import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDedicatedHostGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host_group#name DataAzurermDedicatedHostGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host_group#resource_group_name DataAzurermDedicatedHostGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host_group#timeouts DataAzurermDedicatedHostGroup#timeouts}
    */
    readonly timeouts?: DataAzurermDedicatedHostGroupTimeouts;
}
export interface DataAzurermDedicatedHostGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host_group#read DataAzurermDedicatedHostGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDedicatedHostGroupTimeoutsToTerraform(struct?: DataAzurermDedicatedHostGroupTimeoutsOutputReference | DataAzurermDedicatedHostGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDedicatedHostGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDedicatedHostGroupTimeouts | undefined;
    set internalValue(value: DataAzurermDedicatedHostGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host_group azurerm_dedicated_host_group}
*/
export declare class DataAzurermDedicatedHostGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dedicated_host_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host_group azurerm_dedicated_host_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDedicatedHostGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDedicatedHostGroupConfig);
    get automaticPlacementEnabled(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformFaultDomainCount(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermDedicatedHostGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDedicatedHostGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDedicatedHostGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
