import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermIpGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/ip_group#name DataAzurermIpGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/ip_group#resource_group_name DataAzurermIpGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/ip_group#timeouts DataAzurermIpGroup#timeouts}
    */
    readonly timeouts?: DataAzurermIpGroupTimeouts;
}
export interface DataAzurermIpGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/ip_group#read DataAzurermIpGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermIpGroupTimeoutsToTerraform(struct?: DataAzurermIpGroupTimeoutsOutputReference | DataAzurermIpGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermIpGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermIpGroupTimeouts | undefined;
    set internalValue(value: DataAzurermIpGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/ip_group azurerm_ip_group}
*/
export declare class DataAzurermIpGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_ip_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/ip_group azurerm_ip_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermIpGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermIpGroupConfig);
    get cidrs(): string[];
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermIpGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermIpGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermIpGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
