import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorScheduledQueryRulesLogConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log#name DataAzurermMonitorScheduledQueryRulesLog#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log#resource_group_name DataAzurermMonitorScheduledQueryRulesLog#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log#timeouts DataAzurermMonitorScheduledQueryRulesLog#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorScheduledQueryRulesLogTimeouts;
}
export interface DataAzurermMonitorScheduledQueryRulesLogCriteriaDimension {
}
export declare function dataAzurermMonitorScheduledQueryRulesLogCriteriaDimensionToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesLogCriteriaDimension): any;
export declare class DataAzurermMonitorScheduledQueryRulesLogCriteriaDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesLogCriteriaDimension | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesLogCriteriaDimension | undefined);
    get name(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataAzurermMonitorScheduledQueryRulesLogCriteriaDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorScheduledQueryRulesLogCriteriaDimensionOutputReference;
}
export interface DataAzurermMonitorScheduledQueryRulesLogCriteria {
}
export declare function dataAzurermMonitorScheduledQueryRulesLogCriteriaToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesLogCriteria): any;
export declare class DataAzurermMonitorScheduledQueryRulesLogCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesLogCriteria | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesLogCriteria | undefined);
    private _dimension;
    get dimension(): DataAzurermMonitorScheduledQueryRulesLogCriteriaDimensionList;
    get metricName(): string;
}
export declare class DataAzurermMonitorScheduledQueryRulesLogCriteriaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorScheduledQueryRulesLogCriteriaOutputReference;
}
export interface DataAzurermMonitorScheduledQueryRulesLogTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log#read DataAzurermMonitorScheduledQueryRulesLog#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorScheduledQueryRulesLogTimeoutsToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesLogTimeoutsOutputReference | DataAzurermMonitorScheduledQueryRulesLogTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorScheduledQueryRulesLogTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesLogTimeouts | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesLogTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log azurerm_monitor_scheduled_query_rules_log}
*/
export declare class DataAzurermMonitorScheduledQueryRulesLog extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_monitor_scheduled_query_rules_log";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_log azurerm_monitor_scheduled_query_rules_log} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorScheduledQueryRulesLogConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorScheduledQueryRulesLogConfig);
    get authorizedResourceIds(): string[];
    private _criteria;
    get criteria(): DataAzurermMonitorScheduledQueryRulesLogCriteriaList;
    get dataSourceId(): string;
    get description(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermMonitorScheduledQueryRulesLogTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorScheduledQueryRulesLogTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMonitorScheduledQueryRulesLogTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
