import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMssqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database#name DataAzurermMssqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database#server_id DataAzurermMssqlDatabase#server_id}
    */
    readonly serverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database#timeouts DataAzurermMssqlDatabase#timeouts}
    */
    readonly timeouts?: DataAzurermMssqlDatabaseTimeouts;
}
export interface DataAzurermMssqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database#read DataAzurermMssqlDatabase#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMssqlDatabaseTimeoutsToTerraform(struct?: DataAzurermMssqlDatabaseTimeoutsOutputReference | DataAzurermMssqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMssqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMssqlDatabaseTimeouts | undefined;
    set internalValue(value: DataAzurermMssqlDatabaseTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database azurerm_mssql_database}
*/
export declare class DataAzurermMssqlDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mssql_database";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_database azurerm_mssql_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMssqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlDatabaseConfig);
    get collation(): string;
    get elasticPoolId(): string;
    get id(): string;
    get licenseType(): string;
    get maxSizeGb(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get readReplicaCount(): number;
    get readScale(): cdktf.IResolvable;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    get skuName(): string;
    get storageAccountType(): string;
    tags(key: string): string | cdktf.IResolvable;
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermMssqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMssqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMssqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
