import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageAccountSasConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#connection_string DataAzurermStorageAccountSas#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#expiry DataAzurermStorageAccountSas#expiry}
    */
    readonly expiry: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#https_only DataAzurermStorageAccountSas#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#ip_addresses DataAzurermStorageAccountSas#ip_addresses}
    */
    readonly ipAddresses?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#signed_version DataAzurermStorageAccountSas#signed_version}
    */
    readonly signedVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#start DataAzurermStorageAccountSas#start}
    */
    readonly start: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#permissions DataAzurermStorageAccountSas#permissions}
    */
    readonly permissions: DataAzurermStorageAccountSasPermissions;
    /**
    * resource_types block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#resource_types DataAzurermStorageAccountSas#resource_types}
    */
    readonly resourceTypes: DataAzurermStorageAccountSasResourceTypes;
    /**
    * services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#services DataAzurermStorageAccountSas#services}
    */
    readonly services: DataAzurermStorageAccountSasServices;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#timeouts DataAzurermStorageAccountSas#timeouts}
    */
    readonly timeouts?: DataAzurermStorageAccountSasTimeouts;
}
export interface DataAzurermStorageAccountSasPermissions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#add DataAzurermStorageAccountSas#add}
    */
    readonly add: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#create DataAzurermStorageAccountSas#create}
    */
    readonly create: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#delete DataAzurermStorageAccountSas#delete}
    */
    readonly delete: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#list DataAzurermStorageAccountSas#list}
    */
    readonly list: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#process DataAzurermStorageAccountSas#process}
    */
    readonly process: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#read DataAzurermStorageAccountSas#read}
    */
    readonly read: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#update DataAzurermStorageAccountSas#update}
    */
    readonly update: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#write DataAzurermStorageAccountSas#write}
    */
    readonly write: boolean | cdktf.IResolvable;
}
export declare function dataAzurermStorageAccountSasPermissionsToTerraform(struct?: DataAzurermStorageAccountSasPermissionsOutputReference | DataAzurermStorageAccountSasPermissions): any;
export declare class DataAzurermStorageAccountSasPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageAccountSasPermissions | undefined;
    set internalValue(value: DataAzurermStorageAccountSasPermissions | undefined);
    private _add?;
    get add(): boolean | cdktf.IResolvable;
    set add(value: boolean | cdktf.IResolvable);
    get addInput(): boolean | cdktf.IResolvable | undefined;
    private _create?;
    get create(): boolean | cdktf.IResolvable;
    set create(value: boolean | cdktf.IResolvable);
    get createInput(): boolean | cdktf.IResolvable | undefined;
    private _delete?;
    get delete(): boolean | cdktf.IResolvable;
    set delete(value: boolean | cdktf.IResolvable);
    get deleteInput(): boolean | cdktf.IResolvable | undefined;
    private _list?;
    get list(): boolean | cdktf.IResolvable;
    set list(value: boolean | cdktf.IResolvable);
    get listInput(): boolean | cdktf.IResolvable | undefined;
    private _process?;
    get process(): boolean | cdktf.IResolvable;
    set process(value: boolean | cdktf.IResolvable);
    get processInput(): boolean | cdktf.IResolvable | undefined;
    private _read?;
    get read(): boolean | cdktf.IResolvable;
    set read(value: boolean | cdktf.IResolvable);
    get readInput(): boolean | cdktf.IResolvable | undefined;
    private _update?;
    get update(): boolean | cdktf.IResolvable;
    set update(value: boolean | cdktf.IResolvable);
    get updateInput(): boolean | cdktf.IResolvable | undefined;
    private _write?;
    get write(): boolean | cdktf.IResolvable;
    set write(value: boolean | cdktf.IResolvable);
    get writeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataAzurermStorageAccountSasResourceTypes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#container DataAzurermStorageAccountSas#container}
    */
    readonly container: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#object DataAzurermStorageAccountSas#object}
    */
    readonly object: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#service DataAzurermStorageAccountSas#service}
    */
    readonly service: boolean | cdktf.IResolvable;
}
export declare function dataAzurermStorageAccountSasResourceTypesToTerraform(struct?: DataAzurermStorageAccountSasResourceTypesOutputReference | DataAzurermStorageAccountSasResourceTypes): any;
export declare class DataAzurermStorageAccountSasResourceTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageAccountSasResourceTypes | undefined;
    set internalValue(value: DataAzurermStorageAccountSasResourceTypes | undefined);
    private _container?;
    get container(): boolean | cdktf.IResolvable;
    set container(value: boolean | cdktf.IResolvable);
    get containerInput(): boolean | cdktf.IResolvable | undefined;
    private _object?;
    get object(): boolean | cdktf.IResolvable;
    set object(value: boolean | cdktf.IResolvable);
    get objectInput(): boolean | cdktf.IResolvable | undefined;
    private _service?;
    get service(): boolean | cdktf.IResolvable;
    set service(value: boolean | cdktf.IResolvable);
    get serviceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataAzurermStorageAccountSasServices {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#blob DataAzurermStorageAccountSas#blob}
    */
    readonly blob: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#file DataAzurermStorageAccountSas#file}
    */
    readonly file: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#queue DataAzurermStorageAccountSas#queue}
    */
    readonly queue: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#table DataAzurermStorageAccountSas#table}
    */
    readonly table: boolean | cdktf.IResolvable;
}
export declare function dataAzurermStorageAccountSasServicesToTerraform(struct?: DataAzurermStorageAccountSasServicesOutputReference | DataAzurermStorageAccountSasServices): any;
export declare class DataAzurermStorageAccountSasServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageAccountSasServices | undefined;
    set internalValue(value: DataAzurermStorageAccountSasServices | undefined);
    private _blob?;
    get blob(): boolean | cdktf.IResolvable;
    set blob(value: boolean | cdktf.IResolvable);
    get blobInput(): boolean | cdktf.IResolvable | undefined;
    private _file?;
    get file(): boolean | cdktf.IResolvable;
    set file(value: boolean | cdktf.IResolvable);
    get fileInput(): boolean | cdktf.IResolvable | undefined;
    private _queue?;
    get queue(): boolean | cdktf.IResolvable;
    set queue(value: boolean | cdktf.IResolvable);
    get queueInput(): boolean | cdktf.IResolvable | undefined;
    private _table?;
    get table(): boolean | cdktf.IResolvable;
    set table(value: boolean | cdktf.IResolvable);
    get tableInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataAzurermStorageAccountSasTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas#read DataAzurermStorageAccountSas#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageAccountSasTimeoutsToTerraform(struct?: DataAzurermStorageAccountSasTimeoutsOutputReference | DataAzurermStorageAccountSasTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageAccountSasTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageAccountSasTimeouts | undefined;
    set internalValue(value: DataAzurermStorageAccountSasTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas azurerm_storage_account_sas}
*/
export declare class DataAzurermStorageAccountSas extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_account_sas";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas azurerm_storage_account_sas} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageAccountSasConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageAccountSasConfig);
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    private _expiry?;
    get expiry(): string;
    set expiry(value: string);
    get expiryInput(): string | undefined;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _ipAddresses?;
    get ipAddresses(): string;
    set ipAddresses(value: string);
    resetIpAddresses(): void;
    get ipAddressesInput(): string | undefined;
    get sas(): string;
    private _signedVersion?;
    get signedVersion(): string;
    set signedVersion(value: string);
    resetSignedVersion(): void;
    get signedVersionInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
    private _permissions;
    get permissions(): DataAzurermStorageAccountSasPermissionsOutputReference;
    putPermissions(value: DataAzurermStorageAccountSasPermissions): void;
    get permissionsInput(): DataAzurermStorageAccountSasPermissions | undefined;
    private _resourceTypes;
    get resourceTypes(): DataAzurermStorageAccountSasResourceTypesOutputReference;
    putResourceTypes(value: DataAzurermStorageAccountSasResourceTypes): void;
    get resourceTypesInput(): DataAzurermStorageAccountSasResourceTypes | undefined;
    private _services;
    get services(): DataAzurermStorageAccountSasServicesOutputReference;
    putServices(value: DataAzurermStorageAccountSasServices): void;
    get servicesInput(): DataAzurermStorageAccountSasServices | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageAccountSasTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageAccountSasTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageAccountSasTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
