import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppActionCustomConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom#body LogicAppActionCustom#body}
    */
    readonly body: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom#logic_app_id LogicAppActionCustom#logic_app_id}
    */
    readonly logicAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom#name LogicAppActionCustom#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom#timeouts LogicAppActionCustom#timeouts}
    */
    readonly timeouts?: LogicAppActionCustomTimeouts;
}
export interface LogicAppActionCustomTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom#create LogicAppActionCustom#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom#delete LogicAppActionCustom#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom#read LogicAppActionCustom#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom#update LogicAppActionCustom#update}
    */
    readonly update?: string;
}
export declare function logicAppActionCustomTimeoutsToTerraform(struct?: LogicAppActionCustomTimeoutsOutputReference | LogicAppActionCustomTimeouts | cdktf.IResolvable): any;
export declare class LogicAppActionCustomTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppActionCustomTimeouts | undefined;
    set internalValue(value: LogicAppActionCustomTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom azurerm_logic_app_action_custom}
*/
export declare class LogicAppActionCustom extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_action_custom";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_action_custom azurerm_logic_app_action_custom} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppActionCustomConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppActionCustomConfig);
    private _body?;
    get body(): string;
    set body(value: string);
    get bodyInput(): string | undefined;
    get id(): string;
    private _logicAppId?;
    get logicAppId(): string;
    set logicAppId(value: string);
    get logicAppIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): LogicAppActionCustomTimeoutsOutputReference;
    putTimeouts(value: LogicAppActionCustomTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LogicAppActionCustomTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
