import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_name}
    */
    readonly baselineName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#database_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#rule_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#rule_id}
    */
    readonly ruleId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#server_vulnerability_assessment_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#server_vulnerability_assessment_id}
    */
    readonly serverVulnerabilityAssessmentId: string;
    /**
    * baseline_result block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_result}
    */
    readonly baselineResult: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#timeouts MssqlDatabaseVulnerabilityAssessmentRuleBaseline#timeouts}
    */
    readonly timeouts?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts;
}
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#result}
    */
    readonly result: string[];
}
export declare function mssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultToTerraform(struct?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult | cdktf.IResolvable): any;
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#create MssqlDatabaseVulnerabilityAssessmentRuleBaseline#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#delete MssqlDatabaseVulnerabilityAssessmentRuleBaseline#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#read MssqlDatabaseVulnerabilityAssessmentRuleBaseline#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#update MssqlDatabaseVulnerabilityAssessmentRuleBaseline#update}
    */
    readonly update?: string;
}
export declare function mssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsToTerraform(struct?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference | MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | cdktf.IResolvable): any;
export declare class MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | undefined;
    set internalValue(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline azurerm_mssql_database_vulnerability_assessment_rule_baseline}
*/
export declare class MssqlDatabaseVulnerabilityAssessmentRuleBaseline extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_database_vulnerability_assessment_rule_baseline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline azurerm_mssql_database_vulnerability_assessment_rule_baseline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig
    */
    constructor(scope: Construct, id: string, config: MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig);
    private _baselineName?;
    get baselineName(): string;
    set baselineName(value: string);
    resetBaselineName(): void;
    get baselineNameInput(): string | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    get id(): string;
    private _ruleId?;
    get ruleId(): string;
    set ruleId(value: string);
    get ruleIdInput(): string | undefined;
    private _serverVulnerabilityAssessmentId?;
    get serverVulnerabilityAssessmentId(): string;
    set serverVulnerabilityAssessmentId(value: string);
    get serverVulnerabilityAssessmentIdInput(): string | undefined;
    private _baselineResult?;
    get baselineResult(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | cdktf.IResolvable;
    set baselineResult(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | cdktf.IResolvable);
    get baselineResultInput(): cdktf.IResolvable | MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | undefined;
    private _timeouts;
    get timeouts(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference;
    putTimeouts(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
