import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#enabled_protocol StorageShare#enabled_protocol}
    */
    readonly enabledProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#metadata StorageShare#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#name StorageShare#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#quota StorageShare#quota}
    */
    readonly quota?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#storage_account_name StorageShare#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * acl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#acl StorageShare#acl}
    */
    readonly acl?: StorageShareAcl[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#timeouts StorageShare#timeouts}
    */
    readonly timeouts?: StorageShareTimeouts;
}
export interface StorageShareAclAccessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#expiry StorageShare#expiry}
    */
    readonly expiry?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#permissions StorageShare#permissions}
    */
    readonly permissions: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#start StorageShare#start}
    */
    readonly start?: string;
}
export declare function storageShareAclAccessPolicyToTerraform(struct?: StorageShareAclAccessPolicy | cdktf.IResolvable): any;
export interface StorageShareAcl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#id StorageShare#id}
    */
    readonly id: string;
    /**
    * access_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#access_policy StorageShare#access_policy}
    */
    readonly accessPolicy?: StorageShareAclAccessPolicy[] | cdktf.IResolvable;
}
export declare function storageShareAclToTerraform(struct?: StorageShareAcl | cdktf.IResolvable): any;
export interface StorageShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#create StorageShare#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#delete StorageShare#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#read StorageShare#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#update StorageShare#update}
    */
    readonly update?: string;
}
export declare function storageShareTimeoutsToTerraform(struct?: StorageShareTimeoutsOutputReference | StorageShareTimeouts | cdktf.IResolvable): any;
export declare class StorageShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageShareTimeouts | undefined;
    set internalValue(value: StorageShareTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share azurerm_storage_share}
*/
export declare class StorageShare extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_share";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share azurerm_storage_share} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageShareConfig
    */
    constructor(scope: Construct, id: string, config: StorageShareConfig);
    private _enabledProtocol?;
    get enabledProtocol(): string;
    set enabledProtocol(value: string);
    resetEnabledProtocol(): void;
    get enabledProtocolInput(): string | undefined;
    get id(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _quota?;
    get quota(): number;
    set quota(value: number);
    resetQuota(): void;
    get quotaInput(): number | undefined;
    get resourceManagerId(): string;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    get url(): string;
    private _acl?;
    get acl(): StorageShareAcl[] | cdktf.IResolvable;
    set acl(value: StorageShareAcl[] | cdktf.IResolvable);
    resetAcl(): void;
    get aclInput(): cdktf.IResolvable | StorageShareAcl[] | undefined;
    private _timeouts;
    get timeouts(): StorageShareTimeoutsOutputReference;
    putTimeouts(value: StorageShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
