import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseWorkspaceKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#active SynapseWorkspaceKey#active}
    */
    readonly active: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#cusomter_managed_key_name SynapseWorkspaceKey#cusomter_managed_key_name}
    */
    readonly cusomterManagedKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#customer_managed_key_name SynapseWorkspaceKey#customer_managed_key_name}
    */
    readonly customerManagedKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#customer_managed_key_versionless_id SynapseWorkspaceKey#customer_managed_key_versionless_id}
    */
    readonly customerManagedKeyVersionlessId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#synapse_workspace_id SynapseWorkspaceKey#synapse_workspace_id}
    */
    readonly synapseWorkspaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#timeouts SynapseWorkspaceKey#timeouts}
    */
    readonly timeouts?: SynapseWorkspaceKeyTimeouts;
}
export interface SynapseWorkspaceKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#create SynapseWorkspaceKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#delete SynapseWorkspaceKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#read SynapseWorkspaceKey#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key#update SynapseWorkspaceKey#update}
    */
    readonly update?: string;
}
export declare function synapseWorkspaceKeyTimeoutsToTerraform(struct?: SynapseWorkspaceKeyTimeoutsOutputReference | SynapseWorkspaceKeyTimeouts | cdktf.IResolvable): any;
export declare class SynapseWorkspaceKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceKeyTimeouts | undefined;
    set internalValue(value: SynapseWorkspaceKeyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key azurerm_synapse_workspace_key}
*/
export declare class SynapseWorkspaceKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_workspace_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_key azurerm_synapse_workspace_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseWorkspaceKeyConfig
    */
    constructor(scope: Construct, id: string, config: SynapseWorkspaceKeyConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _cusomterManagedKeyName?;
    get cusomterManagedKeyName(): string;
    set cusomterManagedKeyName(value: string);
    resetCusomterManagedKeyName(): void;
    get cusomterManagedKeyNameInput(): string | undefined;
    private _customerManagedKeyName?;
    get customerManagedKeyName(): string;
    set customerManagedKeyName(value: string);
    resetCustomerManagedKeyName(): void;
    get customerManagedKeyNameInput(): string | undefined;
    private _customerManagedKeyVersionlessId?;
    get customerManagedKeyVersionlessId(): string;
    set customerManagedKeyVersionlessId(value: string);
    resetCustomerManagedKeyVersionlessId(): void;
    get customerManagedKeyVersionlessIdInput(): string | undefined;
    get id(): string;
    private _synapseWorkspaceId?;
    get synapseWorkspaceId(): string;
    set synapseWorkspaceId(value: string);
    get synapseWorkspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SynapseWorkspaceKeyTimeoutsOutputReference;
    putTimeouts(value: SynapseWorkspaceKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SynapseWorkspaceKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
