import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TrafficManagerAzureEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#enabled TrafficManagerAzureEndpoint#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#geo_mappings TrafficManagerAzureEndpoint#geo_mappings}
    */
    readonly geoMappings?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#name TrafficManagerAzureEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#priority TrafficManagerAzureEndpoint#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#profile_id TrafficManagerAzureEndpoint#profile_id}
    */
    readonly profileId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#target_resource_id TrafficManagerAzureEndpoint#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#weight TrafficManagerAzureEndpoint#weight}
    */
    readonly weight: number;
    /**
    * custom_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#custom_header TrafficManagerAzureEndpoint#custom_header}
    */
    readonly customHeader?: TrafficManagerAzureEndpointCustomHeader[] | cdktf.IResolvable;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#subnet TrafficManagerAzureEndpoint#subnet}
    */
    readonly subnet?: TrafficManagerAzureEndpointSubnet[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#timeouts TrafficManagerAzureEndpoint#timeouts}
    */
    readonly timeouts?: TrafficManagerAzureEndpointTimeouts;
}
export interface TrafficManagerAzureEndpointCustomHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#name TrafficManagerAzureEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#value TrafficManagerAzureEndpoint#value}
    */
    readonly value: string;
}
export declare function trafficManagerAzureEndpointCustomHeaderToTerraform(struct?: TrafficManagerAzureEndpointCustomHeader | cdktf.IResolvable): any;
export interface TrafficManagerAzureEndpointSubnet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#first TrafficManagerAzureEndpoint#first}
    */
    readonly first: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#last TrafficManagerAzureEndpoint#last}
    */
    readonly last?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#scope TrafficManagerAzureEndpoint#scope}
    */
    readonly scope?: number;
}
export declare function trafficManagerAzureEndpointSubnetToTerraform(struct?: TrafficManagerAzureEndpointSubnet | cdktf.IResolvable): any;
export interface TrafficManagerAzureEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#create TrafficManagerAzureEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#delete TrafficManagerAzureEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#read TrafficManagerAzureEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint#update TrafficManagerAzureEndpoint#update}
    */
    readonly update?: string;
}
export declare function trafficManagerAzureEndpointTimeoutsToTerraform(struct?: TrafficManagerAzureEndpointTimeoutsOutputReference | TrafficManagerAzureEndpointTimeouts | cdktf.IResolvable): any;
export declare class TrafficManagerAzureEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TrafficManagerAzureEndpointTimeouts | undefined;
    set internalValue(value: TrafficManagerAzureEndpointTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint azurerm_traffic_manager_azure_endpoint}
*/
export declare class TrafficManagerAzureEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_traffic_manager_azure_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_azure_endpoint azurerm_traffic_manager_azure_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TrafficManagerAzureEndpointConfig
    */
    constructor(scope: Construct, id: string, config: TrafficManagerAzureEndpointConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _geoMappings?;
    get geoMappings(): string[];
    set geoMappings(value: string[]);
    resetGeoMappings(): void;
    get geoMappingsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _profileId?;
    get profileId(): string;
    set profileId(value: string);
    get profileIdInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _customHeader?;
    get customHeader(): TrafficManagerAzureEndpointCustomHeader[] | cdktf.IResolvable;
    set customHeader(value: TrafficManagerAzureEndpointCustomHeader[] | cdktf.IResolvable);
    resetCustomHeader(): void;
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerAzureEndpointCustomHeader[] | undefined;
    private _subnet?;
    get subnet(): TrafficManagerAzureEndpointSubnet[] | cdktf.IResolvable;
    set subnet(value: TrafficManagerAzureEndpointSubnet[] | cdktf.IResolvable);
    resetSubnet(): void;
    get subnetInput(): cdktf.IResolvable | TrafficManagerAzureEndpointSubnet[] | undefined;
    private _timeouts;
    get timeouts(): TrafficManagerAzureEndpointTimeoutsOutputReference;
    putTimeouts(value: TrafficManagerAzureEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): TrafficManagerAzureEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
