import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualHubConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#hub_to_vitual_network_traffic_allowed VirtualHubConnection#hub_to_vitual_network_traffic_allowed}
    */
    readonly hubToVitualNetworkTrafficAllowed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#internet_security_enabled VirtualHubConnection#internet_security_enabled}
    */
    readonly internetSecurityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#name VirtualHubConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#remote_virtual_network_id VirtualHubConnection#remote_virtual_network_id}
    */
    readonly remoteVirtualNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#virtual_hub_id VirtualHubConnection#virtual_hub_id}
    */
    readonly virtualHubId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#vitual_network_to_hub_gateways_traffic_allowed VirtualHubConnection#vitual_network_to_hub_gateways_traffic_allowed}
    */
    readonly vitualNetworkToHubGatewaysTrafficAllowed?: boolean | cdktf.IResolvable;
    /**
    * routing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#routing VirtualHubConnection#routing}
    */
    readonly routing?: VirtualHubConnectionRouting;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#timeouts VirtualHubConnection#timeouts}
    */
    readonly timeouts?: VirtualHubConnectionTimeouts;
}
export interface VirtualHubConnectionRoutingPropagatedRouteTable {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#labels VirtualHubConnection#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#route_table_ids VirtualHubConnection#route_table_ids}
    */
    readonly routeTableIds?: string[];
}
export declare function virtualHubConnectionRoutingPropagatedRouteTableToTerraform(struct?: VirtualHubConnectionRoutingPropagatedRouteTableOutputReference | VirtualHubConnectionRoutingPropagatedRouteTable): any;
export declare class VirtualHubConnectionRoutingPropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubConnectionRoutingPropagatedRouteTable | undefined;
    set internalValue(value: VirtualHubConnectionRoutingPropagatedRouteTable | undefined);
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _routeTableIds?;
    get routeTableIds(): string[];
    set routeTableIds(value: string[]);
    resetRouteTableIds(): void;
    get routeTableIdsInput(): string[] | undefined;
}
export interface VirtualHubConnectionRoutingStaticVnetRoute {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#address_prefixes VirtualHubConnection#address_prefixes}
    */
    readonly addressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#name VirtualHubConnection#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#next_hop_ip_address VirtualHubConnection#next_hop_ip_address}
    */
    readonly nextHopIpAddress?: string;
}
export declare function virtualHubConnectionRoutingStaticVnetRouteToTerraform(struct?: VirtualHubConnectionRoutingStaticVnetRoute | cdktf.IResolvable): any;
export interface VirtualHubConnectionRouting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#associated_route_table_id VirtualHubConnection#associated_route_table_id}
    */
    readonly associatedRouteTableId?: string;
    /**
    * propagated_route_table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#propagated_route_table VirtualHubConnection#propagated_route_table}
    */
    readonly propagatedRouteTable?: VirtualHubConnectionRoutingPropagatedRouteTable;
    /**
    * static_vnet_route block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#static_vnet_route VirtualHubConnection#static_vnet_route}
    */
    readonly staticVnetRoute?: VirtualHubConnectionRoutingStaticVnetRoute[] | cdktf.IResolvable;
}
export declare function virtualHubConnectionRoutingToTerraform(struct?: VirtualHubConnectionRoutingOutputReference | VirtualHubConnectionRouting): any;
export declare class VirtualHubConnectionRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubConnectionRouting | undefined;
    set internalValue(value: VirtualHubConnectionRouting | undefined);
    private _associatedRouteTableId?;
    get associatedRouteTableId(): string;
    set associatedRouteTableId(value: string);
    resetAssociatedRouteTableId(): void;
    get associatedRouteTableIdInput(): string | undefined;
    private _propagatedRouteTable;
    get propagatedRouteTable(): VirtualHubConnectionRoutingPropagatedRouteTableOutputReference;
    putPropagatedRouteTable(value: VirtualHubConnectionRoutingPropagatedRouteTable): void;
    resetPropagatedRouteTable(): void;
    get propagatedRouteTableInput(): VirtualHubConnectionRoutingPropagatedRouteTable | undefined;
    private _staticVnetRoute?;
    get staticVnetRoute(): VirtualHubConnectionRoutingStaticVnetRoute[] | cdktf.IResolvable;
    set staticVnetRoute(value: VirtualHubConnectionRoutingStaticVnetRoute[] | cdktf.IResolvable);
    resetStaticVnetRoute(): void;
    get staticVnetRouteInput(): cdktf.IResolvable | VirtualHubConnectionRoutingStaticVnetRoute[] | undefined;
}
export interface VirtualHubConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#create VirtualHubConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#delete VirtualHubConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#read VirtualHubConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection#update VirtualHubConnection#update}
    */
    readonly update?: string;
}
export declare function virtualHubConnectionTimeoutsToTerraform(struct?: VirtualHubConnectionTimeoutsOutputReference | VirtualHubConnectionTimeouts | cdktf.IResolvable): any;
export declare class VirtualHubConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubConnectionTimeouts | undefined;
    set internalValue(value: VirtualHubConnectionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection azurerm_virtual_hub_connection}
*/
export declare class VirtualHubConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_hub_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection azurerm_virtual_hub_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualHubConnectionConfig
    */
    constructor(scope: Construct, id: string, config: VirtualHubConnectionConfig);
    private _hubToVitualNetworkTrafficAllowed?;
    get hubToVitualNetworkTrafficAllowed(): boolean | cdktf.IResolvable;
    set hubToVitualNetworkTrafficAllowed(value: boolean | cdktf.IResolvable);
    resetHubToVitualNetworkTrafficAllowed(): void;
    get hubToVitualNetworkTrafficAllowedInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _internetSecurityEnabled?;
    get internetSecurityEnabled(): boolean | cdktf.IResolvable;
    set internetSecurityEnabled(value: boolean | cdktf.IResolvable);
    resetInternetSecurityEnabled(): void;
    get internetSecurityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _remoteVirtualNetworkId?;
    get remoteVirtualNetworkId(): string;
    set remoteVirtualNetworkId(value: string);
    get remoteVirtualNetworkIdInput(): string | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
    private _vitualNetworkToHubGatewaysTrafficAllowed?;
    get vitualNetworkToHubGatewaysTrafficAllowed(): boolean | cdktf.IResolvable;
    set vitualNetworkToHubGatewaysTrafficAllowed(value: boolean | cdktf.IResolvable);
    resetVitualNetworkToHubGatewaysTrafficAllowed(): void;
    get vitualNetworkToHubGatewaysTrafficAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _routing;
    get routing(): VirtualHubConnectionRoutingOutputReference;
    putRouting(value: VirtualHubConnectionRouting): void;
    resetRouting(): void;
    get routingInput(): VirtualHubConnectionRouting | undefined;
    private _timeouts;
    get timeouts(): VirtualHubConnectionTimeoutsOutputReference;
    putTimeouts(value: VirtualHubConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VirtualHubConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
