"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNetworkGatewayConnection = exports.VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference = exports.virtualNetworkGatewayConnectionTrafficSelectorPolicyToTerraform = exports.VirtualNetworkGatewayConnectionTimeoutsOutputReference = exports.virtualNetworkGatewayConnectionTimeoutsToTerraform = exports.VirtualNetworkGatewayConnectionIpsecPolicyOutputReference = exports.virtualNetworkGatewayConnectionIpsecPolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function virtualNetworkGatewayConnectionIpsecPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        dh_group: cdktf.stringToTerraform(struct.dhGroup),
        ike_encryption: cdktf.stringToTerraform(struct.ikeEncryption),
        ike_integrity: cdktf.stringToTerraform(struct.ikeIntegrity),
        ipsec_encryption: cdktf.stringToTerraform(struct.ipsecEncryption),
        ipsec_integrity: cdktf.stringToTerraform(struct.ipsecIntegrity),
        pfs_group: cdktf.stringToTerraform(struct.pfsGroup),
        sa_datasize: cdktf.numberToTerraform(struct.saDatasize),
        sa_lifetime: cdktf.numberToTerraform(struct.saLifetime),
    };
}
exports.virtualNetworkGatewayConnectionIpsecPolicyToTerraform = virtualNetworkGatewayConnectionIpsecPolicyToTerraform;
class VirtualNetworkGatewayConnectionIpsecPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._dhGroup !== undefined) {
            hasAnyValues = true;
            internalValueResult.dhGroup = this._dhGroup;
        }
        if (this._ikeEncryption !== undefined) {
            hasAnyValues = true;
            internalValueResult.ikeEncryption = this._ikeEncryption;
        }
        if (this._ikeIntegrity !== undefined) {
            hasAnyValues = true;
            internalValueResult.ikeIntegrity = this._ikeIntegrity;
        }
        if (this._ipsecEncryption !== undefined) {
            hasAnyValues = true;
            internalValueResult.ipsecEncryption = this._ipsecEncryption;
        }
        if (this._ipsecIntegrity !== undefined) {
            hasAnyValues = true;
            internalValueResult.ipsecIntegrity = this._ipsecIntegrity;
        }
        if (this._pfsGroup !== undefined) {
            hasAnyValues = true;
            internalValueResult.pfsGroup = this._pfsGroup;
        }
        if (this._saDatasize !== undefined) {
            hasAnyValues = true;
            internalValueResult.saDatasize = this._saDatasize;
        }
        if (this._saLifetime !== undefined) {
            hasAnyValues = true;
            internalValueResult.saLifetime = this._saLifetime;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._dhGroup = undefined;
            this._ikeEncryption = undefined;
            this._ikeIntegrity = undefined;
            this._ipsecEncryption = undefined;
            this._ipsecIntegrity = undefined;
            this._pfsGroup = undefined;
            this._saDatasize = undefined;
            this._saLifetime = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._dhGroup = value.dhGroup;
            this._ikeEncryption = value.ikeEncryption;
            this._ikeIntegrity = value.ikeIntegrity;
            this._ipsecEncryption = value.ipsecEncryption;
            this._ipsecIntegrity = value.ipsecIntegrity;
            this._pfsGroup = value.pfsGroup;
            this._saDatasize = value.saDatasize;
            this._saLifetime = value.saLifetime;
        }
    }
    get dhGroup() {
        return this.getStringAttribute('dh_group');
    }
    set dhGroup(value) {
        this._dhGroup = value;
    }
    // Temporarily expose input value. Use with caution.
    get dhGroupInput() {
        return this._dhGroup;
    }
    get ikeEncryption() {
        return this.getStringAttribute('ike_encryption');
    }
    set ikeEncryption(value) {
        this._ikeEncryption = value;
    }
    // Temporarily expose input value. Use with caution.
    get ikeEncryptionInput() {
        return this._ikeEncryption;
    }
    get ikeIntegrity() {
        return this.getStringAttribute('ike_integrity');
    }
    set ikeIntegrity(value) {
        this._ikeIntegrity = value;
    }
    // Temporarily expose input value. Use with caution.
    get ikeIntegrityInput() {
        return this._ikeIntegrity;
    }
    get ipsecEncryption() {
        return this.getStringAttribute('ipsec_encryption');
    }
    set ipsecEncryption(value) {
        this._ipsecEncryption = value;
    }
    // Temporarily expose input value. Use with caution.
    get ipsecEncryptionInput() {
        return this._ipsecEncryption;
    }
    get ipsecIntegrity() {
        return this.getStringAttribute('ipsec_integrity');
    }
    set ipsecIntegrity(value) {
        this._ipsecIntegrity = value;
    }
    // Temporarily expose input value. Use with caution.
    get ipsecIntegrityInput() {
        return this._ipsecIntegrity;
    }
    get pfsGroup() {
        return this.getStringAttribute('pfs_group');
    }
    set pfsGroup(value) {
        this._pfsGroup = value;
    }
    // Temporarily expose input value. Use with caution.
    get pfsGroupInput() {
        return this._pfsGroup;
    }
    get saDatasize() {
        return this.getNumberAttribute('sa_datasize');
    }
    set saDatasize(value) {
        this._saDatasize = value;
    }
    resetSaDatasize() {
        this._saDatasize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saDatasizeInput() {
        return this._saDatasize;
    }
    get saLifetime() {
        return this.getNumberAttribute('sa_lifetime');
    }
    set saLifetime(value) {
        this._saLifetime = value;
    }
    resetSaLifetime() {
        this._saLifetime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saLifetimeInput() {
        return this._saLifetime;
    }
}
exports.VirtualNetworkGatewayConnectionIpsecPolicyOutputReference = VirtualNetworkGatewayConnectionIpsecPolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
VirtualNetworkGatewayConnectionIpsecPolicyOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.VirtualNetworkGatewayConnectionIpsecPolicyOutputReference", version: "0.6.8" };
function virtualNetworkGatewayConnectionTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.virtualNetworkGatewayConnectionTimeoutsToTerraform = virtualNetworkGatewayConnectionTimeoutsToTerraform;
class VirtualNetworkGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.VirtualNetworkGatewayConnectionTimeoutsOutputReference = VirtualNetworkGatewayConnectionTimeoutsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
VirtualNetworkGatewayConnectionTimeoutsOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.VirtualNetworkGatewayConnectionTimeoutsOutputReference", version: "0.6.8" };
function virtualNetworkGatewayConnectionTrafficSelectorPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        local_address_cidrs: cdktf.listMapper(cdktf.stringToTerraform)(struct.localAddressCidrs),
        remote_address_cidrs: cdktf.listMapper(cdktf.stringToTerraform)(struct.remoteAddressCidrs),
    };
}
exports.virtualNetworkGatewayConnectionTrafficSelectorPolicyToTerraform = virtualNetworkGatewayConnectionTrafficSelectorPolicyToTerraform;
class VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._localAddressCidrs !== undefined) {
            hasAnyValues = true;
            internalValueResult.localAddressCidrs = this._localAddressCidrs;
        }
        if (this._remoteAddressCidrs !== undefined) {
            hasAnyValues = true;
            internalValueResult.remoteAddressCidrs = this._remoteAddressCidrs;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._localAddressCidrs = undefined;
            this._remoteAddressCidrs = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._localAddressCidrs = value.localAddressCidrs;
            this._remoteAddressCidrs = value.remoteAddressCidrs;
        }
    }
    get localAddressCidrs() {
        return this.getListAttribute('local_address_cidrs');
    }
    set localAddressCidrs(value) {
        this._localAddressCidrs = value;
    }
    // Temporarily expose input value. Use with caution.
    get localAddressCidrsInput() {
        return this._localAddressCidrs;
    }
    get remoteAddressCidrs() {
        return this.getListAttribute('remote_address_cidrs');
    }
    set remoteAddressCidrs(value) {
        this._remoteAddressCidrs = value;
    }
    // Temporarily expose input value. Use with caution.
    get remoteAddressCidrsInput() {
        return this._remoteAddressCidrs;
    }
}
exports.VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference = VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference;
_c = JSII_RTTI_SYMBOL_1;
VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference", version: "0.6.8" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection azurerm_virtual_network_gateway_connection}
*/
class VirtualNetworkGatewayConnection extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection azurerm_virtual_network_gateway_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualNetworkGatewayConnectionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_virtual_network_gateway_connection',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '2.99.0',
                providerVersionConstraint: '~> 2.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // ipsec_policy - computed: false, optional: true, required: false
        this._ipsecPolicy = new VirtualNetworkGatewayConnectionIpsecPolicyOutputReference(this, "ipsec_policy");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new VirtualNetworkGatewayConnectionTimeoutsOutputReference(this, "timeouts");
        // traffic_selector_policy - computed: false, optional: true, required: false
        this._trafficSelectorPolicy = new VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference(this, "traffic_selector_policy");
        this._authorizationKey = config.authorizationKey;
        this._connectionMode = config.connectionMode;
        this._connectionProtocol = config.connectionProtocol;
        this._dpdTimeoutSeconds = config.dpdTimeoutSeconds;
        this._enableBgp = config.enableBgp;
        this._expressRouteCircuitId = config.expressRouteCircuitId;
        this._expressRouteGatewayBypass = config.expressRouteGatewayBypass;
        this._localAzureIpAddressEnabled = config.localAzureIpAddressEnabled;
        this._localNetworkGatewayId = config.localNetworkGatewayId;
        this._location = config.location;
        this._name = config.name;
        this._peerVirtualNetworkGatewayId = config.peerVirtualNetworkGatewayId;
        this._resourceGroupName = config.resourceGroupName;
        this._routingWeight = config.routingWeight;
        this._sharedKey = config.sharedKey;
        this._tags = config.tags;
        this._type = config.type;
        this._usePolicyBasedTrafficSelectors = config.usePolicyBasedTrafficSelectors;
        this._virtualNetworkGatewayId = config.virtualNetworkGatewayId;
        this._ipsecPolicy.internalValue = config.ipsecPolicy;
        this._timeouts.internalValue = config.timeouts;
        this._trafficSelectorPolicy.internalValue = config.trafficSelectorPolicy;
    }
    get authorizationKey() {
        return this.getStringAttribute('authorization_key');
    }
    set authorizationKey(value) {
        this._authorizationKey = value;
    }
    resetAuthorizationKey() {
        this._authorizationKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorizationKeyInput() {
        return this._authorizationKey;
    }
    get connectionMode() {
        return this.getStringAttribute('connection_mode');
    }
    set connectionMode(value) {
        this._connectionMode = value;
    }
    resetConnectionMode() {
        this._connectionMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get connectionModeInput() {
        return this._connectionMode;
    }
    get connectionProtocol() {
        return this.getStringAttribute('connection_protocol');
    }
    set connectionProtocol(value) {
        this._connectionProtocol = value;
    }
    resetConnectionProtocol() {
        this._connectionProtocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get connectionProtocolInput() {
        return this._connectionProtocol;
    }
    get dpdTimeoutSeconds() {
        return this.getNumberAttribute('dpd_timeout_seconds');
    }
    set dpdTimeoutSeconds(value) {
        this._dpdTimeoutSeconds = value;
    }
    resetDpdTimeoutSeconds() {
        this._dpdTimeoutSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpdTimeoutSecondsInput() {
        return this._dpdTimeoutSeconds;
    }
    get enableBgp() {
        return this.getBooleanAttribute('enable_bgp');
    }
    set enableBgp(value) {
        this._enableBgp = value;
    }
    resetEnableBgp() {
        this._enableBgp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableBgpInput() {
        return this._enableBgp;
    }
    get expressRouteCircuitId() {
        return this.getStringAttribute('express_route_circuit_id');
    }
    set expressRouteCircuitId(value) {
        this._expressRouteCircuitId = value;
    }
    resetExpressRouteCircuitId() {
        this._expressRouteCircuitId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expressRouteCircuitIdInput() {
        return this._expressRouteCircuitId;
    }
    get expressRouteGatewayBypass() {
        return this.getBooleanAttribute('express_route_gateway_bypass');
    }
    set expressRouteGatewayBypass(value) {
        this._expressRouteGatewayBypass = value;
    }
    resetExpressRouteGatewayBypass() {
        this._expressRouteGatewayBypass = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expressRouteGatewayBypassInput() {
        return this._expressRouteGatewayBypass;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get localAzureIpAddressEnabled() {
        return this.getBooleanAttribute('local_azure_ip_address_enabled');
    }
    set localAzureIpAddressEnabled(value) {
        this._localAzureIpAddressEnabled = value;
    }
    resetLocalAzureIpAddressEnabled() {
        this._localAzureIpAddressEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localAzureIpAddressEnabledInput() {
        return this._localAzureIpAddressEnabled;
    }
    get localNetworkGatewayId() {
        return this.getStringAttribute('local_network_gateway_id');
    }
    set localNetworkGatewayId(value) {
        this._localNetworkGatewayId = value;
    }
    resetLocalNetworkGatewayId() {
        this._localNetworkGatewayId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localNetworkGatewayIdInput() {
        return this._localNetworkGatewayId;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get peerVirtualNetworkGatewayId() {
        return this.getStringAttribute('peer_virtual_network_gateway_id');
    }
    set peerVirtualNetworkGatewayId(value) {
        this._peerVirtualNetworkGatewayId = value;
    }
    resetPeerVirtualNetworkGatewayId() {
        this._peerVirtualNetworkGatewayId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get peerVirtualNetworkGatewayIdInput() {
        return this._peerVirtualNetworkGatewayId;
    }
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    get routingWeight() {
        return this.getNumberAttribute('routing_weight');
    }
    set routingWeight(value) {
        this._routingWeight = value;
    }
    resetRoutingWeight() {
        this._routingWeight = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get routingWeightInput() {
        return this._routingWeight;
    }
    get sharedKey() {
        return this.getStringAttribute('shared_key');
    }
    set sharedKey(value) {
        this._sharedKey = value;
    }
    resetSharedKey() {
        this._sharedKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedKeyInput() {
        return this._sharedKey;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get usePolicyBasedTrafficSelectors() {
        return this.getBooleanAttribute('use_policy_based_traffic_selectors');
    }
    set usePolicyBasedTrafficSelectors(value) {
        this._usePolicyBasedTrafficSelectors = value;
    }
    resetUsePolicyBasedTrafficSelectors() {
        this._usePolicyBasedTrafficSelectors = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usePolicyBasedTrafficSelectorsInput() {
        return this._usePolicyBasedTrafficSelectors;
    }
    get virtualNetworkGatewayId() {
        return this.getStringAttribute('virtual_network_gateway_id');
    }
    set virtualNetworkGatewayId(value) {
        this._virtualNetworkGatewayId = value;
    }
    // Temporarily expose input value. Use with caution.
    get virtualNetworkGatewayIdInput() {
        return this._virtualNetworkGatewayId;
    }
    get ipsecPolicy() {
        return this._ipsecPolicy;
    }
    putIpsecPolicy(value) {
        this._ipsecPolicy.internalValue = value;
    }
    resetIpsecPolicy() {
        this._ipsecPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipsecPolicyInput() {
        return this._ipsecPolicy.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get trafficSelectorPolicy() {
        return this._trafficSelectorPolicy;
    }
    putTrafficSelectorPolicy(value) {
        this._trafficSelectorPolicy.internalValue = value;
    }
    resetTrafficSelectorPolicy() {
        this._trafficSelectorPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trafficSelectorPolicyInput() {
        return this._trafficSelectorPolicy.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            authorization_key: cdktf.stringToTerraform(this._authorizationKey),
            connection_mode: cdktf.stringToTerraform(this._connectionMode),
            connection_protocol: cdktf.stringToTerraform(this._connectionProtocol),
            dpd_timeout_seconds: cdktf.numberToTerraform(this._dpdTimeoutSeconds),
            enable_bgp: cdktf.booleanToTerraform(this._enableBgp),
            express_route_circuit_id: cdktf.stringToTerraform(this._expressRouteCircuitId),
            express_route_gateway_bypass: cdktf.booleanToTerraform(this._expressRouteGatewayBypass),
            local_azure_ip_address_enabled: cdktf.booleanToTerraform(this._localAzureIpAddressEnabled),
            local_network_gateway_id: cdktf.stringToTerraform(this._localNetworkGatewayId),
            location: cdktf.stringToTerraform(this._location),
            name: cdktf.stringToTerraform(this._name),
            peer_virtual_network_gateway_id: cdktf.stringToTerraform(this._peerVirtualNetworkGatewayId),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            routing_weight: cdktf.numberToTerraform(this._routingWeight),
            shared_key: cdktf.stringToTerraform(this._sharedKey),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            type: cdktf.stringToTerraform(this._type),
            use_policy_based_traffic_selectors: cdktf.booleanToTerraform(this._usePolicyBasedTrafficSelectors),
            virtual_network_gateway_id: cdktf.stringToTerraform(this._virtualNetworkGatewayId),
            ipsec_policy: virtualNetworkGatewayConnectionIpsecPolicyToTerraform(this._ipsecPolicy.internalValue),
            timeouts: virtualNetworkGatewayConnectionTimeoutsToTerraform(this._timeouts.internalValue),
            traffic_selector_policy: virtualNetworkGatewayConnectionTrafficSelectorPolicyToTerraform(this._trafficSelectorPolicy.internalValue),
        };
    }
}
exports.VirtualNetworkGatewayConnection = VirtualNetworkGatewayConnection;
_d = JSII_RTTI_SYMBOL_1;
VirtualNetworkGatewayConnection[_d] = { fqn: "@cdktf/provider-azurerm.VirtualNetworkGatewayConnection", version: "0.6.8" };
// =================
// STATIC PROPERTIES
// =================
VirtualNetworkGatewayConnection.tfResourceType = "azurerm_virtual_network_gateway_connection";
//# sourceMappingURL=data:application/json;base64,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