"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * Use a CloudFront Distribution as an alias record target.
 *
 * @stability stable
 */
class CloudFrontTarget {
    /**
     * @stability stable
     */
    constructor(distribution) {
        this.distribution = distribution;
    }
    /**
     * Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined.
     * @stability stable
     */
    static getHostedZoneId(scope) {
        var _a;
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_a = scopeStack.node.tryFindChild(mappingName)) !== null && _a !== void 0 ? _a : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 *
 * @stability stable
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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