"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InterfaceVpcEndpointTarget = void 0;
const cdk = require("@aws-cdk/core");
/**
 * Set an InterfaceVpcEndpoint as a target for an ARecord.
 *
 * @stability stable
 */
class InterfaceVpcEndpointTarget {
    /**
     * @stability stable
     */
    constructor(vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
        this.cfnVpcEndpoint = this.vpcEndpoint.node.findChild('Resource');
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            dnsName: cdk.Fn.select(1, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
            hostedZoneId: cdk.Fn.select(0, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
        };
    }
}
exports.InterfaceVpcEndpointTarget = InterfaceVpcEndpointTarget;
//# sourceMappingURL=data:application/json;base64,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