"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolDomainTarget = void 0;
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * Use a user pool domain as an alias record target.
 *
 * @stability stable
 */
class UserPoolDomainTarget {
    /**
     * @stability stable
     */
    constructor(domain) {
        this.domain = domain;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.getHostedZoneId(this.domain),
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLDJEQUF1RDs7Ozs7O0FBS3ZELE1BQWEsb0JBQW9COzs7O0lBQy9CLFlBQTZCLE1BQXNCO1FBQXRCLFdBQU0sR0FBTixNQUFNLENBQWdCO0lBQ25ELENBQUM7Ozs7OztJQUVNLElBQUksQ0FBQyxPQUFtQjtRQUM3QixPQUFPO1lBQ0wsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsb0JBQW9CO1lBQ3pDLFlBQVksRUFBRSxvQ0FBZ0IsQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztTQUM1RCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBVkQsb0RBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBVc2VyUG9vbERvbWFpbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2duaXRvJztcbmltcG9ydCB7IEFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnLCBJQWxpYXNSZWNvcmRUYXJnZXQsIElSZWNvcmRTZXQgfSBmcm9tICdAYXdzLWNkay9hd3Mtcm91dGU1Myc7XG5pbXBvcnQgeyBDbG91ZEZyb250VGFyZ2V0IH0gZnJvbSAnLi9jbG91ZGZyb250LXRhcmdldCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgVXNlclBvb2xEb21haW5UYXJnZXQgaW1wbGVtZW50cyBJQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGRvbWFpbjogVXNlclBvb2xEb21haW4pIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9yZWNvcmQ6IElSZWNvcmRTZXQpOiBBbGlhc1JlY29yZFRhcmdldENvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGRuc05hbWU6IHRoaXMuZG9tYWluLmNsb3VkRnJvbnREb21haW5OYW1lLFxuICAgICAgaG9zdGVkWm9uZUlkOiBDbG91ZEZyb250VGFyZ2V0LmdldEhvc3RlZFpvbmVJZCh0aGlzLmRvbWFpbiksXG4gICAgfTtcbiAgfVxufVxuIl19