import sgqlc.types
import sgqlc.types.datetime
import sgqlc.types.relay


schema = sgqlc.types.Schema()


# Unexport Node/PageInfo, let schema re-declare them
schema -= sgqlc.types.relay.Node
schema -= sgqlc.types.relay.PageInfo


__docformat__ = 'markdown'


########################################################################
# Scalars and Enumerations
########################################################################
class AccessKeyIndexEnum(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `account`None
    * `user`None
    '''
    __schema__ = schema
    __choices__ = ('account', 'user')


class AccountNotificationDigestSettingsModelDigestType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ANOMALIES_DIGEST`: anomalies based digest
    * `INACTIVE_DIGEST`: inactive monitors digest
    * `MISCONF_DIGEST`: misconfigured monitors digest
    '''
    __schema__ = schema
    __choices__ = ('ANOMALIES_DIGEST', 'INACTIVE_DIGEST', 'MISCONF_DIGEST')


class AccountNotificationRoutingRulesModelMonitorLabelsMatchType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AND`: AND
    * `OR`: OR
    '''
    __schema__ = schema
    __choices__ = ('AND', 'OR')


class AccountNotificationSettingsModelNotificationScheduleType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `BACKUP_OR_FAILURE`: Backup Or Failure
    * `DIGEST`: Digest
    * `REALTIME`: Realtime
    '''
    __schema__ = schema
    __choices__ = ('BACKUP_OR_FAILURE', 'DIGEST', 'REALTIME')


class AccountNotificationSettingsModelType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ALATION`: Alation
    * `EMAIL`: Email
    * `JIRA`: Jira
    * `MATTERMOST`: Mattermost
    * `MSTEAMS`: Msteams
    * `OPSGENIE`: Opsgenie
    * `PAGERDUTY`: Pagerduty
    * `SERVICENOW`: Servicenow
    * `SLACK`: Slack
    * `SLACK_V2`: Slack V2
    * `WEBEX`: Webex
    * `WEBHOOK`: Webhook
    '''
    __schema__ = schema
    __choices__ = ('ALATION', 'EMAIL', 'JIRA', 'MATTERMOST', 'MSTEAMS', 'OPSGENIE', 'PAGERDUTY', 'SERVICENOW', 'SLACK', 'SLACK_V2', 'WEBEX', 'WEBHOOK')


class ActorType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `AI`None
    * `HUMAN`None
    * `assistant`None
    * `system`None
    * `user`None
    '''
    __schema__ = schema
    __choices__ = ('AI', 'HUMAN', 'assistant', 'system', 'user')


class AgentModelAgentType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DATA_STORE_AGENT`: Data Store Agent
    * `REMOTE_AGENT`: Remote Agent
    '''
    __schema__ = schema
    __choices__ = ('DATA_STORE_AGENT', 'REMOTE_AGENT')


class AgentModelAuthType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AWS_ASSUMABLE_ROLE`: AWS Assumable Role
    * `AWS_VPCE`: AWS VPC Endpoint
    * `AZURE_FUNCTION_APP_KEY`: Azure Function App Key
    * `AZURE_STORAGE_ACCOUNT_KEYS`: Azure Storage Account Shared Key
    * `GCP_JSON_SERVICE_ACCOUNT_KEY`: GCP JSON Service Account Key
    * `GCP_WORKLOAD_IDENTITY_FEDERATION`: GCP Workload Identity
      Federation
    '''
    __schema__ = schema
    __choices__ = ('AWS_ASSUMABLE_ROLE', 'AWS_VPCE', 'AZURE_FUNCTION_APP_KEY', 'AZURE_STORAGE_ACCOUNT_KEYS', 'GCP_JSON_SERVICE_ACCOUNT_KEY', 'GCP_WORKLOAD_IDENTITY_FEDERATION')


class AgentModelPlatform(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AWS`: AWS
    * `AZURE`: Azure
    * `GCP`: GCP
    '''
    __schema__ = schema
    __choices__ = ('AWS', 'AZURE', 'GCP')


class AgentModelStorageType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AZURE_BLOB`: Azure Storage
    * `GCS`: Google Cloud Storage
    * `S3`: Amazon S3
    '''
    __schema__ = schema
    __choices__ = ('AZURE_BLOB', 'GCS', 'S3')


class AgentModelWrapperType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CLOUDFORMATION`: CloudFormation
    * `TERRAFORM`: Terraform
    '''
    __schema__ = schema
    __choices__ = ('CLOUDFORMATION', 'TERRAFORM')


class AgentTypeEnum(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DATA_STORE_AGENT`None
    * `REMOTE_AGENT`None
    '''
    __schema__ = schema
    __choices__ = ('DATA_STORE_AGENT', 'REMOTE_AGENT')


class AggregationFunction(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `AVG`None
    * `MAX`None
    * `MEDIAN`None
    * `MIN`None
    '''
    __schema__ = schema
    __choices__ = ('AVG', 'MAX', 'MEDIAN', 'MIN')


class AuthTypeEnum(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AWS_ASSUMABLE_ROLE`None
    * `AWS_VPCE`None
    * `AZURE_FUNCTION_APP_KEY`None
    * `AZURE_STORAGE_ACCOUNT_KEYS`None
    * `GCP_JSON_SERVICE_ACCOUNT_KEY`None
    * `GCP_WORKLOAD_IDENTITY_FEDERATION`None
    '''
    __schema__ = schema
    __choices__ = ('AWS_ASSUMABLE_ROLE', 'AWS_VPCE', 'AZURE_FUNCTION_APP_KEY', 'AZURE_STORAGE_ACCOUNT_KEYS', 'GCP_JSON_SERVICE_ACCOUNT_KEY', 'GCP_WORKLOAD_IDENTITY_FEDERATION')


class BiContainerModelType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `LOOKER`: Looker
    * `POWER_BI`: Power BI
    * `TABLEAU`: Tableau
    '''
    __schema__ = schema
    __choices__ = ('LOOKER', 'POWER_BI', 'TABLEAU')


class BillingPlanType(sgqlc.types.Enum):
    '''Used to select the billing plan for the accounts.

    Enumeration Choices:

    * `ENTERPRISE`None
    * `ENTERPRISE_WITH_ENTERPRISE_SUPPORT`None
    * `SCALE`None
    * `SCALE_WITH_ENTERPRISE_SUPPORT`None
    * `START`None
    '''
    __schema__ = schema
    __choices__ = ('ENTERPRISE', 'ENTERPRISE_WITH_ENTERPRISE_SUPPORT', 'SCALE', 'SCALE_WITH_ENTERPRISE_SUPPORT', 'START')


Boolean = sgqlc.types.Boolean

class CollectionPreferenceEffectType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `allow`None
    * `block`None
    '''
    __schema__ = schema
    __choices__ = ('allow', 'block')


class CollectionPreferenceMatchType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `exact_match`None
    * `prefix`None
    * `regexp`None
    * `substring`None
    * `suffix`None
    '''
    __schema__ = schema
    __choices__ = ('exact_match', 'prefix', 'regexp', 'substring', 'suffix')


class CollectionPreferenceTargetObjectType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `dataset`None
    * `project`None
    * `table`None
    '''
    __schema__ = schema
    __choices__ = ('dataset', 'project', 'table')


class ComparisonType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `ABSOLUTE_VOLUME`None
    * `CHANGE`None
    * `DYNAMIC_THRESHOLD`None
    * `FRESHNESS`None
    * `GROWTH_VOLUME`None
    * `QUERY_PERFORMANCE`None
    * `SOURCE_TARGET_DELTA`None
    * `THRESHOLD`None
    '''
    __schema__ = schema
    __choices__ = ('ABSOLUTE_VOLUME', 'CHANGE', 'DYNAMIC_THRESHOLD', 'FRESHNESS', 'GROWTH_VOLUME', 'QUERY_PERFORMANCE', 'SOURCE_TARGET_DELTA', 'THRESHOLD')


class ConnectionModelType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AIRFLOW`: Airflow
    * `ATHENA`: Athena
    * `BIGQUERY`: BigQuery
    * `CONFLUENT_KAFKA`: Confluent Kafka
    * `CONFLUENT_KAFKA_CONNECT`: Confluent Kafka Connect
    * `DATABRICKS_DELTA`: Databricks Delta
    * `DATABRICKS_METASTORE`: Databricks metastore
    * `DATABRICKS_METASTORE_SQL_WAREHOUSE`: Databricks Metastore Sql
      Warehouse
    * `DATABRICKS_SQL_WAREHOUSE`: Databricks Sql Warehouse
    * `DBT_CLOUD`: dbt Cloud
    * `DBT_CLOUD_V2`: dbt Cloud v2
    * `DBT_CLOUD_WEBHOOK`: dbt Cloud Webhook
    * `DBT_CORE`: dbt Core
    * `FIVETRAN`: Fivetran
    * `GLUE`: Glue
    * `HIVE`: Hive
    * `HIVE_MYSQL`: Hive (MySQL)
    * `HIVE_S3`: Hive (S3 Location)
    * `LOOKER`: Looker
    * `LOOKER_GIT`: Looker Git
    * `LOOKER_GIT_CLONE`: Looker Git Clone either ssh or https
    * `LOOKER_GIT_SSH`: Looker Git SSH
    * `POWER_BI`: Power BI
    * `PRESTO`: Presto
    * `PRESTO_S3`: Presto (S3 Location)
    * `REDSHIFT`: Amazon Redshift
    * `S3`: S3
    * `S3_METADATA_EVENTS`: S3 Metadata Events
    * `S3_QL_EVENTS`: S3 Query Log Events
    * `SNOWFLAKE`: Snowflake
    * `SPARK`: Spark
    * `TABLEAU`: Tableau
    * `TRANSACTIONAL_DB`: transactional-db
    '''
    __schema__ = schema
    __choices__ = ('AIRFLOW', 'ATHENA', 'BIGQUERY', 'CONFLUENT_KAFKA', 'CONFLUENT_KAFKA_CONNECT', 'DATABRICKS_DELTA', 'DATABRICKS_METASTORE', 'DATABRICKS_METASTORE_SQL_WAREHOUSE', 'DATABRICKS_SQL_WAREHOUSE', 'DBT_CLOUD', 'DBT_CLOUD_V2', 'DBT_CLOUD_WEBHOOK', 'DBT_CORE', 'FIVETRAN', 'GLUE', 'HIVE', 'HIVE_MYSQL', 'HIVE_S3', 'LOOKER', 'LOOKER_GIT', 'LOOKER_GIT_CLONE', 'LOOKER_GIT_SSH', 'POWER_BI', 'PRESTO', 'PRESTO_S3', 'REDSHIFT', 'S3', 'S3_METADATA_EVENTS', 'S3_QL_EVENTS', 'SNOWFLAKE', 'SPARK', 'TABLEAU', 'TRANSACTIONAL_DB')


class CustomRuleComparisonOperator(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `EQ`None
    * `GT`None
    * `GTE`None
    * `IS_NOT_NULL`None
    * `IS_NULL`None
    * `LT`None
    * `LTE`None
    * `NEQ`None
    '''
    __schema__ = schema
    __choices__ = ('EQ', 'GT', 'GTE', 'IS_NOT_NULL', 'IS_NULL', 'LT', 'LTE', 'NEQ')


class CustomRuleModelQueryResultType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `LABELED_NUMERICS`: LABELED_NUMERICS
    * `ROW_COUNT`: ROW_COUNT
    * `SINGLE_NUMERIC`: SINGLE_NUMERIC
    '''
    __schema__ = schema
    __choices__ = ('LABELED_NUMERICS', 'ROW_COUNT', 'SINGLE_NUMERIC')


class CustomRuleModelRuleType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `COMPARISON`: Comparison Rule
    * `CUSTOM_SQL`: SQL Rule
    * `FIELD_QUALITY`: Field Quality Rule
    * `FRESHNESS`: Freshness Rule
    * `QUERY_PERF`: Query Performance Rule
    * `TABLE_METRIC`: Table Metric Rule
    * `VOLUME`: Volume Rule
    '''
    __schema__ = schema
    __choices__ = ('COMPARISON', 'CUSTOM_SQL', 'FIELD_QUALITY', 'FRESHNESS', 'QUERY_PERF', 'TABLE_METRIC', 'VOLUME')


class CustomSQLTemplateModelQueryResultType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `LABELED_NUMERICS`: LABELED_NUMERICS
    * `ROW_COUNT`: ROW_COUNT
    * `SINGLE_NUMERIC`: SINGLE_NUMERIC
    '''
    __schema__ = schema
    __choices__ = ('LABELED_NUMERICS', 'ROW_COUNT', 'SINGLE_NUMERIC')


class DashboardType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `READ`None
    * `WRITE`None
    '''
    __schema__ = schema
    __choices__ = ('READ', 'WRITE')


class DataAssetTypeEnum(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ASSET_TYPE_EXTERNAL`None
    * `ASSET_TYPE_SNOWFLAKE_STREAM`None
    * `ASSET_TYPE_TABLE`None
    * `ASSET_TYPE_VIEW`None
    * `ASSET_TYPE_WILDCARD_TABLE`None
    '''
    __schema__ = schema
    __choices__ = ('ASSET_TYPE_EXTERNAL', 'ASSET_TYPE_SNOWFLAKE_STREAM', 'ASSET_TYPE_TABLE', 'ASSET_TYPE_VIEW', 'ASSET_TYPE_WILDCARD_TABLE')


class DataCollectorEventTypes(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `s3_metadata_events`None
    * `s3_ql_events`None
    '''
    __schema__ = schema
    __choices__ = ('s3_metadata_events', 's3_ql_events')


class DataCollectorScheduleModelDeleteReason(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CONNECTION_DELETED`: connection_deleted
    * `MONITOR_DELETED`: monitor_deleted
    * `NO_COLLECTOR`: no_collector
    * `RULE_DELETED`: rule_deleted
    * `SIZE_COLLECTION_DISABLED`: size_collection_disabled
    '''
    __schema__ = schema
    __choices__ = ('CONNECTION_DELETED', 'MONITOR_DELETED', 'NO_COLLECTOR', 'RULE_DELETED', 'SIZE_COLLECTION_DISABLED')


class DataCollectorScheduleModelScheduleType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DYNAMIC`: Dynamic
    * `FIXED`: Fixed
    * `LOOSE`: Loose
    * `MANUAL`: Manual
    '''
    __schema__ = schema
    __choices__ = ('DYNAMIC', 'FIXED', 'LOOSE', 'MANUAL')


class DataCollectorScheduleModelSkipReason(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CONNECTION_DISABLED`: Connection disabled
    * `MANUALLY_SKIPPED`: Manually skipped
    * `NONE`: Empty reason
    '''
    __schema__ = schema
    __choices__ = ('CONNECTION_DISABLED', 'MANUALLY_SKIPPED', 'NONE')


class DataColumnTypes(sgqlc.types.Enum):
    '''Available types for column values.

    Enumeration Choices:

    * `CHART`None
    * `DATE_TIME`None
    * `HOURS`None
    * `NUMERIC`None
    * `PERCENTAGE`None
    * `TEXT`None
    '''
    __schema__ = schema
    __choices__ = ('CHART', 'DATE_TIME', 'HOURS', 'NUMERIC', 'PERCENTAGE', 'TEXT')


class DataExplorerWidgetModelWidgetType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DISCRETE`: DISCRETE
    * `NUMERIC_CONTINUOUS`: NUMERIC_CONTINUOUS
    * `TIMESTAMP_HISTOGRAM`: TIMESTAMP_HISTOGRAM
    '''
    __schema__ = schema
    __choices__ = ('DISCRETE', 'NUMERIC_CONTINUOUS', 'TIMESTAMP_HISTOGRAM')


class DataMaintenanceMetric(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `ALL`None
    * `DT_METRICS`None
    * `FH_METRICS`None
    * `FRESHNESS`None
    * `VOLUME`None
    '''
    __schema__ = schema
    __choices__ = ('ALL', 'DT_METRICS', 'FH_METRICS', 'FRESHNESS', 'VOLUME')


class DataProductMetric(sgqlc.types.Enum):
    '''Metrics for data products

    Enumeration Choices:

    * `INCIDENTS_BY_DAY`None
    * `INCIDENTS_BY_HOUR`None
    * `INCIDENTS_BY_SEVERITY`None
    * `INCIDENTS_BY_STATUS`None
    * `INCIDENTS_STATUS_UPDATE_RATES_BY_DAY`None
    * `INCIDENTS_STATUS_UPDATE_RATES_BY_HOUR`None
    * `INCIDENTS_TIME_TO_FIXED_BY_DAY`None
    * `INCIDENTS_TIME_TO_FIXED_BY_HOUR`None
    * `INCIDENTS_TIME_TO_RESPONSE_BY_DAY`None
    * `INCIDENTS_TIME_TO_RESPONSE_BY_HOUR`None
    * `TABLE_UPTIME_FOR_AUTOMATED_FRESHNESS_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_AUTOMATED_FRESHNESS_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_AUTOMATED_VOLUME_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_AUTOMATED_VOLUME_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_CUSTOM_FRESHNESS_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_CUSTOM_FRESHNESS_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_CUSTOM_SQL_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_CUSTOM_SQL_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_CUSTOM_VOLUME_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_CUSTOM_VOLUME_MONITORS_BY_HOUR`None
    * `TABLE_UPTIME_FOR_FIELD_HEALTH_MONITORS_BY_DAY`None
    * `TABLE_UPTIME_FOR_FIELD_HEALTH_MONITORS_BY_HOUR`None
    '''
    __schema__ = schema
    __choices__ = ('INCIDENTS_BY_DAY', 'INCIDENTS_BY_HOUR', 'INCIDENTS_BY_SEVERITY', 'INCIDENTS_BY_STATUS', 'INCIDENTS_STATUS_UPDATE_RATES_BY_DAY', 'INCIDENTS_STATUS_UPDATE_RATES_BY_HOUR', 'INCIDENTS_TIME_TO_FIXED_BY_DAY', 'INCIDENTS_TIME_TO_FIXED_BY_HOUR', 'INCIDENTS_TIME_TO_RESPONSE_BY_DAY', 'INCIDENTS_TIME_TO_RESPONSE_BY_HOUR', 'TABLE_UPTIME_FOR_AUTOMATED_FRESHNESS_MONITORS_BY_DAY', 'TABLE_UPTIME_FOR_AUTOMATED_FRESHNESS_MONITORS_BY_HOUR', 'TABLE_UPTIME_FOR_AUTOMATED_VOLUME_MONITORS_BY_DAY', 'TABLE_UPTIME_FOR_AUTOMATED_VOLUME_MONITORS_BY_HOUR', 'TABLE_UPTIME_FOR_CUSTOM_FRESHNESS_MONITORS_BY_DAY', 'TABLE_UPTIME_FOR_CUSTOM_FRESHNESS_MONITORS_BY_HOUR', 'TABLE_UPTIME_FOR_CUSTOM_SQL_MONITORS_BY_DAY', 'TABLE_UPTIME_FOR_CUSTOM_SQL_MONITORS_BY_HOUR', 'TABLE_UPTIME_FOR_CUSTOM_VOLUME_MONITORS_BY_DAY', 'TABLE_UPTIME_FOR_CUSTOM_VOLUME_MONITORS_BY_HOUR', 'TABLE_UPTIME_FOR_FIELD_HEALTH_MONITORS_BY_DAY', 'TABLE_UPTIME_FOR_FIELD_HEALTH_MONITORS_BY_HOUR')


Date = sgqlc.types.datetime.Date

DateTime = sgqlc.types.datetime.DateTime

class DbtJobExecutionStatuses(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CANCELLED`None
    * `ERROR`None
    * `FAILED`None
    * `SUCCESS`None
    '''
    __schema__ = schema
    __choices__ = ('CANCELLED', 'ERROR', 'FAILED', 'SUCCESS')


class DbtProjectModelSource(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CLI`: CLI
    * `DBT_CLOUD`: dbt Cloud
    * `DBT_CORE`: dbt Core
    '''
    __schema__ = schema
    __choices__ = ('CLI', 'DBT_CLOUD', 'DBT_CORE')


class DetectorStatus(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ACTIVE`None
    * `INACTIVE`None
    * `TRAINING`None
    '''
    __schema__ = schema
    __choices__ = ('ACTIVE', 'INACTIVE', 'TRAINING')


class EtlType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AIRFLOW`None
    * `DATABRICKS`None
    * `FIVETRAN`None
    '''
    __schema__ = schema
    __choices__ = ('AIRFLOW', 'DATABRICKS', 'FIVETRAN')


class EventModelEventState(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `FALSE_POSITIVE`: FALSE POSITIVE
    * `MUTED`: MUTED
    * `NOTIFIED`: NOTIFIED
    * `NO_ACTION_REQUIRED`: NO ACTION REQUIRED
    * `OPEN`: OPEN
    * `RESOLVED`: RESOLVED
    * `STALE`: STALE
    * `SYSTEM_RESOLVED`: RESOLVED
    * `TIMELINE`: Timeline event status
    * `USER_RESOLVED`: RESOLVED
    '''
    __schema__ = schema
    __choices__ = ('FALSE_POSITIVE', 'MUTED', 'NOTIFIED', 'NO_ACTION_REQUIRED', 'OPEN', 'RESOLVED', 'STALE', 'SYSTEM_RESOLVED', 'TIMELINE', 'USER_RESOLVED')


class EventModelEventType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AIRFLOW_DAG_FAILURE`: Airflow DAG Failure
    * `COMMENT`: Timeline Comment
    * `COMPARISON_RULE_ANOM`: Comparison Rule Anomaly
    * `CUSTOM_RULE_ANOM`: Custom Rule Anomaly
    * `DBT_MODEL_ERROR`: dbt Model Error
    * `DBT_TEST_FAILURE`: dbt Test Failure
    * `DELETE_TABLE`: Delete Table
    * `DIST_ANOM`: Distribution Anomaly
    * `FRESH_ANOM`: Freshness Anomaly
    * `INACTIVE_MONITOR`: Inactive Monitor
    * `INCIDENT_OWNER_UPDATE`: Incident Owner Update
    * `INCIDENT_SEVERITY_UPDATE`: Incident Severity Update
    * `INCIDENT_SLACK_THREAD`: Incident Slack Thread
    * `INCIDENT_SPLIT`: Incident Split
    * `INCIDENT_STATUS_UPDATE`: Incident Status Update
    * `JSON_SCHEMA_CHANGE`: JSON Schema Change
    * `METRIC_ANOM`: Metric Anomaly
    * `QUERY_PERFORMANCE_ANOM`: Query Performance Anomaly
    * `QUERY_RUNTIME_ANOM`: Query Runtime Anomaly
    * `RULE_RUN_FAILURE`: Rule Run Failure
    * `SCHEMA_CHANGE`: Schema Change
    * `SIZE_ANOM`: Size Anomaly
    * `SIZE_DIFF`: Row count anomaly
    * `UNCHANGED_SIZE_ANOM`: Unchanged Size Anomaly
    '''
    __schema__ = schema
    __choices__ = ('AIRFLOW_DAG_FAILURE', 'COMMENT', 'COMPARISON_RULE_ANOM', 'CUSTOM_RULE_ANOM', 'DBT_MODEL_ERROR', 'DBT_TEST_FAILURE', 'DELETE_TABLE', 'DIST_ANOM', 'FRESH_ANOM', 'INACTIVE_MONITOR', 'INCIDENT_OWNER_UPDATE', 'INCIDENT_SEVERITY_UPDATE', 'INCIDENT_SLACK_THREAD', 'INCIDENT_SPLIT', 'INCIDENT_STATUS_UPDATE', 'JSON_SCHEMA_CHANGE', 'METRIC_ANOM', 'QUERY_PERFORMANCE_ANOM', 'QUERY_RUNTIME_ANOM', 'RULE_RUN_FAILURE', 'SCHEMA_CHANGE', 'SIZE_ANOM', 'SIZE_DIFF', 'UNCHANGED_SIZE_ANOM')


class EventMutingRuleModelRuleType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `EXACT_MATCH_RULE`: Exact match Rule
    * `REGEX_RULE`: Regex Rule
    '''
    __schema__ = schema
    __choices__ = ('EXACT_MATCH_RULE', 'REGEX_RULE')


class EventRcaStatusModelReason(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `BASELINE_SAMPLE_INSUFFICIENT`: Baseline sample too small to run
      analysis.
    * `BREACHES_SAMPLE_INSUFFICIENT`: Breaches sample too small to run
      analysis.
    * `CONNECTION_NOT_SUPPORTED`: Connection not supported
    * `DATA_SAMPLING_DISABLED`: Data Sampling disabled for warehouse
    * `DOES_NOT_MEET_CRITERIA`: Does not meet criteria
    * `DUPLICATE_EVENT`: Equivalent event already processed
    * `EVENT_MISSING_INCIDENT`: Event missing incident
    * `EVENT_MISSING_TABLE`: Event missing associated table
    * `HIGH_BREACHING_MONITOR`: Do not create RCAs for high breaching
      monitors
    * `MISSING_EVENT_WAREHOUSE`: Missing event warehouse connection.
    * `NOT_ENOUGH_BREACHES_DATA_RETURNED`: Not enough breaches data
      returned for correlation analysis
    * `NOT_ENOUGH_DATA_RETURNED`: Not enough data (breaches and normal
      rows) returned for correlation analysis
    * `NOT_ENOUGH_NORM_DATA_RETURNED`: Not enough normal data returned
      for correlation analysis
    * `NO_EXPLANATORY_FIELDS`: Unable to identify explanatory fields
    * `NO_HISTORY_ACCESS_METHOD_SELECTED`: No relevant history access
      method could be selected
    * `NO_TIME_FIELDS`: Unable to identify time fields
    * `PERMISSION_FAILURE`: Failure due to insufficient permissions
    * `QUERY_TIMEOUT`: RCA query timeout
    * `RCA_QUOTA_EXCEEDED`: RCA quota exceeded. Not running.
    * `RESOURCES_EXCEEDED`: Resources exceeded when running query.
    * `S3_OBJECT_WRITER_NOT_SUPPORTED`: S3 object writer not supported
    * `SQL_COMPILATION_ERROR`: Error in SQL RCA query.
    * `TABLE_TYPE_NOT_SUPPORTED`: Table type not supported
    * `UNKNOWN`: RCA failure needs further investigation to determine
      failure cause.
    * `WAREHOUSE_DISABLED`: Warehouse disabled for RCA
    * `WAREHOUSE_NOT_SUPPORTED`: RCA warehouse not supported
    '''
    __schema__ = schema
    __choices__ = ('BASELINE_SAMPLE_INSUFFICIENT', 'BREACHES_SAMPLE_INSUFFICIENT', 'CONNECTION_NOT_SUPPORTED', 'DATA_SAMPLING_DISABLED', 'DOES_NOT_MEET_CRITERIA', 'DUPLICATE_EVENT', 'EVENT_MISSING_INCIDENT', 'EVENT_MISSING_TABLE', 'HIGH_BREACHING_MONITOR', 'MISSING_EVENT_WAREHOUSE', 'NOT_ENOUGH_BREACHES_DATA_RETURNED', 'NOT_ENOUGH_DATA_RETURNED', 'NOT_ENOUGH_NORM_DATA_RETURNED', 'NO_EXPLANATORY_FIELDS', 'NO_HISTORY_ACCESS_METHOD_SELECTED', 'NO_TIME_FIELDS', 'PERMISSION_FAILURE', 'QUERY_TIMEOUT', 'RCA_QUOTA_EXCEEDED', 'RESOURCES_EXCEEDED', 'S3_OBJECT_WRITER_NOT_SUPPORTED', 'SQL_COMPILATION_ERROR', 'TABLE_TYPE_NOT_SUPPORTED', 'UNKNOWN', 'WAREHOUSE_DISABLED', 'WAREHOUSE_NOT_SUPPORTED')


class ExecDashboardMetrics(sgqlc.types.Enum):
    '''Available executive dashboard metrics.      For series, we
    use the plural. Ex: INCIDENTS_COUNTS, vs. singular for single. Ex:
    TABLES_COUNT

    Enumeration Choices:

    * `DAILY_MUTED_TABLES_COUNTS`None
    * `DAILY_NON_MUTED_TABLES_COUNTS`None
    * `DAILY_TABLES_COUNTS`None
    * `FIELD_MONITOR_UPTIME_PCT`None
    * `FRESHNESS_UPTIME_PCT`None
    * `INCIDENTS_CLASSIFIED_COUNTS`None
    * `INCIDENTS_COUNTS`None
    * `INCIDENTS_COUNTS_BY_TABLE`None
    * `INCIDENTS_MEAN_TIME_TO_FIRST_RESPONSE`None
    * `INCIDENTS_MEAN_TIME_TO_RESOLUTION`None
    * `INCIDENTS_MEDIAN_TIME_TO_FIRST_RESPONSE`None
    * `INCIDENTS_MEDIAN_TIME_TO_RESOLUTION`None
    * `INCIDENTS_STATUS_UPDATE_RATE`None
    * `MONITORS_COUNTS`None
    * `MONITORS_CREATED_COUNT`None
    * `MONITORS_INCIDENTS_COUNTS`None
    * `OOTB_FRESHNESS_UPTIME_PCT`None
    * `OOTB_VOLUME_UPTIME_PCT`None
    * `SQL_RULES_UPTIME_PCT`None
    * `STACK_SUMMARY`None
    * `USER_APP_VIEWS_COUNTS`None
    * `USER_PAGE_VIEWS_COUNTS`None
    * `USER_VISITS_COUNTS`None
    * `VOLUME_UPTIME_PCT`None
    '''
    __schema__ = schema
    __choices__ = ('DAILY_MUTED_TABLES_COUNTS', 'DAILY_NON_MUTED_TABLES_COUNTS', 'DAILY_TABLES_COUNTS', 'FIELD_MONITOR_UPTIME_PCT', 'FRESHNESS_UPTIME_PCT', 'INCIDENTS_CLASSIFIED_COUNTS', 'INCIDENTS_COUNTS', 'INCIDENTS_COUNTS_BY_TABLE', 'INCIDENTS_MEAN_TIME_TO_FIRST_RESPONSE', 'INCIDENTS_MEAN_TIME_TO_RESOLUTION', 'INCIDENTS_MEDIAN_TIME_TO_FIRST_RESPONSE', 'INCIDENTS_MEDIAN_TIME_TO_RESOLUTION', 'INCIDENTS_STATUS_UPDATE_RATE', 'MONITORS_COUNTS', 'MONITORS_CREATED_COUNT', 'MONITORS_INCIDENTS_COUNTS', 'OOTB_FRESHNESS_UPTIME_PCT', 'OOTB_VOLUME_UPTIME_PCT', 'SQL_RULES_UPTIME_PCT', 'STACK_SUMMARY', 'USER_APP_VIEWS_COUNTS', 'USER_PAGE_VIEWS_COUNTS', 'USER_VISITS_COUNTS', 'VOLUME_UPTIME_PCT')


class ExecDashboardTables(sgqlc.types.Enum):
    '''Available executive dashboard tables.

    Enumeration Choices:

    * `DOMAINS_TABLE`None
    * `MONITORS_TABLE`None
    * `USERS_TABLE`None
    '''
    __schema__ = schema
    __choices__ = ('DOMAINS_TABLE', 'MONITORS_TABLE', 'USERS_TABLE')


class FacetType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `TAGS`None
    * `TAG_NAMES`None
    * `TAG_VALUES`None
    '''
    __schema__ = schema
    __choices__ = ('TAGS', 'TAG_NAMES', 'TAG_VALUES')


class FieldHealthMetrics(sgqlc.types.Enum):
    '''Field Health monitor opt-in metrics.

    Enumeration Choices:

    * `NEGATIVE_RATE`None
    * `NULL_RATE`None
    * `NUMERIC_MAX`None
    * `NUMERIC_MEAN`None
    * `NUMERIC_MEDIAN`None
    * `NUMERIC_MIN`None
    * `NUMERIC_QUANTILES`None
    * `NUMERIC_STDDEV`None
    * `TEXT_ALL_SPACE_RATE`None
    * `TEXT_INT_RATE`None
    * `TEXT_MAX_LENGTH`None
    * `TEXT_MEAN_LENGTH`None
    * `TEXT_MIN_LENGTH`None
    * `TEXT_NULL_KEYWORD_RATE`None
    * `TEXT_NUMBER_RATE`None
    * `TEXT_STD_LENGTH`None
    * `TEXT_UUID_RATE`None
    * `UNIQUE_RATE`None
    * `ZERO_RATE`None
    '''
    __schema__ = schema
    __choices__ = ('NEGATIVE_RATE', 'NULL_RATE', 'NUMERIC_MAX', 'NUMERIC_MEAN', 'NUMERIC_MEDIAN', 'NUMERIC_MIN', 'NUMERIC_QUANTILES', 'NUMERIC_STDDEV', 'TEXT_ALL_SPACE_RATE', 'TEXT_INT_RATE', 'TEXT_MAX_LENGTH', 'TEXT_MEAN_LENGTH', 'TEXT_MIN_LENGTH', 'TEXT_NULL_KEYWORD_RATE', 'TEXT_NUMBER_RATE', 'TEXT_STD_LENGTH', 'TEXT_UUID_RATE', 'UNIQUE_RATE', 'ZERO_RATE')


class FieldMetricType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `APPROX_DISTINCTNESS`None
    * `MAX_LENGTH`None
    * `MEAN_LENGTH`None
    * `MIN_LENGTH`None
    * `NEGATIVE_RATE`None
    * `NULL_RATE`None
    * `NUMERIC_MAX`None
    * `NUMERIC_MEAN`None
    * `NUMERIC_MEDIAN`None
    * `NUMERIC_MIN`None
    * `NUMERIC_STDDEV`None
    * `TEXT_ALL_SPACE_RATE`None
    * `TEXT_INT_RATE`None
    * `TEXT_MAX_LENGTH`None
    * `TEXT_MEAN_LENGTH`None
    * `TEXT_MIN_LENGTH`None
    * `TEXT_NULL_KEYWORD_RATE`None
    * `TEXT_NUMBER_RATE`None
    * `TEXT_STD_LENGTH`None
    * `TEXT_UUID_RATE`None
    * `UNIQUE_RATE`None
    * `ZERO_RATE`None
    '''
    __schema__ = schema
    __choices__ = ('APPROX_DISTINCTNESS', 'MAX_LENGTH', 'MEAN_LENGTH', 'MIN_LENGTH', 'NEGATIVE_RATE', 'NULL_RATE', 'NUMERIC_MAX', 'NUMERIC_MEAN', 'NUMERIC_MEDIAN', 'NUMERIC_MIN', 'NUMERIC_STDDEV', 'TEXT_ALL_SPACE_RATE', 'TEXT_INT_RATE', 'TEXT_MAX_LENGTH', 'TEXT_MEAN_LENGTH', 'TEXT_MIN_LENGTH', 'TEXT_NULL_KEYWORD_RATE', 'TEXT_NUMBER_RATE', 'TEXT_STD_LENGTH', 'TEXT_UUID_RATE', 'UNIQUE_RATE', 'ZERO_RATE')


class FieldQueryType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `APPROX_DISTINCTNESS`None
    * `DISTINCT_VALUES`None
    * `MAX_LENGTH`None
    * `MEAN_LENGTH`None
    * `MIN_LENGTH`None
    * `MISSING_VALUES`None
    * `NEGATIVE_RATE`None
    * `NOT_IN_VALUES`None
    * `NULL_RATE`None
    * `NUMERIC_MAX`None
    * `NUMERIC_MEAN`None
    * `NUMERIC_MEDIAN`None
    * `NUMERIC_MIN`None
    * `NUMERIC_QUANTILES`None
    * `NUMERIC_STDDEV`None
    * `TEXT_ALL_SPACE_RATE`None
    * `TEXT_INT_RATE`None
    * `TEXT_MAX_LENGTH`None
    * `TEXT_MEAN_LENGTH`None
    * `TEXT_MIN_LENGTH`None
    * `TEXT_NULL_KEYWORD_RATE`None
    * `TEXT_NUMBER_RATE`None
    * `TEXT_STD_LENGTH`None
    * `TEXT_UUID_RATE`None
    * `UNIQUE_RATE`None
    * `ZERO_RATE`None
    '''
    __schema__ = schema
    __choices__ = ('APPROX_DISTINCTNESS', 'DISTINCT_VALUES', 'MAX_LENGTH', 'MEAN_LENGTH', 'MIN_LENGTH', 'MISSING_VALUES', 'NEGATIVE_RATE', 'NOT_IN_VALUES', 'NULL_RATE', 'NUMERIC_MAX', 'NUMERIC_MEAN', 'NUMERIC_MEDIAN', 'NUMERIC_MIN', 'NUMERIC_QUANTILES', 'NUMERIC_STDDEV', 'TEXT_ALL_SPACE_RATE', 'TEXT_INT_RATE', 'TEXT_MAX_LENGTH', 'TEXT_MEAN_LENGTH', 'TEXT_MIN_LENGTH', 'TEXT_NULL_KEYWORD_RATE', 'TEXT_NUMBER_RATE', 'TEXT_STD_LENGTH', 'TEXT_UUID_RATE', 'UNIQUE_RATE', 'ZERO_RATE')


class FieldType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `BOOLEAN`None
    * `DATE`None
    * `NUMERIC`None
    * `TEXT`None
    * `TIME`None
    * `UNKNOWN`None
    '''
    __schema__ = schema
    __choices__ = ('BOOLEAN', 'DATE', 'NUMERIC', 'TEXT', 'TIME', 'UNKNOWN')


class FieldValueFilterOperator(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `EXCLUDE`None
    * `INCLUDE`None
    '''
    __schema__ = schema
    __choices__ = ('EXCLUDE', 'INCLUDE')


class FivetranConnectorSetupStates(sgqlc.types.Enum):
    '''Defines the current setup state of a Fivetran Connector

    Enumeration Choices:

    * `BROKEN`None
    * `CONNECTED`None
    * `INCOMPLETE`None
    '''
    __schema__ = schema
    __choices__ = ('BROKEN', 'CONNECTED', 'INCOMPLETE')


class FivetranConnectorStatuses(sgqlc.types.Enum):
    '''Defines the user facing statues of Fivetran connectors.
    See: https://fivetran.com/docs/getting-started/fivetran-
    dashboard/connectors#connectorstatus

    Enumeration Choices:

    * `Active`None
    * `Broken`None
    * `Delayed`None
    * `Incomplete`None
    * `Paused`None
    '''
    __schema__ = schema
    __choices__ = ('Active', 'Broken', 'Delayed', 'Incomplete', 'Paused')


class FivetranConnectorSyncStates(sgqlc.types.Enum):
    '''Defines the current sync state of a Fivetran Connector

    Enumeration Choices:

    * `PAUSED`None
    * `RESCHEDULED`None
    * `SCHEDULED`None
    * `SYNCING`None
    '''
    __schema__ = schema
    __choices__ = ('PAUSED', 'RESCHEDULED', 'SCHEDULED', 'SYNCING')


class FivetranConnectorUpdateStates(sgqlc.types.Enum):
    '''Defines the current data update state of a Fivetran connector

    Enumeration Choices:

    * `DELAYED`None
    * `ON_SCHEDULE`None
    '''
    __schema__ = schema
    __choices__ = ('DELAYED', 'ON_SCHEDULE')


Float = sgqlc.types.Float

class GenericScalar(sgqlc.types.Scalar):
    '''The `GenericScalar` scalar type represents a generic GraphQL
    scalar value that could be: String, Boolean, Int, Float, List or
    Object.
    '''
    __schema__ = schema


ID = sgqlc.types.ID

class IdempotentStatus(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `COMPLETED`None
    * `ERROR`None
    * `IN_PROGRESS`None
    '''
    __schema__ = schema
    __choices__ = ('COMPLETED', 'ERROR', 'IN_PROGRESS')


class ImportanceScoreOperator(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `EQ`None
    * `GT`None
    * `GTE`None
    * `LT`None
    * `LTE`None
    * `RANGE`None
    '''
    __schema__ = schema
    __choices__ = ('EQ', 'GT', 'GTE', 'LT', 'LTE', 'RANGE')


class IncidentCategory(sgqlc.types.Enum):
    '''Categories to classify incidents

    Enumeration Choices:

    * `dbt_errors`None
    * `dimension`None
    * `field_health`None
    * `field_quality_rule`None
    * `freshness`None
    * `schema`None
    * `sql_rule`None
    * `volume`None
    '''
    __schema__ = schema
    __choices__ = ('dbt_errors', 'dimension', 'field_health', 'field_quality_rule', 'freshness', 'schema', 'sql_rule', 'volume')


class IncidentGroupBy(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `STATUS`None
    * `TYPE`None
    '''
    __schema__ = schema
    __choices__ = ('STATUS', 'TYPE')


class IncidentModelFeedback(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ANOMALY_NORMALIZED`: Anomaly Normalized
    * `EXPECTED`: Expected
    * `FALSE_POSITIVE`: False Positive
    * `FIXED`: Fixed
    * `HELPFUL`: Helpful
    * `INVESTIGATING`: Investigating
    * `NOT_HELPFUL`: Not Helpful
    * `NO_ACTION_NEEDED`: No Action Needed
    '''
    __schema__ = schema
    __choices__ = ('ANOMALY_NORMALIZED', 'EXPECTED', 'FALSE_POSITIVE', 'FIXED', 'HELPFUL', 'INVESTIGATING', 'NOT_HELPFUL', 'NO_ACTION_NEEDED')


class IncidentModelIncidentType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ANOMALIES`: Anomalies
    * `CUSTOM_RULE_ANOMALIES`: Custom Rule Anomalies
    * `DBT_ERRORS`: dbt Errors
    * `DELETED_TABLES`: Deleted Tables
    * `ETL_ERRORS`: ETL Errors
    * `JSON_SCHEMA_CHANGES`: JSON Schema Changes
    * `METRIC_ANOMALIES`: Metric Anomalies
    * `PERFORMANCE_ANOMALIES`: Performance Anomalies
    * `PSEUDO_INTEGRATION_TEST`: Pseudo Anomalies
    * `RULE_RUN_EXECUTION_ERROR`: Rule Run Failure
    * `SCHEMA_CHANGES`: Schema Changes
    '''
    __schema__ = schema
    __choices__ = ('ANOMALIES', 'CUSTOM_RULE_ANOMALIES', 'DBT_ERRORS', 'DELETED_TABLES', 'ETL_ERRORS', 'JSON_SCHEMA_CHANGES', 'METRIC_ANOMALIES', 'PERFORMANCE_ANOMALIES', 'PSEUDO_INTEGRATION_TEST', 'RULE_RUN_EXECUTION_ERROR', 'SCHEMA_CHANGES')


class IncidentReactionReason(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `DetectorTooSensitive`None
    * `DontCareAboutThisTable`None
    * `SeenThisTooManyTimes`None
    '''
    __schema__ = schema
    __choices__ = ('DetectorTooSensitive', 'DontCareAboutThisTable', 'SeenThisTooManyTimes')


class IncidentReactionType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `Helpful`None
    * `NotHelpful`None
    '''
    __schema__ = schema
    __choices__ = ('Helpful', 'NotHelpful')


class IncidentSubType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `abnormal_size_change`None
    * `airflow_dag_failure`None
    * `comparison_rule_breach`None
    * `data_added`None
    * `data_removed`None
    * `dbt_model_error`None
    * `dbt_test_failure`None
    * `dimension_anomaly`None
    * `field_metrics_anomaly`None
    * `field_quality_rule_breach`None
    * `fields_added`None
    * `fields_changed`None
    * `fields_removed`None
    * `freshness_anomaly`None
    * `freshness_sli_rule_breach`None
    * `json_fields_added`None
    * `json_fields_removed`None
    * `sql_rule_breach`None
    * `unchanged_size`None
    * `volume_anomaly`None
    * `volume_sli_rule_breach`None
    '''
    __schema__ = schema
    __choices__ = ('abnormal_size_change', 'airflow_dag_failure', 'comparison_rule_breach', 'data_added', 'data_removed', 'dbt_model_error', 'dbt_test_failure', 'dimension_anomaly', 'field_metrics_anomaly', 'field_quality_rule_breach', 'fields_added', 'fields_changed', 'fields_removed', 'freshness_anomaly', 'freshness_sli_rule_breach', 'json_fields_added', 'json_fields_removed', 'sql_rule_breach', 'unchanged_size', 'volume_anomaly', 'volume_sli_rule_breach')


class IncidentsFilterFields(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `contains_key_asset`None
    * `dataset`None
    * `domain`None
    * `incident_type`None
    * `include_normalized`None
    * `jira`None
    * `owner`None
    * `servicenow`None
    * `severity`None
    * `status`None
    * `table`None
    * `tag`None
    '''
    __schema__ = schema
    __choices__ = ('contains_key_asset', 'dataset', 'domain', 'incident_type', 'include_normalized', 'jira', 'owner', 'servicenow', 'severity', 'status', 'table', 'tag')


Int = sgqlc.types.Int

class IntegrationKeyScope(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AirflowCallbacks`None
    * `CircuitBreaker`None
    * `DatabricksMetadata`None
    * `DbtCloudWebhook`None
    * `S3PresignedUrl`None
    * `Spark`None
    '''
    __schema__ = schema
    __choices__ = ('AirflowCallbacks', 'CircuitBreaker', 'DatabricksMetadata', 'DbtCloudWebhook', 'S3PresignedUrl', 'Spark')


class InvitationType(sgqlc.types.Enum):
    '''Used to select the template to use for new user invites.

    Enumeration Choices:

    * `Discovery`None
    * `Observability`None
    '''
    __schema__ = schema
    __choices__ = ('Discovery', 'Observability')


class JSONString(sgqlc.types.Scalar):
    '''Allows use of a JSON String for input / output from the GraphQL
    schema.  Use of this type is *not recommended* as you lose the
    benefits of having a defined, static schema (one of the key
    benefits of GraphQL).
    '''
    __schema__ = schema


class JobExecutionStatus(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `FAILED`None
    * `IN_PROGRESS`None
    * `SUCCESS`None
    * `TIMEOUT`None
    '''
    __schema__ = schema
    __choices__ = ('FAILED', 'IN_PROGRESS', 'SUCCESS', 'TIMEOUT')


class LineageGraphTraversalDirection(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `BOTH`None
    * `DOWNSTREAM`None
    * `UPSTREAM`None
    '''
    __schema__ = schema
    __choices__ = ('BOTH', 'DOWNSTREAM', 'UPSTREAM')


class LineageNodeJobDirectionType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `dest`None
    * `source`None
    '''
    __schema__ = schema
    __choices__ = ('dest', 'source')


class LineageNodeJobType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `AIRFLOW`None
    * `CONFLUENT_KAFKA_CONNECT`None
    * `DATABRICKS`None
    * `UNKNOWN`None
    '''
    __schema__ = schema
    __choices__ = ('AIRFLOW', 'CONFLUENT_KAFKA_CONNECT', 'DATABRICKS', 'UNKNOWN')


class LookbackRange(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `ONE_DAY`None
    * `ONE_HOUR`None
    * `SEVEN_DAY`None
    * `TWELVE_HOUR`None
    '''
    __schema__ = schema
    __choices__ = ('ONE_DAY', 'ONE_HOUR', 'SEVEN_DAY', 'TWELVE_HOUR')


class MetricMonitorSelectExpressionModelDataType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `BOOLEAN`: BOOLEAN
    * `DATETIME`: DATETIME
    * `NUMERIC`: NUMERIC
    * `STRING`: STRING
    '''
    __schema__ = schema
    __choices__ = ('BOOLEAN', 'DATETIME', 'NUMERIC', 'STRING')


class MetricMonitoringModelType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CATEGORIES`: Dimension Tracking
    * `HOURLY_STATS`: Statistical metrics over an hour interval
    * `JSON_SCHEMA`: JSON Schema
    * `STATS`: Field Health
    '''
    __schema__ = schema
    __choices__ = ('CATEGORIES', 'HOURLY_STATS', 'JSON_SCHEMA', 'STATS')


class MigrationWarningType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ACCOUNT_ALREADY_MIGRATED`None
    * `AUDIENCE_CREATED`None
    * `AUDIENCE_DOES_NOT_EXIST`None
    * `CUSTOM_MESSAGE_DROPPED`None
    * `INCIDENT_TYPE_DROPPED`None
    * `MONITOR_AUDIENCE_SET`None
    * `MONITOR_IS_TEMPLATE_MANAGED`None
    * `RULES_BEING_IGNORED`None
    * `TEMPLATE_SETTING_NOT_SUPPORTED`None
    '''
    __schema__ = schema
    __choices__ = ('ACCOUNT_ALREADY_MIGRATED', 'AUDIENCE_CREATED', 'AUDIENCE_DOES_NOT_EXIST', 'CUSTOM_MESSAGE_DROPPED', 'INCIDENT_TYPE_DROPPED', 'MONITOR_AUDIENCE_SET', 'MONITOR_IS_TEMPLATE_MANAGED', 'RULES_BEING_IGNORED', 'TEMPLATE_SETTING_NOT_SUPPORTED')


class MonitorAggTimeInterval(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `DAY`None
    * `HOUR`None
    '''
    __schema__ = schema
    __choices__ = ('DAY', 'HOUR')


class MonitorConfigurationStatusType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `MISCONFIGURED`None
    * `NO_STATUS`None
    * `SUCCESS`None
    '''
    __schema__ = schema
    __choices__ = ('MISCONFIGURED', 'NO_STATUS', 'SUCCESS')


class MonitorLabelsMatchType(sgqlc.types.Enum):
    '''Used to select the logical operator for matching labels

    Enumeration Choices:

    * `AND`None
    * `OR`None
    '''
    __schema__ = schema
    __choices__ = ('AND', 'OR')


class MonitorRunStatusType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ERROR`None
    * `IN_PROGRESS`None
    * `NO_STATUS`None
    * `PAUSED`None
    * `SNOOZED`None
    * `SUCCESS`None
    '''
    __schema__ = schema
    __choices__ = ('ERROR', 'IN_PROGRESS', 'NO_STATUS', 'PAUSED', 'SNOOZED', 'SUCCESS')


class MonitorStatusType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ERROR`None
    * `IN_PROGRESS`None
    * `IN_TRAINING`None
    * `MISCONFIGURED`None
    * `NO_STATUS`None
    * `PAUSED`None
    * `SNOOZED`None
    * `SUCCESS`None
    '''
    __schema__ = schema
    __choices__ = ('ERROR', 'IN_PROGRESS', 'IN_TRAINING', 'MISCONFIGURED', 'NO_STATUS', 'PAUSED', 'SNOOZED', 'SUCCESS')


class MonitorTrainingStatusType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `IN_TRAINING`None
    * `NO_STATUS`None
    * `SUCCESS`None
    '''
    __schema__ = schema
    __choices__ = ('IN_TRAINING', 'NO_STATUS', 'SUCCESS')


class MonitoredTableRuleType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `all`None
    * `prefix`None
    * `substring`None
    * `suffix`None
    * `wildcard_pattern`None
    '''
    __schema__ = schema
    __choices__ = ('all', 'prefix', 'substring', 'suffix', 'wildcard_pattern')


class MutedEventType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CUSTOM_RULE_ANOM`None
    * `DELETE_TABLE`None
    * `DIST_ANOM`None
    * `FRESH_ANOM`None
    * `JSON_SCHEMA_CHANGE`None
    * `METRIC_ANOM`None
    * `QUERY_RUNTIME_ANOM`None
    * `SCHEMA_CHANGE`None
    * `SIZE_ANOM`None
    * `SIZE_DIFF`None
    * `UNCHANGED_SIZE_ANOM`None
    '''
    __schema__ = schema
    __choices__ = ('CUSTOM_RULE_ANOM', 'DELETE_TABLE', 'DIST_ANOM', 'FRESH_ANOM', 'JSON_SCHEMA_CHANGE', 'METRIC_ANOM', 'QUERY_RUNTIME_ANOM', 'SCHEMA_CHANGE', 'SIZE_ANOM', 'SIZE_DIFF', 'UNCHANGED_SIZE_ANOM')


class ObjectPropertyModelPropertySourceType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `COLLECTION`: Collection
    * `DASHBOARD`: Dashboard
    * `DBT`: DBT
    * `LINEAGE_API`: Lineage API
    * `TAGS_COLLECTION`: Tags Collection
    '''
    __schema__ = schema
    __choices__ = ('COLLECTION', 'DASHBOARD', 'DBT', 'LINEAGE_API', 'TAGS_COLLECTION')


class PeriodGrouping(sgqlc.types.Enum):
    '''Time size of the periods.

    Enumeration Choices:

    * `DAY`None
    * `MONTH`None
    * `WEEK`None
    '''
    __schema__ = schema
    __choices__ = ('DAY', 'MONTH', 'WEEK')


class Permission(sgqlc.types.Enum):
    '''Currently-defined permissions.

    Enumeration Choices:

    * `CatalogAccess`None
    * `CatalogEdit`None
    * `DashboardAccess`None
    * `DashboardEdit`None
    * `GraphqlMutate`None
    * `GraphqlQuery`None
    * `IncidentsAccess`None
    * `IncidentsEdit`None
    * `IncidentsUpdateStatus`None
    * `MonitorsAccess`None
    * `MonitorsAggregates`None
    * `MonitorsEdit`None
    * `PerformanceAccess`None
    * `PipelinesAccess`None
    * `PipelinesEdit`None
    * `ProductsAccess`None
    * `ProductsDiscoveryAccess`None
    * `ProductsObservabilityAccess`None
    * `ProductsSamplingAccess`None
    * `SettingsAccess`None
    * `SettingsApiAccess`None
    * `SettingsApiEdit`None
    * `SettingsApiTokensManage`None
    * `SettingsCollectionPreferencesEdit`None
    * `SettingsCollectionPreferencesList`None
    * `SettingsDomainsAccess`None
    * `SettingsDomainsEdit`None
    * `SettingsDomainsList`None
    * `SettingsDomainsViewDetail`None
    * `SettingsEdit`None
    * `SettingsIntegrationsAccess`None
    * `SettingsIntegrationsEdit`None
    * `SettingsMutedDataAccess`None
    * `SettingsMutedDataEdit`None
    * `SettingsNotificationsAccess`None
    * `SettingsPiiFiltersEdit`None
    * `SettingsPiiFiltersList`None
    * `SettingsPiiFiltersViewMetrics`None
    * `SettingsSecretsAccess`None
    * `SettingsSecretsEdit`None
    * `SettingsSecretsValuesAccess`None
    * `SettingsUsersAccess`None
    * `SettingsUsersEdit`None
    * `SettingsUsersEditSso`None
    * `SettingsUsersManageDomainsManagers`None
    * `SettingsUsersManageOwners`None
    '''
    __schema__ = schema
    __choices__ = ('CatalogAccess', 'CatalogEdit', 'DashboardAccess', 'DashboardEdit', 'GraphqlMutate', 'GraphqlQuery', 'IncidentsAccess', 'IncidentsEdit', 'IncidentsUpdateStatus', 'MonitorsAccess', 'MonitorsAggregates', 'MonitorsEdit', 'PerformanceAccess', 'PipelinesAccess', 'PipelinesEdit', 'ProductsAccess', 'ProductsDiscoveryAccess', 'ProductsObservabilityAccess', 'ProductsSamplingAccess', 'SettingsAccess', 'SettingsApiAccess', 'SettingsApiEdit', 'SettingsApiTokensManage', 'SettingsCollectionPreferencesEdit', 'SettingsCollectionPreferencesList', 'SettingsDomainsAccess', 'SettingsDomainsEdit', 'SettingsDomainsList', 'SettingsDomainsViewDetail', 'SettingsEdit', 'SettingsIntegrationsAccess', 'SettingsIntegrationsEdit', 'SettingsMutedDataAccess', 'SettingsMutedDataEdit', 'SettingsNotificationsAccess', 'SettingsPiiFiltersEdit', 'SettingsPiiFiltersList', 'SettingsPiiFiltersViewMetrics', 'SettingsSecretsAccess', 'SettingsSecretsEdit', 'SettingsSecretsValuesAccess', 'SettingsUsersAccess', 'SettingsUsersEdit', 'SettingsUsersEditSso', 'SettingsUsersManageDomainsManagers', 'SettingsUsersManageOwners')


class PermissionEffect(sgqlc.types.Enum):
    '''Possible effects of a policy.

    Enumeration Choices:

    * `Allow`None
    * `Deny`None
    '''
    __schema__ = schema
    __choices__ = ('Allow', 'Deny')


class PiiFilteringFailModeType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CLOSE`None
    * `OPEN`None
    '''
    __schema__ = schema
    __choices__ = ('CLOSE', 'OPEN')


class PlatformTypeEnum(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AWS`None
    * `AZURE`None
    * `GCP`None
    '''
    __schema__ = schema
    __choices__ = ('AWS', 'AZURE', 'GCP')


class PowerBIAuthModeEnum(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `PRIMARY_USER`None
    * `SERVICE_PRINCIPAL`None
    '''
    __schema__ = schema
    __choices__ = ('PRIMARY_USER', 'SERVICE_PRINCIPAL')


class PowerBIAuthModeEnumV2(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `PRIMARY_USER`None
    * `SERVICE_PRINCIPAL`None
    '''
    __schema__ = schema
    __choices__ = ('PRIMARY_USER', 'SERVICE_PRINCIPAL')


class QueryCategory(sgqlc.types.Enum):
    '''Possible query categories

    Enumeration Choices:

    * `alter`None
    * `clone`None
    * `copy`None
    * `create_table`None
    * `create_table_as_select`None
    * `create_table_using_template`None
    * `create_view`None
    * `delete_from`None
    * `delete_using`None
    * `drop_table`None
    * `explain`None
    * `insert_into`None
    * `insert_overwrite`None
    * `load`None
    * `merge`None
    * `put`None
    * `query`None
    * `rename`None
    * `select_into`None
    * `swap`None
    * `truncate`None
    * `unload`None
    * `update`None
    '''
    __schema__ = schema
    __choices__ = ('alter', 'clone', 'copy', 'create_table', 'create_table_as_select', 'create_table_using_template', 'create_view', 'delete_from', 'delete_using', 'drop_table', 'explain', 'insert_into', 'insert_overwrite', 'load', 'merge', 'put', 'query', 'rename', 'select_into', 'swap', 'truncate', 'unload', 'update')


class QueryLogType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `READ`None
    * `WRITE`None
    '''
    __schema__ = schema
    __choices__ = ('READ', 'WRITE')


class QueryRcaType(sgqlc.types.Enum):
    '''Types of query RCAs

    Enumeration Choices:

    * `AFR`None
    * `DBT_FAIL_SKIP`None
    * `EMPTY`None
    * `FAILED`None
    * `NEW`None
    * `QDR`None
    * `UPDATE`None
    * `UPSTREAM`None
    '''
    __schema__ = schema
    __choices__ = ('AFR', 'DBT_FAIL_SKIP', 'EMPTY', 'FAILED', 'NEW', 'QDR', 'UPDATE', 'UPSTREAM')


class QueryResultType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `LABELED_NUMERICS`None
    * `ROW_COUNT`None
    * `SINGLE_NUMERIC`None
    '''
    __schema__ = schema
    __choices__ = ('LABELED_NUMERICS', 'ROW_COUNT', 'SINGLE_NUMERIC')


class QueryType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `read`: Filter for reads on the table
    * `write`: Filter for writes to the table
    '''
    __schema__ = schema
    __choices__ = ('read', 'write')


class RcaJobsModelJobType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DELTA_HISTORY_SAMPLING`: Delta History sampling
    * `FIELD_QUALITY_CORRELATION`: Field Quality Rule value
      correlation
    * `METRIC_CORRELATION`: Metric (Field Health) value correlation
    * `NUMERIC_CORRELATION`: Numeric (Field Health) value correlation
    * `SIZE_DIFF_CORRELATION`: Size Diff value correlation
    * `SIZE_DIFF_SAMPLING`: Size Diff sampling
    * `SQL_RULE_CUSTOM_SAMPLING`: SQL Rule custom sampling
    * `SQL_RULE_PROFILING`: SQL Rule sample data profiling
    '''
    __schema__ = schema
    __choices__ = ('DELTA_HISTORY_SAMPLING', 'FIELD_QUALITY_CORRELATION', 'METRIC_CORRELATION', 'NUMERIC_CORRELATION', 'SIZE_DIFF_CORRELATION', 'SIZE_DIFF_SAMPLING', 'SQL_RULE_CUSTOM_SAMPLING', 'SQL_RULE_PROFILING')


class RcaJobsModelStatus(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CANCELED`: canceled
    * `EMPTY`: No root cause found
    * `EXPIRED`: expired
    * `FAILED`: RCA process has failed
    * `FOUND`: Root cause has been found
    * `PARTIAL_DATA`: partial_data
    '''
    __schema__ = schema
    __choices__ = ('CANCELED', 'EMPTY', 'EXPIRED', 'FAILED', 'FOUND', 'PARTIAL_DATA')


class RcaStatus(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `CANCELED`None
    * `EMPTY`None
    * `EXPIRED`None
    * `FAILED`None
    * `FOUND`None
    * `PARTIAL_DATA`None
    '''
    __schema__ = schema
    __choices__ = ('CANCELED', 'EMPTY', 'EXPIRED', 'FAILED', 'FOUND', 'PARTIAL_DATA')


class RelationshipType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `EXPERT`None
    * `OWNER`None
    '''
    __schema__ = schema
    __choices__ = ('EXPERT', 'OWNER')


class ScheduleType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `DYNAMIC`None
    * `FIXED`None
    * `LOOSE`None
    * `MANUAL`None
    '''
    __schema__ = schema
    __choices__ = ('DYNAMIC', 'FIXED', 'LOOSE', 'MANUAL')


class SensitivityLevels(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `HIGH`None
    * `LOW`None
    * `MEDIUM`None
    '''
    __schema__ = schema
    __choices__ = ('HIGH', 'LOW', 'MEDIUM')


class SharedQueryTypeEnum(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `PERMANENT`None
    * `TEMPORARY`None
    '''
    __schema__ = schema
    __choices__ = ('PERMANENT', 'TEMPORARY')


class SlackAppType(sgqlc.types.Enum):
    '''Defines OBSERVE/DISCO types to support separate Slack apps

    Enumeration Choices:

    * `DISCOVER`None
    * `OBSERVE`None
    '''
    __schema__ = schema
    __choices__ = ('DISCOVER', 'OBSERVE')


class SlackCredentialsV2ModelSlackAppType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DISCOVER`: discover
    * `OBSERVE`: observe
    '''
    __schema__ = schema
    __choices__ = ('DISCOVER', 'OBSERVE')


class SlackEngagementEventType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CHANNEL_COMMENT`None
    * `REACTION_ADDED`None
    * `REACTION_REMOVED`None
    * `THREAD_REPLY`None
    '''
    __schema__ = schema
    __choices__ = ('CHANNEL_COMMENT', 'REACTION_ADDED', 'REACTION_REMOVED', 'THREAD_REPLY')


class SqlJobCheckpointStatus(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `EXECUTING_COMPLETE`None
    * `EXECUTING_START`None
    * `HAS_ERROR`None
    * `PROCESSING_COMPLETE`None
    * `PROCESSING_START`None
    * `REGISTERED`None
    '''
    __schema__ = schema
    __choices__ = ('EXECUTING_COMPLETE', 'EXECUTING_START', 'HAS_ERROR', 'PROCESSING_COMPLETE', 'PROCESSING_START', 'REGISTERED')


class State(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `APPLIED`None
    * `FAILED`None
    * `PENDING`None
    * `SKIPPED`None
    '''
    __schema__ = schema
    __choices__ = ('APPLIED', 'FAILED', 'PENDING', 'SKIPPED')


class StorageTypeEnum(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `AZURE_BLOB`None
    * `GCS`None
    * `S3`None
    '''
    __schema__ = schema
    __choices__ = ('AZURE_BLOB', 'GCS', 'S3')


class StreamingClusterModelClusterType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CONFLUENT_KAFKA`: Confluent Kafka
    * `CONFLUENT_KAFKA_CONNECT`: Confluent Kafka Connect
    '''
    __schema__ = schema
    __choices__ = ('CONFLUENT_KAFKA', 'CONFLUENT_KAFKA_CONNECT')


class StreamingSystemModelType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CONFLUENT_CLOUD`: Confluent Cloud
    '''
    __schema__ = schema
    __choices__ = ('CONFLUENT_CLOUD',)


String = sgqlc.types.String

class TableAnomalyModelReason(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `COMPARISON_RULE`: Comparison Rule Anomaly
    * `CUSTOM_RULE`: Custom Rule Anomaly
    * `DIST`: Distribution Anomaly
    * `FRESHNESS`: Freshness Anomaly
    * `METRIC`: Metric Anomaly
    * `QUERY_PERFORMANCE`: Query Performance Anomaly
    * `QUERY_RUNTIME`: Query Time Anomaly
    * `RULE_RUN_FAILURE`: Rule Run Failure Anomaly
    * `SIZE`: Size Anomaly
    * `SIZE_DIFF`: Row count anomaly
    * `UNCHANGED_SIZE`: Unchanged Size Anomaly
    '''
    __schema__ = schema
    __choices__ = ('COMPARISON_RULE', 'CUSTOM_RULE', 'DIST', 'FRESHNESS', 'METRIC', 'QUERY_PERFORMANCE', 'QUERY_RUNTIME', 'RULE_RUN_FAILURE', 'SIZE', 'SIZE_DIFF', 'UNCHANGED_SIZE')


class TableFieldToBiModelBiType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `TABLEAU_WORKBOOK`: Tableau Workbook
    '''
    __schema__ = schema
    __choices__ = ('TABLEAU_WORKBOOK',)


class TableFlagType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DEPRECATION`None
    * `WARNING`None
    '''
    __schema__ = schema
    __choices__ = ('DEPRECATION', 'WARNING')


class TableMonitorType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CUSTOM_SQL`None
    * `FRESHNESS`None
    * `SCHEMA`None
    * `VOLUME`None
    '''
    __schema__ = schema
    __choices__ = ('CUSTOM_SQL', 'FRESHNESS', 'SCHEMA', 'VOLUME')


class ThresholdModifierType(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `METRIC`None
    * `PERCENTAGE`None
    '''
    __schema__ = schema
    __choices__ = ('METRIC', 'PERCENTAGE')


class ThresholdStatus(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ACTIVE`None
    * `INACTIVE`None
    * `TRAINING`None
    '''
    __schema__ = schema
    __choices__ = ('ACTIVE', 'INACTIVE', 'TRAINING')


class ThresholdType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CUSTOM`None
    * `FIELD_HEALTH`None
    * `FRESHNESS`None
    * `ROWS`None
    * `SIZE_DIFF`None
    * `UNCHANGED_SIZE`None
    '''
    __schema__ = schema
    __choices__ = ('CUSTOM', 'FIELD_HEALTH', 'FRESHNESS', 'ROWS', 'SIZE_DIFF', 'UNCHANGED_SIZE')


class UUID(sgqlc.types.Scalar):
    '''Leverages the internal Python implmeentation of UUID (uuid.UUID)
    to provide native UUID objects in fields, resolvers and input.
    '''
    __schema__ = schema


class UnifiedUserAssignmentModelRelationshipType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `EXPERT`: Expert
    * `OWNER`: Owner
    '''
    __schema__ = schema
    __choices__ = ('EXPERT', 'OWNER')


class Upload(sgqlc.types.Scalar):
    '''Create scalar that ignores normal serialization/deserialization,
    since that will be handled by the multipart request spec
    '''
    __schema__ = schema


class UserDefinedMonitorModelMonitorType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CATEGORIES`: Dimension Tracking
    * `COMPARISON`: Comparison Rule
    * `CUSTOM_SQL`: SQL Rule
    * `FIELD_QUALITY`: Field Quality Rule
    * `FRESHNESS`: Freshness Rule
    * `HOURLY_STATS`: Statistical metrics over an hour interval
    * `JSON_SCHEMA`: JSON Schema
    * `QUERY_PERF`: Query Performance Rule
    * `STATS`: Field Health
    * `TABLE_METRIC`: Table Metric Rule
    * `VOLUME`: Volume Rule
    '''
    __schema__ = schema
    __choices__ = ('CATEGORIES', 'COMPARISON', 'CUSTOM_SQL', 'FIELD_QUALITY', 'FRESHNESS', 'HOURLY_STATS', 'JSON_SCHEMA', 'QUERY_PERF', 'STATS', 'TABLE_METRIC', 'VOLUME')


class UserDefinedMonitorModelScheduleType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DYNAMIC`: Dynamic
    * `FIXED`: Fixed
    * `LOOSE`: Loose
    * `MANUAL`: Manual
    '''
    __schema__ = schema
    __choices__ = ('DYNAMIC', 'FIXED', 'LOOSE', 'MANUAL')


class UserDefinedMonitorModelUdmType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `MONITOR`: MONITOR
    * `RULE`: RULE
    '''
    __schema__ = schema
    __choices__ = ('MONITOR', 'RULE')


class UserDefinedMonitorSearchFields(sgqlc.types.Enum):
    '''Defines which fields can be used for full text search in the user
    defined monitors view

    Enumeration Choices:

    * `CREATOR_ID`None
    * `ENTITIES`None
    * `MONITOR_FIELDS`None
    * `NAMESPACE`None
    * `RULE_DESCRIPTION`None
    * `RULE_NAME`None
    * `UPDATER_ID`None
    '''
    __schema__ = schema
    __choices__ = ('CREATOR_ID', 'ENTITIES', 'MONITOR_FIELDS', 'NAMESPACE', 'RULE_DESCRIPTION', 'RULE_NAME', 'UPDATER_ID')


class UserDefinedMonitors(sgqlc.types.Enum):
    '''Enumeration Choices:

    * `CATEGORIES`None
    * `COMPARISON`None
    * `CUSTOM_SQL`None
    * `FIELD_QUALITY`None
    * `FRESHNESS`None
    * `JSON_SCHEMA`None
    * `QUERY_PERF`None
    * `STATS`None
    * `TABLE_METRIC`None
    * `VOLUME`None
    '''
    __schema__ = schema
    __choices__ = ('CATEGORIES', 'COMPARISON', 'CUSTOM_SQL', 'FIELD_QUALITY', 'FRESHNESS', 'JSON_SCHEMA', 'QUERY_PERF', 'STATS', 'TABLE_METRIC', 'VOLUME')


class UserInviteModelInviteType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DISCOVERY`: discovery
    * `OBSERVABILITY`: observability
    '''
    __schema__ = schema
    __choices__ = ('DISCOVERY', 'OBSERVABILITY')


class UserInviteModelState(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `ACCEPTED`: Accepted
    * `INVALIDATED`: Invalidated
    * `SENT`: Sent
    '''
    __schema__ = schema
    __choices__ = ('ACCEPTED', 'INVALIDATED', 'SENT')


class UserModelPersona(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `BI_ANALYST_ENGINEER`: bi_analyst_or_engineer
    * `DATA_ANALYST`: data_analyst
    * `DATA_ENGINEER`: data_engineer
    * `EXECUTIVE`: executive
    * `OTHER`: other
    * `PRODUCT_MANAGER_OWNER`: product_manager_or_owner
    * `SOFTWARE_ENGINEER`: software_engineer
    * `TEAM_LEAD`: team_lead
    '''
    __schema__ = schema
    __choices__ = ('BI_ANALYST_ENGINEER', 'DATA_ANALYST', 'DATA_ENGINEER', 'EXECUTIVE', 'OTHER', 'PRODUCT_MANAGER_OWNER', 'SOFTWARE_ENGINEER', 'TEAM_LEAD')


class UserModelState(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `CHECK_BACK`: Check Back Soon
    * `CONNECT_DW`: Connect Data Warehouse
    * `DASHBOARD`: View Dashboard
    * `INSTALL_DC`: Install Data Collector
    * `INTEGRATIONS`: Other integrations
    * `NOT_AVAILABLE`: Not available
    * `SET_ACCOUNT_NAME`: Set Account Name
    * `SIGNED_UP`: Signed-Up
    '''
    __schema__ = schema
    __choices__ = ('CHECK_BACK', 'CONNECT_DW', 'DASHBOARD', 'INSTALL_DC', 'INTEGRATIONS', 'NOT_AVAILABLE', 'SET_ACCOUNT_NAME', 'SIGNED_UP')


class UserPersona(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `BI_ANALYST_ENGINEER`None
    * `DATA_ANALYST`None
    * `DATA_ENGINEER`None
    * `EXECUTIVE`None
    * `OTHER`None
    * `PRODUCT_MANAGER_OWNER`None
    * `SOFTWARE_ENGINEER`None
    * `TEAM_LEAD`None
    '''
    __schema__ = schema
    __choices__ = ('BI_ANALYST_ENGINEER', 'DATA_ANALYST', 'DATA_ENGINEER', 'EXECUTIVE', 'OTHER', 'PRODUCT_MANAGER_OWNER', 'SOFTWARE_ENGINEER', 'TEAM_LEAD')


class WarehouseModelConnectionType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `BIGQUERY`: BigQuery
    * `DATA_LAKE`: Data Lake
    * `ETL`: etl
    * `REDSHIFT`: Amazon Redshift
    * `S3_METADATA_EVENTS`: S3 Metadata Events
    * `SNOWFLAKE`: Snowflake
    * `TRANSACTIONAL_DB`: Transactional DB
    '''
    __schema__ = schema
    __choices__ = ('BIGQUERY', 'DATA_LAKE', 'ETL', 'REDSHIFT', 'S3_METADATA_EVENTS', 'SNOWFLAKE', 'TRANSACTIONAL_DB')


class WarehouseTableModelStatus(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `G`: Green
    * `R`: Red
    * `Y`: Yellow
    '''
    __schema__ = schema
    __choices__ = ('G', 'R', 'Y')


class WidgetType(sgqlc.types.Enum):
    '''An enumeration.

    Enumeration Choices:

    * `DISCRETE`None
    * `NUMERIC_CONTINUOUS`None
    * `TIMESTAMP_HISTOGRAM`None
    '''
    __schema__ = schema
    __choices__ = ('DISCRETE', 'NUMERIC_CONTINUOUS', 'TIMESTAMP_HISTOGRAM')



########################################################################
# Input Objects
########################################################################
class AIMessageInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('message', 'actor', 'mcons')
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='message')
    '''Message from the specified actor'''

    actor = sgqlc.types.Field(sgqlc.types.non_null(ActorType), graphql_name='actor')
    '''The actor that sends the message'''

    mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='mcons')
    '''The mcons for the tables added in this message'''



class AirflowConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('host_name',)
    host_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='hostName')
    '''Airflow host name'''



class AirflowEnvInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('env_name', 'env_id', 'version', 'base_url')
    env_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='envName')
    '''Environment name'''

    env_id = sgqlc.types.Field(String, graphql_name='envId')

    version = sgqlc.types.Field(String, graphql_name='version')

    base_url = sgqlc.types.Field(String, graphql_name='baseUrl')



class ApiCallReference(sgqlc.types.Input):
    '''References (For instance UUIDs) that were passed as input to
    GraphQL API calls
    '''
    __schema__ = schema
    __field_names__ = ('parameter_name', 'parameter_value', 'parameter_values')
    parameter_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='parameterName')
    '''Name of the parameter'''

    parameter_value = sgqlc.types.Field(String, graphql_name='parameterValue')
    '''Value of the parameter. If provided, `parameter_values` will be
    ignored
    '''

    parameter_values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='parameterValues')
    '''List of values for the parameter'''



class AssetsUsageFilterOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('only_ingested_tables', 'only_not_ingested_tables', 'only_monitored_tables', 'only_not_monitored_tables', 'only_ingested_schemas', 'only_not_ingested_schemas')
    only_ingested_tables = sgqlc.types.Field(Boolean, graphql_name='onlyIngestedTables')
    '''To filter results that only has ingested tables.'''

    only_not_ingested_tables = sgqlc.types.Field(Boolean, graphql_name='onlyNotIngestedTables')
    '''To filter results that only does not have ingested tables.'''

    only_monitored_tables = sgqlc.types.Field(Boolean, graphql_name='onlyMonitoredTables')
    '''To filter results that only has monitored tables.'''

    only_not_monitored_tables = sgqlc.types.Field(Boolean, graphql_name='onlyNotMonitoredTables')
    '''To filter results that only does not have monitored tables.'''

    only_ingested_schemas = sgqlc.types.Field(Boolean, graphql_name='onlyIngestedSchemas')
    '''To filter results that only has ingested schemas.'''

    only_not_ingested_schemas = sgqlc.types.Field(Boolean, graphql_name='onlyNotIngestedSchemas')
    '''To filter results that only does not have ingested schemas.'''



class AudienceNotificationSettingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('recipients', 'notification_type', 'extra', 'audience_id', 'integration_id', 'uuid')
    recipients = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='recipients')
    '''Destination to send notifications to'''

    notification_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='notificationType')
    '''emailSpecify the notification integration to use. Supported
    options include: , mattermostSpecify the notification integration
    to use. Supported options include: , opsgenieSpecify the
    notification integration to use. Supported options include: ,
    pagerdutySpecify the notification integration to use. Supported
    options include: , slackSpecify the notification integration to
    use. Supported options include: , slack_v2Specify the notification
    integration to use. Supported options include: , webhookSpecify
    the notification integration to use. Supported options include: ,
    msteamsSpecify the notification integration to use. Supported
    options include: , alationSpecify the notification integration to
    use. Supported options include: , servicenowSpecify the
    notification integration to use. Supported options include: ,
    jiraSpecify the notification integration to use. Supported options
    include: , webex
    '''

    extra = sgqlc.types.Field('NotificationExtra', graphql_name='extra')
    '''Any extra values'''

    audience_id = sgqlc.types.Field(UUID, graphql_name='audienceId')
    '''Audience associated with the recipient'''

    integration_id = sgqlc.types.Field(UUID, graphql_name='integrationId')
    '''Integration ID for the recipient'''

    uuid = sgqlc.types.Field(UUID, graphql_name='uuid')
    '''For updating a notification setting'''



class BiWarehouseSourcesInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('warehouse_resource_id', 'warehouse_resource_type', 'bi_warehouse_id')
    warehouse_resource_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='warehouseResourceId')
    '''Warehouse resource ID. This is a Monte Carlo ID'''

    warehouse_resource_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='warehouseResourceType')
    '''Warehouse type. Examples: snowflake, redshift, etc.'''

    bi_warehouse_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='biWarehouseId')
    '''The warehouse ID in the BI instance of the customer. This is an ID
    in the customer ID space and is not a Monte Carlo ID.
    '''



class BqConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('service_json',)
    service_json = sgqlc.types.Field(String, graphql_name='serviceJson')
    '''Service account key file as a base64 string'''



class BulkUpdateIncidentsValues(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('severity', 'owner', 'feedback')
    severity = sgqlc.types.Field(String, graphql_name='severity')

    owner = sgqlc.types.Field(String, graphql_name='owner')

    feedback = sgqlc.types.Field(String, graphql_name='feedback')



class CollectionBlockInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('resource_id', 'project', 'dataset')
    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceId')
    '''The resource UUID this collection block applies to.'''

    project = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='project')
    '''Top-level object hierarchy e.g. database, catalog, etc.'''

    dataset = sgqlc.types.Field(String, graphql_name='dataset')
    '''Intermediate object hierarchy e.g. schema, database, etc.'''



class CollectionBlockListParentScopeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('resource_id', 'project', 'dataset')
    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceId')
    '''Warehouse to scope the rules to'''

    project = sgqlc.types.Field(String, graphql_name='project')
    '''Project/database to scope the rules to'''

    dataset = sgqlc.types.Field(String, graphql_name='dataset')
    '''Dataset/schema to scope the rules to'''



class ConfluentKafkaConnectCredentialsInput(sgqlc.types.Input):
    '''Credentials to Confluent Connect APIs'''
    __schema__ = schema
    __field_names__ = ('confluent_env', 'cluster', 'api_key', 'secret', 'url')
    confluent_env = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='confluentEnv')
    '''Confluent environment.'''

    cluster = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cluster')
    '''Confluent Kafka cluster in which the connectors are defined.'''

    api_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='apiKey')
    '''Confluent Cloud API key.'''

    secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='secret')
    '''Confluent Cloud Api key's secret.'''

    url = sgqlc.types.Field(String, graphql_name='url')
    '''URL for the Confluent Connect.'''



class ConfluentKafkaCredentialsInput(sgqlc.types.Input):
    '''Credentials to a Confluent Kafka Cluster'''
    __schema__ = schema
    __field_names__ = ('cluster', 'api_key', 'secret', 'url')
    cluster = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cluster')
    '''Confluent Kafka cluster.'''

    api_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='apiKey')
    '''Confluent Kafka API key.'''

    secret = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='secret')
    '''Confluent Kafka Api key's secret.'''

    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='url')
    '''URL for the Confluent kafka cluster.'''



class ConnectionTestOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('dc_id', 'skip_validation', 'skip_permission_tests', 'test_options')
    dc_id = sgqlc.types.Field(UUID, graphql_name='dcId')
    '''DC UUID. To disambiguate accounts with multiple collectors.'''

    skip_validation = sgqlc.types.Field(Boolean, graphql_name='skipValidation')
    '''Skip all connection tests.'''

    skip_permission_tests = sgqlc.types.Field(Boolean, graphql_name='skipPermissionTests')
    '''Skips all permission tests for the service account/role for
    anysupported integrations. Only validates network connection
    between the DC and resource can be established.
    '''

    test_options = sgqlc.types.Field('ValidatorTestOptions', graphql_name='testOptions')
    '''Specify tests to run (Redshift only).'''



class CreatedByFilters(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('created_by', 'is_template_managed', 'namespace', 'rule_name')
    created_by = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='createdBy')
    '''Emails of users who created monitors to filter by'''

    is_template_managed = sgqlc.types.Field(Boolean, graphql_name='isTemplateManaged')
    '''Filter only by monitors created with monitor-as-code (if true)'''

    namespace = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='namespace')
    '''Filter by namespace name (for monitors created via monitor-as-
    code)
    '''

    rule_name = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='ruleName')
    '''Filter by rule names (for monitors created via monitor-as-code)'''



class CriteriaInput(sgqlc.types.Input):
    '''Filtering criteria, specified by data type'''
    __schema__ = schema
    __field_names__ = ('string_filters', 'timestamp_filters', 'numeric_filters', 'custom_where_clause')
    string_filters = sgqlc.types.Field(sgqlc.types.list_of('StringFilterInput'), graphql_name='stringFilters')
    '''String filters'''

    timestamp_filters = sgqlc.types.Field(sgqlc.types.list_of('TimestampFilterInput'), graphql_name='timestampFilters')
    '''Timestamp filters'''

    numeric_filters = sgqlc.types.Field(sgqlc.types.list_of('NumericFilterInput'), graphql_name='numericFilters')
    '''Numeric filters'''

    custom_where_clause = sgqlc.types.Field(String, graphql_name='customWhereClause')
    '''Custom where clause'''



class CustomRuleComparisonInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('comparison_type', 'full_table_id', 'full_table_ids', 'mcon', 'field', 'metric', 'operator', 'threshold', 'baseline_agg_function', 'baseline_interval_minutes', 'is_threshold_relative', 'threshold_lookback_minutes', 'threshold_ref', 'min_buffer', 'max_buffer', 'number_of_agg_periods', 'threshold_lookback_data_points')
    comparison_type = sgqlc.types.Field(ComparisonType, graphql_name='comparisonType')

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')

    full_table_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='fullTableIds')

    mcon = sgqlc.types.Field(String, graphql_name='mcon')

    field = sgqlc.types.Field(String, graphql_name='field')

    metric = sgqlc.types.Field(String, graphql_name='metric')

    operator = sgqlc.types.Field(sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name='operator')
    '''Comparison operator'''

    threshold = sgqlc.types.Field(Float, graphql_name='threshold')
    '''Threshold value'''

    baseline_agg_function = sgqlc.types.Field(AggregationFunction, graphql_name='baselineAggFunction')
    '''Function used to aggregate historical data points to calculate
    baseline
    '''

    baseline_interval_minutes = sgqlc.types.Field(Int, graphql_name='baselineIntervalMinutes')
    '''Time interval to aggregate over to calculate baseline.'''

    is_threshold_relative = sgqlc.types.Field(Boolean, graphql_name='isThresholdRelative')
    '''True, if threshold is a relative percentage change of baseline.
    False, if threshold is absolute change
    '''

    threshold_lookback_minutes = sgqlc.types.Field(Int, graphql_name='thresholdLookbackMinutes')
    '''Time to look back for rules which compare current and past values.'''

    threshold_ref = sgqlc.types.Field(String, graphql_name='thresholdRef')
    '''Key used to retrieve the threshold values from external source'''

    min_buffer = sgqlc.types.Field('ThresholdModifierInput', graphql_name='minBuffer')
    '''The lower bound buffer to modify the alert threshold.'''

    max_buffer = sgqlc.types.Field('ThresholdModifierInput', graphql_name='maxBuffer')
    '''The upper bound buffer to modify the alert threshold.'''

    number_of_agg_periods = sgqlc.types.Field(Int, graphql_name='numberOfAggPeriods')
    '''The number of periods to use in the aggregate comparison for
    Volume Growth comparisons.
    '''

    threshold_lookback_data_points = sgqlc.types.Field(Int, graphql_name='thresholdLookbackDataPoints')
    '''Number of data points to look back for rules which compare current
    and past values.
    '''



class CustomRuleSnoozeInput(sgqlc.types.Input):
    '''input variables for snoozing'''
    __schema__ = schema
    __field_names__ = ('rule_uuid', 'snooze_minutes', 'conditional_snooze')
    rule_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='ruleUuid')
    '''UUID of rule to snooze'''

    snooze_minutes = sgqlc.types.Field(Int, graphql_name='snoozeMinutes')
    '''number of minutes to snooze rule'''

    conditional_snooze = sgqlc.types.Field(Boolean, graphql_name='conditionalSnooze')
    '''snooze rule until breach condition changes or is resolved'''



class DataExplorerComparisonDashboardInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('uuid', 'warehouse_uuid', 'name', 'dashboard_left', 'dashboard_right', 'widgets', 'criteria')
    uuid = sgqlc.types.Field(UUID, graphql_name='uuid')
    '''UUID of comparison dashboard, required if updating existing object'''

    warehouse_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='warehouseUuid')
    '''UUID of warehouse'''

    name = sgqlc.types.Field(String, graphql_name='name')
    '''Descriptive name'''

    dashboard_left = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dashboardLeft')
    '''First dashboard to be compared'''

    dashboard_right = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dashboardRight')
    '''Second dashboard to be compared'''

    widgets = sgqlc.types.Field(sgqlc.types.list_of('DataExplorerWidgetInputType'), graphql_name='widgets')

    criteria = sgqlc.types.Field(JSONString, graphql_name='criteria')
    '''Saved criteria'''



class DataExplorerDashboardInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('uuid', 'warehouse_uuid', 'mcon', 'name', 'time_axis_field_name', 'base_where_clause', 'widgets', 'criteria')
    uuid = sgqlc.types.Field(UUID, graphql_name='uuid')
    '''UUID of dashboard, required if updating existing object'''

    warehouse_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='warehouseUuid')
    '''UUID of warehouse'''

    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''MCON of underlying warehouse table'''

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''Descriptive name of dashboard'''

    time_axis_field_name = sgqlc.types.Field(String, graphql_name='timeAxisFieldName')
    '''Time axis field name'''

    base_where_clause = sgqlc.types.Field(String, graphql_name='baseWhereClause')
    '''Base where clause'''

    widgets = sgqlc.types.Field(sgqlc.types.list_of('DataExplorerWidgetInputType'), graphql_name='widgets')
    '''Configured widgets'''

    criteria = sgqlc.types.Field(JSONString, graphql_name='criteria')
    '''Saved criteria'''



class DataExplorerWidgetInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'widget_type', 'config')
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')
    '''Field name visualized by this widget'''

    widget_type = sgqlc.types.Field(sgqlc.types.non_null(WidgetType), graphql_name='widgetType')
    '''Type of widget'''

    config = sgqlc.types.Field(JSONString, graphql_name='config')
    '''Additional configuration for widget'''



class DatabricksSqlWarehouseConnectionInput(sgqlc.types.Input):
    '''Credentials and connection details to a Databricks SQL warehouse
    connection
    '''
    __schema__ = schema
    __field_names__ = ('dc_id', 'databricks_config')
    dc_id = sgqlc.types.Field(UUID, graphql_name='dcId')
    '''The Data Collector UUID for a new Databricks Connection'''

    databricks_config = sgqlc.types.Field('DatabricksSqlWarehouseInput', graphql_name='databricksConfig')
    '''Configuration for Databricks.'''



class DatabricksSqlWarehouseInput(sgqlc.types.Input):
    '''Credentials to a Databricks sql warehouse.'''
    __schema__ = schema
    __field_names__ = ('databricks_workspace_url', 'databricks_warehouse_id', 'databricks_token')
    databricks_workspace_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='databricksWorkspaceUrl')
    '''Databricks workspace URL'''

    databricks_warehouse_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='databricksWarehouseId')
    '''Databricks warehouse ID'''

    databricks_token = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='databricksToken')
    '''User token'''



class DatasetInput(sgqlc.types.Input):
    '''Specifies base table + criteria for dashboard/widget'''
    __schema__ = schema
    __field_names__ = ('mcon', 'criteria', 'base_where_clause')
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''MCON of underlying table'''

    criteria = sgqlc.types.Field(CriteriaInput, graphql_name='criteria')
    '''Filtering criteria'''

    base_where_clause = sgqlc.types.Field(String, graphql_name='baseWhereClause')
    '''Base where clause'''



class DbtArtifactsInput(sgqlc.types.Input):
    '''dbt artifacts'''
    __schema__ = schema
    __field_names__ = ('manifest', 'run_results', 'logs')
    manifest = sgqlc.types.Field(String, graphql_name='manifest')
    '''manifest file name'''

    run_results = sgqlc.types.Field(String, graphql_name='runResults')
    '''run results file name'''

    logs = sgqlc.types.Field(String, graphql_name='logs')
    '''logs file name'''



class FieldMetricFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'operator', 'value')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field to filter by'''

    operator = sgqlc.types.Field(sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name='operator')
    '''Operator to filter field by'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Value to filter field by'''



class FieldMetricInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('table_mcon', 'table_mcons', 'field_name', 'field_names', 'metric_type', 'value_list', 'value_sql', 'filters')
    table_mcon = sgqlc.types.Field(String, graphql_name='tableMcon')
    '''MCON of the table the metric is based on'''

    table_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='tableMcons')
    '''MCONs of the table the metric is based on'''

    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Name of the field the metric is based on'''

    field_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='fieldNames')
    '''Name of the fields the metric is based on'''

    metric_type = sgqlc.types.Field(sgqlc.types.non_null(FieldMetricType), graphql_name='metricType')
    '''Type of metric to compute'''

    value_list = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='valueList')
    '''Values for metrics that check for cardinality'''

    value_sql = sgqlc.types.Field(String, graphql_name='valueSql')
    '''Values SQL expression for metrics that check for cardinality'''

    filters = sgqlc.types.Field(sgqlc.types.list_of(FieldMetricFilterInput), graphql_name='filters')
    '''Filters for which rows the metric is computed over'''



class FieldQueryFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'operator', 'value')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field to filter by'''

    operator = sgqlc.types.Field(sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name='operator')
    '''Operator to filter field by'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Value to filter field by'''



class FieldQueryParametersInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('table_mcons', 'field_names', 'query_type', 'value_list', 'value_sql', 'filters')
    table_mcons = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='tableMcons')
    '''MCONs of the table the query is based on'''

    field_names = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='fieldNames')
    '''Name of the fields the query is based on'''

    query_type = sgqlc.types.Field(sgqlc.types.non_null(FieldQueryType), graphql_name='queryType')
    '''Type of query'''

    value_list = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='valueList')
    '''Values for queries that check for cardinality'''

    value_sql = sgqlc.types.Field(String, graphql_name='valueSql')
    '''Values SQL expression for metrics that check for cardinality'''

    filters = sgqlc.types.Field(sgqlc.types.list_of(FieldQueryFilterInput), graphql_name='filters')
    '''Filters for which rows the query is computed over'''



class GetExplanationForEventRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('event_uuid', 'start_time', 'end_time')
    event_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='eventUuid')
    '''Event UUID'''

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''Start time range. By default, current time - 4 weeks'''

    end_time = sgqlc.types.Field(DateTime, graphql_name='endTime')
    '''End time range. By default, current time'''



class GetExplanationRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('query_group', 'start_time', 'end_time')
    query_group = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryGroup')
    '''Query group hash'''

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''Start time range. By default, current time - 4 weeks'''

    end_time = sgqlc.types.Field(DateTime, graphql_name='endTime')
    '''End time range. By default, current time'''



class ImportanceScoreTableStatsRule(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('operator', 'value', 'value_min', 'value_max')
    operator = sgqlc.types.Field(sgqlc.types.non_null(ImportanceScoreOperator), graphql_name='operator')
    '''Comparison operator. Options include ==, >=, <=, >, <, RANGE'''

    value = sgqlc.types.Field(Float, graphql_name='value')

    value_min = sgqlc.types.Field(Float, graphql_name='valueMin')

    value_max = sgqlc.types.Field(Float, graphql_name='valueMax')



class IncidentReactionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('type', 'reasons', 'notes', 'adapt_model')
    type = sgqlc.types.Field(sgqlc.types.non_null(IncidentReactionType), graphql_name='type')

    reasons = sgqlc.types.Field(sgqlc.types.list_of(IncidentReactionReason), graphql_name='reasons')

    notes = sgqlc.types.Field(String, graphql_name='notes')
    '''Tell us more about how we can improve this incident.'''

    adapt_model = sgqlc.types.Field(Boolean, graphql_name='adaptModel')
    '''Enable if this reaction should be used to adapt our models.'''



class IncidentsFilterDataFilterType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'value')
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')

    value = sgqlc.types.Field(sgqlc.types.non_null(GenericScalar), graphql_name='value')



class IncidentsFilterDataRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'search_criteria', 'first', 'after', 'search_value')
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')

    search_criteria = sgqlc.types.Field(sgqlc.types.non_null('IncidentsFilterDataSearchCriteriaType'), graphql_name='searchCriteria')

    first = sgqlc.types.Field(Int, graphql_name='first')
    '''Number of results to return'''

    after = sgqlc.types.Field(String, graphql_name='after')
    '''Cursor to paginate results'''

    search_value = sgqlc.types.Field(String, graphql_name='searchValue')
    '''Respond with filter values which contain this text'''



class IncidentsFilterDataSearchCriteriaType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('start_time', 'end_time', 'filters')
    start_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='startTime')
    '''filter for incidents after or equal to this time'''

    end_time = sgqlc.types.Field(DateTime, graphql_name='endTime')
    '''filter for incidents before this time'''

    filters = sgqlc.types.Field(sgqlc.types.list_of(IncidentsFilterDataFilterType), graphql_name='filters')
    '''List of filters to apply to incidents'''



class IndexedFieldFilterType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'values', 'operator')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field name'''

    values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='values')
    '''Values to filter by'''

    operator = sgqlc.types.Field(FieldValueFilterOperator, graphql_name='operator')
    '''comparison operator to use when filtering'''



class InputFilterOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('only_ingested_tables', 'only_not_ingested_tables', 'only_monitored_tables', 'only_not_monitored_tables', 'only_ingested_schemas', 'only_not_ingested_schemas')
    only_ingested_tables = sgqlc.types.Field(Boolean, graphql_name='onlyIngestedTables')
    '''To filter results that only has ingested tables.'''

    only_not_ingested_tables = sgqlc.types.Field(Boolean, graphql_name='onlyNotIngestedTables')
    '''To filter results that only does not have ingested tables.'''

    only_monitored_tables = sgqlc.types.Field(Boolean, graphql_name='onlyMonitoredTables')
    '''To filter results that only has monitored tables.'''

    only_not_monitored_tables = sgqlc.types.Field(Boolean, graphql_name='onlyNotMonitoredTables')
    '''To filter results that only does not have monitored tables.'''

    only_ingested_schemas = sgqlc.types.Field(Boolean, graphql_name='onlyIngestedSchemas')
    '''To filter results that only has ingested schemas.'''

    only_not_ingested_schemas = sgqlc.types.Field(Boolean, graphql_name='onlyNotIngestedSchemas')
    '''To filter results that only does not have ingested schemas.'''



class InputObjectProperty(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('mcon_id', 'property_name', 'property_value', 'property_source_type')
    mcon_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mconId')
    '''Monte Carlo full identifier for an entity'''

    property_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='propertyName')
    '''Name of the property (AKA tag key)'''

    property_value = sgqlc.types.Field(String, graphql_name='propertyValue')
    '''Value of the property (AKA tag value)'''

    property_source_type = sgqlc.types.Field(String, graphql_name='propertySourceType')
    '''Where property originated.'''



class InviteUsersInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('emails', 'client_mutation_id')
    emails = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='emails')

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class IsImportantTableStatsRule(sgqlc.types.Input):
    '''The key asset rule matches the is_important table stat'''
    __schema__ = schema
    __field_names__ = ('value',)
    value = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='value')



class JiraStatusMappingInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('incident_feedback', 'jira_status')
    incident_feedback = sgqlc.types.Field(String, graphql_name='incidentFeedback')
    '''The feedback that will be set on the Monte Carlo incident if the
    Jira ticket is set to any of the provided Jira statuses
    '''

    jira_status = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='jiraStatus')
    '''The Jira statuses that will map to the Monte Carlo incident
    feedback
    '''



class JiraWebhookConfigInput(sgqlc.types.Input):
    '''Jira webhook config'''
    __schema__ = schema
    __field_names__ = ('status_mappings',)
    status_mappings = sgqlc.types.Field(sgqlc.types.list_of(JiraStatusMappingInput), graphql_name='statusMappings')
    '''Status mapping'''



class LookerConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('base_url', 'client_id', 'client_secret', 'verify_ssl')
    base_url = sgqlc.types.Field(String, graphql_name='baseUrl')
    '''Host url'''

    client_id = sgqlc.types.Field(String, graphql_name='clientId')
    '''Looker client id'''

    client_secret = sgqlc.types.Field(String, graphql_name='clientSecret')
    '''Looker client secret'''

    verify_ssl = sgqlc.types.Field(Boolean, graphql_name='verifySsl')
    '''Verify SSL (uncheck for self-signed certs)'''



class LookerGitCloneConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('repo_url', 'username', 'token')
    repo_url = sgqlc.types.Field(String, graphql_name='repoUrl')
    '''Repository URL as https://server/project.git'''

    username = sgqlc.types.Field(String, graphql_name='username')
    '''The git username'''

    token = sgqlc.types.Field(String, graphql_name='token')
    '''The access token for git HTTPS integrations'''



class LookerGitSshConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('ssh_key', 'repo_url')
    ssh_key = sgqlc.types.Field(String, graphql_name='sshKey')
    '''SSH key, base64-encoded'''

    repo_url = sgqlc.types.Field(String, graphql_name='repoUrl')
    '''Repository URL as ssh://[user@]server/project.git or the shorter
    form [user@]server:project.git
    '''



class MetricAggregationInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('metric', 'aggregation')
    metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='metric')
    '''Query performance metric'''

    aggregation = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='aggregation')
    '''Metric aggregation function'''



class MetricDimensionFilter(sgqlc.types.Input):
    '''Filter in key value pairs that would be applied in dimensions'''
    __schema__ = schema
    __field_names__ = ('key', 'value', 'value_str')
    key = sgqlc.types.Field(String, graphql_name='key')
    '''name of the dimension.'''

    value = sgqlc.types.Field(Float, graphql_name='value')
    '''float value field.'''

    value_str = sgqlc.types.Field(String, graphql_name='valueStr')
    '''string value field. This field and value field should be exclusive'''



class MetricsFilter(sgqlc.types.Input):
    '''Filters for the metrics to be fetched'''
    __schema__ = schema
    __field_names__ = ('monitor_id', 'mcon', 'full_table_id', 'dw_id', 'segments_filter', 'field', 'ootb')
    monitor_id = sgqlc.types.Field(UUID, graphql_name='monitorId')
    '''UUID of the monitor or custom rule'''

    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''MCON of the asset tracked by the metrics to be fetched'''

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')
    '''Full table ID of the table tracked by the metrics to be fetched'''

    dw_id = sgqlc.types.Field(UUID, graphql_name='dwId')
    '''Warehouse UUID of the asset tracked by the metrics to be fetched'''

    segments_filter = sgqlc.types.Field(sgqlc.types.list_of('SegmentsFilter'), graphql_name='segmentsFilter')
    '''Values of segments for filtering based on segments'''

    field = sgqlc.types.Field(String, graphql_name='field')
    '''Field name for filtering based on fields for field health monitors'''

    ootb = sgqlc.types.Field(Boolean, graphql_name='ootb')
    '''Indicates whether to get the datapoints for out-of-the-box metric.
    If this is true, then the monitor_id parameter will be ignored.
    '''



class ModifyCollectionBlockListInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('id', 'resource_id', 'project', 'dataset', 'table_name', 'match_type', 'effect')
    id = sgqlc.types.Field(String, graphql_name='id')
    '''ID of the rule. If provided, the rule will be updated instead of
    created.
    '''

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceId')
    '''Warehouse that the collection preference belongs to.'''

    project = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='project')
    '''Value used to match against project/database.'''

    dataset = sgqlc.types.Field(String, graphql_name='dataset')
    '''Value used to match against dataset/schema.'''

    table_name = sgqlc.types.Field(String, graphql_name='tableName')
    '''Value used to match against table name.'''

    match_type = sgqlc.types.Field(sgqlc.types.non_null(CollectionPreferenceMatchType), graphql_name='matchType')

    effect = sgqlc.types.Field(CollectionPreferenceEffectType, graphql_name='effect')



class MonitorConfigurationInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('mcon', 'time_fields')
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''MC mcon'''

    time_fields = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('TimestampResult')), graphql_name='timeFields')
    '''field and timestamp for monitor configuration'''



class MonitorSelectExpressionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('expression', 'data_type')
    expression = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='expression')
    '''SQL select expression, could be a raw column name or a more
    complex expression
    '''

    data_type = sgqlc.types.Field(String, graphql_name='dataType')
    '''Data type of expression. Required if expression is a complex
    expression and not a raw column name
    '''



class MonitoredTableRuleInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('is_exclude', 'rule_type', 'table_rule_text', 'id')
    is_exclude = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isExclude')
    '''Whether the rule is an exclusion rule'''

    rule_type = sgqlc.types.Field(sgqlc.types.non_null(MonitoredTableRuleType), graphql_name='ruleType')
    '''Type of rule'''

    table_rule_text = sgqlc.types.Field(String, graphql_name='tableRuleText')
    '''The rule. If rule_type=ALL, this field must be empty.'''

    id = sgqlc.types.Field(String, graphql_name='id')
    '''ID of the rule. If provided, the rule will be updated instead of
    created.
    '''



class NodeInput(sgqlc.types.Input):
    '''Minimal information to identify a node'''
    __schema__ = schema
    __field_names__ = ('object_type', 'object_id', 'resource_id', 'resource_name')
    object_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='objectType')
    '''Object type'''

    object_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='objectId')
    '''Object identifier'''

    resource_id = sgqlc.types.Field(UUID, graphql_name='resourceId')
    '''The id of the resource containing the node'''

    resource_name = sgqlc.types.Field(String, graphql_name='resourceName')
    '''The name of the resource containing the node'''



class NotificationDigestSettings(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('start_time', 'interval_minutes', 'digest_type')
    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''Start time of scheduled digest. If not set, by default it is UTC
    00:00 daily
    '''

    interval_minutes = sgqlc.types.Field(Int, graphql_name='intervalMinutes')
    '''Interval of how frequently to run the schedule. If not set, by
    default it is 1440 minutes(24h)
    '''

    digest_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='digestType')
    '''Type of digest.Supported options include: anomalies_digest,
    misconf_digest, inactive_digest
    '''



class NotificationExtra(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('slack_is_private', 'webhook_shared_secret', 'webhook_encrypted_secret', 'team_id', 'team_name', 'priority', 'url', 'username', 'password', 'dc_proxy', 'turn_off_normalized_messages', 'disable_ssl_verification', 'include_incident_fields', 'jira_project_id', 'jira_issue_type_id')
    slack_is_private = sgqlc.types.Field(Boolean, graphql_name='slackIsPrivate')
    '''Skip attempting to join if the channel is private. Requires a
    channel invitation first
    '''

    webhook_shared_secret = sgqlc.types.Field(String, graphql_name='webhookSharedSecret')
    '''An optional shared signing secret to use for validating the
    integrity of information when using a webhook integration
    '''

    webhook_encrypted_secret = sgqlc.types.Field(String, graphql_name='webhookEncryptedSecret')
    '''This field should be provided by the frontend when an update is
    being done to the notification setting and a shared secret key
    already existed for the web hook
    '''

    team_id = sgqlc.types.Field(String, graphql_name='teamId')
    '''The team ID to use when sending notifications to a Slack workspace'''

    team_name = sgqlc.types.Field(String, graphql_name='teamName')
    '''The team ID to use when sending notifications to a Slack workspace'''

    priority = sgqlc.types.Field(String, graphql_name='priority')
    '''Priority in remote notification system (Opsgenie)'''

    url = sgqlc.types.Field(String, graphql_name='url')
    '''API URL (Opsgenie, use this for regional URLs)'''

    username = sgqlc.types.Field(String, graphql_name='username')
    '''Username for external notification integration'''

    password = sgqlc.types.Field(String, graphql_name='password')
    '''Password for external notification integration'''

    dc_proxy = sgqlc.types.Field(Boolean, graphql_name='dcProxy')
    '''True if HTTP requests should be proxied through the Data Collector'''

    turn_off_normalized_messages = sgqlc.types.Field(Boolean, graphql_name='turnOffNormalizedMessages')
    '''True if normalized messages need to be turned off'''

    disable_ssl_verification = sgqlc.types.Field(Boolean, graphql_name='disableSslVerification')
    '''True if HTTP requests proxied through the Data Collector should
    not verify SSL certificates
    '''

    include_incident_fields = sgqlc.types.Field(JSONString, graphql_name='includeIncidentFields')
    '''Field-value pairs to include as additional fields (when creating
    incidents in ServiceNow)
    '''

    jira_project_id = sgqlc.types.Field(Int, graphql_name='jiraProjectId')
    '''Project Id for Jira'''

    jira_issue_type_id = sgqlc.types.Field(Int, graphql_name='jiraIssueTypeId')
    '''Issue Type Id for Jira'''



class NotificationRoutingRules(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('project_names', 'project_mcons', 'dataset_ids', 'full_table_ids', 'table_mcons', 'rule_ids', 'domain_ids', 'tag_keys', 'tag_key_values', 'all_tag_key_values', 'table_stats_rules', 'monitor_labels', 'monitor_labels_match_type', 'exclude_project_names', 'exclude_project_mcons', 'exclude_dataset_ids', 'exclude_full_table_ids', 'exclude_table_mcons', 'exclude_tag_keys', 'exclude_tag_key_values', 'exclude_all_tag_key_values', 'table_regex')
    project_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='projectNames')
    '''Allowlist by project names'''

    project_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='projectMcons')
    '''Allowlist by project mcons'''

    dataset_ids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name='datasetIds')
    '''Allowlist by dataset identifiers'''

    full_table_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='fullTableIds')
    '''Allowlist by full table identifiers'''

    table_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='tableMcons')
    '''Allowlist by table mcons'''

    rule_ids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name='ruleIds')
    '''Allowlist by rule identifiers'''

    domain_ids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name='domainIds')
    '''Allowlist by domain identifiers'''

    tag_keys = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='tagKeys')
    '''Allowlist by tag keys'''

    tag_key_values = sgqlc.types.Field(sgqlc.types.list_of('NotificationTagPairs'), graphql_name='tagKeyValues')
    '''Allowlist by tag key/value pairs'''

    all_tag_key_values = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.list_of('NotificationTagPairs')), graphql_name='allTagKeyValues')

    table_stats_rules = sgqlc.types.Field('TableStatsRules', graphql_name='tableStatsRules')
    '''Allowlist by table stats (importance_score, is_important).'''

    monitor_labels = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name='monitorLabels')
    '''Allowlist by monitor labels'''

    monitor_labels_match_type = sgqlc.types.Field(MonitorLabelsMatchType, graphql_name='monitorLabelsMatchType')
    '''Logic operator for matching labels. Defaults to OR.'''

    exclude_project_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='excludeProjectNames')
    '''Denylist by project names'''

    exclude_project_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='excludeProjectMcons')
    '''Denylist by project mcons'''

    exclude_dataset_ids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name='excludeDatasetIds')
    '''Denylist by dataset identifiers'''

    exclude_full_table_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='excludeFullTableIds')
    '''Denylist by full table identifiers'''

    exclude_table_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='excludeTableMcons')
    '''Denylist by table mcon identifiers'''

    exclude_tag_keys = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='excludeTagKeys')
    '''Denylist by tag keys'''

    exclude_tag_key_values = sgqlc.types.Field(sgqlc.types.list_of('NotificationTagPairs'), graphql_name='excludeTagKeyValues')
    '''Denylist by tag key/value pairs'''

    exclude_all_tag_key_values = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.list_of('NotificationTagPairs')), graphql_name='excludeAllTagKeyValues')

    table_regex = sgqlc.types.Field(String, graphql_name='tableRegex')
    '''For use in updating regex based rules'''



class NotificationTagPairs(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('name', 'value')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''Tag key'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Tag Value'''



class NumericFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'ranges')
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')
    '''Field name to filter on'''

    ranges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('NumericRangeInput')), graphql_name='ranges')
    '''Numeric ranges to filter by (combined via OR)'''



class NumericRangeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('lower_bound_value', 'upper_bound_value')
    lower_bound_value = sgqlc.types.Field(Int, graphql_name='lowerBoundValue')
    '''Numeric range end value'''

    upper_bound_value = sgqlc.types.Field(Int, graphql_name='upperBoundValue')
    '''Numeric range start value'''



class ObjectPropertyInput(sgqlc.types.Input):
    '''Object properties, indexed by the search service'''
    __schema__ = schema
    __field_names__ = ('property_name', 'property_value')
    property_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='propertyName')
    '''The name (key) of the property'''

    property_value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='propertyValue')
    '''The value for the property'''



class PiiFilterStatusPair(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('filter_name', 'enabled')
    filter_name = sgqlc.types.Field(String, graphql_name='filterName')
    '''The unique name of the PII filter.'''

    enabled = sgqlc.types.Field(Boolean, graphql_name='enabled')
    '''Whether the PII filter should be enabled or not.'''



class PowerBIConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('tenant_id', 'auth_mode', 'client_id', 'client_secret', 'username', 'password')
    tenant_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='tenantId')
    '''Azure Power BI tenant uuid'''

    auth_mode = sgqlc.types.Field(sgqlc.types.non_null(PowerBIAuthModeEnumV2), graphql_name='authMode')
    '''Authentication mode. We support two values here
    [service_principal, primary_user]
    '''

    client_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='clientId')
    '''App Client UUID'''

    client_secret = sgqlc.types.Field(String, graphql_name='clientSecret')
    '''Secret key for the client ID. Required if auth_mode is
    service_principal.
    '''

    username = sgqlc.types.Field(String, graphql_name='username')
    '''Username when auth as a primary user. Required if auth_mode is
    primary_user.
    '''

    password = sgqlc.types.Field(String, graphql_name='password')
    '''Password when auth as a primary user. Required if auth_mode is
    primary_user.
    '''



class QPMonitorConfigInputType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('metadata', 'comparisons')
    metadata = sgqlc.types.Field(sgqlc.types.non_null('QuerySelectionInput'), graphql_name='metadata')
    '''Query selection'''

    comparisons = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons')
    '''Comparisons'''



class QueryAfterKeyInput(sgqlc.types.Input):
    '''The after key to use for Blast Radius query data pagination'''
    __schema__ = schema
    __field_names__ = ('user', 'date', 'query_hash')
    user = sgqlc.types.Field(String, graphql_name='user')
    '''The last username retrieved'''

    date = sgqlc.types.Field(String, graphql_name='date')
    '''The last date retrieved as a string'''

    query_hash = sgqlc.types.Field(String, graphql_name='queryHash')
    '''The last query hash'''



class QueryLogsFacetRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'search_criteria', 'apply_mask', 'first', 'search_prefix', 'included_query_types')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field name'''

    search_criteria = sgqlc.types.Field('SearchCriteriaType', graphql_name='searchCriteria')

    apply_mask = sgqlc.types.Field(Boolean, graphql_name='applyMask')
    '''Apply mask'''

    first = sgqlc.types.Field(Int, graphql_name='first')
    '''First'''

    search_prefix = sgqlc.types.Field(String, graphql_name='searchPrefix')
    '''Search facets by prefix'''

    included_query_types = sgqlc.types.Field(sgqlc.types.list_of(QueryLogType), graphql_name='includedQueryTypes')
    '''The query log types we want to include in the time series
    aggregation. The options are [READ], [WRITE] or [READ, WRITE]
    '''



class QueryLogsFacetRequestTypeV2(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('requests',)
    requests = sgqlc.types.Field(sgqlc.types.list_of(QueryLogsFacetRequestType), graphql_name='requests')



class QueryLogsRequestInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('search_criteria', 'query_group_field', 'query_runtime_field', 'sort_field', 'sort_order', 'first', 'offset', 'included_query_types')
    search_criteria = sgqlc.types.Field(sgqlc.types.non_null('SearchCriteriaType'), graphql_name='searchCriteria')

    query_group_field = sgqlc.types.Field(String, graphql_name='queryGroupField')

    query_runtime_field = sgqlc.types.Field(String, graphql_name='queryRuntimeField')

    sort_field = sgqlc.types.Field(String, graphql_name='sortField')

    sort_order = sgqlc.types.Field(String, graphql_name='sortOrder')

    first = sgqlc.types.Field(Int, graphql_name='first')

    offset = sgqlc.types.Field(Int, graphql_name='offset')

    included_query_types = sgqlc.types.Field(sgqlc.types.list_of(QueryLogType), graphql_name='includedQueryTypes')
    '''Query types to include in the results. Can be READ, WRITE or both.
    By default it will use WRITE
    '''



class QueryPerformanceDataRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('search_criteria', 'query_group_values', 'time_bucket_size', 'metrics')
    search_criteria = sgqlc.types.Field('SearchCriteriaType', graphql_name='searchCriteria')
    '''Query search criteria'''

    query_group_values = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='queryGroupValues')
    '''Query group identifiers'''

    time_bucket_size = sgqlc.types.Field(String, graphql_name='timeBucketSize')
    '''Size of time buckets'''

    metrics = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(MetricAggregationInputType)), graphql_name='metrics')
    '''Metric aggregations'''



class QueryRuntimePercentileTimeSeriesRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('search_criteria', 'time_bucket_size', 'percentiles', 'included_query_types')
    search_criteria = sgqlc.types.Field('SearchCriteriaType', graphql_name='searchCriteria')

    time_bucket_size = sgqlc.types.Field(String, graphql_name='timeBucketSize')

    percentiles = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(Int)), graphql_name='percentiles')
    '''Each time series returned will be for a given percentile. Examples
    are: 50, 75, 95. 99, 100
    '''

    included_query_types = sgqlc.types.Field(sgqlc.types.list_of(QueryLogType), graphql_name='includedQueryTypes')
    '''The query log types we want to include in the time series
    aggregation. The options are [READ], [WRITE] or [READ, WRITE]
    '''



class QuerySelectionInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('query_type', 'indexed_field_filters')
    query_type = sgqlc.types.Field(sgqlc.types.non_null(QueryLogType), graphql_name='queryType')
    '''Type of the monitored queries'''

    indexed_field_filters = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(IndexedFieldFilterType)), graphql_name='indexedFieldFilters')
    '''Selection criteria of the monitored queries'''



class QueryTemplateVariableValueInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('name', 'value', 'value_json')
    name = sgqlc.types.Field(String, graphql_name='name')
    '''Variable name'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Variable value'''

    value_json = sgqlc.types.Field(JSONString, graphql_name='valueJson')
    '''Variable value (in JSON)'''



class RedshiftConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('db_name', 'host', 'port', 'user', 'password')
    db_name = sgqlc.types.Field(String, graphql_name='dbName')
    '''Name of database to add connection for'''

    host = sgqlc.types.Field(String, graphql_name='host')
    '''Hostname of the warehouse'''

    port = sgqlc.types.Field(Int, graphql_name='port')
    '''HTTP Port to use'''

    user = sgqlc.types.Field(String, graphql_name='user')
    '''User with access to the database'''

    password = sgqlc.types.Field(String, graphql_name='password')
    '''User's password'''



class RetrieveComparisonWidgetDataRequestInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('dataset_left', 'dataset_right', 'widget_type', 'field_name', 'limit', 'config')
    dataset_left = sgqlc.types.Field(sgqlc.types.non_null(DatasetInput), graphql_name='datasetLeft')
    '''First dataset to be compared'''

    dataset_right = sgqlc.types.Field(sgqlc.types.non_null(DatasetInput), graphql_name='datasetRight')
    '''Second dataset to be compared'''

    widget_type = sgqlc.types.Field(sgqlc.types.non_null(WidgetType), graphql_name='widgetType')
    '''Widget type'''

    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')
    '''Field name'''

    limit = sgqlc.types.Field(Int, graphql_name='limit')

    config = sgqlc.types.Field(JSONString, graphql_name='config')
    '''Extra configuration'''



class RetrieveTableDataRequestInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('dataset', 'order_by', 'limit')
    dataset = sgqlc.types.Field(sgqlc.types.non_null(DatasetInput), graphql_name='dataset')

    order_by = sgqlc.types.Field(String, graphql_name='orderBy')

    limit = sgqlc.types.Field(Int, graphql_name='limit')



class RetrieveWidgetDataRequestInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('dataset', 'widget_type', 'field_name', 'limit', 'config')
    dataset = sgqlc.types.Field(sgqlc.types.non_null(DatasetInput), graphql_name='dataset')

    widget_type = sgqlc.types.Field(sgqlc.types.non_null(WidgetType), graphql_name='widgetType')

    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')

    limit = sgqlc.types.Field(Int, graphql_name='limit')

    config = sgqlc.types.Field(JSONString, graphql_name='config')



class ScheduleConfigInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('schedule_type', 'interval_minutes', 'interval_crontab', 'start_time', 'min_interval_minutes', 'timezone')
    schedule_type = sgqlc.types.Field(sgqlc.types.non_null(ScheduleType), graphql_name='scheduleType')
    '''Type of schedule'''

    interval_minutes = sgqlc.types.Field(Int, graphql_name='intervalMinutes')
    '''Time interval between job executions, in minutes'''

    interval_crontab = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='intervalCrontab')
    '''Time interval between job executions, using a cron expression'''

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''For schedule_type=fixed, the date the schedule should start'''

    min_interval_minutes = sgqlc.types.Field(Int, graphql_name='minIntervalMinutes')
    '''For schedule_type=dynamic, the minimum time interval between job
    executions
    '''

    timezone = sgqlc.types.Field(String, graphql_name='timezone')
    '''Timezone for daylight savings and interpreting cron expressions.'''



class SearchCriteriaType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('indexed_field_filters', 'query_group', 'start_time', 'end_time', 'query_group_field', 'query_ids')
    indexed_field_filters = sgqlc.types.Field(sgqlc.types.list_of(IndexedFieldFilterType), graphql_name='indexedFieldFilters')
    '''List of indexed field filters'''

    query_group = sgqlc.types.Field(String, graphql_name='queryGroup')

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''start time, overrides days_back'''

    end_time = sgqlc.types.Field(DateTime, graphql_name='endTime')
    '''end time, overrides days_back'''

    query_group_field = sgqlc.types.Field(String, graphql_name='queryGroupField')

    query_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='queryIds')
    '''List of query ids'''



class SegmentsFilter(sgqlc.types.Input):
    '''A segment key and its value'''
    __schema__ = schema
    __field_names__ = ('key', 'value')
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='key')
    '''The segment name'''

    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='value')
    '''Value of the segment'''



class SensitivityInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('level',)
    level = sgqlc.types.Field(SensitivityLevels, graphql_name='level')
    '''Low, medium or high sensitivity'''



class SetIncidentFeedbackInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('incident_id', 'feedback', 'client_mutation_id')
    incident_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='incidentId')
    '''UUID of incident to add feedback'''

    feedback = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='feedback')
    '''The feedback to be added to an incident'''

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class SimulateMonitorEvaluationRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('evaluation_start_time', 'evaluation_end_time', 'limit')
    evaluation_start_time = sgqlc.types.Field(DateTime, graphql_name='evaluationStartTime')
    '''Evaluation start time'''

    evaluation_end_time = sgqlc.types.Field(DateTime, graphql_name='evaluationEndTime')
    '''Evaluation end time'''

    limit = sgqlc.types.Field(Int, graphql_name='limit')
    '''Number of breaching query groups to return'''



class SnowflakeConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('user', 'password', 'private_key', 'private_key_passphrase', 'account', 'warehouse')
    user = sgqlc.types.Field(String, graphql_name='user')
    '''User with access to snowflake.'''

    password = sgqlc.types.Field(String, graphql_name='password')
    '''User's password if using user/password basic auth'''

    private_key = sgqlc.types.Field(String, graphql_name='privateKey')
    '''User's private key (base64 encoded) if using key pair auth.'''

    private_key_passphrase = sgqlc.types.Field(String, graphql_name='privateKeyPassphrase')
    '''User's private key passphrase if using key pair auth. This
    argument is only needed when the private key is encrypted.
    '''

    account = sgqlc.types.Field(String, graphql_name='account')
    '''Snowflake account name'''

    warehouse = sgqlc.types.Field(String, graphql_name='warehouse')
    '''Name of the warehouse for the user'''



class SparkBinaryInput(sgqlc.types.Input):
    '''Credentials to the Spark  Thrift server in binary mode'''
    __schema__ = schema
    __field_names__ = ('database', 'host', 'port', 'username', 'password')
    database = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='database')
    '''Database name'''

    host = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='host')
    '''Host name'''

    port = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='port')
    '''Port'''

    username = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='username')
    '''User name'''

    password = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='password')
    '''Password'''



class SparkDatabricksConnectionInput(sgqlc.types.Input):
    '''Credentials and connection details to a new Databricks cluster
    connection
    '''
    __schema__ = schema
    __field_names__ = ('dc_id', 'connection_type', 'databricks_config')
    dc_id = sgqlc.types.Field(UUID, graphql_name='dcId')
    '''The Data Collector UUID for a new Databricks Connection'''

    connection_type = sgqlc.types.Field(String, graphql_name='connectionType')
    '''The Databricks connection type for a new Databricks connection'''

    databricks_config = sgqlc.types.Field('SparkDatabricksInput', graphql_name='databricksConfig')
    '''Configuration for Databricks.'''



class SparkDatabricksInput(sgqlc.types.Input):
    '''Credentials to a Databricks cluster'''
    __schema__ = schema
    __field_names__ = ('databricks_workspace_url', 'databricks_workspace_id', 'databricks_cluster_id', 'databricks_token')
    databricks_workspace_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='databricksWorkspaceUrl')
    '''Databricks workspace URL'''

    databricks_workspace_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='databricksWorkspaceId')
    '''Databricks workspace ID'''

    databricks_cluster_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='databricksClusterId')
    '''Databricks cluster ID'''

    databricks_token = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='databricksToken')
    '''User token'''



class SparkHttpInput(sgqlc.types.Input):
    '''Credentials to the Spark  Thrift server in HTTP mode'''
    __schema__ = schema
    __field_names__ = ('url', 'username', 'password')
    url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='url')
    '''Connection URL to the Thrift server'''

    username = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='username')
    '''User name'''

    password = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='password')
    '''Password'''



class SslInputOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('ca', 'cert', 'key', 'mechanism', 'skip_verification')
    ca = sgqlc.types.Field(String, graphql_name='ca')
    '''CA bundle file'''

    cert = sgqlc.types.Field(String, graphql_name='cert')
    '''Certificate file'''

    key = sgqlc.types.Field(String, graphql_name='key')
    '''Key file'''

    mechanism = sgqlc.types.Field(String, graphql_name='mechanism')
    '''How the file is passed to the DC. Possible values are: "dc-s3" or
    "url"
    '''

    skip_verification = sgqlc.types.Field(Boolean, graphql_name='skipVerification')
    '''Whether SSL certificate verification should be skipped'''



class StringFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'values')
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')
    '''Field name to filter on'''

    values = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='values')
    '''Values to filter by (combined via OR)'''



class TableStatsRules(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('importance_score', 'is_important')
    importance_score = sgqlc.types.Field(ImportanceScoreTableStatsRule, graphql_name='importanceScore')

    is_important = sgqlc.types.Field(IsImportantTableStatsRule, graphql_name='isImportant')



class TableauConnectionDetails(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('server_name', 'username', 'password', 'client_id', 'secret_id', 'secret_value', 'token_name', 'token_value', 'site_name', 'verify_ssl')
    server_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='serverName')
    '''The Tableau server name'''

    username = sgqlc.types.Field(String, graphql_name='username')
    '''Username for the Tableau user if using username/password or
    Connected Apps
    '''

    password = sgqlc.types.Field(String, graphql_name='password')
    '''Password for the Tableau user if using username/password'''

    client_id = sgqlc.types.Field(String, graphql_name='clientId')
    '''The Tableau Connected Apps Client ID'''

    secret_id = sgqlc.types.Field(String, graphql_name='secretId')
    '''The Tableau Connected Apps Secret ID'''

    secret_value = sgqlc.types.Field(String, graphql_name='secretValue')
    '''The Tableau Connected Apps Secret value'''

    token_name = sgqlc.types.Field(String, graphql_name='tokenName')
    '''The personal access token name'''

    token_value = sgqlc.types.Field(String, graphql_name='tokenValue')
    '''The personal access token value'''

    site_name = sgqlc.types.Field(String, graphql_name='siteName')
    '''The Tableau site name'''

    verify_ssl = sgqlc.types.Field(Boolean, graphql_name='verifySsl')
    '''Whether to verify the SSL connection to Tableau server'''



class TagFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('tag_name', 'tag_values')
    tag_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='tagName')
    '''Tag name'''

    tag_values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='tagValues')
    '''Tag values. If empty, match all with tag_name'''



class TagKeyValuePairInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('name', 'value')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''Tag key'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Tag Value'''



class TagPair(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('name', 'value')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''Tag key'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Tag Value'''



class ThresholdModifierInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('modifier_type', 'value')
    modifier_type = sgqlc.types.Field(sgqlc.types.non_null(ThresholdModifierType), graphql_name='modifierType')
    '''The type of threshold modifier'''

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='value')
    '''The value of the threshold modifier. If the type is PERCENTAGE,
    this should be a decimal value.
    '''



class TimestampFilterInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'ranges')
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')
    '''Field name to filter on'''

    ranges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('TimestampRangeInput')), graphql_name='ranges')
    '''Time ranges to filter by (combined via OR)'''



class TimestampRangeInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('start_time', 'end_time')
    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''Time range start'''

    end_time = sgqlc.types.Field(DateTime, graphql_name='endTime')
    '''Time range end'''



class TimestampResult(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('field_name', 'timestamp')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')

    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')



class ToggleDatasetInputItem(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('dw_id', 'ds_id')
    dw_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dwId')
    '''Warehouse the dataset is contained in.'''

    ds_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dsId')
    '''ID of the dataset.'''



class ToggleMuteDatasetInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('dw_id', 'ds_id', 'mute', 'muted_event_types', 'client_mutation_id')
    dw_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dwId')
    '''Warehouse the dataset is contained in.'''

    ds_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dsId')
    '''ID of the dataset.'''

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='mute')
    '''True for muting the table, False for un-muting'''

    muted_event_types = sgqlc.types.Field(sgqlc.types.list_of(MutedEventType), graphql_name='mutedEventTypes')
    '''Restrict muting to the following event types (optional)'''

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class ToggleMuteDatasetsInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('datasets', 'mute', 'muted_event_types', 'client_mutation_id')
    datasets = sgqlc.types.Field(sgqlc.types.list_of(ToggleDatasetInputItem), graphql_name='datasets')
    '''The datasets being muted'''

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='mute')
    '''True for muting the table, False for un-muting'''

    muted_event_types = sgqlc.types.Field(sgqlc.types.list_of(MutedEventType), graphql_name='mutedEventTypes')
    '''Restrict muting to the following event types (optional)'''

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class ToggleMuteTableInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('mcon', 'full_table_id', 'dw_id', 'mute', 'muted_event_types', 'client_mutation_id')
    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''Mcon of table to toggle muting for'''

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')
    '''Deprecated - use mcon. Ignored if mcon is present'''

    dw_id = sgqlc.types.Field(UUID, graphql_name='dwId')
    '''Warehouse the table is contained in. Required when using a
    fullTableId
    '''

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='mute')
    '''True for muting the table, False for un-muting'''

    muted_event_types = sgqlc.types.Field(sgqlc.types.list_of(MutedEventType), graphql_name='mutedEventTypes')
    '''Restrict muting to the following event types (optional)'''

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class ToggleMuteTablesInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('tables', 'mute', 'muted_event_types', 'client_mutation_id')
    tables = sgqlc.types.Field(sgqlc.types.list_of('ToggleTableInputItem'), graphql_name='tables')
    '''The tables being muted'''

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='mute')
    '''True for muting the table, False for un-muting'''

    muted_event_types = sgqlc.types.Field(sgqlc.types.list_of(MutedEventType), graphql_name='mutedEventTypes')
    '''Restrict muting to the following event types (optional)'''

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class ToggleMuteWithRegexInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('dw_id', 'rule_regex', 'mute', 'muted_event_types', 'client_mutation_id')
    dw_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dwId')
    '''Warehouse the dataset is contained in.'''

    rule_regex = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='ruleRegex')
    '''Valid regex to match fullTableIds. FullTableIds have the following
    format: "PROJECT_NAME:DATASET_NAME.TABLE_ID"
    '''

    mute = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='mute')
    '''True for muting the table, False for un-muting'''

    muted_event_types = sgqlc.types.Field(sgqlc.types.list_of(MutedEventType), graphql_name='mutedEventTypes')
    '''Restrict muting to the following event types (optional)'''

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class ToggleTableInputItem(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('mcon', 'full_table_id', 'dw_id')
    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''Mcon of the table to toggle muting for'''

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')
    '''Deprecated - use mcon. Ignored if mcon is present'''

    dw_id = sgqlc.types.Field(UUID, graphql_name='dwId')
    '''Warehouse the table is contained in. Required when using a full
    table id
    '''



class TopQueryGroupsRequestType(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('search_criteria', 'first', 'offset', 'sort_field', 'metric_field_name')
    search_criteria = sgqlc.types.Field(sgqlc.types.non_null(SearchCriteriaType), graphql_name='searchCriteria')

    first = sgqlc.types.Field(Int, graphql_name='first')

    offset = sgqlc.types.Field(Int, graphql_name='offset')

    sort_field = sgqlc.types.Field(String, graphql_name='sortField')

    metric_field_name = sgqlc.types.Field(String, graphql_name='metricFieldName')



class TrackTableInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('mcon', 'full_table_id', 'dw_id', 'track', 'client_mutation_id')
    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''Mcon of table to toggle tracking for'''

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')
    '''Deprecated - use mcon. Ignored if mcon is present'''

    dw_id = sgqlc.types.Field(UUID, graphql_name='dwId')
    '''Warehouse the table is contained in. Required when using a
    fullTableId
    '''

    track = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='track')
    '''Enable or disable table tracking'''

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class UpdateUserStateInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('state', 'client_mutation_id')
    state = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='state')

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class UserAfterKeyInput(sgqlc.types.Input):
    '''The after key to use for Blast Radius User data pagination'''
    __schema__ = schema
    __field_names__ = ('user', 'source')
    user = sgqlc.types.Field(String, graphql_name='user')
    '''The last username retrieved'''

    source = sgqlc.types.Field(String, graphql_name='source')
    '''The last source table retrieved'''



class UserAfterKeyInput2(sgqlc.types.Input):
    '''The after key to use for Blast Radius User data pagination'''
    __schema__ = schema
    __field_names__ = ('user',)
    user = sgqlc.types.Field(String, graphql_name='user')
    '''The last username retrieved'''



class ValidatorTestOptions(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('validate_select', 'validate_info_access', 'validate_table_metadata', 'validate_syslog')
    validate_select = sgqlc.types.Field(Boolean, graphql_name='validateSelect')
    '''Whether the validate select query should be executed'''

    validate_info_access = sgqlc.types.Field(Boolean, graphql_name='validateInfoAccess')
    '''Whether the validate info access query should be executed'''

    validate_table_metadata = sgqlc.types.Field(Boolean, graphql_name='validateTableMetadata')
    '''Whether the validate table metadata query should be executed'''

    validate_syslog = sgqlc.types.Field(Boolean, graphql_name='validateSyslog')
    '''Whether the validate syslog query should be executed'''



class WildcardTemplateInput(sgqlc.types.Input):
    __schema__ = schema
    __field_names__ = ('template_name', 'template_regex')
    template_name = sgqlc.types.Field(String, graphql_name='templateName')

    template_regex = sgqlc.types.Field(String, graphql_name='templateRegex')




########################################################################
# Output Objects and Interfaces
########################################################################
class CollectionPreferenceNode(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')
    '''The ID of the object.'''



class IBaseRca(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ('rca_type', 'rca_uuid')
    rca_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='rcaType')
    '''RCA type'''

    rca_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='rcaUuid')
    '''Unique identifier of an RCA'''



class ICustomRulesMonitor(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ('has_custom_rule_name', 'rule_description', 'rule_comparisons', 'rule_notes', 'rule_variables', 'is_snoozed', 'snooze_until_time', 'slack_snooze_user', 'conditional_snooze', 'breach_rate', 'interval_minutes')
    has_custom_rule_name = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasCustomRuleName')
    '''Whether the monitor has a name given by the monitor creator'''

    rule_description = sgqlc.types.Field(String, graphql_name='ruleDescription')
    '''**DEPRECATED**'''

    rule_comparisons = sgqlc.types.Field(sgqlc.types.list_of('CustomRuleComparison'), graphql_name='ruleComparisons')

    rule_notes = sgqlc.types.Field(String, graphql_name='ruleNotes')
    '''**DEPRECATED**'''

    rule_variables = sgqlc.types.Field(JSONString, graphql_name='ruleVariables')
    '''variables defined for the sql rule'''

    is_snoozed = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isSnoozed')
    '''Whether the monitor is currently snoozed'''

    snooze_until_time = sgqlc.types.Field(DateTime, graphql_name='snoozeUntilTime')
    '''If snoozed, the wake up time in UTC'''

    slack_snooze_user = sgqlc.types.Field(String, graphql_name='slackSnoozeUser')
    '''Slack user who snoozed rule'''

    conditional_snooze = sgqlc.types.Field(Boolean, graphql_name='conditionalSnooze')
    '''Whether the monitor is conditionally snoozed'''

    breach_rate = sgqlc.types.Field(String, graphql_name='breachRate')
    '''Percentage of last 10 runs in which the monitor's condition was
    breached
    '''

    interval_minutes = sgqlc.types.Field(Int, graphql_name='intervalMinutes')
    '''Interval between monitor runs, in minutes'''



class IMetricsMonitor(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ('monitor_fields', 'monitor_time_axis_field_name', 'monitor_time_axis_field_type', 'where_condition', 'use_partition_clause', 'segmented_expressions', 'history_days', 'select_expressions', 'selected_metrics', 'agg_time_interval')
    monitor_fields = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='monitorFields')
    '''Field/s to monitor'''

    monitor_time_axis_field_name = sgqlc.types.Field(String, graphql_name='monitorTimeAxisFieldName')
    '''The name of the table/view field used for establishing the table
    time
    '''

    monitor_time_axis_field_type = sgqlc.types.Field(String, graphql_name='monitorTimeAxisFieldType')
    '''Type of time axis field used for establishing the table time'''

    where_condition = sgqlc.types.Field(String, graphql_name='whereCondition')
    '''Comparison predicate for the monitor SQL query'''

    use_partition_clause = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='usePartitionClause')
    '''Whether to use automatic partition filter in query'''

    segmented_expressions = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='segmentedExpressions')
    '''Fields or expressions used to segment the monitored field
    (currently supports one such value)
    '''

    history_days = sgqlc.types.Field(Int, graphql_name='historyDays')
    '''Number of lookback days for each monitor execution'''

    select_expressions = sgqlc.types.Field(sgqlc.types.list_of('MetricMonitorSelectExpression'), graphql_name='selectExpressions')
    '''Monitor select expression'''

    selected_metrics = sgqlc.types.Field(sgqlc.types.list_of(FieldHealthMetrics), graphql_name='selectedMetrics')
    '''Selected metrics for the monitor. If empty, all metrics will be
    monitored. Only available for Field Health monitors.
    '''

    agg_time_interval = sgqlc.types.Field(MonitorAggTimeInterval, graphql_name='aggTimeInterval')
    '''For field health and dimension monitoring, the aggregation time
    interval to use. Either HOUR or DAY
    '''



class IMonitor(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ('uuid', 'monitor_type', 'created_time', 'last_update_time', 'creator_id', 'updater_id', 'resource_id', 'entities', 'entity_mcons', 'schedule_type', 'name', 'rule_name', 'description', 'notes', 'labels', 'severity', 'notification_settings', 'notify_rule_run_failure', 'is_snoozeable', 'is_paused', 'is_template_managed', 'namespace', 'next_execution_time', 'prev_execution_time', 'is_transitioning_data_provider', 'schedule_config', 'seven_days_incident_count', 'incident_count_history', 'weekly_incident_count_change_rate')
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Unique identifier for monitors'''

    monitor_type = sgqlc.types.Field(sgqlc.types.non_null(UserDefinedMonitors), graphql_name='monitorType')
    '''Type of monitor'''

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdTime')
    '''Monitor creation time (UTC)'''

    last_update_time = sgqlc.types.Field(DateTime, graphql_name='lastUpdateTime')
    '''Monitor last update time (UTC)'''

    creator_id = sgqlc.types.Field(String, graphql_name='creatorId')
    '''Email of user who created the monitor'''

    updater_id = sgqlc.types.Field(String, graphql_name='updaterId')
    '''Email of user who last updated the monitor'''

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceId')
    '''Warehouse Unique Identifier'''

    entities = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='entities')
    '''Full table IDs for monitored tables/views'''

    entity_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='entityMcons')
    '''MCONs for monitored tables/views'''

    schedule_type = sgqlc.types.Field(String, graphql_name='scheduleType')
    '''Monitor scheduling type'''

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''Monitor/rule name, default or user-defined'''

    rule_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='ruleName')
    '''DEPRECATED: Rule name, default or user-defined, null for monitors.
    Use name instead.
    '''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''Monitor user-defined name'''

    notes = sgqlc.types.Field(String, graphql_name='notes')
    '''Notes defined on this monitor'''

    labels = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='labels')
    '''List of tags used to filter a monitor'''

    severity = sgqlc.types.Field(String, graphql_name='severity')
    '''Default severity for incidents involving this monitor'''

    notification_settings = sgqlc.types.Field(sgqlc.types.list_of('AccountNotificationSetting'), graphql_name='notificationSettings')
    '''Notification channels that match the monitor'''

    notify_rule_run_failure = sgqlc.types.Field(Boolean, graphql_name='notifyRuleRunFailure')
    '''Whether audiences will be notified when the rule fails to execute'''

    is_snoozeable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isSnoozeable')
    '''Whether the monitor can be snoozed'''

    is_paused = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isPaused')
    '''Whether the monitor is currently paused'''

    is_template_managed = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isTemplateManaged')
    '''Whether the monitor was created from through monitor-as-code'''

    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='namespace')
    '''The monitor-as-code namespace used when creating the monitor'''

    next_execution_time = sgqlc.types.Field(DateTime, graphql_name='nextExecutionTime')
    '''The next time (UTC) in which the monitor will run'''

    prev_execution_time = sgqlc.types.Field(DateTime, graphql_name='prevExecutionTime')
    '''The last time (UTC) in which the monitor ran'''

    is_transitioning_data_provider = sgqlc.types.Field(Boolean, graphql_name='isTransitioningDataProvider')

    schedule_config = sgqlc.types.Field('ScheduleConfigOutput', graphql_name='scheduleConfig')

    seven_days_incident_count = sgqlc.types.Field(Int, graphql_name='sevenDaysIncidentCount')
    '''Number of incidents in the past 7 days'''

    incident_count_history = sgqlc.types.Field(sgqlc.types.list_of('IncidentDailyCount'), graphql_name='incidentCountHistory')
    '''Number of incidents per day for the past 30 days'''

    weekly_incident_count_change_rate = sgqlc.types.Field(Int, graphql_name='weeklyIncidentCountChangeRate')
    '''Change in percentage between between last 7 days and the 7 days
    before.
    '''



class IMonitorStatus(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ('monitor_run_status', 'monitor_configuration_status', 'monitor_training_status', 'monitor_status', 'exceptions')
    monitor_run_status = sgqlc.types.Field(sgqlc.types.non_null(MonitorRunStatusType), graphql_name='monitorRunStatus')
    '''Monitor run status'''

    monitor_configuration_status = sgqlc.types.Field(sgqlc.types.non_null(MonitorConfigurationStatusType), graphql_name='monitorConfigurationStatus')
    '''Monitor configuration status'''

    monitor_training_status = sgqlc.types.Field(sgqlc.types.non_null(MonitorTrainingStatusType), graphql_name='monitorTrainingStatus')
    '''Monitor training status'''

    monitor_status = sgqlc.types.Field(sgqlc.types.non_null(MonitorStatusType), graphql_name='monitorStatus')
    '''Consolidated monitor status'''

    exceptions = sgqlc.types.Field(String, graphql_name='exceptions')
    '''Exceptions if any occurred during the last run'''



class IQueryRca(sgqlc.types.Interface):
    __schema__ = schema
    __field_names__ = ('query_log_group_hash', 'query_log_id', 'query_type', 'query_subtype', 'user', 'start_time', 'mcon')
    query_log_group_hash = sgqlc.types.Field(String, graphql_name='queryLogGroupHash')
    '''Hash of query group the query belongs to'''

    query_log_id = sgqlc.types.Field(String, graphql_name='queryLogId')
    '''UUID of specific query'''

    query_type = sgqlc.types.Field(String, graphql_name='queryType')
    '''The type of query that failed'''

    query_subtype = sgqlc.types.Field(String, graphql_name='querySubtype')
    '''The sub-type of the query that failed'''

    user = sgqlc.types.Field(String, graphql_name='user')
    '''The user who ran the query that failed'''

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''The RCA start time'''

    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''The MCON of the table associated with the RCA'''



class Node(sgqlc.types.Interface):
    '''An object with an ID'''
    __schema__ = schema
    __field_names__ = ('id',)
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')
    '''The ID of the object.'''



class AIMessageOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('message', 'actor', 'status')
    message = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='message')
    '''Message from the specified actor'''

    actor = sgqlc.types.Field(sgqlc.types.non_null(ActorType), graphql_name='actor')
    '''The actor that sends the message'''

    status = sgqlc.types.Field(String, graphql_name='status')
    '''When streaming the results, it returns the status of the request'''



class AccessToken(sgqlc.types.Type):
    '''Generated API Token ID and Access Key. Only available once'''
    __schema__ = schema
    __field_names__ = ('id', 'token')
    id = sgqlc.types.Field(String, graphql_name='id')
    '''Token user ID'''

    token = sgqlc.types.Field(String, graphql_name='token')
    '''Generated token'''



class Account(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'uuid', 'name', 'created_on', 'config', 'allow_non_sso_login', 'data_share', 'is_deleted', 'notification_settings', 'data_collectors', 'users', 'user_invites', 'user_account_before_switch', 'warehouses', 'bi', 'etl_containers', 'connections', 'custom_sql_templates', 'slack_credentials', 'slack_channels', 'slack_msg_details', 'resources', 'account_domains', 'alation_integrations', 'slack_credentials_v2', 'collection_preferences', 'data_products', 'dashboards', 'comparison_dashboards', 'widgets', 'identity_provider', 'tableau_accounts', 'active_collection_regions', 'internal_notifications')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''The account id'''

    name = sgqlc.types.Field(String, graphql_name='name')
    '''The account name'''

    created_on = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdOn')
    '''When the account was first created'''

    config = sgqlc.types.Field(JSONString, graphql_name='config')
    '''Account level configuration'''

    allow_non_sso_login = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='allowNonSsoLogin')

    data_share = sgqlc.types.Field(JSONString, graphql_name='dataShare')
    '''Information necessary to setup a Snowflake Data Share'''

    is_deleted = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isDeleted')

    notification_settings = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('AccountNotificationSetting'))), graphql_name='notificationSettings', args=sgqlc.types.ArgDict((
        ('with_audience', sgqlc.types.Arg(Boolean, graphql_name='withAudience', default=None)),
))
    )
    '''Arguments:

    * `with_audience` (`Boolean`): If true, only settings associated
      to an audience will be returned. If false, only settings not
      associated will be returned. If not provided, all settings will
      be returned
    '''

    data_collectors = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('DataCollector'))), graphql_name='dataCollectors')

    users = sgqlc.types.Field(sgqlc.types.non_null('UserConnection'), graphql_name='users', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('email', sgqlc.types.Arg(String, graphql_name='email', default=None)),
        ('first_name', sgqlc.types.Arg(String, graphql_name='firstName', default=None)),
        ('last_name', sgqlc.types.Arg(String, graphql_name='lastName', default=None)),
        ('role', sgqlc.types.Arg(String, graphql_name='role', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `email` (`String`)None
    * `first_name` (`String`)None
    * `last_name` (`String`)None
    * `role` (`String`)None
    '''

    user_invites = sgqlc.types.Field(sgqlc.types.non_null('UserInviteConnection'), graphql_name='userInvites', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('state', sgqlc.types.Arg(String, graphql_name='state', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `state` (`String`)None
    '''

    user_account_before_switch = sgqlc.types.Field(sgqlc.types.non_null('UserInviteConnection'), graphql_name='userAccountBeforeSwitch', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('state', sgqlc.types.Arg(String, graphql_name='state', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `state` (`String`)None
    '''

    warehouses = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('Warehouse'))), graphql_name='warehouses')

    bi = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('BiContainer'))), graphql_name='bi')

    etl_containers = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('EtlContainer'))), graphql_name='etlContainers')

    connections = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('Connection'))), graphql_name='connections')

    custom_sql_templates = sgqlc.types.Field(sgqlc.types.non_null('CustomSQLTemplateConnection'), graphql_name='customSqlTemplates', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('sql_template', sgqlc.types.Arg(String, graphql_name='sqlTemplate', default=None)),
        ('dialect', sgqlc.types.Arg(String, graphql_name='dialect', default=None)),
        ('query_result_type', sgqlc.types.Arg(CustomSQLTemplateModelQueryResultType, graphql_name='queryResultType', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `uuid` (`UUID`)None
    * `name` (`String`)None
    * `description` (`String`)None
    * `sql_template` (`String`)None
    * `dialect` (`String`)None
    * `query_result_type`
      (`CustomSQLTemplateModelQueryResultType`)None
    '''

    slack_credentials = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('SlackCredentials'))), graphql_name='slackCredentials')

    slack_channels = sgqlc.types.Field(sgqlc.types.non_null('SlackChannelV2Connection'), graphql_name='slackChannels', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''The account associated with the slack channel.

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    slack_msg_details = sgqlc.types.Field(sgqlc.types.non_null('SlackMessageDetailsConnection'), graphql_name='slackMsgDetails', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    resources = sgqlc.types.Field(sgqlc.types.non_null('ResourceConnection'), graphql_name='resources', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Customer account

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    account_domains = sgqlc.types.Field(sgqlc.types.non_null('DomainRestrictionConnection'), graphql_name='accountDomains', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Related account

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    alation_integrations = sgqlc.types.Field(sgqlc.types.non_null('AlationIntegrationConnection'), graphql_name='alationIntegrations', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    slack_credentials_v2 = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('SlackCredentialsV2'))), graphql_name='slackCredentialsV2')

    collection_preferences = sgqlc.types.Field(sgqlc.types.non_null('CollectionBlockConnection'), graphql_name='collectionPreferences', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    data_products = sgqlc.types.Field(sgqlc.types.non_null('DataProductConnection'), graphql_name='dataProducts', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    dashboards = sgqlc.types.Field(sgqlc.types.non_null('DataExplorerDashboardTypeConnection'), graphql_name='dashboards', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    comparison_dashboards = sgqlc.types.Field(sgqlc.types.non_null('DataExplorerComparisonDashboardTypeConnection'), graphql_name='comparisonDashboards', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    widgets = sgqlc.types.Field(sgqlc.types.non_null('DataExplorerWidgetTypeConnection'), graphql_name='widgets', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    identity_provider = sgqlc.types.Field('SamlIdentityProvider', graphql_name='identityProvider')

    tableau_accounts = sgqlc.types.Field(sgqlc.types.list_of('TableauAccount'), graphql_name='tableauAccounts')

    active_collection_regions = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='activeCollectionRegions')
    '''AWS Regions where a DC can be hosted'''

    internal_notifications = sgqlc.types.Field(sgqlc.types.list_of('InternalNotifications'), graphql_name='internalNotifications')
    '''MC internal account notifications.'''



class AccountAuditLog(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('timestamp', 'account_uuid', 'account_name', 'email', 'first_name', 'last_name', 'url', 'event_type', 'api_name', 'api_is_query', 'api_call_references', 'api_call_source', 'client_ip')
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='timestamp')
    '''Timestamp of the event'''

    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='accountUuid')
    '''Account ID'''

    account_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='accountName')
    '''Account name'''

    email = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='email')
    '''Email of the user'''

    first_name = sgqlc.types.Field(String, graphql_name='firstName')
    '''First name of the user'''

    last_name = sgqlc.types.Field(String, graphql_name='lastName')
    '''Last name of the user'''

    url = sgqlc.types.Field(String, graphql_name='url')
    '''URL on which the event occurred'''

    event_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='eventType')
    '''Event type'''

    api_name = sgqlc.types.Field(String, graphql_name='apiName')
    '''API name in case of GraphQL API calls'''

    api_is_query = sgqlc.types.Field(Boolean, graphql_name='apiIsQuery')
    '''Whether a GraphQL API call is a query'''

    api_call_references = sgqlc.types.Field(String, graphql_name='apiCallReferences')
    '''References (For instance UUIDs) passed as input parameters in
    GraphQL API calls
    '''

    api_call_source = sgqlc.types.Field(String, graphql_name='apiCallSource')
    '''Indicates the source of the GraphQL API call.For instance, `Web`
    or `Programmatic`
    '''

    client_ip = sgqlc.types.Field(String, graphql_name='clientIp')
    '''Client IP address'''



class AccountNotificationDigestSettings(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'interval_minutes', 'start_time', 'prev_execution_time', 'next_execution_time', 'created_time', 'uuid', 'digest_type', 'routing_rules')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    interval_minutes = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='intervalMinutes')
    '''Frequency interval in minutes to indicate how often to run the the
    schedule.
    '''

    start_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='startTime')
    '''First start time to run the schedule.'''

    prev_execution_time = sgqlc.types.Field(DateTime, graphql_name='prevExecutionTime')
    '''Previous successful execution time.'''

    next_execution_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='nextExecutionTime')
    '''Scheduled time for next run.'''

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdTime')
    '''Timestamp of when the schedule is created.'''

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Unique id of the digest settings.'''

    digest_type = sgqlc.types.Field(sgqlc.types.non_null(AccountNotificationDigestSettingsModelDigestType), graphql_name='digestType')
    '''Type of digest.'''

    routing_rules = sgqlc.types.Field('NotificationRoutingRule', graphql_name='routingRules')



class AccountNotificationRoutingRules(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'uuid', 'table_rules', 'tag_rules', 'sql_rules', 'table_stats_rules', 'domain_rules', 'monitor_labels', 'monitor_labels_match_type', 'table_id_rules', 'anomaly_types', 'incident_sub_types', 'custom_message', 'digest_settings', 'audience', 'notification_settings')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''The route rule id'''

    table_rules = sgqlc.types.Field(String, graphql_name='tableRules')
    '''Table/dataset based rules (regex)'''

    tag_rules = sgqlc.types.Field(JSONString, graphql_name='tagRules')
    '''Key and key/value based rules'''

    sql_rules = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name='sqlRules')
    '''Custom sql rules'''

    table_stats_rules = sgqlc.types.Field(JSONString, graphql_name='tableStatsRules')
    '''Rules based on table stats (importance_score, is_important).'''

    domain_rules = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name='domainRules')
    '''List of domain UUIDs to match event objects against.'''

    monitor_labels = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name='monitorLabels')
    '''labels'''

    monitor_labels_match_type = sgqlc.types.Field(sgqlc.types.non_null(AccountNotificationRoutingRulesModelMonitorLabelsMatchType), graphql_name='monitorLabelsMatchType')
    '''Specifies what logic operator to apply when matching labels'''

    table_id_rules = sgqlc.types.Field(JSONString, graphql_name='tableIdRules')
    '''Project/dataset/table based rules'''

    anomaly_types = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='anomalyTypes')
    '''List of supported incident types to send notifications for'''

    incident_sub_types = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='incidentSubTypes')
    '''All the incident sub-types this notification settings will alert
    on.
    '''

    custom_message = sgqlc.types.Field(String, graphql_name='customMessage')
    '''Custom text to be included with the notification'''

    digest_settings = sgqlc.types.Field(AccountNotificationDigestSettings, graphql_name='digestSettings')
    '''Digest notification settings for events matching the rule'''

    audience = sgqlc.types.Field('MonitorLabelObject', graphql_name='audience')
    '''Routing rules per audience'''

    notification_settings = sgqlc.types.Field('NotificationSetting', graphql_name='notificationSettings')



class AccountNotificationSetting(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'deleted_at', 'uuid', 'created_by', 'created_time', 'last_updated_by', 'last_update_time', 'name', 'is_template_managed', 'namespace', 'type', 'recipients', 'extra', 'routing_rules', 'notification_schedule_type', 'notification_enabled', 'audience', 'slack_msg_details', 'specification_rule', 'recipient', 'recipient_display_name', 'recipients_display_names', 'digest_settings', 'permalink', 'notification_count_history', 'anomaly_types', 'incident_sub_types', 'matching_incidents', 'custom_message', 'integration_id')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    deleted_at = sgqlc.types.Field(DateTime, graphql_name='deletedAt')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Effective ID for notification settings'''

    created_by = sgqlc.types.Field('User', graphql_name='createdBy')
    '''Creator of the notification'''

    created_time = sgqlc.types.Field(DateTime, graphql_name='createdTime')
    '''When the notification was first created'''

    last_updated_by = sgqlc.types.Field('User', graphql_name='lastUpdatedBy')
    '''User who last updated this notification'''

    last_update_time = sgqlc.types.Field(DateTime, graphql_name='lastUpdateTime')
    '''When the notification was last updated'''

    name = sgqlc.types.Field(String, graphql_name='name')
    '''Resource name for notifications created through notifications-as-
    code
    '''

    is_template_managed = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isTemplateManaged')
    '''Is this monitor managed by a configuration template
    (notifications-as-code)?
    '''

    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='namespace')
    '''Namespace of notification, used for notifications-as-code'''

    type = sgqlc.types.Field(sgqlc.types.non_null(AccountNotificationSettingsModelType), graphql_name='type')
    '''Type of notification integration (e.g. slack)'''

    recipients = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='recipients')
    '''Destinations to send notifications to'''

    extra = sgqlc.types.Field(JSONString, graphql_name='extra')
    '''Any additional information for various notification integrations'''

    routing_rules = sgqlc.types.Field(AccountNotificationRoutingRules, graphql_name='routingRules')

    notification_schedule_type = sgqlc.types.Field(sgqlc.types.non_null(AccountNotificationSettingsModelNotificationScheduleType), graphql_name='notificationScheduleType')
    '''Indicates whether the notification is of real time or digest types'''

    notification_enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='notificationEnabled')
    '''When enabled notifications for this setting are sent.'''

    audience = sgqlc.types.Field('MonitorLabelObject', graphql_name='audience')
    '''Notification settings per audience'''

    slack_msg_details = sgqlc.types.Field(sgqlc.types.non_null('SlackMessageDetailsConnection'), graphql_name='slackMsgDetails', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    specification_rule = sgqlc.types.Field(String, graphql_name='specificationRule')
    '''Deprecated. Use routingRules tableRules.'''

    recipient = sgqlc.types.Field(String, graphql_name='recipient')
    '''Deprecated. Use recipients instead.'''

    recipient_display_name = sgqlc.types.Field(String, graphql_name='recipientDisplayName')

    recipients_display_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='recipientsDisplayNames')

    digest_settings = sgqlc.types.Field(AccountNotificationDigestSettings, graphql_name='digestSettings')

    permalink = sgqlc.types.Field(String, graphql_name='permalink')

    notification_count_history = sgqlc.types.Field(sgqlc.types.list_of('NotificationDailyCount'), graphql_name='notificationCountHistory')
    '''Number of incidents per day for the past 30 days'''

    anomaly_types = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='anomalyTypes')
    '''anomaliesLimit notifications to specific incident types
    (default=all). Supported options include: , schema_changesLimit
    notifications to specific incident types (default=all). Supported
    options include: , json_schema_changesLimit notifications to
    specific incident types (default=all). Supported options include:
    , deleted_tablesLimit notifications to specific incident types
    (default=all). Supported options include: , metric_anomaliesLimit
    notifications to specific incident types (default=all). Supported
    options include: , custom_rule_anomaliesLimit notifications to
    specific incident types (default=all). Supported options include:
    , performance_anomaliesLimit notifications to specific incident
    types (default=all). Supported options include: , dbt_errorsLimit
    notifications to specific incident types (default=all). Supported
    options include: , etl_errorsLimit notifications to specific
    incident types (default=all). Supported options include: ,
    pseudo_integration_testLimit notifications to specific incident
    types (default=all). Supported options include: ,
    rule_run_execution_error
    '''

    incident_sub_types = sgqlc.types.Field(sgqlc.types.list_of(IncidentSubType), graphql_name='incidentSubTypes')
    '''Limit notifications to specific incident sub types (default=all).'''

    matching_incidents = sgqlc.types.Field(Int, graphql_name='matchingIncidents')

    custom_message = sgqlc.types.Field(String, graphql_name='customMessage')
    '''Message to add on every notification'''

    integration_id = sgqlc.types.Field(UUID, graphql_name='integrationId')
    '''Integration ID for the recipient'''



class AccountSecretOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name', 'scope', 'description', 'expires_at', 'value', 'created_by', 'created_at', 'updated_by', 'last_update')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''The secret name'''

    scope = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='scope')
    '''The secret scope'''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''The secret description'''

    expires_at = sgqlc.types.Field(DateTime, graphql_name='expiresAt')
    '''When does the secret expire. Null if it doesn't expire.'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''The secret value. Can only be accessed under specific conditions
    and by explicitly asking it with the 'reveal' option.
    '''

    created_by = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='createdBy')
    '''The user that created the secret'''

    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdAt')
    '''When the secret was created'''

    updated_by = sgqlc.types.Field(String, graphql_name='updatedBy')
    '''The user that updated the secret'''

    last_update = sgqlc.types.Field(DateTime, graphql_name='lastUpdate')
    '''When the secret was last updated'''



class AddBiConnectionMutation(sgqlc.types.Type):
    '''Add a bi connection and setup any associated jobs'''
    __schema__ = schema
    __field_names__ = ('connection',)
    connection = sgqlc.types.Field('Connection', graphql_name='connection')



class AddConnectionMutation(sgqlc.types.Type):
    '''Add a connection and setup any associated jobs. Creates a
    warehouse if not specified
    '''
    __schema__ = schema
    __field_names__ = ('connection',)
    connection = sgqlc.types.Field('Connection', graphql_name='connection')



class AddDatabricksConnectionMutation(sgqlc.types.Type):
    '''Add a databricks connection and setup any associated jobs. Creates
    a warehouse if not specified
    '''
    __schema__ = schema
    __field_names__ = ('connection',)
    connection = sgqlc.types.Field('Connection', graphql_name='connection')



class AddEtlConnectionMutation(sgqlc.types.Type):
    '''Add an etl connection and setup any associated jobs'''
    __schema__ = schema
    __field_names__ = ('connection',)
    connection = sgqlc.types.Field('Connection', graphql_name='connection')



class AddMonitorsLabels(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class AddStreamingConnectionMutation(sgqlc.types.Type):
    '''Add a connection for a streaming cluster and setup any associated
    jobs. Creates a streaming cluster if a cluster if not specified.
    '''
    __schema__ = schema
    __field_names__ = ('connection',)
    connection = sgqlc.types.Field('Connection', graphql_name='connection')



class AddStreamingSystemMutation(sgqlc.types.Type):
    '''Add a streaming system, which contains a set of streaming clusters
    that work together in the system.
    '''
    __schema__ = schema
    __field_names__ = ('streaming_system',)
    streaming_system = sgqlc.types.Field('StreamingSystem', graphql_name='streamingSystem')



class AddToCollectionBlockList(sgqlc.types.Type):
    '''Adds to the list of entities for which metadata collection is not
    allowed on this account.
    '''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''Whether the mutation succeeded.'''



class AdditionalData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('projects_validated', 'datasets_validated', 'tables_validated', 'queries_with_results', 'returned_data')
    projects_validated = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='projectsValidated')
    '''Projects that were validated.'''

    datasets_validated = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='datasetsValidated')
    '''Datasets that were validated.'''

    tables_validated = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='tablesValidated')
    '''Tables that were validated.'''

    queries_with_results = sgqlc.types.Field(sgqlc.types.list_of('QueryWithResults'), graphql_name='queriesWithResults')
    '''Queries that were executed for validation along with their
    results.
    '''

    returned_data = sgqlc.types.Field(GenericScalar, graphql_name='returnedData')
    '''JSON object containing all data returned from validation.'''



class Agent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'uuid', 'data_collector', 'endpoint', 'platform', 'agent_type', 'wrapper_type', 'auth_type', 'storage_type', 'credentials_s3_key', 'created_time', 'last_updated_time', 'wrapper_version', 'image_build', 'image_version', 'is_remote_upgradeable', 'is_deleted')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')
    '''Unique ID of the Agent.'''

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Unique UUID of the Agent.'''

    data_collector = sgqlc.types.Field(sgqlc.types.non_null('DataCollector'), graphql_name='dataCollector')
    '''Data Collector the Agent is registered to.'''

    endpoint = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='endpoint')
    '''The address of the Agent; bucket name, IP address, URL, etc.'''

    platform = sgqlc.types.Field(AgentModelPlatform, graphql_name='platform')
    '''The cloud platform the Agent is deployed in.'''

    agent_type = sgqlc.types.Field(sgqlc.types.non_null(AgentModelAgentType), graphql_name='agentType')
    '''Type of Agent deployed.'''

    wrapper_type = sgqlc.types.Field(AgentModelWrapperType, graphql_name='wrapperType')
    '''Type of MC provided wrapper, if any.'''

    auth_type = sgqlc.types.Field(sgqlc.types.non_null(AgentModelAuthType), graphql_name='authType')
    '''The authorization type used to connect to this Agent.'''

    storage_type = sgqlc.types.Field(sgqlc.types.non_null(AgentModelStorageType), graphql_name='storageType')
    '''Type of data store used by this Agent.'''

    credentials_s3_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='credentialsS3Key')
    '''Key to the credentials vault. Used to look up the agent
    credentials.
    '''

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdTime')
    '''Timestamp of when agent was registered.'''

    last_updated_time = sgqlc.types.Field(DateTime, graphql_name='lastUpdatedTime')
    '''Timestamp of the last image version update.'''

    wrapper_version = sgqlc.types.Field(String, graphql_name='wrapperVersion')
    '''If using an MC wrapper, the version number'''

    image_build = sgqlc.types.Field(String, graphql_name='imageBuild')
    '''Build number of agent image. Null if agent_type is
    DATA_STORE_AGENT
    '''

    image_version = sgqlc.types.Field(String, graphql_name='imageVersion')
    '''Docker image version of the agent. Null if agent_type is
    DATA_STORE_AGENT
    '''

    is_remote_upgradeable = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isRemoteUpgradeable')
    '''True if Monte Carlo has access to update the image version of the
    remote agent.
    '''

    is_deleted = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isDeleted')
    '''If the Agent is deregistered from the DC, this field will be
    'true', allowing the customer to register a different Agent with
    the data collector.
    '''



class AgentLogEntry(sgqlc.types.Type):
    '''A log entry from an agent.'''
    __schema__ = schema
    __field_names__ = ('timestamp', 'payload')
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='timestamp')
    '''Timestamp for the log entry.'''

    payload = sgqlc.types.Field(GenericScalar, graphql_name='payload')
    '''The JSON payload in the log entry. If the entry is a text message,
    then a dictionary with a single 'message' attribute is returned.
    '''



class AggregatedMetricDataType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query_group', 'metric_aggregation', 'timestamp', 'value')
    query_group = sgqlc.types.Field(String, graphql_name='queryGroup')
    '''Query group identifier'''

    metric_aggregation = sgqlc.types.Field('MetricAggregationOutputType', graphql_name='metricAggregation')
    '''Metric aggregation'''

    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')
    '''Aggregated data timestamp'''

    value = sgqlc.types.Field(Float, graphql_name='value')
    '''Aggregated data value'''



class AggregatedQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('date', 'group_id', 'query_hash', 'user', 'category', 'latest_query', 'latest_query_id', 'latest_query_timestamp', 'count', 'average_run_time')
    date = sgqlc.types.Field(Date, graphql_name='date')
    '''Date the queries occurred on'''

    group_id = sgqlc.types.Field(String, graphql_name='groupId')
    '''Hash that is shared by all the aggregated queries for writes'''

    query_hash = sgqlc.types.Field(String, graphql_name='queryHash')
    '''Hash that is shared by all the aggregated queries for reads'''

    user = sgqlc.types.Field(String, graphql_name='user')
    '''User of the aggregated queries'''

    category = sgqlc.types.Field(QueryCategory, graphql_name='category')
    '''Category of the aggregated queries'''

    latest_query = sgqlc.types.Field(String, graphql_name='latestQuery')
    '''Substring of the latest query from the aggregated group containing
    the first n characters defined by the query_characters parameter
    in the request
    '''

    latest_query_id = sgqlc.types.Field(String, graphql_name='latestQueryId')
    '''ID of the latest query'''

    latest_query_timestamp = sgqlc.types.Field(DateTime, graphql_name='latestQueryTimestamp')
    '''Timestamp of the latest query'''

    count = sgqlc.types.Field(Int, graphql_name='count')
    '''Count of the number of queries aggregated'''

    average_run_time = sgqlc.types.Field(Int, graphql_name='averageRunTime')
    '''Average run time of the aggregated queries in milliseconds'''



class AggregatedQueryResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('aggregated_queries', 'page_info')
    aggregated_queries = sgqlc.types.Field(sgqlc.types.list_of(AggregatedQuery), graphql_name='aggregatedQueries')
    '''List of aggregated queries which are grouped based on their group
    ID
    '''

    page_info = sgqlc.types.Field('NextPageInfo', graphql_name='pageInfo')
    '''Data necessary to paginate aggregated queries'''



class AirflowCapabilitiesResponse(sgqlc.types.Type):
    '''Airflow capabilities information'''
    __schema__ = schema
    __field_names__ = ('has_connection', 'has_callbacks')
    has_connection = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasConnection')
    '''True if the account has a connection set up'''

    has_callbacks = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasCallbacks')
    '''True if the account has callbacks set up'''



class AirflowDagConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('AirflowDagEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class AirflowDagEdge(sgqlc.types.Type):
    '''A Relay edge containing a `AirflowDag` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('AirflowDag', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class AirflowDagRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('AirflowDagRunEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class AirflowDagRunEdge(sgqlc.types.Type):
    '''A Relay edge containing a `AirflowDagRun` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('AirflowDagRun', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class AirflowDagRunInfo(sgqlc.types.Type):
    '''Airflow DAG Run information'''
    __schema__ = schema
    __field_names__ = ('run_id', 'start_date', 'end_date', 'success', 'duration', 'error')
    run_id = sgqlc.types.Field(String, graphql_name='runId')
    '''Run ID'''

    start_date = sgqlc.types.Field(DateTime, graphql_name='startDate')
    '''Start date'''

    end_date = sgqlc.types.Field(DateTime, graphql_name='endDate')
    '''End date'''

    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''Run was completed successfully'''

    duration = sgqlc.types.Field(Float, graphql_name='duration')
    '''Run duration in seconds'''

    error = sgqlc.types.Field(String, graphql_name='error')
    '''Error message in case of failure'''



class AirflowTaskConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('AirflowTaskEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class AirflowTaskEdge(sgqlc.types.Type):
    '''A Relay edge containing a `AirflowTask` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('AirflowTask', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class AirflowTaskRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('AirflowTaskRunEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class AirflowTaskRunEdge(sgqlc.types.Type):
    '''A Relay edge containing a `AirflowTaskRun` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('AirflowTaskRun', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class AirflowTaskRunStats(sgqlc.types.Type):
    '''Airflow Task Run statistics'''
    __schema__ = schema
    __field_names__ = ('num_run_success', 'num_run_failure', 'num_run_running', 'avg_duration', 'last_run', 'task_id', 'dag_id', 'resource__name', 'task_mcon', 'job_mcon', 'urls')
    num_run_success = sgqlc.types.Field(Int, graphql_name='numRunSuccess')
    '''Number of successful tasks'''

    num_run_failure = sgqlc.types.Field(Int, graphql_name='numRunFailure')
    '''Number of failed tasks'''

    num_run_running = sgqlc.types.Field(Int, graphql_name='numRunRunning')
    '''Number of running tasks'''

    avg_duration = sgqlc.types.Field(Float, graphql_name='avgDuration')
    '''Average duration of tasks'''

    last_run = sgqlc.types.Field(DateTime, graphql_name='lastRun')
    '''Last run timestamp of tasks'''

    task_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='taskId')
    '''Task ID of Airflow task'''

    dag_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='dagId')
    '''DAG ID of Airflow DAG'''

    resource__name = sgqlc.types.Field(String, graphql_name='resource_Name')
    '''Resource name of Airflow connection'''

    task_mcon = sgqlc.types.Field(String, graphql_name='taskMcon')
    '''MCON of Task for provided task_id'''

    job_mcon = sgqlc.types.Field(String, graphql_name='jobMcon')
    '''MCON of Job for provided job_id'''

    urls = sgqlc.types.Field('AirflowUrls', graphql_name='urls')
    '''URLs to Airflow UI'''



class AirflowTaskRunStatsConnection(sgqlc.types.relay.Connection):
    '''Airflow Task Run statistics response'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('AirflowTaskRunStatsEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class AirflowTaskRunStatsEdge(sgqlc.types.Type):
    '''A Relay edge containing a `AirflowTaskRunStats` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field(AirflowTaskRunStats, graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class AirflowUrls(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('dag', 'dag_run', 'task_run')
    dag = sgqlc.types.Field(String, graphql_name='dag')
    '''URL to Airflow UI for the DAG'''

    dag_run = sgqlc.types.Field(String, graphql_name='dagRun')
    '''URL to Airflow UI for the DAG run'''

    task_run = sgqlc.types.Field(String, graphql_name='taskRun')
    '''URL to Airflow UI for the task run'''



class AlationIntegrationConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('AlationIntegrationEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class AlationIntegrationEdge(sgqlc.types.Type):
    '''A Relay edge containing a `AlationIntegration` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('AlationIntegration', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class AssetUsageNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon_id', 'display_name', 'path', 'schema_count_is_ingested', 'schema_count_is_not_ingested', 'table_count', 'table_count_is_ingested', 'table_count_is_not_ingested', 'table_count_is_monitored', 'table_count_is_not_monitored', 'is_excluded', 'is_monitored')
    mcon_id = sgqlc.types.Field(String, graphql_name='mconId')
    '''MCON of the object represented by this node.'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''User-friendly display name of the catalog object.'''

    path = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='path')
    '''Object's hierarchy as list of ancestors plus self, if applicable.'''

    schema_count_is_ingested = sgqlc.types.Field(Int, graphql_name='schemaCountIsIngested')
    '''The number of schemas associated with this node that are ingested.'''

    schema_count_is_not_ingested = sgqlc.types.Field(Int, graphql_name='schemaCountIsNotIngested')
    '''The number of schemas associated with this node that are not
    ingested.
    '''

    table_count = sgqlc.types.Field(Int, graphql_name='tableCount')
    '''The number of tables associated with this node.'''

    table_count_is_ingested = sgqlc.types.Field(Int, graphql_name='tableCountIsIngested')
    '''The number of tables associated with this node that are ingested.'''

    table_count_is_not_ingested = sgqlc.types.Field(Int, graphql_name='tableCountIsNotIngested')
    '''The number of tables associated with this node that are not
    ingested.
    '''

    table_count_is_monitored = sgqlc.types.Field(Int, graphql_name='tableCountIsMonitored')
    '''The number of tables associated with this node that are monitored.'''

    table_count_is_not_monitored = sgqlc.types.Field(Int, graphql_name='tableCountIsNotMonitored')
    '''The number of tables associated with this node that are not
    monitored.
    '''

    is_excluded = sgqlc.types.Field(Boolean, graphql_name='isExcluded')
    '''Whether or not a table node is excluded from ingestion control.
    When it is True, it means that the table is excluded for
    ingestion.
    '''

    is_monitored = sgqlc.types.Field(Boolean, graphql_name='isMonitored')
    '''Whether or not a table node is monitored. When it is False, it
    means that the table is not monitored.
    '''



class AssetsUsageResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('nodes', 'has_next_page', 'next_page_offset', 'group_object_type', 'total_count')
    nodes = sgqlc.types.Field(sgqlc.types.list_of(AssetUsageNode), graphql_name='nodes')
    '''Nodes for current page.'''

    has_next_page = sgqlc.types.Field(Boolean, graphql_name='hasNextPage')
    '''If there are more nodes.'''

    next_page_offset = sgqlc.types.Field(Int, graphql_name='nextPageOffset')
    '''Where to start for next page, if next page exists.'''

    group_object_type = sgqlc.types.Field(String, graphql_name='groupObjectType')
    '''Object type of the group, when grouping by type.'''

    total_count = sgqlc.types.Field(Int, graphql_name='totalCount')
    '''Total number of nodes.'''



class AudienceMonitor(sgqlc.types.Type):
    '''Backed by a UserDefinedMonitorModel, as returned by
    resolve_custom_monitors
    '''
    __schema__ = schema
    __field_names__ = ('uuid', 'monitor_type', 'creator_id', 'name', 'description', 'audiences', 'incident_count_history', 'incident_count')
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Unique identifier for monitors'''

    monitor_type = sgqlc.types.Field(sgqlc.types.non_null(UserDefinedMonitors), graphql_name='monitorType')
    '''Type of monitor'''

    creator_id = sgqlc.types.Field(String, graphql_name='creatorId')
    '''Email of user who created the monitor'''

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''Monitor name, default or user-defined'''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''Monitor description'''

    audiences = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='audiences')
    '''List of audiences (labels) for the monitor'''

    incident_count_history = sgqlc.types.Field(sgqlc.types.list_of('NotificationIncidentDailyCount'), graphql_name='incidentCountHistory', args=sgqlc.types.ArgDict((
        ('audience_id', sgqlc.types.Arg(UUID, graphql_name='audienceId', default=None)),
))
    )
    '''Number of incidents per day for the past 30 days notified

    Arguments:

    * `audience_id` (`UUID`): filter by audience ID
    '''

    incident_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='incidentCount', args=sgqlc.types.ArgDict((
        ('audience_id', sgqlc.types.Arg(UUID, graphql_name='audienceId', default=None)),
))
    )
    '''The number of distinct notified incidents in the past 30 days

    Arguments:

    * `audience_id` (`UUID`): filter by audience ID
    '''



class AudienceMonitorConnection(sgqlc.types.relay.Connection):
    '''Audience monitor response'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('AudienceMonitorEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class AudienceMonitorEdge(sgqlc.types.Type):
    '''A Relay edge containing a `AudienceMonitor` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field(AudienceMonitor, graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class AuditLogEntryConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('AuditLogEntryEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class AuditLogEntryEdge(sgqlc.types.Type):
    '''A Relay edge containing a `AuditLogEntry` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('AuditLogEntry', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class AuthorRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name', 'username', 'email')
    name = sgqlc.types.Field(String, graphql_name='name')

    username = sgqlc.types.Field(String, graphql_name='username')

    email = sgqlc.types.Field(String, graphql_name='email')



class AuthorizationGroupOutput(sgqlc.types.Type):
    '''Authorization group used to configure access and permissions for
    users.
    '''
    __schema__ = schema
    __field_names__ = ('name', 'roles', 'version', 'is_managed', 'label', 'description', 'users', 'domain_restrictions', 'sso_group')
    name = sgqlc.types.Field(String, graphql_name='name')
    '''Unique to the account, human-readable name (for use in code/policy
    reference).
    '''

    roles = sgqlc.types.Field(sgqlc.types.list_of('RoleOutput'), graphql_name='roles')
    '''List of roles that are assigned to this group.'''

    version = sgqlc.types.Field(String, graphql_name='version')
    '''Version of the permissions definitions the group is designed for,
    ex: 2022-03-17. Defaults to current.
    '''

    is_managed = sgqlc.types.Field(Boolean, graphql_name='isManaged')
    '''Indicates if this group is managed by Monte Carlo. If so, only
    changes to group membership are supported.
    '''

    label = sgqlc.types.Field(String, graphql_name='label')
    '''UI/user-friendly display name, ex: Data Consumers'''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''Description/help text to help users understand the purpose of the
    group
    '''

    users = sgqlc.types.Field(sgqlc.types.list_of('AuthUser'), graphql_name='users')
    '''List of users  who are members of the group.'''

    domain_restrictions = sgqlc.types.Field(sgqlc.types.list_of('DomainRestriction'), graphql_name='domainRestrictions')
    '''List of domains this group is limited to.'''

    sso_group = sgqlc.types.Field(String, graphql_name='ssoGroup')
    '''SSO group name to map this authorization group to'''



class AwsAgentInfraDetailsResult(sgqlc.types.Type):
    '''Infrastructure information for an AWS Agent.'''
    __schema__ = schema
    __field_names__ = ('template', 'parameters')
    template = sgqlc.types.Field(sgqlc.types.non_null(GenericScalar), graphql_name='template')
    '''The CloudFormation template, in YAML format'''

    parameters = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(GenericScalar)), graphql_name='parameters')
    '''The current template parameters.'''



class AwsAgentLogsQueryResult(sgqlc.types.Type):
    '''The result for a CloudWatch query, includes events and status.'''
    __schema__ = schema
    __field_names__ = ('status', 'events')
    status = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='status')
    '''The status of the query, for example Running or Complete'''

    events = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(GenericScalar)), graphql_name='events')
    '''The log events.'''



class AwsAgentLogsStopQueryResult(sgqlc.types.Type):
    '''The result for stop_query.'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='success')
    '''Indicates if the query was successfully stopped'''



class AwsAgentStartLogsQueryResult(sgqlc.types.Type):
    '''The result for start_query including the query ID.'''
    __schema__ = schema
    __field_names__ = ('query_id',)
    query_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryId')
    '''The ID for the started query'''



class AwsAgentUpgradeLogEntry(sgqlc.types.Type):
    '''An upgrade log entry from an AWS agent.'''
    __schema__ = schema
    __field_names__ = ('timestamp', 'logical_resource_id', 'resource_status', 'resource_status_reason', 'resource_type')
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='timestamp')
    '''Timestamp for the log entry.'''

    logical_resource_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='logicalResourceId')
    '''Resource ID.'''

    resource_status = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='resourceStatus')
    '''Resource status, for example: 'UPDATE_COMPLETE'.'''

    resource_status_reason = sgqlc.types.Field(String, graphql_name='resourceStatusReason')
    '''Reason for the status, for example: 'User Initiated'.'''

    resource_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='resourceType')
    '''Resource type, for example: 'AWS::Lambda::Function'.'''



class BiContainer(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'account', 'uuid', 'data_collector', 'type', 'name', 'connections')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    account = sgqlc.types.Field(sgqlc.types.non_null(Account), graphql_name='account')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')

    data_collector = sgqlc.types.Field('DataCollector', graphql_name='dataCollector')

    type = sgqlc.types.Field(sgqlc.types.non_null(BiContainerModelType), graphql_name='type')

    name = sgqlc.types.Field(String, graphql_name='name')

    connections = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('Connection'))), graphql_name='connections')



class BiLineage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('workbook_id', 'friendly_name', 'content_url', 'owner_id', 'project_id', 'project_name', 'created', 'updated', 'total_views', 'workbook_creators', 'view_id', 'category', 'mcon', 'name', 'display_name')
    workbook_id = sgqlc.types.Field(String, graphql_name='workbookId')

    friendly_name = sgqlc.types.Field(String, graphql_name='friendlyName')

    content_url = sgqlc.types.Field(String, graphql_name='contentUrl')

    owner_id = sgqlc.types.Field(String, graphql_name='ownerId')

    project_id = sgqlc.types.Field(String, graphql_name='projectId')

    project_name = sgqlc.types.Field(String, graphql_name='projectName')

    created = sgqlc.types.Field(DateTime, graphql_name='created')

    updated = sgqlc.types.Field(DateTime, graphql_name='updated')

    total_views = sgqlc.types.Field(Int, graphql_name='totalViews')

    workbook_creators = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='workbookCreators')

    view_id = sgqlc.types.Field(String, graphql_name='viewId')

    category = sgqlc.types.Field(String, graphql_name='category')
    '''Node type'''

    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''Monte Carlo object name'''

    name = sgqlc.types.Field(String, graphql_name='name')
    '''Object name (table name, report name, etc)'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''Friendly display name'''



class BiMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('owner', 'site', 'uri', 'sheets', 'embedded_datasources', 'upstream_data_quality_warnings', 'view_path', 'workbook_id', 'workbook_name', 'view_id', 'luid', 'name', 'is_certified', 'has_extracts', 'has_active_warning', 'has_user_reference', 'contains_unsupported_custom_sql', 'extract_last_refresh_time', 'container_name', 'container_type', 'dashboards', 'model_name', 'source_file', 'view_name', 'connection_name', 'lookml_model_id', 'explore_id', 'explore_name', 'query', 'is_deleted', 'user_id', 'hidden', 'deleted_at', 'last_accessed_at', 'last_viewed_at', 'description', 'favorite_count', 'view_count', 'preferred_viewer', 'readonly', 'refresh_interval', 'load_configuration', 'edit_uri', 'look_ids', 'looker_dashboard_tiles', 'importance_score', 'dashboard_folder', 'avg_daily_views_last30_days', 'total_views_since_creation', 'model_id', 'dashboard', 'chart_title', 'user_emails', 'reason', 'is_manual', 'aggregation', 'date_range', 'workspace', 'created_by', 'modified_at', 'modified_by', 'report_type', 'tiles', 'workbook', 'url', 'email', 'org', 'kind', 'project_name', 'creation_time', 'created_at')
    owner = sgqlc.types.Field('OwnerRef', graphql_name='owner')

    site = sgqlc.types.Field('SiteRef', graphql_name='site')

    uri = sgqlc.types.Field(String, graphql_name='uri')

    sheets = sgqlc.types.Field(sgqlc.types.list_of('SheetDashboardRef'), graphql_name='sheets')

    embedded_datasources = sgqlc.types.Field(sgqlc.types.list_of('NameRef'), graphql_name='embeddedDatasources')

    upstream_data_quality_warnings = sgqlc.types.Field(sgqlc.types.list_of('DataQualityWarningsRef'), graphql_name='upstreamDataQualityWarnings')

    view_path = sgqlc.types.Field(String, graphql_name='viewPath')

    workbook_id = sgqlc.types.Field(String, graphql_name='workbookId')

    workbook_name = sgqlc.types.Field(String, graphql_name='workbookName')

    view_id = sgqlc.types.Field(String, graphql_name='viewId')

    luid = sgqlc.types.Field(String, graphql_name='luid')

    name = sgqlc.types.Field(String, graphql_name='name')

    is_certified = sgqlc.types.Field(Boolean, graphql_name='isCertified')

    has_extracts = sgqlc.types.Field(Boolean, graphql_name='hasExtracts')

    has_active_warning = sgqlc.types.Field(Boolean, graphql_name='hasActiveWarning')

    has_user_reference = sgqlc.types.Field(Boolean, graphql_name='hasUserReference')

    contains_unsupported_custom_sql = sgqlc.types.Field(Boolean, graphql_name='containsUnsupportedCustomSql')

    extract_last_refresh_time = sgqlc.types.Field(String, graphql_name='extractLastRefreshTime')

    container_name = sgqlc.types.Field(String, graphql_name='containerName')

    container_type = sgqlc.types.Field(String, graphql_name='containerType')

    dashboards = sgqlc.types.Field(sgqlc.types.list_of('SheetDashboardRef'), graphql_name='dashboards')

    model_name = sgqlc.types.Field(String, graphql_name='modelName')

    source_file = sgqlc.types.Field(String, graphql_name='sourceFile')

    view_name = sgqlc.types.Field(String, graphql_name='viewName')

    connection_name = sgqlc.types.Field(String, graphql_name='connectionName')

    lookml_model_id = sgqlc.types.Field(String, graphql_name='lookmlModelId')

    explore_id = sgqlc.types.Field(String, graphql_name='exploreId')

    explore_name = sgqlc.types.Field(String, graphql_name='exploreName')

    query = sgqlc.types.Field('QueryRef', graphql_name='query')

    is_deleted = sgqlc.types.Field(Boolean, graphql_name='isDeleted')

    user_id = sgqlc.types.Field(String, graphql_name='userId')

    hidden = sgqlc.types.Field(String, graphql_name='hidden')

    deleted_at = sgqlc.types.Field(String, graphql_name='deletedAt')

    last_accessed_at = sgqlc.types.Field(String, graphql_name='lastAccessedAt')

    last_viewed_at = sgqlc.types.Field(String, graphql_name='lastViewedAt')

    description = sgqlc.types.Field(String, graphql_name='description')

    favorite_count = sgqlc.types.Field(Int, graphql_name='favoriteCount')

    view_count = sgqlc.types.Field(Int, graphql_name='viewCount')

    preferred_viewer = sgqlc.types.Field(String, graphql_name='preferredViewer')

    readonly = sgqlc.types.Field(Boolean, graphql_name='readonly')

    refresh_interval = sgqlc.types.Field(String, graphql_name='refreshInterval')

    load_configuration = sgqlc.types.Field(String, graphql_name='loadConfiguration')

    edit_uri = sgqlc.types.Field(String, graphql_name='editUri')

    look_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='lookIds')

    looker_dashboard_tiles = sgqlc.types.Field(sgqlc.types.list_of('LookerDashboardTileRef'), graphql_name='lookerDashboardTiles')

    importance_score = sgqlc.types.Field(Float, graphql_name='importanceScore')

    dashboard_folder = sgqlc.types.Field(String, graphql_name='dashboardFolder')

    avg_daily_views_last30_days = sgqlc.types.Field(Float, graphql_name='avgDailyViewsLast30Days')

    total_views_since_creation = sgqlc.types.Field(Int, graphql_name='totalViewsSinceCreation')

    model_id = sgqlc.types.Field(String, graphql_name='modelId')

    dashboard = sgqlc.types.Field('SheetDashboardRef', graphql_name='dashboard')

    chart_title = sgqlc.types.Field(String, graphql_name='chartTitle')

    user_emails = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='userEmails')

    reason = sgqlc.types.Field(String, graphql_name='reason')

    is_manual = sgqlc.types.Field(String, graphql_name='isManual')

    aggregation = sgqlc.types.Field(String, graphql_name='aggregation')

    date_range = sgqlc.types.Field(String, graphql_name='dateRange')

    workspace = sgqlc.types.Field('PowerBIWorkSpaceRef', graphql_name='workspace')

    created_by = sgqlc.types.Field(String, graphql_name='createdBy')

    modified_at = sgqlc.types.Field(String, graphql_name='modifiedAt')

    modified_by = sgqlc.types.Field(String, graphql_name='modifiedBy')

    report_type = sgqlc.types.Field(String, graphql_name='reportType')

    tiles = sgqlc.types.Field(sgqlc.types.list_of('PowerBIDashboardTileRef'), graphql_name='tiles')

    workbook = sgqlc.types.Field(String, graphql_name='workbook')

    url = sgqlc.types.Field(String, graphql_name='url')

    email = sgqlc.types.Field(String, graphql_name='email')

    org = sgqlc.types.Field(String, graphql_name='org')

    kind = sgqlc.types.Field(String, graphql_name='kind')

    project_name = sgqlc.types.Field(String, graphql_name='projectName')

    creation_time = sgqlc.types.Field(String, graphql_name='creationTime')

    created_at = sgqlc.types.Field(String, graphql_name='createdAt')



class BiWarehouseSources(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('warehouse_resource_id', 'warehouse_resource_type', 'bi_warehouse_id')
    warehouse_resource_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='warehouseResourceId')
    '''Warehouse resource ID. This is a Monte Carlo ID'''

    warehouse_resource_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='warehouseResourceType')
    '''Warehouse type. Examples: snowflake, redshift, etc.'''

    bi_warehouse_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='biWarehouseId')
    '''The warehouse ID in the BI instance of the customer. This is an ID
    in the customer ID space and is not a Monte Carlo ID.
    '''



class BigQueryProject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('full_project_id', 'friendly_name')
    full_project_id = sgqlc.types.Field(String, graphql_name='fullProjectId')

    friendly_name = sgqlc.types.Field(String, graphql_name='friendlyName')



class BlastRadiusCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query_count', 'user_count')
    query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='queryCount')
    '''The number of queries'''

    user_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='userCount')
    '''The number of users'''



class BlastRadiusUserQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('date', 'tables', 'query_hash', 'query_count')
    date = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='date')
    '''The date the query was ran'''

    tables = sgqlc.types.Field(sgqlc.types.list_of('TableInfo'), graphql_name='tables')
    '''The impacted tables in the query'''

    query_hash = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryHash')
    '''The query hash'''

    query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='queryCount')
    '''The number of times the query was ran'''



class BulkCreateOrUpdateObjectProperties(sgqlc.types.Type):
    '''Create or update a list of properties (tags) for objects (e.g.
    tables, fields, etc.)
    '''
    __schema__ = schema
    __field_names__ = ('object_properties',)
    object_properties = sgqlc.types.Field(sgqlc.types.list_of('ObjectProperty'), graphql_name='objectProperties')
    '''List of properties created or updated'''



class BulkUpdateIncidents(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class CatalogNavNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon_id', 'display_name', 'object_type', 'path', 'table_count', 'may_have_children')
    mcon_id = sgqlc.types.Field(String, graphql_name='mconId')
    '''MCON ID of the object represented by this node.'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''User-friendly display name of the catalog object.'''

    object_type = sgqlc.types.Field(String, graphql_name='objectType')
    '''The catalog object's type.'''

    path = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='path')
    '''Object's hierarchy as list of ancestors plus self, if applicable.'''

    table_count = sgqlc.types.Field(Int, graphql_name='tableCount')
    '''The number of tables associated with this node.'''

    may_have_children = sgqlc.types.Field(Boolean, graphql_name='mayHaveChildren')
    '''Whether or not the node may have children. (Does not indicate if
    it actually does.)
    '''



class CatalogNavResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('nodes', 'has_next_page', 'next_page_offset', 'group_object_type')
    nodes = sgqlc.types.Field(sgqlc.types.list_of(CatalogNavNode), graphql_name='nodes')
    '''Nodes for current nav page.'''

    has_next_page = sgqlc.types.Field(Boolean, graphql_name='hasNextPage')
    '''If there are more nodes.'''

    next_page_offset = sgqlc.types.Field(Int, graphql_name='nextPageOffset')
    '''Where to start for next page, if next page exists.'''

    group_object_type = sgqlc.types.Field(String, graphql_name='groupObjectType')
    '''Object type of the group, when grouping by type.'''



class CatalogObjectMetadataConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('CatalogObjectMetadataEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class CatalogObjectMetadataEdge(sgqlc.types.Type):
    '''A Relay edge containing a `CatalogObjectMetadata` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('CatalogObjectMetadata', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class CatalogUsageNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon_id', 'display_name', 'object_type', 'path', 'schema_count_is_ingested', 'schema_count_is_not_ingested', 'table_count', 'table_count_is_ingested', 'table_count_is_not_ingested', 'table_count_is_monitored', 'table_count_is_not_monitored', 'is_excluded', 'is_monitored', 'may_have_children')
    mcon_id = sgqlc.types.Field(String, graphql_name='mconId')
    '''MCON ID of the object represented by this node.'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''User-friendly display name of the catalog object.'''

    object_type = sgqlc.types.Field(String, graphql_name='objectType')
    '''The catalog object's type.'''

    path = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='path')
    '''Object's hierarchy as list of ancestors plus self, if applicable.'''

    schema_count_is_ingested = sgqlc.types.Field(Int, graphql_name='schemaCountIsIngested')
    '''The number of schemas associated with this node that are ingested.'''

    schema_count_is_not_ingested = sgqlc.types.Field(Int, graphql_name='schemaCountIsNotIngested')
    '''The number of schemas associated with this node that are not
    ingested.
    '''

    table_count = sgqlc.types.Field(Int, graphql_name='tableCount')
    '''The number of tables associated with this node.'''

    table_count_is_ingested = sgqlc.types.Field(Int, graphql_name='tableCountIsIngested')
    '''The number of tables associated with this node that are ingested.'''

    table_count_is_not_ingested = sgqlc.types.Field(Int, graphql_name='tableCountIsNotIngested')
    '''The number of tables associated with this node that are not
    ingested.
    '''

    table_count_is_monitored = sgqlc.types.Field(Int, graphql_name='tableCountIsMonitored')
    '''The number of tables associated with this node that are monitored.'''

    table_count_is_not_monitored = sgqlc.types.Field(Int, graphql_name='tableCountIsNotMonitored')
    '''The number of tables associated with this node that are not
    monitored.
    '''

    is_excluded = sgqlc.types.Field(Boolean, graphql_name='isExcluded')
    '''Whether or not a table node is excluded from ingestion control.
    When it is True, it means that the table is excluded for
    ingestion.
    '''

    is_monitored = sgqlc.types.Field(Boolean, graphql_name='isMonitored')
    '''Whether or not a table node is monitored. When it is False, it
    means that the table is not monitored.
    '''

    may_have_children = sgqlc.types.Field(Boolean, graphql_name='mayHaveChildren')
    '''Whether or not the node may have children. (Does not indicate if
    it actually does.)
    '''



class CatalogUsageNodesResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('nodes', 'has_next_page', 'next_page_offset', 'group_object_type', 'total_counts')
    nodes = sgqlc.types.Field(sgqlc.types.list_of(CatalogUsageNode), graphql_name='nodes')
    '''Nodes for current page.'''

    has_next_page = sgqlc.types.Field(Boolean, graphql_name='hasNextPage')
    '''If there are more nodes.'''

    next_page_offset = sgqlc.types.Field(Int, graphql_name='nextPageOffset')
    '''Where to start for next page, if next page exists.'''

    group_object_type = sgqlc.types.Field(String, graphql_name='groupObjectType')
    '''Object type of the group, when grouping by type.'''

    total_counts = sgqlc.types.Field(Int, graphql_name='totalCounts')
    '''Total number of nodes.'''



class CategoryLabelRank(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('label', 'rank')
    label = sgqlc.types.Field(String, graphql_name='label')

    rank = sgqlc.types.Field(Float, graphql_name='rank')



class CircuitBreakerState(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('job_execution_uuid', 'account_uuid', 'resource_uuid', 'custom_rule_uuid', 'status', 'log')
    job_execution_uuid = sgqlc.types.Field(UUID, graphql_name='jobExecutionUuid')
    '''UUID for the job execution that identifies the circuit breaker run'''

    account_uuid = sgqlc.types.Field(UUID, graphql_name='accountUuid')
    '''UUID for the account that owns the rule'''

    resource_uuid = sgqlc.types.Field(UUID, graphql_name='resourceUuid')
    '''UUID for the warehouse that owns the rule'''

    custom_rule_uuid = sgqlc.types.Field(UUID, graphql_name='customRuleUuid')
    '''UUID for the custom rule that was run as a circuit breaker'''

    status = sgqlc.types.Field(SqlJobCheckpointStatus, graphql_name='status')
    '''Status of the circuit breaker run'''

    log = sgqlc.types.Field(JSONString, graphql_name='log')
    '''Array of JSON objects containing state for each stage of the job
    execution
    '''



class CleanupCollectorRecordInAccount(sgqlc.types.Type):
    '''Deletes an unassociated collector record in the account. This does
    not delete the CloudFormation stack and will not succeed if the
    collector is active and/or associated with a warehouse.
    '''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''If the collector record was deleted'''



class CollectionBlockConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('CollectionBlockEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class CollectionBlockEdge(sgqlc.types.Type):
    '''A Relay edge containing a `CollectionBlock` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('CollectionBlock', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class CollectionDataSet(sgqlc.types.Type):
    '''Data set to collect data.'''
    __schema__ = schema
    __field_names__ = ('resource_id', 'project', 'dataset')
    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceId')
    '''The resource UUID of the dataset.'''

    project = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='project')
    '''Top-level object hierarchy e.g. database, catalog, etc.'''

    dataset = sgqlc.types.Field(String, graphql_name='dataset')
    '''Intermediate object hierarchy e.g. schema, database, etc.'''



class CollectionDataSetConnection(sgqlc.types.relay.Connection):
    '''Datasets to collect data'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('CollectionDataSetEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class CollectionDataSetEdge(sgqlc.types.Type):
    '''A Relay edge containing a `CollectionDataSet` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field(CollectionDataSet, graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class CollectionProperties(sgqlc.types.Type):
    '''Collection infrastructure properties'''
    __schema__ = schema
    __field_names__ = ('cross_account_external_id', 'customer_account_token', 'code_bucket', 'code_version', 'platform_aws_account_id', 'docker_image_uri', 'platform_region_details')
    cross_account_external_id = sgqlc.types.Field(String, graphql_name='crossAccountExternalId')
    '''External id for cross account IAM role'''

    customer_account_token = sgqlc.types.Field(String, graphql_name='customerAccountToken')
    '''Customer account token (unique per data collector)'''

    code_bucket = sgqlc.types.Field(String, graphql_name='codeBucket')
    '''S3 bucket containing data collector code'''

    code_version = sgqlc.types.Field(String, graphql_name='codeVersion')
    '''Data collector code version'''

    platform_aws_account_id = sgqlc.types.Field(String, graphql_name='platformAwsAccountId')
    '''Monte Carlo AWS account id'''

    docker_image_uri = sgqlc.types.Field(String, graphql_name='dockerImageUri')
    '''URI of the docker image for the data collector'''

    platform_region_details = sgqlc.types.Field('PlatformRegionProperties', graphql_name='platformRegionDetails')
    '''Region-specific properties'''



class ColumnLineage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('selected_column', 'lineage_sources')
    selected_column = sgqlc.types.Field(String, graphql_name='selectedColumn')
    '''The column on the destination table'''

    lineage_sources = sgqlc.types.Field(sgqlc.types.list_of('LineageSources'), graphql_name='lineageSources')
    '''Direct source lineage of the selected column'''



class ComparableDashboardType(sgqlc.types.Type):
    '''Another dashboard that is compatible for comparison'''
    __schema__ = schema
    __field_names__ = ('dashboard_uuid', 'shared_time_axis_field_name', 'shared_field_names')
    dashboard_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dashboardUuid')

    shared_time_axis_field_name = sgqlc.types.Field(String, graphql_name='sharedTimeAxisFieldName')
    '''Shared time axis field name'''

    shared_field_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='sharedFieldNames')
    '''Fields shared between dashboards'''



class ConfigureAirflowLogEvents(sgqlc.types.Type):
    '''Configure collection of Airflow logs via S3 events'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class ConfigureMetadataEvents(sgqlc.types.Type):
    '''Configure collection of metadata via S3 events'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class ConfigureQueryLogEvents(sgqlc.types.Type):
    '''Configure collection of query logs via S3 events'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class ConnectedLineageGraphNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'requested_node', 'directly_connected_nodes')
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''Monte Carlo full identifier for an entity'''

    requested_node = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='requestedNode')
    '''Whether the node was added or is part of the original request'''

    directly_connected_nodes = sgqlc.types.Field(sgqlc.types.list_of('LineageGraphEdgeNode'), graphql_name='directlyConnectedNodes')
    '''Nodes directly connected to the entity, including edge properties'''



class ConnectedLineageGraphNodeWithJobs(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('graph', 'jobs')
    graph = sgqlc.types.Field(sgqlc.types.list_of(ConnectedLineageGraphNode), graphql_name='graph')
    '''Edges data'''

    jobs = sgqlc.types.Field(sgqlc.types.list_of('LineageGraphJobData'), graphql_name='jobs')
    '''Job data for each mcon'''



class Connection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('id', 'uuid', 'type', 'subtype', 'account', 'warehouse', 'bi_container', 'etl_container', 'job_types', 'streaming_cluster', 'credentials_s3_key', 'integration_gateway_credentials_key', 'data', 'created_on', 'updated_on', 'is_active', 'disabled_on', 'dbt_projects', 'connection_identifier', 'connection_identifiers', 'job_errors')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')

    type = sgqlc.types.Field(sgqlc.types.non_null(ConnectionModelType), graphql_name='type')

    subtype = sgqlc.types.Field(String, graphql_name='subtype')
    '''Subtype of a plugin connection'''

    account = sgqlc.types.Field(Account, graphql_name='account')

    warehouse = sgqlc.types.Field('Warehouse', graphql_name='warehouse')

    bi_container = sgqlc.types.Field(BiContainer, graphql_name='biContainer')

    etl_container = sgqlc.types.Field('EtlContainer', graphql_name='etlContainer')

    job_types = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(String))), graphql_name='jobTypes')

    streaming_cluster = sgqlc.types.Field('StreamingCluster', graphql_name='streamingCluster')

    credentials_s3_key = sgqlc.types.Field(String, graphql_name='credentialsS3Key')

    integration_gateway_credentials_key = sgqlc.types.Field(String, graphql_name='integrationGatewayCredentialsKey')

    data = sgqlc.types.Field(JSONString, graphql_name='data')

    created_on = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdOn')

    updated_on = sgqlc.types.Field(DateTime, graphql_name='updatedOn')

    is_active = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isActive')

    disabled_on = sgqlc.types.Field(DateTime, graphql_name='disabledOn')

    dbt_projects = sgqlc.types.Field(sgqlc.types.non_null('DbtProjectConnection'), graphql_name='dbtProjects', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''dbt connection

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    connection_identifier = sgqlc.types.Field('ConnectionIdentifier', graphql_name='connectionIdentifier')

    connection_identifiers = sgqlc.types.Field(sgqlc.types.list_of('ConnectionIdentifier'), graphql_name='connectionIdentifiers')

    job_errors = sgqlc.types.Field(sgqlc.types.list_of('JobError'), graphql_name='jobErrors')
    '''Errors related to the connection'''



class ConnectionIdentifier(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('key', 'value')
    key = sgqlc.types.Field(String, graphql_name='key')
    '''Connection credential key serving as an identifier'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Value of connection identifier key'''



class ConnectionValidation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('type', 'message', 'data')
    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='type')
    '''Validation type'''

    message = sgqlc.types.Field(String, graphql_name='message')
    '''Message describing the validation'''

    data = sgqlc.types.Field('ConnectionValidationData', graphql_name='data')
    '''Metadata for the validation'''



class ConnectionValidationData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('database', 'table', 'error')
    database = sgqlc.types.Field(String, graphql_name='database')
    '''Database name'''

    table = sgqlc.types.Field(String, graphql_name='table')
    '''Table identifier'''

    error = sgqlc.types.Field(String, graphql_name='error')
    '''Error message'''



class ConvertConfigTemplateToUiMonitors(sgqlc.types.Type):
    '''Convert a config template to UI Monitors'''
    __schema__ = schema
    __field_names__ = ('response',)
    response = sgqlc.types.Field('ConvertConfigTemplateToUiMonitorsOutput', graphql_name='response')
    '''Exported template'''



class ConvertConfigTemplateToUiMonitorsOutput(sgqlc.types.Type):
    '''Convert config template to UI monitors response'''
    __schema__ = schema
    __field_names__ = ('monitors',)
    monitors = sgqlc.types.Field(sgqlc.types.list_of('UserDefinedMonitorV2'), graphql_name='monitors')
    '''Converted monitors'''



class ConvertUiMonitorsToConfigTemplate(sgqlc.types.Type):
    '''Convert a set of monitors to a config template'''
    __schema__ = schema
    __field_names__ = ('response',)
    response = sgqlc.types.Field('ConvertUiMonitorsToConfigTemplateOutput', graphql_name='response')
    '''Exported template'''



class ConvertUiMonitorsToConfigTemplateOutput(sgqlc.types.Type):
    '''Convert monitors to config template response'''
    __schema__ = schema
    __field_names__ = ('monitors', 'config_template_as_yaml', 'config_template_as_dict', 'errors')
    monitors = sgqlc.types.Field(sgqlc.types.list_of('UserDefinedMonitor'), graphql_name='monitors')
    '''Converted monitors'''

    config_template_as_yaml = sgqlc.types.Field(String, graphql_name='configTemplateAsYaml')
    '''Config Template as YAML'''

    config_template_as_dict = sgqlc.types.Field(JSONString, graphql_name='configTemplateAsDict')
    '''Config Template as a dictionary'''

    errors = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='errors')
    '''Errors encountered'''



class CorrelationSamplingMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('time_axis', 'explanatory_field')
    time_axis = sgqlc.types.Field('TimeAxisMetadata', graphql_name='timeAxis')
    '''Field used as the time axis'''

    explanatory_field = sgqlc.types.Field('ExplanatoryFieldMetadata', graphql_name='explanatoryField')
    '''Field from which values are sampled'''



class CorrelationSamplingResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('sample',)
    sample = sgqlc.types.Field(sgqlc.types.list_of('RcaPlotData'), graphql_name='sample')
    '''List of value distribution samples'''



class CreateAccessToken(sgqlc.types.Type):
    '''Generate an API Access Token and associate to user'''
    __schema__ = schema
    __field_names__ = ('access_token',)
    access_token = sgqlc.types.Field(AccessToken, graphql_name='accessToken')



class CreateAccountSecret(sgqlc.types.Type):
    '''Create an account secret'''
    __schema__ = schema
    __field_names__ = ('secret',)
    secret = sgqlc.types.Field(AccountSecretOutput, graphql_name='secret')
    '''The secret that was created'''



class CreateCollectorRecord(sgqlc.types.Type):
    '''Create an additional collector record (with template) in the
    account.
    '''
    __schema__ = schema
    __field_names__ = ('dc',)
    dc = sgqlc.types.Field('DataCollector', graphql_name='dc')
    '''The data collector that was created'''



class CreateCustomMetricRule(sgqlc.types.Type):
    '''Deprecated, use CreateOrUpdateCustomMetricRule instead'''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateCustomRule(sgqlc.types.Type):
    '''Deprecated, use CreateOrUpdateCustomRule instead'''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateCustomUser(sgqlc.types.Type):
    '''Create a CustomUser'''
    __schema__ = schema
    __field_names__ = ('custom_user',)
    custom_user = sgqlc.types.Field('CustomUser', graphql_name='customUser')



class CreateDatabricksNotebookJob(sgqlc.types.Type):
    '''Create Databricks directory, upload the collection notebook and
    setup a job.
    '''
    __schema__ = schema
    __field_names__ = ('databricks',)
    databricks = sgqlc.types.Field('DatabricksJobResponse', graphql_name='databricks')
    '''The Databricks resources which were created.'''



class CreateDatabricksSecret(sgqlc.types.Type):
    '''Create Databricks scope and secret for an integration key.'''
    __schema__ = schema
    __field_names__ = ('success', 'scope_name', 'secret_name')
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''Indicates whether the operation was completed successfully.'''

    scope_name = sgqlc.types.Field(String, graphql_name='scopeName')
    '''Scope name that the secret was created with'''

    secret_name = sgqlc.types.Field(String, graphql_name='secretName')
    '''Name of the secret that was created'''



class CreateIntegrationKey(sgqlc.types.Type):
    '''Create an integration key'''
    __schema__ = schema
    __field_names__ = ('key',)
    key = sgqlc.types.Field('IntegrationKey', graphql_name='key')
    '''Integration key id and secret (only available once).'''



class CreateJiraIntegration(sgqlc.types.Type):
    '''Create a Jira integration'''
    __schema__ = schema
    __field_names__ = ('jira_integration',)
    jira_integration = sgqlc.types.Field('JiraIntegrationOutput', graphql_name='jiraIntegration')
    '''The integration that was created'''



class CreateJiraTicketForIncident(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('jira_ticket',)
    jira_ticket = sgqlc.types.Field('JiraTicketOutput', graphql_name='jiraTicket')
    '''The created Jira ticket'''



class CreateOrUpdateAgent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('agent_id', 'validation_result')
    agent_id = sgqlc.types.Field(UUID, graphql_name='agentId')
    '''The UUID of the agent that was created or updated.'''

    validation_result = sgqlc.types.Field('TestCredentialsV2Response', graphql_name='validationResult')
    '''Result validating the provided parameters.'''



class CreateOrUpdateAlationIntegration(sgqlc.types.Type):
    '''Create or update Alation integration'''
    __schema__ = schema
    __field_names__ = ('alation_integration',)
    alation_integration = sgqlc.types.Field('AlationIntegration', graphql_name='alationIntegration')



class CreateOrUpdateAlationTableFlag(sgqlc.types.Type):
    '''Create or update Alation flag on a table. The flag could be a
    warning or a deprecation.
    '''
    __schema__ = schema
    __field_names__ = ('alation_flag_ids',)
    alation_flag_ids = sgqlc.types.Field(sgqlc.types.list_of(Int), graphql_name='alationFlagIds')
    '''List of IDs of flags created. This list will have more than one
    entry when multiple tables matched the input full_table_id.
    '''



class CreateOrUpdateAudience(sgqlc.types.Type):
    '''Create a notification audience'''
    __schema__ = schema
    __field_names__ = ('audience',)
    audience = sgqlc.types.Field('NotificationAudience', graphql_name='audience')



class CreateOrUpdateAudienceNotificationSetting(sgqlc.types.Type):
    '''Create or update an audience notification setting'''
    __schema__ = schema
    __field_names__ = ('notification_setting',)
    notification_setting = sgqlc.types.Field('NotificationSetting', graphql_name='notificationSetting')
    '''Setting that was created or updated'''



class CreateOrUpdateAudienceRoutingRule(sgqlc.types.Type):
    '''Create or update an audience routing rule'''
    __schema__ = schema
    __field_names__ = ('routing_rule',)
    routing_rule = sgqlc.types.Field('NotificationRoutingRule', graphql_name='routingRule')
    '''Routing rule that was created or updated'''



class CreateOrUpdateAuthorizationGroup(sgqlc.types.Type):
    '''Create or update an authorization group.'''
    __schema__ = schema
    __field_names__ = ('authorization_group',)
    authorization_group = sgqlc.types.Field(AuthorizationGroupOutput, graphql_name='authorizationGroup')
    '''Created or updated authorization group.'''



class CreateOrUpdateCatalogObjectMetadata(sgqlc.types.Type):
    '''Create or update an asset's metadata'''
    __schema__ = schema
    __field_names__ = ('catalog_object_metadata',)
    catalog_object_metadata = sgqlc.types.Field('CatalogObjectMetadata', graphql_name='catalogObjectMetadata')
    '''Object metadata created or updated'''



class CreateOrUpdateComparisonRule(sgqlc.types.Type):
    '''Create or update a comparison rule'''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateOrUpdateCustomMetricRule(sgqlc.types.Type):
    '''Create or update a custom metric rule'''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateOrUpdateCustomRule(sgqlc.types.Type):
    '''Create or update a custom rule'''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateOrUpdateCustomSQLTemplate(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('custom_sql_template',)
    custom_sql_template = sgqlc.types.Field('CustomSQLTemplate', graphql_name='customSqlTemplate')



class CreateOrUpdateDataExplorerComparisonDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('data_explorer_comparison_dashboard',)
    data_explorer_comparison_dashboard = sgqlc.types.Field('DataExplorerComparisonDashboardType', graphql_name='dataExplorerComparisonDashboard')



class CreateOrUpdateDataExplorerDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('data_explorer_dashboard',)
    data_explorer_dashboard = sgqlc.types.Field('DataExplorerDashboardType', graphql_name='dataExplorerDashboard')



class CreateOrUpdateDataMaintenanceEntry(sgqlc.types.Type):
    '''Creates or updates a data maintenance period'''
    __schema__ = schema
    __field_names__ = ('entry',)
    entry = sgqlc.types.Field('DataMaintenanceEntry', graphql_name='entry')



class CreateOrUpdateDataProduct(sgqlc.types.Type):
    '''Create or update a data product'''
    __schema__ = schema
    __field_names__ = ('data_product',)
    data_product = sgqlc.types.Field('DataProduct', graphql_name='dataProduct')
    '''Created or updated domain'''



class CreateOrUpdateDomain(sgqlc.types.Type):
    '''Create or update a domain'''
    __schema__ = schema
    __field_names__ = ('domain',)
    domain = sgqlc.types.Field('DomainOutput', graphql_name='domain')
    '''Created or updated domain'''



class CreateOrUpdateFieldQualityRule(sgqlc.types.Type):
    '''Create or update a field quality rule'''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateOrUpdateFreshnessCustomRule(sgqlc.types.Type):
    '''Create or update a freshness custom rule'''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateOrUpdateIncidentComment(sgqlc.types.Type):
    '''Creates or updates a comment on an incident'''
    __schema__ = schema
    __field_names__ = ('comment_event',)
    comment_event = sgqlc.types.Field('Event', graphql_name='commentEvent')
    '''The incident comment event.'''



class CreateOrUpdateLineageEdge(sgqlc.types.Type):
    '''Create or update a lineage edge'''
    __schema__ = schema
    __field_names__ = ('edge',)
    edge = sgqlc.types.Field('LineageGraphEdge', graphql_name='edge')



class CreateOrUpdateLineageNode(sgqlc.types.Type):
    '''Create or update a lineage node'''
    __schema__ = schema
    __field_names__ = ('node',)
    node = sgqlc.types.Field('LineageGraphNode', graphql_name='node')



class CreateOrUpdateLineageNodeBlockPattern(sgqlc.types.Type):
    '''Create or update a node block pattern'''
    __schema__ = schema
    __field_names__ = ('pattern',)
    pattern = sgqlc.types.Field('LineageNodeBlockPattern', graphql_name='pattern')



class CreateOrUpdateLineageNodeCollapsingRule(sgqlc.types.Type):
    '''Create or update a node collapsing rule'''
    __schema__ = schema
    __field_names__ = ('rule',)
    rule = sgqlc.types.Field('LineageNodeCollapsingRule', graphql_name='rule')
    '''Collapsing rule that was created or updated'''



class CreateOrUpdateLineageNodeReplacementRule(sgqlc.types.Type):
    '''Create or update a node replacement rule'''
    __schema__ = schema
    __field_names__ = ('rule',)
    rule = sgqlc.types.Field('LineageNodeReplacementRule', graphql_name='rule')
    '''Replacement rule that was created or updated'''



class CreateOrUpdateMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('monitor',)
    monitor = sgqlc.types.Field('MetricMonitoring', graphql_name='monitor')



class CreateOrUpdateMonitorLabel(sgqlc.types.Type):
    '''Create or update a monitor label'''
    __schema__ = schema
    __field_names__ = ('monitor_label',)
    monitor_label = sgqlc.types.Field('MonitorLabelObject', graphql_name='monitorLabel')
    '''The created monitor label'''



class CreateOrUpdateMonteCarloConfigTemplate(sgqlc.types.Type):
    '''Create or update a Monte Carlo Config Template'''
    __schema__ = schema
    __field_names__ = ('response',)
    response = sgqlc.types.Field('MonteCarloConfigTemplateUpdateResponse', graphql_name='response')
    '''Response'''



class CreateOrUpdateMonteCarloConfigTemplateAsync(sgqlc.types.Type):
    '''Create or update a Monte Carlo Config Template asynchronously'''
    __schema__ = schema
    __field_names__ = ('response',)
    response = sgqlc.types.Field('MonteCarloConfigTemplateUpdateAsyncResponse', graphql_name='response')
    '''Response'''



class CreateOrUpdateNotificationSetting(sgqlc.types.Type):
    '''Create or update a notification setting'''
    __schema__ = schema
    __field_names__ = ('notification_setting',)
    notification_setting = sgqlc.types.Field(AccountNotificationSetting, graphql_name='notificationSetting')
    '''Setting that was created or updated'''



class CreateOrUpdateObjectProperty(sgqlc.types.Type):
    '''Create or update properties (tags) for objects (e.g. tables,
    fields, etc.)
    '''
    __schema__ = schema
    __field_names__ = ('object_property',)
    object_property = sgqlc.types.Field('ObjectProperty', graphql_name='objectProperty')
    '''Property created or updated'''



class CreateOrUpdateQueryPerfRule(sgqlc.types.Type):
    '''Create or update query performance rule/monitor.
    There must be exactly (3) comparisons, which follow this format:
    {                 "comparisonType": "QUERY_PERFORMANCE",
    "operator": "GT",                 "metric": "runtime",
    "threshold": <THRESHOLD IN SECONDS>,             },             {
    "comparisonType": "QUERY_PERFORMANCE",                 "operator":
    "GT",                 "metric": "runtime_change",
    "threshold": <THRESHOLD AS PERCENTAGE>,
    "baselineAggFunction": <MEDIAN|AVG>,
    "thresholdLookbackDataPoints": <NUMBER OF DATA POINTS TO INCLUDE
    IN LOOKBACK RANGE>,             },             {
    "comparisonType": "QUERY_PERFORMANCE",                 "operator":
    "GT",                 "metric": "consecutive_breach_count",
    "threshold": <NUMBER OF CONSECUTIVE BREACHES TO TRIGGER AN ALERT>,
    }
    '''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateOrUpdateRecipientName(sgqlc.types.Type):
    '''Create or update a recipient's custom name'''
    __schema__ = schema
    __field_names__ = ('recipient', 'name')
    recipient = sgqlc.types.Field(String, graphql_name='recipient')

    name = sgqlc.types.Field(String, graphql_name='name')



class CreateOrUpdateResource(sgqlc.types.Type):
    '''Create or update a resource'''
    __schema__ = schema
    __field_names__ = ('resource',)
    resource = sgqlc.types.Field('Resource', graphql_name='resource')



class CreateOrUpdateSamlIdentityProvider(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('account',)
    account = sgqlc.types.Field(Account, graphql_name='account')



class CreateOrUpdateServiceApiToken(sgqlc.types.Type):
    '''Generate a service API Access Token'''
    __schema__ = schema
    __field_names__ = ('access_token',)
    access_token = sgqlc.types.Field(AccessToken, graphql_name='accessToken')



class CreateOrUpdateUserSettings(sgqlc.types.Type):
    '''Create a new user-specific setting'''
    __schema__ = schema
    __field_names__ = ('user_settings',)
    user_settings = sgqlc.types.Field('UserSettings', graphql_name='userSettings')
    '''Response'''



class CreateOrUpdateVolumeRule(sgqlc.types.Type):
    '''Create or update a Volume Rule'''
    __schema__ = schema
    __field_names__ = ('custom_rule',)
    custom_rule = sgqlc.types.Field('CustomRule', graphql_name='customRule')



class CreateServiceNowIntegration(sgqlc.types.Type):
    '''Create a ServiceNow integration'''
    __schema__ = schema
    __field_names__ = ('servicenow_integration',)
    servicenow_integration = sgqlc.types.Field('ServiceNowIntegrationOutput', graphql_name='servicenowIntegration')
    '''The integration that was created'''



class CreateSharedQuery(sgqlc.types.Type):
    '''Create a new shared API Explorer GraphQL query or mutation'''
    __schema__ = schema
    __field_names__ = ('link',)
    link = sgqlc.types.Field(String, graphql_name='link')
    '''Link to newly shared query'''



class CreateTableauAssetWarning(sgqlc.types.Type):
    '''Creates a warning on an asset.'''
    __schema__ = schema
    __field_names__ = ('tableau_warning_id',)
    tableau_warning_id = sgqlc.types.Field(String, graphql_name='tableauWarningId')
    '''ID of the created warning in Tableau ID space.'''



class CreateUnifiedUserAssignment(sgqlc.types.Type):
    '''Associate a UnifiedUser with a CatalogObject'''
    __schema__ = schema
    __field_names__ = ('unified_user_assignment',)
    unified_user_assignment = sgqlc.types.Field('UnifiedUserAssignment', graphql_name='unifiedUserAssignment')



class CreateWebexIntegration(sgqlc.types.Type):
    '''Create a Webex integration'''
    __schema__ = schema
    __field_names__ = ('webex_integration',)
    webex_integration = sgqlc.types.Field('WebexIntegrationOutput', graphql_name='webexIntegration')
    '''The integration that was created'''



class CustomRuleComparison(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('comparison_type', 'full_table_id', 'full_table_ids', 'field', 'metric', 'operator', 'threshold', 'baseline_agg_function', 'baseline_interval_minutes', 'is_threshold_relative', 'is_freshness_from_metadata', 'threshold_lookback_minutes', 'threshold_ref', 'min_buffer', 'max_buffer', 'number_of_agg_periods', 'data_collection_interval_minutes', 'rule_interval_minutes', 'threshold_lookback_data_points', 'source_metric', 'target_metric')
    comparison_type = sgqlc.types.Field(sgqlc.types.non_null(ComparisonType), graphql_name='comparisonType')
    '''Type of comparison'''

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')

    full_table_ids = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='fullTableIds')

    field = sgqlc.types.Field(String, graphql_name='field')

    metric = sgqlc.types.Field(String, graphql_name='metric')

    operator = sgqlc.types.Field(sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name='operator')
    '''Comparison operator'''

    threshold = sgqlc.types.Field(Float, graphql_name='threshold')
    '''Threshold value'''

    baseline_agg_function = sgqlc.types.Field(AggregationFunction, graphql_name='baselineAggFunction')
    '''Function used to aggregate historical data points to calculate
    baseline
    '''

    baseline_interval_minutes = sgqlc.types.Field(Int, graphql_name='baselineIntervalMinutes')
    '''Time interval to aggregate over to calculate baseline.'''

    is_threshold_relative = sgqlc.types.Field(Boolean, graphql_name='isThresholdRelative')
    '''True, if threshold is a relative percentage change of baseline.
    False, if threshold is absolute change
    '''

    is_freshness_from_metadata = sgqlc.types.Field(Boolean, graphql_name='isFreshnessFromMetadata')
    '''True if freshness is calculated from metadata.'''

    threshold_lookback_minutes = sgqlc.types.Field(Int, graphql_name='thresholdLookbackMinutes')
    '''Time to look back for rules which compare current and past values.'''

    threshold_ref = sgqlc.types.Field(String, graphql_name='thresholdRef')
    '''Key used to retrieve the threshold values from external source'''

    min_buffer = sgqlc.types.Field('ThresholdModifier', graphql_name='minBuffer')
    '''The lower bound buffer to modify the alert threshold'''

    max_buffer = sgqlc.types.Field('ThresholdModifier', graphql_name='maxBuffer')
    '''The upper bound buffer to modify the alert threshold'''

    number_of_agg_periods = sgqlc.types.Field(Int, graphql_name='numberOfAggPeriods')
    '''The number of periods to use in the aggregate comparison for
    Volume Growth comparisons.
    '''

    data_collection_interval_minutes = sgqlc.types.Field(Int, graphql_name='dataCollectionIntervalMinutes')
    '''Time interval of data collection for the rule.'''

    rule_interval_minutes = sgqlc.types.Field(Int, graphql_name='ruleIntervalMinutes')
    '''Time interval for the rule evaluation.'''

    threshold_lookback_data_points = sgqlc.types.Field(Int, graphql_name='thresholdLookbackDataPoints')
    '''Number of data points to look back for rules which compare current
    and past values.
    '''

    source_metric = sgqlc.types.Field(String, graphql_name='sourceMetric')
    '''Name of source metric'''

    target_metric = sgqlc.types.Field(String, graphql_name='targetMetric')
    '''Name of target metric'''



class CustomRuleConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('CustomRuleEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class CustomRuleDatapoint(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('value', 'measurement_timestamp', 'thresholds')
    value = sgqlc.types.Field(Float, graphql_name='value')
    '''Value of the datapoint'''

    measurement_timestamp = sgqlc.types.Field(DateTime, graphql_name='measurementTimestamp')
    '''Measurement timestamp of the datapoint'''

    thresholds = sgqlc.types.Field(sgqlc.types.list_of('Threshold'), graphql_name='thresholds')
    '''Thresholds for the datapoint'''



class CustomRuleEdge(sgqlc.types.Type):
    '''A Relay edge containing a `CustomRule` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('CustomRule', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class CustomRuleExecutionAnalytics(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('date', 'runs', 'passes', 'breaches')
    date = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='date')
    '''Date for the analytics, if grouped by week/month it has the start
    of each grouping period
    '''

    runs = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='runs')
    '''Number of runs'''

    passes = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='passes')
    '''Number of passes'''

    breaches = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='breaches')
    '''Number of breaches'''



class CustomRuleQueryConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('CustomRuleQueryEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class CustomRuleQueryEdge(sgqlc.types.Type):
    '''A Relay edge containing a `CustomRuleQuery` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('CustomRuleQuery', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class CustomSQLOutputDownload(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('sampling_disabled', 'download_url')
    sampling_disabled = sgqlc.types.Field(Boolean, graphql_name='samplingDisabled')

    download_url = sgqlc.types.Field(String, graphql_name='downloadUrl')
    '''Link to download the query response which expires in 5 minutes.'''



class CustomSQLOutputSample(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('columns', 'rows', 'sampling_disabled')
    columns = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='columns')

    rows = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.list_of(String)), graphql_name='rows')

    sampling_disabled = sgqlc.types.Field(Boolean, graphql_name='samplingDisabled')



class CustomSQLTemplateConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges', 'total_count', 'edge_count')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('CustomSQLTemplateEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''

    total_count = sgqlc.types.Field(Int, graphql_name='totalCount')

    edge_count = sgqlc.types.Field(Int, graphql_name='edgeCount')



class CustomSQLTemplateEdge(sgqlc.types.Type):
    '''A Relay edge containing a `CustomSQLTemplate` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('CustomSQLTemplate', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class CustomUserConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('CustomUserEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class CustomUserEdge(sgqlc.types.Type):
    '''A Relay edge containing a `CustomUser` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('CustomUser', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DataAssetDashboard(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('data_sources_count', 'project_count', 'schema_count', 'table_count', 'view_count', 'external_table_count', 'wildcard_table_count')
    data_sources_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='dataSourcesCount')
    '''The number of data sources monitored'''

    project_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='projectCount')
    '''The number of projects monitored'''

    schema_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='schemaCount')
    '''The number of schemas monitored'''

    table_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='tableCount')
    '''The number of tables monitored'''

    view_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='viewCount')
    '''The number of views monitored'''

    external_table_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='externalTableCount')
    '''The number of external tables monitored'''

    wildcard_table_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='wildcardTableCount')
    '''The number of wildcard tables monitored'''



class DataCollector(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'account', 'uuid', 'api_gateway_id', 'kinesis_endpoint_id', 'cloudwatch_log_endpoint_id', 'cross_account_role_arn', 'stack_arn', 'customer_aws_account_id', 'customer_aws_region', 'template_launch_url', 'template_provider', 'template_variant', 'template_version', 'template_parameters', 'code_version', 'kinesis_access_role', 'active', 'last_updated', 'is_custom', 'oauth_credentials_s3_key', 'release_channel', 'warehouses', 'bi_container', 'etl_container', 'agents', 'supports_data_store_agents', 'supports_remote_agents')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    account = sgqlc.types.Field(sgqlc.types.non_null(Account), graphql_name='account')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')

    api_gateway_id = sgqlc.types.Field(String, graphql_name='apiGatewayId')

    kinesis_endpoint_id = sgqlc.types.Field(String, graphql_name='kinesisEndpointId')

    cloudwatch_log_endpoint_id = sgqlc.types.Field(String, graphql_name='cloudwatchLogEndpointId')

    cross_account_role_arn = sgqlc.types.Field(String, graphql_name='crossAccountRoleArn')

    stack_arn = sgqlc.types.Field(String, graphql_name='stackArn')

    customer_aws_account_id = sgqlc.types.Field(String, graphql_name='customerAwsAccountId')

    customer_aws_region = sgqlc.types.Field(String, graphql_name='customerAwsRegion')

    template_launch_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='templateLaunchUrl')

    template_provider = sgqlc.types.Field(String, graphql_name='templateProvider')

    template_variant = sgqlc.types.Field(String, graphql_name='templateVariant')

    template_version = sgqlc.types.Field(String, graphql_name='templateVersion')

    template_parameters = sgqlc.types.Field(JSONString, graphql_name='templateParameters')

    code_version = sgqlc.types.Field(String, graphql_name='codeVersion')

    kinesis_access_role = sgqlc.types.Field(String, graphql_name='kinesisAccessRole')

    active = sgqlc.types.Field(Boolean, graphql_name='active')

    last_updated = sgqlc.types.Field(DateTime, graphql_name='lastUpdated')

    is_custom = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isCustom')

    oauth_credentials_s3_key = sgqlc.types.Field(String, graphql_name='oauthCredentialsS3Key')

    release_channel = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='releaseChannel')

    warehouses = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('Warehouse'))), graphql_name='warehouses')

    bi_container = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(BiContainer))), graphql_name='biContainer')

    etl_container = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null('EtlContainer'))), graphql_name='etlContainer')

    agents = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Agent))), graphql_name='agents')
    '''Data Collector the Agent is registered to.'''

    supports_data_store_agents = sgqlc.types.Field(Boolean, graphql_name='supportsDataStoreAgents')
    '''Indicates whether the data collector's version supports data store
    agents
    '''

    supports_remote_agents = sgqlc.types.Field(Boolean, graphql_name='supportsRemoteAgents')
    '''Indicates whether the data collector's version supports remote
    agents
    '''



class DataCollectorSchedule(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'uuid', 'dc_id', 'resource_id', 'connection_id', 'project_id', 'output_stream', 'output_s3_bucket', 'last_job_id', 'job_type', 'schedule_type', 'created_on', 'last_run', 'interval_in_seconds', 'override', 'skip', 'is_deleted', 'friendly_name', 'notes', 'limits', 'interval_crontab', 'start_time', 'prev_execution_time', 'next_execution_time', 'timezone', 'is_dynamic_schedule_poller', 'min_interval_seconds', 'delete_reason', 'skip_reason', 'queued_at', 'metric_monitors')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')

    dc_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dcId')

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceId')

    connection_id = sgqlc.types.Field(UUID, graphql_name='connectionId')

    project_id = sgqlc.types.Field(String, graphql_name='projectId')

    output_stream = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='outputStream')

    output_s3_bucket = sgqlc.types.Field(String, graphql_name='outputS3Bucket')

    last_job_id = sgqlc.types.Field(String, graphql_name='lastJobId')

    job_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='jobType')

    schedule_type = sgqlc.types.Field(sgqlc.types.non_null(DataCollectorScheduleModelScheduleType), graphql_name='scheduleType')

    created_on = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdOn')

    last_run = sgqlc.types.Field(DateTime, graphql_name='lastRun')

    interval_in_seconds = sgqlc.types.Field(Int, graphql_name='intervalInSeconds')

    override = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='override')

    skip = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='skip')

    is_deleted = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isDeleted')

    friendly_name = sgqlc.types.Field(String, graphql_name='friendlyName')

    notes = sgqlc.types.Field(String, graphql_name='notes')

    limits = sgqlc.types.Field(JSONString, graphql_name='limits')

    interval_crontab = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='intervalCrontab')

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')

    prev_execution_time = sgqlc.types.Field(DateTime, graphql_name='prevExecutionTime')

    next_execution_time = sgqlc.types.Field(DateTime, graphql_name='nextExecutionTime')

    timezone = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='timezone')

    is_dynamic_schedule_poller = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isDynamicSchedulePoller')
    '''If true, this schedule is for used to poll forfreshness to trigger
    dynamically scheduled jobs
    '''

    min_interval_seconds = sgqlc.types.Field(Int, graphql_name='minIntervalSeconds')
    '''Minimum interval between job executions. Used to preventa dynamic
    scheduled job from executing too frequently
    '''

    delete_reason = sgqlc.types.Field(DataCollectorScheduleModelDeleteReason, graphql_name='deleteReason')

    skip_reason = sgqlc.types.Field(DataCollectorScheduleModelSkipReason, graphql_name='skipReason')
    '''This field will be set when the schedule is set to skip=true froma
    manual action or when the connection is disabled.
    '''

    queued_at = sgqlc.types.Field(DateTime, graphql_name='queuedAt')
    '''The last time this schedule was added to the execution queue'''

    metric_monitors = sgqlc.types.Field(sgqlc.types.non_null('MetricMonitoringConnection'), graphql_name='metricMonitors', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('type', sgqlc.types.Arg(String, graphql_name='type', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `type` (`String`)None
    '''



class DataExplorerComparisonDashboardTypeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DataExplorerComparisonDashboardTypeEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DataExplorerComparisonDashboardTypeEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DataExplorerComparisonDashboardType`
    and its cursor.
    '''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DataExplorerComparisonDashboardType', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DataExplorerDashboardTypeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DataExplorerDashboardTypeEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DataExplorerDashboardTypeEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DataExplorerDashboardType` and its
    cursor.
    '''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DataExplorerDashboardType', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DataExplorerWidgetTypeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DataExplorerWidgetTypeEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DataExplorerWidgetTypeEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DataExplorerWidgetType` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DataExplorerWidgetType', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DataMaintenanceEntry(sgqlc.types.Type):
    '''Data maintenance entry'''
    __schema__ = schema
    __field_names__ = ('created_time', 'updated_time', 'id', 'account_uuid', 'resource_uuid', 'database', 'dataset', 'full_table_id', 'maintenance_type', 'start_time', 'end_time', 'reason')
    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdTime')

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='updatedTime')

    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='accountUuid')

    resource_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceUuid')

    database = sgqlc.types.Field(String, graphql_name='database')

    dataset = sgqlc.types.Field(String, graphql_name='dataset')

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')

    maintenance_type = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='maintenanceType')

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')

    end_time = sgqlc.types.Field(DateTime, graphql_name='endTime')

    reason = sgqlc.types.Field(String, graphql_name='reason')



class DataPoint(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('timestamp', 'value')
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='timestamp')

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='value')



class DataProductAssetConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DataProductAssetEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DataProductAssetEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DataProductAsset` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DataProductAsset', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DataProductConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DataProductEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DataProductEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DataProduct` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DataProduct', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DataProductMetricData(sgqlc.types.Type):
    '''Data product metric with calculated data points'''
    __schema__ = schema
    __field_names__ = ('metric', 'data_points', 'fill_missing_data_points_with', 'overall_value')
    metric = sgqlc.types.Field(sgqlc.types.non_null(DataProductMetric), graphql_name='metric')
    '''Metric identifier'''

    data_points = sgqlc.types.Field(sgqlc.types.list_of('DataProductMetricDataPoint'), graphql_name='dataPoints')
    '''Data points for the metric'''

    fill_missing_data_points_with = sgqlc.types.Field(Float, graphql_name='fillMissingDataPointsWith')
    '''Value to use for missing data points. This is used to tell the FE
    which is the value to use when there is no data for a specific
    date or time.
    '''

    overall_value = sgqlc.types.Field(Float, graphql_name='overallValue')
    '''Overall value for the metric that is not grouped into data points'''



class DataProductMetricDataPoint(sgqlc.types.Type):
    '''Data point for a data product metric'''
    __schema__ = schema
    __field_names__ = ('label', 'value')
    label = sgqlc.types.Field(String, graphql_name='label')
    '''Label associated to the value'''

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='value')
    '''Value for the data point'''



class DataProfileField(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name', 'type', 'min', 'max', 'p25', 'p50', 'p75', 'dist')
    name = sgqlc.types.Field(String, graphql_name='name')

    type = sgqlc.types.Field(String, graphql_name='type')

    min = sgqlc.types.Field(Float, graphql_name='min')

    max = sgqlc.types.Field(Float, graphql_name='max')

    p25 = sgqlc.types.Field(Float, graphql_name='p25')

    p50 = sgqlc.types.Field(Float, graphql_name='p50')

    p75 = sgqlc.types.Field(Float, graphql_name='p75')

    dist = sgqlc.types.Field(JSONString, graphql_name='dist')



class DataProfileResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('sample_size', 'fields')
    sample_size = sgqlc.types.Field(Int, graphql_name='sampleSize')

    fields = sgqlc.types.Field(sgqlc.types.list_of(DataProfileField), graphql_name='fields')



class DataQualityWarningsRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name', 'author', 'is_severe', 'is_active', 'warning_type', 'message', 'created_at', 'updated_at')
    name = sgqlc.types.Field(String, graphql_name='name')

    author = sgqlc.types.Field(AuthorRef, graphql_name='author')

    is_severe = sgqlc.types.Field(String, graphql_name='isSevere')

    is_active = sgqlc.types.Field(String, graphql_name='isActive')

    warning_type = sgqlc.types.Field(String, graphql_name='warningType')

    message = sgqlc.types.Field(String, graphql_name='message')

    created_at = sgqlc.types.Field(String, graphql_name='createdAt')

    updated_at = sgqlc.types.Field(String, graphql_name='updatedAt')



class DataResponseType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('data_frame', 'sql_query', 'presigned_url')
    data_frame = sgqlc.types.Field(JSONString, graphql_name='dataFrame')

    sql_query = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='sqlQuery')
    '''Raw SQL query that produced this data'''

    presigned_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='presignedUrl')
    '''Presigned URL containing data output'''



class DatabricksClusterResponse(sgqlc.types.Type):
    '''Databricks cluster details.'''
    __schema__ = schema
    __field_names__ = ('cluster_id', 'state')
    cluster_id = sgqlc.types.Field(String, graphql_name='clusterId')
    '''ID of the cluster.'''

    state = sgqlc.types.Field(String, graphql_name='state')
    '''State of the cluster.'''



class DatabricksJobResponse(sgqlc.types.Type):
    '''Databricks job details.'''
    __schema__ = schema
    __field_names__ = ('workspace_job_id', 'workspace_job_name', 'workspace_notebook_path', 'notebook_source', 'notebook_version')
    workspace_job_id = sgqlc.types.Field(String, graphql_name='workspaceJobId')
    '''Generated Databricks job ID.'''

    workspace_job_name = sgqlc.types.Field(String, graphql_name='workspaceJobName')
    '''Generated Databricks job name.'''

    workspace_notebook_path = sgqlc.types.Field(String, graphql_name='workspaceNotebookPath')
    '''Uploaded Databricks notebook path.'''

    notebook_source = sgqlc.types.Field(String, graphql_name='notebookSource')
    '''Source location used to create the notebook.'''

    notebook_version = sgqlc.types.Field(String, graphql_name='notebookVersion')
    '''Version of the notebook created'''



class DatabricksNotebookLink(sgqlc.types.Type):
    '''Databricks notebook link details.'''
    __schema__ = schema
    __field_names__ = ('presigned_url', 'notebook_source')
    presigned_url = sgqlc.types.Field(String, graphql_name='presignedUrl')
    '''Temporary link containing the notebook.'''

    notebook_source = sgqlc.types.Field(String, graphql_name='notebookSource')
    '''Source location used to create the notebook link.'''



class DatabricksSqlWarehouseConnectionMigration(sgqlc.types.Type):
    '''Migrate an existing databricks connection to use a sql warehouse'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DatabricksWarehouseResponse(sgqlc.types.Type):
    '''Databricks warehouse details.'''
    __schema__ = schema
    __field_names__ = ('warehouse_id', 'state')
    warehouse_id = sgqlc.types.Field(String, graphql_name='warehouseId')
    '''ID of the warehouse.'''

    state = sgqlc.types.Field(String, graphql_name='state')
    '''State of the warehouse.'''



class DatasetConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DatasetEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DatasetEdge(sgqlc.types.Type):
    '''A Relay edge containing a `Dataset` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('Dataset', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DatasetEntity(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('dataset_id',)
    dataset_id = sgqlc.types.Field(String, graphql_name='datasetId')
    '''Dataset ID'''



class DbtConnectionDetails(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('dbt_cloud_account_id', 'dbt_cloud_webhook_id', 'dbt_cloud_base_url')
    dbt_cloud_account_id = sgqlc.types.Field(String, graphql_name='dbtCloudAccountId')

    dbt_cloud_webhook_id = sgqlc.types.Field(String, graphql_name='dbtCloudWebhookId')

    dbt_cloud_base_url = sgqlc.types.Field(String, graphql_name='dbtCloudBaseUrl')



class DbtEdgeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtEdgeEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DbtEdgeEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtEdge` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtEdge', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtJobConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtJobEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DbtJobEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtJob` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtJob', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtJobExecutionConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtJobExecutionEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DbtJobExecutionEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtJobExecution` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtJobExecution', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtJobExecutionsConnection(sgqlc.types.relay.Connection):
    '''dbt job executions response'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges', 'edge_count', 'total_count')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtJobExecutionsEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''

    edge_count = sgqlc.types.Field(Int, graphql_name='edgeCount')
    '''Total number of edges returned (page count)'''

    total_count = sgqlc.types.Field(Int, graphql_name='totalCount')
    '''Total number of edges matching filter (total count)'''



class DbtJobExecutionsEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtJobExecutions` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtJobExecution', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtJobInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('integration_type', 'job_name', 'mc_dbt_job_mcon', 'mc_dbt_job_execution_id', 'mc_dbt_run_id', 'dbt_cloud_job_id', 'dbt_cloud_run_id', 'dbt_node_id', 'dbt_node_name', 'invocation_id')
    integration_type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='integrationType')
    '''Type of Integration'''

    job_name = sgqlc.types.Field(String, graphql_name='jobName')
    '''Name of Job'''

    mc_dbt_job_mcon = sgqlc.types.Field(String, graphql_name='mcDbtJobMcon')
    '''MC dbt Job mcon'''

    mc_dbt_job_execution_id = sgqlc.types.Field(UUID, graphql_name='mcDbtJobExecutionId')
    '''MC dbt Job Execution ID (uuid)'''

    mc_dbt_run_id = sgqlc.types.Field(UUID, graphql_name='mcDbtRunId')
    '''MC dbt Run ID (uuid)'''

    dbt_cloud_job_id = sgqlc.types.Field(String, graphql_name='dbtCloudJobId')
    '''dbt Cloud Job ID'''

    dbt_cloud_run_id = sgqlc.types.Field(String, graphql_name='dbtCloudRunId')
    '''dbt Cloud Run ID'''

    dbt_node_id = sgqlc.types.Field(String, graphql_name='dbtNodeId')
    '''dbt node ID'''

    dbt_node_name = sgqlc.types.Field(String, graphql_name='dbtNodeName')
    '''dbt node name'''

    invocation_id = sgqlc.types.Field(String, graphql_name='invocationId')
    '''dbt Invocation ID'''



class DbtModelResult(sgqlc.types.Type):
    '''dbt model result'''
    __schema__ = schema
    __field_names__ = ('node_id', 'node_name', 'schema', 'database')
    node_id = sgqlc.types.Field(String, graphql_name='nodeId')
    '''dbt node id'''

    node_name = sgqlc.types.Field(String, graphql_name='nodeName')
    '''dbt node name'''

    schema = sgqlc.types.Field(String, graphql_name='schema')
    '''dbt schema name'''

    database = sgqlc.types.Field(String, graphql_name='database')
    '''dbt database name'''



class DbtModelResultsConnection(sgqlc.types.relay.Connection):
    '''dbt model results response'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges', 'edge_count', 'total_count')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtModelResultsEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''

    edge_count = sgqlc.types.Field(Int, graphql_name='edgeCount')
    '''Total number of edges returned (page count)'''

    total_count = sgqlc.types.Field(Int, graphql_name='totalCount')
    '''Total number of edges matching filter (total count)'''



class DbtModelResultsEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtModelResults` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtRunResult', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtModelsConnection(sgqlc.types.relay.Connection):
    '''dbt models response'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges', 'edge_count', 'total_count')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtModelsEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''

    edge_count = sgqlc.types.Field(Int, graphql_name='edgeCount')
    '''Total number of edges returned (page count)'''

    total_count = sgqlc.types.Field(Int, graphql_name='totalCount')
    '''Total number of edges matching filter (total count)'''



class DbtModelsEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtModels` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field(DbtModelResult, graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtNodeConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtNodeEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DbtNodeEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtNode` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtNode', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtProjectConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtProjectEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DbtProjectEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtProject` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtProject', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtRunConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtRunEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DbtRunEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtRun` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtRun', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtRunResult(sgqlc.types.Type):
    '''dbt run result'''
    __schema__ = schema
    __field_names__ = ('node_id', 'node_name', 'run_started_at', 'started_at', 'execution_time', 'status', 'run_uuid', 'mcon', 'job_name', 'command')
    node_id = sgqlc.types.Field(String, graphql_name='nodeId')
    '''dbt node id'''

    node_name = sgqlc.types.Field(String, graphql_name='nodeName')
    '''dbt node name'''

    run_started_at = sgqlc.types.Field(DateTime, graphql_name='runStartedAt')
    '''Time dbt run started'''

    started_at = sgqlc.types.Field(DateTime, graphql_name='startedAt')
    '''Time dbt node execution started'''

    execution_time = sgqlc.types.Field(Float, graphql_name='executionTime')
    '''Total dbt node execution time (in seconds)'''

    status = sgqlc.types.Field(String, graphql_name='status')
    '''Execution status'''

    run_uuid = sgqlc.types.Field(UUID, graphql_name='runUuid')
    '''Internal id of dbt run'''

    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''MCON of associated table'''

    job_name = sgqlc.types.Field(String, graphql_name='jobName')
    '''Dbt job name'''

    command = sgqlc.types.Field(String, graphql_name='command')
    '''dbt command executed'''



class DbtRunStepConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtRunStepEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DbtRunStepEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtRunStep` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtRunStep', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtTestResultsConnection(sgqlc.types.relay.Connection):
    '''dbt test results response'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges', 'edge_count', 'total_count')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DbtTestResultsEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''

    edge_count = sgqlc.types.Field(Int, graphql_name='edgeCount')
    '''Total number of edges returned (page count)'''

    total_count = sgqlc.types.Field(Int, graphql_name='totalCount')
    '''Total number of edges matching filter (total count)'''



class DbtTestResultsEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DbtTestResults` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DbtTestRunResult', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DbtTestRunResult(sgqlc.types.Type):
    '''dbt test run result'''
    __schema__ = schema
    __field_names__ = ('node_id', 'node_name', 'run_started_at', 'started_at', 'execution_time', 'status', 'run_uuid', 'mcon', 'job_name', 'command', 'model_id', 'model_name')
    node_id = sgqlc.types.Field(String, graphql_name='nodeId')
    '''dbt node id'''

    node_name = sgqlc.types.Field(String, graphql_name='nodeName')
    '''dbt node name'''

    run_started_at = sgqlc.types.Field(DateTime, graphql_name='runStartedAt')
    '''Time dbt run started'''

    started_at = sgqlc.types.Field(DateTime, graphql_name='startedAt')
    '''Time dbt node execution started'''

    execution_time = sgqlc.types.Field(Float, graphql_name='executionTime')
    '''Total dbt node execution time (in seconds)'''

    status = sgqlc.types.Field(String, graphql_name='status')
    '''Execution status'''

    run_uuid = sgqlc.types.Field(UUID, graphql_name='runUuid')
    '''Internal id of dbt run'''

    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''MCON of associated table'''

    job_name = sgqlc.types.Field(String, graphql_name='jobName')
    '''Dbt job name'''

    command = sgqlc.types.Field(String, graphql_name='command')
    '''dbt command executed'''

    model_id = sgqlc.types.Field(String, graphql_name='modelId')
    '''Id of associated dbt model'''

    model_name = sgqlc.types.Field(String, graphql_name='modelName')
    '''Name of associated dbt model'''



class DcPingResponse(sgqlc.types.Type):
    '''Describes the result of pinging a data collector.'''
    __schema__ = schema
    __field_names__ = ('dc_id', 'trace_id')
    dc_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='dcId')
    '''The UUID identifying the data collector pinged.'''

    trace_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='traceId')
    '''A unique identifier for correlating the data collector ping.'''



class DeauthorizeSlackAppMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteAccessToken(sgqlc.types.Type):
    '''Delete an API Access Token by ID'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''If the token was successfully deleted'''



class DeleteAccountSecret(sgqlc.types.Type):
    '''Delete an account secret'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Boolean, graphql_name='deleted')



class DeleteAgent(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteAlationIntegration(sgqlc.types.Type):
    '''Delete Alation integration'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Boolean, graphql_name='deleted')



class DeleteAudienceNotificationSetting(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Int, graphql_name='deleted')



class DeleteAudienceRoutingRule(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Int, graphql_name='deleted')



class DeleteAuthorizationGroup(sgqlc.types.Type):
    '''Delete an authorization group'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Int, graphql_name='deleted')
    '''Number of groups deleted.'''



class DeleteCatalogObjectMetadata(sgqlc.types.Type):
    '''Delete metadata for an asset'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteCustomRule(sgqlc.types.Type):
    '''Delete a custom rule'''
    __schema__ = schema
    __field_names__ = ('uuid',)
    uuid = sgqlc.types.Field(UUID, graphql_name='uuid')



class DeleteCustomSQLTemplate(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteDataExplorerComparisonDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='success')



class DeleteDataExplorerDashboardMutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteDataMaintenanceEntry(sgqlc.types.Type):
    '''Delete a data maintenance window'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteDataProduct(sgqlc.types.Type):
    '''Delete a data product'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''Status of the deletion operation.'''



class DeleteDomain(sgqlc.types.Type):
    '''Delete a domain'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Int, graphql_name='deleted')
    '''Number of domains deleted'''



class DeleteEventOnboardingData(sgqlc.types.Type):
    '''Delete stored event onboarding configuration'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''Indicates whether the event onboarding data was deleted
    successfully
    '''



class DeleteGithubInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Boolean, graphql_name='deleted')
    '''True if deleting the installation was successful'''



class DeleteIncidentComment(sgqlc.types.Type):
    '''Deletes an incident's comment'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteIntegrationKey(sgqlc.types.Type):
    '''Delete an integration key'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Boolean, graphql_name='deleted')
    '''True if the key was deleted, false otherwise'''



class DeleteJiraIntegration(sgqlc.types.Type):
    '''Delete a Jira integration'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Boolean, graphql_name='deleted')



class DeleteLineageNode(sgqlc.types.Type):
    '''Delete a lineage node and any lineage edges connected to it.'''
    __schema__ = schema
    __field_names__ = ('objects_deleted', 'nodes_deleted', 'edges_deleted')
    objects_deleted = sgqlc.types.Field(Int, graphql_name='objectsDeleted')
    '''Total number of objects (nodes + edges) deleted'''

    nodes_deleted = sgqlc.types.Field(Int, graphql_name='nodesDeleted')
    '''Total number of nodes deleted'''

    edges_deleted = sgqlc.types.Field(Int, graphql_name='edgesDeleted')
    '''Total number of edges deleted'''



class DeleteLineageNodeBlockPattern(sgqlc.types.Type):
    '''Delete a lineage node block pattern.'''
    __schema__ = schema
    __field_names__ = ('pattern',)
    pattern = sgqlc.types.Field('LineageNodeBlockPattern', graphql_name='pattern')



class DeleteLineageNodeCollapsingRule(sgqlc.types.Type):
    '''Delete a lineage node collapsing rule'''
    __schema__ = schema
    __field_names__ = ('rule',)
    rule = sgqlc.types.Field('LineageNodeCollapsingRule', graphql_name='rule')



class DeleteLineageNodeReplacementRule(sgqlc.types.Type):
    '''Delete a lineage node replacement rule'''
    __schema__ = schema
    __field_names__ = ('rule',)
    rule = sgqlc.types.Field('LineageNodeReplacementRule', graphql_name='rule')



class DeleteMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteMonitorLabel(sgqlc.types.Type):
    '''Delete a monitor label'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Boolean, graphql_name='deleted')
    '''True if the monitor label was deleted'''



class DeleteMonteCarloConfigTemplate(sgqlc.types.Type):
    '''Delete a Monte Carlo Config Template'''
    __schema__ = schema
    __field_names__ = ('response',)
    response = sgqlc.types.Field('MonteCarloConfigTemplateDeleteResponse', graphql_name='response')
    '''Response'''



class DeleteNotificationSetting(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Int, graphql_name='deleted')



class DeleteObjectProperty(sgqlc.types.Type):
    '''Delete properties (tags) for objects (e.g. tables, fields, etc.)'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteRecipientName(sgqlc.types.Type):
    '''Create or update a recipient's custom name'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteSamlIdentityProvider(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('account',)
    account = sgqlc.types.Field(Account, graphql_name='account')



class DeleteServiceNowIntegration(sgqlc.types.Type):
    '''Delete a ServiceNow integration'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Boolean, graphql_name='deleted')



class DeleteStreamingClusterMutation(sgqlc.types.Type):
    '''Delete a streaming clusters, and connections on this cluster.'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteStreamingSystemMutation(sgqlc.types.Type):
    '''Delete a streaming system. This will delete all clusters within
    the streaming system as well.
    '''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteUnifiedUserAssignment(sgqlc.types.Type):
    '''Associate a UnifiedUser with a CatalogObject'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DeleteUserInvite(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''Indicates whether the operation was completed successfully'''



class DeleteWebexIntegration(sgqlc.types.Type):
    '''Delete a Webex integration'''
    __schema__ = schema
    __field_names__ = ('deleted',)
    deleted = sgqlc.types.Field(Boolean, graphql_name='deleted')



class DeltaLog(sgqlc.types.Type):
    '''Represents a single entry in the table's Delta History'''
    __schema__ = schema
    __field_names__ = ('version', 'timestamp', 'user_name', 'operation', 'operation_metrics')
    version = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='version')
    '''Table version generated by the operation.'''

    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='timestamp')
    '''When this version was committed.'''

    user_name = sgqlc.types.Field(String, graphql_name='userName')
    '''Name of the user that ran the operation.'''

    operation = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='operation')
    '''Name of the operation.'''

    operation_metrics = sgqlc.types.Field(sgqlc.types.non_null(JSONString), graphql_name='operationMetrics')
    '''Metrics of the operation (for example, number of rows and files
    modified).
    '''



class DeltaLogConnection(sgqlc.types.relay.Connection):
    '''Describes a page of DeltaLog results'''
    __schema__ = schema
    __field_names__ = ('edges', 'page_info')
    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DeltaLogConnectionEdge')), graphql_name='edges')

    page_info = sgqlc.types.Field(sgqlc.types.non_null('DeltaLogConnectionPageInfo'), graphql_name='pageInfo')
    '''Holds details of the current results page'''



class DeltaLogConnectionEdge(sgqlc.types.Type):
    '''Describes each item in a paginated list of Delta Log results'''
    __schema__ = schema
    __field_names__ = ('cursor', 'node')
    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A consistent identifier for each operation in the results list'''

    node = sgqlc.types.Field(sgqlc.types.non_null(DeltaLog), graphql_name='node')
    '''The Delta Log object representing a single operation'''



class DeltaLogConnectionPageInfo(sgqlc.types.Type):
    '''Information about the current page of Delta Log results'''
    __schema__ = schema
    __field_names__ = ('end_cursor', 'has_next_page')
    end_cursor = sgqlc.types.Field(String, graphql_name='endCursor')
    '''The last edge's identifier, can be passed as after argument'''

    has_next_page = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasNextPage')
    '''Whether there are more results to be fetched'''



class DerivedTablePartialLineage(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'columns', 'source_column_used_as_non_selected', 'display_name')
    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''Derived destination table's mcon'''

    columns = sgqlc.types.Field(sgqlc.types.list_of('SourceColumn'), graphql_name='columns')
    '''A list of columns in the derived table, that are derived from some
    source
    '''

    source_column_used_as_non_selected = sgqlc.types.Field(Boolean, graphql_name='sourceColumnUsedAsNonSelected')
    '''Indicates whether the input source column is used as a non
    selected column in the query that derives the current table
    '''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''Display name for BI tables'''



class DerivedTablesLineageResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'source_column', 'destinations', 'is_last_page', 'cursor')
    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''Source table mcon'''

    source_column = sgqlc.types.Field(String, graphql_name='sourceColumn')
    '''Source column'''

    destinations = sgqlc.types.Field(sgqlc.types.list_of(DerivedTablePartialLineage), graphql_name='destinations')
    '''Derived tables and their columns that are influenced by the source
    col
    '''

    is_last_page = sgqlc.types.Field(Boolean, graphql_name='isLastPage')
    '''Indicates whether this response the the last page of response'''

    cursor = sgqlc.types.Field(String, graphql_name='cursor')
    '''Cursor for getting the next page of results'''



class DimensionLabel(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('timestamp', 'label', 'value')
    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')

    label = sgqlc.types.Field(String, graphql_name='label')

    value = sgqlc.types.Field(Float, graphql_name='value')



class DimensionLabelList(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('timestamp', 'label', 'values')
    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')

    label = sgqlc.types.Field(String, graphql_name='label')

    values = sgqlc.types.Field(sgqlc.types.list_of('DimensionLabelListItem'), graphql_name='values')



class DimensionLabelListItem(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('measurement_timestamp', 'value')
    measurement_timestamp = sgqlc.types.Field(DateTime, graphql_name='measurementTimestamp')

    value = sgqlc.types.Field(Float, graphql_name='value')



class DimensionTracking(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('value', 'mn_cnt', 'mx_cnt', 'mn_fld', 'mn_fq', 'mx_fq', 'reason')
    value = sgqlc.types.Field(String, graphql_name='value')
    '''Value name'''

    mn_cnt = sgqlc.types.Field(Int, graphql_name='mnCnt')
    '''Minimum count threshold'''

    mx_cnt = sgqlc.types.Field(Int, graphql_name='mxCnt')
    '''Maximum count threshold'''

    mn_fld = sgqlc.types.Field(Float, graphql_name='mnFld')
    '''Minimum field size required to trigger anomaly'''

    mn_fq = sgqlc.types.Field(Float, graphql_name='mnFq')
    '''Minimum relative frequency threshold'''

    mx_fq = sgqlc.types.Field(Float, graphql_name='mxFq')
    '''Maximum relative frequency threshold'''

    reason = sgqlc.types.Field(String, graphql_name='reason')
    '''Reason for not providing DT thresholds'''



class DimensionTrackingSuggestionsConnection(sgqlc.types.relay.Connection):
    '''Suggestions for creating dimension tracking monitors'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DimensionTrackingSuggestionsEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DimensionTrackingSuggestionsEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DimensionTrackingSuggestions` and its
    cursor.
    '''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DimensionTrackingSuggestions', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DirectedGraph(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('vertices', 'edges')
    vertices = sgqlc.types.Field(String, graphql_name='vertices')

    edges = sgqlc.types.Field(String, graphql_name='edges')



class DisableAirflowLogEvents(sgqlc.types.Type):
    '''Disable collection of Airflow logs via S3 events'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DisableMetadataEvents(sgqlc.types.Type):
    '''Disable collection of metadata via S3 events'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DisableQueryLogEvents(sgqlc.types.Type):
    '''Disable collection of query logs via S3 events'''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')



class DisableUser(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('user',)
    user = sgqlc.types.Field('User', graphql_name='user')



class DisplayableFieldValueType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'value_as_string', 'value_as_string_array', 'linked_mcon', 'linked_mcon_array')
    field_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='fieldName')

    value_as_string = sgqlc.types.Field(String, graphql_name='valueAsString')

    value_as_string_array = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='valueAsStringArray')

    linked_mcon = sgqlc.types.Field(String, graphql_name='linkedMcon')

    linked_mcon_array = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='linkedMconArray')



class DomainOutput(sgqlc.types.Type):
    '''Domain configuration'''
    __schema__ = schema
    __field_names__ = ('uuid', 'name', 'description', 'created_by_email', 'assignments', 'tags')
    uuid = sgqlc.types.Field(UUID, graphql_name='uuid')
    '''Domain UUID'''

    name = sgqlc.types.Field(String, graphql_name='name')
    '''Domain name'''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''Domain description'''

    created_by_email = sgqlc.types.Field(String, graphql_name='createdByEmail')
    '''Domain created by email address'''

    assignments = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='assignments')
    '''Objects assigned to domain (as MCONs)'''

    tags = sgqlc.types.Field(sgqlc.types.list_of('TagKeyValuePairOutput'), graphql_name='tags')
    '''Filter by tag key/value pairs for tables.'''



class DomainRestrictionConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('DomainRestrictionEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class DomainRestrictionEdge(sgqlc.types.Type):
    '''A Relay edge containing a `DomainRestriction` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('DomainRestriction', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class DownstreamBI(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('node_id', 'full_table_id', 'downstream_bi')
    node_id = sgqlc.types.Field(String, graphql_name='nodeId')

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')

    downstream_bi = sgqlc.types.Field(sgqlc.types.list_of(BiLineage), graphql_name='downstreamBi')



class DownstreamImpactRadiusSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('total_users_affected', 'total_reports_affected')
    total_users_affected = sgqlc.types.Field(Int, graphql_name='totalUsersAffected')
    '''Number of users affected'''

    total_reports_affected = sgqlc.types.Field(Int, graphql_name='totalReportsAffected')
    '''Number of reports affected'''



class DownstreamReport(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'display_name', 'report_type', 'object_id', 'owner_id', 'is_custom', 'importance_score', 'tableau_metadata')
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''MCON of the report.'''

    display_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='displayName')
    '''Display name of the report'''

    report_type = sgqlc.types.Field(String, graphql_name='reportType')
    '''Type of the report'''

    object_id = sgqlc.types.Field(String, graphql_name='objectId')
    '''ID of the object'''

    owner_id = sgqlc.types.Field(String, graphql_name='ownerId')
    '''ID of the owner of this object'''

    is_custom = sgqlc.types.Field(Boolean, graphql_name='isCustom')
    '''Indicates whether this is a custom lineage node (created by a
    user)
    '''

    importance_score = sgqlc.types.Field(Float, graphql_name='importanceScore')
    '''Importance score of the report'''

    tableau_metadata = sgqlc.types.Field('TableauMetadata', graphql_name='tableauMetadata')
    '''Metadata for Tableau objects'''



class DownstreamReportOwners(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('owner_ids', 'has_next_page', 'limit', 'offset')
    owner_ids = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='ownerIds')
    '''Owner ID of a BI report'''

    has_next_page = sgqlc.types.Field(Boolean, graphql_name='hasNextPage')
    '''Whether more pages of results exist. Used for pagination.'''

    limit = sgqlc.types.Field(Int, graphql_name='limit')
    '''Limit results returned'''

    offset = sgqlc.types.Field(Int, graphql_name='offset')
    '''Offset when paging'''



class DownstreamReportTypes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('downstream_report_types',)
    downstream_report_types = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='downstreamReportTypes')
    '''List of distinct downstream report types.'''



class DownstreamReports(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('downstream_reports', 'limit', 'offset', 'has_next_page')
    downstream_reports = sgqlc.types.Field(sgqlc.types.list_of(DownstreamReport), graphql_name='downstreamReports')
    '''List of downstream reports'''

    limit = sgqlc.types.Field(Int, graphql_name='limit')
    '''Limit results returned'''

    offset = sgqlc.types.Field(Int, graphql_name='offset')
    '''Offset when paging'''

    has_next_page = sgqlc.types.Field(Boolean, graphql_name='hasNextPage')
    '''Whether more pages of results exist. Used for pagination.'''



class Dynamic(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('min', 'max', 'reason')
    min = sgqlc.types.Field(Float, graphql_name='min')
    '''Minimum threshold'''

    max = sgqlc.types.Field(Float, graphql_name='max')
    '''Maximum threshold'''

    reason = sgqlc.types.Field(String, graphql_name='reason')
    '''Explanation if min/max is missing'''



class ETLJobsType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('jobs', 'has_next_page')
    jobs = sgqlc.types.Field(sgqlc.types.list_of('ETLJobUnionType'), graphql_name='jobs')
    '''ETL Jobs list'''

    has_next_page = sgqlc.types.Field(Boolean, graphql_name='hasNextPage')
    '''Boolean indicating if there's a next page based on limit/offset'''



class EmptyDataCollector(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('uuid', 'customer_aws_region')
    uuid = sgqlc.types.Field(String, graphql_name='uuid')

    customer_aws_region = sgqlc.types.Field(String, graphql_name='customerAwsRegion')



class EtlContainer(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'account', 'uuid', 'data_collector', 'type', 'name', 'is_synthetic', 'connections', 'incidents', 'events', 'airflowdagmodel_set', 'airflowtaskmodel_set', 'airflowdagrunmodel_set', 'airflowtaskrunmodel_set')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    account = sgqlc.types.Field(sgqlc.types.non_null(Account), graphql_name='account')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')

    data_collector = sgqlc.types.Field(DataCollector, graphql_name='dataCollector')

    type = sgqlc.types.Field(EtlType, graphql_name='type')

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''A friendly name for this etl container'''

    is_synthetic = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isSynthetic')
    '''Whether this etl container is created as a result of another
    connection
    '''

    connections = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(Connection))), graphql_name='connections')

    incidents = sgqlc.types.Field(sgqlc.types.non_null('IncidentConnection'), graphql_name='incidents', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    events = sgqlc.types.Field(sgqlc.types.non_null('EventConnection'), graphql_name='events', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    airflowdagmodel_set = sgqlc.types.Field(sgqlc.types.non_null(AirflowDagConnection), graphql_name='airflowdagmodelSet', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''ETL container associated with the pipeline

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    airflowtaskmodel_set = sgqlc.types.Field(sgqlc.types.non_null(AirflowTaskConnection), graphql_name='airflowtaskmodelSet', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''ETL container associated with the pipeline

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    airflowdagrunmodel_set = sgqlc.types.Field(sgqlc.types.non_null(AirflowDagRunConnection), graphql_name='airflowdagrunmodelSet', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''ETL container associated with the event

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    airflowtaskrunmodel_set = sgqlc.types.Field(sgqlc.types.non_null(AirflowTaskRunConnection), graphql_name='airflowtaskrunmodelSet', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''ETL container associated with the event

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''



class EventCommentConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('EventCommentEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class EventCommentEdge(sgqlc.types.Type):
    '''A Relay edge containing a `EventComment` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('EventComment', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class EventConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('EventEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class EventEdge(sgqlc.types.Type):
    '''A Relay edge containing a `Event` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('Event', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class EventMutingRule(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'uuid', 'warehouse', 'rule_type', 'rule', 'is_active', 'created_time', 'last_update_time', 'event_types')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')

    warehouse = sgqlc.types.Field(sgqlc.types.non_null('Warehouse'), graphql_name='warehouse')

    rule_type = sgqlc.types.Field(sgqlc.types.non_null(EventMutingRuleModelRuleType), graphql_name='ruleType')

    rule = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='rule')

    is_active = sgqlc.types.Field(Boolean, graphql_name='isActive')

    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdTime')

    last_update_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='lastUpdateTime')

    event_types = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='eventTypes')
    '''List of event types to mute. Mutes all if empty.'''



class EventOnbardingConfig(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('account_uuid', 'config')
    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='accountUuid')

    config = sgqlc.types.Field(JSONString, graphql_name='config')
    '''Onboarding Config meant to be shared between customers and MC'''



class EventRcaData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('event_uuid', 'rcas')
    event_uuid = sgqlc.types.Field(UUID, graphql_name='eventUuid')

    rcas = sgqlc.types.Field(sgqlc.types.list_of('ExtendedRca'), graphql_name='rcas')



class EventRcaStatus(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'event', 'rca', 'set_ts', 'reason', 'rca_module', 'rca_job_uuid')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    event = sgqlc.types.Field(sgqlc.types.non_null('Event'), graphql_name='event')

    rca = sgqlc.types.Field('RcaJob', graphql_name='rca')

    set_ts = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='setTs')

    reason = sgqlc.types.Field(sgqlc.types.non_null(EventRcaStatusModelReason), graphql_name='reason')
    '''Reason why RCA was assigned a specific status.'''

    rca_module = sgqlc.types.Field(String, graphql_name='rcaModule')
    '''The RCA module that detected the failure reason'''

    rca_job_uuid = sgqlc.types.Field(UUID, graphql_name='rcaJobUuid')
    '''UUID of the RCA job associated with the status'''



class EventRcaStatusModelType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'event', 'rca', 'set_ts', 'reason', 'rca_module')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    event = sgqlc.types.Field(sgqlc.types.non_null('Event'), graphql_name='event')

    rca = sgqlc.types.Field('RcaJob', graphql_name='rca')

    set_ts = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='setTs')

    reason = sgqlc.types.Field(sgqlc.types.non_null(EventRcaStatusModelReason), graphql_name='reason')
    '''Reason why RCA was assigned a specific status.'''

    rca_module = sgqlc.types.Field(String, graphql_name='rcaModule')
    '''The RCA module that detected the failure reason'''



class EventStateSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('open', 'false_positive', 'no_action_required', 'notified', 'resolved', 'user_resolved', 'system_resolved', 'muted', 'stale')
    open = sgqlc.types.Field(Int, graphql_name='open')

    false_positive = sgqlc.types.Field(Int, graphql_name='falsePositive')

    no_action_required = sgqlc.types.Field(Int, graphql_name='noActionRequired')

    notified = sgqlc.types.Field(Int, graphql_name='notified')

    resolved = sgqlc.types.Field(Int, graphql_name='resolved')

    user_resolved = sgqlc.types.Field(Int, graphql_name='userResolved')

    system_resolved = sgqlc.types.Field(Int, graphql_name='systemResolved')

    muted = sgqlc.types.Field(Int, graphql_name='muted')

    stale = sgqlc.types.Field(Int, graphql_name='stale')



class EventTopology(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('event', 'upstream')
    event = sgqlc.types.Field('Event', graphql_name='event')
    '''Reference to an event'''

    upstream = sgqlc.types.Field(sgqlc.types.list_of('Event'), graphql_name='upstream')
    '''List of events immediately upstream'''



class EventTypeSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('schema_change', 'fresh_anom', 'unchanged_size_anom', 'json_schema_change', 'delete_table', 'size_anom', 'size_diff', 'metric_anom', 'custom_rule_anom', 'dist_anom', 'query_runtime_anom', 'query_performance_anom', 'dbt_model_error', 'dbt_test_failure', 'airflow_dag_failure', 'rule_run_failure', 'comparison_rule_anom')
    schema_change = sgqlc.types.Field(Int, graphql_name='schemaChange')

    fresh_anom = sgqlc.types.Field(Int, graphql_name='freshAnom')

    unchanged_size_anom = sgqlc.types.Field(Int, graphql_name='unchangedSizeAnom')

    json_schema_change = sgqlc.types.Field(Int, graphql_name='jsonSchemaChange')

    delete_table = sgqlc.types.Field(Int, graphql_name='deleteTable')

    size_anom = sgqlc.types.Field(Int, graphql_name='sizeAnom')

    size_diff = sgqlc.types.Field(Int, graphql_name='sizeDiff')

    metric_anom = sgqlc.types.Field(Int, graphql_name='metricAnom')

    custom_rule_anom = sgqlc.types.Field(Int, graphql_name='customRuleAnom')

    dist_anom = sgqlc.types.Field(Int, graphql_name='distAnom')

    query_runtime_anom = sgqlc.types.Field(Int, graphql_name='queryRuntimeAnom')

    query_performance_anom = sgqlc.types.Field(Int, graphql_name='queryPerformanceAnom')

    dbt_model_error = sgqlc.types.Field(Int, graphql_name='dbtModelError')

    dbt_test_failure = sgqlc.types.Field(Int, graphql_name='dbtTestFailure')

    airflow_dag_failure = sgqlc.types.Field(Int, graphql_name='airflowDagFailure')

    rule_run_failure = sgqlc.types.Field(Int, graphql_name='ruleRunFailure')

    comparison_rule_anom = sgqlc.types.Field(Int, graphql_name='comparisonRuleAnom')



class ExecDashboardDataColumn(sgqlc.types.Type):
    '''A column for a table.'''
    __schema__ = schema
    __field_names__ = ('name', 'type')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''Name associated with the column, can be used to identify it.'''

    type = sgqlc.types.Field(sgqlc.types.non_null(DataColumnTypes), graphql_name='type')
    '''Data type of the values included in the column.'''



class ExecDashboardDataPoint(sgqlc.types.Type):
    '''A single measure/data point for a metric.'''
    __schema__ = schema
    __field_names__ = ('value', 'period_start', 'dimension', 'children')
    value = sgqlc.types.Field(Float, graphql_name='value')
    '''Value of data point.'''

    period_start = sgqlc.types.Field(DateTime, graphql_name='periodStart')
    '''Start of period for data point, for time series.'''

    dimension = sgqlc.types.Field(String, graphql_name='dimension')
    '''Dimension of data point, for category series.'''

    children = sgqlc.types.Field(sgqlc.types.list_of('ExecDashboardDataPoint'), graphql_name='children')



class ExecDashboardDataRow(sgqlc.types.Type):
    '''A row with values for each column.'''
    __schema__ = schema
    __field_names__ = ('values',)
    values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='values')
    '''Values for each column in the row.'''



class ExecDashboardMetric(sgqlc.types.Type):
    '''A set of data points (or single data point) that is a named
    measure.
    '''
    __schema__ = schema
    __field_names__ = ('metric', 'data_points', 'has_error')
    metric = sgqlc.types.Field(sgqlc.types.non_null(ExecDashboardMetrics), graphql_name='metric')
    '''Metric identifier.'''

    data_points = sgqlc.types.Field(sgqlc.types.list_of(ExecDashboardDataPoint), graphql_name='dataPoints')
    '''Data points. May only be one for single-value metrics.'''

    has_error = sgqlc.types.Field(Boolean, graphql_name='hasError')
    '''If true, indicates an error occurred trying to get metric data.'''



class ExecDashboardTable(sgqlc.types.Type):
    '''A table with measured values.'''
    __schema__ = schema
    __field_names__ = ('table', 'data_columns', 'data_rows', 'is_visible', 'has_error')
    table = sgqlc.types.Field(sgqlc.types.non_null(ExecDashboardTables), graphql_name='table')
    '''Table identifier.'''

    data_columns = sgqlc.types.Field(sgqlc.types.list_of(ExecDashboardDataColumn), graphql_name='dataColumns')
    '''Column definitions.'''

    data_rows = sgqlc.types.Field(sgqlc.types.list_of(ExecDashboardDataRow), graphql_name='dataRows')
    '''Row values.'''

    is_visible = sgqlc.types.Field(Boolean, graphql_name='isVisible')
    '''If true, indicates that the table must be shown, otherwise it
    should be hidden.
    '''

    has_error = sgqlc.types.Field(Boolean, graphql_name='hasError')
    '''If true, indicates an error occurred trying to get metric data.'''



class ExplanationDataPointType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query_id', 'timestamp', 'execution_time', 'baseline_metric', 'pct_increase_over_baseline_upper_threshold', 'is_breach')
    query_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryId')
    '''Query ID of query execution'''

    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='timestamp')
    '''Timestamp of query'''

    execution_time = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='executionTime')
    '''Execution time of query'''

    baseline_metric = sgqlc.types.Field(Float, graphql_name='baselineMetric')
    '''Historical baseline metric'''

    pct_increase_over_baseline_upper_threshold = sgqlc.types.Field(Float, graphql_name='pctIncreaseOverBaselineUpperThreshold')
    '''Upper threshold of % increase over historical baseline metric'''

    is_breach = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isBreach')
    '''True if this query execution breaches monitor.'''



class ExplanatoryFieldMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('candidates',)
    candidates = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='candidates')
    '''Fields which can be used as explanatory'''



class FHNumericRcaResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('rca',)
    rca = sgqlc.types.Field(sgqlc.types.list_of('FHNumericResult'), graphql_name='rca')



class FHNumericResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metric_name', 'metric_field_name', 'explanatory_field_name', 'explanatory_field_value', 'normal_row_ratio', 'anomalous_row_ratio', 'normal_metric_value', 'anomalous_metric_value', 'explainability1', 'explainability2', 'correlation')
    metric_name = sgqlc.types.Field(String, graphql_name='metricName')
    '''The metric which we ran the correlation for (i.e. mean, p80, etc.)'''

    metric_field_name = sgqlc.types.Field(String, graphql_name='metricFieldName')
    '''The name of the field we ran the correlation for'''

    explanatory_field_name = sgqlc.types.Field(String, graphql_name='explanatoryFieldName')
    '''The name of the column in which a value is correlated with the
    anomalous rows
    '''

    explanatory_field_value = sgqlc.types.Field(String, graphql_name='explanatoryFieldValue')
    '''The value correlated with the anomalous rows'''

    normal_row_ratio = sgqlc.types.Field(Float, graphql_name='normalRowRatio')
    '''The ratio of rows out of total rows for the explanatory value
    prior to the anomaly
    '''

    anomalous_row_ratio = sgqlc.types.Field(Float, graphql_name='anomalousRowRatio')
    '''The ratio of rows out of total rows for the explanatory value in
    the anomalous rows
    '''

    normal_metric_value = sgqlc.types.Field(Float, graphql_name='normalMetricValue')
    '''The value of the relevant metric prior to the anomaly'''

    anomalous_metric_value = sgqlc.types.Field(Float, graphql_name='anomalousMetricValue')
    '''The value of metric in the anomalous rows'''

    explainability1 = sgqlc.types.Field(Float, graphql_name='explainability1')
    '''Explainability 1 score'''

    explainability2 = sgqlc.types.Field(Float, graphql_name='explainability2')
    '''Explainability 2 score'''

    correlation = sgqlc.types.Field(String, graphql_name='correlation')
    '''high or low correlation found on field'''



class FacetEntry(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('key', 'count')
    key = sgqlc.types.Field(String, graphql_name='key')
    '''Key of facet entry'''

    count = sgqlc.types.Field(Int, graphql_name='count')
    '''Number of documents that contain key'''



class FacetResultType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('value', 'display_name', 'count')
    value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='value')
    '''Field value'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''Display name'''

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='count')
    '''Count'''



class FacetResults(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('facet_type', 'entries')
    facet_type = sgqlc.types.Field(FacetType, graphql_name='facetType')
    '''Facet type'''

    entries = sgqlc.types.Field(sgqlc.types.list_of(FacetEntry), graphql_name='entries')
    '''Facet entries'''



class FieldChange(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field', 'friendly_name', 'scalar_change', 'many_to_many_change')
    field = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='field')
    '''The name of the changed field'''

    friendly_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='friendlyName')
    '''Friendly name of the changed field'''

    scalar_change = sgqlc.types.Field('ScalarChange', graphql_name='scalarChange')
    '''Change to scalar field'''

    many_to_many_change = sgqlc.types.Field('ManyToManyChange', graphql_name='manyToManyChange')
    '''Change to M2M field'''



class FieldDistRcaData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('time_field', 'anom_time', 'explanatory_field', 'val')
    time_field = sgqlc.types.Field(String, graphql_name='timeField')
    '''Table field which serves as a time axis'''

    anom_time = sgqlc.types.Field(DateTime, graphql_name='anomTime')
    '''Time when the anomaly occurred'''

    explanatory_field = sgqlc.types.Field(String, graphql_name='explanatoryField')
    '''Table field containing the explanatory value'''

    val = sgqlc.types.Field(String, graphql_name='val')
    '''Explanatory value used in the analysis'''



class FieldDistRcaResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('rca', 'plot_data', 'low_card_fields_wo_rca', 'available_fields')
    rca = sgqlc.types.Field(sgqlc.types.list_of(FieldDistRcaData), graphql_name='rca')

    plot_data = sgqlc.types.Field(sgqlc.types.list_of('RcaPlotData'), graphql_name='plotData', args=sgqlc.types.ArgDict((
        ('field_name', sgqlc.types.Arg(String, graphql_name='fieldName', default=None)),
))
    )
    '''Arguments:

    * `field_name` (`String`)None
    '''

    low_card_fields_wo_rca = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='lowCardFieldsWoRca')

    available_fields = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='availableFields')



class FieldDownstreamBi(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('bi_account_id', 'bi_identifier', 'bi_name', 'bi_type', 'bi_node_id', 'last_seen')
    bi_account_id = sgqlc.types.Field(String, graphql_name='biAccountId')

    bi_identifier = sgqlc.types.Field(String, graphql_name='biIdentifier')

    bi_name = sgqlc.types.Field(String, graphql_name='biName')

    bi_type = sgqlc.types.Field(String, graphql_name='biType')

    bi_node_id = sgqlc.types.Field(String, graphql_name='biNodeId')

    last_seen = sgqlc.types.Field(DateTime, graphql_name='lastSeen')



class FieldHealth(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('lower', 'upper', 'status', 'reason')
    lower = sgqlc.types.Field(Float, graphql_name='lower')
    '''Field health lower threshold'''

    upper = sgqlc.types.Field(Float, graphql_name='upper')
    '''Field health upper threshold'''

    status = sgqlc.types.Field(DetectorStatus, graphql_name='status')
    '''Status of the FH detection'''

    reason = sgqlc.types.Field(String, graphql_name='reason')
    '''Reason for not providing FH thresholds'''



class FieldHealthSampling(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('columns', 'rows', 'sampling_disabled', 'normal_records_query', 'anomalous_records_query')
    columns = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='columns')

    rows = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.list_of(String)), graphql_name='rows')

    sampling_disabled = sgqlc.types.Field(Boolean, graphql_name='samplingDisabled')

    normal_records_query = sgqlc.types.Field(String, graphql_name='normalRecordsQuery')
    '''This is null for summary statistics such as mean, min, max, and
    percentiles
    '''

    anomalous_records_query = sgqlc.types.Field(String, graphql_name='anomalousRecordsQuery')



class FieldHealthSuggestionsConnection(sgqlc.types.relay.Connection):
    '''Suggestions for creating field health monitors'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('FieldHealthSuggestionsEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class FieldHealthSuggestionsEdge(sgqlc.types.Type):
    '''A Relay edge containing a `FieldHealthSuggestions` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('FieldHealthSuggestions', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class FieldMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_type', 'table')
    field_type = sgqlc.types.Field(String, graphql_name='fieldType')

    table = sgqlc.types.Field('TableRef', graphql_name='table')



class FieldMetricFilterOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'operator', 'value')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field to filter by'''

    operator = sgqlc.types.Field(sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name='operator')
    '''Operator to filter field by'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Value to filter field by'''



class FieldMetricOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('table_mcon', 'table_mcons', 'field_name', 'field_names', 'metric_type', 'value_list', 'value_sql', 'filters')
    table_mcon = sgqlc.types.Field(String, graphql_name='tableMcon')
    '''MCON of the table the metric is based on'''

    table_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='tableMcons')
    '''MCONs of the table the metric is based on'''

    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Name of the field the metric is based on'''

    field_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='fieldNames')
    '''Name of the fields the metric is based on'''

    metric_type = sgqlc.types.Field(sgqlc.types.non_null(FieldMetricType), graphql_name='metricType')
    '''Type of metric to compute'''

    value_list = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='valueList')
    '''Values for metrics that check for cardinality'''

    value_sql = sgqlc.types.Field(String, graphql_name='valueSql')
    '''Values SQL expression for metrics that check for cardinality'''

    filters = sgqlc.types.Field(sgqlc.types.list_of(FieldMetricFilterOutput), graphql_name='filters')
    '''Filters for which rows the metric is computed over'''



class FieldMetricQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('sql_query',)
    sql_query = sgqlc.types.Field(String, graphql_name='sqlQuery')
    '''SQL query for the metric'''



class FieldQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('sql_query',)
    sql_query = sgqlc.types.Field(String, graphql_name='sqlQuery')
    '''SQL query'''



class FieldQueryFilterOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'operator', 'value')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field to filter by'''

    operator = sgqlc.types.Field(sgqlc.types.non_null(CustomRuleComparisonOperator), graphql_name='operator')
    '''Operator to filter field by'''

    value = sgqlc.types.Field(String, graphql_name='value')
    '''Value to filter field by'''



class FieldQueryParametersOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('table_mcons', 'field_names', 'query_type', 'value_list', 'value_sql', 'filters')
    table_mcons = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='tableMcons')
    '''MCONs of the table the query is based on'''

    field_names = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='fieldNames')
    '''Name of the fields the query is based on'''

    query_type = sgqlc.types.Field(sgqlc.types.non_null(FieldQueryType), graphql_name='queryType')
    '''Type of query'''

    value_list = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='valueList')
    '''Values for queries that check for cardinality'''

    value_sql = sgqlc.types.Field(String, graphql_name='valueSql')
    '''Values SQL expression for metrics that check for cardinality'''

    filters = sgqlc.types.Field(sgqlc.types.list_of(FieldQueryFilterOutput), graphql_name='filters')
    '''Filters for which rows the query is computed over'''



class FieldValueCorrelation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field', 'value', 'norm_rate', 'anom_rate')
    field = sgqlc.types.Field(String, graphql_name='field')

    value = sgqlc.types.Field(String, graphql_name='value')

    norm_rate = sgqlc.types.Field(Float, graphql_name='normRate')

    anom_rate = sgqlc.types.Field(Float, graphql_name='anomRate')



class FivetranConnectorConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('FivetranConnectorEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class FivetranConnectorEdge(sgqlc.types.Type):
    '''A Relay edge containing a `FivetranConnector` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('FivetranConnector', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class FivetranDestinationConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('FivetranDestinationEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class FivetranDestinationEdge(sgqlc.types.Type):
    '''A Relay edge containing a `FivetranDestination` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('FivetranDestination', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class FlattenedLineageGraphEdges(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'directly_connected_mcons', 'directly_connected_nodes')
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''Monte Carlo full identifier for an entity'''

    directly_connected_mcons = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='directlyConnectedMcons')
    '''MCONs of nodes directly connected to the entity'''

    directly_connected_nodes = sgqlc.types.Field(sgqlc.types.list_of('LineageGraphEdgeNode'), graphql_name='directlyConnectedNodes')
    '''Nodes directly connected to the entity, including edge properties'''



class Freshness(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('status', 'expected', 'breach', 'reason', 'last_update', 'detector_threshold', 'threshold_low', 'threshold_medium', 'threshold_high')
    status = sgqlc.types.Field(DetectorStatus, graphql_name='status')
    '''Status of the freshness detector'''

    expected = sgqlc.types.Field(Float, graphql_name='expected')
    '''Time delta of next expected update (in seconds)'''

    breach = sgqlc.types.Field(Float, graphql_name='breach')
    '''Time delta when a delay is considered a breach (in seconds)'''

    reason = sgqlc.types.Field(String, graphql_name='reason')
    '''Explanation if expected and/or breach is missing'''

    last_update = sgqlc.types.Field(DateTime, graphql_name='lastUpdate')
    '''Last time the table was updated'''

    detector_threshold = sgqlc.types.Field(Float, graphql_name='detectorThreshold')
    '''The threshold calculated by the detector model'''

    threshold_low = sgqlc.types.Field(Float, graphql_name='thresholdLow')
    '''The "low" level threshold calculated by the detector model'''

    threshold_medium = sgqlc.types.Field(Float, graphql_name='thresholdMedium')
    '''The "medium" level threshold calculated by the detector model'''

    threshold_high = sgqlc.types.Field(Float, graphql_name='thresholdHigh')
    '''The "high" level threshold calculated by the detector model'''



class FreshnessCycleData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('periodic', 'usual_update_cycle_hours', 'maximal_update_cycle_hours')
    periodic = sgqlc.types.Field(Boolean, graphql_name='periodic')
    '''Whether or not this table is updated periodically'''

    usual_update_cycle_hours = sgqlc.types.Field(Int, graphql_name='usualUpdateCycleHours')
    '''The median update in hours'''

    maximal_update_cycle_hours = sgqlc.types.Field(Int, graphql_name='maximalUpdateCycleHours')
    '''Time delta when a delay is considered a breach (in seconds)'''



class GenerateCollectorTemplate(sgqlc.types.Type):
    '''Generate a data collector template (uploaded to S3)'''
    __schema__ = schema
    __field_names__ = ('dc',)
    dc = sgqlc.types.Field(DataCollector, graphql_name='dc')
    '''The data collector that was created or updated'''



class GenerateDcUpgradeTemplate(sgqlc.types.Type):
    '''Generates a template for DC upgrade and a URL to execute the
    template in the cloud provider.
    '''
    __schema__ = schema
    __field_names__ = ('upgrade_launch_url', 'template_url', 'code_version', 'template_version', 'template_variant', 'is_mc_hosted', 'is_up_to_date')
    upgrade_launch_url = sgqlc.types.Field(String, graphql_name='upgradeLaunchUrl')
    '''A link that launches the upgrade flow (for instance in AWS
    CloudFormation) that customers can complete to upgrade a data
    collector stack.
    '''

    template_url = sgqlc.types.Field(String, graphql_name='templateUrl')
    '''A link to the deployment template URL (for instance an AWS S3
    URL). This can be used to diff against an existing deployment
    template and review upgrades.
    '''

    code_version = sgqlc.types.Field(String, graphql_name='codeVersion')
    '''The code version of the upgrade.'''

    template_version = sgqlc.types.Field(String, graphql_name='templateVersion')
    '''The template version of the upgrade.'''

    template_variant = sgqlc.types.Field(String, graphql_name='templateVariant')
    '''The template variant of the upgrade.'''

    is_mc_hosted = sgqlc.types.Field(Boolean, graphql_name='isMcHosted')
    '''Indicates whether the data collector is hosted by Monte Carlo.'''

    is_up_to_date = sgqlc.types.Field(Boolean, graphql_name='isUpToDate')
    '''Indicates whether the data collector is already running on the
    latest code and infrastructure.
    '''



class GetAccountAuditLogsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('records', 'page_info')
    records = sgqlc.types.Field(sgqlc.types.list_of(AccountAuditLog), graphql_name='records')
    '''List of audit log records'''

    page_info = sgqlc.types.Field('PageInfo', graphql_name='pageInfo')
    '''Pagination info'''



class GetAlationTableFlags(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('flag_type', 'flag_reason')
    flag_type = sgqlc.types.Field(sgqlc.types.non_null(TableFlagType), graphql_name='flagType')
    '''The type of the flag. Either WARNING or DEPRECATION'''

    flag_reason = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='flagReason')
    '''A reason or a description of the flag'''



class GetCustomFreshnessDatapointsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metric', 'datapoints')
    metric = sgqlc.types.Field(String, graphql_name='metric')
    '''Name of the metric. For instance, last_updated_on'''

    datapoints = sgqlc.types.Field(sgqlc.types.list_of(CustomRuleDatapoint), graphql_name='datapoints')
    '''The datapoints'''



class GetCustomVolumeDatapointsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metric', 'datapoints')
    metric = sgqlc.types.Field(String, graphql_name='metric')
    '''Name of the metric. For instance, total_row_count'''

    datapoints = sgqlc.types.Field(sgqlc.types.list_of(CustomRuleDatapoint), graphql_name='datapoints')
    '''The datapoints'''



class GetTableauAssetWarningByIdResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('message',)
    message = sgqlc.types.Field(String, graphql_name='message')
    '''The message body of the warning.'''



class GithubAppInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('install_link', 'installations')
    install_link = sgqlc.types.Field(String, graphql_name='installLink')
    '''Link to click in order to install new Github integration'''

    installations = sgqlc.types.Field(sgqlc.types.list_of('GithubAppInstallation'), graphql_name='installations')
    '''Metadata about Github App installation'''



class GithubAppInstallation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('uuid', 'gh_org', 'show_impact_analysis', 'settings_link')
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Internal Github installation uuid'''

    gh_org = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='ghOrg')
    '''Github Org name in which the Github App is installed'''

    show_impact_analysis = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='showImpactAnalysis')
    '''Controls whether or not to show impacted models and reports as a
    PR comment
    '''

    settings_link = sgqlc.types.Field(String, graphql_name='settingsLink')
    '''Link to click in order to configure Github App installation'''



class GithubPullRequestConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('GithubPullRequestEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class GithubPullRequestEdge(sgqlc.types.Type):
    '''A Relay edge containing a `GithubPullRequest` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('GithubPullRequest', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class GithubPullRequestFile(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('path', 'change_type', 'additions', 'deletions')
    path = sgqlc.types.Field(String, graphql_name='path')
    '''File path from the root of the repository'''

    change_type = sgqlc.types.Field(String, graphql_name='changeType')
    '''File change type: added, modified, removed'''

    additions = sgqlc.types.Field(Int, graphql_name='additions')
    '''Number of lines added'''

    deletions = sgqlc.types.Field(Int, graphql_name='deletions')
    '''Number of lines deleted'''



class GithubPullRequestImpact(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon',)
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''MCON of a table impacted by the pull reuqets'''



class GithubPullRequestInsight(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('pull_request',)
    pull_request = sgqlc.types.Field(sgqlc.types.non_null('GithubPullRequest'), graphql_name='pullRequest')
    '''Reference to the pull request identified as root cause'''



class GithubPullRequestsList(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('pull_requests',)
    pull_requests = sgqlc.types.Field(sgqlc.types.list_of('GithubPullRequest'), graphql_name='pullRequests')
    '''List of pull requests'''



class GithubUser(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('login', 'avatar_url')
    login = sgqlc.types.Field(String, graphql_name='login')
    '''Github user login'''

    avatar_url = sgqlc.types.Field(String, graphql_name='avatarUrl')
    '''Github user Avatar URL'''



class HighlightSnippets(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'snippets')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field name'''

    snippets = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='snippets')
    '''Highlighted snippet'''



class IncidentConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges', 'total_count')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('IncidentEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''

    total_count = sgqlc.types.Field(Int, graphql_name='totalCount')
    '''Both startTime and endTime must be supplied to get totalCount'''



class IncidentDailyCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('day', 'incident_count')
    day = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='day')
    '''The date for the incident count'''

    incident_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='incidentCount')
    '''The incident count'''



class IncidentDashboardData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('total_incident_count', 'no_status_count', 'investigating_count', 'fixed_count', 'expected_and_no_action_count')
    total_incident_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalIncidentCount')
    '''The total count of incidents over the specified weeks'''

    no_status_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='noStatusCount')
    '''The total count of incidents with no status over the specified
    weeks
    '''

    investigating_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='investigatingCount')
    '''The total count of incidents with status of investigating over the
    specified weeks
    '''

    fixed_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='fixedCount')
    '''The total count of incidents with fixed status over the specified
    weeks
    '''

    expected_and_no_action_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='expectedAndNoActionCount')
    '''The total count of incidents with status expected or no action
    over the specified weeks
    '''



class IncidentEdge(sgqlc.types.Type):
    '''A Relay edge containing a `Incident` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('Incident', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class IncidentRcaData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('primary_rca', 'event_rcas', 'incident_rcas')
    primary_rca = sgqlc.types.Field('PrimaryRcaData', graphql_name='primaryRca')

    event_rcas = sgqlc.types.Field(sgqlc.types.list_of(EventRcaData), graphql_name='eventRcas')

    incident_rcas = sgqlc.types.Field(sgqlc.types.list_of('IncidentScopedRcaData'), graphql_name='incidentRcas')



class IncidentReactionConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('IncidentReactionEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class IncidentReactionEdge(sgqlc.types.Type):
    '''A Relay edge containing a `IncidentReaction` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('IncidentReaction', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class IncidentSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('incident_id', 'types', 'states', 'tables', 'key_assets', 'has_rca')
    incident_id = sgqlc.types.Field(UUID, graphql_name='incidentId')

    types = sgqlc.types.Field(EventTypeSummary, graphql_name='types')

    states = sgqlc.types.Field(EventStateSummary, graphql_name='states')

    tables = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='tables')

    key_assets = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='keyAssets')
    '''Number of key assets(tables) in incident'''

    has_rca = sgqlc.types.Field(Boolean, graphql_name='hasRca')
    '''Whether an rca insight exists for this incident'''



class IncidentTableMcons(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('tables',)
    tables = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='tables')
    '''The list of table mcons directly impacted by incident'''



class IncidentTimePeriodAggregateData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('start_date', 'end_date', 'values')
    start_date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='startDate')
    '''The start date for the aggregated data'''

    end_date = sgqlc.types.Field(sgqlc.types.non_null(Date), graphql_name='endDate')
    '''The end date for the aggregated data'''

    values = sgqlc.types.Field(sgqlc.types.list_of('LabelCount'), graphql_name='values')
    '''The aggregate label and count for the time time period'''



class IncidentTopology(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('root_events',)
    root_events = sgqlc.types.Field(sgqlc.types.list_of(EventTopology), graphql_name='rootEvents')
    '''List of root events in the incident'''



class IncidentTypeSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('anomalies', 'schema_changes', 'json_schema_changes', 'deleted_tables', 'metric_anomalies', 'custom_rule_anomalies', 'performance_anomalies', 'dbt_errors', 'etl_errors', 'pseudo_integration_test', 'rule_run_execution_error')
    anomalies = sgqlc.types.Field(Int, graphql_name='anomalies')

    schema_changes = sgqlc.types.Field(Int, graphql_name='schemaChanges')

    json_schema_changes = sgqlc.types.Field(Int, graphql_name='jsonSchemaChanges')

    deleted_tables = sgqlc.types.Field(Int, graphql_name='deletedTables')

    metric_anomalies = sgqlc.types.Field(Int, graphql_name='metricAnomalies')

    custom_rule_anomalies = sgqlc.types.Field(Int, graphql_name='customRuleAnomalies')

    performance_anomalies = sgqlc.types.Field(Int, graphql_name='performanceAnomalies')

    dbt_errors = sgqlc.types.Field(Int, graphql_name='dbtErrors')

    etl_errors = sgqlc.types.Field(Int, graphql_name='etlErrors')

    pseudo_integration_test = sgqlc.types.Field(Int, graphql_name='pseudoIntegrationTest')

    rule_run_execution_error = sgqlc.types.Field(Int, graphql_name='ruleRunExecutionError')



class IncidentWeeklyDataDashboard(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('weekly_data',)
    weekly_data = sgqlc.types.Field(sgqlc.types.list_of(IncidentTimePeriodAggregateData), graphql_name='weeklyData')
    '''The weekly incident data'''



class IncidentsFilter(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'display_name', 'incidents_parameter_name', 'incidents_parameter_accepts_multiple_values', 'facetable', 'facet_searchable')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')

    display_name = sgqlc.types.Field(String, graphql_name='displayName')

    incidents_parameter_name = sgqlc.types.Field(String, graphql_name='incidentsParameterName')
    '''Associated getIncidents parameter used to filter incidents'''

    incidents_parameter_accepts_multiple_values = sgqlc.types.Field(Boolean, graphql_name='incidentsParameterAcceptsMultipleValues')
    '''Whether the associated getIncidents parameter accepts multiple
    values as input
    '''

    facetable = sgqlc.types.Field(Boolean, graphql_name='facetable')
    '''Whether the filter shows up as a facet on the incidents UI page'''

    facet_searchable = sgqlc.types.Field(Boolean, graphql_name='facetSearchable')
    '''Whether the filter values can be searched by their display name'''



class IncidentsFilterData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'values', 'page_info')
    field_name = sgqlc.types.Field(IncidentsFilterFields, graphql_name='fieldName')

    values = sgqlc.types.Field(sgqlc.types.list_of('IncidentsFilterDataValue'), graphql_name='values')
    '''List of possible values to filter incidents'''

    page_info = sgqlc.types.Field('NextPageInfo', graphql_name='pageInfo')
    '''Data for paginating values'''



class IncidentsFilterDataValue(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('value', 'display_name', 'count', 'child_values', 'incidents_parameter_name')
    value = sgqlc.types.Field(GenericScalar, graphql_name='value')

    display_name = sgqlc.types.Field(String, graphql_name='displayName')

    count = sgqlc.types.Field(Int, graphql_name='count')

    child_values = sgqlc.types.Field(sgqlc.types.list_of('IncidentsFilterDataValue'), graphql_name='childValues')

    incidents_parameter_name = sgqlc.types.Field(String, graphql_name='incidentsParameterName')
    '''If this has a value, it should override the value from
    IncidentsFilter
    '''



class IndexedFieldFilterOutputType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'values', 'operator')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field name'''

    values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='values')
    '''Values to filter by'''

    operator = sgqlc.types.Field(FieldValueFilterOperator, graphql_name='operator')
    '''comparison operator to use when filtering'''



class IndexedFieldSpecType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'display_name', 'displayable', 'aggregatable', 'facetable', 'filterable', 'facet_searchable', 'dashboard_types')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')

    display_name = sgqlc.types.Field(String, graphql_name='displayName')

    displayable = sgqlc.types.Field(Boolean, graphql_name='displayable')

    aggregatable = sgqlc.types.Field(Boolean, graphql_name='aggregatable')

    facetable = sgqlc.types.Field(Boolean, graphql_name='facetable')

    filterable = sgqlc.types.Field(Boolean, graphql_name='filterable')

    facet_searchable = sgqlc.types.Field(Boolean, graphql_name='facetSearchable')

    dashboard_types = sgqlc.types.Field(sgqlc.types.list_of(DashboardType), graphql_name='dashboardTypes')



class Insight(sgqlc.types.Type):
    '''Available data on a specific element of the system created by DS'''
    __schema__ = schema
    __field_names__ = ('name', 'title', 'usage', 'description', 'reports', 'available')
    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''Name (id) of insight'''

    title = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='title')
    '''Insight display name'''

    usage = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='usage')
    '''Explains what the insight data can be used for'''

    description = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='description')
    '''Information the reports for the insight will provide'''

    reports = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null('Report')), graphql_name='reports')
    '''Reports available for the insight'''

    available = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='available')
    '''True if this insight is currently available'''



class IntegrationKey(sgqlc.types.Type):
    '''Integration key id and secret. Only available once.'''
    __schema__ = schema
    __field_names__ = ('id', 'secret')
    id = sgqlc.types.Field(String, graphql_name='id')
    '''Key id'''

    secret = sgqlc.types.Field(String, graphql_name='secret')
    '''Key secret'''



class IntegrationKeyMetadata(sgqlc.types.Type):
    '''Metadata for an integration key (will not include the associated
    secret)
    '''
    __schema__ = schema
    __field_names__ = ('id', 'description', 'scope', 'warehouses', 'created_time', 'created_by')
    id = sgqlc.types.Field(String, graphql_name='id')
    '''Key id'''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''Key description'''

    scope = sgqlc.types.Field(String, graphql_name='scope')
    '''Key scope (integration it can be used for)'''

    warehouses = sgqlc.types.Field(sgqlc.types.list_of('Warehouse'), graphql_name='warehouses')
    '''Warehouses associated with key'''

    created_time = sgqlc.types.Field(DateTime, graphql_name='createdTime')
    '''Time key was created'''

    created_by = sgqlc.types.Field('User', graphql_name='createdBy')
    '''Who created the key'''



class InternalNotifications(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('type', 'friendly_message', 'details', 'is_urgent', 'expiration_date')
    type = sgqlc.types.Field(String, graphql_name='type')
    '''Type of notification.'''

    friendly_message = sgqlc.types.Field(String, graphql_name='friendlyMessage')
    '''Human readable message.'''

    details = sgqlc.types.Field(JSONString, graphql_name='details')
    '''Raw information about the message (e.g. specifics).'''

    is_urgent = sgqlc.types.Field(Boolean, graphql_name='isUrgent')
    '''Whether to display a modal or badge.'''

    expiration_date = sgqlc.types.Field(DateTime, graphql_name='expirationDate')
    '''Reserved for future use (e.g. hiding old messages).'''



class InvestigationQuery(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query', 'has_error')
    query = sgqlc.types.Field(String, graphql_name='query')

    has_error = sgqlc.types.Field(Boolean, graphql_name='hasError')



class InviteUsersPayload(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('users', 'client_mutation_id')
    users = sgqlc.types.Field(sgqlc.types.list_of('UserInvite'), graphql_name='users')

    client_mutation_id = sgqlc.types.Field(String, graphql_name='clientMutationId')



class InviteUsersV2(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('invites', 'existing_users', 'already_invited')
    invites = sgqlc.types.Field(sgqlc.types.list_of('UserInvite'), graphql_name='invites')
    '''List of users invites sent'''

    existing_users = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='existingUsers')
    '''List of email addresses of users who already exist and cannot be
    invited
    '''

    already_invited = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='alreadyInvited')
    '''List of email addresses already invited to this account or another
    account
    '''



class JiraIntegrationOutput(sgqlc.types.Type):
    '''A Jira integration'''
    __schema__ = schema
    __field_names__ = ('integration_id', 'integration_name', 'server_url', 'username', 'default_ticket_fields', 'webhook_enabled', 'webhook_url', 'webhook_config')
    integration_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='integrationId')
    '''The integration ID'''

    integration_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='integrationName')
    '''A short name to identify the integration'''

    server_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='serverUrl')
    '''The domain name for your Jira site'''

    username = sgqlc.types.Field(String, graphql_name='username')
    '''The Jira username for basic authentication.'''

    default_ticket_fields = sgqlc.types.Field(JSONString, graphql_name='defaultTicketFields')
    '''Default values for ticket fields.'''

    webhook_enabled = sgqlc.types.Field(Boolean, graphql_name='webhookEnabled')
    '''Whether the Jira webhook is enabled'''

    webhook_url = sgqlc.types.Field(String, graphql_name='webhookUrl')
    '''The Jira webhook URL. Configure this as the target of your Jira
    Webhook.
    '''

    webhook_config = sgqlc.types.Field('JiraWebhookConfigOutput', graphql_name='webhookConfig')
    '''Webhook config'''



class JiraIssueTypeFieldOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('key', 'name', 'required', 'has_default_value', 'has_default_value_in_jira', 'type')
    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='key')
    '''The field key'''

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''The field name'''

    required = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='required')
    '''If the field is required to create the issue'''

    has_default_value = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasDefaultValue')
    '''If the field has a default value when not set, considering
    integration level default values configured on Monte Carlo
    '''

    has_default_value_in_jira = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasDefaultValueInJira')
    '''If the field has a default value in Jira when not set'''

    type = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='type')
    '''The field type'''



class JiraIssueTypeOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'name', 'untranslated_name', 'fields')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')
    '''The issue type ID'''

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''The issue type name'''

    untranslated_name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='untranslatedName')
    '''The issue type untranslated name'''

    fields = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(JiraIssueTypeFieldOutput)), graphql_name='fields')
    '''The issue type fields'''



class JiraProjectOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'key', 'name')
    id = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='id')
    '''The project ID'''

    key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='key')
    '''The project key'''

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''The project name'''



class JiraStatusMappingOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('incident_feedback', 'jira_status')
    incident_feedback = sgqlc.types.Field(String, graphql_name='incidentFeedback')
    '''The feedback that will be set on the Monte Carlo incident if the
    Jira ticket is set to any of the provided Jira statuses
    '''

    jira_status = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='jiraStatus')
    '''The Jira statuses that will map to the Monte Carlo incident
    feedback
    '''



class JiraStatusOutput(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'name')
    id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='id')
    '''The status ID'''

    name = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='name')
    '''The status name'''



class JiraTestCredentialsOutput(sgqlc.types.Type):
    '''A Jira test credentials result'''
    __schema__ = schema
    __field_names__ = ('valid_credentials',)
    valid_credentials = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='validCredentials')
    '''Returns if the credentials are valid'''



class JiraTicketDetailsOutput(sgqlc.types.Type):
    '''Ticket details stored at Jira'''
    __schema__ = schema
    __field_names__ = ('assignee', 'status')
    assignee = sgqlc.types.Field('JiraUserOutput', graphql_name='assignee')
    '''The user assigned to the ticket'''

    status = sgqlc.types.Field('JiraTicketStatusOutput', graphql_name='status')
    '''The ticket status'''



class JiraTicketOutput(sgqlc.types.Type):
    '''A Jira ticket'''
    __schema__ = schema
    __field_names__ = ('ticket_id', 'ticket_url', 'ticket_key', 'incident_id', 'integration_id', 'created_by', 'created_at', 'details')
    ticket_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='ticketId')
    '''The ticket ID in Monte Carlo'''

    ticket_url = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='ticketUrl')
    '''The ticket URL'''

    ticket_key = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='ticketKey')
    '''The ticket key'''

    incident_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='incidentId')
    '''The incident ID'''

    integration_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='integrationId')
    '''The integration ID'''

    created_by = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='createdBy')
    '''Email of the user that created the ticket'''

    created_at = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdAt')
    '''When the ticket was created'''

    details = sgqlc.types.Field(JiraTicketDetailsOutput, graphql_name='details')
    '''Ticket details stored at Jira'''



class JiraTicketStatusOutput(sgqlc.types.Type):
    '''A JIRA ticket status'''
    __schema__ = schema
    __field_names__ = ('name', 'description')
    name = sgqlc.types.Field(String, graphql_name='name')
    '''A short descriptive name for the status'''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''A more detailed description of the status'''



class JiraUserOutput(sgqlc.types.Type):
    '''A JIRA user details'''
    __schema__ = schema
    __field_names__ = ('avatar_url', 'display_name', 'email_address')
    avatar_url = sgqlc.types.Field(String, graphql_name='avatarUrl')
    '''The user 24x24 avatar URL'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''The user display name'''

    email_address = sgqlc.types.Field(String, graphql_name='emailAddress')
    '''The user email'''



class JiraWebhookConfigOutput(sgqlc.types.Type):
    '''Jira webhook config'''
    __schema__ = schema
    __field_names__ = ('status_mappings',)
    status_mappings = sgqlc.types.Field(sgqlc.types.list_of(JiraStatusMappingOutput), graphql_name='statusMappings')
    '''Status mapping'''



class JobError(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('message', 'job_execution_uuid', 'dc_schedule_uuid', 'timestamp', 'result_count', 'job_type', 'stack_name', 'data_collector_uuid')
    message = sgqlc.types.Field(String, graphql_name='message')
    '''The error message'''

    job_execution_uuid = sgqlc.types.Field(UUID, graphql_name='jobExecutionUuid')
    '''The Job Execution ID'''

    dc_schedule_uuid = sgqlc.types.Field(UUID, graphql_name='dcScheduleUuid')
    '''The data collector schedule UUID'''

    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')
    '''The timestamp of the error'''

    result_count = sgqlc.types.Field(Int, graphql_name='resultCount')
    '''The number of results returned'''

    job_type = sgqlc.types.Field(String, graphql_name='jobType')
    '''The type of job that failed'''

    stack_name = sgqlc.types.Field(String, graphql_name='stackName')
    '''The name of the stack for the data collector'''

    data_collector_uuid = sgqlc.types.Field(UUID, graphql_name='dataCollectorUuid')
    '''The data collector uuid'''



class JobExecutionException(sgqlc.types.Type):
    '''Job execution exception details'''
    __schema__ = schema
    __field_names__ = ('type', 'description', 'sql_query')
    type = sgqlc.types.Field(String, graphql_name='type')
    '''Exception type'''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''Exception description'''

    sql_query = sgqlc.types.Field(String, graphql_name='sqlQuery')
    '''SQL query execution that triggered the exception'''



class JobExecutionHistoryLog(sgqlc.types.Type):
    '''Job history log entry'''
    __schema__ = schema
    __field_names__ = ('job_execution_uuid', 'start_time', 'status', 'end_time', 'exceptions', 'exceptions_detail')
    job_execution_uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='jobExecutionUuid')
    '''UUID of job execution'''

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''When the job was scheduled'''

    status = sgqlc.types.Field(JobExecutionStatus, graphql_name='status')

    end_time = sgqlc.types.Field(DateTime, graphql_name='endTime')
    '''When the job was completed'''

    exceptions = sgqlc.types.Field(String, graphql_name='exceptions')
    '''Exceptions that were captured during this job execution (pre-
    formatted)
    '''

    exceptions_detail = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(JobExecutionException)), graphql_name='exceptionsDetail')
    '''Exceptions that were captured during this job execution'''



class JobInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('dbt_job_info',)
    dbt_job_info = sgqlc.types.Field(DbtJobInfo, graphql_name='dbtJobInfo')



class LabelCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('label', 'count')
    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    '''The label value'''

    count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='count')
    '''The count for the label'''



class LastSizeChange(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('timestamp', 'size')
    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')
    '''Timestamp when the last size change occurred'''

    size = sgqlc.types.Field(Float, graphql_name='size')
    '''Table size after the last size change occurred'''



class LastUpdates(sgqlc.types.Type):
    '''this class will be used to hold new last updates v2 results. The
    time_interval_in_sec would indicate the time bucket interval used
    for integration. For direct query result, time_interval_in_sec
    field will be set to 0
    '''
    __schema__ = schema
    __field_names__ = ('last_updates', 'time_interval_in_sec')
    last_updates = sgqlc.types.Field(sgqlc.types.list_of('TableUpdateTime'), graphql_name='lastUpdates')

    time_interval_in_sec = sgqlc.types.Field(Int, graphql_name='timeIntervalInSec')



class LineageAirflowJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('dag_id', 'task_id', 'display_name')
    dag_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='dagId')
    '''Airflow DAG Id'''

    task_id = sgqlc.types.Field(String, graphql_name='taskId')
    '''Airflow Task Id'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''Airflow DAG Name'''



class LineageDatabricksJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('job_id', 'task_id', 'display_name')
    job_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='jobId')
    '''Databricks Job Id'''

    task_id = sgqlc.types.Field(String, graphql_name='taskId')
    '''Databricks task Id'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''Databricks Job Name'''



class LineageEdgeJob(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('job_type', 'job_attributes')
    job_type = sgqlc.types.Field(sgqlc.types.non_null(LineageNodeJobType), graphql_name='jobType')
    '''Job type, only supported values are AIRFLOW and DATABRICKS'''

    job_attributes = sgqlc.types.Field(sgqlc.types.non_null('LineageJobAttributes'), graphql_name='jobAttributes')



class LineageGraph(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('base_node', 'base_nodes', 'connected_nodes', 'flattened_edges')
    base_node = sgqlc.types.Field('LineageGraphNode', graphql_name='baseNode')
    '''This is the base node for which lineage is fetched. If there are
    multiples nodes requested this is the first one.
    '''

    base_nodes = sgqlc.types.Field(sgqlc.types.list_of('LineageGraphNode'), graphql_name='baseNodes')
    '''These are the base nodes for which lineages are fetched'''

    connected_nodes = sgqlc.types.Field(sgqlc.types.list_of('LineageGraphNode'), graphql_name='connectedNodes')
    '''List of nodes connected to the base node. This could be nodes that
    are multiple hops away from the base node in the graph in cases
    where nodes at multiple hops were queried.
    '''

    flattened_edges = sgqlc.types.Field(sgqlc.types.list_of(FlattenedLineageGraphEdges), graphql_name='flattenedEdges')
    '''Each entry is an mcon and a list of mcons it is directly connected
    to
    '''



class LineageGraphEdge(sgqlc.types.Type):
    '''A lineage graph edge'''
    __schema__ = schema
    __field_names__ = ('source', 'destination', 'job_ts', 'expire_at', 'is_custom')
    source = sgqlc.types.Field('LineageGraphNode', graphql_name='source')
    '''The source node'''

    destination = sgqlc.types.Field('LineageGraphNode', graphql_name='destination')
    '''The destination node'''

    job_ts = sgqlc.types.Field(DateTime, graphql_name='jobTs')
    '''The timestamp of the job run or API call that created this edge'''

    expire_at = sgqlc.types.Field(DateTime, graphql_name='expireAt')
    '''The timestamp when this edge will expire'''

    is_custom = sgqlc.types.Field(Boolean, graphql_name='isCustom')
    '''Indicates whether this is a custom lineage edge (created by a
    user)
    '''



class LineageGraphEdgeNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'jobs')
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''Target MCON of this edge'''

    jobs = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(LineageEdgeJob)), graphql_name='jobs')
    '''Jobs associated to this edge'''



class LineageGraphJobData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'job_type', 'job_name', 'sub_job_type', 'sub_job_name')
    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''MCON modified by the job'''

    job_type = sgqlc.types.Field(String, graphql_name='jobType')
    '''Currently only AIRFLOW and DATABRICKS supported'''

    job_name = sgqlc.types.Field(String, graphql_name='jobName')
    '''The name of the Airflow DAG or Databricks Job'''

    sub_job_type = sgqlc.types.Field(String, graphql_name='subJobType')
    '''The type of the Airflow or Databricks task, i.e. task'''

    sub_job_name = sgqlc.types.Field(String, graphql_name='subJobName')
    '''The name of the Airflow or Databricks task'''



class LineageGraphNode(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'display_name', 'has_downstream_nodes', 'has_upstream_nodes', 'object_type', 'is_custom', 'job_ts', 'expire_at', 'jobs')
    mcon = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='mcon')
    '''Monte Carlo full identifier for an entity'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''Friendly name for entity'''

    has_downstream_nodes = sgqlc.types.Field(Boolean, graphql_name='hasDownstreamNodes')
    '''Indicates whether this node has downstream nodes'''

    has_upstream_nodes = sgqlc.types.Field(Boolean, graphql_name='hasUpstreamNodes')
    '''Indicates whether this node has upstream nodes'''

    object_type = sgqlc.types.Field(String, graphql_name='objectType')
    '''Type of the object that this lineage node denotes'''

    is_custom = sgqlc.types.Field(Boolean, graphql_name='isCustom')
    '''Indicates whether this is a custom lineage node (created by a
    user)
    '''

    job_ts = sgqlc.types.Field(DateTime, graphql_name='jobTs')
    '''The timestamp of the job run or API call that created this node'''

    expire_at = sgqlc.types.Field(DateTime, graphql_name='expireAt')
    '''The timestamp when this node will expire'''

    jobs = sgqlc.types.Field(sgqlc.types.list_of('LineageNodeJob'), graphql_name='jobs')
    '''List of jobs'''



class LineageKafkaConnectorJobAttributes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('job_id', 'display_name', 'external_origin_id', 'external_cluster_id')
    job_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='jobId')
    '''Kafka Connector ID'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''kafka Connector display name'''

    external_origin_id = sgqlc.types.Field(String, graphql_name='externalOriginId')
    '''External unique identifier of the job'''

    external_cluster_id = sgqlc.types.Field(String, graphql_name='externalClusterId')
    '''Cluster the connector runs in'''



class LineageNodeBlockPattern(sgqlc.types.Type):
    '''A pattern defining nodes to be blocked from lineage'''
    __schema__ = schema
    __field_names__ = ('id', 'uuid', 'account_id', 'resource_id', 'dataset_regexp', 'project_regexp', 'table_regexp', 'created_time', 'last_update_user', 'last_update_time')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Pattern UUID'''

    account_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='accountId')
    '''Customer account id'''

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceId')
    '''Resource containing the node'''

    dataset_regexp = sgqlc.types.Field(String, graphql_name='datasetRegexp')
    '''Block nodes with dataset id matching this regexp'''

    project_regexp = sgqlc.types.Field(String, graphql_name='projectRegexp')
    '''Block nodes with project id matching this regexp'''

    table_regexp = sgqlc.types.Field(String, graphql_name='tableRegexp')
    '''Block nodes with table id matching this regexp'''

    created_time = sgqlc.types.Field(DateTime, graphql_name='createdTime')
    '''When the regexp was first created'''

    last_update_user = sgqlc.types.Field('User', graphql_name='lastUpdateUser')
    '''Who last updated the regexp'''

    last_update_time = sgqlc.types.Field(DateTime, graphql_name='lastUpdateTime')
    '''When the regexp was last updated'''



class LineageNodeCollapsingRule(sgqlc.types.Type):
    '''A pattern matching lineage nodes that should be collapsed'''
    __schema__ = schema
    __field_names__ = ('created_time', 'updated_time', 'created_by', 'last_update_user', 'uuid', 'account_id', 'pattern', 'case_insensitive')
    created_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='createdTime')

    updated_time = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='updatedTime')

    created_by = sgqlc.types.Field('User', graphql_name='createdBy')
    '''Creator of the template'''

    last_update_user = sgqlc.types.Field('User', graphql_name='lastUpdateUser')
    '''Template Last updated by'''

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Collapsing pattern UUID'''

    account_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='accountId')
    '''Customer account id'''

    pattern = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='pattern')
    '''Pattern to match collapsible nodes global id'''

    case_insensitive = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='caseInsensitive')
    '''Case sensitivity of the pattern matching'''



class LineageNodeJob(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('job_type', 'job_attributes', 'direction')
    job_type = sgqlc.types.Field(sgqlc.types.non_null(LineageNodeJobType), graphql_name='jobType')
    '''Job type, only supported values are AIRFLOW and DATABRICKS'''

    job_attributes = sgqlc.types.Field(sgqlc.types.non_null('LineageJobAttributes'), graphql_name='jobAttributes')

    direction = sgqlc.types.Field(sgqlc.types.non_null(LineageNodeJobDirectionType), graphql_name='direction')
    '''Direction, one of source or dest'''



class LineageNodeReplacementRule(sgqlc.types.Type):
    '''A replacement pattern modifying lineage node's canonical name'''
    __schema__ = schema
    __field_names__ = ('id', 'uuid', 'account_id', 'resource_id', 'pattern', 'replacement', 'case_insensitive', 'last_update_user', 'last_update_time')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Replacement rule UUID'''

    account_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='accountId')
    '''Customer account id'''

    resource_id = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='resourceId')
    '''Resource containing the node'''

    pattern = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='pattern')
    '''Modify canonical name by replacing the pattern with replacement'''

    replacement = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='replacement')
    '''Modify canonical name by replacing the pattern with replacement'''

    case_insensitive = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='caseInsensitive')
    '''Case sensitivity of the pattern matching'''

    last_update_user = sgqlc.types.Field('User', graphql_name='lastUpdateUser')
    '''Who last updated the replacement rule'''

    last_update_time = sgqlc.types.Field(DateTime, graphql_name='lastUpdateTime')
    '''When the replacement rule was last updated'''



class LineageNodeReplacementRuleResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('test_input_string', 'replaced_string')
    test_input_string = sgqlc.types.Field(String, graphql_name='testInputString')
    '''The provided test input string'''

    replaced_string = sgqlc.types.Field(String, graphql_name='replacedString')
    '''The replaced string, using provided pattern/replacement'''



class LineageSources(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'source_columns')
    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''Mcon of the source table'''

    source_columns = sgqlc.types.Field(sgqlc.types.list_of('SourceColumn'), graphql_name='sourceColumns')
    '''Source columns from this source table'''



class LinkGithubAppInstallation(sgqlc.types.Type):
    '''Called from the FE as part of the post-installation callback. The
    "code" parameter is used to validate that the request is an
    authentic Github callback and authenticates the user on the Github
    side.
    '''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''True if linking the installation was successful'''



class LinkJiraTicketForIncident(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('jira_ticket',)
    jira_ticket = sgqlc.types.Field(JiraTicketOutput, graphql_name='jiraTicket')
    '''The created Jira ticket'''



class ListDatasetsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('datasets', 'next_page_token')
    datasets = sgqlc.types.Field(sgqlc.types.list_of(DatasetEntity), graphql_name='datasets')
    '''List of dataset IDs'''

    next_page_token = sgqlc.types.Field(String, graphql_name='nextPageToken')
    '''Page token for the next page'''



class ListProjectsResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('projects', 'next_page_token')
    projects = sgqlc.types.Field(sgqlc.types.list_of('ProjectEntity'), graphql_name='projects')
    '''List of project IDs'''

    next_page_token = sgqlc.types.Field(String, graphql_name='nextPageToken')
    '''Page token for the next page'''



class LookerDashboardTileRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('tile_id', 'tile_title')
    tile_id = sgqlc.types.Field(String, graphql_name='tileId')

    tile_title = sgqlc.types.Field(String, graphql_name='tileTitle')



class MaintenanceWindow(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('start_time', 'end_time')
    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''Start of maintenance window'''

    end_time = sgqlc.types.Field(DateTime, graphql_name='endTime')
    '''End of maintenance window'''



class ManyToManyChange(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('operation', 'object_names')
    operation = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='operation')
    '''add/delete'''

    object_names = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='objectNames')
    '''Related objects'''



class MatchAndCreateBiWarehouseSources(sgqlc.types.Type):
    '''Create or update a BI warehouse source. If BI warehouse source
    details are provided in thebi_warehouse_sources parameter then
    those are saved. Else, details are pulled from the BIAPIs, matched
    with warehouses in Monte Carlo and details saved only if there is
    a full match.
    '''
    __schema__ = schema
    __field_names__ = ('matching_bi_warehouse_sources',)
    matching_bi_warehouse_sources = sgqlc.types.Field('MatchingBiWarehouseSources', graphql_name='matchingBiWarehouseSources')



class MatchingBiWarehouseSources(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('match_successful', 'bi_warehouse_sources', 'raw_bi_warehouse_connections', 'raw_warehouse_connections')
    match_successful = sgqlc.types.Field(Boolean, graphql_name='matchSuccessful')
    '''Indicates whether all BI source warehouses could be matched with a
    warehouse stored in MC. Only true if all BI source warehouses
    could be matched.
    '''

    bi_warehouse_sources = sgqlc.types.Field(sgqlc.types.list_of(BiWarehouseSources), graphql_name='biWarehouseSources')
    '''Details of matched warehouses.'''

    raw_bi_warehouse_connections = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='rawBiWarehouseConnections')
    '''Raw response from customer's BI system listing the warehouses it
    is connected to. Only set if match_successful is False.
    '''

    raw_warehouse_connections = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='rawWarehouseConnections')
    '''Details of warehouses that are in MC. Only set if match_successful
    is False.
    '''



class MetricAggregationOutputType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metric', 'aggregation')
    metric = sgqlc.types.Field(String, graphql_name='metric')
    '''Query performance metric'''

    aggregation = sgqlc.types.Field(String, graphql_name='aggregation')
    '''Metric aggregation function'''



class MetricAnomalyCorrelation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field', 'metric', 'correlations')
    field = sgqlc.types.Field(String, graphql_name='field')

    metric = sgqlc.types.Field(String, graphql_name='metric')

    correlations = sgqlc.types.Field(sgqlc.types.list_of(FieldValueCorrelation), graphql_name='correlations')



class MetricAnomalyCorrelationV2(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field', 'metric', 'data', 'has_strong_correlations')
    field = sgqlc.types.Field(String, graphql_name='field')

    metric = sgqlc.types.Field(String, graphql_name='metric')

    data = sgqlc.types.Field(sgqlc.types.list_of(FieldValueCorrelation), graphql_name='data')

    has_strong_correlations = sgqlc.types.Field(Boolean, graphql_name='hasStrongCorrelations')



class MetricCorrelationResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metric_anomalies', 'metric_anomalies_v2')
    metric_anomalies = sgqlc.types.Field(sgqlc.types.list_of(MetricAnomalyCorrelation), graphql_name='metricAnomalies')

    metric_anomalies_v2 = sgqlc.types.Field(sgqlc.types.list_of(MetricAnomalyCorrelationV2), graphql_name='metricAnomaliesV2')



class MetricDimensions(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('rank', 'label', 'sequence_number')
    rank = sgqlc.types.Field(Float, graphql_name='rank')

    label = sgqlc.types.Field(String, graphql_name='label')

    sequence_number = sgqlc.types.Field(Int, graphql_name='sequenceNumber')



class MetricMonitorSelectExpression(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('id', 'metric_monitor', 'expression', 'data_type', 'is_raw_column_name')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    metric_monitor = sgqlc.types.Field(sgqlc.types.non_null('MetricMonitoring'), graphql_name='metricMonitor')

    expression = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='expression')

    data_type = sgqlc.types.Field(MetricMonitorSelectExpressionModelDataType, graphql_name='dataType')

    is_raw_column_name = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isRawColumnName')



class MetricMonitoringConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('MetricMonitoringEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class MetricMonitoringEdge(sgqlc.types.Type):
    '''A Relay edge containing a `MetricMonitoring` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('MetricMonitoring', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class MetricSampling(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('columns', 'rows', 'query', 'has_error')
    columns = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='columns')

    rows = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.list_of(String)), graphql_name='rows')

    query = sgqlc.types.Field(String, graphql_name='query')

    has_error = sgqlc.types.Field(Boolean, graphql_name='hasError')



class MetricValueByTable(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('value', 'full_table_id', 'resource_id')
    value = sgqlc.types.Field(DateTime, graphql_name='value')

    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')

    resource_id = sgqlc.types.Field(String, graphql_name='resourceId')



class Metrics(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metrics', 'is_partial_date_range')
    metrics = sgqlc.types.Field(sgqlc.types.list_of('TableMetricV2'), graphql_name='metrics')

    is_partial_date_range = sgqlc.types.Field(Boolean, graphql_name='isPartialDateRange')



class MigrateCollectorResources(sgqlc.types.Type):
    '''Migrate resources (warehouses, BI) from one data collector to
    another
    '''
    __schema__ = schema
    __field_names__ = ('success',)
    success = sgqlc.types.Field(Boolean, graphql_name='success')
    '''If the migration was successful'''



class MigrateToNotificationsV2(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('warnings', 'text_log', 'created_audiences', 'updated_monitors')
    warnings = sgqlc.types.Field(sgqlc.types.list_of('MigrationWarning'), graphql_name='warnings')

    text_log = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='textLog')

    created_audiences = sgqlc.types.Field(sgqlc.types.list_of('MigrationAudience'), graphql_name='createdAudiences')

    updated_monitors = sgqlc.types.Field(sgqlc.types.list_of('MigrationMonitor'), graphql_name='updatedMonitors')



class MigrationAudience(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('label',)
    label = sgqlc.types.Field(String, graphql_name='label')



class MigrationMonitor(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('uuid',)
    uuid = sgqlc.types.Field(UUID, graphql_name='uuid')



class MigrationWarning(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('code', 'description', 'notification_setting_uuid', 'extra')
    code = sgqlc.types.Field(MigrationWarningType, graphql_name='code')

    description = sgqlc.types.Field(String, graphql_name='description')

    notification_setting_uuid = sgqlc.types.Field(UUID, graphql_name='notificationSettingUuid')

    extra = sgqlc.types.Field(JSONString, graphql_name='extra')



class MonitorConfiguration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('time_field', 'aggregation_type', 'lookback_days')
    time_field = sgqlc.types.Field(String, graphql_name='timeField')
    '''Time field to use for the monitor'''

    aggregation_type = sgqlc.types.Field(MonitorAggTimeInterval, graphql_name='aggregationType')
    '''Day or Hour'''

    lookback_days = sgqlc.types.Field(Int, graphql_name='lookbackDays')
    '''The history days for the monitor'''



class MonitorDashboardData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('total_monitor_count', 'paused_count', 'snoozed_count', 'active_count', 'training_count', 'misconfigured_count', 'error_count', 'in_progress_count', 'no_status_count')
    total_monitor_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='totalMonitorCount')
    '''Total count of monitors actively in MC account'''

    paused_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='pausedCount')
    '''Total number of paused monitors'''

    snoozed_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='snoozedCount')
    '''Total number of snoozed monitors'''

    active_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='activeCount')
    '''Total count of monitors with active status'''

    training_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='trainingCount')
    '''Total count of monitors with training status'''

    misconfigured_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='misconfiguredCount')
    '''Total count of monitors with misconfigured status'''

    error_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='errorCount')
    '''Total count of monitors with error status'''

    in_progress_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='inProgressCount')
    '''Total number of monitors currently running'''

    no_status_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='noStatusCount')
    '''Total number of monitors with state no status'''



class MonitorDetail(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('monitor_uuid', 'metric_name', 'metric_display_name', 'incident_uuids')
    monitor_uuid = sgqlc.types.Field(UUID, graphql_name='monitorUuid')
    '''UUID of the monitor. This is not set for OOTB monitors.'''

    metric_name = sgqlc.types.Field(String, graphql_name='metricName')
    '''Name of the metric monitored by this monitor.'''

    metric_display_name = sgqlc.types.Field(String, graphql_name='metricDisplayName')
    '''Display name of the metric.'''

    incident_uuids = sgqlc.types.Field(sgqlc.types.list_of(UUID), graphql_name='incidentUuids')
    '''UUIDs of incidents for this monitor, within the time range
    specified in the request.
    '''



class MonitorLabel(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('label',)
    label = sgqlc.types.Field(String, graphql_name='label')
    '''The monitor label name'''



class MonitorLabelObject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('uuid', 'label', 'created_by', 'monitors', 'monitor_count', 'notification_count', 'used_in_mac')
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Unique identifier of a monitor label'''

    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    '''Monitor label name'''

    created_by = sgqlc.types.Field('User', graphql_name='createdBy')
    '''Monitor label creator'''

    monitors = sgqlc.types.Field(sgqlc.types.list_of('Monitor'), graphql_name='monitors', args=sgqlc.types.ArgDict((
        ('monitor_types', sgqlc.types.Arg(sgqlc.types.list_of(UserDefinedMonitors), graphql_name='monitorTypes', default=None)),
        ('status_types', sgqlc.types.Arg(sgqlc.types.list_of(MonitorStatusType), graphql_name='statusTypes', default=None)),
        ('description_field_or_table', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='descriptionFieldOrTable', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('uuids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='uuids', default=None)),
        ('created_by_filters', sgqlc.types.Arg(CreatedByFilters, graphql_name='createdByFilters', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('search', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='search', default=None)),
        ('search_fields', sgqlc.types.Arg(sgqlc.types.list_of(UserDefinedMonitorSearchFields), graphql_name='searchFields', default=None)),
        ('namespaces', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='namespaces', default=None)),
        ('is_template_managed', sgqlc.types.Arg(Boolean, graphql_name='isTemplateManaged', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
))
    )
    '''List of monitors using this label

    Arguments:

    * `monitor_types` (`[UserDefinedMonitors]`): Type of monitors to
      filter by, default all
    * `status_types` (`[MonitorStatusType]`): Type of monitor status
      to filter by, default all
    * `description_field_or_table` (`[String]`): DEPRECATED
    * `domain_id` (`UUID`): Domain uuid to filter by
    * `uuids` (`[String]`): list of uuids of the monitors to filter by
    * `created_by_filters` (`CreatedByFilters`): Deprecated
    * `labels` (`[String]`): List of labels to filter by
    * `search` (`[String]`): Search criteria for filtering the
      monitors list
    * `search_fields` (`[UserDefinedMonitorSearchFields]`): Which
      fields to include during search
    * `namespaces` (`[String]`): filter by namespaces
    * `is_template_managed` (`Boolean`): Filter monitors created by
      code
    * `mcons` (`[String]`): Filter by associated entities (MCON)
    * `order_by` (`String`): Field and direction to order monitors by
    * `limit` (`Int`): Number of monitors to return
    * `offset` (`Int`): From which monitor to return the next results
    '''

    monitor_count = sgqlc.types.Field(Int, graphql_name='monitorCount')
    '''The number of monitors using this label'''

    notification_count = sgqlc.types.Field(Int, graphql_name='notificationCount')
    '''The number of notifications using this label'''

    used_in_mac = sgqlc.types.Field(Boolean, graphql_name='usedInMac')
    '''Flag for whether any MaC monitors use this label'''



class MonitorQueries(sgqlc.types.Type):
    '''A monitor query'''
    __schema__ = schema
    __field_names__ = ('queries',)
    queries = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='queries')
    '''The SQL queries executed by the monitor'''



class MonitorQueriesResults(sgqlc.types.Type):
    '''Result of executing a monitor query for test purposes'''
    __schema__ = schema
    __field_names__ = ('queries',)
    queries = sgqlc.types.Field(sgqlc.types.list_of('SQLResponse'), graphql_name='queries')
    '''The SQL queries results'''



class MonitorSchedulingConfiguration(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('schedule_type', 'interval_minutes', 'start_time')
    schedule_type = sgqlc.types.Field(String, graphql_name='scheduleType')
    '''One of fixed/dynamic or None if cannot decide automatically'''

    interval_minutes = sgqlc.types.Field(Int, graphql_name='intervalMinutes')
    '''Number of minutes between monitor runs is schedule type is fixed'''

    start_time = sgqlc.types.Field(DateTime, graphql_name='startTime')
    '''Date to start the monitor if schedule type is fixed'''



class MonitorSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('resources', 'stats', 'categories', 'hourly_stats', 'json_schema', 'custom_sql', 'table_metric')
    resources = sgqlc.types.Field('TableResources', graphql_name='resources')

    stats = sgqlc.types.Field(Int, graphql_name='stats')

    categories = sgqlc.types.Field(Int, graphql_name='categories')

    hourly_stats = sgqlc.types.Field(Int, graphql_name='hourlyStats')
    '''Hourly stats monitors (DEPRECATED)'''

    json_schema = sgqlc.types.Field(Int, graphql_name='jsonSchema')

    custom_sql = sgqlc.types.Field(Int, graphql_name='customSql')

    table_metric = sgqlc.types.Field(Int, graphql_name='tableMetric')



class MonitoredTableRuleObject(sgqlc.types.Type):
    '''Rule for deciding which tables are monitored'''
    __schema__ = schema
    __field_names__ = ('id', 'dataset', 'is_exclude', 'table_rule_text', 'project', 'rule_type')
    id = sgqlc.types.Field(sgqlc.types.non_null(ID), graphql_name='id')

    dataset = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='dataset')
    '''Schema/Dataset where rule applies'''

    is_exclude = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isExclude')
    '''Is this an exclude rule?'''

    table_rule_text = sgqlc.types.Field(String, graphql_name='tableRuleText')
    '''Text used to match against table name'''

    project = sgqlc.types.Field(String, graphql_name='project')
    '''Project/database scope of the rule'''

    rule_type = sgqlc.types.Field(MonitoredTableRuleType, graphql_name='ruleType')
    '''Type of rule'''



class MonteCarloConfigTemplateConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('MonteCarloConfigTemplateEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class MonteCarloConfigTemplateDeleteResponse(sgqlc.types.Type):
    '''Monte Carlo Config Template Delete Response'''
    __schema__ = schema
    __field_names__ = ('num_deleted', 'changes_applied')
    num_deleted = sgqlc.types.Field(Int, graphql_name='numDeleted')
    '''Number of resources deleted'''

    changes_applied = sgqlc.types.Field(Boolean, graphql_name='changesApplied')
    '''Changes applied?'''



class MonteCarloConfigTemplateEdge(sgqlc.types.Type):
    '''A Relay edge containing a `MonteCarloConfigTemplate` and its
    cursor.
    '''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('MonteCarloConfigTemplate', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class MonteCarloConfigTemplateExportResponse(sgqlc.types.Type):
    '''Monte Carlo Config Template Export Response'''
    __schema__ = schema
    __field_names__ = ('config_template_as_yaml', 'errors')
    config_template_as_yaml = sgqlc.types.Field(String, graphql_name='configTemplateAsYaml')
    '''Config Template as YAML'''

    errors = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='errors')
    '''Errors encountered'''



class MonteCarloConfigTemplateUpdateAsyncResponse(sgqlc.types.Type):
    '''Monte Carlo Config Template Update Async Response'''
    __schema__ = schema
    __field_names__ = ('update_uuid', 'errors_as_json')
    update_uuid = sgqlc.types.Field(UUID, graphql_name='updateUuid')
    '''The UUID of the requested update. Used to poll for the status of
    the update. Null if the update request is invalid.
    '''

    errors_as_json = sgqlc.types.Field(String, graphql_name='errorsAsJson')
    '''Errors encountered'''



class MonteCarloConfigTemplateUpdateAsyncState(sgqlc.types.Type):
    '''Monte Carlo Config Template Update Async State'''
    __schema__ = schema
    __field_names__ = ('resource_modifications', 'changes_applied', 'errors_as_json', 'warnings_as_json', 'info_as_json', 'state')
    resource_modifications = sgqlc.types.Field(sgqlc.types.list_of('ResourceModification'), graphql_name='resourceModifications')
    '''List of resource modifications'''

    changes_applied = sgqlc.types.Field(Boolean, graphql_name='changesApplied')
    '''Changes applied?'''

    errors_as_json = sgqlc.types.Field(String, graphql_name='errorsAsJson')
    '''Errors encountered'''

    warnings_as_json = sgqlc.types.Field(String, graphql_name='warningsAsJson')
    '''Warnings encountered'''

    info_as_json = sgqlc.types.Field(String, graphql_name='infoAsJson')
    '''Informational messages'''

    state = sgqlc.types.Field(sgqlc.types.non_null(State), graphql_name='state')
    '''State of the async update'''



class MonteCarloConfigTemplateUpdateResponse(sgqlc.types.Type):
    '''Monte Carlo Config Template Update Response'''
    __schema__ = schema
    __field_names__ = ('resource_modifications', 'changes_applied', 'errors_as_json', 'warnings_as_json', 'info_as_json')
    resource_modifications = sgqlc.types.Field(sgqlc.types.list_of('ResourceModification'), graphql_name='resourceModifications')
    '''List of resource modifications'''

    changes_applied = sgqlc.types.Field(Boolean, graphql_name='changesApplied')
    '''Changes applied?'''

    errors_as_json = sgqlc.types.Field(String, graphql_name='errorsAsJson')
    '''Errors encountered'''

    warnings_as_json = sgqlc.types.Field(String, graphql_name='warningsAsJson')
    '''Warnings encountered'''

    info_as_json = sgqlc.types.Field(String, graphql_name='infoAsJson')
    '''Informational messages'''



class Mutation(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('create_or_update_data_explorer_dashboard', 'delete_data_explorer_dashboard', 'create_or_update_data_explorer_comparison_dashboard', 'delete_data_explorer_comparison_dashboard', 'create_webex_integration', 'update_webex_integration', 'delete_webex_integration', 'update_monitored_table_rule_list', 'toggle_performance_dashboard_for_domain_restricted_users', 'create_or_update_agent', 'delete_agent', 'upgrade_agent', 'create_tableau_asset_warning', 'update_tableau_asset_warning', 'generate_dc_upgrade_template', 'delete_data_product', 'create_or_update_data_product', 'update_data_product_sharing', 'link_github_app_installation', 'register_github_app_installation_request', 'update_github_installation', 'delete_github_installation', 'test_confluent_kafka_credentials', 'test_confluent_kafka_connect_credentials', 'add_streaming_system', 'add_streaming_connection', 'delete_streaming_system', 'delete_streaming_cluster', 'update_streaming_system_name', 'update_streaming_cluster_name', 'toggle_size_collection', 'create_servicenow_integration', 'update_servicenow_integration', 'delete_servicenow_integration', 'create_jira_integration', 'update_jira_integration', 'delete_jira_integration', 'create_jira_ticket_for_incident', 'link_jira_ticket_for_incident', 'unlink_jira_ticket_for_incident', 'create_or_update_audience', 'create_or_update_audience_notification_setting', 'delete_audience_notification_setting', 'create_or_update_audience_routing_rule', 'delete_audience_routing_rule', 'migrate_to_notifications_v2', 'create_or_update_notification_setting', 'create_or_update_recipient_name', 'delete_notification_settings', 'delete_recipient_name', 'set_pii_filter_status', 'update_pii_filtering_preferences', 'update_monitor_name', 'update_monitor_notes', 'update_monitor_labels', 'create_custom_user', 'create_unified_user_assignment', 'delete_unified_user_assignment', 'send_dbt_artifacts_event', 'set_group_repetitive_dbt_model_failures', 'set_group_repetitive_dbt_test_failures', 'set_generates_incidents', 'set_job_generates_incidents', 'snooze_dbt_node', 'unsnooze_dbt_node', 'update_dbt_project_info', 'create_or_update_monte_carlo_config_template', 'create_or_update_monte_carlo_config_template_async', 'delete_monte_carlo_config_template', 'convert_ui_monitors_to_config_template', 'convert_config_template_to_ui_monitors', 'set_sensitivity', 'add_to_collection_block_list', 'remove_from_collection_block_list', 'modify_collection_block_list', 'create_custom_rule', 'create_or_update_custom_rule', 'create_or_update_volume_rule', 'create_custom_metric_rule', 'create_or_update_custom_metric_rule', 'create_or_update_comparison_rule', 'create_or_update_query_perf_rule', 'update_custom_metric_rule_notes', 'update_custom_metric_severity', 'create_or_update_freshness_custom_rule', 'snooze_custom_rule', 'unsnooze_custom_rule', 'delete_custom_rule', 'trigger_custom_rule', 'trigger_circuit_breaker_rule', 'trigger_circuit_breaker_rule_v2', 'run_sql_rule', 'pause_rule', 'update_custom_rule_investigation_query', 'create_or_update_lineage_node', 'create_or_update_lineage_edge', 'create_or_update_lineage_node_block_pattern', 'create_or_update_lineage_node_replacement_rule', 'create_or_update_lineage_node_collapsing_rule', 'delete_lineage_node', 'delete_lineage_node_block_pattern', 'delete_lineage_node_replacement_rule', 'delete_lineage_node_collapsing_rule', 'create_or_update_field_quality_rule', 'create_or_update_catalog_object_metadata', 'delete_catalog_object_metadata', 'create_or_update_object_property', 'delete_object_property', 'bulk_create_or_update_object_properties', 'create_or_update_monitor_label', 'delete_monitor_label', 'add_monitors_labels', 'remove_monitors_labels', 'create_or_update_custom_sql_template', 'delete_custom_sql_template', 'stop_monitor', 'delete_monitor', 'trigger_monitor', 'create_or_update_monitor', 'pause_monitor', 'validate_cron', 'create_event_comment', 'update_event_comment', 'delete_event_comment', 'set_incident_feedback', 'set_incident_reaction', 'set_incident_severity', 'set_incident_owner', 'create_or_update_incident_comment', 'delete_incident_comment', 'split_incident', 'bulk_update_incidents', 'create_or_update_domain', 'delete_domain', 'create_or_update_authorization_group', 'delete_authorization_group', 'update_user_authorization_group_membership', 'create_or_update_resource', 'match_and_create_bi_warehouse_sources', 'toggle_disable_sampling', 'toggle_restrict_sampling', 'toggle_disable_value_ingestion', 'toggle_disable_value_sampling_when_testing', 'toggle_enable_full_distribution_metrics', 'save_table_importance_stats', 'set_default_incident_group_interval', 'set_default_lineage_incident_grouping', 'create_or_update_data_maintenance_entry', 'toggle_wildcard_aggregation', 'set_wildcard_templates', 'delete_data_maintenance_entry', 'create_shared_query', 'create_or_update_user_settings', 'update_user_state', 'update_user_persona', 'update_account_display_assets_search_tags', 'set_account_name', 'set_account_billing_plan', 'set_warehouse_name', 'set_etl_container_name', 'create_or_update_saml_identity_provider', 'delete_saml_identity_provider', 'invite_users', 'invite_users_v2', 'switch_user_account', 'delete_user_invite', 'resend_user_invite', 'remove_user_from_account', 'disable_user', 'track_table', 'upload_credentials', 'save_slack_credentials', 'deauthorize_slack_app', 'test_credentials', 'test_database_credentials', 'test_presto_credentials', 'test_snowflake_credentials', 'test_hive_credentials', 'test_s3_credentials', 'test_glue_credentials', 'test_athena_credentials', 'test_looker_credentials', 'test_looker_git_credentials', 'test_looker_git_ssh_credentials', 'test_looker_git_clone_credentials', 'test_dbt_cloud_credentials', 'test_bq_credentials', 'test_spark_credentials', 'test_databricks_sql_warehouse_credentials', 'test_self_hosted_credentials', 'test_tableau_credentials', 'test_power_bi_credentials', 'test_fivetran_credentials', 'toggle_mute_dataset', 'toggle_mute_table', 'toggle_mute_datasets', 'toggle_mute_tables', 'toggle_mute_with_regex', 'toggle_slack_reply_warning', 'toggle_connection_enable', 'add_connection', 'remove_connection', 'add_bi_connection', 'update_bi_connection_name', 'add_etl_connection', 'toggle_event_config', 'configure_airflow_log_events', 'configure_metadata_events', 'configure_query_log_events', 'disable_airflow_log_events', 'disable_metadata_events', 'disable_query_log_events', 'create_or_update_service_api_token', 'create_access_token', 'delete_access_token', 'generate_collector_template', 'update_credentials', 'create_collector_record', 'cleanup_collector_record', 'migrate_collector_resources', 'update_slack_channels', 'create_integration_key', 'delete_integration_key', 'create_databricks_secret', 'create_databricks_notebook_job', 'update_databricks_notebook_job', 'update_databricks_notebook', 'start_databricks_cluster', 'start_databricks_warehouse', 'test_databricks_credentials', 'test_delta_credentials', 'add_databricks_connection', 'save_event_onboarding_data', 'delete_event_onboarding_data', 'migrate_databricks_sql_warehouse', 'toggle_notifications_v2', 'toggle_account_feature', 'test_snowflake_credentials_v2', 'test_redshift_credentials_v2', 'test_bq_credentials_v2', 'test_tableau_credentials_v2', 'test_looker_credentials_v2', 'test_looker_git_ssh_credentials_v2', 'test_looker_git_clone_credentials_v2', 'test_power_bi_credentials_v2', 'test_databricks_credentials_v2', 'test_databricks_sql_warehouse_credentials_v2', 'test_databricks_metastore_sql_warehouse_credentials_v2', 'test_databricks_spark_credentials_v2', 'test_airflow_credentials_v2', 'upload_airflow_dag_result', 'upload_airflow_task_result', 'upload_airflow_sla_misses', 'create_or_update_alation_integration', 'delete_alation_integration', 'create_or_update_alation_table_flag', 'set_etl_job_generates_incidents', 'create_account_secret', 'update_account_secret', 'delete_account_secret')
    create_or_update_data_explorer_dashboard = sgqlc.types.Field(CreateOrUpdateDataExplorerDashboardMutation, graphql_name='createOrUpdateDataExplorerDashboard', args=sgqlc.types.ArgDict((
        ('data_explorer_dashboard', sgqlc.types.Arg(sgqlc.types.non_null(DataExplorerDashboardInputType), graphql_name='dataExplorerDashboard', default=None)),
))
    )
    '''Arguments:

    * `data_explorer_dashboard`
      (`DataExplorerDashboardInputType!`)None
    '''

    delete_data_explorer_dashboard = sgqlc.types.Field(DeleteDataExplorerDashboardMutation, graphql_name='deleteDataExplorerDashboard', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Arguments:

    * `uuid` (`UUID!`): UUID of dashboard to be deleted
    '''

    create_or_update_data_explorer_comparison_dashboard = sgqlc.types.Field(CreateOrUpdateDataExplorerComparisonDashboardMutation, graphql_name='createOrUpdateDataExplorerComparisonDashboard', args=sgqlc.types.ArgDict((
        ('data_explorer_comparison_dashboard', sgqlc.types.Arg(sgqlc.types.non_null(DataExplorerComparisonDashboardInputType), graphql_name='dataExplorerComparisonDashboard', default=None)),
))
    )
    '''Arguments:

    * `data_explorer_comparison_dashboard`
      (`DataExplorerComparisonDashboardInputType!`)None
    '''

    delete_data_explorer_comparison_dashboard = sgqlc.types.Field(DeleteDataExplorerComparisonDashboardMutation, graphql_name='deleteDataExplorerComparisonDashboard', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Arguments:

    * `uuid` (`UUID!`): UUID of comparison dashboard to be deleted
    '''

    create_webex_integration = sgqlc.types.Field(CreateWebexIntegration, graphql_name='createWebexIntegration', args=sgqlc.types.ArgDict((
        ('bot_token', sgqlc.types.Arg(String, graphql_name='botToken', default=None)),
        ('integration_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='integrationName', default=None)),
))
    )
    '''Create a Webex integration

    Arguments:

    * `bot_token` (`String`): The bot token for authentication; if not
      provided, the previous value will be used
    * `integration_name` (`String!`): A short name to identify the
      integration
    '''

    update_webex_integration = sgqlc.types.Field('UpdateWebexIntegration', graphql_name='updateWebexIntegration', args=sgqlc.types.ArgDict((
        ('bot_token', sgqlc.types.Arg(String, graphql_name='botToken', default=None)),
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
        ('integration_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='integrationName', default=None)),
))
    )
    '''Update a Webex integration

    Arguments:

    * `bot_token` (`String`): The bot token for authentication; if not
      provided, the previous value will be used
    * `integration_id` (`UUID!`): The integration ID
    * `integration_name` (`String!`): A short name to identify the
      integration
    '''

    delete_webex_integration = sgqlc.types.Field(DeleteWebexIntegration, graphql_name='deleteWebexIntegration', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
))
    )
    '''Delete a Webex integration

    Arguments:

    * `integration_id` (`UUID!`): The integration ID
    '''

    update_monitored_table_rule_list = sgqlc.types.Field(sgqlc.types.list_of(MonitoredTableRuleObject), graphql_name='updateMonitoredTableRuleList', args=sgqlc.types.ArgDict((
        ('dataset', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='dataset', default=None)),
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('project', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='project', default=None)),
        ('rules', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(MonitoredTableRuleInput)), graphql_name='rules', default=None)),
))
    )
    '''Updates the list of rules for deciding which tables are monitored
    within the given project & dataset scope

    Arguments:

    * `dataset` (`String!`): Rules apply to tables in this
      dataset/schema
    * `dw_id` (`UUID!`): Rules apply to tables in this warehouse
    * `project` (`String!`): Rules apply to tables in this
      project/database
    * `rules` (`[MonitoredTableRuleInput]!`): The complete list of
      rules for deciding which tables are monitored
    '''

    toggle_performance_dashboard_for_domain_restricted_users = sgqlc.types.Field('TogglePerformanceDashboardForDomainRestrictedUsers', graphql_name='togglePerformanceDashboardForDomainRestrictedUsers', args=sgqlc.types.ArgDict((
        ('enabled', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enabled', default=None)),
))
    )
    '''Sets the toggle for enabling performance dashboard for domain
    restricted users

    Arguments:

    * `enabled` (`Boolean!`): Enable performance dashboard for domain
      restricted user
    '''

    create_or_update_agent = sgqlc.types.Field(CreateOrUpdateAgent, graphql_name='createOrUpdateAgent', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(UUID, graphql_name='agentId', default=None)),
        ('agent_type', sgqlc.types.Arg(AgentTypeEnum, graphql_name='agentType', default=None)),
        ('auth_type', sgqlc.types.Arg(AuthTypeEnum, graphql_name='authType', default=None)),
        ('credentials', sgqlc.types.Arg(JSONString, graphql_name='credentials', default=None)),
        ('data_collector_id', sgqlc.types.Arg(UUID, graphql_name='dataCollectorId', default=None)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=False)),
        ('endpoint', sgqlc.types.Arg(String, graphql_name='endpoint', default=None)),
        ('image_build', sgqlc.types.Arg(String, graphql_name='imageBuild', default=None)),
        ('image_version', sgqlc.types.Arg(String, graphql_name='imageVersion', default=None)),
        ('platform', sgqlc.types.Arg(PlatformTypeEnum, graphql_name='platform', default=None)),
        ('skip_validation', sgqlc.types.Arg(Boolean, graphql_name='skipValidation', default=None)),
        ('storage_type', sgqlc.types.Arg(StorageTypeEnum, graphql_name='storageType', default=None)),
        ('upgradeable', sgqlc.types.Arg(Boolean, graphql_name='upgradeable', default=None)),
        ('wrapper_type', sgqlc.types.Arg(String, graphql_name='wrapperType', default=None)),
        ('wrapper_version', sgqlc.types.Arg(String, graphql_name='wrapperVersion', default=None)),
))
    )
    '''Create or Update a Monte Carlo Agent

    Arguments:

    * `agent_id` (`UUID`): UUID of Agent to update.
    * `agent_type` (`AgentTypeEnum`): The type of Agent being
      deployed.
    * `auth_type` (`AuthTypeEnum`): The type of authorization
      provided.
    * `credentials` (`JSONString`): JSON of credentials for Agent.
    * `data_collector_id` (`UUID`): The UUID of the Data Collector to
      associate the agent with.
    * `dry_run` (`Boolean`): Dry run? (default: `false`)
    * `endpoint` (`String`): Bucket name, IP address or URL of the
      agent.
    * `image_build` (`String`): Build number of agent image. Ignored
      if agent type is DATA_STORE_AGENT.
    * `image_version` (`String`): The image version of the Agent. Null
      if agent type is data_store.
    * `platform` (`PlatformTypeEnum`): The cloud platform the agent is
      deployed on.
    * `skip_validation` (`Boolean`): True if you want to skip
      validating agent access before creating/updating.
    * `storage_type` (`StorageTypeEnum`): The storage type of the
      Agent.
    * `upgradeable` (`Boolean`): Boolean if the agent is remote
      upgradeable.
    * `wrapper_type` (`String`): The wrapper type of the Agent.
    * `wrapper_version` (`String`): The wrapper version of the Agent.
    '''

    delete_agent = sgqlc.types.Field(DeleteAgent, graphql_name='deleteAgent', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
))
    )
    '''Delete a Monte Carlo Agent

    Arguments:

    * `agent_id` (`UUID!`): UUID of Agent to delete
    '''

    upgrade_agent = sgqlc.types.Field('UpgradeAgent', graphql_name='upgradeAgent', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('image', sgqlc.types.Arg(String, graphql_name='image', default=None)),
        ('parameters', sgqlc.types.Arg(GenericScalar, graphql_name='parameters', default=None)),
        ('timeout', sgqlc.types.Arg(Int, graphql_name='timeout', default=None)),
        ('trace_id', sgqlc.types.Arg(String, graphql_name='traceId', default=None)),
))
    )
    '''Upgrades a Monte Carlo Agent to a given version

    Arguments:

    * `agent_id` (`UUID!`): The UUID of the Agent to upgrade.
    * `image` (`String`): Image to upgrade the agent to (upgrades to
      the latest image by default).
    * `parameters` (`GenericScalar`): New values for template
      parameters, for example: MemorySize=1024
    * `timeout` (`Int`): Time to wait for the upgrade to complete
    * `trace_id` (`String`): Trace ID for the request.
    '''

    create_tableau_asset_warning = sgqlc.types.Field(CreateTableauAssetWarning, graphql_name='createTableauAssetWarning', args=sgqlc.types.ArgDict((
        ('bi_container_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='biContainerId', default=None)),
        ('incident_id', sgqlc.types.Arg(UUID, graphql_name='incidentId', default=None)),
        ('message', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='message', default=None)),
        ('tableau_asset_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='tableauAssetType', default=None)),
        ('tableau_luid', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='tableauLuid', default=None)),
))
    )
    '''Create tableau asset warning

    Arguments:

    * `bi_container_id` (`UUID!`): UUID of the Tableau container for
      which this warning is being created.
    * `incident_id` (`UUID`): UUID of the incident for which this
      warning is being created.
    * `message` (`String!`): The message of the warning
    * `tableau_asset_type` (`String!`): The type of the Tableau asset.
      This is a string defined by Tableau. Eg: datasource
    * `tableau_luid` (`String!`): The Tableau LUID of the tableau
      asset for which the warning is being created.
    '''

    update_tableau_asset_warning = sgqlc.types.Field('UpdateTableauAssetWarning', graphql_name='updateTableauAssetWarning', args=sgqlc.types.ArgDict((
        ('bi_container_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='biContainerId', default=None)),
        ('message', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='message', default=None)),
        ('tableau_warning_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='tableauWarningId', default=None)),
))
    )
    '''Update tableau asset warning

    Arguments:

    * `bi_container_id` (`UUID!`): UUID of the Tableau container for
      which this warning is being created.
    * `message` (`String!`): The new message of the warning
    * `tableau_warning_id` (`String!`): The Tableau Data Quality
      Warning ID.
    '''

    generate_dc_upgrade_template = sgqlc.types.Field(GenerateDcUpgradeTemplate, graphql_name='generateDcUpgradeTemplate', args=sgqlc.types.ArgDict((
        ('dc_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dcId', default=None)),
))
    )
    '''Generates a template for DC upgrade and a URL to execute the
    template in the cloud provider.

    Arguments:

    * `dc_id` (`UUID!`): The data collector UUID
    '''

    delete_data_product = sgqlc.types.Field(DeleteDataProduct, graphql_name='deleteDataProduct', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Delete a data product

    Arguments:

    * `uuid` (`UUID!`): UUID of data product to delete
    '''

    create_or_update_data_product = sgqlc.types.Field(CreateOrUpdateDataProduct, graphql_name='createOrUpdateDataProduct', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update a data product

    Arguments:

    * `description` (`String`): Description of the data product
    * `domain_id` (`UUID`): UUID of domain to create this data product
    * `mcons` (`[String]`): MCON of assets to be part of this data
      product
    * `name` (`String`): Data product name
    * `uuid` (`UUID`): UUID of data product to update
    '''

    update_data_product_sharing = sgqlc.types.Field('UpdateDataProductSharing', graphql_name='updateDataProductSharing', args=sgqlc.types.ArgDict((
        ('data_product_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dataProductUuid', default=None)),
        ('shared_with_all_in_same_account', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='sharedWithAllInSameAccount', default=False)),
))
    )
    '''Create or update sharing definition on a data product

    Arguments:

    * `data_product_uuid` (`UUID!`): UUID of data product to share
    * `shared_with_all_in_same_account` (`Boolean!`): Whether this
      data product is shared with all users in the same account.
      (default: `false`)
    '''

    link_github_app_installation = sgqlc.types.Field(LinkGithubAppInstallation, graphql_name='linkGithubAppInstallation', args=sgqlc.types.ArgDict((
        ('code', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='code', default=None)),
        ('installation_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='installationId', default=None)),
))
    )
    '''Called from the FE as part of the post-installation callback. The
    "code" parameter is used to validate that the request is an
    authentic Github callback and authenticates the user on the Github
    side.

    Arguments:

    * `code` (`String!`): Security code passed from Github
    * `installation_id` (`String!`): Github App installation id
    '''

    register_github_app_installation_request = sgqlc.types.Field('RegisterGithubAppInstallationRequest', graphql_name='registerGithubAppInstallationRequest', args=sgqlc.types.ArgDict((
        ('code', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='code', default=None)),
))
    )
    '''Called from the FE as part of the post-installation callback in
    case the user requested approval from her Github admin, instead of
    approving directly. The "code" parameter is used to identify the
    Github user of the requester.

    Arguments:

    * `code` (`String!`): Security code passed from Github
    '''

    update_github_installation = sgqlc.types.Field('UpdateGithubAppInstallation', graphql_name='updateGithubInstallation', args=sgqlc.types.ArgDict((
        ('installation_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='installationUuid', default=None)),
        ('show_impact_analysis', sgqlc.types.Arg(Boolean, graphql_name='showImpactAnalysis', default=None)),
))
    )
    '''Updates settings for the Github app installation

    Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the installation
      to delete
    * `show_impact_analysis` (`Boolean`): If true, show impacted
      models and reports as a PR comment
    '''

    delete_github_installation = sgqlc.types.Field(DeleteGithubInstallation, graphql_name='deleteGithubInstallation', args=sgqlc.types.ArgDict((
        ('installation_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='installationUuid', default=None)),
))
    )
    '''Arguments:

    * `installation_uuid` (`UUID!`): Internal UUID of the installation
      to delete
    '''

    test_confluent_kafka_credentials = sgqlc.types.Field('TestConfluentKafkaCredentials', graphql_name='testConfluentKafkaCredentials', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(ConfluentKafkaCredentialsInput), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test a confluent Kafka cluster credentials.

    Arguments:

    * `connection_details` (`ConfluentKafkaCredentialsInput!`):
      Required Credential Info for accessing Confluent Kafka Cluster
      APIs.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_confluent_kafka_connect_credentials = sgqlc.types.Field('TestConfluentKafkaConnectCredentials', graphql_name='testConfluentKafkaConnectCredentials', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(ConfluentKafkaConnectCredentialsInput), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test a confluent Kafka Connect cluster credentials.

    Arguments:

    * `connection_details` (`ConfluentKafkaConnectCredentialsInput!`):
      Required Credential Info for accessing Confluent Cloud Kafka
      Connect APIs.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `validation_name` (`String!`): Validation to run for validating
      the connection.
    '''

    add_streaming_system = sgqlc.types.Field(AddStreamingSystemMutation, graphql_name='addStreamingSystem', args=sgqlc.types.ArgDict((
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('streaming_system_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='streamingSystemName', default=None)),
        ('streaming_system_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='streamingSystemType', default=None)),
))
    )
    '''Add a streaming system, which contains a set of streaming clusters
    that work together in the system.

    Arguments:

    * `dc_id` (`UUID`): The Data Collector UUID for the jobs of
      connections within the streaming system to run in.
    * `streaming_system_name` (`String!`): Name of the streaming
      system.
    * `streaming_system_type` (`String!`): Streaming system type.
      Supported values [confluent-cloud]
    '''

    add_streaming_connection = sgqlc.types.Field(AddStreamingConnectionMutation, graphql_name='addStreamingConnection', args=sgqlc.types.ArgDict((
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('job_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='jobTypes', default=None)),
        ('key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='key', default=None)),
        ('mc_cluster_id', sgqlc.types.Arg(UUID, graphql_name='mcClusterId', default=None)),
        ('new_cluster_id', sgqlc.types.Arg(String, graphql_name='newClusterId', default=None)),
        ('new_cluster_name', sgqlc.types.Arg(String, graphql_name='newClusterName', default=None)),
        ('new_cluster_type', sgqlc.types.Arg(String, graphql_name='newClusterType', default=None)),
        ('new_streaming_system_name', sgqlc.types.Arg(String, graphql_name='newStreamingSystemName', default=None)),
        ('new_streaming_system_type', sgqlc.types.Arg(String, graphql_name='newStreamingSystemType', default=None)),
        ('streaming_system_id', sgqlc.types.Arg(UUID, graphql_name='streamingSystemId', default=None)),
))
    )
    '''Add a connection for a streaming cluster and setup any associated
    jobs. Creates a streaming cluster if a cluster if not specified.

    Arguments:

    * `connection_type` (`String!`): Type of the new connection.
    * `dc_id` (`UUID`): Data Collector uuid to associate the streaming
      system with.
    * `job_types` (`[String]`): List of job types to create for the
      connection. If left empty, MC'd create all auto jobs.
    * `key` (`String!`): Temp key from testing connections.
    * `mc_cluster_id` (`UUID`): UUID of an existing streaming cluster.
      If this field is given, please don't set new_cluster_id,
      new_cluster_type or new_cluster_name.
    * `new_cluster_id` (`String`): Real cluster ID used in the system.
      Should be obtained from customer system. Only set when creating
      a new cluster.
    * `new_cluster_name` (`String`): Name of the cluster. Only set
      when creating a new cluster.
    * `new_cluster_type` (`String`): Type of the cluster. Only set
      when creating a new cluster. Supported types: [kafka-cluster,
      kafka-connect-cluster]
    * `new_streaming_system_name` (`String`): Name of a new streaming
      system to associate with a new cluster and the connection. Only
      set when we'd like to create a new streaming system.
    * `new_streaming_system_type` (`String`): Type of a new streaming
      system to associate with a new cluster and the connection. Only
      set when we'd like to create a new streaming system. Supported
      values: [confluent-cloud]
    * `streaming_system_id` (`UUID`): UUID of an existing streaming
      system. If this field is given, please don't set
      new_streaming_system_type or new_streaming_system_name.
    '''

    delete_streaming_system = sgqlc.types.Field(DeleteStreamingSystemMutation, graphql_name='deleteStreamingSystem', args=sgqlc.types.ArgDict((
        ('streaming_system_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='streamingSystemUuid', default=None)),
))
    )
    '''Delete a streaming system. This will delete all clusters within
    the streaming system as well.

    Arguments:

    * `streaming_system_uuid` (`UUID!`): UUID of the streaming System
    '''

    delete_streaming_cluster = sgqlc.types.Field(DeleteStreamingClusterMutation, graphql_name='deleteStreamingCluster', args=sgqlc.types.ArgDict((
        ('streaming_cluster_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='streamingClusterUuid', default=None)),
))
    )
    '''Delete a streaming clusters, and connections on this cluster.

    Arguments:

    * `streaming_cluster_uuid` (`UUID!`): UUID of the streaming
      Cluster.
    '''

    update_streaming_system_name = sgqlc.types.Field('UpdateStreamingSystemNameMutation', graphql_name='updateStreamingSystemName', args=sgqlc.types.ArgDict((
        ('new_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='newName', default=None)),
        ('streaming_system_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='streamingSystemUuid', default=None)),
))
    )
    '''Update a streaming system name.

    Arguments:

    * `new_name` (`String!`): New name of the system
    * `streaming_system_uuid` (`UUID!`): UUID of the streaming
      Cluster.
    '''

    update_streaming_cluster_name = sgqlc.types.Field('UpdateStreamingClusterNameMutation', graphql_name='updateStreamingClusterName', args=sgqlc.types.ArgDict((
        ('new_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='newName', default=None)),
        ('streaming_cluster_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='streamingClusterUuid', default=None)),
))
    )
    '''Update a streaming cluster name.

    Arguments:

    * `new_name` (`String!`): New name of the system
    * `streaming_cluster_uuid` (`UUID!`): UUID of the streaming
      cluster.
    '''

    toggle_size_collection = sgqlc.types.Field('ToggleSizeCollection', graphql_name='toggleSizeCollection', args=sgqlc.types.ArgDict((
        ('enabled', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enabled', default=None)),
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('where_condition', sgqlc.types.Arg(String, graphql_name='whereCondition', default=None)),
))
    )
    '''Toggle Size Collection for an assets which doesn't support
    metadata

    Arguments:

    * `enabled` (`Boolean!`): True if collection should be enabled.
      False if disabled
    * `mcon` (`String!`): MC unique identifier of the object
    * `where_condition` (`String`): Where condition which is applied
      to the collection query
    '''

    create_servicenow_integration = sgqlc.types.Field(CreateServiceNowIntegration, graphql_name='createServicenowIntegration', args=sgqlc.types.ArgDict((
        ('default_incident_fields', sgqlc.types.Arg(JSONString, graphql_name='defaultIncidentFields', default=None)),
        ('instance_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='instanceName', default=None)),
        ('integration_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='integrationName', default=None)),
        ('password', sgqlc.types.Arg(String, graphql_name='password', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
))
    )
    '''Create a ServiceNow integration

    Arguments:

    * `default_incident_fields` (`JSONString`): Default values for
      incident fields
    * `instance_name` (`String!`): The instance name of the ServiceNow
      site
    * `integration_name` (`String!`): A short name to identify the
      integration
    * `password` (`String`): The user's password for basic
      authentication; if not provided, the previous value will be used
    * `username` (`String`): The ServiceNow username for basic
      authentication; if not provided, the previous value will be used
    '''

    update_servicenow_integration = sgqlc.types.Field('UpdateServiceNowIntegration', graphql_name='updateServicenowIntegration', args=sgqlc.types.ArgDict((
        ('default_incident_fields', sgqlc.types.Arg(JSONString, graphql_name='defaultIncidentFields', default=None)),
        ('instance_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='instanceName', default=None)),
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
        ('integration_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='integrationName', default=None)),
        ('password', sgqlc.types.Arg(String, graphql_name='password', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
))
    )
    '''Update a ServiceNow integration

    Arguments:

    * `default_incident_fields` (`JSONString`): Default values for
      incident fields
    * `instance_name` (`String!`): The instance name of the ServiceNow
      site
    * `integration_id` (`UUID!`): The integration ID
    * `integration_name` (`String!`): A short name to identify the
      integration
    * `password` (`String`): The user's password for basic
      authentication; if not provided, the previous value will be used
    * `username` (`String`): The ServiceNow username for basic
      authentication; if not provided, the previous value will be used
    '''

    delete_servicenow_integration = sgqlc.types.Field(DeleteServiceNowIntegration, graphql_name='deleteServicenowIntegration', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
))
    )
    '''Delete a ServiceNow integration

    Arguments:

    * `integration_id` (`UUID!`): The integration ID
    '''

    create_jira_integration = sgqlc.types.Field(CreateJiraIntegration, graphql_name='createJiraIntegration', args=sgqlc.types.ArgDict((
        ('api_token', sgqlc.types.Arg(String, graphql_name='apiToken', default=None)),
        ('default_ticket_fields', sgqlc.types.Arg(JSONString, graphql_name='defaultTicketFields', default=None)),
        ('integration_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='integrationName', default=None)),
        ('server_url', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='serverUrl', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
        ('webhook_config', sgqlc.types.Arg(JiraWebhookConfigInput, graphql_name='webhookConfig', default=None)),
        ('webhook_enabled', sgqlc.types.Arg(Boolean, graphql_name='webhookEnabled', default=None)),
))
    )
    '''Create a Jira integration

    Arguments:

    * `api_token` (`String`): The personal API token for basic
      authentication; if not provided, the previous value will be used
    * `default_ticket_fields` (`JSONString`): Default values for
      ticket fields
    * `integration_name` (`String!`): A short name to identify the
      integration
    * `server_url` (`String!`): The domain name for your Jira site
    * `username` (`String`): The Jira username for basic
      authentication; if not provided, the previous value will be used
    * `webhook_config` (`JiraWebhookConfigInput`): Webhook config
    * `webhook_enabled` (`Boolean`): Whether the Jira webhook is
      enabled
    '''

    update_jira_integration = sgqlc.types.Field('UpdateJiraIntegration', graphql_name='updateJiraIntegration', args=sgqlc.types.ArgDict((
        ('api_token', sgqlc.types.Arg(String, graphql_name='apiToken', default=None)),
        ('default_ticket_fields', sgqlc.types.Arg(JSONString, graphql_name='defaultTicketFields', default=None)),
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
        ('integration_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='integrationName', default=None)),
        ('server_url', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='serverUrl', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
        ('webhook_config', sgqlc.types.Arg(JiraWebhookConfigInput, graphql_name='webhookConfig', default=None)),
        ('webhook_enabled', sgqlc.types.Arg(Boolean, graphql_name='webhookEnabled', default=None)),
))
    )
    '''Update a Jira integration

    Arguments:

    * `api_token` (`String`): The personal API token for basic
      authentication; if not provided, the previous value will be used
    * `default_ticket_fields` (`JSONString`): Default values for
      ticket fields
    * `integration_id` (`UUID!`): The integration ID
    * `integration_name` (`String!`): A short name to identify the
      integration
    * `server_url` (`String!`): The domain name for your Jira site
    * `username` (`String`): The Jira username for basic
      authentication; if not provided, the previous value will be used
    * `webhook_config` (`JiraWebhookConfigInput`): Webhook config
    * `webhook_enabled` (`Boolean`): Whether the Jira webhook is
      enabled
    '''

    delete_jira_integration = sgqlc.types.Field(DeleteJiraIntegration, graphql_name='deleteJiraIntegration', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
))
    )
    '''Delete a Jira integration

    Arguments:

    * `integration_id` (`UUID!`): The integration ID
    '''

    create_jira_ticket_for_incident = sgqlc.types.Field(CreateJiraTicketForIncident, graphql_name='createJiraTicketForIncident', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
        ('issuetype', sgqlc.types.Arg(Int, graphql_name='issuetype', default=None)),
        ('project', sgqlc.types.Arg(Int, graphql_name='project', default=None)),
        ('summary', sgqlc.types.Arg(String, graphql_name='summary', default=None)),
))
    )
    '''Arguments:

    * `description` (`String`): Jira ticket description
    * `incident_id` (`UUID!`): ID of the incident
    * `integration_id` (`UUID!`): ID of the integration
    * `issuetype` (`Int`): Jira issue type ID
    * `project` (`Int`): Jira project ID
    * `summary` (`String`): Jira ticket summary
    '''

    link_jira_ticket_for_incident = sgqlc.types.Field(LinkJiraTicketForIncident, graphql_name='linkJiraTicketForIncident', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
        ('ticket_url', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='ticketUrl', default=None)),
))
    )
    '''Arguments:

    * `incident_id` (`UUID!`): ID of the incident
    * `integration_id` (`UUID!`): ID of the integration
    * `ticket_url` (`String!`): URL of the Jira ticket
    '''

    unlink_jira_ticket_for_incident = sgqlc.types.Field('UnlinkJiraTicketForIncident', graphql_name='unlinkJiraTicketForIncident', args=sgqlc.types.ArgDict((
        ('ticket_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='ticketId', default=None)),
))
    )
    '''Arguments:

    * `ticket_id` (`UUID!`): The ticket ID
    '''

    create_or_update_audience = sgqlc.types.Field(CreateOrUpdateAudience, graphql_name='createOrUpdateAudience', args=sgqlc.types.ArgDict((
        ('label', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='label', default=None)),
        ('notification_settings', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(AudienceNotificationSettingInput)), graphql_name='notificationSettings', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create a notification audience

    Arguments:

    * `label` (`String!`): Label for the audience
    * `notification_settings` (`[AudienceNotificationSettingInput]!`):
      Notification settings for the audience
    * `uuid` (`UUID`): For updating an audience
    '''

    create_or_update_audience_notification_setting = sgqlc.types.Field(CreateOrUpdateAudienceNotificationSetting, graphql_name='createOrUpdateAudienceNotificationSetting', args=sgqlc.types.ArgDict((
        ('audience_id', sgqlc.types.Arg(UUID, graphql_name='audienceId', default=None)),
        ('dry', sgqlc.types.Arg(Boolean, graphql_name='dry', default=False)),
        ('extra', sgqlc.types.Arg(NotificationExtra, graphql_name='extra', default=None)),
        ('integration_id', sgqlc.types.Arg(UUID, graphql_name='integrationId', default=None)),
        ('notification_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='notificationType', default=None)),
        ('recipients', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='recipients', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update an audience notification setting

    Arguments:

    * `audience_id` (`UUID`): Audience associated with the recipient
    * `dry` (`Boolean`): Test destination is reachable by sending a
      sample alert. Note - setting is not saved and rules are not
      evaluated. (default: `false`)
    * `extra` (`NotificationExtra`): Any extra values
    * `integration_id` (`UUID`): Integration ID for the recipient
    * `notification_type` (`String!`): emailSpecify the notification
      integration to use. Supported options include: ,
      mattermostSpecify the notification integration to use. Supported
      options include: , opsgenieSpecify the notification integration
      to use. Supported options include: , pagerdutySpecify the
      notification integration to use. Supported options include: ,
      slackSpecify the notification integration to use. Supported
      options include: , slack_v2Specify the notification integration
      to use. Supported options include: , webhookSpecify the
      notification integration to use. Supported options include: ,
      msteamsSpecify the notification integration to use. Supported
      options include: , alationSpecify the notification integration
      to use. Supported options include: , servicenowSpecify the
      notification integration to use. Supported options include: ,
      jiraSpecify the notification integration to use. Supported
      options include: , webex
    * `recipients` (`[String]!`): Destination to send notifications to
    * `uuid` (`UUID`): For updating a notification setting
    '''

    delete_audience_notification_setting = sgqlc.types.Field(DeleteAudienceNotificationSetting, graphql_name='deleteAudienceNotificationSetting', args=sgqlc.types.ArgDict((
        ('uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='uuids', default=None)),
))
    )
    '''Arguments:

    * `uuids` (`[UUID]!`)None
    '''

    create_or_update_audience_routing_rule = sgqlc.types.Field(CreateOrUpdateAudienceRoutingRule, graphql_name='createOrUpdateAudienceRoutingRule', args=sgqlc.types.ArgDict((
        ('all_tag_key_values', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.list_of(NotificationTagPairs)), graphql_name='allTagKeyValues', default=None)),
        ('anomaly_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='anomalyTypes', default=None)),
        ('audience_id', sgqlc.types.Arg(UUID, graphql_name='audienceId', default=None)),
        ('custom_message', sgqlc.types.Arg(String, graphql_name='customMessage', default=None)),
        ('dataset_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='datasetIds', default=None)),
        ('digest_settings', sgqlc.types.Arg(NotificationDigestSettings, graphql_name='digestSettings', default=None)),
        ('domain_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='domainIds', default=None)),
        ('exclude_all_tag_key_values', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.list_of(NotificationTagPairs)), graphql_name='excludeAllTagKeyValues', default=None)),
        ('exclude_dataset_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='excludeDatasetIds', default=None)),
        ('exclude_full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeFullTableIds', default=None)),
        ('exclude_project_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeProjectMcons', default=None)),
        ('exclude_project_names', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeProjectNames', default=None)),
        ('exclude_table_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeTableMcons', default=None)),
        ('exclude_tag_key_values', sgqlc.types.Arg(sgqlc.types.list_of(NotificationTagPairs), graphql_name='excludeTagKeyValues', default=None)),
        ('exclude_tag_keys', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeTagKeys', default=None)),
        ('full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='fullTableIds', default=None)),
        ('incident_sub_types', sgqlc.types.Arg(sgqlc.types.list_of(IncidentSubType), graphql_name='incidentSubTypes', default=None)),
        ('project_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='projectMcons', default=None)),
        ('project_names', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='projectNames', default=None)),
        ('table_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tableMcons', default=None)),
        ('table_regex', sgqlc.types.Arg(String, graphql_name='tableRegex', default=None)),
        ('table_stats_rules', sgqlc.types.Arg(TableStatsRules, graphql_name='tableStatsRules', default=None)),
        ('tag_key_values', sgqlc.types.Arg(sgqlc.types.list_of(NotificationTagPairs), graphql_name='tagKeyValues', default=None)),
        ('tag_keys', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tagKeys', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update an audience routing rule

    Arguments:

    * `all_tag_key_values` (`[[NotificationTagPairs]]`)None
    * `anomaly_types` (`[String]`): anomaliesLimit notifications to
      specific incident types (default=all). Supported options
      include: , schema_changesLimit notifications to specific
      incident types (default=all). Supported options include: ,
      json_schema_changesLimit notifications to specific incident
      types (default=all). Supported options include: ,
      deleted_tablesLimit notifications to specific incident types
      (default=all). Supported options include: ,
      metric_anomaliesLimit notifications to specific incident types
      (default=all). Supported options include: ,
      custom_rule_anomaliesLimit notifications to specific incident
      types (default=all). Supported options include: ,
      performance_anomaliesLimit notifications to specific incident
      types (default=all). Supported options include: ,
      dbt_errorsLimit notifications to specific incident types
      (default=all). Supported options include: , etl_errorsLimit
      notifications to specific incident types (default=all).
      Supported options include: , pseudo_integration_testLimit
      notifications to specific incident types (default=all).
      Supported options include: , rule_run_execution_error
    * `audience_id` (`UUID`): Audience associated with the rule
    * `custom_message` (`String`): A custom message to be sent with
      triggered notification
    * `dataset_ids` (`[UUID]`): Allowlist by dataset identifiers
    * `digest_settings` (`NotificationDigestSettings`): Digest
      settings.
    * `domain_ids` (`[UUID]`): Allowlist by domain identifiers
    * `exclude_all_tag_key_values` (`[[NotificationTagPairs]]`)None
    * `exclude_dataset_ids` (`[UUID]`): Denylist by dataset
      identifiers
    * `exclude_full_table_ids` (`[String]`): Denylist by full table
      identifiers
    * `exclude_project_mcons` (`[String]`): Denylist by project mcons
    * `exclude_project_names` (`[String]`): Denylist by project names
    * `exclude_table_mcons` (`[String]`): Denylist by table mcon
      identifiers
    * `exclude_tag_key_values` (`[NotificationTagPairs]`): Denylist by
      tag key/value pairs
    * `exclude_tag_keys` (`[String]`): Denylist by tag keys
    * `full_table_ids` (`[String]`): Allowlist by full table
      identifiers
    * `incident_sub_types` (`[IncidentSubType]`): Limit notifications
      to specific incident sub types (default=all).
    * `project_mcons` (`[String]`): Allowlist by project mcons
    * `project_names` (`[String]`): Allowlist by project names
    * `table_mcons` (`[String]`): Allowlist by table mcons
    * `table_regex` (`String`): For use in updating regex based rules
    * `table_stats_rules` (`TableStatsRules`): Allowlist by table
      stats (importance_score, is_important).
    * `tag_key_values` (`[NotificationTagPairs]`): Allowlist by tag
      key/value pairs
    * `tag_keys` (`[String]`): Allowlist by tag keys
    * `uuid` (`UUID`): Rule ID to update a routing rule
    '''

    delete_audience_routing_rule = sgqlc.types.Field(DeleteAudienceRoutingRule, graphql_name='deleteAudienceRoutingRule', args=sgqlc.types.ArgDict((
        ('uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='uuids', default=None)),
))
    )
    '''Arguments:

    * `uuids` (`[UUID]!`)None
    '''

    migrate_to_notifications_v2 = sgqlc.types.Field(MigrateToNotificationsV2, graphql_name='migrateToNotificationsV2', args=sgqlc.types.ArgDict((
        ('dry_run', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='dryRun', default=True)),
))
    )
    '''Arguments:

    * `dry_run` (`Boolean!`): Do not execute the migration. Instead,
      return the actions to be performed and any warnings. (default:
      `true`)
    '''

    create_or_update_notification_setting = sgqlc.types.Field(CreateOrUpdateNotificationSetting, graphql_name='createOrUpdateNotificationSetting', args=sgqlc.types.ArgDict((
        ('anomaly_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='anomalyTypes', default=None)),
        ('audience_id', sgqlc.types.Arg(UUID, graphql_name='audienceId', default=None)),
        ('custom_message', sgqlc.types.Arg(String, graphql_name='customMessage', default=None)),
        ('digest_settings', sgqlc.types.Arg(NotificationDigestSettings, graphql_name='digestSettings', default=None)),
        ('dry', sgqlc.types.Arg(Boolean, graphql_name='dry', default=False)),
        ('extra', sgqlc.types.Arg(NotificationExtra, graphql_name='extra', default=None)),
        ('incident_sub_types', sgqlc.types.Arg(sgqlc.types.list_of(IncidentSubType), graphql_name='incidentSubTypes', default=None)),
        ('integration_id', sgqlc.types.Arg(UUID, graphql_name='integrationId', default=None)),
        ('notification_schedule_type', sgqlc.types.Arg(String, graphql_name='notificationScheduleType', default=None)),
        ('notification_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='notificationType', default=None)),
        ('recipient', sgqlc.types.Arg(String, graphql_name='recipient', default=None)),
        ('recipients', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='recipients', default=None)),
        ('rules', sgqlc.types.Arg(NotificationRoutingRules, graphql_name='rules', default=None)),
        ('setting_id', sgqlc.types.Arg(UUID, graphql_name='settingId', default=None)),
))
    )
    '''Create or update a notification setting

    Arguments:

    * `anomaly_types` (`[String]`): anomaliesLimit notifications to
      specific incident types (default=all). Supported options
      include: , schema_changesLimit notifications to specific
      incident types (default=all). Supported options include: ,
      json_schema_changesLimit notifications to specific incident
      types (default=all). Supported options include: ,
      deleted_tablesLimit notifications to specific incident types
      (default=all). Supported options include: ,
      metric_anomaliesLimit notifications to specific incident types
      (default=all). Supported options include: ,
      custom_rule_anomaliesLimit notifications to specific incident
      types (default=all). Supported options include: ,
      performance_anomaliesLimit notifications to specific incident
      types (default=all). Supported options include: ,
      dbt_errorsLimit notifications to specific incident types
      (default=all). Supported options include: , etl_errorsLimit
      notifications to specific incident types (default=all).
      Supported options include: , pseudo_integration_testLimit
      notifications to specific incident types (default=all).
      Supported options include: , rule_run_execution_error
    * `audience_id` (`UUID`): Audience associated with the recipient
    * `custom_message` (`String`): A custom message to be sent with
      triggered notification
    * `digest_settings` (`NotificationDigestSettings`): Digest
      settings. Only valid when notification schedule type is digest
    * `dry` (`Boolean`): Test destination is reachable by sending a
      sample alert. Note - setting is not saved and rules are not
      evaluated. (default: `false`)
    * `extra` (`NotificationExtra`): Any extra values
    * `incident_sub_types` (`[IncidentSubType]`): Limit notifications
      to specific incident sub types (default=all).
    * `integration_id` (`UUID`): Integration ID for the recipient
    * `notification_schedule_type` (`String`): realtimeSpecify the
      notification schedule type. Supported values: , digestSpecify
      the notification schedule type. Supported values: ,
      backup_or_failure
    * `notification_type` (`String!`): emailSpecify the notification
      integration to use. Supported options include: ,
      mattermostSpecify the notification integration to use. Supported
      options include: , opsgenieSpecify the notification integration
      to use. Supported options include: , pagerdutySpecify the
      notification integration to use. Supported options include: ,
      slackSpecify the notification integration to use. Supported
      options include: , slack_v2Specify the notification integration
      to use. Supported options include: , webhookSpecify the
      notification integration to use. Supported options include: ,
      msteamsSpecify the notification integration to use. Supported
      options include: , alationSpecify the notification integration
      to use. Supported options include: , servicenowSpecify the
      notification integration to use. Supported options include: ,
      jiraSpecify the notification integration to use. Supported
      options include: , webex
    * `recipient` (`String`): Deprecated
    * `recipients` (`[String]`): Destination to send notifications to
    * `rules` (`NotificationRoutingRules`): Routing rules
    * `setting_id` (`UUID`): For updating a notification setting
    '''

    create_or_update_recipient_name = sgqlc.types.Field(CreateOrUpdateRecipientName, graphql_name='createOrUpdateRecipientName', args=sgqlc.types.ArgDict((
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
        ('recipient', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='recipient', default=None)),
))
    )
    '''Create or update a recipient's custom name

    Arguments:

    * `name` (`String!`): Custom name
    * `recipient` (`String!`): Recipient string
    '''

    delete_notification_settings = sgqlc.types.Field(DeleteNotificationSetting, graphql_name='deleteNotificationSettings', args=sgqlc.types.ArgDict((
        ('uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='uuids', default=None)),
))
    )
    '''Arguments:

    * `uuids` (`[UUID]!`)None
    '''

    delete_recipient_name = sgqlc.types.Field(DeleteRecipientName, graphql_name='deleteRecipientName', args=sgqlc.types.ArgDict((
        ('recipient', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='recipient', default=None)),
))
    )
    '''Create or update a recipient's custom name

    Arguments:

    * `recipient` (`String!`): Recipient string
    '''

    set_pii_filter_status = sgqlc.types.Field('SetPiiFilterStatus', graphql_name='setPiiFilterStatus', args=sgqlc.types.ArgDict((
        ('pii_filter_status_pairs', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(PiiFilterStatusPair)), graphql_name='piiFilterStatusPairs', default=None)),
))
    )
    '''Set PII filter status for this account.

    Arguments:

    * `pii_filter_status_pairs` (`[PiiFilterStatusPair]!`): PII Filter
      statuses to set for the account.
    '''

    update_pii_filtering_preferences = sgqlc.types.Field('UpdatePiiFilteringPreferences', graphql_name='updatePiiFilteringPreferences', args=sgqlc.types.ArgDict((
        ('enabled', sgqlc.types.Arg(Boolean, graphql_name='enabled', default=None)),
        ('fail_mode', sgqlc.types.Arg(PiiFilteringFailModeType, graphql_name='failMode', default=None)),
))
    )
    '''Update account-wide PII filtering options.

    Arguments:

    * `enabled` (`Boolean`): Whether PII filtering should be enabled
      for the account.
    * `fail_mode` (`PiiFilteringFailModeType`): Whether PII filter
      failures will allow (open) or prevent (close) data flow for this
      account.
    '''

    update_monitor_name = sgqlc.types.Field('UpdateMonitorName', graphql_name='updateMonitorName', args=sgqlc.types.ArgDict((
        ('monitor_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='monitorType', default=None)),
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
))
    )
    '''Arguments:

    * `monitor_type` (`String!`): Type of monitor
    * `monitor_uuid` (`UUID!`): UUID of the metric monitor or custom
      rule
    * `name` (`String!`): The new monitor name (the description field)
    '''

    update_monitor_notes = sgqlc.types.Field('UpdateMonitorNotes', graphql_name='updateMonitorNotes', args=sgqlc.types.ArgDict((
        ('monitor_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='monitorType', default=None)),
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('notes', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='notes', default=None)),
))
    )
    '''Arguments:

    * `monitor_type` (`String!`): Type of monitor
    * `monitor_uuid` (`UUID!`): UUID of the metric monitor or custom
      rule
    * `notes` (`String!`): The notes for the monitor
    '''

    update_monitor_labels = sgqlc.types.Field('UpdateMonitorLabels', graphql_name='updateMonitorLabels', args=sgqlc.types.ArgDict((
        ('labels', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='labels', default=None)),
        ('monitor_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='monitorType', default=None)),
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
))
    )
    '''Arguments:

    * `labels` (`[String]!`): Labels to insert on the monitor
    * `monitor_type` (`String!`): Type of monitor
    * `monitor_uuid` (`UUID!`): UUID of the metric monitor or custom
      rule
    '''

    create_custom_user = sgqlc.types.Field(CreateCustomUser, graphql_name='createCustomUser', args=sgqlc.types.ArgDict((
        ('email', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='email', default=None)),
        ('first_name', sgqlc.types.Arg(String, graphql_name='firstName', default=None)),
        ('last_name', sgqlc.types.Arg(String, graphql_name='lastName', default=None)),
))
    )
    '''Create a CustomUser

    Arguments:

    * `email` (`String!`): Email
    * `first_name` (`String`): First name
    * `last_name` (`String`): Last name
    '''

    create_unified_user_assignment = sgqlc.types.Field(CreateUnifiedUserAssignment, graphql_name='createUnifiedUserAssignment', args=sgqlc.types.ArgDict((
        ('object_mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='objectMcon', default=None)),
        ('relationship_type', sgqlc.types.Arg(sgqlc.types.non_null(RelationshipType), graphql_name='relationshipType', default=None)),
        ('unified_user_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='unifiedUserId', default=None)),
))
    )
    '''Associate a UnifiedUser with a CatalogObject

    Arguments:

    * `object_mcon` (`String!`): MCON of catalog object
    * `relationship_type` (`RelationshipType!`): Type of relationship
    * `unified_user_id` (`String!`): UUID of UnifiedUser
    '''

    delete_unified_user_assignment = sgqlc.types.Field(DeleteUnifiedUserAssignment, graphql_name='deleteUnifiedUserAssignment', args=sgqlc.types.ArgDict((
        ('object_mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='objectMcon', default=None)),
        ('unified_user_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='unifiedUserId', default=None)),
))
    )
    '''Associate a UnifiedUser with a CatalogObject

    Arguments:

    * `object_mcon` (`String!`): MCON of catalog object
    * `unified_user_id` (`String!`): UUID of UnifiedUser
    '''

    send_dbt_artifacts_event = sgqlc.types.Field('SendDbtArtifactsEvent', graphql_name='sendDbtArtifactsEvent', args=sgqlc.types.ArgDict((
        ('artifacts', sgqlc.types.Arg(sgqlc.types.non_null(DbtArtifactsInput), graphql_name='artifacts', default=None)),
        ('invocation_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='invocationId', default=None)),
        ('job_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='jobName', default=None)),
        ('project_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='projectName', default=None)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
))
    )
    '''Publish a Dbt artifacts event to Kinesis stream

    Arguments:

    * `artifacts` (`DbtArtifactsInput!`): Artifacts to publish
    * `invocation_id` (`UUID!`): dbt invocation id
    * `job_name` (`String!`): dbt job name
    * `project_name` (`String!`): dbt project name
    * `resource_id` (`UUID`): Optional resource uuid
    '''

    set_group_repetitive_dbt_model_failures = sgqlc.types.Field('SetGroupRepetitiveDbtModelFailures', graphql_name='setGroupRepetitiveDbtModelFailures', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
        ('group_repetitive_failures', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='groupRepetitiveFailures', default=None)),
))
    )
    '''Set whether to group dbt model failures with the same error
    message into the same incident

    Arguments:

    * `connection_id` (`UUID!`): dbt connection id
    * `group_repetitive_failures` (`Boolean!`): Failures with the same
      error message should be grouped together
    '''

    set_group_repetitive_dbt_test_failures = sgqlc.types.Field('SetGroupRepetitiveDbtTestFailures', graphql_name='setGroupRepetitiveDbtTestFailures', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
        ('group_repetitive_failures', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='groupRepetitiveFailures', default=None)),
))
    )
    '''Set whether to group dbt test failures with the same error message
    into the same incident

    Arguments:

    * `connection_id` (`UUID!`): dbt connection id
    * `group_repetitive_failures` (`Boolean!`): Failures with the same
      error message should be grouped together
    '''

    set_generates_incidents = sgqlc.types.Field('SetGeneratesIncidents', graphql_name='setGeneratesIncidents', args=sgqlc.types.ArgDict((
        ('generates_incidents', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='generatesIncidents', default=None)),
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Set whether a dbt project generates incidents

    Arguments:

    * `generates_incidents` (`Boolean!`): should generate incidents
    * `uuid` (`UUID!`): dbt project uuid
    '''

    set_job_generates_incidents = sgqlc.types.Field('SetJobGeneratesIncidents', graphql_name='setJobGeneratesIncidents', args=sgqlc.types.ArgDict((
        ('generates_incidents', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='generatesIncidents', default=None)),
        ('job_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='jobId', default=None)),
))
    )
    '''Set whether a dbt job generates incidents

    Arguments:

    * `generates_incidents` (`Boolean!`): should generate incidents
    * `job_id` (`UUID!`): dbt job id
    '''

    snooze_dbt_node = sgqlc.types.Field('SnoozeDbtNode', graphql_name='snoozeDbtNode', args=sgqlc.types.ArgDict((
        ('dbt_node_uuid', sgqlc.types.Arg(UUID, graphql_name='dbtNodeUuid', default=None)),
        ('snooze_minutes', sgqlc.types.Arg(Int, graphql_name='snoozeMinutes', default=None)),
))
    )
    '''Snooze a DBT node (model/test). Data collection will continue, but
    no events will be reported.

    Arguments:

    * `dbt_node_uuid` (`UUID`): UUID for DBT node to snooze
    * `snooze_minutes` (`Int`): Number of minutes to snooze
    '''

    unsnooze_dbt_node = sgqlc.types.Field('UnsnoozeDbtNode', graphql_name='unsnoozeDbtNode', args=sgqlc.types.ArgDict((
        ('dbt_node_uuid', sgqlc.types.Arg(UUID, graphql_name='dbtNodeUuid', default=None)),
))
    )
    '''Un-snooze a DBT node (model/test).

    Arguments:

    * `dbt_node_uuid` (`UUID`): UUID for DBT node to un-snooze
    '''

    update_dbt_project_info = sgqlc.types.Field('UpdateDbtProjectInfo', graphql_name='updateDbtProjectInfo', args=sgqlc.types.ArgDict((
        ('remote_url', sgqlc.types.Arg(String, graphql_name='remoteUrl', default=None)),
        ('subdirectory', sgqlc.types.Arg(String, graphql_name='subdirectory', default=None)),
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Set extra information about dbt project

    Arguments:

    * `remote_url` (`String`): Remote location of the project sources
    * `subdirectory` (`String`): Subdirectory of the project sources
    * `uuid` (`UUID!`): dbt project id
    '''

    create_or_update_monte_carlo_config_template = sgqlc.types.Field(CreateOrUpdateMonteCarloConfigTemplate, graphql_name='createOrUpdateMonteCarloConfigTemplate', args=sgqlc.types.ArgDict((
        ('config_template_json', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='configTemplateJson', default=None)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=None)),
        ('misconfigured_as_warning', sgqlc.types.Arg(Boolean, graphql_name='misconfiguredAsWarning', default=None)),
        ('namespace', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='namespace', default=None)),
        ('resource', sgqlc.types.Arg(String, graphql_name='resource', default=None)),
))
    )
    '''Create or update a Monte Carlo Config Template

    Arguments:

    * `config_template_json` (`String!`): Monte Carlo Template in JSON
      format
    * `dry_run` (`Boolean`): Dry run?
    * `misconfigured_as_warning` (`Boolean`): Misconfigured errors as
      warnings
    * `namespace` (`String!`): Namespace of config template
    * `resource` (`String`): Default resource (warehouse) ID or name
    '''

    create_or_update_monte_carlo_config_template_async = sgqlc.types.Field(CreateOrUpdateMonteCarloConfigTemplateAsync, graphql_name='createOrUpdateMonteCarloConfigTemplateAsync', args=sgqlc.types.ArgDict((
        ('config_template_json', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='configTemplateJson', default=None)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=None)),
        ('misconfigured_as_warning', sgqlc.types.Arg(Boolean, graphql_name='misconfiguredAsWarning', default=None)),
        ('namespace', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='namespace', default=None)),
        ('resource', sgqlc.types.Arg(String, graphql_name='resource', default=None)),
))
    )
    '''Create or update a Monte Carlo Config Template asynchronously

    Arguments:

    * `config_template_json` (`String!`): Monte Carlo Template in JSON
      format
    * `dry_run` (`Boolean`): Dry run?
    * `misconfigured_as_warning` (`Boolean`): Misconfigured errors as
      warnings
    * `namespace` (`String!`): Namespace of config template
    * `resource` (`String`): Default resource (warehouse) ID or name
    '''

    delete_monte_carlo_config_template = sgqlc.types.Field(DeleteMonteCarloConfigTemplate, graphql_name='deleteMonteCarloConfigTemplate', args=sgqlc.types.ArgDict((
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=None)),
        ('namespace', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='namespace', default=None)),
))
    )
    '''Delete a Monte Carlo Config Template

    Arguments:

    * `dry_run` (`Boolean`): Dry run?
    * `namespace` (`String!`): Namespace of config template
    '''

    convert_ui_monitors_to_config_template = sgqlc.types.Field(ConvertUiMonitorsToConfigTemplate, graphql_name='convertUiMonitorsToConfigTemplate', args=sgqlc.types.ArgDict((
        ('all_monitors', sgqlc.types.Arg(Boolean, graphql_name='allMonitors', default=False)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=False)),
        ('monitor_uuids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='monitorUuids', default=None)),
        ('namespace', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='namespace', default=None)),
))
    )
    '''Convert a set of monitors to a config template

    Arguments:

    * `all_monitors` (`Boolean`): Convert all UI monitors (default:
      `false`)
    * `dry_run` (`Boolean`): Dry run? (default: `false`)
    * `monitor_uuids` (`[UUID]`): Monitor IDs to convert
    * `namespace` (`String!`): Namespace of config template
    '''

    convert_config_template_to_ui_monitors = sgqlc.types.Field(ConvertConfigTemplateToUiMonitors, graphql_name='convertConfigTemplateToUiMonitors', args=sgqlc.types.ArgDict((
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=False)),
        ('namespace', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='namespace', default=None)),
))
    )
    '''Convert a config template to UI Monitors

    Arguments:

    * `dry_run` (`Boolean`): Dry run? (default: `false`)
    * `namespace` (`String!`): Namespace of config template
    '''

    set_sensitivity = sgqlc.types.Field('SetSensitivity', graphql_name='setSensitivity', args=sgqlc.types.ArgDict((
        ('event_type', sgqlc.types.Arg(String, graphql_name='eventType', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('monitor_uuid', sgqlc.types.Arg(UUID, graphql_name='monitorUuid', default=None)),
        ('threshold', sgqlc.types.Arg(SensitivityInput, graphql_name='threshold', default=None)),
))
    )
    '''Arguments:

    * `event_type` (`String`): event type for which to get/set
      sensitivity
    * `mcon` (`String`): MCON of the object (e.g. table) for which to
      get/set sensitivity
    * `monitor_uuid` (`UUID`): UUID of an associated monitor
    * `threshold` (`SensitivityInput`): Custom threshold definition
    '''

    add_to_collection_block_list = sgqlc.types.Field(AddToCollectionBlockList, graphql_name='addToCollectionBlockList', args=sgqlc.types.ArgDict((
        ('collection_blocks', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CollectionBlockInput)), graphql_name='collectionBlocks', default=None)),
))
    )
    '''Adds to the list of entities for which metadata collection is not
    allowed on this account.

    Arguments:

    * `collection_blocks` (`[CollectionBlockInput]!`): The entries to
      be added to the collection block list.
    '''

    remove_from_collection_block_list = sgqlc.types.Field('RemoveFromCollectionBlockList', graphql_name='removeFromCollectionBlockList', args=sgqlc.types.ArgDict((
        ('collection_blocks', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CollectionBlockInput)), graphql_name='collectionBlocks', default=None)),
))
    )
    '''Removes from the list of entities for which metadata collection is
    not allowed on this account.

    Arguments:

    * `collection_blocks` (`[CollectionBlockInput]!`): The entries to
      be removed from the collection block list.
    '''

    modify_collection_block_list = sgqlc.types.Field(sgqlc.types.list_of('CollectionBlock'), graphql_name='modifyCollectionBlockList', args=sgqlc.types.ArgDict((
        ('collection_blocks', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(ModifyCollectionBlockListInput)), graphql_name='collectionBlocks', default=None)),
        ('parent_scope', sgqlc.types.Arg(sgqlc.types.non_null(CollectionBlockListParentScopeInput), graphql_name='parentScope', default=None)),
        ('target_object_type', sgqlc.types.Arg(sgqlc.types.non_null(CollectionPreferenceTargetObjectType), graphql_name='targetObjectType', default=None)),
))
    )
    '''For an object type under a parent scope, modify the list of rules
    used to determine which objects are excluded from metadata
    collection. **Example:** To exclude ingestion for the 'analytics'
    project and all projects that start with 'prod_', make a request
    with these variables: {             "parentScope": {
    "resourceId": "9ed28eb2-6d21-4ad3-9d87-c05a3cb0f7e2"
    },             "targetObjectType": "project",
    "collectionBlocks": [                 {
    "resourceId": "9ed28eb2-6d21-4ad3-9d87-c05a3cb0f7e2",
    "project": "analytics",                     "matchType":
    "exact_match"                 },                 {
    "resourceId": "9ed28eb2-6d21-4ad3-9d87-c05a3cb0f7e2",
    "project": "prod_",                     "matchType": "prefix"
    }             ]         }

    Arguments:

    * `collection_blocks` (`[ModifyCollectionBlockListInput]!`): The
      complete list of rules for deciding which objects are excluded
      from metadata collection
    * `parent_scope` (`CollectionBlockListParentScopeInput!`): The
      direct parent scope of target objects
    * `target_object_type` (`CollectionPreferenceTargetObjectType!`):
      The type of object to apply the rules to
    '''

    create_custom_rule = sgqlc.types.Field(CreateCustomRule, graphql_name='createCustomRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('event_rollup_count', sgqlc.types.Arg(Int, graphql_name='eventRollupCount', default=None)),
        ('event_rollup_until_changed', sgqlc.types.Arg(Boolean, graphql_name='eventRollupUntilChanged', default=None)),
        ('interval_minutes', sgqlc.types.Arg(Int, graphql_name='intervalMinutes', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('schedule_config', sgqlc.types.Arg(ScheduleConfigInput, graphql_name='scheduleConfig', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default=None)),
))
    )
    '''Deprecated, use CreateOrUpdateCustomRule instead

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `description` (`String`): Used as the name in the UI
    * `dw_id` (`UUID`): Warehouse the tables are contained in.
      Required when using fullTableIds
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `interval_minutes` (`Int`): How often to run scheduled custom
      rule check (DEPRECATED, use schedule instead)
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `schedule_config` (`ScheduleConfigInput`): Schedule of custom
      rule
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    * `start_time` (`DateTime`): Start time of schedule (DEPRECATED,
      use schedule instead)
    * `timezone` (`String`): Timezone (DEPRECATED, use timezone in
      scheduleConfig instead
    '''

    create_or_update_custom_rule = sgqlc.types.Field(CreateOrUpdateCustomRule, graphql_name='createOrUpdateCustomRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('event_rollup_count', sgqlc.types.Arg(Int, graphql_name='eventRollupCount', default=None)),
        ('event_rollup_until_changed', sgqlc.types.Arg(Boolean, graphql_name='eventRollupUntilChanged', default=None)),
        ('interval_minutes', sgqlc.types.Arg(Int, graphql_name='intervalMinutes', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('schedule_config', sgqlc.types.Arg(ScheduleConfigInput, graphql_name='scheduleConfig', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default=None)),
))
    )
    '''Create or update a custom rule

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `description` (`String`): Used as the name in the UI
    * `dw_id` (`UUID`): Warehouse the tables are contained in.
      Required when using fullTableIds
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `interval_minutes` (`Int`): How often to run scheduled custom
      rule check (DEPRECATED, use schedule instead)
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `schedule_config` (`ScheduleConfigInput`): Schedule of custom
      rule
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    * `start_time` (`DateTime`): Start time of schedule (DEPRECATED,
      use schedule instead)
    * `timezone` (`String`): Timezone (DEPRECATED, use timezone in
      scheduleConfig instead
    '''

    create_or_update_volume_rule = sgqlc.types.Field(CreateOrUpdateVolumeRule, graphql_name='createOrUpdateVolumeRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('data_collection_schedule_config', sgqlc.types.Arg(ScheduleConfigInput, graphql_name='dataCollectionScheduleConfig', default=None)),
        ('description', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='description', default=None)),
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('event_rollup_count', sgqlc.types.Arg(Int, graphql_name='eventRollupCount', default=None)),
        ('event_rollup_until_changed', sgqlc.types.Arg(Boolean, graphql_name='eventRollupUntilChanged', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('override', sgqlc.types.Arg(Boolean, graphql_name='override', default=None)),
        ('schedule_config', sgqlc.types.Arg(sgqlc.types.non_null(ScheduleConfigInput), graphql_name='scheduleConfig', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default=None)),
))
    )
    '''Create or update a Volume Rule

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `data_collection_schedule_config` (`ScheduleConfigInput`): Data
      Collection schedule of custom rule
    * `description` (`String!`): Description of rule
    * `dw_id` (`UUID`): Warehouse the tables are contained in.
      Required when using fullTableIds
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `override` (`Boolean`): If override is set, it forces the dc
      schedule to run
    * `schedule_config` (`ScheduleConfigInput!`): Schedule of custom
      rule
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    * `timezone` (`String`): Timezone (DEPRECATED, use timezone in
      scheduleConfig instead
    '''

    create_custom_metric_rule = sgqlc.types.Field(CreateCustomMetricRule, graphql_name='createCustomMetricRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('custom_sampling_sql', sgqlc.types.Arg(String, graphql_name='customSamplingSql', default=None)),
        ('custom_sql', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='customSql', default=None)),
        ('description', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='description', default=None)),
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('event_rollup_count', sgqlc.types.Arg(Int, graphql_name='eventRollupCount', default=None)),
        ('event_rollup_until_changed', sgqlc.types.Arg(Boolean, graphql_name='eventRollupUntilChanged', default=None)),
        ('fail_on_reset', sgqlc.types.Arg(Boolean, graphql_name='failOnReset', default=False)),
        ('field_metric', sgqlc.types.Arg(FieldMetricInput, graphql_name='fieldMetric', default=None)),
        ('field_query_parameters', sgqlc.types.Arg(FieldQueryParametersInput, graphql_name='fieldQueryParameters', default=None)),
        ('interval_minutes', sgqlc.types.Arg(Int, graphql_name='intervalMinutes', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('query_result_type', sgqlc.types.Arg(QueryResultType, graphql_name='queryResultType', default=None)),
        ('query_template_id', sgqlc.types.Arg(String, graphql_name='queryTemplateId', default=None)),
        ('query_template_variable_values', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(QueryTemplateVariableValueInput)), graphql_name='queryTemplateVariableValues', default=None)),
        ('schedule_config', sgqlc.types.Arg(ScheduleConfigInput, graphql_name='scheduleConfig', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
        ('skip_reset', sgqlc.types.Arg(Boolean, graphql_name='skipReset', default=False)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default=None)),
        ('variables', sgqlc.types.Arg(JSONString, graphql_name='variables', default=None)),
))
    )
    '''Deprecated, use CreateOrUpdateCustomMetricRule instead

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `connection_id` (`UUID`): Specify a connection (e.g. query-
      engine) to use
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `custom_sampling_sql` (`String`): Custom sampling SQL query to
      run on breach
    * `custom_sql` (`String!`): Custom SQL query to run
    * `description` (`String!`): Description of rule
    * `dw_id` (`UUID!`): Warehouse UUID
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `fail_on_reset` (`Boolean`): Return an error if the update is a
      significant change that would require a monitor reset. (default:
      `false`)
    * `field_metric` (`FieldMetricInput`): (DEPRECATED). Field will be
      ignored if provided.
    * `field_query_parameters` (`FieldQueryParametersInput`): Field
      metric parameters (if query generated by getFieldQuery)
    * `interval_minutes` (`Int`): How often to run scheduled custom
      rule check (DEPRECATED, use schedule instead)
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `query_result_type` (`QueryResultType`): How the query result is
      used for the metric. Uses row count if unset.
    * `query_template_id` (`String`): ID for the template used to
      generate this query
    * `query_template_variable_values`
      (`[QueryTemplateVariableValueInput!]`): Values for the template
      variables. If not provided, the template source will be returned
    * `schedule_config` (`ScheduleConfigInput`): Schedule of custom
      rule
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    * `skip_reset` (`Boolean`): Do not reset monitor if the update is
      a significant change that would normally cause the monitor to be
      reset. Learned model might not match the new monitor
      configuration and false positives might be detected for up to 35
      days (default: `false`)
    * `start_time` (`DateTime`): Start time of schedule (DEPRECATED,
      use schedule instead)
    * `timezone` (`String`): Timezone (DEPRECATED, use timezone in
      scheduleConfig instead
    * `variables` (`JSONString`): Possible variable values for SQL
      query
    '''

    create_or_update_custom_metric_rule = sgqlc.types.Field(CreateOrUpdateCustomMetricRule, graphql_name='createOrUpdateCustomMetricRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('custom_sampling_sql', sgqlc.types.Arg(String, graphql_name='customSamplingSql', default=None)),
        ('custom_sql', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='customSql', default=None)),
        ('description', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='description', default=None)),
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('event_rollup_count', sgqlc.types.Arg(Int, graphql_name='eventRollupCount', default=None)),
        ('event_rollup_until_changed', sgqlc.types.Arg(Boolean, graphql_name='eventRollupUntilChanged', default=None)),
        ('fail_on_reset', sgqlc.types.Arg(Boolean, graphql_name='failOnReset', default=False)),
        ('field_metric', sgqlc.types.Arg(FieldMetricInput, graphql_name='fieldMetric', default=None)),
        ('field_query_parameters', sgqlc.types.Arg(FieldQueryParametersInput, graphql_name='fieldQueryParameters', default=None)),
        ('interval_minutes', sgqlc.types.Arg(Int, graphql_name='intervalMinutes', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('query_result_type', sgqlc.types.Arg(QueryResultType, graphql_name='queryResultType', default=None)),
        ('query_template_id', sgqlc.types.Arg(String, graphql_name='queryTemplateId', default=None)),
        ('query_template_variable_values', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(QueryTemplateVariableValueInput)), graphql_name='queryTemplateVariableValues', default=None)),
        ('schedule_config', sgqlc.types.Arg(ScheduleConfigInput, graphql_name='scheduleConfig', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
        ('skip_reset', sgqlc.types.Arg(Boolean, graphql_name='skipReset', default=False)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default=None)),
        ('variables', sgqlc.types.Arg(JSONString, graphql_name='variables', default=None)),
))
    )
    '''Create or update a custom metric rule

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `connection_id` (`UUID`): Specify a connection (e.g. query-
      engine) to use
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `custom_sampling_sql` (`String`): Custom sampling SQL query to
      run on breach
    * `custom_sql` (`String!`): Custom SQL query to run
    * `description` (`String!`): Description of rule
    * `dw_id` (`UUID!`): Warehouse UUID
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `fail_on_reset` (`Boolean`): Return an error if the update is a
      significant change that would require a monitor reset. (default:
      `false`)
    * `field_metric` (`FieldMetricInput`): (DEPRECATED). Field will be
      ignored if provided.
    * `field_query_parameters` (`FieldQueryParametersInput`): Field
      metric parameters (if query generated by getFieldQuery)
    * `interval_minutes` (`Int`): How often to run scheduled custom
      rule check (DEPRECATED, use schedule instead)
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `query_result_type` (`QueryResultType`): How the query result is
      used for the metric. Uses row count if unset.
    * `query_template_id` (`String`): ID for the template used to
      generate this query
    * `query_template_variable_values`
      (`[QueryTemplateVariableValueInput!]`): Values for the template
      variables. If not provided, the template source will be returned
    * `schedule_config` (`ScheduleConfigInput`): Schedule of custom
      rule
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    * `skip_reset` (`Boolean`): Do not reset monitor if the update is
      a significant change that would normally cause the monitor to be
      reset. Learned model might not match the new monitor
      configuration and false positives might be detected for up to 35
      days (default: `false`)
    * `start_time` (`DateTime`): Start time of schedule (DEPRECATED,
      use schedule instead)
    * `timezone` (`String`): Timezone (DEPRECATED, use timezone in
      scheduleConfig instead
    * `variables` (`JSONString`): Possible variable values for SQL
      query
    '''

    create_or_update_comparison_rule = sgqlc.types.Field(CreateOrUpdateComparisonRule, graphql_name='createOrUpdateComparisonRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('description', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='description', default=None)),
        ('event_rollup_count', sgqlc.types.Arg(Int, graphql_name='eventRollupCount', default=None)),
        ('event_rollup_until_changed', sgqlc.types.Arg(Boolean, graphql_name='eventRollupUntilChanged', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('query_result_type', sgqlc.types.Arg(sgqlc.types.non_null(QueryResultType), graphql_name='queryResultType', default=None)),
        ('schedule_config', sgqlc.types.Arg(sgqlc.types.non_null(ScheduleConfigInput), graphql_name='scheduleConfig', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
        ('source_connection_id', sgqlc.types.Arg(UUID, graphql_name='sourceConnectionId', default=None)),
        ('source_dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='sourceDwId', default=None)),
        ('source_sql_query', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='sourceSqlQuery', default=None)),
        ('target_connection_id', sgqlc.types.Arg(UUID, graphql_name='targetConnectionId', default=None)),
        ('target_dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='targetDwId', default=None)),
        ('target_sql_query', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='targetSqlQuery', default=None)),
))
    )
    '''Create or update a comparison rule

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `description` (`String!`): Description of rule
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `query_result_type` (`QueryResultType!`): Specifies query result
      format for generating metrics
    * `schedule_config` (`ScheduleConfigInput!`): Schedule of custom
      rule
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    * `source_connection_id` (`UUID`): Connection (i.e. query-engine)
      to use for source query
    * `source_dw_id` (`UUID!`): Warehouse UUID for source query
    * `source_sql_query` (`String!`): Query to generate source metric
    * `target_connection_id` (`UUID`): Connection (i.e. query-engine)
      to use for target query
    * `target_dw_id` (`UUID!`): Warehouse UUID for target query
    * `target_sql_query` (`String!`): Query to generate target metric
    '''

    create_or_update_query_perf_rule = sgqlc.types.Field(CreateOrUpdateQueryPerfRule, graphql_name='createOrUpdateQueryPerfRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('description', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='description', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default=None)),
        ('rule_name', sgqlc.types.Arg(String, graphql_name='ruleName', default=None)),
        ('selection', sgqlc.types.Arg(sgqlc.types.non_null(QuerySelectionInput), graphql_name='selection', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
))
    )
    '''Create or update query performance rule/monitor.
    There must be exactly (3) comparisons, which follow this format:
    {                 "comparisonType": "QUERY_PERFORMANCE",
    "operator": "GT",                 "metric": "runtime",
    "threshold": <THRESHOLD IN SECONDS>,             },             {
    "comparisonType": "QUERY_PERFORMANCE",                 "operator":
    "GT",                 "metric": "runtime_change",
    "threshold": <THRESHOLD AS PERCENTAGE>,
    "baselineAggFunction": <MEDIAN|AVG>,
    "thresholdLookbackDataPoints": <NUMBER OF DATA POINTS TO INCLUDE
    IN LOOKBACK RANGE>,             },             {
    "comparisonType": "QUERY_PERFORMANCE",                 "operator":
    "GT",                 "metric": "consecutive_breach_count",
    "threshold": <NUMBER OF CONSECUTIVE BREACHES TO TRIGGER AN ALERT>,
    }

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `description` (`String!`): Description of rule
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the rule
    * `rule_name` (`String`): Rule Name
    * `selection` (`QuerySelectionInput!`): Selection of the monitored
      queries
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    '''

    update_custom_metric_rule_notes = sgqlc.types.Field('UpdateCustomMetricRuleNotes', graphql_name='updateCustomMetricRuleNotes', args=sgqlc.types.ArgDict((
        ('custom_rule_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='customRuleUuid', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default=None)),
))
    )
    '''Create or update notes for custom metric rule

    Arguments:

    * `custom_rule_uuid` (`UUID!`): UUID of custom rule, to update
      existing rule
    * `notes` (`String`): Additional context for the custom SQL rule
    '''

    update_custom_metric_severity = sgqlc.types.Field('UpdateCustomMetricSeverity', graphql_name='updateCustomMetricSeverity', args=sgqlc.types.ArgDict((
        ('custom_rule_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='customRuleUuid', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default=None)),
))
    )
    '''Create or update default severity for custom metric rule

    Arguments:

    * `custom_rule_uuid` (`UUID!`): UUID of custom rule, to update
      existing rule
    * `severity` (`String`): System set severity when an incident for
      the rule is created
    '''

    create_or_update_freshness_custom_rule = sgqlc.types.Field(CreateOrUpdateFreshnessCustomRule, graphql_name='createOrUpdateFreshnessCustomRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('event_rollup_count', sgqlc.types.Arg(Int, graphql_name='eventRollupCount', default=None)),
        ('event_rollup_until_changed', sgqlc.types.Arg(Boolean, graphql_name='eventRollupUntilChanged', default=None)),
        ('interval_minutes', sgqlc.types.Arg(Int, graphql_name='intervalMinutes', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('schedule_config', sgqlc.types.Arg(ScheduleConfigInput, graphql_name='scheduleConfig', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default=None)),
))
    )
    '''Create or update a freshness custom rule

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `description` (`String`): Used as the name in the UI
    * `dw_id` (`UUID`): Warehouse the tables are contained in.
      Required when using fullTableIds
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `interval_minutes` (`Int`): How often to run scheduled custom
      rule check (DEPRECATED, use schedule instead)
    * `labels` (`[String]`): The monitor labels
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `schedule_config` (`ScheduleConfigInput`): Schedule of custom
      rule
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    * `start_time` (`DateTime`): Start time of schedule (DEPRECATED,
      use schedule instead)
    * `timezone` (`String`): Timezone (DEPRECATED, use timezone in
      scheduleConfig instead
    '''

    snooze_custom_rule = sgqlc.types.Field('SnoozeCustomRule', graphql_name='snoozeCustomRule', args=sgqlc.types.ArgDict((
        ('snooze_minutes', sgqlc.types.Arg(Int, graphql_name='snoozeMinutes', default=None)),
        ('snooze_type', sgqlc.types.Arg(CustomRuleSnoozeInput, graphql_name='snoozeType', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Snooze a custom rule. Data collection will continue, but no
    anomalies will be reported.

    Arguments:

    * `snooze_minutes` (`Int`): Number of minutes to snooze rule -
      deprecated by snooze_type
    * `snooze_type` (`CustomRuleSnoozeInput`): Choose regular snooze
      or conditional snooze options
    * `uuid` (`UUID`): UUID for rule to snooze - deprecated by
      snooze_type
    '''

    unsnooze_custom_rule = sgqlc.types.Field('UnsnoozeCustomRule', graphql_name='unsnoozeCustomRule', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Un-snooze a custom rule.

    Arguments:

    * `uuid` (`UUID`): UUID for rule to un-snooze
    '''

    delete_custom_rule = sgqlc.types.Field(DeleteCustomRule, graphql_name='deleteCustomRule', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
        ('warehouse_uuid', sgqlc.types.Arg(UUID, graphql_name='warehouseUuid', default=None)),
))
    )
    '''Delete a custom rule

    Arguments:

    * `uuid` (`UUID`): UUID for rule to delete
    * `warehouse_uuid` (`UUID`): Deprecated
    '''

    trigger_custom_rule = sgqlc.types.Field('TriggerCustomRule', graphql_name='triggerCustomRule', args=sgqlc.types.ArgDict((
        ('custom_sql_contains', sgqlc.types.Arg(String, graphql_name='customSqlContains', default=None)),
        ('description_contains', sgqlc.types.Arg(String, graphql_name='descriptionContains', default=None)),
        ('rule_id', sgqlc.types.Arg(UUID, graphql_name='ruleId', default=None)),
))
    )
    '''Run a custom rule immediately

    Arguments:

    * `custom_sql_contains` (`String`): String to completely or
      partially match the rule SQL, case-insensitive
    * `description_contains` (`String`): String to completely or
      partially match the rule description, case-insensitive
    * `rule_id` (`UUID`): Rule id
    '''

    trigger_circuit_breaker_rule = sgqlc.types.Field('TriggerCircuitBreakerRule', graphql_name='triggerCircuitBreakerRule', args=sgqlc.types.ArgDict((
        ('namespace', sgqlc.types.Arg(String, graphql_name='namespace', default=None)),
        ('rule_name', sgqlc.types.Arg(String, graphql_name='ruleName', default=None)),
        ('rule_uuid', sgqlc.types.Arg(UUID, graphql_name='ruleUuid', default=None)),
))
    )
    '''Run a custom rule as a circuit breaker immediately. Supports rules
    that create a single query.

    Arguments:

    * `namespace` (`String`): Namespace
    * `rule_name` (`String`): Rule Name
    * `rule_uuid` (`UUID`): Rule UUID
    '''

    trigger_circuit_breaker_rule_v2 = sgqlc.types.Field('TriggerCircuitBreakerRuleV2', graphql_name='triggerCircuitBreakerRuleV2', args=sgqlc.types.ArgDict((
        ('namespace', sgqlc.types.Arg(String, graphql_name='namespace', default=None)),
        ('rule_name', sgqlc.types.Arg(String, graphql_name='ruleName', default=None)),
        ('rule_uuid', sgqlc.types.Arg(UUID, graphql_name='ruleUuid', default=None)),
))
    )
    '''Run a custom rule as a circuit breaker immediately. Supports rules
    that create multiple queries.

    Arguments:

    * `namespace` (`String`): Namespace
    * `rule_name` (`String`): Rule Name
    * `rule_uuid` (`UUID`): Rule UUID
    '''

    run_sql_rule = sgqlc.types.Field('RunSqlRule', graphql_name='runSqlRule', args=sgqlc.types.ArgDict((
        ('rule_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='ruleUuid', default=None)),
))
    )
    '''Run a SQL Rule manually

    Arguments:

    * `rule_uuid` (`UUID!`): Rule UUID
    '''

    pause_rule = sgqlc.types.Field('PauseRule', graphql_name='pauseRule', args=sgqlc.types.ArgDict((
        ('pause', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='pause', default=None)),
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Pause a rule from collecting data or triggering notifications

    Arguments:

    * `pause` (`Boolean!`): Pause state of the monitor.
    * `uuid` (`UUID!`): UUID of the rule whose skip status is being
      changed.
    '''

    update_custom_rule_investigation_query = sgqlc.types.Field('UpdateCustomRuleInvestigationQuery', graphql_name='updateCustomRuleInvestigationQuery', args=sgqlc.types.ArgDict((
        ('custom_sampling_sql', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='customSamplingSql', default=None)),
        ('rule_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='ruleUuid', default=None)),
))
    )
    '''Update a rule's investigation query

    Arguments:

    * `custom_sampling_sql` (`String!`): The new investigation query
    * `rule_uuid` (`UUID!`): The UUID of the rule to update
    '''

    create_or_update_lineage_node = sgqlc.types.Field(CreateOrUpdateLineageNode, graphql_name='createOrUpdateLineageNode', args=sgqlc.types.ArgDict((
        ('expire_at', sgqlc.types.Arg(DateTime, graphql_name='expireAt', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
        ('object_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='objectId', default=None)),
        ('object_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='objectType', default=None)),
        ('properties', sgqlc.types.Arg(sgqlc.types.list_of(ObjectPropertyInput), graphql_name='properties', default=None)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('resource_name', sgqlc.types.Arg(String, graphql_name='resourceName', default=None)),
))
    )
    '''Create or update a lineage node

    Arguments:

    * `expire_at` (`DateTime`): When the node will expire. If not
      provided, the node will expire 7 days fromcreation.
    * `name` (`String`): Object name (table name, report name, etc)
    * `object_id` (`String!`): Object identifier
    * `object_type` (`String!`): Object type
    * `properties` (`[ObjectPropertyInput]`): A list of object
      properties to be indexed by the search service
    * `resource_id` (`UUID`): The id of the resource containing the
      node
    * `resource_name` (`String`): The name of the resource containing
      the node
    '''

    create_or_update_lineage_edge = sgqlc.types.Field(CreateOrUpdateLineageEdge, graphql_name='createOrUpdateLineageEdge', args=sgqlc.types.ArgDict((
        ('destination', sgqlc.types.Arg(sgqlc.types.non_null(NodeInput), graphql_name='destination', default=None)),
        ('expire_at', sgqlc.types.Arg(DateTime, graphql_name='expireAt', default=None)),
        ('source', sgqlc.types.Arg(sgqlc.types.non_null(NodeInput), graphql_name='source', default=None)),
))
    )
    '''Create or update a lineage edge

    Arguments:

    * `destination` (`NodeInput!`): The destination node
    * `expire_at` (`DateTime`): When the edge will expire. If not
      provided, the node will expire 7 days from creation.
    * `source` (`NodeInput!`): The source node
    '''

    create_or_update_lineage_node_block_pattern = sgqlc.types.Field(CreateOrUpdateLineageNodeBlockPattern, graphql_name='createOrUpdateLineageNodeBlockPattern', args=sgqlc.types.ArgDict((
        ('dataset_regexp', sgqlc.types.Arg(String, graphql_name='datasetRegexp', default=None)),
        ('project_regexp', sgqlc.types.Arg(String, graphql_name='projectRegexp', default=None)),
        ('resource_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='resourceId', default=None)),
        ('table_regexp', sgqlc.types.Arg(String, graphql_name='tableRegexp', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update a node block pattern

    Arguments:

    * `dataset_regexp` (`String`): Block datasets matching the regexp
    * `project_regexp` (`String`): Block projects matching the regexp
    * `resource_id` (`UUID!`): The id of the resource containing the
      node
    * `table_regexp` (`String`): Block tables matching the regexp
    * `uuid` (`UUID`): The pattern UUID (updates only)
    '''

    create_or_update_lineage_node_replacement_rule = sgqlc.types.Field(CreateOrUpdateLineageNodeReplacementRule, graphql_name='createOrUpdateLineageNodeReplacementRule', args=sgqlc.types.ArgDict((
        ('case_insensitive', sgqlc.types.Arg(Boolean, graphql_name='caseInsensitive', default=None)),
        ('pattern', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='pattern', default=None)),
        ('replacement', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='replacement', default=None)),
        ('resource_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='resourceId', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update a node replacement rule

    Arguments:

    * `case_insensitive` (`Boolean`): Case sensitivity of the pattern
      matching
    * `pattern` (`String!`): Modify canonical name by replacing the
      pattern with replacement
    * `replacement` (`String!`): Modify canonical name by replacing
      the pattern with replacement
    * `resource_id` (`UUID!`): The id of the resource containing the
      node
    * `uuid` (`UUID`): The rule UUID (updates only)
    '''

    create_or_update_lineage_node_collapsing_rule = sgqlc.types.Field(CreateOrUpdateLineageNodeCollapsingRule, graphql_name='createOrUpdateLineageNodeCollapsingRule', args=sgqlc.types.ArgDict((
        ('case_insensitive', sgqlc.types.Arg(Boolean, graphql_name='caseInsensitive', default=False)),
        ('pattern', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='pattern', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update a node collapsing rule

    Arguments:

    * `case_insensitive` (`Boolean`): Case sensitivity of the pattern
      matching (default: `false`)
    * `pattern` (`String!`): Nodes which canonical name matches the
      pattern will be marked as collapsible
    * `uuid` (`UUID`): The rule UUID (updates only)
    '''

    delete_lineage_node = sgqlc.types.Field(DeleteLineageNode, graphql_name='deleteLineageNode', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Delete a lineage node and any lineage edges connected to it.

    Arguments:

    * `mcon` (`String!`): The MCON of the node to be deleted
    '''

    delete_lineage_node_block_pattern = sgqlc.types.Field(DeleteLineageNodeBlockPattern, graphql_name='deleteLineageNodeBlockPattern', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Delete a lineage node block pattern.

    Arguments:

    * `uuid` (`UUID!`): The UUID of the pattern to delete
    '''

    delete_lineage_node_replacement_rule = sgqlc.types.Field(DeleteLineageNodeReplacementRule, graphql_name='deleteLineageNodeReplacementRule', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Delete a lineage node replacement rule

    Arguments:

    * `uuid` (`UUID!`): The UUID of the replacement rule to delete
    '''

    delete_lineage_node_collapsing_rule = sgqlc.types.Field(DeleteLineageNodeCollapsingRule, graphql_name='deleteLineageNodeCollapsingRule', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Delete a lineage node collapsing rule

    Arguments:

    * `uuid` (`UUID!`): The UUID of the collapsing rule to delete
    '''

    create_or_update_field_quality_rule = sgqlc.types.Field(CreateOrUpdateFieldQualityRule, graphql_name='createOrUpdateFieldQualityRule', args=sgqlc.types.ArgDict((
        ('comparisons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(CustomRuleComparisonInput)), graphql_name='comparisons', default=None)),
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(UUID, graphql_name='customRuleUuid', default=None)),
        ('description', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='description', default=None)),
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('event_rollup_count', sgqlc.types.Arg(Int, graphql_name='eventRollupCount', default=None)),
        ('event_rollup_until_changed', sgqlc.types.Arg(Boolean, graphql_name='eventRollupUntilChanged', default=None)),
        ('field_names', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='fieldNames', default=None)),
        ('filters', sgqlc.types.Arg(sgqlc.types.list_of(FieldMetricFilterInput), graphql_name='filters', default=None)),
        ('interval_minutes', sgqlc.types.Arg(Int, graphql_name='intervalMinutes', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('metric_type', sgqlc.types.Arg(sgqlc.types.non_null(FieldMetricType), graphql_name='metricType', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('schedule_config', sgqlc.types.Arg(sgqlc.types.non_null(ScheduleConfigInput), graphql_name='scheduleConfig', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default='')),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('table_mcons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='tableMcons', default=None)),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default=None)),
))
    )
    '''Create or update a field quality rule

    Arguments:

    * `comparisons` (`[CustomRuleComparisonInput]!`): Custom rule
      comparisons
    * `connection_id` (`UUID`): Specify a connection (e.g. query-
      engine) to use
    * `custom_rule_uuid` (`UUID`): UUID of custom rule, to update
      existing rule
    * `description` (`String!`): Description of rule
    * `dw_id` (`UUID!`): Warehouse UUID
    * `event_rollup_count` (`Int`): The number of events to roll up
      into a single incident
    * `event_rollup_until_changed` (`Boolean`): If true, roll up
      events until the value changes
    * `field_names` (`[String]!`): Fields to monitor
    * `filters` (`[FieldMetricFilterInput]`): Filters for which rows
      the metric is computed over
    * `interval_minutes` (`Int`): How often to run scheduled custom
      rule check (DEPRECATED, use schedule instead)
    * `labels` (`[String]`): The monitor labels
    * `metric_type` (`FieldMetricType!`): Type of metric to compute
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `schedule_config` (`ScheduleConfigInput!`): Schedule of the
      field quality rule
    * `severity` (`String`): The default severity for incidents
      involving this monitor (default: `""`)
    * `start_time` (`DateTime`): Start time of schedule (DEPRECATED,
      use schedule instead)
    * `table_mcons` (`[String]!`): MCON of tables to monitor
    * `timezone` (`String`): Timezone (DEPRECATED, use timezone in
      scheduleConfig instead
    '''

    create_or_update_catalog_object_metadata = sgqlc.types.Field(CreateOrUpdateCatalogObjectMetadata, graphql_name='createOrUpdateCatalogObjectMetadata', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='description', default=None)),
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Create or update an asset's metadata

    Arguments:

    * `description` (`String!`): Description of object
    * `mcon` (`String!`): Monte Carlo full identifier for an entity
    '''

    delete_catalog_object_metadata = sgqlc.types.Field(DeleteCatalogObjectMetadata, graphql_name='deleteCatalogObjectMetadata', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Delete metadata for an asset

    Arguments:

    * `mcon` (`String!`): Monte Carlo full identifier for an entity
    '''

    create_or_update_object_property = sgqlc.types.Field(CreateOrUpdateObjectProperty, graphql_name='createOrUpdateObjectProperty', args=sgqlc.types.ArgDict((
        ('mcon_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mconId', default=None)),
        ('property_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='propertyName', default=None)),
        ('property_source_type', sgqlc.types.Arg(String, graphql_name='propertySourceType', default='dashboard')),
        ('property_value', sgqlc.types.Arg(String, graphql_name='propertyValue', default=None)),
))
    )
    '''Create or update properties (tags) for objects (e.g. tables,
    fields, etc.)

    Arguments:

    * `mcon_id` (`String!`): Monte Carlo full identifier for an entity
    * `property_name` (`String!`): Name of the property (AKA tag key)
    * `property_source_type` (`String`): Where property originated.
      (default: `"dashboard"`)
    * `property_value` (`String`): Value of the property (AKA tag
      value)
    '''

    delete_object_property = sgqlc.types.Field(DeleteObjectProperty, graphql_name='deleteObjectProperty', args=sgqlc.types.ArgDict((
        ('mcon_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mconId', default=None)),
        ('property_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='propertyName', default=None)),
        ('property_source_type', sgqlc.types.Arg(String, graphql_name='propertySourceType', default='dashboard')),
))
    )
    '''Delete properties (tags) for objects (e.g. tables, fields, etc.)

    Arguments:

    * `mcon_id` (`String!`): Monte Carlo full identifier for an entity
    * `property_name` (`String!`): Name of the property (AKA tag key)
    * `property_source_type` (`String`): Where property originated.
      (default: `"dashboard"`)
    '''

    bulk_create_or_update_object_properties = sgqlc.types.Field(BulkCreateOrUpdateObjectProperties, graphql_name='bulkCreateOrUpdateObjectProperties', args=sgqlc.types.ArgDict((
        ('input_object_properties', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(InputObjectProperty)), graphql_name='inputObjectProperties', default=None)),
))
    )
    '''Create or update a list of properties (tags) for objects (e.g.
    tables, fields, etc.)

    Arguments:

    * `input_object_properties` (`[InputObjectProperty]!`): List of
      object properties to create and update
    '''

    create_or_update_monitor_label = sgqlc.types.Field(CreateOrUpdateMonitorLabel, graphql_name='createOrUpdateMonitorLabel', args=sgqlc.types.ArgDict((
        ('label', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='label', default=None)),
        ('monitor_uuids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='monitorUuids', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update a monitor label

    Arguments:

    * `label` (`String!`): The monitor label name
    * `monitor_uuids` (`[UUID]`): If any monitor IDs are given, add
      this label to those monitors; additive only, does not remove the
      label from other monitors
    * `uuid` (`UUID`): The monitor label ID
    '''

    delete_monitor_label = sgqlc.types.Field(DeleteMonitorLabel, graphql_name='deleteMonitorLabel', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Delete a monitor label

    Arguments:

    * `uuid` (`UUID!`): The monitor label ID
    '''

    add_monitors_labels = sgqlc.types.Field(AddMonitorsLabels, graphql_name='addMonitorsLabels', args=sgqlc.types.ArgDict((
        ('labels', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='labels', default=None)),
        ('monitor_uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='monitorUuids', default=None)),
))
    )
    '''Arguments:

    * `labels` (`[String]!`): Labels to add on the monitors
    * `monitor_uuids` (`[UUID]!`): UUID of the monitors to update
    '''

    remove_monitors_labels = sgqlc.types.Field('RemoveMonitorsLabels', graphql_name='removeMonitorsLabels', args=sgqlc.types.ArgDict((
        ('labels', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='labels', default=None)),
        ('monitor_uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='monitorUuids', default=None)),
))
    )
    '''Arguments:

    * `labels` (`[String]!`): Labels to remove from the monitors
    * `monitor_uuids` (`[UUID]!`): UUID of the monitors to update
    '''

    create_or_update_custom_sql_template = sgqlc.types.Field(CreateOrUpdateCustomSQLTemplate, graphql_name='createOrUpdateCustomSqlTemplate', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('dialect', sgqlc.types.Arg(String, graphql_name='dialect', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
        ('query_result_type', sgqlc.types.Arg(QueryResultType, graphql_name='queryResultType', default=None)),
        ('sql_template', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='sqlTemplate', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update custom sql template

    Arguments:

    * `description` (`String`): Description of custom sql template
    * `dialect` (`String`): Dialect of custom sql template
    * `name` (`String`): Name of custom sql template
    * `query_result_type` (`QueryResultType`): CustomSQLTemplate's
      query result type can be set to SINGLE_NUMERIC, ROW_COUNT and
      LABELED_NUMERICS. The result is ROW_COUNT if unset
    * `sql_template` (`String!`): SQL template of custom sql template
    * `uuid` (`UUID`): UUID of custom sql template
    '''

    delete_custom_sql_template = sgqlc.types.Field(DeleteCustomSQLTemplate, graphql_name='deleteCustomSqlTemplate', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Delete custom sql template

    Arguments:

    * `uuid` (`UUID`): uuid of custom sql template
    '''

    stop_monitor = sgqlc.types.Field('StopMonitor', graphql_name='stopMonitor', args=sgqlc.types.ArgDict((
        ('monitor_id', sgqlc.types.Arg(UUID, graphql_name='monitorId', default=None)),
))
    )
    '''Deletes a monitor

    Arguments:

    * `monitor_id` (`UUID`)None
    '''

    delete_monitor = sgqlc.types.Field(DeleteMonitor, graphql_name='deleteMonitor', args=sgqlc.types.ArgDict((
        ('monitor_id', sgqlc.types.Arg(UUID, graphql_name='monitorId', default=None)),
))
    )
    '''Deletes a monitor

    Arguments:

    * `monitor_id` (`UUID`)None
    '''

    trigger_monitor = sgqlc.types.Field('TriggerMonitor', graphql_name='triggerMonitor', args=sgqlc.types.ArgDict((
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('monitor_type', sgqlc.types.Arg(String, graphql_name='monitorType', default=None)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Deletes a monitor

    Arguments:

    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Trigger monitor by mcon
    * `monitor_type` (`String`): Specify the monitor type. Required
      when using an mcon or full table id
    * `resource_id` (`UUID`): Specify the resource uuid (e.g.
      warehouse the table is contained in) when using a fullTableId
    * `uuid` (`UUID`): Trigger monitor by a UUID
    '''

    create_or_update_monitor = sgqlc.types.Field(CreateOrUpdateMonitor, graphql_name='createOrUpdateMonitor', args=sgqlc.types.ArgDict((
        ('agg_select_expression', sgqlc.types.Arg(String, graphql_name='aggSelectExpression', default=None)),
        ('agg_time_interval', sgqlc.types.Arg(MonitorAggTimeInterval, graphql_name='aggTimeInterval', default=None)),
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('disable_look_back_bootstrap', sgqlc.types.Arg(Boolean, graphql_name='disableLookBackBootstrap', default=False)),
        ('fail_on_reset', sgqlc.types.Arg(Boolean, graphql_name='failOnReset', default=False)),
        ('failed_schedule_account_notification_id', sgqlc.types.Arg(UUID, graphql_name='failedScheduleAccountNotificationId', default=None)),
        ('fields', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='fields', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('lookback_days', sgqlc.types.Arg(Int, graphql_name='lookbackDays', default=1)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('min_segment_size', sgqlc.types.Arg(Int, graphql_name='minSegmentSize', default=None)),
        ('monitor_type', sgqlc.types.Arg(String, graphql_name='monitorType', default=None)),
        ('notes', sgqlc.types.Arg(String, graphql_name='notes', default='')),
        ('notify_rule_run_failure', sgqlc.types.Arg(Boolean, graphql_name='notifyRuleRunFailure', default=False)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('schedule_config', sgqlc.types.Arg(ScheduleConfigInput, graphql_name='scheduleConfig', default=None)),
        ('segmented_expressions', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='segmentedExpressions', default=None)),
        ('select_expressions', sgqlc.types.Arg(sgqlc.types.list_of(MonitorSelectExpressionInput), graphql_name='selectExpressions', default=None)),
        ('selected_metrics', sgqlc.types.Arg(sgqlc.types.list_of(FieldHealthMetrics), graphql_name='selectedMetrics', default=None)),
        ('severity', sgqlc.types.Arg(String, graphql_name='severity', default=None)),
        ('skip_reset', sgqlc.types.Arg(Boolean, graphql_name='skipReset', default=False)),
        ('time_axis_name', sgqlc.types.Arg(String, graphql_name='timeAxisName', default=None)),
        ('time_axis_type', sgqlc.types.Arg(String, graphql_name='timeAxisType', default=None)),
        ('unnest_fields', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='unnestFields', default=None)),
        ('use_partition_clause', sgqlc.types.Arg(Boolean, graphql_name='usePartitionClause', default=False)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
        ('where_condition', sgqlc.types.Arg(String, graphql_name='whereCondition', default=None)),
))
    )
    '''Arguments:

    * `agg_select_expression` (`String`): For dimension monitoring,
      the aggregation select expression to use (defaults to COUNT(*))
    * `agg_time_interval` (`MonitorAggTimeInterval`): For field health
      and dimension monitoring, the aggregation time interval to use.
      Either HOUR or DAY (defaults to HOUR)
    * `connection_id` (`UUID`): Specify a connection (e.g. query-
      engine) to use
    * `description` (`String`): Used as the name in the UI
    * `disable_look_back_bootstrap` (`Boolean`): The flag decides
      whether to disable look back bootstrap for new monitors. By
      default, it's False (default: `false`)
    * `fail_on_reset` (`Boolean`): Return an error if the update is a
      significant change that would require a monitor reset. (default:
      `false`)
    * `failed_schedule_account_notification_id` (`UUID`): Account
      notification to be used when the monitor's scheduled executions
      fail.
    * `fields` (`[String]`): Fields to monitor. DEPRECATED, use
      select_expressions instead.
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `labels` (`[String]`): The monitor labels
    * `lookback_days` (`Int`): Look-back period in days (to be applied
      by time axis) (default: `1`)
    * `mcon` (`String`): Mcon of table to create monitor for
    * `min_segment_size` (`Int`): Minimum number of rows for a segment
      to be retrieved. Segments with less rows than this will be
      discarded.
    * `monitor_type` (`String`): Type of monitor to create
    * `notes` (`String`): Additional context for the monitor (default:
      `""`)
    * `notify_rule_run_failure` (`Boolean`): The flag decides whether
      to send run failure notifications to audiences (default:
      `false`)
    * `resource_id` (`UUID`): Resource (e.g. warehouse) the table is
      contained in. Required when using a fullTableId
    * `schedule_config` (`ScheduleConfigInput`): Schedule of monitor
    * `segmented_expressions` (`[String]`): Fields or expressions used
      to segment the monitored field (currently supports one such
      value)
    * `select_expressions` (`[MonitorSelectExpressionInput]`): Monitor
      select expressions
    * `selected_metrics` (`[FieldHealthMetrics]`): Only monitor the
      selected metrics. If empty, all metrics will be monitored. Only
      available for Field Health monitors.
    * `severity` (`String`): The default severity for incidents
      involving this monitor
    * `skip_reset` (`Boolean`): Do not reset monitor if the update is
      a significant change that would normally cause the monitor to be
      reset. Learned model might not match the new monitor
      configuration and false positives might be detected for up to 35
      days (default: `false`)
    * `time_axis_name` (`String`): Time axis name
    * `time_axis_type` (`String`): Time axis type
    * `unnest_fields` (`[String]`): Fields to unnest
    * `use_partition_clause` (`Boolean`): Whether to use automatic
      partition filter in query (default: `false`)
    * `uuid` (`UUID`): UUID of the monitor. If specified, it means the
      request is for update
    * `where_condition` (`String`): SQL WHERE condition to apply to
      query
    '''

    pause_monitor = sgqlc.types.Field('PauseMonitor', graphql_name='pauseMonitor', args=sgqlc.types.ArgDict((
        ('pause', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='pause', default=None)),
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Pause a monitor from collecting data.'

    Arguments:

    * `pause` (`Boolean!`): Pause state of the monitor.
    * `uuid` (`UUID!`): UUID of the monitor whose skip status is being
      changed.
    '''

    validate_cron = sgqlc.types.Field('ValidateCron', graphql_name='validateCron', args=sgqlc.types.ArgDict((
        ('allow_multiple', sgqlc.types.Arg(Boolean, graphql_name='allowMultiple', default=None)),
        ('cron', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='cron', default=None)),
))
    )
    '''Validate a CRON expression

    Arguments:

    * `allow_multiple` (`Boolean`): Allow multiple CRON expressions
    * `cron` (`String!`): CRON expression
    '''

    create_event_comment = sgqlc.types.Field('createEventComment', graphql_name='createEventComment', args=sgqlc.types.ArgDict((
        ('event_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='eventId', default=None)),
        ('event_text', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='eventText', default=None)),
))
    )
    '''Arguments:

    * `event_id` (`UUID!`)None
    * `event_text` (`String!`)None
    '''

    update_event_comment = sgqlc.types.Field('updateEventComment', graphql_name='updateEventComment', args=sgqlc.types.ArgDict((
        ('event_comment_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='eventCommentId', default=None)),
        ('event_text', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='eventText', default=None)),
))
    )
    '''Arguments:

    * `event_comment_id` (`UUID!`)None
    * `event_text` (`String!`)None
    '''

    delete_event_comment = sgqlc.types.Field('deleteEventComment', graphql_name='deleteEventComment', args=sgqlc.types.ArgDict((
        ('event_comment_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='eventCommentId', default=None)),
))
    )
    '''Arguments:

    * `event_comment_id` (`UUID!`)None
    '''

    set_incident_feedback = sgqlc.types.Field('SetIncidentFeedbackPayload', graphql_name='setIncidentFeedback', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(SetIncidentFeedbackInput), graphql_name='input', default=None)),
))
    )
    '''Provide feedback for an incident

    Arguments:

    * `input` (`SetIncidentFeedbackInput!`)None
    '''

    set_incident_reaction = sgqlc.types.Field('SetIncidentReaction', graphql_name='setIncidentReaction', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('reaction', sgqlc.types.Arg(sgqlc.types.non_null(IncidentReactionInput), graphql_name='reaction', default=None)),
))
    )
    '''Arguments:

    * `incident_id` (`UUID!`): The incident's UUID
    * `reaction` (`IncidentReactionInput!`): Incident reaction input
    '''

    set_incident_severity = sgqlc.types.Field('SetIncidentSeverity', graphql_name='setIncidentSeverity', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('severity', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='severity', default=None)),
))
    )
    '''Set severity for an existing incident

    Arguments:

    * `incident_id` (`UUID!`): The incident's UUID
    * `severity` (`String!`): Incident severity to set
    '''

    set_incident_owner = sgqlc.types.Field('SetIncidentOwner', graphql_name='setIncidentOwner', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('owner', sgqlc.types.Arg(String, graphql_name='owner', default=None)),
))
    )
    '''Set an owner for an existing incident

    Arguments:

    * `incident_id` (`UUID!`): The incident's UUID
    * `owner` (`String`): Incident owner to set
    '''

    create_or_update_incident_comment = sgqlc.types.Field(CreateOrUpdateIncidentComment, graphql_name='createOrUpdateIncidentComment', args=sgqlc.types.ArgDict((
        ('comment', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='comment', default=None)),
        ('comment_id', sgqlc.types.Arg(UUID, graphql_name='commentId', default=None)),
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
))
    )
    '''Creates or updates a comment on an incident

    Arguments:

    * `comment` (`String!`): Content of the comment
    * `comment_id` (`UUID`): UUID of the comment. If set, this call is
      for updating the comment
    * `incident_id` (`UUID!`): The incident's UUID
    '''

    delete_incident_comment = sgqlc.types.Field(DeleteIncidentComment, graphql_name='deleteIncidentComment', args=sgqlc.types.ArgDict((
        ('comment_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='commentId', default=None)),
))
    )
    '''Deletes an incident's comment

    Arguments:

    * `comment_id` (`UUID!`): UUID of the comment for update
    '''

    split_incident = sgqlc.types.Field('SplitIncident', graphql_name='splitIncident', args=sgqlc.types.ArgDict((
        ('event_uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='eventUuids', default=None)),
        ('incident_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentUuid', default=None)),
        ('send_notification', sgqlc.types.Arg(Boolean, graphql_name='sendNotification', default=False)),
))
    )
    '''Splits event/s from incident into a new incident

    Arguments:

    * `event_uuids` (`[UUID]!`): unique identifier of event/s to split
      to new incident
    * `incident_uuid` (`UUID!`): Incident unique identifier
    * `send_notification` (`Boolean`): Whether to send a notification
      for the new incident (default: `false`)
    '''

    bulk_update_incidents = sgqlc.types.Field(BulkUpdateIncidents, graphql_name='bulkUpdateIncidents', args=sgqlc.types.ArgDict((
        ('new_values', sgqlc.types.Arg(sgqlc.types.non_null(BulkUpdateIncidentsValues), graphql_name='newValues', default=None)),
        ('uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='uuids', default=None)),
))
    )
    '''Arguments:

    * `new_values` (`BulkUpdateIncidentsValues!`): New values to apply
      to incidents supplied by uuids
    * `uuids` (`[UUID]!`): UUIDs of incidents to update
    '''

    create_or_update_domain = sgqlc.types.Field(CreateOrUpdateDomain, graphql_name='createOrUpdateDomain', args=sgqlc.types.ArgDict((
        ('assignments', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='assignments', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
        ('tags', sgqlc.types.Arg(sgqlc.types.list_of(TagKeyValuePairInput), graphql_name='tags', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update a domain

    Arguments:

    * `assignments` (`[String]`): Objects assigned to domain (as
      MCONs)
    * `description` (`String`): Description of the domain
    * `name` (`String!`): Domain name
    * `tags` (`[TagKeyValuePairInput]`): Filter by tag key/value pairs
      for tables.
    * `uuid` (`UUID`): UUID of domain to update
    '''

    delete_domain = sgqlc.types.Field(DeleteDomain, graphql_name='deleteDomain', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Delete a domain

    Arguments:

    * `uuid` (`UUID!`): UUID of domain to delete
    '''

    create_or_update_authorization_group = sgqlc.types.Field(CreateOrUpdateAuthorizationGroup, graphql_name='createOrUpdateAuthorizationGroup', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('domain_restriction_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='domainRestrictionIds', default=None)),
        ('label', sgqlc.types.Arg(String, graphql_name='label', default=None)),
        ('member_user_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='memberUserIds', default=None)),
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
        ('roles', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='roles', default=None)),
        ('sso_group', sgqlc.types.Arg(String, graphql_name='ssoGroup', default=None)),
        ('version', sgqlc.types.Arg(String, graphql_name='version', default=None)),
))
    )
    '''Create or update an authorization group.

    Arguments:

    * `description` (`String`): Description/help text to help users
      understand the purpose of the group. If not provided on updates,
      will keep current value.
    * `domain_restriction_ids` (`[UUID]`): Optional list of domain IDs
      to restrict access to. If not provided, will clear/apply no
      restrictions.
    * `label` (`String`): UI/user-friendly display name, ex: Data
      Consumers. If not provided on updates, will keep current value.
    * `member_user_ids` (`[String]`): User IDs of group members. If
      not provided, no changes to membership will be performed.
    * `name` (`String!`): Unique to the account, human-readable name
      (for use in code/policy reference).
    * `roles` (`[String]!`): Role names assigned to the group.
    * `sso_group` (`String`): SSO group name to map this authorization
      group to
    * `version` (`String`): Version of the permissions definitions the
      group is designed for ex: 2022-03-17. Defaults to system
      current. If not provided on updates, will keep current value.
    '''

    delete_authorization_group = sgqlc.types.Field(DeleteAuthorizationGroup, graphql_name='deleteAuthorizationGroup', args=sgqlc.types.ArgDict((
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Delete an authorization group

    Arguments:

    * `name` (`String`): Unique to the account, human-readable name
      name (for use in code/policy reference).
    '''

    update_user_authorization_group_membership = sgqlc.types.Field('UpdateUserAuthorizationGroupMembership', graphql_name='updateUserAuthorizationGroupMembership', args=sgqlc.types.ArgDict((
        ('group_names', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='groupNames', default=None)),
        ('member_user_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='memberUserId', default=None)),
))
    )
    '''Update a user's authorization group membership. Authenticated user
    must have permission to manage users.

    Arguments:

    * `group_names` (`[String]!`): List of authorization group names
      the user should be a member of.
    * `member_user_id` (`String!`): User ID for the user whose
      membership is being updated.
    '''

    create_or_update_resource = sgqlc.types.Field(CreateOrUpdateResource, graphql_name='createOrUpdateResource', args=sgqlc.types.ArgDict((
        ('is_default', sgqlc.types.Arg(Boolean, graphql_name='isDefault', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
        ('type', sgqlc.types.Arg(String, graphql_name='type', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Create or update a resource

    Arguments:

    * `is_default` (`Boolean`): If the account's default resource
    * `name` (`String`): The resource name
    * `type` (`String`): The resource type
    * `uuid` (`UUID`): The resource id
    '''

    match_and_create_bi_warehouse_sources = sgqlc.types.Field(MatchAndCreateBiWarehouseSources, graphql_name='matchAndCreateBiWarehouseSources', args=sgqlc.types.ArgDict((
        ('bi_container_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='biContainerId', default=None)),
        ('bi_warehouse_sources', sgqlc.types.Arg(sgqlc.types.list_of(BiWarehouseSourcesInput), graphql_name='biWarehouseSources', default=None)),
))
    )
    '''Create or update a BI warehouse source. If BI warehouse source
    details are provided in thebi_warehouse_sources parameter then
    those are saved. Else, details are pulled from the BIAPIs, matched
    with warehouses in Monte Carlo and details saved only if there is
    a full match.

    Arguments:

    * `bi_container_id` (`UUID!`): Monte Carlo UUID of the BI
      container
    * `bi_warehouse_sources` (`[BiWarehouseSourcesInput]`): BI
      warehouse source details that should be saved in Monte Carlo.
    '''

    toggle_disable_sampling = sgqlc.types.Field('ToggleDisableSampling', graphql_name='toggleDisableSampling', args=sgqlc.types.ArgDict((
        ('disable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='disable', default=None)),
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
))
    )
    '''Enable/disable the sampling data feature

    Arguments:

    * `disable` (`Boolean!`): If true, disable the sampling data
      feature
    * `dw_id` (`UUID!`): The warehouse's UUID
    '''

    toggle_restrict_sampling = sgqlc.types.Field('ToggleRestrictSampling', graphql_name='toggleRestrictSampling', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('enable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enable', default=None)),
))
    )
    '''Enable/disable to restrict certain roles to access sampling data

    Arguments:

    * `dw_id` (`UUID!`): The warehouse's UUID
    * `enable` (`Boolean!`): If true, restrict certain roles to access
      sampling data
    '''

    toggle_disable_value_ingestion = sgqlc.types.Field('ToggleDisableValueIngestion', graphql_name='toggleDisableValueIngestion', args=sgqlc.types.ArgDict((
        ('disable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='disable', default=None)),
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
))
    )
    '''Enable/disable the value ingestion feature

    Arguments:

    * `disable` (`Boolean!`): If true, disable the value ingestion
      feature
    * `dw_id` (`UUID!`): The warehouse's UUID
    '''

    toggle_disable_value_sampling_when_testing = sgqlc.types.Field('ToggleDisableValueSamplingWhenTesting', graphql_name='toggleDisableValueSamplingWhenTesting', args=sgqlc.types.ArgDict((
        ('disable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='disable', default=None)),
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
))
    )
    '''Enable/disable the sampling data feature when testing value-based
    sql rules

    Arguments:

    * `disable` (`Boolean!`): If true, disable the feature
    * `dw_id` (`UUID!`): The warehouse's UUID
    '''

    toggle_enable_full_distribution_metrics = sgqlc.types.Field('ToggleFullDistributionMetrics', graphql_name='toggleEnableFullDistributionMetrics', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('enable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enable', default=None)),
))
    )
    '''Enable/disable collection of full distribution metrics for a
    particular warehouse

    Arguments:

    * `dw_id` (`UUID!`): The warehouse's UUID
    * `enable` (`Boolean!`): If true, enable full distribution metrics
    '''

    save_table_importance_stats = sgqlc.types.Field('SaveTableImportanceStats', graphql_name='saveTableImportanceStats', args=sgqlc.types.ArgDict((
        ('importance_score', sgqlc.types.Arg(Float, graphql_name='importanceScore', default=None)),
        ('is_important', sgqlc.types.Arg(Boolean, graphql_name='isImportant', default=None)),
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Save custom table stats for a table

    Arguments:

    * `importance_score` (`Float`): User-provided importance score.
    * `is_important` (`Boolean`): Whether the table is a key asset or
      not.
    * `mcon` (`String!`): The MCON of the table whose stats are being
      updated.
    '''

    set_default_incident_group_interval = sgqlc.types.Field('SetDefaultIncidentGroupInterval', graphql_name='setDefaultIncidentGroupInterval', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('interval', sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name='interval', default=None)),
))
    )
    '''Set default incident grouping interval (in hours) for a warehouse.

    Arguments:

    * `dw_id` (`UUID!`): The warehouse's UUID.
    * `interval` (`Int!`): Interval in hours.
    '''

    set_default_lineage_incident_grouping = sgqlc.types.Field('SetDefaultLineageIncidentGrouping', graphql_name='setDefaultLineageIncidentGrouping', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('enabled', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enabled', default=None)),
))
    )
    '''Set default lineage grouping for incident for a warehouse.

    Arguments:

    * `dw_id` (`UUID!`): The warehouse's UUID.
    * `enabled` (`Boolean!`): Whether to enable or disable lineage
      grouping
    '''

    create_or_update_data_maintenance_entry = sgqlc.types.Field(CreateOrUpdateDataMaintenanceEntry, graphql_name='createOrUpdateDataMaintenanceEntry', args=sgqlc.types.ArgDict((
        ('dataset', sgqlc.types.Arg(String, graphql_name='dataset', default=None)),
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('id', sgqlc.types.Arg(Int, graphql_name='id', default=None)),
        ('maintenance_type', sgqlc.types.Arg(DataMaintenanceMetric, graphql_name='maintenanceType', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('project', sgqlc.types.Arg(String, graphql_name='project', default=None)),
        ('reason', sgqlc.types.Arg(String, graphql_name='reason', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
))
    )
    '''Creates or updates a data maintenance period

    Arguments:

    * `dataset` (`String`): Deprecated: Name of dataset to to set
      maintenance period for. If `dataset` is given, `project` is
      required as-well
    * `dw_id` (`UUID!`): Warehouse UUID
    * `end_time` (`DateTime`): Start period of data maintenance. If
      not set, all future data will be ignored until updated
    * `id` (`Int`): ID of existing data maintenance entry for updating
    * `maintenance_type` (`DataMaintenanceMetric`): If not set, all
      metrics for the object will be ignored
    * `mcon` (`String`): MCON unique identifier of object to set
      maintenance period for. MCON can be of type 'warehouse',
      'project', 'dataset' or any table type. Setting any type other
      than a table type will set the maintenance window for all
      matching tables.
    * `project` (`String`): Deprecated: Name of database or project to
      to set maintenance period for
    * `reason` (`String`): Description of the reason for the
      maintenance window
    * `start_time` (`DateTime`): Start period of data maintenance. If
      not set, all previous data will be ignored.
    '''

    toggle_wildcard_aggregation = sgqlc.types.Field('ToggleWildcardAggregation', graphql_name='toggleWildcardAggregation', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('enable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enable', default=None)),
))
    )
    '''Enables/disable aggregation of wildcard tables (defaults to yearly
    and monthly templates)

    Arguments:

    * `dw_id` (`UUID!`): The warehouse's UUID
    * `enable` (`Boolean!`): If true, enable full wildcard aggregation
    '''

    set_wildcard_templates = sgqlc.types.Field('SetWildcardTemplates', graphql_name='setWildcardTemplates', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('templates', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(WildcardTemplateInput)), graphql_name='templates', default=None)),
))
    )
    '''Sets the templates to use for wildcard aggregation (overrides
    existing templates)

    Arguments:

    * `dw_id` (`UUID!`): The warehouse's UUID
    * `templates` (`[WildcardTemplateInput]!`): List of templates to
      use to aggregate wildcard tables
    '''

    delete_data_maintenance_entry = sgqlc.types.Field(DeleteDataMaintenanceEntry, graphql_name='deleteDataMaintenanceEntry', args=sgqlc.types.ArgDict((
        ('id', sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name='id', default=None)),
))
    )
    '''Delete a data maintenance window

    Arguments:

    * `id` (`Int!`): ID of existing data maintenance entry for
      deleting
    '''

    create_shared_query = sgqlc.types.Field(CreateSharedQuery, graphql_name='createSharedQuery', args=sgqlc.types.ArgDict((
        ('content', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='content', default=None)),
        ('expiration_in_days', sgqlc.types.Arg(Int, graphql_name='expirationInDays', default=None)),
        ('type', sgqlc.types.Arg(SharedQueryTypeEnum, graphql_name='type', default=None)),
        ('variables', sgqlc.types.Arg(JSONString, graphql_name='variables', default=None)),
))
    )
    '''Create a new shared API Explorer GraphQL query or mutation

    Arguments:

    * `content` (`String!`): API Explorer GraphQL operation content.
      Maximum size is 1MB.
    * `expiration_in_days` (`Int`): Number of days to expire the
      temporary link, max and default expiration is 7 days
    * `type` (`SharedQueryTypeEnum`): Type of shared GraphQL
      operation: temporary (default) or permanent (internal only)
    * `variables` (`JSONString`): API Explorer GraphQL variables.
      Maximum size is 1MB.
    '''

    create_or_update_user_settings = sgqlc.types.Field(CreateOrUpdateUserSettings, graphql_name='createOrUpdateUserSettings', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='key', default=None)),
        ('value', sgqlc.types.Arg(JSONString, graphql_name='value', default=None)),
))
    )
    '''Create a new user-specific setting

    Arguments:

    * `description` (`String`): Description for this user's settings
    * `key` (`String!`): User setting key
    * `value` (`JSONString`): User settings
    '''

    update_user_state = sgqlc.types.Field('UpdateUserStatePayload', graphql_name='updateUserState', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(UpdateUserStateInput), graphql_name='input', default=None)),
))
    )
    '''Arguments:

    * `input` (`UpdateUserStateInput!`)None
    '''

    update_user_persona = sgqlc.types.Field('UpdateUserPersona', graphql_name='updateUserPersona', args=sgqlc.types.ArgDict((
        ('persona', sgqlc.types.Arg(UserPersona, graphql_name='persona', default=None)),
))
    )
    '''Update a persona that can help personalize the home page
    experience and the onboarding flow.

    Arguments:

    * `persona` (`UserPersona`)None
    '''

    update_account_display_assets_search_tags = sgqlc.types.Field('UpdateAccountDisplayCatalogSearchTags', graphql_name='updateAccountDisplayAssetsSearchTags', args=sgqlc.types.ArgDict((
        ('display', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='display', default=None)),
))
    )
    '''Updates account-level setting for displaying search tags on assets
    ui

    Arguments:

    * `display` (`Boolean!`)None
    '''

    set_account_name = sgqlc.types.Field('SetAccountName', graphql_name='setAccountName', args=sgqlc.types.ArgDict((
        ('account_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='accountName', default=None)),
))
    )
    '''Arguments:

    * `account_name` (`String!`)None
    '''

    set_account_billing_plan = sgqlc.types.Field('SetAccountBillingPlan', graphql_name='setAccountBillingPlan', args=sgqlc.types.ArgDict((
        ('billing_plan_type', sgqlc.types.Arg(sgqlc.types.non_null(BillingPlanType), graphql_name='billingPlanType', default=None)),
))
    )
    '''Sets the billing plan for an account and create the customer in
    the billing vendor

    Arguments:

    * `billing_plan_type` (`BillingPlanType!`): The Billing plan that
      will be used to charge the customer
    '''

    set_warehouse_name = sgqlc.types.Field('SetWarehouseName', graphql_name='setWarehouseName', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
))
    )
    '''Set friendly name for a warehouse.

    Arguments:

    * `dw_id` (`UUID!`): UUID of the warehouse to update.
    * `name` (`String!`): Desired name.
    '''

    set_etl_container_name = sgqlc.types.Field('SetEtlContainerName', graphql_name='setEtlContainerName', args=sgqlc.types.ArgDict((
        ('etl_container_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='etlContainerId', default=None)),
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
))
    )
    '''Set friendly name for a ETL container.

    Arguments:

    * `etl_container_id` (`UUID!`): UUID of the ETL container to
      update.
    * `name` (`String!`): Desired name.
    '''

    create_or_update_saml_identity_provider = sgqlc.types.Field(CreateOrUpdateSamlIdentityProvider, graphql_name='createOrUpdateSamlIdentityProvider', args=sgqlc.types.ArgDict((
        ('account_identifier', sgqlc.types.Arg(String, graphql_name='accountIdentifier', default=None)),
        ('default_authorization_groups', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='defaultAuthorizationGroups', default=None)),
        ('domains', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='domains', default=None)),
        ('metadata', sgqlc.types.Arg(String, graphql_name='metadata', default=None)),
        ('metadata_url', sgqlc.types.Arg(String, graphql_name='metadataUrl', default=None)),
))
    )
    '''Arguments:

    * `account_identifier` (`String`): An account identifier
      authorized by the IdP
    * `default_authorization_groups` (`[String]`): One or more
      authorization group names to assign to new SSO users who do not
      have an invite. If none/not set, it means new users must wait to
      be assigned group to gain any access.
    * `domains` (`[String]!`): A list of domains authorized by the IdP
    * `metadata` (`String`): The metadata in XML format, encoded as
      base64
    * `metadata_url` (`String`): The URL of the metadata file
    '''

    delete_saml_identity_provider = sgqlc.types.Field(DeleteSamlIdentityProvider, graphql_name='deleteSamlIdentityProvider')

    invite_users = sgqlc.types.Field(InviteUsersPayload, graphql_name='inviteUsers', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(InviteUsersInput), graphql_name='input', default=None)),
))
    )
    '''DEPRECATED: use inviteUsersV2

    Arguments:

    * `input` (`InviteUsersInput!`)None
    '''

    invite_users_v2 = sgqlc.types.Field(InviteUsersV2, graphql_name='inviteUsersV2', args=sgqlc.types.ArgDict((
        ('auth_groups', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='authGroups', default=None)),
        ('emails', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='emails', default=None)),
        ('invitation_type', sgqlc.types.Arg(InvitationType, graphql_name='invitationType', default=None)),
))
    )
    '''Invite users to the account

    Arguments:

    * `auth_groups` (`[String]!`): Names of groups to add user to upon
      acceptance.
    * `emails` (`[String]!`): List of email addresses to invite
    * `invitation_type` (`InvitationType`): Type of invitation to send
      --typically maps to product.
    '''

    switch_user_account = sgqlc.types.Field('SwitchUserAccount', graphql_name='switchUserAccount', args=sgqlc.types.ArgDict((
        ('switch_to_account_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='switchToAccountId', default=None)),
        ('verification_token', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='verificationToken', default=None)),
))
    )
    '''User can switch accounts if provided with valid invite

    Arguments:

    * `switch_to_account_id` (`UUID!`)None
    * `verification_token` (`String!`)None
    '''

    delete_user_invite = sgqlc.types.Field(DeleteUserInvite, graphql_name='deleteUserInvite', args=sgqlc.types.ArgDict((
        ('emails', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='emails', default=None)),
))
    )
    '''Delete user invite

    Arguments:

    * `emails` (`[String]!`): List of email addresses to invite
    '''

    resend_user_invite = sgqlc.types.Field('ReInviteUsers', graphql_name='resendUserInvite', args=sgqlc.types.ArgDict((
        ('emails', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='emails', default=None)),
))
    )
    '''Resend user invite

    Arguments:

    * `emails` (`[String]!`): List of email addresses to resend the
      invitation
    '''

    remove_user_from_account = sgqlc.types.Field('RemoveUserFromAccount', graphql_name='removeUserFromAccount', args=sgqlc.types.ArgDict((
        ('email', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='email', default=None)),
))
    )
    '''Remove user from account

    Arguments:

    * `email` (`String!`): Email address of user
    '''

    disable_user = sgqlc.types.Field(DisableUser, graphql_name='disableUser', args=sgqlc.types.ArgDict((
        ('email', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='email', default=None)),
))
    )
    '''Disable a user

    Arguments:

    * `email` (`String!`): Email address of user
    '''

    track_table = sgqlc.types.Field('TrackTablePayload', graphql_name='trackTable', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(TrackTableInput), graphql_name='input', default=None)),
))
    )
    '''Add table to account's dashboard

    Arguments:

    * `input` (`TrackTableInput!`)None
    '''

    upload_credentials = sgqlc.types.Field('UploadWarehouseCredentialsMutation', graphql_name='uploadCredentials', args=sgqlc.types.ArgDict((
        ('file', sgqlc.types.Arg(sgqlc.types.non_null(Upload), graphql_name='file', default=None)),
))
    )
    '''Arguments:

    * `file` (`Upload!`)None
    '''

    save_slack_credentials = sgqlc.types.Field('SaveSlackCredentialsMutation', graphql_name='saveSlackCredentials', args=sgqlc.types.ArgDict((
        ('key', sgqlc.types.Arg(String, graphql_name='key', default=None)),
        ('slack_app_type', sgqlc.types.Arg(SlackAppType, graphql_name='slackAppType', default=None)),
        ('slack_installation_uuid', sgqlc.types.Arg(String, graphql_name='slackInstallationUuid', default=None)),
))
    )
    '''Arguments:

    * `key` (`String`): Slack installation UUID (deprecated, use
      slackInstallationUuid
    * `slack_app_type` (`SlackAppType`): Slack App Type
    * `slack_installation_uuid` (`String`): Slack installation UUID
    '''

    deauthorize_slack_app = sgqlc.types.Field(DeauthorizeSlackAppMutation, graphql_name='deauthorizeSlackApp', args=sgqlc.types.ArgDict((
        ('slack_app_type', sgqlc.types.Arg(sgqlc.types.non_null(SlackAppType), graphql_name='slackAppType', default=None)),
))
    )
    '''Arguments:

    * `slack_app_type` (`SlackAppType!`): Slack App Type
    '''

    test_credentials = sgqlc.types.Field('TestCredentialsMutation', graphql_name='testCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('connection_type', sgqlc.types.Arg(String, graphql_name='connectionType', default='bigquery')),
        ('key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='key', default=None)),
        ('project_id', sgqlc.types.Arg(String, graphql_name='projectId', default=None)),
))
    )
    '''Test credentials where the temp key already exists (e.g. BQ)

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `connection_type` (`String`): The type of connection to add
      (default: `"bigquery"`)
    * `key` (`String!`): Temp key from testing connections
    * `project_id` (`String`): BQ project ID if adding for a specific
      project only (lists otherwise)
    '''

    test_database_credentials = sgqlc.types.Field('TestDatabaseCredentials', graphql_name='testDatabaseCredentials', args=sgqlc.types.ArgDict((
        ('assumable_role', sgqlc.types.Arg(String, graphql_name='assumableRole', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('connection_type', sgqlc.types.Arg(String, graphql_name='connectionType', default=None)),
        ('db_name', sgqlc.types.Arg(String, graphql_name='dbName', default=None)),
        ('db_type', sgqlc.types.Arg(String, graphql_name='dbType', default=None)),
        ('external_id', sgqlc.types.Arg(String, graphql_name='externalId', default=None)),
        ('host', sgqlc.types.Arg(String, graphql_name='host', default=None)),
        ('password', sgqlc.types.Arg(String, graphql_name='password', default=None)),
        ('port', sgqlc.types.Arg(Int, graphql_name='port', default=None)),
        ('ssl_options', sgqlc.types.Arg(SslInputOptions, graphql_name='sslOptions', default=None)),
        ('user', sgqlc.types.Arg(String, graphql_name='user', default=None)),
))
    )
    '''Test a generic warehouse or database connection

    Arguments:

    * `assumable_role` (`String`): AWS role that can be assumed by the
      DC
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `connection_type` (`String`): Type of connection (e.g.
      snowflake, redshift)
    * `db_name` (`String`): Name of database to add connection for
    * `db_type` (`String`): Type of database to add connection for
    * `external_id` (`String`): An external id, per assumable role
      conditions
    * `host` (`String`): Hostname of the warehouse
    * `password` (`String`): User's password
    * `port` (`Int`): HTTP Port to use
    * `ssl_options` (`SslInputOptions`): Specify any SSL options (e.g.
      certs)
    * `user` (`String`): User with access to the database
    '''

    test_presto_credentials = sgqlc.types.Field('TestPrestoCredentials', graphql_name='testPrestoCredentials', args=sgqlc.types.ArgDict((
        ('catalog', sgqlc.types.Arg(String, graphql_name='catalog', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('host', sgqlc.types.Arg(String, graphql_name='host', default=None)),
        ('http_scheme', sgqlc.types.Arg(String, graphql_name='httpScheme', default=None)),
        ('password', sgqlc.types.Arg(String, graphql_name='password', default=None)),
        ('port', sgqlc.types.Arg(Int, graphql_name='port', default=None)),
        ('schema', sgqlc.types.Arg(String, graphql_name='schema', default=None)),
        ('ssl_options', sgqlc.types.Arg(SslInputOptions, graphql_name='sslOptions', default=None)),
        ('user', sgqlc.types.Arg(String, graphql_name='user', default=None)),
))
    )
    '''Test connection to Presto

    Arguments:

    * `catalog` (`String`): Mount point to access data source
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `host` (`String`): Hostname
    * `http_scheme` (`String`): Scheme for authentication
    * `password` (`String`): User's password
    * `port` (`Int`): HTTP port
    * `schema` (`String`): Schema to access
    * `ssl_options` (`SslInputOptions`): Specify any ssl options
    * `user` (`String`): Username with access to catalog/schema
    '''

    test_snowflake_credentials = sgqlc.types.Field('TestSnowflakeCredentials', graphql_name='testSnowflakeCredentials', args=sgqlc.types.ArgDict((
        ('account', sgqlc.types.Arg(String, graphql_name='account', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('password', sgqlc.types.Arg(String, graphql_name='password', default=None)),
        ('private_key', sgqlc.types.Arg(String, graphql_name='privateKey', default=None)),
        ('private_key_passphrase', sgqlc.types.Arg(String, graphql_name='privateKeyPassphrase', default=None)),
        ('user', sgqlc.types.Arg(String, graphql_name='user', default=None)),
        ('warehouse', sgqlc.types.Arg(String, graphql_name='warehouse', default=None)),
))
    )
    '''Test a Snowflake connection

    Arguments:

    * `account` (`String`): Snowflake account name
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `password` (`String`): User's password if using user/password
      basic auth
    * `private_key` (`String`): User's private key (base64 encoded) if
      using key pair auth.
    * `private_key_passphrase` (`String`): User's private key
      passphrase if using key pair auth. This argument is only needed
      when the private key is encrypted.
    * `user` (`String`): User with access to snowflake.
    * `warehouse` (`String`): Name of the warehouse for the user
    '''

    test_hive_credentials = sgqlc.types.Field('TestHiveCredentials', graphql_name='testHiveCredentials', args=sgqlc.types.ArgDict((
        ('auth_mode', sgqlc.types.Arg(String, graphql_name='authMode', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('database', sgqlc.types.Arg(String, graphql_name='database', default=None)),
        ('host', sgqlc.types.Arg(String, graphql_name='host', default=None)),
        ('port', sgqlc.types.Arg(Int, graphql_name='port', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
))
    )
    '''Test a hive sql based connection

    Arguments:

    * `auth_mode` (`String`): Authentication mode to hive. If not set
      "SASL" is used.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `database` (`String`): Name of database
    * `host` (`String`): Hostname
    * `port` (`Int`): Port
    * `username` (`String`): Username with access to hive
    '''

    test_s3_credentials = sgqlc.types.Field('TestS3Credentials', graphql_name='testS3Credentials', args=sgqlc.types.ArgDict((
        ('assumable_role', sgqlc.types.Arg(String, graphql_name='assumableRole', default=None)),
        ('bucket', sgqlc.types.Arg(String, graphql_name='bucket', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('connection_type', sgqlc.types.Arg(String, graphql_name='connectionType', default='s3')),
        ('external_id', sgqlc.types.Arg(String, graphql_name='externalId', default=None)),
        ('prefix', sgqlc.types.Arg(String, graphql_name='prefix', default=None)),
))
    )
    '''Test a s3 based connection (e.g. presto query logs on s3)

    Arguments:

    * `assumable_role` (`String`): AWS role that can be assumed by the
      DC
    * `bucket` (`String`): S3 Bucket where relevant objects are
      contained
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `connection_type` (`String`): Type of connection (default:
      `"s3"`)
    * `external_id` (`String`): An external id, per assumable role
      conditions
    * `prefix` (`String`): Path to objects
    '''

    test_glue_credentials = sgqlc.types.Field('TestGlueCredentials', graphql_name='testGlueCredentials', args=sgqlc.types.ArgDict((
        ('assumable_role', sgqlc.types.Arg(String, graphql_name='assumableRole', default=None)),
        ('aws_region', sgqlc.types.Arg(String, graphql_name='awsRegion', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('external_id', sgqlc.types.Arg(String, graphql_name='externalId', default=None)),
))
    )
    '''Test a Glue connection

    Arguments:

    * `assumable_role` (`String`): Assumable role ARN to use for
      accessing AWS resources
    * `aws_region` (`String`): Glue region
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `external_id` (`String`): An external id, per assumable role
      conditions
    '''

    test_athena_credentials = sgqlc.types.Field('TestAthenaCredentials', graphql_name='testAthenaCredentials', args=sgqlc.types.ArgDict((
        ('assumable_role', sgqlc.types.Arg(String, graphql_name='assumableRole', default=None)),
        ('aws_region', sgqlc.types.Arg(String, graphql_name='awsRegion', default=None)),
        ('catalog', sgqlc.types.Arg(String, graphql_name='catalog', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('external_id', sgqlc.types.Arg(String, graphql_name='externalId', default=None)),
        ('workgroup', sgqlc.types.Arg(String, graphql_name='workgroup', default=None)),
))
    )
    '''Test an Athena connection

    Arguments:

    * `assumable_role` (`String`): Assumable role ARN to use for
      accessing AWS resources
    * `aws_region` (`String`): Athena cluster region
    * `catalog` (`String`): Glue data catalog
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `external_id` (`String`): An external id, per assumable role
      conditions
    * `workgroup` (`String`): Workbook for running queries and
      retrieving logs. If not specified the primary is used
    '''

    test_looker_credentials = sgqlc.types.Field('TestLookerCredentials', graphql_name='testLookerCredentials', args=sgqlc.types.ArgDict((
        ('base_url', sgqlc.types.Arg(String, graphql_name='baseUrl', default=None)),
        ('client_id', sgqlc.types.Arg(String, graphql_name='clientId', default=None)),
        ('client_secret', sgqlc.types.Arg(String, graphql_name='clientSecret', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('verify_ssl', sgqlc.types.Arg(Boolean, graphql_name='verifySsl', default=None)),
))
    )
    '''Test a Looker API connection

    Arguments:

    * `base_url` (`String`): Host url
    * `client_id` (`String`): Looker client id
    * `client_secret` (`String`): Looker client secret
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `verify_ssl` (`Boolean`): Verify SSL (uncheck for self-signed
      certs)
    '''

    test_looker_git_credentials = sgqlc.types.Field('TestLookerGitCredentials', graphql_name='testLookerGitCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('installation_id', sgqlc.types.Arg(Int, graphql_name='installationId', default=None)),
))
    )
    '''Deprecated. Do not use.

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `installation_id` (`Int`): ID response from Github
    '''

    test_looker_git_ssh_credentials = sgqlc.types.Field('TestLookerGitSshCredentials', graphql_name='testLookerGitSshCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('repo_url', sgqlc.types.Arg(String, graphql_name='repoUrl', default=None)),
        ('ssh_key', sgqlc.types.Arg(String, graphql_name='sshKey', default=None)),
))
    )
    '''Test the connection to a Git repository using the SSH protocol

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `repo_url` (`String`): Repository URL as
      ssh://[user@]server/project.git or the shorter form
      [user@]server:project.git
    * `ssh_key` (`String`): SSH key, base64-encoded
    '''

    test_looker_git_clone_credentials = sgqlc.types.Field('TestLookerGitCloneCredentials', graphql_name='testLookerGitCloneCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('repo_url', sgqlc.types.Arg(String, graphql_name='repoUrl', default=None)),
        ('ssh_key', sgqlc.types.Arg(String, graphql_name='sshKey', default=None)),
        ('token', sgqlc.types.Arg(String, graphql_name='token', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
))
    )
    '''Test the connection to a Git repository using the SSH or HTTPS
    protocol

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `repo_url` (`String`): Repository URL as
      ssh://[user@]server/project.git or the shorter form
      [user@]server:project.git SSH integrations and
      htts://server/project.git for HTTPS integrations
    * `ssh_key` (`String`): SSH key, base64-encoded
    * `token` (`String`): The access token for git HTTPS integrations
    * `username` (`String`): The git username for BitBucket
      integrations
    '''

    test_dbt_cloud_credentials = sgqlc.types.Field('TestDbtCloudCredentials', graphql_name='testDbtCloudCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('connection_type', sgqlc.types.Arg(String, graphql_name='connectionType', default='dbt-cloud-v2')),
        ('dbt_cloud_account_id', sgqlc.types.Arg(String, graphql_name='dbtCloudAccountId', default=None)),
        ('dbt_cloud_api_token', sgqlc.types.Arg(String, graphql_name='dbtCloudApiToken', default=None)),
        ('dbt_cloud_base_url', sgqlc.types.Arg(String, graphql_name='dbtCloudBaseUrl', default=None)),
        ('dbt_cloud_webhook_hmac_secret', sgqlc.types.Arg(String, graphql_name='dbtCloudWebhookHmacSecret', default=None)),
        ('dbt_cloud_webhook_id', sgqlc.types.Arg(String, graphql_name='dbtCloudWebhookId', default=None)),
))
    )
    '''Test a dbt Cloud connection

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `connection_type` (`String`): dbt Cloud connection type
      (default: `"dbt-cloud-v2"`)
    * `dbt_cloud_account_id` (`String`): dbt Cloud account ID
    * `dbt_cloud_api_token` (`String`): dbt Cloud API token
    * `dbt_cloud_base_url` (`String`): dbt Cloud base URL
    * `dbt_cloud_webhook_hmac_secret` (`String`): Provide the
      hmac_secret of a dbt outbound webhook to setup a webhook-based
      dbt integration
    * `dbt_cloud_webhook_id` (`String`): Provide the webhook ID of a
      dbt outbound webhook to setup a webhook-based dbt integration
    '''

    test_bq_credentials = sgqlc.types.Field('TestBqCredentials', graphql_name='testBqCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('service_json', sgqlc.types.Arg(String, graphql_name='serviceJson', default=None)),
))
    )
    '''Test a BQ connection

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `service_json` (`String`): Service account key file as a base64
      string
    '''

    test_spark_credentials = sgqlc.types.Field('TestSparkCredentials', graphql_name='testSparkCredentials', args=sgqlc.types.ArgDict((
        ('binary_mode', sgqlc.types.Arg(SparkBinaryInput, graphql_name='binaryMode', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('databricks', sgqlc.types.Arg(SparkDatabricksInput, graphql_name='databricks', default=None)),
        ('http_mode', sgqlc.types.Arg(SparkHttpInput, graphql_name='httpMode', default=None)),
))
    )
    '''Test Spark credentials

    Arguments:

    * `binary_mode` (`SparkBinaryInput`): Configuration for Thrift in
      binary mode
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `databricks` (`SparkDatabricksInput`): Configuration for
      Databricks
    * `http_mode` (`SparkHttpInput`): Configuration for Thrift in HTTP
      mode
    '''

    test_databricks_sql_warehouse_credentials = sgqlc.types.Field('TestDatabricksSqlWarehouseCredentials', graphql_name='testDatabricksSqlWarehouseCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('databricks_config', sgqlc.types.Arg(sgqlc.types.non_null(DatabricksSqlWarehouseInput), graphql_name='databricksConfig', default=None)),
))
    )
    '''Test Databricks Sql Warehouse credentials

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `databricks_config` (`DatabricksSqlWarehouseInput!`):
      Configuration for the Databricks sql warehouse.
    '''

    test_self_hosted_credentials = sgqlc.types.Field('TestSelfHostedCredentials', graphql_name='testSelfHostedCredentials', args=sgqlc.types.ArgDict((
        ('assumable_role', sgqlc.types.Arg(String, graphql_name='assumableRole', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('connection_type', sgqlc.types.Arg(String, graphql_name='connectionType', default=None)),
        ('external_id', sgqlc.types.Arg(String, graphql_name='externalId', default=None)),
        ('region', sgqlc.types.Arg(String, graphql_name='region', default=None)),
        ('self_hosting_key', sgqlc.types.Arg(String, graphql_name='selfHostingKey', default=None)),
        ('self_hosting_mechanism', sgqlc.types.Arg(String, graphql_name='selfHostingMechanism', default=None)),
))
    )
    '''Test a connection of any type with self-hosted credentials.

    Arguments:

    * `assumable_role` (`String`): Role that can be assumed by the DC
      to access the self-hosting mechanism
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `connection_type` (`String`): Type of connection
    * `external_id` (`String`): An external id, per assumable role
      conditions
    * `region` (`String`): Region where the credentials are hosted
    * `self_hosting_key` (`String`): Identifier for the credentials
      within the self-hosting mechanism (e.g. SecretManager secret
      ARN)
    * `self_hosting_mechanism` (`String`): Type of credential self-
      hosting mechanism
    '''

    test_tableau_credentials = sgqlc.types.Field('TestTableauCredentialsMutation', graphql_name='testTableauCredentials', args=sgqlc.types.ArgDict((
        ('client_id', sgqlc.types.Arg(String, graphql_name='clientId', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('password', sgqlc.types.Arg(String, graphql_name='password', default=None)),
        ('secret_id', sgqlc.types.Arg(String, graphql_name='secretId', default=None)),
        ('secret_value', sgqlc.types.Arg(String, graphql_name='secretValue', default=None)),
        ('server_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='serverName', default=None)),
        ('site_name', sgqlc.types.Arg(String, graphql_name='siteName', default=None)),
        ('token_name', sgqlc.types.Arg(String, graphql_name='tokenName', default=None)),
        ('token_value', sgqlc.types.Arg(String, graphql_name='tokenValue', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
        ('verify_ssl', sgqlc.types.Arg(Boolean, graphql_name='verifySsl', default=True)),
))
    )
    '''Test Tableau credentials

    Arguments:

    * `client_id` (`String`): The Tableau Connected Apps Client ID
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `password` (`String`): Password for the Tableau user if using
      username/password
    * `secret_id` (`String`): The Tableau Connected Apps Secret ID
    * `secret_value` (`String`): The Tableau Connected Apps Secret
      value
    * `server_name` (`String!`): The Tableau server name
    * `site_name` (`String`): The Tableau site name
    * `token_name` (`String`): The personal access token name
    * `token_value` (`String`): The personal access token value
    * `username` (`String`): Username for the Tableau user if using
      username/password or Connected Apps
    * `verify_ssl` (`Boolean`): Whether to verify the SSL connection
      to Tableau server (default: `true`)
    '''

    test_power_bi_credentials = sgqlc.types.Field('TestPowerBICredentials', graphql_name='testPowerBiCredentials', args=sgqlc.types.ArgDict((
        ('auth_mode', sgqlc.types.Arg(sgqlc.types.non_null(PowerBIAuthModeEnum), graphql_name='authMode', default=None)),
        ('client_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='clientId', default=None)),
        ('client_secret', sgqlc.types.Arg(String, graphql_name='clientSecret', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('password', sgqlc.types.Arg(String, graphql_name='password', default=None)),
        ('tenant_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='tenantId', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
))
    )
    '''Test Power BI credentials

    Arguments:

    * `auth_mode` (`PowerBIAuthModeEnum!`): Authentication mode. We
      support two values here [service_principal, primary_user]
    * `client_id` (`String!`): App Client uuid
    * `client_secret` (`String`): Secret key for the client ID.
      Required if auth_mode is service_principal.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `password` (`String`): Password when auth as a primary user.
      Required if auth_mode is primary_user.
    * `tenant_id` (`String!`): Azure power bi tenant uuid
    * `username` (`String`): Username when auth as a primary user.
      Required if auth_mode is primary_user.
    '''

    test_fivetran_credentials = sgqlc.types.Field('TestFivetranCredentials', graphql_name='testFivetranCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('fivetran_api_key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='fivetranApiKey', default=None)),
        ('fivetran_api_password', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='fivetranApiPassword', default=None)),
        ('fivetran_base_url', sgqlc.types.Arg(String, graphql_name='fivetranBaseUrl', default=None)),
))
    )
    '''Test Fivetran credentials

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests
    * `fivetran_api_key` (`String!`): Fivetran API Key
    * `fivetran_api_password` (`String!`): Fivetran API Password
    * `fivetran_base_url` (`String`): Fivetran base URL
    '''

    toggle_mute_dataset = sgqlc.types.Field('ToggleMuteDatasetPayload', graphql_name='toggleMuteDataset', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(ToggleMuteDatasetInput), graphql_name='input', default=None)),
))
    )
    '''Start/Stop creating incidents for the given dataset

    Arguments:

    * `input` (`ToggleMuteDatasetInput!`)None
    '''

    toggle_mute_table = sgqlc.types.Field('ToggleMuteTablePayload', graphql_name='toggleMuteTable', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(ToggleMuteTableInput), graphql_name='input', default=None)),
))
    )
    '''Start/Stop creating incidents for the given table

    Arguments:

    * `input` (`ToggleMuteTableInput!`)None
    '''

    toggle_mute_datasets = sgqlc.types.Field('ToggleMuteDatasetsPayload', graphql_name='toggleMuteDatasets', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(ToggleMuteDatasetsInput), graphql_name='input', default=None)),
))
    )
    '''Start/Stop creating incidents for the given datasets

    Arguments:

    * `input` (`ToggleMuteDatasetsInput!`)None
    '''

    toggle_mute_tables = sgqlc.types.Field('ToggleMuteTablesPayload', graphql_name='toggleMuteTables', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(ToggleMuteTablesInput), graphql_name='input', default=None)),
))
    )
    '''Start/Stop creating incidents for the given tables

    Arguments:

    * `input` (`ToggleMuteTablesInput!`)None
    '''

    toggle_mute_with_regex = sgqlc.types.Field('ToggleMuteWithRegexPayload', graphql_name='toggleMuteWithRegex', args=sgqlc.types.ArgDict((
        ('input', sgqlc.types.Arg(sgqlc.types.non_null(ToggleMuteWithRegexInput), graphql_name='input', default=None)),
))
    )
    '''Start/Stop creating incidents for all matched elements. Use
    wildcards to match more than one table or dataset.

    Arguments:

    * `input` (`ToggleMuteWithRegexInput!`)None
    '''

    toggle_slack_reply_warning = sgqlc.types.Field('ToggleSlackReplyWarning', graphql_name='toggleSlackReplyWarning', args=sgqlc.types.ArgDict((
        ('enable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enable', default=None)),
))
    )
    '''Enable/disable the Slack reply warning feature

    Arguments:

    * `enable` (`Boolean!`): If true, enable the feature
    '''

    toggle_connection_enable = sgqlc.types.Field('ToggleConnectionEnable', graphql_name='toggleConnectionEnable', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
        ('enable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enable', default=None)),
))
    )
    '''Enable or Disable a connection. This will also skip/un-skip all
    related data collector schedules.

    Arguments:

    * `connection_id` (`UUID!`): Connection to perform the action on
    * `enable` (`Boolean!`): Indicates whether the connection should
      be enabled (true) or disabled (false)
    '''

    add_connection = sgqlc.types.Field(AddConnectionMutation, graphql_name='addConnection', args=sgqlc.types.ArgDict((
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
        ('create_warehouse_type', sgqlc.types.Arg(String, graphql_name='createWarehouseType', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('job_limits', sgqlc.types.Arg(JSONString, graphql_name='jobLimits', default=None)),
        ('job_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='jobTypes', default=None)),
        ('key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='key', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Add a connection and setup any associated jobs. Creates a
    warehouse if not specified

    Arguments:

    * `connection_type` (`String!`): The type of connection to add
    * `create_warehouse_type` (`String`): Create a new warehouse for
      the connection
    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    * `dw_id` (`UUID`): Add connection to an existing warehouse
    * `job_limits` (`JSONString`): Customize job operations for all
      job types
    * `job_types` (`[String]`): Specify job types for the connection.
      Uses connection default otherwise
    * `key` (`String!`): Temp key from testing connections
    * `name` (`String`): Provide a friendly name for the warehouse
      when creating
    '''

    remove_connection = sgqlc.types.Field('RemoveConnectionMutation', graphql_name='removeConnection', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
))
    )
    '''Remove an integration connection and deschedule any associated
    jobs

    Arguments:

    * `connection_id` (`UUID!`): ID of the connection to remove
    '''

    add_bi_connection = sgqlc.types.Field(AddBiConnectionMutation, graphql_name='addBiConnection', args=sgqlc.types.ArgDict((
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('job_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='jobTypes', default=None)),
        ('key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='key', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
))
    )
    '''Add a bi connection and setup any associated jobs

    Arguments:

    * `connection_type` (`String!`): The type of connection to add
    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    * `job_types` (`[String]`): Specify job types for the connection.
      Uses connection default otherwise
    * `key` (`String!`): Temp key from testing connections
    * `name` (`String`): Provide a friendly name for the BI connection
    * `resource_id` (`UUID`): BI Container UUID. Add the connection
      under the same resource UUID.
    '''

    update_bi_connection_name = sgqlc.types.Field('UpdateBiConnectionNameMutation', graphql_name='updateBiConnectionName', args=sgqlc.types.ArgDict((
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
        ('resource_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='resourceId', default=None)),
))
    )
    '''Update the name of an existing bi connection

    Arguments:

    * `name` (`String!`): Provide a friendly name for the BI
      connection
    * `resource_id` (`UUID!`): Existing BI Container UUID.
    '''

    add_etl_connection = sgqlc.types.Field(AddEtlConnectionMutation, graphql_name='addEtlConnection', args=sgqlc.types.ArgDict((
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='key', default=None)),
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
))
    )
    '''Add an etl connection and setup any associated jobs

    Arguments:

    * `connection_type` (`String!`): The type of connection to add
    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    * `key` (`String!`): Temp key from testing connections
    * `name` (`String!`): Provide a friendly name for the ETL
      connection
    '''

    toggle_event_config = sgqlc.types.Field('ToggleEventConfig', graphql_name='toggleEventConfig', args=sgqlc.types.ArgDict((
        ('assumable_role', sgqlc.types.Arg(String, graphql_name='assumableRole', default=None)),
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
        ('connection_type', sgqlc.types.Arg(String, graphql_name='connectionType', default=None)),
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('enable', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enable', default=None)),
        ('event_type', sgqlc.types.Arg(sgqlc.types.non_null(DataCollectorEventTypes), graphql_name='eventType', default=None)),
        ('external_id', sgqlc.types.Arg(String, graphql_name='externalId', default=None)),
        ('format_type', sgqlc.types.Arg(String, graphql_name='formatType', default=None)),
        ('location', sgqlc.types.Arg(String, graphql_name='location', default=None)),
        ('mapping', sgqlc.types.Arg(JSONString, graphql_name='mapping', default=None)),
        ('source_format', sgqlc.types.Arg(String, graphql_name='sourceFormat', default=None)),
))
    )
    '''Enable / disable the configuration for data collection via events

    Arguments:

    * `assumable_role` (`String`): AWS role that can be assumed by the
      DC
    * `connection_id` (`UUID`): The connection id. Cannot be present
      with DW ID
    * `connection_type` (`String`): Type of connection (e.g. hive-s3),
      required if connection id not set
    * `dw_id` (`UUID`): The warehouse id. Cannot be present with
      connection ID
    * `enable` (`Boolean!`): If true enable the connection, otherwise
      disable it
    * `event_type` (`DataCollectorEventTypes!`): Type of event (e.g.
      metadata)
    * `external_id` (`String`): An external id, per assumable role
      conditions
    * `format_type` (`String`): Log file format (e.g. hive-emr)
    * `location` (`String`): Location of the log files
    * `mapping` (`JSONString`): A map where keys are the attributes in
      the destinationschema and values are the keys in the source
      schema
    * `source_format` (`String`): File format (e.g. "json")
    '''

    configure_airflow_log_events = sgqlc.types.Field(ConfigureAirflowLogEvents, graphql_name='configureAirflowLogEvents', args=sgqlc.types.ArgDict((
        ('assumable_role', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='assumableRole', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('external_id', sgqlc.types.Arg(String, graphql_name='externalId', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Configure collection of Airflow logs via S3 events

    Arguments:

    * `assumable_role` (`String!`): AWS role that can be assumed by
      the DC
    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    * `external_id` (`String`): An external id, per assumable role
      conditions
    * `name` (`String`): Provide a friendly name for the warehouse
      when creating
    '''

    configure_metadata_events = sgqlc.types.Field(ConfigureMetadataEvents, graphql_name='configureMetadataEvents', args=sgqlc.types.ArgDict((
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Configure collection of metadata via S3 events

    Arguments:

    * `connection_type` (`String!`): Type of data lake connection
      (e.g. hive-s3)
    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    * `name` (`String`): Provide a friendly name for the warehouse
      when creating
    '''

    configure_query_log_events = sgqlc.types.Field(ConfigureQueryLogEvents, graphql_name='configureQueryLogEvents', args=sgqlc.types.ArgDict((
        ('assumable_role', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='assumableRole', default=None)),
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
        ('external_id', sgqlc.types.Arg(String, graphql_name='externalId', default=None)),
        ('format_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='formatType', default=None)),
        ('location', sgqlc.types.Arg(String, graphql_name='location', default=None)),
        ('mapping', sgqlc.types.Arg(JSONString, graphql_name='mapping', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
        ('source_format', sgqlc.types.Arg(String, graphql_name='sourceFormat', default=None)),
))
    )
    '''Configure collection of query logs via S3 events

    Arguments:

    * `assumable_role` (`String!`): AWS role that can be assumed by
      the DC
    * `connection_type` (`String!`): Type of data lake connection
      (e.g. hive-s3)
    * `external_id` (`String`): An external id, per assumable role
      conditions
    * `format_type` (`String!`): Log file format (e.g. hive-emr)
    * `location` (`String`): Location of the log files
    * `mapping` (`JSONString`): A map where keys are the attributes in
      the destinationschema and values are the keys in the source
      schema
    * `name` (`String`): Provide a friendly name for the warehouse
      when creating
    * `source_format` (`String`): File format (e.g. "json")
    '''

    disable_airflow_log_events = sgqlc.types.Field(DisableAirflowLogEvents, graphql_name='disableAirflowLogEvents', args=sgqlc.types.ArgDict((
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Disable collection of Airflow logs via S3 events

    Arguments:

    * `name` (`String`): Resource name (required if more than one is
      present
    '''

    disable_metadata_events = sgqlc.types.Field(DisableMetadataEvents, graphql_name='disableMetadataEvents', args=sgqlc.types.ArgDict((
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Disable collection of metadata via S3 events

    Arguments:

    * `name` (`String`): Resource name (required if more than one is
      present
    '''

    disable_query_log_events = sgqlc.types.Field(DisableQueryLogEvents, graphql_name='disableQueryLogEvents', args=sgqlc.types.ArgDict((
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Disable collection of query logs via S3 events

    Arguments:

    * `name` (`String`): Resource name (required if more than one is
      present
    '''

    create_or_update_service_api_token = sgqlc.types.Field(CreateOrUpdateServiceApiToken, graphql_name='createOrUpdateServiceApiToken', args=sgqlc.types.ArgDict((
        ('comment', sgqlc.types.Arg(String, graphql_name='comment', default=None)),
        ('display_name', sgqlc.types.Arg(String, graphql_name='displayName', default=None)),
        ('expiration_in_days', sgqlc.types.Arg(Int, graphql_name='expirationInDays', default=None)),
        ('groups', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='groups', default=None)),
        ('token_id', sgqlc.types.Arg(String, graphql_name='tokenId', default=None)),
))
    )
    '''Generate a service API Access Token

    Arguments:

    * `comment` (`String`): Any comment or description to help
      identify the token
    * `display_name` (`String`): A name to show when displaying the
      user name
    * `expiration_in_days` (`Int`): Number of days before the token
      auto expires
    * `groups` (`[String]`): Names of the groups for the API token.
    * `token_id` (`String`): Token ID to edit
    '''

    create_access_token = sgqlc.types.Field(CreateAccessToken, graphql_name='createAccessToken', args=sgqlc.types.ArgDict((
        ('comment', sgqlc.types.Arg(String, graphql_name='comment', default=None)),
        ('expiration_in_days', sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name='expirationInDays', default=None)),
))
    )
    '''Generate an API Access Token and associate to user

    Arguments:

    * `comment` (`String`): Any comment or description to help
      identify the token
    * `expiration_in_days` (`Int!`): Number of days before the token
      auto expires
    '''

    delete_access_token = sgqlc.types.Field(DeleteAccessToken, graphql_name='deleteAccessToken', args=sgqlc.types.ArgDict((
        ('token_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='tokenId', default=None)),
))
    )
    '''Delete an API Access Token by ID

    Arguments:

    * `token_id` (`String!`): ID of the token to delete
    '''

    generate_collector_template = sgqlc.types.Field(GenerateCollectorTemplate, graphql_name='generateCollectorTemplate', args=sgqlc.types.ArgDict((
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('region', sgqlc.types.Arg(String, graphql_name='region', default='us-east-1')),
        ('template_variant', sgqlc.types.Arg(String, graphql_name='templateVariant', default=None)),
        ('update_infra', sgqlc.types.Arg(Boolean, graphql_name='updateInfra', default=False)),
))
    )
    '''Generate a data collector template (uploaded to S3)

    Arguments:

    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    * `region` (`String`): Region where the DC is hosted (default:
      `"us-east-1"`)
    * `template_variant` (`String`): DC template variant.
    * `update_infra` (`Boolean`): Use latest version of the collector
      template, with any infrastructure changes it might include.
      Otherwise, only the lambda code version will be updated.
      (default: `false`)
    '''

    update_credentials = sgqlc.types.Field('UpdateCredentials', graphql_name='updateCredentials', args=sgqlc.types.ArgDict((
        ('changes', sgqlc.types.Arg(sgqlc.types.non_null(JSONString), graphql_name='changes', default=None)),
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
        ('should_replace', sgqlc.types.Arg(Boolean, graphql_name='shouldReplace', default=False)),
        ('should_validate', sgqlc.types.Arg(Boolean, graphql_name='shouldValidate', default=True)),
))
    )
    '''Update credentials for a connection

    Arguments:

    * `changes` (`JSONString!`): JSON Key/values with fields to update
    * `connection_id` (`UUID!`): ID for connection to update
    * `should_replace` (`Boolean`): Set true to replace all
      credentials with changes. Otherwise inserts/replaces (default:
      `false`)
    * `should_validate` (`Boolean`): Set to true to test changes
      before saving (default: `true`)
    '''

    create_collector_record = sgqlc.types.Field(CreateCollectorRecord, graphql_name='createCollectorRecord', args=sgqlc.types.ArgDict((
        ('region', sgqlc.types.Arg(String, graphql_name='region', default='us-east-1')),
        ('template_provider', sgqlc.types.Arg(String, graphql_name='templateProvider', default='cloudformation')),
        ('template_variant', sgqlc.types.Arg(String, graphql_name='templateVariant', default='janus')),
))
    )
    '''Create an additional collector record (with template) in the
    account.

    Arguments:

    * `region` (`String`): Region where the DC is hosted (default:
      `"us-east-1"`)
    * `template_provider` (`String`): DC template IaC provider
      (default: `"cloudformation"`)
    * `template_variant` (`String`): DC template variant (default:
      `"janus"`)
    '''

    cleanup_collector_record = sgqlc.types.Field(CleanupCollectorRecordInAccount, graphql_name='cleanupCollectorRecord', args=sgqlc.types.ArgDict((
        ('dc_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dcId', default=None)),
))
    )
    '''Deletes an unassociated collector record in the account. This does
    not delete the CloudFormation stack and will not succeed if the
    collector is active and/or associated with a warehouse.

    Arguments:

    * `dc_id` (`UUID!`): DC UUID
    '''

    migrate_collector_resources = sgqlc.types.Field(MigrateCollectorResources, graphql_name='migrateCollectorResources', args=sgqlc.types.ArgDict((
        ('resource_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='resourceIds', default=None)),
        ('source_dc_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='sourceDcId', default=None)),
        ('target_dc_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='targetDcId', default=None)),
))
    )
    '''Migrate resources (warehouses, BI) from one data collector to
    another

    Arguments:

    * `resource_ids` (`[UUID]`): List of resource UUIDs to migrate. By
      default all resources will be migrated.
    * `source_dc_id` (`UUID!`): Source DC UUID
    * `target_dc_id` (`UUID!`): Target DC UUID
    '''

    update_slack_channels = sgqlc.types.Field('UpdateSlackChannelsMutation', graphql_name='updateSlackChannels')
    '''Update the slack channels cache for the account'''

    create_integration_key = sgqlc.types.Field(CreateIntegrationKey, graphql_name='createIntegrationKey', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='description', default=None)),
        ('scope', sgqlc.types.Arg(sgqlc.types.non_null(IntegrationKeyScope), graphql_name='scope', default=None)),
        ('warehouse_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='warehouseIds', default=None)),
))
    )
    '''Create an integration key

    Arguments:

    * `description` (`String!`): Key description
    * `scope` (`IntegrationKeyScope!`): Key scope (integration it can
      be used for)
    * `warehouse_ids` (`[UUID]`): UUID(s) of warehouse(s) associated
      with key
    '''

    delete_integration_key = sgqlc.types.Field(DeleteIntegrationKey, graphql_name='deleteIntegrationKey', args=sgqlc.types.ArgDict((
        ('key_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='keyId', default=None)),
))
    )
    '''Delete an integration key

    Arguments:

    * `key_id` (`String!`): Integration key id
    '''

    create_databricks_secret = sgqlc.types.Field(CreateDatabricksSecret, graphql_name='createDatabricksSecret', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('databricks_config', sgqlc.types.Arg(sgqlc.types.non_null(SparkDatabricksInput), graphql_name='databricksConfig', default=None)),
        ('scope_name', sgqlc.types.Arg(String, graphql_name='scopeName', default=None)),
        ('scope_principal', sgqlc.types.Arg(String, graphql_name='scopePrincipal', default=None)),
        ('secret_name', sgqlc.types.Arg(String, graphql_name='secretName', default=None)),
))
    )
    '''Create Databricks scope and secret for an integration key.

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `databricks_config` (`SparkDatabricksInput!`): Configuration for
      Databricks.
    * `scope_name` (`String`): Override default scope name from DC.
    * `scope_principal` (`String`): Override default principal name
      from DC.
    * `secret_name` (`String`): Override default secret name from DC.
    '''

    create_databricks_notebook_job = sgqlc.types.Field(CreateDatabricksNotebookJob, graphql_name='createDatabricksNotebookJob', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('databricks_config', sgqlc.types.Arg(sgqlc.types.non_null(SparkDatabricksInput), graphql_name='databricksConfig', default=None)),
))
    )
    '''Create Databricks directory, upload the collection notebook and
    setup a job.

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `databricks_config` (`SparkDatabricksInput!`): Configuration for
      Databricks.
    '''

    update_databricks_notebook_job = sgqlc.types.Field('UpdateDatabricksNotebookJob', graphql_name='updateDatabricksNotebookJob', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
))
    )
    '''Update Databricks collection notebook and job.

    Arguments:

    * `connection_id` (`UUID`): A Databricks connection UUID
    '''

    update_databricks_notebook = sgqlc.types.Field('UpdateDatabricksNotebook', graphql_name='updateDatabricksNotebook', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
))
    )
    '''Update Databricks notebook.

    Arguments:

    * `connection_id` (`UUID`): A Databricks connection UUID
    '''

    start_databricks_cluster = sgqlc.types.Field('StartDatabricksCluster', graphql_name='startDatabricksCluster', args=sgqlc.types.ArgDict((
        ('connection_config', sgqlc.types.Arg(SparkDatabricksConnectionInput, graphql_name='connectionConfig', default=None)),
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
))
    )
    '''Start Databricks Cluster.

    Arguments:

    * `connection_config` (`SparkDatabricksConnectionInput`):
      Connection config for new Databricks cluster connection
    * `connection_id` (`UUID`): A Databricks connection UUID of an
      existing connection
    '''

    start_databricks_warehouse = sgqlc.types.Field('StartDatabricksWarehouse', graphql_name='startDatabricksWarehouse', args=sgqlc.types.ArgDict((
        ('connection_config', sgqlc.types.Arg(DatabricksSqlWarehouseConnectionInput, graphql_name='connectionConfig', default=None)),
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
))
    )
    '''Start Databricks Warehouse.

    Arguments:

    * `connection_config` (`DatabricksSqlWarehouseConnectionInput`):
      Connection config for new Databricks SQL warehouse connection
    * `connection_id` (`UUID`): A Databricks connection UUID
    '''

    test_databricks_credentials = sgqlc.types.Field('TestDatabricksCredentials', graphql_name='testDatabricksCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('databricks_config', sgqlc.types.Arg(sgqlc.types.non_null(SparkDatabricksInput), graphql_name='databricksConfig', default=None)),
))
    )
    '''Test a Databricks connection

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `databricks_config` (`SparkDatabricksInput!`): Configuration for
      Databricks.
    '''

    test_delta_credentials = sgqlc.types.Field('TestDatabricksCredentials', graphql_name='testDeltaCredentials', args=sgqlc.types.ArgDict((
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('databricks_config', sgqlc.types.Arg(sgqlc.types.non_null(SparkDatabricksInput), graphql_name='databricksConfig', default=None)),
))
    )
    '''Test a Databricks connection

    Arguments:

    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `databricks_config` (`SparkDatabricksInput!`): Configuration for
      Databricks.
    '''

    add_databricks_connection = sgqlc.types.Field(AddDatabricksConnectionMutation, graphql_name='addDatabricksConnection', args=sgqlc.types.ArgDict((
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
        ('create_warehouse_type', sgqlc.types.Arg(String, graphql_name='createWarehouseType', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('job_limits', sgqlc.types.Arg(sgqlc.types.non_null(JSONString), graphql_name='jobLimits', default=None)),
        ('job_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='jobTypes', default=None)),
        ('key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='key', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Add a databricks connection and setup any associated jobs. Creates
    a warehouse if not specified

    Arguments:

    * `connection_type` (`String!`): The type of connection to add
    * `create_warehouse_type` (`String`): Create a new warehouse for
      the connection
    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    * `dw_id` (`UUID`): Add connection to an existing warehouse
    * `job_limits` (`JSONString!`): Customize job operations for all
      job types
    * `job_types` (`[String]`): Specify job types for the connection.
      Uses connection default otherwise
    * `key` (`String!`): Temp key from testing connections
    * `name` (`String`): Provide a friendly name for the warehouse
      when creating
    '''

    save_event_onboarding_data = sgqlc.types.Field('SaveEventOnboardingData', graphql_name='saveEventOnboardingData', args=sgqlc.types.ArgDict((
        ('config', sgqlc.types.Arg(sgqlc.types.non_null(JSONString), graphql_name='config', default=None)),
))
    )
    '''Save event onboarding configuration

    Arguments:

    * `config` (`JSONString!`): JSON Key/values with event config to
      store
    '''

    delete_event_onboarding_data = sgqlc.types.Field(DeleteEventOnboardingData, graphql_name='deleteEventOnboardingData')
    '''Delete stored event onboarding configuration'''

    migrate_databricks_sql_warehouse = sgqlc.types.Field(DatabricksSqlWarehouseConnectionMigration, graphql_name='migrateDatabricksSqlWarehouse', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
        ('databricks_config', sgqlc.types.Arg(sgqlc.types.non_null(DatabricksSqlWarehouseInput), graphql_name='databricksConfig', default=None)),
))
    )
    '''Migrate an existing databricks connection to use a sql warehouse

    Arguments:

    * `connection_id` (`UUID!`): ID of the connection to migrate
    * `databricks_config` (`DatabricksSqlWarehouseInput!`):
      Configuration for the Databricks sql warehouse.
    '''

    toggle_notifications_v2 = sgqlc.types.Field('ToggleNotificationsV2', graphql_name='toggleNotificationsV2', args=sgqlc.types.ArgDict((
        ('enabled', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='enabled', default=None)),
))
    )
    '''Enable/disable notifications 2.0

    Arguments:

    * `enabled` (`Boolean!`): If true, notifications 2.0 is enabled.
    '''

    toggle_account_feature = sgqlc.types.Field('ToggleAccountFeature', graphql_name='toggleAccountFeature', args=sgqlc.types.ArgDict((
        ('feature', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='feature', default=None)),
        ('is_enabled', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='isEnabled', default=None)),
))
    )
    '''Enable/disable an account level feature

    Arguments:

    * `feature` (`String!`): Feature to enable/disable
    * `is_enabled` (`Boolean!`): Enable or disable the feature
    '''

    test_snowflake_credentials_v2 = sgqlc.types.Field('TestSnowflakeCredentialsV2', graphql_name='testSnowflakeCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(SnowflakeConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Snowflake credentials

    Arguments:

    * `connection_details` (`SnowflakeConnectionDetails!`): Connection
      parameters.
    * `connection_id` (`UUID`): If updating an existing connection,
      the ID of the connection to test.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_redshift_credentials_v2 = sgqlc.types.Field('TestRedshiftCredentialsV2', graphql_name='testRedshiftCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(RedshiftConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Redshift credentials

    Arguments:

    * `connection_details` (`RedshiftConnectionDetails!`): Connection
      parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_bq_credentials_v2 = sgqlc.types.Field('TestBqCredentialsV2', graphql_name='testBqCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(BqConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test BigQuery credentials

    Arguments:

    * `connection_details` (`BqConnectionDetails!`): Connection
      parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_tableau_credentials_v2 = sgqlc.types.Field('TestTableauCredentialsV2', graphql_name='testTableauCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(TableauConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Tableau credentials

    Arguments:

    * `connection_details` (`TableauConnectionDetails!`): Connection
      parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_looker_credentials_v2 = sgqlc.types.Field('TestLookerCredentialsV2', graphql_name='testLookerCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(LookerConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Looker API credentials

    Arguments:

    * `connection_details` (`LookerConnectionDetails!`): Connection
      parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_looker_git_ssh_credentials_v2 = sgqlc.types.Field('TestLookerGitSshCredentialsV2', graphql_name='testLookerGitSshCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(LookerGitSshConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test the connection to a Git repository using the SSH protocol

    Arguments:

    * `connection_details` (`LookerGitSshConnectionDetails!`):
      Connection parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_looker_git_clone_credentials_v2 = sgqlc.types.Field('TestLookerGitCloneCredentialsV2', graphql_name='testLookerGitCloneCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(LookerGitCloneConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test the connection to a Git repository using the HTTPS protocol

    Arguments:

    * `connection_details` (`LookerGitCloneConnectionDetails!`):
      Connection parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_power_bi_credentials_v2 = sgqlc.types.Field('TestPowerBICredentialsV2', graphql_name='testPowerBiCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(PowerBIConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Databricks SQL Warehouse credentials

    Arguments:

    * `connection_details` (`PowerBIConnectionDetails!`): Connection
      parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_databricks_credentials_v2 = sgqlc.types.Field('TestDatabricksCredentialsV2', graphql_name='testDatabricksCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(SparkDatabricksInput), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('job_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='jobId', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Databricks credentials

    Arguments:

    * `connection_details` (`SparkDatabricksInput!`): Configuration
      for Databricks.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `job_id` (`String!`): Databricks Job Id to validate.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_databricks_sql_warehouse_credentials_v2 = sgqlc.types.Field('TestDatabricksSqlWarehouseCredentialsV2', graphql_name='testDatabricksSqlWarehouseCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(DatabricksSqlWarehouseInput), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Power BI credentials

    Arguments:

    * `connection_details` (`DatabricksSqlWarehouseInput!`):
      Connection parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_databricks_metastore_sql_warehouse_credentials_v2 = sgqlc.types.Field('TestDatabricksMetastoreSqlWarehouseCredentialsV2', graphql_name='testDatabricksMetastoreSqlWarehouseCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(DatabricksSqlWarehouseInput), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Databricks Metastore Sql Warehouse credentials

    Arguments:

    * `connection_details` (`DatabricksSqlWarehouseInput!`):
      Connection parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_databricks_spark_credentials_v2 = sgqlc.types.Field('TestDatabricksSparkCredentialsV2', graphql_name='testDatabricksSparkCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(SparkDatabricksInput), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Databricks AP Cluster credentials

    Arguments:

    * `connection_details` (`SparkDatabricksInput!`): Configuration
      for Databricks.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    test_airflow_credentials_v2 = sgqlc.types.Field('TestAirflowCredentialsV2', graphql_name='testAirflowCredentialsV2', args=sgqlc.types.ArgDict((
        ('connection_details', sgqlc.types.Arg(sgqlc.types.non_null(AirflowConnectionDetails), graphql_name='connectionDetails', default=None)),
        ('connection_options', sgqlc.types.Arg(ConnectionTestOptions, graphql_name='connectionOptions', default=None)),
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
))
    )
    '''Test Airflow credentials

    Arguments:

    * `connection_details` (`AirflowConnectionDetails!`): Connection
      parameters.
    * `connection_options` (`ConnectionTestOptions`): Common options
      for integration tests.
    * `validation_name` (`String!`): Name of the validation test that
      should be run.
    '''

    upload_airflow_dag_result = sgqlc.types.Field('UploadAirflowDagResult', graphql_name='uploadAirflowDagResult', args=sgqlc.types.ArgDict((
        ('dag_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='dagId', default=None)),
        ('end_date', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='endDate', default=None)),
        ('env', sgqlc.types.Arg(sgqlc.types.non_null(AirflowEnvInput), graphql_name='env', default=None)),
        ('execution_date', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='executionDate', default=None)),
        ('payload', sgqlc.types.Arg(sgqlc.types.non_null(GenericScalar), graphql_name='payload', default=None)),
        ('reason', sgqlc.types.Arg(String, graphql_name='reason', default=None)),
        ('resource_name', sgqlc.types.Arg(String, graphql_name='resourceName', default=None)),
        ('run_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='runId', default=None)),
        ('start_date', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startDate', default=None)),
        ('state', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='state', default=None)),
        ('success', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='success', default=None)),
))
    )
    '''Upload Airflow DAG run result

    Arguments:

    * `dag_id` (`String!`): DAG identifier
    * `end_date` (`DateTime!`): 'end_date' as returned by Airflow
    * `env` (`AirflowEnvInput!`): Airflow environment information
    * `execution_date` (`DateTime!`): 'execution_date' as returned by
      Airflow
    * `payload` (`GenericScalar!`): Payload for the result, a JSON
      object containing all data gathered form Airflow on the
      callbacks.
    * `reason` (`String`): 'reason' field from Airflow Run
    * `resource_name` (`String`): ETL container name used to
      disambiguate if there are multiple Airflow connections in the
      account. If there's not a single active Airflow connection in
      the given ETL container an error will be thrown. If no
      resource_name is specified then it's expected to be a single
      active Airflow connection on the account.
    * `run_id` (`String!`): DAG Run Identifier
    * `start_date` (`DateTime!`): 'start_date' as returned by Airflow
    * `state` (`String!`): Airflow state, for example success, failed,
      up_for_retry, etc.
    * `success` (`Boolean!`): Flag indicating if the result was
      successful or not
    '''

    upload_airflow_task_result = sgqlc.types.Field('UploadAirflowTaskResult', graphql_name='uploadAirflowTaskResult', args=sgqlc.types.ArgDict((
        ('attempt_number', sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name='attemptNumber', default=None)),
        ('dag_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='dagId', default=None)),
        ('duration', sgqlc.types.Arg(Float, graphql_name='duration', default=None)),
        ('end_date', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='endDate', default=None)),
        ('env', sgqlc.types.Arg(sgqlc.types.non_null(AirflowEnvInput), graphql_name='env', default=None)),
        ('exception_message', sgqlc.types.Arg(String, graphql_name='exceptionMessage', default=None)),
        ('execution_date', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='executionDate', default=None)),
        ('log_url', sgqlc.types.Arg(String, graphql_name='logUrl', default=None)),
        ('next_retry_date', sgqlc.types.Arg(DateTime, graphql_name='nextRetryDate', default=None)),
        ('payload', sgqlc.types.Arg(sgqlc.types.non_null(GenericScalar), graphql_name='payload', default=None)),
        ('resource_name', sgqlc.types.Arg(String, graphql_name='resourceName', default=None)),
        ('run_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='runId', default=None)),
        ('start_date', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startDate', default=None)),
        ('state', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='state', default=None)),
        ('success', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='success', default=None)),
        ('task_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='taskId', default=None)),
))
    )
    '''Upload Airflow Task run result

    Arguments:

    * `attempt_number` (`Int!`): Attempt number for this Task Run, 1
      for the first attempt.
    * `dag_id` (`String!`): DAG identifier
    * `duration` (`Float`): Task Run duration in seconds
    * `end_date` (`DateTime!`): 'end_date' as returned by Airflow
    * `env` (`AirflowEnvInput!`): Airflow environment information
    * `exception_message` (`String`): Exception message obtained from
      Airflow 'exception' attribute
    * `execution_date` (`DateTime!`): 'execution_date' as returned by
      Airflow
    * `log_url` (`String`): URL to access the log for this Task Run
    * `next_retry_date` (`DateTime`): Datetime for the next retry as
      returned by Airflow
    * `payload` (`GenericScalar!`): Payload for the result, a JSON
      object containing all data gathered form Airflow on the
      callbacks.
    * `resource_name` (`String`): ETL container name used to
      disambiguate if there are multiple Airflow connections in the
      account. If there's not a single active Airflow connection in
      the given ETL container an error will be thrown. If no
      resource_name is specified then it's expected to be a single
      active Airflow connection on the account.
    * `run_id` (`String!`): DAG Run Identifier
    * `start_date` (`DateTime!`): 'start_date' as returned by Airflow
    * `state` (`String!`): Airflow state, for example success, failed,
      up_for_retry, etc.
    * `success` (`Boolean!`): Flag indicating if the result was
      successful or not
    * `task_id` (`String!`): Airflow Task ID
    '''

    upload_airflow_sla_misses = sgqlc.types.Field('UploadAirflowSlaMisses', graphql_name='uploadAirflowSlaMisses', args=sgqlc.types.ArgDict((
        ('dag_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='dagId', default=None)),
        ('env', sgqlc.types.Arg(sgqlc.types.non_null(AirflowEnvInput), graphql_name='env', default=None)),
        ('payload', sgqlc.types.Arg(sgqlc.types.non_null(GenericScalar), graphql_name='payload', default=None)),
        ('resource_name', sgqlc.types.Arg(String, graphql_name='resourceName', default=None)),
))
    )
    '''Upload Airflow SLA misses

    Arguments:

    * `dag_id` (`String!`): DAG identifier
    * `env` (`AirflowEnvInput!`): Airflow environment information
    * `payload` (`GenericScalar!`): Payload for the result, a JSON
      object containing all data gathered form Airflow on the
      callbacks.
    * `resource_name` (`String`): ETL container name used to
      disambiguate if there are multiple Airflow connections in the
      account. If there's not a single active Airflow connection in
      the given ETL container an error will be thrown. If no
      resource_name is specified then it's expected to be a single
      active Airflow connection on the account.
    '''

    create_or_update_alation_integration = sgqlc.types.Field(CreateOrUpdateAlationIntegration, graphql_name='createOrUpdateAlationIntegration', args=sgqlc.types.ArgDict((
        ('dc_proxy', sgqlc.types.Arg(Boolean, graphql_name='dcProxy', default=False)),
        ('disable_ssl_verification', sgqlc.types.Arg(Boolean, graphql_name='disableSslVerification', default=False)),
        ('integration_uuid', sgqlc.types.Arg(UUID, graphql_name='integrationUuid', default=None)),
        ('password', sgqlc.types.Arg(String, graphql_name='password', default=None)),
        ('server_url', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='serverUrl', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
))
    )
    '''Create or update Alation integration

    Arguments:

    * `dc_proxy` (`Boolean`): Whether to proxy requests to the Alation
      instance via the data collector (default: `false`)
    * `disable_ssl_verification` (`Boolean`): Whether to disable SSL
      when proxying requests via the data collector (default: `false`)
    * `integration_uuid` (`UUID`): The integration to update
    * `password` (`String`): ('The Alation service account password
      for authentication; if not provided, previous value will be
      used',)
    * `server_url` (`String!`): The url for your Alation instance
    * `username` (`String`): ('The Alation service account username
      for authentication; if not provided, previous value will be
      used',)
    '''

    delete_alation_integration = sgqlc.types.Field(DeleteAlationIntegration, graphql_name='deleteAlationIntegration', args=sgqlc.types.ArgDict((
        ('integration_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationUuid', default=None)),
))
    )
    '''Delete Alation integration

    Arguments:

    * `integration_uuid` (`UUID!`): The integration ID
    '''

    create_or_update_alation_table_flag = sgqlc.types.Field(CreateOrUpdateAlationTableFlag, graphql_name='createOrUpdateAlationTableFlag', args=sgqlc.types.ArgDict((
        ('flag_reason', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='flagReason', default=None)),
        ('flag_type', sgqlc.types.Arg(sgqlc.types.non_null(TableFlagType), graphql_name='flagType', default=None)),
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Create or update Alation flag on a table. The flag could be a
    warning or a deprecation.

    Arguments:

    * `flag_reason` (`String!`): This may be a reason or a description
      of the flag.Should only be set for DEPRECATION and WARNING.
    * `flag_type` (`TableFlagType!`): The type of the flag
    * `mcon` (`String!`): The MCON of the table
    '''

    set_etl_job_generates_incidents = sgqlc.types.Field('SetEtlJobGeneratesIncidents', graphql_name='setEtlJobGeneratesIncidents', args=sgqlc.types.ArgDict((
        ('generates_incidents', sgqlc.types.Arg(sgqlc.types.non_null(Boolean), graphql_name='generatesIncidents', default=None)),
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Configures if incidents should be generated or not when a given
    ETL Job (like an Airflow DAG) fails

    Arguments:

    * `generates_incidents` (`Boolean!`): should generate incidents
    * `mcon` (`String!`): job mcon
    '''

    create_account_secret = sgqlc.types.Field(CreateAccountSecret, graphql_name='createAccountSecret', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('expires_at', sgqlc.types.Arg(DateTime, graphql_name='expiresAt', default=None)),
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
        ('scope', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='scope', default=None)),
        ('value', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='value', default=None)),
))
    )
    '''Create an account secret

    Arguments:

    * `description` (`String`): The secret description
    * `expires_at` (`DateTime`): When does the secret expire. Null if
      it doesn't expire.
    * `name` (`String!`): The secret name
    * `scope` (`String!`): The secret scope
    * `value` (`String!`): The secret value.
    '''

    update_account_secret = sgqlc.types.Field('UpdateAccountSecret', graphql_name='updateAccountSecret', args=sgqlc.types.ArgDict((
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('expires_at', sgqlc.types.Arg(DateTime, graphql_name='expiresAt', default=None)),
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
        ('scope', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='scope', default=None)),
        ('value', sgqlc.types.Arg(String, graphql_name='value', default=None)),
))
    )
    '''Update an account secret

    Arguments:

    * `description` (`String`): The secret description
    * `expires_at` (`DateTime`): When does the secret expire. Null if
      it doesn't expire.
    * `name` (`String!`): The secret name
    * `scope` (`String!`): The secret scope
    * `value` (`String`): The secret value. If not provided, the value
      will not be changed.
    '''

    delete_account_secret = sgqlc.types.Field(DeleteAccountSecret, graphql_name='deleteAccountSecret', args=sgqlc.types.ArgDict((
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
))
    )
    '''Delete an account secret

    Arguments:

    * `name` (`String!`): The secret name
    '''



class NameRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name',)
    name = sgqlc.types.Field(String, graphql_name='name')



class NestedHighlightSnippets(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('offset', 'inner_hit_snippets')
    offset = sgqlc.types.Field(Int, graphql_name='offset')
    '''Offset into nested field'''

    inner_hit_snippets = sgqlc.types.Field(sgqlc.types.list_of(HighlightSnippets), graphql_name='innerHitSnippets')
    '''Highlighted snippet of inner hit'''



class NextPageInfo(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('has_next_page', 'end_cursor')
    has_next_page = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasNextPage')
    '''When paginating forwards, are there more items?'''

    end_cursor = sgqlc.types.Field(String, graphql_name='endCursor')
    '''If there is next page, use this cursor to continue'''



class NodeProperties(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('workbook_id', 'friendly_name', 'content_url', 'owner_id', 'project_id', 'project_name', 'created', 'updated', 'total_views', 'workbook_creators', 'view_id', 'category', 'mcon', 'name', 'display_name', 'table_id', 'data_set', 'node_id', 'resource', 'sampling')
    workbook_id = sgqlc.types.Field(String, graphql_name='workbookId')

    friendly_name = sgqlc.types.Field(String, graphql_name='friendlyName')

    content_url = sgqlc.types.Field(String, graphql_name='contentUrl')

    owner_id = sgqlc.types.Field(String, graphql_name='ownerId')

    project_id = sgqlc.types.Field(String, graphql_name='projectId')

    project_name = sgqlc.types.Field(String, graphql_name='projectName')

    created = sgqlc.types.Field(DateTime, graphql_name='created')

    updated = sgqlc.types.Field(DateTime, graphql_name='updated')

    total_views = sgqlc.types.Field(Int, graphql_name='totalViews')

    workbook_creators = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='workbookCreators')

    view_id = sgqlc.types.Field(String, graphql_name='viewId')

    category = sgqlc.types.Field(String, graphql_name='category')
    '''Node type'''

    mcon = sgqlc.types.Field(String, graphql_name='mcon')
    '''Monte Carlo object name'''

    name = sgqlc.types.Field(String, graphql_name='name')
    '''Object name (table name, report name, etc)'''

    display_name = sgqlc.types.Field(String, graphql_name='displayName')
    '''Friendly display name'''

    table_id = sgqlc.types.Field(String, graphql_name='tableId')

    data_set = sgqlc.types.Field(String, graphql_name='dataSet')

    node_id = sgqlc.types.Field(String, graphql_name='nodeId')
    '''Lineage node id, to be deprecated in favor of MCONs'''

    resource = sgqlc.types.Field(String, graphql_name='resource')
    '''Resource containing this object (warehouse, Tableau account, etc)'''

    sampling = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='sampling')
    '''A subset of the nodes that were collapsed into a node, only
    present on nodes of type collapsed-etl or collapsed-ext
    '''



class NonTableMetric(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metric', 'value', 'measurement_timestamp', 'dimensions', 'job_execution_uuid', 'thresholds')
    metric = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='metric')
    '''Metric for which to fetch results. E.g; custom_metric_uuid'''

    value = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='value')
    '''Measurement value for the metric'''

    measurement_timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='measurementTimestamp')
    '''Time when measurement value was obtained'''

    dimensions = sgqlc.types.Field(MetricDimensions, graphql_name='dimensions')
    '''List of key/value dimension pairs applied as filters'''

    job_execution_uuid = sgqlc.types.Field(UUID, graphql_name='jobExecutionUuid')
    '''UUID of the job execution that produced the measurement'''

    thresholds = sgqlc.types.Field(sgqlc.types.list_of('Threshold'), graphql_name='thresholds')
    '''Thresholds'''



class NonTableMetrics(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metrics', 'is_partial_date_range')
    metrics = sgqlc.types.Field(sgqlc.types.list_of(NonTableMetric), graphql_name='metrics')

    is_partial_date_range = sgqlc.types.Field(Boolean, graphql_name='isPartialDateRange')



class NotificationAudience(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('uuid', 'account_uuid', 'label', 'created_by', 'routing_rules', 'notification_settings', 'routing_rules_count', 'custom_monitors', 'custom_monitors_count', 'notification_settings_count', 'incident_count_history', 'incident_count')
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Unique identifier of a monitor label'''

    account_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='accountUuid')
    '''Account identifier'''

    label = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='label')
    '''Monitor label name'''

    created_by = sgqlc.types.Field('User', graphql_name='createdBy')
    '''Monitor label creator'''

    routing_rules = sgqlc.types.Field('NotificationRoutingRuleConnection', graphql_name='routingRules', args=sgqlc.types.ArgDict((
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Routing rules for this audience

    Arguments:

    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    notification_settings = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('NotificationSetting')), graphql_name='notificationSettings')
    '''Notification settings for this audience'''

    routing_rules_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='routingRulesCount')
    '''Number of routing rules for this audience'''

    custom_monitors = sgqlc.types.Field(AudienceMonitorConnection, graphql_name='customMonitors', args=sgqlc.types.ArgDict((
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Custom monitors for this audience

    Arguments:

    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    custom_monitors_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='customMonitorsCount')
    '''Number of custom monitors for this audience'''

    notification_settings_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='notificationSettingsCount')
    '''Number of notification settings for this audience'''

    incident_count_history = sgqlc.types.Field(sgqlc.types.list_of('NotificationIncidentDailyCount'), graphql_name='incidentCountHistory')
    '''Number of incidents per day for the past 30 days'''

    incident_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='incidentCount')
    '''The number of distinct notified incidents in the past 30 days'''



class NotificationDailyCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('day', 'notification_count')
    day = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='day')
    '''The date for the notification count'''

    notification_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='notificationCount')
    '''The notification count'''



class NotificationIncidentDailyCount(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('day', 'incident_count')
    day = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='day')
    '''The date for the notification count'''

    incident_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='incidentCount')
    '''The number of distinct notified incidents'''



class NotificationRoutingRule(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('uuid', 'table_rules', 'tag_rules', 'sql_rules', 'table_stats_rules', 'domain_rules', 'table_id_rules', 'anomaly_types', 'incident_sub_types', 'custom_message', 'digest_settings', 'audience', 'incident_count_history', 'incident_count')
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''The route rule id'''

    table_rules = sgqlc.types.Field(String, graphql_name='tableRules')
    '''Table/dataset based rules (regex)'''

    tag_rules = sgqlc.types.Field(JSONString, graphql_name='tagRules')
    '''Key and key/value based rules'''

    sql_rules = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name='sqlRules')
    '''Custom sql rules'''

    table_stats_rules = sgqlc.types.Field(JSONString, graphql_name='tableStatsRules')
    '''Rules based on table stats (importance_score, is_important).'''

    domain_rules = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(UUID)), graphql_name='domainRules')
    '''List of domain UUIDs to match event objects against.'''

    table_id_rules = sgqlc.types.Field(JSONString, graphql_name='tableIdRules')
    '''Project/dataset/table based rules'''

    anomaly_types = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='anomalyTypes')
    '''List of supported incident types to send notifications for'''

    incident_sub_types = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='incidentSubTypes')
    '''All the incident sub-types this notification settings will alert
    on.
    '''

    custom_message = sgqlc.types.Field(String, graphql_name='customMessage')
    '''Custom text to be included with the notification'''

    digest_settings = sgqlc.types.Field(AccountNotificationDigestSettings, graphql_name='digestSettings')
    '''Digest notification settings for events matching the rule'''

    audience = sgqlc.types.Field(NotificationAudience, graphql_name='audience')

    incident_count_history = sgqlc.types.Field(sgqlc.types.list_of(NotificationIncidentDailyCount), graphql_name='incidentCountHistory')
    '''Number of incidents per day for the past 30 days'''

    incident_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='incidentCount')
    '''The number of distinct notified incidents in the past 30 days'''



class NotificationRoutingRuleConnection(sgqlc.types.relay.Connection):
    '''Notification routing rules response'''
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('NotificationRoutingRuleEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class NotificationRoutingRuleEdge(sgqlc.types.Type):
    '''A Relay edge containing a `NotificationRoutingRule` and its
    cursor.
    '''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field(NotificationRoutingRule, graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class NotificationSetting(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('uuid', 'created_by', 'created_time', 'last_updated_by', 'last_update_time', 'name', 'is_template_managed', 'namespace', 'type', 'recipients', 'extra', 'notification_enabled', 'audience', 'recipients_display_names', 'incident_count_history', 'incident_count', 'integration_id')
    uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='uuid')
    '''Effective ID for notification settings'''

    created_by = sgqlc.types.Field('User', graphql_name='createdBy')
    '''Creator of the notification'''

    created_time = sgqlc.types.Field(DateTime, graphql_name='createdTime')
    '''When the notification was first created'''

    last_updated_by = sgqlc.types.Field('User', graphql_name='lastUpdatedBy')
    '''User who last updated this notification'''

    last_update_time = sgqlc.types.Field(DateTime, graphql_name='lastUpdateTime')
    '''When the notification was last updated'''

    name = sgqlc.types.Field(String, graphql_name='name')
    '''Resource name for notifications created through notifications-as-
    code
    '''

    is_template_managed = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='isTemplateManaged')
    '''Is this monitor managed by a configuration template
    (notifications-as-code)?
    '''

    namespace = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='namespace')
    '''Namespace of notification, used for notifications-as-code'''

    type = sgqlc.types.Field(sgqlc.types.non_null(AccountNotificationSettingsModelType), graphql_name='type')
    '''Type of notification integration (e.g. slack)'''

    recipients = sgqlc.types.Field(sgqlc.types.list_of(sgqlc.types.non_null(String)), graphql_name='recipients')
    '''Destinations to send notifications to'''

    extra = sgqlc.types.Field(JSONString, graphql_name='extra')
    '''Any additional information for various notification integrations'''

    notification_enabled = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='notificationEnabled')
    '''When enabled notifications for this setting are sent.'''

    audience = sgqlc.types.Field(NotificationAudience, graphql_name='audience')

    recipients_display_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='recipientsDisplayNames')

    incident_count_history = sgqlc.types.Field(sgqlc.types.list_of(NotificationIncidentDailyCount), graphql_name='incidentCountHistory')
    '''Number of incidents per day for the past 30 days'''

    incident_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='incidentCount')
    '''The number of distinct notified incidents in the past 30 days'''

    integration_id = sgqlc.types.Field(UUID, graphql_name='integrationId')
    '''Integration ID for the recipient'''



class ObjectDocument(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('mcon', 'resource_id', 'object_id', 'object_type', 'display_name', 'field_metadata', 'table_metadata', 'bi_metadata', 'properties')
    mcon = sgqlc.types.Field(String, graphql_name='mcon')

    resource_id = sgqlc.types.Field(String, graphql_name='resourceId')

    object_id = sgqlc.types.Field(String, graphql_name='objectId')

    object_type = sgqlc.types.Field(String, graphql_name='objectType')

    display_name = sgqlc.types.Field(String, graphql_name='displayName')

    field_metadata = sgqlc.types.Field(FieldMetadata, graphql_name='fieldMetadata')

    table_metadata = sgqlc.types.Field('TableMetadata', graphql_name='tableMetadata')

    bi_metadata = sgqlc.types.Field(BiMetadata, graphql_name='biMetadata')

    properties = sgqlc.types.Field(sgqlc.types.list_of('ObjectPropertyEntry'), graphql_name='properties')



class ObjectPropertyConnection(sgqlc.types.relay.Connection):
    __schema__ = schema
    __field_names__ = ('page_info', 'edges')
    page_info = sgqlc.types.Field(sgqlc.types.non_null('PageInfo'), graphql_name='pageInfo')
    '''Pagination data for this connection.'''

    edges = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('ObjectPropertyEdge')), graphql_name='edges')
    '''Contains the nodes in this connection.'''



class ObjectPropertyEdge(sgqlc.types.Type):
    '''A Relay edge containing a `ObjectProperty` and its cursor.'''
    __schema__ = schema
    __field_names__ = ('node', 'cursor')
    node = sgqlc.types.Field('ObjectProperty', graphql_name='node')
    '''The item at the end of the edge'''

    cursor = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='cursor')
    '''A cursor for use in pagination'''



class ObjectPropertyEntry(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name', 'value')
    name = sgqlc.types.Field(String, graphql_name='name')

    value = sgqlc.types.Field(String, graphql_name='value')



class OwnerRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name', 'username', 'email')
    name = sgqlc.types.Field(String, graphql_name='name')

    username = sgqlc.types.Field(String, graphql_name='username')

    email = sgqlc.types.Field(String, graphql_name='email')



class PageInfo(sgqlc.types.Type):
    '''The Relay compliant `PageInfo` type, containing data necessary to
    paginate this connection.
    '''
    __schema__ = schema
    __field_names__ = ('has_next_page', 'has_previous_page', 'start_cursor', 'end_cursor')
    has_next_page = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasNextPage')
    '''When paginating forwards, are there more items?'''

    has_previous_page = sgqlc.types.Field(sgqlc.types.non_null(Boolean), graphql_name='hasPreviousPage')
    '''When paginating backwards, are there more items?'''

    start_cursor = sgqlc.types.Field(String, graphql_name='startCursor')
    '''When paginating backwards, the cursor to continue.'''

    end_cursor = sgqlc.types.Field(String, graphql_name='endCursor')
    '''When paginating forwards, the cursor to continue.'''



class PaginateQueriesBlastRadius(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('after_key', 'data')
    after_key = sgqlc.types.Field('QueryAfterKey', graphql_name='afterKey')
    '''The after key to use for pagination'''

    data = sgqlc.types.Field(sgqlc.types.list_of('QueryBlastRadius'), graphql_name='data')
    '''The user blast radius data'''



class PaginateQueriesBlastRadius2(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('after_key', 'data')
    after_key = sgqlc.types.Field('UserAfterKey2', graphql_name='afterKey')
    '''The after key to user for pagination'''

    data = sgqlc.types.Field(sgqlc.types.list_of('QueryBlastRadius2'), graphql_name='data')
    '''The user blast radius data'''



class PaginateQueriesBlastRadiusSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('after_key', 'data')
    after_key = sgqlc.types.Field('UserAfterKey2', graphql_name='afterKey')
    '''The after key to user for pagination'''

    data = sgqlc.types.Field(sgqlc.types.list_of('QueryBlastRadiusSummary'), graphql_name='data')
    '''The user blast radius data'''



class PaginateUsersBlastRadius(sgqlc.types.Type):
    '''Deprecated'''
    __schema__ = schema
    __field_names__ = ('after_key', 'data')
    after_key = sgqlc.types.Field('UserAfterKey', graphql_name='afterKey')
    '''The after key to use for pagination. Deprecated.'''

    data = sgqlc.types.Field(sgqlc.types.list_of('UserBlastRadius'), graphql_name='data')
    '''The user blast radius data. Deprecated.'''



class PaginateUsersBlastRadius2(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('after_key', 'data')
    after_key = sgqlc.types.Field('UserAfterKey2', graphql_name='afterKey')
    '''The after key to use for pagination'''

    data = sgqlc.types.Field(sgqlc.types.list_of('UserBlastRadius2'), graphql_name='data')
    '''The user blast radius data'''



class ParsedQueryResult(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('parsed_query',)
    parsed_query = sgqlc.types.Field(String, graphql_name='parsedQuery')
    '''Query, based on which the table's created'''



class PauseMonitor(sgqlc.types.Type):
    '''Pause a monitor from collecting data.' '''
    __schema__ = schema
    __field_names__ = ('monitor',)
    monitor = sgqlc.types.Field('MetricMonitoring', graphql_name='monitor')
    '''The monitor whose pause property has been toggled.'''



class PauseRule(sgqlc.types.Type):
    '''Pause a rule from collecting data or triggering notifications'''
    __schema__ = schema
    __field_names__ = ('rule',)
    rule = sgqlc.types.Field('CustomRule', graphql_name='rule')
    '''The rule whose pause property has been toggled.'''



class PiiFilterMetricOutput(sgqlc.types.Type):
    '''A container for PII filter metrics per completed job execution
    aggregated by job type, warehouse and PII filter name.
    '''
    __schema__ = schema
    __field_names__ = ('filter_name', 'job_type', 'resource_id', 'total_replacements')
    filter_name = sgqlc.types.Field(String, graphql_name='filterName')
    '''The unique name for the filter that was run.'''

    job_type = sgqlc.types.Field(String, graphql_name='jobType')
    '''The type of job the PII filter run was a part of.'''

    resource_id = sgqlc.types.Field(UUID, graphql_name='resourceId')
    '''The UUID of the resource the PII filtering ran on.'''

    total_replacements = sgqlc.types.Field(Int, graphql_name='totalReplacements')
    '''Total number of text occurrences replaced by this filter across
    the job runs.
    '''



class PiiFilterOutput(sgqlc.types.Type):
    '''A container for a regex pattern used to match data for redaction
    of PII information.
    '''
    __schema__ = schema
    __field_names__ = ('name', 'description', 'pattern', 'on_by_default', 'enabled')
    name = sgqlc.types.Field(String, graphql_name='name')
    '''The unique name of the PII filter.'''

    description = sgqlc.types.Field(String, graphql_name='description')
    '''The explanation of the PII filter's purpose.'''

    pattern = sgqlc.types.Field(String, graphql_name='pattern')
    '''The regex matching pattern of the PII filter.'''

    on_by_default = sgqlc.types.Field(Boolean, graphql_name='onByDefault')
    '''Whether this PII filter is on by default globally.'''

    enabled = sgqlc.types.Field(Boolean, graphql_name='enabled')
    '''Whether this PII filter is enabled for this account.'''



class PiiFilteringPreferencesOutput(sgqlc.types.Type):
    '''A container describing this account's PII filtering customizations
    and settings.
    '''
    __schema__ = schema
    __field_names__ = ('enabled', 'fail_mode')
    enabled = sgqlc.types.Field(Boolean, graphql_name='enabled')
    '''Whether PII filtering is enabled for this account.'''

    fail_mode = sgqlc.types.Field(PiiFilteringFailModeType, graphql_name='failMode')
    '''Whether PII filter failures will allow (open) or prevent (close)
    data flow for this account.
    '''



class PipelineFreshness(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metric_values_by_table', 'is_partial_date_range')
    metric_values_by_table = sgqlc.types.Field(sgqlc.types.list_of(MetricValueByTable), graphql_name='metricValuesByTable')

    is_partial_date_range = sgqlc.types.Field(Boolean, graphql_name='isPartialDateRange')



class PlatformRegionProperties(sgqlc.types.Type):
    '''Region-specific platform properties'''
    __schema__ = schema
    __field_names__ = ('gateway_endpoint', 'gateway_vpce', 'linker_arn', 'log_arn', 'template_launch_url')
    gateway_endpoint = sgqlc.types.Field(String, graphql_name='gatewayEndpoint')
    '''Gateway endpoint URL'''

    gateway_vpce = sgqlc.types.Field(String, graphql_name='gatewayVpce')
    '''Gateway VPC id'''

    linker_arn = sgqlc.types.Field(String, graphql_name='linkerArn')
    '''ARN of SNS topic used to link data collector deployment'''

    log_arn = sgqlc.types.Field(String, graphql_name='logArn')
    '''ARN of CloudWatch log destination for cross-account log
    subscriptions
    '''

    template_launch_url = sgqlc.types.Field(String, graphql_name='templateLaunchUrl')
    '''CloudFormation template launch URL'''



class PowerBIDashboardTileRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('tile_id', 'tile_title', 'tile_sub_title', 'report_name', 'report_id')
    tile_id = sgqlc.types.Field(String, graphql_name='tileId')

    tile_title = sgqlc.types.Field(String, graphql_name='tileTitle')

    tile_sub_title = sgqlc.types.Field(String, graphql_name='tileSubTitle')

    report_name = sgqlc.types.Field(String, graphql_name='reportName')

    report_id = sgqlc.types.Field(String, graphql_name='reportId')



class PowerBIWorkSpaceRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name', 'id', 'type', 'state', 'description')
    name = sgqlc.types.Field(String, graphql_name='name')

    id = sgqlc.types.Field(String, graphql_name='id')

    type = sgqlc.types.Field(String, graphql_name='type')

    state = sgqlc.types.Field(String, graphql_name='state')

    description = sgqlc.types.Field(String, graphql_name='description')



class PrimaryRcaData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('event_uuid', 'rca_uuid')
    event_uuid = sgqlc.types.Field(UUID, graphql_name='eventUuid')

    rca_uuid = sgqlc.types.Field(UUID, graphql_name='rcaUuid')



class ProjectEntity(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('project_id', 'friendly_name')
    project_id = sgqlc.types.Field(String, graphql_name='projectId')
    '''Project ID'''

    friendly_name = sgqlc.types.Field(String, graphql_name='friendlyName')
    '''Friendly name of the project'''



class Projects(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('projects',)
    projects = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='projects')



class PropertyNameValue(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('name', 'value')
    name = sgqlc.types.Field(String, graphql_name='name')

    value = sgqlc.types.Field(String, graphql_name='value')



class PropertyNameValues(sgqlc.types.Type):
    '''All unique object property names/values'''
    __schema__ = schema
    __field_names__ = ('property_name_values', 'has_next_page')
    property_name_values = sgqlc.types.Field(sgqlc.types.list_of(PropertyNameValue), graphql_name='propertyNameValues')
    '''List of unique object property name/value pairs'''

    has_next_page = sgqlc.types.Field(Boolean, graphql_name='hasNextPage')
    '''there are more pages to be retrieved'''



class PropertyNames(sgqlc.types.Type):
    '''All unique object property names'''
    __schema__ = schema
    __field_names__ = ('property_names',)
    property_names = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='propertyNames')
    '''List of object property names'''



class PropertyValues(sgqlc.types.Type):
    '''All unique object property names'''
    __schema__ = schema
    __field_names__ = ('property_values',)
    property_values = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='propertyValues')
    '''List of object property values'''



class QPMonitorExplanationType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('data_points', 'breaching_query_logs')
    data_points = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(ExplanationDataPointType)), graphql_name='dataPoints')
    '''List of data points, with metrics that explain monitor evaluation'''

    breaching_query_logs = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of('QueryLogResultType')), graphql_name='breachingQueryLogs')
    '''List of breaching query logs'''



class QPMonitorSimulationType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('breaching_query_groups', 'breaching_query_groups_daily_count')
    breaching_query_groups = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='breachingQueryGroups')
    '''List of breaching query groups'''

    breaching_query_groups_daily_count = sgqlc.types.Field(sgqlc.types.list_of(DataPoint), graphql_name='breachingQueryGroupsDailyCount')
    '''Daily count of breaching query groups over evaluation period'''



class Query(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('retrieve_comparison_widget_data', 'get_data_explorer_comparison_dashboards', 'get_comparable_dashboards', 'retrieve_table_data', 'retrieve_widget_data', 'get_data_explorer_table_metadata', 'get_data_explorer_dashboards', 'get_webex_integrations', 'test_webex_credentials', 'get_assets_usage', 'get_monitored_table_rule_list', 'get_streaming_systems', 'get_tableau_asset_warning_by_id', 'get_etl_job', 'get_etl_task', 'get_etl_jobs', 'get_data_product', 'get_data_products', 'get_data_product_metrics', 'parse_query', 'ping_data_collector', 'get_github_integrations', 'get_github_pull_requests', 'get_github_pull_requests_for_table', 'get_github_pull_requests_for_table_v2', 'get_size_collection_configuration', 'get_size_collection_query', 'get_servicenow_integrations', 'test_servicenow_credentials', 'get_jira_integrations', 'get_jira_statuses', 'get_jira_projects', 'get_jira_issue_types', 'test_jira_credentials', 'get_query_perf_rule_execution_history_logs', 'simulate_query_perf_monitor_evaluation', 'get_query_perf_monitor_explanation_for_event', 'get_query_perf_monitor_explanation', 'get_indexed_field_specs', 'get_query_logs', 'get_query_logs_facets_v2', 'get_query_logs_facets', 'get_query_runtime_percentile_timeseries', 'get_query_performance_data', 'get_top_query_groups', 'get_aggregated_queries', 'get_query_rcas', 'get_query_dimensions', 'get_query_text', 'get_notification_audiences', 'get_notification_settings', 'get_collection_dataset_list', 'get_collection_block_list', 'get_fivetran_connectors', 'get_pii_filtering_preferences', 'get_pii_filters', 'get_pii_filter_metrics', 'get_dbt_connections', 'get_dbt_connection_details', 'get_dbt_projects', 'get_dbt_jobs', 'get_dbt_nodes', 'get_dbt_runs', 'get_dbt_models', 'get_dbt_model_results', 'get_dbt_model_results_count', 'get_dbt_run_steps', 'get_dbt_test_results_count', 'get_dbt_test_results', 'get_dbt_upload_url', 'get_dbt_last_run_results', 'get_dbt_job_executions', 'get_exec_dashboard_metrics', 'get_exec_dashboard_tables', 'get_custom_users', 'get_unified_users', 'get_unified_user_assignments', 'get_monte_carlo_config_templates', 'export_monte_carlo_config_templates', 'get_monte_carlo_config_template_update_state', 'get_correlation_sampling_metadata', 'detect_time_axis_intrinsic_delta', 'perform_correlation_sampling', 'perform_correlation_sampling_with_time_travel', 'perform_field_health_sampling', 'get_rca_result', 'get_rca_job_result', 'get_incident_rcas', 'get_table_rcas', 'get_sensitivity', 'thresholds', 'get_thresholds', 'get_table_columns_lineage', 'get_derived_tables_partial_lineage', 'get_parsed_query', 'get_job_execution_history_logs', 'get_dimension_tracking_monitor_suggestions', 'get_field_health_monitor_suggestions', 'get_monitors', 'get_monitor_queries', 'test_monitor_queries', 'get_all_user_defined_monitors_v2', 'get_all_user_defined_monitors', 'get_custom_metrics', 'get_custom_rule', 'get_custom_rules', 'get_generated_rules', 'get_circuit_breaker_rule_state', 'get_circuit_breaker_rule_state_v2', 'get_run_sql_rule_state', 'get_tables_for_sql', 'get_notification_settings_for_rules_with', 'get_field_metric_query', 'get_field_query', 'get_query_template', 'get_custom_rule_execution_analytics', 'get_insights', 'get_insight', 'get_reports', 'get_report_url', 'get_lineage_node_block_pattern', 'get_lineage_node_block_patterns', 'get_lineage_node_replacement_rule', 'get_lineage_node_replacement_rules', 'get_lineage_node_collapsing_rules', 'get_lineage_node_collapsing_rule', 'simulate_lineage_node_replacement_rule', 'get_catalog_object_metadata', 'get_catalog_usage_nodes', 'get_catalog_nav_level_nodes', 'get_catalog_nav_grouped_nodes', 'get_object_properties', 'get_object_property_name_values', 'get_object_property_names', 'get_object_property_values', 'get_monitor_labels', 'monitor_labels', 'get_account_monitor_labels', 'get_custom_sql_templates', 'get_active_monitors', 'get_monitor_summary', 'get_monitors_by_type', 'get_monitor', 'get_monitor_configuration', 'get_monitor_scheduling_configuration', 'get_time_axis_sql_expressions', 'get_notification_settings_for_monitors_with', 'get_delta_logs', 'get_data_assets_dashboard', 'get_incident_dashboard_data', 'get_incident_data_weekly', 'get_monitor_dashboard_data', 'get_blast_radius_direct_users', 'get_blast_radius_direct_users_v2', 'get_blast_radius_direct_queries', 'get_blast_radius_direct_queries_v2', 'get_blast_radius_direct_queries_summary', 'get_incident_tables', 'get_incident_warehouse_tables', 'get_direct_blast_radius_counts', 'get_blast_radius_direct_queries_for_user', 'get_events', 'get_events_for_incidents', 'get_comments_for_monitor_incidents', 'get_event', 'get_event_comments', 'get_event_type_summary', 'get_incidents', 'get_incidents_filters', 'get_incidents_filters_data', 'get_incident_reaction', 'get_incident_summaries', 'get_incident_type_summary', 'get_incident_notification_settings_used', 'get_slack_messages_for_incident', 'get_slack_engagements_for_incident', 'get_slack_engagements_for_incidents', 'get_all_domains', 'get_domain', 'get_account_roles', 'get_authorization_groups', 'get_user_authorization', 'search', 'get_object', 'get_metadata', 'get_metrics_v3', 'get_metrics_v4', 'get_table_monitor_details', 'get_table_fields_monitor_details', 'get_non_table_metrics', 'get_aggregated_metrics', 'get_latest_table_access_timestamp_metrics', 'get_top_category_labels', 'get_segmented_where_condition_labels', 'get_first_seen_dimensions_by_labels', 'get_first_and_last_seen_dimensions_by_labels', 'get_downstream_bi', 'get_downstream_impact_radius_summary', 'get_downstream_reports', 'get_downstream_report_owners', 'get_downstream_report_types', 'get_table_lineage', 'get_connected_table_lineage', 'get_connected_table_lineage_with_jobs', 'get_external_source_paths_sample', 'get_tableau_workbook_count', 'get_query_list', 'get_query_by_id', 'get_query_by_query_hash', 'get_query_data_by_query_hash', 'get_query_data', 'get_query_log_hashes_that_affect_these_tables', 'get_query_log_hashes_on_these_tables', 'get_related_users', 'get_lineage_node_properties', 'get_digraph', 'get_pipeline_freshness_v2', 'get_custom_sql_output_sample', 'get_custom_sql_output_download', 'get_metric_sampling', 'get_fh_sampling', 'get_dt_sampling', 'get_fh_reproduction_query', 'get_dt_reproduction_query', 'run_custom_query', 'test_sql_query_part', 'test_sql_query_where_expression', 'get_table_stats_v2', 'get_table_stats', 'get_resource', 'get_resources', 'get_table_fields_importance', 'get_data_maintenance_entries', 'get_wildcard_templates', 'run_sql_investigation_query', 'get_common_fields', 'get_common_fields_v2', 'get_user_settings', 'get_user', 'get_user_by_id', 'get_warehouse', 'get_collection_properties', 'get_custom_volume_datapoints', 'get_custom_freshness_datapoints', 'get_table', 'get_tables', 'get_tables_health', 'get_bq_projects', 'get_slack_oauth_url', 'get_slack_channels', 'get_slack_channels_v2', 'get_projects', 'get_datasets_by_uuid', 'get_datasets', 'get_field_bi_lineage', 'get_event_muting_rules', 'get_users_in_account', 'get_invites_in_account', 'get_token_metadata', 'get_integration_keys', 'test_existing_connection', 'test_telnet_connection', 'test_tcp_open_connection', 'test_notification_integration', 'get_databricks_cluster_info', 'get_databricks_warehouse_info', 'get_databricks_notebook_link', 'get_databricks_metadata_job_info', 'get_current_databricks_notebook_version', 'validate_connection_type', 'get_event_onboarding_data', 'get_etl_containers', 'get_supported_validations_v2', 'get_supported_table_validations', 'validate_data_asset_access', 'test_existing_connection_v2', 'test_storage_access', 'test_data_store_reachability', 'test_agent_reachability', 'list_projects', 'list_datasets', 'get_account_audit_logs', 'get_monitor_audit_logs', 'get_alation_table_flags', 'get_airflow_task_results', 'get_airflow_task_stats', 'get_airflow_dag_runs', 'get_airflow_capabilities', 'fix_sql_query', 'create_sql_query', 'get_agent_operation_logs', 'get_gcp_agent_logs', 'get_azure_agent_logs', 'get_aws_agent_logs', 'start_aws_logs_query', 'stop_aws_logs_query', 'get_aws_logs_query_results', 'get_aws_agent_upgrade_logs', 'get_aws_agent_infra_details', 'get_account_secret', 'get_account_secrets')
    retrieve_comparison_widget_data = sgqlc.types.Field(DataResponseType, graphql_name='retrieveComparisonWidgetData', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(RetrieveComparisonWidgetDataRequestInput), graphql_name='request', default=None)),
))
    )
    '''Arguments:

    * `request` (`RetrieveComparisonWidgetDataRequestInput!`)None
    '''

    get_data_explorer_comparison_dashboards = sgqlc.types.Field(DataExplorerComparisonDashboardTypeConnection, graphql_name='getDataExplorerComparisonDashboards', args=sgqlc.types.ArgDict((
        ('uuids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='uuids', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `uuids` (`[UUID]`)None
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_comparable_dashboards = sgqlc.types.Field(sgqlc.types.list_of(ComparableDashboardType), graphql_name='getComparableDashboards', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Arguments:

    * `uuid` (`UUID!`)None
    '''

    retrieve_table_data = sgqlc.types.Field(DataResponseType, graphql_name='retrieveTableData', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(RetrieveTableDataRequestInput), graphql_name='request', default=None)),
))
    )
    '''Arguments:

    * `request` (`RetrieveTableDataRequestInput!`)None
    '''

    retrieve_widget_data = sgqlc.types.Field(DataResponseType, graphql_name='retrieveWidgetData', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(RetrieveWidgetDataRequestInput), graphql_name='request', default=None)),
))
    )
    '''Arguments:

    * `request` (`RetrieveWidgetDataRequestInput!`)None
    '''

    get_data_explorer_table_metadata = sgqlc.types.Field('TableMetadataType', graphql_name='getDataExplorerTableMetadata', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Arguments:

    * `mcon` (`String!`)None
    '''

    get_data_explorer_dashboards = sgqlc.types.Field(DataExplorerDashboardTypeConnection, graphql_name='getDataExplorerDashboards', args=sgqlc.types.ArgDict((
        ('uuids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='uuids', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get data explorer dashboards

    Arguments:

    * `uuids` (`[UUID]`): UUIDs to filter by
    * `mcon` (`String`): MCON to filter by
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_webex_integrations = sgqlc.types.Field(sgqlc.types.list_of('WebexIntegrationOutput'), graphql_name='getWebexIntegrations', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(UUID, graphql_name='integrationId', default=None)),
))
    )
    '''Get the configured Webex integrations

    Arguments:

    * `integration_id` (`UUID`): Filter by integration ID
    '''

    test_webex_credentials = sgqlc.types.Field('WebexTestCredentialsOutput', graphql_name='testWebexCredentials', args=sgqlc.types.ArgDict((
        ('bot_token', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='botToken', default=None)),
))
    )
    '''Test the Webex connection credentials

    Arguments:

    * `bot_token` (`String!`): The Webex bot token for basic
      authentication
    '''

    get_assets_usage = sgqlc.types.Field(AssetsUsageResults, graphql_name='getAssetsUsage', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('parent_mcon', sgqlc.types.Arg(String, graphql_name='parentMcon', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('display_name_contains', sgqlc.types.Arg(String, graphql_name='displayNameContains', default=None)),
        ('filter_options', sgqlc.types.Arg(AssetsUsageFilterOptions, graphql_name='filterOptions', default=None)),
))
    )
    '''Use this to get a list of assets. The response will only contain
    assets of one type. The asset hierarchy is warehouses > databases
    > schemas > tables. If mcon is given, the response will only
    contain this object. To get all warehouses, omit both mcon and
    parentMcon. This assumes the parent to be the account. To get all
    databases/projects under a warehouse, provide the mcon of the
    warehouse. To get all schemas/datasets under a database, provide
    the mcon of the database. To get all tables under a schema,
    provide the mcon of the schema.

    Arguments:

    * `mcon` (`String`): Filter by mcon, returns this single object.
      Include this or parent_mcon.If neither mcon nor parent_mcon is
      given, will return warehouses.
    * `parent_mcon` (`String`): Only include children of this object.
      Include this or mcon.If neither mcon nor parent_mcon is given,
      will return warehouses.
    * `offset` (`Int`): Starting node index for current page.
    * `limit` (`Int`): Max nodes to get for page.
    * `display_name_contains` (`String`): To search a substring of an
      asset's display name.
    * `filter_options` (`AssetsUsageFilterOptions`): To filter results
      by only ingested/not ingested/monitored/not monitored tables.
    '''

    get_monitored_table_rule_list = sgqlc.types.Field(sgqlc.types.list_of(MonitoredTableRuleObject), graphql_name='getMonitoredTableRuleList', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('project', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='project', default=None)),
        ('dataset', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='dataset', default=None)),
))
    )
    '''List of rules for deciding which tables are monitored for a given
    project & dataset scope

    Arguments:

    * `dw_id` (`UUID!`): Warehouse ID to filter the rules
    * `project` (`String!`): Project/database name to filter the rules
    * `dataset` (`String!`): Dataset/schema name to filter the rules
    '''

    get_streaming_systems = sgqlc.types.Field(sgqlc.types.list_of('StreamingSystemWithClusters'), graphql_name='getStreamingSystems', args=sgqlc.types.ArgDict((
        ('include_clusters', sgqlc.types.Arg(Boolean, graphql_name='includeClusters', default=None)),
))
    )
    '''Gets streaming systems under an account.

    Arguments:

    * `include_clusters` (`Boolean`)None
    '''

    get_tableau_asset_warning_by_id = sgqlc.types.Field(GetTableauAssetWarningByIdResponse, graphql_name='getTableauAssetWarningById', args=sgqlc.types.ArgDict((
        ('bi_container_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='biContainerId', default=None)),
        ('tableau_warning_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='tableauWarningId', default=None)),
))
    )
    '''Arguments:

    * `bi_container_id` (`UUID!`): UUID of the Tableau container for
      which this warning is being created.
    * `tableau_warning_id` (`String!`): The Tableau Data Quality
      Warning ID.
    '''

    get_etl_job = sgqlc.types.Field('ETLJobUnionType', graphql_name='getEtlJob', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Get information about a job

    Arguments:

    * `mcon` (`String!`): Mcon for job to get details for
    '''

    get_etl_task = sgqlc.types.Field('ETLTaskUnionType', graphql_name='getEtlTask', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Get information about a task

    Arguments:

    * `mcon` (`String!`): Mcon for task to get details for
    '''

    get_etl_jobs = sgqlc.types.Field(ETLJobsType, graphql_name='getEtlJobs', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name='first', default=None)),
        ('offset', sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name='offset', default=None)),
        ('resource_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='resourceUuid', default=None)),
))
    )
    '''Get ETL Jobs for the given ETL container

    Arguments:

    * `first` (`Int!`): Page size
    * `offset` (`Int!`): Page offset
    * `resource_uuid` (`UUID!`): Filter by ETL container
    '''

    get_data_product = sgqlc.types.Field('DataProduct', graphql_name='getDataProduct', args=sgqlc.types.ArgDict((
        ('data_product_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dataProductId', default=None)),
        ('upstream_levels', sgqlc.types.Arg(Int, graphql_name='upstreamLevels', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
))
    )
    '''Get a data product

    Arguments:

    * `data_product_id` (`UUID!`): Data product id
    * `upstream_levels` (`Int`): Number of upstream levels used to
      calculate upstream dependencies
    * `domain_id` (`UUID`): Filter assets by domain UUID
    '''

    get_data_products = sgqlc.types.Field(sgqlc.types.list_of('DataProduct'), graphql_name='getDataProducts', args=sgqlc.types.ArgDict((
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
))
    )
    '''Get a list of data products

    Arguments:

    * `domain_id` (`UUID`): Filter assets by domain UUID
    '''

    get_data_product_metrics = sgqlc.types.Field(sgqlc.types.list_of(DataProductMetricData), graphql_name='getDataProductMetrics', args=sgqlc.types.ArgDict((
        ('data_product_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dataProductId', default=None)),
        ('metrics', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(DataProductMetric)), graphql_name='metrics', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('timezone', sgqlc.types.Arg(String, graphql_name='timezone', default=None)),
        ('include_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='includeFeedback', default=None)),
        ('exclude_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeFeedback', default=None)),
        ('include_normalized', sgqlc.types.Arg(Boolean, graphql_name='includeNormalized', default=None)),
        ('severities', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='severities', default=None)),
        ('incident_categories', sgqlc.types.Arg(sgqlc.types.list_of(IncidentCategory), graphql_name='incidentCategories', default=None)),
        ('upstream_levels', sgqlc.types.Arg(Int, graphql_name='upstreamLevels', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
))
    )
    '''Get one or more data product metric values

    Arguments:

    * `data_product_id` (`UUID!`): Data product id
    * `metrics` (`[DataProductMetric]!`): Metrics to calculate
    * `start_time` (`DateTime!`): Filter incidents newer than this
    * `end_time` (`DateTime`): Filter incidents older than this
    * `timezone` (`String`): Timezone to apply when grouping by date
    * `include_feedback` (`[String]`): Filter incidents by user
      feedback
    * `exclude_feedback` (`[String]`): Exclude incidents by user
      feedback
    * `include_normalized` (`Boolean`): If false, filter out
      normalized incidents.
    * `severities` (`[String]`): Filter for specific severities
    * `incident_categories` (`[IncidentCategory]`): Include only
      selected incident categories. Or all categories if not
      specified.
    * `upstream_levels` (`Int`): Number of upstream levels used to
      calculate upstream dependencies
    * `domain_id` (`UUID`): Filter assets by domain UUID
    '''

    parse_query = sgqlc.types.Field('SqlParserResult', graphql_name='parseQuery', args=sgqlc.types.ArgDict((
        ('query', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='query', default=None)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('database', sgqlc.types.Arg(String, graphql_name='database', default=None)),
        ('schema', sgqlc.types.Arg(String, graphql_name='schema', default=None)),
))
    )
    '''Arguments:

    * `query` (`String!`): SQL query to parse
    * `resource_id` (`UUID`): Id of resource/warehouse to use for
      table resolution
    * `database` (`String`): Name of database to use for table
      resolution
    * `schema` (`String`): Name of schema to use for table resolution
    '''

    ping_data_collector = sgqlc.types.Field(DcPingResponse, graphql_name='pingDataCollector', args=sgqlc.types.ArgDict((
        ('dc_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dcId', default=None)),
        ('trace_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='traceId', default=None)),
))
    )
    '''Sends a ping request to a data collector to verify it is
    operational.

    Arguments:

    * `dc_id` (`UUID!`): The UUID identifying the data collector to
      ping.
    * `trace_id` (`UUID!`): A unique identifier for correlating the
      data collector ping.
    '''

    get_github_integrations = sgqlc.types.Field(GithubAppInfo, graphql_name='getGithubIntegrations')
    '''Github integration info'''

    get_github_pull_requests = sgqlc.types.Field(GithubPullRequestsList, graphql_name='getGithubPullRequests', args=sgqlc.types.ArgDict((
        ('incident_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentUuid', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('include_zero_score', sgqlc.types.Arg(Boolean, graphql_name='includeZeroScore', default=False)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=10)),
))
    )
    '''Get the list of pull requests related to a given incident

    Arguments:

    * `incident_uuid` (`UUID!`): Incident UUID to get PRs for
    * `mcon` (`String`): mcon of the table to get the PRs for
    * `include_zero_score` (`Boolean`): Include PRs with 0 relevance
      score (default: `false`)
    * `limit` (`Int`): Limit the number of PRs returned (default:
      `10`)
    '''

    get_github_pull_requests_for_table = sgqlc.types.Field(GithubPullRequestsList, graphql_name='getGithubPullRequestsForTable', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('include_zero_score', sgqlc.types.Arg(Boolean, graphql_name='includeZeroScore', default=False)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=10)),
))
    )
    '''Get the list of pull requests related to a given incident.
    DEPRECATED: Use getGithubPullRequestsForTableV2

    Arguments:

    * `mcon` (`String!`): mcon of the table to get the PRs for
    * `include_zero_score` (`Boolean`): Include PRs with 0 relevance
      score (default: `false`)
    * `limit` (`Int`): Limit the number of PRs returned (default:
      `10`)
    '''

    get_github_pull_requests_for_table_v2 = sgqlc.types.Field(GithubPullRequestConnection, graphql_name='getGithubPullRequestsForTableV2', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get the list of pull requests related to a given incident

    Arguments:

    * `mcon` (`String!`): mcon of the table to get the PRs for
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_size_collection_configuration = sgqlc.types.Field('SizeCollectionConfiguration', graphql_name='getSizeCollectionConfiguration', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
))
    )
    '''Size Collection configuration for an assets with size collection

    Arguments:

    * `mcon` (`String`): MC unique identifier of the object
    '''

    get_size_collection_query = sgqlc.types.Field('SizeCollectionQuery', graphql_name='getSizeCollectionQuery', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('where_condition', sgqlc.types.Arg(String, graphql_name='whereCondition', default=None)),
))
    )
    '''Retrieve query executed by size collection for the given asset

    Arguments:

    * `mcon` (`String`): MC unique identifier of the object
    * `where_condition` (`String`): Where condition to include with
      collection query
    '''

    get_servicenow_integrations = sgqlc.types.Field(sgqlc.types.list_of('ServiceNowIntegrationOutput'), graphql_name='getServicenowIntegrations', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(UUID, graphql_name='integrationId', default=None)),
))
    )
    '''Get the configured ServiceNow integrations

    Arguments:

    * `integration_id` (`UUID`): Filter by integration ID
    '''

    test_servicenow_credentials = sgqlc.types.Field('ServiceNowTestCredentialsOutput', graphql_name='testServicenowCredentials', args=sgqlc.types.ArgDict((
        ('instance_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='instanceName', default=None)),
        ('username', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='username', default=None)),
        ('password', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='password', default=None)),
))
    )
    '''Test the ServiceNow connection credentials

    Arguments:

    * `instance_name` (`String!`): The instance name of the ServiceNow
      site
    * `username` (`String!`): The ServiceNow username for basic
      authentication
    * `password` (`String!`): The user's password for basic
      authentication
    '''

    get_jira_integrations = sgqlc.types.Field(sgqlc.types.list_of(JiraIntegrationOutput), graphql_name='getJiraIntegrations', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(UUID, graphql_name='integrationId', default=None)),
))
    )
    '''Get the configured Jira integrations

    Arguments:

    * `integration_id` (`UUID`): Filter by integration ID
    '''

    get_jira_statuses = sgqlc.types.Field(sgqlc.types.list_of(JiraStatusOutput), graphql_name='getJiraStatuses', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(UUID, graphql_name='integrationId', default=None)),
        ('server_url', sgqlc.types.Arg(String, graphql_name='serverUrl', default=None)),
        ('username', sgqlc.types.Arg(String, graphql_name='username', default=None)),
        ('api_token', sgqlc.types.Arg(String, graphql_name='apiToken', default=None)),
))
    )
    '''Get Jira statuses for the given integration or set of credentials

    Arguments:

    * `integration_id` (`UUID`): Jira integration id
    * `server_url` (`String`): The domain name for your Jira site
    * `username` (`String`): The Jira username for basic
      authentication
    * `api_token` (`String`): The personal API token for basic
      authentication
    '''

    get_jira_projects = sgqlc.types.Field(sgqlc.types.list_of(JiraProjectOutput), graphql_name='getJiraProjects', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
))
    )
    '''Get Jira projects for the given integration

    Arguments:

    * `integration_id` (`UUID!`): Jira integration id
    '''

    get_jira_issue_types = sgqlc.types.Field(sgqlc.types.list_of(JiraIssueTypeOutput), graphql_name='getJiraIssueTypes', args=sgqlc.types.ArgDict((
        ('integration_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='integrationId', default=None)),
        ('project', sgqlc.types.Arg(Int, graphql_name='project', default=None)),
))
    )
    '''Get Jira issue types for the integration

    Arguments:

    * `integration_id` (`UUID!`): Jira integration ID
    * `project` (`Int`): Filter by Jira project ID
    '''

    test_jira_credentials = sgqlc.types.Field(JiraTestCredentialsOutput, graphql_name='testJiraCredentials', args=sgqlc.types.ArgDict((
        ('server_url', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='serverUrl', default=None)),
        ('username', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='username', default=None)),
        ('api_token', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='apiToken', default=None)),
))
    )
    '''Test the Jira connection credentials

    Arguments:

    * `server_url` (`String!`): The domain name for your Jira site
    * `username` (`String!`): The Jira username for basic
      authentication
    * `api_token` (`String!`): The personal API token for basic
      authentication
    '''

    get_query_perf_rule_execution_history_logs = sgqlc.types.Field(sgqlc.types.list_of(JobExecutionHistoryLog), graphql_name='getQueryPerfRuleExecutionHistoryLogs', args=sgqlc.types.ArgDict((
        ('rule_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='ruleUuid', default=None)),
        ('history_days', sgqlc.types.Arg(Int, graphql_name='historyDays', default=7)),
))
    )
    '''Arguments:

    * `rule_uuid` (`UUID!`): UUID of the Query Performance
      Monitor/Rule
    * `history_days` (`Int`): Number of lookback days (default: `7`)
    '''

    simulate_query_perf_monitor_evaluation = sgqlc.types.Field(QPMonitorSimulationType, graphql_name='simulateQueryPerfMonitorEvaluation', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(SimulateMonitorEvaluationRequestType), graphql_name='request', default=None)),
        ('config', sgqlc.types.Arg(sgqlc.types.non_null(QPMonitorConfigInputType), graphql_name='config', default=None)),
))
    )
    '''Arguments:

    * `request` (`SimulateMonitorEvaluationRequestType!`)None
    * `config` (`QPMonitorConfigInputType!`): Monitor configuration
    '''

    get_query_perf_monitor_explanation_for_event = sgqlc.types.Field(QPMonitorExplanationType, graphql_name='getQueryPerfMonitorExplanationForEvent', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(GetExplanationForEventRequestType), graphql_name='request', default=None)),
))
    )
    '''Arguments:

    * `request` (`GetExplanationForEventRequestType!`)None
    '''

    get_query_perf_monitor_explanation = sgqlc.types.Field(QPMonitorExplanationType, graphql_name='getQueryPerfMonitorExplanation', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(GetExplanationRequestType), graphql_name='request', default=None)),
        ('config', sgqlc.types.Arg(sgqlc.types.non_null(QPMonitorConfigInputType), graphql_name='config', default=None)),
))
    )
    '''Arguments:

    * `request` (`GetExplanationRequestType!`)None
    * `config` (`QPMonitorConfigInputType!`): QP monitor config
    '''

    get_indexed_field_specs = sgqlc.types.Field(sgqlc.types.list_of(IndexedFieldSpecType), graphql_name='getIndexedFieldSpecs', args=sgqlc.types.ArgDict((
        ('included_facets_types', sgqlc.types.Arg(sgqlc.types.list_of(DashboardType), graphql_name='includedFacetsTypes', default=None)),
))
    )
    '''Arguments:

    * `included_facets_types` (`[DashboardType]`): Facet types to
      include in the results. Can be READ, WRITE or both. By default
      it will use WRITE
    '''

    get_query_logs = sgqlc.types.Field('QueryLogsResponseType', graphql_name='getQueryLogs', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(QueryLogsRequestInput), graphql_name='request', default=None)),
))
    )
    '''Arguments:

    * `request` (`QueryLogsRequestInput!`)None
    '''

    get_query_logs_facets_v2 = sgqlc.types.Field(sgqlc.types.list_of('QueryLogsFacetResponseType'), graphql_name='getQueryLogsFacetsV2', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(QueryLogsFacetRequestTypeV2), graphql_name='request', default=None)),
))
    )
    '''Arguments:

    * `request` (`QueryLogsFacetRequestTypeV2!`)None
    '''

    get_query_logs_facets = sgqlc.types.Field('QueryLogsFacetResponseType', graphql_name='getQueryLogsFacets', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(QueryLogsFacetRequestType), graphql_name='request', default=None)),
))
    )
    '''Arguments:

    * `request` (`QueryLogsFacetRequestType!`)None
    '''

    get_query_runtime_percentile_timeseries = sgqlc.types.Field('QueryRuntimePercentileTimeSeriesResponseType', graphql_name='getQueryRuntimePercentileTimeseries', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(QueryRuntimePercentileTimeSeriesRequestType), graphql_name='request', default=None)),
))
    )
    '''Returns data for the Latency Distribution Line Graph for read
    queries

    Arguments:

    * `request` (`QueryRuntimePercentileTimeSeriesRequestType!`)None
    '''

    get_query_performance_data = sgqlc.types.Field(sgqlc.types.list_of(AggregatedMetricDataType), graphql_name='getQueryPerformanceData', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(QueryPerformanceDataRequestType), graphql_name='request', default=None)),
))
    )
    '''Get aggregated query performance data

    Arguments:

    * `request` (`QueryPerformanceDataRequestType!`)None
    '''

    get_top_query_groups = sgqlc.types.Field('TopQueryGroupsResponseType', graphql_name='getTopQueryGroups', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(TopQueryGroupsRequestType), graphql_name='request', default=None)),
))
    )
    '''Arguments:

    * `request` (`TopQueryGroupsRequestType!`)None
    '''

    get_aggregated_queries = sgqlc.types.Field(AggregatedQueryResults, graphql_name='getAggregatedQueries', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='endTime', default=None)),
        ('query_type', sgqlc.types.Arg(sgqlc.types.non_null(QueryType), graphql_name='queryType', default=None)),
        ('limit', sgqlc.types.Arg(sgqlc.types.non_null(Int), graphql_name='limit', default=None)),
        ('end_cursor', sgqlc.types.Arg(String, graphql_name='endCursor', default=None)),
        ('category', sgqlc.types.Arg(QueryCategory, graphql_name='category', default=None)),
        ('user', sgqlc.types.Arg(String, graphql_name='user', default=None)),
        ('query_characters', sgqlc.types.Arg(Int, graphql_name='queryCharacters', default=50)),
))
    )
    '''Arguments:

    * `mcon` (`String!`): MCON for the table
    * `start_time` (`DateTime!`): Filter for queries on or after this
      date
    * `end_time` (`DateTime!`): Filter for queries on or before this
      date
    * `query_type` (`QueryType!`): Filter for reads or writes to the
      table
    * `limit` (`Int!`): Number of aggregated queries to return. Up to
      a maximum of 1000
    * `end_cursor` (`String`): Cursor used to get results from the
      next page
    * `category` (`QueryCategory`): Filter queries by category
    * `user` (`String`): Filter queries by user
    * `query_characters` (`Int`): Number of characters to return for
      the sample query (default: `50`)
    '''

    get_query_rcas = sgqlc.types.Field(sgqlc.types.list_of('QueryRca'), graphql_name='getQueryRcas', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
))
    )
    '''Get query RCAs for a given incident.

    Arguments:

    * `incident_id` (`UUID!`): Incident identifier
    '''

    get_query_dimensions = sgqlc.types.Field('QueryDimensions', graphql_name='getQueryDimensions', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='endTime', default=None)),
        ('query_type', sgqlc.types.Arg(sgqlc.types.non_null(QueryType), graphql_name='queryType', default=None)),
))
    )
    '''Arguments:

    * `mcon` (`String!`): Mcon for table to get query dimensions for
    * `start_time` (`DateTime!`): Filter for queries on or after this
      date
    * `end_time` (`DateTime!`): Filter for queries on or before this
      date
    * `query_type` (`QueryType!`): Filter for reads or writes to the
      table
    '''

    get_query_text = sgqlc.types.Field(String, graphql_name='getQueryText', args=sgqlc.types.ArgDict((
        ('key', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='key', default=None)),
))
    )
    '''Arguments:

    * `key` (`String!`): Query text key
    '''

    get_notification_audiences = sgqlc.types.Field(sgqlc.types.list_of(NotificationAudience), graphql_name='getNotificationAudiences', args=sgqlc.types.ArgDict((
        ('audience_id', sgqlc.types.Arg(UUID, graphql_name='audienceId', default=None)),
))
    )
    '''Get notification audiences

    Arguments:

    * `audience_id` (`UUID`): Audience associated with the recipient
    '''

    get_notification_settings = sgqlc.types.Field(sgqlc.types.list_of(AccountNotificationSetting), graphql_name='getNotificationSettings', args=sgqlc.types.ArgDict((
        ('monitor_labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='monitorLabels', default=None)),
))
    )
    '''Get notification settings

    Arguments:

    * `monitor_labels` (`[String]`): Filter by notifications that
      handle these monitor labels
    '''

    get_collection_dataset_list = sgqlc.types.Field(CollectionDataSetConnection, graphql_name='getCollectionDatasetList', args=sgqlc.types.ArgDict((
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get datasets in the account, including blocked datasets and
    dataset unblocked recently

    Arguments:

    * `resource_id` (`UUID`): Filter by resource id
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_collection_block_list = sgqlc.types.Field(CollectionBlockConnection, graphql_name='getCollectionBlockList', args=sgqlc.types.ArgDict((
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('project', sgqlc.types.Arg(String, graphql_name='project', default=None)),
        ('parent_scope', sgqlc.types.Arg(CollectionBlockListParentScopeInput, graphql_name='parentScope', default=None)),
        ('target_object_types', sgqlc.types.Arg(sgqlc.types.list_of(CollectionPreferenceTargetObjectType), graphql_name='targetObjectTypes', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get entities blocked from metadata collection in my account.

    Arguments:

    * `resource_id` (`UUID`): Filter by resource id
    * `project` (`String`): DEPRECATED: use parent_scope instead
    * `parent_scope` (`CollectionBlockListParentScopeInput`): The
      parent scope of target objects. If not provided then all
      collection blocks for the account will be returned.
    * `target_object_types`
      (`[CollectionPreferenceTargetObjectType]`): Only return
      collection blocks targeting these object types.
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_fivetran_connectors = sgqlc.types.Field(FivetranConnectorConnection, graphql_name='getFivetranConnectors', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('table_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tableMcons', default=None)),
        ('services', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='services', default=None)),
        ('statuses', sgqlc.types.Arg(sgqlc.types.list_of(FivetranConnectorStatuses), graphql_name='statuses', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get fivetran connectors

    Arguments:

    * `mcons` (`[String]`): Filter by a list of MCONs
    * `table_mcons` (`[String]`): Filter by a list of table MCONs
    * `services` (`[String]`): Filter by a list of fivetran connector
      sources
    * `statuses` (`[FivetranConnectorStatuses]`): Filter by a list of
      fivetran connector statuses
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_pii_filtering_preferences = sgqlc.types.Field(PiiFilteringPreferencesOutput, graphql_name='getPiiFilteringPreferences')
    '''The PII filter settings for the user's account.'''

    get_pii_filters = sgqlc.types.Field(sgqlc.types.list_of(PiiFilterOutput), graphql_name='getPiiFilters')
    '''The possible PII filters for the user's account.'''

    get_pii_filter_metrics = sgqlc.types.Field(sgqlc.types.list_of(PiiFilterMetricOutput), graphql_name='getPiiFilterMetrics', args=sgqlc.types.ArgDict((
        ('resource_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='resourceIds', default=None)),
        ('filter_names', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='filterNames', default=None)),
        ('job_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='jobTypes', default=None)),
        ('earliest_job_completion_time', sgqlc.types.Arg(DateTime, graphql_name='earliestJobCompletionTime', default=None)),
        ('latest_job_completion_time', sgqlc.types.Arg(DateTime, graphql_name='latestJobCompletionTime', default=None)),
        ('number_of_jobs', sgqlc.types.Arg(Int, graphql_name='numberOfJobs', default=100)),
))
    )
    '''PII filter metrics per job run.

    Arguments:

    * `resource_ids` (`[UUID]`): UUIDs of which resources to look for.
    * `filter_names` (`[String]`): Names of specific PII filters to
      look for.
    * `job_types` (`[String]`): Specify job types to look for.
    * `earliest_job_completion_time` (`DateTime`): How far back to
      look for the job completion time.
    * `latest_job_completion_time` (`DateTime`): How recent to look
      for the job completion time.
    * `number_of_jobs` (`Int`): How many recent job runs to use in the
      metrics aggregation (maximum is 100). (default: `100`)
    '''

    get_dbt_connections = sgqlc.types.Field(sgqlc.types.list_of(Connection), graphql_name='getDbtConnections')
    '''Get dbt connections'''

    get_dbt_connection_details = sgqlc.types.Field(DbtConnectionDetails, graphql_name='getDbtConnectionDetails', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionId', default=None)),
))
    )
    '''Get dbt connection details

    Arguments:

    * `connection_id` (`String!`): dbt connection id
    '''

    get_dbt_projects = sgqlc.types.Field(DbtProjectConnection, graphql_name='getDbtProjects', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(String, graphql_name='uuid', default=None)),
        ('project_name', sgqlc.types.Arg(String, graphql_name='projectName', default=None)),
        ('connection_id', sgqlc.types.Arg(String, graphql_name='connectionId', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get dbt projects

    Arguments:

    * `uuid` (`String`): dbt project id
    * `project_name` (`String`): dbt project name
    * `connection_id` (`String`): dbt connection id
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_dbt_jobs = sgqlc.types.Field(DbtJobConnection, graphql_name='getDbtJobs', args=sgqlc.types.ArgDict((
        ('project_id', sgqlc.types.Arg(UUID, graphql_name='projectId', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get dbt jobs

    Arguments:

    * `project_id` (`UUID`): dbt project id
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_dbt_nodes = sgqlc.types.Field(DbtNodeConnection, graphql_name='getDbtNodes', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(String, graphql_name='uuid', default=None)),
        ('dbt_project_uuid', sgqlc.types.Arg(String, graphql_name='dbtProjectUuid', default=None)),
        ('table_mcon', sgqlc.types.Arg(String, graphql_name='tableMcon', default=None)),
        ('table_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tableMcons', default=None)),
        ('dbt_unique_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='dbtUniqueIds', default=None)),
        ('resource_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='resourceTypes', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get dbt nodes

    Arguments:

    * `uuid` (`String`): Filter by UUID of dbt node
    * `dbt_project_uuid` (`String`): Filter by UUID of dbt project
    * `table_mcon` (`String`): Filter by table MCON (deprecated, use
      tableMcons instead)
    * `table_mcons` (`[String]`): Filter by list of table MCON
    * `dbt_unique_ids` (`[String]`): Filter by list of dbt node
      unique_id
    * `resource_types` (`[String]`): Filter by dbt node resource type
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_dbt_runs = sgqlc.types.Field(DbtRunConnection, graphql_name='getDbtRuns', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(String, graphql_name='uuid', default=None)),
        ('dbt_project_uuid', sgqlc.types.Arg(String, graphql_name='dbtProjectUuid', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get dbt runs

    Arguments:

    * `uuid` (`String`): Filter by UUID of dbt node
    * `dbt_project_uuid` (`String`): Filter by UUID of dbt project
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_dbt_models = sgqlc.types.Field(DbtModelsConnection, graphql_name='getDbtModels', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('name_filter', sgqlc.types.Arg(String, graphql_name='nameFilter', default=None)),
        ('table_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tableMcons', default=None)),
))
    )
    '''Get dbt models

    Arguments:

    * `first` (`Int`): When paging forward: the number of items to
      return (page size)
    * `after` (`String`): When paging forward: the cursor of the last
      item on the previous page of results
    * `last` (`Int`): When paging backward: the number of items to
      return (page size)
    * `before` (`String`): When paging backward: the cursor of the
      first item on the next page of results
    * `name_filter` (`String`): Filter the models for which the name
      start with this string
    * `table_mcons` (`[String]`): Filter the models for which the mcon
      is in this list
    '''

    get_dbt_model_results = sgqlc.types.Field(DbtModelResultsConnection, graphql_name='getDbtModelResults', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('run_start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runStartTime', default=None)),
        ('run_end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runEndTime', default=None)),
        ('status', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='status', default=None)),
        ('command', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='command', default=None)),
        ('model', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='model', default=None)),
        ('mcon', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcon', default=None)),
        ('job_execution_id', sgqlc.types.Arg(UUID, graphql_name='jobExecutionId', default=None)),
        ('sort_order', sgqlc.types.Arg(String, graphql_name='sortOrder', default='desc')),
))
    )
    '''Get dbt model results

    Arguments:

    * `first` (`Int`): When paging forward: the number of items to
      return (page size)
    * `after` (`String`): When paging forward: the cursor of the last
      item on the previous page of results
    * `last` (`Int`): When paging backward: the number of items to
      return (page size)
    * `before` (`String`): When paging backward: the cursor of the
      first item on the next page of results
    * `run_start_time` (`DateTime!`): Beginning of time window to
      filter run start times
    * `run_end_time` (`DateTime!`): End of time window to filter run
      start times
    * `status` (`[String]`): Status(es) to filter run results
    * `command` (`[String]`): dbt command(s) to filter run results
    * `model` (`[String]`): dbt model ids to filter run results
    * `mcon` (`[String]`): Associated table MCONs to filter run
      results
    * `job_execution_id` (`UUID`): Filter by dbt job execution uuid
    * `sort_order` (`String`): Specify asc to return results by
      ascending completion time (default: `"desc"`)
    '''

    get_dbt_model_results_count = sgqlc.types.Field(Int, graphql_name='getDbtModelResultsCount', args=sgqlc.types.ArgDict((
        ('run_start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runStartTime', default=None)),
        ('run_end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runEndTime', default=None)),
        ('status', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='status', default=None)),
))
    )
    '''Get the count of dbt model results

    Arguments:

    * `run_start_time` (`DateTime!`): Beginning of time window to
      filter run start times
    * `run_end_time` (`DateTime!`): End of time window to filter run
      start times
    * `status` (`[String]`): Status(es) to filter run results
    '''

    get_dbt_run_steps = sgqlc.types.Field(sgqlc.types.list_of('DbtRunStep'), graphql_name='getDbtRunSteps', args=sgqlc.types.ArgDict((
        ('node_unique_id', sgqlc.types.Arg(String, graphql_name='nodeUniqueId', default=None)),
        ('table_mcon', sgqlc.types.Arg(String, graphql_name='tableMcon', default=None)),
        ('completed_at_start_time', sgqlc.types.Arg(DateTime, graphql_name='completedAtStartTime', default=None)),
        ('completed_at_end_time', sgqlc.types.Arg(DateTime, graphql_name='completedAtEndTime', default=None)),
        ('status', sgqlc.types.Arg(String, graphql_name='status', default=None)),
        ('dbt_run_id', sgqlc.types.Arg(String, graphql_name='dbtRunId', default=None)),
        ('sort_field', sgqlc.types.Arg(String, graphql_name='sortField', default=None)),
        ('sort_direction', sgqlc.types.Arg(String, graphql_name='sortDirection', default=None)),
))
    )
    '''Get dbt run steps

    Arguments:

    * `node_unique_id` (`String`): dbt test id
    * `table_mcon` (`String`): MCON of the associated table
    * `completed_at_start_time` (`DateTime`): Filter the results by
      those that completed on or after this time
    * `completed_at_end_time` (`DateTime`): Filter the results by
      those that completed before this time
    * `status` (`String`): Filter results by completion status
    * `dbt_run_id` (`String`): Filter results by dbt run id
    * `sort_field` (`String`): Sort by the fields: created_time,
      updated_time, started_at, completed_at. The default value is
      completed_at
    * `sort_direction` (`String`): Sort direction: asc or desc. The
      default value is asc
    '''

    get_dbt_test_results_count = sgqlc.types.Field(Int, graphql_name='getDbtTestResultsCount', args=sgqlc.types.ArgDict((
        ('run_start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runStartTime', default=None)),
        ('run_end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runEndTime', default=None)),
        ('status', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='status', default=None)),
))
    )
    '''Get the count of dbt test results

    Arguments:

    * `run_start_time` (`DateTime!`): Beginning of time window to
      filter run start times
    * `run_end_time` (`DateTime!`): End of time window to filter run
      start times
    * `status` (`[String]`): Status(es) to filter run results
    '''

    get_dbt_test_results = sgqlc.types.Field(DbtTestResultsConnection, graphql_name='getDbtTestResults', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('run_start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runStartTime', default=None)),
        ('run_end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runEndTime', default=None)),
        ('status', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='status', default=None)),
        ('model', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='model', default=None)),
        ('mcon', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcon', default=None)),
))
    )
    '''Get dbt test results

    Arguments:

    * `first` (`Int`): When paging forward: the number of items to
      return (page size)
    * `after` (`String`): When paging forward: the cursor of the last
      item on the previous page of results
    * `last` (`Int`): When paging backward: the number of items to
      return (page size)
    * `before` (`String`): When paging backward: the cursor of the
      first item on the next page of results
    * `run_start_time` (`DateTime!`): Beginning of time window to
      match run start times
    * `run_end_time` (`DateTime!`): End of time window to match run
      start times
    * `status` (`[String]`): Status(es) to match run results
    * `model` (`[String]`): dbt model ids to filter run results
    * `mcon` (`[String]`): Associated table MCONs to filter run
      results
    '''

    get_dbt_upload_url = sgqlc.types.Field(String, graphql_name='getDbtUploadUrl', args=sgqlc.types.ArgDict((
        ('project_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='projectName', default=None)),
        ('invocation_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='invocationId', default=None)),
        ('file_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='fileName', default=None)),
))
    )
    '''Get the Dbt artifacts presigned upload url

    Arguments:

    * `project_name` (`String!`): dbt project name
    * `invocation_id` (`String!`): dbt invocation id
    * `file_name` (`String!`): name of the file for the upload
    '''

    get_dbt_last_run_results = sgqlc.types.Field(DbtModelResultsConnection, graphql_name='getDbtLastRunResults', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('run_start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runStartTime', default=None)),
        ('run_end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='runEndTime', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='mcons', default=None)),
        ('status', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='status', default=None)),
        ('model', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='model', default=None)),
))
    )
    '''Get dbt model results for latest relevant run

    Arguments:

    * `first` (`Int`): When paging forward: the number of items to
      return (page size)
    * `after` (`String`): When paging forward: the cursor of the last
      item on the previous page of results
    * `last` (`Int`): When paging backward: the number of items to
      return (page size)
    * `before` (`String`): When paging backward: the cursor of the
      first item on the next page of results
    * `run_start_time` (`DateTime!`): Beginning of time window to
      filter run start times
    * `run_end_time` (`DateTime!`): End of time window to filter run
      start times
    * `mcons` (`[String]!`): Associated table MCONs to filter run
      results
    * `status` (`[String]!`): Status(es) to filter run results
    * `model` (`[String]`): dbt model ids to filter run results
    '''

    get_dbt_job_executions = sgqlc.types.Field(DbtJobExecutionsConnection, graphql_name='getDbtJobExecutions', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('job_uuid', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='jobUuid', default=None)),
        ('job_start_time', sgqlc.types.Arg(DateTime, graphql_name='jobStartTime', default=None)),
        ('job_end_time', sgqlc.types.Arg(DateTime, graphql_name='jobEndTime', default=None)),
        ('job_execution_uuid', sgqlc.types.Arg(UUID, graphql_name='jobExecutionUuid', default=None)),
))
    )
    '''Get dbt job executions for a given job uuid

    Arguments:

    * `first` (`Int`): When paging forward: the number of items to
      return (page size)
    * `after` (`String`): When paging forward: the cursor of the last
      item on the previous page of results
    * `last` (`Int`): When paging backward: the number of items to
      return (page size)
    * `before` (`String`): When paging backward: the cursor of the
      first item on the next page of results
    * `job_uuid` (`String!`): dbt job uuid
    * `job_start_time` (`DateTime`): Beginning of time window to
      filter job start times
    * `job_end_time` (`DateTime`): End of time window to filter job
      start times
    * `job_execution_uuid` (`UUID`): UUID of job execution
    '''

    get_exec_dashboard_metrics = sgqlc.types.Field(sgqlc.types.list_of(ExecDashboardMetric), graphql_name='getExecDashboardMetrics', args=sgqlc.types.ArgDict((
        ('metrics', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(ExecDashboardMetrics)), graphql_name='metrics', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('period_count', sgqlc.types.Arg(Int, graphql_name='periodCount', default=None)),
        ('period_unit', sgqlc.types.Arg(PeriodGrouping, graphql_name='periodUnit', default=None)),
        ('period_grouping', sgqlc.types.Arg(PeriodGrouping, graphql_name='periodGrouping', default=None)),
        ('period_total', sgqlc.types.Arg(Boolean, graphql_name='periodTotal', default=None)),
        ('period_include_current', sgqlc.types.Arg(Boolean, graphql_name='periodIncludeCurrent', default=None)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('key_assets_only', sgqlc.types.Arg(Boolean, graphql_name='keyAssetsOnly', default=None)),
        ('tags', sgqlc.types.Arg(sgqlc.types.list_of(TagKeyValuePairInput), graphql_name='tags', default=None)),
        ('incident_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='incidentTypes', default=None)),
        ('include_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='includeFeedback', default=None)),
        ('exclude_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeFeedback', default=None)),
))
    )
    '''Get one or more exec dashboard metrics.

    Arguments:

    * `metrics` (`[ExecDashboardMetrics]!`)None
    * `start_time` (`DateTime`): Start time to get time-bound values
      for.
    * `end_time` (`DateTime`): End time to get time-bound values for.
    * `period_count` (`Int`): Number of periods to get time-bound
      values for.
    * `period_unit` (`PeriodGrouping`): Time unit to use with the
      period_count, if not defined use period_grouping.
    * `period_grouping` (`PeriodGrouping`): Time buckets to group
      time-bound metrics by.
    * `period_total` (`Boolean`): Indicates if must return a single
      value with the total.
    * `period_include_current` (`Boolean`): Indicates if must include
      until current days (otherwise will include only full
      weeks/months).
    * `resource_id` (`UUID`): Resource id to filter.
    * `domain_id` (`UUID`): Domain id to filter.
    * `key_assets_only` (`Boolean`): Only include key assets.
    * `tags` (`[TagKeyValuePairInput]`): Tags to filter.
    * `incident_types` (`[String]`): Filter by type of incident (e.g.
      anomalies)
    * `include_feedback` (`[String]`): Filter by user feedback
    * `exclude_feedback` (`[String]`): Exclude by user feedback
    '''

    get_exec_dashboard_tables = sgqlc.types.Field(sgqlc.types.list_of(ExecDashboardTable), graphql_name='getExecDashboardTables', args=sgqlc.types.ArgDict((
        ('tables', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(ExecDashboardTables)), graphql_name='tables', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('period_count', sgqlc.types.Arg(Int, graphql_name='periodCount', default=None)),
        ('period_unit', sgqlc.types.Arg(PeriodGrouping, graphql_name='periodUnit', default=None)),
        ('period_grouping', sgqlc.types.Arg(PeriodGrouping, graphql_name='periodGrouping', default=None)),
        ('period_total', sgqlc.types.Arg(Boolean, graphql_name='periodTotal', default=None)),
        ('period_include_current', sgqlc.types.Arg(Boolean, graphql_name='periodIncludeCurrent', default=None)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('key_assets_only', sgqlc.types.Arg(Boolean, graphql_name='keyAssetsOnly', default=None)),
        ('tags', sgqlc.types.Arg(sgqlc.types.list_of(TagKeyValuePairInput), graphql_name='tags', default=None)),
        ('incident_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='incidentTypes', default=None)),
        ('include_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='includeFeedback', default=None)),
        ('exclude_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeFeedback', default=None)),
))
    )
    '''Get one or more exec dashboard metrics.

    Arguments:

    * `tables` (`[ExecDashboardTables]!`)None
    * `start_time` (`DateTime`): Start time to get time-bound values
      for.
    * `end_time` (`DateTime`): End time to get time-bound values for.
    * `period_count` (`Int`): Number of periods to get time-bound
      values for.
    * `period_unit` (`PeriodGrouping`): Time unit to use with the
      period_count, if not defined use period_grouping.
    * `period_grouping` (`PeriodGrouping`): Time buckets to group
      time-bound metrics by.
    * `period_total` (`Boolean`): Indicates if must return a single
      value with the total.
    * `period_include_current` (`Boolean`): Indicates if must include
      until current days (otherwise will include only full
      weeks/months).
    * `resource_id` (`UUID`): Resource id to filter.
    * `domain_id` (`UUID`): Domain id to filter.
    * `key_assets_only` (`Boolean`): Only include key assets.
    * `tags` (`[TagKeyValuePairInput]`): Tags to filter.
    * `incident_types` (`[String]`): Filter by type of incident (e.g.
      anomalies)
    * `include_feedback` (`[String]`): Filter by user feedback
    * `exclude_feedback` (`[String]`): Exclude by user feedback
    '''

    get_custom_users = sgqlc.types.Field(CustomUserConnection, graphql_name='getCustomUsers', args=sgqlc.types.ArgDict((
        ('custom_user_id', sgqlc.types.Arg(String, graphql_name='customUserId', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get all unified users

    Arguments:

    * `custom_user_id` (`String`)None
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_unified_users = sgqlc.types.Field('UnifiedUserConnection', graphql_name='getUnifiedUsers', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(String, graphql_name='uuid', default=None)),
        ('display_name_search', sgqlc.types.Arg(String, graphql_name='displayNameSearch', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get all unified users

    Arguments:

    * `uuid` (`String`)None
    * `display_name_search` (`String`)None
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_unified_user_assignments = sgqlc.types.Field('UnifiedUserAssignmentConnection', graphql_name='getUnifiedUserAssignments', args=sgqlc.types.ArgDict((
        ('unified_user_id', sgqlc.types.Arg(String, graphql_name='unifiedUserId', default=None)),
        ('object_mcon', sgqlc.types.Arg(String, graphql_name='objectMcon', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get all unified user assignments

    Arguments:

    * `unified_user_id` (`String`)None
    * `object_mcon` (`String`)None
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_monte_carlo_config_templates = sgqlc.types.Field(MonteCarloConfigTemplateConnection, graphql_name='getMonteCarloConfigTemplates', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('namespace', sgqlc.types.Arg(String, graphql_name='namespace', default=None)),
))
    )
    '''Get existing Monte Carlo config templates

    Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `namespace` (`String`)None
    '''

    export_monte_carlo_config_templates = sgqlc.types.Field(MonteCarloConfigTemplateExportResponse, graphql_name='exportMonteCarloConfigTemplates', args=sgqlc.types.ArgDict((
        ('monitor_uuids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='monitorUuids', default=None)),
        ('notification_uuids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='notificationUuids', default=None)),
        ('export_name', sgqlc.types.Arg(Boolean, graphql_name='exportName', default=False)),
))
    )
    '''Export Monte Carlo config templates from existing custom monitors

    Arguments:

    * `monitor_uuids` (`[UUID]`): List of custom monitor uuids to
      export
    * `notification_uuids` (`[UUID]`): List of notifications uuids to
      export
    * `export_name` (`Boolean`): Include the resource name in the
      export (default: `false`)
    '''

    get_monte_carlo_config_template_update_state = sgqlc.types.Field(MonteCarloConfigTemplateUpdateAsyncState, graphql_name='getMonteCarloConfigTemplateUpdateState', args=sgqlc.types.ArgDict((
        ('update_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='updateUuid', default=None)),
))
    )
    '''Get result of async Monte Carlo config template update

    Arguments:

    * `update_uuid` (`UUID!`): UUID of update to fetch result for
    '''

    get_correlation_sampling_metadata = sgqlc.types.Field(CorrelationSamplingMetadata, graphql_name='getCorrelationSamplingMetadata', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default='Table MCON')),
))
    )
    '''Provides initial information for sampling requests (e.g. time axis
    candidates, explanatory fields, etc.

    Arguments:

    * `mcon` (`String!`)None (default: `"Table MCON"`)
    '''

    detect_time_axis_intrinsic_delta = sgqlc.types.Field('TimeAxisDeltaDetectionResult', graphql_name='detectTimeAxisIntrinsicDelta', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default='Table MCON')),
        ('time_axis', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='timeAxis', default='Time axis field name')),
        ('anchor_event', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='anchorEvent', default='Anomaly event used for finding the time axis and intrinsic time overlap')),
))
    )
    '''Detects time delta between the selected time axis and intrinsic
    time

    Arguments:

    * `mcon` (`String!`)None (default: `"Table MCON"`)
    * `time_axis` (`String!`)None (default: `"Time axis field name"`)
    * `anchor_event` (`UUID!`)None (default: `"Anomaly event used for
      finding the time axis and intrinsic time overlap"`)
    '''

    perform_correlation_sampling = sgqlc.types.Field(CorrelationSamplingResult, graphql_name='performCorrelationSampling', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('field', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='field', default=None)),
        ('time_axis', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='timeAxis', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='endTime', default=None)),
        ('max_values', sgqlc.types.Arg(Int, graphql_name='maxValues', default=5)),
        ('max_rows', sgqlc.types.Arg(Int, graphql_name='maxRows', default=1000)),
))
    )
    '''Samples value distribution data alongside the time axis

    Arguments:

    * `mcon` (`String!`): MCON of the sampled table
    * `field` (`String!`): Field to be sampled
    * `time_axis` (`String!`): Time axis field used for sampling
    * `start_time` (`DateTime!`): Start time for sampling
    * `end_time` (`DateTime!`): End time for sampling
    * `max_values` (`Int`): Maximum number of top values (the rest is
      aggregated in "others") (default: `5`)
    * `max_rows` (`Int`): Maximum number of rows returned (default:
      `1000`)
    '''

    perform_correlation_sampling_with_time_travel = sgqlc.types.Field(CorrelationSamplingResult, graphql_name='performCorrelationSamplingWithTimeTravel', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('field', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='field', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='endTime', default=None)),
        ('max_values', sgqlc.types.Arg(Int, graphql_name='maxValues', default=5)),
        ('max_rows', sgqlc.types.Arg(Int, graphql_name='maxRows', default=1000)),
))
    )
    '''Samples value distribution data alongside the time axis

    Arguments:

    * `mcon` (`String!`): MCON of the sampled table
    * `field` (`String!`): Field to be sampled
    * `start_time` (`DateTime!`): Start time for sampling
    * `end_time` (`DateTime!`): End time for sampling
    * `max_values` (`Int`): Maximum number of top values (the rest is
      aggregated in "others") (default: `5`)
    * `max_rows` (`Int`): Maximum number of rows returned (default:
      `1000`)
    '''

    perform_field_health_sampling = sgqlc.types.Field(FieldHealthSampling, graphql_name='performFieldHealthSampling', args=sgqlc.types.ArgDict((
        ('field', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='field', default=None)),
        ('metric', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='metric', default=None)),
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='endTime', default=None)),
        ('max_rows', sgqlc.types.Arg(Int, graphql_name='maxRows', default=1000)),
        ('event_uuid', sgqlc.types.Arg(UUID, graphql_name='eventUuid', default=None)),
))
    )
    '''Samples value distribution data alongside the time axis

    Arguments:

    * `field` (`String!`): Field to be sampled
    * `metric` (`String!`): Metric to be sampled
    * `monitor_uuid` (`UUID!`): The Monitor UUID that monitors the
      field health
    * `start_time` (`DateTime!`): Start time for sampling
    * `end_time` (`DateTime!`): End time for sampling
    * `max_rows` (`Int`): Maximum number of rows returned (default:
      `1000`)
    * `event_uuid` (`UUID`): Optional UUID of an event that contains
      field metric anomaly
    '''

    get_rca_result = sgqlc.types.Field('RcaResult', graphql_name='getRcaResult', args=sgqlc.types.ArgDict((
        ('event_uuid', sgqlc.types.Arg(UUID, graphql_name='eventUuid', default=None)),
))
    )
    '''Arguments:

    * `event_uuid` (`UUID`)None
    '''

    get_rca_job_result = sgqlc.types.Field('RcaResult', graphql_name='getRcaJobResult', args=sgqlc.types.ArgDict((
        ('job_uuid', sgqlc.types.Arg(UUID, graphql_name='jobUuid', default=None)),
))
    )
    '''Arguments:

    * `job_uuid` (`UUID`)None
    '''

    get_incident_rcas = sgqlc.types.Field(IncidentRcaData, graphql_name='getIncidentRcas', args=sgqlc.types.ArgDict((
        ('incident_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentUuid', default=None)),
))
    )
    '''Fetches all RCAs of all types for an incident and includes a
    primary rca which is the most important one for the incident

    Arguments:

    * `incident_uuid` (`UUID!`): Incident identifier
    '''

    get_table_rcas = sgqlc.types.Field(sgqlc.types.list_of('ExtendedRca'), graphql_name='getTableRcas', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
))
    )
    '''Fetches all RCAs for a table

    Arguments:

    * `mcon` (`String!`): MC table unique identifier
    * `start_time` (`DateTime!`): Starting date to fetch RCAs from
    * `end_time` (`DateTime`): Optional end date to fetch RCAs,
      defaults to now
    '''

    get_sensitivity = sgqlc.types.Field('SensitivityThreshold', graphql_name='getSensitivity', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('event_type', sgqlc.types.Arg(String, graphql_name='eventType', default=None)),
        ('monitor_uuid', sgqlc.types.Arg(UUID, graphql_name='monitorUuid', default=None)),
))
    )
    '''Arguments:

    * `mcon` (`String`)None
    * `event_type` (`String`)None
    * `monitor_uuid` (`UUID`)None
    '''

    thresholds = sgqlc.types.Field('ThresholdsData', graphql_name='thresholds')
    '''Section describing various anomaly thresholds for the table'''

    get_thresholds = sgqlc.types.Field('ThresholdsData', graphql_name='getThresholds')
    '''Section describing various anomaly thresholds for the table'''

    get_table_columns_lineage = sgqlc.types.Field('TableColumnsLineageResult', graphql_name='getTableColumnsLineage', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
))
    )
    '''Column level lineage for a destination table

    Arguments:

    * `mcon` (`String`): Destination table mcon
    '''

    get_derived_tables_partial_lineage = sgqlc.types.Field(DerivedTablesLineageResult, graphql_name='getDerivedTablesPartialLineage', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('column', sgqlc.types.Arg(String, graphql_name='column', default=None)),
        ('cursor', sgqlc.types.Arg(String, graphql_name='cursor', default=None)),
        ('page_size', sgqlc.types.Arg(Int, graphql_name='pageSize', default=20)),
))
    )
    '''Tables and its columns that are influenced by the source table and
    column. Note we only return columns that are influenced by the
    source column in the response.

    Arguments:

    * `mcon` (`String`): source table mcon
    * `column` (`String`): source column
    * `cursor` (`String`): cursor for getting the next page
    * `page_size` (`Int`): number of derived tables to return in a
      call (default: `20`)
    '''

    get_parsed_query = sgqlc.types.Field(ParsedQueryResult, graphql_name='getParsedQuery', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
))
    )
    '''The query, based on which the table's created

    Arguments:

    * `mcon` (`String`): Source table mcon
    '''

    get_job_execution_history_logs = sgqlc.types.Field(sgqlc.types.list_of(JobExecutionHistoryLog), graphql_name='getJobExecutionHistoryLogs', args=sgqlc.types.ArgDict((
        ('job_schedule_uuid', sgqlc.types.Arg(String, graphql_name='jobScheduleUuid', default=None)),
        ('monitor_uuid', sgqlc.types.Arg(String, graphql_name='monitorUuid', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(String, graphql_name='customRuleUuid', default=None)),
        ('history_days', sgqlc.types.Arg(Int, graphql_name='historyDays', default=None)),
        ('include_snoozed', sgqlc.types.Arg(Boolean, graphql_name='includeSnoozed', default=False)),
        ('include_data_collection_only', sgqlc.types.Arg(Boolean, graphql_name='includeDataCollectionOnly', default=False)),
))
    )
    '''Arguments:

    * `job_schedule_uuid` (`String`): UUID of job schedule
    * `monitor_uuid` (`String`): UUID of monitor
    * `custom_rule_uuid` (`String`): UUID of custom rule
    * `history_days` (`Int`): Number of days back
    * `include_snoozed` (`Boolean`): Include snoozed jobs (default:
      `false`)
    * `include_data_collection_only` (`Boolean`): Include data
      collection only jobs (default: `false`)
    '''

    get_dimension_tracking_monitor_suggestions = sgqlc.types.Field(DimensionTrackingSuggestionsConnection, graphql_name='getDimensionTrackingMonitorSuggestions', args=sgqlc.types.ArgDict((
        ('entities', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='entities', default=None)),
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Return all dimension tracking monitor suggestions for the account,
    filtering the ones that already exist for the table+field

    Arguments:

    * `entities` (`[String]`): Filter by associated entities (tables)
    * `order_by` (`String`): Sorting of results
    * `domain_id` (`UUID`): Filter by domain UUID
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_field_health_monitor_suggestions = sgqlc.types.Field(FieldHealthSuggestionsConnection, graphql_name='getFieldHealthMonitorSuggestions', args=sgqlc.types.ArgDict((
        ('entities', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='entities', default=None)),
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Return all field health monitor suggestions for the account,
    filtering the ones that already exist for the table

    Arguments:

    * `entities` (`[String]`): Filter by associated entities (tables)
    * `order_by` (`String`): Sorting of results
    * `domain_id` (`UUID`): Filter by domain UUID
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_monitors = sgqlc.types.Field(sgqlc.types.list_of('Monitor'), graphql_name='getMonitors', args=sgqlc.types.ArgDict((
        ('monitor_types', sgqlc.types.Arg(sgqlc.types.list_of(UserDefinedMonitors), graphql_name='monitorTypes', default=None)),
        ('status_types', sgqlc.types.Arg(sgqlc.types.list_of(MonitorStatusType), graphql_name='statusTypes', default=None)),
        ('description_field_or_table', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='descriptionFieldOrTable', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('uuids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='uuids', default=None)),
        ('created_by_filters', sgqlc.types.Arg(CreatedByFilters, graphql_name='createdByFilters', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('search', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='search', default=None)),
        ('search_fields', sgqlc.types.Arg(sgqlc.types.list_of(UserDefinedMonitorSearchFields), graphql_name='searchFields', default=None)),
        ('namespaces', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='namespaces', default=None)),
        ('is_template_managed', sgqlc.types.Arg(Boolean, graphql_name='isTemplateManaged', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
))
    )
    '''List of monitors

    Arguments:

    * `monitor_types` (`[UserDefinedMonitors]`): Type of monitors to
      filter by, default all
    * `status_types` (`[MonitorStatusType]`): Type of monitor status
      to filter by, default all
    * `description_field_or_table` (`[String]`): DEPRECATED
    * `domain_id` (`UUID`): Domain uuid to filter by
    * `uuids` (`[String]`): list of uuids of the monitors to filter by
    * `created_by_filters` (`CreatedByFilters`): Deprecated
    * `labels` (`[String]`): List of labels to filter by
    * `search` (`[String]`): Search criteria for filtering the
      monitors list
    * `search_fields` (`[UserDefinedMonitorSearchFields]`): Which
      fields to include during search
    * `namespaces` (`[String]`): filter by namespaces
    * `is_template_managed` (`Boolean`): Filter monitors created by
      code
    * `mcons` (`[String]`): Filter by associated entities (MCON)
    * `order_by` (`String`): Field and direction to order monitors by
    * `limit` (`Int`): Number of monitors to return
    * `offset` (`Int`): From which monitor to return the next results
    '''

    get_monitor_queries = sgqlc.types.Field(MonitorQueries, graphql_name='getMonitorQueries', args=sgqlc.types.ArgDict((
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('bootstrap', sgqlc.types.Arg(Boolean, graphql_name='bootstrap', default=None)),
        ('format_sql', sgqlc.types.Arg(Boolean, graphql_name='formatSql', default=True)),
        ('strip_metadata_comment', sgqlc.types.Arg(Boolean, graphql_name='stripMetadataComment', default=False)),
        ('all_queries', sgqlc.types.Arg(Boolean, graphql_name='allQueries', default=False)),
))
    )
    '''Arguments:

    * `monitor_uuid` (`UUID!`): UUID of monitor
    * `bootstrap` (`Boolean`): Return the bootstrap query
    * `format_sql` (`Boolean`): Pretty-print the SQL query (default:
      `true`)
    * `strip_metadata_comment` (`Boolean`): Strip the leading metadata
      comment (default: `false`)
    * `all_queries` (`Boolean`): Returns all queries that will be
      issued when the monitor is run. If false, only the first query
      will be returned. (default: `false`)
    '''

    test_monitor_queries = sgqlc.types.Field(MonitorQueriesResults, graphql_name='testMonitorQueries', args=sgqlc.types.ArgDict((
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('all_queries', sgqlc.types.Arg(Boolean, graphql_name='allQueries', default=False)),
))
    )
    '''Arguments:

    * `monitor_uuid` (`UUID!`): UUID of monitor
    * `all_queries` (`Boolean`): Runs all the queries that will be
      issued when the monitor is run. If false, only the first query
      will be executed. (default: `false`)
    '''

    get_all_user_defined_monitors_v2 = sgqlc.types.Field('UserDefinedMonitorConnectionV2Connection', graphql_name='getAllUserDefinedMonitorsV2', args=sgqlc.types.ArgDict((
        ('user_defined_monitor_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='userDefinedMonitorTypes', default=None)),
        ('created_by', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='createdBy', default=None)),
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
        ('entities', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='entities', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('description_field_or_table', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='descriptionFieldOrTable', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('is_template_managed', sgqlc.types.Arg(Boolean, graphql_name='isTemplateManaged', default=None)),
        ('namespace', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='namespace', default=None)),
        ('rule_name', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='ruleName', default=None)),
        ('search', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='search', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `user_defined_monitor_types` (`[String]`): Filter by monitor
      type
    * `created_by` (`[String]`): Filter by creator
    * `order_by` (`String`): Sorting of results
    * `entities` (`[String]`): Filter by associated entities (full
      table ID)
    * `mcons` (`[String]`): Filter by associated entities (MCON)
    * `description_field_or_table` (`[String]`): Match text on rule
      description, table, or field
    * `domain_id` (`UUID`): Filter by domain UUID
    * `is_template_managed` (`Boolean`): Filter monitors created by
      code
    * `namespace` (`[String]`): Filter by namespace -> used in
      monitors created by code
    * `rule_name` (`[String]`): Filter by rule_name -> used in
      monitors created by code
    * `search` (`[String]`): Filter by: description, field, table,
      rule name, creator, namespace
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_all_user_defined_monitors = sgqlc.types.Field('UserDefinedMonitorConnection', graphql_name='getAllUserDefinedMonitors', args=sgqlc.types.ArgDict((
        ('user_defined_monitor_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='userDefinedMonitorTypes', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `user_defined_monitor_types` (`[String]`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_custom_metrics = sgqlc.types.Field(Metrics, graphql_name='getCustomMetrics', args=sgqlc.types.ArgDict((
        ('rule_uuid', sgqlc.types.Arg(UUID, graphql_name='ruleUuid', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=5000)),
))
    )
    '''Retrieve custom metrics based on a custom rule

    Arguments:

    * `rule_uuid` (`UUID`): A custom rule UUID
    * `start_time` (`DateTime`): Beginning of time range to retrieve
      metrics for
    * `end_time` (`DateTime`): End of time range to retrieve metrics
      for
    * `first` (`Int`): Limit of number of metrics retrieved (default:
      `5000`)
    '''

    get_custom_rule = sgqlc.types.Field('CustomRule', graphql_name='getCustomRule', args=sgqlc.types.ArgDict((
        ('rule_id', sgqlc.types.Arg(UUID, graphql_name='ruleId', default=None)),
        ('description_contains', sgqlc.types.Arg(String, graphql_name='descriptionContains', default=None)),
        ('custom_sql_contains', sgqlc.types.Arg(String, graphql_name='customSqlContains', default=None)),
))
    )
    '''Get a custom rule

    Arguments:

    * `rule_id` (`UUID`): Rule id
    * `description_contains` (`String`): String to completely or
      partially match the rule description, case-insensitive
    * `custom_sql_contains` (`String`): String to completely or
      partially match the rule SQL, case-insensitive
    '''

    get_custom_rules = sgqlc.types.Field(CustomRuleConnection, graphql_name='getCustomRules', args=sgqlc.types.ArgDict((
        ('entity_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='entityMcons', default=None)),
        ('metadata_keys', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='metadataKeys', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('rule_type', sgqlc.types.Arg(CustomRuleModelRuleType, graphql_name='ruleType', default=None)),
        ('warehouse_uuid', sgqlc.types.Arg(UUID, graphql_name='warehouseUuid', default=None)),
))
    )
    '''Arguments:

    * `entity_mcons` (`[String]`): Return rules associated with any of
      these table MCONs
    * `metadata_keys` (`[String]`): Return rules with all these keys
      in their metadata
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `rule_type` (`CustomRuleModelRuleType`)None
    * `warehouse_uuid` (`UUID`)None
    '''

    get_generated_rules = sgqlc.types.Field(sgqlc.types.list_of('CustomRule'), graphql_name='getGeneratedRules', args=sgqlc.types.ArgDict((
        ('generated_by_uuid', sgqlc.types.Arg(UUID, graphql_name='generatedByUuid', default=None)),
))
    )
    '''Arguments:

    * `generated_by_uuid` (`UUID`): Parent CustomRule UUID
    '''

    get_circuit_breaker_rule_state = sgqlc.types.Field(CircuitBreakerState, graphql_name='getCircuitBreakerRuleState', args=sgqlc.types.ArgDict((
        ('job_execution_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='jobExecutionUuid', default=None)),
))
    )
    '''State for the circuit breaker rule job execution

    Arguments:

    * `job_execution_uuid` (`UUID!`): The UUID of the job execution to
      get the state for
    '''

    get_circuit_breaker_rule_state_v2 = sgqlc.types.Field(sgqlc.types.list_of(CircuitBreakerState), graphql_name='getCircuitBreakerRuleStateV2', args=sgqlc.types.ArgDict((
        ('job_execution_uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='jobExecutionUuids', default=None)),
))
    )
    '''State for the circuit breaker rule job executions

    Arguments:

    * `job_execution_uuids` (`[UUID]!`): The UUIDs of the job
      executions to get the state for
    '''

    get_run_sql_rule_state = sgqlc.types.Field(sgqlc.types.list_of(CircuitBreakerState), graphql_name='getRunSqlRuleState', args=sgqlc.types.ArgDict((
        ('job_execution_uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='jobExecutionUuids', default=None)),
))
    )
    '''State for the sql rule job executions

    Arguments:

    * `job_execution_uuids` (`[UUID]!`): The UUID of the job execution
      to get the state for
    '''

    get_tables_for_sql = sgqlc.types.Field(sgqlc.types.list_of('SqlQueryTable'), graphql_name='getTablesForSql', args=sgqlc.types.ArgDict((
        ('warehouse_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='warehouseUuid', default=None)),
        ('custom_sql', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='customSql', default=None)),
        ('custom_sampling_sql', sgqlc.types.Arg(String, graphql_name='customSamplingSql', default=None)),
        ('variables', sgqlc.types.Arg(JSONString, graphql_name='variables', default=None)),
))
    )
    '''The full table ids calculated from the sql query

    Arguments:

    * `warehouse_uuid` (`UUID!`): Warehouse UUID.
    * `custom_sql` (`String!`): Custom SQL query to run
    * `custom_sampling_sql` (`String`): Custom sampling SQL query to
      run on breach
    * `variables` (`JSONString`): Possible variable values for SQL
      query
    '''

    get_notification_settings_for_rules_with = sgqlc.types.Field(sgqlc.types.list_of(AccountNotificationSetting), graphql_name='getNotificationSettingsForRulesWith', args=sgqlc.types.ArgDict((
        ('rule_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='ruleType', default=None)),
        ('warehouse_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='warehouseUuid', default=None)),
        ('full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='fullTableIds', default=None)),
        ('label_names', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labelNames', default=None)),
))
    )
    '''The notification settings that will be used in a rule with the
    specified data

    Arguments:

    * `rule_type` (`String!`): Rule type.
    * `warehouse_uuid` (`UUID!`): Warehouse UUID.
    * `full_table_ids` (`[String]`): Full table ids.
    * `label_names` (`[String]`): Monitor labels.
    '''

    get_field_metric_query = sgqlc.types.Field(FieldMetricQuery, graphql_name='getFieldMetricQuery', args=sgqlc.types.ArgDict((
        ('field_metric', sgqlc.types.Arg(sgqlc.types.non_null(FieldMetricInput), graphql_name='fieldMetric', default=None)),
))
    )
    '''Build Field Metric query from parameters

    Arguments:

    * `field_metric` (`FieldMetricInput!`): Field Metric query
      parameters
    '''

    get_field_query = sgqlc.types.Field(FieldQuery, graphql_name='getFieldQuery', args=sgqlc.types.ArgDict((
        ('field_query_parameters', sgqlc.types.Arg(sgqlc.types.non_null(FieldQueryParametersInput), graphql_name='fieldQueryParameters', default=None)),
))
    )
    '''Build Field Metric query from parameters

    Arguments:

    * `field_query_parameters` (`FieldQueryParametersInput!`): Field
      Metric query parameters
    '''

    get_query_template = sgqlc.types.Field('QueryTemplateOutput', graphql_name='getQueryTemplate', args=sgqlc.types.ArgDict((
        ('query_template_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='queryTemplateId', default=None)),
        ('warehouse_uuid', sgqlc.types.Arg(UUID, graphql_name='warehouseUuid', default=None)),
        ('variable_values', sgqlc.types.Arg(sgqlc.types.list_of(sgqlc.types.non_null(QueryTemplateVariableValueInput)), graphql_name='variableValues', default=None)),
))
    )
    '''Gets a query template

    Arguments:

    * `query_template_id` (`String!`): ID for the template used to
      generate this query
    * `warehouse_uuid` (`UUID`): UUID for the warehouse where the run
      will be executed
    * `variable_values` (`[QueryTemplateVariableValueInput!]`): Values
      for the template variables. If not provided, the template source
      will be returned
    '''

    get_custom_rule_execution_analytics = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(CustomRuleExecutionAnalytics))), graphql_name='getCustomRuleExecutionAnalytics', args=sgqlc.types.ArgDict((
        ('rule_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='ruleId', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('group_by', sgqlc.types.Arg(sgqlc.types.non_null(PeriodGrouping), graphql_name='groupBy', default=None)),
))
    )
    '''Return analytics for the executions of the custom rules

    Arguments:

    * `rule_id` (`UUID!`): Rule id
    * `start_time` (`DateTime!`): Beginning of time range to calculate
      the execution analytics
    * `end_time` (`DateTime`): End of time range to calculate the
      execution analytics
    * `group_by` (`PeriodGrouping!`): Time buckets to group time-bound
      analytics by.
    '''

    get_insights = sgqlc.types.Field(sgqlc.types.list_of(Insight), graphql_name='getInsights')
    '''List of available insights'''

    get_insight = sgqlc.types.Field(Insight, graphql_name='getInsight', args=sgqlc.types.ArgDict((
        ('insight_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='insightName', default=None)),
))
    )
    '''Arguments:

    * `insight_name` (`String!`): Name (id) of insight to fetch
    '''

    get_reports = sgqlc.types.Field(sgqlc.types.list_of('Report'), graphql_name='getReports', args=sgqlc.types.ArgDict((
        ('insight_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='insightName', default=None)),
))
    )
    '''Arguments:

    * `insight_name` (`String!`): Name (id) of insight for which to
      fetch reports
    '''

    get_report_url = sgqlc.types.Field('ResponseURL', graphql_name='getReportUrl', args=sgqlc.types.ArgDict((
        ('insight_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='insightName', default=None)),
        ('report_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='reportName', default=None)),
        ('created_before', sgqlc.types.Arg(DateTime, graphql_name='createdBefore', default=None)),
))
    )
    '''Name (id) of insight to fetch

    Arguments:

    * `insight_name` (`String!`)None
    * `report_name` (`String!`): Name of report to fetch
    * `created_before` (`DateTime`): Version of the report created
      before specific date
    '''

    get_lineage_node_block_pattern = sgqlc.types.Field(LineageNodeBlockPattern, graphql_name='getLineageNodeBlockPattern', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='uuid', default=None)),
))
    )
    '''Retrieve a node block pattern

    Arguments:

    * `uuid` (`String!`): Node block pattern id
    '''

    get_lineage_node_block_patterns = sgqlc.types.Field(sgqlc.types.list_of(LineageNodeBlockPattern), graphql_name='getLineageNodeBlockPatterns', args=sgqlc.types.ArgDict((
        ('resource_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='resourceId', default=None)),
))
    )
    '''Retrieve a list of node block patterns

    Arguments:

    * `resource_id` (`String!`): Resource id of the resources
    '''

    get_lineage_node_replacement_rule = sgqlc.types.Field(LineageNodeReplacementRule, graphql_name='getLineageNodeReplacementRule', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Retrieve a node replacement rule

    Arguments:

    * `uuid` (`UUID!`): Replacement rule UUID
    '''

    get_lineage_node_replacement_rules = sgqlc.types.Field(sgqlc.types.list_of(LineageNodeReplacementRule), graphql_name='getLineageNodeReplacementRules', args=sgqlc.types.ArgDict((
        ('resource_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='resourceId', default=None)),
))
    )
    '''Retrieve a list of node replacement rules

    Arguments:

    * `resource_id` (`UUID!`): Resource id of the resources
    '''

    get_lineage_node_collapsing_rules = sgqlc.types.Field(sgqlc.types.list_of(LineageNodeCollapsingRule), graphql_name='getLineageNodeCollapsingRules')
    '''Retrieve a list of node collapsing rules'''

    get_lineage_node_collapsing_rule = sgqlc.types.Field(LineageNodeCollapsingRule, graphql_name='getLineageNodeCollapsingRule', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Retrieve a node collapsing rule

    Arguments:

    * `uuid` (`UUID!`): Collapsing rule UUID
    '''

    simulate_lineage_node_replacement_rule = sgqlc.types.Field(sgqlc.types.list_of(LineageNodeReplacementRuleResult), graphql_name='simulateLineageNodeReplacementRule', args=sgqlc.types.ArgDict((
        ('pattern', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='pattern', default=None)),
        ('replacement', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='replacement', default=None)),
        ('test_input_strings', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='testInputStrings', default=None)),
        ('case_insensitive', sgqlc.types.Arg(Boolean, graphql_name='caseInsensitive', default=None)),
))
    )
    '''Simulate a replacement pattern

    Arguments:

    * `pattern` (`String!`): Input regex pattern
    * `replacement` (`String!`): Replacement pattern
    * `test_input_strings` (`[String]!`): Input to test
    * `case_insensitive` (`Boolean`): Case sensitivity of the pattern
      matching
    '''

    get_catalog_object_metadata = sgqlc.types.Field(CatalogObjectMetadataConnection, graphql_name='getCatalogObjectMetadata', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `mcon` (`String`)None
    '''

    get_catalog_usage_nodes = sgqlc.types.Field(CatalogUsageNodesResults, graphql_name='getCatalogUsageNodes', args=sgqlc.types.ArgDict((
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('parent_mcon', sgqlc.types.Arg(String, graphql_name='parentMcon', default=None)),
        ('object_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='objectTypes', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('display_name_contains', sgqlc.types.Arg(String, graphql_name='displayNameContains', default=None)),
        ('filter_options', sgqlc.types.Arg(InputFilterOptions, graphql_name='filterOptions', default=None)),
))
    )
    '''Get nodes for an asset by type and hierarchy. It is currently used
    for Consumption-based Pricing (CBP) use case.

    Arguments:

    * `domain_id` (`UUID`): Only include objects in this domain or its
      hierarchy.
    * `mcon` (`String`): Filter by mcon, returns this single object
    * `parent_mcon` (`String`): Only include children of this catalog
      object. If not given, will get top-level objects.
    * `object_types` (`[String]`): Only include objects of these
      types.
    * `offset` (`Int`): Starting node index for current page.
    * `limit` (`Int`): Max nodes to get for page.
    * `display_name_contains` (`String`): To search a substring of an
      asset's display name.
    * `filter_options` (`InputFilterOptions`): To filter results by
      only ingested/not ingested/monitored/not monitored tables.
    '''

    get_catalog_nav_level_nodes = sgqlc.types.Field(CatalogNavResults, graphql_name='getCatalogNavLevelNodes', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('parent_mcon', sgqlc.types.Arg(String, graphql_name='parentMcon', default=None)),
        ('object_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='objectTypes', default=None)),
        ('exclude_object_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeObjectTypes', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
))
    )
    '''Get nodes for navigating the catalog by type and hierarchy.

    Arguments:

    * `mcon` (`String`): Filter by mcon, returns this single object
    * `parent_mcon` (`String`): Only include children of this catalog
      object. If not given, will get top-level objects.
    * `object_types` (`[String]`): Only include objects of these
      types.
    * `exclude_object_types` (`[String]`): Exclude objects of these
      types.
    * `domain_id` (`UUID`): Only include objects in this domain or its
      hierarchy.
    * `offset` (`Int`): Starting node index for current page.
    * `limit` (`Int`): Max nodes to get for page.
    '''

    get_catalog_nav_grouped_nodes = sgqlc.types.Field(sgqlc.types.list_of(CatalogNavResults), graphql_name='getCatalogNavGroupedNodes', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('parent_mcon', sgqlc.types.Arg(String, graphql_name='parentMcon', default=None)),
        ('object_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='objectTypes', default=None)),
        ('exclude_object_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeObjectTypes', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
))
    )
    '''Get nodes for navigating the catalog by type and hierarchy.

    Arguments:

    * `mcon` (`String`): Filter by mcon, returns this single object
    * `parent_mcon` (`String`): Only include children of this catalog
      object. If not given, will get top-level objects.
    * `object_types` (`[String]`): Only include objects of these
      types.
    * `exclude_object_types` (`[String]`): Exclude objects of these
      types.
    * `domain_id` (`UUID`): Only include objects in this domain or its
      hierarchy.
    * `offset` (`Int`): Starting node index for current page.
    * `limit` (`Int`): Max nodes to get for page.
    '''

    get_object_properties = sgqlc.types.Field(ObjectPropertyConnection, graphql_name='getObjectProperties', args=sgqlc.types.ArgDict((
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('mcon_id', sgqlc.types.Arg(String, graphql_name='mconId', default=None)),
))
    )
    '''Arguments:

    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `mcon_id` (`String`)None
    '''

    get_object_property_name_values = sgqlc.types.Field(PropertyNameValues, graphql_name='getObjectPropertyNameValues', args=sgqlc.types.ArgDict((
        ('search_string', sgqlc.types.Arg(String, graphql_name='searchString', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=100)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=0)),
))
    )
    '''Return all unique property names/values for an account

    Arguments:

    * `search_string` (`String`)None
    * `first` (`Int`)None (default: `100`)
    * `offset` (`Int`)None (default: `0`)
    '''

    get_object_property_names = sgqlc.types.Field(PropertyNames, graphql_name='getObjectPropertyNames', args=sgqlc.types.ArgDict((
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=100)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=0)),
        ('search_string', sgqlc.types.Arg(String, graphql_name='searchString', default=None)),
))
    )
    '''Return all unique property names for an account

    Arguments:

    * `limit` (`Int`)None (default: `100`)
    * `offset` (`Int`)None (default: `0`)
    * `search_string` (`String`): Filter property names by search
      string
    '''

    get_object_property_values = sgqlc.types.Field(PropertyValues, graphql_name='getObjectPropertyValues', args=sgqlc.types.ArgDict((
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=100)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=0)),
        ('property_name', sgqlc.types.Arg(String, graphql_name='propertyName', default=None)),
        ('search_string', sgqlc.types.Arg(String, graphql_name='searchString', default=None)),
))
    )
    '''Return all unique property values for an account

    Arguments:

    * `limit` (`Int`)None (default: `100`)
    * `offset` (`Int`)None (default: `0`)
    * `property_name` (`String`): Filter by property name
    * `search_string` (`String`): Filter property values by search
      string
    '''

    get_monitor_labels = sgqlc.types.Field(sgqlc.types.list_of(MonitorLabelObject), graphql_name='getMonitorLabels')
    '''Get monitor labels'''

    monitor_labels = sgqlc.types.Field(sgqlc.types.list_of(MonitorLabel), graphql_name='monitorLabels')
    '''Get monitor labels'''

    get_account_monitor_labels = sgqlc.types.Field(sgqlc.types.list_of(MonitorLabelObject), graphql_name='getAccountMonitorLabels')
    '''Get monitor labels'''

    get_custom_sql_templates = sgqlc.types.Field(CustomSQLTemplateConnection, graphql_name='getCustomSqlTemplates', args=sgqlc.types.ArgDict((
        ('query_result_type_filter', sgqlc.types.Arg(QueryResultType, graphql_name='queryResultTypeFilter', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('sql_template', sgqlc.types.Arg(String, graphql_name='sqlTemplate', default=None)),
        ('dialect', sgqlc.types.Arg(String, graphql_name='dialect', default=None)),
        ('query_result_type', sgqlc.types.Arg(CustomSQLTemplateModelQueryResultType, graphql_name='queryResultType', default=None)),
))
    )
    '''Get all active Custom SQL Templates

    Arguments:

    * `query_result_type_filter` (`QueryResultType`):
      CustomSQLTemplate's query result type can be set to
      SINGLE_NUMERIC, ROW_COUNT and LABELED_NUMERICS. The filter is
      None then all templates are returned
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `uuid` (`UUID`)None
    * `name` (`String`)None
    * `description` (`String`)None
    * `sql_template` (`String`)None
    * `dialect` (`String`)None
    * `query_result_type`
      (`CustomSQLTemplateModelQueryResultType`)None
    '''

    get_active_monitors = sgqlc.types.Field(MetricMonitoringConnection, graphql_name='getActiveMonitors', args=sgqlc.types.ArgDict((
        ('entities', sgqlc.types.Arg(String, graphql_name='entities', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('type', sgqlc.types.Arg(String, graphql_name='type', default=None)),
))
    )
    '''Get all active custom monitors (one of Field Health, Distribution
    Tracking, or JSON Schema). Does not return custom rules.

    Arguments:

    * `entities` (`String`): Filter by full table id or mcon
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `type` (`String`)None
    '''

    get_monitor_summary = sgqlc.types.Field(MonitorSummary, graphql_name='getMonitorSummary', args=sgqlc.types.ArgDict((
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
))
    )
    '''Arguments:

    * `resource_id` (`UUID`): Filter by resource UUID
    * `domain_id` (`UUID`): Filter by domain UUID
    '''

    get_monitors_by_type = sgqlc.types.Field(MetricMonitoringConnection, graphql_name='getMonitorsByType', args=sgqlc.types.ArgDict((
        ('monitor_type', sgqlc.types.Arg(String, graphql_name='monitorType', default=None)),
        ('monitor_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='monitorTypes', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('type', sgqlc.types.Arg(String, graphql_name='type', default=None)),
))
    )
    '''Retrieve information on custom monitors of a given type (one of
    Field Health, Distribution Tracking, or JSON Schema). Does not
    return custom rules.

    Arguments:

    * `monitor_type` (`String`)None
    * `monitor_types` (`[String]`)None
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `type` (`String`)None
    '''

    get_monitor = sgqlc.types.Field('MetricMonitoring', graphql_name='getMonitor', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('monitor_type', sgqlc.types.Arg(String, graphql_name='monitorType', default=None)),
))
    )
    '''Retrieve information about a custom monitor (one of Field Health,
    Distribution Tracking, or JSON Schema). Does not return custom
    rules.

    Arguments:

    * `uuid` (`UUID`): Get monitor by UUID
    * `resource_id` (`UUID`): Specify the resource uuid (e.g.
      warehouse the table is contained in) when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Get monitor by mcon
    * `monitor_type` (`String`): Specify the monitor type. Required
      when using an mcon or full table id
    '''

    get_monitor_configuration = sgqlc.types.Field(MonitorConfiguration, graphql_name='getMonitorConfiguration', args=sgqlc.types.ArgDict((
        ('configuration_data', sgqlc.types.Arg(MonitorConfigurationInput, graphql_name='configurationData', default=None)),
))
    )
    '''The time axis data for the monitor

    Arguments:

    * `configuration_data` (`MonitorConfigurationInput`)
    '''

    get_monitor_scheduling_configuration = sgqlc.types.Field(MonitorSchedulingConfiguration, graphql_name='getMonitorSchedulingConfiguration', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''The scheduling configuration for the monitor

    Arguments:

    * `mcon` (`String!`): mcon for table to fetch scheduling for
    '''

    get_time_axis_sql_expressions = sgqlc.types.Field(sgqlc.types.list_of('SqlExpression'), graphql_name='getTimeAxisSqlExpressions')
    '''The SQL expressions used in time axis in monitors for the account'''

    get_notification_settings_for_monitors_with = sgqlc.types.Field(sgqlc.types.list_of(AccountNotificationSetting), graphql_name='getNotificationSettingsForMonitorsWith', args=sgqlc.types.ArgDict((
        ('monitor_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='monitorType', default=None)),
        ('label_names', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labelNames', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
))
    )
    '''The notification settings that will be used in a monitor with the
    specified data

    Arguments:

    * `monitor_type` (`String!`): Monitor type.
    * `label_names` (`[String]`): Label names.
    * `mcon` (`String`): MCON of the table associated with the
      monitor.
    '''

    get_delta_logs = sgqlc.types.Field(DeltaLogConnection, graphql_name='getDeltaLogs', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
))
    )
    '''Get Delta logs for the provided table. Due to Databricks'
    limitations, this query field only supports forwards pagination
    with first and after, but not backwards with last and before.

    Arguments:

    * `mcon` (`String!`): MCON for table to get delta logs for
    * `start_time` (`DateTime`): Beginning of time window to filter
      to. Defaults to the 10 most recent delta logs.
    * `end_time` (`DateTime`): End of time window to filter to.
      Defaults to the 10 most recent delta logs.
    * `first` (`Int`): The number of items to return (default: 10).
    * `after` (`String`): Cursor of the last item on the previous page
    '''

    get_data_assets_dashboard = sgqlc.types.Field(DataAssetDashboard, graphql_name='getDataAssetsDashboard', args=sgqlc.types.ArgDict((
        ('domain_uuid', sgqlc.types.Arg(UUID, graphql_name='domainUuid', default=None)),
))
    )
    '''Dashboard counts for monitored data assets

    Arguments:

    * `domain_uuid` (`UUID`): The domain id to filter by
    '''

    get_incident_dashboard_data = sgqlc.types.Field(IncidentDashboardData, graphql_name='getIncidentDashboardData', args=sgqlc.types.ArgDict((
        ('domain_uuid', sgqlc.types.Arg(UUID, graphql_name='domainUuid', default=None)),
        ('lookback_weeks', sgqlc.types.Arg(Int, graphql_name='lookbackWeeks', default=None)),
))
    )
    '''Dashboard counts for incidents occurring over specified weeks

    Arguments:

    * `domain_uuid` (`UUID`): The domain id to filter by
    * `lookback_weeks` (`Int`): The number of weeks to aggregate data
      over
    '''

    get_incident_data_weekly = sgqlc.types.Field(IncidentWeeklyDataDashboard, graphql_name='getIncidentDataWeekly', args=sgqlc.types.ArgDict((
        ('group_by', sgqlc.types.Arg(sgqlc.types.non_null(IncidentGroupBy), graphql_name='groupBy', default=None)),
        ('domain_uuid', sgqlc.types.Arg(UUID, graphql_name='domainUuid', default=None)),
        ('lookback_weeks', sgqlc.types.Arg(Int, graphql_name='lookbackWeeks', default=None)),
))
    )
    '''Dashboard counts for incidents occurring over specified weeks

    Arguments:

    * `group_by` (`IncidentGroupBy!`): The value to group the
      incidents by
    * `domain_uuid` (`UUID`): The domain id to filter by
    * `lookback_weeks` (`Int`): The number of weeks to aggregate data
      over
    '''

    get_monitor_dashboard_data = sgqlc.types.Field(MonitorDashboardData, graphql_name='getMonitorDashboardData', args=sgqlc.types.ArgDict((
        ('domain_uuid', sgqlc.types.Arg(UUID, graphql_name='domainUuid', default=None)),
))
    )
    '''Dashboard counts for mmonitors

    Arguments:

    * `domain_uuid` (`UUID`): The domain id to filter by
    '''

    get_blast_radius_direct_users = sgqlc.types.Field(PaginateUsersBlastRadius, graphql_name='getBlastRadiusDirectUsers', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('lookback', sgqlc.types.Arg(sgqlc.types.non_null(LookbackRange), graphql_name='lookback', default=None)),
        ('after_key', sgqlc.types.Arg(UserAfterKeyInput, graphql_name='afterKey', default=None)),
        ('size', sgqlc.types.Arg(Int, graphql_name='size', default=None)),
))
    )
    '''User information for direct blast radius of an incident.
    DEPRECATED - please use getBlastRadiusDirectUsersV2

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    * `lookback` (`LookbackRange!`): The lookback period for the blast
      radius [ONE_HOUR, TWELVE_HOUR, ONE_DAY, SEVEN_DAY]
    * `after_key` (`UserAfterKeyInput`): The key for pagination
    * `size` (`Int`): The max number of results to fetch
    '''

    get_blast_radius_direct_users_v2 = sgqlc.types.Field(PaginateUsersBlastRadius2, graphql_name='getBlastRadiusDirectUsersV2', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('lookback', sgqlc.types.Arg(sgqlc.types.non_null(LookbackRange), graphql_name='lookback', default=None)),
        ('after_key', sgqlc.types.Arg(UserAfterKeyInput2, graphql_name='afterKey', default=None)),
        ('size', sgqlc.types.Arg(Int, graphql_name='size', default=None)),
))
    )
    '''User information for direct blast radius of an incident

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    * `lookback` (`LookbackRange!`): The lookback period for the blast
      radius [ONE_HOUR, TWELVE_HOUR, ONE_DAY, SEVEN_DAY]
    * `after_key` (`UserAfterKeyInput2`): The key for pagination
    * `size` (`Int`): The max number of results to fetch
    '''

    get_blast_radius_direct_queries = sgqlc.types.Field(PaginateQueriesBlastRadius, graphql_name='getBlastRadiusDirectQueries', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('lookback', sgqlc.types.Arg(sgqlc.types.non_null(LookbackRange), graphql_name='lookback', default=None)),
        ('after_key', sgqlc.types.Arg(QueryAfterKeyInput, graphql_name='afterKey', default=None)),
        ('size', sgqlc.types.Arg(Int, graphql_name='size', default=None)),
))
    )
    '''Direct queries for blast radius of incident

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    * `lookback` (`LookbackRange!`): The lookback period for the blast
      radius [ONE_HOUR, TWELVE_HOUR, ONE_DAY, SEVEN_DAY]
    * `after_key` (`QueryAfterKeyInput`): The key for pagination
    * `size` (`Int`): The max number of results to fetch
    '''

    get_blast_radius_direct_queries_v2 = sgqlc.types.Field(PaginateQueriesBlastRadius2, graphql_name='getBlastRadiusDirectQueriesV2', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('lookback', sgqlc.types.Arg(sgqlc.types.non_null(LookbackRange), graphql_name='lookback', default=None)),
        ('after_key', sgqlc.types.Arg(UserAfterKeyInput2, graphql_name='afterKey', default=None)),
        ('size', sgqlc.types.Arg(Int, graphql_name='size', default=None)),
))
    )
    '''Direct queries for blast radius of incident

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    * `lookback` (`LookbackRange!`): The lookback period for the blast
      radius [ONE_HOUR, TWELVE_HOUR, ONE_DAY, SEVEN_DAY]
    * `after_key` (`UserAfterKeyInput2`): The key for pagination
    * `size` (`Int`): The max number of results to fetch
    '''

    get_blast_radius_direct_queries_summary = sgqlc.types.Field(PaginateQueriesBlastRadiusSummary, graphql_name='getBlastRadiusDirectQueriesSummary', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('lookback', sgqlc.types.Arg(sgqlc.types.non_null(LookbackRange), graphql_name='lookback', default=None)),
        ('after_key', sgqlc.types.Arg(UserAfterKeyInput2, graphql_name='afterKey', default=None)),
        ('size', sgqlc.types.Arg(Int, graphql_name='size', default=None)),
))
    )
    '''Direct queries for blast radius of incident

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    * `lookback` (`LookbackRange!`): The lookback period for the blast
      radius [ONE_HOUR, TWELVE_HOUR, ONE_DAY, SEVEN_DAY]
    * `after_key` (`UserAfterKeyInput2`): The key for pagination
    * `size` (`Int`): The max number of results to fetch
    '''

    get_incident_tables = sgqlc.types.Field(IncidentTableMcons, graphql_name='getIncidentTables', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
))
    )
    '''The MCONS directly impacted by the incident

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    '''

    get_incident_warehouse_tables = sgqlc.types.Field(sgqlc.types.list_of('WarehouseTable'), graphql_name='getIncidentWarehouseTables', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
))
    )
    '''The Warehouse Tables associated with an incident

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    '''

    get_direct_blast_radius_counts = sgqlc.types.Field(BlastRadiusCount, graphql_name='getDirectBlastRadiusCounts', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('lookback', sgqlc.types.Arg(sgqlc.types.non_null(LookbackRange), graphql_name='lookback', default=None)),
))
    )
    '''The aggregated counts for tables directly impacted by the incident

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    * `lookback` (`LookbackRange!`): The lookback period for the blast
      radius [ONE_HOUR, TWELVE_HOUR, ONE_DAY, SEVEN_DAY]
    '''

    get_blast_radius_direct_queries_for_user = sgqlc.types.Field(sgqlc.types.list_of(BlastRadiusUserQuery), graphql_name='getBlastRadiusDirectQueriesForUser', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('username', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='username', default=None)),
        ('lookback', sgqlc.types.Arg(sgqlc.types.non_null(LookbackRange), graphql_name='lookback', default=None)),
))
    )
    '''The queries for the lookback period provided for the given user

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    * `username` (`String!`): The username to get queries for
    * `lookback` (`LookbackRange!`): The lookback period for the blast
      radius [ONE_HOUR, TWELVE_HOUR, ONE_DAY, SEVEN_DAY]
    '''

    get_events = sgqlc.types.Field(EventConnection, graphql_name='getEvents', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('event_type', sgqlc.types.Arg(String, graphql_name='eventType', default=None)),
        ('event_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='eventTypes', default=None)),
        ('dataset', sgqlc.types.Arg(String, graphql_name='dataset', default=None)),
        ('tables_older_than_days', sgqlc.types.Arg(Int, graphql_name='tablesOlderThanDays', default=None)),
        ('event_states', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='eventStates', default=None)),
        ('exclude_state', sgqlc.types.Arg(String, graphql_name='excludeState', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('incident_id', sgqlc.types.Arg(UUID, graphql_name='incidentId', default=None)),
        ('include_timeline_events', sgqlc.types.Arg(Boolean, graphql_name='includeTimelineEvents', default=None)),
        ('include_anomaly_events', sgqlc.types.Arg(Boolean, graphql_name='includeAnomalyEvents', default=None)),
        ('desc_order', sgqlc.types.Arg(Boolean, graphql_name='descOrder', default=None)),
        ('monitor_id', sgqlc.types.Arg(UUID, graphql_name='monitorId', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get events (i.e. anomalies, changes, etc.) in my account

    Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    * `full_table_id` (`String`): Filter by the full table id (e.g.
      project:dataset.table)
    * `event_type` (`String`): Filter by the type of event
    * `event_types` (`[String]`): Filter by a list of types
    * `dataset` (`String`): Filter by the dataset
    * `tables_older_than_days` (`Int`): Filter for events based on
      table age
    * `event_states` (`[String]`): Filter by a list of states
    * `exclude_state` (`String`): Exclude a specific state
    * `start_time` (`DateTime`): Filter for events newer than this
    * `end_time` (`DateTime`): Filter for events older than this
    * `incident_id` (`UUID`): Filter by incident (grouping of related
      events)
    * `include_timeline_events` (`Boolean`): Flag that decides whether
      to include incident timeline related events. If event_types
      specified, this will be ignored.
    * `include_anomaly_events` (`Boolean`): Flag that decides whether
      to include anomaly timeline related events. If event_types
      sepcified, this will be ignored
    * `desc_order` (`Boolean`): Returns events in descending order of
      create_time
    * `monitor_id` (`UUID`): Filter by the UUID of the monitor or rule
      that generated the event
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_events_for_incidents = sgqlc.types.Field(EventConnection, graphql_name='getEventsForIncidents', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('event_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='eventTypes', default=None)),
        ('incident_end_time', sgqlc.types.Arg(DateTime, graphql_name='incidentEndTime', default=None)),
        ('incident_rule_id', sgqlc.types.Arg(UUID, graphql_name='incidentRuleId', default=None)),
        ('incident_full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='incidentFullTableIds', default=None)),
        ('desc_order', sgqlc.types.Arg(Boolean, graphql_name='descOrder', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get events by filtering on associated incident properties

    Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    * `domain_id` (`UUID`): Filter by domain UUID
    * `event_types` (`[String]`): Filter by a list of types
    * `incident_end_time` (`DateTime`): Filter for events belonging to
      incidents older than this time
    * `incident_rule_id` (`UUID`): Filter for events belonging to
      incidents that are associated with this custom rule UUID
    * `incident_full_table_ids` (`[String]`): Filter for events
      belonging to incidents associated with these full table ids
    * `desc_order` (`Boolean`): Returns events in descending order of
      create_time
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_comments_for_monitor_incidents = sgqlc.types.Field(EventConnection, graphql_name='getCommentsForMonitorIncidents', args=sgqlc.types.ArgDict((
        ('monitor_uuids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='monitorUuids', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get comments associated with incidents that have events created by
    the monitors

    Arguments:

    * `monitor_uuids` (`[UUID]`): Monitor uuids
    * `start_time` (`DateTime`): Filter for comments newer than this
    * `end_time` (`DateTime`): Filter for comments older than this
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_event = sgqlc.types.Field('Event', graphql_name='getEvent', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Arguments:

    * `uuid` (`UUID`)None
    '''

    get_event_comments = sgqlc.types.Field(EventCommentConnection, graphql_name='getEventComments', args=sgqlc.types.ArgDict((
        ('event_id', sgqlc.types.Arg(UUID, graphql_name='eventId', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `event_id` (`UUID`)None
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_event_type_summary = sgqlc.types.Field(EventTypeSummary, graphql_name='getEventTypeSummary', args=sgqlc.types.ArgDict((
        ('resource_id', sgqlc.types.Arg(UUID, graphql_name='resourceId', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
))
    )
    '''Arguments:

    * `resource_id` (`UUID`)None
    * `start_time` (`DateTime`)None
    * `end_time` (`DateTime`)None
    '''

    get_incidents = sgqlc.types.Field(IncidentConnection, graphql_name='getIncidents', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('incident_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='incidentTypes', default=None)),
        ('incident_sub_types', sgqlc.types.Arg(sgqlc.types.list_of(IncidentSubType), graphql_name='incidentSubTypes', default=None)),
        ('event_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='eventTypes', default=None)),
        ('event_states', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='eventStates', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('incident_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='incidentIds', default=None)),
        ('owners', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='owners', default=None)),
        ('severities', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='severities', default=None)),
        ('include_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='includeFeedback', default=None)),
        ('exclude_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='excludeFeedback', default=None)),
        ('projects', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='projects', default=None)),
        ('datasets', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='datasets', default=None)),
        ('tables', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tables', default=None)),
        ('full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='fullTableIds', default=None)),
        ('include_timeline_events', sgqlc.types.Arg(Boolean, graphql_name='includeTimelineEvents', default=None)),
        ('include_anomaly_events', sgqlc.types.Arg(Boolean, graphql_name='includeAnomalyEvents', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('monitor_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='monitorIds', default=None)),
        ('reaction_types', sgqlc.types.Arg(sgqlc.types.list_of(IncidentReactionType), graphql_name='reactionTypes', default=None)),
        ('rule_id', sgqlc.types.Arg(UUID, graphql_name='ruleId', default=None)),
        ('tag_key_value_pairs', sgqlc.types.Arg(sgqlc.types.list_of(TagKeyValuePairInput), graphql_name='tagKeyValuePairs', default=None)),
        ('tag_key_values', sgqlc.types.Arg(sgqlc.types.list_of(TagPair), graphql_name='tagKeyValues', default=None)),
        ('tag_keys', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tagKeys', default=None)),
        ('min_event_count', sgqlc.types.Arg(Int, graphql_name='minEventCount', default=None)),
        ('max_event_count', sgqlc.types.Arg(Int, graphql_name='maxEventCount', default=None)),
        ('contains_key_asset', sgqlc.types.Arg(Boolean, graphql_name='containsKeyAsset', default=None)),
        ('include_normalized', sgqlc.types.Arg(Boolean, graphql_name='includeNormalized', default=None)),
        ('has_jira_tickets', sgqlc.types.Arg(Boolean, graphql_name='hasJiraTickets', default=None)),
        ('has_servicenow_incidents', sgqlc.types.Arg(Boolean, graphql_name='hasServicenowIncidents', default=None)),
        ('job_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='jobMcons', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
))
    )
    '''Get incidents (i.e. a collection of related events) in my account

    Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    * `incident_types` (`[String]`): Filter by type of incident (e.g.
      anomalies)
    * `incident_sub_types` (`[IncidentSubType]`): Filter by incident
      sub type (e.g. freshness_anomaly)
    * `event_types` (`[String]`): Filter by type of event as an
      incident can have multiple event types
    * `event_states` (`[String]`): Filter by the state individual
      events are in
    * `start_time` (`DateTime`): Filter for incidents newer than this
    * `end_time` (`DateTime`): Filter for incidents older than this
    * `incident_ids` (`[UUID]`): Filter for specific incidents
    * `owners` (`[String]`): Filter for specific owners
    * `severities` (`[String]`): Filter for specific severities
    * `include_feedback` (`[String]`): Filter by user feedback
    * `exclude_feedback` (`[String]`): Exclude by user feedback
    * `projects` (`[String]`): Filter by projects
    * `datasets` (`[String]`): Filter by datasets
    * `tables` (`[String]`): Filter by tables
    * `full_table_ids` (`[String]`): Filter by full table ids
    * `include_timeline_events` (`Boolean`): Flag decides whether to
      include timeline events or not. By default it's false. If
      event_types field set, this will be ignored too.
    * `include_anomaly_events` (`Boolean`): Flag decides whether to
      include anomaly events or not. By default it's false. If
      event_types field set, this will be ignored too.
    * `domain_id` (`UUID`): Filter by domain UUID
    * `monitor_ids` (`[UUID]`): Filter for specific monitors
    * `reaction_types` (`[IncidentReactionType]`): Filter for specific
      reaction types
    * `rule_id` (`UUID`): Filter by custom rule UUID
    * `tag_key_value_pairs` (`[TagKeyValuePairInput]`): Filter by tag
      key values
    * `tag_key_values` (`[TagPair]`): (Deprecated, use
      `tag_key_value_pairs` instead) Filter by tag key values
    * `tag_keys` (`[String]`): (Deprecated, use `tag_key_value_pairs`
      instead) Filter by tag keys
    * `min_event_count` (`Int`): Filter to incidents with at least
      this many events
    * `max_event_count` (`Int`): Filter to incidents with at most this
      many events
    * `contains_key_asset` (`Boolean`): If true, filter to incidents
      containining a key asset
    * `include_normalized` (`Boolean`): If false, filter out
      normalized events.
    * `has_jira_tickets` (`Boolean`): If false, include incidents
      without jira tickets. If true, include incidents with jira
      tickets. If null, return all incidents.
    * `has_servicenow_incidents` (`Boolean`): If false, include
      incidents without ServiceNow incidents. If true, include
      incidents with ServiceNow incidents. If null, return all
      incidents.
    * `job_mcons` (`[String]`): If provided, filter incidents by job
      mcons
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `order_by` (`String`): Ordering
    '''

    get_incidents_filters = sgqlc.types.Field(sgqlc.types.list_of(IncidentsFilter), graphql_name='getIncidentsFilters')
    '''Filters that can be applied when requesting for a list of
    incidents
    '''

    get_incidents_filters_data = sgqlc.types.Field(sgqlc.types.list_of(IncidentsFilterData), graphql_name='getIncidentsFiltersData', args=sgqlc.types.ArgDict((
        ('request', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(IncidentsFilterDataRequestType)), graphql_name='request', default=None)),
))
    )
    '''Get possible values for incident filters

    Arguments:

    * `request` (`[IncidentsFilterDataRequestType]!`)None
    '''

    get_incident_reaction = sgqlc.types.Field('IncidentReaction', graphql_name='getIncidentReaction', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(UUID, graphql_name='incidentId', default=None)),
))
    )
    '''Arguments:

    * `incident_id` (`UUID`)None
    '''

    get_incident_summaries = sgqlc.types.Field(sgqlc.types.list_of(IncidentSummary), graphql_name='getIncidentSummaries', args=sgqlc.types.ArgDict((
        ('incident_ids', sgqlc.types.Arg(sgqlc.types.list_of(UUID), graphql_name='incidentIds', default=None)),
))
    )
    '''Arguments:

    * `incident_ids` (`[UUID]`)None
    '''

    get_incident_type_summary = sgqlc.types.Field(IncidentTypeSummary, graphql_name='getIncidentTypeSummary', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
))
    )
    '''Get a summary of counts by type for incidents in the account

    Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    * `start_time` (`DateTime`): Filter for incidents newer than this
    * `end_time` (`DateTime`): Filter for incidents older than this
    * `domain_id` (`UUID`): Filter by domain UUID
    '''

    get_incident_notification_settings_used = sgqlc.types.Field(sgqlc.types.list_of(AccountNotificationSetting), graphql_name='getIncidentNotificationSettingsUsed', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
))
    )
    '''The notification settings that were used to send notifications for
    the incident

    Arguments:

    * `incident_id` (`UUID!`): The incident UUID
    '''

    get_slack_messages_for_incident = sgqlc.types.Field(sgqlc.types.list_of('SlackMessageDetails'), graphql_name='getSlackMessagesForIncident', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
))
    )
    '''Arguments:

    * `incident_id` (`UUID!`): Filter by incident id
    '''

    get_slack_engagements_for_incident = sgqlc.types.Field(sgqlc.types.list_of('SlackEngagement'), graphql_name='getSlackEngagementsForIncident', args=sgqlc.types.ArgDict((
        ('incident_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='incidentId', default=None)),
        ('event_types', sgqlc.types.Arg(sgqlc.types.list_of(SlackEngagementEventType), graphql_name='eventTypes', default=None)),
        ('exclude_bot_engagements', sgqlc.types.Arg(Boolean, graphql_name='excludeBotEngagements', default=None)),
))
    )
    '''Arguments:

    * `incident_id` (`UUID!`): Filter by incident id
    * `event_types` (`[SlackEngagementEventType]`): Filter by
      event_type (e.g. thread_reply, reaction_added)
    * `exclude_bot_engagements` (`Boolean`): Exclude bot engagements
    '''

    get_slack_engagements_for_incidents = sgqlc.types.Field('SlackEngagementConnection', graphql_name='getSlackEngagementsForIncidents', args=sgqlc.types.ArgDict((
        ('event_types', sgqlc.types.Arg(sgqlc.types.list_of(SlackEngagementEventType), graphql_name='eventTypes', default=None)),
        ('exclude_bot_engagements', sgqlc.types.Arg(Boolean, graphql_name='excludeBotEngagements', default=None)),
        ('incident_domain_id', sgqlc.types.Arg(UUID, graphql_name='incidentDomainId', default=None)),
        ('incident_dw_id', sgqlc.types.Arg(UUID, graphql_name='incidentDwId', default=None)),
        ('incident_full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='incidentFullTableIds', default=None)),
        ('incident_rule_id', sgqlc.types.Arg(UUID, graphql_name='incidentRuleId', default=None)),
        ('incident_end_time', sgqlc.types.Arg(DateTime, graphql_name='incidentEndTime', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get slack engagements by filtering on the associated incident's
    properties

    Arguments:

    * `event_types` (`[SlackEngagementEventType]`): Filter by
      event_type (e.g. thread_reply, reaction_added)
    * `exclude_bot_engagements` (`Boolean`): Exclude bot engagements
    * `incident_domain_id` (`UUID`): Filter by domain UUID
    * `incident_dw_id` (`UUID`): Filter by incidents from a specific
      warehouse
    * `incident_full_table_ids` (`[String]`): Filter by incidents
      associated with list of full table ids (e.g.
      project:dataset.table)
    * `incident_rule_id` (`UUID`): Filter by incidents associated with
      a custom rule UUID
    * `incident_end_time` (`DateTime`): Filter by incidents older than
      this time
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_all_domains = sgqlc.types.Field(sgqlc.types.list_of(DomainOutput), graphql_name='getAllDomains')
    '''Get all available domains'''

    get_domain = sgqlc.types.Field(DomainOutput, graphql_name='getDomain', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='uuid', default=None)),
))
    )
    '''Get domain by id

    Arguments:

    * `uuid` (`UUID!`): Domain UUID
    '''

    get_account_roles = sgqlc.types.Field(sgqlc.types.list_of('RoleOutput'), graphql_name='getAccountRoles')
    '''Get roles available for current user's account.'''

    get_authorization_groups = sgqlc.types.Field(sgqlc.types.list_of(AuthorizationGroupOutput), graphql_name='getAuthorizationGroups')
    '''Get authorization group list for the user's account.'''

    get_user_authorization = sgqlc.types.Field('UserAuthorizationOutput', graphql_name='getUserAuthorization')
    '''Get resolved authorization info for the user.'''

    search = sgqlc.types.Field('SearchResponse', graphql_name='search', args=sgqlc.types.ArgDict((
        ('object_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='objectTypes', default=None)),
        ('ignore_object_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='ignoreObjectTypes', default=None)),
        ('query', sgqlc.types.Arg(String, graphql_name='query', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=0)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=50)),
        ('full_results', sgqlc.types.Arg(Boolean, graphql_name='fullResults', default=True)),
        ('operator', sgqlc.types.Arg(String, graphql_name='operator', default='OR')),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('parent_mcon', sgqlc.types.Arg(String, graphql_name='parentMcon', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('tags_only', sgqlc.types.Arg(Boolean, graphql_name='tagsOnly', default=False)),
        ('include_facet_types', sgqlc.types.Arg(sgqlc.types.list_of(FacetType), graphql_name='includeFacetTypes', default=None)),
        ('facet_results_limit', sgqlc.types.Arg(Int, graphql_name='facetResultsLimit', default=10)),
        ('tags', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tags', default=None)),
        ('tag_name_query', sgqlc.types.Arg(String, graphql_name='tagNameQuery', default=None)),
        ('tag_value_query', sgqlc.types.Arg(String, graphql_name='tagValueQuery', default=None)),
        ('resource_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='resourceIds', default=None)),
        ('tag_filters', sgqlc.types.Arg(sgqlc.types.list_of(TagFilterInput), graphql_name='tagFilters', default=None)),
        ('monitor_type', sgqlc.types.Arg(String, graphql_name='monitorType', default=None)),
))
    )
    '''Search catalog for an entity

    Arguments:

    * `object_types` (`[String]`): Filter by object type (e.g. table,
      view, etc.)
    * `ignore_object_types` (`[String]`): Filter out by object type
    * `query` (`String`): Entity to search for
    * `offset` (`Int`): Offset when paging (default: `0`)
    * `limit` (`Int`): Max results (default: `50`)
    * `full_results` (`Boolean`): Full search mode, used to search all
      available fields, not just display_name (default: `true`)
    * `operator` (`String`): Search operator to use, either OR or AND
      (DEPRECATED) (default: `"OR"`)
    * `mcon` (`String`): Filter on mcon
    * `parent_mcon` (`String`): Filter on parent_mcon
    * `domain_id` (`UUID`): Filter by domain UUID
    * `tags_only` (`Boolean`): Search only tags and descriptions (no
      display_name) (default: `false`)
    * `include_facet_types` (`[FacetType]`): Facet types to include
      (tags, tag_names, tag_values)
    * `facet_results_limit` (`Int`): Facet results limit (default:
      `10`)
    * `tags` (`[String]`): Filter by tags (DEPRECATED, use tagFilters)
    * `tag_name_query` (`String`): Query tag names (DEPRECATED)
    * `tag_value_query` (`String`): Query tag values (DEPRECATED)
    * `resource_ids` (`[String]`): Filter by resource ID
    * `tag_filters` (`[TagFilterInput]`): List of tag filters
    * `monitor_type` (`String`): Exclude from results objects that do
      not support this monitor type
    '''

    get_object = sgqlc.types.Field(ObjectDocument, graphql_name='getObject', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
))
    )
    '''Arguments:

    * `mcon` (`String`)None
    '''

    get_metadata = sgqlc.types.Field(sgqlc.types.list_of(ObjectDocument), graphql_name='getMetadata', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
))
    )
    '''Arguments:

    * `mcons` (`[String]`)None
    '''

    get_metrics_v3 = sgqlc.types.Field(Metrics, graphql_name='getMetricsV3', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('metric', sgqlc.types.Arg(String, graphql_name='metric', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('field', sgqlc.types.Arg(String, graphql_name='field', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('dimension_filters', sgqlc.types.Arg(sgqlc.types.list_of(MetricDimensionFilter), graphql_name='dimensionFilters', default=None)),
))
    )
    '''Retrieves field-level metric values in a given time range AND in a
    given measurement time range

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Mcon for table to get details for
    * `metric` (`String`): Type of metric (e.g. row_count)
    * `start_time` (`DateTime`): Filter for data newer than this
    * `field` (`String`): Filter by a specific field
    * `end_time` (`DateTime`): Filter for data older than this
    * `first` (`Int`): Number of metrics to retrieve
    * `dimension_filters` (`[MetricDimensionFilter]`): Filter by a
      list of key/value dimension pairs
    '''

    get_metrics_v4 = sgqlc.types.Field(Metrics, graphql_name='getMetricsV4', args=sgqlc.types.ArgDict((
        ('metric_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='metricName', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('metrics_filter', sgqlc.types.Arg(sgqlc.types.non_null(MetricsFilter), graphql_name='metricsFilter', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
))
    )
    '''Retrieves metric data points by time range and filters

    Arguments:

    * `metric_name` (`String!`): Name of the metric
    * `start_time` (`DateTime!`): Filter for data newer than this
    * `end_time` (`DateTime`): Filter for data older than this.
      Defaults to current time.
    * `metrics_filter` (`MetricsFilter!`): Filters for the metrics to
      be fetched
    * `first` (`Int`): Number of data points to retrieve. Defaults to
      5000.
    '''

    get_table_monitor_details = sgqlc.types.Field(sgqlc.types.list_of('TableMonitorDetail'), graphql_name='getTableMonitorDetails', args=sgqlc.types.ArgDict((
        ('table_mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='tableMcon', default=None)),
        ('table_monitor_type', sgqlc.types.Arg(sgqlc.types.non_null(TableMonitorType), graphql_name='tableMonitorType', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
))
    )
    '''Retrieve all table-level monitors of a given type for a table and
    the details of those monitors, such as the count of incidents
    associated with them.

    Arguments:

    * `table_mcon` (`String!`): MCON of the table.
    * `table_monitor_type` (`TableMonitorType!`): The type of monitor
      being queried.
    * `start_time` (`DateTime!`): Count incidents for the monitor
      created on or after this time.
    * `end_time` (`DateTime`): Count incidents for the monitor created
      on or before this time. Defaults to current time.
    '''

    get_table_fields_monitor_details = sgqlc.types.Field('TableFieldMonitorDetails', graphql_name='getTableFieldsMonitorDetails', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('table_mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='tableMcon', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('field_search_pattern', sgqlc.types.Arg(String, graphql_name='fieldSearchPattern', default=None)),
))
    )
    '''Retrieve all field-level monitors for a table and the details of
    those monitors, such as the count of incidents associated with
    them.

    Arguments:

    * `first` (`Int`): When paging forward: the number of items to
      return (page size)
    * `after` (`String`): When paging forward: the cursor of the last
      item on the previous page of results
    * `last` (`Int`): When paging backward: the number of items to
      return (page size)
    * `before` (`String`): When paging backward: the cursor of the
      first item on the next page of results
    * `table_mcon` (`String!`): MCON of the table.
    * `start_time` (`DateTime!`): Count incidents for the monitor
      created on or after this time.
    * `end_time` (`DateTime`): Count incidents for the monitor created
      on or before this time. Defaults to current time.
    * `field_search_pattern` (`String`): Pattern to substring-match
      with field name.
    '''

    get_non_table_metrics = sgqlc.types.Field(NonTableMetrics, graphql_name='getNonTableMetrics', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('metric', sgqlc.types.Arg(String, graphql_name='metric', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('dimension_filters', sgqlc.types.Arg(sgqlc.types.list_of(MetricDimensionFilter), graphql_name='dimensionFilters', default=None)),
))
    )
    '''Retrieves metric values in a given time range AND in a given
    measurement time range

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in
    * `mcon` (`String`): the mcon associated with the metric
    * `metric` (`String`): Type of metric (e.g. row_count)
    * `start_time` (`DateTime`): Filter for data newer than this
    * `end_time` (`DateTime`): Filter for data older than this
    * `first` (`Int`): Number of metrics to retrieve
    * `dimension_filters` (`[MetricDimensionFilter]`): Filter by a
      list of key/value dimension pairs
    '''

    get_aggregated_metrics = sgqlc.types.Field(Metrics, graphql_name='getAggregatedMetrics', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('full_table_id_list', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='fullTableIdList', default=None)),
        ('metric', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='metric', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('date_aggregation_bucket_size', sgqlc.types.Arg(String, graphql_name='dateAggregationBucketSize', default='day')),
))
    )
    '''Retrieves field-level metric values in a given time range AND in a
    given measurement time range

    Arguments:

    * `dw_id` (`UUID!`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id_list` (`[String]!`): Full table ID
    * `metric` (`String!`): Type of metric
    * `start_time` (`DateTime`): Filter for data newer than this
    * `end_time` (`DateTime`): Filter for data older than this
    * `date_aggregation_bucket_size` (`String`)None (default: `"day"`)
    '''

    get_latest_table_access_timestamp_metrics = sgqlc.types.Field(Metrics, graphql_name='getLatestTableAccessTimestampMetrics', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('full_table_id_list', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='fullTableIdList', default=None)),
        ('metric', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='metric', default=None)),
))
    )
    '''Retrieves field-level metric values in a given time range AND in a
    given measurement time range

    Arguments:

    * `dw_id` (`UUID!`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id_list` (`[String]!`): Full table ID
    * `metric` (`String!`): Type of metric
    '''

    get_top_category_labels = sgqlc.types.Field(sgqlc.types.list_of(CategoryLabelRank), graphql_name='getTopCategoryLabels', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('monitor_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='monitorIds', default=None)),
        ('field', sgqlc.types.Arg(String, graphql_name='field', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
))
    )
    '''Get the top distribution labels. For use in
    getFirstSeenDimensionsByLabels

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Mcon for table to get details for
    * `monitor_ids` (`[String]`): Filter results by monitor ID
    * `field` (`String`): Field (column) to get labels for
    * `start_time` (`DateTime`): Filter for data newer than this
    * `limit` (`Int`): Limit results retrieved
    * `end_time` (`DateTime`): Filter for data older than this
    '''

    get_segmented_where_condition_labels = sgqlc.types.Field(sgqlc.types.list_of('WhereConditionSegments'), graphql_name='getSegmentedWhereConditionLabels', args=sgqlc.types.ArgDict((
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('warehouse_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='warehouseUuid', default=None)),
        ('full_table_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='fullTableId', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
))
    )
    '''Get top segmented where_conditions for monitor of sub-type
    segmented

    Arguments:

    * `monitor_uuid` (`UUID!`): The monitor for which to locate labels
    * `warehouse_uuid` (`UUID!`): The warehouse uuid the monitor is
      being run on
    * `full_table_id` (`String!`): The table being monitored
    * `start_time` (`DateTime`): Filter for labels from this date. If
      not provided, use monitor creation time.
    * `end_time` (`DateTime`): Filter for labels until and including
      this date
    '''

    get_first_seen_dimensions_by_labels = sgqlc.types.Field(sgqlc.types.list_of(DimensionLabel), graphql_name='getFirstSeenDimensionsByLabels', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('field', sgqlc.types.Arg(String, graphql_name='field', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('dimensions_filter', sgqlc.types.Arg(sgqlc.types.list_of(MetricDimensionFilter), graphql_name='dimensionsFilter', default=None)),
))
    )
    '''Get the first measurements of the provided labels across a time
    range

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Mcon for table to get details for
    * `field` (`String`): Field (column) to get measurements for
    * `labels` (`[String]`): Labels to get measurements for. Can be
      retrieved using getFirstSeenDimensionsByLabels
    * `start_time` (`DateTime`): Filter for data newer than this
    * `end_time` (`DateTime`): Filter for data older than this
    * `dimensions_filter` (`[MetricDimensionFilter]`): Filter by a
      list of key/value dimension pairs
    '''

    get_first_and_last_seen_dimensions_by_labels = sgqlc.types.Field(sgqlc.types.list_of(DimensionLabelList), graphql_name='getFirstAndLastSeenDimensionsByLabels', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('field', sgqlc.types.Arg(String, graphql_name='field', default=None)),
        ('labels', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='labels', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('dimensions_filter', sgqlc.types.Arg(sgqlc.types.list_of(MetricDimensionFilter), graphql_name='dimensionsFilter', default=None)),
))
    )
    '''Get the first and last measurements per timestamp of the provided
    labels across a time range

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Mcon for table to get details for
    * `field` (`String`): Field (column) to get measurements for
    * `labels` (`[String]`): Labels to get measurements for. Can be
      retrieved using getFirstSeenDimensionsByLabels
    * `start_time` (`DateTime`): Filter for data newer than this
    * `end_time` (`DateTime`): Filter for data older than this
    * `dimensions_filter` (`[MetricDimensionFilter]`): Filter by a
      list of key/value dimension pairs
    '''

    get_downstream_bi = sgqlc.types.Field(sgqlc.types.list_of(DownstreamBI), graphql_name='getDownstreamBi', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('node_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='nodeIds', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
))
    )
    '''Arguments:

    * `dw_id` (`UUID`)None
    * `node_ids` (`[String]`)None
    * `start_time` (`DateTime`)None
    * `end_time` (`DateTime`)None
    '''

    get_downstream_impact_radius_summary = sgqlc.types.Field(DownstreamImpactRadiusSummary, graphql_name='getDownstreamImpactRadiusSummary', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='mcons', default=None)),
))
    )
    '''Arguments:

    * `mcons` (`[String]!`): List of MCONs where each MCON identifies
      a table whose downstream reports are being queried.
    '''

    get_downstream_reports = sgqlc.types.Field(DownstreamReports, graphql_name='getDownstreamReports', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='mcons', default=None)),
        ('name_matcher', sgqlc.types.Arg(String, graphql_name='nameMatcher', default=None)),
        ('report_types', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='reportTypes', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('sort_by', sgqlc.types.Arg(String, graphql_name='sortBy', default=None)),
        ('sort_desc', sgqlc.types.Arg(Boolean, graphql_name='sortDesc', default=None)),
))
    )
    '''Gets downstream reports for a list of tables.

    Arguments:

    * `mcons` (`[String]!`): List of MCONs where each MCON identifies
      a table whose downstream reports are being queried.
    * `name_matcher` (`String`): A string to filter names by
      performing substring match.
    * `report_types` (`[String]`): Report types to query.
    * `limit` (`Int`): Limit results returned
    * `offset` (`Int`): Offset when paging
    * `sort_by` (`String`): Sort by property: [last_updated, owner_id,
      display_name, type, importance_score]
    * `sort_desc` (`Boolean`): Sort in descending order
    '''

    get_downstream_report_owners = sgqlc.types.Field(DownstreamReportOwners, graphql_name='getDownstreamReportOwners', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='mcons', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
))
    )
    '''Gets owners of downstream reports for a list of tables.

    Arguments:

    * `mcons` (`[String]!`): List of MCONs where each MCON identifies
      a table whose downstream report owners are being queried.
    * `limit` (`Int`): Limit results returned
    * `offset` (`Int`): Offset when paging
    '''

    get_downstream_report_types = sgqlc.types.Field(DownstreamReportTypes, graphql_name='getDownstreamReportTypes', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
))
    )
    '''Gets all report types of downstream reports for a table.

    Arguments:

    * `mcon` (`String`): MCON of the table whose downstream reports
      are being queried.
    * `mcons` (`[String]`): List of MCONs of the tables whose
      downstream reports are being queried.
    '''

    get_table_lineage = sgqlc.types.Field(LineageGraph, graphql_name='getTableLineage', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('direction', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='direction', default=None)),
        ('hops', sgqlc.types.Arg(Int, graphql_name='hops', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
))
    )
    '''Gets the lineage for a table up to specified number of hops in the
    lineage graph.

    Arguments:

    * `mcon` (`String`): MCON of the table whose lineage is being
      queried. Must provide either mcon or mcons.
    * `mcons` (`[String]`): MCONs of the tables whose lineage is being
      queried to a maximum of 20. Must provide either mcons or mcon.
    * `direction` (`String!`): This can be either 'upstream' or
      'downstream' based on the direction in which to traverse the
      lineage graph
    * `hops` (`Int`): The number of hops to query in the lineage
      graph. Defaults to 1.
    * `start_time` (`DateTime`): Filter for lineage data newer than
      this. Defaults to no date filtering.
    * `end_time` (`DateTime`): Filter for lineage data older than
      this. Defaults to no date filtering.
    '''

    get_connected_table_lineage = sgqlc.types.Field(sgqlc.types.list_of(ConnectedLineageGraphNode), graphql_name='getConnectedTableLineage', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='mcons', default=None)),
))
    )
    '''Get mcon and and directly connected mcons

    Arguments:

    * `mcons` (`[String]!`)None
    '''

    get_connected_table_lineage_with_jobs = sgqlc.types.Field(ConnectedLineageGraphNodeWithJobs, graphql_name='getConnectedTableLineageWithJobs', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='mcons', default=None)),
        ('direction', sgqlc.types.Arg(LineageGraphTraversalDirection, graphql_name='direction', default=None)),
        ('hops', sgqlc.types.Arg(Int, graphql_name='hops', default=None)),
))
    )
    '''Get mcon and and directly connected mcons with job data

    Arguments:

    * `mcons` (`[String]!`)None
    * `direction` (`LineageGraphTraversalDirection`): This can be
      either 'upstream' or 'downstream' or 'both' based on the
      direction in which to traverse the lineage graph. Default to
      'both'.
    * `hops` (`Int`): The number of hops to query in the lineage
      graph. Defaults to 1.
    '''

    get_external_source_paths_sample = sgqlc.types.Field('TableSourceSample', graphql_name='getExternalSourcePathsSample', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('max_results', sgqlc.types.Arg(Int, graphql_name='maxResults', default=20)),
))
    )
    '''Gets sample of table sources, typically external files

    Arguments:

    * `mcon` (`String!`)None
    * `max_results` (`Int`)None (default: `20`)
    '''

    get_tableau_workbook_count = sgqlc.types.Field('TableauWorkbookCount', graphql_name='getTableauWorkbookCount', args=sgqlc.types.ArgDict((
        ('bi_container_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='biContainerId', default=None)),
))
    )
    '''Gets the number of workbooks in a Tableau instance.

    Arguments:

    * `bi_container_id` (`UUID!`): Monte Carlo UUID of the Tableau BI
      container
    '''

    get_query_list = sgqlc.types.Field(sgqlc.types.list_of('QueryListResponse'), graphql_name='getQueryList', args=sgqlc.types.ArgDict((
        ('query_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='queryType', default=None)),
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='endTime', default=None)),
        ('user_name', sgqlc.types.Arg(String, graphql_name='userName', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
))
    )
    '''Gets the queries on this table according to query type

    Arguments:

    * `query_type` (`String!`): source (reads on the table) or
      destination (writes on this table)
    * `mcon` (`String!`): Monte Carlo object name
    * `start_time` (`DateTime!`): Filter for queries newer than this
    * `end_time` (`DateTime!`): Filter for queries older than this
    * `user_name` (`String`): Filter by user name
    * `limit` (`Int`): Limit results returned
    * `offset` (`Int`): Offset when paging
    '''

    get_query_by_id = sgqlc.types.Field(sgqlc.types.list_of('QueryDataObject'), graphql_name='getQueryById', args=sgqlc.types.ArgDict((
        ('query_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='queryId', default=None)),
        ('timestamp', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='timestamp', default=None)),
        ('query_format', sgqlc.types.Arg(String, graphql_name='queryFormat', default=None)),
))
    )
    '''Gets the query by query ID

    Arguments:

    * `query_id` (`String!`): Query unique identifier
    * `timestamp` (`DateTime!`): Query execution time (can be reduced
      to day on which it ran)
    * `query_format` (`String`): 'raw' or 'base64' format
    '''

    get_query_by_query_hash = sgqlc.types.Field(sgqlc.types.list_of('QueryDataObject'), graphql_name='getQueryByQueryHash', args=sgqlc.types.ArgDict((
        ('query_hash', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='queryHash', default=None)),
        ('day', sgqlc.types.Arg(sgqlc.types.non_null(Date), graphql_name='day', default=None)),
        ('query_format', sgqlc.types.Arg(String, graphql_name='queryFormat', default=None)),
))
    )
    '''Gets the query by query hash

    Arguments:

    * `query_hash` (`String!`): The query_hash for which to fetch
      query data
    * `day` (`Date!`): The day on which the query ran
    * `query_format` (`String`): 'raw' or 'base64' format
    '''

    get_query_data_by_query_hash = sgqlc.types.Field(sgqlc.types.list_of('QueryLogResponse'), graphql_name='getQueryDataByQueryHash', args=sgqlc.types.ArgDict((
        ('query_hash', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='queryHash', default=None)),
        ('day', sgqlc.types.Arg(sgqlc.types.non_null(Date), graphql_name='day', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
))
    )
    '''Fetch query metadata for a single query for all daily occurrences

    Arguments:

    * `query_hash` (`String!`): The query_hash for which to fetch the
      queries
    * `day` (`Date!`): The day for which to fetch the query metadata
    * `limit` (`Int`): Limit results returned
    * `offset` (`Int`): Offset when paging
    '''

    get_query_data = sgqlc.types.Field(sgqlc.types.list_of('QueryLogResponse'), graphql_name='getQueryData', args=sgqlc.types.ArgDict((
        ('query_id', sgqlc.types.Arg(String, graphql_name='queryId', default=None)),
        ('query_hash', sgqlc.types.Arg(String, graphql_name='queryHash', default=None)),
        ('day', sgqlc.types.Arg(sgqlc.types.non_null(Date), graphql_name='day', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('group_id', sgqlc.types.Arg(String, graphql_name='groupId', default=None)),
))
    )
    '''Fetch query metadata for a single query for all daily occurrences

    Arguments:

    * `query_id` (`String`): The query_id for which to fetch the
      queries
    * `query_hash` (`String`): The query_hash for which to fetch the
      queries
    * `day` (`Date!`): The day for which to fetch the query metadata
    * `limit` (`Int`): Limit results returned
    * `offset` (`Int`): Offset when paging
    * `group_id` (`String`): Fetch queries that share the same
      group_id
    '''

    get_query_log_hashes_that_affect_these_tables = sgqlc.types.Field(sgqlc.types.list_of('QueryLogHashes'), graphql_name='getQueryLogHashesThatAffectTheseTables', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='fullTableIds', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('users', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='users', default=None)),
        ('query_characters', sgqlc.types.Arg(Int, graphql_name='queryCharacters', default=None)),
))
    )
    '''Get query log aggregates (AKA updates to these tables)

    Arguments:

    * `dw_id` (`UUID`): Warehouse the tables are contained in.
      Required when using fullTableIds
    * `full_table_ids` (`[String]`): Deprecated - use mcons. Ignored
      if mcons are present
    * `mcons` (`[String]`): List of mcons to get details for
    * `limit` (`Int`): Limit results returned
    * `offset` (`Int`): Offset when paging
    * `start_time` (`DateTime`): Filter for queries newer than this
    * `end_time` (`DateTime`): Filter for queries older than this
    * `users` (`[String]`): List of users to get details for
    * `query_characters` (`Int`): The number of characters in the
      query to return
    '''

    get_query_log_hashes_on_these_tables = sgqlc.types.Field(sgqlc.types.list_of('QueryLogHashes'), graphql_name='getQueryLogHashesOnTheseTables', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='fullTableIds', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('users', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='users', default=None)),
        ('query_characters', sgqlc.types.Arg(Int, graphql_name='queryCharacters', default=None)),
))
    )
    '''Get query log aggregates (AKA queries on these tables)

    Arguments:

    * `dw_id` (`UUID`): Warehouse the tables are contained in.
      Required when using fullTableIds
    * `full_table_ids` (`[String]`): Deprecated - use mcons. Ignored
      if mcons are present
    * `mcons` (`[String]`): List of mcons to get details for
    * `limit` (`Int`): Limit results returned
    * `offset` (`Int`): Offset when paging
    * `start_time` (`DateTime`): Filter for queries newer than this
    * `end_time` (`DateTime`): Filter for queries older than this
    * `users` (`[String]`): List of users to get details for
    * `query_characters` (`Int`): The number of characters to return
      of the query
    '''

    get_related_users = sgqlc.types.Field(sgqlc.types.list_of('RelatedUserCount'), graphql_name='getRelatedUsers', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('query_type', sgqlc.types.Arg(String, graphql_name='queryType', default=None)),
))
    )
    '''Get users related to object

    Arguments:

    * `mcon` (`String!`): Monte Carlo object name
    * `start_time` (`DateTime`): Filter for queries newer than this.
      By default, endTime - 3 weeks
    * `end_time` (`DateTime`): Filter for queries older than this. By
      default, now
    * `query_type` (`String`): source (reads on the table) or
      destination (writes on this table)
    '''

    get_lineage_node_properties = sgqlc.types.Field(sgqlc.types.list_of(NodeProperties), graphql_name='getLineageNodeProperties', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('node_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='nodeIds', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
))
    )
    '''Get properties (metadata) from nodes (DEPRECATED, use GetMetadata
    instead!)

    Arguments:

    * `dw_id` (`UUID`): Warehouse the asset is contained within. Not
      required when using an mcon as node id
    * `node_ids` (`[String]`): Deprecated - use mcon. Ignored if mcon
      is present
    * `mcons` (`[String]`): List of mcons to get properties for
    '''

    get_digraph = sgqlc.types.Field(DirectedGraph, graphql_name='getDigraph', args=sgqlc.types.ArgDict((
        ('metadata_version', sgqlc.types.Arg(String, graphql_name='metadataVersion', default=None)),
))
    )
    '''Arguments:

    * `metadata_version` (`String`)None
    '''

    get_pipeline_freshness_v2 = sgqlc.types.Field(PipelineFreshness, graphql_name='getPipelineFreshnessV2', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='fullTableIds', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
))
    )
    '''Get latest freshness for multiple tables

    Arguments:

    * `dw_id` (`UUID`): Warehouse the tables are contained in.
      Required when using fullTableIds
    * `full_table_ids` (`[String]`): Deprecated - use mcons. Ignored
      if mcons are present
    * `mcons` (`[String]`): List of mcons to get details for
    * `start_time` (`DateTime`): Filter for data newer than this
    * `end_time` (`DateTime`): Filter for data older than this
    '''

    get_custom_sql_output_sample = sgqlc.types.Field(CustomSQLOutputSample, graphql_name='getCustomSqlOutputSample', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('job_execution_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='jobExecutionUuid', default=None)),
))
    )
    '''Retrieve output sample for custom SQL job execution

    Arguments:

    * `dw_id` (`UUID!`): Warehouse the custom SQL ran in
    * `job_execution_uuid` (`UUID!`): JobExecution to fetch the output
      sample for
    '''

    get_custom_sql_output_download = sgqlc.types.Field(CustomSQLOutputDownload, graphql_name='getCustomSqlOutputDownload', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
        ('custom_rule_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='customRuleUuid', default=None)),
))
    )
    '''Runs custom sql rule and returns a download link for all results.

    Arguments:

    * `dw_id` (`UUID!`): Warehouse the custom SQL ran in
    * `custom_rule_uuid` (`UUID!`): Custom rule to run
    '''

    get_metric_sampling = sgqlc.types.Field(MetricSampling, graphql_name='getMetricSampling', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('time_axis', sgqlc.types.Arg(String, graphql_name='timeAxis', default=None)),
        ('field', sgqlc.types.Arg(String, graphql_name='field', default=None)),
        ('metric', sgqlc.types.Arg(String, graphql_name='metric', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=False)),
        ('monitor_uuid', sgqlc.types.Arg(UUID, graphql_name='monitorUuid', default=None)),
))
    )
    '''Get sample rows for metrics

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Mcon for table to get details for
    * `time_axis` (`String`): Time field (column) to use when for date
      range
    * `field` (`String`): Field to sample for
    * `metric` (`String`): Type of metric to sample for
    * `start_time` (`DateTime`): Filter for data newer than this
    * `end_time` (`DateTime`): Filter for data older than this
    * `limit` (`Int`): Limit results
    * `dry_run` (`Boolean`): Generate sample query without running
      (default: `false`)
    * `monitor_uuid` (`UUID`): Monitor uuid is used for extracting an
      accurate time axis
    '''

    get_fh_sampling = sgqlc.types.Field(MetricSampling, graphql_name='getFhSampling', args=sgqlc.types.ArgDict((
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('event_created_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='eventCreatedTime', default=None)),
        ('field', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='field', default=None)),
        ('metric', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='metric', default=None)),
        ('dimension', sgqlc.types.Arg(String, graphql_name='dimension', default=None)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=True)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
))
    )
    '''Generates and/or runs a FH sampling query

    Arguments:

    * `monitor_uuid` (`UUID!`): Monitor uuid is used for creating the
      sampling query
    * `event_created_time` (`DateTime!`): When the anomaly occurred
    * `field` (`String!`): The field on which the anomaly was found
    * `metric` (`String!`): The metric which measured the anomaly
    * `dimension` (`String`): FH segment if segmented monitor
    * `dry_run` (`Boolean`): Generate sample query without running
      (default: `true`)
    * `limit` (`Int`): Limit results
    '''

    get_dt_sampling = sgqlc.types.Field(MetricSampling, graphql_name='getDtSampling', args=sgqlc.types.ArgDict((
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('dimension', sgqlc.types.Arg(String, graphql_name='dimension', default=None)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=False)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
))
    )
    '''Generates and/or runs a Dimension Tracking investigation query

    Arguments:

    * `monitor_uuid` (`UUID!`): Monitor uuid is used for creating the
      sampling query
    * `start_time` (`DateTime`): Event start time
    * `dimension` (`String`): FH segment if segmented monitor
    * `dry_run` (`Boolean`): Generate sample query without running
      (default: `false`)
    * `limit` (`Int`): Limit results
    '''

    get_fh_reproduction_query = sgqlc.types.Field(InvestigationQuery, graphql_name='getFhReproductionQuery', args=sgqlc.types.ArgDict((
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('event_created_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='eventCreatedTime', default=None)),
        ('field', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='field', default=None)),
        ('metric', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='metric', default=None)),
        ('dimension', sgqlc.types.Arg(String, graphql_name='dimension', default=None)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=True)),
))
    )
    '''Generates a SQL query that will reproduce the anomalous data on a
    table

    Arguments:

    * `monitor_uuid` (`UUID!`): UUID of the monitor on which the
      anomaly occurred
    * `event_created_time` (`DateTime!`): When the anomaly occurred
    * `field` (`String!`): The field on which the anomaly was found
    * `metric` (`String!`): The metric which measured the anomaly
    * `dimension` (`String`): FH segment if segmented monitor
    * `dry_run` (`Boolean`): Generate sample query without running
      (default: `true`)
    '''

    get_dt_reproduction_query = sgqlc.types.Field(InvestigationQuery, graphql_name='getDtReproductionQuery', args=sgqlc.types.ArgDict((
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('event_created_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='eventCreatedTime', default=None)),
        ('field', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='field', default=None)),
        ('field_val', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='fieldVal', default=None)),
        ('dimension', sgqlc.types.Arg(String, graphql_name='dimension', default=None)),
        ('dry_run', sgqlc.types.Arg(Boolean, graphql_name='dryRun', default=True)),
))
    )
    '''Generates a SQL query that will reproduce the anomalous data on a
    table

    Arguments:

    * `monitor_uuid` (`UUID!`): UUID of the monitor on which the
      anomaly occurred
    * `event_created_time` (`DateTime!`): When the anomaly occurred
    * `field` (`String!`): The field on which the anomaly was found
    * `field_val` (`String!`): The value for which the anomaly was
      found
    * `dimension` (`String`): FH segment if segmented monitor
    * `dry_run` (`Boolean`): Generate sample query without running
      (default: `true`)
    '''

    run_custom_query = sgqlc.types.Field('SQLResponse', graphql_name='runCustomQuery', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('query', sgqlc.types.Arg(String, graphql_name='query', default=None)),
        ('variables', sgqlc.types.Arg(JSONString, graphql_name='variables', default=None)),
        ('query_result_type', sgqlc.types.Arg(QueryResultType, graphql_name='queryResultType', default=None)),
))
    )
    '''Arguments:

    * `dw_id` (`UUID`)None
    * `query` (`String`)None
    * `variables` (`JSONString`)None
    * `query_result_type` (`QueryResultType`): How the query result is
      used for the metric. Uses row count if unset.
    '''

    test_sql_query_part = sgqlc.types.Field('SQLResponse', graphql_name='testSqlQueryPart', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('query_part', sgqlc.types.Arg(String, graphql_name='queryPart', default=None)),
))
    )
    '''Test part of query

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Mcon for table to get details for
    * `query_part` (`String`): Part of query (e.g. select options)
    '''

    test_sql_query_where_expression = sgqlc.types.Field('SQLResponse', graphql_name='testSqlQueryWhereExpression', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('where_expression', sgqlc.types.Arg(String, graphql_name='whereExpression', default=None)),
))
    )
    '''Test WHERE expression

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Mcon for table to get details for
    * `where_expression` (`String`): body of the where expression
      (without WHERE prefix)
    '''

    get_table_stats_v2 = sgqlc.types.Field('TableStatsV2', graphql_name='getTableStatsV2', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('parent_mcon', sgqlc.types.Arg(String, graphql_name='parentMcon', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
))
    )
    '''Arguments:

    * `first` (`Int`): When paging forward: the number of items to
      return (page size)
    * `after` (`String`): When paging forward: the cursor of the last
      item on the previous page of results
    * `last` (`Int`): When paging backward: the number of items to
      return (page size)
    * `before` (`String`): When paging backward: the cursor of the
      first item on the next page of results
    * `parent_mcon` (`String`): Filter stats for tables by root mcon
    * `domain_id` (`UUID`): Filter by domain UUID
    '''

    get_table_stats = sgqlc.types.Field('TableStatsConnection', graphql_name='getTableStats', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_ids', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='fullTableIds', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('parent_mcon', sgqlc.types.Arg(String, graphql_name='parentMcon', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Arguments:

    * `dw_id` (`UUID`): Filter by warehouse. Required when using a
      fullTableId
    * `full_table_ids` (`[String]`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcons` (`[String]`): Get stats for specific tables by mcon
    * `parent_mcon` (`String`): Filter stats for tables by parent mcon
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_resource = sgqlc.types.Field('Resource', graphql_name='getResource', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
        ('name', sgqlc.types.Arg(String, graphql_name='name', default=None)),
))
    )
    '''Retrieve a specific resource

    Arguments:

    * `uuid` (`UUID`): The resource id
    * `name` (`String`): The resource name
    '''

    get_resources = sgqlc.types.Field(sgqlc.types.list_of('Resource'), graphql_name='getResources')
    '''Retrieve all resources in an account'''

    get_table_fields_importance = sgqlc.types.Field('TableFieldsImportance', graphql_name='getTableFieldsImportance', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
        ('importance_score_cutoff', sgqlc.types.Arg(Float, graphql_name='importanceScoreCutoff', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
))
    )
    '''Arguments:

    * `mcon` (`String!`)
    * `importance_score_cutoff` (`Float`)
    * `limit` (`Int`)
    '''

    get_data_maintenance_entries = sgqlc.types.Field(sgqlc.types.list_of(DataMaintenanceEntry), graphql_name='getDataMaintenanceEntries', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
))
    )
    '''Fetch data maintenance entries for warehouse

    Arguments:

    * `dw_id` (`UUID!`): Warehouse UUID
    '''

    get_wildcard_templates = sgqlc.types.Field('WildcardTemplates', graphql_name='getWildcardTemplates', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dwId', default=None)),
))
    )
    '''List of templates used for aggregating wildcard tables

    Arguments:

    * `dw_id` (`UUID!`): UUID of the warehouse to fetch templates for
    '''

    run_sql_investigation_query = sgqlc.types.Field('SQLResponse', graphql_name='runSqlInvestigationQuery', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('query', sgqlc.types.Arg(String, graphql_name='query', default=None)),
        ('variables', sgqlc.types.Arg(JSONString, graphql_name='variables', default=None)),
))
    )
    '''Arguments:

    * `dw_id` (`UUID`): warehouse UUID
    * `query` (`String`): Investigation query to run
    * `variables` (`JSONString`): variables and values to use
    '''

    get_common_fields = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='getCommonFields', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
))
    )
    '''Get fields that are common across a set of tables.

    Arguments:

    * `mcons` (`[String]`): The tables to inspect. All tables must
      belong to the same warehouse.
    '''

    get_common_fields_v2 = sgqlc.types.Field('TableFields', graphql_name='getCommonFieldsV2', args=sgqlc.types.ArgDict((
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
))
    )
    '''Get fields that are common across a set of tables.

    Arguments:

    * `mcons` (`[String]`): The tables to inspect. All tables must
      belong to the same warehouse.
    '''

    get_user_settings = sgqlc.types.Field(sgqlc.types.list_of('UserSettings'), graphql_name='getUserSettings', args=sgqlc.types.ArgDict((
        ('keys', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='keys', default=None)),
))
    )
    '''Get user-specific settings. Return only the settings that have
    value.

    Arguments:

    * `keys` (`[String]!`): User setting's keys
    '''

    get_user = sgqlc.types.Field('User', graphql_name='getUser')

    get_user_by_id = sgqlc.types.Field('User', graphql_name='getUserById')

    get_warehouse = sgqlc.types.Field('Warehouse', graphql_name='getWarehouse', args=sgqlc.types.ArgDict((
        ('uuid', sgqlc.types.Arg(UUID, graphql_name='uuid', default=None)),
))
    )
    '''Arguments:

    * `uuid` (`UUID`)None
    '''

    get_collection_properties = sgqlc.types.Field(CollectionProperties, graphql_name='getCollectionProperties', args=sgqlc.types.ArgDict((
        ('region', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='region', default=None)),
))
    )
    '''Get infrastructure properties for a new data collector deployment

    Arguments:

    * `region` (`String!`): AWS region
    '''

    get_custom_volume_datapoints = sgqlc.types.Field(GetCustomVolumeDatapointsResponse, graphql_name='getCustomVolumeDatapoints', args=sgqlc.types.ArgDict((
        ('custom_rule_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='customRuleUuid', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('eliminate_gaps', sgqlc.types.Arg(Boolean, graphql_name='eliminateGaps', default=None)),
))
    )
    '''List of data points for a custom volume rule

    Arguments:

    * `custom_rule_uuid` (`UUID!`): The UUID of the custom rule
    * `start_time` (`DateTime!`)None
    * `end_time` (`DateTime`)None
    * `eliminate_gaps` (`Boolean`)None
    '''

    get_custom_freshness_datapoints = sgqlc.types.Field(GetCustomFreshnessDatapointsResponse, graphql_name='getCustomFreshnessDatapoints', args=sgqlc.types.ArgDict((
        ('custom_rule_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='customRuleUuid', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('eliminate_gaps', sgqlc.types.Arg(Boolean, graphql_name='eliminateGaps', default=None)),
))
    )
    '''List of data points for a custom freshness rule

    Arguments:

    * `custom_rule_uuid` (`UUID!`): The UUID of the custom rule
    * `start_time` (`DateTime!`)None
    * `end_time` (`DateTime`)None
    * `eliminate_gaps` (`Boolean`)None
    '''

    get_table = sgqlc.types.Field('WarehouseTable', graphql_name='getTable', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
))
    )
    '''Get information about a table

    Arguments:

    * `dw_id` (`UUID`): Warehouse the table is contained in. Required
      when using a fullTableId
    * `full_table_id` (`String`): Deprecated - use mcon. Ignored if
      mcon is present
    * `mcon` (`String`): Mcon for table to get details for
    '''

    get_tables = sgqlc.types.Field('WarehouseTableConnection', graphql_name='getTables', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('search', sgqlc.types.Arg(String, graphql_name='search', default=None)),
        ('status', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='status', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('table_id', sgqlc.types.Arg(String, graphql_name='tableId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('warehouse', sgqlc.types.Arg(ID, graphql_name='warehouse', default=None)),
        ('discovered_time', sgqlc.types.Arg(DateTime, graphql_name='discoveredTime', default=None)),
        ('friendly_name', sgqlc.types.Arg(String, graphql_name='friendlyName', default=None)),
        ('location', sgqlc.types.Arg(String, graphql_name='location', default=None)),
        ('project_name', sgqlc.types.Arg(String, graphql_name='projectName', default=None)),
        ('dataset', sgqlc.types.Arg(String, graphql_name='dataset', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('table_type', sgqlc.types.Arg(String, graphql_name='tableType', default=None)),
        ('is_encrypted', sgqlc.types.Arg(Boolean, graphql_name='isEncrypted', default=None)),
        ('created_time', sgqlc.types.Arg(DateTime, graphql_name='createdTime', default=None)),
        ('last_modified', sgqlc.types.Arg(DateTime, graphql_name='lastModified', default=None)),
        ('view_query', sgqlc.types.Arg(String, graphql_name='viewQuery', default=None)),
        ('view_is_materialized', sgqlc.types.Arg(Boolean, graphql_name='viewIsMaterialized', default=None)),
        ('path', sgqlc.types.Arg(String, graphql_name='path', default=None)),
        ('priority', sgqlc.types.Arg(Int, graphql_name='priority', default=None)),
        ('tracked', sgqlc.types.Arg(Boolean, graphql_name='tracked', default=None)),
        ('freshness_anomaly', sgqlc.types.Arg(Boolean, graphql_name='freshnessAnomaly', default=None)),
        ('size_anomaly', sgqlc.types.Arg(Boolean, graphql_name='sizeAnomaly', default=None)),
        ('freshness_size_anomaly', sgqlc.types.Arg(Boolean, graphql_name='freshnessSizeAnomaly', default=None)),
        ('metric_anomaly', sgqlc.types.Arg(Boolean, graphql_name='metricAnomaly', default=None)),
        ('dynamic_table', sgqlc.types.Arg(Boolean, graphql_name='dynamicTable', default=None)),
        ('is_deleted', sgqlc.types.Arg(Boolean, graphql_name='isDeleted', default=None)),
        ('deleted_at', sgqlc.types.Arg(DateTime, graphql_name='deletedAt', default=None)),
        ('last_observed', sgqlc.types.Arg(DateTime, graphql_name='lastObserved', default=None)),
        ('is_excluded', sgqlc.types.Arg(Boolean, graphql_name='isExcluded', default=None)),
        ('is_monitored', sgqlc.types.Arg(Boolean, graphql_name='isMonitored', default=None)),
        ('data_provider', sgqlc.types.Arg(String, graphql_name='dataProvider', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('importance_score', sgqlc.types.Arg(Float, graphql_name='importanceScore', default=None)),
        ('is_important', sgqlc.types.Arg(Boolean, graphql_name='isImportant', default=None)),
        ('importance_score_is_custom', sgqlc.types.Arg(Boolean, graphql_name='importanceScoreIsCustom', default=None)),
        ('is_important_is_custom', sgqlc.types.Arg(Boolean, graphql_name='isImportantIsCustom', default=None)),
        ('last_observed__gt', sgqlc.types.Arg(DateTime, graphql_name='lastObserved_Gt', default=None)),
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
))
    )
    '''Get tables in account

    Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    * `search` (`String`): Filter by partial asset names (e.g.
      dataset)
    * `status` (`[String]`): Filter by table statuses
    * `domain_id` (`UUID`): Filter by domain UUID
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `table_id` (`String`)None
    * `full_table_id` (`String`)None
    * `warehouse` (`ID`)None
    * `discovered_time` (`DateTime`)None
    * `friendly_name` (`String`)None
    * `location` (`String`)None
    * `project_name` (`String`)None
    * `dataset` (`String`)None
    * `description` (`String`)None
    * `table_type` (`String`)None
    * `is_encrypted` (`Boolean`)None
    * `created_time` (`DateTime`)None
    * `last_modified` (`DateTime`)None
    * `view_query` (`String`)None
    * `view_is_materialized` (`Boolean`)None
    * `path` (`String`)None
    * `priority` (`Int`)None
    * `tracked` (`Boolean`)None
    * `freshness_anomaly` (`Boolean`)None
    * `size_anomaly` (`Boolean`)None
    * `freshness_size_anomaly` (`Boolean`)None
    * `metric_anomaly` (`Boolean`)None
    * `dynamic_table` (`Boolean`)None
    * `is_deleted` (`Boolean`)None
    * `deleted_at` (`DateTime`)None
    * `last_observed` (`DateTime`)None
    * `is_excluded` (`Boolean`)None
    * `is_monitored` (`Boolean`)None
    * `data_provider` (`String`)None
    * `mcon` (`String`)None
    * `importance_score` (`Float`)None
    * `is_important` (`Boolean`)None
    * `importance_score_is_custom` (`Boolean`)None
    * `is_important_is_custom` (`Boolean`)None
    * `last_observed__gt` (`DateTime`)None
    * `order_by` (`String`): Ordering
    '''

    get_tables_health = sgqlc.types.Field('WarehouseTableHealthConnection', graphql_name='getTablesHealth', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('search', sgqlc.types.Arg(String, graphql_name='search', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('table_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tableMcons', default=None)),
        ('table_contains', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tableContains', default=None)),
        ('tags_contains', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tagsContains', default=None)),
        ('tag_key_value_pairs', sgqlc.types.Arg(sgqlc.types.list_of(TagKeyValuePairInput), graphql_name='tagKeyValuePairs', default=None)),
        ('key_assets_only', sgqlc.types.Arg(Boolean, graphql_name='keyAssetsOnly', default=None)),
        ('has_incidents_only', sgqlc.types.Arg(Boolean, graphql_name='hasIncidentsOnly', default=None)),
        ('has_incidents_start_time', sgqlc.types.Arg(DateTime, graphql_name='hasIncidentsStartTime', default=None)),
        ('has_incidents_end_time', sgqlc.types.Arg(DateTime, graphql_name='hasIncidentsEndTime', default=None)),
        ('has_incidents_include_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='hasIncidentsIncludeFeedback', default=None)),
        ('has_incidents_exclude_feedback', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='hasIncidentsExcludeFeedback', default=None)),
        ('has_incidents_include_normalized', sgqlc.types.Arg(Boolean, graphql_name='hasIncidentsIncludeNormalized', default=None)),
        ('has_incidents_severities', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='hasIncidentsSeverities', default=None)),
        ('incident_categories', sgqlc.types.Arg(sgqlc.types.list_of(IncidentCategory), graphql_name='incidentCategories', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('table_id', sgqlc.types.Arg(String, graphql_name='tableId', default=None)),
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('warehouse', sgqlc.types.Arg(ID, graphql_name='warehouse', default=None)),
        ('discovered_time', sgqlc.types.Arg(DateTime, graphql_name='discoveredTime', default=None)),
        ('friendly_name', sgqlc.types.Arg(String, graphql_name='friendlyName', default=None)),
        ('location', sgqlc.types.Arg(String, graphql_name='location', default=None)),
        ('project_name', sgqlc.types.Arg(String, graphql_name='projectName', default=None)),
        ('dataset', sgqlc.types.Arg(String, graphql_name='dataset', default=None)),
        ('description', sgqlc.types.Arg(String, graphql_name='description', default=None)),
        ('table_type', sgqlc.types.Arg(String, graphql_name='tableType', default=None)),
        ('is_encrypted', sgqlc.types.Arg(Boolean, graphql_name='isEncrypted', default=None)),
        ('created_time', sgqlc.types.Arg(DateTime, graphql_name='createdTime', default=None)),
        ('last_modified', sgqlc.types.Arg(DateTime, graphql_name='lastModified', default=None)),
        ('view_query', sgqlc.types.Arg(String, graphql_name='viewQuery', default=None)),
        ('view_is_materialized', sgqlc.types.Arg(Boolean, graphql_name='viewIsMaterialized', default=None)),
        ('path', sgqlc.types.Arg(String, graphql_name='path', default=None)),
        ('priority', sgqlc.types.Arg(Int, graphql_name='priority', default=None)),
        ('tracked', sgqlc.types.Arg(Boolean, graphql_name='tracked', default=None)),
        ('freshness_anomaly', sgqlc.types.Arg(Boolean, graphql_name='freshnessAnomaly', default=None)),
        ('size_anomaly', sgqlc.types.Arg(Boolean, graphql_name='sizeAnomaly', default=None)),
        ('freshness_size_anomaly', sgqlc.types.Arg(Boolean, graphql_name='freshnessSizeAnomaly', default=None)),
        ('metric_anomaly', sgqlc.types.Arg(Boolean, graphql_name='metricAnomaly', default=None)),
        ('dynamic_table', sgqlc.types.Arg(Boolean, graphql_name='dynamicTable', default=None)),
        ('is_deleted', sgqlc.types.Arg(Boolean, graphql_name='isDeleted', default=None)),
        ('deleted_at', sgqlc.types.Arg(DateTime, graphql_name='deletedAt', default=None)),
        ('last_observed', sgqlc.types.Arg(DateTime, graphql_name='lastObserved', default=None)),
        ('is_excluded', sgqlc.types.Arg(Boolean, graphql_name='isExcluded', default=None)),
        ('is_monitored', sgqlc.types.Arg(Boolean, graphql_name='isMonitored', default=None)),
        ('data_provider', sgqlc.types.Arg(String, graphql_name='dataProvider', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('importance_score', sgqlc.types.Arg(Float, graphql_name='importanceScore', default=None)),
        ('is_important', sgqlc.types.Arg(Boolean, graphql_name='isImportant', default=None)),
        ('importance_score_is_custom', sgqlc.types.Arg(Boolean, graphql_name='importanceScoreIsCustom', default=None)),
        ('is_important_is_custom', sgqlc.types.Arg(Boolean, graphql_name='isImportantIsCustom', default=None)),
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
))
    )
    '''Get tables health in account

    Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    * `search` (`String`): Filter by partial asset names (e.g.
      dataset)
    * `domain_id` (`UUID`): Filter by domain UUID
    * `table_mcons` (`[String]`): List of table MCONS to filter the
      result
    * `table_contains` (`[String]`): List of terms to filter the
      result on full name (project/schema/name) of the tables
    * `tags_contains` (`[String]`): List of terms to filter the result
      on tags (both tag keys and values)
    * `tag_key_value_pairs` (`[TagKeyValuePairInput]`): Filter by tag
      key values
    * `key_assets_only` (`Boolean`): Filter by key assets only
    * `has_incidents_only` (`Boolean`): Filter by tables that have
      incidents
    * `has_incidents_start_time` (`DateTime`): Filter tables without
      incidents newer than this
    * `has_incidents_end_time` (`DateTime`): Filter tables without
      incidents older than this
    * `has_incidents_include_feedback` (`[String]`): Filter tables
      without incidents with user feedback
    * `has_incidents_exclude_feedback` (`[String]`): Filter tables
      without incidents excluding user feedback
    * `has_incidents_include_normalized` (`Boolean`): Filter tables
      without incidents excluding normalized incidents if False is
      indicate
    * `has_incidents_severities` (`[String]`): Filter tables without
      incidents with severity
    * `incident_categories` (`[IncidentCategory]`): Include only
      selected incident categories. Or all categories if not
      specified.
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `table_id` (`String`)None
    * `full_table_id` (`String`)None
    * `warehouse` (`ID`)None
    * `discovered_time` (`DateTime`)None
    * `friendly_name` (`String`)None
    * `location` (`String`)None
    * `project_name` (`String`)None
    * `dataset` (`String`)None
    * `description` (`String`)None
    * `table_type` (`String`)None
    * `is_encrypted` (`Boolean`)None
    * `created_time` (`DateTime`)None
    * `last_modified` (`DateTime`)None
    * `view_query` (`String`)None
    * `view_is_materialized` (`Boolean`)None
    * `path` (`String`)None
    * `priority` (`Int`)None
    * `tracked` (`Boolean`)None
    * `freshness_anomaly` (`Boolean`)None
    * `size_anomaly` (`Boolean`)None
    * `freshness_size_anomaly` (`Boolean`)None
    * `metric_anomaly` (`Boolean`)None
    * `dynamic_table` (`Boolean`)None
    * `is_deleted` (`Boolean`)None
    * `deleted_at` (`DateTime`)None
    * `last_observed` (`DateTime`)None
    * `is_excluded` (`Boolean`)None
    * `is_monitored` (`Boolean`)None
    * `data_provider` (`String`)None
    * `mcon` (`String`)None
    * `importance_score` (`Float`)None
    * `is_important` (`Boolean`)None
    * `importance_score_is_custom` (`Boolean`)None
    * `is_important_is_custom` (`Boolean`)None
    * `order_by` (`String`): Ordering
    '''

    get_bq_projects = sgqlc.types.Field(sgqlc.types.list_of(BigQueryProject), graphql_name='getBqProjects', args=sgqlc.types.ArgDict((
        ('credentials_key', sgqlc.types.Arg(String, graphql_name='credentialsKey', default=None)),
))
    )
    '''Arguments:

    * `credentials_key` (`String`)None
    '''

    get_slack_oauth_url = sgqlc.types.Field('SlackOauthUrlResponse', graphql_name='getSlackOauthUrl', args=sgqlc.types.ArgDict((
        ('slack_app_type', sgqlc.types.Arg(SlackAppType, graphql_name='slackAppType', default=None)),
))
    )
    '''Returns a Slack OAuth URL

    Arguments:

    * `slack_app_type` (`SlackAppType`): Slack app type
    '''

    get_slack_channels = sgqlc.types.Field('SlackChannelResponse', graphql_name='getSlackChannels', args=sgqlc.types.ArgDict((
        ('exclude_archived', sgqlc.types.Arg(Boolean, graphql_name='excludeArchived', default=None)),
        ('ignore_cached', sgqlc.types.Arg(Boolean, graphql_name='ignoreCached', default=None)),
))
    )
    '''Arguments:

    * `exclude_archived` (`Boolean`): Specify whether to include
      archived Slack Channels
    * `ignore_cached` (`Boolean`): Specify whether to ignore the
      cached versions and attempt to pull directly from Slack API.
    '''

    get_slack_channels_v2 = sgqlc.types.Field('SlackChannelV2Connection', graphql_name='getSlackChannelsV2', args=sgqlc.types.ArgDict((
        ('order_by', sgqlc.types.Arg(String, graphql_name='orderBy', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('name__iexact', sgqlc.types.Arg(String, graphql_name='name_Iexact', default=None)),
        ('name__icontains', sgqlc.types.Arg(String, graphql_name='name_Icontains', default=None)),
        ('name__istartswith', sgqlc.types.Arg(String, graphql_name='name_Istartswith', default=None)),
        ('team_id__iexact', sgqlc.types.Arg(String, graphql_name='teamId_Iexact', default=None)),
))
    )
    '''Arguments:

    * `order_by` (`String`): Ordering
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `name__iexact` (`String`)None
    * `name__icontains` (`String`)None
    * `name__istartswith` (`String`)None
    * `team_id__iexact` (`String`)None
    '''

    get_projects = sgqlc.types.Field(Projects, graphql_name='getProjects', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('search', sgqlc.types.Arg(String, graphql_name='search', default=None)),
        ('warehouse_type', sgqlc.types.Arg(String, graphql_name='warehouseType', default=None)),
))
    )
    '''Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    * `search` (`String`): Filter by project name
    * `warehouse_type` (`String`): Filter by a specific warehouse type
    '''

    get_datasets_by_uuid = sgqlc.types.Field(sgqlc.types.list_of('Dataset'), graphql_name='getDatasetsByUuid', args=sgqlc.types.ArgDict((
        ('dataset_uuids', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(UUID)), graphql_name='datasetUuids', default=None)),
))
    )
    '''Get datasets by UUID

    Arguments:

    * `dataset_uuids` (`[UUID]!`)None
    '''

    get_datasets = sgqlc.types.Field(DatasetConnection, graphql_name='getDatasets', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
        ('search', sgqlc.types.Arg(String, graphql_name='search', default=None)),
        ('allow_search_on_project', sgqlc.types.Arg(Boolean, graphql_name='allowSearchOnProject', default=None)),
        ('domain_id', sgqlc.types.Arg(UUID, graphql_name='domainId', default=None)),
        ('include_table_count', sgqlc.types.Arg(Boolean, graphql_name='includeTableCount', default=False)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('dataset', sgqlc.types.Arg(String, graphql_name='dataset', default=None)),
))
    )
    '''Get datasets in the account

    Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    * `search` (`String`): Filter by a dataset
    * `allow_search_on_project` (`Boolean`): Apply search filter on
      project name
    * `domain_id` (`UUID`): Filter by domain UUID
    * `include_table_count` (`Boolean`): Include table count for each
      dataset (default: `false`)
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `dataset` (`String`)None
    '''

    get_field_bi_lineage = sgqlc.types.Field(sgqlc.types.list_of(FieldDownstreamBi), graphql_name='getFieldBiLineage', args=sgqlc.types.ArgDict((
        ('full_table_id', sgqlc.types.Arg(String, graphql_name='fullTableId', default=None)),
        ('field_name', sgqlc.types.Arg(String, graphql_name='fieldName', default=None)),
        ('last_seen_range_start', sgqlc.types.Arg(DateTime, graphql_name='lastSeenRangeStart', default=None)),
))
    )
    '''Arguments:

    * `full_table_id` (`String`)None
    * `field_name` (`String`)None
    * `last_seen_range_start` (`DateTime`)None
    '''

    get_event_muting_rules = sgqlc.types.Field(sgqlc.types.list_of(EventMutingRule), graphql_name='getEventMutingRules', args=sgqlc.types.ArgDict((
        ('dw_id', sgqlc.types.Arg(UUID, graphql_name='dwId', default=None)),
))
    )
    '''Get muting rules in the account

    Arguments:

    * `dw_id` (`UUID`): Filter by a specific warehouse
    '''

    get_users_in_account = sgqlc.types.Field('UserConnection', graphql_name='getUsersInAccount', args=sgqlc.types.ArgDict((
        ('roles', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='roles', default=None)),
        ('search', sgqlc.types.Arg(String, graphql_name='search', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('email', sgqlc.types.Arg(String, graphql_name='email', default=None)),
        ('first_name', sgqlc.types.Arg(String, graphql_name='firstName', default=None)),
        ('last_name', sgqlc.types.Arg(String, graphql_name='lastName', default=None)),
        ('role', sgqlc.types.Arg(String, graphql_name='role', default=None)),
))
    )
    '''Arguments:

    * `roles` (`[String]`): Filter by user roles
    * `search` (`String`): Filter by first name, last name or email
      address
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `email` (`String`)None
    * `first_name` (`String`)None
    * `last_name` (`String`)None
    * `role` (`String`)None
    '''

    get_invites_in_account = sgqlc.types.Field('UserInviteConnection', graphql_name='getInvitesInAccount', args=sgqlc.types.ArgDict((
        ('roles', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='roles', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('state', sgqlc.types.Arg(String, graphql_name='state', default=None)),
))
    )
    '''Arguments:

    * `roles` (`[String]`): Filter by user role membership
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    * `state` (`String`)None
    '''

    get_token_metadata = sgqlc.types.Field(sgqlc.types.list_of('TokenMetadata'), graphql_name='getTokenMetadata', args=sgqlc.types.ArgDict((
        ('index', sgqlc.types.Arg(sgqlc.types.non_null(AccessKeyIndexEnum), graphql_name='index', default=None)),
        ('is_service_api_token', sgqlc.types.Arg(Boolean, graphql_name='isServiceApiToken', default=False)),
))
    )
    '''Retrieve access token metadata for current user or account

    Arguments:

    * `index` (`AccessKeyIndexEnum!`): Specifies which metadata index
      to use
    * `is_service_api_token` (`Boolean`): Filter by token type.
      (default: `false`)
    '''

    get_integration_keys = sgqlc.types.Field(sgqlc.types.list_of(IntegrationKeyMetadata), graphql_name='getIntegrationKeys', args=sgqlc.types.ArgDict((
        ('scope', sgqlc.types.Arg(String, graphql_name='scope', default=None)),
        ('resource_uuid', sgqlc.types.Arg(UUID, graphql_name='resourceUuid', default=None)),
))
    )
    '''Retrieve integration keys in the current user's account

    Arguments:

    * `scope` (`String`): Optional scope to filter keys by
    * `resource_uuid` (`UUID`): Optional, return only keys including
      this resource id
    '''

    test_existing_connection = sgqlc.types.Field('TestConnectionResponse', graphql_name='testExistingConnection', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
))
    )
    '''Test an existing connection's credentials against the account's
    data collector

    Arguments:

    * `connection_id` (`UUID`): An existing connection's UUID
    '''

    test_telnet_connection = sgqlc.types.Field('TestConnectionResponse', graphql_name='testTelnetConnection', args=sgqlc.types.ArgDict((
        ('host', sgqlc.types.Arg(String, graphql_name='host', default=None)),
        ('port', sgqlc.types.Arg(Int, graphql_name='port', default=None)),
        ('timeout', sgqlc.types.Arg(Int, graphql_name='timeout', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
))
    )
    '''Checks if telnet connection is usable.

    Arguments:

    * `host` (`String`): Host to check
    * `port` (`Int`): Port to check
    * `timeout` (`Int`): Timeout in seconds
    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    '''

    test_tcp_open_connection = sgqlc.types.Field('TestConnectionResponse', graphql_name='testTcpOpenConnection', args=sgqlc.types.ArgDict((
        ('host', sgqlc.types.Arg(String, graphql_name='host', default=None)),
        ('port', sgqlc.types.Arg(Int, graphql_name='port', default=None)),
        ('timeout', sgqlc.types.Arg(Int, graphql_name='timeout', default=None)),
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
))
    )
    '''Tests if a destination exists and accepts requests. Opens a TCP
    Socket to a specific port.

    Arguments:

    * `host` (`String`): Host to check
    * `port` (`Int`): Port to check
    * `timeout` (`Int`): Timeout in seconds
    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors
    '''

    test_notification_integration = sgqlc.types.Field(Boolean, graphql_name='testNotificationIntegration', args=sgqlc.types.ArgDict((
        ('setting_id', sgqlc.types.Arg(UUID, graphql_name='settingId', default=None)),
))
    )
    '''Tests an integration is reachable by sending a sample alert. Note
    - rules are not evaluated.

    Arguments:

    * `setting_id` (`UUID`): UUID for the notification setting.
    '''

    get_databricks_cluster_info = sgqlc.types.Field(DatabricksClusterResponse, graphql_name='getDatabricksClusterInfo', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
        ('connection_config', sgqlc.types.Arg(SparkDatabricksConnectionInput, graphql_name='connectionConfig', default=None)),
))
    )
    '''Get the state of the databricks cluster.

    Arguments:

    * `connection_id` (`UUID`): A Databricks connection UUID.
    * `connection_config` (`SparkDatabricksConnectionInput`):
      Connection config for new Databricks cluster connection
    '''

    get_databricks_warehouse_info = sgqlc.types.Field(DatabricksWarehouseResponse, graphql_name='getDatabricksWarehouseInfo', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
        ('connection_config', sgqlc.types.Arg(DatabricksSqlWarehouseConnectionInput, graphql_name='connectionConfig', default=None)),
))
    )
    '''Get the state of the databricks warehouse.

    Arguments:

    * `connection_id` (`UUID`): A Databricks connection UUID.
    * `connection_config` (`DatabricksSqlWarehouseConnectionInput`):
      Connection config for new Databricks SQL Warehouse connection
    '''

    get_databricks_notebook_link = sgqlc.types.Field(DatabricksNotebookLink, graphql_name='getDatabricksNotebookLink')
    '''Get a temporary link to the latest collection notebook.'''

    get_databricks_metadata_job_info = sgqlc.types.Field(sgqlc.types.list_of(DatabricksJobResponse), graphql_name='getDatabricksMetadataJobInfo', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(UUID, graphql_name='connectionId', default=None)),
))
    )
    '''The Databricks job information for the connection.

    Arguments:

    * `connection_id` (`UUID`): A Databricks connection UUID.
    '''

    get_current_databricks_notebook_version = sgqlc.types.Field(String, graphql_name='getCurrentDatabricksNotebookVersion')
    '''Current Version of the Databricks Collection Notebook'''

    validate_connection_type = sgqlc.types.Field(Boolean, graphql_name='validateConnectionType', args=sgqlc.types.ArgDict((
        ('warehouse_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='warehouseType', default=None)),
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
))
    )
    '''Validate that the connection type can be added to the warehouse
    type

    Arguments:

    * `warehouse_type` (`String!`): The type of the warehouse to add
      the connection to
    * `connection_type` (`String!`): The type of the connection to add
    '''

    get_event_onboarding_data = sgqlc.types.Field(EventOnbardingConfig, graphql_name='getEventOnboardingData')

    get_etl_containers = sgqlc.types.Field(sgqlc.types.list_of(EtlContainer), graphql_name='getEtlContainers')
    '''Retrieve the list of ETL containers in the current user's account'''

    get_supported_validations_v2 = sgqlc.types.Field('SupportedValidationsResponse', graphql_name='getSupportedValidationsV2', args=sgqlc.types.ArgDict((
        ('dc_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='dcId', default=None)),
        ('connection_type', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='connectionType', default=None)),
        ('scope', sgqlc.types.Arg(String, graphql_name='scope', default=None)),
))
    )
    '''Arguments:

    * `dc_id` (`UUID!`): DC UUID. To disambiguate accounts with
      multiple collectors.
    * `connection_type` (`String!`): The type of connection to query
      supported validations for.
    * `scope` (`String`): The scope of validations to return
    '''

    get_supported_table_validations = sgqlc.types.Field('SupportedTableValidationsResponse', graphql_name='getSupportedTableValidations', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
))
    )
    '''Arguments:

    * `connection_id` (`UUID!`): UUID of the connection to check for
      supported table validations.
    '''

    validate_data_asset_access = sgqlc.types.Field('ValidateDataAssetAccessResponse', graphql_name='validateDataAssetAccess', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
        ('validation_names', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='validationNames', default=None)),
        ('mcon', sgqlc.types.Arg(String, graphql_name='mcon', default=None)),
        ('asset_id', sgqlc.types.Arg(String, graphql_name='assetId', default=None)),
        ('project', sgqlc.types.Arg(String, graphql_name='project', default=None)),
        ('dataset', sgqlc.types.Arg(String, graphql_name='dataset', default=None)),
        ('asset_name', sgqlc.types.Arg(String, graphql_name='assetName', default=None)),
        ('asset_type', sgqlc.types.Arg(DataAssetTypeEnum, graphql_name='assetType', default='ASSET_TYPE_TABLE')),
))
    )
    '''Arguments:

    * `connection_id` (`UUID!`): The connection UUID
    * `validation_names` (`[String]`): Name of the table validation to
      run.
    * `mcon` (`String`): MCON of the table to validate
    * `asset_id` (`String`): Full ID of the table to validate in the
      format: project:dataset.table, ignored if mcon is specified
    * `project` (`String`): Project (or database) containing the asset
      to validate. Ignored if mcon or asset_id are specified
    * `dataset` (`String`): Dataset (or schema) containing the asset
      to validate. Ignored if mcon or asset_id are specified
    * `asset_name` (`String`): Name of the asset to validate, for
      example table name. Ignored if mcon or asset_id are specified
    * `asset_type` (`DataAssetTypeEnum`): Asset type to validate, it
      could be table, external, snowflake_stream, etc., ignored if
      mcon is specified (default: `"table"`)
    '''

    test_existing_connection_v2 = sgqlc.types.Field('TestCredentialsV2Response', graphql_name='testExistingConnectionV2', args=sgqlc.types.ArgDict((
        ('validation_name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='validationName', default=None)),
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
))
    )
    '''Execute a validation test on an integration

    Arguments:

    * `validation_name` (`String!`): Name of the validation that
      should be run.
    * `connection_id` (`UUID!`): An existing connection's UUID
    '''

    test_storage_access = sgqlc.types.Field('TestCredentialsV2Response', graphql_name='testStorageAccess', args=sgqlc.types.ArgDict((
        ('dc_id', sgqlc.types.Arg(UUID, graphql_name='dcId', default=None)),
))
    )
    '''Validates storage access for the account

    Arguments:

    * `dc_id` (`UUID`): DC UUID. To disambiguate accounts with
      multiple collectors.
    '''

    test_data_store_reachability = sgqlc.types.Field('TestCredentialsV2Response', graphql_name='testDataStoreReachability', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
))
    )
    '''Validates that Data Store is accessible for the account

    Arguments:

    * `agent_id` (`UUID!`): Identifies which storage to run the test
      against.
    '''

    test_agent_reachability = sgqlc.types.Field('TestCredentialsV2Response', graphql_name='testAgentReachability', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
))
    )
    '''Validates that Agent is accessible for the account

    Arguments:

    * `agent_id` (`UUID!`): Identifies which agent to run the test
      against.
    '''

    list_projects = sgqlc.types.Field(ListProjectsResponse, graphql_name='listProjects', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
        ('page_size', sgqlc.types.Arg(Int, graphql_name='pageSize', default=None)),
        ('page_token', sgqlc.types.Arg(String, graphql_name='pageToken', default=None)),
))
    )
    '''Lists projects for a given connection

    Arguments:

    * `connection_id` (`UUID!`): A connection ID
    * `page_size` (`Int`): The size of the page being requested.
    * `page_token` (`String`): The token for the page being requested.
    '''

    list_datasets = sgqlc.types.Field(ListDatasetsResponse, graphql_name='listDatasets', args=sgqlc.types.ArgDict((
        ('connection_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='connectionId', default=None)),
        ('project_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='projectId', default=None)),
        ('page_size', sgqlc.types.Arg(Int, graphql_name='pageSize', default=None)),
        ('page_token', sgqlc.types.Arg(String, graphql_name='pageToken', default=None)),
))
    )
    '''Lists datasets for a given connection

    Arguments:

    * `connection_id` (`UUID!`): A connection ID
    * `project_id` (`String!`): The ID of the project whose datasets
      are being queried
    * `page_size` (`Int`): The size of the page being requested.
    * `page_token` (`String`): The token for the page being requested.
    '''

    get_account_audit_logs = sgqlc.types.Field(GetAccountAuditLogsResponse, graphql_name='getAccountAuditLogs', args=sgqlc.types.ArgDict((
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('start_time', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('include_api_queries', sgqlc.types.Arg(Boolean, graphql_name='includeApiQueries', default=False)),
        ('api_call_references', sgqlc.types.Arg(sgqlc.types.list_of(ApiCallReference), graphql_name='apiCallReferences', default=None)),
        ('user_email', sgqlc.types.Arg(String, graphql_name='userEmail', default=None)),
))
    )
    '''Get audit logs for an account.

    Arguments:

    * `first` (`Int`): When paging forward: the number of items to
      return (page size)
    * `after` (`String`): When paging forward: the cursor of the last
      item on the previous page of results
    * `last` (`Int`): When paging backward: the number of items to
      return (page size)
    * `before` (`String`): When paging backward: the cursor of the
      first item on the next page of results
    * `start_time` (`DateTime!`): Start time of the time range to
      query
    * `end_time` (`DateTime`): End time of the time range to query.
      Defaults to current time
    * `include_api_queries` (`Boolean`): If set to false, GraphQL API
      calls that are queries (not mutations) will be excluded from the
      response (default: `false`)
    * `api_call_references` (`[ApiCallReference]`): References (For
      instance UUIDs) that were passed as input to GraphQL API calls
    * `user_email` (`String`): Filter activity of a specific user
    '''

    get_monitor_audit_logs = sgqlc.types.Field(AuditLogEntryConnection, graphql_name='getMonitorAuditLogs', args=sgqlc.types.ArgDict((
        ('monitor_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='monitorUuid', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get audit logs for specified monitor

    Arguments:

    * `monitor_uuid` (`UUID!`): UUID of monitor
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_alation_table_flags = sgqlc.types.Field(sgqlc.types.list_of(GetAlationTableFlags), graphql_name='getAlationTableFlags', args=sgqlc.types.ArgDict((
        ('mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='mcon', default=None)),
))
    )
    '''Gets warning and deprecation flags set in Alation for this table.

    Arguments:

    * `mcon` (`String!`): The MCON of the table
    '''

    get_airflow_task_results = sgqlc.types.Field(AirflowTaskRunConnection, graphql_name='getAirflowTaskResults', args=sgqlc.types.ArgDict((
        ('resource_name', sgqlc.types.Arg(String, graphql_name='resourceName', default=None)),
        ('from_date', sgqlc.types.Arg(DateTime, graphql_name='fromDate', default=None)),
        ('to_date', sgqlc.types.Arg(DateTime, graphql_name='toDate', default=None)),
        ('success', sgqlc.types.Arg(Boolean, graphql_name='success', default=None)),
        ('state', sgqlc.types.Arg(String, graphql_name='state', default=None)),
        ('dag_id', sgqlc.types.Arg(String, graphql_name='dagId', default=None)),
        ('task_id', sgqlc.types.Arg(String, graphql_name='taskId', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('job_mcon', sgqlc.types.Arg(String, graphql_name='jobMcon', default=None)),
        ('task_mcon', sgqlc.types.Arg(String, graphql_name='taskMcon', default=None)),
        ('table_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tableMcons', default=None)),
        ('run_id', sgqlc.types.Arg(String, graphql_name='runId', default=None)),
        ('offset', sgqlc.types.Arg(Int, graphql_name='offset', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get Airflow Task runs

    Arguments:

    * `resource_name` (`String`): Filter by ETL container
    * `from_date` (`DateTime`): Filter date range start, optional only
      if runId is specified
    * `to_date` (`DateTime`): Filter date range end
    * `success` (`Boolean`): Filter by success or failure
    * `state` (`String`): Filter by state
    * `dag_id` (`String`): Deprecated, use jobMcon. Filter by DAG ID
    * `task_id` (`String`): Deprecated, use taskMcon. Filter by Task
      ID
    * `mcons` (`[String]`): Deprecated, use tableMcons. Filter by list
      of table MCONs
    * `job_mcon` (`String`): Filter by Job MCON
    * `task_mcon` (`String`): Filter by Task MCON
    * `table_mcons` (`[String]`): Filter by list of table MCONs
    * `run_id` (`String`): Filter by Run ID
    * `offset` (`Int`)None
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_airflow_task_stats = sgqlc.types.Field(AirflowTaskRunStatsConnection, graphql_name='getAirflowTaskStats', args=sgqlc.types.ArgDict((
        ('resource_name', sgqlc.types.Arg(String, graphql_name='resourceName', default=None)),
        ('from_date', sgqlc.types.Arg(sgqlc.types.non_null(DateTime), graphql_name='fromDate', default=None)),
        ('to_date', sgqlc.types.Arg(DateTime, graphql_name='toDate', default=None)),
        ('success', sgqlc.types.Arg(Boolean, graphql_name='success', default=None)),
        ('state', sgqlc.types.Arg(String, graphql_name='state', default=None)),
        ('mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='mcons', default=None)),
        ('dag_id', sgqlc.types.Arg(String, graphql_name='dagId', default=None)),
        ('table_mcons', sgqlc.types.Arg(sgqlc.types.list_of(String), graphql_name='tableMcons', default=None)),
        ('job_mcon', sgqlc.types.Arg(String, graphql_name='jobMcon', default=None)),
        ('before', sgqlc.types.Arg(String, graphql_name='before', default=None)),
        ('after', sgqlc.types.Arg(String, graphql_name='after', default=None)),
        ('first', sgqlc.types.Arg(Int, graphql_name='first', default=None)),
        ('last', sgqlc.types.Arg(Int, graphql_name='last', default=None)),
))
    )
    '''Get Airflow Task statistics

    Arguments:

    * `resource_name` (`String`): Filter by ETL container
    * `from_date` (`DateTime!`): Filter date range start
    * `to_date` (`DateTime`): Filter date range end
    * `success` (`Boolean`): Filter by success or failure
    * `state` (`String`): Filter by state
    * `mcons` (`[String]`): Deprecated, use tableMcons. Filter by list
      of table MCONs
    * `dag_id` (`String`): Deprecated, use jobMcon. Filter by DAG ID
    * `table_mcons` (`[String]`): Filter by list of table MCONs
    * `job_mcon` (`String`): Filter by Job MCON
    * `before` (`String`)None
    * `after` (`String`)None
    * `first` (`Int`)None
    * `last` (`Int`)None
    '''

    get_airflow_dag_runs = sgqlc.types.Field(sgqlc.types.list_of(AirflowDagRunInfo), graphql_name='getAirflowDagRuns', args=sgqlc.types.ArgDict((
        ('job_mcon', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='jobMcon', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=20)),
))
    )
    '''List of runs for a given DAG

    Arguments:

    * `job_mcon` (`String!`): Job MCON to filter by
    * `limit` (`Int`): Number of runs to return (default: `20`)
    '''

    get_airflow_capabilities = sgqlc.types.Field(sgqlc.types.non_null(AirflowCapabilitiesResponse), graphql_name='getAirflowCapabilities')
    '''Airflow Capabilities'''

    fix_sql_query = sgqlc.types.Field(AIMessageOutput, graphql_name='fixSqlQuery', args=sgqlc.types.ArgDict((
        ('sql_query', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='sqlQuery', default=None)),
        ('error_message', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='errorMessage', default=None)),
        ('warehouse_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='warehouseUuid', default=None)),
        ('request_uuid', sgqlc.types.Arg(UUID, graphql_name='requestUuid', default=None)),
))
    )
    '''Given a SQL query it uses AI to fix it

    Arguments:

    * `sql_query` (`String!`): SQL query to fix
    * `error_message` (`String!`): Error message
    * `warehouse_uuid` (`UUID!`): The identifier of warehouse that is
      being queried
    * `request_uuid` (`UUID`): The identifier of the request if we
      want to stream the results
    '''

    create_sql_query = sgqlc.types.Field(AIMessageOutput, graphql_name='createSqlQuery', args=sgqlc.types.ArgDict((
        ('messages', sgqlc.types.Arg(sgqlc.types.non_null(sgqlc.types.list_of(AIMessageInput)), graphql_name='messages', default=None)),
        ('warehouse_uuid', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='warehouseUuid', default=None)),
        ('request_uuid', sgqlc.types.Arg(UUID, graphql_name='requestUuid', default=None)),
))
    )
    '''Convert natural language into a SQL query

    Arguments:

    * `messages` (`[AIMessageInput]!`): Messages between the user and
      the AI
    * `warehouse_uuid` (`UUID!`): The identifier of datawarehouse that
      is being queried
    * `request_uuid` (`UUID`): The identifier of the request if we
      want to stream the results
    '''

    get_agent_operation_logs = sgqlc.types.Field(sgqlc.types.list_of(AgentLogEntry), graphql_name='getAgentOperationLogs', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('connection_type', sgqlc.types.Arg(String, graphql_name='connectionType', default=None)),
))
    )
    '''Get Agent operations log entries for a given time period,
    optionally matching a connection type

    Arguments:

    * `agent_id` (`UUID!`): Agent ID
    * `start_time` (`DateTime`): Optional start time, defaults to 10
      minutes ago
    * `end_time` (`DateTime`): Optional end time, defaults to now
    * `limit` (`Int`): Maximum number of entries to return, defaults
      to 1000
    * `connection_type` (`String`): Optional connection type, for
      example "snowflake", "redshift", etc.
    '''

    get_gcp_agent_logs = sgqlc.types.Field(sgqlc.types.list_of(AgentLogEntry), graphql_name='getGcpAgentLogs', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('logs_filter', sgqlc.types.Arg(String, graphql_name='logsFilter', default=None)),
))
    )
    '''Get GCP Agent log entries for a given time period, optionally
    matching a filter

    Arguments:

    * `agent_id` (`UUID!`): GCP Agent ID
    * `limit` (`Int`): Maximum number of entries to return, defaults
      to 1000
    * `logs_filter` (`String`): Optional filter, for example:
      SEARCH("text") or timestamp >= "2023-01-01T00:00:00Z"
    '''

    get_azure_agent_logs = sgqlc.types.Field(sgqlc.types.list_of(AgentLogEntry), graphql_name='getAzureAgentLogs', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('query', sgqlc.types.Arg(String, graphql_name='query', default=None)),
))
    )
    '''Get Azure Agent log entries for a given time period, optionally
    matching a query

    Arguments:

    * `agent_id` (`UUID!`): Azure Agent ID
    * `start_time` (`DateTime`): Optional start time, defaults to 10
      minutes ago
    * `end_time` (`DateTime`): Optional end time, defaults to now
    * `limit` (`Int`): Maximum number of entries to return, defaults
      to 1000
    * `query` (`String`): Optional query, for example: where message
      like "pattern"
    '''

    get_aws_agent_logs = sgqlc.types.Field(sgqlc.types.list_of(AgentLogEntry), graphql_name='getAwsAgentLogs', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('pattern', sgqlc.types.Arg(String, graphql_name='pattern', default=None)),
))
    )
    '''Get AWS Agent log entries for a given time period, optionally
    matching a filter

    Arguments:

    * `agent_id` (`UUID!`): AWS Agent ID
    * `start_time` (`DateTime`): Optional start time, defaults to 10
      minutes ago
    * `end_time` (`DateTime`): Optional end time, defaults to now
    * `limit` (`Int`): Maximum number of entries to return, defaults
      to 1000
    * `pattern` (`String`): Optional pattern, for example: %text%
    '''

    start_aws_logs_query = sgqlc.types.Field(AwsAgentStartLogsQueryResult, graphql_name='startAwsLogsQuery', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
        ('end_time', sgqlc.types.Arg(DateTime, graphql_name='endTime', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('query', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='query', default=None)),
))
    )
    '''Get the results of a query started using start_aws_logs_query.

    Arguments:

    * `agent_id` (`UUID!`): Agent ID
    * `start_time` (`DateTime`): Optional start time, defaults to 10
      minutes ago
    * `end_time` (`DateTime`): Optional end time, defaults to now
    * `limit` (`Int`): Maximum number of entries to return, defaults
      to 1000
    * `query` (`String!`): The CloudWatch query following the syntax
      defined at: https://docs.aws.amazon.com/AmazonCloudWatch/latest/
      logs/CWL_QuerySyntax.html. For example: 'fields @timestamp,
      @message | filter @message like "error"'
    '''

    stop_aws_logs_query = sgqlc.types.Field(AwsAgentLogsStopQueryResult, graphql_name='stopAwsLogsQuery', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('query_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='queryId', default=None)),
))
    )
    '''Stops a query started using start_aws_logs_query.

    Arguments:

    * `agent_id` (`UUID!`): Agent ID
    * `query_id` (`String!`): The query_id as returned by
      start_aws_query
    '''

    get_aws_logs_query_results = sgqlc.types.Field(AwsAgentLogsQueryResult, graphql_name='getAwsLogsQueryResults', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('query_id', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='queryId', default=None)),
))
    )
    '''Get the results of a query started using start_aws_logs_query.

    Arguments:

    * `agent_id` (`UUID!`): Agent ID
    * `query_id` (`String!`): The query_id as returned by
      start_aws_query
    '''

    get_aws_agent_upgrade_logs = sgqlc.types.Field(sgqlc.types.list_of(AwsAgentUpgradeLogEntry), graphql_name='getAwsAgentUpgradeLogs', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
        ('limit', sgqlc.types.Arg(Int, graphql_name='limit', default=None)),
        ('start_time', sgqlc.types.Arg(DateTime, graphql_name='startTime', default=None)),
))
    )
    '''Get AWS Agent upgrade log entries from a given start time.

    Arguments:

    * `agent_id` (`UUID!`): AWS Agent ID.
    * `limit` (`Int`): Maximum number of entries to return, defaults
      to 100
    * `start_time` (`DateTime`): Optional start time, defaults to 12
      hours ago
    '''

    get_aws_agent_infra_details = sgqlc.types.Field(AwsAgentInfraDetailsResult, graphql_name='getAwsAgentInfraDetails', args=sgqlc.types.ArgDict((
        ('agent_id', sgqlc.types.Arg(sgqlc.types.non_null(UUID), graphql_name='agentId', default=None)),
))
    )
    '''Get infrastructure information from an AWS Agent like
    CloudFormation template and parameters.

    Arguments:

    * `agent_id` (`UUID!`): Agent ID
    '''

    get_account_secret = sgqlc.types.Field(AccountSecretOutput, graphql_name='getAccountSecret', args=sgqlc.types.ArgDict((
        ('name', sgqlc.types.Arg(sgqlc.types.non_null(String), graphql_name='name', default=None)),
        ('reveal', sgqlc.types.Arg(Boolean, graphql_name='reveal', default=None)),
))
    )
    '''Get an account secret

    Arguments:

    * `name` (`String!`): If the secret name
    * `reveal` (`Boolean`): If the secret value must be returned
    '''

    get_account_secrets = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(sgqlc.types.non_null(AccountSecretOutput))), graphql_name='getAccountSecrets')



class QueryAfterKey(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('user', 'date', 'query_hash')
    user = sgqlc.types.Field(String, graphql_name='user')
    '''The username'''

    date = sgqlc.types.Field(String, graphql_name='date')
    '''The date as a string'''

    query_hash = sgqlc.types.Field(String, graphql_name='queryHash')
    '''The query hash'''



class QueryBlastRadius(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('date', 'username', 'query_hash', 'query_count', 'tables')
    date = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='date')
    '''The date when the query was performed'''

    username = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='username')
    '''The user who ran the query'''

    query_hash = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryHash')
    '''The query hash'''

    query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='queryCount')
    '''The number of times the query was ran'''

    tables = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(String)), graphql_name='tables')
    '''The list of tables in the incident queried'''



class QueryBlastRadius2(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('username', 'last_accessed_date', 'distinct_query_count', 'query_count', 'queries')
    username = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='username')
    '''The user who ran the query'''

    last_accessed_date = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='lastAccessedDate')
    '''The date when the query was performed'''

    distinct_query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='distinctQueryCount')
    '''The number of unique queries the user ran'''

    query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='queryCount')
    '''The number of times the query was ran'''

    queries = sgqlc.types.Field(sgqlc.types.list_of('QueryBlastRadiusData'), graphql_name='queries')
    '''The query data'''



class QueryBlastRadiusData(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('date', 'query_hash', 'query_count', 'tables')
    date = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='date')
    '''The date when the query was performed'''

    query_hash = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryHash')
    '''The query hash'''

    query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='queryCount')
    '''The number of times the query was ran'''

    tables = sgqlc.types.Field(sgqlc.types.list_of('TableInfo'), graphql_name='tables')
    '''The list of tables in the incident queried'''



class QueryBlastRadiusSummary(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('username', 'last_accessed_date', 'distinct_query_count', 'query_count')
    username = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='username')
    '''The user who ran the query'''

    last_accessed_date = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='lastAccessedDate')
    '''The date when the query was performed'''

    distinct_query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='distinctQueryCount')
    '''The number of unique queries the user ran'''

    query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='queryCount')
    '''The number of times the query was ran'''



class QueryDataObject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query_id', 'group_id', 'user_name', 'timestamp', 'query', 'source_display_name', 'destination_display_name', 'error_code', 'error_msg')
    query_id = sgqlc.types.Field(String, graphql_name='queryId')

    group_id = sgqlc.types.Field(String, graphql_name='groupId')

    user_name = sgqlc.types.Field(String, graphql_name='userName')

    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')

    query = sgqlc.types.Field(String, graphql_name='query')

    source_display_name = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='sourceDisplayName')

    destination_display_name = sgqlc.types.Field(String, graphql_name='destinationDisplayName')

    error_code = sgqlc.types.Field(String, graphql_name='errorCode')

    error_msg = sgqlc.types.Field(String, graphql_name='errorMsg')



class QueryDimensions(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('users', 'categories')
    users = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='users')
    '''A distinct list of users for a list of queries'''

    categories = sgqlc.types.Field(sgqlc.types.list_of(QueryCategory), graphql_name='categories')
    '''A distinct list of query categories for a list of queries'''



class QueryGroupSummaryType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query_group_field', 'query_group_value', 'query_snippet', 'user_email', 'query_count', 'avg_runtime', 'max_runtime', 'sum_runtime', 'avg_metric', 'max_metric', 'sum_metric', 'warehouse_uuid', 'destination', 'destination_mcon', 'displayable_field_values')
    query_group_field = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryGroupField')

    query_group_value = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryGroupValue')

    query_snippet = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='querySnippet')

    user_email = sgqlc.types.Field(String, graphql_name='userEmail')
    '''DEPRECATED (use displayableFieldValues)'''

    query_count = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='queryCount')

    avg_runtime = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='avgRuntime')

    max_runtime = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='maxRuntime')

    sum_runtime = sgqlc.types.Field(sgqlc.types.non_null(Float), graphql_name='sumRuntime')

    avg_metric = sgqlc.types.Field(Float, graphql_name='avgMetric')

    max_metric = sgqlc.types.Field(Float, graphql_name='maxMetric')

    sum_metric = sgqlc.types.Field(Float, graphql_name='sumMetric')

    warehouse_uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='warehouseUuid')

    destination = sgqlc.types.Field(String, graphql_name='destination')

    destination_mcon = sgqlc.types.Field(String, graphql_name='destinationMcon')

    displayable_field_values = sgqlc.types.Field(sgqlc.types.list_of(DisplayableFieldValueType), graphql_name='displayableFieldValues')



class QueryListObject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query_id', 'user_name', 'timestamp', 'query_length', 'query_hash', 'sub_category')
    query_id = sgqlc.types.Field(String, graphql_name='queryId')

    user_name = sgqlc.types.Field(String, graphql_name='userName')

    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')

    query_length = sgqlc.types.Field(Int, graphql_name='queryLength')

    query_hash = sgqlc.types.Field(String, graphql_name='queryHash')

    sub_category = sgqlc.types.Field(String, graphql_name='subCategory')



class QueryListResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('queries', 'queries_by_type', 'offset')
    queries = sgqlc.types.Field(sgqlc.types.list_of(QueryListObject), graphql_name='queries')

    queries_by_type = sgqlc.types.Field(sgqlc.types.list_of('QueryMapObject'), graphql_name='queriesByType')

    offset = sgqlc.types.Field(Int, graphql_name='offset')



class QueryLogHash(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query', 'query_hash', 'user_email', 'day', 'count', 'category', 'average_elapsed_time')
    query = sgqlc.types.Field(String, graphql_name='query')
    '''A substring of the query containing the first n characters defined
    by the query_characters parameter in the query
    '''

    query_hash = sgqlc.types.Field(String, graphql_name='queryHash')
    '''Hash of the query'''

    user_email = sgqlc.types.Field(String, graphql_name='userEmail')
    '''User email'''

    day = sgqlc.types.Field(DateTime, graphql_name='day')
    '''Day of the query log hash'''

    count = sgqlc.types.Field(Int, graphql_name='count')
    '''Count of the number of queries with the same hash in the day'''

    category = sgqlc.types.Field(String, graphql_name='category')
    '''Category of the query log hash'''

    average_elapsed_time = sgqlc.types.Field(Int, graphql_name='averageElapsedTime')
    '''Average elapsed time of the query log hash in milliseconds'''



class QueryLogHashes(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('full_table_id', 'offset', 'query_hashes')
    full_table_id = sgqlc.types.Field(String, graphql_name='fullTableId')

    offset = sgqlc.types.Field(Int, graphql_name='offset')

    query_hashes = sgqlc.types.Field(sgqlc.types.list_of(QueryLogHash), graphql_name='queryHashes')



class QueryLogMetadata(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('metadata', 'timestamp')
    metadata = sgqlc.types.Field(String, graphql_name='metadata')

    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')



class QueryLogResponse(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('query_data', 'queries', 'offset')
    query_data = sgqlc.types.Field(QueryDataObject, graphql_name='queryData')

    queries = sgqlc.types.Field(sgqlc.types.list_of(QueryLogMetadata), graphql_name='queries')

    offset = sgqlc.types.Field(Int, graphql_name='offset')



class QueryLogResultType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('timestamp', 'warehouse_uuid', 'query_id', 'query_snippet', 'query', 'query_group', 'user', 'status', 'destination', 'runtime', 'displayable_field_values', 'destination_mcon', 'job_info')
    timestamp = sgqlc.types.Field(sgqlc.types.non_null(DateTime), graphql_name='timestamp')

    warehouse_uuid = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='warehouseUuid')

    query_id = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='queryId')

    query_snippet = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='querySnippet')

    query = sgqlc.types.Field(sgqlc.types.non_null(String), graphql_name='query')

    query_group = sgqlc.types.Field(String, graphql_name='queryGroup')

    user = sgqlc.types.Field(String, graphql_name='user')
    '''DEPRECATED, use displayableFieldValues'''

    status = sgqlc.types.Field(String, graphql_name='status')
    '''DEPRECATED, use displayableFieldValues'''

    destination = sgqlc.types.Field(String, graphql_name='destination')
    '''DEPRECATED, use displayableFieldValues'''

    runtime = sgqlc.types.Field(Int, graphql_name='runtime')

    displayable_field_values = sgqlc.types.Field(sgqlc.types.list_of(DisplayableFieldValueType), graphql_name='displayableFieldValues')

    destination_mcon = sgqlc.types.Field(String, graphql_name='destinationMcon')

    job_info = sgqlc.types.Field(JobInfo, graphql_name='jobInfo')



class QueryLogsFacetResponseType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('field_name', 'facet_results')
    field_name = sgqlc.types.Field(String, graphql_name='fieldName')
    '''Field name'''

    facet_results = sgqlc.types.Field(sgqlc.types.list_of(FacetResultType), graphql_name='facetResults')
    '''Facet results'''



class QueryLogsResponseType(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('total', 'results')
    total = sgqlc.types.Field(sgqlc.types.non_null(Int), graphql_name='total')

    results = sgqlc.types.Field(sgqlc.types.non_null(sgqlc.types.list_of(QueryLogResultType)), graphql_name='results')



class QueryMapObject(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('queries', 'query_length')
    queries = sgqlc.types.Field(sgqlc.types.list_of(QueryListObject), graphql_name='queries')

    query_length = sgqlc.types.Field(Int, graphql_name='queryLength')



class QueryRca(sgqlc.types.Type):
    '''Query RCA result'''
    __schema__ = schema
    __field_names__ = ('table_mcon', 'group_id', 'timestamp', 'type', 'rca_data', 'event_uuid')
    table_mcon = sgqlc.types.Field(String, graphql_name='tableMcon')
    '''MCON of affected table'''

    group_id = sgqlc.types.Field(String, graphql_name='groupId')
    '''Identifier for a grouping of like/same queries'''

    timestamp = sgqlc.types.Field(DateTime, graphql_name='timestamp')
    '''Time RCA was executed'''

    type = sgqlc.types.Field(QueryRcaType, graphql_name='type')
    '''Type of query RCA'''

    rca_data = sgqlc.types.Field(JSONString, graphql_name='rcaData')
    '''Get full rca data'''

    event_uuid = sgqlc.types.Field(sgqlc.types.non_null(UUID), graphql_name='eventUuid')
    '''The uuid connected of the event the RCA is connected to'''



class QueryRef(sgqlc.types.Type):
    __schema__ = schema
    __field_names__ = ('dynamic_fields', 'fields', 'filters', 'model', 'query_timezone', 'url', 'view')
    dynamic_fields = sgqlc.types.Field(String, graphql_name='dynamicFields')

    fields = sgqlc.types.Field(sgqlc.types.list_of(String), graphql_name='fields'