"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartingPosition = exports.EventSourceMapping = exports.SourceAccessConfigurationType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * The type of authentication protocol or the VPC components for your event source's SourceAccessConfiguration
 * @see https://docs.aws.amazon.com/lambda/latest/dg/API_SourceAccessConfiguration.html#SSS-Type-SourceAccessConfiguration-Type
 */
class SourceAccessConfigurationType {
    constructor(type) {
        this.type = type;
    }
    /** A custom source access configuration property */
    static of(name) {
        return new SourceAccessConfigurationType(name);
    }
}
exports.SourceAccessConfigurationType = SourceAccessConfigurationType;
_a = JSII_RTTI_SYMBOL_1;
SourceAccessConfigurationType[_a] = { fqn: "@aws-cdk/aws-lambda.SourceAccessConfigurationType", version: "1.186.1" };
/**
 * (MQ) The Secrets Manager secret that stores your broker credentials.
 */
SourceAccessConfigurationType.BASIC_AUTH = new SourceAccessConfigurationType('BASIC_AUTH');
/**
 * The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your Self-Managed Apache Kafka cluster.
 */
SourceAccessConfigurationType.VPC_SUBNET = new SourceAccessConfigurationType('VPC_SUBNET');
/**
 * The VPC security group used to manage access to your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.VPC_SECURITY_GROUP = new SourceAccessConfigurationType('VPC_SECURITY_GROUP');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.SASL_SCRAM_256_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_256_AUTH');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.SASL_SCRAM_512_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_512_AUTH');
/**
 * The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM),
 * and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
 */
SourceAccessConfigurationType.CLIENT_CERTIFICATE_TLS_AUTH = new SourceAccessConfigurationType('CLIENT_CERTIFICATE_TLS_AUTH');
/**
 * Defines a Lambda EventSourceMapping resource.
 *
 * Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:
 *
 *    import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
 *    lambda.addEventSource(new SqsEventSource(sqs));
 *
 * The `SqsEventSource` class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.
 */
class EventSourceMapping extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_EventSourceMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EventSourceMapping);
            }
            throw error;
        }
        if (props.eventSourceArn == undefined && props.kafkaBootstrapServers == undefined) {
            throw new Error('Either eventSourceArn or kafkaBootstrapServers must be set');
        }
        if (props.eventSourceArn !== undefined && props.kafkaBootstrapServers !== undefined) {
            throw new Error('eventSourceArn and kafkaBootstrapServers are mutually exclusive');
        }
        if (props.kafkaBootstrapServers && (props.kafkaBootstrapServers?.length < 1)) {
            throw new Error('kafkaBootStrapServers must not be empty if set');
        }
        if (props.maxBatchingWindow && props.maxBatchingWindow.toSeconds() > 300) {
            throw new Error(`maxBatchingWindow cannot be over 300 seconds, got ${props.maxBatchingWindow.toSeconds()}`);
        }
        if (props.maxRecordAge && (props.maxRecordAge.toSeconds() < 60 || props.maxRecordAge.toDays({ integral: false }) > 7)) {
            throw new Error('maxRecordAge must be between 60 seconds and 7 days inclusive');
        }
        props.retryAttempts !== undefined && cdk.withResolved(props.retryAttempts, (attempts) => {
            if (attempts < 0 || attempts > 10000) {
                throw new Error(`retryAttempts must be between 0 and 10000 inclusive, got ${attempts}`);
            }
        });
        props.parallelizationFactor !== undefined && cdk.withResolved(props.parallelizationFactor, (factor) => {
            if (factor < 1 || factor > 10) {
                throw new Error(`parallelizationFactor must be between 1 and 10 inclusive, got ${factor}`);
            }
        });
        if (props.tumblingWindow && !cdk.Token.isUnresolved(props.tumblingWindow) && props.tumblingWindow.toSeconds() > 900) {
            throw new Error(`tumblingWindow cannot be over 900 seconds, got ${props.tumblingWindow.toSeconds()}`);
        }
        let destinationConfig;
        if (props.onFailure) {
            destinationConfig = {
                onFailure: props.onFailure.bind(this, props.target),
            };
        }
        let selfManagedEventSource;
        if (props.kafkaBootstrapServers) {
            selfManagedEventSource = { endpoints: { kafkaBootstrapServers: props.kafkaBootstrapServers } };
        }
        const cfnEventSourceMapping = new lambda_generated_1.CfnEventSourceMapping(this, 'Resource', {
            batchSize: props.batchSize,
            bisectBatchOnFunctionError: props.bisectBatchOnError,
            destinationConfig,
            enabled: props.enabled,
            eventSourceArn: props.eventSourceArn,
            functionName: props.target.functionName,
            startingPosition: props.startingPosition,
            functionResponseTypes: props.reportBatchItemFailures ? ['ReportBatchItemFailures'] : undefined,
            maximumBatchingWindowInSeconds: props.maxBatchingWindow?.toSeconds(),
            maximumRecordAgeInSeconds: props.maxRecordAge?.toSeconds(),
            maximumRetryAttempts: props.retryAttempts,
            parallelizationFactor: props.parallelizationFactor,
            topics: props.kafkaTopic !== undefined ? [props.kafkaTopic] : undefined,
            tumblingWindowInSeconds: props.tumblingWindow?.toSeconds(),
            sourceAccessConfigurations: props.sourceAccessConfigurations?.map((o) => { return { type: o.type.type, uri: o.uri }; }),
            selfManagedEventSource,
        });
        this.eventSourceMappingId = cfnEventSourceMapping.ref;
    }
    /**
     * Import an event source into this stack from its event source id.
     */
    static fromEventSourceMappingId(scope, id, eventSourceMappingId) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.eventSourceMappingId = eventSourceMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.EventSourceMapping = EventSourceMapping;
_b = JSII_RTTI_SYMBOL_1;
EventSourceMapping[_b] = { fqn: "@aws-cdk/aws-lambda.EventSourceMapping", version: "1.186.1" };
/**
 * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start
 * reading.
 */
var StartingPosition;
(function (StartingPosition) {
    /**
     * Start reading at the last untrimmed record in the shard in the system,
     * which is the oldest data record in the shard.
     */
    StartingPosition["TRIM_HORIZON"] = "TRIM_HORIZON";
    /**
     * Start reading just after the most recent record in the shard, so that you
     * always read the most recent data in the shard
     */
    StartingPosition["LATEST"] = "LATEST";
})(StartingPosition = exports.StartingPosition || (exports.StartingPosition = {}));
//# sourceMappingURL=data:application/json;base64,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