var SwaggerSpec = {"info": {"version": "1.0", "description": "Arifname API will run on Google App Engine, Google Cloud SQL will be used for database and Google Cloud Storage will be\nused to store the files. During the development, the API will run on `arifname.appspot.com` and the changes will be pushed from the `api_test` branch\non [BitBucket](https://bitbucket.org/edmoware/arifnameapi).\n\n# Overview\n\nArifname is a service that is used to give people legit Islamic dream interpretations along with others. There are 2 kinds of users: `Customer` and\n`Interpreter`. When a `Customer` wants en interpretation it will be directed to a specific `Interpreter`. If that `Interpreter` doesn't answer the\nreuqest, then the `Interpretation` can fall into the pool where other `Interpreter`s can pick it up.\nCurrent interpretation categories are `dream`, `graphology`, `physionomy`, `elfabe`, `yildizname`, and `elsima`.\n\nWith the use of the `CategoryType` model, admins can dynamically add new categories without the need for an API or app update. This gives us the\nflexibility to give a better service to the customers.\n\n`Admin`, `Customer`, and `Interpreter` will login and signup using only the email.\n\nA user with the same email can only have one type of account. The same email address cannot belong to both `Customer` and `Interpreter` and `Admin`.\n\nYou can find the **Postman Collection** link [here](https://www.getpostman.com/collections/064614d9dcfe71e11ad9).\n\n# API Headers\n\n## Accept\n\n`Accept` header versioning is used for the API. So you need to include the version you want to use when making a request.\nCurrent version is `1.0` so a request **MUST** have the following `Accept` header: `Accept: application/json; version=1.0`\n\nOptionaly, you can omit the `Accept` header in which case the API will use whatever version is the default at the time of the request. But this can\nlead to problems when the API changes the default version. And different versions may have code-breaking changes.\n\n## Content-Type\n\nEvery request will be made with `JSON` format so the header is `Content-Type: application/json`.\nThis header is **REQUIRED** when making a request.\n\n## Authorization\n\nJava Script Web Token is used for authorization. By default, tokens are valid for 30 days. If for any reason the token was invalidated, a response with\nthe error will be returned with `HTTP 403`.\nThis header is **REQUIRED** when making a request except the register requests (User, Interpreter, and Admin).\n\n**Header**: `Authorization: JWT <YOUR_TOKEN_KEY>`\n\n## Accept-Language\n\n`Accept-Language` header is used to translate the error messages, and other translatable fields. Every translateble field is marked so in the\ndefinitions.\nLanguage codes are in ISO 639-1 standard.\n\n## Origin\n\nThe `Origin` header is used to determine the origin of the request. If you are sending the request from a browser, you can use\n[this](https://github.com/Valve/fingerprintjs2) library to get browser fingerprint. This header **MUST** be present in `/login/` request.\n\n### Examples\n\n**Browser**\n\n`Origin: web FINGER_PRINT`\n\n**iOS**\n\n`Origin: ios DEVICE_ID`\n\n**For Android**\n\n`Origin: android DEVICE_ID`\n\n# Error Codes\n\nError codes are different from the HTTP codes. These are custom values that are defined to represent an error.\n\n| Name                         | Value | Description                                                                                        |\n|------------------------------|-------|----------------------------------------------------------------------------------------------------|\n| unknown                      | -1    | The error is unknown                                                                               |\n| unsupported_version          | 10    | Accept header contains an unsupported version                                                      |\n| parameter_error              | 11    | A parameter error occurred. Check the `parameters` key                                             |\n| user_is_not_admin            | 12    | User is not an admin                                                                               |\n| insufficient_permissions     | 13    | User doesn't have the permission to complete the action                                            |\n| category_type_no_exist       | 14    | The category type with the given ID doesn't exist.                                                 |\n| already_exists               | 15    | This is a generic error that is raised when an item that's already in the database is added again. |\n| country_no_exist             | 16    | The country with the given ID doesn't exist.                                                       |\n| city_no_exist                | 17    | The city with the given ID doesn't exist.                                                          |\n| lang_no_exist                | 18    | The language with the given ID doesn't exist.                                                      |\n| admin_no_exist               | 19    | The admin with the given ID doesn't exist.                                                         |\n| missing_token                | 20    | The token is missing from the headers.                                                             |\n| invalid_token                | 21    | The provided token is not valid.                                                                   |\n| customer_no_exist            | 22    | The customer with the given ID doesn't exist.                                                      |\n| interpretation_no_exist      | 23    | The interpretation with the given ID doesn't exist.                                                |\n| credit_package_no_exist      | 24    | The credit package with the given ID doesn't exist.                                                |\n| interpreter_no_exist         | 25    | The interpreter with the given ID doesn't exist.                                                   |\n| interpreter_payment_no_exist | 25    | The interpreter with the given ID doesn't exist.                                                   |\n\n# HTTP Codes\n\nEvery request to the API returns an appropriate HTTP response code along with an error message and a special error code If the request resulted in an\nerror.\nYou can check the HTTP codes [here](https://httpstatuses.com/)\n\n## HTTP 401 vs HTTP 403\n\nFor a clean explanation, see [here](http://www.dirv.me/blog/2011/07/18/understanding-403-forbidden/index.html).\n\n# Admin System\n\nAn `Admin` has the right to access any content for `Customer` and `Interpreter`. An `Admin` cannot change personal information about a `Customer` and\n`Interpreter`.\n\n## Admin Permissions\n\nAdmins have different permissions and an admin must have the associated permission for an action to be able to complete it.\nAll admins have permissions for the safe methods (`GET`, `HEAD`, `OPTIONS`).\n\nWhen an insufficient_permissions error raised, you can get the detailed information in `user` key that's in the `parameters` key of the returned error.\n\n| Name                              | Codename                       | Description                                                                                        | Default | Type  |\n|-----------------------------------|--------------------------------|----------------------------------------------------------------------------------------------------|---------|-------|\n| Can view                          | is_admin                       | This is the default permission that every Admin is created with. This only allows read-only acess. | True    | admin |\n| Is supervisor                     | is_supervisor                  | A user with this permission is supervisor                                                          | False   | admin |\n| Can edit admin permissions        | can_edit_permissions           | This admin can add and remove permissions from other admins                                        | False   | admin |\n| Can ban users                     | can_ban                        | The admin has the permission to ban users and update the ban information.                          | True    | admin |\n| Can create promotions             | can_create_promotion           | An admin with this permission has full access to promotions                                        | False   | admin |\n| Can create special offers         | can_create_special_offers      | An admin with this permission has full access to special offers                                    | False   | admin |\n| Can edit admins                   | can_edit_admin                 | An admin with this permission can register, update and delete admins                               | False   | admin |\n| Can add purchase to customer      | can_create_purchase            | An admin with this permission can add credit to a customer's account                               | True    | admin |\n| Can add payment to interpretation | can_create_payment             | An admin with this permission can pay the credit for an interpretation                             | True    | admin |\n| Can add payment to interpreter    | can_create_interpreter_payment | An admin with this permission can pay an interpreter                                               | False   | admin |\n| Can update interpretation         | can_edit_interpretation        | An admin with this permission can edit an interpretation                                           | True    | admin |\n| Can edit category types           | can_edit_category_type         | An admin with this permission can edit a category type and add new ones                            | False   | admin |\n| Can edit country                  | can_edit_country               | An admin with this permission can add a new country to the list of countries                       | True    | admin |\n| Can edit languages                | can_edit_language              | An admin with this permission can add a new language to the list of languages                      | True    | admin |\n\n# List of Fields with Multpile Choices\n\n## General\n\n**gender**\n\n| Value | Name    |\n|-------|---------|\n| 0     | none    |\n| 1     | male    |\n| 2     | female  |\n\n### Customer\n\n**registration_method**\n\nThis is always set to `email` unless it is explictly set to something else.\n\n| Value | Name     |\n|-------|----------|\n| 0     | none     |\n| 1     | email    |\n| 2     | facebook |\n| 3     | google   |\n| 4     | twitter  |\n\n\n**customer_type**\n\n| Value | Name    |\n|-------|---------|\n| 0     | none    |\n| 1     | regular |\n| 2     | silver  |\n| 3     | gold    |\n| 4     | premium |\n\n**relationship**\n\n| Value | Name            |\n|-------|-----------------|\n| 0     | none            |\n| 1     | single          |\n| 2     | married         |\n| 3     | in_relationship |\n\n**status**\n\n| Value | Name            |\n|-------|-----------------|\n| 0     | none            |\n| 1     | banned          |\n| 2     | active          |\n\n## Purchase\n\n**platform**\n\n| Value | Name    |\n|-------|---------|\n| 0     | none    |\n| 1     | ios     |\n| 2     | android |\n| 3     | web     |\n\n## Interpreter\n\n**status**\n\n| Value | Name             |\n|-------|------------------|\n| 0     | none             |\n| 1     | banned           |\n| 2     | active           |\n| 3     | waiting_approval |\n| 4     | declined         |\n\n**preferred_response_type**\n\n| Value | Name  |\n|-------|-------|\n| 0     | none  |\n| 1     | both  |\n| 2     | text  |\n| 3     | voice |\n\n## Interpretation\n\n**status**\n\n| Value | Name             |\n|-------|------------------|\n| 0     | none             |\n| 1     | in_proggress     |\n| 2     | in_queue         |\n| 3     | in_pool          |\n| 4     | waiting_approval |\n\n**response_type** and **request_type**\n\n| Value | Name             |\n|-------|------------------|\n| 0     | none             |\n| 1     | voice            |\n| 2     | text             |\n\n## Message\n\n**to and from**\n\n| Value | Name             |\n|-------|------------------|\n| 0     | none             |\n| 1     | customer         |\n| 2     | interpreter      |\n\n# Notes\n\n## General\n\n- Since every model has the `id` field associated with it, it is ommitted from the definitions in this documentation.\n\n## Payment vs InterpreterPayment\n\n`Payment` is only in credit while `InterpreterPayment` is only in real money.\n`Payment` is done to an interpreter by a customer and `InterpreterPayment` is done to an interpreter by an admin.\n\n# TODO\n\n- [ ] Find a way to authenenticate the client so only the official clients can reach to the API\n- [ ] Interpreters cannot set their of price. Admins can.\n- [ ] Interpreters will not be able to see the customer information\n- [ ] Add preferred response type for interpreter.\n- [ ] Add the option to delete interpretation.\n\n- [ ] Add timeout to interpretation -> Cancel / Re-assign interpreter\n\n# Known Issues With the Documentation\n\n- When using `$ref` in `parameters`, the Swagger Editor gives an `invalid parameter` error. But the renderin of the documentation is done correctly. For\n  more information on the error see [this](https://github.com/swagger-api/swagger-editor/issues/1156) issue.\n", "title": "Arifname API"}, "paths": {"/admins/register/": {"post": {"responses": {"201": {"description": "Successful registration", "schema": {"$ref": "#/definitions/Admin"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "An `Admin` account **must** be created at this endpoint. The `/login/` endpoint will **NOT** register a new `Admin`.\nOnly a **supervisor** can create an `Admin` account. The `registration_method` is `email` by default for the admins.\nWhen a new admin is registered, all of the default permissions are given to the admin. Additional permissions can later be added.\n", "parameters": [{"required": true, "in": "body", "description": "The required values are `email`, `first_name` and `last_name`. The rest can be updated by the account owner.\n", "name": "body", "schema": {"$ref": "#/definitions/UserCreate"}}], "tags": ["Admin Actions"], "summary": "Create an `Admin` account"}}, "/login/": {"post": {"responses": {"200": {"description": "The account already exists and a login link is sent to the user's email."}, "201": {"description": "The customer is registered. This means that the account didn't exists before."}, "400": {"description": "Bad request. Usually means that a parameter was wrong.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is accessible by anoyone. All of the user types login with only their emails to the API. So only one endpoint is used for this.\n\n`Customer` and `Interpreter` in Arifname API will be using the email only signup/login flow.\n`Admin` **can only login**, they cannot register with this endpoint. Admins are added by a supervisor. And the supervisor account is added manually.\n\nThe `Origin` header will be used to determine which type of link to send. If the request is from a browser, then the **web link** will be used. If the\nreqeust is from a mobile deivce, then the **mobile link** will be used.\n\nThe URL schema for the login/signup link is as follows:\n\n# Mobile Link\n\n```\narifname://<device_id>:<token_key>:<link_type>:<account_type>\n```\n\n# Web Link\n\n```\narifname.com/?link_type=<link_type>&device_id=<device_id>&token=<token_key>&account_type=<account_type>\n```\n\n# `link_type` Options\n\n| Name   | Description                                                                                                        |\n|--------|--------------------------------------------------------------------------------------------------------------------|\n| login  | The email already exists in the system and this URL is a URL for the login process.                                |\n| signup | The email does not exist in the system, so this is the first time user is loging in. This is the registration URL. |\n\n# `account_type` Options\n\n| Name        | Description                                                        |\n|-------------|--------------------------------------------------------------------|\n| admin       | The user who is loging in with account type key is an admin        |\n| customer    | The user who is loging in with this account type is a customer     |\n| interpreter | The user who is loging in with this account type is an interpreter |\n\n### Note\n\nDuring development the above link will be sent in the following format as a HTTP response\n\n```\n{\n    \"link\": \"THE_LINK\"\n}\n```\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"type": "object", "properties": {"registration_id": {"type": "string", "description": "Required when a customer or interpreter is signing up"}, "account_type": {"format": "char[256]", "type": "string", "example": "not_a_password_12345", "description": "See the options at the top of the documentation. This field is used when the given email does not exist in the database. If this is the case\nand this field isn't provided, you'll get an `HTTP 400` error.\n"}, "email": {"format": "email", "type": "string", "example": "example@email.com", "description": "Email for the user"}, "registration_method": {"type": "integer", "description": "Required when a customer or interpreter is signing up"}}}}], "tags": ["Customer Actions", "Interpreter Actions", "Admin Actions"], "summary": "This is where you login/signup a new user"}}, "/transactions/interpreter-payments/": {"get": {"responses": {"200": {"description": "Successful", "schema": {"type": "object", "properties": {"next_page": {"type": "integer", "description": "Use this to get to the next page"}, "has_previous_page": {"type": "boolean", "description": "This will be true If you can navigate to the previous page"}, "paid_credit_amount": {"type": "integer", "description": "This is the credit amount paid to interpreters after the `start_date`, `end_date`, `currency` and `interpreter` filters are applied.\n", "format": "int32"}, "unpaid_credit_amount": {"type": "integer", "description": "This is the credit amount unpaid to interpreters after the `start_date`, `end_date`, `currency` and `interpreter` filters are applied.\n", "format": "int32"}, "previous_page": {"type": "integer", "description": "Use this to get to the previous page"}, "page_count": {"type": "integer", "description": "Total page count"}, "total_paid_credit_amount": {"type": "integer", "description": "This is the credit amount paid to interpreters in total.", "format": "int32"}, "has_next_page": {"type": "boolean", "description": "This will be true If you can navigate to the next page"}, "total_unpaid_credit_amount": {"type": "integer", "description": "This is the credit amount unpaid to interpreters in total.", "format": "int32"}, "interpreter_payments": {"items": {"$ref": "#/definitions/InterpreterPayment"}, "type": "array"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This is only accessible by `Admin`. If the authenenticated user is `Interpreter`, then the ID of the `Interpreter` must belong to the authenenticated\nuser.\n", "parameters": [{"required": false, "type": "integer", "name": "interpreter", "in": "query"}, {"required": false, "type": "string", "name": "payment_date_start", "in": "query", "format": "dateTime"}, {"required": false, "type": "string", "name": "payment_date_end", "in": "query", "format": "dateTime"}, {"in": "query", "description": "If it doesn't exist, defaults to `try` for now.", "format": "char[4]", "required": true, "type": "string", "name": "currency"}], "tags": ["Admin Actions", "Interpreter Actions"], "summary": "List the payments interpreter received"}}, "/countries/{country_id}/": {"delete": {"responses": {"200": {"description": "Successful"}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The user has no access here", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This method is only available for `Admin`. When a country is deleted, every city associated with it is also deleted.\n", "parameters": [{"required": true, "type": "integer", "name": "country_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions"], "summary": "Delete country"}}, "/languages/{language_id}/": {"delete": {"responses": {"200": {"description": "Successful"}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The user has no access here", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This method is only available for `Admin`.\n", "parameters": [{"required": true, "type": "integer", "name": "language_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions"], "summary": "Delete language"}}, "/transactions/interpreter-payments/{payment_id}/": {"get": {"responses": {"200": {"description": "Successful", "schema": {"$ref": "#/definitions/InterpreterPayment"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This is only accessible by `Admin` and `Interpreter`. You can provide only the changed parts.\n", "parameters": [{"required": true, "type": "integer", "name": "payment_id", "in": "path"}], "tags": ["Admin Actions"], "summary": "Get payment"}}, "/category-types/new/": {"post": {"responses": {"201": {"description": "Successful", "schema": {"$ref": "#/definitions/CategoryType"}}, "403": {"description": "The user has no access here", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This method is only available for `Admin`. This is wehere a new category type is added. The admin must have the permission to add category types.\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/CategoryType"}}], "tags": ["Admin Actions"], "summary": "Add category type"}}, "/credit-packages/new/": {"post": {"responses": {"200": {"description": "successful", "schema": {"$ref": "#/definitions/CreditPackage"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is accessible by `Admin`.\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/CreditPackage"}}], "tags": ["Admin Actions"], "summary": "Add credit credit package"}}, "/token-refresh": {"post": {"responses": {"200": {"description": "Successful response", "schema": {"type": "object", "properties": {"token": {"type": "string"}}}}}, "description": "Use this endpoint to refresh a token. Every token has an expiration of 30 days. After that, a token **must** be refreshed.", "parameters": [{"required": true, "in": "body", "description": "The old token for the client", "name": "body", "schema": {"type": "object", "properties": {"token": {"type": "string"}}}}], "tags": ["Admin Actions", "Customer Actions", "Interpreter Actions"], "summary": "Refresh a token"}}, "/transactions/purchases/new/": {"post": {"responses": {"400": {"description": "Bad request. This is usually becuase of a parameter error or insufficent funds", "schema": {"$ref": "#/definitions/Error"}}, "201": {"description": "Successful.", "schema": {"$ref": "#/definitions/Purchase"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "The interpretation does not exist.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only accessible by the `Customer` and `Admin`. Any other user trying to access here will return an `HTTP 403` error.\nUse this endpoint to add a purchase to the `Interpretation`. A `Purchase` can only be added for an `Interpretation`.\n\nIf an `Admin` is adding a purchase, s/he needs to give a reason for doing so. When adding a purchase, the user must have enough credits to\nafford the purchase.\n\nThe conditions for adding a purchase:\n- The customer field must **not** be empty.\n- If an admin is adding the purchase, s/he **must** give provide the reason.\n- If the purchase is being added by the customer these fields **must** be present: `platform`, `transaction_id`\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/PurchaseCreate"}}], "tags": ["Customer Actions", "Admin Actions"], "summary": "Add a purchase"}}, "/languages/": {"get": {"responses": {"200": {"description": "Returns the list of languages", "schema": {"type": "object", "properties": {"languages": {"items": {"$ref": "#/definitions/Language"}, "type": "array"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "tags": ["Admin Actions", "Customer Actions", "Interpreter Actions"], "description": "This endpoint is used to list the languages in the database.\n\nAny user type can access this endpoint, but they must be authenenticated.\n", "summary": "List the available languages"}}, "/transactions/interpreter-payments/new/": {"post": {"responses": {"201": {"description": "Successful", "schema": {"$ref": "#/definitions/InterpreterPayment"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This is where the admin adds payment to the interpreter. This is used when we send the money we owe for the unpaid credits that the interpreter has.\nThis is only accessible by `Admin`.\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/InterpreterPaymentCreate"}}], "tags": ["Admin Actions"], "summary": "Add payment to the interpreter"}}, "/customers/{customer_id}/": {"get": {"responses": {"200": {"description": "Customer detail", "schema": {"$ref": "#/definitions/Customer"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "The customer with the given ID doesn't exist.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only accessible by the admins. When anyone other than admins try to access here, they will get a `HTTP 403` error.\n", "parameters": [{"required": true, "type": "integer", "name": "customer_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions"], "summary": "This endpoint returns the customer profile details for given `customer_id`"}}, "/countries/new/": {"post": {"responses": {"400": {"description": "Bad request. Ususally means parameter error.", "schema": {"$ref": "#/definitions/Error"}}, "201": {"description": "Successful", "schema": {"$ref": "#/definitions/Country"}}, "403": {"description": "The user has no access here", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This method is only available for `Admin`. This is wehere a new country is added. A country with the same language cannot be added twice. When a country\nexists but the name for the given language doesn't exist, a new translation is created.\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/CountryCreate"}}], "tags": ["Admin Actions"], "summary": "Add new country"}}, "/customer/": {"put": {"responses": {"200": {"description": "Successful update", "schema": {"$ref": "#/definitions/Customer"}}, "304": {"description": "No changes were made to the profile"}, "400": {"description": "Bad request. This is usually becuase of a parameter error", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "In this endpoint, the authenenticated user can update his/her profile information. Since the profile information will be taken from the given token\nkey, If the authenenticated user is not a customer they will get an `HTTP 403` error.\n\nNone of the properties here are required. You can provide just the ones that you want updated.\n\nAlthough when presenting the `Customer` we separate the `User` part, you can ignore that and just give update for fields from both `Customer` and\n`User`. The API will set them apart and update them accordingly.\n\nThe following fields cannot be changed:\n\n- `registration_method`\n- `registration_id`\n- `is_active`\n- `date_joined`\n\n**Example**\n```\n{\n    \"first_name\": \"James\",\n    \"last_name\": \"Hawlett\",\n    \"gender\": 1\n}\n```\n", "parameters": [{"required": true, "in": "body", "description": "Email for the user", "name": "body", "schema": {"$ref": "#/definitions/Customer"}}], "tags": ["Customer Actions"], "summary": "Update the customer profile."}, "get": {"responses": {"200": {"description": "Customer detail", "schema": {"$ref": "#/definitions/Customer"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "tags": ["Customer Actions"], "description": "In this endpoint, an authenenticated user can get the details about her/his profile. This endpoint is only accessible  by the authenenticated user\nwho is a `Customer`. Non-authenthicated users cannot access here and If an authenenticated user who is not a `Customer` accesses this endpoint, API\nwill return a `HTTP 403` error.\n", "summary": "This endpoint returns the customer profile details for the authenenticated user."}}, "/admins/": {"get": {"responses": {"200": {"description": "An array of admins", "schema": {"type": "object", "properties": {"next_page": {"type": "integer", "description": "Use this to get to the next page. It will be null If the next page doesn't exist."}, "has_previous_page": {"type": "boolean", "description": "This will be true If you can navigate to the previous page"}, "total_admin_count": {"type": "integer", "description": "Total number of admin accounts"}, "previous_page": {"type": "integer", "description": "Use this to get to the previous page. It will be null If the previous page doesn't exist."}, "page_count": {"type": "integer", "description": "Total page count"}, "admins": {"items": {"$ref": "#/definitions/Admin"}, "type": "array"}, "has_next_page": {"type": "boolean", "description": "This will be true If you can navigate to the next page"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "If the authenenticated user is an admin, s/he can use this endpoint to list the admins with support for filtering. If no filter is given, all of the\nadmins are listed. This endpoint is restricted for any user other than an `Admin`.\n\nIf `email`, `first_name` or `last_name` filters are given, they are used first with OR operator to filter the admins and then the other filters are\nused with AND operator.\n", "parameters": [{"required": false, "type": "string", "name": "email", "in": "query", "format": "email"}, {"required": false, "type": "string", "name": "first_name", "in": "query", "format": "char[32]"}, {"required": false, "type": "string", "name": "last_name", "in": "query", "format": "char[32]"}, {"in": "query", "description": "The page to show. If this is not provided, the first page will be returned.", "format": "int32", "required": false, "type": "integer", "name": "page"}, {"in": "query", "description": "The number of admins to show in a list. This defaults to 10", "format": "int32", "required": false, "type": "integer", "name": "page_item_count"}, {"in": "query", "description": "The beginning date to look for users. `date_joined_end` parameters is not required for this parameter to work.", "format": "date", "required": false, "type": "string", "name": "date_joined_start"}, {"in": "query", "description": "The end date to look for users. `date_joined_start` parameters is not required for this parameter to work.", "format": "date", "required": false, "type": "string", "name": "date_joined_end"}, {"in": "query", "description": "The country ID", "format": "int32", "required": false, "type": "integer", "name": "country"}, {"in": "query", "description": "The city ID", "format": "int32", "required": false, "type": "integer", "name": "city"}, {"in": "query", "description": "The language ID", "format": "int32", "required": false, "type": "integer", "name": "language"}, {"in": "query", "description": "See the options at the top of the documentation", "format": "int32", "required": false, "type": "integer", "name": "gender"}], "tags": ["Admin Actions"], "summary": "This endpoint lists the admins. It can only be accessed by an `Admin`"}}, "/admins/{admin_id}/permissions/": {"post": {"responses": {"304": {"description": "No changes have been made."}, "201": {"description": "Successfully added permissions. Returns all of the permissions of the admin.", "schema": {"type": "object", "properties": {"permissions": {"items": {"$ref": "#/definitions/Permission"}, "type": "array"}}}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "An admin with the given ID doesn't exist.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only available to admins who has the `can_edit_permissions` permission.", "parameters": [{"required": true, "type": "integer", "name": "admin_id", "in": "path", "format": "int32"}, {"required": true, "in": "body", "name": "body", "schema": {"type": "object", "properties": {"permissions": {"items": {"type": "string", "description": "Permission codename"}, "type": "array"}}}}], "tags": ["Admin Actions"], "summary": "Add permissions to admin"}, "delete": {"responses": {"200": {"description": "Successfully deleted permissions. Returns all of the permissions of the admin.", "schema": {"type": "object", "properties": {"permissions": {"items": {"$ref": "#/definitions/Permission"}, "type": "array"}}}}, "304": {"description": "No changes have been made."}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "An admin with the given ID doesn't exist.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only available to supervisors.", "parameters": [{"required": true, "type": "integer", "name": "admin_id", "in": "path", "format": "int32"}, {"required": true, "in": "body", "name": "body", "schema": {"type": "object", "properties": {"permissions": {"items": {"type": "string", "description": "Permission codename"}, "type": "array"}}}}], "tags": ["Admin Actions"], "summary": "Delete permissions from admin"}, "get": {"responses": {"200": {"description": "Successful", "schema": {"type": "object", "properties": {"permissions": {"items": {"$ref": "#/definitions/Permission"}, "type": "array"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "An admin with the given ID doesn't exist.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only available to supervisors.", "parameters": [{"required": true, "type": "integer", "name": "admin_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions"], "summary": "List admin permissions"}}, "/transactions/payments/": {"get": {"responses": {"200": {"description": "successful", "schema": {"type": "object", "properties": {"next_page": {"type": "integer", "description": "Use this to get to the next page"}, "has_previous_page": {"type": "boolean", "description": "This will be true If you can navigate to the previous page"}, "previous_page": {"type": "integer", "description": "Use this to get to the previous page"}, "page_count": {"type": "integer", "description": "Total page count"}, "total_payment_count": {"type": "integer", "description": "The total count of payments made by this customer"}, "has_next_page": {"type": "boolean", "description": "This will be true If you can navigate to the next page"}, "payments": {"items": {"$ref": "#/definitions/PaymentSummary"}, "type": "array"}, "spent_credit_amount": {"type": "integer", "description": "For the time between `start_date` and `end_date`"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is accessible by `Customer` and `Admin`.\nPayments are listed here.\n`customer` and `interpreter` filters cannot be used simultaneously, you'll get an error If you do.\n", "parameters": [{"required": true, "type": "integer", "name": "last_x_payments", "in": "query"}, {"required": false, "type": "integer", "description": "The number of items to show in one page. This is applied to both payments and purchases.", "in": "query", "name": "page_item_count"}, {"required": false, "type": "integer", "description": "The page number to show", "in": "query", "name": "page"}, {"required": false, "type": "integer", "description": "Available only for `Admin`. If a customer is accessing, this will be filled with the authenticated customer so you don't neeed to use it. If this\nfilter is omitted, all of the payments are listed.\n", "in": "query", "name": "customer"}, {"required": false, "type": "integer", "description": "Available only for `Admin`. If an interpreter is accessing, this will be filled with the authenticated interpreter so you don't neeed to use it.\nIf this filter is omitted, all of the payments are listed.\n", "in": "query", "name": "interpreter"}, {"required": false, "type": "integer", "description": "The Interpretation ID", "in": "query", "name": "interpretation"}, {"required": false, "type": "string", "name": "start_date", "in": "query", "format": "dateTime"}, {"required": false, "type": "string", "name": "end_date", "in": "query", "format": "dateTime"}], "tags": ["Customer Actions", "Interpreter Actions", "Admin Actions"], "summary": "List payments"}}, "/interpreters/{interpreter_id}/": {"patch": {"responses": {"200": {"description": "Successful", "schema": {"$ref": "#/definitions/Interpreter"}}, "304": {"description": "No changes have been made."}, "400": {"description": "Bad request. Usually means parameter error", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only accessible by the admins. When anyone other than admins try to access here, they will get an\n`HTTP 403` error.\n", "parameters": [{"required": true, "type": "integer", "name": "interpreter_id", "in": "path", "format": "int32"}, {"required": true, "in": "body", "description": "See the options at the top of the documentation", "name": "body", "schema": {"type": "object", "properties": {"status": {"type": "integer", "format": "int32"}}}}], "tags": ["Admin Actions"], "summary": "Accept or deny the Interpreter his/her interpreter status"}, "get": {"responses": {"200": {"description": "Interpreter detail", "schema": {"$ref": "#/definitions/Interpreter"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only accessible by the admins and the customers. When anyone other than admins and customers try to access here, they will get an\n`HTTP 403` error.\n", "parameters": [{"required": true, "type": "integer", "name": "interpreter_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions", "Customer Actions"], "summary": "This endpoint returns the interpreter profile details for given `interpreter_id`"}}, "/interpreters/": {"get": {"responses": {"200": {"description": "An array of interpreters", "schema": {"type": "object", "properties": {"next_page": {"type": "integer", "description": "Use this to get to the next page"}, "has_previous_page": {"type": "boolean", "description": "This will be true If you can navigate to the previous page"}, "total_interpreter_count": {"type": "integer", "description": "The total number of Interpreters"}, "interpreters": {"items": {"$ref": "#/definitions/Interpreter"}, "type": "array"}, "previous_page": {"type": "integer", "description": "Use this to get to the previous page"}, "page_count": {"type": "integer", "description": "Total page count"}, "has_next_page": {"type": "boolean", "description": "This will be true If you can navigate to the next page"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "Interpreters can be listed here by `Admin` and `Interpreter` with support for filtering.\n\n# Interpreter Filtering Exception\n\nWhen a customer is filtering, some information is kept from the customer.\n\nOnly the following filters are allowed for `Customer`:\n- page\n- page_item_count\n- category_type\n- language\n", "parameters": [{"in": "query", "description": "The page to show. If this is not provided, the first page will be returned.", "format": "int32", "required": false, "type": "integer", "name": "page"}, {"in": "query", "description": "The number of admins to show in a list. This defaults to 10", "format": "int32", "required": false, "type": "integer", "name": "page_item_count"}, {"in": "query", "description": "The beginning date to look for interpreters. `date_joined_end` parameters is not required for this parameter to work.", "format": "date", "required": false, "type": "string", "name": "date_joined_start"}, {"in": "query", "description": "The end date to look for interpreters. `date_joined_start` parameters is not required for this parameter to work.", "format": "date", "required": false, "type": "string", "name": "date_joined_end"}, {"in": "query", "description": "See the options at the top of the documentation", "format": "int32", "required": false, "type": "integer", "name": "registration_method"}, {"in": "query", "description": "The country ID", "format": "int32", "required": false, "type": "integer", "name": "country"}, {"in": "query", "description": "The city ID", "format": "int32", "required": false, "type": "integer", "name": "city"}, {"in": "query", "description": "The language ID", "format": "int32", "required": false, "type": "integer", "name": "language"}, {"in": "query", "description": "See the options at the top of the documentation", "format": "int32", "required": false, "type": "integer", "name": "gender"}, {"in": "query", "description": "This is the `CategoryType` ID. List the interpreters who does this type of interpretation.", "format": "int32", "required": false, "type": "integer", "name": "category_type"}, {"required": false, "type": "string", "description": "See the options at the top of the documentation", "in": "query", "name": "status"}], "tags": ["Admin Actions", "Interpreter Actions"], "summary": "This endpoint lists the interpreters for `Admin` and `Interpreter`."}}, "/admin/": {"put": {"responses": {"200": {"description": "Successful update", "schema": {"$ref": "#/definitions/Admin"}}, "304": {"description": "No changes was made"}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only available to `Admin`. This endpoint will update the details for the authenenticated user. If the authenenticated user doesn't\nhave access to this endpoint, they will receive `HTTP 403` error. Although `Admin` contains a `User` model inside of it, you can give the details as\none. You can provide only the details that you want changed.\n\nThe following fields cannot be changed:\n\n- `registration_method`\n- `registration_id`\n- `is_active`\n- `date_joined`\n- `is_supervisor`\n\n**Example**\n```\n{\n    \"gender\": 1,\n    \"first_name\": \"Van\"\n}\n```\n", "parameters": [{"required": true, "in": "body", "description": "Email for the user", "name": "body", "schema": {"$ref": "#/definitions/AdminUpdate"}}], "tags": ["Admin Actions"], "summary": "Update admin profile details"}, "get": {"responses": {"200": {"description": "Successful response", "schema": {"$ref": "#/definitions/Admin"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "tags": ["Admin Actions"], "description": "This endpoint is only available to `Admin`. This endpoint will return the details for the authenenticated user. If the authenenticated user doesn't\nhave access to this endpoint, they will receive `HTTP 403` error.\n", "summary": "Get admin profile details"}}, "/admins/permissions/": {"get": {"responses": {"200": {"description": "Successful", "schema": {"properties": {"permissions": {"items": {"$ref": "#/definitions/Permission"}, "type": "array"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "tags": ["Admin Actions"], "description": "This endpoint is only available to supervisors.", "summary": "List available admin permissions"}}, "/languages/new/": {"post": {"responses": {"201": {"description": "Successful", "schema": {"$ref": "#/definitions/Language"}}, "403": {"description": "The user has no access here", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This method is only available for `Admin`. This is wehere a new language is added.\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/Language"}}], "tags": ["Admin Actions"], "summary": "Add new language"}}, "/countries/{country_id}/cities/": {"get": {"responses": {"200": {"description": "Returns the list of cities", "schema": {"type": "object", "properties": {"cities": {"items": {"$ref": "#/definitions/City"}, "type": "array"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is used to list the cities of a country in the database.\n\nAny user type can access this endpoint, but they must be authenenticated.\n", "parameters": [{"required": true, "type": "integer", "name": "country_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions", "Customer Actions", "Interpreter Actions"], "summary": "List the available cities for a country"}}, "/interpreter/": {"patch": {"responses": {"200": {"description": "Successful update", "schema": {"$ref": "#/definitions/Interpreter"}}, "304": {"description": "No changes were made to the profile"}, "400": {"description": "Bad request. This is usually becuase of a parameter error", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "In this endpoint, the authenenticated user can update his/her profile information. Since the profile information will be taken from the given token\nkey, If the authenenticated user is not an interpreter they will get an `HTTP 403` error.\n\nNone of the properties here are required. You can provide just the ones that you want updated.\n\nAlthough when presenting the `Interpreter`, we separate the `User` part. You can ignore that and just give update for fields from both `Interpreter`\nand `User`. The API will set them apart and update them accordingly.\n\nThe following fields cannot be changed:\n\n- `registration_method`\n- `registration_id`\n- `is_active`\n- `date_joined`\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/InterpreterUpdate"}}], "tags": ["Interpreter Actions"], "summary": "Update the interpreter profile."}, "get": {"responses": {"200": {"description": "Interpreter detail", "schema": {"$ref": "#/definitions/Interpreter"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "tags": ["Interpreter Actions"], "description": "In this endpoint, an authenenticated user can get the details about her/his profile. This endpoint is only accessible by the authenenticated user who is\nan `Interpreter`. Non-authenthicated users cannot access here and If an authenenticated user who is not an `Interpreter` accesses this endpoint, API will\nreturn a `HTTP 403` error.\n", "summary": "This endpoint returns the interpreter profile details for the authenenticated user."}}, "/countries/cities/{city_id}/": {"delete": {"responses": {"200": {"description": "Successful"}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The user has no access here", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This method is only available for `Admin`.\n", "parameters": [{"required": true, "type": "integer", "name": "city_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions"], "summary": "Delete city"}}, "/admins/{admin_id}/": {"delete": {"responses": {"200": {"description": "successfully deleted the admin"}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "An admin with the given ID doesn't exist.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only available to a supervisor `Admin`. This endpoint will delete the admin with the given ID. This action is irreversable. When an\nadmin is deleted that email address cannot be used to create another account. We'll be keeping the account to preserve the log history. If the\nauthenenticated user doesn't have access to this endpoint, they will receive `HTTP 403` error.\n", "parameters": [{"required": true, "type": "integer", "name": "admin_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions"], "summary": "Delete an admin"}, "get": {"responses": {"200": {"description": "Successful response", "schema": {"$ref": "#/definitions/Admin"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "An admin with the given ID doesn't exist.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only available to `Admin`. This endpoint will return the details for the admin with the given ID. If the authenenticated user doesn't\nhave access to this endpoint, they will receive `HTTP 403` error.\n", "parameters": [{"required": true, "type": "integer", "name": "admin_id", "in": "path", "format": "int32"}], "tags": ["Admin Actions"], "summary": "Get admin profile details"}}, "/credit-packages/{package_id}/": {"delete": {"responses": {"200": {"description": "Successful"}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "The credit package doesn't exist.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is accessible by `Admin`. Only deactivates the package instead of deleting it.\n", "parameters": [{"required": true, "type": "integer", "name": "package_id", "in": "path"}], "tags": ["Admin Actions"], "summary": "Deletes the credit package"}, "get": {"responses": {"200": {"description": "Successful", "schema": {"$ref": "#/definitions/CreditPackage"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "The credit package doesn't exist.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is accessible by `Customer` and `Admin`.\n", "parameters": [{"required": true, "type": "integer", "name": "package_id", "in": "path"}], "tags": ["Customer Actions", "Admin Actions"], "summary": "Get credit package details"}}, "/category-types/{category_type_id}/": {"delete": {"responses": {"200": {"description": "Successful"}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The user has no access here", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "Category type with the given ID doesn't exist", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This method is only available for `Admin`.\n", "parameters": [{"required": true, "type": "integer", "name": "category_type_id", "in": "path"}], "tags": ["Admin Actions"], "summary": "Delete category type"}}, "/customers/": {"get": {"responses": {"200": {"description": "An array of customers", "schema": {"type": "object", "properties": {"next_page": {"type": "integer", "description": "Use this to get to the next page"}, "has_previous_page": {"type": "boolean", "description": "This will be true If you can navigate to the previous page"}, "total_customer_count": {"type": "integer", "description": "Total number of customers"}, "previous_page": {"type": "integer", "description": "Use this to get to the previous page"}, "page_count": {"type": "integer", "description": "Total page count"}, "customers": {"items": {"$ref": "#/definitions/Customer"}, "type": "array"}, "has_next_page": {"type": "boolean", "description": "This will be true If you can navigate to the next page"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "If the authenenticated user is an admin, s/he can use this endpoint to list the users with support for filtering. Filters are only available to the\nadmins. If no filter is given, all of customers are listed. This endpoint is restricted for any user other than an `Admin`.\n", "parameters": [{"in": "query", "description": "The page to show. If this is not provided, the first page will be returned.", "format": "int32", "required": false, "type": "integer", "name": "page"}, {"in": "query", "description": "The number of admins to show in a list. This defaults to 10", "format": "int32", "required": false, "type": "integer", "name": "page_item_count"}, {"required": false, "type": "string", "name": "email", "in": "query", "format": "email"}, {"in": "query", "description": "The beginning date to look for users. `date_joined_end` parameters is not required for this parameter to work.", "format": "date", "required": false, "type": "string", "name": "date_joined_start"}, {"in": "query", "description": "The end date to look for users. `date_joined_start` parameters is not required for this parameter to work.", "format": "date", "required": false, "type": "string", "name": "date_joined_end"}, {"in": "query", "description": "See the options at the top of the documentation", "format": "int32", "required": false, "type": "integer", "name": "registration_method"}, {"in": "query", "description": "The country ID", "format": "int32", "required": false, "type": "integer", "name": "country"}, {"in": "query", "description": "The city ID", "format": "int32", "required": false, "type": "integer", "name": "city"}, {"in": "query", "description": "The language ID", "format": "int32", "required": false, "type": "integer", "name": "language"}, {"in": "query", "description": "See the options at the top of the documentation", "format": "int32", "required": false, "type": "integer", "name": "gender"}, {"in": "query", "description": "See the options at the top of the documentation", "format": "int32", "required": false, "type": "integer", "name": "customer_type"}, {"required": false, "type": "integer", "name": "status", "in": "query"}], "tags": ["Admin Actions"], "summary": "This endpoint lists the customers for `Admin`s. It can only be accessed by an `Admin`"}}, "/countries/{country_id}/cities/new/": {"post": {"responses": {"201": {"description": "Successful", "schema": {"$ref": "#/definitions/City"}}, "403": {"description": "The user has no access here", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This method is only available for `Admin`. This is wehere a new city is added.\n", "parameters": [{"required": true, "type": "integer", "name": "country_id", "in": "path"}, {"required": true, "in": "body", "name": "body", "schema": {"type": "object", "properties": {"name": {"type": "string", "description": "The name of the city. City names are not translatable, so this is the name of the city in the country's native language."}}}}], "tags": ["Admin Actions"], "summary": "Add new city"}}, "/countries/": {"get": {"responses": {"200": {"description": "Returns the list of countries", "schema": {"type": "object", "properties": {"countries": {"items": {"$ref": "#/definitions/Country"}, "type": "array"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "tags": ["Admin Actions", "Customer Actions", "Interpreter Actions"], "description": "This endpoint is used to list the countries in the database.\n\nAny user type can access this endpoint, but they must be authenenticated.\n", "summary": "List the available countries"}}, "/credit-packages/": {"get": {"responses": {"200": {"description": "successful", "schema": {"type": "object", "properties": {"credit_packages": {"items": {"$ref": "#/definitions/CreditPackage"}, "type": "array"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "tags": ["Customer Actions", "Admin Actions"], "description": "This endpoint is accessible by `Customer` and `Admin`.\n", "summary": "List credit credit packages"}}, "/transactions/purchases/": {"get": {"responses": {"200": {"description": "successful", "schema": {"type": "object", "properties": {"purchases": {"items": {"$ref": "#/definitions/PurchaseSummary"}, "type": "array"}, "next_page": {"type": "integer", "description": "Use this to get to the next page"}, "has_previous_page": {"type": "boolean", "description": "This will be true If you can navigate to the previous page"}, "purchased_credit_amount": {"type": "integer", "description": "For the time between `start_date` and `end_date`"}, "previous_page": {"type": "integer", "description": "Use this to get to the previous page"}, "page_count": {"type": "integer", "description": "Total page count"}, "has_next_page": {"type": "boolean", "description": "This will be true If you can navigate to the next page"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is accessible by `Customer` and `Admin`. This is where you list the purchases.\n", "parameters": [{"required": true, "type": "integer", "name": "last_x_purchases", "in": "query"}, {"required": false, "type": "integer", "description": "The number of items to show in one page. Defaults to 10.", "in": "query", "name": "page_item_count"}, {"required": false, "type": "integer", "description": "The page number to show. Defaults to 1.", "in": "query", "name": "page"}, {"required": false, "type": "integer", "description": "Available only for `Admin`. If a customer is accessing, this will be filled with the authenticated customer so you don't neeed to use it.", "in": "query", "name": "customer"}, {"required": false, "type": "string", "name": "start_date", "in": "query", "format": "dateTime"}, {"required": false, "type": "string", "name": "end_date", "in": "query", "format": "dateTime"}, {"required": false, "type": "integer", "name": "platform", "in": "query", "format": "int32"}], "tags": ["Customer Actions", "Admin Actions"], "summary": "List purchases"}}, "/interpreters/interpreter-payments/{payment_id}/": {"patch": {"responses": {"200": {"description": "Successful", "schema": {"$ref": "#/definitions/InterpreterPayment"}}, "304": {"description": "No changes have been made."}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This is only accessible by `Admin`. You can provide only the changed parts.\n", "parameters": [{"required": true, "type": "integer", "name": "payment_id", "in": "path"}, {"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/InterpreterPaymentUpdate"}}], "tags": ["Admin Actions"], "summary": "Update payment"}}, "/category-types/": {"get": {"responses": {"200": {"description": "Returns the list of categories", "schema": {"type": "object", "properties": {"category_types": {"items": {"$ref": "#/definitions/CategoryType"}, "type": "array"}}}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "tags": ["Admin Actions", "Customer Actions", "Interpreter Actions"], "description": "This endpoint is used to list all of the available category types. A `CategoryType` represents the category of an interpretation. And they are\ndynamically added by the `Admin` so this list is bound to change, but you can handle it without any code change.\n\nAny user type can access this endpoint, but they must be authenenticated. Pagination is not available here.\n", "summary": "List the available interpretation category types"}}, "/transactions/payments/new/": {"post": {"responses": {"400": {"description": "Bad request. This is usually becuase of a parameter error or insufficent funds", "schema": {"$ref": "#/definitions/Error"}}, "201": {"description": "Successful.", "schema": {"$ref": "#/definitions/Payment"}}, "403": {"description": "The authenenticated user is not allowed access here.", "schema": {"$ref": "#/definitions/Error"}}, "404": {"description": "The interpretation does not exist.", "schema": {"$ref": "#/definitions/Error"}}, "401": {"description": "The user is not authenenticated", "schema": {"$ref": "#/definitions/Error"}}}, "description": "This endpoint is only accessible by the `Customer` and `Admin`. Any other user trying to access here will return an `HTTP 403` error.\nUse this endpoint to add a payment to the `Interpretation`. A `Payment` can only be added for an `Interpretation`.\n\nIf an `Admin` is adding a payment, s/he needs to give a reason for doing so. When adding a payment, the user must have enough credits to\nafford the payment.\n\nThe conditions for adding a payment:\n- The interpretation **must** exist.\n- The customer **must** be the owner of the interpretation\n- The `amount` must be the same as the interpretation price.\n- The customer **must** have enough credits for payment.\n", "parameters": [{"required": true, "in": "body", "name": "body", "schema": {"$ref": "#/definitions/PaymentCreate"}}], "tags": ["Customer Actions", "Admin Actions"], "summary": "Add a payment"}}}, "schemes": ["https", "http"], "produces": ["application/json"], "securityDefinitions": {"apiKey": {"in": "header", "type": "apiKey", "description": "Make sure to include `JWT` prefix when typing your API key in the dialog", "name": "Authorization"}}, "host": "arifname.appspot.com", "definitions": {"Customer": {"type": "object", "description": "The interpreters can only see the `first_name` and the first letter of the `last_name`", "properties": {"status": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation. This is `none` by default"}, "city": {"$ref": "#/definitions/City"}, "language": {"$ref": "#/definitions/Language"}, "relationship": {"format": "int32", "type": "integer", "example": 2, "description": "See the options at the top of the documentation"}, "is_customer": {"type": "boolean", "description": "This will be equal to `false` until an interpretation is bought by the user.", "example": true}, "country": {"$ref": "#/definitions/Country"}, "is_phone_verified": {"type": "boolean", "description": "This is false by default", "example": true}, "profile_photo": {"type": "string", "description": "The URL to the user's profile photo", "format": "url"}, "remaining_credit": {"type": "integer"}, "phone": {"format": "char[15]", "type": "string", "example": "+905064569878", "description": "Phone number for the user"}, "customer_type": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation. `regular` is the default customer type."}, "user": {"$ref": "#/definitions/User"}, "total_credit": {"type": "integer", "description": "This is the credi purchased for the duration of the membership."}, "gender": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}}}, "City": {"type": "object", "properties": {"country": {"format": "char[3]", "type": "string", "example": "Turkey", "description": "The ISO 3166-1 alpha-2 is used to determine the countries (eg: TR, US). This way, the API can return translations of the country names\naccording to the user's language or the `Accept-Language` header.\nFor the list of the codes see [here](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)\n"}, "name": {"format": "char[64]", "type": "string", "example": "Ankara", "description": "The name of the city in the country language"}}}, "InterpreterUpdate": {"type": "object", "properties": {"country": {"type": "integer", "example": 1}, "profile_photo": {"type": "string", "description": "The URL to the interpreters's profile photo", "format": "url"}, "nickname": {"type": "string", "example": "Beard Brother", "format": "char[32]"}, "language": {"type": "integer", "example": 1}, "city": {"type": "integer", "example": 1}}}, "Language": {"type": "object", "properties": {"code": {"format": "char[3]", "type": "string", "example": "tr", "description": "The ISO 639-1 standard for languages (eg: tr, en). This way, the API can return translations of the country names according to the user's language or the `Accept-Language` header. For the list of the codes see [here](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes)"}, "name": {"format": "char[64]", "type": "string", "example": "English", "description": "The name of the language in the native format"}}}, "CountryCreate": {"type": "object", "description": "The model to use when creating a country", "properties": {"code": {"format": "char[3]", "type": "string", "example": "us", "description": "The ISO 3166-1 alpha-2 is used to determine the countries (eg: TR, US). This way, the API can return translations of the country names\naccording to the user's language or the `Accept-Language` header. For the list of the codes see\n[here](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)\n"}, "name": {"format": "char[64]", "type": "string", "example": "United States", "description": "The name of the country in the requested language"}, "language": {"$ref": "#/definitions/Language"}}}, "Admin": {"type": "object", "description": "Admins do not have a `registration_method` field, because they will be added by a supervisor by email.", "properties": {"city": {"$ref": "#/definitions/City"}, "language": {"$ref": "#/definitions/Language"}, "country": {"$ref": "#/definitions/Country"}, "profile_photo": {"type": "string", "description": "The URL to the admin's profile photo", "format": "url"}, "is_supervisor": {"type": "boolean", "description": "This is `false` by default", "example": false}, "phone": {"type": "string", "description": "Phone number for the admin", "example": "+905064569878"}, "user": {"$ref": "#/definitions/User"}, "gender": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}}}, "Country": {"type": "object", "description": "The same country with different names can be added. But the country with the same country code will have the same cities. City names are not\ntranslatable.\n", "properties": {"code": {"format": "char[3]", "type": "string", "example": "us", "description": "The ISO 3166-1 alpha-2 is used to determine the countries (eg: TR, US). This way, the API can return translations of the country names\naccording to the user's language or the `Accept-Language` header. For the list of the codes see\n[here](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)\n"}, "translations": {"items": {"$ref": "#/definitions/CountryTranslation"}, "type": "array"}}}, "InterpretationCreate": {"type": "object", "properties": {"category": {"$ref": "#/definitions/Category"}, "interpreter": {"type": "integer", "description": "Interpreter ID."}, "additional_user": {"$ref": "#/definitions/AdditionalUser"}, "response_type": {"type": "integer", "description": "Interpretation response type"}, "allow_in_pool": {"type": "boolean", "description": "The default is true."}}}, "AdminUpdate": {"type": "object", "description": "Used when updating an Admin", "properties": {"city": {"$ref": "#/definitions/City"}, "gender": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}, "user": {"$ref": "#/definitions/UserUpdate"}, "language": {"$ref": "#/definitions/Language"}, "phone": {"type": "string", "description": "Phone number for the admin", "example": "+905064569878"}, "country": {"$ref": "#/definitions/Country"}, "profile_photo": {"type": "string", "description": "The URL to the admin's profile photo", "format": "url"}}}, "Category": {"type": "object", "description": "This is one-to-one related to `Interpretation`.", "properties": {"request_voice": {"type": "string", "description": "The URL to the voice file. Only available if `type` is `voice`. Otherwise this value will be `null`.", "format": "url"}, "category_type": {"$ref": "#/definitions/CategoryType"}, "request_type": {"type": "integer", "description": "See the options at the top of the documentation", "format": "int32"}, "request_content": {"type": "string", "description": "The content of the dream. Only available if `type` is `text`. Otherwise this value will be `null`."}, "request_photos": {"items": {"type": "string", "description": "Each item is a URL to the uploaded photo"}, "type": "array"}}}, "InterpreterPaymentUpdate": {"type": "object", "description": "This defines a single payment for an interpreter.", "properties": {"payment_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "credit_amount": {"format": "int32", "type": "integer", "example": 1250, "description": "This is the credit amount for the interpretation"}, "paid_currency": {"format": "char[3]", "type": "string", "example": "usd", "description": "This is the currency as [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217#Active_codes) standard"}, "paid_amount": {"format": "double", "type": "integer", "example": 125.45, "description": "This is the `credit_amount`'s value in real money."}, "interpreter": {"$ref": "#/definitions/Interpreter"}}}, "PurchaseSummary": {"type": "object", "description": "This is essentially same as `Purchase`. The only difference is that fields like `promotion` doesn't provide the details of its contents but only the ID.\n", "properties": {"special_offer": {"type": "integer"}, "credit_package": {"$ref": "#/definitions/CreditPackage"}, "admin": {"type": "integer"}, "platform": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top"}, "reason": {"format": "char[512]", "type": "string", "example": "The customer paid the price, but the credit wasn't installed to his account.", "description": "If this purhcase was done by an `Admin`, they need to provide the reason for doing so"}, "purchase_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "promotion": {"type": "integer"}, "transaction_id": {"format": "char[256]", "type": "string", "example": "totally_not_an_id", "description": "This is the transaction ID that is provided by an in-app purchase. This field is not required If the purchase was a gift or a promotion."}}}, "InterpreterSummary": {"type": "object", "properties": {"status": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}, "city": {"$ref": "#/definitions/City"}, "language": {"$ref": "#/definitions/Language"}, "country": {"$ref": "#/definitions/Country"}, "profile_photo": {"type": "string", "description": "The URL to the interpreters's profile photo", "format": "url"}, "interpretation_count": {"format": "int32", "type": "integer", "example": 420, "description": "This is the total amount of interpretations the `Interpreter` has done."}, "user": {"$ref": "#/definitions/UserSummary"}, "queue_length": {"format": "int32", "type": "integer", "example": 42, "description": "This is the number of `Interpretation`s whose `status` is `in_progress`."}, "interpretation_prices": {"items": {"$ref": "#/definitions/InterpretationPrice"}, "type": "array", "description": "The list of interpretation prices for each interpretation category type the Interpreter does. The categories do not have a separate field becuase\nthis field is enough.\n"}, "nickname": {"type": "string", "example": "Beard Brother", "format": "char[32]"}}}, "CountryTranslation": {"type": "object", "description": "The same country with different names can be added. But the country with the same country code will have the same cities. City names are not\ntranslatable.\n", "properties": {"name": {"type": "string", "example": "United States", "format": "char[64]"}, "language": {"$ref": "#/definitions/Language"}}}, "InterpretationPrice": {"type": "object", "description": "This represents the price range for each interpretation category type. When an `Interpreter` wants to add an interpretation category to their profile, they need to create a price for it too.", "properties": {"credit": {"type": "integer", "example": 125, "format": "int32"}, "category_type": {"$ref": "#/definitions/CategoryType"}}}, "Error": {"type": "object", "properties": {"message": {"type": "string", "description": "This is the human readable error message. The right place to handle the error programmatically would be to read `code` and `parameters` keys.", "example": "A parameter error occurred"}, "code": {"format": "int32", "type": "integer", "example": 12, "description": "This is the custom code."}, "parameters": {"type": "object", "properties": {"FIELD_NAME": {"items": {"type": "string", "example": "This field must be unique"}, "type": "array", "description": "Each item in the aray details the error. These errors are human readable so it can be showed to the user. If `Accept-Language` header is specified, these errors will be translated to that language.", "example": "email"}}}}}, "Ban": {"type": "object", "description": "A `Ban` object will be created everytime a user is banned. This will live until, If ever, the ban is lifted from the user. This is automatically assigned\nby the API based on the authenenticated Admin\n", "properties": {"admin": {"$ref": "#/definitions/Admin"}, "ban_date": {"format": "dateTime", "type": "string", "example": "2017-07-01T13:00", "description": "This is the date time of the ban. This is automatically added by the API."}, "reason": {"format": "char[512]", "type": "string", "example": "The user was being kind of a jerk", "description": "A short 512 character long description of why the user is banned"}, "end_date": {"format": "dateTime", "type": "string", "example": "2018-01-01T13:00", "description": "If this field is set to `null` then the user is banned indefinately. This field can be used to give bans for a period of time. After this\ndate is passed, the user will be unbanned.\n"}, "user": {"$ref": "#/definitions/User"}}}, "Interpretation": {"type": "object", "description": "This is the model to use for an interpretation request. If the interpretation falls into the pool, `interpreter` will be `null` until another\n`Interpreter` is assigned. When an interpretation is first created, the default status will be `waiting_approval`. If the assigned interpreter approves\nthe interpretation, the status will be `in_queue`. And when the interpreter starts the interpretation the status will be `in_progress`. If the assigned\ninterpreter doesn't take the interpretation or doesn't answer, then the status will be `in_pool`, meaning other interpreters will be able to take it.\n", "properties": {"customer": {"$ref": "#/definitions/CustomerSummary"}, "category": {"$ref": "#/definitions/Category"}, "remaining_message_count": {"format": "int32", "type": "integer", "example": 2, "description": "When this is 0, the `Customer` can no longer send messages."}, "request_date": {"type": "string", "description": "This is the date that the request was made.", "format": "dateTime"}, "queue_number": {"format": "int32", "type": "integer", "example": 42, "description": "This is automatically added when the interpretation request is created. The queue is a FIFO list."}, "response_content": {"type": "string", "description": "The written response", "example": "You have cancer!"}, "messages": {"items": {"$ref": "#/definitions/Message"}, "type": "array"}, "response_voice": {"type": "string", "description": "The URL to the voice recording"}, "response_date": {"format": "dateTime", "type": "string", "example": "2017-05-06T13:45", "description": "This is the date that the response was made."}, "status": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}, "response_type": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}, "timeout": {"format": "int32", "type": "integer", "example": 2, "description": "This is the timeout in hours. The default is 48 hours and it cannot be changed."}, "interpreter": {"$ref": "#/definitions/InterpreterSummary"}, "allow_in_pool": {"type": "boolean", "description": "This is `false` by default. But if it is true, then the interpretation can be picked up by other interpreters if it doesn't get picked up by the\nassigned one.\n", "example": false}, "additional_user": {"$ref": "#/definitions/AdditionalUser"}}}, "Promotion": {"type": "object", "description": "Promotions are created by the admins who have the permission to create them. A promotion will be automatically added to the customers who satisfy the\ncriteria. And if the promotion is set to expire, the customer **must** spend it until expiration otherwise the promotion will be invalid for them.\nThe promotions will not be added to the banned customers.\n", "properties": {"customers": {"items": {"type": "integer"}, "type": "array", "description": "Promotions can be applied to certain customers too. But when this field is used, all of the other filters will be ignored."}, "end_date": {"format": "dateTime", "type": "string", "example": "2017-01-02T12:45", "description": "The promotion will be invalid after the end date has passed."}, "countries": {"items": {"type": "integer"}, "type": "array", "description": "The country to which the promotion applies."}, "admin": {"$ref": "#/definitions/Admin"}, "gender": {"type": "integer", "description": "The gender to which the promotion applies.", "example": 1}, "credit_amount": {"format": "int32", "type": "integer", "example": 250, "description": "The credit amount for this promotion"}, "customer_type": {"type": "integer", "description": "The customer type to which the promotion applies.", "example": 1}, "is_valid": {"type": "boolean", "example": false}, "cities": {"items": {"type": "integer"}, "type": "array", "description": "The city to which the promotion applies."}, "start_date": {"format": "dateTime", "type": "string", "example": "2017-01-02T12:30", "description": "The promotion will not be active until the `start_date`"}}}, "CategoryType": {"type": "object", "description": "Each category is many-to-one related to `Category` model. This way, we can create categories dynamically and not write one line of code until we decide to provide a new way to submit and response to interpretations. `name` field is human readable so provide it in the given language.", "properties": {"code": {"type": "string", "description": "This is the underscore separated form of the type. This is meant for the programmer to easly handle the category type.", "example": "physionomy"}, "name": {"type": "string", "description": "This is the name of the category type in human readable form. This field is translateble. The translation will be done according to the `Accept-Language` header.", "example": "Fizyonomi"}, "language": {"$ref": "#/definitions/Language"}}}, "Device": {"type": "object", "properties": {"platform": {"type": "integer", "description": "See top of the documentation for options", "example": 1}, "user": {"$ref": "#/definitions/User"}, "last_login_date": {"type": "string", "example": "2017-01-01T13:45", "format": "dateTime"}, "ip_address": {"format": "char[45]", "type": "string", "example": "127.0.0.1", "description": "This holds the last login IP (v4 and v6) address."}, "is_banned": {"type": "boolean", "description": "All of the devices of a customer is banned along with the customer.", "example": false}, "login_count": {"format": "int32", "type": "integer", "example": 45, "description": "The count of login requests."}, "device_id": {"type": "string", "example": "3416asdslfu3094rwsedf54_totally_not_an_id", "format": "char[256]"}}}, "SpecialOffer": {"type": "object", "description": "Special offers are created by admins. At least one filter is required.\n", "properties": {"customers": {"items": {"type": "integer"}, "type": "array", "description": "Promotions can be applied to certain customers too. But when this field is used, all of the other filters will be ignored."}, "credit_package": {"$ref": "#/definitions/CreditPackage"}, "end_date": {"format": "dateTime", "type": "string", "example": "2018-01-01T13:03", "description": "The promotion will be invalid after the end date has passed."}, "countries": {"items": {"type": "integer"}, "type": "array", "description": "The country to which the promotion applies."}, "admin": {"$ref": "#/definitions/Admin"}, "gender": {"type": "integer", "description": "The gender to which the promotion applies.", "example": 1}, "currency": {"format": "char[4]", "type": "string", "example": "usd", "description": "This is the currency as [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217#Active_codes) standard"}, "customer_type": {"type": "integer", "description": "The customer type to which the promotion applies.", "example": 1}, "credit_price": {"format": "double", "type": "integer", "example": 4.99, "description": "The credit price for this special offer"}, "message": {"format": "char[512]", "type": "string", "example": "{'tr': 'Bizim kampanyadan faydalan!', 'en': 'Wow! What a special offer!'}", "description": "This is the message to show to user when offering the special. This is a text field but a json will be dumped here for differen languages."}, "cities": {"items": {"type": "integer"}, "type": "array", "description": "The city to which the promotion applies."}, "start_date": {"format": "dateTime", "type": "string", "example": "2018-01-01T10:03", "description": "The promotion will not be active until the `start_date`"}, "registration_method": {"type": "integer", "description": "See the top of the documentation for options", "example": 2}}}, "Comment": {"type": "object", "description": "The interpreters and customers cannot see who wrote the comment. So comments are anonymous. But not to the admins.", "properties": {"customer": {"$ref": "#/definitions/CustomerSummary"}, "content": {"type": "string", "example": "He's OK, I guess..."}, "interpreter": {"$ref": "#/definitions/InterpreterSummary"}, "date": {"type": "string", "example": "2017-01-01T12:45", "format": "dateTime"}, "rating": {"type": "integer", "description": "This is between 1 and 5 inclusive", "example": 3}}}, "PaymentCreate": {"type": "object", "description": "This defines a single payment for an interpretation. This is a many-to-one relationship model to `Customer`. That's why we are not including a `user` field here. Payments can only be made by a customer. `customer_credit` will only appear in the JSON response, that field does not exist in the database as this will have a relationship to `Customer` model.", "properties": {"payment_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "amount": {"format": "int32", "type": "integer", "example": 500, "description": "This is the credit amount for the interpretation"}, "interpretation": {"type": "integer"}, "reason": {"format": "char[512]", "type": "string", "example": "There was an error during payment.", "description": "If this payment was done by an `Admin`, they need to provide the reason for doing so"}}}, "CreditPackage": {"type": "object", "description": "Credit purchases can only be made by each package", "properties": {"currency": {"format": "char[4]", "type": "string", "example": "usd", "description": "This is the currency as [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217#Active_codes) standard"}, "amount": {"type": "integer", "example": 100}, "cost": {"format": "double", "type": "integer", "example": 2.99, "description": "The money customer pays to buy this credit"}, "is_active": {"type": "boolean", "description": "This is set to False if the credit package is not active anymore.", "example": false}, "codename": {"format": "char[32]", "type": "string", "example": "package_100", "description": "This must be unique"}}}, "Permission": {"type": "object", "description": "Permission is used to determine whether an admin has the right to complete an action. The `name` field is not kept in the database. Permission creating\nis not dynamic.\n", "properties": {"codename": {"format": "char[64]", "type": "string", "example": "can_ban", "description": "This is used by the programmer"}, "name": {"type": "string", "description": "This is a json object with name representing each supported language.", "example": "{\n    \"tr\": \"Admin silme yapar\",\n    \"en\": \"Admin can delete.\"\n}\n"}}}, "PaymentSummary": {"type": "object", "description": "This is essentially same as `Payment`. The only difference is that fields like `admin` doesn't provide the details of its contents but only the ID.\n", "properties": {"admin": {"type": "integer"}, "payment_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "amount": {"format": "int32", "type": "integer", "example": 500, "description": "This is the credit amount for the interpretation"}, "interpretation": {"type": "integer"}, "reason": {"format": "char[512]", "type": "string", "example": "There was an error during payment.", "description": "If this payment was done by an `Admin`, they need to provide the reason for doing so"}}}, "UserCreate": {"type": "object", "description": "This is used when creating a user", "properties": {"first_name": {"format": "char[64]", "type": "string", "example": "John", "description": "User's first name."}, "last_name": {"format": "char[64]", "type": "string", "example": "Q", "description": "User's last name."}, "email": {"type": "string", "description": "A unique email for the user.", "example": "example@email.com"}, "registration_method": {"format": "int32", "type": "integer", "example": 1, "description": "This is set only one-time during the registration process and then it cannot be changed. See the options at the top of the documentation"}, "registration_id": {"format": "char[128]", "type": "string", "example": "kjsadhg7u234retotally_not_an_id", "description": "This is used when the user signs up with any of the methods except `email`."}}}, "UserUpdate": {"type": "object", "description": "This is used to update a user", "properties": {"first_name": {"format": "char[64]", "type": "string", "example": "John", "description": "User's first name."}, "last_name": {"format": "char[64]", "type": "string", "example": "Q", "description": "User's last name."}, "email": {"type": "string", "description": "A unique email for the user.", "example": "example@email.com"}}}, "Payment": {"type": "object", "description": "This defines a single payment for an interpretation. Payments can only be made by a customer and admins. If an admin is making the payment then they\n**need** to give a reason for that.\n", "properties": {"message_increase": {"type": "integer", "description": "Set this field to any number of messages to increase the `remaining_message_count` field in an interpretation. This parameter is only available if\nthe `type` is `purchase`.\n"}, "payment_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "reason": {"format": "char[512]", "type": "string", "example": "There was an error during payment.", "description": "If this payment was done by an `Admin`, they need to provide the reason for doing so"}, "interpretation": {"$ref": "#/definitions/Interpretation"}, "admin": {"$ref": "#/definitions/Admin"}, "amount": {"format": "int32", "type": "integer", "example": 500, "description": "This is the credit amount for the interpretation"}}}, "InterpreterPaymentCreate": {"type": "object", "description": "This defines a single payment for an interpreter. Admin field is set by the API.", "properties": {"payment_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "credit_amount": {"format": "int32", "type": "integer", "example": 1250, "description": "This is the credit amount for the interpretation"}, "paid_currency": {"format": "char[3]", "type": "string", "example": "usd", "description": "This is the currency as [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217#Active_codes) standard"}, "paid_amount": {"format": "double", "type": "integer", "example": 125.45, "description": "This is the `credit_amount`'s value in real money."}}}, "UserSummary": {"type": "object", "description": "This is used when a request is made to list Customer, Admin or Interpreter. User detilas are only shown\nwhen the user is getting the profile details.\n", "properties": {"first_name": {"format": "char[64]", "type": "string", "example": "John", "description": "User's first name."}, "last_name": {"format": "char[64]", "type": "string", "example": "Q", "description": "User's last name."}, "email": {"type": "string", "description": "A unique email for the user.", "example": "example@email.com"}}}, "InterpreterPayment": {"type": "object", "description": "This defines a single payment for an interpretation. This is a many-to-one relationship model to `Customer`. That's why we are not including a `user` field here. Payments can only be made by a customer. `customer_credit` will only appear in the JSON response, that field does not exist in the database as this will have a relationship to `Customer` model.", "properties": {"payment_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "paid_amount": {"format": "double", "type": "integer", "example": 125.45, "description": "This is the `credit_amount`'s value in real money."}, "admin": {"$ref": "#/definitions/Admin"}, "interpreter": {"$ref": "#/definitions/Interpreter"}, "credit_amount": {"format": "int32", "type": "integer", "example": 1250, "description": "This is the credit amount for the interpretation"}, "paid_currency": {"format": "char[3]", "type": "string", "example": "usd", "description": "This is the currency as [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217#Active_codes) standard"}}}, "Purchase": {"type": "object", "description": "This defines a single credit purchase.", "properties": {"special_offer": {"$ref": "#/definitions/SpecialOffer"}, "credit_package": {"$ref": "#/definitions/CreditPackage"}, "admin": {"$ref": "#/definitions/Admin"}, "platform": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top"}, "reason": {"format": "char[512]", "type": "string", "example": "The customer paid the price, but the credit wasn't installed to his account.", "description": "If this purhcase was done by an `Admin`, they need to provide the reason for doing so"}, "purchase_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "promotion": {"$ref": "#/definitions/Promotion"}, "transaction_id": {"format": "char[256]", "type": "string", "example": "totally_not_an_id", "description": "This is the transaction ID that is provided by an in-app purchase. This field is not required If the purchase was a gift or a promotion."}}}, "PurchaseCreate": {"type": "object", "description": "This defines a single credit purchase. This model is many-to-one related to `Customer` model.`customer_credit` will only appear in the JSON response, that field does not exist in the database as this will have a relationship to `Customer` model.", "properties": {"platform": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top"}, "reason": {"format": "char[512]", "type": "string", "example": "The customer paid the price, but the credit wasn't installed to his account.", "description": "If this purhcase was done by an `Admin`, they need to provide the reason for doing so"}, "special_offer": {"type": "integer"}, "credit_package": {"type": "integer"}, "purchase_date": {"type": "string", "example": "2017-01-02T12:45", "format": "dateTime"}, "promotion": {"type": "integer"}, "transaction_id": {"format": "char[256]", "type": "string", "example": "totally_not_an_id", "description": "This is the transaction ID that is provided by an in-app purchase. This field is not required If the purchase was a gift or a promotion."}}}, "User": {"type": "object", "description": "This is the base model for `Customer`, `Interpreter`, and `Admin`", "properties": {"username": {"type": "string", "description": "This will be empty by default.", "format": "char[32]"}, "first_name": {"format": "char[32]", "type": "string", "example": "John", "description": "User's first name."}, "last_name": {"format": "char[32]", "type": "string", "example": "Q", "description": "User's last name."}, "is_active": {"type": "boolean", "description": "Inactive accounts cannot be modified.", "example": true}, "registration_id": {"format": "char[128]", "type": "string", "example": "kjsadhgi7u234retotally_not_an_id", "description": "This is used when the user signs up with any of the methods except `email`."}, "devices": {"items": {"$ref": "#/definitions/Device"}, "type": "array"}, "birthday": {"format": "date", "type": "string", "example": "1995-01-02", "description": "Birthday for the user"}, "date_joined": {"format": "date", "type": "string", "example": "2017-01-02T12:45", "description": "This is auto generated when the user completes registration and it is read-only."}, "email": {"type": "string", "description": "A unique email for the user.", "example": "example@email.com"}, "registration_method": {"format": "int32", "type": "integer", "example": 1, "description": "This is set only one-time during the registration process and then it cannot be changed. See the options at the top of the documentation"}, "permissions": {"items": {"$ref": "#/definitions/Permission"}, "type": "array"}}}, "Interpreter": {"type": "object", "description": "Customers cannot see the real name of the interpreters and the phone numbers.", "properties": {"status": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}, "rating": {"format": "double", "type": "integer", "example": 4.5, "description": "This field is calculated from the `comments`. The default value is -1 which means this interpreter has not been rated."}, "preferred_response_type": {"type": "integer", "description": "See the top of the documentation for the options.", "example": 1}, "paid_credit_amount": {"type": "integer", "description": "The total paid credit.", "example": 500}, "is_phone_verified": {"type": "boolean", "description": "This is false by default", "example": true}, "phone": {"format": "char[15]", "type": "string", "example": "+905064569878", "description": "Phone number for the interpreter"}, "interpretation_count": {"format": "int32", "type": "integer", "example": 1993, "description": "This is the total amount of interpretations the `Interpreter` has done."}, "profile_description": {"format": "char[1024]", "type": "string", "example": "I'm... Dr. Strange!", "description": "The about section for the interpreter"}, "user": {"$ref": "#/definitions/User"}, "interpretation_response_average": {"format": "double", "type": "integer", "example": 45.5, "description": "Average response time in minutes."}, "nickname": {"type": "string", "example": "Beard Brother", "format": "char[32]"}, "city": {"$ref": "#/definitions/City"}, "language": {"$ref": "#/definitions/Language"}, "country": {"$ref": "#/definitions/Country"}, "comments": {"items": {"$ref": "#/definitions/Comment"}, "type": "array", "description": "Only last 10 comments are returned."}, "profile_photo": {"type": "string", "description": "The URL to the interpreters's profile photo", "format": "url"}, "earned_credit_amount": {"type": "integer", "description": "The total earned credit.", "example": 1500}, "queue_length": {"format": "int32", "type": "integer", "example": 42, "description": "This is the interpretation count that the `Interpreter` is currently doing."}, "interpretation_prices": {"items": {"$ref": "#/definitions/InterpretationPrice"}, "type": "array", "description": "The list of interpretation prices for each interpretation category type the Interpreter does."}}}, "Message": {"type": "object", "description": "This is the message that is used for an `Interpretation`. `from` and `to` fields are automatically set by the API by using the authenenticated user information. If the authenenticated user is a customer, then the `from` field will be `customer` if the authenenticated user is an interpreter the `from` field will be `interpreter`. This is a on-to-many related model to interpretation, so we don't need the intpertation field", "properties": {"content": {"type": "string", "example": "Are you kidding me!? This is totally me!"}, "send_date": {"type": "string", "example": "2017-02-03T13:45", "format": "dateTime"}, "from": {"format": "int32", "type": "integer", "example": 2, "description": "See the options at the top of the documentation. This field is read-only."}, "to": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation. This field is read-only."}}}, "AdditionalUser": {"type": "object", "description": "This is used when the user wants an interpretation for another person. This user doesn't have to be registered. This user is one-to-many\nrelated to `Interpretation`.\n", "properties": {"city": {"$ref": "#/definitions/City"}, "first_name": {"format": "char[32]", "type": "string", "example": "Steven", "description": "User's first name."}, "last_name": {"format": "char[32]", "type": "string", "example": "Strange", "description": "User's last name."}, "gender": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}, "country": {"$ref": "#/definitions/Country"}, "email": {"type": "string", "description": "A unique email for the user.", "example": "additional@email.com"}, "birthday": {"format": "date", "type": "string", "example": "1993-07-10", "description": "Birthday for the user"}}}, "CustomerSummary": {"type": "object", "description": "The interpreters can only see the `first_name` and the first letter of the `last_name`", "properties": {"status": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}, "city": {"$ref": "#/definitions/City"}, "language": {"$ref": "#/definitions/Language"}, "country": {"$ref": "#/definitions/Country"}, "profile_photo": {"type": "string", "description": "The URL to the user's profile photo", "format": "url"}, "customer_type": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}, "user": {"$ref": "#/definitions/User"}, "gender": {"format": "int32", "type": "integer", "example": 1, "description": "See the options at the top of the documentation"}}}}, "security": [{"apiKey": []}], "swagger": "2.0", "consumes": ["application/json"]};