/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.gui.GenericDialog;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.ArrayList;
import java.util.List;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.WindowTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorDialog
extends ImporterDialog {
    private static final Dimension SWATCH_SIZE = new Dimension(100, 50);

    public ColorDialog(ImportProcess process) {
        super(process);
    }

    @Override
    protected boolean needPrompt() {
        return !this.process.isWindowless() && this.options.isColorModeCustom();
    }

    @Override
    protected GenericDialog constructDialog() {
        GenericDialog gd = new GenericDialog("Bio-Formats Custom Colorization");
        ImageProcessorReader reader = this.process.getReader();
        ArrayList<Panel> swatches = new ArrayList<Panel>();
        for (int s = 0; s < this.process.getSeriesCount(); ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            reader.setSeries(s);
            for (int c = 0; c < reader.getSizeC(); ++c) {
                Color color = this.options.getCustomColor(s, c);
                if (color == null) {
                    color = this.options.getDefaultCustomColor(c);
                }
                gd.addSlider(this.makeLabel("Red:", s, c), 0.0, 255.0, (double)color.getRed());
                gd.addSlider(this.makeLabel("Green:", s, c), 0.0, 255.0, (double)color.getGreen());
                gd.addSlider(this.makeLabel("Blue:", s, c), 0.0, 255.0, (double)color.getBlue());
                Panel swatch = this.createSwatch(color);
                gd.addPanel(swatch, 10, new Insets(5, 0, 5, 0));
                swatches.add(swatch);
            }
        }
        List<TextField> colorFields = this.getNumericFields(gd);
        this.attachListeners(colorFields, swatches);
        WindowTools.addScrollBars((Container)gd);
        return gd;
    }

    @Override
    protected boolean harvestResults(GenericDialog gd) {
        ImageProcessorReader reader = this.process.getReader();
        for (int s = 0; s < this.process.getSeriesCount(); ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            reader.setSeries(s);
            for (int c = 0; c < reader.getSizeC(); ++c) {
                int red = (int)gd.getNextNumber();
                int green = (int)gd.getNextNumber();
                int blue = (int)gd.getNextNumber();
                Color color = new Color(red, green, blue);
                this.options.setCustomColor(s, c, color);
            }
        }
        return true;
    }

    private String makeLabel(String baseLabel, int s, int c) {
        return "Series_" + s + "_Channel_" + c + "_" + baseLabel;
    }

    private Panel createSwatch(Color color) {
        Panel swatch = new Panel();
        swatch.setPreferredSize(SWATCH_SIZE);
        swatch.setMinimumSize(SWATCH_SIZE);
        swatch.setMaximumSize(SWATCH_SIZE);
        swatch.setBackground(color);
        return swatch;
    }

    private void attachListeners(List<TextField> colors, List<Panel> swatches) {
        int colorIndex = 0;
        int swatchIndex = 0;
        while (colorIndex < colors.size()) {
            final TextField redField = colors.get(colorIndex++);
            final TextField greenField = colors.get(colorIndex++);
            final TextField blueField = colors.get(colorIndex++);
            final Panel swatch = swatches.get(swatchIndex++);
            TextListener textListener = new TextListener(){

                public void textValueChanged(TextEvent e) {
                    int red = ColorDialog.this.getColorValue(redField);
                    int green = ColorDialog.this.getColorValue(greenField);
                    int blue = ColorDialog.this.getColorValue(blueField);
                    swatch.setBackground(new Color(red, green, blue));
                    swatch.repaint();
                }
            };
            redField.addTextListener(textListener);
            greenField.addTextListener(textListener);
            blueField.addTextListener(textListener);
        }
    }

    private int getColorValue(TextField colorField) {
        int color = 0;
        try {
            color = Integer.parseInt(colorField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (color < 0) {
            color = 0;
        }
        if (color > 255) {
            color = 255;
        }
        return color;
    }

    private List<TextField> getNumericFields(GenericDialog gd) {
        return gd.getNumericFields();
    }
}

