/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import loci.common.Location;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;

public class IdDialog
extends ImporterDialog {
    private OpenDialog od;
    private String name;

    public IdDialog(ImportProcess process) {
        super(process);
    }

    protected boolean needPrompt() {
        return this.options.getId() == null;
    }

    protected GenericDialog constructDialog() {
        GenericDialog gd = null;
        if (this.options.isHTTP()) {
            gd = new GenericDialog("Bio-Formats URL");
            gd.addStringField("URL: ", "http://", 30);
        }
        return gd;
    }

    protected boolean displayDialog(GenericDialog gd) {
        if (this.options.isLocal()) {
            String osVersion;
            if (this.options.isFirstTime() && IJ.isMacOSX() && !this.options.isQuiet() && ((osVersion = System.getProperty("os.version")) == null || osVersion.startsWith("10.4.") || osVersion.startsWith("10.3.") || osVersion.startsWith("10.2."))) {
                IJ.showMessage((String)"Bio-Formats", (String)"One-time warning: There is a bug in Java on Mac OS X with the native file chooser\nthat crashes ImageJ if you click on a file in CXD, IPW, OIB or ZVI format while in\ncolumn view mode. You can work around the problem in one of two ways:\n \n    1. Switch to list view (press Command+2)\n    2. Check \"Use JFileChooser to Open/Save\" under Edit>Options>Input/Output...");
            }
            String idLabel = this.options.getLabel("id");
            this.od = new OpenDialog(idLabel, this.options.getId());
            this.name = this.od.getFileName();
            if (this.name == null) {
                return false;
            }
        } else if (this.options.isHTTP()) {
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
        }
        return true;
    }

    protected boolean harvestResults(GenericDialog gd) {
        String id = null;
        if (this.options.isLocal()) {
            Location idLoc;
            String dir = this.od.getDirectory();
            if (dir != null || this.name == null) {
                id = dir + this.name;
            }
            if (!(idLoc = new Location(id)).exists() && !id.toLowerCase().endsWith(".fake")) {
                if (!this.options.isQuiet()) {
                    IJ.error((String)"Bio-Formats", (String)("The specified file (" + id + ") does not exist."));
                }
                return false;
            }
        } else if (this.options.isHTTP() && (id = gd.getNextString()) == null) {
            if (!this.options.isQuiet()) {
                IJ.error((String)"Bio-Formats", (String)"No URL was specified.");
            }
            return false;
        }
        this.options.setId(id);
        return true;
    }
}

