/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Settings;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LightSourceSettings
extends Settings {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(LightSourceSettings.class);
    private PositiveInteger wavelength;
    private PercentFraction attenuation;
    private String id;

    public LightSourceSettings() {
    }

    public LightSourceSettings(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"LightSourceSettings".equals(tagName)) {
            LOGGER.debug("Expecting node name of LightSourceSettings got {}", (Object)tagName);
        }
        if (element.hasAttribute("Wavelength")) {
            this.setWavelength(PositiveInteger.valueOf(element.getAttribute("Wavelength")));
        }
        if (element.hasAttribute("Attenuation")) {
            this.setAttenuation(PercentFraction.valueOf(element.getAttribute("Attenuation")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("LightSourceSettings missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public PositiveInteger getWavelength() {
        return this.wavelength;
    }

    public void setWavelength(PositiveInteger wavelength) {
        this.wavelength = wavelength;
    }

    public PercentFraction getAttenuation() {
        return this.attenuation;
    }

    public void setAttenuation(PercentFraction attenuation) {
        this.attenuation = attenuation;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element LightSourceSettings_element) {
        if (LightSourceSettings_element == null) {
            LightSourceSettings_element = document.createElementNS(NAMESPACE, "LightSourceSettings");
        }
        if (this.wavelength != null) {
            LightSourceSettings_element.setAttribute("Wavelength", this.wavelength.toString());
        }
        if (this.attenuation != null) {
            LightSourceSettings_element.setAttribute("Attenuation", this.attenuation.toString());
        }
        if (this.id != null) {
            LightSourceSettings_element.setAttribute("ID", this.id.toString());
        }
        return super.asXMLElement(document, LightSourceSettings_element);
    }
}

