/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    public static final long MILLIS = 1L;
    public static final long MILLIS_SECOND = 1000L;
    public static final long MILLIS_MINUTE = 60000L;
    public static final long MILLIS_HOUR = 3600000L;
    public static final long MILLIS_DAY = 86400000L;
    public static final long MILLIS_WEEK = 604800000L;
    public static final long MILLIS_MONTH = 2592000000L;
    public static final long MILLIS_YEAR = 31536000000L;
    public static final long MILLIS_DECADE = 315360000000L;
    public static final long MILLIS_CENTURY = 3153600000000L;
    public static final long MILLIS_MILLENIUM = 31536000000000L;
    private static Logger log = LoggerFactory.getLogger(DateUtil.class);

    public static String getCurrentSystemTimeAsISO8601() {
        return DateUtil.getTimeAsISO8601(System.currentTimeMillis());
    }

    public static String getTimeAsISO8601(Date date) {
        return DateUtil.getTimeAsISO8601(date.getTime());
    }

    public static String getTimeAsISO8601(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(time);
        Date curSysDate = cal.getTime();
        return DateFormatHandler.ISO_DATE_TIME.getDateTimeStringFromDate(curSysDate);
    }

    public static long daysToMillis(double days) {
        return DateUtil.hoursToMillis(days * 24.0);
    }

    public static long hoursToMillis(double hour) {
        return DateUtil.minutesToMillis(hour * 60.0);
    }

    public static double millisToMinutes(double millis) {
        return millis / 1000.0 / 60.0;
    }

    public static long minutesToMillis(double minutes) {
        return (long)(minutes * 60.0 * 1000.0);
    }

    static class DateFormatHandler {
        public static final DateFormatHandler ISO_DATE = new DateFormatHandler("yyyy-MM-dd");
        public static final DateFormatHandler ISO_TIME = new DateFormatHandler("HH:mm:ss.SSSz");
        public static final DateFormatHandler ISO_DATE_TIME = new DateFormatHandler("yyyy-MM-dd'T'HH:mm:ssz");
        public static final DateFormatHandler ISO_DATE_TIME_MILLIS = new DateFormatHandler("yyyy-MM-dd'T'HH:mm:ss.SSSz");
        private String dateTimeFormatString = null;

        private DateFormatHandler(String dateTimeFormatString) {
            this.dateTimeFormatString = dateTimeFormatString;
        }

        public String getDateTimeFormatString() {
            return this.dateTimeFormatString;
        }

        public Date getDateFromDateTimeString(String dateTimeString) {
            Date theDate = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateTimeFormatString, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                theDate = dateFormat.parse(dateTimeString);
            }
            catch (ParseException e) {
                log.warn(e.getMessage());
                return null;
            }
            return theDate;
        }

        public String getDateTimeStringFromDate(Date date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateTimeFormatString, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String dateString = dateFormat.format(date);
            return dateString;
        }
    }
}

