# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTacacsCommandSetResult',
    'AwaitableGetTacacsCommandSetResult',
    'get_tacacs_command_set',
    'get_tacacs_command_set_output',
]

@pulumi.output_type
class GetTacacsCommandSetResult:
    """
    A collection of values returned by getTacacsCommandSet.
    """
    def __init__(__self__, commands=None, description=None, id=None, name=None, permit_unmatched=None):
        if commands and not isinstance(commands, list):
            raise TypeError("Expected argument 'commands' to be a list")
        pulumi.set(__self__, "commands", commands)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permit_unmatched and not isinstance(permit_unmatched, bool):
            raise TypeError("Expected argument 'permit_unmatched' to be a bool")
        pulumi.set(__self__, "permit_unmatched", permit_unmatched)

    @property
    @pulumi.getter
    def commands(self) -> Sequence['outputs.GetTacacsCommandSetCommandResult']:
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the object
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the TACACS command set
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="permitUnmatched")
    def permit_unmatched(self) -> bool:
        """
        Permit unmatched commands
        """
        return pulumi.get(self, "permit_unmatched")


class AwaitableGetTacacsCommandSetResult(GetTacacsCommandSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTacacsCommandSetResult(
            commands=self.commands,
            description=self.description,
            id=self.id,
            name=self.name,
            permit_unmatched=self.permit_unmatched)


def get_tacacs_command_set(id: Optional[str] = None,
                           name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTacacsCommandSetResult:
    """
    This data source can read the TACACS Command Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.deviceadmin.get_tacacs_command_set(id="76d24097-41c4-4558-a4d0-a8c07ac08470")
    ```


    :param str id: The id of the object
    :param str name: The name of the TACACS command set
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ise:deviceadmin/getTacacsCommandSet:getTacacsCommandSet', __args__, opts=opts, typ=GetTacacsCommandSetResult).value

    return AwaitableGetTacacsCommandSetResult(
        commands=pulumi.get(__ret__, 'commands'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        permit_unmatched=pulumi.get(__ret__, 'permit_unmatched'))


@_utilities.lift_output_func(get_tacacs_command_set)
def get_tacacs_command_set_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTacacsCommandSetResult]:
    """
    This data source can read the TACACS Command Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.deviceadmin.get_tacacs_command_set(id="76d24097-41c4-4558-a4d0-a8c07ac08470")
    ```


    :param str id: The id of the object
    :param str name: The name of the TACACS command set
    """
    ...
