/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.testng.ITestObjectFactory;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;
import org.testng.internal.objects.InstanceCreator;
import org.testng.util.Strings;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlMethodSelectors;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;
import org.testng.xml.XmlWeaver;

public class XmlSuite
implements Cloneable {
    private String m_test;
    private static final String DEFAULT_SUITE_NAME = "Default Suite";
    private String m_name = "Default Suite";
    public static final Integer DEFAULT_VERBOSE = 1;
    private Integer m_verbose = null;
    public static final ParallelMode DEFAULT_PARALLEL = ParallelMode.NONE;
    private ParallelMode m_parallel = DEFAULT_PARALLEL;
    private String m_parentModule = "";
    private String m_guiceStage = "";
    public static final FailurePolicy DEFAULT_CONFIG_FAILURE_POLICY = FailurePolicy.SKIP;
    private FailurePolicy m_configFailurePolicy = DEFAULT_CONFIG_FAILURE_POLICY;
    public static final Boolean DEFAULT_JUNIT = Boolean.FALSE;
    private Boolean m_isJUnit = DEFAULT_JUNIT;
    public static final Boolean DEFAULT_MIXED = Boolean.FALSE;
    public static final Boolean DEFAULT_SKIP_FAILED_INVOCATION_COUNTS = Boolean.FALSE;
    private Boolean m_skipFailedInvocationCounts = DEFAULT_SKIP_FAILED_INVOCATION_COUNTS;
    public static final Integer DEFAULT_THREAD_COUNT = 5;
    private int m_threadCount = DEFAULT_THREAD_COUNT;
    public static final Integer DEFAULT_DATA_PROVIDER_THREAD_COUNT = 10;
    private int m_dataProviderThreadCount = DEFAULT_DATA_PROVIDER_THREAD_COUNT;
    public static final Boolean DEFAULT_GROUP_BY_INSTANCES = false;
    private Boolean m_groupByInstances = DEFAULT_GROUP_BY_INSTANCES;
    public static final Boolean DEFAULT_ALLOW_RETURN_VALUES = Boolean.FALSE;
    private Boolean m_allowReturnValues = DEFAULT_ALLOW_RETURN_VALUES;
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlTest> m_tests = Lists.newArrayList();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private String m_fileName;
    private String m_timeOut;
    private final List<XmlSuite> m_childSuites = Lists.newArrayList();
    private XmlSuite m_parentSuite;
    private List<String> m_suiteFiles = Lists.newArrayList();
    private Class<? extends ITestObjectFactory> m_objectFactoryClass;
    private List<String> m_listeners = Lists.newArrayList();
    public static final Boolean DEFAULT_PRESERVE_ORDER = Boolean.TRUE;
    private Boolean m_preserveOrder = DEFAULT_PRESERVE_ORDER;
    private List<String> m_includedGroups = Lists.newArrayList();
    private List<String> m_excludedGroups = Lists.newArrayList();
    private XmlMethodSelectors m_xmlMethodSelectors;
    private boolean parsed = false;
    private XmlGroups m_xmlGroups;

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public ParallelMode getParallel() {
        return this.m_parallel;
    }

    public String getParentModule() {
        return this.m_parentModule;
    }

    public String getGuiceStage() {
        return this.m_guiceStage;
    }

    @Deprecated
    public ITestObjectFactory getObjectFactory() {
        return InstanceCreator.newInstance(this.getObjectFactoryClass());
    }

    public Class<? extends ITestObjectFactory> getObjectFactoryClass() {
        return this.m_objectFactoryClass;
    }

    @Deprecated
    public void setObjectFactory(ITestObjectFactory objectFactory) {
        this.setObjectFactoryClass(objectFactory.getClass());
    }

    public void setObjectFactoryClass(Class<? extends ITestObjectFactory> objectFactoryClass) {
        this.m_objectFactoryClass = objectFactoryClass;
    }

    public void setParallel(ParallelMode parallel) {
        this.m_parallel = parallel == null ? DEFAULT_PARALLEL : parallel;
    }

    public void setParentModule(String parentModule) {
        this.m_parentModule = parentModule;
    }

    public void setGuiceStage(String guiceStage) {
        this.m_guiceStage = guiceStage;
    }

    public void setConfigFailurePolicy(FailurePolicy configFailurePolicy) {
        this.m_configFailurePolicy = configFailurePolicy;
    }

    public FailurePolicy getConfigFailurePolicy() {
        return this.m_configFailurePolicy;
    }

    public Integer getVerbose() {
        return this.m_verbose != null ? this.m_verbose : RuntimeBehavior.getDefaultVerboseLevel();
    }

    public void setVerbose(Integer verbose) {
        this.m_verbose = verbose;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("Suite name cannot be null (or) empty.");
        }
        this.m_name = name;
    }

    public String getTest() {
        return this.m_test;
    }

    public List<XmlTest> getTests() {
        return this.m_tests;
    }

    public void setTests(List<XmlTest> tests) {
        this.m_tests = tests;
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        if (this.m_xmlMethodSelectors != null) {
            return this.m_xmlMethodSelectors.getMethodSelectors();
        }
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> methodSelectors) {
        this.m_methodSelectors = Lists.newArrayList(methodSelectors);
    }

    private void updateParameters() {
        if (this.m_parentSuite != null) {
            Set<String> keySet = this.m_parentSuite.getParameters().keySet();
            for (String name : keySet) {
                if (this.m_parameters.containsKey(name)) continue;
                this.m_parameters.put(name, this.m_parentSuite.getParameter(name));
            }
        }
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
        this.updateParameters();
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> result = Maps.newHashMap();
        result.putAll(this.m_parameters);
        for (XmlTest test : this.getTests()) {
            result.putAll(test.getLocalParameters());
        }
        return result;
    }

    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public int getThreadCount() {
        return this.m_threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.m_threadCount = threadCount;
    }

    public Boolean isJUnit() {
        return this.m_isJUnit;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setJunit(Boolean j) {
        this.setJUnit(j);
    }

    public Boolean skipFailedInvocationCounts() {
        return this.m_skipFailedInvocationCounts;
    }

    public void setSkipFailedInvocationCounts(boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    public void setXmlPackages(List<XmlPackage> packages) {
        this.m_xmlPackages = Lists.newArrayList(packages);
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlPackage> getPackages() {
        return this.getXmlPackages();
    }

    public void setMethodSelectors(XmlMethodSelectors xms) {
        this.m_xmlMethodSelectors = xms;
    }

    public void setPackages(List<XmlPackage> packages) {
        this.setXmlPackages(packages);
    }

    public String toXml() {
        return XmlWeaver.asXml(this);
    }

    public List<String> getLocalListeners() {
        return this.m_listeners;
    }

    public void setXmlMethodSelectors(XmlMethodSelectors xms) {
        this.m_xmlMethodSelectors = xms;
    }

    public XmlMethodSelectors getXmlMethodSelectors() {
        return this.m_xmlMethodSelectors;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[Suite: \"").append(this.m_name).append("\" ");
        for (XmlTest t2 : this.m_tests) {
            result.append("  ").append(t2.toString()).append(' ');
        }
        for (XmlMethodSelector ms : this.m_methodSelectors) {
            result.append(" methodSelector:").append(ms);
        }
        result.append(']');
        return result.toString();
    }

    public Object clone() {
        XmlSuite result = this.shallowCopy();
        result.setExcludedGroups(this.getExcludedGroups());
        result.setIncludedGroups(this.getIncludedGroups());
        result.setGroupByInstances(this.getGroupByInstances());
        result.setGroups(this.getGroups());
        result.setMethodSelectors(this.getXmlMethodSelectors());
        result.setPackages(this.getPackages());
        result.setParentSuite(this.getParentSuite());
        result.setPreserveOrder(this.getPreserveOrder());
        result.setSuiteFiles(this.getSuiteFiles());
        result.setTests(this.getTests());
        result.setXmlMethodSelectors(this.getXmlMethodSelectors());
        return result;
    }

    public XmlSuite shallowCopy() {
        XmlSuite result = new XmlSuite();
        result.setName(this.getName());
        result.setFileName(this.getFileName());
        result.setListeners(this.getListeners());
        result.setParallel(this.getParallel());
        result.setParentModule(this.getParentModule());
        result.setGuiceStage(this.getGuiceStage());
        result.setConfigFailurePolicy(this.getConfigFailurePolicy());
        result.setThreadCount(this.getThreadCount());
        result.setDataProviderThreadCount(this.getDataProviderThreadCount());
        result.setParameters(this.getParameters());
        result.setVerbose(this.getVerbose());
        result.setXmlPackages(this.getXmlPackages());
        result.setMethodSelectors(this.getMethodSelectors());
        result.setJUnit(this.isJUnit());
        result.setSkipFailedInvocationCounts(this.skipFailedInvocationCounts());
        result.setObjectFactoryClass(this.getObjectFactoryClass());
        result.setAllowReturnValues(this.getAllowReturnValues());
        result.setTimeOut(this.getTimeOut());
        return result;
    }

    public void setTimeOut(String timeOut) {
        this.m_timeOut = timeOut;
    }

    public String getTimeOut() {
        return this.m_timeOut;
    }

    public long getTimeOut(long def) {
        long result = def;
        if (this.m_timeOut != null) {
            result = Long.parseLong(this.m_timeOut);
        }
        return result;
    }

    public void setSuiteFiles(List<String> files) {
        this.m_suiteFiles = files;
    }

    public List<String> getSuiteFiles() {
        return this.m_suiteFiles;
    }

    public void setListeners(List<String> listeners) {
        this.m_listeners = listeners;
    }

    public List<String> getListeners() {
        return this.m_listeners;
    }

    public void setDataProviderThreadCount(int count) {
        this.m_dataProviderThreadCount = count;
    }

    public int getDataProviderThreadCount() {
        String s2 = RuntimeBehavior.getDefaultDataProviderThreadCount();
        try {
            if (!s2.trim().isEmpty()) {
                return Integer.parseInt(s2);
            }
        }
        catch (NumberFormatException nfe) {
            System.err.println("Parsing System property 'dataproviderthreadcount': " + nfe);
        }
        return this.m_dataProviderThreadCount;
    }

    public void setParentSuite(XmlSuite parentSuite) {
        this.m_parentSuite = parentSuite;
        this.updateParameters();
    }

    public XmlSuite getParentSuite() {
        return this.m_parentSuite;
    }

    public List<XmlSuite> getChildSuites() {
        return this.m_childSuites;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_configFailurePolicy == null ? 0 : this.m_configFailurePolicy.hashCode());
        result = 31 * result + this.m_dataProviderThreadCount;
        result = 31 * result + (this.m_fileName == null ? 0 : this.m_fileName.hashCode());
        result = 31 * result + (this.m_isJUnit == null ? 0 : this.m_isJUnit.hashCode());
        result = 31 * result + (this.m_listeners == null ? 0 : this.m_listeners.hashCode());
        result = 31 * result + (this.m_methodSelectors == null ? 0 : this.m_methodSelectors.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_objectFactoryClass == null ? 0 : this.m_objectFactoryClass.hashCode());
        result = 31 * result + (this.m_parallel == null ? 0 : this.m_parallel.hashCode());
        result = 31 * result + (this.m_skipFailedInvocationCounts == null ? 0 : this.m_skipFailedInvocationCounts.hashCode());
        result = 31 * result + (this.m_suiteFiles == null ? 0 : this.m_suiteFiles.hashCode());
        result = 31 * result + (this.m_test == null ? 0 : this.m_test.hashCode());
        result = 31 * result + (this.m_tests == null ? 0 : this.m_tests.hashCode());
        result = 31 * result + this.m_threadCount;
        result = 31 * result + (this.m_timeOut == null ? 0 : this.m_timeOut.hashCode());
        result = 31 * result + (this.m_verbose == null ? 0 : this.m_verbose.hashCode());
        result = 31 * result + (this.m_xmlPackages == null ? 0 : this.m_xmlPackages.hashCode());
        return result;
    }

    static boolean f() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != obj.getClass()) {
            return XmlSuite.f();
        }
        XmlSuite other = (XmlSuite)obj;
        if (this.m_configFailurePolicy == null ? other.m_configFailurePolicy != null : !this.m_configFailurePolicy.equals((Object)other.m_configFailurePolicy)) {
            return XmlSuite.f();
        }
        if (this.m_dataProviderThreadCount != other.m_dataProviderThreadCount) {
            return XmlSuite.f();
        }
        if (this.m_isJUnit == null ? other.m_isJUnit != null : !this.m_isJUnit.equals(other.m_isJUnit)) {
            return XmlSuite.f();
        }
        if (this.m_listeners == null ? other.m_listeners != null : !this.m_listeners.equals(other.m_listeners)) {
            return XmlSuite.f();
        }
        if (this.m_methodSelectors == null ? other.m_methodSelectors != null : !this.m_methodSelectors.equals(other.m_methodSelectors)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_objectFactoryClass == null ? other.m_objectFactoryClass != null : !this.m_objectFactoryClass.equals(other.m_objectFactoryClass)) {
            return XmlSuite.f();
        }
        if (this.m_parallel == null ? other.m_parallel != null : !this.m_parallel.equals((Object)other.m_parallel)) {
            return XmlSuite.f();
        }
        if (this.m_skipFailedInvocationCounts == null ? other.m_skipFailedInvocationCounts != null : !this.m_skipFailedInvocationCounts.equals(other.m_skipFailedInvocationCounts)) {
            return XmlSuite.f();
        }
        if (this.m_suiteFiles == null ? other.m_suiteFiles != null : !this.m_suiteFiles.equals(other.m_suiteFiles)) {
            return XmlSuite.f();
        }
        if (this.m_test == null ? other.m_test != null : !this.m_test.equals(other.m_test)) {
            return XmlSuite.f();
        }
        if (this.m_tests == null ? other.m_tests != null : !this.m_tests.equals(other.m_tests)) {
            return XmlSuite.f();
        }
        if (this.m_threadCount != other.m_threadCount) {
            return XmlSuite.f();
        }
        if (this.m_timeOut == null ? other.m_timeOut != null : !this.m_timeOut.equals(other.m_timeOut)) {
            return XmlSuite.f();
        }
        if (this.m_verbose == null ? other.m_verbose != null : !this.m_verbose.equals(other.m_verbose)) {
            return XmlSuite.f();
        }
        if (this.m_xmlPackages == null ? other.m_xmlPackages != null : !this.m_xmlPackages.equals(other.m_xmlPackages)) {
            return XmlSuite.f();
        }
        return true;
    }

    public void setPreserveOrder(Boolean f) {
        this.m_preserveOrder = f;
    }

    public Boolean getPreserveOrder() {
        return this.m_preserveOrder;
    }

    public List<String> getIncludedGroups() {
        if (this.m_parentSuite != null) {
            return this.m_parentSuite.getIncludedGroups();
        }
        if (this.m_xmlGroups != null && this.m_xmlGroups.getRun() != null) {
            return this.m_xmlGroups.getRun().getIncludes();
        }
        return this.m_includedGroups;
    }

    public void addIncludedGroup(String g2) {
        this.m_includedGroups.add(g2);
    }

    public void setIncludedGroups(List<String> g2) {
        this.m_includedGroups = g2;
    }

    public void setExcludedGroups(List<String> g2) {
        this.m_excludedGroups = g2;
    }

    public List<String> getExcludedGroups() {
        if (this.m_parentSuite != null) {
            return this.m_parentSuite.getExcludedGroups();
        }
        if (this.m_xmlGroups != null && this.m_xmlGroups.getRun() != null) {
            return this.m_xmlGroups.getRun().getExcludes();
        }
        return this.m_excludedGroups;
    }

    public void addExcludedGroup(String g2) {
        this.m_excludedGroups.add(g2);
    }

    public Boolean getGroupByInstances() {
        return this.m_groupByInstances;
    }

    public void setGroupByInstances(boolean f) {
        this.m_groupByInstances = f;
    }

    public void addListener(String listener) {
        this.m_listeners.add(listener);
    }

    public Boolean getAllowReturnValues() {
        return this.m_allowReturnValues;
    }

    public void setAllowReturnValues(Boolean allowReturnValues) {
        this.m_allowReturnValues = allowReturnValues;
    }

    public void setGroups(XmlGroups xmlGroups) {
        this.m_xmlGroups = xmlGroups;
    }

    public void onParameterElement(String name, String value) {
        this.getParameters().put(name, value);
    }

    public void onListenerElement(String className) {
        this.addListener(className);
    }

    public void onSuiteFilesElement(String path) {
        this.getSuiteFiles().add(path);
    }

    public void onPackagesElement(String name) {
        this.getPackages().add(new XmlPackage(name));
    }

    public void onMethodSelectorElement(String language, String name, String priority) {
        System.out.println("Language:" + language);
    }

    public XmlGroups getGroups() {
        return this.m_xmlGroups;
    }

    public void addTest(XmlTest test) {
        this.getTests().add(test);
    }

    public Collection<String> getPackageNames() {
        List<String> result = Lists.newArrayList();
        for (XmlPackage p : this.getPackages()) {
            result.add(p.getName());
        }
        return result;
    }

    public static enum FailurePolicy {
        SKIP("skip"),
        CONTINUE("continue");

        private final String name;

        private FailurePolicy(String name) {
            this.name = name;
        }

        public static FailurePolicy getValidPolicy(String policy) {
            if (policy == null) {
                return null;
            }
            try {
                return FailurePolicy.valueOf(policy.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ParallelMode {
        TESTS("tests", false),
        METHODS("methods"),
        CLASSES("classes"),
        INSTANCES("instances"),
        NONE("none", false);

        private final String name;
        private final boolean isParallel;

        private ParallelMode(String name) {
            this(name, true);
        }

        private ParallelMode(String name, boolean isParallel) {
            this.name = name;
            this.isParallel = isParallel;
        }

        private static void warnUser(String value, ParallelMode mode) {
            Utils.log(XmlSuite.class.getSimpleName(), 1, "[WARN] 'parallel' value '" + value + "' is no longer valid, defaulting to '" + (Object)((Object)mode) + "'.");
        }

        public static ParallelMode getValidParallel(String parallel) {
            if (parallel == null) {
                return NONE;
            }
            try {
                return ParallelMode.valueOf(parallel.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                if ("true".equalsIgnoreCase(parallel)) {
                    ParallelMode.warnUser("true", METHODS);
                    return METHODS;
                }
                if ("false".equalsIgnoreCase(parallel)) {
                    ParallelMode.warnUser("false", NONE);
                    return NONE;
                }
                return NONE;
            }
        }

        public boolean isParallel() {
            return this.isParallel;
        }

        public String toString() {
            return this.name;
        }
    }
}

