# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class EventBase(object):

    def __init__(self, data=None, event_type=None):
        """
        EventBase - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'data': 'EventData',
            'event_type': 'str'
        }

        self.attribute_map = {
            'data': 'data',
            'event_type': 'event_type'
        }

        self._data = data
        self._event_type = event_type

    @property
    def data(self):
        """
        Gets the data of this EventBase.


        :return: The data of this EventBase.
        :rtype: EventData
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this EventBase.


        :param data: The data of this EventBase.
        :type: EventData
        """

        self._data = data

    @property
    def event_type(self):
        """
        Gets the event_type of this EventBase.


        :return: The event_type of this EventBase.
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """
        Sets the event_type of this EventBase.


        :param event_type: The event_type of this EventBase.
        :type: str
        """
        allowed_values = ["unknown", "session_start", "session_end", "screen_view", "custom_event", "crash_report", "opt_out", "first_run", "pre_attribution", "push_registration", "application_state_transition", "push_message", "network_performance", "breadcrumb", "profile", "push_reaction", "commerce_event"]
        if event_type not in allowed_values:
            raise ValueError(
                "Invalid value for `event_type` ({0}), must be one of {1}"
                .format(event_type, allowed_values)
            )

        self._event_type = event_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
