# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class ProductAction(object):

    def __init__(self, action=None, checkout_step=None, checkout_options=None, product_action_list=None, product_list_source=None, transaction_id=None, affiliation=None, total_amount=None, tax_amount=None, shipping_amount=None, coupon_code=None, products=None):
        """
        ProductAction - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'str',
            'checkout_step': 'int',
            'checkout_options': 'str',
            'product_action_list': 'str',
            'product_list_source': 'str',
            'transaction_id': 'str',
            'affiliation': 'str',
            'total_amount': 'float',
            'tax_amount': 'float',
            'shipping_amount': 'float',
            'coupon_code': 'str',
            'products': 'list[Product]'
        }

        self.attribute_map = {
            'action': 'action',
            'checkout_step': 'checkout_step',
            'checkout_options': 'checkout_options',
            'product_action_list': 'product_action_list',
            'product_list_source': 'product_list_source',
            'transaction_id': 'transaction_id',
            'affiliation': 'affiliation',
            'total_amount': 'total_amount',
            'tax_amount': 'tax_amount',
            'shipping_amount': 'shipping_amount',
            'coupon_code': 'coupon_code',
            'products': 'products'
        }

        self._action = action
        self._checkout_step = checkout_step
        self._checkout_options = checkout_options
        self._product_action_list = product_action_list
        self._product_list_source = product_list_source
        self._transaction_id = transaction_id
        self._affiliation = affiliation
        self._total_amount = total_amount
        self._tax_amount = tax_amount
        self._shipping_amount = shipping_amount
        self._coupon_code = coupon_code
        self._products = products

    @property
    def action(self):
        """
        Gets the action of this ProductAction.


        :return: The action of this ProductAction.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this ProductAction.


        :param action: The action of this ProductAction.
        :type: str
        """
        allowed_values = ["unknown", "add_to_cart", "remove_from_cart", "checkout", "checkout_option", "click", "view_detail", "purchase", "refund", "add_to_wishlist", "remove_from_wish_list"]
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def checkout_step(self):
        """
        Gets the checkout_step of this ProductAction.


        :return: The checkout_step of this ProductAction.
        :rtype: int
        """
        return self._checkout_step

    @checkout_step.setter
    def checkout_step(self, checkout_step):
        """
        Sets the checkout_step of this ProductAction.


        :param checkout_step: The checkout_step of this ProductAction.
        :type: int
        """

        self._checkout_step = checkout_step

    @property
    def checkout_options(self):
        """
        Gets the checkout_options of this ProductAction.


        :return: The checkout_options of this ProductAction.
        :rtype: str
        """
        return self._checkout_options

    @checkout_options.setter
    def checkout_options(self, checkout_options):
        """
        Sets the checkout_options of this ProductAction.


        :param checkout_options: The checkout_options of this ProductAction.
        :type: str
        """

        self._checkout_options = checkout_options

    @property
    def product_action_list(self):
        """
        Gets the product_action_list of this ProductAction.


        :return: The product_action_list of this ProductAction.
        :rtype: str
        """
        return self._product_action_list

    @product_action_list.setter
    def product_action_list(self, product_action_list):
        """
        Sets the product_action_list of this ProductAction.


        :param product_action_list: The product_action_list of this ProductAction.
        :type: str
        """

        self._product_action_list = product_action_list

    @property
    def product_list_source(self):
        """
        Gets the product_list_source of this ProductAction.


        :return: The product_list_source of this ProductAction.
        :rtype: str
        """
        return self._product_list_source

    @product_list_source.setter
    def product_list_source(self, product_list_source):
        """
        Sets the product_list_source of this ProductAction.


        :param product_list_source: The product_list_source of this ProductAction.
        :type: str
        """

        self._product_list_source = product_list_source

    @property
    def transaction_id(self):
        """
        Gets the transaction_id of this ProductAction.


        :return: The transaction_id of this ProductAction.
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """
        Sets the transaction_id of this ProductAction.


        :param transaction_id: The transaction_id of this ProductAction.
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def affiliation(self):
        """
        Gets the affiliation of this ProductAction.


        :return: The affiliation of this ProductAction.
        :rtype: str
        """
        return self._affiliation

    @affiliation.setter
    def affiliation(self, affiliation):
        """
        Sets the affiliation of this ProductAction.


        :param affiliation: The affiliation of this ProductAction.
        :type: str
        """

        self._affiliation = affiliation

    @property
    def total_amount(self):
        """
        Gets the total_amount of this ProductAction.


        :return: The total_amount of this ProductAction.
        :rtype: float
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """
        Sets the total_amount of this ProductAction.


        :param total_amount: The total_amount of this ProductAction.
        :type: float
        """

        self._total_amount = total_amount

    @property
    def tax_amount(self):
        """
        Gets the tax_amount of this ProductAction.


        :return: The tax_amount of this ProductAction.
        :rtype: float
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount):
        """
        Sets the tax_amount of this ProductAction.


        :param tax_amount: The tax_amount of this ProductAction.
        :type: float
        """

        self._tax_amount = tax_amount

    @property
    def shipping_amount(self):
        """
        Gets the shipping_amount of this ProductAction.


        :return: The shipping_amount of this ProductAction.
        :rtype: float
        """
        return self._shipping_amount

    @shipping_amount.setter
    def shipping_amount(self, shipping_amount):
        """
        Sets the shipping_amount of this ProductAction.


        :param shipping_amount: The shipping_amount of this ProductAction.
        :type: float
        """

        self._shipping_amount = shipping_amount

    @property
    def coupon_code(self):
        """
        Gets the coupon_code of this ProductAction.


        :return: The coupon_code of this ProductAction.
        :rtype: str
        """
        return self._coupon_code

    @coupon_code.setter
    def coupon_code(self, coupon_code):
        """
        Sets the coupon_code of this ProductAction.


        :param coupon_code: The coupon_code of this ProductAction.
        :type: str
        """

        self._coupon_code = coupon_code

    @property
    def products(self):
        """
        Gets the products of this ProductAction.


        :return: The products of this ProductAction.
        :rtype: list[Product]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this ProductAction.


        :param products: The products of this ProductAction.
        :type: list[Product]
        """

        self._products = products

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
