# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import os
import sys
import unittest

import mparticle
from mparticle.rest import ApiException
from mparticle.models.app_event import AppEvent


class TestAppEvent(unittest.TestCase):

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testAppEvent(self):
        event = mparticle.models.app_event.AppEvent(
            event_name='test event', 
            custom_event_type='transaction', 
            custom_attributes = {'example attribute key':'example attribute value'}
            )
        self.assertEqual('test event', event.event_name)
        self.assertEqual('transaction', event.custom_event_type)
        self.assertEqual('example attribute value', event.custom_attributes['example attribute key'])

    def testAppEventAttributeValues(self):
        with self.assertRaises(ValueError):
            event = mparticle.models.app_event.AppEvent(
                event_name='test event', 
                custom_event_type='transaction', 
                custom_attributes = {'example attribute key': ['something']}
                )

        event = mparticle.models.app_event.AppEvent(
            event_name='test event', 
            custom_event_type='transaction', 
            custom_attributes=None
            )
        with self.assertRaises(ValueError):
            event.custom_attributes = {'example attribute key': ['something']}
        

    def testAttributionEvent(self):
        event = mparticle.models.app_event.AppEvent.create_attribution_event(u'this is a publisher', 'this is a campaign')
        self.assertEqual('attribution', event.custom_event_type)
        self.assertEqual('attribution', event.event_name)
        self.assertEqual('this is a campaign', event.custom_attributes['campaign'])
        self.assertEqual(u'this is a publisher', event.custom_attributes['publisher'])

    def testAttributionDeleteEvent(self):
        event = mparticle.models.app_event.AppEvent.create_attribution_delete_event()
        self.assertEqual('attribution', event.custom_event_type)
        self.assertEqual('attribution', event.event_name)
        self.assertEqual('delete', event.custom_attributes['action'])
        self.assertFalse('campaign' in event.custom_attributes)
        self.assertFalse('publisher' in event.custom_attributes)

if __name__ == '__main__':
    unittest.main()
