# coding: utf-8

"""
    mParticle

    mParticle Event API

    OpenAPI spec version: 1.0.1
    Contact: support@mparticle.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import os
import sys
import unittest

import mparticle
from mparticle.rest import ApiException
from mparticle.models.user_identities import UserIdentities


class TestUserIdentities(unittest.TestCase):
    """ UserIdentities unit test stubs """

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testUserIdentities(self):
        model = mparticle.models.user_identities.UserIdentities()

    def testOtherUserIdentitiesConstructor(self):
        model = mparticle.models.user_identities.UserIdentities(other2="foo-other2", other3="foo-other3", other4="foo-other4")
        self.assertEqual("foo-other2", model.other2)
        self.assertEqual("foo-other3", model.other3)
        self.assertEqual("foo-other4", model.other4)


    def testOtherUserIdentitiesProperties(self):
        model = mparticle.models.user_identities.UserIdentities()
        model.other2 = "foo-other2"
        model.other3 = "foo-other3"
        model.other4 = "foo-other4"
        self.assertEqual("foo-other2", model.other2)
        self.assertEqual("foo-other3", model.other3)
        self.assertEqual("foo-other4", model.other4)

    def testOtherUserIdentitiesSerialization(self):
        model = mparticle.models.user_identities.UserIdentities()
        identity_dict = model.to_dict()
        for key in identity_dict:
            self.assertEqual(None, identity_dict[key])

        model.other2 = "foo-other2"
        model.other3 = "foo-other3"
        model.other4 = "foo-other4"
        identity_dict = model.to_dict()
        self.assertEqual("foo-other2", identity_dict["other2"])
        self.assertEqual("foo-other3", identity_dict["other3"])
        self.assertEqual("foo-other4", identity_dict["other4"])


if __name__ == '__main__':
    unittest.main()
