import hashlib
from struct import unpack
from mlib.crypto import serpent,rc6
from mlib.compression import aplib


CMDS = ['LOAD_UPDATE', 'LOAD_INI', 'GET_SYSINFO', 'LOAD_DLL', 'GROUP', 'SELF_DELETE', 'GET_CERTS',
        'CLR_COOKIES', 'URL_BLOCK', 'KILL', 'GET_FILES', 'GET_COOKIES', 'LOAD_REG_DLL', 'LOAD_EXE']


def _decode_meta(pkey, enc_m, block):
    def cv(x):
        x = hex(x)[2:].strip('L')
        x = x.zfill(block * 2)
        return x.decode('hex')

    def strip_padd(x):
        if x[:2] == "\x00\x01":
            o = x[2:].find("\x00") + 1 + 2
            return x[o:]
        return x

    # we need to do rsa-pubkey decryption/unsing via hand...
    meta = pow(long(enc_m.encode('hex'), 16), pkey[1], pkey[0])
    meta = cv(meta)

    meta = strip_padd(meta)
    md5 = meta[:0x10]
    xkey = meta[0x10:0x20]
    ss = unpack('I', meta[0x10 * 2:0x10 * 2 + 4])[0]
    return md5, xkey, ss


def raw_decrypt_buffer(d, pkey, decrypt, xunpack=True):
    block = len(hex(pkey[0])[2:].strip('L')) / 2
    # decode last block as meta data
    md5, xkey, ss = _decode_meta(pkey, d[-block:], block)
    # with# open('/tmp/isfbx.xdec.bin','w') as f: f.write(d)

    d = decrypt(d[:-block], xkey)[:ss]

    if md5 == hashlib.md5(d).digest():
        if not d:
            return
        if any(map(lambda x: d.startswith(x), CMDS)):
            return d
        s = unpack('I', d[:4])[0]
        return aplib.decompress(d[4:], s + 0x10) if xunpack else d
    else:
        raise Exception('Wrong checksum')


def full_decrypt_buffer(data,pk,xunpack=False):
    
    
    def decryptor(d,k):
        return rc6.decrypt(d,k,typ='str',inverse=True,iv = [0,0,0,0])

    algos = [('rc6big',decryptor),
            ('serpent',serpent.decrypt),
            ('rc6',rc6.decrypt)
    ]
    cfg = None
    for enc_typ, enc in algos:
        try:
            cfg = raw_decrypt_buffer(data,pk,enc,xunpack)
            break
        except:
            pass
    return cfg,enc_typ

def decrypt_buffer(data,pk,xunpack=False):
    return full_decrypt_buffer(data,pk,xunpack)[0]
