import ctypes as c
import hashlib
from mlib.crypto import rc4
from mlib.compression import gzip
from mlib.struct import Structure


def find_buffer(d):
    r = -1, None
    for i in range(len(d) - 0x300):
        data = d[i:i + 0x300]
        key = hashlib.md5(data[:16]).digest()
        xdata = rc4.decrypt(data[16:], key)
        chk = hashlib.md5(data[:16] + xdata[:-16]).digest()

        if chk == xdata[752 - 16:]:
            r = i, data[:16] + xdata
            break
    return r


class C(Structure):
    _pack_ = 1
    _fields_ = [
        ('key', c.c_ubyte * 0x10),
        ('unk1', c.c_uint),
        ('unk2', c.c_uint),
        ('file_name', c.c_char * 20),
        ('_ds', c.c_ushort),
        ('_d', c.c_ubyte * (0x300 - 0x10 * 2 - 8 - 20 - 2)),
        ('checksum', c.c_ubyte * 0x10)
    ]
    _blacklist_ = ['key', 'checksum', '_ds', '_d']

    @property
    def data(self):
        if not hasattr(self, '_data'):
            d = ''.join(map(chr, self._d[:self._ds]))
            self._data = gzip.decompress(d)
        return self._data

    def as_dict(self):
        r = super(C, self).as_dict()
        r['data'] = self.data
        return r


def parse_cfg(data):
    return C.parse(data)
