import hashlib
from mlib.crypto import aes
from mlib.rnd import LCG

BS = 16


def pad(s): return s + (BS - len(s) % BS) * chr(BS - len(s) % BS)


def unpad(s): return s[:-ord(s[len(s) - 1:])]


def hash_rounds(data_buf):
    while len(data_buf) <= 0x1000:
        buf_hash = hashlib.sha256(data_buf).digest()
        data_buf += buf_hash
    return buf_hash


def decrypt(data):
    key = hash_rounds(data[:0x20])[:0x20]
    iv = hash_rounds(data[0x10:0x30])[:0x10]
    data = pad(data[0x30:])
    return aes.decrypt(data, key, None, 'cbc', iv)


class TrickLCG(LCG):
    mul = 0xAE529
    add = 0x24D69
