win11_theme = {
    "window": {
        "back": "#f4f4f4"
    },

    "label": {
        "back": "transparent",
        "text_back": "#000000",
    },

    "button": {
        "radius": 13,
        "back": "#fdfdfd",
        "border": "#ededed",
        "text_back": "#202020",
        "border_width": 1,

        "active": {
            "back": "#f9f9f9",
            "border": "#d5d5d5",
            "text_back": "#202020",
            "border_width": 1,
        },

        "pressed": {
            "back": "#fafafa",
            "border": "#ebebeb",
            "text_back": "#202020",
            "border_width": 1,
        },
    },

    "circular_button": {
        "back": "#fdfdfd",
        "border": "#ededed",
        "text_back": "#202020",
        "border_width": 1,

        "active": {
            "back": "#f9f9f9",
            "border": "#d5d5d5",
            "text_back": "#202020",
            "border_width": 1,
        },

        "pressed": {
            "back": "#fafafa",
            "border": "#ebebeb",
            "text_back": "#202020",
            "border_width": 1,
        },
    },

    "frame": {
        "radius": 15,
        "back": "#fafafa",
        "border": "#e7e7e7",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 13,
        "padding": (8, 8),

        "back": "#ffffff",
        "border": "#e6e6e6",
        "text_back": "#18191c",
        "border_width": 1,

        "bottom_line": "#9c9c9c",
        "bottom_width": 1,

        "focusin": {
            "back": "#ffffff",
            "border": "#ebebeb",
            "text_back": "#18191c",
            "border_width": 1,

            "bottom_line": "#005fb8",
            "bottom_width": 2,
        }
    },

    "text": {
        "radius": 13,
        "padding": (8, 8),

        "back": "#ffffff",
        "border": "#e6e6e6",
        "text_back": "#18191c",
        "border_width": 1,

        "bottom_line": "#9c9c9c",
        "bottom_width": 1,

        "focusin": {
            "back": "#ffffff",
            "border": "#ebebeb",
            "text_back": "#18191c",
            "border_width": 1,

            "bottom_line": "#005fb8",
            "bottom_width": 2,
        }
    },

    "separator": {
        "back": "#d0d0d0",
        "border_width": 1,

        "rounded": True
    },

    "designer_frame": {
        "border": "black",
        "grip": "black"
    },

    "listbox": {
        "back": "#fafafa",
        "border": "#e7e7e7",
        "border_width": 1,
        "padding": 0,
        "radius": 6,

        "item_back": "#fafafa",
        "item_border": "#fafafa",
        "item_text": "#000000",

        "item_radius": 8,
        "item_height": 25,
        "item_padding": 1,

        "active": {
            "item_back": "#005fb8",
            "item_border": "#005fb8",
            "item_text": "#ffffff",
        },
    }
}

win11_dark_theme = {
    "window": {
        "back": "#202020"
    },

    "label": {
        "back": "transparent",
        "text_back": "#ffffff",
    },

    "button": {
        "radius": 13,
        "back": "#2a2a2a",
        "border": "#313131",
        "text_back": "#ebebeb",
        "border_width": 1,

        "active": {
            "back": "#2f2f2f",
            "border": "#313131",
            "text_back": "#ebebeb",
            "border_width": 1,
        },

        "pressed": {
            "back": "#232323",
            "border": "#2c2c2c",
            "text_back": "#ebebeb",
            "border_width": 1,
        },
    },

    "circular_button": {
        "back": "#2a2a2a",
        "border": "#313131",
        "text_back": "#ebebeb",
        "border_width": 1,

        "active": {
            "back": "#2f2f2f",
            "border": "#313131",
            "text_back": "#ebebeb",
            "border_width": 1,
        },

        "pressed": {
            "back": "#232323",
            "border": "#2c2c2c",
            "text_back": "#ebebeb",
            "border_width": 1,
        },
    },

    "frame": {
        "radius": 15,
        "back": "#1c1c1c",
        "border": "#2f2f2f",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 13,
        "padding": (8, 8),

        "back": "#2c2c2c",
        "border": "#383838",
        "text_back": "#e7e9eb",
        "border_width": 1,

        "bottom_line": "#686868",
        "bottom_width": 1,

        "focusin": {
            "back": "#1c1c1c",
            "border": "#2c2c2c",
            "text_back": "#e7e9eb",
            "border_width": 1,

            "bottom_line": "#57c8ff",
            "bottom_width": 2,
        }
    },

    "text": {
        "radius": 13,
        "padding": (8, 8),

        "back": "#2c2c2c",
        "border": "#383838",
        "text_back": "#e7e9eb",
        "border_width": 1,

        "bottom_line": "#686868",
        "bottom_width": 1,

        "focusin": {
            "back": "#1c1c1c",
            "border": "#2c2c2c",
            "text_back": "#e7e9eb",
            "border_width": 1,

            "bottom_line": "#57c8ff",
            "bottom_width": 2,
        }
    },

    "separator": {
        "back": "#404040",
        "border_width": 1,

        "rounded": True
    },

    "designer_frame": {
        "border": "white",
        "grip": "white"
    },

    "listbox": {
        "back": "#1c1c1c",
        "border": "#2f2f2f",
        "border_width": 1,
        "padding": 0,
        "radius": 6,

        "item_back": "#1c1c1c",
        "item_border": "#1c1c1c",
        "item_text": "#ffffff",

        "item_radius": 8,
        "item_height": 25,
        "item_padding": 1,

        "active": {
            "item_back": "#57c8ff",
            "item_border": "#57c8ff",
            "item_text": "#000000",
        },
    }
}

gtk_theme = {
    "window": {
        "back": "#ffffff"
    },

    "label": {
        "back": "transparent",
        "text_back": "#000000",
    },

    "button": {
        "radius": 11,
        "back": "#f6f5f4",
        "border": "#ccc6c1",
        "text_back": "#2e3436",
        "border_width": 1.3,

        "active": {
            "back": "#f8f8f7",
            "border": "#dad6d2",
            "text_back": "#2e3436",
            "border_width": 1.3,
        },

        "pressed": {
            "back": "#dad6d2",
            "border": "#dad6d2",
            "text_back": "#2e3436",
            "border_width": 1.3,
        },
    },

    "circular_button": {
        "back": "#f6f5f4",
        "border": "#ccc6c1",
        "text_back": "#2e3436",
        "border_width": 1.3,

        "active": {
            "back": "#f8f8f7",
            "border": "#dad6d2",
            "text_back": "#2e3436",
            "border_width": 1.3,
        },

        "pressed": {
            "back": "#dad6d2",
            "border": "#dad6d2",
            "text_back": "#2e3436",
            "border_width": 1.3,
        },
    },

    "frame": {
        "radius": 0,
        "back": "#f6f5f4",
        "border": "#d5d0cc",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 11,
        "padding": (5, 5),

        "back": "#ffffff",
        "border": "#cdc7c2",
        "text_back": "#000000",
        "border_width": 1,

        "bottom_line": "#eaeaea",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#3584e4",
            "text_back": "#000000",
            "border_width": 1,

            "bottom_line": "#185fb4",
            "bottom_width": 0,
        }
    },

    "text": {
        "padding": (5, 5),

        "radius": 0,
        "back": "#ffffff",
        "border": "#cdc7c2",
        "text_back": "#000000",
        "border_width": 1,

        "bottom_line": "#eaeaea",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#3584e4",
            "text_back": "#000000",
            "border_width": 1,

            "bottom_line": "#185fb4",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#d8d4d0",
        "border_width": 1,

        "rounded": True
    },

    "designer_frame": {
        "border": "black",
        "grip": "black"
    },

    "listbox": {
        "back": "#f6f5f4",
        "border": "#d5d0cc",
        "border_width": 1,
        "padding": 0,
        "radius": 0,

        "item_back": "#f6f5f4",
        "item_border": "#f6f5f4",
        "item_text": "#000000",

        "item_radius": 8,
        "item_height": 25,
        "item_padding": 1,

        "active": {
            "item_back": "#3584e4",
            "item_border": "#3584e4",
            "item_text": "#ffffff",
        },
    }
}

gtk_dark_theme = {
    "window": {
        "back": "#353535"
    },

    "label": {
        "back": "transparent",
        "text_back": "#ffffff",
    },

    "button": {
        "radius": 11,
        "back": "#353535",
        "border": "#1b1b1b",
        "text_back": "#eeeeec",
        "border_width": 1.3,

        "active": {
            "back": "#373737",
            "border": "#1b1b1b",
            "text_back": "#eeeeec",
            "border_width": 1.3,
        },

        "pressed": {
            "back": "#1e1e1e",
            "border": "#282828",
            "text_back": "#eeeeec",
            "border_width": 1.3,
        },
    },

    "circular_button": {
        "back": "#353535",
        "border": "#1b1b1b",
        "text_back": "#eeeeec",
        "border_width": 1.3,

        "active": {
            "back": "#373737",
            "border": "#1b1b1b",
            "text_back": "#eeeeec",
            "border_width": 1.3,
        },

        "pressed": {
            "back": "#1e1e1e",
            "border": "#282828",
            "text_back": "#eeeeec",
            "border_width": 1.3,
        },
    },

    "frame": {
        "radius": 0,
        "back": "#313131",
        "border": "#1b1b1b",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 11,
        "padding": (5, 5),

        "back": "#2d2d2d",
        "border": "#1f1f1f",
        "text_back": "#cccccc",
        "border_width": 1,

        "bottom_line": "#eaeaea",
        "bottom_width": 0,

        "focusin": {
            "back": "#2d2d2d",
            "border": "#3584e4",
            "text_back": "#ffffff",
            "border_width": 1,

            "bottom_line": "#3584e4",
            "bottom_width": 0,
        }
    },

    "text": {
        "padding": (5, 5),

        "radius": 0,
        "back": "#2d2d2d",
        "border": "#1f1f1f",
        "text_back": "#cccccc",
        "border_width": 1,

        "bottom_line": "#eaeaea",
        "bottom_width": 0,

        "focusin": {
            "back": "#2d2d2d",
            "border": "#3584e4",
            "text_back": "#ffffff",
            "border_width": 1,

            "bottom_line": "#3584e4",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#282828",
        "border_width": 1,

        "rounded": True
    },

    "designer_frame": {
        "border": "white",
        "grip": "white"
    },

    "listbox": {
        "back": "#313131",
        "border": "#1b1b1b",
        "border_width": 1,
        "padding": 0,
        "radius": 0,

        "item_back": "#313131",
        "item_border": "#313131",
        "item_text": "#ffffff",

        "item_radius": 8,
        "item_height": 25,
        "item_padding": 1,

        "active": {
            "item_back": "#3584e4",
            "item_border": "#3584e4",
            "item_text": "#000000",
        },
    },
}

bilibili_theme = {
    "window": {
        "back": "#ffffff"
    },

    "label": {
        "back": "transparent",
        "text_back": "#000000",
    },

    "button": {
        "radius": 16,
        "back": "#ffffff",
        "border": "#e3e5e7",
        "text_back": "#18191c",
        "border_width": 1,

        "active": {
            "back": "#e3e5e7",
            "border": "#e3e5e7",
            "text_back": "#18191c",
            "border_width": 1,
        },

        "pressed": {
            "back": "#eceff0",
            "border": "#e3e5e7",
            "text_back": "#6d7479",
            "border_width": 1,
        },
    },

    "circular_button": {
        "back": "#ffffff",
        "border": "#e3e5e7",
        "text_back": "#18191c",
        "border_width": 1,

        "active": {
            "back": "#e3e5e7",
            "border": "#e3e5e7",
            "text_back": "#18191c",
            "border_width": 1,
        },

        "pressed": {
            "back": "#eceff0",
            "border": "#e3e5e7",
            "text_back": "#6d7479",
            "border_width": 1,
        },
    },

    "frame": {
        "radius": 18,
        "back": "#f6f7f8",
        "border": "#f1f2f3",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 16,
        "padding": (8, 8),

        "back": "#ffffff",
        "border": "#e3e5e7",
        "text_back": "#18191c",
        "border_width": 1,

        "bottom_line": "#eaeaea",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#ff6699",
            "text_back": "#18191c",
            "border_width": 1,

            "bottom_line": "#185fb4",
            "bottom_width": 0,
        }
    },

    "text": {
        "radius": 16,
        "padding": (8, 8),

        "back": "#ffffff",
        "border": "#e3e5e7",
        "text_back": "#18191c",
        "border_width": 1,

        "bottom_line": "#eaeaea",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#ff6699",
            "text_back": "#18191c",
            "border_width": 1,

            "bottom_line": "#185fb4",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#f1f2f3",
        "border_width": 1,

        "rounded": True
    },

    "designer_frame": {
        "border": "#ff6699",
        "grip": "#ff6699"
    },

    "listbox": {
        "back": "#f6f7f8",
        "border": "#f1f2f3",
        "border_width": 1,
        "padding": 0,
        "radius": 18,

        "item_back": "#f6f7f8",
        "item_border": "#f6f7f8",
        "item_text": "#000000",

        "item_radius": 14,
        "item_height": 40,
        "item_padding": 1,

        "active": {
            "item_back": "#d44e7d",
            "item_border": "#d44e7d",
            "item_text": "#ffffff",
        },
    },
}

bilibili_dark_theme = {
    "window": {
        "back": "#17181a"
    },

    "label": {
        "back": "transparent",
        "text_back": "#ffffff",
    },

    "button": {
        "radius": 16,
        "back": "#242628",
        "border": "#2f3134",
        "text_back": "#dcdee0",
        "border_width": 1,

        "active": {
            "back": "#2f3134",
            "border": "#2f3134",
            "text_back": "#dcdee0",
            "border_width": 1,
        },

        "pressed": {
            "back": "#26282a",
            "border": "#2f3134",
            "text_back": "#a9abad",
            "border_width": 1,
        },
    },

    "circular_button": {
        "radius": 16,
        "back": "#242628",
        "border": "#2f3134",
        "text_back": "#dcdee0",
        "border_width": 1,

        "active": {
            "back": "#2f3134",
            "border": "#2f3134",
            "text_back": "#dcdee0",
            "border_width": 1,
        },

        "pressed": {
            "back": "#26282a",
            "border": "#2f3134",
            "text_back": "#a9abad",
            "border_width": 1,
        },
    },

    "frame": {
        "radius": 18,
        "back": "#1e2022",
        "border": "#232527",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 16,
        "padding": (8, 8),

        "back": "#17181a",
        "border": "#2f3134",
        "text_back": "#e7e9eb",
        "border_width": 1,

        "bottom_line": "#eaeaea",
        "bottom_width": 0,

        "focusin": {
            "back": "#17181a",
            "border": "#d44e7d",
            "text_back": "#e7e9eb",
            "border_width": 1,

            "bottom_line": "#d44e7d",
            "bottom_width": 0,
        }
    },

    "text": {
        "radius": 16,
        "padding": (8, 8),

        "back": "#17181a",
        "border": "#2f3134",
        "text_back": "#e7e9eb",
        "border_width": 1,

        "bottom_line": "#eaeaea",
        "bottom_width": 0,

        "focusin": {
            "back": "#17181a",
            "border": "#d44e7d",
            "text_back": "#e7e9eb",
            "border_width": 1,

            "bottom_line": "#d44e7d",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#232527",
        "border_width": 1,

        "rounded": True
    },

    "designer_frame": {
        "border": "#ff6699",
        "grip": "#ff6699"
    },

    "listbox": {
        "back": "#1e2022",
        "border": "#232527",
        "border_width": 1,
        "padding": 0,
        "radius": 18,

        "item_back": "#1e2022",
        "item_border": "#1e2022",
        "item_text": "#ffffff",

        "item_radius": 14,
        "item_height": 40,
        "item_padding": 1,

        "active": {
            "item_back": "#d44e7d",
            "item_border": "#d44e7d",
            "item_text": "#000000",
        },
    },
}

metro_theme = {
    "window": {
        "back": "#ffffff"
    },

    "label": {
        "back": "transparent",
        "text_back": "#000000",
    },

    "button": {
        "radius": 0,
        "back": "#eeeeee",
        "border": "#cccccc",
        "text_back": "#000000",
        "border_width": 1,

        "active": {
            "back": "#666666",
            "border": "#666666",
            "text_back": "#ffffff",
            "border_width": 1,
        },

        "pressed": {
            "back": "#333333",
            "border": "#333333",
            "text_back": "#ffffff",
            "border_width": 1,
        },
    },

    "circular_button": {
        "back": "#eeeeee",
        "border": "#cccccc",
        "text_back": "#000000",
        "border_width": 1,

        "active": {
            "back": "#666666",
            "border": "#666666",
            "text_back": "#ffffff",
            "border_width": 1,
        },

        "pressed": {
            "back": "#333333",
            "border": "#333333",
            "text_back": "#ffffff",
            "border_width": 1,
        },
    },

    "frame": {
        "radius": 0,
        "back": "#ffffff",
        "border": "#bfbfbf",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 0,
        "padding": (3, 3),

        "back": "#ffffff",
        "border": "#999999",
        "text_back": "#000000",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#00aedb",
            "text_back": "#000000",
            "border_width": 1,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "text": {
        "radius": 0,
        "padding": (3, 3),

        "back": "#ffffff",
        "border": "#999999",
        "text_back": "#000000",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#00aedb",
            "text_back": "#000000",
            "border_width": 1,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#999999",
        "border_width": 1,

        "rounded": True
    },

    "designer_frame": {
        "border": "black",
        "grip": "black"
    },

    "listbox": {
        "back": "#ffffff",
        "border": "#bfbfbf",
        "border_width": 1,
        "padding": 0,
        "radius": 0,

        "item_back": "#ffffff",
        "item_border": "#ffffff",
        "item_text": "#000000",

        "item_radius": 8,
        "item_height": 35,
        "item_padding": 1,

        "active": {
            "item_back": "#666666",
            "item_border": "#666666",
            "item_text": "#ffffff",
        },
    },
}

metro_dark_theme = {
    "window": {
        "back": "#111111"
    },

    "label": {
        "back": "transparent",
        "text_back": "#ffffff",
    },

    "button": {
        "radius": 0,
        "back": "#222222",
        "border": "#444444",
        "text_back": "#ffffff",
        "border_width": 1,

        "active": {
            "back": "#aaaaaa",
            "border": "#aaaaaa",
            "text_back": "#000000",
            "border_width": 1,
        },

        "pressed": {
            "back": "#eeeeee",
            "border": "#eeeeee",
            "text_back": "#000000",
            "border_width": 1,
        },
    },

    "circular_button": {
        "back": "#222222",
        "border": "#444444",
        "text_back": "#ffffff",
        "border_width": 1,

        "active": {
            "back": "#aaaaaa",
            "border": "#aaaaaa",
            "text_back": "#000000",
            "border_width": 1,
        },

        "pressed": {
            "back": "#eeeeee",
            "border": "#eeeeee",
            "text_back": "#000000",
            "border_width": 1,
        },
    },

    "frame": {
        "radius": 0,
        "back": "#111111",
        "border": "#373737",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 0,
        "padding": (3, 3),

        "back": "#111111",
        "border": "#999999",
        "text_back": "#ffffff",
        "border_width": 1,

        "bottom_line": "#000000",
        "bottom_width": 0,

        "focusin": {
            "back": "#111111",
            "border": "#00aedb",
            "text_back": "#ffffff",
            "border_width": 1,

            "bottom_line": "#000000",
            "bottom_width": 0,
        }
    },

    "text": {
        "radius": 0,
        "padding": (3, 3),

        "back": "#111111",
        "border": "#999999",
        "text_back": "#ffffff",
        "border_width": 1,

        "bottom_line": "#000000",
        "bottom_width": 0,

        "focusin": {
            "back": "#111111",
            "border": "#00aedb",
            "text_back": "#ffffff",
            "border_width": 1,

            "bottom_line": "#000000",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#999999",
        "border_width": 1,

        "rounded": False
    },

    "designer_frame": {
        "border": "white",
        "grip": "white"
    },

    "listbox": {
        "back": "#111111",
        "border": "#373737",
        "border_width": 1,
        "padding": 0,
        "radius": 0,

        "item_back": "#111111",
        "item_border": "#111111",
        "item_text": "#ffffff",

        "item_radius": 8,
        "item_height": 35,
        "item_padding": 1,

        "active": {
            "item_back": "#aaaaaa",
            "item_border": "#aaaaaa",
            "item_text": "#000000",
        },
    },
}

basic_theme = {
    "window": {
        "back": "#f0f0f0"
    },

    "label": {
        "back": "transparent",
        "text_back": "#000000",
    },

    "button": {
        "radius": 0,
        "back": "#ffffff",
        "border": "#a0a0a0",
        "text_back": "#000000",
        "border_width": 1,

        "active": {
            "back": "#dce9fc",
            "border": "#a0a0a0",
            "text_back": "#000000",
            "border_width": 1,
        },

        "pressed": {
            "back": "#dce9fc",
            "border": "#4e6d9c",
            "text_back": "#000000",
            "border_width": 2,
        },
    },

    "circular_button": {
        "back": "#ffffff",
        "border": "#a0a0a0",
        "text_back": "#000000",
        "border_width": 1,

        "active": {
            "back": "#dce9fc",
            "border": "#a0a0a0",
            "text_back": "#000000",
            "border_width": 1,
        },

        "pressed": {
            "back": "#dce9fc",
            "border": "#4e6d9c",
            "text_back": "#000000",
            "border_width": 2,
        },
    },

    "frame": {
        "radius": 0,
        "back": "#f0f0f0",
        "border": "#c8c8c8",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 0,
        "padding": (3, 3),

        "back": "#ffffff",
        "border": "#a0a0a0",
        "text_back": "#000000",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#a0a0a0",
            "text_back": "#000000",
            "border_width": 1,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "text": {
        "radius": 0,
        "padding": (3, 3),

        "back": "#ffffff",
        "border": "#a0a0a0",
        "text_back": "#000000",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#a0a0a0",
            "text_back": "#000000",
            "border_width": 1,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#999999",
        "border_width": 1,

        "rounded": True
    },

    "designer_frame": {
        "border": "black",
        "grip": "black"
    },

    "listbox": {
        "back": "#f0f0f0",
        "border": "#c8c8c8",
        "border_width": 1,
        "padding": 0,
        "radius": 0,

        "item_back": "#f0f0f0",
        "item_border": "#f0f0f0",
        "item_text": "#000000",

        "item_radius": 0,
        "item_height": 35,
        "item_padding": 0,

        "active": {
            "item_back": "#dce9fc",
            "item_border": "#dce9fc",
            "item_text": "#000000",
        },
    },
}

basic_dark_theme = {
    "window": {
        "back": "#323232"
    },

    "label": {
        "back": "transparent",
        "text_back": "#ffffff",
    },

    "button": {
        "radius": 0,
        "back": "#232323",
        "border": "#4b4b4b",
        "text_back": "#ffffff",
        "border_width": 1,

        "active": {
            "back": "#373737",
            "border": "#4b4b4b",
            "text_back": "#ffffff",
            "border_width": 1,
        },

        "pressed": {
            "back": "#373737",
            "border": "#4e6d9c",
            "text_back": "#ffffff",
            "border_width": 2,
        },
    },

    "circular_button": {
        "back": "#232323",
        "border": "#4b4b4b",
        "text_back": "#ffffff",
        "border_width": 1,

        "active": {
            "back": "#373737",
            "border": "#4b4b4b",
            "text_back": "#ffffff",
            "border_width": 1,
        },

        "pressed": {
            "back": "#373737",
            "border": "#4e6d9c",
            "text_back": "#ffffff",
            "border_width": 2,
        },
    },

    "frame": {
        "radius": 0,
        "back": "#323232",
        "border": "#464646",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 0,
        "padding": (3, 3),

        "back": "#232323",
        "border": "#4b4b4b",
        "text_back": "#ffffff",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#232323",
            "border": "#4b4b4b",
            "text_back": "#ffffff",
            "border_width": 1,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "text": {
        "radius": 0,
        "padding": (3, 3),

        "back": "#232323",
        "border": "#4b4b4b",
        "text_back": "#ffffff",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#232323",
            "border": "#4b4b4b",
            "text_back": "#ffffff",
            "border_width": 1,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#464646",
        "border_width": 1,

        "rounded": False
    },

    "designer_frame": {
        "border": "white",
        "grip": "white"
    },

    "listbox": {
        "back": "#323232",
        "border": "#464646",
        "border_width": 1,
        "padding": 0,
        "radius": 0,

        "item_back": "#323232",
        "item_border": "#323232",
        "item_text": "#ffffff",

        "item_radius": 0,
        "item_height": 35,
        "item_padding": 0,

        "active": {
            "item_back": "#373737",
            "item_border": "#373737",
            "item_text": "#ffffff",
        },
    },
}

pypi_org_theme = {
    "window": {
        "back": "#ffffff"
    },

    "label": {
        "back": "transparent",
        "text_back": "#000000",
    },

    "button": {
        "radius": 8,
        "back": "#006dad",
        "border": "#006dad",
        "text_back": "#ffffff",
        "border_width": 1,

        "active": {
            "back": "#00507f",
            "border": "#00507f",
            "text_back": "#ffffff",
            "border_width": 1,
        },

        "pressed": {
            "back": "#00507f",
            "border": "#ffffff",
            "text_back": "#ffffff",
            "border_width": 1,
        },
    },

    "circular_button": {
        "back": "#006dad",
        "border": "#006dad",
        "text_back": "#ffffff",
        "border_width": 1,

        "active": {
            "back": "#00507f",
            "border": "#00507f",
            "text_back": "#ffffff",
            "border_width": 1,
        },

        "pressed": {
            "back": "#00507f",
            "border": "#ffffff",
            "text_back": "#ffffff",
            "border_width": 1,
        },
    },

    "frame": {
        "radius": 0,
        "back": "#ececec",
        "border": "#d3d3d3",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 8,
        "padding": (5, 5),

        "back": "#ffffff",
        "border": "#949494",
        "text_back": "#464646",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#006dad",
            "text_back": "#464646",
            "border_width": 3,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "text": {
        "radius": 8,
        "padding": (8, 8),

        "back": "#ffffff",
        "border": "#949494",
        "text_back": "#464646",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#ffffff",
            "border": "#006dad",
            "text_back": "#464646",
            "border_width": 3,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#d3d3d3",
        "border_width": 1,

        "rounded": False
    },

    "designer_frame": {
        "border": "#006dad",
        "grip": "#006dad"
    },

    "listbox": {
        "back": "#ececec",
        "border": "#d3d3d3",
        "border_width": 1,
        "padding": 0,
        "radius": 0,

        "item_back": "#ececec",
        "item_border": "#ececec",
        "item_text": "#000000",

        "item_radius": 0,
        "item_height": 35,
        "item_padding": 0,

        "active": {
            "item_back": "#00507f",
            "item_border": "#00507f",
            "item_text": "#ffffff",
        },
    },
}

pypi_org_dark_theme = {
    "window": {
        "back": "#000002"
    },

    "label": {
        "back": "transparent",
        "text_back": "#ffffff",
    },

    "button": {
        "radius": 8,
        "back": "#00569f",
        "border": "#00569f",
        "text_back": "#ffffff",
        "border_width": 1,

        "active": {
            "back": "#00356c",
            "border": "#00356c",
            "text_back": "#ffffff",
            "border_width": 1,
        },

        "pressed": {
            "back": "#00356c",
            "border": "#000000",
            "text_back": "#ffffff",
            "border_width": 1,
        },
    },

    "circular_button": {
        "back": "#00569f",
        "border": "#00569f",
        "text_back": "#ffffff",
        "border_width": 1,

        "active": {
            "back": "#00356c",
            "border": "#00356c",
            "text_back": "#ffffff",
            "border_width": 1,
        },

        "pressed": {
            "back": "#00356c",
            "border": "#000000",
            "text_back": "#ffffff",
            "border_width": 1,
        },
    },

    "frame": {
        "radius": 0,
        "back": "#0c1012",
        "border": "#30373b",
        "border_width": 1,
        "padding": 0
    },

    "entry": {
        "radius": 8,
        "padding": (5, 5),

        "back": "#000000",
        "border": "#1e2427",
        "text_back": "#d1deca",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#000000",
            "border": "#004d8f",
            "text_back": "#d1deca",
            "border_width": 3,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "text": {
        "radius": 8,
        "padding": (5, 5),

        "back": "#000000",
        "border": "#1e2427",
        "text_back": "#d1deca",
        "border_width": 1,

        "bottom_line": "#ffffff",
        "bottom_width": 0,

        "focusin": {
            "back": "#000000",
            "border": "#004d8f",
            "text_back": "#d1deca",
            "border_width": 3,

            "bottom_line": "#ffffff",
            "bottom_width": 0,
        }
    },

    "separator": {
        "back": "#30373b",
        "border_width": 1,

        "rounded": False
    },

    "designer_frame": {
        "border": "#00569f",
        "grip": "#00569f"
    },

    "listbox": {
        "back": "#0c1012",
        "border": "#30373b",
        "border_width": 1,
        "padding": 0,
        "radius": 0,

        "item_back": "#0c1012",
        "item_border": "#0c1012",
        "item_text": "#ffffff",

        "item_radius": 0,
        "item_height": 35,
        "item_padding": 0,

        "active": {
            "item_back": "#00356c",
            "item_border": "#00356c",
            "item_text": "#000000",
        },
    },
}


def get_default_theme():
    from os import environ
    from json import loads
    try:
        return loads(environ["tkAdwite.DefaultTheme"])
    except KeyError:
        return None


def _set_default_theme(theme):
    from os import environ
    from json import dumps
    environ["tkAdwite.DefaultTheme"] = dumps(theme)


def set_default_theme(theme, mode="system"):
    if theme == "win11" or theme == "windows11" or theme == "Windows11" or theme == "Win11":
        if mode.lower() == "system" or mode.lower() == "auto":
            try:
                from darkdetect import isDark
            except ModuleNotFoundError:
                _set_default_theme(win11_theme)
            else:
                if isDark():
                    _set_default_theme(win11_dark_theme)
                else:
                    _set_default_theme(win11_theme)
        elif mode.lower() == "dark":
            _set_default_theme(win11_dark_theme)
        else:
            _set_default_theme(win11_theme)
    elif theme == "gtk" or theme == "Gtk":
        if mode.lower() == "system" or mode.lower() == "auto":
            try:
                from darkdetect import isDark
            except ModuleNotFoundError:
                _set_default_theme(gtk_theme)
            else:
                if isDark():
                    _set_default_theme(gtk_dark_theme)
                else:
                    _set_default_theme(gtk_theme)

        elif mode.lower() == "dark":
            _set_default_theme(gtk_dark_theme)
        else:
            _set_default_theme(gtk_theme)
    elif theme == "bilibili" or theme == "BiliBili":
        if mode.lower() == "system" or mode.lower() == "auto":
            try:
                from darkdetect import isDark
            except ModuleNotFoundError:
                _set_default_theme(bilibili_theme)
            else:
                if isDark():
                    _set_default_theme(bilibili_dark_theme)
                else:
                    _set_default_theme(bilibili_theme)
        elif mode.lower() == "dark":
            _set_default_theme(bilibili_dark_theme)
        else:
            _set_default_theme(bilibili_theme)
    elif theme == "metro" or theme == "Metro":
        if mode.lower() == "system" or mode.lower() == "auto":
            try:
                from darkdetect import isDark
            except ModuleNotFoundError:
                _set_default_theme(metro_theme)
            else:
                if isDark():
                    _set_default_theme(metro_dark_theme)
                else:
                    _set_default_theme(metro_theme)
        elif mode.lower() == "dark":
            _set_default_theme(metro_dark_theme)
        else:
            _set_default_theme(metro_theme)
    elif theme == "basic" or theme == "Basic":
        if mode.lower() == "system" or mode.lower() == "auto":
            try:
                from darkdetect import isDark
            except ModuleNotFoundError:
                _set_default_theme(basic_theme)
            else:
                if isDark():
                    _set_default_theme(basic_dark_theme)
                else:
                    _set_default_theme(basic_theme)
        elif mode.lower() == "dark":
            _set_default_theme(basic_dark_theme)
        else:
            _set_default_theme(basic_theme)
    elif theme == "pypi" or theme == "Pypi":
        if mode.lower() == "system" or mode.lower() == "auto":
            try:
                from darkdetect import isDark
            except ModuleNotFoundError:
                _set_default_theme(pypi_org_theme)
            else:
                if isDark():
                    _set_default_theme(pypi_org_dark_theme)
                else:
                    _set_default_theme(pypi_org_theme)
        elif mode.lower() == "dark":
            _set_default_theme(pypi_org_dark_theme)
        else:
            _set_default_theme(pypi_org_theme)
    else:
        _set_default_theme(theme)


set_default_theme("win11")

from tkadw.windows.widgets.adw import Adw


class Adwite(Adw):
    def __init__(self, default_theme="win11", *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.set_default_theme(default_theme)

    def get_json(self):
        from json import dumps
        return dumps(
            {
                "root": {
                    "type": type(self).__name__,
                    "title": self.title()
                }
            }
        )

    def set_default_theme(self, theme, _mode="auto"):
        """
        win11、basic、metro、bilibili、gtk
        """
        set_default_theme(theme, _mode)
        for widget in self.winfo_children():
            if hasattr(widget, "palette"):
                widget.palette(get_default_theme())
                widget.update()
        self.palette(get_default_theme())

        from sys import platform
        """
        if platform == "win32":
            from sys import platform
            from ctypes import windll, byref, sizeof, c_int
            from ctypes.wintypes import RGB
            color = self.winfo_rgb(self.cget("bg"))
            windll.dwmapi.DwmSetWindowAttribute(windll.user32.GetParent(self.winfo_id()), 35,
                                                byref(c_int(RGB(color[0], color[1], color[2]))),
                                                sizeof(c_int))
        """

    def use_win_mica(self, caption=None):
        from win32mica import ApplyMica, MicaTheme, MicaStyle
        from ctypes import windll

        ApplyMica(windll.user32.GetParent(root.winfo_id()), MicaTheme.AUTO)

    def default_palette(self):
        self.palette(get_default_theme())


from tkadw.windows.widgets.toplevel import AdwToplevel


class Adwitew(Adwite, AdwToplevel):
    pass


from tkadw.windows.widgets import AdwLabel


class AdwTLabel(AdwLabel):
    def default_palette(self):
        self.palette(get_default_theme())


from tkadw.windows.canvas.button import AdwDrawRoundButton3


class AdwTButton(AdwDrawRoundButton3):
    def default_palette(self):
        self.palette(get_default_theme())

    def win11_accent_dark(self):
        self.palette(
            {
                "button": {
                    "radius": 13,
                    "back": "#57c8ff",
                    "border": "#64cdff",
                    "text_back": "#1c1c1c",
                    "border_width": 1,

                    "active": {
                        "back": "#51b7eb",
                        "border": "#5fbced",
                        "text_back": "#1c1c1c",
                        "border_width": 1,
                    },

                    "pressed": {
                        "back": "#4ba6d5",
                        "border": "#59aed9",
                        "text_back": "#1c1c1c",
                        "border_width": 1,
                    },
                }
            }
        )

    def win11_accent_light(self):
        self.palette(
            {
                "button": {
                    "radius": 13,
                    "back": "#0560b6",
                    "border": "#1a6cba",
                    "text_back": "#ebebeb",
                    "border_width": 1,

                    "active": {
                        "back": "#1e6fbc",
                        "border": "#307bc2",
                        "text_back": "#ebebeb",
                        "border_width": 1,
                    },

                    "pressed": {
                        "back": "#327ec5",
                        "border": "#4288ca",
                        "text_back": "#ebebeb",
                        "border_width": 1,
                    },
                }
            }
        )


from tkadw.windows.canvas.button import AdwDrawCircularButton


class AdwTCircularButton(AdwDrawCircularButton, AdwTButton):
    def default_palette(self):
        self.palette(get_default_theme())


from tkadw.windows.canvas.entry import AdwDrawRoundEntry3


class AdwTEntry(AdwDrawRoundEntry3):
    def default_palette(self):
        self.palette(get_default_theme())


from tkadw.designer.designerframe import AdwDesignerFrame


class AdwTDesignerFrame(AdwDesignerFrame):
    def default_palette(self):
        self.palette(get_default_theme())


from tkadw.windows.canvas.textbox import AdwDrawRoundText3


class AdwTText(AdwDrawRoundText3):
    def default_palette(self):
        self.palette(get_default_theme())


from tkadw.windows.canvas.frame import AdwDrawRoundFrame3


class AdwTFrame(AdwDrawRoundFrame3):
    def default_palette(self):
        self.palette(get_default_theme())


from tkadw.windows.widgets.listbox import AdwRoundListBox3


class AdwTListBox(AdwRoundListBox3):
    def default_palette(self):
        self.palette(get_default_theme())


from tkadw.windows.canvas.separator import AdwDrawSeparator


class AdwTSeparator(AdwDrawSeparator):
    def default_palette(self):
        self.palette(get_default_theme())


class AdwTStack(AdwTFrame):
    def __init__(self, *args, **kwargs):
        """
        用于切换不同的界面
        """
        super().__init__(*args, **kwargs)
        self._pages = {}

    def add_page(self, page: AdwTFrame, id: int = 0):
        """
        添加页面

        :param page: 页面组件
        :param id: 组件ID
        """
        self._pages[id] = page

    def show_page(self, id: int):
        """
        显示页面，会将其他页面隐藏

        :param id: 被显示的页面ID
        """
        self._pages[id].pack(fill="both", expand="yes")
        for item in self._pages.keys():
            if not item == id:
                self.hide_page(item)

    def hide_page(self, id: int):
        """
        内置函数，最好不要使用，因为几乎没有什么用
        """
        self._pages[id].pack_forget()

    def get_page(self, id: int):
        """
        获取页面

        :param id: 所要获取的页面ID
        """
        return self._pages[id]

    def get_pages(self):
        """
        获取所有页面
        """
        return self._pages


from tkadw.windows.widgets.mdi import AdwMDI


class AdwTMDI(AdwMDI):
    def default_palette(self):
        self.palette(get_default_theme())

    def create_child(self, x=10, y=10, width=150, height=150, can_close: bool = True,
                     closebutton=AdwTCircularButton, childframe=AdwTFrame, titlebarframe=AdwTFrame
                     ):
        return super().create_child(
            x=x, y=y, width=width, height=height, can_close=can_close,
            closebutton=closebutton, childframe=childframe, titlebarframe=titlebarframe
        )

    def create_designer_child(self, x=10, y=10, width=150, height=150, can_close: bool = True,
                              closebutton=AdwTCircularButton, childframe=AdwTFrame, titlebarframe=AdwTFrame
                              ):
        return super().create_designer_child(
            x=x, y=y, width=width, height=height, can_close=can_close,
            closebutton=closebutton, childframe=childframe, titlebarframe=titlebarframe
        )


if __name__ == '__main__':
    root = Adwite()
    root.set_default_theme("bilibili", "dark")


    def command():
        widgets_panel.show_page(choose_panel.select())


    choose_panel = AdwTListBox(
        items=sorted(
            ["AdwTButton", "AdwTCircularButton", "AdwTDesignerFrame", "AdwTEntry", "AdwTMDI"]
        ),
        item_selected=command
    )
    choose_panel.column(expand=False)

    widgets_panel = AdwTStack()
    widgets_panel.column()

    button_panel = AdwTFrame(widgets_panel.frame)
    button = AdwTButton(button_panel.frame, text="AdwTButton")
    button.row(expand="no")
    widgets_panel.add_page(button_panel, "AdwTButton")

    cbutton_panel = AdwTFrame(widgets_panel.frame)
    cbutton = AdwTCircularButton(cbutton_panel.frame, text="AdwTCircularButton")
    cbutton.row(expand="no", fill="none")
    widgets_panel.add_page(cbutton_panel, "AdwTCircularButton")

    designerframe_panel = AdwTFrame(widgets_panel.frame)
    designerframe = AdwTDesignerFrame(designerframe_panel.frame, widget=AdwTButton, text="AdwTDesignerFrame")
    designerframe.place(x=5, y=5, width=160, height=60)
    widgets_panel.add_page(designerframe_panel, "AdwTDesignerFrame")

    entry_panel = AdwTFrame(widgets_panel.frame)
    entry = AdwTEntry(entry_panel.frame)
    entry.row(expand="no")
    widgets_panel.add_page(entry_panel, "AdwTEntry")

    mdi_panel = AdwTFrame(widgets_panel.frame)
    mdi = AdwTMDI(mdi_panel.frame)
    mdi_child1 = mdi.create_child()
    mdi.row()
    widgets_panel.add_page(mdi_panel, "AdwTMDI")

    w = Adwitew()
    w.mainloop()

    root.mainloop()
