# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetJavaFamiliesResult',
    'AwaitableGetJavaFamiliesResult',
    'get_java_families',
    'get_java_families_output',
]

@pulumi.output_type
class GetJavaFamiliesResult:
    """
    A collection of values returned by getJavaFamilies.
    """
    def __init__(__self__, display_name=None, family_version=None, filters=None, id=None, is_supported_version=None, java_family_collections=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if family_version and not isinstance(family_version, str):
            raise TypeError("Expected argument 'family_version' to be a str")
        pulumi.set(__self__, "family_version", family_version)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_supported_version and not isinstance(is_supported_version, bool):
            raise TypeError("Expected argument 'is_supported_version' to be a bool")
        pulumi.set(__self__, "is_supported_version", is_supported_version)
        if java_family_collections and not isinstance(java_family_collections, list):
            raise TypeError("Expected argument 'java_family_collections' to be a list")
        pulumi.set(__self__, "java_family_collections", java_family_collections)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the release family.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="familyVersion")
    def family_version(self) -> Optional[str]:
        """
        The Java release family identifier.
        """
        return pulumi.get(self, "family_version")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetJavaFamiliesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSupportedVersion")
    def is_supported_version(self) -> Optional[bool]:
        """
        Whether or not this Java release family is under active support. Refer [Java Support Roadmap](https://www.oracle.com/java/technologies/java-se-support-roadmap.html) for more details.
        """
        return pulumi.get(self, "is_supported_version")

    @property
    @pulumi.getter(name="javaFamilyCollections")
    def java_family_collections(self) -> Sequence['outputs.GetJavaFamiliesJavaFamilyCollectionResult']:
        """
        The list of java_family_collection.
        """
        return pulumi.get(self, "java_family_collections")


class AwaitableGetJavaFamiliesResult(GetJavaFamiliesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJavaFamiliesResult(
            display_name=self.display_name,
            family_version=self.family_version,
            filters=self.filters,
            id=self.id,
            is_supported_version=self.is_supported_version,
            java_family_collections=self.java_family_collections)


def get_java_families(display_name: Optional[str] = None,
                      family_version: Optional[str] = None,
                      filters: Optional[Sequence[Union['GetJavaFamiliesFilterArgs', 'GetJavaFamiliesFilterArgsDict']]] = None,
                      is_supported_version: Optional[bool] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJavaFamiliesResult:
    """
    This data source provides the list of Java Families in Oracle Cloud Infrastructure Jms service.

    Returns a list of the Java release family information.
    A Java release family is typically a major version in the Java version identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_families = oci.Jms.get_java_families(display_name=java_family_display_name,
        family_version=java_family_family_version,
        is_supported_version=java_family_is_supported_version)
    ```


    :param str display_name: The display name for the Java family.
    :param str family_version: The version identifier for the Java family.
    :param bool is_supported_version: Filter the Java Release Family versions by support status.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['familyVersion'] = family_version
    __args__['filters'] = filters
    __args__['isSupportedVersion'] = is_supported_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJavaFamilies:getJavaFamilies', __args__, opts=opts, typ=GetJavaFamiliesResult).value

    return AwaitableGetJavaFamiliesResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        family_version=pulumi.get(__ret__, 'family_version'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_supported_version=pulumi.get(__ret__, 'is_supported_version'),
        java_family_collections=pulumi.get(__ret__, 'java_family_collections'))
def get_java_families_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             family_version: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetJavaFamiliesFilterArgs', 'GetJavaFamiliesFilterArgsDict']]]]] = None,
                             is_supported_version: Optional[pulumi.Input[Optional[bool]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJavaFamiliesResult]:
    """
    This data source provides the list of Java Families in Oracle Cloud Infrastructure Jms service.

    Returns a list of the Java release family information.
    A Java release family is typically a major version in the Java version identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_families = oci.Jms.get_java_families(display_name=java_family_display_name,
        family_version=java_family_family_version,
        is_supported_version=java_family_is_supported_version)
    ```


    :param str display_name: The display name for the Java family.
    :param str family_version: The version identifier for the Java family.
    :param bool is_supported_version: Filter the Java Release Family versions by support status.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['familyVersion'] = family_version
    __args__['filters'] = filters
    __args__['isSupportedVersion'] = is_supported_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getJavaFamilies:getJavaFamilies', __args__, opts=opts, typ=GetJavaFamiliesResult)
    return __ret__.apply(lambda __response__: GetJavaFamiliesResult(
        display_name=pulumi.get(__response__, 'display_name'),
        family_version=pulumi.get(__response__, 'family_version'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_supported_version=pulumi.get(__response__, 'is_supported_version'),
        java_family_collections=pulumi.get(__response__, 'java_family_collections')))
