# SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

REAL_TIME_MATCH_ALLOWED_DIFFERENCE = 0.2

TEST_FILE_MAPPING = {
    "exec_simple": "BFCL_v2_exec_simple.json",
    "exec_parallel": "BFCL_v2_exec_parallel.json",
    "exec_multiple": "BFCL_v2_exec_multiple.json",
    "exec_parallel_multiple": "BFCL_v2_exec_parallel_multiple.json",
    "simple": "BFCL_v2_simple.json",
    "irrelevance": "BFCL_v2_irrelevance.json",
    "parallel": "BFCL_v2_parallel.json",
    "multiple": "BFCL_v2_multiple.json",
    "parallel_multiple": "BFCL_v2_parallel_multiple.json",
    "java": "BFCL_v2_java.json",
    "javascript": "BFCL_v2_javascript.json",
    "rest": "BFCL_v2_rest.json",
    "sql": "BFCL_v2_sql.json",
    "chatable": "BFCL_v2_chatable.json",
    # Live Datasets
    "live_simple": "BFCL_v2_live_simple.json",
    "live_multiple": "BFCL_v2_live_multiple.json",
    "live_parallel": "BFCL_v2_live_parallel.json",
    "live_parallel_multiple": "BFCL_v2_live_parallel_multiple.json",
    "live_irrelevance": "BFCL_v2_live_irrelevance.json",
    "live_relevance": "BFCL_v2_live_relevance.json",
}

TEST_COLLECTION_MAPPING = {
    "all": [
        "exec_simple",
        "exec_parallel",
        "exec_multiple",
        "exec_parallel_multiple",
        "simple",
        "irrelevance",
        "parallel",
        "multiple",
        "parallel_multiple",
        "java",
        "javascript",
        "rest",
        "live_simple",
        "live_multiple",
        "live_parallel",
        "live_parallel_multiple",
        "live_irrelevance",
        "live_relevance",
    ],
    "live": [
        "live_simple",
        "live_multiple",
        "live_parallel",
        "live_parallel_multiple",
        "live_irrelevance",
        "live_relevance",
    ],
    "non_live": [
        "exec_simple",
        "exec_parallel",
        "exec_multiple",
        "exec_parallel_multiple",
        "simple",
        "irrelevance",
        "parallel",
        "multiple",
        "parallel_multiple",
        "java",
        "javascript",
        "rest",
    ],
    "ast": [
        "simple",
        "irrelevance",
        "parallel",
        "multiple",
        "parallel_multiple",
        "java",
        "javascript",
        "live_simple",
        "live_multiple",
        "live_parallel",
        "live_parallel_multiple",
        "live_irrelevance",
        "live_relevance",
    ],
    "executable": [
        "exec_simple",
        "exec_parallel",
        "exec_multiple",
        "exec_parallel_multiple",
        "rest",
    ],
    "non_python": [
        "java",
        "javascript",
    ],
    "python": [
        "exec_simple",
        "exec_parallel",
        "exec_multiple",
        "exec_parallel_multiple",
        "simple",
        "irrelevance",
        "parallel",
        "multiple",
        "parallel_multiple",
        "rest",
        "live_simple",
        "live_multiple",
        "live_parallel",
        "live_parallel_multiple",
        "live_irrelevance",
        "live_relevance",
    ],
    "python_ast": [
        "simple",
        "irrelevance",
        "parallel",
        "multiple",
        "parallel_multiple",
        "live_simple",
        "live_multiple",
        "live_parallel",
        "live_parallel_multiple",
        "live_irrelevance",
        "live_relevance",
    ],
}
