# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterPlacementGroupCapabilities',
    'ClusterPlacementGroupCapabilitiesItem',
    'ClusterPlacementGroupPlacementInstruction',
    'GetClusterPlacementGroupCapabilityResult',
    'GetClusterPlacementGroupCapabilityItemResult',
    'GetClusterPlacementGroupPlacementInstructionResult',
    'GetClusterPlacementGroupsClusterPlacementGroupCollectionResult',
    'GetClusterPlacementGroupsClusterPlacementGroupCollectionItemResult',
    'GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityResult',
    'GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityItemResult',
    'GetClusterPlacementGroupsClusterPlacementGroupCollectionItemPlacementInstructionResult',
    'GetClusterPlacementGroupsFilterResult',
]

@pulumi.output_type
class ClusterPlacementGroupCapabilities(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.ClusterPlacementGroupCapabilitiesItem']):
        """
        :param Sequence['ClusterPlacementGroupCapabilitiesItemArgs'] items: The supported resources.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ClusterPlacementGroupCapabilitiesItem']:
        """
        The supported resources.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ClusterPlacementGroupCapabilitiesItem(dict):
    def __init__(__self__, *,
                 name: str,
                 service: str):
        """
        :param str name: The friendly name of the cluster placement group.
        :param str service: The service that the resource is part of.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The friendly name of the cluster placement group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The service that the resource is part of.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ClusterPlacementGroupPlacementInstruction(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of placement instruction.
        :param str value: The value of the token designated for placement of the cluster placement group upon creation.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of placement instruction.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the token designated for placement of the cluster placement group upon creation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetClusterPlacementGroupCapabilityResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetClusterPlacementGroupCapabilityItemResult']):
        """
        :param Sequence['GetClusterPlacementGroupCapabilityItemArgs'] items: The supported resources.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetClusterPlacementGroupCapabilityItemResult']:
        """
        The supported resources.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetClusterPlacementGroupCapabilityItemResult(dict):
    def __init__(__self__, *,
                 name: str,
                 service: str):
        """
        :param str name: The user-friendly name of the cluster placement group. The display name for a cluster placement must be unique and you cannot change it. Avoid entering confidential information.
        :param str service: The service that the resource is part of.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The user-friendly name of the cluster placement group. The display name for a cluster placement must be unique and you cannot change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The service that the resource is part of.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetClusterPlacementGroupPlacementInstructionResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of placement instruction.
        :param str value: The value of the token designated for placement of the cluster placement group upon creation.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of placement instruction.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the token designated for placement of the cluster placement group upon creation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetClusterPlacementGroupsClusterPlacementGroupCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionItemResult']):
        """
        :param Sequence['GetClusterPlacementGroupsClusterPlacementGroupCollectionItemArgs'] items: The supported resources.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionItemResult']:
        """
        The supported resources.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetClusterPlacementGroupsClusterPlacementGroupCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 capabilities: Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityResult'],
                 cluster_placement_group_type: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 name: str,
                 opc_dry_run: bool,
                 placement_instructions: Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionItemPlacementInstructionResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str availability_domain: The availability domain of the cluster placement group.
        :param Sequence['GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityArgs'] capabilities: A list of resources that you can create in a cluster placement group.
        :param str cluster_placement_group_type: The type of cluster placement group.
        :param str compartment_id: A filter to return only the resources that match the specified compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: A description of the cluster placement group.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: A filter to return only the resources that match the specified unique cluster placement group identifier.
        :param str lifecycle_details: A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.
        :param str name: A filter to return only the resources that match the entire display name specified.
        :param Sequence['GetClusterPlacementGroupsClusterPlacementGroupCollectionItemPlacementInstructionArgs'] placement_instructions: Details that inform cluster placement group provisioning.
        :param str state: A filter to return only the resources that match the specified lifecycle state.
        :param Mapping[str, Any] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the cluster placement group was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param str time_updated: The time the cluster placement group was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "cluster_placement_group_type", cluster_placement_group_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        pulumi.set(__self__, "placement_instructions", placement_instructions)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain of the cluster placement group.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityResult']:
        """
        A list of resources that you can create in a cluster placement group.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="clusterPlacementGroupType")
    def cluster_placement_group_type(self) -> str:
        """
        The type of cluster placement group.
        """
        return pulumi.get(self, "cluster_placement_group_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        A filter to return only the resources that match the specified compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the cluster placement group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only the resources that match the specified unique cluster placement group identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only the resources that match the entire display name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> bool:
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter(name="placementInstructions")
    def placement_instructions(self) -> Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionItemPlacementInstructionResult']:
        """
        Details that inform cluster placement group provisioning.
        """
        return pulumi.get(self, "placement_instructions")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the resources that match the specified lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the cluster placement group was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the cluster placement group was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityItemResult']):
        """
        :param Sequence['GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityItemArgs'] items: The supported resources.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityItemResult']:
        """
        The supported resources.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetClusterPlacementGroupsClusterPlacementGroupCollectionItemCapabilityItemResult(dict):
    def __init__(__self__, *,
                 name: str,
                 service: str):
        """
        :param str name: A filter to return only the resources that match the entire display name specified.
        :param str service: The service that the resource is part of.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only the resources that match the entire display name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The service that the resource is part of.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetClusterPlacementGroupsClusterPlacementGroupCollectionItemPlacementInstructionResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of placement instruction.
        :param str value: The value of the token designated for placement of the cluster placement group upon creation.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of placement instruction.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the token designated for placement of the cluster placement group upon creation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetClusterPlacementGroupsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only the resources that match the entire display name specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only the resources that match the entire display name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


