# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstanceAvailablePluginResult',
    'AwaitableGetInstanceAvailablePluginResult',
    'get_instance_available_plugin',
    'get_instance_available_plugin_output',
]

@pulumi.output_type
class GetInstanceAvailablePluginResult:
    """
    A collection of values returned by getInstanceAvailablePlugin.
    """
    def __init__(__self__, available_plugins=None, compartment_id=None, filters=None, id=None, name=None, os_name=None, os_version=None):
        if available_plugins and not isinstance(available_plugins, list):
            raise TypeError("Expected argument 'available_plugins' to be a list")
        pulumi.set(__self__, "available_plugins", available_plugins)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_name and not isinstance(os_name, str):
            raise TypeError("Expected argument 'os_name' to be a str")
        pulumi.set(__self__, "os_name", os_name)
        if os_version and not isinstance(os_version, str):
            raise TypeError("Expected argument 'os_version' to be a str")
        pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="availablePlugins")
    def available_plugins(self) -> Sequence['outputs.GetInstanceAvailablePluginAvailablePluginResult']:
        """
        The list of available_plugins.
        """
        return pulumi.get(self, "available_plugins")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstanceAvailablePluginFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The plugin name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        return pulumi.get(self, "os_version")


class AwaitableGetInstanceAvailablePluginResult(GetInstanceAvailablePluginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceAvailablePluginResult(
            available_plugins=self.available_plugins,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            os_name=self.os_name,
            os_version=self.os_version)


def get_instance_available_plugin(compartment_id: Optional[str] = None,
                                  filters: Optional[Sequence[pulumi.InputType['GetInstanceAvailablePluginFilterArgs']]] = None,
                                  name: Optional[str] = None,
                                  os_name: Optional[str] = None,
                                  os_version: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceAvailablePluginResult:
    """
    This data source provides the list of Instance Available Plugins in Oracle Cloud Infrastructure Compute Instance Agent service.

    The API to get the list of plugins that are available.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_available_plugins = oci.ComputeInstanceAgent.get_instance_available_plugin(os_name=instance_available_plugin_os_name,
        os_version=instance_available_plugin_os_version,
        name=instance_available_plugin_name)
    ```


    :param str name: The plugin name
    :param str os_name: The OS for which the plugin is supported. Examples of OperatingSystemQueryParam:OperatingSystemVersionQueryParam are as follows: 'CentOS' '6.10' , 'CentOS Linux' '7', 'CentOS Linux' '8', 'Oracle Linux Server' '6.10', 'Oracle Linux Server' '8.0', 'Red Hat Enterprise Linux Server' '7.8', 'Windows' '10', 'Windows' '2008ServerR2', 'Windows' '2012ServerR2', 'Windows' '7', 'Windows' '8.1'
    :param str os_version: The OS version for which the plugin is supported.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['osName'] = os_name
    __args__['osVersion'] = os_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ComputeInstanceAgent/getInstanceAvailablePlugin:getInstanceAvailablePlugin', __args__, opts=opts, typ=GetInstanceAvailablePluginResult).value

    return AwaitableGetInstanceAvailablePluginResult(
        available_plugins=pulumi.get(__ret__, 'available_plugins'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        os_name=pulumi.get(__ret__, 'os_name'),
        os_version=pulumi.get(__ret__, 'os_version'))


@_utilities.lift_output_func(get_instance_available_plugin)
def get_instance_available_plugin_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetInstanceAvailablePluginFilterArgs']]]]] = None,
                                         name: Optional[pulumi.Input[Optional[str]]] = None,
                                         os_name: Optional[pulumi.Input[str]] = None,
                                         os_version: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceAvailablePluginResult]:
    """
    This data source provides the list of Instance Available Plugins in Oracle Cloud Infrastructure Compute Instance Agent service.

    The API to get the list of plugins that are available.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_available_plugins = oci.ComputeInstanceAgent.get_instance_available_plugin(os_name=instance_available_plugin_os_name,
        os_version=instance_available_plugin_os_version,
        name=instance_available_plugin_name)
    ```


    :param str name: The plugin name
    :param str os_name: The OS for which the plugin is supported. Examples of OperatingSystemQueryParam:OperatingSystemVersionQueryParam are as follows: 'CentOS' '6.10' , 'CentOS Linux' '7', 'CentOS Linux' '8', 'Oracle Linux Server' '6.10', 'Oracle Linux Server' '8.0', 'Red Hat Enterprise Linux Server' '7.8', 'Windows' '10', 'Windows' '2008ServerR2', 'Windows' '2012ServerR2', 'Windows' '7', 'Windows' '8.1'
    :param str os_version: The OS version for which the plugin is supported.
    """
    ...
