# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAddonOptionsResult',
    'AwaitableGetAddonOptionsResult',
    'get_addon_options',
    'get_addon_options_output',
]

@pulumi.output_type
class GetAddonOptionsResult:
    """
    A collection of values returned by getAddonOptions.
    """
    def __init__(__self__, addon_name=None, addon_options=None, filters=None, id=None, kubernetes_version=None):
        if addon_name and not isinstance(addon_name, str):
            raise TypeError("Expected argument 'addon_name' to be a str")
        pulumi.set(__self__, "addon_name", addon_name)
        if addon_options and not isinstance(addon_options, list):
            raise TypeError("Expected argument 'addon_options' to be a list")
        pulumi.set(__self__, "addon_options", addon_options)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> Optional[str]:
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="addonOptions")
    def addon_options(self) -> Sequence['outputs.GetAddonOptionsAddonOptionResult']:
        """
        The list of addon_options.
        """
        return pulumi.get(self, "addon_options")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAddonOptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> str:
        return pulumi.get(self, "kubernetes_version")


class AwaitableGetAddonOptionsResult(GetAddonOptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddonOptionsResult(
            addon_name=self.addon_name,
            addon_options=self.addon_options,
            filters=self.filters,
            id=self.id,
            kubernetes_version=self.kubernetes_version)


def get_addon_options(addon_name: Optional[str] = None,
                      filters: Optional[Sequence[pulumi.InputType['GetAddonOptionsFilterArgs']]] = None,
                      kubernetes_version: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddonOptionsResult:
    """
    This data source provides the list of Addon Options in Oracle Cloud Infrastructure Container Engine service.

    Get list of supported addons for a specific kubernetes version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_addon_options = oci.ContainerEngine.get_addon_options(kubernetes_version=addon_option_kubernetes_version,
        addon_name=test_addon["name"])
    ```


    :param str addon_name: The name of the addon.
    :param str kubernetes_version: The kubernetes version to fetch the addons.
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['filters'] = filters
    __args__['kubernetesVersion'] = kubernetes_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getAddonOptions:getAddonOptions', __args__, opts=opts, typ=GetAddonOptionsResult).value

    return AwaitableGetAddonOptionsResult(
        addon_name=pulumi.get(__ret__, 'addon_name'),
        addon_options=pulumi.get(__ret__, 'addon_options'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'))


@_utilities.lift_output_func(get_addon_options)
def get_addon_options_output(addon_name: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAddonOptionsFilterArgs']]]]] = None,
                             kubernetes_version: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAddonOptionsResult]:
    """
    This data source provides the list of Addon Options in Oracle Cloud Infrastructure Container Engine service.

    Get list of supported addons for a specific kubernetes version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_addon_options = oci.ContainerEngine.get_addon_options(kubernetes_version=addon_option_kubernetes_version,
        addon_name=test_addon["name"])
    ```


    :param str addon_name: The name of the addon.
    :param str kubernetes_version: The kubernetes version to fetch the addons.
    """
    ...
