# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalDbSystemDiscoveryResult',
    'AwaitableGetExternalDbSystemDiscoveryResult',
    'get_external_db_system_discovery',
    'get_external_db_system_discovery_output',
]

@pulumi.output_type
class GetExternalDbSystemDiscoveryResult:
    """
    A collection of values returned by getExternalDbSystemDiscovery.
    """
    def __init__(__self__, agent_id=None, compartment_id=None, defined_tags=None, discovered_components=None, display_name=None, external_db_system_discovery_id=None, freeform_tags=None, grid_home=None, id=None, lifecycle_details=None, patch_operations=None, resource_id=None, state=None, time_created=None, time_updated=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if discovered_components and not isinstance(discovered_components, list):
            raise TypeError("Expected argument 'discovered_components' to be a list")
        pulumi.set(__self__, "discovered_components", discovered_components)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_db_system_discovery_id and not isinstance(external_db_system_discovery_id, str):
            raise TypeError("Expected argument 'external_db_system_discovery_id' to be a str")
        pulumi.set(__self__, "external_db_system_discovery_id", external_db_system_discovery_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if grid_home and not isinstance(grid_home, str):
            raise TypeError("Expected argument 'grid_home' to be a str")
        pulumi.set(__self__, "grid_home", grid_home)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if patch_operations and not isinstance(patch_operations, list):
            raise TypeError("Expected argument 'patch_operations' to be a list")
        pulumi.set(__self__, "patch_operations", patch_operations)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management agent used for the external DB system connector.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveredComponents")
    def discovered_components(self) -> Sequence['outputs.GetExternalDbSystemDiscoveryDiscoveredComponentResult']:
        """
        The list of DB system components that were found in the DB system discovery.
        """
        return pulumi.get(self, "discovered_components")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalDbSystemDiscoveryId")
    def external_db_system_discovery_id(self) -> str:
        return pulumi.get(self, "external_db_system_discovery_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gridHome")
    def grid_home(self) -> str:
        """
        The directory in which Oracle Grid Infrastructure is installed.
        """
        return pulumi.get(self, "grid_home")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system discovery.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Sequence['outputs.GetExternalDbSystemDiscoveryPatchOperationResult']:
        return pulumi.get(self, "patch_operations")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the existing Oracle Cloud Infrastructure resource matching the discovered DB system.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the external DB system discovery resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the external DB system discovery was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the external DB system discovery was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetExternalDbSystemDiscoveryResult(GetExternalDbSystemDiscoveryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalDbSystemDiscoveryResult(
            agent_id=self.agent_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            discovered_components=self.discovered_components,
            display_name=self.display_name,
            external_db_system_discovery_id=self.external_db_system_discovery_id,
            freeform_tags=self.freeform_tags,
            grid_home=self.grid_home,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            patch_operations=self.patch_operations,
            resource_id=self.resource_id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_external_db_system_discovery(external_db_system_discovery_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalDbSystemDiscoveryResult:
    """
    This data source provides details about a specific External Db System Discovery resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external DB system discovery resource specified by `externalDbSystemDiscoveryId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_system_discovery = oci.DatabaseManagement.get_external_db_system_discovery(external_db_system_discovery_id=test_external_db_system_discovery_oci_database_management_external_db_system_discovery["id"])
    ```


    :param str external_db_system_discovery_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system discovery.
    """
    __args__ = dict()
    __args__['externalDbSystemDiscoveryId'] = external_db_system_discovery_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalDbSystemDiscovery:getExternalDbSystemDiscovery', __args__, opts=opts, typ=GetExternalDbSystemDiscoveryResult).value

    return AwaitableGetExternalDbSystemDiscoveryResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        discovered_components=pulumi.get(__ret__, 'discovered_components'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_db_system_discovery_id=pulumi.get(__ret__, 'external_db_system_discovery_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        grid_home=pulumi.get(__ret__, 'grid_home'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        patch_operations=pulumi.get(__ret__, 'patch_operations'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_external_db_system_discovery)
def get_external_db_system_discovery_output(external_db_system_discovery_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalDbSystemDiscoveryResult]:
    """
    This data source provides details about a specific External Db System Discovery resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external DB system discovery resource specified by `externalDbSystemDiscoveryId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_system_discovery = oci.DatabaseManagement.get_external_db_system_discovery(external_db_system_discovery_id=test_external_db_system_discovery_oci_database_management_external_db_system_discovery["id"])
    ```


    :param str external_db_system_discovery_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system discovery.
    """
    ...
