# coding: utf-8# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
# File content is auto-generated. Do not modify.
# pylint: skip-file
from ._internal import SymbolBase
from ..base import _Null

def _CachedOp(*data, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol[]
        input data list

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _CachedOpThreadSafe(*data, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol[]
        input data list

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _CrossDeviceCopy(name=None, attr=None, out=None, **kwargs):
    r"""Special op to copy data cross device

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _CustomFunction(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Div(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Divides arguments element-wise.

    The storage type of ``elemwise_div`` output is always dense



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _DivScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Divide an array with a scalar.

    ``_div_scalar`` only operates on data array of input if input is sparse.

    For example, if input of shape (100, 100) has only 2 non zero elements,
    i.e. input.data = [5, 6], scalar = nan,
    it will result output.data = [nan, nan] instead of 10000 nans.



    Defined in ../src/operator/tensor/elemwise_binary_scalar_op_basic.cc:L174

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Equal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _EqualScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Greater(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _GreaterEqualScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _GreaterScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Greater_Equal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Hypot(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Given the "legs" of a right triangle, return its hypotenuse.



    Defined in ../src/operator/tensor/elemwise_binary_op_extended.cc:L79

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _HypotScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Lesser(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _LesserEqualScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _LesserScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Lesser_Equal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _LogicalAndScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _LogicalOrScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _LogicalXorScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Logical_And(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Logical_Or(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Logical_Xor(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Maximum(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _MaximumScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Minimum(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _MinimumScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Minus(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Subtracts arguments element-wise.

    The storage type of ``elemwise_sub`` output depends on storage types of inputs

       - elemwise_sub(row_sparse, row_sparse) = row_sparse
       - elemwise_sub(csr, csr) = csr
       - elemwise_sub(default, csr) = default
       - elemwise_sub(csr, default) = default
       - elemwise_sub(default, rsp) = default
       - elemwise_sub(rsp, default) = default
       - otherwise, ``elemwise_sub`` generates output with default storage



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _MinusScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Mod(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _ModScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Mul(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Multiplies arguments element-wise.

    The storage type of ``elemwise_mul`` output depends on storage types of inputs

       - elemwise_mul(default, default) = default
       - elemwise_mul(row_sparse, row_sparse) = row_sparse
       - elemwise_mul(default, row_sparse) = row_sparse
       - elemwise_mul(row_sparse, default) = row_sparse
       - elemwise_mul(csr, csr) = csr
       - otherwise, ``elemwise_mul`` generates output with default storage



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _MulScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Multiply an array with a scalar.

    ``_mul_scalar`` only operates on data array of input if input is sparse.

    For example, if input of shape (100, 100) has only 2 non zero elements,
    i.e. input.data = [5, 6], scalar = nan,
    it will result output.data = [nan, nan] instead of 10000 nans.



    Defined in ../src/operator/tensor/elemwise_binary_scalar_op_basic.cc:L152

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _NDArray(*data, **kwargs):
    r"""Stub for implementing an operator implemented in native frontend language with ndarray.

    Parameters
    ----------
    data : Symbol[]
        Input data for the custom operator.
    info : ptr, required

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Native(*data, **kwargs):
    r"""Stub for implementing an operator implemented in native frontend language.

    Parameters
    ----------
    data : Symbol[]
        Input data for the custom operator.
    info : ptr, required
    need_top_grad : boolean, optional, default=1
        Whether this layer needs out grad for backward. Should be false for loss layers.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _NoGradient(name=None, attr=None, out=None, **kwargs):
    r"""Place holder for variable who cannot perform gradient

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _NotEqualScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Not_Equal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Plus(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Adds arguments element-wise.

    The storage type of ``elemwise_add`` output depends on storage types of inputs

       - elemwise_add(row_sparse, row_sparse) = row_sparse
       - elemwise_add(csr, csr) = csr
       - elemwise_add(default, csr) = default
       - elemwise_add(csr, default) = default
       - elemwise_add(default, rsp) = default
       - elemwise_add(rsp, default) = default
       - otherwise, ``elemwise_add`` generates output with default storage



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _PlusScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _Power(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _PowerScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _RDivScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _RMinusScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _RModScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _RPowerScalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _adabelief_update(weight=None, grad=None, mean=None, var=None, rescale_grad=None, lr=_Null, beta1=_Null, beta2=_Null, epsilon=_Null, wd=_Null, eta=_Null, clip_gradient=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Update function for AdaBelief optimizer.

    AdaBelief is seen as a modification of Adam with a different variance 
    estimator.

    Adam update consists of the following steps, where g represents gradient and m, s
    are 1st and 2nd order moment estimates (mean and variance).

    .. math::

     g_t = \nabla J(W_{t-1}) + w * wd \\
     m_t = \beta_1 m_{t-1} + (1 - \beta_1) g_t\\
     s_t = \beta_2 v_{t-1} + (1 - \beta_2) (g_t - m_t)^2 + \epsilon\\
     W_t = W_{t-1} - \eta_t (\alpha \frac{ m_t }{ \sqrt{ v_t } + \epsilon })

    It updates the weights using::

     m = beta1*m + (1-beta1)*grad
     s = beta2*v + (1-beta2)*(grad**2)
     w -= eta * (learning_rate * m / (sqrt(s) + epsilon))

    Note that gradient is rescaled to grad = rescale_grad * grad. If rescale_grad is NaN, Inf, or 0,
    the update is skipped.
    )

    Defined in ../src/operator/contrib/adabelief.cc:L104

    Parameters
    ----------
    weight : Symbol
        Weight
    grad : Symbol
        Gradient
    mean : Symbol
        Moving mean
    var : Symbol
        Moving variance
    rescale_grad : Symbol
        Rescale gradient to rescale_grad * grad. If NaN, Inf, or 0, the update is skipped.
    lr : float, required
        Learning rate
    beta1 : float, optional, default=0.899999976
        The decay rate for the 1st moment estimates.
    beta2 : float, optional, default=0.999000013
        The decay rate for the 2nd moment estimates.
    epsilon : float, optional, default=9.99999994e-09
        A small constant for numerical stability.
    wd : float, optional, default=0
        Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    eta : float, required
        Learning rate schedule multiplier
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _adamw_update(weight=None, grad=None, mean=None, var=None, rescale_grad=None, lr=_Null, beta1=_Null, beta2=_Null, epsilon=_Null, wd=_Null, eta=_Null, clip_gradient=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Update function for AdamW optimizer. AdamW is seen as a modification of
    Adam by decoupling the weight decay from the optimization steps taken w.r.t. the loss function.

    Adam update consists of the following steps, where g represents gradient and m, v
    are 1st and 2nd order moment estimates (mean and variance).

    .. math::

     g_t = \nabla J(W_{t-1})\\
     m_t = \beta_1 m_{t-1} + (1 - \beta_1) g_t\\
     v_t = \beta_2 v_{t-1} + (1 - \beta_2) g_t^2\\
     W_t = W_{t-1} - \eta_t (\alpha \frac{ m_t }{ \sqrt{ v_t } + \epsilon } + wd W_{t-1})

    It updates the weights using::

     m = beta1*m + (1-beta1)*grad
     v = beta2*v + (1-beta2)*(grad**2)
     w -= eta * (learning_rate * m / (sqrt(v) + epsilon) + w * wd)

    Note that gradient is rescaled to grad = rescale_grad * grad. If rescale_grad is NaN, Inf, or 0,
    the update is skipped.


    Defined in ../src/operator/contrib/adamw.cc:L102

    Parameters
    ----------
    weight : Symbol
        Weight
    grad : Symbol
        Gradient
    mean : Symbol
        Moving mean
    var : Symbol
        Moving variance
    rescale_grad : Symbol
        Rescale gradient to rescale_grad * grad. If NaN, Inf, or 0, the update is skipped.
    lr : float, required
        Learning rate
    beta1 : float, optional, default=0.899999976
        The decay rate for the 1st moment estimates.
    beta2 : float, optional, default=0.999000013
        The decay rate for the 2nd moment estimates.
    epsilon : float, optional, default=9.99999994e-09
        A small constant for numerical stability.
    wd : float, optional, default=0
        Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    eta : float, required
        Learning rate schedule multiplier
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _add(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Adds arguments element-wise.

    The storage type of ``elemwise_add`` output depends on storage types of inputs

       - elemwise_add(row_sparse, row_sparse) = row_sparse
       - elemwise_add(csr, csr) = csr
       - elemwise_add(default, csr) = default
       - elemwise_add(csr, default) = default
       - elemwise_add(default, rsp) = default
       - elemwise_add(rsp, default) = default
       - otherwise, ``elemwise_add`` generates output with default storage



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _arange(start=_Null, stop=_Null, step=_Null, repeat=_Null, infer_range=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Return evenly spaced values within a given interval. Similar to Numpy

    Parameters
    ----------
    start : double, required
        Start of interval. The interval includes this value. The default start value is 0.
    stop : double or None, optional, default=None
        End of interval. The interval does not include this value, except in some cases where step is not an integer and floating point round-off affects the length of out.
    step : double, optional, default=1
        Spacing between values.
    repeat : int, optional, default='1'
        The repeating time of all elements. E.g repeat=3, the element a will be repeated three times --> a, a, a.
    infer_range : boolean, optional, default=0
        When set to True, infer the stop position from the start, step, repeat, and output tensor size.
    ctx : string, optional, default=''
        Context of output, in format [cpu|gpu|cpu_pinned](n).Only used for imperative calls.
    dtype : {'None', 'bfloat16', 'float16', 'float32', 'float64', 'int32', 'int64', 'int8', 'uint8'},optional, default='None'
        Target data type.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Activation(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_BatchNorm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_BilinearSampler(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_CachedOp(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Concat(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Convolution(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Correlation(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Crop(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Custom(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_CustomFunction(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Deconvolution(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Dropout(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Embedding(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_FullyConnected(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_GridGenerator(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_GroupNorm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_IdentityAttachKLSparseReg(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_L2Normalization(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_LRN(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_LayerNorm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_LeakyReLU(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_MakeLoss(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Pad(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_Pooling(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_RNN(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_ROIAlign(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_ROIPooling(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_RROIAlign(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SVMOutput(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SequenceLast(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SequenceMask(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SequenceReverse(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SliceChannel(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SoftmaxActivation(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SoftmaxOutput(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SpatialTransformer(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_SwapAxis(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_UpSampling(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__CrossDeviceCopy(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__NDArray(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__Native(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_DeformablePSROIPooling(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_MultiBoxDetection(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_MultiBoxPrior(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_MultiBoxTarget(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_MultiProposal(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_PSROIPooling(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_Proposal(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_SyncBatchNorm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_count_sketch(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__contrib_fft(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__npx_deformable_convolution(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward__npx_modulated_deformable_convolution(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_abs(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_add(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_amp_cast(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_amp_multicast(*grad, **kwargs):
    r"""

    Parameters
    ----------
    grad : Symbol[]
        Gradients
    num_outputs : int, required
        Number of input/output pairs to be casted to the widest type.
    cast_narrow : boolean, optional, default=0
        Whether to cast to the narrowest type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_arccos(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_arccosh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_arcsin(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_arcsinh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_arctan(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_arctanh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_backward_FullyConnected(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_add(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_div(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_exponential(scale=_Null, size=_Null, ctx=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    scale : float or None, optional, default=1
    size : , optional, default=None
        Output shape. If the given shape is, e.g., (m, n, k), then m * n * k samples are drawn. Default is None, in which case a single value is returned.
    ctx : string, optional, default='cpu'
        Context of output, in format [cpu|gpu|cpu_pinned](n). Only used for imperative calls.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_gumbel(loc=_Null, scale=_Null, size=_Null, ctx=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    loc : float or None, required
    scale : float or None, required
    size : , optional, default=None
        Output shape. If the given shape is, e.g., (m, n, k), then m * n * k samples are drawn. Default is None, in which case a single value is returned.
    ctx : string, optional, default='cpu'
        Context of output, in format [cpu|gpu|cpu_pinned](n). Only used for imperative calls.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_hypot(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_logistic(loc=_Null, scale=_Null, size=_Null, ctx=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    loc : float or None, required
    scale : float or None, required
    size : , optional, default=None
        Output shape. If the given shape is, e.g., (m, n, k), then m * n * k samples are drawn. Default is None, in which case a single value is returned.
    ctx : string, optional, default='cpu'
        Context of output, in format [cpu|gpu|cpu_pinned](n). Only used for imperative calls.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_maximum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_minimum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_mod(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_mul(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_normal(loc=_Null, scale=_Null, size=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    loc : float or None, required
    scale : float or None, required
    size : , optional, default=None
        Output shape. If the given shape is, e.g., (m, n, k), then m * n * k samples are drawn. Default is None, in which case a single value is returned.
    ctx : string, optional, default='cpu'
        Context of output, in format [cpu|gpu|cpu_pinned](n). Only used for imperative calls.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 or float64 if not defined (dtype=None).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_pareto(a=_Null, size=_Null, ctx=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    a : float or None, optional, default=None
    size : , optional, default=None
        Output shape. If the given shape is, e.g., (m, n, k), then m * n * k samples are drawn. Default is None, in which case a single value is returned.
    ctx : string, optional, default='cpu'
        Context of output, in format [cpu|gpu|cpu_pinned](n). Only used for imperative calls.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_power(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_rayleigh(scale=_Null, size=_Null, ctx=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    scale : float or None, optional, default=1
    size : , optional, default=None
        Output shape. If the given shape is, e.g., (m, n, k), then m * n * k samples are drawn. Default is None, in which case a single value is returned.
    ctx : string, optional, default='cpu'
        Context of output, in format [cpu|gpu|cpu_pinned](n). Only used for imperative calls.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_sub(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_broadcast_weibull(a=_Null, size=_Null, ctx=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    a : float or None, optional, default=None
    size : , optional, default=None
        Output shape. If the given shape is, e.g., (m, n, k), then m * n * k samples are drawn. Default is None, in which case a single value is returned.
    ctx : string, optional, default='cpu'
        Context of output, in format [cpu|gpu|cpu_pinned](n). Only used for imperative calls.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_cast(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_cbrt(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_clip(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_col2im(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_cond(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_contrib_AdaptiveAvgPooling2D(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_contrib_BatchNormWithReLU(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_contrib_BilinearResize2D(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_contrib_bipartite_matching(is_ascend=_Null, threshold=_Null, topk=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    is_ascend : boolean, optional, default=0
        Use ascend order for scores instead of descending. Please set threshold accordingly.
    threshold : float, required
        Ignore matching when score < thresh, if is_ascend=false, or ignore score > thresh, if is_ascend=true.
    topk : int, optional, default='-1'
        Limit the number of matches to topk, set -1 for no limit

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_contrib_boolean_mask(axis=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    axis : int, optional, default='0'
        An integer that represents the axis in NDArray to mask from.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_contrib_box_iou(format=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    format : {'center', 'corner'},optional, default='corner'
        The box encoding type. 
     "corner" means boxes are encoded as [xmin, ymin, xmax, ymax], "center" means boxes are encodes as [x, y, width, height].

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_contrib_box_nms(overlap_thresh=_Null, valid_thresh=_Null, topk=_Null, coord_start=_Null, score_index=_Null, id_index=_Null, background_id=_Null, force_suppress=_Null, in_format=_Null, out_format=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    overlap_thresh : float, optional, default=0.5
        Overlapping(IoU) threshold to suppress object with smaller score.
    valid_thresh : float, optional, default=0
        Filter input boxes to those whose scores greater than valid_thresh.
    topk : int, optional, default='-1'
        Apply nms to topk boxes with descending scores, -1 to no restriction.
    coord_start : int, optional, default='2'
        Start index of the consecutive 4 coordinates.
    score_index : int, optional, default='1'
        Index of the scores/confidence of boxes.
    id_index : int, optional, default='-1'
        Optional, index of the class categories, -1 to disable.
    background_id : int, optional, default='-1'
        Optional, id of the background class which will be ignored in nms.
    force_suppress : boolean, optional, default=0
        Optional, if set false and id_index is provided, nms will only apply to boxes belongs to the same category
    in_format : {'center', 'corner'},optional, default='corner'
        The input box encoding type. 
     "corner" means boxes are encoded as [xmin, ymin, xmax, ymax], "center" means boxes are encodes as [x, y, width, height].
    out_format : {'center', 'corner'},optional, default='corner'
        The output box encoding type. 
     "corner" means boxes are encoded as [xmin, ymin, xmax, ymax], "center" means boxes are encodes as [x, y, width, height].

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_contrib_dynamic_reshape(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_copy(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_cos(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_cosh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_ctc_loss(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_degrees(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_diag(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_digamma(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_div(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_div_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_dot(transpose_a=_Null, transpose_b=_Null, forward_stype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    transpose_a : boolean, optional, default=0
        If true then transpose the first input before dot.
    transpose_b : boolean, optional, default=0
        If true then transpose the second input before dot.
    forward_stype : {None, 'csr', 'default', 'row_sparse'},optional, default='None'
        The desired storage type of the forward output given by user, if thecombination of input storage types and this hint does not matchany implemented ones, the dot operator will perform fallback operationand still produce an output of the desired storage type.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_erf(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_erfinv(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_expm1(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_foreach(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_gamma(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_gamma_sample(shape=_Null, scale=_Null, size=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    shape : float or None, required
    scale : float or None, required
    size : , optional, default=None
        Output shape. If the given shape is, e.g., (m, n, k), then m * n * k samples are drawn. Default is None, in which case a single value is returned.
    ctx : string, optional, default='cpu'
        Context of output, in format [xpu|xpu|xpu_pinned](n). Only used for imperative calls.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred.Defaults to float64 or float32 if not defined (dtype=None),which depends on your current default dtype.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_gammaln(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_gather_nd(data=None, indices=None, shape=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Accumulates data according to indices and get the result. It's the backward of
    `gather_nd`.

    Given `data` with shape `(Y_0, ..., Y_{K-1}, X_M, ..., X_{N-1})` and indices with shape
    `(M, Y_0, ..., Y_{K-1})`, the output will have shape `(X_0, X_1, ..., X_{N-1})`,
    where `M <= N`. If `M == N`, data shape should simply be `(Y_0, ..., Y_{K-1})`.

    The elements in output is defined as follows::

      output[indices[0, y_0, ..., y_{K-1}],
             ...,
             indices[M-1, y_0, ..., y_{K-1}],
             x_M, ..., x_{N-1}] += data[y_0, ..., y_{K-1}, x_M, ..., x_{N-1}]

    all other entries in output are 0 or the original value if AddTo is triggered.

    Examples::

      data = [2, 3, 0]
      indices = [[1, 1, 0], [0, 1, 0]]
      shape = (2, 2)
      _backward_gather_nd(data, indices, shape) = [[0, 0], [2, 3]] # Same as scatter_nd

      # The difference between scatter_nd and scatter_nd_acc is the latter will accumulate
      #  the values that point to the same index.

      data = [2, 3, 0]
      indices = [[1, 1, 0], [1, 1, 0]]
      shape = (2, 2)
      _backward_gather_nd(data, indices, shape) = [[0, 0], [0, 5]]



    Parameters
    ----------
    data : Symbol
        data
    indices : Symbol
        indices
    shape : Shape(tuple), required
        Shape of output.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_hard_sigmoid(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_hypot(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_hypot_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_im2col(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_image_crop(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_image_normalize(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_index_add_val(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_index_update_a(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_index_update_val(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_instance_norm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_interleaved_matmul_encdec_qk(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_interleaved_matmul_encdec_valatt(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_interleaved_matmul_selfatt_qk(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_interleaved_matmul_selfatt_valatt(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_det(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_extractdiag(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_extracttrian(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_gelqf(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_gemm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_gemm2(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_inverse(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_makediag(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_maketrian(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_potrf(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_potri(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_slogdet(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_sumlogdiag(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_syevd(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_syrk(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_trmm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linalg_trsm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_linear_reg_out(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_log(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_log10(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_log1p(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_log2(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_log_sigmoid(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_log_softmax(*args, **kwargs):
    r"""

    Parameters
    ----------
    args : Symbol[]
        Positional input arguments

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_logistic_reg_out(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_mae_reg_out(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_masked_log_softmax(*args, **kwargs):
    r"""

    Parameters
    ----------
    args : Symbol[]
        Positional input arguments

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_masked_softmax(*args, **kwargs):
    r"""

    Parameters
    ----------
    args : Symbol[]
        Positional input arguments

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_max(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_maximum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_maximum_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_mean(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_min(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_minimum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_minimum_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_mish(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_mod(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_mod_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_moments(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_mul(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_mul_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_nanprod(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_nansum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_norm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_advanced_indexing(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_advanced_indexing_multiple(data=None, indices=None, shape=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Accumulates data according to indices and get the result. It's the backward of
    `_npi_advanced_indexing_multiple`.


    Parameters
    ----------
    data : Symbol
        data
    indices : Symbol
        indices
    shape : Shape(tuple), required
        Shape of output.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_average(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_broadcast_to(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_column_stack(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_concat(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_dstack(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_hstack(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_matmul(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_mean(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_vstack(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_where(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_where_lscalar(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_np_where_rscalar(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_arccos(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_arccosh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_arcsin(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_arcsinh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_arctan(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_arctan2(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_arctan2_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_arctanh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_bitwise_left_shift(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_bitwise_left_shift_scalar(scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_bitwise_right_shift(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_bitwise_right_shift_scalar(scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_broadcast_add(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_broadcast_div(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_broadcast_mod(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_broadcast_mul(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_broadcast_power(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_broadcast_sub(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_cbrt(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_copysign(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_copysign_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_cos(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_cosh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_cross(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_cumsum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_degrees(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_diag(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_diagflat(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_diagonal(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_diff(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_dot(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_einsum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_exp(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_expm1(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_flip(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_fmax(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_fmax_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_fmin(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_fmin_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_fmod(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_fmod_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_hypot(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_kron(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_ldexp(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_ldexp_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_log(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_log10(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_log1p(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_log2(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_logaddexp(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_logaddexp_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_max(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_min(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_norm(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_pad(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_prod(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_qr(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_radians(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_rarctan2_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_rbitwise_left_shift_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_rbitwise_right_shift_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_rfmod_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_rldexp_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_sin(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_sinh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_solve(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_sqrt(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_sum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_svd(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_tan(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_tanh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_tensordot(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_tensordot_int_axes(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_tensorinv(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_tensorsolve(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npi_trace(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npx_cond(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npx_foreach(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_npx_while_loop(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pdf_dirichlet(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pdf_exponential(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pdf_gamma(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pdf_generalized_negative_binomial(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pdf_negative_binomial(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pdf_normal(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pdf_poisson(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pdf_uniform(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_pick(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_power(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_power_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_prod(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_radians(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_random_image_crop(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_random_resized_image_crop(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_rcbrt(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_rdiv_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_reciprocal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_relu(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_repeat(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_reshape(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_reverse(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_rmod_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_rpower_scalar(lhs=None, rhs=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_rsqrt(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sample_categorical(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sigmoid(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sin(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sinh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sldwin_atten_context(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sldwin_atten_score(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_slice(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_slice_axis(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_slice_like(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_smooth_l1(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_softmax(*args, **kwargs):
    r"""

    Parameters
    ----------
    args : Symbol[]
        Positional input arguments

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_softmax_cross_entropy(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_softmin(*args, **kwargs):
    r"""

    Parameters
    ----------
    args : Symbol[]
        Positional input arguments

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_softsign(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sparse_retain(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sqrt(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_square(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_square_sum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_squeeze(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_stack(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sub(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_sum(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_take(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_tan(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_tanh(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_tile(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_topk(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_tril(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_triu(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_where(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _backward_while_loop(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _broadcast_backward(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _cond(*data, **kwargs):
    r"""Run a if-then-else using user-defined condition and computation

    From:../src/operator/control_flow.cc:1196
    This function support variable length of positional input.

    Parameters
    ----------
    cond : Symbol
        Input graph for the condition.
    then_branch : Symbol
        Input graph for the then branch.
    else_branch : Symbol
        Input graph for the else branch.
    data : Symbol[]
        The input arrays that include data arrays and states.
    num_outputs : int, required
        The number of outputs of the subgraph.
    cond_input_locs : tuple of <long>, required
        The locations of cond's inputs in the given inputs.
    then_input_locs : tuple of <long>, required
        The locations of then's inputs in the given inputs.
    else_input_locs : tuple of <long>, required
        The locations of else's inputs in the given inputs.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _copy(data=None, name=None, attr=None, out=None, **kwargs):
    r"""Returns a copy of the input.

    From:../src/operator/tensor/elemwise_unary_op_basic.cc:348

    Parameters
    ----------
    data : Symbol
        The input array.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _copyto(data=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : NDArray
        input data

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _crop_assign(lhs=None, rhs=None, begin=_Null, end=_Null, step=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Assign the rhs to a cropped subset of lhs.

    Requirements
    ------------
    - output should be explicitly given and be the same as lhs.
    - lhs and rhs are of the same data type, and on the same device.


    From:../src/operator/tensor/matrix_op.cc:577

    Parameters
    ----------
    lhs : Symbol
        Source input
    rhs : Symbol
        value to assign
    begin : tuple of <>, required
        starting indices for the slice operation, supports negative indices.
    end : tuple of <>, required
        ending indices for the slice operation, supports negative indices.
    step : tuple of <>, optional, default=[]
        step for the slice operation, supports negative values.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _crop_assign_scalar(data=None, scalar=_Null, begin=_Null, end=_Null, step=_Null, name=None, attr=None, out=None, **kwargs):
    r"""(Assign the scalar to a cropped subset of the input.

    Requirements
    ------------
    - output should be explicitly given and be the same as input
    )

    From:../src/operator/tensor/matrix_op.cc:604

    Parameters
    ----------
    data : Symbol
        Source input
    scalar : double, optional, default=0
        The scalar value for assignment.
    begin : tuple of <>, required
        starting indices for the slice operation, supports negative indices.
    end : tuple of <>, required
        ending indices for the slice operation, supports negative indices.
    step : tuple of <>, optional, default=[]
        step for the slice operation, supports negative values.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _cvcopyMakeBorder(src=None, top=_Null, bot=_Null, left=_Null, right=_Null, type=_Null, value=_Null, values=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Pad image border with OpenCV. 


    Parameters
    ----------
    src : NDArray
        source image
    top : int, required
        Top margin.
    bot : int, required
        Bottom margin.
    left : int, required
        Left margin.
    right : int, required
        Right margin.
    type : int, optional, default='0'
        Filling type (default=cv2.BORDER_CONSTANT).
    value : double, optional, default=0
        (Deprecated! Use ``values`` instead.) Fill with single value.
    values : tuple of <double>, optional, default=[]
        Fill with value(RGB[A] or gray), up to 4 channels.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _cvimdecode(buf=None, flag=_Null, to_rgb=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Decode image with OpenCV. 
    Note: return image in RGB by default, instead of OpenCV's default BGR.

    Parameters
    ----------
    buf : NDArray
        Buffer containing binary encoded image
    flag : int, optional, default='1'
        Convert decoded image to grayscale (0) or color (1).
    to_rgb : boolean, optional, default=1
        Whether to convert decoded image to mxnet's default RGB format (instead of opencv's default BGR).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _cvimread(filename=_Null, flag=_Null, to_rgb=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Read and decode image with OpenCV. 
    Note: return image in RGB by default, instead of OpenCV's default BGR.

    Parameters
    ----------
    filename : string, required
        Name of the image file to be loaded.
    flag : int, optional, default='1'
        Convert decoded image to grayscale (0) or color (1).
    to_rgb : boolean, optional, default=1
        Whether to convert decoded image to mxnet's default RGB format (instead of opencv's default BGR).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _cvimresize(src=None, w=_Null, h=_Null, interp=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Resize image with OpenCV. 


    Parameters
    ----------
    src : NDArray
        source image
    w : int, required
        Width of resized image.
    h : int, required
        Height of resized image.
    interp : int, optional, default='1'
        Interpolation method (default=cv2.INTER_LINEAR).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _div(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Divides arguments element-wise.

    The storage type of ``elemwise_div`` output is always dense



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _div_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Divide an array with a scalar.

    ``_div_scalar`` only operates on data array of input if input is sparse.

    For example, if input of shape (100, 100) has only 2 non zero elements,
    i.e. input.data = [5, 6], scalar = nan,
    it will result output.data = [nan, nan] instead of 10000 nans.



    Defined in ../src/operator/tensor/elemwise_binary_scalar_op_basic.cc:L174

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _equal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _equal_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _eye(N=_Null, M=_Null, k=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Return a 2-D array with ones on the diagonal and zeros elsewhere.

    Parameters
    ----------
    N : long, required
        Number of rows in the output.
    M : long, optional, default=0
        Number of columns in the output. If 0, defaults to N
    k : long, optional, default=0
        Index of the diagonal. 0 (the default) refers to the main diagonal.A positive value refers to an upper diagonal.A negative value to a lower diagonal.
    ctx : string, optional, default=''
        Context of output, in format [cpu|gpu|cpu_pinned](n).Only used for imperative calls.
    dtype : {'None', 'bfloat16', 'float16', 'float32', 'float64', 'int32', 'int64', 'int8', 'uint8'},optional, default='None'
        Target data type.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _foreach(*data, **kwargs):
    r"""Run a for loop over an NDArray with user-defined computation

    From:../src/operator/control_flow.cc:1076
    This function support variable length of positional input.

    Parameters
    ----------
    fn : Symbol
        Input graph.
    data : Symbol[]
        The input arrays that include data arrays and states.
    num_outputs : int, required
        The number of outputs of the subgraph.
    num_out_data : int, required
        The number of output data of the subgraph.
    in_state_locs : tuple of <long>, required
        The locations of loop states among the inputs.
    in_data_locs : tuple of <long>, required
        The locations of input data among the inputs.
    remain_locs : tuple of <long>, required
        The locations of remaining data among the inputs.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _full(shape=_Null, ctx=_Null, dtype=_Null, value=_Null, name=None, attr=None, out=None, **kwargs):
    r"""fill target with a scalar value

    Parameters
    ----------
    shape : Shape(tuple), optional, default=None
        The shape of the output
    ctx : string, optional, default=''
        Context of output, in format [cpu|gpu|cpu_pinned](n).Only used for imperative calls.
    dtype : {'None', 'bfloat16', 'bool', 'float16', 'float32', 'float64', 'int16', 'int32', 'int64', 'int8', 'uint16', 'uint32', 'uint64', 'uint8'},optional, default='None'
        Target data type.
    value : double, required
        Value with which to fill newly created tensor

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _grad_add(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _greater(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _greater_equal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _greater_equal_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _greater_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _histogram(data=None, bins=None, bin_cnt=_Null, range=_Null, name=None, attr=None, out=None, **kwargs):
    r"""This operators implements the histogram function.

    Example::
      x = [[0, 1], [2, 2], [3, 4]]
      histo, bin_edges = histogram(data=x, bin_bounds=[], bin_cnt=5, range=(0,5))
      histo = [1, 1, 2, 1, 1]
      bin_edges = [0., 1., 2., 3., 4.]
      histo, bin_edges = histogram(data=x, bin_bounds=[0., 2.1, 3.])
      histo = [4, 1]



    Defined in ../src/operator/tensor/histogram.cc:L153

    Parameters
    ----------
    data : Symbol
        Input ndarray
    bins : Symbol
        Input ndarray
    bin_cnt : int or None, optional, default='None'
        Number of bins for uniform case
    range : , optional, default=None
        The lower and upper range of the bins. if not provided, range is simply (a.min(), a.max()). values outside the range are ignored. the first element of the range must be less than or equal to the second. range affects the automatic bin computation as well. while bin width is computed to be optimal based on the actual data within range, the bin count will fill the entire range including portions containing no data.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _hypot(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Given the "legs" of a right triangle, return its hypotenuse.



    Defined in ../src/operator/tensor/elemwise_binary_op_extended.cc:L79

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _hypot_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _identity_with_attr_like_rhs(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        First input.
    rhs : Symbol
        Second input.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _imdecode(mean=None, index=_Null, x0=_Null, y0=_Null, x1=_Null, y1=_Null, c=_Null, size=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Decode an image, clip to (x0, y0, x1, y1), subtract mean, and write to buffer

    Parameters
    ----------
    mean : Symbol
        image mean
    index : int
        buffer position for output
    x0 : int
        x0
    y0 : int
        y0
    x1 : int
        x1
    y1 : int
        y1
    c : int
        channel
    size : int
        length of str_img

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _lesser(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _lesser_equal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _lesser_equal_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _lesser_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _linspace(start=_Null, stop=_Null, step=_Null, repeat=_Null, infer_range=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Return evenly spaced numbers over a specified interval. Similar to Numpy

    Parameters
    ----------
    start : double, required
        Start of interval. The interval includes this value. The default start value is 0.
    stop : double or None, optional, default=None
        End of interval. The interval does not include this value, except in some cases where step is not an integer and floating point round-off affects the length of out.
    step : double, optional, default=1
        Spacing between values.
    repeat : int, optional, default='1'
        The repeating time of all elements. E.g repeat=3, the element a will be repeated three times --> a, a, a.
    infer_range : boolean, optional, default=0
        When set to True, infer the stop position from the start, step, repeat, and output tensor size.
    ctx : string, optional, default=''
        Context of output, in format [cpu|gpu|cpu_pinned](n).Only used for imperative calls.
    dtype : {'None', 'bfloat16', 'float16', 'float32', 'float64', 'int32', 'int64', 'int8', 'uint8'},optional, default='None'
        Target data type.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _logical_and(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _logical_and_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _logical_or(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _logical_or_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _logical_xor(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _logical_xor_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _maximum(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _maximum_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _minimum(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _minimum_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _minus(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Subtracts arguments element-wise.

    The storage type of ``elemwise_sub`` output depends on storage types of inputs

       - elemwise_sub(row_sparse, row_sparse) = row_sparse
       - elemwise_sub(csr, csr) = csr
       - elemwise_sub(default, csr) = default
       - elemwise_sub(csr, default) = default
       - elemwise_sub(default, rsp) = default
       - elemwise_sub(rsp, default) = default
       - otherwise, ``elemwise_sub`` generates output with default storage



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _minus_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _mod(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _mod_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _mp_adabelief_update(weight=None, grad=None, mean=None, var=None, weight32=None, rescale_grad=None, lr=_Null, beta1=_Null, beta2=_Null, epsilon=_Null, wd=_Null, eta=_Null, clip_gradient=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Update function for multi-precision AdaBelief optimizer.

    AdaBelief is seen as a modification of Adam with a different variance 
    estimator.

    Adam update consists of the following steps, where g represents gradient and m, s
    are 1st and 2nd order moment estimates (mean and variance).

    .. math::

     g_t = \nabla J(W_{t-1}) + w * wd \\
     m_t = \beta_1 m_{t-1} + (1 - \beta_1) g_t\\
     s_t = \beta_2 v_{t-1} + (1 - \beta_2) (g_t - m_t)^2 + \epsilon\\
     W_t = W_{t-1} - \eta_t (\alpha \frac{ m_t }{ \sqrt{ v_t } + \epsilon })

    It updates the weights using::

     m = beta1*m + (1-beta1)*grad
     s = beta2*v + (1-beta2)*(grad**2)
     w -= eta * (learning_rate * m / (sqrt(s) + epsilon))

    Note that gradient is rescaled to grad = rescale_grad * grad. If rescale_grad is NaN, Inf, or 0,
    the update is skipped.


    Defined in ../src/operator/contrib/adabelief.cc:L58

    Parameters
    ----------
    weight : Symbol
        Weight
    grad : Symbol
        Gradient
    mean : Symbol
        Moving mean
    var : Symbol
        Moving variance
    weight32 : Symbol
        Weight32
    rescale_grad : Symbol
        Rescale gradient to rescale_grad * grad. If NaN, Inf, or 0, the update is skipped.
    lr : float, required
        Learning rate
    beta1 : float, optional, default=0.899999976
        The decay rate for the 1st moment estimates.
    beta2 : float, optional, default=0.999000013
        The decay rate for the 2nd moment estimates.
    epsilon : float, optional, default=9.99999994e-09
        A small constant for numerical stability.
    wd : float, optional, default=0
        Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    eta : float, required
        Learning rate schedule multiplier
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _mp_adamw_update(weight=None, grad=None, mean=None, var=None, weight32=None, rescale_grad=None, lr=_Null, beta1=_Null, beta2=_Null, epsilon=_Null, wd=_Null, eta=_Null, clip_gradient=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Update function for multi-precision AdamW optimizer.

    AdamW is seen as a modification of Adam by decoupling the weight decay from the
    optimization steps taken w.r.t. the loss function.

    Adam update consists of the following steps, where g represents gradient and m, v
    are 1st and 2nd order moment estimates (mean and variance).

    .. math::

     g_t = \nabla J(W_{t-1})\\
     m_t = \beta_1 m_{t-1} + (1 - \beta_1) g_t\\
     v_t = \beta_2 v_{t-1} + (1 - \beta_2) g_t^2\\
     W_t = W_{t-1} - \eta_t (\alpha \frac{ m_t }{ \sqrt{ v_t } + \epsilon } + wd W_{t-1})

    It updates the weights using::

     m = beta1*m + (1-beta1)*grad
     v = beta2*v + (1-beta2)*(grad**2)
     w -= eta * (learning_rate * m / (sqrt(v) + epsilon) + w * wd)

    Note that gradient is rescaled to grad = rescale_grad * grad. If rescale_grad is NaN, Inf, or 0,
    the update is skipped.


    Defined in ../src/operator/contrib/adamw.cc:L58

    Parameters
    ----------
    weight : Symbol
        Weight
    grad : Symbol
        Gradient
    mean : Symbol
        Moving mean
    var : Symbol
        Moving variance
    weight32 : Symbol
        Weight32
    rescale_grad : Symbol
        Rescale gradient to rescale_grad * grad. If NaN, Inf, or 0, the update is skipped.
    lr : float, required
        Learning rate
    beta1 : float, optional, default=0.899999976
        The decay rate for the 1st moment estimates.
    beta2 : float, optional, default=0.999000013
        The decay rate for the 2nd moment estimates.
    epsilon : float, optional, default=9.99999994e-09
        A small constant for numerical stability.
    wd : float, optional, default=0
        Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    eta : float, required
        Learning rate schedule multiplier
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _mul(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Multiplies arguments element-wise.

    The storage type of ``elemwise_mul`` output depends on storage types of inputs

       - elemwise_mul(default, default) = default
       - elemwise_mul(row_sparse, row_sparse) = row_sparse
       - elemwise_mul(default, row_sparse) = row_sparse
       - elemwise_mul(row_sparse, default) = row_sparse
       - elemwise_mul(csr, csr) = csr
       - otherwise, ``elemwise_mul`` generates output with default storage



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _mul_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Multiply an array with a scalar.

    ``_mul_scalar`` only operates on data array of input if input is sparse.

    For example, if input of shape (100, 100) has only 2 non zero elements,
    i.e. input.data = [5, 6], scalar = nan,
    it will result output.data = [nan, nan] instead of 10000 nans.



    Defined in ../src/operator/tensor/elemwise_binary_scalar_op_basic.cc:L152

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _multi_adabelief_update(*data, **kwargs):
    r"""Update function for AdaBelief optimizer.

    AdaBelief is seen as a modification of Adam with a different variance 
    estimator.

    Adam update consists of the following steps, where g represents gradient and m, s
    are 1st and 2nd order moment estimates (mean and variance).

    .. math::

     g_t = \nabla J(W_{t-1}) + w * wd \\
     m_t = \beta_1 m_{t-1} + (1 - \beta_1) g_t\\
     s_t = \beta_2 v_{t-1} + (1 - \beta_2) (g_t - m_t)^2\\
     W_t = W_{t-1} - \eta_t (\alpha \frac{ m_t }{ \sqrt{ v_t } + \epsilon })

    It updates the weights using::

     m = beta1*m + (1-beta1)*grad
     s = beta2*v + (1-beta2)*(grad**2)
     w -= eta * (learning_rate * m / (sqrt(s) + epsilon))

    Note that gradient is rescaled to grad = rescale_grad * grad. If rescale_grad is NaN, Inf, or 0,
    the update is skipped.
    )

    Defined in ../src/operator/contrib/adabelief.cc:L172

    Parameters
    ----------
    data : Symbol[]
        data
    lrs : tuple of <float>, required
        Learning rates
    beta1 : float, optional, default=0.899999976
        The decay rate for the 1st moment estimates.
    beta2 : float, optional, default=0.999000013
        The decay rate for the 2nd moment estimates.
    epsilon : float, optional, default=9.99999994e-09
        A small constant for numerical stability.
    wds : tuple of <float>, required
        Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    etas : tuple of <float>, required
        Learning rates schedule multiplier
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).
    num_weights : int, optional, default='1'
        Number of updated weights.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _multi_adamw_update(*data, **kwargs):
    r"""Update function for AdamW optimizer.

    AdamW is seen as a modification of Adam by decoupling the weight decay from the
    optimization steps taken w.r.t. the loss function.

    Adam update consists of the following steps, where g represents gradient and m, v
    are 1st and 2nd order moment estimates (mean and variance).

    .. math::

     g_t = \nabla J(W_{t-1})\\
     m_t = \beta_1 m_{t-1} + (1 - \beta_1) g_t\\
     v_t = \beta_2 v_{t-1} + (1 - \beta_2) g_t^2\\
     W_t = W_{t-1} - \eta_t (\alpha \frac{ m_t }{ \sqrt{ v_t } + \epsilon } + wd W_{t-1})

    It updates the weights using::

     m = beta1*m + (1-beta1)*grad
     v = beta2*v + (1-beta2)*(grad**2)
     w -= eta * (learning_rate * m / (sqrt(v) + epsilon) + w * wd)

    Note that gradient is rescaled to grad = rescale_grad * grad. If rescale_grad is NaN, Inf, or 0,
    the update is skipped.


    Defined in ../src/operator/contrib/adamw.cc:L170

    Parameters
    ----------
    data : Symbol[]
        data
    lrs : tuple of <float>, required
        Learning rates
    beta1 : float, optional, default=0.899999976
        The decay rate for the 1st moment estimates.
    beta2 : float, optional, default=0.999000013
        The decay rate for the 2nd moment estimates.
    epsilon : float, optional, default=9.99999994e-09
        A small constant for numerical stability.
    wds : tuple of <float>, required
        Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    etas : tuple of <float>, required
        Learning rates schedule multiplier
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).
    num_weights : int, optional, default='1'
        Number of updated weights.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _multi_lamb_update(*data, **kwargs):
    r"""Compute the LAMB coefficients of multiple weights and grads"


    Defined in ../src/operator/contrib/multi_lamb.cc:L184

    Parameters
    ----------
    data : Symbol[]
        data
    learning_rates : tuple of <float>, required
        List of learning rates
    beta1 : float, optional, default=0.899999976
        Exponential decay rate for the first moment estimates.
    beta2 : float, optional, default=0.999000013
        Exponential decay rate for the second moment estimates.
    epsilon : float, optional, default=9.99999997e-07
        Small value to avoid division by 0.
    wds : tuple of <float>, required
        List of Weight decays.Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    rescale_grad : float, optional, default=1
        Gradient rescaling factor
    lower_bound : float, optional, default=-1
        Lower limit of norm of weight. If lower_bound <= 0, Lower limit is not set
    upper_bound : float, optional, default=-1
        Upper limit of norm of weight. If upper_bound <= 0, Upper limit is not set
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).
    bias_correction : boolean, optional, default=1
        Whether to use bias correction.
    step_count : Shape(tuple), required
        Step count for each tensor
    num_tensors : int, optional, default='1'
        Number of tensors

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _multi_lans_update(*data, **kwargs):
    r"""Compute the LANS coefficients of multiple weights and grads"


    Defined in ../src/operator/contrib/multi_lans.cc:L205

    Parameters
    ----------
    data : Symbol[]
        data
    learning_rates : tuple of <float>, required
        List of learning rates
    beta1 : float, optional, default=0.899999976
        Exponential decay rate for the first moment estimates.
    beta2 : float, optional, default=0.999000013
        Exponential decay rate for the second moment estimates.
    epsilon : float, optional, default=9.99999997e-07
        Small value to avoid division by 0.
    wds : tuple of <float>, required
        List of Weight decays.Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    rescale_grad : float, optional, default=1
        Gradient rescaling factor
    lower_bound : float, optional, default=-1
        Lower limit of norm of weight. If lower_bound <= 0, Lower limit is not set
    upper_bound : float, optional, default=-1
        Upper limit of norm of weight. If upper_bound <= 0, Upper limit is not set
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).
    step_count : Shape(tuple), required
        Step count for each tensor
    num_tensors : int, optional, default='1'
        Number of tensors

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _multi_mp_adabelief_update(*data, **kwargs):
    r"""Update function for multi-precision AdaBelief optimizer.

    AdaBelief is seen as a modification of Adam with a different variance 
    estimator.

    Adam update consists of the following steps, where g represents gradient and m, s
    are 1st and 2nd order moment estimates (mean and variance).

    .. math::

     g_t = \nabla J(W_{t-1}) + w * wd \\
     m_t = \beta_1 m_{t-1} + (1 - \beta_1) g_t\\
     s_t = \beta_2 v_{t-1} + (1 - \beta_2) (g_t - m_t)^2 + \epsilon\\
     W_t = W_{t-1} - \eta_t (\alpha \frac{ m_t }{ \sqrt{ v_t } + \epsilon })

    It updates the weights using::

     m = beta1*m + (1-beta1)*grad
     s = beta2*v + (1-beta2)*(grad**2)
     w -= eta * (learning_rate * m / (sqrt(s) + epsilon))

    Note that gradient is rescaled to grad = rescale_grad * grad. If rescale_grad is NaN, Inf, or 0,
    the update is skipped.
    )

    Defined in ../src/operator/contrib/adabelief.cc:L226

    Parameters
    ----------
    data : Symbol[]
        data
    lrs : tuple of <float>, required
        Learning rates
    beta1 : float, optional, default=0.899999976
        The decay rate for the 1st moment estimates.
    beta2 : float, optional, default=0.999000013
        The decay rate for the 2nd moment estimates.
    epsilon : float, optional, default=9.99999994e-09
        A small constant for numerical stability.
    wds : tuple of <float>, required
        Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    etas : tuple of <float>, required
        Learning rates schedule multiplier
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).
    num_weights : int, optional, default='1'
        Number of updated weights.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _multi_mp_adamw_update(*data, **kwargs):
    r"""Update function for multi-precision AdamW optimizer.

    AdamW is seen as a modification of Adam by decoupling the weight decay from the
    optimization steps taken w.r.t. the loss function.

    Adam update consists of the following steps, where g represents gradient and m, v
    are 1st and 2nd order moment estimates (mean and variance).

    .. math::

     g_t = \nabla J(W_{t-1})\\
     m_t = \beta_1 m_{t-1} + (1 - \beta_1) g_t\\
     v_t = \beta_2 v_{t-1} + (1 - \beta_2) g_t^2\\
     W_t = W_{t-1} - \eta_t (\alpha \frac{ m_t }{ \sqrt{ v_t } + \epsilon } + wd W_{t-1})

    It updates the weights using::

     m = beta1*m + (1-beta1)*grad
     v = beta2*v + (1-beta2)*(grad**2)
     w -= eta * (learning_rate * m / (sqrt(v) + epsilon) + w * wd)

    Note that gradient is rescaled to grad = rescale_grad * grad. If rescale_grad is NaN, Inf, or 0,
    the update is skipped.


    Defined in ../src/operator/contrib/adamw.cc:L223

    Parameters
    ----------
    data : Symbol[]
        data
    lrs : tuple of <float>, required
        Learning rates
    beta1 : float, optional, default=0.899999976
        The decay rate for the 1st moment estimates.
    beta2 : float, optional, default=0.999000013
        The decay rate for the 2nd moment estimates.
    epsilon : float, optional, default=9.99999994e-09
        A small constant for numerical stability.
    wds : tuple of <float>, required
        Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    etas : tuple of <float>, required
        Learning rates schedule multiplier
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).
    num_weights : int, optional, default='1'
        Number of updated weights.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _multi_mp_lamb_update(*data, **kwargs):
    r"""Compute the LAMB coefficients of multiple weights and grads with Mix Precision"


    Defined in ../src/operator/contrib/multi_lamb.cc:L218

    Parameters
    ----------
    data : Symbol[]
        data
    learning_rates : tuple of <float>, required
        List of learning rates
    beta1 : float, optional, default=0.899999976
        Exponential decay rate for the first moment estimates.
    beta2 : float, optional, default=0.999000013
        Exponential decay rate for the second moment estimates.
    epsilon : float, optional, default=9.99999997e-07
        Small value to avoid division by 0.
    wds : tuple of <float>, required
        List of Weight decays.Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    rescale_grad : float, optional, default=1
        Gradient rescaling factor
    lower_bound : float, optional, default=-1
        Lower limit of norm of weight. If lower_bound <= 0, Lower limit is not set
    upper_bound : float, optional, default=-1
        Upper limit of norm of weight. If upper_bound <= 0, Upper limit is not set
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).
    bias_correction : boolean, optional, default=1
        Whether to use bias correction.
    step_count : Shape(tuple), required
        Step count for each tensor
    num_tensors : int, optional, default='1'
        Number of tensors

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _multi_mp_lans_update(*data, **kwargs):
    r"""Compute the Nesterov LAMB coefficients of multiple weights and grads with Mix Precision"


    Defined in ../src/operator/contrib/multi_lans.cc:L240

    Parameters
    ----------
    data : Symbol[]
        data
    learning_rates : tuple of <float>, required
        List of learning rates
    beta1 : float, optional, default=0.899999976
        Exponential decay rate for the first moment estimates.
    beta2 : float, optional, default=0.999000013
        Exponential decay rate for the second moment estimates.
    epsilon : float, optional, default=9.99999997e-07
        Small value to avoid division by 0.
    wds : tuple of <float>, required
        List of Weight decays.Weight decay augments the objective function with a regularization term that penalizes large weights. The penalty scales with the square of the magnitude of each weight.
    rescale_grad : float, optional, default=1
        Gradient rescaling factor
    lower_bound : float, optional, default=-1
        Lower limit of norm of weight. If lower_bound <= 0, Lower limit is not set
    upper_bound : float, optional, default=-1
        Upper limit of norm of weight. If upper_bound <= 0, Upper limit is not set
    clip_gradient : float, optional, default=-1
        Clip gradient to the range of [-clip_gradient, clip_gradient] If clip_gradient <= 0, gradient clipping is turned off. grad = max(min(grad, clip_gradient), -clip_gradient).
    step_count : Shape(tuple), required
        Step count for each tensor
    num_tensors : int, optional, default='1'
        Number of tensors

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _not_equal(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _not_equal_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _onehot_encode(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : NDArray
        Left operand to the function.
    rhs : NDArray
        Right operand to the function.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _ones(shape=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""fill target with ones

    Parameters
    ----------
    shape : Shape(tuple), optional, default=[]
        The shape of the output
    ctx : string, optional, default=''
        Context of output, in format [cpu|gpu|cpu_pinned](n).Only used for imperative calls.
    dtype : {'None', 'bfloat16', 'bool', 'float16', 'float32', 'float64', 'int16', 'int32', 'int64', 'int8', 'uint16', 'uint32', 'uint64', 'uint8'},optional, default='None'
        Target data type.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _plus(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Adds arguments element-wise.

    The storage type of ``elemwise_add`` output depends on storage types of inputs

       - elemwise_add(row_sparse, row_sparse) = row_sparse
       - elemwise_add(csr, csr) = csr
       - elemwise_add(default, csr) = default
       - elemwise_add(csr, default) = default
       - elemwise_add(default, rsp) = default
       - elemwise_add(rsp, default) = default
       - otherwise, ``elemwise_add`` generates output with default storage



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _plus_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _power(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _power_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _ravel_multi_index(data=None, shape=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Converts a batch of index arrays into an array of flat indices. The operator follows numpy conventions so a single multi index is given by a column of the input matrix. The leading dimension may be left unspecified by using -1 as placeholder.  

    Examples::
   
       A = [[3,6,6],[4,5,1]]
       ravel(A, shape=(7,6)) = [22,41,37]
       ravel(A, shape=(-1,6)) = [22,41,37]



    Defined in ../src/operator/tensor/ravel.cc:L42

    Parameters
    ----------
    data : Symbol
        Batch of multi-indices
    shape : Shape(tuple), optional, default=None
        Shape of the array into which the multi-indices apply.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _rdiv_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _rminus_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _rmod_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _rnn_param_concat(*data, **kwargs):
    r"""
    This function support variable length of positional input.

    Parameters
    ----------
    data : Symbol[]
        List of arrays to concatenate
    dim : int or None, optional, default='1'
        the dimension to be concated.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _rpower_scalar(data=None, scalar=_Null, is_int=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    data : Symbol
        source input
    scalar : double, optional, default=1
        Scalar input value
    is_int : boolean, optional, default=1
        Indicate whether scalar input is int type

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_binomial(n=None, p=None, shape=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple
    binomial distributions with parameters *n* (number of trials) and *p* (success probability).

    The parameters of the distributions are provided as input arrays.
    Let *[s]* be the shape of the input arrays, *n* be the dimension of *[s]*, *[t]*
    be the shape specified as the parameter of the operator, and *m* be the dimension
    of *[t]*. Then the output will be a *(n+m)*-dimensional array with shape *[s]x[t]*.

    For any valid *n*-dimensional index *i* with respect to the input arrays, *output[i]*
    will be an *m*-dimensional array that holds randomly drawn samples from the distribution
    which is parameterized by the input values at index *i*. If the shape parameter of the
    operator is not set, then one sample will be drawn per distribution and the output array
    has the same shape as the input arrays.

    Samples will always be returned as a floating point data type.

    Examples::

       n = [ 20, 49 ]
       p = [ 0.4 , 0.77 ]

       // Draw a single sample for each distribution
       sample_binomial(n, p) = [ 5.,  36.]

       // Draw a vector containing two samples for each distribution
       sample_binomial(n, p, shape=(2)) = [[ 5.,  40.],
                                           [ 11.,  35.]]


    Defined in ../src/operator/random/multisample_op.cc:L352

    Parameters
    ----------
    n : Symbol
        Number of experiments.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 if not defined (dtype=None).
    p : Symbol
        Success probabilities in each experiment.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_categorical(data=None, shape=_Null, get_prob=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple categorical distributions.

    *data* is an *n* dimensional array whose last dimension has length *k*, where
    *k* is the number of possible outcomes of each categorical distribution. This
    operator will draw *shape* samples from each distribution. If shape is empty
    one sample will be drawn from each distribution.

    If *get_prob* is true, a second array containing log likelihood of the drawn
    samples will also be returned. This is usually used for reinforcement learning
    where you can provide reward as head gradient for this array to estimate
    gradient.

    Note that the input distribution must be normalized, i.e. *data* must sum to
    1 along its last axis.

    Examples::

       probs = [[0, 0.1, 0.2, 0.3, 0.4], [0.4, 0.3, 0.2, 0.1, 0]]

       // Draw a single sample for each distribution
       sample_categorical(probs) = [3, 0]

       // Draw a vector containing two samples for each distribution
       sample_categorical(probs, shape=(2)) = [[4, 2],
                                               [0, 0]]

       // requests log likelihood
       sample_categorical(probs, get_prob=True) = [2, 1], [0.2, 0.3]


    Parameters
    ----------
    data : Symbol
        Distribution probabilities. Must sum to one on the last axis.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    get_prob : boolean, optional, default=0
        Whether to also return the log probability of sampled result. This is usually used for differentiating through stochastic variables, e.g. in reinforcement learning.
    dtype : {'float16', 'float32', 'float64', 'int32', 'uint8'},optional, default='int32'
        DType of the output in case this can't be inferred.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_exponential(lam=None, shape=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple
    exponential distributions with parameters lambda (rate).

    The parameters of the distributions are provided as an input array.
    Let *[s]* be the shape of the input array, *n* be the dimension of *[s]*, *[t]*
    be the shape specified as the parameter of the operator, and *m* be the dimension
    of *[t]*. Then the output will be a *(n+m)*-dimensional array with shape *[s]x[t]*.

    For any valid *n*-dimensional index *i* with respect to the input array, *output[i]*
    will be an *m*-dimensional array that holds randomly drawn samples from the distribution
    which is parameterized by the input value at index *i*. If the shape parameter of the
    operator is not set, then one sample will be drawn per distribution and the output array
    has the same shape as the input array.

    Examples::

       lam = [ 1.0, 8.5 ]

       // Draw a single sample for each distribution
       sample_exponential(lam) = [ 0.51837951,  0.09994757]

       // Draw a vector containing two samples for each distribution
       sample_exponential(lam, shape=(2)) = [[ 0.51837951,  0.19866663],
                                             [ 0.09994757,  0.50447971]]


    Defined in ../src/operator/random/multisample_op.cc:L339

    Parameters
    ----------
    lam : Symbol
        Lambda (rate) parameters of the distributions.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 if not defined (dtype=None).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_gamma(alpha=None, beta=None, shape=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple
    gamma distributions with parameters *alpha* (shape) and *beta* (scale).

    The parameters of the distributions are provided as input arrays.
    Let *[s]* be the shape of the input arrays, *n* be the dimension of *[s]*, *[t]*
    be the shape specified as the parameter of the operator, and *m* be the dimension
    of *[t]*. Then the output will be a *(n+m)*-dimensional array with shape *[s]x[t]*.

    For any valid *n*-dimensional index *i* with respect to the input arrays, *output[i]*
    will be an *m*-dimensional array that holds randomly drawn samples from the distribution
    which is parameterized by the input values at index *i*. If the shape parameter of the
    operator is not set, then one sample will be drawn per distribution and the output array
    has the same shape as the input arrays.

    Examples::

       alpha = [ 0.0, 2.5 ]
       beta = [ 1.0, 0.7 ]

       // Draw a single sample for each distribution
       sample_gamma(alpha, beta) = [ 0.        ,  2.25797319]

       // Draw a vector containing two samples for each distribution
       sample_gamma(alpha, beta, shape=(2)) = [[ 0.        ,  0.        ],
                                               [ 2.25797319,  1.70734084]]


    Defined in ../src/operator/random/multisample_op.cc:L334

    Parameters
    ----------
    alpha : Symbol
        Alpha (shape) parameters of the distributions.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 if not defined (dtype=None).
    beta : Symbol
        Beta (scale) parameters of the distributions.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_generalized_negative_binomial(mu=None, alpha=None, shape=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple
    generalized negative binomial distributions with parameters *mu* (mean) and *alpha* (dispersion).

    The parameters of the distributions are provided as input arrays.
    Let *[s]* be the shape of the input arrays, *n* be the dimension of *[s]*, *[t]*
    be the shape specified as the parameter of the operator, and *m* be the dimension
    of *[t]*. Then the output will be a *(n+m)*-dimensional array with shape *[s]x[t]*.

    For any valid *n*-dimensional index *i* with respect to the input arrays, *output[i]*
    will be an *m*-dimensional array that holds randomly drawn samples from the distribution
    which is parameterized by the input values at index *i*. If the shape parameter of the
    operator is not set, then one sample will be drawn per distribution and the output array
    has the same shape as the input arrays.

    Samples will always be returned as a floating point data type.

    Examples::

       mu = [ 2.0, 2.5 ]
       alpha = [ 1.0, 0.1 ]

       // Draw a single sample for each distribution
       sample_generalized_negative_binomial(mu, alpha) = [ 0.,  3.]

       // Draw a vector containing two samples for each distribution
       sample_generalized_negative_binomial(mu, alpha, shape=(2)) = [[ 0.,  3.],
                                                                     [ 3.,  1.]]


    Defined in ../src/operator/random/multisample_op.cc:L366

    Parameters
    ----------
    mu : Symbol
        Means of the distributions.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 if not defined (dtype=None).
    alpha : Symbol
        Alpha (dispersion) parameters of the distributions.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_multinomial(n=None, p=None, shape=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple multinomial distributions.

    Samples are distributed according to a multinomial distribution parametrized by
    *n* (number of experiments) and *p* (success probabilities of the k possible outcomes
    in each experiment). Samples will always be returned as a floating point data type.

    Note that the input distribution must be normalized, i.e. *p* must sum to
    1 along its last axis.

    Examples::

       n = [5., 6.]
       probs = [[0., 0.1, 0.2, 0.3, 0.4], [0.4, 0.3, 0.2, 0.1, 0.]]

       multinomial(n, probs) = [[0., 0., 0., 3., 2.],
                                [0., 3., 1., 2., 0.]]


    Parameters
    ----------
    n : Symbol
        Number of experiments
    p : Symbol
        Probability of every outcome in each experiment. Must sum to 1 on the last axis
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    ctx : string, optional, default=''
        Context of output, in format [cpu|gpu|cpu_pinned](n). Only used for imperative calls.
    dtype : {'float16', 'float32', 'float64', 'int32', 'uint8'},optional, default='int32'
        DType of the output in case this can't be inferred.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_negative_binomial(k=None, p=None, shape=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple
    negative binomial distributions with parameters *k* (failure limit) and *p* (failure probability).

    The parameters of the distributions are provided as input arrays.
    Let *[s]* be the shape of the input arrays, *n* be the dimension of *[s]*, *[t]*
    be the shape specified as the parameter of the operator, and *m* be the dimension
    of *[t]*. Then the output will be a *(n+m)*-dimensional array with shape *[s]x[t]*.

    For any valid *n*-dimensional index *i* with respect to the input arrays, *output[i]*
    will be an *m*-dimensional array that holds randomly drawn samples from the distribution
    which is parameterized by the input values at index *i*. If the shape parameter of the
    operator is not set, then one sample will be drawn per distribution and the output array
    has the same shape as the input arrays.

    Samples will always be returned as a floating point data type.

    Examples::

       k = [ 20, 49 ]
       p = [ 0.4 , 0.77 ]

       // Draw a single sample for each distribution
       sample_negative_binomial(k, p) = [ 15.,  16.]

       // Draw a vector containing two samples for each distribution
       sample_negative_binomial(k, p, shape=(2)) = [[ 15.,  50.],
                                                    [ 16.,  12.]]


    Defined in ../src/operator/random/multisample_op.cc:L359

    Parameters
    ----------
    k : Symbol
        Limits of unsuccessful experiments.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 if not defined (dtype=None).
    p : Symbol
        Failure probabilities in each experiment.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_normal(mu=None, sigma=None, shape=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple
    normal distributions with parameters *mu* (mean) and *sigma* (standard deviation).

    The parameters of the distributions are provided as input arrays.
    Let *[s]* be the shape of the input arrays, *n* be the dimension of *[s]*, *[t]*
    be the shape specified as the parameter of the operator, and *m* be the dimension
    of *[t]*. Then the output will be a *(n+m)*-dimensional array with shape *[s]x[t]*.

    For any valid *n*-dimensional index *i* with respect to the input arrays, *output[i]*
    will be an *m*-dimensional array that holds randomly drawn samples from the distribution
    which is parameterized by the input values at index *i*. If the shape parameter of the
    operator is not set, then one sample will be drawn per distribution and the output array
    has the same shape as the input arrays.

    Examples::

       mu = [ 0.0, 2.5 ]
       sigma = [ 1.0, 3.7 ]

       // Draw a single sample for each distribution
       sample_normal(mu, sigma) = [-0.56410581,  0.95934606]

       // Draw a vector containing two samples for each distribution
       sample_normal(mu, sigma, shape=(2)) = [[-0.56410581,  0.2928229 ],
                                              [ 0.95934606,  4.48287058]]


    Defined in ../src/operator/random/multisample_op.cc:L327

    Parameters
    ----------
    mu : Symbol
        Means of the distributions.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 if not defined (dtype=None).
    sigma : Symbol
        Standard deviations of the distributions.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_poisson(lam=None, shape=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple
    Poisson distributions with parameters lambda (rate).

    The parameters of the distributions are provided as an input array.
    Let *[s]* be the shape of the input array, *n* be the dimension of *[s]*, *[t]*
    be the shape specified as the parameter of the operator, and *m* be the dimension
    of *[t]*. Then the output will be a *(n+m)*-dimensional array with shape *[s]x[t]*.

    For any valid *n*-dimensional index *i* with respect to the input array, *output[i]*
    will be an *m*-dimensional array that holds randomly drawn samples from the distribution
    which is parameterized by the input value at index *i*. If the shape parameter of the
    operator is not set, then one sample will be drawn per distribution and the output array
    has the same shape as the input array.

    Samples will always be returned as a floating point data type.

    Examples::

       lam = [ 1.0, 8.5 ]

       // Draw a single sample for each distribution
       sample_poisson(lam) = [  0.,  13.]

       // Draw a vector containing two samples for each distribution
       sample_poisson(lam, shape=(2)) = [[  0.,   4.],
                                         [ 13.,   8.]]


    Defined in ../src/operator/random/multisample_op.cc:L344

    Parameters
    ----------
    lam : Symbol
        Lambda (rate) parameters of the distributions.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 if not defined (dtype=None).

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_uniform(low=None, high=None, shape=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Concurrent sampling from multiple
    uniform distributions on the intervals given by *[low,high)*.

    The parameters of the distributions are provided as input arrays.
    Let *[s]* be the shape of the input arrays, *n* be the dimension of *[s]*, *[t]*
    be the shape specified as the parameter of the operator, and *m* be the dimension
    of *[t]*. Then the output will be a *(n+m)*-dimensional array with shape *[s]x[t]*.

    For any valid *n*-dimensional index *i* with respect to the input arrays, *output[i]*
    will be an *m*-dimensional array that holds randomly drawn samples from the distribution
    which is parameterized by the input values at index *i*. If the shape parameter of the
    operator is not set, then one sample will be drawn per distribution and the output array
    has the same shape as the input arrays.

    Examples::

       low = [ 0.0, 2.5 ]
       high = [ 1.0, 3.7 ]

       // Draw a single sample for each distribution
       sample_uniform(low, high) = [ 0.40451524,  3.18687344]

       // Draw a vector containing two samples for each distribution
       sample_uniform(low, high, shape=(2)) = [[ 0.40451524,  0.18017688],
                                               [ 3.18687344,  3.68352246]]


    Defined in ../src/operator/random/multisample_op.cc:L320

    Parameters
    ----------
    low : Symbol
        Lower bounds of the distributions.
    shape : Shape(tuple), optional, default=[]
        Shape to be sampled from each random distribution.
    dtype : {'None', 'float16', 'float32', 'float64'},optional, default='None'
        DType of the output in case this can't be inferred. Defaults to float32 if not defined (dtype=None).
    high : Symbol
        Upper bounds of the distributions.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sample_unique_zipfian(range_max=_Null, shape=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Draw random samples from an an approximately log-uniform
    or Zipfian distribution without replacement.

    This operation takes a 2-D shape `(batch_size, num_sampled)`,
    and randomly generates *num_sampled* samples from the range of integers [0, range_max)
    for each instance in the batch.

    The elements in each instance are drawn without replacement from the base distribution.
    The base distribution for this operator is an approximately log-uniform or Zipfian distribution:

      P(class) = (log(class + 2) - log(class + 1)) / log(range_max + 1)

    Additionaly, it also returns the number of trials used to obtain `num_sampled` samples for
    each instance in the batch.

    Example::

       samples, trials = _sample_unique_zipfian(750000, shape=(4, 8192))
       unique(samples[0]) = 8192
       unique(samples[3]) = 8192
       trials[0] = 16435



    Defined in ../src/operator/random/unique_sample_op.cc:L64

    Parameters
    ----------
    range_max : int, required
        The number of possible classes.
    shape : Shape(tuple), optional, default=None
        2-D shape of the output, where shape[0] is the batch size, and shape[1] is the number of candidates to sample for each batch.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _scatter_set_nd(lhs=None, rhs=None, indices=None, shape=_Null, name=None, attr=None, out=None, **kwargs):
    r"""This operator has the same functionality as scatter_nd
    except that it does not reset the elements not indexed by the input
    index `NDArray` in the input data `NDArray`. output should be explicitly
    given and be the same as lhs.

    .. note:: This operator is for internal use only.

    Examples::

      data = [2, 3, 0]
      indices = [[1, 1, 0], [0, 1, 0]]
      out = [[1, 1], [1, 1]]
      _scatter_set_nd(lhs=out, rhs=data, indices=indices, out=out)
      out = [[0, 1], [2, 3]]



    Parameters
    ----------
    lhs : Symbol
        source input
    rhs : Symbol
        value to assign
    indices : Symbol
        indices
    shape : Shape(tuple), required
        Shape of output.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _set_value(src=_Null, name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------
    src : real_t
        Source input to the function.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_mkldnn_conv(name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_conv

    Defined in ../src/operator/subgraph/dnnl/dnnl_conv.cc:L743
    This function support variable length of positional input.

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_mkldnn_fully_connected(name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_fully_connected

    Defined in ../src/operator/subgraph/dnnl/dnnl_fc.cc:L759
    This function support variable length of positional input.

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_mkldnn_selfatt_qk(queries_keys_values=None, heads=_Null, quantized=_Null, enable_float_output=_Null, min_calib_range=_Null, max_calib_range=_Null, name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_selfatt_qk

    Defined in ../src/operator/subgraph/dnnl/dnnl_transformer.cc:L315

    Parameters
    ----------
    queries_keys_values : Symbol
        Interleaved queries, keys and values
    heads : int, required
        Set number of heads.
    quantized : boolean, optional, default=0
        Whether it's a quantized self attention matmul operator.
    enable_float_output : boolean, optional, default=0
        Whether to enable float32 output.
    min_calib_range : float or None, optional, default=None
        The minimum scalar value in the form of float32 obtained through calibration. If present, it will be used to by quantized self-attention op to calculate primitive scale.
    max_calib_range : float or None, optional, default=None
        The maximum scalar value in the form of float32 obtained through calibration. If present, it will be used to by quantized self-attention op to calculate primitive scale.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_mkldnn_selfatt_valatt(attention=None, queries_keys_values=None, heads=_Null, quantized=_Null, enable_float_output=_Null, min_calib_range=_Null, max_calib_range=_Null, name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_selfatt_valatt

    Defined in ../src/operator/subgraph/dnnl/dnnl_transformer.cc:L715

    Parameters
    ----------
    attention : Symbol
        Attention maps
    queries_keys_values : Symbol
        Queries, keys and values interleaved
    heads : int, required
        Set number of heads.
    quantized : boolean, optional, default=0
        Whether it's a quantized self attention matmul operator.
    enable_float_output : boolean, optional, default=0
        Whether to enable float32 output.
    min_calib_range : float or None, optional, default=None
        The minimum scalar value in the form of float32 obtained through calibration. If present, it will be used to by quantized self-attention op to calculate primitive scale.
    max_calib_range : float or None, optional, default=None
        The maximum scalar value in the form of float32 obtained through calibration. If present, it will be used to by quantized self-attention op to calculate primitive scale.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_onednn_batch_dot(name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_batch_dot

    Defined in ../src/operator/subgraph/dnnl/dnnl_batch_dot.cc:L118

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_onednn_conv(name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_conv

    Defined in ../src/operator/subgraph/dnnl/dnnl_conv.cc:L743
    This function support variable length of positional input.

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_onednn_fully_connected(name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_fully_connected

    Defined in ../src/operator/subgraph/dnnl/dnnl_fc.cc:L759
    This function support variable length of positional input.

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_onednn_selfatt_qk(queries_keys_values=None, heads=_Null, quantized=_Null, enable_float_output=_Null, min_calib_range=_Null, max_calib_range=_Null, name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_selfatt_qk

    Defined in ../src/operator/subgraph/dnnl/dnnl_transformer.cc:L315

    Parameters
    ----------
    queries_keys_values : Symbol
        Interleaved queries, keys and values
    heads : int, required
        Set number of heads.
    quantized : boolean, optional, default=0
        Whether it's a quantized self attention matmul operator.
    enable_float_output : boolean, optional, default=0
        Whether to enable float32 output.
    min_calib_range : float or None, optional, default=None
        The minimum scalar value in the form of float32 obtained through calibration. If present, it will be used to by quantized self-attention op to calculate primitive scale.
    max_calib_range : float or None, optional, default=None
        The maximum scalar value in the form of float32 obtained through calibration. If present, it will be used to by quantized self-attention op to calculate primitive scale.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sg_onednn_selfatt_valatt(attention=None, queries_keys_values=None, heads=_Null, quantized=_Null, enable_float_output=_Null, min_calib_range=_Null, max_calib_range=_Null, name=None, attr=None, out=None, **kwargs):
    r"""_sg_onednn_selfatt_valatt

    Defined in ../src/operator/subgraph/dnnl/dnnl_transformer.cc:L715

    Parameters
    ----------
    attention : Symbol
        Attention maps
    queries_keys_values : Symbol
        Queries, keys and values interleaved
    heads : int, required
        Set number of heads.
    quantized : boolean, optional, default=0
        Whether it's a quantized self attention matmul operator.
    enable_float_output : boolean, optional, default=0
        Whether to enable float32 output.
    min_calib_range : float or None, optional, default=None
        The minimum scalar value in the form of float32 obtained through calibration. If present, it will be used to by quantized self-attention op to calculate primitive scale.
    max_calib_range : float or None, optional, default=None
        The maximum scalar value in the form of float32 obtained through calibration. If present, it will be used to by quantized self-attention op to calculate primitive scale.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _shuffle(data=None, name=None, attr=None, out=None, **kwargs):
    r"""Randomly shuffle the elements.

    This shuffles the array along the first axis.
    The order of the elements in each subarray does not change.
    For example, if a 2D array is given, the order of the rows randomly changes,
    but the order of the elements in each row does not change.


    Parameters
    ----------
    data : Symbol
        Data to be shuffled.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _slice_assign(lhs=None, rhs=None, begin=_Null, end=_Null, step=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Assign the rhs to a cropped subset of lhs.

    Requirements
    ------------
    - output should be explicitly given and be the same as lhs.
    - lhs and rhs are of the same data type, and on the same device.


    From:../src/operator/tensor/matrix_op.cc:577

    Parameters
    ----------
    lhs : Symbol
        Source input
    rhs : Symbol
        value to assign
    begin : tuple of <>, required
        starting indices for the slice operation, supports negative indices.
    end : tuple of <>, required
        ending indices for the slice operation, supports negative indices.
    step : tuple of <>, optional, default=[]
        step for the slice operation, supports negative values.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _slice_assign_scalar(data=None, scalar=_Null, begin=_Null, end=_Null, step=_Null, name=None, attr=None, out=None, **kwargs):
    r"""(Assign the scalar to a cropped subset of the input.

    Requirements
    ------------
    - output should be explicitly given and be the same as input
    )

    From:../src/operator/tensor/matrix_op.cc:604

    Parameters
    ----------
    data : Symbol
        Source input
    scalar : double, optional, default=0
        The scalar value for assignment.
    begin : tuple of <>, required
        starting indices for the slice operation, supports negative indices.
    end : tuple of <>, required
        ending indices for the slice operation, supports negative indices.
    step : tuple of <>, optional, default=[]
        step for the slice operation, supports negative values.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _split_v2(data=None, indices=_Null, axis=_Null, squeeze_axis=_Null, sections=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Splits an array along a particular axis into multiple sub-arrays.
    Example::

       x  = [[[ 1.]
              [ 2.]]
             [[ 3.]
              [ 4.]]
             [[ 5.]
              [ 6.]]]
       x.shape = (3, 2, 1)
       y = split_v2(x, axis=1, indices_or_sections=2) // a list of 2 arrays with shape (3, 1, 1)
       y = [[[ 1.]]
            [[ 3.]]
            [[ 5.]]]
           [[[ 2.]]
            [[ 4.]]
            [[ 6.]]]
       y[0].shape = (3, 1, 1)
       z = split_v2(x, axis=0, indices_or_sections=3) // a list of 3 arrays with shape (1, 2, 1)
       z = [[[ 1.]
             [ 2.]]]
           [[[ 3.]
             [ 4.]]]
           [[[ 5.]
             [ 6.]]]
       z[0].shape = (1, 2, 1)
       w = split_v2(x, axis=0, indices_or_sections=(1,)) // a list of 2 arrays with shape [(1, 2, 1), (2, 2, 1)]
       w = [[[ 1.]
             [ 2.]]]
           [[[3.]
             [4.]]
            [[5.]
             [6.]]]
      w[0].shape = (1, 2, 1)
      w[1].shape = (2, 2, 1)

    `squeeze_axis=True` removes the axis with length 1 from the shapes of the output arrays.
    **Note** that setting `squeeze_axis` to ``1`` removes axis with length 1 only
    along the `axis` which it is split.
    Also `squeeze_axis` can be set to true only if ``input.shape[axis] == indices_or_sections``.
    Example::

       z = split_v2(x, axis=0, indices_or_sections=3, squeeze_axis=1) // a list of 3 arrays with shape (2, 1)
       z = [[ 1.]
            [ 2.]]
           [[ 3.]
            [ 4.]]
           [[ 5.]
            [ 6.]]
       z[0].shape = (2, 1)



    Defined in ../src/operator/tensor/matrix_op.cc:L1261

    Parameters
    ----------
    data : Symbol
        The input
    indices : Shape(tuple), required
        Indices of splits. The elements should denote the boundaries of at which split is performed along the `axis`.
    axis : int, optional, default='1'
        Axis along which to split.
    squeeze_axis : boolean, optional, default=0
        If true, Removes the axis with length 1 from the shapes of the output arrays. **Note** that setting `squeeze_axis` to ``true`` removes axis with length 1 only along the `axis` which it is split. Also `squeeze_axis` can be set to ``true`` only if ``input.shape[axis] == num_outputs``.
    sections : int, optional, default='0'
        Number of sections if equally splitted. Default to 0 which means split by indices.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _split_v2_backward(name=None, attr=None, out=None, **kwargs):
    r"""

    Parameters
    ----------


    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _square_sum(data=None, axis=_Null, keepdims=_Null, exclude=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Computes the square sum of array elements over a given axis
    for row-sparse matrix. This is a temporary solution for fusing ops square and
    sum together for row-sparse matrix to save memory for storing gradients.
    It will become deprecated once the functionality of fusing operators is finished
    in the future.

    Example::

      dns = mx.nd.array([[0, 0], [1, 2], [0, 0], [3, 4], [0, 0]])
      rsp = dns.tostype('row_sparse')
      sum = mx.nd._internal._square_sum(rsp, axis=1)
      sum = [0, 5, 0, 25, 0]


    Defined in ../src/operator/tensor/square_sum.cc:L64

    Parameters
    ----------
    data : Symbol
        The input
    axis : Shape or None, optional, default=None
        The axis or axes along which to perform the reduction.

          The default, `axis=()`, will compute over all elements into a
          scalar array with shape `(1,)`.

          If `axis` is int, a reduction is performed on a particular axis.

          If `axis` is a tuple of ints, a reduction is performed on all the axes
          specified in the tuple.

          If `exclude` is true, reduction will be performed on the axes that are
          NOT in axis instead.

          Negative values means indexing from right to left.
    keepdims : boolean, optional, default=0
        If this is set to `True`, the reduced axes are left in the result as dimension with size one.
    exclude : boolean, optional, default=0
        Whether to perform reduction on axis that are NOT in axis instead.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _sub(lhs=None, rhs=None, name=None, attr=None, out=None, **kwargs):
    r"""Subtracts arguments element-wise.

    The storage type of ``elemwise_sub`` output depends on storage types of inputs

       - elemwise_sub(row_sparse, row_sparse) = row_sparse
       - elemwise_sub(csr, csr) = csr
       - elemwise_sub(default, csr) = default
       - elemwise_sub(csr, default) = default
       - elemwise_sub(default, rsp) = default
       - elemwise_sub(rsp, default) = default
       - otherwise, ``elemwise_sub`` generates output with default storage



    Parameters
    ----------
    lhs : Symbol
        first input
    rhs : Symbol
        second input

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _unravel_index(data=None, shape=_Null, name=None, attr=None, out=None, **kwargs):
    r"""Converts an array of flat indices into a batch of index arrays. The operator follows numpy conventions so a single multi index is given by a column of the output matrix. The leading dimension may be left unspecified by using -1 as placeholder.  

    Examples::

       A = [22,41,37]
       unravel_index(A, shape=(7,6)) = [[3,6,6],
                                        [4,5,1]]
       unravel_index(A, shape=(-1,6)) = [[3,6,6],
                                         [4,5,1]]

       B = [[22,41,37],[10,11,15]]
       unravel_index(B, shape=(7,6)) = [[[3,6,6],[1,1,2]],
                                        [[4,5,1],[4,5,3]]]
       unravel_index(B, shape=(-1,6)) = [[[3,6,6],[1,1,2]],
                                         [[4,5,1],[4,5,3]]]



    Defined in ../src/operator/tensor/ravel.cc:L82

    Parameters
    ----------
    data : Symbol
        Array of flat indices
    shape : Shape(tuple), optional, default=None
        Shape of the array into which the multi-indices apply.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _while_loop(*data, **kwargs):
    r"""Run a while loop over with user-defined condition and computation

    From:../src/operator/control_flow.cc:1135
    This function support variable length of positional input.

    Parameters
    ----------
    cond : Symbol
        Input graph for the loop condition.
    func : Symbol
        Input graph for the loop body.
    data : Symbol[]
        The input arrays that include data arrays and states.
    num_outputs : int, required
        The number of outputs of the subgraph.
    num_out_data : int, required
        The number of outputs from the function body.
    max_iterations : int, required
        Maximum number of iterations.
    cond_input_locs : tuple of <long>, required
        The locations of cond's inputs in the given inputs.
    func_input_locs : tuple of <long>, required
        The locations of func's inputs in the given inputs.
    func_var_locs : tuple of <long>, required
        The locations of loop_vars among func's inputs.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _zeros(shape=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""fill target with zeros

    Parameters
    ----------
    shape : Shape(tuple), optional, default=[]
        The shape of the output
    ctx : string, optional, default=''
        Context of output, in format [cpu|gpu|cpu_pinned](n).Only used for imperative calls.
    dtype : {'None', 'bfloat16', 'bool', 'float16', 'float32', 'float64', 'int16', 'int32', 'int64', 'int8', 'uint16', 'uint32', 'uint64', 'uint8'},optional, default='None'
        Target data type.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

def _zeros_without_dtype(shape=_Null, ctx=_Null, dtype=_Null, name=None, attr=None, out=None, **kwargs):
    r"""fill target with zeros without default dtype

    Parameters
    ----------
    shape : Shape(tuple), optional, default=None
        The shape of the output
    ctx : string, optional, default=''
        Context of output, in format [cpu|gpu|cpu_pinned](n).Only used for imperative calls.
    dtype : int, optional, default='-1'
        Target data type.

    name : string, optional.
        Name of the resulting symbol.

    Returns
    -------
    Symbol
        The result symbol.
    """
    return (0,)

__all__ = ['_CachedOp', '_CachedOpThreadSafe', '_CrossDeviceCopy', '_CustomFunction', '_Div', '_DivScalar', '_Equal', '_EqualScalar', '_Greater', '_GreaterEqualScalar', '_GreaterScalar', '_Greater_Equal', '_Hypot', '_HypotScalar', '_Lesser', '_LesserEqualScalar', '_LesserScalar', '_Lesser_Equal', '_LogicalAndScalar', '_LogicalOrScalar', '_LogicalXorScalar', '_Logical_And', '_Logical_Or', '_Logical_Xor', '_Maximum', '_MaximumScalar', '_Minimum', '_MinimumScalar', '_Minus', '_MinusScalar', '_Mod', '_ModScalar', '_Mul', '_MulScalar', '_NDArray', '_Native', '_NoGradient', '_NotEqualScalar', '_Not_Equal', '_Plus', '_PlusScalar', '_Power', '_PowerScalar', '_RDivScalar', '_RMinusScalar', '_RModScalar', '_RPowerScalar', '_adabelief_update', '_adamw_update', '_add', '_arange', '_backward_Activation', '_backward_BatchNorm', '_backward_BilinearSampler', '_backward_CachedOp', '_backward_Concat', '_backward_Convolution', '_backward_Correlation', '_backward_Crop', '_backward_Custom', '_backward_CustomFunction', '_backward_Deconvolution', '_backward_Dropout', '_backward_Embedding', '_backward_FullyConnected', '_backward_GridGenerator', '_backward_GroupNorm', '_backward_IdentityAttachKLSparseReg', '_backward_L2Normalization', '_backward_LRN', '_backward_LayerNorm', '_backward_LeakyReLU', '_backward_MakeLoss', '_backward_Pad', '_backward_Pooling', '_backward_RNN', '_backward_ROIAlign', '_backward_ROIPooling', '_backward_RROIAlign', '_backward_SVMOutput', '_backward_SequenceLast', '_backward_SequenceMask', '_backward_SequenceReverse', '_backward_SliceChannel', '_backward_SoftmaxActivation', '_backward_SoftmaxOutput', '_backward_SpatialTransformer', '_backward_SwapAxis', '_backward_UpSampling', '_backward__CrossDeviceCopy', '_backward__NDArray', '_backward__Native', '_backward__contrib_DeformablePSROIPooling', '_backward__contrib_MultiBoxDetection', '_backward__contrib_MultiBoxPrior', '_backward__contrib_MultiBoxTarget', '_backward__contrib_MultiProposal', '_backward__contrib_PSROIPooling', '_backward__contrib_Proposal', '_backward__contrib_SyncBatchNorm', '_backward__contrib_count_sketch', '_backward__contrib_fft', '_backward__npx_deformable_convolution', '_backward__npx_modulated_deformable_convolution', '_backward_abs', '_backward_add', '_backward_amp_cast', '_backward_amp_multicast', '_backward_arccos', '_backward_arccosh', '_backward_arcsin', '_backward_arcsinh', '_backward_arctan', '_backward_arctanh', '_backward_backward_FullyConnected', '_backward_broadcast_add', '_backward_broadcast_div', '_backward_broadcast_exponential', '_backward_broadcast_gumbel', '_backward_broadcast_hypot', '_backward_broadcast_logistic', '_backward_broadcast_maximum', '_backward_broadcast_minimum', '_backward_broadcast_mod', '_backward_broadcast_mul', '_backward_broadcast_normal', '_backward_broadcast_pareto', '_backward_broadcast_power', '_backward_broadcast_rayleigh', '_backward_broadcast_sub', '_backward_broadcast_weibull', '_backward_cast', '_backward_cbrt', '_backward_clip', '_backward_col2im', '_backward_cond', '_backward_contrib_AdaptiveAvgPooling2D', '_backward_contrib_BatchNormWithReLU', '_backward_contrib_BilinearResize2D', '_backward_contrib_bipartite_matching', '_backward_contrib_boolean_mask', '_backward_contrib_box_iou', '_backward_contrib_box_nms', '_backward_contrib_dynamic_reshape', '_backward_copy', '_backward_cos', '_backward_cosh', '_backward_ctc_loss', '_backward_degrees', '_backward_diag', '_backward_digamma', '_backward_div', '_backward_div_scalar', '_backward_dot', '_backward_erf', '_backward_erfinv', '_backward_expm1', '_backward_foreach', '_backward_gamma', '_backward_gamma_sample', '_backward_gammaln', '_backward_gather_nd', '_backward_hard_sigmoid', '_backward_hypot', '_backward_hypot_scalar', '_backward_im2col', '_backward_image_crop', '_backward_image_normalize', '_backward_index_add_val', '_backward_index_update_a', '_backward_index_update_val', '_backward_instance_norm', '_backward_interleaved_matmul_encdec_qk', '_backward_interleaved_matmul_encdec_valatt', '_backward_interleaved_matmul_selfatt_qk', '_backward_interleaved_matmul_selfatt_valatt', '_backward_linalg_det', '_backward_linalg_extractdiag', '_backward_linalg_extracttrian', '_backward_linalg_gelqf', '_backward_linalg_gemm', '_backward_linalg_gemm2', '_backward_linalg_inverse', '_backward_linalg_makediag', '_backward_linalg_maketrian', '_backward_linalg_potrf', '_backward_linalg_potri', '_backward_linalg_slogdet', '_backward_linalg_sumlogdiag', '_backward_linalg_syevd', '_backward_linalg_syrk', '_backward_linalg_trmm', '_backward_linalg_trsm', '_backward_linear_reg_out', '_backward_log', '_backward_log10', '_backward_log1p', '_backward_log2', '_backward_log_sigmoid', '_backward_log_softmax', '_backward_logistic_reg_out', '_backward_mae_reg_out', '_backward_masked_log_softmax', '_backward_masked_softmax', '_backward_max', '_backward_maximum', '_backward_maximum_scalar', '_backward_mean', '_backward_min', '_backward_minimum', '_backward_minimum_scalar', '_backward_mish', '_backward_mod', '_backward_mod_scalar', '_backward_moments', '_backward_mul', '_backward_mul_scalar', '_backward_nanprod', '_backward_nansum', '_backward_norm', '_backward_np_advanced_indexing', '_backward_np_advanced_indexing_multiple', '_backward_np_average', '_backward_np_broadcast_to', '_backward_np_column_stack', '_backward_np_concat', '_backward_np_dstack', '_backward_np_hstack', '_backward_np_matmul', '_backward_np_mean', '_backward_np_vstack', '_backward_np_where', '_backward_np_where_lscalar', '_backward_np_where_rscalar', '_backward_npi_arccos', '_backward_npi_arccosh', '_backward_npi_arcsin', '_backward_npi_arcsinh', '_backward_npi_arctan', '_backward_npi_arctan2', '_backward_npi_arctan2_scalar', '_backward_npi_arctanh', '_backward_npi_bitwise_left_shift', '_backward_npi_bitwise_left_shift_scalar', '_backward_npi_bitwise_right_shift', '_backward_npi_bitwise_right_shift_scalar', '_backward_npi_broadcast_add', '_backward_npi_broadcast_div', '_backward_npi_broadcast_mod', '_backward_npi_broadcast_mul', '_backward_npi_broadcast_power', '_backward_npi_broadcast_sub', '_backward_npi_cbrt', '_backward_npi_copysign', '_backward_npi_copysign_scalar', '_backward_npi_cos', '_backward_npi_cosh', '_backward_npi_cross', '_backward_npi_cumsum', '_backward_npi_degrees', '_backward_npi_diag', '_backward_npi_diagflat', '_backward_npi_diagonal', '_backward_npi_diff', '_backward_npi_dot', '_backward_npi_einsum', '_backward_npi_exp', '_backward_npi_expm1', '_backward_npi_flip', '_backward_npi_fmax', '_backward_npi_fmax_scalar', '_backward_npi_fmin', '_backward_npi_fmin_scalar', '_backward_npi_fmod', '_backward_npi_fmod_scalar', '_backward_npi_hypot', '_backward_npi_kron', '_backward_npi_ldexp', '_backward_npi_ldexp_scalar', '_backward_npi_log', '_backward_npi_log10', '_backward_npi_log1p', '_backward_npi_log2', '_backward_npi_logaddexp', '_backward_npi_logaddexp_scalar', '_backward_npi_max', '_backward_npi_min', '_backward_npi_norm', '_backward_npi_pad', '_backward_npi_prod', '_backward_npi_qr', '_backward_npi_radians', '_backward_npi_rarctan2_scalar', '_backward_npi_rbitwise_left_shift_scalar', '_backward_npi_rbitwise_right_shift_scalar', '_backward_npi_rfmod_scalar', '_backward_npi_rldexp_scalar', '_backward_npi_sin', '_backward_npi_sinh', '_backward_npi_solve', '_backward_npi_sqrt', '_backward_npi_sum', '_backward_npi_svd', '_backward_npi_tan', '_backward_npi_tanh', '_backward_npi_tensordot', '_backward_npi_tensordot_int_axes', '_backward_npi_tensorinv', '_backward_npi_tensorsolve', '_backward_npi_trace', '_backward_npx_cond', '_backward_npx_foreach', '_backward_npx_while_loop', '_backward_pdf_dirichlet', '_backward_pdf_exponential', '_backward_pdf_gamma', '_backward_pdf_generalized_negative_binomial', '_backward_pdf_negative_binomial', '_backward_pdf_normal', '_backward_pdf_poisson', '_backward_pdf_uniform', '_backward_pick', '_backward_power', '_backward_power_scalar', '_backward_prod', '_backward_radians', '_backward_random_image_crop', '_backward_random_resized_image_crop', '_backward_rcbrt', '_backward_rdiv_scalar', '_backward_reciprocal', '_backward_relu', '_backward_repeat', '_backward_reshape', '_backward_reverse', '_backward_rmod_scalar', '_backward_rpower_scalar', '_backward_rsqrt', '_backward_sample_categorical', '_backward_sigmoid', '_backward_sin', '_backward_sinh', '_backward_sldwin_atten_context', '_backward_sldwin_atten_score', '_backward_slice', '_backward_slice_axis', '_backward_slice_like', '_backward_smooth_l1', '_backward_softmax', '_backward_softmax_cross_entropy', '_backward_softmin', '_backward_softsign', '_backward_sparse_retain', '_backward_sqrt', '_backward_square', '_backward_square_sum', '_backward_squeeze', '_backward_stack', '_backward_sub', '_backward_sum', '_backward_take', '_backward_tan', '_backward_tanh', '_backward_tile', '_backward_topk', '_backward_tril', '_backward_triu', '_backward_where', '_backward_while_loop', '_broadcast_backward', '_cond', '_copy', '_copyto', '_crop_assign', '_crop_assign_scalar', '_cvcopyMakeBorder', '_cvimdecode', '_cvimread', '_cvimresize', '_div', '_div_scalar', '_equal', '_equal_scalar', '_eye', '_foreach', '_full', '_grad_add', '_greater', '_greater_equal', '_greater_equal_scalar', '_greater_scalar', '_histogram', '_hypot', '_hypot_scalar', '_identity_with_attr_like_rhs', '_imdecode', '_lesser', '_lesser_equal', '_lesser_equal_scalar', '_lesser_scalar', '_linspace', '_logical_and', '_logical_and_scalar', '_logical_or', '_logical_or_scalar', '_logical_xor', '_logical_xor_scalar', '_maximum', '_maximum_scalar', '_minimum', '_minimum_scalar', '_minus', '_minus_scalar', '_mod', '_mod_scalar', '_mp_adabelief_update', '_mp_adamw_update', '_mul', '_mul_scalar', '_multi_adabelief_update', '_multi_adamw_update', '_multi_lamb_update', '_multi_lans_update', '_multi_mp_adabelief_update', '_multi_mp_adamw_update', '_multi_mp_lamb_update', '_multi_mp_lans_update', '_not_equal', '_not_equal_scalar', '_onehot_encode', '_ones', '_plus', '_plus_scalar', '_power', '_power_scalar', '_ravel_multi_index', '_rdiv_scalar', '_rminus_scalar', '_rmod_scalar', '_rnn_param_concat', '_rpower_scalar', '_sample_binomial', '_sample_categorical', '_sample_exponential', '_sample_gamma', '_sample_generalized_negative_binomial', '_sample_multinomial', '_sample_negative_binomial', '_sample_normal', '_sample_poisson', '_sample_uniform', '_sample_unique_zipfian', '_scatter_set_nd', '_set_value', '_sg_mkldnn_conv', '_sg_mkldnn_fully_connected', '_sg_mkldnn_selfatt_qk', '_sg_mkldnn_selfatt_valatt', '_sg_onednn_batch_dot', '_sg_onednn_conv', '_sg_onednn_fully_connected', '_sg_onednn_selfatt_qk', '_sg_onednn_selfatt_valatt', '_shuffle', '_slice_assign', '_slice_assign_scalar', '_split_v2', '_split_v2_backward', '_square_sum', '_sub', '_unravel_index', '_while_loop', '_zeros', '_zeros_without_dtype']