class sftConfig:
    def __init__(
        self,
        MODEL_ID="TheBloke/zephyr-7B-alpha-GPTQ",
        DATA=["bitext/Bitext-customer-support-llm-chatbot-training-dataset", "instruction", "response"],
        CONTEXT_FIELD="",
        BITS=4,
        DISABLE_EXLLAMA=True,
        DEVICE_MAP="auto",
        USE_CACHE=False,
        LORA_R=16,
        LORA_ALPHA=16,
        LORA_DROPOUT=0.05,
        BIAS="none",
        TARGET_MODULES=["q_proj", "v_proj"],
        TASK_TYPE="CAUSAL_LM",
        OUTPUT_DIR="FineTune1",
        BATCH_SIZE=8,
        GRAD_ACCUMULATION_STEPS=1,
        OPTIMIZER="paged_adamw_32bit",
        LR=2e-4,
        LR_SCHEDULER="cosine",
        LOGGING_STEPS=50,
        SAVE_STRATEGY="epoch",
        NUM_TRAIN_EPOCHS=1,
        MAX_STEPS=250,
        FP16=True,
        PUSH_TO_HUB=False,
        DATASET_TEXT_FIELD="text",
        MAX_SEQ_LENGTH=512,
        PACKING=False,
    ):
        self.MODEL_ID = MODEL_ID
        self.DATASET_ID = DATA[0]
        self.CONTEXT_FIELD = CONTEXT_FIELD
        self.INSTRUCTION_FIELD = DATA[1]
        self.TARGET_FIELD = DATA[2]
        self.BITS = BITS
        self.DISABLE_EXLLAMA = DISABLE_EXLLAMA
        self.DEVICE_MAP = DEVICE_MAP
        self.USE_CACHE = USE_CACHE
        self.LORA_R = LORA_R
        self.LORA_ALPHA = LORA_ALPHA
        self.LORA_DROPOUT = LORA_DROPOUT
        self.BIAS = BIAS
        self.TARGET_MODULES = TARGET_MODULES
        self.TASK_TYPE = TASK_TYPE
        self.OUTPUT_DIR = OUTPUT_DIR
        self.BATCH_SIZE = BATCH_SIZE
        self.GRAD_ACCUMULATION_STEPS = GRAD_ACCUMULATION_STEPS
        self.OPTIMIZER = OPTIMIZER
        self.LR = LR
        self.LR_SCHEDULER = LR_SCHEDULER
        self.LOGGING_STEPS = LOGGING_STEPS
        self.SAVE_STRATEGY = SAVE_STRATEGY
        self.NUM_TRAIN_EPOCHS = NUM_TRAIN_EPOCHS
        self.MAX_STEPS = MAX_STEPS
        self.FP16 = FP16
        self.PUSH_TO_HUB = PUSH_TO_HUB
        self.DATASET_TEXT_FIELD = DATASET_TEXT_FIELD
        self.MAX_SEQ_LENGTH = MAX_SEQ_LENGTH
        self.PACKING = PACKING
