import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
import { StackSynthesizer } from './stack-synthesizer';
import { IStackSynthesizer } from './types';
/**
 * Deployment environment for a nested stack
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
export declare class NestedStackSynthesizer extends StackSynthesizer {
    private readonly parentDeployment;
    private stack?;
    constructor(parentDeployment: IStackSynthesizer);
    bind(stack: Stack): void;
    addFileAsset(asset: FileAssetSource): FileAssetLocation;
    addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    synthesize(session: ISynthesisSession): void;
}
