import mpmath

import numpy as np


def q_b(m0, m1, m2, n0, n1, n2):
    """Stretch"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)


    return mpmath.sqrt((m0 - n0)**2 + (m1 - n1)**2 + (m2 - n2)**2)


def dq_b(m0, m1, m2, n0, n1, n2):
    """Stretch, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - n0
    x1 = m1 - n1
    x2 = m2 - n2
    x3 = 1/mpmath.sqrt(x0**2 + x1**2 + x2**2)

    return np.array([x0*x3, x1*x3, x2*x3, -x0*x3, -x1*x3, -x2*x3], dtype=np.float64)


def d2q_b(m0, m1, m2, n0, n1, n2):
    """Stretch, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - n0
    x1 = x0**2
    x2 = m1 - n1
    x3 = x2**2
    x4 = m2 - n2
    x5 = x4**2
    x6 = x1 + x3 + x5
    x7 = 1/mpmath.sqrt(x6)
    x8 = x6**(mpmath.mpf(-3)/mpmath.mpf(2))
    x9 = -x0
    x10 = x8*x9
    x11 = x0*x10 + x7
    x12 = x10*x2
    x13 = x10*x4
    x14 = -x7
    x15 = -x2
    x16 = x10*x15
    x17 = -x4
    x18 = x10*x17
    x19 = x15*x8
    x20 = x0*x19
    x21 = x19*x2 + x7
    x22 = x19*x4
    x23 = x17*x19
    x24 = x17*x8
    x25 = x0*x24
    x26 = x2*x24
    x27 = x24*x4 + x7
    x28 = x0*x8
    x29 = x2*x28
    x30 = x28*x4
    x31 = x2*x4*x8

    return np.array([x11, x12, x13, x14 + x8*x9**2, x16, x18, x20, x21, x22, x16, x14 + x15**2*x8, x23, x25, x26, x27, x18, x23, x14 + x17**2*x8, x1*x8 + x14, x29, x30, x11, x20, x25, x29, x14 + x3*x8, x31, x12, x21, x26, x30, x31, x14 + x5*x8, x13, x22, x27], dtype=np.float64)


def q_a(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = m1 + x2
    x4 = -o2
    x5 = m2 + x4
    x6 = n0 + x0
    x7 = n1 + x2
    x8 = n2 + x4

    return mpmath.acos((x1*x6 + x3*x7 + x5*x8)/(mpmath.sqrt(x1**2 + x3**2 + x5**2)*mpmath.sqrt(x6**2 + x7**2 + x8**2)))


def dq_a(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = m1 + x2
    x4 = -o2
    x5 = m2 + x4
    x6 = x1**2 + x3**2 + x5**2
    x7 = n0 + x0
    x8 = n1 + x2
    x9 = n2 + x4
    x10 = x7**2 + x8**2 + x9**2
    x11 = x1*x7 + x3*x8 + x5*x9
    x12 = 1/mpmath.sqrt(1 - x11**2/(x10*x6))
    x13 = 1/mpmath.sqrt(x6)
    x14 = 1/mpmath.sqrt(x10)
    x15 = x13*x14
    x16 = x11*x14/x6**(mpmath.mpf(3)/mpmath.mpf(2))
    x17 = x11*x13/x10**(mpmath.mpf(3)/mpmath.mpf(2))

    return np.array([-x12*(-x1*x16 + x15*x7), -x12*(x15*x8 - x16*x3), -x12*(x15*x9 - x16*x5), -x12*(x1*x16 + x15*(-m0 - n0 + 2*o0) + x17*x7), -x12*(x15*(-m1 - n1 + 2*o1) + x16*x3 + x17*x8), -x12*(x15*(-m2 - n2 + 2*o2) + x16*x5 + x17*x9), -x12*(x1*x15 - x17*x7), -x12*(x15*x3 - x17*x8), -x12*(x15*x5 - x17*x9)], dtype=np.float64)


def d2q_a(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = n0 + x0
    x3 = x1*x2
    x4 = -o1
    x5 = m1 + x4
    x6 = n1 + x4
    x7 = x5*x6
    x8 = -o2
    x9 = m2 + x8
    x10 = n2 + x8
    x11 = x10*x9
    x12 = x11 + x3 + x7
    x13 = x12**2
    x14 = x1**2
    x15 = x5**2
    x16 = x9**2
    x17 = x14 + x15 + x16
    x18 = x17**(-1)
    x19 = x2**2
    x20 = x6**2
    x21 = x10**2
    x22 = x19 + x20 + x21
    x23 = x22**(-1)
    x24 = x18*x23
    x25 = -x13*x24 + 1
    x26 = 1/mpmath.sqrt(x25)
    x27 = -x1
    x28 = 1/mpmath.sqrt(x22)
    x29 = x17**(mpmath.mpf(-3)/mpmath.mpf(2))
    x30 = x28*x29
    x31 = x2*x30
    x32 = x12*x30
    x33 = -x32
    x34 = x12*x27
    x35 = -3*o0
    x36 = 3*m0 + x35
    x37 = x28/x17**(mpmath.mpf(5)/mpmath.mpf(2))
    x38 = -x36*x37
    x39 = 1/mpmath.sqrt(x17)
    x40 = x28*x39
    x41 = x2*x40 + x27*x32
    x42 = x25**(mpmath.mpf(-3)/mpmath.mpf(2))
    x43 = 2*n0
    x44 = -2*o0
    x45 = x43 + x44
    x46 = (mpmath.mpf(1)/mpmath.mpf(2))*x45
    x47 = x12*x24
    x48 = 2*m0
    x49 = x44 + x48
    x50 = (mpmath.mpf(1)/mpmath.mpf(2))*x13
    x51 = x23*x50/x17**2
    x52 = x42*(x46*x47 - x49*x51)
    x53 = -x5
    x54 = x12*x38
    x55 = x27*x30
    x56 = x31*x53 + x55*x6
    x57 = x32*x53 + x40*x6
    x58 = -x9
    x59 = x10*x55 + x31*x58
    x60 = x10*x40 + x32*x58
    x61 = -m0 - n0 - x44
    x62 = x22**(mpmath.mpf(-3)/mpmath.mpf(2))
    x63 = x39*x62
    x64 = x12*x63
    x65 = x1*x32 + x2*x64 + x40*x61
    x66 = x29*x62
    x67 = x34*x66
    x68 = -x40
    x69 = x32 + x68
    x70 = x19*x63 + x2*x67 + x3*x30 + x55*x61 + x69
    x71 = -2*o1
    x72 = -m1 - n1 - x71
    x73 = x2*x63
    x74 = x6*x73
    x75 = x31*x5 + x55*x72 + x6*x67 + x74
    x76 = x32*x5 + x40*x72 + x6*x64
    x77 = -2*o2
    x78 = -m2 - n2 - x77
    x79 = x10*x73
    x80 = x10*x67 + x31*x9 + x55*x78 + x79
    x81 = x10*x64 + x32*x9 + x40*x78
    x82 = -x2
    x83 = x26*(x1*x55 + x40 + x67*x82 + x73*x82)
    x84 = x1*x40 + x64*x82
    x85 = -x6
    x86 = x26*(x5*x55 + x67*x85 + x73*x85)
    x87 = x40*x5 + x64*x85
    x88 = -x10
    x89 = x26*(x55*x9 + x67*x88 + x73*x88)
    x90 = x40*x9 + x64*x88
    x91 = -3*o1
    x92 = 3*m1 + x91
    x93 = -x37*x92
    x94 = 2*n1
    x95 = x71 + x94
    x96 = (mpmath.mpf(1)/mpmath.mpf(2))*x47
    x97 = 2*m1
    x98 = x71 + x97
    x99 = x42*(-x51*x98 + x95*x96)
    x100 = x30*x6
    x101 = x12*x93
    x102 = x30*x53
    x103 = x10*x102 + x100*x58
    x104 = x12*x53
    x105 = x104*x66
    x106 = x1*x100 + x102*x61 + x105*x2 + x74
    x107 = x102*x72 + x105*x6 + x20*x63 + x30*x7 + x69
    x108 = x6*x63
    x109 = x10*x108
    x110 = x10*x105 + x100*x9 + x102*x78 + x109
    x111 = x26*(x1*x102 + x105*x82 + x108*x82)
    x112 = x26*(x102*x5 + x105*x85 + x108*x85 + x40)
    x113 = x26*(x102*x9 + x105*x88 + x108*x88)
    x114 = -3*o2
    x115 = 3*m2 + x114
    x116 = -x115*x37
    x117 = 2*n2
    x118 = x117 + x77
    x119 = 2*m2
    x120 = x119 + x77
    x121 = x42*(x118*x96 - x120*x51)
    x122 = x10*x30
    x123 = x116*x12
    x124 = x30*x58
    x125 = x12*x58
    x126 = x125*x66
    x127 = x1*x122 + x124*x61 + x126*x2 + x79
    x128 = x109 + x122*x5 + x124*x72 + x126*x6
    x129 = x10*x126 + x11*x30 + x124*x78 + x21*x63 + x69
    x130 = x10*x63
    x131 = x26*(x1*x124 + x126*x82 + x130*x82)
    x132 = x26*(x124*x5 + x126*x85 + x130*x85)
    x133 = x26*(x124*x9 + x126*x88 + x130*x88 + x40)
    x134 = x18/x22**2
    x135 = x42*(x13*x134*x46 + x49*x51 + x96*(4*o0 - x43 - x48))
    x136 = x36*x37
    x137 = x1*x30
    x138 = 2*x61
    x139 = x12*x136
    x140 = x12*x2
    x141 = 3*n0 + x35
    x142 = x39/x22**(mpmath.mpf(5)/mpmath.mpf(2))
    x143 = x141*x142
    x144 = x12*x66
    x145 = 2*x144
    x146 = -x64
    x147 = x146 + x33 + 2*x40
    x148 = x12*x6
    x149 = x30*x61
    x150 = x1*x66
    x151 = x140*x66
    x152 = x108*x61 + x137*x72 + x148*x150 + x149*x5 + x151*x5 + x72*x73
    x153 = x10*x12
    x154 = x130*x61 + x137*x78 + x149*x9 + x150*x153 + x151*x9 + x73*x78
    x155 = x12*x82
    x156 = x61*x63
    x157 = x64 + x68
    x158 = x14*x30 + x150*x155 + x156*x82 + x157 + x3*x63
    x159 = x12*x85
    x160 = x137*x5
    x161 = x150*x159 + x156*x85 + x160 + x5*x73
    x162 = x12*x88
    x163 = x137*x9
    x164 = x150*x162 + x156*x88 + x163 + x73*x9
    x165 = x37*x92
    x166 = x134*x50
    x167 = x42*(x166*x95 + x51*x98 + x96*(4*o1 - x94 - x97))
    x168 = x12*x165
    x169 = 3*n1 + x91
    x170 = x142*x169
    x171 = x30*x5
    x172 = 2*x72
    x173 = x30*x9
    x174 = x5*x66
    x175 = x66*x9
    x176 = x108*x78 + x130*x72 + x148*x175 + x153*x174 + x171*x78 + x173*x72
    x177 = x63*x72
    x178 = x1*x108 + x155*x174 + x160 + x177*x82
    x179 = x15*x30 + x157 + x159*x174 + x177*x85 + x63*x7
    x180 = x171*x9
    x181 = x5*x88
    x182 = x108*x9 + x144*x181 + x177*x88 + x180
    x183 = x115*x37
    x184 = x42*(x118*x166 + x120*x51 + x96*(4*o2 - x117 - x119))
    x185 = x12*x183
    x186 = 3*n2 + x114
    x187 = x142*x186
    x188 = 2*x78
    x189 = x63*x78
    x190 = x1*x130 + x155*x175 + x163 + x189*x82
    x191 = x85*x9
    x192 = x130*x5 + x144*x191 + x180 + x189*x85
    x193 = x11*x63 + x157 + x16*x30 + x162*x175 + x189*x88
    x194 = x42*(-x166*x45 + x49*x96)
    x195 = -x141*x142
    x196 = x1*x63
    x197 = x63*x82
    x198 = x196*x85 + x197*x5
    x199 = x196*x88 + x197*x9
    x200 = x42*(-x166*x95 + x96*x98)
    x201 = -x142*x169
    x202 = 2*x63
    x203 = x181*x63 + x191*x63
    x204 = x42*(-x118*x166 + x120*x96)
    x205 = -x142*x186

    return np.array([-x26*(2*x27*x31 + x33 + x34*x38) - x41*x52, -x26*(x53*x54 + x56) - x52*x57, -x26*(x54*x58 + x59) - x52*x60, -x26*(x1*x54 + x70) - x52*x65, -x26*(x5*x54 + x75) - x52*x76, -x26*(x54*x9 + x80) - x52*x81, -x52*x84 - x83, -x52*x87 - x86, -x52*x90 - x89, -x26*(x34*x93 + x56) - x41*x99, -x26*(2*x100*x53 + x101*x53 + x33) - x57*x99, -x26*(x101*x58 + x103) - x60*x99, -x26*(x1*x101 + x106) - x65*x99, -x26*(x101*x5 + x107) - x76*x99, -x26*(x101*x9 + x110) - x81*x99, -x111 - x84*x99, -x112 - x87*x99, -x113 - x90*x99, -x121*x41 - x26*(x116*x34 + x59), -x121*x57 - x26*(x103 + x104*x116), -x121*x60 - x26*(2*x122*x58 + x123*x58 + x33), -x121*x65 - x26*(x1*x123 + x127), -x121*x76 - x26*(x123*x5 + x128), -x121*x81 - x26*(x123*x9 + x129), -x121*x84 - x131, -x121*x87 - x132, -x121*x90 - x133, -x135*x41 - x26*(x136*x34 + x70), -x135*x57 - x26*(x104*x136 + x106), -x135*x60 - x26*(x125*x136 + x127), -x135*x65 - x26*(x1*x139 + x137*x138 + x138*x73 + x140*x143 + x145*x3 + x147), -x135*x76 - x26*(x139*x5 + x143*x148 + x152), -x135*x81 - x26*(x139*x9 + x143*x153 + x154), -x135*x84 - x26*(x143*x155 + x158), -x135*x87 - x26*(x143*x159 + x161), -x135*x90 - x26*(x143*x162 + x164), -x167*x41 - x26*(x165*x34 + x75), -x167*x57 - x26*(x104*x165 + x107), -x167*x60 - x26*(x125*x165 + x128), -x167*x65 - x26*(x1*x168 + x140*x170 + x152), -x167*x76 - x26*(x108*x172 + x145*x7 + x147 + x148*x170 + x168*x5 + x171*x172), -x167*x81 - x26*(x153*x170 + x168*x9 + x176), -x167*x84 - x26*(x155*x170 + x178), -x167*x87 - x26*(x159*x170 + x179), -x167*x90 - x26*(x162*x170 + x182), -x184*x41 - x26*(x183*x34 + x80), -x184*x57 - x26*(x104*x183 + x110), -x184*x60 - x26*(x125*x183 + x129), -x184*x65 - x26*(x1*x185 + x140*x187 + x154), -x184*x76 - x26*(x148*x187 + x176 + x185*x5), -x184*x81 - x26*(x11*x145 + x130*x188 + x147 + x153*x187 + x173*x188 + x185*x9), -x184*x84 - x26*(x155*x187 + x190), -x184*x87 - x26*(x159*x187 + x192), -x184*x90 - x26*(x162*x187 + x193), -x194*x41 - x83, -x111 - x194*x57, -x131 - x194*x60, -x194*x65 - x26*(x140*x195 + x158), -x194*x76 - x26*(x148*x195 + x178), -x194*x81 - x26*(x153*x195 + x190), -x194*x84 - x26*(x146 + x155*x195 + 2*x196*x82), -x194*x87 - x26*(x159*x195 + x198), -x194*x90 - x26*(x162*x195 + x199), -x200*x41 - x86, -x112 - x200*x57, -x132 - x200*x60, -x200*x65 - x26*(x140*x201 + x161), -x200*x76 - x26*(x148*x201 + x179), -x200*x81 - x26*(x153*x201 + x192), -x200*x84 - x26*(x155*x201 + x198), -x200*x87 - x26*(x146 + x159*x201 + x202*x5*x85), -x200*x90 - x26*(x162*x201 + x203), -x204*x41 - x89, -x113 - x204*x57, -x133 - x204*x60, -x204*x65 - x26*(x140*x205 + x164), -x204*x76 - x26*(x148*x205 + x182), -x204*x81 - x26*(x153*x205 + x193), -x204*x84 - x26*(x155*x205 + x199), -x204*x87 - x26*(x159*x205 + x203), -x204*x90 - x26*(x146 + x162*x205 + x202*x88*x9)], dtype=np.float64)


def q_a2(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend2"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = n1 + x2
    x4 = m1 + x2
    x5 = n0 + x0
    x6 = -o2
    x7 = n2 + x6
    x8 = m2 + x6

    return mpmath.atan2(mpmath.sqrt((x1*x3 - x4*x5)**2 + (-x1*x7 + x5*x8)**2 + (-x3*x8 + x4*x7)**2), x1*x5 + x3*x4 + x7*x8)


def dq_a2(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend2, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o0
    x1 = n0 + x0
    x2 = m0 + x0
    x3 = -o1
    x4 = n1 + x3
    x5 = m1 + x3
    x6 = -x1*x5 + x2*x4
    x7 = -o2
    x8 = n2 + x7
    x9 = m2 + x7
    x10 = x1*x9 - x2*x8
    x11 = -x4*x9 + x5*x8
    x12 = x10**2 + x11**2 + x6**2
    x13 = mpmath.sqrt(x12)
    x14 = x1*x2 + x4*x5 + x8*x9
    x15 = (x12 + x14**2)**(-1)
    x16 = x13*x15
    x17 = 2*n1
    x18 = -2*o1
    x19 = x17 + x18
    x20 = (mpmath.mpf(1)/mpmath.mpf(2))*x6
    x21 = 2*n2
    x22 = -2*o2
    x23 = x21 + x22
    x24 = (mpmath.mpf(1)/mpmath.mpf(2))*x10
    x25 = x13**(-1)
    x26 = 2*n0
    x27 = -2*o0
    x28 = x26 + x27
    x29 = (mpmath.mpf(1)/mpmath.mpf(2))*x11
    x30 = 2*m1
    x31 = -x17 + x30
    x32 = 2*m2
    x33 = -x21 + x32
    x34 = x14*x15*x25
    x35 = 2*m0
    x36 = -x26 + x35
    x37 = x18 + x30
    x38 = x22 + x32
    x39 = x27 + x35

    return np.array([-x1*x16 + x14*x15*x25*(x19*x20 - x23*x24), x14*x15*x25*(-x20*x28 + x23*x29) - x16*x4, x14*x15*x25*(-x19*x29 + x24*x28) - x16*x8, -x16*(-m0 - n0 - x27) + x34*(x20*x31 - x24*x33), -x16*(-m1 - n1 - x18) + x34*(-x20*x36 + x29*x33), -x16*(-m2 - n2 - x22) + x34*(x24*x36 - x29*x31), x14*x15*x25*(-x20*x37 + x24*x38) - x16*x2, x14*x15*x25*(x20*x39 - x29*x38) - x16*x5, x14*x15*x25*(-x24*x39 + x29*x37) - x16*x9], dtype=np.float64)


def d2q_a2(m0, m1, m2, o0, o1, o2, n0, n1, n2):
    """Bend2, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -o1
    x1 = n1 + x0
    x2 = -o2
    x3 = n2 + x2
    x4 = -x3
    x5 = -o0
    x6 = m0 + x5
    x7 = n0 + x5
    x8 = m1 + x0
    x9 = m2 + x2
    x10 = x1*x8 + x3*x9 + x6*x7
    x11 = x1*x6
    x12 = -x7
    x13 = x12*x8
    x14 = x11 + x13
    x15 = x4*x6
    x16 = x7*x9
    x17 = x15 + x16
    x18 = x3*x8
    x19 = -x1
    x20 = x19*x9
    x21 = x18 + x20
    x22 = x14**2 + x17**2 + x21**2
    x23 = x10**2 + x22
    x24 = x23**(-1)
    x25 = mpmath.sqrt(x22)
    x26 = x25**(-1)
    x27 = x24*x26
    x28 = x10*x27
    x29 = 2*n1
    x30 = -2*o1
    x31 = x29 + x30
    x32 = x14*x31
    x33 = 2*n2
    x34 = -2*o2
    x35 = x33 + x34
    x36 = -x17*x35
    x37 = 2*n0
    x38 = -2*o0
    x39 = x37 + x38
    x40 = -x10*x39 - x32 - x36
    x41 = x23**(-2)
    x42 = x25*x41
    x43 = x40*x42
    x44 = (mpmath.mpf(1)/mpmath.mpf(2))*x32 + (mpmath.mpf(1)/mpmath.mpf(2))*x36
    x45 = x10*x44
    x46 = x24/x22**(mpmath.mpf(3)/mpmath.mpf(2))
    x47 = -x44*x46
    x48 = x26*x41
    x49 = x40*x48
    x50 = x1*x12*x28
    x51 = -x14*x39
    x52 = x21*x35
    x53 = (mpmath.mpf(1)/mpmath.mpf(2))*x51 + (mpmath.mpf(1)/mpmath.mpf(2))*x52
    x54 = x27*x7
    x55 = x53*x54
    x56 = x27*x44
    x57 = x1*x56
    x58 = x10*x53
    x59 = x28*x4*x7
    x60 = x17*x39
    x61 = -x21*x31
    x62 = (mpmath.mpf(1)/mpmath.mpf(2))*x60 + (mpmath.mpf(1)/mpmath.mpf(2))*x61
    x63 = x54*x62
    x64 = x3*x56
    x65 = x10*x62
    x66 = 2*m1
    x67 = -x29 + x66
    x68 = x14*x67
    x69 = 2*m2
    x70 = -x33 + x69
    x71 = -x17*x70
    x72 = (mpmath.mpf(1)/mpmath.mpf(2))*x68 + (mpmath.mpf(1)/mpmath.mpf(2))*x71
    x73 = x54*x72
    x74 = -m0 - n0 - x38
    x75 = x56*x74
    x76 = x10*x72
    x77 = x24*x25
    x78 = m1 - n1
    x79 = m2 - n2
    x80 = -x79
    x81 = x28*(x1*x78 + x4*x80) + x77
    x82 = 2*m0
    x83 = -x37 + x82
    x84 = -x14*x83
    x85 = x21*x70
    x86 = (mpmath.mpf(1)/mpmath.mpf(2))*x84 + (mpmath.mpf(1)/mpmath.mpf(2))*x85
    x87 = x54*x86
    x88 = m0 - n0
    x89 = -x88
    x90 = x28*(x1*x89 - x14)
    x91 = -m1 - n1 - x30
    x92 = x56*x91
    x93 = x10*x86
    x94 = x28*(x17 + x4*x88)
    x95 = x17*x83
    x96 = -x21*x67
    x97 = (mpmath.mpf(1)/mpmath.mpf(2))*x95 + (mpmath.mpf(1)/mpmath.mpf(2))*x96
    x98 = x54*x97
    x99 = -m2 - n2 - x34
    x100 = x56*x99
    x101 = x10*x97
    x102 = x30 + x66
    x103 = -x102*x14
    x104 = x34 + x69
    x105 = x104*x17
    x106 = (mpmath.mpf(1)/mpmath.mpf(2))*x103 + (mpmath.mpf(1)/mpmath.mpf(2))*x105
    x107 = x106*x54
    x108 = x56*x6
    x109 = x10*x106
    x110 = -x77
    x111 = -x8
    x112 = x110 + x28*(x1*x111 + x4*x9)
    x113 = x28*(2*x11 + x13)
    x114 = x38 + x82
    x115 = x114*x14
    x116 = -x104*x21
    x117 = (mpmath.mpf(1)/mpmath.mpf(2))*x115 + (mpmath.mpf(1)/mpmath.mpf(2))*x116
    x118 = x117*x54
    x119 = x56*x8
    x120 = x10*x117
    x121 = -x114*x17
    x122 = x102*x21
    x123 = (mpmath.mpf(1)/mpmath.mpf(2))*x121 + (mpmath.mpf(1)/mpmath.mpf(2))*x122
    x124 = x123*x54
    x125 = -x6
    x126 = x28*(x125*x4 - x17)
    x127 = x56*x9
    x128 = x10*x123
    x129 = -x10*x31 - x51 - x52
    x130 = x129*x42
    x131 = -x46*x53
    x132 = x129*x48
    x133 = x19*x28*x3
    x134 = x1*x27
    x135 = x134*x62
    x136 = x27*x53
    x137 = x136*x3
    x138 = x28*(x12*x78 + x14)
    x139 = x134*x72
    x140 = x136*x74
    x141 = x134*x86
    x142 = x136*x91
    x143 = x28*(x12*x89 + x3*x79) + x77
    x144 = x134*x97
    x145 = -x78
    x146 = x28*(x145*x3 - x21)
    x147 = x136*x99
    x148 = x106*x134
    x149 = x28*(x111*x12 - x14)
    x150 = x136*x6
    x151 = x117*x134
    x152 = x136*x8
    x153 = -x9
    x154 = x110 + x28*(x12*x6 + x153*x3)
    x155 = x28*(2*x18 + x20)
    x156 = x123*x134
    x157 = x136*x9
    x158 = -x10*x35 - x60 - x61
    x159 = x158*x42
    x160 = -x46*x62
    x161 = x158*x48
    x162 = x27*x3
    x163 = x162*x72
    x164 = x28*(-x17 + x7*x80)
    x165 = x27*x62
    x166 = x165*x74
    x167 = x28*(x19*x79 + x21)
    x168 = x162*x86
    x169 = x165*x91
    x170 = x162*x97
    x171 = x165*x99
    x172 = x28*(x145*x19 + x7*x88) + x77
    x173 = x28*(x15 + 2*x16)
    x174 = x106*x162
    x175 = x165*x6
    x176 = x117*x162
    x177 = x28*(x153*x19 - x21)
    x178 = x165*x8
    x179 = x123*x162
    x180 = x165*x9
    x181 = x110 + x28*(x125*x7 + x19*x8)
    x182 = -x10*(4*o0 - x37 - x82) - x68 - x71
    x183 = x182*x42
    x184 = -x46*x72
    x185 = x182*x48
    x186 = -2*x77
    x187 = x28*x78*x89
    x188 = x27*x74
    x189 = x188*x86
    x190 = x27*x72
    x191 = x190*x91
    x192 = x28*x80*x88
    x193 = x188*x97
    x194 = x190*x99
    x195 = x106*x188
    x196 = x190*x6
    x197 = x28*(x111*x78 + x80*x9) + x77
    x198 = x28*(-x14 + x6*x78)
    x199 = x190*x8
    x200 = x117*x188
    x201 = x28*(x125*x80 + x17)
    x202 = x190*x9
    x203 = x123*x188
    x204 = -x10*(4*o1 - x29 - x66) - x84 - x85
    x205 = x204*x42
    x206 = -x46*x86
    x207 = x204*x48
    x208 = x145*x28*x79
    x209 = x27*x91
    x210 = x209*x97
    x211 = x27*x86
    x212 = x211*x99
    x213 = x28*(x111*x89 + x14)
    x214 = x211*x6
    x215 = x106*x209
    x216 = x117*x209
    x217 = x211*x8
    x218 = x28*(x153*x79 + x6*x89) + x77
    x219 = x28*(-x21 + x79*x8)
    x220 = x211*x9
    x221 = x123*x209
    x222 = -x10*(4*o2 - x33 - x69) - x95 - x96
    x223 = x222*x42
    x224 = -x46*x97
    x225 = x222*x48
    x226 = x28*(-x17 + x88*x9)
    x227 = x27*x97
    x228 = x227*x6
    x229 = x27*x99
    x230 = x106*x229
    x231 = x28*(x145*x153 + x21)
    x232 = x227*x8
    x233 = x117*x229
    x234 = x123*x229
    x235 = x227*x9
    x236 = x28*(x125*x88 + x145*x8) + x77
    x237 = -x10*x114 - x103 - x105
    x238 = x237*x42
    x239 = -x106*x46
    x240 = x237*x48
    x241 = x111*x28*x6
    x242 = x27*x6
    x243 = x117*x242
    x244 = x106*x27
    x245 = x244*x8
    x246 = x125*x28*x9
    x247 = x123*x242
    x248 = x244*x9
    x249 = -x10*x102 - x115 - x116
    x250 = x249*x42
    x251 = -x117*x46
    x252 = x249*x48
    x253 = x153*x28*x8
    x254 = x123*x27*x8
    x255 = x117*x27*x9
    x256 = -x10*x104 - x121 - x122
    x257 = x256*x42
    x258 = -x123*x46
    x259 = x256*x48

    return np.array([x28*(x1**2 + x4**2) - x43*x7 + x45*x47 + x45*x49, -x1*x43 + x47*x58 + x49*x58 + x50 + x55 - x57, -x3*x43 + x47*x65 + x49*x65 + x59 + x63 - x64, -x43*x74 + x47*x76 + x49*x76 + x73 - x75 + x81, -x43*x91 + x47*x93 + x49*x93 + x87 + x90 - x92, -x100 + x101*x47 + x101*x49 - x43*x99 + x94 + x98, x107 - x108 + x109*x47 + x109*x49 + x112 - x43*x6, x113 + x118 - x119 + x120*x47 + x120*x49 - x43*x8, x124 + x126 - x127 + x128*x47 + x128*x49 - x43*x9, -x130*x7 + x131*x45 + x132*x45 + x50 - x55 + x57, -x1*x130 + x131*x58 + x132*x58 + x28*(x12**2 + x3**2), -x130*x3 + x131*x65 + x132*x65 + x133 + x135 - x137, -x130*x74 + x131*x76 + x132*x76 + x138 + x139 - x140, -x130*x91 + x131*x93 + x132*x93 + x141 - x142 + x143, x101*x131 + x101*x132 - x130*x99 + x144 + x146 - x147, x109*x131 + x109*x132 - x130*x6 + x148 + x149 - x150, x120*x131 + x120*x132 - x130*x8 + x151 - x152 + x154, x128*x131 + x128*x132 - x130*x9 + x155 + x156 - x157, -x159*x7 + x160*x45 + x161*x45 + x59 - x63 + x64, -x1*x159 + x133 - x135 + x137 + x160*x58 + x161*x58, -x159*x3 + x160*x65 + x161*x65 + x28*(x19**2 + x7**2), -x159*x74 + x160*x76 + x161*x76 + x163 + x164 - x166, -x159*x91 + x160*x93 + x161*x93 + x167 + x168 - x169, x101*x160 + x101*x161 - x159*x99 + x170 - x171 + x172, x109*x160 + x109*x161 - x159*x6 + x173 + x174 - x175, x120*x160 + x120*x161 - x159*x8 + x176 + x177 - x178, x128*x160 + x128*x161 - x159*x9 + x179 - x180 + x181, -x183*x7 + x184*x45 + x185*x45 - x73 + x75 + x81, -x1*x183 + x138 - x139 + x140 + x184*x58 + x185*x58, -x163 + x164 + x166 - x183*x3 + x184*x65 + x185*x65, -x183*x74 + x184*x76 + x185*x76 + x186 + x28*(x78**2 + x80**2), -x183*x91 + x184*x93 + x185*x93 + x187 + x189 - x191, x101*x184 + x101*x185 - x183*x99 + x192 + x193 - x194, x109*x184 + x109*x185 - x183*x6 + x195 - x196 + x197, x120*x184 + x120*x185 - x183*x8 + x198 - x199 + x200, x128*x184 + x128*x185 - x183*x9 + x201 - x202 + x203, -x205*x7 + x206*x45 + x207*x45 - x87 + x90 + x92, -x1*x205 - x141 + x142 + x143 + x206*x58 + x207*x58, x167 - x168 + x169 - x205*x3 + x206*x65 + x207*x65, x187 - x189 + x191 - x205*x74 + x206*x76 + x207*x76, x186 - x205*x91 + x206*x93 + x207*x93 + x28*(x79**2 + x89**2), x101*x206 + x101*x207 - x205*x99 + x208 + x210 - x212, x109*x206 + x109*x207 - x205*x6 + x213 - x214 + x215, x120*x206 + x120*x207 - x205*x8 + x216 - x217 + x218, x128*x206 + x128*x207 - x205*x9 + x219 - x220 + x221, x100 - x223*x7 + x224*x45 + x225*x45 + x94 - x98, -x1*x223 - x144 + x146 + x147 + x224*x58 + x225*x58, -x170 + x171 + x172 - x223*x3 + x224*x65 + x225*x65, x192 - x193 + x194 - x223*x74 + x224*x76 + x225*x76, x208 - x210 + x212 - x223*x91 + x224*x93 + x225*x93, x101*x224 + x101*x225 + x186 - x223*x99 + x28*(x145**2 + x88**2), x109*x224 + x109*x225 - x223*x6 + x226 - x228 + x230, x120*x224 + x120*x225 - x223*x8 + x231 - x232 + x233, x128*x224 + x128*x225 - x223*x9 + x234 - x235 + x236, -x107 + x108 + x112 - x238*x7 + x239*x45 + x240*x45, -x1*x238 - x148 + x149 + x150 + x239*x58 + x240*x58, x173 - x174 + x175 - x238*x3 + x239*x65 + x240*x65, -x195 + x196 + x197 - x238*x74 + x239*x76 + x240*x76, x213 + x214 - x215 - x238*x91 + x239*x93 + x240*x93, x101*x239 + x101*x240 + x226 + x228 - x230 - x238*x99, x109*x239 + x109*x240 - x238*x6 + x28*(x111**2 + x9**2), x120*x239 + x120*x240 - x238*x8 + x241 + x243 - x245, x128*x239 + x128*x240 - x238*x9 + x246 + x247 - x248, x113 - x118 + x119 - x250*x7 + x251*x45 + x252*x45, -x1*x250 - x151 + x152 + x154 + x251*x58 + x252*x58, -x176 + x177 + x178 - x250*x3 + x251*x65 + x252*x65, x198 + x199 - x200 - x250*x74 + x251*x76 + x252*x76, -x216 + x217 + x218 - x250*x91 + x251*x93 + x252*x93, x101*x251 + x101*x252 + x231 + x232 - x233 - x250*x99, x109*x251 + x109*x252 + x241 - x243 + x245 - x250*x6, x120*x251 + x120*x252 - x250*x8 + x28*(x153**2 + x6**2), x128*x251 + x128*x252 - x250*x9 + x253 + x254 - x255, -x124 + x126 + x127 - x257*x7 + x258*x45 + x259*x45, -x1*x257 + x155 - x156 + x157 + x258*x58 + x259*x58, -x179 + x180 + x181 - x257*x3 + x258*x65 + x259*x65, x201 + x202 - x203 - x257*x74 + x258*x76 + x259*x76, x219 + x220 - x221 - x257*x91 + x258*x93 + x259*x93, x101*x258 + x101*x259 - x234 + x235 + x236 - x257*x99, x109*x258 + x109*x259 + x246 - x247 + x248 - x257*x6, x120*x258 + x120*x259 + x253 - x254 + x255 - x257*x8, x128*x258 + x128*x259 - x257*x9 + x28*(x125**2 + x8**2)], dtype=np.float64)


def q_d(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -p0
    x1 = -o0 - x0
    x2 = m0 - o0
    x3 = m1 - o1
    x4 = m2 - o2
    x5 = 1/mpmath.sqrt(x2**2 + x3**2 + x4**2)
    x6 = -p1
    x7 = -o1 - x6
    x8 = -p2
    x9 = -o2 - x8
    x10 = 1/mpmath.sqrt(x1**2 + x7**2 + x9**2)
    x11 = x10*x5
    x12 = x11*x2
    x13 = x11*x3
    x14 = x11*x4
    x15 = n0 + x0
    x16 = n1 + x6
    x17 = n2 + x8
    x18 = 1/mpmath.sqrt(x15**2 + x16**2 + x17**2)
    x19 = x10*x18
    x20 = x15*x19
    x21 = x16*x19
    x22 = x17*x19

    return mpmath.acos(((-x1*x13 + x12*x7)*(-x1*x21 + x20*x7) + (x13*x9 - x14*x7)*(x21*x9 - x22*x7) + (x1*x10*x17*x18 - x20*x9)*(x1*x10*x4*x5 - x12*x9))/(mpmath.sqrt(1 - (x1*x12 + x13*x7 + x14*x9)**2)*mpmath.sqrt(1 - (-x1*x20 - x21*x7 - x22*x9)**2)))


def dq_d(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - o0
    x1 = -p0
    x2 = o0 + x1
    x3 = -x2
    x4 = x0**2
    x5 = m1 - o1
    x6 = x5**2
    x7 = m2 - o2
    x8 = x7**2
    x9 = x4 + x6 + x8
    x10 = 1/mpmath.sqrt(x9)
    x11 = x3**2
    x12 = -p1
    x13 = o1 + x12
    x14 = -x13
    x15 = x14**2
    x16 = -p2
    x17 = o2 + x16
    x18 = -x17
    x19 = x18**2
    x20 = x11 + x15 + x19
    x21 = 1/mpmath.sqrt(x20)
    x22 = x10*x21
    x23 = x22*x3
    x24 = x14*x22
    x25 = x18*x22
    x26 = x0*x23 + x24*x5 + x25*x7
    x27 = 1 - x26**2
    x28 = n0 + x1
    x29 = x28**2
    x30 = n1 + x12
    x31 = x30**2
    x32 = n2 + x16
    x33 = x32**2
    x34 = x29 + x31 + x33
    x35 = 1/mpmath.sqrt(x34)
    x36 = x21*x35
    x37 = x28*x36
    x38 = x30*x36
    x39 = x32*x36
    x40 = -x14*x38 - x18*x39 - x3*x37
    x41 = 1 - x40**2
    x42 = x0*x24 - x23*x5
    x43 = x14*x37 - x3*x38
    x44 = -x0*x25 + x10*x21*x3*x7
    x45 = -x18*x37 + x21*x3*x32*x35
    x46 = -x24*x7 + x25*x5
    x47 = -x14*x39 + x18*x38
    x48 = x42*x43 + x44*x45 + x46*x47
    x49 = 1/mpmath.sqrt(1 - x48**2/(x27*x41))
    x50 = -x0
    x51 = x9**(mpmath.mpf(-3)/mpmath.mpf(2))
    x52 = x21*x51
    x53 = x50*x52
    x54 = x5*x53
    x55 = x53*x7
    x56 = x0*x14
    x57 = x0*x18
    x58 = 1/mpmath.sqrt(x27)
    x59 = 1/mpmath.sqrt(x41)
    x60 = x58*x59
    x61 = 2*x23
    x62 = x0*x3
    x63 = 2*x62
    x64 = 2*x14
    x65 = 2*x18
    x66 = (mpmath.mpf(1)/mpmath.mpf(2))*x48
    x67 = x26*x59*x66/x27**(mpmath.mpf(3)/mpmath.mpf(2))
    x68 = -x5
    x69 = x52*x68
    x70 = x5*x69
    x71 = x69*x7
    x72 = 2*x24
    x73 = -x7
    x74 = x52*x73
    x75 = x5*x74
    x76 = x7*x74
    x77 = 2*x25
    x78 = 2*x37
    x79 = x20**(mpmath.mpf(-3)/mpmath.mpf(2))
    x80 = x11*x79
    x81 = x35*x80
    x82 = 2*x28
    x83 = x3*x79
    x84 = x35*x83
    x85 = x14*x84
    x86 = x30*x85
    x87 = x18*x84
    x88 = x32*x87
    x89 = x40*x58*x66/x41**(mpmath.mpf(3)/mpmath.mpf(2))
    x90 = x0*x22
    x91 = 2*x90
    x92 = x10*x80
    x93 = 2*x0
    x94 = x4*x52
    x95 = 2*x3
    x96 = x5*x52
    x97 = x56*x96
    x98 = x52*x7
    x99 = x57*x98
    x100 = x10*x83
    x101 = x100*x5
    x102 = x101*x14
    x103 = x100*x7
    x104 = x30*x87
    x105 = -x32*x85
    x106 = x14*x28
    x107 = x106*x84
    x108 = x28*x87
    x109 = x101*x18
    x110 = x56*x98
    x111 = x14*x7
    x112 = -x100*x111 + x57*x96
    x113 = x22*x5
    x114 = x100*x56
    x115 = x62*x96
    x116 = x100*x57
    x117 = x22*x7
    x118 = x117 - x25
    x119 = 2*x38
    x120 = x15*x79
    x121 = x120*x35
    x122 = 2*x30
    x123 = x18*x79
    x124 = x123*x35
    x125 = 2*x113
    x126 = x10*x120
    x127 = x52*x6
    x128 = x7*x96
    x129 = x128*x18
    x130 = x10*x123
    x131 = x111*x130
    x132 = x106*x124
    x133 = x14*x30
    x134 = x124*x133
    x135 = -x128*x3 + x130*x56
    x136 = x23 - x90
    x137 = x130*x5
    x138 = x137*x14
    x139 = x111*x96
    x140 = 2*x39
    x141 = x19*x79
    x142 = x141*x35
    x143 = 2*x32
    x144 = 2*x117
    x145 = x10*x141
    x146 = 2*x7
    x147 = x52*x8
    x148 = x14*x32
    x149 = x100*x93
    x150 = x2*x79
    x151 = x10*x150
    x152 = x5*x64
    x153 = x130*x146
    x154 = x3*x36
    x155 = 2*x154
    x156 = x34**(mpmath.mpf(-3)/mpmath.mpf(2))
    x157 = x156*x21
    x158 = x157*x29
    x159 = x157*x32
    x160 = x159*x18
    x161 = x82*x84
    x162 = x150*x35
    x163 = 2*x133
    x164 = x124*x143
    x165 = x157*x30
    x166 = x165*x28
    x167 = x166*x18
    x168 = x2*x30
    x169 = x106*x159
    x170 = x159*x28
    x171 = x124*x28
    x172 = x18*x36
    x173 = x172 + x39
    x174 = x14*x36
    x175 = x174 + x38
    x176 = x13*x79
    x177 = x10*x176
    x178 = 2*x174
    x179 = x157*x31
    x180 = x176*x35
    x181 = x165*x32
    x182 = -x181*x3
    x183 = x154 + x37
    x184 = x17*x79
    x185 = x10*x184
    x186 = 2*x172
    x187 = x157*x33
    x188 = x184*x35
    x189 = x17*x30
    x190 = -x28
    x191 = x165*x190
    x192 = x157*x190
    x193 = x18*x28
    x194 = x28*x95
    x195 = x159*x65
    x196 = -x30
    x197 = x157*x196
    x198 = x165*x196
    x199 = -x32
    x200 = x157*x199

    return np.array([-x49*(x60*(x43*(x24 - x3*x54 + x53*x56) + x45*(x21*x3*x50*x51*x7 - x25 - x53*x57) + x47*(-x14*x55 + x18*x54)) + x67*(x53*x63 + x54*x64 + x55*x65 + x61)), -x49*(x60*(x43*(x0*x14*x21*x51*x68 - x23 - x3*x70) + x45*(x21*x3*x51*x68*x7 - x57*x69) + x47*(-x14*x71 + x18*x70 + x25)) + x67*(x63*x69 + x64*x70 + x65*x71 + x72)), -x49*(x60*(x43*(-x3*x75 + x56*x74) + x45*(x23 + x3*x76 - x57*x74) + x47*(-x14*x76 + x18*x21*x5*x51*x73 - x24)) + x67*(x63*x74 + x64*x75 + x65*x76 + x77)), -x49*(x60*(x42*(x107 - x30*x81 + x38) + x43*(x113 + x114 - x115 + x14*x94 - x24 - x5*x92) + x44*(-x108 + x11*x32*x35*x79 - x39) + x45*(x0*x21*x3*x51*x7 + x10*x11*x7*x79 - x116 - x118 - x18*x94) + x46*(x104 + x105) + x47*(x109 - x110 + x112)) + x67*(2*x102 + 2*x103*x18 - x61 - x91 + x92*x93 + x94*x95 + 2*x97 + 2*x99) + x89*(x78 - x81*x82 - 2*x86 - 2*x88)), -x49*(x60*(x42*(x15*x28*x35*x79 - x37 - x86) + x43*(x0*x126 - x102 - x127*x3 + x136 + x97) + x44*(-x105 - x132) + x45*(-x112 - x135) + x46*(-x121*x32 + x134 + x39) + x47*(x118 - x126*x7 + x127*x18 + x138 - x139)) + x67*(2*x114 + 2*x115 - x125 + 2*x126*x5 + x127*x64 + 2*x129 + 2*x131 - x72) + x89*(-2*x107 + x119 - x121*x122 - x124*x32*x64)), -x49*(x60*(x42*(-x104 + x132) + x43*(-x109 + x110 + x135) + x44*(-x142*x28 + x37 + x88) + x45*(-x0*x145 + x10*x18*x3*x7*x79 - x136 + x21*x3*x51*x8 - x99) + x46*(-x124*x148 + x19*x30*x35*x79 - x38) + x47*(-x113 + x129 - x131 - x14*x147 + x145*x5 + x24)) + x67*(2*x116 + 2*x138 + 2*x139 - x144 + x145*x146 + x147*x65 + 2*x62*x98 - x77) + x89*(-2*x108 - 2*x134 + x140 - x142*x143)), -x49*(x60*(x42*(x14*x156*x21*x29 + x14*x2*x28*x35*x79 - x166*x3 - x168*x84 - x175) + x43*(x0*x10*x14*x2*x79 - x101*x2 - x113) + x44*(-x158*x18 + x170*x3 - x171*x2 + x173 + x2*x32*x84) + x45*(x103*x2 + x117 - x151*x57) + x46*(x124*x168 - x148*x162 + x167 - x169) + x47*(-x111*x151 + x137*x2)) + x67*(x149*x2 + x151*x152 + x153*x2 + x91) + x89*(-x106*x122*x157 + x155 - x158*x95 - x160*x82 - x161*x2 - x162*x163 - x164*x2 - x78)), -x49*(x60*(x42*(x106*x165 + x106*x180 - x13*x30*x84 - x179*x3 + x183) + x43*(-x101*x13 + x177*x56 + x90) + x44*(-x13*x171 + x13*x3*x32*x35*x79 - x167 - x182) + x45*(x10*x13*x3*x7*x79 - x177*x57) + x46*(x13*x18*x30*x35*x79 - x133*x159 - x148*x180 + x156*x18*x21*x31 - x173) + x47*(x10*x13*x18*x5*x79 - x111*x177 - x117)) + x67*(x125 + x13*x149 + x13*x153 + x152*x177) + x89*(-x119 - x122*x160 - x13*x161 - x13*x164 - x163*x180 - x166*x95 + x178 - x179*x64)), -x49*(x60*(x42*(x106*x188 + x169 + x182 - x189*x84) + x43*(-x101*x17 + x185*x56) + x44*(x156*x21*x3*x33 - x17*x171 + x17*x3*x32*x35*x79 - x170*x18 - x183) + x45*(x10*x17*x3*x7*x79 - x185*x57 - x90) + x46*(x124*x189 - x14*x187 - x148*x188 + x175 + x18*x181) + x47*(-x111*x185 + x113 + x137*x17)) + x67*(x144 + x149*x17 + x152*x185 + x153*x17) + x89*(-x133*x143*x157 - x140 - x161*x17 - x163*x188 - x164*x17 - x170*x95 + x186 - x187*x65)), -x49*(x60*(x42*(x106*x192 + x174 - x191*x3) + x44*(x156*x190*x21*x3*x32 - x172 - x192*x193) + x46*(-x148*x192 + x18*x191)) + x89*(-x155 - x163*x192 - x190*x195 - x192*x194)), -x49*(x60*(x42*(x14*x156*x196*x21*x28 - x154 - x198*x3) + x44*(x156*x196*x21*x3*x32 - x193*x197) + x46*(-x148*x197 + x172 + x18*x198)) + x89*(-x163*x197 - x178 - x194*x197 - x195*x196)), -x49*(x60*(x42*(x106*x200 - x165*x199*x3) + x44*(x154 + x159*x199*x3 - x193*x200) + x46*(-x148*x200 + x156*x18*x199*x21*x30 - x174)) + x89*(-x163*x200 - x186 - x194*x200 - x195*x199))], dtype=np.float64)


def d2q_d(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -p2
    x1 = o2 + x0
    x2 = -x1
    x3 = -p1
    x4 = n1 + x3
    x5 = -p0
    x6 = n0 + x5
    x7 = x6**2
    x8 = x4**2
    x9 = n2 + x0
    x10 = x9**2
    x11 = x10 + x7 + x8
    x12 = 1/mpmath.sqrt(x11)
    x13 = o0 + x5
    x14 = -x13
    x15 = x14**2
    x16 = o1 + x3
    x17 = -x16
    x18 = x17**2
    x19 = x2**2
    x20 = x15 + x18 + x19
    x21 = 1/mpmath.sqrt(x20)
    x22 = x12*x21
    x23 = x22*x4
    x24 = x22*x9
    x25 = -x17*x24 + x2*x23
    x26 = m0 - o0
    x27 = -x26
    x28 = m1 - o1
    x29 = x26**2
    x30 = x28**2
    x31 = m2 - o2
    x32 = x31**2
    x33 = x29 + x30 + x32
    x34 = x33**(mpmath.mpf(-3)/mpmath.mpf(2))
    x35 = x21*x34
    x36 = x28*x35
    x37 = x2*x36
    x38 = x17*x35
    x39 = x31*x38
    x40 = x27*x37 - x27*x39
    x41 = x25*x40
    x42 = x22*x6
    x43 = -x14*x23 + x17*x42
    x44 = 1/mpmath.sqrt(x33)
    x45 = x21*x44
    x46 = x17*x45
    x47 = x26*x38
    x48 = x14*x36
    x49 = x27*x47 - x27*x48 + x46
    x50 = x43*x49
    x51 = x12*x14*x21*x9 - x2*x42
    x52 = x2*x45
    x53 = x2*x35
    x54 = x26*x53
    x55 = x14*x21*x27*x31*x34 - x27*x54 - x52
    x56 = x51*x55
    x57 = x41 + x50 + x56
    x58 = x14*x45
    x59 = x26*x58 + x28*x46 + x31*x52
    x60 = x59**2
    x61 = 1 - x60
    x62 = 1/mpmath.sqrt(x61)
    x63 = -x14*x42 - x17*x23 - x2*x24
    x64 = x63**2
    x65 = 1 - x64
    x66 = 1/mpmath.sqrt(x65)
    x67 = x62*x66
    x68 = 2*x58
    x69 = x14*x35
    x70 = x27*x69
    x71 = x26*x70
    x72 = x27*x36
    x73 = x17*x72
    x74 = x27*x53
    x75 = 2*x74
    x76 = x31*x75 + x68 + 2*x71 + 2*x73
    x77 = x59*x76
    x78 = x61**(mpmath.mpf(-3)/mpmath.mpf(2))
    x79 = x66*x78
    x80 = x77*x79
    x81 = x26*x46 - x28*x58
    x82 = x14*x21*x31*x44 - x26*x52
    x83 = x28*x52 - x31*x46
    x84 = x25*x83 + x43*x81 + x51*x82
    x85 = (mpmath.mpf(1)/mpmath.mpf(2))*x84
    x86 = x57*x67 + x80*x85
    x87 = x84**2
    x88 = x61**(-1)
    x89 = x65**(-1)
    x90 = x88*x89
    x91 = -x87*x90 + 1
    x92 = x91**(mpmath.mpf(-3)/mpmath.mpf(2))
    x93 = (mpmath.mpf(1)/mpmath.mpf(2))*x87
    x94 = x89*x93/x61**2
    x95 = x85*x90
    x96 = x92*(x77*x94 + x95*(2*x41 + 2*x50 + 2*x56))
    x97 = 1/mpmath.sqrt(x91)
    x98 = (mpmath.mpf(3)/mpmath.mpf(4))*x84
    x99 = x60*x66*x98/x61**(mpmath.mpf(5)/mpmath.mpf(2))
    x100 = x79*x85
    x101 = x100*(x31*x74 + x58 + x71 + x73)
    x102 = 3*o0
    x103 = 3*m0 - x102
    x104 = -x103
    x105 = x33**(mpmath.mpf(-5)/mpmath.mpf(2))
    x106 = x105*x21
    x107 = x104*x106
    x108 = x107*x27
    x109 = x108*x28
    x110 = x108*x31
    x111 = -x37
    x112 = x111 + x39
    x113 = x27*x38
    x114 = 2*x113
    x115 = x17*x26
    x116 = -x47
    x117 = x116 + x48
    x118 = x2*x26
    x119 = x31*x69
    x120 = -x54
    x121 = x119 + x120
    x122 = 2*x14
    x123 = x122*x26
    x124 = 2*x17
    x125 = 2*x2
    x126 = x26*x69
    x127 = 2*x126
    x128 = x17*x36
    x129 = 2*x128
    x130 = x31*x53
    x131 = 2*x130
    x132 = -x127 - x129 - x131
    x133 = x59*x79
    x134 = x133*x85
    x135 = -x28
    x136 = x135*x14*x21*x31*x34 - x135*x54
    x137 = x136*x51
    x138 = x135*x37 - x135*x39 + x52
    x139 = x138*x25
    x140 = x135*x17*x21*x26*x34 - x135*x48 - x58
    x141 = x140*x43
    x142 = x137 + x139 + x141
    x143 = 2*x46
    x144 = x135*x69
    x145 = 2*x144
    x146 = x135*x53
    x147 = x146*x31
    x148 = x129*x135 + x143 + x145*x26 + 2*x147
    x149 = x133*x148
    x150 = x142*x67 + x149*x85
    x151 = x107*x135
    x152 = x151*x28
    x153 = x151*x31
    x154 = x135*x38
    x155 = -x70
    x156 = x154 + x155
    x157 = x114 + x145
    x158 = (mpmath.mpf(1)/mpmath.mpf(2))*x57
    x159 = (mpmath.mpf(1)/mpmath.mpf(2))*x80
    x160 = x76*x99
    x161 = x142*x159 + x148*x160 + x149*x158
    x162 = -x31
    x163 = x162*x47 - x162*x48
    x164 = x163*x43
    x165 = x119*x162 - x162*x54 + x58
    x166 = x165*x51
    x167 = x162*x2*x21*x28*x34 - x162*x39 - x46
    x168 = x167*x25
    x169 = x164 + x166 + x168
    x170 = 2*x52
    x171 = x162*x69
    x172 = 2*x171
    x173 = x162*x53
    x174 = x173*x31
    x175 = x129*x162 + x170 + x172*x26 + 2*x174
    x176 = x133*x175
    x177 = x169*x67 + x176*x85
    x178 = x162*x38
    x179 = x107*x162
    x180 = x179*x28
    x181 = x179*x31
    x182 = x155 + x173
    x183 = x172 + x75
    x184 = x158*x176 + x159*x169 + x160*x175
    x185 = 2*x42
    x186 = x20**(mpmath.mpf(-3)/mpmath.mpf(2))
    x187 = x12*x186
    x188 = x15*x187
    x189 = x188*x6
    x190 = x187*x4
    x191 = x14*x190
    x192 = x17*x191
    x193 = x187*x9
    x194 = x14*x193
    x195 = x194*x2
    x196 = x185 - 2*x189 - 2*x192 - 2*x195
    x197 = x196*x63
    x198 = x65**(mpmath.mpf(-3)/mpmath.mpf(2))
    x199 = x198*x62
    x200 = x197*x199
    x201 = 2*x45
    x202 = x201*x26
    x203 = x186*x44
    x204 = x15*x203
    x205 = 2*x204
    x206 = x29*x35
    x207 = x14*x206
    x208 = x31*x54
    x209 = x14*x203
    x210 = x17*x209
    x211 = 2*x210
    x212 = x2*x209
    x213 = 2*x212
    x214 = x129*x26 - x202 + x205*x26 + 2*x207 + 2*x208 + x211*x28 + x213*x31 - x68
    x215 = x133*x214
    x216 = x191*x2
    x217 = x17*x187
    x218 = x217*x9
    x219 = -x14*x218
    x220 = x216 + x219
    x221 = x220*x83
    x222 = x217*x6
    x223 = x14*x222
    x224 = -x188*x4 + x223 + x23
    x225 = x224*x81
    x226 = x187*x6
    x227 = x2*x226
    x228 = x14*x227
    x229 = x12*x15*x186*x9 - x228 - x24
    x230 = x229*x82
    x231 = x212*x28
    x232 = x31*x47
    x233 = -x210*x31 + x26*x37
    x234 = x231 - x232 + x233
    x235 = x234*x25
    x236 = x28*x45
    x237 = x26*x48
    x238 = x210*x26
    x239 = x238 - x46
    x240 = x17*x206 - x204*x28 + x236 - x237 + x239
    x241 = x240*x43
    x242 = x212*x26
    x243 = x31*x45
    x244 = -x52
    x245 = x243 + x244
    x246 = x14*x21*x26*x31*x34 + x15*x186*x31*x44 - x2*x206 - x242 - x245
    x247 = x246*x51
    x248 = x221 + x225 + x230 + x235 + x241 + x247
    x249 = x200*x85 + x215*x85 + x248*x67
    x250 = 2*o0
    x251 = 2*m0 - x250
    x252 = x107*x29
    x253 = x26*x28
    x254 = x107*x253
    x255 = x14*x254
    x256 = -x48
    x257 = x186*x34
    x258 = x15*x257
    x259 = x258*x27
    x260 = x14*x257
    x261 = x260*x27
    x262 = x115*x261
    x263 = -x113 + x210 + x256 - x259*x28 + x262 + x72
    x264 = x26*x31
    x265 = x107*x264
    x266 = x17*x265
    x267 = x17*x31
    x268 = -x261*x267
    x269 = x2*x254 + x268
    x270 = x261*x28
    x271 = x2*x270
    x272 = -x39
    x273 = x272 + x37
    x274 = x271 + x273
    x275 = x27*x35
    x276 = x275*x31
    x277 = -x276
    x278 = -x212
    x279 = -x251
    x280 = x118*x261
    x281 = x14*x265
    x282 = x220*x40 + x224*x49 + x229*x55
    x283 = 4*o0
    x284 = 4*m0 - x283
    x285 = x17*x254
    x286 = x2*x265
    x287 = x26*x275
    x288 = 2*x287
    x289 = 2*x26
    x290 = x17*x270
    x291 = -x201
    x292 = x131 + x291
    x293 = x129 + 2*x2*x261*x31 + x205 + x259*x289 - x288 + 2*x290 + x292 - 2*x70
    x294 = x198*x78
    x295 = x197*x294
    x296 = (mpmath.mpf(1)/mpmath.mpf(4))*x84
    x297 = x296*x77
    x298 = x158*x200 + x158*x215 + x159*x248 + x160*x214 + x295*x297
    x299 = 2*x23
    x300 = x18*x187
    x301 = x300*x4
    x302 = x2*x218
    x303 = -2*x223 + x299 - 2*x301 - 2*x302
    x304 = x199*x63
    x305 = x303*x304
    x306 = x201*x28
    x307 = x18*x203
    x308 = 2*x307
    x309 = x30*x35
    x310 = x17*x309
    x311 = x31*x37
    x312 = x17*x203
    x313 = x2*x312
    x314 = x31*x313
    x315 = -x143 + 2*x237 + 2*x238 + x28*x308 - x306 + 2*x310 + 2*x311 + 2*x314
    x316 = x133*x315
    x317 = x2*x222
    x318 = -x219 - x317
    x319 = x318*x82
    x320 = x190*x2
    x321 = x17*x320
    x322 = x24 - x300*x9 + x321
    x323 = x322*x83
    x324 = x12*x18*x186*x6 - x192 - x42
    x325 = x324*x81
    x326 = x26*x313 - x31*x48
    x327 = -x233 - x326
    x328 = x327*x51
    x329 = x128*x26
    x330 = x210*x28
    x331 = x26*x45
    x332 = -x331
    x333 = x332 + x58
    x334 = -x14*x309 + x26*x307 + x329 - x330 + x333
    x335 = x334*x43
    x336 = x28*x313
    x337 = x128*x31
    x338 = x2*x309 + x245 - x307*x31 + x336 - x337
    x339 = x25*x338
    x340 = x319 + x323 + x325 + x328 + x335 + x339
    x341 = x305*x85 + x316*x85 + x340*x67
    x342 = x107*x30
    x343 = x18*x257
    x344 = x27*x343
    x345 = x128 + x307
    x346 = -x45
    x347 = -x287 + x346 + x70
    x348 = x26*x344 - x290 + x345 + x347
    x349 = x28*x31
    x350 = x107*x349
    x351 = x17*x350
    x352 = x257*x27
    x353 = x2*x28
    x354 = x17*x353
    x355 = x352*x354
    x356 = x276 - x74
    x357 = -x31*x344 + x355 + x356
    x358 = x2*x352
    x359 = x115*x358 + x313
    x360 = -x14*x350 + x359
    x361 = x318*x55 + x322*x40 + x324*x49
    x362 = x2*x350
    x363 = 2*x48
    x364 = 2*x72
    x365 = 2*x28
    x366 = x267*x358
    x367 = -x114 + x211 + 2*x262 + x344*x365 + x363 - x364 + 2*x366
    x368 = x294*x63
    x369 = x297*x368
    x370 = x158*x305 + x158*x316 + x159*x340 + x160*x315 + x303*x369
    x371 = 2*x24
    x372 = x187*x19
    x373 = x372*x9
    x374 = -2*x228 - 2*x321 + x371 - 2*x373
    x375 = x304*x374
    x376 = x201*x31
    x377 = x19*x203
    x378 = 2*x377
    x379 = x32*x35
    x380 = x2*x379
    x381 = x119*x26
    x382 = x129*x31 - x170 + 2*x242 + x31*x378 + 2*x336 - x376 + 2*x380 + 2*x381
    x383 = x133*x382
    x384 = -x216 + x317
    x385 = x384*x81
    x386 = x195 - x372*x6 + x42
    x387 = x386*x82
    x388 = x12*x186*x19*x4 - x23 - x302
    x389 = x388*x83
    x390 = -x231 + x232 + x326
    x391 = x390*x43
    x392 = x14*x186*x2*x31*x44 + x14*x21*x32*x34 - x208 - x26*x377 - x333
    x393 = x392*x51
    x394 = -x236 + x311
    x395 = -x17*x379 + x28*x377 - x314 + x394 + x46
    x396 = x25*x395
    x397 = x385 + x387 + x389 + x391 + x393 + x396
    x398 = x375*x85 + x383*x85 + x397*x67
    x399 = -x271 + x39
    x400 = x107*x32
    x401 = -x72
    x402 = x19*x257
    x403 = x27*x402
    x404 = x113 + x28*x403 - x366 + x401
    x405 = x130 + x377
    x406 = -x14*x186*x2*x27*x31*x34 + x26*x403 + x347 + x405
    x407 = x384*x49 + x386*x55 + x388*x40
    x408 = 2*x119
    x409 = 2*x276
    x410 = 2*x31
    x411 = x213 + 2*x280 + 2*x355 + x403*x410 + x408 - x409 - x75
    x412 = x158*x375 + x158*x383 + x159*x397 + x160*x382 + x369*x374
    x413 = x13*x209
    x414 = 2*x413
    x415 = x13*x312
    x416 = 2*x415
    x417 = x2*x203
    x418 = x13*x417
    x419 = 2*x418
    x420 = x202 + x26*x414 + x28*x416 + x31*x419
    x421 = x133*x420
    x422 = x14*x22
    x423 = 2*x422
    x424 = x11**(mpmath.mpf(-3)/mpmath.mpf(2))
    x425 = x21*x424
    x426 = x425*x7
    x427 = x425*x6
    x428 = x4*x427
    x429 = x17*x428
    x430 = x427*x9
    x431 = x2*x430
    x432 = x14*x226
    x433 = 2*x432
    x434 = x17*x190
    x435 = 2*x434
    x436 = x193*x2
    x437 = 2*x436
    x438 = -x13*x433 - x13*x435 - x13*x437 - 2*x14*x426 - x185 + x423 - 2*x429 - 2*x431
    x439 = x304*x438
    x440 = x28*x418 - x31*x415
    x441 = x25*x440
    x442 = x243 - x26*x418 + x31*x413
    x443 = x442*x51
    x444 = x13*x17*x186*x26*x44 - x236 - x28*x413
    x445 = x43*x444
    x446 = x2*x428
    x447 = x17*x430
    x448 = -x13*x218 + x13*x320 + x446 - x447
    x449 = x448*x83
    x450 = x14*x430
    x451 = x2*x22
    x452 = x24 + x451
    x453 = x13*x194 - x13*x227 - x2*x426 + x450 + x452
    x454 = x453*x82
    x455 = x14*x428
    x456 = x17*x22
    x457 = x23 + x456
    x458 = x12*x13*x17*x186*x6 - x13*x191 + x17*x21*x424*x7 - x455 - x457
    x459 = x458*x81
    x460 = x441 + x443 + x445 + x449 + x454 + x459
    x461 = x421*x85 + x439*x85 + x460*x67
    x462 = x13*x352
    x463 = x261*x289
    x464 = x124*x28
    x465 = x358*x410
    x466 = x134*(x13*x463 + x13*x465 + x201 + x288 + x414 + x462*x464) + x158*x421 + x158*x439 + x159*x460 + x160*x420 + x369*x438 + x67*(x25*(-x267*x462 + x353*x462) + x40*x448 + x43*(x115*x462 - x13*x270 + x401 + x415) + x453*x55 + x458*x49 + x51*(-x118*x462 + x13*x14*x186*x27*x31*x34 - x277 - x418))
    x467 = x16*x209
    x468 = 2*x467
    x469 = x16*x312
    x470 = 2*x469
    x471 = x16*x417
    x472 = 2*x471
    x473 = x26*x468 + x28*x470 + x306 + x31*x472
    x474 = x133*x473
    x475 = 2*x456
    x476 = x425*x8
    x477 = x4*x425
    x478 = x477*x9
    x479 = x2*x478
    x480 = -x16*x433 - x16*x435 - x16*x437 - 2*x17*x476 - x299 - 2*x455 + x475 - 2*x479
    x481 = x304*x480
    x482 = x14*x16*x186*x31*x44 - x26*x471
    x483 = x482*x51
    x484 = x26*x469 - x28*x467 + x331
    x485 = x43*x484
    x486 = x16*x186*x2*x28*x44 - x243 - x31*x469
    x487 = x25*x486
    x488 = -x14*x478
    x489 = x12*x14*x16*x186*x9 - x16*x227 - x446 - x488
    x490 = x489*x82
    x491 = x42 + x422
    x492 = -x14*x476 - x16*x191 + x16*x222 + x429 + x491
    x493 = x492*x81
    x494 = x17*x478
    x495 = x12*x16*x186*x2*x4 - x16*x218 + x2*x21*x424*x8 - x452 - x494
    x496 = x495*x83
    x497 = x483 + x485 + x487 + x490 + x493 + x496
    x498 = x474*x85 + x481*x85 + x497*x67
    x499 = x16*x352
    x500 = x287 + x45
    x501 = x134*(x16*x463 + x16*x465 + x364 + x464*x499 + x468) + x158*x474 + x158*x481 + x159*x497 + x160*x473 + x369*x480 + x67*(x25*(x16*x186*x2*x27*x28*x34 - x267*x499 - x276) + x40*x495 + x43*(x115*x499 - x16*x270 + x469 + x500) + x489*x55 + x49*x492 + x51*(-x118*x499 + x14*x16*x186*x27*x31*x34 - x471))
    x502 = x1*x209
    x503 = 2*x502
    x504 = x1*x312
    x505 = 2*x504
    x506 = x1*x417
    x507 = 2*x506
    x508 = x26*x503 + x28*x505 + x31*x507 + x376
    x509 = x133*x508
    x510 = 2*x451
    x511 = x10*x425
    x512 = -x1*x433 - x1*x435 - x1*x437 - 2*x2*x511 - x371 - 2*x450 - 2*x494 + x510
    x513 = x304*x512
    x514 = x26*x504 - x28*x502
    x515 = x43*x514
    x516 = x236 + x28*x506 - x31*x504
    x517 = x25*x516
    x518 = x1*x14*x186*x31*x44 - x26*x506 - x331
    x519 = x51*x518
    x520 = -x1*x191 + x1*x222 + x447 + x488
    x521 = x520*x81
    x522 = -x1*x218 + x1*x320 - x17*x511 + x457 + x479
    x523 = x522*x83
    x524 = x1*x12*x14*x186*x9 - x1*x227 + x10*x14*x21*x424 - x431 - x491
    x525 = x524*x82
    x526 = x515 + x517 + x519 + x521 + x523 + x525
    x527 = x509*x85 + x513*x85 + x526*x67
    x528 = x1*x352
    x529 = x134*(x1*x463 + x1*x465 + x409 + x464*x528 + x503) + x158*x509 + x158*x513 + x159*x526 + x160*x508 + x369*x512 + x67*(x25*(-x267*x528 + x353*x528 + x72) + x40*x522 + x43*(-x1*x270 + x115*x528 + x504) + x49*x520 + x51*(x1*x14*x186*x27*x31*x34 - x118*x528 - x500 - x506) + x524*x55)
    x530 = -x6
    x531 = x477*x530
    x532 = x425*x9
    x533 = x530*x532
    x534 = -x17*x533 + x2*x531
    x535 = x534*x83
    x536 = x427*x530
    x537 = -x14*x531 + x17*x536 + x456
    x538 = x537*x81
    x539 = x14*x21*x424*x530*x9 - x2*x536 - x451
    x540 = x539*x82
    x541 = x535 + x538 + x540
    x542 = 2*x536
    x543 = 2*x531
    x544 = 2*x533
    x545 = -x14*x542 - x17*x543 - x2*x544 - x423
    x546 = x304*x545
    x547 = x541*x67 + x546*x85
    x548 = x97*(x158*x546 + x159*x541 + x369*x545 + x67*(x40*x534 + x49*x537 + x539*x55))
    x549 = -x4
    x550 = x427*x549
    x551 = x14*x21*x424*x549*x9 - x2*x550
    x552 = x551*x82
    x553 = x477*x549
    x554 = x532*x549
    x555 = -x17*x554 + x2*x553 + x451
    x556 = x555*x83
    x557 = -x14*x553 + x17*x21*x424*x549*x6 - x422
    x558 = x557*x81
    x559 = x552 + x556 + x558
    x560 = 2*x550
    x561 = 2*x553
    x562 = 2*x554
    x563 = -x14*x560 - x17*x561 - x2*x562 - x475
    x564 = x304*x563
    x565 = x559*x67 + x564*x85
    x566 = x97*(x158*x564 + x159*x559 + x369*x563 + x67*(x40*x555 + x49*x557 + x55*x551))
    x567 = -x9
    x568 = x427*x567
    x569 = x477*x567
    x570 = -x14*x569 + x17*x568
    x571 = x570*x81
    x572 = x532*x567
    x573 = x14*x572 - x2*x568 + x422
    x574 = x573*x82
    x575 = -x17*x572 + x2*x21*x4*x424*x567 - x456
    x576 = x575*x83
    x577 = x571 + x574 + x576
    x578 = 2*x568
    x579 = 2*x569
    x580 = 2*x572
    x581 = -x14*x578 - x17*x579 - x2*x580 - x510
    x582 = x304*x581
    x583 = x577*x67 + x582*x85
    x584 = x97*(x158*x582 + x159*x577 + x369*x581 + x67*(x40*x575 + x49*x570 + x55*x573))
    x585 = x59*x94
    x586 = x92*(x148*x585 + x95*(2*x137 + 2*x139 + 2*x141))
    x587 = 3*o1
    x588 = 3*m1 - x587
    x589 = -x588
    x590 = x106*x589
    x591 = x27*x590
    x592 = x125*x31
    x593 = x100*(x128*x135 + x144*x26 + x147 + x46)
    x594 = x135*x590
    x595 = x256 + x47
    x596 = 2*x146
    x597 = x162*x590
    x598 = x14*x597
    x599 = -x154 + x173
    x600 = 2*x178
    x601 = x596 + x600
    x602 = (mpmath.mpf(1)/mpmath.mpf(2))*x149
    x603 = (mpmath.mpf(1)/mpmath.mpf(2))*x142
    x604 = x148*x99
    x605 = x169*x602 + x175*x604 + x176*x603
    x606 = x253*x590
    x607 = x135*x258
    x608 = x126 + x204
    x609 = x135*x36
    x610 = x154 + x346 - x609
    x611 = -x135*x14*x17*x186*x26*x34 + x28*x607 + x608 + x610
    x612 = x135*x260
    x613 = -x267*x612
    x614 = x2*x606 + x613
    x615 = x264*x590
    x616 = x212 + x353*x612
    x617 = -x17*x615 + x616
    x618 = x29*x590
    x619 = x118*x612
    x620 = x135*x35
    x621 = x31*x620
    x622 = -x146 + x621
    x623 = -x135*x15*x186*x31*x34 + x619 + x622
    x624 = x136*x229 + x138*x220 + x140*x224
    x625 = 2*x47
    x626 = x26*x620
    x627 = 2*x626
    x628 = x28*x612
    x629 = x31*x612
    x630 = x124*x628 + x125*x629 - x145 + x211 + x289*x607 + x625 - x627
    x631 = x296*x59
    x632 = x148*x631
    x633 = x200*x603 + x214*x604 + x215*x603 + x248*x602 + x295*x632
    x634 = 2*o1
    x635 = 2*m1 - x634
    x636 = -x635
    x637 = x135*x343
    x638 = x30*x590
    x639 = x17*x628
    x640 = x144 - x626
    x641 = x349*x590
    x642 = x135*x257
    x643 = x354*x642
    x644 = x272 - x31*x637 + x313 + x622 + x643
    x645 = x14*x641
    x646 = x2*x642
    x647 = x115*x646
    x648 = -x119
    x649 = x54 + x648
    x650 = x647 + x649
    x651 = x136*x318 + x138*x322 + x140*x324
    x652 = 4*o1
    x653 = 4*m1 - x652
    x654 = 2*x609
    x655 = x125*x267
    x656 = 2*x115*x612 + x127 - 2*x154 + x292 + x308 + x365*x637 + x642*x655 - x654
    x657 = x368*x632
    x658 = x303*x657 + x305*x603 + x315*x604 + x316*x603 + x340*x602
    x659 = x119 - x647
    x660 = x32*x590
    x661 = x135*x402
    x662 = -x267*x646 + x28*x661 + x405 + x610
    x663 = -x135*x14*x186*x2*x31*x34 + x26*x661 + x640
    x664 = x136*x386 + x138*x388 + x140*x384
    x665 = 2*x39
    x666 = 2*x621
    x667 = 2*x313
    x668 = x410*x661 - x596 + 2*x619 + 2*x643 + x665 - x666 + x667
    x669 = x374*x657 + x375*x603 + x382*x604 + x383*x603 + x397*x602
    x670 = x13*x642
    x671 = x45 + x609
    x672 = x289*x612
    x673 = x134*(x13*x672 + x416 + x464*x670 + x592*x670 + x627) + x420*x604 + x421*x603 + x438*x657 + x439*x603 + x460*x602 + x67*(x136*x453 + x138*x448 + x140*x458 + x25*(-x267*x670 + x353*x670 + x418) + x43*(x13*x135*x17*x186*x26*x34 - x13*x628 - x413 - x671) + x51*(-x118*x670 + x13*x629 + x621))
    x674 = x16*x642
    x675 = x134*(x16*x672 + x201 + x464*x674 + x470 + x592*x674 + x654) + x473*x604 + x474*x603 + x480*x657 + x481*x603 + x497*x602 + x67*(x136*x489 + x138*x495 + x140*x492 + x25*(-x267*x674 + x353*x674 + x471 - x621) + x43*(x115*x674 - x16*x628 - x467 + x626) + x51*(-x118*x674 + x135*x14*x16*x186*x31*x34))
    x676 = x1*x642
    x677 = x134*(x1*x672 + x464*x676 + x505 + x592*x676 + x666) + x508*x604 + x509*x603 + x512*x657 + x513*x603 + x526*x602 + x67*(x136*x524 + x138*x522 + x140*x520 + x25*(-x267*x676 + x353*x676 + x506 + x671) + x43*(x1*x135*x17*x186*x26*x34 - x1*x628 - x502) + x51*(x1*x135*x14*x186*x31*x34 - x118*x676 - x626))
    x678 = x97*(x541*x602 + x545*x657 + x546*x603 + x67*(x136*x539 + x138*x534 + x140*x537))
    x679 = x97*(x559*x602 + x563*x657 + x564*x603 + x67*(x136*x551 + x138*x555 + x140*x557))
    x680 = x97*(x577*x602 + x581*x657 + x582*x603 + x67*(x136*x573 + x138*x575 + x140*x570))
    x681 = x92*(x175*x585 + x95*(2*x164 + 2*x166 + 2*x168))
    x682 = 3*o2
    x683 = 3*m2 - x682
    x684 = -x683
    x685 = x106*x684
    x686 = x27*x685
    x687 = x100*(x128*x162 + x171*x26 + x174 + x52)
    x688 = x135*x685
    x689 = x14*x688
    x690 = x162*x685
    x691 = x14*x690
    x692 = x29*x685
    x693 = x253*x685
    x694 = x162*x258
    x695 = x162*x260
    x696 = x115*x695
    x697 = x162*x36
    x698 = -x178 + x697
    x699 = -x28*x694 + x696 + x698
    x700 = x264*x685
    x701 = -x353*x695
    x702 = x17*x700 + x701
    x703 = x210 + x267*x695
    x704 = -x2*x693 + x703
    x705 = x118*x695
    x706 = x162*x35
    x707 = x31*x706
    x708 = x173 + x346 - x707
    x709 = x31*x694 + x608 - x705 + x708
    x710 = x163*x224 + x165*x229 + x167*x220
    x711 = 2*x54
    x712 = x26*x706
    x713 = 2*x712
    x714 = x28*x695
    x715 = x31*x695
    x716 = x124*x714 + x125*x715 - x172 + x213 + x289*x694 + x711 - x713
    x717 = (mpmath.mpf(1)/mpmath.mpf(2))*x169
    x718 = (mpmath.mpf(1)/mpmath.mpf(2))*x176
    x719 = x175*x99
    x720 = x175*x631
    x721 = x200*x717 + x214*x719 + x215*x717 + x248*x718 + x295*x720
    x722 = x30*x685
    x723 = x162*x343
    x724 = -x17*x714 + x171 + x26*x723 - x712
    x725 = x349*x685
    x726 = -x162*x17*x186*x2*x28*x34 + x31*x723 + x345 + x708
    x727 = x14*x725
    x728 = x162*x257
    x729 = x2*x728
    x730 = x115*x729
    x731 = x48 - x730
    x732 = x163*x324 + x165*x318 + x167*x322
    x733 = 2*x37
    x734 = 2*x697
    x735 = x365*x723 - x600 + x655*x728 + x667 + 2*x696 + x733 - x734
    x736 = x368*x720
    x737 = x303*x736 + x305*x717 + x315*x719 + x316*x717 + x340*x718
    x738 = x595 + x730
    x739 = -x313
    x740 = 2*o2
    x741 = 2*m2 - x740
    x742 = -x741
    x743 = x162*x402
    x744 = x32*x685
    x745 = x267*x729
    x746 = x120 - x171 + x2*x715 + x212 - x26*x743 + x712
    x747 = x163*x384 + x165*x386 + x167*x388
    x748 = 4*o2
    x749 = 4*m2 - x748
    x750 = 2*x707
    x751 = x127 + x129 - 2*x173 + x291 + 2*x354*x728 + x378 + x410*x743 + 2*x705 - x750
    x752 = x374*x736 + x375*x717 + x382*x719 + x383*x717 + x397*x718
    x753 = x13*x728
    x754 = x45 + x707
    x755 = x289*x695
    x756 = x134*(x13*x755 + x419 + x464*x753 + x592*x753 + x713) + x420*x719 + x421*x717 + x438*x736 + x439*x717 + x460*x718 + x67*(x163*x458 + x165*x453 + x167*x448 + x25*(x13*x162*x186*x2*x28*x34 - x267*x753 - x415) + x43*(x13*x162*x17*x186*x26*x34 - x13*x714 - x697) + x51*(-x118*x753 + x13*x715 + x413 + x754))
    x757 = x16*x728
    x758 = x134*(x16*x755 + x464*x757 + x472 + x592*x757 + x734) + x473*x719 + x474*x717 + x480*x736 + x481*x717 + x497*x718 + x67*(x163*x492 + x165*x489 + x167*x495 + x25*(x16*x162*x186*x2*x28*x34 - x267*x757 - x469 - x754) + x43*(x115*x757 - x16*x714 + x712) + x51*(-x118*x757 + x16*x715 + x467))
    x759 = x1*x728
    x760 = -x502
    x761 = -x504
    x762 = x134*(x1*x755 + x201 + x464*x759 + x507 + x592*x759 + x750) + x508*x719 + x509*x717 + x512*x736 + x513*x717 + x526*x718 + x67*(x163*x520 + x165*x524 + x167*x522 + x25*(-x267*x759 + x353*x759 + x697 + x761) + x43*(-x1*x714 + x115*x759) + x51*(x1*x14*x162*x186*x31*x34 - x118*x759 - x712 - x760))
    x763 = x97*(x541*x718 + x545*x736 + x546*x717 + x67*(x163*x537 + x165*x539 + x167*x534))
    x764 = x97*(x559*x718 + x563*x736 + x564*x717 + x67*(x163*x557 + x165*x551 + x167*x555))
    x765 = x97*(x577*x718 + x581*x736 + x582*x717 + x67*(x163*x570 + x165*x573 + x167*x575))
    x766 = x88*x93/x65**2
    x767 = x92*(x197*x766 + x214*x585 + x95*(2*x221 + 2*x225 + 2*x230 + 2*x235 + 2*x241 + 2*x247))
    x768 = x103*x106
    x769 = x27*x768
    x770 = x100*(x204*x26 + x207 + x208 + x212*x31 + x329 + x330 + x332 - x58)
    x771 = x135*x768
    x772 = x162*x768
    x773 = x14*x772
    x774 = x62*x64*x98/x65**(mpmath.mpf(5)/mpmath.mpf(2))
    x775 = x199*x85
    x776 = x775*(-x189 - x192 - x195 + x42)
    x777 = -4*p0
    x778 = x283 + x777
    x779 = -x778
    x780 = x20**(mpmath.mpf(-5)/mpmath.mpf(2))
    x781 = -3*p0
    x782 = x102 + x781
    x783 = -x782
    x784 = x780*x783
    x785 = x15*x784
    x786 = x12*x6
    x787 = 2*x786
    x788 = x12*x4
    x789 = x17*x788
    x790 = x122*x784
    x791 = x12*x9
    x792 = x2*x784
    x793 = x791*x792
    x794 = x435 + x437
    x795 = x433 + x794
    x796 = x304*x85
    x797 = x59*x85
    x798 = x203*x26
    x799 = x257*x29
    x800 = x29*x768
    x801 = x44*x785
    x802 = x253*x768
    x803 = x264*x768
    x804 = x28*x44
    x805 = x17*x804
    x806 = x44*x792
    x807 = x260*x264
    x808 = 4*x2*x807
    x809 = 4*x45
    x810 = x253*x260
    x811 = x209*x26
    x812 = 2*x811
    x813 = x28*x312
    x814 = 2*x813
    x815 = x31*x417
    x816 = 2*x815
    x817 = -x812 - x814 - x816
    x818 = x132 + 4*x17*x810 + x809 + x817
    x819 = -x320
    x820 = x14*x784
    x821 = x2*x820
    x822 = x788*x821
    x823 = x17*x820
    x824 = x218 - x791*x823
    x825 = -2*p0
    x826 = x250 + x825
    x827 = -x826
    x828 = x17*x786
    x829 = -x222
    x830 = x191 + x829
    x831 = -x194 + x227
    x832 = x44*x820
    x833 = x353*x832
    x834 = x17*x803
    x835 = x124*x807
    x836 = x125*x810
    x837 = x2*x802 - x267*x832
    x838 = x31*x312
    x839 = x28*x417
    x840 = -x839
    x841 = x838 + x840
    x842 = x112 + x841
    x843 = x26*x36
    x844 = 2*x843
    x845 = x203*x28
    x846 = 2*x258
    x847 = x253*x846
    x848 = x17*x799
    x849 = x122*x848
    x850 = x209*x28
    x851 = x26*x312
    x852 = -x851
    x853 = x850 + x852
    x854 = x117 + x853
    x855 = x203*x31
    x856 = x264*x35
    x857 = 2*x856
    x858 = x2*x799
    x859 = x122*x858
    x860 = x264*x846
    x861 = x26*x417
    x862 = x209*x31
    x863 = -x862
    x864 = x861 + x863
    x865 = x649 + x864
    x866 = x18*x784
    x867 = -x432
    x868 = x434 + x867
    x869 = x792*x828
    x870 = x44*x866
    x871 = x30*x768
    x872 = x309 + x813
    x873 = -x206 + x608 - x811
    x874 = -x128 + x18*x799 - x258*x30 - x307 + x872 + x873
    x875 = x44*x784
    x876 = x354*x875
    x877 = x17*x349
    x878 = x2*x30
    x879 = x260*x878
    x880 = x264*x343
    x881 = x2*x253
    x882 = x17*x257
    x883 = -x260*x877 + x881*x882
    x884 = x120 + x278 + x856 + x862 + x879 - x880 + x883
    x885 = x349*x768
    x886 = x31*x36
    x887 = x2*x848 - x258*x349 + x739 + x886
    x888 = x115*x806 - x14*x885 + x887
    x889 = x260*x881
    x890 = x111 - x14*x17*x186*x26*x31*x34 + x838 + x889
    x891 = x220*x338 + x224*x334 + x229*x327 + x234*x322 + x240*x324 + x246*x318
    x892 = x122*x875
    x893 = x2*x264
    x894 = x124*x257*x893
    x895 = 2*x343
    x896 = x253*x895
    x897 = 2*x851
    x898 = 2*x850
    x899 = x260*x30
    x900 = x124*x899
    x901 = x260*x349
    x902 = x125*x901
    x903 = -4*x210 - x363 - x625 - 4*x843 + x847 + x849 + x894 + x896 - x897 - x898 + x900 + x902
    x904 = 2*x788
    x905 = 2*x222
    x906 = -x905
    x907 = 2*x191
    x908 = -x907
    x909 = x906 + x908
    x910 = (mpmath.mpf(1)/mpmath.mpf(2))*x248
    x911 = (mpmath.mpf(1)/mpmath.mpf(2))*x340
    x912 = x214*x99
    x913 = x196*x774
    x914 = x295*x631
    x915 = x303*x368
    x916 = x214*x631
    x917 = x200*x911 + x215*x911 + x303*x913 + x305*x910 + x315*x912 + x315*x914 + x316*x910 + x915*x916
    x918 = x17*x791
    x919 = x19*x784
    x920 = x436 + x867
    x921 = x17*x807 + x272 + x839 - x889
    x922 = x44*x919
    x923 = x17*x32
    x924 = -x850
    x925 = x2*x349
    x926 = x264*x882
    x927 = x2*x926
    x928 = -x843
    x929 = x210 + x253*x402 - x260*x923 + x928
    x930 = x260*x925 + x47 + x924 - x927 + x929
    x931 = x379 + x815
    x932 = -x130 - x377 + x931
    x933 = -x15*x186*x32*x34 + x19*x799 + x873 + x932
    x934 = x220*x395 + x224*x390 + x229*x392 + x234*x388 + x240*x384 + x246*x386
    x935 = x125*x32
    x936 = x257*x881
    x937 = x124*x936
    x938 = x260*x32
    x939 = x125*x938
    x940 = 2*x861
    x941 = 2*x862
    x942 = 2*x402
    x943 = x264*x942
    x944 = x124*x901 - 4*x212 - x408 - x711 - 4*x856 + x859 + x860 + x937 + x939 - x940 - x941 + x943
    x945 = 2*x791
    x946 = x786*x792
    x947 = x124*x788
    x948 = 2*x227
    x949 = -x948
    x950 = 2*x194
    x951 = -x950
    x952 = x949 + x951
    x953 = (mpmath.mpf(1)/mpmath.mpf(2))*x397
    x954 = x368*x916
    x955 = x200*x953 + x215*x953 + x374*x913 + x374*x954 + x375*x910 + x382*x912 + x382*x914 + x383*x910
    x956 = x13*x784
    x957 = x13*x788
    x958 = x13*x190
    x959 = x186*x424
    x960 = x14*x959
    x961 = x17*x7
    x962 = x960*x961
    x963 = x15*x959
    x964 = x6*x963
    x965 = x4*x964
    x966 = x14*x217
    x967 = x428 - x966
    x968 = x222 + x958 + x962 - x965 + x967
    x969 = -x218
    x970 = x17*x960
    x971 = x9*x970
    x972 = x6*x971
    x973 = x2*x960
    x974 = x4*x6
    x975 = x973*x974
    x976 = x320 + x975
    x977 = x969 - x972 + x976
    x978 = x13*x193
    x979 = x7*x973
    x980 = x14*x187
    x981 = x2*x980
    x982 = x430 - x981
    x983 = -x15*x186*x424*x6*x9 + x227 + x978 + x979 + x982
    x984 = x13*x810
    x985 = x13*x832
    x986 = x13*x845
    x987 = x415 - x986
    x988 = x13*x875
    x989 = x13*x936
    x990 = -x13*x926
    x991 = -x838
    x992 = x839 + x991
    x993 = x989 + x990 + x992
    x994 = -x861
    x995 = x13*x855
    x996 = x13*x807
    x997 = -x13*x858 + x418 + x856 + x994 - x995 + x996
    x998 = x220*x440 + x224*x444 + x229*x442 + x234*x448 + x240*x458 + x246*x453
    x999 = x124*x804
    x1000 = x13*x798
    x1001 = x122*x799
    x1002 = x13*x257
    x1003 = x124*x253
    x1004 = x125*x264
    x1005 = x291 + x816
    x1006 = -2*x1000 + x1001*x13 + x1002*x1003 + x1002*x1004 + x1005 + 2*x206 - x414 + x814
    x1007 = x122*x786
    x1008 = x125*x791
    x1009 = 2*x188
    x1010 = 2*x7
    x1011 = x9*x973
    x1012 = x1011*x6
    x1013 = 2*x1012
    x1014 = 2*x22
    x1015 = x970*x974
    x1016 = x1014 + 2*x1015
    x1017 = -x1009 + x1010*x963 + x1013 + x1016 - 2*x12*x13*x186*x6 - 2*x21*x424*x7 + x794
    x1018 = (mpmath.mpf(1)/mpmath.mpf(2))*x460
    x1019 = x1018*x200 + x1018*x215 + x420*x912 + x420*x914 + x421*x910 + x438*x913 + x438*x954 + x439*x910
    x1020 = x16*x784
    x1021 = x16*x788
    x1022 = -x22
    x1023 = x1015 + x1022
    x1024 = x16*x190
    x1025 = x1024 + x476
    x1026 = x188 + x432
    x1027 = x1023 + x1025 + x1026 - x8*x963
    x1028 = x4*x971
    x1029 = -x8*x973 + x981
    x1030 = x1028 + x1029 + x194
    x1031 = x16*x193
    x1032 = x4*x963
    x1033 = -x1032*x9 + x478
    x1034 = x1031 + x1033 + x975
    x1035 = x16*x875
    x1036 = x16*x810
    x1037 = x206 + x346 + x811
    x1038 = x16*x845
    x1039 = x1038 - x469
    x1040 = -x1036 + x1037 + x1039 + x16*x848
    x1041 = x16*x936
    x1042 = x16*x926 + x856
    x1043 = -x1041 + x1042 + x862
    x1044 = x16*x855
    x1045 = x1044 - x471
    x1046 = x1045 - x14*x16*x186*x26*x31*x34 + x16*x858
    x1047 = x220*x486 + x224*x484 + x229*x482 + x234*x495 + x240*x492 + x246*x489
    x1048 = x16*x798
    x1049 = 2*x1048
    x1050 = x16*x257
    x1051 = x1001*x16 + x1003*x1050 + x1004*x1050 - x1049 - x468 + x844 + x898
    x1052 = x16*x226
    x1053 = 2*x1052
    x1054 = x8*x970
    x1055 = x1011*x4
    x1056 = 2*x428
    x1057 = 2*x966
    x1058 = -x1056 - x1057
    x1059 = -x1053 + 2*x1054 + 2*x1055 + x1058 + x907 + 2*x965
    x1060 = (mpmath.mpf(1)/mpmath.mpf(2))*x497
    x1061 = x1060*x200 + x1060*x215 + x473*x912 + x473*x914 + x474*x910 + x480*x913 + x480*x954 + x481*x910
    x1062 = x1*x784
    x1063 = x1*x788
    x1064 = x1*x190
    x1065 = x1033 + x1064 + x972
    x1066 = -x10*x970 + x966
    x1067 = x1055 + x1066 + x191
    x1068 = x1012 + x1022
    x1069 = x1*x193
    x1070 = x1069 + x511
    x1071 = -x10*x15*x186*x424 + x1026 + x1068 + x1070
    x1072 = x1*x875
    x1073 = x1*x845
    x1074 = x1*x810
    x1075 = x1*x848 + x1073 - x1074 + x761
    x1076 = x1*x926
    x1077 = x1*x936 + x843
    x1078 = -x1076 + x1077 + x850
    x1079 = x1*x855
    x1080 = x1079 - x506
    x1081 = -x1*x14*x186*x26*x31*x34 + x1*x858 + x1037 + x1080
    x1082 = x220*x516 + x224*x514 + x229*x518 + x234*x522 + x240*x520 + x246*x524
    x1083 = x1*x798
    x1084 = 2*x1083
    x1085 = x1*x257
    x1086 = x1*x1001 + x1003*x1085 + x1004*x1085 - x1084 - x503 + x857 + x941
    x1087 = x1*x226
    x1088 = 2*x1087
    x1089 = x10*x973
    x1090 = 2*x430
    x1091 = 2*x981
    x1092 = -x1090 - x1091
    x1093 = 2*x1028 - x1088 + 2*x1089 + x1092 + 2*x9*x964 + x950
    x1094 = (mpmath.mpf(1)/mpmath.mpf(2))*x526
    x1095 = x1094*x200 + x1094*x215 + x508*x912 + x508*x914 + x509*x910 + x512*x913 + x512*x954 + x513*x910
    x1096 = x4*x973
    x1097 = x1096*x530
    x1098 = -x530*x971
    x1099 = x530*x6
    x1100 = x1099*x970
    x1101 = x1099*x973
    x1102 = (mpmath.mpf(1)/mpmath.mpf(2))*x541
    x1103 = -x1014
    x1104 = 2*x964
    x1105 = x4*x530
    x1106 = x1105*x970
    x1107 = x1011*x530
    x1108 = x1102*x200 + x1102*x215 + x545*x913 + x545*x954 + x546*x910 + x67*(x234*x534 + x240*x537 + x246*x539 + x81*(-x1032*x530 + x1100 + x531 + x966) + x82*(-x1101 + x15*x186*x424*x530*x9 - x533 - x981) + x83*(x1097 + x1098)) + x796*(-x1009 - x1103 - x1104*x530 - 2*x1106 - 2*x1107 + x542)
    x1109 = x549*x6
    x1110 = x1109*x973
    x1111 = -x549*x971
    x1112 = x1096*x549 + x981
    x1113 = x1109*x970
    x1114 = -x188 + x22
    x1115 = (mpmath.mpf(1)/mpmath.mpf(2))*x559
    x1116 = x4*x549
    x1117 = x1116*x970
    x1118 = x1011*x549
    x1119 = x1115*x200 + x1115*x215 + x563*x913 + x563*x954 + x564*x910 + x67*(x234*x555 + x240*x557 + x246*x551 + x81*(-x1032*x549 + x1113 + x1114 + x553) + x82*(-x1110 + x15*x186*x424*x549*x9 - x554) + x83*(x1111 + x1112)) + x796*(-x1057 - x1104*x549 - 2*x1117 - 2*x1118 + x560)
    x1120 = x567*x6
    x1121 = x1120*x970
    x1122 = -x1096*x567
    x1123 = x567*x971 + x966
    x1124 = x1120*x973
    x1125 = (mpmath.mpf(1)/mpmath.mpf(2))*x577
    x1126 = x4*x567
    x1127 = x1126*x970
    x1128 = x1011*x567
    x1129 = x1125*x200 + x1125*x215 + x581*x913 + x581*x954 + x582*x910 + x67*(x234*x575 + x240*x570 + x246*x573 + x81*(-x1032*x567 + x1121 + x569) + x82*(-x1114 - x1124 + x15*x186*x424*x567*x9 - x572) + x83*(-x1122 - x1123)) + x796*(-x1091 - x1104*x567 - 2*x1127 - 2*x1128 + x578)
    x1130 = x63*x766
    x1131 = x92*(x1130*x303 + x315*x585 + x95*(2*x319 + 2*x323 + 2*x325 + 2*x328 + 2*x335 + 2*x339))
    x1132 = x106*x588
    x1133 = x1132*x27
    x1134 = x100*(x237 + x239 + x28*x307 + x310 + x314 + x394)
    x1135 = x1132*x135
    x1136 = x1132*x162
    x1137 = x1136*x14
    x1138 = -3*p1
    x1139 = x1138 + x587
    x1140 = -x1139
    x1141 = x1140*x780
    x1142 = x1141*x15
    x1143 = x1141*x14
    x1144 = x1143*x2
    x1145 = x1144*x788
    x1146 = -x1143*x918 + x194
    x1147 = x1132*x29
    x1148 = x1142*x44
    x1149 = x1143*x44
    x1150 = x1132*x14
    x1151 = x1149*x353
    x1152 = x1132*x17
    x1153 = x1152*x264
    x1154 = x1132*x881 - x1149*x267
    x1155 = x1141*x122
    x1156 = x31*x44
    x1157 = x1141*x2
    x1158 = x1157*x122
    x1159 = x775*(-x223 + x23 - x301 - x302)
    x1160 = -4*p1
    x1161 = x1160 + x652
    x1162 = -x1161
    x1163 = x1141*x18
    x1164 = x124*x791
    x1165 = x124*x30
    x1166 = x1163*x44
    x1167 = x1132*x122
    x1168 = x1132*x349
    x1169 = x1141*x44
    x1170 = x1169*x122
    x1171 = 4*x882*x925
    x1172 = -x227
    x1173 = x1157*x828
    x1174 = -2*p1
    x1175 = x1174 + x634
    x1176 = -x1175
    x1177 = x218 + x819
    x1178 = x862 + x994
    x1179 = x1157*x44
    x1180 = x115*x1179 - x1150*x349
    x1181 = x14*x30
    x1182 = x1143*x804
    x1183 = 2*x886
    x1184 = x349*x895
    x1185 = x257*x878
    x1186 = x1185*x124
    x1187 = x1169*x354
    x1188 = x1141*x19
    x1189 = -x434 + x436
    x1190 = -x856
    x1191 = x119 + x1190 + x212 - x879 + x880 + x883 + x994
    x1192 = x1188*x44
    x1193 = x30*x402 - x309 - x32*x343 + x345 - x813 + x932
    x1194 = -x14*x186*x2*x28*x31*x34 + x48 + x852 + x927 + x929
    x1195 = x318*x392 + x322*x395 + x324*x390 + x327*x386 + x334*x384 + x338*x388
    x1196 = x349*x942
    x1197 = 2*x839
    x1198 = 2*x838
    x1199 = x257*x923
    x1200 = x1199*x125
    x1201 = x1184 + x1186 + x1196 - x1197 - x1198 + x1200 - 4*x313 - x665 - x733 + x835 + x836 - 4*x886
    x1202 = x1157*x786
    x1203 = 2*x320
    x1204 = -x1203
    x1205 = 2*x218
    x1206 = -x1205
    x1207 = x1204 + x1206
    x1208 = x315*x99
    x1209 = x303*x774
    x1210 = x631*x915
    x1211 = x368*x374
    x1212 = x315*x631
    x1213 = x1208*x382 + x1209*x374 + x1210*x382 + x1211*x1212 + x305*x953 + x316*x953 + x375*x911 + x383*x911
    x1214 = x300 + x434
    x1215 = x13*x226
    x1216 = x1215 + x426
    x1217 = x1023 + x1214 + x1216 - x18*x186*x424*x7
    x1218 = x1141*x13
    x1219 = x2*x959
    x1220 = x1219*x17
    x1221 = x1220*x974
    x1222 = x18*x959
    x1223 = x1222*x6
    x1224 = -x1223*x9 + x430
    x1225 = x1221 + x1224 + x978
    x1226 = x1143*x13
    x1227 = x2*x217
    x1228 = -x1219*x961 + x1227
    x1229 = x1228 + x218 + x972
    x1230 = x346 + x872
    x1231 = x1000 - x413
    x1232 = x1230 + x1231 - x13*x17*x186*x26*x28*x34 + x13*x899
    x1233 = x1169*x13
    x1234 = x1185*x13 - x13*x349*x882 - x418 + x995
    x1235 = x13*x901 + x886
    x1236 = x1235 + x838 - x989
    x1237 = x318*x442 + x322*x440 + x324*x444 + x327*x453 + x334*x458 + x338*x448
    x1238 = x1156*x125
    x1239 = 2*x986
    x1240 = x1165*x257
    x1241 = x125*x349
    x1242 = x1002*x1241 - x1239 + x1240*x13 - x416 + x844 + x897 + 2*x984
    x1243 = x1141*x124
    x1244 = 2*x958
    x1245 = x1220*x9
    x1246 = x1245*x6
    x1247 = x1058 + 2*x1223*x4 - x1244 + 2*x1246 + x905 + 2*x962
    x1248 = x1212*x368
    x1249 = x1018*x305 + x1018*x316 + x1208*x420 + x1209*x438 + x1210*x420 + x1248*x438 + x421*x911 + x439*x911
    x1250 = x1052 + x1054 - x18*x186*x4*x424*x6 + x191 + x967
    x1251 = x1141*x16
    x1252 = x1220*x8
    x1253 = x1222*x9
    x1254 = x1253*x4
    x1255 = -x1227 + x478
    x1256 = x1031 + x1252 - x1254 + x1255 + x320
    x1257 = -x1028 + x1221 + x831
    x1258 = x1169*x16
    x1259 = x16*x882
    x1260 = -x1048 + x467
    x1261 = x1259*x253 + x1260 - x16*x899 + x843 + x924
    x1262 = x1259*x349
    x1263 = -x16*x901
    x1264 = x1041 + x1263 + x864
    x1265 = x318*x482 + x322*x486 + x324*x484 + x327*x489 + x334*x492 + x338*x495
    x1266 = x1005 + 2*x1036 - 2*x1038 + x1050*x1241 + x1240*x16 + 2*x309 - x470 + x812
    x1267 = 2*x300
    x1268 = 2*x1222
    x1269 = x1245*x4
    x1270 = 2*x1269 + x433
    x1271 = x1016 - 2*x12*x16*x186*x4 - x1267 + x1268*x8 + x1270 - 2*x21*x424*x8 + x437
    x1272 = x1060*x305 + x1060*x316 + x1208*x473 + x1209*x480 + x1210*x473 + x1248*x480 + x474*x911 + x481*x911
    x1273 = x1028 + x1087 + x1224
    x1274 = x1*x1141
    x1275 = x1022 + x1269
    x1276 = -x10*x1222 + x1070 + x1214 + x1275
    x1277 = x1246 + x222
    x1278 = x1066 + x1277
    x1279 = x1*x1169
    x1280 = x1*x882
    x1281 = -x1083 + x502
    x1282 = -x1*x899 + x1280*x253 + x1281
    x1283 = x1*x1185 + x1080 + x1230 - x1280*x349
    x1284 = -x1*x901
    x1285 = x1077 + x1284 + x851
    x1286 = x318*x518 + x322*x516 + x324*x514 + x327*x524 + x334*x520 + x338*x522
    x1287 = 2*x1073
    x1288 = x1*x1240 + 2*x1074 + x1085*x1241 + x1183 + x1198 - x1287 - x505
    x1289 = 2*x1064
    x1290 = x10*x1220
    x1291 = 2*x478
    x1292 = 2*x1227
    x1293 = -x1291 - x1292
    x1294 = x1205 + 2*x1254 - x1289 + 2*x1290 + x1293 + 2*x972
    x1295 = x1094*x305 + x1094*x316 + x1208*x508 + x1209*x512 + x1210*x508 + x1248*x512 + x509*x911 + x513*x911
    x1296 = x1105*x1220
    x1297 = x1099*x1220 + x1227
    x1298 = x22 - x300
    x1299 = x1245*x530
    x1300 = x1102*x305 + x1102*x316 + x1209*x545 + x1248*x545 + x546*x911 + x67*(x327*x539 + x334*x537 + x338*x534 + x81*(-x1106 - x1298 + x18*x186*x424*x530*x6 - x536) + x82*(-x1098 - x1297) + x83*(-x1253*x530 + x1296 + x533)) + x796*(-x1057 - 2*x1100 - x1105*x1268 - 2*x1299 + x543)
    x1301 = x1109*x1220
    x1302 = x1116*x1220
    x1303 = x1245*x549
    x1304 = x1115*x305 + x1115*x316 + x1209*x563 + x1248*x563 + x564*x911 + x67*(x327*x551 + x334*x557 + x338*x555 + x81*(-x1117 + x18*x186*x424*x549*x6 - x550 - x966) + x82*(-x1111 - x1301) + x83*(x1227 - x1253*x549 + x1302 + x554)) + x796*(-x1103 - 2*x1113 - x1116*x1268 - x1267 - 2*x1303 + x561)
    x1305 = x1120*x1220
    x1306 = x1126*x1220
    x1307 = x1245*x567
    x1308 = x1125*x305 + x1125*x316 + x1209*x581 + x1248*x581 + x582*x911 + x67*(x327*x573 + x334*x570 + x338*x575 + x81*(-x1127 + x18*x186*x424*x567*x6 - x568) + x82*(x1123 - x1305) + x83*(-x1253*x567 + x1298 + x1306 + x572)) + x796*(-2*x1121 - x1126*x1268 - x1292 - 2*x1307 + x579)
    x1309 = x92*(x1130*x374 + x382*x585 + x95*(2*x385 + 2*x387 + 2*x389 + 2*x391 + 2*x393 + 2*x396))
    x1310 = x106*x683
    x1311 = x1310*x27
    x1312 = x100*(x242 - x243 + x244 + x31*x377 + x336 + x337 + x380 + x381)
    x1313 = x1310*x135
    x1314 = x1310*x162
    x1315 = x1314*x14
    x1316 = -3*p2
    x1317 = x1316 + x682
    x1318 = -x1317
    x1319 = x1318*x780
    x1320 = x1319*x15
    x1321 = x1319*x14
    x1322 = x1321*x918
    x1323 = x1321*x2
    x1324 = -x1323*x788 + x191
    x1325 = x1310*x29
    x1326 = x1320*x44
    x1327 = x1321*x44
    x1328 = x1310*x14
    x1329 = x1327*x353
    x1330 = x1310*x17
    x1331 = x1330*x264
    x1332 = x1310*x881 - x1327*x267
    x1333 = x122*x1319
    x1334 = x1319*x2
    x1335 = x122*x1334
    x1336 = x775*(-x228 + x24 - x321 - x373)
    x1337 = x1319*x18
    x1338 = x1334*x828
    x1339 = x1337*x44
    x1340 = x1321*x804
    x1341 = x1319*x44
    x1342 = x1341*x354
    x1343 = x1334*x44
    x1344 = x115*x1343 - x1328*x349
    x1345 = x122*x1310
    x1346 = x122*x1341
    x1347 = -4*p2
    x1348 = x1347 + x748
    x1349 = -x1348
    x1350 = x1319*x19
    x1351 = x1334*x786
    x1352 = x1350*x44
    x1353 = x124*x349
    x1354 = -2*p2
    x1355 = x1354 + x740
    x1356 = -x1355
    x1357 = x1228 + x976
    x1358 = x13*x1319
    x1359 = x19*x959
    x1360 = x1359*x4
    x1361 = -x1360*x6 + x428
    x1362 = x1246 + x1361 + x958
    x1363 = x13*x1321
    x1364 = x372 + x436
    x1365 = x1068 + x1216 - x1359*x7 + x1364
    x1366 = x1235 + x839 + x990
    x1367 = x13*x1341
    x1368 = x1002*x925 - x1199*x13 + x987
    x1369 = x346 + x931
    x1370 = -x1002*x893 + x1231 + x13*x938 + x1369
    x1371 = x384*x444 + x386*x442 + x388*x440 + x390*x458 + x392*x453 + x395*x448
    x1372 = 2*x995
    x1373 = x1002*x1353 + x1002*x935 - x1372 - x419 + x857 + x940 + 2*x996
    x1374 = x124*x1319
    x1375 = 2*x978
    x1376 = x1359*x6
    x1377 = x1376*x9
    x1378 = x1092 + 2*x1221 - x1375 + 2*x1377 + x948 + 2*x979
    x1379 = x382*x99
    x1380 = x374*x774
    x1381 = x1211*x631
    x1382 = x368*x438
    x1383 = x382*x631
    x1384 = x1018*x375 + x1018*x383 + x1379*x420 + x1380*x438 + x1381*x420 + x1382*x1383 + x421*x953 + x439*x953
    x1385 = x1319*x16
    x1386 = x1029 + x1221 + x227
    x1387 = x1025 + x1275 + x1364 - x186*x19*x424*x8
    x1388 = x1052 + x1055 + x1361
    x1389 = x1341*x16
    x1390 = x1042 + x1263 + x861
    x1391 = x1039 + x1199*x16 + x1369 - x16*x186*x2*x28*x31*x34
    x1392 = x1050*x893 + x1260 - x14*x16*x186*x32*x34
    x1393 = x384*x484 + x386*x482 + x388*x486 + x390*x492 + x392*x489 + x395*x495
    x1394 = 2*x1044
    x1395 = x1050*x1353 + x1050*x935 + x1183 + x1197 - x1394 + 2*x16*x807 - x472
    x1396 = 2*x1031
    x1397 = x1203 + 2*x1252 + x1293 + 2*x1360*x9 - x1396 + 2*x975
    x1398 = x1383*x368
    x1399 = x1060*x375 + x1060*x383 + x1379*x473 + x1380*x480 + x1381*x473 + x1398*x480 + x474*x953 + x481*x953
    x1400 = x1*x1319
    x1401 = -x191
    x1402 = -x1055 + x1277 + x1401
    x1403 = x1064 + x1255 + x1290 - x186*x19*x4*x424*x9 + x218
    x1404 = x1087 + x1089 - x1377 + x194 + x982
    x1405 = x1*x1341
    x1406 = x851 + x924
    x1407 = x1076 + x1284 + x1406
    x1408 = -x1*x1199 - x1073 + x1085*x925 + x504 + x886 + x991
    x1409 = x1085*x893
    x1410 = x384*x514 + x386*x518 + x388*x516 + x390*x520 + x392*x524 + x395*x522
    x1411 = 2*x1*x807 - 2*x1079 + x1085*x1353 + x1085*x935 + x291 + 2*x379 - x507 + x812 + x814
    x1412 = 2*x372
    x1413 = 2*x1359
    x1414 = -2*x1*x12*x186*x9 + x10*x1413 - 2*x10*x21*x424 + x1013 + x1014 + x1270 - x1412 + x435
    x1415 = x1094*x375 + x1094*x383 + x1379*x508 + x1380*x512 + x1381*x508 + x1398*x512 + x509*x953 + x513*x953
    x1416 = x22 - x372
    x1417 = x1413*x9
    x1418 = x1102*x375 + x1102*x383 + x1380*x545 + x1398*x545 + x546*x953 + x67*(x390*x537 + x392*x539 + x395*x534 + x81*(-x1097 + x1297) + x82*(x1107 - x1376*x530 + x1416 + x536) + x83*(-x1299 + x186*x19*x4*x424*x530 - x531)) + x796*(-x1091 - 2*x1101 - 2*x1296 - x1417*x530 + x544)
    x1419 = x1115*x375 + x1115*x383 + x1380*x563 + x1398*x563 + x564*x953 + x67*(x390*x557 + x392*x551 + x395*x555 + x81*(-x1112 + x1301) + x82*(x1118 - x1376*x549 + x550) + x83*(-x1303 - x1416 + x186*x19*x4*x424*x549 - x553)) + x796*(-2*x1110 - x1292 - 2*x1302 - x1417*x549 + x562)
    x1420 = x1125*x375 + x1125*x383 + x1380*x581 + x1398*x581 + x582*x953 + x67*(x390*x570 + x392*x573 + x395*x575 + x81*(x1122 + x1305) + x82*(x1128 - x1376*x567 + x568 + x981) + x83*(-x1227 - x1307 + x186*x19*x4*x424*x567 - x569)) + x796*(-x1103 - 2*x1124 - 2*x1306 - x1412 - x1417*x567 + x580)
    x1421 = x92*(x1130*x438 + x420*x585 + x95*(2*x441 + 2*x443 + 2*x445 + 2*x449 + 2*x454 + 2*x459))
    x1422 = x100*(x26*x413 + x28*x415 + x31*x418 + x331)
    x1423 = x780*x782
    x1424 = x1423*x15
    x1425 = x14*x1423
    x1426 = x1425*x2
    x1427 = x1426*x788
    x1428 = x1425*x918
    x1429 = x1424*x44
    x1430 = x1425*x44
    x1431 = x1430*x353
    x1432 = x1430*x267
    x1433 = x122*x1423
    x1434 = x1423*x2
    x1435 = x122*x1434
    x1436 = x775*(-x13*x432 - x13*x434 - x13*x436 - x14*x426 - x42 + x422 - x429 - x431)
    x1437 = x1423*x18
    x1438 = -x1434*x828
    x1439 = x1425*x804
    x1440 = x1437*x44
    x1441 = x1423*x44
    x1442 = x1441*x354
    x1443 = x1434*x44
    x1444 = -x115*x1443
    x1445 = x122*x1441
    x1446 = x1423*x19
    x1447 = x1446*x44
    x1448 = x1434*x786
    x1449 = x13*x1441
    x1450 = x13*x1423
    x1451 = 4*n0 + x777
    x1452 = 3*n0 + x781
    x1453 = x11**(mpmath.mpf(-5)/mpmath.mpf(2))
    x1454 = x1453*x21
    x1455 = x1452*x1454
    x1456 = x14*x1455
    x1457 = x13*x960
    x1458 = x124*x1455
    x1459 = x1455*x2
    x1460 = x6*x9
    x1461 = x1459*x1460
    x1462 = x124*x1423
    x1463 = x17*x959
    x1464 = x13*x1463
    x1465 = x1464*x974
    x1466 = x1219*x13
    x1467 = x1460*x1466
    x1468 = x14*x427
    x1469 = 2*x1468
    x1470 = x17*x477
    x1471 = 2*x1470
    x1472 = x2*x532
    x1473 = 2*x1472
    x1474 = -x1469 - x1471 - x1473
    x1475 = -4*x12*x21 + x1474 - x433 - x435 - x437
    x1476 = x13*x1425
    x1477 = x1459*x974
    x1478 = x1455*x17
    x1479 = -x1460*x1478
    x1480 = x124*x959
    x1481 = x13*x1480
    x1482 = 2*x13
    x1483 = x1482*x974
    x1484 = x17*x532
    x1485 = x2*x477
    x1486 = x1484 - x1485
    x1487 = x1177 + x1486
    x1488 = x13*x217
    x1489 = 2*x1488
    x1490 = 2*n0 + x825
    x1491 = -x1490
    x1492 = x1456*x974
    x1493 = x17*x427
    x1494 = x14*x477
    x1495 = x1493 - x1494
    x1496 = x1244 + x1483*x960
    x1497 = x187*x2
    x1498 = x13*x1497
    x1499 = 2*x1498
    x1500 = x2*x425
    x1501 = x1456*x1460
    x1502 = x2*x427
    x1503 = x14*x532
    x1504 = x1502 - x1503
    x1505 = x1482*x960
    x1506 = x1375 + x1460*x1505
    x1507 = x1423*x16
    x1508 = x16*x217
    x1509 = x13*x8
    x1510 = x16*x974
    x1511 = x1510*x960
    x1512 = x13*x980
    x1513 = x1468 + x1512
    x1514 = x1216 + x1513
    x1515 = -x1024 + x1465 - x1470 - x1508 - x1509*x960 - x1511 + x1514 + x16*x959*x961 - x476
    x1516 = x4*x9
    x1517 = x1498 + x1502
    x1518 = x1460*x16
    x1519 = x1463*x1518 + x430
    x1520 = -x13*x186*x2*x424*x8 + x1464*x1516 + x1517 + x1519 - x16*x186*x2*x4*x424*x6 + x978
    x1521 = x1425*x16
    x1522 = x1457*x1516 + x478
    x1523 = x1456*x1516 + x1522
    x1524 = x1219*x7
    x1525 = x1518*x960
    x1526 = x1497*x16
    x1527 = x1485 + x1526
    x1528 = x1031 - x1466*x974 - x1524*x16 + x1525 + x1527
    x1529 = x1441*x16
    x1530 = x1000 - x1038
    x1531 = x440*x495 + x442*x489 + x444*x492 + x448*x486 + x453*x482 + x458*x484
    x1532 = x1049 + x1239
    x1533 = x124*x8
    x1534 = x1459*x1516
    x1535 = 2*x1493
    x1536 = -x1535
    x1537 = 2*x1494
    x1538 = -x1537
    x1539 = x16*x980
    x1540 = 2*x1539
    x1541 = x1010*x960
    x1542 = 2*x1219
    x1543 = x1219*x1482
    x1544 = x1053 + x1480*x1510
    x1545 = x1480*x1509 - x1489 + x1496 + x1516*x1543 + x1518*x1542 + x1536 + x1538 - x1540 + x1541*x16 + x1544 + 4*x428
    x1546 = x420*x99
    x1547 = x438*x774
    x1548 = x368*x480
    x1549 = x420*x631
    x1550 = x1382*x631
    x1551 = x1018*x474 + x1018*x481 + x1060*x421 + x1060*x439 + x1546*x473 + x1547*x480 + x1548*x1549 + x1550*x473
    x1552 = x1*x974
    x1553 = x1552*x960
    x1554 = x1*x217
    x1555 = x1484 + x1554
    x1556 = -x1*x17*x186*x424*x7 + x1064 - x13*x17*x186*x424*x6*x9 + x1553 + x1555
    x1557 = x10*x17
    x1558 = x1*x1423
    x1559 = x1557*x959
    x1560 = x1*x1460
    x1561 = x1488 + x1493
    x1562 = x1219*x1552 + x428
    x1563 = -x13*x1559 - x1463*x1560 + x1466*x1516 + x1561 + x1562 + x958
    x1564 = x1*x1497
    x1565 = -x1069 - x1472 - x1564 - x511
    x1566 = -x1*x14*x186*x424*x6*x9 + x1*x1524 - x10*x13*x14*x186*x424 + x1467 + x1514 + x1565
    x1567 = x1*x1441
    x1568 = -x1079
    x1569 = x1000 + x1568
    x1570 = x440*x522 + x442*x524 + x444*x520 + x448*x516 + x453*x518 + x458*x514
    x1571 = x1084 + x1372
    x1572 = 2*x10
    x1573 = 2*x1502
    x1574 = -x1573
    x1575 = 2*x1503
    x1576 = -x1575
    x1577 = x1*x980
    x1578 = 2*x1577
    x1579 = x10*x1219
    x1580 = x1088 + x1542*x1560
    x1581 = x1*x1541 + x1480*x1552 + x1481*x1516 + x1482*x1579 - x1499 + x1506 + x1574 + x1576 - x1578 + x1580 + 4*x430
    x1582 = x1549*x368
    x1583 = x1018*x509 + x1018*x513 + x1094*x421 + x1094*x439 + x1546*x508 + x1547*x512 + x1550*x508 + x1582*x512
    x1584 = x17*x425
    x1585 = x1584*x530
    x1586 = x1585 + x531
    x1587 = x1105*x1457 - x13*x17*x186*x424*x530*x6 - x1488 + x1494 + x1586
    x1588 = x530*x9
    x1589 = -x1484 + x1485
    x1590 = x1105*x1466 - x1464*x1588 + x1589
    x1591 = x1500*x530
    x1592 = x1591 + x533
    x1593 = -x1099*x1466 + x1457*x1588 - x1498 + x1503 + x1592
    x1594 = x440*x534 + x442*x539 + x444*x537
    x1595 = 2*x1456
    x1596 = 2*x1459
    x1597 = x1014 + x1473
    x1598 = x1099*x1505 + x1105*x1481 - 2*x14*x21*x424*x530 + x1471 + 2*x1512 + x1543*x1588 + x1597 + x542
    x1599 = x1018*x546 + x1102*x421 + x1102*x439 + x1547*x545 + x1582*x545
    x1600 = x1513 + x22
    x1601 = x1584*x549
    x1602 = x1601 + x553
    x1603 = x1116*x1457 - x13*x17*x186*x424*x549*x6 + x1600 + x1602
    x1604 = x549*x9
    x1605 = x1116*x1466 - x1464*x1604 + x1517
    x1606 = x1500*x549
    x1607 = x1606 + x554
    x1608 = -x1109*x1466 + x1457*x1604 + x1607
    x1609 = x440*x555 + x442*x551 + x444*x557
    x1610 = x14*x425
    x1611 = x1610*x549
    x1612 = 2*x1611
    x1613 = x1109*x1505 + x1116*x1481 + x1489 + x1535 + x1543*x1604 - x1612 + x560
    x1614 = x1018*x564 + x1115*x421 + x1115*x439 + x1547*x563 + x1582*x563
    x1615 = x1584*x567
    x1616 = x1615 + x569
    x1617 = x1126*x1457 - x13*x17*x186*x424*x567*x6 + x1616
    x1618 = x567*x9
    x1619 = -x13*x186*x2*x4*x424*x567 + x1464*x1618 + x1561
    x1620 = x1500*x567
    x1621 = x1620 + x572
    x1622 = -x1120*x1466 + x1457*x1618 + x1600 + x1621
    x1623 = x440*x575 + x442*x573 + x444*x570
    x1624 = x1610*x567
    x1625 = 2*x1624
    x1626 = x1120*x1505 + x1126*x1481 + x1499 + x1543*x1618 + x1573 - x1625 + x578
    x1627 = x1018*x582 + x1125*x421 + x1125*x439 + x1547*x581 + x1582*x581
    x1628 = x92*(x1130*x480 + x473*x585 + x95*(2*x483 + 2*x485 + 2*x487 + 2*x490 + 2*x493 + 2*x496))
    x1629 = x100*(x236 + x26*x467 + x28*x469 + x31*x471)
    x1630 = x1139*x780
    x1631 = x15*x1630
    x1632 = x14*x1630
    x1633 = x1632*x918
    x1634 = x1632*x2
    x1635 = -x1634*x788
    x1636 = x1631*x44
    x1637 = x1632*x44
    x1638 = x1637*x267
    x1639 = -x1637*x353
    x1640 = x122*x1630
    x1641 = x1630*x2
    x1642 = x122*x1641
    x1643 = x775*(-x16*x432 - x16*x434 - x16*x436 - x17*x476 - x23 - x455 + x456 - x479)
    x1644 = x1630*x18
    x1645 = x1641*x828
    x1646 = x1644*x44
    x1647 = x1632*x804
    x1648 = x1630*x44
    x1649 = x1648*x354
    x1650 = x1641*x44
    x1651 = x115*x1650
    x1652 = x122*x1648
    x1653 = x1630*x19
    x1654 = x1653*x44
    x1655 = x1641*x786
    x1656 = 3*n1 + x1138
    x1657 = x1454*x1656
    x1658 = x13*x1630
    x1659 = x14*x1657
    x1660 = x1659*x974
    x1661 = x1657*x17
    x1662 = x1460*x1661
    x1663 = x1657*x2
    x1664 = x1663*x974
    x1665 = x1460*x1659
    x1666 = x13*x1632
    x1667 = x13*x1648
    x1668 = x124*x1657
    x1669 = x1460*x1663
    x1670 = x124*x1630
    x1671 = x16*x1648
    x1672 = x16*x1630
    x1673 = 4*n1 + x1160
    x1674 = x16*x8
    x1675 = 4*x1463
    x1676 = x1516*x1663
    x1677 = x1516*x16
    x1678 = x1219*x1677
    x1679 = -x1516*x1659
    x1680 = -x1502 + x1503
    x1681 = x1172 + x1680 + x194
    x1682 = 2*n1 + x1174
    x1683 = 2*x960
    x1684 = -x1493 + x1494
    x1685 = x1684 + x830
    x1686 = 2*x1526
    x1687 = -x1682
    x1688 = x1396 + x1480*x1677
    x1689 = x1*x1630
    x1690 = x1*x8
    x1691 = x1503 + x1577
    x1692 = x1087 + x1463*x1552 + x1519 - x1677*x960 - x1690*x960 + x1691
    x1693 = x1*x1516
    x1694 = x1470 + x1508
    x1695 = x1025 + x1219*x1690 - x1463*x1693 - x1559*x16 + x1565 + x1678 + x1694
    x1696 = x1494 + x1539
    x1697 = -x1*x14*x186*x4*x424*x9 - x10*x14*x16*x186*x424 + x1052 + x1219*x1518 + x1562 + x1696
    x1698 = x1*x1648
    x1699 = x1038 + x1568
    x1700 = x482*x524 + x484*x520 + x486*x522 + x489*x518 + x492*x514 + x495*x516
    x1701 = x1287 + x1394
    x1702 = 2*x1485
    x1703 = -x1702
    x1704 = 2*x1484
    x1705 = -x1704
    x1706 = 2*x1554
    x1707 = x1219*x16
    x1708 = x1289 + x1542*x1693
    x1709 = x1480*x1690 + 2*x1525 + 2*x1553 + x1572*x1707 - x1686 + x1688 + x1703 + x1705 - x1706 + x1708 + 4*x478
    x1710 = x480*x774
    x1711 = x368*x512
    x1712 = x473*x631
    x1713 = x508*x631
    x1714 = x1060*x509 + x1060*x513 + x1094*x474 + x1094*x481 + x1548*x1713 + x1710*x512 + x1711*x1712 + x473*x508*x99
    x1715 = x1463*x16
    x1716 = x16*x960
    x1717 = x1694 + x22
    x1718 = x1610*x530
    x1719 = x1718 + x536
    x1720 = x1099*x1715 - x1105*x1716 + x1717 + x1719
    x1721 = x1588*x1715 + x1592 - x16*x186*x2*x4*x424*x530
    x1722 = x1099*x1707 - x14*x16*x186*x424*x530*x9 + x1527
    x1723 = x482*x539 + x484*x537 + x486*x534
    x1724 = 2*x1659
    x1725 = 2*x1663
    x1726 = 2*x1585
    x1727 = x16*x1683
    x1728 = x1480*x16
    x1729 = x1542*x16
    x1730 = x1099*x1727 + x1105*x1728 + x1537 + x1540 + x1588*x1729 - x1726 + x543
    x1731 = x1712*x368
    x1732 = x1060*x546 + x1102*x474 + x1102*x481 + x1710*x545 + x1731*x545
    x1733 = x1611 + x550
    x1734 = x1109*x1715 - x1116*x1716 + x1493 - x1539 + x1733
    x1735 = x1484 - x1526 - x16*x186*x2*x4*x424*x549 + x1604*x1715 + x1607
    x1736 = x1109*x1707 - x14*x16*x186*x424*x549*x9 + x1504
    x1737 = x482*x551 + x484*x557 + x486*x555
    x1738 = x1109*x1727 + x1116*x1728 + x1469 + 2*x1508 + x1597 + x1604*x1729 - 2*x17*x21*x424*x549 + x561
    x1739 = x1060*x564 + x1115*x474 + x1115*x481 + x1710*x563 + x1731*x563
    x1740 = x1624 + x568
    x1741 = x1120*x1715 - x1126*x1716 + x1740
    x1742 = -x16*x186*x2*x4*x424*x567 + x1618*x1715 + x1621 + x1717
    x1743 = -x1120*x1707 + x1618*x1716 + x1696
    x1744 = x482*x573 + x484*x570 + x486*x575
    x1745 = 2*x1615
    x1746 = x1120*x1727 + x1126*x1728 + x1618*x1729 + x1686 + x1702 - x1745 + x579
    x1747 = x1060*x582 + x1125*x474 + x1125*x481 + x1710*x581 + x1731*x581
    x1748 = x92*(x1130*x512 + x508*x585 + x95*(2*x515 + 2*x517 + 2*x519 + 2*x521 + 2*x523 + 2*x525))
    x1749 = x100*(x243 + x26*x502 + x28*x504 + x31*x506)
    x1750 = x1317*x780
    x1751 = x15*x1750
    x1752 = x14*x1750
    x1753 = x1752*x2
    x1754 = x1753*x788
    x1755 = -x1752*x918
    x1756 = x1751*x44
    x1757 = x1752*x44
    x1758 = x1757*x353
    x1759 = -x1757*x267
    x1760 = x122*x1750
    x1761 = x1750*x2
    x1762 = x122*x1761
    x1763 = x775*(-x1*x432 - x1*x434 - x1*x436 - x2*x511 - x24 - x450 + x451 - x494)
    x1764 = x1750*x18
    x1765 = x1761*x828
    x1766 = x1764*x44
    x1767 = x1752*x804
    x1768 = x1750*x44
    x1769 = x1768*x354
    x1770 = x1761*x44
    x1771 = x115*x1770
    x1772 = x122*x1768
    x1773 = x1750*x19
    x1774 = x1773*x44
    x1775 = x1761*x786
    x1776 = 3*n2 + x1316
    x1777 = x1454*x1776
    x1778 = x14*x1777
    x1779 = x1778*x974
    x1780 = x1777*x2
    x1781 = x1780*x974
    x1782 = x17*x1777
    x1783 = x1460*x1782
    x1784 = x13*x1750
    x1785 = x13*x1768
    x1786 = x124*x1777
    x1787 = x1460*x1780
    x1788 = x124*x1750
    x1789 = x16*x1750
    x1790 = -x1516*x1778
    x1791 = x16*x1768
    x1792 = x1516*x1780
    x1793 = x1*x1768
    x1794 = x1*x1750
    x1795 = 4*n2 + x1347
    x1796 = 2*n2 + x1354
    x1797 = -x1796
    x1798 = x1*x1463
    x1799 = x1*x1105
    x1800 = x1099*x1798 + x1555 - x1799*x960
    x1801 = x1219*x1799 + x1586 - x1588*x1798
    x1802 = x1*x1219
    x1803 = x1472 + x1564 + x22
    x1804 = -x1*x14*x186*x424*x530*x9 + x1099*x1802 + x1719 + x1803
    x1805 = x514*x537 + x516*x534 + x518*x539
    x1806 = 2*x1778
    x1807 = 2*x1780
    x1808 = 2*x1591
    x1809 = x1*x1683
    x1810 = x1*x1542
    x1811 = x1099*x1809 + x1480*x1799 + x1575 + x1578 + x1588*x1810 - x1808 + x544
    x1812 = x512*x774
    x1813 = x1713*x368
    x1814 = x1094*x546 + x1102*x509 + x1102*x513 + x1812*x545 + x1813*x545
    x1815 = x1*x960
    x1816 = -x1*x17*x186*x424*x549*x6 + x1116*x1815 + x1691
    x1817 = x1116*x1802 + x1602 - x1604*x1798 + x1803
    x1818 = -x1*x14*x186*x424*x549*x9 + x1109*x1802 + x1733
    x1819 = x514*x557 + x516*x555 + x518*x551
    x1820 = 2*x1606
    x1821 = x1*x1480
    x1822 = x1109*x1809 + x1116*x1821 + x1604*x1810 + x1704 + x1706 - x1820 + x562
    x1823 = x1094*x564 + x1115*x509 + x1115*x513 + x1812*x563 + x1813*x563
    x1824 = x1120*x1798 - x1126*x1815 + x1495
    x1825 = x1126*x1802 + x1485 - x1554 + x1616 - x1618*x1798
    x1826 = -x1*x14*x186*x424*x567*x9 + x1120*x1802 + x1502 - x1577 + x1740
    x1827 = x514*x570 + x516*x575 + x518*x573
    x1828 = x1014 + x1120*x1809 + x1126*x1821 + x1469 + x1471 + 2*x1564 + x1618*x1810 - 2*x2*x21*x424*x567 + x580
    x1829 = x1094*x582 + x1125*x509 + x1125*x513 + x1812*x581 + x1813*x581
    x1830 = x92*(x1130*x545 + x95*(2*x535 + 2*x538 + 2*x540))
    x1831 = x775*(-x14*x536 - x17*x531 - x2*x533 - x422)
    x1832 = -x1452
    x1833 = x1454*x1832
    x1834 = x14*x1833
    x1835 = x1834*x974
    x1836 = x1833*x2
    x1837 = x1836*x974
    x1838 = x17*x1833
    x1839 = x1460*x1838
    x1840 = x1460*x1834
    x1841 = x124*x1833
    x1842 = x1460*x1836
    x1843 = -x1516*x1834
    x1844 = x1516*x1836
    x1845 = 2*x1834
    x1846 = 2*x1836
    x1847 = -x1718
    x1848 = x1601 + x1847
    x1849 = x1612 + x1726
    x1850 = x545*x774
    x1851 = x1102*x564 + x1115*x546 + x1850*x563
    x1852 = x1620 + x1847
    x1853 = x1625 + x1808
    x1854 = x1102*x582 + x1125*x546 + x1850*x581
    x1855 = x92*(x1130*x563 + x95*(2*x552 + 2*x556 + 2*x558))
    x1856 = x775*(-x14*x550 - x17*x553 - x2*x554 - x456)
    x1857 = -x1656
    x1858 = x1454*x1857
    x1859 = x14*x1858
    x1860 = x1859*x974
    x1861 = x1858*x2
    x1862 = x1861*x974
    x1863 = x17*x1858
    x1864 = -x1460*x1863
    x1865 = x1460*x1859
    x1866 = x124*x1858
    x1867 = x1460*x1861
    x1868 = x1516*x1859
    x1869 = x1516*x1861
    x1870 = 2*x1859
    x1871 = 2*x1861
    x1872 = -x1601 + x1620
    x1873 = x1745 + x1820
    x1874 = x1115*x582 + x1125*x564 + x563*x581*x774
    x1875 = x92*(x1130*x581 + x95*(2*x571 + 2*x574 + 2*x576))
    x1876 = x775*(-x14*x568 - x17*x569 - x2*x572 - x451)
    x1877 = -x1776
    x1878 = x1454*x1877
    x1879 = x14*x1878
    x1880 = x1879*x974
    x1881 = x17*x1878
    x1882 = x1460*x1881
    x1883 = x1878*x2
    x1884 = -x1883*x974
    x1885 = x1460*x1879
    x1886 = x124*x1878
    x1887 = x1460*x1883
    x1888 = x1516*x1879
    x1889 = x1516*x1883
    x1890 = 2*x1879
    x1891 = 2*x1883

    return np.array([-x86*x96 - x97*(x101*x76 + x134*(x108*x123 + x109*x124 + x110*x125 + x132 + 4*x70) + x57*x80 + x67*(x25*(x109*x2 - x110*x17 + x112) + x43*(x108*x115 - x109*x14 + x114 + x117) + x51*(x104*x105*x14*x21*x27*x31 - x108*x118 - x121 - x75)) + x76**2*x99), -x150*x96 - x97*(x101*x148 + x134*(x123*x151 + x124*x152 + x125*x153 + x157) + x161 + x67*(x25*(x152*x2 - x153*x17 + x74) + x43*(x115*x151 - x14*x152 + x156) + x51*(x104*x105*x135*x14*x21*x31 - x118*x151 - x146))), -x177*x96 - x97*(x101*x175 + x134*(x123*x179 + x124*x180 + x125*x181 + x183) + x184 + x67*(x25*(x104*x105*x162*x2*x21*x28 - x113 - x17*x181) + x43*(x115*x179 - x14*x180 + x178) + x51*(x104*x105*x14*x162*x21*x31 - x118*x179 - x182))), -x249*x96 - x97*(x101*x214 + x134*(x122*x252 + x284*x69 + 2*x285 + 2*x286 + x293) + x298 + x67*(x25*(-x266 + x269 + x274) + x282 + x43*(x17*x252 + x251*x38 - x255 + x263) + x51*(x119 - x2*x252 + x259*x31 + x277 + x278 + x279*x53 - x280 + x281 + x74))), -x341*x96 - x97*(x101*x315 + x134*(x124*x342 + 2*x255 + 2*x362 + x367) + x370 + x67*(x25*(x2*x342 - x351 + x357) + x361 + x43*(-x14*x342 + x285 + x348) + x51*(-x269 - x360 - x37))), -x398*x96 - x97*(x101*x382 + x134*(x125*x400 + 2*x281 + 2*x351 + x411) + x412 + x67*(x25*(-x17*x400 + x362 + x404) + x407 + x43*(x266 + x360 + x399) + x51*(x104*x105*x14*x21*x32 - x286 - x406))), -x461*x96 - x97*(x101*x420 + x466), -x498*x96 - x97*(x101*x473 + x501), -x527*x96 - x97*(x101*x508 + x529), -x547*x96 - x548, -x565*x96 - x566, -x583*x96 - x584, -x586*x86 - x97*(x134*(x123*x591 + x157 + x464*x591 + x591*x592) + x161 + x593*x76 + x67*(x25*(-x267*x591 + x353*x591 + x74) + x43*(x115*x591 - x14*x28*x591 + x156) + x51*(x105*x14*x21*x27*x31*x589 - x118*x591 - x146))), -x150*x586 - x97*(x134*(x123*x594 + x132 + 4*x154 + x464*x594 + x592*x594) + x142*x149 + x148**2*x99 + x148*x593 + x67*(x25*(x112 - x267*x594 + x353*x594 + x596) + x43*(x105*x135*x17*x21*x26*x589 - x14*x28*x594 - x145 - x595) + x51*(x105*x135*x14*x21*x31*x589 - x118*x594 - x121))), -x177*x586 - x97*(x134*(x123*x597 + x464*x597 + x592*x597 + x601) + x175*x593 + x605 + x67*(x25*(-x267*x597 + x353*x597 + x599) + x43*(x105*x162*x17*x21*x26*x589 - x171 - x28*x598) + x51*(-x118*x597 + x144 + x31*x598))), -x249*x586 - x97*(x134*(x122*x618 + x124*x606 + x125*x615 + x630) + x214*x593 + x633 + x67*(x25*(x54 + x614 + x617) + x43*(x105*x17*x21*x29*x589 - x14*x606 - x611) + x51*(x105*x14*x21*x26*x31*x589 - x2*x618 - x623) + x624)), -x341*x586 - x97*(x134*(x122*x606 + x124*x638 + x125*x641 + x38*x653 + x656) + x315*x593 + x658 + x67*(x25*(-x17*x641 + x2*x638 + x53*x635 + x644) + x43*(-x14*x638 + x17*x606 - x210 + x26*x637 + x47 + x636*x69 - x639 + x640) + x51*(-x614 + x645 - x650) + x651)), -x398*x586 - x97*(x134*(x122*x615 + x124*x641 + x125*x660 + x668) + x382*x593 + x669 + x67*(x25*(-x17*x660 + x2*x641 + x662) + x43*(-x617 - x645 - x659) + x51*(x105*x14*x21*x32*x589 - x2*x615 - x663) + x664)), -x461*x586 - x97*(x420*x593 + x673), -x498*x586 - x97*(x473*x593 + x675), -x527*x586 - x97*(x508*x593 + x677), -x547*x586 - x678, -x565*x586 - x679, -x583*x586 - x680, -x681*x86 - x97*(x134*(x123*x686 + x183 + x464*x686 + x592*x686) + x184 + x67*(x25*(x105*x2*x21*x27*x28*x684 - x113 - x267*x686) + x43*(x115*x686 - x14*x28*x686 + x178) + x51*(x105*x14*x21*x27*x31*x684 - x118*x686 - x182)) + x687*x76), -x150*x681 - x97*(x134*(x123*x688 + x464*x688 + x592*x688 + x601) + x148*x687 + x605 + x67*(x25*(-x267*x688 + x353*x688 + x599) + x43*(x105*x135*x17*x21*x26*x684 - x171 - x28*x689) + x51*(-x118*x688 + x144 + x31*x689))), -x177*x681 - x97*(x134*(x123*x690 + x132 + 4*x173 + x464*x690 + x592*x690) + x169*x176 + x175**2*x99 + x175*x687 + x67*(x25*(x105*x162*x2*x21*x28*x684 - x267*x690 - x273 - x600) + x43*(x115*x690 + x117 - x28*x691) + x51*(-x118*x690 + x172 + x31*x691 + x649))), -x249*x681 - x97*(x134*(x122*x692 + x124*x693 + x125*x700 + x716) + x214*x687 + x67*(x25*(-x47 - x702 - x704) + x43*(-x14*x693 + x17*x692 + x699) + x51*(x14*x700 - x2*x692 + x709) + x710) + x721), -x341*x681 - x97*(x134*(x122*x693 + x124*x722 + x125*x725 + x735) + x315*x687 + x67*(x25*(x105*x2*x21*x30*x684 - x17*x725 - x726) + x43*(-x14*x722 + x17*x693 + x724) + x51*(x704 + x727 + x731) + x732) + x737), -x398*x681 - x97*(x134*(x122*x700 + x124*x725 + x125*x744 + x53*x749 + x751) + x382*x687 + x67*(x25*(-x17*x744 + x178 + x2*x725 + x28*x743 + x37 + x38*x742 - x697 + x739 - x745) + x43*(x702 - x727 + x738) + x51*(x14*x744 - x2*x700 + x69*x741 + x746) + x747) + x752), -x461*x681 - x97*(x420*x687 + x756), -x498*x681 - x97*(x473*x687 + x758), -x527*x681 - x97*(x508*x687 + x762), -x547*x681 - x763, -x565*x681 - x764, -x583*x681 - x765, -x767*x86 - x97*(x134*(x123*x769 + 4*x126 + x293 + x464*x769 + x592*x769) + x298 + x67*(x25*(-x267*x769 + x268 + x274 + x353*x769) + x282 + x43*(x115*x769 - x14*x28*x769 + x263 + x625) + x51*(x103*x105*x14*x21*x27*x31 - x118*x769 + x15*x186*x27*x31*x34 - x212 - x280 - x356 - x648 - x711)) + x76*x770), -x150*x767 - x97*(x134*(x123*x771 + x464*x771 + x592*x771 + x630) + x148*x770 + x633 + x67*(x25*(-x267*x771 + x353*x771 + x54 + x613 + x616) + x43*(x103*x105*x135*x17*x21*x26 - x14*x28*x771 - x611) + x51*(x103*x105*x135*x14*x21*x31 - x118*x771 - x623) + x624)), -x177*x767 - x97*(x134*(x123*x772 + x464*x772 + x592*x772 + x716) + x175*x770 + x67*(x25*(x103*x105*x162*x2*x21*x28 - x267*x772 - x47 - x701 - x703) + x43*(x115*x772 - x28*x773 + x699) + x51*(-x118*x772 + x31*x773 + x709) + x710) + x721), -x249*x767 - x97*(x134*(x122*x31*x806 + x122*x800 + x124*x802 + x125*x803 + 4*x15*x799 - 4*x204 - 4*x206 - x284*x69 + x289*x801 + x778*x798 + x790*x805 + x808 + x818) + x196**2*x774 + x196*x776 + x200*x248 + x214**2*x99 + x214*x295*x797 + x214*x770 + x215*x248 + x67*(2*x220*x234 + 2*x224*x240 + 2*x229*x246 + x25*(x833 - x834 - x835 + x836 + x837 + x842) + x43*(x115*x832 - x14*x802 + x17*x800 - x211 + x279*x38 - x28*x801 + x827*x845 + x844 - x847 + x849 + x854) + x51*(-x118*x832 + x14*x803 - x2*x800 + x213 + x251*x53 + x31*x801 + x826*x855 - x857 - x859 + x860 + x865) + x81*(x190*x827 - x785*x788 + x820*x828 + x830) + x82*(x193*x826 + x785*x791 - x786*x821 + x831) + x83*(x819 + x822 + x824)) + x796*(-x122*x793 + x226*x779 - x785*x787 - x789*x790 + x795)), -x341*x767 - x97*(x134*(x115*x892 + x122*x802 + x124*x871 + x125*x885 + x365*x870 + x655*x875 + x903) + x303*x776 + x315*x770 + x67*(x25*(x2*x871 - x31*x870 - x768*x877 + x876 + x884) + x43*(-x14*x871 + x17*x802 + x26*x870 - x804*x823 + x874) + x51*(-x837 - x888 - x890) + x81*(x786*x866 - x788*x823 + x868) + x82*(-x824 - x869) + x83*(x194 + x789*x792 - x791*x866) + x891) + x796*(-x124*x793 - x790*x828 - x866*x904 - x909) + x917), -x398*x767 - x97*(x134*(x118*x892 + x122*x803 + x124*x885 + x410*x922 + x768*x935 + 2*x876 + x944) + x374*x776 + x382*x770 + x67*(x25*(x2*x885 - x267*x806 + x28*x922 - x768*x923 + x930) + x43*(-x833 + x834 + x888 + x921) + x51*(x103*x105*x14*x21*x32 + x14*x2*x31*x44*x780*x783 - x2*x803 - x26*x922 - x933) + x81*(x320 - x822 + x869) + x82*(x12*x14*x2*x780*x783*x9 - x786*x919 - x920) + x83*(x12*x19*x4*x780*x783 - x191 - x792*x918) + x934) + x796*(-x122*x946 - x792*x947 - x919*x945 - x952) + x955), -x461*x767 - x97*(x1019 + x134*(x1006 + x123*x988 + x592*x988 + 4*x811 + x956*x999) + x420*x770 + x438*x776 + x67*(x25*(-x267*x988 + x353*x988 + x993) + x43*(x13*x17*x186*x29*x34 + x13*x17*x26*x44*x780*x783 - x28*x985 - x843 - x852 - x898 - x984 - x987) + x51*(-x118*x988 + x31*x985 + x941 + x997) + x81*(-x820*x957 + x828*x956 + x908 + x968) + x82*(x12*x13*x14*x780*x783*x9 - x13*x946 - x951 - x983) + x83*(x792*x957 - x918*x956 + x977) + x998) + x796*(-x1007*x956 - x1008*x956 - x1017 - 4*x432 - x947*x956)), -x498*x767 - x97*(x1061 + x134*(x1020*x999 + x1035*x123 + x1035*x592 + x1051) + x473*x770 + x480*x776 + x67*(x1047 + x25*(-x1035*x267 - x1043 + x16*x2*x28*x44*x780*x783) + x43*(x1035*x115 + x1040 - x16*x28*x832) + x51*(-x1035*x118 - x1046 + x14*x16*x31*x44*x780*x783) + x81*(x1020*x828 - x1021*x820 + x1027) + x82*(-x1034 + x12*x14*x16*x780*x783*x9 - x16*x946) + x83*(-x1020*x918 - x1030 + x12*x16*x2*x4*x780*x783)) + x796*(-x1007*x1020 - x1008*x1020 - x1020*x947 - x1059)), -x527*x767 - x97*(x1095 + x134*(x1062*x999 + x1072*x123 + x1072*x592 + x1086) + x508*x770 + x512*x776 + x67*(x1082 + x25*(-x1072*x267 + x1072*x353 + x1078) + x43*(-x1*x28*x832 + x1072*x115 + x1075) + x51*(x1*x14*x31*x44*x780*x783 - x1072*x118 - x1081) + x81*(x1062*x828 - x1063*x820 + x1065) + x82*(x1*x12*x14*x780*x783*x9 - x1*x946 - x1071) + x83*(-x1062*x918 + x1063*x792 + x1067)) + x796*(-x1007*x1062 - x1008*x1062 - x1062*x947 - x1093)), -x547*x767 - x97*(x1108 + x545*x776), -x565*x767 - x97*(x1119 + x563*x776), -x583*x767 - x97*(x1129 + x581*x776), -x1131*x86 - x97*(x1134*x76 + x134*(x1133*x123 + x1133*x464 + x1133*x592 + x367) + x370 + x67*(x25*(-x1133*x267 + x1133*x353 + x357) + x361 + x43*(x1133*x115 - x1133*x14*x28 + x348) + x51*(x105*x14*x21*x27*x31*x588 - x1133*x118 - x268 - x359 - x37))), -x1131*x150 - x97*(x1134*x148 + x134*(x1135*x123 + x1135*x464 + x1135*x592 + 4*x128 + x656) + x658 + x67*(x25*(-x1135*x267 + x1135*x353 + x644 + x733) + x43*(x105*x135*x17*x21*x26*x588 - x1135*x14*x28 - x116 + x135*x18*x186*x26*x34 + x144 - x210 - x363 - x626 - x639) + x51*(x105*x135*x14*x21*x31*x588 - x1135*x118 - x613 - x650) + x651)), -x1131*x177 - x97*(x1134*x175 + x134*(x1136*x123 + x1136*x464 + x1136*x592 + x735) + x67*(x25*(x105*x162*x2*x21*x28*x588 - x1136*x267 - x726) + x43*(x1136*x115 - x1137*x28 + x724) + x51*(-x1136*x118 + x1137*x31 + x703 + x731) + x732) + x737), -x1131*x249 - x97*(x1134*x214 + x1159*x196 + x134*(x1003*x1132 + x1004*x1132 + x1147*x122 + x1148*x289 + x1155*x805 + x1156*x1158 + x903) + x67*(x25*(x1151 - x1153 + x1154 + x884) + x43*(x1147*x17 - x1148*x28 + x1149*x115 - x1150*x253 + x874) + x51*(x105*x14*x21*x26*x31*x588 + x1140*x15*x31*x44*x780 - x1147*x2 - x1149*x118 - x887 - x890) + x81*(-x1142*x788 + x1143*x828 + x868) + x82*(x1140*x12*x15*x780*x9 - x1144*x786 - x218) + x83*(x1145 + x1146) + x891) + x796*(-x1142*x787 - x1155*x789 - x1158*x791 - x909) + x917), -x1131*x341 - x97*(x1134*x315 + x1159*x303 + x134*(x1132*x1165 + x115*x1170 + x1161*x845 + x1166*x365 + x1167*x253 + x1168*x125 + x1169*x655 + x1171 + 4*x30*x343 - 4*x307 - 4*x309 - x38*x653 + x818) + x303**2*x774 + x305*x340 + x315**2*x99 + x315*x797*x915 + x316*x340 + x67*(x25*(-x1132*x877 + x1132*x878 - x1166*x31 + x1176*x855 + x1183 - x1184 + x1186 + x1187 + x53*x636 - x667 + x842) + 2*x318*x327 + 2*x322*x338 + 2*x324*x334 + x43*(-x1132*x1181 + x1152*x253 + x1166*x26 + x1175*x798 - x1182*x17 + x211 + x635*x69 - x844 + x854 + x896 - x900) + x51*(-x1154 - x1178 - x1180 - x121 + 2*x14*x17*x186*x28*x31*x34 - x937) + x81*(-x1143*x789 + x1163*x786 + x1175*x226 + x830) + x82*(-x1146 - x1172 - x1173) + x83*(x1157*x789 - x1163*x791 + x1176*x193 + x1177)) + x796*(-x1155*x828 - x1157*x1164 + x1162*x190 - x1163*x904 + x795)), -x1131*x398 - x97*(x1134*x382 + x1159*x374 + x1213 + x134*(x1132*x935 + x1167*x264 + x1168*x124 + x1170*x118 + 2*x1187 + x1192*x410 + x1201) + x67*(x1195 + x25*(-x1132*x923 + x1132*x925 - x1179*x267 + x1192*x28 + x1193) + x43*(-x1151 + x1153 + x1180 + x1191) + x51*(x105*x14*x21*x32*x588 - x1132*x893 + x1140*x14*x2*x31*x44*x780 - x1192*x26 - x1194) + x81*(-x1145 + x1173 - x227) + x82*(x1144*x791 - x1188*x786 + x222) + x83*(-x1157*x918 + x1188*x788 + x1189)) + x796*(-x1157*x947 - x1188*x945 - x1202*x122 - x1207)), -x1131*x461 - x97*(x1134*x420 + x1159*x438 + x1249 + x134*(x1218*x1238 + x1218*x999 + x123*x1233 + x1242) + x67*(x1237 + x25*(-x1233*x267 + x1233*x353 + x1234) + x43*(x1140*x13*x17*x26*x44*x780 - x1182*x13 - x1232) + x51*(x1156*x1226 - x118*x1233 + x1236) + x81*(x1140*x12*x13*x17*x6*x780 - x1143*x957 - x1217) + x82*(-x1202*x13 + x1226*x791 + x1229) + x83*(x1157*x957 - x1218*x918 + x1225)) + x796*(-x1007*x1218 - x1008*x1218 - x1243*x957 - x1247)), -x1131*x498 - x97*(x1134*x473 + x1159*x480 + x1272 + x134*(x123*x1258 + x1238*x1251 + x1251*x999 + x1266 + 4*x813) + x67*(x1265 + x25*(x1044 + x1140*x16*x2*x28*x44*x780 - x1198 - x1258*x267 - x1262 + x16*x186*x2*x30*x34 - x471 - x840 - x886) + x43*(x115*x1258 - x1182*x16 + x1261 + x897) + x51*(x1140*x14*x16*x31*x44*x780 - x118*x1258 - x1264) + x81*(-x1021*x1143 + x1140*x12*x16*x17*x6*x780 - x1250 - x906) + x82*(x1140*x12*x14*x16*x780*x9 - x1202*x16 - x1257) + x83*(x1021*x1157 + x1206 - x1251*x918 + x1256)) + x796*(-x1007*x1251 - x1008*x1251 - x1021*x1243 - x1271 - 4*x434)), -x1131*x527 - x97*(x1134*x508 + x1159*x512 + x1295 + x134*(x123*x1279 + x1238*x1274 + x1274*x999 + x1288) + x67*(x1286 + x25*(-x1279*x267 + x1279*x353 + x1283) + x43*(-x1*x1182 + x115*x1279 + x1282) + x51*(x1*x1140*x14*x31*x44*x780 - x118*x1279 - x1285) + x81*(x1*x1140*x12*x17*x6*x780 - x1063*x1143 - x1273) + x82*(x1*x1140*x12*x14*x780*x9 - x1*x1202 - x1278) + x83*(x1063*x1157 - x1274*x918 + x1276)) + x796*(-x1007*x1274 - x1008*x1274 - x1063*x1243 - x1294)), -x1131*x547 - x97*(x1159*x545 + x1300), -x1131*x565 - x97*(x1159*x563 + x1304), -x1131*x583 - x97*(x1159*x581 + x1308), -x1309*x86 - x97*(x1312*x76 + x134*(x123*x1311 + x1311*x464 + x1311*x592 + x411) + x412 + x67*(x25*(-x1311*x267 + x1311*x353 + x404) + x407 + x43*(x115*x1311 - x1311*x14*x28 + x359 + x399) + x51*(x105*x14*x21*x27*x31*x683 - x118*x1311 - x406))), -x1309*x150 - x97*(x1312*x148 + x134*(x123*x1313 + x1313*x464 + x1313*x592 + x668) + x669 + x67*(x25*(-x1313*x267 + x1313*x353 + x662) + x43*(x105*x135*x17*x21*x26*x683 - x1313*x14*x28 - x616 - x659) + x51*(x105*x135*x14*x21*x31*x683 - x118*x1313 - x663) + x664)), -x1309*x177 - x97*(x1312*x175 + x134*(x123*x1314 + 4*x130 + x1314*x464 + x1314*x592 + x751) + x67*(x25*(x105*x162*x2*x21*x28*x683 - x111 - x1314*x267 + x162*x186*x19*x28*x34 - x313 - x665 - x698 - x745) + x43*(x115*x1314 - x1315*x28 + x701 + x738) + x51*(-x118*x1314 + x1315*x31 + x408 + x746) + x747) + x752), -x1309*x249 - x97*(x1312*x214 + x1336*x196 + x134*(x1003*x1310 + x1004*x1310 + x1156*x1335 + x122*x1325 + x1326*x289 + x1333*x805 + x944) + x67*(x25*(x1329 - x1331 + x1332 + x930) + x43*(x115*x1327 + x1325*x17 - x1326*x28 - x1328*x253 + x887 + x921) + x51*(x105*x14*x21*x26*x31*x683 - x118*x1327 + x1318*x15*x31*x44*x780 - x1325*x2 - x933) + x81*(-x1320*x788 + x1321*x828 + x320) + x82*(x12*x1318*x15*x780*x9 - x1323*x786 - x920) + x83*(-x1322 - x1324) + x934) + x796*(-x1320*x787 - x1333*x789 - x1335*x791 - x952) + x955), -x1309*x341 - x97*(x1213 + x1312*x315 + x1336*x303 + x134*(x115*x1346 + x1165*x1310 + x1201 + x1241*x1310 + x1339*x365 + x1341*x655 + x1345*x253) + x67*(x1195 + x25*(x1193 - x1310*x877 + x1310*x878 - x1339*x31 + x1342) + x43*(-x1181*x1310 + x1191 + x1330*x253 + x1339*x26 - x1340*x17) + x51*(-x1194 - x1332 - x1344) + x81*(x12*x1318*x18*x6*x780 - x1321*x789 - x227) + x82*(x1322 - x1338 + x222) + x83*(x1189 + x1334*x789 - x1337*x791)) + x796*(-x1164*x1334 - x1207 - x1333*x828 - x1337*x904)), -x1309*x398 - x97*(x1211*x382*x797 + x1312*x382 + x1336*x374 + x134*(x1171 + x118*x1346 + x1310*x1353 + x1310*x935 + x132 + 2*x1342 + x1345*x264 + x1348*x855 + x1352*x410 + 4*x32*x402 - 4*x377 - 4*x379 - x53*x749 + x808 + x809 + x817) + x374**2*x774 + x375*x397 + x382**2*x99 + x383*x397 + x67*(x25*(-x1183 + x1196 - x1200 - x1310*x923 + x1310*x925 - x1343*x267 + x1352*x28 + x1355*x845 + x38*x741 + x667 + x842) + 2*x384*x390 + 2*x386*x392 + 2*x388*x395 + x43*(-x1329 + x1331 + x1344 + x854 + x894 - x902) + x51*(x1156*x1323 + x1310*x14*x32 - x1310*x893 - x1352*x26 + x1356*x798 - x213 + x69*x742 + x857 + x865 + x939 - x943) + x81*(x1324 + x1338 + x829) + x82*(x1323*x791 - x1350*x786 + x1356*x226 + x831) + x83*(x1177 - x1334*x918 + x1350*x788 + x1355*x190)) + x796*(-x122*x1351 - x1334*x947 + x1349*x193 - x1350*x945 + x795)), -x1309*x461 - x97*(x1312*x420 + x1336*x438 + x134*(x123*x1367 + x1238*x1358 + x1358*x999 + x1373) + x1384 + x67*(x1371 + x25*(-x1367*x267 + x1367*x353 + x1368) + x43*(x13*x1318*x17*x26*x44*x780 - x13*x1340 - x1366) + x51*(x1156*x1363 - x118*x1367 + x1370) + x81*(x12*x13*x1318*x17*x6*x780 - x1321*x957 - x1357) + x82*(-x13*x1351 + x1363*x791 + x1365) + x83*(x12*x13*x1318*x2*x4*x780 - x1358*x918 - x1362)) + x796*(-x1007*x1358 - x1008*x1358 - x1374*x957 - x1378)), -x1309*x498 - x97*(x1312*x473 + x1336*x480 + x134*(x123*x1389 + x1238*x1385 + x1385*x999 + x1395) + x1399 + x67*(x1393 + x25*(x1318*x16*x2*x28*x44*x780 - x1389*x267 - x1391) + x43*(x115*x1389 - x1340*x16 + x1390) + x51*(-x118*x1389 + x1318*x14*x16*x31*x44*x780 - x1392) + x81*(-x1021*x1321 + x1385*x828 + x1386) + x82*(x1321*x16*x791 - x1351*x16 + x1388) + x83*(x12*x1318*x16*x2*x4*x780 - x1385*x918 - x1387)) + x796*(-x1007*x1385 - x1008*x1385 - x1021*x1374 - x1397)), -x1309*x527 - x97*(x1312*x508 + x1336*x512 + x134*(x123*x1405 + x1238*x1400 + x1400*x999 + x1411 + 4*x815) + x1415 + x67*(x1410 + x25*(x1197 - x1405*x267 + x1405*x353 + x1408) + x43*(-x1*x1340 + x115*x1405 + x1407) + x51*(x1*x1318*x14*x31*x44*x780 + x1*x14*x186*x32*x34 - x118*x1405 - x1281 - x1409 - x856 - x863 - x940) + x81*(-x1063*x1321 + x1400*x828 + x1402) + x82*(x1*x1321*x791 - x1*x1351 + x1404 + x949) + x83*(x1*x12*x1318*x2*x4*x780 - x1204 - x1400*x918 - x1403)) + x796*(-x1007*x1400 - x1008*x1400 - x1063*x1374 - x1414 - 4*x436)), -x1309*x547 - x97*(x1336*x545 + x1418), -x1309*x565 - x97*(x1336*x563 + x1419), -x1309*x583 - x97*(x1336*x581 + x1420), -x1421*x86 - x97*(x1422*x76 + x466), -x1421*x150 - x97*(x1422*x148 + x673), -x1421*x177 - x97*(x1422*x175 + x756), -x1421*x249 - x97*(x1019 + x134*(x1006 + x1156*x1435 + x1429*x289 + x1433*x805 + x779*x798) + x1422*x214 + x1436*x196 + x67*(x25*(x1431 - x1432 + x993) + x43*(x115*x1430 + x13*x848 - x1429*x28 - x415 + x826*x845 + x851 + x928 - x984 + x986) + x51*(-x118*x1430 + x1429*x31 + x827*x855 + x997) + x81*(-x1424*x788 + x1425*x828 + x190*x826 + x968) + x82*(x12*x15*x780*x782*x9 + x12*x186*x827*x9 - x1426*x786 - x983) + x83*(x1427 - x1428 + x977) + x998) + x796*(-x1017 + x12*x186*x6*x778 - x1424*x787 - x1433*x789 - x1435*x791)), -x1421*x341 - x97*(x1249 + x134*(x115*x1445 + x1242 + x1440*x365 + x1441*x655) + x1422*x315 + x1436*x303 + x67*(x1237 + x25*(x1234 - x1440*x31 + x1442) + x43*(-x1232 - x1439*x17 + x18*x26*x44*x780*x782) + x51*(x1236 + x1432 + x1444) + x81*(x12*x18*x6*x780*x782 - x1217 - x1425*x789) + x82*(x1229 + x1428 + x1438) + x83*(x1225 + x1434*x789 - x1437*x791)) + x796*(-x1164*x1434 - x1247 - x1433*x828 - x1437*x904)), -x1421*x398 - x97*(x134*(x118*x1445 + x1373 + 2*x1442 + x1447*x410) + x1384 + x1422*x382 + x1436*x374 + x67*(x1371 + x25*(x1368 - x1443*x267 + x1447*x28) + x43*(-x1366 - x1431 - x1444) + x51*(x1156*x1426 + x1370 - x1447*x26) + x81*(-x1357 - x1427 - x1438) + x82*(x1365 + x1426*x791 - x1446*x786) + x83*(x12*x19*x4*x780*x782 - x1362 - x1434*x918)) + x796*(-x122*x1448 - x1378 - x1434*x947 - x1446*x945)), -x1421*x461 - x97*(x134*(4*x1000 + x123*x1449 + x1238*x1450 + x1450*x999 + x817) + x1382*x420*x797 + x1422*x420 + x1436*x438 + x420**2*x99 + x421*x460 + x438**2*x774 + x439*x460 + x67*(x25*(-x1449*x267 + x1449*x353 + x841) + x43*(-x1239 - x13*x1439 + x13*x17*x26*x44*x780*x782 - x1406) + 2*x440*x448 + 2*x442*x453 + 2*x444*x458 + x51*(x1156*x1476 - x118*x1449 + x1372 + x864) + x81*(-x1056 + x12*x13*x17*x6*x780*x782 + 2*x13*x17*x186*x424*x7 - x1401 - x1425*x957 + x1452*x1453*x17*x21*x7 - x1489 + x1491*x17*x21*x424 - x1492 - x1495 - x1496 - x222) + x82*(-x1010*x1466 + x1090 - x13*x1448 - x1459*x7 + x1476*x791 + x1490*x1500 + x1499 + x1501 + x1504 + x1506 + x831) + x83*(x1219*x1483 + x1434*x957 - x1450*x918 - x1460*x1481 + x1477 + x1479 + x1487)) + x796*(-x1007*x1450 - x1008*x1450 - x1010*x1456 + 4*x12*x13*x14*x186 - 4*x1215 + x14*x1451*x21*x424 - 4*x1457*x7 - x1458*x974 - 2*x1461 - x1462*x957 - 4*x1465 - 4*x1467 - x1475 - 4*x426)), -x1421*x498 - x97*(x134*(x123*x1529 + x1238*x1507 + x1507*x999 + x1532) + x1422*x473 + x1436*x480 + x1551 + x67*(x1531 + x25*(-x1529*x267 + x16*x2*x28*x44*x780*x782 - x995) + x43*(x115*x1529 - x1439*x16 + x1530) + x51*(x1044 + x1156*x1521 - x118*x1529) + x81*(-x1021*x1425 - x1456*x8 + x1478*x974 + x1507*x828 + x1515) + x82*(-x1448*x16 - x1477 + x1521*x791 + x1523 + x1528) + x83*(x12*x16*x2*x4*x780*x782 + x1452*x1453*x2*x21*x8 - x1478*x1516 - x1507*x918 - x1520)) + x796*(-x1007*x1507 - x1008*x1507 - x1021*x1462 - x1455*x1533 - 2*x1492 - 2*x1534 - x1545)), -x1421*x527 - x97*(x134*(x123*x1567 + x1238*x1558 + x1558*x999 + x1571) + x1422*x508 + x1436*x512 + x1583 + x67*(x1570 + x25*(-x1567*x267 + x1567*x353 + x986) + x43*(-x1*x1439 + x1*x17*x26*x44*x780*x782 - x1073) + x51*(x1*x14*x31*x44*x780*x782 - x118*x1567 - x1569) + x81*(x1*x12*x17*x6*x780*x782 - x1063*x1425 - x1479 - x1523 - x1556) + x82*(x1*x12*x14*x780*x782*x9 - x1*x1448 + x10*x14*x1452*x1453*x21 - x1461 - x1566) + x83*(x1063*x1434 - x1455*x1557 + x1534 - x1558*x918 + x1563)) + x796*(-x1007*x1558 - x1008*x1558 - x1063*x1462 - x1458*x1516 - x1459*x1572 - 2*x1501 - x1581)), -x1421*x547 - x97*(x1436*x545 + x1599 + x67*(x1594 + x81*(-x1105*x1456 + x1452*x1453*x17*x21*x530*x6 - x1536 - x1587) + x82*(-x1099*x1459 + x1456*x1588 + x1574 + x1593) + x83*(x1105*x1459 - x1478*x1588 + x1590)) + x796*(-x1099*x1595 - x1105*x1458 - 4*x1468 - x1588*x1596 - x1598)), -x1421*x565 - x97*(x1436*x563 + x1614 + x67*(x1609 + x81*(-x1116*x1456 + x1452*x1453*x17*x21*x549*x6 - x1603) + x82*(-x1109*x1459 + x1456*x1604 + x1608) + x83*(x1116*x1459 - x1478*x1604 + x1605)) + x796*(-x1109*x1595 - x1116*x1458 - x1596*x1604 - x1613)), -x1421*x583 - x97*(x1436*x581 + x1627 + x67*(x1623 + x81*(-x1126*x1456 + x1452*x1453*x17*x21*x567*x6 - x1617) + x82*(-x1120*x1459 + x1456*x1618 + x1622) + x83*(x1452*x1453*x2*x21*x4*x567 - x1478*x1618 - x1619)) + x796*(-x1120*x1595 - x1126*x1458 - x1596*x1618 - x1626)), -x1628*x86 - x97*(x1629*x76 + x501), -x150*x1628 - x97*(x148*x1629 + x675), -x1628*x177 - x97*(x1629*x175 + x758), -x1628*x249 - x97*(x1061 + x134*(x1051 + x1156*x1642 + x1636*x289 + x1640*x805) + x1629*x214 + x1643*x196 + x67*(x1047 + x25*(-x1043 - x1638 - x1639) + x43*(x1040 + x115*x1637 - x1636*x28) + x51*(-x1046 + x1139*x15*x31*x44*x780 - x118*x1637) + x81*(x1027 - x1631*x788 + x1632*x828) + x82*(-x1034 + x1139*x12*x15*x780*x9 - x1634*x786) + x83*(-x1030 - x1633 - x1635)) + x796*(-x1059 - x1631*x787 - x1640*x789 - x1642*x791)), -x1628*x341 - x97*(x1272 + x134*(x115*x1652 + x1162*x845 + x1266 + x1646*x365 + x1648*x655) + x1629*x315 + x1643*x303 + x67*(x1265 + x25*(x1045 + x1175*x855 + x1185*x16 - x1262 - x1646*x31 + x1649 + x839 - x886) + x43*(x1176*x798 + x1261 + x1646*x26 - x1647*x17) + x51*(-x1264 + x1638 - x1651) + x81*(x1139*x12*x18*x6*x780 + x1176*x12*x186*x6 - x1250 - x1632*x789) + x82*(-x1257 + x1633 - x1645) + x83*(x1175*x193 + x1256 + x1641*x789 - x1644*x791)) + x796*(x1161*x12*x186*x4 - x1164*x1641 - x1271 - x1640*x828 - x1644*x904)), -x1628*x398 - x97*(x134*(x118*x1652 + x1395 + 2*x1649 + x1654*x410) + x1399 + x1629*x382 + x1643*x374 + x67*(x1393 + x25*(x1139*x19*x28*x44*x780 - x1391 - x1650*x267) + x43*(x1390 + x1639 + x1651) + x51*(x1139*x14*x2*x31*x44*x780 - x1392 - x1654*x26) + x81*(x1386 + x1635 + x1645) + x82*(x1388 + x1634*x791 - x1653*x786) + x83*(x1139*x12*x19*x4*x780 - x1387 - x1641*x918)) + x796*(-x122*x1655 - x1397 - x1641*x947 - x1653*x945)), -x1628*x461 - x97*(x134*(x123*x1667 + x1238*x1658 + x1532 + x1658*x999) + x1551 + x1629*x420 + x1643*x438 + x67*(x1531 + x25*(x1139*x13*x2*x28*x44*x780 - x1667*x267 - x995) + x43*(x115*x1667 - x13*x1647 + x1530) + x51*(x1044 + x1156*x1666 - x118*x1667) + x81*(x1515 - x1632*x957 + x1657*x961 + x1658*x828 - x1660) + x82*(-x13*x1655 + x1522 + x1528 - x1663*x7 + x1665 + x1666*x791) + x83*(x1139*x12*x13*x2*x4*x780 - x1520 - x1658*x918 - x1662 + x1664)) + x796*(-x1007*x1658 - x1008*x1658 - x1010*x1659 - x1545 - x1668*x974 - 2*x1669 - x1670*x957)), -x1628*x498 - x97*(x134*(4*x1038 + x123*x1671 + x1238*x1672 + x1672*x999 + x817) + x1548*x473*x797 + x1629*x473 + x1643*x480 + x473**2*x99 + x474*x497 + x480**2*x774 + x481*x497 + x67*(x25*(x1139*x16*x2*x28*x44*x780 - x1394 - x1671*x267 - x992) + x43*(x1049 + x115*x1671 - x16*x1647 + x853) + 2*x482*x489 + 2*x484*x492 + 2*x486*x495 + x51*(x1139*x14*x16*x31*x44*x780 - x1178 - x118*x1671) + x81*(-x1021*x1632 + x1056 + x1540 + x1544 + x1610*x1682 - x1659*x8 + x1661*x974 + x1672*x828 - x1674*x1683 + x1685) + x82*(x1139*x12*x14*x16*x780*x9 - 2*x1219*x1510 + 2*x14*x16*x186*x4*x424*x9 - x16*x1655 - x1664 - x1679 - x1681) + x83*(x1139*x12*x16*x2*x4*x780 - x1291 + x1453*x1656*x2*x21*x8 - x1516*x1661 - x1589 + 2*x16*x186*x2*x424*x8 - x1672*x918 - x1686 + x1687*x2*x21*x424 - x1688 - x320 - x969)) + x796*(-x1007*x1672 - x1008*x1672 - x1021*x1670 - 4*x1024 + 4*x12*x16*x17*x186 - x1475 - 4*x1511 - x1533*x1657 - 2*x1660 + x1673*x17*x21*x424 - x1674*x1675 - 2*x1676 - 4*x1678 - 4*x476)), -x1628*x527 - x97*(x134*(x123*x1698 + x1238*x1689 + x1689*x999 + x1701) + x1629*x508 + x1643*x512 + x1714 + x67*(x1700 + x25*(-x1698*x267 + x1698*x353 + x1699) + x43*(-x1*x1647 + x1083 + x115*x1698) + x51*(x1*x1139*x14*x31*x44*x780 - x1048 - x118*x1698) + x81*(-x1063*x1632 + x1662 + x1679 + x1689*x828 + x1692) + x82*(x1*x1139*x12*x14*x780*x9 - x1*x1655 + x10*x14*x1453*x1656*x21 - x1669 - x1697) + x83*(x1063*x1641 - x1557*x1657 + x1676 - x1689*x918 + x1695)) + x796*(-x1007*x1689 - x1008*x1689 - x1063*x1670 - x1516*x1668 - x1572*x1663 - 2*x1665 - x1709)), -x1628*x547 - x97*(x1643*x545 + x1732 + x67*(x1723 + x81*(x1099*x1661 - x1105*x1659 + x1720) + x82*(-x1099*x1663 + x14*x1453*x1656*x21*x530*x9 - x1722) + x83*(x1453*x1656*x2*x21*x4*x530 - x1588*x1661 - x1721)) + x796*(-x1099*x1724 - x1105*x1668 - x1588*x1725 - x1730)), -x1628*x565 - x97*(x1643*x563 + x1739 + x67*(x1737 + x81*(x1109*x1661 - x1116*x1659 + x1538 + x1734) + x82*(-x1109*x1663 + x14*x1453*x1656*x21*x549*x9 - x1736) + x83*(x1453*x1656*x2*x21*x4*x549 - x1604*x1661 - x1703 - x1735)) + x796*(-x1109*x1724 - x1116*x1668 - 4*x1470 - x1604*x1725 - x1738)), -x1628*x583 - x97*(x1643*x581 + x1747 + x67*(x1744 + x81*(x1120*x1661 - x1126*x1659 + x1741) + x82*(-x1120*x1663 + x1618*x1659 + x1743) + x83*(x1453*x1656*x2*x21*x4*x567 - x1618*x1661 - x1742)) + x796*(-x1120*x1724 - x1126*x1668 - x1618*x1725 - x1746)), -x1748*x86 - x97*(x1749*x76 + x529), -x150*x1748 - x97*(x148*x1749 + x677), -x1748*x177 - x97*(x1749*x175 + x762), -x1748*x249 - x97*(x1095 + x134*(x1086 + x1156*x1762 + x1756*x289 + x1760*x805) + x1749*x214 + x1763*x196 + x67*(x1082 + x25*(x1078 + x1758 + x1759) + x43*(x1075 + x115*x1757 - x1756*x28) + x51*(-x1081 - x118*x1757 + x1317*x15*x31*x44*x780) + x81*(x1065 - x1751*x788 + x1752*x828) + x82*(-x1071 + x12*x1317*x15*x780*x9 - x1753*x786) + x83*(x1067 + x1754 + x1755)) + x796*(-x1093 - x1751*x787 - x1760*x789 - x1762*x791)), -x1748*x341 - x97*(x1295 + x134*(x115*x1772 + x1288 + x1766*x365 + x1768*x655) + x1749*x315 + x1763*x303 + x67*(x1286 + x25*(x1283 - x1766*x31 + x1769) + x43*(x1282 - x17*x1767 + x1766*x26) + x51*(-x1285 - x1759 - x1771) + x81*(x12*x1317*x18*x6*x780 - x1273 - x1752*x789) + x82*(-x1278 - x1755 - x1765) + x83*(x1276 + x1761*x789 - x1764*x791)) + x796*(-x1164*x1761 - x1294 - x1760*x828 - x1764*x904)), -x1748*x398 - x97*(x134*(x118*x1772 + x1349*x855 + x1411 + 2*x1769 + x1774*x410) + x1415 + x1749*x382 + x1763*x374 + x67*(x1410 + x25*(x1356*x845 + x1408 - x1770*x267 + x1774*x28) + x43*(x1407 - x1758 + x1771) + x51*(x1*x938 + x1083 + x1156*x1753 + x1190 + x1355*x798 - x1409 - x1774*x26 + x760 + x862) + x81*(x1402 - x1754 + x1765) + x82*(x1355*x226 + x1404 + x1753*x791 - x1773*x786) + x83*(x12*x1317*x19*x4*x780 + x12*x1356*x186*x4 - x1403 - x1761*x918)) + x796*(x12*x1348*x186*x9 - x122*x1775 - x1414 - x1761*x947 - x1773*x945)), -x1748*x461 - x97*(x134*(x123*x1785 + x1238*x1784 + x1571 + x1784*x999) + x1583 + x1749*x420 + x1763*x438 + x67*(x1570 + x25*(-x1785*x267 + x1785*x353 + x986) + x43*(-x1073 + x13*x1317*x17*x26*x44*x780 - x13*x1767) + x51*(-x118*x1785 + x13*x1317*x14*x31*x44*x780 - x1569) + x81*(x12*x13*x1317*x17*x6*x780 + x1453*x17*x1776*x21*x7 - x1522 - x1556 - x1752*x957 - x1779) + x82*(x12*x13*x1317*x14*x780*x9 - x13*x1775 + x14*x1453*x1776*x21*x6*x9 - x1566 - x1780*x7) + x83*(x1563 + x1761*x957 + x1781 - x1783 - x1784*x918)) + x796*(-x1007*x1784 - x1008*x1784 - x1010*x1778 - x1581 - x1786*x974 - 2*x1787 - x1788*x957)), -x1748*x498 - x97*(x134*(x123*x1791 + x1238*x1789 + x1701 + x1789*x999) + x1714 + x1749*x473 + x1763*x480 + x67*(x1700 + x25*(x1699 - x1791*x267 + x1791*x353) + x43*(x1083 + x115*x1791 - x16*x1767) + x51*(-x1048 - x118*x1791 + x1317*x14*x16*x31*x44*x780) + x81*(-x1021*x1752 + x1692 - x1778*x8 + x1782*x974 + x1789*x828) + x82*(x12*x1317*x14*x16*x780*x9 - x16*x1775 - x1697 - x1781 - x1790) + x83*(x1021*x1761 - x1516*x1782 + x1695 + x1780*x8 - x1789*x918)) + x796*(-x1007*x1789 - x1008*x1789 - x1021*x1788 - x1533*x1777 - x1709 - 2*x1779 - 2*x1792)), -x1748*x527 - x97*(x134*(4*x1079 + x123*x1793 + x1238*x1794 + x1794*x999 + x817) + x1711*x508*x797 + x1749*x508 + x1763*x512 + x508**2*x99 + x509*x526 + x512**2*x774 + x513*x526 + x67*(x25*(x1287 - x1793*x267 + x1793*x353 + x841) + x43*(-x1*x1767 + x115*x1793 + x853) + x51*(x1*x1317*x14*x31*x44*x780 - x1084 - x1178 - x118*x1793) + 2*x514*x520 + 2*x516*x522 + 2*x518*x524 + x81*(-x1063*x1752 + x1480*x1560 - x1683*x1693 + x1685 + x1783 + x1790 + x1794*x828) + x82*(2*x1*x10*x14*x186*x424 + x1*x12*x1317*x14*x780*x9 - x1*x1775 + x10*x14*x1453*x1776*x21 - x1090 + x14*x1797*x21*x424 - x1578 - x1580 - x1681 - x1787) + x83*(-2*x1*x1559 + x1063*x1761 + x1291 + x1487 - x1557*x1777 + x1584*x1796 + x1706 + x1708 + x1792 - x1794*x918)) + x796*(4*x1*x12*x186*x2 - 4*x1*x1579 - x1007*x1794 - x1008*x1794 - x1063*x1788 - 4*x1069 - 2*x1460*x1778 - x1475 - x1516*x1786 - 4*x1560*x960 - x1572*x1780 - x1675*x1693 + x1795*x2*x21*x424 - 4*x511)), -x1748*x547 - x97*(x1763*x545 + x1814 + x67*(x1805 + x81*(x1099*x1782 - x1105*x1778 + x1800) + x82*(-x1099*x1780 + x14*x1453*x1776*x21*x530*x9 - x1804) + x83*(x1105*x1780 - x1588*x1782 + x1801)) + x796*(-x1099*x1806 - x1105*x1786 - x1588*x1807 - x1811)), -x1748*x565 - x97*(x1763*x563 + x1823 + x67*(x1819 + x81*(-x1116*x1778 + x1453*x17*x1776*x21*x549*x6 - x1816) + x82*(-x1109*x1780 + x14*x1453*x1776*x21*x549*x9 - x1818) + x83*(x1116*x1780 - x1604*x1782 + x1817)) + x796*(-x1109*x1806 - x1116*x1786 - x1604*x1807 - x1822)), -x1748*x583 - x97*(x1763*x581 + x1829 + x67*(x1827 + x81*(x1120*x1782 - x1126*x1778 + x1824) + x82*(-x1120*x1780 + x14*x1453*x1776*x21*x567*x9 - x1576 - x1826) + x83*(x1126*x1780 - x1618*x1782 + x1705 + x1825)) + x796*(-x1120*x1806 - x1126*x1786 - 4*x1472 - x1618*x1807 - x1828)), -x1830*x86 - x548, -x150*x1830 - x678, -x177*x1830 - x763, -x1830*x249 - x97*(x1108 + x1831*x196), -x1830*x341 - x97*(x1300 + x1831*x303), -x1830*x398 - x97*(x1418 + x1831*x374), -x1830*x461 - x97*(x1599 + x1831*x438 + x67*(x1594 + x81*(x1453*x17*x1832*x21*x7 + x1490*x17*x21*x424 - x1587 - x1835) + x82*(x1491*x1500 + x1593 - x1836*x7 + x1840) + x83*(x1590 + x1837 - x1839)) + x796*(-x1010*x1834 - x14*x1451*x21*x424 - x1598 - x1841*x974 - 2*x1842)), -x1830*x498 - x97*(x1732 + x1831*x480 + x67*(x1723 + x81*(x1720 - x1834*x8 + x1838*x974) + x82*(-x1722 - x1837 - x1843) + x83*(x1453*x1832*x2*x21*x8 - x1516*x1838 - x1721)) + x796*(-x1533*x1833 - x1730 - 2*x1835 - 2*x1844)), -x1830*x527 - x97*(x1814 + x1831*x512 + x67*(x1805 + x81*(x1800 + x1839 + x1843) + x82*(x10*x14*x1453*x1832*x21 - x1804 - x1842) + x83*(-x1557*x1833 + x1801 + x1844)) + x796*(-x1516*x1841 - x1572*x1836 - x1811 - 2*x1840)), -x1830*x547 - x97*(x1831*x545 + x541*x546 + x545**2*x774 + x67*(x81*(x1099*x1838 - x1105*x1834 + x1684 + x1726) + x82*(-x1099*x1836 + x14*x1453*x1832*x21*x530*x9 - x1680 - x1808) + x83*(x1105*x1836 + x1486 - x1588*x1838)) + x796*(-x1099*x1845 - x1105*x1841 - x1474 - x1588*x1846 - 4*x1718)), -x1830*x565 - x97*(x1831*x563 + x1851 + x67*(x81*(x1109*x1838 - x1116*x1834 + x1848) + x82*(-x1109*x1836 + x14*x1453*x1832*x21*x549*x9 - x1606) + x83*(x1116*x1836 + x1591 - x1604*x1838)) + x796*(-x1109*x1845 - x1116*x1841 - x1604*x1846 - x1849)), -x1830*x583 - x97*(x1831*x581 + x1854 + x67*(x81*(x1120*x1838 - x1126*x1834 + x1615) + x82*(-x1120*x1836 + x14*x1453*x1832*x21*x567*x9 - x1852) + x83*(x1453*x1832*x2*x21*x4*x567 - x1585 - x1618*x1838)) + x796*(-x1120*x1845 - x1126*x1841 - x1618*x1846 - x1853)), -x1855*x86 - x566, -x150*x1855 - x679, -x177*x1855 - x764, -x1855*x249 - x97*(x1119 + x1856*x196), -x1855*x341 - x97*(x1304 + x1856*x303), -x1855*x398 - x97*(x1419 + x1856*x374), -x1855*x461 - x97*(x1614 + x1856*x438 + x67*(x1609 + x81*(x1453*x17*x1857*x21*x7 - x1603 - x1860) + x82*(x1608 - x1861*x7 + x1865) + x83*(x1605 + x1862 + x1864)) + x796*(-x1010*x1859 - x1613 - x1866*x974 - 2*x1867)), -x1855*x498 - x97*(x1739 + x1856*x480 + x67*(x1737 + x81*(x1610*x1687 + x1734 - x1859*x8 + x1863*x974) + x82*(-x1736 - x1862 + x1868) + x83*(x1453*x1857*x2*x21*x8 - x1516*x1863 + x1682*x2*x21*x424 - x1735)) + x796*(-x1533*x1858 - x1673*x17*x21*x424 - x1738 - 2*x1860 - 2*x1869)), -x1855*x527 - x97*(x1823 + x1856*x512 + x67*(x1819 + x81*(-x1816 - x1864 - x1868) + x82*(x10*x14*x1453*x1857*x21 - x1818 - x1867) + x83*(-x1557*x1858 + x1817 + x1869)) + x796*(-x1516*x1866 - x1572*x1861 - x1822 - 2*x1865)), -x1855*x547 - x97*(x1851 + x1856*x545 + x67*(x81*(x1099*x1863 - x1105*x1859 + x1848) + x82*(-x1099*x1861 + x14*x1453*x1857*x21*x530*x9 - x1606) + x83*(x1105*x1861 - x1588*x1863 + x1591)) + x796*(-x1099*x1870 - x1105*x1866 - x1588*x1871 - x1849)), -x1855*x565 - x97*(x1856*x563 + x559*x564 + x563**2*x774 + x67*(x81*(-x1116*x1859 + x1453*x17*x1857*x21*x549*x6 - x1495 - x1612) + x82*(-x1109*x1861 + x14*x1453*x1857*x21*x549*x9 - x1680) + x83*(x1116*x1861 + x1486 - x1604*x1863 + x1820)) + x796*(-x1109*x1870 - x1116*x1866 - x1474 - 4*x1601 - x1604*x1871)), -x1855*x583 - x97*(x1856*x581 + x1874 + x67*(x81*(-x1126*x1859 + x1453*x17*x1857*x21*x567*x6 - x1624) + x82*(-x1120*x1861 + x1611 + x1618*x1859) + x83*(x1126*x1861 - x1618*x1863 + x1872)) + x796*(-x1120*x1870 - x1126*x1866 - x1618*x1871 - x1873)), -x1875*x86 - x584, -x150*x1875 - x680, -x177*x1875 - x765, -x1875*x249 - x97*(x1129 + x1876*x196), -x1875*x341 - x97*(x1308 + x1876*x303), -x1875*x398 - x97*(x1420 + x1876*x374), -x1875*x461 - x97*(x1627 + x1876*x438 + x67*(x1623 + x81*(x1453*x17*x1877*x21*x7 - x1617 - x1880) + x82*(x1622 - x1883*x7 + x1885) + x83*(-x1619 - x1882 - x1884)) + x796*(-x1010*x1879 - x1626 - x1886*x974 - 2*x1887)), -x1875*x498 - x97*(x1747 + x1876*x480 + x67*(x1744 + x81*(x1741 - x1879*x8 + x1881*x974) + x82*(x1743 + x1884 + x1888) + x83*(x1453*x1877*x2*x21*x8 - x1516*x1881 - x1742)) + x796*(-x1533*x1878 - x1746 - 2*x1880 - 2*x1889)), -x1875*x527 - x97*(x1829 + x1876*x512 + x67*(x1827 + x81*(x1824 + x1882 - x1888) + x82*(x10*x14*x1453*x1877*x21 + x14*x1796*x21*x424 - x1826 - x1887) + x83*(-x1557*x1878 + x1584*x1797 + x1825 + x1889)) + x796*(-x1516*x1886 - x1572*x1883 - x1795*x2*x21*x424 - x1828 - 2*x1885)), -x1875*x547 - x97*(x1854 + x1876*x545 + x67*(x81*(x1099*x1881 - x1105*x1879 + x1615) + x82*(-x1099*x1883 + x14*x1453*x1877*x21*x530*x9 - x1852) + x83*(x1453*x1877*x2*x21*x4*x530 - x1585 - x1588*x1881)) + x796*(-x1099*x1890 - x1105*x1886 - x1588*x1891 - x1853)), -x1875*x565 - x97*(x1874 + x1876*x563 + x67*(x81*(-x1116*x1879 + x1453*x17*x1877*x21*x549*x6 - x1624) + x82*(-x1109*x1883 + x1604*x1879 + x1611) + x83*(x1116*x1883 - x1604*x1881 + x1872)) + x796*(-x1109*x1890 - x1116*x1886 - x1604*x1891 - x1873)), -x1875*x583 - x97*(x1876*x581 + x577*x582 + x581**2*x774 + x67*(x81*(x1120*x1881 - x1126*x1879 + x1684) + x82*(-x1120*x1883 + x1504 + x1618*x1879 + x1625) + x83*(x1453*x1877*x2*x21*x4*x567 - x1589 - x1618*x1881 - x1745)) + x796*(-x1120*x1890 - x1126*x1886 - x1474 - x1618*x1891 - 4*x1620))], dtype=np.float64)


def q_d2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion2"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -m0 + o0
    x1 = -p1
    x2 = n1 + x1
    x3 = -p2
    x4 = o2 + x3
    x5 = -x4
    x6 = n2 + x3
    x7 = o1 + x1
    x8 = -x7
    x9 = -x2*x5 + x6*x8
    x10 = -p0
    x11 = o0 + x10
    x12 = -x11
    x13 = mpmath.sqrt(x12**2 + x5**2 + x8**2)
    x14 = -m1 + o1
    x15 = n0 + x10
    x16 = -x12*x6 + x15*x5
    x17 = -m2 + o2
    x18 = x12*x2 - x15*x8

    return mpmath.atan2(x0*x13*x9 + x13*x14*x16 + x13*x17*x18, x16*(x0*x4 + x12*x17) + x18*(x0*x8 + x11*x14) + x9*(x14*x5 + x17*x7))


def dq_d2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion2, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -p1
    x1 = n1 + x0
    x2 = -x1
    x3 = -p2
    x4 = o2 + x3
    x5 = -x4
    x6 = n2 + x3
    x7 = o1 + x0
    x8 = -x7
    x9 = x2*x5 + x6*x8
    x10 = -p0
    x11 = o0 + x10
    x12 = -x11
    x13 = mpmath.sqrt(x12**2 + x5**2 + x8**2)
    x14 = x13*x9
    x15 = -o0
    x16 = m0 + x15
    x17 = -x16
    x18 = x17*x8
    x19 = -o1
    x20 = m1 + x19
    x21 = -x20
    x22 = x11*x21
    x23 = x18 + x22
    x24 = n0 + x10
    x25 = -x24
    x26 = x1*x12 + x25*x8
    x27 = x17*x4
    x28 = -o2
    x29 = m2 + x28
    x30 = -x29
    x31 = x12*x30
    x32 = x27 + x31
    x33 = -x6
    x34 = x12*x33 + x24*x5
    x35 = x21*x5
    x36 = x30*x7
    x37 = x35 + x36
    x38 = x23*x26 + x32*x34 + x37*x9
    x39 = x13*x34
    x40 = x13*x26
    x41 = x14*x17 + x21*x39 + x30*x40
    x42 = (x38**2 + x41**2)**(-1)
    x43 = x38*x42
    x44 = -x41
    x45 = m1 + x0
    x46 = m2 + x3
    x47 = x42*x44
    x48 = x13*x21
    x49 = x13*x30
    x50 = x13**(-1)
    x51 = x11*x50
    x52 = x17*x9
    x53 = x34*x50
    x54 = x26*x30
    x55 = m0 + x10
    x56 = x13*x17
    x57 = x50*x52
    x58 = x21*x53
    x59 = x26*x50
    x60 = x50*x9
    x61 = x50*x54
    x62 = n1 + x19
    x63 = n2 + x28
    x64 = -x63
    x65 = n0 + x15
    x66 = -x65
    x67 = -x62

    return np.array([-x14*x43 + x42*x44*(x26*x7 + x34*x5), -x39*x43 + x42*x44*(x12*x26 + x4*x9), -x40*x43 + x42*x44*(x11*x34 + x8*x9), x43*(x14 + x2*x49 + x22*x53 + x48*x6 + x51*x52 + x51*x54) + x47*(x2*x23 - x26*x45 + x32*x6 + x34*x46), x43*(x24*x49 + x33*x56 + x36*x59 + x39 + x57*x7 + x58*x7) + x47*(x23*x24 + x26*x55 + x33*x37 - x46*x9), x43*(x1*x56 + x25*x48 + x27*x60 + x4*x58 + x4*x61 + x40) + x47*(x1*x37 + x25*x32 - x34*x55 + x45*x9), x43*(x12*x57 + x12*x58 + x31*x59 + x48*x64 + x49*x62) + x47*(x20*x26 + x23*x62 + x30*x34 + x32*x64), x43*(x18*x60 + x49*x66 + x56*x63 + x58*x8 + x61*x8) + x47*(x17*x26 + x23*x66 + x29*x9 + x37*x63), x43*(x35*x53 + x48*x65 + x5*x57 + x5*x61 + x56*x67) + x47*(x16*x34 + x21*x9 + x32*x65 + x37*x67), x43*(x13*x35 + x13*x36) + x47*(x23*x7 + x32*x5), x43*(x13*x27 + x13*x31) + x47*(x12*x23 + x37*x4), x43*(x13*x18 + x13*x22) + x47*(x11*x32 + x37*x8)], dtype=np.float64)


def d2q_d2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """Torsion2, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -p1
    x1 = n1 + x0
    x2 = -x1
    x3 = -p2
    x4 = o2 + x3
    x5 = -x4
    x6 = x2*x5
    x7 = n2 + x3
    x8 = o1 + x0
    x9 = -x8
    x10 = x7*x9
    x11 = x10 + x6
    x12 = -p0
    x13 = o0 + x12
    x14 = -x13
    x15 = x14**2
    x16 = x9**2
    x17 = x5**2
    x18 = x15 + x16 + x17
    x19 = mpmath.sqrt(x18)
    x20 = x11*x19
    x21 = -o0
    x22 = m0 + x21
    x23 = -x22
    x24 = x23*x9
    x25 = -o1
    x26 = m1 + x25
    x27 = -x26
    x28 = x13*x27
    x29 = x24 + x28
    x30 = n0 + x12
    x31 = -x30
    x32 = x31*x9
    x33 = x1*x14
    x34 = x32 + x33
    x35 = x23*x4
    x36 = -o2
    x37 = m2 + x36
    x38 = -x37
    x39 = x14*x38
    x40 = x35 + x39
    x41 = x30*x5
    x42 = -x7
    x43 = x14*x42
    x44 = x41 + x43
    x45 = x27*x5
    x46 = x38*x8
    x47 = x45 + x46
    x48 = x11*x47 + x29*x34 + x40*x44
    x49 = x19*x44
    x50 = x19*x34
    x51 = x20*x23 + x27*x49 + x38*x50
    x52 = x48**2 + x51**2
    x53 = x52**(-2)
    x54 = x34*x8
    x55 = x44*x5
    x56 = 2*x20
    x57 = -x48*(2*x54 + 2*x55) + x51*x56
    x58 = x53*x57
    x59 = x48*x58
    x60 = x54 + x55
    x61 = -x51
    x62 = x14*x34
    x63 = x11*x4
    x64 = x62 + x63
    x65 = x52**(-1)
    x66 = x60*x65
    x67 = x64*x65
    x68 = -x20*x67 + x49*x66
    x69 = x13*x44
    x70 = x11*x9
    x71 = x69 + x70
    x72 = x65*x71
    x73 = -x20*x72 + x50*x66
    x74 = m1 + x0
    x75 = -x74
    x76 = x34*x75
    x77 = m2 + x3
    x78 = x44*x77
    x79 = x2*x29
    x80 = x40*x7
    x81 = x76 + x78 + x79 + x80
    x82 = x65*x81
    x83 = x20*x82
    x84 = x2*x8 + x5*x7
    x85 = x61*x65
    x86 = x48*x65
    x87 = x19**(-1)
    x88 = x11*x87
    x89 = x13*x88
    x90 = x86*x89
    x91 = x19*x7
    x92 = x27*x91
    x93 = x19*x2
    x94 = x38*x93
    x95 = x23*x88
    x96 = x13*x95
    x97 = x44*x87
    x98 = x28*x97
    x99 = x13*x38
    x100 = x34*x87
    x101 = x100*x99
    x102 = x101 + x20 + x92 + x94 + x96 + x98
    x103 = x58*x61
    x104 = m0 + x12
    x105 = x104*x34
    x106 = -x77
    x107 = x106*x11
    x108 = x29*x30
    x109 = x42*x47
    x110 = x105 + x107 + x108 + x109
    x111 = x110*x65
    x112 = x111*x20
    x113 = x30*x8 + x34
    x114 = x19*x42
    x115 = x8*x88
    x116 = x114 + x115
    x117 = x114*x23
    x118 = x19*x30
    x119 = x118*x38
    x120 = x23*x8
    x121 = x120*x88
    x122 = x27*x97
    x123 = x122*x8
    x124 = x100*x46
    x125 = x117 + x119 + x121 + x123 + x124 + x49
    x126 = -x104
    x127 = x126*x44
    x128 = x11*x74
    x129 = x31*x40
    x130 = x1*x47
    x131 = x127 + x128 + x129 + x130
    x132 = x131*x65
    x133 = x132*x20
    x134 = x31*x5 - x44
    x135 = x1*x19
    x136 = x63*x87
    x137 = x135 + x136
    x138 = x135*x23
    x139 = x19*x31
    x140 = x139*x27
    x141 = x35*x88
    x142 = x27*x4
    x143 = x142*x97
    x144 = x100*x38
    x145 = x144*x4
    x146 = x138 + x140 + x141 + x143 + x145 + x50
    x147 = x26*x34
    x148 = x38*x44
    x149 = n1 + x25
    x150 = x149*x29
    x151 = n2 + x36
    x152 = -x151
    x153 = x152*x40
    x154 = x147 + x148 + x150 + x153
    x155 = x154*x65
    x156 = x155*x20
    x157 = x149*x8 + x152*x5
    x158 = x14*x88
    x159 = x158*x86
    x160 = x152*x19
    x161 = x160*x27
    x162 = x149*x19
    x163 = x162*x38
    x164 = x14*x23
    x165 = x164*x88
    x166 = x14*x97
    x167 = x100*x39
    x168 = x161 + x163 + x165 + x166*x27 + x167
    x169 = x23*x34
    x170 = x11*x37
    x171 = n0 + x21
    x172 = -x171
    x173 = x172*x29
    x174 = x151*x47
    x175 = x169 + x170 + x173 + x174
    x176 = x175*x65
    x177 = x176*x20
    x178 = x172*x8 - x34
    x179 = x151*x19
    x180 = x70*x87
    x181 = x179 + x180
    x182 = x179*x23
    x183 = x172*x19
    x184 = x183*x38
    x185 = x24*x88
    x186 = x27*x9
    x187 = x186*x97
    x188 = x100*x9
    x189 = x188*x38
    x190 = x182 + x184 + x185 + x187 + x189
    x191 = x22*x44
    x192 = x11*x27
    x193 = x171*x40
    x194 = -x149
    x195 = x194*x47
    x196 = x191 + x192 + x193 + x195
    x197 = x196*x65
    x198 = x197*x20
    x199 = x171*x5 + x44
    x200 = x19*x194
    x201 = x5*x88
    x202 = x200 + x201
    x203 = x200*x23
    x204 = x171*x19
    x205 = x204*x27
    x206 = x201*x23
    x207 = x45*x97
    x208 = x38*x5
    x209 = x100*x208
    x210 = x203 + x205 + x206 + x207 + x209
    x211 = x29*x8
    x212 = x40*x5
    x213 = x211 + x212
    x214 = x213*x65
    x215 = x20*x214
    x216 = x19*x45
    x217 = x19*x46
    x218 = x216 + x217
    x219 = x8**2
    x220 = x85*(x17 + x219)
    x221 = x19*x35
    x222 = x19*x39
    x223 = x221 + x222
    x224 = x14*x29
    x225 = x4*x47
    x226 = x224 + x225
    x227 = x226*x65
    x228 = x20*x227
    x229 = x14*x8
    x230 = x229*x85
    x231 = x19*x4
    x232 = x230 - x231*x86
    x233 = x19*x24
    x234 = x19*x28
    x235 = x233 + x234
    x236 = x13*x40
    x237 = x47*x9
    x238 = x236 + x237
    x239 = x238*x65
    x240 = x20*x239
    x241 = x13*x5
    x242 = x241*x85
    x243 = x19*x9
    x244 = x242 - x243*x86
    x245 = 2*x49
    x246 = x245*x51 - x48*(2*x62 + 2*x63)
    x247 = x246*x53
    x248 = x247*x61
    x249 = x247*x48
    x250 = -x49*x72 + x50*x67
    x251 = x49*x82
    x252 = x14*x2 - x34
    x253 = x69*x87
    x254 = x253 + x91
    x255 = x111*x49
    x256 = x14*x30 + x4*x42
    x257 = x8*x97
    x258 = x257*x86
    x259 = x132*x49
    x260 = x1*x4 + x11
    x261 = x4*x97
    x262 = x139 + x261
    x263 = x155*x49
    x264 = x14*x149 + x34
    x265 = x160 + x166
    x266 = x176*x49
    x267 = x14*x172 + x151*x4
    x268 = x9*x97
    x269 = x268*x86
    x270 = x197*x49
    x271 = -x11 + x194*x4
    x272 = x55*x87
    x273 = x204 + x272
    x274 = x214*x49
    x275 = x19*x5
    x276 = x230 - x275*x86
    x277 = x227*x49
    x278 = x4**2
    x279 = x85*(x15 + x278)
    x280 = x239*x49
    x281 = x13*x19
    x282 = x281*x86
    x283 = x4*x9
    x284 = x283*x85
    x285 = 2*x50
    x286 = x285*x51 - x48*(2*x69 + 2*x70)
    x287 = x286*x53
    x288 = x287*x61
    x289 = x287*x48
    x290 = x50*x82
    x291 = x13*x7 + x44
    x292 = x100*x13
    x293 = x292 + x93
    x294 = x111*x50
    x295 = -x11 + x42*x9
    x296 = x54*x87
    x297 = x118 + x296
    x298 = x132*x50
    x299 = x1*x9 + x13*x31
    x300 = x100*x4
    x301 = x300*x86
    x302 = x155*x50
    x303 = x13*x152 - x44
    x304 = x62*x87
    x305 = x162 + x304
    x306 = x176*x50
    x307 = x11 + x151*x9
    x308 = x183 + x188
    x309 = x197*x50
    x310 = x13*x171 + x194*x9
    x311 = x100*x5
    x312 = x311*x86
    x313 = x214*x50
    x314 = x19*x8
    x315 = x242 - x314*x86
    x316 = x227*x50
    x317 = x14*x19
    x318 = x317*x86
    x319 = x239*x50
    x320 = x13**2
    x321 = x85*(x16 + x320)
    x322 = -x102
    x323 = -x48*(2*x76 + 2*x78 + 2*x79 + 2*x80) - x51*(2*x101 + x56 + 2*x92 + 2*x94 + 2*x96 + 2*x98)
    x324 = x323*x53
    x325 = x324*x48
    x326 = 2*x2
    x327 = 2*x7
    x328 = x28*x87
    x329 = x87*x99
    x330 = x18**(mpmath.mpf(-3)/mpmath.mpf(2))
    x331 = x13*x330
    x332 = x11*x164
    x333 = x14*x330
    x334 = x333*x44
    x335 = x34*x39
    x336 = x122 + x144 + x95
    x337 = x28*x334 + x331*x332 + x331*x335 + x336
    x338 = x324*x61
    x339 = x85*(x104*x2 + x30*x75)
    x340 = x322*x65
    x341 = x11*x333
    x342 = x27*x44
    x343 = x120*x341 + x229*x330*x342 + x330*x39*x54
    x344 = x27*x87
    x345 = x344*x7
    x346 = x23*x87
    x347 = x13*x346
    x348 = x2*x87
    x349 = x116 + x254 + x30*x329 + x345*x8 + x347*x42 + x348*x46
    x350 = x85*(x126*x7 + x31*x77)
    x351 = x330*x335
    x352 = x142*x334 + x341*x35 + x351*x4
    x353 = x7*x87
    x354 = x38*x87
    x355 = x2*x354
    x356 = x1*x347 + x137 + x142*x353 + x293 + x31*x328 + x355*x4
    x357 = x85*(x149*x75 + x152*x77 + x2*x26 + x38*x7)
    x358 = x15*x330
    x359 = x11*x23
    x360 = x34*x38
    x361 = -x122 - x144 - x95
    x362 = x14*x345 + x149*x329 + x152*x328 + x158 + x348*x39 + x361
    x363 = x29 + x34
    x364 = x85*(x172*x75 + x2*x23 + x363)
    x365 = x186*x334 + x24*x341 + x351*x9
    x366 = x19*x38
    x367 = x10*x344 + x151*x347 + x172*x329 + x181 + x355*x9 + x366
    x368 = x40 + x44
    x369 = x85*(x171*x77 + x22*x7 - x368)
    x370 = x330*x5
    x371 = x332*x370 + x334*x45 + x351*x5
    x372 = x19*x27
    x373 = -x372
    x374 = x171*x328 + x194*x347 + x202 + x353*x45 + x354*x6 + x373
    x375 = x328*x5
    x376 = x13*x87
    x377 = x85*(x5*x77 + x75*x8) + x86*(x375 + x376*x46)
    x378 = -x366
    x379 = x85*(x14*x75 - x29) + x86*(x231 + x35*x376 + x376*x39 + x378)
    x380 = x85*(x13*x77 + x40) + x86*(x24*x376 + x243 + x320*x344 + x372)
    x381 = -x125
    x382 = -x48*(2*x105 + 2*x107 + 2*x108 + 2*x109) - x51*(2*x117 + 2*x119 + 2*x121 + 2*x123 + 2*x124 + x245)
    x383 = x382*x53
    x384 = x383*x48
    x385 = x11*x24
    x386 = x330*x9
    x387 = x386*x44
    x388 = x34*x386
    x389 = x28*x387 + x331*x385 + x388*x99
    x390 = x383*x61
    x391 = 2*x30
    x392 = 2*x42
    x393 = x46*x87
    x394 = x120*x87
    x395 = x330*x8
    x396 = x395*x44
    x397 = x186*x396 + x336 + x385*x395 + x388*x46
    x398 = x85*(x1*x106 + x42*x74)
    x399 = x381*x65
    x400 = x142*x387 + x283*x330*x360 + x330*x35*x70
    x401 = x30*x354
    x402 = x42*x87
    x403 = x344*x8
    x404 = x1*x394 + x262 + x297 + x31*x403 + x35*x402 + x4*x401
    x405 = x85*(x104*x149 + x26*x30 - x363)
    x406 = x39*x87
    x407 = x149*x393 + x152*x403 + x265 + x30*x406 + x346*x43 + x378
    x408 = x85*(x104*x172 + x106*x151 + x23*x30 + x37*x42)
    x409 = x16*x330
    x410 = x151*x394 + x172*x393 + x24*x402 + x268 + x361 + x401*x9
    x411 = x11 + x47
    x412 = x85*(x106*x194 + x27*x42 + x411)
    x413 = x208*x388 + x370*x385 + x387*x45
    x414 = x19*x23
    x415 = x346*x5
    x416 = x171*x403 + x194*x394 + x273 + x354*x41 + x414 + x415*x42
    x417 = x8*x87
    x418 = x85*(x104*x8 + x29) + x86*(x219*x354 + x275 + x366 + x417*x45)
    x419 = x406*x8
    x420 = x85*(x104*x14 + x106*x4) + x86*(x35*x417 + x419)
    x421 = -x414
    x422 = x85*(x106*x9 - x47) + x86*(x24*x417 + x281 + x328*x8 + x421)
    x423 = -x146
    x424 = -x48*(2*x127 + 2*x128 + 2*x129 + 2*x130) - x51*(2*x138 + 2*x140 + 2*x141 + 2*x143 + 2*x145 + x285)
    x425 = x424*x53
    x426 = x425*x48
    x427 = x28*x330
    x428 = x208*x34
    x429 = x241*x330*x359 + x331*x428 + x427*x55
    x430 = x425*x61
    x431 = x11*x370
    x432 = x34*x46
    x433 = x120*x431 + x370*x432 + x396*x45
    x434 = 2*x31
    x435 = 2*x1
    x436 = x35*x87
    x437 = x142*x87
    x438 = x330*x4
    x439 = x336 + x35*x431 + x428*x438 + x438*x44*x45
    x440 = x85*(x126*x152 + x31*x38 + x368)
    x441 = x423*x65
    x442 = x354*x4
    x443 = x14*x344
    x444 = x149*x442 + x152*x437 + x305 + x31*x443 + x33*x346 + x372
    x445 = x85*(x1*x37 + x151*x74 - x411)
    x446 = x24*x87
    x447 = x1*x446 + x151*x436 + x172*x442 + x308 + x32*x344 + x421
    x448 = x85*(x1*x27 + x126*x171 + x194*x74 + x22*x31)
    x449 = x17*x330
    x450 = x45*x87
    x451 = x1*x415 + x171*x437 + x194*x436 + x31*x450 + x311 + x361
    x452 = x85*(x126*x5 - x40) + x86*(x314 + x373 + x393*x4 + x4*x450)
    x453 = x85*(x4*x74 + x47) + x86*(x278*x346 + x317 + x4*x406 + x414)
    x454 = x436*x9
    x455 = x85*(x126*x13 + x74*x9) + x86*(x328*x4 + x454)
    x456 = -x168
    x457 = 2*x27
    x458 = -x48*(2*x147 + 2*x148 + 2*x150 + 2*x153) - x51*(2*x161 + 2*x163 + 2*x165 + x166*x457 + 2*x167)
    x459 = x458*x53
    x460 = x459*x48
    x461 = x320*x330
    x462 = x459*x61
    x463 = x11*x331
    x464 = x120*x463 + x28*x396 + x331*x432
    x465 = x34*x438*x99 + x35*x463 + x4*x427*x44
    x466 = 2*x149
    x467 = 2*x152
    x468 = x85*(x149*x23 + x172*x26)
    x469 = x456*x65
    x470 = x354*x9
    x471 = x164*x87
    x472 = x186*x87
    x473 = x149*x470 + x151*x471 + x152*x472 + x172*x406
    x474 = x85*(x152*x22 + x171*x38)
    x475 = x208*x87
    x476 = x149*x475 + x152*x450 + x171*x443 + x194*x471
    x477 = x85*(x208 + x26*x8) + x86*(x14*x450 + x419)
    x478 = x85*(x14*x26 + x29) + x86*(x14*x436 + x15*x354 + x366)
    x479 = x85*(x13*x38 - x40) + x86*(x14*x328 + x14*x446 + x373)
    x480 = -x190
    x481 = -x48*(2*x169 + 2*x170 + 2*x173 + 2*x174) - x51*(2*x182 + 2*x184 + 2*x185 + 2*x187 + 2*x189)
    x482 = x481*x53
    x483 = x48*x482
    x484 = x482*x61
    x485 = x219*x330
    x486 = x11*x35*x395 + x142*x396 + x432*x438
    x487 = 2*x172
    x488 = 2*x151
    x489 = x85*(x151*x27 + x194*x37)
    x490 = x480*x65
    x491 = x151*x415 + x171*x472 + x172*x475 + x194*x446
    x492 = x85*(x23*x8 - x29) + x86*(x378 + x393*x9 + x450*x9)
    x493 = x85*(x164 + x37*x4) + x86*(x406*x9 + x454)
    x494 = x85*(x37*x9 + x47) + x86*(x16*x346 + x328*x9 + x414)
    x495 = -x210
    x496 = -x48*(2*x191 + 2*x192 + 2*x193 + 2*x195) - x51*(2*x203 + 2*x205 + 2*x206 + 2*x207 + 2*x209)
    x497 = x496*x53
    x498 = x48*x497
    x499 = x497*x61
    x500 = x278*x330
    x501 = 2*x171
    x502 = x495*x65
    x503 = x85*(x22*x5 + x40) + x86*(x17*x344 + x372 + x393*x5)
    x504 = x85*(x27*x4 - x47) + x86*(x406*x5 + x421 + x436*x5)
    x505 = x85*(x13*x22 + x186) + x86*(x375 + x446*x5)
    x506 = -x218
    x507 = x53*(-x48*(2*x211 + 2*x212) - x51*(2*x216 + 2*x217))
    x508 = x48*x507
    x509 = x507*x61
    x510 = x506*x65
    x511 = -x223
    x512 = -x48*(2*x224 + 2*x225) - x51*(2*x221 + 2*x222)
    x513 = x512*x53
    x514 = x513*x61
    x515 = x48*x513
    x516 = -x4*x61*x65*x9
    x517 = -x235
    x518 = -x48*(2*x236 + 2*x237) - x51*(2*x233 + 2*x234)
    x519 = x518*x53
    x520 = x519*x61
    x521 = x48*x519

    return np.array([-x20*x59 + x53*x57*x60*x61, -x49*x59 + x53*x57*x61*x64 - x68, -x50*x59 + x53*x57*x61*x71 - x73, x102*x59 + x102*x66 + x103*x81 + x83 + x84*x85 - x90, x103*x110 + x112 + x113*x85 - x116*x86 + x125*x59 + x125*x66, x103*x131 + x133 + x134*x85 - x137*x86 + x146*x59 + x146*x66, x103*x154 + x156 + x157*x85 - x159 + x168*x59 + x168*x66, x103*x175 + x177 + x178*x85 - x181*x86 + x190*x59 + x190*x66, x103*x196 + x198 + x199*x85 - x202*x86 + x210*x59 + x210*x66, x103*x213 + x215 + x218*x59 + x218*x66 + x220, x103*x226 + x223*x59 + x223*x66 + x228 + x232, x103*x238 + x235*x59 + x235*x66 + x240 + x244, -x20*x249 + x248*x60 + x68, x246*x53*x61*x64 - x249*x49, x246*x53*x61*x71 - x249*x50 - x250, x102*x249 + x102*x67 + x248*x81 + x251 + x252*x85 - x254*x86, x110*x248 + x125*x249 + x125*x67 + x255 + x256*x85 - x258, x131*x248 + x146*x249 + x146*x67 + x259 + x260*x85 - x262*x86, x154*x248 + x168*x249 + x168*x67 + x263 + x264*x85 - x265*x86, x175*x248 + x190*x249 + x190*x67 + x266 + x267*x85 - x269, x196*x248 + x210*x249 + x210*x67 + x270 + x271*x85 - x273*x86, x213*x248 + x218*x249 + x218*x67 + x274 + x276, x223*x249 + x223*x67 + x226*x248 + x277 + x279, x235*x249 + x235*x67 + x238*x248 + x280 - x282 + x284, -x20*x289 + x288*x60 + x73, x250 + x288*x64 - x289*x49, x286*x53*x61*x71 - x289*x50, x102*x289 + x102*x72 + x288*x81 + x290 + x291*x85 - x293*x86, x110*x288 + x125*x289 + x125*x72 + x294 + x295*x85 - x297*x86, x131*x288 + x146*x289 + x146*x72 + x298 + x299*x85 - x301, x154*x288 + x168*x289 + x168*x72 + x302 + x303*x85 - x305*x86, x175*x288 + x190*x289 + x190*x72 + x306 + x307*x85 - x308*x86, x196*x288 + x210*x289 + x210*x72 + x309 + x310*x85 - x312, x213*x288 + x218*x289 + x218*x72 + x313 + x315, x223*x289 + x223*x72 + x226*x288 + x284 + x316 - x318, x235*x289 + x235*x72 + x238*x288 + x319 + x321, -x20*x325 + x322*x60*x65 + x323*x53*x60*x61 + x61*x65*x84 - x83 - x90, -x251 + x252*x61*x65 - x253*x86 + x322*x64*x65 + x323*x53*x61*x64 - x325*x49 - x86*x91, -x290 + x291*x61*x65 - x292*x86 + x322*x65*x71 + x323*x53*x61*x71 - x325*x50 - x86*x93, x102*x325 + x102*x82 + x322*x82 + x338*x81 + x85*(x326*x75 + x327*x77) + x86*(x326*x329 + x327*x328 + x337 + 2*x89), x110*x338 + x110*x340 + x125*x325 + x125*x82 + x339 + x86*(x343 + x349), x131*x338 + x131*x340 + x146*x325 + x146*x82 + x350 + x86*(x352 + x356), x154*x338 + x154*x340 + x168*x325 + x168*x82 + x357 + x86*(x342*x358 + x358*x359 + x358*x360 + x362), x175*x338 + x175*x340 + x190*x325 + x190*x82 + x364 + x86*(x365 + x367), x196*x338 + x196*x340 + x210*x325 + x210*x82 + x369 + x86*(x371 + x374), x213*x338 + x213*x340 + x218*x325 + x218*x82 + x377, x223*x325 + x223*x82 + x226*x338 + x226*x340 + x379, x235*x325 + x235*x82 + x238*x338 + x238*x340 + x380, -x112 + x113*x61*x65 - x114*x86 - x115*x86 - x20*x384 + x381*x60*x65 + x382*x53*x60*x61, -x255 + x256*x61*x65 - x258 + x381*x64*x65 + x382*x53*x61*x64 - x384*x49, -x118*x86 - x294 + x295*x61*x65 - x296*x86 + x381*x65*x71 + x382*x53*x61*x71 - x384*x50, x102*x111 + x102*x384 + x339 + x381*x82 + x390*x81 + x86*(x349 + x389), x110*x390 + x111*x125 + x111*x381 + x125*x384 + x85*(x104*x391 + x106*x392) + x86*(2*x257 + x391*x393 + x392*x394 + x397), x111*x146 + x131*x390 + x131*x399 + x146*x384 + x398 + x86*(x400 + x404), x111*x168 + x154*x390 + x154*x399 + x168*x384 + x405 + x86*(x365 + x407), x111*x190 + x175*x390 + x175*x399 + x190*x384 + x408 + x86*(x342*x409 + x359*x409 + x360*x409 + x410), x111*x210 + x196*x390 + x196*x399 + x210*x384 + x412 + x86*(x413 + x416), x111*x218 + x213*x390 + x213*x399 + x218*x384 + x418, x111*x223 + x223*x384 + x226*x390 + x226*x399 + x420, x111*x235 + x235*x384 + x238*x390 + x238*x399 + x422, -x133 + x134*x61*x65 - x135*x86 - x136*x86 - x20*x426 + x423*x60*x65 + x424*x53*x60*x61, -x139*x86 - x259 + x260*x61*x65 - x261*x86 + x423*x64*x65 + x424*x53*x61*x64 - x426*x49, -x298 + x299*x61*x65 - x301 + x423*x65*x71 + x424*x53*x61*x71 - x426*x50, x102*x132 + x102*x426 + x350 + x423*x82 + x430*x81 + x86*(x356 + x429), x110*x430 + x111*x423 + x125*x132 + x125*x426 + x398 + x86*(x404 + x433), x131*x430 + x132*x146 + x132*x423 + x146*x426 + x85*(x126*x434 + x435*x74) + x86*(2*x300 + x434*x437 + x435*x436 + x439), x132*x168 + x154*x430 + x154*x441 + x168*x426 + x440 + x86*(x371 + x444), x132*x190 + x175*x430 + x175*x441 + x190*x426 + x445 + x86*(x413 + x447), x132*x210 + x196*x430 + x196*x441 + x210*x426 + x448 + x86*(x342*x449 + x359*x449 + x360*x449 + x451), x132*x218 + x213*x430 + x213*x441 + x218*x426 + x452, x132*x223 + x223*x426 + x226*x430 + x226*x441 + x453, x132*x235 + x235*x426 + x238*x430 + x238*x441 + x455, -x156 + x157*x61*x65 - x159 - x20*x460 + x456*x60*x65 + x458*x53*x60*x61, -x160*x86 - x166*x86 - x263 + x264*x61*x65 + x456*x64*x65 + x458*x53*x61*x64 - x460*x49, -x162*x86 - x302 + x303*x61*x65 - x304*x86 + x456*x65*x71 + x458*x53*x61*x71 - x460*x50, x102*x155 + x102*x460 + x357 + x456*x82 + x462*x81 + x86*(x342*x461 + x359*x461 + x360*x461 + x362), x110*x462 + x111*x456 + x125*x155 + x125*x460 + x405 + x86*(x407 + x464), x131*x462 + x132*x456 + x146*x155 + x146*x460 + x440 + x86*(x444 + x465), x154*x462 + x155*x168 + x155*x456 + x168*x460 + x85*(x26*x466 + x38*x467) + x86*(x337 + x406*x466 + x443*x467), x155*x190 + x175*x462 + x175*x469 + x190*x460 + x468 + x86*(x389 + x473), x155*x210 + x196*x462 + x196*x469 + x210*x460 + x474 + x86*(x429 + x476), x155*x218 + x213*x462 + x213*x469 + x218*x460 + x477, x155*x223 + x223*x460 + x226*x462 + x226*x469 + x478, x155*x235 + x235*x460 + x238*x462 + x238*x469 + x479, -x177 + x178*x61*x65 - x179*x86 - x180*x86 - x20*x483 + x480*x60*x65 + x481*x53*x60*x61, -x266 + x267*x61*x65 - x269 + x480*x64*x65 + x481*x53*x61*x64 - x483*x49, -x183*x86 - x188*x86 - x306 + x307*x61*x65 + x480*x65*x71 + x481*x53*x61*x71 - x483*x50, x102*x176 + x102*x483 + x364 + x480*x82 + x484*x81 + x86*(x367 + x464), x110*x484 + x111*x480 + x125*x176 + x125*x483 + x408 + x86*(x342*x485 + x359*x485 + x360*x485 + x410), x131*x484 + x132*x480 + x146*x176 + x146*x483 + x445 + x86*(x447 + x486), x154*x484 + x155*x480 + x168*x176 + x168*x483 + x468 + x86*(x343 + x473), x175*x484 + x176*x190 + x176*x480 + x190*x483 + x85*(x23*x487 + x37*x488) + x86*(x397 + x446*x488 + x470*x487), x176*x210 + x196*x484 + x196*x490 + x210*x483 + x489 + x86*(x433 + x491), x176*x218 + x213*x484 + x213*x490 + x218*x483 + x492, x176*x223 + x223*x483 + x226*x484 + x226*x490 + x493, x176*x235 + x235*x483 + x238*x484 + x238*x490 + x494, -x198 + x199*x61*x65 - x20*x498 - x200*x86 - x201*x86 + x495*x60*x65 + x496*x53*x60*x61, -x204*x86 - x270 + x271*x61*x65 - x272*x86 - x49*x498 + x495*x64*x65 + x496*x53*x61*x64, -x309 + x310*x61*x65 - x312 + x495*x65*x71 + x496*x53*x61*x71 - x498*x50, x102*x197 + x102*x498 + x369 + x495*x82 + x499*x81 + x86*(x374 + x465), x110*x499 + x111*x495 + x125*x197 + x125*x498 + x412 + x86*(x416 + x486), x131*x499 + x132*x495 + x146*x197 + x146*x498 + x448 + x86*(x342*x500 + x359*x500 + x360*x500 + x451), x154*x499 + x155*x495 + x168*x197 + x168*x498 + x474 + x86*(x352 + x476), x175*x499 + x176*x495 + x190*x197 + x190*x498 + x489 + x86*(x400 + x491), x196*x499 + x197*x210 + x197*x495 + x210*x498 + x85*(x194*x457 + x22*x501) + x86*(2*x194*x415 + x439 + x450*x501), x197*x218 + x213*x499 + x213*x502 + x218*x498 + x503, x197*x223 + x223*x498 + x226*x499 + x226*x502 + x504, x197*x235 + x235*x498 + x238*x499 + x238*x502 + x505, -x20*x508 - x215 + x220 + x506*x66 + x509*x60, -x274 + x276 - x49*x508 + x506*x67 + x509*x64, -x313 + x315 - x50*x508 + x506*x72 + x509*x71, x102*x214 + x102*x508 + x377 + x506*x82 + x509*x81, x110*x509 + x111*x506 + x125*x214 + x125*x508 + x418, x131*x509 + x132*x506 + x146*x214 + x146*x508 + x452, x154*x509 + x155*x506 + x168*x214 + x168*x508 + x477, x175*x509 + x176*x506 + x190*x214 + x190*x508 + x492, x196*x509 + x197*x506 + x210*x214 + x210*x508 + x503, x213*x509 + x214*x218 + x214*x506 + x218*x508, x214*x223 + x223*x508 + x226*x509 + x226*x510, x214*x235 + x235*x508 + x238*x509 + x238*x510, -x20*x515 - x228 + x232 + x511*x66 + x514*x60, -x277 + x279 - x49*x515 + x511*x67 + x514*x64, -x316 - x318 - x50*x515 + x511*x65*x71 + x512*x53*x61*x71 - x516, x102*x227 + x102*x515 + x379 + x511*x82 + x514*x81, x110*x514 + x111*x511 + x125*x227 + x125*x515 + x420, x131*x514 + x132*x511 + x146*x227 + x146*x515 + x453, x154*x514 + x155*x511 + x168*x227 + x168*x515 + x478, x175*x514 + x176*x511 + x190*x227 + x190*x515 + x493, x196*x514 + x197*x511 + x210*x227 + x210*x515 + x504, x213*x514 + x214*x511 + x218*x227 + x218*x515, x223*x227 + x223*x515 + x226*x514 + x227*x511, x227*x235 + x235*x515 + x238*x514 + x239*x511, -x20*x521 - x240 + x244 + x517*x66 + x520*x60, -x280 - x282 - x49*x521 - x516 + x517*x64*x65 + x518*x53*x61*x64, -x319 + x321 - x50*x521 + x517*x72 + x520*x71, x102*x239 + x102*x521 + x380 + x517*x82 + x520*x81, x110*x520 + x111*x517 + x125*x239 + x125*x521 + x422, x131*x520 + x132*x517 + x146*x239 + x146*x521 + x455, x154*x520 + x155*x517 + x168*x239 + x168*x521 + x479, x175*x520 + x176*x517 + x190*x239 + x190*x521 + x494, x196*x520 + x197*x517 + x210*x239 + x210*x521 + x505, x213*x520 + x214*x517 + x218*x239 + x218*x521, x223*x239 + x223*x521 + x226*x520 + x227*x517, x235*x239 + x235*x521 + x238*x520 + x239*x517], dtype=np.float64)


def q_rd1(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """RobustTorsion1"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - o0
    x1 = n0 - p0
    x2 = m1 - o1
    x3 = m2 - o2
    x4 = n1 - p1
    x5 = n2 - p2
    x6 = 1/(mpmath.sqrt(x0**2 + x2**2 + x3**2)*mpmath.sqrt(x1**2 + x4**2 + x5**2))

    return x0*x1*x6 + x2*x4*x6 + x3*x5*x6


def dq_rd1(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """RobustTorsion1, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = n0 - p0
    x1 = m0 - o0
    x2 = x1**2
    x3 = m1 - o1
    x4 = x3**2
    x5 = m2 - o2
    x6 = x5**2
    x7 = x2 + x4 + x6
    x8 = 1/mpmath.sqrt(x7)
    x9 = x0**2
    x10 = n1 - p1
    x11 = x10**2
    x12 = n2 - p2
    x13 = x12**2
    x14 = x11 + x13 + x9
    x15 = 1/mpmath.sqrt(x14)
    x16 = x15*x8
    x17 = x0*x16
    x18 = -x1
    x19 = x15/x7**(mpmath.mpf(3)/mpmath.mpf(2))
    x20 = x0*x19
    x21 = x1*x20
    x22 = x10*x19
    x23 = x22*x3
    x24 = x12*x19
    x25 = x24*x5
    x26 = x10*x16
    x27 = -x3
    x28 = x12*x16
    x29 = -x5
    x30 = x1*x16
    x31 = x8/x14**(mpmath.mpf(3)/mpmath.mpf(2))
    x32 = x1*x31
    x33 = x3*x31
    x34 = x0*x10
    x35 = x31*x5
    x36 = x12*x35
    x37 = x16*x3
    x38 = x16*x5
    x39 = x0*x32
    x40 = x10*x33
    x41 = -x0
    x42 = -x10
    x43 = -x12

    return np.array([x17 + x18*x21 + x18*x23 + x18*x25, x21*x27 + x23*x27 + x25*x27 + x26, x21*x29 + x23*x29 + x25*x29 + x28, x1*x23 + x1*x25 - x17 + x2*x20, x21*x3 + x22*x4 + x25*x3 - x26, x21*x5 + x23*x5 + x24*x6 - x28, x0*x36 - x30 + x32*x9 + x33*x34, x10*x36 + x11*x33 + x32*x34 - x37, x12*x39 + x12*x40 + x13*x35 - x38, x30 + x36*x41 + x39*x41 + x40*x41, x36*x42 + x37 + x39*x42 + x40*x42, x36*x43 + x38 + x39*x43 + x40*x43], dtype=np.float64)


def d2q_rd1(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """RobustTorsion1, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - o0
    x1 = -x0
    x2 = n0 - p0
    x3 = x2**2
    x4 = n1 - p1
    x5 = x4**2
    x6 = n2 - p2
    x7 = x6**2
    x8 = x3 + x5 + x7
    x9 = 1/mpmath.sqrt(x8)
    x10 = x0**2
    x11 = m1 - o1
    x12 = x11**2
    x13 = m2 - o2
    x14 = x13**2
    x15 = x10 + x12 + x14
    x16 = x15**(mpmath.mpf(-3)/mpmath.mpf(2))
    x17 = x16*x9
    x18 = x17*x2
    x19 = x1*x18
    x20 = 3*m0 - 3*o0
    x21 = x9/x15**(mpmath.mpf(5)/mpmath.mpf(2))
    x22 = -x20*x21
    x23 = x1*x22
    x24 = x0*x2
    x25 = x11*x4
    x26 = x13*x6
    x27 = x0*x18
    x28 = x17*x4
    x29 = x11*x28
    x30 = x17*x6
    x31 = x13*x30
    x32 = -x27 - x29 - x31
    x33 = -x11
    x34 = x22*x33
    x35 = x18*x33
    x36 = x1*x28
    x37 = x35 + x36
    x38 = -x13
    x39 = x22*x38
    x40 = x18*x38
    x41 = x1*x30
    x42 = x40 + x41
    x43 = 2*m0 - 2*o0
    x44 = x10*x2
    x45 = x0*x22
    x46 = -x19 + x29 + x31
    x47 = x12*x4
    x48 = x22*x24
    x49 = x11*x13
    x50 = x22*x49
    x51 = x11*x18
    x52 = -x36 + x51
    x53 = x14*x6
    x54 = x13*x18
    x55 = -x41 + x54
    x56 = 1/mpmath.sqrt(x15)
    x57 = x56*x9
    x58 = -x57
    x59 = x8**(mpmath.mpf(-3)/mpmath.mpf(2))
    x60 = x56*x59
    x61 = x3*x60
    x62 = x1*x17
    x63 = x0*x62
    x64 = x16*x59
    x65 = x3*x64
    x66 = x0*x65
    x67 = x1*x64
    x68 = x2*x25
    x69 = x26*x67
    x70 = x1*x66 + x2*x69 + x58 + x61 - x63 + x67*x68
    x71 = x2*x60
    x72 = x4*x71
    x73 = x11*x62
    x74 = x5*x64
    x75 = x11*x74
    x76 = x24*x67
    x77 = x1*x75 + x4*x69 + x4*x76 + x72 - x73
    x78 = x6*x71
    x79 = x13*x62
    x80 = x64*x7
    x81 = x13*x80
    x82 = x25*x67
    x83 = x1*x81 + x6*x76 + x6*x82 + x78 - x79
    x84 = -x2
    x85 = x71*x84
    x86 = x57 + x63 + x69*x84 + x76*x84 + x82*x84 + x85
    x87 = -x4
    x88 = x71*x87
    x89 = x69*x87 + x73 + x76*x87 + x82*x87 + x88
    x90 = -x6
    x91 = x71*x90
    x92 = x69*x90 + x76*x90 + x79 + x82*x90 + x91
    x93 = 3*m1 - 3*o1
    x94 = -x21*x93
    x95 = x1*x94
    x96 = x28*x33
    x97 = x33*x94
    x98 = x38*x94
    x99 = x28*x38
    x100 = x30*x33
    x101 = x100 + x99
    x102 = x0*x94
    x103 = x0*x28
    x104 = x103 - x35
    x105 = 2*m1 - 2*o1
    x106 = x24*x94
    x107 = x49*x94
    x108 = x27 + x31 - x96
    x109 = x13*x28
    x110 = -x100 + x109
    x111 = x17*x33
    x112 = x0*x111
    x113 = x33*x64
    x114 = x113*x26
    x115 = -x112 + x113*x68 + x114*x2 + x33*x66 + x72
    x116 = x5*x60
    x117 = x11*x111
    x118 = x113*x24
    x119 = x114*x4 + x116 - x117 + x118*x4 + x33*x75 + x58
    x120 = x4*x60
    x121 = x120*x6
    x122 = x111*x13
    x123 = x113*x25
    x124 = x118*x6 + x121 - x122 + x123*x6 + x33*x81
    x125 = x120*x84
    x126 = x112 + x114*x84 + x118*x84 + x123*x84 + x125
    x127 = x120*x87
    x128 = x114*x87 + x117 + x118*x87 + x123*x87 + x127 + x57
    x129 = x120*x90
    x130 = x114*x90 + x118*x90 + x122 + x123*x90 + x129
    x131 = 3*m2 - 3*o2
    x132 = -x131*x21
    x133 = x1*x132
    x134 = x132*x33
    x135 = x30*x38
    x136 = x132*x38
    x137 = x0*x132
    x138 = x0*x30
    x139 = x138 - x40
    x140 = x132*x24
    x141 = x132*x49
    x142 = x11*x30
    x143 = x142 - x99
    x144 = 2*m2 - 2*o2
    x145 = -x135 + x27 + x29
    x146 = x17*x38
    x147 = x0*x146
    x148 = x38*x64
    x149 = x148*x26
    x150 = -x147 + x148*x68 + x149*x2 + x38*x66 + x78
    x151 = x11*x146
    x152 = x148*x24
    x153 = x121 + x149*x4 - x151 + x152*x4 + x38*x75
    x154 = x60*x7
    x155 = x13*x146
    x156 = x148*x25
    x157 = x152*x6 + x154 - x155 + x156*x6 + x38*x81 + x58
    x158 = x6*x60
    x159 = x158*x84
    x160 = x147 + x149*x84 + x152*x84 + x156*x84 + x159
    x161 = x158*x87
    x162 = x149*x87 + x151 + x152*x87 + x156*x87 + x161
    x163 = x158*x90
    x164 = x149*x90 + x152*x90 + x155 + x156*x90 + x163 + x57
    x165 = x20*x21
    x166 = x1*x165
    x167 = x165*x33
    x168 = x165*x38
    x169 = x0*x165
    x170 = x165*x24
    x171 = x165*x49
    x172 = -x103 - x51
    x173 = -x138 - x54
    x174 = x10*x17
    x175 = x24*x64
    x176 = x175*x26
    x177 = x175*x25 + x57
    x178 = x10*x65 - x174 + x176 + x177 - x61
    x179 = x44*x64
    x180 = x0*x64
    x181 = x26*x4
    x182 = x0*x17
    x183 = x11*x182
    x184 = -x183 - x72
    x185 = x0*x75 + x179*x4 + x180*x181 + x184
    x186 = x180*x25
    x187 = x13*x182
    x188 = -x187 - x78
    x189 = x0*x81 + x179*x6 + x186*x6 + x188
    x190 = x180*x26
    x191 = x174 + x179*x84 + x186*x84 + x190*x84 + x58 - x85
    x192 = x179*x87 + x183 + x186*x87 + x190*x87 - x88
    x193 = x179*x90 + x186*x90 + x187 + x190*x90 - x91
    x194 = x21*x93
    x195 = x1*x194
    x196 = x194*x33
    x197 = x194*x38
    x198 = x0*x194
    x199 = x194*x24
    x200 = x194*x49
    x201 = -x109 - x142
    x202 = x47*x64
    x203 = x49*x6
    x204 = x203*x64
    x205 = x11*x66 + x184 + x2*x202 + x2*x204
    x206 = x12*x17
    x207 = x204*x4
    x208 = -x116 + x12*x74 + x177 - x206 + x207
    x209 = x11*x175
    x210 = x17*x49
    x211 = -x121 - x210
    x212 = x202*x6 + x209*x6 + x211 + x49*x80
    x213 = -x125 + x183 + x202*x84 + x204*x84 + x209*x84
    x214 = -x127 + x202*x87 + x204*x87 + x206 + x209*x87 + x58
    x215 = -x129 + x202*x90 + x204*x90 + x209*x90 + x210
    x216 = x131*x21
    x217 = x1*x216
    x218 = x216*x33
    x219 = x216*x38
    x220 = x0*x216
    x221 = x216*x24
    x222 = x4*x49
    x223 = x53*x64
    x224 = x222*x64
    x225 = x13*x66 + x188 + x2*x223 + x2*x224
    x226 = x13*x175
    x227 = x211 + x223*x4 + x226*x4 + x49*x74
    x228 = x14*x17
    x229 = x14*x80 - x154 + x176 + x207 - x228 + x57
    x230 = -x159 + x187 + x223*x84 + x224*x84 + x226*x84
    x231 = -x161 + x210 + x223*x87 + x224*x87 + x226*x87
    x232 = -x163 + x223*x90 + x224*x90 + x226*x90 + x228 + x58
    x233 = 2*n0 - 2*p0
    x234 = x0*x60
    x235 = 3*n0 - 3*p0
    x236 = x56/x8**(mpmath.mpf(5)/mpmath.mpf(2))
    x237 = x235*x236
    x238 = x0*x3
    x239 = x237*x26
    x240 = x0*x71
    x241 = x11*x120
    x242 = x13*x158
    x243 = -x240 - x241 - x242
    x244 = x11*x5
    x245 = x237*x24
    x246 = x0*x120
    x247 = x11*x71
    x248 = -x246 - x247
    x249 = x13*x7
    x250 = x237*x25
    x251 = x0*x158
    x252 = x13*x71
    x253 = -x251 - x252
    x254 = x234*x84
    x255 = x241 + x242 - x254
    x256 = x234*x87
    x257 = x247 - x256
    x258 = x234*x90
    x259 = x252 - x258
    x260 = 3*n1 - 3*p1
    x261 = x236*x260
    x262 = x26*x261
    x263 = 2*n1 - 2*p1
    x264 = x11*x60
    x265 = x24*x261
    x266 = x25*x261
    x267 = x11*x158
    x268 = x120*x13
    x269 = -x267 - x268
    x270 = x264*x84
    x271 = x246 - x270
    x272 = x264*x87
    x273 = x240 + x242 - x272
    x274 = x264*x90
    x275 = x268 - x274
    x276 = 3*n2 - 3*p2
    x277 = x236*x276
    x278 = x26*x277
    x279 = x24*x277
    x280 = 2*n2 - 2*p2
    x281 = x13*x60
    x282 = x25*x277
    x283 = x281*x84
    x284 = x251 - x283
    x285 = x281*x87
    x286 = x267 - x285
    x287 = x281*x90
    x288 = x240 + x241 - x287
    x289 = -x235*x236
    x290 = x26*x289
    x291 = x24*x289
    x292 = x25*x289
    x293 = x256 + x270
    x294 = x258 + x283
    x295 = -x236*x260
    x296 = x26*x295
    x297 = x24*x295
    x298 = x25*x295
    x299 = x274 + x285
    x300 = -x236*x276
    x301 = x26*x300
    x302 = x24*x300
    x303 = x25*x300

    return np.array([2*x19 + x23*x24 + x23*x25 + x23*x26 + x32, x24*x34 + x25*x34 + x26*x34 + x37, x24*x39 + x25*x39 + x26*x39 + x42, x18*x43 + x22*x44 + x25*x45 + x26*x45 + x46, x11*x48 + x22*x47 + x50*x6 + x52, x13*x48 + x22*x53 + x4*x50 + x55, x70, x77, x83, x86, x89, x92, x24*x95 + x25*x95 + x26*x95 + x37, x24*x97 + x25*x97 + x26*x97 + x32 + 2*x96, x101 + x24*x98 + x25*x98 + x26*x98, x102*x25 + x102*x26 + x104 + x44*x94, x105*x28 + x106*x11 + x107*x6 + x108 + x47*x94, x106*x13 + x107*x4 + x110 + x53*x94, x115, x119, x124, x126, x128, x130, x133*x24 + x133*x25 + x133*x26 + x42, x101 + x134*x24 + x134*x25 + x134*x26, 2*x135 + x136*x24 + x136*x25 + x136*x26 + x32, x132*x44 + x137*x25 + x137*x26 + x139, x11*x140 + x132*x47 + x141*x6 + x143, x13*x140 + x132*x53 + x141*x4 + x144*x30 + x145, x150, x153, x157, x160, x162, x164, x166*x24 + x166*x25 + x166*x26 + 2*x27 + x46, x104 + x167*x24 + x167*x25 + x167*x26, x139 + x168*x24 + x168*x25 + x168*x26, x165*x44 + x169*x25 + x169*x26 - x18*x43 + x32, x11*x170 + x165*x47 + x171*x6 + x172, x13*x170 + x165*x53 + x171*x4 + x173, x178, x185, x189, x191, x192, x193, x195*x24 + x195*x25 + x195*x26 + x52, x108 + x196*x24 + x196*x25 + x196*x26 + 2*x29, x143 + x197*x24 + x197*x25 + x197*x26, x172 + x194*x44 + x198*x25 + x198*x26, -x105*x28 + x11*x199 + x194*x47 + x200*x6 + x32, x13*x199 + x194*x53 + x200*x4 + x201, x205, x208, x212, x213, x214, x215, x217*x24 + x217*x25 + x217*x26 + x55, x110 + x218*x24 + x218*x25 + x218*x26, x145 + x219*x24 + x219*x25 + x219*x26 + 2*x31, x173 + x216*x44 + x220*x25 + x220*x26, x11*x221 + x201 + x203*x216 + x216*x47, x13*x221 - x144*x30 + x216*x222 + x216*x53 + x32, x225, x227, x229, x230, x231, x232, x70, x115, x150, x178, x205, x225, x2*x239 - x233*x234 + x237*x238 + x237*x68 + x243, x181*x237 + x237*x244 + x245*x4 + x248, x237*x249 + x245*x6 + x250*x6 + x253, x239*x84 + 2*x240 + x245*x84 + x250*x84 + x255, x239*x87 + x245*x87 + x250*x87 + x257, x239*x90 + x245*x90 + x250*x90 + x259, x77, x119, x153, x185, x208, x227, x2*x262 + x238*x261 + x248 + x261*x68, x181*x261 + x243 + x244*x261 - x263*x264 + x265*x4, x249*x261 + x265*x6 + x266*x6 + x269, x262*x84 + x265*x84 + x266*x84 + x271, 2*x241 + x262*x87 + x265*x87 + x266*x87 + x273, x262*x90 + x265*x90 + x266*x90 + x275, x83, x124, x157, x189, x212, x229, x2*x278 + x238*x277 + x253 + x277*x68, x181*x277 + x244*x277 + x269 + x279*x4, x243 + x249*x277 + x279*x6 - x280*x281 + x282*x6, x278*x84 + x279*x84 + x282*x84 + x284, x278*x87 + x279*x87 + x282*x87 + x286, 2*x242 + x278*x90 + x279*x90 + x282*x90 + x288, x86, x126, x160, x191, x213, x230, x2*x290 + x233*x234 + x238*x289 + x255 + x289*x68, x181*x289 + x244*x289 + x271 + x291*x4, x249*x289 + x284 + x291*x6 + x292*x6, x243 + 2*x254 + x290*x84 + x291*x84 + x292*x84, x290*x87 + x291*x87 + x292*x87 + x293, x290*x90 + x291*x90 + x292*x90 + x294, x89, x128, x162, x192, x214, x231, x2*x296 + x238*x295 + x257 + x295*x68, x181*x295 + x244*x295 + x263*x264 + x273 + x297*x4, x249*x295 + x286 + x297*x6 + x298*x6, x293 + x296*x84 + x297*x84 + x298*x84, x243 + 2*x272 + x296*x87 + x297*x87 + x298*x87, x296*x90 + x297*x90 + x298*x90 + x299, x92, x130, x164, x193, x215, x232, x2*x301 + x238*x300 + x259 + x300*x68, x181*x300 + x244*x300 + x275 + x302*x4, x249*x300 + x280*x281 + x288 + x302*x6 + x303*x6, x294 + x301*x84 + x302*x84 + x303*x84, x299 + x301*x87 + x302*x87 + x303*x87, x243 + 2*x287 + x301*x90 + x302*x90 + x303*x90], dtype=np.float64)


def q_rd2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """RobustTorsion2"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = -p0
    x1 = -o0 - x0
    x2 = -p1
    x3 = -o1 - x2
    x4 = -p2
    x5 = -o2 - x4
    x6 = 1/mpmath.sqrt(x1**2 + x3**2 + x5**2)
    x7 = m1 - o1
    x8 = n2 + x4
    x9 = m0 - o0
    x10 = m2 - o2
    x11 = 1/mpmath.sqrt(x10**2 + x7**2 + x9**2)
    x12 = n0 + x0
    x13 = n1 + x2
    x14 = 1/mpmath.sqrt(x12**2 + x13**2 + x8**2)
    x15 = x11*x14
    x16 = x15*x8

    return x1*x6*(-x10*x13*x15 + x16*x7) + x3*x6*(x10*x11*x12*x14 - x16*x9) + x5*x6*(-x12*x15*x7 + x13*x15*x9)


def dq_rd2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """RobustTorsion2, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - o0
    x1 = -x0
    x2 = -p0
    x3 = n0 + x2
    x4 = x3**2
    x5 = -p1
    x6 = n1 + x5
    x7 = x6**2
    x8 = -p2
    x9 = n2 + x8
    x10 = x9**2
    x11 = x10 + x4 + x7
    x12 = 1/mpmath.sqrt(x11)
    x13 = x0**2
    x14 = m1 - o1
    x15 = x14**2
    x16 = m2 - o2
    x17 = x16**2
    x18 = x13 + x15 + x17
    x19 = x18**(mpmath.mpf(-3)/mpmath.mpf(2))
    x20 = x12*x19
    x21 = x1*x20
    x22 = x14*x9
    x23 = o0 + x2
    x24 = -x23
    x25 = x24**2
    x26 = o1 + x5
    x27 = -x26
    x28 = x27**2
    x29 = o2 + x8
    x30 = -x29
    x31 = x30**2
    x32 = x25 + x28 + x31
    x33 = 1/mpmath.sqrt(x32)
    x34 = x24*x33
    x35 = 1/mpmath.sqrt(x18)
    x36 = x12*x35
    x37 = x36*x6
    x38 = x0*x21
    x39 = x14*x3
    x40 = x30*x33
    x41 = x36*x9
    x42 = x27*x33
    x43 = -x14
    x44 = x20*x43
    x45 = x3*x36
    x46 = -x16
    x47 = x20*x46
    x48 = x0*x47
    x49 = x16*x47
    x50 = x14*x41 - x16*x37
    x51 = x33*x50
    x52 = x32**(mpmath.mpf(-3)/mpmath.mpf(2))
    x53 = x50*x52
    x54 = -x0*x41 + x12*x16*x3*x35
    x55 = x52*x54
    x56 = x24*x27
    x57 = x0*x37 - x14*x45
    x58 = x52*x57
    x59 = x30*x58
    x60 = x0*x20
    x61 = x22*x60
    x62 = x16*x60
    x63 = x6*x62
    x64 = x33*x54
    x65 = x16*x20
    x66 = -x39*x65
    x67 = x14*x6
    x68 = x33*x57
    x69 = x24*x53
    x70 = x27*x55
    x71 = x11**(mpmath.mpf(-3)/mpmath.mpf(2))
    x72 = x35*x71
    x73 = x3*x72
    x74 = x22*x73
    x75 = x6*x73
    x76 = -x16*x75
    x77 = x14*x36
    x78 = x16*x36
    x79 = x0*x9
    x80 = x6*x72
    x81 = x79*x80
    x82 = x0*x36
    x83 = x16*x9
    x84 = -x3
    x85 = x72*x84
    x86 = x16*x84
    x87 = -x6
    x88 = x72*x87
    x89 = x0*x80
    x90 = -x9
    x91 = x72*x90

    return np.array([x34*(-x16*x21*x6 + x21*x22) + x40*(-x21*x39 + x37 + x38*x6) + x42*(x1*x12*x16*x19*x3 - x38*x9 - x41), x34*(-x16*x44*x6 + x22*x44 + x41) + x40*(x0*x12*x19*x43*x6 - x39*x44 - x45) + x42*(-x0*x44*x9 + x12*x16*x19*x3*x43), x34*(x12*x14*x19*x46*x9 - x37 - x49*x6) + x40*(-x39*x47 + x48*x6) + x42*(x3*x49 + x45 - x48*x9), x24*x59 + x25*x53 + x34*(x61 - x63) + x40*(x12*x13*x19*x6 - x37 - x39*x60) + x42*(-x13*x20*x9 + x3*x62 + x41) - x51 + x55*x56, x27*x59 + x28*x55 + x34*(x12*x15*x19*x9 - x41 - x65*x67) + x40*(-x15*x20*x3 + x45 + x60*x67) + x42*(-x61 - x66) + x53*x56 - x64, x30*x69 + x30*x70 + x31*x58 + x34*(-x17*x20*x6 + x22*x65 + x37) + x40*(x63 + x66) + x42*(x12*x17*x19*x3 - x45 - x62*x9) - x68, x23*x59 + x23*x69 + x23*x70 + x34*(x74 + x76) + x40*(x0*x75 - x14*x4*x72 + x77) + x42*(x16*x35*x4*x71 - x73*x79 - x78) + x51, x26*x59 + x26*x69 + x26*x70 + x34*(-x16*x7*x72 + x22*x80 + x78) + x40*(x0*x35*x7*x71 - x39*x80 - x82) + x42*(-x76 - x81) + x64, x29*x59 + x29*x69 + x29*x70 + x34*(x10*x14*x35*x71 - x77 - x80*x83) + x40*(-x74 + x81) + x42*(-x0*x10*x72 + x73*x83 + x82) + x68, x34*(x22*x85 - x80*x86) + x40*(x0*x35*x6*x71*x84 - x39*x85 - x77) + x42*(x73*x86 + x78 - x79*x85), x34*(x14*x35*x71*x87*x9 - x16*x80*x87 - x78) + x40*(-x39*x88 + x82 + x87*x89) + x42*(x16*x3*x35*x71*x87 - x79*x88), x34*(-x16*x80*x90 + x22*x91 + x77) + x40*(-x39*x91 + x89*x90) + x42*(x16*x3*x35*x71*x90 - x79*x91 - x82)], dtype=np.float64)


def d2q_rd2(m0, m1, m2, o0, o1, o2, p0, p1, p2, n0, n1, n2):
    """RobustTorsion2, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)

    x0 = m0 - o0
    x1 = -x0
    x2 = 3*o0
    x3 = 3*m0 - x2
    x4 = -x3
    x5 = -p0
    x6 = n0 + x5
    x7 = x6**2
    x8 = -p1
    x9 = n1 + x8
    x10 = x9**2
    x11 = -p2
    x12 = n2 + x11
    x13 = x12**2
    x14 = x10 + x13 + x7
    x15 = 1/mpmath.sqrt(x14)
    x16 = x0**2
    x17 = m1 - o1
    x18 = x17**2
    x19 = m2 - o2
    x20 = x19**2
    x21 = x16 + x18 + x20
    x22 = x21**(mpmath.mpf(-5)/mpmath.mpf(2))
    x23 = x15*x22
    x24 = x23*x4
    x25 = x1*x24
    x26 = x12*x17
    x27 = x21**(mpmath.mpf(-3)/mpmath.mpf(2))
    x28 = x15*x27
    x29 = x19*x28
    x30 = x29*x9
    x31 = x12*x28
    x32 = x17*x31
    x33 = -x32
    x34 = x30 + x33
    x35 = o0 + x5
    x36 = -x35
    x37 = x36**2
    x38 = o1 + x8
    x39 = -x38
    x40 = x39**2
    x41 = o2 + x11
    x42 = -x41
    x43 = x42**2
    x44 = x37 + x40 + x43
    x45 = 1/mpmath.sqrt(x44)
    x46 = x36*x45
    x47 = x1*x31
    x48 = x0*x25
    x49 = x29*x6
    x50 = x0*x31
    x51 = -x50
    x52 = x49 + x51
    x53 = x39*x45
    x54 = x28*x9
    x55 = x1*x54
    x56 = x17*x6
    x57 = x28*x6
    x58 = x17*x57
    x59 = x0*x54
    x60 = -x59
    x61 = x58 + x60
    x62 = x42*x45
    x63 = -x17
    x64 = x24*x63
    x65 = x31*x63
    x66 = x0*x64
    x67 = x54*x63
    x68 = x1*x57
    x69 = -x68
    x70 = x67 + x69
    x71 = -x19
    x72 = x54*x71
    x73 = x24*x71
    x74 = x0*x73
    x75 = x31*x71
    x76 = x69 + x75
    x77 = -x30
    x78 = x19*x24
    x79 = x0*x9
    x80 = x78*x79
    x81 = x0*x17
    x82 = x24*x81
    x83 = x12*x82 + x32
    x84 = 2*o0
    x85 = 2*m0 - x84
    x86 = -x85
    x87 = x0*x78
    x88 = x47 + x49
    x89 = x55 + x58
    x90 = -x1*x30 + x1*x32
    x91 = x45*x90
    x92 = x44**(mpmath.mpf(-3)/mpmath.mpf(2))
    x93 = x37*x92
    x94 = 1/mpmath.sqrt(x21)
    x95 = x15*x94
    x96 = x12*x95
    x97 = x1*x15*x19*x27*x6 - x1*x50 - x96
    x98 = x36*x92
    x99 = x39*x98
    x100 = x9*x95
    x101 = -x1*x58 + x1*x59 + x100
    x102 = x101*x42
    x103 = x102*x98 + x90*x93 - x91 + x97*x99
    x104 = x17*x9
    x105 = -x56*x78
    x106 = x17*x54
    x107 = x106 + x68
    x108 = x45*x97
    x109 = x40*x92
    x110 = x39*x92
    x111 = x102*x110 - x108 + x109*x97 + x90*x99
    x112 = x12*x29
    x113 = x112 + x68
    x114 = x101*x45
    x115 = x43*x92
    x116 = x90*x98
    x117 = x110*x97
    x118 = x101*x115 - x114 + x116*x42 + x117*x42
    x119 = x14**(mpmath.mpf(-3)/mpmath.mpf(2))
    x120 = x119*x27
    x121 = x1*x120
    x122 = x121*x17
    x123 = x12*x6
    x124 = x122*x123
    x125 = x121*x6
    x126 = x19*x9
    x127 = -x125*x126
    x128 = x102*x92
    x129 = x1*x28
    x130 = x129*x17
    x131 = x119*x94
    x132 = x131*x6
    x133 = x132*x9
    x134 = x1*x29
    x135 = x12*x132
    x136 = x121*x123
    x137 = x116*x35 + x117*x35 + x128*x35 + x46*(x124 + x127) + x53*(-x0*x136 + x1*x119*x19*x27*x7 - x134 - x135) + x62*(-x122*x7 + x125*x79 + x130 + x133) + x91
    x138 = x122*x9
    x139 = x12*x131
    x140 = x139*x9
    x141 = x12*x121
    x142 = x140 + x141*x79
    x143 = x10*x131
    x144 = -x143
    x145 = x0*x129 + x95
    x146 = x108 + x116*x38 + x117*x38 + x128*x38 + x46*(-x10*x121*x19 + x12*x138 + x134) + x53*(-x127 - x142) + x62*(x0*x1*x10*x119*x27 - x138*x6 - x144 - x145)
    x147 = x13*x131
    x148 = -x147
    x149 = x0*x13
    x150 = x114 + x116*x41 + x117*x41 + x128*x41 + x46*(x1*x119*x13*x17*x27 - x126*x141 - x130) + x53*(-x121*x149 + x136*x19 + x145 + x148) + x62*(-x124 + x142)
    x151 = -x6
    x152 = x122*x151
    x153 = x121*x151
    x154 = x139*x151
    x155 = x0*x141
    x156 = x131*x9
    x157 = x151*x156
    x158 = x46*(x12*x152 - x126*x153) + x53*(x1*x119*x151*x19*x27*x6 + x134 - x151*x155 - x154) + x62*(-x130 - x152*x6 + x153*x79 + x157)
    x159 = -x9
    x160 = x121*x159
    x161 = x139*x159
    x162 = x156*x159
    x163 = x46*(x1*x119*x12*x159*x17*x27 - x126*x160 - x134) + x53*(x1*x119*x159*x19*x27*x6 - x155*x159 - x161) + x62*(-x122*x159*x6 + x145 + x160*x79 + x162)
    x164 = -x12
    x165 = x122*x164
    x166 = x121*x164
    x167 = x156*x164
    x168 = x139*x164
    x169 = x46*(x12*x165 - x126*x166 + x130) + x53*(x1*x119*x164*x19*x27*x6 - x145 - x155*x164 - x168) + x62*(-x165*x6 + x166*x79 + x167)
    x170 = 3*o1
    x171 = 3*m1 - x170
    x172 = -x171
    x173 = x172*x23
    x174 = x1*x173
    x175 = x0*x12
    x176 = x173*x63
    x177 = x57*x63
    x178 = -x58
    x179 = x178 + x59
    x180 = x19*x6
    x181 = x173*x71
    x182 = x57*x71
    x183 = -x67 + x75
    x184 = x173*x19
    x185 = -x184*x79
    x186 = x173*x81
    x187 = x12*x186 + x50
    x188 = x0*x180
    x189 = x0*x57
    x190 = x189 + x67
    x191 = -x30*x63 + x32*x63 + x96
    x192 = x191*x45
    x193 = x15*x19*x27*x6*x63 - x50*x63
    x194 = x6*x95
    x195 = x0*x15*x27*x63*x9 - x194 - x58*x63
    x196 = x195*x42
    x197 = x191*x93 - x192 + x193*x99 + x196*x98
    x198 = 2*o1
    x199 = 2*m1 - x198
    x200 = x30 + x65
    x201 = -x49
    x202 = x184*x56
    x203 = -x199
    x204 = x177 + x59
    x205 = x193*x45
    x206 = x109*x193 + x110*x196 + x191*x99 - x205
    x207 = x112 + x67
    x208 = x195*x45
    x209 = x191*x98
    x210 = x110*x193
    x211 = x115*x195 - x208 + x209*x42 + x210*x42
    x212 = x196*x92
    x213 = x29*x63
    x214 = x120*x63
    x215 = x123*x214
    x216 = x214*x6
    x217 = -x126*x216
    x218 = x17*x214
    x219 = x123*x218 + x135
    x220 = x131*x7
    x221 = -x220
    x222 = x28*x63
    x223 = x17*x222 + x95
    x224 = x192 + x209*x35 + x210*x35 + x212*x35 + x46*(x217 + x219) + x53*(-x0*x215 + x119*x19*x27*x63*x7 - x213) + x62*(x216*x79 - x218*x7 + x221 + x223)
    x225 = x12*x214
    x226 = x225*x79
    x227 = x218*x9
    x228 = x0*x222
    x229 = x205 + x209*x38 + x210*x38 + x212*x38 + x46*(-x10*x19*x214 + x12*x227 + x140 + x213) + x53*(-x217 - x226) + x62*(x0*x10*x119*x27*x63 - x133 - x227*x6 - x228)
    x230 = x208 + x209*x41 + x210*x41 + x212*x41 + x46*(x119*x13*x17*x27*x63 - x126*x225 - x148 - x223) + x53*(-x149*x214 + x19*x215 + x228) + x62*(-x219 + x226)
    x231 = x151*x218
    x232 = x151*x214
    x233 = x132*x151
    x234 = x46*(x12*x231 - x126*x232 + x154) + x53*(-x175*x232 + x180*x232 + x213) + x62*(x0*x119*x151*x27*x63*x9 - x223 - x231*x6 - x233)
    x235 = x159*x214
    x236 = x159*x218
    x237 = x132*x159
    x238 = x46*(x12*x236 - x126*x235 + x161 - x213) + x53*(x119*x159*x19*x27*x6*x63 - x175*x235) + x62*(x228 + x235*x79 - x236*x6 - x237)
    x239 = x164*x214
    x240 = x132*x164
    x241 = x164*x218
    x242 = x46*(x12*x241 - x126*x239 + x168 + x223) + x53*(x119*x164*x19*x27*x6*x63 - x175*x239 - x228) + x62*(x0*x119*x164*x27*x63*x9 - x240 - x241*x6)
    x243 = 3*o2
    x244 = 3*m2 - x243
    x245 = -x244
    x246 = x23*x245
    x247 = x1*x246
    x248 = x246*x63
    x249 = x246*x71
    x250 = x32 + x77
    x251 = x201 + x50
    x252 = x246*x81
    x253 = -x12*x252
    x254 = x19*x246
    x255 = x254*x79 + x59
    x256 = x189 + x75
    x257 = -x100 + x12*x15*x17*x27*x71 - x30*x71
    x258 = x257*x45
    x259 = x194 + x49*x71 - x50*x71
    x260 = -x58*x71 + x59*x71
    x261 = x260*x42
    x262 = x257*x93 - x258 + x259*x99 + x261*x98
    x263 = x106 + x75
    x264 = x254*x56
    x265 = x259*x45
    x266 = x109*x259 + x110*x261 + x257*x99 - x265
    x267 = 2*o2
    x268 = 2*m2 - x267
    x269 = -x268
    x270 = x32 + x72
    x271 = x182 + x50
    x272 = x260*x45
    x273 = x257*x98
    x274 = x110*x259
    x275 = x115*x260 - x272 + x273*x42 + x274*x42
    x276 = x261*x92
    x277 = x28*x71
    x278 = x17*x277
    x279 = x120*x71
    x280 = x17*x279
    x281 = x279*x6
    x282 = -x123*x280
    x283 = x126*x281 + x133
    x284 = x123*x279
    x285 = x29*x71 + x95
    x286 = x258 + x273*x35 + x274*x35 + x276*x35 + x46*(-x282 - x283) + x53*(-x0*x284 + x119*x19*x27*x7*x71 - x221 - x285) + x62*(x278 - x280*x7 + x281*x79)
    x287 = x0*x277
    x288 = x280*x9
    x289 = x12*x279
    x290 = x289*x79
    x291 = x265 + x273*x38 + x274*x38 + x276*x38 + x46*(-x10*x19*x279 + x12*x288 + x144 + x285) + x53*(x283 - x290) + x62*(x0*x10*x119*x27*x71 - x287 - x288*x6)
    x292 = x272 + x273*x41 + x274*x41 + x276*x41 + x46*(x119*x13*x17*x27*x71 - x126*x289 - x140 - x278) + x53*(x135 - x149*x279 + x19*x284 + x287) + x62*(x282 + x290)
    x293 = x151*x279
    x294 = x46*(x119*x12*x151*x17*x27*x71 - x126*x293 - x157) + x53*(-x175*x293 + x180*x293 + x233 + x285) + x62*(x0*x119*x151*x27*x71*x9 - x151*x280*x6 - x278)
    x295 = x159*x279
    x296 = x46*(x119*x12*x159*x17*x27*x71 - x126*x295 - x162 - x285) + x53*(-x175*x295 + x180*x295 + x237) + x62*(-x159*x280*x6 + x287 + x295*x79)
    x297 = x164*x279
    x298 = x164*x280
    x299 = x46*(x12*x298 - x126*x297 - x167 + x278) + x53*(x119*x164*x19*x27*x6*x71 - x175*x297 + x240 - x287) + x62*(x297*x79 - x298*x6)
    x300 = x23*x3
    x301 = x1*x300
    x302 = x300*x63
    x303 = x300*x71
    x304 = x0*x32
    x305 = x0*x30
    x306 = x304 - x305
    x307 = x306*x45
    x308 = -2*p0
    x309 = x308 + x84
    x310 = -x100*x19 + x17*x96
    x311 = x310*x92
    x312 = x300*x81
    x313 = x12*x312
    x314 = x19*x300
    x315 = x30 - x314*x79
    x316 = x16*x300
    x317 = x44**(mpmath.mpf(-5)/mpmath.mpf(2))
    x318 = -3*p0
    x319 = x2 + x318
    x320 = -x317*x319
    x321 = x310*x37
    x322 = x16*x28
    x323 = x0*x49 - x12*x322 + x96
    x324 = 2*x99
    x325 = -x0*x58 - x100 + x15*x16*x27*x9
    x326 = x42*x98
    x327 = 2*x326
    x328 = x320*x36
    x329 = -x0*x96 + x15*x19*x6*x94
    x330 = x329*x39
    x331 = x0*x100 - x17*x194
    x332 = x331*x42
    x333 = x311*x36
    x334 = x329*x92
    x335 = x334*x39
    x336 = x331*x92
    x337 = x336*x42
    x338 = -x333 - x335 - x337
    x339 = x314*x56
    x340 = -x106 + x189
    x341 = x329*x40
    x342 = x310*x328
    x343 = x320*x332
    x344 = x323*x45
    x345 = x12*x15*x18*x27 - x17*x30 - x96
    x346 = x345*x45
    x347 = x334*x36
    x348 = x311*x39
    x349 = -x17*x49
    x350 = -x304 - x349
    x351 = x18*x28
    x352 = x17*x59 + x194 - x351*x6
    x353 = x110*x42
    x354 = x109*x323 + x306*x99 + x325*x353 + x326*x352 - x344 + x345*x93 - x346 - x347 - x348 + x350*x99
    x355 = -x112
    x356 = x189 + x355
    x357 = x331*x43
    x358 = x320*x330
    x359 = x20*x28
    x360 = x100 + x112*x17 - x359*x9
    x361 = x360*x45
    x362 = x325*x45
    x363 = x336*x36
    x364 = x311*x42
    x365 = -x0*x112 + x15*x20*x27*x6 - x194
    x366 = x305 + x349
    x367 = x115*x325 + x306*x326 + x323*x353 + x326*x366 + x360*x93 - x361 - x362 - x363 - x364 + x365*x99
    x368 = x135*x17
    x369 = -x133*x19
    x370 = x368 + x369
    x371 = x370*x45
    x372 = x120*x81
    x373 = x123*x372
    x374 = x0*x120
    x375 = x126*x374
    x376 = x375*x6
    x377 = x0*x29
    x378 = x120*x16
    x379 = x378*x6
    x380 = x28*x81
    x381 = x311*x35
    x382 = x306*x98
    x383 = x110*x323
    x384 = x42*x92
    x385 = x325*x384
    x386 = x19*x95
    x387 = -x0*x135 + x119*x19*x7*x94 - x386
    x388 = x17*x95
    x389 = x0*x133 - x17*x220 + x388
    x390 = x307 + x326*x389 + x335 + x337 + x35*x382 + x35*x383 + x35*x385 + x370*x93 - x371 - x381 + x387*x99 + x46*(x373 - x376) + x53*(x0*x119*x19*x27*x7 - x12*x379 + x135 - x377) + x62*(-x133 - x372*x7 + x379*x9 + x380)
    x391 = x140*x17 - x143*x19 + x386
    x392 = x391*x45
    x393 = x372*x9
    x394 = x12*x393
    x395 = x10*x19
    x396 = -x374*x395 + x377
    x397 = x12*x378
    x398 = x140 - x397*x9
    x399 = x393*x6
    x400 = -x95
    x401 = x322 + x400
    x402 = x311*x38
    x403 = x0*x140
    x404 = -x369 - x403
    x405 = x0*x95
    x406 = x0*x10*x119*x94 - x133*x17 - x405
    x407 = x326*x406 + x344 + x347 + x38*x382 + x38*x383 + x38*x385 + x391*x93 - x392 - x402 + x404*x99 + x46*(x394 + x396) + x53*(x376 + x398) + x62*(x10*x119*x16*x27 - x143 - x399 - x401)
    x408 = x119*x13*x17*x94 - x140*x19 - x388
    x409 = x408*x45
    x410 = x12*x375
    x411 = -x13*x372 + x380
    x412 = x19*x374
    x413 = x123*x412
    x414 = x311*x41
    x415 = -x0*x147 + x135*x19 + x405
    x416 = -x368 + x403
    x417 = x326*x416 + x362 + x363 + x382*x41 + x383*x41 + x385*x41 + x408*x93 - x409 - x414 + x415*x99 + x46*(-x410 - x411) + x53*(-x13*x378 + x147 + x401 + x413) + x62*(-x373 - x398)
    x418 = x154*x17 - x157*x19
    x419 = x418*x45
    x420 = x151*x372
    x421 = x12*x420
    x422 = -x151*x375
    x423 = -x0*x154 + x19*x233 + x386
    x424 = x0*x119*x151*x9*x94 - x17*x233 - x388
    x425 = x180*x374
    x426 = x326*x424 + x418*x93 - x419 + x423*x99 + x46*(x421 + x422) + x53*(-x151*x397 + x151*x425 + x154 + x377) + x62*(x119*x151*x16*x27*x9 - x157 - x380 - x420*x6)
    x427 = -x0*x161 + x119*x159*x19*x6*x94
    x428 = x119*x12*x159*x17*x94 - x162*x19 - x386
    x429 = x428*x45
    x430 = x0*x162 - x17*x237 + x405
    x431 = x159*x372
    x432 = x12*x431
    x433 = x159*x375 + x377
    x434 = -x322 + x95
    x435 = x326*x430 + x427*x99 + x428*x93 - x429 + x46*(x432 - x433) + x53*(-x159*x397 + x159*x425 + x161) + x62*(x119*x159*x16*x27*x9 - x162 - x431*x6 - x434)
    x436 = x0*x167 - x17*x240
    x437 = -x167*x19 + x168*x17 + x388
    x438 = x437*x45
    x439 = -x0*x168 + x119*x164*x19*x6*x94 - x405
    x440 = x164*x372
    x441 = x164*x375
    x442 = x12*x440 + x380
    x443 = x326*x436 + x437*x93 - x438 + x439*x99 + x46*(-x441 + x442) + x53*(-x164*x397 + x164*x425 + x168 + x434) + x62*(x119*x16*x164*x27*x9 - x167 - x440*x6)
    x444 = x171*x23
    x445 = x1*x444
    x446 = x444*x63
    x447 = x444*x71
    x448 = x19*x444
    x449 = x448*x79
    x450 = x444*x81
    x451 = x12*x450
    x452 = x16*x444
    x453 = -3*p1
    x454 = x170 + x453
    x455 = -x317*x454
    x456 = x36*x455
    x457 = x350*x45
    x458 = -2*p1
    x459 = x198 + x458
    x460 = x18*x444
    x461 = -x448*x56 + x49
    x462 = 2*x353
    x463 = x310*x456
    x464 = x332*x455
    x465 = x106 + x355
    x466 = x330*x455
    x467 = x352*x45
    x468 = x365*x45
    x469 = x336*x39
    x470 = x334*x42
    x471 = x109*x365 + x115*x352 + x326*x345 + x350*x353 + x353*x366 + x360*x99 - x467 - x468 - x469 - x470
    x472 = x387*x45
    x473 = x120*x17
    x474 = x19*x473
    x475 = x474*x9
    x476 = x475*x6
    x477 = x120*x18
    x478 = x12*x477
    x479 = x135 - x478*x6
    x480 = x17*x29
    x481 = x19*x7
    x482 = -x473*x481 + x480
    x483 = x351 + x400
    x484 = x334*x35
    x485 = x345*x98
    x486 = x110*x350
    x487 = x352*x384
    x488 = x109*x387 + x346 + x348 + x35*x485 + x35*x486 + x35*x487 + x353*x389 + x370*x99 + x46*(-x476 - x479) - x472 - x484 + x53*(-x373 - x482) + x62*(x220 + x399 - x477*x7 + x483)
    x489 = x404*x45
    x490 = x477*x6
    x491 = x334*x38
    x492 = x109*x404 + x333 + x337 + x353*x406 + x38*x485 + x38*x486 + x38*x487 + x391*x99 + x457 + x46*(-x140 - x395*x473 + x478*x9 + x480) - x489 - x491 + x53*(-x394 + x476) + x62*(x10*x372 + x133 - x380 - x490*x9)
    x493 = x415*x45
    x494 = x12*x475
    x495 = x123*x474
    x496 = x334*x41
    x497 = x109*x415 + x353*x416 + x408*x99 + x41*x485 + x41*x486 + x41*x487 + x46*(x119*x13*x18*x27 - x147 - x483 - x494) + x467 + x469 - x493 - x496 + x53*(x411 + x495) + x62*(x394 + x479)
    x498 = x423*x45
    x499 = x474*x6
    x500 = x151*x499 + x480
    x501 = -x351 + x95
    x502 = x109*x423 + x353*x424 + x418*x99 + x46*(x119*x12*x151*x18*x27 - x151*x475 - x154) - x498 + x53*(-x421 + x500) + x62*(x151*x393 - x151*x490 + x233 + x501)
    x503 = x427*x45
    x504 = -x159*x499
    x505 = x109*x427 + x353*x430 + x428*x99 + x46*(x119*x12*x159*x18*x27 - x159*x475 - x161 - x480) - x503 + x53*(-x432 - x504) + x62*(x159*x393 - x159*x490 + x237 + x380)
    x506 = x439*x45
    x507 = -x164*x499
    x508 = x109*x439 + x353*x436 + x437*x99 + x46*(x119*x12*x164*x18*x27 - x164*x475 - x168 - x501) - x506 + x53*(-x442 - x507) + x62*(x164*x393 - x164*x490 + x240)
    x509 = x23*x244
    x510 = x1*x509
    x511 = x509*x63
    x512 = x509*x71
    x513 = x509*x81
    x514 = x12*x513
    x515 = x19*x509
    x516 = x515*x79
    x517 = -3*p2
    x518 = x243 + x517
    x519 = -x317*x518
    x520 = x36*x519
    x521 = x18*x509
    x522 = -x515*x56 + x58
    x523 = x310*x520
    x524 = x332*x519
    x525 = x366*x45
    x526 = -2*p2
    x527 = x267 + x526
    x528 = x20*x509
    x529 = x330*x519
    x530 = x389*x45
    x531 = x120*x20
    x532 = x531*x9
    x533 = x133 - x532*x6
    x534 = x359 + x400
    x535 = x336*x35
    x536 = x360*x98
    x537 = x110*x365
    x538 = x366*x384
    x539 = x115*x389 + x326*x370 + x35*x536 + x35*x537 + x35*x538 + x353*x387 + x361 + x364 + x46*(x495 + x533) + x53*(x119*x20*x27*x7 - x220 - x413 - x534) - x530 - x535 + x62*(x376 + x482)
    x540 = x406*x45
    x541 = x336*x38
    x542 = x115*x406 + x326*x391 + x353*x404 + x38*x536 + x38*x537 + x38*x538 + x46*(-x10*x531 + x143 + x494 + x534) + x468 + x470 + x53*(-x410 - x533) - x540 - x541 + x62*(-x396 - x476)
    x543 = x416*x45
    x544 = x336*x41
    x545 = x115*x416 + x326*x408 + x333 + x335 + x353*x415 + x41*x536 + x41*x537 + x41*x538 + x46*(-x12*x532 + x13*x474 + x140 - x480) + x525 + x53*(x119*x12*x20*x27*x6 - x120*x149*x19 - x135 + x377) - x543 - x544 + x62*(x410 - x495)
    x546 = x424*x45
    x547 = x12*x151
    x548 = -x359 + x95
    x549 = x115*x424 + x326*x418 + x353*x423 + x46*(-x151*x532 + x157 + x474*x547) + x53*(x119*x151*x20*x27*x6 - x233 - x412*x547 - x548) - x546 + x62*(-x422 - x500)
    x550 = x430*x45
    x551 = x12*x159
    x552 = x115*x430 + x326*x428 + x353*x427 + x46*(-x159*x532 + x162 + x474*x551 + x548) + x53*(x119*x159*x20*x27*x6 - x237 - x412*x551) - x550 + x62*(x433 + x504)
    x553 = x436*x45
    x554 = x12*x164
    x555 = x115*x436 + x326*x437 + x353*x439 + x46*(-x164*x532 + x167 + x474*x554 + x480) + x53*(x119*x164*x20*x27*x6 - x240 - x377 - x412*x554) - x553 + x62*(x441 + x507)
    x556 = x317*x319
    x557 = x36*x556
    x558 = x310*x557
    x559 = x332*x556
    x560 = x330*x556
    x561 = x139*x17
    x562 = -x561
    x563 = 3*n0 + x318
    x564 = x14**(mpmath.mpf(-5)/mpmath.mpf(2))
    x565 = x564*x94
    x566 = x563*x565
    x567 = x17*x566
    x568 = x123*x567
    x569 = x156*x19
    x570 = x566*x6
    x571 = -x126*x570 + x569
    x572 = 2*n0 + x308
    x573 = -x572
    x574 = x131*x19
    x575 = x123*x566
    x576 = x0*x139
    x577 = x132*x19
    x578 = -x577
    x579 = x576 + x578
    x580 = x131*x17
    x581 = x132*x17
    x582 = x0*x156
    x583 = -x582
    x584 = x581 + x583
    x585 = x35*x98
    x586 = x110*x35
    x587 = x35*x384
    x588 = x567*x9
    x589 = x12*x566
    x590 = x589*x79
    x591 = x0*x132
    x592 = x156*x17
    x593 = -x592
    x594 = x370*x98
    x595 = x110*x387
    x596 = x384*x389
    x597 = x38*x594 + x38*x595 + x38*x596 + x391*x585 + x392 + x402 + x404*x586 + x406*x587 + x472 + x484
    x598 = x139*x19
    x599 = -x598
    x600 = x408*x585 + x409 + x41*x594 + x41*x595 + x41*x596 + x414 + x415*x586 + x416*x587 + x530 + x535
    x601 = x151*x566
    x602 = -x569
    x603 = x561 + x602
    x604 = x151*x574
    x605 = x576 + x604
    x606 = x567*x6
    x607 = x151*x580
    x608 = x582 + x607
    x609 = x418*x585 + x419 + x423*x586 + x424*x587
    x610 = x159*x566
    x611 = x159*x574
    x612 = x159*x580
    x613 = x591 + x612
    x614 = x427*x586 + x428*x585 + x429 + x430*x587
    x615 = x164*x566
    x616 = x164*x574
    x617 = x591 + x616
    x618 = x164*x580
    x619 = x436*x587 + x437*x585 + x438 + x439*x586
    x620 = x317*x454
    x621 = x36*x620
    x622 = x310*x621
    x623 = x332*x620
    x624 = x330*x620
    x625 = 3*n1 + x453
    x626 = x565*x625
    x627 = x17*x626
    x628 = x123*x627
    x629 = x6*x626
    x630 = -x126*x629 + x577
    x631 = x123*x626
    x632 = -x591
    x633 = 2*n1 + x458
    x634 = x627*x9
    x635 = x562 + x569
    x636 = -x576
    x637 = x12*x626
    x638 = x637*x79
    x639 = -x633
    x640 = x0*x131
    x641 = x38*x98
    x642 = x110*x38
    x643 = x38*x384
    x644 = x41*x98
    x645 = x110*x41
    x646 = x384*x41
    x647 = x391*x644 + x404*x645 + x406*x646 + x408*x641 + x415*x642 + x416*x643 + x493 + x496 + x540 + x541
    x648 = x151*x626
    x649 = x6*x627
    x650 = x151*x640
    x651 = x592 + x650
    x652 = x418*x641 + x423*x642 + x424*x643 + x498
    x653 = x159*x626
    x654 = x561 + x611
    x655 = x159*x640
    x656 = x581 + x655
    x657 = x427*x642 + x428*x641 + x430*x643 + x503
    x658 = x164*x626
    x659 = x592 + x616
    x660 = x164*x640
    x661 = x436*x643 + x437*x641 + x439*x642 + x506
    x662 = x317*x518
    x663 = x36*x662
    x664 = x310*x663
    x665 = x332*x662
    x666 = x330*x662
    x667 = 3*n2 + x517
    x668 = x565*x667
    x669 = x6*x668
    x670 = x126*x669
    x671 = x17*x668
    x672 = -x123*x671 + x581
    x673 = x123*x668
    x674 = x671*x9
    x675 = x12*x668
    x676 = x675*x79
    x677 = 2*n2 + x526
    x678 = -x677
    x679 = x151*x668
    x680 = x598 + x650
    x681 = x6*x671
    x682 = x418*x644 + x423*x645 + x424*x646 + x546
    x683 = x159*x668
    x684 = x598 + x612
    x685 = x427*x645 + x428*x644 + x430*x646 + x550
    x686 = x164*x668
    x687 = x569 + x618
    x688 = x577 + x660
    x689 = -x581
    x690 = x582 + x689
    x691 = x436*x646 + x437*x644 + x439*x645 + x553
    x692 = -x563
    x693 = x565*x692
    x694 = x6*x693
    x695 = x126*x694
    x696 = x17*x693
    x697 = x123*x696 + x561
    x698 = x123*x693
    x699 = x696*x9
    x700 = x12*x693
    x701 = -x700*x79
    x702 = x151*x693
    x703 = x6*x696
    x704 = x159*x693
    x705 = -x612 + x650
    x706 = x164*x693
    x707 = -x616
    x708 = x650 + x707
    x709 = -x625
    x710 = x565*x709
    x711 = x6*x710
    x712 = x126*x711
    x713 = x17*x710
    x714 = -x123*x713
    x715 = x123*x710
    x716 = x713*x9
    x717 = x12*x710
    x718 = x576 + x717*x79
    x719 = x151*x710
    x720 = x6*x713
    x721 = x159*x710
    x722 = x577 + x636
    x723 = x164*x710
    x724 = x612 + x707
    x725 = -x667
    x726 = x565*x725
    x727 = x17*x726
    x728 = x123*x727
    x729 = x6*x726
    x730 = -x126*x729
    x731 = x123*x726
    x732 = x727*x9
    x733 = x12*x726
    x734 = x582 + x733*x79
    x735 = x151*x726
    x736 = x6*x727
    x737 = x159*x726
    x738 = x164*x726

    return np.array([x46*(-x19*x25*x9 + x25*x26 + x34) + x53*(x1*x15*x19*x22*x4*x6 - x12*x48 - 2*x47 - x52) + x62*(-x25*x56 + x48*x9 + 2*x55 + x61), x46*(-x19*x64*x9 + x26*x64 + x47) + x53*(-x12*x66 + x15*x19*x22*x4*x6*x63 - x65) + x62*(-x56*x64 + x66*x9 + x70), x46*(x12*x15*x17*x22*x4*x71 - x19*x73*x9 - x55) + x53*(-x12*x74 + x15*x19*x22*x4*x6*x71 - x76) + x62*(-x56*x73 + x72 + x74*x9), x103 + x46*(x77 - x80 + x83) + x53*(-x12*x16*x24 + x31*x86 + x6*x87 + x88) + x62*(x15*x16*x22*x4*x9 + x15*x27*x85*x9 - x6*x82 - x89), x111 + x46*(-x104*x78 + x12*x15*x18*x22*x4 - x47) + x53*(-x105 - x83) + x62*(x107 - x18*x24*x6 + x82*x9), x118 + x46*(-x20*x24*x9 + x26*x78 + x55) + x53*(-x113 - x12*x87 + x15*x20*x22*x4*x6) + x62*(x105 + x30 + x80), x137, x146, x150, x158, x163, x169, x46*(-x126*x174 + x174*x26 + x47) + x53*(x1*x15*x172*x19*x22*x6 - x174*x175 - x65) + x62*(-x174*x56 + x174*x79 + x70), x46*(-x126*x176 + x176*x26 + x34 + 2*x65) + x53*(x15*x172*x19*x22*x6*x63 - x175*x176 - x52) + x62*(x0*x15*x172*x22*x63*x9 - x176*x56 - 2*x177 - x179), x46*(-x126*x181 + x181*x26 + x183) + x53*(-x175*x181 + x177 + x180*x181) + x62*(x0*x15*x172*x22*x71*x9 - x181*x56 - x182), x197 + x46*(x185 + x187) + x53*(-x12*x16*x173 + x173*x188 + x65) + x62*(x15*x16*x172*x22*x9 - x186*x6 - x190), x206 + x46*(-x104*x184 + x12*x15*x172*x18*x22 + x12*x15*x199*x27 - x200) + x53*(-x187 - x201 + x202) + x62*(-x173*x18*x6 + x186*x9 + x203*x57 + x204), x211 + x46*(-x173*x20*x9 + x184*x26 + x207) + x53*(x15*x172*x20*x22*x6 - x175*x184 - x177) + x62*(-x185 - x202 - x49), x224, x229, x230, x234, x238, x242, x46*(x1*x12*x15*x17*x22*x245 - x126*x247 - x55) + x53*(x1*x15*x19*x22*x245*x6 - x175*x247 - x76) + x62*(-x247*x56 + x247*x79 + x72), x46*(-x126*x248 + x183 + x248*x26) + x53*(-x175*x248 + x177 + x180*x248) + x62*(x0*x15*x22*x245*x63*x9 - x182 - x248*x56), x46*(x12*x15*x17*x22*x245*x71 - x126*x249 - x250 - 2*x72) + x53*(-x175*x249 + x180*x249 + 2*x182 + x251) + x62*(-x249*x56 + x249*x79 + x61), x262 + x46*(-x253 - x255) + x53*(-x12*x16*x246 + x188*x246 + x256) + x62*(x15*x16*x22*x245*x9 - x252*x6 - x72), x266 + x46*(-x104*x254 + x12*x15*x18*x22*x245 - x263) + x53*(x253 + x264 + x58) + x62*(-x18*x246*x6 + x182 + x252*x9), x275 + x46*(-x20*x246*x9 + x254*x26 + x269*x54 + x270) + x53*(x15*x20*x22*x245*x6 + x15*x268*x27*x6 - x175*x254 - x271) + x62*(x178 + x255 - x264), x286, x291, x292, x294, x296, x299, x103 + x46*(-x126*x301 + x250 + x26*x301) + x53*(-x175*x301 + x180*x301 - 2*x50 + x88) + x62*(x0*x1*x15*x22*x3*x9 + 2*x0*x15*x27*x9 - x301*x56 - x89), x197 + x46*(-x126*x302 + x26*x302 + x50) + x53*(-x175*x302 + x180*x302 + x65) + x62*(x0*x15*x22*x3*x63*x9 - x190 - x302*x56), x262 + x46*(x12*x15*x17*x22*x3*x71 - x126*x303 - x59) + x53*(-x175*x303 + x180*x303 + x256) + x62*(x0*x15*x22*x3*x71*x9 - x303*x56 - x72), 2*x306*x93 - 2*x307 + x309*x311 + x320*x321 + x323*x324 + x325*x327 + x328*x330 + x328*x332 + x338 + x46*(x313 + x315 + x33) + x53*(-x12*x316 + x188*x300 + x251 + x31*x85) + x62*(-x312*x6 + x316*x9 + x54*x86 + x61), x320*x341 + x342*x39 + x343*x39 + x354 + x46*(-x104*x314 + x12*x15*x18*x22*x3 - x50) + x53*(-x313 + x32 + x339) + x62*(-x18*x300*x6 + x312*x9 + x340), x320*x357 + x342*x42 + x358*x42 + x367 + x46*(-x20*x300*x9 + x26*x314 + x59) + x53*(x15*x20*x22*x3*x6 - x175*x314 - x356) + x62*(-x315 - x339), 2*x333 + x342*x35 + x343*x35 + x35*x358 + x390, x342*x38 + x343*x38 + x358*x38 + x407, x342*x41 + x343*x41 + x358*x41 + x417, x426, x435, x443, x111 + x46*(x1*x12*x15*x17*x171*x22 - x126*x445 - x47) + x53*(x1*x15*x171*x19*x22*x6 - x175*x445 - x32) + x62*(x107 - x445*x56 + x445*x79), x206 + x46*(x12*x15*x17*x171*x22*x63 + 2*x12*x15*x17*x27 - x126*x446 - x200) + x53*(x15*x171*x19*x22*x6*x63 - x175*x446 - x251) + x62*(x204 - x446*x56 + x446*x79 - 2*x58), x266 + x46*(x12*x15*x17*x171*x22*x71 - x126*x447 - x263) + x53*(-x175*x447 + x180*x447 + x58) + x62*(x182 - x447*x56 + x447*x79), x321*x455 + x330*x456 + x332*x456 + x354 + x46*(-x449 + x451 - x50) + x53*(-x12*x452 + x188*x444 + x32) + x62*(x340 - x450*x6 + x452*x9), 2*x109*x350 + x324*x345 + x334*x459 + x338 + x341*x455 + x352*x462 + x39*x463 + x39*x464 - 2*x457 + x46*(-x104*x448 + x12*x460 + x203*x31 + x34) + x53*(-x451 - x461 - x51) + x62*(x199*x57 + x450*x9 - x460*x6 + x61), x357*x455 + x42*x463 + x42*x466 + x46*(-x20*x444*x9 + x26*x448 + x465) + x471 + x53*(x15*x171*x20*x22*x6 - x175*x448 - x58) + x62*(x449 + x461), x35*x463 + x35*x464 + x35*x466 + x488, 2*x335 + x38*x463 + x38*x464 + x38*x466 + x492, x41*x463 + x41*x464 + x41*x466 + x497, x502, x505, x508, x118 + x46*(-x126*x510 + x26*x510 + x55) + x53*(x1*x15*x19*x22*x244*x6 - x113 - x175*x510) + x62*(x30 - x510*x56 + x510*x79), x211 + x46*(-x126*x511 + x207 + x26*x511) + x53*(x15*x19*x22*x244*x6*x63 - x175*x511 - x177) + x62*(x0*x15*x22*x244*x63*x9 - x49 - x511*x56), x275 + x46*(-x126*x512 + x26*x512 + x270 - 2*x30) + x53*(x15*x19*x22*x244*x6*x71 + 2*x15*x19*x27*x6 - x175*x512 - x271) + x62*(x179 - x512*x56 + x512*x79), x321*x519 + x330*x520 + x332*x520 + x367 + x46*(x514 - x516 + x59) + x53*(x0*x15*x19*x22*x244*x6 - x12*x16*x509 - x356) + x62*(x15*x16*x22*x244*x9 - x30 - x513*x6), x341*x519 + x39*x523 + x39*x524 + x46*(-x104*x515 + x12*x521 + x465) + x471 + x53*(-x514 - x522) + x62*(x49 + x513*x9 - x521*x6), 2*x115*x366 + x327*x360 + x336*x527 + x338 + x357*x519 + x365*x462 + x42*x523 + x42*x529 + x46*(x26*x515 + x268*x54 + x34 - x528*x9) - 2*x525 + x53*(-x175*x515 + x251 + x269*x57 + x528*x6) + x62*(x516 + x522 + x60), x35*x523 + x35*x524 + x35*x529 + x539, x38*x523 + x38*x524 + x38*x529 + x542, 2*x337 + x41*x523 + x41*x524 + x41*x529 + x545, x549, x552, x555, x137, x224, x286, -x309*x311 + x321*x556 + x330*x557 + x332*x557 + x390, x341*x556 + x39*x558 + x39*x559 + x488, x357*x556 + x42*x558 + x42*x560 + x539, x338 + x35*x558 + x35*x559 + x35*x560 + 2*x370*x585 + 2*x371 + 2*x381 + 2*x387*x586 + 2*x389*x587 + x46*(x562 + x568 + x571) + x53*(-x0*x575 + x481*x566 + x573*x574 + x579) + x62*(-x567*x7 + x570*x79 + x572*x580 + x584), x38*x558 + x38*x559 + x38*x560 + x46*(x12*x588 - x395*x566 + x577) + x53*(-x571 - x590) + x597 + x62*(x0*x10*x563*x564*x94 - x588*x6 - x591 - x593), x41*x558 + x41*x559 + x41*x560 + x46*(-x126*x589 + x13*x17*x563*x564*x94 - x581) + x53*(-x149*x566 + x19*x575 + x591 + x599) + x600 + x62*(x561 - x568 + x590), x46*(-x126*x601 + x547*x567 + x603) + x53*(2*x119*x19*x6*x94 + x151*x19*x563*x564*x6*x94 - x175*x601 - x605) + x609 + x62*(-x151*x606 - 2*x581 + x601*x79 + x608), x46*(x12*x159*x17*x563*x564*x94 - x126*x610 - x577) + x53*(x159*x19*x563*x564*x6*x94 - x175*x610 - x611) + x614 + x62*(-x159*x606 + x610*x79 + x613), x46*(-x126*x615 + x554*x567 + x581) + x53*(x164*x19*x563*x564*x6*x94 - x175*x615 - x617) + x619 + x62*(-x164*x606 + x615*x79 + x618), x146, x229, x291, x321*x620 + x330*x621 + x332*x621 + x407, -x334*x459 + x341*x620 + x39*x622 + x39*x623 + x492, x357*x620 + x42*x622 + x42*x624 + x542, x35*x622 + x35*x623 + x35*x624 + x46*(x628 + x630) + x53*(-x0*x631 + x19*x564*x625*x7*x94 - x569) + x597 + x62*(x592 - x627*x7 + x629*x79 + x632), x338 + x38*x622 + x38*x623 + x38*x624 + 2*x391*x641 + 2*x404*x642 + 2*x406*x643 + x46*(x12*x634 - x395*x626 + x574*x633 + x635) + 2*x489 + 2*x491 + x53*(-x630 - x636 - x638) + x62*(x0*x10*x626 + x584 - x6*x634 + x639*x640), x41*x622 + x41*x623 + x41*x624 + x46*(-x126*x637 + x13*x17*x564*x625*x94 - x592 - x599) + x53*(-x149*x626 + x19*x631 + x582) + x62*(-x576 - x628 + x638) + x647, x46*(-x126*x648 + x547*x627 + x604) + x53*(-x175*x648 + x180*x648 + x569) + x62*(x0*x151*x564*x625*x9*x94 - x151*x649 - x651) + x652, x46*(-x126*x653 + x551*x627 - 2*x569 + x654) + x53*(x159*x19*x564*x6*x625*x94 - x175*x653 - x579) + x62*(2*x0*x119*x9*x94 + x0*x159*x564*x625*x9*x94 - x159*x649 - x656) + x657, x46*(-x126*x658 + x554*x627 + x659) + x53*(x164*x19*x564*x6*x625*x94 - x175*x658 - x582) + x62*(x0*x164*x564*x625*x9*x94 - x164*x649 - x660) + x661, x150, x230, x292, x321*x662 + x330*x663 + x332*x663 + x417, x341*x662 + x39*x664 + x39*x665 + x497, -x336*x527 + x357*x662 + x42*x664 + x42*x666 + x545, x35*x664 + x35*x665 + x35*x666 + x46*(-x670 - x672) + x53*(-x0*x673 + x19*x564*x667*x7*x94 - x598 - x632) + x600 + x62*(x561 + x669*x79 - x671*x7), x38*x664 + x38*x665 + x38*x666 + x46*(x12*x674 - x395*x668 + x593 + x598) + x53*(x582 + x670 - x676) + x62*(x0*x10*x564*x667*x94 - x576 - x6*x674) + x647, x338 + 2*x408*x644 + x41*x664 + x41*x665 + x41*x666 + 2*x415*x645 + 2*x416*x646 + x46*(-x126*x675 + x13*x671 + x580*x678 + x635) + x53*(-x149*x668 + x19*x673 + x579 + x640*x677) + 2*x543 + 2*x544 + x62*(x583 + x672 + x676), x46*(x12*x151*x17*x564*x667*x94 - x126*x679 - x607) + x53*(-x175*x679 + x180*x679 + x680) + x62*(x0*x151*x564*x667*x9*x94 - x151*x681 - x561) + x682, x46*(x12*x159*x17*x564*x667*x94 - x126*x683 - x684) + x53*(-x175*x683 + x180*x683 + x655) + x62*(-x159*x681 + x576 + x683*x79) + x685, x46*(2*x119*x12*x17*x94 + x12*x164*x17*x564*x667*x94 - x126*x686 - x687) + x53*(-x175*x686 + x180*x686 - 2*x576 + x688) + x62*(-x164*x681 + x686*x79 + x690) + x691, x158, x234, x294, x426, x502, x549, x46*(x602 - x695 + x697) + x53*(-x0*x698 + x119*x19*x572*x94 + x19*x564*x692*x7*x94 - x605) + x609 + x62*(x573*x580 + x608 + x694*x79 - x696*x7), x46*(x12*x699 - x395*x693 + x604) + x53*(x569 + x695 + x701) + x62*(x0*x10*x564*x692*x94 - x6*x699 - x651) + x652, x46*(-x126*x700 + x13*x17*x564*x692*x94 - x607) + x53*(-x149*x693 + x19*x698 + x680) + x62*(-x697 - x701) + x682, x46*(-x126*x702 + x547*x696 + x635) + x53*(-x175*x702 + x180*x702 + x579 + 2*x604) + x62*(x0*x151*x564*x692*x9*x94 - x151*x703 - 2*x607 - x690), x46*(x12*x159*x17*x564*x692*x94 - x126*x704 - x604) + x53*(-x175*x704 + x180*x704 + x611) + x62*(-x159*x703 + x704*x79 + x705), x46*(-x126*x706 + x554*x696 + x607) + x53*(x164*x19*x564*x6*x692*x94 - x175*x706 - x708) + x62*(x0*x164*x564*x692*x9*x94 - x164*x703 - x618), x163, x238, x296, x435, x505, x552, x46*(-x577 - x712 - x714) + x53*(-x0*x715 + x19*x564*x7*x709*x94 - x611) + x614 + x62*(x613 - x7*x713 + x711*x79), x46*(x12*x716 - x395*x710 + x574*x639 + x654) + x53*(-x578 + x712 - x718) + x62*(x0*x10*x564*x709*x94 + x0*x119*x633*x94 - x6*x716 - x656) + x657, x46*(-x126*x717 + x13*x17*x564*x709*x94 - x684) + x53*(-x149*x710 + x19*x715 + x655) + x62*(x714 + x718) + x685, x46*(x12*x151*x17*x564*x709*x94 - x126*x719 - x604) + x53*(-x175*x719 + x180*x719 + x611) + x62*(-x151*x720 + x705 + x719*x79), x46*(x12*x159*x17*x564*x709*x94 - x126*x721 - x603 - 2*x611) + x53*(x159*x19*x564*x6*x709*x94 - x175*x721 - x722) + x62*(-x159*x720 + x584 + 2*x655 + x721*x79), x46*(-x126*x723 + x554*x713 + x724) + x53*(x164*x19*x564*x6*x709*x94 - x175*x723 - x655) + x62*(-x164*x720 + x660 + x723*x79), x169, x242, x299, x443, x508, x555, x46*(x581 + x728 + x730) + x53*(-x0*x731 + x19*x564*x7*x725*x94 - x617) + x619 + x62*(x618 - x7*x727 + x729*x79), x46*(x12*x732 - x395*x726 + x659) + x53*(-x730 - x734) + x62*(x0*x10*x564*x725*x94 - x6*x732 - x660) + x661, x46*(x119*x17*x677*x94 - x126*x733 + x13*x17*x564*x725*x94 - x687) + x53*(-x149*x726 + x19*x731 + x640*x678 + x688) + x62*(x689 - x728 + x734) + x691, x46*(-x126*x735 + x547*x727 + x607) + x53*(x151*x19*x564*x6*x725*x94 - x175*x735 - x708) + x62*(x0*x151*x564*x725*x9*x94 - x151*x736 - x618), x46*(-x126*x737 + x551*x727 + x724) + x53*(x159*x19*x564*x6*x725*x94 - x175*x737 - x655) + x62*(-x159*x736 + x660 + x737*x79), x46*(-x126*x738 + x554*x727 + 2*x618 + x635) + x53*(x164*x19*x564*x6*x725*x94 - x175*x738 - 2*x660 - x722) + x62*(-x164*x736 + x584 + x738*x79)], dtype=np.float64)


def q_lb(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Bend"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -o1
    x3 = m1 + x2
    x4 = -o2
    x5 = m2 + x4
    x6 = n0 + x0
    x7 = n1 + x2
    x8 = n2 + x4

    return (p0*(x3*x8 - x5*x7) + p1*(-x1*x8 + x5*x6) + p2*(x1*x7 - x3*x6))/(mpmath.sqrt(x1**2 + x3**2 + x5**2)*mpmath.sqrt(x6**2 + x7**2 + x8**2))


def dq_lb(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Bend, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -o2
    x1 = n2 + x0
    x2 = -x1
    x3 = -o1
    x4 = n1 + x3
    x5 = -o0
    x6 = m0 + x5
    x7 = m1 + x3
    x8 = m2 + x0
    x9 = x6**2 + x7**2 + x8**2
    x10 = 1/mpmath.sqrt(x9)
    x11 = n0 + x5
    x12 = x1**2 + x11**2 + x4**2
    x13 = 1/mpmath.sqrt(x12)
    x14 = x10*x13
    x15 = -x6
    x16 = -x4
    x17 = -x11
    x18 = p0*(x1*x7 + x16*x8) + p1*(x11*x8 + x2*x6) + p2*(x17*x7 + x4*x6)
    x19 = x13*x18/x9**(mpmath.mpf(3)/mpmath.mpf(2))
    x20 = -x7
    x21 = -x8
    x22 = m2 - n2
    x23 = m1 - n1
    x24 = x10*x18/x12**(mpmath.mpf(3)/mpmath.mpf(2))
    x25 = m0 - n0

    return np.array([x14*(p1*x2 + p2*x4) + x15*x19, x14*(p0*x1 + p2*x17) + x19*x20, x14*(p0*x16 + p1*x11) + x19*x21, x11*x24 + x14*(-p1*x22 + p2*x23) + x19*x6, x14*(p0*x22 - p2*x25) + x19*x7 + x24*x4, x1*x24 + x14*(-p0*x23 + p1*x25) + x19*x8, x14*(p1*x8 + p2*x20) + x17*x24, x14*(p0*x21 + p2*x6) + x16*x24, x14*(p0*x7 + p1*x15) + x2*x24], dtype=np.float64)


def d2q_lb(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Bend, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -o2
    x1 = n2 + x0
    x2 = -x1
    x3 = -o1
    x4 = n1 + x3
    x5 = p1*x2 + p2*x4
    x6 = -o0
    x7 = m0 + x6
    x8 = -x7
    x9 = m1 + x3
    x10 = m2 + x0
    x11 = x10**2 + x7**2 + x9**2
    x12 = x11**(mpmath.mpf(-3)/mpmath.mpf(2))
    x13 = n0 + x6
    x14 = x1**2 + x13**2 + x4**2
    x15 = 1/mpmath.sqrt(x14)
    x16 = x12*x15
    x17 = x16*x8
    x18 = x1*x9
    x19 = -x4
    x20 = x10*x19
    x21 = x2*x7
    x22 = x10*x13
    x23 = x4*x7
    x24 = -x13
    x25 = x24*x9
    x26 = p0*(x18 + x20) + p1*(x21 + x22) + p2*(x23 + x25)
    x27 = x16*x26
    x28 = -x27
    x29 = x26*x8
    x30 = -3*o0
    x31 = 3*m0 + x30
    x32 = x15/x11**(mpmath.mpf(5)/mpmath.mpf(2))
    x33 = -x31*x32
    x34 = -x9
    x35 = x26*x33
    x36 = p0*x1 + p2*x24
    x37 = x16*x5
    x38 = x17*x36 + x34*x37
    x39 = -x10
    x40 = p0*x19 + p1*x13
    x41 = x17*x40 + x37*x39
    x42 = m2 - n2
    x43 = m1 - n1
    x44 = -p1*x42 + p2*x43
    x45 = 1/mpmath.sqrt(x11)
    x46 = x14**(mpmath.mpf(-3)/mpmath.mpf(2))
    x47 = x45*x46
    x48 = x47*x5
    x49 = x12*x46
    x50 = x29*x49
    x51 = x13*x48 + x13*x50 + x17*x44 + x27 + x37*x7
    x52 = x15*x45
    x53 = p2*x52
    x54 = -x53
    x55 = m0 - n0
    x56 = p0*x42 - p2*x55
    x57 = x17*x56 + x37*x9 + x4*x48 + x4*x50 + x54
    x58 = p1*x52
    x59 = -p0*x43 + p1*x55
    x60 = x1*x48 + x1*x50 + x10*x37 + x17*x59 + x58
    x61 = p1*x10 + p2*x34
    x62 = x17*x61 + x24*x48 + x24*x50
    x63 = p0*x39 + p2*x7
    x64 = x17*x63 + x19*x48 + x19*x50 + x53
    x65 = -x58
    x66 = p0*x9 + p1*x8
    x67 = x17*x66 + x2*x48 + x2*x50 + x65
    x68 = -3*o1
    x69 = 3*m1 + x68
    x70 = -x32*x69
    x71 = x16*x34
    x72 = x26*x70
    x73 = x16*x36
    x74 = x39*x73 + x40*x71
    x75 = x36*x47
    x76 = x26*x34
    x77 = x49*x76
    x78 = x13*x75 + x13*x77 + x44*x71 + x53 + x7*x73
    x79 = x27 + x4*x75 + x4*x77 + x56*x71 + x73*x9
    x80 = p0*x52
    x81 = -x80
    x82 = x1*x75 + x1*x77 + x10*x73 + x59*x71 + x81
    x83 = x24*x75 + x24*x77 + x54 + x61*x71
    x84 = x19*x75 + x19*x77 + x63*x71
    x85 = x2*x75 + x2*x77 + x66*x71 + x80
    x86 = -3*o2
    x87 = 3*m2 + x86
    x88 = -x32*x87
    x89 = x16*x40
    x90 = x26*x88
    x91 = x16*x39
    x92 = x40*x47
    x93 = x26*x39
    x94 = x49*x93
    x95 = x13*x92 + x13*x94 + x44*x91 + x65 + x7*x89
    x96 = x4*x92 + x4*x94 + x56*x91 + x80 + x89*x9
    x97 = x1*x92 + x1*x94 + x10*x89 + x27 + x59*x91
    x98 = x24*x92 + x24*x94 + x58 + x61*x91
    x99 = x19*x92 + x19*x94 + x63*x91 + x81
    x100 = x2*x92 + x2*x94 + x66*x91
    x101 = x31*x32
    x102 = x16*x7
    x103 = 2*x44
    x104 = x13*x47
    x105 = x101*x26
    x106 = x13*x26
    x107 = 3*n0 + x30
    x108 = x45/x14**(mpmath.mpf(5)/mpmath.mpf(2))
    x109 = x107*x108
    x110 = x106*x49
    x111 = x26*x47
    x112 = -x111
    x113 = x112 + x28
    x114 = x109*x26
    x115 = x16*x44
    x116 = x44*x47
    x117 = x26*x49
    x118 = x102*x56 + x104*x56 + x110*x9 + x115*x9 + x116*x4 + x117*x23
    x119 = x117*x7
    x120 = x1*x116 + x1*x119 + x10*x115 + x102*x59 + x104*x59 + x117*x22
    x121 = x102*x61 + x104*x61 + x111 + x116*x24 + x119*x24
    x122 = x102*x63 + x104*x63 + x116*x19 + x119*x19 + x54
    x123 = x102*x66 + x104*x66 + x116*x2 + x117*x21 + x58
    x124 = x32*x69
    x125 = x124*x26
    x126 = 3*n1 + x68
    x127 = x108*x126
    x128 = x16*x9
    x129 = 2*x56
    x130 = x4*x47
    x131 = x127*x26
    x132 = x117*x9
    x133 = x10*x16
    x134 = x47*x56
    x135 = x10*x117
    x136 = x1*x134 + x117*x18 + x128*x59 + x130*x59 + x133*x56 + x135*x4
    x137 = x117*x25 + x128*x61 + x130*x61 + x134*x24 + x53
    x138 = x111 + x128*x63 + x130*x63 + x132*x19 + x134*x19
    x139 = x128*x66 + x130*x66 + x132*x2 + x134*x2 + x81
    x140 = x32*x87
    x141 = x140*x26
    x142 = 3*n2 + x86
    x143 = x108*x142
    x144 = x143*x26
    x145 = 2*x59
    x146 = x1*x47
    x147 = x47*x59
    x148 = x133*x61 + x135*x24 + x146*x61 + x147*x24 + x65
    x149 = x117*x20 + x133*x63 + x146*x63 + x147*x19 + x80
    x150 = x111 + x133*x66 + x135*x2 + x146*x66 + x147*x2
    x151 = -x107*x108
    x152 = x151*x26
    x153 = x24*x47
    x154 = x47*x61
    x155 = x153*x63 + x154*x19
    x156 = x153*x66 + x154*x2
    x157 = -x108*x126
    x158 = x157*x26
    x159 = x19*x47
    x160 = x2*x47
    x161 = x159*x66 + x160*x63
    x162 = -x108*x142
    x163 = x162*x26

    return np.array([2*x17*x5 + x28 + x29*x33, x34*x35 + x38, x35*x39 + x41, x35*x7 + x51, x35*x9 + x57, x10*x35 + x60, x62, x64, x67, x29*x70 + x38, x28 + x34*x72 + 2*x36*x71, x39*x72 + x74, x7*x72 + x78, x72*x9 + x79, x10*x72 + x82, x83, x84, x85, x29*x88 + x41, x74 + x76*x88, x28 + 2*x39*x89 + x39*x90, x7*x90 + x95, x9*x90 + x96, x10*x90 + x97, x98, x99, x100, x101*x29 + x51, x101*x76 + x78, x101*x93 + x95, x102*x103 + x103*x104 + x105*x7 + x106*x109 + 2*x110*x7 + x113, x105*x9 + x114*x4 + x118, x1*x114 + x10*x105 + x120, x114*x24 + x121, x114*x19 + x122, x114*x2 + x123, x124*x29 + x57, x124*x76 + x79, x124*x93 + x96, x106*x127 + x118 + x125*x7, x113 + x125*x9 + x128*x129 + x129*x130 + x131*x4 + 2*x132*x4, x1*x131 + x10*x125 + x136, x131*x24 + x137, x131*x19 + x138, x131*x2 + x139, x140*x29 + x60, x140*x76 + x82, x140*x93 + x97, x106*x143 + x120 + x141*x7, x136 + x141*x9 + x144*x4, 2*x1*x135 + x1*x144 + x10*x141 + x113 + x133*x145 + x145*x146, x144*x24 + x148, x144*x19 + x149, x144*x2 + x150, x62, x83, x98, x106*x151 + x121, x137 + x152*x4, x1*x152 + x148, x112 + x152*x24 + 2*x153*x61, x152*x19 + x155, x152*x2 + x156, x64, x84, x99, x106*x157 + x122, x138 + x158*x4, x1*x158 + x149, x155 + x158*x24, x112 + x158*x19 + 2*x159*x63, x158*x2 + x161, x67, x85, x100, x106*x162 + x123, x139 + x163*x4, x1*x163 + x150, x156 + x163*x24, x161 + x163*x19, x112 + 2*x160*x66 + x163*x2], dtype=np.float64)


def q_oop(m0, m1, m2, n0, n1, n2, o0, o1, o2, p0, p1, p2):
    """OutOfPlane"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -p0
    x1 = m0 + x0
    x2 = -p2
    x3 = n2 + x2
    x4 = -p1
    x5 = m1 + x4
    x6 = m2 + x2
    x7 = 1/mpmath.sqrt(x1**2 + x5**2 + x6**2)
    x8 = n0 + x0
    x9 = n1 + x4
    x10 = 1/mpmath.sqrt(x3**2 + x8**2 + x9**2)
    x11 = x10*x7
    x12 = x11*x5
    x13 = o1 + x4
    x14 = o0 + x0
    x15 = o2 + x2
    x16 = 1/mpmath.sqrt(x13**2 + x14**2 + x15**2)
    x17 = x16*x7
    x18 = x13*x17
    x19 = x10*x16
    x20 = x19*x9
    x21 = x17*x5
    x22 = x11*x9
    x23 = x13*x19
    x24 = x12*x3 + x15*x20 - x15*x21 + x18*x6 - x22*x6 - x23*x3
    x25 = -x1*x18 + x1*x22 - x12*x8 - x14*x20 + x14*x21 + x23*x8
    x26 = -x1*x11*x3 + x1*x15*x16*x7 + x10*x14*x16*x3 + x10*x6*x7*x8 - x14*x17*x6 - x15*x19*x8
    x27 = x7/mpmath.sqrt(x24**2 + x25**2 + x26**2)

    return x1*x24*x27 + x25*x27*x6 + x26*x27*x5


def dq_oop(m0, m1, m2, n0, n1, n2, o0, o1, o2, p0, p1, p2):
    """OutOfPlane, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -p0
    x1 = n0 + x0
    x2 = x1**2
    x3 = -p1
    x4 = n1 + x3
    x5 = x4**2
    x6 = -p2
    x7 = n2 + x6
    x8 = x7**2
    x9 = x2 + x5 + x8
    x10 = 1/mpmath.sqrt(x9)
    x11 = x10*x7
    x12 = m1 + x3
    x13 = m0 + x0
    x14 = x13**2
    x15 = x12**2
    x16 = m2 + x6
    x17 = x16**2
    x18 = x14 + x15 + x17
    x19 = x18**(mpmath.mpf(-3)/mpmath.mpf(2))
    x20 = -x13
    x21 = x19*x20
    x22 = x12*x21
    x23 = x11*x22
    x24 = o0 + x0
    x25 = x24**2
    x26 = o1 + x3
    x27 = x26**2
    x28 = o2 + x6
    x29 = x28**2
    x30 = x25 + x27 + x29
    x31 = 1/mpmath.sqrt(x30)
    x32 = x26*x31
    x33 = x16*x21
    x34 = x32*x33
    x35 = x28*x31
    x36 = x22*x35
    x37 = x10*x4
    x38 = x33*x37
    x39 = 1/mpmath.sqrt(x18)
    x40 = x10*x39
    x41 = x4*x40
    x42 = x31*x39
    x43 = x24*x42
    x44 = x10*x31
    x45 = x26*x44
    x46 = x26*x42
    x47 = x1*x40
    x48 = x24*x44
    x49 = x1*x45 + x12*x43 - x12*x47 + x13*x41 - x13*x46 - x4*x48
    x50 = x40*x7
    x51 = x28*x44
    x52 = x1*x10*x16*x39 - x1*x51 + x10*x24*x31*x7 + x13*x28*x31*x39 - x13*x50 - x16*x43
    x53 = x28*x42
    x54 = x12*x50 - x12*x53 - x16*x41 + x16*x46 + x4*x51 - x45*x7
    x55 = x49**2 + x52**2 + x54**2
    x56 = 1/mpmath.sqrt(x55)
    x57 = x39*x56
    x58 = x13*x57
    x59 = x54*x57
    x60 = x54*x56
    x61 = x13*x21
    x62 = x52*x56
    x63 = x49*x56
    x64 = x11*x61
    x65 = x24*x31
    x66 = x33*x65
    x67 = x50 - x53
    x68 = x12*x57
    x69 = x37*x61
    x70 = x22*x65
    x71 = x1*x10
    x72 = x22*x71
    x73 = x32*x61
    x74 = x41 - x46
    x75 = x16*x57
    x76 = x55**(mpmath.mpf(-3)/mpmath.mpf(2))
    x77 = (mpmath.mpf(1)/mpmath.mpf(2))*x54
    x78 = 2*x46
    x79 = 2*x41
    x80 = -x78 + x79
    x81 = (mpmath.mpf(1)/mpmath.mpf(2))*x49
    x82 = 2*x53
    x83 = 2*x50
    x84 = -x82 + x83
    x85 = (mpmath.mpf(1)/mpmath.mpf(2))*x52
    x86 = x76*(-x77*(2*x23 + 2*x34 - 2*x36 - 2*x38) - x81*(2*x69 + 2*x70 - 2*x72 - 2*x73 + x80) - x85*(2*x1*x10*x16*x19*x20 + 2*x13*x19*x20*x28*x31 - 2*x64 - 2*x66 - x84))
    x87 = x13*x39
    x88 = x54*x87
    x89 = x12*x39
    x90 = x52*x89
    x91 = x16*x39
    x92 = x49*x91
    x93 = -x12
    x94 = x19*x93
    x95 = x13*x94
    x96 = x11*x95
    x97 = x16*x94
    x98 = x65*x97
    x99 = x52*x57
    x100 = x12*x94
    x101 = x100*x11
    x102 = x32*x97
    x103 = x37*x97
    x104 = x100*x35
    x105 = x37*x95
    x106 = x100*x65
    x107 = x100*x71
    x108 = x32*x95
    x109 = x43 - x47
    x110 = 2*x47
    x111 = 2*x43
    x112 = -x110 + x111
    x113 = x76*(-x77*(2*x101 + 2*x102 - 2*x103 - 2*x104 + x84) - x81*(2*x105 + 2*x106 - 2*x107 - 2*x108 + x112) - x85*(2*x1*x10*x16*x19*x93 + 2*x13*x19*x28*x31*x93 - 2*x96 - 2*x98))
    x114 = -x16
    x115 = x114*x19
    x116 = x115*x13
    x117 = x116*x37
    x118 = x115*x12
    x119 = x118*x65
    x120 = x116*x32
    x121 = x118*x71
    x122 = x49*x57
    x123 = x115*x16
    x124 = x11*x118
    x125 = x123*x32
    x126 = x123*x37
    x127 = x118*x35
    x128 = -x41 + x46
    x129 = x11*x116
    x130 = x123*x65
    x131 = x78 - x79
    x132 = x76*(-x77*(2*x124 + 2*x125 - 2*x126 - 2*x127 + x131) - x81*(2*x117 + 2*x119 - 2*x120 - 2*x121) - x85*(2*x1*x10*x114*x16*x19 - x112 + 2*x114*x13*x19*x28*x31 - 2*x129 - 2*x130))
    x133 = x9**(mpmath.mpf(-3)/mpmath.mpf(2))
    x134 = -x1
    x135 = x133*x134
    x136 = x135*x7
    x137 = x136*x89
    x138 = x135*x4
    x139 = x138*x35
    x140 = x138*x91
    x141 = x136*x32
    x142 = x136*x87
    x143 = x1*x135
    x144 = x143*x35
    x145 = x16*x40
    x146 = -x145 + x51
    x147 = x138*x87
    x148 = x143*x32
    x149 = x143*x89
    x150 = x138*x65
    x151 = x12*x40
    x152 = -x151 + x45
    x153 = 2*x151
    x154 = 2*x45
    x155 = -x153 + x154
    x156 = 2*x145
    x157 = 2*x51
    x158 = -x156 + x157
    x159 = x76*(-x77*(2*x137 + 2*x139 - 2*x140 - 2*x141) - x81*(2*x147 + 2*x148 - 2*x149 - 2*x150 + x155) - x85*(2*x1*x133*x134*x16*x39 + 2*x133*x134*x24*x31*x7 - 2*x142 - 2*x144 - x158))
    x160 = -x4
    x161 = x133*x160
    x162 = x161*x7
    x163 = x162*x87
    x164 = x1*x161
    x165 = x164*x35
    x166 = x162*x89
    x167 = x161*x4
    x168 = x167*x35
    x169 = x167*x91
    x170 = x162*x32
    x171 = x167*x87
    x172 = x164*x32
    x173 = x164*x89
    x174 = x167*x65
    x175 = x13*x40
    x176 = x175 - x48
    x177 = 2*x48
    x178 = 2*x175
    x179 = -x177 + x178
    x180 = x76*(-x77*(x158 + 2*x166 + 2*x168 - 2*x169 - 2*x170) - x81*(2*x171 + 2*x172 - 2*x173 - 2*x174 + x179) - x85*(2*x1*x133*x16*x160*x39 + 2*x133*x160*x24*x31*x7 - 2*x163 - 2*x165))
    x181 = -x7
    x182 = x133*x181
    x183 = x182*x4
    x184 = x183*x87
    x185 = x1*x182
    x186 = x185*x32
    x187 = x185*x89
    x188 = x183*x65
    x189 = x182*x7
    x190 = x189*x89
    x191 = x183*x35
    x192 = x183*x91
    x193 = x189*x32
    x194 = x151 - x45
    x195 = x189*x87
    x196 = x185*x35
    x197 = x153 - x154
    x198 = x76*(-x77*(2*x190 + 2*x191 - 2*x192 - 2*x193 + x197) - x81*(2*x184 + 2*x186 - 2*x187 - 2*x188) - x85*(2*x1*x133*x16*x181*x39 + 2*x133*x181*x24*x31*x7 - x179 - 2*x195 - 2*x196))
    x199 = x30**(mpmath.mpf(-3)/mpmath.mpf(2))
    x200 = -x24
    x201 = x199*x200
    x202 = x201*x28
    x203 = x202*x89
    x204 = x201*x26
    x205 = x11*x204
    x206 = x202*x87
    x207 = x201*x24
    x208 = x11*x207
    x209 = x207*x91
    x210 = x202*x71
    x211 = x44*x7
    x212 = x16*x42
    x213 = x211 - x212
    x214 = x204*x87
    x215 = x207*x37
    x216 = x4*x44
    x217 = x12*x42
    x218 = x216 - x217
    x219 = 2*x217
    x220 = 2*x216
    x221 = -x219 + x220
    x222 = 2*x211 - 2*x212
    x223 = x76*(-x77*(2*x10*x199*x200*x28*x4 + 2*x16*x199*x200*x26*x39 - 2*x203 - 2*x205) - x81*(2*x1*x10*x199*x200*x26 + 2*x12*x199*x200*x24*x39 - 2*x214 - 2*x215 - x221) - x85*(2*x206 + 2*x208 - 2*x209 - 2*x210 + x222))
    x224 = -x26
    x225 = x199*x224
    x226 = x225*x28
    x227 = x226*x87
    x228 = x225*x24
    x229 = x11*x228
    x230 = x228*x91
    x231 = x226*x71
    x232 = x226*x89
    x233 = x225*x26
    x234 = x11*x233
    x235 = x233*x87
    x236 = x228*x37
    x237 = x13*x42
    x238 = x1*x44
    x239 = x237 - x238
    x240 = 2*x237 - 2*x238
    x241 = x76*(-x77*(2*x10*x199*x224*x28*x4 + 2*x16*x199*x224*x26*x39 - x222 - 2*x232 - 2*x234) - x81*(2*x1*x10*x199*x224*x26 + 2*x12*x199*x224*x24*x39 - 2*x235 - 2*x236 - x240) - x85*(2*x227 + 2*x229 - 2*x230 - 2*x231))
    x242 = -x28
    x243 = x199*x242
    x244 = x243*x26
    x245 = x244*x87
    x246 = x24*x243
    x247 = x246*x37
    x248 = x243*x28
    x249 = x248*x89
    x250 = x11*x244
    x251 = -x216 + x217
    x252 = x248*x87
    x253 = x11*x246
    x254 = x246*x91
    x255 = x248*x71
    x256 = x219 - x220
    x257 = x76*(-x77*(2*x10*x199*x242*x28*x4 + 2*x16*x199*x242*x26*x39 - 2*x249 - 2*x250 - x256) - x81*(2*x1*x10*x199*x242*x26 + 2*x12*x199*x24*x242*x39 - 2*x245 - 2*x247) - x85*(x240 + 2*x252 + 2*x253 - 2*x254 - 2*x255))
    x258 = x14*x19
    x259 = x13*x19
    x260 = x12*x259
    x261 = x16*x259
    x262 = x261*x32
    x263 = x1*x133
    x264 = x263*x7
    x265 = x264*x89
    x266 = x199*x24
    x267 = x266*x28
    x268 = x267*x37
    x269 = x261*x37
    x270 = x267*x89
    x271 = x264*x32
    x272 = x11*x260
    x273 = x26*x266
    x274 = x273*x91
    x275 = x263*x4
    x276 = x275*x35
    x277 = x260*x35
    x278 = x275*x91
    x279 = x11*x273
    x280 = x272 + x274 + x276 - x277 - x278 - x279
    x281 = x11*x258
    x282 = x133*x2
    x283 = x282*x35
    x284 = x199*x25
    x285 = x284*x91
    x286 = x261*x65
    x287 = x264*x87
    x288 = x267*x71
    x289 = x145 + x213 - x50 - x51 + x53
    x290 = x258*x37
    x291 = x282*x32
    x292 = x284*x89
    x293 = x258*x32
    x294 = x282*x89
    x295 = x284*x37
    x296 = x260*x65
    x297 = x275*x87
    x298 = x273*x71
    x299 = x260*x71
    x300 = x273*x87
    x301 = x275*x65
    x302 = 2*x269
    x303 = 2*x270
    x304 = 2*x271
    x305 = 2*x262
    x306 = 2*x265
    x307 = 2*x268
    x308 = 2*x272 + 2*x274 + 2*x276 - 2*x277 - 2*x278 - 2*x279
    x309 = x156 - x157 + x222 + x82 - x83
    x310 = x76*(-x77*(-x302 - x303 - x304 + x305 + x306 + x307 + x308) - x81*(x131 + x197 + x221 + 2*x290 + 2*x291 + 2*x292 - 2*x293 - 2*x294 - 2*x295 + 2*x296 + 2*x297 + 2*x298 - 2*x299 - 2*x300 - 2*x301) - x85*(2*x1*x10*x13*x16*x19 + 2*x1*x133*x24*x31*x7 + 2*x10*x199*x25*x7 + 2*x13*x199*x24*x28*x39 + 2*x133*x16*x2*x39 + 2*x14*x19*x28*x31 - 2*x281 - 2*x283 - 2*x285 - 2*x286 - 2*x287 - 2*x288 - x309))
    x311 = x15*x19
    x312 = x12*x16*x19
    x313 = x312*x65
    x314 = x133*x4*x7
    x315 = x314*x87
    x316 = x199*x26*x28
    x317 = x316*x71
    x318 = x312*x71
    x319 = x316*x87
    x320 = x314*x65
    x321 = x313 + x315 + x317 - x318 - x319 - x320
    x322 = x11*x311
    x323 = x133*x5
    x324 = x323*x35
    x325 = x199*x27
    x326 = x325*x91
    x327 = x311*x35
    x328 = x323*x91
    x329 = x11*x325
    x330 = x312*x32
    x331 = x314*x89
    x332 = x316*x37
    x333 = x312*x37
    x334 = x316*x89
    x335 = x314*x32
    x336 = x311*x65
    x337 = x323*x87
    x338 = x325*x71
    x339 = x311*x71
    x340 = x323*x65
    x341 = x325*x87
    x342 = x260*x37
    x343 = x273*x89
    x344 = x275*x32
    x345 = x260*x32
    x346 = x275*x89
    x347 = x273*x37
    x348 = -x175 + x239 - x43 + x47 + x48
    x349 = 2*x313 + 2*x315 + 2*x317 - 2*x318 - 2*x319 - 2*x320
    x350 = x110 - x111 + x177 - x178 + x240
    x351 = x76*(-x77*(x309 + 2*x322 + 2*x324 + 2*x326 - 2*x327 - 2*x328 - 2*x329 + 2*x330 + 2*x331 + 2*x332 - 2*x333 - 2*x334 - 2*x335) - x81*(2*x336 + 2*x337 + 2*x338 - 2*x339 - 2*x340 - 2*x341 + 2*x342 + 2*x343 + 2*x344 - 2*x345 - 2*x346 - 2*x347 + x350) - x85*(-x308 - x349))
    x352 = x17*x19
    x353 = x32*x352
    x354 = x133*x8
    x355 = x354*x89
    x356 = x199*x29
    x357 = x356*x37
    x358 = x352*x37
    x359 = x32*x354
    x360 = x356*x89
    x361 = x11*x312
    x362 = x316*x91
    x363 = x314*x35
    x364 = x312*x35
    x365 = x314*x91
    x366 = x11*x316
    x367 = x352*x65
    x368 = x354*x87
    x369 = x356*x71
    x370 = x11*x261
    x371 = x267*x91
    x372 = x264*x35
    x373 = x76*(-x77*(x155 + x256 + 2*x353 + 2*x355 + 2*x357 - 2*x358 - 2*x359 - 2*x360 + 2*x361 + 2*x362 + 2*x363 - 2*x364 - 2*x365 - 2*x366 + x80) - x81*(x302 + x303 + x304 - x305 - x306 - x307 + x349) - x85*(2*x1*x10*x17*x19 + 2*x1*x133*x16*x39*x7 + 2*x10*x199*x24*x28*x7 + 2*x13*x16*x19*x28*x31 + 2*x13*x199*x29*x39 + 2*x133*x24*x31*x8 - x350 - 2*x367 - 2*x368 - 2*x369 - 2*x370 - 2*x371 - 2*x372))

    return np.array([x22*x62 + x33*x63 + x58*(x23 + x34 - x36 - x38) + x59 + x60*x61 + x68*(x1*x10*x16*x19*x20 + x13*x19*x20*x28*x31 - x64 - x66 - x67) + x75*(x69 + x70 - x72 - x73 + x74) + x86*x88 + x86*x90 + x86*x92, x100*x62 + x113*x88 + x113*x90 + x113*x92 + x58*(x101 + x102 - x103 - x104 + x67) + x60*x95 + x63*x97 + x68*(x1*x10*x16*x19*x93 + x13*x19*x28*x31*x93 - x96 - x98) + x75*(x105 + x106 - x107 - x108 + x109) + x99, x116*x60 + x118*x62 + x122 + x123*x63 + x132*x88 + x132*x90 + x132*x92 + x58*(x124 + x125 - x126 - x127 + x128) + x68*(x1*x10*x114*x16*x19 - x109 + x114*x13*x19*x28*x31 - x129 - x130) + x75*(x117 + x119 - x120 - x121), x159*x88 + x159*x90 + x159*x92 + x58*(x137 + x139 - x140 - x141) + x68*(x1*x133*x134*x16*x39 + x133*x134*x24*x31*x7 - x142 - x144 - x146) + x75*(x147 + x148 - x149 - x150 + x152), x180*x88 + x180*x90 + x180*x92 + x58*(x146 + x166 + x168 - x169 - x170) + x68*(x1*x133*x16*x160*x39 + x133*x160*x24*x31*x7 - x163 - x165) + x75*(x171 + x172 - x173 - x174 + x176), x198*x88 + x198*x90 + x198*x92 + x58*(x190 + x191 - x192 - x193 + x194) + x68*(x1*x133*x16*x181*x39 + x133*x181*x24*x31*x7 - x176 - x195 - x196) + x75*(x184 + x186 - x187 - x188), x223*x88 + x223*x90 + x223*x92 + x58*(x10*x199*x200*x28*x4 + x16*x199*x200*x26*x39 - x203 - x205) + x68*(x206 + x208 - x209 - x210 + x213) + x75*(x1*x10*x199*x200*x26 + x12*x199*x200*x24*x39 - x214 - x215 - x218), x241*x88 + x241*x90 + x241*x92 + x58*(x10*x199*x224*x28*x4 + x16*x199*x224*x26*x39 - x213 - x232 - x234) + x68*(x227 + x229 - x230 - x231) + x75*(x1*x10*x199*x224*x26 + x12*x199*x224*x24*x39 - x235 - x236 - x239), x257*x88 + x257*x90 + x257*x92 + x58*(x10*x199*x242*x28*x4 + x16*x199*x242*x26*x39 - x249 - x250 - x251) + x68*(x239 + x252 + x253 - x254 - x255) + x75*(x1*x10*x199*x242*x26 + x12*x199*x24*x242*x39 - x245 - x247), x258*x60 + x260*x62 + x261*x63 + x310*x88 + x310*x90 + x310*x92 + x58*(x262 + x265 + x268 - x269 - x270 - x271 + x280) - x59 + x68*(x1*x10*x13*x16*x19 + x1*x133*x24*x31*x7 + x10*x199*x25*x7 + x13*x199*x24*x28*x39 + x133*x16*x2*x39 + x14*x19*x28*x31 - x281 - x283 - x285 - x286 - x287 - x288 - x289) + x75*(x128 + x194 + x218 + x290 + x291 + x292 - x293 - x294 - x295 + x296 + x297 + x298 - x299 - x300 - x301), x260*x60 + x311*x62 + x312*x63 + x351*x88 + x351*x90 + x351*x92 + x58*(x289 + x322 + x324 + x326 - x327 - x328 - x329 + x330 + x331 + x332 - x333 - x334 - x335) + x68*(-x280 - x321) + x75*(x336 + x337 + x338 - x339 - x340 - x341 + x342 + x343 + x344 - x345 - x346 - x347 + x348) - x99, -x122 + x261*x60 + x312*x62 + x352*x63 + x373*x88 + x373*x90 + x373*x92 + x58*(x152 + x251 + x353 + x355 + x357 - x358 - x359 - x360 + x361 + x362 + x363 - x364 - x365 - x366 + x74) + x68*(x1*x10*x17*x19 + x1*x133*x16*x39*x7 + x10*x199*x24*x28*x7 + x13*x16*x19*x28*x31 + x13*x199*x29*x39 + x133*x24*x31*x8 - x348 - x367 - x368 - x369 - x370 - x371 - x372) + x75*(-x262 - x265 - x268 + x269 + x270 + x271 + x321)], dtype=np.float64)


def d2q_oop(m0, m1, m2, n0, n1, n2, o0, o1, o2, p0, p1, p2):
    """OutOfPlane, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -p0
    x1 = m0 + x0
    x2 = -x1
    x3 = -p1
    x4 = m1 + x3
    x5 = -p2
    x6 = n2 + x5
    x7 = n0 + x0
    x8 = x7**2
    x9 = n1 + x3
    x10 = x9**2
    x11 = x6**2
    x12 = x10 + x11 + x8
    x13 = 1/mpmath.sqrt(x12)
    x14 = x1**2
    x15 = x4**2
    x16 = m2 + x5
    x17 = x16**2
    x18 = x14 + x15 + x17
    x19 = x18**(mpmath.mpf(-3)/mpmath.mpf(2))
    x20 = x13*x19
    x21 = x20*x6
    x22 = x21*x4
    x23 = x2*x22
    x24 = o1 + x3
    x25 = o0 + x0
    x26 = x25**2
    x27 = x24**2
    x28 = o2 + x5
    x29 = x28**2
    x30 = x26 + x27 + x29
    x31 = 1/mpmath.sqrt(x30)
    x32 = x19*x31
    x33 = x16*x32
    x34 = x24*x33
    x35 = x2*x34
    x36 = x28*x32
    x37 = x36*x4
    x38 = x2*x37
    x39 = x16*x20
    x40 = x39*x9
    x41 = x2*x40
    x42 = x23 + x35 - x38 - x41
    x43 = 1/mpmath.sqrt(x18)
    x44 = x13*x43
    x45 = x44*x9
    x46 = x1*x45
    x47 = x31*x43
    x48 = x25*x47
    x49 = x4*x48
    x50 = x13*x31
    x51 = x24*x50
    x52 = x51*x7
    x53 = x24*x47
    x54 = x44*x7
    x55 = x25*x50
    x56 = -x1*x53 - x4*x54 + x46 + x49 + x52 - x55*x9
    x57 = x44*x6
    x58 = x1*x57
    x59 = x16*x48
    x60 = x28*x50
    x61 = x60*x7
    x62 = x1*x28*x31*x43 + x13*x16*x43*x7 + x13*x25*x31*x6 - x58 - x59 - x61
    x63 = x4*x57
    x64 = x16*x53
    x65 = x60*x9
    x66 = x28*x47
    x67 = -x16*x45 - x4*x66 - x51*x6 + x63 + x64 + x65
    x68 = x56**2 + x62**2 + x67**2
    x69 = 1/mpmath.sqrt(x68)
    x70 = x43*x69
    x71 = x42*x70
    x72 = x18**(mpmath.mpf(-5)/mpmath.mpf(2))
    x73 = -3*p0
    x74 = 3*m0 + x73
    x75 = -x74
    x76 = x72*x75
    x77 = x2*x76
    x78 = x13*x6
    x79 = x4*x78
    x80 = x24*x31
    x81 = x16*x77
    x82 = x13*x9
    x83 = x28*x31
    x84 = -x34 + x40
    x85 = -x22 + x37
    x86 = x84 + x85
    x87 = -x4*x77*x83 + x77*x79 + x80*x81 - x81*x82 + x86
    x88 = x1*x70
    x89 = x1*x77
    x90 = x25*x31
    x91 = x39*x7
    x92 = x25*x33
    x93 = x91 - x92
    x94 = x1*x36
    x95 = x1*x21
    x96 = x94 - x95
    x97 = x93 + x96
    x98 = x2*x36
    x99 = 2*x98
    x100 = x2*x21
    x101 = 2*x100
    x102 = x101 - x99
    x103 = -x1*x2*x28*x31*x72*x75 + x102 - x13*x16*x2*x7*x72*x75 + x78*x89 + x81*x90 + x97
    x104 = x4*x70
    x105 = x4*x77
    x106 = x13*x7
    x107 = x24*x32
    x108 = x1*x107
    x109 = x20*x9
    x110 = x1*x109
    x111 = x108 - x110
    x112 = x20*x7
    x113 = x112*x4
    x114 = x25*x32
    x115 = x114*x4
    x116 = x113 - x115
    x117 = x111 + x116
    x118 = x107*x2
    x119 = 2*x118
    x120 = x109*x2
    x121 = 2*x120
    x122 = -x119 + x121
    x123 = -x105*x106 + x105*x90 + x117 + x122 - x80*x89 + x82*x89
    x124 = x16*x70
    x125 = x19*x69
    x126 = x125*x67
    x127 = x126*x2
    x128 = x67*(2*x23 + 2*x35 - 2*x38 - 2*x41)
    x129 = x113*x2
    x130 = x108*x2
    x131 = x110*x2
    x132 = x115*x2
    x133 = 2*x53
    x134 = 2*x45
    x135 = -x133 + x134
    x136 = x56*(-2*x129 - 2*x130 + 2*x131 + 2*x132 + x135)
    x137 = x2*x95
    x138 = x2*x92
    x139 = 2*x66
    x140 = 2*x57
    x141 = -x139 + x140
    x142 = x62*(2*x1*x19*x2*x28*x31 + 2*x13*x16*x19*x2*x7 - 2*x137 - 2*x138 - x141)
    x143 = -mpmath.mpf(1)/mpmath.mpf(2)*x128 - mpmath.mpf(1)/mpmath.mpf(2)*x136 - mpmath.mpf(1)/mpmath.mpf(2)*x142
    x144 = x68**(mpmath.mpf(-3)/mpmath.mpf(2))
    x145 = x144*x43
    x146 = x145*x67
    x147 = x143*x146
    x148 = -x42
    x149 = x45 - x53
    x150 = -x129 - x130 + x131 + x132 + x149
    x151 = -x150
    x152 = x2*x91
    x153 = x2*x94
    x154 = x57 - x66
    x155 = x137 + x138 - x152 - x153 + x154
    x156 = -x155
    x157 = x103*x62 - x123*x56 + x148*x42 + x150*x151 + x155*x156 - x67*x87
    x158 = x1*x67
    x159 = x145*x158
    x160 = x145*x62
    x161 = x160*x4
    x162 = x145*x56
    x163 = x16*x162
    x164 = x1*x125
    x165 = x164*x2
    x166 = x125*x4
    x167 = x166*x2
    x168 = x125*x16
    x169 = x168*x2
    x170 = x1*x42
    x171 = x143*x145
    x172 = 2*x171
    x173 = x156*x4
    x174 = x150*x16
    x175 = x158*x69
    x176 = x62*x69
    x177 = x56*x69
    x178 = x68**(mpmath.mpf(-5)/mpmath.mpf(2))
    x179 = x178*(-mpmath.mpf(3)/mpmath.mpf(2)*x128 - mpmath.mpf(3)/mpmath.mpf(2)*x136 - mpmath.mpf(3)/mpmath.mpf(2)*x142)
    x180 = x143*x179
    x181 = x158*x43
    x182 = x4*x43
    x183 = x182*x62
    x184 = x16*x43
    x185 = x184*x56
    x186 = x19*x2
    x187 = x158*x186
    x188 = x143*x144
    x189 = 2*x188
    x190 = x186*x4
    x191 = x190*x62
    x192 = x16*x186
    x193 = x192*x56
    x194 = x125*x158
    x195 = x125*x62
    x196 = x195*x4
    x197 = x125*x56
    x198 = x16*x197
    x199 = -x194 - x196 - x198
    x200 = -x4
    x201 = x200*x76
    x202 = x16*x201
    x203 = x100 - x98
    x204 = -x201*x4*x83 + x201*x79 + x202*x80 - x202*x82 + x203
    x205 = x1*x201
    x206 = x200*x21
    x207 = x200*x36
    x208 = x206 - x207
    x209 = -x1*x200*x28*x31*x72*x75 - x13*x16*x200*x7*x72*x75 + x202*x90 + x205*x78 + x208
    x210 = x201*x4
    x211 = x114*x2
    x212 = x112*x2
    x213 = x211 - x212
    x214 = x109*x200
    x215 = x107*x200
    x216 = x214 - x215
    x217 = x213 + x216
    x218 = -x106*x210 - x205*x80 + x205*x82 + x210*x90 + x217
    x219 = x200*x22
    x220 = x200*x34
    x221 = x200*x40
    x222 = x200*x37
    x223 = x154 + x219 + x220 - x221 - x222
    x224 = -x223
    x225 = x200*x95
    x226 = x200*x92
    x227 = -x1*x19*x200*x28*x31 - x13*x16*x19*x200*x7 + x225 + x226
    x228 = x110*x200
    x229 = x115*x200
    x230 = x113*x200
    x231 = x108*x200
    x232 = x48 - x54
    x233 = x228 + x229 - x230 - x231 + x232
    x234 = -x233
    x235 = x150*x234 + x156*x227 - x204*x67 + x209*x62 - x218*x56 + x224*x42
    x236 = 2*x1*x19*x200*x28*x31 + 2*x13*x16*x19*x200*x7 - 2*x225 - 2*x226
    x237 = (mpmath.mpf(1)/mpmath.mpf(2))*x62
    x238 = 2*x54
    x239 = 2*x48
    x240 = -x238 + x239
    x241 = 2*x228 + 2*x229 - 2*x230 - 2*x231 + x240
    x242 = (mpmath.mpf(1)/mpmath.mpf(2))*x56
    x243 = x141 + 2*x219 + 2*x220 - 2*x221 - 2*x222
    x244 = (mpmath.mpf(1)/mpmath.mpf(2))*x67
    x245 = -x236*x237 - x241*x242 - x243*x244
    x246 = x179*x245
    x247 = x223*x70
    x248 = x156*x70
    x249 = x195*x2
    x250 = x126*x200
    x251 = x146*x245
    x252 = x171*x62
    x253 = x164*x42
    x254 = -x227
    x255 = x156*x166
    x256 = x150*x168
    x257 = x145*x245
    x258 = x1*x171
    x259 = x171*x4
    x260 = x16*x171
    x261 = x144*x245
    x262 = x19*x200
    x263 = x158*x188
    x264 = x262*x4
    x265 = x188*x62
    x266 = x16*x262
    x267 = x188*x56
    x268 = x165*x223 + x167*x254 + x169*x233 + x170*x257 + x173*x257 + x174*x257 + x187*x261 + x191*x261 + x193*x261 + x200*x253 + x200*x255 + x200*x256 + x223*x258 + x233*x260 + x247 + x248 + x249 + x250 + x251 + x252 + x254*x259 + x262*x263 + x264*x265 + x266*x267
    x269 = -x16
    x270 = x269*x76
    x271 = x16*x270
    x272 = x118 - x120
    x273 = -x270*x4*x83 + x270*x79 + x271*x80 - x271*x82 + x272
    x274 = x1*x270
    x275 = x21*x269
    x276 = x269*x36
    x277 = x275 - x276
    x278 = x213 + x277
    x279 = -x1*x269*x28*x31*x72*x75 - x13*x16*x269*x7*x72*x75 + x271*x90 + x274*x78 + x278
    x280 = x270*x4
    x281 = x109*x269
    x282 = x107*x269
    x283 = x281 - x282
    x284 = -x106*x280 - x274*x80 + x274*x82 + x280*x90 + x283
    x285 = x22*x269
    x286 = x269*x34
    x287 = x269*x40
    x288 = x269*x37
    x289 = -x45 + x53
    x290 = x285 + x286 - x287 - x288 + x289
    x291 = -x290
    x292 = x110*x269
    x293 = x115*x269
    x294 = x108*x269
    x295 = x113*x269
    x296 = x292 + x293 - x294 - x295
    x297 = -x296
    x298 = x269*x95
    x299 = x269*x92
    x300 = -x1*x19*x269*x28*x31 - x13*x16*x19*x269*x7 + x232 + x298 + x299
    x301 = x150*x297 + x156*x300 - x273*x67 + x279*x62 - x284*x56 + x291*x42
    x302 = 2*x292 + 2*x293 - 2*x294 - 2*x295
    x303 = 2*x1*x19*x269*x28*x31 + 2*x13*x16*x19*x269*x7 - x240 - 2*x298 - 2*x299
    x304 = x133 - x134
    x305 = 2*x285 + 2*x286 - 2*x287 - 2*x288 + x304
    x306 = -x237*x303 - x242*x302 - x244*x305
    x307 = x179*x306
    x308 = x150*x70
    x309 = x290*x70
    x310 = x197*x2
    x311 = x126*x269
    x312 = x146*x306
    x313 = x171*x56
    x314 = -x300
    x315 = x145*x306
    x316 = x144*x306
    x317 = x19*x269
    x318 = x317*x4
    x319 = x16*x317
    x320 = x165*x290 + x167*x314 + x169*x296 + x170*x315 + x173*x315 + x174*x315 + x187*x316 + x191*x316 + x193*x316 + x253*x269 + x255*x269 + x256*x269 + x258*x290 + x259*x314 + x260*x296 + x263*x317 + x265*x318 + x267*x319 + x308 + x309 + x310 + x311 + x312 + x313
    x321 = -x7
    x322 = x12**(mpmath.mpf(-3)/mpmath.mpf(2))
    x323 = x322*x43
    x324 = x321*x323
    x325 = x324*x6
    x326 = x325*x4
    x327 = x31*x322
    x328 = x28*x327
    x329 = x328*x9
    x330 = x321*x329
    x331 = x324*x9
    x332 = x16*x331
    x333 = x327*x6
    x334 = x24*x333
    x335 = x321*x334
    x336 = x326 + x330 - x332 - x335
    x337 = -x336
    x338 = x1*x331
    x339 = x24*x327
    x340 = x339*x7
    x341 = x321*x340
    x342 = x324*x7
    x343 = x342*x4
    x344 = x25*x327
    x345 = x344*x9
    x346 = x321*x345
    x347 = x4*x44
    x348 = -x347 + x51
    x349 = x338 + x341 - x343 - x346 + x348
    x350 = -x349
    x351 = x1*x325
    x352 = x328*x7
    x353 = x321*x352
    x354 = x16*x44
    x355 = -x354 + x60
    x356 = -x16*x321*x322*x43*x7 - x25*x31*x321*x322*x6 + x351 + x353 + x355
    x357 = x321*x322
    x358 = x357*x6
    x359 = x357*x9
    x360 = x190*x358 - x192*x359
    x361 = x2*x20
    x362 = x361*x4
    x363 = -x362
    x364 = x1*x186
    x365 = x357*x7
    x366 = -x190*x365 + x331 + x359*x364 + x363
    x367 = x2*x39
    x368 = -x367
    x369 = -x16*x19*x2*x321*x322*x7 + x325 + x358*x364 + x368
    x370 = -x360*x67 - x366*x56 + x369*x62
    x371 = x150*x350 + x156*x356 + x337*x42 + x370
    x372 = 2*x326 + 2*x330 - 2*x332 - 2*x335
    x373 = 2*x347
    x374 = 2*x51
    x375 = -x373 + x374
    x376 = 2*x338 + 2*x341 - 2*x343 - 2*x346 + x375
    x377 = 2*x354
    x378 = 2*x60
    x379 = -x377 + x378
    x380 = 2*x16*x321*x322*x43*x7 + 2*x25*x31*x321*x322*x6 - 2*x351 - 2*x353 - x379
    x381 = -x237*x380 - x242*x376 - x244*x372
    x382 = x179*x381
    x383 = x336*x70
    x384 = x146*x381
    x385 = -x356
    x386 = x145*x381
    x387 = x144*x381
    x388 = -x104*x369 + x124*x366 + x165*x336 + x167*x385 + x169*x349 + x170*x386 + x173*x386 + x174*x386 + x187*x387 + x191*x387 + x193*x387 + x258*x336 + x259*x385 + x260*x349 + x360*x88 + x383 + x384
    x389 = -x9
    x390 = x323*x389
    x391 = x390*x6
    x392 = x391*x4
    x393 = x329*x389
    x394 = x390*x9
    x395 = x16*x394
    x396 = x334*x389
    x397 = x355 + x392 + x393 - x395 - x396
    x398 = -x397
    x399 = x1*x391
    x400 = x352*x389
    x401 = -x16*x322*x389*x43*x7 - x25*x31*x322*x389*x6 + x399 + x400
    x402 = x1*x394
    x403 = x340*x389
    x404 = x390*x7
    x405 = x4*x404
    x406 = x345*x389
    x407 = x1*x44
    x408 = x407 - x55
    x409 = x402 + x403 - x405 - x406 + x408
    x410 = -x409
    x411 = x322*x389
    x412 = x411*x9
    x413 = -x19*x2*x322*x389*x4*x6 + x192*x412 + x367
    x414 = x411*x6
    x415 = -x16*x19*x2*x322*x389*x7 + x364*x414 + x391
    x416 = x411*x7
    x417 = x1*x361
    x418 = x417 + x44
    x419 = -x190*x416 + x364*x412 + x394 + x418
    x420 = x413*x67 + x415*x62 - x419*x56
    x421 = x150*x410 + x156*x401 + x398*x42 + x420
    x422 = 2*x16*x322*x389*x43*x7 + 2*x25*x31*x322*x389*x6 - 2*x399 - 2*x400
    x423 = 2*x55
    x424 = 2*x407
    x425 = -x423 + x424
    x426 = 2*x402 + 2*x403 - 2*x405 - 2*x406 + x425
    x427 = x379 + 2*x392 + 2*x393 - 2*x395 - 2*x396
    x428 = -x237*x422 - x242*x426 - x244*x427
    x429 = x179*x428
    x430 = x397*x70
    x431 = x146*x428
    x432 = -x401
    x433 = x145*x428
    x434 = x144*x428
    x435 = -x104*x415 + x124*x419 + x165*x397 + x167*x432 + x169*x409 + x170*x433 + x173*x433 + x174*x433 + x187*x434 + x191*x434 + x193*x434 + x258*x397 + x259*x432 + x260*x409 - x413*x88 + x430 + x431
    x436 = -x6
    x437 = x323*x436
    x438 = x437*x6
    x439 = x4*x438
    x440 = x329*x436
    x441 = x437*x9
    x442 = x16*x441
    x443 = x334*x436
    x444 = x347 - x51
    x445 = x439 + x440 - x442 - x443 + x444
    x446 = -x445
    x447 = x1*x441
    x448 = x340*x436
    x449 = x437*x7
    x450 = x4*x449
    x451 = x345*x436
    x452 = x447 + x448 - x450 - x451
    x453 = -x452
    x454 = x1*x438
    x455 = x352*x436
    x456 = -x16*x322*x43*x436*x7 - x25*x31*x322*x436*x6 + x408 + x454 + x455
    x457 = x322*x436
    x458 = x457*x6
    x459 = x457*x9
    x460 = x190*x458 - x192*x459 + x362
    x461 = x457*x7
    x462 = -x190*x461 + x364*x459 + x441
    x463 = -x16*x19*x2*x322*x436*x7 + x364*x458 + x418 + x438
    x464 = -x460*x67 - x462*x56 + x463*x62
    x465 = x150*x453 + x156*x456 + x42*x446 + x464
    x466 = 2*x447 + 2*x448 - 2*x450 - 2*x451
    x467 = 2*x16*x322*x43*x436*x7 + 2*x25*x31*x322*x436*x6 - x425 - 2*x454 - 2*x455
    x468 = x373 - x374
    x469 = 2*x439 + 2*x440 - 2*x442 - 2*x443 + x468
    x470 = -x237*x467 - x242*x466 - x244*x469
    x471 = x179*x470
    x472 = x445*x70
    x473 = x146*x470
    x474 = -x456
    x475 = x145*x470
    x476 = x144*x470
    x477 = -x104*x463 + x124*x462 + x165*x445 + x167*x474 + x169*x452 + x170*x475 + x173*x475 + x174*x475 + x187*x476 + x191*x476 + x193*x476 + x258*x445 + x259*x474 + x260*x452 + x460*x88 + x472 + x473
    x478 = -x25
    x479 = x30**(mpmath.mpf(-3)/mpmath.mpf(2))
    x480 = x43*x479
    x481 = x478*x480
    x482 = x28*x481
    x483 = x4*x482
    x484 = x13*x479
    x485 = x478*x484
    x486 = x24*x485
    x487 = x486*x6
    x488 = -x13*x28*x478*x479*x9 - x16*x24*x43*x478*x479 + x483 + x487
    x489 = x24*x481
    x490 = x1*x489
    x491 = x25*x485
    x492 = x491*x9
    x493 = x50*x9
    x494 = x4*x47
    x495 = x493 - x494
    x496 = -x13*x24*x478*x479*x7 - x25*x4*x43*x478*x479 + x490 + x492 + x495
    x497 = x1*x482
    x498 = x491*x6
    x499 = x25*x481
    x500 = x16*x499
    x501 = x28*x485
    x502 = x501*x7
    x503 = x50*x6
    x504 = x16*x47
    x505 = x503 - x504
    x506 = x497 + x498 - x500 - x502 + x505
    x507 = -x506
    x508 = x478*x479
    x509 = x28*x508
    x510 = -x16*x19*x2*x24*x478*x479 + x190*x509
    x511 = x2*x33
    x512 = -x511
    x513 = x25*x508
    x514 = -x192*x513 + x364*x509 + x482 + x512
    x515 = x2*x32
    x516 = x4*x515
    x517 = -x516
    x518 = x24*x508
    x519 = -x19*x2*x25*x4*x478*x479 + x364*x518 + x489 + x517
    x520 = x510*x67 - x514*x62 + x519*x56
    x521 = x150*x496 + x156*x507 + x42*x488 + x520
    x522 = 2*x13*x28*x478*x479*x9 + 2*x16*x24*x43*x478*x479 - 2*x483 - 2*x487
    x523 = 2*x494
    x524 = 2*x493
    x525 = -x523 + x524
    x526 = 2*x13*x24*x478*x479*x7 + 2*x25*x4*x43*x478*x479 - 2*x490 - 2*x492 - x525
    x527 = 2*x503 - 2*x504
    x528 = 2*x497 + 2*x498 - 2*x500 - 2*x502 + x527
    x529 = -x237*x528 - x242*x526 - x244*x522
    x530 = x179*x529
    x531 = -x488
    x532 = x531*x70
    x533 = x146*x529
    x534 = -x496
    x535 = x145*x529
    x536 = x144*x529
    x537 = x104*x514 - x124*x519 + x165*x531 + x167*x506 + x169*x534 + x170*x535 + x173*x535 + x174*x535 + x187*x536 + x191*x536 + x193*x536 + x258*x531 + x259*x506 + x260*x534 - x510*x88 + x532 + x533
    x538 = -x24
    x539 = x480*x538
    x540 = x28*x539
    x541 = x4*x540
    x542 = x484*x538
    x543 = x24*x542
    x544 = x543*x6
    x545 = -x13*x28*x479*x538*x9 - x16*x24*x43*x479*x538 + x505 + x541 + x544
    x546 = x1*x540
    x547 = x25*x542
    x548 = x547*x6
    x549 = x25*x539
    x550 = x16*x549
    x551 = x28*x542
    x552 = x551*x7
    x553 = x546 + x548 - x550 - x552
    x554 = -x553
    x555 = x24*x539
    x556 = x1*x555
    x557 = x547*x9
    x558 = x1*x47
    x559 = x50*x7
    x560 = x558 - x559
    x561 = -x13*x24*x479*x538*x7 - x25*x4*x43*x479*x538 + x556 + x557 + x560
    x562 = x479*x538
    x563 = x24*x562
    x564 = x28*x562
    x565 = -x190*x564 + x192*x563 + x511
    x566 = x25*x562
    x567 = -x192*x566 + x364*x564 + x540
    x568 = x1*x515
    x569 = x47 + x568
    x570 = -x19*x2*x25*x4*x479*x538 + x364*x563 + x555 + x569
    x571 = x56*x570 - x565*x67 - x567*x62
    x572 = x150*x561 + x156*x554 + x42*x545 + x571
    x573 = 2*x546 + 2*x548 - 2*x550 - 2*x552
    x574 = 2*x558 - 2*x559
    x575 = 2*x13*x24*x479*x538*x7 + 2*x25*x4*x43*x479*x538 - 2*x556 - 2*x557 - x574
    x576 = 2*x13*x28*x479*x538*x9 + 2*x16*x24*x43*x479*x538 - x527 - 2*x541 - 2*x544
    x577 = -x237*x573 - x242*x575 - x244*x576
    x578 = x179*x577
    x579 = -x545
    x580 = x579*x70
    x581 = x146*x577
    x582 = -x561
    x583 = x145*x577
    x584 = x144*x577
    x585 = x104*x567 - x124*x570 + x165*x579 + x167*x553 + x169*x582 + x170*x583 + x173*x583 + x174*x583 + x187*x584 + x191*x584 + x193*x584 + x258*x579 + x259*x553 + x260*x582 + x565*x88 + x580 + x581
    x586 = -x28
    x587 = x480*x586
    x588 = x28*x587
    x589 = x4*x588
    x590 = x484*x586
    x591 = x24*x590
    x592 = x591*x6
    x593 = -x493 + x494
    x594 = -x13*x28*x479*x586*x9 - x16*x24*x43*x479*x586 + x589 + x592 + x593
    x595 = x24*x587
    x596 = x1*x595
    x597 = x25*x590
    x598 = x597*x9
    x599 = -x13*x24*x479*x586*x7 - x25*x4*x43*x479*x586 + x596 + x598
    x600 = x1*x588
    x601 = x597*x6
    x602 = x25*x587
    x603 = x16*x602
    x604 = x28*x590
    x605 = x604*x7
    x606 = x560 + x600 + x601 - x603 - x605
    x607 = -x606
    x608 = x479*x586
    x609 = x28*x608
    x610 = -x16*x19*x2*x24*x479*x586 + x190*x609 + x516
    x611 = x24*x608
    x612 = -x19*x2*x25*x4*x479*x586 + x364*x611 + x595
    x613 = x25*x608
    x614 = -x192*x613 + x364*x609 + x569 + x588
    x615 = x56*x612 + x610*x67 - x614*x62
    x616 = x150*x599 + x156*x607 + x42*x594 + x615
    x617 = 2*x13*x24*x479*x586*x7 + 2*x25*x4*x43*x479*x586 - 2*x596 - 2*x598
    x618 = x574 + 2*x600 + 2*x601 - 2*x603 - 2*x605
    x619 = x523 - x524
    x620 = 2*x13*x28*x479*x586*x9 + 2*x16*x24*x43*x479*x586 - 2*x589 - 2*x592 - x619
    x621 = -x237*x618 - x242*x617 - x244*x620
    x622 = x179*x621
    x623 = -x594
    x624 = x623*x70
    x625 = x146*x621
    x626 = -x599
    x627 = x145*x621
    x628 = x144*x621
    x629 = x104*x614 - x124*x612 + x165*x623 + x167*x606 + x169*x626 + x170*x627 + x173*x627 + x174*x627 + x187*x628 + x191*x628 + x193*x628 + x258*x623 + x259*x606 + x260*x626 - x610*x88 + x624 + x625
    x630 = -2*p0
    x631 = 2*m0 + x630
    x632 = x16*x76
    x633 = x1*x80
    x634 = x632*x633
    x635 = x1*x632
    x636 = x635*x82
    x637 = x1*x4
    x638 = x637*x76
    x639 = x638*x78
    x640 = x638*x83
    x641 = x25*x479
    x642 = x24*x641
    x643 = x192*x642
    x644 = x7*x9
    x645 = x322*x644
    x646 = x192*x645
    x647 = x22 - x37
    x648 = x643 - x646 + x647
    x649 = x639 - x640 + x648
    x650 = x322*x6
    x651 = x650*x7
    x652 = x190*x651
    x653 = x28*x641
    x654 = x190*x653
    x655 = x34 - x40
    x656 = x652 - x654 + x655
    x657 = -x631
    x658 = x14*x76
    x659 = x658*x83
    x660 = x322*x8
    x661 = x192*x660
    x662 = x13*x658
    x663 = x6*x662
    x664 = x26*x479
    x665 = x192*x664
    x666 = x106*x635
    x667 = x364*x653
    x668 = x635*x90
    x669 = x364*x651
    x670 = x25*x480
    x671 = x28*x670
    x672 = x323*x7
    x673 = x6*x672
    x674 = x671 - x673
    x675 = x662*x9
    x676 = x658*x80
    x677 = x638*x90
    x678 = x106*x638
    x679 = x190*x664
    x680 = x190*x660
    x681 = x364*x645
    x682 = x364*x642
    x683 = -x113 + x115
    x684 = x672*x9
    x685 = x24*x670
    x686 = x684 - x685
    x687 = x272 + x362 + x517 + x679 - x680 + x681 - x682 + x683 + x686
    x688 = x67*x69
    x689 = (mpmath.mpf(1)/mpmath.mpf(2))*x13*x16*x19*x2*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x19*x2*x28*x31*x4 - mpmath.mpf(1)/mpmath.mpf(2)*x23 - mpmath.mpf(1)/mpmath.mpf(2)*x35
    x690 = x1*x40
    x691 = 2*x690
    x692 = x4*x671
    x693 = 2*x692
    x694 = x334*x7
    x695 = 2*x694
    x696 = x1*x34
    x697 = 2*x696
    x698 = x4*x673
    x699 = 2*x698
    x700 = x25*x484
    x701 = x28*x700
    x702 = x701*x9
    x703 = 2*x702
    x704 = x1*x37
    x705 = x16*x684
    x706 = x24*x700
    x707 = x6*x706
    x708 = x1*x22
    x709 = x16*x685
    x710 = x329*x7
    x711 = -2*x704 - 2*x705 - 2*x707 + 2*x708 + 2*x709 + 2*x710
    x712 = -x691 - x693 - x695 + x697 + x699 + x703 + x711
    x713 = (mpmath.mpf(1)/mpmath.mpf(2))*x13*x16*x43*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x24*x31*x6 + (mpmath.mpf(1)/mpmath.mpf(2))*x28*x31*x4*x43 - mpmath.mpf(1)/mpmath.mpf(2)*x63 - mpmath.mpf(1)/mpmath.mpf(2)*x64 - mpmath.mpf(1)/mpmath.mpf(2)*x65
    x714 = 2*x636
    x715 = 2*x654
    x716 = 2*x634
    x717 = 2*x652
    x718 = 2*x40
    x719 = 2*x34
    x720 = -x718 + x719
    x721 = 2*x37
    x722 = 2*x22
    x723 = -x721 + x722
    x724 = 2*x639 - 2*x640 + 2*x643 - 2*x646 + x723
    x725 = (mpmath.mpf(1)/mpmath.mpf(2))*x45
    x726 = (mpmath.mpf(1)/mpmath.mpf(2))*x53
    x727 = x725 - x726
    x728 = (mpmath.mpf(1)/mpmath.mpf(2))*x1*x19*x2*x24*x31 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x19*x2*x4*x7 - mpmath.mpf(1)/mpmath.mpf(2)*x131 - mpmath.mpf(1)/mpmath.mpf(2)*x132 - x727
    x729 = x14*x32
    x730 = x24*x729
    x731 = x323*x8
    x732 = x4*x731
    x733 = x26*x484
    x734 = x733*x9
    x735 = x14*x20
    x736 = x735*x9
    x737 = x327*x8
    x738 = x24*x737
    x739 = x26*x480
    x740 = x4*x739
    x741 = x1*x113
    x742 = x1*x685
    x743 = x345*x7
    x744 = x1*x115
    x745 = x1*x684
    x746 = x7*x706
    x747 = x304 + x468 + x525 - 2*x730 - 2*x732 - 2*x734 + 2*x736 + 2*x738 + 2*x740 - 2*x741 - 2*x742 - 2*x743 + 2*x744 + 2*x745 + 2*x746
    x748 = (mpmath.mpf(1)/mpmath.mpf(2))*x57
    x749 = (mpmath.mpf(1)/mpmath.mpf(2))*x66
    x750 = x748 - x749
    x751 = (mpmath.mpf(1)/mpmath.mpf(2))*x137 + (mpmath.mpf(1)/mpmath.mpf(2))*x138 - mpmath.mpf(1)/mpmath.mpf(2)*x152 - mpmath.mpf(1)/mpmath.mpf(2)*x153 + x750
    x752 = x6*x735
    x753 = x28*x737
    x754 = x16*x739
    x755 = x1*x92
    x756 = x1*x673
    x757 = x7*x701
    x758 = x139 - x140 + x377 - x378 + x527
    x759 = 2*x1*x13*x16*x19*x7 + 2*x1*x25*x28*x43*x479 + 2*x13*x26*x479*x6 + 2*x14*x19*x28*x31 + 2*x16*x322*x43*x8 + 2*x25*x31*x322*x6*x7 - 2*x752 - 2*x753 - 2*x754 - 2*x755 - 2*x756 - 2*x757 - x758
    x760 = (mpmath.mpf(1)/mpmath.mpf(2))*x1*x24*x31*x43 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x25*x31*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x4*x43*x7 - mpmath.mpf(1)/mpmath.mpf(2)*x46 - mpmath.mpf(1)/mpmath.mpf(2)*x49 - mpmath.mpf(1)/mpmath.mpf(2)*x52
    x761 = -4*p0
    x762 = 4*m0 + x761
    x763 = -x762
    x764 = 2*x516
    x765 = 2*x362
    x766 = 2*x113
    x767 = 2*x115
    x768 = -x766 + x767
    x769 = 2*x685
    x770 = 2*x684
    x771 = -x769 + x770
    x772 = -mpmath.mpf(1)/mpmath.mpf(2)*x1*x66 - mpmath.mpf(1)/mpmath.mpf(2)*x16*x54 - mpmath.mpf(1)/mpmath.mpf(2)*x55*x6 + (mpmath.mpf(1)/mpmath.mpf(2))*x58 + (mpmath.mpf(1)/mpmath.mpf(2))*x59 + (mpmath.mpf(1)/mpmath.mpf(2))*x61
    x773 = 2*x367
    x774 = 2*x511
    x775 = 2*x673
    x776 = 2*x671
    x777 = -x775 + x776
    x778 = 2*x92
    x779 = 2*x91
    x780 = -x778 + x779
    x781 = x689*x712 + x713*(-x714 - x715 + x716 + x717 + x720 + x724) + x728*x747 + x751*x759 + x760*(x107*x763 + x109*x762 + x119 - x121 + 2*x675 - 2*x676 + 2*x677 - 2*x678 + 2*x679 - 2*x680 + 2*x681 - 2*x682 - x764 + x765 + x768 + x771) + x772*(x102 + x21*x763 + x36*x762 + 2*x659 + 2*x661 - 2*x663 - 2*x665 + 2*x666 + 2*x667 - 2*x668 - 2*x669 - x773 + x774 + x777 + x780)
    x782 = -x237*x759 - x242*x747 - x244*x712
    x783 = x179*x782
    x784 = -x704 - x705 - x707 + x708 + x709 + x710
    x785 = -x690 - x692 - x694 + x696 + x698 + x702 + x784
    x786 = x70*x785
    x787 = x125*x14
    x788 = x146*x782
    x789 = x14*x19
    x790 = x67*x789
    x791 = x125*x637
    x792 = x354 + x505 - x57 - x60 + x66
    x793 = x1*x13*x16*x19*x7 + x1*x25*x28*x43*x479 + x13*x26*x479*x6 + x14*x19*x28*x31 + x16*x322*x43*x8 + x25*x31*x322*x6*x7 - x752 - x753 - x754 - x755 - x756 - x757 - x792
    x794 = x289 + x444 + x495 - x730 - x732 - x734 + x736 + x738 + x740 - x741 - x742 - x743 + x744 + x745 + x746
    x795 = x145*x782
    x796 = x19*x637
    x797 = x16*x19
    x798 = x1*x797
    x799 = x144*x782
    x800 = -x127 - x147 + x156*x791 + x164*x174 + x165*x785 + x167*x793 + x169*x794 + x170*x795 + x173*x795 + x174*x795 + x187*x799 + x188*x790 + x191*x799 + x193*x799 + x196 + x198 + x258*x785 + x259*x793 + x260*x794 + x265*x796 + x267*x798 + x42*x787 - x71 + x786 + x788
    x801 = x15*x76
    x802 = x78*x801
    x803 = x801*x83
    x804 = x4*x632
    x805 = x80*x804
    x806 = x804*x82
    x807 = x27*x479
    x808 = x192*x807
    x809 = x10*x322
    x810 = x192*x809
    x811 = x650*x9
    x812 = x190*x811
    x813 = x24*x28
    x814 = x479*x813
    x815 = x190*x814
    x816 = -x100 + x367 + x512 + x98
    x817 = x808 - x810 + x812 - x815 + x816
    x818 = x804*x90
    x819 = x106*x804
    x820 = x364*x811
    x821 = x364*x814
    x822 = x323*x9
    x823 = x6*x822
    x824 = x480*x813
    x825 = x823 - x824
    x826 = x820 - x821 + x825
    x827 = x818 - x819 + x826
    x828 = x801*x90
    x829 = x106*x801
    x830 = x638*x82
    x831 = x638*x80
    x832 = x364*x809
    x833 = x364*x807
    x834 = x190*x642
    x835 = x190*x645
    x836 = x10*x323
    x837 = x27*x480
    x838 = x109*x4
    x839 = x107*x4
    x840 = x836 - x837 + x838 - x839
    x841 = -x44
    x842 = -x211 + x212 - x417 + x569 + x841
    x843 = x832 - x833 + x834 - x835 + x840 + x842
    x844 = x1*x824
    x845 = x25*x333
    x846 = x845*x9
    x847 = x1*x823
    x848 = x484*x813
    x849 = x7*x848
    x850 = x4*x778 - x4*x779 - 2*x844 - 2*x846 + 2*x847 + 2*x849
    x851 = -x711 - x850
    x852 = 2*x824
    x853 = 2*x823
    x854 = -x852 + x853
    x855 = 2*x818 - 2*x819 + 2*x820 - 2*x821 + x854
    x856 = x15*x32
    x857 = x28*x856
    x858 = x16*x836
    x859 = x27*x484
    x860 = x6*x859
    x861 = x15*x20
    x862 = x6*x861
    x863 = x10*x327
    x864 = x28*x863
    x865 = x16*x837
    x866 = x4*x824
    x867 = x334*x9
    x868 = x4*x823
    x869 = x848*x9
    x870 = -x4*x718 + x4*x719 + x758 - 2*x857 - 2*x858 - 2*x860 + 2*x862 + 2*x864 + 2*x865 - 2*x866 - 2*x867 + 2*x868 + 2*x869
    x871 = x7*x861
    x872 = x25*x863
    x873 = x1*x837
    x874 = x25*x856
    x875 = x1*x836
    x876 = x7*x859
    x877 = x108*x4
    x878 = x706*x9
    x879 = x110*x4
    x880 = x340*x9
    x881 = x238 - x239 + x423 - x424 + x574
    x882 = x4*x769 - x4*x770 - 2*x871 - 2*x872 - 2*x873 + 2*x874 + 2*x875 + 2*x876 - 2*x877 - 2*x878 + 2*x879 + 2*x880 + x881
    x883 = 2*x837
    x884 = 2*x836
    x885 = 2*x839
    x886 = 2*x838
    x887 = -x883 + x884 - x885 + x886
    x888 = 2*x44
    x889 = -x888
    x890 = 2*x47
    x891 = x889 + x890
    x892 = -2*x211 + 2*x212 - 2*x417 + 2*x568 + x891
    x893 = x689*x870 + x713*(-x101 + x773 - x774 + 2*x802 - 2*x803 + 2*x805 - 2*x806 + 2*x808 - 2*x810 + 2*x812 - 2*x815 + x99) + x728*x882 + x751*x851 + x760*(2*x828 - 2*x829 + 2*x830 - 2*x831 + 2*x832 - 2*x833 + 2*x834 - 2*x835 + x887 + x892) + x772*(-x724 - x855)
    x894 = x175*x4
    x895 = -x237*x851 - x242*x882 - x244*x870
    x896 = x179*x895
    x897 = x34*x4
    x898 = -x4*x40 + x792 - x857 - x858 - x860 + x862 + x864 + x865 - x866 - x867 + x868 + x869 + x897
    x899 = x70*x898
    x900 = x125*x15
    x901 = x126*x4
    x902 = x146*x895
    x903 = x15*x19
    x904 = x62*x903
    x905 = x4*x92
    x906 = x4*x91
    x907 = -x844 - x846 + x847 + x849 + x905 - x906
    x908 = -x784 - x907
    x909 = x4*x685
    x910 = -x407 - x48 + x54 + x55 + x560
    x911 = -x4*x684 - x871 - x872 - x873 + x874 + x875 + x876 - x877 - x878 + x879 + x880 + x909 + x910
    x912 = x145*x895
    x913 = x19*x4
    x914 = x144*x895
    x915 = x4*x797
    x916 = x156*x900 + x165*x898 + x166*x174 + x167*x908 + x169*x911 + x170*x912 + x173*x912 + x174*x912 + x187*x914 + x188*x904 + x191*x914 + x193*x914 - x248 - x249 - x252 + x258*x898 + x259*x908 + x260*x911 + x263*x913 + x267*x915 + x42*x791 + x899 + x901 + x902
    x917 = x17*x76
    x918 = x80*x917
    x919 = x82*x917
    x920 = x632*x79
    x921 = x804*x83
    x922 = x11*x322
    x923 = x190*x922
    x924 = x29*x479
    x925 = x190*x924
    x926 = x192*x814
    x927 = x192*x811
    x928 = -x118 + x120 + x363 + x516 + x923 - x925 + x926 - x927
    x929 = x90*x917
    x930 = x635*x78
    x931 = x364*x922
    x932 = x192*x653
    x933 = x11*x323
    x934 = x29*x480
    x935 = x39*x6
    x936 = x16*x36
    x937 = x933 - x934 + x935 - x936
    x938 = -x1*x19*x2*x29*x479 - x16*x19*x2*x322*x6*x7 + x842 + x931 + x932 + x937
    x939 = -x652 + x654 + x84
    x940 = x691 + x693 + x695 - x697 - x699 - x703 + x850
    x941 = x718 - x719
    x942 = x17*x20
    x943 = x9*x942
    x944 = x11*x327
    x945 = x24*x944
    x946 = x4*x934
    x947 = x17*x32
    x948 = x24*x947
    x949 = x4*x933
    x950 = x29*x484
    x951 = x9*x950
    x952 = x6*x848
    x953 = x4*x935
    x954 = x28*x333
    x955 = x9*x954
    x956 = x135 - x16*x721 + x16*x852 - x16*x853 + x375 + x619 - 2*x943 - 2*x945 - 2*x946 + 2*x948 + 2*x949 + 2*x951 - 2*x952 + 2*x953 + 2*x955
    x957 = x25*x947
    x958 = x1*x933
    x959 = x7*x950
    x960 = x1*x935
    x961 = x7*x954
    x962 = 2*x1*x16*x19*x28*x31 + 2*x1*x29*x43*x479 + 2*x11*x25*x31*x322 + 2*x13*x17*x19*x7 + 2*x13*x25*x28*x479*x6 + 2*x16*x322*x43*x6*x7 - x16*x776 - x881 - 2*x957 - 2*x958 - 2*x959 - 2*x960 - 2*x961
    x963 = 2*x934
    x964 = 2*x933
    x965 = 2*x936
    x966 = 2*x935
    x967 = -x963 + x964 - x965 + x966
    x968 = x689*x956 + x713*(x122 + x764 - x765 + 2*x918 - 2*x919 + 2*x920 - 2*x921 + 2*x923 - 2*x925 + 2*x926 - 2*x927) + x728*x940 + x751*x962 + x760*(x714 + x715 - x716 - x717 + x855 + x941) + x772*(2*x1*x16*x28*x31*x72*x75 + 2*x1*x19*x2*x29*x479 + 2*x13*x17*x7*x72*x75 + 2*x16*x19*x2*x322*x6*x7 - x892 - 2*x929 - 2*x930 - 2*x931 - 2*x932 - x967)
    x969 = -x237*x962 - x242*x940 - x244*x956
    x970 = x179*x969
    x971 = x16*x824
    x972 = x149 - x16*x37 - x16*x823 + x348 + x593 - x943 - x945 - x946 + x948 + x949 + x951 - x952 + x953 + x955 + x971
    x973 = x70*x972
    x974 = x125*x17
    x975 = x126*x16
    x976 = x146*x969
    x977 = x17*x19
    x978 = x56*x977
    x979 = x16*x671
    x980 = x1*x16*x19*x28*x31 + x1*x29*x43*x479 + x11*x25*x31*x322 + x13*x17*x19*x7 + x13*x25*x28*x479*x6 + x16*x322*x43*x6*x7 - x910 - x957 - x958 - x959 - x960 - x961 - x979
    x981 = x690 + x692 + x694 - x696 - x698 - x702 + x907
    x982 = x145*x969
    x983 = x144*x969
    x984 = x150*x974 + x16*x253 + x16*x255 + x165*x972 + x167*x980 + x169*x981 + x170*x982 + x173*x982 + x174*x982 + x187*x983 + x188*x978 + x191*x983 + x193*x983 + x258*x972 + x259*x980 + x260*x981 + x263*x797 + x265*x915 - x308 - x310 - x313 + x973 + x975 + x976
    x985 = -3*p1
    x986 = 3*m1 + x985
    x987 = -x986
    x988 = x72*x987
    x989 = x2*x988
    x990 = x16*x989
    x991 = x203 - x4*x83*x989 + x79*x989 + x80*x990 - x82*x990
    x992 = x1*x989
    x993 = -x1*x2*x28*x31*x72*x987 - x13*x16*x2*x7*x72*x987 + x208 + x78*x992 + x90*x990
    x994 = x4*x989
    x995 = -x106*x994 + x217 - x633*x989 + x82*x992 + x90*x994
    x996 = x148*x223 + x151*x233 + x155*x254 - x56*x995 + x62*x993 - x67*x991
    x997 = (mpmath.mpf(3)/mpmath.mpf(2))*x62
    x998 = (mpmath.mpf(3)/mpmath.mpf(2))*x56
    x999 = (mpmath.mpf(3)/mpmath.mpf(2))*x67
    x1000 = x178*(-x236*x997 - x241*x998 - x243*x999)
    x1001 = x1000*x143
    x1002 = x254*x70
    x1003 = 2*x207
    x1004 = 2*x206
    x1005 = x200*x988
    x1006 = x1005*x16
    x1007 = -x1003 + x1004 - x1005*x4*x83 + x1005*x79 + x1006*x80 - x1006*x82 + x86
    x1008 = x1*x1005
    x1009 = -x1*x200*x28*x31*x72*x987 + x1006*x90 + x1008*x78 - x13*x16*x200*x7*x72*x987 + x97
    x1010 = x112*x200
    x1011 = 2*x1010
    x1012 = x114*x200
    x1013 = 2*x1012
    x1014 = x1005*x4
    x1015 = -x1005*x633 + x1008*x82 - x1011 + x1013 - x1014*x106 + x1014*x90 + x117
    x1016 = x195*x200
    x1017 = x257*x62
    x1018 = -x1007*x67 + x1009*x62 - x1015*x56 + x223*x224 + x227*x254 + x233*x234
    x1019 = x164*x200
    x1020 = 2*x223
    x1021 = x166*x200
    x1022 = 2*x254
    x1023 = x168*x200
    x1024 = 2*x233
    x1025 = x1*x257
    x1026 = x257*x4
    x1027 = x16*x257
    x1028 = x1000*x245
    x1029 = x158*x262
    x1030 = 2*x261
    x1031 = x264*x62
    x1032 = x266*x56
    x1033 = x269*x988
    x1034 = x1033*x16
    x1035 = -x214 + x215
    x1036 = x1035 + x277
    x1037 = -x1033*x4*x83 + x1033*x79 + x1034*x80 - x1034*x82 + x1036
    x1038 = x1*x1033
    x1039 = -x1010 + x1012
    x1040 = -x1*x269*x28*x31*x72*x987 + x1034*x90 + x1038*x78 + x1039 - x13*x16*x269*x7*x72*x987
    x1041 = x1033*x4
    x1042 = x114*x269
    x1043 = x112*x269
    x1044 = x1042 - x1043
    x1045 = -x1033*x633 + x1038*x82 - x1041*x106 + x1041*x90 + x1044
    x1046 = -x1037*x67 + x1040*x62 - x1045*x56 + x223*x291 + x233*x297 + x254*x300
    x1047 = x1000*x306
    x1048 = x314*x70
    x1049 = x233*x70
    x1050 = x197*x200
    x1051 = x195*x269
    x1052 = x257*x56
    x1053 = x160*x306
    x1054 = x164*x223
    x1055 = x166*x254
    x1056 = x168*x269
    x1057 = x1*x223
    x1058 = x254*x4
    x1059 = x16*x233
    x1060 = x158*x261
    x1061 = x261*x62
    x1062 = x261*x56
    x1063 = x1019*x290 + x1021*x314 + x1023*x296 + x1025*x290 + x1026*x314 + x1027*x296 + x1029*x316 + x1031*x316 + x1032*x316 + x1048 + x1049 + x1050 + x1051 + x1052 + x1053 + x1054*x269 + x1055*x269 + x1056*x233 + x1057*x315 + x1058*x315 + x1059*x315 + x1060*x317 + x1061*x318 + x1062*x319
    x1064 = x200*x39
    x1065 = x1*x262
    x1066 = x1064 - x1065*x358 + x266*x365
    x1067 = x264*x358 - x266*x359 + x325
    x1068 = x20*x200
    x1069 = x1068*x4
    x1070 = x1069 + x44
    x1071 = -x1*x19*x200*x321*x322*x9 + x1070 + x264*x365 + x342
    x1072 = -x1066*x62 - x1067*x67 + x1071*x56
    x1073 = x1072 + x223*x337 + x233*x350 + x254*x356
    x1074 = x1000*x381
    x1075 = x385*x70
    x1076 = x160*x381
    x1077 = x1019*x336 + x1021*x385 + x1023*x349 + x1025*x336 + x1026*x385 + x1027*x349 + x1029*x387 + x1031*x387 + x1032*x387 + x104*x1066 + x1057*x386 + x1058*x386 + x1059*x386 + x1067*x88 - x1071*x124 + x1075 + x1076
    x1078 = x1065*x414 - x16*x19*x200*x322*x389*x7
    x1079 = -x1064 + x264*x414 - x266*x412 + x391
    x1080 = x1*x1068
    x1081 = x1065*x412 + x1080 - x264*x416 - x404
    x1082 = x1078*x62 - x1079*x67 - x1081*x56
    x1083 = x1082 + x223*x398 + x233*x410 + x254*x401
    x1084 = x1000*x428
    x1085 = x432*x70
    x1086 = x160*x428
    x1087 = x1019*x397 + x1021*x432 + x1023*x409 + x1025*x397 + x1026*x432 + x1027*x409 + x1029*x434 + x1031*x434 + x1032*x434 - x104*x1078 + x1057*x433 + x1058*x433 + x1059*x433 + x1079*x88 + x1081*x124 + x1085 + x1086
    x1088 = x1065*x458 + x1080 - x16*x19*x200*x322*x436*x7
    x1089 = -x1*x19*x200*x322*x436*x9 + x264*x461 + x449
    x1090 = x1070 + x264*x458 - x266*x459 + x438
    x1091 = x1088*x62 + x1089*x56 - x1090*x67
    x1092 = x1091 + x223*x446 + x233*x453 + x254*x456
    x1093 = x1000*x470
    x1094 = x474*x70
    x1095 = x160*x470
    x1096 = x1019*x445 + x1021*x474 + x1023*x452 + x1025*x445 + x1026*x474 + x1027*x452 + x1029*x476 + x1031*x476 + x1032*x476 - x104*x1088 + x1057*x475 + x1058*x475 + x1059*x475 - x1089*x124 + x1090*x88 + x1094 + x1095
    x1097 = x200*x33
    x1098 = -x1*x19*x200*x28*x478*x479 + x1097 + x266*x513
    x1099 = -x16*x19*x200*x24*x478*x479 + x264*x509 + x482
    x1100 = x200*x32
    x1101 = x1100*x4
    x1102 = x1101 + x47
    x1103 = -x1065*x518 + x1102 + x264*x513 + x499
    x1104 = x1098*x62 + x1099*x67 - x1103*x56
    x1105 = x1104 + x223*x488 + x233*x496 + x254*x507
    x1106 = x1000*x529
    x1107 = x506*x70
    x1108 = x160*x529
    x1109 = x1019*x531 + x1021*x506 + x1023*x534 + x1025*x531 + x1026*x506 + x1027*x534 + x1029*x536 + x1031*x536 + x1032*x536 - x104*x1098 + x1057*x535 + x1058*x535 + x1059*x535 - x1099*x88 + x1103*x124 + x1107 + x1108
    x1110 = x1065*x564 - x266*x566
    x1111 = x1*x1100
    x1112 = -x549
    x1113 = x1065*x563 + x1111 + x1112 - x19*x200*x25*x4*x479*x538
    x1114 = -x1097
    x1115 = x1114 - x16*x19*x200*x24*x479*x538 + x264*x564 + x540
    x1116 = -x1110*x62 + x1113*x56 + x1115*x67
    x1117 = x1116 + x223*x545 + x233*x561 + x254*x554
    x1118 = x1000*x577
    x1119 = x553*x70
    x1120 = x160*x577
    x1121 = x1019*x579 + x1021*x553 + x1023*x582 + x1025*x579 + x1026*x553 + x1027*x582 + x1029*x584 + x1031*x584 + x1032*x584 + x104*x1110 + x1057*x583 + x1058*x583 + x1059*x583 - x1113*x124 - x1115*x88 + x1119 + x1120
    x1122 = x1065*x609 + x1111 - x266*x613
    x1123 = -x1065*x611 + x264*x613 + x602
    x1124 = x1102 - x16*x19*x200*x24*x479*x586 + x264*x609 + x588
    x1125 = -x1122*x62 - x1123*x56 + x1124*x67
    x1126 = x1125 + x223*x594 + x233*x599 + x254*x607
    x1127 = x1000*x621
    x1128 = x606*x70
    x1129 = x160*x621
    x1130 = x1019*x623 + x1021*x606 + x1023*x626 + x1025*x623 + x1026*x606 + x1027*x626 + x1029*x628 + x1031*x628 + x1032*x628 + x104*x1122 + x1057*x627 + x1058*x627 + x1059*x627 + x1123*x124 - x1124*x88 + x1128 + x1129
    x1131 = x16*x988
    x1132 = x1131*x633
    x1133 = x1*x1131
    x1134 = x1133*x82
    x1135 = x637*x988
    x1136 = x1135*x78
    x1137 = x1135*x83
    x1138 = x266*x642
    x1139 = x266*x645
    x1140 = -x94 + x95
    x1141 = x1138 - x1139 + x1140
    x1142 = x1136 - x1137 + x1141
    x1143 = x264*x651
    x1144 = x264*x653
    x1145 = -x671 + x673
    x1146 = x1143 - x1144 + x1145
    x1147 = x14*x988
    x1148 = x1147*x78
    x1149 = x1133*x90
    x1150 = x266*x664
    x1151 = x1065*x651
    x1152 = x1064 + x1114 - x206 + x207
    x1153 = -x1*x19*x200*x25*x28*x479 + x1150 + x1151 + x1152 - x16*x19*x200*x322*x8
    x1154 = x1147*x82
    x1155 = x1147*x80
    x1156 = x1135*x90
    x1157 = x106*x1135
    x1158 = x264*x664
    x1159 = x264*x660
    x1160 = x1065*x645
    x1161 = x1065*x642
    x1162 = -x47
    x1163 = x1*x114
    x1164 = x1*x112
    x1165 = x1162 + x1163 - x1164 - x731 + x739
    x1166 = x1035 + x1070 - x1101 + x1158 - x1159 + x1160 - x1161 + x1165
    x1167 = (mpmath.mpf(1)/mpmath.mpf(2))*x13*x16*x19*x200*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x19*x200*x28*x31*x4 - mpmath.mpf(1)/mpmath.mpf(2)*x219 - mpmath.mpf(1)/mpmath.mpf(2)*x220 - x750
    x1168 = x1003 - x1004 + 2*x1064 - 2*x1097
    x1169 = 2*x1134
    x1170 = 2*x1144
    x1171 = 2*x1132
    x1172 = 2*x1143
    x1173 = x775 - x776
    x1174 = 2*x94
    x1175 = 2*x95
    x1176 = -x1174 + x1175
    x1177 = 2*x1136 - 2*x1137 + 2*x1138 - 2*x1139 + x1176
    x1178 = -mpmath.mpf(1)/mpmath.mpf(2)*x200*x91 - mpmath.mpf(1)/mpmath.mpf(2)*x200*x94 + (mpmath.mpf(1)/mpmath.mpf(2))*x225 + (mpmath.mpf(1)/mpmath.mpf(2))*x226
    x1179 = (mpmath.mpf(1)/mpmath.mpf(2))*x48
    x1180 = (mpmath.mpf(1)/mpmath.mpf(2))*x54
    x1181 = x1179 - x1180
    x1182 = (mpmath.mpf(1)/mpmath.mpf(2))*x1*x19*x200*x24*x31 - x1181 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x19*x200*x4*x7 - mpmath.mpf(1)/mpmath.mpf(2)*x228 - mpmath.mpf(1)/mpmath.mpf(2)*x229
    x1183 = 2*x214
    x1184 = 2*x1101
    x1185 = 2*x1069
    x1186 = 2*x215
    x1187 = 2*x731
    x1188 = 2*x739
    x1189 = 2*x1164
    x1190 = 2*x1163
    x1191 = -x890
    x1192 = x1191 + x888
    x1193 = -x1187 + x1188 - x1189 + x1190 + x1192
    x1194 = x1167*x712 + x1178*x759 + x1182*x747 + x713*(-x1169 - x1170 + x1171 + x1172 + x1173 + x1177) + x760*(2*x1154 - 2*x1155 + 2*x1156 - 2*x1157 + 2*x1158 - 2*x1159 + 2*x1160 - 2*x1161 - x1183 - x1184 + x1185 + x1186 + x1193) + x772*(2*x1*x13*x16*x7*x72*x987 + 2*x1*x19*x200*x25*x28*x479 - 2*x1148 - 2*x1149 - 2*x1150 - 2*x1151 - x1168 + 2*x14*x28*x31*x72*x987 + 2*x16*x19*x200*x322*x8)
    x1195 = x1000*x782
    x1196 = x70*x793
    x1197 = x1*x195
    x1198 = x160*x782
    x1199 = x1019*x785 + x1021*x793 + x1023*x794 + x1025*x785 + x1026*x793 + x1027*x794 + x1029*x799 + x1031*x799 + x1032*x799 + x1057*x795 + x1058*x795 + x1059*x164 + x1059*x795 + x1061*x796 + x1062*x798 + x1196 + x1197 + x1198 + x223*x787 - x247 - x250 - x251 + x254*x791 + x261*x790
    x1200 = -2*p1
    x1201 = 2*m1 + x1200
    x1202 = -x1201
    x1203 = x15*x988
    x1204 = x1203*x78
    x1205 = x1203*x83
    x1206 = x1131*x4
    x1207 = x1206*x80
    x1208 = x1206*x82
    x1209 = x266*x807
    x1210 = x266*x809
    x1211 = x264*x811
    x1212 = x264*x814
    x1213 = x1152 + x1209 - x1210 + x1211 - x1212 + x655 + x825
    x1214 = x1206*x90
    x1215 = x106*x1206
    x1216 = x1065*x811
    x1217 = x1065*x814
    x1218 = -x91 + x92
    x1219 = x1216 - x1217 + x1218
    x1220 = x1214 - x1215 + x1219
    x1221 = x1203*x90
    x1222 = x106*x1203
    x1223 = x1135*x82
    x1224 = x1135*x80
    x1225 = x1065*x809
    x1226 = x1065*x807
    x1227 = x264*x642
    x1228 = x264*x645
    x1229 = x1010 - x1012 - x1080 + x1111
    x1230 = -x684 + x685
    x1231 = -x108 + x110
    x1232 = x1225 - x1226 + x1227 - x1228 + x1229 + x1230 + x1231
    x1233 = x778 - x779
    x1234 = 2*x1214 - 2*x1215 + 2*x1216 - 2*x1217 + x1233
    x1235 = -4*p1
    x1236 = 4*m1 + x1235
    x1237 = -x1236
    x1238 = x1011 - x1013 - 2*x1080 + 2*x1111
    x1239 = x769 - x770
    x1240 = 2*x108
    x1241 = 2*x110
    x1242 = -x1240 + x1241
    x1243 = x1167*x870 + x1178*x851 + x1182*x882 + x713*(x1168 + 2*x1204 - 2*x1205 + 2*x1207 - 2*x1208 + 2*x1209 - 2*x1210 + 2*x1211 - 2*x1212 + x1236*x21 + x1237*x36 + x720 + x854) + x760*(x112*x1237 + x114*x1236 + 2*x1221 - 2*x1222 + 2*x1223 - 2*x1224 + 2*x1225 - 2*x1226 + 2*x1227 - 2*x1228 + x1238 + x1239 + x1242) + x772*(-x1177 - x1234)
    x1244 = x1000*x895
    x1245 = x70*x908
    x1246 = x160*x895
    x1247 = -x1002 - x1016 - x1017 + x1019*x898 + x1021*x908 + x1023*x911 + x1025*x898 + x1026*x908 + x1027*x911 + x1029*x914 + x1031*x914 + x1032*x914 + x1057*x912 + x1058*x912 + x1059*x166 + x1059*x912 + x1060*x913 + x1062*x915 + x1245 + x1246 + x194 + x198 + x223*x791 + x254*x900 + x261*x904
    x1248 = x17*x988
    x1249 = x1248*x80
    x1250 = x1248*x82
    x1251 = x1131*x79
    x1252 = x1206*x83
    x1253 = x264*x922
    x1254 = x264*x924
    x1255 = x266*x814
    x1256 = x266*x811
    x1257 = -x1069 + x1102 + x1253 - x1254 + x1255 - x1256 + x216 + x841 + x937
    x1258 = x1248*x90
    x1259 = x1133*x78
    x1260 = x1065*x922
    x1261 = x266*x653
    x1262 = -x1*x19*x200*x29*x479 + x1229 + x1260 + x1261 - x16*x19*x200*x322*x6*x7
    x1263 = -x1143 + x1144 + x674
    x1264 = x1167*x956 + x1178*x962 + x1182*x940 + x713*(x1183 + x1184 - x1185 - x1186 + 2*x1249 - 2*x1250 + 2*x1251 - 2*x1252 + 2*x1253 - 2*x1254 + 2*x1255 - 2*x1256 + x891 + x967) + x760*(x1169 + x1170 - x1171 - x1172 + x1234 + x777) + x772*(2*x1*x16*x28*x31*x72*x987 + 2*x1*x19*x200*x29*x479 - x1238 - 2*x1258 - 2*x1259 - 2*x1260 - 2*x1261 + 2*x13*x17*x7*x72*x987 + 2*x16*x19*x200*x322*x6*x7)
    x1265 = x1000*x969
    x1266 = x70*x980
    x1267 = x16*x195
    x1268 = x160*x969
    x1269 = x1019*x972 + x1021*x980 + x1023*x981 + x1025*x972 + x1026*x980 + x1027*x981 + x1029*x983 + x1031*x983 + x1032*x983 - x1049 - x1050 - x1052 + x1054*x16 + x1055*x16 + x1057*x982 + x1058*x982 + x1059*x982 + x1060*x797 + x1061*x915 + x1266 + x1267 + x1268 + x233*x974 + x261*x978
    x1270 = -3*p2
    x1271 = 3*m2 + x1270
    x1272 = -x1271
    x1273 = x1272*x72
    x1274 = x1273*x2
    x1275 = x1274*x16
    x1276 = -x1274*x4*x83 + x1274*x79 + x1275*x80 - x1275*x82 + x272
    x1277 = x1*x1274
    x1278 = -x1*x1272*x2*x28*x31*x72 - x1272*x13*x16*x2*x7*x72 + x1275*x90 + x1277*x78 + x278
    x1279 = x1274*x4
    x1280 = -x106*x1279 - x1274*x633 + x1277*x82 + x1279*x90 + x283
    x1281 = -x1276*x67 + x1278*x62 - x1280*x56 + x148*x290 + x151*x296 + x155*x314
    x1282 = x178*(-x302*x998 - x303*x997 - x305*x999)
    x1283 = x1282*x143
    x1284 = x1273*x200
    x1285 = x1284*x16
    x1286 = x1036 - x1284*x4*x83 + x1284*x79 + x1285*x80 - x1285*x82
    x1287 = x1*x1284
    x1288 = -x1*x1272*x200*x28*x31*x72 + x1039 - x1272*x13*x16*x200*x7*x72 + x1285*x90 + x1287*x78
    x1289 = x1284*x4
    x1290 = x1044 - x106*x1289 - x1284*x633 + x1287*x82 + x1289*x90
    x1291 = -x1286*x67 + x1288*x62 - x1290*x56 + x224*x290 + x227*x314 + x234*x296
    x1292 = x1282*x245
    x1293 = x296*x70
    x1294 = x1273*x269
    x1295 = x1294*x16
    x1296 = 2*x281
    x1297 = 2*x282
    x1298 = -x1296 + x1297
    x1299 = -x1294*x4*x83 + x1294*x79 + x1295*x80 - x1295*x82 + x1298 + x86
    x1300 = x1*x1294
    x1301 = 2*x1043
    x1302 = 2*x1042
    x1303 = -x1301 + x1302
    x1304 = -x1*x1272*x269*x28*x31*x72 - x1272*x13*x16*x269*x7*x72 + x1295*x90 + x1300*x78 + x1303 + x97
    x1305 = x1294*x4
    x1306 = -x106*x1305 + x117 - x1294*x633 + x1300*x82 + x1305*x90
    x1307 = x197*x269
    x1308 = x162*x306
    x1309 = -x1299*x67 + x1304*x62 - x1306*x56 + x290*x291 + x296*x297 + x300*x314
    x1310 = x164*x269
    x1311 = 2*x290
    x1312 = x166*x269
    x1313 = 2*x314
    x1314 = 2*x296
    x1315 = x1*x315
    x1316 = x315*x4
    x1317 = x16*x315
    x1318 = x1282*x306
    x1319 = x158*x317
    x1320 = 2*x316
    x1321 = x318*x62
    x1322 = x319*x56
    x1323 = x20*x269
    x1324 = x1323*x4
    x1325 = -x1*x19*x269*x321*x322*x9 + x1324 + x318*x365
    x1326 = -x19*x269*x321*x322*x4*x6 + x319*x359 + x331
    x1327 = x1*x317
    x1328 = x269*x39
    x1329 = x1328 + x44
    x1330 = -x1327*x358 + x1329 + x319*x365 + x342
    x1331 = x1325*x56 + x1326*x67 - x1330*x62
    x1332 = x1331 + x290*x337 + x296*x350 + x314*x356
    x1333 = x1282*x381
    x1334 = x349*x70
    x1335 = x162*x381
    x1336 = x1*x290
    x1337 = x314*x4
    x1338 = x16*x296
    x1339 = x104*x1330 + x1056*x349 - x124*x1325 + x1310*x336 + x1312*x385 + x1315*x336 + x1316*x385 + x1317*x349 + x1319*x387 + x1321*x387 + x1322*x387 - x1326*x88 + x1334 + x1335 + x1336*x386 + x1337*x386 + x1338*x386
    x1340 = x1*x1323
    x1341 = x1327*x412 + x1340 - x318*x416
    x1342 = -x1327*x414 + x319*x416 + x404
    x1343 = x1329 - x19*x269*x322*x389*x4*x6 + x319*x412 + x394
    x1344 = -x1341*x56 - x1342*x62 + x1343*x67
    x1345 = x1344 + x290*x398 + x296*x410 + x314*x401
    x1346 = x1282*x428
    x1347 = x409*x70
    x1348 = x162*x428
    x1349 = x104*x1342 + x1056*x409 + x124*x1341 + x1310*x397 + x1312*x432 + x1315*x397 + x1316*x432 + x1317*x409 + x1319*x434 + x1321*x434 + x1322*x434 + x1336*x433 + x1337*x433 + x1338*x433 - x1343*x88 + x1347 + x1348
    x1350 = x1327*x459 - x318*x461
    x1351 = -x449
    x1352 = x1327*x458 + x1340 + x1351 - x16*x19*x269*x322*x436*x7
    x1353 = -x441
    x1354 = x1324 + x1353 + x318*x458 - x319*x459
    x1355 = -x1350*x56 + x1352*x62 - x1354*x67
    x1356 = x1355 + x290*x446 + x296*x453 + x314*x456
    x1357 = x1282*x470
    x1358 = x452*x70
    x1359 = x162*x470
    x1360 = -x104*x1352 + x1056*x452 + x124*x1350 + x1310*x445 + x1312*x474 + x1315*x445 + x1316*x474 + x1317*x452 + x1319*x476 + x1321*x476 + x1322*x476 + x1336*x475 + x1337*x475 + x1338*x475 + x1354*x88 + x1358 + x1359
    x1361 = x269*x32
    x1362 = x1361*x4
    x1363 = -x1327*x518 + x1362 + x318*x513
    x1364 = -x318*x509 + x319*x518 + x489
    x1365 = x269*x33
    x1366 = x1365 + x47
    x1367 = -x1*x19*x269*x28*x478*x479 + x1366 + x319*x513 + x499
    x1368 = -x1363*x56 - x1364*x67 + x1367*x62
    x1369 = x1368 + x290*x488 + x296*x496 + x314*x507
    x1370 = x1282*x529
    x1371 = x534*x70
    x1372 = x162*x529
    x1373 = -x104*x1367 + x1056*x534 + x124*x1363 + x1310*x531 + x1312*x506 + x1315*x531 + x1316*x506 + x1317*x534 + x1319*x536 + x1321*x536 + x1322*x536 + x1336*x535 + x1337*x535 + x1338*x535 + x1364*x88 + x1371 + x1372
    x1374 = x1*x1361
    x1375 = x1327*x563 + x1374 - x19*x25*x269*x4*x479*x538
    x1376 = -x1*x19*x269*x28*x479*x538 + x319*x566 + x549
    x1377 = x1366 - x318*x564 + x319*x563 + x555
    x1378 = x1375*x56 + x1376*x62 - x1377*x67
    x1379 = x1378 + x290*x545 + x296*x561 + x314*x554
    x1380 = x1282*x577
    x1381 = x582*x70
    x1382 = x162*x577
    x1383 = -x104*x1376 + x1056*x582 - x124*x1375 + x1310*x579 + x1312*x553 + x1315*x579 + x1316*x553 + x1317*x582 + x1319*x584 + x1321*x584 + x1322*x584 + x1336*x583 + x1337*x583 + x1338*x583 + x1377*x88 + x1381 + x1382
    x1384 = x1327*x611 - x19*x25*x269*x4*x479*x586
    x1385 = -x595
    x1386 = x1362 + x1385 - x16*x19*x24*x269*x479*x586 + x318*x609
    x1387 = x1327*x609 + x1374 - x319*x613 - x602
    x1388 = x1384*x56 + x1386*x67 - x1387*x62
    x1389 = x1388 + x290*x594 + x296*x599 + x314*x607
    x1390 = x1282*x621
    x1391 = x626*x70
    x1392 = x162*x621
    x1393 = x104*x1387 + x1056*x626 - x124*x1384 + x1310*x623 + x1312*x606 + x1315*x623 + x1316*x606 + x1317*x626 + x1319*x628 + x1321*x628 + x1322*x628 + x1336*x627 + x1337*x627 + x1338*x627 - x1386*x88 + x1391 + x1392
    x1394 = x1273*x16
    x1395 = x1394*x633
    x1396 = x318*x651
    x1397 = x1*x1394
    x1398 = x1397*x82
    x1399 = x318*x653
    x1400 = x1273*x637
    x1401 = x1400*x78
    x1402 = x1400*x83
    x1403 = x319*x642
    x1404 = x319*x645
    x1405 = x1230 + x1403 - x1404
    x1406 = x1401 - x1402 + x1405
    x1407 = x1273*x14
    x1408 = x1407*x78
    x1409 = x1397*x90
    x1410 = x319*x664
    x1411 = x1327*x651
    x1412 = x1329 - x1365 - x275 + x276
    x1413 = -x1*x19*x25*x269*x28*x479 + x1165 + x1410 + x1411 + x1412 - x16*x19*x269*x322*x8
    x1414 = x1407*x82
    x1415 = x1407*x80
    x1416 = x1400*x90
    x1417 = x106*x1400
    x1418 = x318*x664
    x1419 = x318*x660
    x1420 = x1327*x645
    x1421 = x1327*x642
    x1422 = x1324 - x1362 + x1418 - x1419 + x1420 - x1421 - x281 + x282
    x1423 = -x725 + x726
    x1424 = (mpmath.mpf(1)/mpmath.mpf(2))*x13*x16*x19*x269*x9 - x1423 + (mpmath.mpf(1)/mpmath.mpf(2))*x19*x269*x28*x31*x4 - mpmath.mpf(1)/mpmath.mpf(2)*x285 - mpmath.mpf(1)/mpmath.mpf(2)*x286
    x1425 = 2*x1362
    x1426 = 2*x1324
    x1427 = 2*x1398
    x1428 = 2*x1399
    x1429 = 2*x1395
    x1430 = 2*x1396
    x1431 = x1240 - x1241
    x1432 = x1239 + 2*x1401 - 2*x1402 + 2*x1403 - 2*x1404
    x1433 = (mpmath.mpf(1)/mpmath.mpf(2))*x1*x19*x24*x269*x31 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x19*x269*x4*x7 - mpmath.mpf(1)/mpmath.mpf(2)*x292 - mpmath.mpf(1)/mpmath.mpf(2)*x293
    x1434 = x1181 - mpmath.mpf(1)/mpmath.mpf(2)*x269*x91 - mpmath.mpf(1)/mpmath.mpf(2)*x269*x94 + (mpmath.mpf(1)/mpmath.mpf(2))*x298 + (mpmath.mpf(1)/mpmath.mpf(2))*x299
    x1435 = 2*x1328 - 2*x1365 - 2*x275 + 2*x276
    x1436 = x1424*x712 + x1433*x747 + x1434*x759 + x713*(-x1427 - x1428 + x1429 + x1430 + x1431 + x1432) + x760*(x1298 + 2*x1414 - 2*x1415 + 2*x1416 - 2*x1417 + 2*x1418 - 2*x1419 + 2*x1420 - 2*x1421 - x1425 + x1426) + x772*(2*x1*x1272*x13*x16*x7*x72 + 2*x1*x19*x25*x269*x28*x479 - x1193 + 2*x1272*x14*x28*x31*x72 - 2*x1408 - 2*x1409 - 2*x1410 - 2*x1411 - x1435 + 2*x16*x19*x269*x322*x8)
    x1437 = x1282*x782
    x1438 = x70*x794
    x1439 = x1*x197
    x1440 = x162*x782
    x1441 = x316*x62
    x1442 = x316*x56
    x1443 = x1056*x794 + x1310*x785 + x1312*x793 + x1315*x785 + x1316*x793 + x1317*x794 + x1319*x799 + x1321*x799 + x1322*x799 + x1336*x795 + x1337*x795 + x1338*x164 + x1338*x795 + x1438 + x1439 + x1440 + x1441*x796 + x1442*x798 + x290*x787 - x309 - x311 - x312 + x314*x791 + x316*x790
    x1444 = x1273*x15
    x1445 = x1444*x78
    x1446 = x1444*x83
    x1447 = x1394*x4
    x1448 = x1447*x80
    x1449 = x1447*x82
    x1450 = x319*x807
    x1451 = x319*x809
    x1452 = x318*x811
    x1453 = x318*x814
    x1454 = -x836 + x837 - x838 + x839
    x1455 = x1162 + x1412 + x1450 - x1451 + x1452 - x1453 + x1454
    x1456 = x1447*x90
    x1457 = x106*x1447
    x1458 = x1327*x811
    x1459 = x1327*x814
    x1460 = x1458 - x1459 + x683
    x1461 = x1456 - x1457 + x1460
    x1462 = x1444*x90
    x1463 = x106*x1444
    x1464 = x1400*x82
    x1465 = x1400*x80
    x1466 = x1327*x809
    x1467 = x1327*x807
    x1468 = x318*x642
    x1469 = x318*x645
    x1470 = -x1042 + x1043 - x1340 + x1374
    x1471 = x1466 - x1467 + x1468 - x1469 + x1470
    x1472 = 2*x1340
    x1473 = 2*x1374
    x1474 = 2*x1456 - 2*x1457 + 2*x1458 - 2*x1459 + x768
    x1475 = x883 - x884 + x885 - x886
    x1476 = x1424*x870 + x1433*x882 + x1434*x851 + x713*(x1192 + x1435 + 2*x1445 - 2*x1446 + 2*x1448 - 2*x1449 + 2*x1450 - 2*x1451 + 2*x1452 - 2*x1453 + x1475) + x760*(x1301 - x1302 + 2*x1462 - 2*x1463 + 2*x1464 - 2*x1465 + 2*x1466 - 2*x1467 + 2*x1468 - 2*x1469 - x1472 + x1473) + x772*(-x1432 - x1474)
    x1477 = x1282*x895
    x1478 = x70*x911
    x1479 = x197*x4
    x1480 = x162*x895
    x1481 = x158*x316
    x1482 = -x1048 - x1051 - x1053 + x1056*x911 + x1310*x898 + x1312*x908 + x1315*x898 + x1316*x908 + x1317*x911 + x1319*x914 + x1321*x914 + x1322*x914 + x1336*x912 + x1337*x912 + x1338*x166 + x1338*x912 + x1442*x915 + x1478 + x1479 + x1480 + x1481*x913 + x290*x791 + x314*x900 + x316*x904
    x1483 = -2*p2
    x1484 = 2*m2 + x1483
    x1485 = -x1484
    x1486 = x1273*x17
    x1487 = x1486*x80
    x1488 = x1486*x82
    x1489 = x1394*x79
    x1490 = x1447*x83
    x1491 = x318*x922
    x1492 = x318*x924
    x1493 = x319*x814
    x1494 = x319*x811
    x1495 = -x823 + x824
    x1496 = -x1324 + x1362 + x1491 - x1492 + x1493 - x1494 + x1495 + x283 + x647
    x1497 = x106*x1486
    x1498 = x1327*x924
    x1499 = x1486*x90
    x1500 = x1327*x922
    x1501 = x1397*x83
    x1502 = x319*x651
    x1503 = x1397*x78
    x1504 = x319*x653
    x1505 = x1231 - x1396 + x1399
    x1506 = -4*p2
    x1507 = 4*m2 + x1506
    x1508 = -x1507
    x1509 = x1174 - x1175
    x1510 = x852 - x853
    x1511 = x1424*x956 + x1433*x940 + x1434*x962 + x713*(x107*x1507 + x109*x1508 + x1296 - x1297 + x1425 - x1426 + 2*x1487 - 2*x1488 + 2*x1489 - 2*x1490 + 2*x1491 - 2*x1492 + 2*x1493 - 2*x1494 + x1510 + x723) + x760*(x1242 + x1427 + x1428 - x1429 - x1430 + x1474) + x772*(x112*x1507 + x114*x1508 + x1173 + x1303 + x1472 - x1473 + 2*x1497 + 2*x1498 - 2*x1499 - 2*x1500 + 2*x1501 + 2*x1502 - 2*x1503 - 2*x1504 + x1509)
    x1512 = x1282*x969
    x1513 = x70*x981
    x1514 = x162*x969
    x1515 = x16*x164
    x1516 = x16*x166
    x1517 = x1056*x981 - x1293 - x1307 - x1308 + x1310*x972 + x1312*x980 + x1315*x972 + x1316*x980 + x1317*x981 + x1319*x983 + x1321*x983 + x1322*x983 + x1336*x982 + x1337*x982 + x1338*x982 + x1441*x915 + x1481*x797 + x1513 + x1514 + x1515*x290 + x1516*x314 + x194 + x196 + x296*x974 + x316*x978
    x1518 = x148*x336 + x151*x349 + x155*x385 + x370
    x1519 = x178*(-x372*x999 - x376*x998 - x380*x997)
    x1520 = x143*x1519
    x1521 = x1072 + x224*x336 + x227*x385 + x234*x349
    x1522 = x1519*x245
    x1523 = x1331 + x291*x336 + x297*x349 + x300*x385
    x1524 = x1519*x306
    x1525 = x12**(mpmath.mpf(-5)/mpmath.mpf(2))
    x1526 = 3*n0 + x73
    x1527 = -x1526
    x1528 = x1525*x1527
    x1529 = x1528*x321
    x1530 = x182*x6
    x1531 = x1529*x9
    x1532 = x1529*x6
    x1533 = x323*x6
    x1534 = x1533*x4
    x1535 = -x1534 + x334
    x1536 = x16*x822
    x1537 = x1536 - x329
    x1538 = x1535 + x1537
    x1539 = x1529*x1530 - x1531*x184 + x1531*x83 - x1532*x80 + x1538
    x1540 = x1*x43
    x1541 = x1529*x7
    x1542 = x1*x1533
    x1543 = -x1542 + x845
    x1544 = x16*x672
    x1545 = x1544 - x352
    x1546 = x1543 + x1545
    x1547 = x16*x324
    x1548 = 2*x1547
    x1549 = x321*x328
    x1550 = 2*x1549
    x1551 = -x1548 + x1550
    x1552 = -x1525*x1527*x16*x321*x43*x7 - x1525*x1527*x25*x31*x321*x6 + x1532*x1540 + x1541*x83 + x1546 + x1551
    x1553 = x4*x672
    x1554 = x1553 - x340
    x1555 = x1*x822
    x1556 = -x1555 + x345
    x1557 = x1554 + x1556
    x1558 = x324*x4
    x1559 = 2*x1558
    x1560 = x321*x339
    x1561 = 2*x1560
    x1562 = -x1559 + x1561
    x1563 = x1531*x1540 - x1531*x90 - x1541*x182 + x1541*x80 + x1557 + x1562
    x1564 = x1*x336
    x1565 = 2*x386
    x1566 = x385*x4
    x1567 = x16*x349
    x1568 = x1519*x381
    x1569 = -x1539*x67 + x1552*x62 - x1563*x56 + x336*x337 + x349*x350 + x356*x385
    x1570 = x1528*x389
    x1571 = x1570*x9
    x1572 = x1570*x6
    x1573 = -x1547 + x1549
    x1574 = x1530*x1570 - x1571*x184 + x1571*x83 - x1572*x80 + x1573
    x1575 = x1570*x7
    x1576 = x328*x389
    x1577 = x16*x390
    x1578 = x1576 - x1577
    x1579 = -x1525*x1527*x16*x389*x43*x7 - x1525*x1527*x25*x31*x389*x6 + x1540*x1572 + x1575*x83 + x1578
    x1580 = x1*x324
    x1581 = x321*x344
    x1582 = x1580 - x1581
    x1583 = x339*x389
    x1584 = x390*x4
    x1585 = x1583 - x1584
    x1586 = x1582 + x1585
    x1587 = x1540*x1571 - x1571*x90 - x1575*x182 + x1575*x80 + x1586
    x1588 = -x1574*x67 + x1579*x62 - x1587*x56 + x336*x398 + x349*x410 + x385*x401
    x1589 = x1519*x428
    x1590 = x1*x386
    x1591 = x386*x4
    x1592 = x16*x386
    x1593 = x1564*x433 + x1566*x433 + x1567*x433 + x1590*x397 + x1591*x432 + x1592*x409
    x1594 = x1528*x436
    x1595 = x1594*x9
    x1596 = x1594*x6
    x1597 = x1558 - x1560
    x1598 = x1530*x1594 - x1595*x184 + x1595*x83 - x1596*x80 + x1597
    x1599 = x1594*x7
    x1600 = x328*x436
    x1601 = x16*x437
    x1602 = x1600 - x1601
    x1603 = x1582 + x1602
    x1604 = -x1525*x1527*x16*x43*x436*x7 - x1525*x1527*x25*x31*x436*x6 + x1540*x1596 + x1599*x83 + x1603
    x1605 = x339*x436
    x1606 = x4*x437
    x1607 = x1605 - x1606
    x1608 = x1540*x1595 - x1595*x90 - x1599*x182 + x1599*x80 + x1607
    x1609 = -x1598*x67 + x1604*x62 - x1608*x56 + x336*x446 + x349*x453 + x385*x456
    x1610 = x1519*x470
    x1611 = x1564*x475 + x1566*x475 + x1567*x475 + x1590*x445 + x1591*x474 + x1592*x452
    x1612 = -x358*x518 + x359*x509
    x1613 = x321*x327
    x1614 = x1613*x9
    x1615 = -x1614
    x1616 = x1615 - x359*x513 + x365*x518 + x486
    x1617 = x321*x333
    x1618 = -x1617
    x1619 = x1618 - x25*x321*x322*x478*x479*x6 + x365*x509 + x501
    x1620 = -x1612*x67 - x1616*x56 + x1619*x62
    x1621 = x1620 + x336*x488 + x349*x496 + x385*x507
    x1622 = x1519*x529
    x1623 = -x104*x1619 + x124*x1616 + x1564*x535 + x1566*x535 + x1567*x535 + x1590*x531 + x1591*x506 + x1592*x534 + x1612*x88
    x1624 = x1617 - x28*x321*x322*x479*x538*x9 + x358*x563
    x1625 = -x25*x321*x322*x479*x538*x6 + x365*x564 + x551
    x1626 = x1613*x7
    x1627 = x1626 + x50
    x1628 = x1627 - x359*x566 + x365*x563 + x543
    x1629 = x1624*x67 + x1625*x62 - x1628*x56
    x1630 = x1629 + x336*x545 + x349*x561 + x385*x554
    x1631 = x1519*x577
    x1632 = -x104*x1625 + x124*x1628 + x1564*x583 + x1566*x583 + x1567*x583 + x1590*x579 + x1591*x553 + x1592*x582 - x1624*x88
    x1633 = x1614 - x358*x611 + x359*x609
    x1634 = -x359*x613 + x365*x611 + x591
    x1635 = x1627 - x25*x321*x322*x479*x586*x6 + x365*x609 + x604
    x1636 = -x1633*x67 - x1634*x56 + x1635*x62
    x1637 = x1636 + x336*x594 + x349*x599 + x385*x607
    x1638 = x1519*x621
    x1639 = -x104*x1635 + x124*x1634 + x1564*x627 + x1566*x627 + x1567*x627 + x1590*x623 + x1591*x606 + x1592*x626 + x1633*x88
    x1640 = x1528*x7
    x1641 = x1530*x1640
    x1642 = x1640*x6
    x1643 = x1642*x80
    x1644 = x1528*x644
    x1645 = x1644*x83
    x1646 = x1644*x184
    x1647 = x358*x796
    x1648 = x358*x642
    x1649 = -x1536 + x329
    x1650 = x1647 - x1648 + x1649
    x1651 = x1645 - x1646 + x1650
    x1652 = x359*x653
    x1653 = x359*x798
    x1654 = x1534 - x334
    x1655 = x1652 - x1653 + x1654
    x1656 = 2*n0 + x630
    x1657 = x16*x323
    x1658 = -x1656
    x1659 = x1528*x8
    x1660 = x1659*x184
    x1661 = x358*x664
    x1662 = x358*x789
    x1663 = x1659*x83
    x1664 = x365*x798
    x1665 = x1642*x90
    x1666 = x1540*x1642
    x1667 = x365*x653
    x1668 = x1*x39
    x1669 = x1668 - x701
    x1670 = x323*x4
    x1671 = x1659*x80
    x1672 = x1659*x182
    x1673 = x1540*x1644
    x1674 = x1644*x90
    x1675 = x359*x789
    x1676 = x359*x664
    x1677 = x365*x642
    x1678 = x365*x796
    x1679 = x1555 - x345
    x1680 = x20*x637
    x1681 = -x1680 + x706
    x1682 = x1597 + x1614 + x1675 - x1676 + x1677 - x1678 + x1679 + x1681 - x331
    x1683 = (mpmath.mpf(1)/mpmath.mpf(2))*x16*x321*x322*x43*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x24*x31*x321*x322*x6 - mpmath.mpf(1)/mpmath.mpf(2)*x326 - mpmath.mpf(1)/mpmath.mpf(2)*x330
    x1684 = 2*x1653
    x1685 = 2*x1643
    x1686 = 2*x1641
    x1687 = 2*x1652
    x1688 = 2*x334
    x1689 = 2*x1534
    x1690 = -x1688 + x1689
    x1691 = 2*x1536
    x1692 = 2*x329
    x1693 = -x1691 + x1692
    x1694 = 2*x1645 - 2*x1646 + 2*x1647 - 2*x1648 + x1693
    x1695 = (mpmath.mpf(1)/mpmath.mpf(2))*x51
    x1696 = (mpmath.mpf(1)/mpmath.mpf(2))*x347
    x1697 = x1695 - x1696
    x1698 = -x1697 + (mpmath.mpf(1)/mpmath.mpf(2))*x25*x31*x321*x322*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x321*x322*x4*x43*x7 - mpmath.mpf(1)/mpmath.mpf(2)*x338 - mpmath.mpf(1)/mpmath.mpf(2)*x341
    x1699 = (mpmath.mpf(1)/mpmath.mpf(2))*x60
    x1700 = (mpmath.mpf(1)/mpmath.mpf(2))*x354
    x1701 = x1699 - x1700
    x1702 = -mpmath.mpf(1)/mpmath.mpf(2)*x16*x342 + x1701 - mpmath.mpf(1)/mpmath.mpf(2)*x321*x845 + (mpmath.mpf(1)/mpmath.mpf(2))*x351 + (mpmath.mpf(1)/mpmath.mpf(2))*x353
    x1703 = 4*n0 + x761
    x1704 = -x1703
    x1705 = 2*x331
    x1706 = 2*x1614
    x1707 = 2*x345
    x1708 = 2*x1555
    x1709 = -x1707 + x1708
    x1710 = 2*x1680
    x1711 = 2*x706
    x1712 = -x1710 + x1711
    x1713 = 2*x1617
    x1714 = 2*x325
    x1715 = 2*x701
    x1716 = 2*x1668
    x1717 = -x1715 + x1716
    x1718 = 2*x1542
    x1719 = 2*x845
    x1720 = -x1718 + x1719
    x1721 = x1683*x712 + x1698*x747 + x1702*x759 + x713*(-x1684 - x1685 + x1686 + x1687 + x1690 + x1694) + x760*(x1559 - x1561 + x1670*x1704 + 2*x1671 - 2*x1672 + 2*x1673 - 2*x1674 + 2*x1675 - 2*x1676 + 2*x1677 - 2*x1678 + x1703*x339 - x1705 + x1706 + x1709 + x1712) + x772*(x1551 + x1657*x1703 + 2*x1660 + 2*x1661 - 2*x1662 - 2*x1663 + 2*x1664 + 2*x1665 - 2*x1666 - 2*x1667 + x1704*x328 - x1713 + x1714 + x1717 + x1720)
    x1722 = x1519*x782
    x1723 = x387*x62
    x1724 = x387*x56
    x1725 = x1515*x349 + x1564*x795 + x1566*x795 + x1567*x795 + x1590*x785 + x1591*x793 + x1592*x794 + x1723*x796 + x1724*x798 + x336*x787 - x383 - x384 + x385*x791 + x387*x790
    x1726 = x10*x1528
    x1727 = x1726*x83
    x1728 = x1726*x184
    x1729 = x1528*x9
    x1730 = x1530*x1729
    x1731 = x1729*x6
    x1732 = x1731*x80
    x1733 = x358*x903
    x1734 = x358*x807
    x1735 = x359*x814
    x1736 = x359*x915
    x1737 = x1547 - x1549 + x1617 - x325
    x1738 = x1733 - x1734 + x1735 - x1736 + x1737
    x1739 = x1540*x1731
    x1740 = x1731*x90
    x1741 = x365*x814
    x1742 = x365*x915
    x1743 = x39*x4
    x1744 = -x1743 + x848
    x1745 = x1741 - x1742 + x1744
    x1746 = x1739 - x1740 + x1745
    x1747 = x1540*x1726
    x1748 = x1726*x90
    x1749 = x1644*x80
    x1750 = x1644*x182
    x1751 = x365*x807
    x1752 = x365*x903
    x1753 = x359*x796
    x1754 = x359*x642
    x1755 = x339*x9
    x1756 = x4*x822
    x1757 = x1755 - x1756 + x859 - x861
    x1758 = -x50
    x1759 = x1758 + x44
    x1760 = -x1580 + x1581 - x1626 + x1759 + x342
    x1761 = x1751 - x1752 + x1753 - x1754 + x1757 + x1760
    x1762 = 2*x1743
    x1763 = 2*x848
    x1764 = -x1762 + x1763
    x1765 = 2*x1739 - 2*x1740 + 2*x1741 - 2*x1742 + x1764
    x1766 = 2*x861
    x1767 = 2*x859
    x1768 = 2*x1756
    x1769 = 2*x1755
    x1770 = -x1766 + x1767 - x1768 + x1769
    x1771 = 2*x50
    x1772 = -x1771
    x1773 = x1772 + x888
    x1774 = -2*x1580 + 2*x1581 - 2*x1626 + x1773 + 2*x342
    x1775 = x1683*x870 + x1698*x882 + x1702*x851 + x713*(x1548 - x1550 + x1713 - x1714 + 2*x1727 - 2*x1728 + 2*x1730 - 2*x1732 + 2*x1733 - 2*x1734 + 2*x1735 - 2*x1736) + x760*(2*x1747 - 2*x1748 + 2*x1749 - 2*x1750 + 2*x1751 - 2*x1752 + 2*x1753 - 2*x1754 + x1770 + x1774) + x772*(-x1694 - x1765)
    x1776 = x1519*x895
    x1777 = x158*x387
    x1778 = -x1075 - x1076 + x1516*x349 + x1564*x912 + x1566*x912 + x1567*x912 + x1590*x898 + x1591*x908 + x1592*x911 + x1724*x915 + x1777*x913 + x336*x791 + x385*x900 + x387*x904
    x1779 = x11*x1528
    x1780 = x1779*x182
    x1781 = x1779*x80
    x1782 = x1731*x83
    x1783 = x1731*x184
    x1784 = x359*x924
    x1785 = x359*x977
    x1786 = x358*x915
    x1787 = x358*x814
    x1788 = -x1558 + x1560 + x1615 + x1784 - x1785 + x1786 - x1787 + x331
    x1789 = x1540*x1779
    x1790 = x1642*x83
    x1791 = x365*x924
    x1792 = x358*x798
    x1793 = x1533*x16
    x1794 = -x1793 - x942 + x950 + x954
    x1795 = -x17*x19*x321*x322*x7 + x1760 + x1791 + x1792 + x1794 - x25*x28*x321*x322*x479*x6
    x1796 = x1535 - x1652 + x1653
    x1797 = x1688 - x1689
    x1798 = 2*x942
    x1799 = 2*x950
    x1800 = 2*x1793
    x1801 = 2*x954
    x1802 = -x1798 + x1799 - x1800 + x1801
    x1803 = x1683*x956 + x1698*x940 + x1702*x962 + x713*(x1562 + x1705 - x1706 + 2*x1780 - 2*x1781 + 2*x1782 - 2*x1783 + 2*x1784 - 2*x1785 + 2*x1786 - 2*x1787) + x760*(x1684 + x1685 - x1686 - x1687 + x1765 + x1797) + x772*(2*x11*x1525*x1527*x25*x31 + 2*x1525*x1527*x16*x43*x6*x7 + 2*x17*x19*x321*x322*x7 - x1774 - 2*x1789 - 2*x1790 - 2*x1791 - 2*x1792 - x1802 + 2*x25*x28*x321*x322*x479*x6)
    x1804 = x1519*x969
    x1805 = -x1334 - x1335 + x1515*x336 + x1516*x385 + x1564*x982 + x1566*x982 + x1567*x982 + x1590*x972 + x1591*x980 + x1592*x981 + x1723*x915 + x1777*x797 + x349*x974 + x387*x978
    x1806 = x148*x397 + x151*x409 + x155*x432 + x420
    x1807 = x178*(-x422*x997 - x426*x998 - x427*x999)
    x1808 = x143*x1807
    x1809 = x1082 + x224*x397 + x227*x432 + x234*x409
    x1810 = x1807*x245
    x1811 = x1344 + x291*x397 + x297*x409 + x300*x432
    x1812 = x1807*x306
    x1813 = 3*n1 + x985
    x1814 = -x1813
    x1815 = x1525*x1814
    x1816 = x1815*x321
    x1817 = x1816*x9
    x1818 = x1816*x6
    x1819 = x1530*x1816 + x1573 - x1817*x184 + x1817*x83 - x1818*x80
    x1820 = x1816*x7
    x1821 = -x1525*x16*x1814*x321*x43*x7 - x1525*x1814*x25*x31*x321*x6 + x1540*x1818 + x1578 + x1820*x83
    x1822 = x1540*x1817 + x1586 - x1817*x90 - x182*x1820 + x1820*x80
    x1823 = -x1819*x67 + x1821*x62 - x1822*x56 + x337*x397 + x350*x409 + x356*x432
    x1824 = x1807*x381
    x1825 = x1815*x389
    x1826 = x1825*x6
    x1827 = x1825*x7
    x1828 = -x1525*x16*x1814*x389*x43*x7 - x1525*x1814*x25*x31*x389*x6 + x1540*x1826 + x1546 + x1827*x83
    x1829 = 2*x1577
    x1830 = 2*x1576
    x1831 = x1825*x9
    x1832 = x1530*x1825 + x1538 - x1826*x80 - x1829 + x1830 - x1831*x184 + x1831*x83
    x1833 = x344*x389
    x1834 = 2*x1833
    x1835 = x1*x390
    x1836 = 2*x1835
    x1837 = x1540*x1831 + x1557 - x182*x1827 + x1827*x80 - x1831*x90 - x1834 + x1836
    x1838 = x4*x433
    x1839 = x1*x433
    x1840 = x16*x433
    x1841 = x1807*x428
    x1842 = x1828*x62 - x1832*x67 - x1837*x56 + x397*x398 + x401*x432 + x409*x410
    x1843 = x1815*x436
    x1844 = x1843*x9
    x1845 = x1843*x6
    x1846 = -x1583 + x1584
    x1847 = x1602 + x1846
    x1848 = x1530*x1843 - x184*x1844 + x1844*x83 - x1845*x80 + x1847
    x1849 = x1843*x7
    x1850 = -x1833 + x1835
    x1851 = -x1525*x16*x1814*x43*x436*x7 - x1525*x1814*x25*x31*x436*x6 + x1540*x1845 + x1849*x83 + x1850
    x1852 = x1*x437
    x1853 = x344*x436
    x1854 = x1852 - x1853
    x1855 = x1540*x1844 - x182*x1849 - x1844*x90 + x1849*x80 + x1854
    x1856 = -x1848*x67 + x1851*x62 - x1855*x56 + x397*x446 + x409*x453 + x432*x456
    x1857 = x1807*x470
    x1858 = x1*x397
    x1859 = x4*x432
    x1860 = x16*x409
    x1861 = x1838*x474 + x1839*x445 + x1840*x452 + x1858*x475 + x1859*x475 + x1860*x475
    x1862 = x333*x389
    x1863 = x1862 + x414*x513 - x416*x509
    x1864 = x412*x509 - x414*x518 + x501
    x1865 = x327*x389
    x1866 = x1865*x9
    x1867 = x1866 + x50
    x1868 = x1867 - x24*x322*x389*x478*x479*x7 + x412*x513 + x491
    x1869 = -x1863*x62 - x1864*x67 + x1868*x56
    x1870 = x1869 + x397*x488 + x409*x496 + x432*x507
    x1871 = x1807*x529
    x1872 = x104*x1863 - x124*x1868 + x1838*x506 + x1839*x531 + x1840*x534 + x1858*x535 + x1859*x535 + x1860*x535 + x1864*x88
    x1873 = -x25*x322*x389*x479*x538*x6 + x416*x564
    x1874 = -x1862 + x412*x564 - x414*x563 + x551
    x1875 = x1865*x7
    x1876 = -x547
    x1877 = x1875 + x1876 - x412*x566 + x416*x563
    x1878 = x1873*x62 - x1874*x67 - x1877*x56
    x1879 = x1878 + x397*x545 + x409*x561 + x432*x554
    x1880 = x1807*x577
    x1881 = -x104*x1873 + x124*x1877 + x1838*x553 + x1839*x579 + x1840*x582 + x1858*x583 + x1859*x583 + x1860*x583 + x1874*x88
    x1882 = x1875 - x25*x322*x389*x479*x586*x6 + x416*x609
    x1883 = -x24*x322*x389*x479*x586*x7 + x412*x613 + x597
    x1884 = x1867 + x412*x609 - x414*x611 + x604
    x1885 = x1882*x62 + x1883*x56 - x1884*x67
    x1886 = x1885 + x397*x594 + x409*x599 + x432*x607
    x1887 = x1807*x621
    x1888 = -x104*x1882 - x124*x1883 + x1838*x606 + x1839*x623 + x1840*x626 + x1858*x627 + x1859*x627 + x1860*x627 + x1884*x88
    x1889 = x1815*x7
    x1890 = x1530*x1889
    x1891 = x1889*x6
    x1892 = x1891*x80
    x1893 = x1815*x644
    x1894 = x1893*x83
    x1895 = x184*x1893
    x1896 = x414*x796
    x1897 = x414*x642
    x1898 = -x1544 + x352
    x1899 = x1896 - x1897 + x1898
    x1900 = x1894 - x1895 + x1899
    x1901 = x412*x653
    x1902 = x412*x798
    x1903 = -x1668 + x701
    x1904 = x1901 - x1902 + x1903
    x1905 = x1815*x8
    x1906 = x1905*x83
    x1907 = x1540*x1891
    x1908 = x414*x789
    x1909 = x416*x653
    x1910 = -x1576 + x1577 + x1862 - x391
    x1911 = -x1*x16*x19*x322*x389*x7 + x1908 + x1909 + x1910 - x26*x322*x389*x479*x6
    x1912 = x1905*x80
    x1913 = x182*x1905
    x1914 = x1540*x1893
    x1915 = x1893*x90
    x1916 = x412*x789
    x1917 = x412*x664
    x1918 = x416*x642
    x1919 = x416*x796
    x1920 = x1*x672
    x1921 = x344*x7
    x1922 = x1920 - x1921 - x733 + x735 + x841
    x1923 = x1846 + x1867 + x1916 - x1917 + x1918 - x1919 + x1922 - x394
    x1924 = (mpmath.mpf(1)/mpmath.mpf(2))*x16*x322*x389*x43*x9 - x1701 + (mpmath.mpf(1)/mpmath.mpf(2))*x24*x31*x322*x389*x6 - mpmath.mpf(1)/mpmath.mpf(2)*x392 - mpmath.mpf(1)/mpmath.mpf(2)*x393
    x1925 = x1829 - x1830 + 2*x1862 - 2*x391
    x1926 = 2*x1902
    x1927 = 2*x1892
    x1928 = 2*x1890
    x1929 = 2*x1901
    x1930 = x1715 - x1716
    x1931 = 2*x1544
    x1932 = 2*x352
    x1933 = -x1931 + x1932
    x1934 = 2*x1894 - 2*x1895 + 2*x1896 - 2*x1897 + x1933
    x1935 = -mpmath.mpf(1)/mpmath.mpf(2)*x16*x404 - mpmath.mpf(1)/mpmath.mpf(2)*x389*x845 + (mpmath.mpf(1)/mpmath.mpf(2))*x399 + (mpmath.mpf(1)/mpmath.mpf(2))*x400
    x1936 = (mpmath.mpf(1)/mpmath.mpf(2))*x407
    x1937 = (mpmath.mpf(1)/mpmath.mpf(2))*x55
    x1938 = x1936 - x1937
    x1939 = -x1938 + (mpmath.mpf(1)/mpmath.mpf(2))*x25*x31*x322*x389*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x322*x389*x4*x43*x7 - mpmath.mpf(1)/mpmath.mpf(2)*x402 - mpmath.mpf(1)/mpmath.mpf(2)*x403
    x1940 = 2*x394
    x1941 = 2*x1583
    x1942 = 2*x1584
    x1943 = 2*x1866
    x1944 = 2*x733
    x1945 = 2*x735
    x1946 = 2*x1921
    x1947 = 2*x1920
    x1948 = x1771 + x889
    x1949 = -x1944 + x1945 - x1946 + x1947 + x1948
    x1950 = x1924*x712 + x1935*x759 + x1939*x747 + x713*(-x1926 - x1927 + x1928 + x1929 + x1930 + x1934) + x760*(2*x1912 - 2*x1913 + 2*x1914 - 2*x1915 + 2*x1916 - 2*x1917 + 2*x1918 - 2*x1919 - x1940 - x1941 + x1942 + x1943 + x1949) + x772*(2*x1*x16*x19*x322*x389*x7 + 2*x1525*x16*x1814*x43*x8 + 2*x1525*x1814*x25*x31*x6*x7 - 2*x1906 - 2*x1907 - 2*x1908 - 2*x1909 - x1925 + 2*x26*x322*x389*x479*x6)
    x1951 = x1807*x782
    x1952 = x434*x62
    x1953 = x434*x56
    x1954 = x1515*x409 + x1838*x793 + x1839*x785 + x1840*x794 + x1858*x795 + x1859*x795 + x1860*x795 + x1952*x796 + x1953*x798 + x397*x787 - x430 - x431 + x432*x791 + x434*x790
    x1955 = 2*n1 + x1200
    x1956 = -x1955
    x1957 = x10*x1815
    x1958 = x1957*x83
    x1959 = x184*x1957
    x1960 = x1815*x9
    x1961 = x1530*x1960
    x1962 = x1960*x6
    x1963 = x1962*x80
    x1964 = x414*x903
    x1965 = x414*x807
    x1966 = x412*x814
    x1967 = x412*x915
    x1968 = x1654 + x1744 + x1910 + x1964 - x1965 + x1966 - x1967
    x1969 = x1540*x1962
    x1970 = x1962*x90
    x1971 = x416*x814
    x1972 = x416*x915
    x1973 = x1542 - x845
    x1974 = x1971 - x1972 + x1973
    x1975 = x1969 - x1970 + x1974
    x1976 = x1*x323
    x1977 = x1540*x1957
    x1978 = x1957*x90
    x1979 = x1893*x80
    x1980 = x182*x1893
    x1981 = x416*x807
    x1982 = x416*x903
    x1983 = x412*x796
    x1984 = x412*x642
    x1985 = x1833 - x1835 - x1875 + x404
    x1986 = x1680 - x706
    x1987 = -x1553 + x340
    x1988 = x1981 - x1982 + x1983 - x1984 + x1985 + x1986 + x1987
    x1989 = x1718 - x1719
    x1990 = 2*x1969 - 2*x1970 + 2*x1971 - 2*x1972 + x1989
    x1991 = 4*n1 + x1235
    x1992 = -x1991
    x1993 = x1834 - x1836 - 2*x1875 + 2*x404
    x1994 = x1710 - x1711
    x1995 = 2*x1553
    x1996 = 2*x340
    x1997 = -x1995 + x1996
    x1998 = x1924*x870 + x1935*x851 + x1939*x882 + x713*(x1657*x1992 + x1690 + x1764 + x1925 + 2*x1958 - 2*x1959 + 2*x1961 - 2*x1963 + 2*x1964 - 2*x1965 + 2*x1966 - 2*x1967 + x1991*x328) + x760*(x1976*x1991 + 2*x1977 - 2*x1978 + 2*x1979 - 2*x1980 + 2*x1981 - 2*x1982 + 2*x1983 - 2*x1984 + x1992*x344 + x1993 + x1994 + x1997) + x772*(-x1934 - x1990)
    x1999 = x1807*x895
    x2000 = x158*x434
    x2001 = -x1085 - x1086 + x1516*x409 + x1838*x908 + x1839*x898 + x1840*x911 + x1858*x912 + x1859*x912 + x1860*x912 + x1953*x915 + x2000*x913 + x397*x791 + x432*x900 + x434*x904
    x2002 = x11*x1815
    x2003 = x182*x2002
    x2004 = x2002*x80
    x2005 = x1962*x83
    x2006 = x184*x1962
    x2007 = x412*x924
    x2008 = x412*x977
    x2009 = x414*x915
    x2010 = x414*x814
    x2011 = x1585 + x1759 + x1794 - x1866 + x2007 - x2008 + x2009 - x2010 + x394
    x2012 = x1540*x2002
    x2013 = x1891*x83
    x2014 = x416*x924
    x2015 = x414*x798
    x2016 = -x17*x19*x322*x389*x7 + x1985 + x2014 + x2015 - x25*x28*x322*x389*x479*x6
    x2017 = x1669 - x1901 + x1902
    x2018 = x1924*x956 + x1935*x962 + x1939*x940 + x713*(x1773 + x1802 + x1940 + x1941 - x1942 - x1943 + 2*x2003 - 2*x2004 + 2*x2005 - 2*x2006 + 2*x2007 - 2*x2008 + 2*x2009 - 2*x2010) + x760*(x1717 + x1926 + x1927 - x1928 - x1929 + x1990) + x772*(2*x11*x1525*x1814*x25*x31 + 2*x1525*x16*x1814*x43*x6*x7 + 2*x17*x19*x322*x389*x7 - x1993 - 2*x2012 - 2*x2013 - 2*x2014 - 2*x2015 + 2*x25*x28*x322*x389*x479*x6)
    x2019 = x1807*x969
    x2020 = -x1347 - x1348 + x1515*x397 + x1516*x432 + x1838*x980 + x1839*x972 + x1840*x981 + x1858*x982 + x1859*x982 + x1860*x982 + x1952*x915 + x2000*x797 + x409*x974 + x434*x978
    x2021 = x148*x445 + x151*x452 + x155*x474 + x464
    x2022 = x178*(-x466*x998 - x467*x997 - x469*x999)
    x2023 = x143*x2022
    x2024 = x1091 + x224*x445 + x227*x474 + x234*x452
    x2025 = x2022*x245
    x2026 = x1355 + x291*x445 + x297*x452 + x300*x474
    x2027 = x2022*x306
    x2028 = 3*n2 + x1270
    x2029 = -x2028
    x2030 = x1525*x2029
    x2031 = x2030*x321
    x2032 = x2031*x9
    x2033 = x2031*x6
    x2034 = x1530*x2031 + x1597 - x184*x2032 + x2032*x83 - x2033*x80
    x2035 = x2031*x7
    x2036 = -x1525*x16*x2029*x321*x43*x7 - x1525*x2029*x25*x31*x321*x6 + x1540*x2033 + x1603 + x2035*x83
    x2037 = x1540*x2032 + x1607 - x182*x2035 - x2032*x90 + x2035*x80
    x2038 = -x2034*x67 + x2036*x62 - x2037*x56 + x337*x445 + x350*x452 + x356*x474
    x2039 = x2022*x381
    x2040 = x2030*x389
    x2041 = x2040*x9
    x2042 = x2040*x6
    x2043 = x1530*x2040 - x184*x2041 + x1847 + x2041*x83 - x2042*x80
    x2044 = x2040*x7
    x2045 = -x1525*x16*x2029*x389*x43*x7 - x1525*x2029*x25*x31*x389*x6 + x1540*x2042 + x1850 + x2044*x83
    x2046 = x1540*x2041 - x182*x2044 + x1854 - x2041*x90 + x2044*x80
    x2047 = -x2043*x67 + x2045*x62 - x2046*x56 + x398*x445 + x401*x474 + x410*x452
    x2048 = x2022*x428
    x2049 = x2030*x436
    x2050 = x2049*x9
    x2051 = x2049*x7
    x2052 = x1540*x2050 + x1557 - x182*x2051 - x2050*x90 + x2051*x80
    x2053 = x2049*x6
    x2054 = 2*x1605
    x2055 = 2*x1606
    x2056 = -x2054 + x2055
    x2057 = x1530*x2049 + x1538 - x184*x2050 + x2050*x83 - x2053*x80 + x2056
    x2058 = 2*x1853
    x2059 = 2*x1852
    x2060 = -x2058 + x2059
    x2061 = -x1525*x16*x2029*x43*x436*x7 - x1525*x2029*x25*x31*x436*x6 + x1540*x2053 + x1546 + x2051*x83 + x2060
    x2062 = x16*x475
    x2063 = x1*x475
    x2064 = x4*x475
    x2065 = x2022*x470
    x2066 = -x2052*x56 - x2057*x67 + x2061*x62 + x445*x446 + x452*x453 + x456*x474
    x2067 = x327*x436
    x2068 = x2067*x9
    x2069 = x2068 - x24*x322*x436*x478*x479*x7 + x459*x513
    x2070 = -x28*x322*x436*x478*x479*x9 + x458*x518 + x486
    x2071 = x333*x436
    x2072 = x2071 + x50
    x2073 = x2072 + x458*x513 - x461*x509 + x491
    x2074 = x2069*x56 + x2070*x67 - x2073*x62
    x2075 = x2074 + x445*x488 + x452*x496 + x474*x507
    x2076 = x2022*x529
    x2077 = x1*x445
    x2078 = x4*x474
    x2079 = x16*x452
    x2080 = x104*x2073 - x124*x2069 + x2062*x534 + x2063*x531 + x2064*x506 - x2070*x88 + x2077*x535 + x2078*x535 + x2079*x535
    x2081 = x2067*x7
    x2082 = x2081 - x459*x566 + x461*x563
    x2083 = x458*x566 - x461*x564 + x547
    x2084 = x2072 - x28*x322*x436*x479*x538*x9 + x458*x563 + x543
    x2085 = -x2082*x56 - x2083*x62 + x2084*x67
    x2086 = x2085 + x445*x545 + x452*x561 + x474*x554
    x2087 = x2022*x577
    x2088 = x104*x2083 + x124*x2082 + x2062*x582 + x2063*x579 + x2064*x553 + x2077*x583 + x2078*x583 + x2079*x583 - x2084*x88
    x2089 = -x459*x613 + x461*x611
    x2090 = -x597
    x2091 = x2081 + x2090 - x25*x322*x436*x479*x586*x6 + x461*x609
    x2092 = -x591
    x2093 = x2068 + x2092 - x458*x611 + x459*x609
    x2094 = -x2089*x56 + x2091*x62 - x2093*x67
    x2095 = x2094 + x445*x594 + x452*x599 + x474*x607
    x2096 = x2022*x621
    x2097 = -x104*x2091 + x124*x2089 + x2062*x626 + x2063*x623 + x2064*x606 + x2077*x627 + x2078*x627 + x2079*x627 + x2093*x88
    x2098 = x2030*x7
    x2099 = x1530*x2098
    x2100 = x2098*x6
    x2101 = x2100*x80
    x2102 = x2030*x644
    x2103 = x2102*x83
    x2104 = x184*x2102
    x2105 = x458*x796
    x2106 = x458*x642
    x2107 = x1986 + x2105 - x2106
    x2108 = x2103 - x2104 + x2107
    x2109 = x459*x653
    x2110 = x459*x798
    x2111 = x1554 + x2109 - x2110
    x2112 = x2030*x8
    x2113 = x2112*x83
    x2114 = x1540*x2100
    x2115 = x458*x789
    x2116 = x461*x653
    x2117 = -x1600 + x1601 + x2072 - x438
    x2118 = -x1*x16*x19*x322*x436*x7 + x1922 + x2115 + x2116 + x2117 - x26*x322*x436*x479*x6
    x2119 = x2112*x80
    x2120 = x182*x2112
    x2121 = x1540*x2102
    x2122 = x2102*x90
    x2123 = x459*x789
    x2124 = x459*x664
    x2125 = x461*x642
    x2126 = x461*x796
    x2127 = x1353 - x1605 + x1606 + x2068 + x2123 - x2124 + x2125 - x2126
    x2128 = -x1695 + x1696
    x2129 = (mpmath.mpf(1)/mpmath.mpf(2))*x16*x322*x43*x436*x9 - x2128 + (mpmath.mpf(1)/mpmath.mpf(2))*x24*x31*x322*x436*x6 - mpmath.mpf(1)/mpmath.mpf(2)*x439 - mpmath.mpf(1)/mpmath.mpf(2)*x440
    x2130 = 2*x441
    x2131 = 2*x2068
    x2132 = 2*x2110
    x2133 = 2*x2101
    x2134 = 2*x2099
    x2135 = 2*x2109
    x2136 = x1995 - x1996
    x2137 = x1994 + 2*x2103 - 2*x2104 + 2*x2105 - 2*x2106
    x2138 = (mpmath.mpf(1)/mpmath.mpf(2))*x25*x31*x322*x436*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x322*x4*x43*x436*x7 - mpmath.mpf(1)/mpmath.mpf(2)*x447 - mpmath.mpf(1)/mpmath.mpf(2)*x448
    x2139 = -mpmath.mpf(1)/mpmath.mpf(2)*x16*x449 + x1938 - mpmath.mpf(1)/mpmath.mpf(2)*x436*x845 + (mpmath.mpf(1)/mpmath.mpf(2))*x454 + (mpmath.mpf(1)/mpmath.mpf(2))*x455
    x2140 = -2*x1600 + 2*x1601 + 2*x2071 - 2*x438
    x2141 = x2129*x712 + x2138*x747 + x2139*x759 + x713*(-x2132 - x2133 + x2134 + x2135 + x2136 + x2137) + x760*(x2056 + 2*x2119 - 2*x2120 + 2*x2121 - 2*x2122 + 2*x2123 - 2*x2124 + 2*x2125 - 2*x2126 - x2130 + x2131) + x772*(2*x1*x16*x19*x322*x436*x7 + 2*x1525*x16*x2029*x43*x8 + 2*x1525*x2029*x25*x31*x6*x7 - x1949 - 2*x2113 - 2*x2114 - 2*x2115 - 2*x2116 - x2140 + 2*x26*x322*x436*x479*x6)
    x2142 = x2022*x782
    x2143 = x476*x62
    x2144 = x476*x56
    x2145 = x1515*x452 + x2062*x794 + x2063*x785 + x2064*x793 + x2077*x795 + x2078*x795 + x2079*x795 + x2143*x796 + x2144*x798 + x445*x787 - x472 - x473 + x474*x791 + x476*x790
    x2146 = x10*x2030
    x2147 = x2146*x83
    x2148 = x184*x2146
    x2149 = x2030*x9
    x2150 = x1530*x2149
    x2151 = x2149*x6
    x2152 = x2151*x80
    x2153 = x458*x903
    x2154 = x458*x807
    x2155 = x459*x814
    x2156 = x459*x915
    x2157 = -x1755 + x1756 - x859 + x861
    x2158 = x2117 + x2153 - x2154 + x2155 - x2156 + x2157 + x841
    x2159 = x1540*x2151
    x2160 = x2151*x90
    x2161 = x461*x814
    x2162 = x461*x915
    x2163 = x1679 + x2161 - x2162
    x2164 = x2159 - x2160 + x2163
    x2165 = x1540*x2146
    x2166 = x2146*x90
    x2167 = x2102*x80
    x2168 = x182*x2102
    x2169 = x461*x807
    x2170 = x461*x903
    x2171 = x459*x796
    x2172 = x459*x642
    x2173 = -x1852 + x1853 - x2081 + x449
    x2174 = x2169 - x2170 + x2171 - x2172 + x2173
    x2175 = 2*x449
    x2176 = 2*x2081
    x2177 = x1709 + 2*x2159 - 2*x2160 + 2*x2161 - 2*x2162
    x2178 = x1766 - x1767 + x1768 - x1769
    x2179 = x2129*x870 + x2138*x882 + x2139*x851 + x713*(x1948 + x2140 + 2*x2147 - 2*x2148 + 2*x2150 - 2*x2152 + 2*x2153 - 2*x2154 + 2*x2155 - 2*x2156 + x2178) + x760*(x2058 - x2059 + 2*x2165 - 2*x2166 + 2*x2167 - 2*x2168 + 2*x2169 - 2*x2170 + 2*x2171 - 2*x2172 + x2175 - x2176) + x772*(-x2137 - x2177)
    x2180 = x2022*x895
    x2181 = x158*x476
    x2182 = -x1094 - x1095 + x1516*x452 + x2062*x911 + x2063*x898 + x2064*x908 + x2077*x912 + x2078*x912 + x2079*x912 + x2144*x915 + x2181*x913 + x445*x791 + x474*x900 + x476*x904
    x2183 = 2*n2 + x1483
    x2184 = -x2183
    x2185 = x11*x2030
    x2186 = x182*x2185
    x2187 = x2185*x80
    x2188 = x2151*x83
    x2189 = x184*x2151
    x2190 = x459*x924
    x2191 = x459*x977
    x2192 = x458*x915
    x2193 = x458*x814
    x2194 = x1743 - x848
    x2195 = x1607 + x1649 - x2068 + x2190 - x2191 + x2192 - x2193 + x2194 + x441
    x2196 = x461*x977
    x2197 = x2185*x90
    x2198 = x1540*x2185
    x2199 = x461*x924
    x2200 = x184*x2100
    x2201 = x458*x653
    x2202 = x458*x798
    x2203 = x2100*x83
    x2204 = x1987 - x2109 + x2110
    x2205 = 4*n2 + x1506
    x2206 = -x2205
    x2207 = x1931 - x1932
    x2208 = x1762 - x1763
    x2209 = x2129*x956 + x2138*x940 + x2139*x962 + x713*(x1670*x2205 + x1693 + x2054 - x2055 + x2130 - x2131 + 2*x2186 - 2*x2187 + 2*x2188 - 2*x2189 + 2*x2190 - 2*x2191 + 2*x2192 - 2*x2193 + x2206*x339 + x2208) + x760*(x1997 + x2132 + x2133 - x2134 - x2135 + x2177) + x772*(x1930 + x1976*x2206 + x2060 - x2175 + x2176 + 2*x2196 + 2*x2197 - 2*x2198 - 2*x2199 + 2*x2200 + 2*x2201 - 2*x2202 - 2*x2203 + x2205*x344 + x2207)
    x2210 = x2022*x969
    x2211 = -x1358 - x1359 + x1515*x445 + x1516*x474 + x2062*x981 + x2063*x972 + x2064*x980 + x2077*x982 + x2078*x982 + x2079*x982 + x2143*x915 + x2181*x797 + x452*x974 + x476*x978
    x2212 = x148*x531 + x151*x534 + x155*x506 + x520
    x2213 = x178*(-x522*x999 - x526*x998 - x528*x997)
    x2214 = x143*x2213
    x2215 = x1104 + x224*x531 + x227*x506 + x234*x534
    x2216 = x2213*x245
    x2217 = x1368 + x291*x531 + x297*x534 + x300*x506
    x2218 = x2213*x306
    x2219 = x1620 + x337*x531 + x350*x534 + x356*x506
    x2220 = x2213*x381
    x2221 = x1869 + x398*x531 + x401*x506 + x410*x534
    x2222 = x2213*x428
    x2223 = x2074 + x446*x531 + x453*x534 + x456*x506
    x2224 = x2213*x470
    x2225 = x30**(mpmath.mpf(-5)/mpmath.mpf(2))
    x2226 = 3*o0 + x73
    x2227 = -x2226
    x2228 = x2225*x2227
    x2229 = x2228*x478
    x2230 = x2229*x28
    x2231 = x2229*x78
    x2232 = x28*x484
    x2233 = x2232*x9
    x2234 = x28*x480
    x2235 = x2234*x4
    x2236 = x2233 - x2235
    x2237 = x24*x480
    x2238 = x16*x2237
    x2239 = x24*x484
    x2240 = x2239*x6
    x2241 = x2238 - x2240
    x2242 = x2236 + x2241
    x2243 = -x13*x2225*x2227*x28*x478*x9 - x16*x2225*x2227*x24*x43*x478 + x182*x2230 + x2231*x24 + x2242
    x2244 = x16*x481
    x2245 = 2*x2244
    x2246 = x485*x6
    x2247 = 2*x2246
    x2248 = x2229*x25
    x2249 = x16*x670
    x2250 = x2232*x7
    x2251 = x1*x2234
    x2252 = x6*x700
    x2253 = x2249 + x2250 - x2251 - x2252
    x2254 = -x106*x2230 + x1540*x2230 - x184*x2248 + x2231*x25 - x2245 + x2247 + x2253
    x2255 = x4*x670
    x2256 = x700*x9
    x2257 = x2255 - x2256
    x2258 = x2239*x7
    x2259 = x1*x2237
    x2260 = x2258 - x2259
    x2261 = x2257 + x2260
    x2262 = x4*x481
    x2263 = x485*x9
    x2264 = -2*x2262 + 2*x2263
    x2265 = -x13*x2225*x2227*x24*x478*x7 + x1540*x2229*x24 - x2225*x2227*x25*x4*x43*x478 + x2248*x82 + x2261 + x2264
    x2266 = x1*x535
    x2267 = x4*x535
    x2268 = x16*x535
    x2269 = x2213*x529
    x2270 = x2243*x67 - x2254*x62 + x2265*x56 + x488*x531 + x496*x534 + x506*x507
    x2271 = x2228*x538
    x2272 = x2271*x28
    x2273 = x2271*x78
    x2274 = -x2244 + x2246
    x2275 = -x13*x2225*x2227*x28*x538*x9 - x16*x2225*x2227*x24*x43*x538 + x182*x2272 + x2273*x24 + x2274
    x2276 = x2271*x25
    x2277 = x542*x6
    x2278 = x16*x539
    x2279 = x2277 - x2278
    x2280 = -x106*x2272 + x1540*x2272 - x184*x2276 + x2273*x25 + x2279
    x2281 = x1*x481
    x2282 = x485*x7
    x2283 = x2281 - x2282
    x2284 = x542*x9
    x2285 = x4*x539
    x2286 = x2284 - x2285
    x2287 = x2283 + x2286
    x2288 = -x13*x2225*x2227*x24*x538*x7 + x1540*x2271*x24 - x2225*x2227*x25*x4*x43*x538 + x2276*x82 + x2287
    x2289 = x2275*x67 - x2280*x62 + x2288*x56 + x506*x554 + x531*x545 + x534*x561
    x2290 = x2213*x577
    x2291 = x1*x531
    x2292 = x4*x506
    x2293 = x16*x534
    x2294 = x2266*x579 + x2267*x553 + x2268*x582 + x2291*x583 + x2292*x583 + x2293*x583
    x2295 = x2228*x586
    x2296 = x2295*x28
    x2297 = x2295*x78
    x2298 = x2262 - x2263
    x2299 = -x13*x2225*x2227*x28*x586*x9 - x16*x2225*x2227*x24*x43*x586 + x182*x2296 + x2297*x24 + x2298
    x2300 = x2295*x25
    x2301 = x590*x6
    x2302 = x16*x587
    x2303 = x2301 - x2302
    x2304 = x2283 + x2303
    x2305 = -x106*x2296 + x1540*x2296 - x184*x2300 + x2297*x25 + x2304
    x2306 = x590*x9
    x2307 = x4*x587
    x2308 = x2306 - x2307
    x2309 = -x13*x2225*x2227*x24*x586*x7 + x1540*x2295*x24 - x2225*x2227*x25*x4*x43*x586 + x2300*x82 + x2308
    x2310 = x2299*x67 - x2305*x62 + x2309*x56 + x506*x607 + x531*x594 + x534*x599
    x2311 = x2213*x621
    x2312 = x2266*x623 + x2267*x606 + x2268*x626 + x2291*x627 + x2292*x627 + x2293*x627
    x2313 = x2228*x25
    x2314 = x2313*x28
    x2315 = x182*x2314
    x2316 = x2314*x82
    x2317 = x2313*x24
    x2318 = x2317*x78
    x2319 = x184*x24
    x2320 = x2313*x2319
    x2321 = x509*x796
    x2322 = x509*x645
    x2323 = -x2238 + x2240
    x2324 = x2321 - x2322 + x2323
    x2325 = x2318 - x2320 + x2324
    x2326 = x518*x651
    x2327 = x518*x798
    x2328 = -x2233 + x2235
    x2329 = x2326 - x2327 + x2328
    x2330 = 2*o0 + x630
    x2331 = -x2330
    x2332 = x16*x480
    x2333 = x484*x6
    x2334 = x2228*x26
    x2335 = x2334*x78
    x2336 = x184*x2334
    x2337 = x1540*x2314
    x2338 = x106*x2314
    x2339 = x509*x789
    x2340 = x509*x660
    x2341 = x513*x651
    x2342 = x513*x798
    x2343 = x2244 - x2246 - x482 + x501
    x2344 = x333*x7
    x2345 = x1*x33
    x2346 = x2344 - x2345
    x2347 = -x2250 + x2251
    x2348 = x2339 - x2340 + x2341 - x2342 + x2343 + x2346 + x2347
    x2349 = x4*x480
    x2350 = x484*x9
    x2351 = x518*x660
    x2352 = x182*x2334
    x2353 = x518*x789
    x2354 = x2334*x82
    x2355 = x513*x796
    x2356 = x106*x2317
    x2357 = x1540*x2317
    x2358 = x513*x645
    x2359 = -x2262 + x2263 - x486 + x489
    x2360 = x32*x637
    x2361 = x327*x644
    x2362 = x2360 - x2361
    x2363 = -mpmath.mpf(1)/mpmath.mpf(2)*x16*x489 + (mpmath.mpf(1)/mpmath.mpf(2))*x483 + (mpmath.mpf(1)/mpmath.mpf(2))*x487 - mpmath.mpf(1)/mpmath.mpf(2)*x501*x9
    x2364 = 2*x2327
    x2365 = 2*x2316
    x2366 = 2*x2315
    x2367 = 2*x2326
    x2368 = 2*x2238
    x2369 = 2*x2240
    x2370 = -x2368 + x2369
    x2371 = 2*x2233
    x2372 = 2*x2235
    x2373 = -x2371 + x2372
    x2374 = x2370 + x2373
    x2375 = 2*x2318 - 2*x2320 + 2*x2321 - 2*x2322
    x2376 = (mpmath.mpf(1)/mpmath.mpf(2))*x493
    x2377 = (mpmath.mpf(1)/mpmath.mpf(2))*x494
    x2378 = x2376 - x2377
    x2379 = x2378 - mpmath.mpf(1)/mpmath.mpf(2)*x4*x499 - mpmath.mpf(1)/mpmath.mpf(2)*x486*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x490 + (mpmath.mpf(1)/mpmath.mpf(2))*x492
    x2380 = (mpmath.mpf(1)/mpmath.mpf(2))*x503 - mpmath.mpf(1)/mpmath.mpf(2)*x504
    x2381 = (mpmath.mpf(1)/mpmath.mpf(2))*x13*x28*x478*x479*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x16*x25*x43*x478*x479 - x2380 - mpmath.mpf(1)/mpmath.mpf(2)*x497 - mpmath.mpf(1)/mpmath.mpf(2)*x498
    x2382 = 4*o0 + x761
    x2383 = -x2382
    x2384 = 2*x2259
    x2385 = 2*x2258
    x2386 = x2264 - 2*x486 + 2*x489
    x2387 = 2*x2361
    x2388 = 2*x2360
    x2389 = -x2387 + x2388
    x2390 = x2245 - x2247 - 2*x482 + 2*x501
    x2391 = 2*x2345
    x2392 = 2*x2344
    x2393 = -x2391 + x2392
    x2394 = 2*x2250
    x2395 = 2*x2251
    x2396 = -x2394 + x2395
    x2397 = x2363*x712 + x2379*x747 + x2381*x759 + x713*(x2364 + x2365 - x2366 - x2367 - x2374 - x2375) + x760*(x2349*x2382 + x2350*x2383 + 2*x2351 + 2*x2352 - 2*x2353 - 2*x2354 + 2*x2355 + 2*x2356 - 2*x2357 - 2*x2358 - x2384 + x2385 + x2386 + x2389) + x772*(x2332*x2383 + x2333*x2382 + 2*x2335 - 2*x2336 + 2*x2337 - 2*x2338 + 2*x2339 - 2*x2340 + 2*x2341 - 2*x2342 + x2390 + x2393 + x2396)
    x2398 = x2213*x782
    x2399 = x536*x62
    x2400 = x536*x56
    x2401 = x1515*x534 + x2266*x785 + x2267*x793 + x2268*x794 + x2291*x795 + x2292*x795 + x2293*x795 + x2399*x796 + x2400*x798 + x506*x791 + x531*x787 - x532 - x533 + x536*x790
    x2402 = x2228*x27
    x2403 = x2402*x78
    x2404 = x2228*x813
    x2405 = x182*x2404
    x2406 = x509*x903
    x2407 = x518*x811
    x2408 = -x10*x28*x322*x478*x479 - x16*x19*x24*x4*x478*x479 + x2343 + x2406 + x2407
    x2409 = x1540*x2404
    x2410 = x106*x2404
    x2411 = x513*x811
    x2412 = x513*x915
    x2413 = x333*x9
    x2414 = x33*x4
    x2415 = x2413 - x2414
    x2416 = x2411 - x2412 + x2415
    x2417 = x2409 - x2410 + x2416
    x2418 = x1540*x2402
    x2419 = x2317*x82
    x2420 = x513*x809
    x2421 = x518*x796
    x2422 = x2239*x9
    x2423 = x2237*x4
    x2424 = x2422 - x2423 - x856 + x863
    x2425 = x1758 + x47
    x2426 = -x2281 + x2282 + x2425 - x491 + x499
    x2427 = -x15*x19*x25*x478*x479 - x24*x322*x478*x479*x7*x9 + x2420 + x2421 + x2424 + x2426
    x2428 = 2*x2414
    x2429 = 2*x2413
    x2430 = -x2428 + x2429
    x2431 = x2370 + x2430
    x2432 = 2*x2409 - 2*x2410 + 2*x2411 - 2*x2412
    x2433 = 2*x856
    x2434 = 2*x863
    x2435 = 2*x2423
    x2436 = 2*x2422
    x2437 = -x2433 + x2434 - x2435 + x2436
    x2438 = x1772 + x890
    x2439 = -2*x2281 + 2*x2282 + x2438 - 2*x491 + 2*x499
    x2440 = x2363*x870 + x2379*x882 + x2381*x851 + x713*(2*x10*x28*x322*x478*x479 + 2*x13*x2225*x2227*x24*x28*x9 + 2*x16*x19*x24*x4*x478*x479 + 2*x16*x2225*x2227*x27*x43 - x2390 - 2*x2403 - 2*x2405 - 2*x2406 - 2*x2407) + x760*(2*x13*x2225*x2227*x27*x7 + 2*x15*x19*x25*x478*x479 + 2*x2225*x2227*x24*x25*x4*x43 + 2*x24*x322*x478*x479*x7*x9 - 2*x2418 - 2*x2419 - 2*x2420 - 2*x2421 - x2437 - x2439) + x772*(x2375 + x2431 + x2432)
    x2441 = x2213*x895
    x2442 = x158*x536
    x2443 = -x1107 - x1108 + x1516*x534 + x2266*x898 + x2267*x908 + x2268*x911 + x2291*x912 + x2292*x912 + x2293*x912 + x2400*x915 + x2442*x913 + x506*x900 + x531*x791 + x536*x904
    x2444 = x2228*x29
    x2445 = x182*x2444
    x2446 = x2404*x78
    x2447 = x518*x922
    x2448 = x509*x915
    x2449 = -x17*x19*x24*x478*x479 + x2359 + x2447 + x2448 - x28*x322*x478*x479*x6*x9
    x2450 = x1540*x2444
    x2451 = x106*x2444
    x2452 = x2314*x78
    x2453 = x184*x2314
    x2454 = x513*x922
    x2455 = x513*x977
    x2456 = x509*x798
    x2457 = x509*x651
    x2458 = x2232*x6
    x2459 = x16*x2234
    x2460 = x2458 - x2459 + x944 - x947
    x2461 = x2426 + x2454 - x2455 + x2456 - x2457 + x2460
    x2462 = x2236 - x2326 + x2327
    x2463 = x2371 - x2372
    x2464 = x2430 + x2463
    x2465 = 2*x2458 - 2*x2459 + 2*x944 - 2*x947
    x2466 = x2363*x956 + x2379*x940 + x2381*x962 + x713*(2*x13*x2225*x2227*x29*x9 + 2*x16*x2225*x2227*x24*x28*x43 + 2*x17*x19*x24*x478*x479 - x2386 - 2*x2445 - 2*x2446 - 2*x2447 - 2*x2448 + 2*x28*x322*x478*x479*x6*x9) + x760*(-x2364 - x2365 + x2366 + x2367 - x2432 - x2464) + x772*(x2439 + 2*x2450 - 2*x2451 + 2*x2452 - 2*x2453 + 2*x2454 - 2*x2455 + 2*x2456 - 2*x2457 + x2465)
    x2467 = x2213*x969
    x2468 = -x1371 - x1372 + x1515*x531 + x1516*x506 + x2266*x972 + x2267*x980 + x2268*x981 + x2291*x982 + x2292*x982 + x2293*x982 + x2399*x915 + x2442*x797 + x534*x974 + x536*x978
    x2469 = x148*x579 + x151*x582 + x155*x553 + x571
    x2470 = x178*(-x573*x997 - x575*x998 - x576*x999)
    x2471 = x143*x2470
    x2472 = x1116 + x224*x579 + x227*x553 + x234*x582
    x2473 = x245*x2470
    x2474 = x1378 + x291*x579 + x297*x582 + x300*x553
    x2475 = x2470*x306
    x2476 = x1629 + x337*x579 + x350*x582 + x356*x553
    x2477 = x2470*x381
    x2478 = x1878 + x398*x579 + x401*x553 + x410*x582
    x2479 = x2470*x428
    x2480 = x2085 + x446*x579 + x453*x582 + x456*x553
    x2481 = x2470*x470
    x2482 = 3*o1 + x985
    x2483 = -x2482
    x2484 = x2225*x2483
    x2485 = x2484*x478
    x2486 = x2485*x28
    x2487 = x2485*x78
    x2488 = -x13*x2225*x2483*x28*x478*x9 - x16*x2225*x24*x2483*x43*x478 + x182*x2486 + x2274 + x24*x2487
    x2489 = x2485*x25
    x2490 = -x106*x2486 + x1540*x2486 - x184*x2489 + x2279 + x2487*x25
    x2491 = -x13*x2225*x24*x2483*x478*x7 + x1540*x24*x2485 - x2225*x2483*x25*x4*x43*x478 + x2287 + x2489*x82
    x2492 = x2488*x67 - x2490*x62 + x2491*x56 + x488*x579 + x496*x582 + x507*x553
    x2493 = x2470*x529
    x2494 = x2484*x538
    x2495 = x2494*x28
    x2496 = x2494*x78
    x2497 = x2494*x25
    x2498 = -x106*x2495 + x1540*x2495 - x184*x2497 + x2253 + x2496*x25
    x2499 = 2*x2278
    x2500 = 2*x2277
    x2501 = -x2499 + x2500
    x2502 = -x13*x2225*x2483*x28*x538*x9 - x16*x2225*x24*x2483*x43*x538 + x182*x2495 + x2242 + x24*x2496 + x2501
    x2503 = x542*x7
    x2504 = 2*x2503
    x2505 = x1*x539
    x2506 = 2*x2505
    x2507 = -x2504 + x2506
    x2508 = -x13*x2225*x24*x2483*x538*x7 + x1540*x24*x2494 - x2225*x2483*x25*x4*x43*x538 + x2261 + x2497*x82 + x2507
    x2509 = x4*x553
    x2510 = 2*x583
    x2511 = x1*x579
    x2512 = x16*x582
    x2513 = x2470*x577
    x2514 = -x2498*x62 + x2502*x67 + x2508*x56 + x545*x579 + x553*x554 + x561*x582
    x2515 = x2484*x586
    x2516 = x2515*x28
    x2517 = x2515*x78
    x2518 = -x2284 + x2285
    x2519 = x2303 + x2518
    x2520 = -x13*x2225*x2483*x28*x586*x9 - x16*x2225*x24*x2483*x43*x586 + x182*x2516 + x24*x2517 + x2519
    x2521 = x25*x2515
    x2522 = -x2503 + x2505
    x2523 = -x106*x2516 + x1540*x2516 - x184*x2521 + x25*x2517 + x2522
    x2524 = x1*x587
    x2525 = x590*x7
    x2526 = x2524 - x2525
    x2527 = -x13*x2225*x24*x2483*x586*x7 + x1540*x24*x2515 - x2225*x2483*x25*x4*x43*x586 + x2521*x82 + x2526
    x2528 = x2520*x67 - x2523*x62 + x2527*x56 + x553*x607 + x579*x594 + x582*x599
    x2529 = x2470*x621
    x2530 = x1*x583
    x2531 = x4*x583
    x2532 = x16*x583
    x2533 = x2509*x627 + x2511*x627 + x2512*x627 + x2530*x623 + x2531*x606 + x2532*x626
    x2534 = x2484*x25
    x2535 = x2534*x28
    x2536 = x182*x2535
    x2537 = x2535*x82
    x2538 = x24*x2534
    x2539 = x2538*x78
    x2540 = x2319*x2534
    x2541 = x564*x796
    x2542 = x564*x645
    x2543 = -x2249 + x2252
    x2544 = x2541 - x2542 + x2543
    x2545 = x2539 - x2540 + x2544
    x2546 = x563*x651
    x2547 = x563*x798
    x2548 = x2346 + x2546 - x2547
    x2549 = x2484*x26
    x2550 = x2549*x78
    x2551 = x184*x2549
    x2552 = x1540*x2535
    x2553 = x106*x2535
    x2554 = x564*x789
    x2555 = x564*x660
    x2556 = x566*x651
    x2557 = x566*x798
    x2558 = -x2277 + x2278 - x540 + x551
    x2559 = x2554 - x2555 + x2556 - x2557 + x2558
    x2560 = x2549*x82
    x2561 = x1540*x2538
    x2562 = x563*x789
    x2563 = x566*x645
    x2564 = x1162 + x50
    x2565 = x1*x670
    x2566 = x7*x700
    x2567 = x2565 - x2566 + x729 - x737
    x2568 = x2564 + x2567
    x2569 = -x1*x19*x25*x4*x479*x538 - x24*x322*x479*x538*x8 + x2518 + x2562 + x2563 + x2568 + x543 - x555
    x2570 = -mpmath.mpf(1)/mpmath.mpf(2)*x16*x555 + x2380 + (mpmath.mpf(1)/mpmath.mpf(2))*x541 + (mpmath.mpf(1)/mpmath.mpf(2))*x544 - mpmath.mpf(1)/mpmath.mpf(2)*x551*x9
    x2571 = 2*x540
    x2572 = 2*x551
    x2573 = 2*x2547
    x2574 = 2*x2537
    x2575 = 2*x2536
    x2576 = 2*x2546
    x2577 = 2*x2249
    x2578 = 2*x2252
    x2579 = -x2577 + x2578
    x2580 = x2393 + x2579
    x2581 = 2*x2539 - 2*x2540 + 2*x2541 - 2*x2542
    x2582 = (mpmath.mpf(1)/mpmath.mpf(2))*x13*x28*x479*x538*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x16*x25*x43*x479*x538 - mpmath.mpf(1)/mpmath.mpf(2)*x546 - mpmath.mpf(1)/mpmath.mpf(2)*x548
    x2583 = (mpmath.mpf(1)/mpmath.mpf(2))*x558 - mpmath.mpf(1)/mpmath.mpf(2)*x559
    x2584 = x2583 - mpmath.mpf(1)/mpmath.mpf(2)*x4*x549 - mpmath.mpf(1)/mpmath.mpf(2)*x543*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x556 + (mpmath.mpf(1)/mpmath.mpf(2))*x557
    x2585 = 2*x555
    x2586 = 2*x2284
    x2587 = 2*x2285
    x2588 = 2*x543
    x2589 = x1191 + x1771
    x2590 = 2*x2565 - 2*x2566 + 2*x729 - 2*x737
    x2591 = x2589 + x2590
    x2592 = x2570*x712 + x2582*x759 + x2584*x747 + x713*(x2573 + x2574 - x2575 - x2576 - x2580 - x2581) + x760*(2*x1*x19*x25*x4*x479*x538 + 2*x13*x2225*x24*x2483*x25*x7 + 2*x2225*x2483*x26*x4*x43 + 2*x24*x322*x479*x538*x8 - 2*x2560 - 2*x2561 - 2*x2562 - 2*x2563 + x2585 + x2586 - x2587 - x2588 - x2591) + x772*(x2499 - x2500 + 2*x2550 - 2*x2551 + 2*x2552 - 2*x2553 + 2*x2554 - 2*x2555 + 2*x2556 - 2*x2557 - x2571 + x2572)
    x2593 = x2470*x782
    x2594 = x584*x62
    x2595 = x56*x584
    x2596 = x1515*x582 + x2509*x795 + x2511*x795 + x2512*x795 + x2530*x785 + x2531*x793 + x2532*x794 + x2594*x796 + x2595*x798 + x553*x791 + x579*x787 - x580 - x581 + x584*x790
    x2597 = 2*o1 + x1200
    x2598 = -x2597
    x2599 = x564*x809
    x2600 = x2484*x27
    x2601 = x184*x2600
    x2602 = x564*x903
    x2603 = x2600*x78
    x2604 = x563*x915
    x2605 = x2484*x813
    x2606 = x2605*x82
    x2607 = x182*x2605
    x2608 = x563*x811
    x2609 = -x2413 + x2414
    x2610 = x1540*x2605
    x2611 = x106*x2605
    x2612 = x566*x811
    x2613 = x566*x915
    x2614 = x2347 + x2612 - x2613
    x2615 = x2610 - x2611 + x2614
    x2616 = x1*x480
    x2617 = x484*x7
    x2618 = x566*x903
    x2619 = x106*x2600
    x2620 = x566*x809
    x2621 = x1540*x2600
    x2622 = x182*x2538
    x2623 = x563*x645
    x2624 = x563*x796
    x2625 = x2538*x82
    x2626 = -x2360 + x2361
    x2627 = x2396 + x2579
    x2628 = 2*x2610 - 2*x2611 + 2*x2612 - 2*x2613
    x2629 = 4*o1 + x1235
    x2630 = -x2629
    x2631 = 2*x549
    x2632 = 2*x547
    x2633 = 2*x2256
    x2634 = 2*x2255
    x2635 = -x2633 + x2634
    x2636 = x2387 - x2388
    x2637 = x2428 - x2429
    x2638 = x2570*x870 + x2582*x851 + x2584*x882 + x713*(x2332*x2629 + x2333*x2630 + x2463 + x2501 + x2571 - x2572 + 2*x2599 + 2*x2601 - 2*x2602 - 2*x2603 + 2*x2604 + 2*x2606 - 2*x2607 - 2*x2608 + x2637) + x760*(x2507 + x2616*x2630 + x2617*x2629 + 2*x2618 + 2*x2619 - 2*x2620 - 2*x2621 + 2*x2622 + 2*x2623 - 2*x2624 - 2*x2625 - x2631 + x2632 + x2635 + x2636) + x772*(x2581 + x2627 + x2628)
    x2639 = x2470*x895
    x2640 = x158*x584
    x2641 = -x1119 - x1120 + x1516*x582 + x2509*x912 + x2511*x912 + x2512*x912 + x2530*x898 + x2531*x908 + x2532*x911 + x2595*x915 + x2640*x913 + x553*x900 + x579*x791 + x584*x904
    x2642 = x2484*x29
    x2643 = x182*x2642
    x2644 = x2605*x78
    x2645 = x563*x922
    x2646 = x564*x915
    x2647 = -x17*x19*x24*x479*x538 + x2286 + x2425 + x2460 + x2645 + x2646 - x28*x322*x479*x538*x6*x9 - x543 + x555
    x2648 = x1540*x2642
    x2649 = x106*x2642
    x2650 = x2535*x78
    x2651 = x184*x2535
    x2652 = x566*x922
    x2653 = x566*x977
    x2654 = x564*x798
    x2655 = x564*x651
    x2656 = x1876 + x2503 - x2505 + x549
    x2657 = x2652 - x2653 + x2654 - x2655 + x2656
    x2658 = -x2344 + x2345
    x2659 = -x2546 + x2547 + x2658
    x2660 = x2391 - x2392
    x2661 = x2396 + x2660
    x2662 = x2570*x956 + x2582*x962 + x2584*x940 + x713*(2*x13*x2225*x2483*x29*x9 + 2*x16*x2225*x24*x2483*x28*x43 + 2*x17*x19*x24*x479*x538 - x2438 - x2465 - x2585 - x2586 + x2587 + x2588 - 2*x2643 - 2*x2644 - 2*x2645 - 2*x2646 + 2*x28*x322*x479*x538*x6*x9) + x760*(-x2573 - x2574 + x2575 + x2576 - x2628 - x2661) + x772*(x2504 - x2506 + x2631 - x2632 + 2*x2648 - 2*x2649 + 2*x2650 - 2*x2651 + 2*x2652 - 2*x2653 + 2*x2654 - 2*x2655)
    x2663 = x2470*x969
    x2664 = -x1381 - x1382 + x1515*x579 + x1516*x553 + x2509*x982 + x2511*x982 + x2512*x982 + x2530*x972 + x2531*x980 + x2532*x981 + x2594*x915 + x2640*x797 + x582*x974 + x584*x978
    x2665 = x148*x623 + x151*x626 + x155*x606 + x615
    x2666 = x178*(-x617*x998 - x618*x997 - x620*x999)
    x2667 = x143*x2666
    x2668 = x1125 + x224*x623 + x227*x606 + x234*x626
    x2669 = x245*x2666
    x2670 = x1388 + x291*x623 + x297*x626 + x300*x606
    x2671 = x2666*x306
    x2672 = x1636 + x337*x623 + x350*x626 + x356*x606
    x2673 = x2666*x381
    x2674 = x1885 + x398*x623 + x401*x606 + x410*x626
    x2675 = x2666*x428
    x2676 = x2094 + x446*x623 + x453*x626 + x456*x606
    x2677 = x2666*x470
    x2678 = 3*o2 + x1270
    x2679 = -x2678
    x2680 = x2225*x2679
    x2681 = x2680*x478
    x2682 = x2681*x28
    x2683 = x2681*x78
    x2684 = -x13*x2225*x2679*x28*x478*x9 - x16*x2225*x24*x2679*x43*x478 + x182*x2682 + x2298 + x24*x2683
    x2685 = x25*x2681
    x2686 = -x106*x2682 + x1540*x2682 - x184*x2685 + x2304 + x25*x2683
    x2687 = -x13*x2225*x24*x2679*x478*x7 + x1540*x24*x2681 - x2225*x25*x2679*x4*x43*x478 + x2308 + x2685*x82
    x2688 = x2684*x67 - x2686*x62 + x2687*x56 + x488*x623 + x496*x626 + x507*x606
    x2689 = x2666*x529
    x2690 = x2680*x538
    x2691 = x2690*x28
    x2692 = x2690*x78
    x2693 = -x13*x2225*x2679*x28*x538*x9 - x16*x2225*x24*x2679*x43*x538 + x182*x2691 + x24*x2692 + x2519
    x2694 = x25*x2690
    x2695 = -x106*x2691 + x1540*x2691 - x184*x2694 + x25*x2692 + x2522
    x2696 = -x13*x2225*x24*x2679*x538*x7 + x1540*x24*x2690 - x2225*x25*x2679*x4*x43*x538 + x2526 + x2694*x82
    x2697 = x2693*x67 - x2695*x62 + x2696*x56 + x545*x623 + x554*x606 + x561*x626
    x2698 = x2666*x577
    x2699 = x2680*x586
    x2700 = x25*x2699
    x2701 = -x13*x2225*x24*x2679*x586*x7 + x1540*x24*x2699 - x2225*x25*x2679*x4*x43*x586 + x2261 + x2700*x82
    x2702 = x2699*x28
    x2703 = x2699*x78
    x2704 = -2*x2306 + 2*x2307
    x2705 = -x13*x2225*x2679*x28*x586*x9 - x16*x2225*x24*x2679*x43*x586 + x182*x2702 + x2242 + x24*x2703 + x2704
    x2706 = 2*x2525
    x2707 = 2*x2524
    x2708 = -x106*x2702 + x1540*x2702 - x184*x2700 + x2253 + x25*x2703 - x2706 + x2707
    x2709 = x16*x627
    x2710 = x1*x627
    x2711 = x4*x627
    x2712 = x2666*x621
    x2713 = x2701*x56 + x2705*x67 - x2708*x62 + x594*x623 + x599*x626 + x606*x607
    x2714 = x25*x2680
    x2715 = x2714*x28
    x2716 = x182*x2715
    x2717 = x2715*x82
    x2718 = x24*x2714
    x2719 = x2718*x78
    x2720 = x2319*x2714
    x2721 = x609*x796
    x2722 = x609*x645
    x2723 = x2721 - x2722
    x2724 = x2719 - x2720 + x2723
    x2725 = x611*x651
    x2726 = x611*x798
    x2727 = x2257 + x2362
    x2728 = x2725 - x2726 + x2727
    x2729 = x26*x2680
    x2730 = x2729*x78
    x2731 = x184*x2729
    x2732 = x1540*x2715
    x2733 = x106*x2715
    x2734 = x609*x789
    x2735 = x609*x660
    x2736 = x613*x651
    x2737 = x613*x798
    x2738 = -x2301 + x2302 - x588 + x604
    x2739 = x2568 + x2734 - x2735 + x2736 - x2737 + x2738
    x2740 = x2729*x82
    x2741 = x1540*x2718
    x2742 = x611*x789
    x2743 = x613*x645
    x2744 = x1385 - x2306 + x2307 + x591
    x2745 = -x1*x19*x25*x4*x479*x586 - x24*x322*x479*x586*x8 + x2742 + x2743 + x2744
    x2746 = -x2376 + x2377
    x2747 = -mpmath.mpf(1)/mpmath.mpf(2)*x16*x595 + x2746 + (mpmath.mpf(1)/mpmath.mpf(2))*x589 + (mpmath.mpf(1)/mpmath.mpf(2))*x592 - mpmath.mpf(1)/mpmath.mpf(2)*x604*x9
    x2748 = x2704 + 2*x591 - 2*x595
    x2749 = 2*x2726
    x2750 = 2*x2717
    x2751 = 2*x2716
    x2752 = 2*x2725
    x2753 = x2389 + x2635
    x2754 = 2*x2719 - 2*x2720 + 2*x2721 - 2*x2722
    x2755 = -mpmath.mpf(1)/mpmath.mpf(2)*x4*x602 - mpmath.mpf(1)/mpmath.mpf(2)*x591*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x596 + (mpmath.mpf(1)/mpmath.mpf(2))*x598
    x2756 = (mpmath.mpf(1)/mpmath.mpf(2))*x13*x28*x479*x586*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x16*x25*x43*x479*x586 - x2583 - mpmath.mpf(1)/mpmath.mpf(2)*x600 - mpmath.mpf(1)/mpmath.mpf(2)*x601
    x2757 = -2*x2301 + 2*x2302 - 2*x588 + 2*x604
    x2758 = x2747*x712 + x2755*x747 + x2756*x759 + x713*(x2749 + x2750 - x2751 - x2752 - x2753 - x2754) + x760*(2*x1*x19*x25*x4*x479*x586 + 2*x13*x2225*x24*x25*x2679*x7 + 2*x2225*x26*x2679*x4*x43 + 2*x24*x322*x479*x586*x8 - 2*x2740 - 2*x2741 - 2*x2742 - 2*x2743 - x2748) + x772*(x2591 + 2*x2730 - 2*x2731 + 2*x2732 - 2*x2733 + 2*x2734 - 2*x2735 + 2*x2736 - 2*x2737 + x2757)
    x2759 = x2666*x782
    x2760 = x1*x623
    x2761 = x4*x606
    x2762 = x16*x626
    x2763 = x62*x628
    x2764 = x56*x628
    x2765 = x1515*x626 + x2709*x794 + x2710*x785 + x2711*x793 + x2760*x795 + x2761*x795 + x2762*x795 + x2763*x796 + x2764*x798 + x606*x791 + x623*x787 - x624 - x625 + x628*x790
    x2766 = x2680*x27
    x2767 = x2766*x78
    x2768 = x2680*x813
    x2769 = x182*x2768
    x2770 = x609*x903
    x2771 = x611*x811
    x2772 = -x2422 + x2423 + x856 - x863
    x2773 = -x10*x28*x322*x479*x586 - x16*x19*x24*x4*x479*x586 + x2564 + x2738 + x2770 + x2771 + x2772
    x2774 = -x2258 + x2259
    x2775 = x2362 + x2774
    x2776 = x613*x811
    x2777 = x613*x915
    x2778 = x2776 - x2777
    x2779 = x2775 + x2778
    x2780 = x1540*x2768
    x2781 = x106*x2768
    x2782 = x2780 - x2781
    x2783 = x1540*x2766
    x2784 = x2718*x82
    x2785 = x613*x809
    x2786 = x611*x796
    x2787 = x2090 - x2524 + x2525 + x602
    x2788 = -x15*x19*x25*x479*x586 - x24*x322*x479*x586*x7*x9 + x2785 + x2786 + x2787
    x2789 = x2706 - x2707 - 2*x597 + 2*x602
    x2790 = x2384 - x2385
    x2791 = x2389 + x2790
    x2792 = 2*x2776 - 2*x2777 + 2*x2780 - 2*x2781
    x2793 = x2433 - x2434 + x2435 - x2436
    x2794 = x2747*x870 + x2755*x882 + x2756*x851 + x713*(2*x10*x28*x322*x479*x586 + 2*x13*x2225*x24*x2679*x28*x9 + 2*x16*x19*x24*x4*x479*x586 + 2*x16*x2225*x2679*x27*x43 - x2589 - x2757 - 2*x2767 - 2*x2769 - 2*x2770 - 2*x2771 - x2793) + x760*(2*x13*x2225*x2679*x27*x7 + 2*x15*x19*x25*x479*x586 + 2*x2225*x24*x25*x2679*x4*x43 + 2*x24*x322*x479*x586*x7*x9 - 2*x2783 - 2*x2784 - 2*x2785 - 2*x2786 - x2789) + x772*(x2754 + x2791 + x2792)
    x2795 = x2666*x895
    x2796 = x158*x628
    x2797 = -x1128 - x1129 + x1516*x626 + x2709*x911 + x2710*x898 + x2711*x908 + x2760*x912 + x2761*x912 + x2762*x912 + x2764*x915 + x2796*x913 + x606*x900 + x623*x791 + x628*x904
    x2798 = 2*o2 + x1483
    x2799 = -x2798
    x2800 = x611*x977
    x2801 = x2680*x29
    x2802 = x2801*x82
    x2803 = x611*x922
    x2804 = x182*x2801
    x2805 = x184*x2768
    x2806 = x609*x811
    x2807 = x609*x915
    x2808 = x2768*x78
    x2809 = x1540*x2801
    x2810 = x106*x2801
    x2811 = x2715*x78
    x2812 = x184*x2715
    x2813 = x613*x922
    x2814 = x613*x977
    x2815 = x609*x798
    x2816 = x609*x651
    x2817 = x2543 + x2658 + x2787 + x2813 - x2814 + x2815 - x2816
    x2818 = -x2255 + x2256
    x2819 = x2774 + x2818
    x2820 = -x2725 + x2726 + x2778 + x2819
    x2821 = x2633 - x2634
    x2822 = x2790 + x2821
    x2823 = 4*o2 + x1506
    x2824 = -x2823
    x2825 = x2747*x956 + x2755*x940 + x2756*x962 + x713*(x2349*x2824 + x2350*x2823 + x2368 - x2369 + x2430 + x2748 + 2*x2800 + 2*x2802 - 2*x2803 - 2*x2804 + 2*x2805 + 2*x2806 - 2*x2807 - 2*x2808) + x760*(-x2749 - x2750 + x2751 + x2752 - x2792 - x2822) + x772*(x2579 + x2616*x2823 + x2617*x2824 + x2660 + x2789 + 2*x2809 - 2*x2810 + 2*x2811 - 2*x2812 + 2*x2813 - 2*x2814 + 2*x2815 - 2*x2816)
    x2826 = x2666*x969
    x2827 = -x1391 - x1392 + x1515*x623 + x1516*x606 + x2709*x981 + x2710*x972 + x2711*x980 + x2760*x982 + x2761*x982 + x2762*x982 + x2763*x915 + x2796*x797 + x626*x974 + x628*x978
    x2828 = x72*x74
    x2829 = x2*x2828
    x2830 = x16*x2829
    x2831 = -x2829*x4*x83 + x2829*x79 + x2830*x80 - x2830*x82 + x648 + x656
    x2832 = x1*x2829
    x2833 = -x1*x19*x2*x25*x28*x479 - x1*x2*x28*x31*x72*x74 + x1145 + x1176 + x1218 - x13*x16*x2*x7*x72*x74 - x16*x19*x2*x322*x8 + x2830*x90 + x2832*x78 + x665 + x669 + x816
    x2834 = x2829*x4
    x2835 = -x106*x2834 + x1242 - x2829*x633 + x2832*x82 + x2834*x90 + x687
    x2836 = x148*x785 + x151*x794 + x155*x793 - x2831*x67 + x2833*x62 - x2835*x56
    x2837 = x178*(-x712*x999 - x747*x998 - x759*x997)
    x2838 = x143*x2837
    x2839 = x200*x2828
    x2840 = x16*x2839
    x2841 = x1141 + x1146 - x2839*x4*x83 + x2839*x79 + x2840*x80 - x2840*x82
    x2842 = x1*x2839
    x2843 = -x1*x200*x28*x31*x72*x74 + x1153 - x13*x16*x200*x7*x72*x74 + x2840*x90 + x2842*x78
    x2844 = x2839*x4
    x2845 = -x106*x2844 + x1166 - x2839*x633 + x2842*x82 + x2844*x90
    x2846 = x224*x785 + x227*x793 + x234*x794 - x2841*x67 + x2843*x62 - x2845*x56
    x2847 = x245*x2837
    x2848 = x269*x2828
    x2849 = x16*x2848
    x2850 = -x13*x269*x4*x6*x72*x74 - x1403 + x1404 + x1505 - x16*x24*x269*x31*x72*x74 + x2848*x4*x83 + x2849*x82 + x686
    x2851 = x1*x2848
    x2852 = -x1*x269*x28*x31*x72*x74 - x13*x16*x269*x7*x72*x74 + x1413 + x2849*x90 + x2851*x78
    x2853 = x2848*x4
    x2854 = -x106*x2853 + x1422 - x2848*x633 + x2851*x82 + x2853*x90
    x2855 = x2850*x67 + x2852*x62 - x2854*x56 + x291*x785 + x297*x794 + x300*x793
    x2856 = x2837*x306
    x2857 = x1525*x1526
    x2858 = x2857*x321
    x2859 = x2858*x9
    x2860 = x2858*x6
    x2861 = x1530*x2858 + x1650 + x1655 - x184*x2859 + x2859*x83 - x2860*x80
    x2862 = x2858*x7
    x2863 = -x1*x16*x19*x321*x322*x7 - x1525*x1526*x16*x321*x43*x7 - x1525*x1526*x25*x31*x321*x6 + x1540*x2860 + x1662 + x1667 + x1737 + x1903 + x1933 + x1973 - x26*x321*x322*x479*x6 + x2862*x83
    x2864 = x1540*x2859 + x1682 - x182*x2862 + x1997 - x2859*x90 + x2862*x80
    x2865 = -x2861*x67 + x2863*x62 - x2864*x56 + x337*x785 + x350*x794 + x356*x793
    x2866 = x2837*x381
    x2867 = x2857*x389
    x2868 = x2867*x9
    x2869 = x2867*x6
    x2870 = x1530*x2867 - x184*x2868 + x1899 + x1904 + x2868*x83 - x2869*x80
    x2871 = x2867*x7
    x2872 = -x1525*x1526*x16*x389*x43*x7 - x1525*x1526*x25*x31*x389*x6 + x1540*x2869 + x1911 + x2871*x83
    x2873 = x1540*x2868 - x182*x2871 + x1923 - x2868*x90 + x2871*x80
    x2874 = -x2870*x67 + x2872*x62 - x2873*x56 + x398*x785 + x401*x793 + x410*x794
    x2875 = x2837*x428
    x2876 = x2857*x436
    x2877 = x2876*x9
    x2878 = x2876*x6
    x2879 = x1530*x2876 - x184*x2877 + x2107 + x2111 + x2877*x83 - x2878*x80
    x2880 = x2876*x7
    x2881 = -x1525*x1526*x16*x43*x436*x7 - x1525*x1526*x25*x31*x436*x6 + x1540*x2878 + x2118 + x2880*x83
    x2882 = x1540*x2877 - x182*x2880 + x2127 - x2877*x90 + x2880*x80
    x2883 = -x2879*x67 + x2881*x62 - x2882*x56 + x446*x785 + x453*x794 + x456*x793
    x2884 = x2837*x470
    x2885 = x2225*x2226
    x2886 = x2885*x478
    x2887 = x28*x2886
    x2888 = x2886*x78
    x2889 = -x13*x2225*x2226*x28*x478*x9 - x16*x2225*x2226*x24*x43*x478 + x182*x2887 + x2324 + x2329 + x24*x2888
    x2890 = x25*x2886
    x2891 = -x106*x2887 + x1540*x2887 - x184*x2890 + x2348 + x25*x2888 + x2579
    x2892 = -x1*x19*x25*x4*x478*x479 - x13*x2225*x2226*x24*x478*x7 + x1540*x24*x2886 - x2225*x2226*x25*x4*x43*x478 + x2298 + x2353 + x2358 - x24*x322*x478*x479*x8 + x2626 + x2774 + x2821 + x2890*x82 + x486 - x489
    x2893 = x2889*x67 - x2891*x62 + x2892*x56 + x488*x785 + x496*x794 + x507*x793
    x2894 = x2837*x529
    x2895 = x2885*x538
    x2896 = x28*x2895
    x2897 = x2895*x78
    x2898 = -x13*x2225*x2226*x28*x538*x9 - x16*x2225*x2226*x24*x43*x538 + x182*x2896 + x24*x2897 + x2544 + x2548
    x2899 = x25*x2895
    x2900 = -x106*x2896 + x1540*x2896 - x184*x2899 + x25*x2897 + x2559
    x2901 = -x13*x2225*x2226*x24*x538*x7 + x1540*x24*x2895 - x2225*x2226*x25*x4*x43*x538 + x2569 + x2899*x82
    x2902 = x2898*x67 - x2900*x62 + x2901*x56 + x545*x785 + x554*x793 + x561*x794
    x2903 = x2837*x577
    x2904 = x2885*x586
    x2905 = x28*x2904
    x2906 = x2904*x78
    x2907 = -x13*x2225*x2226*x28*x586*x9 - x16*x2225*x2226*x24*x43*x586 + x182*x2905 + x24*x2906 + x2723 + x2728
    x2908 = x25*x2904
    x2909 = -x106*x2905 + x1540*x2905 - x184*x2908 + x25*x2906 + x2739
    x2910 = -x13*x2225*x2226*x24*x586*x7 + x1540*x24*x2904 - x2225*x2226*x25*x4*x43*x586 + x2745 + x2908*x82
    x2911 = x2907*x67 - x2909*x62 + x2910*x56 + x594*x785 + x599*x794 + x607*x793
    x2912 = x2837*x621
    x2913 = x16*x2828
    x2914 = x2913*x633
    x2915 = x2857*x7
    x2916 = x1530*x2915
    x2917 = x25*x2885
    x2918 = x28*x2917
    x2919 = x2918*x82
    x2920 = x1*x2913
    x2921 = x2920*x82
    x2922 = x182*x2918
    x2923 = x2915*x6
    x2924 = x2923*x80
    x2925 = x1538 + x2323 + x2328 + x86
    x2926 = x645*x798
    x2927 = 2*x2926
    x2928 = x653*x796
    x2929 = 2*x2928
    x2930 = x642*x651
    x2931 = 2*x2930
    x2932 = x651*x796
    x2933 = 2*x2932
    x2934 = x642*x798
    x2935 = 2*x2934
    x2936 = x645*x653
    x2937 = 2*x2936
    x2938 = -x2927 - x2929 - x2931 + x2933 + x2935 + x2937
    x2939 = x2828*x637
    x2940 = x2939*x78
    x2941 = x2319*x2917
    x2942 = x2857*x644
    x2943 = x2942*x83
    x2944 = x2939*x83
    x2945 = x184*x2942
    x2946 = x24*x2917
    x2947 = x2946*x78
    x2948 = x2940 + x2941 + x2943 - x2944 - x2945 - x2947
    x2949 = x14*x2828
    x2950 = x2949*x83
    x2951 = x2857*x8
    x2952 = x184*x2951
    x2953 = x26*x2885
    x2954 = x2953*x78
    x2955 = x2949*x78
    x2956 = x2951*x83
    x2957 = x184*x2953
    x2958 = 2*x789
    x2959 = 2*x660
    x2960 = 2*x664
    x2961 = x106*x2920
    x2962 = x1540*x2918
    x2963 = x2923*x90
    x2964 = x2920*x90
    x2965 = x1540*x2923
    x2966 = x106*x2918
    x2967 = x1173 + x1930
    x2968 = x1140 + x1218 + x1898 + x1973 + x2253
    x2969 = x2949*x82
    x2970 = x2951*x80
    x2971 = x182*x2953
    x2972 = x2949*x80
    x2973 = x182*x2951
    x2974 = x2953*x82
    x2975 = x2939*x90
    x2976 = x1540*x2942
    x2977 = x106*x2946
    x2978 = x106*x2939
    x2979 = x1540*x2946
    x2980 = x2942*x90
    x2981 = x117 + x1557 + x2819
    x2982 = 2*x785
    x2983 = (mpmath.mpf(1)/mpmath.mpf(2))*x696
    x2984 = (mpmath.mpf(1)/mpmath.mpf(2))*x698
    x2985 = (mpmath.mpf(1)/mpmath.mpf(2))*x702
    x2986 = (mpmath.mpf(1)/mpmath.mpf(2))*x690
    x2987 = (mpmath.mpf(1)/mpmath.mpf(2))*x692
    x2988 = (mpmath.mpf(1)/mpmath.mpf(2))*x694
    x2989 = -mpmath.mpf(1)/mpmath.mpf(2)*x704 - mpmath.mpf(1)/mpmath.mpf(2)*x705 - mpmath.mpf(1)/mpmath.mpf(2)*x707 + (mpmath.mpf(1)/mpmath.mpf(2))*x708 + (mpmath.mpf(1)/mpmath.mpf(2))*x709 + (mpmath.mpf(1)/mpmath.mpf(2))*x710
    x2990 = -x2983 - x2984 - x2985 + x2986 + x2987 + x2988 - x2989
    x2991 = (mpmath.mpf(1)/mpmath.mpf(2))*x1*x13*x19*x4*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x1*x24*x25*x43*x479 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x26*x479*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x14*x19*x24*x31 - x1423 - x2128 - x2378 + (mpmath.mpf(1)/mpmath.mpf(2))*x25*x31*x322*x7*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x322*x4*x43*x8 - mpmath.mpf(1)/mpmath.mpf(2)*x736 - mpmath.mpf(1)/mpmath.mpf(2)*x738 - mpmath.mpf(1)/mpmath.mpf(2)*x740 - mpmath.mpf(1)/mpmath.mpf(2)*x744 - mpmath.mpf(1)/mpmath.mpf(2)*x745 - mpmath.mpf(1)/mpmath.mpf(2)*x746
    x2992 = -x1699 + x1700 + x2380 - x748 + x749
    x2993 = -mpmath.mpf(1)/mpmath.mpf(2)*x1*x671 - mpmath.mpf(1)/mpmath.mpf(2)*x1*x91 - mpmath.mpf(1)/mpmath.mpf(2)*x16*x731 - mpmath.mpf(1)/mpmath.mpf(2)*x28*x729 + x2992 - mpmath.mpf(1)/mpmath.mpf(2)*x6*x733 - mpmath.mpf(1)/mpmath.mpf(2)*x7*x845 + (mpmath.mpf(1)/mpmath.mpf(2))*x752 + (mpmath.mpf(1)/mpmath.mpf(2))*x753 + (mpmath.mpf(1)/mpmath.mpf(2))*x754 + (mpmath.mpf(1)/mpmath.mpf(2))*x755 + (mpmath.mpf(1)/mpmath.mpf(2))*x756 + (mpmath.mpf(1)/mpmath.mpf(2))*x757
    x2994 = 2*x2921
    x2995 = 2*x2922
    x2996 = 2*x2924
    x2997 = 2*x2914
    x2998 = 2*x2916
    x2999 = 2*x2919
    x3000 = x1691 - x1692 + x721 - x722
    x3001 = x1797 + x2374 + x3000 + x941
    x3002 = 2*x2940 + 2*x2941 + 2*x2943 - 2*x2944 - 2*x2945 - 2*x2947
    x3003 = 4*x2360
    x3004 = 4*x684
    x3005 = 4*x706
    x3006 = 4*x1680
    x3007 = 4*x685
    x3008 = 4*x2361
    x3009 = 4*x789
    x3010 = 4*x660
    x3011 = 4*x664
    x3012 = x1707 - x1708 + x766 - x767
    x3013 = x1431 + x2136 + x2822 + x3012
    x3014 = 4*x1668
    x3015 = 4*x671
    x3016 = 4*x2344
    x3017 = 4*x2345
    x3018 = 4*x673
    x3019 = 4*x701
    x3020 = x1176 + x1233 + x1933 + x1989 + x2394 - x2395 + x2577 - x2578
    x3021 = x2990*x712 + x2991*x747 + x2993*x759 + x713*(-4*x2926 - 4*x2928 - 4*x2930 + 4*x2932 + 4*x2934 + 4*x2936 - x2994 - x2995 - x2996 + x2997 + x2998 + x2999 + x3001 + x3002) + x760*(x107*x762 + x109*x763 + x1670*x1703 + x1704*x339 + x2349*x2383 + x2350*x2382 + 2*x2969 + 2*x2970 + 2*x2971 - 2*x2972 - 2*x2973 - 2*x2974 + 2*x2975 + 2*x2976 + 2*x2977 - 2*x2978 - 2*x2979 - 2*x2980 - x3003 - x3004 - x3005 + x3006 + x3007 + x3008 - x3009*x642 + x3009*x645 + x3010*x642 - x3010*x796 - x3011*x645 + x3011*x796 + x3013) + x772*(x1657*x1704 + x1703*x328 + x21*x762 + x2332*x2382 + x2333*x2383 + 2*x2950 + 2*x2952 + 2*x2954 - 2*x2955 - 2*x2956 - 2*x2957 + 2*x2961 + 2*x2962 + 2*x2963 - 2*x2964 - 2*x2965 - 2*x2966 - x3009*x651 + x3009*x653 - x3010*x653 + x3010*x798 + x3011*x651 - x3011*x798 - x3014 - x3015 - x3016 + x3017 + x3018 + x3019 + x3020 + x36*x763)
    x3022 = x144*x790
    x3023 = 2*x791
    x3024 = 2*x1515
    x3025 = x1*x795
    x3026 = x4*x793
    x3027 = 2*x795
    x3028 = x16*x794
    x3029 = x2837*x782
    x3030 = x62*x796
    x3031 = 2*x799
    x3032 = x56*x798
    x3033 = x15*x2828
    x3034 = x3033*x78
    x3035 = x10*x2857
    x3036 = x3035*x83
    x3037 = x27*x2885
    x3038 = x184*x3037
    x3039 = x3033*x83
    x3040 = x184*x3035
    x3041 = x3037*x78
    x3042 = x2913*x4
    x3043 = x3042*x80
    x3044 = x2857*x9
    x3045 = x1530*x3044
    x3046 = x2885*x813
    x3047 = x3046*x82
    x3048 = x3042*x82
    x3049 = x182*x3046
    x3050 = x3044*x6
    x3051 = x3050*x80
    x3052 = x651*x903
    x3053 = x653*x809
    x3054 = x798*x807
    x3055 = x653*x903
    x3056 = x798*x809
    x3057 = x651*x807
    x3058 = x796*x811
    x3059 = x642*x915
    x3060 = x645*x814
    x3061 = x645*x915
    x3062 = x796*x814
    x3063 = x642*x811
    x3064 = x3058 + x3059 + x3060 - x3061 - x3062 - x3063
    x3065 = x1545 + x1669 + x2346 + x3052 + x3053 + x3054 - x3055 - x3056 - x3057 + x3064 + x674 + x96
    x3066 = x3042*x90
    x3067 = x1540*x3050
    x3068 = x106*x3046
    x3069 = x106*x3042
    x3070 = x1540*x3046
    x3071 = x3050*x90
    x3072 = x789*x811
    x3073 = x660*x814
    x3074 = x664*x915
    x3075 = x789*x814
    x3076 = x660*x915
    x3077 = x664*x811
    x3078 = x1495 + x2194 + x2415 + x3072 + x3073 + x3074 - x3075 - x3076 - x3077
    x3079 = x3066 + x3067 + x3068 - x3069 - x3070 - x3071 + x3078
    x3080 = -x1*x16*x19*x322*x7*x9 - x1*x19*x25*x28*x4*x479 + x1537 + x2323 - x24*x25*x322*x479*x6*x7 + x2932 + x2934 + x2936 + x85
    x3081 = x3033*x90
    x3082 = x1540*x3035
    x3083 = x106*x3037
    x3084 = x106*x3033
    x3085 = x3035*x90
    x3086 = x1540*x3037
    x3087 = x2939*x82
    x3088 = x182*x2946
    x3089 = x2942*x80
    x3090 = x2939*x80
    x3091 = x182*x2942
    x3092 = x2946*x82
    x3093 = x789*x809
    x3094 = x664*x903
    x3095 = x660*x807
    x3096 = x789*x807
    x3097 = x660*x903
    x3098 = x664*x809
    x3099 = -x1163 + x1164 - x1920 + x1921 + x2567 + x731 + x733 - x735 - x739
    x3100 = x1454 + x2157 + x2424 + x3093 + x3094 + x3095 - x3096 - x3097 - x3098 + x3099
    x3101 = x1509 + x2207
    x3102 = 2*x3055
    x3103 = 2*x3056
    x3104 = 2*x3057
    x3105 = 2*x3052
    x3106 = 2*x3053
    x3107 = 2*x3054
    x3108 = 2*x3058 + 2*x3059 + 2*x3060 - 2*x3061 - 2*x3062 - 2*x3063
    x3109 = x1717 + x777
    x3110 = x2580 - x3102 - x3103 - x3104 + x3105 + x3106 + x3107 + x3108 + x3109
    x3111 = x1510 + x2208
    x3112 = 2*x3072 + 2*x3073 + 2*x3074 - 2*x3075 - 2*x3076 - 2*x3077 + x3111
    x3113 = x2431 + x2938 + x3000 + x3112
    x3114 = 2*x3066 + 2*x3067 + 2*x3068 - 2*x3069 - 2*x3070 - 2*x3071
    x3115 = x1187 - x1188 + x1189 - x1190 + x1944 - x1945 + x1946 - x1947 + x2590
    x3116 = x1475 + x2178 + x2437 + 2*x3093 + 2*x3094 + 2*x3095 - 2*x3096 - 2*x3097 - 2*x3098 + x3115
    x3117 = x2990*x870 + x2991*x882 + x2993*x851 + x713*(2*x3034 + 2*x3036 + 2*x3038 - 2*x3039 - 2*x3040 - 2*x3041 + 2*x3043 + 2*x3045 + 2*x3047 - 2*x3048 - 2*x3049 - 2*x3051 + x3101 + x3110) + x760*(2*x3081 + 2*x3082 + 2*x3083 - 2*x3084 - 2*x3085 - 2*x3086 + 2*x3087 + 2*x3088 + 2*x3089 - 2*x3090 - 2*x3091 - 2*x3092 + x3116) + x772*(-x3002 - x3113 - x3114)
    x3118 = x2837*x895
    x3119 = x1*x785
    x3120 = x4*x795
    x3121 = x16*x795
    x3122 = x158*x799
    x3123 = x799*x915
    x3124 = -x1196 - x1197 - x1198 + x1515*x911 + x1516*x794 + x3022*x895 + x3025*x898 + x3026*x912 + x3028*x912 + x3030*x914 + x3032*x914 + x3119*x912 + x3120*x908 + x3121*x911 + x3122*x913 + x3123*x56 + x785*x791 + x787*x898 + x791*x908 + x793*x900 + x799*x904 - x899 - x901 - x902
    x3125 = x17*x2828
    x3126 = x3125*x80
    x3127 = x11*x2857
    x3128 = x182*x3127
    x3129 = x2885*x29
    x3130 = x3129*x82
    x3131 = x3125*x82
    x3132 = x3127*x80
    x3133 = x182*x3129
    x3134 = x2913*x79
    x3135 = x184*x3046
    x3136 = x3050*x83
    x3137 = x3042*x83
    x3138 = x184*x3050
    x3139 = x3046*x78
    x3140 = x651*x915
    x3141 = x798*x814
    x3142 = x653*x811
    x3143 = x798*x811
    x3144 = x653*x915
    x3145 = x651*x814
    x3146 = x642*x977
    x3147 = x796*x922
    x3148 = x645*x924
    x3149 = x645*x977
    x3150 = x642*x922
    x3151 = x796*x924
    x3152 = x1681 + x3146 + x3147 + x3148 - x3149 - x3150 - x3151 + x686
    x3153 = x1231 + x1987 + x2727 + x3140 + x3141 + x3142 - x3143 - x3144 - x3145 + x3152
    x3154 = x3125*x90
    x3155 = x1540*x3127
    x3156 = x106*x3129
    x3157 = x2920*x78
    x3158 = x184*x2918
    x3159 = x2923*x83
    x3160 = x789*x922
    x3161 = x664*x977
    x3162 = x660*x924
    x3163 = x1793 + x2460 - x933 + x934 - x935 + x936 + x942 - x950 - x954
    x3164 = -x11*x26*x322*x479 - x14*x19*x29*x479 - x17*x19*x322*x8 + x3099 + x3160 + x3161 + x3162 + x3163
    x3165 = x1654 + x2236 + x2926 + x2928 + x2930 - x2932 - x2934 - x2936 + x655
    x3166 = 2*x3143
    x3167 = 2*x3144
    x3168 = 2*x3145
    x3169 = 2*x3140
    x3170 = 2*x3141
    x3171 = 2*x3142
    x3172 = x1712 + x771
    x3173 = 2*x3146 + 2*x3147 + 2*x3148 - 2*x3149 - 2*x3150 - 2*x3151 + x3172
    x3174 = x1242 + x1997 + x2753 - x3166 - x3167 - x3168 + x3169 + x3170 + x3171 + x3173
    x3175 = x1690 + x2464 + x2927 + x2929 + x2931 - x2933 - x2935 - x2937 + x3112 + x720
    x3176 = x1798 - x1799 + x1800 - x1801 + x2465 + x963 - x964 + x965 - x966
    x3177 = -2*x11*x26*x322*x479 - 2*x14*x19*x29*x479 - 2*x17*x19*x322*x8 + x3115 + 2*x3160 + 2*x3161 + 2*x3162 + x3176
    x3178 = x2990*x956 + x2991*x940 + x2993*x962 + x713*(2*x3126 + 2*x3128 + 2*x3130 - 2*x3131 - 2*x3132 - 2*x3133 + 2*x3134 + 2*x3135 + 2*x3136 - 2*x3137 - 2*x3138 - 2*x3139 + x3174) + x760*(x2994 + x2995 + x2996 - x2997 - x2998 - x2999 + x3114 + x3175) + x772*(2*x1*x16*x28*x31*x72*x74 + 2*x1*x2225*x2226*x29*x43 + 2*x11*x1525*x1526*x25*x31 + 2*x13*x17*x7*x72*x74 + 2*x13*x2225*x2226*x25*x28*x6 + 2*x1525*x1526*x16*x43*x6*x7 - 2*x3154 - 2*x3155 - 2*x3156 - 2*x3157 - 2*x3158 - 2*x3159 - x3177)
    x3179 = x2837*x969
    x3180 = -x1438 - x1439 - x1440 + x1515*x785 + x1515*x981 + x1516*x793 + x3022*x969 + x3025*x972 + x3026*x982 + x3028*x982 + x3030*x983 + x3032*x983 + x3119*x982 + x3120*x980 + x3121*x981 + x3122*x797 + x3123*x62 + x787*x972 + x791*x980 + x794*x974 + x799*x978 - x973 - x975 - x976
    x3181 = x72*x986
    x3182 = x2*x3181
    x3183 = x16*x3182
    x3184 = -x3182*x4*x83 + x3182*x79 + x3183*x80 - x3183*x82 + x817
    x3185 = x1*x3182
    x3186 = -x1*x2*x28*x31*x72*x986 - x13*x16*x2*x7*x72*x986 + x3183*x90 + x3185*x78 + x648 + x826
    x3187 = x3182*x4
    x3188 = -x106*x3187 - x3182*x633 + x3185*x82 + x3187*x90 + x843
    x3189 = x148*x898 + x151*x911 + x155*x908 - x3184*x67 + x3186*x62 - x3188*x56
    x3190 = x178*(-x851*x997 - x870*x999 - x882*x998)
    x3191 = x143*x3190
    x3192 = x200*x3181
    x3193 = x16*x3192
    x3194 = x1213 - x3192*x4*x83 + x3192*x79 + x3193*x80 - x3193*x82 + x723
    x3195 = x1*x3192
    x3196 = -x1*x200*x28*x31*x72*x986 + x1141 + x1219 - x13*x16*x200*x7*x72*x986 + x3193*x90 + x3195*x78
    x3197 = x3192*x4
    x3198 = -x106*x3197 + x1232 - x3192*x633 + x3195*x82 + x3197*x90 + x768
    x3199 = x224*x898 + x227*x908 + x234*x911 - x3194*x67 + x3196*x62 - x3198*x56
    x3200 = x245*x3190
    x3201 = x269*x3181
    x3202 = x16*x3201
    x3203 = x1455 - x3201*x4*x83 + x3201*x79 + x3202*x80 - x3202*x82
    x3204 = x1*x3201
    x3205 = -x1*x269*x28*x31*x72*x986 - x13*x16*x269*x7*x72*x986 + x1405 + x1460 + x3202*x90 + x3204*x78
    x3206 = x3201*x4
    x3207 = -x106*x3206 + x1471 - x3201*x633 + x3204*x82 + x3206*x90
    x3208 = x291*x898 + x297*x911 + x300*x908 - x3203*x67 + x3205*x62 - x3207*x56
    x3209 = x306*x3190
    x3210 = x1525*x1813
    x3211 = x321*x3210
    x3212 = x3211*x9
    x3213 = x3211*x6
    x3214 = x1530*x3211 + x1738 - x184*x3212 + x3212*x83 - x3213*x80
    x3215 = x3211*x7
    x3216 = -x1525*x16*x1813*x321*x43*x7 - x1525*x1813*x25*x31*x321*x6 + x1540*x3213 + x1650 + x1745 + x3215*x83
    x3217 = x1540*x3212 + x1761 - x182*x3215 - x3212*x90 + x3215*x80
    x3218 = -x3214*x67 + x3216*x62 - x3217*x56 + x337*x898 + x350*x911 + x356*x908
    x3219 = x3190*x381
    x3220 = x3210*x389
    x3221 = x3220*x9
    x3222 = x3220*x6
    x3223 = x1530*x3220 + x1693 - x184*x3221 + x1968 + x3221*x83 - x3222*x80
    x3224 = x3220*x7
    x3225 = -x1525*x16*x1813*x389*x43*x7 - x1525*x1813*x25*x31*x389*x6 + x1540*x3222 + x1899 + x1974 + x3224*x83
    x3226 = x1540*x3221 + x1709 - x182*x3224 + x1988 - x3221*x90 + x3224*x80
    x3227 = -x3223*x67 + x3225*x62 - x3226*x56 + x398*x898 + x401*x908 + x410*x911
    x3228 = x3190*x428
    x3229 = x3210*x436
    x3230 = x3229*x9
    x3231 = x3229*x6
    x3232 = x1530*x3229 - x184*x3230 + x2158 + x3230*x83 - x3231*x80
    x3233 = x3229*x7
    x3234 = -x1525*x16*x1813*x43*x436*x7 - x1525*x1813*x25*x31*x436*x6 + x1540*x3231 + x2107 + x2163 + x3233*x83
    x3235 = x1540*x3230 - x182*x3233 + x2174 - x3230*x90 + x3233*x80
    x3236 = -x3232*x67 + x3234*x62 - x3235*x56 + x446*x898 + x453*x911 + x456*x908
    x3237 = x3190*x470
    x3238 = x2225*x2482
    x3239 = x3238*x478
    x3240 = x28*x3239
    x3241 = x3239*x78
    x3242 = -x13*x2225*x2482*x28*x478*x9 - x16*x2225*x24*x2482*x43*x478 + x182*x3240 + x24*x3241 + x2408
    x3243 = x25*x3239
    x3244 = -x106*x3240 + x1540*x3240 - x184*x3243 + x2324 + x2416 + x25*x3241
    x3245 = -x13*x2225*x24*x2482*x478*x7 + x1540*x24*x3239 - x2225*x2482*x25*x4*x43*x478 + x2427 + x3243*x82
    x3246 = x3242*x67 - x3244*x62 + x3245*x56 + x488*x898 + x496*x911 + x507*x908
    x3247 = x3190*x529
    x3248 = x3238*x538
    x3249 = x28*x3248
    x3250 = x3248*x78
    x3251 = -x10*x28*x322*x479*x538 - x13*x2225*x2482*x28*x538*x9 - x16*x19*x24*x4*x479*x538 - x16*x2225*x24*x2482*x43*x538 + x182*x3249 + x2328 + x2370 + x24*x3250 + x2415 + x2558 + x2602 + x2608
    x3252 = x25*x3248
    x3253 = -x106*x3249 + x1540*x3249 - x184*x3252 + x25*x3250 + x2544 + x2614
    x3254 = -x13*x2225*x24*x2482*x538*x7 - x15*x19*x25*x479*x538 + x1540*x24*x3248 - x2225*x2482*x25*x4*x43*x538 + x2362 - x24*x322*x479*x538*x7*x9 + x2620 + x2624 + x2656 + x2790 + x2818 + x3252*x82
    x3255 = x3251*x67 - x3253*x62 + x3254*x56 + x545*x898 + x554*x908 + x561*x911
    x3256 = x3190*x577
    x3257 = x3238*x586
    x3258 = x28*x3257
    x3259 = x3257*x78
    x3260 = -x13*x2225*x2482*x28*x586*x9 - x16*x2225*x24*x2482*x43*x586 + x182*x3258 + x24*x3259 + x2773
    x3261 = x25*x3257
    x3262 = -x106*x3258 + x1540*x3258 - x184*x3261 + x25*x3259 + x2723 + x2779
    x3263 = -x13*x2225*x24*x2482*x586*x7 + x1540*x24*x3257 - x2225*x2482*x25*x4*x43*x586 + x2788 + x3261*x82
    x3264 = x3260*x67 - x3262*x62 + x3263*x56 + x594*x898 + x599*x911 + x607*x908
    x3265 = x3190*x621
    x3266 = x16*x3181
    x3267 = x3266*x633
    x3268 = x3210*x7
    x3269 = x1530*x3268
    x3270 = x25*x3238
    x3271 = x28*x3270
    x3272 = x3271*x82
    x3273 = x1*x3266
    x3274 = x3273*x82
    x3275 = x182*x3271
    x3276 = x3268*x6
    x3277 = x3276*x80
    x3278 = x3181*x637
    x3279 = x3278*x78
    x3280 = x2319*x3270
    x3281 = x3210*x644
    x3282 = x3281*x83
    x3283 = x3278*x83
    x3284 = x184*x3281
    x3285 = x24*x3270
    x3286 = x3285*x78
    x3287 = x2543 + x3279 + x3280 + x3282 - x3283 - x3284 - x3286
    x3288 = x14*x3181
    x3289 = x3288*x78
    x3290 = x3210*x8
    x3291 = x3290*x83
    x3292 = x26*x3238
    x3293 = x184*x3292
    x3294 = x3273*x90
    x3295 = x1540*x3276
    x3296 = x106*x3271
    x3297 = x3288*x82
    x3298 = x3290*x80
    x3299 = x182*x3292
    x3300 = x3288*x80
    x3301 = x182*x3290
    x3302 = x3292*x82
    x3303 = x3278*x90
    x3304 = x1540*x3281
    x3305 = x106*x3285
    x3306 = x106*x3278
    x3307 = x1540*x3285
    x3308 = x3281*x90
    x3309 = -mpmath.mpf(1)/mpmath.mpf(2)*x844 - mpmath.mpf(1)/mpmath.mpf(2)*x846 + (mpmath.mpf(1)/mpmath.mpf(2))*x847 + (mpmath.mpf(1)/mpmath.mpf(2))*x849 + (mpmath.mpf(1)/mpmath.mpf(2))*x905 - mpmath.mpf(1)/mpmath.mpf(2)*x906
    x3310 = x2989 + x3309
    x3311 = (mpmath.mpf(1)/mpmath.mpf(2))*x10*x16*x322*x43 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x16*x19*x4*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x27*x479*x6 + (mpmath.mpf(1)/mpmath.mpf(2))*x15*x19*x28*x31 + (mpmath.mpf(1)/mpmath.mpf(2))*x24*x28*x4*x43*x479 + (mpmath.mpf(1)/mpmath.mpf(2))*x24*x31*x322*x6*x9 - x2992 - mpmath.mpf(1)/mpmath.mpf(2)*x862 - mpmath.mpf(1)/mpmath.mpf(2)*x864 - mpmath.mpf(1)/mpmath.mpf(2)*x865 - mpmath.mpf(1)/mpmath.mpf(2)*x868 - mpmath.mpf(1)/mpmath.mpf(2)*x869 - mpmath.mpf(1)/mpmath.mpf(2)*x897
    x3312 = -x1179 + x1180 - x1936 + x1937 + x2583
    x3313 = (mpmath.mpf(1)/mpmath.mpf(2))*x1*x19*x24*x31*x4 + (mpmath.mpf(1)/mpmath.mpf(2))*x1*x27*x43*x479 + (mpmath.mpf(1)/mpmath.mpf(2))*x10*x25*x31*x322 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x15*x19*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x24*x25*x479*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x322*x4*x43*x7*x9 - x3312 - mpmath.mpf(1)/mpmath.mpf(2)*x874 - mpmath.mpf(1)/mpmath.mpf(2)*x875 - mpmath.mpf(1)/mpmath.mpf(2)*x876 - mpmath.mpf(1)/mpmath.mpf(2)*x879 - mpmath.mpf(1)/mpmath.mpf(2)*x880 - mpmath.mpf(1)/mpmath.mpf(2)*x909
    x3314 = 2*x3274
    x3315 = 2*x3275
    x3316 = 2*x3277
    x3317 = 2*x3267
    x3318 = 2*x3269
    x3319 = 2*x3272
    x3320 = x3101 + 2*x3279 + 2*x3280 + 2*x3282 - 2*x3283 - 2*x3284 - 2*x3286
    x3321 = x3310*x759 + x3311*x712 + x3313*x747 + x713*(x3110 - x3314 - x3315 - x3316 + x3317 + x3318 + x3319 + x3320) + x760*(x3116 + 2*x3297 + 2*x3298 + 2*x3299 - 2*x3300 - 2*x3301 - 2*x3302 + 2*x3303 + 2*x3304 + 2*x3305 - 2*x3306 - 2*x3307 - 2*x3308) + x772*(2*x1*x13*x16*x7*x72*x986 + 2*x1*x2225*x2482*x25*x28*x43 + 2*x13*x2225*x2482*x26*x6 + 2*x14*x28*x31*x72*x986 + 2*x1525*x16*x1813*x43*x8 + 2*x1525*x1813*x25*x31*x6*x7 - x3113 - 2*x3289 - 2*x3291 - 2*x3293 - 2*x3294 - 2*x3295 - 2*x3296)
    x3322 = x3190*x782
    x3323 = x15*x3181
    x3324 = x3323*x78
    x3325 = x10*x3210
    x3326 = x3325*x83
    x3327 = x27*x3238
    x3328 = x184*x3327
    x3329 = x3323*x83
    x3330 = x184*x3325
    x3331 = x3327*x78
    x3332 = 2*x903
    x3333 = 2*x809
    x3334 = 2*x807
    x3335 = x3266*x4
    x3336 = x3335*x80
    x3337 = x3210*x9
    x3338 = x1530*x3337
    x3339 = x3238*x813
    x3340 = x3339*x82
    x3341 = x3335*x82
    x3342 = x182*x3339
    x3343 = x3337*x6
    x3344 = x3343*x80
    x3345 = x3335*x90
    x3346 = x1540*x3343
    x3347 = x106*x3339
    x3348 = x106*x3335
    x3349 = x1540*x3339
    x3350 = x3343*x90
    x3351 = x2347 + x3345 + x3346 + x3347 - x3348 - x3349 - x3350
    x3352 = x3323*x90
    x3353 = x1540*x3325
    x3354 = x106*x3327
    x3355 = x106*x3323
    x3356 = x3325*x90
    x3357 = x1540*x3327
    x3358 = x3278*x82
    x3359 = x182*x3285
    x3360 = x3281*x80
    x3361 = x3278*x80
    x3362 = x182*x3281
    x3363 = x3285*x82
    x3364 = 2*x908
    x3365 = x1720 + x780
    x3366 = 2*x3345 + 2*x3346 + 2*x3347 - 2*x3348 - 2*x3349 - 2*x3350 + x3365
    x3367 = 4*x903
    x3368 = 4*x809
    x3369 = 4*x807
    x3370 = 4*x2414
    x3371 = 4*x823
    x3372 = 4*x848
    x3373 = 4*x1743
    x3374 = 4*x824
    x3375 = 4*x2413
    x3376 = x3310*x851 + x3311*x870 + x3313*x882 + x713*(x1236*x36 + x1237*x21 + x1657*x1991 + x1992*x328 + x2332*x2630 + x2333*x2629 + x3001 + 2*x3324 + 2*x3326 + 2*x3328 - 2*x3329 - 2*x3330 - 2*x3331 + 2*x3336 + 2*x3338 + 2*x3340 - 2*x3341 - 2*x3342 - 2*x3344 + x3367*x811 - x3367*x814 + x3368*x814 - x3368*x915 - x3369*x811 + x3369*x915 - x3370 - x3371 - x3372 + x3373 + x3374 + x3375) + x760*(x112*x1236 + x114*x1237 + x1976*x1992 + x1991*x344 + x2616*x2629 + x2617*x2630 + x3003 + x3004 + x3005 - x3006 - x3007 - x3008 + x3013 + 2*x3352 + 2*x3353 + 2*x3354 - 2*x3355 - 2*x3356 - 2*x3357 + 2*x3358 + 2*x3359 + 2*x3360 - 2*x3361 - 2*x3362 - 2*x3363 + x3367*x642 - x3367*x645 - x3368*x642 + x3368*x796 + x3369*x645 - x3369*x796) + x772*(4*x1*x19*x24*x28*x4*x479 + 4*x16*x19*x322*x4*x7*x9 + 4*x24*x25*x322*x479*x6*x9 - x2627 - 4*x3058 - 4*x3059 - 4*x3060 - x3320 - x3366)
    x3377 = 2*x914
    x3378 = 2*x1516
    x3379 = x1*x898
    x3380 = 2*x912
    x3381 = x4*x912
    x3382 = x16*x911
    x3383 = x3190*x895
    x3384 = x158*x913
    x3385 = x56*x915
    x3386 = x17*x3181
    x3387 = x3386*x80
    x3388 = x11*x3210
    x3389 = x182*x3388
    x3390 = x29*x3238
    x3391 = x3390*x82
    x3392 = x3386*x82
    x3393 = x3388*x80
    x3394 = x182*x3390
    x3395 = x3266*x79
    x3396 = x184*x3339
    x3397 = x3343*x83
    x3398 = x3335*x83
    x3399 = x184*x3343
    x3400 = x3339*x78
    x3401 = x903*x922
    x3402 = x807*x977
    x3403 = x809*x924
    x3404 = x903*x924
    x3405 = x809*x977
    x3406 = x807*x922
    x3407 = x1757 + x2772 + x3163 + x3401 + x3402 + x3403 - x3404 - x3405 - x3406 + x840
    x3408 = x3386*x90
    x3409 = x1540*x3388
    x3410 = x106*x3390
    x3411 = x3273*x78
    x3412 = x184*x3271
    x3413 = x3276*x83
    x3414 = -x1*x16*x19*x24*x28*x479 + x116 + x1556 - x16*x19*x322*x4*x6*x7 - x25*x28*x322*x479*x6*x9 + x2775 + x3143 + x3144 + x3145 + x3152
    x3415 = x1145 + x1543 + x1903 + x2658 - x3052 - x3053 - x3054 + x3055 + x3056 + x3057 + x3064 + x93
    x3416 = x3166 + x3167 + x3168 - x3169 - x3170 - x3171
    x3417 = x2791 + x3012 + x3173 + x3416
    x3418 = x2661 + x2967 + x3102 + x3103 + x3104 - x3105 - x3106 - x3107 + x3108
    x3419 = x1770 + x2793 + x3176 + 2*x3401 + 2*x3402 + 2*x3403 - 2*x3404 - 2*x3405 - 2*x3406 + x887
    x3420 = x3310*x962 + x3311*x956 + x3313*x940 + x713*(2*x3387 + 2*x3389 + 2*x3391 - 2*x3392 - 2*x3393 - 2*x3394 + 2*x3395 + 2*x3396 + 2*x3397 - 2*x3398 - 2*x3399 - 2*x3400 + x3419) + x760*(x3314 + x3315 + x3316 - x3317 - x3318 - x3319 + x3366 + x3418) + x772*(2*x1*x16*x28*x31*x72*x986 + 2*x1*x2225*x2482*x29*x43 + 2*x11*x1525*x1813*x25*x31 + 2*x13*x17*x7*x72*x986 + 2*x13*x2225*x2482*x25*x28*x6 + 2*x1525*x16*x1813*x43*x6*x7 - 2*x3408 - 2*x3409 - 2*x3410 - 2*x3411 - 2*x3412 - 2*x3413 - x3417)
    x3421 = x3190*x969
    x3422 = x1*x972
    x3423 = x4*x982
    x3424 = x16*x981
    x3425 = x158*x797
    x3426 = x62*x915
    x3427 = -x1266 - x1267 - x1268 - x1478 - x1479 - x1480 + x1515*x898 + x1516*x908 + x1516*x981 + x3379*x982 + x3381*x980 + x3382*x982 + x3384*x983 + x3385*x983 + x3422*x912 + x3423*x908 + x3424*x912 + x3425*x914 + x3426*x914 + x791*x972 + x900*x980 + x904*x983 + x911*x974 + x914*x978
    x3428 = x1271*x72
    x3429 = x2*x3428
    x3430 = x16*x3429
    x3431 = -x3429*x4*x83 + x3429*x79 + x3430*x80 - x3430*x82 + x928
    x3432 = x1*x3429
    x3433 = -x1*x1271*x2*x28*x31*x72 - x1271*x13*x16*x2*x7*x72 + x3430*x90 + x3432*x78 + x938
    x3434 = x3429*x4
    x3435 = -x106*x3434 - x3429*x633 + x3432*x82 + x3434*x90 + x826 + x939
    x3436 = x148*x972 + x151*x981 + x155*x980 - x3431*x67 + x3433*x62 - x3435*x56
    x3437 = x178*(-x940*x998 - x956*x999 - x962*x997)
    x3438 = x143*x3437
    x3439 = x200*x3428
    x3440 = x16*x3439
    x3441 = x1257 - x3439*x4*x83 + x3439*x79 + x3440*x80 - x3440*x82
    x3442 = x1*x3439
    x3443 = -x1*x1271*x200*x28*x31*x72 + x1262 - x1271*x13*x16*x200*x7*x72 + x3440*x90 + x3442*x78
    x3444 = x3439*x4
    x3445 = -x106*x3444 + x1219 + x1263 - x3439*x633 + x3442*x82 + x3444*x90
    x3446 = x224*x972 + x227*x980 + x234*x981 - x3441*x67 + x3443*x62 - x3445*x56
    x3447 = x245*x3437
    x3448 = x269*x3428
    x3449 = x16*x3448
    x3450 = x1496 - x3448*x4*x83 + x3448*x79 + x3449*x80 - x3449*x82 + x720
    x3451 = x1*x3448
    x3452 = -x1*x1271*x269*x28*x31*x72 - x1*x19*x269*x29*x479 + x1140 + x1233 - x1271*x13*x16*x269*x7*x72 + x1470 + x1500 + x1504 - x16*x19*x269*x322*x6*x7 + x3449*x90 + x3451*x78 + x674
    x3453 = x3448*x4
    x3454 = -x106*x3453 + x1460 + x1505 - x3448*x633 + x3451*x82 + x3453*x90
    x3455 = x291*x972 + x297*x981 + x300*x980 - x3450*x67 + x3452*x62 - x3454*x56
    x3456 = x306*x3437
    x3457 = x1525*x2028
    x3458 = x321*x3457
    x3459 = x3458*x9
    x3460 = x3458*x6
    x3461 = x1530*x3458 + x1788 - x184*x3459 + x3459*x83 - x3460*x80
    x3462 = x3458*x7
    x3463 = -x1525*x16*x2028*x321*x43*x7 - x1525*x2028*x25*x31*x321*x6 + x1540*x3460 + x1795 + x3462*x83
    x3464 = x1540*x3459 + x1745 + x1796 - x182*x3462 - x3459*x90 + x3462*x80
    x3465 = x337*x972 - x3461*x67 + x3463*x62 - x3464*x56 + x350*x981 + x356*x980
    x3466 = x3437*x381
    x3467 = x3457*x389
    x3468 = x3467*x9
    x3469 = x3467*x6
    x3470 = x1530*x3467 - x184*x3468 + x2011 + x3468*x83 - x3469*x80
    x3471 = x3467*x7
    x3472 = -x1525*x16*x2028*x389*x43*x7 - x1525*x2028*x25*x31*x389*x6 + x1540*x3469 + x2016 + x3471*x83
    x3473 = x1540*x3468 - x182*x3471 + x1974 + x2017 - x3468*x90 + x3471*x80
    x3474 = -x3470*x67 + x3472*x62 - x3473*x56 + x398*x972 + x401*x980 + x410*x981
    x3475 = x3437*x428
    x3476 = x3457*x436
    x3477 = x3476*x9
    x3478 = x3476*x6
    x3479 = x1530*x3476 + x1690 - x184*x3477 + x2195 + x3477*x83 - x3478*x80
    x3480 = x3476*x7
    x3481 = -x1525*x16*x2028*x43*x436*x7 - x1525*x2028*x25*x31*x436*x6 + x1540*x3478 + x1669 - x17*x19*x322*x436*x7 + x1898 + x1989 + x2173 + x2199 + x2202 - x25*x28*x322*x436*x479*x6 + x3480*x83
    x3482 = x1540*x3477 - x182*x3480 + x2163 + x2204 - x3477*x90 + x3480*x80
    x3483 = -x3479*x67 + x3481*x62 - x3482*x56 + x446*x972 + x453*x981 + x456*x980
    x3484 = x3437*x470
    x3485 = x2225*x2678
    x3486 = x3485*x478
    x3487 = x28*x3486
    x3488 = x3486*x78
    x3489 = -x13*x2225*x2678*x28*x478*x9 - x16*x2225*x24*x2678*x43*x478 + x182*x3487 + x24*x3488 + x2449
    x3490 = x25*x3486
    x3491 = -x106*x3487 + x1540*x3487 - x184*x3490 + x2461 + x25*x3488
    x3492 = -x13*x2225*x24*x2678*x478*x7 + x1540*x24*x3486 - x2225*x25*x2678*x4*x43*x478 + x2416 + x2462 + x3490*x82
    x3493 = x3489*x67 - x3491*x62 + x3492*x56 + x488*x972 + x496*x981 + x507*x980
    x3494 = x3437*x529
    x3495 = x3485*x538
    x3496 = x28*x3495
    x3497 = x3495*x78
    x3498 = -x13*x2225*x2678*x28*x538*x9 - x16*x2225*x24*x2678*x43*x538 + x182*x3496 + x24*x3497 + x2647
    x3499 = x25*x3495
    x3500 = -x106*x3496 + x1540*x3496 - x184*x3499 + x25*x3497 + x2657
    x3501 = -x13*x2225*x24*x2678*x538*x7 + x1540*x24*x3495 - x2225*x25*x2678*x4*x43*x538 + x2614 + x2659 + x3499*x82
    x3502 = x3498*x67 - x3500*x62 + x3501*x56 + x545*x972 + x554*x980 + x561*x981
    x3503 = x3437*x577
    x3504 = x3485*x586
    x3505 = x28*x3504
    x3506 = x3504*x78
    x3507 = -x13*x2225*x2678*x28*x586*x9 - x16*x2225*x24*x2678*x43*x586 - x17*x19*x24*x479*x586 + x182*x3505 + x2092 + x2308 + x2323 + x2373 + x24*x3506 + x2609 - x28*x322*x479*x586*x6*x9 + x2803 + x2807 + x595
    x3508 = x25*x3504
    x3509 = -x106*x3505 + x1540*x3505 - x184*x3508 + x2396 + x25*x3506 + x2817
    x3510 = -x13*x2225*x24*x2678*x586*x7 + x1540*x24*x3504 - x2225*x25*x2678*x4*x43*x586 + x2820 + x3508*x82
    x3511 = x3507*x67 - x3509*x62 + x3510*x56 + x594*x972 + x599*x981 + x607*x980
    x3512 = x3437*x621
    x3513 = x16*x3428
    x3514 = x3513*x633
    x3515 = x3457*x7
    x3516 = x1530*x3515
    x3517 = x25*x3485
    x3518 = x28*x3517
    x3519 = x3518*x82
    x3520 = x1*x3513
    x3521 = x3520*x82
    x3522 = x182*x3518
    x3523 = x3515*x6
    x3524 = x3523*x80
    x3525 = x3428*x637
    x3526 = x3525*x78
    x3527 = x2319*x3517
    x3528 = x3457*x644
    x3529 = x3528*x83
    x3530 = x3525*x83
    x3531 = x184*x3528
    x3532 = x24*x3517
    x3533 = x3532*x78
    x3534 = x3526 + x3527 + x3529 - x3530 - x3531 - x3533
    x3535 = x14*x3428
    x3536 = x3535*x78
    x3537 = x3457*x8
    x3538 = x3537*x83
    x3539 = x26*x3485
    x3540 = x184*x3539
    x3541 = x3520*x90
    x3542 = x1540*x3523
    x3543 = x106*x3518
    x3544 = x3535*x82
    x3545 = x3537*x80
    x3546 = x182*x3539
    x3547 = x3535*x80
    x3548 = x182*x3537
    x3549 = x3539*x82
    x3550 = x3525*x90
    x3551 = x1540*x3528
    x3552 = x106*x3532
    x3553 = x106*x3525
    x3554 = x1540*x3532
    x3555 = x3528*x90
    x3556 = (mpmath.mpf(1)/mpmath.mpf(2))*x11*x24*x31*x322 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x17*x19*x9 + (mpmath.mpf(1)/mpmath.mpf(2))*x13*x24*x28*x479*x6 + (mpmath.mpf(1)/mpmath.mpf(2))*x16*x19*x28*x31*x4 + (mpmath.mpf(1)/mpmath.mpf(2))*x16*x322*x43*x6*x9 - x1697 - x2746 + (mpmath.mpf(1)/mpmath.mpf(2))*x29*x4*x43*x479 - x727 - mpmath.mpf(1)/mpmath.mpf(2)*x948 - mpmath.mpf(1)/mpmath.mpf(2)*x949 - mpmath.mpf(1)/mpmath.mpf(2)*x951 - mpmath.mpf(1)/mpmath.mpf(2)*x953 - mpmath.mpf(1)/mpmath.mpf(2)*x955 - mpmath.mpf(1)/mpmath.mpf(2)*x971
    x3557 = x2983 + x2984 + x2985 - x2986 - x2987 - x2988 - x3309
    x3558 = -mpmath.mpf(1)/mpmath.mpf(2)*x1*x934 - mpmath.mpf(1)/mpmath.mpf(2)*x16*x673 - mpmath.mpf(1)/mpmath.mpf(2)*x16*x94 - mpmath.mpf(1)/mpmath.mpf(2)*x25*x944 + x3312 - mpmath.mpf(1)/mpmath.mpf(2)*x6*x701 - mpmath.mpf(1)/mpmath.mpf(2)*x7*x942 + (mpmath.mpf(1)/mpmath.mpf(2))*x957 + (mpmath.mpf(1)/mpmath.mpf(2))*x958 + (mpmath.mpf(1)/mpmath.mpf(2))*x959 + (mpmath.mpf(1)/mpmath.mpf(2))*x960 + (mpmath.mpf(1)/mpmath.mpf(2))*x961 + (mpmath.mpf(1)/mpmath.mpf(2))*x979
    x3559 = 2*x3521
    x3560 = 2*x3522
    x3561 = 2*x3524
    x3562 = 2*x3514
    x3563 = 2*x3516
    x3564 = 2*x3519
    x3565 = 2*x3526 + 2*x3527 + 2*x3529 - 2*x3530 - 2*x3531 - 2*x3533
    x3566 = x3556*x712 + x3557*x747 + x3558*x759 + x713*(x3174 - x3559 - x3560 - x3561 + x3562 + x3563 + x3564 + x3565) + x760*(x3175 + 2*x3544 + 2*x3545 + 2*x3546 - 2*x3547 - 2*x3548 - 2*x3549 + 2*x3550 + 2*x3551 + 2*x3552 - 2*x3553 - 2*x3554 - 2*x3555) + x772*(2*x1*x1271*x13*x16*x7*x72 + 2*x1*x2225*x25*x2678*x28*x43 + 2*x1271*x14*x28*x31*x72 + 2*x13*x2225*x26*x2678*x6 + 2*x1525*x16*x2028*x43*x8 + 2*x1525*x2028*x25*x31*x6*x7 - x3177 - 2*x3536 - 2*x3538 - 2*x3540 - 2*x3541 - 2*x3542 - 2*x3543)
    x3567 = x3437*x782
    x3568 = x15*x3428
    x3569 = x3568*x78
    x3570 = x10*x3457
    x3571 = x3570*x83
    x3572 = x27*x3485
    x3573 = x184*x3572
    x3574 = x3568*x83
    x3575 = x184*x3570
    x3576 = x3572*x78
    x3577 = x3513*x4
    x3578 = x3577*x80
    x3579 = x3457*x9
    x3580 = x1530*x3579
    x3581 = x3485*x813
    x3582 = x3581*x82
    x3583 = x3577*x82
    x3584 = x182*x3581
    x3585 = x3579*x6
    x3586 = x3585*x80
    x3587 = x3577*x90
    x3588 = x1540*x3585
    x3589 = x106*x3581
    x3590 = x106*x3577
    x3591 = x1540*x3581
    x3592 = x3585*x90
    x3593 = x3587 + x3588 + x3589 - x3590 - x3591 - x3592
    x3594 = x3568*x90
    x3595 = x1540*x3570
    x3596 = x106*x3572
    x3597 = x106*x3568
    x3598 = x3570*x90
    x3599 = x1540*x3572
    x3600 = x3525*x82
    x3601 = x182*x3532
    x3602 = x3528*x80
    x3603 = x3525*x80
    x3604 = x182*x3528
    x3605 = x3532*x82
    x3606 = 2*x3587 + 2*x3588 + 2*x3589 - 2*x3590 - 2*x3591 - 2*x3592
    x3607 = x3556*x870 + x3557*x882 + x3558*x851 + x713*(x3419 + 2*x3569 + 2*x3571 + 2*x3573 - 2*x3574 - 2*x3575 - 2*x3576 + 2*x3578 + 2*x3580 + 2*x3582 - 2*x3583 - 2*x3584 - 2*x3586) + x760*(x3365 + x3418 + 2*x3594 + 2*x3595 + 2*x3596 - 2*x3597 - 2*x3598 - 2*x3599 + 2*x3600 + 2*x3601 + 2*x3602 - 2*x3603 - 2*x3604 - 2*x3605) + x772*(-x3417 - x3565 - x3606)
    x3608 = x3437*x895
    x3609 = x17*x3428
    x3610 = x3609*x80
    x3611 = x11*x3457
    x3612 = x182*x3611
    x3613 = x29*x3485
    x3614 = x3613*x82
    x3615 = x3609*x82
    x3616 = x3611*x80
    x3617 = x182*x3613
    x3618 = 2*x977
    x3619 = 2*x922
    x3620 = 2*x924
    x3621 = x3513*x79
    x3622 = x184*x3581
    x3623 = x3585*x83
    x3624 = x3577*x83
    x3625 = x184*x3585
    x3626 = x3581*x78
    x3627 = x106*x3609
    x3628 = x3611*x90
    x3629 = x1540*x3613
    x3630 = x3609*x90
    x3631 = x1540*x3611
    x3632 = x106*x3613
    x3633 = x3520*x83
    x3634 = x184*x3523
    x3635 = x3518*x78
    x3636 = x3520*x78
    x3637 = x184*x3518
    x3638 = x3523*x83
    x3639 = 4*x977
    x3640 = 4*x922
    x3641 = 4*x924
    x3642 = x3556*x956 + x3557*x940 + x3558*x962 + x713*(x107*x1508 + x109*x1507 + x1670*x2206 + x2205*x339 + x2349*x2823 + x2350*x2824 + x3001 + x3370 + x3371 + x3372 - x3373 - x3374 - x3375 + 2*x3610 + 2*x3612 + 2*x3614 - 2*x3615 - 2*x3616 - 2*x3617 + 2*x3621 + 2*x3622 + 2*x3623 - 2*x3624 - 2*x3625 - 2*x3626 - x3639*x811 + x3639*x814 - x3640*x814 + x3640*x915 + x3641*x811 - x3641*x915) + x760*(x3013 - 4*x3140 - 4*x3141 - 4*x3142 + 4*x3143 + 4*x3144 + 4*x3145 + x3559 + x3560 + x3561 - x3562 - x3563 - x3564 + x3606) + x772*(x112*x1508 + x114*x1507 + x1976*x2205 + x2206*x344 + x2616*x2824 + x2617*x2823 + x3014 + x3015 + x3016 - x3017 - x3018 - x3019 + x3020 + 2*x3627 + 2*x3628 + 2*x3629 - 2*x3630 - 2*x3631 - 2*x3632 + 2*x3633 + 2*x3634 + 2*x3635 - 2*x3636 - 2*x3637 - 2*x3638 + x3639*x651 - x3639*x653 + x3640*x653 - x3640*x798 - x3641*x651 + x3641*x798)
    x3643 = 2*x983
    x3644 = 2*x982
    x3645 = x3437*x969

    return np.array([-x103*x104 + x105*x176 + x123*x124 + 2*x127 + 2*x147 + 2*x150*x169 + 2*x156*x167 + x157*x159 + x157*x161 + x157*x163 + 2*x165*x42 + x170*x172 + x172*x173 + x172*x174 + x175*x77 + x177*x81 + x180*x181 + x180*x183 + x180*x185 + x187*x189 + x189*x191 + x189*x193 + x199 + 2*x71 + x87*x88, -x104*x209 + x124*x218 + x159*x235 + x161*x235 + x163*x235 + x175*x201 + x176*x210 + x177*x202 + x181*x246 + x183*x246 + x185*x246 + x204*x88 + x268, -x104*x279 + x124*x284 + x159*x301 + x161*x301 + x163*x301 + x175*x270 + x176*x280 + x177*x271 + x181*x307 + x183*x307 + x185*x307 + x273*x88 + x320, x159*x371 + x161*x371 + x163*x371 + x181*x382 + x183*x382 + x185*x382 + x388, x159*x421 + x161*x421 + x163*x421 + x181*x429 + x183*x429 + x185*x429 + x435, x159*x465 + x161*x465 + x163*x465 + x181*x471 + x183*x471 + x185*x471 + x477, x159*x521 + x161*x521 + x163*x521 + x181*x530 + x183*x530 + x185*x530 + x537, x159*x572 + x161*x572 + x163*x572 + x181*x578 + x183*x578 + x185*x578 + x585, x159*x616 + x161*x616 + x163*x616 + x181*x622 + x183*x622 + x185*x622 + x629, x104*(x203 + x21*x657 + x36*x631 + x368 + x511 + x659 + x661 - x663 - x665 + x666 + x667 - x668 - x669 + x674 + x93) + x124*(x107*x657 + x109*x631 + x675 - x676 + x677 - x678 + x687) + x126*x631 + x159*x781 + x161*x781 + x163*x781 + x176*x638 + x177*x635 + x181*x783 + x183*x783 + x185*x783 + x658*x688 + x800 + x88*(x634 - x636 + x649 + x656), x104*(-x649 - x827) + x124*(x828 - x829 + x830 - x831 + x843) + x159*x893 + x161*x893 + x163*x893 + x176*x801 + x177*x804 + x181*x896 + x183*x896 + x185*x896 + x76*x894 + x88*(x802 - x803 + x805 - x806 + x817) + x916, x104*(x1*x16*x28*x31*x72*x75 + x13*x17*x7*x72*x75 - x929 - x930 - x938) + x124*(-x634 + x636 + x827 + x939) + x159*x968 + x161*x968 + x163*x968 + x175*x632 + x176*x804 + x177*x917 + x181*x970 + x183*x970 + x185*x970 + x88*(x918 - x919 + x920 - x921 + x928) + x984, x1001*x181 + x1001*x183 + x1001*x185 - x104*x993 + x124*x995 + x159*x996 + x161*x996 + x163*x996 + x175*x989 + x176*x994 + x177*x990 + x268 + x88*x991, 2*x1002 + x1005*x175 + x1006*x177 + x1007*x88 - x1009*x104 + x1014*x176 + x1015*x124 + 2*x1016 + 2*x1017 + x1018*x159 + x1018*x161 + x1018*x163 + x1019*x1020 + x1020*x1025 + x1021*x1022 + x1022*x1026 + x1023*x1024 + x1024*x1027 + x1028*x181 + x1028*x183 + x1028*x185 + x1029*x1030 + x1030*x1031 + x1030*x1032 + x199, x1033*x175 + x1034*x177 + x1037*x88 - x104*x1040 + x1041*x176 + x1045*x124 + x1046*x159 + x1046*x161 + x1046*x163 + x1047*x181 + x1047*x183 + x1047*x185 + x1063, x1073*x159 + x1073*x161 + x1073*x163 + x1074*x181 + x1074*x183 + x1074*x185 + x1077, x1083*x159 + x1083*x161 + x1083*x163 + x1084*x181 + x1084*x183 + x1084*x185 + x1087, x1092*x159 + x1092*x161 + x1092*x163 + x1093*x181 + x1093*x183 + x1093*x185 + x1096, x1105*x159 + x1105*x161 + x1105*x163 + x1106*x181 + x1106*x183 + x1106*x185 + x1109, x1117*x159 + x1117*x161 + x1117*x163 + x1118*x181 + x1118*x183 + x1118*x185 + x1121, x1126*x159 + x1126*x161 + x1126*x163 + x1127*x181 + x1127*x183 + x1127*x185 + x1130, x104*(x1*x13*x16*x7*x72*x987 - x1148 - x1149 - x1153 + x14*x28*x31*x72*x987) + x1133*x177 + x1135*x176 + x1147*x688 + x1194*x159 + x1194*x161 + x1194*x163 + x1195*x181 + x1195*x183 + x1195*x185 + x1199 + x124*(x1154 - x1155 + x1156 - x1157 + x1166) + x88*(x1132 - x1134 + x1142 + x1146), x104*(-x1142 - x1220) + x1201*x195 + x1203*x176 + x1206*x177 + x124*(x112*x1202 + x114*x1201 + x1221 - x1222 + x1223 - x1224 + x1232) + x1243*x159 + x1243*x161 + x1243*x163 + x1244*x181 + x1244*x183 + x1244*x185 + x1247 + x88*(x1201*x21 + x1202*x36 + x1204 - x1205 + x1207 - x1208 + x1213) + x894*x988, x104*(x1*x16*x28*x31*x72*x987 - x1258 - x1259 - x1262 + x13*x17*x7*x72*x987) + x1131*x175 + x1206*x176 + x124*(-x1132 + x1134 + x1220 + x1263) + x1248*x177 + x1264*x159 + x1264*x161 + x1264*x163 + x1265*x181 + x1265*x183 + x1265*x185 + x1269 + x88*(x1249 - x1250 + x1251 - x1252 + x1257), -x104*x1278 + x124*x1280 + x1274*x175 + x1275*x177 + x1276*x88 + x1279*x176 + x1281*x159 + x1281*x161 + x1281*x163 + x1283*x181 + x1283*x183 + x1283*x185 + x320, -x104*x1288 + x1063 + x124*x1290 + x1284*x175 + x1285*x177 + x1286*x88 + x1289*x176 + x1291*x159 + x1291*x161 + x1291*x163 + x1292*x181 + x1292*x183 + x1292*x185, -x104*x1304 + x1056*x1314 + x124*x1306 + 2*x1293 + x1294*x175 + x1295*x177 + x1299*x88 + x1305*x176 + 2*x1307 + 2*x1308 + x1309*x159 + x1309*x161 + x1309*x163 + x1310*x1311 + x1311*x1315 + x1312*x1313 + x1313*x1316 + x1314*x1317 + x1318*x181 + x1318*x183 + x1318*x185 + x1319*x1320 + x1320*x1321 + x1320*x1322 + x199, x1332*x159 + x1332*x161 + x1332*x163 + x1333*x181 + x1333*x183 + x1333*x185 + x1339, x1345*x159 + x1345*x161 + x1345*x163 + x1346*x181 + x1346*x183 + x1346*x185 + x1349, x1356*x159 + x1356*x161 + x1356*x163 + x1357*x181 + x1357*x183 + x1357*x185 + x1360, x1369*x159 + x1369*x161 + x1369*x163 + x1370*x181 + x1370*x183 + x1370*x185 + x1373, x1379*x159 + x1379*x161 + x1379*x163 + x1380*x181 + x1380*x183 + x1380*x185 + x1383, x1389*x159 + x1389*x161 + x1389*x163 + x1390*x181 + x1390*x183 + x1390*x185 + x1393, x104*(x1*x1272*x13*x16*x7*x72 + x1272*x14*x28*x31*x72 - x1408 - x1409 - x1413) + x124*(x1414 - x1415 + x1416 - x1417 + x1422) + x1397*x177 + x1400*x176 + x1407*x688 + x1436*x159 + x1436*x161 + x1436*x163 + x1437*x181 + x1437*x183 + x1437*x185 + x1443 + x88*(x111 + x1395 + x1396 - x1398 - x1399 + x1406), x104*(-x1406 - x1461) + x124*(x1462 - x1463 + x1464 - x1465 + x1471) + x1273*x894 + x1444*x176 + x1447*x177 + x1476*x159 + x1476*x161 + x1476*x163 + x1477*x181 + x1477*x183 + x1477*x185 + x1482 + x88*(x1445 - x1446 + x1448 - x1449 + x1455), x104*(x1044 + x112*x1484 + x114*x1485 + x1145 + x1340 - x1374 + x1497 + x1498 - x1499 - x1500 + x1501 + x1502 - x1503 - x1504 + x96) + x124*(-x1395 + x1398 + x1461 + x1505) + x1394*x175 + x1447*x176 + x1484*x197 + x1486*x177 + x1511*x159 + x1511*x161 + x1511*x163 + x1512*x181 + x1512*x183 + x1512*x185 + x1517 + x88*(x107*x1484 + x109*x1485 + x1487 - x1488 + x1489 - x1490 + x1496), x1518*x159 + x1518*x161 + x1518*x163 + x1520*x181 + x1520*x183 + x1520*x185 + x388, x1077 + x1521*x159 + x1521*x161 + x1521*x163 + x1522*x181 + x1522*x183 + x1522*x185, x1339 + x1523*x159 + x1523*x161 + x1523*x163 + x1524*x181 + x1524*x183 + x1524*x185, -x104*x1552 + x124*x1563 + x1539*x88 + x1564*x1565 + x1565*x1566 + x1565*x1567 + x1568*x181 + x1568*x183 + x1568*x185 + x1569*x159 + x1569*x161 + x1569*x163, -x104*x1579 + x124*x1587 + x1574*x88 + x1588*x159 + x1588*x161 + x1588*x163 + x1589*x181 + x1589*x183 + x1589*x185 + x1593, -x104*x1604 + x124*x1608 + x159*x1609 + x1598*x88 + x1609*x161 + x1609*x163 + x1610*x181 + x1610*x183 + x1610*x185 + x1611, x159*x1621 + x161*x1621 + x1621*x163 + x1622*x181 + x1622*x183 + x1622*x185 + x1623, x159*x1630 + x161*x1630 + x163*x1630 + x1631*x181 + x1631*x183 + x1631*x185 + x1632, x159*x1637 + x161*x1637 + x163*x1637 + x1638*x181 + x1638*x183 + x1638*x185 + x1639, x104*(x1543 + x1573 + x1618 + x1656*x1657 + x1658*x328 + x1660 + x1661 - x1662 - x1663 + x1664 + x1665 - x1666 - x1667 + x1669 + x325) + x124*(x1656*x339 + x1658*x1670 + x1671 - x1672 + x1673 - x1674 + x1682) + x159*x1721 + x161*x1721 + x163*x1721 + x1722*x181 + x1722*x183 + x1722*x185 + x1725 + x88*(x1641 - x1643 + x1651 + x1655), x104*(-x1651 - x1746) + x124*(x1747 - x1748 + x1749 - x1750 + x1761) + x159*x1775 + x161*x1775 + x163*x1775 + x1776*x181 + x1776*x183 + x1776*x185 + x1778 + x88*(x1727 - x1728 + x1730 - x1732 + x1738), x104*(x11*x1525*x1527*x25*x31 + x1525*x1527*x16*x43*x6*x7 - x1789 - x1790 - x1795) + x124*(-x1641 + x1643 + x1746 + x1796) + x159*x1803 + x161*x1803 + x163*x1803 + x1804*x181 + x1804*x183 + x1804*x185 + x1805 + x88*(x1780 - x1781 + x1782 - x1783 + x1788), x159*x1806 + x161*x1806 + x163*x1806 + x1808*x181 + x1808*x183 + x1808*x185 + x435, x1087 + x159*x1809 + x161*x1809 + x163*x1809 + x181*x1810 + x1810*x183 + x1810*x185, x1349 + x159*x1811 + x161*x1811 + x163*x1811 + x181*x1812 + x1812*x183 + x1812*x185, -x104*x1821 + x124*x1822 + x159*x1823 + x1593 + x161*x1823 + x163*x1823 + x181*x1824 + x1819*x88 + x1824*x183 + x1824*x185, -x104*x1828 + x124*x1837 + x159*x1842 + x161*x1842 + x163*x1842 + x181*x1841 + x183*x1841 + x1832*x88 + 2*x1838*x432 + 2*x1839*x397 + 2*x1840*x409 + x1841*x185, -x104*x1851 + x124*x1855 + x159*x1856 + x161*x1856 + x163*x1856 + x181*x1857 + x183*x1857 + x1848*x88 + x185*x1857 + x1861, x159*x1870 + x161*x1870 + x163*x1870 + x181*x1871 + x183*x1871 + x185*x1871 + x1872, x159*x1879 + x161*x1879 + x163*x1879 + x181*x1880 + x183*x1880 + x185*x1880 + x1881, x159*x1886 + x161*x1886 + x163*x1886 + x181*x1887 + x183*x1887 + x185*x1887 + x1888, x104*(x1525*x16*x1814*x43*x8 + x1525*x1814*x25*x31*x6*x7 - x1906 - x1907 - x1911) + x124*(x1912 - x1913 + x1914 - x1915 + x1923) + x159*x1950 + x161*x1950 + x163*x1950 + x181*x1951 + x183*x1951 + x185*x1951 + x1954 + x88*(x1890 - x1892 + x1900 + x1904), x104*(-x1900 - x1975) + x124*(x1955*x1976 + x1956*x344 + x1977 - x1978 + x1979 - x1980 + x1988) + x159*x1998 + x161*x1998 + x163*x1998 + x181*x1999 + x183*x1999 + x185*x1999 + x2001 + x88*(x1657*x1956 + x1955*x328 + x1958 - x1959 + x1961 - x1963 + x1968), x104*(x11*x1525*x1814*x25*x31 + x1525*x16*x1814*x43*x6*x7 - x2012 - x2013 - x2016) + x124*(-x1890 + x1892 + x1975 + x2017) + x159*x2018 + x161*x2018 + x163*x2018 + x181*x2019 + x183*x2019 + x185*x2019 + x2020 + x88*(x2003 - x2004 + x2005 - x2006 + x2011), x159*x2021 + x161*x2021 + x163*x2021 + x181*x2023 + x183*x2023 + x185*x2023 + x477, x1096 + x159*x2024 + x161*x2024 + x163*x2024 + x181*x2025 + x183*x2025 + x185*x2025, x1360 + x159*x2026 + x161*x2026 + x163*x2026 + x181*x2027 + x183*x2027 + x185*x2027, -x104*x2036 + x124*x2037 + x159*x2038 + x161*x2038 + x1611 + x163*x2038 + x181*x2039 + x183*x2039 + x185*x2039 + x2034*x88, -x104*x2045 + x124*x2046 + x159*x2047 + x161*x2047 + x163*x2047 + x181*x2048 + x183*x2048 + x185*x2048 + x1861 + x2043*x88, -x104*x2061 + x124*x2052 + x159*x2066 + x161*x2066 + x163*x2066 + x181*x2065 + x183*x2065 + x185*x2065 + x2057*x88 + 2*x2062*x452 + 2*x2063*x445 + 2*x2064*x474, x159*x2075 + x161*x2075 + x163*x2075 + x181*x2076 + x183*x2076 + x185*x2076 + x2080, x159*x2086 + x161*x2086 + x163*x2086 + x181*x2087 + x183*x2087 + x185*x2087 + x2088, x159*x2095 + x161*x2095 + x163*x2095 + x181*x2096 + x183*x2096 + x185*x2096 + x2097, x104*(x1525*x16*x2029*x43*x8 + x1525*x2029*x25*x31*x6*x7 - x2113 - x2114 - x2118) + x124*(x2119 - x2120 + x2121 - x2122 + x2127) + x159*x2141 + x161*x2141 + x163*x2141 + x181*x2142 + x183*x2142 + x185*x2142 + x2145 + x88*(x2099 - x2101 + x2108 + x2111), x104*(-x2108 - x2164) + x124*(x2165 - x2166 + x2167 - x2168 + x2174) + x159*x2179 + x161*x2179 + x163*x2179 + x181*x2180 + x183*x2180 + x185*x2180 + x2182 + x88*(x2147 - x2148 + x2150 - x2152 + x2158), x104*(x1351 + x1545 + x1854 + x1903 + x1976*x2184 + x2081 + x2183*x344 + x2196 + x2197 - x2198 - x2199 + x2200 + x2201 - x2202 - x2203) + x124*(-x2099 + x2101 + x2164 + x2204) + x159*x2209 + x161*x2209 + x163*x2209 + x181*x2210 + x183*x2210 + x185*x2210 + x2211 + x88*(x1670*x2183 + x2184*x339 + x2186 - x2187 + x2188 - x2189 + x2195), x159*x2212 + x161*x2212 + x163*x2212 + x181*x2214 + x183*x2214 + x185*x2214 + x537, x1109 + x159*x2215 + x161*x2215 + x163*x2215 + x181*x2216 + x183*x2216 + x185*x2216, x1373 + x159*x2217 + x161*x2217 + x163*x2217 + x181*x2218 + x183*x2218 + x185*x2218, x159*x2219 + x161*x2219 + x1623 + x163*x2219 + x181*x2220 + x183*x2220 + x185*x2220, x159*x2221 + x161*x2221 + x163*x2221 + x181*x2222 + x183*x2222 + x185*x2222 + x1872, x159*x2223 + x161*x2223 + x163*x2223 + x181*x2224 + x183*x2224 + x185*x2224 + x2080, x104*x2254 - x124*x2265 + x159*x2270 + x161*x2270 + x163*x2270 + x181*x2269 + x183*x2269 + x185*x2269 - x2243*x88 + 2*x2266*x531 + 2*x2267*x506 + 2*x2268*x534, x104*x2280 - x124*x2288 + x159*x2289 + x161*x2289 + x163*x2289 + x181*x2290 + x183*x2290 + x185*x2290 - x2275*x88 + x2294, x104*x2305 - x124*x2309 + x159*x2310 + x161*x2310 + x163*x2310 + x181*x2311 + x183*x2311 + x185*x2311 - x2299*x88 + x2312, x104*(x2330*x2333 + x2331*x2332 + x2335 - x2336 + x2337 - x2338 + x2348) + x124*(x2260 + x2330*x2349 + x2331*x2350 + x2351 + x2352 - x2353 - x2354 + x2355 + x2356 - x2357 - x2358 + x2359 + x2362) + x159*x2397 + x161*x2397 + x163*x2397 + x181*x2398 + x183*x2398 + x185*x2398 + x2401 + x88*(-x2315 + x2316 - x2325 - x2329), x104*(x2325 + x2417) + x124*(x13*x2225*x2227*x27*x7 + x2225*x2227*x24*x25*x4*x43 - x2418 - x2419 - x2427) + x159*x2440 + x161*x2440 + x163*x2440 + x181*x2441 + x183*x2441 + x185*x2441 + x2443 + x88*(x13*x2225*x2227*x24*x28*x9 + x16*x2225*x2227*x27*x43 - x2403 - x2405 - x2408), x104*(x2450 - x2451 + x2452 - x2453 + x2461) + x124*(x2315 - x2316 - x2417 - x2462) + x159*x2466 + x161*x2466 + x163*x2466 + x181*x2467 + x183*x2467 + x185*x2467 + x2468 + x88*(x13*x2225*x2227*x29*x9 + x16*x2225*x2227*x24*x28*x43 - x2445 - x2446 - x2449), x159*x2469 + x161*x2469 + x163*x2469 + x181*x2471 + x183*x2471 + x185*x2471 + x585, x1121 + x159*x2472 + x161*x2472 + x163*x2472 + x181*x2473 + x183*x2473 + x185*x2473, x1383 + x159*x2474 + x161*x2474 + x163*x2474 + x181*x2475 + x183*x2475 + x185*x2475, x159*x2476 + x161*x2476 + x163*x2476 + x1632 + x181*x2477 + x183*x2477 + x185*x2477, x159*x2478 + x161*x2478 + x163*x2478 + x181*x2479 + x183*x2479 + x185*x2479 + x1881, x159*x2480 + x161*x2480 + x163*x2480 + x181*x2481 + x183*x2481 + x185*x2481 + x2088, x104*x2490 - x124*x2491 + x159*x2492 + x161*x2492 + x163*x2492 + x181*x2493 + x183*x2493 + x185*x2493 + x2294 - x2488*x88, x104*x2498 - x124*x2508 + x159*x2514 + x161*x2514 + x163*x2514 + x181*x2513 + x183*x2513 + x185*x2513 - x2502*x88 + x2509*x2510 + x2510*x2511 + x2510*x2512, x104*x2523 - x124*x2527 + x159*x2528 + x161*x2528 + x163*x2528 + x181*x2529 + x183*x2529 + x185*x2529 - x2520*x88 + x2533, x104*(x2550 - x2551 + x2552 - x2553 + x2559) + x124*(x13*x2225*x24*x2483*x25*x7 + x2225*x2483*x26*x4*x43 - x2560 - x2561 - x2569) + x159*x2592 + x161*x2592 + x163*x2592 + x181*x2593 + x183*x2593 + x185*x2593 + x2596 + x88*(-x2536 + x2537 - x2545 - x2548), x104*(x2545 + x2615) + x124*(x1112 + x2257 + x2522 + x2597*x2617 + x2598*x2616 + x2618 + x2619 - x2620 - x2621 + x2622 + x2623 - x2624 - x2625 + x2626 + x547) + x159*x2638 + x161*x2638 + x163*x2638 + x181*x2639 + x183*x2639 + x185*x2639 + x2641 + x88*(x2236 + x2279 + x2332*x2597 + x2333*x2598 + x2599 + x2601 - x2602 - x2603 + x2604 + x2606 - x2607 - x2608 + x2609 + x540 - x551), x104*(x2648 - x2649 + x2650 - x2651 + x2657) + x124*(x2536 - x2537 - x2615 - x2659) + x159*x2662 + x161*x2662 + x163*x2662 + x181*x2663 + x183*x2663 + x185*x2663 + x2664 + x88*(x13*x2225*x2483*x29*x9 + x16*x2225*x24*x2483*x28*x43 - x2643 - x2644 - x2647), x159*x2665 + x161*x2665 + x163*x2665 + x181*x2667 + x183*x2667 + x185*x2667 + x629, x1130 + x159*x2668 + x161*x2668 + x163*x2668 + x181*x2669 + x183*x2669 + x185*x2669, x1393 + x159*x2670 + x161*x2670 + x163*x2670 + x181*x2671 + x183*x2671 + x185*x2671, x159*x2672 + x161*x2672 + x163*x2672 + x1639 + x181*x2673 + x183*x2673 + x185*x2673, x159*x2674 + x161*x2674 + x163*x2674 + x181*x2675 + x183*x2675 + x185*x2675 + x1888, x159*x2676 + x161*x2676 + x163*x2676 + x181*x2677 + x183*x2677 + x185*x2677 + x2097, x104*x2686 - x124*x2687 + x159*x2688 + x161*x2688 + x163*x2688 + x181*x2689 + x183*x2689 + x185*x2689 + x2312 - x2684*x88, x104*x2695 - x124*x2696 + x159*x2697 + x161*x2697 + x163*x2697 + x181*x2698 + x183*x2698 + x185*x2698 + x2533 - x2693*x88, x104*x2708 - x124*x2701 + x159*x2713 + x161*x2713 + x163*x2713 + x181*x2712 + x183*x2712 + x185*x2712 - x2705*x88 + 2*x2709*x626 + 2*x2710*x623 + 2*x2711*x606, x104*(x2730 - x2731 + x2732 - x2733 + x2739) + x124*(x13*x2225*x24*x25*x2679*x7 + x2225*x26*x2679*x4*x43 - x2740 - x2741 - x2745) + x159*x2758 + x161*x2758 + x163*x2758 + x181*x2759 + x183*x2759 + x185*x2759 + x2765 + x88*(-x2716 + x2717 - x2724 - x2728), x104*(x2724 + x2779 + x2782) + x124*(x13*x2225*x2679*x27*x7 + x2225*x24*x25*x2679*x4*x43 - x2783 - x2784 - x2788) + x159*x2794 + x161*x2794 + x163*x2794 + x181*x2795 + x183*x2795 + x185*x2795 + x2797 + x88*(x13*x2225*x24*x2679*x28*x9 + x16*x2225*x2679*x27*x43 - x2767 - x2769 - x2773), x104*(x2616*x2798 + x2617*x2799 + x2809 - x2810 + x2811 - x2812 + x2817) + x124*(x2716 - x2717 - x2782 - x2820) + x159*x2825 + x161*x2825 + x163*x2825 + x181*x2826 + x183*x2826 + x185*x2826 + x2827 + x88*(x2241 + x2349*x2799 + x2350*x2798 + x2415 + x2744 + x2800 + x2802 - x2803 - x2804 + x2805 + x2806 - x2807 - x2808), -x104*x2833 + x124*x2835 + x159*x2836 + x161*x2836 + x163*x2836 + x175*x2829 + x176*x2834 + x177*x2830 + x181*x2838 + x183*x2838 + x185*x2838 + 2*x194 + x2831*x88 + x800, -x104*x2843 + x1199 + x124*x2845 + x159*x2846 + x161*x2846 + x163*x2846 + x175*x2839 + x176*x2844 + x177*x2840 + x181*x2847 + x183*x2847 + x185*x2847 + x2841*x88, -x104*x2852 + x124*x2854 + x1443 + x159*x2855 + x161*x2855 + x163*x2855 + x175*x2848 + x176*x2853 + x177*x2849 + x181*x2856 + x183*x2856 + x185*x2856 - x2850*x88, -x104*x2863 + x124*x2864 + x159*x2865 + x161*x2865 + x163*x2865 + x1725 + x181*x2866 + x183*x2866 + x185*x2866 + x2861*x88, -x104*x2872 + x124*x2873 + x159*x2874 + x161*x2874 + x163*x2874 + x181*x2875 + x183*x2875 + x185*x2875 + x1954 + x2870*x88, -x104*x2881 + x124*x2882 + x159*x2883 + x161*x2883 + x163*x2883 + x181*x2884 + x183*x2884 + x185*x2884 + x2145 + x2879*x88, x104*x2891 - x124*x2892 + x159*x2893 + x161*x2893 + x163*x2893 + x181*x2894 + x183*x2894 + x185*x2894 + x2401 - x2889*x88, x104*x2900 - x124*x2901 + x159*x2902 + x161*x2902 + x163*x2902 + x181*x2903 + x183*x2903 + x185*x2903 + x2596 - x2898*x88, x104*x2909 - x124*x2910 + x159*x2911 + x161*x2911 + x163*x2911 + x181*x2912 + x183*x2912 + x185*x2912 + x2765 - x2907*x88, x104*(x1656*x328 + x1657*x1658 + x21*x631 + x2330*x2332 + x2331*x2333 + x2660 + x2950 + x2952 + x2954 - x2955 - x2956 - x2957 - x2958*x651 + x2958*x653 - x2959*x653 + x2959*x798 + x2960*x651 - x2960*x798 + x2961 + x2962 + x2963 - x2964 - x2965 - x2966 + x2967 + x2968 + x36*x657) + x124*(x107*x631 + x109*x657 + x1239 + x1656*x1670 + x1658*x339 + x1994 + x2330*x2350 + x2331*x2349 + x2636 - x2958*x642 + x2958*x645 + x2959*x642 - x2959*x796 - x2960*x645 + x2960*x796 + x2969 + x2970 + x2971 - x2972 - x2973 - x2974 + x2975 + x2976 + x2977 - x2978 - x2979 - x2980 + x2981) + x126*x657 + x159*x3021 + x161*x3021 + x163*x3021 + x176*x2939 + x177*x2920 + x181*x3029 + x183*x3029 + x185*x3029 + x199 + x2949*x688 + x2982*x3025 + x2982*x787 + 2*x3022*x782 + x3023*x793 + x3024*x794 + x3026*x3027 + x3027*x3028 + x3030*x3031 + x3031*x3032 - 2*x786 - 2*x788 + x88*(x2914 + x2916 + x2919 - x2921 - x2922 - x2924 + x2925 + x2938 + x2948), x104*(-x2948 - x3079 - x3080) + x124*(x3081 + x3082 + x3083 - x3084 - x3085 - x3086 + x3087 + x3088 + x3089 - x3090 - x3091 - x3092 + x3100) + x159*x3117 + x161*x3117 + x163*x3117 + x176*x3033 + x177*x3042 + x181*x3118 + x183*x3118 + x185*x3118 + x2828*x894 + x3124 + x88*(x2543 + x3034 + x3036 + x3038 - x3039 - x3040 - x3041 + x3043 + x3045 + x3047 - x3048 - x3049 - x3051 + x3065), x104*(x1*x16*x28*x31*x72*x74 + x1*x2225*x2226*x29*x43 + x11*x1525*x1526*x25*x31 + x13*x17*x7*x72*x74 + x13*x2225*x2226*x25*x28*x6 + x1525*x1526*x16*x43*x6*x7 - x3154 - x3155 - x3156 - x3157 - x3158 - x3159 - x3164) + x124*(-x2914 - x2916 - x2919 + x2921 + x2922 + x2924 + x3079 + x3165) + x159*x3178 + x161*x3178 + x163*x3178 + x175*x2913 + x176*x3042 + x177*x3125 + x181*x3179 + x183*x3179 + x185*x3179 + x3180 + x88*(x3126 + x3128 + x3130 - x3131 - x3132 - x3133 + x3134 + x3135 + x3136 - x3137 - x3138 - x3139 + x3153), -x104*x3186 + x124*x3188 + x159*x3189 + x161*x3189 + x163*x3189 + x175*x3182 + x176*x3187 + x177*x3183 + x181*x3191 + x183*x3191 + x185*x3191 + x3184*x88 + x916, -x104*x3196 + x124*x3198 + x1247 + x159*x3199 + x161*x3199 + x163*x3199 + x175*x3192 + x176*x3197 + x177*x3193 + x181*x3200 + x183*x3200 + x185*x3200 + 2*x196 + x3194*x88, -x104*x3205 + x124*x3207 + x1482 + x159*x3208 + x161*x3208 + x163*x3208 + x175*x3201 + x176*x3206 + x177*x3202 + x181*x3209 + x183*x3209 + x185*x3209 + x3203*x88, -x104*x3216 + x124*x3217 + x159*x3218 + x161*x3218 + x163*x3218 + x1778 + x181*x3219 + x183*x3219 + x185*x3219 + x3214*x88, -x104*x3225 + x124*x3226 + x159*x3227 + x161*x3227 + x163*x3227 + x181*x3228 + x183*x3228 + x185*x3228 + x2001 + x3223*x88, -x104*x3234 + x124*x3235 + x159*x3236 + x161*x3236 + x163*x3236 + x181*x3237 + x183*x3237 + x185*x3237 + x2182 + x3232*x88, x104*x3244 - x124*x3245 + x159*x3246 + x161*x3246 + x163*x3246 + x181*x3247 + x183*x3247 + x185*x3247 + x2443 - x3242*x88, x104*x3253 - x124*x3254 + x159*x3255 + x161*x3255 + x163*x3255 + x181*x3256 + x183*x3256 + x185*x3256 + x2641 - x3251*x88, x104*x3262 - x124*x3263 + x159*x3264 + x161*x3264 + x163*x3264 + x181*x3265 + x183*x3265 + x185*x3265 + x2797 - x3260*x88, x104*(x1*x13*x16*x7*x72*x986 + x1*x2225*x2482*x25*x28*x43 + x13*x2225*x2482*x26*x6 + x14*x28*x31*x72*x986 + x1525*x16*x1813*x43*x8 + x1525*x1813*x25*x31*x6*x7 - x3078 - x3080 - x3289 - x3291 - x3293 - x3294 - x3295 - x3296) + x124*(x3100 + x3297 + x3298 + x3299 - x3300 - x3301 - x3302 + x3303 + x3304 + x3305 - x3306 - x3307 - x3308) + x159*x3321 + x161*x3321 + x163*x3321 + x176*x3278 + x177*x3273 + x181*x3322 + x183*x3322 + x185*x3322 + x3124 + x3288*x688 + x88*(x3065 + x3267 + x3269 + x3272 - x3274 - x3275 - x3277 + x3287), x104*(-x1546 - x3108 - x3287 - x3351 - x97) + x1202*x195 + x124*(x112*x1201 + x114*x1202 + x1955*x344 + x1956*x1976 + x2389 + x2597*x2616 + x2598*x2617 + x2981 + x3172 + x3332*x642 - x3332*x645 - x3333*x642 + x3333*x796 + x3334*x645 - x3334*x796 + x3352 + x3353 + x3354 - x3355 - x3356 - x3357 + x3358 + x3359 + x3360 - x3361 - x3362 - x3363) - 2*x1245 - 2*x1246 + x159*x3376 + x161*x3376 + x163*x3376 + x176*x3323 + x177*x3335 + x181*x3383 + x183*x3383 + x185*x3383 + x199 + x3023*x898 + x3181*x894 + x3364*x3381 + x3364*x900 + x3377*x3384 + x3377*x3385 + x3377*x904 + x3378*x911 + x3379*x3380 + x3380*x3382 + x88*(x1201*x36 + x1202*x21 + x1657*x1955 + x1956*x328 + x2332*x2598 + x2333*x2597 + x2430 + x2925 + x3111 + x3324 + x3326 + x3328 - x3329 - x3330 - x3331 + x3332*x811 - x3332*x814 + x3333*x814 - x3333*x915 - x3334*x811 + x3334*x915 + x3336 + x3338 + x3340 - x3341 - x3342 - x3344), x104*(x1*x16*x28*x31*x72*x986 + x1*x2225*x2482*x29*x43 + x11*x1525*x1813*x25*x31 + x13*x17*x7*x72*x986 + x13*x2225*x2482*x25*x28*x6 + x1525*x16*x1813*x43*x6*x7 - x3408 - x3409 - x3410 - x3411 - x3412 - x3413 - x3414) + x124*(-x3267 - x3269 - x3272 + x3274 + x3275 + x3277 + x3351 + x3415) + x159*x3420 + x161*x3420 + x163*x3420 + x175*x3266 + x176*x3335 + x177*x3386 + x181*x3421 + x183*x3421 + x185*x3421 + x3427 + x88*(x3387 + x3389 + x3391 - x3392 - x3393 - x3394 + x3395 + x3396 + x3397 - x3398 - x3399 - x3400 + x3407), -x104*x3433 + x124*x3435 + x159*x3436 + x161*x3436 + x163*x3436 + x175*x3429 + x176*x3434 + x177*x3430 + x181*x3438 + x183*x3438 + x185*x3438 + x3431*x88 + x984, -x104*x3443 + x124*x3445 + x1269 + x159*x3446 + x161*x3446 + x163*x3446 + x175*x3439 + x176*x3444 + x177*x3440 + x181*x3447 + x183*x3447 + x185*x3447 + x3441*x88, -x104*x3452 + x124*x3454 + x1517 + x159*x3455 + x161*x3455 + x163*x3455 + x175*x3448 + x176*x3453 + x177*x3449 + x181*x3456 + x183*x3456 + x185*x3456 + 2*x198 + x3450*x88, -x104*x3463 + x124*x3464 + x159*x3465 + x161*x3465 + x163*x3465 + x1805 + x181*x3466 + x183*x3466 + x185*x3466 + x3461*x88, -x104*x3472 + x124*x3473 + x159*x3474 + x161*x3474 + x163*x3474 + x181*x3475 + x183*x3475 + x185*x3475 + x2020 + x3470*x88, -x104*x3481 + x124*x3482 + x159*x3483 + x161*x3483 + x163*x3483 + x181*x3484 + x183*x3484 + x185*x3484 + x2211 + x3479*x88, x104*x3491 - x124*x3492 + x159*x3493 + x161*x3493 + x163*x3493 + x181*x3494 + x183*x3494 + x185*x3494 + x2468 - x3489*x88, x104*x3500 - x124*x3501 + x159*x3502 + x161*x3502 + x163*x3502 + x181*x3503 + x183*x3503 + x185*x3503 + x2664 - x3498*x88, x104*x3509 - x124*x3510 + x159*x3511 + x161*x3511 + x163*x3511 + x181*x3512 + x183*x3512 + x185*x3512 + x2827 - x3507*x88, x104*(x1*x1271*x13*x16*x7*x72 + x1*x2225*x25*x2678*x28*x43 + x1271*x14*x28*x31*x72 + x13*x2225*x26*x2678*x6 + x1525*x16*x2028*x43*x8 + x1525*x2028*x25*x31*x6*x7 - x3164 - x3536 - x3538 - x3540 - x3541 - x3542 - x3543) + x124*(x3078 + x3165 + x3544 + x3545 + x3546 - x3547 - x3548 - x3549 + x3550 + x3551 + x3552 - x3553 - x3554 - x3555) + x159*x3566 + x161*x3566 + x163*x3566 + x176*x3525 + x177*x3520 + x181*x3567 + x183*x3567 + x185*x3567 + x3180 + x3535*x688 + x88*(x3153 + x3514 + x3516 + x3519 - x3521 - x3522 - x3524 + x3534), x104*(-x3414 - x3534 - x3593) + x124*(x2347 + x3415 + x3594 + x3595 + x3596 - x3597 - x3598 - x3599 + x3600 + x3601 + x3602 - x3603 - x3604 - x3605) + x159*x3607 + x161*x3607 + x163*x3607 + x176*x3568 + x177*x3577 + x181*x3608 + x183*x3608 + x185*x3608 + x3427 + x3428*x894 + x88*(x3407 + x3569 + x3571 + x3573 - x3574 - x3575 - x3576 + x3578 + x3580 + x3582 - x3583 - x3584 - x3586), x104*(x112*x1485 + x114*x1484 + x1976*x2183 + x2184*x344 + x2393 + x2616*x2799 + x2617*x2798 + x2968 + x3109 + x3618*x651 - x3618*x653 + x3619*x653 - x3619*x798 - x3620*x651 + x3620*x798 + x3627 + x3628 + x3629 - x3630 - x3631 - x3632 + x3633 + x3634 + x3635 - x3636 - x3637 - x3638) + x124*(x2981 + x3416 - x3514 - x3516 - x3519 + x3521 + x3522 + x3524 + x3593) + x1485*x197 - 2*x1513 - 2*x1514 + x159*x3642 + x161*x3642 + x163*x3642 + x175*x3513 + x176*x3577 + x177*x3609 + x181*x3645 + x183*x3645 + x185*x3645 + x199 + x3024*x972 + x3378*x980 + x3422*x3644 + 2*x3423*x980 + x3424*x3644 + x3425*x3643 + x3426*x3643 + x3643*x978 + x88*(x107*x1485 + x109*x1484 + x1670*x2184 + x1764 + x2183*x339 + x2349*x2798 + x2350*x2799 + x2637 + x2925 + x3610 + x3612 + x3614 - x3615 - x3616 - x3617 - x3618*x811 + x3618*x814 - x3619*x814 + x3619*x915 + x3620*x811 - x3620*x915 + x3621 + x3622 + x3623 - x3624 - x3625 - x3626 + x854) + 2*x974*x981], dtype=np.float64)


def q_ld(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Displacement"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = -o0
    x1 = m0 + x0
    x2 = -m2 + n2
    x3 = -m0 + n0
    x4 = -m1 + n1
    x5 = 1/mpmath.sqrt(x2**2 + x3**2 + x4**2)
    x6 = -p1*x2*x5 + p2*x4*x5
    x7 = -o1
    x8 = m1 + x7
    x9 = -o2
    x10 = m2 + x9
    x11 = p0*x5
    x12 = p1*x3*x5 - x11*x4
    x13 = -p2*x3*x5 + x11*x2
    x14 = 1/mpmath.sqrt(x12**2 + x13**2 + x6**2)
    x15 = x14/mpmath.sqrt(x1**2 + x10**2 + x8**2)
    x16 = n0 + x0
    x17 = n1 + x7
    x18 = n2 + x9
    x19 = x14/mpmath.sqrt(x16**2 + x17**2 + x18**2)

    return x1*x15*x6 + x10*x12*x15 + x12*x18*x19 + x13*x15*x8 + x13*x17*x19 + x16*x19*x6


def dq_ld(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Displacement, first derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = m2 - n2
    x1 = -x0
    x2 = m0 - n0
    x3 = -x2
    x4 = x3**2
    x5 = m1 - n1
    x6 = -x5
    x7 = x6**2
    x8 = x1**2
    x9 = x4 + x7 + x8
    x10 = 1/mpmath.sqrt(x9)
    x11 = p1*x10
    x12 = p2*x10*x6 - x1*x11
    x13 = -o0
    x14 = m0 + x13
    x15 = x14**2
    x16 = -o1
    x17 = m1 + x16
    x18 = x17**2
    x19 = -o2
    x20 = m2 + x19
    x21 = x20**2
    x22 = x15 + x18 + x21
    x23 = 1/mpmath.sqrt(x22)
    x24 = p0*x10
    x25 = p1*x10*x3 - x24*x6
    x26 = p2*x10
    x27 = x1*x24 - x26*x3
    x28 = x12**2 + x25**2 + x27**2
    x29 = 1/mpmath.sqrt(x28)
    x30 = x23*x29
    x31 = x12*x30
    x32 = -x14
    x33 = x22**(mpmath.mpf(-3)/mpmath.mpf(2))
    x34 = x12*x29
    x35 = x33*x34
    x36 = x14*x35
    x37 = x27*x29
    x38 = x33*x37
    x39 = x17*x38
    x40 = x25*x29
    x41 = x33*x40
    x42 = x20*x41
    x43 = x9**(mpmath.mpf(-3)/mpmath.mpf(2))
    x44 = x3*x43
    x45 = x1*x44
    x46 = p1*x45
    x47 = x44*x6
    x48 = p2*x47
    x49 = -x48
    x50 = -x46 - x49
    x51 = x14*x30
    x52 = n0 + x13
    x53 = x52**2
    x54 = n1 + x16
    x55 = x54**2
    x56 = n2 + x19
    x57 = x56**2
    x58 = x53 + x55 + x57
    x59 = 1/mpmath.sqrt(x58)
    x60 = x29*x59
    x61 = x52*x60
    x62 = p2*x4*x43
    x63 = p0*x45
    x64 = x26 - x62 + x63
    x65 = x17*x30
    x66 = x54*x60
    x67 = p0*x47
    x68 = p1*x4*x43 - x11 - x67
    x69 = x20*x30
    x70 = x56*x60
    x71 = x28**(mpmath.mpf(-3)/mpmath.mpf(2))
    x72 = 2*x46
    x73 = -2*x48
    x74 = (mpmath.mpf(1)/mpmath.mpf(2))*x12
    x75 = 2*x11
    x76 = (mpmath.mpf(1)/mpmath.mpf(2))*x25
    x77 = 2*x26
    x78 = (mpmath.mpf(1)/mpmath.mpf(2))*x27
    x79 = x71*(-x74*(-x72 - x73) - x76*(2*p1*x4*x43 - 2*x67 - x75) - x78*(-2*x62 + 2*x63 + x77))
    x80 = x23*x79
    x81 = x12*x14
    x82 = x17*x27
    x83 = x20*x25
    x84 = x59*x79
    x85 = x12*x52
    x86 = x27*x54
    x87 = x25*x56
    x88 = x27*x30
    x89 = -x17
    x90 = x43*x6
    x91 = x1*x90
    x92 = p0*x91
    x93 = x49 + x92
    x94 = p0*x43*x7
    x95 = p1*x47
    x96 = x24 - x94 + x95
    x97 = p1*x91
    x98 = p2*x43*x7 - x26 - x97
    x99 = 2*x92
    x100 = 2*x24
    x101 = x71*(-x74*(2*p2*x43*x7 - x77 - 2*x97) - x76*(x100 - 2*x94 + 2*x95) - x78*(x73 + x99))
    x102 = x101*x23
    x103 = x101*x59
    x104 = x25*x30
    x105 = -x20
    x106 = x46 - x92
    x107 = p1*x43*x8
    x108 = p2*x91
    x109 = -x107 + x108 + x11
    x110 = p2*x45
    x111 = p0*x43*x8 - x110 - x24
    x112 = x71*(-x74*(-2*x107 + 2*x108 + x75) - x76*(x72 - x99) - x78*(2*p0*x43*x8 - x100 - 2*x110))
    x113 = x112*x23
    x114 = x112*x59
    x115 = x12*x60
    x116 = x58**(mpmath.mpf(-3)/mpmath.mpf(2))
    x117 = x116*x34
    x118 = x116*x37
    x119 = x52*x54
    x120 = x116*x40
    x121 = x120*x56
    x122 = x27*x60
    x123 = x25*x60
    x124 = x117*x52
    x125 = x118*x54
    x126 = -x52
    x127 = p1*x2
    x128 = x1*x43
    x129 = x127*x128
    x130 = p2*x2*x43*x6 - x129
    x131 = x127*x44
    x132 = p0*x2*x90
    x133 = x11 + x131 - x132
    x134 = p2*x2*x44
    x135 = p0*x1*x2*x43 - x134 - x26
    x136 = x71*(-x74*(2*p2*x2*x43*x6 - 2*x129) - x76*(2*x131 - 2*x132 + x75) - x78*(2*p0*x1*x2*x43 - 2*x134 - x77))
    x137 = x136*x23
    x138 = x136*x59
    x139 = -x54
    x140 = x128*x5
    x141 = p0*x140
    x142 = p2*x5
    x143 = x142*x44
    x144 = x141 - x143
    x145 = x142*x90
    x146 = p1*x140
    x147 = x145 - x146 + x26
    x148 = p0*x90
    x149 = x148*x5
    x150 = p1*x3*x43*x5 - x149 - x24
    x151 = x71*(-x74*(2*x145 - 2*x146 + x77) - x76*(2*p1*x3*x43*x5 - x100 - 2*x149) - x78*(2*x141 - 2*x143))
    x152 = x151*x23
    x153 = x151*x59
    x154 = -x56
    x155 = x0*x148
    x156 = p1*x0*x3*x43 - x155
    x157 = x0*x128
    x158 = p0*x157
    x159 = p2*x0*x44
    x160 = x158 - x159 + x24
    x161 = p1*x157
    x162 = p2*x0*x43*x6 - x11 - x161
    x163 = x71*(-x74*(2*p2*x0*x43*x6 - 2*x161 - x75) - x76*(2*p1*x0*x3*x43 - 2*x155) - x78*(x100 + 2*x158 - 2*x159))
    x164 = x163*x23
    x165 = x163*x59

    return np.array([x31 + x32*x36 + x32*x39 + x32*x42 + x50*x51 + x50*x61 + x64*x65 + x64*x66 + x68*x69 + x68*x70 + x80*x81 + x80*x82 + x80*x83 + x84*x85 + x84*x86 + x84*x87, x102*x81 + x102*x82 + x102*x83 + x103*x85 + x103*x86 + x103*x87 + x36*x89 + x39*x89 + x42*x89 + x51*x98 + x61*x98 + x65*x93 + x66*x93 + x69*x96 + x70*x96 + x88, x104 + x105*x36 + x105*x39 + x105*x42 + x106*x69 + x106*x70 + x109*x51 + x109*x61 + x111*x65 + x111*x66 + x113*x81 + x113*x82 + x113*x83 + x114*x85 + x114*x86 + x114*x87, -x115 + x117*x53 + x118*x119 + x121*x52 + x14*x39 + x14*x42 + x15*x35 - x31, x117*x119 + x118*x55 + x121*x54 - x122 + x17*x36 + x17*x42 + x18*x38 - x88, -x104 + x120*x57 - x123 + x124*x56 + x125*x56 + x20*x36 + x20*x39 + x21*x41, x115 + x121*x126 + x124*x126 + x125*x126 + x130*x51 + x130*x61 + x133*x69 + x133*x70 + x135*x65 + x135*x66 + x137*x81 + x137*x82 + x137*x83 + x138*x85 + x138*x86 + x138*x87, x121*x139 + x122 + x124*x139 + x125*x139 + x144*x65 + x144*x66 + x147*x51 + x147*x61 + x150*x69 + x150*x70 + x152*x81 + x152*x82 + x152*x83 + x153*x85 + x153*x86 + x153*x87, x121*x154 + x123 + x124*x154 + x125*x154 + x156*x69 + x156*x70 + x160*x65 + x160*x66 + x162*x51 + x162*x61 + x164*x81 + x164*x82 + x164*x83 + x165*x85 + x165*x86 + x165*x87], dtype=np.float64)


def d2q_ld(m0, m1, m2, o0, o1, o2, n0, n1, n2, p0, p1, p2):
    """Linear Displacement, 2nd derivative wrt. Cartesians"""

    m0 = mpmath.mpf(m0)
    m1 = mpmath.mpf(m1)
    m2 = mpmath.mpf(m2)
    o0 = mpmath.mpf(o0)
    o1 = mpmath.mpf(o1)
    o2 = mpmath.mpf(o2)
    n0 = mpmath.mpf(n0)
    n1 = mpmath.mpf(n1)
    n2 = mpmath.mpf(n2)
    p0 = mpmath.mpf(p0)
    p1 = mpmath.mpf(p1)
    p2 = mpmath.mpf(p2)

    x0 = m0 - n0
    x1 = -x0
    x2 = m2 - n2
    x3 = -x2
    x4 = x1**2
    x5 = m1 - n1
    x6 = -x5
    x7 = x6**2
    x8 = x3**2
    x9 = x4 + x7 + x8
    x10 = x9**(mpmath.mpf(-3)/mpmath.mpf(2))
    x11 = x10*x3
    x12 = p1*x11
    x13 = x1*x12
    x14 = p2*x10
    x15 = x14*x6
    x16 = x1*x15
    x17 = -x16
    x18 = -x13 - x17
    x19 = -o0
    x20 = m0 + x19
    x21 = x20**2
    x22 = -o1
    x23 = m1 + x22
    x24 = x23**2
    x25 = -o2
    x26 = m2 + x25
    x27 = x26**2
    x28 = x21 + x24 + x27
    x29 = 1/mpmath.sqrt(x28)
    x30 = 1/mpmath.sqrt(x9)
    x31 = p0*x30
    x32 = x31*x6
    x33 = p1*x1*x30 - x32
    x34 = x3*x31
    x35 = p2*x30
    x36 = -x1*x35 + x34
    x37 = p1*x30
    x38 = x3*x37
    x39 = p2*x30*x6 - x38
    x40 = x33**2 + x36**2 + x39**2
    x41 = 1/mpmath.sqrt(x40)
    x42 = x29*x41
    x43 = x18*x42
    x44 = -x12
    x45 = x9**(mpmath.mpf(-5)/mpmath.mpf(2))
    x46 = 3*m0
    x47 = 3*n0
    x48 = x46 - x47
    x49 = -x48
    x50 = x45*x49
    x51 = x1*x50
    x52 = x3*x51
    x53 = p1*x52
    x54 = p2*x6
    x55 = x51*x54
    x56 = x15 - x55
    x57 = -x44 - x53 - x56
    x58 = x20*x42
    x59 = 2*m0
    x60 = 2*n0
    x61 = x59 - x60
    x62 = x14*x61
    x63 = x4*x50
    x64 = p2*x63
    x65 = p0*x11
    x66 = x1*x14
    x67 = -x66
    x68 = x65 + x67
    x69 = p0*x1*x3*x45*x49 - x62 - x64 - x68
    x70 = x23*x42
    x71 = p1*x10
    x72 = x61*x71
    x73 = p1*x63
    x74 = p0*x6
    x75 = x51*x74
    x76 = p0*x10
    x77 = x6*x76
    x78 = x1*x71
    x79 = -x78
    x80 = x77 + x79
    x81 = x72 + x73 - x75 + x80
    x82 = x26*x42
    x83 = n0 + x19
    x84 = x83**2
    x85 = n1 + x22
    x86 = x85**2
    x87 = n2 + x25
    x88 = x87**2
    x89 = x84 + x86 + x88
    x90 = 1/mpmath.sqrt(x89)
    x91 = x41*x90
    x92 = x83*x91
    x93 = x85*x91
    x94 = x87*x91
    x95 = -x20
    x96 = x28**(mpmath.mpf(-3)/mpmath.mpf(2))
    x97 = x41*x96
    x98 = x39*x97
    x99 = x95*x98
    x100 = 2*x13
    x101 = -2*x16
    x102 = -x100 - x101
    x103 = x102*x39
    x104 = 2*x37
    x105 = 2*x77
    x106 = 2*p1*x10*x4 - x1*x105 - x104
    x107 = x106*x33
    x108 = 2*x35
    x109 = x14*x4
    x110 = 2*x65
    x111 = x1*x110 + x108 - 2*x109
    x112 = x111*x36
    x113 = -mpmath.mpf(1)/mpmath.mpf(2)*x103 - mpmath.mpf(1)/mpmath.mpf(2)*x107 - mpmath.mpf(1)/mpmath.mpf(2)*x112
    x114 = x40**(mpmath.mpf(-3)/mpmath.mpf(2))
    x115 = x114*x29
    x116 = x115*x39
    x117 = x113*x116
    x118 = (mpmath.mpf(1)/mpmath.mpf(2))*x13
    x119 = -mpmath.mpf(1)/mpmath.mpf(2)*x16
    x120 = x118 + x119
    x121 = (mpmath.mpf(1)/mpmath.mpf(2))*x37
    x122 = x1*x77
    x123 = x121 + (mpmath.mpf(1)/mpmath.mpf(2))*x122 - mpmath.mpf(1)/mpmath.mpf(2)*x4*x71
    x124 = (mpmath.mpf(1)/mpmath.mpf(2))*x35
    x125 = x1*x65
    x126 = (mpmath.mpf(1)/mpmath.mpf(2))*p2*x10*x4 - x124 - mpmath.mpf(1)/mpmath.mpf(2)*x125
    x127 = -mpmath.mpf(1)/mpmath.mpf(2)*x35*x6 + (mpmath.mpf(1)/mpmath.mpf(2))*x38
    x128 = 2*x12
    x129 = -x128
    x130 = 2*x53
    x131 = 2*x15
    x132 = x131 - 2*x55
    x133 = -mpmath.mpf(1)/mpmath.mpf(2)*x1*x37 + (mpmath.mpf(1)/mpmath.mpf(2))*x32
    x134 = 2*x78
    x135 = -x134
    x136 = x105 + x135
    x137 = (mpmath.mpf(1)/mpmath.mpf(2))*p2*x1*x30 - mpmath.mpf(1)/mpmath.mpf(2)*x34
    x138 = 2*x66
    x139 = -x138
    x140 = x110 + x139
    x141 = x102*x120 + x106*x123 + x111*x126 + x127*(-x129 - x130 - x132) + x133*(x136 + 2*x72 + 2*x73 - 2*x75) + x137*(2*p0*x1*x3*x45*x49 - x140 - 2*x62 - 2*x64)
    x142 = x20*x39
    x143 = x115*x142
    x144 = x115*x36
    x145 = x144*x23
    x146 = x115*x33
    x147 = x146*x26
    x148 = x114*x90
    x149 = x148*x39
    x150 = x149*x83
    x151 = x148*x36
    x152 = x151*x85
    x153 = x148*x33
    x154 = x153*x87
    x155 = x20*x97
    x156 = x155*x95
    x157 = 2*x18
    x158 = x23*x97
    x159 = x158*x95
    x160 = -x109 + x125 + x35
    x161 = 2*x160
    x162 = x26*x97
    x163 = x162*x95
    x164 = p1*x10*x4 - x122 - x37
    x165 = 2*x164
    x166 = x115*x20
    x167 = x113*x157
    x168 = x115*x23
    x169 = x113*x161
    x170 = x115*x26
    x171 = x113*x165
    x172 = x148*x83
    x173 = x148*x85
    x174 = x148*x87
    x175 = -3*o0
    x176 = x175 + x46
    x177 = x41/x28**(mpmath.mpf(5)/mpmath.mpf(2))
    x178 = -x176*x177
    x179 = x178*x95
    x180 = x23*x36
    x181 = x26*x33
    x182 = x40**(mpmath.mpf(-5)/mpmath.mpf(2))
    x183 = x182*(-mpmath.mpf(3)/mpmath.mpf(2)*x103 - mpmath.mpf(3)/mpmath.mpf(2)*x107 - mpmath.mpf(3)/mpmath.mpf(2)*x112)
    x184 = x183*x29
    x185 = x142*x184
    x186 = x113*x36
    x187 = x186*x23
    x188 = x113*x33
    x189 = x184*x26
    x190 = x183*x90
    x191 = x39*x83
    x192 = x190*x191
    x193 = x190*x85
    x194 = x190*x87
    x195 = x113*x114
    x196 = x142*x96
    x197 = x195*x196
    x198 = 2*x95
    x199 = x114*x186
    x200 = x199*x96
    x201 = x200*x23
    x202 = x114*x188
    x203 = x26*x96
    x204 = x203*x95
    x205 = x142*x97
    x206 = x36*x97
    x207 = x206*x23
    x208 = x33*x97
    x209 = x208*x26
    x210 = -x205 - x207 - x209
    x211 = x3*x50
    x212 = p1*x6
    x213 = x211*x212
    x214 = p2*x45*x49*x7 - x213 - x66
    x215 = x211*x74
    x216 = x215 + x56
    x217 = p0*x50*x7
    x218 = x6*x71
    x219 = x1*x76
    x220 = -x219
    x221 = x218 + x220
    x222 = p1*x1*x45*x49*x6 - x217 - x221
    x223 = x110*x6
    x224 = x101 + x223
    x225 = 2*p2*x10*x7 - x108 - x128*x6
    x226 = 2*x215
    x227 = 2*x31
    x228 = x7*x76
    x229 = x134*x6 + x227 - 2*x228
    x230 = 2*x219
    x231 = -x230
    x232 = 2*x218
    x233 = x231 + x232
    x234 = x120*x225 + x123*x229 + x126*x224 + x127*(2*p2*x45*x49*x7 - x138 - 2*x213) + x133*(2*p1*x1*x45*x49*x6 - 2*x217 - x233) + x137*(x132 + x226)
    x235 = -x23
    x236 = x178*x235
    x237 = (mpmath.mpf(1)/mpmath.mpf(2))*x36
    x238 = (mpmath.mpf(1)/mpmath.mpf(2))*x33
    x239 = (mpmath.mpf(1)/mpmath.mpf(2))*x39
    x240 = -x224*x237 - x225*x239 - x229*x238
    x241 = x180*x184
    x242 = x240*x33
    x243 = x193*x36
    x244 = x160*x42
    x245 = x12*x6
    x246 = p2*x10*x7 - x245 - x35
    x247 = x246*x42
    x248 = x206*x95
    x249 = x235*x98
    x250 = x115*x186
    x251 = x116*x240
    x252 = x155*x18
    x253 = x6*x65
    x254 = x17 + x253
    x255 = x158*x160
    x256 = x6*x78
    x257 = -x228 + x256 + x31
    x258 = x162*x164
    x259 = x18*x240
    x260 = x113*x246
    x261 = x113*x254
    x262 = x160*x240
    x263 = x113*x257
    x264 = x164*x240
    x265 = x114*x240
    x266 = x265*x95
    x267 = x180*x96
    x268 = x114*x242
    x269 = x202*x203
    x270 = x156*x246 + x159*x254 + x163*x257 + x166*x259 + x166*x260 + x168*x261 + x168*x262 + x170*x263 + x170*x264 + x172*x259 + x172*x260 + x173*x261 + x173*x262 + x174*x263 + x174*x264 + x196*x266 + x197*x235 + x201*x235 + x204*x268 + x235*x252 + x235*x255 + x235*x258 + x235*x269 + x244 + x247 + x248 + x249 + x250 + x251 + x266*x267
    x271 = x50*x8
    x272 = p1*x271
    x273 = x211*x54
    x274 = -x272 + x273 + x78
    x275 = p0*x271
    x276 = p2*x52
    x277 = p2*x11
    x278 = x220 + x277
    x279 = x275 - x276 + x278
    x280 = -x12 - x215 + x53
    x281 = x100 - x223
    x282 = x71*x8
    x283 = x277*x6
    x284 = x104 - 2*x282 + 2*x283
    x285 = x1*x277
    x286 = 2*p0*x10*x8 - x227 - 2*x285
    x287 = 2*x277
    x288 = x231 + x287
    x289 = x120*x284 + x123*x281 + x126*x286 + x127*(x134 - 2*x272 + 2*x273) + x133*(-x128 + x130 - x226) + x137*(2*x275 - 2*x276 + x288)
    x290 = -x26
    x291 = x178*x290
    x292 = -x237*x286 - x238*x281 - x239*x284
    x293 = x292*x33
    x294 = -x282 + x283 + x37
    x295 = x294*x42
    x296 = x164*x42
    x297 = x208*x95
    x298 = x290*x98
    x299 = x115*x188
    x300 = x116*x292
    x301 = p0*x10*x8 - x285 - x31
    x302 = x13 - x253
    x303 = x18*x292
    x304 = x113*x294
    x305 = x160*x292
    x306 = x113*x301
    x307 = x113*x302
    x308 = x164*x292
    x309 = x114*x292
    x310 = x309*x95
    x311 = x114*x293
    x312 = x156*x294 + x159*x301 + x163*x302 + x166*x303 + x166*x304 + x168*x305 + x168*x306 + x170*x307 + x170*x308 + x172*x303 + x172*x304 + x173*x305 + x173*x306 + x174*x307 + x174*x308 + x196*x310 + x197*x290 + x201*x290 + x204*x311 + x252*x290 + x255*x290 + x258*x290 + x267*x310 + x269*x290 + x295 + x296 + x297 + x298 + x299 + x300
    x313 = -2*o0
    x314 = x313 + x59
    x315 = x21*x39
    x316 = x178*x20
    x317 = x18*x91
    x318 = x21*x97
    x319 = x89**(mpmath.mpf(-3)/mpmath.mpf(2))
    x320 = x319*x41
    x321 = x320*x84
    x322 = x113*x149
    x323 = x315*x96
    x324 = x39*x84
    x325 = x319*x324
    x326 = x155*x23
    x327 = x164*x26
    x328 = x320*x83
    x329 = x328*x85
    x330 = x164*x87
    x331 = x319*x83
    x332 = x199*x85
    x333 = x202*x87
    x334 = -x117 + x155*x327 + x160*x326 + x160*x329 + x18*x318 + x18*x321 + x195*x323 + x195*x325 + x20*x201 + x20*x269 + x207 + x209 - x317 - x322 + x328*x330 + x331*x332 + x331*x333 - x43 - x99
    x335 = x24*x36
    x336 = x178*x23
    x337 = x160*x91
    x338 = x24*x97
    x339 = x320*x86
    x340 = x23*x98
    x341 = x148*x186
    x342 = x319*x86
    x343 = x320*x85
    x344 = x319*x85
    x345 = x191*x195
    x346 = x158*x327 + x160*x338 + x160*x339 + x18*x329 + x197*x23 + x199*x342 + x200*x24 + x23*x252 + x23*x269 - x244 - x248 - x250 + x330*x343 + x333*x344 - x337 + x340 - x341 + x344*x345
    x347 = x27*x33
    x348 = x178*x26
    x349 = x164*x91
    x350 = x27*x97
    x351 = x320*x88
    x352 = x26*x98
    x353 = x148*x188
    x354 = x27*x96
    x355 = x319*x88
    x356 = x18*x328
    x357 = x160*x343
    x358 = x319*x87
    x359 = x164*x350 + x164*x351 + x197*x26 + x201*x26 + x202*x354 + x202*x355 + x252*x26 + x255*x26 - x296 - x297 - x299 + x332*x358 + x345*x358 - x349 + x352 - x353 + x356*x87 + x357*x87
    x360 = x0*x211
    x361 = p1*x360
    x362 = -x15
    x363 = x12 + x362
    x364 = p2*x0*x45*x49*x6 - x361 - x363
    x365 = p0*x360
    x366 = p2*x0*x51
    x367 = x0*x14
    x368 = x367 + x65
    x369 = x139 + x365 - x366 + x368
    x370 = x0*x50*x74
    x371 = x0*x71
    x372 = x371 + x77
    x373 = p1*x0*x1*x45*x49 - x135 - x370 - x372
    x374 = 2*p2*x0*x10*x6 - x0*x128
    x375 = -x0*x105 + x0*x134 + x104
    x376 = 2*p0*x0*x10*x3 - x0*x138 - x108
    x377 = -x131
    x378 = x128 + x377
    x379 = 2*x371
    x380 = x105 + x379
    x381 = 2*x367
    x382 = x110 + x381
    x383 = x120*x374 + x123*x375 + x126*x376 + x127*(2*p2*x0*x45*x49*x6 - 2*x361 - x378) + x133*(2*p1*x0*x1*x45*x49 + 4*p1*x1*x10 - 2*x370 - x380) + x137*(2*x365 - 2*x366 + x382 - 4*x66)
    x384 = -x237*x376 - x238*x375 - x239*x374
    x385 = x181*x184
    x386 = x194*x33
    x387 = x0*x12
    x388 = p2*x0*x10*x6 - x387
    x389 = x388*x42
    x390 = x116*x384
    x391 = x0*x66
    x392 = p0*x0*x10*x3 - x35 - x391
    x393 = x0*x78
    x394 = -x0*x77 + x37 + x393
    x395 = x113*x388
    x396 = x18*x384
    x397 = x160*x384
    x398 = x113*x392
    x399 = x113*x394
    x400 = x164*x384
    x401 = -x83
    x402 = x320*x330
    x403 = x114*x384
    x404 = x403*x95
    x405 = x181*x96
    x406 = x319*x401
    x407 = x156*x388 + x159*x392 + x163*x394 + x166*x395 + x166*x396 + x168*x397 + x168*x398 + x170*x399 + x170*x400 + x172*x395 + x172*x396 + x173*x397 + x173*x398 + x174*x399 + x174*x400 + x196*x404 + x267*x404 + x317 + x322 + x332*x406 + x333*x406 + x345*x406 + x356*x401 + x357*x401 + x389 + x390 + x401*x402 + x404*x405
    x408 = x5*x50
    x409 = x408*x54
    x410 = x211*x5
    x411 = p1*x410
    x412 = x409 - x411 + x66
    x413 = x14*x5
    x414 = p0*x410
    x415 = p2*x5*x51
    x416 = x413 + x414 - x415
    x417 = x408*x74
    x418 = x5*x71
    x419 = x219 + x418
    x420 = p1*x1*x45*x49*x5 - x417 - x419
    x421 = x110*x5 - x138*x5
    x422 = x108 - x128*x5 + x131*x5
    x423 = 2*x413
    x424 = 2*p1*x1*x10*x5 - x105*x5 - x227
    x425 = 2*x418
    x426 = x230 + x425
    x427 = x120*x422 + x123*x424 + x126*x421 + x127*(x138 + 2*x409 - 2*x411) + x133*(2*p1*x1*x45*x49*x5 - 2*x417 - x426) + x137*(2*x414 - 2*x415 + x423)
    x428 = -x237*x421 - x238*x424 - x239*x422
    x429 = x15*x5
    x430 = -x12*x5 + x35 + x429
    x431 = x42*x430
    x432 = x116*x428
    x433 = x5*x65
    x434 = x433 - x5*x66
    x435 = x5*x77
    x436 = p1*x1*x10*x5 - x31 - x435
    x437 = x18*x428
    x438 = x113*x430
    x439 = x113*x434
    x440 = x160*x428
    x441 = x113*x436
    x442 = x164*x428
    x443 = -x85
    x444 = x114*x428
    x445 = x444*x95
    x446 = x319*x443
    x447 = x156*x430 + x159*x434 + x163*x436 + x166*x437 + x166*x438 + x168*x439 + x168*x440 + x170*x441 + x170*x442 + x172*x437 + x172*x438 + x173*x439 + x173*x440 + x174*x441 + x174*x442 + x196*x445 + x267*x445 + x332*x446 + x333*x446 + x337 + x341 + x345*x446 + x356*x443 + x357*x443 + x402*x443 + x405*x445 + x431 + x432
    x448 = x2*x211
    x449 = p1*x448
    x450 = p2*x2*x45*x49*x6 - x449 - x78
    x451 = p0*x448
    x452 = p2*x2*x51
    x453 = x14*x2
    x454 = x219 + x453
    x455 = x451 - x452 + x454
    x456 = x2*x71
    x457 = x2*x50*x74
    x458 = p1*x1*x2*x45*x49 - x456 - x457
    x459 = 2*p1*x1*x10*x2 - x105*x2
    x460 = 2*p2*x10*x2*x6 - x104 - x128*x2
    x461 = 2*x456
    x462 = x110*x2 - x138*x2 + x227
    x463 = 2*x453
    x464 = x230 + x463
    x465 = x120*x460 + x123*x459 + x126*x462 + x127*(2*p2*x2*x45*x49*x6 - x134 - 2*x449) + x133*(2*p1*x1*x2*x45*x49 - 2*x457 - x461) + x137*(2*x451 - 2*x452 + x464)
    x466 = -x237*x462 - x238*x459 - x239*x460
    x467 = x12*x2
    x468 = p2*x10*x2*x6 - x37 - x467
    x469 = x42*x468
    x470 = x116*x466
    x471 = x2*x65
    x472 = -x2*x66 + x31 + x471
    x473 = x2*x77
    x474 = p1*x1*x10*x2 - x473
    x475 = x18*x466
    x476 = x113*x468
    x477 = x113*x472
    x478 = x160*x466
    x479 = x113*x474
    x480 = x164*x466
    x481 = -x87
    x482 = x114*x466
    x483 = x482*x95
    x484 = x319*x481
    x485 = x156*x468 + x159*x472 + x163*x474 + x166*x475 + x166*x476 + x168*x477 + x168*x478 + x170*x479 + x170*x480 + x172*x475 + x172*x476 + x173*x477 + x173*x478 + x174*x479 + x174*x480 + x196*x483 + x267*x483 + x332*x484 + x333*x484 + x345*x484 + x349 + x353 + x356*x481 + x357*x481 + x402*x481 + x405*x483 + x469 + x470
    x486 = 3*m1
    x487 = 3*n1
    x488 = x486 - x487
    x489 = -x488
    x490 = x45*x489
    x491 = x1*x490
    x492 = x3*x491
    x493 = p1*x492
    x494 = x491*x54
    x495 = -x494 + x66
    x496 = -x493 - x495
    x497 = p2*x4*x490
    x498 = p0*x492
    x499 = x15 - x497 + x498
    x500 = x491*x74
    x501 = p1*x4*x45*x489 - x221 - x500
    x502 = (mpmath.mpf(1)/mpmath.mpf(2))*x253
    x503 = -x119 - x502
    x504 = x124 - mpmath.mpf(1)/mpmath.mpf(2)*x14*x7 + (mpmath.mpf(1)/mpmath.mpf(2))*x245
    x505 = 2*x493
    x506 = x138 - 2*x494
    x507 = (mpmath.mpf(1)/mpmath.mpf(2))*x31
    x508 = (mpmath.mpf(1)/mpmath.mpf(2))*p0*x10*x7 - mpmath.mpf(1)/mpmath.mpf(2)*x256 - x507
    x509 = x102*x504 + x106*x508 + x111*x503 + x127*(-x505 - x506) + x133*(2*p1*x4*x45*x489 - x233 - 2*x500) + x137*(x131 - 2*x497 + 2*x498)
    x510 = -3*o1
    x511 = x486 + x510
    x512 = -x177*x511
    x513 = x512*x95
    x514 = (mpmath.mpf(3)/mpmath.mpf(2))*x36
    x515 = (mpmath.mpf(3)/mpmath.mpf(2))*x33
    x516 = (mpmath.mpf(3)/mpmath.mpf(2))*x39
    x517 = x182*(-x224*x514 - x225*x516 - x229*x515)
    x518 = x29*x517
    x519 = x142*x518
    x520 = x26*x518
    x521 = x517*x90
    x522 = x191*x521
    x523 = x521*x85
    x524 = x521*x87
    x525 = x254*x42
    x526 = 2*m1
    x527 = 2*n1
    x528 = x526 - x527
    x529 = x14*x528
    x530 = x490*x7
    x531 = p2*x530
    x532 = x3*x490
    x533 = x212*x532
    x534 = x363 + x529 + x531 - x533
    x535 = -x65
    x536 = x532*x74
    x537 = x495 + x535 + x536
    x538 = x528*x76
    x539 = p0*x530
    x540 = -x77
    x541 = x540 + x78
    x542 = p1*x1*x45*x489*x6 - x538 - x539 - x541
    x543 = x206*x235
    x544 = x144*x240
    x545 = -x110
    x546 = 2*x536
    x547 = -x105
    x548 = x134 + x547
    x549 = x127*(x378 + 2*x529 + 2*x531 - 2*x533) + x133*(2*p1*x1*x45*x489*x6 - 2*x538 - 2*x539 - x548) + x137*(x506 + x545 + x546) + x224*x503 + x225*x504 + x229*x508
    x550 = x155*x235
    x551 = 2*x246
    x552 = x158*x235
    x553 = 2*x254
    x554 = x162*x235
    x555 = 2*x257
    x556 = x240*x551
    x557 = x240*x553
    x558 = x240*x555
    x559 = x235*x512
    x560 = x180*x518
    x561 = x36*x523
    x562 = x196*x265
    x563 = 2*x235
    x564 = x265*x267
    x565 = x203*x268
    x566 = p1*x490*x8
    x567 = -x218 + x277
    x568 = p2*x3*x45*x489*x6 - x566 - x567
    x569 = p2*x492
    x570 = p0*x45*x489*x8 - x569 - x77
    x571 = x493 - x536 + x65
    x572 = -x232 + x287
    x573 = x127*(2*p2*x3*x45*x489*x6 - 2*x566 - x572) + x133*(x110 + x505 - x546) + x137*(2*p0*x45*x489*x8 - x105 - 2*x569) + x281*x508 + x284*x504 + x286*x503
    x574 = x290*x512
    x575 = x257*x42
    x576 = x301*x42
    x577 = x208*x235
    x578 = x206*x290
    x579 = x144*x292
    x580 = x115*x242
    x581 = x155*x246
    x582 = x158*x254
    x583 = x162*x290
    x584 = x240*x294
    x585 = x246*x292
    x586 = x254*x292
    x587 = x240*x301
    x588 = x240*x302
    x589 = x257*x292
    x590 = x235*x309
    x591 = x265*x290
    x592 = x203*x311
    x593 = x166*x584 + x166*x585 + x168*x586 + x168*x587 + x170*x588 + x170*x589 + x172*x584 + x172*x585 + x173*x586 + x173*x587 + x174*x588 + x174*x589 + x196*x590 + x196*x591 + x235*x592 + x257*x583 + x267*x590 + x267*x591 + x290*x565 + x290*x581 + x290*x582 + x294*x550 + x301*x552 + x302*x554 + x575 + x576 + x577 + x578 + x579 + x580
    x594 = x20*x512
    x595 = x246*x91
    x596 = x20*x206
    x597 = x149*x240
    x598 = x257*x26
    x599 = x257*x87
    x600 = x265*x36
    x601 = x331*x85
    x602 = x268*x87
    x603 = x155*x598 + x20*x564 + x20*x565 + x246*x318 + x246*x321 - x247 - x249 - x251 + x254*x326 + x254*x329 + x265*x323 + x265*x325 + x328*x599 + x331*x602 - x595 + x596 - x597 + x600*x601
    x604 = -2*o1
    x605 = x526 + x604
    x606 = x23*x512
    x607 = x254*x91
    x608 = x151*x240
    x609 = x335*x96
    x610 = x342*x36
    x611 = x191*x265
    x612 = x158*x598 + x205 + x209 + x23*x562 + x23*x565 + x246*x326 + x246*x329 + x254*x338 + x254*x339 + x265*x609 + x265*x610 + x343*x599 + x344*x602 + x344*x611 - x525 - x543 - x544 - x607 - x608
    x613 = x26*x512
    x614 = x257*x91
    x615 = x206*x26
    x616 = x148*x242
    x617 = x246*x328
    x618 = x254*x343
    x619 = x344*x600
    x620 = x257*x350 + x257*x351 + x26*x562 + x26*x564 + x26*x581 + x26*x582 + x268*x354 + x268*x355 + x358*x611 - x575 - x577 - x580 - x614 + x615 - x616 + x617*x87 + x618*x87 + x619*x87
    x621 = p1*x0*x532
    x622 = p2*x0*x45*x489*x6 - x367 - x621
    x623 = x0*x491
    x624 = p2*x623
    x625 = p0*x0*x3*x45*x489 - x15 - x624
    x626 = p1*x623
    x627 = x0*x490*x74
    x628 = x0*x76
    x629 = x218 + x628
    x630 = x626 - x627 + x629
    x631 = 2*x628
    x632 = x232 + x631
    x633 = x127*(2*p2*x0*x45*x489*x6 - x381 - 2*x621) + x133*(2*x626 - 2*x627 + x632) + x137*(2*p0*x0*x3*x45*x489 - x131 - 2*x624) + x374*x504 + x375*x508 + x376*x503
    x634 = x181*x518
    x635 = x33*x524
    x636 = x392*x42
    x637 = x144*x384
    x638 = x240*x388
    x639 = x246*x384
    x640 = x254*x384
    x641 = x240*x392
    x642 = x257*x384
    x643 = x240*x394
    x644 = x320*x599
    x645 = x235*x403
    x646 = x268*x358
    x647 = x166*x638 + x166*x639 + x168*x640 + x168*x641 + x170*x642 + x170*x643 + x172*x638 + x172*x639 + x173*x640 + x173*x641 + x174*x642 + x174*x643 + x196*x645 + x267*x645 + x388*x550 + x392*x552 + x394*x554 + x401*x617 + x401*x618 + x401*x619 + x401*x644 + x401*x646 + x405*x645 + x406*x611 + x595 + x597 + x636 + x637
    x648 = x5*x532
    x649 = p1*x648
    x650 = x12 + x413
    x651 = p2*x45*x489*x5*x6 - x377 - x649 - x650
    x652 = p0*x648
    x653 = x491*x5
    x654 = p2*x653
    x655 = x652 - x654 + x68
    x656 = p1*x653
    x657 = x490*x5*x74
    x658 = x5*x76
    x659 = x658 + x78
    x660 = x547 + x656 - x657 + x659
    x661 = 2*x658
    x662 = x134 + x661
    x663 = x128 + x423
    x664 = x127*(4*p2*x10*x6 + 2*p2*x45*x489*x5*x6 - 2*x649 - x663) + x133*(2*x656 - 2*x657 + x662 - 4*x77) + x137*(x140 + 2*x652 - 2*x654) + x421*x503 + x422*x504 + x424*x508
    x665 = x42*x434
    x666 = x144*x428
    x667 = x240*x430
    x668 = x246*x428
    x669 = x240*x434
    x670 = x254*x428
    x671 = x257*x428
    x672 = x240*x436
    x673 = x235*x444
    x674 = x166*x667 + x166*x668 + x168*x669 + x168*x670 + x170*x671 + x170*x672 + x172*x667 + x172*x668 + x173*x669 + x173*x670 + x174*x671 + x174*x672 + x196*x673 + x267*x673 + x405*x673 + x430*x550 + x434*x552 + x436*x554 + x443*x617 + x443*x618 + x443*x619 + x443*x644 + x443*x646 + x446*x611 + x607 + x608 + x665 + x666
    x675 = x2*x532
    x676 = p1*x675
    x677 = x218 + x453
    x678 = p2*x2*x45*x489*x6 - x676 - x677
    x679 = p0*x675
    x680 = x2*x491
    x681 = p2*x680
    x682 = x679 - x681 + x77
    x683 = x2*x76
    x684 = p1*x680
    x685 = x2*x490*x74
    x686 = x683 + x684 - x685
    x687 = 2*x683
    x688 = x232 + x463
    x689 = x127*(2*p2*x2*x45*x489*x6 - 2*x676 - x688) + x133*(2*x684 - 2*x685 + x687) + x137*(x105 + 2*x679 - 2*x681) + x459*x508 + x460*x504 + x462*x503
    x690 = x42*x472
    x691 = x144*x466
    x692 = x240*x468
    x693 = x246*x466
    x694 = x254*x466
    x695 = x240*x472
    x696 = x240*x474
    x697 = x257*x466
    x698 = x235*x482
    x699 = x166*x692 + x166*x693 + x168*x694 + x168*x695 + x170*x696 + x170*x697 + x172*x692 + x172*x693 + x173*x694 + x173*x695 + x174*x696 + x174*x697 + x196*x698 + x267*x698 + x405*x698 + x468*x550 + x472*x552 + x474*x554 + x481*x617 + x481*x618 + x481*x619 + x481*x644 + x481*x646 + x484*x611 + x614 + x616 + x690 + x691
    x700 = 3*m2
    x701 = 3*n2
    x702 = x700 - x701
    x703 = -x702
    x704 = x45*x703
    x705 = x1*x704
    x706 = x54*x705
    x707 = x3*x705
    x708 = p1*x707
    x709 = -x708 + x78
    x710 = x706 + x709
    x711 = p2*x4*x704
    x712 = p0*x707
    x713 = x278 - x711 + x712
    x714 = x705*x74
    x715 = p1*x4*x45*x703 - x12 - x714
    x716 = -x118 + x502
    x717 = (mpmath.mpf(1)/mpmath.mpf(2))*p1*x10*x8 - x121 - mpmath.mpf(1)/mpmath.mpf(2)*x283
    x718 = 2*x706
    x719 = x134 - 2*x708
    x720 = (mpmath.mpf(1)/mpmath.mpf(2))*x285 + x507 - mpmath.mpf(1)/mpmath.mpf(2)*x76*x8
    x721 = x102*x717 + x106*x716 + x111*x720 + x127*(x718 + x719) + x133*(2*p1*x4*x45*x703 - x128 - 2*x714) + x137*(x288 - 2*x711 + 2*x712)
    x722 = -3*o2
    x723 = x700 + x722
    x724 = -x177*x723
    x725 = x724*x95
    x726 = x182*(-x281*x515 - x284*x516 - x286*x514)
    x727 = x29*x726
    x728 = x142*x727
    x729 = x26*x727
    x730 = x726*x90
    x731 = x191*x730
    x732 = x730*x85
    x733 = x730*x87
    x734 = x3*x704
    x735 = x212*x734
    x736 = p2*x45*x7*x703 - x567 - x735
    x737 = x734*x74
    x738 = -x706 + x737 - x77
    x739 = p0*x7*x704
    x740 = x212*x705
    x741 = x65 - x739 + x740
    x742 = 2*x737
    x743 = x127*(2*p2*x45*x7*x703 - x572 - 2*x735) + x133*(x110 - 2*x739 + 2*x740) + x137*(-x105 - x718 + x742) + x224*x720 + x225*x717 + x229*x716
    x744 = x235*x724
    x745 = x180*x727
    x746 = x36*x732
    x747 = x302*x42
    x748 = 2*m2
    x749 = 2*n2
    x750 = x748 - x749
    x751 = x71*x750
    x752 = x704*x8
    x753 = p1*x752
    x754 = x15 + x44
    x755 = p2*x3*x45*x6*x703 - x751 - x753 - x754
    x756 = x750*x76
    x757 = p0*x752
    x758 = p2*x707
    x759 = x535 + x66
    x760 = x756 + x757 - x758 + x759
    x761 = -x540 - x709 - x737
    x762 = x208*x290
    x763 = x115*x293
    x764 = x138 + x545
    x765 = x129 + x131
    x766 = x127*(2*p2*x3*x45*x6*x703 - 2*x751 - 2*x753 - x765) + x133*(-x547 - x719 - x742) + x137*(2*x756 + 2*x757 - 2*x758 + x764) + x281*x716 + x284*x717 + x286*x720
    x767 = x155*x290
    x768 = 2*x294
    x769 = x158*x290
    x770 = 2*x301
    x771 = 2*x302
    x772 = x292*x768
    x773 = x292*x770
    x774 = x292*x771
    x775 = x290*x724
    x776 = x196*x309
    x777 = 2*x290
    x778 = x267*x309
    x779 = x20*x724
    x780 = x294*x91
    x781 = x20*x208
    x782 = x149*x292
    x783 = x26*x302
    x784 = x302*x87
    x785 = x309*x36
    x786 = x311*x87
    x787 = x155*x783 + x20*x592 + x20*x778 + x294*x318 + x294*x321 - x295 - x298 - x300 + x301*x326 + x301*x329 + x309*x323 + x309*x325 + x328*x784 + x331*x786 + x601*x785 - x780 + x781 - x782
    x788 = x23*x724
    x789 = x301*x91
    x790 = x208*x23
    x791 = x151*x292
    x792 = x191*x309
    x793 = x158*x783 + x23*x592 + x23*x776 + x294*x326 + x294*x329 + x301*x338 + x301*x339 + x309*x609 + x309*x610 + x343*x784 + x344*x786 + x344*x792 - x576 - x578 - x579 - x789 + x790 - x791
    x794 = -2*o2
    x795 = x748 + x794
    x796 = x26*x724
    x797 = x302*x91
    x798 = x148*x293
    x799 = x155*x26
    x800 = x158*x26
    x801 = x294*x328
    x802 = x301*x343
    x803 = x344*x785
    x804 = x205 + x207 + x26*x776 + x26*x778 + x294*x799 + x301*x800 + x302*x350 + x302*x351 + x311*x354 + x311*x355 + x358*x792 - x747 - x762 - x763 - x797 - x798 + x801*x87 + x802*x87 + x803*x87
    x805 = x0*x704
    x806 = x54*x805
    x807 = p1*x0*x734
    x808 = x371 + x806 - x807
    x809 = x0*x705
    x810 = p2*x809
    x811 = x277 + x628
    x812 = p0*x0*x3*x45*x703 - x810 - x811
    x813 = p1*x809
    x814 = x74*x805
    x815 = x12 + x813 - x814
    x816 = x287 + x631
    x817 = x127*(x379 + 2*x806 - 2*x807) + x133*(x128 + 2*x813 - 2*x814) + x137*(2*p0*x0*x3*x45*x703 - 2*x810 - x816) + x374*x717 + x375*x716 + x376*x720
    x818 = x181*x727
    x819 = x33*x733
    x820 = x394*x42
    x821 = x146*x384
    x822 = x292*x388
    x823 = x294*x384
    x824 = x301*x384
    x825 = x292*x392
    x826 = x302*x384
    x827 = x292*x394
    x828 = x320*x784
    x829 = x290*x403
    x830 = x311*x358
    x831 = x166*x822 + x166*x823 + x168*x824 + x168*x825 + x170*x826 + x170*x827 + x172*x822 + x172*x823 + x173*x824 + x173*x825 + x174*x826 + x174*x827 + x196*x829 + x267*x829 + x388*x767 + x392*x769 + x394*x583 + x401*x801 + x401*x802 + x401*x803 + x401*x828 + x401*x830 + x405*x829 + x406*x792 + x780 + x782 + x820 + x821
    x832 = x5*x704
    x833 = x54*x832
    x834 = p1*x5*x734
    x835 = x277 + x418
    x836 = x833 - x834 + x835
    x837 = p2*x5*x705
    x838 = p0*x3*x45*x5*x703 - x658 - x837
    x839 = x74*x832
    x840 = p1*x1*x45*x5*x703 - x65 - x839
    x841 = x287 + x425
    x842 = x127*(2*x833 - 2*x834 + x841) + x133*(2*p1*x1*x45*x5*x703 - x110 - 2*x839) + x137*(2*p0*x3*x45*x5*x703 - x661 - 2*x837) + x421*x720 + x422*x717 + x424*x716
    x843 = x42*x436
    x844 = x146*x428
    x845 = x294*x428
    x846 = x292*x430
    x847 = x292*x434
    x848 = x301*x428
    x849 = x302*x428
    x850 = x292*x436
    x851 = x290*x444
    x852 = x166*x845 + x166*x846 + x168*x847 + x168*x848 + x170*x849 + x170*x850 + x172*x845 + x172*x846 + x173*x847 + x173*x848 + x174*x849 + x174*x850 + x196*x851 + x267*x851 + x405*x851 + x430*x767 + x434*x769 + x436*x583 + x443*x801 + x443*x802 + x443*x803 + x443*x828 + x443*x830 + x446*x792 + x789 + x791 + x843 + x844
    x853 = x2*x704
    x854 = x54*x853
    x855 = p1*x2*x734
    x856 = x15 + x456
    x857 = x129 + x854 - x855 + x856
    x858 = p2*x2*x705
    x859 = x66 + x683
    x860 = p0*x2*x3*x45*x703 - x545 - x858 - x859
    x861 = x74*x853
    x862 = p1*x1*x2*x45*x703 - x80 - x861
    x863 = x138 + x687
    x864 = x131 + x461
    x865 = x127*(-4*x12 + 2*x854 - 2*x855 + x864) + x133*(2*p1*x1*x2*x45*x703 - x136 - 2*x861) + x137*(4*p0*x10*x3 + 2*p0*x2*x3*x45*x703 - 2*x858 - x863) + x459*x716 + x460*x717 + x462*x720
    x866 = x42*x474
    x867 = x146*x466
    x868 = x294*x466
    x869 = x292*x468
    x870 = x292*x472
    x871 = x301*x466
    x872 = x292*x474
    x873 = x302*x466
    x874 = x290*x482
    x875 = x166*x868 + x166*x869 + x168*x870 + x168*x871 + x170*x872 + x170*x873 + x172*x868 + x172*x869 + x173*x870 + x173*x871 + x174*x872 + x174*x873 + x196*x874 + x267*x874 + x405*x874 + x468*x767 + x472*x769 + x474*x583 + x481*x801 + x481*x802 + x481*x803 + x481*x828 + x481*x830 + x484*x792 + x797 + x798 + x866 + x867
    x876 = x176*x177
    x877 = x876*x95
    x878 = x235*x876
    x879 = x290*x876
    x880 = x313 + x60
    x881 = x320*x39
    x882 = x175 + x47
    x883 = x41/x89**(mpmath.mpf(5)/mpmath.mpf(2))
    x884 = x882*x883
    x885 = x20*x876
    x886 = x83*x884
    x887 = x36*x85
    x888 = x33*x87
    x889 = x83*x881
    x890 = x320*x36
    x891 = x85*x890
    x892 = x320*x33
    x893 = x87*x892
    x894 = -x889 - x891 - x893
    x895 = x210 + x894
    x896 = x36*x86
    x897 = x23*x876
    x898 = x85*x884
    x899 = x83*x890
    x900 = x85*x881
    x901 = -x340 - x596 - x899 - x900
    x902 = x33*x88
    x903 = x26*x876
    x904 = x87*x884
    x905 = x83*x892
    x906 = x87*x881
    x907 = -x352 - x781 - x905 - x906
    x908 = x401*x884
    x909 = x388*x91
    x910 = x401*x881
    x911 = x149*x384
    x912 = x328*x87
    x913 = x20*x403
    x914 = x36*x601
    x915 = x331*x888
    x916 = x267*x913 + x318*x388 + x321*x388 + x323*x403 + x325*x403 + x326*x392 + x329*x392 - x389 - x390 + x394*x799 + x394*x912 + x403*x914 + x403*x915 + x405*x913 + x891 + x893 - x909 - x910 - x911
    x917 = x443*x884
    x918 = x430*x91
    x919 = x443*x881
    x920 = x149*x428
    x921 = x20*x444
    x922 = x267*x921 + x318*x430 + x321*x430 + x323*x444 + x325*x444 + x326*x434 + x329*x434 + x405*x921 - x431 - x432 + x436*x799 + x436*x912 + x444*x914 + x444*x915 + x899 - x918 - x919 - x920
    x923 = x481*x884
    x924 = x468*x91
    x925 = x481*x881
    x926 = x149*x466
    x927 = x20*x482
    x928 = x267*x927 + x318*x468 + x321*x468 + x323*x482 + x325*x482 + x326*x472 + x329*x472 + x405*x927 - x469 - x470 + x474*x799 + x474*x912 + x482*x914 + x482*x915 + x905 - x924 - x925 - x926
    x929 = x177*x511
    x930 = x929*x95
    x931 = x235*x929
    x932 = x290*x929
    x933 = x487 + x510
    x934 = x883*x933
    x935 = x20*x929
    x936 = x83*x934
    x937 = x527 + x604
    x938 = x23*x929
    x939 = x85*x934
    x940 = x26*x929
    x941 = x87*x934
    x942 = x85*x892
    x943 = x87*x890
    x944 = -x615 - x790 - x942 - x943
    x945 = x401*x934
    x946 = x392*x91
    x947 = x401*x890
    x948 = x151*x384
    x949 = x343*x87
    x950 = x23*x403
    x951 = x344*x403
    x952 = x191*x951 + x196*x950 + x326*x388 + x329*x388 + x338*x392 + x339*x392 + x394*x800 + x394*x949 + x403*x609 + x403*x610 + x405*x950 - x636 - x637 + x888*x951 + x900 - x946 - x947 - x948
    x953 = x443*x934
    x954 = x434*x91
    x955 = x443*x890
    x956 = x151*x428
    x957 = x23*x444
    x958 = x344*x444
    x959 = x191*x958 + x196*x957 + x326*x430 + x329*x430 + x338*x434 + x339*x434 + x405*x957 + x436*x800 + x436*x949 + x444*x609 + x444*x610 - x665 - x666 + x888*x958 + x889 + x893 - x954 - x955 - x956
    x960 = x481*x934
    x961 = x472*x91
    x962 = x481*x890
    x963 = x151*x466
    x964 = x23*x482
    x965 = x344*x482
    x966 = x191*x965 + x196*x964 + x326*x468 + x329*x468 + x338*x472 + x339*x472 + x405*x964 + x474*x800 + x474*x949 + x482*x609 + x482*x610 - x690 - x691 + x888*x965 + x942 - x961 - x962 - x963
    x967 = x177*x723
    x968 = x95*x967
    x969 = x235*x967
    x970 = x290*x967
    x971 = x701 + x722
    x972 = x883*x971
    x973 = x20*x967
    x974 = x83*x972
    x975 = x23*x967
    x976 = x85*x972
    x977 = x749 + x794
    x978 = x26*x967
    x979 = x87*x972
    x980 = x401*x972
    x981 = x394*x91
    x982 = x401*x892
    x983 = x153*x384
    x984 = x347*x96
    x985 = x33*x355
    x986 = x26*x403
    x987 = x191*x358
    x988 = x36*x87
    x989 = x196*x986 + x267*x986 + x350*x394 + x351*x394 + x388*x799 + x388*x912 + x392*x800 + x392*x949 + x403*x984 + x403*x985 + x403*x987 - x820 - x821 + x906 + x951*x988 - x981 - x982 - x983
    x990 = x443*x972
    x991 = x436*x91
    x992 = x443*x892
    x993 = x153*x428
    x994 = x26*x444
    x995 = x196*x994 + x267*x994 + x350*x436 + x351*x436 + x430*x799 + x430*x912 + x434*x800 + x434*x949 + x444*x984 + x444*x985 + x444*x987 - x843 - x844 + x943 + x958*x988 - x991 - x992 - x993
    x996 = x481*x972
    x997 = x474*x91
    x998 = x481*x892
    x999 = x153*x466
    x1000 = x26*x482
    x1001 = x1000*x196 + x1000*x267 + x350*x474 + x351*x474 + x468*x799 + x468*x912 + x472*x800 + x472*x949 + x482*x984 + x482*x985 + x482*x987 - x866 - x867 + x889 + x891 + x965*x988 - x997 - x998 - x999
    x1002 = x45*x48
    x1003 = x1*x1002
    x1004 = x1003*x54
    x1005 = x1003*x3
    x1006 = p1*x1005
    x1007 = x1006 + x12
    x1008 = x1004 - x1007 - x362
    x1009 = -x61
    x1010 = x1009*x14
    x1011 = p2*x1002*x4
    x1012 = p0*x1005
    x1013 = -x1010 - x1011 + x1012 + x368
    x1014 = x1003*x74
    x1015 = p1*x10*x1009 + p1*x4*x45*x48 - x1014 - x372
    x1016 = -mpmath.mpf(1)/mpmath.mpf(2)*x0*x15 + (mpmath.mpf(1)/mpmath.mpf(2))*x387
    x1017 = (mpmath.mpf(1)/mpmath.mpf(2))*p0*x0*x10*x6 - x121 - mpmath.mpf(1)/mpmath.mpf(2)*x393
    x1018 = -mpmath.mpf(1)/mpmath.mpf(2)*x0*x65 + x124 + (mpmath.mpf(1)/mpmath.mpf(2))*x391
    x1019 = 2*x1004
    x1020 = 2*x1006 + x128
    x1021 = x1016*x102 + x1017*x106 + x1018*x111 + x127*(x1019 - x1020 - x377) + x133*(2*p1*x10*x1009 + 2*p1*x4*x45*x48 - 2*x1014 - x380) + x137*(-2*x1010 - 2*x1011 + 2*x1012 + x382)
    x1022 = x182*(-x374*x516 - x375*x515 - x376*x514)
    x1023 = x1022*x29
    x1024 = x1023*x142
    x1025 = x1023*x26
    x1026 = x1022*x90
    x1027 = x1026*x191
    x1028 = x186*x85
    x1029 = x1026*x87
    x1030 = x1002*x3
    x1031 = x1030*x212
    x1032 = p2*x45*x48*x7 - x1031 - x367
    x1033 = x1030*x74
    x1034 = -x1033
    x1035 = -x1004 - x1034 - x15
    x1036 = p0*x1002*x7
    x1037 = x1003*x212
    x1038 = -x1036 + x1037 + x629
    x1039 = -2*x1033
    x1040 = x1016*x225 + x1017*x229 + x1018*x224 + x127*(2*p2*x45*x48*x7 - 2*x1031 - x381) + x133*(-2*x1036 + 2*x1037 + x632) + x137*(-x1019 - x1039 - x131)
    x1041 = x1023*x180
    x1042 = x1026*x887
    x1043 = p1*x1002*x8
    x1044 = x1030*x54
    x1045 = -x1043 + x1044 + x371
    x1046 = p2*x1005
    x1047 = p0*x45*x48*x8 - x1046 - x811
    x1048 = x1007 + x1034
    x1049 = x1016*x284 + x1017*x281 + x1018*x286 + x127*(-2*x1043 + 2*x1044 + x379) + x133*(x1020 + x1039) + x137*(2*p0*x45*x48*x8 - 2*x1046 - x816)
    x1050 = -x882*x883
    x1051 = x1050*x83
    x1052 = x1050*x85
    x1053 = x1050*x87
    x1054 = p1*x0*x1030
    x1055 = p2*x0*x45*x48*x6 - x1054 - x754
    x1056 = x0*x1003
    x1057 = p2*x1056
    x1058 = p0*x0*x3*x45*x48 - x1057 - x381 - x68
    x1059 = p1*x1056
    x1060 = x0*x1002*x74
    x1061 = x1059 - x1060 + x379 + x80
    x1062 = x1016*x374 + x1017*x375 + x1018*x376 + x127*(2*p2*x0*x45*x48*x6 - 2*x1054 - x765) + x133*(2*x1059 - 2*x1060 + x136 + 4*x371) + x137*(2*p0*x0*x3*x45*x48 - 2*x1057 - x140 - 4*x367)
    x1063 = 2*x384
    x1064 = x1063*x388
    x1065 = x1063*x392
    x1066 = x1063*x394
    x1067 = x328*x401
    x1068 = x343*x401
    x1069 = x320*x87
    x1070 = x1069*x401
    x1071 = x1023*x181
    x1072 = x1050*x401
    x1073 = x1026*x888
    x1074 = x191*x406
    x1075 = 2*x403
    x1076 = x36*x401
    x1077 = x33*x358
    x1078 = x1077*x401
    x1079 = x1002*x5
    x1080 = x1079*x54
    x1081 = p1*x1030*x5
    x1082 = x1080 - x1081 + x367
    x1083 = p2*x1003*x5
    x1084 = p0*x3*x45*x48*x5 - x1083 - x413
    x1085 = x1079*x74
    x1086 = -x418 + x628
    x1087 = p1*x1*x45*x48*x5 - x1085 - x1086
    x1088 = -x425 + x631
    x1089 = x1016*x422 + x1017*x424 + x1018*x421 + x127*(2*x1080 - 2*x1081 + x381) + x133*(2*p1*x1*x45*x48*x5 - 2*x1085 - x1088) + x137*(2*p0*x3*x45*x48*x5 - 2*x1083 - x423)
    x1090 = x1050*x443
    x1091 = x388*x428
    x1092 = x384*x430
    x1093 = x384*x434
    x1094 = x392*x428
    x1095 = x394*x428
    x1096 = x384*x436
    x1097 = x328*x388
    x1098 = x343*x392
    x1099 = x1069*x394
    x1100 = x191*x403
    x1101 = x36*x951
    x1102 = x1077*x403
    x1103 = x1067*x430 + x1068*x434 + x1070*x436 + x1074*x444 + x1076*x958 + x1078*x444 + x1091*x166 + x1091*x172 + x1092*x166 + x1092*x172 + x1093*x168 + x1093*x173 + x1094*x168 + x1094*x173 + x1095*x170 + x1095*x174 + x1096*x170 + x1096*x174 + x1097*x443 + x1098*x443 + x1099*x443 + x1100*x446 + x1101*x443 + x1102*x443 + x918 + x919 + x920 + x946 + x947 + x948
    x1104 = x1030*x2
    x1105 = p1*x1104
    x1106 = p2*x2*x45*x48*x6 - x1105 - x371
    x1107 = p0*x1104
    x1108 = x1003*x2
    x1109 = p2*x1108
    x1110 = -x453
    x1111 = x1110 + x628
    x1112 = x1107 - x1109 + x1111
    x1113 = p1*x1108
    x1114 = x1002*x2*x74
    x1115 = x1113 - x1114 + x456
    x1116 = -x463
    x1117 = x1116 + x631
    x1118 = x1016*x460 + x1017*x459 + x1018*x462 + x127*(2*p2*x2*x45*x48*x6 - 2*x1105 - x379) + x133*(2*x1113 - 2*x1114 + x461) + x137*(2*x1107 - 2*x1109 + x1117)
    x1119 = x1050*x481
    x1120 = x388*x466
    x1121 = x384*x468
    x1122 = x384*x472
    x1123 = x392*x466
    x1124 = x384*x474
    x1125 = x394*x466
    x1126 = x1067*x468 + x1068*x472 + x1070*x474 + x1074*x482 + x1076*x965 + x1078*x482 + x1097*x481 + x1098*x481 + x1099*x481 + x1100*x484 + x1101*x481 + x1102*x481 + x1120*x166 + x1120*x172 + x1121*x166 + x1121*x172 + x1122*x168 + x1122*x173 + x1123*x168 + x1123*x173 + x1124*x170 + x1124*x174 + x1125*x170 + x1125*x174 + x924 + x925 + x926 + x981 + x982 + x983
    x1127 = x45*x488
    x1128 = x1*x1127
    x1129 = x1128*x54
    x1130 = x1128*x3
    x1131 = p1*x1130
    x1132 = -x1131
    x1133 = x1129 + x1132 + x66
    x1134 = p2*x1127*x4
    x1135 = p0*x1130
    x1136 = -x1134 + x1135 + x413
    x1137 = x1128*x74
    x1138 = p1*x4*x45*x488 - x1137 - x419
    x1139 = (mpmath.mpf(1)/mpmath.mpf(2))*p2*x1*x10*x5 - mpmath.mpf(1)/mpmath.mpf(2)*x433
    x1140 = (mpmath.mpf(1)/mpmath.mpf(2))*p1*x10*x3*x5 - x124 - mpmath.mpf(1)/mpmath.mpf(2)*x429
    x1141 = -2*x1131
    x1142 = 2*x1129
    x1143 = (mpmath.mpf(1)/mpmath.mpf(2))*x435 - mpmath.mpf(1)/mpmath.mpf(2)*x5*x78 + x507
    x1144 = x102*x1140 + x106*x1143 + x111*x1139 + x127*(x1141 + x1142 + x138) + x133*(2*p1*x4*x45*x488 - 2*x1137 - x426) + x137*(-2*x1134 + 2*x1135 + x423)
    x1145 = x182*(-x421*x514 - x422*x516 - x424*x515)
    x1146 = x1145*x29
    x1147 = x1146*x142
    x1148 = x1146*x26
    x1149 = x1145*x90
    x1150 = x1149*x191
    x1151 = x1149*x87
    x1152 = -x528
    x1153 = x1127*x3
    x1154 = x1153*x212
    x1155 = p2*x10*x1152 + p2*x45*x488*x7 - x1154 - x650
    x1156 = x1153*x74
    x1157 = x1156 + x65
    x1158 = -x1129 + x1157 + x67
    x1159 = x1152*x76
    x1160 = p0*x1127*x7
    x1161 = x1128*x212
    x1162 = -x1159 - x1160 + x1161 + x659
    x1163 = x110 + 2*x1156
    x1164 = x1139*x224 + x1140*x225 + x1143*x229 + x127*(2*p2*x10*x1152 + 2*p2*x45*x488*x7 - 2*x1154 - x663) + x133*(-2*x1159 - 2*x1160 + 2*x1161 + x662) + x137*(-x1142 + x1163 + x139)
    x1165 = x1146*x180
    x1166 = x1149*x887
    x1167 = p1*x1127*x8
    x1168 = x1153*x54
    x1169 = -x1167 + x1168 + x835
    x1170 = p2*x1130
    x1171 = p0*x45*x488*x8 - x1170 - x658
    x1172 = -x1132 - x1157
    x1173 = x1139*x286 + x1140*x284 + x1143*x281 + x127*(-2*x1167 + 2*x1168 + x841) + x133*(-x1141 - x1163) + x137*(2*p0*x45*x488*x8 - 2*x1170 - x661)
    x1174 = -x883*x933
    x1175 = x1174*x83
    x1176 = x1174*x85
    x1177 = x1174*x87
    x1178 = x0*x1127
    x1179 = x1178*x54
    x1180 = p1*x0*x1153
    x1181 = x1179 - x1180 + x367
    x1182 = p2*x0*x1128
    x1183 = p0*x0*x3*x45*x488 - x1182 - x413
    x1184 = x1178*x74
    x1185 = p1*x0*x1*x45*x488 - x1086 - x1184
    x1186 = x1139*x376 + x1140*x374 + x1143*x375 + x127*(2*x1179 - 2*x1180 + x381) + x133*(2*p1*x0*x1*x45*x488 - x1088 - 2*x1184) + x137*(2*p0*x0*x3*x45*x488 - 2*x1182 - x423)
    x1187 = x1146*x181
    x1188 = x1174*x401
    x1189 = x1149*x888
    x1190 = x1127*x5
    x1191 = x1190*x54
    x1192 = x1153*x5
    x1193 = p1*x1192
    x1194 = x1191 - x1193 + x363 + x423
    x1195 = p0*x1192
    x1196 = p2*x1128*x5
    x1197 = x1195 - x1196 + x759
    x1198 = x1190*x74
    x1199 = p1*x1*x45*x488*x5 - x1198 - x541 - x661
    x1200 = x1139*x421 + x1140*x422 + x1143*x424 + x127*(2*x1191 - 2*x1193 + x378 + 4*x413) + x133*(2*p1*x1*x45*x488*x5 - 2*x1198 - x548 - 4*x658) + x137*(2*x1195 - 2*x1196 + x764)
    x1201 = 2*x428
    x1202 = x1201*x430
    x1203 = x1201*x434
    x1204 = x1201*x436
    x1205 = x328*x443
    x1206 = x343*x443
    x1207 = x1069*x443
    x1208 = x1174*x443
    x1209 = x191*x446
    x1210 = 2*x444
    x1211 = x36*x443
    x1212 = x1077*x443
    x1213 = x1153*x2
    x1214 = p1*x1213
    x1215 = x1110 + x418
    x1216 = p2*x2*x45*x488*x6 - x1214 - x1215
    x1217 = p0*x1213
    x1218 = p2*x1128*x2
    x1219 = x1217 - x1218 + x658
    x1220 = x1127*x2*x74
    x1221 = p1*x1*x2*x45*x488 - x1220 - x683
    x1222 = x1116 + x425
    x1223 = x1139*x462 + x1140*x460 + x1143*x459 + x127*(2*p2*x2*x45*x488*x6 - 2*x1214 - x1222) + x133*(2*p1*x1*x2*x45*x488 - 2*x1220 - x687) + x137*(2*x1217 - 2*x1218 + x661)
    x1224 = x1174*x481
    x1225 = x430*x466
    x1226 = x428*x468
    x1227 = x434*x466
    x1228 = x428*x472
    x1229 = x428*x474
    x1230 = x436*x466
    x1231 = x328*x481
    x1232 = x343*x481
    x1233 = x1069*x481
    x1234 = x191*x484
    x1235 = x36*x481
    x1236 = x1077*x481
    x1237 = x1205*x468 + x1206*x472 + x1207*x474 + x1209*x482 + x1211*x965 + x1212*x482 + x1225*x166 + x1225*x172 + x1226*x166 + x1226*x172 + x1227*x168 + x1227*x173 + x1228*x168 + x1228*x173 + x1229*x170 + x1229*x174 + x1230*x170 + x1230*x174 + x1231*x430 + x1232*x434 + x1233*x436 + x1234*x444 + x1235*x958 + x1236*x444 + x961 + x962 + x963 + x991 + x992 + x993
    x1238 = x45*x702
    x1239 = x1*x1238
    x1240 = x1239*x3
    x1241 = p1*x1240
    x1242 = x1239*x54
    x1243 = -x1242
    x1244 = -x1241 - x1243 - x78
    x1245 = p2*x1238*x4
    x1246 = p0*x1240
    x1247 = -x1245 + x1246 + x454
    x1248 = x1239*x74
    x1249 = p1*x4*x45*x702 - x1248 - x456
    x1250 = -mpmath.mpf(1)/mpmath.mpf(2)*x2*x78 + (mpmath.mpf(1)/mpmath.mpf(2))*x473
    x1251 = x121 - mpmath.mpf(1)/mpmath.mpf(2)*x15*x2 + (mpmath.mpf(1)/mpmath.mpf(2))*x467
    x1252 = 2*x1241
    x1253 = -2*x1242
    x1254 = (mpmath.mpf(1)/mpmath.mpf(2))*p2*x1*x10*x2 - mpmath.mpf(1)/mpmath.mpf(2)*x471 - x507
    x1255 = x102*x1251 + x106*x1250 + x111*x1254 + x127*(-x1252 - x1253 - x134) + x133*(2*p1*x4*x45*x702 - 2*x1248 - x461) + x137*(-2*x1245 + 2*x1246 + x464)
    x1256 = x182*(-x459*x515 - x460*x516 - x462*x514)
    x1257 = x1256*x29
    x1258 = x1257*x142
    x1259 = x1257*x26
    x1260 = x1256*x90
    x1261 = x1260*x191
    x1262 = x1260*x87
    x1263 = x1238*x3
    x1264 = x1263*x212
    x1265 = p2*x45*x7*x702 - x1264 - x677
    x1266 = x1263*x74
    x1267 = x1266 + x77
    x1268 = x1243 + x1267
    x1269 = p0*x1238*x7
    x1270 = x1239*x212
    x1271 = -x1269 + x1270 + x683
    x1272 = x105 + 2*x1266
    x1273 = x1250*x229 + x1251*x225 + x1254*x224 + x127*(2*p2*x45*x7*x702 - 2*x1264 - x688) + x133*(-2*x1269 + 2*x1270 + x687) + x137*(x1253 + x1272)
    x1274 = x1257*x180
    x1275 = x1260*x887
    x1276 = -x750
    x1277 = x1276*x71
    x1278 = p1*x1238*x8
    x1279 = x1263*x54
    x1280 = -x1277 - x1278 + x1279 + x856
    x1281 = p2*x1240
    x1282 = p0*x10*x1276 + p0*x45*x702*x8 - x1281 - x859
    x1283 = x1241 - x1267 - x79
    x1284 = x1250*x281 + x1251*x284 + x1254*x286 + x127*(-2*x1277 - 2*x1278 + 2*x1279 + x864) + x133*(x1252 - x1272 - x135) + x137*(2*p0*x10*x1276 + 2*p0*x45*x702*x8 - 2*x1281 - x863)
    x1285 = -x883*x971
    x1286 = x1285*x83
    x1287 = x1285*x85
    x1288 = x1285*x87
    x1289 = x0*x1263
    x1290 = p1*x1289
    x1291 = p2*x0*x45*x6*x702 - x1290 - x371
    x1292 = p0*x1289
    x1293 = x0*x1239
    x1294 = p2*x1293
    x1295 = x1111 + x1292 - x1294
    x1296 = p1*x1293
    x1297 = x0*x1238*x74
    x1298 = x1296 - x1297 + x456
    x1299 = x1250*x375 + x1251*x374 + x1254*x376 + x127*(2*p2*x0*x45*x6*x702 - 2*x1290 - x379) + x133*(2*x1296 - 2*x1297 + x461) + x137*(x1117 + 2*x1292 - 2*x1294)
    x1300 = x1257*x181
    x1301 = x1285*x401
    x1302 = x1260*x888
    x1303 = x1263*x5
    x1304 = p1*x1303
    x1305 = p2*x45*x5*x6*x702 - x1215 - x1304
    x1306 = p0*x1303
    x1307 = p2*x1239*x5
    x1308 = x1306 - x1307 + x658
    x1309 = x1238*x5*x74
    x1310 = p1*x1*x45*x5*x702 - x1309 - x683
    x1311 = x1250*x424 + x1251*x422 + x1254*x421 + x127*(2*p2*x45*x5*x6*x702 - x1222 - 2*x1304) + x133*(2*p1*x1*x45*x5*x702 - 2*x1309 - x687) + x137*(2*x1306 - 2*x1307 + x661)
    x1312 = x1285*x443
    x1313 = x1263*x2
    x1314 = p1*x1313
    x1315 = p2*x2*x45*x6*x702 - x1314 - x461 - x754
    x1316 = p0*x1313
    x1317 = p2*x1239*x2
    x1318 = x1316 - x1317 + x687 + x759
    x1319 = x1238*x2*x74
    x1320 = p1*x1*x2*x45*x702 - x1319 - x541
    x1321 = x1250*x459 + x1251*x460 + x1254*x462 + x127*(2*p2*x2*x45*x6*x702 - 2*x1314 - 4*x456 - x765) + x133*(2*p1*x1*x2*x45*x702 - 2*x1319 - x548) + x137*(2*x1316 - 2*x1317 + 4*x683 + x764)
    x1322 = 2*x466
    x1323 = x1322*x468
    x1324 = x1322*x472
    x1325 = x1322*x474
    x1326 = x1285*x481
    x1327 = 2*x482

    return np.array([x113*x185 + x113*x192 + 2*x117 + x141*x143 + x141*x145 + x141*x147 + x141*x150 + x141*x152 + x141*x154 + x142*x179 + x156*x157 + x159*x161 + x163*x165 + x166*x167 + x167*x172 + x168*x169 + x169*x173 + x170*x171 + x171*x174 + x179*x180 + x179*x181 + x184*x187 + x186*x193 + x188*x189 + x188*x194 + x197*x198 + x198*x201 + 2*x202*x204 + x210 + 2*x43 + x57*x58 + x57*x92 + x69*x70 + x69*x93 + x81*x82 + x81*x94 + 2*x99, x142*x236 + x143*x234 + x145*x234 + x147*x234 + x150*x234 + x152*x234 + x154*x234 + x180*x236 + x181*x236 + x185*x240 + x189*x242 + x192*x240 + x194*x242 + x214*x58 + x214*x92 + x216*x70 + x216*x93 + x222*x82 + x222*x94 + x240*x241 + x240*x243 + x270, x142*x291 + x143*x289 + x145*x289 + x147*x289 + x150*x289 + x152*x289 + x154*x289 + x180*x291 + x181*x291 + x185*x292 + x189*x293 + x192*x292 + x194*x293 + x241*x292 + x243*x292 + x274*x58 + x274*x92 + x279*x70 + x279*x93 + x280*x82 + x280*x94 + x312, x178*x315 + x180*x316 + x181*x316 + x314*x98 + x334, x142*x336 + x178*x335 + x181*x336 + x346, x142*x348 + x178*x347 + x180*x348 + x359, x143*x383 + x145*x383 + x147*x383 + x150*x383 + x152*x383 + x154*x383 + x185*x384 + x192*x384 + x241*x384 + x243*x384 + x364*x58 + x364*x92 + x369*x70 + x369*x93 + x373*x82 + x373*x94 + x384*x385 + x384*x386 + x407, x143*x427 + x145*x427 + x147*x427 + x150*x427 + x152*x427 + x154*x427 + x185*x428 + x192*x428 + x241*x428 + x243*x428 + x385*x428 + x386*x428 + x412*x58 + x412*x92 + x416*x70 + x416*x93 + x420*x82 + x420*x94 + x447, x143*x465 + x145*x465 + x147*x465 + x150*x465 + x152*x465 + x154*x465 + x185*x466 + x192*x466 + x241*x466 + x243*x466 + x385*x466 + x386*x466 + x450*x58 + x450*x92 + x455*x70 + x455*x93 + x458*x82 + x458*x94 + x485, x113*x519 + x113*x522 + x142*x513 + x143*x509 + x145*x509 + x147*x509 + x150*x509 + x152*x509 + x154*x509 + x180*x513 + x181*x513 + x186*x523 + x187*x518 + x188*x520 + x188*x524 + x270 + x496*x58 + x496*x92 + x499*x70 + x499*x93 + x501*x82 + x501*x94, x142*x559 + x143*x549 + x145*x549 + x147*x549 + x150*x549 + x152*x549 + x154*x549 + x166*x556 + x168*x557 + x170*x558 + x172*x556 + x173*x557 + x174*x558 + x180*x559 + x181*x559 + x210 + x240*x519 + x240*x522 + x240*x560 + x240*x561 + x242*x520 + x242*x524 + 2*x525 + x534*x58 + x534*x92 + x537*x70 + x537*x93 + x542*x82 + x542*x94 + 2*x543 + 2*x544 + x550*x551 + x552*x553 + x554*x555 + x562*x563 + x563*x564 + x563*x565, x142*x574 + x143*x573 + x145*x573 + x147*x573 + x150*x573 + x152*x573 + x154*x573 + x180*x574 + x181*x574 + x292*x519 + x292*x522 + x292*x560 + x292*x561 + x293*x520 + x293*x524 + x568*x58 + x568*x92 + x570*x70 + x570*x93 + x571*x82 + x571*x94 + x593, x180*x594 + x181*x594 + x315*x512 + x603, x142*x606 + x181*x606 + x206*x605 + x335*x512 + x612, x142*x613 + x180*x613 + x347*x512 + x620, x143*x633 + x145*x633 + x147*x633 + x150*x633 + x152*x633 + x154*x633 + x384*x519 + x384*x522 + x384*x560 + x384*x561 + x384*x634 + x384*x635 + x58*x622 + x622*x92 + x625*x70 + x625*x93 + x630*x82 + x630*x94 + x647, x143*x664 + x145*x664 + x147*x664 + x150*x664 + x152*x664 + x154*x664 + x428*x519 + x428*x522 + x428*x560 + x428*x561 + x428*x634 + x428*x635 + x58*x651 + x651*x92 + x655*x70 + x655*x93 + x660*x82 + x660*x94 + x674, x143*x689 + x145*x689 + x147*x689 + x150*x689 + x152*x689 + x154*x689 + x466*x519 + x466*x522 + x466*x560 + x466*x561 + x466*x634 + x466*x635 + x58*x678 + x678*x92 + x682*x70 + x682*x93 + x686*x82 + x686*x94 + x699, x113*x728 + x113*x731 + x142*x725 + x143*x721 + x145*x721 + x147*x721 + x150*x721 + x152*x721 + x154*x721 + x180*x725 + x181*x725 + x186*x732 + x187*x727 + x188*x729 + x188*x733 + x312 + x58*x710 + x70*x713 + x710*x92 + x713*x93 + x715*x82 + x715*x94, x142*x744 + x143*x743 + x145*x743 + x147*x743 + x150*x743 + x152*x743 + x154*x743 + x180*x744 + x181*x744 + x240*x728 + x240*x731 + x240*x745 + x240*x746 + x242*x729 + x242*x733 + x58*x736 + x593 + x70*x738 + x736*x92 + x738*x93 + x741*x82 + x741*x94, x142*x775 + x143*x766 + x145*x766 + x147*x766 + x150*x766 + x152*x766 + x154*x766 + x166*x772 + x168*x773 + x170*x774 + x172*x772 + x173*x773 + x174*x774 + x180*x775 + x181*x775 + x210 + x292*x728 + x292*x731 + x292*x745 + x292*x746 + x293*x729 + x293*x733 + x58*x755 + x583*x771 + x592*x777 + x70*x760 + 2*x747 + x755*x92 + x760*x93 + x761*x82 + x761*x94 + 2*x762 + 2*x763 + x767*x768 + x769*x770 + x776*x777 + x777*x778, x180*x779 + x181*x779 + x315*x724 + x787, x142*x788 + x181*x788 + x335*x724 + x793, x142*x796 + x180*x796 + x208*x795 + x347*x724 + x804, x143*x817 + x145*x817 + x147*x817 + x150*x817 + x152*x817 + x154*x817 + x384*x728 + x384*x731 + x384*x745 + x384*x746 + x384*x818 + x384*x819 + x58*x808 + x70*x812 + x808*x92 + x812*x93 + x815*x82 + x815*x94 + x831, x143*x842 + x145*x842 + x147*x842 + x150*x842 + x152*x842 + x154*x842 + x428*x728 + x428*x731 + x428*x745 + x428*x746 + x428*x818 + x428*x819 + x58*x836 + x70*x838 + x82*x840 + x836*x92 + x838*x93 + x840*x94 + x852, x143*x865 + x145*x865 + x147*x865 + x150*x865 + x152*x865 + x154*x865 + x466*x728 + x466*x731 + x466*x745 + x466*x746 + x466*x818 + x466*x819 + x58*x857 + x70*x860 + x82*x862 + x857*x92 + x860*x93 + x862*x94 + x875, x142*x877 + x180*x877 + x181*x877 + 2*x205 + x334, x142*x878 + x180*x878 + x181*x878 + x603, x142*x879 + x180*x879 + x181*x879 + x787, x180*x885 + x181*x885 - x314*x98 + x315*x876 + x324*x884 - x880*x881 + x886*x887 + x886*x888 + x895, x142*x897 + x181*x897 + x191*x898 + x335*x876 + x884*x896 + x888*x898 + x901, x142*x903 + x180*x903 + x191*x904 + x347*x876 + x884*x902 + x887*x904 + x907, x191*x908 + x887*x908 + x888*x908 + 2*x889 + x916, x191*x917 + x887*x917 + x888*x917 + x922, x191*x923 + x887*x923 + x888*x923 + x928, x142*x930 + x180*x930 + x181*x930 + x346, x142*x931 + x180*x931 + x181*x931 + 2*x207 + x612, x142*x932 + x180*x932 + x181*x932 + x793, x180*x935 + x181*x935 + x315*x929 + x324*x934 + x887*x936 + x888*x936 + x901, x142*x938 + x181*x938 + x191*x939 - x206*x605 + x335*x929 + x888*x939 - x890*x937 + x895 + x896*x934, x142*x940 + x180*x940 + x191*x941 + x347*x929 + x887*x941 + x902*x934 + x944, x191*x945 + x887*x945 + x888*x945 + x952, x191*x953 + x887*x953 + x888*x953 + 2*x891 + x959, x191*x960 + x887*x960 + x888*x960 + x966, x142*x968 + x180*x968 + x181*x968 + x359, x142*x969 + x180*x969 + x181*x969 + x620, x142*x970 + x180*x970 + x181*x970 + 2*x209 + x804, x180*x973 + x181*x973 + x315*x967 + x324*x972 + x887*x974 + x888*x974 + x907, x142*x975 + x181*x975 + x191*x976 + x335*x967 + x888*x976 + x896*x972 + x944, x142*x978 + x180*x978 + x191*x979 - x208*x795 + x347*x967 + x887*x979 - x892*x977 + x895 + x902*x972, x191*x980 + x887*x980 + x888*x980 + x989, x191*x990 + x887*x990 + x888*x990 + x995, x1001 + x191*x996 + x887*x996 + x888*x996 + 2*x893, x1008*x58 + x1008*x92 + x1013*x70 + x1013*x93 + x1015*x82 + x1015*x94 + x1021*x143 + x1021*x145 + x1021*x147 + x1021*x150 + x1021*x152 + x1021*x154 + x1023*x187 + x1024*x113 + x1025*x188 + x1026*x1028 + x1027*x113 + x1029*x188 + x407, x1024*x240 + x1025*x242 + x1027*x240 + x1029*x242 + x1032*x58 + x1032*x92 + x1035*x70 + x1035*x93 + x1038*x82 + x1038*x94 + x1040*x143 + x1040*x145 + x1040*x147 + x1040*x150 + x1040*x152 + x1040*x154 + x1041*x240 + x1042*x240 + x647, x1024*x292 + x1025*x293 + x1027*x292 + x1029*x293 + x1041*x292 + x1042*x292 + x1045*x58 + x1045*x92 + x1047*x70 + x1047*x93 + x1048*x82 + x1048*x94 + x1049*x143 + x1049*x145 + x1049*x147 + x1049*x150 + x1049*x152 + x1049*x154 + x831, x1050*x324 + x1051*x887 + x1051*x888 + x880*x881 + x916, x1050*x896 + x1052*x191 + x1052*x888 + x952, x1050*x902 + x1053*x191 + x1053*x887 + x989, x1024*x384 + x1027*x384 + x1041*x384 + x1042*x384 + x1055*x58 + x1055*x92 + x1058*x70 + x1058*x93 + x1061*x82 + x1061*x94 + x1062*x143 + x1062*x145 + x1062*x147 + x1062*x150 + x1062*x152 + x1062*x154 + x1064*x166 + x1064*x172 + x1065*x168 + x1065*x173 + x1066*x170 + x1066*x174 + 2*x1067*x388 + 2*x1068*x392 + 2*x1070*x394 + x1071*x384 + x1072*x191 + x1072*x887 + x1072*x888 + x1073*x384 + x1074*x1075 + x1075*x1078 + 2*x1076*x951 + x894 + 2*x909 + 2*x910 + 2*x911, x1024*x428 + x1027*x428 + x1041*x428 + x1042*x428 + x1071*x428 + x1073*x428 + x1082*x58 + x1082*x92 + x1084*x70 + x1084*x93 + x1087*x82 + x1087*x94 + x1089*x143 + x1089*x145 + x1089*x147 + x1089*x150 + x1089*x152 + x1089*x154 + x1090*x191 + x1090*x887 + x1090*x888 + x1103, x1024*x466 + x1027*x466 + x1041*x466 + x1042*x466 + x1071*x466 + x1073*x466 + x1106*x58 + x1106*x92 + x1112*x70 + x1112*x93 + x1115*x82 + x1115*x94 + x1118*x143 + x1118*x145 + x1118*x147 + x1118*x150 + x1118*x152 + x1118*x154 + x1119*x191 + x1119*x887 + x1119*x888 + x1126, x1028*x1149 + x113*x1147 + x113*x1150 + x1133*x58 + x1133*x92 + x1136*x70 + x1136*x93 + x1138*x82 + x1138*x94 + x1144*x143 + x1144*x145 + x1144*x147 + x1144*x150 + x1144*x152 + x1144*x154 + x1146*x187 + x1148*x188 + x1151*x188 + x447, x1147*x240 + x1148*x242 + x1150*x240 + x1151*x242 + x1155*x58 + x1155*x92 + x1158*x70 + x1158*x93 + x1162*x82 + x1162*x94 + x1164*x143 + x1164*x145 + x1164*x147 + x1164*x150 + x1164*x152 + x1164*x154 + x1165*x240 + x1166*x240 + x674, x1147*x292 + x1148*x293 + x1150*x292 + x1151*x293 + x1165*x292 + x1166*x292 + x1169*x58 + x1169*x92 + x1171*x70 + x1171*x93 + x1172*x82 + x1172*x94 + x1173*x143 + x1173*x145 + x1173*x147 + x1173*x150 + x1173*x152 + x1173*x154 + x852, x1174*x324 + x1175*x887 + x1175*x888 + x922, x1174*x896 + x1176*x191 + x1176*x888 + x890*x937 + x959, x1174*x902 + x1177*x191 + x1177*x887 + x995, x1103 + x1147*x384 + x1150*x384 + x1165*x384 + x1166*x384 + x1181*x58 + x1181*x92 + x1183*x70 + x1183*x93 + x1185*x82 + x1185*x94 + x1186*x143 + x1186*x145 + x1186*x147 + x1186*x150 + x1186*x152 + x1186*x154 + x1187*x384 + x1188*x191 + x1188*x887 + x1188*x888 + x1189*x384, x1147*x428 + x1150*x428 + x1165*x428 + x1166*x428 + x1187*x428 + x1189*x428 + x1194*x58 + x1194*x92 + x1197*x70 + x1197*x93 + x1199*x82 + x1199*x94 + x1200*x143 + x1200*x145 + x1200*x147 + x1200*x150 + x1200*x152 + x1200*x154 + x1202*x166 + x1202*x172 + x1203*x168 + x1203*x173 + x1204*x170 + x1204*x174 + 2*x1205*x430 + 2*x1206*x434 + 2*x1207*x436 + x1208*x191 + x1208*x887 + x1208*x888 + x1209*x1210 + x1210*x1212 + 2*x1211*x958 + x894 + 2*x954 + 2*x955 + 2*x956, x1147*x466 + x1150*x466 + x1165*x466 + x1166*x466 + x1187*x466 + x1189*x466 + x1216*x58 + x1216*x92 + x1219*x70 + x1219*x93 + x1221*x82 + x1221*x94 + x1223*x143 + x1223*x145 + x1223*x147 + x1223*x150 + x1223*x152 + x1223*x154 + x1224*x191 + x1224*x887 + x1224*x888 + x1237, x1028*x1260 + x113*x1258 + x113*x1261 + x1244*x58 + x1244*x92 + x1247*x70 + x1247*x93 + x1249*x82 + x1249*x94 + x1255*x143 + x1255*x145 + x1255*x147 + x1255*x150 + x1255*x152 + x1255*x154 + x1257*x187 + x1259*x188 + x1262*x188 + x485, x1258*x240 + x1259*x242 + x1261*x240 + x1262*x242 + x1265*x58 + x1265*x92 + x1268*x70 + x1268*x93 + x1271*x82 + x1271*x94 + x1273*x143 + x1273*x145 + x1273*x147 + x1273*x150 + x1273*x152 + x1273*x154 + x1274*x240 + x1275*x240 + x699, x1258*x292 + x1259*x293 + x1261*x292 + x1262*x293 + x1274*x292 + x1275*x292 + x1280*x58 + x1280*x92 + x1282*x70 + x1282*x93 + x1283*x82 + x1283*x94 + x1284*x143 + x1284*x145 + x1284*x147 + x1284*x150 + x1284*x152 + x1284*x154 + x875, x1285*x324 + x1286*x887 + x1286*x888 + x928, x1285*x896 + x1287*x191 + x1287*x888 + x966, x1001 + x1285*x902 + x1288*x191 + x1288*x887 + x892*x977, x1126 + x1258*x384 + x1261*x384 + x1274*x384 + x1275*x384 + x1291*x58 + x1291*x92 + x1295*x70 + x1295*x93 + x1298*x82 + x1298*x94 + x1299*x143 + x1299*x145 + x1299*x147 + x1299*x150 + x1299*x152 + x1299*x154 + x1300*x384 + x1301*x191 + x1301*x887 + x1301*x888 + x1302*x384, x1237 + x1258*x428 + x1261*x428 + x1274*x428 + x1275*x428 + x1300*x428 + x1302*x428 + x1305*x58 + x1305*x92 + x1308*x70 + x1308*x93 + x1310*x82 + x1310*x94 + x1311*x143 + x1311*x145 + x1311*x147 + x1311*x150 + x1311*x152 + x1311*x154 + x1312*x191 + x1312*x887 + x1312*x888, 2*x1231*x468 + 2*x1232*x472 + 2*x1233*x474 + x1234*x1327 + 2*x1235*x965 + x1236*x1327 + x1258*x466 + x1261*x466 + x1274*x466 + x1275*x466 + x1300*x466 + x1302*x466 + x1315*x58 + x1315*x92 + x1318*x70 + x1318*x93 + x1320*x82 + x1320*x94 + x1321*x143 + x1321*x145 + x1321*x147 + x1321*x150 + x1321*x152 + x1321*x154 + x1323*x166 + x1323*x172 + x1324*x168 + x1324*x173 + x1325*x170 + x1325*x174 + x1326*x191 + x1326*x887 + x1326*x888 + x894 + 2*x997 + 2*x998 + 2*x999], dtype=np.float64)


