import numpy

from pysisyphus.wavefunction.ints.boys import boys


def _2center2el3d_00(a, A, b, B):
    """Cartesian (s|s) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b

    # 1 item(s)
    return numpy.array(
        [
            34.9868366552497
            * x0 ** (-0.5)
            * boys(
                0,
                a
                * b
                * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
                / x0,
            )
            / (a * b)
        ]
    )


def _2center2el3d_01(a, A, b, B):
    """Cartesian (s|p) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = (
        34.9868366552497
        * x0 ** (-0.5)
        * boys(
            1, a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        / (a * b)
    )

    # 3 item(s)
    return numpy.array(
        [
            x2 * (x1 * (a * A[0] + b * B[0]) - B[0]),
            x2 * (x1 * (a * A[1] + b * B[1]) - B[1]),
            x2 * (x1 * (a * A[2] + b * B[2]) - B[2]),
        ]
    )


def _2center2el3d_02(a, A, b, B):
    """Cartesian (s|d) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = b ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x4 = 17.4934183276249
    x5 = 2.0 * x0 * x4
    x6 = a ** (-1.0)
    x7 = x1 ** (-0.5)
    x8 = (
        0.5
        * x0
        * (2.0 * x0 * x4 * x6 * x7 * boys(0, x3) - x1 ** (-1.5) * x5 * boys(1, x3))
    )
    x9 = x2 * (a * A[0] + b * B[0]) - B[0]
    x10 = x5 * x6 * x7 * boys(2, x3)
    x11 = x2 * (a * A[1] + b * B[1]) - B[1]
    x12 = x10 * x9
    x13 = x2 * (a * A[2] + b * B[2]) - B[2]

    # 6 item(s)
    return numpy.array(
        [
            x10 * x9**2 + x8,
            x11 * x12,
            x12 * x13,
            x10 * x11**2 + x8,
            x10 * x11 * x13,
            x10 * x13**2 + x8,
        ]
    )


def _2center2el3d_03(a, A, b, B):
    """Cartesian (s|f) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = b ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = x2 * (a * A[0] + b * B[0]) - B[0]
    x4 = a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x5 = 17.4934183276249
    x6 = 2.0 * x0 * x5
    x7 = x1 ** (-1.5) * x6 * boys(2, x4)
    x8 = a ** (-1.0)
    x9 = x1 ** (-0.5)
    x10 = boys(1, x4)
    x11 = 0.5 * x0 * (2.0 * x0 * x10 * x5 * x8 * x9 - x7)
    x12 = x6 * x8 * x9 * boys(3, x4)
    x13 = x12 * x3**2
    x14 = x2 * (a * A[1] + b * B[1]) - B[1]
    x15 = x0 * (2.0 * x0 * x10 * x14 * x5 * x8 * x9 - x14 * x7)
    x16 = x2 * (a * A[2] + b * B[2]) - B[2]
    x17 = x0 * (2.0 * x0 * x10 * x16 * x5 * x8 * x9 - x16 * x7)
    x18 = 0.5 * x17
    x19 = x12 * x14**2
    x20 = x11 + x19
    x21 = x11 + x12 * x16**2

    # 10 item(s)
    return numpy.array(
        [
            x0 * (2.0 * x0 * x10 * x3 * x5 * x8 * x9 - x3 * x7) + x3 * (x11 + x13),
            x13 * x14 + 0.5 * x15,
            x13 * x16 + x18,
            x20 * x3,
            x12 * x14 * x16 * x3,
            x21 * x3,
            x14 * x20 + x15,
            x16 * x19 + x18,
            x14 * x21,
            x16 * x21 + x17,
        ]
    )


def _2center2el3d_04(a, A, b, B):
    """Cartesian (s|g) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - B[0]
    x3 = b ** (-1.0)
    x4 = a * x1
    x5 = b * x4 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x6 = boys(3, x5)
    x7 = 17.4934183276249
    x8 = 2.0 * x3 * x7
    x9 = x0 ** (-1.5) * x8
    x10 = x6 * x9
    x11 = x10 * x2
    x12 = a ** (-1.0)
    x13 = x0 ** (-0.5)
    x14 = boys(2, x5)
    x15 = 0.5 * x3
    x16 = x15 * (-x10 + 2.0 * x12 * x13 * x14 * x3 * x7)
    x17 = boys(4, x5)
    x18 = x2**2
    x19 = x12 * x13 * x8
    x20 = x18 * x19
    x21 = x17 * x20
    x22 = boys(1, x5)
    x23 = x15 * (2.0 * x12 * x13 * x3 * x7 * boys(0, x5) - x22 * x9)
    x24 = x15 * (2.0 * x12 * x13 * x22 * x3 * x7 - x14 * x9)
    x25 = x14 * x19
    x26 = 1.5 * x3
    x27 = x1 * (a * A[1] + b * B[1]) - B[1]
    x28 = x2 * x27
    x29 = x10 * x27
    x30 = x3 * (2.0 * x12 * x13 * x14 * x27 * x3 * x7 - x29)
    x31 = x21 * x27
    x32 = x1 * (a * A[2] + b * B[2]) - B[2]
    x33 = x3 * (-x10 * x32 + 2.0 * x12 * x13 * x14 * x3 * x32 * x7)
    x34 = 0.5 * x33
    x35 = x27**2
    x36 = x19 * x35
    x37 = x17 * x36
    x38 = x16 + x37
    x39 = x23 + x25 * x35 - x4 * (x24 + x36 * x6)
    x40 = x3 * (2.0 * x12 * x13 * x14 * x27 * x3 * x32 * x7 - x29 * x32)
    x41 = x32**2
    x42 = x19 * x41
    x43 = x16 + x17 * x42
    x44 = x23 + x25 * x41 - x4 * (x24 + x42 * x6)
    x45 = x15 * x44
    x46 = x27 * x38 + x30
    x47 = x32 * x37 + x34
    x48 = x32 * x43 + x33

    # 15 item(s)
    return numpy.array(
        [
            x2 * (x2 * (x16 + x21) + x3 * (-x11 + 2.0 * x12 * x13 * x14 * x2 * x3 * x7))
            + x26 * (x18 * x25 + x23 - x4 * (x20 * x6 + x24)),
            x2 * (0.5 * x30 + x31)
            + x3 * (-x10 * x28 + 2.0 * x12 * x13 * x14 * x2 * x27 * x3 * x7),
            x2 * (x21 * x32 + x34)
            + x3 * (-x11 * x32 + 2.0 * x12 * x13 * x14 * x2 * x3 * x32 * x7),
            x15 * x39 + x18 * x38,
            x31 * x32 + 0.5 * x40,
            x18 * x43 + x45,
            x2 * x46,
            x2 * x47,
            x28 * x43,
            x2 * x48,
            x26 * x39 + x27 * x46,
            x27 * x47 + x40,
            x35 * x43 + x45,
            x27 * x48,
            x26 * x44 + x32 * x48,
        ]
    )


def _2center2el3d_05(a, A, b, B):
    """Cartesian (s|h) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - B[0]
    x3 = b ** (-1.0)
    x4 = a * x1
    x5 = b * x4 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x6 = boys(4, x5)
    x7 = 17.4934183276249
    x8 = 2.0 * x3
    x9 = x7 * x8
    x10 = x0 ** (-1.5) * x9
    x11 = x10 * x6
    x12 = x11 * x2
    x13 = a ** (-1.0)
    x14 = x0 ** (-0.5)
    x15 = boys(3, x5)
    x16 = 0.5 * x3
    x17 = x16 * (-x11 + 2.0 * x13 * x14 * x15 * x3 * x7)
    x18 = boys(5, x5)
    x19 = x2**2
    x20 = x13 * x14 * x9
    x21 = x19 * x20
    x22 = x18 * x21
    x23 = x10 * x15
    x24 = boys(2, x5)
    x25 = x16 * (2.0 * x13 * x14 * x24 * x3 * x7 - x23)
    x26 = x21 * x6
    x27 = x25 + x26
    x28 = x10 * x24
    x29 = boys(1, x5)
    x30 = x16 * (2.0 * x13 * x14 * x29 * x3 * x7 - x28)
    x31 = x15 * x20
    x32 = x19 * x31
    x33 = x30 + x32
    x34 = 1.5 * x3
    x35 = x1 * (a * A[1] + b * B[1]) - B[1]
    x36 = x2 * x35
    x37 = x11 * x35
    x38 = x3 * (2.0 * x13 * x14 * x15 * x3 * x35 * x7 - x37)
    x39 = x22 * x35
    x40 = x3 * (2.0 * x13 * x14 * x29 * x3 * x35 * x7 - x28 * x35)
    x41 = x3 * (2.0 * x13 * x14 * x24 * x3 * x35 * x7 - x23 * x35)
    x42 = x1 * (a * A[2] + b * B[2]) - B[2]
    x43 = x11 * x42
    x44 = x3 * (2.0 * x13 * x14 * x15 * x3 * x42 * x7 - x43)
    x45 = 0.5 * x44
    x46 = x3 * (2.0 * x13 * x14 * x29 * x3 * x42 * x7 - x28 * x42)
    x47 = 0.5 * x46
    x48 = x3 * (2.0 * x13 * x14 * x24 * x3 * x42 * x7 - x23 * x42)
    x49 = 0.5 * x48
    x50 = x35**2
    x51 = x30 + x31 * x50
    x52 = x20 * x50
    x53 = x52 * x6
    x54 = x25 + x53
    x55 = x4 * x54
    x56 = x18 * x52
    x57 = x17 + x56
    x58 = x51 - x55
    x59 = x3 * (2.0 * x13 * x14 * x15 * x3 * x35 * x42 * x7 - x37 * x42)
    x60 = x42**2
    x61 = x30 + x31 * x60
    x62 = x20 * x60
    x63 = x25 + x6 * x62
    x64 = x4 * x63
    x65 = x17 + x18 * x62
    x66 = x19 * x65
    x67 = x61 - x64
    x68 = x16 * x67
    x69 = x35 * x57 + x38
    x70 = x35 * x51 - x4 * (x35 * x54 + x41) + x40
    x71 = x42 * x56 + x45
    x72 = x31 * x42 * x50 - x4 * (x42 * x53 + x49) + x47
    x73 = x3 * (x35 * x61 - x35 * x64)
    x74 = x42 * x65 + x44
    x75 = -x4 * (x42 * x63 + x48) + x42 * x61 + x46
    x76 = x16 * x75
    x77 = x34 * x58 + x35 * x69
    x78 = x35 * x71 + x59
    x79 = x50 * x65 + x68
    x80 = x34 * x67 + x42 * x74

    # 21 item(s)
    return numpy.array(
        [
            x2
            * (
                x2
                * (x2 * (x17 + x22) + x3 * (-x12 + 2.0 * x13 * x14 * x15 * x2 * x3 * x7))
                + x34 * (-x27 * x4 + x33)
            )
            + x8
            * (
                x2 * x33
                + x3 * (2.0 * x13 * x14 * x2 * x29 * x3 * x7 - x2 * x28)
                - x4 * (x2 * x27 + x3 * (2.0 * x13 * x14 * x2 * x24 * x3 * x7 - x2 * x23))
            ),
            x2
            * (
                x2 * (0.5 * x38 + x39)
                + x3 * (-x11 * x36 + 2.0 * x13 * x14 * x15 * x2 * x3 * x35 * x7)
            )
            + x34 * (x32 * x35 - x4 * (x26 * x35 + 0.5 * x41) + 0.5 * x40),
            x2
            * (
                x2 * (x22 * x42 + x45)
                + x3 * (-x12 * x42 + 2.0 * x13 * x14 * x15 * x2 * x3 * x42 * x7)
            )
            + x34 * (x32 * x42 - x4 * (x26 * x42 + x49) + x47),
            x2 * (x16 * x58 + x19 * x57) + x3 * (x2 * x51 - x2 * x55),
            x2 * (x39 * x42 + 0.5 * x59)
            + x3 * (2.0 * x13 * x14 * x15 * x2 * x3 * x35 * x42 * x7 - x36 * x43),
            x2 * (x66 + x68) + x3 * (x2 * x61 - x2 * x64),
            x16 * x70 + x19 * x69,
            x16 * x72 + x19 * x71,
            x35 * x66 + 0.5 * x73,
            x19 * x74 + x76,
            x2 * x77,
            x2 * x78,
            x2 * x79,
            x36 * x74,
            x2 * x80,
            x35 * x77 + x70 * x8,
            x34 * x72 + x35 * x78,
            x35 * x79 + x73,
            x50 * x74 + x76,
            x35 * x80,
            x42 * x80 + x75 * x8,
        ]
    )


def _2center2el3d_10(a, A, b, B):
    """Cartesian (p|s) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = (
        34.9868366552497
        * x0 ** (-0.5)
        * boys(
            1, a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        / (a * b)
    )

    # 3 item(s)
    return numpy.array(
        [
            x2 * (x1 * (a * A[0] + b * B[0]) - A[0]),
            x2 * (x1 * (a * A[1] + b * B[1]) - A[1]),
            x2 * (x1 * (a * A[2] + b * B[2]) - A[2]),
        ]
    )


def _2center2el3d_11(a, A, b, B):
    """Cartesian (p|p) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x3 = 34.9868366552497 * x0 ** (-0.5) / (a * b)
    x4 = x3 * boys(1, x2) / (2.0 * a + 2.0 * b)
    x5 = -x1 * (a * A[0] + b * B[0])
    x6 = -x5 - B[0]
    x7 = x3 * boys(2, x2)
    x8 = x7 * (-x5 - A[0])
    x9 = -x1 * (a * A[1] + b * B[1])
    x10 = -x9 - B[1]
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - B[2]
    x13 = x7 * (-x9 - A[1])
    x14 = x7 * (-x11 - A[2])

    # 9 item(s)
    return numpy.array(
        [
            x4 + x6 * x8,
            x10 * x8,
            x12 * x8,
            x13 * x6,
            x10 * x13 + x4,
            x12 * x13,
            x14 * x6,
            x10 * x14,
            x12 * x14 + x4,
        ]
    )


def _2center2el3d_12(a, A, b, B):
    """Cartesian (p|d) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = b ** (-1.0)
    x5 = a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x6 = boys(2, x5)
    x7 = 17.4934183276249
    x8 = 2.0 * x4 * x7
    x9 = x6 * x8
    x10 = a ** (-1.0)
    x11 = x0 ** (-0.5)
    x12 = 0.5 * x4 * (-(x0 ** (-1.5)) * x9 + 2.0 * x10 * x11 * x4 * x7 * boys(1, x5))
    x13 = -x2 - B[0]
    x14 = x10 * x11
    x15 = x14 * x8 * boys(3, x5)
    x16 = x12 + x13**2 * x15
    x17 = x14 / (2.0 * a + 2.0 * b)
    x18 = x13 * x17
    x19 = 4.0 * x4 * x6 * x7
    x20 = -x1 * (a * A[1] + b * B[1])
    x21 = -x20 - B[1]
    x22 = x17 * x9
    x23 = x21 * x22
    x24 = x13 * x15
    x25 = x24 * x3
    x26 = -x1 * (a * A[2] + b * B[2])
    x27 = -x26 - B[2]
    x28 = x22 * x27
    x29 = x12 + x15 * x21**2
    x30 = x15 * x21 * x27
    x31 = x12 + x15 * x27**2
    x32 = -x20 - A[1]
    x33 = x18 * x9
    x34 = x24 * x32
    x35 = x17 * x19
    x36 = -x26 - A[2]
    x37 = x24 * x36

    # 18 item(s)
    return numpy.array(
        [
            x16 * x3 + x18 * x19,
            x21 * x25 + x23,
            x25 * x27 + x28,
            x29 * x3,
            x3 * x30,
            x3 * x31,
            x16 * x32,
            x21 * x34 + x33,
            x27 * x34,
            x21 * x35 + x29 * x32,
            x28 + x30 * x32,
            x31 * x32,
            x16 * x36,
            x21 * x37,
            x27 * x37 + x33,
            x29 * x36,
            x23 + x30 * x36,
            x27 * x35 + x31 * x36,
        ]
    )


def _2center2el3d_13(a, A, b, B):
    """Cartesian (p|f) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = b ** (-1.0)
    x5 = -x2 - B[0]
    x6 = a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x7 = boys(3, x6)
    x8 = 17.4934183276249
    x9 = 2.0 * x4 * x8
    x10 = x0 ** (-1.5) * x9
    x11 = x10 * x7
    x12 = a ** (-1.0)
    x13 = x0 ** (-0.5)
    x14 = boys(2, x6)
    x15 = 0.5 * x4
    x16 = x15 * (-x11 + 2.0 * x12 * x13 * x14 * x4 * x8)
    x17 = boys(4, x6)
    x18 = x12 * x13
    x19 = x18 * x9
    x20 = x19 * x5**2
    x21 = x17 * x20
    x22 = x4 * (-x11 * x5 + 2.0 * x12 * x13 * x14 * x4 * x5 * x8) + x5 * (x16 + x21)
    x23 = (2.0 * a + 2.0 * b) ** (-1.0)
    x24 = x15 * (-x10 * x14 + 2.0 * x12 * x13 * x4 * x8 * boys(1, x6))
    x25 = x23 * (x20 * x7 + x24)
    x26 = -x1 * (a * A[1] + b * B[1])
    x27 = -x26 - B[1]
    x28 = x4 * (-x11 * x27 + 2.0 * x12 * x13 * x14 * x27 * x4 * x8)
    x29 = x21 * x27 + 0.5 * x28
    x30 = x23 * x27 * x7
    x31 = x30 * x5
    x32 = 4.0 * x18 * x4 * x8
    x33 = x31 * x32
    x34 = -x1 * (a * A[2] + b * B[2])
    x35 = -x34 - B[2]
    x36 = x4 * (-x11 * x35 + 2.0 * x12 * x13 * x14 * x35 * x4 * x8)
    x37 = 0.5 * x36
    x38 = x21 * x35 + x37
    x39 = x32 * x35
    x40 = x23 * x5 * x7
    x41 = x39 * x40
    x42 = x19 * x27**2
    x43 = x23 * (x24 + x42 * x7)
    x44 = x17 * x42
    x45 = x16 + x44
    x46 = x3 * x5
    x47 = x19 * x35
    x48 = x17 * x27 * x47
    x49 = x19 * x35**2
    x50 = x23 * (x24 + x49 * x7)
    x51 = x16 + x17 * x49
    x52 = x27 * x45 + x28
    x53 = x35 * x44 + x37
    x54 = x27 * x51
    x55 = x35 * x51 + x36
    x56 = -x26 - A[1]
    x57 = x5 * x56
    x58 = x30 * x39
    x59 = -x34 - A[2]
    x60 = x5 * x59

    # 30 item(s)
    return numpy.array(
        [
            x22 * x3 + 3.0 * x25,
            x29 * x3 + x33,
            x3 * x38 + x41,
            x43 + x45 * x46,
            x30 * x47 + x46 * x48,
            x46 * x51 + x50,
            x3 * x52,
            x3 * x53,
            x3 * x54,
            x3 * x55,
            x22 * x56,
            x25 + x29 * x56,
            x38 * x56,
            x33 + x45 * x57,
            x40 * x47 + x48 * x57,
            x51 * x57,
            3.0 * x43 + x52 * x56,
            x53 * x56 + x58,
            x50 + x54 * x56,
            x55 * x56,
            x22 * x59,
            x29 * x59,
            x25 + x38 * x59,
            x45 * x60,
            x19 * x31 + x48 * x60,
            x41 + x51 * x60,
            x52 * x59,
            x43 + x53 * x59,
            x54 * x59 + x58,
            3.0 * x50 + x55 * x59,
        ]
    )


def _2center2el3d_14(a, A, b, B):
    """Cartesian (p|g) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = -x2 - B[0]
    x5 = b ** (-1.0)
    x6 = a * x1
    x7 = b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x8 = boys(4, x7)
    x9 = 17.4934183276249
    x10 = 2.0 * x5 * x9
    x11 = x0 ** (-1.5) * x10
    x12 = x11 * x8
    x13 = x12 * x4
    x14 = a ** (-1.0)
    x15 = x0 ** (-0.5)
    x16 = boys(3, x7)
    x17 = 0.5 * x5
    x18 = x17 * (-x12 + 2.0 * x14 * x15 * x16 * x5 * x9)
    x19 = boys(5, x7)
    x20 = x4**2
    x21 = x14 * x15
    x22 = x10 * x21
    x23 = x20 * x22
    x24 = x19 * x23
    x25 = boys(2, x7)
    x26 = x17 * (-x11 * x25 + 2.0 * x14 * x15 * x5 * x9 * boys(1, x7))
    x27 = x11 * x16
    x28 = x17 * (2.0 * x14 * x15 * x25 * x5 * x9 - x27)
    x29 = x23 * x8
    x30 = x28 + x29
    x31 = x16 * x22
    x32 = 1.5 * x5
    x33 = x32 * (x20 * x31 + x26 - x30 * x6) + x4 * (
        x4 * (x18 + x24) + x5 * (-x13 + 2.0 * x14 * x15 * x16 * x4 * x5 * x9)
    )
    x34 = (2.0 * a + 2.0 * b) ** (-1.0)
    x35 = x34 * (x30 * x4 + x5 * (2.0 * x14 * x15 * x25 * x4 * x5 * x9 - x27 * x4))
    x36 = -x1 * (a * A[1] + b * B[1])
    x37 = -x36 - B[1]
    x38 = x12 * x37
    x39 = x5 * (2.0 * x14 * x15 * x16 * x37 * x5 * x9 - x38)
    x40 = x24 * x37
    x41 = x4 * (0.5 * x39 + x40) + x5 * (
        -x13 * x37 + 2.0 * x14 * x15 * x16 * x37 * x4 * x5 * x9
    )
    x42 = x5 * (2.0 * x14 * x15 * x25 * x37 * x5 * x9 - x27 * x37)
    x43 = x34 * (x29 * x37 + 0.5 * x42)
    x44 = -x1 * (a * A[2] + b * B[2])
    x45 = -x44 - B[2]
    x46 = x5 * (-x12 * x45 + 2.0 * x14 * x15 * x16 * x45 * x5 * x9)
    x47 = 0.5 * x46
    x48 = x4 * (x24 * x45 + x47) + x5 * (
        -x13 * x45 + 2.0 * x14 * x15 * x16 * x4 * x45 * x5 * x9
    )
    x49 = x5 * (2.0 * x14 * x15 * x25 * x45 * x5 * x9 - x27 * x45)
    x50 = 0.5 * x49
    x51 = x34 * (x29 * x45 + x50)
    x52 = x37**2
    x53 = x22 * x52
    x54 = x19 * x53
    x55 = x18 + x54
    x56 = x53 * x8
    x57 = x28 + x56
    x58 = x26 + x31 * x52 - x57 * x6
    x59 = x17 * x58 + x20 * x55
    x60 = x34 * x4
    x61 = x57 * x60
    x62 = x5 * (2.0 * x14 * x15 * x16 * x37 * x45 * x5 * x9 - x38 * x45)
    x63 = x40 * x45 + 0.5 * x62
    x64 = 4.0 * x21 * x37 * x45 * x5 * x60 * x8 * x9
    x65 = x45**2
    x66 = x22 * x65
    x67 = x18 + x19 * x66
    x68 = x28 + x66 * x8
    x69 = x26 + x31 * x65 - x6 * x68
    x70 = x17 * x69
    x71 = x20 * x67 + x70
    x72 = x34 * x68
    x73 = x4 * x72
    x74 = x34 * (x37 * x57 + x42)
    x75 = x37 * x55 + x39
    x76 = x3 * x4
    x77 = x34 * (x45 * x56 + x50)
    x78 = x45 * x54 + x47
    x79 = x37 * x72
    x80 = x37 * x67
    x81 = x34 * (x45 * x68 + x49)
    x82 = x45 * x67 + x46
    x83 = x32 * x58 + x37 * x75
    x84 = x37 * x78 + x62
    x85 = x52 * x67 + x70
    x86 = x37 * x82
    x87 = x32 * x69 + x45 * x82
    x88 = -x36 - A[1]
    x89 = x4 * x88
    x90 = -x44 - A[2]
    x91 = x4 * x90

    # 45 item(s)
    return numpy.array(
        [
            x3 * x33 + 4.0 * x35,
            x3 * x41 + 3.0 * x43,
            x3 * x48 + 3.0 * x51,
            x3 * x59 + 2.0 * x61,
            x3 * x63 + x64,
            x3 * x71 + 2.0 * x73,
            x74 + x75 * x76,
            x76 * x78 + x77,
            x76 * x80 + x79,
            x76 * x82 + x81,
            x3 * x83,
            x3 * x84,
            x3 * x85,
            x3 * x86,
            x3 * x87,
            x33 * x88,
            x35 + x41 * x88,
            x48 * x88,
            2.0 * x43 + x59 * x88,
            x51 + x63 * x88,
            x71 * x88,
            3.0 * x61 + x75 * x89,
            x64 + x78 * x89,
            x73 + x80 * x89,
            x82 * x89,
            4.0 * x74 + x83 * x88,
            3.0 * x77 + x84 * x88,
            2.0 * x79 + x85 * x88,
            x81 + x86 * x88,
            x87 * x88,
            x33 * x90,
            x41 * x90,
            x35 + x48 * x90,
            x59 * x90,
            x43 + x63 * x90,
            2.0 * x51 + x71 * x90,
            x75 * x91,
            x61 + x78 * x91,
            x64 + x80 * x91,
            3.0 * x73 + x82 * x91,
            x83 * x90,
            x74 + x84 * x90,
            2.0 * x77 + x85 * x90,
            3.0 * x79 + x86 * x90,
            4.0 * x81 + x87 * x90,
        ]
    )


def _2center2el3d_15(a, A, b, B):
    """Cartesian (p|h) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = -x2 - B[0]
    x5 = b ** (-1.0)
    x6 = a * x1
    x7 = b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x8 = boys(5, x7)
    x9 = 17.4934183276249
    x10 = 2.0 * x5
    x11 = x10 * x9
    x12 = x0 ** (-1.5) * x11
    x13 = x12 * x8
    x14 = x13 * x4
    x15 = a ** (-1.0)
    x16 = x0 ** (-0.5)
    x17 = boys(4, x7)
    x18 = 0.5 * x5
    x19 = x18 * (-x13 + 2.0 * x15 * x16 * x17 * x5 * x9)
    x20 = boys(6, x7)
    x21 = x4**2
    x22 = x11 * x15 * x16
    x23 = x21 * x22
    x24 = x20 * x23
    x25 = x12 * x17
    x26 = boys(3, x7)
    x27 = x18 * (2.0 * x15 * x16 * x26 * x5 * x9 - x25)
    x28 = x23 * x8
    x29 = x27 + x28
    x30 = x12 * x26
    x31 = boys(2, x7)
    x32 = x18 * (2.0 * x15 * x16 * x31 * x5 * x9 - x30)
    x33 = x17 * x22
    x34 = x21 * x33
    x35 = x32 + x34
    x36 = 1.5 * x5
    x37 = x25 * x4
    x38 = x29 * x4 + x5 * (2.0 * x15 * x16 * x26 * x4 * x5 * x9 - x37)
    x39 = x10 * (
        x35 * x4 - x38 * x6 + x5 * (2.0 * x15 * x16 * x31 * x4 * x5 * x9 - x30 * x4)
    ) + x4 * (
        x36 * (-x29 * x6 + x35)
        + x4 * (x4 * (x19 + x24) + x5 * (-x14 + 2.0 * x15 * x16 * x17 * x4 * x5 * x9))
    )
    x40 = (2.0 * a + 2.0 * b) ** (-1.0)
    x41 = x18 * (-x12 * x31 + 2.0 * x15 * x16 * x5 * x9 * boys(1, x7))
    x42 = x22 * x26
    x43 = x40 * (x36 * (x21 * x42 - x35 * x6 + x41) + x38 * x4)
    x44 = -x1 * (a * A[1] + b * B[1])
    x45 = -x44 - B[1]
    x46 = x14 * x45
    x47 = x13 * x45
    x48 = x5 * (2.0 * x15 * x16 * x17 * x45 * x5 * x9 - x47)
    x49 = x24 * x45
    x50 = x5 * (2.0 * x15 * x16 * x31 * x45 * x5 * x9 - x30 * x45)
    x51 = x25 * x45
    x52 = x5 * (2.0 * x15 * x16 * x26 * x45 * x5 * x9 - x51)
    x53 = x28 * x45
    x54 = 0.5 * x52 + x53
    x55 = x36 * (x34 * x45 + 0.5 * x50 - x54 * x6) + x4 * (
        x4 * (0.5 * x48 + x49) + x5 * (2.0 * x15 * x16 * x17 * x4 * x45 * x5 * x9 - x46)
    )
    x56 = x40 * (x4 * x54 + x5 * (2.0 * x15 * x16 * x26 * x4 * x45 * x5 * x9 - x37 * x45))
    x57 = -x1 * (a * A[2] + b * B[2])
    x58 = -x57 - B[2]
    x59 = x5 * (-x13 * x58 + 2.0 * x15 * x16 * x17 * x5 * x58 * x9)
    x60 = 0.5 * x59
    x61 = x5 * (2.0 * x15 * x16 * x31 * x5 * x58 * x9 - x30 * x58)
    x62 = 0.5 * x61
    x63 = x5 * (2.0 * x15 * x16 * x26 * x5 * x58 * x9 - x25 * x58)
    x64 = 0.5 * x63
    x65 = x28 * x58 + x64
    x66 = x36 * (x34 * x58 - x6 * x65 + x62) + x4 * (
        x4 * (x24 * x58 + x60)
        + x5 * (-x14 * x58 + 2.0 * x15 * x16 * x17 * x4 * x5 * x58 * x9)
    )
    x67 = x40 * (x4 * x65 + x5 * (2.0 * x15 * x16 * x26 * x4 * x5 * x58 * x9 - x37 * x58))
    x68 = x45**2
    x69 = x32 + x33 * x68
    x70 = x22 * x68
    x71 = x70 * x8
    x72 = x27 + x71
    x73 = x6 * x72
    x74 = x20 * x70
    x75 = x19 + x74
    x76 = x69 - x73
    x77 = x4 * (x18 * x76 + x21 * x75) + x5 * (x4 * x69 - x4 * x73)
    x78 = x41 + x42 * x68 - x6 * x69
    x79 = x40 * (x18 * x78 + x21 * x72)
    x80 = 3.0 * x79
    x81 = x5 * (2.0 * x15 * x16 * x17 * x45 * x5 * x58 * x9 - x47 * x58)
    x82 = x4 * (x49 * x58 + 0.5 * x81) + x5 * (
        2.0 * x15 * x16 * x17 * x4 * x45 * x5 * x58 * x9 - x46 * x58
    )
    x83 = x5 * (2.0 * x15 * x16 * x26 * x45 * x5 * x58 * x9 - x51 * x58)
    x84 = x40 * (x53 * x58 + 0.5 * x83)
    x85 = x58**2
    x86 = x32 + x33 * x85
    x87 = x22 * x85
    x88 = x27 + x8 * x87
    x89 = x6 * x88
    x90 = x19 + x20 * x87
    x91 = x21 * x90
    x92 = x86 - x89
    x93 = x18 * x92
    x94 = x4 * (x91 + x93) + x5 * (x4 * x86 - x4 * x89)
    x95 = x41 + x42 * x85 - x6 * x86
    x96 = x18 * x95
    x97 = x40 * (x21 * x88 + x96)
    x98 = 3.0 * x97
    x99 = x45 * x75 + x48
    x100 = x45 * x72 + x52
    x101 = -x100 * x6 + x45 * x69 + x50
    x102 = x101 * x18 + x21 * x99
    x103 = x4 * x40
    x104 = x100 * x103
    x105 = x58 * x74 + x60
    x106 = x58 * x71 + x64
    x107 = -x106 * x6 + x33 * x58 * x68 + x62
    x108 = x105 * x21 + x107 * x18
    x109 = x103 * x106
    x110 = 2.0 * x109
    x111 = x5 * (x45 * x86 - x45 * x89)
    x112 = 0.5 * x111 + x45 * x91
    x113 = x103 * x45 * x88
    x114 = 2.0 * x113
    x115 = x58 * x90 + x59
    x116 = x58 * x88 + x63
    x117 = -x116 * x6 + x58 * x86 + x61
    x118 = x117 * x18
    x119 = x115 * x21 + x118
    x120 = x116 * x40
    x121 = x120 * x4
    x122 = x40 * (x100 * x45 + x36 * x78)
    x123 = x36 * x76 + x45 * x99
    x124 = x3 * x4
    x125 = x40 * (x106 * x45 + x83)
    x126 = x105 * x45 + x81
    x127 = x40 * (x68 * x88 + x96)
    x128 = x68 * x90 + x93
    x129 = x120 * x45
    x130 = x115 * x45
    x131 = x40 * (x116 * x58 + x36 * x95)
    x132 = x115 * x58 + x36 * x92
    x133 = x10 * x101 + x123 * x45
    x134 = x107 * x36 + x126 * x45
    x135 = x111 + x128 * x45
    x136 = x115 * x68 + x118
    x137 = x132 * x45
    x138 = x10 * x117 + x132 * x58
    x139 = -x44 - A[1]
    x140 = 2.0 * x84
    x141 = x139 * x4
    x142 = 3.0 * x127
    x143 = -x57 - A[2]
    x144 = x143 * x4

    # 63 item(s)
    return numpy.array(
        [
            x3 * x39 + 5.0 * x43,
            x3 * x55 + 4.0 * x56,
            x3 * x66 + 4.0 * x67,
            x3 * x77 + x80,
            x3 * x82 + 3.0 * x84,
            x3 * x94 + x98,
            x102 * x3 + 2.0 * x104,
            x108 * x3 + x110,
            x112 * x3 + x114,
            x119 * x3 + 2.0 * x121,
            x122 + x123 * x124,
            x124 * x126 + x125,
            x124 * x128 + x127,
            x124 * x130 + x129,
            x124 * x132 + x131,
            x133 * x3,
            x134 * x3,
            x135 * x3,
            x136 * x3,
            x137 * x3,
            x138 * x3,
            x139 * x39,
            x139 * x55 + x43,
            x139 * x66,
            x139 * x77 + 2.0 * x56,
            x139 * x82 + x67,
            x139 * x94,
            x102 * x139 + x80,
            x108 * x139 + x140,
            x112 * x139 + x97,
            x119 * x139,
            4.0 * x104 + x123 * x141,
            3.0 * x109 + x126 * x141,
            x114 + x128 * x141,
            x121 + x130 * x141,
            x132 * x141,
            5.0 * x122 + x133 * x139,
            4.0 * x125 + x134 * x139,
            x135 * x139 + x142,
            2.0 * x129 + x136 * x139,
            x131 + x137 * x139,
            x138 * x139,
            x143 * x39,
            x143 * x55,
            x143 * x66 + x43,
            x143 * x77,
            x143 * x82 + x56,
            x143 * x94 + 2.0 * x67,
            x102 * x143,
            x108 * x143 + x79,
            x112 * x143 + x140,
            x119 * x143 + x98,
            x123 * x144,
            x104 + x126 * x144,
            x110 + x128 * x144,
            3.0 * x113 + x130 * x144,
            4.0 * x121 + x132 * x144,
            x133 * x143,
            x122 + x134 * x143,
            2.0 * x125 + x135 * x143,
            x136 * x143 + x142,
            4.0 * x129 + x137 * x143,
            5.0 * x131 + x138 * x143,
        ]
    )


def _2center2el3d_20(a, A, b, B):
    """Cartesian (d|s) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x4 = 17.4934183276249
    x5 = 2.0 * x0 * x4
    x6 = b ** (-1.0)
    x7 = x1 ** (-0.5)
    x8 = (
        0.5
        * x0
        * (2.0 * x0 * x4 * x6 * x7 * boys(0, x3) - x1 ** (-1.5) * x5 * boys(1, x3))
    )
    x9 = x2 * (a * A[0] + b * B[0]) - A[0]
    x10 = x5 * x6 * x7 * boys(2, x3)
    x11 = x2 * (a * A[1] + b * B[1]) - A[1]
    x12 = x10 * x9
    x13 = x2 * (a * A[2] + b * B[2]) - A[2]

    # 6 item(s)
    return numpy.array(
        [
            x10 * x9**2 + x8,
            x11 * x12,
            x12 * x13,
            x10 * x11**2 + x8,
            x10 * x11 * x13,
            x10 * x13**2 + x8,
        ]
    )


def _2center2el3d_21(a, A, b, B):
    """Cartesian (d|p) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x5 = a ** (-1.0)
    x6 = 17.4934183276249
    x7 = 2.0 * x5 * x6
    x8 = x7 * boys(2, x4)
    x9 = b ** (-1.0)
    x10 = x0 ** (-0.5)
    x11 = x10 * x9
    x12 = x11 * x8 / (2.0 * a + 2.0 * b)
    x13 = -x2 - B[0]
    x14 = x11 * x7 * boys(3, x4)
    x15 = x13 * x14
    x16 = x15 * x3
    x17 = x0 ** (-1.5) * x8
    x18 = boys(1, x4)
    x19 = 0.5 * x5
    x20 = x19 * (2.0 * x10 * x13 * x18 * x5 * x6 * x9 - x13 * x17)
    x21 = -x1 * (a * A[1] + b * B[1])
    x22 = -x21 - B[1]
    x23 = x19 * (2.0 * x10 * x18 * x22 * x5 * x6 * x9 - x17 * x22)
    x24 = x14 * x3**2
    x25 = -x1 * (a * A[2] + b * B[2])
    x26 = -x25 - B[2]
    x27 = x19 * (2.0 * x10 * x18 * x26 * x5 * x6 * x9 - x17 * x26)
    x28 = -x21 - A[1]
    x29 = x12 * x28
    x30 = x14 * x22
    x31 = x28 * x30
    x32 = x12 + x31
    x33 = x14 * x26
    x34 = -x25 - A[2]
    x35 = x12 * x34
    x36 = x12 + x33 * x34
    x37 = x28**2
    x38 = x34**2

    # 18 item(s)
    return numpy.array(
        [
            x12 * x3 + x20 + x3 * (x12 + x16),
            x22 * x24 + x23,
            x24 * x26 + x27,
            x16 * x28 + x29,
            x3 * x32,
            x28 * x3 * x33,
            x16 * x34 + x35,
            x3 * x30 * x34,
            x3 * x36,
            x15 * x37 + x20,
            x23 + x28 * x32 + x29,
            x27 + x33 * x37,
            x15 * x28 * x34,
            x31 * x34 + x35,
            x28 * x36,
            x15 * x38 + x20,
            x23 + x30 * x38,
            x27 + x34 * x36 + x35,
        ]
    )


def _2center2el3d_22(a, A, b, B):
    """Cartesian (d|d) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = b * x1
    x5 = a * x4 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x6 = boys(3, x5)
    x7 = x0 ** (-1.5)
    x8 = b ** (-1.0)
    x9 = 17.4934183276249
    x10 = x8 * x9
    x11 = 2.0 * x10
    x12 = x11 * x7
    x13 = a ** (-1.0)
    x14 = x0 ** (-0.5)
    x15 = boys(2, x5)
    x16 = 0.5 * x8
    x17 = x16 * (-x12 * x6 + 2.0 * x13 * x14 * x15 * x8 * x9)
    x18 = boys(4, x5)
    x19 = -x2 - B[0]
    x20 = x19**2
    x21 = x13 * x14
    x22 = x11 * x21
    x23 = x20 * x22
    x24 = x17 + x18 * x23
    x25 = x24 * x3
    x26 = x19 * x6
    x27 = (2.0 * a + 2.0 * b) ** (-1.0)
    x28 = x10 * x21
    x29 = 4.0 * x27 * x28
    x30 = x26 * x29
    x31 = boys(1, x5)
    x32 = x16 * (-x12 * x31 + 2.0 * x13 * x14 * x8 * x9 * boys(0, x5))
    x33 = x16 * (-x12 * x15 + 2.0 * x13 * x14 * x31 * x8 * x9)
    x34 = x15 * x22
    x35 = 0.5 * x13
    x36 = x35 * (x20 * x34 + x32 - x4 * (x23 * x6 + x33))
    x37 = 2.0 * x27
    x38 = x28 * x37
    x39 = x15 * x38
    x40 = x22 * x3
    x41 = -x1 * (a * A[1] + b * B[1])
    x42 = -x41 - B[1]
    x43 = x42 * x6
    x44 = x38 * x43
    x45 = x18 * x19
    x46 = x40 * x45
    x47 = 2.0 * x13 * x26 * x7 * x9
    x48 = x35 * (2.0 * x13 * x14 * x15 * x19 * x42 * x8 * x9 - x42 * x47)
    x49 = -x1 * (a * A[2] + b * B[2])
    x50 = -x49 - B[2]
    x51 = x50 * x6
    x52 = x38 * x51
    x53 = x35 * (2.0 * x13 * x14 * x15 * x19 * x50 * x8 * x9 - x47 * x50)
    x54 = x3**2
    x55 = x42**2
    x56 = x22 * x55
    x57 = x17 + x18 * x56
    x58 = x35 * (x32 + x34 * x55 - x4 * (x33 + x56 * x6))
    x59 = x35 * (
        2.0 * x13 * x14 * x15 * x42 * x50 * x8 * x9 - 2.0 * x13 * x43 * x50 * x7 * x9
    )
    x60 = x18 * x42 * x50
    x61 = x50**2
    x62 = x22 * x61
    x63 = x17 + x18 * x62
    x64 = x35 * (x32 + x34 * x61 - x4 * (x33 + x6 * x62))
    x65 = -x41 - A[1]
    x66 = x22 * x65
    x67 = x27 * (x39 + x43 * x66)
    x68 = x26 * x38
    x69 = x42 * x45
    x70 = x66 * x69 + x68
    x71 = x52 * x65
    x72 = x3 * x65
    x73 = x45 * x50
    x74 = x22 * x73
    x75 = x57 * x65
    x76 = x29 * x43
    x77 = x75 + x76
    x78 = x52 + x60 * x66
    x79 = -x49 - A[2]
    x80 = x44 * x79
    x81 = x3 * x79
    x82 = x22 * x69
    x83 = x22 * x79
    x84 = x27 * (x39 + x51 * x83)
    x85 = x68 + x73 * x83
    x86 = x44 + x60 * x83
    x87 = x29 * x51 + x63 * x79
    x88 = x65**2
    x89 = x65 * x79
    x90 = x68 * x79
    x91 = x79**2

    # 36 item(s)
    return numpy.array(
        [
            x3 * (x25 + x30) + x36 + x37 * (x26 * x40 + x39),
            x3 * x44 + x3 * (x42 * x46 + x44) + x48,
            x3 * x52 + x3 * (x46 * x50 + x52) + x53,
            x54 * x57 + x58,
            x22 * x54 * x60 + x59,
            x54 * x63 + x64,
            x25 * x65 + x30 * x65,
            x3 * x70 + x67,
            x71 + x72 * x74,
            x3 * x77,
            x3 * x78,
            x63 * x72,
            x25 * x79 + x30 * x79,
            x80 + x81 * x82,
            x3 * x85 + x84,
            x57 * x81,
            x3 * x86,
            x3 * x87,
            x24 * x88 + x36,
            x48 + x65 * x68 + x65 * x70,
            x53 + x74 * x88,
            x58 + x65 * x77 + 2.0 * x67,
            x59 + x65 * x78 + x71,
            x63 * x88 + x64,
            x24 * x89,
            x82 * x89 + x90,
            x65 * x85,
            x75 * x79 + x76 * x79,
            x65 * x86 + x84,
            x65 * x87,
            x24 * x91 + x36,
            x48 + x82 * x91,
            x53 + x79 * x85 + x90,
            x57 * x91 + x58,
            x59 + x79 * x86 + x80,
            x64 + x79 * x87 + 2.0 * x84,
        ]
    )


def _2center2el3d_23(a, A, b, B):
    """Cartesian (d|f) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = b ** (-1.0)
    x5 = -x2 - B[0]
    x6 = b * x1
    x7 = a * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x8 = boys(4, x7)
    x9 = x0 ** (-1.5)
    x10 = 17.4934183276249
    x11 = x10 * x4
    x12 = 2.0 * x11
    x13 = x12 * x9
    x14 = x13 * x8
    x15 = a ** (-1.0)
    x16 = x0 ** (-0.5)
    x17 = boys(3, x7)
    x18 = 0.5 * x4
    x19 = x18 * (2.0 * x10 * x15 * x16 * x17 * x4 - x14)
    x20 = boys(5, x7)
    x21 = x5**2
    x22 = x15 * x16
    x23 = x12 * x22
    x24 = x21 * x23
    x25 = x20 * x24
    x26 = x4 * (2.0 * x10 * x15 * x16 * x17 * x4 * x5 - x14 * x5) + x5 * (x19 + x25)
    x27 = x26 * x3
    x28 = (2.0 * a + 2.0 * b) ** (-1.0)
    x29 = x13 * x17
    x30 = boys(2, x7)
    x31 = x18 * (2.0 * x10 * x15 * x16 * x30 * x4 - x29)
    x32 = x24 * x8
    x33 = x31 + x32
    x34 = x28 * x33
    x35 = 3.0 * x34
    x36 = x13 * x30
    x37 = boys(1, x7)
    x38 = x18 * (2.0 * x10 * x15 * x16 * x37 * x4 - x36)
    x39 = x17 * x23
    x40 = x21 * x39
    x41 = 0.5 * x15
    x42 = x41 * (
        x4 * (2.0 * x10 * x15 * x16 * x37 * x4 * x5 - x36 * x5)
        + x5 * (x38 + x40)
        - x6 * (x33 * x5 + x4 * (2.0 * x10 * x15 * x16 * x30 * x4 * x5 - x29 * x5))
    )
    x43 = x11 * x22
    x44 = x17 * x43
    x45 = x44 * x5
    x46 = 4.0 * x28
    x47 = -x1 * (a * A[1] + b * B[1])
    x48 = -x47 - B[1]
    x49 = x4 * (2.0 * x10 * x15 * x16 * x17 * x4 * x48 - x14 * x48)
    x50 = x25 * x48 + 0.5 * x49
    x51 = x3 * x50
    x52 = x48 * x8
    x53 = x5 * x52
    x54 = x43 * x46
    x55 = x53 * x54
    x56 = x4 * (2.0 * x10 * x15 * x16 * x37 * x4 * x48 - x36 * x48)
    x57 = x4 * (2.0 * x10 * x15 * x16 * x30 * x4 * x48 - x29 * x48)
    x58 = x41 * (x40 * x48 + 0.5 * x56 - x6 * (x32 * x48 + 0.5 * x57))
    x59 = 2.0 * x28
    x60 = x44 * x59
    x61 = x48 * x60
    x62 = x3 * x5
    x63 = x23 * x62
    x64 = -x1 * (a * A[2] + b * B[2])
    x65 = -x64 - B[2]
    x66 = x4 * (2.0 * x10 * x15 * x16 * x17 * x4 * x65 - x14 * x65)
    x67 = 0.5 * x66
    x68 = x25 * x65 + x67
    x69 = x3 * x68
    x70 = x65 * x8
    x71 = x5 * x70
    x72 = x54 * x71
    x73 = x4 * (2.0 * x10 * x15 * x16 * x37 * x4 * x65 - x36 * x65)
    x74 = 0.5 * x73
    x75 = x4 * (2.0 * x10 * x15 * x16 * x30 * x4 * x65 - x29 * x65)
    x76 = 0.5 * x75
    x77 = x41 * (x40 * x65 - x6 * (x32 * x65 + x76) + x74)
    x78 = x60 * x65
    x79 = x48**2
    x80 = x23 * x79
    x81 = x8 * x80
    x82 = x31 + x81
    x83 = x28 * x82
    x84 = x20 * x80
    x85 = x19 + x84
    x86 = x62 * x85
    x87 = x38 + x39 * x79
    x88 = x5 * x6
    x89 = x41 * (x5 * x87 - x82 * x88)
    x90 = x52 * x65
    x91 = x43 * x59
    x92 = x90 * x91
    x93 = x20 * x48 * x65
    x94 = x41 * (
        2.0 * x10 * x15 * x16 * x17 * x4 * x48 * x5 * x65
        - 2.0 * x10 * x15 * x53 * x65 * x9
    )
    x95 = x65**2
    x96 = x23 * x95
    x97 = x31 + x8 * x96
    x98 = x28 * x97
    x99 = x19 + x20 * x96
    x100 = x62 * x99
    x101 = x38 + x39 * x95
    x102 = x41 * (x101 * x5 - x88 * x97)
    x103 = x3**2
    x104 = x48 * x85 + x49
    x105 = x41 * (x48 * x87 + x56 - x6 * (x48 * x82 + x57))
    x106 = x65 * x84 + x67
    x107 = x41 * (x39 * x65 * x79 - x6 * (x65 * x81 + x76) + x74)
    x108 = x41 * (x101 * x48 - x48 * x6 * x97)
    x109 = x48 * x99
    x110 = x65 * x99 + x66
    x111 = x41 * (x101 * x65 - x6 * (x65 * x97 + x75) + x73)
    x112 = -x47 - A[1]
    x113 = x112 * x50
    x114 = x113 + x34
    x115 = x45 * x59
    x116 = x112 * x23
    x117 = x59 * (x115 + x116 * x53)
    x118 = x44 * x46
    x119 = x28 * (x112 * x82 + x118 * x48)
    x120 = x5 * x85
    x121 = x112 * x120
    x122 = x121 + x55
    x123 = x28 * (x116 * x90 + x78)
    x124 = x71 * x91
    x125 = x5 * x93
    x126 = x116 * x125 + x124
    x127 = x112 * x98
    x128 = x104 * x112
    x129 = 3.0 * x83
    x130 = x128 + x129
    x131 = x54 * x90
    x132 = x106 * x112 + x131
    x133 = x109 * x112 + x98
    x134 = -x64 - A[2]
    x135 = x134 * x55
    x136 = x134 * x68 + x34
    x137 = x134 * x23
    x138 = x28 * (x115 + x137 * x71)
    x139 = 2.0 * x138
    x140 = x134 * x83
    x141 = x28 * (x137 * x90 + x61)
    x142 = x53 * x91
    x143 = x125 * x137 + x142
    x144 = x28 * (x118 * x65 + x134 * x97)
    x145 = x5 * x99
    x146 = x134 * x145 + x72
    x147 = x106 * x134 + x83
    x148 = x109 * x134 + x131
    x149 = x110 * x134 + 3.0 * x98
    x150 = x112**2
    x151 = x134 * x34
    x152 = 2.0 * x141
    x153 = x134**2

    # 60 item(s)
    return numpy.array(
        [
            3.0 * x28 * (x3 * x33 + x45 * x46) + x3 * (x27 + x35) + x42,
            x3 * (x51 + x55) + x58 + x59 * (x52 * x63 + x61),
            x3 * (x69 + x72) + x59 * (x63 * x70 + x78) + x77,
            x3 * x83 + x3 * (x83 + x86) + x89,
            x3 * x92 + x3 * (x63 * x93 + x92) + x94,
            x102 + x3 * x98 + x3 * (x100 + x98),
            x103 * x104 + x105,
            x103 * x106 + x107,
            x103 * x109 + x108,
            x103 * x110 + x111,
            x112 * x27 + x112 * x35,
            x114 * x3 + x117,
            x112 * x69 + x112 * x72,
            x119 + x122 * x3,
            x123 + x126 * x3,
            x100 * x112 + x127,
            x130 * x3,
            x132 * x3,
            x133 * x3,
            x110 * x112 * x3,
            x134 * x27 + x134 * x35,
            x134 * x51 + x135,
            x136 * x3 + x139,
            x134 * x86 + x140,
            x141 + x143 * x3,
            x144 + x146 * x3,
            x104 * x134 * x3,
            x147 * x3,
            x148 * x3,
            x149 * x3,
            x150 * x26 + x42,
            x112 * x114 + x112 * x34 + x58,
            x150 * x68 + x77,
            x112 * x122 + x117 + x89,
            x112 * x124 + x112 * x126 + x94,
            x102 + x145 * x150,
            x105 + x112 * x130 + 3.0 * x119,
            x107 + x112 * x132 + 2.0 * x123,
            x108 + x112 * x133 + x127,
            x110 * x150 + x111,
            x112 * x134 * x26,
            x113 * x134 + x151,
            x112 * x136,
            x121 * x134 + x135,
            x112 * x143 + x138,
            x112 * x146,
            x128 * x134 + x129 * x134,
            x112 * x147 + x152,
            x112 * x148 + x144,
            x112 * x149,
            x153 * x26 + x42,
            x153 * x50 + x58,
            x134 * x136 + x151 + x77,
            x120 * x153 + x89,
            x134 * x142 + x134 * x143 + x94,
            x102 + x134 * x146 + x139,
            x104 * x153 + x105,
            x107 + x134 * x147 + x140,
            x108 + x134 * x148 + x152,
            x111 + x134 * x149 + 3.0 * x144,
        ]
    )


def _2center2el3d_24(a, A, b, B):
    """Cartesian (d|g) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = -x2 - B[0]
    x5 = b ** (-1.0)
    x6 = a * x1
    x7 = b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x8 = boys(5, x7)
    x9 = 17.4934183276249
    x10 = x5 * x9
    x11 = 2.0 * x10
    x12 = x0 ** (-1.5) * x11
    x13 = x12 * x8
    x14 = x13 * x4
    x15 = a ** (-1.0)
    x16 = x0 ** (-0.5)
    x17 = boys(4, x7)
    x18 = 0.5 * x5
    x19 = x18 * (-x13 + 2.0 * x15 * x16 * x17 * x5 * x9)
    x20 = boys(6, x7)
    x21 = x4**2
    x22 = x15 * x16
    x23 = x11 * x22
    x24 = x21 * x23
    x25 = x20 * x24
    x26 = x12 * x17
    x27 = boys(3, x7)
    x28 = x18 * (2.0 * x15 * x16 * x27 * x5 * x9 - x26)
    x29 = x24 * x8
    x30 = x28 + x29
    x31 = x12 * x27
    x32 = boys(2, x7)
    x33 = x18 * (2.0 * x15 * x16 * x32 * x5 * x9 - x31)
    x34 = x17 * x23
    x35 = x21 * x34
    x36 = x33 + x35
    x37 = 1.5 * x5
    x38 = x37 * (-x30 * x6 + x36) + x4 * (
        x4 * (x19 + x25) + x5 * (-x14 + 2.0 * x15 * x16 * x17 * x4 * x5 * x9)
    )
    x39 = x3 * x38
    x40 = (2.0 * a + 2.0 * b) ** (-1.0)
    x41 = x26 * x4
    x42 = x30 * x4 + x5 * (2.0 * x15 * x16 * x27 * x4 * x5 * x9 - x41)
    x43 = x40 * x42
    x44 = 4.0 * x43
    x45 = x31 * x4
    x46 = boys(1, x7)
    x47 = x18 * (-x12 * x46 + 2.0 * x15 * x16 * x5 * x9 * boys(0, x7))
    x48 = x18 * (-x12 * x32 + 2.0 * x15 * x16 * x46 * x5 * x9)
    x49 = x23 * x27
    x50 = x21 * x49 + x48
    x51 = x23 * x32
    x52 = b * x1
    x53 = 0.5 * x15
    x54 = x53 * (
        x37 * (x21 * x51 + x47 - x50 * x6)
        + x4 * (x36 * x4 + x5 * (2.0 * x15 * x16 * x32 * x4 * x5 * x9 - x45))
        - x52 * (x37 * (-x36 * x6 + x50) + x4 * x42)
    )
    x55 = x36 * x40
    x56 = 4.0 * x40
    x57 = -x1 * (a * A[1] + b * B[1])
    x58 = -x57 - B[1]
    x59 = x4 * x58
    x60 = x13 * x58
    x61 = x5 * (2.0 * x15 * x16 * x17 * x5 * x58 * x9 - x60)
    x62 = x25 * x58
    x63 = x4 * (0.5 * x61 + x62) + x5 * (
        -x13 * x59 + 2.0 * x15 * x16 * x17 * x4 * x5 * x58 * x9
    )
    x64 = x3 * x63
    x65 = x26 * x58
    x66 = x5 * (2.0 * x15 * x16 * x27 * x5 * x58 * x9 - x65)
    x67 = x29 * x58
    x68 = 0.5 * x66 + x67
    x69 = x40 * x68
    x70 = 3.0 * x69
    x71 = x31 * x58
    x72 = x5 * (2.0 * x15 * x16 * x32 * x5 * x58 * x9 - x71)
    x73 = x35 * x58
    x74 = x53 * (
        x4 * (0.5 * x72 + x73)
        + x5 * (2.0 * x15 * x16 * x32 * x4 * x5 * x58 * x9 - x31 * x59)
        - x52 * (x4 * x68 + x5 * (2.0 * x15 * x16 * x27 * x4 * x5 * x58 * x9 - x26 * x59))
    )
    x75 = x10 * x17 * x22
    x76 = x56 * x75
    x77 = x59 * x76
    x78 = 3.0 * x40
    x79 = -x1 * (a * A[2] + b * B[2])
    x80 = -x79 - B[2]
    x81 = x5 * (-x13 * x80 + 2.0 * x15 * x16 * x17 * x5 * x80 * x9)
    x82 = 0.5 * x81
    x83 = x4 * (x25 * x80 + x82) + x5 * (
        -x14 * x80 + 2.0 * x15 * x16 * x17 * x4 * x5 * x80 * x9
    )
    x84 = x3 * x83
    x85 = x5 * (2.0 * x15 * x16 * x27 * x5 * x80 * x9 - x26 * x80)
    x86 = 0.5 * x85
    x87 = x29 * x80 + x86
    x88 = x40 * x87
    x89 = 3.0 * x88
    x90 = x5 * (2.0 * x15 * x16 * x32 * x5 * x80 * x9 - x31 * x80)
    x91 = 0.5 * x90
    x92 = x53 * (
        x4 * (x35 * x80 + x91)
        + x5 * (2.0 * x15 * x16 * x32 * x4 * x5 * x80 * x9 - x45 * x80)
        - x52 * (x4 * x87 + x5 * (2.0 * x15 * x16 * x27 * x4 * x5 * x80 * x9 - x41 * x80))
    )
    x93 = x4 * x80
    x94 = x76 * x93
    x95 = x58**2
    x96 = x23 * x95
    x97 = x20 * x96
    x98 = x19 + x97
    x99 = x8 * x96
    x100 = x28 + x99
    x101 = x33 + x34 * x95
    x102 = -x100 * x6 + x101
    x103 = x102 * x18 + x21 * x98
    x104 = x103 * x3
    x105 = 2.0 * x40
    x106 = x100 * x4
    x107 = x105 * x106
    x108 = x48 + x49 * x95
    x109 = -x108 * x6 + x47 + x51 * x95
    x110 = -x101 * x6 + x108
    x111 = x53 * (x101 * x21 + x109 * x18 - x52 * (x100 * x21 + x110 * x18))
    x112 = x101 * x40
    x113 = x3 * x4
    x114 = x5 * (2.0 * x15 * x16 * x17 * x5 * x58 * x80 * x9 - x60 * x80)
    x115 = 0.5 * x114 + x62 * x80
    x116 = x8 * x80
    x117 = x116 * x59
    x118 = x10 * x117 * x22 * x56
    x119 = x5 * (2.0 * x15 * x16 * x32 * x5 * x58 * x80 * x9 - x71 * x80)
    x120 = x5 * (2.0 * x15 * x16 * x27 * x5 * x58 * x80 * x9 - x65 * x80)
    x121 = x53 * (0.5 * x119 - x52 * (0.5 * x120 + x67 * x80) + x73 * x80)
    x122 = x105 * x75
    x123 = x58 * x80
    x124 = x113 * x58
    x125 = x80**2
    x126 = x125 * x23
    x127 = x126 * x20 + x19
    x128 = x126 * x8 + x28
    x129 = x125 * x34 + x33
    x130 = -x128 * x6 + x129
    x131 = x130 * x18
    x132 = x127 * x21 + x131
    x133 = x132 * x3
    x134 = x128 * x4
    x135 = x125 * x49 + x48
    x136 = x125 * x51 - x135 * x6 + x47
    x137 = x136 * x18
    x138 = -x129 * x6 + x135
    x139 = x138 * x18
    x140 = x53 * (x129 * x21 + x137 - x52 * (x128 * x21 + x139))
    x141 = x129 * x40
    x142 = x100 * x58 + x66
    x143 = x142 * x40
    x144 = x58 * x98 + x61
    x145 = x113 * x144
    x146 = x101 * x58 + x72
    x147 = x4 * x52
    x148 = x53 * (-x142 * x147 + x146 * x4)
    x149 = x80 * x99 + x86
    x150 = x149 * x40
    x151 = x80 * x97 + x82
    x152 = x34 * x80 * x95 + x91
    x153 = x53 * (-x147 * x149 + x152 * x4)
    x154 = x128 * x58
    x155 = x154 * x40
    x156 = x53 * (x129 * x4 * x58 - x147 * x154)
    x157 = x128 * x80 + x85
    x158 = x157 * x40
    x159 = x127 * x80 + x81
    x160 = x113 * x159
    x161 = x129 * x80 + x90
    x162 = x53 * (-x147 * x157 + x161 * x4)
    x163 = x3**2
    x164 = x102 * x37 + x144 * x58
    x165 = x53 * (x109 * x37 + x146 * x58 - x52 * (x110 * x37 + x142 * x58))
    x166 = x114 + x151 * x58
    x167 = x53 * (x119 + x152 * x58 - x52 * (x120 + x149 * x58))
    x168 = x127 * x95 + x131
    x169 = x53 * (x129 * x95 + x137 - x52 * (x128 * x95 + x139))
    x170 = x53 * (-x157 * x52 * x58 + x161 * x58)
    x171 = x159 * x58
    x172 = x130 * x37 + x159 * x80
    x173 = x53 * (x136 * x37 + x161 * x80 - x52 * (x138 * x37 + x157 * x80))
    x174 = -x57 - A[1]
    x175 = x174 * x63
    x176 = x175 + x43
    x177 = x174 * x68 + x55
    x178 = x103 * x174
    x179 = 2.0 * x69
    x180 = x178 + x179
    x181 = x174 * x4
    x182 = x100 * x181 + x77
    x183 = x115 * x174 + x88
    x184 = x117 * x23
    x185 = x105 * (x122 * x93 + x174 * x184)
    x186 = x128 * x181
    x187 = x40 * (3.0 * x112 + x142 * x174)
    x188 = x144 * x181
    x189 = x106 * x78
    x190 = x188 + x189
    x191 = x123 * x76
    x192 = x40 * (x149 * x174 + x191)
    x193 = x118 + x151 * x181
    x194 = x40 * (x141 + x154 * x174)
    x195 = x127 * x59
    x196 = x134 * x40 + x174 * x195
    x197 = x158 * x174
    x198 = x164 * x174
    x199 = 4.0 * x143
    x200 = x198 + x199
    x201 = 3.0 * x150 + x166 * x174
    x202 = x105 * x154 + x168 * x174
    x203 = x158 + x171 * x174
    x204 = -x79 - A[2]
    x205 = x204 * x83 + x43
    x206 = x40 * (x204 * x87 + x55)
    x207 = x115 * x204 + x69
    x208 = x105 * (x122 * x59 + x184 * x204)
    x209 = x132 * x204 + 2.0 * x88
    x210 = x40 * (x134 * x204 + x94)
    x211 = x143 * x204
    x212 = x40 * (x112 + x149 * x204)
    x213 = x106 * x40
    x214 = x204 * x4
    x215 = x151 * x214 + x213
    x216 = x40 * (x154 * x204 + x191)
    x217 = x118 + x195 * x204
    x218 = x40 * (3.0 * x141 + x157 * x204)
    x219 = x134 * x78 + x159 * x214
    x220 = x143 + x166 * x204
    x221 = 2.0 * x150 + x168 * x204
    x222 = x154 * x78 + x171 * x204
    x223 = 4.0 * x158 + x172 * x204
    x224 = x174**2
    x225 = x204 * x43
    x226 = x204**2

    # 90 item(s)
    return numpy.array(
        [
            x3 * (x39 + x44) + x54 + x56 * (x3 * x42 + 3.0 * x55),
            x3 * (x64 + x70) + x74 + x78 * (x3 * x68 + x77),
            x3 * (x84 + x89) + x78 * (x3 * x87 + x94) + x92,
            x105 * (x100 * x113 + x112) + x111 + x3 * (x104 + x107),
            x105 * (x116 * x124 * x23 + x122 * x123) + x121 + x3 * (x115 * x3 + x118),
            x105 * (x113 * x128 + x141) + x140 + x3 * (x105 * x134 + x133),
            x143 * x3 + x148 + x3 * (x143 + x145),
            x150 * x3 + x153 + x3 * (x113 * x151 + x150),
            x155 * x3 + x156 + x3 * (x124 * x127 + x155),
            x158 * x3 + x162 + x3 * (x158 + x160),
            x163 * x164 + x165,
            x163 * x166 + x167,
            x163 * x168 + x169,
            x163 * x171 + x170,
            x163 * x172 + x173,
            x174 * x39 + x174 * x44,
            x176 * x3 + x177 * x78,
            x174 * x84 + x174 * x89,
            x105 * x182 + x180 * x3,
            x183 * x3 + x185,
            x105 * x186 + x133 * x174,
            x187 + x190 * x3,
            x192 + x193 * x3,
            x194 + x196 * x3,
            x160 * x174 + x197,
            x200 * x3,
            x201 * x3,
            x202 * x3,
            x203 * x3,
            x172 * x174 * x3,
            x204 * x39 + x204 * x44,
            x204 * x64 + x204 * x70,
            x205 * x3 + 3.0 * x206,
            x104 * x204 + x107 * x204,
            x207 * x3 + x208,
            x209 * x3 + 2.0 * x210,
            x145 * x204 + x211,
            x212 + x215 * x3,
            x216 + x217 * x3,
            x218 + x219 * x3,
            x164 * x204 * x3,
            x220 * x3,
            x221 * x3,
            x222 * x3,
            x223 * x3,
            x224 * x38 + x54,
            x174 * x176 + x174 * x43 + x74,
            x224 * x83 + x92,
            x105 * x177 + x111 + x174 * x180,
            x121 + x174 * x183 + x174 * x88,
            x132 * x224 + x140,
            x148 + x174 * x190 + x182 * x78,
            x153 + x174 * x193 + x185,
            x156 + x174 * x196 + x186 * x40,
            x159 * x224 * x4 + x162,
            x165 + x174 * x200 + 4.0 * x187,
            x167 + x174 * x201 + 3.0 * x192,
            x169 + x174 * x202 + 2.0 * x194,
            x170 + x174 * x203 + x197,
            x172 * x224 + x173,
            x174 * x204 * x38,
            x175 * x204 + x225,
            x174 * x205,
            x178 * x204 + x179 * x204,
            x174 * x207 + x206,
            x174 * x209,
            x188 * x204 + x189 * x204,
            x174 * x215 + x208,
            x174 * x217 + x210,
            x174 * x219,
            x198 * x204 + x199 * x204,
            x174 * x220 + 3.0 * x212,
            x174 * x221 + 2.0 * x216,
            x174 * x222 + x218,
            x174 * x223,
            x226 * x38 + x54,
            x226 * x63 + x74,
            x204 * x205 + x225 + x92,
            x103 * x226 + x111,
            x121 + x204 * x207 + x204 * x69,
            x140 + x204 * x209 + 2.0 * x206,
            x144 * x226 * x4 + x148,
            x153 + x204 * x213 + x204 * x215,
            x156 + x204 * x217 + x208,
            x162 + x204 * x219 + 3.0 * x210,
            x164 * x226 + x165,
            x167 + x204 * x220 + x211,
            x169 + x204 * x221 + 2.0 * x212,
            x170 + x204 * x222 + 3.0 * x216,
            x173 + x204 * x223 + 4.0 * x218,
        ]
    )


def _2center2el3d_25(a, A, b, B):
    """Cartesian (d|h) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = -x2 - B[0]
    x5 = b ** (-1.0)
    x6 = a * x1
    x7 = b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x8 = boys(6, x7)
    x9 = 17.4934183276249
    x10 = 2.0 * x5
    x11 = x10 * x9
    x12 = x0 ** (-1.5) * x11
    x13 = x12 * x8
    x14 = x13 * x4
    x15 = a ** (-1.0)
    x16 = x0 ** (-0.5)
    x17 = boys(5, x7)
    x18 = 0.5 * x5
    x19 = x18 * (-x13 + 2.0 * x15 * x16 * x17 * x5 * x9)
    x20 = boys(7, x7)
    x21 = x4**2
    x22 = x11 * x15 * x16
    x23 = x21 * x22
    x24 = x20 * x23
    x25 = x12 * x17
    x26 = boys(4, x7)
    x27 = x18 * (2.0 * x15 * x16 * x26 * x5 * x9 - x25)
    x28 = x23 * x8
    x29 = x27 + x28
    x30 = x12 * x26
    x31 = boys(3, x7)
    x32 = x18 * (2.0 * x15 * x16 * x31 * x5 * x9 - x30)
    x33 = x17 * x22
    x34 = x21 * x33
    x35 = x32 + x34
    x36 = 1.5 * x5
    x37 = x25 * x4
    x38 = x29 * x4 + x5 * (2.0 * x15 * x16 * x26 * x4 * x5 * x9 - x37)
    x39 = x30 * x4
    x40 = x35 * x4 + x5 * (2.0 * x15 * x16 * x31 * x4 * x5 * x9 - x39)
    x41 = x10 * (-x38 * x6 + x40) + x4 * (
        x36 * (-x29 * x6 + x35)
        + x4 * (x4 * (x19 + x24) + x5 * (-x14 + 2.0 * x15 * x16 * x17 * x4 * x5 * x9))
    )
    x42 = x3 * x41
    x43 = (2.0 * a + 2.0 * b) ** (-1.0)
    x44 = x12 * x31
    x45 = boys(2, x7)
    x46 = x18 * (2.0 * x15 * x16 * x45 * x5 * x9 - x44)
    x47 = x22 * x26
    x48 = x21 * x47
    x49 = x46 + x48
    x50 = x36 * (-x35 * x6 + x49) + x38 * x4
    x51 = x43 * x50
    x52 = 5.0 * x51
    x53 = x12 * x45
    x54 = boys(1, x7)
    x55 = x18 * (2.0 * x15 * x16 * x5 * x54 * x9 - x53)
    x56 = x22 * x31
    x57 = x21 * x56
    x58 = x55 + x57
    x59 = x4 * x49 + x5 * (2.0 * x15 * x16 * x4 * x45 * x5 * x9 - x4 * x44)
    x60 = b * x1
    x61 = 0.5 * x15
    x62 = x61 * (
        x10
        * (x4 * x58 + x5 * (2.0 * x15 * x16 * x4 * x5 * x54 * x9 - x4 * x53) - x59 * x6)
        + x4 * (x36 * (-x49 * x6 + x58) + x4 * x40)
        - x60 * (x10 * (-x40 * x6 + x59) + x4 * x50)
    )
    x63 = x40 * x43
    x64 = -x1 * (a * A[1] + b * B[1])
    x65 = -x64 - B[1]
    x66 = x4 * x65
    x67 = x13 * x65
    x68 = x5 * (2.0 * x15 * x16 * x17 * x5 * x65 * x9 - x67)
    x69 = x24 * x65
    x70 = x25 * x65
    x71 = x5 * (2.0 * x15 * x16 * x26 * x5 * x65 * x9 - x70)
    x72 = x28 * x65
    x73 = 0.5 * x71 + x72
    x74 = x30 * x65
    x75 = x5 * (2.0 * x15 * x16 * x31 * x5 * x65 * x9 - x74)
    x76 = x34 * x65
    x77 = 0.5 * x75 + x76
    x78 = x36 * (-x6 * x73 + x77) + x4 * (
        x4 * (0.5 * x68 + x69)
        + x5 * (-x13 * x66 + 2.0 * x15 * x16 * x17 * x4 * x5 * x65 * x9)
    )
    x79 = x3 * x78
    x80 = x4 * x73 + x5 * (2.0 * x15 * x16 * x26 * x4 * x5 * x65 * x9 - x25 * x66)
    x81 = x43 * x80
    x82 = 4.0 * x81
    x83 = x5 * (2.0 * x15 * x16 * x5 * x54 * x65 * x9 - x53 * x65)
    x84 = x5 * (2.0 * x15 * x16 * x45 * x5 * x65 * x9 - x44 * x65)
    x85 = x48 * x65 + 0.5 * x84
    x86 = x61 * (
        x36 * (x57 * x65 - x6 * x85 + 0.5 * x83)
        + x4 * (x4 * x77 + x5 * (2.0 * x15 * x16 * x31 * x4 * x5 * x65 * x9 - x30 * x66))
        - x60 * (x36 * (-x6 * x77 + x85) + x4 * x80)
    )
    x87 = x43 * x77
    x88 = 4.0 * x43
    x89 = -x1 * (a * A[2] + b * B[2])
    x90 = -x89 - B[2]
    x91 = x13 * x90
    x92 = x5 * (2.0 * x15 * x16 * x17 * x5 * x9 * x90 - x91)
    x93 = 0.5 * x92
    x94 = x25 * x90
    x95 = x5 * (2.0 * x15 * x16 * x26 * x5 * x9 * x90 - x94)
    x96 = 0.5 * x95
    x97 = x28 * x90 + x96
    x98 = x30 * x90
    x99 = x5 * (2.0 * x15 * x16 * x31 * x5 * x9 * x90 - x98)
    x100 = 0.5 * x99
    x101 = x100 + x34 * x90
    x102 = x36 * (x101 - x6 * x97) + x4 * (
        x4 * (x24 * x90 + x93)
        + x5 * (-x14 * x90 + 2.0 * x15 * x16 * x17 * x4 * x5 * x9 * x90)
    )
    x103 = x102 * x3
    x104 = x4 * x97 + x5 * (2.0 * x15 * x16 * x26 * x4 * x5 * x9 * x90 - x37 * x90)
    x105 = x104 * x43
    x106 = 4.0 * x105
    x107 = x5 * (2.0 * x15 * x16 * x5 * x54 * x9 * x90 - x53 * x90)
    x108 = 0.5 * x107
    x109 = x5 * (2.0 * x15 * x16 * x45 * x5 * x9 * x90 - x44 * x90)
    x110 = 0.5 * x109
    x111 = x110 + x48 * x90
    x112 = x61 * (
        x36 * (x108 - x111 * x6 + x57 * x90)
        + x4 * (x101 * x4 + x5 * (2.0 * x15 * x16 * x31 * x4 * x5 * x9 * x90 - x39 * x90))
        - x60 * (x104 * x4 + x36 * (-x101 * x6 + x111))
    )
    x113 = x101 * x43
    x114 = x65**2
    x115 = x114 * x33 + x32
    x116 = x114 * x22
    x117 = x116 * x8
    x118 = x117 + x27
    x119 = x118 * x6
    x120 = x116 * x20
    x121 = x120 + x19
    x122 = x115 - x119
    x123 = x4 * (x121 * x21 + x122 * x18) + x5 * (x115 * x4 - x119 * x4)
    x124 = x123 * x3
    x125 = x114 * x47 + x46
    x126 = -x115 * x6 + x125
    x127 = x118 * x21 + x126 * x18
    x128 = x127 * x43
    x129 = 3.0 * x128
    x130 = x114 * x56 + x55
    x131 = -x125 * x6 + x130
    x132 = x115 * x4
    x133 = x61 * (
        x4 * (x115 * x21 + x131 * x18)
        + x5 * (-x125 * x4 * x6 + x130 * x4)
        - x60 * (x127 * x4 + x5 * (x125 * x4 - x132 * x6))
    )
    x134 = 2.0 * x43
    x135 = 3.0 * x43
    x136 = x5 * (2.0 * x15 * x16 * x17 * x5 * x65 * x9 * x90 - x67 * x90)
    x137 = x4 * (0.5 * x136 + x69 * x90) + x5 * (
        2.0 * x15 * x16 * x17 * x4 * x5 * x65 * x9 * x90 - x66 * x91
    )
    x138 = x5 * (2.0 * x15 * x16 * x26 * x5 * x65 * x9 * x90 - x70 * x90)
    x139 = 0.5 * x138 + x72 * x90
    x140 = x5 * (2.0 * x15 * x16 * x31 * x5 * x65 * x9 * x90 - x74 * x90)
    x141 = x61 * (
        x4 * (0.5 * x140 + x76 * x90)
        + x5 * (2.0 * x15 * x16 * x31 * x4 * x5 * x65 * x9 * x90 - x66 * x98)
        - x60
        * (
            x139 * x4
            + x5 * (2.0 * x15 * x16 * x26 * x4 * x5 * x65 * x9 * x90 - x66 * x94)
        )
    )
    x142 = x15 * x16 * x17 * x5 * x66 * x88 * x9 * x90
    x143 = x90**2
    x144 = x143 * x33 + x32
    x145 = x143 * x22
    x146 = x145 * x8 + x27
    x147 = x146 * x6
    x148 = x145 * x20 + x19
    x149 = x148 * x21
    x150 = x144 - x147
    x151 = x150 * x18
    x152 = x4 * (x149 + x151) + x5 * (x144 * x4 - x147 * x4)
    x153 = x152 * x3
    x154 = x146 * x21
    x155 = x143 * x47 + x46
    x156 = -x144 * x6 + x155
    x157 = x156 * x18
    x158 = x154 + x157
    x159 = x158 * x43
    x160 = 3.0 * x159
    x161 = x143 * x56 + x55
    x162 = x144 * x21
    x163 = -x155 * x6 + x161
    x164 = x163 * x18
    x165 = x144 * x4
    x166 = x61 * (
        x4 * (x162 + x164)
        + x5 * (-x155 * x4 * x6 + x161 * x4)
        - x60 * (x158 * x4 + x5 * (x155 * x4 - x165 * x6))
    )
    x167 = x121 * x65 + x68
    x168 = x118 * x65 + x71
    x169 = x115 * x65 + x75
    x170 = -x168 * x6 + x169
    x171 = x167 * x21 + x170 * x18
    x172 = x171 * x3
    x173 = x168 * x4
    x174 = x125 * x65 + x84
    x175 = x130 * x65 - x174 * x6 + x83
    x176 = -x169 * x6 + x174
    x177 = x61 * (x169 * x21 + x175 * x18 - x60 * (x168 * x21 + x176 * x18))
    x178 = x169 * x43
    x179 = x3 * x4
    x180 = x120 * x90 + x93
    x181 = x117 * x90 + x96
    x182 = x100 + x114 * x33 * x90
    x183 = -x181 * x6 + x182
    x184 = x18 * x183 + x180 * x21
    x185 = x181 * x4
    x186 = x134 * x185
    x187 = x110 + x114 * x47 * x90
    x188 = x108 + x114 * x56 * x90 - x187 * x6
    x189 = -x182 * x6 + x187
    x190 = x61 * (x18 * x188 + x182 * x21 - x60 * (x18 * x189 + x181 * x21))
    x191 = x182 * x43
    x192 = x5 * (x144 * x65 - x147 * x65)
    x193 = x149 * x65 + 0.5 * x192
    x194 = x146 * x66
    x195 = x134 * x194
    x196 = x5 * (-x155 * x6 * x65 + x161 * x65)
    x197 = x144 * x65
    x198 = x5 * (x155 * x65 - x197 * x6)
    x199 = x61 * (x162 * x65 + 0.5 * x196 - x60 * (x154 * x65 + 0.5 * x198))
    x200 = x179 * x65
    x201 = x148 * x90 + x92
    x202 = x146 * x90 + x95
    x203 = x144 * x90 + x99
    x204 = -x202 * x6 + x203
    x205 = x18 * x204
    x206 = x201 * x21 + x205
    x207 = x206 * x3
    x208 = x202 * x4
    x209 = x109 + x155 * x90
    x210 = x107 + x161 * x90 - x209 * x6
    x211 = x18 * x210
    x212 = -x203 * x6 + x209
    x213 = x18 * x212
    x214 = x61 * (x203 * x21 + x211 - x60 * (x202 * x21 + x213))
    x215 = x203 * x43
    x216 = x126 * x36 + x168 * x65
    x217 = x216 * x43
    x218 = x122 * x36 + x167 * x65
    x219 = x179 * x218
    x220 = x131 * x36 + x169 * x65
    x221 = x4 * x60
    x222 = x61 * (-x216 * x221 + x220 * x4)
    x223 = x138 + x181 * x65
    x224 = x223 * x43
    x225 = x136 + x180 * x65
    x226 = x140 + x182 * x65
    x227 = x61 * (-x221 * x223 + x226 * x4)
    x228 = x114 * x146 + x157
    x229 = x228 * x43
    x230 = x114 * x148 + x151
    x231 = x114 * x144 + x164
    x232 = x61 * (-x221 * x228 + x231 * x4)
    x233 = x202 * x65
    x234 = x233 * x43
    x235 = x61 * (x203 * x4 * x65 - x221 * x233)
    x236 = x156 * x36 + x202 * x90
    x237 = x236 * x43
    x238 = x150 * x36 + x201 * x90
    x239 = x179 * x238
    x240 = x163 * x36 + x203 * x90
    x241 = x61 * (-x221 * x236 + x240 * x4)
    x242 = x3**2
    x243 = x10 * x170 + x218 * x65
    x244 = x61 * (x10 * x175 + x220 * x65 - x60 * (x10 * x176 + x216 * x65))
    x245 = x183 * x36 + x225 * x65
    x246 = x61 * (x188 * x36 + x226 * x65 - x60 * (x189 * x36 + x223 * x65))
    x247 = x192 + x230 * x65
    x248 = x61 * (x196 + x231 * x65 - x60 * (x198 + x228 * x65))
    x249 = x114 * x201 + x205
    x250 = x61 * (x114 * x203 + x211 - x60 * (x114 * x202 + x213))
    x251 = x61 * (-x236 * x60 * x65 + x240 * x65)
    x252 = x238 * x65
    x253 = x10 * x204 + x238 * x90
    x254 = x61 * (x10 * x210 + x240 * x90 - x60 * (x10 * x212 + x236 * x90))
    x255 = -x64 - A[1]
    x256 = x255 * x78
    x257 = x256 + x51
    x258 = x255 * x80 + x63
    x259 = x123 * x255
    x260 = 2.0 * x81
    x261 = x259 + x260
    x262 = x135 * (x127 * x255 + 2.0 * x87)
    x263 = x105 + x137 * x255
    x264 = x113 + x139 * x255
    x265 = x171 * x255
    x266 = x129 + x265
    x267 = x255 * x4
    x268 = x132 * x135 + x168 * x267
    x269 = x134 * x139
    x270 = x184 * x255 + x269
    x271 = x142 + x181 * x267
    x272 = x159 + x193 * x255
    x273 = x255 * x66
    x274 = x134 * (x146 * x273 + x165 * x43)
    x275 = x202 * x267
    x276 = x43 * (4.0 * x178 + x216 * x255)
    x277 = x218 * x267
    x278 = x173 * x88 + x277
    x279 = x43 * (3.0 * x191 + x223 * x255)
    x280 = x135 * x185 + x225 * x267
    x281 = x43 * (x134 * x197 + x228 * x255)
    x282 = x195 + x230 * x267
    x283 = x43 * (x215 + x233 * x255)
    x284 = x201 * x273 + x208 * x43
    x285 = x237 * x255
    x286 = x243 * x255
    x287 = 5.0 * x217
    x288 = x286 + x287
    x289 = 4.0 * x224 + x245 * x255
    x290 = 3.0 * x229
    x291 = x247 * x255 + x290
    x292 = x134 * x233 + x249 * x255
    x293 = x237 + x252 * x255
    x294 = -x89 - A[2]
    x295 = x102 * x294 + x51
    x296 = x43 * (x104 * x294 + x63)
    x297 = x129 * x294
    x298 = x137 * x294 + x81
    x299 = x139 * x294 + x87
    x300 = 2.0 * x105 + x152 * x294
    x301 = x43 * (2.0 * x113 + x158 * x294)
    x302 = 3.0 * x301
    x303 = x294 * x4
    x304 = x168 * x303
    x305 = x128 + x184 * x294
    x306 = x132 * x43 + x181 * x303
    x307 = x134 * x306
    x308 = x193 * x294 + x269
    x309 = x294 * x66
    x310 = x142 + x146 * x309
    x311 = x134 * x310
    x312 = x160 + x206 * x294
    x313 = x43 * (x135 * x165 + x208 * x294)
    x314 = x217 * x294
    x315 = x43 * (x178 + x223 * x294)
    x316 = x173 * x43 + x225 * x303
    x317 = x43 * (2.0 * x191 + x228 * x294)
    x318 = x186 + x230 * x303
    x319 = x43 * (x135 * x197 + x233 * x294)
    x320 = x135 * x194 + x201 * x309
    x321 = x43 * (4.0 * x215 + x236 * x294)
    x322 = x208 * x88 + x238 * x303
    x323 = x217 + x245 * x294
    x324 = 2.0 * x224 + x247 * x294
    x325 = x249 * x294 + x290
    x326 = x233 * x88 + x252 * x294
    x327 = 5.0 * x237 + x253 * x294
    x328 = x255**2
    x329 = x294 * x51
    x330 = x134 * x299
    x331 = 3.0 * x317
    x332 = x294**2

    # 126 item(s)
    return numpy.array(
        [
            x3 * (x42 + x52) + 5.0 * x43 * (x3 * x50 + 4.0 * x63) + x62,
            x3 * (x79 + x82) + x86 + x88 * (x3 * x80 + 3.0 * x87),
            x112 + x3 * (x103 + x106) + x88 * (x104 * x3 + 3.0 * x113),
            x133 + x135 * (x127 * x3 + x132 * x134) + x3 * (x124 + x129),
            x135 * (x139 * x3 + x142) + x141 + x3 * (x135 * x139 + x137 * x3),
            x135 * (x134 * x165 + x158 * x3) + x166 + x3 * (x153 + x160),
            x134 * (x168 * x179 + x178) + x177 + x3 * (x134 * x173 + x172),
            x134 * (x179 * x181 + x191) + x190 + x3 * (x184 * x3 + x186),
            x134 * (x146 * x200 + x197 * x43) + x199 + x3 * (x193 * x3 + x195),
            x134 * (x179 * x202 + x215) + x214 + x3 * (x134 * x208 + x207),
            x217 * x3 + x222 + x3 * (x217 + x219),
            x224 * x3 + x227 + x3 * (x179 * x225 + x224),
            x229 * x3 + x232 + x3 * (x179 * x230 + x229),
            x234 * x3 + x235 + x3 * (x200 * x201 + x234),
            x237 * x3 + x241 + x3 * (x237 + x239),
            x242 * x243 + x244,
            x242 * x245 + x246,
            x242 * x247 + x248,
            x242 * x249 + x250,
            x242 * x252 + x251,
            x242 * x253 + x254,
            x255 * x42 + x255 * x52,
            x257 * x3 + x258 * x88,
            x103 * x255 + x106 * x255,
            x261 * x3 + x262,
            x135 * x264 + x263 * x3,
            x153 * x255 + x160 * x255,
            x134 * x268 + x266 * x3,
            x134 * x271 + x270 * x3,
            x272 * x3 + x274,
            x134 * x275 + x207 * x255,
            x276 + x278 * x3,
            x279 + x280 * x3,
            x281 + x282 * x3,
            x283 + x284 * x3,
            x239 * x255 + x285,
            x288 * x3,
            x289 * x3,
            x291 * x3,
            x292 * x3,
            x293 * x3,
            x253 * x255 * x3,
            x294 * x42 + x294 * x52,
            x294 * x79 + x294 * x82,
            x295 * x3 + 4.0 * x296,
            x124 * x294 + x297,
            x135 * x299 + x298 * x3,
            x3 * x300 + x302,
            x134 * x304 + x172 * x294,
            x3 * x305 + x307,
            x3 * x308 + x311,
            x3 * x312 + 2.0 * x313,
            x219 * x294 + x314,
            x3 * x316 + x315,
            x3 * x318 + x317,
            x3 * x320 + x319,
            x3 * x322 + x321,
            x243 * x294 * x3,
            x3 * x323,
            x3 * x324,
            x3 * x325,
            x3 * x326,
            x3 * x327,
            x328 * x41 + x62,
            x255 * x257 + x255 * x51 + x86,
            x102 * x328 + x112,
            x133 + x134 * x258 + x255 * x261,
            x105 * x255 + x141 + x255 * x263,
            x152 * x328 + x166,
            x177 + x255 * x266 + x262,
            x134 * x264 + x190 + x255 * x270,
            x159 * x255 + x199 + x255 * x272,
            x206 * x328 + x214,
            x222 + x255 * x278 + x268 * x88,
            x135 * x271 + x227 + x255 * x280,
            x232 + x255 * x282 + x274,
            x235 + x255 * x284 + x275 * x43,
            x238 * x328 * x4 + x241,
            x244 + x255 * x288 + 5.0 * x276,
            x246 + x255 * x289 + 4.0 * x279,
            x248 + x255 * x291 + 3.0 * x281,
            x250 + x255 * x292 + 2.0 * x283,
            x251 + x255 * x293 + x285,
            x253 * x328 + x254,
            x255 * x294 * x41,
            x256 * x294 + x329,
            x255 * x295,
            x259 * x294 + x260 * x294,
            x255 * x298 + x296,
            x255 * x300,
            x265 * x294 + x297,
            x255 * x305 + x330,
            x255 * x308 + x301,
            x255 * x312,
            x277 * x294 + x304 * x88,
            x135 * x306 + x255 * x316,
            x255 * x318 + x311,
            x255 * x320 + x313,
            x255 * x322,
            x286 * x294 + x287 * x294,
            x255 * x323 + 4.0 * x315,
            x255 * x324 + x331,
            x255 * x325 + 2.0 * x319,
            x255 * x326 + x321,
            x255 * x327,
            x332 * x41 + x62,
            x332 * x78 + x86,
            x112 + x294 * x295 + x329,
            x123 * x332 + x133,
            x141 + x294 * x298 + x294 * x81,
            x166 + x294 * x300 + 2.0 * x296,
            x171 * x332 + x177,
            x128 * x294 + x190 + x294 * x305,
            x199 + x294 * x308 + x330,
            x214 + x294 * x312 + x302,
            x218 * x332 * x4 + x222,
            x227 + x294 * x316 + x304 * x43,
            x232 + x294 * x318 + x307,
            x135 * x310 + x235 + x294 * x320,
            x241 + x294 * x322 + 4.0 * x313,
            x243 * x332 + x244,
            x246 + x294 * x323 + x314,
            x248 + x294 * x324 + 2.0 * x315,
            x250 + x294 * x325 + x331,
            x251 + x294 * x326 + 4.0 * x319,
            x254 + x294 * x327 + 5.0 * x321,
        ]
    )


def _2center2el3d_30(a, A, b, B):
    """Cartesian (f|s) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = x2 * (a * A[0] + b * B[0]) - A[0]
    x4 = a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x5 = 17.4934183276249
    x6 = 2.0 * x0 * x5
    x7 = x1 ** (-1.5) * x6 * boys(2, x4)
    x8 = b ** (-1.0)
    x9 = x1 ** (-0.5)
    x10 = boys(1, x4)
    x11 = 0.5 * x0 * (2.0 * x0 * x10 * x5 * x8 * x9 - x7)
    x12 = x6 * x8 * x9 * boys(3, x4)
    x13 = x12 * x3**2
    x14 = x2 * (a * A[1] + b * B[1]) - A[1]
    x15 = x0 * (2.0 * x0 * x10 * x14 * x5 * x8 * x9 - x14 * x7)
    x16 = x2 * (a * A[2] + b * B[2]) - A[2]
    x17 = x0 * (2.0 * x0 * x10 * x16 * x5 * x8 * x9 - x16 * x7)
    x18 = 0.5 * x17
    x19 = x12 * x14**2
    x20 = x11 + x19
    x21 = x11 + x12 * x16**2

    # 10 item(s)
    return numpy.array(
        [
            x0 * (2.0 * x0 * x10 * x3 * x5 * x8 * x9 - x3 * x7) + x3 * (x11 + x13),
            x13 * x14 + 0.5 * x15,
            x13 * x16 + x18,
            x20 * x3,
            x12 * x14 * x16 * x3,
            x21 * x3,
            x14 * x20 + x15,
            x16 * x19 + x18,
            x14 * x21,
            x16 * x21 + x17,
        ]
    )


def _2center2el3d_31(a, A, b, B):
    """Cartesian (f|p) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = b * x2
    x4 = a * x3 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x5 = boys(2, x4)
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = b ** (-1.0)
    x8 = x1 ** (-0.5)
    x9 = 17.4934183276249
    x10 = 2.0 * x0 * x9
    x11 = x10 * x7 * x8
    x12 = x11 * x6
    x13 = x12 * x5
    x14 = boys(3, x4)
    x15 = x11 * x14
    x16 = -x2 * (a * A[0] + b * B[0])
    x17 = -x16 - A[0]
    x18 = -x16 - B[0]
    x19 = x17 * x18
    x20 = boys(1, x4)
    x21 = x11 * x20 * x6
    x22 = x11 * x5
    x23 = x1 ** (-1.5) * x10
    x24 = 0.5 * x0
    x25 = x24 * (2.0 * x0 * x20 * x7 * x8 * x9 - x23 * x5)
    x26 = x17**2
    x27 = x12 * x14
    x28 = x11 * boys(4, x4)
    x29 = x19 * x28
    x30 = x14 * x23
    x31 = x18 * x30
    x32 = x24 * (2.0 * x0 * x18 * x5 * x7 * x8 * x9 - x31)
    x33 = x17 * x27
    x34 = -x2 * (a * A[1] + b * B[1])
    x35 = -x34 - B[1]
    x36 = x30 * x35
    x37 = x24 * (2.0 * x0 * x35 * x5 * x7 * x8 * x9 - x36)
    x38 = x26 * x28
    x39 = x35 * x38
    x40 = -x2 * (a * A[2] + b * B[2])
    x41 = -x40 - B[2]
    x42 = x30 * x41
    x43 = x24 * (2.0 * x0 * x41 * x5 * x7 * x8 * x9 - x42)
    x44 = x38 * x41
    x45 = -x34 - A[1]
    x46 = x27 * x45
    x47 = x17 * x45
    x48 = x18 * x28 * x47
    x49 = x0 * (2.0 * x0 * x18 * x45 * x5 * x7 * x8 * x9 - x31 * x45)
    x50 = x35 * x45
    x51 = x28 * x50
    x52 = x27 + x51
    x53 = x0 * (x21 + x22 * x35 * x45 - x3 * (x13 + x15 * x50))
    x54 = x0 * (2.0 * x0 * x41 * x45 * x5 * x7 * x8 * x9 - x42 * x45)
    x55 = -x40 - A[2]
    x56 = x27 * x55
    x57 = x0 * (2.0 * x0 * x18 * x5 * x55 * x7 * x8 * x9 - x31 * x55)
    x58 = 0.5 * x57
    x59 = x0 * (2.0 * x0 * x35 * x5 * x55 * x7 * x8 * x9 - x36 * x55)
    x60 = 0.5 * x59
    x61 = x41 * x55
    x62 = x27 + x28 * x61
    x63 = x0 * (x21 + x22 * x41 * x55 - x3 * (x13 + x15 * x61))
    x64 = 0.5 * x63
    x65 = x45**2
    x66 = x6 * (x15 * x65 + x25)
    x67 = x28 * x65
    x68 = x18 * x67
    x69 = x32 + x68
    x70 = x37 + x45 * x52 + x46
    x71 = x41 * x67 + x43
    x72 = x46 * x55
    x73 = x51 * x55 + x56
    x74 = x55**2
    x75 = x6 * (x15 * x74 + x25)
    x76 = x28 * x74
    x77 = x18 * x76 + x32
    x78 = x35 * x76 + x37
    x79 = x43 + x55 * x62 + x56

    # 30 item(s)
    return numpy.array(
        [
            x0 * (x17 * x18 * x22 + x21 - x3 * (x13 + x15 * x19))
            + x17 * (x17 * (x27 + x29) + x32 + x33)
            + x6 * (x15 * x26 + x25),
            x0 * (2.0 * x0 * x17 * x35 * x5 * x7 * x8 * x9 - x17 * x36)
            + x17 * (x37 + x39),
            x0 * (2.0 * x0 * x17 * x41 * x5 * x7 * x8 * x9 - x17 * x42)
            + x17 * (x43 + x44),
            x17 * (x46 + x48) + x27 * x47 + 0.5 * x49,
            x26 * x52 + 0.5 * x53,
            x44 * x45 + 0.5 * x54,
            x17 * (x29 * x55 + x56) + x33 * x55 + x58,
            x39 * x55 + x60,
            x26 * x62 + x64,
            x17 * x69 + x66,
            x17 * x70,
            x17 * x71,
            x48 * x55 + x72,
            x17 * x73,
            x47 * x62,
            x17 * x77 + x75,
            x17 * x78,
            x17 * x79,
            x45 * x69 + x49,
            x45 * x70 + x53 + x66,
            x45 * x71 + x54,
            x55 * x68 + x58,
            x45 * x73 + x60 + x72,
            x62 * x65 + x64,
            x45 * x77,
            x45 * x78 + x75,
            x45 * x79,
            x55 * x77 + x57,
            x55 * x78 + x59,
            x55 * x79 + x63 + x75,
        ]
    )


def _2center2el3d_32(a, A, b, B):
    """Cartesian (f|d) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = b * x2
    x6 = a * x5 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x7 = boys(2, x6)
    x8 = x1 ** (-1.5)
    x9 = b ** (-1.0)
    x10 = 17.4934183276249
    x11 = x10 * x9
    x12 = 2.0 * x11
    x13 = x12 * x8
    x14 = x1 ** (-0.5)
    x15 = 0.5 * x9
    x16 = x15 * (2.0 * x0 * x10 * x14 * x9 * boys(1, x6) - x13 * x7)
    x17 = -x3 - B[0]
    x18 = x17**2
    x19 = boys(3, x6)
    x20 = x0 * x14
    x21 = x12 * x20
    x22 = x19 * x21
    x23 = x16 + x18 * x22
    x24 = x15 * (2.0 * x0 * x10 * x14 * x7 * x9 - x13 * x19)
    x25 = boys(4, x6)
    x26 = x18 * x21
    x27 = x24 + x25 * x26
    x28 = x17 * x19
    x29 = (2.0 * a + 2.0 * b) ** (-1.0)
    x30 = x11 * x20
    x31 = 4.0 * x29 * x30
    x32 = x17 * x7
    x33 = x15 * (2.0 * x0 * x10 * x14 * x19 * x9 - x13 * x25)
    x34 = boys(5, x6)
    x35 = x26 * x34 + x33
    x36 = x35 * x4
    x37 = x17 * x25
    x38 = x31 * x37
    x39 = x27 * x5
    x40 = 0.5 * x0
    x41 = x40 * (x23 - x39)
    x42 = 2.0 * x29
    x43 = x30 * x42
    x44 = x19 * x43
    x45 = x21 * x37
    x46 = x4 * x45
    x47 = x44 + x46
    x48 = 2.0 * x0 * x10 * x8
    x49 = x40 * (2.0 * x0 * x10 * x14 * x17 * x7 * x9 - x28 * x48)
    x50 = -x2 * (a * A[1] + b * B[1])
    x51 = -x50 - B[1]
    x52 = x44 * x51
    x53 = x43 * x7
    x54 = x51 * x53
    x55 = x17 * x22
    x56 = x51 * x55
    x57 = x19 * x48
    x58 = x40 * (2.0 * x0 * x10 * x14 * x51 * x7 * x9 - x51 * x57)
    x59 = x25 * x51
    x60 = x4**2
    x61 = x21 * x60
    x62 = x43 * x59
    x63 = x21 * x34
    x64 = x17 * x63
    x65 = x4 * x64
    x66 = x51 * x65
    x67 = x37 * x48
    x68 = x51 * x67
    x69 = x40 * (2.0 * x0 * x10 * x14 * x17 * x19 * x51 * x9 - x68)
    x70 = x4 * x62
    x71 = -x2 * (a * A[2] + b * B[2])
    x72 = -x71 - B[2]
    x73 = x44 * x72
    x74 = x53 * x72
    x75 = x55 * x72
    x76 = x40 * (2.0 * x0 * x10 * x14 * x7 * x72 * x9 - x57 * x72)
    x77 = x25 * x72
    x78 = x43 * x77
    x79 = x67 * x72
    x80 = x40 * (2.0 * x0 * x10 * x14 * x17 * x19 * x72 * x9 - x79)
    x81 = x51**2
    x82 = x16 + x22 * x81
    x83 = x21 * x81
    x84 = x24 + x25 * x83
    x85 = x5 * x84
    x86 = x33 + x34 * x83
    x87 = x60 * x86
    x88 = x40 * (x82 - x85)
    x89 = x59 * x72
    x90 = x48 * x89
    x91 = x40 * (2.0 * x0 * x10 * x14 * x19 * x51 * x72 * x9 - x90)
    x92 = x51 * x72
    x93 = x72**2
    x94 = x16 + x22 * x93
    x95 = x21 * x93
    x96 = x24 + x25 * x95
    x97 = x5 * x96
    x98 = x33 + x34 * x95
    x99 = x60 * x98
    x100 = x40 * (x94 - x97)
    x101 = -x50 - A[1]
    x102 = x101 * x36
    x103 = x101 * x38
    x104 = x0 * (x101 * x23 - x101 * x39)
    x105 = x101 * x44
    x106 = x101 * x4
    x107 = x21 * x59
    x108 = x101 * x107
    x109 = x108 + x44
    x110 = x109 * x29
    x111 = x37 * x43
    x112 = x101 * x51
    x113 = x112 * x64
    x114 = x111 + x113
    x115 = x28 * x43
    x116 = x32 * x43
    x117 = x0 * (x101 * x56 + x116 - x5 * (x112 * x45 + x115))
    x118 = x101 * x78
    x119 = x64 * x72
    x120 = x0 * (2.0 * x0 * x10 * x101 * x14 * x17 * x19 * x72 * x9 - x101 * x79)
    x121 = x101 * x86
    x122 = x31 * x59
    x123 = x121 + x122
    x124 = x31 * x51
    x125 = x0 * (x101 * x82 + x124 * x7 - x5 * (x101 * x84 + x124 * x19))
    x126 = x63 * x92
    x127 = x101 * x126 + x78
    x128 = x21 * x89
    x129 = x22 * x92
    x130 = x0 * (x101 * x129 - x5 * (x101 * x128 + x73) + x74)
    x131 = x0 * (x101 * x94 - x101 * x97)
    x132 = -x71 - A[2]
    x133 = x0 * (x132 * x23 - x132 * x39)
    x134 = 0.5 * x133
    x135 = x132 * x44
    x136 = x132 * x62
    x137 = x0 * (2.0 * x0 * x10 * x132 * x14 * x17 * x19 * x51 * x9 - x132 * x68)
    x138 = 0.5 * x137
    x139 = x21 * x77
    x140 = x132 * x139 + x44
    x141 = x140 * x29
    x142 = x132 * x72
    x143 = x111 + x142 * x64
    x144 = x143 * x4
    x145 = x0 * (x116 + x132 * x75 - x5 * (x115 + x142 * x45))
    x146 = 0.5 * x145
    x147 = x0 * (x132 * x82 - x132 * x85)
    x148 = 0.5 * x147
    x149 = x126 * x132 + x62
    x150 = x0 * (x129 * x132 - x5 * (x128 * x132 + x52) + x54)
    x151 = 0.5 * x150
    x152 = x132 * x98 + x31 * x77
    x153 = x31 * x72
    x154 = x0 * (x132 * x94 + x153 * x7 - x5 * (x132 * x96 + x153 * x19))
    x155 = 0.5 * x154
    x156 = x101**2
    x157 = x156 * x35
    x158 = x157 + x41
    x159 = x29 * (x156 * x45 + x49)
    x160 = x29 * (x101 * x109 + x105 + x58)
    x161 = x101 * x111
    x162 = x101 * x114 + x161 + x69
    x163 = x29 * (x139 * x156 + x76)
    x164 = x119 * x156 + x80
    x165 = x101 * x123 + 2.0 * x110 + x88
    x166 = x101 * x127 + x118 + x91
    x167 = x100 + x156 * x98
    x168 = x29 * (x108 * x132 + x135)
    x169 = x111 * x132
    x170 = x113 * x132 + x169
    x171 = x101 * x141
    x172 = x121 * x132 + x122 * x132
    x173 = x101 * x149 + x141
    x174 = x132**2
    x175 = x174 * x35 + x41
    x176 = x29 * (x174 * x45 + x49)
    x177 = x29 * (x107 * x174 + x58)
    x178 = x174 * x51 * x64 + x69
    x179 = x29 * (x132 * x140 + x135 + x76)
    x180 = x132 * x143 + x169 + x80
    x181 = x174 * x86 + x88
    x182 = x132 * x149 + x136 + x91
    x183 = x100 + x132 * x152 + 2.0 * x141

    # 60 item(s)
    return numpy.array(
        [
            x0 * (x23 * x4 + x31 * x32 - x5 * (x27 * x4 + x28 * x31))
            + x4 * (x4 * (x36 + x38) + x41 + x42 * x47)
            + x42 * (x4 * x44 + x4 * x47 + x49),
            x0 * (x4 * x56 - x5 * (x46 * x51 + x52) + x54)
            + x29 * (x58 + x59 * x61)
            + x4 * (x4 * (x62 + x66) + x69 + x70),
            x0 * (x4 * x75 - x5 * (x46 * x72 + x73) + x74)
            + x29 * (x61 * x77 + x76)
            + x4 * (x4 * x78 + x4 * (x65 * x72 + x78) + x80),
            x0 * (x4 * x82 - x4 * x85) + x4 * (x87 + x88),
            x0 * (2.0 * x0 * x10 * x14 * x19 * x4 * x51 * x72 * x9 - x4 * x90)
            + x4 * (x34 * x61 * x92 + x91),
            x0 * (x4 * x94 - x4 * x97) + x4 * (x100 + x99),
            0.5 * x104 + x4 * (x102 + x103) + x42 * (x105 + x106 * x45),
            x110 * x4 + 0.5 * x117 + x4 * (x110 + x114 * x4),
            x106 * x78 + 0.5 * x120 + x4 * (x106 * x119 + x118),
            x123 * x60 + 0.5 * x125,
            x127 * x60 + 0.5 * x130,
            x101 * x99 + 0.5 * x131,
            x134 + x4 * (x132 * x36 + x132 * x38) + x42 * (x132 * x46 + x135),
            x132 * x70 + x138 + x4 * (x132 * x66 + x136),
            x141 * x4 + x146 + x4 * (x141 + x144),
            x132 * x87 + x148,
            x149 * x60 + x151,
            x152 * x60 + x155,
            x158 * x4 + 2.0 * x159,
            x160 + x162 * x4,
            x163 + x164 * x4,
            x165 * x4,
            x166 * x4,
            x167 * x4,
            x102 * x132 + x103 * x132,
            x168 + x170 * x4,
            x101 * x144 + x171,
            x172 * x4,
            x173 * x4,
            x106 * x152,
            x175 * x4 + 2.0 * x176,
            x177 + x178 * x4,
            x179 + x180 * x4,
            x181 * x4,
            x182 * x4,
            x183 * x4,
            x101 * x158 + x104,
            x101 * x162 + x117 + x159,
            x101 * x164 + x120,
            x101 * x165 + x125 + 2.0 * x160,
            x101 * x166 + x130 + x163,
            x101 * x167 + x131,
            x132 * x157 + x134,
            x101 * x170 + x132 * x161 + x138,
            x143 * x156 + x146,
            x101 * x172 + x148 + 2.0 * x168,
            x101 * x173 + x151 + x171,
            x152 * x156 + x155,
            x101 * x175,
            x101 * x178 + x176,
            x101 * x180,
            x101 * x181 + 2.0 * x177,
            x101 * x182 + x179,
            x101 * x183,
            x132 * x175 + x133,
            x132 * x178 + x137,
            x132 * x180 + x145 + x176,
            x132 * x181 + x147,
            x132 * x182 + x150 + x177,
            x132 * x183 + x154 + 2.0 * x179,
        ]
    )


def _2center2el3d_33(a, A, b, B):
    """Cartesian (f|f) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = b ** (-1.0)
    x6 = -x3 - B[0]
    x7 = b * x2
    x8 = a * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(3, x8)
    x10 = x1 ** (-1.5)
    x11 = 17.4934183276249
    x12 = x11 * x5
    x13 = 2.0 * x12
    x14 = x10 * x13
    x15 = x14 * x9
    x16 = x1 ** (-0.5)
    x17 = boys(2, x8)
    x18 = 0.5 * x5
    x19 = x18 * (2.0 * x0 * x11 * x16 * x17 * x5 - x15)
    x20 = x6**2
    x21 = boys(4, x8)
    x22 = x0 * x16
    x23 = x13 * x22
    x24 = x21 * x23
    x25 = x20 * x24
    x26 = x19 + x25
    x27 = x26 * x6 + x5 * (2.0 * x0 * x11 * x16 * x17 * x5 * x6 - x15 * x6)
    x28 = (2.0 * a + 2.0 * b) ** (-1.0)
    x29 = x18 * (2.0 * x0 * x11 * x16 * x5 * boys(1, x8) - x14 * x17)
    x30 = x23 * x9
    x31 = x20 * x30 + x29
    x32 = x28 * x31
    x33 = x14 * x21
    x34 = x18 * (2.0 * x0 * x11 * x16 * x5 * x9 - x33)
    x35 = boys(5, x8)
    x36 = x20 * x23
    x37 = x35 * x36
    x38 = x34 + x37
    x39 = x38 * x6 + x5 * (2.0 * x0 * x11 * x16 * x5 * x6 * x9 - x33 * x6)
    x40 = x26 * x28
    x41 = x14 * x35
    x42 = x18 * (2.0 * x0 * x11 * x16 * x21 * x5 - x41)
    x43 = boys(6, x8)
    x44 = x36 * x43
    x45 = x5 * (2.0 * x0 * x11 * x16 * x21 * x5 * x6 - x41 * x6) + x6 * (x42 + x44)
    x46 = x4 * x45
    x47 = x28 * x38
    x48 = 3.0 * x47
    x49 = x39 * x7
    x50 = 0.5 * x0
    x51 = x50 * (x27 - x49)
    x52 = x38 * x4
    x53 = x21 * x6
    x54 = x12 * x22
    x55 = 4.0 * x28 * x54
    x56 = x53 * x55
    x57 = x52 + x56
    x58 = 3.0 * x28
    x59 = x50 * (-x26 * x7 + x31)
    x60 = 2.0 * x28
    x61 = x54 * x60
    x62 = x61 * x9
    x63 = x4 * x6
    x64 = -x2 * (a * A[1] + b * B[1])
    x65 = -x64 - B[1]
    x66 = x5 * (2.0 * x0 * x11 * x16 * x17 * x5 * x65 - x15 * x65)
    x67 = x25 * x65 + 0.5 * x66
    x68 = x5 * (2.0 * x0 * x11 * x16 * x5 * x65 * x9 - x33 * x65)
    x69 = x37 * x65 + 0.5 * x68
    x70 = x53 * x65
    x71 = x55 * x70
    x72 = x6 * x65
    x73 = x55 * x9
    x74 = x72 * x73
    x75 = x5 * (2.0 * x0 * x11 * x16 * x21 * x5 * x65 - x41 * x65)
    x76 = x44 * x65 + 0.5 * x75
    x77 = x4 * x76
    x78 = x35 * x72
    x79 = x55 * x78
    x80 = x69 * x7
    x81 = x50 * (x67 - x80)
    x82 = x21 * x65
    x83 = x61 * x82
    x84 = x35 * x65
    x85 = x23 * x63
    x86 = x84 * x85
    x87 = x83 + x86
    x88 = 2.0 * x0 * x10 * x11
    x89 = x50 * (2.0 * x0 * x11 * x16 * x5 * x6 * x65 * x9 - x70 * x88)
    x90 = -x2 * (a * A[2] + b * B[2])
    x91 = -x90 - B[2]
    x92 = x5 * (2.0 * x0 * x11 * x16 * x17 * x5 * x91 - x15 * x91)
    x93 = 0.5 * x92
    x94 = x25 * x91 + x93
    x95 = x5 * (2.0 * x0 * x11 * x16 * x5 * x9 * x91 - x33 * x91)
    x96 = 0.5 * x95
    x97 = x37 * x91 + x96
    x98 = x56 * x91
    x99 = x6 * x91
    x100 = x73 * x99
    x101 = x5 * (2.0 * x0 * x11 * x16 * x21 * x5 * x91 - x41 * x91)
    x102 = 0.5 * x101
    x103 = x102 + x44 * x91
    x104 = x103 * x4
    x105 = x35 * x99
    x106 = x105 * x55
    x107 = x7 * x97
    x108 = x50 * (-x107 + x94)
    x109 = x21 * x91
    x110 = x109 * x61
    x111 = x85 * x91
    x112 = x111 * x35
    x113 = x110 + x112
    x114 = x88 * x91
    x115 = x50 * (2.0 * x0 * x11 * x16 * x5 * x6 * x9 * x91 - x114 * x53)
    x116 = x65**2
    x117 = x116 * x30 + x29
    x118 = x117 * x28
    x119 = x116 * x24 + x19
    x120 = x119 * x6
    x121 = x119 * x28
    x122 = x116 * x23
    x123 = x122 * x35
    x124 = x123 + x34
    x125 = x4**2
    x126 = x50 * (x117 - x119 * x7)
    x127 = x124 * x28
    x128 = x122 * x43
    x129 = x128 + x42
    x130 = x129 * x63
    x131 = x6 * x7
    x132 = x124 * x131
    x133 = x50 * (x119 * x6 - x132)
    x134 = x127 * x4
    x135 = x65 * x91
    x136 = x24 * x65
    x137 = x50 * (2.0 * x0 * x11 * x16 * x5 * x65 * x9 * x91 - x114 * x82)
    x138 = x84 * x91
    x139 = x138 * x23
    x140 = x138 * x61
    x141 = x50 * (2.0 * x0 * x11 * x16 * x21 * x5 * x6 * x65 * x91 - x114 * x78)
    x142 = x91**2
    x143 = x142 * x30 + x29
    x144 = x143 * x28
    x145 = x142 * x24 + x19
    x146 = x145 * x6
    x147 = x145 * x28
    x148 = x142 * x23
    x149 = x148 * x35 + x34
    x150 = x50 * (x143 - x145 * x7)
    x151 = x149 * x28
    x152 = x148 * x43 + x42
    x153 = x152 * x63
    x154 = x131 * x149
    x155 = x50 * (x145 * x6 - x154)
    x156 = x151 * x4
    x157 = x119 * x65 + x66
    x158 = x124 * x65 + x68
    x159 = x158 * x7
    x160 = x129 * x65 + x75
    x161 = x125 * x160
    x162 = x50 * (x157 - x159)
    x163 = x24 * x91
    x164 = x116 * x163 + x93
    x165 = x123 * x91 + x96
    x166 = x165 * x7
    x167 = x102 + x128 * x91
    x168 = x50 * (x164 - x166)
    x169 = x149 * x65
    x170 = x169 * x7
    x171 = x50 * (x145 * x65 - x170)
    x172 = x152 * x65
    x173 = x145 * x91 + x92
    x174 = x149 * x91 + x95
    x175 = x174 * x7
    x176 = x101 + x152 * x91
    x177 = x125 * x176
    x178 = x50 * (x173 - x175)
    x179 = -x64 - A[1]
    x180 = x179 * x46
    x181 = x179 * x48
    x182 = x0 * (x179 * x27 - x179 * x49)
    x183 = x179 * x76
    x184 = x183 + x47
    x185 = x53 * x61
    x186 = x23 * x78
    x187 = x179 * x186
    x188 = x185 + x187
    x189 = x188 * x60
    x190 = x0 * (x179 * x67 + x32 - x7 * (x179 * x69 + x40))
    x191 = x28 * (x136 * x179 + x62)
    x192 = x0 * (-x107 * x179 + x179 * x94)
    x193 = x110 * x179
    x194 = x124 * x179
    x195 = x55 * x82
    x196 = x194 + x195
    x197 = x196 * x28
    x198 = x129 * x6
    x199 = x179 * x198
    x200 = x199 + x79
    x201 = x0 * (x120 * x179 - x7 * (x194 * x6 + x71) + x74)
    x202 = x110 + x139 * x179
    x203 = x202 * x28
    x204 = x105 * x61
    x205 = x23 * x43 * x72 * x91
    x206 = x179 * x205 + x204
    x207 = x135 * x24 * x6
    x208 = x0 * (x179 * x207 + x62 * x99 - x7 * (x185 * x91 + x187 * x91))
    x209 = x151 * x179
    x210 = x0 * (x145 * x179 * x6 - x154 * x179)
    x211 = x160 * x179
    x212 = 3.0 * x127
    x213 = x211 + x212
    x214 = x0 * (3.0 * x118 + x157 * x179 - x7 * (3.0 * x121 + x158 * x179))
    x215 = x138 * x55
    x216 = x167 * x179 + x215
    x217 = x195 * x91
    x218 = x135 * x73
    x219 = x0 * (x164 * x179 + x218 - x7 * (x165 * x179 + x217))
    x220 = x151 + x172 * x179
    x221 = x145 * x65
    x222 = x0 * (x144 + x179 * x221 - x7 * (x147 + x169 * x179))
    x223 = x0 * (x173 * x179 - x175 * x179)
    x224 = -x90 - A[2]
    x225 = x0 * (x224 * x27 - x224 * x49)
    x226 = 0.5 * x225
    x227 = x224 * x79
    x228 = x0 * (x224 * x67 - x224 * x80)
    x229 = 0.5 * x228
    x230 = x224 * x83
    x231 = x103 * x224 + x47
    x232 = x231 * x4
    x233 = x105 * x23
    x234 = x185 + x224 * x233
    x235 = x234 * x28
    x236 = 2.0 * x235
    x237 = x0 * (x224 * x94 + x32 - x7 * (x224 * x97 + x40))
    x238 = 0.5 * x237
    x239 = x28 * (x163 * x224 + x62)
    x240 = x127 * x224
    x241 = x0 * (x119 * x224 * x6 - x132 * x224)
    x242 = 0.5 * x241
    x243 = x139 * x224 + x83
    x244 = x243 * x28
    x245 = x61 * x78
    x246 = x205 * x224 + x245
    x247 = x0 * (x207 * x224 + x62 * x72 - x7 * (x186 * x224 * x91 + x61 * x70))
    x248 = 0.5 * x247
    x249 = x149 * x224
    x250 = x109 * x55 + x249
    x251 = x250 * x28
    x252 = x152 * x6
    x253 = x106 + x224 * x252
    x254 = x253 * x4
    x255 = x0 * (x100 + x146 * x224 - x7 * (x249 * x6 + x98))
    x256 = 0.5 * x255
    x257 = x0 * (x157 * x224 - x159 * x224)
    x258 = 0.5 * x257
    x259 = x127 + x167 * x224
    x260 = x0 * (x118 + x164 * x224 - x7 * (x121 + x165 * x224))
    x261 = 0.5 * x260
    x262 = x172 * x224 + x215
    x263 = x0 * (x218 + x221 * x224 - x7 * (x217 + x249 * x65))
    x264 = 0.5 * x263
    x265 = 3.0 * x151 + x176 * x224
    x266 = x0 * (3.0 * x144 + x173 * x224 - x7 * (3.0 * x147 + x174 * x224))
    x267 = 0.5 * x266
    x268 = x179**2
    x269 = x268 * x45
    x270 = x269 + x51
    x271 = x28 * (x268 * x38 + x59)
    x272 = x179 * x47
    x273 = x179 * x184 + x272 + x81
    x274 = x60 * (x179 * x185 + x179 * x188 + x89)
    x275 = x103 * x268 + x108
    x276 = x28 * (x115 + x233 * x268)
    x277 = x28 * (x126 + x179 * x196 + 2.0 * x191)
    x278 = x133 + x179 * x200 + x189
    x279 = x28 * (x137 + x179 * x202 + x193)
    x280 = x141 + x179 * x204 + x179 * x206
    x281 = x28 * (x149 * x268 + x150)
    x282 = x155 + x252 * x268
    x283 = x162 + x179 * x213 + 3.0 * x197
    x284 = x168 + x179 * x216 + 2.0 * x203
    x285 = x171 + x179 * x220 + x209
    x286 = x176 * x268 + x178
    x287 = x224 * x47
    x288 = x183 * x224 + x287
    x289 = x185 * x224
    x290 = x60 * (x187 * x224 + x289)
    x291 = x28 * (x194 * x224 + x195 * x224)
    x292 = x199 * x224 + x227
    x293 = x28 * (x179 * x243 + x239)
    x294 = x179 * x246 + x235
    x295 = x179 * x251
    x296 = x211 * x224 + x212 * x224
    x297 = 2.0 * x244
    x298 = x179 * x259 + x297
    x299 = x179 * x262 + x251
    x300 = x224**2
    x301 = x300 * x45 + x51
    x302 = x28 * (x300 * x38 + x59)
    x303 = x300 * x76 + x81
    x304 = x28 * (x186 * x300 + x89)
    x305 = 2.0 * x304
    x306 = x108 + x224 * x231 + x287
    x307 = x28 * (x115 + x224 * x234 + x289)
    x308 = 2.0 * x307
    x309 = x28 * (x124 * x300 + x126)
    x310 = x133 + x198 * x300
    x311 = x28 * (x137 + x224 * x243 + x230)
    x312 = x141 + x224 * x245 + x224 * x246
    x313 = x28 * (x150 + x224 * x250 + 2.0 * x239)
    x314 = x155 + x224 * x253 + x236
    x315 = x160 * x300 + x162
    x316 = x168 + x224 * x259 + x240
    x317 = x171 + x224 * x262 + x297
    x318 = x178 + x224 * x265 + 3.0 * x251
    x319 = 2.0 * x311

    # 100 item(s)
    return numpy.array(
        [
            x0 * (x27 * x4 + 3.0 * x32 - x7 * (x39 * x4 + 3.0 * x40))
            + x4 * (x4 * (x46 + x48) + x51 + x57 * x58)
            + x58 * (x4 * x57 + x59 + x60 * (x24 * x63 + x62)),
            x0 * (x4 * x67 - x7 * (x4 * x69 + x71) + x74)
            + x4 * (x4 * (x77 + x79) + x60 * x87 + x81)
            + x60 * (x4 * x83 + x4 * x87 + x89),
            x0 * (x100 + x4 * x94 - x7 * (x4 * x97 + x98))
            + x4 * (x108 + x113 * x60 + x4 * (x104 + x106))
            + x60 * (x110 * x4 + x113 * x4 + x115),
            x0 * (x118 + x120 * x4 - x7 * (x121 + x124 * x63))
            + x28 * (x124 * x125 + x126)
            + x4 * (x133 + x134 + x4 * (x127 + x130)),
            x0 * (x135 * x62 + x136 * x63 * x91 - x7 * (x83 * x91 + x86 * x91))
            + x28 * (x125 * x139 + x137)
            + x4 * (x140 * x4 + x141 + x4 * (x111 * x43 * x65 + x140)),
            x0 * (x144 + x146 * x4 - x7 * (x147 + x149 * x63))
            + x28 * (x125 * x149 + x150)
            + x4 * (x155 + x156 + x4 * (x151 + x153)),
            x0 * (x157 * x4 - x159 * x4) + x4 * (x161 + x162),
            x0 * (x164 * x4 - x166 * x4) + x4 * (x125 * x167 + x168),
            x0 * (x145 * x4 * x65 - x170 * x4) + x4 * (x125 * x172 + x171),
            x0 * (x173 * x4 - x175 * x4) + x4 * (x177 + x178),
            0.5 * x182 + x4 * (x180 + x181) + x58 * (x179 * x52 + x179 * x56),
            0.5 * x190 + x4 * (x184 * x4 + x189) + x60 * (x188 * x4 + x191),
            0.5 * x192 + x4 * (x104 * x179 + x106 * x179) + x60 * (x112 * x179 + x193),
            x197 * x4 + 0.5 * x201 + x4 * (x197 + x200 * x4),
            x203 * x4 + 0.5 * x208 + x4 * (x203 + x206 * x4),
            x156 * x179 + 0.5 * x210 + x4 * (x153 * x179 + x209),
            x125 * x213 + 0.5 * x214,
            x125 * x216 + 0.5 * x219,
            x125 * x220 + 0.5 * x222,
            x177 * x179 + 0.5 * x223,
            x226 + x4 * (x224 * x46 + x224 * x48) + x58 * (x224 * x52 + x224 * x56),
            x229 + x4 * (x224 * x77 + x227) + x60 * (x224 * x86 + x230),
            x238 + x4 * (x232 + x236) + x60 * (x234 * x4 + x239),
            x134 * x224 + x242 + x4 * (x130 * x224 + x240),
            x244 * x4 + x248 + x4 * (x244 + x246 * x4),
            x251 * x4 + x256 + x4 * (x251 + x254),
            x161 * x224 + x258,
            x125 * x259 + x261,
            x125 * x262 + x264,
            x125 * x265 + x267,
            x270 * x4 + 3.0 * x271,
            x273 * x4 + x274,
            x275 * x4 + 2.0 * x276,
            x277 + x278 * x4,
            x279 + x280 * x4,
            x281 + x282 * x4,
            x283 * x4,
            x284 * x4,
            x285 * x4,
            x286 * x4,
            x180 * x224 + x181 * x224,
            x288 * x4 + x290,
            x179 * x232 + x179 * x236,
            x291 + x292 * x4,
            x293 + x294 * x4,
            x179 * x254 + x295,
            x296 * x4,
            x298 * x4,
            x299 * x4,
            x179 * x265 * x4,
            x301 * x4 + 3.0 * x302,
            x303 * x4 + x305,
            x306 * x4 + x308,
            x309 + x310 * x4,
            x311 + x312 * x4,
            x313 + x314 * x4,
            x315 * x4,
            x316 * x4,
            x317 * x4,
            x318 * x4,
            x179 * x270 + x182,
            x179 * x273 + x190 + x271,
            x179 * x275 + x192,
            x179 * x278 + x201 + x274,
            x179 * x280 + x208 + x276,
            x179 * x282 + x210,
            x179 * x283 + x214 + 3.0 * x277,
            x179 * x284 + x219 + 2.0 * x279,
            x179 * x285 + x222 + x281,
            x179 * x286 + x223,
            x224 * x269 + x226,
            x179 * x288 + x224 * x272 + x229,
            x231 * x268 + x238,
            x179 * x292 + x242 + x290,
            x179 * x235 + x179 * x294 + x248,
            x253 * x268 + x256,
            x179 * x296 + x258 + 3.0 * x291,
            x179 * x298 + x261 + 2.0 * x293,
            x179 * x299 + x264 + x295,
            x265 * x268 + x267,
            x179 * x301,
            x179 * x303 + x302,
            x179 * x306,
            x179 * x310 + x305,
            x179 * x312 + x307,
            x179 * x314,
            x179 * x315 + 3.0 * x309,
            x179 * x316 + x319,
            x179 * x317 + x313,
            x179 * x318,
            x224 * x301 + x225,
            x224 * x303 + x228,
            x224 * x306 + x237 + x302,
            x224 * x310 + x241,
            x224 * x312 + x247 + x304,
            x224 * x314 + x255 + x308,
            x224 * x315 + x257,
            x224 * x316 + x260 + x309,
            x224 * x317 + x263 + x319,
            x224 * x318 + x266 + 3.0 * x313,
        ]
    )


def _2center2el3d_34(a, A, b, B):
    """Cartesian (f|g) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = -x3 - B[0]
    x6 = b ** (-1.0)
    x7 = a * x2
    x8 = b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(4, x8)
    x10 = x1 ** (-1.5)
    x11 = 17.4934183276249
    x12 = x11 * x6
    x13 = 2.0 * x12
    x14 = x10 * x13
    x15 = x14 * x9
    x16 = x15 * x5
    x17 = x1 ** (-0.5)
    x18 = boys(3, x8)
    x19 = 0.5 * x6
    x20 = x19 * (2.0 * x0 * x11 * x17 * x18 * x6 - x15)
    x21 = x5**2
    x22 = boys(5, x8)
    x23 = x0 * x17
    x24 = x13 * x23
    x25 = x22 * x24
    x26 = x21 * x25
    x27 = x20 + x26
    x28 = x27 * x5 + x6 * (2.0 * x0 * x11 * x17 * x18 * x5 * x6 - x16)
    x29 = boys(2, x8)
    x30 = x19 * (2.0 * x0 * x11 * x17 * x6 * boys(1, x8) - x14 * x29)
    x31 = x14 * x18
    x32 = x19 * (2.0 * x0 * x11 * x17 * x29 * x6 - x31)
    x33 = x24 * x9
    x34 = x21 * x33
    x35 = x32 + x34
    x36 = x18 * x24
    x37 = 1.5 * x6
    x38 = x28 * x5 + x37 * (x21 * x36 + x30 - x35 * x7)
    x39 = (2.0 * a + 2.0 * b) ** (-1.0)
    x40 = x35 * x5 + x6 * (2.0 * x0 * x11 * x17 * x29 * x5 * x6 - x31 * x5)
    x41 = x39 * x40
    x42 = x14 * x22
    x43 = x42 * x5
    x44 = x19 * (2.0 * x0 * x11 * x17 * x6 * x9 - x42)
    x45 = boys(6, x8)
    x46 = x21 * x24
    x47 = x45 * x46
    x48 = x44 + x47
    x49 = x48 * x5 + x6 * (2.0 * x0 * x11 * x17 * x5 * x6 * x9 - x43)
    x50 = x37 * (-x27 * x7 + x35) + x49 * x5
    x51 = x28 * x39
    x52 = b * x2
    x53 = x14 * x45
    x54 = x5 * x53
    x55 = x19 * (2.0 * x0 * x11 * x17 * x22 * x6 - x53)
    x56 = boys(7, x8)
    x57 = x46 * x56
    x58 = x37 * (x27 - x48 * x7) + x5 * (
        x5 * (x55 + x57) + x6 * (2.0 * x0 * x11 * x17 * x22 * x5 * x6 - x54)
    )
    x59 = x4 * x58
    x60 = x39 * x49
    x61 = 4.0 * x60
    x62 = x50 * x52
    x63 = 0.5 * x0
    x64 = x63 * (x38 - x62)
    x65 = x4 * x49
    x66 = x27 * x39
    x67 = 3.0 * x66
    x68 = x65 + x67
    x69 = 4.0 * x39
    x70 = x63 * (-x28 * x52 + x40)
    x71 = x12 * x23
    x72 = x71 * x9
    x73 = x5 * x72
    x74 = 3.0 * x39
    x75 = -x2 * (a * A[1] + b * B[1])
    x76 = -x75 - B[1]
    x77 = x5 * x76
    x78 = x15 * x76
    x79 = x6 * (2.0 * x0 * x11 * x17 * x18 * x6 * x76 - x78)
    x80 = x26 * x76
    x81 = 0.5 * x79 + x80
    x82 = x5 * x81 + x6 * (2.0 * x0 * x11 * x17 * x18 * x5 * x6 * x76 - x15 * x77)
    x83 = x6 * (2.0 * x0 * x11 * x17 * x29 * x6 * x76 - x31 * x76)
    x84 = x34 * x76 + 0.5 * x83
    x85 = x39 * x84
    x86 = x42 * x76
    x87 = x6 * (2.0 * x0 * x11 * x17 * x6 * x76 * x9 - x86)
    x88 = x47 * x76
    x89 = 0.5 * x87 + x88
    x90 = x5 * x89 + x6 * (2.0 * x0 * x11 * x17 * x5 * x6 * x76 * x9 - x42 * x77)
    x91 = x39 * x81
    x92 = x53 * x76
    x93 = x6 * (2.0 * x0 * x11 * x17 * x22 * x6 * x76 - x92)
    x94 = x57 * x76
    x95 = x5 * (0.5 * x93 + x94) + x6 * (
        2.0 * x0 * x11 * x17 * x22 * x5 * x6 * x76 - x53 * x77
    )
    x96 = x4 * x95
    x97 = x39 * x89
    x98 = 3.0 * x97
    x99 = x52 * x90
    x100 = x63 * (x82 - x99)
    x101 = x4 * x89
    x102 = x22 * x77
    x103 = x69 * x71
    x104 = x102 * x103
    x105 = x101 + x104
    x106 = x63 * (-x52 * x81 + x84)
    x107 = 2.0 * x39
    x108 = x107 * x72
    x109 = x108 * x76
    x110 = x4 * x5
    x111 = x25 * x76
    x112 = -x2 * (a * A[2] + b * B[2])
    x113 = -x112 - B[2]
    x114 = x6 * (2.0 * x0 * x11 * x113 * x17 * x18 * x6 - x113 * x15)
    x115 = 0.5 * x114
    x116 = x113 * x26 + x115
    x117 = x116 * x5 + x6 * (2.0 * x0 * x11 * x113 * x17 * x18 * x5 * x6 - x113 * x16)
    x118 = x6 * (2.0 * x0 * x11 * x113 * x17 * x29 * x6 - x113 * x31)
    x119 = 0.5 * x118
    x120 = x113 * x34 + x119
    x121 = x120 * x39
    x122 = x6 * (2.0 * x0 * x11 * x113 * x17 * x6 * x9 - x113 * x42)
    x123 = 0.5 * x122
    x124 = x113 * x47 + x123
    x125 = x124 * x5 + x6 * (2.0 * x0 * x11 * x113 * x17 * x5 * x6 * x9 - x113 * x43)
    x126 = x116 * x39
    x127 = x6 * (2.0 * x0 * x11 * x113 * x17 * x22 * x6 - x113 * x53)
    x128 = 0.5 * x127
    x129 = x5 * (x113 * x57 + x128) + x6 * (
        2.0 * x0 * x11 * x113 * x17 * x22 * x5 * x6 - x113 * x54
    )
    x130 = x129 * x4
    x131 = x124 * x39
    x132 = 3.0 * x131
    x133 = x125 * x52
    x134 = x63 * (x117 - x133)
    x135 = x124 * x4
    x136 = x113 * x22
    x137 = x136 * x5
    x138 = x103 * x137
    x139 = x135 + x138
    x140 = x63 * (-x116 * x52 + x120)
    x141 = x108 * x113
    x142 = x113 * x25
    x143 = x76**2
    x144 = x143 * x25 + x20
    x145 = x143 * x33 + x32
    x146 = x143 * x36 - x145 * x7 + x30
    x147 = x144 * x21 + x146 * x19
    x148 = x143 * x24
    x149 = x148 * x45
    x150 = x149 + x44
    x151 = -x144 * x7 + x145
    x152 = x150 * x21 + x151 * x19
    x153 = x144 * x39
    x154 = x153 * x5
    x155 = x145 * x5
    x156 = x148 * x56
    x157 = x156 + x55
    x158 = x144 - x150 * x7
    x159 = x157 * x21 + x158 * x19
    x160 = x159 * x4
    x161 = x150 * x5
    x162 = x107 * x161
    x163 = x152 * x52
    x164 = x63 * (x147 - x163)
    x165 = x110 * x150
    x166 = x153 + x165
    x167 = x5 * x52
    x168 = x63 * (-x144 * x167 + x145 * x5)
    x169 = x6 * (2.0 * x0 * x11 * x113 * x17 * x18 * x6 * x76 - x113 * x78)
    x170 = x113 * x80 + 0.5 * x169
    x171 = x6 * (2.0 * x0 * x11 * x113 * x17 * x6 * x76 * x9 - x113 * x86)
    x172 = x113 * x88 + 0.5 * x171
    x173 = x102 * x113
    x174 = x103 * x173
    x175 = x69 * x72
    x176 = x113 * x175
    x177 = x176 * x77
    x178 = x6 * (2.0 * x0 * x11 * x113 * x17 * x22 * x6 * x76 - x113 * x92)
    x179 = x113 * x94 + 0.5 * x178
    x180 = x113 * x45
    x181 = x103 * x180 * x77
    x182 = x63 * (x170 - x172 * x52)
    x183 = x107 * x71
    x184 = x136 * x76
    x185 = x183 * x184
    x186 = x180 * x24 * x76
    x187 = x110 * x186 + x185
    x188 = x63 * (
        -2.0 * x0 * x10 * x11 * x173 + 2.0 * x0 * x11 * x113 * x17 * x5 * x6 * x76 * x9
    )
    x189 = x113**2
    x190 = x189 * x25 + x20
    x191 = x189 * x33 + x32
    x192 = x189 * x36 - x191 * x7 + x30
    x193 = x19 * x192
    x194 = x190 * x21 + x193
    x195 = x189 * x24
    x196 = x195 * x45 + x44
    x197 = -x190 * x7 + x191
    x198 = x19 * x197
    x199 = x196 * x21 + x198
    x200 = x190 * x39
    x201 = x200 * x5
    x202 = x191 * x5
    x203 = x195 * x56 + x55
    x204 = x190 - x196 * x7
    x205 = x19 * x204
    x206 = x203 * x21 + x205
    x207 = x206 * x4
    x208 = x196 * x5
    x209 = x199 * x52
    x210 = x63 * (x194 - x209)
    x211 = x110 * x196
    x212 = x200 + x211
    x213 = x190 * x5
    x214 = x63 * (x191 * x5 - x213 * x52)
    x215 = x145 * x76 + x83
    x216 = x215 * x39
    x217 = x144 * x76 + x79
    x218 = x217 * x5
    x219 = x217 * x39
    x220 = x150 * x76 + x87
    x221 = x4**2
    x222 = x63 * (x215 - x217 * x52)
    x223 = x220 * x39
    x224 = x157 * x76 + x93
    x225 = x110 * x224
    x226 = x63 * (-x167 * x220 + x217 * x5)
    x227 = x223 * x4
    x228 = x113 * x143 * x33 + x119
    x229 = x228 * x39
    x230 = x115 + x142 * x143
    x231 = x230 * x5
    x232 = x230 * x39
    x233 = x113 * x149 + x123
    x234 = x63 * (x228 - x230 * x52)
    x235 = x233 * x39
    x236 = x113 * x156 + x128
    x237 = x63 * (-x167 * x233 + x230 * x5)
    x238 = x191 * x76
    x239 = x200 * x76
    x240 = x190 * x76
    x241 = x63 * (x191 * x76 - x240 * x52)
    x242 = x196 * x76
    x243 = x242 * x39
    x244 = x203 * x76
    x245 = x63 * (-x167 * x242 + x190 * x5 * x76)
    x246 = x113 * x191 + x118
    x247 = x246 * x39
    x248 = x113 * x190 + x114
    x249 = x248 * x5
    x250 = x248 * x39
    x251 = x113 * x196 + x122
    x252 = x63 * (x246 - x248 * x52)
    x253 = x251 * x39
    x254 = x113 * x203 + x127
    x255 = x110 * x254
    x256 = x63 * (-x167 * x251 + x248 * x5)
    x257 = x253 * x4
    x258 = x146 * x37 + x217 * x76
    x259 = x151 * x37 + x220 * x76
    x260 = x259 * x52
    x261 = x158 * x37 + x224 * x76
    x262 = x221 * x261
    x263 = x63 * (x258 - x260)
    x264 = x169 + x230 * x76
    x265 = x171 + x233 * x76
    x266 = x265 * x52
    x267 = x178 + x236 * x76
    x268 = x63 * (x264 - x266)
    x269 = x143 * x190 + x193
    x270 = x143 * x196 + x198
    x271 = x270 * x52
    x272 = x143 * x203 + x205
    x273 = x63 * (x269 - x271)
    x274 = x251 * x76
    x275 = x274 * x52
    x276 = x63 * (x248 * x76 - x275)
    x277 = x254 * x76
    x278 = x113 * x248 + x192 * x37
    x279 = x113 * x251 + x197 * x37
    x280 = x279 * x52
    x281 = x113 * x254 + x204 * x37
    x282 = x221 * x281
    x283 = x63 * (x278 - x280)
    x284 = -x75 - A[1]
    x285 = x284 * x59
    x286 = x284 * x61
    x287 = x0 * (x284 * x38 - x284 * x62)
    x288 = x284 * x95
    x289 = x288 + x60
    x290 = x284 * x89
    x291 = x290 + x66
    x292 = x0 * (x284 * x82 + x41 - x52 * (x284 * x90 + x51))
    x293 = x107 * x73
    x294 = x284 * x5
    x295 = x107 * (x111 * x294 + x293)
    x296 = x0 * (x117 * x284 - x133 * x284)
    x297 = x136 * x294
    x298 = x159 * x284
    x299 = 2.0 * x97
    x300 = x298 + x299
    x301 = x150 * x294
    x302 = x104 + x301
    x303 = x0 * (x147 * x284 - x52 * (x152 * x284 + 2.0 * x91) + 2.0 * x85)
    x304 = x39 * (x144 * x284 + x175 * x76)
    x305 = x131 + x179 * x284
    x306 = x137 * x183 + x186 * x294
    x307 = x107 * x306
    x308 = x0 * (x121 + x170 * x284 - x52 * (x126 + x172 * x284))
    x309 = x111 * x113
    x310 = x39 * (x141 + x284 * x309)
    x311 = x196 * x294
    x312 = x0 * (x194 * x284 - x209 * x284)
    x313 = x200 * x284
    x314 = x220 * x284
    x315 = 3.0 * x153
    x316 = x314 + x315
    x317 = x316 * x39
    x318 = x224 * x294
    x319 = x161 * x74
    x320 = x318 + x319
    x321 = x0 * (x155 * x74 + x218 * x284 - x52 * (x314 * x5 + x315 * x5))
    x322 = x233 * x284
    x323 = x103 * x184
    x324 = x322 + x323
    x325 = x324 * x39
    x326 = x181 + x236 * x294
    x327 = x0 * (x177 + x231 * x284 - x52 * (x174 + x322 * x5))
    x328 = x200 + x242 * x284
    x329 = x328 * x39
    x330 = x208 * x39 + x244 * x294
    x331 = x0 * (x202 * x39 + x213 * x284 * x76 - x52 * (x201 + x242 * x294))
    x332 = x253 * x284
    x333 = x0 * (x248 * x284 * x5 - x251 * x294 * x52)
    x334 = x261 * x284
    x335 = 4.0 * x223
    x336 = x334 + x335
    x337 = x0 * (4.0 * x216 + x258 * x284 - x52 * (4.0 * x219 + x259 * x284))
    x338 = 3.0 * x235 + x267 * x284
    x339 = x0 * (3.0 * x229 + x264 * x284 - x52 * (3.0 * x232 + x265 * x284))
    x340 = x107 * x242 + x272 * x284
    x341 = x0 * (x107 * x238 + x269 * x284 - x52 * (2.0 * x239 + x270 * x284))
    x342 = x253 + x277 * x284
    x343 = x248 * x76
    x344 = x0 * (x247 + x284 * x343 - x52 * (x250 + x274 * x284))
    x345 = x0 * (x278 * x284 - x280 * x284)
    x346 = -x112 - A[2]
    x347 = x0 * (x346 * x38 - x346 * x62)
    x348 = 0.5 * x347
    x349 = x0 * (x346 * x82 - x346 * x99)
    x350 = 0.5 * x349
    x351 = x346 * x5
    x352 = x22 * x351 * x76
    x353 = x103 * x352
    x354 = x129 * x346 + x60
    x355 = x354 * x4
    x356 = x124 * x346 + x66
    x357 = x356 * x39
    x358 = 3.0 * x357
    x359 = x0 * (x117 * x346 + x41 - x52 * (x125 * x346 + x51))
    x360 = 0.5 * x359
    x361 = x39 * (x142 * x351 + x293)
    x362 = 2.0 * x361
    x363 = x0 * (x147 * x346 - x163 * x346)
    x364 = 0.5 * x363
    x365 = x153 * x346
    x366 = x179 * x346 + x97
    x367 = x102 * x183 + x186 * x351
    x368 = x107 * x367
    x369 = x0 * (x170 * x346 - x52 * (x172 * x346 + x91) + x85)
    x370 = 0.5 * x369
    x371 = x39 * (x109 + x309 * x346)
    x372 = 2.0 * x131 + x206 * x346
    x373 = x372 * x4
    x374 = x138 + x208 * x346
    x375 = x374 * x39
    x376 = 2.0 * x375
    x377 = x0 * (2.0 * x121 + x194 * x346 - x52 * (2.0 * x126 + x199 * x346))
    x378 = 0.5 * x377
    x379 = x190 * x346
    x380 = x39 * (x176 + x379)
    x381 = x223 * x346
    x382 = x0 * (x217 * x346 * x5 - x220 * x351 * x52)
    x383 = 0.5 * x382
    x384 = x233 * x346
    x385 = x153 + x384
    x386 = x385 * x39
    x387 = x161 * x39
    x388 = x236 * x351 + x387
    x389 = x0 * (x155 * x39 + x231 * x346 - x52 * (x154 + x384 * x5))
    x390 = 0.5 * x389
    x391 = x242 * x346 + x323
    x392 = x39 * x391
    x393 = x181 + x244 * x351
    x394 = x0 * (x177 + x379 * x77 - x52 * (x174 + x242 * x351))
    x395 = 0.5 * x394
    x396 = x251 * x346
    x397 = 3.0 * x200 + x396
    x398 = x39 * x397
    x399 = x208 * x74 + x254 * x351
    x400 = x399 * x4
    x401 = x0 * (x202 * x74 + x249 * x346 - x52 * (3.0 * x201 + x396 * x5))
    x402 = 0.5 * x401
    x403 = x0 * (x258 * x346 - x260 * x346)
    x404 = 0.5 * x403
    x405 = x223 + x267 * x346
    x406 = x0 * (x216 + x264 * x346 - x52 * (x219 + x265 * x346))
    x407 = 0.5 * x406
    x408 = 2.0 * x235 + x272 * x346
    x409 = x0 * (2.0 * x229 + x269 * x346 - x52 * (2.0 * x232 + x270 * x346))
    x410 = 0.5 * x409
    x411 = x242 * x74 + x277 * x346
    x412 = x0 * (x238 * x74 + x343 * x346 - x52 * (3.0 * x239 + x396 * x76))
    x413 = 0.5 * x412
    x414 = 4.0 * x253 + x281 * x346
    x415 = x0 * (4.0 * x247 + x278 * x346 - x52 * (4.0 * x250 + x279 * x346))
    x416 = 0.5 * x415
    x417 = x284**2
    x418 = x417 * x58
    x419 = x418 + x64
    x420 = x39 * (x417 * x49 + x70)
    x421 = x284 * x60
    x422 = x100 + x284 * x289 + x421
    x423 = x106 + x284 * x291 + x284 * x66
    x424 = x129 * x417 + x134
    x425 = x39 * (x124 * x417 + x140)
    x426 = x107 * x291 + x164 + x284 * x300
    x427 = x168 + x284 * x302 + x295
    x428 = x131 * x284 + x182 + x284 * x305
    x429 = x107 * (x183 * x297 + x188 + x284 * x306)
    x430 = x206 * x417 + x210
    x431 = x39 * (x208 * x417 + x214)
    x432 = x39 * (x222 + x284 * x316 + 3.0 * x304)
    x433 = x226 + x284 * x320 + x302 * x74
    x434 = x39 * (x234 + x284 * x324 + 2.0 * x310)
    x435 = x237 + x284 * x326 + x307
    x436 = x39 * (x241 + x284 * x328 + x313)
    x437 = x245 + x284 * x330 + x311 * x39
    x438 = x39 * (x251 * x417 + x252)
    x439 = x254 * x417 * x5 + x256
    x440 = x263 + x284 * x336 + 4.0 * x317
    x441 = x268 + x284 * x338 + 3.0 * x325
    x442 = x273 + x284 * x340 + 2.0 * x329
    x443 = x276 + x284 * x342 + x332
    x444 = x281 * x417 + x283
    x445 = x346 * x60
    x446 = x288 * x346 + x445
    x447 = x346 * x66
    x448 = x290 * x346 + x447
    x449 = x298 * x346 + x299 * x346
    x450 = x301 * x346 + x353
    x451 = x284 * x366 + x357
    x452 = x107 * (x284 * x367 + x361)
    x453 = x39 * (x314 * x346 + x315 * x346)
    x454 = x318 * x346 + x319 * x346
    x455 = 2.0 * x371
    x456 = x39 * (x284 * x385 + x455)
    x457 = x284 * x388 + x368
    x458 = x39 * (x284 * x391 + x380)
    x459 = x284 * x393 + x375
    x460 = x284 * x398
    x461 = x334 * x346 + x335 * x346
    x462 = x284 * x405 + 3.0 * x386
    x463 = x284 * x408 + 2.0 * x392
    x464 = x284 * x411 + x398
    x465 = x346**2
    x466 = x465 * x58 + x64
    x467 = x39 * (x465 * x49 + x70)
    x468 = x100 + x465 * x95
    x469 = x39 * (x106 + x465 * x89)
    x470 = x134 + x346 * x354 + x445
    x471 = x39 * (x140 + x346 * x356 + x447)
    x472 = x159 * x465 + x164
    x473 = x39 * (x161 * x465 + x168)
    x474 = x182 + x346 * x366 + x346 * x97
    x475 = x107 * (x183 * x352 + x188 + x346 * x367)
    x476 = x210 + x346 * x372 + 2.0 * x357
    x477 = x39 * (x214 + x346 * x374 + x362)
    x478 = x39 * (x220 * x465 + x222)
    x479 = x224 * x465 * x5 + x226
    x480 = x39 * (x234 + x346 * x385 + x365)
    x481 = x237 + x346 * x387 + x346 * x388
    x482 = x39 * (x241 + x346 * x391 + x455)
    x483 = x245 + x346 * x393 + x368
    x484 = x39 * (x252 + x346 * x397 + 3.0 * x380)
    x485 = x256 + x346 * x399 + 3.0 * x375
    x486 = x261 * x465 + x263
    x487 = x268 + x346 * x405 + x381
    x488 = x273 + x346 * x408 + 2.0 * x386
    x489 = x276 + x346 * x411 + 3.0 * x392
    x490 = x283 + x346 * x414 + 4.0 * x398

    # 150 item(s)
    return numpy.array(
        [
            x0 * (x38 * x4 + 4.0 * x41 - x52 * (x4 * x50 + 4.0 * x51))
            + x4 * (x4 * (x59 + x61) + x64 + x68 * x69)
            + x69 * (x4 * x68 + x70 + x74 * (x27 * x4 + x69 * x73)),
            x0 * (x4 * x82 - x52 * (x4 * x90 + 3.0 * x91) + 3.0 * x85)
            + x4 * (x100 + x105 * x74 + x4 * (x96 + x98))
            + x74 * (x105 * x4 + x106 + x107 * (x109 + x110 * x111)),
            x0 * (x117 * x4 + 3.0 * x121 - x52 * (x125 * x4 + 3.0 * x126))
            + x4 * (x134 + x139 * x74 + x4 * (x130 + x132))
            + x74 * (x107 * (x110 * x142 + x141) + x139 * x4 + x140),
            x0 * (x107 * x155 + x147 * x4 - x52 * (x152 * x4 + 2.0 * x154))
            + x107 * (x153 * x4 + x166 * x4 + x168)
            + x4 * (x107 * x166 + x164 + x4 * (x160 + x162)),
            x0 * (x170 * x4 + x177 - x52 * (x172 * x4 + x174))
            + x107 * (x185 * x4 + x187 * x4 + x188)
            + x4 * (x107 * x187 + x182 + x4 * (x179 * x4 + x181)),
            x0 * (x107 * x202 + x194 * x4 - x52 * (x199 * x4 + 2.0 * x201))
            + x107 * (x200 * x4 + x212 * x4 + x214)
            + x4 * (x107 * x212 + x210 + x4 * (x107 * x208 + x207)),
            x0 * (x216 + x218 * x4 - x52 * (x110 * x220 + x219))
            + x39 * (x220 * x221 + x222)
            + x4 * (x226 + x227 + x4 * (x223 + x225)),
            x0 * (x229 + x231 * x4 - x52 * (x110 * x233 + x232))
            + x39 * (x221 * x233 + x234)
            + x4 * (x235 * x4 + x237 + x4 * (x110 * x236 + x235)),
            x0 * (x110 * x240 + x238 * x39 - x52 * (x211 * x76 + x239))
            + x39 * (x221 * x242 + x241)
            + x4 * (x243 * x4 + x245 + x4 * (x110 * x244 + x243)),
            x0 * (x247 + x249 * x4 - x52 * (x110 * x251 + x250))
            + x39 * (x221 * x251 + x252)
            + x4 * (x256 + x257 + x4 * (x253 + x255)),
            x0 * (x258 * x4 - x260 * x4) + x4 * (x262 + x263),
            x0 * (x264 * x4 - x266 * x4) + x4 * (x221 * x267 + x268),
            x0 * (x269 * x4 - x271 * x4) + x4 * (x221 * x272 + x273),
            x0 * (x248 * x4 * x76 - x275 * x4) + x4 * (x221 * x277 + x276),
            x0 * (x278 * x4 - x280 * x4) + x4 * (x282 + x283),
            0.5 * x287 + x4 * (x285 + x286) + x69 * (x284 * x65 + x284 * x67),
            0.5 * x292 + x4 * (x289 * x4 + x291 * x74) + x74 * (x291 * x4 + x295),
            0.5 * x296
            + x4 * (x130 * x284 + x132 * x284)
            + x74 * (x103 * x297 + x135 * x284),
            x107 * (x302 * x4 + x304) + 0.5 * x303 + x4 * (x107 * x302 + x300 * x4),
            x107 * (x306 * x4 + x310) + 0.5 * x308 + x4 * (x305 * x4 + x307),
            x107 * (x211 * x284 + x313) + 0.5 * x312 + x4 * (x107 * x311 + x207 * x284),
            x317 * x4 + 0.5 * x321 + x4 * (x317 + x320 * x4),
            x325 * x4 + 0.5 * x327 + x4 * (x325 + x326 * x4),
            x329 * x4 + 0.5 * x331 + x4 * (x329 + x330 * x4),
            x257 * x284 + 0.5 * x333 + x4 * (x255 * x284 + x332),
            x221 * x336 + 0.5 * x337,
            x221 * x338 + 0.5 * x339,
            x221 * x340 + 0.5 * x341,
            x221 * x342 + 0.5 * x344,
            x282 * x284 + 0.5 * x345,
            x348 + x4 * (x346 * x59 + x346 * x61) + x69 * (x346 * x65 + x346 * x67),
            x350 + x4 * (x346 * x96 + x346 * x98) + x74 * (x101 * x346 + x353),
            x360 + x4 * (x355 + x358) + x74 * (x356 * x4 + x362),
            x107 * (x165 * x346 + x365) + x364 + x4 * (x160 * x346 + x162 * x346),
            x107 * (x367 * x4 + x371) + x370 + x4 * (x366 * x4 + x368),
            x107 * (x374 * x4 + x380) + x378 + x4 * (x373 + x376),
            x227 * x346 + x383 + x4 * (x225 * x346 + x381),
            x386 * x4 + x390 + x4 * (x386 + x388 * x4),
            x392 * x4 + x395 + x4 * (x392 + x393 * x4),
            x398 * x4 + x4 * (x398 + x400) + x402,
            x262 * x346 + x404,
            x221 * x405 + x407,
            x221 * x408 + x410,
            x221 * x411 + x413,
            x221 * x414 + x416,
            x4 * x419 + 4.0 * x420,
            x4 * x422 + x423 * x74,
            x4 * x424 + 3.0 * x425,
            x107 * x427 + x4 * x426,
            x4 * x428 + x429,
            x4 * x430 + 2.0 * x431,
            x4 * x433 + x432,
            x4 * x435 + x434,
            x4 * x437 + x436,
            x4 * x439 + x438,
            x4 * x440,
            x4 * x441,
            x4 * x442,
            x4 * x443,
            x4 * x444,
            x285 * x346 + x286 * x346,
            x4 * x446 + x448 * x74,
            x284 * x355 + x284 * x358,
            x107 * x450 + x4 * x449,
            x4 * x451 + x452,
            x284 * x373 + x284 * x376,
            x4 * x454 + x453,
            x4 * x457 + x456,
            x4 * x459 + x458,
            x284 * x400 + x460,
            x4 * x461,
            x4 * x462,
            x4 * x463,
            x4 * x464,
            x284 * x4 * x414,
            x4 * x466 + 4.0 * x467,
            x4 * x468 + 3.0 * x469,
            x4 * x470 + 3.0 * x471,
            x4 * x472 + 2.0 * x473,
            x4 * x474 + x475,
            x4 * x476 + 2.0 * x477,
            x4 * x479 + x478,
            x4 * x481 + x480,
            x4 * x483 + x482,
            x4 * x485 + x484,
            x4 * x486,
            x4 * x487,
            x4 * x488,
            x4 * x489,
            x4 * x490,
            x284 * x419 + x287,
            x284 * x422 + x292 + x420,
            x284 * x424 + x296,
            x107 * x423 + x284 * x426 + x303,
            x284 * x428 + x308 + x425,
            x284 * x430 + x312,
            x284 * x433 + x321 + x427 * x74,
            x284 * x435 + x327 + x429,
            x284 * x437 + x331 + x431,
            x284 * x439 + x333,
            x284 * x440 + x337 + 4.0 * x432,
            x284 * x441 + x339 + 3.0 * x434,
            x284 * x442 + x341 + 2.0 * x436,
            x284 * x443 + x344 + x438,
            x284 * x444 + x345,
            x346 * x418 + x348,
            x284 * x446 + x346 * x421 + x350,
            x354 * x417 + x360,
            x107 * x448 + x284 * x449 + x364,
            x284 * x357 + x284 * x451 + x370,
            x372 * x417 + x378,
            x284 * x454 + x383 + x450 * x74,
            x284 * x457 + x390 + x452,
            x284 * x375 + x284 * x459 + x395,
            x399 * x417 + x402,
            x284 * x461 + x404 + 4.0 * x453,
            x284 * x462 + x407 + 3.0 * x456,
            x284 * x463 + x410 + 2.0 * x458,
            x284 * x464 + x413 + x460,
            x414 * x417 + x416,
            x284 * x466,
            x284 * x468 + x467,
            x284 * x470,
            x284 * x472 + 2.0 * x469,
            x284 * x474 + x471,
            x284 * x476,
            x284 * x479 + 3.0 * x473,
            x284 * x481 + x475,
            x284 * x483 + x477,
            x284 * x485,
            x284 * x486 + 4.0 * x478,
            x284 * x487 + 3.0 * x480,
            x284 * x488 + 2.0 * x482,
            x284 * x489 + x484,
            x284 * x490,
            x346 * x466 + x347,
            x346 * x468 + x349,
            x346 * x470 + x359 + x467,
            x346 * x472 + x363,
            x346 * x474 + x369 + x469,
            x346 * x476 + x377 + 2.0 * x471,
            x346 * x479 + x382,
            x346 * x481 + x389 + x473,
            x346 * x483 + x394 + x475,
            x346 * x485 + x401 + 3.0 * x477,
            x346 * x486 + x403,
            x346 * x487 + x406 + x478,
            x346 * x488 + x409 + 2.0 * x480,
            x346 * x489 + x412 + 3.0 * x482,
            x346 * x490 + x415 + 4.0 * x484,
        ]
    )


def _2center2el3d_35(a, A, b, B):
    """Cartesian (f|h) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = -x3 - B[0]
    x6 = b ** (-1.0)
    x7 = a * x2
    x8 = b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(5, x8)
    x10 = 17.4934183276249
    x11 = 2.0 * x6
    x12 = x10 * x11
    x13 = x1 ** (-1.5) * x12
    x14 = x13 * x9
    x15 = x14 * x5
    x16 = x1 ** (-0.5)
    x17 = boys(4, x8)
    x18 = 0.5 * x6
    x19 = x18 * (2.0 * x0 * x10 * x16 * x17 * x6 - x14)
    x20 = x5**2
    x21 = boys(6, x8)
    x22 = x0 * x16
    x23 = x12 * x22
    x24 = x21 * x23
    x25 = x20 * x24
    x26 = x19 + x25
    x27 = x26 * x5 + x6 * (2.0 * x0 * x10 * x16 * x17 * x5 * x6 - x15)
    x28 = x13 * x17
    x29 = boys(3, x8)
    x30 = x18 * (2.0 * x0 * x10 * x16 * x29 * x6 - x28)
    x31 = x23 * x9
    x32 = x20 * x31
    x33 = x30 + x32
    x34 = x13 * x29
    x35 = boys(2, x8)
    x36 = x18 * (2.0 * x0 * x10 * x16 * x35 * x6 - x34)
    x37 = x17 * x23
    x38 = x20 * x37
    x39 = x36 + x38
    x40 = 1.5 * x6
    x41 = x27 * x5 + x40 * (-x33 * x7 + x39)
    x42 = x28 * x5
    x43 = x33 * x5 + x6 * (2.0 * x0 * x10 * x16 * x29 * x5 * x6 - x42)
    x44 = (
        x11
        * (x39 * x5 - x43 * x7 + x6 * (2.0 * x0 * x10 * x16 * x35 * x5 * x6 - x34 * x5))
        + x41 * x5
    )
    x45 = (2.0 * a + 2.0 * b) ** (-1.0)
    x46 = x18 * (2.0 * x0 * x10 * x16 * x6 * boys(1, x8) - x13 * x35)
    x47 = x23 * x29
    x48 = x40 * (x20 * x47 - x39 * x7 + x46) + x43 * x5
    x49 = x45 * x48
    x50 = x13 * x21
    x51 = x5 * x50
    x52 = x18 * (2.0 * x0 * x10 * x16 * x6 * x9 - x50)
    x53 = boys(7, x8)
    x54 = x20 * x23
    x55 = x53 * x54
    x56 = x52 + x55
    x57 = x5 * x56 + x6 * (2.0 * x0 * x10 * x16 * x5 * x6 * x9 - x51)
    x58 = x40 * (-x26 * x7 + x33) + x5 * x57
    x59 = x11 * (-x27 * x7 + x43) + x5 * x58
    x60 = x41 * x45
    x61 = b * x2
    x62 = x13 * x53
    x63 = x5 * x62
    x64 = x18 * (2.0 * x0 * x10 * x16 * x21 * x6 - x62)
    x65 = boys(8, x8)
    x66 = x54 * x65
    x67 = x11 * (x27 - x57 * x7) + x5 * (
        x40 * (x26 - x56 * x7)
        + x5 * (x5 * (x64 + x66) + x6 * (2.0 * x0 * x10 * x16 * x21 * x5 * x6 - x63))
    )
    x68 = x4 * x67
    x69 = x45 * x58
    x70 = 5.0 * x69
    x71 = x59 * x61
    x72 = 0.5 * x0
    x73 = x72 * (x44 - x71)
    x74 = x4 * x58
    x75 = x27 * x45
    x76 = 4.0 * x75
    x77 = x74 + x76
    x78 = 5.0 * x45
    x79 = x72 * (-x41 * x61 + x48)
    x80 = x33 * x45
    x81 = 4.0 * x45
    x82 = -x2 * (a * A[1] + b * B[1])
    x83 = -x82 - B[1]
    x84 = x5 * x83
    x85 = x14 * x83
    x86 = x6 * (2.0 * x0 * x10 * x16 * x17 * x6 * x83 - x85)
    x87 = x25 * x83
    x88 = 0.5 * x86 + x87
    x89 = x5 * x88 + x6 * (2.0 * x0 * x10 * x16 * x17 * x5 * x6 * x83 - x14 * x84)
    x90 = x6 * (2.0 * x0 * x10 * x16 * x35 * x6 * x83 - x34 * x83)
    x91 = x28 * x83
    x92 = x6 * (2.0 * x0 * x10 * x16 * x29 * x6 * x83 - x91)
    x93 = x32 * x83
    x94 = 0.5 * x92 + x93
    x95 = x40 * (x38 * x83 - x7 * x94 + 0.5 * x90) + x5 * x89
    x96 = x5 * x94 + x6 * (2.0 * x0 * x10 * x16 * x29 * x5 * x6 * x83 - x28 * x84)
    x97 = x45 * x96
    x98 = x50 * x83
    x99 = x6 * (2.0 * x0 * x10 * x16 * x6 * x83 * x9 - x98)
    x100 = x55 * x83
    x101 = x100 + 0.5 * x99
    x102 = x101 * x5 + x6 * (2.0 * x0 * x10 * x16 * x5 * x6 * x83 * x9 - x50 * x84)
    x103 = x102 * x5 + x40 * (-x7 * x88 + x94)
    x104 = x45 * x89
    x105 = x62 * x83
    x106 = x6 * (2.0 * x0 * x10 * x16 * x21 * x6 * x83 - x105)
    x107 = x66 * x83
    x108 = x40 * (-x101 * x7 + x88) + x5 * (
        x5 * (0.5 * x106 + x107)
        + x6 * (2.0 * x0 * x10 * x16 * x21 * x5 * x6 * x83 - x62 * x84)
    )
    x109 = x108 * x4
    x110 = x102 * x45
    x111 = 4.0 * x110
    x112 = x103 * x61
    x113 = x72 * (-x112 + x95)
    x114 = x102 * x4
    x115 = x45 * x88
    x116 = 3.0 * x115
    x117 = x114 + x116
    x118 = x72 * (-x61 * x89 + x96)
    x119 = x10 * x22 * x6 * x81 * x9
    x120 = x119 * x84
    x121 = 3.0 * x45
    x122 = -x2 * (a * A[2] + b * B[2])
    x123 = -x122 - B[2]
    x124 = x123 * x14
    x125 = x6 * (2.0 * x0 * x10 * x123 * x16 * x17 * x6 - x124)
    x126 = 0.5 * x125
    x127 = x123 * x25 + x126
    x128 = x127 * x5 + x6 * (2.0 * x0 * x10 * x123 * x16 * x17 * x5 * x6 - x123 * x15)
    x129 = x6 * (2.0 * x0 * x10 * x123 * x16 * x35 * x6 - x123 * x34)
    x130 = 0.5 * x129
    x131 = x6 * (2.0 * x0 * x10 * x123 * x16 * x29 * x6 - x123 * x28)
    x132 = 0.5 * x131
    x133 = x123 * x32 + x132
    x134 = x128 * x5 + x40 * (x123 * x38 + x130 - x133 * x7)
    x135 = x133 * x5 + x6 * (2.0 * x0 * x10 * x123 * x16 * x29 * x5 * x6 - x123 * x42)
    x136 = x135 * x45
    x137 = x123 * x50
    x138 = x6 * (2.0 * x0 * x10 * x123 * x16 * x6 * x9 - x137)
    x139 = 0.5 * x138
    x140 = x123 * x55 + x139
    x141 = x140 * x5 + x6 * (2.0 * x0 * x10 * x123 * x16 * x5 * x6 * x9 - x123 * x51)
    x142 = x141 * x5 + x40 * (-x127 * x7 + x133)
    x143 = x128 * x45
    x144 = x123 * x62
    x145 = x6 * (2.0 * x0 * x10 * x123 * x16 * x21 * x6 - x144)
    x146 = 0.5 * x145
    x147 = x40 * (x127 - x140 * x7) + x5 * (
        x5 * (x123 * x66 + x146)
        + x6 * (2.0 * x0 * x10 * x123 * x16 * x21 * x5 * x6 - x123 * x63)
    )
    x148 = x147 * x4
    x149 = x141 * x45
    x150 = 4.0 * x149
    x151 = x142 * x61
    x152 = x72 * (x134 - x151)
    x153 = x141 * x4
    x154 = x127 * x45
    x155 = 3.0 * x154
    x156 = x153 + x155
    x157 = x72 * (-x128 * x61 + x135)
    x158 = x119 * x123
    x159 = x158 * x5
    x160 = x83**2
    x161 = x160 * x37 + x36
    x162 = x160 * x31 + x30
    x163 = x160 * x24 + x19
    x164 = x161 - x162 * x7
    x165 = x163 * x20 + x164 * x18
    x166 = x165 * x5 + x6 * (x161 * x5 - x162 * x5 * x7)
    x167 = x160 * x47 - x161 * x7 + x46
    x168 = x162 * x20 + x167 * x18
    x169 = x168 * x45
    x170 = 3.0 * x169
    x171 = x163 * x5
    x172 = x160 * x23
    x173 = x172 * x53
    x174 = x173 + x52
    x175 = x162 - x163 * x7
    x176 = x174 * x20 + x175 * x18
    x177 = x176 * x5 + x6 * (x162 * x5 - x171 * x7)
    x178 = x165 * x45
    x179 = 3.0 * x178
    x180 = x174 * x7
    x181 = x172 * x65
    x182 = x181 + x64
    x183 = x163 - x180
    x184 = x5 * (x18 * x183 + x182 * x20) + x6 * (x163 * x5 - x180 * x5)
    x185 = x184 * x4
    x186 = x176 * x45
    x187 = 3.0 * x186
    x188 = x177 * x61
    x189 = x72 * (x166 - x188)
    x190 = x176 * x4
    x191 = 2.0 * x45
    x192 = x171 * x191
    x193 = x190 + x192
    x194 = x72 * (-x165 * x61 + x168)
    x195 = x162 * x45
    x196 = x6 * (2.0 * x0 * x10 * x123 * x16 * x17 * x6 * x83 - x123 * x85)
    x197 = x123 * x87 + 0.5 * x196
    x198 = x197 * x5 + x6 * (
        2.0 * x0 * x10 * x123 * x16 * x17 * x5 * x6 * x83 - x124 * x84
    )
    x199 = x6 * (2.0 * x0 * x10 * x123 * x16 * x29 * x6 * x83 - x123 * x91)
    x200 = x123 * x93 + 0.5 * x199
    x201 = x6 * (2.0 * x0 * x10 * x123 * x16 * x6 * x83 * x9 - x123 * x98)
    x202 = x100 * x123 + 0.5 * x201
    x203 = x202 * x5 + x6 * (
        2.0 * x0 * x10 * x123 * x16 * x5 * x6 * x83 * x9 - x137 * x84
    )
    x204 = x6 * (2.0 * x0 * x10 * x123 * x16 * x21 * x6 * x83 - x105 * x123)
    x205 = x5 * (x107 * x123 + 0.5 * x204) + x6 * (
        2.0 * x0 * x10 * x123 * x16 * x21 * x5 * x6 * x83 - x144 * x84
    )
    x206 = x72 * (x198 - x203 * x61)
    x207 = x10 * x123 * x21 * x22 * x6 * x81 * x84
    x208 = x202 * x4 + x207
    x209 = x72 * (-x197 * x61 + x200)
    x210 = x4 * x5
    x211 = x210 * x83
    x212 = x123 * x24
    x213 = x123**2
    x214 = x213 * x37 + x36
    x215 = x213 * x31 + x30
    x216 = x215 * x5
    x217 = x19 + x213 * x24
    x218 = x20 * x217
    x219 = x214 - x215 * x7
    x220 = x18 * x219
    x221 = x218 + x220
    x222 = x221 * x5 + x6 * (x214 * x5 - x216 * x7)
    x223 = x213 * x47 - x214 * x7 + x46
    x224 = x18 * x223
    x225 = x20 * x215 + x224
    x226 = x225 * x45
    x227 = 3.0 * x226
    x228 = x217 * x5
    x229 = x213 * x23
    x230 = x229 * x53 + x52
    x231 = x20 * x230
    x232 = x215 - x217 * x7
    x233 = x18 * x232
    x234 = x231 + x233
    x235 = x234 * x5 + x6 * (x215 * x5 - x228 * x7)
    x236 = x221 * x45
    x237 = 3.0 * x236
    x238 = x230 * x7
    x239 = x229 * x65 + x64
    x240 = x20 * x239
    x241 = x217 - x238
    x242 = x18 * x241
    x243 = x5 * (x240 + x242) + x6 * (x217 * x5 - x238 * x5)
    x244 = x243 * x4
    x245 = x234 * x45
    x246 = 3.0 * x245
    x247 = x235 * x61
    x248 = x72 * (x222 - x247)
    x249 = x234 * x4
    x250 = x191 * x228
    x251 = x249 + x250
    x252 = x72 * (-x221 * x61 + x225)
    x253 = x215 * x45
    x254 = x163 * x83 + x86
    x255 = x162 * x83 + x92
    x256 = x161 * x83 - x255 * x7 + x90
    x257 = x18 * x256 + x20 * x254
    x258 = x174 * x83 + x99
    x259 = -x254 * x7 + x255
    x260 = x18 * x259 + x20 * x258
    x261 = x254 * x45
    x262 = x261 * x5
    x263 = x255 * x5
    x264 = x106 + x182 * x83
    x265 = x254 - x258 * x7
    x266 = x18 * x265 + x20 * x264
    x267 = x266 * x4
    x268 = x258 * x5
    x269 = x260 * x61
    x270 = x72 * (x257 - x269)
    x271 = x210 * x258
    x272 = x261 + x271
    x273 = x5 * x61
    x274 = x72 * (-x254 * x273 + x255 * x5)
    x275 = x126 + x160 * x212
    x276 = x123 * x160 * x31 + x132
    x277 = x123 * x160 * x37 + x130 - x276 * x7
    x278 = x18 * x277 + x20 * x275
    x279 = x123 * x173 + x139
    x280 = -x275 * x7 + x276
    x281 = x18 * x280 + x20 * x279
    x282 = x275 * x45
    x283 = 2.0 * x282
    x284 = x283 * x5
    x285 = x276 * x5
    x286 = x191 * x285
    x287 = x123 * x181 + x146
    x288 = x275 - x279 * x7
    x289 = x18 * x288 + x20 * x287
    x290 = x279 * x5
    x291 = x191 * x290
    x292 = x72 * (x278 - x281 * x61)
    x293 = x210 * x279 + x282
    x294 = x72 * (-x273 * x275 + x276 * x5)
    x295 = x6 * (x214 * x83 - x215 * x7 * x83)
    x296 = x218 * x83 + 0.5 * x295
    x297 = x217 * x83
    x298 = x6 * (x215 * x83 - x297 * x7)
    x299 = x231 * x83 + 0.5 * x298
    x300 = x250 * x83
    x301 = x216 * x83
    x302 = x191 * x301
    x303 = x6 * (x217 * x83 - x238 * x83)
    x304 = x240 * x83 + 0.5 * x303
    x305 = x230 * x84
    x306 = x191 * x305
    x307 = x72 * (x296 - x299 * x61)
    x308 = x297 * x45
    x309 = x211 * x230 + x308
    x310 = x61 * x83
    x311 = x72 * (x215 * x5 * x83 - x228 * x310)
    x312 = x123 * x217 + x125
    x313 = x123 * x215 + x131
    x314 = x123 * x214 + x129 - x313 * x7
    x315 = x18 * x314
    x316 = x20 * x312 + x315
    x317 = x123 * x230 + x138
    x318 = -x312 * x7 + x313
    x319 = x18 * x318
    x320 = x20 * x317 + x319
    x321 = x312 * x45
    x322 = x321 * x5
    x323 = x313 * x5
    x324 = x123 * x239 + x145
    x325 = x312 - x317 * x7
    x326 = x18 * x325
    x327 = x20 * x324 + x326
    x328 = x327 * x4
    x329 = x317 * x5
    x330 = x320 * x61
    x331 = x72 * (x316 - x330)
    x332 = x210 * x317
    x333 = x321 + x332
    x334 = x312 * x5
    x335 = x72 * (x313 * x5 - x334 * x61)
    x336 = x167 * x40 + x255 * x83
    x337 = x336 * x45
    x338 = x164 * x40 + x254 * x83
    x339 = x338 * x5
    x340 = x338 * x45
    x341 = x175 * x40 + x258 * x83
    x342 = x4**2
    x343 = x72 * (x336 - x338 * x61)
    x344 = x341 * x45
    x345 = x183 * x40 + x264 * x83
    x346 = x210 * x345
    x347 = x72 * (-x273 * x341 + x338 * x5)
    x348 = x344 * x4
    x349 = x199 + x276 * x83
    x350 = x349 * x45
    x351 = x196 + x275 * x83
    x352 = x351 * x5
    x353 = x351 * x45
    x354 = x201 + x279 * x83
    x355 = x72 * (x349 - x351 * x61)
    x356 = x354 * x45
    x357 = x204 + x287 * x83
    x358 = x72 * (-x273 * x354 + x351 * x5)
    x359 = x160 * x215 + x224
    x360 = x359 * x45
    x361 = x160 * x217 + x220
    x362 = x361 * x5
    x363 = x361 * x45
    x364 = x160 * x230 + x233
    x365 = x72 * (x359 - x361 * x61)
    x366 = x364 * x45
    x367 = x160 * x239 + x242
    x368 = x72 * (-x273 * x364 + x361 * x5)
    x369 = x313 * x83
    x370 = x321 * x83
    x371 = x72 * (-x310 * x312 + x313 * x83)
    x372 = x317 * x83
    x373 = x372 * x45
    x374 = x72 * (-x273 * x372 + x312 * x5 * x83)
    x375 = x123 * x313 + x223 * x40
    x376 = x375 * x45
    x377 = x123 * x312 + x219 * x40
    x378 = x377 * x5
    x379 = x377 * x45
    x380 = x123 * x317 + x232 * x40
    x381 = x72 * (x375 - x377 * x61)
    x382 = x380 * x45
    x383 = x123 * x324 + x241 * x40
    x384 = x210 * x383
    x385 = x72 * (-x273 * x380 + x377 * x5)
    x386 = x382 * x4
    x387 = x11 * x256 + x338 * x83
    x388 = x11 * x259 + x341 * x83
    x389 = x388 * x61
    x390 = x11 * x265 + x345 * x83
    x391 = x342 * x390
    x392 = x72 * (x387 - x389)
    x393 = x277 * x40 + x351 * x83
    x394 = x280 * x40 + x354 * x83
    x395 = x394 * x61
    x396 = x288 * x40 + x357 * x83
    x397 = x72 * (x393 - x395)
    x398 = x295 + x361 * x83
    x399 = x298 + x364 * x83
    x400 = x399 * x61
    x401 = x303 + x367 * x83
    x402 = x72 * (x398 - x400)
    x403 = x160 * x312 + x315
    x404 = x160 * x317 + x319
    x405 = x404 * x61
    x406 = x160 * x324 + x326
    x407 = x72 * (x403 - x405)
    x408 = x380 * x83
    x409 = x408 * x61
    x410 = x72 * (x377 * x83 - x409)
    x411 = x383 * x83
    x412 = x11 * x314 + x123 * x377
    x413 = x11 * x318 + x123 * x380
    x414 = x413 * x61
    x415 = x11 * x325 + x123 * x383
    x416 = x342 * x415
    x417 = x72 * (x412 - x414)
    x418 = -x82 - A[1]
    x419 = x418 * x68
    x420 = x418 * x70
    x421 = x0 * (x418 * x44 - x418 * x71)
    x422 = x108 * x418
    x423 = x422 + x69
    x424 = x102 * x418
    x425 = x424 + x75
    x426 = x0 * (x418 * x95 + x49 - x61 * (x103 * x418 + x60))
    x427 = x418 * x88 + x80
    x428 = x0 * (x134 * x418 - x151 * x418)
    x429 = x184 * x418
    x430 = 2.0 * x110
    x431 = x429 + x430
    x432 = x176 * x418
    x433 = 2.0 * x115
    x434 = x432 + x433
    x435 = x121 * x434
    x436 = x0 * (x166 * x418 - x61 * (2.0 * x104 + x177 * x418) + 2.0 * x97)
    x437 = x120 + x171 * x418
    x438 = x149 + x205 * x418
    x439 = x154 + x202 * x418
    x440 = x0 * (x136 + x198 * x418 - x61 * (x143 + x203 * x418))
    x441 = x418 * x5
    x442 = x441 * x83
    x443 = x191 * (x123 * x31 * x45 * x5 + x212 * x442)
    x444 = x0 * (x222 * x418 - x247 * x418)
    x445 = x266 * x418
    x446 = x187 + x445
    x447 = x258 * x441
    x448 = x121 * x171
    x449 = x447 + x448
    x450 = x0 * (x170 + x257 * x418 - x61 * (x179 + x260 * x418))
    x451 = x45 * (3.0 * x195 + x254 * x418)
    x452 = x191 * x202
    x453 = x289 * x418 + x452
    x454 = x207 + x279 * x441
    x455 = x191 * x200
    x456 = x191 * x197
    x457 = x0 * (x278 * x418 + x455 - x61 * (x281 * x418 + x456))
    x458 = x158 * x83
    x459 = x45 * (x275 * x418 + x458)
    x460 = x245 + x304 * x418
    x461 = x228 * x45
    x462 = x230 * x442 + x461
    x463 = x191 * x462
    x464 = x0 * (x226 + x296 * x418 - x61 * (x236 + x299 * x418))
    x465 = x45 * (x253 + x297 * x418)
    x466 = x317 * x441
    x467 = x0 * (x316 * x418 - x330 * x418)
    x468 = x321 * x418
    x469 = x341 * x418
    x470 = 4.0 * x261
    x471 = x469 + x470
    x472 = x45 * x471
    x473 = x345 * x441
    x474 = x268 * x81 + x473
    x475 = x0 * (x263 * x81 + x339 * x418 - x61 * (x469 * x5 + x470 * x5))
    x476 = x354 * x418
    x477 = 3.0 * x282
    x478 = x476 + x477
    x479 = x45 * x478
    x480 = x121 * x290 + x357 * x441
    x481 = x0 * (x121 * x285 + x352 * x418 - x61 * (x476 * x5 + x477 * x5))
    x482 = x364 * x418
    x483 = x191 * x297 + x482
    x484 = x45 * x483
    x485 = x306 + x367 * x441
    x486 = x0 * (x302 + x362 * x418 - x61 * (x300 + x482 * x5))
    x487 = x321 + x372 * x418
    x488 = x45 * x487
    x489 = x324 * x442 + x329 * x45
    x490 = x0 * (x323 * x45 + x334 * x418 * x83 - x61 * (x322 + x372 * x441))
    x491 = x382 * x418
    x492 = x0 * (x377 * x418 * x5 - x380 * x441 * x61)
    x493 = x390 * x418
    x494 = 5.0 * x344
    x495 = x493 + x494
    x496 = x0 * (5.0 * x337 + x387 * x418 - x61 * (5.0 * x340 + x388 * x418))
    x497 = 4.0 * x356 + x396 * x418
    x498 = x0 * (4.0 * x350 + x393 * x418 - x61 * (4.0 * x353 + x394 * x418))
    x499 = 3.0 * x366
    x500 = x401 * x418 + x499
    x501 = 3.0 * x360
    x502 = 3.0 * x363
    x503 = x0 * (x398 * x418 + x501 - x61 * (x399 * x418 + x502))
    x504 = x191 * x372 + x406 * x418
    x505 = x0 * (x191 * x369 + x403 * x418 - x61 * (2.0 * x370 + x404 * x418))
    x506 = x382 + x411 * x418
    x507 = x377 * x83
    x508 = x0 * (x376 + x418 * x507 - x61 * (x379 + x408 * x418))
    x509 = x0 * (x412 * x418 - x414 * x418)
    x510 = -x122 - A[2]
    x511 = x0 * (x44 * x510 - x510 * x71)
    x512 = 0.5 * x511
    x513 = x0 * (-x112 * x510 + x510 * x95)
    x514 = 0.5 * x513
    x515 = x147 * x510 + x69
    x516 = x4 * x515
    x517 = x141 * x510 + x75
    x518 = x45 * x517
    x519 = 4.0 * x518
    x520 = x0 * (x134 * x510 + x49 - x61 * (x142 * x510 + x60))
    x521 = 0.5 * x520
    x522 = x45 * (x127 * x510 + x80)
    x523 = x187 * x510
    x524 = x0 * (x166 * x510 - x188 * x510)
    x525 = 0.5 * x524
    x526 = x110 + x205 * x510
    x527 = x115 + x202 * x510
    x528 = x0 * (x198 * x510 - x61 * (x104 + x203 * x510) + x97)
    x529 = 0.5 * x528
    x530 = x5 * x510
    x531 = x530 * x83
    x532 = x191 * (x212 * x531 + x31 * x45 * x84)
    x533 = 2.0 * x149 + x243 * x510
    x534 = x4 * x533
    x535 = 2.0 * x154 + x234 * x510
    x536 = x45 * x535
    x537 = 3.0 * x536
    x538 = x0 * (2.0 * x136 + x222 * x510 - x61 * (2.0 * x143 + x235 * x510))
    x539 = 0.5 * x538
    x540 = x45 * (x159 + x228 * x510)
    x541 = x258 * x530
    x542 = x0 * (x257 * x510 - x269 * x510)
    x543 = 0.5 * x542
    x544 = x261 * x510
    x545 = x186 + x289 * x510
    x546 = x171 * x45
    x547 = x279 * x530 + x546
    x548 = x191 * x547
    x549 = x0 * (x169 + x278 * x510 - x61 * (x178 + x281 * x510))
    x550 = 0.5 * x549
    x551 = x45 * (x195 + x275 * x510)
    x552 = x304 * x510 + x452
    x553 = x207 + x230 * x531
    x554 = x191 * x553
    x555 = x0 * (x296 * x510 + x455 - x61 * (x299 * x510 + x456))
    x556 = 0.5 * x555
    x557 = x45 * (x297 * x510 + x458)
    x558 = x246 + x327 * x510
    x559 = x4 * x558
    x560 = x121 * x228
    x561 = x329 * x510 + x560
    x562 = x45 * x561
    x563 = 2.0 * x562
    x564 = x0 * (x227 + x316 * x510 - x61 * (x237 + x320 * x510))
    x565 = 0.5 * x564
    x566 = x312 * x510
    x567 = x45 * (3.0 * x253 + x566)
    x568 = x344 * x510
    x569 = x0 * (x338 * x5 * x510 - x341 * x530 * x61)
    x570 = 0.5 * x569
    x571 = x354 * x510
    x572 = x261 + x571
    x573 = x45 * x572
    x574 = x268 * x45 + x357 * x530
    x575 = x0 * (x263 * x45 + x352 * x510 - x61 * (x262 + x5 * x571))
    x576 = 0.5 * x575
    x577 = x364 * x510
    x578 = x283 + x577
    x579 = x45 * x578
    x580 = x291 + x367 * x530
    x581 = x0 * (x286 + x362 * x510 - x61 * (x284 + x5 * x577))
    x582 = 0.5 * x581
    x583 = x121 * x297 + x372 * x510
    x584 = x45 * x583
    x585 = x121 * x305 + x324 * x531
    x586 = x0 * (x121 * x301 + x566 * x84 - x61 * (x372 * x530 + x560 * x83))
    x587 = 0.5 * x586
    x588 = x380 * x510
    x589 = 4.0 * x321 + x588
    x590 = x45 * x589
    x591 = x329 * x81 + x383 * x530
    x592 = x4 * x591
    x593 = x0 * (x323 * x81 + x378 * x510 - x61 * (4.0 * x322 + x5 * x588))
    x594 = 0.5 * x593
    x595 = x0 * (x387 * x510 - x389 * x510)
    x596 = 0.5 * x595
    x597 = x344 + x396 * x510
    x598 = x0 * (x337 + x393 * x510 - x61 * (x340 + x394 * x510))
    x599 = 0.5 * x598
    x600 = 2.0 * x356 + x401 * x510
    x601 = x0 * (2.0 * x350 + x398 * x510 - x61 * (2.0 * x353 + x399 * x510))
    x602 = 0.5 * x601
    x603 = x406 * x510 + x499
    x604 = x0 * (x403 * x510 + x501 - x61 * (x404 * x510 + x502))
    x605 = 0.5 * x604
    x606 = x372 * x81 + x411 * x510
    x607 = x0 * (x369 * x81 + x507 * x510 - x61 * (4.0 * x370 + x588 * x83))
    x608 = 0.5 * x607
    x609 = 5.0 * x382 + x415 * x510
    x610 = x0 * (5.0 * x376 + x412 * x510 - x61 * (5.0 * x379 + x413 * x510))
    x611 = 0.5 * x610
    x612 = x418**2
    x613 = x612 * x67
    x614 = x613 + x73
    x615 = x45 * (x58 * x612 + x79)
    x616 = x418 * x69
    x617 = x113 + x418 * x423 + x616
    x618 = x118 + x418 * x425 + x418 * x75
    x619 = x147 * x612 + x152
    x620 = x45 * (x141 * x612 + x157)
    x621 = x189 + x191 * x425 + x418 * x431
    x622 = x121 * (x191 * x427 + x194 + x418 * x434)
    x623 = x149 * x418 + x206 + x418 * x438
    x624 = x154 * x418 + x209 + x418 * x439
    x625 = x243 * x612 + x248
    x626 = x45 * (x234 * x612 + x252)
    x627 = x270 + x418 * x446 + x435
    x628 = x121 * x437 + x274 + x418 * x449
    x629 = x191 * x439 + x292 + x418 * x453
    x630 = x294 + x418 * x454 + x443
    x631 = x245 * x418 + x307 + x418 * x460
    x632 = x191 * (x311 + x418 * x461 + x418 * x462)
    x633 = x327 * x612 + x331
    x634 = x45 * (x329 * x612 + x335)
    x635 = x45 * (x343 + x418 * x471 + 4.0 * x451)
    x636 = x347 + x418 * x474 + x449 * x81
    x637 = x45 * (x355 + x418 * x478 + 3.0 * x459)
    x638 = x121 * x454 + x358 + x418 * x480
    x639 = x45 * (x365 + x418 * x483 + 2.0 * x465)
    x640 = x368 + x418 * x485 + x463
    x641 = x45 * (x371 + x418 * x487 + x468)
    x642 = x374 + x418 * x489 + x45 * x466
    x643 = x45 * (x380 * x612 + x381)
    x644 = x383 * x5 * x612 + x385
    x645 = x392 + x418 * x495 + 5.0 * x472
    x646 = x397 + x418 * x497 + 4.0 * x479
    x647 = x402 + x418 * x500 + 3.0 * x484
    x648 = x407 + x418 * x504 + 2.0 * x488
    x649 = x410 + x418 * x506 + x491
    x650 = x415 * x612 + x417
    x651 = x510 * x69
    x652 = x422 * x510 + x651
    x653 = x510 * x75
    x654 = x424 * x510 + x653
    x655 = x429 * x510 + x430 * x510
    x656 = x121 * (x432 * x510 + x433 * x510)
    x657 = x418 * x526 + x518
    x658 = x418 * x527 + x522
    x659 = x445 * x510 + x523
    x660 = x447 * x510 + x448 * x510
    x661 = x191 * x527
    x662 = x418 * x545 + x661
    x663 = x418 * x547 + x532
    x664 = x418 * x552 + x536
    x665 = x191 * (x418 * x553 + x540)
    x666 = x45 * (x469 * x510 + x470 * x510)
    x667 = x473 * x510 + x541 * x81
    x668 = x45 * (x418 * x572 + 3.0 * x551)
    x669 = x121 * x547 + x418 * x574
    x670 = x45 * (x418 * x578 + 2.0 * x557)
    x671 = x418 * x580 + x554
    x672 = x45 * (x418 * x583 + x567)
    x673 = x418 * x585 + x562
    x674 = x418 * x590
    x675 = x493 * x510 + x494 * x510
    x676 = x418 * x597 + 4.0 * x573
    x677 = 3.0 * x579
    x678 = x418 * x600 + x677
    x679 = x418 * x603 + 2.0 * x584
    x680 = x418 * x606 + x590
    x681 = x510**2
    x682 = x67 * x681 + x73
    x683 = x45 * (x58 * x681 + x79)
    x684 = x108 * x681 + x113
    x685 = x45 * (x102 * x681 + x118)
    x686 = x152 + x510 * x515 + x651
    x687 = x45 * (x157 + x510 * x517 + x653)
    x688 = x184 * x681 + x189
    x689 = x45 * (x176 * x681 + x194)
    x690 = 3.0 * x689
    x691 = x110 * x510 + x206 + x510 * x526
    x692 = x115 * x510 + x209 + x510 * x527
    x693 = x248 + x510 * x533 + 2.0 * x518
    x694 = x45 * (x252 + x510 * x535 + 2.0 * x522)
    x695 = 3.0 * x694
    x696 = x266 * x681 + x270
    x697 = x45 * (x268 * x681 + x274)
    x698 = x186 * x510 + x292 + x510 * x545
    x699 = x294 + x510 * x546 + x510 * x547
    x700 = x191 * x699
    x701 = x307 + x510 * x552 + x661
    x702 = x311 + x510 * x553 + x532
    x703 = x191 * x702
    x704 = x331 + x510 * x558 + x537
    x705 = x45 * (x335 + x510 * x561 + 3.0 * x540)
    x706 = x45 * (x341 * x681 + x343)
    x707 = x345 * x5 * x681 + x347
    x708 = x45 * (x355 + x510 * x572 + x544)
    x709 = x358 + x45 * x541 + x510 * x574
    x710 = x45 * (x365 + x510 * x578 + 2.0 * x551)
    x711 = x368 + x510 * x580 + x548
    x712 = x45 * (x371 + x510 * x583 + 3.0 * x557)
    x713 = x121 * x553 + x374 + x510 * x585
    x714 = x45 * (x381 + x510 * x589 + 4.0 * x567)
    x715 = x385 + x510 * x591 + 4.0 * x562
    x716 = x390 * x681 + x392
    x717 = x397 + x510 * x597 + x568
    x718 = x402 + x510 * x600 + 2.0 * x573
    x719 = x407 + x510 * x603 + x677
    x720 = x410 + x510 * x606 + 4.0 * x584
    x721 = x417 + x510 * x609 + 5.0 * x590
    x722 = x191 * x692
    x723 = 3.0 * x710

    # 210 item(s)
    return numpy.array(
        [
            x0 * (x4 * x44 + 5.0 * x49 - x61 * (x4 * x59 + 5.0 * x60))
            + x4 * (x4 * (x68 + x70) + x73 + x77 * x78)
            + x78 * (x4 * x77 + x79 + x81 * (x27 * x4 + 3.0 * x80)),
            x0 * (x4 * x95 - x61 * (x103 * x4 + 4.0 * x104) + 4.0 * x97)
            + x4 * (x113 + x117 * x81 + x4 * (x109 + x111))
            + x81 * (x117 * x4 + x118 + x121 * (x120 + x4 * x88)),
            x0 * (x134 * x4 + 4.0 * x136 - x61 * (x142 * x4 + 4.0 * x143))
            + x4 * (x152 + x156 * x81 + x4 * (x148 + x150))
            + x81 * (x121 * (x127 * x4 + x159) + x156 * x4 + x157),
            x0 * (x166 * x4 + x170 - x61 * (x177 * x4 + x179))
            + x121 * (x191 * (x171 * x4 + x195) + x193 * x4 + x194)
            + x4 * (x121 * x193 + x189 + x4 * (x185 + x187)),
            x0 * (x121 * x200 + x198 * x4 - x61 * (x121 * x197 + x203 * x4))
            + x121 * (x191 * (x123 * x31 * x45 * x83 + x211 * x212) + x208 * x4 + x209)
            + x4 * (x121 * x208 + x206 + x4 * (x121 * x202 + x205 * x4)),
            x0 * (x222 * x4 + x227 - x61 * (x235 * x4 + x237))
            + x121 * (x191 * (x228 * x4 + x253) + x251 * x4 + x252)
            + x4 * (x121 * x251 + x248 + x4 * (x244 + x246)),
            x0 * (x191 * x263 + x257 * x4 - x61 * (x260 * x4 + 2.0 * x262))
            + x191 * (x261 * x4 + x272 * x4 + x274)
            + x4 * (x191 * x272 + x270 + x4 * (x191 * x268 + x267)),
            x0 * (x278 * x4 + x286 - x61 * (x281 * x4 + x284))
            + x191 * (x282 * x4 + x293 * x4 + x294)
            + x4 * (x191 * x293 + x292 + x4 * (x289 * x4 + x291)),
            x0 * (x296 * x4 + x302 - x61 * (x299 * x4 + x300))
            + x191 * (x308 * x4 + x309 * x4 + x311)
            + x4 * (x191 * x309 + x307 + x4 * (x304 * x4 + x306)),
            x0 * (x191 * x323 + x316 * x4 - x61 * (x320 * x4 + 2.0 * x322))
            + x191 * (x321 * x4 + x333 * x4 + x335)
            + x4 * (x191 * x333 + x331 + x4 * (x191 * x329 + x328)),
            x0 * (x337 + x339 * x4 - x61 * (x210 * x341 + x340))
            + x4 * (x347 + x348 + x4 * (x344 + x346))
            + x45 * (x341 * x342 + x343),
            x0 * (x350 + x352 * x4 - x61 * (x210 * x354 + x353))
            + x4 * (x356 * x4 + x358 + x4 * (x210 * x357 + x356))
            + x45 * (x342 * x354 + x355),
            x0 * (x360 + x362 * x4 - x61 * (x210 * x364 + x363))
            + x4 * (x366 * x4 + x368 + x4 * (x210 * x367 + x366))
            + x45 * (x342 * x364 + x365),
            x0 * (x211 * x312 + x369 * x45 - x61 * (x332 * x83 + x370))
            + x4 * (x373 * x4 + x374 + x4 * (x211 * x324 + x373))
            + x45 * (x342 * x372 + x371),
            x0 * (x376 + x378 * x4 - x61 * (x210 * x380 + x379))
            + x4 * (x385 + x386 + x4 * (x382 + x384))
            + x45 * (x342 * x380 + x381),
            x0 * (x387 * x4 - x389 * x4) + x4 * (x391 + x392),
            x0 * (x393 * x4 - x395 * x4) + x4 * (x342 * x396 + x397),
            x0 * (x398 * x4 - x4 * x400) + x4 * (x342 * x401 + x402),
            x0 * (x4 * x403 - x4 * x405) + x4 * (x342 * x406 + x407),
            x0 * (x377 * x4 * x83 - x4 * x409) + x4 * (x342 * x411 + x410),
            x0 * (x4 * x412 - x4 * x414) + x4 * (x416 + x417),
            x4 * (x419 + x420) + 0.5 * x421 + x78 * (x418 * x74 + x418 * x76),
            x4 * (x4 * x423 + x425 * x81) + 0.5 * x426 + x81 * (x121 * x427 + x4 * x425),
            x4 * (x148 * x418 + x150 * x418)
            + 0.5 * x428
            + x81 * (x153 * x418 + x155 * x418),
            x121 * (x191 * x437 + x4 * x434) + x4 * (x4 * x431 + x435) + 0.5 * x436,
            x121 * (x4 * x439 + x443) + x4 * (x121 * x439 + x4 * x438) + 0.5 * x440,
            x121 * (x249 * x418 + x250 * x418)
            + x4 * (x244 * x418 + x246 * x418)
            + 0.5 * x444,
            x191 * (x4 * x449 + x451) + x4 * (x191 * x449 + x4 * x446) + 0.5 * x450,
            x191 * (x4 * x454 + x459) + x4 * (x191 * x454 + x4 * x453) + 0.5 * x457,
            x191 * (x4 * x462 + x465) + x4 * (x4 * x460 + x463) + 0.5 * x464,
            x191 * (x332 * x418 + x468) + x4 * (x191 * x466 + x328 * x418) + 0.5 * x467,
            x4 * x472 + x4 * (x4 * x474 + x472) + 0.5 * x475,
            x4 * x479 + x4 * (x4 * x480 + x479) + 0.5 * x481,
            x4 * x484 + x4 * (x4 * x485 + x484) + 0.5 * x486,
            x4 * x488 + x4 * (x4 * x489 + x488) + 0.5 * x490,
            x386 * x418 + x4 * (x384 * x418 + x491) + 0.5 * x492,
            x342 * x495 + 0.5 * x496,
            x342 * x497 + 0.5 * x498,
            x342 * x500 + 0.5 * x503,
            x342 * x504 + 0.5 * x505,
            x342 * x506 + 0.5 * x508,
            x416 * x418 + 0.5 * x509,
            x4 * (x510 * x68 + x510 * x70) + x512 + x78 * (x510 * x74 + x510 * x76),
            x4 * (x109 * x510 + x111 * x510) + x514 + x81 * (x114 * x510 + x116 * x510),
            x4 * (x516 + x519) + x521 + x81 * (x4 * x517 + 3.0 * x522),
            x121 * (x190 * x510 + x192 * x510) + x4 * (x185 * x510 + x523) + x525,
            x121 * (x4 * x527 + x532) + x4 * (x121 * x527 + x4 * x526) + x529,
            x121 * (x4 * x535 + 2.0 * x540) + x4 * (x534 + x537) + x539,
            x191 * (x271 * x510 + x544) + x4 * (x191 * x541 + x267 * x510) + x543,
            x191 * (x4 * x547 + x551) + x4 * (x4 * x545 + x548) + x550,
            x191 * (x4 * x553 + x557) + x4 * (x4 * x552 + x554) + x556,
            x191 * (x4 * x561 + x567) + x4 * (x559 + x563) + x565,
            x348 * x510 + x4 * (x346 * x510 + x568) + x570,
            x4 * x573 + x4 * (x4 * x574 + x573) + x576,
            x4 * x579 + x4 * (x4 * x580 + x579) + x582,
            x4 * x584 + x4 * (x4 * x585 + x584) + x587,
            x4 * x590 + x4 * (x590 + x592) + x594,
            x391 * x510 + x596,
            x342 * x597 + x599,
            x342 * x600 + x602,
            x342 * x603 + x605,
            x342 * x606 + x608,
            x342 * x609 + x611,
            x4 * x614 + 5.0 * x615,
            x4 * x617 + x618 * x81,
            x4 * x619 + 4.0 * x620,
            x4 * x621 + x622,
            x121 * x624 + x4 * x623,
            x4 * x625 + 3.0 * x626,
            x191 * x628 + x4 * x627,
            x191 * x630 + x4 * x629,
            x4 * x631 + x632,
            x4 * x633 + 2.0 * x634,
            x4 * x636 + x635,
            x4 * x638 + x637,
            x4 * x640 + x639,
            x4 * x642 + x641,
            x4 * x644 + x643,
            x4 * x645,
            x4 * x646,
            x4 * x647,
            x4 * x648,
            x4 * x649,
            x4 * x650,
            x419 * x510 + x420 * x510,
            x4 * x652 + x654 * x81,
            x418 * x516 + x418 * x519,
            x4 * x655 + x656,
            x121 * x658 + x4 * x657,
            x418 * x534 + x418 * x537,
            x191 * x660 + x4 * x659,
            x191 * x663 + x4 * x662,
            x4 * x664 + x665,
            x418 * x559 + x418 * x563,
            x4 * x667 + x666,
            x4 * x669 + x668,
            x4 * x671 + x670,
            x4 * x673 + x672,
            x418 * x592 + x674,
            x4 * x675,
            x4 * x676,
            x4 * x678,
            x4 * x679,
            x4 * x680,
            x4 * x418 * x609,
            x4 * x682 + 5.0 * x683,
            x4 * x684 + 4.0 * x685,
            x4 * x686 + 4.0 * x687,
            x4 * x688 + x690,
            x121 * x692 + x4 * x691,
            x4 * x693 + x695,
            x4 * x696 + 2.0 * x697,
            x4 * x698 + x700,
            x4 * x701 + x703,
            x4 * x704 + 2.0 * x705,
            x4 * x707 + x706,
            x4 * x709 + x708,
            x4 * x711 + x710,
            x4 * x713 + x712,
            x4 * x715 + x714,
            x4 * x716,
            x4 * x717,
            x4 * x718,
            x4 * x719,
            x4 * x720,
            x4 * x721,
            x418 * x614 + x421,
            x418 * x617 + x426 + x615,
            x418 * x619 + x428,
            x191 * x618 + x418 * x621 + x436,
            x418 * x623 + x440 + x620,
            x418 * x625 + x444,
            x418 * x627 + x450 + x622,
            x191 * x624 + x418 * x629 + x457,
            x418 * x631 + x464 + x626,
            x418 * x633 + x467,
            x418 * x636 + x475 + x628 * x81,
            x121 * x630 + x418 * x638 + x481,
            x418 * x640 + x486 + x632,
            x418 * x642 + x490 + x634,
            x418 * x644 + x492,
            x418 * x645 + x496 + 5.0 * x635,
            x418 * x646 + x498 + 4.0 * x637,
            x418 * x647 + x503 + 3.0 * x639,
            x418 * x648 + x505 + 2.0 * x641,
            x418 * x649 + x508 + x643,
            x418 * x650 + x509,
            x510 * x613 + x512,
            x418 * x652 + x510 * x616 + x514,
            x515 * x612 + x521,
            x191 * x654 + x418 * x655 + x525,
            x418 * x518 + x418 * x657 + x529,
            x533 * x612 + x539,
            x418 * x659 + x543 + x656,
            x191 * x658 + x418 * x662 + x550,
            x418 * x536 + x418 * x664 + x556,
            x558 * x612 + x565,
            x418 * x667 + x570 + x660 * x81,
            x121 * x663 + x418 * x669 + x576,
            x418 * x671 + x582 + x665,
            x418 * x562 + x418 * x673 + x587,
            x591 * x612 + x594,
            x418 * x675 + x596 + 5.0 * x666,
            x418 * x676 + x599 + 4.0 * x668,
            x418 * x678 + x602 + 3.0 * x670,
            x418 * x679 + x605 + 2.0 * x672,
            x418 * x680 + x608 + x674,
            x609 * x612 + x611,
            x418 * x682,
            x418 * x684 + x683,
            x418 * x686,
            x418 * x688 + 2.0 * x685,
            x418 * x691 + x687,
            x418 * x693,
            x418 * x696 + x690,
            x418 * x698 + x722,
            x418 * x701 + x694,
            x418 * x704,
            x418 * x707 + 4.0 * x697,
            x121 * x699 + x418 * x709,
            x418 * x711 + x703,
            x418 * x713 + x705,
            x418 * x715,
            x418 * x716 + 5.0 * x706,
            x418 * x717 + 4.0 * x708,
            x418 * x718 + x723,
            x418 * x719 + 2.0 * x712,
            x418 * x720 + x714,
            x418 * x721,
            x510 * x682 + x511,
            x510 * x684 + x513,
            x510 * x686 + x520 + x683,
            x510 * x688 + x524,
            x510 * x691 + x528 + x685,
            x510 * x693 + x538 + 2.0 * x687,
            x510 * x696 + x542,
            x510 * x698 + x549 + x689,
            x510 * x701 + x555 + x722,
            x510 * x704 + x564 + x695,
            x510 * x707 + x569,
            x510 * x709 + x575 + x697,
            x510 * x711 + x581 + x700,
            x121 * x702 + x510 * x713 + x586,
            x510 * x715 + x593 + 4.0 * x705,
            x510 * x716 + x595,
            x510 * x717 + x598 + x706,
            x510 * x718 + x601 + 2.0 * x708,
            x510 * x719 + x604 + x723,
            x510 * x720 + x607 + 4.0 * x712,
            x510 * x721 + x610 + 5.0 * x714,
        ]
    )


def _2center2el3d_40(a, A, b, B):
    """Cartesian (g|s) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - A[0]
    x3 = a ** (-1.0)
    x4 = b * x1
    x5 = a * x4 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x6 = boys(3, x5)
    x7 = 17.4934183276249
    x8 = 2.0 * x3 * x7
    x9 = x0 ** (-1.5) * x8
    x10 = x6 * x9
    x11 = x10 * x2
    x12 = b ** (-1.0)
    x13 = x0 ** (-0.5)
    x14 = boys(2, x5)
    x15 = 0.5 * x3
    x16 = x15 * (-x10 + 2.0 * x12 * x13 * x14 * x3 * x7)
    x17 = boys(4, x5)
    x18 = x2**2
    x19 = x12 * x13 * x8
    x20 = x18 * x19
    x21 = x17 * x20
    x22 = boys(1, x5)
    x23 = x15 * (2.0 * x12 * x13 * x3 * x7 * boys(0, x5) - x22 * x9)
    x24 = x15 * (2.0 * x12 * x13 * x22 * x3 * x7 - x14 * x9)
    x25 = x14 * x19
    x26 = 1.5 * x3
    x27 = x1 * (a * A[1] + b * B[1]) - A[1]
    x28 = x2 * x27
    x29 = x10 * x27
    x30 = x3 * (2.0 * x12 * x13 * x14 * x27 * x3 * x7 - x29)
    x31 = x21 * x27
    x32 = x1 * (a * A[2] + b * B[2]) - A[2]
    x33 = x3 * (-x10 * x32 + 2.0 * x12 * x13 * x14 * x3 * x32 * x7)
    x34 = 0.5 * x33
    x35 = x27**2
    x36 = x19 * x35
    x37 = x17 * x36
    x38 = x16 + x37
    x39 = x23 + x25 * x35 - x4 * (x24 + x36 * x6)
    x40 = x3 * (2.0 * x12 * x13 * x14 * x27 * x3 * x32 * x7 - x29 * x32)
    x41 = x32**2
    x42 = x19 * x41
    x43 = x16 + x17 * x42
    x44 = x23 + x25 * x41 - x4 * (x24 + x42 * x6)
    x45 = x15 * x44
    x46 = x27 * x38 + x30
    x47 = x32 * x37 + x34
    x48 = x32 * x43 + x33

    # 15 item(s)
    return numpy.array(
        [
            x2 * (x2 * (x16 + x21) + x3 * (-x11 + 2.0 * x12 * x13 * x14 * x2 * x3 * x7))
            + x26 * (x18 * x25 + x23 - x4 * (x20 * x6 + x24)),
            x2 * (0.5 * x30 + x31)
            + x3 * (-x10 * x28 + 2.0 * x12 * x13 * x14 * x2 * x27 * x3 * x7),
            x2 * (x21 * x32 + x34)
            + x3 * (-x11 * x32 + 2.0 * x12 * x13 * x14 * x2 * x3 * x32 * x7),
            x15 * x39 + x18 * x38,
            x31 * x32 + 0.5 * x40,
            x18 * x43 + x45,
            x2 * x46,
            x2 * x47,
            x28 * x43,
            x2 * x48,
            x26 * x39 + x27 * x46,
            x27 * x47 + x40,
            x35 * x43 + x45,
            x27 * x48,
            x26 * x44 + x32 * x48,
        ]
    )


def _2center2el3d_41(a, A, b, B):
    """Cartesian (g|p) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = a ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = b * x3
    x7 = a * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x8 = boys(3, x7)
    x9 = 17.4934183276249
    x10 = 2.0 * x1 * x9
    x11 = x10 * x2 ** (-1.5)
    x12 = x11 * x8
    x13 = b ** (-1.0)
    x14 = x2 ** (-0.5)
    x15 = boys(2, x7)
    x16 = 0.5 * x1
    x17 = x16 * (2.0 * x1 * x13 * x14 * x15 * x9 - x12)
    x18 = x5**2
    x19 = boys(4, x7)
    x20 = x10 * x13 * x14
    x21 = x19 * x20
    x22 = x18 * x21
    x23 = x17 + x22
    x24 = x20 * x8
    x25 = x0 * x24
    x26 = -x4 - B[0]
    x27 = x26 * x5
    x28 = x21 * x27
    x29 = x25 + x28
    x30 = x15 * x20
    x31 = x0 * x30
    x32 = x24 * x26
    x33 = x32 * x5
    x34 = x31 + x33
    x35 = x0 * x21
    x36 = x20 * boys(5, x7)
    x37 = x27 * x36
    x38 = x11 * x26
    x39 = x19 * x38
    x40 = x16 * (2.0 * x1 * x13 * x14 * x26 * x8 * x9 - x39)
    x41 = x35 * x5
    x42 = boys(1, x7)
    x43 = x16 * (2.0 * x1 * x13 * x14 * x26 * x42 * x9 - x15 * x38)
    x44 = x16 * (2.0 * x1 * x13 * x14 * x15 * x26 * x9 - x12 * x26)
    x45 = 1.5 * x1
    x46 = -x3 * (a * A[1] + b * B[1])
    x47 = -x46 - B[1]
    x48 = x11 * x47
    x49 = x19 * x48
    x50 = x49 * x5
    x51 = x16 * (2.0 * x1 * x13 * x14 * x47 * x8 * x9 - x49)
    x52 = x18 * x36
    x53 = x47 * x52
    x54 = x16 * (2.0 * x1 * x13 * x14 * x42 * x47 * x9 - x15 * x48)
    x55 = x16 * (2.0 * x1 * x13 * x14 * x15 * x47 * x9 - x12 * x47)
    x56 = x24 * x47
    x57 = -x3 * (a * A[2] + b * B[2])
    x58 = -x57 - B[2]
    x59 = x11 * x58
    x60 = x19 * x59
    x61 = x16 * (2.0 * x1 * x13 * x14 * x58 * x8 * x9 - x60)
    x62 = x52 * x58
    x63 = x16 * (2.0 * x1 * x13 * x14 * x42 * x58 * x9 - x15 * x59)
    x64 = x16 * (2.0 * x1 * x13 * x14 * x15 * x58 * x9 - x12 * x58)
    x65 = x24 * x58
    x66 = -x46 - A[1]
    x67 = x25 * x66
    x68 = x5 * x66
    x69 = x26 * x68
    x70 = x31 * x66
    x71 = x1 * (2.0 * x1 * x13 * x14 * x15 * x66 * x9 - x12 * x66)
    x72 = x35 * x66
    x73 = x36 * x69
    x74 = x39 * x66
    x75 = x1 * (2.0 * x1 * x13 * x14 * x26 * x66 * x8 * x9 - x74)
    x76 = x56 * x66
    x77 = x31 + x76
    x78 = x47 * x66
    x79 = x21 * x78
    x80 = x25 + x79
    x81 = x6 * x80
    x82 = x36 * x78
    x83 = x35 + x82
    x84 = x1 * (x77 - x81)
    x85 = x1 * (2.0 * x1 * x13 * x14 * x58 * x66 * x8 * x9 - x60 * x66)
    x86 = -x57 - A[2]
    x87 = x25 * x86
    x88 = x31 * x86
    x89 = x1 * (2.0 * x1 * x13 * x14 * x15 * x86 * x9 - x12 * x86)
    x90 = 0.5 * x89
    x91 = x35 * x86
    x92 = x1 * (2.0 * x1 * x13 * x14 * x26 * x8 * x86 * x9 - x39 * x86)
    x93 = 0.5 * x92
    x94 = x1 * (2.0 * x1 * x13 * x14 * x47 * x8 * x86 * x9 - x49 * x86)
    x95 = 0.5 * x94
    x96 = x31 + x65 * x86
    x97 = x58 * x86
    x98 = x21 * x97 + x25
    x99 = x6 * x98
    x100 = x35 + x36 * x97
    x101 = x100 * x18
    x102 = x1 * (x96 - x99)
    x103 = 0.5 * x102
    x104 = x66**2
    x105 = x104 * x21
    x106 = x105 + x17
    x107 = x0 * x106
    x108 = x104 * x36
    x109 = x108 * x26
    x110 = x109 + x40
    x111 = x104 * x32 + x43 - x6 * (x105 * x26 + x44)
    x112 = x51 + x66 * x83 + x72
    x113 = x54 - x6 * (x55 + x66 * x80 + x67) + x66 * x77 + x70
    x114 = x108 * x58 + x61
    x115 = x104 * x65 - x6 * (x105 * x58 + x64) + x63
    x116 = x72 * x86
    x117 = x1 * (2.0 * x1 * x13 * x14 * x26 * x66 * x8 * x86 * x9 - x74 * x86)
    x118 = x82 * x86 + x91
    x119 = x1 * (-x6 * (x79 * x86 + x87) + x76 * x86 + x88)
    x120 = x1 * (x66 * x96 - x66 * x99)
    x121 = x86**2
    x122 = x121 * x21
    x123 = x122 + x17
    x124 = x0 * x123
    x125 = x121 * x36
    x126 = x125 * x26 + x40
    x127 = x126 * x5
    x128 = x121 * x32 + x43 - x6 * (x122 * x26 + x44)
    x129 = x128 * x16
    x130 = x125 * x47 + x51
    x131 = x121 * x56 + x54 - x6 * (x122 * x47 + x55)
    x132 = x131 * x16
    x133 = x100 * x86 + x61 + x91
    x134 = -x6 * (x64 + x86 * x98 + x87) + x63 + x86 * x96 + x88
    x135 = x134 * x16
    x136 = x0 * (x106 * x66 + x71)
    x137 = x110 * x66 + x75
    x138 = x107 + x112 * x66 + x84
    x139 = x114 * x66 + x85
    x140 = x0 * (x105 * x86 + x90)
    x141 = x109 * x86 + x93
    x142 = x116 + x118 * x66 + x95
    x143 = x100 * x104 + x103
    x144 = x124 * x66
    x145 = x124 + x130 * x66
    x146 = x0 * (x123 * x86 + x89)
    x147 = x126 * x86 + x92
    x148 = x130 * x86 + x94
    x149 = x102 + x124 + x133 * x86

    # 45 item(s)
    return numpy.array(
        [
            x0 * (x1 * (2.0 * x1 * x13 * x14 * x15 * x5 * x9 - x12 * x5) + x23 * x5)
            + x45 * (x0 * x30 * x5 + x34 * x5 + x43 - x6 * (x25 * x5 + x29 * x5 + x44))
            + x5
            * (x0 * x23 + x1 * (-x29 * x6 + x34) + x5 * (x40 + x41 + x5 * (x35 + x37))),
            x45 * (x18 * x56 + x54 - x6 * (x22 * x47 + x55))
            + x5
            * (x1 * (2.0 * x1 * x13 * x14 * x47 * x5 * x8 * x9 - x50) + x5 * (x51 + x53)),
            x45 * (x18 * x65 - x6 * (x22 * x58 + x64) + x63)
            + x5
            * (
                x1 * (2.0 * x1 * x13 * x14 * x5 * x58 * x8 * x9 - x5 * x60)
                + x5 * (x61 + x62)
            ),
            x0 * (x22 * x66 + 0.5 * x71)
            + x1 * (x32 * x68 - x6 * (x21 * x69 + x67) + x70)
            + x5 * (x35 * x68 + x5 * (x72 + x73) + 0.5 * x75),
            x1 * (x5 * x77 - x5 * x81) + x5 * (x18 * x83 + 0.5 * x84),
            x1 * (2.0 * x1 * x13 * x14 * x5 * x58 * x66 * x8 * x9 - x60 * x68)
            + x5 * (x62 * x66 + 0.5 * x85),
            x0 * (x22 * x86 + x90)
            + x1 * (x33 * x86 - x6 * (x28 * x86 + x87) + x88)
            + x5 * (x41 * x86 + x5 * (x37 * x86 + x91) + x93),
            x1 * (2.0 * x1 * x13 * x14 * x47 * x5 * x8 * x86 * x9 - x50 * x86)
            + x5 * (x53 * x86 + x95),
            x1 * (x5 * x96 - x5 * x99) + x5 * (x101 + x103),
            x107 * x5 + x111 * x16 + x5 * (x107 + x110 * x5),
            x112 * x18 + x113 * x16,
            x114 * x18 + x115 * x16,
            0.5 * x117 + x5 * (x116 + x73 * x86) + x68 * x91,
            x118 * x18 + 0.5 * x119,
            x101 * x66 + 0.5 * x120,
            x124 * x5 + x129 + x5 * (x124 + x127),
            x130 * x18 + x132,
            x133 * x18 + x135,
            x136 + x137 * x5,
            x138 * x5,
            x139 * x5,
            x140 + x141 * x5,
            x142 * x5,
            x143 * x5,
            x127 * x66 + x144,
            x145 * x5,
            x133 * x68,
            x146 + x147 * x5,
            x148 * x5,
            x149 * x5,
            x111 * x45 + x137 * x66,
            x113 * x45 + x136 + x138 * x66,
            x115 * x45 + x139 * x66,
            x117 + x141 * x66,
            x119 + x140 + x142 * x66,
            x120 + x143 * x66,
            x104 * x126 + x129,
            x132 + x144 + x145 * x66,
            x104 * x133 + x135,
            x147 * x66,
            x146 + x148 * x66,
            x149 * x66,
            x128 * x45 + x147 * x86,
            x131 * x45 + x148 * x86,
            x134 * x45 + x146 + x149 * x86,
        ]
    )


def _2center2el3d_42(a, A, b, B):
    """Cartesian (g|d) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a ** (-1.0)
    x5 = b * x1
    x6 = a * x5 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x7 = boys(4, x6)
    x8 = x0 ** (-1.5)
    x9 = b ** (-1.0)
    x10 = 17.4934183276249
    x11 = x10 * x9
    x12 = 2.0 * x11
    x13 = x12 * x8
    x14 = x0 ** (-0.5)
    x15 = boys(3, x6)
    x16 = 0.5 * x9
    x17 = x16 * (2.0 * x10 * x14 * x15 * x4 * x9 - x13 * x7)
    x18 = boys(5, x6)
    x19 = -x2 - B[0]
    x20 = x19**2
    x21 = x12 * x14
    x22 = x21 * x4
    x23 = x20 * x22
    x24 = x17 + x18 * x23
    x25 = x24 * x3
    x26 = x4 * x7
    x27 = (2.0 * a + 2.0 * b) ** (-1.0)
    x28 = x11 * x14
    x29 = 4.0 * x27 * x28
    x30 = x19 * x29
    x31 = x26 * x30
    x32 = x25 + x31
    x33 = boys(2, x6)
    x34 = -2.0 * x10 * x14 * x33 * x4 * x9
    x35 = x16 * (-x13 * x15 - x34)
    x36 = x22 * x7
    x37 = x20 * x36 + x35
    x38 = x3 * x37
    x39 = x15 * x4
    x40 = x30 * x39
    x41 = x38 + x40
    x42 = x16 * (2.0 * x10 * x14 * x4 * x7 * x9 - x13 * x18)
    x43 = boys(6, x6)
    x44 = x23 * x43 + x42
    x45 = x3 * x44
    x46 = x18 * x4
    x47 = x30 * x46
    x48 = x24 * x5
    x49 = 0.5 * x4
    x50 = x49 * (x37 - x48)
    x51 = 2.0 * x27
    x52 = x28 * x51
    x53 = x26 * x52
    x54 = x19 * x3
    x55 = x18 * x22
    x56 = x54 * x55
    x57 = x53 + x56
    x58 = 2.0 * x10 * x8
    x59 = x26 * x58
    x60 = x19 * x59
    x61 = x49 * (2.0 * x10 * x14 * x15 * x19 * x4 * x9 - x60)
    x62 = x3 * x53
    x63 = x3 * x57 + x61 + x62
    x64 = x39 * x52
    x65 = x36 * x54 + x64
    x66 = x4 * x52
    x67 = x33 * x66
    x68 = x21 * x39
    x69 = x19 * x3 * x68 + x67
    x70 = x39 * x58
    x71 = x49 * (-x34 - x70)
    x72 = x3**2
    x73 = x36 * x72
    x74 = boys(1, x6)
    x75 = x16 * (2.0 * x10 * x14 * x4 * x9 * boys(0, x6) - x13 * x74)
    x76 = x16 * (2.0 * x10 * x14 * x4 * x74 * x9 - x13 * x33)
    x77 = x20 * x68 + x76
    x78 = x22 * x33
    x79 = x49 * (x20 * x78 - x5 * x77 + x75)
    x80 = x49 * (-x37 * x5 + x77)
    x81 = 1.5 * x4
    x82 = -x1 * (a * A[1] + b * B[1])
    x83 = -x82 - B[1]
    x84 = x59 * x83
    x85 = x49 * (2.0 * x10 * x14 * x15 * x4 * x83 * x9 - x84)
    x86 = x55 * x72
    x87 = x83 * x86
    x88 = x85 + x87
    x89 = x53 * x83
    x90 = x19 * x83
    x91 = x3 * x90
    x92 = x55 * x91
    x93 = x89 + x92
    x94 = x64 * x83
    x95 = x36 * x90
    x96 = x3 * x95
    x97 = x94 + x96
    x98 = x18 * x66
    x99 = x83 * x98
    x100 = x22 * x43
    x101 = x100 * x91
    x102 = x46 * x58
    x103 = x102 * x90
    x104 = x49 * (2.0 * x10 * x14 * x19 * x4 * x7 * x83 * x9 - x103)
    x105 = x3 * x99
    x106 = x49 * (2.0 * x10 * x14 * x19 * x33 * x4 * x83 * x9 - x70 * x90)
    x107 = x49 * (2.0 * x10 * x14 * x15 * x19 * x4 * x83 * x9 - x60 * x83)
    x108 = -x1 * (a * A[2] + b * B[2])
    x109 = -x108 - B[2]
    x110 = x109 * x59
    x111 = x49 * (2.0 * x10 * x109 * x14 * x15 * x4 * x9 - x110)
    x112 = x109 * x86
    x113 = x111 + x112
    x114 = x109 * x53
    x115 = x109 * x19
    x116 = x115 * x3
    x117 = x114 + x116 * x55
    x118 = x109 * x64
    x119 = x115 * x36
    x120 = x118 + x119 * x3
    x121 = x109 * x98
    x122 = x102 * x115
    x123 = x49 * (2.0 * x10 * x109 * x14 * x19 * x4 * x7 * x9 - x122)
    x124 = x49 * (2.0 * x10 * x109 * x14 * x19 * x33 * x4 * x9 - x115 * x70)
    x125 = x49 * (2.0 * x10 * x109 * x14 * x15 * x19 * x4 * x9 - x109 * x60)
    x126 = x83**2
    x127 = x126 * x36 + x35
    x128 = x126 * x22
    x129 = x128 * x18 + x17
    x130 = x129 * x5
    x131 = x130 * x3
    x132 = x128 * x43 + x42
    x133 = x132 * x72
    x134 = x49 * (x127 - x130)
    x135 = x126 * x68 + x76
    x136 = x49 * (x126 * x78 - x135 * x5 + x75)
    x137 = x49 * (-x127 * x5 + x135)
    x138 = x109 * x83
    x139 = x102 * x138
    x140 = x49 * (2.0 * x10 * x109 * x14 * x4 * x7 * x83 * x9 - x139)
    x141 = x100 * x138
    x142 = x49 * (2.0 * x10 * x109 * x14 * x33 * x4 * x83 * x9 - x138 * x70)
    x143 = x49 * (2.0 * x10 * x109 * x14 * x15 * x4 * x83 * x9 - x109 * x84)
    x144 = x109**2
    x145 = x144 * x36 + x35
    x146 = x144 * x22
    x147 = x146 * x18 + x17
    x148 = x147 * x5
    x149 = x146 * x43 + x42
    x150 = x149 * x72
    x151 = x49 * (x145 - x148)
    x152 = x144 * x68 + x76
    x153 = x49 * (x144 * x78 - x152 * x5 + x75)
    x154 = x49 * (-x145 * x5 + x152)
    x155 = -x82 - A[1]
    x156 = x155 * x45
    x157 = x155 * x47
    x158 = x155 * x48
    x159 = x4 * (x155 * x37 - x158)
    x160 = x155 * x53
    x161 = x155 * x3
    x162 = x161 * x55
    x163 = x162 * x19
    x164 = x160 + x163
    x165 = x4 * (2.0 * x10 * x14 * x15 * x155 * x19 * x4 * x9 - x155 * x60)
    x166 = x155 * x68 * x83 + x67
    x167 = x166 * x27
    x168 = x19 * x64
    x169 = x155 * x95
    x170 = x168 + x169
    x171 = x155 * x83
    x172 = x171 * x36 + x64
    x173 = x172 * x27
    x174 = x19 * x53
    x175 = x155 * x90
    x176 = x175 * x55
    x177 = x174 + x176
    x178 = x171 * x55
    x179 = x178 + x53
    x180 = x4 * (x166 - x172 * x5)
    x181 = x179 * x27
    x182 = x19 * x98
    x183 = x100 * x175
    x184 = x182 + x183
    x185 = x4 * (x170 - x177 * x5)
    x186 = x114 * x155
    x187 = x118 * x155
    x188 = x4 * (2.0 * x10 * x109 * x14 * x15 * x155 * x4 * x9 - x110 * x155)
    x189 = x121 * x155
    x190 = x100 * x115
    x191 = x4 * (2.0 * x10 * x109 * x14 * x155 * x19 * x4 * x7 * x9 - x122 * x155)
    x192 = x127 * x155
    x193 = x29 * x83
    x194 = x193 * x39
    x195 = x192 + x194
    x196 = x129 * x155
    x197 = x193 * x26
    x198 = x196 + x197
    x199 = x198 * x5
    x200 = x132 * x155
    x201 = x193 * x46
    x202 = x200 + x201
    x203 = x4 * (x195 - x199)
    x204 = x138 * x36
    x205 = x118 + x155 * x204
    x206 = x138 * x55
    x207 = x114 + x155 * x206
    x208 = x207 * x5
    x209 = x121 + x141 * x155
    x210 = x4 * (x205 - x208)
    x211 = x4 * (x145 * x155 - x148 * x155)
    x212 = -x108 - A[2]
    x213 = x4 * (x212 * x37 - x212 * x48)
    x214 = 0.5 * x213
    x215 = x212 * x53
    x216 = x212 * x56 + x215
    x217 = x4 * (2.0 * x10 * x14 * x15 * x19 * x212 * x4 * x9 - x212 * x60)
    x218 = 0.5 * x217
    x219 = x212 * x89
    x220 = x212 * x94
    x221 = x4 * (2.0 * x10 * x14 * x15 * x212 * x4 * x83 * x9 - x212 * x84)
    x222 = 0.5 * x221
    x223 = x212 * x99
    x224 = x4 * (2.0 * x10 * x14 * x19 * x212 * x4 * x7 * x83 * x9 - x103 * x212)
    x225 = 0.5 * x224
    x226 = x109 * x212 * x68 + x67
    x227 = x226 * x27
    x228 = x119 * x212 + x168
    x229 = x109 * x212
    x230 = x229 * x36 + x64
    x231 = x230 * x27
    x232 = x115 * x212
    x233 = x174 + x232 * x55
    x234 = x229 * x55 + x53
    x235 = x4 * (x226 - x230 * x5)
    x236 = 0.5 * x235
    x237 = x234 * x27
    x238 = x100 * x232 + x182
    x239 = x238 * x3
    x240 = x233 * x5
    x241 = x4 * (x228 - x240)
    x242 = 0.5 * x241
    x243 = x237 * x3
    x244 = x4 * (x127 * x212 - x130 * x212)
    x245 = 0.5 * x244
    x246 = x204 * x212 + x94
    x247 = x206 * x212 + x89
    x248 = x247 * x5
    x249 = x141 * x212 + x99
    x250 = x4 * (x246 - x248)
    x251 = 0.5 * x250
    x252 = x109 * x29
    x253 = x145 * x212 + x252 * x39
    x254 = x147 * x212 + x252 * x26
    x255 = x254 * x5
    x256 = x149 * x212 + x252 * x46
    x257 = x256 * x72
    x258 = x4 * (x253 - x255)
    x259 = 0.5 * x258
    x260 = x155**2
    x261 = x260 * x44
    x262 = x261 + x50
    x263 = x260 * x55
    x264 = x19 * x263
    x265 = x264 + x61
    x266 = x265 * x27
    x267 = x260 * x37 - x5 * (x24 * x260 + x80) + x79
    x268 = x260 * x36
    x269 = x27 * (x268 + x71)
    x270 = x155 * x179 + x160 + x85
    x271 = x27 * x270
    x272 = x155 * x182
    x273 = x104 + x155 * x184 + x272
    x274 = x106 + x155 * x168 + x155 * x170 - x5 * (x107 + x155 * x177 + x160 * x19)
    x275 = x109 * x263 + x111
    x276 = x27 * x275
    x277 = x123 + x190 * x260
    x278 = x115 * x268 + x124 - x5 * (x115 * x263 + x125)
    x279 = x134 + x155 * x202 + 2.0 * x181
    x280 = x136 + x155 * x195 + 2.0 * x167 - x5 * (x137 + x155 * x198 + 2.0 * x173)
    x281 = x140 + x155 * x209 + x189
    x282 = x142 + x155 * x205 + x187 - x5 * (x143 + x155 * x207 + x186)
    x283 = x149 * x260 + x151
    x284 = x145 * x260 + x153 - x5 * (x147 * x260 + x154)
    x285 = x4 * (x155 * x212 * x37 - x158 * x212)
    x286 = x160 * x212
    x287 = x178 * x212 + x215
    x288 = x27 * x287
    x289 = x182 * x212
    x290 = x183 * x212 + x289
    x291 = x174 * x212
    x292 = x168 * x212
    x293 = x4 * (x169 * x212 + x292 - x5 * (x176 * x212 + x291))
    x294 = x155 * x237
    x295 = x4 * (x155 * x228 - x155 * x240)
    x296 = x200 * x212 + x201 * x212
    x297 = x4 * (x192 * x212 + x194 * x212 - x5 * (x196 * x212 + x197 * x212))
    x298 = x155 * x249 + x237
    x299 = x4 * (x155 * x246 + x227 - x5 * (x155 * x247 + x231))
    x300 = x4 * (x155 * x253 - x155 * x255)
    x301 = x212**2
    x302 = x301 * x44 + x50
    x303 = x3 * x302
    x304 = x301 * x55
    x305 = x19 * x304 + x61
    x306 = x27 * x305
    x307 = 2.0 * x306
    x308 = x301 * x37 - x5 * (x24 * x301 + x80) + x79
    x309 = x308 * x49
    x310 = x301 * x36
    x311 = x27 * (x310 + x71)
    x312 = x304 * x83 + x85
    x313 = x27 * x312
    x314 = x100 * x301 * x90 + x104
    x315 = x106 + x310 * x90 - x5 * (x107 + x304 * x90)
    x316 = x315 * x49
    x317 = x111 + x212 * x234 + x215
    x318 = x27 * x317
    x319 = x123 + x212 * x238 + x289
    x320 = x3 * x319
    x321 = x124 + x212 * x228 + x292 - x5 * (x125 + x212 * x233 + x291)
    x322 = x321 * x49
    x323 = x132 * x301 + x134
    x324 = x127 * x301 + x136 - x5 * (x129 * x301 + x137)
    x325 = x324 * x49
    x326 = x140 + x212 * x249 + x223
    x327 = x142 + x212 * x246 + x220 - x5 * (x143 + x212 * x247 + x219)
    x328 = x327 * x49
    x329 = x151 + x212 * x256 + 2.0 * x237
    x330 = x153 + x212 * x253 + 2.0 * x227 - x5 * (x154 + x212 * x254 + 2.0 * x231)
    x331 = x330 * x49
    x332 = x155 * x262 + x159
    x333 = x27 * (x155 * x265 + x165)
    x334 = x27 * (x155 * x270 + x180 + x269)
    x335 = x155 * x273 + x185 + x266
    x336 = x27 * (x155 * x275 + x188)
    x337 = x155 * x277 + x191
    x338 = x155 * x279 + x203 + 2.0 * x271
    x339 = x155 * x281 + x210 + x276
    x340 = x155 * x283 + x211
    x341 = x212 * x261 + x214
    x342 = x27 * (x212 * x264 + x218)
    x343 = x27 * (x155 * x287 + x222 + x286)
    x344 = x155 * x290 + x212 * x272 + x225
    x345 = x27 * (x234 * x260 + x236)
    x346 = x238 * x260 + x242
    x347 = x155 * x296 + x245 + 2.0 * x288
    x348 = x155 * x298 + x251 + x294
    x349 = x256 * x260 + x259
    x350 = x27 * (x155 * x312 + x311)
    x351 = x155 * x314 + x306
    x352 = x155 * x318
    x353 = x155 * x323 + 2.0 * x313
    x354 = x155 * x326 + x318
    x355 = x212 * x302 + x213
    x356 = x27 * (x212 * x305 + x217)
    x357 = x27 * (x212 * x312 + x221)
    x358 = x212 * x314 + x224
    x359 = x27 * (x212 * x317 + x235 + x311)
    x360 = x212 * x319 + x241 + x306
    x361 = x212 * x323 + x244
    x362 = x212 * x326 + x250 + x313
    x363 = x212 * x329 + x258 + 2.0 * x318

    # 90 item(s)
    return numpy.array(
        [
            x3
            * (
                x3 * (x3 * (x45 + x47) + x50 + x51 * x57)
                + x4 * (-x32 * x5 + x41)
                + x51 * x63
            )
            + x51 * (x27 * (x71 + x73) + x3 * x63 + x4 * (-x5 * x65 + x69))
            + x81 * (x3 * x41 - x5 * (x3 * x32 + x51 * x65 + x80) + x51 * x69 + x79),
            x27
            * (x3 * x88 + x4 * (2.0 * x10 * x14 * x15 * x3 * x4 * x83 * x9 - x3 * x84))
            + x3
            * (
                x27 * x88
                + x3 * (x104 + x105 + x3 * (x101 + x99))
                + x4 * (-x5 * x93 + x97)
            )
            + x81 * (x106 + x3 * x94 + x3 * x97 - x5 * (x107 + x3 * x93 + x62 * x83)),
            x27
            * (x113 * x3 + x4 * (2.0 * x10 * x109 * x14 * x15 * x3 * x4 * x9 - x110 * x3))
            + x3
            * (
                x113 * x27
                + x3 * (x121 * x3 + x123 + x3 * (x100 * x116 + x121))
                + x4 * (-x117 * x5 + x120)
            )
            + x81 * (x118 * x3 + x120 * x3 + x124 - x5 * (x109 * x62 + x117 * x3 + x125)),
            x3 * (x3 * (x133 + x134) + x4 * (x127 * x3 - x131))
            + x81 * (x127 * x72 + x136 - x5 * (x129 * x72 + x137)),
            x3
            * (
                x3 * (x140 + x141 * x72)
                + x4 * (2.0 * x10 * x109 * x14 * x3 * x4 * x7 * x83 * x9 - x139 * x3)
            )
            + x81 * (x138 * x73 + x142 - x5 * (x138 * x86 + x143)),
            x3 * (x3 * (x150 + x151) + x4 * (x145 * x3 - x148 * x3))
            + x81 * (x145 * x72 + x153 - x5 * (x147 * x72 + x154)),
            x3 * (0.5 * x159 + x164 * x51 + x3 * (x156 + x157))
            + x4 * (x155 * x38 + x155 * x40 - x5 * (x155 * x25 + x155 * x31))
            + x51 * (x161 * x53 + x164 * x3 + 0.5 * x165),
            x27 * (x179 * x72 + 0.5 * x180)
            + x3 * (x181 * x3 + 0.5 * x185 + x3 * (x181 + x184 * x3))
            + x4 * (x167 + x170 * x3 - x5 * (x173 + x177 * x3)),
            x27 * (x112 * x155 + 0.5 * x188)
            + x3 * (x121 * x161 + 0.5 * x191 + x3 * (x161 * x190 + x189))
            + x4 * (x119 * x161 + x187 - x5 * (x115 * x162 + x186)),
            x3 * (x202 * x72 + 0.5 * x203) + x4 * (x195 * x3 - x199 * x3),
            x3 * (x209 * x72 + 0.5 * x210) + x4 * (x205 * x3 - x208 * x3),
            x3 * (x150 * x155 + 0.5 * x211) + x4 * (x145 * x155 * x3 - x148 * x161),
            x3 * (x214 + x216 * x51 + x3 * (x212 * x45 + x212 * x47))
            + x4 * (x212 * x38 + x212 * x40 - x5 * (x212 * x25 + x212 * x31))
            + x51 * (x212 * x62 + x216 * x3 + x218),
            x27 * (x212 * x87 + x222)
            + x3 * (x105 * x212 + x225 + x3 * (x101 * x212 + x223))
            + x4 * (x212 * x96 + x220 - x5 * (x212 * x92 + x219)),
            x27 * (x234 * x72 + x236)
            + x3 * (x242 + x243 + x3 * (x237 + x239))
            + x4 * (x227 + x228 * x3 - x5 * (x231 + x233 * x3)),
            x3 * (x133 * x212 + x245) + x4 * (x127 * x212 * x3 - x131 * x212),
            x3 * (x249 * x72 + x251) + x4 * (x246 * x3 - x248 * x3),
            x3 * (x257 + x259) + x4 * (x253 * x3 - x255 * x3),
            x267 * x49 + x3 * (x262 * x3 + 2.0 * x266) + x51 * (x265 * x3 + x269),
            x271 * x3 + x274 * x49 + x3 * (x271 + x273 * x3),
            x276 * x3 + x278 * x49 + x3 * (x276 + x277 * x3),
            x279 * x72 + x280 * x49,
            x281 * x72 + x282 * x49,
            x283 * x72 + x284 * x49,
            0.5 * x285 + x3 * (x156 * x212 + x157 * x212) + x51 * (x163 * x212 + x286),
            x288 * x3 + 0.5 * x293 + x3 * (x288 + x290 * x3),
            x155 * x243 + 0.5 * x295 + x3 * (x155 * x239 + x294),
            x296 * x72 + 0.5 * x297,
            x298 * x72 + 0.5 * x299,
            x155 * x257 + 0.5 * x300,
            x3 * (x303 + x307) + x309 + x51 * (x3 * x305 + x311),
            x3 * x313 + x3 * (x3 * x314 + x313) + x316,
            x3 * x318 + x3 * (x318 + x320) + x322,
            x323 * x72 + x325,
            x326 * x72 + x328,
            x329 * x72 + x331,
            x3 * x332 + 2.0 * x333,
            x3 * x335 + x334,
            x3 * x337 + x336,
            x3 * x338,
            x3 * x339,
            x3 * x340,
            x3 * x341 + 2.0 * x342,
            x3 * x344 + x343,
            x3 * x346 + x345,
            x3 * x347,
            x3 * x348,
            x3 * x349,
            x155 * x303 + x155 * x307,
            x3 * x351 + x350,
            x155 * x320 + x352,
            x3 * x353,
            x3 * x354,
            x161 * x329,
            x3 * x355 + 2.0 * x356,
            x3 * x358 + x357,
            x3 * x360 + x359,
            x3 * x361,
            x3 * x362,
            x3 * x363,
            x155 * x332 + x267 * x81,
            x155 * x335 + x274 * x81 + x333,
            x155 * x337 + x278 * x81,
            x155 * x338 + x280 * x81 + 2.0 * x334,
            x155 * x339 + x282 * x81 + x336,
            x155 * x340 + x284 * x81,
            x155 * x341 + x285,
            x155 * x344 + x293 + x342,
            x155 * x346 + x295,
            x155 * x347 + x297 + 2.0 * x343,
            x155 * x348 + x299 + x345,
            x155 * x349 + x300,
            x260 * x302 + x309,
            x155 * x306 + x155 * x351 + x316,
            x260 * x319 + x322,
            x155 * x353 + x325 + 2.0 * x350,
            x155 * x354 + x328 + x352,
            x260 * x329 + x331,
            x155 * x355,
            x155 * x358 + x356,
            x155 * x360,
            x155 * x361 + 2.0 * x357,
            x155 * x362 + x359,
            x155 * x363,
            x212 * x355 + x308 * x81,
            x212 * x358 + x315 * x81,
            x212 * x360 + x321 * x81 + x356,
            x212 * x361 + x324 * x81,
            x212 * x362 + x327 * x81 + x357,
            x212 * x363 + x330 * x81 + 2.0 * x359,
        ]
    )


def _2center2el3d_43(a, A, b, B):
    """Cartesian (g|f) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a ** (-1.0)
    x5 = b ** (-1.0)
    x6 = -x2 - B[0]
    x7 = b * x1
    x8 = a * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(5, x8)
    x10 = x0 ** (-1.5)
    x11 = 17.4934183276249
    x12 = x11 * x5
    x13 = 2.0 * x12
    x14 = x10 * x13
    x15 = x14 * x9
    x16 = x0 ** (-0.5)
    x17 = boys(4, x8)
    x18 = 0.5 * x5
    x19 = x18 * (2.0 * x11 * x16 * x17 * x4 * x5 - x15)
    x20 = boys(6, x8)
    x21 = x6**2
    x22 = x16 * x4
    x23 = x13 * x22
    x24 = x21 * x23
    x25 = x20 * x24
    x26 = x19 + x25
    x27 = x26 * x6 + x5 * (2.0 * x11 * x16 * x17 * x4 * x5 * x6 - x15 * x6)
    x28 = x27 * x3
    x29 = (2.0 * a + 2.0 * b) ** (-1.0)
    x30 = x14 * x17
    x31 = boys(3, x8)
    x32 = x18 * (2.0 * x11 * x16 * x31 * x4 * x5 - x30)
    x33 = x23 * x9
    x34 = x21 * x33
    x35 = x32 + x34
    x36 = x29 * x35
    x37 = 3.0 * x36
    x38 = x28 + x37
    x39 = -2.0 * x11 * x16 * x31 * x4 * x5 * x6
    x40 = x35 * x6 + x5 * (-x30 * x6 - x39)
    x41 = x3 * x40
    x42 = x14 * x31
    x43 = boys(2, x8)
    x44 = x18 * (2.0 * x11 * x16 * x4 * x43 * x5 - x42)
    x45 = x17 * x23
    x46 = x21 * x45
    x47 = x44 + x46
    x48 = x29 * x47
    x49 = 3.0 * x48
    x50 = x41 + x49
    x51 = x14 * x20
    x52 = x18 * (2.0 * x11 * x16 * x4 * x5 * x9 - x51)
    x53 = boys(7, x8)
    x54 = x24 * x53
    x55 = x5 * (2.0 * x11 * x16 * x4 * x5 * x6 * x9 - x51 * x6) + x6 * (x52 + x54)
    x56 = x3 * x55
    x57 = x26 * x29
    x58 = 3.0 * x57
    x59 = x27 * x7
    x60 = 0.5 * x4
    x61 = x60 * (x40 - x59)
    x62 = x26 * x3
    x63 = x6 * x9
    x64 = x12 * x22
    x65 = 4.0 * x29 * x64
    x66 = x63 * x65
    x67 = x62 + x66
    x68 = 3.0 * x29
    x69 = x35 * x7
    x70 = x60 * (x47 - x69)
    x71 = 2.0 * x29
    x72 = x64 * x71
    x73 = x17 * x72
    x74 = x3 * x6
    x75 = x33 * x74
    x76 = x73 + x75
    x77 = x3 * x67 + x70 + x71 * x76
    x78 = x17 * x6
    x79 = x65 * x78
    x80 = x3 * x35 + x79
    x81 = x31 * x6
    x82 = x3 * x47 + x65 * x81
    x83 = 2.0 * x10 * x11 * x4
    x84 = x78 * x83
    x85 = x60 * (-x39 - x84)
    x86 = x3 * x73
    x87 = x14 * x43
    x88 = boys(1, x8)
    x89 = x18 * (2.0 * x11 * x16 * x4 * x5 * x88 - x87)
    x90 = x23 * x31
    x91 = x21 * x90
    x92 = x47 * x6 + x5 * (2.0 * x11 * x16 * x4 * x43 * x5 * x6 - x42 * x6)
    x93 = x60 * (
        x5 * (2.0 * x11 * x16 * x4 * x5 * x6 * x88 - x6 * x87)
        + x6 * (x89 + x91)
        - x7 * x92
    )
    x94 = x60 * (-x40 * x7 + x92)
    x95 = 1.5 * x4
    x96 = -x1 * (a * A[1] + b * B[1])
    x97 = -x96 - B[1]
    x98 = x5 * (2.0 * x11 * x16 * x17 * x4 * x5 * x97 - x15 * x97)
    x99 = x25 * x97 + 0.5 * x98
    x100 = x3 * x99
    x101 = x66 * x97
    x102 = x100 + x101
    x103 = -2.0 * x11 * x16 * x31 * x4 * x5 * x97
    x104 = x5 * (-x103 - x30 * x97)
    x105 = 0.5 * x104 + x34 * x97
    x106 = x105 * x3
    x107 = x79 * x97
    x108 = x106 + x107
    x109 = x5 * (2.0 * x11 * x16 * x4 * x5 * x9 * x97 - x51 * x97)
    x110 = 0.5 * x109 + x54 * x97
    x111 = x110 * x3
    x112 = x20 * x97
    x113 = x112 * x6
    x114 = x113 * x65
    x115 = x7 * x99
    x116 = x60 * (x105 - x115)
    x117 = x9 * x97
    x118 = x117 * x72
    x119 = x23 * x74
    x120 = x112 * x119
    x121 = x118 + x120
    x122 = x63 * x83
    x123 = x122 * x97
    x124 = x60 * (2.0 * x11 * x16 * x17 * x4 * x5 * x6 * x97 - x123)
    x125 = x118 * x3
    x126 = x121 * x3 + x124 + x125
    x127 = x73 * x97
    x128 = x33 * x97
    x129 = x128 * x74
    x130 = x127 + x129
    x131 = x31 * x72
    x132 = x131 * x97
    x133 = x45 * x97
    x134 = x132 + x133 * x74
    x135 = x17 * x83
    x136 = x60 * (-x103 - x135 * x97)
    x137 = x3**2
    x138 = x5 * (2.0 * x11 * x16 * x4 * x5 * x88 * x97 - x87 * x97)
    x139 = x5 * (2.0 * x11 * x16 * x4 * x43 * x5 * x97 - x42 * x97)
    x140 = 0.5 * x139 + x46 * x97
    x141 = x60 * (0.5 * x138 - x140 * x7 + x91 * x97)
    x142 = x60 * (-x105 * x7 + x140)
    x143 = -x1 * (a * A[2] + b * B[2])
    x144 = -x143 - B[2]
    x145 = x5 * (2.0 * x11 * x144 * x16 * x17 * x4 * x5 - x144 * x15)
    x146 = 0.5 * x145
    x147 = x144 * x25 + x146
    x148 = x147 * x3
    x149 = x144 * x66
    x150 = x148 + x149
    x151 = -2.0 * x11 * x144 * x16 * x31 * x4 * x5
    x152 = x5 * (-x144 * x30 - x151)
    x153 = 0.5 * x152
    x154 = x144 * x34 + x153
    x155 = x154 * x3
    x156 = x144 * x79
    x157 = x155 + x156
    x158 = x5 * (2.0 * x11 * x144 * x16 * x4 * x5 * x9 - x144 * x51)
    x159 = 0.5 * x158
    x160 = x144 * x54 + x159
    x161 = x160 * x3
    x162 = x144 * x65
    x163 = x20 * x6
    x164 = x162 * x163
    x165 = x147 * x7
    x166 = x60 * (x154 - x165)
    x167 = x144 * x9
    x168 = x167 * x72
    x169 = x119 * x144 * x20
    x170 = x168 + x169
    x171 = x122 * x144
    x172 = x60 * (2.0 * x11 * x144 * x16 * x17 * x4 * x5 * x6 - x171)
    x173 = x168 * x3 + x170 * x3 + x172
    x174 = x144 * x73
    x175 = x144 * x33
    x176 = x174 + x175 * x74
    x177 = x131 * x144
    x178 = x144 * x45
    x179 = x177 + x178 * x74
    x180 = x60 * (-x135 * x144 - x151)
    x181 = x5 * (2.0 * x11 * x144 * x16 * x4 * x5 * x88 - x144 * x87)
    x182 = 0.5 * x181
    x183 = x5 * (2.0 * x11 * x144 * x16 * x4 * x43 * x5 - x144 * x42)
    x184 = 0.5 * x183
    x185 = x144 * x46 + x184
    x186 = x60 * (x144 * x91 + x182 - x185 * x7)
    x187 = x60 * (-x154 * x7 + x185)
    x188 = x97**2
    x189 = x188 * x45 + x44
    x190 = x188 * x33 + x32
    x191 = x190 * x7
    x192 = x188 * x23
    x193 = x192 * x20
    x194 = x19 + x193
    x195 = x137 * x194
    x196 = x60 * (x189 - x191)
    x197 = x195 + x196
    x198 = x190 * x29
    x199 = x194 * x74
    x200 = x198 + x199
    x201 = x189 * x29
    x202 = x190 * x6
    x203 = x202 * x3
    x204 = x201 + x203
    x205 = x194 * x29
    x206 = x192 * x53
    x207 = x206 + x52
    x208 = x207 * x74
    x209 = x6 * x7
    x210 = x194 * x209
    x211 = x60 * (x190 * x6 - x210)
    x212 = x205 * x3
    x213 = x188 * x90 + x89
    x214 = x60 * (-x189 * x6 * x7 + x213 * x6)
    x215 = x60 * (x189 * x6 - x202 * x7)
    x216 = x144 * x83
    x217 = x117 * x216
    x218 = x60 * (2.0 * x11 * x144 * x16 * x17 * x4 * x5 * x97 - x217)
    x219 = x112 * x144
    x220 = x219 * x23
    x221 = x137 * x220 + x218
    x222 = x118 * x144 + x120 * x144
    x223 = x127 * x144 + x129 * x144
    x224 = x219 * x72
    x225 = x144 * x97
    x226 = x225 * x53
    x227 = x60 * (2.0 * x11 * x144 * x16 * x4 * x5 * x6 * x9 * x97 - x113 * x216)
    x228 = x60 * (2.0 * x11 * x144 * x16 * x31 * x4 * x5 * x6 * x97 - x225 * x84)
    x229 = x60 * (2.0 * x11 * x144 * x16 * x17 * x4 * x5 * x6 * x97 - x123 * x144)
    x230 = x144**2
    x231 = x230 * x45 + x44
    x232 = x230 * x33 + x32
    x233 = x232 * x7
    x234 = x23 * x230
    x235 = x19 + x20 * x234
    x236 = x137 * x235
    x237 = x60 * (x231 - x233)
    x238 = x236 + x237
    x239 = x232 * x29
    x240 = x235 * x74
    x241 = x239 + x240
    x242 = x231 * x29
    x243 = x232 * x6
    x244 = x243 * x3
    x245 = x242 + x244
    x246 = x235 * x29
    x247 = x234 * x53 + x52
    x248 = x247 * x74
    x249 = x209 * x235
    x250 = x60 * (x232 * x6 - x249)
    x251 = x246 * x3
    x252 = x230 * x90 + x89
    x253 = x60 * (-x231 * x6 * x7 + x252 * x6)
    x254 = x60 * (x231 * x6 - x243 * x7)
    x255 = x104 + x190 * x97
    x256 = x194 * x97 + x98
    x257 = x256 * x7
    x258 = x257 * x3
    x259 = x109 + x207 * x97
    x260 = x137 * x259
    x261 = x60 * (x255 - x257)
    x262 = x139 + x189 * x97
    x263 = x60 * (x138 + x213 * x97 - x262 * x7)
    x264 = x60 * (-x255 * x7 + x262)
    x265 = x153 + x175 * x188
    x266 = x144 * x193 + x146
    x267 = x266 * x7
    x268 = x144 * x206 + x159
    x269 = x60 * (x265 - x267)
    x270 = x178 * x188 + x184
    x271 = x60 * (x144 * x188 * x90 + x182 - x270 * x7)
    x272 = x60 * (-x265 * x7 + x270)
    x273 = x235 * x97
    x274 = x273 * x7
    x275 = x60 * (x232 * x97 - x274)
    x276 = x247 * x97
    x277 = x60 * (-x231 * x7 * x97 + x252 * x97)
    x278 = x232 * x97
    x279 = x60 * (x231 * x97 - x278 * x7)
    x280 = x144 * x232 + x152
    x281 = x144 * x235 + x145
    x282 = x281 * x7
    x283 = x144 * x247 + x158
    x284 = x137 * x283
    x285 = x60 * (x280 - x282)
    x286 = x144 * x231 + x183
    x287 = x60 * (x144 * x252 + x181 - x286 * x7)
    x288 = x60 * (-x280 * x7 + x286)
    x289 = -x96 - A[1]
    x290 = x289 * x47
    x291 = x289 * x56
    x292 = x289 * x58
    x293 = x289 * x59
    x294 = x4 * (x289 * x40 - x293)
    x295 = x289 * x62
    x296 = x289 * x66
    x297 = x295 + x296
    x298 = x4 * (x289 * x47 - x289 * x69)
    x299 = x289 * x73
    x300 = x105 * x289
    x301 = x300 + x48
    x302 = x72 * x81
    x303 = x45 * x6
    x304 = x289 * x303 * x97 + x302
    x305 = x304 * x71
    x306 = x289 * x99
    x307 = x306 + x36
    x308 = x72 * x78
    x309 = x33 * x6
    x310 = x289 * x309 * x97 + x308
    x311 = x310 * x71
    x312 = x110 * x289
    x313 = x312 + x57
    x314 = x63 * x72
    x315 = x113 * x23
    x316 = x289 * x315
    x317 = x314 + x316
    x318 = x317 * x71
    x319 = x4 * (x301 - x307 * x7)
    x320 = x128 * x289
    x321 = x320 + x73
    x322 = x29 * x321
    x323 = x3 * x317 + x322
    x324 = x4 * (x304 - x310 * x7)
    x325 = x4 * (x154 * x289 - x165 * x289)
    x326 = x168 * x289
    x327 = x169 * x289 + x326
    x328 = x4 * (2.0 * x11 * x144 * x16 * x17 * x289 * x4 * x5 * x6 - x171 * x289)
    x329 = x289 * x3
    x330 = x65 * x97
    x331 = x189 * x289 + x31 * x330
    x332 = x29 * x331
    x333 = x202 * x289
    x334 = x107 + x333
    x335 = x17 * x330 + x190 * x289
    x336 = x29 * x335
    x337 = x194 * x289
    x338 = x337 * x6
    x339 = x101 + x338
    x340 = x117 * x65
    x341 = x337 + x340
    x342 = x4 * (x331 - x335 * x7)
    x343 = x29 * x341
    x344 = x207 * x6
    x345 = x289 * x344
    x346 = x114 + x345
    x347 = x4 * (x334 - x339 * x7)
    x348 = x133 * x144
    x349 = x177 + x289 * x348
    x350 = x29 * x349
    x351 = x144 * x308
    x352 = x225 * x309
    x353 = x289 * x352 + x351
    x354 = x144 * x320 + x174
    x355 = x29 * x354
    x356 = x144 * x314
    x357 = x144 * x316 + x356
    x358 = x168 + x220 * x289
    x359 = x4 * (x349 - x354 * x7)
    x360 = x29 * x358
    x361 = x144 * x163
    x362 = x361 * x72
    x363 = x226 * x23 * x6
    x364 = x289 * x363 + x362
    x365 = x4 * (x353 - x357 * x7)
    x366 = x242 * x289
    x367 = x239 * x289
    x368 = x4 * (x231 * x289 - x233 * x289)
    x369 = x246 * x289
    x370 = x4 * (x232 * x289 * x6 - x249 * x289)
    x371 = x255 * x289
    x372 = 3.0 * x201
    x373 = x371 + x372
    x374 = x256 * x289
    x375 = 3.0 * x198
    x376 = x374 + x375
    x377 = x376 * x7
    x378 = x259 * x289
    x379 = 3.0 * x205
    x380 = x378 + x379
    x381 = x4 * (x373 - x377)
    x382 = x17 * x225 * x65
    x383 = x265 * x289 + x382
    x384 = x144 * x340
    x385 = x266 * x289 + x384
    x386 = x385 * x7
    x387 = x112 * x162
    x388 = x268 * x289 + x387
    x389 = x4 * (x383 - x386)
    x390 = x242 + x278 * x289
    x391 = x239 + x273 * x289
    x392 = x391 * x7
    x393 = x246 + x276 * x289
    x394 = x4 * (x390 - x392)
    x395 = x4 * (x280 * x289 - x282 * x289)
    x396 = -x143 - A[2]
    x397 = x4 * (x396 * x40 - x396 * x59)
    x398 = 0.5 * x397
    x399 = x396 * x62 + x396 * x66
    x400 = x4 * (x396 * x47 - x396 * x69)
    x401 = 0.5 * x400
    x402 = x396 * x73
    x403 = x101 * x396
    x404 = x107 * x396
    x405 = x114 * x396
    x406 = x4 * (x105 * x396 - x115 * x396)
    x407 = 0.5 * x406
    x408 = x118 * x396
    x409 = x120 * x396 + x408
    x410 = x4 * (2.0 * x11 * x16 * x17 * x396 * x4 * x5 * x6 * x97 - x123 * x396)
    x411 = 0.5 * x410
    x412 = x154 * x396 + x48
    x413 = x144 * x303 * x396 + x302
    x414 = x29 * x413
    x415 = 2.0 * x414
    x416 = x147 * x396 + x36
    x417 = x144 * x396
    x418 = x308 + x309 * x417
    x419 = x29 * x418
    x420 = 2.0 * x419
    x421 = x160 * x396 + x57
    x422 = x3 * x421
    x423 = x23 * x361
    x424 = x314 + x396 * x423
    x425 = x29 * x424
    x426 = 2.0 * x425
    x427 = x416 * x7
    x428 = x4 * (x412 - x427)
    x429 = 0.5 * x428
    x430 = x175 * x396 + x73
    x431 = x29 * x430
    x432 = x3 * x424
    x433 = x431 + x432
    x434 = x4 * (x413 - x418 * x7)
    x435 = 0.5 * x434
    x436 = x201 * x396
    x437 = x198 * x396
    x438 = x4 * (x189 * x396 - x191 * x396)
    x439 = 0.5 * x438
    x440 = x205 * x396
    x441 = x4 * (x190 * x396 * x6 - x210 * x396)
    x442 = 0.5 * x441
    x443 = x132 + x348 * x396
    x444 = x29 * x443
    x445 = x308 * x97
    x446 = x352 * x396 + x445
    x447 = x127 + x128 * x417
    x448 = x29 * x447
    x449 = x314 * x97
    x450 = x315 * x417 + x449
    x451 = x118 + x220 * x396
    x452 = x4 * (x443 - x447 * x7)
    x453 = 0.5 * x452
    x454 = x29 * x451
    x455 = x113 * x72
    x456 = x363 * x396 + x455
    x457 = x4 * (x446 - x450 * x7)
    x458 = 0.5 * x457
    x459 = x162 * x31 + x231 * x396
    x460 = x29 * x459
    x461 = x156 + x243 * x396
    x462 = x162 * x17 + x232 * x396
    x463 = x29 * x462
    x464 = x235 * x396
    x465 = x149 + x464 * x6
    x466 = x167 * x65 + x464
    x467 = x4 * (x459 - x462 * x7)
    x468 = 0.5 * x467
    x469 = x29 * x466
    x470 = x247 * x6
    x471 = x164 + x396 * x470
    x472 = x3 * x471
    x473 = x465 * x7
    x474 = x4 * (x461 - x473)
    x475 = 0.5 * x474
    x476 = x3 * x469
    x477 = x4 * (x255 * x396 - x257 * x396)
    x478 = 0.5 * x477
    x479 = x201 + x265 * x396
    x480 = x198 + x266 * x396
    x481 = x480 * x7
    x482 = x205 + x268 * x396
    x483 = x4 * (x479 - x481)
    x484 = 0.5 * x483
    x485 = x278 * x396 + x382
    x486 = x384 + x464 * x97
    x487 = x486 * x7
    x488 = x276 * x396 + x387
    x489 = x4 * (x485 - x487)
    x490 = 0.5 * x489
    x491 = 3.0 * x242 + x280 * x396
    x492 = 3.0 * x239 + x281 * x396
    x493 = x492 * x7
    x494 = 3.0 * x246 + x283 * x396
    x495 = x137 * x494
    x496 = x4 * (x491 - x493)
    x497 = 0.5 * x496
    x498 = x289**2
    x499 = x498 * x55
    x500 = x499 + x61
    x501 = x26 * x498
    x502 = x501 + x70
    x503 = x29 * x502
    x504 = x40 * x498 - x7 * (x27 * x498 + x94) + x93
    x505 = x29 * (x309 * x498 + x85)
    x506 = x289 * x57
    x507 = x116 + x289 * x313 + x506
    x508 = x289 * x314
    x509 = x124 + x289 * x317 + x508
    x510 = x509 * x71
    x511 = x141 + x289 * x301 + x29 * x290 - x7 * (x142 + x289 * x307 + x289 * x36)
    x512 = x29 * (x136 + x289 * x321 + x299)
    x513 = x160 * x498 + x166
    x514 = x172 + x423 * x498
    x515 = x29 * x514
    x516 = x154 * x498 + x186 - x7 * (x147 * x498 + x187)
    x517 = x29 * (x175 * x498 + x180)
    x518 = x196 + x289 * x341 + 2.0 * x322
    x519 = x29 * x518
    x520 = x211 + x289 * x346 + x318
    x521 = x214 + x289 * x334 + x305 - x7 * (x215 + x289 * x339 + x311)
    x522 = x218 + x289 * x358 + x326
    x523 = x29 * x522
    x524 = x227 + x289 * x362 + x289 * x364
    x525 = x228 + x289 * x351 + x289 * x353 - x7 * (x229 + x289 * x356 + x289 * x357)
    x526 = x235 * x498
    x527 = x237 + x526
    x528 = x29 * x527
    x529 = x250 + x470 * x498
    x530 = x243 * x498 + x253 - x7 * (x254 + x526 * x6)
    x531 = x261 + x289 * x380 + 3.0 * x343
    x532 = x263 + x289 * x373 + 3.0 * x332 - x7 * (x264 + x289 * x376 + 3.0 * x336)
    x533 = x269 + x289 * x388 + 2.0 * x360
    x534 = x271 + x289 * x383 + 2.0 * x350 - x7 * (x272 + x289 * x385 + 2.0 * x355)
    x535 = x275 + x289 * x393 + x369
    x536 = x277 + x289 * x390 + x366 - x7 * (x279 + x289 * x391 + x367)
    x537 = x283 * x498 + x285
    x538 = x280 * x498 + x287 - x7 * (x281 * x498 + x288)
    x539 = x4 * (x289 * x396 * x40 - x293 * x396)
    x540 = x396 * x57
    x541 = x312 * x396 + x540
    x542 = x314 * x396
    x543 = x316 * x396 + x542
    x544 = x543 * x71
    x545 = x396 * x48
    x546 = x36 * x396
    x547 = x4 * (x300 * x396 + x545 - x7 * (x306 * x396 + x546))
    x548 = x29 * (x320 * x396 + x402)
    x549 = x4 * (x289 * x412 - x289 * x427)
    x550 = x289 * x431
    x551 = x337 * x396 + x340 * x396
    x552 = x29 * x551
    x553 = x345 * x396 + x405
    x554 = x4 * (x333 * x396 + x404 - x7 * (x338 * x396 + x403))
    x555 = x289 * x451 + x431
    x556 = x29 * x555
    x557 = x289 * x456 + x425
    x558 = x4 * (x289 * x446 + x414 - x7 * (x289 * x450 + x419))
    x559 = x289 * x469
    x560 = x4 * (x289 * x461 - x289 * x473)
    x561 = x378 * x396 + x379 * x396
    x562 = x4 * (x371 * x396 + x372 * x396 - x7 * (x374 * x396 + x375 * x396))
    x563 = 2.0 * x454
    x564 = x289 * x482 + x563
    x565 = 2.0 * x444
    x566 = 2.0 * x448
    x567 = x4 * (x289 * x479 + x565 - x7 * (x289 * x480 + x566))
    x568 = x289 * x488 + x469
    x569 = x4 * (x289 * x485 + x460 - x7 * (x289 * x486 + x463))
    x570 = x4 * (x289 * x491 - x289 * x493)
    x571 = x396**2
    x572 = x55 * x571 + x61
    x573 = x3 * x572
    x574 = x26 * x571 + x70
    x575 = x29 * x574
    x576 = 3.0 * x575
    x577 = x40 * x571 - x7 * (x27 * x571 + x94) + x93
    x578 = x577 * x60
    x579 = x29 * (x309 * x571 + x85)
    x580 = x110 * x571 + x116
    x581 = x124 + x315 * x571
    x582 = x29 * x581
    x583 = 2.0 * x582
    x584 = x105 * x571 + x141 - x7 * (x142 + x571 * x99)
    x585 = x584 * x60
    x586 = x29 * (x128 * x571 + x136)
    x587 = x166 + x396 * x421 + x540
    x588 = x3 * x587
    x589 = x172 + x396 * x424 + x542
    x590 = x29 * x589
    x591 = 2.0 * x590
    x592 = x186 + x396 * x412 + x545 - x7 * (x187 + x396 * x416 + x546)
    x593 = x592 * x60
    x594 = x29 * (x180 + x396 * x430 + x402)
    x595 = x194 * x571
    x596 = x196 + x595
    x597 = x29 * x596
    x598 = x211 + x344 * x571
    x599 = x202 * x571 + x214 - x7 * (x215 + x595 * x6)
    x600 = x599 * x60
    x601 = x218 + x396 * x451 + x408
    x602 = x29 * x601
    x603 = x227 + x396 * x455 + x396 * x456
    x604 = x228 + x396 * x445 + x396 * x446 - x7 * (x229 + x396 * x449 + x396 * x450)
    x605 = x60 * x604
    x606 = x237 + x396 * x466 + 2.0 * x431
    x607 = x29 * x606
    x608 = x250 + x396 * x471 + x426
    x609 = x3 * x608
    x610 = x253 + x396 * x461 + x415 - x7 * (x254 + x396 * x465 + x420)
    x611 = x60 * x610
    x612 = x259 * x571 + x261
    x613 = x255 * x571 + x263 - x7 * (x256 * x571 + x264)
    x614 = x60 * x613
    x615 = x269 + x396 * x482 + x440
    x616 = x271 + x396 * x479 + x436 - x7 * (x272 + x396 * x480 + x437)
    x617 = x60 * x616
    x618 = x275 + x396 * x488 + x563
    x619 = x277 + x396 * x485 + x565 - x7 * (x279 + x396 * x486 + x566)
    x620 = x60 * x619
    x621 = x285 + x396 * x494 + 3.0 * x469
    x622 = x287 + x396 * x491 + 3.0 * x460 - x7 * (x288 + x396 * x492 + 3.0 * x463)
    x623 = x60 * x622
    x624 = x289 * x500 + x294
    x625 = x29 * (x289 * x502 + x298)
    x626 = x289 * x507 + x319 + x503
    x627 = x71 * (x289 * x509 + x324 + x505)
    x628 = x289 * x513 + x325
    x629 = x29 * (x289 * x514 + x328)
    x630 = x29 * (x289 * x518 + x342 + 2.0 * x512)
    x631 = x289 * x520 + x347 + x510
    x632 = x29 * (x289 * x522 + x359 + x517)
    x633 = x289 * x524 + x365 + x515
    x634 = x29 * (x289 * x527 + x368)
    x635 = x289 * x529 + x370
    x636 = x289 * x531 + x381 + 3.0 * x519
    x637 = x289 * x533 + x389 + 2.0 * x523
    x638 = x289 * x535 + x394 + x528
    x639 = x289 * x537 + x395
    x640 = x396 * x499 + x398
    x641 = x29 * (x396 * x501 + x401)
    x642 = x289 * x541 + x396 * x506 + x407
    x643 = x71 * (x289 * x543 + x396 * x508 + x411)
    x644 = x421 * x498 + x429
    x645 = x29 * (x424 * x498 + x435)
    x646 = x29 * (x289 * x551 + x439 + 2.0 * x548)
    x647 = x289 * x553 + x442 + x544
    x648 = x29 * (x289 * x555 + x453 + x550)
    x649 = x289 * x425 + x289 * x557 + x458
    x650 = x29 * (x466 * x498 + x468)
    x651 = x471 * x498 + x475
    x652 = x289 * x561 + x478 + 3.0 * x552
    x653 = x289 * x564 + x484 + 2.0 * x556
    x654 = x289 * x568 + x490 + x559
    x655 = x494 * x498 + x497
    x656 = x289 * x580 + x575
    x657 = x71 * (x289 * x581 + x579)
    x658 = x29 * (x289 * x596 + 2.0 * x586)
    x659 = x289 * x598 + x583
    x660 = x29 * (x289 * x601 + x594)
    x661 = x289 * x603 + x590
    x662 = x289 * x607
    x663 = x289 * x612 + 3.0 * x597
    x664 = 2.0 * x602
    x665 = x289 * x615 + x664
    x666 = x289 * x618 + x607
    x667 = x396 * x572 + x397
    x668 = x29 * (x396 * x574 + x400)
    x669 = x396 * x580 + x406
    x670 = x29 * (x396 * x581 + x410)
    x671 = 2.0 * x670
    x672 = x396 * x587 + x428 + x575
    x673 = x29 * (x396 * x589 + x434 + x579)
    x674 = 2.0 * x673
    x675 = x29 * (x396 * x596 + x438)
    x676 = x396 * x598 + x441
    x677 = x29 * (x396 * x601 + x452 + x586)
    x678 = x396 * x603 + x457 + x582
    x679 = x29 * (x396 * x606 + x467 + 2.0 * x594)
    x680 = x396 * x608 + x474 + x591
    x681 = x396 * x612 + x477
    x682 = x396 * x615 + x483 + x597
    x683 = x396 * x618 + x489 + x664
    x684 = x396 * x621 + x496 + 3.0 * x607
    x685 = 2.0 * x677

    # 150 item(s)
    return numpy.array(
        [
            x3
            * (
                x3 * (x3 * (x56 + x58) + x61 + x67 * x68)
                + x4 * (-x38 * x7 + x50)
                + x68 * x77
            )
            + x68 * (x3 * x77 + x4 * (-x7 * x80 + x82) + x71 * (x3 * x76 + x85 + x86))
            + x95 * (x3 * x50 + x68 * x82 - x7 * (x3 * x38 + x68 * x80 + x94) + x93),
            x3
            * (
                x126 * x71
                + x3 * (x116 + x121 * x71 + x3 * (x111 + x114))
                + x4 * (-x102 * x7 + x108)
            )
            + x71 * (x126 * x3 + x29 * (x128 * x137 + x136) + x4 * (-x130 * x7 + x134))
            + x95
            * (x108 * x3 + x134 * x71 + x141 - x7 * (x102 * x3 + x130 * x71 + x142)),
            x3
            * (
                x173 * x71
                + x3 * (x166 + x170 * x71 + x3 * (x161 + x164))
                + x4 * (-x150 * x7 + x157)
            )
            + x71 * (x173 * x3 + x29 * (x137 * x175 + x180) + x4 * (-x176 * x7 + x179))
            + x95
            * (x157 * x3 + x179 * x71 + x186 - x7 * (x150 * x3 + x176 * x71 + x187)),
            x29 * (x197 * x3 + x4 * (x189 * x3 - x191 * x3))
            + x3
            * (
                x197 * x29
                + x3 * (x211 + x212 + x3 * (x205 + x208))
                + x4 * (-x200 * x7 + x204)
            )
            + x95
            * (x189 * x29 * x3 + x204 * x3 + x214 - x7 * (x198 * x3 + x200 * x3 + x215)),
            x29
            * (
                x221 * x3
                + x4 * (2.0 * x11 * x144 * x16 * x17 * x3 * x4 * x5 * x97 - x217 * x3)
            )
            + x3
            * (
                x221 * x29
                + x3 * (x224 * x3 + x227 + x3 * (x119 * x226 + x224))
                + x4 * (-x222 * x7 + x223)
            )
            + x95
            * (x223 * x3 + x225 * x86 + x228 - x7 * (x125 * x144 + x222 * x3 + x229)),
            x29 * (x238 * x3 + x4 * (x231 * x3 - x233 * x3))
            + x3
            * (
                x238 * x29
                + x3 * (x250 + x251 + x3 * (x246 + x248))
                + x4 * (-x241 * x7 + x245)
            )
            + x95
            * (x231 * x29 * x3 + x245 * x3 + x253 - x7 * (x239 * x3 + x241 * x3 + x254)),
            x3 * (x3 * (x260 + x261) + x4 * (x255 * x3 - x258))
            + x95 * (x137 * x255 + x263 - x7 * (x137 * x256 + x264)),
            x3 * (x3 * (x137 * x268 + x269) + x4 * (x265 * x3 - x267 * x3))
            + x95 * (x137 * x265 + x271 - x7 * (x137 * x266 + x272)),
            x3 * (x3 * (x137 * x276 + x275) + x4 * (x232 * x3 * x97 - x274 * x3))
            + x95 * (x137 * x278 + x277 - x7 * (x236 * x97 + x279)),
            x3 * (x3 * (x284 + x285) + x4 * (x280 * x3 - x282 * x3))
            + x95 * (x137 * x280 + x287 - x7 * (x137 * x281 + x288)),
            x3 * (0.5 * x294 + x297 * x68 + x3 * (x291 + x292))
            + x4 * (x289 * x41 + x290 * x68 - x7 * (x28 * x289 + x289 * x37))
            + x68 * (x297 * x3 + 0.5 * x298 + x71 * (x289 * x75 + x299)),
            x3 * (x3 * (x3 * x313 + x318) + 0.5 * x319 + x323 * x71)
            + x4 * (x3 * x301 + x305 - x7 * (x3 * x307 + x311))
            + x71 * (x3 * x322 + x3 * x323 + 0.5 * x324),
            x3 * (x3 * (x161 * x289 + x164 * x289) + 0.5 * x325 + x327 * x71)
            + x4 * (x155 * x289 + x156 * x289 - x7 * (x148 * x289 + x149 * x289))
            + x71 * (x168 * x329 + x3 * x327 + 0.5 * x328),
            x29 * (x137 * x341 + 0.5 * x342)
            + x3 * (x3 * x343 + x3 * (x3 * x346 + x343) + 0.5 * x347)
            + x4 * (x3 * x334 + x332 - x7 * (x3 * x339 + x336)),
            x29 * (x137 * x358 + 0.5 * x359)
            + x3 * (x3 * x360 + x3 * (x3 * x364 + x360) + 0.5 * x365)
            + x4 * (x3 * x353 + x350 - x7 * (x3 * x357 + x355)),
            x29 * (x236 * x289 + 0.5 * x368)
            + x3 * (x251 * x289 + x3 * (x248 * x289 + x369) + 0.5 * x370)
            + x4 * (x244 * x289 + x366 - x7 * (x240 * x289 + x367)),
            x3 * (x137 * x380 + 0.5 * x381) + x4 * (x3 * x373 - x3 * x377),
            x3 * (x137 * x388 + 0.5 * x389) + x4 * (x3 * x383 - x3 * x386),
            x3 * (x137 * x393 + 0.5 * x394) + x4 * (x3 * x390 - x3 * x392),
            x3 * (x284 * x289 + 0.5 * x395) + x4 * (x280 * x289 * x3 - x282 * x329),
            x3 * (x3 * (x396 * x56 + x396 * x58) + x398 + x399 * x68)
            + x4 * (x396 * x41 + x396 * x49 - x7 * (x28 * x396 + x37 * x396))
            + x68 * (x3 * x399 + x401 + x71 * (x396 * x75 + x402)),
            x3 * (x3 * (x111 * x396 + x405) + x407 + x409 * x71)
            + x4 * (x106 * x396 + x404 - x7 * (x100 * x396 + x403))
            + x71 * (x125 * x396 + x3 * x409 + x411),
            x3 * (x3 * (x422 + x426) + x429 + x433 * x71)
            + x4 * (x3 * x412 + x415 - x7 * (x3 * x416 + x420))
            + x71 * (x3 * x431 + x3 * x433 + x435),
            x29 * (x195 * x396 + x439)
            + x3 * (x212 * x396 + x3 * (x208 * x396 + x440) + x442)
            + x4 * (x203 * x396 + x436 - x7 * (x199 * x396 + x437)),
            x29 * (x137 * x451 + x453)
            + x3 * (x3 * x454 + x3 * (x3 * x456 + x454) + x458)
            + x4 * (x3 * x446 + x444 - x7 * (x3 * x450 + x448)),
            x29 * (x137 * x466 + x468)
            + x3 * (x3 * (x469 + x472) + x475 + x476)
            + x4 * (x3 * x461 + x460 - x7 * (x3 * x465 + x463)),
            x3 * (x260 * x396 + x478) + x4 * (x255 * x3 * x396 - x258 * x396),
            x3 * (x137 * x482 + x484) + x4 * (x3 * x479 - x3 * x481),
            x3 * (x137 * x488 + x490) + x4 * (x3 * x485 - x3 * x487),
            x3 * (x495 + x497) + x4 * (x3 * x491 - x3 * x493),
            x3 * (x3 * x500 + 3.0 * x503) + x504 * x60 + x68 * (x3 * x502 + 2.0 * x505),
            x3 * (x3 * x507 + x510) + x511 * x60 + x71 * (x3 * x509 + x512),
            x3 * (x3 * x513 + 2.0 * x515) + x516 * x60 + x71 * (x3 * x514 + x517),
            x3 * x519 + x3 * (x3 * x520 + x519) + x521 * x60,
            x3 * x523 + x3 * (x3 * x524 + x523) + x525 * x60,
            x3 * x528 + x3 * (x3 * x529 + x528) + x530 * x60,
            x137 * x531 + x532 * x60,
            x137 * x533 + x534 * x60,
            x137 * x535 + x536 * x60,
            x137 * x537 + x538 * x60,
            x3 * (x291 * x396 + x292 * x396)
            + 0.5 * x539
            + x68 * (x295 * x396 + x296 * x396),
            x3 * (x3 * x541 + x544) + 0.5 * x547 + x71 * (x3 * x543 + x548),
            x3 * (x289 * x422 + x289 * x426) + 0.5 * x549 + x71 * (x289 * x432 + x550),
            x3 * x552 + x3 * (x3 * x553 + x552) + 0.5 * x554,
            x3 * x556 + x3 * (x3 * x557 + x556) + 0.5 * x558,
            x289 * x476 + x3 * (x289 * x472 + x559) + 0.5 * x560,
            x137 * x561 + 0.5 * x562,
            x137 * x564 + 0.5 * x567,
            x137 * x568 + 0.5 * x569,
            x289 * x495 + 0.5 * x570,
            x3 * (x573 + x576) + x578 + x68 * (x3 * x574 + 2.0 * x579),
            x3 * (x3 * x580 + x583) + x585 + x71 * (x3 * x581 + x586),
            x3 * (x588 + x591) + x593 + x71 * (x3 * x589 + x594),
            x3 * x597 + x3 * (x3 * x598 + x597) + x600,
            x3 * x602 + x3 * (x3 * x603 + x602) + x605,
            x3 * x607 + x3 * (x607 + x609) + x611,
            x137 * x612 + x614,
            x137 * x615 + x617,
            x137 * x618 + x620,
            x137 * x621 + x623,
            x3 * x624 + 3.0 * x625,
            x3 * x626 + x627,
            x3 * x628 + 2.0 * x629,
            x3 * x631 + x630,
            x3 * x633 + x632,
            x3 * x635 + x634,
            x3 * x636,
            x3 * x637,
            x3 * x638,
            x3 * x639,
            x3 * x640 + 3.0 * x641,
            x3 * x642 + x643,
            x3 * x644 + 2.0 * x645,
            x3 * x647 + x646,
            x3 * x649 + x648,
            x3 * x651 + x650,
            x3 * x652,
            x3 * x653,
            x3 * x654,
            x3 * x655,
            x289 * x573 + x289 * x576,
            x3 * x656 + x657,
            x289 * x588 + x289 * x591,
            x3 * x659 + x658,
            x3 * x661 + x660,
            x289 * x609 + x662,
            x3 * x663,
            x3 * x665,
            x3 * x666,
            x329 * x621,
            x3 * x667 + 3.0 * x668,
            x3 * x669 + x671,
            x3 * x672 + x674,
            x3 * x676 + x675,
            x3 * x678 + x677,
            x3 * x680 + x679,
            x3 * x681,
            x3 * x682,
            x3 * x683,
            x3 * x684,
            x289 * x624 + x504 * x95,
            x289 * x626 + x511 * x95 + x625,
            x289 * x628 + x516 * x95,
            x289 * x631 + x521 * x95 + x627,
            x289 * x633 + x525 * x95 + x629,
            x289 * x635 + x530 * x95,
            x289 * x636 + x532 * x95 + 3.0 * x630,
            x289 * x637 + x534 * x95 + 2.0 * x632,
            x289 * x638 + x536 * x95 + x634,
            x289 * x639 + x538 * x95,
            x289 * x640 + x539,
            x289 * x642 + x547 + x641,
            x289 * x644 + x549,
            x289 * x647 + x554 + x643,
            x289 * x649 + x558 + x645,
            x289 * x651 + x560,
            x289 * x652 + x562 + 3.0 * x646,
            x289 * x653 + x567 + 2.0 * x648,
            x289 * x654 + x569 + x650,
            x289 * x655 + x570,
            x498 * x572 + x578,
            x289 * x575 + x289 * x656 + x585,
            x498 * x587 + x593,
            x289 * x659 + x600 + x657,
            x289 * x590 + x289 * x661 + x605,
            x498 * x608 + x611,
            x289 * x663 + x614 + 3.0 * x658,
            x289 * x665 + x617 + 2.0 * x660,
            x289 * x666 + x620 + x662,
            x498 * x621 + x623,
            x289 * x667,
            x289 * x669 + x668,
            x289 * x672,
            x289 * x676 + x671,
            x289 * x678 + x673,
            x289 * x680,
            x289 * x681 + 3.0 * x675,
            x289 * x682 + x685,
            x289 * x683 + x679,
            x289 * x684,
            x396 * x667 + x577 * x95,
            x396 * x669 + x584 * x95,
            x396 * x672 + x592 * x95 + x668,
            x396 * x676 + x599 * x95,
            x396 * x678 + x604 * x95 + x670,
            x396 * x680 + x610 * x95 + x674,
            x396 * x681 + x613 * x95,
            x396 * x682 + x616 * x95 + x675,
            x396 * x683 + x619 * x95 + x685,
            x396 * x684 + x622 * x95 + 3.0 * x679,
        ]
    )


def _2center2el3d_44(a, A, b, B):
    """Cartesian (g|g) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a ** (-1.0)
    x5 = -x2 - B[0]
    x6 = b ** (-1.0)
    x7 = a * x1
    x8 = b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(6, x8)
    x10 = x0 ** (-1.5)
    x11 = 17.4934183276249
    x12 = x11 * x6
    x13 = 2.0 * x12
    x14 = x10 * x13
    x15 = x14 * x9
    x16 = x15 * x5
    x17 = x0 ** (-0.5)
    x18 = boys(5, x8)
    x19 = 0.5 * x6
    x20 = x19 * (2.0 * x11 * x17 * x18 * x4 * x6 - x15)
    x21 = boys(7, x8)
    x22 = x5**2
    x23 = x17 * x4
    x24 = x13 * x23
    x25 = x22 * x24
    x26 = x21 * x25
    x27 = x20 + x26
    x28 = x27 * x5 + x6 * (2.0 * x11 * x17 * x18 * x4 * x5 * x6 - x16)
    x29 = x14 * x18
    x30 = boys(4, x8)
    x31 = x19 * (2.0 * x11 * x17 * x30 * x4 * x6 - x29)
    x32 = x24 * x9
    x33 = x22 * x32
    x34 = x31 + x33
    x35 = x14 * x30
    x36 = boys(3, x8)
    x37 = x19 * (2.0 * x11 * x17 * x36 * x4 * x6 - x35)
    x38 = x18 * x24
    x39 = x22 * x38
    x40 = x37 + x39
    x41 = 1.5 * x6
    x42 = x28 * x5 + x41 * (-x34 * x7 + x40)
    x43 = x3 * x42
    x44 = (2.0 * a + 2.0 * b) ** (-1.0)
    x45 = x29 * x5
    x46 = x34 * x5 + x6 * (2.0 * x11 * x17 * x30 * x4 * x5 * x6 - x45)
    x47 = x44 * x46
    x48 = 4.0 * x47
    x49 = x43 + x48
    x50 = b * x1
    x51 = x14 * x36
    x52 = boys(2, x8)
    x53 = x19 * (2.0 * x11 * x17 * x4 * x52 * x6 - x51)
    x54 = x24 * x30
    x55 = x22 * x54
    x56 = x53 + x55
    x57 = x41 * (-x40 * x7 + x56) + x46 * x5
    x58 = x3 * x57
    x59 = x35 * x5
    x60 = x40 * x5 + x6 * (2.0 * x11 * x17 * x36 * x4 * x5 * x6 - x59)
    x61 = x44 * x60
    x62 = 4.0 * x61
    x63 = x58 + x62
    x64 = x14 * x21
    x65 = x5 * x64
    x66 = x19 * (2.0 * x11 * x17 * x4 * x6 * x9 - x64)
    x67 = boys(8, x8)
    x68 = x25 * x67
    x69 = x41 * (-x27 * x7 + x34) + x5 * (
        x5 * (x66 + x68) + x6 * (2.0 * x11 * x17 * x4 * x5 * x6 * x9 - x65)
    )
    x70 = x3 * x69
    x71 = x28 * x44
    x72 = 4.0 * x71
    x73 = x42 * x50
    x74 = 0.5 * x4
    x75 = x74 * (x57 - x73)
    x76 = x28 * x3
    x77 = x34 * x44
    x78 = 3.0 * x77
    x79 = x76 + x78
    x80 = 4.0 * x44
    x81 = x46 * x50
    x82 = x74 * (x60 - x81)
    x83 = x3 * x34
    x84 = x18 * x5
    x85 = x12 * x23
    x86 = x80 * x85
    x87 = x84 * x86
    x88 = x83 + x87
    x89 = 3.0 * x44
    x90 = x3 * x79 + x82 + x88 * x89
    x91 = x40 * x44
    x92 = x3 * x46 + 3.0 * x91
    x93 = x44 * x56
    x94 = x3 * x60 + 3.0 * x93
    x95 = x74 * (-x40 * x50 + x56)
    x96 = 2.0 * x44
    x97 = x85 * x96
    x98 = x30 * x97
    x99 = x3 * x5
    x100 = x5 * x51
    x101 = boys(1, x8)
    x102 = x19 * (-x101 * x14 + 2.0 * x11 * x17 * x4 * x6 * boys(0, x8))
    x103 = x19 * (2.0 * x101 * x11 * x17 * x4 * x6 - x14 * x52)
    x104 = x24 * x36
    x105 = x103 + x104 * x22
    x106 = x24 * x52
    x107 = x41 * (x105 - x56 * x7) + x5 * x60
    x108 = x74 * (
        -x107 * x50
        + x41 * (x102 - x105 * x7 + x106 * x22)
        + x5 * (x5 * x56 + x6 * (-x100 + 2.0 * x11 * x17 * x4 * x5 * x52 * x6))
    )
    x109 = x74 * (x107 - x50 * x57)
    x110 = 1.5 * x4
    x111 = -x1 * (a * A[1] + b * B[1])
    x112 = -x111 - B[1]
    x113 = x112 * x5
    x114 = x112 * x15
    x115 = x6 * (2.0 * x11 * x112 * x17 * x18 * x4 * x6 - x114)
    x116 = x112 * x26
    x117 = 0.5 * x115 + x116
    x118 = x117 * x5 + x6 * (2.0 * x11 * x112 * x17 * x18 * x4 * x5 * x6 - x113 * x15)
    x119 = x118 * x3
    x120 = x112 * x29
    x121 = x6 * (2.0 * x11 * x112 * x17 * x30 * x4 * x6 - x120)
    x122 = x112 * x33
    x123 = 0.5 * x121 + x122
    x124 = x123 * x44
    x125 = 3.0 * x124
    x126 = x119 + x125
    x127 = -2.0 * x11 * x112 * x17 * x30 * x4 * x5 * x6
    x128 = x123 * x5 + x6 * (-x113 * x29 - x127)
    x129 = x128 * x3
    x130 = x112 * x35
    x131 = x6 * (2.0 * x11 * x112 * x17 * x36 * x4 * x6 - x130)
    x132 = x112 * x39
    x133 = 0.5 * x131 + x132
    x134 = x133 * x44
    x135 = x129 + 3.0 * x134
    x136 = x112 * x64
    x137 = x6 * (2.0 * x11 * x112 * x17 * x4 * x6 * x9 - x136)
    x138 = x112 * x68
    x139 = x5 * (0.5 * x137 + x138) + x6 * (
        2.0 * x11 * x112 * x17 * x4 * x5 * x6 * x9 - x113 * x64
    )
    x140 = x139 * x3
    x141 = x117 * x44
    x142 = 3.0 * x141
    x143 = x118 * x50
    x144 = x74 * (x128 - x143)
    x145 = x117 * x3
    x146 = x113 * x9
    x147 = x146 * x86
    x148 = x145 + x147
    x149 = x123 * x50
    x150 = x74 * (x133 - x149)
    x151 = x112 * x18
    x152 = x151 * x97
    x153 = x112 * x99
    x154 = x153 * x32
    x155 = x152 + x154
    x156 = x148 * x3 + x150 + x155 * x96
    x157 = x113 * x18
    x158 = x157 * x86
    x159 = x123 * x3 + x158
    x160 = x30 * x86
    x161 = x113 * x160
    x162 = x133 * x3 + x161
    x163 = 2.0 * x10 * x11 * x4
    x164 = x74 * (-x127 - x157 * x163)
    x165 = x112 * x51
    x166 = x6 * (2.0 * x11 * x112 * x17 * x4 * x52 * x6 - x165)
    x167 = x112 * x55
    x168 = x133 * x5 + x6 * (2.0 * x11 * x112 * x17 * x36 * x4 * x5 * x6 - x113 * x35)
    x169 = x74 * (
        -x168 * x50
        + x5 * (0.5 * x166 + x167)
        + x6 * (2.0 * x11 * x112 * x17 * x4 * x5 * x52 * x6 - x113 * x51)
    )
    x170 = x74 * (-x128 * x50 + x168)
    x171 = -x1 * (a * A[2] + b * B[2])
    x172 = -x171 - B[2]
    x173 = x6 * (2.0 * x11 * x17 * x172 * x18 * x4 * x6 - x15 * x172)
    x174 = 0.5 * x173
    x175 = x172 * x26 + x174
    x176 = x175 * x5 + x6 * (2.0 * x11 * x17 * x172 * x18 * x4 * x5 * x6 - x16 * x172)
    x177 = x176 * x3
    x178 = x6 * (2.0 * x11 * x17 * x172 * x30 * x4 * x6 - x172 * x29)
    x179 = 0.5 * x178
    x180 = x172 * x33 + x179
    x181 = x180 * x44
    x182 = 3.0 * x181
    x183 = x177 + x182
    x184 = -2.0 * x11 * x17 * x172 * x30 * x4 * x5 * x6
    x185 = x180 * x5 + x6 * (-x172 * x45 - x184)
    x186 = x185 * x3
    x187 = x6 * (2.0 * x11 * x17 * x172 * x36 * x4 * x6 - x172 * x35)
    x188 = 0.5 * x187
    x189 = x172 * x39 + x188
    x190 = x189 * x44
    x191 = x186 + 3.0 * x190
    x192 = x6 * (2.0 * x11 * x17 * x172 * x4 * x6 * x9 - x172 * x64)
    x193 = 0.5 * x192
    x194 = x5 * (x172 * x68 + x193) + x6 * (
        2.0 * x11 * x17 * x172 * x4 * x5 * x6 * x9 - x172 * x65
    )
    x195 = x194 * x3
    x196 = x175 * x44
    x197 = 3.0 * x196
    x198 = x176 * x50
    x199 = x74 * (x185 - x198)
    x200 = x175 * x3
    x201 = x172 * x5
    x202 = x201 * x9
    x203 = x202 * x86
    x204 = x200 + x203
    x205 = x180 * x50
    x206 = x74 * (x189 - x205)
    x207 = x172 * x18
    x208 = x207 * x97
    x209 = x172 * x32
    x210 = x209 * x99
    x211 = x208 + x210
    x212 = x204 * x3 + x206 + x211 * x96
    x213 = x172 * x87
    x214 = x180 * x3 + x213
    x215 = x160 * x201
    x216 = x189 * x3 + x215
    x217 = x163 * x172
    x218 = x74 * (-x184 - x217 * x84)
    x219 = x6 * (2.0 * x11 * x17 * x172 * x4 * x52 * x6 - x172 * x51)
    x220 = 0.5 * x219
    x221 = x189 * x5 + x6 * (2.0 * x11 * x17 * x172 * x36 * x4 * x5 * x6 - x172 * x59)
    x222 = x74 * (
        -x221 * x50
        + x5 * (x172 * x55 + x220)
        + x6 * (-x100 * x172 + 2.0 * x11 * x17 * x172 * x4 * x5 * x52 * x6)
    )
    x223 = x74 * (-x185 * x50 + x221)
    x224 = x112**2
    x225 = x224 * x24
    x226 = x21 * x225
    x227 = x20 + x226
    x228 = x224 * x32 + x31
    x229 = x224 * x38 + x37
    x230 = -x228 * x7 + x229
    x231 = x19 * x230 + x22 * x227
    x232 = x231 * x3
    x233 = x228 * x44
    x234 = x233 * x5
    x235 = x232 + 2.0 * x234
    x236 = x224 * x54 + x53
    x237 = -x229 * x7 + x236
    x238 = x19 * x237 + x22 * x228
    x239 = x238 * x3
    x240 = x229 * x5
    x241 = x239 + x240 * x96
    x242 = x225 * x67
    x243 = x242 + x66
    x244 = -x227 * x7 + x228
    x245 = x19 * x244 + x22 * x243
    x246 = x245 * x3
    x247 = x227 * x5
    x248 = x247 * x96
    x249 = x231 * x50
    x250 = x74 * (x238 - x249)
    x251 = x227 * x99
    x252 = x233 + x251
    x253 = x5 * x50
    x254 = x74 * (-x228 * x253 + x229 * x5)
    x255 = x233 * x3
    x256 = x252 * x3 + x254 + x255
    x257 = x229 * x44
    x258 = x228 * x99 + x257
    x259 = x236 * x44
    x260 = x240 * x3 + x259
    x261 = x3**2
    x262 = x74 * (-x229 * x50 + x236)
    x263 = x103 + x104 * x224
    x264 = x102 + x106 * x224 - x263 * x7
    x265 = -x236 * x7 + x263
    x266 = x19 * x265 + x22 * x229
    x267 = x74 * (x19 * x264 + x22 * x236 - x266 * x50)
    x268 = x74 * (-x238 * x50 + x266)
    x269 = x6 * (2.0 * x11 * x112 * x17 * x172 * x18 * x4 * x6 - x114 * x172)
    x270 = x116 * x172 + 0.5 * x269
    x271 = x147 * x172
    x272 = x270 * x3 + x271
    x273 = -2.0 * x11 * x112 * x17 * x172 * x30 * x4 * x6
    x274 = x6 * (-x120 * x172 - x273)
    x275 = x122 * x172 + 0.5 * x274
    x276 = x158 * x172
    x277 = x275 * x3 + x276
    x278 = x6 * (2.0 * x11 * x112 * x17 * x172 * x4 * x6 * x9 - x136 * x172)
    x279 = x138 * x172 + 0.5 * x278
    x280 = x172 * x21
    x281 = x113 * x280
    x282 = x281 * x86
    x283 = x74 * (-x270 * x50 + x275)
    x284 = x112 * x172
    x285 = x284 * x9
    x286 = x285 * x97
    x287 = x153 * x24 * x280 + x286
    x288 = x74 * (2.0 * x11 * x112 * x17 * x172 * x18 * x4 * x5 * x6 - x146 * x217)
    x289 = x286 * x3 + x287 * x3 + x288
    x290 = x152 * x172 + x153 * x209
    x291 = x172 * x38
    x292 = x153 * x291 + x284 * x98
    x293 = x74 * (-x151 * x217 - x273)
    x294 = x112 * x172 * x32
    x295 = x6 * (2.0 * x11 * x112 * x17 * x172 * x4 * x52 * x6 - x165 * x172)
    x296 = x6 * (2.0 * x11 * x112 * x17 * x172 * x36 * x4 * x6 - x130 * x172)
    x297 = x132 * x172 + 0.5 * x296
    x298 = x74 * (x167 * x172 + 0.5 * x295 - x297 * x50)
    x299 = x74 * (-x275 * x50 + x297)
    x300 = x172**2
    x301 = x24 * x300
    x302 = x20 + x21 * x301
    x303 = x300 * x32 + x31
    x304 = x300 * x38 + x37
    x305 = -x303 * x7 + x304
    x306 = x19 * x305
    x307 = x22 * x302 + x306
    x308 = x3 * x307
    x309 = x303 * x44
    x310 = x309 * x5
    x311 = x308 + 2.0 * x310
    x312 = x300 * x54 + x53
    x313 = -x304 * x7 + x312
    x314 = x19 * x313
    x315 = x22 * x303 + x314
    x316 = x3 * x315
    x317 = x304 * x5
    x318 = x316 + x317 * x96
    x319 = x301 * x67 + x66
    x320 = -x302 * x7 + x303
    x321 = x19 * x320
    x322 = x22 * x319 + x321
    x323 = x3 * x322
    x324 = x302 * x5
    x325 = x307 * x50
    x326 = x74 * (x315 - x325)
    x327 = x302 * x99
    x328 = x309 + x327
    x329 = x74 * (-x253 * x303 + x304 * x5)
    x330 = x3 * x309
    x331 = x3 * x328 + x329 + x330
    x332 = x304 * x44
    x333 = x303 * x99
    x334 = x332 + x333
    x335 = x312 * x44
    x336 = x3 * x317 + x335
    x337 = x74 * (-x304 * x50 + x312)
    x338 = x103 + x104 * x300
    x339 = x102 + x106 * x300 - x338 * x7
    x340 = x19 * x339
    x341 = -x312 * x7 + x338
    x342 = x19 * x341
    x343 = x22 * x304 + x342
    x344 = x74 * (x22 * x312 + x340 - x343 * x50)
    x345 = x74 * (-x315 * x50 + x343)
    x346 = x112 * x229 + x131
    x347 = x112 * x228 + x121
    x348 = x347 * x50
    x349 = x112 * x227 + x115
    x350 = x261 * x349
    x351 = x74 * (x346 - x348)
    x352 = x350 + x351
    x353 = x347 * x44
    x354 = x349 * x99
    x355 = x353 + x354
    x356 = x346 * x44
    x357 = x347 * x5
    x358 = x3 * x357
    x359 = x356 + x358
    x360 = x349 * x44
    x361 = x112 * x243 + x137
    x362 = x361 * x99
    x363 = x74 * (-x253 * x349 + x347 * x5)
    x364 = x3 * x360
    x365 = x112 * x236 + x166
    x366 = x74 * (-x346 * x5 * x50 + x365 * x5)
    x367 = x74 * (x346 * x5 - x357 * x50)
    x368 = x188 + x224 * x291
    x369 = x179 + x209 * x224
    x370 = x369 * x50
    x371 = x172 * x226 + x174
    x372 = x74 * (x368 - x370)
    x373 = x261 * x371 + x372
    x374 = x369 * x44
    x375 = x371 * x99 + x374
    x376 = x368 * x44
    x377 = x369 * x5
    x378 = x3 * x377 + x376
    x379 = x371 * x44
    x380 = x172 * x242 + x193
    x381 = x74 * (-x253 * x371 + x369 * x5)
    x382 = x172 * x224 * x54 + x220
    x383 = x74 * (-x368 * x5 * x50 + x382 * x5)
    x384 = x74 * (x368 * x5 - x377 * x50)
    x385 = x112 * x50
    x386 = x303 * x385
    x387 = x74 * (x112 * x304 - x386)
    x388 = x112 * x302
    x389 = x261 * x388 + x387
    x390 = x112 * x309
    x391 = x112 * x327 + x390
    x392 = x112 * x332
    x393 = x112 * x333 + x392
    x394 = x388 * x44
    x395 = x74 * (x112 * x303 * x5 - x253 * x388)
    x396 = x74 * (x112 * x312 * x5 - x112 * x317 * x50)
    x397 = x113 * x303
    x398 = x74 * (x112 * x304 * x5 - x397 * x50)
    x399 = x172 * x304 + x187
    x400 = x172 * x303 + x178
    x401 = x400 * x50
    x402 = x172 * x302 + x173
    x403 = x261 * x402
    x404 = x74 * (x399 - x401)
    x405 = x403 + x404
    x406 = x400 * x44
    x407 = x402 * x99
    x408 = x406 + x407
    x409 = x399 * x44
    x410 = x400 * x5
    x411 = x3 * x410
    x412 = x409 + x411
    x413 = x402 * x44
    x414 = x172 * x319 + x192
    x415 = x414 * x99
    x416 = x74 * (-x253 * x402 + x400 * x5)
    x417 = x3 * x413
    x418 = x172 * x312 + x219
    x419 = x74 * (-x399 * x5 * x50 + x418 * x5)
    x420 = x74 * (x399 * x5 - x410 * x50)
    x421 = x112 * x347 + x237 * x41
    x422 = x112 * x349 + x230 * x41
    x423 = x422 * x50
    x424 = x3 * x423
    x425 = x112 * x361 + x244 * x41
    x426 = x261 * x425
    x427 = x74 * (x421 - x423)
    x428 = x112 * x346 + x265 * x41
    x429 = x74 * (x112 * x365 + x264 * x41 - x428 * x50)
    x430 = x74 * (-x421 * x50 + x428)
    x431 = x112 * x369 + x274
    x432 = x112 * x371 + x269
    x433 = x432 * x50
    x434 = x112 * x380 + x278
    x435 = x74 * (x431 - x433)
    x436 = x112 * x368 + x296
    x437 = x74 * (x112 * x382 + x295 - x436 * x50)
    x438 = x74 * (-x431 * x50 + x436)
    x439 = x224 * x303 + x314
    x440 = x224 * x302 + x306
    x441 = x440 * x50
    x442 = x224 * x319 + x321
    x443 = x74 * (x439 - x441)
    x444 = x224 * x304 + x342
    x445 = x74 * (x224 * x312 + x340 - x444 * x50)
    x446 = x74 * (-x439 * x50 + x444)
    x447 = x385 * x402
    x448 = x74 * (x112 * x400 - x447)
    x449 = x112 * x414
    x450 = x74 * (-x112 * x399 * x50 + x112 * x418)
    x451 = x112 * x400
    x452 = x74 * (x112 * x399 - x451 * x50)
    x453 = x172 * x400 + x313 * x41
    x454 = x172 * x402 + x305 * x41
    x455 = x454 * x50
    x456 = x172 * x414 + x320 * x41
    x457 = x261 * x456
    x458 = x74 * (x453 - x455)
    x459 = x172 * x399 + x341 * x41
    x460 = x74 * (x172 * x418 + x339 * x41 - x459 * x50)
    x461 = x74 * (-x453 * x50 + x459)
    x462 = -x111 - A[1]
    x463 = x462 * x60
    x464 = x462 * x70
    x465 = x462 * x72
    x466 = x462 * x73
    x467 = x4 * (x462 * x57 - x466)
    x468 = x462 * x76
    x469 = x462 * x78
    x470 = x468 + x469
    x471 = x4 * (x462 * x60 - x462 * x81)
    x472 = x462 * x5
    x473 = x18 * x86
    x474 = x128 * x462
    x475 = x474 + x61
    x476 = x133 * x462 + x93
    x477 = x118 * x462
    x478 = x47 + x477
    x479 = x123 * x462 + x91
    x480 = x139 * x462
    x481 = x480 + x71
    x482 = x117 * x462
    x483 = x482 + x77
    x484 = x4 * (x475 - x478 * x50)
    x485 = x84 * x97
    x486 = x113 * x32
    x487 = x462 * x486
    x488 = x485 + x487
    x489 = x488 * x96
    x490 = x3 * x483 + x489
    x491 = x4 * (x476 - x479 * x50)
    x492 = x112 * x462
    x493 = x44 * (x38 * x492 + x98)
    x494 = x189 * x462
    x495 = x4 * (x185 * x462 - x198 * x462)
    x496 = x172 * x472 * x9
    x497 = x200 * x462 + x496 * x86
    x498 = x4 * (x189 * x462 - x205 * x462)
    x499 = x208 * x462
    x500 = x238 * x462
    x501 = 2.0 * x134 + x500
    x502 = x161 + x240 * x462
    x503 = x231 * x462
    x504 = 2.0 * x124
    x505 = x503 + x504
    x506 = x228 * x462
    x507 = x158 + x5 * x506
    x508 = x245 * x462
    x509 = 2.0 * x141
    x510 = x508 + x509
    x511 = x227 * x472
    x512 = x147 + x511
    x513 = x4 * (-x50 * x505 + x501)
    x514 = x151 * x86
    x515 = x506 + x514
    x516 = x44 * x515
    x517 = x3 * x512 + x516
    x518 = x4 * (-x50 * x507 + x502)
    x519 = x190 + x275 * x462
    x520 = x113 * x291 * x462 + x201 * x98
    x521 = x520 * x96
    x522 = x181 + x270 * x462
    x523 = x113 * x209
    x524 = x172 * x485 + x462 * x523
    x525 = x524 * x96
    x526 = x196 + x279 * x462
    x527 = x24 * x281
    x528 = x202 * x97 + x462 * x527
    x529 = x528 * x96
    x530 = x4 * (-x50 * x522 + x519)
    x531 = x208 + x209 * x492
    x532 = x44 * x531
    x533 = x3 * x528 + x532
    x534 = x4 * (-x50 * x524 + x520)
    x535 = x309 * x472
    x536 = x317 * x462
    x537 = x302 * x472
    x538 = x4 * (x315 * x462 - x325 * x462)
    x539 = x309 * x462
    x540 = x327 * x462 + x539
    x541 = x472 * x50
    x542 = x4 * (-x303 * x541 + x304 * x462 * x5)
    x543 = 3.0 * x259 + x346 * x462
    x544 = x44 * x543
    x545 = x357 * x462
    x546 = x240 * x89 + x545
    x547 = 3.0 * x257 + x347 * x462
    x548 = x44 * x547
    x549 = x349 * x462
    x550 = x5 * x549
    x551 = 3.0 * x233
    x552 = x5 * x551 + x550
    x553 = x549 + x551
    x554 = x4 * (-x50 * x547 + x543)
    x555 = x44 * x553
    x556 = x361 * x472
    x557 = x247 * x89
    x558 = x556 + x557
    x559 = x4 * (-x50 * x552 + x546)
    x560 = x160 * x284
    x561 = x368 * x462 + x560
    x562 = x44 * x561
    x563 = x276 + x377 * x462
    x564 = x172 * x514
    x565 = x369 * x462 + x564
    x566 = x44 * x565
    x567 = x371 * x462
    x568 = x271 + x5 * x567
    x569 = x285 * x86
    x570 = x567 + x569
    x571 = x4 * (-x50 * x565 + x561)
    x572 = x44 * x570
    x573 = x282 + x380 * x472
    x574 = x4 * (-x50 * x568 + x563)
    x575 = x112 * x304
    x576 = x335 + x462 * x575
    x577 = x44 * x576
    x578 = x317 * x44 + x397 * x462
    x579 = x303 * x492 + x332
    x580 = x44 * x579
    x581 = x310 + x388 * x472
    x582 = x309 + x388 * x462
    x583 = x4 * (-x50 * x579 + x576)
    x584 = x44 * x582
    x585 = x113 * x319
    x586 = x324 * x44 + x462 * x585
    x587 = x4 * (-x50 * x581 + x578)
    x588 = x409 * x462
    x589 = x406 * x462
    x590 = x4 * (x399 * x462 - x401 * x462)
    x591 = x413 * x462
    x592 = x4 * (x400 * x462 * x5 - x402 * x541)
    x593 = x421 * x462
    x594 = 4.0 * x356
    x595 = x593 + x594
    x596 = x422 * x462
    x597 = 4.0 * x353
    x598 = x596 + x597
    x599 = x50 * x598
    x600 = x425 * x462
    x601 = 4.0 * x360
    x602 = x600 + x601
    x603 = x4 * (x595 - x599)
    x604 = 3.0 * x376 + x431 * x462
    x605 = 3.0 * x374 + x432 * x462
    x606 = x50 * x605
    x607 = 3.0 * x379 + x434 * x462
    x608 = x4 * (x604 - x606)
    x609 = 2.0 * x392 + x439 * x462
    x610 = 2.0 * x390 + x440 * x462
    x611 = x50 * x610
    x612 = x388 * x96 + x442 * x462
    x613 = x4 * (x609 - x611)
    x614 = x409 + x451 * x462
    x615 = x402 * x492 + x406
    x616 = x50 * x615
    x617 = x413 + x449 * x462
    x618 = x4 * (x614 - x616)
    x619 = x3 * x462
    x620 = x4 * (x453 * x462 - x455 * x462)
    x621 = -x171 - A[2]
    x622 = x4 * (x57 * x621 - x621 * x73)
    x623 = 0.5 * x622
    x624 = x621 * x76 + x621 * x78
    x625 = x4 * (x60 * x621 - x621 * x81)
    x626 = 0.5 * x625
    x627 = x5 * x621
    x628 = x133 * x621
    x629 = x4 * (x128 * x621 - x143 * x621)
    x630 = 0.5 * x629
    x631 = x147 * x621
    x632 = x145 * x621 + x631
    x633 = x4 * (x133 * x621 - x149 * x621)
    x634 = 0.5 * x633
    x635 = x152 * x621
    x636 = x185 * x621 + x61
    x637 = x189 * x621 + x93
    x638 = x44 * x637
    x639 = x176 * x621 + x47
    x640 = x180 * x621 + x91
    x641 = x44 * x640
    x642 = x194 * x621 + x71
    x643 = x3 * x642
    x644 = x175 * x621 + x77
    x645 = x44 * x644
    x646 = 3.0 * x645
    x647 = x50 * x639
    x648 = x4 * (x636 - x647)
    x649 = 0.5 * x648
    x650 = x3 * x644
    x651 = x209 * x627 + x485
    x652 = x44 * x651
    x653 = 2.0 * x652
    x654 = x650 + x653
    x655 = x4 * (-x50 * x640 + x637)
    x656 = 0.5 * x655
    x657 = x291 * x621
    x658 = x44 * (x657 + x98)
    x659 = x233 * x621
    x660 = x5 * x659
    x661 = x240 * x621
    x662 = x4 * (x238 * x621 - x249 * x621)
    x663 = 0.5 * x662
    x664 = x251 * x621 + x659
    x665 = x50 * x627
    x666 = x4 * (-x228 * x665 + x229 * x5 * x621)
    x667 = 0.5 * x666
    x668 = x134 + x275 * x621
    x669 = x113 * x657 + x113 * x98
    x670 = x669 * x96
    x671 = x124 + x270 * x621
    x672 = x157 * x97 + x523 * x621
    x673 = x672 * x96
    x674 = x141 + x279 * x621
    x675 = x146 * x97
    x676 = x527 * x621 + x675
    x677 = x676 * x96
    x678 = x4 * (-x50 * x671 + x668)
    x679 = 0.5 * x678
    x680 = x152 + x294 * x621
    x681 = x44 * x680
    x682 = x3 * x676 + x681
    x683 = x4 * (-x50 * x672 + x669)
    x684 = 0.5 * x683
    x685 = 2.0 * x190 + x315 * x621
    x686 = x215 + x317 * x621
    x687 = x44 * x686
    x688 = 2.0 * x181 + x307 * x621
    x689 = x303 * x621
    x690 = x213 + x5 * x689
    x691 = x44 * x690
    x692 = 2.0 * x196 + x322 * x621
    x693 = x3 * x692
    x694 = x203 + x324 * x621
    x695 = x44 * x694
    x696 = 2.0 * x695
    x697 = x50 * x688
    x698 = x4 * (x685 - x697)
    x699 = 0.5 * x698
    x700 = x207 * x86 + x689
    x701 = x44 * x700
    x702 = x3 * x694
    x703 = x701 + x702
    x704 = x4 * (-x50 * x690 + x686)
    x705 = 0.5 * x704
    x706 = x356 * x621
    x707 = x353 * x621
    x708 = x4 * (x346 * x621 - x348 * x621)
    x709 = 0.5 * x708
    x710 = x360 * x621
    x711 = x4 * (x347 * x5 * x621 - x349 * x665)
    x712 = 0.5 * x711
    x713 = x259 + x368 * x621
    x714 = x44 * x713
    x715 = x240 * x44 + x377 * x621
    x716 = x257 + x369 * x621
    x717 = x44 * x716
    x718 = x371 * x621
    x719 = x234 + x5 * x718
    x720 = x233 + x718
    x721 = x4 * (-x50 * x716 + x713)
    x722 = 0.5 * x721
    x723 = x44 * x720
    x724 = x247 * x44
    x725 = x380 * x627 + x724
    x726 = x4 * (-x50 * x719 + x715)
    x727 = 0.5 * x726
    x728 = x560 + x575 * x621
    x729 = x44 * x728
    x730 = x113 * x689 + x276
    x731 = x112 * x689 + x564
    x732 = x44 * x731
    x733 = x271 + x388 * x627
    x734 = x388 * x621 + x569
    x735 = x4 * (-x50 * x731 + x728)
    x736 = 0.5 * x735
    x737 = x44 * x734
    x738 = x282 + x585 * x621
    x739 = x4 * (-x50 * x733 + x730)
    x740 = 0.5 * x739
    x741 = 3.0 * x335 + x399 * x621
    x742 = x44 * x741
    x743 = x317 * x89 + x410 * x621
    x744 = 3.0 * x332 + x400 * x621
    x745 = x44 * x744
    x746 = x402 * x621
    x747 = 3.0 * x310 + x5 * x746
    x748 = 3.0 * x309 + x746
    x749 = x4 * (-x50 * x744 + x741)
    x750 = 0.5 * x749
    x751 = x44 * x748
    x752 = x324 * x89 + x414 * x627
    x753 = x3 * x752
    x754 = x50 * x747
    x755 = x4 * (x743 - x754)
    x756 = 0.5 * x755
    x757 = x3 * x751
    x758 = x4 * (x421 * x621 - x423 * x621)
    x759 = 0.5 * x758
    x760 = x356 + x431 * x621
    x761 = x353 + x432 * x621
    x762 = x50 * x761
    x763 = x360 + x434 * x621
    x764 = x4 * (x760 - x762)
    x765 = 0.5 * x764
    x766 = 2.0 * x376 + x439 * x621
    x767 = 2.0 * x374 + x440 * x621
    x768 = x50 * x767
    x769 = 2.0 * x379 + x442 * x621
    x770 = x4 * (x766 - x768)
    x771 = 0.5 * x770
    x772 = 3.0 * x392 + x451 * x621
    x773 = x112 * x746 + 3.0 * x390
    x774 = x50 * x773
    x775 = x388 * x89 + x449 * x621
    x776 = x4 * (x772 - x774)
    x777 = 0.5 * x776
    x778 = 4.0 * x409 + x453 * x621
    x779 = 4.0 * x406 + x454 * x621
    x780 = x50 * x779
    x781 = 4.0 * x413 + x456 * x621
    x782 = x261 * x781
    x783 = x4 * (x778 - x780)
    x784 = 0.5 * x783
    x785 = x462**2
    x786 = x69 * x785
    x787 = x75 + x786
    x788 = x28 * x785
    x789 = x788 + x82
    x790 = x44 * x789
    x791 = x108 - x50 * (x109 + x42 * x785) + x57 * x785
    x792 = x44 * (x34 * x785 + x95)
    x793 = x462 * x71
    x794 = x144 + x462 * x481 + x793
    x795 = x462 * x77
    x796 = x150 + x462 * x483 + x795
    x797 = x169 + x44 * x463 + x462 * x475 - x50 * (x170 + x462 * x47 + x462 * x478)
    x798 = x18 * x97
    x799 = x96 * (x164 + x462 * x488 + x472 * x798)
    x800 = x194 * x785 + x199
    x801 = x175 * x785 + x206
    x802 = x44 * x801
    x803 = x185 * x785 + x222 - x50 * (x176 * x785 + x223)
    x804 = x5 * x785
    x805 = x44 * (x209 * x804 + x218)
    x806 = x250 + x462 * x510 + x483 * x96
    x807 = x254 + x462 * x512 + x489
    x808 = x267 + x462 * x501 + x476 * x96 - x50 * (x268 + x462 * x505 + x479 * x96)
    x809 = x44 * (x262 + x462 * x515 + 2.0 * x493)
    x810 = x196 * x462 + x283 + x462 * x526
    x811 = x288 + x462 * x528 + x496 * x97
    x812 = x811 * x96
    x813 = x298 + x44 * x494 + x462 * x519 - x50 * (x181 * x462 + x299 + x462 * x522)
    x814 = x44 * (x293 + x462 * x531 + x499)
    x815 = x322 * x785 + x326
    x816 = x324 * x785 + x329
    x817 = x44 * x816
    x818 = x315 * x785 + x344 - x50 * (x307 * x785 + x345)
    x819 = x44 * (x303 * x785 + x337)
    x820 = x351 + x462 * x553 + 3.0 * x516
    x821 = x44 * x820
    x822 = x363 + x462 * x558 + x512 * x89
    x823 = x366 + x462 * x546 - x50 * (x367 + x462 * x552 + x507 * x89) + x502 * x89
    x824 = x372 + x462 * x570 + 2.0 * x532
    x825 = x44 * x824
    x826 = x381 + x462 * x573 + x529
    x827 = x383 + x462 * x563 - x50 * (x384 + x462 * x568 + x525) + x521
    x828 = x387 + x462 * x582 + x539
    x829 = x44 * x828
    x830 = x395 + x44 * x537 + x462 * x586
    x831 = x396 + x44 * x536 + x462 * x578 - x50 * (x398 + x462 * x581 + x535)
    x832 = x402 * x785
    x833 = x404 + x832
    x834 = x44 * x833
    x835 = x414 * x804 + x416
    x836 = x410 * x785 + x419 - x50 * (x420 + x5 * x832)
    x837 = x427 + x462 * x602 + 4.0 * x555
    x838 = x429 + x462 * x595 - x50 * (x430 + x462 * x598 + 4.0 * x548) + 4.0 * x544
    x839 = x435 + x462 * x607 + 3.0 * x572
    x840 = x437 + x462 * x604 - x50 * (x438 + x462 * x605 + 3.0 * x566) + 3.0 * x562
    x841 = x443 + x462 * x612 + 2.0 * x584
    x842 = x445 + x462 * x609 - x50 * (x446 + x462 * x610 + 2.0 * x580) + 2.0 * x577
    x843 = x448 + x462 * x617 + x591
    x844 = x450 + x462 * x614 - x50 * (x452 + x462 * x615 + x589) + x588
    x845 = x456 * x785 + x458
    x846 = x453 * x785 + x460 - x50 * (x454 * x785 + x461)
    x847 = x4 * (x462 * x57 * x621 - x466 * x621)
    x848 = x621 * x71
    x849 = x480 * x621 + x848
    x850 = x621 * x77
    x851 = x482 * x621 + x850
    x852 = x61 * x621
    x853 = x47 * x621
    x854 = x4 * (x474 * x621 - x50 * (x477 * x621 + x853) + x852)
    x855 = x627 * x798
    x856 = x96 * (x487 * x621 + x855)
    x857 = x4 * (x462 * x636 - x462 * x647)
    x858 = x508 * x621 + x509 * x621
    x859 = x511 * x621 + x631
    x860 = x4 * (-x50 * (x503 * x621 + x504 * x621) + x500 * x621 + x628 * x96)
    x861 = x44 * (x506 * x621 + x514 * x621)
    x862 = x462 * x674 + x645
    x863 = x462 * x676 + x652
    x864 = x863 * x96
    x865 = x4 * (x462 * x668 - x50 * (x462 * x671 + x641) + x638)
    x866 = x44 * (x462 * x680 + x658)
    x867 = x4 * (x462 * x685 - x462 * x697)
    x868 = x462 * x701
    x869 = x549 * x621 + x551 * x621
    x870 = x44 * x869
    x871 = x556 * x621 + x557 * x621
    x872 = x4 * (-x50 * (x550 * x621 + x551 * x627) + x545 * x621 + x661 * x89)
    x873 = 2.0 * x681
    x874 = x462 * x720 + x873
    x875 = x44 * x874
    x876 = x462 * x725 + x677
    x877 = x4 * (x462 * x715 - x50 * (x462 * x719 + x673) + x670)
    x878 = x462 * x734 + x701
    x879 = x44 * x878
    x880 = x462 * x738 + x695
    x881 = x4 * (x462 * x730 - x50 * (x462 * x733 + x691) + x687)
    x882 = x462 * x751
    x883 = x4 * (x462 * x743 - x462 * x754)
    x884 = x600 * x621 + x601 * x621
    x885 = x4 * (-x50 * (x596 * x621 + x597 * x621) + x593 * x621 + x594 * x621)
    x886 = x462 * x763 + 3.0 * x723
    x887 = x4 * (x462 * x760 - x50 * (x462 * x761 + 3.0 * x717) + 3.0 * x714)
    x888 = x462 * x769 + 2.0 * x737
    x889 = x4 * (x462 * x766 - x50 * (x462 * x767 + 2.0 * x732) + 2.0 * x729)
    x890 = x462 * x775 + x751
    x891 = x4 * (x462 * x772 - x50 * (x462 * x773 + x745) + x742)
    x892 = x4 * (x462 * x778 - x462 * x780)
    x893 = x621**2
    x894 = x69 * x893 + x75
    x895 = x3 * x894
    x896 = x28 * x893 + x82
    x897 = x44 * x896
    x898 = 4.0 * x897
    x899 = x108 - x50 * (x109 + x42 * x893) + x57 * x893
    x900 = x74 * x899
    x901 = x44 * (x34 * x893 + x95)
    x902 = x139 * x893 + x144
    x903 = x117 * x893 + x150
    x904 = x44 * x903
    x905 = x128 * x893 + x169 - x50 * (x118 * x893 + x170)
    x906 = x74 * x905
    x907 = x44 * (x164 + x486 * x893)
    x908 = 2.0 * x907
    x909 = x199 + x621 * x642 + x848
    x910 = x3 * x909
    x911 = x206 + x621 * x644 + x850
    x912 = x44 * x911
    x913 = 3.0 * x912
    x914 = x222 - x50 * (x223 + x621 * x639 + x853) + x621 * x636 + x852
    x915 = x74 * x914
    x916 = x44 * (x218 + x621 * x651 + x855)
    x917 = 2.0 * x916
    x918 = x245 * x893 + x250
    x919 = x247 * x893 + x254
    x920 = x44 * x919
    x921 = x238 * x893 + x267 - x50 * (x231 * x893 + x268)
    x922 = x74 * x921
    x923 = x44 * (x228 * x893 + x262)
    x924 = x141 * x621 + x283 + x621 * x674
    x925 = x288 + x621 * x675 + x621 * x676
    x926 = x925 * x96
    x927 = x298 + x44 * x628 - x50 * (x124 * x621 + x299 + x621 * x671) + x621 * x668
    x928 = x74 * x927
    x929 = x44 * (x293 + x621 * x680 + x635)
    x930 = x326 + x621 * x692 + 2.0 * x645
    x931 = x3 * x930
    x932 = x329 + x621 * x694 + x653
    x933 = x44 * x932
    x934 = 2.0 * x933
    x935 = x344 - x50 * (x345 + x621 * x688 + 2.0 * x641) + x621 * x685 + 2.0 * x638
    x936 = x74 * x935
    x937 = x44 * (x337 + x621 * x700 + 2.0 * x658)
    x938 = x349 * x893
    x939 = x351 + x938
    x940 = x44 * x939
    x941 = x361 * x5 * x893 + x363
    x942 = x357 * x893 + x366 - x50 * (x367 + x5 * x938)
    x943 = x74 * x942
    x944 = x372 + x621 * x720 + x659
    x945 = x44 * x944
    x946 = x381 + x621 * x724 + x621 * x725
    x947 = x383 + x44 * x661 - x50 * (x384 + x621 * x719 + x660) + x621 * x715
    x948 = x74 * x947
    x949 = x387 + x621 * x734 + x873
    x950 = x44 * x949
    x951 = x395 + x621 * x738 + x677
    x952 = x396 - x50 * (x398 + x621 * x733 + x673) + x621 * x730 + x670
    x953 = x74 * x952
    x954 = x404 + x621 * x748 + 3.0 * x701
    x955 = x44 * x954
    x956 = x416 + x621 * x752 + 3.0 * x695
    x957 = x3 * x956
    x958 = x419 - x50 * (x420 + x621 * x747 + 3.0 * x691) + x621 * x743 + 3.0 * x687
    x959 = x74 * x958
    x960 = x425 * x893 + x427
    x961 = x421 * x893 + x429 - x50 * (x422 * x893 + x430)
    x962 = x74 * x961
    x963 = x435 + x621 * x763 + x710
    x964 = x437 - x50 * (x438 + x621 * x761 + x707) + x621 * x760 + x706
    x965 = x74 * x964
    x966 = x443 + x621 * x769 + 2.0 * x723
    x967 = x445 - x50 * (x446 + x621 * x767 + 2.0 * x717) + x621 * x766 + 2.0 * x714
    x968 = x74 * x967
    x969 = x448 + x621 * x775 + 3.0 * x737
    x970 = x450 - x50 * (x452 + x621 * x773 + 3.0 * x732) + x621 * x772 + 3.0 * x729
    x971 = x74 * x970
    x972 = x458 + x621 * x781 + 4.0 * x751
    x973 = x460 - x50 * (x461 + x621 * x779 + 4.0 * x745) + x621 * x778 + 4.0 * x742
    x974 = x74 * x973
    x975 = x462 * x787 + x467
    x976 = x44 * (x462 * x789 + x471)
    x977 = x462 * x794 + x484 + x790
    x978 = x462 * x796 + x491 + x792
    x979 = x462 * x800 + x495
    x980 = x44 * (x462 * x801 + x498)
    x981 = x462 * x806 + x513 + x796 * x96
    x982 = x462 * x807 + x518 + x799
    x983 = x462 * x810 + x530 + x802
    x984 = x96 * (x462 * x811 + x534 + x805)
    x985 = x462 * x815 + x538
    x986 = x44 * (x462 * x816 + x542)
    x987 = x44 * (x462 * x820 + x554 + 3.0 * x809)
    x988 = x462 * x822 + x559 + x807 * x89
    x989 = x44 * (x462 * x824 + x571 + 2.0 * x814)
    x990 = x462 * x826 + x574 + x812
    x991 = x44 * (x462 * x828 + x583 + x819)
    x992 = x462 * x830 + x587 + x817
    x993 = x44 * (x462 * x833 + x590)
    x994 = x462 * x835 + x592
    x995 = x462 * x837 + x603 + 4.0 * x821
    x996 = x462 * x839 + x608 + 3.0 * x825
    x997 = x462 * x841 + x613 + 2.0 * x829
    x998 = x462 * x843 + x618 + x834
    x999 = x462 * x845 + x620
    x1000 = x621 * x786 + x623
    x1001 = x44 * (x621 * x788 + x626)
    x1002 = x462 * x849 + x621 * x793 + x630
    x1003 = x462 * x851 + x621 * x795 + x634
    x1004 = x642 * x785 + x649
    x1005 = x44 * (x644 * x785 + x656)
    x1006 = x462 * x858 + x663 + x851 * x96
    x1007 = x462 * x859 + x667 + x856
    x1008 = x462 * x645 + x462 * x862 + x679
    x1009 = x96 * (x462 * x652 + x462 * x863 + x684)
    x1010 = x692 * x785 + x699
    x1011 = x44 * (x694 * x785 + x705)
    x1012 = x44 * (x462 * x869 + x709 + 3.0 * x861)
    x1013 = x462 * x871 + x712 + x859 * x89
    x1014 = x44 * (x462 * x874 + x722 + 2.0 * x866)
    x1015 = x462 * x876 + x727 + x864
    x1016 = x44 * (x462 * x878 + x736 + x868)
    x1017 = x462 * x695 + x462 * x880 + x740
    x1018 = x44 * (x748 * x785 + x750)
    x1019 = x752 * x785 + x756
    x1020 = x462 * x884 + x759 + 4.0 * x870
    x1021 = x462 * x886 + x765 + 3.0 * x875
    x1022 = x462 * x888 + x771 + 2.0 * x879
    x1023 = x462 * x890 + x777 + x882
    x1024 = x781 * x785 + x784
    x1025 = x462 * x902 + x897
    x1026 = x462 * x903 + x901
    x1027 = x462 * x918 + 2.0 * x904
    x1028 = x462 * x919 + x908
    x1029 = x462 * x924 + x912
    x1030 = x96 * (x462 * x925 + x916)
    x1031 = x44 * (x462 * x939 + 3.0 * x923)
    x1032 = x462 * x941 + 3.0 * x920
    x1033 = 2.0 * x929
    x1034 = x44 * (x1033 + x462 * x944)
    x1035 = x462 * x946 + x926
    x1036 = x44 * (x462 * x949 + x937)
    x1037 = x462 * x951 + x933
    x1038 = x462 * x955
    x1039 = x462 * x960 + 4.0 * x940
    x1040 = x462 * x963 + 3.0 * x945
    x1041 = x462 * x966 + 2.0 * x950
    x1042 = x462 * x969 + x955
    x1043 = x621 * x894 + x622
    x1044 = x44 * (x621 * x896 + x625)
    x1045 = x621 * x902 + x629
    x1046 = x44 * (x621 * x903 + x633)
    x1047 = x621 * x909 + x648 + x897
    x1048 = x44 * (x621 * x911 + x655 + x901)
    x1049 = x621 * x918 + x662
    x1050 = x44 * (x621 * x919 + x666)
    x1051 = x621 * x924 + x678 + x904
    x1052 = x96 * (x621 * x925 + x683 + x907)
    x1053 = x621 * x930 + x698 + 2.0 * x912
    x1054 = x44 * (x621 * x932 + x704 + x917)
    x1055 = x44 * (x621 * x939 + x708)
    x1056 = x621 * x941 + x711
    x1057 = x44 * (x621 * x944 + x721 + x923)
    x1058 = x621 * x946 + x726 + x920
    x1059 = x44 * (x1033 + x621 * x949 + x735)
    x1060 = x621 * x951 + x739 + x926
    x1061 = x44 * (x621 * x954 + x749 + 3.0 * x937)
    x1062 = x621 * x956 + x755 + 3.0 * x933
    x1063 = x621 * x960 + x758
    x1064 = x621 * x963 + x764 + x940
    x1065 = x621 * x966 + x770 + 2.0 * x945
    x1066 = x621 * x969 + x776 + 3.0 * x950
    x1067 = x621 * x972 + x783 + 4.0 * x955

    # 225 item(s)
    return numpy.array(
        [
            x110 * (x108 + x3 * x63 - x50 * (x109 + x3 * x49 + x80 * x92) + x80 * x94)
            + x3
            * (
                x3 * (x3 * (x70 + x72) + x75 + x79 * x80)
                + x4 * (-x49 * x50 + x63)
                + x80 * x90
            )
            + x80
            * (
                x3 * x90
                + x4 * (-x50 * x92 + x94)
                + x89 * (x3 * x88 + x95 + x96 * (x38 * x99 + x98))
            ),
            x110 * (x135 * x3 + x162 * x89 + x169 - x50 * (x126 * x3 + x159 * x89 + x170))
            + x3
            * (
                x156 * x89
                + x3 * (x144 + x148 * x89 + x3 * (x140 + x142))
                + x4 * (-x126 * x50 + x135)
            )
            + x89
            * (
                x156 * x3
                + x4 * (-x159 * x50 + x162)
                + x96 * (x152 * x3 + x155 * x3 + x164)
            ),
            x110 * (x191 * x3 + x216 * x89 + x222 - x50 * (x183 * x3 + x214 * x89 + x223))
            + x3
            * (
                x212 * x89
                + x3 * (x199 + x204 * x89 + x3 * (x195 + x197))
                + x4 * (-x183 * x50 + x191)
            )
            + x89
            * (
                x212 * x3
                + x4 * (-x214 * x50 + x216)
                + x96 * (x208 * x3 + x211 * x3 + x218)
            ),
            x110 * (x241 * x3 + x260 * x96 + x267 - x50 * (x235 * x3 + x258 * x96 + x268))
            + x3
            * (
                x256 * x96
                + x3 * (x250 + x252 * x96 + x3 * (x246 + x248))
                + x4 * (-x235 * x50 + x241)
            )
            + x96 * (x256 * x3 + x4 * (-x258 * x50 + x260) + x44 * (x228 * x261 + x262)),
            x110 * (x277 * x3 + x292 * x96 + x298 - x50 * (x272 * x3 + x290 * x96 + x299))
            + x3
            * (
                x289 * x96
                + x3 * (x283 + x287 * x96 + x3 * (x279 * x3 + x282))
                + x4 * (-x272 * x50 + x277)
            )
            + x96 * (x289 * x3 + x4 * (-x290 * x50 + x292) + x44 * (x261 * x294 + x293)),
            x110 * (x3 * x318 + x336 * x96 + x344 - x50 * (x3 * x311 + x334 * x96 + x345))
            + x3
            * (
                x3 * (x3 * (x323 + x324 * x96) + x326 + x328 * x96)
                + x331 * x96
                + x4 * (-x311 * x50 + x318)
            )
            + x96 * (x3 * x331 + x4 * (-x334 * x50 + x336) + x44 * (x261 * x303 + x337)),
            x110
            * (x3 * x346 * x44 + x3 * x359 + x366 - x50 * (x3 * x353 + x3 * x355 + x367))
            + x3
            * (
                x3 * (x3 * (x360 + x362) + x363 + x364)
                + x352 * x44
                + x4 * (-x355 * x50 + x359)
            )
            + x44 * (x3 * x352 + x4 * (x3 * x346 - x3 * x348)),
            x110
            * (x3 * x368 * x44 + x3 * x378 + x383 - x50 * (x3 * x374 + x3 * x375 + x384))
            + x3
            * (
                x3 * (x3 * x379 + x3 * (x379 + x380 * x99) + x381)
                + x373 * x44
                + x4 * (-x375 * x50 + x378)
            )
            + x44 * (x3 * x373 + x4 * (x3 * x368 - x3 * x370)),
            x110 * (x3 * x392 + x3 * x393 + x396 - x50 * (x112 * x330 + x3 * x391 + x398))
            + x3
            * (
                x3 * (x3 * x394 + x3 * (x153 * x319 + x394) + x395)
                + x389 * x44
                + x4 * (-x391 * x50 + x393)
            )
            + x44 * (x3 * x389 + x4 * (x112 * x3 * x304 - x3 * x386)),
            x110
            * (x3 * x399 * x44 + x3 * x412 + x419 - x50 * (x3 * x406 + x3 * x408 + x420))
            + x3
            * (
                x3 * (x3 * (x413 + x415) + x416 + x417)
                + x4 * (-x408 * x50 + x412)
                + x405 * x44
            )
            + x44 * (x3 * x405 + x4 * (x3 * x399 - x3 * x401)),
            x110 * (x261 * x421 + x429 - x50 * (x261 * x422 + x430))
            + x3 * (x3 * (x426 + x427) + x4 * (x3 * x421 - x424)),
            x110 * (x261 * x431 + x437 - x50 * (x261 * x432 + x438))
            + x3 * (x3 * (x261 * x434 + x435) + x4 * (x3 * x431 - x3 * x433)),
            x110 * (x261 * x439 + x445 - x50 * (x261 * x440 + x446))
            + x3 * (x3 * (x261 * x442 + x443) + x4 * (x3 * x439 - x3 * x441)),
            x110 * (x261 * x451 + x450 - x50 * (x112 * x403 + x452))
            + x3 * (x3 * (x261 * x449 + x448) + x4 * (x112 * x3 * x400 - x3 * x447)),
            x110 * (x261 * x453 + x460 - x50 * (x261 * x454 + x461))
            + x3 * (x3 * (x457 + x458) + x4 * (x3 * x453 - x3 * x455)),
            x3 * (x3 * (x464 + x465) + 0.5 * x467 + x470 * x80)
            + x4 * (x462 * x58 + x463 * x80 - x50 * (x43 * x462 + x462 * x48))
            + x80 * (x3 * x470 + 0.5 * x471 + x89 * (x462 * x83 + x472 * x473)),
            x3 * (x3 * (x3 * x481 + x483 * x89) + 0.5 * x484 + x490 * x89)
            + x4 * (x3 * x475 + x476 * x89 - x50 * (x3 * x478 + x479 * x89))
            + x89 * (x3 * x490 + 0.5 * x491 + x96 * (x3 * x488 + x493)),
            x3 * (x3 * (x195 * x462 + x197 * x462) + 0.5 * x495 + x497 * x89)
            + x4 * (x186 * x462 + x494 * x89 - x50 * (x177 * x462 + x182 * x462))
            + x89 * (x3 * x497 + 0.5 * x498 + x96 * (x210 * x462 + x499)),
            x3 * (x3 * (x3 * x510 + x512 * x96) + 0.5 * x513 + x517 * x96)
            + x4 * (x3 * x501 - x50 * (x3 * x505 + x507 * x96) + x502 * x96)
            + x96 * (x3 * x516 + x3 * x517 + 0.5 * x518),
            x3 * (x3 * (x3 * x526 + x529) + 0.5 * x530 + x533 * x96)
            + x4 * (x3 * x519 - x50 * (x3 * x522 + x525) + x521)
            + x96 * (x3 * x532 + x3 * x533 + 0.5 * x534),
            x3 * (x3 * (x323 * x462 + x537 * x96) + 0.5 * x538 + x540 * x96)
            + x4 * (x316 * x462 - x50 * (x308 * x462 + 2.0 * x535) + x536 * x96)
            + x96 * (x3 * x540 + x330 * x462 + 0.5 * x542),
            x3 * (x3 * x555 + x3 * (x3 * x558 + x555) + 0.5 * x559)
            + x4 * (x3 * x546 - x50 * (x3 * x552 + x548) + x544)
            + x44 * (x261 * x553 + 0.5 * x554),
            x3 * (x3 * x572 + x3 * (x3 * x573 + x572) + 0.5 * x574)
            + x4 * (x3 * x563 - x50 * (x3 * x568 + x566) + x562)
            + x44 * (x261 * x570 + 0.5 * x571),
            x3 * (x3 * x584 + x3 * (x3 * x586 + x584) + 0.5 * x587)
            + x4 * (x3 * x578 - x50 * (x3 * x581 + x580) + x577)
            + x44 * (x261 * x582 + 0.5 * x583),
            x3 * (x3 * (x415 * x462 + x591) + x417 * x462 + 0.5 * x592)
            + x4 * (x411 * x462 - x50 * (x407 * x462 + x589) + x588)
            + x44 * (x403 * x462 + 0.5 * x590),
            x3 * (x261 * x602 + 0.5 * x603) + x4 * (x3 * x595 - x3 * x599),
            x3 * (x261 * x607 + 0.5 * x608) + x4 * (x3 * x604 - x3 * x606),
            x3 * (x261 * x612 + 0.5 * x613) + x4 * (x3 * x609 - x3 * x611),
            x3 * (x261 * x617 + 0.5 * x618) + x4 * (x3 * x614 - x3 * x616),
            x3 * (x457 * x462 + 0.5 * x620) + x4 * (x3 * x453 * x462 - x455 * x619),
            x3 * (x3 * (x621 * x70 + x621 * x72) + x623 + x624 * x80)
            + x4 * (-x50 * (x43 * x621 + x48 * x621) + x58 * x621 + x62 * x621)
            + x80 * (x3 * x624 + x626 + x89 * (x473 * x627 + x621 * x83)),
            x3 * (x3 * (x140 * x621 + x142 * x621) + x630 + x632 * x89)
            + x4 * (x129 * x621 - x50 * (x119 * x621 + x125 * x621) + x628 * x89)
            + x89 * (x3 * x632 + x634 + x96 * (x154 * x621 + x635)),
            x3 * (x3 * (x643 + x646) + x649 + x654 * x89)
            + x4 * (x3 * x636 - x50 * (x3 * x639 + 3.0 * x641) + 3.0 * x638)
            + x89 * (x3 * x654 + x656 + x96 * (x3 * x651 + x658)),
            x3 * (x3 * (x246 * x621 + x248 * x621) + x663 + x664 * x96)
            + x4 * (x239 * x621 - x50 * (x232 * x621 + 2.0 * x660) + x661 * x96)
            + x96 * (x255 * x621 + x3 * x664 + x667),
            x3 * (x3 * (x3 * x674 + x677) + x679 + x682 * x96)
            + x4 * (x3 * x668 - x50 * (x3 * x671 + x673) + x670)
            + x96 * (x3 * x681 + x3 * x682 + x684),
            x3 * (x3 * (x693 + x696) + x699 + x703 * x96)
            + x4 * (x3 * x685 - x50 * (x3 * x688 + 2.0 * x691) + 2.0 * x687)
            + x96 * (x3 * x701 + x3 * x703 + x705),
            x3 * (x3 * (x362 * x621 + x710) + x364 * x621 + x712)
            + x4 * (x358 * x621 - x50 * (x354 * x621 + x707) + x706)
            + x44 * (x350 * x621 + x709),
            x3 * (x3 * x723 + x3 * (x3 * x725 + x723) + x727)
            + x4 * (x3 * x715 - x50 * (x3 * x719 + x717) + x714)
            + x44 * (x261 * x720 + x722),
            x3 * (x3 * x737 + x3 * (x3 * x738 + x737) + x740)
            + x4 * (x3 * x730 - x50 * (x3 * x733 + x732) + x729)
            + x44 * (x261 * x734 + x736),
            x3 * (x3 * (x751 + x753) + x756 + x757)
            + x4 * (x3 * x743 - x50 * (x3 * x747 + x745) + x742)
            + x44 * (x261 * x748 + x750),
            x3 * (x426 * x621 + x759) + x4 * (x3 * x421 * x621 - x424 * x621),
            x3 * (x261 * x763 + x765) + x4 * (x3 * x760 - x3 * x762),
            x3 * (x261 * x769 + x771) + x4 * (x3 * x766 - x3 * x768),
            x3 * (x261 * x775 + x777) + x4 * (x3 * x772 - x3 * x774),
            x3 * (x782 + x784) + x4 * (x3 * x778 - x3 * x780),
            x3 * (x3 * x787 + 4.0 * x790) + x74 * x791 + x80 * (x3 * x789 + 3.0 * x792),
            x3 * (x3 * x794 + x796 * x89) + x74 * x797 + x89 * (x3 * x796 + x799),
            x3 * (x3 * x800 + 3.0 * x802) + x74 * x803 + x89 * (x3 * x801 + 2.0 * x805),
            x3 * (x3 * x806 + x807 * x96) + x74 * x808 + x96 * (x3 * x807 + x809),
            x3 * (x3 * x810 + x812) + x74 * x813 + x96 * (x3 * x811 + x814),
            x3 * (x3 * x815 + 2.0 * x817) + x74 * x818 + x96 * (x3 * x816 + x819),
            x3 * x821 + x3 * (x3 * x822 + x821) + x74 * x823,
            x3 * x825 + x3 * (x3 * x826 + x825) + x74 * x827,
            x3 * x829 + x3 * (x3 * x830 + x829) + x74 * x831,
            x3 * x834 + x3 * (x3 * x835 + x834) + x74 * x836,
            x261 * x837 + x74 * x838,
            x261 * x839 + x74 * x840,
            x261 * x841 + x74 * x842,
            x261 * x843 + x74 * x844,
            x261 * x845 + x74 * x846,
            x3 * (x464 * x621 + x465 * x621)
            + x80 * (x468 * x621 + x469 * x621)
            + 0.5 * x847,
            x3 * (x3 * x849 + x851 * x89) + 0.5 * x854 + x89 * (x3 * x851 + x856),
            x3 * (x462 * x643 + x462 * x646)
            + 0.5 * x857
            + x89 * (x462 * x650 + x462 * x653),
            x3 * (x3 * x858 + x859 * x96) + 0.5 * x860 + x96 * (x3 * x859 + x861),
            x3 * (x3 * x862 + x864) + 0.5 * x865 + x96 * (x3 * x863 + x866),
            x3 * (x462 * x693 + x462 * x696) + 0.5 * x867 + x96 * (x462 * x702 + x868),
            x3 * x870 + x3 * (x3 * x871 + x870) + 0.5 * x872,
            x3 * x875 + x3 * (x3 * x876 + x875) + 0.5 * x877,
            x3 * x879 + x3 * (x3 * x880 + x879) + 0.5 * x881,
            x3 * (x462 * x753 + x882) + x462 * x757 + 0.5 * x883,
            x261 * x884 + 0.5 * x885,
            x261 * x886 + 0.5 * x887,
            x261 * x888 + 0.5 * x889,
            x261 * x890 + 0.5 * x891,
            x462 * x782 + 0.5 * x892,
            x3 * (x895 + x898) + x80 * (x3 * x896 + 3.0 * x901) + x900,
            x3 * (x3 * x902 + 3.0 * x904) + x89 * (x3 * x903 + x908) + x906,
            x3 * (x910 + x913) + x89 * (x3 * x911 + x917) + x915,
            x3 * (x3 * x918 + 2.0 * x920) + x922 + x96 * (x3 * x919 + x923),
            x3 * (x3 * x924 + x926) + x928 + x96 * (x3 * x925 + x929),
            x3 * (x931 + x934) + x936 + x96 * (x3 * x932 + x937),
            x3 * x940 + x3 * (x3 * x941 + x940) + x943,
            x3 * x945 + x3 * (x3 * x946 + x945) + x948,
            x3 * x950 + x3 * (x3 * x951 + x950) + x953,
            x3 * x955 + x3 * (x955 + x957) + x959,
            x261 * x960 + x962,
            x261 * x963 + x965,
            x261 * x966 + x968,
            x261 * x969 + x971,
            x261 * x972 + x974,
            x3 * x975 + 4.0 * x976,
            x3 * x977 + x89 * x978,
            x3 * x979 + 3.0 * x980,
            x3 * x981 + x96 * x982,
            x3 * x983 + x984,
            x3 * x985 + 2.0 * x986,
            x3 * x988 + x987,
            x3 * x990 + x989,
            x3 * x992 + x991,
            x3 * x994 + x993,
            x3 * x995,
            x3 * x996,
            x3 * x997,
            x3 * x998,
            x3 * x999,
            x1000 * x3 + 4.0 * x1001,
            x1002 * x3 + x1003 * x89,
            x1004 * x3 + 3.0 * x1005,
            x1006 * x3 + x1007 * x96,
            x1008 * x3 + x1009,
            x1010 * x3 + 2.0 * x1011,
            x1012 + x1013 * x3,
            x1014 + x1015 * x3,
            x1016 + x1017 * x3,
            x1018 + x1019 * x3,
            x1020 * x3,
            x1021 * x3,
            x1022 * x3,
            x1023 * x3,
            x1024 * x3,
            x462 * x895 + x462 * x898,
            x1025 * x3 + x1026 * x89,
            x462 * x910 + x462 * x913,
            x1027 * x3 + x1028 * x96,
            x1029 * x3 + x1030,
            x462 * x931 + x462 * x934,
            x1031 + x1032 * x3,
            x1034 + x1035 * x3,
            x1036 + x1037 * x3,
            x1038 + x462 * x957,
            x1039 * x3,
            x1040 * x3,
            x1041 * x3,
            x1042 * x3,
            x619 * x972,
            x1043 * x3 + 4.0 * x1044,
            x1045 * x3 + 3.0 * x1046,
            x1047 * x3 + 3.0 * x1048,
            x1049 * x3 + 2.0 * x1050,
            x1051 * x3 + x1052,
            x1053 * x3 + 2.0 * x1054,
            x1055 + x1056 * x3,
            x1057 + x1058 * x3,
            x1059 + x1060 * x3,
            x1061 + x1062 * x3,
            x1063 * x3,
            x1064 * x3,
            x1065 * x3,
            x1066 * x3,
            x1067 * x3,
            x110 * x791 + x462 * x975,
            x110 * x797 + x462 * x977 + x976,
            x110 * x803 + x462 * x979,
            x110 * x808 + x462 * x981 + x96 * x978,
            x110 * x813 + x462 * x983 + x980,
            x110 * x818 + x462 * x985,
            x110 * x823 + x462 * x988 + x89 * x982,
            x110 * x827 + x462 * x990 + x984,
            x110 * x831 + x462 * x992 + x986,
            x110 * x836 + x462 * x994,
            x110 * x838 + x462 * x995 + 4.0 * x987,
            x110 * x840 + x462 * x996 + 3.0 * x989,
            x110 * x842 + x462 * x997 + 2.0 * x991,
            x110 * x844 + x462 * x998 + x993,
            x110 * x846 + x462 * x999,
            x1000 * x462 + x847,
            x1001 + x1002 * x462 + x854,
            x1004 * x462 + x857,
            x1003 * x96 + x1006 * x462 + x860,
            x1005 + x1008 * x462 + x865,
            x1010 * x462 + x867,
            x1007 * x89 + x1013 * x462 + x872,
            x1009 + x1015 * x462 + x877,
            x1011 + x1017 * x462 + x881,
            x1019 * x462 + x883,
            4.0 * x1012 + x1020 * x462 + x885,
            3.0 * x1014 + x1021 * x462 + x887,
            2.0 * x1016 + x1022 * x462 + x889,
            x1018 + x1023 * x462 + x891,
            x1024 * x462 + x892,
            x785 * x894 + x900,
            x1025 * x462 + x462 * x897 + x906,
            x785 * x909 + x915,
            x1026 * x96 + x1027 * x462 + x922,
            x1029 * x462 + x462 * x912 + x928,
            x785 * x930 + x936,
            x1028 * x89 + x1032 * x462 + x943,
            x1030 + x1035 * x462 + x948,
            x1037 * x462 + x462 * x933 + x953,
            x785 * x956 + x959,
            4.0 * x1031 + x1039 * x462 + x962,
            3.0 * x1034 + x1040 * x462 + x965,
            2.0 * x1036 + x1041 * x462 + x968,
            x1038 + x1042 * x462 + x971,
            x785 * x972 + x974,
            x1043 * x462,
            x1044 + x1045 * x462,
            x1047 * x462,
            2.0 * x1046 + x1049 * x462,
            x1048 + x1051 * x462,
            x1053 * x462,
            3.0 * x1050 + x1056 * x462,
            x1052 + x1058 * x462,
            x1054 + x1060 * x462,
            x1062 * x462,
            4.0 * x1055 + x1063 * x462,
            3.0 * x1057 + x1064 * x462,
            2.0 * x1059 + x1065 * x462,
            x1061 + x1066 * x462,
            x1067 * x462,
            x1043 * x621 + x110 * x899,
            x1045 * x621 + x110 * x905,
            x1044 + x1047 * x621 + x110 * x914,
            x1049 * x621 + x110 * x921,
            x1046 + x1051 * x621 + x110 * x927,
            2.0 * x1048 + x1053 * x621 + x110 * x935,
            x1056 * x621 + x110 * x942,
            x1050 + x1058 * x621 + x110 * x947,
            x1052 + x1060 * x621 + x110 * x952,
            3.0 * x1054 + x1062 * x621 + x110 * x958,
            x1063 * x621 + x110 * x961,
            x1055 + x1064 * x621 + x110 * x964,
            2.0 * x1057 + x1065 * x621 + x110 * x967,
            3.0 * x1059 + x1066 * x621 + x110 * x970,
            4.0 * x1061 + x1067 * x621 + x110 * x973,
        ]
    )


def _2center2el3d_45(a, A, b, B):
    """Cartesian (g|h) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a ** (-1.0)
    x5 = -x2 - B[0]
    x6 = b ** (-1.0)
    x7 = a * x1
    x8 = b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(7, x8)
    x10 = x0 ** (-1.5)
    x11 = 17.4934183276249
    x12 = 2.0 * x6
    x13 = x11 * x12
    x14 = x10 * x13
    x15 = x14 * x9
    x16 = x15 * x5
    x17 = x0 ** (-0.5)
    x18 = boys(6, x8)
    x19 = 0.5 * x6
    x20 = x19 * (2.0 * x11 * x17 * x18 * x4 * x6 - x15)
    x21 = boys(8, x8)
    x22 = x5**2
    x23 = x17 * x4
    x24 = x13 * x23
    x25 = x22 * x24
    x26 = x21 * x25
    x27 = x20 + x26
    x28 = x27 * x5 + x6 * (2.0 * x11 * x17 * x18 * x4 * x5 * x6 - x16)
    x29 = x14 * x18
    x30 = boys(5, x8)
    x31 = x19 * (2.0 * x11 * x17 * x30 * x4 * x6 - x29)
    x32 = x24 * x9
    x33 = x22 * x32
    x34 = x31 + x33
    x35 = x14 * x30
    x36 = boys(4, x8)
    x37 = x19 * (2.0 * x11 * x17 * x36 * x4 * x6 - x35)
    x38 = x18 * x24
    x39 = x22 * x38
    x40 = x37 + x39
    x41 = 1.5 * x6
    x42 = x28 * x5 + x41 * (-x34 * x7 + x40)
    x43 = x29 * x5
    x44 = x34 * x5 + x6 * (2.0 * x11 * x17 * x30 * x4 * x5 * x6 - x43)
    x45 = x35 * x5
    x46 = x40 * x5 + x6 * (2.0 * x11 * x17 * x36 * x4 * x5 * x6 - x45)
    x47 = x12 * (-x44 * x7 + x46) + x42 * x5
    x48 = x3 * x47
    x49 = (2.0 * a + 2.0 * b) ** (-1.0)
    x50 = x14 * x36
    x51 = boys(3, x8)
    x52 = x19 * (2.0 * x11 * x17 * x4 * x51 * x6 - x50)
    x53 = x24 * x30
    x54 = x22 * x53
    x55 = x52 + x54
    x56 = x41 * (-x40 * x7 + x55) + x44 * x5
    x57 = x49 * x56
    x58 = 5.0 * x57
    x59 = x48 + x58
    x60 = b * x1
    x61 = x5 * x50
    x62 = x5 * x55 + x6 * (2.0 * x11 * x17 * x4 * x5 * x51 * x6 - x61)
    x63 = x12 * (-x46 * x7 + x62) + x5 * x56
    x64 = x3 * x63
    x65 = x14 * x51
    x66 = boys(2, x8)
    x67 = x19 * (2.0 * x11 * x17 * x4 * x6 * x66 - x65)
    x68 = x24 * x36
    x69 = x22 * x68
    x70 = x67 + x69
    x71 = x41 * (-x55 * x7 + x70) + x46 * x5
    x72 = x49 * x71
    x73 = 5.0 * x72
    x74 = x64 + x73
    x75 = x14 * x21
    x76 = x5 * x75
    x77 = x19 * (2.0 * x11 * x17 * x4 * x6 * x9 - x75)
    x78 = boys(9, x8)
    x79 = x25 * x78
    x80 = x12 * (-x28 * x7 + x44) + x5 * (
        x41 * (-x27 * x7 + x34)
        + x5 * (x5 * (x77 + x79) + x6 * (2.0 * x11 * x17 * x4 * x5 * x6 * x9 - x76))
    )
    x81 = x3 * x80
    x82 = x42 * x49
    x83 = 5.0 * x82
    x84 = x47 * x60
    x85 = 0.5 * x4
    x86 = x85 * (x63 - x84)
    x87 = x3 * x42
    x88 = x44 * x49
    x89 = 4.0 * x88
    x90 = x87 + x89
    x91 = 5.0 * x49
    x92 = x56 * x60
    x93 = x85 * (x71 - x92)
    x94 = x3 * x44
    x95 = x40 * x49
    x96 = 3.0 * x95
    x97 = x94 + x96
    x98 = 4.0 * x49
    x99 = x3 * x90 + x93 + x97 * x98
    x100 = x46 * x49
    x101 = 4.0 * x100 + x3 * x56
    x102 = x49 * x62
    x103 = 4.0 * x102 + x3 * x71
    x104 = x85 * (-x46 * x60 + x62)
    x105 = x11 * x23 * x6 * x98
    x106 = x105 * x30
    x107 = 3.0 * x49
    x108 = x14 * x66
    x109 = boys(1, x8)
    x110 = x19 * (-x108 + 2.0 * x109 * x11 * x17 * x4 * x6)
    x111 = x24 * x51
    x112 = x111 * x22
    x113 = x110 + x112
    x114 = x5 * x70 + x6 * (2.0 * x11 * x17 * x4 * x5 * x6 * x66 - x5 * x65)
    x115 = x12 * (x114 - x62 * x7) + x5 * x71
    x116 = x85 * (
        -x115 * x60
        + x12
        * (
            x113 * x5
            - x114 * x7
            + x6 * (-x108 * x5 + 2.0 * x109 * x11 * x17 * x4 * x5 * x6)
        )
        + x5 * (x41 * (x113 - x7 * x70) + x5 * x62)
    )
    x117 = x85 * (x115 - x60 * x63)
    x118 = 1.5 * x4
    x119 = -x1 * (a * A[1] + b * B[1])
    x120 = -x119 - B[1]
    x121 = x120 * x5
    x122 = x120 * x15
    x123 = x6 * (2.0 * x11 * x120 * x17 * x18 * x4 * x6 - x122)
    x124 = x120 * x26
    x125 = 0.5 * x123 + x124
    x126 = x125 * x5 + x6 * (2.0 * x11 * x120 * x17 * x18 * x4 * x5 * x6 - x121 * x15)
    x127 = x120 * x29
    x128 = x6 * (2.0 * x11 * x120 * x17 * x30 * x4 * x6 - x127)
    x129 = x120 * x33
    x130 = 0.5 * x128 + x129
    x131 = x120 * x35
    x132 = x6 * (2.0 * x11 * x120 * x17 * x36 * x4 * x6 - x131)
    x133 = x120 * x39
    x134 = 0.5 * x132 + x133
    x135 = x126 * x5 + x41 * (-x130 * x7 + x134)
    x136 = x135 * x3
    x137 = x130 * x5 + x6 * (2.0 * x11 * x120 * x17 * x30 * x4 * x5 * x6 - x121 * x29)
    x138 = x137 * x49
    x139 = 4.0 * x138
    x140 = x136 + x139
    x141 = x120 * x50
    x142 = x6 * (2.0 * x11 * x120 * x17 * x4 * x51 * x6 - x141)
    x143 = x120 * x54
    x144 = 0.5 * x142 + x143
    x145 = x137 * x5 + x41 * (-x134 * x7 + x144)
    x146 = x145 * x3
    x147 = x134 * x5 + x6 * (2.0 * x11 * x120 * x17 * x36 * x4 * x5 * x6 - x121 * x35)
    x148 = x147 * x49
    x149 = x146 + 4.0 * x148
    x150 = x120 * x75
    x151 = x6 * (2.0 * x11 * x120 * x17 * x4 * x6 * x9 - x150)
    x152 = x120 * x79
    x153 = x41 * (-x125 * x7 + x130) + x5 * (
        x5 * (0.5 * x151 + x152)
        + x6 * (2.0 * x11 * x120 * x17 * x4 * x5 * x6 * x9 - x121 * x75)
    )
    x154 = x153 * x3
    x155 = x126 * x49
    x156 = 4.0 * x155
    x157 = x135 * x60
    x158 = x85 * (x145 - x157)
    x159 = x126 * x3
    x160 = x130 * x49
    x161 = 3.0 * x160
    x162 = x159 + x161
    x163 = x137 * x60
    x164 = x85 * (x147 - x163)
    x165 = x130 * x3
    x166 = x121 * x18
    x167 = x105 * x166
    x168 = x165 + x167
    x169 = x107 * x168 + x162 * x3 + x164
    x170 = x134 * x49
    x171 = x137 * x3 + 3.0 * x170
    x172 = x144 * x49
    x173 = x147 * x3 + 3.0 * x172
    x174 = x85 * (-x134 * x60 + x144)
    x175 = x120 * x49 * x53
    x176 = x3 * x5
    x177 = x120 * x176
    x178 = 2.0 * x49
    x179 = x6 * (-x108 * x120 + 2.0 * x109 * x11 * x120 * x17 * x4 * x6)
    x180 = x6 * (2.0 * x11 * x120 * x17 * x4 * x6 * x66 - x120 * x65)
    x181 = x120 * x69 + 0.5 * x180
    x182 = x147 * x5 + x41 * (-x144 * x7 + x181)
    x183 = x85 * (
        -x182 * x60
        + x41 * (x112 * x120 + 0.5 * x179 - x181 * x7)
        + x5
        * (x144 * x5 + x6 * (2.0 * x11 * x120 * x17 * x4 * x5 * x51 * x6 - x121 * x50))
    )
    x184 = x85 * (-x145 * x60 + x182)
    x185 = -x1 * (a * A[2] + b * B[2])
    x186 = -x185 - B[2]
    x187 = x15 * x186
    x188 = x6 * (2.0 * x11 * x17 * x18 * x186 * x4 * x6 - x187)
    x189 = 0.5 * x188
    x190 = x186 * x26 + x189
    x191 = x190 * x5 + x6 * (2.0 * x11 * x17 * x18 * x186 * x4 * x5 * x6 - x16 * x186)
    x192 = x186 * x29
    x193 = x6 * (2.0 * x11 * x17 * x186 * x30 * x4 * x6 - x192)
    x194 = 0.5 * x193
    x195 = x186 * x33 + x194
    x196 = x186 * x35
    x197 = x6 * (2.0 * x11 * x17 * x186 * x36 * x4 * x6 - x196)
    x198 = 0.5 * x197
    x199 = x186 * x39 + x198
    x200 = x191 * x5 + x41 * (-x195 * x7 + x199)
    x201 = x200 * x3
    x202 = x195 * x5 + x6 * (2.0 * x11 * x17 * x186 * x30 * x4 * x5 * x6 - x186 * x43)
    x203 = x202 * x49
    x204 = 4.0 * x203
    x205 = x201 + x204
    x206 = x186 * x50
    x207 = x6 * (2.0 * x11 * x17 * x186 * x4 * x51 * x6 - x206)
    x208 = 0.5 * x207
    x209 = x186 * x54 + x208
    x210 = x202 * x5 + x41 * (-x199 * x7 + x209)
    x211 = x210 * x3
    x212 = x199 * x5 + x6 * (2.0 * x11 * x17 * x186 * x36 * x4 * x5 * x6 - x186 * x45)
    x213 = x212 * x49
    x214 = x211 + 4.0 * x213
    x215 = x186 * x75
    x216 = x6 * (2.0 * x11 * x17 * x186 * x4 * x6 * x9 - x215)
    x217 = 0.5 * x216
    x218 = x41 * (-x190 * x7 + x195) + x5 * (
        x5 * (x186 * x79 + x217)
        + x6 * (2.0 * x11 * x17 * x186 * x4 * x5 * x6 * x9 - x186 * x76)
    )
    x219 = x218 * x3
    x220 = x191 * x49
    x221 = 4.0 * x220
    x222 = x200 * x60
    x223 = x85 * (x210 - x222)
    x224 = x191 * x3
    x225 = x195 * x49
    x226 = 3.0 * x225
    x227 = x224 + x226
    x228 = x202 * x60
    x229 = x85 * (x212 - x228)
    x230 = x195 * x3
    x231 = x105 * x186
    x232 = x18 * x231
    x233 = x232 * x5
    x234 = x230 + x233
    x235 = x107 * x234 + x227 * x3 + x229
    x236 = x199 * x49
    x237 = x202 * x3 + 3.0 * x236
    x238 = x209 * x49
    x239 = x212 * x3 + 3.0 * x238
    x240 = x85 * (-x199 * x60 + x209)
    x241 = x186 * x53
    x242 = x241 * x49
    x243 = x186 * x38
    x244 = x6 * (-x108 * x186 + 2.0 * x109 * x11 * x17 * x186 * x4 * x6)
    x245 = 0.5 * x244
    x246 = x6 * (2.0 * x11 * x17 * x186 * x4 * x6 * x66 - x186 * x65)
    x247 = 0.5 * x246
    x248 = x186 * x69 + x247
    x249 = x212 * x5 + x41 * (-x209 * x7 + x248)
    x250 = x85 * (
        -x249 * x60
        + x41 * (x112 * x186 + x245 - x248 * x7)
        + x5
        * (x209 * x5 + x6 * (2.0 * x11 * x17 * x186 * x4 * x5 * x51 * x6 - x186 * x61))
    )
    x251 = x85 * (-x210 * x60 + x249)
    x252 = x120**2
    x253 = x252 * x38 + x37
    x254 = x252 * x32 + x31
    x255 = x254 * x5
    x256 = x24 * x252
    x257 = x21 * x256
    x258 = x20 + x257
    x259 = x253 - x254 * x7
    x260 = x19 * x259 + x22 * x258
    x261 = x260 * x5 + x6 * (x253 * x5 - x255 * x7)
    x262 = x261 * x3
    x263 = x252 * x53 + x52
    x264 = -x253 * x7 + x263
    x265 = x19 * x264 + x22 * x254
    x266 = x265 * x49
    x267 = 3.0 * x266
    x268 = x262 + x267
    x269 = -x263 * x5
    x270 = x253 * x5
    x271 = x265 * x5 + x6 * (-x269 - x270 * x7)
    x272 = x271 * x3
    x273 = x252 * x68 + x67
    x274 = -x263 * x7 + x273
    x275 = x19 * x274 + x22 * x253
    x276 = x275 * x49
    x277 = 3.0 * x276
    x278 = x272 + x277
    x279 = x258 * x7
    x280 = x256 * x78
    x281 = x280 + x77
    x282 = x254 - x279
    x283 = x5 * (x19 * x282 + x22 * x281) + x6 * (x254 * x5 - x279 * x5)
    x284 = x283 * x3
    x285 = x260 * x49
    x286 = 3.0 * x285
    x287 = x261 * x60
    x288 = x85 * (x271 - x287)
    x289 = x260 * x3
    x290 = x178 * x255
    x291 = x289 + x290
    x292 = x265 * x60
    x293 = x85 * (x275 - x292)
    x294 = x253 * x49
    x295 = x255 * x3
    x296 = x294 + x295
    x297 = x178 * x296 + x291 * x3 + x293
    x298 = x178 * x270 + x265 * x3
    x299 = x263 * x5
    x300 = x178 * x299 + x275 * x3
    x301 = x85 * (-x269 - x270 * x60)
    x302 = x110 + x111 * x252
    x303 = -x273 * x7 + x302
    x304 = x275 * x5 + x6 * (x273 * x5 - x299 * x7)
    x305 = x85 * (
        -x304 * x60 + x5 * (x19 * x303 + x22 * x263) + x6 * (-x273 * x5 * x7 + x302 * x5)
    )
    x306 = x85 * (-x271 * x60 + x304)
    x307 = x6 * (2.0 * x11 * x120 * x17 * x18 * x186 * x4 * x6 - x122 * x186)
    x308 = x124 * x186 + 0.5 * x307
    x309 = x308 * x5 + x6 * (
        2.0 * x11 * x120 * x17 * x18 * x186 * x4 * x5 * x6 - x121 * x187
    )
    x310 = x6 * (2.0 * x11 * x120 * x17 * x186 * x30 * x4 * x6 - x127 * x186)
    x311 = x129 * x186 + 0.5 * x310
    x312 = x107 * x311 + x3 * x309
    x313 = -2.0 * x11 * x120 * x17 * x186 * x30 * x4 * x5 * x6
    x314 = x311 * x5 + x6 * (-x121 * x192 - x313)
    x315 = x6 * (2.0 * x11 * x120 * x17 * x186 * x36 * x4 * x6 - x131 * x186)
    x316 = x133 * x186 + 0.5 * x315
    x317 = x107 * x316 + x3 * x314
    x318 = x6 * (2.0 * x11 * x120 * x17 * x186 * x4 * x6 * x9 - x150 * x186)
    x319 = x5 * (x152 * x186 + 0.5 * x318) + x6 * (
        2.0 * x11 * x120 * x17 * x186 * x4 * x5 * x6 * x9 - x121 * x215
    )
    x320 = x85 * (-x309 * x60 + x314)
    x321 = x121 * x231 * x9
    x322 = x3 * x308 + x321
    x323 = x85 * (-x311 * x60 + x316)
    x324 = x120 * x186 * x38
    x325 = x324 * x49
    x326 = x186 * x32
    x327 = x177 * x326 + x325
    x328 = x178 * x327 + x3 * x322 + x323
    x329 = x166 * x186
    x330 = x105 * x329
    x331 = x3 * x311 + x330
    x332 = x106 * x186
    x333 = x121 * x332
    x334 = x3 * x316 + x333
    x335 = x85 * (-2.0 * x10 * x11 * x329 * x4 - x313)
    x336 = x6 * (2.0 * x11 * x120 * x17 * x186 * x4 * x51 * x6 - x141 * x186)
    x337 = x316 * x5 + x6 * (
        2.0 * x11 * x120 * x17 * x186 * x36 * x4 * x5 * x6 - x121 * x196
    )
    x338 = x85 * (
        -x337 * x60
        + x5 * (x143 * x186 + 0.5 * x336)
        + x6 * (2.0 * x11 * x120 * x17 * x186 * x4 * x5 * x51 * x6 - x121 * x206)
    )
    x339 = x85 * (-x314 * x60 + x337)
    x340 = x186**2
    x341 = x340 * x38 + x37
    x342 = x31 + x32 * x340
    x343 = x342 * x5
    x344 = x24 * x340
    x345 = x20 + x21 * x344
    x346 = x22 * x345
    x347 = x341 - x342 * x7
    x348 = x19 * x347
    x349 = x346 + x348
    x350 = x349 * x5 + x6 * (x341 * x5 - x343 * x7)
    x351 = x3 * x350
    x352 = x22 * x342
    x353 = x340 * x53 + x52
    x354 = -x341 * x7 + x353
    x355 = x19 * x354
    x356 = x352 + x355
    x357 = x356 * x49
    x358 = 3.0 * x357
    x359 = x351 + x358
    x360 = -x353 * x5
    x361 = x341 * x5
    x362 = x356 * x5 + x6 * (-x360 - x361 * x7)
    x363 = x3 * x362
    x364 = x22 * x341
    x365 = x340 * x68 + x67
    x366 = -x353 * x7 + x365
    x367 = x19 * x366
    x368 = x364 + x367
    x369 = x368 * x49
    x370 = 3.0 * x369
    x371 = x363 + x370
    x372 = x345 * x7
    x373 = x344 * x78 + x77
    x374 = x22 * x373
    x375 = x342 - x372
    x376 = x19 * x375
    x377 = x5 * (x374 + x376) + x6 * (x342 * x5 - x372 * x5)
    x378 = x3 * x377
    x379 = x349 * x49
    x380 = 3.0 * x379
    x381 = x350 * x60
    x382 = x85 * (x362 - x381)
    x383 = x3 * x349
    x384 = x178 * x343
    x385 = x383 + x384
    x386 = x356 * x60
    x387 = x85 * (x368 - x386)
    x388 = x341 * x49
    x389 = x3 * x343
    x390 = x388 + x389
    x391 = x178 * x390 + x3 * x385 + x387
    x392 = x178 * x361 + x3 * x356
    x393 = x353 * x5
    x394 = x178 * x393 + x3 * x368
    x395 = x85 * (-x360 - x361 * x60)
    x396 = x110 + x111 * x340
    x397 = x22 * x353
    x398 = -x365 * x7 + x396
    x399 = x19 * x398
    x400 = x368 * x5 + x6 * (x365 * x5 - x393 * x7)
    x401 = x85 * (-x400 * x60 + x5 * (x397 + x399) + x6 * (-x365 * x5 * x7 + x396 * x5))
    x402 = x85 * (-x362 * x60 + x400)
    x403 = x120 * x258 + x123
    x404 = x120 * x254 + x128
    x405 = x120 * x253 + x132
    x406 = -x404 * x7 + x405
    x407 = x19 * x406 + x22 * x403
    x408 = x3 * x407
    x409 = x404 * x49
    x410 = x409 * x5
    x411 = x408 + 2.0 * x410
    x412 = x120 * x263 + x142
    x413 = -x405 * x7 + x412
    x414 = x19 * x413 + x22 * x404
    x415 = x3 * x414
    x416 = x405 * x5
    x417 = x178 * x416 + x415
    x418 = x120 * x281 + x151
    x419 = -x403 * x7 + x404
    x420 = x19 * x419 + x22 * x418
    x421 = x3 * x420
    x422 = x403 * x5
    x423 = x407 * x60
    x424 = x85 * (x414 - x423)
    x425 = x176 * x403
    x426 = x409 + x425
    x427 = x5 * x60
    x428 = x85 * (-x404 * x427 + x405 * x5)
    x429 = x3 * x409
    x430 = x3 * x426 + x428 + x429
    x431 = x405 * x49
    x432 = x176 * x404 + x431
    x433 = x412 * x49
    x434 = x3 * x416 + x433
    x435 = x3**2
    x436 = x85 * (-x405 * x60 + x412)
    x437 = x120 * x273 + x180
    x438 = x120 * x302 + x179 - x437 * x7
    x439 = -x412 * x7 + x437
    x440 = x19 * x439 + x22 * x405
    x441 = x85 * (x19 * x438 + x22 * x412 - x440 * x60)
    x442 = x85 * (-x414 * x60 + x440)
    x443 = x186 * x257 + x189
    x444 = x194 + x252 * x326
    x445 = x198 + x243 * x252
    x446 = -x444 * x7 + x445
    x447 = x19 * x446 + x22 * x443
    x448 = x444 * x49
    x449 = 2.0 * x448
    x450 = x449 * x5
    x451 = x3 * x447 + x450
    x452 = x208 + x241 * x252
    x453 = -x445 * x7 + x452
    x454 = x19 * x453 + x22 * x444
    x455 = x445 * x5
    x456 = x178 * x455
    x457 = x3 * x454 + x456
    x458 = x186 * x280 + x217
    x459 = -x443 * x7 + x444
    x460 = x19 * x459 + x22 * x458
    x461 = x443 * x5
    x462 = x178 * x461
    x463 = x85 * (-x447 * x60 + x454)
    x464 = x176 * x443 + x448
    x465 = x85 * (-x427 * x444 + x445 * x5)
    x466 = x3 * x448 + x3 * x464 + x465
    x467 = x445 * x49
    x468 = x176 * x444 + x467
    x469 = x452 * x49
    x470 = x3 * x455 + x469
    x471 = x85 * (-x445 * x60 + x452)
    x472 = x186 * x252 * x68 + x247
    x473 = x111 * x186 * x252 + x245 - x472 * x7
    x474 = -x452 * x7 + x472
    x475 = x19 * x474 + x22 * x445
    x476 = x85 * (x19 * x473 + x22 * x452 - x475 * x60)
    x477 = x85 * (-x454 * x60 + x475)
    x478 = x120 * x342
    x479 = x6 * (x120 * x341 - x478 * x7)
    x480 = x120 * x346 + 0.5 * x479
    x481 = x120 * x384
    x482 = x3 * x480 + x481
    x483 = -x120 * x353
    x484 = x120 * x341
    x485 = x6 * (-x483 - x484 * x7)
    x486 = x120 * x352 + 0.5 * x485
    x487 = x120 * x361
    x488 = x178 * x487
    x489 = x3 * x486 + x488
    x490 = x6 * (x120 * x342 - x120 * x372)
    x491 = x120 * x374 + 0.5 * x490
    x492 = x121 * x345
    x493 = x178 * x492
    x494 = x85 * (-x480 * x60 + x486)
    x495 = x478 * x49
    x496 = x177 * x345 + x495
    x497 = x120 * x60
    x498 = x85 * (x120 * x341 * x5 - x343 * x497)
    x499 = x3 * x495 + x3 * x496 + x498
    x500 = x120 * x388
    x501 = x120 * x389 + x500
    x502 = x120 * x353
    x503 = x3 * x487 + x49 * x502
    x504 = x85 * (-x483 - x484 * x60)
    x505 = x6 * (-x120 * x365 * x7 + x120 * x396)
    x506 = x6 * (x120 * x365 - x502 * x7)
    x507 = x120 * x364 + 0.5 * x506
    x508 = x85 * (x120 * x397 + 0.5 * x505 - x507 * x60)
    x509 = x85 * (-x486 * x60 + x507)
    x510 = x186 * x345 + x188
    x511 = x186 * x342 + x193
    x512 = x186 * x341 + x197
    x513 = -x511 * x7 + x512
    x514 = x19 * x513
    x515 = x22 * x510 + x514
    x516 = x3 * x515
    x517 = x49 * x511
    x518 = x5 * x517
    x519 = x516 + 2.0 * x518
    x520 = x186 * x353 + x207
    x521 = -x512 * x7 + x520
    x522 = x19 * x521
    x523 = x22 * x511 + x522
    x524 = x3 * x523
    x525 = x5 * x512
    x526 = x178 * x525 + x524
    x527 = x186 * x373 + x216
    x528 = -x510 * x7 + x511
    x529 = x19 * x528
    x530 = x22 * x527 + x529
    x531 = x3 * x530
    x532 = x5 * x510
    x533 = x515 * x60
    x534 = x85 * (x523 - x533)
    x535 = x176 * x510
    x536 = x517 + x535
    x537 = x85 * (-x427 * x511 + x5 * x512)
    x538 = x3 * x517
    x539 = x3 * x536 + x537 + x538
    x540 = x49 * x512
    x541 = x176 * x511
    x542 = x540 + x541
    x543 = x49 * x520
    x544 = x3 * x525 + x543
    x545 = x85 * (-x512 * x60 + x520)
    x546 = x186 * x365 + x246
    x547 = x186 * x396 + x244 - x546 * x7
    x548 = x19 * x547
    x549 = -x520 * x7 + x546
    x550 = x19 * x549
    x551 = x22 * x512 + x550
    x552 = x85 * (x22 * x520 + x548 - x551 * x60)
    x553 = x85 * (-x523 * x60 + x551)
    x554 = x120 * x405 + x274 * x41
    x555 = x120 * x404 + x264 * x41
    x556 = x555 * x60
    x557 = x120 * x403 + x259 * x41
    x558 = x435 * x557
    x559 = x85 * (x554 - x556)
    x560 = x558 + x559
    x561 = x49 * x555
    x562 = x176 * x557
    x563 = x561 + x562
    x564 = x49 * x554
    x565 = x5 * x555
    x566 = x3 * x565
    x567 = x564 + x566
    x568 = x49 * x557
    x569 = x120 * x418 + x282 * x41
    x570 = x176 * x569
    x571 = x85 * (-x427 * x557 + x5 * x555)
    x572 = x3 * x568
    x573 = x120 * x412 + x303 * x41
    x574 = x85 * (-x5 * x554 * x60 + x5 * x573)
    x575 = x85 * (x5 * x554 - x565 * x60)
    x576 = x120 * x445 + x315
    x577 = x120 * x444 + x310
    x578 = x577 * x60
    x579 = x120 * x443 + x307
    x580 = x85 * (x576 - x578)
    x581 = x435 * x579 + x580
    x582 = x49 * x577
    x583 = x176 * x579 + x582
    x584 = x49 * x576
    x585 = x5 * x577
    x586 = x3 * x585 + x584
    x587 = x49 * x579
    x588 = x120 * x458 + x318
    x589 = x85 * (-x427 * x579 + x5 * x577)
    x590 = x120 * x452 + x336
    x591 = x85 * (-x5 * x576 * x60 + x5 * x590)
    x592 = x85 * (x5 * x576 - x585 * x60)
    x593 = x252 * x341 + x367
    x594 = x252 * x342 + x355
    x595 = x594 * x60
    x596 = x252 * x345 + x348
    x597 = x85 * (x593 - x595)
    x598 = x435 * x596 + x597
    x599 = x49 * x594
    x600 = x176 * x596 + x599
    x601 = x49 * x593
    x602 = x5 * x594
    x603 = x3 * x602 + x601
    x604 = x49 * x596
    x605 = x252 * x373 + x376
    x606 = x85 * (-x427 * x596 + x5 * x594)
    x607 = x252 * x353 + x399
    x608 = x85 * (-x5 * x593 * x60 + x5 * x607)
    x609 = x85 * (x5 * x593 - x60 * x602)
    x610 = x497 * x511
    x611 = x85 * (x120 * x512 - x610)
    x612 = x120 * x510
    x613 = x435 * x612 + x611
    x614 = x120 * x517
    x615 = x120 * x535 + x614
    x616 = x120 * x540
    x617 = x120 * x541 + x616
    x618 = x49 * x612
    x619 = x85 * (x120 * x5 * x511 - x427 * x612)
    x620 = x85 * (x120 * x5 * x520 - x120 * x525 * x60)
    x621 = x121 * x511
    x622 = x85 * (x120 * x5 * x512 - x60 * x621)
    x623 = x186 * x512 + x366 * x41
    x624 = x186 * x511 + x354 * x41
    x625 = x60 * x624
    x626 = x186 * x510 + x347 * x41
    x627 = x435 * x626
    x628 = x85 * (x623 - x625)
    x629 = x627 + x628
    x630 = x49 * x624
    x631 = x176 * x626
    x632 = x630 + x631
    x633 = x49 * x623
    x634 = x5 * x624
    x635 = x3 * x634
    x636 = x633 + x635
    x637 = x49 * x626
    x638 = x186 * x527 + x375 * x41
    x639 = x176 * x638
    x640 = x85 * (-x427 * x626 + x5 * x624)
    x641 = x3 * x637
    x642 = x186 * x520 + x398 * x41
    x643 = x85 * (-x5 * x60 * x623 + x5 * x642)
    x644 = x85 * (x5 * x623 - x60 * x634)
    x645 = x12 * x413 + x120 * x555
    x646 = x12 * x406 + x120 * x557
    x647 = x60 * x646
    x648 = x3 * x647
    x649 = x12 * x419 + x120 * x569
    x650 = x435 * x649
    x651 = x85 * (x645 - x647)
    x652 = x12 * x439 + x120 * x554
    x653 = x85 * (x12 * x438 + x120 * x573 - x60 * x652)
    x654 = x85 * (-x60 * x645 + x652)
    x655 = x120 * x577 + x41 * x453
    x656 = x120 * x579 + x41 * x446
    x657 = x60 * x656
    x658 = x120 * x588 + x41 * x459
    x659 = x85 * (x655 - x657)
    x660 = x120 * x576 + x41 * x474
    x661 = x85 * (x120 * x590 + x41 * x473 - x60 * x660)
    x662 = x85 * (-x60 * x655 + x660)
    x663 = x120 * x594 + x485
    x664 = x120 * x596 + x479
    x665 = x60 * x664
    x666 = x120 * x605 + x490
    x667 = x85 * (x663 - x665)
    x668 = x120 * x593 + x506
    x669 = x85 * (x120 * x607 + x505 - x60 * x668)
    x670 = x85 * (-x60 * x663 + x668)
    x671 = x252 * x511 + x522
    x672 = x252 * x510 + x514
    x673 = x60 * x672
    x674 = x252 * x527 + x529
    x675 = x85 * (x671 - x673)
    x676 = x252 * x512 + x550
    x677 = x85 * (x252 * x520 + x548 - x60 * x676)
    x678 = x85 * (-x60 * x671 + x676)
    x679 = x497 * x626
    x680 = x85 * (x120 * x624 - x679)
    x681 = x120 * x638
    x682 = x85 * (-x120 * x60 * x623 + x120 * x642)
    x683 = x120 * x624
    x684 = x85 * (x120 * x623 - x60 * x683)
    x685 = x12 * x521 + x186 * x624
    x686 = x12 * x513 + x186 * x626
    x687 = x60 * x686
    x688 = x12 * x528 + x186 * x638
    x689 = x435 * x688
    x690 = x85 * (x685 - x687)
    x691 = x12 * x549 + x186 * x623
    x692 = x85 * (x12 * x547 + x186 * x642 - x60 * x691)
    x693 = x85 * (-x60 * x685 + x691)
    x694 = -x119 - A[1]
    x695 = x694 * x71
    x696 = x694 * x81
    x697 = x694 * x83
    x698 = x694 * x84
    x699 = x4 * (x63 * x694 - x698)
    x700 = x694 * x87
    x701 = x694 * x89
    x702 = x700 + x701
    x703 = x4 * (x694 * x71 - x694 * x92)
    x704 = x145 * x694
    x705 = x704 + x72
    x706 = x102 + x147 * x694
    x707 = x135 * x694
    x708 = x57 + x707
    x709 = x100 + x137 * x694
    x710 = x153 * x694
    x711 = x710 + x82
    x712 = x126 * x694
    x713 = x712 + x88
    x714 = x4 * (-x60 * x708 + x705)
    x715 = x130 * x694
    x716 = x715 + x95
    x717 = x107 * x716 + x3 * x713
    x718 = x4 * (-x60 * x709 + x706)
    x719 = x49 * x5 * x53
    x720 = x121 * x694
    x721 = x178 * (x38 * x720 + x719)
    x722 = x212 * x694
    x723 = x4 * (x210 * x694 - x222 * x694)
    x724 = x224 * x694 + x226 * x694
    x725 = x4 * (x212 * x694 - x228 * x694)
    x726 = x5 * x694
    x727 = x271 * x694
    x728 = 2.0 * x148 + x727
    x729 = 2.0 * x172 + x275 * x694
    x730 = x107 * x729
    x731 = x261 * x694
    x732 = 2.0 * x138
    x733 = x731 + x732
    x734 = 2.0 * x170 + x265 * x694
    x735 = x107 * x734
    x736 = x283 * x694
    x737 = 2.0 * x155
    x738 = x736 + x737
    x739 = x260 * x694
    x740 = 2.0 * x160
    x741 = x739 + x740
    x742 = x107 * x741
    x743 = x4 * (-x60 * x733 + x728)
    x744 = x255 * x694
    x745 = x167 + x744
    x746 = x178 * x745 + x3 * x741
    x747 = x4 * (-x60 * x734 + x729)
    x748 = x49 * (x106 * x120 + x253 * x694)
    x749 = x213 + x314 * x694
    x750 = x238 + x316 * x694
    x751 = x203 + x309 * x694
    x752 = x236 + x311 * x694
    x753 = x220 + x319 * x694
    x754 = x225 + x308 * x694
    x755 = x4 * (-x60 * x751 + x749)
    x756 = x186 * x38 * x49 * x5 + x326 * x720
    x757 = x178 * x756
    x758 = x3 * x754 + x757
    x759 = x4 * (-x60 * x752 + x750)
    x760 = x120 * x694
    x761 = x49 * (x242 + x243 * x760)
    x762 = x368 * x694
    x763 = x4 * (x362 * x694 - x381 * x694)
    x764 = x383 * x694 + x384 * x694
    x765 = x4 * (x368 * x694 - x386 * x694)
    x766 = x388 * x694
    x767 = x414 * x694
    x768 = x277 + x767
    x769 = x107 * x299 + x416 * x694
    x770 = x407 * x694
    x771 = x267 + x770
    x772 = x404 * x694
    x773 = x107 * x270 + x5 * x772
    x774 = x420 * x694
    x775 = x286 + x774
    x776 = x403 * x726
    x777 = x107 * x255
    x778 = x776 + x777
    x779 = x4 * (-x60 * x771 + x768)
    x780 = 3.0 * x294
    x781 = x772 + x780
    x782 = x49 * x781
    x783 = x3 * x778 + x782
    x784 = x4 * (-x60 * x773 + x769)
    x785 = x178 * x316
    x786 = x454 * x694 + x785
    x787 = x333 + x455 * x694
    x788 = x178 * x311
    x789 = x447 * x694 + x788
    x790 = x444 * x694
    x791 = x330 + x5 * x790
    x792 = x178 * x308
    x793 = x460 * x694 + x792
    x794 = x321 + x443 * x726
    x795 = x4 * (-x60 * x789 + x786)
    x796 = x120 * x232
    x797 = x790 + x796
    x798 = x49 * x797
    x799 = x3 * x794 + x798
    x800 = x4 * (-x60 * x791 + x787)
    x801 = x369 + x486 * x694
    x802 = x393 * x49 + x487 * x694
    x803 = x178 * x802
    x804 = x357 + x480 * x694
    x805 = x343 * x760 + x361 * x49
    x806 = x178 * x805
    x807 = x379 + x491 * x694
    x808 = x343 * x49
    x809 = x345 * x720 + x808
    x810 = x178 * x809
    x811 = x4 * (-x60 * x804 + x801)
    x812 = x388 + x478 * x694
    x813 = x49 * x812
    x814 = x3 * x809 + x813
    x815 = x4 * (-x60 * x805 + x802)
    x816 = x517 * x726
    x817 = x525 * x694
    x818 = x510 * x726
    x819 = x4 * (x523 * x694 - x533 * x694)
    x820 = x517 * x694
    x821 = x535 * x694 + x820
    x822 = x60 * x726
    x823 = x4 * (x5 * x512 * x694 - x511 * x822)
    x824 = 4.0 * x433 + x554 * x694
    x825 = x49 * x824
    x826 = x565 * x694
    x827 = x416 * x98 + x826
    x828 = 4.0 * x431 + x555 * x694
    x829 = x49 * x828
    x830 = x557 * x694
    x831 = x5 * x830
    x832 = 4.0 * x409
    x833 = x5 * x832 + x831
    x834 = x830 + x832
    x835 = x4 * (-x60 * x828 + x824)
    x836 = x49 * x834
    x837 = x569 * x726
    x838 = x422 * x98 + x837
    x839 = x4 * (-x60 * x833 + x827)
    x840 = 3.0 * x469 + x576 * x694
    x841 = x49 * x840
    x842 = x107 * x455 + x585 * x694
    x843 = 3.0 * x467 + x577 * x694
    x844 = x49 * x843
    x845 = x579 * x694
    x846 = 3.0 * x448
    x847 = x5 * x845 + x5 * x846
    x848 = x845 + x846
    x849 = x4 * (-x60 * x843 + x840)
    x850 = x49 * x848
    x851 = x107 * x461 + x588 * x726
    x852 = x4 * (-x60 * x847 + x842)
    x853 = x178 * x502 + x593 * x694
    x854 = x49 * x853
    x855 = x488 + x602 * x694
    x856 = 2.0 * x500 + x594 * x694
    x857 = x49 * x856
    x858 = x596 * x694
    x859 = x481 + x5 * x858
    x860 = x178 * x478 + x858
    x861 = x4 * (-x60 * x856 + x853)
    x862 = x49 * x860
    x863 = x493 + x605 * x726
    x864 = x4 * (-x60 * x859 + x855)
    x865 = x120 * x512
    x866 = x543 + x694 * x865
    x867 = x49 * x866
    x868 = x49 * x525 + x621 * x694
    x869 = x511 * x760 + x540
    x870 = x49 * x869
    x871 = x518 + x612 * x726
    x872 = x517 + x612 * x694
    x873 = x4 * (-x60 * x869 + x866)
    x874 = x49 * x872
    x875 = x49 * x532 + x527 * x720
    x876 = x4 * (-x60 * x871 + x868)
    x877 = x633 * x694
    x878 = x630 * x694
    x879 = x4 * (x623 * x694 - x625 * x694)
    x880 = x637 * x694
    x881 = x4 * (x5 * x624 * x694 - x626 * x822)
    x882 = x645 * x694
    x883 = 5.0 * x564
    x884 = x882 + x883
    x885 = x646 * x694
    x886 = 5.0 * x561
    x887 = x885 + x886
    x888 = x60 * x887
    x889 = x649 * x694
    x890 = 5.0 * x568
    x891 = x889 + x890
    x892 = x4 * (x884 - x888)
    x893 = 4.0 * x584 + x655 * x694
    x894 = 4.0 * x582 + x656 * x694
    x895 = x60 * x894
    x896 = 4.0 * x587 + x658 * x694
    x897 = x4 * (x893 - x895)
    x898 = 3.0 * x601
    x899 = x663 * x694 + x898
    x900 = 3.0 * x599
    x901 = x664 * x694 + x900
    x902 = x60 * x901
    x903 = 3.0 * x604
    x904 = x666 * x694 + x903
    x905 = x4 * (x899 - x902)
    x906 = 2.0 * x616 + x671 * x694
    x907 = 2.0 * x614 + x672 * x694
    x908 = x60 * x907
    x909 = x178 * x612 + x674 * x694
    x910 = x4 * (x906 - x908)
    x911 = x633 + x683 * x694
    x912 = x626 * x760 + x630
    x913 = x60 * x912
    x914 = x637 + x681 * x694
    x915 = x4 * (x911 - x913)
    x916 = x3 * x694
    x917 = x4 * (x685 * x694 - x687 * x694)
    x918 = -x185 - A[2]
    x919 = x4 * (x63 * x918 - x84 * x918)
    x920 = 0.5 * x919
    x921 = x87 * x918 + x89 * x918
    x922 = x4 * (x71 * x918 - x918 * x92)
    x923 = 0.5 * x922
    x924 = x147 * x918
    x925 = x4 * (x145 * x918 - x157 * x918)
    x926 = 0.5 * x925
    x927 = x159 * x918 + x161 * x918
    x928 = x4 * (x147 * x918 - x163 * x918)
    x929 = 0.5 * x928
    x930 = x121 * x918
    x931 = x105 * x18 * x930
    x932 = x210 * x918 + x72
    x933 = x102 + x212 * x918
    x934 = x49 * x933
    x935 = x200 * x918 + x57
    x936 = x100 + x202 * x918
    x937 = x49 * x936
    x938 = x218 * x918 + x82
    x939 = x3 * x938
    x940 = x191 * x918 + x88
    x941 = x49 * x940
    x942 = 4.0 * x941
    x943 = x60 * x935
    x944 = x4 * (x932 - x943)
    x945 = 0.5 * x944
    x946 = x3 * x940
    x947 = x195 * x918 + x95
    x948 = x49 * x947
    x949 = 3.0 * x948
    x950 = x946 + x949
    x951 = x4 * (-x60 * x936 + x933)
    x952 = 0.5 * x951
    x953 = x5 * x918
    x954 = x49 * (x243 * x953 + x719)
    x955 = 2.0 * x954
    x956 = x267 * x918
    x957 = x275 * x918
    x958 = x107 * x957
    x959 = x286 * x918
    x960 = x4 * (x271 * x918 - x287 * x918)
    x961 = 0.5 * x960
    x962 = x289 * x918 + x290 * x918
    x963 = x4 * (x275 * x918 - x292 * x918)
    x964 = 0.5 * x963
    x965 = x294 * x918
    x966 = x148 + x314 * x918
    x967 = x172 + x316 * x918
    x968 = x138 + x309 * x918
    x969 = x170 + x311 * x918
    x970 = x155 + x319 * x918
    x971 = x160 + x308 * x918
    x972 = x4 * (-x60 * x968 + x966)
    x973 = 0.5 * x972
    x974 = x121 * x38 * x49 + x326 * x930
    x975 = x178 * x974
    x976 = x3 * x971 + x975
    x977 = x4 * (-x60 * x969 + x967)
    x978 = 0.5 * x977
    x979 = x49 * (x175 + x324 * x918)
    x980 = 2.0 * x213 + x362 * x918
    x981 = 2.0 * x238 + x368 * x918
    x982 = x49 * x981
    x983 = 3.0 * x982
    x984 = 2.0 * x203 + x350 * x918
    x985 = 2.0 * x236 + x356 * x918
    x986 = x49 * x985
    x987 = 3.0 * x986
    x988 = 2.0 * x220 + x377 * x918
    x989 = x3 * x988
    x990 = 2.0 * x225 + x349 * x918
    x991 = x49 * x990
    x992 = 3.0 * x991
    x993 = x60 * x984
    x994 = x4 * (x980 - x993)
    x995 = 0.5 * x994
    x996 = x3 * x990
    x997 = x343 * x918
    x998 = x233 + x997
    x999 = x49 * x998
    x1000 = 2.0 * x999
    x1001 = x1000 + x996
    x1002 = x4 * (-x60 * x985 + x981)
    x1003 = 0.5 * x1002
    x1004 = x49 * (x332 + x341 * x918)
    x1005 = x409 * x918
    x1006 = x1005 * x5
    x1007 = x416 * x918
    x1008 = x403 * x953
    x1009 = x4 * (x414 * x918 - x423 * x918)
    x1010 = 0.5 * x1009
    x1011 = x1005 + x425 * x918
    x1012 = x60 * x953
    x1013 = x4 * (-x1012 * x404 + x405 * x5 * x918)
    x1014 = 0.5 * x1013
    x1015 = x276 + x454 * x918
    x1016 = x299 * x49 + x455 * x918
    x1017 = x1016 * x178
    x1018 = x266 + x447 * x918
    x1019 = x444 * x918
    x1020 = x1019 * x5 + x270 * x49
    x1021 = x1020 * x178
    x1022 = x285 + x460 * x918
    x1023 = x255 * x49
    x1024 = x1023 + x443 * x953
    x1025 = x1024 * x178
    x1026 = x4 * (x1015 - x1018 * x60)
    x1027 = 0.5 * x1026
    x1028 = x1019 + x294
    x1029 = x1028 * x49
    x1030 = x1024 * x3 + x1029
    x1031 = x4 * (x1016 - x1020 * x60)
    x1032 = 0.5 * x1031
    x1033 = x486 * x918 + x785
    x1034 = x333 + x487 * x918
    x1035 = x1034 * x178
    x1036 = x480 * x918 + x788
    x1037 = x120 * x997 + x330
    x1038 = x1037 * x178
    x1039 = x491 * x918 + x792
    x1040 = x321 + x345 * x930
    x1041 = x1040 * x178
    x1042 = x4 * (x1033 - x1036 * x60)
    x1043 = 0.5 * x1042
    x1044 = x478 * x918 + x796
    x1045 = x1044 * x49
    x1046 = x1040 * x3 + x1045
    x1047 = x4 * (x1034 - x1037 * x60)
    x1048 = 0.5 * x1047
    x1049 = x370 + x523 * x918
    x1050 = x107 * x393 + x525 * x918
    x1051 = x1050 * x49
    x1052 = x358 + x515 * x918
    x1053 = x511 * x918
    x1054 = x1053 * x5 + x107 * x361
    x1055 = x1054 * x49
    x1056 = x380 + x530 * x918
    x1057 = x1056 * x3
    x1058 = x107 * x343
    x1059 = x1058 + x532 * x918
    x1060 = x1059 * x49
    x1061 = 2.0 * x1060
    x1062 = x1052 * x60
    x1063 = x4 * (x1049 - x1062)
    x1064 = 0.5 * x1063
    x1065 = x1053 + 3.0 * x388
    x1066 = x1065 * x49
    x1067 = x1059 * x3
    x1068 = x1066 + x1067
    x1069 = x4 * (x1050 - x1054 * x60)
    x1070 = 0.5 * x1069
    x1071 = x564 * x918
    x1072 = x561 * x918
    x1073 = x4 * (x554 * x918 - x556 * x918)
    x1074 = 0.5 * x1073
    x1075 = x568 * x918
    x1076 = x4 * (-x1012 * x557 + x5 * x555 * x918)
    x1077 = 0.5 * x1076
    x1078 = x433 + x576 * x918
    x1079 = x1078 * x49
    x1080 = x416 * x49 + x585 * x918
    x1081 = x431 + x577 * x918
    x1082 = x1081 * x49
    x1083 = x579 * x918
    x1084 = x1083 * x5 + x410
    x1085 = x1083 + x409
    x1086 = x4 * (x1078 - x1081 * x60)
    x1087 = 0.5 * x1086
    x1088 = x1085 * x49
    x1089 = x422 * x49 + x588 * x953
    x1090 = x4 * (x1080 - x1084 * x60)
    x1091 = 0.5 * x1090
    x1092 = 2.0 * x469 + x593 * x918
    x1093 = x1092 * x49
    x1094 = x456 + x602 * x918
    x1095 = 2.0 * x467 + x594 * x918
    x1096 = x1095 * x49
    x1097 = x596 * x918
    x1098 = x1097 * x5 + x450
    x1099 = x1097 + x449
    x1100 = x4 * (x1092 - x1095 * x60)
    x1101 = 0.5 * x1100
    x1102 = x1099 * x49
    x1103 = x462 + x605 * x953
    x1104 = x4 * (x1094 - x1098 * x60)
    x1105 = 0.5 * x1104
    x1106 = x107 * x502 + x865 * x918
    x1107 = x1106 * x49
    x1108 = x1053 * x121 + x107 * x487
    x1109 = x1053 * x120 + 3.0 * x500
    x1110 = x1109 * x49
    x1111 = x1058 * x120 + x612 * x953
    x1112 = x107 * x478 + x612 * x918
    x1113 = x4 * (x1106 - x1109 * x60)
    x1114 = 0.5 * x1113
    x1115 = x1112 * x49
    x1116 = x107 * x492 + x527 * x930
    x1117 = x4 * (x1108 - x1111 * x60)
    x1118 = 0.5 * x1117
    x1119 = 4.0 * x543 + x623 * x918
    x1120 = x1119 * x49
    x1121 = x525 * x98 + x634 * x918
    x1122 = 4.0 * x540 + x624 * x918
    x1123 = x1122 * x49
    x1124 = x626 * x918
    x1125 = x1124 * x5 + 4.0 * x518
    x1126 = x1124 + 4.0 * x517
    x1127 = x4 * (x1119 - x1122 * x60)
    x1128 = 0.5 * x1127
    x1129 = x1126 * x49
    x1130 = x532 * x98 + x638 * x953
    x1131 = x1130 * x3
    x1132 = x1125 * x60
    x1133 = x4 * (x1121 - x1132)
    x1134 = 0.5 * x1133
    x1135 = x1129 * x3
    x1136 = x4 * (x645 * x918 - x647 * x918)
    x1137 = 0.5 * x1136
    x1138 = x564 + x655 * x918
    x1139 = x561 + x656 * x918
    x1140 = x1139 * x60
    x1141 = x568 + x658 * x918
    x1142 = x4 * (x1138 - x1140)
    x1143 = 0.5 * x1142
    x1144 = 2.0 * x584 + x663 * x918
    x1145 = 2.0 * x582 + x664 * x918
    x1146 = x1145 * x60
    x1147 = 2.0 * x587 + x666 * x918
    x1148 = x4 * (x1144 - x1146)
    x1149 = 0.5 * x1148
    x1150 = x671 * x918 + x898
    x1151 = x672 * x918 + x900
    x1152 = x1151 * x60
    x1153 = x674 * x918 + x903
    x1154 = x4 * (x1150 - x1152)
    x1155 = 0.5 * x1154
    x1156 = 4.0 * x616 + x683 * x918
    x1157 = x1124 * x120 + 4.0 * x614
    x1158 = x1157 * x60
    x1159 = x612 * x98 + x681 * x918
    x1160 = x4 * (x1156 - x1158)
    x1161 = 0.5 * x1160
    x1162 = 5.0 * x633 + x685 * x918
    x1163 = 5.0 * x630 + x686 * x918
    x1164 = x1163 * x60
    x1165 = 5.0 * x637 + x688 * x918
    x1166 = x1165 * x435
    x1167 = x4 * (x1162 - x1164)
    x1168 = 0.5 * x1167
    x1169 = x694**2
    x1170 = x1169 * x80
    x1171 = x1170 + x86
    x1172 = x1169 * x42
    x1173 = x1172 + x93
    x1174 = x1173 * x49
    x1175 = x116 + x1169 * x63 - x60 * (x1169 * x47 + x117)
    x1176 = x49 * (x104 + x1169 * x44)
    x1177 = x694 * x82
    x1178 = x1177 + x158 + x694 * x711
    x1179 = x694 * x88
    x1180 = x1179 + x164 + x694 * x713
    x1181 = x183 + x49 * x695 - x60 * (x184 + x57 * x694 + x694 * x708) + x694 * x705
    x1182 = x174 + x694 * x716 + x694 * x95
    x1183 = x1169 * x218 + x223
    x1184 = x1169 * x191 + x229
    x1185 = x1184 * x49
    x1186 = x1169 * x210 + x250 - x60 * (x1169 * x200 + x251)
    x1187 = x49 * (x1169 * x195 + x240)
    x1188 = x178 * x713 + x288 + x694 * x738
    x1189 = x178 * x716 + x293 + x694 * x741
    x1190 = x107 * x1189
    x1191 = x178 * x706 + x305 - x60 * (x178 * x709 + x306 + x694 * x733) + x694 * x728
    x1192 = x301 + x694 * x745 + x721
    x1193 = x220 * x694 + x320 + x694 * x753
    x1194 = x225 * x694 + x323 + x694 * x754
    x1195 = x338 + x49 * x722 - x60 * (x203 * x694 + x339 + x694 * x751) + x694 * x749
    x1196 = x178 * (x243 * x49 * x726 + x335 + x694 * x756)
    x1197 = x1169 * x377 + x382
    x1198 = x1169 * x349 + x387
    x1199 = x1198 * x49
    x1200 = x1169 * x362 + x401 - x60 * (x1169 * x350 + x402)
    x1201 = x49 * (x1169 * x343 + x395)
    x1202 = x424 + x694 * x775 + x742
    x1203 = x107 * x745 + x428 + x694 * x778
    x1204 = x441 - x60 * (x442 + x694 * x771 + x735) + x694 * x768 + x730
    x1205 = x49 * (x436 + x694 * x781 + 3.0 * x748)
    x1206 = x178 * x754 + x463 + x694 * x793
    x1207 = x465 + x694 * x794 + x757
    x1208 = x178 * x750 + x476 - x60 * (x178 * x752 + x477 + x694 * x789) + x694 * x786
    x1209 = x49 * (x471 + x694 * x797 + 2.0 * x761)
    x1210 = x379 * x694 + x494 + x694 * x807
    x1211 = x498 + x694 * x808 + x694 * x809
    x1212 = x1211 * x178
    x1213 = x49 * x762 + x508 - x60 * (x357 * x694 + x509 + x694 * x804) + x694 * x801
    x1214 = x49 * (x504 + x694 * x812 + x766)
    x1215 = x1169 * x530 + x534
    x1216 = x1169 * x532 + x537
    x1217 = x1216 * x49
    x1218 = x1169 * x523 + x552 - x60 * (x1169 * x515 + x553)
    x1219 = x49 * (x1169 * x511 + x545)
    x1220 = x559 + x694 * x834 + 4.0 * x782
    x1221 = x1220 * x49
    x1222 = x571 + x694 * x838 + x778 * x98
    x1223 = x574 - x60 * (x575 + x694 * x833 + x773 * x98) + x694 * x827 + x769 * x98
    x1224 = x580 + x694 * x848 + 3.0 * x798
    x1225 = x1224 * x49
    x1226 = x107 * x794 + x589 + x694 * x851
    x1227 = x107 * x787 + x591 - x60 * (x107 * x791 + x592 + x694 * x847) + x694 * x842
    x1228 = x597 + x694 * x860 + 2.0 * x813
    x1229 = x1228 * x49
    x1230 = x606 + x694 * x863 + x810
    x1231 = -x60 * (x609 + x694 * x859 + x806) + x608 + x694 * x855 + x803
    x1232 = x611 + x694 * x872 + x820
    x1233 = x1232 * x49
    x1234 = x49 * x818 + x619 + x694 * x875
    x1235 = x49 * x817 - x60 * (x622 + x694 * x871 + x816) + x620 + x694 * x868
    x1236 = x1169 * x626
    x1237 = x1236 + x628
    x1238 = x1237 * x49
    x1239 = x1169 * x5 * x638 + x640
    x1240 = x1169 * x634 - x60 * (x1236 * x5 + x644) + x643
    x1241 = x651 + x694 * x891 + 5.0 * x836
    x1242 = -x60 * (x654 + x694 * x887 + 5.0 * x829) + x653 + x694 * x884 + 5.0 * x825
    x1243 = x659 + x694 * x896 + 4.0 * x850
    x1244 = -x60 * (x662 + x694 * x894 + 4.0 * x844) + x661 + x694 * x893 + 4.0 * x841
    x1245 = x667 + x694 * x904 + 3.0 * x862
    x1246 = -x60 * (x670 + x694 * x901 + 3.0 * x857) + x669 + x694 * x899 + 3.0 * x854
    x1247 = x675 + x694 * x909 + 2.0 * x874
    x1248 = -x60 * (x678 + x694 * x907 + 2.0 * x870) + x677 + x694 * x906 + 2.0 * x867
    x1249 = x680 + x694 * x914 + x880
    x1250 = -x60 * (x684 + x694 * x912 + x878) + x682 + x694 * x911 + x877
    x1251 = x1169 * x688 + x690
    x1252 = x1169 * x685 - x60 * (x1169 * x686 + x693) + x692
    x1253 = x4 * (x63 * x694 * x918 - x698 * x918)
    x1254 = x82 * x918
    x1255 = x1254 + x710 * x918
    x1256 = x88 * x918
    x1257 = x1256 + x712 * x918
    x1258 = x72 * x918
    x1259 = x57 * x918
    x1260 = x4 * (x1258 - x60 * (x1259 + x707 * x918) + x704 * x918)
    x1261 = x918 * x95
    x1262 = x1261 + x715 * x918
    x1263 = x4 * (x694 * x932 - x694 * x943)
    x1264 = x736 * x918 + x737 * x918
    x1265 = x739 * x918 + x740 * x918
    x1266 = x107 * x1265
    x1267 = x4 * (x178 * x924 - x60 * (x731 * x918 + x732 * x918) + x727 * x918)
    x1268 = x744 * x918 + x931
    x1269 = x694 * x970 + x941
    x1270 = x694 * x971 + x948
    x1271 = x4 * (-x60 * (x694 * x968 + x937) + x694 * x966 + x934)
    x1272 = x178 * (x694 * x974 + x954)
    x1273 = x4 * (x694 * x980 - x694 * x993)
    x1274 = x774 * x918 + x959
    x1275 = x776 * x918 + x777 * x918
    x1276 = x4 * (-x60 * (x770 * x918 + x956) + x767 * x918 + x958)
    x1277 = x49 * (x772 * x918 + x780 * x918)
    x1278 = x178 * x971
    x1279 = x1022 * x694 + x1278
    x1280 = x1024 * x694 + x975
    x1281 = x178 * x967
    x1282 = x178 * x969
    x1283 = x4 * (x1015 * x694 + x1281 - x60 * (x1018 * x694 + x1282))
    x1284 = 2.0 * x979
    x1285 = x49 * (x1028 * x694 + x1284)
    x1286 = x1039 * x694 + x991
    x1287 = x1040 * x694 + x999
    x1288 = x1287 * x178
    x1289 = x4 * (x1033 * x694 - x60 * (x1036 * x694 + x986) + x982)
    x1290 = x49 * (x1004 + x1044 * x694)
    x1291 = x4 * (x1049 * x694 - x1062 * x694)
    x1292 = x1066 * x694
    x1293 = x830 * x918 + x832 * x918
    x1294 = x1293 * x49
    x1295 = x1008 * x98 + x837 * x918
    x1296 = x4 * (x1007 * x98 - x60 * (x831 * x918 + x832 * x953) + x826 * x918)
    x1297 = 3.0 * x1029 + x1085 * x694
    x1298 = x1297 * x49
    x1299 = x1024 * x107 + x1089 * x694
    x1300 = x4 * (x1016 * x107 + x1080 * x694 - x60 * (x1020 * x107 + x1084 * x694))
    x1301 = 2.0 * x1045 + x1099 * x694
    x1302 = x1301 * x49
    x1303 = x1041 + x1103 * x694
    x1304 = x4 * (x1035 + x1094 * x694 - x60 * (x1038 + x1098 * x694))
    x1305 = x1066 + x1112 * x694
    x1306 = x1305 * x49
    x1307 = x1060 + x1116 * x694
    x1308 = x4 * (x1051 + x1108 * x694 - x60 * (x1055 + x1111 * x694))
    x1309 = x1129 * x694
    x1310 = x4 * (x1121 * x694 - x1132 * x694)
    x1311 = x889 * x918 + x890 * x918
    x1312 = x4 * (-x60 * (x885 * x918 + x886 * x918) + x882 * x918 + x883 * x918)
    x1313 = 4.0 * x1088 + x1141 * x694
    x1314 = x4 * (4.0 * x1079 + x1138 * x694 - x60 * (4.0 * x1082 + x1139 * x694))
    x1315 = 3.0 * x1102
    x1316 = x1147 * x694 + x1315
    x1317 = 3.0 * x1093
    x1318 = 3.0 * x1096
    x1319 = x4 * (x1144 * x694 + x1317 - x60 * (x1145 * x694 + x1318))
    x1320 = 2.0 * x1115 + x1153 * x694
    x1321 = x4 * (2.0 * x1107 + x1150 * x694 - x60 * (2.0 * x1110 + x1151 * x694))
    x1322 = x1129 + x1159 * x694
    x1323 = x4 * (x1120 + x1156 * x694 - x60 * (x1123 + x1157 * x694))
    x1324 = x4 * (x1162 * x694 - x1164 * x694)
    x1325 = x918**2
    x1326 = x1325 * x80 + x86
    x1327 = x1326 * x3
    x1328 = x1325 * x42 + x93
    x1329 = x1328 * x49
    x1330 = 5.0 * x1329
    x1331 = x116 + x1325 * x63 - x60 * (x117 + x1325 * x47)
    x1332 = x1331 * x85
    x1333 = x49 * (x104 + x1325 * x44)
    x1334 = x1325 * x153 + x158
    x1335 = x126 * x1325 + x164
    x1336 = x1335 * x49
    x1337 = x1325 * x145 + x183 - x60 * (x1325 * x135 + x184)
    x1338 = x1337 * x85
    x1339 = x49 * (x130 * x1325 + x174)
    x1340 = x1254 + x223 + x918 * x938
    x1341 = x1340 * x3
    x1342 = x1256 + x229 + x918 * x940
    x1343 = x1342 * x49
    x1344 = 4.0 * x1343
    x1345 = x1258 + x250 - x60 * (x1259 + x251 + x918 * x935) + x918 * x932
    x1346 = x1345 * x85
    x1347 = x49 * (x1261 + x240 + x918 * x947)
    x1348 = x1325 * x283 + x288
    x1349 = x1325 * x260 + x293
    x1350 = x1349 * x49
    x1351 = 3.0 * x1350
    x1352 = x1325 * x271 + x305 - x60 * (x1325 * x261 + x306)
    x1353 = x1352 * x85
    x1354 = x49 * (x1325 * x255 + x301)
    x1355 = x155 * x918 + x320 + x918 * x970
    x1356 = x160 * x918 + x323 + x918 * x971
    x1357 = x338 + x49 * x924 - x60 * (x138 * x918 + x339 + x918 * x968) + x918 * x966
    x1358 = x1357 * x85
    x1359 = x178 * (x335 + x38 * x49 * x930 + x918 * x974)
    x1360 = x382 + x918 * x988 + 2.0 * x941
    x1361 = x1360 * x3
    x1362 = x387 + x918 * x990 + 2.0 * x948
    x1363 = x1362 * x49
    x1364 = 3.0 * x1363
    x1365 = x401 - x60 * (x402 + x918 * x984 + 2.0 * x937) + x918 * x980 + 2.0 * x934
    x1366 = x1365 * x85
    x1367 = x49 * (x395 + x918 * x998 + x955)
    x1368 = x1325 * x420 + x424
    x1369 = x1325 * x422 + x428
    x1370 = x1369 * x49
    x1371 = x1325 * x414 + x441 - x60 * (x1325 * x407 + x442)
    x1372 = x1371 * x85
    x1373 = x49 * (x1325 * x404 + x436)
    x1374 = x1022 * x918 + x285 * x918 + x463
    x1375 = x1023 * x918 + x1024 * x918 + x465
    x1376 = x1375 * x178
    x1377 = x1015 * x918 + x476 + x49 * x957 - x60 * (x1018 * x918 + x266 * x918 + x477)
    x1378 = x1377 * x85
    x1379 = x49 * (x1028 * x918 + x471 + x965)
    x1380 = x1039 * x918 + x1278 + x494
    x1381 = x1040 * x918 + x498 + x975
    x1382 = x1381 * x178
    x1383 = x1033 * x918 + x1281 + x508 - x60 * (x1036 * x918 + x1282 + x509)
    x1384 = x1383 * x85
    x1385 = x49 * (x1044 * x918 + x1284 + x504)
    x1386 = x1056 * x918 + x534 + x992
    x1387 = x1386 * x3
    x1388 = x1059 * x918 + x537 + 3.0 * x999
    x1389 = x1388 * x49
    x1390 = 2.0 * x1389
    x1391 = x1049 * x918 + x552 - x60 * (x1052 * x918 + x553 + x987) + x983
    x1392 = x1391 * x85
    x1393 = x49 * (3.0 * x1004 + x1065 * x918 + x545)
    x1394 = x1325 * x557
    x1395 = x1394 + x559
    x1396 = x1395 * x49
    x1397 = x1325 * x5 * x569 + x571
    x1398 = x1325 * x565 + x574 - x60 * (x1394 * x5 + x575)
    x1399 = x1398 * x85
    x1400 = x1005 + x1085 * x918 + x580
    x1401 = x1400 * x49
    x1402 = x1008 * x49 + x1089 * x918 + x589
    x1403 = x1007 * x49 + x1080 * x918 + x591 - x60 * (x1006 + x1084 * x918 + x592)
    x1404 = x1403 * x85
    x1405 = 2.0 * x1029 + x1099 * x918 + x597
    x1406 = x1405 * x49
    x1407 = x1025 + x1103 * x918 + x606
    x1408 = x1017 + x1094 * x918 - x60 * (x1021 + x1098 * x918 + x609) + x608
    x1409 = x1408 * x85
    x1410 = 3.0 * x1045 + x1112 * x918 + x611
    x1411 = x1410 * x49
    x1412 = x1040 * x107 + x1116 * x918 + x619
    x1413 = (
        x1034 * x107 + x1108 * x918 - x60 * (x1037 * x107 + x1111 * x918 + x622) + x620
    )
    x1414 = x1413 * x85
    x1415 = 4.0 * x1066 + x1126 * x918 + x628
    x1416 = x1415 * x49
    x1417 = 4.0 * x1060 + x1130 * x918 + x640
    x1418 = x1417 * x3
    x1419 = 4.0 * x1051 + x1121 * x918 - x60 * (4.0 * x1055 + x1125 * x918 + x644) + x643
    x1420 = x1419 * x85
    x1421 = x1325 * x649 + x651
    x1422 = x1325 * x645 - x60 * (x1325 * x646 + x654) + x653
    x1423 = x1422 * x85
    x1424 = x1075 + x1141 * x918 + x659
    x1425 = x1071 + x1138 * x918 - x60 * (x1072 + x1139 * x918 + x662) + x661
    x1426 = x1425 * x85
    x1427 = 2.0 * x1088 + x1147 * x918 + x667
    x1428 = 2.0 * x1079 + x1144 * x918 - x60 * (2.0 * x1082 + x1145 * x918 + x670) + x669
    x1429 = x1428 * x85
    x1430 = x1153 * x918 + x1315 + x675
    x1431 = x1150 * x918 + x1317 - x60 * (x1151 * x918 + x1318 + x678) + x677
    x1432 = x1431 * x85
    x1433 = 4.0 * x1115 + x1159 * x918 + x680
    x1434 = 4.0 * x1107 + x1156 * x918 - x60 * (4.0 * x1110 + x1157 * x918 + x684) + x682
    x1435 = x1434 * x85
    x1436 = 5.0 * x1129 + x1165 * x918 + x690
    x1437 = 5.0 * x1120 + x1162 * x918 - x60 * (5.0 * x1123 + x1163 * x918 + x693) + x692
    x1438 = x1437 * x85
    x1439 = x1171 * x694 + x699
    x1440 = x49 * (x1173 * x694 + x703)
    x1441 = x1174 + x1178 * x694 + x714
    x1442 = x1176 + x1180 * x694 + x718
    x1443 = x1183 * x694 + x723
    x1444 = x49 * (x1184 * x694 + x725)
    x1445 = x1180 * x178 + x1188 * x694 + x743
    x1446 = x107 * (x1182 * x178 + x1189 * x694 + x747)
    x1447 = x1185 + x1193 * x694 + x755
    x1448 = x1187 + x1194 * x694 + x759
    x1449 = x1197 * x694 + x763
    x1450 = x49 * (x1198 * x694 + x765)
    x1451 = x1190 + x1202 * x694 + x779
    x1452 = x107 * x1192 + x1203 * x694 + x784
    x1453 = x1194 * x178 + x1206 * x694 + x795
    x1454 = x1196 + x1207 * x694 + x800
    x1455 = x1199 + x1210 * x694 + x811
    x1456 = x178 * (x1201 + x1211 * x694 + x815)
    x1457 = x1215 * x694 + x819
    x1458 = x49 * (x1216 * x694 + x823)
    x1459 = x49 * (4.0 * x1205 + x1220 * x694 + x835)
    x1460 = x1203 * x98 + x1222 * x694 + x839
    x1461 = x49 * (3.0 * x1209 + x1224 * x694 + x849)
    x1462 = x107 * x1207 + x1226 * x694 + x852
    x1463 = x49 * (2.0 * x1214 + x1228 * x694 + x861)
    x1464 = x1212 + x1230 * x694 + x864
    x1465 = x49 * (x1219 + x1232 * x694 + x873)
    x1466 = x1217 + x1234 * x694 + x876
    x1467 = x49 * (x1237 * x694 + x879)
    x1468 = x1239 * x694 + x881
    x1469 = 5.0 * x1221 + x1241 * x694 + x892
    x1470 = 4.0 * x1225 + x1243 * x694 + x897
    x1471 = 3.0 * x1229 + x1245 * x694 + x905
    x1472 = 2.0 * x1233 + x1247 * x694 + x910
    x1473 = x1238 + x1249 * x694 + x915
    x1474 = x1251 * x694 + x917
    x1475 = x1170 * x918 + x920
    x1476 = x49 * (x1172 * x918 + x923)
    x1477 = x1177 * x918 + x1255 * x694 + x926
    x1478 = x1179 * x918 + x1257 * x694 + x929
    x1479 = x1169 * x938 + x945
    x1480 = x49 * (x1169 * x940 + x952)
    x1481 = x1257 * x178 + x1264 * x694 + x961
    x1482 = x107 * (x1262 * x178 + x1265 * x694 + x964)
    x1483 = x1269 * x694 + x694 * x941 + x973
    x1484 = x1270 * x694 + x694 * x948 + x978
    x1485 = x1169 * x988 + x995
    x1486 = x49 * (x1003 + x1169 * x990)
    x1487 = x1010 + x1266 + x1274 * x694
    x1488 = x1014 + x107 * x1268 + x1275 * x694
    x1489 = x1027 + x1270 * x178 + x1279 * x694
    x1490 = x1032 + x1272 + x1280 * x694
    x1491 = x1043 + x1286 * x694 + x694 * x991
    x1492 = x178 * (x1048 + x1287 * x694 + x694 * x999)
    x1493 = x1056 * x1169 + x1064
    x1494 = x49 * (x1059 * x1169 + x1070)
    x1495 = x49 * (x1074 + 4.0 * x1277 + x1293 * x694)
    x1496 = x1077 + x1275 * x98 + x1295 * x694
    x1497 = x49 * (x1087 + 3.0 * x1285 + x1297 * x694)
    x1498 = x107 * x1280 + x1091 + x1299 * x694
    x1499 = x49 * (x1101 + 2.0 * x1290 + x1301 * x694)
    x1500 = x1105 + x1288 + x1303 * x694
    x1501 = x49 * (x1114 + x1292 + x1305 * x694)
    x1502 = x1060 * x694 + x1118 + x1307 * x694
    x1503 = x49 * (x1126 * x1169 + x1128)
    x1504 = x1130 * x1169 + x1134
    x1505 = x1137 + 5.0 * x1294 + x1311 * x694
    x1506 = x1143 + 4.0 * x1298 + x1313 * x694
    x1507 = x1149 + 3.0 * x1302 + x1316 * x694
    x1508 = x1155 + 2.0 * x1306 + x1320 * x694
    x1509 = x1161 + x1309 + x1322 * x694
    x1510 = x1165 * x1169 + x1168
    x1511 = x1329 + x1334 * x694
    x1512 = x1333 + x1335 * x694
    x1513 = 2.0 * x1336 + x1348 * x694
    x1514 = x107 * (2.0 * x1339 + x1349 * x694)
    x1515 = x1343 + x1355 * x694
    x1516 = x1347 + x1356 * x694
    x1517 = x1351 + x1368 * x694
    x1518 = 3.0 * x1354 + x1369 * x694
    x1519 = x1356 * x178
    x1520 = x1374 * x694 + x1519
    x1521 = x1359 + x1375 * x694
    x1522 = x1363 + x1380 * x694
    x1523 = x178 * (x1367 + x1381 * x694)
    x1524 = x49 * (4.0 * x1373 + x1395 * x694)
    x1525 = 4.0 * x1370 + x1397 * x694
    x1526 = x49 * (3.0 * x1379 + x1400 * x694)
    x1527 = x107 * x1375 + x1402 * x694
    x1528 = x49 * (2.0 * x1385 + x1405 * x694)
    x1529 = x1382 + x1407 * x694
    x1530 = x49 * (x1393 + x1410 * x694)
    x1531 = x1389 + x1412 * x694
    x1532 = x1416 * x694
    x1533 = 5.0 * x1396 + x1421 * x694
    x1534 = 4.0 * x1401 + x1424 * x694
    x1535 = 3.0 * x1406
    x1536 = x1427 * x694 + x1535
    x1537 = 2.0 * x1411 + x1430 * x694
    x1538 = x1416 + x1433 * x694
    x1539 = x1326 * x918 + x919
    x1540 = x49 * (x1328 * x918 + x922)
    x1541 = x1334 * x918 + x925
    x1542 = x49 * (x1335 * x918 + x928)
    x1543 = x1329 + x1340 * x918 + x944
    x1544 = x49 * (x1333 + x1342 * x918 + x951)
    x1545 = x1348 * x918 + x960
    x1546 = x49 * (x1349 * x918 + x963)
    x1547 = 3.0 * x1546
    x1548 = x1336 + x1355 * x918 + x972
    x1549 = x1339 + x1356 * x918 + x977
    x1550 = 2.0 * x1343 + x1360 * x918 + x994
    x1551 = x49 * (x1002 + 2.0 * x1347 + x1362 * x918)
    x1552 = 3.0 * x1551
    x1553 = x1009 + x1368 * x918
    x1554 = x49 * (x1013 + x1369 * x918)
    x1555 = x1026 + x1350 + x1374 * x918
    x1556 = x1031 + x1354 + x1375 * x918
    x1557 = x1556 * x178
    x1558 = x1042 + x1380 * x918 + x1519
    x1559 = x1047 + x1359 + x1381 * x918
    x1560 = x1559 * x178
    x1561 = x1063 + x1364 + x1386 * x918
    x1562 = x49 * (x1069 + 3.0 * x1367 + x1388 * x918)
    x1563 = x49 * (x1073 + x1395 * x918)
    x1564 = x1076 + x1397 * x918
    x1565 = x49 * (x1086 + x1373 + x1400 * x918)
    x1566 = x1090 + x1370 + x1402 * x918
    x1567 = x49 * (x1100 + 2.0 * x1379 + x1405 * x918)
    x1568 = x1104 + x1376 + x1407 * x918
    x1569 = x49 * (x1113 + 3.0 * x1385 + x1410 * x918)
    x1570 = x107 * x1381 + x1117 + x1412 * x918
    x1571 = x49 * (x1127 + 4.0 * x1393 + x1415 * x918)
    x1572 = x1133 + 4.0 * x1389 + x1417 * x918
    x1573 = x1136 + x1421 * x918
    x1574 = x1142 + x1396 + x1424 * x918
    x1575 = x1148 + 2.0 * x1401 + x1427 * x918
    x1576 = x1154 + x1430 * x918 + x1535
    x1577 = x1160 + 4.0 * x1411 + x1433 * x918
    x1578 = x1167 + 5.0 * x1416 + x1436 * x918
    x1579 = x1549 * x178
    x1580 = 3.0 * x1567

    # 315 item(s)
    return numpy.array(
        [
            x118 * (x103 * x91 + x116 + x3 * x74 - x60 * (x101 * x91 + x117 + x3 * x59))
            + x3
            * (
                x3 * (x3 * (x81 + x83) + x86 + x90 * x91)
                + x4 * (-x59 * x60 + x74)
                + x91 * x99
            )
            + x91
            * (
                x3 * x99
                + x4 * (-x101 * x60 + x103)
                + x98 * (x104 + x107 * (x106 * x5 + x3 * x40) + x3 * x97)
            ),
            x118 * (x149 * x3 + x173 * x98 + x183 - x60 * (x140 * x3 + x171 * x98 + x184))
            + x3
            * (
                x169 * x98
                + x3 * (x158 + x162 * x98 + x3 * (x154 + x156))
                + x4 * (-x140 * x60 + x149)
            )
            + x98
            * (
                x107 * (x168 * x3 + x174 + x178 * (x175 + x177 * x38))
                + x169 * x3
                + x4 * (-x171 * x60 + x173)
            ),
            x118 * (x214 * x3 + x239 * x98 + x250 - x60 * (x205 * x3 + x237 * x98 + x251))
            + x3
            * (
                x235 * x98
                + x3 * (x223 + x227 * x98 + x3 * (x219 + x221))
                + x4 * (-x205 * x60 + x214)
            )
            + x98
            * (
                x107 * (x178 * (x176 * x243 + x242) + x234 * x3 + x240)
                + x235 * x3
                + x4 * (-x237 * x60 + x239)
            ),
            x107
            * (
                x178 * (x294 * x3 + x296 * x3 + x301)
                + x297 * x3
                + x4 * (-x298 * x60 + x300)
            )
            + x118
            * (x107 * x300 + x278 * x3 + x305 - x60 * (x107 * x298 + x268 * x3 + x306))
            + x3
            * (
                x107 * x297
                + x3 * (x107 * x291 + x288 + x3 * (x284 + x286))
                + x4 * (-x268 * x60 + x278)
            ),
            x107
            * (
                x178 * (x3 * x325 + x3 * x327 + x335)
                + x3 * x328
                + x4 * (-x331 * x60 + x334)
            )
            + x118
            * (x107 * x334 + x3 * x317 + x338 - x60 * (x107 * x331 + x3 * x312 + x339))
            + x3
            * (
                x107 * x328
                + x3 * (x107 * x322 + x3 * (x107 * x308 + x3 * x319) + x320)
                + x4 * (-x312 * x60 + x317)
            ),
            x107
            * (
                x178 * (x3 * x388 + x3 * x390 + x395)
                + x3 * x391
                + x4 * (-x392 * x60 + x394)
            )
            + x118
            * (x107 * x394 + x3 * x371 + x401 - x60 * (x107 * x392 + x3 * x359 + x402))
            + x3
            * (
                x107 * x391
                + x3 * (x107 * x385 + x3 * (x378 + x380) + x382)
                + x4 * (-x359 * x60 + x371)
            ),
            x118
            * (x178 * x434 + x3 * x417 + x441 - x60 * (x178 * x432 + x3 * x411 + x442))
            + x178 * (x3 * x430 + x4 * (-x432 * x60 + x434) + x49 * (x404 * x435 + x436))
            + x3
            * (
                x178 * x430
                + x3 * (x178 * x426 + x3 * (x178 * x422 + x421) + x424)
                + x4 * (-x411 * x60 + x417)
            ),
            x118
            * (x178 * x470 + x3 * x457 + x476 - x60 * (x178 * x468 + x3 * x451 + x477))
            + x178 * (x3 * x466 + x4 * (-x468 * x60 + x470) + x49 * (x435 * x444 + x471))
            + x3
            * (
                x178 * x466
                + x3 * (x178 * x464 + x3 * (x3 * x460 + x462) + x463)
                + x4 * (-x451 * x60 + x457)
            ),
            x118
            * (x178 * x503 + x3 * x489 + x508 - x60 * (x178 * x501 + x3 * x482 + x509))
            + x178 * (x3 * x499 + x4 * (-x501 * x60 + x503) + x49 * (x435 * x478 + x504))
            + x3
            * (
                x178 * x499
                + x3 * (x178 * x496 + x3 * (x3 * x491 + x493) + x494)
                + x4 * (-x482 * x60 + x489)
            ),
            x118
            * (x178 * x544 + x3 * x526 + x552 - x60 * (x178 * x542 + x3 * x519 + x553))
            + x178 * (x3 * x539 + x4 * (-x542 * x60 + x544) + x49 * (x435 * x511 + x545))
            + x3
            * (
                x178 * x539
                + x3 * (x178 * x536 + x3 * (x178 * x532 + x531) + x534)
                + x4 * (-x519 * x60 + x526)
            ),
            x118
            * (x3 * x49 * x554 + x3 * x567 + x574 - x60 * (x3 * x561 + x3 * x563 + x575))
            + x3
            * (
                x3 * (x3 * (x568 + x570) + x571 + x572)
                + x4 * (-x563 * x60 + x567)
                + x49 * x560
            )
            + x49 * (x3 * x560 + x4 * (x3 * x554 - x3 * x556)),
            x118
            * (x3 * x49 * x576 + x3 * x586 + x591 - x60 * (x3 * x582 + x3 * x583 + x592))
            + x3
            * (
                x3 * (x3 * x587 + x3 * (x176 * x588 + x587) + x589)
                + x4 * (-x583 * x60 + x586)
                + x49 * x581
            )
            + x49 * (x3 * x581 + x4 * (x3 * x576 - x3 * x578)),
            x118
            * (x3 * x49 * x593 + x3 * x603 - x60 * (x3 * x599 + x3 * x600 + x609) + x608)
            + x3
            * (
                x3 * (x3 * x604 + x3 * (x176 * x605 + x604) + x606)
                + x4 * (-x60 * x600 + x603)
                + x49 * x598
            )
            + x49 * (x3 * x598 + x4 * (x3 * x593 - x3 * x595)),
            x118 * (x3 * x616 + x3 * x617 - x60 * (x120 * x538 + x3 * x615 + x622) + x620)
            + x3
            * (
                x3 * (x3 * x618 + x3 * (x177 * x527 + x618) + x619)
                + x4 * (-x60 * x615 + x617)
                + x49 * x613
            )
            + x49 * (x3 * x613 + x4 * (x120 * x3 * x512 - x3 * x610)),
            x118
            * (x3 * x49 * x623 + x3 * x636 - x60 * (x3 * x630 + x3 * x632 + x644) + x643)
            + x3
            * (
                x3 * (x3 * (x637 + x639) + x640 + x641)
                + x4 * (-x60 * x632 + x636)
                + x49 * x629
            )
            + x49 * (x3 * x629 + x4 * (x3 * x623 - x3 * x625)),
            x118 * (x435 * x645 - x60 * (x435 * x646 + x654) + x653)
            + x3 * (x3 * (x650 + x651) + x4 * (x3 * x645 - x648)),
            x118 * (x435 * x655 - x60 * (x435 * x656 + x662) + x661)
            + x3 * (x3 * (x435 * x658 + x659) + x4 * (x3 * x655 - x3 * x657)),
            x118 * (x435 * x663 - x60 * (x435 * x664 + x670) + x669)
            + x3 * (x3 * (x435 * x666 + x667) + x4 * (x3 * x663 - x3 * x665)),
            x118 * (x435 * x671 - x60 * (x435 * x672 + x678) + x677)
            + x3 * (x3 * (x435 * x674 + x675) + x4 * (x3 * x671 - x3 * x673)),
            x118 * (x435 * x683 - x60 * (x120 * x627 + x684) + x682)
            + x3 * (x3 * (x435 * x681 + x680) + x4 * (x120 * x3 * x624 - x3 * x679)),
            x118 * (x435 * x685 - x60 * (x435 * x686 + x693) + x692)
            + x3 * (x3 * (x689 + x690) + x4 * (x3 * x685 - x3 * x687)),
            x3 * (x3 * (x696 + x697) + 0.5 * x699 + x702 * x91)
            + x4 * (-x60 * (x48 * x694 + x58 * x694) + x64 * x694 + x695 * x91)
            + x91 * (x3 * x702 + 0.5 * x703 + x98 * (x694 * x94 + x694 * x96)),
            x3 * (x3 * (x3 * x711 + x713 * x98) + 0.5 * x714 + x717 * x98)
            + x4 * (x3 * x705 - x60 * (x3 * x708 + x709 * x98) + x706 * x98)
            + x98 * (x107 * (x3 * x716 + x721) + x3 * x717 + 0.5 * x718),
            x3 * (x3 * (x219 * x694 + x221 * x694) + 0.5 * x723 + x724 * x98)
            + x4 * (x211 * x694 - x60 * (x201 * x694 + x204 * x694) + x722 * x98)
            + x98 * (x107 * (x230 * x694 + x232 * x726) + x3 * x724 + 0.5 * x725),
            x107 * (x178 * (x3 * x745 + x748) + x3 * x746 + 0.5 * x747)
            + x3 * (x107 * x746 + x3 * (x3 * x738 + x742) + 0.5 * x743)
            + x4 * (x3 * x728 - x60 * (x3 * x733 + x735) + x730),
            x107 * (x178 * (x3 * x756 + x761) + x3 * x758 + 0.5 * x759)
            + x3 * (x107 * x758 + x3 * (x107 * x754 + x3 * x753) + 0.5 * x755)
            + x4 * (x107 * x750 + x3 * x749 - x60 * (x107 * x752 + x3 * x751)),
            x107 * (x178 * (x389 * x694 + x766) + x3 * x764 + 0.5 * x765)
            + x3 * (x107 * x764 + x3 * (x378 * x694 + x380 * x694) + 0.5 * x763)
            + x4 * (x107 * x762 + x363 * x694 - x60 * (x351 * x694 + x358 * x694)),
            x178 * (x3 * x782 + x3 * x783 + 0.5 * x784)
            + x3 * (x178 * x783 + x3 * (x178 * x778 + x3 * x775) + 0.5 * x779)
            + x4 * (x178 * x769 + x3 * x768 - x60 * (x178 * x773 + x3 * x771)),
            x178 * (x3 * x798 + x3 * x799 + 0.5 * x800)
            + x3 * (x178 * x799 + x3 * (x178 * x794 + x3 * x793) + 0.5 * x795)
            + x4 * (x178 * x787 + x3 * x786 - x60 * (x178 * x791 + x3 * x789)),
            x178 * (x3 * x813 + x3 * x814 + 0.5 * x815)
            + x3 * (x178 * x814 + x3 * (x3 * x807 + x810) + 0.5 * x811)
            + x4 * (x3 * x801 - x60 * (x3 * x804 + x806) + x803),
            x178 * (x3 * x821 + x538 * x694 + 0.5 * x823)
            + x3 * (x178 * x821 + x3 * (x178 * x818 + x531 * x694) + 0.5 * x819)
            + x4 * (x178 * x817 + x524 * x694 - x60 * (x516 * x694 + 2.0 * x816)),
            x3 * (x3 * x836 + x3 * (x3 * x838 + x836) + 0.5 * x839)
            + x4 * (x3 * x827 - x60 * (x3 * x833 + x829) + x825)
            + x49 * (x435 * x834 + 0.5 * x835),
            x3 * (x3 * x850 + x3 * (x3 * x851 + x850) + 0.5 * x852)
            + x4 * (x3 * x842 - x60 * (x3 * x847 + x844) + x841)
            + x49 * (x435 * x848 + 0.5 * x849),
            x3 * (x3 * x862 + x3 * (x3 * x863 + x862) + 0.5 * x864)
            + x4 * (x3 * x855 - x60 * (x3 * x859 + x857) + x854)
            + x49 * (x435 * x860 + 0.5 * x861),
            x3 * (x3 * x874 + x3 * (x3 * x875 + x874) + 0.5 * x876)
            + x4 * (x3 * x868 - x60 * (x3 * x871 + x870) + x867)
            + x49 * (x435 * x872 + 0.5 * x873),
            x3 * (x3 * (x639 * x694 + x880) + x641 * x694 + 0.5 * x881)
            + x4 * (-x60 * (x631 * x694 + x878) + x635 * x694 + x877)
            + x49 * (x627 * x694 + 0.5 * x879),
            x3 * (x435 * x891 + 0.5 * x892) + x4 * (x3 * x884 - x3 * x888),
            x3 * (x435 * x896 + 0.5 * x897) + x4 * (x3 * x893 - x3 * x895),
            x3 * (x435 * x904 + 0.5 * x905) + x4 * (x3 * x899 - x3 * x902),
            x3 * (x435 * x909 + 0.5 * x910) + x4 * (x3 * x906 - x3 * x908),
            x3 * (x435 * x914 + 0.5 * x915) + x4 * (x3 * x911 - x3 * x913),
            x3 * (x689 * x694 + 0.5 * x917) + x4 * (x3 * x685 * x694 - x687 * x916),
            x3 * (x3 * (x81 * x918 + x83 * x918) + x91 * x921 + x920)
            + x4 * (-x60 * (x48 * x918 + x58 * x918) + x64 * x918 + x73 * x918)
            + x91 * (x3 * x921 + x923 + x98 * (x918 * x94 + x918 * x96)),
            x3 * (x3 * (x154 * x918 + x156 * x918) + x926 + x927 * x98)
            + x4 * (x146 * x918 - x60 * (x136 * x918 + x139 * x918) + x924 * x98)
            + x98 * (x107 * (x165 * x918 + x931) + x3 * x927 + x929),
            x3 * (x3 * (x939 + x942) + x945 + x950 * x98)
            + x4 * (x3 * x932 - x60 * (x3 * x935 + 4.0 * x937) + 4.0 * x934)
            + x98 * (x107 * (x3 * x947 + x955) + x3 * x950 + x952),
            x107 * (x178 * (x295 * x918 + x965) + x3 * x962 + x964)
            + x3 * (x107 * x962 + x3 * (x284 * x918 + x959) + x961)
            + x4 * (x272 * x918 - x60 * (x262 * x918 + x956) + x958),
            x107 * (x178 * (x3 * x974 + x979) + x3 * x976 + x978)
            + x3 * (x107 * x976 + x3 * (x107 * x971 + x3 * x970) + x973)
            + x4 * (x107 * x967 + x3 * x966 - x60 * (x107 * x969 + x3 * x968)),
            x107 * (x1001 * x3 + x1003 + x178 * (x1004 + x3 * x998))
            + x3 * (x1001 * x107 + x3 * (x989 + x992) + x995)
            + x4 * (x3 * x980 - x60 * (x3 * x984 + x987) + x983),
            x178 * (x1011 * x3 + x1014 + x429 * x918)
            + x3 * (x1010 + x1011 * x178 + x3 * (x1008 * x178 + x421 * x918))
            + x4 * (x1007 * x178 + x415 * x918 - x60 * (2.0 * x1006 + x408 * x918)),
            x178 * (x1029 * x3 + x1030 * x3 + x1032)
            + x3 * (x1027 + x1030 * x178 + x3 * (x1022 * x3 + x1025))
            + x4 * (x1015 * x3 + x1017 - x60 * (x1018 * x3 + x1021)),
            x178 * (x1045 * x3 + x1046 * x3 + x1048)
            + x3 * (x1043 + x1046 * x178 + x3 * (x1039 * x3 + x1041))
            + x4 * (x1033 * x3 + x1035 - x60 * (x1036 * x3 + x1038)),
            x178 * (x1066 * x3 + x1068 * x3 + x1070)
            + x3 * (x1064 + x1068 * x178 + x3 * (x1057 + x1061))
            + x4 * (x1049 * x3 + 2.0 * x1051 - x60 * (x1052 * x3 + 2.0 * x1055)),
            x3 * (x1077 + x3 * (x1075 + x570 * x918) + x572 * x918)
            + x4 * (x1071 + x566 * x918 - x60 * (x1072 + x562 * x918))
            + x49 * (x1074 + x558 * x918),
            x3 * (x1088 * x3 + x1091 + x3 * (x1088 + x1089 * x3))
            + x4 * (x1079 + x1080 * x3 - x60 * (x1082 + x1084 * x3))
            + x49 * (x1085 * x435 + x1087),
            x3 * (x1102 * x3 + x1105 + x3 * (x1102 + x1103 * x3))
            + x4 * (x1093 + x1094 * x3 - x60 * (x1096 + x1098 * x3))
            + x49 * (x1099 * x435 + x1101),
            x3 * (x1115 * x3 + x1118 + x3 * (x1115 + x1116 * x3))
            + x4 * (x1107 + x1108 * x3 - x60 * (x1110 + x1111 * x3))
            + x49 * (x1112 * x435 + x1114),
            x3 * (x1134 + x1135 + x3 * (x1129 + x1131))
            + x4 * (x1120 + x1121 * x3 - x60 * (x1123 + x1125 * x3))
            + x49 * (x1126 * x435 + x1128),
            x3 * (x1137 + x650 * x918) + x4 * (x3 * x645 * x918 - x648 * x918),
            x3 * (x1141 * x435 + x1143) + x4 * (x1138 * x3 - x1140 * x3),
            x3 * (x1147 * x435 + x1149) + x4 * (x1144 * x3 - x1146 * x3),
            x3 * (x1153 * x435 + x1155) + x4 * (x1150 * x3 - x1152 * x3),
            x3 * (x1159 * x435 + x1161) + x4 * (x1156 * x3 - x1158 * x3),
            x3 * (x1166 + x1168) + x4 * (x1162 * x3 - x1164 * x3),
            x1175 * x85
            + x3 * (x1171 * x3 + 5.0 * x1174)
            + x91 * (x1173 * x3 + 4.0 * x1176),
            x1181 * x85
            + x3 * (x1178 * x3 + x1180 * x98)
            + x98 * (x107 * x1182 + x1180 * x3),
            x1186 * x85
            + x3 * (x1183 * x3 + 4.0 * x1185)
            + x98 * (x1184 * x3 + 3.0 * x1187),
            x107 * (x1189 * x3 + x1192 * x178) + x1191 * x85 + x3 * (x1188 * x3 + x1190),
            x107 * (x1194 * x3 + x1196) + x1195 * x85 + x3 * (x107 * x1194 + x1193 * x3),
            x107 * (x1198 * x3 + 2.0 * x1201)
            + x1200 * x85
            + x3 * (x1197 * x3 + 3.0 * x1199),
            x1204 * x85 + x178 * (x1203 * x3 + x1205) + x3 * (x1202 * x3 + x1203 * x178),
            x1208 * x85 + x178 * (x1207 * x3 + x1209) + x3 * (x1206 * x3 + x1207 * x178),
            x1213 * x85 + x178 * (x1211 * x3 + x1214) + x3 * (x1210 * x3 + x1212),
            x1218 * x85 + x178 * (x1216 * x3 + x1219) + x3 * (x1215 * x3 + 2.0 * x1217),
            x1221 * x3 + x1223 * x85 + x3 * (x1221 + x1222 * x3),
            x1225 * x3 + x1227 * x85 + x3 * (x1225 + x1226 * x3),
            x1229 * x3 + x1231 * x85 + x3 * (x1229 + x1230 * x3),
            x1233 * x3 + x1235 * x85 + x3 * (x1233 + x1234 * x3),
            x1238 * x3 + x1240 * x85 + x3 * (x1238 + x1239 * x3),
            x1241 * x435 + x1242 * x85,
            x1243 * x435 + x1244 * x85,
            x1245 * x435 + x1246 * x85,
            x1247 * x435 + x1248 * x85,
            x1249 * x435 + x1250 * x85,
            x1251 * x435 + x1252 * x85,
            0.5 * x1253
            + x3 * (x696 * x918 + x697 * x918)
            + x91 * (x700 * x918 + x701 * x918),
            0.5 * x1260
            + x3 * (x1255 * x3 + x1257 * x98)
            + x98 * (x107 * x1262 + x1257 * x3),
            0.5 * x1263
            + x3 * (x694 * x939 + x694 * x942)
            + x98 * (x694 * x946 + x694 * x949),
            x107 * (x1265 * x3 + x1268 * x178) + 0.5 * x1267 + x3 * (x1264 * x3 + x1266),
            x107 * (x1270 * x3 + x1272) + 0.5 * x1271 + x3 * (x107 * x1270 + x1269 * x3),
            x107 * (x1000 * x694 + x694 * x996)
            + 0.5 * x1273
            + x3 * (x694 * x989 + x694 * x992),
            0.5 * x1276 + x178 * (x1275 * x3 + x1277) + x3 * (x1274 * x3 + x1275 * x178),
            0.5 * x1283 + x178 * (x1280 * x3 + x1285) + x3 * (x1279 * x3 + x1280 * x178),
            0.5 * x1289 + x178 * (x1287 * x3 + x1290) + x3 * (x1286 * x3 + x1288),
            0.5 * x1291
            + x178 * (x1067 * x694 + x1292)
            + x3 * (x1057 * x694 + x1061 * x694),
            x1294 * x3 + 0.5 * x1296 + x3 * (x1294 + x1295 * x3),
            x1298 * x3 + 0.5 * x1300 + x3 * (x1298 + x1299 * x3),
            x1302 * x3 + 0.5 * x1304 + x3 * (x1302 + x1303 * x3),
            x1306 * x3 + 0.5 * x1308 + x3 * (x1306 + x1307 * x3),
            x1135 * x694 + 0.5 * x1310 + x3 * (x1131 * x694 + x1309),
            x1311 * x435 + 0.5 * x1312,
            x1313 * x435 + 0.5 * x1314,
            x1316 * x435 + 0.5 * x1319,
            x1320 * x435 + 0.5 * x1321,
            x1322 * x435 + 0.5 * x1323,
            x1166 * x694 + 0.5 * x1324,
            x1332 + x3 * (x1327 + x1330) + x91 * (x1328 * x3 + 4.0 * x1333),
            x1338 + x3 * (x1334 * x3 + 4.0 * x1336) + x98 * (x1335 * x3 + 3.0 * x1339),
            x1346 + x3 * (x1341 + x1344) + x98 * (x1342 * x3 + 3.0 * x1347),
            x107 * (x1349 * x3 + 2.0 * x1354) + x1353 + x3 * (x1348 * x3 + x1351),
            x107 * (x1356 * x3 + x1359) + x1358 + x3 * (x107 * x1356 + x1355 * x3),
            x107 * (x1362 * x3 + 2.0 * x1367) + x1366 + x3 * (x1361 + x1364),
            x1372 + x178 * (x1369 * x3 + x1373) + x3 * (x1368 * x3 + 2.0 * x1370),
            x1378 + x178 * (x1375 * x3 + x1379) + x3 * (x1374 * x3 + x1376),
            x1384 + x178 * (x1381 * x3 + x1385) + x3 * (x1380 * x3 + x1382),
            x1392 + x178 * (x1388 * x3 + x1393) + x3 * (x1387 + x1390),
            x1396 * x3 + x1399 + x3 * (x1396 + x1397 * x3),
            x1401 * x3 + x1404 + x3 * (x1401 + x1402 * x3),
            x1406 * x3 + x1409 + x3 * (x1406 + x1407 * x3),
            x1411 * x3 + x1414 + x3 * (x1411 + x1412 * x3),
            x1416 * x3 + x1420 + x3 * (x1416 + x1418),
            x1421 * x435 + x1423,
            x1424 * x435 + x1426,
            x1427 * x435 + x1429,
            x1430 * x435 + x1432,
            x1433 * x435 + x1435,
            x1436 * x435 + x1438,
            x1439 * x3 + 5.0 * x1440,
            x1441 * x3 + x1442 * x98,
            x1443 * x3 + 4.0 * x1444,
            x1445 * x3 + x1446,
            x107 * x1448 + x1447 * x3,
            x1449 * x3 + 3.0 * x1450,
            x1451 * x3 + x1452 * x178,
            x1453 * x3 + x1454 * x178,
            x1455 * x3 + x1456,
            x1457 * x3 + 2.0 * x1458,
            x1459 + x1460 * x3,
            x1461 + x1462 * x3,
            x1463 + x1464 * x3,
            x1465 + x1466 * x3,
            x1467 + x1468 * x3,
            x1469 * x3,
            x1470 * x3,
            x1471 * x3,
            x1472 * x3,
            x1473 * x3,
            x1474 * x3,
            x1475 * x3 + 5.0 * x1476,
            x1477 * x3 + x1478 * x98,
            x1479 * x3 + 4.0 * x1480,
            x1481 * x3 + x1482,
            x107 * x1484 + x1483 * x3,
            x1485 * x3 + 3.0 * x1486,
            x1487 * x3 + x1488 * x178,
            x1489 * x3 + x1490 * x178,
            x1491 * x3 + x1492,
            x1493 * x3 + 2.0 * x1494,
            x1495 + x1496 * x3,
            x1497 + x1498 * x3,
            x1499 + x1500 * x3,
            x1501 + x1502 * x3,
            x1503 + x1504 * x3,
            x1505 * x3,
            x1506 * x3,
            x1507 * x3,
            x1508 * x3,
            x1509 * x3,
            x1510 * x3,
            x1327 * x694 + x1330 * x694,
            x1511 * x3 + x1512 * x98,
            x1341 * x694 + x1344 * x694,
            x1513 * x3 + x1514,
            x107 * x1516 + x1515 * x3,
            x1361 * x694 + x1364 * x694,
            x1517 * x3 + x1518 * x178,
            x1520 * x3 + x1521 * x178,
            x1522 * x3 + x1523,
            x1387 * x694 + x1390 * x694,
            x1524 + x1525 * x3,
            x1526 + x1527 * x3,
            x1528 + x1529 * x3,
            x1530 + x1531 * x3,
            x1418 * x694 + x1532,
            x1533 * x3,
            x1534 * x3,
            x1536 * x3,
            x1537 * x3,
            x1538 * x3,
            x1436 * x916,
            x1539 * x3 + 5.0 * x1540,
            x1541 * x3 + 4.0 * x1542,
            x1543 * x3 + 4.0 * x1544,
            x1545 * x3 + x1547,
            x107 * x1549 + x1548 * x3,
            x1550 * x3 + x1552,
            x1553 * x3 + 2.0 * x1554,
            x1555 * x3 + x1557,
            x1558 * x3 + x1560,
            x1561 * x3 + 2.0 * x1562,
            x1563 + x1564 * x3,
            x1565 + x1566 * x3,
            x1567 + x1568 * x3,
            x1569 + x1570 * x3,
            x1571 + x1572 * x3,
            x1573 * x3,
            x1574 * x3,
            x1575 * x3,
            x1576 * x3,
            x1577 * x3,
            x1578 * x3,
            x1175 * x118 + x1439 * x694,
            x118 * x1181 + x1440 + x1441 * x694,
            x118 * x1186 + x1443 * x694,
            x118 * x1191 + x1442 * x178 + x1445 * x694,
            x118 * x1195 + x1444 + x1447 * x694,
            x118 * x1200 + x1449 * x694,
            x118 * x1204 + x1446 + x1451 * x694,
            x118 * x1208 + x1448 * x178 + x1453 * x694,
            x118 * x1213 + x1450 + x1455 * x694,
            x118 * x1218 + x1457 * x694,
            x118 * x1223 + x1452 * x98 + x1460 * x694,
            x107 * x1454 + x118 * x1227 + x1462 * x694,
            x118 * x1231 + x1456 + x1464 * x694,
            x118 * x1235 + x1458 + x1466 * x694,
            x118 * x1240 + x1468 * x694,
            x118 * x1242 + 5.0 * x1459 + x1469 * x694,
            x118 * x1244 + 4.0 * x1461 + x1470 * x694,
            x118 * x1246 + 3.0 * x1463 + x1471 * x694,
            x118 * x1248 + 2.0 * x1465 + x1472 * x694,
            x118 * x1250 + x1467 + x1473 * x694,
            x118 * x1252 + x1474 * x694,
            x1253 + x1475 * x694,
            x1260 + x1476 + x1477 * x694,
            x1263 + x1479 * x694,
            x1267 + x1478 * x178 + x1481 * x694,
            x1271 + x1480 + x1483 * x694,
            x1273 + x1485 * x694,
            x1276 + x1482 + x1487 * x694,
            x1283 + x1484 * x178 + x1489 * x694,
            x1289 + x1486 + x1491 * x694,
            x1291 + x1493 * x694,
            x1296 + x1488 * x98 + x1496 * x694,
            x107 * x1490 + x1300 + x1498 * x694,
            x1304 + x1492 + x1500 * x694,
            x1308 + x1494 + x1502 * x694,
            x1310 + x1504 * x694,
            x1312 + 5.0 * x1495 + x1505 * x694,
            x1314 + 4.0 * x1497 + x1506 * x694,
            x1319 + 3.0 * x1499 + x1507 * x694,
            x1321 + 2.0 * x1501 + x1508 * x694,
            x1323 + x1503 + x1509 * x694,
            x1324 + x1510 * x694,
            x1169 * x1326 + x1332,
            x1329 * x694 + x1338 + x1511 * x694,
            x1169 * x1340 + x1346,
            x1353 + x1512 * x178 + x1513 * x694,
            x1343 * x694 + x1358 + x1515 * x694,
            x1169 * x1360 + x1366,
            x1372 + x1514 + x1517 * x694,
            x1378 + x1516 * x178 + x1520 * x694,
            x1363 * x694 + x1384 + x1522 * x694,
            x1169 * x1386 + x1392,
            x1399 + x1518 * x98 + x1525 * x694,
            x107 * x1521 + x1404 + x1527 * x694,
            x1409 + x1523 + x1529 * x694,
            x1389 * x694 + x1414 + x1531 * x694,
            x1169 * x1417 + x1420,
            x1423 + 5.0 * x1524 + x1533 * x694,
            x1426 + 4.0 * x1526 + x1534 * x694,
            x1429 + 3.0 * x1528 + x1536 * x694,
            x1432 + 2.0 * x1530 + x1537 * x694,
            x1435 + x1532 + x1538 * x694,
            x1169 * x1436 + x1438,
            x1539 * x694,
            x1540 + x1541 * x694,
            x1543 * x694,
            2.0 * x1542 + x1545 * x694,
            x1544 + x1548 * x694,
            x1550 * x694,
            x1547 + x1553 * x694,
            x1555 * x694 + x1579,
            x1551 + x1558 * x694,
            x1561 * x694,
            4.0 * x1554 + x1564 * x694,
            x107 * x1556 + x1566 * x694,
            x1560 + x1568 * x694,
            x1562 + x1570 * x694,
            x1572 * x694,
            5.0 * x1563 + x1573 * x694,
            4.0 * x1565 + x1574 * x694,
            x1575 * x694 + x1580,
            2.0 * x1569 + x1576 * x694,
            x1571 + x1577 * x694,
            x1578 * x694,
            x118 * x1331 + x1539 * x918,
            x118 * x1337 + x1541 * x918,
            x118 * x1345 + x1540 + x1543 * x918,
            x118 * x1352 + x1545 * x918,
            x118 * x1357 + x1542 + x1548 * x918,
            x118 * x1365 + 2.0 * x1544 + x1550 * x918,
            x118 * x1371 + x1553 * x918,
            x118 * x1377 + x1546 + x1555 * x918,
            x118 * x1383 + x1558 * x918 + x1579,
            x118 * x1391 + x1552 + x1561 * x918,
            x118 * x1398 + x1564 * x918,
            x118 * x1403 + x1554 + x1566 * x918,
            x118 * x1408 + x1557 + x1568 * x918,
            x107 * x1559 + x118 * x1413 + x1570 * x918,
            x118 * x1419 + 4.0 * x1562 + x1572 * x918,
            x118 * x1422 + x1573 * x918,
            x118 * x1425 + x1563 + x1574 * x918,
            x118 * x1428 + 2.0 * x1565 + x1575 * x918,
            x118 * x1431 + x1576 * x918 + x1580,
            x118 * x1434 + 4.0 * x1569 + x1577 * x918,
            x118 * x1437 + 5.0 * x1571 + x1578 * x918,
        ]
    )


def _2center2el3d_50(a, A, b, B):
    """Cartesian (h|s) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - A[0]
    x3 = a ** (-1.0)
    x4 = b * x1
    x5 = a * x4 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x6 = boys(4, x5)
    x7 = 17.4934183276249
    x8 = 2.0 * x3
    x9 = x7 * x8
    x10 = x0 ** (-1.5) * x9
    x11 = x10 * x6
    x12 = x11 * x2
    x13 = b ** (-1.0)
    x14 = x0 ** (-0.5)
    x15 = boys(3, x5)
    x16 = 0.5 * x3
    x17 = x16 * (-x11 + 2.0 * x13 * x14 * x15 * x3 * x7)
    x18 = boys(5, x5)
    x19 = x2**2
    x20 = x13 * x14 * x9
    x21 = x19 * x20
    x22 = x18 * x21
    x23 = x10 * x15
    x24 = boys(2, x5)
    x25 = x16 * (2.0 * x13 * x14 * x24 * x3 * x7 - x23)
    x26 = x21 * x6
    x27 = x25 + x26
    x28 = x10 * x24
    x29 = boys(1, x5)
    x30 = x16 * (2.0 * x13 * x14 * x29 * x3 * x7 - x28)
    x31 = x15 * x20
    x32 = x19 * x31
    x33 = x30 + x32
    x34 = 1.5 * x3
    x35 = x1 * (a * A[1] + b * B[1]) - A[1]
    x36 = x2 * x35
    x37 = x11 * x35
    x38 = x3 * (2.0 * x13 * x14 * x15 * x3 * x35 * x7 - x37)
    x39 = x22 * x35
    x40 = x3 * (2.0 * x13 * x14 * x29 * x3 * x35 * x7 - x28 * x35)
    x41 = x3 * (2.0 * x13 * x14 * x24 * x3 * x35 * x7 - x23 * x35)
    x42 = x1 * (a * A[2] + b * B[2]) - A[2]
    x43 = x11 * x42
    x44 = x3 * (2.0 * x13 * x14 * x15 * x3 * x42 * x7 - x43)
    x45 = 0.5 * x44
    x46 = x3 * (2.0 * x13 * x14 * x29 * x3 * x42 * x7 - x28 * x42)
    x47 = 0.5 * x46
    x48 = x3 * (2.0 * x13 * x14 * x24 * x3 * x42 * x7 - x23 * x42)
    x49 = 0.5 * x48
    x50 = x35**2
    x51 = x30 + x31 * x50
    x52 = x20 * x50
    x53 = x52 * x6
    x54 = x25 + x53
    x55 = x4 * x54
    x56 = x18 * x52
    x57 = x17 + x56
    x58 = x51 - x55
    x59 = x3 * (2.0 * x13 * x14 * x15 * x3 * x35 * x42 * x7 - x37 * x42)
    x60 = x42**2
    x61 = x30 + x31 * x60
    x62 = x20 * x60
    x63 = x25 + x6 * x62
    x64 = x4 * x63
    x65 = x17 + x18 * x62
    x66 = x19 * x65
    x67 = x61 - x64
    x68 = x16 * x67
    x69 = x35 * x57 + x38
    x70 = x35 * x51 - x4 * (x35 * x54 + x41) + x40
    x71 = x42 * x56 + x45
    x72 = x31 * x42 * x50 - x4 * (x42 * x53 + x49) + x47
    x73 = x3 * (x35 * x61 - x35 * x64)
    x74 = x42 * x65 + x44
    x75 = -x4 * (x42 * x63 + x48) + x42 * x61 + x46
    x76 = x16 * x75
    x77 = x34 * x58 + x35 * x69
    x78 = x35 * x71 + x59
    x79 = x50 * x65 + x68
    x80 = x34 * x67 + x42 * x74

    # 21 item(s)
    return numpy.array(
        [
            x2
            * (
                x2
                * (x2 * (x17 + x22) + x3 * (-x12 + 2.0 * x13 * x14 * x15 * x2 * x3 * x7))
                + x34 * (-x27 * x4 + x33)
            )
            + x8
            * (
                x2 * x33
                + x3 * (2.0 * x13 * x14 * x2 * x29 * x3 * x7 - x2 * x28)
                - x4 * (x2 * x27 + x3 * (2.0 * x13 * x14 * x2 * x24 * x3 * x7 - x2 * x23))
            ),
            x2
            * (
                x2 * (0.5 * x38 + x39)
                + x3 * (-x11 * x36 + 2.0 * x13 * x14 * x15 * x2 * x3 * x35 * x7)
            )
            + x34 * (x32 * x35 - x4 * (x26 * x35 + 0.5 * x41) + 0.5 * x40),
            x2
            * (
                x2 * (x22 * x42 + x45)
                + x3 * (-x12 * x42 + 2.0 * x13 * x14 * x15 * x2 * x3 * x42 * x7)
            )
            + x34 * (x32 * x42 - x4 * (x26 * x42 + x49) + x47),
            x2 * (x16 * x58 + x19 * x57) + x3 * (x2 * x51 - x2 * x55),
            x2 * (x39 * x42 + 0.5 * x59)
            + x3 * (2.0 * x13 * x14 * x15 * x2 * x3 * x35 * x42 * x7 - x36 * x43),
            x2 * (x66 + x68) + x3 * (x2 * x61 - x2 * x64),
            x16 * x70 + x19 * x69,
            x16 * x72 + x19 * x71,
            x35 * x66 + 0.5 * x73,
            x19 * x74 + x76,
            x2 * x77,
            x2 * x78,
            x2 * x79,
            x36 * x74,
            x2 * x80,
            x35 * x77 + x70 * x8,
            x34 * x72 + x35 * x78,
            x35 * x79 + x73,
            x50 * x74 + x76,
            x35 * x80,
            x42 * x80 + x75 * x8,
        ]
    )


def _2center2el3d_51(a, A, b, B):
    """Cartesian (h|p) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = a ** (-1.0)
    x6 = b * x2
    x7 = a * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x8 = boys(4, x7)
    x9 = 17.4934183276249
    x10 = 2.0 * x5
    x11 = x10 * x9
    x12 = x1 ** (-1.5) * x11
    x13 = x12 * x8
    x14 = x13 * x4
    x15 = b ** (-1.0)
    x16 = x1 ** (-0.5)
    x17 = boys(3, x7)
    x18 = 0.5 * x5
    x19 = x18 * (-x13 + 2.0 * x15 * x16 * x17 * x5 * x9)
    x20 = boys(5, x7)
    x21 = x4**2
    x22 = x11 * x15 * x16
    x23 = x21 * x22
    x24 = x20 * x23
    x25 = x19 + x24
    x26 = x25 * x4 + x5 * (-x14 + 2.0 * x15 * x16 * x17 * x4 * x5 * x9)
    x27 = x12 * x17
    x28 = boys(2, x7)
    x29 = x18 * (2.0 * x15 * x16 * x28 * x5 * x9 - x27)
    x30 = x23 * x8
    x31 = x29 + x30
    x32 = boys(1, x7)
    x33 = x18 * (-x12 * x28 + 2.0 * x15 * x16 * x32 * x5 * x9)
    x34 = x17 * x22
    x35 = x21 * x34 + x33
    x36 = 1.5 * x5
    x37 = x0 * x22
    x38 = x37 * x8
    x39 = x20 * x22
    x40 = -x3 - B[0]
    x41 = x4 * x40
    x42 = x39 * x41
    x43 = x38 + x42
    x44 = x0 * x34
    x45 = x22 * x8
    x46 = x40 * x45
    x47 = x4 * x46
    x48 = x44 + x47
    x49 = x20 * x37
    x50 = boys(6, x7)
    x51 = x22 * x50
    x52 = x41 * x51
    x53 = x12 * x20
    x54 = x40 * x53
    x55 = x18 * (2.0 * x15 * x16 * x40 * x5 * x8 * x9 - x54)
    x56 = x4 * x49
    x57 = x13 * x40
    x58 = x18 * (2.0 * x15 * x16 * x17 * x40 * x5 * x9 - x57)
    x59 = x38 * x4
    x60 = x4 * x43 + x58 + x59
    x61 = x27 * x40
    x62 = x18 * (2.0 * x15 * x16 * x28 * x40 * x5 * x9 - x61)
    x63 = x34 * x4
    x64 = x0 * x63
    x65 = x4 * x48 + x62 + x64
    x66 = x22 * x28
    x67 = x0 * x66
    x68 = x40 * x63 + x67
    x69 = x0 * x22 * x32
    x70 = -x2 * (a * A[1] + b * B[1])
    x71 = -x70 - B[1]
    x72 = x53 * x71
    x73 = x4 * x72
    x74 = x18 * (2.0 * x15 * x16 * x5 * x71 * x8 * x9 - x72)
    x75 = x23 * x50
    x76 = x71 * x75
    x77 = x13 * x71
    x78 = x18 * (2.0 * x15 * x16 * x17 * x5 * x71 * x9 - x77)
    x79 = x24 * x71
    x80 = x78 + x79
    x81 = x27 * x71
    x82 = x18 * (2.0 * x15 * x16 * x28 * x5 * x71 * x9 - x81)
    x83 = x30 * x71
    x84 = x82 + x83
    x85 = -x2 * (a * A[2] + b * B[2])
    x86 = -x85 - B[2]
    x87 = x53 * x86
    x88 = x18 * (2.0 * x15 * x16 * x5 * x8 * x86 * x9 - x87)
    x89 = x75 * x86
    x90 = x13 * x86
    x91 = x18 * (2.0 * x15 * x16 * x17 * x5 * x86 * x9 - x90)
    x92 = x24 * x86
    x93 = x91 + x92
    x94 = x27 * x86
    x95 = x18 * (2.0 * x15 * x16 * x28 * x5 * x86 * x9 - x94)
    x96 = x30 * x86
    x97 = x95 + x96
    x98 = -x70 - A[1]
    x99 = x4 * x98
    x100 = x13 * x98
    x101 = x5 * (-x100 + 2.0 * x15 * x16 * x17 * x5 * x9 * x98)
    x102 = x24 * x98
    x103 = 0.5 * x101 + x102
    x104 = x38 * x98
    x105 = x40 * x99
    x106 = x105 * x39
    x107 = x104 + x106
    x108 = x44 * x98
    x109 = x108 + x46 * x99
    x110 = x49 * x98
    x111 = x105 * x51
    x112 = x54 * x98
    x113 = x5 * (-x112 + 2.0 * x15 * x16 * x40 * x5 * x8 * x9 * x98)
    x114 = x5 * (2.0 * x15 * x16 * x28 * x40 * x5 * x9 * x98 - x61 * x98)
    x115 = x5 * (2.0 * x15 * x16 * x17 * x40 * x5 * x9 * x98 - x57 * x98)
    x116 = x45 * x71
    x117 = x116 * x98
    x118 = x117 + x44
    x119 = x71 * x98
    x120 = x119 * x39
    x121 = x120 + x38
    x122 = x121 * x6
    x123 = x119 * x51
    x124 = x123 + x49
    x125 = x5 * (x118 - x122)
    x126 = x34 * x71 * x98 + x67
    x127 = x5 * (-x126 * x6 + x66 * x71 * x98 + x69)
    x128 = x5 * (-x118 * x6 + x126)
    x129 = x5 * (2.0 * x15 * x16 * x5 * x8 * x86 * x9 * x98 - x87 * x98)
    x130 = x5 * (2.0 * x15 * x16 * x28 * x5 * x86 * x9 * x98 - x94 * x98)
    x131 = x5 * (2.0 * x15 * x16 * x17 * x5 * x86 * x9 * x98 - x90 * x98)
    x132 = -x85 - A[2]
    x133 = x5 * (-x13 * x132 + 2.0 * x132 * x15 * x16 * x17 * x5 * x9)
    x134 = 0.5 * x133
    x135 = x132 * x24 + x134
    x136 = x132 * x38
    x137 = x132 * x42 + x136
    x138 = x132 * x44
    x139 = x132 * x47 + x138
    x140 = x132 * x49
    x141 = x5 * (2.0 * x132 * x15 * x16 * x40 * x5 * x8 * x9 - x132 * x54)
    x142 = 0.5 * x141
    x143 = x5 * (2.0 * x132 * x15 * x16 * x28 * x40 * x5 * x9 - x132 * x61)
    x144 = 0.5 * x143
    x145 = x5 * (2.0 * x132 * x15 * x16 * x17 * x40 * x5 * x9 - x132 * x57)
    x146 = 0.5 * x145
    x147 = x5 * (2.0 * x132 * x15 * x16 * x5 * x71 * x8 * x9 - x132 * x72)
    x148 = 0.5 * x147
    x149 = x5 * (2.0 * x132 * x15 * x16 * x28 * x5 * x71 * x9 - x132 * x81)
    x150 = 0.5 * x149
    x151 = x5 * (2.0 * x132 * x15 * x16 * x17 * x5 * x71 * x9 - x132 * x77)
    x152 = 0.5 * x151
    x153 = x45 * x86
    x154 = x132 * x153 + x44
    x155 = x132 * x86
    x156 = x155 * x39 + x38
    x157 = x156 * x6
    x158 = x155 * x51 + x49
    x159 = x158 * x21
    x160 = x5 * (x154 - x157)
    x161 = 0.5 * x160
    x162 = x132 * x34 * x86 + x67
    x163 = x5 * (x132 * x66 * x86 - x162 * x6 + x69)
    x164 = 0.5 * x163
    x165 = x5 * (-x154 * x6 + x162)
    x166 = 0.5 * x165
    x167 = x98**2
    x168 = x167 * x34 + x33
    x169 = x0 * x168
    x170 = x167 * x46 + x62
    x171 = x167 * x45 + x29
    x172 = x0 * x171
    x173 = x167 * x39
    x174 = x173 * x40
    x175 = x174 + x58
    x176 = x173 + x19
    x177 = x168 - x171 * x6
    x178 = x0 * x176
    x179 = x167 * x51
    x180 = x179 * x40
    x181 = x180 + x55
    x182 = x170 - x175 * x6
    x183 = x108 + x118 * x98 + x82
    x184 = x104 + x121 * x98 + x78
    x185 = x184 * x6
    x186 = x110 + x124 * x98 + x74
    x187 = x183 - x185
    x188 = x153 * x167 + x95
    x189 = x173 * x86 + x91
    x190 = x189 * x6
    x191 = x179 * x86 + x88
    x192 = x188 - x190
    x193 = x104 * x132
    x194 = x108 * x132
    x195 = x132 * x46
    x196 = x5 * (-x100 * x132 + 2.0 * x132 * x15 * x16 * x17 * x5 * x9 * x98)
    x197 = x110 * x132
    x198 = x5 * (-x112 * x132 + 2.0 * x132 * x15 * x16 * x40 * x5 * x8 * x9 * x98)
    x199 = x117 * x132 + x138
    x200 = x120 * x132 + x136
    x201 = x200 * x6
    x202 = x123 * x132 + x140
    x203 = x5 * (x199 - x201)
    x204 = x5 * (x154 * x98 - x157 * x98)
    x205 = x132**2
    x206 = x205 * x34 + x33
    x207 = x0 * x206
    x208 = x205 * x46 + x62
    x209 = x205 * x45 + x29
    x210 = x0 * x209
    x211 = x205 * x39
    x212 = x211 * x40 + x58
    x213 = x19 + x211
    x214 = x206 - x209 * x6
    x215 = x18 * x214
    x216 = x0 * x213
    x217 = x205 * x51
    x218 = x217 * x40 + x55
    x219 = x218 * x4
    x220 = x212 * x6
    x221 = x208 - x220
    x222 = x18 * x221
    x223 = x216 * x4
    x224 = x116 * x205 + x82
    x225 = x211 * x71 + x78
    x226 = x225 * x6
    x227 = x217 * x71 + x74
    x228 = x224 - x226
    x229 = x18 * x228
    x230 = x132 * x154 + x138 + x95
    x231 = x132 * x156 + x136 + x91
    x232 = x231 * x6
    x233 = x132 * x158 + x140 + x88
    x234 = x21 * x233
    x235 = x230 - x232
    x236 = x18 * x235
    x237 = x101 + x176 * x98
    x238 = x0 * x237
    x239 = x113 + x181 * x98
    x240 = x114 + x170 * x98 - x6 * (x115 + x175 * x98)
    x241 = x125 + x178 + x186 * x98
    x242 = x127 + x169 + x183 * x98 - x6 * (x128 + x172 + x184 * x98)
    x243 = x129 + x191 * x98
    x244 = x130 + x188 * x98 - x6 * (x131 + x189 * x98)
    x245 = x132 * x173 + x134
    x246 = x0 * x245
    x247 = x132 * x180 + x142
    x248 = x144 + x167 * x195 - x6 * (x132 * x174 + x146)
    x249 = x148 + x197 + x202 * x98
    x250 = x150 + x194 + x199 * x98 - x6 * (x152 + x193 + x200 * x98)
    x251 = x158 * x167 + x161
    x252 = x154 * x167 + x164 - x6 * (x156 * x167 + x166)
    x253 = x216 * x98
    x254 = x5 * (x208 * x98 - x220 * x98)
    x255 = x216 + x227 * x98
    x256 = x5 * (x207 + x224 * x98 - x6 * (x210 + x225 * x98))
    x257 = x5 * (x230 * x98 - x232 * x98)
    x258 = x132 * x213 + x133
    x259 = x0 * x258
    x260 = x132 * x218 + x141
    x261 = x260 * x4
    x262 = x132 * x208 + x143 - x6 * (x132 * x212 + x145)
    x263 = x18 * x262
    x264 = x132 * x227 + x147
    x265 = x132 * x224 + x149 - x6 * (x132 * x225 + x151)
    x266 = x18 * x265
    x267 = x132 * x233 + x160 + x216
    x268 = x132 * x230 + x163 + x207 - x6 * (x132 * x231 + x165 + x210)
    x269 = x18 * x268
    x270 = x0 * (x177 * x36 + x237 * x98)
    x271 = x182 * x36 + x239 * x98
    x272 = x187 * x36 + x238 + x241 * x98
    x273 = x192 * x36 + x243 * x98
    x274 = x0 * (x196 + x245 * x98)
    x275 = x198 + x247 * x98
    x276 = x203 + x246 + x249 * x98
    x277 = x204 + x251 * x98
    x278 = x0 * (x167 * x213 + x215)
    x279 = x167 * x218 + x222
    x280 = x229 + x253 + x255 * x98
    x281 = x167 * x233 + x236
    x282 = x259 * x98
    x283 = x259 + x264 * x98
    x284 = x0 * (x132 * x258 + x214 * x36)
    x285 = x132 * x260 + x221 * x36
    x286 = x132 * x264 + x228 * x36
    x287 = x132 * x267 + x235 * x36 + x259

    # 63 item(s)
    return numpy.array(
        [
            x0 * (x26 * x4 + x36 * (-x31 * x6 + x35))
            + x10
            * (
                x0 * x35
                + x4 * x65
                + x5 * (x4 * x40 * x66 - x6 * x68 + x69)
                - x6 * (x0 * x31 + x4 * x60 + x5 * (-x48 * x6 + x68))
            )
            + x4
            * (
                x0 * x26
                + x36 * (-x6 * x60 + x65)
                + x4
                * (
                    x0 * x25
                    + x4 * (x4 * (x49 + x52) + x55 + x56)
                    + x5 * (-x43 * x6 + x48)
                )
            ),
            x10
            * (
                x4 * x84
                + x5 * (2.0 * x15 * x16 * x28 * x4 * x5 * x71 * x9 - x4 * x81)
                - x6
                * (
                    x4 * x80
                    + x5 * (-x14 * x71 + 2.0 * x15 * x16 * x17 * x4 * x5 * x71 * x9)
                )
            )
            + x4
            * (
                x36 * (-x6 * x80 + x84)
                + x4
                * (
                    x4 * (x74 + x76)
                    + x5 * (2.0 * x15 * x16 * x4 * x5 * x71 * x8 * x9 - x73)
                )
            ),
            x10
            * (
                x4 * x97
                + x5 * (2.0 * x15 * x16 * x28 * x4 * x5 * x86 * x9 - x4 * x94)
                - x6
                * (
                    x4 * x93
                    + x5 * (-x14 * x86 + 2.0 * x15 * x16 * x17 * x4 * x5 * x86 * x9)
                )
            )
            + x4
            * (
                x36 * (-x6 * x93 + x97)
                + x4
                * (
                    x4 * (x88 + x89)
                    + x5 * (2.0 * x15 * x16 * x4 * x5 * x8 * x86 * x9 - x4 * x87)
                )
            ),
            x0
            * (x103 * x4 + x5 * (-x13 * x99 + 2.0 * x15 * x16 * x17 * x4 * x5 * x9 * x98))
            + x36
            * (
                x109 * x4
                + 0.5 * x114
                + x44 * x99
                - x6 * (x107 * x4 + 0.5 * x115 + x38 * x99)
            )
            + x4
            * (
                x0 * x103
                + x4 * (0.5 * x113 + x4 * (x110 + x111) + x49 * x99)
                + x5 * (-x107 * x6 + x109)
            ),
            x36 * (x118 * x21 + 0.5 * x127 - x6 * (x121 * x21 + 0.5 * x128))
            + x4 * (x4 * (x124 * x21 + 0.5 * x125) + x5 * (x118 * x4 - x122 * x4)),
            x36 * (0.5 * x130 - x6 * (0.5 * x131 + x92 * x98) + x96 * x98)
            + x4
            * (
                x4 * (0.5 * x129 + x89 * x98)
                + x5 * (2.0 * x15 * x16 * x4 * x5 * x8 * x86 * x9 * x98 - x87 * x99)
            ),
            x0
            * (
                x135 * x4
                + x5 * (-x132 * x14 + 2.0 * x132 * x15 * x16 * x17 * x4 * x5 * x9)
            )
            + x36 * (x132 * x64 + x139 * x4 + x144 - x6 * (x132 * x59 + x137 * x4 + x146))
            + x4
            * (
                x0 * x135
                + x4 * (x132 * x56 + x142 + x4 * (x132 * x52 + x140))
                + x5 * (-x137 * x6 + x139)
            ),
            x36 * (x132 * x83 + x150 - x6 * (x132 * x79 + x152))
            + x4
            * (
                x4 * (x132 * x76 + x148)
                + x5 * (2.0 * x132 * x15 * x16 * x4 * x5 * x71 * x8 * x9 - x132 * x73)
            ),
            x36 * (x154 * x21 + x164 - x6 * (x156 * x21 + x166))
            + x4 * (x4 * (x159 + x161) + x5 * (x154 * x4 - x157 * x4)),
            x0 * (x176 * x21 + x177 * x18)
            + x4 * (x178 * x4 + x18 * x182 + x4 * (x178 + x181 * x4))
            + x5 * (x169 + x170 * x4 - x6 * (x172 + x175 * x4)),
            x4 * (x18 * x187 + x186 * x21) + x5 * (x183 * x4 - x185 * x4),
            x4 * (x18 * x192 + x191 * x21) + x5 * (x188 * x4 - x190 * x4),
            x0 * (x102 * x132 + 0.5 * x196)
            + x4 * (x140 * x99 + 0.5 * x198 + x4 * (x111 * x132 + x197))
            + x5 * (x194 + x195 * x99 - x6 * (x106 * x132 + x193)),
            x4 * (x202 * x21 + 0.5 * x203) + x5 * (x199 * x4 - x201 * x4),
            x4 * (x159 * x98 + 0.5 * x204) + x5 * (x154 * x4 * x98 - x157 * x99),
            x0 * (x21 * x213 + x215)
            + x4 * (x222 + x223 + x4 * (x216 + x219))
            + x5 * (x207 + x208 * x4 - x6 * (x210 + x212 * x4)),
            x4 * (x21 * x227 + x229) + x5 * (x224 * x4 - x226 * x4),
            x4 * (x234 + x236) + x5 * (x230 * x4 - x232 * x4),
            x18 * x240 + x238 * x4 + x4 * (x238 + x239 * x4),
            x18 * x242 + x21 * x241,
            x18 * x244 + x21 * x243,
            x18 * x248 + x246 * x4 + x4 * (x246 + x247 * x4),
            x18 * x250 + x21 * x249,
            x18 * x252 + x21 * x251,
            x223 * x98 + 0.5 * x254 + x4 * (x219 * x98 + x253),
            x21 * x255 + 0.5 * x256,
            x234 * x98 + 0.5 * x257,
            x259 * x4 + x263 + x4 * (x259 + x261),
            x21 * x264 + x266,
            x21 * x267 + x269,
            x270 + x271 * x4,
            x272 * x4,
            x273 * x4,
            x274 + x275 * x4,
            x276 * x4,
            x277 * x4,
            x278 + x279 * x4,
            x280 * x4,
            x281 * x4,
            x261 * x98 + x282,
            x283 * x4,
            x267 * x99,
            x284 + x285 * x4,
            x286 * x4,
            x287 * x4,
            x10 * x240 + x271 * x98,
            x10 * x242 + x270 + x272 * x98,
            x10 * x244 + x273 * x98,
            x248 * x36 + x275 * x98,
            x250 * x36 + x274 + x276 * x98,
            x252 * x36 + x277 * x98,
            x254 + x279 * x98,
            x256 + x278 + x280 * x98,
            x257 + x281 * x98,
            x167 * x260 + x263,
            x266 + x282 + x283 * x98,
            x167 * x267 + x269,
            x285 * x98,
            x284 + x286 * x98,
            x287 * x98,
            x10 * x262 + x132 * x285,
            x10 * x265 + x132 * x286,
            x10 * x268 + x132 * x287 + x284,
        ]
    )


def _2center2el3d_52(a, A, b, B):
    """Cartesian (h|d) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a ** (-1.0)
    x5 = b * x1
    x6 = a * x5 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x7 = boys(5, x6)
    x8 = x0 ** (-1.5)
    x9 = b ** (-1.0)
    x10 = 17.4934183276249
    x11 = x10 * x9
    x12 = 2.0 * x11
    x13 = x12 * x8
    x14 = x0 ** (-0.5)
    x15 = boys(4, x6)
    x16 = 0.5 * x9
    x17 = x16 * (2.0 * x10 * x14 * x15 * x4 * x9 - x13 * x7)
    x18 = boys(6, x6)
    x19 = -x2 - B[0]
    x20 = x19**2
    x21 = 2.0 * x4
    x22 = x11 * x14
    x23 = x21 * x22
    x24 = x20 * x23
    x25 = x17 + x18 * x24
    x26 = x25 * x3
    x27 = x19 * x7
    x28 = (2.0 * a + 2.0 * b) ** (-1.0)
    x29 = x22 * x4
    x30 = 4.0 * x28 * x29
    x31 = x27 * x30
    x32 = x26 + x31
    x33 = x15 * x8
    x34 = boys(3, x6)
    x35 = -2.0 * x10 * x14 * x34 * x4 * x9
    x36 = x16 * (-x12 * x33 - x35)
    x37 = x23 * x7
    x38 = x20 * x37 + x36
    x39 = x3 * x38
    x40 = x19 * x30
    x41 = x15 * x40
    x42 = x39 + x41
    x43 = x16 * (2.0 * x10 * x14 * x4 * x7 * x9 - x13 * x18)
    x44 = boys(7, x6)
    x45 = x24 * x44 + x43
    x46 = x3 * x45
    x47 = x18 * x19
    x48 = x30 * x47
    x49 = x25 * x5
    x50 = 0.5 * x4
    x51 = x50 * (x38 - x49)
    x52 = 2.0 * x28
    x53 = x29 * x52
    x54 = x53 * x7
    x55 = x23 * x47
    x56 = x3 * x55
    x57 = x54 + x56
    x58 = x10 * x21
    x59 = x58 * x8
    x60 = x27 * x59
    x61 = x50 * (2.0 * x10 * x14 * x15 * x19 * x4 * x9 - x60)
    x62 = x3 * x54
    x63 = x3 * x57 + x61 + x62
    x64 = x15 * x53
    x65 = x19 * x37
    x66 = x3 * x65
    x67 = x64 + x66
    x68 = x34 * x53
    x69 = x15 * x23
    x70 = x19 * x69
    x71 = x3 * x70
    x72 = x68 + x71
    x73 = x33 * x58
    x74 = x50 * (-x35 - x73)
    x75 = x3**2
    x76 = x37 * x75
    x77 = x74 + x76
    x78 = x28 * x77 + x3 * x63 + x4 * (-x5 * x67 + x72)
    x79 = boys(2, x6)
    x80 = x16 * (2.0 * x10 * x14 * x4 * x79 * x9 - x13 * x34)
    x81 = x20 * x69 + x80
    x82 = x50 * (-x38 * x5 + x81)
    x83 = x3 * x32 + x52 * x67 + x82
    x84 = x16 * (2.0 * x10 * x14 * x4 * x9 * boys(1, x6) - x13 * x79)
    x85 = x23 * x34
    x86 = x20 * x85 + x84
    x87 = x50 * (-x5 * x81 + x86)
    x88 = x3 * x42 + x52 * x72 + x87
    x89 = 1.5 * x4
    x90 = x3 * x81 + x34 * x40
    x91 = x34 * x59
    x92 = x50 * (2.0 * x10 * x14 * x19 * x4 * x79 * x9 - x19 * x91)
    x93 = x3 * x68 + x3 * x72 + x92
    x94 = x19 * x73
    x95 = x50 * (2.0 * x10 * x14 * x19 * x34 * x4 * x9 - x94)
    x96 = x3 * x64
    x97 = x3 * x67 + x95 + x96
    x98 = x3 * x73
    x99 = -x1 * (a * A[1] + b * B[1])
    x100 = -x99 - B[1]
    x101 = x59 * x7
    x102 = x100 * x101
    x103 = x102 * x3
    x104 = x50 * (2.0 * x10 * x100 * x14 * x15 * x4 * x9 - x102)
    x105 = x100 * x18
    x106 = x23 * x75
    x107 = x105 * x106
    x108 = x104 + x107
    x109 = x108 * x3 + x4 * (2.0 * x10 * x100 * x14 * x15 * x3 * x4 * x9 - x103)
    x110 = x100 * x73
    x111 = x50 * (2.0 * x10 * x100 * x14 * x34 * x4 * x9 - x110)
    x112 = x100 * x76
    x113 = x111 + x112
    x114 = x50 * (2.0 * x10 * x100 * x14 * x4 * x79 * x9 - x100 * x91)
    x115 = x100 * x69
    x116 = x114 + x115 * x75
    x117 = x100 * x54
    x118 = x100 * x56
    x119 = x117 + x118
    x120 = x100 * x64
    x121 = x100 * x66
    x122 = x120 + x121
    x123 = x105 * x53
    x124 = x23 * x44
    x125 = x124 * x19
    x126 = x125 * x3
    x127 = x100 * x126
    x128 = x47 * x59
    x129 = x100 * x128
    x130 = x50 * (2.0 * x10 * x100 * x14 * x19 * x4 * x7 * x9 - x129)
    x131 = x123 * x3
    x132 = x100 * x60
    x133 = x50 * (2.0 * x10 * x100 * x14 * x15 * x19 * x4 * x9 - x132)
    x134 = x100 * x62
    x135 = x119 * x3 + x133 + x134
    x136 = x100 * x94
    x137 = x50 * (2.0 * x10 * x100 * x14 * x19 * x34 * x4 * x9 - x136)
    x138 = x100 * x96
    x139 = x122 * x3 + x137 + x138
    x140 = x100 * x68
    x141 = x100 * x71 + x140
    x142 = x53 * x79
    x143 = x100 * x142
    x144 = x19 * x85
    x145 = x100 * x144
    x146 = -x1 * (a * A[2] + b * B[2])
    x147 = -x146 - B[2]
    x148 = x101 * x147
    x149 = x50 * (2.0 * x10 * x14 * x147 * x15 * x4 * x9 - x148)
    x150 = x147 * x18
    x151 = x106 * x150
    x152 = x149 + x151
    x153 = x152 * x3 + x4 * (2.0 * x10 * x14 * x147 * x15 * x3 * x4 * x9 - x148 * x3)
    x154 = x50 * (2.0 * x10 * x14 * x147 * x34 * x4 * x9 - x147 * x73)
    x155 = x147 * x76 + x154
    x156 = x50 * (2.0 * x10 * x14 * x147 * x4 * x79 * x9 - x147 * x91)
    x157 = x147 * x69
    x158 = x156 + x157 * x75
    x159 = x147 * x54
    x160 = x147 * x56 + x159
    x161 = x147 * x64
    x162 = x147 * x66 + x161
    x163 = x150 * x53
    x164 = x128 * x147
    x165 = x50 * (2.0 * x10 * x14 * x147 * x19 * x4 * x7 * x9 - x164)
    x166 = x147 * x60
    x167 = x50 * (2.0 * x10 * x14 * x147 * x15 * x19 * x4 * x9 - x166)
    x168 = x147 * x62 + x160 * x3 + x167
    x169 = x147 * x94
    x170 = x50 * (2.0 * x10 * x14 * x147 * x19 * x34 * x4 * x9 - x169)
    x171 = x147 * x96 + x162 * x3 + x170
    x172 = x147 * x68
    x173 = x147 * x71 + x172
    x174 = x142 * x147
    x175 = x144 * x147
    x176 = x100**2
    x177 = x176 * x37 + x36
    x178 = x176 * x23
    x179 = x17 + x178 * x18
    x180 = x179 * x5
    x181 = x180 * x3
    x182 = x178 * x44 + x43
    x183 = x182 * x75
    x184 = x50 * (x177 - x180)
    x185 = x179 * x75
    x186 = x176 * x69 + x80
    x187 = x50 * (-x177 * x5 + x186)
    x188 = x185 + x187
    x189 = x177 * x75
    x190 = x176 * x85 + x84
    x191 = x50 * (-x186 * x5 + x190)
    x192 = x189 + x191
    x193 = x105 * x147
    x194 = x193 * x59
    x195 = x50 * (2.0 * x10 * x100 * x14 * x147 * x4 * x7 * x9 - x194)
    x196 = x100 * x147
    x197 = x50 * (2.0 * x10 * x100 * x14 * x147 * x15 * x4 * x9 - x102 * x147)
    x198 = x106 * x193 + x197
    x199 = x50 * (2.0 * x10 * x100 * x14 * x147 * x34 * x4 * x9 - x110 * x147)
    x200 = x112 * x147 + x199
    x201 = x147**2
    x202 = x201 * x37 + x36
    x203 = x201 * x23
    x204 = x17 + x18 * x203
    x205 = x204 * x5
    x206 = x203 * x44 + x43
    x207 = x206 * x75
    x208 = x50 * (x202 - x205)
    x209 = x204 * x75
    x210 = x201 * x69 + x80
    x211 = x50 * (-x202 * x5 + x210)
    x212 = x209 + x211
    x213 = x202 * x75
    x214 = x201 * x85 + x84
    x215 = x50 * (-x210 * x5 + x214)
    x216 = x213 + x215
    x217 = -x99 - A[1]
    x218 = x217 * x26
    x219 = x217 * x31
    x220 = x218 + x219
    x221 = x217 * x39
    x222 = x217 * x41
    x223 = x221 + x222
    x224 = x217 * x46
    x225 = x217 * x48
    x226 = x217 * x49
    x227 = x4 * (x217 * x38 - x226)
    x228 = x217 * x54
    x229 = x217 * x3
    x230 = x229 * x55
    x231 = x228 + x230
    x232 = x217 * x60
    x233 = x4 * (2.0 * x10 * x14 * x15 * x19 * x217 * x4 * x9 - x232)
    x234 = x229 * x54 + x231 * x3 + 0.5 * x233
    x235 = x217 * x64
    x236 = x229 * x65 + x235
    x237 = x217 * x68
    x238 = x229 * x70 + x237
    x239 = x4 * (2.0 * x10 * x14 * x217 * x34 * x4 * x9 - x217 * x73)
    x240 = x4 * (-x217 * x5 * x81 + x217 * x86)
    x241 = x4 * (-x217 * x38 * x5 + x217 * x81)
    x242 = x115 * x217
    x243 = x242 + x68
    x244 = x100 * x217
    x245 = x244 * x37
    x246 = x245 + x64
    x247 = x246 * x5
    x248 = x105 * x23
    x249 = x217 * x248
    x250 = x249 + x54
    x251 = x4 * (x243 - x247)
    x252 = x250 * x75 + 0.5 * x251
    x253 = x246 * x28
    x254 = x27 * x53
    x255 = x244 * x55
    x256 = x254 + x255
    x257 = x253 + x256 * x3
    x258 = x243 * x28
    x259 = x19 * x64
    x260 = x100 * x217 * x65
    x261 = x259 + x260
    x262 = x258 + x261 * x3
    x263 = x250 * x28
    x264 = x47 * x53
    x265 = x125 * x244
    x266 = x264 + x265
    x267 = x4 * (-x256 * x5 + x261)
    x268 = x19 * x68
    x269 = x100 * x217 * x70 + x268
    x270 = x142 * x19
    x271 = x4 * (x145 * x217 - x269 * x5 + x270)
    x272 = x4 * (-x261 * x5 + x269)
    x273 = x4 * (2.0 * x10 * x14 * x147 * x15 * x217 * x4 * x9 - x148 * x217)
    x274 = x151 * x217 + 0.5 * x273
    x275 = x159 * x217
    x276 = x147 * x230 + x275
    x277 = x161 * x217
    x278 = x147 * x65
    x279 = x229 * x278 + x277
    x280 = x163 * x217
    x281 = x125 * x147
    x282 = x4 * (2.0 * x10 * x14 * x147 * x19 * x217 * x4 * x7 * x9 - x164 * x217)
    x283 = x4 * (2.0 * x10 * x14 * x147 * x19 * x217 * x34 * x4 * x9 - x169 * x217)
    x284 = x4 * (2.0 * x10 * x14 * x147 * x15 * x19 * x217 * x4 * x9 - x166 * x217)
    x285 = x177 * x217
    x286 = x100 * x30
    x287 = x15 * x286
    x288 = x285 + x287
    x289 = x179 * x217
    x290 = x286 * x7
    x291 = x289 + x290
    x292 = x291 * x5
    x293 = x182 * x217
    x294 = x105 * x30
    x295 = x293 + x294
    x296 = x4 * (x288 - x292)
    x297 = x186 * x217 + x286 * x34
    x298 = x4 * (x190 * x217 + x286 * x79 - x297 * x5)
    x299 = x4 * (-x288 * x5 + x297)
    x300 = x196 * x37
    x301 = x161 + x217 * x300
    x302 = x193 * x23
    x303 = x159 + x217 * x302
    x304 = x303 * x5
    x305 = x124 * x196
    x306 = x163 + x217 * x305
    x307 = x4 * (x301 - x304)
    x308 = x115 * x147
    x309 = x172 + x217 * x308
    x310 = x100 * x147 * x85
    x311 = x4 * (x174 + x217 * x310 - x309 * x5)
    x312 = x4 * (-x301 * x5 + x309)
    x313 = x4 * (x202 * x217 - x205 * x217)
    x314 = x4 * (-x210 * x217 * x5 + x214 * x217)
    x315 = x4 * (-x202 * x217 * x5 + x210 * x217)
    x316 = -x146 - A[2]
    x317 = x26 * x316 + x31 * x316
    x318 = x316 * x39 + x316 * x41
    x319 = x4 * (x316 * x38 - x316 * x49)
    x320 = 0.5 * x319
    x321 = x316 * x54
    x322 = x316 * x56 + x321
    x323 = x4 * (2.0 * x10 * x14 * x15 * x19 * x316 * x4 * x9 - x316 * x60)
    x324 = 0.5 * x323
    x325 = x3 * x322 + x316 * x62 + x324
    x326 = x316 * x64
    x327 = x316 * x66 + x326
    x328 = x316 * x68
    x329 = x316 * x71 + x328
    x330 = x4 * (2.0 * x10 * x14 * x316 * x34 * x4 * x9 - x316 * x73)
    x331 = 0.5 * x330
    x332 = x4 * (-x316 * x5 * x81 + x316 * x86)
    x333 = 0.5 * x332
    x334 = x316 * x38
    x335 = x4 * (x316 * x81 - x334 * x5)
    x336 = 0.5 * x335
    x337 = x4 * (2.0 * x10 * x100 * x14 * x15 * x316 * x4 * x9 - x102 * x316)
    x338 = 0.5 * x337
    x339 = x107 * x316 + x338
    x340 = x117 * x316
    x341 = x118 * x316 + x340
    x342 = x120 * x316
    x343 = x121 * x316 + x342
    x344 = x123 * x316
    x345 = x4 * (2.0 * x10 * x100 * x14 * x19 * x316 * x4 * x7 * x9 - x129 * x316)
    x346 = 0.5 * x345
    x347 = x4 * (2.0 * x10 * x100 * x14 * x19 * x316 * x34 * x4 * x9 - x136 * x316)
    x348 = 0.5 * x347
    x349 = x4 * (2.0 * x10 * x100 * x14 * x15 * x19 * x316 * x4 * x9 - x132 * x316)
    x350 = 0.5 * x349
    x351 = x157 * x316 + x68
    x352 = x147 * x316
    x353 = x352 * x37 + x64
    x354 = x353 * x5
    x355 = x150 * x23
    x356 = x316 * x355 + x54
    x357 = x356 * x75
    x358 = x4 * (x351 - x354)
    x359 = 0.5 * x358
    x360 = x357 + x359
    x361 = x28 * x353
    x362 = x254 + x352 * x55
    x363 = x3 * x362
    x364 = x361 + x363
    x365 = x28 * x351
    x366 = x259 + x278 * x316
    x367 = x3 * x366
    x368 = x365 + x367
    x369 = x28 * x356
    x370 = x125 * x352 + x264
    x371 = x3 * x370
    x372 = x362 * x5
    x373 = x4 * (x366 - x372)
    x374 = 0.5 * x373
    x375 = x3 * x369
    x376 = x147 * x316 * x70 + x268
    x377 = x4 * (x175 * x316 + x270 - x376 * x5)
    x378 = 0.5 * x377
    x379 = x4 * (-x366 * x5 + x376)
    x380 = 0.5 * x379
    x381 = x4 * (x177 * x316 - x180 * x316)
    x382 = 0.5 * x381
    x383 = x4 * (-x186 * x316 * x5 + x190 * x316)
    x384 = 0.5 * x383
    x385 = x4 * (-x177 * x316 * x5 + x186 * x316)
    x386 = 0.5 * x385
    x387 = x120 + x300 * x316
    x388 = x117 + x302 * x316
    x389 = x388 * x5
    x390 = x123 + x305 * x316
    x391 = x4 * (x387 - x389)
    x392 = 0.5 * x391
    x393 = x140 + x308 * x316
    x394 = x4 * (x143 + x310 * x316 - x393 * x5)
    x395 = 0.5 * x394
    x396 = x4 * (-x387 * x5 + x393)
    x397 = 0.5 * x396
    x398 = x147 * x30
    x399 = x15 * x398 + x202 * x316
    x400 = x204 * x316 + x398 * x7
    x401 = x400 * x5
    x402 = x150 * x30 + x206 * x316
    x403 = x402 * x75
    x404 = x4 * (x399 - x401)
    x405 = 0.5 * x404
    x406 = x210 * x316 + x34 * x398
    x407 = x4 * (x214 * x316 + x398 * x79 - x406 * x5)
    x408 = 0.5 * x407
    x409 = x4 * (-x399 * x5 + x406)
    x410 = 0.5 * x409
    x411 = x217**2
    x412 = x38 * x411 + x87
    x413 = x411 * x70 + x92
    x414 = x28 * x413
    x415 = x25 * x411
    x416 = x415 + x82
    x417 = x37 * x411
    x418 = x19 * x417
    x419 = x418 + x95
    x420 = x28 * x419
    x421 = x411 * x45
    x422 = x421 + x51
    x423 = x411 * x55
    x424 = x423 + x61
    x425 = x28 * x424
    x426 = x412 - x416 * x5
    x427 = x417 + x74
    x428 = x28 * x427
    x429 = x3 * x424 + x428
    x430 = x413 - x419 * x5
    x431 = x114 + x217 * x243 + x237
    x432 = x28 * x431
    x433 = x19 * x235
    x434 = x137 + x217 * x261 + x433
    x435 = x111 + x217 * x246 + x235
    x436 = x28 * x435
    x437 = x217 * x254
    x438 = x133 + x217 * x256 + x437
    x439 = x104 + x217 * x250 + x228
    x440 = x431 - x435 * x5
    x441 = x28 * x439
    x442 = x217 * x264
    x443 = x130 + x217 * x266 + x442
    x444 = x434 - x438 * x5
    x445 = x156 + x157 * x411
    x446 = x28 * x445
    x447 = x147 * x418 + x170
    x448 = x147 * x417 + x154
    x449 = x28 * x448
    x450 = x147 * x423 + x167
    x451 = x149 + x355 * x411
    x452 = x445 - x448 * x5
    x453 = x28 * x451
    x454 = x165 + x281 * x411
    x455 = x447 - x450 * x5
    x456 = x191 + x217 * x288 + 2.0 * x258
    x457 = x187 + x217 * x291 + 2.0 * x253
    x458 = x457 * x5
    x459 = x184 + x217 * x295 + 2.0 * x263
    x460 = x456 - x458
    x461 = x199 + x217 * x301 + x277
    x462 = x197 + x217 * x303 + x275
    x463 = x462 * x5
    x464 = x195 + x217 * x306 + x280
    x465 = x461 - x463
    x466 = x202 * x411 + x215
    x467 = x204 * x411 + x211
    x468 = x467 * x5
    x469 = x206 * x411 + x208
    x470 = x466 - x468
    x471 = x4 * (x217 * x316 * x38 - x226 * x316)
    x472 = x228 * x316
    x473 = x230 * x316 + x472
    x474 = x4 * (2.0 * x10 * x14 * x15 * x19 * x217 * x316 * x4 * x9 - x232 * x316)
    x475 = x242 * x316 + x328
    x476 = x28 * x475
    x477 = x259 * x316
    x478 = x260 * x316 + x477
    x479 = x245 * x316 + x326
    x480 = x28 * x479
    x481 = x254 * x316
    x482 = x255 * x316 + x481
    x483 = x249 * x316 + x321
    x484 = x4 * (x475 - x479 * x5)
    x485 = x28 * x483
    x486 = x264 * x316
    x487 = x265 * x316 + x486
    x488 = x4 * (x478 - x482 * x5)
    x489 = x217 * x365
    x490 = x217 * x361
    x491 = x4 * (x217 * x351 - x217 * x354)
    x492 = x217 * x369
    x493 = x4 * (x217 * x366 - x217 * x372)
    x494 = x285 * x316 + x287 * x316
    x495 = x289 * x316 + x290 * x316
    x496 = x495 * x5
    x497 = x293 * x316 + x294 * x316
    x498 = x4 * (x494 - x496)
    x499 = x217 * x387 + x365
    x500 = x217 * x388 + x361
    x501 = x5 * x500
    x502 = x217 * x390 + x369
    x503 = x4 * (x499 - x501)
    x504 = x4 * (x217 * x399 - x217 * x401)
    x505 = x316**2
    x506 = x38 * x505 + x87
    x507 = x505 * x70 + x92
    x508 = x28 * x507
    x509 = x25 * x505 + x82
    x510 = x37 * x505
    x511 = x19 * x510
    x512 = x511 + x95
    x513 = x28 * x512
    x514 = x45 * x505 + x51
    x515 = x3 * x514
    x516 = x505 * x55
    x517 = x516 + x61
    x518 = x28 * x517
    x519 = 2.0 * x518
    x520 = x5 * x509
    x521 = x506 - x520
    x522 = x50 * x521
    x523 = x510 + x74
    x524 = x28 * x523
    x525 = x3 * x517
    x526 = x524 + x525
    x527 = -x5 * x512 + x507
    x528 = x50 * x527
    x529 = x114 + x115 * x505
    x530 = x28 * x529
    x531 = x100 * x511 + x137
    x532 = x100 * x510 + x111
    x533 = x28 * x532
    x534 = x100 * x516 + x133
    x535 = x104 + x248 * x505
    x536 = -x5 * x532 + x529
    x537 = x50 * x536
    x538 = x28 * x535
    x539 = x100 * x125 * x505 + x130
    x540 = -x5 * x534 + x531
    x541 = x50 * x540
    x542 = x156 + x316 * x351 + x328
    x543 = x28 * x542
    x544 = x170 + x316 * x366 + x477
    x545 = x154 + x316 * x353 + x326
    x546 = x28 * x545
    x547 = x167 + x316 * x362 + x481
    x548 = x149 + x316 * x356 + x321
    x549 = -x5 * x545 + x542
    x550 = x50 * x549
    x551 = x28 * x548
    x552 = x165 + x316 * x370 + x486
    x553 = x3 * x552
    x554 = x5 * x547
    x555 = x544 - x554
    x556 = x50 * x555
    x557 = x3 * x551
    x558 = x177 * x505 + x191
    x559 = x179 * x505 + x187
    x560 = x5 * x559
    x561 = x182 * x505 + x184
    x562 = x558 - x560
    x563 = x50 * x562
    x564 = x199 + x316 * x387 + x342
    x565 = x197 + x316 * x388 + x340
    x566 = x5 * x565
    x567 = x195 + x316 * x390 + x344
    x568 = x564 - x566
    x569 = x50 * x568
    x570 = x215 + x316 * x399 + 2.0 * x365
    x571 = x211 + x316 * x400 + 2.0 * x361
    x572 = x5 * x571
    x573 = x208 + x316 * x402 + 2.0 * x369
    x574 = x573 * x75
    x575 = x570 - x572
    x576 = x50 * x575
    x577 = x217 * x422 + x227
    x578 = x217 * x424 + x233
    x579 = x28 * x578
    x580 = x217 * x412 + x240 - x5 * (x217 * x416 + x241)
    x581 = x28 * (x217 * x427 + x239)
    x582 = x217 * x439 + x251 + x428
    x583 = x28 * x582
    x584 = x217 * x443 + x267 + x425
    x585 = x217 * x434 + x271 + x414 - x5 * (x217 * x438 + x272 + x420)
    x586 = x217 * x451 + x273
    x587 = x28 * x586
    x588 = x217 * x454 + x282
    x589 = x217 * x447 + x283 - x5 * (x217 * x450 + x284)
    x590 = x217 * x459 + x296 + 2.0 * x441
    x591 = x217 * x456 + x298 + 2.0 * x432 - x5 * (x217 * x457 + x299 + 2.0 * x436)
    x592 = x217 * x464 + x307 + x453
    x593 = x217 * x461 + x311 + x446 - x5 * (x217 * x462 + x312 + x449)
    x594 = x217 * x469 + x313
    x595 = x217 * x466 + x314 - x5 * (x217 * x467 + x315)
    x596 = x316 * x421 + x320
    x597 = x316 * x423 + x324
    x598 = x28 * x597
    x599 = x333 + x334 * x411 - x5 * (x316 * x415 + x336)
    x600 = x28 * (x316 * x417 + x331)
    x601 = x217 * x483 + x338 + x472
    x602 = x28 * x601
    x603 = x217 * x487 + x316 * x442 + x346
    x604 = x217 * x478 + x316 * x433 + x348 - x5 * (x217 * x482 + x316 * x437 + x350)
    x605 = x356 * x411 + x359
    x606 = x28 * x605
    x607 = x370 * x411 + x374
    x608 = x366 * x411 + x378 - x5 * (x362 * x411 + x380)
    x609 = x217 * x497 + x382 + 2.0 * x485
    x610 = x217 * x494 + x384 + 2.0 * x476 - x5 * (x217 * x495 + x386 + 2.0 * x480)
    x611 = x217 * x502 + x392 + x492
    x612 = x217 * x499 + x395 + x489 - x5 * (x217 * x500 + x397 + x490)
    x613 = x402 * x411 + x405
    x614 = x399 * x411 + x408 - x5 * (x400 * x411 + x410)
    x615 = x4 * (x217 * x506 - x217 * x520)
    x616 = x217 * x524
    x617 = x217 * x535 + x524
    x618 = x28 * x617
    x619 = x217 * x539 + x518
    x620 = x4 * (x217 * x531 - x5 * (x217 * x534 + x513) + x508)
    x621 = x217 * x551
    x622 = x4 * (x217 * x544 - x217 * x554)
    x623 = x217 * x561 + 2.0 * x538
    x624 = x4 * (x217 * x558 - x5 * (x217 * x559 + 2.0 * x533) + 2.0 * x530)
    x625 = x217 * x567 + x551
    x626 = x4 * (x217 * x564 - x5 * (x217 * x565 + x546) + x543)
    x627 = x4 * (x217 * x570 - x217 * x572)
    x628 = x316 * x514 + x319
    x629 = x3 * x628
    x630 = x316 * x517 + x323
    x631 = x28 * x630
    x632 = 2.0 * x631
    x633 = x316 * x506 + x332 - x5 * (x316 * x509 + x335)
    x634 = x50 * x633
    x635 = x28 * (x316 * x523 + x330)
    x636 = x316 * x535 + x337
    x637 = x28 * x636
    x638 = x316 * x539 + x345
    x639 = x316 * x531 + x347 - x5 * (x316 * x534 + x349)
    x640 = x50 * x639
    x641 = x316 * x548 + x358 + x524
    x642 = x28 * x641
    x643 = x316 * x552 + x373 + x518
    x644 = x3 * x643
    x645 = x316 * x544 + x377 - x5 * (x316 * x547 + x379 + x513) + x508
    x646 = x50 * x645
    x647 = x316 * x561 + x381
    x648 = x316 * x558 + x383 - x5 * (x316 * x559 + x385)
    x649 = x50 * x648
    x650 = x316 * x567 + x391 + x538
    x651 = x316 * x564 + x394 - x5 * (x316 * x565 + x396 + x533) + x530
    x652 = x50 * x651
    x653 = x316 * x573 + x404 + 2.0 * x551
    x654 = x316 * x570 + x407 - x5 * (x316 * x571 + x409 + 2.0 * x546) + 2.0 * x543
    x655 = x50 * x654
    x656 = x217 * x577 + x426 * x89
    x657 = x28 * (x217 * x578 + x430 * x89)
    x658 = x28 * (x217 * x582 + x440 * x89 + x581)
    x659 = x217 * x584 + x444 * x89 + x579
    x660 = x28 * (x217 * x586 + x452 * x89)
    x661 = x217 * x588 + x455 * x89
    x662 = x217 * x590 + x460 * x89 + 2.0 * x583
    x663 = x217 * x592 + x465 * x89 + x587
    x664 = x217 * x594 + x470 * x89
    x665 = x217 * x596 + x471
    x666 = x28 * (x217 * x597 + x474)
    x667 = x28 * (x217 * x601 + x484 + x600)
    x668 = x217 * x603 + x488 + x598
    x669 = x28 * (x217 * x605 + x491)
    x670 = x217 * x607 + x493
    x671 = x217 * x609 + x498 + 2.0 * x602
    x672 = x217 * x611 + x503 + x606
    x673 = x217 * x613 + x504
    x674 = x411 * x514 + x522
    x675 = x28 * (x411 * x517 + x528)
    x676 = x28 * (x217 * x617 + x537 + x616)
    x677 = x217 * x518 + x217 * x619 + x541
    x678 = x28 * (x411 * x548 + x550)
    x679 = x411 * x552 + x556
    x680 = x217 * x623 + x563 + 2.0 * x618
    x681 = x217 * x625 + x569 + x621
    x682 = x411 * x573 + x576
    x683 = x28 * (x217 * x636 + x635)
    x684 = x217 * x638 + x631
    x685 = x217 * x642
    x686 = x217 * x647 + 2.0 * x637
    x687 = x217 * x650 + x642
    x688 = x316 * x628 + x521 * x89
    x689 = x28 * (x316 * x630 + x527 * x89)
    x690 = x28 * (x316 * x636 + x536 * x89)
    x691 = x316 * x638 + x540 * x89
    x692 = x28 * (x316 * x641 + x549 * x89 + x635)
    x693 = x316 * x643 + x555 * x89 + x631
    x694 = x316 * x647 + x562 * x89
    x695 = x316 * x650 + x568 * x89 + x637
    x696 = x316 * x653 + x575 * x89 + 2.0 * x642

    # 126 item(s)
    return numpy.array(
        [
            x21
            * (
                x3 * x88
                + x4 * (x3 * x86 + x40 * x79 - x5 * x90)
                - x5 * (x3 * x83 + x4 * (-x42 * x5 + x90) + x52 * x97)
                + x52 * x93
            )
            + x3
            * (
                x3
                * (
                    x3 * (x3 * (x46 + x48) + x51 + x52 * x57)
                    + x4 * (-x32 * x5 + x42)
                    + x52 * x63
                )
                + x52 * x78
                + x89 * (-x5 * x83 + x88)
            )
            + x52
            * (
                x28 * (x3 * x77 + x4 * (2.0 * x10 * x14 * x3 * x34 * x4 * x9 - x98))
                + x3 * x78
                + x89 * (-x5 * x97 + x93)
            ),
            x21
            * (
                x116 * x28
                + x139 * x3
                + x4 * (-x141 * x5 + x143 + x145 * x3)
                - x5 * (x113 * x28 + x135 * x3 + x4 * (-x122 * x5 + x141))
            )
            + x28 * (x109 * x3 + x89 * (-x113 * x5 + x116))
            + x3
            * (
                x109 * x28
                + x3
                * (
                    x108 * x28
                    + x3 * (x130 + x131 + x3 * (x123 + x127))
                    + x4 * (-x119 * x5 + x122)
                )
                + x89 * (-x135 * x5 + x139)
            ),
            x21
            * (
                x158 * x28
                + x171 * x3
                + x4 * (-x173 * x5 + x174 + x175 * x3)
                - x5 * (x155 * x28 + x168 * x3 + x4 * (-x162 * x5 + x173))
            )
            + x28 * (x153 * x3 + x89 * (-x155 * x5 + x158))
            + x3
            * (
                x153 * x28
                + x3
                * (
                    x152 * x28
                    + x3 * (x163 * x3 + x165 + x3 * (x126 * x147 + x163))
                    + x4 * (-x160 * x5 + x162)
                )
                + x89 * (-x168 * x5 + x171)
            ),
            x21
            * (
                x192 * x3
                + x4 * (-x186 * x3 * x5 + x190 * x3)
                - x5 * (x188 * x3 + x4 * (-x177 * x3 * x5 + x186 * x3))
            )
            + x3
            * (
                x3 * (x3 * (x183 + x184) + x4 * (x177 * x3 - x181))
                + x89 * (-x188 * x5 + x192)
            ),
            x21
            * (
                x200 * x3
                + x4 * (2.0 * x10 * x100 * x14 * x147 * x3 * x34 * x4 * x9 - x196 * x98)
                - x5
                * (
                    x198 * x3
                    + x4
                    * (2.0 * x10 * x100 * x14 * x147 * x15 * x3 * x4 * x9 - x103 * x147)
                )
            )
            + x3
            * (
                x3
                * (
                    x3 * (x106 * x196 * x44 + x195)
                    + x4 * (2.0 * x10 * x100 * x14 * x147 * x3 * x4 * x7 * x9 - x194 * x3)
                )
                + x89 * (-x198 * x5 + x200)
            ),
            x21
            * (
                x216 * x3
                + x4 * (-x210 * x3 * x5 + x214 * x3)
                - x5 * (x212 * x3 + x4 * (-x202 * x3 * x5 + x210 * x3))
            )
            + x3
            * (
                x3 * (x3 * (x207 + x208) + x4 * (x202 * x3 - x205 * x3))
                + x89 * (-x212 * x5 + x216)
            ),
            x3
            * (
                x234 * x52
                + x3 * (0.5 * x227 + x231 * x52 + x3 * (x224 + x225))
                + x4 * (-x220 * x5 + x223)
            )
            + x52
            * (x234 * x3 + x28 * (x217 * x76 + 0.5 * x239) + x4 * (-x236 * x5 + x238))
            + x89
            * (
                x223 * x3
                + x238 * x52
                + 0.5 * x240
                - x5 * (x220 * x3 + x236 * x52 + 0.5 * x241)
            ),
            x28 * (x252 * x3 + x4 * (x243 * x3 - x247 * x3))
            + x3
            * (
                x252 * x28
                + x3 * (x263 * x3 + 0.5 * x267 + x3 * (x263 + x266 * x3))
                + x4 * (-x257 * x5 + x262)
            )
            + x89
            * (
                x243 * x28 * x3
                + x262 * x3
                + 0.5 * x271
                - x5 * (x253 * x3 + x257 * x3 + 0.5 * x272)
            ),
            x28
            * (
                x274 * x3
                + x4 * (2.0 * x10 * x14 * x147 * x15 * x217 * x3 * x4 * x9 - x148 * x229)
            )
            + x3
            * (
                x274 * x28
                + x3 * (x163 * x229 + 0.5 * x282 + x3 * (x229 * x281 + x280))
                + x4 * (-x276 * x5 + x279)
            )
            + x89
            * (
                x161 * x229
                + x279 * x3
                + 0.5 * x283
                - x5 * (x159 * x229 + x276 * x3 + 0.5 * x284)
            ),
            x3 * (x3 * (x295 * x75 + 0.5 * x296) + x4 * (x288 * x3 - x292 * x3))
            + x89 * (x288 * x75 + 0.5 * x298 - x5 * (x291 * x75 + 0.5 * x299)),
            x3 * (x3 * (x306 * x75 + 0.5 * x307) + x4 * (x3 * x301 - x3 * x304))
            + x89 * (x301 * x75 + 0.5 * x311 - x5 * (x303 * x75 + 0.5 * x312)),
            x3 * (x3 * (x207 * x217 + 0.5 * x313) + x4 * (x202 * x217 * x3 - x205 * x229))
            + x89 * (x213 * x217 + 0.5 * x314 - x5 * (x209 * x217 + 0.5 * x315)),
            x3
            * (
                x3 * (x3 * (x316 * x46 + x316 * x48) + x320 + x322 * x52)
                + x325 * x52
                + x4 * (-x317 * x5 + x318)
            )
            + x52 * (x28 * (x316 * x76 + x331) + x3 * x325 + x4 * (-x327 * x5 + x329))
            + x89
            * (x3 * x318 + x329 * x52 + x333 - x5 * (x3 * x317 + x327 * x52 + x336)),
            x28
            * (
                x3 * x339
                + x4 * (2.0 * x10 * x100 * x14 * x15 * x3 * x316 * x4 * x9 - x103 * x316)
            )
            + x3
            * (
                x28 * x339
                + x3 * (x131 * x316 + x3 * (x127 * x316 + x344) + x346)
                + x4 * (-x341 * x5 + x343)
            )
            + x89
            * (x138 * x316 + x3 * x343 + x348 - x5 * (x134 * x316 + x3 * x341 + x350)),
            x28 * (x3 * x360 + x4 * (x3 * x351 - x3 * x354))
            + x3
            * (
                x28 * x360
                + x3 * (x3 * (x369 + x371) + x374 + x375)
                + x4 * (-x364 * x5 + x368)
            )
            + x89
            * (x28 * x3 * x351 + x3 * x368 + x378 - x5 * (x3 * x361 + x3 * x364 + x380)),
            x3 * (x3 * (x183 * x316 + x382) + x4 * (x177 * x3 * x316 - x181 * x316))
            + x89 * (x189 * x316 + x384 - x5 * (x185 * x316 + x386)),
            x3 * (x3 * (x390 * x75 + x392) + x4 * (x3 * x387 - x3 * x389))
            + x89 * (x387 * x75 + x395 - x5 * (x388 * x75 + x397)),
            x3 * (x3 * (x403 + x405) + x4 * (x3 * x399 - x3 * x401))
            + x89 * (x399 * x75 + x408 - x5 * (x400 * x75 + x410)),
            x3 * (x3 * (x3 * x422 + 2.0 * x425) + x426 * x50 + x429 * x52)
            + x4 * (x3 * x412 + 2.0 * x414 - x5 * (x3 * x416 + 2.0 * x420))
            + x52 * (x3 * x428 + x3 * x429 + x430 * x50),
            x28 * (x439 * x75 + x440 * x50)
            + x3 * (x3 * x441 + x3 * (x3 * x443 + x441) + x444 * x50)
            + x4 * (x3 * x434 + x432 - x5 * (x3 * x438 + x436)),
            x28 * (x451 * x75 + x452 * x50)
            + x3 * (x3 * x453 + x3 * (x3 * x454 + x453) + x455 * x50)
            + x4 * (x3 * x447 + x446 - x5 * (x3 * x450 + x449)),
            x3 * (x459 * x75 + x460 * x50) + x4 * (x3 * x456 - x3 * x458),
            x3 * (x464 * x75 + x465 * x50) + x4 * (x3 * x461 - x3 * x463),
            x3 * (x469 * x75 + x470 * x50) + x4 * (x3 * x466 - x3 * x468),
            x3 * (x3 * (x224 * x316 + x225 * x316) + 0.5 * x471 + x473 * x52)
            + x4 * (x221 * x316 + x222 * x316 - x5 * (x218 * x316 + x219 * x316))
            + x52 * (x229 * x321 + x3 * x473 + 0.5 * x474),
            x28 * (x483 * x75 + 0.5 * x484)
            + x3 * (x3 * x485 + x3 * (x3 * x487 + x485) + 0.5 * x488)
            + x4 * (x3 * x478 + x476 - x5 * (x3 * x482 + x480)),
            x28 * (x217 * x357 + 0.5 * x491)
            + x3 * (x217 * x375 + x3 * (x217 * x371 + x492) + 0.5 * x493)
            + x4 * (x217 * x367 + x489 - x5 * (x217 * x363 + x490)),
            x3 * (x497 * x75 + 0.5 * x498) + x4 * (x3 * x494 - x3 * x496),
            x3 * (x502 * x75 + 0.5 * x503) + x4 * (x3 * x499 - x3 * x501),
            x3 * (x217 * x403 + 0.5 * x504) + x4 * (x217 * x3 * x399 - x229 * x401),
            x3 * (x3 * (x515 + x519) + x52 * x526 + x522)
            + x4 * (x3 * x506 - x5 * (x3 * x509 + 2.0 * x513) + 2.0 * x508)
            + x52 * (x3 * x524 + x3 * x526 + x528),
            x28 * (x535 * x75 + x537)
            + x3 * (x3 * x538 + x3 * (x3 * x539 + x538) + x541)
            + x4 * (x3 * x531 - x5 * (x3 * x534 + x533) + x530),
            x28 * (x548 * x75 + x550)
            + x3 * (x3 * (x551 + x553) + x556 + x557)
            + x4 * (x3 * x544 - x5 * (x3 * x547 + x546) + x543),
            x3 * (x561 * x75 + x563) + x4 * (x3 * x558 - x3 * x560),
            x3 * (x567 * x75 + x569) + x4 * (x3 * x564 - x3 * x566),
            x3 * (x574 + x576) + x4 * (x3 * x570 - x3 * x572),
            x3 * (x3 * x577 + 2.0 * x579) + x50 * x580 + x52 * (x3 * x578 + x581),
            x3 * x583 + x3 * (x3 * x584 + x583) + x50 * x585,
            x3 * x587 + x3 * (x3 * x588 + x587) + x50 * x589,
            x50 * x591 + x590 * x75,
            x50 * x593 + x592 * x75,
            x50 * x595 + x594 * x75,
            x3 * (x3 * x596 + 2.0 * x598) + x50 * x599 + x52 * (x3 * x597 + x600),
            x3 * x602 + x3 * (x3 * x603 + x602) + x50 * x604,
            x3 * x606 + x3 * (x3 * x607 + x606) + x50 * x608,
            x50 * x610 + x609 * x75,
            x50 * x612 + x611 * x75,
            x50 * x614 + x613 * x75,
            x3 * (x217 * x515 + x217 * x519) + x52 * (x217 * x525 + x616) + 0.5 * x615,
            x3 * x618 + x3 * (x3 * x619 + x618) + 0.5 * x620,
            x217 * x557 + x3 * (x217 * x553 + x621) + 0.5 * x622,
            x623 * x75 + 0.5 * x624,
            x625 * x75 + 0.5 * x626,
            x217 * x574 + 0.5 * x627,
            x3 * (x629 + x632) + x52 * (x3 * x630 + x635) + x634,
            x3 * x637 + x3 * (x3 * x638 + x637) + x640,
            x3 * x642 + x3 * (x642 + x644) + x646,
            x647 * x75 + x649,
            x650 * x75 + x652,
            x653 * x75 + x655,
            x3 * x656 + 2.0 * x657,
            x3 * x659 + x658,
            x3 * x661 + x660,
            x3 * x662,
            x3 * x663,
            x3 * x664,
            x3 * x665 + 2.0 * x666,
            x3 * x668 + x667,
            x3 * x670 + x669,
            x3 * x671,
            x3 * x672,
            x3 * x673,
            x3 * x674 + 2.0 * x675,
            x3 * x677 + x676,
            x3 * x679 + x678,
            x3 * x680,
            x3 * x681,
            x3 * x682,
            x217 * x629 + x217 * x632,
            x3 * x684 + x683,
            x217 * x644 + x685,
            x3 * x686,
            x3 * x687,
            x229 * x653,
            x3 * x688 + 2.0 * x689,
            x3 * x691 + x690,
            x3 * x693 + x692,
            x3 * x694,
            x3 * x695,
            x3 * x696,
            x21 * x580 + x217 * x656,
            x21 * x585 + x217 * x659 + x657,
            x21 * x589 + x217 * x661,
            x21 * x591 + x217 * x662 + 2.0 * x658,
            x21 * x593 + x217 * x663 + x660,
            x21 * x595 + x217 * x664,
            x217 * x665 + x599 * x89,
            x217 * x668 + x604 * x89 + x666,
            x217 * x670 + x608 * x89,
            x217 * x671 + x610 * x89 + 2.0 * x667,
            x217 * x672 + x612 * x89 + x669,
            x217 * x673 + x614 * x89,
            x217 * x674 + x615,
            x217 * x677 + x620 + x675,
            x217 * x679 + x622,
            x217 * x680 + x624 + 2.0 * x676,
            x217 * x681 + x626 + x678,
            x217 * x682 + x627,
            x411 * x628 + x634,
            x217 * x631 + x217 * x684 + x640,
            x411 * x643 + x646,
            x217 * x686 + x649 + 2.0 * x683,
            x217 * x687 + x652 + x685,
            x411 * x653 + x655,
            x217 * x688,
            x217 * x691 + x689,
            x217 * x693,
            x217 * x694 + 2.0 * x690,
            x217 * x695 + x692,
            x217 * x696,
            x21 * x633 + x316 * x688,
            x21 * x639 + x316 * x691,
            x21 * x645 + x316 * x693 + x689,
            x21 * x648 + x316 * x694,
            x21 * x651 + x316 * x695 + x690,
            x21 * x654 + x316 * x696 + 2.0 * x692,
        ]
    )


def _2center2el3d_53(a, A, b, B):
    """Cartesian (h|f) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a ** (-1.0)
    x5 = b ** (-1.0)
    x6 = -x2 - B[0]
    x7 = b * x1
    x8 = a * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(6, x8)
    x10 = 17.4934183276249
    x11 = x0 ** (-1.5) * x10
    x12 = 2.0 * x11
    x13 = x12 * x5
    x14 = x13 * x9
    x15 = x0 ** (-0.5)
    x16 = boys(5, x8)
    x17 = 0.5 * x5
    x18 = x17 * (2.0 * x10 * x15 * x16 * x4 * x5 - x14)
    x19 = boys(7, x8)
    x20 = x6**2
    x21 = 2.0 * x4
    x22 = x10 * x15
    x23 = x22 * x5
    x24 = x21 * x23
    x25 = x20 * x24
    x26 = x19 * x25
    x27 = x18 + x26
    x28 = x27 * x6 + x5 * (2.0 * x10 * x15 * x16 * x4 * x5 * x6 - x14 * x6)
    x29 = x28 * x3
    x30 = (2.0 * a + 2.0 * b) ** (-1.0)
    x31 = x16 * x5
    x32 = x12 * x31
    x33 = boys(4, x8)
    x34 = x17 * (2.0 * x10 * x15 * x33 * x4 * x5 - x32)
    x35 = x24 * x9
    x36 = x20 * x35
    x37 = x34 + x36
    x38 = x30 * x37
    x39 = 3.0 * x38
    x40 = x29 + x39
    x41 = -2.0 * x10 * x15 * x33 * x4 * x5 * x6
    x42 = x37 * x6 + x5 * (-x32 * x6 - x41)
    x43 = x3 * x42
    x44 = x13 * x33
    x45 = boys(3, x8)
    x46 = -2.0 * x10 * x15 * x4 * x45 * x5
    x47 = x17 * (-x44 - x46)
    x48 = x22 * x31
    x49 = x21 * x48
    x50 = x20 * x49
    x51 = x47 + x50
    x52 = x30 * x51
    x53 = 3.0 * x52
    x54 = x43 + x53
    x55 = x13 * x19
    x56 = x17 * (2.0 * x10 * x15 * x4 * x5 * x9 - x55)
    x57 = boys(8, x8)
    x58 = x25 * x57
    x59 = x5 * (2.0 * x10 * x15 * x4 * x5 * x6 * x9 - x55 * x6) + x6 * (x56 + x58)
    x60 = x3 * x59
    x61 = x27 * x30
    x62 = 3.0 * x61
    x63 = x28 * x7
    x64 = 0.5 * x4
    x65 = x64 * (x42 - x63)
    x66 = x27 * x3
    x67 = x6 * x9
    x68 = 4.0 * x30 * x4
    x69 = x23 * x68
    x70 = x67 * x69
    x71 = x66 + x70
    x72 = 3.0 * x30
    x73 = x37 * x7
    x74 = x64 * (x51 - x73)
    x75 = 2.0 * x30
    x76 = x4 * x75
    x77 = x48 * x76
    x78 = x3 * x6
    x79 = x35 * x78
    x80 = x77 + x79
    x81 = x3 * x71 + x74 + x75 * x80
    x82 = x3 * x37
    x83 = x48 * x68
    x84 = x6 * x83
    x85 = x82 + x84
    x86 = x3 * x51
    x87 = x33 * x69
    x88 = x6 * x87
    x89 = x86 + x88
    x90 = x11 * x21
    x91 = x16 * x90
    x92 = x6 * x91
    x93 = x64 * (-x41 - x92)
    x94 = x3 * x77
    x95 = x3 * x80 + x93 + x94
    x96 = x3 * x81 + x4 * (-x7 * x85 + x89) + x75 * x95
    x97 = x5 * (2.0 * x10 * x15 * x4 * x45 * x5 * x6 - x44 * x6) + x51 * x6
    x98 = x64 * (-x42 * x7 + x97)
    x99 = x3 * x40 + x72 * x85 + x98
    x100 = x13 * x45
    x101 = boys(2, x8)
    x102 = x17 * (2.0 * x10 * x101 * x15 * x4 * x5 - x100)
    x103 = x21 * x33
    x104 = x103 * x23
    x105 = x104 * x20
    x106 = x102 + x105
    x107 = x106 * x6 + x5 * (2.0 * x10 * x101 * x15 * x4 * x5 * x6 - x100 * x6)
    x108 = x64 * (x107 - x7 * x97)
    x109 = x108 + x3 * x54 + x72 * x89
    x110 = 1.5 * x4
    x111 = x17 * (2.0 * x10 * x15 * x4 * x5 * boys(1, x8) - x101 * x13)
    x112 = x24 * x45
    x113 = x111 + x112 * x20
    x114 = x113 * x30
    x115 = x106 * x30
    x116 = 3.0 * x115 + x3 * x97
    x117 = x64 * (-x106 * x7 + x113)
    x118 = x23 * x76
    x119 = x118 * x45
    x120 = x104 * x78 + x119
    x121 = x117 + x120 * x75 + x3 * x89
    x122 = x64 * (x106 - x51 * x7)
    x123 = x118 * x33
    x124 = x123 + x49 * x78
    x125 = x122 + x124 * x75 + x3 * x85
    x126 = x103 * x11
    x127 = x64 * (-x126 - x46)
    x128 = x3**2
    x129 = x128 * x49
    x130 = -x1 * (a * A[1] + b * B[1])
    x131 = -x130 - B[1]
    x132 = x5 * (2.0 * x10 * x131 * x15 * x16 * x4 * x5 - x131 * x14)
    x133 = x131 * x26 + 0.5 * x132
    x134 = x133 * x3
    x135 = x131 * x6
    x136 = x69 * x9
    x137 = x135 * x136
    x138 = x134 + x137
    x139 = -2.0 * x10 * x131 * x15 * x33 * x4 * x5
    x140 = x5 * (-x131 * x32 - x139)
    x141 = x131 * x36 + 0.5 * x140
    x142 = x141 * x3
    x143 = x135 * x83
    x144 = x142 + x143
    x145 = x5 * (2.0 * x10 * x131 * x15 * x4 * x5 * x9 - x131 * x55)
    x146 = x131 * x58 + 0.5 * x145
    x147 = x146 * x3
    x148 = x135 * x19
    x149 = x148 * x69
    x150 = x133 * x7
    x151 = x64 * (x141 - x150)
    x152 = x118 * x9
    x153 = x131 * x152
    x154 = x19 * x24
    x155 = x154 * x78
    x156 = x131 * x155
    x157 = x153 + x156
    x158 = x9 * x90
    x159 = x135 * x158
    x160 = x64 * (2.0 * x10 * x131 * x15 * x16 * x4 * x5 * x6 - x159)
    x161 = x153 * x3
    x162 = x157 * x3 + x160 + x161
    x163 = x131 * x77
    x164 = x131 * x35
    x165 = x164 * x78
    x166 = x163 + x165
    x167 = x123 * x131
    x168 = x131 * x49
    x169 = x168 * x78
    x170 = x167 + x169
    x171 = x131 * x91
    x172 = x64 * (-x139 - x171)
    x173 = x128 * x164
    x174 = x172 + x173
    x175 = x162 * x3 + x174 * x30 + x4 * (-x166 * x7 + x170)
    x176 = x5 * (2.0 * x10 * x131 * x15 * x4 * x45 * x5 - x131 * x44)
    x177 = x131 * x50 + 0.5 * x176
    x178 = x64 * (-x141 * x7 + x177)
    x179 = x138 * x3 + x166 * x75 + x178
    x180 = x5 * (2.0 * x10 * x101 * x131 * x15 * x4 * x5 - x100 * x131)
    x181 = x105 * x131 + 0.5 * x180
    x182 = x64 * (-x177 * x7 + x181)
    x183 = x144 * x3 + x170 * x75 + x182
    x184 = x135 * x87
    x185 = x177 * x3 + x184
    x186 = x45 * x69
    x187 = x135 * x186
    x188 = x64 * (2.0 * x10 * x131 * x15 * x4 * x45 * x5 * x6 - x126 * x135)
    x189 = x167 * x3 + x170 * x3 + x188
    x190 = x131 * x92
    x191 = x64 * (2.0 * x10 * x131 * x15 * x33 * x4 * x5 * x6 - x190)
    x192 = x131 * x94 + x166 * x3 + x191
    x193 = -x1 * (a * A[2] + b * B[2])
    x194 = -x193 - B[2]
    x195 = x5 * (2.0 * x10 * x15 * x16 * x194 * x4 * x5 - x14 * x194)
    x196 = 0.5 * x195
    x197 = x194 * x26 + x196
    x198 = x197 * x3
    x199 = x194 * x6
    x200 = x136 * x199
    x201 = x198 + x200
    x202 = -2.0 * x10 * x15 * x194 * x33 * x4 * x5
    x203 = x5 * (-x194 * x32 - x202)
    x204 = 0.5 * x203
    x205 = x194 * x36 + x204
    x206 = x205 * x3
    x207 = x199 * x83
    x208 = x206 + x207
    x209 = x5 * (2.0 * x10 * x15 * x194 * x4 * x5 * x9 - x194 * x55)
    x210 = 0.5 * x209
    x211 = x194 * x58 + x210
    x212 = x211 * x3
    x213 = x19 * x199
    x214 = x213 * x69
    x215 = x197 * x7
    x216 = x64 * (x205 - x215)
    x217 = x152 * x194
    x218 = x155 * x194
    x219 = x217 + x218
    x220 = x158 * x199
    x221 = x64 * (2.0 * x10 * x15 * x16 * x194 * x4 * x5 * x6 - x220)
    x222 = x217 * x3 + x219 * x3 + x221
    x223 = x194 * x77
    x224 = x194 * x35
    x225 = x224 * x78
    x226 = x223 + x225
    x227 = x123 * x194
    x228 = x194 * x49
    x229 = x228 * x78
    x230 = x227 + x229
    x231 = x194 * x91
    x232 = x64 * (-x202 - x231)
    x233 = x128 * x224
    x234 = x232 + x233
    x235 = x222 * x3 + x234 * x30 + x4 * (-x226 * x7 + x230)
    x236 = x5 * (2.0 * x10 * x15 * x194 * x4 * x45 * x5 - x194 * x44)
    x237 = 0.5 * x236
    x238 = x194 * x50 + x237
    x239 = x64 * (-x205 * x7 + x238)
    x240 = x201 * x3 + x226 * x75 + x239
    x241 = x5 * (2.0 * x10 * x101 * x15 * x194 * x4 * x5 - x100 * x194)
    x242 = 0.5 * x241
    x243 = x105 * x194 + x242
    x244 = x64 * (-x238 * x7 + x243)
    x245 = x208 * x3 + x230 * x75 + x244
    x246 = x199 * x87
    x247 = x238 * x3 + x246
    x248 = x186 * x199
    x249 = x64 * (2.0 * x10 * x15 * x194 * x4 * x45 * x5 * x6 - x126 * x199)
    x250 = x227 * x3 + x230 * x3 + x249
    x251 = x64 * (2.0 * x10 * x15 * x194 * x33 * x4 * x5 * x6 - x194 * x92)
    x252 = x194 * x94 + x226 * x3 + x251
    x253 = x131**2
    x254 = x253 * x49 + x47
    x255 = x253 * x35 + x34
    x256 = x255 * x7
    x257 = x256 * x3
    x258 = x24 * x253
    x259 = x19 * x258
    x260 = x18 + x259
    x261 = x128 * x260
    x262 = x64 * (x254 - x256)
    x263 = x261 + x262
    x264 = x263 * x3 + x4 * (x254 * x3 - x257)
    x265 = x102 + x104 * x253
    x266 = x64 * (-x254 * x7 + x265)
    x267 = x128 * x255 + x266
    x268 = x111 + x112 * x253
    x269 = x64 * (-x265 * x7 + x268)
    x270 = x128 * x254 + x269
    x271 = x255 * x30
    x272 = x260 * x78
    x273 = x271 + x272
    x274 = x254 * x30
    x275 = x255 * x6
    x276 = x275 * x3
    x277 = x274 + x276
    x278 = x260 * x30
    x279 = x258 * x57
    x280 = x279 + x56
    x281 = x280 * x78
    x282 = x6 * x7
    x283 = x260 * x282
    x284 = x64 * (x255 * x6 - x283)
    x285 = x278 * x3
    x286 = x64 * (x254 * x6 - x275 * x7)
    x287 = x271 * x3
    x288 = x273 * x3 + x286 + x287
    x289 = x254 * x6
    x290 = x64 * (x265 * x6 - x289 * x7)
    x291 = x254 * x3
    x292 = x291 * x30
    x293 = x277 * x3 + x290 + x292
    x294 = x268 * x30
    x295 = x265 * x6
    x296 = x265 * x30
    x297 = x291 * x6 + x296
    x298 = x131 * x194
    x299 = x158 * x298
    x300 = x64 * (2.0 * x10 * x131 * x15 * x16 * x194 * x4 * x5 - x299)
    x301 = x154 * x298
    x302 = x128 * x301 + x300
    x303 = x3 * x302 + x4 * (
        2.0 * x10 * x131 * x15 * x16 * x194 * x3 * x4 * x5 - x299 * x3
    )
    x304 = x64 * (2.0 * x10 * x131 * x15 * x194 * x33 * x4 * x5 - x171 * x194)
    x305 = x173 * x194 + x304
    x306 = x64 * (2.0 * x10 * x131 * x15 * x194 * x4 * x45 * x5 - x126 * x298)
    x307 = x129 * x298 + x306
    x308 = x152 * x298
    x309 = x155 * x298 + x308
    x310 = x165 * x194 + x298 * x77
    x311 = x19 * x298
    x312 = x118 * x311
    x313 = x24 * x57
    x314 = x148 * x194
    x315 = x64 * (2.0 * x10 * x131 * x15 * x194 * x4 * x5 * x6 * x9 - x314 * x90)
    x316 = x64 * (2.0 * x10 * x131 * x15 * x16 * x194 * x4 * x5 * x6 - x159 * x194)
    x317 = x3 * x308 + x3 * x309 + x316
    x318 = x64 * (2.0 * x10 * x131 * x15 * x194 * x33 * x4 * x5 * x6 - x190 * x194)
    x319 = x298 * x94 + x3 * x310 + x318
    x320 = x168 * x194
    x321 = x123 * x298 + x320 * x78
    x322 = x104 * x131
    x323 = x194**2
    x324 = x323 * x49 + x47
    x325 = x323 * x35 + x34
    x326 = x325 * x7
    x327 = x24 * x323
    x328 = x18 + x19 * x327
    x329 = x128 * x328
    x330 = x64 * (x324 - x326)
    x331 = x329 + x330
    x332 = x3 * x331 + x4 * (x3 * x324 - x3 * x326)
    x333 = x128 * x325
    x334 = x102 + x104 * x323
    x335 = x64 * (-x324 * x7 + x334)
    x336 = x333 + x335
    x337 = x111 + x112 * x323
    x338 = x64 * (-x334 * x7 + x337)
    x339 = x128 * x324 + x338
    x340 = x30 * x325
    x341 = x328 * x78
    x342 = x340 + x341
    x343 = x30 * x324
    x344 = x325 * x6
    x345 = x3 * x344
    x346 = x343 + x345
    x347 = x30 * x328
    x348 = x327 * x57 + x56
    x349 = x348 * x78
    x350 = x282 * x328
    x351 = x64 * (x325 * x6 - x350)
    x352 = x3 * x347
    x353 = x64 * (x324 * x6 - x344 * x7)
    x354 = x3 * x340
    x355 = x3 * x342 + x353 + x354
    x356 = x324 * x6
    x357 = x64 * (x334 * x6 - x356 * x7)
    x358 = x3 * x324
    x359 = x30 * x358
    x360 = x3 * x346 + x357 + x359
    x361 = x30 * x337
    x362 = x334 * x6
    x363 = x30 * x334
    x364 = x358 * x6 + x363
    x365 = x131 * x255 + x140
    x366 = x131 * x260 + x132
    x367 = x366 * x7
    x368 = x3 * x367
    x369 = x131 * x280 + x145
    x370 = x128 * x369
    x371 = x64 * (x365 - x367)
    x372 = x128 * x366
    x373 = x131 * x254 + x176
    x374 = x64 * (-x365 * x7 + x373)
    x375 = x372 + x374
    x376 = x128 * x365
    x377 = x131 * x265 + x180
    x378 = x64 * (-x373 * x7 + x377)
    x379 = x376 + x378
    x380 = x204 + x224 * x253
    x381 = x194 * x259 + x196
    x382 = x381 * x7
    x383 = x194 * x279 + x210
    x384 = x64 * (x380 - x382)
    x385 = x228 * x253 + x237
    x386 = x64 * (-x380 * x7 + x385)
    x387 = x128 * x381 + x386
    x388 = x104 * x194
    x389 = x242 + x253 * x388
    x390 = x64 * (-x385 * x7 + x389)
    x391 = x128 * x380 + x390
    x392 = x131 * x328
    x393 = x392 * x7
    x394 = x64 * (x131 * x325 - x393)
    x395 = x131 * x348
    x396 = x131 * x325
    x397 = x64 * (x131 * x324 - x396 * x7)
    x398 = x131 * x329 + x397
    x399 = x131 * x324
    x400 = x64 * (x131 * x334 - x399 * x7)
    x401 = x131 * x333 + x400
    x402 = x194 * x325 + x203
    x403 = x194 * x328 + x195
    x404 = x403 * x7
    x405 = x194 * x348 + x209
    x406 = x128 * x405
    x407 = x64 * (x402 - x404)
    x408 = x128 * x403
    x409 = x194 * x324 + x236
    x410 = x64 * (-x402 * x7 + x409)
    x411 = x408 + x410
    x412 = x128 * x402
    x413 = x194 * x334 + x241
    x414 = x64 * (-x409 * x7 + x413)
    x415 = x412 + x414
    x416 = -x130 - A[1]
    x417 = x29 * x416
    x418 = x39 * x416
    x419 = x417 + x418
    x420 = x416 * x43
    x421 = x416 * x51
    x422 = x420 + x421 * x72
    x423 = x416 * x60
    x424 = x416 * x62
    x425 = x416 * x63
    x426 = x4 * (x416 * x42 - x425)
    x427 = x416 * x66
    x428 = x416 * x70
    x429 = x427 + x428
    x430 = x416 * x73
    x431 = x4 * (x416 * x51 - x430)
    x432 = x416 * x77
    x433 = x416 * x79
    x434 = x432 + x433
    x435 = x3 * x429 + 0.5 * x431 + x434 * x75
    x436 = x416 * x82 + x416 * x84
    x437 = x416 * x86 + x416 * x88
    x438 = x4 * (2.0 * x10 * x15 * x33 * x4 * x416 * x5 * x6 - x416 * x92)
    x439 = x3 * x416
    x440 = x4 * (x107 * x416 - x416 * x7 * x97)
    x441 = x4 * (-x416 * x42 * x7 + x416 * x97)
    x442 = x133 * x416
    x443 = x38 + x442
    x444 = x6 * x77
    x445 = x35 * x6
    x446 = x131 * x416 * x445
    x447 = x444 + x446
    x448 = x447 * x75
    x449 = x3 * x443 + x448
    x450 = x141 * x416
    x451 = x450 + x52
    x452 = x123 * x6
    x453 = x49 * x6
    x454 = x131 * x453
    x455 = x416 * x454
    x456 = x452 + x455
    x457 = x456 * x75
    x458 = x3 * x451 + x457
    x459 = x146 * x416
    x460 = x459 + x61
    x461 = x118 * x67
    x462 = x148 * x24
    x463 = x416 * x462
    x464 = x461 + x463
    x465 = x464 * x75
    x466 = x4 * (-x443 * x7 + x451)
    x467 = x164 * x416
    x468 = x467 + x77
    x469 = x30 * x468
    x470 = x3 * x464 + x469
    x471 = x4 * (-x447 * x7 + x456)
    x472 = x3 * x469 + x3 * x470 + 0.5 * x471
    x473 = x123 + x168 * x416
    x474 = x30 * x473
    x475 = x3 * x447 + x474
    x476 = x119 + x322 * x416
    x477 = x30 * x476
    x478 = x3 * x456 + x477
    x479 = x4 * (-x473 * x7 + x476)
    x480 = x115 + x177 * x416
    x481 = x4 * (x114 + x181 * x416 - x480 * x7)
    x482 = x4 * (-x451 * x7 + x480)
    x483 = x198 * x416 + x200 * x416
    x484 = x206 * x416 + x207 * x416
    x485 = x4 * (x205 * x416 - x215 * x416)
    x486 = x217 * x416
    x487 = x218 * x416 + x486
    x488 = x4 * (2.0 * x10 * x15 * x16 * x194 * x4 * x416 * x5 * x6 - x220 * x416)
    x489 = x217 * x439 + x3 * x487 + 0.5 * x488
    x490 = x223 * x416
    x491 = x225 * x416 + x490
    x492 = x227 * x416
    x493 = x229 * x416 + x492
    x494 = x4 * (2.0 * x10 * x15 * x194 * x33 * x4 * x416 * x5 - x231 * x416)
    x495 = x4 * (-x238 * x416 * x7 + x243 * x416)
    x496 = x4 * (-x205 * x416 * x7 + x238 * x416)
    x497 = x254 * x416
    x498 = x131 * x87
    x499 = x497 + x498
    x500 = x255 * x416
    x501 = x131 * x83
    x502 = x500 + x501
    x503 = x502 * x7
    x504 = x260 * x416
    x505 = x131 * x136
    x506 = x504 + x505
    x507 = x4 * (x499 - x503)
    x508 = x128 * x506 + 0.5 * x507
    x509 = x30 * x502
    x510 = x504 * x6
    x511 = x137 + x510
    x512 = x3 * x511 + x509
    x513 = x30 * x499
    x514 = x275 * x416
    x515 = x143 + x514
    x516 = x3 * x515 + x513
    x517 = x30 * x506
    x518 = x280 * x6
    x519 = x416 * x518
    x520 = x149 + x519
    x521 = x4 * (-x511 * x7 + x515)
    x522 = x184 + x289 * x416
    x523 = x4 * (x187 + x295 * x416 - x522 * x7)
    x524 = x4 * (-x515 * x7 + x522)
    x525 = x227 + x320 * x416
    x526 = x194 * x467 + x223
    x527 = x526 * x7
    x528 = x217 + x301 * x416
    x529 = x4 * (x525 - x527)
    x530 = x128 * x528 + 0.5 * x529
    x531 = x30 * x526
    x532 = x152 * x199
    x533 = x24 * x314
    x534 = x416 * x533 + x532
    x535 = x3 * x534 + x531
    x536 = x30 * x525
    x537 = x298 * x445
    x538 = x199 * x77 + x416 * x537
    x539 = x3 * x538 + x536
    x540 = x30 * x528
    x541 = x118 * x213
    x542 = x135 * x313
    x543 = x194 * x416 * x542 + x541
    x544 = x4 * (-x534 * x7 + x538)
    x545 = x298 * x453
    x546 = x123 * x199 + x416 * x545
    x547 = x104 * x6
    x548 = x4 * (x119 * x199 + x298 * x416 * x547 - x546 * x7)
    x549 = x4 * (-x538 * x7 + x546)
    x550 = x4 * (x324 * x416 - x326 * x416)
    x551 = x329 * x416 + 0.5 * x550
    x552 = x340 * x416
    x553 = x341 * x416 + x552
    x554 = x343 * x416
    x555 = x345 * x416 + x554
    x556 = x347 * x416
    x557 = x4 * (x325 * x416 * x6 - x350 * x416)
    x558 = x4 * (x334 * x416 * x6 - x356 * x416 * x7)
    x559 = x4 * (x324 * x416 * x6 - x344 * x416 * x7)
    x560 = x365 * x416
    x561 = 3.0 * x274
    x562 = x560 + x561
    x563 = x366 * x416
    x564 = 3.0 * x271
    x565 = x563 + x564
    x566 = x565 * x7
    x567 = x369 * x416
    x568 = 3.0 * x278
    x569 = x567 + x568
    x570 = x4 * (x562 - x566)
    x571 = 3.0 * x296 + x373 * x416
    x572 = x4 * (3.0 * x294 + x377 * x416 - x571 * x7)
    x573 = x4 * (-x562 * x7 + x571)
    x574 = x298 * x83
    x575 = x380 * x416 + x574
    x576 = x136 * x298
    x577 = x381 * x416 + x576
    x578 = x577 * x7
    x579 = x311 * x69
    x580 = x383 * x416 + x579
    x581 = x4 * (x575 - x578)
    x582 = x298 * x87
    x583 = x385 * x416 + x582
    x584 = x186 * x298
    x585 = x4 * (x389 * x416 - x583 * x7 + x584)
    x586 = x4 * (-x575 * x7 + x583)
    x587 = x343 + x396 * x416
    x588 = x340 + x392 * x416
    x589 = x588 * x7
    x590 = x347 + x395 * x416
    x591 = x4 * (x587 - x589)
    x592 = x131 * x334
    x593 = x363 + x399 * x416
    x594 = x4 * (x361 + x416 * x592 - x593 * x7)
    x595 = x4 * (-x587 * x7 + x593)
    x596 = x4 * (x402 * x416 - x404 * x416)
    x597 = x4 * (-x409 * x416 * x7 + x413 * x416)
    x598 = x4 * (-x402 * x416 * x7 + x409 * x416)
    x599 = -x193 - A[2]
    x600 = x29 * x599 + x39 * x599
    x601 = x43 * x599 + x53 * x599
    x602 = x4 * (x42 * x599 - x599 * x63)
    x603 = 0.5 * x602
    x604 = x599 * x66 + x599 * x70
    x605 = x4 * (x51 * x599 - x599 * x73)
    x606 = 0.5 * x605
    x607 = x599 * x77
    x608 = x599 * x79 + x607
    x609 = x3 * x604 + x606 + x608 * x75
    x610 = x599 * x82 + x599 * x84
    x611 = x599 * x86 + x599 * x88
    x612 = x4 * (2.0 * x10 * x15 * x33 * x4 * x5 * x599 * x6 - x599 * x92)
    x613 = 0.5 * x612
    x614 = x4 * (x107 * x599 - x599 * x7 * x97)
    x615 = 0.5 * x614
    x616 = x42 * x599
    x617 = x4 * (x599 * x97 - x616 * x7)
    x618 = 0.5 * x617
    x619 = x137 * x599
    x620 = x134 * x599 + x619
    x621 = x143 * x599
    x622 = x142 * x599 + x621
    x623 = x149 * x599
    x624 = x4 * (x141 * x599 - x150 * x599)
    x625 = 0.5 * x624
    x626 = x153 * x599
    x627 = x156 * x599 + x626
    x628 = x4 * (2.0 * x10 * x131 * x15 * x16 * x4 * x5 * x599 * x6 - x159 * x599)
    x629 = 0.5 * x628
    x630 = x161 * x599 + x3 * x627 + x629
    x631 = x163 * x599
    x632 = x165 * x599 + x631
    x633 = x167 * x599
    x634 = x169 * x599 + x633
    x635 = x4 * (2.0 * x10 * x131 * x15 * x33 * x4 * x5 * x599 - x171 * x599)
    x636 = 0.5 * x635
    x637 = x4 * (-x177 * x599 * x7 + x181 * x599)
    x638 = 0.5 * x637
    x639 = x4 * (-x141 * x599 * x7 + x177 * x599)
    x640 = 0.5 * x639
    x641 = x197 * x599 + x38
    x642 = x3 * x641
    x643 = x194 * x599
    x644 = x444 + x445 * x643
    x645 = x30 * x644
    x646 = 2.0 * x645
    x647 = x642 + x646
    x648 = x205 * x599 + x52
    x649 = x3 * x648
    x650 = x194 * x453
    x651 = x452 + x599 * x650
    x652 = x30 * x651
    x653 = 2.0 * x652
    x654 = x649 + x653
    x655 = x211 * x599 + x61
    x656 = x3 * x655
    x657 = x154 * x199
    x658 = x461 + x599 * x657
    x659 = x30 * x658
    x660 = 2.0 * x659
    x661 = x641 * x7
    x662 = x4 * (x648 - x661)
    x663 = 0.5 * x662
    x664 = x224 * x599 + x77
    x665 = x30 * x664
    x666 = x3 * x658
    x667 = x665 + x666
    x668 = x644 * x7
    x669 = x4 * (x651 - x668)
    x670 = 0.5 * x669
    x671 = x3 * x665
    x672 = x3 * x667 + x670 + x671
    x673 = x123 + x228 * x599
    x674 = x30 * x673
    x675 = x3 * x644 + x674
    x676 = x119 + x388 * x599
    x677 = x30 * x676
    x678 = x3 * x651 + x677
    x679 = x4 * (-x673 * x7 + x676)
    x680 = 0.5 * x679
    x681 = x115 + x238 * x599
    x682 = x4 * (x114 + x243 * x599 - x681 * x7)
    x683 = 0.5 * x682
    x684 = x4 * (-x648 * x7 + x681)
    x685 = 0.5 * x684
    x686 = x4 * (x254 * x599 - x256 * x599)
    x687 = 0.5 * x686
    x688 = x261 * x599 + x687
    x689 = x271 * x599
    x690 = x272 * x599 + x689
    x691 = x274 * x599
    x692 = x276 * x599 + x691
    x693 = x278 * x599
    x694 = x4 * (x255 * x599 * x6 - x283 * x599)
    x695 = 0.5 * x694
    x696 = x4 * (x265 * x599 * x6 - x289 * x599 * x7)
    x697 = 0.5 * x696
    x698 = x4 * (x254 * x599 * x6 - x275 * x599 * x7)
    x699 = 0.5 * x698
    x700 = x167 + x320 * x599
    x701 = x163 + x164 * x643
    x702 = x7 * x701
    x703 = x153 + x301 * x599
    x704 = x4 * (x700 - x702)
    x705 = 0.5 * x704
    x706 = x128 * x703 + x705
    x707 = x30 * x701
    x708 = x135 * x152
    x709 = x533 * x599 + x708
    x710 = x3 * x709 + x707
    x711 = x30 * x700
    x712 = x135 * x77 + x537 * x599
    x713 = x3 * x712 + x711
    x714 = x30 * x703
    x715 = x118 * x148
    x716 = x542 * x643 + x715
    x717 = x4 * (-x7 * x709 + x712)
    x718 = 0.5 * x717
    x719 = x123 * x135 + x545 * x599
    x720 = x4 * (x119 * x135 + x298 * x547 * x599 - x7 * x719)
    x721 = 0.5 * x720
    x722 = x4 * (-x7 * x712 + x719)
    x723 = 0.5 * x722
    x724 = x194 * x87 + x324 * x599
    x725 = x194 * x83 + x325 * x599
    x726 = x7 * x725
    x727 = x328 * x599
    x728 = x136 * x194 + x727
    x729 = x128 * x728
    x730 = x4 * (x724 - x726)
    x731 = 0.5 * x730
    x732 = x729 + x731
    x733 = x30 * x725
    x734 = x200 + x6 * x727
    x735 = x3 * x734
    x736 = x733 + x735
    x737 = x30 * x724
    x738 = x207 + x344 * x599
    x739 = x3 * x738
    x740 = x737 + x739
    x741 = x30 * x728
    x742 = x348 * x6
    x743 = x214 + x599 * x742
    x744 = x3 * x743
    x745 = x7 * x734
    x746 = x4 * (x738 - x745)
    x747 = 0.5 * x746
    x748 = x3 * x741
    x749 = x246 + x356 * x599
    x750 = x4 * (x248 + x362 * x599 - x7 * x749)
    x751 = 0.5 * x750
    x752 = x4 * (-x7 * x738 + x749)
    x753 = 0.5 * x752
    x754 = x4 * (x365 * x599 - x367 * x599)
    x755 = 0.5 * x754
    x756 = x4 * (-x373 * x599 * x7 + x377 * x599)
    x757 = 0.5 * x756
    x758 = x4 * (-x365 * x599 * x7 + x373 * x599)
    x759 = 0.5 * x758
    x760 = x274 + x380 * x599
    x761 = x271 + x381 * x599
    x762 = x7 * x761
    x763 = x278 + x383 * x599
    x764 = x4 * (x760 - x762)
    x765 = 0.5 * x764
    x766 = x296 + x385 * x599
    x767 = x4 * (x294 + x389 * x599 - x7 * x766)
    x768 = 0.5 * x767
    x769 = x4 * (-x7 * x760 + x766)
    x770 = 0.5 * x769
    x771 = x396 * x599 + x574
    x772 = x131 * x727 + x576
    x773 = x7 * x772
    x774 = x395 * x599 + x579
    x775 = x4 * (x771 - x773)
    x776 = 0.5 * x775
    x777 = x399 * x599 + x582
    x778 = x4 * (x584 + x592 * x599 - x7 * x777)
    x779 = 0.5 * x778
    x780 = x4 * (-x7 * x771 + x777)
    x781 = 0.5 * x780
    x782 = 3.0 * x343 + x402 * x599
    x783 = 3.0 * x340 + x403 * x599
    x784 = x7 * x783
    x785 = 3.0 * x347 + x405 * x599
    x786 = x128 * x785
    x787 = x4 * (x782 - x784)
    x788 = 0.5 * x787
    x789 = 3.0 * x363 + x409 * x599
    x790 = x4 * (3.0 * x361 + x413 * x599 - x7 * x789)
    x791 = 0.5 * x790
    x792 = x4 * (-x7 * x782 + x789)
    x793 = 0.5 * x792
    x794 = x416**2
    x795 = x108 + x42 * x794
    x796 = x117 + x51 * x794
    x797 = x30 * x796
    x798 = x28 * x794
    x799 = x798 + x98
    x800 = x122 + x37 * x794
    x801 = x30 * x800
    x802 = x59 * x794
    x803 = x65 + x802
    x804 = x27 * x794
    x805 = x74 + x804
    x806 = x30 * x805
    x807 = -x7 * x799 + x795
    x808 = x445 * x794
    x809 = x808 + x93
    x810 = x30 * x809
    x811 = x3 * x805 + 2.0 * x810
    x812 = -x7 * x800 + x796
    x813 = x30 * (x127 + x49 * x794)
    x814 = x30 * x421
    x815 = x182 + x416 * x451 + x814
    x816 = x188 + x416 * x452 + x416 * x456
    x817 = x75 * x816
    x818 = x38 * x416
    x819 = x178 + x416 * x443 + x818
    x820 = x191 + x416 * x447 + x432 * x6
    x821 = x75 * x820
    x822 = x416 * x61
    x823 = x151 + x416 * x460 + x822
    x824 = x416 * x461
    x825 = x160 + x416 * x464 + x824
    x826 = x75 * x825
    x827 = -x7 * x819 + x815
    x828 = x172 + x416 * x468 + x432
    x829 = x30 * x828
    x830 = x3 * x825 + x829
    x831 = -x7 * x820 + x816
    x832 = x205 * x794 + x244
    x833 = x249 + x650 * x794
    x834 = x30 * x833
    x835 = x197 * x794 + x239
    x836 = x194 * x808 + x251
    x837 = x30 * x836
    x838 = x211 * x794 + x216
    x839 = x221 + x657 * x794
    x840 = x30 * x839
    x841 = -x7 * x835 + x832
    x842 = x224 * x794 + x232
    x843 = x30 * x842
    x844 = x3 * x839 + x843
    x845 = -x7 * x836 + x833
    x846 = x269 + x416 * x499 + 2.0 * x477
    x847 = x30 * x846
    x848 = x290 + x416 * x515 + x457
    x849 = x266 + x416 * x502 + 2.0 * x474
    x850 = x30 * x849
    x851 = x286 + x416 * x511 + x448
    x852 = x262 + x416 * x506 + 2.0 * x469
    x853 = -x7 * x849 + x846
    x854 = x30 * x852
    x855 = x284 + x416 * x520 + x465
    x856 = -x7 * x851 + x848
    x857 = x306 + x416 * x525 + x492
    x858 = x30 * x857
    x859 = x199 * x432 + x318 + x416 * x538
    x860 = x304 + x416 * x526 + x490
    x861 = x30 * x860
    x862 = x316 + x416 * x532 + x416 * x534
    x863 = x300 + x416 * x528 + x486
    x864 = -x7 * x860 + x857
    x865 = x30 * x863
    x866 = x315 + x416 * x541 + x416 * x543
    x867 = -x7 * x862 + x859
    x868 = x324 * x794 + x338
    x869 = x30 * x868
    x870 = x344 * x794 + x357
    x871 = x325 * x794 + x335
    x872 = x30 * x871
    x873 = x328 * x794
    x874 = x353 + x6 * x873
    x875 = x330 + x873
    x876 = -x7 * x871 + x868
    x877 = x30 * x875
    x878 = x351 + x742 * x794
    x879 = -x7 * x874 + x870
    x880 = x378 + x416 * x562 + 3.0 * x513
    x881 = x374 + x416 * x565 + 3.0 * x509
    x882 = x7 * x881
    x883 = x371 + x416 * x569 + 3.0 * x517
    x884 = x880 - x882
    x885 = x390 + x416 * x575 + 2.0 * x536
    x886 = x386 + x416 * x577 + 2.0 * x531
    x887 = x7 * x886
    x888 = x384 + x416 * x580 + 2.0 * x540
    x889 = x885 - x887
    x890 = x400 + x416 * x587 + x554
    x891 = x397 + x416 * x588 + x552
    x892 = x7 * x891
    x893 = x394 + x416 * x590 + x556
    x894 = x890 - x892
    x895 = x402 * x794 + x414
    x896 = x403 * x794 + x410
    x897 = x7 * x896
    x898 = x405 * x794 + x407
    x899 = x895 - x897
    x900 = x4 * (x416 * x42 * x599 - x425 * x599)
    x901 = x427 * x599 + x428 * x599
    x902 = x4 * (x416 * x51 * x599 - x430 * x599)
    x903 = x432 * x599
    x904 = x52 * x599
    x905 = x450 * x599 + x904
    x906 = x452 * x599
    x907 = x455 * x599 + x906
    x908 = x75 * x907
    x909 = x38 * x599
    x910 = x442 * x599 + x909
    x911 = x444 * x599
    x912 = x446 * x599 + x911
    x913 = x75 * x912
    x914 = x599 * x61
    x915 = x459 * x599 + x914
    x916 = x461 * x599
    x917 = x463 * x599 + x916
    x918 = x75 * x917
    x919 = x4 * (-x7 * x910 + x905)
    x920 = x467 * x599 + x607
    x921 = x30 * x920
    x922 = x3 * x917 + x921
    x923 = x4 * (-x7 * x912 + x907)
    x924 = x416 * x651
    x925 = x4 * (x416 * x648 - x416 * x661)
    x926 = x416 * x665
    x927 = x416 * x666 + x926
    x928 = x4 * (x416 * x651 - x416 * x668)
    x929 = x497 * x599 + x498 * x599
    x930 = x30 * x929
    x931 = x514 * x599 + x621
    x932 = x500 * x599 + x501 * x599
    x933 = x30 * x932
    x934 = x510 * x599 + x619
    x935 = x504 * x599 + x505 * x599
    x936 = x4 * (-x7 * x932 + x929)
    x937 = x30 * x935
    x938 = x519 * x599 + x623
    x939 = x4 * (-x7 * x934 + x931)
    x940 = x416 * x700 + x677
    x941 = x30 * x940
    x942 = x416 * x712 + x652
    x943 = x416 * x701 + x674
    x944 = x30 * x943
    x945 = x416 * x709 + x645
    x946 = x416 * x703 + x665
    x947 = x4 * (-x7 * x943 + x940)
    x948 = x30 * x946
    x949 = x416 * x716 + x659
    x950 = x4 * (-x7 * x945 + x942)
    x951 = x416 * x737
    x952 = x416 * x733
    x953 = x4 * (x416 * x724 - x416 * x726)
    x954 = x416 * x741
    x955 = x4 * (x416 * x738 - x416 * x745)
    x956 = x560 * x599 + x561 * x599
    x957 = x563 * x599 + x564 * x599
    x958 = x7 * x957
    x959 = x567 * x599 + x568 * x599
    x960 = x4 * (x956 - x958)
    x961 = 2.0 * x711
    x962 = x416 * x760 + x961
    x963 = 2.0 * x707
    x964 = x416 * x761 + x963
    x965 = x7 * x964
    x966 = 2.0 * x714
    x967 = x416 * x763 + x966
    x968 = x4 * (x962 - x965)
    x969 = x416 * x771 + x737
    x970 = x416 * x772 + x733
    x971 = x7 * x970
    x972 = x416 * x774 + x741
    x973 = x4 * (x969 - x971)
    x974 = x4 * (x416 * x782 - x416 * x784)
    x975 = x599**2
    x976 = x108 + x42 * x975
    x977 = x117 + x51 * x975
    x978 = x30 * x977
    x979 = x28 * x975 + x98
    x980 = x122 + x37 * x975
    x981 = x30 * x980
    x982 = x59 * x975 + x65
    x983 = x3 * x982
    x984 = x27 * x975 + x74
    x985 = x30 * x984
    x986 = 3.0 * x985
    x987 = x7 * x979
    x988 = x976 - x987
    x989 = x64 * x988
    x990 = x3 * x984
    x991 = x445 * x975
    x992 = x93 + x991
    x993 = x30 * x992
    x994 = 2.0 * x993
    x995 = x990 + x994
    x996 = -x7 * x980 + x977
    x997 = x64 * x996
    x998 = x30 * (x127 + x49 * x975)
    x999 = x141 * x975 + x182
    x1000 = x188 + x454 * x975
    x1001 = x1000 * x30
    x1002 = 2.0 * x1001
    x1003 = x133 * x975 + x178
    x1004 = x131 * x991 + x191
    x1005 = x1004 * x30
    x1006 = 2.0 * x1005
    x1007 = x146 * x975 + x151
    x1008 = x160 + x462 * x975
    x1009 = x1008 * x30
    x1010 = 2.0 * x1009
    x1011 = -x1003 * x7 + x999
    x1012 = x1011 * x64
    x1013 = x164 * x975 + x172
    x1014 = x1013 * x30
    x1015 = x1008 * x3 + x1014
    x1016 = x1000 - x1004 * x7
    x1017 = x1016 * x64
    x1018 = x244 + x599 * x648 + x904
    x1019 = x249 + x599 * x651 + x906
    x1020 = x1019 * x30
    x1021 = 2.0 * x1020
    x1022 = x239 + x599 * x641 + x909
    x1023 = x251 + x599 * x644 + x911
    x1024 = x1023 * x30
    x1025 = 2.0 * x1024
    x1026 = x216 + x599 * x655 + x914
    x1027 = x1026 * x3
    x1028 = x221 + x599 * x658 + x916
    x1029 = x1028 * x30
    x1030 = 2.0 * x1029
    x1031 = x1022 * x7
    x1032 = x1018 - x1031
    x1033 = x1032 * x64
    x1034 = x232 + x599 * x664 + x607
    x1035 = x1034 * x30
    x1036 = x1028 * x3
    x1037 = x1035 + x1036
    x1038 = x1019 - x1023 * x7
    x1039 = x1038 * x64
    x1040 = x254 * x975 + x269
    x1041 = x1040 * x30
    x1042 = x275 * x975 + x290
    x1043 = x255 * x975 + x266
    x1044 = x1043 * x30
    x1045 = x260 * x975
    x1046 = x1045 * x6 + x286
    x1047 = x1045 + x262
    x1048 = x1040 - x1043 * x7
    x1049 = x1048 * x64
    x1050 = x1047 * x30
    x1051 = x284 + x518 * x975
    x1052 = x1042 - x1046 * x7
    x1053 = x1052 * x64
    x1054 = x306 + x599 * x700 + x633
    x1055 = x1054 * x30
    x1056 = x135 * x607 + x318 + x599 * x712
    x1057 = x304 + x599 * x701 + x631
    x1058 = x1057 * x30
    x1059 = x316 + x599 * x708 + x599 * x709
    x1060 = x300 + x599 * x703 + x626
    x1061 = x1054 - x1057 * x7
    x1062 = x1061 * x64
    x1063 = x1060 * x30
    x1064 = x315 + x599 * x715 + x599 * x716
    x1065 = x1056 - x1059 * x7
    x1066 = x1065 * x64
    x1067 = x338 + x599 * x724 + 2.0 * x677
    x1068 = x1067 * x30
    x1069 = x357 + x599 * x738 + x653
    x1070 = x335 + x599 * x725 + 2.0 * x674
    x1071 = x1070 * x30
    x1072 = x353 + x599 * x734 + x646
    x1073 = x330 + x599 * x728 + 2.0 * x665
    x1074 = x1067 - x1070 * x7
    x1075 = x1074 * x64
    x1076 = x1073 * x30
    x1077 = x351 + x599 * x743 + x660
    x1078 = x1077 * x3
    x1079 = x1072 * x7
    x1080 = x1069 - x1079
    x1081 = x1080 * x64
    x1082 = x1076 * x3
    x1083 = x365 * x975 + x378
    x1084 = x366 * x975 + x374
    x1085 = x1084 * x7
    x1086 = x369 * x975 + x371
    x1087 = x1083 - x1085
    x1088 = x1087 * x64
    x1089 = x390 + x599 * x760 + x691
    x1090 = x386 + x599 * x761 + x689
    x1091 = x1090 * x7
    x1092 = x384 + x599 * x763 + x693
    x1093 = x1089 - x1091
    x1094 = x1093 * x64
    x1095 = x400 + x599 * x771 + x961
    x1096 = x397 + x599 * x772 + x963
    x1097 = x1096 * x7
    x1098 = x394 + x599 * x774 + x966
    x1099 = x1095 - x1097
    x1100 = x1099 * x64
    x1101 = x414 + x599 * x782 + 3.0 * x737
    x1102 = x410 + x599 * x783 + 3.0 * x733
    x1103 = x1102 * x7
    x1104 = x407 + x599 * x785 + 3.0 * x741
    x1105 = x1104 * x128
    x1106 = x1101 - x1103
    x1107 = x1106 * x64
    x1108 = x416 * x803 + x426
    x1109 = x416 * x805 + x431
    x1110 = x1109 * x30
    x1111 = x416 * x795 + x440 - x7 * (x416 * x799 + x441)
    x1112 = x30 * (x416 * x809 + x438)
    x1113 = x416 * x823 + x466 + x806
    x1114 = x416 * x825 + x471 + x810
    x1115 = x1114 * x75
    x1116 = x416 * x815 + x481 - x7 * (x416 * x819 + x482 + x801) + x797
    x1117 = x30 * (x416 * x828 + x479 + x813)
    x1118 = x416 * x838 + x485
    x1119 = x416 * x839 + x488
    x1120 = x1119 * x30
    x1121 = x416 * x832 + x495 - x7 * (x416 * x835 + x496)
    x1122 = x30 * (x416 * x842 + x494)
    x1123 = x416 * x852 + x507 + 2.0 * x829
    x1124 = x1123 * x30
    x1125 = x416 * x855 + x521 + x826
    x1126 = x416 * x848 + x523 - x7 * (x416 * x851 + x524 + x821) + x817
    x1127 = x416 * x863 + x529 + x843
    x1128 = x1127 * x30
    x1129 = x416 * x866 + x544 + x840
    x1130 = x416 * x859 + x548 - x7 * (x416 * x862 + x549 + x837) + x834
    x1131 = x416 * x875 + x550
    x1132 = x1131 * x30
    x1133 = x416 * x878 + x557
    x1134 = x416 * x870 + x558 - x7 * (x416 * x874 + x559)
    x1135 = x416 * x883 + x570 + 3.0 * x854
    x1136 = x416 * x880 + x572 - x7 * (x416 * x881 + x573 + 3.0 * x850) + 3.0 * x847
    x1137 = x416 * x888 + x581 + 2.0 * x865
    x1138 = x416 * x885 + x585 - x7 * (x416 * x886 + x586 + 2.0 * x861) + 2.0 * x858
    x1139 = x416 * x893 + x591 + x877
    x1140 = x416 * x890 + x594 - x7 * (x416 * x891 + x595 + x872) + x869
    x1141 = x416 * x898 + x596
    x1142 = x416 * x895 + x597 - x7 * (x416 * x896 + x598)
    x1143 = x599 * x802 + x603
    x1144 = x599 * x804 + x606
    x1145 = x1144 * x30
    x1146 = x615 + x616 * x794 - x7 * (x599 * x798 + x618)
    x1147 = x30 * (x599 * x808 + x613)
    x1148 = x416 * x915 + x599 * x822 + x625
    x1149 = x416 * x917 + x599 * x824 + x629
    x1150 = x1149 * x75
    x1151 = x416 * x905 + x599 * x814 + x638 - x7 * (x416 * x910 + x599 * x818 + x640)
    x1152 = x30 * (x416 * x920 + x636 + x903)
    x1153 = x655 * x794 + x663
    x1154 = x658 * x794 + x670
    x1155 = x1154 * x30
    x1156 = x648 * x794 + x683 - x7 * (x641 * x794 + x685)
    x1157 = x30 * (x664 * x794 + x680)
    x1158 = x416 * x935 + x687 + 2.0 * x921
    x1159 = x1158 * x30
    x1160 = x416 * x938 + x695 + x918
    x1161 = x416 * x931 + x697 - x7 * (x416 * x934 + x699 + x913) + x908
    x1162 = x416 * x946 + x705 + x926
    x1163 = x1162 * x30
    x1164 = x416 * x659 + x416 * x949 + x718
    x1165 = x30 * x924 + x416 * x942 - x7 * (x416 * x645 + x416 * x945 + x723) + x721
    x1166 = x728 * x794 + x731
    x1167 = x1166 * x30
    x1168 = x743 * x794 + x747
    x1169 = -x7 * (x734 * x794 + x753) + x738 * x794 + x751
    x1170 = x416 * x959 + x755 + 3.0 * x937
    x1171 = x416 * x956 - x7 * (x416 * x957 + x759 + 3.0 * x933) + x757 + 3.0 * x930
    x1172 = x416 * x967 + x765 + 2.0 * x948
    x1173 = x416 * x962 - x7 * (x416 * x964 + x770 + 2.0 * x944) + x768 + 2.0 * x941
    x1174 = x416 * x972 + x776 + x954
    x1175 = x416 * x969 - x7 * (x416 * x970 + x781 + x952) + x779 + x951
    x1176 = x785 * x794 + x788
    x1177 = -x7 * (x783 * x794 + x793) + x782 * x794 + x791
    x1178 = x4 * (x416 * x976 - x416 * x987)
    x1179 = x1007 * x416 + x985
    x1180 = x1008 * x416 + x993
    x1181 = x1180 * x75
    x1182 = x4 * (x416 * x999 - x7 * (x1003 * x416 + x981) + x978)
    x1183 = x30 * (x1013 * x416 + x998)
    x1184 = x4 * (x1018 * x416 - x1031 * x416)
    x1185 = x1035 * x416
    x1186 = 2.0 * x1014 + x1047 * x416
    x1187 = x1186 * x30
    x1188 = x1010 + x1051 * x416
    x1189 = x4 * (x1002 + x1042 * x416 - x7 * (x1006 + x1046 * x416))
    x1190 = x1035 + x1060 * x416
    x1191 = x1190 * x30
    x1192 = x1029 + x1064 * x416
    x1193 = x4 * (x1020 + x1056 * x416 - x7 * (x1024 + x1059 * x416))
    x1194 = x1076 * x416
    x1195 = x4 * (x1069 * x416 - x1079 * x416)
    x1196 = 3.0 * x1050 + x1086 * x416
    x1197 = x4 * (3.0 * x1041 + x1083 * x416 - x7 * (3.0 * x1044 + x1084 * x416))
    x1198 = 2.0 * x1063
    x1199 = x1092 * x416 + x1198
    x1200 = 2.0 * x1055
    x1201 = 2.0 * x1058
    x1202 = x4 * (x1089 * x416 + x1200 - x7 * (x1090 * x416 + x1201))
    x1203 = x1076 + x1098 * x416
    x1204 = x4 * (x1068 + x1095 * x416 - x7 * (x1071 + x1096 * x416))
    x1205 = x4 * (x1101 * x416 - x1103 * x416)
    x1206 = x599 * x982 + x602
    x1207 = x1206 * x3
    x1208 = x599 * x984 + x605
    x1209 = x1208 * x30
    x1210 = 3.0 * x1209
    x1211 = x599 * x976 + x614 - x7 * (x599 * x979 + x617)
    x1212 = x1211 * x64
    x1213 = x30 * (x599 * x992 + x612)
    x1214 = x1007 * x599 + x624
    x1215 = x1008 * x599 + x628
    x1216 = x1215 * x30
    x1217 = 2.0 * x1216
    x1218 = x599 * x999 + x637 - x7 * (x1003 * x599 + x639)
    x1219 = x1218 * x64
    x1220 = x30 * (x1013 * x599 + x635)
    x1221 = x1026 * x599 + x662 + x985
    x1222 = x1221 * x3
    x1223 = x1028 * x599 + x669 + x993
    x1224 = x1223 * x30
    x1225 = 2.0 * x1224
    x1226 = x1018 * x599 + x682 - x7 * (x1022 * x599 + x684 + x981) + x978
    x1227 = x1226 * x64
    x1228 = x30 * (x1034 * x599 + x679 + x998)
    x1229 = x1047 * x599 + x686
    x1230 = x1229 * x30
    x1231 = x1051 * x599 + x694
    x1232 = x1042 * x599 + x696 - x7 * (x1046 * x599 + x698)
    x1233 = x1232 * x64
    x1234 = x1014 + x1060 * x599 + x704
    x1235 = x1234 * x30
    x1236 = x1009 + x1064 * x599 + x717
    x1237 = x1001 + x1056 * x599 - x7 * (x1005 + x1059 * x599 + x722) + x720
    x1238 = x1237 * x64
    x1239 = 2.0 * x1035 + x1073 * x599 + x730
    x1240 = x1239 * x30
    x1241 = x1030 + x1077 * x599 + x746
    x1242 = x1241 * x3
    x1243 = x1021 + x1069 * x599 - x7 * (x1025 + x1072 * x599 + x752) + x750
    x1244 = x1243 * x64
    x1245 = x1086 * x599 + x754
    x1246 = x1083 * x599 - x7 * (x1084 * x599 + x758) + x756
    x1247 = x1246 * x64
    x1248 = x1050 + x1092 * x599 + x764
    x1249 = x1041 + x1089 * x599 - x7 * (x1044 + x1090 * x599 + x769) + x767
    x1250 = x1249 * x64
    x1251 = x1098 * x599 + x1198 + x775
    x1252 = x1095 * x599 + x1200 - x7 * (x1096 * x599 + x1201 + x780) + x778
    x1253 = x1252 * x64
    x1254 = 3.0 * x1076 + x1104 * x599 + x787
    x1255 = 3.0 * x1068 + x1101 * x599 - x7 * (3.0 * x1071 + x1102 * x599 + x792) + x790
    x1256 = x1255 * x64
    x1257 = x110 * x807 + x1108 * x416
    x1258 = x30 * (x110 * x812 + x1109 * x416)
    x1259 = x110 * x827 + x1110 + x1113 * x416
    x1260 = x75 * (x110 * x831 + x1112 + x1114 * x416)
    x1261 = x110 * x841 + x1118 * x416
    x1262 = x30 * (x110 * x845 + x1119 * x416)
    x1263 = x30 * (x110 * x853 + 2.0 * x1117 + x1123 * x416)
    x1264 = x110 * x856 + x1115 + x1125 * x416
    x1265 = x30 * (x110 * x864 + x1122 + x1127 * x416)
    x1266 = x110 * x867 + x1120 + x1129 * x416
    x1267 = x30 * (x110 * x876 + x1131 * x416)
    x1268 = x110 * x879 + x1133 * x416
    x1269 = x110 * x884 + 3.0 * x1124 + x1135 * x416
    x1270 = x110 * x889 + 2.0 * x1128 + x1137 * x416
    x1271 = x110 * x894 + x1132 + x1139 * x416
    x1272 = x110 * x899 + x1141 * x416
    x1273 = x1143 * x416 + x900
    x1274 = x30 * (x1144 * x416 + x902)
    x1275 = x1145 + x1148 * x416 + x919
    x1276 = x75 * (x1147 + x1149 * x416 + x923)
    x1277 = x1153 * x416 + x925
    x1278 = x30 * (x1154 * x416 + x928)
    x1279 = x30 * (2.0 * x1152 + x1158 * x416 + x936)
    x1280 = x1150 + x1160 * x416 + x939
    x1281 = x30 * (x1157 + x1162 * x416 + x947)
    x1282 = x1155 + x1164 * x416 + x950
    x1283 = x30 * (x1166 * x416 + x953)
    x1284 = x1168 * x416 + x955
    x1285 = 3.0 * x1159 + x1170 * x416 + x960
    x1286 = 2.0 * x1163 + x1172 * x416 + x968
    x1287 = x1167 + x1174 * x416 + x973
    x1288 = x1176 * x416 + x974
    x1289 = x794 * x982 + x989
    x1290 = x30 * (x794 * x984 + x997)
    x1291 = x1012 + x1179 * x416 + x416 * x985
    x1292 = x75 * (x1017 + x1180 * x416 + x416 * x993)
    x1293 = x1026 * x794 + x1033
    x1294 = x30 * (x1028 * x794 + x1039)
    x1295 = x30 * (x1049 + 2.0 * x1183 + x1186 * x416)
    x1296 = x1053 + x1181 + x1188 * x416
    x1297 = x30 * (x1062 + x1185 + x1190 * x416)
    x1298 = x1029 * x416 + x1066 + x1192 * x416
    x1299 = x30 * (x1073 * x794 + x1075)
    x1300 = x1077 * x794 + x1081
    x1301 = x1088 + 3.0 * x1187 + x1196 * x416
    x1302 = x1094 + 2.0 * x1191 + x1199 * x416
    x1303 = x1100 + x1194 + x1203 * x416
    x1304 = x1104 * x794 + x1107
    x1305 = x1209 + x1214 * x416
    x1306 = x75 * (x1213 + x1215 * x416)
    x1307 = x30 * (2.0 * x1220 + x1229 * x416)
    x1308 = x1217 + x1231 * x416
    x1309 = x30 * (x1228 + x1234 * x416)
    x1310 = x1224 + x1236 * x416
    x1311 = x1240 * x416
    x1312 = 3.0 * x1230 + x1245 * x416
    x1313 = 2.0 * x1235
    x1314 = x1248 * x416 + x1313
    x1315 = x1240 + x1251 * x416
    x1316 = x110 * x988 + x1206 * x599
    x1317 = x30 * (x110 * x996 + x1208 * x599)
    x1318 = x1011 * x110 + x1214 * x599
    x1319 = x30 * (x1016 * x110 + x1215 * x599)
    x1320 = 2.0 * x1319
    x1321 = x1032 * x110 + x1209 + x1221 * x599
    x1322 = x30 * (x1038 * x110 + x1213 + x1223 * x599)
    x1323 = 2.0 * x1322
    x1324 = x30 * (x1048 * x110 + x1229 * x599)
    x1325 = x1052 * x110 + x1231 * x599
    x1326 = x30 * (x1061 * x110 + x1220 + x1234 * x599)
    x1327 = x1065 * x110 + x1216 + x1236 * x599
    x1328 = x30 * (x1074 * x110 + 2.0 * x1228 + x1239 * x599)
    x1329 = x1080 * x110 + x1225 + x1241 * x599
    x1330 = x1087 * x110 + x1245 * x599
    x1331 = x1093 * x110 + x1230 + x1248 * x599
    x1332 = x1099 * x110 + x1251 * x599 + x1313
    x1333 = x110 * x1106 + 3.0 * x1240 + x1254 * x599
    x1334 = 2.0 * x1326

    # 210 item(s)
    return numpy.array(
        [
            x21
            * (
                x109 * x3
                + x121 * x72
                + x4 * (x107 * x3 + 3.0 * x114 - x116 * x7)
                - x7 * (x125 * x72 + x3 * x99 + x4 * (x116 - x54 * x7))
            )
            + x3
            * (
                x110 * (x109 - x7 * x99)
                + x3
                * (
                    x3 * (x3 * (x60 + x62) + x65 + x71 * x72)
                    + x4 * (-x40 * x7 + x54)
                    + x72 * x81
                )
                + x72 * x96
            )
            + x72
            * (
                x110 * (x121 - x125 * x7)
                + x3 * x96
                + x75 * (x3 * x95 + x30 * (x127 + x129) + x4 * (x120 - x124 * x7))
            ),
            x21
            * (
                x183 * x3
                + x189 * x75
                + x4 * (x181 * x3 - x185 * x7 + x187)
                - x7 * (x179 * x3 + x192 * x75 + x4 * (-x144 * x7 + x185))
            )
            + x3
            * (
                x110 * (-x179 * x7 + x183)
                + x175 * x75
                + x3
                * (
                    x162 * x75
                    + x3 * (x151 + x157 * x75 + x3 * (x147 + x149))
                    + x4 * (-x138 * x7 + x144)
                )
            )
            + x75
            * (
                x110 * (x189 - x192 * x7)
                + x175 * x3
                + x30
                * (
                    x174 * x3
                    + x4 * (2.0 * x10 * x131 * x15 * x3 * x33 * x4 * x5 - x171 * x3)
                )
            ),
            x21
            * (
                x245 * x3
                + x250 * x75
                + x4 * (x243 * x3 - x247 * x7 + x248)
                - x7 * (x240 * x3 + x252 * x75 + x4 * (-x208 * x7 + x247))
            )
            + x3
            * (
                x110 * (-x240 * x7 + x245)
                + x235 * x75
                + x3
                * (
                    x222 * x75
                    + x3 * (x216 + x219 * x75 + x3 * (x212 + x214))
                    + x4 * (-x201 * x7 + x208)
                )
            )
            + x75
            * (
                x110 * (x250 - x252 * x7)
                + x235 * x3
                + x30
                * (
                    x234 * x3
                    + x4 * (2.0 * x10 * x15 * x194 * x3 * x33 * x4 * x5 - x231 * x3)
                )
            ),
            x21
            * (
                x270 * x30
                + x293 * x3
                + x4 * (x294 + x295 * x3 - x297 * x7)
                - x7 * (x267 * x30 + x288 * x3 + x4 * (-x277 * x7 + x297))
            )
            + x3
            * (
                x110 * (-x288 * x7 + x293)
                + x264 * x30
                + x3
                * (
                    x263 * x30
                    + x3 * (x284 + x285 + x3 * (x278 + x281))
                    + x4 * (-x273 * x7 + x277)
                )
            )
            + x30 * (x110 * (-x267 * x7 + x270) + x264 * x3),
            x21
            * (
                x3 * x319
                + x30 * x307
                + x4 * (x119 * x298 + x194 * x322 * x78 - x321 * x7)
                - x7 * (x3 * x317 + x30 * x305 + x4 * (-x310 * x7 + x321))
            )
            + x3
            * (
                x110 * (-x317 * x7 + x319)
                + x3
                * (
                    x3 * (x3 * x312 + x3 * (x298 * x313 * x78 + x312) + x315)
                    + x30 * x302
                    + x4 * (-x309 * x7 + x310)
                )
                + x30 * x303
            )
            + x30 * (x110 * (-x305 * x7 + x307) + x3 * x303),
            x21
            * (
                x3 * x360
                + x30 * x339
                + x4 * (x3 * x362 + x361 - x364 * x7)
                - x7 * (x3 * x355 + x30 * x336 + x4 * (-x346 * x7 + x364))
            )
            + x3
            * (
                x110 * (-x355 * x7 + x360)
                + x3
                * (
                    x3 * (x3 * (x347 + x349) + x351 + x352)
                    + x30 * x331
                    + x4 * (-x342 * x7 + x346)
                )
                + x30 * x332
            )
            + x30 * (x110 * (-x336 * x7 + x339) + x3 * x332),
            x21
            * (
                x3 * x379
                + x4 * (-x3 * x373 * x7 + x3 * x377)
                - x7 * (x3 * x375 + x4 * (-x3 * x365 * x7 + x3 * x373))
            )
            + x3
            * (
                x110 * (-x375 * x7 + x379)
                + x3 * (x3 * (x370 + x371) + x4 * (x3 * x365 - x368))
            ),
            x21
            * (
                x3 * x391
                + x4 * (-x3 * x385 * x7 + x3 * x389)
                - x7 * (x3 * x387 + x4 * (-x3 * x380 * x7 + x3 * x385))
            )
            + x3
            * (
                x110 * (-x387 * x7 + x391)
                + x3 * (x3 * (x128 * x383 + x384) + x4 * (x3 * x380 - x3 * x382))
            ),
            x21
            * (
                x3 * x401
                + x4 * (x131 * x3 * x334 - x131 * x358 * x7)
                - x7 * (x3 * x398 + x4 * (x131 * x3 * x324 - x3 * x396 * x7))
            )
            + x3
            * (
                x110 * (-x398 * x7 + x401)
                + x3 * (x3 * (x128 * x395 + x394) + x4 * (x131 * x3 * x325 - x3 * x393))
            ),
            x21
            * (
                x3 * x415
                + x4 * (-x3 * x409 * x7 + x3 * x413)
                - x7 * (x3 * x411 + x4 * (-x3 * x402 * x7 + x3 * x409))
            )
            + x3
            * (
                x110 * (-x411 * x7 + x415)
                + x3 * (x3 * (x406 + x407) + x4 * (x3 * x402 - x3 * x404))
            ),
            x110
            * (
                x3 * x422
                + x437 * x72
                + 0.5 * x440
                - x7 * (x3 * x419 + x436 * x72 + 0.5 * x441)
            )
            + x3
            * (
                x3 * (x3 * (x423 + x424) + 0.5 * x426 + x429 * x72)
                + x4 * (-x419 * x7 + x422)
                + x435 * x72
            )
            + x72
            * (
                x3 * x435
                + x4 * (-x436 * x7 + x437)
                + x75 * (x3 * x434 + 0.5 * x438 + x439 * x77)
            ),
            x110
            * (
                x3 * x458
                + x478 * x75
                + 0.5 * x481
                - x7 * (x3 * x449 + x475 * x75 + 0.5 * x482)
            )
            + x3
            * (
                x3 * (x3 * (x3 * x460 + x465) + 0.5 * x466 + x470 * x75)
                + x4 * (-x449 * x7 + x458)
                + x472 * x75
            )
            + x75
            * (x3 * x472 + x30 * (x128 * x468 + 0.5 * x479) + x4 * (-x475 * x7 + x478)),
            x110
            * (
                x3 * x484
                + x493 * x75
                + 0.5 * x495
                - x7 * (x3 * x483 + x491 * x75 + 0.5 * x496)
            )
            + x3
            * (
                x3 * (x3 * (x212 * x416 + x214 * x416) + 0.5 * x485 + x487 * x75)
                + x4 * (-x483 * x7 + x484)
                + x489 * x75
            )
            + x75
            * (x3 * x489 + x30 * (x233 * x416 + 0.5 * x494) + x4 * (-x491 * x7 + x493)),
            x110
            * (
                x3 * x30 * x499
                + x3 * x516
                + 0.5 * x523
                - x7 * (x3 * x509 + x3 * x512 + 0.5 * x524)
            )
            + x3
            * (
                x3 * (x3 * x517 + x3 * (x3 * x520 + x517) + 0.5 * x521)
                + x30 * x508
                + x4 * (-x512 * x7 + x516)
            )
            + x30 * (x3 * x508 + x4 * (x3 * x499 - x3 * x503)),
            x110
            * (
                x3 * x30 * x525
                + x3 * x539
                + 0.5 * x548
                - x7 * (x3 * x531 + x3 * x535 + 0.5 * x549)
            )
            + x3
            * (
                x3 * (x3 * x540 + x3 * (x3 * x543 + x540) + 0.5 * x544)
                + x30 * x530
                + x4 * (-x535 * x7 + x539)
            )
            + x30 * (x3 * x530 + x4 * (x3 * x525 - x3 * x527)),
            x110
            * (
                x3 * x555
                + x359 * x416
                + 0.5 * x558
                - x7 * (x3 * x553 + x354 * x416 + 0.5 * x559)
            )
            + x3
            * (
                x3 * (x3 * (x349 * x416 + x556) + x352 * x416 + 0.5 * x557)
                + x30 * x551
                + x4 * (-x553 * x7 + x555)
            )
            + x30 * (x3 * x551 + x4 * (x3 * x324 * x416 - x326 * x439)),
            x110 * (x128 * x562 + 0.5 * x572 - x7 * (x128 * x565 + 0.5 * x573))
            + x3 * (x3 * (x128 * x569 + 0.5 * x570) + x4 * (x3 * x562 - x3 * x566)),
            x110 * (x128 * x575 + 0.5 * x585 - x7 * (x128 * x577 + 0.5 * x586))
            + x3 * (x3 * (x128 * x580 + 0.5 * x581) + x4 * (x3 * x575 - x3 * x578)),
            x110 * (x128 * x587 + 0.5 * x594 - x7 * (x128 * x588 + 0.5 * x595))
            + x3 * (x3 * (x128 * x590 + 0.5 * x591) + x4 * (x3 * x587 - x3 * x589)),
            x110 * (x412 * x416 + 0.5 * x597 - x7 * (x408 * x416 + 0.5 * x598))
            + x3
            * (x3 * (x406 * x416 + 0.5 * x596) + x4 * (x3 * x402 * x416 - x404 * x439)),
            x110 * (x3 * x601 + x611 * x72 + x615 - x7 * (x3 * x600 + x610 * x72 + x618))
            + x3
            * (
                x3 * (x3 * (x599 * x60 + x599 * x62) + x603 + x604 * x72)
                + x4 * (-x600 * x7 + x601)
                + x609 * x72
            )
            + x72
            * (
                x3 * x609
                + x4 * (-x610 * x7 + x611)
                + x75 * (x3 * x608 + x599 * x94 + x613)
            ),
            x110 * (x3 * x622 + x634 * x75 + x638 - x7 * (x3 * x620 + x632 * x75 + x640))
            + x3
            * (
                x3 * (x3 * (x147 * x599 + x623) + x625 + x627 * x75)
                + x4 * (-x620 * x7 + x622)
                + x630 * x75
            )
            + x75 * (x3 * x630 + x30 * (x173 * x599 + x636) + x4 * (-x632 * x7 + x634)),
            x110 * (x3 * x654 + x678 * x75 + x683 - x7 * (x3 * x647 + x675 * x75 + x685))
            + x3
            * (
                x3 * (x3 * (x656 + x660) + x663 + x667 * x75)
                + x4 * (-x647 * x7 + x654)
                + x672 * x75
            )
            + x75 * (x3 * x672 + x30 * (x128 * x664 + x680) + x4 * (-x675 * x7 + x678)),
            x110
            * (x292 * x599 + x3 * x692 + x697 - x7 * (x287 * x599 + x3 * x690 + x699))
            + x3
            * (
                x3 * (x285 * x599 + x3 * (x281 * x599 + x693) + x695)
                + x30 * x688
                + x4 * (-x690 * x7 + x692)
            )
            + x30 * (x3 * x688 + x4 * (x254 * x3 * x599 - x257 * x599)),
            x110
            * (x3 * x30 * x700 + x3 * x713 - x7 * (x3 * x707 + x3 * x710 + x723) + x721)
            + x3
            * (
                x3 * (x3 * x714 + x3 * (x3 * x716 + x714) + x718)
                + x30 * x706
                + x4 * (-x7 * x710 + x713)
            )
            + x30 * (x3 * x706 + x4 * (x3 * x700 - x3 * x702)),
            x110
            * (x3 * x30 * x724 + x3 * x740 - x7 * (x3 * x733 + x3 * x736 + x753) + x751)
            + x3
            * (
                x3 * (x3 * (x741 + x744) + x747 + x748)
                + x30 * x732
                + x4 * (-x7 * x736 + x740)
            )
            + x30 * (x3 * x732 + x4 * (x3 * x724 - x3 * x726)),
            x110 * (x376 * x599 - x7 * (x372 * x599 + x759) + x757)
            + x3 * (x3 * (x370 * x599 + x755) + x4 * (x3 * x365 * x599 - x368 * x599)),
            x110 * (x128 * x760 - x7 * (x128 * x761 + x770) + x768)
            + x3 * (x3 * (x128 * x763 + x765) + x4 * (x3 * x760 - x3 * x762)),
            x110 * (x128 * x771 - x7 * (x128 * x772 + x781) + x779)
            + x3 * (x3 * (x128 * x774 + x776) + x4 * (x3 * x771 - x3 * x773)),
            x110 * (x128 * x782 - x7 * (x128 * x783 + x793) + x791)
            + x3 * (x3 * (x786 + x788) + x4 * (x3 * x782 - x3 * x784)),
            x3 * (x3 * (x3 * x803 + 3.0 * x806) + x64 * x807 + x72 * x811)
            + x4 * (x3 * x795 - x7 * (x3 * x799 + 3.0 * x801) + 3.0 * x797)
            + x72 * (x3 * x811 + x64 * x812 + x75 * (x3 * x809 + x813)),
            x3 * (x3 * (x3 * x823 + x826) + x64 * x827 + x75 * x830)
            + x4 * (x3 * x815 - x7 * (x3 * x819 + x821) + x817)
            + x75 * (x3 * x829 + x3 * x830 + x64 * x831),
            x3 * (x3 * (x3 * x838 + 2.0 * x840) + x64 * x841 + x75 * x844)
            + x4 * (x3 * x832 - x7 * (x3 * x835 + 2.0 * x837) + 2.0 * x834)
            + x75 * (x3 * x843 + x3 * x844 + x64 * x845),
            x3 * (x3 * x854 + x3 * (x3 * x855 + x854) + x64 * x856)
            + x30 * (x128 * x852 + x64 * x853)
            + x4 * (x3 * x848 - x7 * (x3 * x851 + x850) + x847),
            x3 * (x3 * x865 + x3 * (x3 * x866 + x865) + x64 * x867)
            + x30 * (x128 * x863 + x64 * x864)
            + x4 * (x3 * x859 - x7 * (x3 * x862 + x861) + x858),
            x3 * (x3 * x877 + x3 * (x3 * x878 + x877) + x64 * x879)
            + x30 * (x128 * x875 + x64 * x876)
            + x4 * (x3 * x870 - x7 * (x3 * x874 + x872) + x869),
            x3 * (x128 * x883 + x64 * x884) + x4 * (x3 * x880 - x3 * x882),
            x3 * (x128 * x888 + x64 * x889) + x4 * (x3 * x885 - x3 * x887),
            x3 * (x128 * x893 + x64 * x894) + x4 * (x3 * x890 - x3 * x892),
            x3 * (x128 * x898 + x64 * x899) + x4 * (x3 * x895 - x3 * x897),
            x3 * (x3 * (x423 * x599 + x424 * x599) + x72 * x901 + 0.5 * x900)
            + x4 * (x420 * x599 + x421 * x599 * x72 - x7 * (x417 * x599 + x418 * x599))
            + x72 * (x3 * x901 + x75 * (x433 * x599 + x903) + 0.5 * x902),
            x3 * (x3 * (x3 * x915 + x918) + x75 * x922 + 0.5 * x919)
            + x4 * (x3 * x905 - x7 * (x3 * x910 + x913) + x908)
            + x75 * (x3 * x921 + x3 * x922 + 0.5 * x923),
            x3 * (x3 * (x416 * x656 + x416 * x660) + x75 * x927 + 0.5 * x925)
            + x4 * (x416 * x649 - x7 * (x416 * x642 + x416 * x646) + x75 * x924)
            + x75 * (x3 * x927 + x416 * x671 + 0.5 * x928),
            x3 * (x3 * x937 + x3 * (x3 * x938 + x937) + 0.5 * x939)
            + x30 * (x128 * x935 + 0.5 * x936)
            + x4 * (x3 * x931 - x7 * (x3 * x934 + x933) + x930),
            x3 * (x3 * x948 + x3 * (x3 * x949 + x948) + 0.5 * x950)
            + x30 * (x128 * x946 + 0.5 * x947)
            + x4 * (x3 * x942 - x7 * (x3 * x945 + x944) + x941),
            x3 * (x3 * (x416 * x744 + x954) + x416 * x748 + 0.5 * x955)
            + x30 * (x416 * x729 + 0.5 * x953)
            + x4 * (x416 * x739 - x7 * (x416 * x735 + x952) + x951),
            x3 * (x128 * x959 + 0.5 * x960) + x4 * (x3 * x956 - x3 * x958),
            x3 * (x128 * x967 + 0.5 * x968) + x4 * (x3 * x962 - x3 * x965),
            x3 * (x128 * x972 + 0.5 * x973) + x4 * (x3 * x969 - x3 * x971),
            x3 * (x416 * x786 + 0.5 * x974) + x4 * (x3 * x416 * x782 - x439 * x784),
            x3 * (x3 * (x983 + x986) + x72 * x995 + x989)
            + x4 * (x3 * x976 - x7 * (x3 * x979 + 3.0 * x981) + 3.0 * x978)
            + x72 * (x3 * x995 + x75 * (x3 * x992 + x998) + x997),
            x3 * (x1012 + x1015 * x75 + x3 * (x1007 * x3 + x1010))
            + x4 * (x1002 + x3 * x999 - x7 * (x1003 * x3 + x1006))
            + x75 * (x1014 * x3 + x1015 * x3 + x1017),
            x3 * (x1033 + x1037 * x75 + x3 * (x1027 + x1030))
            + x4 * (x1018 * x3 + x1021 - x7 * (x1022 * x3 + x1025))
            + x75 * (x1035 * x3 + x1037 * x3 + x1039),
            x3 * (x1050 * x3 + x1053 + x3 * (x1050 + x1051 * x3))
            + x30 * (x1047 * x128 + x1049)
            + x4 * (x1041 + x1042 * x3 - x7 * (x1044 + x1046 * x3)),
            x3 * (x1063 * x3 + x1066 + x3 * (x1063 + x1064 * x3))
            + x30 * (x1060 * x128 + x1062)
            + x4 * (x1055 + x1056 * x3 - x7 * (x1058 + x1059 * x3)),
            x3 * (x1081 + x1082 + x3 * (x1076 + x1078))
            + x30 * (x1073 * x128 + x1075)
            + x4 * (x1068 + x1069 * x3 - x7 * (x1071 + x1072 * x3)),
            x3 * (x1086 * x128 + x1088) + x4 * (x1083 * x3 - x1085 * x3),
            x3 * (x1092 * x128 + x1094) + x4 * (x1089 * x3 - x1091 * x3),
            x3 * (x1098 * x128 + x1100) + x4 * (x1095 * x3 - x1097 * x3),
            x3 * (x1105 + x1107) + x4 * (x1101 * x3 - x1103 * x3),
            x1111 * x64
            + x3 * (x1108 * x3 + 3.0 * x1110)
            + x72 * (x1109 * x3 + 2.0 * x1112),
            x1116 * x64 + x3 * (x1113 * x3 + x1115) + x75 * (x1114 * x3 + x1117),
            x1121 * x64 + x3 * (x1118 * x3 + 2.0 * x1120) + x75 * (x1119 * x3 + x1122),
            x1124 * x3 + x1126 * x64 + x3 * (x1124 + x1125 * x3),
            x1128 * x3 + x1130 * x64 + x3 * (x1128 + x1129 * x3),
            x1132 * x3 + x1134 * x64 + x3 * (x1132 + x1133 * x3),
            x1135 * x128 + x1136 * x64,
            x1137 * x128 + x1138 * x64,
            x1139 * x128 + x1140 * x64,
            x1141 * x128 + x1142 * x64,
            x1146 * x64
            + x3 * (x1143 * x3 + 3.0 * x1145)
            + x72 * (x1144 * x3 + 2.0 * x1147),
            x1151 * x64 + x3 * (x1148 * x3 + x1150) + x75 * (x1149 * x3 + x1152),
            x1156 * x64 + x3 * (x1153 * x3 + 2.0 * x1155) + x75 * (x1154 * x3 + x1157),
            x1159 * x3 + x1161 * x64 + x3 * (x1159 + x1160 * x3),
            x1163 * x3 + x1165 * x64 + x3 * (x1163 + x1164 * x3),
            x1167 * x3 + x1169 * x64 + x3 * (x1167 + x1168 * x3),
            x1170 * x128 + x1171 * x64,
            x1172 * x128 + x1173 * x64,
            x1174 * x128 + x1175 * x64,
            x1176 * x128 + x1177 * x64,
            0.5 * x1178
            + x3 * (x416 * x983 + x416 * x986)
            + x72 * (x416 * x990 + x416 * x994),
            0.5 * x1182 + x3 * (x1179 * x3 + x1181) + x75 * (x1180 * x3 + x1183),
            0.5 * x1184
            + x3 * (x1027 * x416 + x1030 * x416)
            + x75 * (x1036 * x416 + x1185),
            x1187 * x3 + 0.5 * x1189 + x3 * (x1187 + x1188 * x3),
            x1191 * x3 + 0.5 * x1193 + x3 * (x1191 + x1192 * x3),
            x1082 * x416 + 0.5 * x1195 + x3 * (x1078 * x416 + x1194),
            x1196 * x128 + 0.5 * x1197,
            x1199 * x128 + 0.5 * x1202,
            x1203 * x128 + 0.5 * x1204,
            x1105 * x416 + 0.5 * x1205,
            x1212 + x3 * (x1207 + x1210) + x72 * (x1208 * x3 + 2.0 * x1213),
            x1219 + x3 * (x1214 * x3 + x1217) + x75 * (x1215 * x3 + x1220),
            x1227 + x3 * (x1222 + x1225) + x75 * (x1223 * x3 + x1228),
            x1230 * x3 + x1233 + x3 * (x1230 + x1231 * x3),
            x1235 * x3 + x1238 + x3 * (x1235 + x1236 * x3),
            x1240 * x3 + x1244 + x3 * (x1240 + x1242),
            x1245 * x128 + x1247,
            x1248 * x128 + x1250,
            x1251 * x128 + x1253,
            x1254 * x128 + x1256,
            x1257 * x3 + 3.0 * x1258,
            x1259 * x3 + x1260,
            x1261 * x3 + 2.0 * x1262,
            x1263 + x1264 * x3,
            x1265 + x1266 * x3,
            x1267 + x1268 * x3,
            x1269 * x3,
            x1270 * x3,
            x1271 * x3,
            x1272 * x3,
            x1273 * x3 + 3.0 * x1274,
            x1275 * x3 + x1276,
            x1277 * x3 + 2.0 * x1278,
            x1279 + x1280 * x3,
            x1281 + x1282 * x3,
            x1283 + x1284 * x3,
            x1285 * x3,
            x1286 * x3,
            x1287 * x3,
            x1288 * x3,
            x1289 * x3 + 3.0 * x1290,
            x1291 * x3 + x1292,
            x1293 * x3 + 2.0 * x1294,
            x1295 + x1296 * x3,
            x1297 + x1298 * x3,
            x1299 + x1300 * x3,
            x1301 * x3,
            x1302 * x3,
            x1303 * x3,
            x1304 * x3,
            x1207 * x416 + x1210 * x416,
            x1305 * x3 + x1306,
            x1222 * x416 + x1225 * x416,
            x1307 + x1308 * x3,
            x1309 + x1310 * x3,
            x1242 * x416 + x1311,
            x1312 * x3,
            x1314 * x3,
            x1315 * x3,
            x1254 * x439,
            x1316 * x3 + 3.0 * x1317,
            x1318 * x3 + x1320,
            x1321 * x3 + x1323,
            x1324 + x1325 * x3,
            x1326 + x1327 * x3,
            x1328 + x1329 * x3,
            x1330 * x3,
            x1331 * x3,
            x1332 * x3,
            x1333 * x3,
            x1111 * x21 + x1257 * x416,
            x1116 * x21 + x1258 + x1259 * x416,
            x1121 * x21 + x1261 * x416,
            x1126 * x21 + x1260 + x1264 * x416,
            x1130 * x21 + x1262 + x1266 * x416,
            x1134 * x21 + x1268 * x416,
            x1136 * x21 + 3.0 * x1263 + x1269 * x416,
            x1138 * x21 + 2.0 * x1265 + x1270 * x416,
            x1140 * x21 + x1267 + x1271 * x416,
            x1142 * x21 + x1272 * x416,
            x110 * x1146 + x1273 * x416,
            x110 * x1151 + x1274 + x1275 * x416,
            x110 * x1156 + x1277 * x416,
            x110 * x1161 + x1276 + x1280 * x416,
            x110 * x1165 + x1278 + x1282 * x416,
            x110 * x1169 + x1284 * x416,
            x110 * x1171 + 3.0 * x1279 + x1285 * x416,
            x110 * x1173 + 2.0 * x1281 + x1286 * x416,
            x110 * x1175 + x1283 + x1287 * x416,
            x110 * x1177 + x1288 * x416,
            x1178 + x1289 * x416,
            x1182 + x1290 + x1291 * x416,
            x1184 + x1293 * x416,
            x1189 + x1292 + x1296 * x416,
            x1193 + x1294 + x1298 * x416,
            x1195 + x1300 * x416,
            x1197 + 3.0 * x1295 + x1301 * x416,
            x1202 + 2.0 * x1297 + x1302 * x416,
            x1204 + x1299 + x1303 * x416,
            x1205 + x1304 * x416,
            x1206 * x794 + x1212,
            x1209 * x416 + x1219 + x1305 * x416,
            x1221 * x794 + x1227,
            x1233 + x1306 + x1308 * x416,
            x1224 * x416 + x1238 + x1310 * x416,
            x1241 * x794 + x1244,
            x1247 + 3.0 * x1307 + x1312 * x416,
            x1250 + 2.0 * x1309 + x1314 * x416,
            x1253 + x1311 + x1315 * x416,
            x1254 * x794 + x1256,
            x1316 * x416,
            x1317 + x1318 * x416,
            x1321 * x416,
            x1320 + x1325 * x416,
            x1322 + x1327 * x416,
            x1329 * x416,
            3.0 * x1324 + x1330 * x416,
            x1331 * x416 + x1334,
            x1328 + x1332 * x416,
            x1333 * x416,
            x1211 * x21 + x1316 * x599,
            x1218 * x21 + x1318 * x599,
            x1226 * x21 + x1317 + x1321 * x599,
            x1232 * x21 + x1325 * x599,
            x1237 * x21 + x1319 + x1327 * x599,
            x1243 * x21 + x1323 + x1329 * x599,
            x1246 * x21 + x1330 * x599,
            x1249 * x21 + x1324 + x1331 * x599,
            x1252 * x21 + x1332 * x599 + x1334,
            x1255 * x21 + 3.0 * x1328 + x1333 * x599,
        ]
    )


def _2center2el3d_54(a, A, b, B):
    """Cartesian (h|g) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a ** (-1.0)
    x5 = -x2 - B[0]
    x6 = b ** (-1.0)
    x7 = a * x1
    x8 = b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(7, x8)
    x10 = 17.4934183276249
    x11 = x10 * x6
    x12 = x0 ** (-1.5)
    x13 = 2.0 * x12
    x14 = x11 * x13
    x15 = x14 * x9
    x16 = x15 * x5
    x17 = x0 ** (-0.5)
    x18 = boys(6, x8)
    x19 = 0.5 * x6
    x20 = x19 * (2.0 * x10 * x17 * x18 * x4 * x6 - x15)
    x21 = boys(8, x8)
    x22 = x5**2
    x23 = 2.0 * x4
    x24 = x17 * x23
    x25 = x11 * x24
    x26 = x22 * x25
    x27 = x21 * x26
    x28 = x20 + x27
    x29 = x28 * x5 + x6 * (2.0 * x10 * x17 * x18 * x4 * x5 * x6 - x16)
    x30 = x11 * x18
    x31 = x13 * x30
    x32 = boys(5, x8)
    x33 = x19 * (2.0 * x10 * x17 * x32 * x4 * x6 - x31)
    x34 = x25 * x9
    x35 = x22 * x34
    x36 = x33 + x35
    x37 = x14 * x32
    x38 = boys(4, x8)
    x39 = x19 * (2.0 * x10 * x17 * x38 * x4 * x6 - x37)
    x40 = x24 * x30
    x41 = x22 * x40
    x42 = x39 + x41
    x43 = 1.5 * x6
    x44 = x29 * x5 + x43 * (-x36 * x7 + x42)
    x45 = x3 * x44
    x46 = (2.0 * a + 2.0 * b) ** (-1.0)
    x47 = x31 * x5
    x48 = x36 * x5 + x6 * (2.0 * x10 * x17 * x32 * x4 * x5 * x6 - x47)
    x49 = x46 * x48
    x50 = 4.0 * x49
    x51 = x45 + x50
    x52 = b * x1
    x53 = x14 * x38
    x54 = boys(3, x8)
    x55 = x19 * (2.0 * x10 * x17 * x4 * x54 * x6 - x53)
    x56 = x25 * x32
    x57 = x22 * x56
    x58 = x55 + x57
    x59 = x43 * (-x42 * x7 + x58) + x48 * x5
    x60 = x3 * x59
    x61 = x37 * x5
    x62 = -2.0 * x10 * x17 * x38 * x4 * x5 * x6
    x63 = x42 * x5 + x6 * (-x61 - x62)
    x64 = x46 * x63
    x65 = 4.0 * x64
    x66 = x60 + x65
    x67 = x14 * x21
    x68 = x5 * x67
    x69 = x19 * (2.0 * x10 * x17 * x4 * x6 * x9 - x67)
    x70 = boys(9, x8)
    x71 = x26 * x70
    x72 = x43 * (-x28 * x7 + x36) + x5 * (
        x5 * (x69 + x71) + x6 * (2.0 * x10 * x17 * x4 * x5 * x6 * x9 - x68)
    )
    x73 = x3 * x72
    x74 = x29 * x46
    x75 = 4.0 * x74
    x76 = x44 * x52
    x77 = 0.5 * x4
    x78 = x77 * (x59 - x76)
    x79 = x29 * x3
    x80 = x36 * x46
    x81 = 3.0 * x80
    x82 = x79 + x81
    x83 = 4.0 * x46
    x84 = x48 * x52
    x85 = x77 * (x63 - x84)
    x86 = x3 * x36
    x87 = x5 * x83
    x88 = x17 * x4
    x89 = x30 * x88
    x90 = x87 * x89
    x91 = x86 + x90
    x92 = 3.0 * x46
    x93 = x3 * x82 + x85 + x91 * x92
    x94 = x3 * x48
    x95 = x42 * x46
    x96 = 3.0 * x95
    x97 = x94 + x96
    x98 = x3 * x63
    x99 = x46 * x58
    x100 = 3.0 * x99
    x101 = x100 + x98
    x102 = x42 * x52
    x103 = x77 * (-x102 + x58)
    x104 = 2.0 * x46
    x105 = x11 * x88
    x106 = x104 * x105
    x107 = x106 * x32
    x108 = x3 * x5
    x109 = x108 * x40
    x110 = x107 + x109
    x111 = x103 + x104 * x110 + x3 * x91
    x112 = x111 * x92 + x3 * x93 + x4 * (x101 - x52 * x97)
    x113 = x14 * x54
    x114 = boys(2, x8)
    x115 = x19 * (2.0 * x10 * x114 * x17 * x4 * x6 - x113)
    x116 = x25 * x38
    x117 = x116 * x22
    x118 = x115 + x117
    x119 = x43 * (x118 - x58 * x7) + x5 * x63
    x120 = x77 * (x119 - x52 * x59)
    x121 = x120 + x3 * x51 + x83 * x97
    x122 = x5 * x53
    x123 = x5 * x58 + x6 * (2.0 * x10 * x17 * x4 * x5 * x54 * x6 - x122)
    x124 = x19 * (2.0 * x10 * x17 * x4 * x6 * boys(1, x8) - x114 * x14)
    x125 = x25 * x54
    x126 = x123 * x5 + x43 * (-x118 * x7 + x124 + x125 * x22)
    x127 = x77 * (-x119 * x52 + x126)
    x128 = x101 * x83 + x127 + x3 * x66
    x129 = 1.5 * x4
    x130 = x118 * x5 + x6 * (2.0 * x10 * x114 * x17 * x4 * x5 * x6 - x113 * x5)
    x131 = x130 * x46
    x132 = x123 * x46
    x133 = x119 * x3 + 4.0 * x132
    x134 = x77 * (-x123 * x52 + x130)
    x135 = x105 * x38
    x136 = x135 * x87 + x3 * x58
    x137 = x101 * x3 + x134 + x136 * x92
    x138 = x77 * (x123 - x52 * x63)
    x139 = x32 * x5
    x140 = x105 * x83
    x141 = x139 * x140
    x142 = x141 + x3 * x42
    x143 = x138 + x142 * x92 + x3 * x97
    x144 = x10 * x12 * x23
    x145 = x139 * x144
    x146 = x77 * (-x145 - x62)
    x147 = x107 * x3
    x148 = -x1 * (a * A[1] + b * B[1])
    x149 = -x148 - B[1]
    x150 = x149 * x15
    x151 = x6 * (2.0 * x10 * x149 * x17 * x18 * x4 * x6 - x150)
    x152 = x149 * x27
    x153 = 0.5 * x151 + x152
    x154 = x153 * x5 + x6 * (2.0 * x10 * x149 * x17 * x18 * x4 * x5 * x6 - x149 * x16)
    x155 = x154 * x3
    x156 = x149 * x31
    x157 = x6 * (2.0 * x10 * x149 * x17 * x32 * x4 * x6 - x156)
    x158 = x149 * x35
    x159 = 0.5 * x157 + x158
    x160 = x159 * x46
    x161 = 3.0 * x160
    x162 = x155 + x161
    x163 = -2.0 * x10 * x149 * x17 * x32 * x4 * x5 * x6
    x164 = x159 * x5 + x6 * (-x149 * x47 - x163)
    x165 = x164 * x3
    x166 = x149 * x37
    x167 = -2.0 * x10 * x149 * x17 * x38 * x4 * x6
    x168 = x6 * (-x166 - x167)
    x169 = x149 * x41
    x170 = 0.5 * x168 + x169
    x171 = x170 * x46
    x172 = x165 + 3.0 * x171
    x173 = x149 * x67
    x174 = x6 * (2.0 * x10 * x149 * x17 * x4 * x6 * x9 - x173)
    x175 = x149 * x71
    x176 = x5 * (0.5 * x174 + x175) + x6 * (
        2.0 * x10 * x149 * x17 * x4 * x5 * x6 * x9 - x149 * x68
    )
    x177 = x176 * x3
    x178 = x153 * x46
    x179 = 3.0 * x178
    x180 = x154 * x52
    x181 = x77 * (x164 - x180)
    x182 = x153 * x3
    x183 = x149 * x5
    x184 = x183 * x9
    x185 = x140 * x184
    x186 = x182 + x185
    x187 = x159 * x52
    x188 = x77 * (x170 - x187)
    x189 = x104 * x89
    x190 = x149 * x189
    x191 = x149 * x34
    x192 = x108 * x191
    x193 = x190 + x192
    x194 = x104 * x193 + x186 * x3 + x188
    x195 = x159 * x3
    x196 = x83 * x89
    x197 = x183 * x196
    x198 = x195 + x197
    x199 = x170 * x3
    x200 = x141 * x149
    x201 = x199 + x200
    x202 = x144 * x18
    x203 = x183 * x202
    x204 = x77 * (-x163 - x203)
    x205 = x190 * x3
    x206 = x193 * x3 + x204 + x205
    x207 = x104 * x206 + x194 * x3 + x4 * (-x198 * x52 + x201)
    x208 = x170 * x5 + x6 * (2.0 * x10 * x149 * x17 * x38 * x4 * x5 * x6 - x149 * x61)
    x209 = x77 * (-x164 * x52 + x208)
    x210 = x162 * x3 + x198 * x92 + x209
    x211 = x149 * x53
    x212 = x6 * (2.0 * x10 * x149 * x17 * x4 * x54 * x6 - x211)
    x213 = x149 * x57
    x214 = 0.5 * x212 + x213
    x215 = x214 * x5 + x6 * (2.0 * x10 * x149 * x17 * x4 * x5 * x54 * x6 - x122 * x149)
    x216 = x77 * (-x208 * x52 + x215)
    x217 = x172 * x3 + x201 * x92 + x216
    x218 = x6 * (2.0 * x10 * x114 * x149 * x17 * x4 * x6 - x113 * x149)
    x219 = x117 * x149 + 0.5 * x218
    x220 = x219 * x46
    x221 = x214 * x46
    x222 = x208 * x3 + 3.0 * x221
    x223 = x77 * (-x214 * x52 + x219)
    x224 = x106 * x38
    x225 = x149 * x224
    x226 = x149 * x56
    x227 = x108 * x226 + x225
    x228 = x104 * x227 + x201 * x3 + x223
    x229 = x77 * (-x170 * x52 + x214)
    x230 = x107 * x149
    x231 = x149 * x40
    x232 = x108 * x231 + x230
    x233 = x104 * x232 + x198 * x3 + x229
    x234 = x144 * x32
    x235 = x77 * (-x149 * x234 - x167)
    x236 = x3**2
    x237 = -x1 * (a * A[2] + b * B[2])
    x238 = -x237 - B[2]
    x239 = x6 * (2.0 * x10 * x17 * x18 * x238 * x4 * x6 - x15 * x238)
    x240 = 0.5 * x239
    x241 = x238 * x27 + x240
    x242 = x241 * x5 + x6 * (2.0 * x10 * x17 * x18 * x238 * x4 * x5 * x6 - x16 * x238)
    x243 = x242 * x3
    x244 = x6 * (2.0 * x10 * x17 * x238 * x32 * x4 * x6 - x238 * x31)
    x245 = 0.5 * x244
    x246 = x238 * x35 + x245
    x247 = x246 * x46
    x248 = 3.0 * x247
    x249 = x243 + x248
    x250 = -2.0 * x10 * x17 * x238 * x32 * x4 * x5 * x6
    x251 = x246 * x5 + x6 * (-x238 * x47 - x250)
    x252 = x251 * x3
    x253 = -2.0 * x10 * x17 * x238 * x38 * x4 * x6
    x254 = x6 * (-x238 * x37 - x253)
    x255 = 0.5 * x254
    x256 = x238 * x41 + x255
    x257 = x256 * x46
    x258 = x252 + 3.0 * x257
    x259 = x6 * (2.0 * x10 * x17 * x238 * x4 * x6 * x9 - x238 * x67)
    x260 = 0.5 * x259
    x261 = x5 * (x238 * x71 + x260) + x6 * (
        2.0 * x10 * x17 * x238 * x4 * x5 * x6 * x9 - x238 * x68
    )
    x262 = x261 * x3
    x263 = x241 * x46
    x264 = 3.0 * x263
    x265 = x242 * x52
    x266 = x77 * (x251 - x265)
    x267 = x241 * x3
    x268 = x238 * x9
    x269 = x105 * x268 * x87
    x270 = x267 + x269
    x271 = x246 * x52
    x272 = x77 * (x256 - x271)
    x273 = x189 * x238
    x274 = x238 * x34
    x275 = x108 * x274
    x276 = x273 + x275
    x277 = x104 * x276 + x270 * x3 + x272
    x278 = x246 * x3
    x279 = x238 * x90
    x280 = x278 + x279
    x281 = x256 * x3
    x282 = x141 * x238
    x283 = x281 + x282
    x284 = x202 * x238
    x285 = x77 * (-x250 - x284 * x5)
    x286 = x273 * x3 + x276 * x3 + x285
    x287 = x104 * x286 + x277 * x3 + x4 * (-x280 * x52 + x283)
    x288 = x256 * x5 + x6 * (2.0 * x10 * x17 * x238 * x38 * x4 * x5 * x6 - x238 * x61)
    x289 = x77 * (-x251 * x52 + x288)
    x290 = x249 * x3 + x280 * x92 + x289
    x291 = x6 * (2.0 * x10 * x17 * x238 * x4 * x54 * x6 - x238 * x53)
    x292 = 0.5 * x291
    x293 = x238 * x57 + x292
    x294 = x293 * x5 + x6 * (2.0 * x10 * x17 * x238 * x4 * x5 * x54 * x6 - x122 * x238)
    x295 = x77 * (-x288 * x52 + x294)
    x296 = x258 * x3 + x283 * x92 + x295
    x297 = x6 * (2.0 * x10 * x114 * x17 * x238 * x4 * x6 - x113 * x238)
    x298 = 0.5 * x297
    x299 = x117 * x238 + x298
    x300 = x299 * x46
    x301 = x293 * x46
    x302 = x288 * x3 + 3.0 * x301
    x303 = x77 * (-x293 * x52 + x299)
    x304 = x224 * x238
    x305 = x238 * x56
    x306 = x108 * x305 + x304
    x307 = x104 * x306 + x283 * x3 + x303
    x308 = x77 * (-x256 * x52 + x293)
    x309 = x107 * x238
    x310 = x238 * x40
    x311 = x108 * x310 + x309
    x312 = x104 * x311 + x280 * x3 + x308
    x313 = x77 * (-x234 * x238 - x253)
    x314 = x149**2
    x315 = x25 * x314
    x316 = x21 * x315
    x317 = x20 + x316
    x318 = x314 * x34 + x33
    x319 = x314 * x40 + x39
    x320 = -x318 * x7 + x319
    x321 = x19 * x320 + x22 * x317
    x322 = x3 * x321
    x323 = x318 * x46
    x324 = x323 * x5
    x325 = x322 + 2.0 * x324
    x326 = x314 * x56 + x55
    x327 = -x319 * x7 + x326
    x328 = x19 * x327 + x22 * x318
    x329 = x3 * x328
    x330 = x319 * x5
    x331 = x104 * x330 + x329
    x332 = x315 * x70
    x333 = x332 + x69
    x334 = -x317 * x7 + x318
    x335 = x19 * x334 + x22 * x333
    x336 = x3 * x335
    x337 = x317 * x5
    x338 = x104 * x337
    x339 = x321 * x52
    x340 = x77 * (x328 - x339)
    x341 = x108 * x317
    x342 = x323 + x341
    x343 = x5 * x52
    x344 = x77 * (-x318 * x343 + x319 * x5)
    x345 = x3 * x323
    x346 = x3 * x342 + x344 + x345
    x347 = x319 * x46
    x348 = x108 * x318
    x349 = x347 + x348
    x350 = x326 * x46
    x351 = x3 * x330
    x352 = x350 + x351
    x353 = x236 * x318
    x354 = x319 * x52
    x355 = x77 * (x326 - x354)
    x356 = x353 + x355
    x357 = x3 * x346 + x356 * x46 + x4 * (-x349 * x52 + x352)
    x358 = x115 + x116 * x314
    x359 = -x326 * x7 + x358
    x360 = x19 * x359 + x22 * x319
    x361 = x77 * (-x328 * x52 + x360)
    x362 = x104 * x349 + x3 * x325 + x361
    x363 = x124 + x125 * x314 - x358 * x7
    x364 = x19 * x363 + x22 * x326
    x365 = x77 * (-x360 * x52 + x364)
    x366 = x104 * x352 + x3 * x331 + x365
    x367 = x350 * x5
    x368 = x3 * x360 + 2.0 * x367
    x369 = x358 * x5
    x370 = x77 * (-x326 * x5 * x52 + x358 * x5)
    x371 = x3 * x350 + x3 * x352 + x370
    x372 = x77 * (x326 * x5 - x330 * x52)
    x373 = x3 * x347 + x3 * x349 + x372
    x374 = x6 * (2.0 * x10 * x149 * x17 * x18 * x238 * x4 * x6 - x150 * x238)
    x375 = x152 * x238 + 0.5 * x374
    x376 = x184 * x238
    x377 = x140 * x376
    x378 = x3 * x375 + x377
    x379 = -2.0 * x10 * x149 * x17 * x238 * x32 * x4 * x6
    x380 = x6 * (-x156 * x238 - x379)
    x381 = x158 * x238 + 0.5 * x380
    x382 = x238 * x83
    x383 = x382 * x89
    x384 = x183 * x383
    x385 = x3 * x381 + x384
    x386 = x6 * (2.0 * x10 * x149 * x17 * x238 * x4 * x6 * x9 - x173 * x238)
    x387 = x175 * x238 + 0.5 * x386
    x388 = x140 * x183 * x21 * x238
    x389 = x77 * (-x375 * x52 + x381)
    x390 = x149 * x238
    x391 = x390 * x9
    x392 = x106 * x391
    x393 = x21 * x25 * x390
    x394 = x108 * x393 + x392
    x395 = x77 * (2.0 * x10 * x149 * x17 * x18 * x238 * x4 * x5 * x6 - x144 * x376)
    x396 = x3 * x392 + x3 * x394 + x395
    x397 = x191 * x238
    x398 = x108 * x397 + x190 * x238
    x399 = x231 * x238
    x400 = x108 * x399 + x230 * x238
    x401 = x149 * x284
    x402 = x77 * (-x379 - x401)
    x403 = x236 * x397 + x402
    x404 = x3 * x396 + x4 * (-x398 * x52 + x400) + x403 * x46
    x405 = x6 * (2.0 * x10 * x149 * x17 * x238 * x38 * x4 * x6 - x166 * x238)
    x406 = x169 * x238 + 0.5 * x405
    x407 = x77 * (-x381 * x52 + x406)
    x408 = x104 * x398 + x3 * x378 + x407
    x409 = x6 * (2.0 * x10 * x149 * x17 * x238 * x4 * x54 * x6 - x211 * x238)
    x410 = x213 * x238 + 0.5 * x409
    x411 = x77 * (-x406 * x52 + x410)
    x412 = x104 * x400 + x3 * x385 + x411
    x413 = x141 * x390
    x414 = x3 * x406 + x413
    x415 = x135 * x382
    x416 = x183 * x415
    x417 = x77 * (2.0 * x10 * x149 * x17 * x238 * x38 * x4 * x5 * x6 - x145 * x390)
    x418 = x147 * x390 + x3 * x400 + x417
    x419 = x77 * (2.0 * x10 * x149 * x17 * x238 * x32 * x4 * x5 * x6 - x203 * x238)
    x420 = x205 * x238 + x3 * x398 + x419
    x421 = x238**2
    x422 = x25 * x421
    x423 = x20 + x21 * x422
    x424 = x33 + x34 * x421
    x425 = x39 + x40 * x421
    x426 = -x424 * x7 + x425
    x427 = x19 * x426
    x428 = x22 * x423 + x427
    x429 = x3 * x428
    x430 = x424 * x46
    x431 = x430 * x5
    x432 = x429 + 2.0 * x431
    x433 = x421 * x56 + x55
    x434 = -x425 * x7 + x433
    x435 = x19 * x434
    x436 = x22 * x424 + x435
    x437 = x3 * x436
    x438 = x425 * x5
    x439 = x104 * x438 + x437
    x440 = x422 * x70 + x69
    x441 = -x423 * x7 + x424
    x442 = x19 * x441
    x443 = x22 * x440 + x442
    x444 = x3 * x443
    x445 = x423 * x5
    x446 = x428 * x52
    x447 = x77 * (x436 - x446)
    x448 = x108 * x423
    x449 = x430 + x448
    x450 = x77 * (-x343 * x424 + x425 * x5)
    x451 = x3 * x430
    x452 = x3 * x449 + x450 + x451
    x453 = x425 * x46
    x454 = x108 * x424
    x455 = x453 + x454
    x456 = x433 * x46
    x457 = x3 * x438
    x458 = x456 + x457
    x459 = x236 * x424
    x460 = x425 * x52
    x461 = x77 * (x433 - x460)
    x462 = x459 + x461
    x463 = x3 * x452 + x4 * (-x455 * x52 + x458) + x46 * x462
    x464 = x115 + x116 * x421
    x465 = -x433 * x7 + x464
    x466 = x19 * x465
    x467 = x22 * x425 + x466
    x468 = x77 * (-x436 * x52 + x467)
    x469 = x104 * x455 + x3 * x432 + x468
    x470 = x124 + x125 * x421 - x464 * x7
    x471 = x19 * x470
    x472 = x22 * x433 + x471
    x473 = x77 * (-x467 * x52 + x472)
    x474 = x104 * x458 + x3 * x439 + x473
    x475 = x456 * x5
    x476 = x3 * x467 + 2.0 * x475
    x477 = x464 * x5
    x478 = x433 * x5
    x479 = x77 * (x464 * x5 - x478 * x52)
    x480 = x3 * x456 + x3 * x458 + x479
    x481 = x77 * (x433 * x5 - x438 * x52)
    x482 = x3 * x453
    x483 = x3 * x455 + x481 + x482
    x484 = x149 * x319 + x168
    x485 = x149 * x318 + x157
    x486 = x485 * x52
    x487 = x3 * x486
    x488 = x149 * x317 + x151
    x489 = x236 * x488
    x490 = x77 * (x484 - x486)
    x491 = x489 + x490
    x492 = x3 * x491 + x4 * (x3 * x484 - x487)
    x493 = x149 * x326 + x212
    x494 = x77 * (-x484 * x52 + x493)
    x495 = x236 * x485 + x494
    x496 = x149 * x358 + x218
    x497 = x77 * (-x493 * x52 + x496)
    x498 = x236 * x484 + x497
    x499 = x46 * x485
    x500 = x108 * x488
    x501 = x499 + x500
    x502 = x46 * x484
    x503 = x485 * x5
    x504 = x3 * x503
    x505 = x502 + x504
    x506 = x46 * x488
    x507 = x149 * x333 + x174
    x508 = x108 * x507
    x509 = x77 * (-x343 * x488 + x485 * x5)
    x510 = x3 * x506
    x511 = x77 * (x484 * x5 - x503 * x52)
    x512 = x3 * x499
    x513 = x3 * x501 + x511 + x512
    x514 = x484 * x5
    x515 = x77 * (x493 * x5 - x514 * x52)
    x516 = x3 * x484
    x517 = x46 * x516
    x518 = x3 * x505 + x515 + x517
    x519 = x46 * x496
    x520 = x493 * x5
    x521 = x46 * x493
    x522 = x5 * x516 + x521
    x523 = x255 + x310 * x314
    x524 = x245 + x274 * x314
    x525 = x52 * x524
    x526 = x238 * x316 + x240
    x527 = x77 * (x523 - x525)
    x528 = x236 * x526 + x527
    x529 = x3 * x528 + x4 * (x3 * x523 - x3 * x525)
    x530 = x292 + x305 * x314
    x531 = x77 * (-x52 * x523 + x530)
    x532 = x236 * x524 + x531
    x533 = x116 * x238 * x314 + x298
    x534 = x77 * (-x52 * x530 + x533)
    x535 = x236 * x523 + x534
    x536 = x46 * x524
    x537 = x108 * x526 + x536
    x538 = x46 * x523
    x539 = x5 * x524
    x540 = x3 * x539 + x538
    x541 = x46 * x526
    x542 = x238 * x332 + x260
    x543 = x77 * (-x343 * x526 + x5 * x524)
    x544 = x77 * (x5 * x523 - x52 * x539)
    x545 = x3 * x536 + x3 * x537 + x544
    x546 = x5 * x523
    x547 = x77 * (x5 * x530 - x52 * x546)
    x548 = x3 * x523
    x549 = x3 * x540 + x46 * x548 + x547
    x550 = x46 * x533
    x551 = x5 * x530
    x552 = x46 * x530
    x553 = x5 * x548 + x552
    x554 = x149 * x424
    x555 = x52 * x554
    x556 = x77 * (x149 * x425 - x555)
    x557 = x149 * x423
    x558 = x236 * x557 + x556
    x559 = x3 * x558 + x4 * (x149 * x3 * x425 - x3 * x555)
    x560 = x149 * x425
    x561 = x77 * (x149 * x433 - x52 * x560)
    x562 = x149 * x459 + x561
    x563 = x77 * (-x149 * x433 * x52 + x149 * x464)
    x564 = x236 * x560 + x563
    x565 = x149 * x430
    x566 = x149 * x448 + x565
    x567 = x149 * x453
    x568 = x149 * x454 + x567
    x569 = x46 * x557
    x570 = x149 * x440
    x571 = x77 * (x149 * x424 * x5 - x343 * x557)
    x572 = x5 * x554
    x573 = x77 * (x149 * x425 * x5 - x52 * x572)
    x574 = x149 * x451 + x3 * x566 + x573
    x575 = x149 * x438
    x576 = x77 * (x149 * x433 * x5 - x52 * x575)
    x577 = x149 * x482 + x3 * x568 + x576
    x578 = x149 * x464
    x579 = x149 * x456
    x580 = x149 * x457 + x579
    x581 = x149 * x478
    x582 = x238 * x425 + x254
    x583 = x238 * x424 + x244
    x584 = x52 * x583
    x585 = x238 * x423 + x239
    x586 = x236 * x585
    x587 = x77 * (x582 - x584)
    x588 = x586 + x587
    x589 = x3 * x588 + x4 * (x3 * x582 - x3 * x584)
    x590 = x236 * x583
    x591 = x238 * x433 + x291
    x592 = x77 * (-x52 * x582 + x591)
    x593 = x590 + x592
    x594 = x238 * x464 + x297
    x595 = x77 * (-x52 * x591 + x594)
    x596 = x236 * x582 + x595
    x597 = x46 * x583
    x598 = x108 * x585
    x599 = x597 + x598
    x600 = x46 * x582
    x601 = x5 * x583
    x602 = x3 * x601
    x603 = x600 + x602
    x604 = x46 * x585
    x605 = x238 * x440 + x259
    x606 = x108 * x605
    x607 = x77 * (-x343 * x585 + x5 * x583)
    x608 = x3 * x604
    x609 = x77 * (x5 * x582 - x52 * x601)
    x610 = x3 * x597
    x611 = x3 * x599 + x609 + x610
    x612 = x5 * x582
    x613 = x77 * (x5 * x591 - x52 * x612)
    x614 = x3 * x582
    x615 = x46 * x614
    x616 = x3 * x603 + x613 + x615
    x617 = x46 * x594
    x618 = x5 * x591
    x619 = x46 * x591
    x620 = x5 * x614 + x619
    x621 = x149 * x485 + x327 * x43
    x622 = x149 * x488 + x320 * x43
    x623 = x52 * x622
    x624 = x3 * x623
    x625 = x149 * x507 + x334 * x43
    x626 = x236 * x625
    x627 = x77 * (x621 - x623)
    x628 = x236 * x622
    x629 = x149 * x484 + x359 * x43
    x630 = x77 * (-x52 * x621 + x629)
    x631 = x628 + x630
    x632 = x236 * x621
    x633 = x149 * x493 + x363 * x43
    x634 = x77 * (-x52 * x629 + x633)
    x635 = x632 + x634
    x636 = x149 * x524 + x380
    x637 = x149 * x526 + x374
    x638 = x52 * x637
    x639 = x149 * x542 + x386
    x640 = x77 * (x636 - x638)
    x641 = x149 * x523 + x405
    x642 = x77 * (-x52 * x636 + x641)
    x643 = x236 * x637 + x642
    x644 = x149 * x530 + x409
    x645 = x77 * (-x52 * x641 + x644)
    x646 = x236 * x636 + x645
    x647 = x314 * x424 + x435
    x648 = x314 * x423 + x427
    x649 = x52 * x648
    x650 = x314 * x440 + x442
    x651 = x77 * (x647 - x649)
    x652 = x314 * x425 + x466
    x653 = x77 * (-x52 * x647 + x652)
    x654 = x236 * x648 + x653
    x655 = x314 * x433 + x471
    x656 = x77 * (-x52 * x652 + x655)
    x657 = x236 * x647 + x656
    x658 = x149 * x585
    x659 = x52 * x658
    x660 = x77 * (x149 * x583 - x659)
    x661 = x149 * x605
    x662 = x149 * x583
    x663 = x77 * (x149 * x582 - x52 * x662)
    x664 = x149 * x586 + x663
    x665 = x149 * x582
    x666 = x77 * (x149 * x591 - x52 * x665)
    x667 = x149 * x590 + x666
    x668 = x238 * x583 + x43 * x434
    x669 = x238 * x585 + x426 * x43
    x670 = x52 * x669
    x671 = x238 * x605 + x43 * x441
    x672 = x236 * x671
    x673 = x77 * (x668 - x670)
    x674 = x236 * x669
    x675 = x238 * x582 + x43 * x465
    x676 = x77 * (-x52 * x668 + x675)
    x677 = x674 + x676
    x678 = x236 * x668
    x679 = x238 * x591 + x43 * x470
    x680 = x77 * (-x52 * x675 + x679)
    x681 = x678 + x680
    x682 = -x148 - A[1]
    x683 = x45 * x682
    x684 = x50 * x682
    x685 = x683 + x684
    x686 = x60 * x682
    x687 = x63 * x682
    x688 = x686 + x687 * x83
    x689 = x682 * x73
    x690 = x682 * x75
    x691 = x682 * x76
    x692 = x4 * (x59 * x682 - x691)
    x693 = x682 * x79
    x694 = x682 * x81
    x695 = x693 + x694
    x696 = x682 * x84
    x697 = x4 * (x63 * x682 - x696)
    x698 = x682 * x86
    x699 = x5 * x682
    x700 = x196 * x699
    x701 = x698 + x700
    x702 = x3 * x695 + 0.5 * x697 + x701 * x92
    x703 = x682 * x94 + x682 * x96
    x704 = x58 * x682
    x705 = x682 * x98 + x704 * x92
    x706 = x4 * (-x102 * x682 + x58 * x682)
    x707 = x107 * x682
    x708 = x4 * (-x119 * x52 * x682 + x126 * x682)
    x709 = x4 * (x119 * x682 - x52 * x59 * x682)
    x710 = x154 * x682
    x711 = x49 + x710
    x712 = x159 * x682
    x713 = x712 + x95
    x714 = x3 * x711 + x713 * x92
    x715 = x164 * x682
    x716 = x64 + x715
    x717 = x170 * x682
    x718 = x717 + x99
    x719 = x3 * x716 + x718 * x92
    x720 = x176 * x682
    x721 = x720 + x74
    x722 = x153 * x682
    x723 = x722 + x80
    x724 = x4 * (-x52 * x711 + x716)
    x725 = x189 * x5
    x726 = x191 * x699
    x727 = x725 + x726
    x728 = x104 * x727
    x729 = x3 * x723 + x728
    x730 = x4 * (-x52 * x713 + x718)
    x731 = x231 * x682
    x732 = x107 + x731
    x733 = x46 * x732
    x734 = x3 * x727 + x733
    x735 = x104 * x734 + x3 * x729 + 0.5 * x730
    x736 = x106 * x139
    x737 = x231 * x699 + x736
    x738 = x104 * x737
    x739 = x3 * x713 + x738
    x740 = x224 * x5
    x741 = x226 * x699 + x740
    x742 = x104 * x741
    x743 = x3 * x718 + x742
    x744 = x4 * (-x52 * x737 + x741)
    x745 = x132 + x208 * x682
    x746 = x4 * (x131 + x215 * x682 - x52 * x745)
    x747 = x4 * (-x52 * x716 + x745)
    x748 = x243 * x682 + x248 * x682
    x749 = x256 * x682
    x750 = x252 * x682 + x749 * x92
    x751 = x4 * (x251 * x682 - x265 * x682)
    x752 = x140 * x268 * x699 + x267 * x682
    x753 = x4 * (x256 * x682 - x271 * x682)
    x754 = x273 * x682
    x755 = x275 * x682 + x754
    x756 = x104 * x755 + x3 * x752 + 0.5 * x753
    x757 = x278 * x682 + x383 * x699
    x758 = x140 * x32
    x759 = x238 * x758
    x760 = x281 * x682 + x699 * x759
    x761 = x4 * (2.0 * x10 * x17 * x238 * x32 * x4 * x5 * x6 * x682 - x284 * x699)
    x762 = x3 * x682
    x763 = x4 * (-x288 * x52 * x682 + x294 * x682)
    x764 = x4 * (-x251 * x52 * x682 + x288 * x682)
    x765 = x321 * x682
    x766 = 2.0 * x160
    x767 = x765 + x766
    x768 = x318 * x682
    x769 = x5 * x768
    x770 = x197 + x769
    x771 = x104 * x770 + x3 * x767
    x772 = x328 * x682
    x773 = 2.0 * x171 + x772
    x774 = x330 * x682
    x775 = x200 + x774
    x776 = x104 * x775 + x3 * x773
    x777 = x335 * x682
    x778 = 2.0 * x178
    x779 = x777 + x778
    x780 = x317 * x699
    x781 = x185 + x780
    x782 = x4 * (-x52 * x767 + x773)
    x783 = x149 * x83
    x784 = x783 * x89
    x785 = x768 + x784
    x786 = x46 * x785
    x787 = x3 * x781 + x786
    x788 = x4 * (-x52 * x770 + x775)
    x789 = x3 * x786 + x3 * x787 + 0.5 * x788
    x790 = x149 * x758
    x791 = x319 * x682 + x790
    x792 = x46 * x791
    x793 = x3 * x770 + x792
    x794 = x135 * x783 + x326 * x682
    x795 = x46 * x794
    x796 = x3 * x775 + x795
    x797 = x4 * (-x52 * x791 + x794)
    x798 = 2.0 * x221 + x360 * x682
    x799 = x4 * (2.0 * x220 + x364 * x682 - x52 * x798)
    x800 = x4 * (-x52 * x773 + x798)
    x801 = x247 + x375 * x682
    x802 = x273 * x5 + x397 * x699
    x803 = x104 * x802
    x804 = x3 * x801 + x803
    x805 = x257 + x381 * x682
    x806 = x238 * x736 + x399 * x699
    x807 = x104 * x806
    x808 = x3 * x805 + x807
    x809 = x263 + x387 * x682
    x810 = x106 * x268
    x811 = x393 * x699 + x5 * x810
    x812 = x104 * x811
    x813 = x4 * (-x52 * x801 + x805)
    x814 = x273 + x397 * x682
    x815 = x46 * x814
    x816 = x3 * x811 + x815
    x817 = x4 * (-x52 * x802 + x806)
    x818 = x3 * x815 + x3 * x816 + 0.5 * x817
    x819 = x309 + x399 * x682
    x820 = x46 * x819
    x821 = x3 * x802 + x820
    x822 = x226 * x238
    x823 = x304 + x682 * x822
    x824 = x46 * x823
    x825 = x3 * x806 + x824
    x826 = x4 * (-x52 * x819 + x823)
    x827 = x301 + x406 * x682
    x828 = x4 * (x300 + x410 * x682 - x52 * x827)
    x829 = x4 * (-x52 * x805 + x827)
    x830 = x430 * x699
    x831 = x429 * x682 + 2.0 * x830
    x832 = x438 * x682
    x833 = x104 * x832 + x437 * x682
    x834 = x423 * x699
    x835 = x4 * (x436 * x682 - x446 * x682)
    x836 = x430 * x682
    x837 = x448 * x682 + x836
    x838 = x52 * x699
    x839 = x4 * (-x424 * x838 + x425 * x5 * x682)
    x840 = x3 * x837 + x451 * x682 + 0.5 * x839
    x841 = x453 * x682
    x842 = x454 * x682 + x841
    x843 = x456 * x682
    x844 = x457 * x682 + x843
    x845 = x4 * (x433 * x682 - x460 * x682)
    x846 = x4 * (-x467 * x52 * x682 + x472 * x682)
    x847 = x4 * (-x436 * x52 * x682 + x467 * x682)
    x848 = x484 * x682
    x849 = 3.0 * x350
    x850 = x848 + x849
    x851 = x485 * x682
    x852 = 3.0 * x347
    x853 = x851 + x852
    x854 = x52 * x853
    x855 = x488 * x682
    x856 = 3.0 * x323
    x857 = x855 + x856
    x858 = x4 * (x850 - x854)
    x859 = x236 * x857 + 0.5 * x858
    x860 = x46 * x853
    x861 = x5 * x855
    x862 = x5 * x856 + x861
    x863 = x3 * x862 + x860
    x864 = x46 * x850
    x865 = x503 * x682
    x866 = x330 * x92 + x865
    x867 = x3 * x866 + x864
    x868 = x46 * x857
    x869 = x507 * x699
    x870 = x337 * x92
    x871 = x869 + x870
    x872 = x4 * (-x52 * x862 + x866)
    x873 = x5 * x849 + x514 * x682
    x874 = x4 * (x369 * x92 - x52 * x873 + x520 * x682)
    x875 = x4 * (-x52 * x866 + x873)
    x876 = x390 * x758
    x877 = x523 * x682 + x876
    x878 = x196 * x390
    x879 = x524 * x682 + x878
    x880 = x52 * x879
    x881 = x526 * x682
    x882 = x140 * x391
    x883 = x881 + x882
    x884 = x4 * (x877 - x880)
    x885 = x236 * x883 + 0.5 * x884
    x886 = x46 * x879
    x887 = x377 + x5 * x881
    x888 = x3 * x887 + x886
    x889 = x46 * x877
    x890 = x384 + x539 * x682
    x891 = x3 * x890 + x889
    x892 = x46 * x883
    x893 = x388 + x542 * x699
    x894 = x4 * (-x52 * x887 + x890)
    x895 = x413 + x546 * x682
    x896 = x4 * (x416 - x52 * x895 + x551 * x682)
    x897 = x4 * (-x52 * x890 + x895)
    x898 = x456 + x560 * x682
    x899 = x453 + x554 * x682
    x900 = x52 * x899
    x901 = x430 + x557 * x682
    x902 = x4 * (x898 - x900)
    x903 = x236 * x901 + 0.5 * x902
    x904 = x46 * x899
    x905 = x431 + x557 * x699
    x906 = x3 * x905 + x904
    x907 = x46 * x898
    x908 = x438 * x46 + x572 * x682
    x909 = x3 * x908 + x907
    x910 = x46 * x901
    x911 = x445 * x46 + x570 * x699
    x912 = x4 * (-x52 * x905 + x908)
    x913 = x475 + x575 * x682
    x914 = x4 * (x46 * x477 - x52 * x913 + x581 * x682)
    x915 = x4 * (-x52 * x908 + x913)
    x916 = x4 * (x582 * x682 - x584 * x682)
    x917 = x586 * x682 + 0.5 * x916
    x918 = x597 * x682
    x919 = x598 * x682 + x918
    x920 = x600 * x682
    x921 = x602 * x682 + x920
    x922 = x604 * x682
    x923 = x4 * (x5 * x583 * x682 - x585 * x838)
    x924 = x4 * (x5 * x591 * x682 - x52 * x612 * x682)
    x925 = x4 * (x5 * x582 * x682 - x52 * x601 * x682)
    x926 = x621 * x682
    x927 = 4.0 * x502
    x928 = x926 + x927
    x929 = x622 * x682
    x930 = 4.0 * x499
    x931 = x929 + x930
    x932 = x52 * x931
    x933 = x625 * x682
    x934 = 4.0 * x506
    x935 = x933 + x934
    x936 = x4 * (x928 - x932)
    x937 = 4.0 * x521 + x629 * x682
    x938 = x4 * (4.0 * x519 - x52 * x937 + x633 * x682)
    x939 = x4 * (-x52 * x928 + x937)
    x940 = 3.0 * x538 + x636 * x682
    x941 = 3.0 * x536 + x637 * x682
    x942 = x52 * x941
    x943 = 3.0 * x541 + x639 * x682
    x944 = x4 * (x940 - x942)
    x945 = 3.0 * x552 + x641 * x682
    x946 = x4 * (-x52 * x945 + 3.0 * x550 + x644 * x682)
    x947 = x4 * (-x52 * x940 + x945)
    x948 = 2.0 * x567 + x647 * x682
    x949 = 2.0 * x565 + x648 * x682
    x950 = x52 * x949
    x951 = x104 * x557 + x650 * x682
    x952 = x4 * (x948 - x950)
    x953 = 2.0 * x579 + x652 * x682
    x954 = x4 * (x104 * x578 - x52 * x953 + x655 * x682)
    x955 = x4 * (-x52 * x948 + x953)
    x956 = x600 + x662 * x682
    x957 = x597 + x658 * x682
    x958 = x52 * x957
    x959 = x604 + x661 * x682
    x960 = x4 * (x956 - x958)
    x961 = x149 * x591
    x962 = x619 + x665 * x682
    x963 = x4 * (-x52 * x962 + x617 + x682 * x961)
    x964 = x4 * (-x52 * x956 + x962)
    x965 = x4 * (x668 * x682 - x670 * x682)
    x966 = x4 * (-x52 * x675 * x682 + x679 * x682)
    x967 = x4 * (-x52 * x668 * x682 + x675 * x682)
    x968 = -x237 - A[2]
    x969 = x45 * x968 + x50 * x968
    x970 = x60 * x968 + x65 * x968
    x971 = x4 * (x59 * x968 - x76 * x968)
    x972 = 0.5 * x971
    x973 = x79 * x968 + x81 * x968
    x974 = x4 * (x63 * x968 - x84 * x968)
    x975 = 0.5 * x974
    x976 = x5 * x968
    x977 = x196 * x976 + x86 * x968
    x978 = x3 * x973 + x92 * x977 + x975
    x979 = x94 * x968 + x96 * x968
    x980 = x100 * x968 + x968 * x98
    x981 = x4 * (-x102 * x968 + x58 * x968)
    x982 = 0.5 * x981
    x983 = x107 * x968
    x984 = x4 * (-x119 * x52 * x968 + x126 * x968)
    x985 = 0.5 * x984
    x986 = x59 * x968
    x987 = x4 * (x119 * x968 - x52 * x986)
    x988 = 0.5 * x987
    x989 = x155 * x968 + x161 * x968
    x990 = x170 * x968
    x991 = x165 * x968 + x92 * x990
    x992 = x4 * (x164 * x968 - x180 * x968)
    x993 = 0.5 * x992
    x994 = x149 * x976
    x995 = x9 * x994
    x996 = x140 * x995
    x997 = x182 * x968 + x996
    x998 = x4 * (x170 * x968 - x187 * x968)
    x999 = 0.5 * x998
    x1000 = x190 * x968
    x1001 = x1000 + x192 * x968
    x1002 = x1001 * x104 + x3 * x997 + x999
    x1003 = x784 * x976
    x1004 = x1003 + x195 * x968
    x1005 = x790 * x976
    x1006 = x1005 + x199 * x968
    x1007 = x4 * (2.0 * x10 * x149 * x17 * x32 * x4 * x5 * x6 * x968 - x202 * x994)
    x1008 = 0.5 * x1007
    x1009 = x4 * (-x208 * x52 * x968 + x215 * x968)
    x1010 = 0.5 * x1009
    x1011 = x4 * (-x164 * x52 * x968 + x208 * x968)
    x1012 = 0.5 * x1011
    x1013 = x242 * x968 + x49
    x1014 = x1013 * x3
    x1015 = x246 * x968 + x95
    x1016 = x1015 * x46
    x1017 = 3.0 * x1016
    x1018 = x1014 + x1017
    x1019 = x251 * x968 + x64
    x1020 = x1019 * x3
    x1021 = x256 * x968 + x99
    x1022 = x1021 * x46
    x1023 = x1020 + 3.0 * x1022
    x1024 = x261 * x968 + x74
    x1025 = x1024 * x3
    x1026 = x241 * x968 + x80
    x1027 = x1026 * x46
    x1028 = 3.0 * x1027
    x1029 = x1013 * x52
    x1030 = x4 * (x1019 - x1029)
    x1031 = 0.5 * x1030
    x1032 = x1026 * x3
    x1033 = x274 * x976 + x725
    x1034 = x1033 * x46
    x1035 = 2.0 * x1034
    x1036 = x1032 + x1035
    x1037 = x1015 * x52
    x1038 = x4 * (x1021 - x1037)
    x1039 = 0.5 * x1038
    x1040 = x107 + x310 * x968
    x1041 = x1040 * x46
    x1042 = x1033 * x3
    x1043 = x1041 + x1042
    x1044 = x1036 * x3 + x1039 + x104 * x1043
    x1045 = x310 * x976 + x736
    x1046 = x1045 * x46
    x1047 = 2.0 * x1046
    x1048 = x1015 * x3 + x1047
    x1049 = x305 * x976 + x740
    x1050 = x1049 * x46
    x1051 = 2.0 * x1050
    x1052 = x1021 * x3 + x1051
    x1053 = x4 * (-x1045 * x52 + x1049)
    x1054 = 0.5 * x1053
    x1055 = x132 + x288 * x968
    x1056 = x4 * (-x1055 * x52 + x131 + x294 * x968)
    x1057 = 0.5 * x1056
    x1058 = x4 * (-x1019 * x52 + x1055)
    x1059 = 0.5 * x1058
    x1060 = x323 * x968
    x1061 = x1060 * x5
    x1062 = 2.0 * x1061 + x322 * x968
    x1063 = x330 * x968
    x1064 = x104 * x1063 + x329 * x968
    x1065 = x4 * (x328 * x968 - x339 * x968)
    x1066 = 0.5 * x1065
    x1067 = x1060 + x341 * x968
    x1068 = x52 * x976
    x1069 = x4 * (-x1068 * x318 + x319 * x5 * x968)
    x1070 = 0.5 * x1069
    x1071 = x1067 * x3 + x1070 + x345 * x968
    x1072 = x347 * x968
    x1073 = x1072 + x348 * x968
    x1074 = x350 * x968
    x1075 = x1074 + x351 * x968
    x1076 = x4 * (x326 * x968 - x354 * x968)
    x1077 = 0.5 * x1076
    x1078 = x4 * (-x360 * x52 * x968 + x364 * x968)
    x1079 = 0.5 * x1078
    x1080 = x4 * (-x328 * x52 * x968 + x360 * x968)
    x1081 = 0.5 * x1080
    x1082 = x160 + x375 * x968
    x1083 = x183 * x189 + x397 * x976
    x1084 = x104 * x1083
    x1085 = x1082 * x3 + x1084
    x1086 = x171 + x381 * x968
    x1087 = x149 * x736 + x399 * x976
    x1088 = x104 * x1087
    x1089 = x1086 * x3 + x1088
    x1090 = x178 + x387 * x968
    x1091 = x106 * x184 + x393 * x976
    x1092 = x104 * x1091
    x1093 = x4 * (-x1082 * x52 + x1086)
    x1094 = 0.5 * x1093
    x1095 = x190 + x397 * x968
    x1096 = x1095 * x46
    x1097 = x1091 * x3 + x1096
    x1098 = x4 * (-x1083 * x52 + x1087)
    x1099 = 0.5 * x1098
    x1100 = x1096 * x3 + x1097 * x3 + x1099
    x1101 = x230 + x399 * x968
    x1102 = x1101 * x46
    x1103 = x1083 * x3 + x1102
    x1104 = x225 + x822 * x968
    x1105 = x1104 * x46
    x1106 = x1087 * x3 + x1105
    x1107 = x4 * (-x1101 * x52 + x1104)
    x1108 = 0.5 * x1107
    x1109 = x221 + x406 * x968
    x1110 = x4 * (-x1109 * x52 + x220 + x410 * x968)
    x1111 = 0.5 * x1110
    x1112 = x4 * (-x1086 * x52 + x1109)
    x1113 = 0.5 * x1112
    x1114 = 2.0 * x247 + x428 * x968
    x1115 = x1114 * x3
    x1116 = x424 * x968
    x1117 = x1116 * x5
    x1118 = x1117 + x279
    x1119 = x1118 * x46
    x1120 = 2.0 * x1119
    x1121 = x1115 + x1120
    x1122 = 2.0 * x257 + x436 * x968
    x1123 = x1122 * x3
    x1124 = x282 + x438 * x968
    x1125 = x1124 * x46
    x1126 = x1123 + 2.0 * x1125
    x1127 = 2.0 * x263 + x443 * x968
    x1128 = x1127 * x3
    x1129 = x269 + x445 * x968
    x1130 = x1129 * x46
    x1131 = 2.0 * x1130
    x1132 = x1114 * x52
    x1133 = x4 * (x1122 - x1132)
    x1134 = 0.5 * x1133
    x1135 = x1116 + x383
    x1136 = x1135 * x46
    x1137 = x1129 * x3
    x1138 = x1136 + x1137
    x1139 = x1118 * x52
    x1140 = x4 * (x1124 - x1139)
    x1141 = 0.5 * x1140
    x1142 = x1136 * x3
    x1143 = x1138 * x3 + x1141 + x1142
    x1144 = x425 * x968 + x759
    x1145 = x1144 * x46
    x1146 = x1118 * x3 + x1145
    x1147 = x415 + x433 * x968
    x1148 = x1147 * x46
    x1149 = x1124 * x3 + x1148
    x1150 = x4 * (-x1144 * x52 + x1147)
    x1151 = 0.5 * x1150
    x1152 = 2.0 * x301 + x467 * x968
    x1153 = x4 * (-x1152 * x52 + 2.0 * x300 + x472 * x968)
    x1154 = 0.5 * x1153
    x1155 = x4 * (-x1122 * x52 + x1152)
    x1156 = 0.5 * x1155
    x1157 = x4 * (x484 * x968 - x486 * x968)
    x1158 = 0.5 * x1157
    x1159 = x1158 + x489 * x968
    x1160 = x499 * x968
    x1161 = x1160 + x500 * x968
    x1162 = x502 * x968
    x1163 = x1162 + x504 * x968
    x1164 = x506 * x968
    x1165 = x4 * (-x1068 * x488 + x485 * x5 * x968)
    x1166 = 0.5 * x1165
    x1167 = x4 * (x493 * x5 * x968 - x514 * x52 * x968)
    x1168 = 0.5 * x1167
    x1169 = x4 * (x484 * x5 * x968 - x503 * x52 * x968)
    x1170 = 0.5 * x1169
    x1171 = x350 + x523 * x968
    x1172 = x347 + x524 * x968
    x1173 = x1172 * x52
    x1174 = x526 * x968
    x1175 = x1174 + x323
    x1176 = x4 * (x1171 - x1173)
    x1177 = 0.5 * x1176
    x1178 = x1175 * x236 + x1177
    x1179 = x1172 * x46
    x1180 = x1174 * x5 + x324
    x1181 = x1179 + x1180 * x3
    x1182 = x1171 * x46
    x1183 = x330 * x46 + x539 * x968
    x1184 = x1182 + x1183 * x3
    x1185 = x1175 * x46
    x1186 = x337 * x46
    x1187 = x1186 + x542 * x976
    x1188 = x4 * (-x1180 * x52 + x1183)
    x1189 = 0.5 * x1188
    x1190 = x367 + x546 * x968
    x1191 = x4 * (-x1190 * x52 + x369 * x46 + x551 * x968)
    x1192 = 0.5 * x1191
    x1193 = x4 * (-x1183 * x52 + x1190)
    x1194 = 0.5 * x1193
    x1195 = x560 * x968 + x876
    x1196 = x1116 * x149 + x878
    x1197 = x1196 * x52
    x1198 = x557 * x968 + x882
    x1199 = x4 * (x1195 - x1197)
    x1200 = 0.5 * x1199
    x1201 = x1198 * x236 + x1200
    x1202 = x1196 * x46
    x1203 = x377 + x557 * x976
    x1204 = x1202 + x1203 * x3
    x1205 = x1195 * x46
    x1206 = x1117 * x149 + x384
    x1207 = x1205 + x1206 * x3
    x1208 = x1198 * x46
    x1209 = x388 + x570 * x976
    x1210 = x4 * (-x1203 * x52 + x1206)
    x1211 = 0.5 * x1210
    x1212 = x413 + x575 * x968
    x1213 = x4 * (-x1212 * x52 + x416 + x581 * x968)
    x1214 = 0.5 * x1213
    x1215 = x4 * (-x1206 * x52 + x1212)
    x1216 = 0.5 * x1215
    x1217 = 3.0 * x456 + x582 * x968
    x1218 = 3.0 * x453 + x583 * x968
    x1219 = x1218 * x52
    x1220 = x585 * x968
    x1221 = x1220 + 3.0 * x430
    x1222 = x1221 * x236
    x1223 = x4 * (x1217 - x1219)
    x1224 = 0.5 * x1223
    x1225 = x1222 + x1224
    x1226 = x1218 * x46
    x1227 = x1220 * x5 + 3.0 * x431
    x1228 = x1227 * x3
    x1229 = x1226 + x1228
    x1230 = x1217 * x46
    x1231 = x438 * x92 + x601 * x968
    x1232 = x1231 * x3
    x1233 = x1230 + x1232
    x1234 = x1221 * x46
    x1235 = x445 * x92 + x605 * x976
    x1236 = x1235 * x3
    x1237 = x1227 * x52
    x1238 = x4 * (x1231 - x1237)
    x1239 = 0.5 * x1238
    x1240 = x1234 * x3
    x1241 = 3.0 * x475 + x612 * x968
    x1242 = x4 * (-x1241 * x52 + x477 * x92 + x618 * x968)
    x1243 = 0.5 * x1242
    x1244 = x4 * (-x1231 * x52 + x1241)
    x1245 = 0.5 * x1244
    x1246 = x4 * (x621 * x968 - x623 * x968)
    x1247 = 0.5 * x1246
    x1248 = x4 * (-x52 * x629 * x968 + x633 * x968)
    x1249 = 0.5 * x1248
    x1250 = x4 * (-x52 * x621 * x968 + x629 * x968)
    x1251 = 0.5 * x1250
    x1252 = x502 + x636 * x968
    x1253 = x499 + x637 * x968
    x1254 = x1253 * x52
    x1255 = x506 + x639 * x968
    x1256 = x4 * (x1252 - x1254)
    x1257 = 0.5 * x1256
    x1258 = x521 + x641 * x968
    x1259 = x4 * (-x1258 * x52 + x519 + x644 * x968)
    x1260 = 0.5 * x1259
    x1261 = x4 * (-x1252 * x52 + x1258)
    x1262 = 0.5 * x1261
    x1263 = 2.0 * x538 + x647 * x968
    x1264 = 2.0 * x536 + x648 * x968
    x1265 = x1264 * x52
    x1266 = 2.0 * x541 + x650 * x968
    x1267 = x4 * (x1263 - x1265)
    x1268 = 0.5 * x1267
    x1269 = 2.0 * x552 + x652 * x968
    x1270 = x4 * (-x1269 * x52 + 2.0 * x550 + x655 * x968)
    x1271 = 0.5 * x1270
    x1272 = x4 * (-x1263 * x52 + x1269)
    x1273 = 0.5 * x1272
    x1274 = 3.0 * x567 + x662 * x968
    x1275 = x1220 * x149 + 3.0 * x565
    x1276 = x1275 * x52
    x1277 = x557 * x92 + x661 * x968
    x1278 = x4 * (x1274 - x1276)
    x1279 = 0.5 * x1278
    x1280 = 3.0 * x579 + x665 * x968
    x1281 = x4 * (-x1280 * x52 + x578 * x92 + x961 * x968)
    x1282 = 0.5 * x1281
    x1283 = x4 * (-x1274 * x52 + x1280)
    x1284 = 0.5 * x1283
    x1285 = 4.0 * x600 + x668 * x968
    x1286 = 4.0 * x597 + x669 * x968
    x1287 = x1286 * x52
    x1288 = 4.0 * x604 + x671 * x968
    x1289 = x1288 * x236
    x1290 = x4 * (x1285 - x1287)
    x1291 = 0.5 * x1290
    x1292 = 4.0 * x619 + x675 * x968
    x1293 = x4 * (-x1292 * x52 + 4.0 * x617 + x679 * x968)
    x1294 = 0.5 * x1293
    x1295 = x4 * (-x1285 * x52 + x1292)
    x1296 = 0.5 * x1295
    x1297 = x682**2
    x1298 = x127 + x1297 * x59
    x1299 = x1297 * x63 + x134
    x1300 = x1299 * x46
    x1301 = x1297 * x44
    x1302 = x120 + x1301
    x1303 = x1297 * x48 + x138
    x1304 = x1303 * x46
    x1305 = x1297 * x72
    x1306 = x1305 + x78
    x1307 = x1297 * x29
    x1308 = x1307 + x85
    x1309 = x1308 * x46
    x1310 = x1298 - x1302 * x52
    x1311 = x1297 * x36
    x1312 = x103 + x1311
    x1313 = x1312 * x46
    x1314 = x1308 * x3 + 3.0 * x1313
    x1315 = x1299 - x1303 * x52
    x1316 = x1297 * x5
    x1317 = x46 * (x1316 * x40 + x146)
    x1318 = x46 * x687
    x1319 = x1318 + x216 + x682 * x716
    x1320 = x223 + x46 * x704 + x682 * x718
    x1321 = x49 * x682
    x1322 = x1321 + x209 + x682 * x711
    x1323 = x229 + x682 * x713 + x682 * x95
    x1324 = x682 * x74
    x1325 = x1324 + x181 + x682 * x721
    x1326 = x682 * x80
    x1327 = x1326 + x188 + x682 * x723
    x1328 = x1319 - x1322 * x52
    x1329 = x189 * x699
    x1330 = x1329 + x204 + x682 * x727
    x1331 = x104 * x1330
    x1332 = x1327 * x3 + x1331
    x1333 = x1320 - x1323 * x52
    x1334 = x46 * (x235 + x682 * x732 + x707)
    x1335 = x1297 * x251 + x295
    x1336 = x1297 * x256 + x303
    x1337 = x1336 * x46
    x1338 = x1297 * x242 + x289
    x1339 = x1297 * x246 + x308
    x1340 = x1339 * x46
    x1341 = x1297 * x261 + x266
    x1342 = x1297 * x241 + x272
    x1343 = x1342 * x46
    x1344 = x1335 - x1338 * x52
    x1345 = x1316 * x274 + x285
    x1346 = x1345 * x46
    x1347 = x1342 * x3 + 2.0 * x1346
    x1348 = x1336 - x1339 * x52
    x1349 = x46 * (x1297 * x310 + x313)
    x1350 = x104 * x718 + x365 + x682 * x773
    x1351 = x370 + x682 * x775 + x742
    x1352 = x104 * x713 + x361 + x682 * x767
    x1353 = x372 + x682 * x770 + x738
    x1354 = x104 * x723 + x340 + x682 * x779
    x1355 = x344 + x682 * x781 + x728
    x1356 = x1350 - x1352 * x52
    x1357 = x355 + x682 * x785 + 2.0 * x733
    x1358 = x1357 * x46
    x1359 = x1355 * x3 + x1358
    x1360 = x1351 - x1353 * x52
    x1361 = x411 + x46 * x749 + x682 * x805
    x1362 = x309 * x699 + x417 + x682 * x806
    x1363 = x104 * x1362
    x1364 = x247 * x682 + x407 + x682 * x801
    x1365 = x273 * x699 + x419 + x682 * x802
    x1366 = x104 * x1365
    x1367 = x263 * x682 + x389 + x682 * x809
    x1368 = x395 + x682 * x811 + x699 * x810
    x1369 = x104 * x1368
    x1370 = x1361 - x1364 * x52
    x1371 = x402 + x682 * x814 + x754
    x1372 = x1371 * x46
    x1373 = x1368 * x3 + x1372
    x1374 = x1362 - x1365 * x52
    x1375 = x1297 * x436 + x473
    x1376 = x1297 * x438 + x479
    x1377 = x1376 * x46
    x1378 = x1297 * x428 + x468
    x1379 = x1297 * x424
    x1380 = x1379 * x5 + x481
    x1381 = x1380 * x46
    x1382 = x1297 * x443 + x447
    x1383 = x1297 * x445 + x450
    x1384 = x1383 * x46
    x1385 = x1375 - x1378 * x52
    x1386 = x1379 + x461
    x1387 = x1386 * x46
    x1388 = x1383 * x3 + x1387
    x1389 = x1376 - x1380 * x52
    x1390 = x497 + x682 * x850 + 3.0 * x795
    x1391 = x1390 * x46
    x1392 = x515 + x682 * x866 + x775 * x92
    x1393 = x494 + x682 * x853 + 3.0 * x792
    x1394 = x1393 * x46
    x1395 = x511 + x682 * x862 + x770 * x92
    x1396 = x490 + x682 * x857 + 3.0 * x786
    x1397 = x1390 - x1393 * x52
    x1398 = x1396 * x46
    x1399 = x509 + x682 * x871 + x781 * x92
    x1400 = x1392 - x1395 * x52
    x1401 = x534 + x682 * x877 + 2.0 * x824
    x1402 = x1401 * x46
    x1403 = x547 + x682 * x890 + x807
    x1404 = x531 + x682 * x879 + 2.0 * x820
    x1405 = x1404 * x46
    x1406 = x544 + x682 * x887 + x803
    x1407 = x527 + x682 * x883 + 2.0 * x815
    x1408 = x1401 - x1404 * x52
    x1409 = x1407 * x46
    x1410 = x543 + x682 * x893 + x812
    x1411 = x1403 - x1406 * x52
    x1412 = x563 + x682 * x898 + x843
    x1413 = x1412 * x46
    x1414 = x46 * x832 + x576 + x682 * x908
    x1415 = x561 + x682 * x899 + x841
    x1416 = x1415 * x46
    x1417 = x573 + x682 * x905 + x830
    x1418 = x556 + x682 * x901 + x836
    x1419 = x1412 - x1415 * x52
    x1420 = x1418 * x46
    x1421 = x46 * x834 + x571 + x682 * x911
    x1422 = x1414 - x1417 * x52
    x1423 = x1297 * x582 + x595
    x1424 = x1423 * x46
    x1425 = x1297 * x601 + x613
    x1426 = x1297 * x583 + x592
    x1427 = x1426 * x46
    x1428 = x1297 * x585
    x1429 = x1428 * x5 + x609
    x1430 = x1428 + x587
    x1431 = x1423 - x1426 * x52
    x1432 = x1430 * x46
    x1433 = x1316 * x605 + x607
    x1434 = x1425 - x1429 * x52
    x1435 = x634 + x682 * x928 + 4.0 * x864
    x1436 = x630 + x682 * x931 + 4.0 * x860
    x1437 = x1436 * x52
    x1438 = x627 + x682 * x935 + 4.0 * x868
    x1439 = x1435 - x1437
    x1440 = x645 + x682 * x940 + 3.0 * x889
    x1441 = x642 + x682 * x941 + 3.0 * x886
    x1442 = x1441 * x52
    x1443 = x640 + x682 * x943 + 3.0 * x892
    x1444 = x1440 - x1442
    x1445 = x656 + x682 * x948 + 2.0 * x907
    x1446 = x653 + x682 * x949 + 2.0 * x904
    x1447 = x1446 * x52
    x1448 = x651 + x682 * x951 + 2.0 * x910
    x1449 = x1445 - x1447
    x1450 = x666 + x682 * x956 + x920
    x1451 = x663 + x682 * x957 + x918
    x1452 = x1451 * x52
    x1453 = x660 + x682 * x959 + x922
    x1454 = x1450 - x1452
    x1455 = x1297 * x668 + x680
    x1456 = x1297 * x669 + x676
    x1457 = x1456 * x52
    x1458 = x1297 * x671 + x673
    x1459 = x1455 - x1457
    x1460 = x4 * (x59 * x682 * x968 - x691 * x968)
    x1461 = x693 * x968 + x694 * x968
    x1462 = x4 * (x63 * x682 * x968 - x696 * x968)
    x1463 = x64 * x968
    x1464 = x1463 + x715 * x968
    x1465 = x968 * x99
    x1466 = x1465 + x717 * x968
    x1467 = x49 * x968
    x1468 = x1467 + x710 * x968
    x1469 = x95 * x968
    x1470 = x1469 + x712 * x968
    x1471 = x74 * x968
    x1472 = x1471 + x720 * x968
    x1473 = x80 * x968
    x1474 = x1473 + x722 * x968
    x1475 = x4 * (x1464 - x1468 * x52)
    x1476 = x189 * x976
    x1477 = x1476 + x726 * x968
    x1478 = x104 * x1477
    x1479 = x1474 * x3 + x1478
    x1480 = x4 * (x1466 - x1470 * x52)
    x1481 = x46 * (x731 * x968 + x983)
    x1482 = x1021 * x682
    x1483 = x4 * (x1019 * x682 - x1029 * x682)
    x1484 = x1032 * x682 + x1035 * x682
    x1485 = x4 * (x1021 * x682 - x1037 * x682)
    x1486 = x1041 * x682
    x1487 = x104 * x990 + x772 * x968
    x1488 = x1005 + x774 * x968
    x1489 = x765 * x968 + x766 * x968
    x1490 = x1003 + x769 * x968
    x1491 = x777 * x968 + x778 * x968
    x1492 = x780 * x968 + x996
    x1493 = x4 * (x1487 - x1489 * x52)
    x1494 = x768 * x968 + x784 * x968
    x1495 = x1494 * x46
    x1496 = x1492 * x3 + x1495
    x1497 = x4 * (x1488 - x1490 * x52)
    x1498 = x1022 + x1086 * x682
    x1499 = x1050 + x1087 * x682
    x1500 = x104 * x1499
    x1501 = x1016 + x1082 * x682
    x1502 = x1046 + x1083 * x682
    x1503 = x104 * x1502
    x1504 = x1027 + x1090 * x682
    x1505 = x1034 + x1091 * x682
    x1506 = x104 * x1505
    x1507 = x4 * (x1498 - x1501 * x52)
    x1508 = x1041 + x1095 * x682
    x1509 = x1508 * x46
    x1510 = x1505 * x3 + x1509
    x1511 = x4 * (x1499 - x1502 * x52)
    x1512 = x1124 * x682
    x1513 = x4 * (x1122 * x682 - x1132 * x682)
    x1514 = x1136 * x682
    x1515 = x1137 * x682 + x1514
    x1516 = x4 * (x1124 * x682 - x1139 * x682)
    x1517 = x848 * x968 + x849 * x968
    x1518 = x1517 * x46
    x1519 = x1063 * x92 + x865 * x968
    x1520 = x851 * x968 + x852 * x968
    x1521 = x1520 * x46
    x1522 = x856 * x976 + x861 * x968
    x1523 = x855 * x968 + x856 * x968
    x1524 = x4 * (x1517 - x1520 * x52)
    x1525 = x1523 * x46
    x1526 = x869 * x968 + x870 * x968
    x1527 = x4 * (x1519 - x1522 * x52)
    x1528 = 2.0 * x1105
    x1529 = x1171 * x682 + x1528
    x1530 = x1529 * x46
    x1531 = x1088 + x1183 * x682
    x1532 = 2.0 * x1102
    x1533 = x1172 * x682 + x1532
    x1534 = x1533 * x46
    x1535 = x1084 + x1180 * x682
    x1536 = 2.0 * x1096
    x1537 = x1175 * x682 + x1536
    x1538 = x4 * (x1529 - x1533 * x52)
    x1539 = x1537 * x46
    x1540 = x1092 + x1187 * x682
    x1541 = x4 * (x1531 - x1535 * x52)
    x1542 = x1148 + x1195 * x682
    x1543 = x1542 * x46
    x1544 = x1125 + x1206 * x682
    x1545 = x1145 + x1196 * x682
    x1546 = x1545 * x46
    x1547 = x1119 + x1203 * x682
    x1548 = x1136 + x1198 * x682
    x1549 = x4 * (x1542 - x1545 * x52)
    x1550 = x1548 * x46
    x1551 = x1130 + x1209 * x682
    x1552 = x4 * (x1544 - x1547 * x52)
    x1553 = x1230 * x682
    x1554 = x1226 * x682
    x1555 = x4 * (x1217 * x682 - x1219 * x682)
    x1556 = x1234 * x682
    x1557 = x4 * (x1231 * x682 - x1237 * x682)
    x1558 = x926 * x968 + x927 * x968
    x1559 = x929 * x968 + x930 * x968
    x1560 = x1559 * x52
    x1561 = x933 * x968 + x934 * x968
    x1562 = x4 * (x1558 - x1560)
    x1563 = 3.0 * x1182 + x1252 * x682
    x1564 = 3.0 * x1179 + x1253 * x682
    x1565 = x1564 * x52
    x1566 = 3.0 * x1185 + x1255 * x682
    x1567 = x4 * (x1563 - x1565)
    x1568 = 2.0 * x1205 + x1263 * x682
    x1569 = 2.0 * x1202 + x1264 * x682
    x1570 = x1569 * x52
    x1571 = 2.0 * x1208 + x1266 * x682
    x1572 = x4 * (x1568 - x1570)
    x1573 = x1230 + x1274 * x682
    x1574 = x1226 + x1275 * x682
    x1575 = x1574 * x52
    x1576 = x1234 + x1277 * x682
    x1577 = x4 * (x1573 - x1575)
    x1578 = x4 * (x1285 * x682 - x1287 * x682)
    x1579 = x968**2
    x1580 = x127 + x1579 * x59
    x1581 = x134 + x1579 * x63
    x1582 = x1581 * x46
    x1583 = x120 + x1579 * x44
    x1584 = x138 + x1579 * x48
    x1585 = x1584 * x46
    x1586 = x1579 * x72 + x78
    x1587 = x1586 * x3
    x1588 = x1579 * x29 + x85
    x1589 = x1588 * x46
    x1590 = 4.0 * x1589
    x1591 = x1583 * x52
    x1592 = x1580 - x1591
    x1593 = x1592 * x77
    x1594 = x1588 * x3
    x1595 = x103 + x1579 * x36
    x1596 = x1595 * x46
    x1597 = 3.0 * x1596
    x1598 = x1594 + x1597
    x1599 = x1581 - x1584 * x52
    x1600 = x1599 * x77
    x1601 = x1579 * x5
    x1602 = x46 * (x146 + x1601 * x40)
    x1603 = x1579 * x164 + x216
    x1604 = x1579 * x170 + x223
    x1605 = x1604 * x46
    x1606 = x154 * x1579 + x209
    x1607 = x1579 * x159 + x229
    x1608 = x1607 * x46
    x1609 = x1579 * x176 + x181
    x1610 = x153 * x1579 + x188
    x1611 = x1610 * x46
    x1612 = x1603 - x1606 * x52
    x1613 = x1612 * x77
    x1614 = x1601 * x191 + x204
    x1615 = x1614 * x46
    x1616 = 2.0 * x1615
    x1617 = x1610 * x3 + x1616
    x1618 = x1604 - x1607 * x52
    x1619 = x1618 * x77
    x1620 = x46 * (x1579 * x231 + x235)
    x1621 = x1019 * x968 + x1463 + x295
    x1622 = x1021 * x968 + x1465 + x303
    x1623 = x1622 * x46
    x1624 = x1013 * x968 + x1467 + x289
    x1625 = x1015 * x968 + x1469 + x308
    x1626 = x1625 * x46
    x1627 = x1024 * x968 + x1471 + x266
    x1628 = x1627 * x3
    x1629 = x1026 * x968 + x1473 + x272
    x1630 = x1629 * x46
    x1631 = 3.0 * x1630
    x1632 = x1624 * x52
    x1633 = x1621 - x1632
    x1634 = x1633 * x77
    x1635 = x1629 * x3
    x1636 = x1033 * x968 + x1476 + x285
    x1637 = x1636 * x46
    x1638 = 2.0 * x1637
    x1639 = x1635 + x1638
    x1640 = x1622 - x1625 * x52
    x1641 = x1640 * x77
    x1642 = x46 * (x1040 * x968 + x313 + x983)
    x1643 = x1579 * x328 + x365
    x1644 = x1579 * x330 + x370
    x1645 = x1644 * x46
    x1646 = x1579 * x321 + x361
    x1647 = x1579 * x318
    x1648 = x1647 * x5 + x372
    x1649 = x1648 * x46
    x1650 = x1579 * x335 + x340
    x1651 = x1579 * x337 + x344
    x1652 = x1651 * x46
    x1653 = x1643 - x1646 * x52
    x1654 = x1653 * x77
    x1655 = x1647 + x355
    x1656 = x1655 * x46
    x1657 = x1651 * x3 + x1656
    x1658 = x1644 - x1648 * x52
    x1659 = x1658 * x77
    x1660 = x1086 * x968 + x411 + x46 * x990
    x1661 = x1087 * x968 + x230 * x976 + x417
    x1662 = x104 * x1661
    x1663 = x1082 * x968 + x160 * x968 + x407
    x1664 = x1083 * x968 + x190 * x976 + x419
    x1665 = x104 * x1664
    x1666 = x1090 * x968 + x178 * x968 + x389
    x1667 = x106 * x995 + x1091 * x968 + x395
    x1668 = x104 * x1667
    x1669 = x1660 - x1663 * x52
    x1670 = x1669 * x77
    x1671 = x1000 + x1095 * x968 + x402
    x1672 = x1671 * x46
    x1673 = x1667 * x3 + x1672
    x1674 = x1661 - x1664 * x52
    x1675 = x1674 * x77
    x1676 = 2.0 * x1022 + x1122 * x968 + x473
    x1677 = x1051 + x1124 * x968 + x479
    x1678 = x1677 * x46
    x1679 = 2.0 * x1016 + x1114 * x968 + x468
    x1680 = x1047 + x1118 * x968 + x481
    x1681 = x1680 * x46
    x1682 = 2.0 * x1027 + x1127 * x968 + x447
    x1683 = x1682 * x3
    x1684 = x1035 + x1129 * x968 + x450
    x1685 = x1684 * x46
    x1686 = 2.0 * x1685
    x1687 = x1679 * x52
    x1688 = x1676 - x1687
    x1689 = x1688 * x77
    x1690 = 2.0 * x1041 + x1135 * x968 + x461
    x1691 = x1690 * x46
    x1692 = x1684 * x3
    x1693 = x1691 + x1692
    x1694 = x1677 - x1680 * x52
    x1695 = x1694 * x77
    x1696 = x1579 * x484 + x497
    x1697 = x1696 * x46
    x1698 = x1579 * x503 + x515
    x1699 = x1579 * x485 + x494
    x1700 = x1699 * x46
    x1701 = x1579 * x488
    x1702 = x1701 * x5 + x511
    x1703 = x1701 + x490
    x1704 = x1696 - x1699 * x52
    x1705 = x1704 * x77
    x1706 = x1703 * x46
    x1707 = x1601 * x507 + x509
    x1708 = x1698 - x1702 * x52
    x1709 = x1708 * x77
    x1710 = x1074 + x1171 * x968 + x534
    x1711 = x1710 * x46
    x1712 = x1063 * x46 + x1183 * x968 + x547
    x1713 = x1072 + x1172 * x968 + x531
    x1714 = x1713 * x46
    x1715 = x1061 + x1180 * x968 + x544
    x1716 = x1060 + x1175 * x968 + x527
    x1717 = x1710 - x1713 * x52
    x1718 = x1717 * x77
    x1719 = x1716 * x46
    x1720 = x1186 * x968 + x1187 * x968 + x543
    x1721 = x1712 - x1715 * x52
    x1722 = x1721 * x77
    x1723 = x1195 * x968 + x1528 + x563
    x1724 = x1723 * x46
    x1725 = x1088 + x1206 * x968 + x576
    x1726 = x1196 * x968 + x1532 + x561
    x1727 = x1726 * x46
    x1728 = x1084 + x1203 * x968 + x573
    x1729 = x1198 * x968 + x1536 + x556
    x1730 = x1723 - x1726 * x52
    x1731 = x1730 * x77
    x1732 = x1729 * x46
    x1733 = x1092 + x1209 * x968 + x571
    x1734 = x1725 - x1728 * x52
    x1735 = x1734 * x77
    x1736 = 3.0 * x1148 + x1217 * x968 + x595
    x1737 = x1736 * x46
    x1738 = 3.0 * x1125 + x1231 * x968 + x613
    x1739 = 3.0 * x1145 + x1218 * x968 + x592
    x1740 = x1739 * x46
    x1741 = 3.0 * x1119 + x1227 * x968 + x609
    x1742 = 3.0 * x1136 + x1221 * x968 + x587
    x1743 = x1736 - x1739 * x52
    x1744 = x1743 * x77
    x1745 = x1742 * x46
    x1746 = 3.0 * x1130 + x1235 * x968 + x607
    x1747 = x1746 * x3
    x1748 = x1741 * x52
    x1749 = x1738 - x1748
    x1750 = x1749 * x77
    x1751 = x1745 * x3
    x1752 = x1579 * x621 + x634
    x1753 = x1579 * x622 + x630
    x1754 = x1753 * x52
    x1755 = x1579 * x625 + x627
    x1756 = x1752 - x1754
    x1757 = x1756 * x77
    x1758 = x1162 + x1252 * x968 + x645
    x1759 = x1160 + x1253 * x968 + x642
    x1760 = x1759 * x52
    x1761 = x1164 + x1255 * x968 + x640
    x1762 = x1758 - x1760
    x1763 = x1762 * x77
    x1764 = 2.0 * x1182 + x1263 * x968 + x656
    x1765 = 2.0 * x1179 + x1264 * x968 + x653
    x1766 = x1765 * x52
    x1767 = 2.0 * x1185 + x1266 * x968 + x651
    x1768 = x1764 - x1766
    x1769 = x1768 * x77
    x1770 = 3.0 * x1205 + x1274 * x968 + x666
    x1771 = 3.0 * x1202 + x1275 * x968 + x663
    x1772 = x1771 * x52
    x1773 = 3.0 * x1208 + x1277 * x968 + x660
    x1774 = x1770 - x1772
    x1775 = x1774 * x77
    x1776 = 4.0 * x1230 + x1285 * x968 + x680
    x1777 = 4.0 * x1226 + x1286 * x968 + x676
    x1778 = x1777 * x52
    x1779 = 4.0 * x1234 + x1288 * x968 + x673
    x1780 = x1779 * x236
    x1781 = x1776 - x1778
    x1782 = x1781 * x77
    x1783 = x1306 * x682 + x692
    x1784 = x1308 * x682 + x697
    x1785 = x1784 * x46
    x1786 = x1298 * x682 - x52 * (x1302 * x682 + x709) + x708
    x1787 = x46 * (x1312 * x682 + x706)
    x1788 = x1309 + x1325 * x682 + x724
    x1789 = x1313 + x1327 * x682 + x730
    x1790 = x1300 + x1319 * x682 - x52 * (x1304 + x1322 * x682 + x747) + x746
    x1791 = x104 * (x1317 + x1330 * x682 + x744)
    x1792 = x1341 * x682 + x751
    x1793 = x1342 * x682 + x753
    x1794 = x1793 * x46
    x1795 = x1335 * x682 - x52 * (x1338 * x682 + x764) + x763
    x1796 = x46 * (x1345 * x682 + x761)
    x1797 = x104 * x1327 + x1354 * x682 + x782
    x1798 = x1331 + x1355 * x682 + x788
    x1799 = (
        x104 * x1320 + x1350 * x682 - x52 * (x104 * x1323 + x1352 * x682 + x800) + x799
    )
    x1800 = x46 * (2.0 * x1334 + x1357 * x682 + x797)
    x1801 = x1343 + x1367 * x682 + x813
    x1802 = x1346 + x1368 * x682 + x817
    x1803 = x104 * x1802
    x1804 = x1337 + x1361 * x682 - x52 * (x1340 + x1364 * x682 + x829) + x828
    x1805 = x46 * (x1349 + x1371 * x682 + x826)
    x1806 = x1382 * x682 + x835
    x1807 = x1383 * x682 + x839
    x1808 = x1807 * x46
    x1809 = x1375 * x682 - x52 * (x1378 * x682 + x847) + x846
    x1810 = x46 * (x1386 * x682 + x845)
    x1811 = 3.0 * x1358 + x1396 * x682 + x858
    x1812 = x1811 * x46
    x1813 = x1355 * x92 + x1399 * x682 + x872
    x1814 = x1351 * x92 + x1392 * x682 - x52 * (x1353 * x92 + x1395 * x682 + x875) + x874
    x1815 = 2.0 * x1372 + x1407 * x682 + x884
    x1816 = x1815 * x46
    x1817 = x1369 + x1410 * x682 + x894
    x1818 = x1363 + x1403 * x682 - x52 * (x1366 + x1406 * x682 + x897) + x896
    x1819 = x1387 + x1418 * x682 + x902
    x1820 = x1819 * x46
    x1821 = x1384 + x1421 * x682 + x912
    x1822 = x1377 + x1414 * x682 - x52 * (x1381 + x1417 * x682 + x915) + x914
    x1823 = x1430 * x682 + x916
    x1824 = x1823 * x46
    x1825 = x1433 * x682 + x923
    x1826 = x1425 * x682 - x52 * (x1429 * x682 + x925) + x924
    x1827 = 4.0 * x1398 + x1438 * x682 + x936
    x1828 = 4.0 * x1391 + x1435 * x682 - x52 * (4.0 * x1394 + x1436 * x682 + x939) + x938
    x1829 = 3.0 * x1409 + x1443 * x682 + x944
    x1830 = 3.0 * x1402 + x1440 * x682 - x52 * (3.0 * x1405 + x1441 * x682 + x947) + x946
    x1831 = 2.0 * x1420 + x1448 * x682 + x952
    x1832 = 2.0 * x1413 + x1445 * x682 - x52 * (2.0 * x1416 + x1446 * x682 + x955) + x954
    x1833 = x1432 + x1453 * x682 + x960
    x1834 = x1424 + x1450 * x682 - x52 * (x1427 + x1451 * x682 + x964) + x963
    x1835 = x1458 * x682 + x965
    x1836 = x1455 * x682 - x52 * (x1456 * x682 + x967) + x966
    x1837 = x1305 * x968 + x972
    x1838 = x1307 * x968 + x975
    x1839 = x1838 * x46
    x1840 = x1297 * x986 - x52 * (x1301 * x968 + x988) + x985
    x1841 = x46 * (x1311 * x968 + x982)
    x1842 = x1324 * x968 + x1472 * x682 + x993
    x1843 = x1326 * x968 + x1474 * x682 + x999
    x1844 = (
        x1010 + x1318 * x968 + x1464 * x682 - x52 * (x1012 + x1321 * x968 + x1468 * x682)
    )
    x1845 = x104 * (x1008 + x1329 * x968 + x1477 * x682)
    x1846 = x1024 * x1297 + x1031
    x1847 = x1026 * x1297 + x1039
    x1848 = x1847 * x46
    x1849 = x1019 * x1297 + x1057 - x52 * (x1013 * x1297 + x1059)
    x1850 = x46 * (x1033 * x1297 + x1054)
    x1851 = x104 * x1474 + x1066 + x1491 * x682
    x1852 = x1070 + x1478 + x1492 * x682
    x1853 = (
        x104 * x1466 + x1079 + x1487 * x682 - x52 * (x104 * x1470 + x1081 + x1489 * x682)
    )
    x1854 = x46 * (x1077 + 2.0 * x1481 + x1494 * x682)
    x1855 = x1027 * x682 + x1094 + x1504 * x682
    x1856 = x1034 * x682 + x1099 + x1505 * x682
    x1857 = x104 * x1856
    x1858 = (
        x1111 + x1482 * x46 + x1498 * x682 - x52 * (x1016 * x682 + x1113 + x1501 * x682)
    )
    x1859 = x46 * (x1108 + x1486 + x1508 * x682)
    x1860 = x1127 * x1297 + x1134
    x1861 = x1129 * x1297 + x1141
    x1862 = x1861 * x46
    x1863 = x1122 * x1297 + x1154 - x52 * (x1114 * x1297 + x1156)
    x1864 = x46 * (x1135 * x1297 + x1151)
    x1865 = x1158 + 3.0 * x1495 + x1523 * x682
    x1866 = x1865 * x46
    x1867 = x1166 + x1492 * x92 + x1526 * x682
    x1868 = (
        x1168 + x1488 * x92 + x1519 * x682 - x52 * (x1170 + x1490 * x92 + x1522 * x682)
    )
    x1869 = x1177 + 2.0 * x1509 + x1537 * x682
    x1870 = x1869 * x46
    x1871 = x1189 + x1506 + x1540 * x682
    x1872 = x1192 + x1500 + x1531 * x682 - x52 * (x1194 + x1503 + x1535 * x682)
    x1873 = x1200 + x1514 + x1548 * x682
    x1874 = x1873 * x46
    x1875 = x1130 * x682 + x1211 + x1551 * x682
    x1876 = (
        x1214 + x1512 * x46 + x1544 * x682 - x52 * (x1119 * x682 + x1216 + x1547 * x682)
    )
    x1877 = x1221 * x1297 + x1224
    x1878 = x1877 * x46
    x1879 = x1235 * x1297 + x1239
    x1880 = x1231 * x1297 + x1243 - x52 * (x1227 * x1297 + x1245)
    x1881 = x1247 + 4.0 * x1525 + x1561 * x682
    x1882 = (
        x1249 + 4.0 * x1518 + x1558 * x682 - x52 * (x1251 + 4.0 * x1521 + x1559 * x682)
    )
    x1883 = x1257 + 3.0 * x1539 + x1566 * x682
    x1884 = (
        x1260 + 3.0 * x1530 + x1563 * x682 - x52 * (x1262 + 3.0 * x1534 + x1564 * x682)
    )
    x1885 = x1268 + 2.0 * x1550 + x1571 * x682
    x1886 = (
        x1271 + 2.0 * x1543 + x1568 * x682 - x52 * (x1273 + 2.0 * x1546 + x1569 * x682)
    )
    x1887 = x1279 + x1556 + x1576 * x682
    x1888 = x1282 + x1553 + x1573 * x682 - x52 * (x1284 + x1554 + x1574 * x682)
    x1889 = x1288 * x1297 + x1291
    x1890 = x1285 * x1297 + x1294 - x52 * (x1286 * x1297 + x1296)
    x1891 = x4 * (x1580 * x682 - x1591 * x682)
    x1892 = x1589 + x1609 * x682
    x1893 = x1596 + x1610 * x682
    x1894 = x4 * (x1582 + x1603 * x682 - x52 * (x1585 + x1606 * x682))
    x1895 = x104 * (x1602 + x1614 * x682)
    x1896 = x4 * (x1621 * x682 - x1632 * x682)
    x1897 = 2.0 * x1611 + x1650 * x682
    x1898 = x1616 + x1651 * x682
    x1899 = x4 * (2.0 * x1605 + x1643 * x682 - x52 * (2.0 * x1608 + x1646 * x682))
    x1900 = x46 * (2.0 * x1620 + x1655 * x682)
    x1901 = x1630 + x1666 * x682
    x1902 = x1637 + x1667 * x682
    x1903 = x104 * x1902
    x1904 = x4 * (x1623 + x1660 * x682 - x52 * (x1626 + x1663 * x682))
    x1905 = x46 * (x1642 + x1671 * x682)
    x1906 = x4 * (x1676 * x682 - x1687 * x682)
    x1907 = x1691 * x682
    x1908 = 3.0 * x1656 + x1703 * x682
    x1909 = x1908 * x46
    x1910 = 3.0 * x1652 + x1707 * x682
    x1911 = x4 * (3.0 * x1645 + x1698 * x682 - x52 * (3.0 * x1649 + x1702 * x682))
    x1912 = 2.0 * x1672
    x1913 = x1716 * x682 + x1912
    x1914 = x1913 * x46
    x1915 = x1668 + x1720 * x682
    x1916 = x4 * (x1662 + x1712 * x682 - x52 * (x1665 + x1715 * x682))
    x1917 = x1691 + x1729 * x682
    x1918 = x1917 * x46
    x1919 = x1685 + x1733 * x682
    x1920 = x4 * (x1678 + x1725 * x682 - x52 * (x1681 + x1728 * x682))
    x1921 = x1745 * x682
    x1922 = x4 * (x1738 * x682 - x1748 * x682)
    x1923 = 4.0 * x1706 + x1755 * x682
    x1924 = x4 * (4.0 * x1697 + x1752 * x682 - x52 * (4.0 * x1700 + x1753 * x682))
    x1925 = 3.0 * x1719 + x1761 * x682
    x1926 = x4 * (3.0 * x1711 + x1758 * x682 - x52 * (3.0 * x1714 + x1759 * x682))
    x1927 = 2.0 * x1732 + x1767 * x682
    x1928 = x4 * (2.0 * x1724 + x1764 * x682 - x52 * (2.0 * x1727 + x1765 * x682))
    x1929 = x1745 + x1773 * x682
    x1930 = x4 * (x1737 + x1770 * x682 - x52 * (x1740 + x1771 * x682))
    x1931 = x4 * (x1776 * x682 - x1778 * x682)
    x1932 = x1586 * x968 + x971
    x1933 = x1932 * x3
    x1934 = x1588 * x968 + x974
    x1935 = x1934 * x46
    x1936 = 4.0 * x1935
    x1937 = x1580 * x968 - x52 * (x1583 * x968 + x987) + x984
    x1938 = x1937 * x77
    x1939 = x46 * (x1595 * x968 + x981)
    x1940 = x1609 * x968 + x992
    x1941 = x1610 * x968 + x998
    x1942 = x1941 * x46
    x1943 = x1009 + x1603 * x968 - x52 * (x1011 + x1606 * x968)
    x1944 = x1943 * x77
    x1945 = x46 * (x1007 + x1614 * x968)
    x1946 = 2.0 * x1945
    x1947 = x1030 + x1589 + x1627 * x968
    x1948 = x1947 * x3
    x1949 = x1038 + x1596 + x1629 * x968
    x1950 = x1949 * x46
    x1951 = 3.0 * x1950
    x1952 = x1056 + x1582 + x1621 * x968 - x52 * (x1058 + x1585 + x1624 * x968)
    x1953 = x1952 * x77
    x1954 = x46 * (x1053 + x1602 + x1636 * x968)
    x1955 = 2.0 * x1954
    x1956 = x1065 + x1650 * x968
    x1957 = x1069 + x1651 * x968
    x1958 = x1957 * x46
    x1959 = x1078 + x1643 * x968 - x52 * (x1080 + x1646 * x968)
    x1960 = x1959 * x77
    x1961 = x46 * (x1076 + x1655 * x968)
    x1962 = x1093 + x1611 + x1666 * x968
    x1963 = x1098 + x1615 + x1667 * x968
    x1964 = x104 * x1963
    x1965 = x1110 + x1605 + x1660 * x968 - x52 * (x1112 + x1608 + x1663 * x968)
    x1966 = x1965 * x77
    x1967 = x46 * (x1107 + x1620 + x1671 * x968)
    x1968 = x1133 + 2.0 * x1630 + x1682 * x968
    x1969 = x1968 * x3
    x1970 = x1140 + x1638 + x1684 * x968
    x1971 = x1970 * x46
    x1972 = 2.0 * x1971
    x1973 = (
        x1153 + 2.0 * x1623 + x1676 * x968 - x52 * (x1155 + 2.0 * x1626 + x1679 * x968)
    )
    x1974 = x1973 * x77
    x1975 = x46 * (x1150 + 2.0 * x1642 + x1690 * x968)
    x1976 = x1157 + x1703 * x968
    x1977 = x1976 * x46
    x1978 = x1165 + x1707 * x968
    x1979 = x1167 + x1698 * x968 - x52 * (x1169 + x1702 * x968)
    x1980 = x1979 * x77
    x1981 = x1176 + x1656 + x1716 * x968
    x1982 = x1981 * x46
    x1983 = x1188 + x1652 + x1720 * x968
    x1984 = x1191 + x1645 + x1712 * x968 - x52 * (x1193 + x1649 + x1715 * x968)
    x1985 = x1984 * x77
    x1986 = x1199 + x1729 * x968 + x1912
    x1987 = x1986 * x46
    x1988 = x1210 + x1668 + x1733 * x968
    x1989 = x1213 + x1662 + x1725 * x968 - x52 * (x1215 + x1665 + x1728 * x968)
    x1990 = x1989 * x77
    x1991 = x1223 + 3.0 * x1691 + x1742 * x968
    x1992 = x1991 * x46
    x1993 = x1238 + 3.0 * x1685 + x1746 * x968
    x1994 = x1993 * x3
    x1995 = (
        x1242 + 3.0 * x1678 + x1738 * x968 - x52 * (x1244 + 3.0 * x1681 + x1741 * x968)
    )
    x1996 = x1995 * x77
    x1997 = x1246 + x1755 * x968
    x1998 = x1248 + x1752 * x968 - x52 * (x1250 + x1753 * x968)
    x1999 = x1998 * x77
    x2000 = x1256 + x1706 + x1761 * x968
    x2001 = x1259 + x1697 + x1758 * x968 - x52 * (x1261 + x1700 + x1759 * x968)
    x2002 = x2001 * x77
    x2003 = x1267 + 2.0 * x1719 + x1767 * x968
    x2004 = (
        x1270 + 2.0 * x1711 + x1764 * x968 - x52 * (x1272 + 2.0 * x1714 + x1765 * x968)
    )
    x2005 = x2004 * x77
    x2006 = x1278 + 3.0 * x1732 + x1773 * x968
    x2007 = (
        x1281 + 3.0 * x1724 + x1770 * x968 - x52 * (x1283 + 3.0 * x1727 + x1771 * x968)
    )
    x2008 = x2007 * x77
    x2009 = x1290 + 4.0 * x1745 + x1779 * x968
    x2010 = (
        x1293 + 4.0 * x1737 + x1776 * x968 - x52 * (x1295 + 4.0 * x1740 + x1777 * x968)
    )
    x2011 = x2010 * x77
    x2012 = x129 * x1310 + x1783 * x682
    x2013 = x46 * (x129 * x1315 + x1784 * x682)
    x2014 = x129 * x1328 + x1785 + x1788 * x682
    x2015 = x129 * x1333 + x1787 + x1789 * x682
    x2016 = x129 * x1344 + x1792 * x682
    x2017 = x46 * (x129 * x1348 + x1793 * x682)
    x2018 = x104 * x1789 + x129 * x1356 + x1797 * x682
    x2019 = x129 * x1360 + x1791 + x1798 * x682
    x2020 = x129 * x1370 + x1794 + x1801 * x682
    x2021 = x104 * (x129 * x1374 + x1796 + x1802 * x682)
    x2022 = x129 * x1385 + x1806 * x682
    x2023 = x46 * (x129 * x1389 + x1807 * x682)
    x2024 = x46 * (x129 * x1397 + 3.0 * x1800 + x1811 * x682)
    x2025 = x129 * x1400 + x1798 * x92 + x1813 * x682
    x2026 = x46 * (x129 * x1408 + 2.0 * x1805 + x1815 * x682)
    x2027 = x129 * x1411 + x1803 + x1817 * x682
    x2028 = x46 * (x129 * x1419 + x1810 + x1819 * x682)
    x2029 = x129 * x1422 + x1808 + x1821 * x682
    x2030 = x46 * (x129 * x1431 + x1823 * x682)
    x2031 = x129 * x1434 + x1825 * x682
    x2032 = x129 * x1439 + 4.0 * x1812 + x1827 * x682
    x2033 = x129 * x1444 + 3.0 * x1816 + x1829 * x682
    x2034 = x129 * x1449 + 2.0 * x1820 + x1831 * x682
    x2035 = x129 * x1454 + x1824 + x1833 * x682
    x2036 = x129 * x1459 + x1835 * x682
    x2037 = x1460 + x1837 * x682
    x2038 = x46 * (x1462 + x1838 * x682)
    x2039 = x1475 + x1839 + x1842 * x682
    x2040 = x1480 + x1841 + x1843 * x682
    x2041 = x1483 + x1846 * x682
    x2042 = x46 * (x1485 + x1847 * x682)
    x2043 = x104 * x1843 + x1493 + x1851 * x682
    x2044 = x1497 + x1845 + x1852 * x682
    x2045 = x1507 + x1848 + x1855 * x682
    x2046 = x104 * (x1511 + x1850 + x1856 * x682)
    x2047 = x1513 + x1860 * x682
    x2048 = x46 * (x1516 + x1861 * x682)
    x2049 = x46 * (x1524 + 3.0 * x1854 + x1865 * x682)
    x2050 = x1527 + x1852 * x92 + x1867 * x682
    x2051 = x46 * (x1538 + 2.0 * x1859 + x1869 * x682)
    x2052 = x1541 + x1857 + x1871 * x682
    x2053 = x46 * (x1549 + x1864 + x1873 * x682)
    x2054 = x1552 + x1862 + x1875 * x682
    x2055 = x46 * (x1555 + x1877 * x682)
    x2056 = x1557 + x1879 * x682
    x2057 = x1562 + 4.0 * x1866 + x1881 * x682
    x2058 = x1567 + 3.0 * x1870 + x1883 * x682
    x2059 = x1572 + 2.0 * x1874 + x1885 * x682
    x2060 = x1577 + x1878 + x1887 * x682
    x2061 = x1578 + x1889 * x682
    x2062 = x1297 * x1586 + x1593
    x2063 = x46 * (x1297 * x1588 + x1600)
    x2064 = x1589 * x682 + x1613 + x1892 * x682
    x2065 = x1596 * x682 + x1619 + x1893 * x682
    x2066 = x1297 * x1627 + x1634
    x2067 = x46 * (x1297 * x1629 + x1641)
    x2068 = x104 * x1893 + x1654 + x1897 * x682
    x2069 = x1659 + x1895 + x1898 * x682
    x2070 = x1630 * x682 + x1670 + x1901 * x682
    x2071 = x104 * (x1637 * x682 + x1675 + x1902 * x682)
    x2072 = x1297 * x1682 + x1689
    x2073 = x46 * (x1297 * x1684 + x1695)
    x2074 = x46 * (x1705 + 3.0 * x1900 + x1908 * x682)
    x2075 = x1709 + x1898 * x92 + x1910 * x682
    x2076 = x46 * (x1718 + 2.0 * x1905 + x1913 * x682)
    x2077 = x1722 + x1903 + x1915 * x682
    x2078 = x46 * (x1731 + x1907 + x1917 * x682)
    x2079 = x1685 * x682 + x1735 + x1919 * x682
    x2080 = x46 * (x1297 * x1742 + x1744)
    x2081 = x1297 * x1746 + x1750
    x2082 = x1757 + 4.0 * x1909 + x1923 * x682
    x2083 = x1763 + 3.0 * x1914 + x1925 * x682
    x2084 = x1769 + 2.0 * x1918 + x1927 * x682
    x2085 = x1775 + x1921 + x1929 * x682
    x2086 = x1297 * x1779 + x1782
    x2087 = x1935 + x1940 * x682
    x2088 = x1939 + x1941 * x682
    x2089 = 2.0 * x1942 + x1956 * x682
    x2090 = x1946 + x1957 * x682
    x2091 = x1950 + x1962 * x682
    x2092 = x104 * (x1954 + x1963 * x682)
    x2093 = x46 * (3.0 * x1961 + x1976 * x682)
    x2094 = 3.0 * x1958 + x1978 * x682
    x2095 = 2.0 * x1967
    x2096 = x46 * (x1981 * x682 + x2095)
    x2097 = x1964 + x1983 * x682
    x2098 = x46 * (x1975 + x1986 * x682)
    x2099 = x1971 + x1988 * x682
    x2100 = x1992 * x682
    x2101 = 4.0 * x1977 + x1997 * x682
    x2102 = 3.0 * x1982 + x2000 * x682
    x2103 = 2.0 * x1987 + x2003 * x682
    x2104 = x1992 + x2006 * x682
    x2105 = x129 * x1592 + x1932 * x968
    x2106 = x46 * (x129 * x1599 + x1934 * x968)
    x2107 = x129 * x1612 + x1940 * x968
    x2108 = x46 * (x129 * x1618 + x1941 * x968)
    x2109 = x129 * x1633 + x1935 + x1947 * x968
    x2110 = x46 * (x129 * x1640 + x1939 + x1949 * x968)
    x2111 = x129 * x1653 + x1956 * x968
    x2112 = x46 * (x129 * x1658 + x1957 * x968)
    x2113 = x129 * x1669 + x1942 + x1962 * x968
    x2114 = x104 * (x129 * x1674 + x1945 + x1963 * x968)
    x2115 = x129 * x1688 + 2.0 * x1950 + x1968 * x968
    x2116 = x46 * (x129 * x1694 + x1955 + x1970 * x968)
    x2117 = x46 * (x129 * x1704 + x1976 * x968)
    x2118 = x129 * x1708 + x1978 * x968
    x2119 = x46 * (x129 * x1717 + x1961 + x1981 * x968)
    x2120 = x129 * x1721 + x1958 + x1983 * x968
    x2121 = x46 * (x129 * x1730 + x1986 * x968 + x2095)
    x2122 = x129 * x1734 + x1964 + x1988 * x968
    x2123 = x46 * (x129 * x1743 + 3.0 * x1975 + x1991 * x968)
    x2124 = x129 * x1749 + 3.0 * x1971 + x1993 * x968
    x2125 = x129 * x1756 + x1997 * x968
    x2126 = x129 * x1762 + x1977 + x2000 * x968
    x2127 = x129 * x1768 + 2.0 * x1982 + x2003 * x968
    x2128 = x129 * x1774 + 3.0 * x1987 + x2006 * x968
    x2129 = x129 * x1781 + 4.0 * x1992 + x2009 * x968

    # 315 item(s)
    return numpy.array(
        [
            x23
            * (
                x128 * x3
                + x137 * x83
                + x4 * (x126 * x3 + 4.0 * x131 - x133 * x52)
                - x52 * (x121 * x3 + x143 * x83 + x4 * (x133 - x52 * x66))
            )
            + x3
            * (
                x112 * x83
                + x129 * (-x121 * x52 + x128)
                + x3
                * (
                    x3 * (x3 * (x73 + x75) + x78 + x82 * x83)
                    + x4 * (-x51 * x52 + x66)
                    + x83 * x93
                )
            )
            + x83
            * (
                x112 * x3
                + x129 * (x137 - x143 * x52)
                + x92
                * (
                    x104 * (x110 * x3 + x146 + x147)
                    + x111 * x3
                    + x4 * (x136 - x142 * x52)
                )
            ),
            x23
            * (
                x217 * x3
                + x228 * x92
                + x4 * (x215 * x3 + 3.0 * x220 - x222 * x52)
                - x52 * (x210 * x3 + x233 * x92 + x4 * (-x172 * x52 + x222))
            )
            + x3
            * (
                x129 * (-x210 * x52 + x217)
                + x207 * x92
                + x3
                * (
                    x194 * x92
                    + x3 * (x181 + x186 * x92 + x3 * (x177 + x179))
                    + x4 * (-x162 * x52 + x172)
                )
            )
            + x92
            * (
                x104 * (x206 * x3 + x4 * (x227 - x232 * x52) + x46 * (x231 * x236 + x235))
                + x129 * (x228 - x233 * x52)
                + x207 * x3
            ),
            x23
            * (
                x296 * x3
                + x307 * x92
                + x4 * (x294 * x3 + 3.0 * x300 - x302 * x52)
                - x52 * (x290 * x3 + x312 * x92 + x4 * (-x258 * x52 + x302))
            )
            + x3
            * (
                x129 * (-x290 * x52 + x296)
                + x287 * x92
                + x3
                * (
                    x277 * x92
                    + x3 * (x266 + x270 * x92 + x3 * (x262 + x264))
                    + x4 * (-x249 * x52 + x258)
                )
            )
            + x92
            * (
                x104 * (x286 * x3 + x4 * (x306 - x311 * x52) + x46 * (x236 * x310 + x313))
                + x129 * (x307 - x312 * x52)
                + x287 * x3
            ),
            x104
            * (
                x129 * (x371 - x373 * x52)
                + x3 * x357
                + x46 * (x3 * x356 + x4 * (x3 * x326 - x3 * x354))
            )
            + x23
            * (
                x104 * x371
                + x3 * x366
                + x4 * (x104 * x369 + x3 * x364 - x368 * x52)
                - x52 * (x104 * x373 + x3 * x362 + x4 * (-x331 * x52 + x368))
            )
            + x3
            * (
                x104 * x357
                + x129 * (-x362 * x52 + x366)
                + x3
                * (
                    x104 * x346
                    + x3 * (x104 * x342 + x3 * (x336 + x338) + x340)
                    + x4 * (-x325 * x52 + x331)
                )
            ),
            x104
            * (
                x129 * (x418 - x420 * x52)
                + x3 * x404
                + x46
                * (
                    x3 * x403
                    + x4
                    * (2.0 * x10 * x149 * x17 * x238 * x3 * x32 * x4 * x6 - x3 * x401)
                )
            )
            + x23
            * (
                x104 * x418
                + x3 * x412
                + x4 * (x3 * x410 - x414 * x52 + x416)
                - x52 * (x104 * x420 + x3 * x408 + x4 * (-x385 * x52 + x414))
            )
            + x3
            * (
                x104 * x404
                + x129 * (-x408 * x52 + x412)
                + x3
                * (
                    x104 * x396
                    + x3 * (x104 * x394 + x3 * (x3 * x387 + x388) + x389)
                    + x4 * (-x378 * x52 + x385)
                )
            ),
            x104
            * (
                x129 * (x480 - x483 * x52)
                + x3 * x463
                + x46 * (x3 * x462 + x4 * (x3 * x433 - x3 * x460))
            )
            + x23
            * (
                x104 * x480
                + x3 * x474
                + x4 * (x104 * x477 + x3 * x472 - x476 * x52)
                - x52 * (x104 * x483 + x3 * x469 + x4 * (-x439 * x52 + x476))
            )
            + x3
            * (
                x104 * x463
                + x129 * (-x469 * x52 + x474)
                + x3
                * (
                    x104 * x452
                    + x3 * (x104 * x449 + x3 * (x104 * x445 + x444) + x447)
                    + x4 * (-x432 * x52 + x439)
                )
            ),
            x23
            * (
                x3 * x518
                + x4 * (x3 * x520 + x519 - x52 * x522)
                + x46 * x498
                - x52 * (x3 * x513 + x4 * (-x505 * x52 + x522) + x46 * x495)
            )
            + x3
            * (
                x129 * (-x513 * x52 + x518)
                + x3
                * (
                    x3 * (x3 * (x506 + x508) + x509 + x510)
                    + x4 * (-x501 * x52 + x505)
                    + x46 * x491
                )
                + x46 * x492
            )
            + x46 * (x129 * (-x495 * x52 + x498) + x3 * x492),
            x23
            * (
                x3 * x549
                + x4 * (x3 * x551 - x52 * x553 + x550)
                + x46 * x535
                - x52 * (x3 * x545 + x4 * (-x52 * x540 + x553) + x46 * x532)
            )
            + x3
            * (
                x129 * (-x52 * x545 + x549)
                + x3
                * (
                    x3 * (x3 * x541 + x3 * (x108 * x542 + x541) + x543)
                    + x4 * (-x52 * x537 + x540)
                    + x46 * x528
                )
                + x46 * x529
            )
            + x46 * (x129 * (-x52 * x532 + x535) + x3 * x529),
            x23
            * (
                x3 * x577
                + x4 * (x3 * x581 + x46 * x578 - x52 * x580)
                + x46 * x564
                - x52 * (x3 * x574 + x4 * (-x52 * x568 + x580) + x46 * x562)
            )
            + x3
            * (
                x129 * (-x52 * x574 + x577)
                + x3
                * (
                    x3 * (x3 * x569 + x3 * (x108 * x570 + x569) + x571)
                    + x4 * (-x52 * x566 + x568)
                    + x46 * x558
                )
                + x46 * x559
            )
            + x46 * (x129 * (-x52 * x562 + x564) + x3 * x559),
            x23
            * (
                x3 * x616
                + x4 * (x3 * x618 - x52 * x620 + x617)
                + x46 * x596
                - x52 * (x3 * x611 + x4 * (-x52 * x603 + x620) + x46 * x593)
            )
            + x3
            * (
                x129 * (-x52 * x611 + x616)
                + x3
                * (
                    x3 * (x3 * (x604 + x606) + x607 + x608)
                    + x4 * (-x52 * x599 + x603)
                    + x46 * x588
                )
                + x46 * x589
            )
            + x46 * (x129 * (-x52 * x593 + x596) + x3 * x589),
            x23
            * (
                x3 * x635
                + x4 * (-x3 * x52 * x629 + x3 * x633)
                - x52 * (x3 * x631 + x4 * (-x3 * x52 * x621 + x3 * x629))
            )
            + x3
            * (
                x129 * (-x52 * x631 + x635)
                + x3 * (x3 * (x626 + x627) + x4 * (x3 * x621 - x624))
            ),
            x23
            * (
                x3 * x646
                + x4 * (-x3 * x52 * x641 + x3 * x644)
                - x52 * (x3 * x643 + x4 * (-x3 * x52 * x636 + x3 * x641))
            )
            + x3
            * (
                x129 * (-x52 * x643 + x646)
                + x3 * (x3 * (x236 * x639 + x640) + x4 * (x3 * x636 - x3 * x638))
            ),
            x23
            * (
                x3 * x657
                + x4 * (-x3 * x52 * x652 + x3 * x655)
                - x52 * (x3 * x654 + x4 * (-x3 * x52 * x647 + x3 * x652))
            )
            + x3
            * (
                x129 * (-x52 * x654 + x657)
                + x3 * (x3 * (x236 * x650 + x651) + x4 * (x3 * x647 - x3 * x649))
            ),
            x23
            * (
                x3 * x667
                + x4 * (x149 * x3 * x591 - x149 * x52 * x614)
                - x52 * (x3 * x664 + x4 * (x149 * x3 * x582 - x3 * x52 * x662))
            )
            + x3
            * (
                x129 * (-x52 * x664 + x667)
                + x3 * (x3 * (x236 * x661 + x660) + x4 * (x149 * x3 * x583 - x3 * x659))
            ),
            x23
            * (
                x3 * x681
                + x4 * (-x3 * x52 * x675 + x3 * x679)
                - x52 * (x3 * x677 + x4 * (-x3 * x52 * x668 + x3 * x675))
            )
            + x3
            * (
                x129 * (-x52 * x677 + x681)
                + x3 * (x3 * (x672 + x673) + x4 * (x3 * x668 - x3 * x670))
            ),
            x129
            * (
                x3 * x688
                - x52 * (x3 * x685 + x703 * x83 + 0.5 * x709)
                + x705 * x83
                + 0.5 * x708
            )
            + x3
            * (
                x3 * (x3 * (x689 + x690) + 0.5 * x692 + x695 * x83)
                + x4 * (-x52 * x685 + x688)
                + x702 * x83
            )
            + x83
            * (
                x3 * x702
                + x4 * (-x52 * x703 + x705)
                + x92 * (x104 * (x109 * x682 + x707) + x3 * x701 + 0.5 * x706)
            ),
            x129
            * (
                x3 * x719
                - x52 * (x3 * x714 + x739 * x92 + 0.5 * x747)
                + x743 * x92
                + 0.5 * x746
            )
            + x3
            * (
                x3 * (x3 * (x3 * x721 + x723 * x92) + 0.5 * x724 + x729 * x92)
                + x4 * (-x52 * x714 + x719)
                + x735 * x92
            )
            + x92
            * (
                x104 * (x3 * x733 + x3 * x734 + 0.5 * x744)
                + x3 * x735
                + x4 * (-x52 * x739 + x743)
            ),
            x129
            * (
                x3 * x750
                - x52 * (x3 * x748 + x757 * x92 + 0.5 * x764)
                + x760 * x92
                + 0.5 * x763
            )
            + x3
            * (
                x3 * (x3 * (x262 * x682 + x264 * x682) + 0.5 * x751 + x752 * x92)
                + x4 * (-x52 * x748 + x750)
                + x756 * x92
            )
            + x92
            * (
                x104 * (x273 * x762 + x3 * x755 + 0.5 * x761)
                + x3 * x756
                + x4 * (-x52 * x757 + x760)
            ),
            x104
            * (x3 * x789 + x4 * (-x52 * x793 + x796) + x46 * (x236 * x785 + 0.5 * x797))
            + x129
            * (
                x104 * x796
                + x3 * x776
                - x52 * (x104 * x793 + x3 * x771 + 0.5 * x800)
                + 0.5 * x799
            )
            + x3
            * (
                x104 * x789
                + x3 * (x104 * x787 + x3 * (x104 * x781 + x3 * x779) + 0.5 * x782)
                + x4 * (-x52 * x771 + x776)
            ),
            x104
            * (x3 * x818 + x4 * (-x52 * x821 + x825) + x46 * (x236 * x814 + 0.5 * x826))
            + x129
            * (
                x104 * x825
                + x3 * x808
                - x52 * (x104 * x821 + x3 * x804 + 0.5 * x829)
                + 0.5 * x828
            )
            + x3
            * (
                x104 * x818
                + x3 * (x104 * x816 + x3 * (x3 * x809 + x812) + 0.5 * x813)
                + x4 * (-x52 * x804 + x808)
            ),
            x104
            * (x3 * x840 + x4 * (-x52 * x842 + x844) + x46 * (x459 * x682 + 0.5 * x845))
            + x129
            * (
                x104 * x844
                + x3 * x833
                - x52 * (x104 * x842 + x3 * x831 + 0.5 * x847)
                + 0.5 * x846
            )
            + x3
            * (
                x104 * x840
                + x3 * (x104 * x837 + x3 * (x104 * x834 + x444 * x682) + 0.5 * x835)
                + x4 * (-x52 * x831 + x833)
            ),
            x129
            * (
                x3 * x46 * x850
                + x3 * x867
                - x52 * (x3 * x860 + x3 * x863 + 0.5 * x875)
                + 0.5 * x874
            )
            + x3
            * (
                x3 * (x3 * x868 + x3 * (x3 * x871 + x868) + 0.5 * x872)
                + x4 * (-x52 * x863 + x867)
                + x46 * x859
            )
            + x46 * (x3 * x859 + x4 * (x3 * x850 - x3 * x854)),
            x129
            * (
                x3 * x46 * x877
                + x3 * x891
                - x52 * (x3 * x886 + x3 * x888 + 0.5 * x897)
                + 0.5 * x896
            )
            + x3
            * (
                x3 * (x3 * x892 + x3 * (x3 * x893 + x892) + 0.5 * x894)
                + x4 * (-x52 * x888 + x891)
                + x46 * x885
            )
            + x46 * (x3 * x885 + x4 * (x3 * x877 - x3 * x880)),
            x129
            * (
                x3 * x46 * x898
                + x3 * x909
                - x52 * (x3 * x904 + x3 * x906 + 0.5 * x915)
                + 0.5 * x914
            )
            + x3
            * (
                x3 * (x3 * x910 + x3 * (x3 * x911 + x910) + 0.5 * x912)
                + x4 * (-x52 * x906 + x909)
                + x46 * x903
            )
            + x46 * (x3 * x903 + x4 * (x3 * x898 - x3 * x900)),
            x129
            * (
                x3 * x921
                - x52 * (x3 * x919 + x610 * x682 + 0.5 * x925)
                + x615 * x682
                + 0.5 * x924
            )
            + x3
            * (
                x3 * (x3 * (x606 * x682 + x922) + x608 * x682 + 0.5 * x923)
                + x4 * (-x52 * x919 + x921)
                + x46 * x917
            )
            + x46 * (x3 * x917 + x4 * (x3 * x582 * x682 - x584 * x762)),
            x129 * (x236 * x928 - x52 * (x236 * x931 + 0.5 * x939) + 0.5 * x938)
            + x3 * (x3 * (x236 * x935 + 0.5 * x936) + x4 * (x3 * x928 - x3 * x932)),
            x129 * (x236 * x940 - x52 * (x236 * x941 + 0.5 * x947) + 0.5 * x946)
            + x3 * (x3 * (x236 * x943 + 0.5 * x944) + x4 * (x3 * x940 - x3 * x942)),
            x129 * (x236 * x948 - x52 * (x236 * x949 + 0.5 * x955) + 0.5 * x954)
            + x3 * (x3 * (x236 * x951 + 0.5 * x952) + x4 * (x3 * x948 - x3 * x950)),
            x129 * (x236 * x956 - x52 * (x236 * x957 + 0.5 * x964) + 0.5 * x963)
            + x3 * (x3 * (x236 * x959 + 0.5 * x960) + x4 * (x3 * x956 - x3 * x958)),
            x129 * (-x52 * (x674 * x682 + 0.5 * x967) + x678 * x682 + 0.5 * x966)
            + x3
            * (x3 * (x672 * x682 + 0.5 * x965) + x4 * (x3 * x668 * x682 - x670 * x762)),
            x129 * (x3 * x970 - x52 * (x3 * x969 + x83 * x979 + x988) + x83 * x980 + x985)
            + x3
            * (
                x3 * (x3 * (x73 * x968 + x75 * x968) + x83 * x973 + x972)
                + x4 * (-x52 * x969 + x970)
                + x83 * x978
            )
            + x83
            * (
                x3 * x978
                + x4 * (-x52 * x979 + x980)
                + x92 * (x104 * (x109 * x968 + x983) + x3 * x977 + x982)
            ),
            x129
            * (x1006 * x92 + x1010 + x3 * x991 - x52 * (x1004 * x92 + x1012 + x3 * x989))
            + x3
            * (
                x1002 * x92
                + x3 * (x3 * (x177 * x968 + x179 * x968) + x92 * x997 + x993)
                + x4 * (-x52 * x989 + x991)
            )
            + x92
            * (
                x1002 * x3
                + x104 * (x1001 * x3 + x1008 + x205 * x968)
                + x4 * (-x1004 * x52 + x1006)
            ),
            x129
            * (
                x1023 * x3
                + x1052 * x92
                + x1057
                - x52 * (x1018 * x3 + x1048 * x92 + x1059)
            )
            + x3
            * (
                x1044 * x92
                + x3 * (x1031 + x1036 * x92 + x3 * (x1025 + x1028))
                + x4 * (-x1018 * x52 + x1023)
            )
            + x92
            * (
                x104 * (x1041 * x3 + x1043 * x3 + x1054)
                + x1044 * x3
                + x4 * (-x1048 * x52 + x1052)
            ),
            x104
            * (x1071 * x3 + x4 * (-x1073 * x52 + x1075) + x46 * (x1077 + x353 * x968))
            + x129
            * (
                x104 * x1075
                + x1064 * x3
                + x1079
                - x52 * (x104 * x1073 + x1062 * x3 + x1081)
            )
            + x3
            * (
                x104 * x1071
                + x3 * (x104 * x1067 + x1066 + x3 * (x336 * x968 + x338 * x968))
                + x4 * (-x1062 * x52 + x1064)
            ),
            x104
            * (x1100 * x3 + x4 * (-x1103 * x52 + x1106) + x46 * (x1095 * x236 + x1108))
            + x129
            * (
                x104 * x1106
                + x1089 * x3
                + x1111
                - x52 * (x104 * x1103 + x1085 * x3 + x1113)
            )
            + x3
            * (
                x104 * x1100
                + x3 * (x104 * x1097 + x1094 + x3 * (x1090 * x3 + x1092))
                + x4 * (-x1085 * x52 + x1089)
            ),
            x104
            * (x1143 * x3 + x4 * (-x1146 * x52 + x1149) + x46 * (x1135 * x236 + x1151))
            + x129
            * (
                x104 * x1149
                + x1126 * x3
                + x1154
                - x52 * (x104 * x1146 + x1121 * x3 + x1156)
            )
            + x3
            * (
                x104 * x1143
                + x3 * (x104 * x1138 + x1134 + x3 * (x1128 + x1131))
                + x4 * (-x1121 * x52 + x1126)
            ),
            x129
            * (
                x1163 * x3
                + x1168
                + x517 * x968
                - x52 * (x1161 * x3 + x1170 + x512 * x968)
            )
            + x3
            * (
                x1159 * x46
                + x3 * (x1166 + x3 * (x1164 + x508 * x968) + x510 * x968)
                + x4 * (-x1161 * x52 + x1163)
            )
            + x46 * (x1159 * x3 + x4 * (x3 * x484 * x968 - x487 * x968)),
            x129
            * (
                x1171 * x3 * x46
                + x1184 * x3
                + x1192
                - x52 * (x1179 * x3 + x1181 * x3 + x1194)
            )
            + x3
            * (
                x1178 * x46
                + x3 * (x1185 * x3 + x1189 + x3 * (x1185 + x1187 * x3))
                + x4 * (-x1181 * x52 + x1184)
            )
            + x46 * (x1178 * x3 + x4 * (x1171 * x3 - x1173 * x3)),
            x129
            * (
                x1195 * x3 * x46
                + x1207 * x3
                + x1214
                - x52 * (x1202 * x3 + x1204 * x3 + x1216)
            )
            + x3
            * (
                x1201 * x46
                + x3 * (x1208 * x3 + x1211 + x3 * (x1208 + x1209 * x3))
                + x4 * (-x1204 * x52 + x1207)
            )
            + x46 * (x1201 * x3 + x4 * (x1195 * x3 - x1197 * x3)),
            x129
            * (
                x1217 * x3 * x46
                + x1233 * x3
                + x1243
                - x52 * (x1226 * x3 + x1229 * x3 + x1245)
            )
            + x3
            * (
                x1225 * x46
                + x3 * (x1239 + x1240 + x3 * (x1234 + x1236))
                + x4 * (-x1229 * x52 + x1233)
            )
            + x46 * (x1225 * x3 + x4 * (x1217 * x3 - x1219 * x3)),
            x129 * (x1249 - x52 * (x1251 + x628 * x968) + x632 * x968)
            + x3 * (x3 * (x1247 + x626 * x968) + x4 * (x3 * x621 * x968 - x624 * x968)),
            x129 * (x1252 * x236 + x1260 - x52 * (x1253 * x236 + x1262))
            + x3 * (x3 * (x1255 * x236 + x1257) + x4 * (x1252 * x3 - x1254 * x3)),
            x129 * (x1263 * x236 + x1271 - x52 * (x1264 * x236 + x1273))
            + x3 * (x3 * (x1266 * x236 + x1268) + x4 * (x1263 * x3 - x1265 * x3)),
            x129 * (x1274 * x236 + x1282 - x52 * (x1275 * x236 + x1284))
            + x3 * (x3 * (x1277 * x236 + x1279) + x4 * (x1274 * x3 - x1276 * x3)),
            x129 * (x1285 * x236 + x1294 - x52 * (x1286 * x236 + x1296))
            + x3 * (x3 * (x1289 + x1291) + x4 * (x1285 * x3 - x1287 * x3)),
            x3 * (x1310 * x77 + x1314 * x83 + x3 * (x1306 * x3 + 4.0 * x1309))
            + x4 * (x1298 * x3 + 4.0 * x1300 - x52 * (x1302 * x3 + 4.0 * x1304))
            + x83 * (x1314 * x3 + x1315 * x77 + x92 * (x1312 * x3 + 2.0 * x1317)),
            x3 * (x1328 * x77 + x1332 * x92 + x3 * (x1325 * x3 + x1327 * x92))
            + x4 * (x1319 * x3 + x1320 * x92 - x52 * (x1322 * x3 + x1323 * x92))
            + x92 * (x104 * (x1330 * x3 + x1334) + x1332 * x3 + x1333 * x77),
            x3 * (x1344 * x77 + x1347 * x92 + x3 * (x1341 * x3 + 3.0 * x1343))
            + x4 * (x1335 * x3 + 3.0 * x1337 - x52 * (x1338 * x3 + 3.0 * x1340))
            + x92 * (x104 * (x1345 * x3 + x1349) + x1347 * x3 + x1348 * x77),
            x104 * (x1358 * x3 + x1359 * x3 + x1360 * x77)
            + x3 * (x104 * x1359 + x1356 * x77 + x3 * (x104 * x1355 + x1354 * x3))
            + x4 * (x104 * x1351 + x1350 * x3 - x52 * (x104 * x1353 + x1352 * x3)),
            x104 * (x1372 * x3 + x1373 * x3 + x1374 * x77)
            + x3 * (x104 * x1373 + x1370 * x77 + x3 * (x1367 * x3 + x1369))
            + x4 * (x1361 * x3 + x1363 - x52 * (x1364 * x3 + x1366)),
            x104 * (x1387 * x3 + x1388 * x3 + x1389 * x77)
            + x3 * (x104 * x1388 + x1385 * x77 + x3 * (x1382 * x3 + 2.0 * x1384))
            + x4 * (x1375 * x3 + 2.0 * x1377 - x52 * (x1378 * x3 + 2.0 * x1381)),
            x3 * (x1398 * x3 + x1400 * x77 + x3 * (x1398 + x1399 * x3))
            + x4 * (x1391 + x1392 * x3 - x52 * (x1394 + x1395 * x3))
            + x46 * (x1396 * x236 + x1397 * x77),
            x3 * (x1409 * x3 + x1411 * x77 + x3 * (x1409 + x1410 * x3))
            + x4 * (x1402 + x1403 * x3 - x52 * (x1405 + x1406 * x3))
            + x46 * (x1407 * x236 + x1408 * x77),
            x3 * (x1420 * x3 + x1422 * x77 + x3 * (x1420 + x1421 * x3))
            + x4 * (x1413 + x1414 * x3 - x52 * (x1416 + x1417 * x3))
            + x46 * (x1418 * x236 + x1419 * x77),
            x3 * (x1432 * x3 + x1434 * x77 + x3 * (x1432 + x1433 * x3))
            + x4 * (x1424 + x1425 * x3 - x52 * (x1427 + x1429 * x3))
            + x46 * (x1430 * x236 + x1431 * x77),
            x3 * (x1438 * x236 + x1439 * x77) + x4 * (x1435 * x3 - x1437 * x3),
            x3 * (x1443 * x236 + x1444 * x77) + x4 * (x1440 * x3 - x1442 * x3),
            x3 * (x1448 * x236 + x1449 * x77) + x4 * (x1445 * x3 - x1447 * x3),
            x3 * (x1453 * x236 + x1454 * x77) + x4 * (x1450 * x3 - x1452 * x3),
            x3 * (x1458 * x236 + x1459 * x77) + x4 * (x1455 * x3 - x1457 * x3),
            x3 * (0.5 * x1460 + x1461 * x83 + x3 * (x689 * x968 + x690 * x968))
            + x4 * (-x52 * (x683 * x968 + x684 * x968) + x686 * x968 + x687 * x83 * x968)
            + x83 * (x1461 * x3 + 0.5 * x1462 + x92 * (x698 * x968 + x700 * x968)),
            x3 * (0.5 * x1475 + x1479 * x92 + x3 * (x1472 * x3 + x1474 * x92))
            + x4 * (x1464 * x3 + x1466 * x92 - x52 * (x1468 * x3 + x1470 * x92))
            + x92 * (x104 * (x1477 * x3 + x1481) + x1479 * x3 + 0.5 * x1480),
            x3 * (0.5 * x1483 + x1484 * x92 + x3 * (x1025 * x682 + x1028 * x682))
            + x4 * (x1020 * x682 + x1482 * x92 - x52 * (x1014 * x682 + x1017 * x682))
            + x92 * (x104 * (x1042 * x682 + x1486) + x1484 * x3 + 0.5 * x1485),
            x104 * (x1495 * x3 + x1496 * x3 + 0.5 * x1497)
            + x3 * (x104 * x1496 + 0.5 * x1493 + x3 * (x104 * x1492 + x1491 * x3))
            + x4 * (x104 * x1488 + x1487 * x3 - x52 * (x104 * x1490 + x1489 * x3)),
            x104 * (x1509 * x3 + x1510 * x3 + 0.5 * x1511)
            + x3 * (x104 * x1510 + 0.5 * x1507 + x3 * (x1504 * x3 + x1506))
            + x4 * (x1498 * x3 + x1500 - x52 * (x1501 * x3 + x1503)),
            x104 * (x1142 * x682 + x1515 * x3 + 0.5 * x1516)
            + x3 * (x104 * x1515 + 0.5 * x1513 + x3 * (x1128 * x682 + x1131 * x682))
            + x4 * (x104 * x1512 + x1123 * x682 - x52 * (x1115 * x682 + x1120 * x682)),
            x3 * (x1525 * x3 + 0.5 * x1527 + x3 * (x1525 + x1526 * x3))
            + x4 * (x1518 + x1519 * x3 - x52 * (x1521 + x1522 * x3))
            + x46 * (x1523 * x236 + 0.5 * x1524),
            x3 * (x1539 * x3 + 0.5 * x1541 + x3 * (x1539 + x1540 * x3))
            + x4 * (x1530 + x1531 * x3 - x52 * (x1534 + x1535 * x3))
            + x46 * (x1537 * x236 + 0.5 * x1538),
            x3 * (x1550 * x3 + 0.5 * x1552 + x3 * (x1550 + x1551 * x3))
            + x4 * (x1543 + x1544 * x3 - x52 * (x1546 + x1547 * x3))
            + x46 * (x1548 * x236 + 0.5 * x1549),
            x3 * (x1240 * x682 + 0.5 * x1557 + x3 * (x1236 * x682 + x1556))
            + x4 * (x1232 * x682 + x1553 - x52 * (x1228 * x682 + x1554))
            + x46 * (x1222 * x682 + 0.5 * x1555),
            x3 * (x1561 * x236 + 0.5 * x1562) + x4 * (x1558 * x3 - x1560 * x3),
            x3 * (x1566 * x236 + 0.5 * x1567) + x4 * (x1563 * x3 - x1565 * x3),
            x3 * (x1571 * x236 + 0.5 * x1572) + x4 * (x1568 * x3 - x1570 * x3),
            x3 * (x1576 * x236 + 0.5 * x1577) + x4 * (x1573 * x3 - x1575 * x3),
            x3 * (x1289 * x682 + 0.5 * x1578) + x4 * (x1285 * x3 * x682 - x1287 * x762),
            x3 * (x1593 + x1598 * x83 + x3 * (x1587 + x1590))
            + x4 * (x1580 * x3 + 4.0 * x1582 - x52 * (x1583 * x3 + 4.0 * x1585))
            + x83 * (x1598 * x3 + x1600 + x92 * (x1595 * x3 + 2.0 * x1602)),
            x3 * (x1613 + x1617 * x92 + x3 * (x1609 * x3 + 3.0 * x1611))
            + x4 * (x1603 * x3 + 3.0 * x1605 - x52 * (x1606 * x3 + 3.0 * x1608))
            + x92 * (x104 * (x1614 * x3 + x1620) + x1617 * x3 + x1619),
            x3 * (x1634 + x1639 * x92 + x3 * (x1628 + x1631))
            + x4 * (x1621 * x3 + 3.0 * x1623 - x52 * (x1624 * x3 + 3.0 * x1626))
            + x92 * (x104 * (x1636 * x3 + x1642) + x1639 * x3 + x1641),
            x104 * (x1656 * x3 + x1657 * x3 + x1659)
            + x3 * (x104 * x1657 + x1654 + x3 * (x1650 * x3 + 2.0 * x1652))
            + x4 * (x1643 * x3 + 2.0 * x1645 - x52 * (x1646 * x3 + 2.0 * x1649)),
            x104 * (x1672 * x3 + x1673 * x3 + x1675)
            + x3 * (x104 * x1673 + x1670 + x3 * (x1666 * x3 + x1668))
            + x4 * (x1660 * x3 + x1662 - x52 * (x1663 * x3 + x1665)),
            x104 * (x1691 * x3 + x1693 * x3 + x1695)
            + x3 * (x104 * x1693 + x1689 + x3 * (x1683 + x1686))
            + x4 * (x1676 * x3 + 2.0 * x1678 - x52 * (x1679 * x3 + 2.0 * x1681)),
            x3 * (x1706 * x3 + x1709 + x3 * (x1706 + x1707 * x3))
            + x4 * (x1697 + x1698 * x3 - x52 * (x1700 + x1702 * x3))
            + x46 * (x1703 * x236 + x1705),
            x3 * (x1719 * x3 + x1722 + x3 * (x1719 + x1720 * x3))
            + x4 * (x1711 + x1712 * x3 - x52 * (x1714 + x1715 * x3))
            + x46 * (x1716 * x236 + x1718),
            x3 * (x1732 * x3 + x1735 + x3 * (x1732 + x1733 * x3))
            + x4 * (x1724 + x1725 * x3 - x52 * (x1727 + x1728 * x3))
            + x46 * (x1729 * x236 + x1731),
            x3 * (x1750 + x1751 + x3 * (x1745 + x1747))
            + x4 * (x1737 + x1738 * x3 - x52 * (x1740 + x1741 * x3))
            + x46 * (x1742 * x236 + x1744),
            x3 * (x1755 * x236 + x1757) + x4 * (x1752 * x3 - x1754 * x3),
            x3 * (x1761 * x236 + x1763) + x4 * (x1758 * x3 - x1760 * x3),
            x3 * (x1767 * x236 + x1769) + x4 * (x1764 * x3 - x1766 * x3),
            x3 * (x1773 * x236 + x1775) + x4 * (x1770 * x3 - x1772 * x3),
            x3 * (x1780 + x1782) + x4 * (x1776 * x3 - x1778 * x3),
            x1786 * x77
            + x3 * (x1783 * x3 + 4.0 * x1785)
            + x83 * (x1784 * x3 + 3.0 * x1787),
            x1790 * x77 + x3 * (x1788 * x3 + x1789 * x92) + x92 * (x1789 * x3 + x1791),
            x1795 * x77
            + x3 * (x1792 * x3 + 3.0 * x1794)
            + x92 * (x1793 * x3 + 2.0 * x1796),
            x104 * (x1798 * x3 + x1800) + x1799 * x77 + x3 * (x104 * x1798 + x1797 * x3),
            x104 * (x1802 * x3 + x1805) + x1804 * x77 + x3 * (x1801 * x3 + x1803),
            x104 * (x1807 * x3 + x1810) + x1809 * x77 + x3 * (x1806 * x3 + 2.0 * x1808),
            x1812 * x3 + x1814 * x77 + x3 * (x1812 + x1813 * x3),
            x1816 * x3 + x1818 * x77 + x3 * (x1816 + x1817 * x3),
            x1820 * x3 + x1822 * x77 + x3 * (x1820 + x1821 * x3),
            x1824 * x3 + x1826 * x77 + x3 * (x1824 + x1825 * x3),
            x1827 * x236 + x1828 * x77,
            x1829 * x236 + x1830 * x77,
            x1831 * x236 + x1832 * x77,
            x1833 * x236 + x1834 * x77,
            x1835 * x236 + x1836 * x77,
            x1840 * x77
            + x3 * (x1837 * x3 + 4.0 * x1839)
            + x83 * (x1838 * x3 + 3.0 * x1841),
            x1844 * x77 + x3 * (x1842 * x3 + x1843 * x92) + x92 * (x1843 * x3 + x1845),
            x1849 * x77
            + x3 * (x1846 * x3 + 3.0 * x1848)
            + x92 * (x1847 * x3 + 2.0 * x1850),
            x104 * (x1852 * x3 + x1854) + x1853 * x77 + x3 * (x104 * x1852 + x1851 * x3),
            x104 * (x1856 * x3 + x1859) + x1858 * x77 + x3 * (x1855 * x3 + x1857),
            x104 * (x1861 * x3 + x1864) + x1863 * x77 + x3 * (x1860 * x3 + 2.0 * x1862),
            x1866 * x3 + x1868 * x77 + x3 * (x1866 + x1867 * x3),
            x1870 * x3 + x1872 * x77 + x3 * (x1870 + x1871 * x3),
            x1874 * x3 + x1876 * x77 + x3 * (x1874 + x1875 * x3),
            x1878 * x3 + x1880 * x77 + x3 * (x1878 + x1879 * x3),
            x1881 * x236 + x1882 * x77,
            x1883 * x236 + x1884 * x77,
            x1885 * x236 + x1886 * x77,
            x1887 * x236 + x1888 * x77,
            x1889 * x236 + x1890 * x77,
            0.5 * x1891
            + x3 * (x1587 * x682 + x1590 * x682)
            + x83 * (x1594 * x682 + x1597 * x682),
            0.5 * x1894 + x3 * (x1892 * x3 + x1893 * x92) + x92 * (x1893 * x3 + x1895),
            0.5 * x1896
            + x3 * (x1628 * x682 + x1631 * x682)
            + x92 * (x1635 * x682 + x1638 * x682),
            x104 * (x1898 * x3 + x1900) + 0.5 * x1899 + x3 * (x104 * x1898 + x1897 * x3),
            x104 * (x1902 * x3 + x1905) + 0.5 * x1904 + x3 * (x1901 * x3 + x1903),
            x104 * (x1692 * x682 + x1907)
            + 0.5 * x1906
            + x3 * (x1683 * x682 + x1686 * x682),
            x1909 * x3 + 0.5 * x1911 + x3 * (x1909 + x1910 * x3),
            x1914 * x3 + 0.5 * x1916 + x3 * (x1914 + x1915 * x3),
            x1918 * x3 + 0.5 * x1920 + x3 * (x1918 + x1919 * x3),
            x1751 * x682 + 0.5 * x1922 + x3 * (x1747 * x682 + x1921),
            x1923 * x236 + 0.5 * x1924,
            x1925 * x236 + 0.5 * x1926,
            x1927 * x236 + 0.5 * x1928,
            x1929 * x236 + 0.5 * x1930,
            x1780 * x682 + 0.5 * x1931,
            x1938 + x3 * (x1933 + x1936) + x83 * (x1934 * x3 + 3.0 * x1939),
            x1944 + x3 * (x1940 * x3 + 3.0 * x1942) + x92 * (x1941 * x3 + x1946),
            x1953 + x3 * (x1948 + x1951) + x92 * (x1949 * x3 + x1955),
            x104 * (x1957 * x3 + x1961) + x1960 + x3 * (x1956 * x3 + 2.0 * x1958),
            x104 * (x1963 * x3 + x1967) + x1966 + x3 * (x1962 * x3 + x1964),
            x104 * (x1970 * x3 + x1975) + x1974 + x3 * (x1969 + x1972),
            x1977 * x3 + x1980 + x3 * (x1977 + x1978 * x3),
            x1982 * x3 + x1985 + x3 * (x1982 + x1983 * x3),
            x1987 * x3 + x1990 + x3 * (x1987 + x1988 * x3),
            x1992 * x3 + x1996 + x3 * (x1992 + x1994),
            x1997 * x236 + x1999,
            x2000 * x236 + x2002,
            x2003 * x236 + x2005,
            x2006 * x236 + x2008,
            x2009 * x236 + x2011,
            x2012 * x3 + 4.0 * x2013,
            x2014 * x3 + x2015 * x92,
            x2016 * x3 + 3.0 * x2017,
            x104 * x2019 + x2018 * x3,
            x2020 * x3 + x2021,
            x2022 * x3 + 2.0 * x2023,
            x2024 + x2025 * x3,
            x2026 + x2027 * x3,
            x2028 + x2029 * x3,
            x2030 + x2031 * x3,
            x2032 * x3,
            x2033 * x3,
            x2034 * x3,
            x2035 * x3,
            x2036 * x3,
            x2037 * x3 + 4.0 * x2038,
            x2039 * x3 + x2040 * x92,
            x2041 * x3 + 3.0 * x2042,
            x104 * x2044 + x2043 * x3,
            x2045 * x3 + x2046,
            x2047 * x3 + 2.0 * x2048,
            x2049 + x2050 * x3,
            x2051 + x2052 * x3,
            x2053 + x2054 * x3,
            x2055 + x2056 * x3,
            x2057 * x3,
            x2058 * x3,
            x2059 * x3,
            x2060 * x3,
            x2061 * x3,
            x2062 * x3 + 4.0 * x2063,
            x2064 * x3 + x2065 * x92,
            x2066 * x3 + 3.0 * x2067,
            x104 * x2069 + x2068 * x3,
            x2070 * x3 + x2071,
            x2072 * x3 + 2.0 * x2073,
            x2074 + x2075 * x3,
            x2076 + x2077 * x3,
            x2078 + x2079 * x3,
            x2080 + x2081 * x3,
            x2082 * x3,
            x2083 * x3,
            x2084 * x3,
            x2085 * x3,
            x2086 * x3,
            x1933 * x682 + x1936 * x682,
            x2087 * x3 + x2088 * x92,
            x1948 * x682 + x1951 * x682,
            x104 * x2090 + x2089 * x3,
            x2091 * x3 + x2092,
            x1969 * x682 + x1972 * x682,
            x2093 + x2094 * x3,
            x2096 + x2097 * x3,
            x2098 + x2099 * x3,
            x1994 * x682 + x2100,
            x2101 * x3,
            x2102 * x3,
            x2103 * x3,
            x2104 * x3,
            x2009 * x762,
            x2105 * x3 + 4.0 * x2106,
            x2107 * x3 + 3.0 * x2108,
            x2109 * x3 + 3.0 * x2110,
            x2111 * x3 + 2.0 * x2112,
            x2113 * x3 + x2114,
            x2115 * x3 + 2.0 * x2116,
            x2117 + x2118 * x3,
            x2119 + x2120 * x3,
            x2121 + x2122 * x3,
            x2123 + x2124 * x3,
            x2125 * x3,
            x2126 * x3,
            x2127 * x3,
            x2128 * x3,
            x2129 * x3,
            x1786 * x23 + x2012 * x682,
            x1790 * x23 + x2013 + x2014 * x682,
            x1795 * x23 + x2016 * x682,
            x104 * x2015 + x1799 * x23 + x2018 * x682,
            x1804 * x23 + x2017 + x2020 * x682,
            x1809 * x23 + x2022 * x682,
            x1814 * x23 + x2019 * x92 + x2025 * x682,
            x1818 * x23 + x2021 + x2027 * x682,
            x1822 * x23 + x2023 + x2029 * x682,
            x1826 * x23 + x2031 * x682,
            x1828 * x23 + 4.0 * x2024 + x2032 * x682,
            x1830 * x23 + 3.0 * x2026 + x2033 * x682,
            x1832 * x23 + 2.0 * x2028 + x2034 * x682,
            x1834 * x23 + x2030 + x2035 * x682,
            x1836 * x23 + x2036 * x682,
            x129 * x1840 + x2037 * x682,
            x129 * x1844 + x2038 + x2039 * x682,
            x129 * x1849 + x2041 * x682,
            x104 * x2040 + x129 * x1853 + x2043 * x682,
            x129 * x1858 + x2042 + x2045 * x682,
            x129 * x1863 + x2047 * x682,
            x129 * x1868 + x2044 * x92 + x2050 * x682,
            x129 * x1872 + x2046 + x2052 * x682,
            x129 * x1876 + x2048 + x2054 * x682,
            x129 * x1880 + x2056 * x682,
            x129 * x1882 + 4.0 * x2049 + x2057 * x682,
            x129 * x1884 + 3.0 * x2051 + x2058 * x682,
            x129 * x1886 + 2.0 * x2053 + x2059 * x682,
            x129 * x1888 + x2055 + x2060 * x682,
            x129 * x1890 + x2061 * x682,
            x1891 + x2062 * x682,
            x1894 + x2063 + x2064 * x682,
            x1896 + x2066 * x682,
            x104 * x2065 + x1899 + x2068 * x682,
            x1904 + x2067 + x2070 * x682,
            x1906 + x2072 * x682,
            x1911 + x2069 * x92 + x2075 * x682,
            x1916 + x2071 + x2077 * x682,
            x1920 + x2073 + x2079 * x682,
            x1922 + x2081 * x682,
            x1924 + 4.0 * x2074 + x2082 * x682,
            x1926 + 3.0 * x2076 + x2083 * x682,
            x1928 + 2.0 * x2078 + x2084 * x682,
            x1930 + x2080 + x2085 * x682,
            x1931 + x2086 * x682,
            x1297 * x1932 + x1938,
            x1935 * x682 + x1944 + x2087 * x682,
            x1297 * x1947 + x1953,
            x104 * x2088 + x1960 + x2089 * x682,
            x1950 * x682 + x1966 + x2091 * x682,
            x1297 * x1968 + x1974,
            x1980 + x2090 * x92 + x2094 * x682,
            x1985 + x2092 + x2097 * x682,
            x1971 * x682 + x1990 + x2099 * x682,
            x1297 * x1993 + x1996,
            x1999 + 4.0 * x2093 + x2101 * x682,
            x2002 + 3.0 * x2096 + x2102 * x682,
            x2005 + 2.0 * x2098 + x2103 * x682,
            x2008 + x2100 + x2104 * x682,
            x1297 * x2009 + x2011,
            x2105 * x682,
            x2106 + x2107 * x682,
            x2109 * x682,
            2.0 * x2108 + x2111 * x682,
            x2110 + x2113 * x682,
            x2115 * x682,
            3.0 * x2112 + x2118 * x682,
            x2114 + x2120 * x682,
            x2116 + x2122 * x682,
            x2124 * x682,
            4.0 * x2117 + x2125 * x682,
            3.0 * x2119 + x2126 * x682,
            2.0 * x2121 + x2127 * x682,
            x2123 + x2128 * x682,
            x2129 * x682,
            x1937 * x23 + x2105 * x968,
            x1943 * x23 + x2107 * x968,
            x1952 * x23 + x2106 + x2109 * x968,
            x1959 * x23 + x2111 * x968,
            x1965 * x23 + x2108 + x2113 * x968,
            x1973 * x23 + 2.0 * x2110 + x2115 * x968,
            x1979 * x23 + x2118 * x968,
            x1984 * x23 + x2112 + x2120 * x968,
            x1989 * x23 + x2114 + x2122 * x968,
            x1995 * x23 + 3.0 * x2116 + x2124 * x968,
            x1998 * x23 + x2125 * x968,
            x2001 * x23 + x2117 + x2126 * x968,
            x2004 * x23 + 2.0 * x2119 + x2127 * x968,
            x2007 * x23 + 3.0 * x2121 + x2128 * x968,
            x2010 * x23 + 4.0 * x2123 + x2129 * x968,
        ]
    )


def _2center2el3d_55(a, A, b, B):
    """Cartesian (h|h) two-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a ** (-1.0)
    x5 = -x2 - B[0]
    x6 = b ** (-1.0)
    x7 = a * x1
    x8 = b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    x9 = boys(8, x8)
    x10 = x0 ** (-1.5)
    x11 = 17.4934183276249
    x12 = 2.0 * x6
    x13 = x11 * x12
    x14 = x10 * x13
    x15 = x14 * x9
    x16 = x15 * x5
    x17 = x0 ** (-0.5)
    x18 = boys(7, x8)
    x19 = 0.5 * x6
    x20 = x19 * (2.0 * x11 * x17 * x18 * x4 * x6 - x15)
    x21 = boys(9, x8)
    x22 = x5**2
    x23 = x17 * x4
    x24 = x13 * x23
    x25 = x22 * x24
    x26 = x21 * x25
    x27 = x20 + x26
    x28 = x27 * x5 + x6 * (2.0 * x11 * x17 * x18 * x4 * x5 * x6 - x16)
    x29 = x14 * x18
    x30 = boys(6, x8)
    x31 = x19 * (2.0 * x11 * x17 * x30 * x4 * x6 - x29)
    x32 = x24 * x9
    x33 = x22 * x32
    x34 = x31 + x33
    x35 = x14 * x30
    x36 = boys(5, x8)
    x37 = x19 * (2.0 * x11 * x17 * x36 * x4 * x6 - x35)
    x38 = x18 * x24
    x39 = x22 * x38
    x40 = x37 + x39
    x41 = 1.5 * x6
    x42 = x28 * x5 + x41 * (-x34 * x7 + x40)
    x43 = x29 * x5
    x44 = x34 * x5 + x6 * (2.0 * x11 * x17 * x30 * x4 * x5 * x6 - x43)
    x45 = x35 * x5
    x46 = x40 * x5 + x6 * (2.0 * x11 * x17 * x36 * x4 * x5 * x6 - x45)
    x47 = x12 * (-x44 * x7 + x46) + x42 * x5
    x48 = x3 * x47
    x49 = (2.0 * a + 2.0 * b) ** (-1.0)
    x50 = x14 * x36
    x51 = boys(4, x8)
    x52 = x19 * (2.0 * x11 * x17 * x4 * x51 * x6 - x50)
    x53 = x24 * x30
    x54 = x22 * x53
    x55 = x52 + x54
    x56 = x41 * (-x40 * x7 + x55) + x44 * x5
    x57 = x49 * x56
    x58 = 5.0 * x57
    x59 = x48 + x58
    x60 = b * x1
    x61 = x5 * x50
    x62 = x5 * x55 + x6 * (2.0 * x11 * x17 * x4 * x5 * x51 * x6 - x61)
    x63 = x12 * (-x46 * x7 + x62) + x5 * x56
    x64 = x3 * x63
    x65 = x14 * x51
    x66 = boys(3, x8)
    x67 = x19 * (2.0 * x11 * x17 * x4 * x6 * x66 - x65)
    x68 = x24 * x36
    x69 = x22 * x68
    x70 = x67 + x69
    x71 = x41 * (-x55 * x7 + x70) + x46 * x5
    x72 = x49 * x71
    x73 = 5.0 * x72
    x74 = x64 + x73
    x75 = x14 * x21
    x76 = x5 * x75
    x77 = x19 * (2.0 * x11 * x17 * x4 * x6 * x9 - x75)
    x78 = boys(10, x8)
    x79 = x25 * x78
    x80 = x12 * (-x28 * x7 + x44) + x5 * (
        x41 * (-x27 * x7 + x34)
        + x5 * (x5 * (x77 + x79) + x6 * (2.0 * x11 * x17 * x4 * x5 * x6 * x9 - x76))
    )
    x81 = x3 * x80
    x82 = x42 * x49
    x83 = 5.0 * x82
    x84 = x47 * x60
    x85 = 0.5 * x4
    x86 = x85 * (x63 - x84)
    x87 = x3 * x42
    x88 = x44 * x49
    x89 = 4.0 * x88
    x90 = x87 + x89
    x91 = 5.0 * x49
    x92 = x56 * x60
    x93 = x85 * (x71 - x92)
    x94 = x3 * x44
    x95 = x40 * x49
    x96 = 3.0 * x95
    x97 = x94 + x96
    x98 = 4.0 * x49
    x99 = x3 * x90 + x93 + x97 * x98
    x100 = x3 * x56
    x101 = x46 * x49
    x102 = 4.0 * x101
    x103 = x100 + x102
    x104 = x3 * x71
    x105 = x49 * x62
    x106 = 4.0 * x105
    x107 = x104 + x106
    x108 = x46 * x60
    x109 = x85 * (-x108 + x62)
    x110 = x3 * x40
    x111 = x11 * x30
    x112 = x111 * x5
    x113 = x23 * x6 * x98
    x114 = x112 * x113
    x115 = x110 + x114
    x116 = 3.0 * x49
    x117 = x109 + x115 * x116 + x3 * x97
    x118 = x117 * x98 + x3 * x99 + x4 * (-x103 * x60 + x107)
    x119 = x5 * x65
    x120 = x5 * x70 + x6 * (2.0 * x11 * x17 * x4 * x5 * x6 * x66 - x119)
    x121 = x12 * (x120 - x62 * x7) + x5 * x71
    x122 = x85 * (x121 - x60 * x63)
    x123 = x103 * x91 + x122 + x3 * x59
    x124 = x14 * x66
    x125 = boys(2, x8)
    x126 = x19 * (2.0 * x11 * x125 * x17 * x4 * x6 - x124)
    x127 = x24 * x51
    x128 = x127 * x22
    x129 = x126 + x128
    x130 = x41 * (x129 - x7 * x70) + x5 * x62
    x131 = (
        x12
        * (
            -x120 * x7
            + x129 * x5
            + x6 * (2.0 * x11 * x125 * x17 * x4 * x5 * x6 - x124 * x5)
        )
        + x130 * x5
    )
    x132 = x85 * (-x121 * x60 + x131)
    x133 = x107 * x91 + x132 + x3 * x74
    x134 = 1.5 * x4
    x135 = x19 * (2.0 * x11 * x17 * x4 * x6 * boys(1, x8) - x125 * x14)
    x136 = x24 * x66
    x137 = x120 * x5 + x41 * (-x129 * x7 + x135 + x136 * x22)
    x138 = x137 * x49
    x139 = x130 * x49
    x140 = x121 * x3 + 5.0 * x139
    x141 = x85 * (-x130 * x60 + x137)
    x142 = x49 * x70
    x143 = 3.0 * x142 + x3 * x62
    x144 = x107 * x3 + x141 + x143 * x98
    x145 = x85 * (x130 - x60 * x71)
    x146 = x49 * x55
    x147 = 3.0 * x146 + x3 * x46
    x148 = x103 * x3 + x145 + x147 * x98
    x149 = 2.0 * x4
    x150 = x85 * (-x55 * x60 + x70)
    x151 = x49 * x68
    x152 = x3 * x5
    x153 = 2.0 * x49
    x154 = -x1 * (a * A[1] + b * B[1])
    x155 = -x154 - B[1]
    x156 = x155 * x5
    x157 = x15 * x155
    x158 = x6 * (2.0 * x11 * x155 * x17 * x18 * x4 * x6 - x157)
    x159 = x155 * x26
    x160 = 0.5 * x158 + x159
    x161 = x160 * x5 + x6 * (2.0 * x11 * x155 * x17 * x18 * x4 * x5 * x6 - x15 * x156)
    x162 = x155 * x29
    x163 = x6 * (2.0 * x11 * x155 * x17 * x30 * x4 * x6 - x162)
    x164 = x155 * x33
    x165 = 0.5 * x163 + x164
    x166 = x155 * x35
    x167 = x6 * (2.0 * x11 * x155 * x17 * x36 * x4 * x6 - x166)
    x168 = x155 * x39
    x169 = 0.5 * x167 + x168
    x170 = x161 * x5 + x41 * (-x165 * x7 + x169)
    x171 = x170 * x3
    x172 = x165 * x5 + x6 * (2.0 * x11 * x155 * x17 * x30 * x4 * x5 * x6 - x156 * x29)
    x173 = x172 * x49
    x174 = 4.0 * x173
    x175 = x171 + x174
    x176 = x155 * x50
    x177 = x6 * (2.0 * x11 * x155 * x17 * x4 * x51 * x6 - x176)
    x178 = x155 * x54
    x179 = 0.5 * x177 + x178
    x180 = x172 * x5 + x41 * (-x169 * x7 + x179)
    x181 = x180 * x3
    x182 = -2.0 * x11 * x155 * x17 * x36 * x4 * x5 * x6
    x183 = x169 * x5 + x6 * (-x156 * x35 - x182)
    x184 = x183 * x49
    x185 = x181 + 4.0 * x184
    x186 = x155 * x75
    x187 = x6 * (2.0 * x11 * x155 * x17 * x4 * x6 * x9 - x186)
    x188 = x155 * x79
    x189 = x41 * (-x160 * x7 + x165) + x5 * (
        x5 * (0.5 * x187 + x188)
        + x6 * (2.0 * x11 * x155 * x17 * x4 * x5 * x6 * x9 - x156 * x75)
    )
    x190 = x189 * x3
    x191 = x161 * x49
    x192 = 4.0 * x191
    x193 = x170 * x60
    x194 = x85 * (x180 - x193)
    x195 = x161 * x3
    x196 = x165 * x49
    x197 = 3.0 * x196
    x198 = x195 + x197
    x199 = x172 * x60
    x200 = x85 * (x183 - x199)
    x201 = x165 * x3
    x202 = x11 * x156
    x203 = x18 * x202
    x204 = x113 * x203
    x205 = x201 + x204
    x206 = x116 * x205 + x198 * x3 + x200
    x207 = x172 * x3
    x208 = x169 * x49
    x209 = 3.0 * x208
    x210 = x207 + x209
    x211 = x183 * x3
    x212 = x179 * x49
    x213 = x211 + 3.0 * x212
    x214 = x169 * x60
    x215 = x85 * (x179 - x214)
    x216 = x155 * x53
    x217 = x216 * x49
    x218 = x152 * x155
    x219 = x218 * x38
    x220 = x217 + x219
    x221 = x153 * x220 + x205 * x3 + x215
    x222 = x116 * x221 + x206 * x3 + x4 * (-x210 * x60 + x213)
    x223 = x155 * x65
    x224 = x6 * (2.0 * x11 * x155 * x17 * x4 * x6 * x66 - x223)
    x225 = x155 * x69
    x226 = 0.5 * x224 + x225
    x227 = x183 * x5 + x41 * (-x179 * x7 + x226)
    x228 = x85 * (-x180 * x60 + x227)
    x229 = x175 * x3 + x210 * x98 + x228
    x230 = x179 * x5 + x6 * (2.0 * x11 * x155 * x17 * x4 * x5 * x51 * x6 - x156 * x50)
    x231 = x6 * (2.0 * x11 * x125 * x155 * x17 * x4 * x6 - x124 * x155)
    x232 = x230 * x5 + x41 * (x128 * x155 - x226 * x7 + 0.5 * x231)
    x233 = x85 * (-x227 * x60 + x232)
    x234 = x185 * x3 + x213 * x98 + x233
    x235 = x226 * x5 + x6 * (2.0 * x11 * x155 * x17 * x4 * x5 * x6 * x66 - x156 * x65)
    x236 = x235 * x49
    x237 = x230 * x49
    x238 = x227 * x3 + 4.0 * x237
    x239 = x85 * (-x230 * x60 + x235)
    x240 = x113 * x202 * x36
    x241 = x179 * x3 + x240
    x242 = x116 * x241 + x213 * x3 + x239
    x243 = x85 * (-x183 * x60 + x230)
    x244 = x111 * x156
    x245 = x113 * x244
    x246 = x169 * x3 + x245
    x247 = x116 * x246 + x210 * x3 + x243
    x248 = x10 * x149
    x249 = x85 * (-x182 - x244 * x248)
    x250 = -x1 * (a * A[2] + b * B[2])
    x251 = -x250 - B[2]
    x252 = x15 * x251
    x253 = x6 * (2.0 * x11 * x17 * x18 * x251 * x4 * x6 - x252)
    x254 = 0.5 * x253
    x255 = x251 * x26 + x254
    x256 = x255 * x5 + x6 * (2.0 * x11 * x17 * x18 * x251 * x4 * x5 * x6 - x16 * x251)
    x257 = x251 * x29
    x258 = x6 * (2.0 * x11 * x17 * x251 * x30 * x4 * x6 - x257)
    x259 = 0.5 * x258
    x260 = x251 * x33 + x259
    x261 = x251 * x35
    x262 = x6 * (2.0 * x11 * x17 * x251 * x36 * x4 * x6 - x261)
    x263 = 0.5 * x262
    x264 = x251 * x39 + x263
    x265 = x256 * x5 + x41 * (-x260 * x7 + x264)
    x266 = x265 * x3
    x267 = x260 * x5 + x6 * (2.0 * x11 * x17 * x251 * x30 * x4 * x5 * x6 - x251 * x43)
    x268 = x267 * x49
    x269 = 4.0 * x268
    x270 = x266 + x269
    x271 = x251 * x50
    x272 = x6 * (2.0 * x11 * x17 * x251 * x4 * x51 * x6 - x271)
    x273 = 0.5 * x272
    x274 = x251 * x54 + x273
    x275 = x267 * x5 + x41 * (-x264 * x7 + x274)
    x276 = x275 * x3
    x277 = -2.0 * x11 * x17 * x251 * x36 * x4 * x5 * x6
    x278 = x264 * x5 + x6 * (-x251 * x45 - x277)
    x279 = x278 * x49
    x280 = x276 + 4.0 * x279
    x281 = x251 * x75
    x282 = x6 * (2.0 * x11 * x17 * x251 * x4 * x6 * x9 - x281)
    x283 = 0.5 * x282
    x284 = x41 * (-x255 * x7 + x260) + x5 * (
        x5 * (x251 * x79 + x283)
        + x6 * (2.0 * x11 * x17 * x251 * x4 * x5 * x6 * x9 - x251 * x76)
    )
    x285 = x284 * x3
    x286 = x256 * x49
    x287 = 4.0 * x286
    x288 = x265 * x60
    x289 = x85 * (x275 - x288)
    x290 = x256 * x3
    x291 = x260 * x49
    x292 = 3.0 * x291
    x293 = x290 + x292
    x294 = x267 * x60
    x295 = x85 * (x278 - x294)
    x296 = x260 * x3
    x297 = x113 * x251
    x298 = x11 * x297
    x299 = x298 * x5
    x300 = x18 * x299
    x301 = x296 + x300
    x302 = x116 * x301 + x293 * x3 + x295
    x303 = x267 * x3
    x304 = x264 * x49
    x305 = 3.0 * x304
    x306 = x303 + x305
    x307 = x278 * x3
    x308 = x274 * x49
    x309 = x307 + 3.0 * x308
    x310 = x264 * x60
    x311 = x85 * (x274 - x310)
    x312 = x251 * x53
    x313 = x312 * x49
    x314 = x251 * x38
    x315 = x152 * x314
    x316 = x313 + x315
    x317 = x153 * x316 + x3 * x301 + x311
    x318 = x116 * x317 + x3 * x302 + x4 * (-x306 * x60 + x309)
    x319 = x6 * (2.0 * x11 * x17 * x251 * x4 * x6 * x66 - x251 * x65)
    x320 = 0.5 * x319
    x321 = x251 * x69 + x320
    x322 = x278 * x5 + x41 * (-x274 * x7 + x321)
    x323 = x85 * (-x275 * x60 + x322)
    x324 = x270 * x3 + x306 * x98 + x323
    x325 = x274 * x5 + x6 * (2.0 * x11 * x17 * x251 * x4 * x5 * x51 * x6 - x251 * x61)
    x326 = x6 * (2.0 * x11 * x125 * x17 * x251 * x4 * x6 - x124 * x251)
    x327 = 0.5 * x326
    x328 = x325 * x5 + x41 * (x128 * x251 - x321 * x7 + x327)
    x329 = x85 * (-x322 * x60 + x328)
    x330 = x280 * x3 + x309 * x98 + x329
    x331 = x321 * x5 + x6 * (2.0 * x11 * x17 * x251 * x4 * x5 * x6 * x66 - x119 * x251)
    x332 = x331 * x49
    x333 = x325 * x49
    x334 = x3 * x322 + 4.0 * x333
    x335 = x85 * (-x325 * x60 + x331)
    x336 = x299 * x36
    x337 = x274 * x3 + x336
    x338 = x116 * x337 + x3 * x309 + x335
    x339 = x85 * (-x278 * x60 + x325)
    x340 = x114 * x251
    x341 = x264 * x3 + x340
    x342 = x116 * x341 + x3 * x306 + x339
    x343 = x248 * x251
    x344 = x85 * (-x112 * x343 - x277)
    x345 = x155**2
    x346 = x345 * x38 + x37
    x347 = x31 + x32 * x345
    x348 = x347 * x5
    x349 = x24 * x345
    x350 = x21 * x349
    x351 = x20 + x350
    x352 = x346 - x347 * x7
    x353 = x19 * x352 + x22 * x351
    x354 = x353 * x5 + x6 * (x346 * x5 - x348 * x7)
    x355 = x3 * x354
    x356 = x345 * x53 + x52
    x357 = -x346 * x7 + x356
    x358 = x19 * x357 + x22 * x347
    x359 = x358 * x49
    x360 = 3.0 * x359
    x361 = x355 + x360
    x362 = -x356 * x5
    x363 = x346 * x5
    x364 = x358 * x5 + x6 * (-x362 - x363 * x7)
    x365 = x3 * x364
    x366 = x345 * x68 + x67
    x367 = -x356 * x7 + x366
    x368 = x19 * x367 + x22 * x346
    x369 = x368 * x49
    x370 = 3.0 * x369
    x371 = x365 + x370
    x372 = x351 * x7
    x373 = x349 * x78
    x374 = x373 + x77
    x375 = x347 - x372
    x376 = x5 * (x19 * x375 + x22 * x374) + x6 * (x347 * x5 - x372 * x5)
    x377 = x3 * x376
    x378 = x353 * x49
    x379 = 3.0 * x378
    x380 = x354 * x60
    x381 = x85 * (x364 - x380)
    x382 = x3 * x353
    x383 = x153 * x348
    x384 = x382 + x383
    x385 = x358 * x60
    x386 = x85 * (x368 - x385)
    x387 = x346 * x49
    x388 = x3 * x348
    x389 = x387 + x388
    x390 = x153 * x389 + x3 * x384 + x386
    x391 = x3 * x358
    x392 = x153 * x363
    x393 = x391 + x392
    x394 = x3 * x368
    x395 = x356 * x5
    x396 = x153 * x395 + x394
    x397 = x363 * x60
    x398 = x85 * (-x362 - x397)
    x399 = x3 * x387
    x400 = x3 * x389 + x398 + x399
    x401 = x153 * x400 + x3 * x390 + x4 * (-x393 * x60 + x396)
    x402 = x368 * x5 + x6 * (x366 * x5 - x395 * x7)
    x403 = x85 * (-x364 * x60 + x402)
    x404 = x116 * x393 + x3 * x361 + x403
    x405 = x126 + x127 * x345
    x406 = -x366 * x7 + x405
    x407 = x19 * x406 + x22 * x356
    x408 = x407 * x5 + x6 * (-x366 * x5 * x7 + x405 * x5)
    x409 = x85 * (-x402 * x60 + x408)
    x410 = x116 * x396 + x3 * x371 + x409
    x411 = x135 + x136 * x345 - x405 * x7
    x412 = x19 * x411 + x22 * x366
    x413 = x412 * x49
    x414 = 3.0 * x413
    x415 = x407 * x49
    x416 = 3.0 * x415
    x417 = x3 * x402 + x416
    x418 = x85 * (-x407 * x60 + x412)
    x419 = x366 * x49
    x420 = x3 * x395 + x419
    x421 = x153 * x420 + x3 * x396 + x418
    x422 = x85 * (-x368 * x60 + x407)
    x423 = x356 * x49
    x424 = x3 * x363 + x423
    x425 = x153 * x424 + x3 * x393 + x422
    x426 = x3**2
    x427 = x85 * (-x356 * x60 + x366)
    x428 = x6 * (2.0 * x11 * x155 * x17 * x18 * x251 * x4 * x6 - x157 * x251)
    x429 = x159 * x251 + 0.5 * x428
    x430 = x429 * x5 + x6 * (
        2.0 * x11 * x155 * x17 * x18 * x251 * x4 * x5 * x6 - x156 * x252
    )
    x431 = x6 * (2.0 * x11 * x155 * x17 * x251 * x30 * x4 * x6 - x162 * x251)
    x432 = x164 * x251 + 0.5 * x431
    x433 = x116 * x432 + x3 * x430
    x434 = -2.0 * x11 * x155 * x17 * x251 * x30 * x4 * x5 * x6
    x435 = x432 * x5 + x6 * (-x156 * x257 - x434)
    x436 = -2.0 * x11 * x155 * x17 * x251 * x36 * x4 * x6
    x437 = x6 * (-x166 * x251 - x436)
    x438 = x168 * x251 + 0.5 * x437
    x439 = x116 * x438 + x3 * x435
    x440 = x6 * (2.0 * x11 * x155 * x17 * x251 * x4 * x6 * x9 - x186 * x251)
    x441 = x5 * (x188 * x251 + 0.5 * x440) + x6 * (
        2.0 * x11 * x155 * x17 * x251 * x4 * x5 * x6 * x9 - x156 * x281
    )
    x442 = x85 * (-x430 * x60 + x435)
    x443 = x202 * x297 * x9
    x444 = x3 * x429 + x443
    x445 = x85 * (-x432 * x60 + x438)
    x446 = x155 * x38
    x447 = x251 * x446
    x448 = x447 * x49
    x449 = x251 * x32
    x450 = x218 * x449 + x448
    x451 = x153 * x450 + x3 * x444 + x445
    x452 = x203 * x297
    x453 = x3 * x432 + x452
    x454 = x244 * x297
    x455 = x3 * x438 + x454
    x456 = x85 * (-x203 * x343 - x434)
    x457 = x3 * x448 + x3 * x450 + x456
    x458 = x153 * x457 + x3 * x451 + x4 * (-x453 * x60 + x455)
    x459 = x438 * x5 + x6 * (
        2.0 * x11 * x155 * x17 * x251 * x36 * x4 * x5 * x6 - x156 * x261
    )
    x460 = x85 * (-x435 * x60 + x459)
    x461 = x116 * x453 + x3 * x433 + x460
    x462 = x6 * (2.0 * x11 * x155 * x17 * x251 * x4 * x51 * x6 - x176 * x251)
    x463 = x178 * x251 + 0.5 * x462
    x464 = x463 * x5 + x6 * (
        2.0 * x11 * x155 * x17 * x251 * x4 * x5 * x51 * x6 - x156 * x271
    )
    x465 = x85 * (-x459 * x60 + x464)
    x466 = x116 * x455 + x3 * x439 + x465
    x467 = x6 * (2.0 * x11 * x155 * x17 * x251 * x4 * x6 * x66 - x223 * x251)
    x468 = x225 * x251 + 0.5 * x467
    x469 = x116 * x463 + x3 * x459
    x470 = x85 * (-x463 * x60 + x468)
    x471 = x151 * x155 * x251 + x218 * x312
    x472 = x153 * x471 + x3 * x455 + x470
    x473 = x85 * (-x438 * x60 + x463)
    x474 = x217 * x251 + x218 * x314
    x475 = x153 * x474 + x3 * x453 + x473
    x476 = x111 * x155
    x477 = x85 * (-x343 * x476 - x436)
    x478 = x251**2
    x479 = x37 + x38 * x478
    x480 = x31 + x32 * x478
    x481 = x480 * x5
    x482 = x24 * x478
    x483 = x20 + x21 * x482
    x484 = x22 * x483
    x485 = x479 - x480 * x7
    x486 = x19 * x485
    x487 = x484 + x486
    x488 = x487 * x5 + x6 * (x479 * x5 - x481 * x7)
    x489 = x3 * x488
    x490 = x22 * x480
    x491 = x478 * x53 + x52
    x492 = -x479 * x7 + x491
    x493 = x19 * x492
    x494 = x490 + x493
    x495 = x49 * x494
    x496 = 3.0 * x495
    x497 = x489 + x496
    x498 = -x491 * x5
    x499 = x479 * x5
    x500 = x494 * x5 + x6 * (-x498 - x499 * x7)
    x501 = x3 * x500
    x502 = x22 * x479
    x503 = x478 * x68 + x67
    x504 = -x491 * x7 + x503
    x505 = x19 * x504
    x506 = x502 + x505
    x507 = x49 * x506
    x508 = 3.0 * x507
    x509 = x501 + x508
    x510 = x483 * x7
    x511 = x482 * x78 + x77
    x512 = x22 * x511
    x513 = x480 - x510
    x514 = x19 * x513
    x515 = x5 * (x512 + x514) + x6 * (x480 * x5 - x5 * x510)
    x516 = x3 * x515
    x517 = x487 * x49
    x518 = 3.0 * x517
    x519 = x488 * x60
    x520 = x85 * (x500 - x519)
    x521 = x3 * x487
    x522 = x153 * x481
    x523 = x521 + x522
    x524 = x494 * x60
    x525 = x85 * (x506 - x524)
    x526 = x479 * x49
    x527 = x3 * x481
    x528 = x526 + x527
    x529 = x153 * x528 + x3 * x523 + x525
    x530 = x3 * x494
    x531 = x153 * x499
    x532 = x530 + x531
    x533 = x3 * x506
    x534 = x491 * x5
    x535 = x153 * x534 + x533
    x536 = x499 * x60
    x537 = x85 * (-x498 - x536)
    x538 = x3 * x526
    x539 = x3 * x528 + x537 + x538
    x540 = x153 * x539 + x3 * x529 + x4 * (-x532 * x60 + x535)
    x541 = x5 * x506 + x6 * (x5 * x503 - x534 * x7)
    x542 = x85 * (-x500 * x60 + x541)
    x543 = x116 * x532 + x3 * x497 + x542
    x544 = x126 + x127 * x478
    x545 = x5 * x503
    x546 = x22 * x491
    x547 = -x503 * x7 + x544
    x548 = x19 * x547
    x549 = x546 + x548
    x550 = x5 * x549 + x6 * (x5 * x544 - x545 * x7)
    x551 = x85 * (-x541 * x60 + x550)
    x552 = x116 * x535 + x3 * x509 + x551
    x553 = x135 + x136 * x478 - x544 * x7
    x554 = x19 * x553
    x555 = x22 * x503 + x554
    x556 = x49 * x555
    x557 = 3.0 * x556
    x558 = x49 * x549
    x559 = 3.0 * x558
    x560 = x3 * x541 + x559
    x561 = x85 * (-x549 * x60 + x555)
    x562 = x49 * x503
    x563 = x3 * x534 + x562
    x564 = x153 * x563 + x3 * x535 + x561
    x565 = x85 * (-x506 * x60 + x549)
    x566 = x49 * x491
    x567 = x3 * x499
    x568 = x566 + x567
    x569 = x153 * x568 + x3 * x532 + x565
    x570 = x85 * (-x491 * x60 + x503)
    x571 = x155 * x351 + x158
    x572 = x155 * x347 + x163
    x573 = x155 * x346 + x167
    x574 = -x572 * x7 + x573
    x575 = x19 * x574 + x22 * x571
    x576 = x3 * x575
    x577 = x49 * x572
    x578 = x5 * x577
    x579 = x576 + 2.0 * x578
    x580 = x155 * x356 + x177
    x581 = -x573 * x7 + x580
    x582 = x19 * x581 + x22 * x572
    x583 = x3 * x582
    x584 = x5 * x573
    x585 = x153 * x584 + x583
    x586 = x155 * x374 + x187
    x587 = -x571 * x7 + x572
    x588 = x19 * x587 + x22 * x586
    x589 = x3 * x588
    x590 = x5 * x571
    x591 = x575 * x60
    x592 = x85 * (x582 - x591)
    x593 = x152 * x571
    x594 = x577 + x593
    x595 = x5 * x60
    x596 = x85 * (x5 * x573 - x572 * x595)
    x597 = x3 * x577
    x598 = x3 * x594 + x596 + x597
    x599 = x49 * x573
    x600 = x152 * x572
    x601 = x599 + x600
    x602 = x49 * x580
    x603 = x3 * x584
    x604 = x602 + x603
    x605 = x426 * x572
    x606 = x573 * x60
    x607 = x85 * (x580 - x606)
    x608 = x605 + x607
    x609 = x3 * x598 + x4 * (-x60 * x601 + x604) + x49 * x608
    x610 = x155 * x366 + x224
    x611 = -x580 * x7 + x610
    x612 = x19 * x611 + x22 * x573
    x613 = x85 * (-x582 * x60 + x612)
    x614 = x153 * x601 + x3 * x579 + x613
    x615 = x155 * x405 + x231 - x610 * x7
    x616 = x19 * x615 + x22 * x580
    x617 = x85 * (-x60 * x612 + x616)
    x618 = x153 * x604 + x3 * x585 + x617
    x619 = x5 * x602
    x620 = x3 * x612 + 2.0 * x619
    x621 = x5 * x610
    x622 = x85 * (-x5 * x580 * x60 + x5 * x610)
    x623 = x3 * x602 + x3 * x604 + x622
    x624 = x85 * (x5 * x580 - x584 * x60)
    x625 = x3 * x599 + x3 * x601 + x624
    x626 = x251 * x350 + x254
    x627 = x259 + x345 * x449
    x628 = x263 + x314 * x345
    x629 = -x627 * x7 + x628
    x630 = x19 * x629 + x22 * x626
    x631 = x49 * x627
    x632 = 2.0 * x631
    x633 = x5 * x632
    x634 = x3 * x630 + x633
    x635 = x273 + x312 * x345
    x636 = -x628 * x7 + x635
    x637 = x19 * x636 + x22 * x627
    x638 = x5 * x628
    x639 = x153 * x638
    x640 = x3 * x637 + x639
    x641 = x251 * x373 + x283
    x642 = -x626 * x7 + x627
    x643 = x19 * x642 + x22 * x641
    x644 = x5 * x626
    x645 = x153 * x644
    x646 = x85 * (-x60 * x630 + x637)
    x647 = x152 * x626 + x631
    x648 = x85 * (x5 * x628 - x595 * x627)
    x649 = x3 * x631 + x3 * x647 + x648
    x650 = x49 * x628
    x651 = x152 * x627 + x650
    x652 = x49 * x635
    x653 = x3 * x638 + x652
    x654 = x60 * x628
    x655 = x85 * (x635 - x654)
    x656 = x426 * x627 + x655
    x657 = x3 * x649 + x4 * (-x60 * x651 + x653) + x49 * x656
    x658 = x251 * x345 * x68 + x320
    x659 = -x635 * x7 + x658
    x660 = x19 * x659 + x22 * x628
    x661 = x85 * (-x60 * x637 + x660)
    x662 = x153 * x651 + x3 * x634 + x661
    x663 = x127 * x251 * x345 + x327 - x658 * x7
    x664 = x19 * x663 + x22 * x635
    x665 = x85 * (-x60 * x660 + x664)
    x666 = x153 * x653 + x3 * x640 + x665
    x667 = 2.0 * x652
    x668 = x5 * x667
    x669 = x3 * x660 + x668
    x670 = x5 * x658
    x671 = x153 * x670
    x672 = x85 * (-x5 * x60 * x635 + x5 * x658)
    x673 = x3 * x652 + x3 * x653 + x672
    x674 = x85 * (x5 * x635 - x60 * x638)
    x675 = x3 * x650 + x3 * x651 + x674
    x676 = x155 * x480
    x677 = x6 * (x155 * x479 - x676 * x7)
    x678 = x155 * x484 + 0.5 * x677
    x679 = x155 * x522
    x680 = x3 * x678 + x679
    x681 = -x155 * x491
    x682 = x155 * x479
    x683 = x6 * (-x681 - x682 * x7)
    x684 = x155 * x490 + 0.5 * x683
    x685 = x155 * x499
    x686 = x153 * x685
    x687 = x3 * x684 + x686
    x688 = x6 * (x155 * x480 - x155 * x510)
    x689 = x155 * x512 + 0.5 * x688
    x690 = x156 * x483
    x691 = x153 * x690
    x692 = x85 * (-x60 * x678 + x684)
    x693 = x49 * x676
    x694 = x218 * x483 + x693
    x695 = x155 * x481
    x696 = x85 * (x155 * x479 * x5 - x60 * x695)
    x697 = x3 * x693 + x3 * x694 + x696
    x698 = x155 * x526
    x699 = x155 * x527 + x698
    x700 = x155 * x566
    x701 = x155 * x567 + x700
    x702 = x60 * x682
    x703 = x85 * (-x681 - x702)
    x704 = x426 * x676 + x703
    x705 = x3 * x697 + x4 * (-x60 * x699 + x701) + x49 * x704
    x706 = x155 * x491
    x707 = x6 * (x155 * x503 - x7 * x706)
    x708 = x155 * x502 + 0.5 * x707
    x709 = x85 * (-x60 * x684 + x708)
    x710 = x153 * x699 + x3 * x680 + x709
    x711 = x6 * (-x155 * x503 * x7 + x155 * x544)
    x712 = x155 * x546 + 0.5 * x711
    x713 = x85 * (-x60 * x708 + x712)
    x714 = x153 * x701 + x3 * x687 + x713
    x715 = x155 * x534
    x716 = x153 * x715
    x717 = x3 * x708 + x716
    x718 = x155 * x545
    x719 = x153 * x718
    x720 = x85 * (x155 * x5 * x503 - x60 * x715)
    x721 = x3 * x700 + x3 * x701 + x720
    x722 = x85 * (x155 * x491 * x5 - x60 * x685)
    x723 = x155 * x538 + x3 * x699 + x722
    x724 = x251 * x483 + x253
    x725 = x251 * x480 + x258
    x726 = x251 * x479 + x262
    x727 = -x7 * x725 + x726
    x728 = x19 * x727
    x729 = x22 * x724 + x728
    x730 = x3 * x729
    x731 = x49 * x725
    x732 = x5 * x731
    x733 = x730 + 2.0 * x732
    x734 = x251 * x491 + x272
    x735 = -x7 * x726 + x734
    x736 = x19 * x735
    x737 = x22 * x725 + x736
    x738 = x3 * x737
    x739 = x5 * x726
    x740 = x153 * x739 + x738
    x741 = x251 * x511 + x282
    x742 = -x7 * x724 + x725
    x743 = x19 * x742
    x744 = x22 * x741 + x743
    x745 = x3 * x744
    x746 = x5 * x724
    x747 = x60 * x729
    x748 = x85 * (x737 - x747)
    x749 = x152 * x724
    x750 = x731 + x749
    x751 = x85 * (x5 * x726 - x595 * x725)
    x752 = x3 * x731
    x753 = x3 * x750 + x751 + x752
    x754 = x49 * x726
    x755 = x152 * x725
    x756 = x754 + x755
    x757 = x49 * x734
    x758 = x3 * x739
    x759 = x757 + x758
    x760 = x426 * x725
    x761 = x60 * x726
    x762 = x85 * (x734 - x761)
    x763 = x760 + x762
    x764 = x3 * x753 + x4 * (-x60 * x756 + x759) + x49 * x763
    x765 = x251 * x503 + x319
    x766 = -x7 * x734 + x765
    x767 = x19 * x766
    x768 = x22 * x726 + x767
    x769 = x85 * (-x60 * x737 + x768)
    x770 = x153 * x756 + x3 * x733 + x769
    x771 = x251 * x544 + x326 - x7 * x765
    x772 = x19 * x771
    x773 = x22 * x734 + x772
    x774 = x85 * (-x60 * x768 + x773)
    x775 = x153 * x759 + x3 * x740 + x774
    x776 = x5 * x757
    x777 = x3 * x768 + 2.0 * x776
    x778 = x5 * x765
    x779 = x5 * x734
    x780 = x85 * (x5 * x765 - x60 * x779)
    x781 = x3 * x757 + x3 * x759 + x780
    x782 = x85 * (x5 * x734 - x60 * x739)
    x783 = x3 * x754
    x784 = x3 * x756 + x782 + x783
    x785 = x155 * x573 + x367 * x41
    x786 = x155 * x572 + x357 * x41
    x787 = x60 * x786
    x788 = x3 * x787
    x789 = x155 * x571 + x352 * x41
    x790 = x426 * x789
    x791 = x85 * (x785 - x787)
    x792 = x790 + x791
    x793 = x3 * x792 + x4 * (x3 * x785 - x788)
    x794 = x155 * x580 + x406 * x41
    x795 = x85 * (-x60 * x785 + x794)
    x796 = x426 * x786 + x795
    x797 = x155 * x610 + x41 * x411
    x798 = x85 * (-x60 * x794 + x797)
    x799 = x426 * x785 + x798
    x800 = x49 * x786
    x801 = x152 * x789
    x802 = x800 + x801
    x803 = x49 * x785
    x804 = x5 * x786
    x805 = x3 * x804
    x806 = x803 + x805
    x807 = x49 * x789
    x808 = x155 * x586 + x375 * x41
    x809 = x152 * x808
    x810 = x85 * (x5 * x786 - x595 * x789)
    x811 = x3 * x807
    x812 = x85 * (x5 * x785 - x60 * x804)
    x813 = x3 * x800
    x814 = x3 * x802 + x812 + x813
    x815 = x5 * x785
    x816 = x85 * (x5 * x794 - x60 * x815)
    x817 = x3 * x785
    x818 = x49 * x817
    x819 = x3 * x806 + x816 + x818
    x820 = x49 * x797
    x821 = x5 * x794
    x822 = x49 * x794
    x823 = x5 * x817 + x822
    x824 = x155 * x628 + x437
    x825 = x155 * x627 + x431
    x826 = x60 * x825
    x827 = x155 * x626 + x428
    x828 = x85 * (x824 - x826)
    x829 = x426 * x827 + x828
    x830 = x3 * x829 + x4 * (x3 * x824 - x3 * x826)
    x831 = x155 * x635 + x462
    x832 = x85 * (-x60 * x824 + x831)
    x833 = x426 * x825 + x832
    x834 = x155 * x658 + x467
    x835 = x85 * (-x60 * x831 + x834)
    x836 = x426 * x824 + x835
    x837 = x49 * x825
    x838 = x152 * x827 + x837
    x839 = x49 * x824
    x840 = x5 * x825
    x841 = x3 * x840 + x839
    x842 = x49 * x827
    x843 = x155 * x641 + x440
    x844 = x85 * (x5 * x825 - x595 * x827)
    x845 = x85 * (x5 * x824 - x60 * x840)
    x846 = x3 * x837 + x3 * x838 + x845
    x847 = x5 * x824
    x848 = x85 * (x5 * x831 - x60 * x847)
    x849 = x3 * x824
    x850 = x3 * x841 + x49 * x849 + x848
    x851 = x49 * x834
    x852 = x5 * x831
    x853 = x49 * x831
    x854 = x5 * x849 + x853
    x855 = x345 * x479 + x505
    x856 = x345 * x480 + x493
    x857 = x60 * x856
    x858 = x345 * x483 + x486
    x859 = x85 * (x855 - x857)
    x860 = x426 * x858 + x859
    x861 = x3 * x860 + x4 * (x3 * x855 - x3 * x857)
    x862 = x345 * x491 + x548
    x863 = x85 * (-x60 * x855 + x862)
    x864 = x426 * x856 + x863
    x865 = x345 * x503 + x554
    x866 = x85 * (-x60 * x862 + x865)
    x867 = x426 * x855 + x866
    x868 = x49 * x856
    x869 = x152 * x858 + x868
    x870 = x49 * x855
    x871 = x5 * x856
    x872 = x3 * x871 + x870
    x873 = x49 * x858
    x874 = x345 * x511 + x514
    x875 = x85 * (x5 * x856 - x595 * x858)
    x876 = x85 * (x5 * x855 - x60 * x871)
    x877 = x3 * x868 + x3 * x869 + x876
    x878 = x5 * x855
    x879 = x85 * (x5 * x862 - x60 * x878)
    x880 = x3 * x855
    x881 = x3 * x872 + x49 * x880 + x879
    x882 = x49 * x865
    x883 = x5 * x862
    x884 = x49 * x862
    x885 = x5 * x880 + x884
    x886 = x155 * x725
    x887 = x60 * x886
    x888 = x85 * (x155 * x726 - x887)
    x889 = x155 * x724
    x890 = x426 * x889 + x888
    x891 = x3 * x890 + x4 * (x155 * x3 * x726 - x3 * x887)
    x892 = x155 * x726
    x893 = x85 * (x155 * x734 - x60 * x892)
    x894 = x155 * x760 + x893
    x895 = x85 * (-x155 * x60 * x734 + x155 * x765)
    x896 = x426 * x892 + x895
    x897 = x155 * x731
    x898 = x155 * x749 + x897
    x899 = x155 * x754
    x900 = x155 * x755 + x899
    x901 = x49 * x889
    x902 = x85 * (x155 * x5 * x725 - x595 * x889)
    x903 = x5 * x886
    x904 = x85 * (x155 * x5 * x726 - x60 * x903)
    x905 = x155 * x752 + x3 * x898 + x904
    x906 = x155 * x739
    x907 = x85 * (x155 * x5 * x734 - x60 * x906)
    x908 = x155 * x783 + x3 * x900 + x907
    x909 = x155 * x765
    x910 = x155 * x757
    x911 = x155 * x758 + x910
    x912 = x155 * x779
    x913 = x251 * x726 + x41 * x504
    x914 = x251 * x725 + x41 * x492
    x915 = x60 * x914
    x916 = x251 * x724 + x41 * x485
    x917 = x426 * x916
    x918 = x85 * (x913 - x915)
    x919 = x917 + x918
    x920 = x3 * x919 + x4 * (x3 * x913 - x3 * x915)
    x921 = x426 * x914
    x922 = x251 * x734 + x41 * x547
    x923 = x85 * (-x60 * x913 + x922)
    x924 = x921 + x923
    x925 = x251 * x765 + x41 * x553
    x926 = x85 * (-x60 * x922 + x925)
    x927 = x426 * x913 + x926
    x928 = x49 * x914
    x929 = x152 * x916
    x930 = x928 + x929
    x931 = x49 * x913
    x932 = x5 * x914
    x933 = x3 * x932
    x934 = x931 + x933
    x935 = x49 * x916
    x936 = x251 * x741 + x41 * x513
    x937 = x152 * x936
    x938 = x85 * (x5 * x914 - x595 * x916)
    x939 = x3 * x935
    x940 = x85 * (x5 * x913 - x60 * x932)
    x941 = x3 * x928
    x942 = x3 * x930 + x940 + x941
    x943 = x5 * x913
    x944 = x85 * (x5 * x922 - x60 * x943)
    x945 = x3 * x913
    x946 = x49 * x945
    x947 = x3 * x934 + x944 + x946
    x948 = x49 * x925
    x949 = x5 * x922
    x950 = x49 * x922
    x951 = x5 * x945 + x950
    x952 = x12 * x581 + x155 * x786
    x953 = x12 * x574 + x155 * x789
    x954 = x60 * x953
    x955 = x3 * x954
    x956 = x12 * x587 + x155 * x808
    x957 = x426 * x956
    x958 = x85 * (x952 - x954)
    x959 = x426 * x953
    x960 = x12 * x611 + x155 * x785
    x961 = x85 * (-x60 * x952 + x960)
    x962 = x959 + x961
    x963 = x426 * x952
    x964 = x12 * x615 + x155 * x794
    x965 = x85 * (-x60 * x960 + x964)
    x966 = x963 + x965
    x967 = x155 * x825 + x41 * x636
    x968 = x155 * x827 + x41 * x629
    x969 = x60 * x968
    x970 = x155 * x843 + x41 * x642
    x971 = x85 * (x967 - x969)
    x972 = x155 * x824 + x41 * x659
    x973 = x85 * (-x60 * x967 + x972)
    x974 = x426 * x968 + x973
    x975 = x155 * x831 + x41 * x663
    x976 = x85 * (-x60 * x972 + x975)
    x977 = x426 * x967 + x976
    x978 = x155 * x856 + x683
    x979 = x155 * x858 + x677
    x980 = x60 * x979
    x981 = x155 * x874 + x688
    x982 = x85 * (x978 - x980)
    x983 = x155 * x855 + x707
    x984 = x85 * (-x60 * x978 + x983)
    x985 = x426 * x979 + x984
    x986 = x155 * x862 + x711
    x987 = x85 * (-x60 * x983 + x986)
    x988 = x426 * x978 + x987
    x989 = x345 * x725 + x736
    x990 = x345 * x724 + x728
    x991 = x60 * x990
    x992 = x345 * x741 + x743
    x993 = x85 * (x989 - x991)
    x994 = x345 * x726 + x767
    x995 = x85 * (-x60 * x989 + x994)
    x996 = x426 * x990 + x995
    x997 = x345 * x734 + x772
    x998 = x85 * (-x60 * x994 + x997)
    x999 = x426 * x989 + x998
    x1000 = x155 * x916
    x1001 = x1000 * x60
    x1002 = x85 * (-x1001 + x155 * x914)
    x1003 = x155 * x936
    x1004 = x155 * x914
    x1005 = x85 * (-x1004 * x60 + x155 * x913)
    x1006 = x1005 + x155 * x917
    x1007 = x155 * x913
    x1008 = x85 * (-x1007 * x60 + x155 * x922)
    x1009 = x1008 + x155 * x921
    x1010 = x12 * x735 + x251 * x914
    x1011 = x12 * x727 + x251 * x916
    x1012 = x1011 * x60
    x1013 = x12 * x742 + x251 * x936
    x1014 = x1013 * x426
    x1015 = x85 * (x1010 - x1012)
    x1016 = x1011 * x426
    x1017 = x12 * x766 + x251 * x913
    x1018 = x85 * (-x1010 * x60 + x1017)
    x1019 = x1016 + x1018
    x1020 = x1010 * x426
    x1021 = x12 * x771 + x251 * x922
    x1022 = x85 * (-x1017 * x60 + x1021)
    x1023 = x1020 + x1022
    x1024 = -x154 - A[1]
    x1025 = x1024 * x48
    x1026 = x1024 * x58
    x1027 = x1025 + x1026
    x1028 = x1024 * x64
    x1029 = x1024 * x71
    x1030 = x1028 + x1029 * x91
    x1031 = x1024 * x81
    x1032 = x1024 * x83
    x1033 = x1024 * x84
    x1034 = x4 * (x1024 * x63 - x1033)
    x1035 = x1024 * x87
    x1036 = x1024 * x89
    x1037 = x1035 + x1036
    x1038 = x1024 * x92
    x1039 = x4 * (x1024 * x71 - x1038)
    x1040 = x1024 * x94
    x1041 = x1024 * x96
    x1042 = x1040 + x1041
    x1043 = x1037 * x3 + 0.5 * x1039 + x1042 * x98
    x1044 = x100 * x1024 + x102 * x1024
    x1045 = x1024 * x62
    x1046 = x1024 * x104 + x1045 * x98
    x1047 = x4 * (-x1024 * x108 + x1024 * x62)
    x1048 = x1024 * x5
    x1049 = x111 * x113
    x1050 = x4 * (-x1024 * x121 * x60 + x1024 * x131)
    x1051 = x4 * (x1024 * x121 - x1024 * x60 * x63)
    x1052 = x1024 * x170
    x1053 = x1052 + x57
    x1054 = x1024 * x172
    x1055 = x101 + x1054
    x1056 = x1053 * x3 + x1055 * x98
    x1057 = x1024 * x180
    x1058 = x1057 + x72
    x1059 = x1024 * x183
    x1060 = x105 + x1059
    x1061 = x1058 * x3 + x1060 * x98
    x1062 = x1024 * x189
    x1063 = x1062 + x82
    x1064 = x1024 * x161
    x1065 = x1064 + x88
    x1066 = x4 * (-x1053 * x60 + x1058)
    x1067 = x1024 * x165
    x1068 = x1067 + x95
    x1069 = x1065 * x3 + x1068 * x116
    x1070 = x4 * (-x1055 * x60 + x1060)
    x1071 = x5 * x53
    x1072 = x1071 * x49
    x1073 = x1048 * x155
    x1074 = x1073 * x38
    x1075 = x1072 + x1074
    x1076 = x1075 * x153
    x1077 = x1068 * x3 + x1076
    x1078 = x1069 * x3 + 0.5 * x1070 + x1077 * x116
    x1079 = x1024 * x169 + x146
    x1080 = x1055 * x3 + x1079 * x116
    x1081 = x1024 * x179 + x142
    x1082 = x1060 * x3 + x1081 * x116
    x1083 = x4 * (-x1079 * x60 + x1081)
    x1084 = x49 * (x1024 * x216 + x151)
    x1085 = x1024 * x227 + x139
    x1086 = x4 * (x1024 * x232 - x1085 * x60 + x138)
    x1087 = x4 * (-x1058 * x60 + x1085)
    x1088 = x1024 * x266 + x1024 * x269
    x1089 = x1024 * x278
    x1090 = x1024 * x276 + x1089 * x98
    x1091 = x4 * (x1024 * x275 - x1024 * x288)
    x1092 = x1024 * x290 + x1024 * x292
    x1093 = x4 * (x1024 * x278 - x1024 * x294)
    x1094 = x1024 * x296 + x1048 * x18 * x298
    x1095 = x1092 * x3 + 0.5 * x1093 + x1094 * x116
    x1096 = x1024 * x303 + x1024 * x305
    x1097 = x1024 * x274
    x1098 = x1024 * x307 + x1097 * x116
    x1099 = x4 * (x1024 * x274 - x1024 * x310)
    x1100 = x1024 * x313
    x1101 = x4 * (-x1024 * x322 * x60 + x1024 * x328)
    x1102 = x4 * (-x1024 * x275 * x60 + x1024 * x322)
    x1103 = x1024 * x354
    x1104 = 2.0 * x173
    x1105 = x1103 + x1104
    x1106 = x1024 * x358
    x1107 = 2.0 * x208
    x1108 = x1106 + x1107
    x1109 = x1108 * x116
    x1110 = x1105 * x3 + x1109
    x1111 = x1024 * x364
    x1112 = x1111 + 2.0 * x184
    x1113 = x1024 * x368
    x1114 = x1113 + 2.0 * x212
    x1115 = x1114 * x116
    x1116 = x1112 * x3 + x1115
    x1117 = x1024 * x376
    x1118 = 2.0 * x191
    x1119 = x1117 + x1118
    x1120 = x1024 * x353
    x1121 = 2.0 * x196
    x1122 = x1120 + x1121
    x1123 = x1122 * x116
    x1124 = x4 * (-x1105 * x60 + x1112)
    x1125 = x1024 * x348
    x1126 = x1125 + x204
    x1127 = x1122 * x3 + x1126 * x153
    x1128 = x4 * (-x1108 * x60 + x1114)
    x1129 = x1024 * x346
    x1130 = x113 * x476
    x1131 = x1129 + x1130
    x1132 = x1131 * x49
    x1133 = x1126 * x3 + x1132
    x1134 = x1127 * x3 + 0.5 * x1128 + x1133 * x153
    x1135 = x1024 * x363 + x245
    x1136 = x1108 * x3 + x1135 * x153
    x1137 = x1024 * x395 + x240
    x1138 = x1114 * x3 + x1137 * x153
    x1139 = x4 * (-x1135 * x60 + x1137)
    x1140 = x1024 * x402 + 2.0 * x237
    x1141 = x4 * (x1024 * x408 - x1140 * x60 + 2.0 * x236)
    x1142 = x4 * (-x1112 * x60 + x1140)
    x1143 = x1024 * x430 + x268
    x1144 = x1024 * x432 + x304
    x1145 = x1143 * x3 + x1144 * x116
    x1146 = x1024 * x435 + x279
    x1147 = x1024 * x438 + x308
    x1148 = x1146 * x3 + x1147 * x116
    x1149 = x1024 * x441 + x286
    x1150 = x1024 * x429 + x291
    x1151 = x4 * (-x1143 * x60 + x1146)
    x1152 = x1073 * x449 + x251 * x38 * x49 * x5
    x1153 = x1152 * x153
    x1154 = x1150 * x3 + x1153
    x1155 = x4 * (-x1144 * x60 + x1147)
    x1156 = x1024 * x447 + x313
    x1157 = x1156 * x49
    x1158 = x1152 * x3 + x1157
    x1159 = x1154 * x3 + 0.5 * x1155 + x1158 * x153
    x1160 = x1071 * x251 * x49 + x1073 * x314
    x1161 = x1160 * x153
    x1162 = x1144 * x3 + x1161
    x1163 = x1073 * x312 + x251 * x49 * x5 * x68
    x1164 = x1163 * x153
    x1165 = x1147 * x3 + x1164
    x1166 = x4 * (-x1160 * x60 + x1163)
    x1167 = x1024 * x459 + x333
    x1168 = x4 * (x1024 * x464 - x1167 * x60 + x332)
    x1169 = x4 * (-x1146 * x60 + x1167)
    x1170 = x1024 * x489 + x1024 * x496
    x1171 = x1024 * x506
    x1172 = x1024 * x501 + x116 * x1171
    x1173 = x4 * (x1024 * x500 - x1024 * x519)
    x1174 = x1024 * x521 + x1024 * x522
    x1175 = x4 * (x1024 * x506 - x1024 * x524)
    x1176 = x1024 * x526
    x1177 = x1024 * x527 + x1176
    x1178 = x1174 * x3 + 0.5 * x1175 + x1177 * x153
    x1179 = x1024 * x530 + x1024 * x531
    x1180 = x1024 * x534
    x1181 = x1024 * x533 + x1180 * x153
    x1182 = x4 * (x1024 * x491 * x5 - x1024 * x536)
    x1183 = x4 * (-x1024 * x541 * x60 + x1024 * x550)
    x1184 = x4 * (-x1024 * x500 * x60 + x1024 * x541)
    x1185 = x1024 * x575
    x1186 = x1185 + x360
    x1187 = x1024 * x572
    x1188 = x1187 * x5
    x1189 = x116 * x363
    x1190 = x1188 + x1189
    x1191 = x1186 * x3 + x1190 * x153
    x1192 = x1024 * x582
    x1193 = x1192 + x370
    x1194 = x1024 * x584
    x1195 = x116 * x395 + x1194
    x1196 = x1193 * x3 + x1195 * x153
    x1197 = x1024 * x588
    x1198 = x1197 + x379
    x1199 = x1048 * x571
    x1200 = x116 * x348
    x1201 = x1199 + x1200
    x1202 = x4 * (-x1186 * x60 + x1193)
    x1203 = 3.0 * x387
    x1204 = x1187 + x1203
    x1205 = x1204 * x49
    x1206 = x1201 * x3 + x1205
    x1207 = x4 * (-x1190 * x60 + x1195)
    x1208 = x1205 * x3 + x1206 * x3 + 0.5 * x1207
    x1209 = x1024 * x573 + 3.0 * x423
    x1210 = x1209 * x49
    x1211 = x1190 * x3 + x1210
    x1212 = x1024 * x580 + 3.0 * x419
    x1213 = x1212 * x49
    x1214 = x1195 * x3 + x1213
    x1215 = x4 * (-x1209 * x60 + x1212)
    x1216 = x1024 * x612 + x416
    x1217 = x4 * (x1024 * x616 - x1216 * x60 + x414)
    x1218 = x4 * (-x1193 * x60 + x1216)
    x1219 = x153 * x432
    x1220 = x1024 * x630 + x1219
    x1221 = x1024 * x627
    x1222 = x1221 * x5 + x452
    x1223 = x1220 * x3 + x1222 * x153
    x1224 = x153 * x438
    x1225 = x1024 * x637 + x1224
    x1226 = x1024 * x638 + x454
    x1227 = x1225 * x3 + x1226 * x153
    x1228 = x153 * x429
    x1229 = x1024 * x643 + x1228
    x1230 = x1048 * x626 + x443
    x1231 = x4 * (-x1220 * x60 + x1225)
    x1232 = x155 * x298
    x1233 = x1232 * x18
    x1234 = x1221 + x1233
    x1235 = x1234 * x49
    x1236 = x1230 * x3 + x1235
    x1237 = x4 * (-x1222 * x60 + x1226)
    x1238 = x1235 * x3 + x1236 * x3 + 0.5 * x1237
    x1239 = x1130 * x251
    x1240 = x1024 * x628 + x1239
    x1241 = x1240 * x49
    x1242 = x1222 * x3 + x1241
    x1243 = x1232 * x36
    x1244 = x1024 * x635 + x1243
    x1245 = x1244 * x49
    x1246 = x1226 * x3 + x1245
    x1247 = x4 * (-x1240 * x60 + x1244)
    x1248 = x153 * x468
    x1249 = x153 * x463
    x1250 = x1024 * x660 + x1249
    x1251 = x4 * (x1024 * x664 + x1248 - x1250 * x60)
    x1252 = x4 * (-x1225 * x60 + x1250)
    x1253 = x1024 * x678 + x495
    x1254 = x49 * x499
    x1255 = x1024 * x695 + x1254
    x1256 = x1255 * x153
    x1257 = x1253 * x3 + x1256
    x1258 = x1024 * x684 + x507
    x1259 = x1024 * x685 + x49 * x534
    x1260 = x1259 * x153
    x1261 = x1258 * x3 + x1260
    x1262 = x1024 * x689 + x517
    x1263 = x481 * x49
    x1264 = x1073 * x483 + x1263
    x1265 = x1264 * x153
    x1266 = x4 * (-x1253 * x60 + x1258)
    x1267 = x1024 * x676 + x526
    x1268 = x1267 * x49
    x1269 = x1264 * x3 + x1268
    x1270 = x4 * (-x1255 * x60 + x1259)
    x1271 = x1268 * x3 + x1269 * x3 + 0.5 * x1270
    x1272 = x1024 * x682 + x566
    x1273 = x1272 * x49
    x1274 = x1255 * x3 + x1273
    x1275 = x1024 * x706 + x562
    x1276 = x1275 * x49
    x1277 = x1259 * x3 + x1276
    x1278 = x4 * (-x1272 * x60 + x1275)
    x1279 = x1024 * x708 + x558
    x1280 = x4 * (x1024 * x712 - x1279 * x60 + x556)
    x1281 = x4 * (-x1258 * x60 + x1279)
    x1282 = x1048 * x731
    x1283 = x1024 * x730 + 2.0 * x1282
    x1284 = x1024 * x739
    x1285 = x1024 * x738 + x1284 * x153
    x1286 = x1048 * x724
    x1287 = x4 * (x1024 * x737 - x1024 * x747)
    x1288 = x1024 * x731
    x1289 = x1024 * x749 + x1288
    x1290 = x1048 * x60
    x1291 = x4 * (x1024 * x5 * x726 - x1290 * x725)
    x1292 = x1024 * x752 + x1289 * x3 + 0.5 * x1291
    x1293 = x1024 * x754
    x1294 = x1024 * x755 + x1293
    x1295 = x1024 * x757
    x1296 = x1024 * x758 + x1295
    x1297 = x4 * (x1024 * x734 - x1024 * x761)
    x1298 = x4 * (-x1024 * x60 * x768 + x1024 * x773)
    x1299 = x4 * (-x1024 * x60 * x737 + x1024 * x768)
    x1300 = x1024 * x785
    x1301 = 4.0 * x602
    x1302 = x1300 + x1301
    x1303 = x1024 * x786
    x1304 = 4.0 * x599
    x1305 = x1303 + x1304
    x1306 = x1305 * x60
    x1307 = x1024 * x789
    x1308 = 4.0 * x577
    x1309 = x1307 + x1308
    x1310 = x4 * (x1302 - x1306)
    x1311 = x1309 * x426 + 0.5 * x1310
    x1312 = x1305 * x49
    x1313 = x1307 * x5
    x1314 = x1308 * x5 + x1313
    x1315 = x1312 + x1314 * x3
    x1316 = x1302 * x49
    x1317 = x1024 * x804
    x1318 = x1317 + x584 * x98
    x1319 = x1316 + x1318 * x3
    x1320 = x1309 * x49
    x1321 = x1048 * x808
    x1322 = x1321 + x590 * x98
    x1323 = x4 * (-x1314 * x60 + x1318)
    x1324 = x1024 * x815 + x1301 * x5
    x1325 = x4 * (x1024 * x821 - x1324 * x60 + x621 * x98)
    x1326 = x4 * (-x1318 * x60 + x1324)
    x1327 = 3.0 * x652
    x1328 = x1024 * x824 + x1327
    x1329 = x1024 * x825 + 3.0 * x650
    x1330 = x1329 * x60
    x1331 = x1024 * x827
    x1332 = 3.0 * x631
    x1333 = x1331 + x1332
    x1334 = x4 * (x1328 - x1330)
    x1335 = x1333 * x426 + 0.5 * x1334
    x1336 = x1329 * x49
    x1337 = x1331 * x5 + x1332 * x5
    x1338 = x1336 + x1337 * x3
    x1339 = x1328 * x49
    x1340 = x1024 * x840 + x116 * x638
    x1341 = x1339 + x1340 * x3
    x1342 = x1333 * x49
    x1343 = x1048 * x843 + x116 * x644
    x1344 = x4 * (-x1337 * x60 + x1340)
    x1345 = x1024 * x847 + x1327 * x5
    x1346 = x4 * (x1024 * x852 + x116 * x670 - x1345 * x60)
    x1347 = x4 * (-x1340 * x60 + x1345)
    x1348 = x1024 * x855 + 2.0 * x700
    x1349 = x1024 * x856 + 2.0 * x698
    x1350 = x1349 * x60
    x1351 = x1024 * x858
    x1352 = x1351 + x153 * x676
    x1353 = x4 * (x1348 - x1350)
    x1354 = x1352 * x426 + 0.5 * x1353
    x1355 = x1349 * x49
    x1356 = x1351 * x5 + x679
    x1357 = x1355 + x1356 * x3
    x1358 = x1348 * x49
    x1359 = x1024 * x871 + x686
    x1360 = x1358 + x1359 * x3
    x1361 = x1352 * x49
    x1362 = x1048 * x874 + x691
    x1363 = x4 * (-x1356 * x60 + x1359)
    x1364 = x1024 * x878 + x716
    x1365 = x4 * (x1024 * x883 - x1364 * x60 + x719)
    x1366 = x4 * (-x1359 * x60 + x1364)
    x1367 = x1024 * x892 + x757
    x1368 = x1024 * x886 + x754
    x1369 = x1368 * x60
    x1370 = x1024 * x889 + x731
    x1371 = x4 * (x1367 - x1369)
    x1372 = x1370 * x426 + 0.5 * x1371
    x1373 = x1368 * x49
    x1374 = x1048 * x889 + x732
    x1375 = x1373 + x1374 * x3
    x1376 = x1367 * x49
    x1377 = x1024 * x903 + x49 * x739
    x1378 = x1376 + x1377 * x3
    x1379 = x1370 * x49
    x1380 = x1073 * x741 + x49 * x746
    x1381 = x4 * (-x1374 * x60 + x1377)
    x1382 = x1024 * x906 + x776
    x1383 = x4 * (x1024 * x912 - x1382 * x60 + x49 * x778)
    x1384 = x4 * (-x1377 * x60 + x1382)
    x1385 = x1024 * x3
    x1386 = x4 * (x1024 * x913 - x1024 * x915)
    x1387 = x1024 * x917 + 0.5 * x1386
    x1388 = x1024 * x928
    x1389 = x1024 * x929 + x1388
    x1390 = x1024 * x931
    x1391 = x1024 * x933 + x1390
    x1392 = x1024 * x935
    x1393 = x4 * (x1024 * x5 * x914 - x1290 * x916)
    x1394 = x4 * (x1024 * x5 * x922 - x1024 * x60 * x943)
    x1395 = x4 * (x1024 * x5 * x913 - x1024 * x60 * x932)
    x1396 = x1024 * x952
    x1397 = 5.0 * x803
    x1398 = x1396 + x1397
    x1399 = x1024 * x953
    x1400 = 5.0 * x800
    x1401 = x1399 + x1400
    x1402 = x1401 * x60
    x1403 = x1024 * x956
    x1404 = 5.0 * x807
    x1405 = x1403 + x1404
    x1406 = x4 * (x1398 - x1402)
    x1407 = x1024 * x960 + 5.0 * x822
    x1408 = x4 * (x1024 * x964 - x1407 * x60 + 5.0 * x820)
    x1409 = x4 * (-x1398 * x60 + x1407)
    x1410 = x1024 * x967 + 4.0 * x839
    x1411 = x1024 * x968 + 4.0 * x837
    x1412 = x1411 * x60
    x1413 = x1024 * x970 + 4.0 * x842
    x1414 = x4 * (x1410 - x1412)
    x1415 = x1024 * x972 + 4.0 * x853
    x1416 = x4 * (x1024 * x975 - x1415 * x60 + 4.0 * x851)
    x1417 = x4 * (-x1410 * x60 + x1415)
    x1418 = 3.0 * x870
    x1419 = x1024 * x978 + x1418
    x1420 = 3.0 * x868
    x1421 = x1024 * x979 + x1420
    x1422 = x1421 * x60
    x1423 = 3.0 * x873
    x1424 = x1024 * x981 + x1423
    x1425 = x4 * (x1419 - x1422)
    x1426 = 3.0 * x882
    x1427 = 3.0 * x884
    x1428 = x1024 * x983 + x1427
    x1429 = x4 * (x1024 * x986 + x1426 - x1428 * x60)
    x1430 = x4 * (-x1419 * x60 + x1428)
    x1431 = x1024 * x989 + 2.0 * x899
    x1432 = x1024 * x990 + 2.0 * x897
    x1433 = x1432 * x60
    x1434 = x1024 * x992 + x153 * x889
    x1435 = x4 * (x1431 - x1433)
    x1436 = x1024 * x994 + 2.0 * x910
    x1437 = x4 * (x1024 * x997 - x1436 * x60 + x153 * x909)
    x1438 = x4 * (-x1431 * x60 + x1436)
    x1439 = x1004 * x1024 + x931
    x1440 = x1000 * x1024 + x928
    x1441 = x1440 * x60
    x1442 = x1003 * x1024 + x935
    x1443 = x4 * (x1439 - x1441)
    x1444 = x155 * x922
    x1445 = x1007 * x1024 + x950
    x1446 = x4 * (x1024 * x1444 - x1445 * x60 + x948)
    x1447 = x4 * (-x1439 * x60 + x1445)
    x1448 = x4 * (x1010 * x1024 - x1012 * x1024)
    x1449 = x4 * (-x1017 * x1024 * x60 + x1021 * x1024)
    x1450 = x4 * (-x1010 * x1024 * x60 + x1017 * x1024)
    x1451 = -x250 - A[2]
    x1452 = x1451 * x48 + x1451 * x58
    x1453 = x1451 * x64 + x1451 * x73
    x1454 = x4 * (x1451 * x63 - x1451 * x84)
    x1455 = 0.5 * x1454
    x1456 = x1451 * x87 + x1451 * x89
    x1457 = x4 * (x1451 * x71 - x1451 * x92)
    x1458 = 0.5 * x1457
    x1459 = x1451 * x94 + x1451 * x96
    x1460 = x1456 * x3 + x1458 + x1459 * x98
    x1461 = x100 * x1451 + x102 * x1451
    x1462 = x104 * x1451 + x106 * x1451
    x1463 = x4 * (-x108 * x1451 + x1451 * x62)
    x1464 = 0.5 * x1463
    x1465 = x1451 * x5
    x1466 = x4 * (-x121 * x1451 * x60 + x131 * x1451)
    x1467 = 0.5 * x1466
    x1468 = x1451 * x63
    x1469 = x4 * (x121 * x1451 - x1468 * x60)
    x1470 = 0.5 * x1469
    x1471 = x1451 * x171 + x1451 * x174
    x1472 = x1451 * x183
    x1473 = x1451 * x181 + x1472 * x98
    x1474 = x4 * (x1451 * x180 - x1451 * x193)
    x1475 = 0.5 * x1474
    x1476 = x1451 * x195 + x1451 * x197
    x1477 = x4 * (x1451 * x183 - x1451 * x199)
    x1478 = 0.5 * x1477
    x1479 = x1465 * x155
    x1480 = x11 * x113 * x1479 * x18
    x1481 = x1451 * x201 + x1480
    x1482 = x116 * x1481 + x1476 * x3 + x1478
    x1483 = x1451 * x207 + x1451 * x209
    x1484 = x1451 * x179
    x1485 = x116 * x1484 + x1451 * x211
    x1486 = x4 * (x1451 * x179 - x1451 * x214)
    x1487 = 0.5 * x1486
    x1488 = x1451 * x217
    x1489 = x4 * (-x1451 * x227 * x60 + x1451 * x232)
    x1490 = 0.5 * x1489
    x1491 = x4 * (-x1451 * x180 * x60 + x1451 * x227)
    x1492 = 0.5 * x1491
    x1493 = x1451 * x265 + x57
    x1494 = x1493 * x3
    x1495 = x101 + x1451 * x267
    x1496 = x1495 * x49
    x1497 = 4.0 * x1496
    x1498 = x1494 + x1497
    x1499 = x1451 * x275 + x72
    x1500 = x1499 * x3
    x1501 = x105 + x1451 * x278
    x1502 = x1501 * x49
    x1503 = x1500 + 4.0 * x1502
    x1504 = x1451 * x284 + x82
    x1505 = x1504 * x3
    x1506 = x1451 * x256 + x88
    x1507 = x1506 * x49
    x1508 = 4.0 * x1507
    x1509 = x1493 * x60
    x1510 = x4 * (x1499 - x1509)
    x1511 = 0.5 * x1510
    x1512 = x1506 * x3
    x1513 = x1451 * x260 + x95
    x1514 = x1513 * x49
    x1515 = 3.0 * x1514
    x1516 = x1512 + x1515
    x1517 = x1495 * x60
    x1518 = x4 * (x1501 - x1517)
    x1519 = 0.5 * x1518
    x1520 = x1513 * x3
    x1521 = x1072 + x1465 * x314
    x1522 = x1521 * x49
    x1523 = 2.0 * x1522
    x1524 = x1520 + x1523
    x1525 = x116 * x1524 + x1516 * x3 + x1519
    x1526 = x1451 * x264 + x146
    x1527 = x1526 * x49
    x1528 = x1495 * x3 + 3.0 * x1527
    x1529 = x142 + x1451 * x274
    x1530 = x1529 * x49
    x1531 = x1501 * x3 + 3.0 * x1530
    x1532 = x4 * (-x1526 * x60 + x1529)
    x1533 = 0.5 * x1532
    x1534 = x49 * (x1451 * x312 + x151)
    x1535 = x139 + x1451 * x322
    x1536 = x4 * (x138 + x1451 * x328 - x1535 * x60)
    x1537 = 0.5 * x1536
    x1538 = x4 * (-x1499 * x60 + x1535)
    x1539 = 0.5 * x1538
    x1540 = x1451 * x360
    x1541 = x1451 * x355 + x1540
    x1542 = x1451 * x368
    x1543 = x116 * x1542
    x1544 = x1451 * x365 + x1543
    x1545 = x1451 * x379
    x1546 = x4 * (x1451 * x364 - x1451 * x380)
    x1547 = 0.5 * x1546
    x1548 = x1451 * x382 + x1451 * x383
    x1549 = x4 * (x1451 * x368 - x1451 * x385)
    x1550 = 0.5 * x1549
    x1551 = x1451 * x387
    x1552 = x1451 * x388 + x1551
    x1553 = x153 * x1552 + x1548 * x3 + x1550
    x1554 = x1451 * x391 + x1451 * x392
    x1555 = x1451 * x395
    x1556 = x1451 * x394 + x153 * x1555
    x1557 = x4 * (x1451 * x356 * x5 - x1451 * x397)
    x1558 = 0.5 * x1557
    x1559 = x4 * (-x1451 * x402 * x60 + x1451 * x408)
    x1560 = 0.5 * x1559
    x1561 = x4 * (-x1451 * x364 * x60 + x1451 * x402)
    x1562 = 0.5 * x1561
    x1563 = x1451 * x430 + x173
    x1564 = x1451 * x432 + x208
    x1565 = x116 * x1564 + x1563 * x3
    x1566 = x1451 * x435 + x184
    x1567 = x1451 * x438 + x212
    x1568 = x116 * x1567 + x1566 * x3
    x1569 = x1451 * x441 + x191
    x1570 = x1451 * x429 + x196
    x1571 = x4 * (-x1563 * x60 + x1566)
    x1572 = 0.5 * x1571
    x1573 = x1479 * x449 + x156 * x38 * x49
    x1574 = x153 * x1573
    x1575 = x1570 * x3 + x1574
    x1576 = x4 * (-x1564 * x60 + x1567)
    x1577 = 0.5 * x1576
    x1578 = x1451 * x447 + x217
    x1579 = x1578 * x49
    x1580 = x1573 * x3 + x1579
    x1581 = x153 * x1580 + x1575 * x3 + x1577
    x1582 = x1479 * x314 + x156 * x49 * x53
    x1583 = x153 * x1582
    x1584 = x1564 * x3 + x1583
    x1585 = x1479 * x312 + x151 * x156
    x1586 = x153 * x1585
    x1587 = x1567 * x3 + x1586
    x1588 = x4 * (-x1582 * x60 + x1585)
    x1589 = 0.5 * x1588
    x1590 = x1451 * x459 + x237
    x1591 = x4 * (x1451 * x464 - x1590 * x60 + x236)
    x1592 = 0.5 * x1591
    x1593 = x4 * (-x1566 * x60 + x1590)
    x1594 = 0.5 * x1593
    x1595 = x1451 * x488 + 2.0 * x268
    x1596 = x1595 * x3
    x1597 = x1451 * x494 + 2.0 * x304
    x1598 = x1597 * x49
    x1599 = 3.0 * x1598
    x1600 = x1596 + x1599
    x1601 = x1451 * x500 + 2.0 * x279
    x1602 = x1601 * x3
    x1603 = x1451 * x506 + 2.0 * x308
    x1604 = x1603 * x49
    x1605 = 3.0 * x1604
    x1606 = x1602 + x1605
    x1607 = x1451 * x515 + 2.0 * x286
    x1608 = x1607 * x3
    x1609 = x1451 * x487 + 2.0 * x291
    x1610 = x1609 * x49
    x1611 = 3.0 * x1610
    x1612 = x1595 * x60
    x1613 = x4 * (x1601 - x1612)
    x1614 = 0.5 * x1613
    x1615 = x1609 * x3
    x1616 = x1451 * x481
    x1617 = x1616 + x300
    x1618 = x1617 * x49
    x1619 = 2.0 * x1618
    x1620 = x1615 + x1619
    x1621 = x1597 * x60
    x1622 = x4 * (x1603 - x1621)
    x1623 = 0.5 * x1622
    x1624 = x111 * x297 + x1451 * x479
    x1625 = x1624 * x49
    x1626 = x1617 * x3
    x1627 = x1625 + x1626
    x1628 = x153 * x1627 + x1620 * x3 + x1623
    x1629 = x1451 * x499 + x340
    x1630 = x1629 * x49
    x1631 = x1597 * x3 + 2.0 * x1630
    x1632 = x1451 * x534 + x336
    x1633 = x1632 * x49
    x1634 = x1603 * x3 + 2.0 * x1633
    x1635 = x4 * (-x1629 * x60 + x1632)
    x1636 = 0.5 * x1635
    x1637 = x1451 * x541 + 2.0 * x333
    x1638 = x4 * (x1451 * x550 - x1637 * x60 + 2.0 * x332)
    x1639 = 0.5 * x1638
    x1640 = x4 * (-x1601 * x60 + x1637)
    x1641 = 0.5 * x1640
    x1642 = x1451 * x577
    x1643 = x1642 * x5
    x1644 = x1451 * x576 + 2.0 * x1643
    x1645 = x1451 * x584
    x1646 = x1451 * x583 + x153 * x1645
    x1647 = x1465 * x571
    x1648 = x4 * (x1451 * x582 - x1451 * x591)
    x1649 = 0.5 * x1648
    x1650 = x1451 * x593 + x1642
    x1651 = x1465 * x60
    x1652 = x4 * (x1451 * x5 * x573 - x1651 * x572)
    x1653 = 0.5 * x1652
    x1654 = x1451 * x597 + x1650 * x3 + x1653
    x1655 = x1451 * x599
    x1656 = x1451 * x600 + x1655
    x1657 = x1451 * x602
    x1658 = x1451 * x603 + x1657
    x1659 = x4 * (x1451 * x580 - x1451 * x606)
    x1660 = 0.5 * x1659
    x1661 = x4 * (-x1451 * x60 * x612 + x1451 * x616)
    x1662 = 0.5 * x1661
    x1663 = x4 * (-x1451 * x582 * x60 + x1451 * x612)
    x1664 = 0.5 * x1663
    x1665 = x1451 * x630 + x359
    x1666 = x363 * x49
    x1667 = x1451 * x627
    x1668 = x1666 + x1667 * x5
    x1669 = x153 * x1668
    x1670 = x1665 * x3 + x1669
    x1671 = x1451 * x637 + x369
    x1672 = x1451 * x638 + x395 * x49
    x1673 = x153 * x1672
    x1674 = x1671 * x3 + x1673
    x1675 = x1451 * x643 + x378
    x1676 = x348 * x49
    x1677 = x1465 * x626 + x1676
    x1678 = x153 * x1677
    x1679 = x4 * (-x1665 * x60 + x1671)
    x1680 = 0.5 * x1679
    x1681 = x1667 + x387
    x1682 = x1681 * x49
    x1683 = x1677 * x3 + x1682
    x1684 = x4 * (-x1668 * x60 + x1672)
    x1685 = 0.5 * x1684
    x1686 = x1682 * x3 + x1683 * x3 + x1685
    x1687 = x1451 * x628 + x423
    x1688 = x1687 * x49
    x1689 = x1668 * x3 + x1688
    x1690 = x1451 * x635 + x419
    x1691 = x1690 * x49
    x1692 = x1672 * x3 + x1691
    x1693 = x4 * (-x1687 * x60 + x1690)
    x1694 = 0.5 * x1693
    x1695 = x1451 * x660 + x415
    x1696 = x4 * (x1451 * x664 - x1695 * x60 + x413)
    x1697 = 0.5 * x1696
    x1698 = x4 * (-x1671 * x60 + x1695)
    x1699 = 0.5 * x1698
    x1700 = x1219 + x1451 * x678
    x1701 = x155 * x1616 + x452
    x1702 = x153 * x1701
    x1703 = x1700 * x3 + x1702
    x1704 = x1224 + x1451 * x684
    x1705 = x1451 * x685 + x454
    x1706 = x153 * x1705
    x1707 = x1704 * x3 + x1706
    x1708 = x1228 + x1451 * x689
    x1709 = x1479 * x483 + x443
    x1710 = x153 * x1709
    x1711 = x4 * (-x1700 * x60 + x1704)
    x1712 = 0.5 * x1711
    x1713 = x1233 + x1451 * x676
    x1714 = x1713 * x49
    x1715 = x1709 * x3 + x1714
    x1716 = x4 * (-x1701 * x60 + x1705)
    x1717 = 0.5 * x1716
    x1718 = x1714 * x3 + x1715 * x3 + x1717
    x1719 = x1239 + x1451 * x682
    x1720 = x1719 * x49
    x1721 = x1701 * x3 + x1720
    x1722 = x1243 + x1451 * x706
    x1723 = x1722 * x49
    x1724 = x1705 * x3 + x1723
    x1725 = x4 * (-x1719 * x60 + x1722)
    x1726 = 0.5 * x1725
    x1727 = x1249 + x1451 * x708
    x1728 = x4 * (x1248 + x1451 * x712 - x1727 * x60)
    x1729 = 0.5 * x1728
    x1730 = x4 * (-x1704 * x60 + x1727)
    x1731 = 0.5 * x1730
    x1732 = x1451 * x729 + x496
    x1733 = x1732 * x3
    x1734 = x1451 * x725
    x1735 = x1734 * x5
    x1736 = x116 * x499 + x1735
    x1737 = x1736 * x49
    x1738 = 2.0 * x1737
    x1739 = x1733 + x1738
    x1740 = x1451 * x737 + x508
    x1741 = x1740 * x3
    x1742 = x116 * x534 + x1451 * x739
    x1743 = x1742 * x49
    x1744 = x1741 + 2.0 * x1743
    x1745 = x1451 * x744 + x518
    x1746 = x1745 * x3
    x1747 = x116 * x481 + x1451 * x746
    x1748 = x1747 * x49
    x1749 = 2.0 * x1748
    x1750 = x1732 * x60
    x1751 = x4 * (x1740 - x1750)
    x1752 = 0.5 * x1751
    x1753 = x1734 + 3.0 * x526
    x1754 = x1753 * x49
    x1755 = x1747 * x3
    x1756 = x1754 + x1755
    x1757 = x1736 * x60
    x1758 = x4 * (x1742 - x1757)
    x1759 = 0.5 * x1758
    x1760 = x1754 * x3
    x1761 = x1756 * x3 + x1759 + x1760
    x1762 = x1451 * x726 + 3.0 * x566
    x1763 = x1762 * x49
    x1764 = x1736 * x3 + x1763
    x1765 = x1451 * x734 + 3.0 * x562
    x1766 = x1765 * x49
    x1767 = x1742 * x3 + x1766
    x1768 = x4 * (-x1762 * x60 + x1765)
    x1769 = 0.5 * x1768
    x1770 = x1451 * x768 + x559
    x1771 = x4 * (x1451 * x773 - x1770 * x60 + x557)
    x1772 = 0.5 * x1771
    x1773 = x4 * (-x1740 * x60 + x1770)
    x1774 = 0.5 * x1773
    x1775 = x4 * (x1451 * x785 - x1451 * x787)
    x1776 = 0.5 * x1775
    x1777 = x1451 * x790 + x1776
    x1778 = x1451 * x800
    x1779 = x1451 * x801 + x1778
    x1780 = x1451 * x803
    x1781 = x1451 * x805 + x1780
    x1782 = x1451 * x807
    x1783 = x4 * (x1451 * x5 * x786 - x1651 * x789)
    x1784 = 0.5 * x1783
    x1785 = x4 * (x1451 * x5 * x794 - x1451 * x60 * x815)
    x1786 = 0.5 * x1785
    x1787 = x4 * (x1451 * x5 * x785 - x1451 * x60 * x804)
    x1788 = 0.5 * x1787
    x1789 = x1451 * x824 + x602
    x1790 = x1451 * x825 + x599
    x1791 = x1790 * x60
    x1792 = x1451 * x827
    x1793 = x1792 + x577
    x1794 = x4 * (x1789 - x1791)
    x1795 = 0.5 * x1794
    x1796 = x1793 * x426 + x1795
    x1797 = x1790 * x49
    x1798 = x1792 * x5 + x578
    x1799 = x1797 + x1798 * x3
    x1800 = x1789 * x49
    x1801 = x1451 * x840 + x49 * x584
    x1802 = x1800 + x1801 * x3
    x1803 = x1793 * x49
    x1804 = x1465 * x843 + x49 * x590
    x1805 = x4 * (-x1798 * x60 + x1801)
    x1806 = 0.5 * x1805
    x1807 = x1451 * x847 + x619
    x1808 = x4 * (x1451 * x852 - x1807 * x60 + x49 * x621)
    x1809 = 0.5 * x1808
    x1810 = x4 * (-x1801 * x60 + x1807)
    x1811 = 0.5 * x1810
    x1812 = x1451 * x855 + x667
    x1813 = x1451 * x856 + 2.0 * x650
    x1814 = x1813 * x60
    x1815 = x1451 * x858
    x1816 = x1815 + x632
    x1817 = x4 * (x1812 - x1814)
    x1818 = 0.5 * x1817
    x1819 = x1816 * x426 + x1818
    x1820 = x1813 * x49
    x1821 = x1815 * x5 + x633
    x1822 = x1820 + x1821 * x3
    x1823 = x1812 * x49
    x1824 = x1451 * x871 + x639
    x1825 = x1823 + x1824 * x3
    x1826 = x1816 * x49
    x1827 = x1465 * x874 + x645
    x1828 = x4 * (-x1821 * x60 + x1824)
    x1829 = 0.5 * x1828
    x1830 = x1451 * x878 + x668
    x1831 = x4 * (x1451 * x883 - x1830 * x60 + x671)
    x1832 = 0.5 * x1831
    x1833 = x4 * (-x1824 * x60 + x1830)
    x1834 = 0.5 * x1833
    x1835 = x1451 * x892 + 3.0 * x700
    x1836 = x155 * x1734 + 3.0 * x698
    x1837 = x1836 * x60
    x1838 = x116 * x676 + x1451 * x889
    x1839 = x4 * (x1835 - x1837)
    x1840 = 0.5 * x1839
    x1841 = x1838 * x426 + x1840
    x1842 = x1836 * x49
    x1843 = x116 * x695 + x1465 * x889
    x1844 = x1842 + x1843 * x3
    x1845 = x1835 * x49
    x1846 = x116 * x685 + x155 * x1735
    x1847 = x1845 + x1846 * x3
    x1848 = x1838 * x49
    x1849 = x116 * x690 + x1479 * x741
    x1850 = x4 * (-x1843 * x60 + x1846)
    x1851 = 0.5 * x1850
    x1852 = x116 * x715 + x1451 * x906
    x1853 = x4 * (x116 * x718 + x1451 * x912 - x1852 * x60)
    x1854 = 0.5 * x1853
    x1855 = x4 * (-x1846 * x60 + x1852)
    x1856 = 0.5 * x1855
    x1857 = x1451 * x913 + 4.0 * x757
    x1858 = x1451 * x914 + 4.0 * x754
    x1859 = x1858 * x60
    x1860 = x1451 * x916
    x1861 = x1860 + 4.0 * x731
    x1862 = x1861 * x426
    x1863 = x4 * (x1857 - x1859)
    x1864 = 0.5 * x1863
    x1865 = x1862 + x1864
    x1866 = x1858 * x49
    x1867 = x1860 * x5 + 4.0 * x732
    x1868 = x1867 * x3
    x1869 = x1866 + x1868
    x1870 = x1857 * x49
    x1871 = x1451 * x932 + x739 * x98
    x1872 = x1871 * x3
    x1873 = x1870 + x1872
    x1874 = x1861 * x49
    x1875 = x1465 * x936 + x746 * x98
    x1876 = x1875 * x3
    x1877 = x1867 * x60
    x1878 = x4 * (x1871 - x1877)
    x1879 = 0.5 * x1878
    x1880 = x1874 * x3
    x1881 = x1451 * x943 + 4.0 * x776
    x1882 = x4 * (x1451 * x949 - x1881 * x60 + x778 * x98)
    x1883 = 0.5 * x1882
    x1884 = x4 * (-x1871 * x60 + x1881)
    x1885 = 0.5 * x1884
    x1886 = x4 * (x1451 * x952 - x1451 * x954)
    x1887 = 0.5 * x1886
    x1888 = x4 * (-x1451 * x60 * x960 + x1451 * x964)
    x1889 = 0.5 * x1888
    x1890 = x4 * (-x1451 * x60 * x952 + x1451 * x960)
    x1891 = 0.5 * x1890
    x1892 = x1451 * x967 + x803
    x1893 = x1451 * x968 + x800
    x1894 = x1893 * x60
    x1895 = x1451 * x970 + x807
    x1896 = x4 * (x1892 - x1894)
    x1897 = 0.5 * x1896
    x1898 = x1451 * x972 + x822
    x1899 = x4 * (x1451 * x975 - x1898 * x60 + x820)
    x1900 = 0.5 * x1899
    x1901 = x4 * (-x1892 * x60 + x1898)
    x1902 = 0.5 * x1901
    x1903 = x1451 * x978 + 2.0 * x839
    x1904 = x1451 * x979 + 2.0 * x837
    x1905 = x1904 * x60
    x1906 = x1451 * x981 + 2.0 * x842
    x1907 = x4 * (x1903 - x1905)
    x1908 = 0.5 * x1907
    x1909 = x1451 * x983 + 2.0 * x853
    x1910 = x4 * (x1451 * x986 - x1909 * x60 + 2.0 * x851)
    x1911 = 0.5 * x1910
    x1912 = x4 * (-x1903 * x60 + x1909)
    x1913 = 0.5 * x1912
    x1914 = x1418 + x1451 * x989
    x1915 = x1420 + x1451 * x990
    x1916 = x1915 * x60
    x1917 = x1423 + x1451 * x992
    x1918 = x4 * (x1914 - x1916)
    x1919 = 0.5 * x1918
    x1920 = x1427 + x1451 * x994
    x1921 = x4 * (x1426 + x1451 * x997 - x1920 * x60)
    x1922 = 0.5 * x1921
    x1923 = x4 * (-x1914 * x60 + x1920)
    x1924 = 0.5 * x1923
    x1925 = x1004 * x1451 + 4.0 * x899
    x1926 = x155 * x1860 + 4.0 * x897
    x1927 = x1926 * x60
    x1928 = x1003 * x1451 + x889 * x98
    x1929 = x4 * (x1925 - x1927)
    x1930 = 0.5 * x1929
    x1931 = x1007 * x1451 + 4.0 * x910
    x1932 = x4 * (x1444 * x1451 - x1931 * x60 + x909 * x98)
    x1933 = 0.5 * x1932
    x1934 = x4 * (-x1925 * x60 + x1931)
    x1935 = 0.5 * x1934
    x1936 = x1010 * x1451 + 5.0 * x931
    x1937 = x1011 * x1451 + 5.0 * x928
    x1938 = x1937 * x60
    x1939 = x1013 * x1451 + 5.0 * x935
    x1940 = x1939 * x426
    x1941 = x4 * (x1936 - x1938)
    x1942 = 0.5 * x1941
    x1943 = x1017 * x1451 + 5.0 * x950
    x1944 = x4 * (x1021 * x1451 - x1943 * x60 + 5.0 * x948)
    x1945 = 0.5 * x1944
    x1946 = x4 * (-x1936 * x60 + x1943)
    x1947 = 0.5 * x1946
    x1948 = x1024**2
    x1949 = x132 + x1948 * x63
    x1950 = x141 + x1948 * x71
    x1951 = x1950 * x49
    x1952 = x1948 * x47
    x1953 = x122 + x1952
    x1954 = x145 + x1948 * x56
    x1955 = x1954 * x49
    x1956 = x1948 * x80
    x1957 = x1956 + x86
    x1958 = x1948 * x42
    x1959 = x1958 + x93
    x1960 = x1959 * x49
    x1961 = x1949 - x1953 * x60
    x1962 = x1948 * x44
    x1963 = x109 + x1962
    x1964 = x1963 * x49
    x1965 = x1959 * x3 + 4.0 * x1964
    x1966 = x1950 - x1954 * x60
    x1967 = x49 * (x150 + x1948 * x40)
    x1968 = x1029 * x49
    x1969 = x1024 * x1058 + x1968 + x233
    x1970 = x1024 * x1060 + x1045 * x49 + x239
    x1971 = x1024 * x57
    x1972 = x1024 * x1053 + x1971 + x228
    x1973 = x101 * x1024 + x1024 * x1055 + x243
    x1974 = x1024 * x82
    x1975 = x1024 * x1063 + x194 + x1974
    x1976 = x1024 * x88
    x1977 = x1024 * x1065 + x1976 + x200
    x1978 = x1969 - x1972 * x60
    x1979 = x1024 * x95
    x1980 = x1024 * x1068 + x1979 + x215
    x1981 = x116 * x1980 + x1977 * x3
    x1982 = x1970 - x1973 * x60
    x1983 = x49 * x53
    x1984 = x153 * (x1024 * x1075 + x1048 * x1983 + x249)
    x1985 = x1948 * x275 + x329
    x1986 = x1948 * x278 + x335
    x1987 = x1986 * x49
    x1988 = x1948 * x265 + x323
    x1989 = x1948 * x267 + x339
    x1990 = x1989 * x49
    x1991 = x1948 * x284 + x289
    x1992 = x1948 * x256 + x295
    x1993 = x1992 * x49
    x1994 = x1985 - x1988 * x60
    x1995 = x1948 * x260 + x311
    x1996 = x1995 * x49
    x1997 = x1992 * x3 + 3.0 * x1996
    x1998 = x1986 - x1989 * x60
    x1999 = x1948 * x5
    x2000 = x49 * (x1999 * x314 + x344)
    x2001 = x1024 * x1112 + x1060 * x153 + x409
    x2002 = x1024 * x1114 + x1081 * x153 + x418
    x2003 = x116 * x2002
    x2004 = x1024 * x1105 + x1055 * x153 + x403
    x2005 = x1024 * x1108 + x1079 * x153 + x422
    x2006 = x116 * x2005
    x2007 = x1024 * x1119 + x1065 * x153 + x381
    x2008 = x1024 * x1122 + x1068 * x153 + x386
    x2009 = x116 * x2008
    x2010 = x2001 - x2004 * x60
    x2011 = x1024 * x1126 + x1076 + x398
    x2012 = x153 * x2011 + x2008 * x3
    x2013 = x2002 - x2005 * x60
    x2014 = x49 * (x1024 * x1131 + 2.0 * x1084 + x427)
    x2015 = x1024 * x1146 + x1089 * x49 + x465
    x2016 = x1024 * x1147 + x1097 * x49 + x470
    x2017 = x1024 * x1143 + x1024 * x268 + x460
    x2018 = x1024 * x1144 + x1024 * x304 + x473
    x2019 = x1024 * x1149 + x1024 * x286 + x442
    x2020 = x1024 * x1150 + x1024 * x291 + x445
    x2021 = x2015 - x2017 * x60
    x2022 = x1024 * x1152 + x1048 * x314 * x49 + x456
    x2023 = x153 * x2022
    x2024 = x2020 * x3 + x2023
    x2025 = x2016 - x2018 * x60
    x2026 = x49 * (x1024 * x1156 + x1100 + x477)
    x2027 = x1948 * x500 + x551
    x2028 = x1948 * x506 + x561
    x2029 = x2028 * x49
    x2030 = x1948 * x488 + x542
    x2031 = x1948 * x494 + x565
    x2032 = x2031 * x49
    x2033 = x1948 * x515 + x520
    x2034 = x1948 * x487 + x525
    x2035 = x2034 * x49
    x2036 = x2027 - x2030 * x60
    x2037 = x1948 * x481 + x537
    x2038 = x2037 * x49
    x2039 = x2034 * x3 + 2.0 * x2038
    x2040 = x2028 - x2031 * x60
    x2041 = x49 * (x1948 * x479 + x570)
    x2042 = x1024 * x1193 + x1115 + x617
    x2043 = x1024 * x1195 + x1137 * x116 + x622
    x2044 = x1024 * x1186 + x1109 + x613
    x2045 = x1024 * x1190 + x1135 * x116 + x624
    x2046 = x1024 * x1198 + x1123 + x592
    x2047 = x1024 * x1201 + x1126 * x116 + x596
    x2048 = x2042 - x2044 * x60
    x2049 = x1024 * x1204 + 3.0 * x1132 + x607
    x2050 = x2049 * x49
    x2051 = x2047 * x3 + x2050
    x2052 = x2043 - x2045 * x60
    x2053 = x1024 * x1225 + x1147 * x153 + x665
    x2054 = x1024 * x1226 + x1164 + x672
    x2055 = x1024 * x1220 + x1144 * x153 + x661
    x2056 = x1024 * x1222 + x1161 + x674
    x2057 = x1024 * x1229 + x1150 * x153 + x646
    x2058 = x1024 * x1230 + x1153 + x648
    x2059 = x2053 - x2055 * x60
    x2060 = x1024 * x1234 + 2.0 * x1157 + x655
    x2061 = x2060 * x49
    x2062 = x2058 * x3 + x2061
    x2063 = x2054 - x2056 * x60
    x2064 = x1024 * x1258 + x1171 * x49 + x713
    x2065 = x1024 * x1259 + x1180 * x49 + x720
    x2066 = x153 * x2065
    x2067 = x1024 * x1253 + x1024 * x495 + x709
    x2068 = x1024 * x1254 + x1024 * x1255 + x722
    x2069 = x153 * x2068
    x2070 = x1024 * x1262 + x1024 * x517 + x692
    x2071 = x1024 * x1263 + x1024 * x1264 + x696
    x2072 = x153 * x2071
    x2073 = x2064 - x2067 * x60
    x2074 = x1024 * x1267 + x1176 + x703
    x2075 = x2074 * x49
    x2076 = x2071 * x3 + x2075
    x2077 = x2065 - x2068 * x60
    x2078 = x1948 * x737 + x774
    x2079 = x1948 * x739 + x780
    x2080 = x2079 * x49
    x2081 = x1948 * x729 + x769
    x2082 = x1948 * x725
    x2083 = x2082 * x5 + x782
    x2084 = x2083 * x49
    x2085 = x1948 * x744 + x748
    x2086 = x1948 * x746 + x751
    x2087 = x2086 * x49
    x2088 = x2078 - x2081 * x60
    x2089 = x2082 + x762
    x2090 = x2089 * x49
    x2091 = x2086 * x3 + x2090
    x2092 = x2079 - x2083 * x60
    x2093 = x1024 * x1302 + 4.0 * x1213 + x798
    x2094 = x2093 * x49
    x2095 = x1024 * x1318 + x1195 * x98 + x816
    x2096 = x1024 * x1305 + 4.0 * x1210 + x795
    x2097 = x2096 * x49
    x2098 = x1024 * x1314 + x1190 * x98 + x812
    x2099 = x1024 * x1309 + 4.0 * x1205 + x791
    x2100 = x2093 - x2096 * x60
    x2101 = x2099 * x49
    x2102 = x1024 * x1322 + x1201 * x98 + x810
    x2103 = x2095 - x2098 * x60
    x2104 = x1024 * x1328 + 3.0 * x1245 + x835
    x2105 = x2104 * x49
    x2106 = x1024 * x1340 + x116 * x1226 + x848
    x2107 = x1024 * x1329 + 3.0 * x1241 + x832
    x2108 = x2107 * x49
    x2109 = x1024 * x1337 + x116 * x1222 + x845
    x2110 = x1024 * x1333 + 3.0 * x1235 + x828
    x2111 = x2104 - x2107 * x60
    x2112 = x2110 * x49
    x2113 = x1024 * x1343 + x116 * x1230 + x844
    x2114 = x2106 - x2109 * x60
    x2115 = x1024 * x1348 + 2.0 * x1276 + x866
    x2116 = x2115 * x49
    x2117 = x1024 * x1359 + x1260 + x879
    x2118 = x1024 * x1349 + 2.0 * x1273 + x863
    x2119 = x2118 * x49
    x2120 = x1024 * x1356 + x1256 + x876
    x2121 = x1024 * x1352 + 2.0 * x1268 + x859
    x2122 = x2115 - x2118 * x60
    x2123 = x2121 * x49
    x2124 = x1024 * x1362 + x1265 + x875
    x2125 = x2117 - x2120 * x60
    x2126 = x1024 * x1367 + x1295 + x895
    x2127 = x2126 * x49
    x2128 = x1024 * x1377 + x1284 * x49 + x907
    x2129 = x1024 * x1368 + x1293 + x893
    x2130 = x2129 * x49
    x2131 = x1024 * x1374 + x1282 + x904
    x2132 = x1024 * x1370 + x1288 + x888
    x2133 = x2126 - x2129 * x60
    x2134 = x2132 * x49
    x2135 = x1024 * x1380 + x1286 * x49 + x902
    x2136 = x2128 - x2131 * x60
    x2137 = x1948 * x913 + x926
    x2138 = x2137 * x49
    x2139 = x1948 * x932 + x944
    x2140 = x1948 * x914 + x923
    x2141 = x2140 * x49
    x2142 = x1948 * x916
    x2143 = x2142 * x5 + x940
    x2144 = x2142 + x918
    x2145 = x2137 - x2140 * x60
    x2146 = x2144 * x49
    x2147 = x1999 * x936 + x938
    x2148 = x2139 - x2143 * x60
    x2149 = x1024 * x1398 + 5.0 * x1316 + x965
    x2150 = x1024 * x1401 + 5.0 * x1312 + x961
    x2151 = x2150 * x60
    x2152 = x1024 * x1405 + 5.0 * x1320 + x958
    x2153 = x2149 - x2151
    x2154 = x1024 * x1410 + 4.0 * x1339 + x976
    x2155 = x1024 * x1411 + 4.0 * x1336 + x973
    x2156 = x2155 * x60
    x2157 = x1024 * x1413 + 4.0 * x1342 + x971
    x2158 = x2154 - x2156
    x2159 = x1024 * x1419 + 3.0 * x1358 + x987
    x2160 = x1024 * x1421 + 3.0 * x1355 + x984
    x2161 = x2160 * x60
    x2162 = x1024 * x1424 + 3.0 * x1361 + x982
    x2163 = x2159 - x2161
    x2164 = x1024 * x1431 + 2.0 * x1376 + x998
    x2165 = x1024 * x1432 + 2.0 * x1373 + x995
    x2166 = x2165 * x60
    x2167 = x1024 * x1434 + 2.0 * x1379 + x993
    x2168 = x2164 - x2166
    x2169 = x1008 + x1024 * x1439 + x1390
    x2170 = x1005 + x1024 * x1440 + x1388
    x2171 = x2170 * x60
    x2172 = x1002 + x1024 * x1442 + x1392
    x2173 = x2169 - x2171
    x2174 = x1010 * x1948 + x1022
    x2175 = x1011 * x1948 + x1018
    x2176 = x2175 * x60
    x2177 = x1013 * x1948 + x1015
    x2178 = x2174 - x2176
    x2179 = x4 * (x1024 * x1451 * x63 - x1033 * x1451)
    x2180 = x1035 * x1451 + x1036 * x1451
    x2181 = x4 * (x1024 * x1451 * x71 - x1038 * x1451)
    x2182 = x1451 * x72
    x2183 = x1057 * x1451 + x2182
    x2184 = x105 * x1451
    x2185 = x1059 * x1451 + x2184
    x2186 = x1451 * x57
    x2187 = x1052 * x1451 + x2186
    x2188 = x101 * x1451
    x2189 = x1054 * x1451 + x2188
    x2190 = x1451 * x82
    x2191 = x1062 * x1451 + x2190
    x2192 = x1451 * x88
    x2193 = x1064 * x1451 + x2192
    x2194 = x4 * (x2183 - x2187 * x60)
    x2195 = x1451 * x95
    x2196 = x1067 * x1451 + x2195
    x2197 = x116 * x2196 + x2193 * x3
    x2198 = x4 * (x2185 - x2189 * x60)
    x2199 = x1465 * x1983
    x2200 = x153 * (x1074 * x1451 + x2199)
    x2201 = x1024 * x1501
    x2202 = x4 * (x1024 * x1499 - x1024 * x1509)
    x2203 = x1024 * x1512 + x1024 * x1515
    x2204 = x4 * (x1024 * x1501 - x1024 * x1517)
    x2205 = x1111 * x1451 + x1472 * x153
    x2206 = x1113 * x1451 + x1484 * x153
    x2207 = x116 * x2206
    x2208 = x1103 * x1451 + x1104 * x1451
    x2209 = x1106 * x1451 + x1107 * x1451
    x2210 = x116 * x2209
    x2211 = x1117 * x1451 + x1118 * x1451
    x2212 = x1120 * x1451 + x1121 * x1451
    x2213 = x116 * x2212
    x2214 = x4 * (x2205 - x2208 * x60)
    x2215 = x1125 * x1451 + x1480
    x2216 = x153 * x2215 + x2212 * x3
    x2217 = x4 * (x2206 - x2209 * x60)
    x2218 = x49 * (x1129 * x1451 + x1130 * x1451)
    x2219 = x1024 * x1566 + x1502
    x2220 = x1024 * x1567 + x1530
    x2221 = x1024 * x1563 + x1496
    x2222 = x1024 * x1564 + x1527
    x2223 = x1024 * x1569 + x1507
    x2224 = x1024 * x1570 + x1514
    x2225 = x4 * (x2219 - x2221 * x60)
    x2226 = x1024 * x1573 + x1522
    x2227 = x153 * x2226
    x2228 = x2224 * x3 + x2227
    x2229 = x4 * (x2220 - x2222 * x60)
    x2230 = x49 * (x1024 * x1578 + x1534)
    x2231 = x1024 * x1603
    x2232 = x4 * (x1024 * x1601 - x1024 * x1612)
    x2233 = x1024 * x1615 + x1024 * x1619
    x2234 = x4 * (x1024 * x1603 - x1024 * x1621)
    x2235 = x1024 * x1625
    x2236 = x1192 * x1451 + x1543
    x2237 = x116 * x1555 + x1194 * x1451
    x2238 = x1185 * x1451 + x1540
    x2239 = x1188 * x1451 + x1189 * x1451
    x2240 = x1197 * x1451 + x1545
    x2241 = x1199 * x1451 + x1200 * x1451
    x2242 = x4 * (x2236 - x2238 * x60)
    x2243 = x1187 * x1451 + x1203 * x1451
    x2244 = x2243 * x49
    x2245 = x2241 * x3 + x2244
    x2246 = x4 * (x2237 - x2239 * x60)
    x2247 = x153 * x1567
    x2248 = x1024 * x1671 + x2247
    x2249 = x1024 * x1672 + x1586
    x2250 = x153 * x1564
    x2251 = x1024 * x1665 + x2250
    x2252 = x1024 * x1668 + x1583
    x2253 = x153 * x1570
    x2254 = x1024 * x1675 + x2253
    x2255 = x1024 * x1677 + x1574
    x2256 = x4 * (x2248 - x2251 * x60)
    x2257 = 2.0 * x1579
    x2258 = x1024 * x1681 + x2257
    x2259 = x2258 * x49
    x2260 = x2255 * x3 + x2259
    x2261 = x4 * (x2249 - x2252 * x60)
    x2262 = x1024 * x1704 + x1604
    x2263 = x1024 * x1705 + x1633
    x2264 = x153 * x2263
    x2265 = x1024 * x1700 + x1598
    x2266 = x1024 * x1701 + x1630
    x2267 = x153 * x2266
    x2268 = x1024 * x1708 + x1610
    x2269 = x1024 * x1709 + x1618
    x2270 = x153 * x2269
    x2271 = x4 * (x2262 - x2265 * x60)
    x2272 = x1024 * x1713 + x1625
    x2273 = x2272 * x49
    x2274 = x2269 * x3 + x2273
    x2275 = x4 * (x2263 - x2266 * x60)
    x2276 = x1024 * x1742
    x2277 = x4 * (x1024 * x1740 - x1024 * x1750)
    x2278 = x1024 * x1754
    x2279 = x1024 * x1755 + x2278
    x2280 = x4 * (x1024 * x1742 - x1024 * x1757)
    x2281 = x1300 * x1451 + x1301 * x1451
    x2282 = x2281 * x49
    x2283 = x1317 * x1451 + x1645 * x98
    x2284 = x1303 * x1451 + x1304 * x1451
    x2285 = x2284 * x49
    x2286 = x1308 * x1465 + x1313 * x1451
    x2287 = x1307 * x1451 + x1308 * x1451
    x2288 = x4 * (x2281 - x2284 * x60)
    x2289 = x2287 * x49
    x2290 = x1321 * x1451 + x1647 * x98
    x2291 = x4 * (x2283 - x2286 * x60)
    x2292 = x1024 * x1789 + 3.0 * x1691
    x2293 = x2292 * x49
    x2294 = x1024 * x1801 + x116 * x1672
    x2295 = x1024 * x1790 + 3.0 * x1688
    x2296 = x2295 * x49
    x2297 = x1024 * x1798 + x116 * x1668
    x2298 = x1024 * x1793 + 3.0 * x1682
    x2299 = x4 * (x2292 - x2295 * x60)
    x2300 = x2298 * x49
    x2301 = x1024 * x1804 + x116 * x1677
    x2302 = x4 * (x2294 - x2297 * x60)
    x2303 = x1024 * x1812 + 2.0 * x1723
    x2304 = x2303 * x49
    x2305 = x1024 * x1824 + x1706
    x2306 = x1024 * x1813 + 2.0 * x1720
    x2307 = x2306 * x49
    x2308 = x1024 * x1821 + x1702
    x2309 = x1024 * x1816 + 2.0 * x1714
    x2310 = x4 * (x2303 - x2306 * x60)
    x2311 = x2309 * x49
    x2312 = x1024 * x1827 + x1710
    x2313 = x4 * (x2305 - x2308 * x60)
    x2314 = x1024 * x1835 + x1766
    x2315 = x2314 * x49
    x2316 = x1024 * x1846 + x1743
    x2317 = x1024 * x1836 + x1763
    x2318 = x2317 * x49
    x2319 = x1024 * x1843 + x1737
    x2320 = x1024 * x1838 + x1754
    x2321 = x4 * (x2314 - x2317 * x60)
    x2322 = x2320 * x49
    x2323 = x1024 * x1849 + x1748
    x2324 = x4 * (x2316 - x2319 * x60)
    x2325 = x1024 * x1870
    x2326 = x1024 * x1866
    x2327 = x4 * (x1024 * x1857 - x1024 * x1859)
    x2328 = x1024 * x1874
    x2329 = x4 * (x1024 * x1871 - x1024 * x1877)
    x2330 = x1396 * x1451 + x1397 * x1451
    x2331 = x1399 * x1451 + x1400 * x1451
    x2332 = x2331 * x60
    x2333 = x1403 * x1451 + x1404 * x1451
    x2334 = x4 * (x2330 - x2332)
    x2335 = x1024 * x1892 + 4.0 * x1800
    x2336 = x1024 * x1893 + 4.0 * x1797
    x2337 = x2336 * x60
    x2338 = x1024 * x1895 + 4.0 * x1803
    x2339 = x4 * (x2335 - x2337)
    x2340 = 3.0 * x1823
    x2341 = x1024 * x1903 + x2340
    x2342 = 3.0 * x1820
    x2343 = x1024 * x1904 + x2342
    x2344 = x2343 * x60
    x2345 = 3.0 * x1826
    x2346 = x1024 * x1906 + x2345
    x2347 = x4 * (x2341 - x2344)
    x2348 = x1024 * x1914 + 2.0 * x1845
    x2349 = x1024 * x1915 + 2.0 * x1842
    x2350 = x2349 * x60
    x2351 = x1024 * x1917 + 2.0 * x1848
    x2352 = x4 * (x2348 - x2350)
    x2353 = x1024 * x1925 + x1870
    x2354 = x1024 * x1926 + x1866
    x2355 = x2354 * x60
    x2356 = x1024 * x1928 + x1874
    x2357 = x4 * (x2353 - x2355)
    x2358 = x4 * (x1024 * x1936 - x1024 * x1938)
    x2359 = x1451**2
    x2360 = x132 + x2359 * x63
    x2361 = x141 + x2359 * x71
    x2362 = x2361 * x49
    x2363 = x122 + x2359 * x47
    x2364 = x145 + x2359 * x56
    x2365 = x2364 * x49
    x2366 = x2359 * x80 + x86
    x2367 = x2366 * x3
    x2368 = x2359 * x42 + x93
    x2369 = x2368 * x49
    x2370 = 5.0 * x2369
    x2371 = x2363 * x60
    x2372 = x2360 - x2371
    x2373 = x2372 * x85
    x2374 = x2368 * x3
    x2375 = x109 + x2359 * x44
    x2376 = x2375 * x49
    x2377 = 4.0 * x2376
    x2378 = x2374 + x2377
    x2379 = x2361 - x2364 * x60
    x2380 = x2379 * x85
    x2381 = x49 * (x150 + x2359 * x40)
    x2382 = x180 * x2359 + x233
    x2383 = x183 * x2359 + x239
    x2384 = x2383 * x49
    x2385 = x170 * x2359 + x228
    x2386 = x172 * x2359 + x243
    x2387 = x2386 * x49
    x2388 = x189 * x2359 + x194
    x2389 = x161 * x2359 + x200
    x2390 = x2389 * x49
    x2391 = x2382 - x2385 * x60
    x2392 = x2391 * x85
    x2393 = x165 * x2359 + x215
    x2394 = x2393 * x49
    x2395 = x2389 * x3 + 3.0 * x2394
    x2396 = x2383 - x2386 * x60
    x2397 = x2396 * x85
    x2398 = x2359 * x5
    x2399 = x49 * (x2398 * x446 + x249)
    x2400 = 2.0 * x2399
    x2401 = x1451 * x1499 + x2182 + x329
    x2402 = x1451 * x1501 + x2184 + x335
    x2403 = x2402 * x49
    x2404 = x1451 * x1493 + x2186 + x323
    x2405 = x1451 * x1495 + x2188 + x339
    x2406 = x2405 * x49
    x2407 = x1451 * x1504 + x2190 + x289
    x2408 = x2407 * x3
    x2409 = x1451 * x1506 + x2192 + x295
    x2410 = x2409 * x49
    x2411 = 4.0 * x2410
    x2412 = x2404 * x60
    x2413 = x2401 - x2412
    x2414 = x2413 * x85
    x2415 = x2409 * x3
    x2416 = x1451 * x1513 + x2195 + x311
    x2417 = x2416 * x49
    x2418 = 3.0 * x2417
    x2419 = x2415 + x2418
    x2420 = x2402 - x2405 * x60
    x2421 = x2420 * x85
    x2422 = x49 * (x1451 * x1521 + x2199 + x344)
    x2423 = 2.0 * x2422
    x2424 = x2359 * x364 + x409
    x2425 = x2359 * x368 + x418
    x2426 = x2425 * x49
    x2427 = 3.0 * x2426
    x2428 = x2359 * x354 + x403
    x2429 = x2359 * x358 + x422
    x2430 = x2429 * x49
    x2431 = 3.0 * x2430
    x2432 = x2359 * x376 + x381
    x2433 = x2359 * x353 + x386
    x2434 = x2433 * x49
    x2435 = 3.0 * x2434
    x2436 = x2424 - x2428 * x60
    x2437 = x2436 * x85
    x2438 = x2359 * x348 + x398
    x2439 = x2438 * x49
    x2440 = x2433 * x3 + 2.0 * x2439
    x2441 = x2425 - x2429 * x60
    x2442 = x2441 * x85
    x2443 = x49 * (x2359 * x346 + x427)
    x2444 = x1451 * x1566 + x1472 * x49 + x465
    x2445 = x1451 * x1567 + x1484 * x49 + x470
    x2446 = x1451 * x1563 + x1451 * x173 + x460
    x2447 = x1451 * x1564 + x1451 * x208 + x473
    x2448 = x1451 * x1569 + x1451 * x191 + x442
    x2449 = x1451 * x1570 + x1451 * x196 + x445
    x2450 = x2444 - x2446 * x60
    x2451 = x2450 * x85
    x2452 = x1451 * x1573 + x1479 * x38 * x49 + x456
    x2453 = x153 * x2452
    x2454 = x2449 * x3 + x2453
    x2455 = x2445 - x2447 * x60
    x2456 = x2455 * x85
    x2457 = x49 * (x1451 * x1578 + x1488 + x477)
    x2458 = x1451 * x1601 + 2.0 * x1502 + x551
    x2459 = x1451 * x1603 + 2.0 * x1530 + x561
    x2460 = x2459 * x49
    x2461 = 3.0 * x2460
    x2462 = x1451 * x1595 + 2.0 * x1496 + x542
    x2463 = x1451 * x1597 + 2.0 * x1527 + x565
    x2464 = x2463 * x49
    x2465 = 3.0 * x2464
    x2466 = x1451 * x1607 + 2.0 * x1507 + x520
    x2467 = x2466 * x3
    x2468 = x1451 * x1609 + 2.0 * x1514 + x525
    x2469 = x2468 * x49
    x2470 = 3.0 * x2469
    x2471 = x2462 * x60
    x2472 = x2458 - x2471
    x2473 = x2472 * x85
    x2474 = x2468 * x3
    x2475 = x1451 * x1617 + x1523 + x537
    x2476 = x2475 * x49
    x2477 = 2.0 * x2476
    x2478 = x2474 + x2477
    x2479 = x2459 - x2463 * x60
    x2480 = x2479 * x85
    x2481 = x49 * (x1451 * x1624 + 2.0 * x1534 + x570)
    x2482 = x2359 * x582 + x617
    x2483 = x2359 * x584 + x622
    x2484 = x2483 * x49
    x2485 = x2359 * x575 + x613
    x2486 = x2359 * x572
    x2487 = x2486 * x5 + x624
    x2488 = x2487 * x49
    x2489 = x2359 * x588 + x592
    x2490 = x2359 * x590 + x596
    x2491 = x2490 * x49
    x2492 = x2482 - x2485 * x60
    x2493 = x2492 * x85
    x2494 = x2486 + x607
    x2495 = x2494 * x49
    x2496 = x2490 * x3 + x2495
    x2497 = x2483 - x2487 * x60
    x2498 = x2497 * x85
    x2499 = x1451 * x1671 + x1542 * x49 + x665
    x2500 = x1451 * x1672 + x1555 * x49 + x672
    x2501 = x153 * x2500
    x2502 = x1451 * x1665 + x1451 * x359 + x661
    x2503 = x1451 * x1666 + x1451 * x1668 + x674
    x2504 = x153 * x2503
    x2505 = x1451 * x1675 + x1451 * x378 + x646
    x2506 = x1451 * x1676 + x1451 * x1677 + x648
    x2507 = x153 * x2506
    x2508 = x2499 - x2502 * x60
    x2509 = x2508 * x85
    x2510 = x1451 * x1681 + x1551 + x655
    x2511 = x2510 * x49
    x2512 = x2506 * x3 + x2511
    x2513 = x2500 - x2503 * x60
    x2514 = x2513 * x85
    x2515 = x1451 * x1704 + x2247 + x713
    x2516 = x1451 * x1705 + x1586 + x720
    x2517 = x153 * x2516
    x2518 = x1451 * x1700 + x2250 + x709
    x2519 = x1451 * x1701 + x1583 + x722
    x2520 = x153 * x2519
    x2521 = x1451 * x1708 + x2253 + x692
    x2522 = x1451 * x1709 + x1574 + x696
    x2523 = x153 * x2522
    x2524 = x2515 - x2518 * x60
    x2525 = x2524 * x85
    x2526 = x1451 * x1713 + x2257 + x703
    x2527 = x2526 * x49
    x2528 = x2522 * x3 + x2527
    x2529 = x2516 - x2519 * x60
    x2530 = x2529 * x85
    x2531 = x1451 * x1740 + x1605 + x774
    x2532 = x1451 * x1742 + 3.0 * x1633 + x780
    x2533 = x2532 * x49
    x2534 = x1451 * x1732 + x1599 + x769
    x2535 = x1451 * x1736 + 3.0 * x1630 + x782
    x2536 = x2535 * x49
    x2537 = x1451 * x1745 + x1611 + x748
    x2538 = x2537 * x3
    x2539 = x1451 * x1747 + 3.0 * x1618 + x751
    x2540 = x2539 * x49
    x2541 = 2.0 * x2540
    x2542 = x2534 * x60
    x2543 = x2531 - x2542
    x2544 = x2543 * x85
    x2545 = x1451 * x1753 + 3.0 * x1625 + x762
    x2546 = x2545 * x49
    x2547 = x2539 * x3
    x2548 = x2546 + x2547
    x2549 = x2532 - x2535 * x60
    x2550 = x2549 * x85
    x2551 = x2359 * x785 + x798
    x2552 = x2551 * x49
    x2553 = x2359 * x804 + x816
    x2554 = x2359 * x786 + x795
    x2555 = x2554 * x49
    x2556 = x2359 * x789
    x2557 = x2556 * x5 + x812
    x2558 = x2556 + x791
    x2559 = x2551 - x2554 * x60
    x2560 = x2559 * x85
    x2561 = x2558 * x49
    x2562 = x2398 * x808 + x810
    x2563 = x2553 - x2557 * x60
    x2564 = x2563 * x85
    x2565 = x1451 * x1789 + x1657 + x835
    x2566 = x2565 * x49
    x2567 = x1451 * x1801 + x1645 * x49 + x848
    x2568 = x1451 * x1790 + x1655 + x832
    x2569 = x2568 * x49
    x2570 = x1451 * x1798 + x1643 + x845
    x2571 = x1451 * x1793 + x1642 + x828
    x2572 = x2565 - x2568 * x60
    x2573 = x2572 * x85
    x2574 = x2571 * x49
    x2575 = x1451 * x1804 + x1647 * x49 + x844
    x2576 = x2567 - x2570 * x60
    x2577 = x2576 * x85
    x2578 = x1451 * x1812 + 2.0 * x1691 + x866
    x2579 = x2578 * x49
    x2580 = x1451 * x1824 + x1673 + x879
    x2581 = x1451 * x1813 + 2.0 * x1688 + x863
    x2582 = x2581 * x49
    x2583 = x1451 * x1821 + x1669 + x876
    x2584 = x1451 * x1816 + 2.0 * x1682 + x859
    x2585 = x2578 - x2581 * x60
    x2586 = x2585 * x85
    x2587 = x2584 * x49
    x2588 = x1451 * x1827 + x1678 + x875
    x2589 = x2580 - x2583 * x60
    x2590 = x2589 * x85
    x2591 = x1451 * x1835 + 3.0 * x1723 + x895
    x2592 = x2591 * x49
    x2593 = x116 * x1705 + x1451 * x1846 + x907
    x2594 = x1451 * x1836 + 3.0 * x1720 + x893
    x2595 = x2594 * x49
    x2596 = x116 * x1701 + x1451 * x1843 + x904
    x2597 = x1451 * x1838 + 3.0 * x1714 + x888
    x2598 = x2591 - x2594 * x60
    x2599 = x2598 * x85
    x2600 = x2597 * x49
    x2601 = x116 * x1709 + x1451 * x1849 + x902
    x2602 = x2593 - x2596 * x60
    x2603 = x2602 * x85
    x2604 = x1451 * x1857 + 4.0 * x1766 + x926
    x2605 = x2604 * x49
    x2606 = x1451 * x1871 + 4.0 * x1743 + x944
    x2607 = x1451 * x1858 + 4.0 * x1763 + x923
    x2608 = x2607 * x49
    x2609 = x1451 * x1867 + 4.0 * x1737 + x940
    x2610 = x1451 * x1861 + 4.0 * x1754 + x918
    x2611 = x2604 - x2607 * x60
    x2612 = x2611 * x85
    x2613 = x2610 * x49
    x2614 = x1451 * x1875 + 4.0 * x1748 + x938
    x2615 = x2614 * x3
    x2616 = x2609 * x60
    x2617 = x2606 - x2616
    x2618 = x2617 * x85
    x2619 = x2613 * x3
    x2620 = x2359 * x952 + x965
    x2621 = x2359 * x953 + x961
    x2622 = x2621 * x60
    x2623 = x2359 * x956 + x958
    x2624 = x2620 - x2622
    x2625 = x2624 * x85
    x2626 = x1451 * x1892 + x1780 + x976
    x2627 = x1451 * x1893 + x1778 + x973
    x2628 = x2627 * x60
    x2629 = x1451 * x1895 + x1782 + x971
    x2630 = x2626 - x2628
    x2631 = x2630 * x85
    x2632 = x1451 * x1903 + 2.0 * x1800 + x987
    x2633 = x1451 * x1904 + 2.0 * x1797 + x984
    x2634 = x2633 * x60
    x2635 = x1451 * x1906 + 2.0 * x1803 + x982
    x2636 = x2632 - x2634
    x2637 = x2636 * x85
    x2638 = x1451 * x1914 + x2340 + x998
    x2639 = x1451 * x1915 + x2342 + x995
    x2640 = x2639 * x60
    x2641 = x1451 * x1917 + x2345 + x993
    x2642 = x2638 - x2640
    x2643 = x2642 * x85
    x2644 = x1008 + x1451 * x1925 + 4.0 * x1845
    x2645 = x1005 + x1451 * x1926 + 4.0 * x1842
    x2646 = x2645 * x60
    x2647 = x1002 + x1451 * x1928 + 4.0 * x1848
    x2648 = x2644 - x2646
    x2649 = x2648 * x85
    x2650 = x1022 + x1451 * x1936 + 5.0 * x1870
    x2651 = x1018 + x1451 * x1937 + 5.0 * x1866
    x2652 = x2651 * x60
    x2653 = x1015 + x1451 * x1939 + 5.0 * x1874
    x2654 = x2653 * x426
    x2655 = x2650 - x2652
    x2656 = x2655 * x85
    x2657 = x1024 * x1957 + x1034
    x2658 = x1024 * x1959 + x1039
    x2659 = x2658 * x49
    x2660 = x1024 * x1949 + x1050 - x60 * (x1024 * x1953 + x1051)
    x2661 = x49 * (x1024 * x1963 + x1047)
    x2662 = x1024 * x1975 + x1066 + x1960
    x2663 = x1024 * x1977 + x1070 + x1964
    x2664 = x1024 * x1969 + x1086 + x1951 - x60 * (x1024 * x1972 + x1087 + x1955)
    x2665 = x1024 * x1980 + x1083 + x1967
    x2666 = x1024 * x1991 + x1091
    x2667 = x1024 * x1992 + x1093
    x2668 = x2667 * x49
    x2669 = x1024 * x1985 + x1101 - x60 * (x1024 * x1988 + x1102)
    x2670 = x49 * (x1024 * x1995 + x1099)
    x2671 = x1024 * x2007 + x1124 + x153 * x1977
    x2672 = x1024 * x2008 + x1128 + x153 * x1980
    x2673 = x116 * x2672
    x2674 = (
        x1024 * x2001
        + x1141
        + x153 * x1970
        - x60 * (x1024 * x2004 + x1142 + x153 * x1973)
    )
    x2675 = x1024 * x2011 + x1139 + x1984
    x2676 = x1024 * x2019 + x1151 + x1993
    x2677 = x1024 * x2020 + x1155 + x1996
    x2678 = x1024 * x2015 + x1168 + x1987 - x60 * (x1024 * x2017 + x1169 + x1990)
    x2679 = x153 * (x1024 * x2022 + x1166 + x2000)
    x2680 = x1024 * x2033 + x1173
    x2681 = x1024 * x2034 + x1175
    x2682 = x2681 * x49
    x2683 = x1024 * x2027 + x1183 - x60 * (x1024 * x2030 + x1184)
    x2684 = x49 * (x1024 * x2037 + x1182)
    x2685 = x1024 * x2046 + x1202 + x2009
    x2686 = x1024 * x2047 + x116 * x2011 + x1207
    x2687 = x1024 * x2042 + x1217 + x2003 - x60 * (x1024 * x2044 + x1218 + x2006)
    x2688 = x49 * (x1024 * x2049 + x1215 + 3.0 * x2014)
    x2689 = x1024 * x2057 + x1231 + x153 * x2020
    x2690 = x1024 * x2058 + x1237 + x2023
    x2691 = (
        x1024 * x2053
        + x1251
        + x153 * x2016
        - x60 * (x1024 * x2055 + x1252 + x153 * x2018)
    )
    x2692 = x49 * (x1024 * x2060 + x1247 + 2.0 * x2026)
    x2693 = x1024 * x2070 + x1266 + x2035
    x2694 = x1024 * x2071 + x1270 + x2038
    x2695 = x153 * x2694
    x2696 = x1024 * x2064 + x1280 + x2029 - x60 * (x1024 * x2067 + x1281 + x2032)
    x2697 = x49 * (x1024 * x2074 + x1278 + x2041)
    x2698 = x1024 * x2085 + x1287
    x2699 = x1024 * x2086 + x1291
    x2700 = x2699 * x49
    x2701 = x1024 * x2078 + x1298 - x60 * (x1024 * x2081 + x1299)
    x2702 = x49 * (x1024 * x2089 + x1297)
    x2703 = x1024 * x2099 + x1310 + 4.0 * x2050
    x2704 = x2703 * x49
    x2705 = x1024 * x2102 + x1323 + x2047 * x98
    x2706 = (
        x1024 * x2095 + x1325 + x2043 * x98 - x60 * (x1024 * x2098 + x1326 + x2045 * x98)
    )
    x2707 = x1024 * x2110 + x1334 + 3.0 * x2061
    x2708 = x2707 * x49
    x2709 = x1024 * x2113 + x116 * x2058 + x1344
    x2710 = (
        x1024 * x2106
        + x116 * x2054
        + x1346
        - x60 * (x1024 * x2109 + x116 * x2056 + x1347)
    )
    x2711 = x1024 * x2121 + x1353 + 2.0 * x2075
    x2712 = x2711 * x49
    x2713 = x1024 * x2124 + x1363 + x2072
    x2714 = x1024 * x2117 + x1365 + x2066 - x60 * (x1024 * x2120 + x1366 + x2069)
    x2715 = x1024 * x2132 + x1371 + x2090
    x2716 = x2715 * x49
    x2717 = x1024 * x2135 + x1381 + x2087
    x2718 = x1024 * x2128 + x1383 + x2080 - x60 * (x1024 * x2131 + x1384 + x2084)
    x2719 = x1024 * x2144 + x1386
    x2720 = x2719 * x49
    x2721 = x1024 * x2147 + x1393
    x2722 = x1024 * x2139 + x1394 - x60 * (x1024 * x2143 + x1395)
    x2723 = x1024 * x2152 + x1406 + 5.0 * x2101
    x2724 = (
        x1024 * x2149 + x1408 + 5.0 * x2094 - x60 * (x1024 * x2150 + x1409 + 5.0 * x2097)
    )
    x2725 = x1024 * x2157 + x1414 + 4.0 * x2112
    x2726 = (
        x1024 * x2154 + x1416 + 4.0 * x2105 - x60 * (x1024 * x2155 + x1417 + 4.0 * x2108)
    )
    x2727 = x1024 * x2162 + x1425 + 3.0 * x2123
    x2728 = (
        x1024 * x2159 + x1429 + 3.0 * x2116 - x60 * (x1024 * x2160 + x1430 + 3.0 * x2119)
    )
    x2729 = x1024 * x2167 + x1435 + 2.0 * x2134
    x2730 = (
        x1024 * x2164 + x1437 + 2.0 * x2127 - x60 * (x1024 * x2165 + x1438 + 2.0 * x2130)
    )
    x2731 = x1024 * x2172 + x1443 + x2146
    x2732 = x1024 * x2169 + x1446 + x2138 - x60 * (x1024 * x2170 + x1447 + x2141)
    x2733 = x1024 * x2177 + x1448
    x2734 = x1024 * x2174 + x1449 - x60 * (x1024 * x2175 + x1450)
    x2735 = x1451 * x1956 + x1455
    x2736 = x1451 * x1958 + x1458
    x2737 = x2736 * x49
    x2738 = x1467 + x1468 * x1948 - x60 * (x1451 * x1952 + x1470)
    x2739 = x49 * (x1451 * x1962 + x1464)
    x2740 = x1024 * x2191 + x1451 * x1974 + x1475
    x2741 = x1024 * x2193 + x1451 * x1976 + x1478
    x2742 = (
        x1024 * x2183
        + x1451 * x1968
        + x1490
        - x60 * (x1024 * x2187 + x1451 * x1971 + x1492)
    )
    x2743 = x1024 * x2196 + x1451 * x1979 + x1487
    x2744 = x1504 * x1948 + x1511
    x2745 = x1506 * x1948 + x1519
    x2746 = x2745 * x49
    x2747 = x1499 * x1948 + x1537 - x60 * (x1493 * x1948 + x1539)
    x2748 = x49 * (x1513 * x1948 + x1533)
    x2749 = x1024 * x2211 + x153 * x2193 + x1547
    x2750 = x1024 * x2212 + x153 * x2196 + x1550
    x2751 = x116 * x2750
    x2752 = (
        x1024 * x2205
        + x153 * x2185
        + x1560
        - x60 * (x1024 * x2208 + x153 * x2189 + x1562)
    )
    x2753 = x1024 * x2215 + x1558 + x2200
    x2754 = x1024 * x1507 + x1024 * x2223 + x1572
    x2755 = x1024 * x1514 + x1024 * x2224 + x1577
    x2756 = (
        x1024 * x2219
        + x1592
        + x2201 * x49
        - x60 * (x1024 * x1496 + x1024 * x2221 + x1594)
    )
    x2757 = x153 * (x1024 * x1522 + x1024 * x2226 + x1589)
    x2758 = x1607 * x1948 + x1614
    x2759 = x1609 * x1948 + x1623
    x2760 = x2759 * x49
    x2761 = x1601 * x1948 + x1639 - x60 * (x1595 * x1948 + x1641)
    x2762 = x49 * (x1617 * x1948 + x1636)
    x2763 = x1024 * x2240 + x1649 + x2213
    x2764 = x1024 * x2241 + x116 * x2215 + x1653
    x2765 = x1024 * x2236 + x1662 + x2207 - x60 * (x1024 * x2238 + x1664 + x2210)
    x2766 = x49 * (x1024 * x2243 + x1660 + 3.0 * x2218)
    x2767 = x1024 * x2254 + x153 * x2224 + x1680
    x2768 = x1024 * x2255 + x1685 + x2227
    x2769 = (
        x1024 * x2248
        + x153 * x2220
        + x1697
        - x60 * (x1024 * x2251 + x153 * x2222 + x1699)
    )
    x2770 = x49 * (x1024 * x2258 + x1694 + 2.0 * x2230)
    x2771 = x1024 * x1610 + x1024 * x2268 + x1712
    x2772 = x1024 * x1618 + x1024 * x2269 + x1717
    x2773 = x153 * x2772
    x2774 = (
        x1024 * x2262
        + x1729
        + x2231 * x49
        - x60 * (x1024 * x1598 + x1024 * x2265 + x1731)
    )
    x2775 = x49 * (x1024 * x2272 + x1726 + x2235)
    x2776 = x1745 * x1948 + x1752
    x2777 = x1747 * x1948 + x1759
    x2778 = x2777 * x49
    x2779 = x1740 * x1948 + x1772 - x60 * (x1732 * x1948 + x1774)
    x2780 = x49 * (x1753 * x1948 + x1769)
    x2781 = x1024 * x2287 + x1776 + 4.0 * x2244
    x2782 = x2781 * x49
    x2783 = x1024 * x2290 + x1784 + x2241 * x98
    x2784 = (
        x1024 * x2283 + x1786 + x2237 * x98 - x60 * (x1024 * x2286 + x1788 + x2239 * x98)
    )
    x2785 = x1024 * x2298 + x1795 + 3.0 * x2259
    x2786 = x2785 * x49
    x2787 = x1024 * x2301 + x116 * x2255 + x1806
    x2788 = (
        x1024 * x2294
        + x116 * x2249
        + x1809
        - x60 * (x1024 * x2297 + x116 * x2252 + x1811)
    )
    x2789 = x1024 * x2309 + x1818 + 2.0 * x2273
    x2790 = x2789 * x49
    x2791 = x1024 * x2312 + x1829 + x2270
    x2792 = x1024 * x2305 + x1832 + x2264 - x60 * (x1024 * x2308 + x1834 + x2267)
    x2793 = x1024 * x2320 + x1840 + x2278
    x2794 = x2793 * x49
    x2795 = x1024 * x1748 + x1024 * x2323 + x1851
    x2796 = (
        x1024 * x2316
        + x1854
        + x2276 * x49
        - x60 * (x1024 * x1737 + x1024 * x2319 + x1856)
    )
    x2797 = x1861 * x1948 + x1864
    x2798 = x2797 * x49
    x2799 = x1875 * x1948 + x1879
    x2800 = x1871 * x1948 + x1883 - x60 * (x1867 * x1948 + x1885)
    x2801 = x1024 * x2333 + x1887 + 5.0 * x2289
    x2802 = (
        x1024 * x2330 + x1889 + 5.0 * x2282 - x60 * (x1024 * x2331 + x1891 + 5.0 * x2285)
    )
    x2803 = x1024 * x2338 + x1897 + 4.0 * x2300
    x2804 = (
        x1024 * x2335 + x1900 + 4.0 * x2293 - x60 * (x1024 * x2336 + x1902 + 4.0 * x2296)
    )
    x2805 = x1024 * x2346 + x1908 + 3.0 * x2311
    x2806 = (
        x1024 * x2341 + x1911 + 3.0 * x2304 - x60 * (x1024 * x2343 + x1913 + 3.0 * x2307)
    )
    x2807 = x1024 * x2351 + x1919 + 2.0 * x2322
    x2808 = (
        x1024 * x2348 + x1922 + 2.0 * x2315 - x60 * (x1024 * x2349 + x1924 + 2.0 * x2318)
    )
    x2809 = x1024 * x2356 + x1930 + x2328
    x2810 = x1024 * x2353 + x1933 + x2325 - x60 * (x1024 * x2354 + x1935 + x2326)
    x2811 = x1939 * x1948 + x1942
    x2812 = x1936 * x1948 + x1945 - x60 * (x1937 * x1948 + x1947)
    x2813 = x4 * (x1024 * x2360 - x1024 * x2371)
    x2814 = x1024 * x2388 + x2369
    x2815 = x1024 * x2389 + x2376
    x2816 = x4 * (x1024 * x2382 + x2362 - x60 * (x1024 * x2385 + x2365))
    x2817 = x1024 * x2393 + x2381
    x2818 = x4 * (x1024 * x2401 - x1024 * x2412)
    x2819 = x1024 * x2432 + 2.0 * x2390
    x2820 = x1024 * x2433 + 2.0 * x2394
    x2821 = x116 * x2820
    x2822 = x4 * (x1024 * x2424 + 2.0 * x2384 - x60 * (x1024 * x2428 + 2.0 * x2387))
    x2823 = x1024 * x2438 + x2400
    x2824 = x1024 * x2448 + x2410
    x2825 = x1024 * x2449 + x2417
    x2826 = x4 * (x1024 * x2444 + x2403 - x60 * (x1024 * x2446 + x2406))
    x2827 = x153 * (x1024 * x2452 + x2422)
    x2828 = x4 * (x1024 * x2458 - x1024 * x2471)
    x2829 = x1024 * x2489 + x2435
    x2830 = x1024 * x2490 + 3.0 * x2439
    x2831 = x4 * (x1024 * x2482 + x2427 - x60 * (x1024 * x2485 + x2431))
    x2832 = x49 * (x1024 * x2494 + 3.0 * x2443)
    x2833 = x153 * x2449
    x2834 = x1024 * x2505 + x2833
    x2835 = x1024 * x2506 + x2453
    x2836 = x153 * x2445
    x2837 = x153 * x2447
    x2838 = x4 * (x1024 * x2499 + x2836 - x60 * (x1024 * x2502 + x2837))
    x2839 = 2.0 * x2457
    x2840 = x49 * (x1024 * x2510 + x2839)
    x2841 = x1024 * x2521 + x2469
    x2842 = x1024 * x2522 + x2476
    x2843 = x153 * x2842
    x2844 = x4 * (x1024 * x2515 + x2460 - x60 * (x1024 * x2518 + x2464))
    x2845 = x49 * (x1024 * x2526 + x2481)
    x2846 = x4 * (x1024 * x2531 - x1024 * x2542)
    x2847 = x1024 * x2546
    x2848 = x1024 * x2558 + 4.0 * x2495
    x2849 = x2848 * x49
    x2850 = x1024 * x2562 + 4.0 * x2491
    x2851 = x4 * (x1024 * x2553 + 4.0 * x2484 - x60 * (x1024 * x2557 + 4.0 * x2488))
    x2852 = x1024 * x2571 + 3.0 * x2511
    x2853 = x2852 * x49
    x2854 = x1024 * x2575 + x116 * x2506
    x2855 = x4 * (x1024 * x2567 + x116 * x2500 - x60 * (x1024 * x2570 + x116 * x2503))
    x2856 = x1024 * x2584 + 2.0 * x2527
    x2857 = x2856 * x49
    x2858 = x1024 * x2588 + x2523
    x2859 = x4 * (x1024 * x2580 + x2517 - x60 * (x1024 * x2583 + x2520))
    x2860 = x1024 * x2597 + x2546
    x2861 = x2860 * x49
    x2862 = x1024 * x2601 + x2540
    x2863 = x4 * (x1024 * x2593 + x2533 - x60 * (x1024 * x2596 + x2536))
    x2864 = x1024 * x2613
    x2865 = x4 * (x1024 * x2606 - x1024 * x2616)
    x2866 = x1024 * x2623 + 5.0 * x2561
    x2867 = x4 * (x1024 * x2620 + 5.0 * x2552 - x60 * (x1024 * x2621 + 5.0 * x2555))
    x2868 = x1024 * x2629 + 4.0 * x2574
    x2869 = x4 * (x1024 * x2626 + 4.0 * x2566 - x60 * (x1024 * x2627 + 4.0 * x2569))
    x2870 = 3.0 * x2587
    x2871 = x1024 * x2635 + x2870
    x2872 = 3.0 * x2579
    x2873 = 3.0 * x2582
    x2874 = x4 * (x1024 * x2632 + x2872 - x60 * (x1024 * x2633 + x2873))
    x2875 = x1024 * x2641 + 2.0 * x2600
    x2876 = x4 * (x1024 * x2638 + 2.0 * x2592 - x60 * (x1024 * x2639 + 2.0 * x2595))
    x2877 = x1024 * x2647 + x2613
    x2878 = x4 * (x1024 * x2644 + x2605 - x60 * (x1024 * x2645 + x2608))
    x2879 = x4 * (x1024 * x2650 - x1024 * x2652)
    x2880 = x1451 * x2366 + x1454
    x2881 = x2880 * x3
    x2882 = x1451 * x2368 + x1457
    x2883 = x2882 * x49
    x2884 = 5.0 * x2883
    x2885 = x1451 * x2360 + x1466 - x60 * (x1451 * x2363 + x1469)
    x2886 = x2885 * x85
    x2887 = x49 * (x1451 * x2375 + x1463)
    x2888 = x1451 * x2388 + x1474
    x2889 = x1451 * x2389 + x1477
    x2890 = x2889 * x49
    x2891 = x1451 * x2382 + x1489 - x60 * (x1451 * x2385 + x1491)
    x2892 = x2891 * x85
    x2893 = x49 * (x1451 * x2393 + x1486)
    x2894 = x1451 * x2407 + x1510 + x2369
    x2895 = x2894 * x3
    x2896 = x1451 * x2409 + x1518 + x2376
    x2897 = x2896 * x49
    x2898 = 4.0 * x2897
    x2899 = x1451 * x2401 + x1536 + x2362 - x60 * (x1451 * x2404 + x1538 + x2365)
    x2900 = x2899 * x85
    x2901 = x49 * (x1451 * x2416 + x1532 + x2381)
    x2902 = x1451 * x2432 + x1546
    x2903 = x1451 * x2433 + x1549
    x2904 = x2903 * x49
    x2905 = 3.0 * x2904
    x2906 = x1451 * x2424 + x1559 - x60 * (x1451 * x2428 + x1561)
    x2907 = x2906 * x85
    x2908 = x49 * (x1451 * x2438 + x1557)
    x2909 = x1451 * x2448 + x1571 + x2390
    x2910 = x1451 * x2449 + x1576 + x2394
    x2911 = x1451 * x2444 + x1591 + x2384 - x60 * (x1451 * x2446 + x1593 + x2387)
    x2912 = x2911 * x85
    x2913 = x153 * (x1451 * x2452 + x1588 + x2399)
    x2914 = x1451 * x2466 + x1613 + 2.0 * x2410
    x2915 = x2914 * x3
    x2916 = x1451 * x2468 + x1622 + 2.0 * x2417
    x2917 = x2916 * x49
    x2918 = 3.0 * x2917
    x2919 = (
        x1451 * x2458 + x1638 + 2.0 * x2403 - x60 * (x1451 * x2462 + x1640 + 2.0 * x2406)
    )
    x2920 = x2919 * x85
    x2921 = x49 * (x1451 * x2475 + x1635 + x2423)
    x2922 = x1451 * x2489 + x1648
    x2923 = x1451 * x2490 + x1652
    x2924 = x2923 * x49
    x2925 = x1451 * x2482 + x1661 - x60 * (x1451 * x2485 + x1663)
    x2926 = x2925 * x85
    x2927 = x49 * (x1451 * x2494 + x1659)
    x2928 = x1451 * x2505 + x1679 + x2434
    x2929 = x1451 * x2506 + x1684 + x2439
    x2930 = x153 * x2929
    x2931 = x1451 * x2499 + x1696 + x2426 - x60 * (x1451 * x2502 + x1698 + x2430)
    x2932 = x2931 * x85
    x2933 = x49 * (x1451 * x2510 + x1693 + x2443)
    x2934 = x1451 * x2521 + x1711 + x2833
    x2935 = x1451 * x2522 + x1716 + x2453
    x2936 = x153 * x2935
    x2937 = x1451 * x2515 + x1728 + x2836 - x60 * (x1451 * x2518 + x1730 + x2837)
    x2938 = x2937 * x85
    x2939 = x49 * (x1451 * x2526 + x1725 + x2839)
    x2940 = x1451 * x2537 + x1751 + x2470
    x2941 = x2940 * x3
    x2942 = x1451 * x2539 + x1758 + 3.0 * x2476
    x2943 = x2942 * x49
    x2944 = 2.0 * x2943
    x2945 = x1451 * x2531 + x1771 + x2461 - x60 * (x1451 * x2534 + x1773 + x2465)
    x2946 = x2945 * x85
    x2947 = x49 * (x1451 * x2545 + x1768 + 3.0 * x2481)
    x2948 = x1451 * x2558 + x1775
    x2949 = x2948 * x49
    x2950 = x1451 * x2562 + x1783
    x2951 = x1451 * x2553 + x1785 - x60 * (x1451 * x2557 + x1787)
    x2952 = x2951 * x85
    x2953 = x1451 * x2571 + x1794 + x2495
    x2954 = x2953 * x49
    x2955 = x1451 * x2575 + x1805 + x2491
    x2956 = x1451 * x2567 + x1808 + x2484 - x60 * (x1451 * x2570 + x1810 + x2488)
    x2957 = x2956 * x85
    x2958 = x1451 * x2584 + x1817 + 2.0 * x2511
    x2959 = x2958 * x49
    x2960 = x1451 * x2588 + x1828 + x2507
    x2961 = x1451 * x2580 + x1831 + x2501 - x60 * (x1451 * x2583 + x1833 + x2504)
    x2962 = x2961 * x85
    x2963 = x1451 * x2597 + x1839 + 3.0 * x2527
    x2964 = x2963 * x49
    x2965 = x116 * x2522 + x1451 * x2601 + x1850
    x2966 = (
        x116 * x2516
        + x1451 * x2593
        + x1853
        - x60 * (x116 * x2519 + x1451 * x2596 + x1855)
    )
    x2967 = x2966 * x85
    x2968 = x1451 * x2610 + x1863 + 4.0 * x2546
    x2969 = x2968 * x49
    x2970 = x1451 * x2614 + x1878 + 4.0 * x2540
    x2971 = x2970 * x3
    x2972 = (
        x1451 * x2606 + x1882 + 4.0 * x2533 - x60 * (x1451 * x2609 + x1884 + 4.0 * x2536)
    )
    x2973 = x2972 * x85
    x2974 = x1451 * x2623 + x1886
    x2975 = x1451 * x2620 + x1888 - x60 * (x1451 * x2621 + x1890)
    x2976 = x2975 * x85
    x2977 = x1451 * x2629 + x1896 + x2561
    x2978 = x1451 * x2626 + x1899 + x2552 - x60 * (x1451 * x2627 + x1901 + x2555)
    x2979 = x2978 * x85
    x2980 = x1451 * x2635 + x1907 + 2.0 * x2574
    x2981 = (
        x1451 * x2632 + x1910 + 2.0 * x2566 - x60 * (x1451 * x2633 + x1912 + 2.0 * x2569)
    )
    x2982 = x2981 * x85
    x2983 = x1451 * x2641 + x1918 + x2870
    x2984 = x1451 * x2638 + x1921 + x2872 - x60 * (x1451 * x2639 + x1923 + x2873)
    x2985 = x2984 * x85
    x2986 = x1451 * x2647 + x1929 + 4.0 * x2600
    x2987 = (
        x1451 * x2644 + x1932 + 4.0 * x2592 - x60 * (x1451 * x2645 + x1934 + 4.0 * x2595)
    )
    x2988 = x2987 * x85
    x2989 = x1451 * x2653 + x1941 + 5.0 * x2613
    x2990 = (
        x1451 * x2650 + x1944 + 5.0 * x2605 - x60 * (x1451 * x2651 + x1946 + 5.0 * x2608)
    )
    x2991 = x2990 * x85
    x2992 = x1024 * x2657 + x134 * x1961
    x2993 = x49 * (x1024 * x2658 + x134 * x1966)
    x2994 = x1024 * x2662 + x134 * x1978 + x2659
    x2995 = x1024 * x2663 + x134 * x1982 + x2661
    x2996 = x1024 * x2666 + x134 * x1994
    x2997 = x49 * (x1024 * x2667 + x134 * x1998)
    x2998 = x1024 * x2671 + x134 * x2010 + x153 * x2663
    x2999 = x116 * (x1024 * x2672 + x134 * x2013 + x153 * x2665)
    x3000 = x1024 * x2676 + x134 * x2021 + x2668
    x3001 = x1024 * x2677 + x134 * x2025 + x2670
    x3002 = x1024 * x2680 + x134 * x2036
    x3003 = x49 * (x1024 * x2681 + x134 * x2040)
    x3004 = x1024 * x2685 + x134 * x2048 + x2673
    x3005 = x1024 * x2686 + x116 * x2675 + x134 * x2052
    x3006 = x1024 * x2689 + x134 * x2059 + x153 * x2677
    x3007 = x1024 * x2690 + x134 * x2063 + x2679
    x3008 = x1024 * x2693 + x134 * x2073 + x2682
    x3009 = x153 * (x1024 * x2694 + x134 * x2077 + x2684)
    x3010 = x1024 * x2698 + x134 * x2088
    x3011 = x49 * (x1024 * x2699 + x134 * x2092)
    x3012 = x49 * (x1024 * x2703 + x134 * x2100 + 4.0 * x2688)
    x3013 = x1024 * x2705 + x134 * x2103 + x2686 * x98
    x3014 = x49 * (x1024 * x2707 + x134 * x2111 + 3.0 * x2692)
    x3015 = x1024 * x2709 + x116 * x2690 + x134 * x2114
    x3016 = x49 * (x1024 * x2711 + x134 * x2122 + 2.0 * x2697)
    x3017 = x1024 * x2713 + x134 * x2125 + x2695
    x3018 = x49 * (x1024 * x2715 + x134 * x2133 + x2702)
    x3019 = x1024 * x2717 + x134 * x2136 + x2700
    x3020 = x49 * (x1024 * x2719 + x134 * x2145)
    x3021 = x1024 * x2721 + x134 * x2148
    x3022 = x1024 * x2723 + x134 * x2153 + 5.0 * x2704
    x3023 = x1024 * x2725 + x134 * x2158 + 4.0 * x2708
    x3024 = x1024 * x2727 + x134 * x2163 + 3.0 * x2712
    x3025 = x1024 * x2729 + x134 * x2168 + 2.0 * x2716
    x3026 = x1024 * x2731 + x134 * x2173 + x2720
    x3027 = x1024 * x2733 + x134 * x2178
    x3028 = x1024 * x2735 + x2179
    x3029 = x49 * (x1024 * x2736 + x2181)
    x3030 = x1024 * x2740 + x2194 + x2737
    x3031 = x1024 * x2741 + x2198 + x2739
    x3032 = x1024 * x2744 + x2202
    x3033 = x49 * (x1024 * x2745 + x2204)
    x3034 = x1024 * x2749 + x153 * x2741 + x2214
    x3035 = x116 * (x1024 * x2750 + x153 * x2743 + x2217)
    x3036 = x1024 * x2754 + x2225 + x2746
    x3037 = x1024 * x2755 + x2229 + x2748
    x3038 = x1024 * x2758 + x2232
    x3039 = x49 * (x1024 * x2759 + x2234)
    x3040 = x1024 * x2763 + x2242 + x2751
    x3041 = x1024 * x2764 + x116 * x2753 + x2246
    x3042 = x1024 * x2767 + x153 * x2755 + x2256
    x3043 = x1024 * x2768 + x2261 + x2757
    x3044 = x1024 * x2771 + x2271 + x2760
    x3045 = x153 * (x1024 * x2772 + x2275 + x2762)
    x3046 = x1024 * x2776 + x2277
    x3047 = x49 * (x1024 * x2777 + x2280)
    x3048 = x49 * (x1024 * x2781 + x2288 + 4.0 * x2766)
    x3049 = x1024 * x2783 + x2291 + x2764 * x98
    x3050 = x49 * (x1024 * x2785 + x2299 + 3.0 * x2770)
    x3051 = x1024 * x2787 + x116 * x2768 + x2302
    x3052 = x49 * (x1024 * x2789 + x2310 + 2.0 * x2775)
    x3053 = x1024 * x2791 + x2313 + x2773
    x3054 = x49 * (x1024 * x2793 + x2321 + x2780)
    x3055 = x1024 * x2795 + x2324 + x2778
    x3056 = x49 * (x1024 * x2797 + x2327)
    x3057 = x1024 * x2799 + x2329
    x3058 = x1024 * x2801 + x2334 + 5.0 * x2782
    x3059 = x1024 * x2803 + x2339 + 4.0 * x2786
    x3060 = x1024 * x2805 + x2347 + 3.0 * x2790
    x3061 = x1024 * x2807 + x2352 + 2.0 * x2794
    x3062 = x1024 * x2809 + x2357 + x2798
    x3063 = x1024 * x2811 + x2358
    x3064 = x1948 * x2366 + x2373
    x3065 = x49 * (x1948 * x2368 + x2380)
    x3066 = x1024 * x2369 + x1024 * x2814 + x2392
    x3067 = x1024 * x2376 + x1024 * x2815 + x2397
    x3068 = x1948 * x2407 + x2414
    x3069 = x49 * (x1948 * x2409 + x2421)
    x3070 = x1024 * x2819 + x153 * x2815 + x2437
    x3071 = x116 * (x1024 * x2820 + x153 * x2817 + x2442)
    x3072 = x1024 * x2410 + x1024 * x2824 + x2451
    x3073 = x1024 * x2417 + x1024 * x2825 + x2456
    x3074 = x1948 * x2466 + x2473
    x3075 = x49 * (x1948 * x2468 + x2480)
    x3076 = x1024 * x2829 + x2493 + x2821
    x3077 = x1024 * x2830 + x116 * x2823 + x2498
    x3078 = x1024 * x2834 + x153 * x2825 + x2509
    x3079 = x1024 * x2835 + x2514 + x2827
    x3080 = x1024 * x2469 + x1024 * x2841 + x2525
    x3081 = x153 * (x1024 * x2476 + x1024 * x2842 + x2530)
    x3082 = x1948 * x2537 + x2544
    x3083 = x49 * (x1948 * x2539 + x2550)
    x3084 = x49 * (x1024 * x2848 + x2560 + 4.0 * x2832)
    x3085 = x1024 * x2850 + x2564 + x2830 * x98
    x3086 = x49 * (x1024 * x2852 + x2573 + 3.0 * x2840)
    x3087 = x1024 * x2854 + x116 * x2835 + x2577
    x3088 = x49 * (x1024 * x2856 + x2586 + 2.0 * x2845)
    x3089 = x1024 * x2858 + x2590 + x2843
    x3090 = x49 * (x1024 * x2860 + x2599 + x2847)
    x3091 = x1024 * x2540 + x1024 * x2862 + x2603
    x3092 = x49 * (x1948 * x2610 + x2612)
    x3093 = x1948 * x2614 + x2618
    x3094 = x1024 * x2866 + x2625 + 5.0 * x2849
    x3095 = x1024 * x2868 + x2631 + 4.0 * x2853
    x3096 = x1024 * x2871 + x2637 + 3.0 * x2857
    x3097 = x1024 * x2875 + x2643 + 2.0 * x2861
    x3098 = x1024 * x2877 + x2649 + x2864
    x3099 = x1948 * x2653 + x2656
    x3100 = x1024 * x2888 + x2883
    x3101 = x1024 * x2889 + x2887
    x3102 = x1024 * x2902 + 2.0 * x2890
    x3103 = x116 * (x1024 * x2903 + 2.0 * x2893)
    x3104 = x1024 * x2909 + x2897
    x3105 = x1024 * x2910 + x2901
    x3106 = x1024 * x2922 + x2905
    x3107 = x1024 * x2923 + 3.0 * x2908
    x3108 = x153 * x2910
    x3109 = x1024 * x2928 + x3108
    x3110 = x1024 * x2929 + x2913
    x3111 = x1024 * x2934 + x2917
    x3112 = x153 * (x1024 * x2935 + x2921)
    x3113 = x49 * (x1024 * x2948 + 4.0 * x2927)
    x3114 = x1024 * x2950 + 4.0 * x2924
    x3115 = x49 * (x1024 * x2953 + 3.0 * x2933)
    x3116 = x1024 * x2955 + x116 * x2929
    x3117 = x49 * (x1024 * x2958 + 2.0 * x2939)
    x3118 = x1024 * x2960 + x2936
    x3119 = x49 * (x1024 * x2963 + x2947)
    x3120 = x1024 * x2965 + x2943
    x3121 = x1024 * x2969
    x3122 = x1024 * x2974 + 5.0 * x2949
    x3123 = x1024 * x2977 + 4.0 * x2954
    x3124 = 3.0 * x2959
    x3125 = x1024 * x2980 + x3124
    x3126 = x1024 * x2983 + 2.0 * x2964
    x3127 = x1024 * x2986 + x2969
    x3128 = x134 * x2372 + x1451 * x2880
    x3129 = x49 * (x134 * x2379 + x1451 * x2882)
    x3130 = x134 * x2391 + x1451 * x2888
    x3131 = x49 * (x134 * x2396 + x1451 * x2889)
    x3132 = x134 * x2413 + x1451 * x2894 + x2883
    x3133 = x49 * (x134 * x2420 + x1451 * x2896 + x2887)
    x3134 = x134 * x2436 + x1451 * x2902
    x3135 = x49 * (x134 * x2441 + x1451 * x2903)
    x3136 = 3.0 * x3135
    x3137 = x134 * x2450 + x1451 * x2909 + x2890
    x3138 = x134 * x2455 + x1451 * x2910 + x2893
    x3139 = x134 * x2472 + x1451 * x2914 + 2.0 * x2897
    x3140 = x49 * (x134 * x2479 + x1451 * x2916 + 2.0 * x2901)
    x3141 = 3.0 * x3140
    x3142 = x134 * x2492 + x1451 * x2922
    x3143 = x49 * (x134 * x2497 + x1451 * x2923)
    x3144 = x134 * x2508 + x1451 * x2928 + x2904
    x3145 = x134 * x2513 + x1451 * x2929 + x2908
    x3146 = x153 * x3145
    x3147 = x134 * x2524 + x1451 * x2934 + x3108
    x3148 = x134 * x2529 + x1451 * x2935 + x2913
    x3149 = x153 * x3148
    x3150 = x134 * x2543 + x1451 * x2940 + x2918
    x3151 = x49 * (x134 * x2549 + x1451 * x2942 + 3.0 * x2921)
    x3152 = x49 * (x134 * x2559 + x1451 * x2948)
    x3153 = x134 * x2563 + x1451 * x2950
    x3154 = x49 * (x134 * x2572 + x1451 * x2953 + x2927)
    x3155 = x134 * x2576 + x1451 * x2955 + x2924
    x3156 = x49 * (x134 * x2585 + x1451 * x2958 + 2.0 * x2933)
    x3157 = x134 * x2589 + x1451 * x2960 + x2930
    x3158 = x49 * (x134 * x2598 + x1451 * x2963 + 3.0 * x2939)
    x3159 = x116 * x2935 + x134 * x2602 + x1451 * x2965
    x3160 = x49 * (x134 * x2611 + x1451 * x2968 + 4.0 * x2947)
    x3161 = x134 * x2617 + x1451 * x2970 + 4.0 * x2943
    x3162 = x134 * x2624 + x1451 * x2974
    x3163 = x134 * x2630 + x1451 * x2977 + x2949
    x3164 = x134 * x2636 + x1451 * x2980 + 2.0 * x2954
    x3165 = x134 * x2642 + x1451 * x2983 + x3124
    x3166 = x134 * x2648 + x1451 * x2986 + 4.0 * x2964
    x3167 = x134 * x2655 + x1451 * x2989 + 5.0 * x2969
    x3168 = x153 * x3138
    x3169 = 3.0 * x3156

    # 441 item(s)
    return numpy.array(
        [
            x149
            * (
                x133 * x3
                + x144 * x91
                + x4 * (x131 * x3 + 5.0 * x138 - x140 * x60)
                - x60 * (x123 * x3 + x148 * x91 + x4 * (x140 - x60 * x74))
            )
            + x3
            * (
                x118 * x91
                + x134 * (-x123 * x60 + x133)
                + x3
                * (
                    x3 * (x3 * (x81 + x83) + x86 + x90 * x91)
                    + x4 * (-x59 * x60 + x74)
                    + x91 * x99
                )
            )
            + x91
            * (
                x118 * x3
                + x134 * (x144 - x148 * x60)
                + x98
                * (
                    x116 * (x115 * x3 + x150 + x153 * (x151 + x152 * x53))
                    + x117 * x3
                    + x4 * (x143 - x147 * x60)
                )
            ),
            x149
            * (
                x234 * x3
                + x242 * x98
                + x4 * (x232 * x3 + 4.0 * x236 - x238 * x60)
                - x60 * (x229 * x3 + x247 * x98 + x4 * (-x185 * x60 + x238))
            )
            + x3
            * (
                x134 * (-x229 * x60 + x234)
                + x222 * x98
                + x3
                * (
                    x206 * x98
                    + x3 * (x194 + x198 * x98 + x3 * (x190 + x192))
                    + x4 * (-x175 * x60 + x185)
                )
            )
            + x98
            * (
                x116
                * (
                    x153 * (x217 * x3 + x220 * x3 + x249)
                    + x221 * x3
                    + x4 * (x241 - x246 * x60)
                )
                + x134 * (x242 - x247 * x60)
                + x222 * x3
            ),
            x149
            * (
                x3 * x330
                + x338 * x98
                + x4 * (x3 * x328 + 4.0 * x332 - x334 * x60)
                - x60 * (x3 * x324 + x342 * x98 + x4 * (-x280 * x60 + x334))
            )
            + x3
            * (
                x134 * (-x324 * x60 + x330)
                + x3
                * (
                    x3 * (x289 + x293 * x98 + x3 * (x285 + x287))
                    + x302 * x98
                    + x4 * (-x270 * x60 + x280)
                )
                + x318 * x98
            )
            + x98
            * (
                x116
                * (
                    x153 * (x3 * x313 + x3 * x316 + x344)
                    + x3 * x317
                    + x4 * (x337 - x341 * x60)
                )
                + x134 * (x338 - x342 * x60)
                + x3 * x318
            ),
            x116
            * (
                x134 * (x421 - x425 * x60)
                + x153
                * (x3 * x400 + x4 * (x420 - x424 * x60) + x49 * (x346 * x426 + x427))
                + x3 * x401
            )
            + x149
            * (
                x116 * x421
                + x3 * x410
                + x4 * (x3 * x408 + x414 - x417 * x60)
                - x60 * (x116 * x425 + x3 * x404 + x4 * (-x371 * x60 + x417))
            )
            + x3
            * (
                x116 * x401
                + x134 * (-x404 * x60 + x410)
                + x3
                * (
                    x116 * x390
                    + x3 * (x116 * x384 + x3 * (x377 + x379) + x381)
                    + x4 * (-x361 * x60 + x371)
                )
            ),
            x116
            * (
                x134 * (x472 - x475 * x60)
                + x153
                * (x3 * x457 + x4 * (x471 - x474 * x60) + x49 * (x426 * x447 + x477))
                + x3 * x458
            )
            + x149
            * (
                x116 * x472
                + x3 * x466
                + x4 * (x116 * x468 + x3 * x464 - x469 * x60)
                - x60 * (x116 * x475 + x3 * x461 + x4 * (-x439 * x60 + x469))
            )
            + x3
            * (
                x116 * x458
                + x134 * (-x461 * x60 + x466)
                + x3
                * (
                    x116 * x451
                    + x3 * (x116 * x444 + x3 * (x116 * x429 + x3 * x441) + x442)
                    + x4 * (-x433 * x60 + x439)
                )
            ),
            x116
            * (
                x134 * (x564 - x569 * x60)
                + x153
                * (x3 * x539 + x4 * (x563 - x568 * x60) + x49 * (x426 * x479 + x570))
                + x3 * x540
            )
            + x149
            * (
                x116 * x564
                + x3 * x552
                + x4 * (x3 * x550 + x557 - x560 * x60)
                - x60 * (x116 * x569 + x3 * x543 + x4 * (-x509 * x60 + x560))
            )
            + x3
            * (
                x116 * x540
                + x134 * (-x543 * x60 + x552)
                + x3
                * (
                    x116 * x529
                    + x3 * (x116 * x523 + x3 * (x516 + x518) + x520)
                    + x4 * (-x497 * x60 + x509)
                )
            ),
            x149
            * (
                x153 * x623
                + x3 * x618
                + x4 * (x153 * x621 + x3 * x616 - x60 * x620)
                - x60 * (x153 * x625 + x3 * x614 + x4 * (-x585 * x60 + x620))
            )
            + x153
            * (
                x134 * (-x60 * x625 + x623)
                + x3 * x609
                + x49 * (x3 * x608 + x4 * (x3 * x580 - x3 * x606))
            )
            + x3
            * (
                x134 * (-x60 * x614 + x618)
                + x153 * x609
                + x3
                * (
                    x153 * x598
                    + x3 * (x153 * x594 + x3 * (x153 * x590 + x589) + x592)
                    + x4 * (-x579 * x60 + x585)
                )
            ),
            x149
            * (
                x153 * x673
                + x3 * x666
                + x4 * (x3 * x664 - x60 * x669 + x671)
                - x60 * (x153 * x675 + x3 * x662 + x4 * (-x60 * x640 + x669))
            )
            + x153
            * (
                x134 * (-x60 * x675 + x673)
                + x3 * x657
                + x49 * (x3 * x656 + x4 * (x3 * x635 - x3 * x654))
            )
            + x3
            * (
                x134 * (-x60 * x662 + x666)
                + x153 * x657
                + x3
                * (
                    x153 * x649
                    + x3 * (x153 * x647 + x3 * (x3 * x643 + x645) + x646)
                    + x4 * (-x60 * x634 + x640)
                )
            ),
            x149
            * (
                x153 * x721
                + x3 * x714
                + x4 * (x3 * x712 - x60 * x717 + x719)
                - x60 * (x153 * x723 + x3 * x710 + x4 * (-x60 * x687 + x717))
            )
            + x153
            * (
                x134 * (-x60 * x723 + x721)
                + x3 * x705
                + x49 * (x3 * x704 + x4 * (x155 * x3 * x491 - x3 * x702))
            )
            + x3
            * (
                x134 * (-x60 * x710 + x714)
                + x153 * x705
                + x3
                * (
                    x153 * x697
                    + x3 * (x153 * x694 + x3 * (x3 * x689 + x691) + x692)
                    + x4 * (-x60 * x680 + x687)
                )
            ),
            x149
            * (
                x153 * x781
                + x3 * x775
                + x4 * (x153 * x778 + x3 * x773 - x60 * x777)
                - x60 * (x153 * x784 + x3 * x770 + x4 * (-x60 * x740 + x777))
            )
            + x153
            * (
                x134 * (-x60 * x784 + x781)
                + x3 * x764
                + x49 * (x3 * x763 + x4 * (x3 * x734 - x3 * x761))
            )
            + x3
            * (
                x134 * (-x60 * x770 + x775)
                + x153 * x764
                + x3
                * (
                    x153 * x753
                    + x3 * (x153 * x750 + x3 * (x153 * x746 + x745) + x748)
                    + x4 * (-x60 * x733 + x740)
                )
            ),
            x149
            * (
                x3 * x819
                + x4 * (x3 * x821 - x60 * x823 + x820)
                + x49 * x799
                - x60 * (x3 * x814 + x4 * (-x60 * x806 + x823) + x49 * x796)
            )
            + x3
            * (
                x134 * (-x60 * x814 + x819)
                + x3
                * (
                    x3 * (x3 * (x807 + x809) + x810 + x811)
                    + x4 * (-x60 * x802 + x806)
                    + x49 * x792
                )
                + x49 * x793
            )
            + x49 * (x134 * (-x60 * x796 + x799) + x3 * x793),
            x149
            * (
                x3 * x850
                + x4 * (x3 * x852 - x60 * x854 + x851)
                + x49 * x836
                - x60 * (x3 * x846 + x4 * (-x60 * x841 + x854) + x49 * x833)
            )
            + x3
            * (
                x134 * (-x60 * x846 + x850)
                + x3
                * (
                    x3 * (x3 * x842 + x3 * (x152 * x843 + x842) + x844)
                    + x4 * (-x60 * x838 + x841)
                    + x49 * x829
                )
                + x49 * x830
            )
            + x49 * (x134 * (-x60 * x833 + x836) + x3 * x830),
            x149
            * (
                x3 * x881
                + x4 * (x3 * x883 - x60 * x885 + x882)
                + x49 * x867
                - x60 * (x3 * x877 + x4 * (-x60 * x872 + x885) + x49 * x864)
            )
            + x3
            * (
                x134 * (-x60 * x877 + x881)
                + x3
                * (
                    x3 * (x3 * x873 + x3 * (x152 * x874 + x873) + x875)
                    + x4 * (-x60 * x869 + x872)
                    + x49 * x860
                )
                + x49 * x861
            )
            + x49 * (x134 * (-x60 * x864 + x867) + x3 * x861),
            x149
            * (
                x3 * x908
                + x4 * (x3 * x912 + x49 * x909 - x60 * x911)
                + x49 * x896
                - x60 * (x3 * x905 + x4 * (-x60 * x900 + x911) + x49 * x894)
            )
            + x3
            * (
                x134 * (-x60 * x905 + x908)
                + x3
                * (
                    x3 * (x3 * x901 + x3 * (x218 * x741 + x901) + x902)
                    + x4 * (-x60 * x898 + x900)
                    + x49 * x890
                )
                + x49 * x891
            )
            + x49 * (x134 * (-x60 * x894 + x896) + x3 * x891),
            x149
            * (
                x3 * x947
                + x4 * (x3 * x949 - x60 * x951 + x948)
                + x49 * x927
                - x60 * (x3 * x942 + x4 * (-x60 * x934 + x951) + x49 * x924)
            )
            + x3
            * (
                x134 * (-x60 * x942 + x947)
                + x3
                * (
                    x3 * (x3 * (x935 + x937) + x938 + x939)
                    + x4 * (-x60 * x930 + x934)
                    + x49 * x919
                )
                + x49 * x920
            )
            + x49 * (x134 * (-x60 * x924 + x927) + x3 * x920),
            x149
            * (
                x3 * x966
                + x4 * (-x3 * x60 * x960 + x3 * x964)
                - x60 * (x3 * x962 + x4 * (-x3 * x60 * x952 + x3 * x960))
            )
            + x3
            * (
                x134 * (-x60 * x962 + x966)
                + x3 * (x3 * (x957 + x958) + x4 * (x3 * x952 - x955))
            ),
            x149
            * (
                x3 * x977
                + x4 * (-x3 * x60 * x972 + x3 * x975)
                - x60 * (x3 * x974 + x4 * (-x3 * x60 * x967 + x3 * x972))
            )
            + x3
            * (
                x134 * (-x60 * x974 + x977)
                + x3 * (x3 * (x426 * x970 + x971) + x4 * (x3 * x967 - x3 * x969))
            ),
            x149
            * (
                x3 * x988
                + x4 * (-x3 * x60 * x983 + x3 * x986)
                - x60 * (x3 * x985 + x4 * (-x3 * x60 * x978 + x3 * x983))
            )
            + x3
            * (
                x134 * (-x60 * x985 + x988)
                + x3 * (x3 * (x426 * x981 + x982) + x4 * (x3 * x978 - x3 * x980))
            ),
            x149
            * (
                x3 * x999
                + x4 * (-x3 * x60 * x994 + x3 * x997)
                - x60 * (x3 * x996 + x4 * (-x3 * x60 * x989 + x3 * x994))
            )
            + x3
            * (
                x134 * (-x60 * x996 + x999)
                + x3 * (x3 * (x426 * x992 + x993) + x4 * (x3 * x989 - x3 * x991))
            ),
            x149
            * (
                x1009 * x3
                + x4 * (x155 * x3 * x922 - x155 * x60 * x945)
                - x60 * (x1006 * x3 + x4 * (-x1004 * x3 * x60 + x155 * x3 * x913))
            )
            + x3
            * (
                x134 * (-x1006 * x60 + x1009)
                + x3
                * (x3 * (x1002 + x1003 * x426) + x4 * (-x1001 * x3 + x155 * x3 * x914))
            ),
            x149
            * (
                x1023 * x3
                + x4 * (-x1017 * x3 * x60 + x1021 * x3)
                - x60 * (x1019 * x3 + x4 * (-x1010 * x3 * x60 + x1017 * x3))
            )
            + x3
            * (
                x134 * (-x1019 * x60 + x1023)
                + x3 * (x3 * (x1014 + x1015) + x4 * (x1010 * x3 - x1012 * x3))
            ),
            x134
            * (
                x1030 * x3
                + x1046 * x91
                + 0.5 * x1050
                - x60 * (x1027 * x3 + x1044 * x91 + 0.5 * x1051)
            )
            + x3
            * (
                x1043 * x91
                + x3 * (0.5 * x1034 + x1037 * x91 + x3 * (x1031 + x1032))
                + x4 * (-x1027 * x60 + x1030)
            )
            + x91
            * (
                x1043 * x3
                + x4 * (-x1044 * x60 + x1046)
                + x98 * (x1042 * x3 + 0.5 * x1047 + x116 * (x1024 * x110 + x1048 * x1049))
            ),
            x134
            * (
                x1061 * x3
                + x1082 * x98
                + 0.5 * x1086
                - x60 * (x1056 * x3 + x1080 * x98 + 0.5 * x1087)
            )
            + x3
            * (
                x1078 * x98
                + x3 * (0.5 * x1066 + x1069 * x98 + x3 * (x1063 * x3 + x1065 * x98))
                + x4 * (-x1056 * x60 + x1061)
            )
            + x98
            * (
                x1078 * x3
                + x116 * (x1077 * x3 + 0.5 * x1083 + x153 * (x1075 * x3 + x1084))
                + x4 * (-x1080 * x60 + x1082)
            ),
            x134
            * (
                x1090 * x3
                + x1098 * x98
                + 0.5 * x1101
                - x60 * (x1088 * x3 + x1096 * x98 + 0.5 * x1102)
            )
            + x3
            * (
                x1095 * x98
                + x3 * (0.5 * x1091 + x1092 * x98 + x3 * (x1024 * x285 + x1024 * x287))
                + x4 * (-x1088 * x60 + x1090)
            )
            + x98
            * (
                x1095 * x3
                + x116 * (x1094 * x3 + 0.5 * x1099 + x153 * (x1024 * x315 + x1100))
                + x4 * (-x1096 * x60 + x1098)
            ),
            x116
            * (
                x1134 * x3
                + x153 * (x1132 * x3 + x1133 * x3 + 0.5 * x1139)
                + x4 * (-x1136 * x60 + x1138)
            )
            + x134
            * (
                x1116 * x3
                + x1138 * x116
                + 0.5 * x1141
                - x60 * (x1110 * x3 + x1136 * x116 + 0.5 * x1142)
            )
            + x3
            * (
                x1134 * x116
                + x3 * (0.5 * x1124 + x1127 * x116 + x3 * (x1119 * x3 + x1123))
                + x4 * (-x1110 * x60 + x1116)
            ),
            x116
            * (
                x1159 * x3
                + x153 * (x1157 * x3 + x1158 * x3 + 0.5 * x1166)
                + x4 * (-x1162 * x60 + x1165)
            )
            + x134
            * (
                x1148 * x3
                + x116 * x1165
                + 0.5 * x1168
                - x60 * (x1145 * x3 + x116 * x1162 + 0.5 * x1169)
            )
            + x3
            * (
                x1159 * x116
                + x3 * (0.5 * x1151 + x1154 * x116 + x3 * (x1149 * x3 + x1150 * x116))
                + x4 * (-x1145 * x60 + x1148)
            ),
            x116
            * (
                x1178 * x3
                + x153 * (x1024 * x538 + x1177 * x3 + 0.5 * x1182)
                + x4 * (-x1179 * x60 + x1181)
            )
            + x134
            * (
                x116 * x1181
                + x1172 * x3
                + 0.5 * x1183
                - x60 * (x116 * x1179 + x1170 * x3 + 0.5 * x1184)
            )
            + x3
            * (
                x116 * x1178
                + x3 * (x116 * x1174 + 0.5 * x1173 + x3 * (x1024 * x516 + x1024 * x518))
                + x4 * (-x1170 * x60 + x1172)
            ),
            x134
            * (
                x1196 * x3
                + x1214 * x153
                + 0.5 * x1217
                - x60 * (x1191 * x3 + x1211 * x153 + 0.5 * x1218)
            )
            + x153
            * (
                x1208 * x3
                + x4 * (-x1211 * x60 + x1214)
                + x49 * (x1204 * x426 + 0.5 * x1215)
            )
            + x3
            * (
                x1208 * x153
                + x3 * (0.5 * x1202 + x1206 * x153 + x3 * (x1198 * x3 + x1201 * x153))
                + x4 * (-x1191 * x60 + x1196)
            ),
            x134
            * (
                x1227 * x3
                + x1246 * x153
                + 0.5 * x1251
                - x60 * (x1223 * x3 + x1242 * x153 + 0.5 * x1252)
            )
            + x153
            * (
                x1238 * x3
                + x4 * (-x1242 * x60 + x1246)
                + x49 * (x1234 * x426 + 0.5 * x1247)
            )
            + x3
            * (
                x1238 * x153
                + x3 * (0.5 * x1231 + x1236 * x153 + x3 * (x1229 * x3 + x1230 * x153))
                + x4 * (-x1223 * x60 + x1227)
            ),
            x134
            * (
                x1261 * x3
                + x1277 * x153
                + 0.5 * x1280
                - x60 * (x1257 * x3 + x1274 * x153 + 0.5 * x1281)
            )
            + x153
            * (
                x1271 * x3
                + x4 * (-x1274 * x60 + x1277)
                + x49 * (x1267 * x426 + 0.5 * x1278)
            )
            + x3
            * (
                x1271 * x153
                + x3 * (0.5 * x1266 + x1269 * x153 + x3 * (x1262 * x3 + x1265))
                + x4 * (-x1257 * x60 + x1261)
            ),
            x134
            * (
                x1285 * x3
                + x1296 * x153
                + 0.5 * x1298
                - x60 * (x1283 * x3 + x1294 * x153 + 0.5 * x1299)
            )
            + x153
            * (
                x1292 * x3
                + x4 * (-x1294 * x60 + x1296)
                + x49 * (x1024 * x760 + 0.5 * x1297)
            )
            + x3
            * (
                x1292 * x153
                + x3 * (0.5 * x1287 + x1289 * x153 + x3 * (x1024 * x745 + x1286 * x153))
                + x4 * (-x1283 * x60 + x1285)
            ),
            x134
            * (
                x1302 * x3 * x49
                + x1319 * x3
                + 0.5 * x1325
                - x60 * (x1312 * x3 + x1315 * x3 + 0.5 * x1326)
            )
            + x3
            * (
                x1311 * x49
                + x3 * (x1320 * x3 + 0.5 * x1323 + x3 * (x1320 + x1322 * x3))
                + x4 * (-x1315 * x60 + x1319)
            )
            + x49 * (x1311 * x3 + x4 * (x1302 * x3 - x1306 * x3)),
            x134
            * (
                x1328 * x3 * x49
                + x1341 * x3
                + 0.5 * x1346
                - x60 * (x1336 * x3 + x1338 * x3 + 0.5 * x1347)
            )
            + x3
            * (
                x1335 * x49
                + x3 * (x1342 * x3 + 0.5 * x1344 + x3 * (x1342 + x1343 * x3))
                + x4 * (-x1338 * x60 + x1341)
            )
            + x49 * (x1335 * x3 + x4 * (x1328 * x3 - x1330 * x3)),
            x134
            * (
                x1348 * x3 * x49
                + x1360 * x3
                + 0.5 * x1365
                - x60 * (x1355 * x3 + x1357 * x3 + 0.5 * x1366)
            )
            + x3
            * (
                x1354 * x49
                + x3 * (x1361 * x3 + 0.5 * x1363 + x3 * (x1361 + x1362 * x3))
                + x4 * (-x1357 * x60 + x1360)
            )
            + x49 * (x1354 * x3 + x4 * (x1348 * x3 - x1350 * x3)),
            x134
            * (
                x1367 * x3 * x49
                + x1378 * x3
                + 0.5 * x1383
                - x60 * (x1373 * x3 + x1375 * x3 + 0.5 * x1384)
            )
            + x3
            * (
                x1372 * x49
                + x3 * (x1379 * x3 + 0.5 * x1381 + x3 * (x1379 + x1380 * x3))
                + x4 * (-x1375 * x60 + x1378)
            )
            + x49 * (x1372 * x3 + x4 * (x1367 * x3 - x1369 * x3)),
            x134
            * (
                x1024 * x946
                + x1391 * x3
                + 0.5 * x1394
                - x60 * (x1024 * x941 + x1389 * x3 + 0.5 * x1395)
            )
            + x3
            * (
                x1387 * x49
                + x3 * (x1024 * x939 + 0.5 * x1393 + x3 * (x1024 * x937 + x1392))
                + x4 * (-x1389 * x60 + x1391)
            )
            + x49 * (x1387 * x3 + x4 * (x1024 * x3 * x913 - x1385 * x915)),
            x134 * (x1398 * x426 + 0.5 * x1408 - x60 * (x1401 * x426 + 0.5 * x1409))
            + x3 * (x3 * (x1405 * x426 + 0.5 * x1406) + x4 * (x1398 * x3 - x1402 * x3)),
            x134 * (x1410 * x426 + 0.5 * x1416 - x60 * (x1411 * x426 + 0.5 * x1417))
            + x3 * (x3 * (x1413 * x426 + 0.5 * x1414) + x4 * (x1410 * x3 - x1412 * x3)),
            x134 * (x1419 * x426 + 0.5 * x1429 - x60 * (x1421 * x426 + 0.5 * x1430))
            + x3 * (x3 * (x1424 * x426 + 0.5 * x1425) + x4 * (x1419 * x3 - x1422 * x3)),
            x134 * (x1431 * x426 + 0.5 * x1437 - x60 * (x1432 * x426 + 0.5 * x1438))
            + x3 * (x3 * (x1434 * x426 + 0.5 * x1435) + x4 * (x1431 * x3 - x1433 * x3)),
            x134 * (x1439 * x426 + 0.5 * x1446 - x60 * (x1440 * x426 + 0.5 * x1447))
            + x3 * (x3 * (x1442 * x426 + 0.5 * x1443) + x4 * (x1439 * x3 - x1441 * x3)),
            x134 * (x1020 * x1024 + 0.5 * x1449 - x60 * (x1016 * x1024 + 0.5 * x1450))
            + x3
            * (
                x3 * (x1014 * x1024 + 0.5 * x1448)
                + x4 * (x1010 * x1024 * x3 - x1012 * x1385)
            ),
            x134
            * (
                x1453 * x3
                + x1462 * x91
                + x1467
                - x60 * (x1452 * x3 + x1461 * x91 + x1470)
            )
            + x3
            * (
                x1460 * x91
                + x3 * (x1455 + x1456 * x91 + x3 * (x1451 * x81 + x1451 * x83))
                + x4 * (-x1452 * x60 + x1453)
            )
            + x91
            * (
                x1460 * x3
                + x4 * (-x1461 * x60 + x1462)
                + x98 * (x116 * (x1049 * x1465 + x110 * x1451) + x1459 * x3 + x1464)
            ),
            x134
            * (
                x1473 * x3
                + x1485 * x98
                + x1490
                - x60 * (x1471 * x3 + x1483 * x98 + x1492)
            )
            + x3
            * (
                x1482 * x98
                + x3 * (x1475 + x1476 * x98 + x3 * (x1451 * x190 + x1451 * x192))
                + x4 * (-x1471 * x60 + x1473)
            )
            + x98
            * (
                x116 * (x1481 * x3 + x1487 + x153 * (x1451 * x219 + x1488))
                + x1482 * x3
                + x4 * (-x1483 * x60 + x1485)
            ),
            x134
            * (
                x1503 * x3
                + x1531 * x98
                + x1537
                - x60 * (x1498 * x3 + x1528 * x98 + x1539)
            )
            + x3
            * (
                x1525 * x98
                + x3 * (x1511 + x1516 * x98 + x3 * (x1505 + x1508))
                + x4 * (-x1498 * x60 + x1503)
            )
            + x98
            * (
                x116 * (x1524 * x3 + x153 * (x1521 * x3 + x1534) + x1533)
                + x1525 * x3
                + x4 * (-x1528 * x60 + x1531)
            ),
            x116
            * (
                x153 * (x1451 * x399 + x1552 * x3 + x1558)
                + x1553 * x3
                + x4 * (-x1554 * x60 + x1556)
            )
            + x134
            * (
                x116 * x1556
                + x1544 * x3
                + x1560
                - x60 * (x116 * x1554 + x1541 * x3 + x1562)
            )
            + x3
            * (
                x116 * x1553
                + x3 * (x116 * x1548 + x1547 + x3 * (x1451 * x377 + x1545))
                + x4 * (-x1541 * x60 + x1544)
            ),
            x116
            * (
                x153 * (x1579 * x3 + x1580 * x3 + x1589)
                + x1581 * x3
                + x4 * (-x1584 * x60 + x1587)
            )
            + x134
            * (
                x116 * x1587
                + x1568 * x3
                + x1592
                - x60 * (x116 * x1584 + x1565 * x3 + x1594)
            )
            + x3
            * (
                x116 * x1581
                + x3 * (x116 * x1575 + x1572 + x3 * (x116 * x1570 + x1569 * x3))
                + x4 * (-x1565 * x60 + x1568)
            ),
            x116
            * (
                x153 * (x1625 * x3 + x1627 * x3 + x1636)
                + x1628 * x3
                + x4 * (-x1631 * x60 + x1634)
            )
            + x134
            * (
                x116 * x1634
                + x1606 * x3
                + x1639
                - x60 * (x116 * x1631 + x1600 * x3 + x1641)
            )
            + x3
            * (
                x116 * x1628
                + x3 * (x116 * x1620 + x1614 + x3 * (x1608 + x1611))
                + x4 * (-x1600 * x60 + x1606)
            ),
            x134
            * (
                x153 * x1658
                + x1646 * x3
                + x1662
                - x60 * (x153 * x1656 + x1644 * x3 + x1664)
            )
            + x153
            * (x1654 * x3 + x4 * (-x1656 * x60 + x1658) + x49 * (x1451 * x605 + x1660))
            + x3
            * (
                x153 * x1654
                + x3 * (x153 * x1650 + x1649 + x3 * (x1451 * x589 + x153 * x1647))
                + x4 * (-x1644 * x60 + x1646)
            ),
            x134
            * (
                x153 * x1692
                + x1674 * x3
                + x1697
                - x60 * (x153 * x1689 + x1670 * x3 + x1699)
            )
            + x153
            * (x1686 * x3 + x4 * (-x1689 * x60 + x1692) + x49 * (x1681 * x426 + x1694))
            + x3
            * (
                x153 * x1686
                + x3 * (x153 * x1683 + x1680 + x3 * (x1675 * x3 + x1678))
                + x4 * (-x1670 * x60 + x1674)
            ),
            x134
            * (
                x153 * x1724
                + x1707 * x3
                + x1729
                - x60 * (x153 * x1721 + x1703 * x3 + x1731)
            )
            + x153
            * (x1718 * x3 + x4 * (-x1721 * x60 + x1724) + x49 * (x1713 * x426 + x1726))
            + x3
            * (
                x153 * x1718
                + x3 * (x153 * x1715 + x1712 + x3 * (x1708 * x3 + x1710))
                + x4 * (-x1703 * x60 + x1707)
            ),
            x134
            * (
                x153 * x1767
                + x1744 * x3
                + x1772
                - x60 * (x153 * x1764 + x1739 * x3 + x1774)
            )
            + x153
            * (x1761 * x3 + x4 * (-x1764 * x60 + x1767) + x49 * (x1753 * x426 + x1769))
            + x3
            * (
                x153 * x1761
                + x3 * (x153 * x1756 + x1752 + x3 * (x1746 + x1749))
                + x4 * (-x1739 * x60 + x1744)
            ),
            x134
            * (
                x1451 * x818
                + x1781 * x3
                + x1786
                - x60 * (x1451 * x813 + x1779 * x3 + x1788)
            )
            + x3
            * (
                x1777 * x49
                + x3 * (x1451 * x811 + x1784 + x3 * (x1451 * x809 + x1782))
                + x4 * (-x1779 * x60 + x1781)
            )
            + x49 * (x1777 * x3 + x4 * (x1451 * x3 * x785 - x1451 * x788)),
            x134
            * (
                x1789 * x3 * x49
                + x1802 * x3
                + x1809
                - x60 * (x1797 * x3 + x1799 * x3 + x1811)
            )
            + x3
            * (
                x1796 * x49
                + x3 * (x1803 * x3 + x1806 + x3 * (x1803 + x1804 * x3))
                + x4 * (-x1799 * x60 + x1802)
            )
            + x49 * (x1796 * x3 + x4 * (x1789 * x3 - x1791 * x3)),
            x134
            * (
                x1812 * x3 * x49
                + x1825 * x3
                + x1832
                - x60 * (x1820 * x3 + x1822 * x3 + x1834)
            )
            + x3
            * (
                x1819 * x49
                + x3 * (x1826 * x3 + x1829 + x3 * (x1826 + x1827 * x3))
                + x4 * (-x1822 * x60 + x1825)
            )
            + x49 * (x1819 * x3 + x4 * (x1812 * x3 - x1814 * x3)),
            x134
            * (
                x1835 * x3 * x49
                + x1847 * x3
                + x1854
                - x60 * (x1842 * x3 + x1844 * x3 + x1856)
            )
            + x3
            * (
                x1841 * x49
                + x3 * (x1848 * x3 + x1851 + x3 * (x1848 + x1849 * x3))
                + x4 * (-x1844 * x60 + x1847)
            )
            + x49 * (x1841 * x3 + x4 * (x1835 * x3 - x1837 * x3)),
            x134
            * (
                x1857 * x3 * x49
                + x1873 * x3
                + x1883
                - x60 * (x1866 * x3 + x1869 * x3 + x1885)
            )
            + x3
            * (
                x1865 * x49
                + x3 * (x1879 + x1880 + x3 * (x1874 + x1876))
                + x4 * (-x1869 * x60 + x1873)
            )
            + x49 * (x1865 * x3 + x4 * (x1857 * x3 - x1859 * x3)),
            x134 * (x1451 * x963 + x1889 - x60 * (x1451 * x959 + x1891))
            + x3
            * (x3 * (x1451 * x957 + x1887) + x4 * (x1451 * x3 * x952 - x1451 * x955)),
            x134 * (x1892 * x426 + x1900 - x60 * (x1893 * x426 + x1902))
            + x3 * (x3 * (x1895 * x426 + x1897) + x4 * (x1892 * x3 - x1894 * x3)),
            x134 * (x1903 * x426 + x1911 - x60 * (x1904 * x426 + x1913))
            + x3 * (x3 * (x1906 * x426 + x1908) + x4 * (x1903 * x3 - x1905 * x3)),
            x134 * (x1914 * x426 + x1922 - x60 * (x1915 * x426 + x1924))
            + x3 * (x3 * (x1917 * x426 + x1919) + x4 * (x1914 * x3 - x1916 * x3)),
            x134 * (x1925 * x426 + x1933 - x60 * (x1926 * x426 + x1935))
            + x3 * (x3 * (x1928 * x426 + x1930) + x4 * (x1925 * x3 - x1927 * x3)),
            x134 * (x1936 * x426 + x1945 - x60 * (x1937 * x426 + x1947))
            + x3 * (x3 * (x1940 + x1942) + x4 * (x1936 * x3 - x1938 * x3)),
            x3 * (x1961 * x85 + x1965 * x91 + x3 * (x1957 * x3 + 5.0 * x1960))
            + x4 * (x1949 * x3 + 5.0 * x1951 - x60 * (x1953 * x3 + 5.0 * x1955))
            + x91 * (x1965 * x3 + x1966 * x85 + x98 * (x1963 * x3 + 3.0 * x1967)),
            x3 * (x1978 * x85 + x1981 * x98 + x3 * (x1975 * x3 + x1977 * x98))
            + x4 * (x1969 * x3 + x1970 * x98 - x60 * (x1972 * x3 + x1973 * x98))
            + x98 * (x116 * (x1980 * x3 + x1984) + x1981 * x3 + x1982 * x85),
            x3 * (x1994 * x85 + x1997 * x98 + x3 * (x1991 * x3 + 4.0 * x1993))
            + x4 * (x1985 * x3 + 4.0 * x1987 - x60 * (x1988 * x3 + 4.0 * x1990))
            + x98 * (x116 * (x1995 * x3 + 2.0 * x2000) + x1997 * x3 + x1998 * x85),
            x116 * (x153 * (x2011 * x3 + x2014) + x2012 * x3 + x2013 * x85)
            + x3 * (x116 * x2012 + x2010 * x85 + x3 * (x2007 * x3 + x2009))
            + x4 * (x2001 * x3 + x2003 - x60 * (x2004 * x3 + x2006)),
            x116 * (x153 * (x2022 * x3 + x2026) + x2024 * x3 + x2025 * x85)
            + x3 * (x116 * x2024 + x2021 * x85 + x3 * (x116 * x2020 + x2019 * x3))
            + x4 * (x116 * x2016 + x2015 * x3 - x60 * (x116 * x2018 + x2017 * x3)),
            x116 * (x153 * (x2037 * x3 + x2041) + x2039 * x3 + x2040 * x85)
            + x3 * (x116 * x2039 + x2036 * x85 + x3 * (x2033 * x3 + 3.0 * x2035))
            + x4 * (x2027 * x3 + 3.0 * x2029 - x60 * (x2030 * x3 + 3.0 * x2032)),
            x153 * (x2050 * x3 + x2051 * x3 + x2052 * x85)
            + x3 * (x153 * x2051 + x2048 * x85 + x3 * (x153 * x2047 + x2046 * x3))
            + x4 * (x153 * x2043 + x2042 * x3 - x60 * (x153 * x2045 + x2044 * x3)),
            x153 * (x2061 * x3 + x2062 * x3 + x2063 * x85)
            + x3 * (x153 * x2062 + x2059 * x85 + x3 * (x153 * x2058 + x2057 * x3))
            + x4 * (x153 * x2054 + x2053 * x3 - x60 * (x153 * x2056 + x2055 * x3)),
            x153 * (x2075 * x3 + x2076 * x3 + x2077 * x85)
            + x3 * (x153 * x2076 + x2073 * x85 + x3 * (x2070 * x3 + x2072))
            + x4 * (x2064 * x3 + x2066 - x60 * (x2067 * x3 + x2069)),
            x153 * (x2090 * x3 + x2091 * x3 + x2092 * x85)
            + x3 * (x153 * x2091 + x2088 * x85 + x3 * (x2085 * x3 + 2.0 * x2087))
            + x4 * (x2078 * x3 + 2.0 * x2080 - x60 * (x2081 * x3 + 2.0 * x2084)),
            x3 * (x2101 * x3 + x2103 * x85 + x3 * (x2101 + x2102 * x3))
            + x4 * (x2094 + x2095 * x3 - x60 * (x2097 + x2098 * x3))
            + x49 * (x2099 * x426 + x2100 * x85),
            x3 * (x2112 * x3 + x2114 * x85 + x3 * (x2112 + x2113 * x3))
            + x4 * (x2105 + x2106 * x3 - x60 * (x2108 + x2109 * x3))
            + x49 * (x2110 * x426 + x2111 * x85),
            x3 * (x2123 * x3 + x2125 * x85 + x3 * (x2123 + x2124 * x3))
            + x4 * (x2116 + x2117 * x3 - x60 * (x2119 + x2120 * x3))
            + x49 * (x2121 * x426 + x2122 * x85),
            x3 * (x2134 * x3 + x2136 * x85 + x3 * (x2134 + x2135 * x3))
            + x4 * (x2127 + x2128 * x3 - x60 * (x2130 + x2131 * x3))
            + x49 * (x2132 * x426 + x2133 * x85),
            x3 * (x2146 * x3 + x2148 * x85 + x3 * (x2146 + x2147 * x3))
            + x4 * (x2138 + x2139 * x3 - x60 * (x2141 + x2143 * x3))
            + x49 * (x2144 * x426 + x2145 * x85),
            x3 * (x2152 * x426 + x2153 * x85) + x4 * (x2149 * x3 - x2151 * x3),
            x3 * (x2157 * x426 + x2158 * x85) + x4 * (x2154 * x3 - x2156 * x3),
            x3 * (x2162 * x426 + x2163 * x85) + x4 * (x2159 * x3 - x2161 * x3),
            x3 * (x2167 * x426 + x2168 * x85) + x4 * (x2164 * x3 - x2166 * x3),
            x3 * (x2172 * x426 + x2173 * x85) + x4 * (x2169 * x3 - x2171 * x3),
            x3 * (x2177 * x426 + x2178 * x85) + x4 * (x2174 * x3 - x2176 * x3),
            x3 * (0.5 * x2179 + x2180 * x91 + x3 * (x1031 * x1451 + x1032 * x1451))
            + x4
            * (
                x1028 * x1451
                + x1029 * x1451 * x91
                - x60 * (x1025 * x1451 + x1026 * x1451)
            )
            + x91 * (x2180 * x3 + 0.5 * x2181 + x98 * (x1040 * x1451 + x1041 * x1451)),
            x3 * (0.5 * x2194 + x2197 * x98 + x3 * (x2191 * x3 + x2193 * x98))
            + x4 * (x2183 * x3 + x2185 * x98 - x60 * (x2187 * x3 + x2189 * x98))
            + x98 * (x116 * (x2196 * x3 + x2200) + x2197 * x3 + 0.5 * x2198),
            x3 * (0.5 * x2202 + x2203 * x98 + x3 * (x1024 * x1505 + x1024 * x1508))
            + x4 * (x1024 * x1500 + x2201 * x98 - x60 * (x1024 * x1494 + x1024 * x1497))
            + x98 * (x116 * (x1024 * x1520 + x1024 * x1523) + x2203 * x3 + 0.5 * x2204),
            x116 * (x153 * (x2215 * x3 + x2218) + x2216 * x3 + 0.5 * x2217)
            + x3 * (x116 * x2216 + 0.5 * x2214 + x3 * (x2211 * x3 + x2213))
            + x4 * (x2205 * x3 + x2207 - x60 * (x2208 * x3 + x2210)),
            x116 * (x153 * (x2226 * x3 + x2230) + x2228 * x3 + 0.5 * x2229)
            + x3 * (x116 * x2228 + 0.5 * x2225 + x3 * (x116 * x2224 + x2223 * x3))
            + x4 * (x116 * x2220 + x2219 * x3 - x60 * (x116 * x2222 + x2221 * x3)),
            x116 * (x153 * (x1024 * x1626 + x2235) + x2233 * x3 + 0.5 * x2234)
            + x3 * (x116 * x2233 + 0.5 * x2232 + x3 * (x1024 * x1608 + x1024 * x1611))
            + x4 * (x1024 * x1602 + x116 * x2231 - x60 * (x1024 * x1596 + x1024 * x1599)),
            x153 * (x2244 * x3 + x2245 * x3 + 0.5 * x2246)
            + x3 * (x153 * x2245 + 0.5 * x2242 + x3 * (x153 * x2241 + x2240 * x3))
            + x4 * (x153 * x2237 + x2236 * x3 - x60 * (x153 * x2239 + x2238 * x3)),
            x153 * (x2259 * x3 + x2260 * x3 + 0.5 * x2261)
            + x3 * (x153 * x2260 + 0.5 * x2256 + x3 * (x153 * x2255 + x2254 * x3))
            + x4 * (x153 * x2249 + x2248 * x3 - x60 * (x153 * x2252 + x2251 * x3)),
            x153 * (x2273 * x3 + x2274 * x3 + 0.5 * x2275)
            + x3 * (x153 * x2274 + 0.5 * x2271 + x3 * (x2268 * x3 + x2270))
            + x4 * (x2262 * x3 + x2264 - x60 * (x2265 * x3 + x2267)),
            x153 * (x1024 * x1760 + x2279 * x3 + 0.5 * x2280)
            + x3 * (x153 * x2279 + 0.5 * x2277 + x3 * (x1024 * x1746 + x1024 * x1749))
            + x4 * (x1024 * x1741 + x153 * x2276 - x60 * (x1024 * x1733 + x1024 * x1738)),
            x3 * (x2289 * x3 + 0.5 * x2291 + x3 * (x2289 + x2290 * x3))
            + x4 * (x2282 + x2283 * x3 - x60 * (x2285 + x2286 * x3))
            + x49 * (x2287 * x426 + 0.5 * x2288),
            x3 * (x2300 * x3 + 0.5 * x2302 + x3 * (x2300 + x2301 * x3))
            + x4 * (x2293 + x2294 * x3 - x60 * (x2296 + x2297 * x3))
            + x49 * (x2298 * x426 + 0.5 * x2299),
            x3 * (x2311 * x3 + 0.5 * x2313 + x3 * (x2311 + x2312 * x3))
            + x4 * (x2304 + x2305 * x3 - x60 * (x2307 + x2308 * x3))
            + x49 * (x2309 * x426 + 0.5 * x2310),
            x3 * (x2322 * x3 + 0.5 * x2324 + x3 * (x2322 + x2323 * x3))
            + x4 * (x2315 + x2316 * x3 - x60 * (x2318 + x2319 * x3))
            + x49 * (x2320 * x426 + 0.5 * x2321),
            x3 * (x1024 * x1880 + 0.5 * x2329 + x3 * (x1024 * x1876 + x2328))
            + x4 * (x1024 * x1872 + x2325 - x60 * (x1024 * x1868 + x2326))
            + x49 * (x1024 * x1862 + 0.5 * x2327),
            x3 * (x2333 * x426 + 0.5 * x2334) + x4 * (x2330 * x3 - x2332 * x3),
            x3 * (x2338 * x426 + 0.5 * x2339) + x4 * (x2335 * x3 - x2337 * x3),
            x3 * (x2346 * x426 + 0.5 * x2347) + x4 * (x2341 * x3 - x2344 * x3),
            x3 * (x2351 * x426 + 0.5 * x2352) + x4 * (x2348 * x3 - x2350 * x3),
            x3 * (x2356 * x426 + 0.5 * x2357) + x4 * (x2353 * x3 - x2355 * x3),
            x3 * (x1024 * x1940 + 0.5 * x2358)
            + x4 * (x1024 * x1936 * x3 - x1385 * x1938),
            x3 * (x2373 + x2378 * x91 + x3 * (x2367 + x2370))
            + x4 * (x2360 * x3 + 5.0 * x2362 - x60 * (x2363 * x3 + 5.0 * x2365))
            + x91 * (x2378 * x3 + x2380 + x98 * (x2375 * x3 + 3.0 * x2381)),
            x3 * (x2392 + x2395 * x98 + x3 * (x2388 * x3 + 4.0 * x2390))
            + x4 * (x2382 * x3 + 4.0 * x2384 - x60 * (x2385 * x3 + 4.0 * x2387))
            + x98 * (x116 * (x2393 * x3 + x2400) + x2395 * x3 + x2397),
            x3 * (x2414 + x2419 * x98 + x3 * (x2408 + x2411))
            + x4 * (x2401 * x3 + 4.0 * x2403 - x60 * (x2404 * x3 + 4.0 * x2406))
            + x98 * (x116 * (x2416 * x3 + x2423) + x2419 * x3 + x2421),
            x116 * (x153 * (x2438 * x3 + x2443) + x2440 * x3 + x2442)
            + x3 * (x116 * x2440 + x2437 + x3 * (x2432 * x3 + x2435))
            + x4 * (x2424 * x3 + x2427 - x60 * (x2428 * x3 + x2431)),
            x116 * (x153 * (x2452 * x3 + x2457) + x2454 * x3 + x2456)
            + x3 * (x116 * x2454 + x2451 + x3 * (x116 * x2449 + x2448 * x3))
            + x4 * (x116 * x2445 + x2444 * x3 - x60 * (x116 * x2447 + x2446 * x3)),
            x116 * (x153 * (x2475 * x3 + x2481) + x2478 * x3 + x2480)
            + x3 * (x116 * x2478 + x2473 + x3 * (x2467 + x2470))
            + x4 * (x2458 * x3 + x2461 - x60 * (x2462 * x3 + x2465)),
            x153 * (x2495 * x3 + x2496 * x3 + x2498)
            + x3 * (x153 * x2496 + x2493 + x3 * (x2489 * x3 + 2.0 * x2491))
            + x4 * (x2482 * x3 + 2.0 * x2484 - x60 * (x2485 * x3 + 2.0 * x2488)),
            x153 * (x2511 * x3 + x2512 * x3 + x2514)
            + x3 * (x153 * x2512 + x2509 + x3 * (x2505 * x3 + x2507))
            + x4 * (x2499 * x3 + x2501 - x60 * (x2502 * x3 + x2504)),
            x153 * (x2527 * x3 + x2528 * x3 + x2530)
            + x3 * (x153 * x2528 + x2525 + x3 * (x2521 * x3 + x2523))
            + x4 * (x2515 * x3 + x2517 - x60 * (x2518 * x3 + x2520)),
            x153 * (x2546 * x3 + x2548 * x3 + x2550)
            + x3 * (x153 * x2548 + x2544 + x3 * (x2538 + x2541))
            + x4 * (x2531 * x3 + 2.0 * x2533 - x60 * (x2534 * x3 + 2.0 * x2536)),
            x3 * (x2561 * x3 + x2564 + x3 * (x2561 + x2562 * x3))
            + x4 * (x2552 + x2553 * x3 - x60 * (x2555 + x2557 * x3))
            + x49 * (x2558 * x426 + x2560),
            x3 * (x2574 * x3 + x2577 + x3 * (x2574 + x2575 * x3))
            + x4 * (x2566 + x2567 * x3 - x60 * (x2569 + x2570 * x3))
            + x49 * (x2571 * x426 + x2573),
            x3 * (x2587 * x3 + x2590 + x3 * (x2587 + x2588 * x3))
            + x4 * (x2579 + x2580 * x3 - x60 * (x2582 + x2583 * x3))
            + x49 * (x2584 * x426 + x2586),
            x3 * (x2600 * x3 + x2603 + x3 * (x2600 + x2601 * x3))
            + x4 * (x2592 + x2593 * x3 - x60 * (x2595 + x2596 * x3))
            + x49 * (x2597 * x426 + x2599),
            x3 * (x2618 + x2619 + x3 * (x2613 + x2615))
            + x4 * (x2605 + x2606 * x3 - x60 * (x2608 + x2609 * x3))
            + x49 * (x2610 * x426 + x2612),
            x3 * (x2623 * x426 + x2625) + x4 * (x2620 * x3 - x2622 * x3),
            x3 * (x2629 * x426 + x2631) + x4 * (x2626 * x3 - x2628 * x3),
            x3 * (x2635 * x426 + x2637) + x4 * (x2632 * x3 - x2634 * x3),
            x3 * (x2641 * x426 + x2643) + x4 * (x2638 * x3 - x2640 * x3),
            x3 * (x2647 * x426 + x2649) + x4 * (x2644 * x3 - x2646 * x3),
            x3 * (x2654 + x2656) + x4 * (x2650 * x3 - x2652 * x3),
            x2660 * x85
            + x3 * (x2657 * x3 + 5.0 * x2659)
            + x91 * (x2658 * x3 + 4.0 * x2661),
            x2664 * x85
            + x3 * (x2662 * x3 + x2663 * x98)
            + x98 * (x116 * x2665 + x2663 * x3),
            x2669 * x85
            + x3 * (x2666 * x3 + 4.0 * x2668)
            + x98 * (x2667 * x3 + 3.0 * x2670),
            x116 * (x153 * x2675 + x2672 * x3) + x2674 * x85 + x3 * (x2671 * x3 + x2673),
            x116 * (x2677 * x3 + x2679) + x2678 * x85 + x3 * (x116 * x2677 + x2676 * x3),
            x116 * (x2681 * x3 + 2.0 * x2684)
            + x2683 * x85
            + x3 * (x2680 * x3 + 3.0 * x2682),
            x153 * (x2686 * x3 + x2688) + x2687 * x85 + x3 * (x153 * x2686 + x2685 * x3),
            x153 * (x2690 * x3 + x2692) + x2691 * x85 + x3 * (x153 * x2690 + x2689 * x3),
            x153 * (x2694 * x3 + x2697) + x2696 * x85 + x3 * (x2693 * x3 + x2695),
            x153 * (x2699 * x3 + x2702) + x2701 * x85 + x3 * (x2698 * x3 + 2.0 * x2700),
            x2704 * x3 + x2706 * x85 + x3 * (x2704 + x2705 * x3),
            x2708 * x3 + x2710 * x85 + x3 * (x2708 + x2709 * x3),
            x2712 * x3 + x2714 * x85 + x3 * (x2712 + x2713 * x3),
            x2716 * x3 + x2718 * x85 + x3 * (x2716 + x2717 * x3),
            x2720 * x3 + x2722 * x85 + x3 * (x2720 + x2721 * x3),
            x2723 * x426 + x2724 * x85,
            x2725 * x426 + x2726 * x85,
            x2727 * x426 + x2728 * x85,
            x2729 * x426 + x2730 * x85,
            x2731 * x426 + x2732 * x85,
            x2733 * x426 + x2734 * x85,
            x2738 * x85
            + x3 * (x2735 * x3 + 5.0 * x2737)
            + x91 * (x2736 * x3 + 4.0 * x2739),
            x2742 * x85
            + x3 * (x2740 * x3 + x2741 * x98)
            + x98 * (x116 * x2743 + x2741 * x3),
            x2747 * x85
            + x3 * (x2744 * x3 + 4.0 * x2746)
            + x98 * (x2745 * x3 + 3.0 * x2748),
            x116 * (x153 * x2753 + x2750 * x3) + x2752 * x85 + x3 * (x2749 * x3 + x2751),
            x116 * (x2755 * x3 + x2757) + x2756 * x85 + x3 * (x116 * x2755 + x2754 * x3),
            x116 * (x2759 * x3 + 2.0 * x2762)
            + x2761 * x85
            + x3 * (x2758 * x3 + 3.0 * x2760),
            x153 * (x2764 * x3 + x2766) + x2765 * x85 + x3 * (x153 * x2764 + x2763 * x3),
            x153 * (x2768 * x3 + x2770) + x2769 * x85 + x3 * (x153 * x2768 + x2767 * x3),
            x153 * (x2772 * x3 + x2775) + x2774 * x85 + x3 * (x2771 * x3 + x2773),
            x153 * (x2777 * x3 + x2780) + x2779 * x85 + x3 * (x2776 * x3 + 2.0 * x2778),
            x2782 * x3 + x2784 * x85 + x3 * (x2782 + x2783 * x3),
            x2786 * x3 + x2788 * x85 + x3 * (x2786 + x2787 * x3),
            x2790 * x3 + x2792 * x85 + x3 * (x2790 + x2791 * x3),
            x2794 * x3 + x2796 * x85 + x3 * (x2794 + x2795 * x3),
            x2798 * x3 + x2800 * x85 + x3 * (x2798 + x2799 * x3),
            x2801 * x426 + x2802 * x85,
            x2803 * x426 + x2804 * x85,
            x2805 * x426 + x2806 * x85,
            x2807 * x426 + x2808 * x85,
            x2809 * x426 + x2810 * x85,
            x2811 * x426 + x2812 * x85,
            0.5 * x2813
            + x3 * (x1024 * x2367 + x1024 * x2370)
            + x91 * (x1024 * x2374 + x1024 * x2377),
            0.5 * x2816
            + x3 * (x2814 * x3 + x2815 * x98)
            + x98 * (x116 * x2817 + x2815 * x3),
            0.5 * x2818
            + x3 * (x1024 * x2408 + x1024 * x2411)
            + x98 * (x1024 * x2415 + x1024 * x2418),
            x116 * (x153 * x2823 + x2820 * x3) + 0.5 * x2822 + x3 * (x2819 * x3 + x2821),
            x116 * (x2825 * x3 + x2827) + 0.5 * x2826 + x3 * (x116 * x2825 + x2824 * x3),
            x116 * (x1024 * x2474 + x1024 * x2477)
            + 0.5 * x2828
            + x3 * (x1024 * x2467 + x1024 * x2470),
            x153 * (x2830 * x3 + x2832) + 0.5 * x2831 + x3 * (x153 * x2830 + x2829 * x3),
            x153 * (x2835 * x3 + x2840) + 0.5 * x2838 + x3 * (x153 * x2835 + x2834 * x3),
            x153 * (x2842 * x3 + x2845) + 0.5 * x2844 + x3 * (x2841 * x3 + x2843),
            x153 * (x1024 * x2547 + x2847)
            + 0.5 * x2846
            + x3 * (x1024 * x2538 + x1024 * x2541),
            x2849 * x3 + 0.5 * x2851 + x3 * (x2849 + x2850 * x3),
            x2853 * x3 + 0.5 * x2855 + x3 * (x2853 + x2854 * x3),
            x2857 * x3 + 0.5 * x2859 + x3 * (x2857 + x2858 * x3),
            x2861 * x3 + 0.5 * x2863 + x3 * (x2861 + x2862 * x3),
            x1024 * x2619 + 0.5 * x2865 + x3 * (x1024 * x2615 + x2864),
            x2866 * x426 + 0.5 * x2867,
            x2868 * x426 + 0.5 * x2869,
            x2871 * x426 + 0.5 * x2874,
            x2875 * x426 + 0.5 * x2876,
            x2877 * x426 + 0.5 * x2878,
            x1024 * x2654 + 0.5 * x2879,
            x2886 + x3 * (x2881 + x2884) + x91 * (x2882 * x3 + 4.0 * x2887),
            x2892 + x3 * (x2888 * x3 + 4.0 * x2890) + x98 * (x2889 * x3 + 3.0 * x2893),
            x2900 + x3 * (x2895 + x2898) + x98 * (x2896 * x3 + 3.0 * x2901),
            x116 * (x2903 * x3 + 2.0 * x2908) + x2907 + x3 * (x2902 * x3 + x2905),
            x116 * (x2910 * x3 + x2913) + x2912 + x3 * (x116 * x2910 + x2909 * x3),
            x116 * (x2916 * x3 + 2.0 * x2921) + x2920 + x3 * (x2915 + x2918),
            x153 * (x2923 * x3 + x2927) + x2926 + x3 * (x2922 * x3 + 2.0 * x2924),
            x153 * (x2929 * x3 + x2933) + x2932 + x3 * (x2928 * x3 + x2930),
            x153 * (x2935 * x3 + x2939) + x2938 + x3 * (x2934 * x3 + x2936),
            x153 * (x2942 * x3 + x2947) + x2946 + x3 * (x2941 + x2944),
            x2949 * x3 + x2952 + x3 * (x2949 + x2950 * x3),
            x2954 * x3 + x2957 + x3 * (x2954 + x2955 * x3),
            x2959 * x3 + x2962 + x3 * (x2959 + x2960 * x3),
            x2964 * x3 + x2967 + x3 * (x2964 + x2965 * x3),
            x2969 * x3 + x2973 + x3 * (x2969 + x2971),
            x2974 * x426 + x2976,
            x2977 * x426 + x2979,
            x2980 * x426 + x2982,
            x2983 * x426 + x2985,
            x2986 * x426 + x2988,
            x2989 * x426 + x2991,
            x2992 * x3 + 5.0 * x2993,
            x2994 * x3 + x2995 * x98,
            x2996 * x3 + 4.0 * x2997,
            x2998 * x3 + x2999,
            x116 * x3001 + x3 * x3000,
            x3 * x3002 + 3.0 * x3003,
            x153 * x3005 + x3 * x3004,
            x153 * x3007 + x3 * x3006,
            x3 * x3008 + x3009,
            x3 * x3010 + 2.0 * x3011,
            x3 * x3013 + x3012,
            x3 * x3015 + x3014,
            x3 * x3017 + x3016,
            x3 * x3019 + x3018,
            x3 * x3021 + x3020,
            x3 * x3022,
            x3 * x3023,
            x3 * x3024,
            x3 * x3025,
            x3 * x3026,
            x3 * x3027,
            x3 * x3028 + 5.0 * x3029,
            x3 * x3030 + x3031 * x98,
            x3 * x3032 + 4.0 * x3033,
            x3 * x3034 + x3035,
            x116 * x3037 + x3 * x3036,
            x3 * x3038 + 3.0 * x3039,
            x153 * x3041 + x3 * x3040,
            x153 * x3043 + x3 * x3042,
            x3 * x3044 + x3045,
            x3 * x3046 + 2.0 * x3047,
            x3 * x3049 + x3048,
            x3 * x3051 + x3050,
            x3 * x3053 + x3052,
            x3 * x3055 + x3054,
            x3 * x3057 + x3056,
            x3 * x3058,
            x3 * x3059,
            x3 * x3060,
            x3 * x3061,
            x3 * x3062,
            x3 * x3063,
            x3 * x3064 + 5.0 * x3065,
            x3 * x3066 + x3067 * x98,
            x3 * x3068 + 4.0 * x3069,
            x3 * x3070 + x3071,
            x116 * x3073 + x3 * x3072,
            x3 * x3074 + 3.0 * x3075,
            x153 * x3077 + x3 * x3076,
            x153 * x3079 + x3 * x3078,
            x3 * x3080 + x3081,
            x3 * x3082 + 2.0 * x3083,
            x3 * x3085 + x3084,
            x3 * x3087 + x3086,
            x3 * x3089 + x3088,
            x3 * x3091 + x3090,
            x3 * x3093 + x3092,
            x3 * x3094,
            x3 * x3095,
            x3 * x3096,
            x3 * x3097,
            x3 * x3098,
            x3 * x3099,
            x1024 * x2881 + x1024 * x2884,
            x3 * x3100 + x3101 * x98,
            x1024 * x2895 + x1024 * x2898,
            x3 * x3102 + x3103,
            x116 * x3105 + x3 * x3104,
            x1024 * x2915 + x1024 * x2918,
            x153 * x3107 + x3 * x3106,
            x153 * x3110 + x3 * x3109,
            x3 * x3111 + x3112,
            x1024 * x2941 + x1024 * x2944,
            x3 * x3114 + x3113,
            x3 * x3116 + x3115,
            x3 * x3118 + x3117,
            x3 * x3120 + x3119,
            x1024 * x2971 + x3121,
            x3 * x3122,
            x3 * x3123,
            x3 * x3125,
            x3 * x3126,
            x3 * x3127,
            x1385 * x2989,
            x3 * x3128 + 5.0 * x3129,
            x3 * x3130 + 4.0 * x3131,
            x3 * x3132 + 4.0 * x3133,
            x3 * x3134 + x3136,
            x116 * x3138 + x3 * x3137,
            x3 * x3139 + x3141,
            x3 * x3142 + 2.0 * x3143,
            x3 * x3144 + x3146,
            x3 * x3147 + x3149,
            x3 * x3150 + 2.0 * x3151,
            x3 * x3153 + x3152,
            x3 * x3155 + x3154,
            x3 * x3157 + x3156,
            x3 * x3159 + x3158,
            x3 * x3161 + x3160,
            x3 * x3162,
            x3 * x3163,
            x3 * x3164,
            x3 * x3165,
            x3 * x3166,
            x3 * x3167,
            x1024 * x2992 + x149 * x2660,
            x1024 * x2994 + x149 * x2664 + x2993,
            x1024 * x2996 + x149 * x2669,
            x1024 * x2998 + x149 * x2674 + x153 * x2995,
            x1024 * x3000 + x149 * x2678 + x2997,
            x1024 * x3002 + x149 * x2683,
            x1024 * x3004 + x149 * x2687 + x2999,
            x1024 * x3006 + x149 * x2691 + x153 * x3001,
            x1024 * x3008 + x149 * x2696 + x3003,
            x1024 * x3010 + x149 * x2701,
            x1024 * x3013 + x149 * x2706 + x3005 * x98,
            x1024 * x3015 + x116 * x3007 + x149 * x2710,
            x1024 * x3017 + x149 * x2714 + x3009,
            x1024 * x3019 + x149 * x2718 + x3011,
            x1024 * x3021 + x149 * x2722,
            x1024 * x3022 + x149 * x2724 + 5.0 * x3012,
            x1024 * x3023 + x149 * x2726 + 4.0 * x3014,
            x1024 * x3024 + x149 * x2728 + 3.0 * x3016,
            x1024 * x3025 + x149 * x2730 + 2.0 * x3018,
            x1024 * x3026 + x149 * x2732 + x3020,
            x1024 * x3027 + x149 * x2734,
            x1024 * x3028 + x134 * x2738,
            x1024 * x3030 + x134 * x2742 + x3029,
            x1024 * x3032 + x134 * x2747,
            x1024 * x3034 + x134 * x2752 + x153 * x3031,
            x1024 * x3036 + x134 * x2756 + x3033,
            x1024 * x3038 + x134 * x2761,
            x1024 * x3040 + x134 * x2765 + x3035,
            x1024 * x3042 + x134 * x2769 + x153 * x3037,
            x1024 * x3044 + x134 * x2774 + x3039,
            x1024 * x3046 + x134 * x2779,
            x1024 * x3049 + x134 * x2784 + x3041 * x98,
            x1024 * x3051 + x116 * x3043 + x134 * x2788,
            x1024 * x3053 + x134 * x2792 + x3045,
            x1024 * x3055 + x134 * x2796 + x3047,
            x1024 * x3057 + x134 * x2800,
            x1024 * x3058 + x134 * x2802 + 5.0 * x3048,
            x1024 * x3059 + x134 * x2804 + 4.0 * x3050,
            x1024 * x3060 + x134 * x2806 + 3.0 * x3052,
            x1024 * x3061 + x134 * x2808 + 2.0 * x3054,
            x1024 * x3062 + x134 * x2810 + x3056,
            x1024 * x3063 + x134 * x2812,
            x1024 * x3064 + x2813,
            x1024 * x3066 + x2816 + x3065,
            x1024 * x3068 + x2818,
            x1024 * x3070 + x153 * x3067 + x2822,
            x1024 * x3072 + x2826 + x3069,
            x1024 * x3074 + x2828,
            x1024 * x3076 + x2831 + x3071,
            x1024 * x3078 + x153 * x3073 + x2838,
            x1024 * x3080 + x2844 + x3075,
            x1024 * x3082 + x2846,
            x1024 * x3085 + x2851 + x3077 * x98,
            x1024 * x3087 + x116 * x3079 + x2855,
            x1024 * x3089 + x2859 + x3081,
            x1024 * x3091 + x2863 + x3083,
            x1024 * x3093 + x2865,
            x1024 * x3094 + x2867 + 5.0 * x3084,
            x1024 * x3095 + x2869 + 4.0 * x3086,
            x1024 * x3096 + x2874 + 3.0 * x3088,
            x1024 * x3097 + x2876 + 2.0 * x3090,
            x1024 * x3098 + x2878 + x3092,
            x1024 * x3099 + x2879,
            x1948 * x2880 + x2886,
            x1024 * x2883 + x1024 * x3100 + x2892,
            x1948 * x2894 + x2900,
            x1024 * x3102 + x153 * x3101 + x2907,
            x1024 * x2897 + x1024 * x3104 + x2912,
            x1948 * x2914 + x2920,
            x1024 * x3106 + x2926 + x3103,
            x1024 * x3109 + x153 * x3105 + x2932,
            x1024 * x2917 + x1024 * x3111 + x2938,
            x1948 * x2940 + x2946,
            x1024 * x3114 + x2952 + x3107 * x98,
            x1024 * x3116 + x116 * x3110 + x2957,
            x1024 * x3118 + x2962 + x3112,
            x1024 * x2943 + x1024 * x3120 + x2967,
            x1948 * x2970 + x2973,
            x1024 * x3122 + x2976 + 5.0 * x3113,
            x1024 * x3123 + x2979 + 4.0 * x3115,
            x1024 * x3125 + x2982 + 3.0 * x3117,
            x1024 * x3126 + x2985 + 2.0 * x3119,
            x1024 * x3127 + x2988 + x3121,
            x1948 * x2989 + x2991,
            x1024 * x3128,
            x1024 * x3130 + x3129,
            x1024 * x3132,
            x1024 * x3134 + 2.0 * x3131,
            x1024 * x3137 + x3133,
            x1024 * x3139,
            x1024 * x3142 + x3136,
            x1024 * x3144 + x3168,
            x1024 * x3147 + x3140,
            x1024 * x3150,
            x1024 * x3153 + 4.0 * x3143,
            x1024 * x3155 + x116 * x3145,
            x1024 * x3157 + x3149,
            x1024 * x3159 + x3151,
            x1024 * x3161,
            x1024 * x3162 + 5.0 * x3152,
            x1024 * x3163 + 4.0 * x3154,
            x1024 * x3164 + x3169,
            x1024 * x3165 + 2.0 * x3158,
            x1024 * x3166 + x3160,
            x1024 * x3167,
            x1451 * x3128 + x149 * x2885,
            x1451 * x3130 + x149 * x2891,
            x1451 * x3132 + x149 * x2899 + x3129,
            x1451 * x3134 + x149 * x2906,
            x1451 * x3137 + x149 * x2911 + x3131,
            x1451 * x3139 + x149 * x2919 + 2.0 * x3133,
            x1451 * x3142 + x149 * x2925,
            x1451 * x3144 + x149 * x2931 + x3135,
            x1451 * x3147 + x149 * x2937 + x3168,
            x1451 * x3150 + x149 * x2945 + x3141,
            x1451 * x3153 + x149 * x2951,
            x1451 * x3155 + x149 * x2956 + x3143,
            x1451 * x3157 + x149 * x2961 + x3146,
            x116 * x3148 + x1451 * x3159 + x149 * x2966,
            x1451 * x3161 + x149 * x2972 + 4.0 * x3151,
            x1451 * x3162 + x149 * x2975,
            x1451 * x3163 + x149 * x2978 + x3152,
            x1451 * x3164 + x149 * x2981 + 2.0 * x3154,
            x1451 * x3165 + x149 * x2984 + x3169,
            x1451 * x3166 + x149 * x2987 + 4.0 * x3158,
            x1451 * x3167 + x149 * x2990 + 5.0 * x3160,
        ]
    )
