import numpy

from pysisyphus.wavefunction.ints.boys import boys


def _3center2el3d_000(a, A, b, B, c, C):
    """Cartesian (ss|s) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = c + x0

    # 1 item(s)
    return numpy.array(
        [
            34.9868366552497
            * x1
            * x2 ** (-0.5)
            * boys(
                0,
                c
                * x0
                * (
                    (x1 * (a * A[0] + b * B[0]) - C[0]) ** 2
                    + (x1 * (a * A[1] + b * B[1]) - C[1]) ** 2
                    + (x1 * (a * A[2] + b * B[2]) - C[2]) ** 2
                )
                / x2,
            )
            * numpy.exp(
                -a
                * b
                * x1
                * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
            )
            / c
        ]
    )


def _3center2el3d_001(a, A, b, B, c, C):
    """Cartesian (ss|p) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - C[0]
    x3 = c + x0
    x4 = x1 * (a * A[1] + b * B[1]) - C[1]
    x5 = x1 * (a * A[2] + b * B[2]) - C[2]
    x6 = (
        34.9868366552497
        * x3 ** (-1.5)
        * boys(1, c * x0 * (x2**2 + x4**2 + x5**2) / x3)
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        / c
    )

    # 3 item(s)
    return numpy.array([x2 * x6, x4 * x6, x5 * x6])


def _3center2el3d_002(a, A, b, B, c, C):
    """Cartesian (ss|d) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = a + b
    x2 = c + x1
    x3 = x1 ** (-1.0)
    x4 = x3 * (a * A[0] + b * B[0]) - C[0]
    x5 = x4**2
    x6 = x3 * (a * A[1] + b * B[1]) - C[1]
    x7 = x6**2
    x8 = x3 * (a * A[2] + b * B[2]) - C[2]
    x9 = x8**2
    x10 = c * x1 * (x5 + x7 + x9) / x2
    x11 = 17.4934183276249
    x12 = numpy.exp(
        -a * b * x3 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x13 = 2.0 * x0 * x11 * x12
    x14 = (
        0.5
        * x0
        * (
            2.0 * x0 * x11 * x12 * x2 ** (-0.5) * x3 * boys(0, x10)
            - x13 * x2 ** (-1.5) * boys(1, x10)
        )
    )
    x15 = x1 * x13 * x2 ** (-2.5) * boys(2, x10)
    x16 = x15 * x4

    # 6 item(s)
    return numpy.array(
        [
            x14 + x15 * x5,
            x16 * x6,
            x16 * x8,
            x14 + x15 * x7,
            x15 * x6 * x8,
            x14 + x15 * x9,
        ]
    )


def _3center2el3d_003(a, A, b, B, c, C):
    """Cartesian (ss|f) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = 17.4934183276249
    x2 = a + b
    x3 = c + x2
    x4 = x3 ** (-1.5)
    x5 = x2 ** (-1.0)
    x6 = x5 * (a * A[0] + b * B[0]) - C[0]
    x7 = x6**2
    x8 = x5 * (a * A[1] + b * B[1]) - C[1]
    x9 = x8**2
    x10 = x5 * (a * A[2] + b * B[2]) - C[2]
    x11 = x10**2
    x12 = x2 / x3
    x13 = c * x12 * (x11 + x7 + x9)
    x14 = boys(1, x13)
    x15 = numpy.exp(
        -a * b * x5 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x16 = 2.0 * x0 * x1 * x15
    x17 = x16 * x6
    x18 = boys(2, x13)
    x19 = x2 * x3 ** (-2.5)
    x20 = x18 * x19
    x21 = 0.5 * x0 * (2.0 * x0 * x1 * x14 * x15 * x3 ** (-0.5) * x5 - x16 * x18 * x4)
    x22 = boys(3, x13)
    x23 = x16 * x22
    x24 = x19 * x23
    x25 = x12 * x6
    x26 = x16 * x20
    x27 = x0 * (2.0 * x0 * x1 * x14 * x15 * x4 * x8 - x26 * x8)
    x28 = x2**2
    x29 = x3 ** (-3.5)
    x30 = x23 * x28 * x29
    x31 = x30 * x7
    x32 = x0 * (2.0 * x0 * x1 * x10 * x14 * x15 * x4 - x10 * x26)
    x33 = 0.5 * x32
    x34 = x21 + x24 * x9
    x35 = x11 * x24 + x21
    x36 = x12 * x8

    # 10 item(s)
    return numpy.array(
        [
            x0 * (2.0 * x0 * x1 * x14 * x15 * x4 * x6 - x17 * x20)
            + x25 * (x21 + x24 * x7),
            0.5 * x27 + x31 * x8,
            x10 * x31 + x33,
            x25 * x34,
            x10 * x17 * x22 * x28 * x29 * x8,
            x25 * x35,
            x27 + x34 * x36,
            x10 * x30 * x9 + x33,
            x35 * x36,
            x10 * x12 * x35 + x32,
        ]
    )


def _3center2el3d_004(a, A, b, B, c, C):
    """Cartesian (ss|g) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - C[0]
    x3 = x2**2
    x4 = x1 * (a * A[1] + b * B[1]) - C[1]
    x5 = x4**2
    x6 = x1 * (a * A[2] + b * B[2]) - C[2]
    x7 = x6**2
    x8 = c + x0
    x9 = x0 / x8
    x10 = c * x9 * (x3 + x5 + x7)
    x11 = boys(1, x10)
    x12 = x8 ** (-1.5)
    x13 = c ** (-1.0)
    x14 = 17.4934183276249
    x15 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x16 = 2.0 * x13 * x14 * x15
    x17 = x12 * x16
    x18 = x8 ** (-0.5)
    x19 = 0.5 * x13
    x20 = x19 * (2.0 * x1 * x13 * x14 * x15 * x18 * boys(0, x10) - x11 * x17)
    x21 = boys(2, x10)
    x22 = x19 * (2.0 * x1 * x11 * x13 * x14 * x15 * x18 - x17 * x21)
    x23 = boys(3, x10)
    x24 = x16 * x23
    x25 = x8 ** (-2.5)
    x26 = x0 * x25
    x27 = x26 * x3
    x28 = x16 * x27
    x29 = 1.5 * x13
    x30 = x24 * x26
    x31 = x19 * (2.0 * x1 * x13 * x14 * x15 * x18 * x21 - x17 * x23)
    x32 = boys(4, x10)
    x33 = x2 * x9
    x34 = x2 * x4
    x35 = x0**2
    x36 = x35 * x8 ** (-3.5)
    x37 = x24 * x36
    x38 = x13 * (2.0 * x12 * x13 * x14 * x15 * x21 * x4 - x30 * x4)
    x39 = x16 * x32 * x36
    x40 = x3 * x39
    x41 = x13 * (2.0 * x12 * x13 * x14 * x15 * x21 * x6 - x30 * x6)
    x42 = 0.5 * x41
    x43 = x16 * x26
    x44 = x43 * x5
    x45 = x20 + x21 * x44 - x9 * (x22 + x30 * x5)
    x46 = x31 + x32 * x44
    x47 = x35 / x8**2
    x48 = x3 * x47
    x49 = x4 * x6
    x50 = x13 * (2.0 * x0 * x13 * x14 * x15 * x21 * x25 * x4 * x6 - x37 * x49)
    x51 = x43 * x7
    x52 = x20 + x21 * x51 - x9 * (x22 + x30 * x7)
    x53 = x19 * x52
    x54 = x31 + x32 * x51
    x55 = x4 * x9
    x56 = x38 + x46 * x55
    x57 = x39 * x5 * x6 + x42
    x58 = x47 * x54
    x59 = x6 * x9
    x60 = x41 + x54 * x59

    # 15 item(s)
    return numpy.array(
        [
            x29 * (x20 + x21 * x28 - x9 * (x22 + x24 * x27))
            + x33
            * (
                x13 * (2.0 * x12 * x13 * x14 * x15 * x2 * x21 - x2 * x30)
                + x33 * (x28 * x32 + x31)
            ),
            x13 * (2.0 * x0 * x13 * x14 * x15 * x2 * x21 * x25 * x4 - x34 * x37)
            + x33 * (0.5 * x38 + x4 * x40),
            x13 * (2.0 * x0 * x13 * x14 * x15 * x2 * x21 * x25 * x6 - x2 * x37 * x6)
            + x33 * (x40 * x6 + x42),
            x19 * x45 + x46 * x48,
            x0**3 * x16 * x3 * x32 * x49 * x8 ** (-4.5) + 0.5 * x50,
            x48 * x54 + x53,
            x33 * x56,
            x33 * x57,
            x34 * x58,
            x33 * x60,
            x29 * x45 + x55 * x56,
            x50 + x55 * x57,
            x5 * x58 + x53,
            x55 * x60,
            x29 * x52 + x59 * x60,
        ]
    )


def _3center2el3d_005(a, A, b, B, c, C):
    """Cartesian (ss|h) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = 17.4934183276249
    x2 = a + b
    x3 = c + x2
    x4 = x3 ** (-1.5)
    x5 = x2 ** (-1.0)
    x6 = x5 * (a * A[0] + b * B[0]) - C[0]
    x7 = x6**2
    x8 = x5 * (a * A[1] + b * B[1]) - C[1]
    x9 = x8**2
    x10 = x5 * (a * A[2] + b * B[2]) - C[2]
    x11 = x10**2
    x12 = x3 ** (-1.0)
    x13 = x12 * x2
    x14 = c * x13 * (x11 + x7 + x9)
    x15 = boys(1, x14)
    x16 = numpy.exp(
        -a * b * x5 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x17 = boys(2, x14)
    x18 = 2.0 * x0
    x19 = x1 * x16 * x18
    x20 = x17 * x19
    x21 = x3 ** (-2.5)
    x22 = x2 * x21
    x23 = x22 * x6
    x24 = boys(3, x14)
    x25 = x19 * x24
    x26 = x19 * x4
    x27 = x3 ** (-0.5)
    x28 = 0.5 * x0
    x29 = x28 * (2.0 * x0 * x1 * x16 * x17 * x27 * x5 - x24 * x26)
    x30 = x22 * x7
    x31 = boys(4, x14)
    x32 = x19 * x31
    x33 = x13 * (x29 + x30 * x32)
    x34 = x28 * (2.0 * x0 * x1 * x15 * x16 * x27 * x5 - x17 * x26)
    x35 = x25 * x30 + x34
    x36 = x13 * x6
    x37 = 1.5 * x0
    x38 = x28 * (2.0 * x0 * x1 * x16 * x24 * x27 * x5 - x26 * x31)
    x39 = x19 * boys(5, x14)
    x40 = x22 * x8
    x41 = x0 * (2.0 * x0 * x1 * x15 * x16 * x4 * x8 - x20 * x40)
    x42 = x0 * (2.0 * x0 * x1 * x16 * x17 * x4 * x8 - x25 * x40)
    x43 = x7 * x8
    x44 = x2**2
    x45 = x3 ** (-3.5)
    x46 = x44 * x45
    x47 = x43 * x46
    x48 = x32 * x46
    x49 = x48 * x6
    x50 = x0 * (2.0 * x0 * x1 * x16 * x24 * x4 * x8 - x32 * x40)
    x51 = x10 * x22
    x52 = x0 * (2.0 * x0 * x1 * x10 * x15 * x16 * x4 - x20 * x51)
    x53 = 0.5 * x52
    x54 = x0 * (2.0 * x0 * x1 * x10 * x16 * x17 * x4 - x25 * x51)
    x55 = 0.5 * x54
    x56 = x10 * x7
    x57 = x46 * x56
    x58 = x0 * (2.0 * x0 * x1 * x10 * x16 * x24 * x4 - x32 * x51)
    x59 = 0.5 * x58
    x60 = x22 * x9
    x61 = x29 + x32 * x60
    x62 = x44 / x3**2
    x63 = x6 * x62
    x64 = x25 * x60 + x34
    x65 = x13 * x61
    x66 = x64 - x65
    x67 = x38 + x39 * x60
    x68 = x62 * x7
    x69 = x2**3
    x70 = x10 * x3 ** (-4.5)
    x71 = x10 * x48
    x72 = x0 * (2.0 * x0 * x1 * x10 * x16 * x2 * x21 * x24 * x8 - x71 * x8)
    x73 = x43 * x69
    x74 = x11 * x22
    x75 = x29 + x32 * x74
    x76 = x25 * x74 + x34
    x77 = x13 * x75
    x78 = x76 - x77
    x79 = x28 * x78
    x80 = x38 + x39 * x74
    x81 = x13 * x8
    x82 = -x13 * (x42 + x65 * x8) + x41 + x64 * x81
    x83 = x50 + x67 * x81
    x84 = x10 * x46 * x9
    x85 = -x13 * (x55 + x71 * x9) + x25 * x84 + x53
    x86 = x39 * x84 + x59
    x87 = x0 * (x12 * x2 * x76 * x8 - x62 * x75 * x8)
    x88 = x10 * x13
    x89 = -x13 * (x10 * x77 + x54) + x52 + x76 * x88
    x90 = x28 * x89
    x91 = x58 + x80 * x88
    x92 = x37 * x66 + x81 * x83
    x93 = x72 + x81 * x86
    x94 = x62 * x9
    x95 = x79 + x80 * x94
    x96 = x37 * x78 + x88 * x91

    # 21 item(s)
    return numpy.array(
        [
            x18
            * (
                x0 * (2.0 * x0 * x1 * x15 * x16 * x4 * x6 - x20 * x23)
                - x13
                * (x0 * (2.0 * x0 * x1 * x16 * x17 * x4 * x6 - x23 * x25) + x33 * x6)
                + x35 * x36
            )
            + x36
            * (
                x36
                * (
                    x0 * (2.0 * x0 * x1 * x16 * x24 * x4 * x6 - x23 * x32)
                    + x36 * (x30 * x39 + x38)
                )
                + x37 * (-x33 + x35)
            ),
            x36
            * (
                x0 * (2.0 * x0 * x1 * x16 * x2 * x21 * x24 * x6 * x8 - x49 * x8)
                + x36 * (x39 * x47 + 0.5 * x50)
            )
            + x37 * (-x13 * (x32 * x47 + 0.5 * x42) + x25 * x47 + 0.5 * x41),
            x36
            * (
                x0 * (2.0 * x0 * x1 * x10 * x16 * x2 * x21 * x24 * x6 - x10 * x49)
                + x36 * (x39 * x57 + x59)
            )
            + x37 * (-x13 * (x48 * x56 + x55) + x25 * x57 + x53),
            x0 * (x12 * x2 * x6 * x64 - x61 * x63) + x36 * (x28 * x66 + x67 * x68),
            x0
            * (
                2.0 * x0 * x1 * x10 * x16 * x24 * x44 * x45 * x6 * x8
                - x32 * x6 * x69 * x70 * x8
            )
            + x36 * (x39 * x70 * x73 + 0.5 * x72),
            x0 * (x12 * x2 * x6 * x76 - x63 * x75) + x36 * (x68 * x80 + x79),
            x28 * x82 + x68 * x83,
            x28 * x85 + x68 * x86,
            0.5 * x87 + x73 * x80 / x3**3,
            x68 * x91 + x90,
            x36 * x92,
            x36 * x93,
            x36 * x95,
            x63 * x8 * x91,
            x36 * x96,
            x18 * x82 + x81 * x92,
            x37 * x85 + x81 * x93,
            x81 * x95 + x87,
            x90 + x91 * x94,
            x81 * x96,
            x18 * x89 + x88 * x96,
        ]
    )


def _3center2el3d_010(a, A, b, B, c, C):
    """Cartesian (sp|s) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = -x1 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x1 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = c * x0 * (x3**2 + x6**2 + x8**2) / x4
    x10 = A[0] - B[0]
    x11 = A[1] - B[1]
    x12 = A[2] - B[2]
    x13 = (
        34.9868366552497 * x1 * numpy.exp(-a * b * x1 * (x10**2 + x11**2 + x12**2))
    )
    x14 = x13 * x4 ** (-1.5) * boys(1, x9)
    x15 = x13 * x4 ** (-0.5) * boys(0, x9) / c

    # 3 item(s)
    return numpy.array(
        [
            x10 * x15 - x14 * x3 + x15 * (-x2 - A[0]),
            x11 * x15 - x14 * x6 + x15 * (-x5 - A[1]),
            x12 * x15 - x14 * x8 + x15 * (-x7 - A[2]),
        ]
    )


def _3center2el3d_011(a, A, b, B, c, C):
    """Cartesian (sp|p) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 / x4
    x12 = c * x11 * (x10**2 + x3**2 + x8**2)
    x13 = 17.4934183276249
    x14 = A[0] - B[0]
    x15 = A[1] - B[1]
    x16 = A[2] - B[2]
    x17 = numpy.exp(-a * b * x1 * (x14**2 + x15**2 + x16**2))
    x18 = 2.0 * x1 * x13 * x17
    x19 = x18 * boys(2, x12)
    x20 = c ** (-1.0)
    x21 = x4 ** (-0.5)
    x22 = boys(1, x12)
    x23 = x11 * (2.0 * x1 * x13 * x17 * x20 * x21 * x22 * (-x2 - A[0]) - x19 * x6)
    x24 = x20 * x22
    x25 = x18 * x21 * x24 / (2.0 * a + 2.0 * b + 2.0 * c)
    x26 = 2.0 * x13 * x17 * x24
    x27 = x14 * x26
    x28 = x27 * x5
    x29 = x19 * x5
    x30 = x11 * (2.0 * x1 * x13 * x17 * x20 * x21 * x22 * (-x7 - A[1]) - x29 * x8)
    x31 = x15 * x26
    x32 = x31 * x5
    x33 = x11 * (2.0 * x1 * x13 * x17 * x20 * x21 * x22 * (-x9 - A[2]) - x10 * x29)
    x34 = x16 * x26
    x35 = x34 * x5

    # 9 item(s)
    return numpy.array(
        [
            x23 * x3 + x25 + x27 * x6,
            x23 * x8 + x28 * x8,
            x10 * x23 + x10 * x28,
            x3 * x30 + x31 * x6,
            x25 + x30 * x8 + x32 * x8,
            x10 * x30 + x10 * x32,
            x3 * x33 + x34 * x6,
            x33 * x8 + x35 * x8,
            x10 * x33 + x10 * x35 + x25,
        ]
    )


def _3center2el3d_012(a, A, b, B, c, C):
    """Cartesian (sp|d) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = c ** (-1.0)
    x2 = 17.4934183276249
    x3 = a + b
    x4 = x3 ** (-1.0)
    x5 = A[1] - B[1]
    x6 = A[2] - B[2]
    x7 = numpy.exp(-a * b * x4 * (x0**2 + x5**2 + x6**2))
    x8 = 2.0 * x1 * x2 * x7
    x9 = c + x3
    x10 = x9 ** (-1.5)
    x11 = -x4 * (a * A[0] + b * B[0])
    x12 = -x11 - C[0]
    x13 = x12**2
    x14 = -x4 * (a * A[1] + b * B[1])
    x15 = -x14 - C[1]
    x16 = x15**2
    x17 = -x4 * (a * A[2] + b * B[2])
    x18 = -x17 - C[2]
    x19 = x18**2
    x20 = x3 / x9
    x21 = c * x20 * (x13 + x16 + x19)
    x22 = boys(1, x21)
    x23 = x10 * x22
    x24 = x9 ** (-0.5)
    x25 = boys(0, x21)
    x26 = 0.5 * x1
    x27 = x26 * (2.0 * x1 * x2 * x24 * x25 * x4 * x7 - x23 * x8)
    x28 = boys(2, x21)
    x29 = x28 * x3 * x8 * x9 ** (-2.5)
    x30 = x13 * x29 + x27
    x31 = x10 * x28
    x32 = x12 * x31
    x33 = 2.0 * x2 * x4 * x7
    x34 = -x11 - A[0]
    x35 = x12 * x33
    x36 = x26 * (
        2.0 * x1 * x2 * x24 * x25 * x34 * x4 * x7
        - x20 * (2.0 * x1 * x2 * x22 * x24 * x34 * x4 * x7 - x32 * x33)
        - x23 * x35
    )
    x37 = x10 * boys(3, x21)
    x38 = 2.0 * x1 * x2 * x24 * x28 * x34 * x4 * x7 - x35 * x37
    x39 = x12 * x20
    x40 = (2.0 * a + 2.0 * b + 2.0 * c) ** (-1.0)
    x41 = x24 * x28 * x4 * x40 * x8
    x42 = x40 * x8
    x43 = x3**2 / x9**2
    x44 = x38 * x43
    x45 = x12 * x44
    x46 = x31 * x42
    x47 = x15 * x46
    x48 = x12 * x15
    x49 = x0 * x29
    x50 = x18 * x46
    x51 = x12 * x18
    x52 = x16 * x29 + x27
    x53 = x15 * x18
    x54 = x19 * x29 + x27
    x55 = x15 * x33
    x56 = -x14 - A[1]
    x57 = x26 * (
        2.0 * x1 * x2 * x24 * x25 * x4 * x56 * x7
        - x20 * (2.0 * x1 * x2 * x22 * x24 * x4 * x56 * x7 - x31 * x55)
        - x23 * x55
    )
    x58 = 2.0 * x1 * x2 * x24 * x28 * x4 * x56 * x7 - x37 * x55
    x59 = x43 * x58
    x60 = x15 * x20
    x61 = x41 + x58 * x60
    x62 = x29 * x5
    x63 = x18 * x33
    x64 = -x17 - A[2]
    x65 = x26 * (
        2.0 * x1 * x2 * x24 * x25 * x4 * x64 * x7
        - x20 * (2.0 * x1 * x2 * x22 * x24 * x4 * x64 * x7 - x31 * x63)
        - x23 * x63
    )
    x66 = 2.0 * x1 * x2 * x24 * x28 * x4 * x64 * x7 - x37 * x63
    x67 = x43 * x66
    x68 = x29 * x6
    x69 = x18 * x20
    x70 = x41 + x66 * x69

    # 18 item(s)
    return numpy.array(
        [
            x0 * x30 + x32 * x42 + x36 + x39 * (x38 * x39 + x41),
            x15 * x45 + x47 + x48 * x49,
            x18 * x45 + x49 * x51 + x50,
            x0 * x52 + x16 * x44 + x36,
            x44 * x53 + x49 * x53,
            x0 * x54 + x19 * x44 + x36,
            x13 * x59 + x30 * x5 + x57,
            x39 * x61 + x48 * x62,
            x51 * x59 + x51 * x62,
            x47 + x5 * x52 + x57 + x60 * x61,
            x50 + x53 * x59 + x53 * x62,
            x19 * x59 + x5 * x54 + x57,
            x13 * x67 + x30 * x6 + x65,
            x48 * x67 + x48 * x68,
            x39 * x70 + x51 * x68,
            x16 * x67 + x52 * x6 + x65,
            x53 * x68 + x60 * x70,
            x50 + x54 * x6 + x65 + x69 * x70,
        ]
    )


def _3center2el3d_013(a, A, b, B, c, C):
    """Cartesian (sp|f) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x2 * x4
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(3, x16)
    x18 = 17.4934183276249
    x19 = x13 ** (-1.5)
    x20 = A[0] - B[0]
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x20**2 + x21**2 + x22**2))
    x24 = 2.0 * x18 * x19 * x23
    x25 = x17 * x24
    x26 = x13 ** (-0.5)
    x27 = -x3 - A[0]
    x28 = boys(2, x16)
    x29 = 2.0 * x0 * x18 * x2 * x23 * x26 * x27 * x28 - x25 * x5
    x30 = x15 * x29
    x31 = (2.0 * a + 2.0 * b + 2.0 * c) ** (-1.0)
    x32 = 2.0 * x18 * x23
    x33 = x2 * x26 * x32
    x34 = x0 * x28
    x35 = x31 * x33 * x34
    x36 = x24 * x28
    x37 = boys(1, x16)
    x38 = -2.0 * x0 * x18 * x2 * x23 * x26 * x27 * x37 + x36 * x5
    x39 = -x38
    x40 = x15 * x4
    x41 = x0 * x31 * x33 * x37
    x42 = 0.5 * x0
    x43 = x42 * (2.0 * x0 * x18 * x2 * x23 * x26 * x37 - x0 * x36)
    x44 = x1 * x13 ** (-2.5) * x32
    x45 = x0 * x17
    x46 = x45 * x6
    x47 = x43 + x44 * x46
    x48 = x34 * x44
    x49 = x0 * (2.0 * x0 * x18 * x19 * x23 * x37 * x4 - x4 * x48) + x40 * x47
    x50 = x42 * (-x30 - x38)
    x51 = x24 * boys(4, x16)
    x52 = 2.0 * x0 * x17 * x18 * x2 * x23 * x26 * x27 - x5 * x51
    x53 = x31 * x33 * x45
    x54 = x31 * x4
    x55 = x0 * x25
    x56 = x0 * (2.0 * x0 * x18 * x19 * x23 * x37 * x8 - x48 * x8)
    x57 = x1**2
    x58 = x13 ** (-3.5) * x32 * x57
    x59 = x46 * x58
    x60 = 0.5 * x56 + x59 * x8
    x61 = x57 / x13**2
    x62 = x29 * x61
    x63 = x0 * (x1 * x14 * x39 * x8 - x62 * x8)
    x64 = x52 * x61
    x65 = x4 * x64
    x66 = x31 * x55
    x67 = x66 * x8
    x68 = x4 * x8
    x69 = x44 * x45
    x70 = x31 * x69
    x71 = x0 * (2.0 * x0 * x11 * x18 * x19 * x23 * x37 - x11 * x48)
    x72 = 0.5 * x71
    x73 = x11 * x59 + x72
    x74 = x0 * (x1 * x11 * x14 * x39 - x11 * x62)
    x75 = 0.5 * x74
    x76 = x11 * x66
    x77 = x43 + x69 * x9
    x78 = x31 * x77
    x79 = x50 + x64 * x9
    x80 = x20 * x40
    x81 = x1**3 / x13**3
    x82 = x52 * x81
    x83 = x11 * x8
    x84 = x4 * x83
    x85 = x70 * x83
    x86 = x45 * x58
    x87 = x84 * x86
    x88 = x12 * x69 + x43
    x89 = x31 * x88
    x90 = x12 * x64 + x50
    x91 = x15 * x8
    x92 = x56 + x77 * x91
    x93 = x11 * x9
    x94 = x72 + x86 * x93
    x95 = x88 * x91
    x96 = x11 * x15
    x97 = x71 + x88 * x96
    x98 = x2 * x8
    x99 = -x7 - A[1]
    x100 = 2.0 * x0 * x18 * x2 * x23 * x26 * x28 * x99 - x25 * x98
    x101 = x100 * x61
    x102 = -2.0 * x0 * x18 * x2 * x23 * x26 * x37 * x99 + x36 * x98
    x103 = -x102
    x104 = x100 * x15
    x105 = x42 * (-x102 - x104)
    x106 = 2.0 * x0 * x17 * x18 * x2 * x23 * x26 * x99 - x51 * x98
    x107 = x6 * x61
    x108 = x0 * (x103 * x91 - x15 * (x104 * x8 + x35) + x41)
    x109 = x106 * x91 + x53
    x110 = x0 * (x1 * x103 * x11 * x14 - x101 * x11)
    x111 = 0.5 * x110
    x112 = x6 * x81
    x113 = x105 + x109 * x91 + x67
    x114 = x21 * x40
    x115 = x106 * x61
    x116 = x115 * x83 + x76
    x117 = x105 + x115 * x12
    x118 = x11 * x2
    x119 = -x10 - A[2]
    x120 = 2.0 * x0 * x119 * x18 * x2 * x23 * x26 * x28 - x118 * x25
    x121 = x120 * x61
    x122 = -2.0 * x0 * x119 * x18 * x2 * x23 * x26 * x37 + x118 * x36
    x123 = -x122
    x124 = x120 * x15
    x125 = x42 * (-x122 - x124)
    x126 = 2.0 * x0 * x119 * x17 * x18 * x2 * x23 * x26 - x118 * x51
    x127 = x0 * (x1 * x123 * x14 * x8 - x121 * x8)
    x128 = x0 * (x123 * x96 - x15 * (x11 * x124 + x35) + x41)
    x129 = 0.5 * x128
    x130 = x126 * x96 + x53
    x131 = x61 * x9
    x132 = x125 + x126 * x131
    x133 = x22 * x40
    x134 = x125 + x130 * x96 + x76

    # 30 item(s)
    return numpy.array(
        [
            x0 * (-x15 * (x30 * x4 + x35) + x39 * x40 + x41)
            + x20 * x49
            + x31 * x47
            + x40 * (x40 * (x40 * x52 + x53) + x50 + x54 * x55),
            x20 * x60 + x40 * (x65 * x8 + x67) + 0.5 * x63 + x68 * x70,
            x11 * x54 * x69 + x20 * x73 + x40 * (x11 * x65 + x76) + x75,
            x40 * x79 + x77 * x80 + x78,
            x20 * x87 + x82 * x84 + x85,
            x40 * x90 + x80 * x88 + x89,
            x20 * x92 + x63 + x79 * x91,
            x20 * x94 + x75 + x82 * x93,
            x20 * x95 + x90 * x91,
            x20 * x97 + x74 + x90 * x96,
            x0 * (x1 * x103 * x14 * x4 - x101 * x4)
            + x21 * x49
            + x40 * (x105 + x106 * x107),
            x107 * x109 + 0.5 * x108 + x21 * x60,
            x106 * x11 * x112 + x111 + x21 * x73,
            x113 * x40 + x114 * x77,
            x116 * x40 + x21 * x87,
            x114 * x88 + x117 * x40,
            x108 + x113 * x91 + x21 * x92 + x78,
            x111 + x116 * x91 + x21 * x94 + x85,
            x117 * x91 + x21 * x95 + x89,
            x110 + x117 * x96 + x21 * x97,
            x0 * (x1 * x123 * x14 * x4 - x121 * x4)
            + x22 * x49
            + x40 * (x107 * x126 + x125),
            x112 * x126 * x8 + 0.5 * x127 + x22 * x60,
            x107 * x130 + x129 + x22 * x73,
            x132 * x40 + x133 * x77,
            x130 * x61 * x68 + x22 * x87,
            x133 * x88 + x134 * x40,
            x127 + x132 * x91 + x22 * x92,
            x129 + x130 * x131 + x22 * x94,
            x134 * x91 + x22 * x95,
            x128 + x134 * x96 + x22 * x97 + x89,
        ]
    )


def _3center2el3d_014(a, A, b, B, c, C):
    """Cartesian (sp|g) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b + 2.0 * c) ** (-1.0)
    x1 = c ** (-1.0)
    x2 = 17.4934183276249
    x3 = a + b
    x4 = c + x3
    x5 = x4 ** (-1.5)
    x6 = x3 ** (-1.0)
    x7 = -x6 * (a * A[0] + b * B[0])
    x8 = -x7 - C[0]
    x9 = x8**2
    x10 = -x6 * (a * A[1] + b * B[1])
    x11 = -x10 - C[1]
    x12 = x11**2
    x13 = -x6 * (a * A[2] + b * B[2])
    x14 = -x13 - C[2]
    x15 = x14**2
    x16 = x4 ** (-1.0)
    x17 = x16 * x3
    x18 = c * x17 * (x12 + x15 + x9)
    x19 = boys(2, x18)
    x20 = A[0] - B[0]
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x6 * (x20**2 + x21**2 + x22**2))
    x24 = x4 ** (-2.5)
    x25 = x24 * x3
    x26 = boys(3, x18)
    x27 = 2.0 * x1 * x2 * x23
    x28 = x26 * x27
    x29 = x28 * x8
    x30 = x27 * x5
    x31 = x26 * x30
    x32 = x4 ** (-0.5)
    x33 = 0.5 * x1
    x34 = x33 * (2.0 * x1 * x19 * x2 * x23 * x32 * x6 - x31)
    x35 = x25 * x9
    x36 = boys(4, x18)
    x37 = x27 * x36
    x38 = x34 + x35 * x37
    x39 = x17 * x8
    x40 = x1 * (2.0 * x1 * x19 * x2 * x23 * x5 * x8 - x25 * x29) + x38 * x39
    x41 = boys(1, x18)
    x42 = boys(0, x18)
    x43 = x33 * (2.0 * x1 * x2 * x23 * x32 * x42 * x6 - x30 * x41)
    x44 = x19 * x30
    x45 = x33 * (2.0 * x1 * x2 * x23 * x32 * x41 * x6 - x44)
    x46 = x19 * x27
    x47 = 1.5 * x1
    x48 = x39 * x40 + x47 * (-x17 * (x28 * x35 + x45) + x35 * x46 + x43)
    x49 = x19 * x6
    x50 = 2.0 * x2 * x23 * x5
    x51 = x50 * x8
    x52 = -x7 - A[0]
    x53 = -2.0 * x1 * x2 * x23 * x32 * x41 * x52 * x6 + x49 * x51
    x54 = x51 * x6
    x55 = x33 * (2.0 * x1 * x2 * x23 * x32 * x42 * x52 * x6 + x17 * x53 - x41 * x54)
    x56 = -2.0 * x1 * x19 * x2 * x23 * x32 * x52 * x6 + x26 * x54
    x57 = -x56
    x58 = x17 * x57
    x59 = x33 * (-x53 - x58)
    x60 = 2.0 * x1 * x2 * x23 * x26 * x32 * x52 * x6 - x36 * x54
    x61 = x17 * x60
    x62 = x27 * x32
    x63 = x6 * x62
    x64 = x0 * x26 * x63
    x65 = x17 * (x61 * x8 + x64)
    x66 = x0 * x8
    x67 = x0 * x49 * x62
    x68 = x58 * x8 + x67
    x69 = x33 * (-x56 - x61)
    x70 = boys(5, x18)
    x71 = 2.0 * x1 * x2 * x23 * x32 * x36 * x52 * x6 - x54 * x70
    x72 = x0 * x36 * x63
    x73 = x30 * x36
    x74 = x3**2
    x75 = x4 ** (-2.0)
    x76 = x74 * x75
    x77 = x11 * x60
    x78 = x76 * x77
    x79 = x0 * x11
    x80 = x31 * x79
    x81 = x76 * x8
    x82 = x11 * x81
    x83 = x0 * x11 * x44
    x84 = x25 * x28
    x85 = x1 * (2.0 * x1 * x11 * x19 * x2 * x23 * x5 - x11 * x84)
    x86 = x4 ** (-3.5) * x74
    x87 = x11 * x86
    x88 = x37 * x9
    x89 = 0.5 * x85 + x87 * x88
    x90 = x11 * x8
    x91 = x86 * x90
    x92 = x1 * (2.0 * x1 * x11 * x19 * x2 * x23 * x24 * x3 * x8 - x28 * x91) + x39 * x89
    x93 = x1 * (x11 * x16 * x3 * x57 - x78)
    x94 = x73 * x79
    x95 = x25 * x37
    x96 = x60 * x76
    x97 = x14 * x96
    x98 = x0 * x14
    x99 = x31 * x98
    x100 = x14 * x81
    x101 = x0 * x14 * x44
    x102 = x1 * (2.0 * x1 * x14 * x19 * x2 * x23 * x5 - x14 * x84)
    x103 = 0.5 * x102
    x104 = x14 * x86
    x105 = x103 + x104 * x88
    x106 = (
        x1 * (2.0 * x1 * x14 * x19 * x2 * x23 * x24 * x3 * x8 - x104 * x29) + x105 * x39
    )
    x107 = x1 * (x14 * x16 * x3 * x57 - x97)
    x108 = 0.5 * x107
    x109 = x73 * x98
    x110 = x14 * x95
    x111 = x12 * x25
    x112 = x111 * x46 - x17 * (x12 * x84 + x45) + x43
    x113 = x111 * x37 + x34
    x114 = x76 * x9
    x115 = x112 * x33 + x113 * x114
    x116 = x12 * x76
    x117 = x116 * x57 - x17 * (x12 * x96 + x59) + x55
    x118 = x0 * x113
    x119 = x116 * x71 + x69
    x120 = x1 * (2.0 * x1 * x11 * x14 * x19 * x2 * x23 * x24 * x3 - x14 * x28 * x87)
    x121 = x3**3
    x122 = x11 * x121 * x14 * x4 ** (-4.5) * x88 + 0.5 * x120
    x123 = x121 / x4**3
    x124 = x123 * x14
    x125 = x1 * (x11 * x14 * x57 * x74 * x75 - x124 * x77)
    x126 = x124 * x71
    x127 = x110 * x79
    x128 = x15 * x25
    x129 = x128 * x46 - x17 * (x15 * x84 + x45) + x43
    x130 = x129 * x33
    x131 = x128 * x37 + x34
    x132 = x114 * x131 + x130
    x133 = x15 * x76
    x134 = x133 * x57 - x17 * (x15 * x96 + x59) + x55
    x135 = x134 * x33
    x136 = x0 * x131
    x137 = x133 * x71 + x69
    x138 = x11 * x17
    x139 = x113 * x138 + x85
    x140 = x0 * x139
    x141 = x119 * x138 + x93
    x142 = x20 * x39
    x143 = x103 + x104 * x12 * x37
    x144 = x0 * x143
    x145 = x108 + x12 * x126
    x146 = x136 * x138
    x147 = x131 * x82
    x148 = x14 * x17
    x149 = x102 + x131 * x148
    x150 = x0 * x149
    x151 = x107 + x137 * x148
    x152 = x112 * x47 + x138 * x139
    x153 = x120 + x138 * x143
    x154 = x116 * x131 + x130
    x155 = x138 * x149
    x156 = x129 * x47 + x148 * x149
    x157 = x11 * x50
    x158 = -x10 - A[1]
    x159 = -2.0 * x1 * x158 * x2 * x23 * x32 * x41 * x6 + x157 * x49
    x160 = x157 * x6
    x161 = x33 * (2.0 * x1 * x158 * x2 * x23 * x32 * x42 * x6 + x159 * x17 - x160 * x41)
    x162 = -2.0 * x1 * x158 * x19 * x2 * x23 * x32 * x6 + x160 * x26
    x163 = -x162
    x164 = x163 * x17
    x165 = x33 * (-x159 - x164)
    x166 = 2.0 * x1 * x158 * x2 * x23 * x26 * x32 * x6 - x160 * x36
    x167 = x166 * x17
    x168 = x33 * (-x162 - x167)
    x169 = 2.0 * x1 * x158 * x2 * x23 * x32 * x36 * x6 - x160 * x70
    x170 = x11 * x167 + x64
    x171 = x11 * x164 + x67
    x172 = x17 * x170
    x173 = x1 * (x171 - x172)
    x174 = x138 * x169 + x72
    x175 = x14 * x76
    x176 = x166 * x175
    x177 = x1 * (x14 * x16 * x163 * x3 - x176)
    x178 = 0.5 * x177
    x179 = x138 * x171 + x161 - x17 * (x11 * x172 + x165 + x80) + x83
    x180 = x138 * x174 + x168 + x94
    x181 = x11 * x175
    x182 = x1 * (x101 + x163 * x181 - x17 * (x11 * x176 + x99))
    x183 = x109 + x169 * x181
    x184 = x133 * x163 + x161 - x17 * (x133 * x166 + x165)
    x185 = x184 * x33
    x186 = x133 * x169 + x168
    x187 = x118 + x138 * x180 + x173
    x188 = x21 * x39
    x189 = x127 + x138 * x183 + x178
    x190 = x136 + x138 * x186
    x191 = x148 * x186 + x177
    x192 = x14 * x50
    x193 = -x13 - A[2]
    x194 = -2.0 * x1 * x193 * x2 * x23 * x32 * x41 * x6 + x192 * x49
    x195 = x192 * x6
    x196 = x33 * (2.0 * x1 * x193 * x2 * x23 * x32 * x42 * x6 + x17 * x194 - x195 * x41)
    x197 = -2.0 * x1 * x19 * x193 * x2 * x23 * x32 * x6 + x195 * x26
    x198 = -x197
    x199 = x17 * x198
    x200 = x33 * (-x194 - x199)
    x201 = 2.0 * x1 * x193 * x2 * x23 * x26 * x32 * x6 - x195 * x36
    x202 = x17 * x201
    x203 = x33 * (-x197 - x202)
    x204 = 2.0 * x1 * x193 * x2 * x23 * x32 * x36 * x6 - x195 * x70
    x205 = x11 * x123
    x206 = x11 * x76
    x207 = x1 * (x11 * x16 * x198 * x3 - x201 * x206)
    x208 = x205 * x9
    x209 = x14 * x202 + x64
    x210 = x14 * x199 + x67
    x211 = x17 * x209
    x212 = x1 * (x210 - x211)
    x213 = 0.5 * x212
    x214 = x148 * x204 + x72
    x215 = x116 * x198 - x17 * (x116 * x201 + x200) + x196
    x216 = x116 * x204 + x203
    x217 = x1 * (x11 * x16 * x210 * x3 - x206 * x209)
    x218 = x101 + x148 * x210 - x17 * (x14 * x211 + x200 + x99) + x196
    x219 = x218 * x33
    x220 = x109 + x148 * x214 + x203
    x221 = x138 * x216 + x207
    x222 = x22 * x39
    x223 = x116 * x214 + x213
    x224 = x136 + x148 * x220 + x212

    # 45 item(s)
    return numpy.array(
        [
            x0 * x40
            + x20 * x48
            + x39
            * (
                x0 * x38
                + x1 * (-x65 + x68)
                + x39 * (x39 * (x39 * x71 + x72) + x66 * x73 + x69)
            )
            + x47
            * (x0 * x44 * x8 - x17 * (x31 * x66 + x59 + x65 * x8) + x39 * x68 + x55),
            x0 * x89
            + x1 * (-x17 * (x78 * x8 + x80) + x57 * x82 + x83)
            + x20 * x92
            + x39 * (x0 * x90 * x95 + x39 * (x71 * x82 + x94) + 0.5 * x93),
            x0 * x105
            + x1 * (x100 * x57 + x101 - x17 * (x8 * x97 + x99))
            + x106 * x20
            + x39 * (x108 + x110 * x66 + x39 * (x100 * x71 + x109)),
            x115 * x20 + x117 * x33 + x118 * x39 + x39 * (x118 + x119 * x39),
            x122 * x20 + 0.5 * x125 + x37 * x91 * x98 + x39 * (x126 * x90 + x127),
            x132 * x20 + x135 + x136 * x39 + x39 * (x136 + x137 * x39),
            x139 * x142 + x140 + x141 * x39,
            x142 * x143 + x144 + x145 * x39,
            x137 * x82 + x146 + x147 * x20,
            x142 * x149 + x150 + x151 * x39,
            x117 * x47 + x138 * x141 + x152 * x20,
            x125 + x138 * x145 + x153 * x20,
            x116 * x137 + x135 + x154 * x20,
            x138 * x151 + x155 * x20,
            x134 * x47 + x148 * x151 + x156 * x20,
            x21 * x48
            + x39
            * (x1 * (x16 * x163 * x3 * x8 - x166 * x81) + x39 * (x114 * x169 + x168))
            + x47 * (x114 * x163 + x161 - x17 * (x114 * x166 + x165)),
            x1 * (x16 * x171 * x3 * x8 - x170 * x81)
            + x21 * x92
            + x39 * (x114 * x174 + 0.5 * x173),
            x1 * (-x124 * x166 * x8 + x14 * x163 * x74 * x75 * x8)
            + x106 * x21
            + x39 * (x124 * x169 * x9 + x178),
            x114 * x180 + x115 * x21 + x179 * x33,
            x114 * x183 + x122 * x21 + 0.5 * x182,
            x114 * x186 + x132 * x21 + x185,
            x139 * x188 + x187 * x39,
            x143 * x188 + x189 * x39,
            x147 * x21 + x190 * x39,
            x149 * x188 + x191 * x39,
            x138 * x187 + x140 + x152 * x21 + x179 * x47,
            x138 * x189 + x144 + x153 * x21 + x182,
            x138 * x190 + x146 + x154 * x21 + x185,
            x138 * x191 + x150 + x155 * x21,
            x148 * x191 + x156 * x21 + x184 * x47,
            x22 * x48
            + x39
            * (x1 * (x16 * x198 * x3 * x8 - x201 * x81) + x39 * (x114 * x204 + x203))
            + x47 * (x114 * x198 - x17 * (x114 * x201 + x200) + x196),
            x1 * (x11 * x198 * x74 * x75 * x8 - x201 * x205 * x8)
            + x22 * x92
            + x39 * (x204 * x208 + 0.5 * x207),
            x1 * (x16 * x210 * x3 * x8 - x209 * x81)
            + x106 * x22
            + x39 * (x114 * x214 + x213),
            x114 * x216 + x115 * x22 + x215 * x33,
            x122 * x22 + x208 * x214 + 0.5 * x217,
            x114 * x220 + x132 * x22 + x219,
            x139 * x222 + x221 * x39,
            x143 * x222 + x223 * x39,
            x147 * x22 + x220 * x82,
            x149 * x222 + x224 * x39,
            x138 * x221 + x152 * x22 + x215 * x47,
            x138 * x223 + x153 * x22 + x217,
            x116 * x220 + x154 * x22 + x219,
            x138 * x224 + x155 * x22,
            x148 * x224 + x150 + x156 * x22 + x218 * x47,
        ]
    )


def _3center2el3d_015(a, A, b, B, c, C):
    """Cartesian (sp|h) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b + 2.0 * c) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x4**2
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x1
    x13 = x12 ** (-1.0)
    x14 = x1 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(3, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[0] - B[0]
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x19**2 + x20**2 + x21**2))
    x23 = c ** (-1.0)
    x24 = 2.0 * x23
    x25 = x18 * x22 * x24
    x26 = x17 * x25
    x27 = x16 * x26
    x28 = x12 ** (-0.5)
    x29 = boys(2, x15)
    x30 = 0.5 * x23
    x31 = x30 * (2.0 * x18 * x2 * x22 * x23 * x28 * x29 - x27)
    x32 = x12 ** (-2.5)
    x33 = x1 * x32
    x34 = boys(4, x15)
    x35 = x25 * x34
    x36 = x35 * x5
    x37 = x31 + x33 * x36
    x38 = x14 * x37
    x39 = boys(1, x15)
    x40 = x30 * (2.0 * x18 * x2 * x22 * x23 * x28 * x39 - x26 * x29)
    x41 = x25 * x33
    x42 = x41 * x5
    x43 = x16 * x42 + x40
    x44 = 1.5 * x23
    x45 = x33 * x35
    x46 = x4 * x45
    x47 = x26 * x34
    x48 = x30 * (2.0 * x16 * x18 * x2 * x22 * x23 * x28 - x47)
    x49 = boys(5, x15)
    x50 = x42 * x49 + x48
    x51 = x14 * x4
    x52 = x23 * (2.0 * x16 * x17 * x18 * x22 * x23 * x4 - x46) + x50 * x51
    x53 = x44 * (-x38 + x43) + x51 * x52
    x54 = x29 * x41
    x55 = x16 * x4
    x56 = x41 * x55
    x57 = (
        x24
        * (
            -x14 * (x23 * (2.0 * x17 * x18 * x22 * x23 * x29 * x4 - x56) + x38 * x4)
            + x23 * (2.0 * x17 * x18 * x22 * x23 * x39 * x4 - x4 * x54)
            + x43 * x51
        )
        + x51 * x53
    )
    x58 = 2.0 * x17 * x18 * x2 * x22
    x59 = -x3 - A[0]
    x60 = -2.0 * x18 * x2 * x22 * x23 * x28 * x29 * x59 + x55 * x58
    x61 = -x60
    x62 = x14 * x61
    x63 = x2 * x25 * x28
    x64 = x0 * x29 * x63
    x65 = x4 * x62 + x64
    x66 = x4 * x58
    x67 = -2.0 * x18 * x2 * x22 * x23 * x28 * x39 * x59 + x29 * x66
    x68 = -x67
    x69 = x0 * x39 * x63
    x70 = -2.0 * x16 * x18 * x2 * x22 * x23 * x28 * x59 + x34 * x66
    x71 = -x70
    x72 = x14 * x71
    x73 = x0 * x16 * x63
    x74 = x4 * x72 + x73
    x75 = x14 * x74
    x76 = x30 * (-x60 - x72)
    x77 = 2.0 * x18 * x2 * x22 * x23 * x28 * x34 * x59 - x49 * x66
    x78 = x14 * x77
    x79 = x0 * x34 * x63
    x80 = x14 * (x4 * x78 + x79)
    x81 = x0 * x4
    x82 = x14 * (x4 * x80 + x47 * x81 + x76)
    x83 = x30 * (-x62 - x67)
    x84 = x0 * x27 * x4 + x4 * x75 + x83
    x85 = x30 * (-x70 - x78)
    x86 = boys(6, x15)
    x87 = 2.0 * x18 * x2 * x22 * x23 * x28 * x49 * x59 - x66 * x86
    x88 = x0 * x49 * x63
    x89 = x26 * x49
    x90 = x35 * x4
    x91 = x1**2
    x92 = x12 ** (-3.5)
    x93 = x91 * x92
    x94 = x7 * x93
    x95 = x23 * (2.0 * x16 * x17 * x18 * x22 * x23 * x7 - x45 * x7)
    x96 = x25 * x5
    x97 = x94 * x96
    x98 = x49 * x97 + 0.5 * x95
    x99 = x23 * (2.0 * x1 * x16 * x18 * x22 * x23 * x32 * x4 * x7 - x90 * x94) + x51 * x98
    x100 = x23 * (2.0 * x17 * x18 * x22 * x23 * x39 * x7 - x54 * x7)
    x101 = x16 * x41
    x102 = x23 * (-x101 * x7 + 2.0 * x17 * x18 * x22 * x23 * x29 * x7)
    x103 = x44 * (0.5 * x100 - x14 * (0.5 * x102 + x36 * x94) + x16 * x97) + x51 * x99
    x104 = x12 ** (-2.0)
    x105 = x104 * x91
    x106 = x105 * x7
    x107 = x23 * (x1 * x13 * x68 * x7 - x106 * x61)
    x108 = x106 * x71
    x109 = x23 * (x1 * x13 * x61 * x7 - x108)
    x110 = x106 * x77
    x111 = x0 * x7
    x112 = x111 * x47
    x113 = x14 * (x110 * x4 + x112)
    x114 = x0 * x27 * x7
    x115 = x108 * x4 + x114
    x116 = x23 * (x1 * x13 * x7 * x71 - x110)
    x117 = x4 * x87
    x118 = x111 * x89
    x119 = x41 * x49
    x120 = x119 * x81
    x121 = x10 * x93
    x122 = x23 * (2.0 * x10 * x16 * x17 * x18 * x22 * x23 - x10 * x45)
    x123 = 0.5 * x122
    x124 = x121 * x96
    x125 = x123 + x124 * x49
    x126 = x125 * x51 + x23 * (
        2.0 * x1 * x10 * x16 * x18 * x22 * x23 * x32 * x4 - x121 * x90
    )
    x127 = x23 * (2.0 * x10 * x17 * x18 * x22 * x23 * x39 - x10 * x54)
    x128 = 0.5 * x127
    x129 = x23 * (-x10 * x101 + 2.0 * x10 * x17 * x18 * x22 * x23 * x29)
    x130 = 0.5 * x129
    x131 = x126 * x51 + x44 * (x124 * x16 + x128 - x14 * (x121 * x36 + x130))
    x132 = x10 * x105
    x133 = x23 * (x1 * x10 * x13 * x68 - x132 * x61)
    x134 = 0.5 * x133
    x135 = x132 * x71
    x136 = x23 * (x1 * x10 * x13 * x61 - x135)
    x137 = 0.5 * x136
    x138 = x132 * x77
    x139 = x0 * x10
    x140 = x139 * x47
    x141 = x14 * (x138 * x4 + x140)
    x142 = x0 * x10 * x27
    x143 = x135 * x4 + x142
    x144 = x23 * (x1 * x10 * x13 * x71 - x138)
    x145 = 0.5 * x144
    x146 = x139 * x89
    x147 = x101 * x8 + x40
    x148 = x0 * x147
    x149 = x31 + x45 * x8
    x150 = x0 * x149
    x151 = x105 * x8
    x152 = x14 * (x151 * x77 + x76)
    x153 = x151 * x71 + x83
    x154 = x14 * x149
    x155 = x147 - x154
    x156 = x119 * x8 + x48
    x157 = x105 * x5
    x158 = x155 * x30 + x156 * x157
    x159 = x105 * x4
    x160 = x158 * x51 + x23 * (x1 * x13 * x147 * x4 - x149 * x159)
    x161 = -x152 + x153
    x162 = x0 * x156
    x163 = x151 * x87 + x85
    x164 = x10 * x7
    x165 = x1**3
    x166 = x165 / x12**3
    x167 = x166 * x77
    x168 = x164 * x167
    x169 = x0 * x164
    x170 = x169 * x45
    x171 = x166 * x4
    x172 = x0 * x101 * x164
    x173 = x35 * x93
    x174 = x23 * (2.0 * x1 * x10 * x16 * x18 * x22 * x23 * x32 * x7 - x164 * x173)
    x175 = x164 * x49
    x176 = x12 ** (-4.5) * x165
    x177 = 0.5 * x174 + x175 * x176 * x96
    x178 = x177 * x51 + x23 * (
        2.0 * x10 * x16 * x18 * x22 * x23 * x4 * x7 * x91 * x92 - x164 * x176 * x90
    )
    x179 = x23 * (x10 * x104 * x7 * x71 * x91 - x168)
    x180 = x119 * x169
    x181 = x25 * x93
    x182 = x101 * x11 + x40
    x183 = x0 * x182
    x184 = x11 * x45 + x31
    x185 = x0 * x184
    x186 = x105 * x11
    x187 = x186 * x77 + x76
    x188 = x14 * x187
    x189 = x186 * x71 + x83
    x190 = x14 * x184
    x191 = x182 - x190
    x192 = x191 * x30
    x193 = x11 * x119 + x48
    x194 = x157 * x193 + x192
    x195 = x194 * x51 + x23 * (x1 * x13 * x182 * x4 - x159 * x184)
    x196 = -x188 + x189
    x197 = x196 * x30
    x198 = x0 * x193
    x199 = x186 * x87 + x85
    x200 = x14 * x7
    x201 = x100 - x14 * (x102 + x154 * x7) + x147 * x200
    x202 = x156 * x200 + x95
    x203 = x157 * x202 + x201 * x30
    x204 = x107 - x14 * (x109 + x152 * x7) + x153 * x200
    x205 = x0 * x202
    x206 = x116 + x163 * x200
    x207 = x10 * x8
    x208 = x181 * x207
    x209 = x128 - x14 * (x130 + x173 * x207) + x16 * x208
    x210 = x123 + x208 * x49
    x211 = x157 * x210 + x209 * x30
    x212 = x166 * x207
    x213 = x134 - x14 * (x137 + x167 * x207) + x212 * x71
    x214 = x0 * x210
    x215 = x145 + x212 * x87
    x216 = x23 * (x1 * x13 * x182 * x7 - x106 * x184)
    x217 = x166 * x5
    x218 = x217 * x7
    x219 = x193 * x218 + 0.5 * x216
    x220 = x23 * (x1 * x13 * x189 * x7 - x106 * x187)
    x221 = x106 * x4
    x222 = x198 * x200
    x223 = x10 * x14
    x224 = x127 - x14 * (x10 * x190 + x129) + x182 * x223
    x225 = x224 * x30
    x226 = x122 + x193 * x223
    x227 = x157 * x226 + x225
    x228 = x133 - x14 * (x10 * x188 + x136) + x189 * x223
    x229 = x228 * x30
    x230 = x0 * x226
    x231 = x144 + x199 * x223
    x232 = x155 * x44 + x200 * x202
    x233 = x0 * x232
    x234 = x161 * x44 + x200 * x206
    x235 = x19 * x51
    x236 = x174 + x200 * x210
    x237 = x0 * x236
    x238 = x179 + x200 * x215
    x239 = x151 * x193 + x192
    x240 = x0 * x239
    x241 = x151 * x199 + x197
    x242 = x200 * x230
    x243 = x221 * x226
    x244 = x191 * x44 + x223 * x226
    x245 = x0 * x244
    x246 = x196 * x44 + x223 * x231
    x247 = x200 * x232 + x201 * x24
    x248 = x200 * x236 + x209 * x44
    x249 = x200 * x239 + x216
    x250 = x151 * x226 + x225
    x251 = x200 * x244
    x252 = x223 * x244 + x224 * x24
    x253 = x58 * x7
    x254 = -x6 - A[1]
    x255 = x16 * x253 - 2.0 * x18 * x2 * x22 * x23 * x254 * x28 * x29
    x256 = -x255
    x257 = -2.0 * x18 * x2 * x22 * x23 * x254 * x28 * x39 + x253 * x29
    x258 = -x257
    x259 = -2.0 * x16 * x18 * x2 * x22 * x23 * x254 * x28 + x253 * x34
    x260 = -x259
    x261 = x14 * x260
    x262 = x30 * (-x255 - x261)
    x263 = 2.0 * x18 * x2 * x22 * x23 * x254 * x28 * x34 - x253 * x49
    x264 = x14 * (x157 * x263 + x262)
    x265 = x14 * x256
    x266 = x30 * (-x257 - x265)
    x267 = x157 * x260 + x266
    x268 = x14 * x263
    x269 = x30 * (-x259 - x268)
    x270 = 2.0 * x18 * x2 * x22 * x23 * x254 * x28 * x49 - x253 * x86
    x271 = x265 * x7 + x64
    x272 = x23 * (-x14 * x271 + x200 * x258 + x69)
    x273 = x261 * x7 + x73
    x274 = x14 * x273
    x275 = x23 * (x271 - x274)
    x276 = x268 * x7 + x79
    x277 = x14 * x276
    x278 = x23 * (x273 - x277)
    x279 = x200 * x270 + x88
    x280 = x23 * (x1 * x10 * x13 * x258 - x132 * x256)
    x281 = 0.5 * x280
    x282 = x23 * (x1 * x10 * x13 * x256 - x132 * x260)
    x283 = 0.5 * x282
    x284 = x10 * x217
    x285 = x10 * x263
    x286 = x23 * (x1 * x10 * x13 * x260 - x132 * x263)
    x287 = 0.5 * x286
    x288 = x112 + x262 + x277 * x7
    x289 = x114 + x266 + x274 * x7
    x290 = x14 * x288
    x291 = x289 - x290
    x292 = x118 + x200 * x279 + x269
    x293 = x106 * x285 + x140
    x294 = x10 * x106
    x295 = x142 + x260 * x294
    x296 = x14 * x293
    x297 = x23 * (x295 - x296)
    x298 = x146 + x270 * x294
    x299 = x186 * x263 + x262
    x300 = x186 * x260 + x266
    x301 = x14 * x299
    x302 = x300 - x301
    x303 = x30 * x302
    x304 = x186 * x270 + x269
    x305 = -x14 * (x150 + x275 + x290 * x7) + x148 + x200 * x289 + x272
    x306 = x162 + x200 * x292 + x278
    x307 = -x14 * (x170 + x283 + x296 * x7) + x172 + x200 * x295 + x281
    x308 = x180 + x200 * x298 + x287
    x309 = x23 * (-x14 * (x185 + x301 * x7) + x183 + x200 * x300)
    x310 = x198 + x200 * x304
    x311 = -x14 * (x10 * x301 + x282) + x223 * x300 + x280
    x312 = x30 * x311
    x313 = x223 * x304 + x286
    x314 = x200 * x306 + x205 + x291 * x44
    x315 = x20 * x51
    x316 = x200 * x308 + x214 + x297
    x317 = x200 * x310 + x222 + x303
    x318 = x200 * x313 + x230
    x319 = x223 * x313 + x302 * x44
    x320 = x10 * x58
    x321 = -x9 - A[2]
    x322 = x16 * x320 - 2.0 * x18 * x2 * x22 * x23 * x28 * x29 * x321
    x323 = -x322
    x324 = -2.0 * x18 * x2 * x22 * x23 * x28 * x321 * x39 + x29 * x320
    x325 = -x324
    x326 = -2.0 * x16 * x18 * x2 * x22 * x23 * x28 * x321 + x320 * x34
    x327 = -x326
    x328 = x14 * x327
    x329 = x30 * (-x322 - x328)
    x330 = 2.0 * x18 * x2 * x22 * x23 * x28 * x321 * x34 - x320 * x49
    x331 = x14 * (x157 * x330 + x329)
    x332 = x14 * x323
    x333 = x30 * (-x324 - x332)
    x334 = x157 * x327 + x333
    x335 = x14 * x330
    x336 = x30 * (-x326 - x335)
    x337 = 2.0 * x18 * x2 * x22 * x23 * x28 * x321 * x49 - x320 * x86
    x338 = x23 * (x1 * x13 * x325 * x7 - x106 * x323)
    x339 = x23 * (x1 * x13 * x323 * x7 - x106 * x327)
    x340 = x171 * x7
    x341 = x23 * (x1 * x13 * x327 * x7 - x106 * x330)
    x342 = x10 * x332 + x64
    x343 = x23 * (-x14 * x342 + x223 * x325 + x69)
    x344 = 0.5 * x343
    x345 = x10 * x328 + x73
    x346 = x14 * x345
    x347 = x23 * (x342 - x346)
    x348 = 0.5 * x347
    x349 = x10 * x335 + x79
    x350 = x14 * x349
    x351 = x23 * (x345 - x350)
    x352 = 0.5 * x351
    x353 = x223 * x337 + x88
    x354 = x151 * x330 + x329
    x355 = x151 * x327 + x333
    x356 = x14 * x354
    x357 = x355 - x356
    x358 = x151 * x337 + x336
    x359 = x23 * (x1 * x13 * x345 * x7 - x106 * x349)
    x360 = x10 * x350 + x140 + x329
    x361 = x10 * x346 + x142 + x333
    x362 = x14 * x360
    x363 = x361 - x362
    x364 = x30 * x363
    x365 = x146 + x223 * x353 + x336
    x366 = -x14 * (x339 + x356 * x7) + x200 * x355 + x338
    x367 = x200 * x358 + x341
    x368 = -x14 * (x151 * x349 + x348) + x151 * x345 + x344
    x369 = x151 * x353 + x352
    x370 = x23 * (x1 * x13 * x361 * x7 - x106 * x360)
    x371 = -x14 * (x10 * x362 + x185 + x347) + x183 + x223 * x361 + x343
    x372 = x30 * x371
    x373 = x198 + x223 * x365 + x351
    x374 = x200 * x367 + x357 * x44
    x375 = x21 * x51
    x376 = x200 * x369 + x359
    x377 = x151 * x365 + x364
    x378 = x223 * x373 + x230 + x363 * x44

    # 63 item(s)
    return numpy.array(
        [
            x0 * x53
            + x19 * x57
            + x24
            * (
                x0 * x43
                - x14 * (x0 * x37 + x23 * (x65 - x75) + x4 * x82)
                + x23 * (-x14 * x65 + x51 * x68 + x69)
                + x51 * x84
            )
            + x51
            * (
                x0 * x52
                + x44 * (-x82 + x84)
                + x51
                * (
                    x0 * x50
                    + x23 * (x74 - x80)
                    + x51 * (x51 * (x51 * x87 + x88) + x81 * x89 + x85)
                )
            ),
            x0 * x99
            + x103 * x19
            + x44
            * (
                0.5 * x107
                + x111 * x56
                + x115 * x51
                - x14 * (0.5 * x109 + x111 * x46 + x113 * x4)
            )
            + x51
            * (
                x0 * x98
                + x23 * (-x113 + x115)
                + x51 * (0.5 * x116 + x120 * x7 + x51 * (x106 * x117 + x118))
            ),
            x0 * x126
            + x131 * x19
            + x44
            * (x134 + x139 * x56 - x14 * (x137 + x139 * x46 + x141 * x4) + x143 * x51)
            + x51
            * (
                x0 * x125
                + x23 * (-x141 + x143)
                + x51 * (x10 * x120 + x145 + x51 * (x117 * x132 + x146))
            ),
            x0 * x158
            + x160 * x19
            + x23 * (-x14 * (x150 + x152 * x4) + x148 + x153 * x51)
            + x51 * (x161 * x30 + x162 * x51 + x51 * (x162 + x163 * x51)),
            x0 * x177
            + x178 * x19
            + x23 * (-x14 * (x168 * x4 + x170) + x164 * x171 * x71 + x172)
            + x51 * (x175 * x181 * x81 + 0.5 * x179 + x51 * (x117 * x164 * x166 + x180)),
            x0 * x194
            + x19 * x195
            + x23 * (-x14 * (x185 + x188 * x4) + x183 + x189 * x51)
            + x51 * (x197 + x198 * x51 + x51 * (x198 + x199 * x51)),
            x19 * x203 + x204 * x30 + x205 * x51 + x51 * (x205 + x206 * x51),
            x19 * x211 + x213 * x30 + x214 * x51 + x51 * (x214 + x215 * x51),
            x19 * x219 + x198 * x221 + 0.5 * x220 + x51 * (x199 * x221 + x222),
            x19 * x227 + x229 + x230 * x51 + x51 * (x230 + x231 * x51),
            x232 * x235 + x233 + x234 * x51,
            x235 * x236 + x237 + x238 * x51,
            x235 * x239 + x240 + x241 * x51,
            x19 * x243 + x221 * x231 + x242,
            x235 * x244 + x245 + x246 * x51,
            x19 * x247 + x200 * x234 + x204 * x24,
            x19 * x248 + x200 * x238 + x213 * x44,
            x19 * x249 + x200 * x241 + x220,
            x151 * x231 + x19 * x250 + x229,
            x19 * x251 + x200 * x246,
            x19 * x252 + x223 * x246 + x228 * x24,
            x20 * x57
            + x24
            * (
                -x14 * (x23 * (x1 * x13 * x256 * x4 - x159 * x260) + x264 * x4)
                + x23 * (x1 * x13 * x258 * x4 - x159 * x256)
                + x267 * x51
            )
            + x51
            * (
                x44 * (-x264 + x267)
                + x51
                * (
                    x23 * (x1 * x13 * x260 * x4 - x159 * x263)
                    + x51 * (x157 * x270 + x269)
                )
            ),
            x103 * x20
            + x44 * (-x14 * (x157 * x276 + 0.5 * x275) + x157 * x273 + 0.5 * x272)
            + x51
            * (
                x23 * (x1 * x13 * x273 * x4 - x159 * x276)
                + x51 * (x157 * x279 + 0.5 * x278)
            ),
            x131 * x20
            + x44 * (-x14 * (x263 * x284 + x283) + x260 * x284 + x281)
            + x51
            * (
                x23 * (x10 * x104 * x260 * x4 * x91 - x171 * x285)
                + x51 * (x270 * x284 + x287)
            ),
            x160 * x20
            + x23 * (x1 * x13 * x289 * x4 - x159 * x288)
            + x51 * (x157 * x292 + x291 * x30),
            x178 * x20
            + x23 * (x1 * x13 * x295 * x4 - x159 * x293)
            + x51 * (x157 * x298 + 0.5 * x297),
            x195 * x20
            + x23 * (x1 * x13 * x300 * x4 - x159 * x299)
            + x51 * (x157 * x304 + x303),
            x157 * x306 + x20 * x203 + x30 * x305,
            x157 * x308 + x20 * x211 + x30 * x307,
            x157 * x310 + x20 * x219 + 0.5 * x309,
            x157 * x313 + x20 * x227 + x312,
            x232 * x315 + x314 * x51,
            x236 * x315 + x316 * x51,
            x239 * x315 + x317 * x51,
            x20 * x243 + x318 * x51,
            x244 * x315 + x319 * x51,
            x20 * x247 + x200 * x314 + x233 + x24 * x305,
            x20 * x248 + x200 * x316 + x237 + x307 * x44,
            x20 * x249 + x200 * x317 + x240 + x309,
            x20 * x250 + x200 * x318 + x242 + x312,
            x20 * x251 + x200 * x319 + x245,
            x20 * x252 + x223 * x319 + x24 * x311,
            x21 * x57
            + x24
            * (
                -x14 * (x23 * (x1 * x13 * x323 * x4 - x159 * x327) + x331 * x4)
                + x23 * (x1 * x13 * x325 * x4 - x159 * x323)
                + x334 * x51
            )
            + x51
            * (
                x44 * (-x331 + x334)
                + x51
                * (
                    x23 * (x1 * x13 * x327 * x4 - x159 * x330)
                    + x51 * (x157 * x337 + x336)
                )
            ),
            x103 * x21
            + x44 * (-x14 * (x218 * x330 + 0.5 * x339) + x218 * x327 + 0.5 * x338)
            + x51
            * (
                x23 * (x104 * x327 * x4 * x7 * x91 - x330 * x340)
                + x51 * (x218 * x337 + 0.5 * x341)
            ),
            x131 * x21
            + x44 * (-x14 * (x157 * x349 + x348) + x157 * x345 + x344)
            + x51
            * (x23 * (x1 * x13 * x345 * x4 - x159 * x349) + x51 * (x157 * x353 + x352)),
            x160 * x21
            + x23 * (x1 * x13 * x355 * x4 - x159 * x354)
            + x51 * (x157 * x358 + x30 * x357),
            x178 * x21
            + x23 * (x104 * x345 * x4 * x7 * x91 - x340 * x349)
            + x51 * (x218 * x353 + 0.5 * x359),
            x195 * x21
            + x23 * (x1 * x13 * x361 * x4 - x159 * x360)
            + x51 * (x157 * x365 + x364),
            x157 * x367 + x203 * x21 + x30 * x366,
            x157 * x369 + x21 * x211 + x30 * x368,
            x21 * x219 + x218 * x365 + 0.5 * x370,
            x157 * x373 + x21 * x227 + x372,
            x232 * x375 + x374 * x51,
            x236 * x375 + x376 * x51,
            x239 * x375 + x377 * x51,
            x21 * x243 + x221 * x373,
            x244 * x375 + x378 * x51,
            x200 * x374 + x21 * x247 + x24 * x366,
            x200 * x376 + x21 * x248 + x368 * x44,
            x200 * x377 + x21 * x249 + x370,
            x151 * x373 + x21 * x250 + x372,
            x200 * x378 + x21 * x251,
            x21 * x252 + x223 * x378 + x24 * x371 + x245,
        ]
    )


def _3center2el3d_020(a, A, b, B, c, C):
    """Cartesian (sd|s) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = c + x0
    x9 = c / x8
    x10 = x0 * x9 * (x3**2 + x5**2 + x7**2)
    x11 = boys(1, x10)
    x12 = 17.4934183276249
    x13 = A[0] - B[0]
    x14 = A[1] - B[1]
    x15 = A[2] - B[2]
    x16 = numpy.exp(-a * b * x1 * (x13**2 + x14**2 + x15**2))
    x17 = 2.0 * x1 * x12 * x16
    x18 = x17 * x8 ** (-1.5)
    x19 = x11 * x18
    x20 = c ** (-1.0)
    x21 = x8 ** (-0.5)
    x22 = boys(0, x10)
    x23 = (2.0 * x1 * x12 * x16 * x20 * x21 * x22 - x19) / (2.0 * a + 2.0 * b)
    x24 = x19 * x3
    x25 = -x2 - A[0]
    x26 = 2.0 * x1 * x12 * x16 * x20 * x21 * x22 * x25 - x24
    x27 = x17 * x20 * x21 * x22
    x28 = x18 * boys(2, x10)
    x29 = x3 * x9
    x30 = x19 * x5
    x31 = -x4 - A[1]
    x32 = x14 * x27 + x27 * x31 - x30
    x33 = 2.0 * x1 * x12 * x16 * x20 * x21 * x22 * x31 - x30
    x34 = 2.0 * x1 * x11 * x12 * x16 * x20 * x21 * x31 - x28 * x5
    x35 = x19 * x7
    x36 = -x6 - A[2]
    x37 = x15 * x27 + x27 * x36 - x35
    x38 = 2.0 * x1 * x12 * x16 * x20 * x21 * x22 * x36 - x35
    x39 = 2.0 * x1 * x11 * x12 * x16 * x20 * x21 * x36 - x28 * x7
    x40 = x5 * x9

    # 6 item(s)
    return numpy.array(
        [
            x13 * x26
            + x13 * (x13 * x27 - x24 + x25 * x27)
            + x23
            + x25 * x26
            - x29 * (2.0 * x1 * x11 * x12 * x16 * x20 * x21 * x25 - x28 * x3),
            x13 * x32 + x14 * x26 + x25 * x33 - x29 * x34,
            x13 * x37 + x15 * x26 + x25 * x38 - x29 * x39,
            x14 * x32 + x14 * x33 + x23 + x31 * x33 - x34 * x40,
            x14 * x37 + x15 * x33 + x31 * x38 - x39 * x40,
            x15 * x37 + x15 * x38 + x23 + x36 * x38 - x39 * x7 * x9,
        ]
    )


def _3center2el3d_021(a, A, b, B, c, C):
    """Cartesian (sd|p) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x2 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x2 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = c + x1
    x10 = x9 ** (-1.0)
    x11 = x1 * x10
    x12 = c * x11 * (x4**2 + x6**2 + x8**2)
    x13 = boys(2, x12)
    x14 = x9 ** (-1.5)
    x15 = 17.4934183276249
    x16 = A[1] - B[1]
    x17 = A[2] - B[2]
    x18 = numpy.exp(-a * b * x2 * (x0**2 + x16**2 + x17**2))
    x19 = 2.0 * x15 * x18 * x2
    x20 = x14 * x19
    x21 = x13 * x20
    x22 = c ** (-1.0)
    x23 = x9 ** (-0.5)
    x24 = -x3 - A[0]
    x25 = boys(1, x12)
    x26 = 2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x25 - x21 * x4
    x27 = x11 * x4
    x28 = 2.0 * a + 2.0 * b
    x29 = (2.0 * c + x28) ** (-1.0)
    x30 = x22 * x25
    x31 = x19 * x23 * x29 * x30
    x32 = x26 * x27 + x31
    x33 = 2.0 * x14 * x15 * x18 * x30
    x34 = x0 * x33
    x35 = x26 * x29
    x36 = (2.0 * x15 * x18 * x2 * x22 * x23 * x25 - x21) / x28
    x37 = x20 * boys(3, x12)
    x38 = c * x10
    x39 = x38 * x4
    x40 = (
        x24 * x26 + x36 - x39 * (2.0 * x13 * x15 * x18 * x2 * x22 * x23 * x24 - x37 * x4)
    )
    x41 = x11 * x6
    x42 = x26 * x41
    x43 = x11 * x8
    x44 = x26 * x43
    x45 = -x5 - A[1]
    x46 = 2.0 * x15 * x18 * x2 * x22 * x23 * x25 * x45 - x21 * x6
    x47 = x29 * x46
    x48 = x27 * x46
    x49 = x16 * x33
    x50 = x4 * x49 + x48
    x51 = 2.0 * x13 * x15 * x18 * x2 * x22 * x23 * x45 - x37 * x6
    x52 = x24 * x46 - x39 * x51
    x53 = x31 + x41 * x46
    x54 = x49 * x6 + x53
    x55 = x43 * x46
    x56 = x49 * x8 + x55
    x57 = -x7 - A[2]
    x58 = 2.0 * x15 * x18 * x2 * x22 * x23 * x25 * x57 - x21 * x8
    x59 = x29 * x58
    x60 = x27 * x58
    x61 = x17 * x33
    x62 = x4 * x61 + x60
    x63 = 2.0 * x13 * x15 * x18 * x2 * x22 * x23 * x57 - x37 * x8
    x64 = x24 * x58 - x39 * x63
    x65 = x41 * x58
    x66 = x6 * x61 + x65
    x67 = x31 + x43 * x58
    x68 = x61 * x8 + x67
    x69 = x38 * x6
    x70 = x36 + x45 * x46 - x51 * x69
    x71 = x45 * x58 - x63 * x69
    x72 = x36 - x38 * x63 * x8 + x57 * x58

    # 18 item(s)
    return numpy.array(
        [
            x0 * x32 + x0 * (x32 + x34 * x4) + x27 * x40 + 2.0 * x35,
            x0 * x42 + x0 * (x34 * x6 + x42) + x40 * x41,
            x0 * x44 + x0 * (x34 * x8 + x44) + x40 * x43,
            x0 * x50 + x16 * x32 + x27 * x52 + x47,
            x0 * x54 + x16 * x42 + x35 + x41 * x52,
            x0 * x56 + x16 * x44 + x43 * x52,
            x0 * x62 + x17 * x32 + x27 * x64 + x59,
            x0 * x66 + x17 * x42 + x41 * x64,
            x0 * x68 + x17 * x44 + x35 + x43 * x64,
            x16 * x48 + x16 * x50 + x27 * x70,
            x16 * x53 + x16 * x54 + x41 * x70 + 2.0 * x47,
            x16 * x55 + x16 * x56 + x43 * x70,
            x16 * x62 + x17 * x48 + x27 * x71,
            x16 * x66 + x17 * x53 + x41 * x71 + x59,
            x16 * x68 + x17 * x55 + x43 * x71 + x47,
            x17 * x60 + x17 * x62 + x27 * x72,
            x17 * x65 + x17 * x66 + x41 * x72,
            x17 * x67 + x17 * x68 + x43 * x72 + 2.0 * x59,
        ]
    )


def _3center2el3d_022(a, A, b, B, c, C):
    """Cartesian (sd|d) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x4**2
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x1
    x13 = x12 ** (-1.0)
    x14 = x1 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(2, x15)
    x17 = x12 ** (-1.5)
    x18 = 2.0 * x17
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x2 * x22
    x24 = x18 * x23
    x25 = x16 * x24
    x26 = c ** (-1.0)
    x27 = x12 ** (-0.5)
    x28 = -x3 - A[0]
    x29 = boys(1, x15)
    x30 = 2.0 * x19 * x2 * x22 * x26 * x27 * x28 * x29 - x25 * x4
    x31 = x18 * x29
    x32 = x23 * x31
    x33 = boys(0, x15)
    x34 = -2.0 * x19 * x2 * x22 * x26 * x27 * x28 * x33 + x32 * x4
    x35 = 0.5 * x26
    x36 = x35 * (-x14 * x30 - x34)
    x37 = boys(3, x15)
    x38 = x24 * x37
    x39 = 2.0 * x16 * x19 * x2 * x22 * x26 * x27 * x28 - x38 * x4
    x40 = x14 * x4
    x41 = 2.0 * a + 2.0 * b
    x42 = (2.0 * c + x41) ** (-1.0)
    x43 = 2.0 * x42
    x44 = x19 * x22 * x26
    x45 = x16 * x43 * x44
    x46 = x2 * x27 * x45
    x47 = x39 * x40 + x46
    x48 = x17 * x45
    x49 = x36 + x4 * x48 + x40 * x47
    x50 = -2.0 * x19 * x2 * x22 * x26 * x27 * x33
    x51 = x35 * (-x31 * x44 - x50)
    x52 = 2.0 * x1 * x12 ** (-2.5) * x16 * x44
    x53 = x5 * x52 + x51
    x54 = x41 ** (-1.0)
    x55 = -x54 * (-x32 - x50)
    x56 = x54 * (2.0 * x19 * x2 * x22 * x26 * x27 * x29 - x25)
    x57 = c * x13
    x58 = x39 * x4
    x59 = x4 * x57
    x60 = x35 * (-x14 * (x28 * x30 + x56 - x57 * x58) - x28 * x34 - x30 * x59 - x55)
    x61 = x39 * x42
    x62 = 2.0 * x61
    x63 = x54 * (2.0 * x16 * x19 * x2 * x22 * x26 * x27 - x38)
    x64 = x24 * boys(4, x15)
    x65 = (
        x28 * x39 - x59 * (2.0 * x19 * x2 * x22 * x26 * x27 * x28 * x37 - x4 * x64) + x63
    )
    x66 = x1**2 / x12**2
    x67 = x66 * x7
    x68 = x48 * x7
    x69 = x58 * x67 + x68
    x70 = x4 * x52
    x71 = x0 * x70
    x72 = x4 * x65
    x73 = x14 * x7
    x74 = x10 * x66
    x75 = x10 * x48
    x76 = x58 * x74 + x75
    x77 = x10 * x14
    x78 = x66 * x8
    x79 = x36 + x39 * x78
    x80 = x51 + x52 * x8
    x81 = x10 * x67
    x82 = x39 * x81
    x83 = x10 * x52 * x7
    x84 = x11 * x66
    x85 = x36 + x39 * x84
    x86 = x11 * x52 + x51
    x87 = -x6 - A[1]
    x88 = 2.0 * x19 * x2 * x22 * x26 * x27 * x29 * x87 - x25 * x7
    x89 = -2.0 * x19 * x2 * x22 * x26 * x27 * x33 * x87 + x32 * x7
    x90 = x35 * (-x14 * x88 - x89)
    x91 = 2.0 * x16 * x19 * x2 * x22 * x26 * x27 * x87 - x38 * x7
    x92 = x5 * x66
    x93 = x90 + x91 * x92
    x94 = x20 * x53 + x93
    x95 = -x89
    x96 = x35 * (-x14 * (x28 * x88 - x59 * x91) + x28 * x95 - x59 * x88)
    x97 = x42 * x91
    x98 = 2.0 * x19 * x2 * x22 * x26 * x27 * x37 * x87 - x64 * x7
    x99 = x28 * x91 - x59 * x98
    x100 = x46 + x73 * x91
    x101 = x100 * x42
    x102 = x100 * x40
    x103 = x20 * x70
    x104 = x102 + x103 * x7
    x105 = x61 + x73 * x99
    x106 = x4 * x74
    x107 = x106 * x91
    x108 = x10 * x103 + x107
    x109 = x77 * x97
    x110 = x100 * x73 + x68 + x90
    x111 = x110 + x20 * x80
    x112 = x75 + x81 * x91
    x113 = x112 + x20 * x83
    x114 = x61 * x77
    x115 = x84 * x91 + x90
    x116 = x115 + x20 * x86
    x117 = -x9 - A[2]
    x118 = -x10 * x25 + 2.0 * x117 * x19 * x2 * x22 * x26 * x27 * x29
    x119 = x10 * x32 - 2.0 * x117 * x19 * x2 * x22 * x26 * x27 * x33
    x120 = x35 * (-x118 * x14 - x119)
    x121 = -x10 * x38 + 2.0 * x117 * x16 * x19 * x2 * x22 * x26 * x27
    x122 = x120 + x121 * x92
    x123 = x122 + x21 * x53
    x124 = -x119
    x125 = x35 * (-x118 * x59 + x124 * x28 - x14 * (x118 * x28 - x121 * x59))
    x126 = x121 * x42
    x127 = -x10 * x64 + 2.0 * x117 * x19 * x2 * x22 * x26 * x27 * x37
    x128 = x121 * x28 - x127 * x59
    x129 = x4 * x67
    x130 = x121 * x129
    x131 = x21 * x70
    x132 = x130 + x131 * x7
    x133 = x126 * x73
    x134 = x121 * x77 + x46
    x135 = x134 * x42
    x136 = x134 * x40
    x137 = x10 * x131 + x136
    x138 = x128 * x77 + x61
    x139 = x120 + x121 * x78
    x140 = x139 + x21 * x80
    x141 = x134 * x73
    x142 = x141 + x21 * x83
    x143 = x120 + x134 * x77 + x75
    x144 = x143 + x21 * x86
    x145 = x57 * x7
    x146 = x35 * (-x14 * (-x145 * x91 + x56 + x87 * x88) - x145 * x88 - x55 + x87 * x95)
    x147 = -x145 * x98 + x63 + x87 * x91
    x148 = 2.0 * x97
    x149 = x147 * x73 + x148
    x150 = x35 * (-x118 * x145 + x124 * x87 - x14 * (x118 * x87 - x121 * x145))
    x151 = x121 * x87 - x127 * x145
    x152 = x126 + x151 * x73
    x153 = x151 * x77 + x97
    x154 = x10 * x57
    x155 = x35 * (
        x117 * x124 - x118 * x154 - x14 * (x117 * x118 - x121 * x154 + x56) - x55
    )
    x156 = x117 * x121 - x127 * x154 + x63
    x157 = 2.0 * x126 + x156 * x77

    # 36 item(s)
    return numpy.array(
        [
            x0 * x49 + x0 * (x0 * x53 + x49) + x40 * (x40 * x65 + x62) + x43 * x47 + x60,
            x0 * x69 + x0 * (x69 + x7 * x71) + x62 * x73 + x67 * x72,
            x0 * x76 + x0 * (x10 * x71 + x76) + x62 * x77 + x72 * x74,
            x0 * x79 + x0 * (x0 * x80 + x79) + x60 + x65 * x78,
            x0 * x82 + x0 * (x0 * x83 + x82) + x65 * x81,
            x0 * x85 + x0 * (x0 * x86 + x85) + x60 + x65 * x84,
            x0 * x94 + x20 * x49 + x40 * x97 + x40 * (x40 * x99 + x97) + x96,
            x0 * x104 + x101 + x105 * x40 + x20 * x69,
            x0 * x108 + x106 * x99 + x109 + x20 * x76,
            x0 * x111 + x105 * x73 + x20 * x79 + x61 * x73 + x96,
            x0 * x113 + x114 + x20 * x82 + x81 * x99,
            x0 * x116 + x20 * x85 + x84 * x99 + x96,
            x0 * x123 + x125 + x126 * x40 + x21 * x49 + x40 * (x126 + x128 * x40),
            x0 * x132 + x128 * x129 + x133 + x21 * x69,
            x0 * x137 + x135 + x138 * x40 + x21 * x76,
            x0 * x140 + x125 + x128 * x78 + x21 * x79,
            x0 * x142 + x138 * x73 + x21 * x82,
            x0 * x144 + x114 + x125 + x138 * x77 + x21 * x85,
            x146 + x147 * x92 + x20 * x93 + x20 * x94,
            x102 * x20 + x104 * x20 + x149 * x40,
            x106 * x147 + x107 * x20 + x108 * x20,
            2.0 * x101 + x110 * x20 + x111 * x20 + x146 + x149 * x73,
            x112 * x20 + x113 * x20 + x147 * x81 + x148 * x77,
            x115 * x20 + x116 * x20 + x146 + x147 * x84,
            x123 * x20 + x150 + x151 * x92 + x21 * x93,
            x102 * x21 + x132 * x20 + x152 * x40,
            x107 * x21 + x137 * x20 + x153 * x40,
            x110 * x21 + x133 + x140 * x20 + x150 + x152 * x73,
            x112 * x21 + x135 + x142 * x20 + x153 * x73,
            x109 + x115 * x21 + x144 * x20 + x150 + x153 * x77,
            x122 * x21 + x123 * x21 + x155 + x156 * x92,
            x129 * x156 + x130 * x21 + x132 * x21,
            x136 * x21 + x137 * x21 + x157 * x40,
            x139 * x21 + x140 * x21 + x155 + x156 * x78,
            x141 * x21 + x142 * x21 + x157 * x73,
            2.0 * x135 + x143 * x21 + x144 * x21 + x155 + x157 * x77,
        ]
    )


def _3center2el3d_023(a, A, b, B, c, C):
    """Cartesian (sd|f) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = a + b
    x4 = x3 ** (-1.0)
    x5 = -x4 * (a * A[0] + b * B[0])
    x6 = -x5 - C[0]
    x7 = 17.4934183276249
    x8 = A[0] - B[0]
    x9 = A[1] - B[1]
    x10 = A[2] - B[2]
    x11 = numpy.exp(-a * b * x4 * (x10**2 + x8**2 + x9**2))
    x12 = x11 * x4 * x7
    x13 = x6**2
    x14 = -x4 * (a * A[1] + b * B[1])
    x15 = -x14 - C[1]
    x16 = x15**2
    x17 = -x4 * (a * A[2] + b * B[2])
    x18 = -x17 - C[2]
    x19 = x18**2
    x20 = c + x3
    x21 = x20 ** (-1.0)
    x22 = x21 * x3
    x23 = c * x22 * (x13 + x16 + x19)
    x24 = boys(2, x23)
    x25 = x20 ** (-1.5)
    x26 = 2.0 * x25
    x27 = x24 * x26
    x28 = x12 * x27
    x29 = x20 ** (-0.5)
    x30 = -x5 - A[0]
    x31 = boys(1, x23)
    x32 = -2.0 * x0 * x11 * x29 * x30 * x31 * x4 * x7 + x28 * x6
    x33 = -x32
    x34 = x2 * x33
    x35 = boys(3, x23)
    x36 = x12 * x35
    x37 = x26 * x36
    x38 = 2.0 * x0 * x11 * x24 * x29 * x30 * x4 * x7 - x37 * x6
    x39 = x2 * x38
    x40 = x1 ** (-1.0)
    x41 = x40 * (2.0 * x0 * x11 * x24 * x29 * x4 * x7 - x37)
    x42 = boys(4, x23)
    x43 = x12 * x26
    x44 = x42 * x43
    x45 = 2.0 * x0 * x11 * x29 * x30 * x35 * x4 * x7 - x44 * x6
    x46 = x45 * x6
    x47 = c * x21
    x48 = x30 * x38 + x41 - x46 * x47
    x49 = x22 * x48
    x50 = -2.0 * x0 * x11 * x29 * x31 * x4 * x7
    x51 = -x28 - x50
    x52 = x40 * x51
    x53 = x47 * x6
    x54 = x38 * x53
    x55 = x30 * x33 + x52 - x54
    x56 = x22 * x6
    x57 = x22 * x38
    x58 = 2.0 * x2
    x59 = x0 * x29
    x60 = x12 * x59
    x61 = x24 * x58 * x60
    x62 = x31 * x58 * x60
    x63 = x0 * x11 * x7
    x64 = 0.5 * x0
    x65 = x64 * (-x27 * x63 - x50)
    x66 = x20 ** (-2.5) * x3
    x67 = x35 * x63
    x68 = 2.0 * x67
    x69 = x13 * x68
    x70 = x65 + x66 * x69
    x71 = x64 * (-x32 - x57)
    x72 = x36 * x58 * x59
    x73 = x22 * x46 + x72
    x74 = x25 * x58
    x75 = x6 * x63
    x76 = x35 * x75
    x77 = x56 * x73 + x71 + x74 * x76
    x78 = x0 * (-x22 * (x57 * x6 + x61) + x33 * x56 + x62) + x2 * x70 + x56 * x77
    x79 = 2.0 * x24 * x66
    x80 = x0 * (2.0 * x0 * x11 * x25 * x31 * x6 * x7 - x75 * x79) + x56 * x70
    x81 = -x40 * x51
    x82 = x64 * (x30 * x33 - x49 - x54 - x81)
    x83 = x2 * x45
    x84 = 2.0 * x83
    x85 = x40 * (2.0 * x0 * x11 * x29 * x35 * x4 * x7 - x44)
    x86 = x43 * boys(5, x23)
    x87 = x30 * x45 - x53 * (2.0 * x0 * x11 * x29 * x30 * x4 * x42 * x7 - x6 * x86) + x85
    x88 = x3**2
    x89 = x88 / x20**2
    x90 = x15 * x89
    x91 = x0 * (x15 * x21 * x3 * x33 - x38 * x90)
    x92 = x67 * x74
    x93 = x15 * x92
    x94 = x46 * x90 + x93
    x95 = x58 * x66
    x96 = x76 * x95
    x97 = x15 * x96 + x56 * x94 + 0.5 * x91
    x98 = x63 * x79
    x99 = x0 * (2.0 * x0 * x11 * x15 * x25 * x31 * x7 - x15 * x98)
    x100 = x20 ** (-3.5) * x88
    x101 = x100 * x69
    x102 = x101 * x15 + 0.5 * x99
    x103 = x0 * (x15 * x21 * x3 * x55 - x48 * x90)
    x104 = x6 * x87
    x105 = x15 * x22
    x106 = x18 * x89
    x107 = x0 * (-x106 * x38 + x18 * x21 * x3 * x33)
    x108 = 0.5 * x107
    x109 = x18 * x92
    x110 = x106 * x46 + x109
    x111 = x108 + x110 * x56 + x18 * x96
    x112 = x0 * (2.0 * x0 * x11 * x18 * x25 * x31 * x7 - x18 * x98)
    x113 = 0.5 * x112
    x114 = x101 * x18 + x113
    x115 = x0 * (-x106 * x48 + x18 * x21 * x3 * x55)
    x116 = 0.5 * x115
    x117 = x18 * x22
    x118 = x66 * x68
    x119 = x118 * x16 + x65
    x120 = x119 * x2
    x121 = x16 * x89
    x122 = x121 * x45 + x71
    x123 = x120 + x122 * x56
    x124 = x56 * x8
    x125 = x122 * x2
    x126 = x121 * x87 + x82
    x127 = x3**3 / x20**3
    x128 = x15 * x18
    x129 = x127 * x128
    x130 = x128 * x67 * x95
    x131 = x129 * x46 + x130
    x132 = 2.0 * x100 * x128 * x76
    x133 = x18 * x90
    x134 = x118 * x19 + x65
    x135 = x134 * x2
    x136 = x19 * x89
    x137 = x136 * x45 + x71
    x138 = x135 + x137 * x56
    x139 = x137 * x2
    x140 = x136 * x87 + x82
    x141 = x105 * x122 + x91
    x142 = x105 * x119 + x99
    x143 = x16 * x18
    x144 = x127 * x143
    x145 = x108 + x144 * x45
    x146 = x100 * x143 * x68 + x113
    x147 = x105 * x137
    x148 = x105 * x134
    x149 = x107 + x117 * x137
    x150 = x112 + x117 * x134
    x151 = -x14 - A[1]
    x152 = -2.0 * x0 * x11 * x151 * x29 * x31 * x4 * x7 + x15 * x28
    x153 = -x152
    x154 = x153 * x2
    x155 = 2.0 * x0 * x11 * x151 * x24 * x29 * x4 * x7 - x15 * x37
    x156 = x155 * x2
    x157 = 2.0 * x0 * x11 * x151 * x29 * x35 * x4 * x7 - x15 * x44
    x158 = x155 * x30 - x157 * x53
    x159 = x158 * x22
    x160 = -x153 * x30 + x155 * x53
    x161 = -x160
    x162 = x155 * x22
    x163 = x64 * (-x152 - x162)
    x164 = x13 * x89
    x165 = x157 * x164 + x163
    x166 = x6 * x89
    x167 = x0 * (x153 * x21 * x3 * x6 - x155 * x166) + x165 * x56
    x168 = x167 + x80 * x9
    x169 = x64 * (-x159 - x160)
    x170 = x157 * x2
    x171 = 2.0 * x0 * x11 * x151 * x29 * x4 * x42 * x7 - x15 * x86
    x172 = x157 * x30 - x171 * x53
    x173 = x0 * (x105 * x153 - x22 * (x15 * x162 + x61) + x62)
    x174 = x105 * x157 + x72
    x175 = x164 * x174 + 0.5 * x173
    x176 = x102 * x9 + x175
    x177 = x0 * (x105 * x161 - x22 * (x15 * x159 + x39) + x34)
    x178 = x174 * x2
    x179 = x105 * x172 + x83
    x180 = x0 * (-x106 * x155 + x153 * x18 * x21 * x3)
    x181 = 0.5 * x180
    x182 = x157 * x18
    x183 = x127 * x13
    x184 = x181 + x182 * x183
    x185 = x114 * x9 + x184
    x186 = x0 * (-x106 * x158 + x161 * x18 * x21 * x3)
    x187 = 0.5 * x186
    x188 = x106 * x6
    x189 = x117 * x170
    x190 = x105 * x174 + x163 + x93
    x191 = x190 * x2
    x192 = x190 * x56
    x193 = x56 * x9
    x194 = x119 * x193 + x192
    x195 = x105 * x179 + x105 * x83 + x169
    x196 = x109 + x182 * x90
    x197 = x196 * x2
    x198 = x196 * x56
    x199 = x132 * x9 + x198
    x200 = x117 * x83
    x201 = x133 * x172 + x200
    x202 = x136 * x157 + x163
    x203 = x2 * x202
    x204 = x202 * x56
    x205 = x134 * x193 + x204
    x206 = x136 * x172 + x169
    x207 = x105 * x190 + x120 + x173
    x208 = x142 * x9 + x207
    x209 = x105 * x196 + x130 + x181
    x210 = x146 * x9 + x209
    x211 = x105 * x202 + x135
    x212 = x148 * x9 + x211
    x213 = x117 * x202 + x180
    x214 = x150 * x9 + x213
    x215 = -x17 - A[2]
    x216 = -2.0 * x0 * x11 * x215 * x29 * x31 * x4 * x7 + x18 * x28
    x217 = -x216
    x218 = x2 * x217
    x219 = 2.0 * x0 * x11 * x215 * x24 * x29 * x4 * x7 - x18 * x37
    x220 = x2 * x219
    x221 = 2.0 * x0 * x11 * x215 * x29 * x35 * x4 * x7 - x18 * x44
    x222 = x219 * x30 - x221 * x53
    x223 = x22 * x222
    x224 = -x217 * x30 + x219 * x53
    x225 = -x224
    x226 = x219 * x22
    x227 = x64 * (-x216 - x226)
    x228 = x164 * x221 + x227
    x229 = x0 * (-x166 * x219 + x21 * x217 * x3 * x6) + x228 * x56
    x230 = x10 * x80 + x229
    x231 = x64 * (-x223 - x224)
    x232 = x2 * x221
    x233 = 2.0 * x0 * x11 * x215 * x29 * x4 * x42 * x7 - x18 * x86
    x234 = x221 * x30 - x233 * x53
    x235 = x0 * (x15 * x21 * x217 * x3 - x219 * x90)
    x236 = x15 * x183
    x237 = x221 * x236 + 0.5 * x235
    x238 = x10 * x102 + x237
    x239 = x0 * (x15 * x21 * x225 * x3 - x222 * x90)
    x240 = x6 * x90
    x241 = x105 * x232
    x242 = x0 * (x117 * x217 - x22 * (x18 * x226 + x61) + x62)
    x243 = 0.5 * x242
    x244 = x117 * x221 + x72
    x245 = x164 * x244 + x243
    x246 = x10 * x114 + x245
    x247 = x0 * (x117 * x225 - x22 * (x18 * x223 + x39) + x34)
    x248 = 0.5 * x247
    x249 = x2 * x244
    x250 = x117 * x234 + x83
    x251 = x121 * x221 + x227
    x252 = x2 * x251
    x253 = x251 * x56
    x254 = x10 * x56
    x255 = x119 * x254 + x253
    x256 = x121 * x234 + x231
    x257 = x240 * x244
    x258 = x10 * x132 + x257
    x259 = x105 * x249
    x260 = x109 + x117 * x244 + x227
    x261 = x2 * x260
    x262 = x260 * x56
    x263 = x134 * x254 + x262
    x264 = x117 * x250 + x200 + x231
    x265 = x105 * x251 + x235
    x266 = x10 * x142 + x265
    x267 = x121 * x244 + x243
    x268 = x10 * x146 + x267
    x269 = x105 * x260
    x270 = x10 * x148 + x269
    x271 = x117 * x260 + x135 + x242
    x272 = x10 * x150 + x271
    x273 = x15 * x47
    x274 = x151 * x155 - x157 * x273 + x41
    x275 = x155 * x273
    x276 = x151 * x153 - x275 + x52
    x277 = x22 * x274
    x278 = x64 * (x151 * x153 - x275 - x277 - x81)
    x279 = x151 * x157 - x171 * x273 + x85
    x280 = x0 * (x105 * x276 + 2.0 * x154 - x22 * (x15 * x277 + 2.0 * x156))
    x281 = 2.0 * x170
    x282 = x105 * x279 + x281
    x283 = x0 * (-x106 * x274 + x18 * x21 * x276 * x3)
    x284 = 0.5 * x283
    x285 = x105 * x282 + 2.0 * x178 + x278
    x286 = x117 * x281 + x133 * x279
    x287 = x136 * x279 + x278
    x288 = x151 * x219 - x221 * x273
    x289 = -x151 * x217 + x219 * x273
    x290 = -x289
    x291 = x22 * x288
    x292 = x64 * (-x289 - x291)
    x293 = x151 * x221 - x233 * x273
    x294 = x0 * (x105 * x290 + x218 - x22 * (x15 * x291 + x220))
    x295 = x105 * x293 + x232
    x296 = x0 * (x117 * x290 + x154 - x22 * (x156 + x18 * x291))
    x297 = 0.5 * x296
    x298 = x117 * x293 + x170
    x299 = x105 * x295 + x241 + x292
    x300 = x105 * x298 + x249
    x301 = x117 * x298 + x189 + x292
    x302 = x18 * x47
    x303 = x215 * x219 - x221 * x302 + x41
    x304 = x219 * x302
    x305 = x215 * x217 - x304 + x52
    x306 = x22 * x303
    x307 = x64 * (x215 * x217 - x304 - x306 - x81)
    x308 = x215 * x221 - x233 * x302 + x85
    x309 = x0 * (x15 * x21 * x3 * x305 - x303 * x90)
    x310 = x0 * (x117 * x305 + 2.0 * x218 - x22 * (x18 * x306 + 2.0 * x220))
    x311 = 0.5 * x310
    x312 = x117 * x308 + 2.0 * x232
    x313 = x121 * x308 + x307
    x314 = x117 * x312 + 2.0 * x249 + x307

    # 60 item(s)
    return numpy.array(
        [
            x0 * (-x22 * (2.0 * x39 + x49 * x6) + 2.0 * x34 + x55 * x56)
            + x56 * (x56 * (x56 * x87 + x84) + x58 * x73 + x82)
            + x58 * x77
            + x78 * x8
            + x8 * (x78 + x8 * x80),
            0.5 * x103
            + x56 * (x104 * x90 + x105 * x84)
            + x58 * x94
            + x8 * x97
            + x8 * (x102 * x8 + x97),
            x110 * x58
            + x111 * x8
            + x116
            + x56 * (x104 * x106 + x117 * x84)
            + x8 * (x111 + x114 * x8),
            x123 * x8 + 2.0 * x125 + x126 * x56 + x8 * (x119 * x124 + x123),
            x104 * x129 + x131 * x8 + x133 * x84 + x8 * (x131 + x132 * x8),
            x138 * x8 + 2.0 * x139 + x140 * x56 + x8 * (x124 * x134 + x138),
            x103 + x105 * x126 + x141 * x8 + x8 * (x141 + x142 * x8),
            x116 + x144 * x87 + x145 * x8 + x8 * (x145 + x146 * x8),
            x105 * x140 + x147 * x8 + x8 * (x147 + x148 * x8),
            x115 + x117 * x140 + x149 * x8 + x8 * (x149 + x150 * x8),
            x0 * (x154 + x161 * x56 - x22 * (x156 + x159 * x6))
            + x165 * x2
            + x168 * x8
            + x56 * (x169 + x170 * x56 + x56 * (x170 + x172 * x56))
            + x78 * x9,
            x176 * x8 + 0.5 * x177 + x178 * x56 + x56 * (x178 + x179 * x56) + x9 * x97,
            x111 * x9 + x170 * x188 + x185 * x8 + x187 + x56 * (x172 * x188 + x189),
            x123 * x9 + x191 + x194 * x8 + x195 * x56,
            x131 * x9 + x197 + x199 * x8 + x201 * x56,
            x138 * x9 + x203 + x205 * x8 + x206 * x56,
            x105 * x195 + x125 + x141 * x9 + x177 + x208 * x8,
            x105 * x201 + x133 * x83 + x145 * x9 + x187 + x210 * x8,
            x105 * x206 + x139 + x147 * x9 + x212 * x8,
            x117 * x206 + x149 * x9 + x186 + x214 * x8,
            x0 * (x218 - x22 * (x220 + x223 * x6) + x225 * x56)
            + x10 * x78
            + x2 * x228
            + x230 * x8
            + x56 * (x231 + x232 * x56 + x56 * (x232 + x234 * x56)),
            x10 * x97 + x232 * x240 + x238 * x8 + 0.5 * x239 + x56 * (x234 * x240 + x241),
            x10 * x111 + x246 * x8 + x248 + x249 * x56 + x56 * (x249 + x250 * x56),
            x10 * x123 + x252 + x255 * x8 + x256 * x56,
            x10 * x131 + x240 * x250 + x258 * x8 + x259,
            x10 * x138 + x261 + x263 * x8 + x264 * x56,
            x10 * x141 + x105 * x256 + x239 + x266 * x8,
            x10 * x145 + x121 * x250 + x248 + x268 * x8,
            x10 * x147 + x105 * x264 + x270 * x8,
            x10 * x149 + x117 * x264 + x139 + x247 + x272 * x8,
            x0 * (-x166 * x274 + x21 * x276 * x3 * x6)
            + x167 * x9
            + x168 * x9
            + x56 * (x164 * x279 + x278),
            x164 * x282 + x175 * x9 + x176 * x9 + 0.5 * x280,
            x18 * x183 * x279 + x184 * x9 + x185 * x9 + x284,
            x192 * x9 + x194 * x9 + x285 * x56,
            x198 * x9 + x199 * x9 + x286 * x56,
            x204 * x9 + x205 * x9 + x287 * x56,
            x105 * x285 + 2.0 * x191 + x207 * x9 + x208 * x9 + x280,
            x105 * x286 + 2.0 * x197 + x209 * x9 + x210 * x9 + x284,
            x105 * x287 + 2.0 * x203 + x211 * x9 + x212 * x9,
            x117 * x287 + x213 * x9 + x214 * x9 + x283,
            x0 * (-x166 * x288 + x21 * x290 * x3 * x6)
            + x10 * x167
            + x230 * x9
            + x56 * (x164 * x293 + x292),
            x10 * x175 + x164 * x295 + x238 * x9 + 0.5 * x294,
            x10 * x184 + x164 * x298 + x246 * x9 + x297,
            x10 * x192 + x255 * x9 + x299 * x56,
            x10 * x198 + x258 * x9 + x300 * x56,
            x10 * x204 + x263 * x9 + x301 * x56,
            x10 * x207 + x105 * x299 + x252 + x266 * x9 + x294,
            x10 * x209 + x105 * x300 + x259 + x268 * x9 + x297,
            x10 * x211 + x105 * x301 + x261 + x270 * x9,
            x10 * x213 + x117 * x301 + x203 + x272 * x9 + x296,
            x0 * (-x166 * x303 + x21 * x3 * x305 * x6)
            + x10 * x229
            + x10 * x230
            + x56 * (x164 * x308 + x307),
            x10 * x237 + x10 * x238 + x236 * x308 + 0.5 * x309,
            x10 * x245 + x10 * x246 + x164 * x312 + x311,
            x10 * x253 + x10 * x255 + x313 * x56,
            x10 * x257 + x10 * x258 + x240 * x312,
            x10 * x262 + x10 * x263 + x314 * x56,
            x10 * x265 + x10 * x266 + x105 * x313 + x309,
            x10 * x267 + x10 * x268 + x121 * x312 + x311,
            x10 * x269 + x10 * x270 + x105 * x314,
            x10 * x271 + x10 * x272 + x117 * x314 + 2.0 * x261 + x310,
        ]
    )


def _3center2el3d_024(a, A, b, B, c, C):
    """Cartesian (sd|g) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = c ** (-1.0)
    x4 = 17.4934183276249
    x5 = a + b
    x6 = c + x5
    x7 = x6 ** (-1.5)
    x8 = x5 ** (-1.0)
    x9 = -x8 * (a * A[0] + b * B[0])
    x10 = -x9 - C[0]
    x11 = x10**2
    x12 = -x8 * (a * A[1] + b * B[1])
    x13 = -x12 - C[1]
    x14 = x13**2
    x15 = -x8 * (a * A[2] + b * B[2])
    x16 = -x15 - C[2]
    x17 = x16**2
    x18 = x6 ** (-1.0)
    x19 = x18 * x5
    x20 = c * x19 * (x11 + x14 + x17)
    x21 = boys(2, x20)
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x8 * (x0**2 + x22**2 + x23**2))
    x25 = x6 ** (-2.5)
    x26 = x25 * x5
    x27 = boys(3, x20)
    x28 = x24 * x3 * x4
    x29 = x27 * x28
    x30 = 2.0 * x29
    x31 = x10 * x30
    x32 = 2.0 * x7
    x33 = x6 ** (-0.5)
    x34 = -2.0 * x21 * x24 * x3 * x33 * x4 * x8
    x35 = 0.5 * x3
    x36 = x35 * (-x29 * x32 - x34)
    x37 = x11 * x26
    x38 = boys(4, x20)
    x39 = 2.0 * x28
    x40 = x38 * x39
    x41 = x36 + x37 * x40
    x42 = x10 * x19
    x43 = x3 * (2.0 * x10 * x21 * x24 * x3 * x4 * x7 - x26 * x31) + x41 * x42
    x44 = x24 * x32 * x4
    x45 = x44 * x8
    x46 = x21 * x45
    x47 = -x9 - A[0]
    x48 = boys(1, x20)
    x49 = x10 * x46 - 2.0 * x24 * x3 * x33 * x4 * x47 * x48 * x8
    x50 = -x49
    x51 = x44 * x48 * x8
    x52 = boys(0, x20)
    x53 = x10 * x51 - 2.0 * x24 * x3 * x33 * x4 * x47 * x52 * x8
    x54 = x35 * (-x19 * x50 - x53)
    x55 = x27 * x45
    x56 = x10 * x55 - 2.0 * x21 * x24 * x3 * x33 * x4 * x47 * x8
    x57 = -x56
    x58 = x19 * x57
    x59 = x35 * (-x49 - x58)
    x60 = x38 * x45
    x61 = -x10 * x60 + 2.0 * x24 * x27 * x3 * x33 * x4 * x47 * x8
    x62 = x19 * x61
    x63 = x33 * x8
    x64 = 2.0 * x2
    x65 = x29 * x64
    x66 = x63 * x65
    x67 = x10 * x62 + x66
    x68 = x19 * x67
    x69 = x10 * x7
    x70 = x28 * x64
    x71 = x21 * x70
    x72 = x63 * x71
    x73 = x10 * x58 + x72
    x74 = 1.5 * x3
    x75 = x35 * (-x56 - x62)
    x76 = boys(5, x20)
    x77 = x45 * x76
    x78 = -x10 * x77 + 2.0 * x24 * x3 * x33 * x38 * x4 * x47 * x8
    x79 = x38 * x70
    x80 = x63 * x79
    x81 = x42 * x78 + x80
    x82 = x42 * x81 + x69 * x79 + x75
    x83 = x2 * x41 + x3 * (-x68 + x73) + x42 * x82
    x84 = (
        x2 * x43
        + x42 * x83
        + x74 * (-x19 * (x10 * x68 + x59 + x65 * x69) + x42 * x73 + x54 + x69 * x71)
    )
    x85 = x28 * x32
    x86 = -2.0 * x24 * x3 * x33 * x4 * x52 * x8
    x87 = x35 * (-x48 * x85 - x86)
    x88 = -2.0 * x24 * x3 * x33 * x4 * x48 * x8
    x89 = x35 * (-x21 * x85 - x88)
    x90 = x21 * x39
    x91 = x42 * x43 + x74 * (-x19 * (x30 * x37 + x89) + x37 * x90 + x87)
    x92 = x1 ** (-1.0)
    x93 = -x92 * (-x51 - x86)
    x94 = -x46 - x88
    x95 = x92 * x94
    x96 = c * x18
    x97 = x10 * x57
    x98 = x96 * x97
    x99 = x10 * x96
    x100 = x35 * (-x19 * (x47 * x50 + x95 - x98) - x47 * x53 - x50 * x99 - x93)
    x101 = -x92 * x94
    x102 = -x34 - x55
    x103 = x102 * x92
    x104 = x61 * x99
    x105 = x103 - x104 + x47 * x57
    x106 = x105 * x19
    x107 = x35 * (-x101 - x106 + x47 * x50 - x98)
    x108 = x2 * x61
    x109 = 2.0 * x108
    x110 = x92 * (2.0 * x24 * x27 * x3 * x33 * x4 * x8 - x60)
    x111 = x110 + x47 * x61 - x78 * x99
    x112 = x111 * x19
    x113 = x19 * (x10 * x112 + x109)
    x114 = x2 * x57
    x115 = 2.0 * x114
    x116 = x10 * x106 + x115
    x117 = -x102 * x92
    x118 = x35 * (-x104 - x112 - x117 + x47 * x57)
    x119 = x2 * x78
    x120 = 2.0 * x119
    x121 = x92 * (2.0 * x24 * x3 * x33 * x38 * x4 * x8 - x77)
    x122 = x45 * boys(6, x20)
    x123 = (
        x121
        + x47 * x78
        - x99 * (-x10 * x122 + 2.0 * x24 * x3 * x33 * x4 * x47 * x76 * x8)
    )
    x124 = x5**2
    x125 = x6 ** (-2.0)
    x126 = x124 * x125
    x127 = x111 * x126
    x128 = x127 * x13
    x129 = x13 * x19
    x130 = x10 * x126
    x131 = x13 * x130
    x132 = x13 * x61
    x133 = x126 * x132
    x134 = x13 * x7
    x135 = x134 * x65
    x136 = x126 * x13
    x137 = x134 * x71
    x138 = x26 * x30
    x139 = x3 * (-x13 * x138 + 2.0 * x13 * x21 * x24 * x3 * x4 * x7)
    x140 = x124 * x6 ** (-3.5)
    x141 = x13 * x140
    x142 = x11 * x40
    x143 = 0.5 * x139 + x141 * x142
    x144 = x3 * (x13 * x18 * x5 * x57 - x133)
    x145 = x134 * x79
    x146 = x131 * x78 + x145
    x147 = x10 * x26 * x79
    x148 = x13 * x147 + 0.5 * x144 + x146 * x42
    x149 = x143 * x2 + x148 * x42 + x3 * (x136 * x97 + x137 - x19 * (x10 * x133 + x135))
    x150 = x143 * x42 + x3 * (
        2.0 * x10 * x13 * x21 * x24 * x25 * x3 * x4 * x5 - x141 * x31
    )
    x151 = x3 * (x105 * x13 * x18 * x5 - x128)
    x152 = x127 * x16
    x153 = x16 * x19
    x154 = x130 * x16
    x155 = x126 * x61
    x156 = x155 * x16
    x157 = x16 * x7
    x158 = x157 * x65
    x159 = x126 * x16
    x160 = x157 * x71
    x161 = x3 * (-x138 * x16 + 2.0 * x16 * x21 * x24 * x3 * x4 * x7)
    x162 = 0.5 * x161
    x163 = x140 * x16
    x164 = x142 * x163 + x162
    x165 = x3 * (-x156 + x16 * x18 * x5 * x57)
    x166 = 0.5 * x165
    x167 = x157 * x79
    x168 = x154 * x78 + x167
    x169 = x147 * x16 + x166 + x168 * x42
    x170 = x164 * x2 + x169 * x42 + x3 * (x159 * x97 + x160 - x19 * (x10 * x156 + x158))
    x171 = x164 * x42 + x3 * (
        2.0 * x10 * x16 * x21 * x24 * x25 * x3 * x4 * x5 - x163 * x31
    )
    x172 = x3 * (x105 * x16 * x18 * x5 - x152)
    x173 = 0.5 * x172
    x174 = x126 * x14
    x175 = x174 * x57 - x19 * (x14 * x155 + x59) + x54
    x176 = x14 * x26
    x177 = x176 * x40 + x36
    x178 = x177 * x2
    x179 = x174 * x78 + x75
    x180 = x178 + x179 * x42
    x181 = x175 * x35 + x178 * x42 + x180 * x42
    x182 = x176 * x90 - x19 * (x138 * x14 + x89) + x87
    x183 = x11 * x126
    x184 = x177 * x183 + x182 * x35
    x185 = x100 + x105 * x174 - x19 * (x107 + x127 * x14)
    x186 = x179 * x2
    x187 = x118 + x123 * x174
    x188 = x5**3
    x189 = x188 / x6**3
    x190 = x16 * x189
    x191 = x3 * (x124 * x125 * x13 * x16 * x57 - x132 * x190)
    x192 = x13 * x190
    x193 = x10 * x192
    x194 = x13 * x16
    x195 = x194 * x26 * x79
    x196 = x193 * x78 + x195
    x197 = x141 * x16
    x198 = x10 * x197 * x79 + 0.5 * x191 + x196 * x42
    x199 = x3 * (2.0 * x13 * x16 * x21 * x24 * x25 * x3 * x4 * x5 - x197 * x30)
    x200 = x142 * x188 * x194 * x6 ** (-4.5) + 0.5 * x199
    x201 = x3 * (x105 * x124 * x125 * x13 * x16 - x111 * x192)
    x202 = x13 * x159
    x203 = x126 * x17
    x204 = -x19 * (x155 * x17 + x59) + x203 * x57 + x54
    x205 = x204 * x35
    x206 = x17 * x26
    x207 = x206 * x40 + x36
    x208 = x2 * x207
    x209 = x203 * x78 + x75
    x210 = x208 + x209 * x42
    x211 = x205 + x208 * x42 + x210 * x42
    x212 = -x19 * (x138 * x17 + x89) + x206 * x90 + x87
    x213 = x212 * x35
    x214 = x183 * x207 + x213
    x215 = x100 + x105 * x203 - x19 * (x107 + x127 * x17)
    x216 = x215 * x35
    x217 = x2 * x209
    x218 = 2.0 * x217
    x219 = x118 + x123 * x203
    x220 = x129 * x177 + x139
    x221 = x2 * x220
    x222 = x129 * x179 + x144
    x223 = x221 + x222 * x42
    x224 = x0 * x42
    x225 = x2 * x222
    x226 = x129 * x187 + x151
    x227 = x14 * x163 * x40 + x162
    x228 = x2 * x227
    x229 = x14 * x190
    x230 = x166 + x229 * x78
    x231 = x228 + x230 * x42
    x232 = x2 * x230
    x233 = x123 * x229 + x173
    x234 = x129 * x208
    x235 = x131 * x209 + x234
    x236 = x131 * x207
    x237 = x153 * x207 + x161
    x238 = x2 * x237
    x239 = x153 * x209 + x165
    x240 = x238 + x239 * x42
    x241 = x2 * x239
    x242 = x153 * x219 + x172
    x243 = x129 * x222 + x175 * x74
    x244 = x129 * x220 + x182 * x74
    x245 = x129 * x230 + x191
    x246 = x129 * x227 + x199
    x247 = x174 * x209 + x205
    x248 = x174 * x207 + x213
    x249 = x129 * x239
    x250 = x129 * x237
    x251 = x153 * x239 + x204 * x74
    x252 = x153 * x237 + x212 * x74
    x253 = -x12 - A[1]
    x254 = -x13 * x60 + 2.0 * x24 * x253 * x27 * x3 * x33 * x4 * x8
    x255 = x13 * x55 - 2.0 * x21 * x24 * x253 * x3 * x33 * x4 * x8
    x256 = -x255
    x257 = x19 * x254
    x258 = x35 * (-x255 - x257)
    x259 = -x13 * x77 + 2.0 * x24 * x253 * x3 * x33 * x38 * x4 * x8
    x260 = x183 * x259 + x258
    x261 = x260 * x42 + x3 * (x10 * x18 * x256 * x5 - x130 * x254)
    x262 = x13 * x46 - 2.0 * x24 * x253 * x3 * x33 * x4 * x48 * x8
    x263 = -x262
    x264 = x13 * x51 - 2.0 * x24 * x253 * x3 * x33 * x4 * x52 * x8
    x265 = x35 * (-x19 * x263 - x264)
    x266 = x19 * x256
    x267 = x35 * (-x262 - x266)
    x268 = x261 * x42 + x74 * (x183 * x256 - x19 * (x183 * x254 + x267) + x265)
    x269 = x22 * x91 + x268
    x270 = -x264
    x271 = x256 * x99 - x263 * x47
    x272 = x35 * (x19 * x271 - x263 * x99 + x270 * x47)
    x273 = x254 * x99 - x256 * x47
    x274 = -x273
    x275 = x19 * x274
    x276 = x35 * (-x271 - x275)
    x277 = x2 * x254
    x278 = x254 * x47 - x259 * x99
    x279 = x19 * x278
    x280 = x19 * (x10 * x279 + x277)
    x281 = x2 * x256
    x282 = x10 * x275 + x281
    x283 = x35 * (-x273 - x279)
    x284 = x2 * x259
    x285 = -x122 * x13 + 2.0 * x24 * x253 * x3 * x33 * x4 * x76 * x8
    x286 = x259 * x47 - x285 * x99
    x287 = x13 * x266 + x72
    x288 = x2 * x287
    x289 = x13 * x257 + x66
    x290 = x2 * x289
    x291 = x19 * (x108 + x13 * x279)
    x292 = x114 + x13 * x275
    x293 = x19 * x289
    x294 = x3 * (x287 - x293)
    x295 = x129 * x259 + x80
    x296 = x183 * x295 + 0.5 * x294
    x297 = x296 * x42 + x3 * (x10 * x18 * x287 * x5 - x130 * x289)
    x298 = x150 * x22 + x297
    x299 = x3 * (-x291 + x292)
    x300 = x2 * x295
    x301 = x119 + x129 * x286
    x302 = x153 * x277
    x303 = x153 * x281
    x304 = x159 * x254
    x305 = x3 * (x16 * x18 * x256 * x5 - x304)
    x306 = 0.5 * x305
    x307 = x11 * x190
    x308 = x259 * x307 + x306
    x309 = x10 * x190
    x310 = x3 * (x10 * x124 * x125 * x16 * x256 - x254 * x309) + x308 * x42
    x311 = x171 * x22 + x310
    x312 = x159 * x278
    x313 = x3 * (x16 * x18 * x274 * x5 - x312)
    x314 = 0.5 * x313
    x315 = x153 * x284
    x316 = x129 * x287 + x137 - x19 * (x13 * x293 + x135 + x267) + x265
    x317 = x129 * x295 + x145 + x258
    x318 = x183 * x317 + x316 * x35
    x319 = x184 * x22 + x318
    x320 = x114 * x129 + x129 * x292 - x19 * (x108 * x129 + x13 * x291 + x276) + x272
    x321 = x2 * x317
    x322 = x119 * x129 + x129 * x301 + x283
    x323 = x3 * (x160 - x19 * (x13 * x304 + x158) + x202 * x256)
    x324 = x167 + x202 * x259
    x325 = x183 * x324 + 0.5 * x323
    x326 = x200 * x22 + x325
    x327 = x108 * x153
    x328 = x114 * x153
    x329 = x3 * (-x19 * (x13 * x312 + x327) + x202 * x274 + x328)
    x330 = x2 * x324
    x331 = x119 * x153
    x332 = x202 * x286 + x331
    x333 = -x19 * (x203 * x254 + x267) + x203 * x256 + x265
    x334 = x333 * x35
    x335 = x203 * x259 + x258
    x336 = x183 * x335 + x334
    x337 = x214 * x22 + x336
    x338 = -x19 * (x203 * x278 + x276) + x203 * x274 + x272
    x339 = x338 * x35
    x340 = x2 * x335
    x341 = x203 * x286 + x283
    x342 = x129 * x317 + x178 + x294
    x343 = x2 * x342
    x344 = x342 * x42
    x345 = x22 * x42
    x346 = x220 * x345 + x344
    x347 = x129 * x322 + x186 + x299
    x348 = x129 * x324 + x195 + x306
    x349 = x2 * x348
    x350 = x348 * x42
    x351 = x227 * x345 + x350
    x352 = x119 * x202 + x129 * x332 + x314
    x353 = x129 * x335 + x208
    x354 = x2 * x353
    x355 = x353 * x42
    x356 = x22 * x236 + x355
    x357 = x129 * x341 + x217
    x358 = x153 * x335 + x305
    x359 = x2 * x358
    x360 = x358 * x42
    x361 = x237 * x345 + x360
    x362 = x153 * x341 + x313
    x363 = x129 * x342 + x221 + x316 * x74
    x364 = x22 * x244 + x363
    x365 = x129 * x348 + x228 + x323
    x366 = x22 * x246 + x365
    x367 = x129 * x353 + x234 + x334
    x368 = x22 * x248 + x367
    x369 = x129 * x358 + x238
    x370 = x22 * x250 + x369
    x371 = x153 * x358 + x333 * x74
    x372 = x22 * x252 + x371
    x373 = -x15 - A[2]
    x374 = -x16 * x60 + 2.0 * x24 * x27 * x3 * x33 * x373 * x4 * x8
    x375 = x16 * x55 - 2.0 * x21 * x24 * x3 * x33 * x373 * x4 * x8
    x376 = -x375
    x377 = x19 * x374
    x378 = x35 * (-x375 - x377)
    x379 = -x16 * x77 + 2.0 * x24 * x3 * x33 * x373 * x38 * x4 * x8
    x380 = x183 * x379 + x378
    x381 = x3 * (x10 * x18 * x376 * x5 - x130 * x374) + x380 * x42
    x382 = x16 * x46 - 2.0 * x24 * x3 * x33 * x373 * x4 * x48 * x8
    x383 = -x382
    x384 = x16 * x51 - 2.0 * x24 * x3 * x33 * x373 * x4 * x52 * x8
    x385 = x35 * (-x19 * x383 - x384)
    x386 = x19 * x376
    x387 = x35 * (-x382 - x386)
    x388 = x381 * x42 + x74 * (x183 * x376 - x19 * (x183 * x374 + x387) + x385)
    x389 = x23 * x91 + x388
    x390 = -x384
    x391 = x376 * x99 - x383 * x47
    x392 = x35 * (x19 * x391 - x383 * x99 + x390 * x47)
    x393 = x374 * x99 - x376 * x47
    x394 = -x393
    x395 = x19 * x394
    x396 = x35 * (-x391 - x395)
    x397 = x2 * x374
    x398 = x374 * x47 - x379 * x99
    x399 = x19 * x398
    x400 = x19 * (x10 * x399 + x397)
    x401 = x2 * x376
    x402 = x10 * x395 + x401
    x403 = x35 * (-x393 - x399)
    x404 = x2 * x379
    x405 = -x122 * x16 + 2.0 * x24 * x3 * x33 * x373 * x4 * x76 * x8
    x406 = x379 * x47 - x405 * x99
    x407 = x129 * x397
    x408 = x129 * x401
    x409 = x3 * (x13 * x18 * x376 * x5 - x136 * x374)
    x410 = x13 * x189
    x411 = x11 * x410
    x412 = x379 * x411 + 0.5 * x409
    x413 = x10 * x410
    x414 = x3 * (x10 * x124 * x125 * x13 * x376 - x374 * x413) + x412 * x42
    x415 = x150 * x23 + x414
    x416 = x3 * (x13 * x18 * x394 * x5 - x136 * x398)
    x417 = x129 * x404
    x418 = x16 * x386 + x72
    x419 = x2 * x418
    x420 = x16 * x377 + x66
    x421 = x2 * x420
    x422 = x108 + x16 * x399
    x423 = x19 * x422
    x424 = x114 + x16 * x395
    x425 = x19 * x420
    x426 = x3 * (x418 - x425)
    x427 = 0.5 * x426
    x428 = x153 * x379 + x80
    x429 = x183 * x428 + x427
    x430 = x3 * (x10 * x18 * x418 * x5 - x130 * x420) + x42 * x429
    x431 = x171 * x23 + x430
    x432 = x3 * (-x423 + x424)
    x433 = 0.5 * x432
    x434 = x2 * x428
    x435 = x119 + x153 * x406
    x436 = x174 * x376 - x19 * (x174 * x374 + x387) + x385
    x437 = x174 * x379 + x378
    x438 = x183 * x437 + x35 * x436
    x439 = x184 * x23 + x438
    x440 = x174 * x394 - x19 * (x174 * x398 + x396) + x392
    x441 = x2 * x437
    x442 = x174 * x406 + x403
    x443 = x3 * (x13 * x18 * x418 * x5 - x136 * x420)
    x444 = x411 * x428 + 0.5 * x443
    x445 = x200 * x23 + x444
    x446 = x3 * (x13 * x18 * x424 * x5 - x136 * x422)
    x447 = x129 * x434
    x448 = x153 * x418 + x160 - x19 * (x158 + x16 * x425 + x387) + x385
    x449 = x35 * x448
    x450 = x153 * x428 + x167 + x378
    x451 = x183 * x450 + x449
    x452 = x214 * x23 + x451
    x453 = x153 * x424 - x19 * (x16 * x423 + x327 + x396) + x328 + x392
    x454 = x35 * x453
    x455 = x2 * x450
    x456 = x153 * x435 + x331 + x403
    x457 = x129 * x437 + x409
    x458 = x2 * x457
    x459 = x42 * x457
    x460 = x23 * x42
    x461 = x220 * x460 + x459
    x462 = x129 * x442 + x416
    x463 = x174 * x428 + x427
    x464 = x2 * x463
    x465 = x42 * x463
    x466 = x227 * x460 + x465
    x467 = x174 * x435 + x433
    x468 = x131 * x450
    x469 = x23 * x236 + x468
    x470 = x129 * x455
    x471 = x153 * x450 + x208 + x426
    x472 = x2 * x471
    x473 = x42 * x471
    x474 = x237 * x460 + x473
    x475 = x153 * x456 + x217 + x432
    x476 = x129 * x457 + x436 * x74
    x477 = x23 * x244 + x476
    x478 = x129 * x463 + x443
    x479 = x23 * x246 + x478
    x480 = x174 * x450 + x449
    x481 = x23 * x248 + x480
    x482 = x129 * x471
    x483 = x23 * x250 + x482
    x484 = x153 * x471 + x238 + x448 * x74
    x485 = x23 * x252 + x484
    x486 = x13 * x96
    x487 = x256 * x486
    x488 = x35 * (-x19 * (x253 * x263 - x487 + x95) + x253 * x270 - x263 * x486 - x93)
    x489 = x254 * x486
    x490 = x103 + x253 * x256 - x489
    x491 = x19 * x490
    x492 = x35 * (-x101 + x253 * x263 - x487 - x491)
    x493 = x110 + x253 * x254 - x259 * x486
    x494 = x19 * x493
    x495 = x35 * (-x117 + x253 * x256 - x489 - x494)
    x496 = x121 + x253 * x259 - x285 * x486
    x497 = 2.0 * x277
    x498 = x13 * x494 + x497
    x499 = 2.0 * x281
    x500 = x13 * x491 + x499
    x501 = x19 * x498
    x502 = x3 * (x500 - x501)
    x503 = 2.0 * x284
    x504 = x129 * x496 + x503
    x505 = x159 * x493
    x506 = x3 * (x16 * x18 * x490 * x5 - x505)
    x507 = 0.5 * x506
    x508 = x129 * x500 - x19 * (x13 * x501 + 2.0 * x290 + x492) + 2.0 * x288 + x488
    x509 = x129 * x504 + 2.0 * x300 + x495
    x510 = x3 * (x153 * x499 - x19 * (x13 * x505 + x153 * x497) + x202 * x490)
    x511 = x153 * x503 + x202 * x496
    x512 = -x19 * (x203 * x493 + x492) + x203 * x490 + x488
    x513 = x35 * x512
    x514 = x203 * x496 + x495
    x515 = x129 * x509 + 2.0 * x321 + x502
    x516 = x129 * x511 + 2.0 * x330 + x507
    x517 = x129 * x514 + 2.0 * x340
    x518 = x153 * x514 + x506
    x519 = -x253 * x383 + x376 * x486
    x520 = x35 * (x19 * x519 + x253 * x390 - x383 * x486)
    x521 = -x253 * x376 + x374 * x486
    x522 = -x521
    x523 = x19 * x522
    x524 = x35 * (-x519 - x523)
    x525 = x253 * x374 - x379 * x486
    x526 = x19 * x525
    x527 = x35 * (-x521 - x526)
    x528 = x253 * x379 - x405 * x486
    x529 = x13 * x526 + x397
    x530 = x13 * x523 + x401
    x531 = x19 * x529
    x532 = x3 * (x530 - x531)
    x533 = x129 * x528 + x404
    x534 = x16 * x526 + x277
    x535 = x16 * x523 + x281
    x536 = x19 * x534
    x537 = x3 * (x535 - x536)
    x538 = 0.5 * x537
    x539 = x153 * x528 + x284
    x540 = x129 * x530 - x19 * (x13 * x531 + x407 + x524) + x408 + x520
    x541 = x129 * x533 + x417 + x527
    x542 = x3 * (x129 * x535 - x19 * (x13 * x536 + x421) + x419)
    x543 = x129 * x539 + x434
    x544 = x153 * x535 - x19 * (x16 * x536 + x302 + x524) + x303 + x520
    x545 = x35 * x544
    x546 = x153 * x539 + x315 + x527
    x547 = x129 * x541 + x441 + x532
    x548 = x129 * x543 + x447 + x538
    x549 = x129 * x546 + x455
    x550 = x153 * x546 + x340 + x537
    x551 = x16 * x96
    x552 = x376 * x551
    x553 = x35 * (-x19 * (x373 * x383 - x552 + x95) + x373 * x390 - x383 * x551 - x93)
    x554 = x374 * x551
    x555 = x103 + x373 * x376 - x554
    x556 = x19 * x555
    x557 = x35 * (-x101 + x373 * x383 - x552 - x556)
    x558 = x110 + x373 * x374 - x379 * x551
    x559 = x19 * x558
    x560 = x35 * (-x117 + x373 * x376 - x554 - x559)
    x561 = x121 + x373 * x379 - x405 * x551
    x562 = x3 * (x13 * x18 * x5 * x555 - x136 * x558)
    x563 = x16 * x559 + 2.0 * x397
    x564 = x16 * x556 + 2.0 * x401
    x565 = x19 * x563
    x566 = x3 * (x564 - x565)
    x567 = 0.5 * x566
    x568 = x153 * x561 + 2.0 * x404
    x569 = x174 * x555 - x19 * (x174 * x558 + x557) + x553
    x570 = x174 * x561 + x560
    x571 = x3 * (x13 * x18 * x5 * x564 - x136 * x563)
    x572 = x153 * x564 - x19 * (x16 * x565 + 2.0 * x421 + x557) + 2.0 * x419 + x553
    x573 = x35 * x572
    x574 = x153 * x568 + 2.0 * x434 + x560
    x575 = x129 * x570 + x562
    x576 = x174 * x568 + x567
    x577 = x153 * x574 + 2.0 * x455 + x566

    # 90 item(s)
    return numpy.array(
        [
            x0 * x84
            + x0 * (x0 * x91 + x84)
            + x42
            * (
                x3 * (-x113 + x116)
                + x42 * (x118 + x42 * (x120 + x123 * x42) + x64 * x81)
                + x64 * x82
            )
            + x64 * x83
            + x74
            * (x100 + x116 * x42 - x19 * (x10 * x113 + x107 + x64 * x67) + x64 * x73),
            x0 * x149
            + x0 * (x0 * x150 + x149)
            + x148 * x64
            + x3 * (x105 * x131 + x115 * x129 - x19 * (x10 * x128 + x109 * x129))
            + x42 * (x146 * x64 + 0.5 * x151 + x42 * (x120 * x129 + x123 * x131)),
            x0 * x170
            + x0 * (x0 * x171 + x170)
            + x169 * x64
            + x3 * (x105 * x154 + x115 * x153 - x19 * (x10 * x152 + x109 * x153))
            + x42 * (x168 * x64 + x173 + x42 * (x120 * x153 + x123 * x154)),
            x0 * x181
            + x0 * (x0 * x184 + x181)
            + x180 * x64
            + x185 * x35
            + x42 * (2.0 * x186 + x187 * x42),
            x0 * x198
            + x0 * (x0 * x200 + x198)
            + x196 * x64
            + 0.5 * x201
            + x42 * (x120 * x202 + x123 * x193),
            x0 * x211
            + x0 * (x0 * x214 + x211)
            + x210 * x64
            + x216
            + x42 * (x218 + x219 * x42),
            x0 * x223 + x0 * (x220 * x224 + x223) + 2.0 * x225 + x226 * x42,
            x0 * x231 + x0 * (x224 * x227 + x231) + 2.0 * x232 + x233 * x42,
            x0 * x235 + x0 * (x0 * x236 + x235) + x129 * x218 + x131 * x219,
            x0 * x240 + x0 * (x224 * x237 + x240) + 2.0 * x241 + x242 * x42,
            x0 * x243 + x0 * (x0 * x244 + x243) + x129 * x226 + x185 * x74,
            x0 * x245 + x0 * (x0 * x246 + x245) + x129 * x233 + x201,
            x0 * x247 + x0 * (x0 * x248 + x247) + x174 * x219 + x216,
            x0 * x249 + x0 * (x0 * x250 + x249) + x129 * x242,
            x0 * x251 + x0 * (x0 * x252 + x251) + x153 * x242 + x215 * x74,
            x0 * x269
            + x2 * x261
            + x22 * x84
            + x42
            * (
                x2 * x260
                + x3 * (-x280 + x282)
                + x42 * (x283 + x284 * x42 + x42 * (x284 + x286 * x42))
            )
            + x74
            * (-x19 * (x10 * x280 + x276 + x277 * x42) + x272 + x281 * x42 + x282 * x42),
            x0 * x298
            + x149 * x22
            + x2 * x296
            + x3 * (-x19 * (x10 * x291 + x290) + x288 + x292 * x42)
            + x42 * (0.5 * x299 + x300 * x42 + x42 * (x300 + x301 * x42)),
            x0 * x311
            + x170 * x22
            + x2 * x308
            + x3 * (x154 * x274 - x19 * (x154 * x278 + x302) + x303)
            + x42 * (x154 * x284 + x314 + x42 * (x154 * x286 + x315)),
            x0 * x319 + x181 * x22 + x320 * x35 + x321 * x42 + x42 * (x321 + x322 * x42),
            x0 * x326 + x198 * x22 + 0.5 * x329 + x330 * x42 + x42 * (x330 + x332 * x42),
            x0 * x337 + x211 * x22 + x339 + x340 * x42 + x42 * (x340 + x341 * x42),
            x0 * x346 + x22 * x223 + x343 + x347 * x42,
            x0 * x351 + x22 * x231 + x349 + x352 * x42,
            x0 * x356 + x22 * x235 + x354 + x357 * x42,
            x0 * x361 + x22 * x240 + x359 + x362 * x42,
            x0 * x364 + x129 * x347 + x22 * x243 + x225 + x320 * x74,
            x0 * x366 + x129 * x352 + x22 * x245 + x232 + x329,
            x0 * x368 + x129 * x217 + x129 * x357 + x22 * x247 + x339,
            x0 * x370 + x129 * x362 + x22 * x249 + x241,
            x0 * x372 + x153 * x362 + x22 * x251 + x338 * x74,
            x0 * x389
            + x2 * x381
            + x23 * x84
            + x42
            * (
                x2 * x380
                + x3 * (-x400 + x402)
                + x42 * (x403 + x404 * x42 + x42 * (x404 + x406 * x42))
            )
            + x74
            * (-x19 * (x10 * x400 + x396 + x397 * x42) + x392 + x401 * x42 + x402 * x42),
            x0 * x415
            + x149 * x23
            + x2 * x412
            + x3 * (x131 * x394 - x19 * (x131 * x398 + x407) + x408)
            + x42 * (x131 * x404 + 0.5 * x416 + x42 * (x131 * x406 + x417)),
            x0 * x431
            + x170 * x23
            + x2 * x429
            + x3 * (-x19 * (x10 * x423 + x421) + x419 + x42 * x424)
            + x42 * (x42 * x434 + x42 * (x42 * x435 + x434) + x433),
            x0 * x439 + x181 * x23 + x35 * x440 + x42 * x441 + x42 * (x42 * x442 + x441),
            x0 * x445
            + x131 * x434
            + x198 * x23
            + x42 * (x131 * x435 + x447)
            + 0.5 * x446,
            x0 * x452 + x211 * x23 + x42 * x455 + x42 * (x42 * x456 + x455) + x454,
            x0 * x461 + x223 * x23 + x42 * x462 + x458,
            x0 * x466 + x23 * x231 + x42 * x467 + x464,
            x0 * x469 + x131 * x456 + x23 * x235 + x470,
            x0 * x474 + x23 * x240 + x42 * x475 + x472,
            x0 * x477 + x129 * x462 + x23 * x243 + x440 * x74,
            x0 * x479 + x129 * x467 + x23 * x245 + x446,
            x0 * x481 + x174 * x456 + x23 * x247 + x454,
            x0 * x483 + x129 * x475 + x23 * x249,
            x0 * x485 + x153 * x475 + x23 * x251 + x241 + x453 * x74,
            x22 * x268
            + x22 * x269
            + x42
            * (x3 * (x10 * x18 * x490 * x5 - x130 * x493) + x42 * (x183 * x496 + x495))
            + x74 * (x183 * x490 - x19 * (x183 * x493 + x492) + x488),
            x22 * x297
            + x22 * x298
            + x3 * (x10 * x18 * x5 * x500 - x130 * x498)
            + x42 * (x183 * x504 + 0.5 * x502),
            x22 * x310
            + x22 * x311
            + x3 * (x10 * x124 * x125 * x16 * x490 - x309 * x493)
            + x42 * (x307 * x496 + x507),
            x183 * x509 + x22 * x318 + x22 * x319 + x35 * x508,
            x183 * x511 + x22 * x325 + x22 * x326 + 0.5 * x510,
            x183 * x514 + x22 * x336 + x22 * x337 + x513,
            x22 * x344 + x22 * x346 + x42 * x515,
            x22 * x350 + x22 * x351 + x42 * x516,
            x22 * x355 + x22 * x356 + x42 * x517,
            x22 * x360 + x22 * x361 + x42 * x518,
            x129 * x515 + x22 * x363 + x22 * x364 + 2.0 * x343 + x508 * x74,
            x129 * x516 + x22 * x365 + x22 * x366 + 2.0 * x349 + x510,
            x129 * x517 + x22 * x367 + x22 * x368 + 2.0 * x354 + x513,
            x129 * x518 + x22 * x369 + x22 * x370 + 2.0 * x359,
            x153 * x518 + x22 * x371 + x22 * x372 + x512 * x74,
            x22 * x389
            + x23 * x268
            + x42
            * (x3 * (x10 * x18 * x5 * x522 - x130 * x525) + x42 * (x183 * x528 + x527))
            + x74 * (x183 * x522 - x19 * (x183 * x525 + x524) + x520),
            x22 * x415
            + x23 * x297
            + x3 * (x10 * x18 * x5 * x530 - x130 * x529)
            + x42 * (x183 * x533 + 0.5 * x532),
            x22 * x431
            + x23 * x310
            + x3 * (x10 * x18 * x5 * x535 - x130 * x534)
            + x42 * (x183 * x539 + x538),
            x183 * x541 + x22 * x439 + x23 * x318 + x35 * x540,
            x183 * x543 + x22 * x445 + x23 * x325 + 0.5 * x542,
            x183 * x546 + x22 * x452 + x23 * x336 + x545,
            x22 * x461 + x23 * x344 + x42 * x547,
            x22 * x466 + x23 * x350 + x42 * x548,
            x22 * x469 + x23 * x355 + x42 * x549,
            x22 * x474 + x23 * x360 + x42 * x550,
            x129 * x547 + x22 * x477 + x23 * x363 + x458 + x540 * x74,
            x129 * x548 + x22 * x479 + x23 * x365 + x464 + x542,
            x129 * x549 + x22 * x481 + x23 * x367 + x470 + x545,
            x129 * x550 + x22 * x483 + x23 * x369 + x472,
            x153 * x550 + x22 * x485 + x23 * x371 + x359 + x544 * x74,
            x23 * x388
            + x23 * x389
            + x42
            * (x3 * (x10 * x18 * x5 * x555 - x130 * x558) + x42 * (x183 * x561 + x560))
            + x74 * (x183 * x555 - x19 * (x183 * x558 + x557) + x553),
            x23 * x414
            + x23 * x415
            + x3 * (x10 * x124 * x125 * x13 * x555 - x413 * x558)
            + x42 * (x411 * x561 + 0.5 * x562),
            x23 * x430
            + x23 * x431
            + x3 * (x10 * x18 * x5 * x564 - x130 * x563)
            + x42 * (x183 * x568 + x567),
            x183 * x570 + x23 * x438 + x23 * x439 + x35 * x569,
            x23 * x444 + x23 * x445 + x411 * x568 + 0.5 * x571,
            x183 * x574 + x23 * x451 + x23 * x452 + x573,
            x23 * x459 + x23 * x461 + x42 * x575,
            x23 * x465 + x23 * x466 + x42 * x576,
            x131 * x574 + x23 * x468 + x23 * x469,
            x23 * x473 + x23 * x474 + x42 * x577,
            x129 * x575 + x23 * x476 + x23 * x477 + x569 * x74,
            x129 * x576 + x23 * x478 + x23 * x479 + x571,
            x174 * x574 + x23 * x480 + x23 * x481 + x573,
            x129 * x577 + x23 * x482 + x23 * x483,
            x153 * x577 + x23 * x484 + x23 * x485 + 2.0 * x472 + x572 * x74,
        ]
    )


def _3center2el3d_025(a, A, b, B, c, C):
    """Cartesian (sd|h) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = a + b
    x4 = x3 ** (-1.0)
    x5 = -x4 * (a * A[0] + b * B[0])
    x6 = -x5 - C[0]
    x7 = x6**2
    x8 = -x4 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x4 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x3
    x15 = x14 ** (-1.0)
    x16 = x15 * x3
    x17 = c * x16 * (x10 + x13 + x7)
    x18 = boys(3, x17)
    x19 = c ** (-1.0)
    x20 = 2.0 * x19
    x21 = 17.4934183276249
    x22 = x14 ** (-1.5)
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x4 * (x0**2 + x23**2 + x24**2))
    x26 = x21 * x22 * x25
    x27 = x20 * x26
    x28 = x18 * x27
    x29 = x14 ** (-0.5)
    x30 = boys(2, x17)
    x31 = -2.0 * x19 * x21 * x25 * x29 * x30 * x4
    x32 = 0.5 * x19
    x33 = x32 * (-x28 - x31)
    x34 = x14 ** (-2.5)
    x35 = x3 * x34
    x36 = boys(4, x17)
    x37 = x20 * x21 * x25
    x38 = x36 * x37
    x39 = x38 * x7
    x40 = x33 + x35 * x39
    x41 = x16 * x40
    x42 = boys(1, x17)
    x43 = -2.0 * x19 * x21 * x25 * x29 * x4 * x42
    x44 = x32 * (-x27 * x30 - x43)
    x45 = x35 * x37
    x46 = x45 * x7
    x47 = x18 * x46 + x44
    x48 = 1.5 * x19
    x49 = x35 * x38
    x50 = x49 * x6
    x51 = x27 * x36
    x52 = -2.0 * x18 * x19 * x21 * x25 * x29 * x4
    x53 = x32 * (-x51 - x52)
    x54 = boys(5, x17)
    x55 = x46 * x54 + x53
    x56 = x16 * x6
    x57 = x19 * (2.0 * x18 * x19 * x21 * x22 * x25 * x6 - x50) + x55 * x56
    x58 = x48 * (-x41 + x47) + x56 * x57
    x59 = x18 * x4
    x60 = 2.0 * x26
    x61 = x59 * x60
    x62 = -x5 - A[0]
    x63 = -2.0 * x19 * x21 * x25 * x29 * x30 * x4 * x62 + x6 * x61
    x64 = -x63
    x65 = x16 * x64
    x66 = x29 * x37
    x67 = x4 * x66
    x68 = x2 * x30 * x67
    x69 = x6 * x65 + x68
    x70 = x4 * x60
    x71 = x30 * x70
    x72 = -2.0 * x19 * x21 * x25 * x29 * x4 * x42 * x62 + x6 * x71
    x73 = -x72
    x74 = x2 * x42 * x67
    x75 = x36 * x70
    x76 = -2.0 * x18 * x19 * x21 * x25 * x29 * x4 * x62 + x6 * x75
    x77 = -x76
    x78 = x16 * x77
    x79 = x2 * x59 * x66
    x80 = x6 * x78 + x79
    x81 = x16 * x80
    x82 = x32 * (-x63 - x78)
    x83 = x54 * x70
    x84 = 2.0 * x19 * x21 * x25 * x29 * x36 * x4 * x62 - x6 * x83
    x85 = x16 * x84
    x86 = x2 * x36 * x67
    x87 = x6 * x85 + x86
    x88 = x16 * x87
    x89 = x2 * x6
    x90 = x51 * x89 + x6 * x88 + x82
    x91 = x16 * x90
    x92 = x32 * (-x65 - x72)
    x93 = x2 * x28 * x6 + x6 * x81 + x92
    x94 = x32 * (-x76 - x85)
    x95 = boys(6, x17)
    x96 = x70 * x95
    x97 = 2.0 * x19 * x21 * x25 * x29 * x4 * x54 * x62 - x6 * x96
    x98 = x2 * x54 * x67
    x99 = x56 * x97 + x98
    x100 = x27 * x54
    x101 = x100 * x89 + x56 * x99 + x94
    x102 = x101 * x56 + x19 * (x80 - x88) + x2 * x55
    x103 = x102 * x56 + x2 * x57 + x48 * (-x91 + x93)
    x104 = (
        x103 * x56
        + x2 * x58
        + x20
        * (
            -x16 * (x19 * (x69 - x81) + x2 * x40 + x6 * x91)
            + x19 * (-x16 * x69 + x56 * x73 + x74)
            + x2 * x47
            + x56 * x93
        )
    )
    x105 = x45 * x6
    x106 = (
        x20
        * (
            -x16
            * (x19 * (-x105 * x18 + 2.0 * x19 * x21 * x22 * x25 * x30 * x6) + x41 * x6)
            + x19 * (-x105 * x30 + 2.0 * x19 * x21 * x22 * x25 * x42 * x6)
            + x47 * x56
        )
        + x56 * x58
    )
    x107 = x2 * x73
    x108 = x2 * x64
    x109 = x1 ** (-1.0)
    x110 = -x31 - x61
    x111 = x109 * x110
    x112 = c * x15
    x113 = x6 * x77
    x114 = x112 * x113
    x115 = x111 - x114 + x62 * x64
    x116 = x115 * x16
    x117 = 2.0 * x108 + x116 * x6
    x118 = -x43 - x71
    x119 = x109 * x118
    x120 = x112 * x6
    x121 = x120 * x64
    x122 = x119 - x121 + x62 * x73
    x123 = 2.0 * x2
    x124 = x2 * x77
    x125 = 2.0 * x124
    x126 = -x52 - x75
    x127 = x109 * x126
    x128 = x120 * x84
    x129 = x127 - x128 + x62 * x77
    x130 = x129 * x16
    x131 = x125 + x130 * x6
    x132 = x131 * x16
    x133 = -x109 * x110
    x134 = x32 * (-x114 - x130 - x133 + x62 * x64)
    x135 = x2 * x84
    x136 = 2.0 * x135
    x137 = x109 * (2.0 * x19 * x21 * x25 * x29 * x36 * x4 - x83)
    x138 = -x120 * x97 + x137 + x62 * x84
    x139 = x138 * x16
    x140 = x16 * (x136 + x139 * x6)
    x141 = x16 * (x123 * x87 + x134 + x140 * x6)
    x142 = -x109 * x118
    x143 = x32 * (-x116 - x121 - x142 + x62 * x73)
    x144 = x123 * x80 + x132 * x6 + x143
    x145 = -x109 * x126
    x146 = x32 * (-x128 - x139 - x145 + x62 * x77)
    x147 = x2 * x97
    x148 = 2.0 * x147
    x149 = x109 * (2.0 * x19 * x21 * x25 * x29 * x4 * x54 - x96)
    x150 = x70 * boys(7, x17)
    x151 = (
        -x120 * (-x150 * x6 + 2.0 * x19 * x21 * x25 * x29 * x4 * x62 * x95)
        + x149
        + x62 * x97
    )
    x152 = x38 * x6
    x153 = x3**2
    x154 = x14 ** (-3.5)
    x155 = x153 * x154
    x156 = x155 * x9
    x157 = x19 * (2.0 * x18 * x19 * x21 * x22 * x25 * x9 - x49 * x9)
    x158 = x37 * x7
    x159 = x156 * x158
    x160 = 0.5 * x157 + x159 * x54
    x161 = x160 * x56 + x19 * (
        -x152 * x156 + 2.0 * x18 * x19 * x21 * x25 * x3 * x34 * x6 * x9
    )
    x162 = x14 ** (-2.0)
    x163 = x153 * x162
    x164 = x163 * x9
    x165 = x19 * (x15 * x3 * x73 * x9 - x164 * x64)
    x166 = x19 * (x15 * x3 * x64 * x9 - x164 * x77)
    x167 = x164 * x84
    x168 = x2 * x9
    x169 = x168 * x51
    x170 = x167 * x6 + x169
    x171 = x16 * x170
    x172 = x2 * x28 * x9
    x173 = x113 * x164 + x172
    x174 = x45 * x9
    x175 = x174 * x18
    x176 = x19 * (x15 * x3 * x77 * x9 - x167)
    x177 = x164 * x6
    x178 = x100 * x168
    x179 = x177 * x97 + x178
    x180 = x54 * x89
    x181 = x174 * x180 + 0.5 * x176 + x179 * x56
    x182 = x160 * x2 + x181 * x56 + x19 * (-x171 + x173)
    x183 = (
        x161 * x2
        + x182 * x56
        + x48
        * (
            -x16 * (0.5 * x166 + x168 * x50 + x171 * x6)
            + 0.5 * x165
            + x173 * x56
            + x175 * x89
        )
    )
    x184 = x19 * (-x174 * x30 + 2.0 * x19 * x21 * x22 * x25 * x42 * x9)
    x185 = x19 * (-x175 + 2.0 * x19 * x21 * x22 * x25 * x30 * x9)
    x186 = x161 * x56 + x48 * (x159 * x18 - x16 * (x156 * x39 + 0.5 * x185) + 0.5 * x184)
    x187 = x19 * (-x115 * x164 + x122 * x15 * x3 * x9)
    x188 = x129 * x164
    x189 = x19 * (x115 * x15 * x3 * x9 - x188)
    x190 = x138 * x164
    x191 = x16 * x9
    x192 = x16 * (x136 * x191 + x190 * x6)
    x193 = x125 * x191 + x188 * x6
    x194 = x19 * (x129 * x15 * x3 * x9 - x190)
    x195 = x12 * x155
    x196 = x19 * (2.0 * x12 * x18 * x19 * x21 * x22 * x25 - x12 * x49)
    x197 = 0.5 * x196
    x198 = x158 * x195
    x199 = x197 + x198 * x54
    x200 = (
        x19 * (2.0 * x12 * x18 * x19 * x21 * x25 * x3 * x34 * x6 - x152 * x195)
        + x199 * x56
    )
    x201 = x12 * x163
    x202 = x19 * (x12 * x15 * x3 * x73 - x201 * x64)
    x203 = 0.5 * x202
    x204 = x19 * (x12 * x15 * x3 * x64 - x201 * x77)
    x205 = 0.5 * x204
    x206 = x201 * x84
    x207 = x12 * x2
    x208 = x207 * x51
    x209 = x206 * x6 + x208
    x210 = x16 * x209
    x211 = x12 * x2 * x28
    x212 = x113 * x201 + x211
    x213 = x12 * x45
    x214 = x18 * x213
    x215 = x19 * (x12 * x15 * x3 * x77 - x206)
    x216 = 0.5 * x215
    x217 = x201 * x6
    x218 = x100 * x207
    x219 = x217 * x97 + x218
    x220 = x180 * x213 + x216 + x219 * x56
    x221 = x19 * (-x210 + x212) + x199 * x2 + x220 * x56
    x222 = (
        x2 * x200
        + x221 * x56
        + x48 * (-x16 * (x205 + x207 * x50 + x210 * x6) + x203 + x212 * x56 + x214 * x89)
    )
    x223 = x19 * (2.0 * x12 * x19 * x21 * x22 * x25 * x42 - x213 * x30)
    x224 = 0.5 * x223
    x225 = x19 * (2.0 * x12 * x19 * x21 * x22 * x25 * x30 - x214)
    x226 = 0.5 * x225
    x227 = x200 * x56 + x48 * (-x16 * (x195 * x39 + x226) + x18 * x198 + x224)
    x228 = x19 * (-x115 * x201 + x12 * x122 * x15 * x3)
    x229 = 0.5 * x228
    x230 = x129 * x201
    x231 = x19 * (x115 * x12 * x15 * x3 - x230)
    x232 = 0.5 * x231
    x233 = x138 * x201
    x234 = x12 * x16
    x235 = x16 * (x136 * x234 + x233 * x6)
    x236 = x125 * x234 + x230 * x6
    x237 = x19 * (x12 * x129 * x15 * x3 - x233)
    x238 = 0.5 * x237
    x239 = x10 * x163
    x240 = x239 * x77 + x92
    x241 = x2 * x240
    x242 = x239 * x84 + x82
    x243 = x2 * x242
    x244 = x16 * (x134 + x138 * x239)
    x245 = x129 * x239 + x143
    x246 = x10 * x45
    x247 = x18 * x246 + x44
    x248 = x2 * x247
    x249 = x10 * x49 + x33
    x250 = x2 * x249
    x251 = x16 * x242
    x252 = x16 * x249
    x253 = x247 - x252
    x254 = x246 * x54 + x53
    x255 = x163 * x7
    x256 = x253 * x32 + x254 * x255
    x257 = x240 - x251
    x258 = x2 * x254
    x259 = x239 * x97 + x94
    x260 = x258 + x259 * x56
    x261 = x257 * x32 + x258 * x56 + x260 * x56
    x262 = x19 * (-x16 * (x250 + x251 * x6) + x240 * x56 + x248) + x2 * x256 + x261 * x56
    x263 = x163 * x6
    x264 = x19 * (x15 * x247 * x3 * x6 - x249 * x263) + x256 * x56
    x265 = -x244 + x245
    x266 = x2 * x259
    x267 = x146 + x151 * x239
    x268 = x12 * x9
    x269 = x3**3
    x270 = x269 / x14**3
    x271 = x268 * x270
    x272 = x138 * x271
    x273 = x12 * x164
    x274 = x271 * x6
    x275 = x271 * x84
    x276 = x2 * x268 * x49
    x277 = x268 * x45
    x278 = x18 * x2 * x277
    x279 = x155 * x268
    x280 = x19 * (2.0 * x12 * x18 * x19 * x21 * x25 * x3 * x34 * x9 - x279 * x38)
    x281 = x14 ** (-4.5) * x268 * x269
    x282 = x158 * x281 * x54 + 0.5 * x280
    x283 = x19 * (x12 * x153 * x162 * x77 * x9 - x275)
    x284 = x2 * x277 * x54
    x285 = x274 * x97 + x284
    x286 = x37 * x54
    x287 = x279 * x286 * x89 + 0.5 * x283 + x285 * x56
    x288 = x19 * (x113 * x271 - x16 * (x275 * x6 + x276) + x278) + x2 * x282 + x287 * x56
    x289 = (
        x19 * (2.0 * x12 * x153 * x154 * x18 * x19 * x21 * x25 * x6 * x9 - x152 * x281)
        + x282 * x56
    )
    x290 = x19 * (x12 * x129 * x153 * x162 * x9 - x272)
    x291 = x13 * x163
    x292 = x291 * x77 + x92
    x293 = x2 * x292
    x294 = x291 * x84 + x82
    x295 = x2 * x294
    x296 = x134 + x138 * x291
    x297 = x16 * x296
    x298 = x129 * x291 + x143
    x299 = x13 * x45
    x300 = x18 * x299 + x44
    x301 = x2 * x300
    x302 = x13 * x49 + x33
    x303 = x2 * x302
    x304 = x16 * x294
    x305 = x16 * x302
    x306 = x300 - x305
    x307 = x306 * x32
    x308 = x299 * x54 + x53
    x309 = x255 * x308 + x307
    x310 = x292 - x304
    x311 = x310 * x32
    x312 = x2 * x308
    x313 = x291 * x97 + x94
    x314 = x312 + x313 * x56
    x315 = x311 + x312 * x56 + x314 * x56
    x316 = x19 * (-x16 * (x303 + x304 * x6) + x292 * x56 + x301) + x2 * x309 + x315 * x56
    x317 = x19 * (x15 * x3 * x300 * x6 - x263 * x302) + x309 * x56
    x318 = -x297 + x298
    x319 = x318 * x32
    x320 = x2 * x313
    x321 = 2.0 * x320
    x322 = x146 + x151 * x291
    x323 = -x16 * (x166 + x251 * x9) + x165 + x191 * x240
    x324 = x157 + x191 * x254
    x325 = x2 * x324
    x326 = x176 + x191 * x259
    x327 = x325 + x326 * x56
    x328 = x32 * x323 + x325 * x56 + x327 * x56
    x329 = -x16 * (x185 + x252 * x9) + x184 + x191 * x247
    x330 = x255 * x324 + x32 * x329
    x331 = -x16 * (x189 + x244 * x9) + x187 + x191 * x245
    x332 = x2 * x326
    x333 = x191 * x267 + x194
    x334 = x12 * x270
    x335 = x10 * x334
    x336 = -x16 * (x205 + x335 * x84) + x203 + x335 * x77
    x337 = x10 * x195
    x338 = x197 + x286 * x337
    x339 = x2 * x338
    x340 = x216 + x335 * x97
    x341 = x339 + x340 * x56
    x342 = x32 * x336 + x339 * x56 + x341 * x56
    x343 = -x16 * (x226 + x337 * x38) + x18 * x337 * x37 + x224
    x344 = x255 * x338 + x32 * x343
    x345 = x129 * x335 - x16 * (x138 * x335 + x232) + x229
    x346 = x2 * x340
    x347 = x151 * x335 + x238
    x348 = x19 * (x15 * x292 * x3 * x9 - x164 * x294)
    x349 = x191 * x312
    x350 = x177 * x313 + x349
    x351 = x177 * x312 + 0.5 * x348 + x350 * x56
    x352 = x19 * (x15 * x3 * x300 * x9 - x164 * x302)
    x353 = x270 * x9
    x354 = x353 * x7
    x355 = x308 * x354 + 0.5 * x352
    x356 = x19 * (x15 * x298 * x3 * x9 - x164 * x296)
    x357 = -x16 * (x12 * x304 + x204) + x202 + x234 * x292
    x358 = x32 * x357
    x359 = x196 + x234 * x308
    x360 = x2 * x359
    x361 = x215 + x234 * x313
    x362 = x360 + x361 * x56
    x363 = x358 + x360 * x56 + x362 * x56
    x364 = -x16 * (x12 * x305 + x225) + x223 + x234 * x300
    x365 = x32 * x364
    x366 = x255 * x359 + x365
    x367 = -x16 * (x12 * x297 + x231) + x228 + x234 * x298
    x368 = x32 * x367
    x369 = x2 * x361
    x370 = 2.0 * x369
    x371 = x234 * x322 + x237
    x372 = x191 * x324 + x253 * x48
    x373 = x2 * x372
    x374 = x191 * x326 + x257 * x48
    x375 = x373 + x374 * x56
    x376 = x0 * x56
    x377 = x2 * x374
    x378 = x191 * x333 + x265 * x48
    x379 = x191 * x338 + x280
    x380 = x2 * x379
    x381 = x191 * x340 + x283
    x382 = x380 + x381 * x56
    x383 = x2 * x381
    x384 = x191 * x347 + x290
    x385 = x239 * x308 + x307
    x386 = x2 * x385
    x387 = x239 * x313 + x311
    x388 = x386 + x387 * x56
    x389 = x2 * x387
    x390 = x239 * x322 + x319
    x391 = x191 * x360
    x392 = x177 * x361 + x391
    x393 = x177 * x359
    x394 = x234 * x359 + x306 * x48
    x395 = x2 * x394
    x396 = x234 * x361 + x310 * x48
    x397 = x395 + x396 * x56
    x398 = x2 * x396
    x399 = x234 * x371 + x318 * x48
    x400 = x191 * x374 + x20 * x323
    x401 = x191 * x372 + x20 * x329
    x402 = x191 * x381 + x336 * x48
    x403 = x191 * x379 + x343 * x48
    x404 = x191 * x387 + x348
    x405 = x191 * x385 + x352
    x406 = x239 * x361 + x358
    x407 = x239 * x359 + x365
    x408 = x191 * x396
    x409 = x191 * x394
    x410 = x20 * x357 + x234 * x396
    x411 = x20 * x364 + x234 * x394
    x412 = -x8 - A[1]
    x413 = -2.0 * x18 * x19 * x21 * x25 * x29 * x4 * x412 + x75 * x9
    x414 = -x413
    x415 = x16 * x414
    x416 = -2.0 * x19 * x21 * x25 * x29 * x30 * x4 * x412 + x61 * x9
    x417 = x32 * (-x415 - x416)
    x418 = 2.0 * x19 * x21 * x25 * x29 * x36 * x4 * x412 - x83 * x9
    x419 = x255 * x418 + x417
    x420 = x16 * x419
    x421 = -x416
    x422 = x16 * x421
    x423 = -2.0 * x19 * x21 * x25 * x29 * x4 * x412 * x42 + x71 * x9
    x424 = x32 * (-x422 - x423)
    x425 = x255 * x414 + x424
    x426 = x16 * x418
    x427 = x32 * (-x413 - x426)
    x428 = 2.0 * x19 * x21 * x25 * x29 * x4 * x412 * x54 - x9 * x96
    x429 = x255 * x428 + x427
    x430 = x19 * (x15 * x3 * x414 * x6 - x263 * x418) + x429 * x56
    x431 = x430 * x56 + x48 * (-x420 + x425)
    x432 = -x423
    x433 = (
        x20
        * (
            -x16 * (x19 * (x15 * x3 * x421 * x6 - x263 * x414) + x420 * x6)
            + x19 * (x15 * x3 * x432 * x6 - x263 * x421)
            + x425 * x56
        )
        + x431 * x56
    )
    x434 = x106 * x23 + x433
    x435 = x2 * x432
    x436 = x2 * x421
    x437 = x120 * x414 - x421 * x62
    x438 = -x437
    x439 = x16 * x438
    x440 = x436 + x439 * x6
    x441 = x120 * x421 - x432 * x62
    x442 = -x441
    x443 = x2 * x414
    x444 = x120 * x418 - x414 * x62
    x445 = -x444
    x446 = x16 * x445
    x447 = x443 + x446 * x6
    x448 = x16 * x447
    x449 = x32 * (-x437 - x446)
    x450 = x2 * x418
    x451 = -x120 * x428 + x418 * x62
    x452 = x16 * x451
    x453 = x16 * (x450 + x452 * x6)
    x454 = x16 * (x449 + x450 * x56 + x453 * x6)
    x455 = x32 * (-x439 - x441)
    x456 = x443 * x56 + x448 * x6 + x455
    x457 = x32 * (-x444 - x452)
    x458 = x2 * x428
    x459 = -x150 * x9 + 2.0 * x19 * x21 * x25 * x29 * x4 * x412 * x95
    x460 = -x120 * x459 + x428 * x62
    x461 = x426 * x9 + x86
    x462 = x415 * x9 + x79
    x463 = x16 * x461
    x464 = x19 * (x462 - x463)
    x465 = x191 * x428 + x98
    x466 = x255 * x465 + 0.5 * x464
    x467 = x19 * (x15 * x3 * x462 * x6 - x263 * x461) + x466 * x56
    x468 = x422 * x9 + x68
    x469 = x19 * (-x16 * x468 + x191 * x432 + x74)
    x470 = x16 * x462
    x471 = x19 * (x468 - x470)
    x472 = x467 * x56 + x48 * (
        -x16 * (x255 * x461 + 0.5 * x471) + x255 * x462 + 0.5 * x469
    )
    x473 = x186 * x23 + x472
    x474 = x108 + x439 * x9
    x475 = x19 * (x107 - x16 * x474 + x191 * x442)
    x476 = x124 + x446 * x9
    x477 = x16 * x476
    x478 = x19 * (x474 - x477)
    x479 = x2 * x461
    x480 = x16 * (x135 + x452 * x9)
    x481 = x16 * (x479 + x480 * x6)
    x482 = x2 * x462
    x483 = x477 * x6 + x482
    x484 = x19 * (x476 - x480)
    x485 = x2 * x465
    x486 = x147 + x191 * x460
    x487 = x334 * x418
    x488 = x19 * (x12 * x15 * x3 * x414 - x201 * x418)
    x489 = 0.5 * x488
    x490 = x334 * x7
    x491 = x428 * x490 + x489
    x492 = x19 * (x12 * x153 * x162 * x414 * x6 - x487 * x6) + x491 * x56
    x493 = x19 * (x12 * x15 * x3 * x432 - x201 * x421)
    x494 = 0.5 * x493
    x495 = x19 * (x12 * x15 * x3 * x421 - x201 * x414)
    x496 = 0.5 * x495
    x497 = x48 * (-x16 * (x487 * x7 + x496) + x414 * x490 + x494) + x492 * x56
    x498 = x227 * x23 + x497
    x499 = x19 * (x12 * x15 * x3 * x442 - x201 * x438)
    x500 = 0.5 * x499
    x501 = x201 * x445
    x502 = x19 * (x12 * x15 * x3 * x438 - x501)
    x503 = 0.5 * x502
    x504 = x201 * x451
    x505 = x234 * x450
    x506 = x16 * (x504 * x6 + x505)
    x507 = x234 * x443
    x508 = x501 * x6 + x507
    x509 = x19 * (x12 * x15 * x3 * x445 - x504)
    x510 = 0.5 * x509
    x511 = x234 * x458
    x512 = x172 + x424 + x470 * x9
    x513 = x2 * x512
    x514 = x169 + x417 + x463 * x9
    x515 = x2 * x514
    x516 = x16 * (x135 * x191 + x449 + x480 * x9)
    x517 = x124 * x191 + x455 + x477 * x9
    x518 = x16 * x514
    x519 = x512 - x518
    x520 = x178 + x191 * x465 + x427
    x521 = x255 * x520 + x32 * x519
    x522 = x19 * (x15 * x3 * x512 * x6 - x263 * x514) + x521 * x56
    x523 = x23 * x264 + x522
    x524 = -x516 + x517
    x525 = x2 * x520
    x526 = x147 * x191 + x191 * x486 + x457
    x527 = x211 + x273 * x414
    x528 = x2 * x527
    x529 = x208 + x273 * x418
    x530 = x2 * x529
    x531 = x135 * x234
    x532 = x16 * (x273 * x451 + x531)
    x533 = x124 * x234
    x534 = x273 * x445 + x533
    x535 = x16 * x529
    x536 = x19 * (x527 - x535)
    x537 = x218 + x273 * x428
    x538 = x255 * x537 + 0.5 * x536
    x539 = x19 * (x15 * x3 * x527 * x6 - x263 * x529) + x538 * x56
    x540 = x23 * x289 + x539
    x541 = x19 * (-x532 + x534)
    x542 = x2 * x537
    x543 = x147 * x234
    x544 = x273 * x460 + x543
    x545 = x291 * x414 + x424
    x546 = x2 * x545
    x547 = x291 * x418 + x417
    x548 = x2 * x547
    x549 = x16 * (x291 * x451 + x449)
    x550 = x291 * x445 + x455
    x551 = x16 * x547
    x552 = x545 - x551
    x553 = x32 * x552
    x554 = x291 * x428 + x427
    x555 = x255 * x554 + x553
    x556 = x19 * (x15 * x3 * x545 * x6 - x263 * x547) + x555 * x56
    x557 = x23 * x317 + x556
    x558 = -x549 + x550
    x559 = x32 * x558
    x560 = x2 * x554
    x561 = x291 * x460 + x457
    x562 = -x16 * (x250 + x471 + x518 * x9) + x191 * x512 + x248 + x469
    x563 = x191 * x520 + x258 + x464
    x564 = x255 * x563 + x32 * x562
    x565 = x23 * x330 + x564
    x566 = -x16 * (x243 + x478 + x516 * x9) + x191 * x517 + x241 + x475
    x567 = x2 * x563
    x568 = x191 * x526 + x266 + x484
    x569 = -x16 * (x276 + x496 + x535 * x9) + x191 * x527 + x278 + x494
    x570 = x191 * x537 + x284 + x489
    x571 = x255 * x570 + x32 * x569
    x572 = x23 * x344 + x571
    x573 = x124 * x273 - x16 * (x135 * x273 + x503 + x532 * x9) + x191 * x534 + x500
    x574 = x2 * x570
    x575 = x147 * x273 + x191 * x544 + x510
    x576 = x19 * (-x16 * (x303 + x551 * x9) + x191 * x545 + x301)
    x577 = x191 * x554 + x312
    x578 = x255 * x577 + 0.5 * x576
    x579 = x23 * x355 + x578
    x580 = x19 * (-x16 * (x295 + x549 * x9) + x191 * x550 + x293)
    x581 = x2 * x577
    x582 = x191 * x561 + x320
    x583 = -x16 * (x12 * x551 + x495) + x234 * x545 + x493
    x584 = x32 * x583
    x585 = x234 * x554 + x488
    x586 = x255 * x585 + x584
    x587 = x23 * x366 + x586
    x588 = -x16 * (x12 * x549 + x502) + x234 * x550 + x499
    x589 = x32 * x588
    x590 = x2 * x585
    x591 = x234 * x561 + x509
    x592 = x191 * x563 + x325 + x48 * x519
    x593 = x2 * x592
    x594 = x56 * x592
    x595 = x23 * x56
    x596 = x372 * x595 + x594
    x597 = x191 * x568 + x332 + x48 * x524
    x598 = x191 * x570 + x339 + x536
    x599 = x2 * x598
    x600 = x56 * x598
    x601 = x379 * x595 + x600
    x602 = x191 * x575 + x346 + x541
    x603 = x191 * x577 + x349 + x553
    x604 = x2 * x603
    x605 = x56 * x603
    x606 = x385 * x595 + x605
    x607 = x191 * x320 + x191 * x582 + x559
    x608 = x191 * x585 + x360
    x609 = x2 * x608
    x610 = x56 * x608
    x611 = x23 * x393 + x610
    x612 = x191 * x591 + x369
    x613 = x234 * x585 + x48 * x552
    x614 = x2 * x613
    x615 = x56 * x613
    x616 = x394 * x595 + x615
    x617 = x234 * x591 + x48 * x558
    x618 = x191 * x592 + x20 * x562 + x373
    x619 = x23 * x401 + x618
    x620 = x191 * x598 + x380 + x48 * x569
    x621 = x23 * x403 + x620
    x622 = x191 * x603 + x386 + x576
    x623 = x23 * x405 + x622
    x624 = x191 * x608 + x391 + x584
    x625 = x23 * x407 + x624
    x626 = x191 * x613 + x395
    x627 = x23 * x409 + x626
    x628 = x20 * x583 + x234 * x613
    x629 = x23 * x411 + x628
    x630 = -x11 - A[2]
    x631 = x12 * x75 - 2.0 * x18 * x19 * x21 * x25 * x29 * x4 * x630
    x632 = -x631
    x633 = x16 * x632
    x634 = x12 * x61 - 2.0 * x19 * x21 * x25 * x29 * x30 * x4 * x630
    x635 = x32 * (-x633 - x634)
    x636 = -x12 * x83 + 2.0 * x19 * x21 * x25 * x29 * x36 * x4 * x630
    x637 = x255 * x636 + x635
    x638 = x16 * x637
    x639 = -x634
    x640 = x16 * x639
    x641 = x12 * x71 - 2.0 * x19 * x21 * x25 * x29 * x4 * x42 * x630
    x642 = x32 * (-x640 - x641)
    x643 = x255 * x632 + x642
    x644 = x16 * x636
    x645 = x32 * (-x631 - x644)
    x646 = -x12 * x96 + 2.0 * x19 * x21 * x25 * x29 * x4 * x54 * x630
    x647 = x255 * x646 + x645
    x648 = x19 * (x15 * x3 * x6 * x632 - x263 * x636) + x56 * x647
    x649 = x48 * (-x638 + x643) + x56 * x648
    x650 = -x641
    x651 = (
        x20
        * (
            -x16 * (x19 * (x15 * x3 * x6 * x639 - x263 * x632) + x6 * x638)
            + x19 * (x15 * x3 * x6 * x650 - x263 * x639)
            + x56 * x643
        )
        + x56 * x649
    )
    x652 = x106 * x24 + x651
    x653 = x2 * x650
    x654 = x2 * x639
    x655 = x120 * x632 - x62 * x639
    x656 = -x655
    x657 = x16 * x656
    x658 = x6 * x657 + x654
    x659 = x120 * x639 - x62 * x650
    x660 = -x659
    x661 = x2 * x632
    x662 = x120 * x636 - x62 * x632
    x663 = -x662
    x664 = x16 * x663
    x665 = x6 * x664 + x661
    x666 = x16 * x665
    x667 = x32 * (-x655 - x664)
    x668 = x2 * x636
    x669 = -x120 * x646 + x62 * x636
    x670 = x16 * x669
    x671 = x16 * (x6 * x670 + x668)
    x672 = x16 * (x56 * x668 + x6 * x671 + x667)
    x673 = x32 * (-x657 - x659)
    x674 = x56 * x661 + x6 * x666 + x673
    x675 = x32 * (-x662 - x670)
    x676 = x2 * x646
    x677 = -x12 * x150 + 2.0 * x19 * x21 * x25 * x29 * x4 * x630 * x95
    x678 = -x120 * x677 + x62 * x646
    x679 = x353 * x6
    x680 = x19 * (x15 * x3 * x632 * x9 - x164 * x636)
    x681 = x354 * x646 + 0.5 * x680
    x682 = x19 * (x153 * x162 * x6 * x632 * x9 - x636 * x679) + x56 * x681
    x683 = x19 * (x15 * x3 * x650 * x9 - x164 * x639)
    x684 = x19 * (x15 * x3 * x639 * x9 - x164 * x632)
    x685 = (
        x48 * (-x16 * (x354 * x636 + 0.5 * x684) + x354 * x632 + 0.5 * x683) + x56 * x682
    )
    x686 = x186 * x24 + x685
    x687 = x19 * (x15 * x3 * x660 * x9 - x164 * x656)
    x688 = x164 * x663
    x689 = x19 * (x15 * x3 * x656 * x9 - x688)
    x690 = x164 * x669
    x691 = x191 * x668
    x692 = x16 * (x6 * x690 + x691)
    x693 = x191 * x661
    x694 = x6 * x688 + x693
    x695 = x19 * (x15 * x3 * x663 * x9 - x690)
    x696 = x191 * x676
    x697 = x12 * x644 + x86
    x698 = x12 * x633 + x79
    x699 = x16 * x697
    x700 = x19 * (x698 - x699)
    x701 = 0.5 * x700
    x702 = x234 * x646 + x98
    x703 = x255 * x702 + x701
    x704 = x19 * (x15 * x3 * x6 * x698 - x263 * x697) + x56 * x703
    x705 = x12 * x640 + x68
    x706 = x19 * (-x16 * x705 + x234 * x650 + x74)
    x707 = 0.5 * x706
    x708 = x16 * x698
    x709 = x19 * (x705 - x708)
    x710 = 0.5 * x709
    x711 = x48 * (-x16 * (x255 * x697 + x710) + x255 * x698 + x707) + x56 * x704
    x712 = x227 * x24 + x711
    x713 = x108 + x12 * x657
    x714 = x19 * (x107 - x16 * x713 + x234 * x660)
    x715 = 0.5 * x714
    x716 = x12 * x664 + x124
    x717 = x16 * x716
    x718 = x19 * (x713 - x717)
    x719 = 0.5 * x718
    x720 = x2 * x697
    x721 = x12 * x670 + x135
    x722 = x16 * x721
    x723 = x16 * (x6 * x722 + x720)
    x724 = x2 * x698
    x725 = x6 * x717 + x724
    x726 = x19 * (x716 - x722)
    x727 = 0.5 * x726
    x728 = x2 * x702
    x729 = x147 + x234 * x678
    x730 = x239 * x632 + x642
    x731 = x2 * x730
    x732 = x239 * x636 + x635
    x733 = x2 * x732
    x734 = x16 * (x239 * x669 + x667)
    x735 = x239 * x663 + x673
    x736 = x16 * x732
    x737 = x730 - x736
    x738 = x239 * x646 + x645
    x739 = x255 * x738 + x32 * x737
    x740 = x19 * (x15 * x3 * x6 * x730 - x263 * x732) + x56 * x739
    x741 = x24 * x264 + x740
    x742 = -x734 + x735
    x743 = x2 * x738
    x744 = x239 * x678 + x675
    x745 = x164 * x721
    x746 = x191 * x720
    x747 = x191 * x724
    x748 = x19 * (x15 * x3 * x698 * x9 - x164 * x697)
    x749 = x354 * x702 + 0.5 * x748
    x750 = x19 * (x153 * x162 * x6 * x698 * x9 - x679 * x697) + x56 * x749
    x751 = x24 * x289 + x750
    x752 = x19 * (x15 * x3 * x716 * x9 - x745)
    x753 = x191 * x728
    x754 = x12 * x708 + x211 + x642
    x755 = x2 * x754
    x756 = x12 * x699 + x208 + x635
    x757 = x2 * x756
    x758 = x12 * x722 + x531 + x667
    x759 = x16 * x758
    x760 = x12 * x717 + x533 + x673
    x761 = x16 * x756
    x762 = x754 - x761
    x763 = x32 * x762
    x764 = x218 + x234 * x702 + x645
    x765 = x255 * x764 + x763
    x766 = x19 * (x15 * x3 * x6 * x754 - x263 * x756) + x56 * x765
    x767 = x24 * x317 + x766
    x768 = -x759 + x760
    x769 = x32 * x768
    x770 = x2 * x764
    x771 = x234 * x729 + x543 + x675
    x772 = -x16 * (x684 + x736 * x9) + x191 * x730 + x683
    x773 = x191 * x738 + x680
    x774 = x255 * x773 + x32 * x772
    x775 = x24 * x330 + x774
    x776 = -x16 * (x689 + x734 * x9) + x191 * x735 + x687
    x777 = x2 * x773
    x778 = x191 * x744 + x695
    x779 = -x16 * (x239 * x697 + x710) + x239 * x698 + x707
    x780 = x239 * x702 + x701
    x781 = x255 * x780 + x32 * x779
    x782 = x24 * x344 + x781
    x783 = -x16 * (x239 * x721 + x719) + x239 * x716 + x715
    x784 = x2 * x780
    x785 = x239 * x729 + x727
    x786 = x19 * (x15 * x3 * x754 * x9 - x164 * x756)
    x787 = x354 * x764 + 0.5 * x786
    x788 = x24 * x355 + x787
    x789 = x19 * (x15 * x3 * x760 * x9 - x164 * x758)
    x790 = x191 * x770
    x791 = -x16 * (x12 * x761 + x303 + x709) + x234 * x754 + x301 + x706
    x792 = x32 * x791
    x793 = x234 * x764 + x312 + x700
    x794 = x255 * x793 + x792
    x795 = x24 * x366 + x794
    x796 = -x16 * (x12 * x759 + x295 + x718) + x234 * x760 + x293 + x714
    x797 = x32 * x796
    x798 = x2 * x793
    x799 = x234 * x771 + x320 + x726
    x800 = x191 * x773 + x48 * x737
    x801 = x2 * x800
    x802 = x56 * x800
    x803 = x24 * x56
    x804 = x372 * x803 + x802
    x805 = x191 * x778 + x48 * x742
    x806 = x191 * x780 + x748
    x807 = x2 * x806
    x808 = x56 * x806
    x809 = x379 * x803 + x808
    x810 = x191 * x785 + x752
    x811 = x239 * x764 + x763
    x812 = x2 * x811
    x813 = x56 * x811
    x814 = x385 * x803 + x813
    x815 = x239 * x771 + x769
    x816 = x177 * x793
    x817 = x24 * x393 + x816
    x818 = x191 * x798
    x819 = x234 * x793 + x360 + x48 * x762
    x820 = x2 * x819
    x821 = x56 * x819
    x822 = x394 * x803 + x821
    x823 = x234 * x799 + x369 + x48 * x768
    x824 = x191 * x800 + x20 * x772
    x825 = x24 * x401 + x824
    x826 = x191 * x806 + x48 * x779
    x827 = x24 * x403 + x826
    x828 = x191 * x811 + x786
    x829 = x24 * x405 + x828
    x830 = x239 * x793 + x792
    x831 = x24 * x407 + x830
    x832 = x191 * x819
    x833 = x24 * x409 + x832
    x834 = x20 * x791 + x234 * x819 + x395
    x835 = x24 * x411 + x834
    x836 = x112 * x9
    x837 = x414 * x836
    x838 = x111 + x412 * x421 - x837
    x839 = x421 * x836
    x840 = x119 + x412 * x432 - x839
    x841 = x418 * x836
    x842 = x127 + x412 * x414 - x841
    x843 = x16 * x842
    x844 = x32 * (-x133 + x412 * x421 - x837 - x843)
    x845 = x137 + x412 * x418 - x428 * x836
    x846 = x16 * (x255 * x845 + x844)
    x847 = x16 * x838
    x848 = x32 * (-x142 + x412 * x432 - x839 - x847)
    x849 = x255 * x842 + x848
    x850 = x16 * x845
    x851 = x32 * (-x145 + x412 * x414 - x841 - x850)
    x852 = x149 + x412 * x428 - x459 * x836
    x853 = 2.0 * x436 + x847 * x9
    x854 = x19 * (-x16 * x853 + x191 * x840 + 2.0 * x435)
    x855 = 2.0 * x443
    x856 = x843 * x9 + x855
    x857 = x16 * x856
    x858 = x19 * (x853 - x857)
    x859 = 2.0 * x450
    x860 = x850 * x9 + x859
    x861 = x16 * x860
    x862 = x19 * (x856 - x861)
    x863 = 2.0 * x458
    x864 = x191 * x852 + x863
    x865 = x19 * (x12 * x15 * x3 * x840 - x201 * x838)
    x866 = 0.5 * x865
    x867 = x19 * (x12 * x15 * x3 * x838 - x201 * x842)
    x868 = 0.5 * x867
    x869 = x19 * (x12 * x15 * x3 * x842 - x201 * x845)
    x870 = 0.5 * x869
    x871 = 2.0 * x479 + x844 + x861 * x9
    x872 = 2.0 * x482 + x848 + x857 * x9
    x873 = x16 * x871
    x874 = x872 - x873
    x875 = x191 * x864 + 2.0 * x485 + x851
    x876 = x234 * x859 + x273 * x845
    x877 = x234 * x855 + x273 * x842
    x878 = x16 * x876
    x879 = x19 * (x877 - x878)
    x880 = x234 * x863 + x273 * x852
    x881 = x291 * x845 + x844
    x882 = x291 * x842 + x848
    x883 = x16 * x881
    x884 = x882 - x883
    x885 = x32 * x884
    x886 = x291 * x852 + x851
    x887 = -x16 * (2.0 * x515 + x858 + x873 * x9) + x191 * x872 + 2.0 * x513 + x854
    x888 = x191 * x875 + 2.0 * x525 + x862
    x889 = -x16 * (2.0 * x530 + x868 + x878 * x9) + x191 * x877 + 2.0 * x528 + x866
    x890 = x191 * x880 + 2.0 * x542 + x870
    x891 = x19 * (-x16 * (2.0 * x548 + x883 * x9) + x191 * x882 + 2.0 * x546)
    x892 = x191 * x886 + 2.0 * x560
    x893 = -x16 * (x12 * x883 + x867) + x234 * x882 + x865
    x894 = x32 * x893
    x895 = x234 * x886 + x869
    x896 = x191 * x888 + x48 * x874 + 2.0 * x567
    x897 = x191 * x890 + 2.0 * x574 + x879
    x898 = x191 * x892 + 2.0 * x581 + x885
    x899 = x191 * x895 + 2.0 * x590
    x900 = x234 * x895 + x48 * x884
    x901 = -x412 * x639 + x632 * x836
    x902 = -x901
    x903 = -x412 * x650 + x639 * x836
    x904 = -x903
    x905 = -x412 * x632 + x636 * x836
    x906 = -x905
    x907 = x16 * x906
    x908 = x32 * (-x901 - x907)
    x909 = x412 * x636 - x646 * x836
    x910 = x16 * (x255 * x909 + x908)
    x911 = x16 * x902
    x912 = x32 * (-x903 - x911)
    x913 = x255 * x906 + x912
    x914 = x16 * x909
    x915 = x32 * (-x905 - x914)
    x916 = x412 * x646 - x677 * x836
    x917 = x654 + x9 * x911
    x918 = x19 * (-x16 * x917 + x191 * x904 + x653)
    x919 = x661 + x9 * x907
    x920 = x16 * x919
    x921 = x19 * (x917 - x920)
    x922 = x668 + x9 * x914
    x923 = x16 * x922
    x924 = x19 * (x919 - x923)
    x925 = x191 * x916 + x676
    x926 = x12 * x911 + x436
    x927 = x19 * (-x16 * x926 + x234 * x904 + x435)
    x928 = 0.5 * x927
    x929 = x12 * x907 + x443
    x930 = x16 * x929
    x931 = x19 * (x926 - x930)
    x932 = 0.5 * x931
    x933 = x12 * x914 + x450
    x934 = x16 * x933
    x935 = x19 * (x929 - x934)
    x936 = 0.5 * x935
    x937 = x234 * x916 + x458
    x938 = x691 + x9 * x923 + x908
    x939 = x693 + x9 * x920 + x912
    x940 = x16 * x938
    x941 = x939 - x940
    x942 = x191 * x925 + x696 + x915
    x943 = x720 + x9 * x934
    x944 = x724 + x9 * x930
    x945 = x16 * x943
    x946 = x19 * (x944 - x945)
    x947 = x191 * x937 + x728
    x948 = x12 * x934 + x505 + x908
    x949 = x12 * x930 + x507 + x912
    x950 = x16 * x948
    x951 = x949 - x950
    x952 = x32 * x951
    x953 = x234 * x937 + x511 + x915
    x954 = -x16 * (x733 + x9 * x940 + x921) + x191 * x939 + x731 + x918
    x955 = x191 * x942 + x743 + x924
    x956 = -x16 * (x746 + x9 * x945 + x932) + x191 * x944 + x747 + x928
    x957 = x191 * x947 + x753 + x936
    x958 = x19 * (-x16 * (x757 + x9 * x950) + x191 * x949 + x755)
    x959 = x191 * x953 + x770
    x960 = -x16 * (x12 * x950 + x548 + x931) + x234 * x949 + x546 + x927
    x961 = x32 * x960
    x962 = x234 * x953 + x560 + x935
    x963 = x191 * x955 + x48 * x941 + x777
    x964 = x191 * x957 + x784 + x946
    x965 = x191 * x959 + x790 + x952
    x966 = x191 * x962 + x798
    x967 = x234 * x962 + x48 * x951 + x590
    x968 = x112 * x12
    x969 = x632 * x968
    x970 = x111 + x630 * x639 - x969
    x971 = x639 * x968
    x972 = x119 + x630 * x650 - x971
    x973 = x636 * x968
    x974 = x127 + x630 * x632 - x973
    x975 = x16 * x974
    x976 = x32 * (-x133 + x630 * x639 - x969 - x975)
    x977 = x137 + x630 * x636 - x646 * x968
    x978 = x16 * (x255 * x977 + x976)
    x979 = x16 * x970
    x980 = x32 * (-x142 + x630 * x650 - x971 - x979)
    x981 = x255 * x974 + x980
    x982 = x16 * x977
    x983 = x32 * (-x145 + x630 * x632 - x973 - x982)
    x984 = x149 + x630 * x646 - x677 * x968
    x985 = x19 * (x15 * x3 * x9 * x972 - x164 * x970)
    x986 = x19 * (x15 * x3 * x9 * x970 - x164 * x974)
    x987 = x19 * (x15 * x3 * x9 * x974 - x164 * x977)
    x988 = x12 * x979 + 2.0 * x654
    x989 = x19 * (-x16 * x988 + x234 * x972 + 2.0 * x653)
    x990 = 0.5 * x989
    x991 = x12 * x975 + 2.0 * x661
    x992 = x16 * x991
    x993 = x19 * (x988 - x992)
    x994 = 0.5 * x993
    x995 = x12 * x982 + 2.0 * x668
    x996 = x16 * x995
    x997 = x19 * (x991 - x996)
    x998 = 0.5 * x997
    x999 = x234 * x984 + 2.0 * x676
    x1000 = x239 * x977 + x976
    x1001 = x239 * x974 + x980
    x1002 = x1000 * x16
    x1003 = x1001 - x1002
    x1004 = x239 * x984 + x983
    x1005 = x19 * (x15 * x3 * x9 * x991 - x164 * x995)
    x1006 = x12 * x996 + 2.0 * x720 + x976
    x1007 = x12 * x992 + 2.0 * x724 + x980
    x1008 = x1006 * x16
    x1009 = x1007 - x1008
    x1010 = x1009 * x32
    x1011 = x234 * x999 + 2.0 * x728 + x983
    x1012 = x1001 * x191 - x16 * (x1002 * x9 + x986) + x985
    x1013 = x1004 * x191 + x987
    x1014 = -x16 * (x239 * x995 + x994) + x239 * x991 + x990
    x1015 = x239 * x999 + x998
    x1016 = x19 * (-x1006 * x164 + x1007 * x15 * x3 * x9)
    x1017 = x1007 * x234 - x16 * (x1008 * x12 + 2.0 * x757 + x993) + 2.0 * x755 + x989
    x1018 = x1017 * x32
    x1019 = x1011 * x234 + 2.0 * x770 + x997
    x1020 = x1003 * x48 + x1013 * x191
    x1021 = x1005 + x1015 * x191
    x1022 = x1010 + x1011 * x239
    x1023 = x1009 * x48 + x1019 * x234 + 2.0 * x798

    # 126 item(s)
    return numpy.array(
        [
            x0 * x104
            + x0 * (x0 * x106 + x104)
            + x103 * x123
            + x20
            * (
                x123 * x93
                + x144 * x56
                - x16 * (x123 * x90 + x141 * x6 + x19 * (x117 - x132))
                + x19 * (2.0 * x107 - x117 * x16 + x122 * x56)
            )
            + x56
            * (
                x102 * x123
                + x48 * (-x141 + x144)
                + x56
                * (
                    x101 * x123
                    + x19 * (x131 - x140)
                    + x56 * (x123 * x99 + x146 + x56 * (x148 + x151 * x56))
                )
            ),
            x0 * x183
            + x0 * (x0 * x186 + x183)
            + x123 * x182
            + x48
            * (
                x123 * x173
                - x16 * (x123 * x170 + 0.5 * x189 + x192 * x6)
                + 0.5 * x187
                + x193 * x56
            )
            + x56
            * (
                x123 * x181
                + x19 * (-x192 + x193)
                + x56 * (x123 * x179 + 0.5 * x194 + x56 * (x148 * x191 + x151 * x177))
            ),
            x0 * x222
            + x0 * (x0 * x227 + x222)
            + x123 * x221
            + x48
            * (x123 * x212 - x16 * (x123 * x209 + x232 + x235 * x6) + x229 + x236 * x56)
            + x56
            * (
                x123 * x220
                + x19 * (-x235 + x236)
                + x56 * (x123 * x219 + x238 + x56 * (x148 * x234 + x151 * x217))
            ),
            x0 * x262
            + x0 * (x0 * x264 + x262)
            + x123 * x261
            + x19 * (-x16 * (2.0 * x243 + x244 * x6) + 2.0 * x241 + x245 * x56)
            + x56 * (x123 * x260 + x265 * x32 + x56 * (2.0 * x266 + x267 * x56)),
            x0 * x288
            + x0 * (x0 * x289 + x288)
            + x123 * x287
            + x19 * (x125 * x273 + x129 * x274 - x16 * (x136 * x273 + x272 * x6))
            + x56 * (x123 * x285 + 0.5 * x290 + x56 * (x148 * x273 + x151 * x274)),
            x0 * x316
            + x0 * (x0 * x317 + x316)
            + x123 * x315
            + x19 * (-x16 * (2.0 * x295 + x297 * x6) + 2.0 * x293 + x298 * x56)
            + x56 * (x123 * x314 + x319 + x56 * (x321 + x322 * x56)),
            x0 * x328
            + x0 * (x0 * x330 + x328)
            + x123 * x327
            + x32 * x331
            + x56 * (2.0 * x332 + x333 * x56),
            x0 * x342
            + x0 * (x0 * x344 + x342)
            + x123 * x341
            + x32 * x345
            + x56 * (2.0 * x346 + x347 * x56),
            x0 * x351
            + x0 * (x0 * x355 + x351)
            + x123 * x350
            + 0.5 * x356
            + x56 * (x177 * x322 + x191 * x321),
            x0 * x363
            + x0 * (x0 * x366 + x363)
            + x123 * x362
            + x368
            + x56 * (x370 + x371 * x56),
            x0 * x375 + x0 * (x372 * x376 + x375) + 2.0 * x377 + x378 * x56,
            x0 * x382 + x0 * (x376 * x379 + x382) + 2.0 * x383 + x384 * x56,
            x0 * x388 + x0 * (x376 * x385 + x388) + 2.0 * x389 + x390 * x56,
            x0 * x392 + x0 * (x0 * x393 + x392) + x177 * x371 + x191 * x370,
            x0 * x397 + x0 * (x376 * x394 + x397) + 2.0 * x398 + x399 * x56,
            x0 * x400 + x0 * (x0 * x401 + x400) + x191 * x378 + x20 * x331,
            x0 * x402 + x0 * (x0 * x403 + x402) + x191 * x384 + x345 * x48,
            x0 * x404 + x0 * (x0 * x405 + x404) + x191 * x390 + x356,
            x0 * x406 + x0 * (x0 * x407 + x406) + x239 * x371 + x368,
            x0 * x408 + x0 * (x0 * x409 + x408) + x191 * x399,
            x0 * x410 + x0 * (x0 * x411 + x410) + x20 * x367 + x234 * x399,
            x0 * x434
            + x104 * x23
            + x2 * x431
            + x20
            * (
                -x16 * (x19 * (x440 - x448) + x2 * x419 + x454 * x6)
                + x19 * (-x16 * x440 + x435 + x442 * x56)
                + x2 * x425
                + x456 * x56
            )
            + x56
            * (
                x2 * x430
                + x48 * (-x454 + x456)
                + x56
                * (
                    x19 * (x447 - x453)
                    + x2 * x429
                    + x56 * (x457 + x458 * x56 + x56 * (x458 + x460 * x56))
                )
            ),
            x0 * x473
            + x183 * x23
            + x2 * x467
            + x48
            * (
                -x16 * (0.5 * x478 + x479 * x56 + x481 * x6)
                + 0.5 * x475
                + x482 * x56
                + x483 * x56
            )
            + x56
            * (
                x19 * (-x481 + x483)
                + x2 * x466
                + x56 * (0.5 * x484 + x485 * x56 + x56 * (x485 + x486 * x56))
            ),
            x0 * x498
            + x2 * x492
            + x222 * x23
            + x48
            * (-x16 * (x217 * x450 + x503 + x506 * x6) + x217 * x443 + x500 + x508 * x56)
            + x56
            * (
                x19 * (-x506 + x508)
                + x2 * x491
                + x56 * (x217 * x458 + x510 + x56 * (x217 * x460 + x511))
            ),
            x0 * x523
            + x19 * (-x16 * (x515 + x516 * x6) + x513 + x517 * x56)
            + x2 * x521
            + x23 * x262
            + x56 * (x32 * x524 + x525 * x56 + x56 * (x525 + x526 * x56)),
            x0 * x540
            + x19 * (-x16 * (x530 + x532 * x6) + x528 + x534 * x56)
            + x2 * x538
            + x23 * x288
            + x56 * (0.5 * x541 + x542 * x56 + x56 * (x542 + x544 * x56)),
            x0 * x557
            + x19 * (-x16 * (x548 + x549 * x6) + x546 + x550 * x56)
            + x2 * x555
            + x23 * x316
            + x56 * (x559 + x56 * x560 + x56 * (x56 * x561 + x560)),
            x0 * x565 + x23 * x328 + x32 * x566 + x56 * x567 + x56 * (x56 * x568 + x567),
            x0 * x572 + x23 * x342 + x32 * x573 + x56 * x574 + x56 * (x56 * x575 + x574),
            x0 * x579 + x23 * x351 + x56 * x581 + x56 * (x56 * x582 + x581) + 0.5 * x580,
            x0 * x587 + x23 * x363 + x56 * x590 + x56 * (x56 * x591 + x590) + x589,
            x0 * x596 + x23 * x375 + x56 * x597 + x593,
            x0 * x601 + x23 * x382 + x56 * x602 + x599,
            x0 * x606 + x23 * x388 + x56 * x607 + x604,
            x0 * x611 + x23 * x392 + x56 * x612 + x609,
            x0 * x616 + x23 * x397 + x56 * x617 + x614,
            x0 * x619 + x191 * x597 + x20 * x566 + x23 * x400 + x377,
            x0 * x621 + x191 * x602 + x23 * x402 + x383 + x48 * x573,
            x0 * x623 + x191 * x607 + x23 * x404 + x389 + x580,
            x0 * x625 + x191 * x369 + x191 * x612 + x23 * x406 + x589,
            x0 * x627 + x191 * x617 + x23 * x408 + x398,
            x0 * x629 + x20 * x588 + x23 * x410 + x234 * x617,
            x0 * x652
            + x104 * x24
            + x2 * x649
            + x20
            * (
                -x16 * (x19 * (x658 - x666) + x2 * x637 + x6 * x672)
                + x19 * (-x16 * x658 + x56 * x660 + x653)
                + x2 * x643
                + x56 * x674
            )
            + x56
            * (
                x2 * x648
                + x48 * (-x672 + x674)
                + x56
                * (
                    x19 * (x665 - x671)
                    + x2 * x647
                    + x56 * (x56 * x676 + x56 * (x56 * x678 + x676) + x675)
                )
            ),
            x0 * x686
            + x183 * x24
            + x2 * x682
            + x48
            * (
                -x16 * (x177 * x668 + x6 * x692 + 0.5 * x689)
                + x177 * x661
                + x56 * x694
                + 0.5 * x687
            )
            + x56
            * (
                x19 * (-x692 + x694)
                + x2 * x681
                + x56 * (x177 * x676 + x56 * (x177 * x678 + x696) + 0.5 * x695)
            ),
            x0 * x712
            + x2 * x704
            + x222 * x24
            + x48
            * (-x16 * (x56 * x720 + x6 * x723 + x719) + x56 * x724 + x56 * x725 + x715)
            + x56
            * (
                x19 * (-x723 + x725)
                + x2 * x703
                + x56 * (x56 * x728 + x56 * (x56 * x729 + x728) + x727)
            ),
            x0 * x741
            + x19 * (-x16 * (x6 * x734 + x733) + x56 * x735 + x731)
            + x2 * x739
            + x24 * x262
            + x56 * (x32 * x742 + x56 * x743 + x56 * (x56 * x744 + x743)),
            x0 * x751
            + x19 * (-x16 * (x6 * x745 + x746) + x177 * x716 + x747)
            + x2 * x749
            + x24 * x288
            + x56 * (x177 * x728 + x56 * (x177 * x729 + x753) + 0.5 * x752),
            x0 * x767
            + x19 * (-x16 * (x6 * x759 + x757) + x56 * x760 + x755)
            + x2 * x765
            + x24 * x316
            + x56 * (x56 * x770 + x56 * (x56 * x771 + x770) + x769),
            x0 * x775 + x24 * x328 + x32 * x776 + x56 * x777 + x56 * (x56 * x778 + x777),
            x0 * x782 + x24 * x342 + x32 * x783 + x56 * x784 + x56 * (x56 * x785 + x784),
            x0 * x788
            + x177 * x770
            + x24 * x351
            + x56 * (x177 * x771 + x790)
            + 0.5 * x789,
            x0 * x795 + x24 * x363 + x56 * x798 + x56 * (x56 * x799 + x798) + x797,
            x0 * x804 + x24 * x375 + x56 * x805 + x801,
            x0 * x809 + x24 * x382 + x56 * x810 + x807,
            x0 * x814 + x24 * x388 + x56 * x815 + x812,
            x0 * x817 + x177 * x799 + x24 * x392 + x818,
            x0 * x822 + x24 * x397 + x56 * x823 + x820,
            x0 * x825 + x191 * x805 + x20 * x776 + x24 * x400,
            x0 * x827 + x191 * x810 + x24 * x402 + x48 * x783,
            x0 * x829 + x191 * x815 + x24 * x404 + x789,
            x0 * x831 + x239 * x799 + x24 * x406 + x797,
            x0 * x833 + x191 * x823 + x24 * x408,
            x0 * x835 + x20 * x796 + x234 * x823 + x24 * x410 + x398,
            x20
            * (
                -x16 * (x19 * (x15 * x3 * x6 * x838 - x263 * x842) + x6 * x846)
                + x19 * (x15 * x3 * x6 * x840 - x263 * x838)
                + x56 * x849
            )
            + x23 * x433
            + x23 * x434
            + x56
            * (
                x48 * (-x846 + x849)
                + x56
                * (
                    x19 * (x15 * x3 * x6 * x842 - x263 * x845)
                    + x56 * (x255 * x852 + x851)
                )
            ),
            x23 * x472
            + x23 * x473
            + x48 * (-x16 * (x255 * x860 + 0.5 * x858) + x255 * x856 + 0.5 * x854)
            + x56
            * (
                x19 * (x15 * x3 * x6 * x856 - x263 * x860)
                + x56 * (x255 * x864 + 0.5 * x862)
            ),
            x23 * x497
            + x23 * x498
            + x48 * (-x16 * (x490 * x845 + x868) + x490 * x842 + x866)
            + x56
            * (
                x19 * (x12 * x153 * x162 * x6 * x842 - x334 * x6 * x845)
                + x56 * (x490 * x852 + x870)
            ),
            x19 * (x15 * x3 * x6 * x872 - x263 * x871)
            + x23 * x522
            + x23 * x523
            + x56 * (x255 * x875 + x32 * x874),
            x19 * (x15 * x3 * x6 * x877 - x263 * x876)
            + x23 * x539
            + x23 * x540
            + x56 * (x255 * x880 + 0.5 * x879),
            x19 * (x15 * x3 * x6 * x882 - x263 * x881)
            + x23 * x556
            + x23 * x557
            + x56 * (x255 * x886 + x885),
            x23 * x564 + x23 * x565 + x255 * x888 + x32 * x887,
            x23 * x571 + x23 * x572 + x255 * x890 + x32 * x889,
            x23 * x578 + x23 * x579 + x255 * x892 + 0.5 * x891,
            x23 * x586 + x23 * x587 + x255 * x895 + x894,
            x23 * x594 + x23 * x596 + x56 * x896,
            x23 * x600 + x23 * x601 + x56 * x897,
            x23 * x605 + x23 * x606 + x56 * x898,
            x23 * x610 + x23 * x611 + x56 * x899,
            x23 * x615 + x23 * x616 + x56 * x900,
            x191 * x896 + x20 * x887 + x23 * x618 + x23 * x619 + 2.0 * x593,
            x191 * x897 + x23 * x620 + x23 * x621 + x48 * x889 + 2.0 * x599,
            x191 * x898 + x23 * x622 + x23 * x623 + 2.0 * x604 + x891,
            x191 * x899 + x23 * x624 + x23 * x625 + 2.0 * x609 + x894,
            x191 * x900 + x23 * x626 + x23 * x627 + 2.0 * x614,
            x20 * x893 + x23 * x628 + x23 * x629 + x234 * x900,
            x20
            * (
                -x16 * (x19 * (x15 * x3 * x6 * x902 - x263 * x906) + x6 * x910)
                + x19 * (x15 * x3 * x6 * x904 - x263 * x902)
                + x56 * x913
            )
            + x23 * x652
            + x24 * x433
            + x56
            * (
                x48 * (-x910 + x913)
                + x56
                * (
                    x19 * (x15 * x3 * x6 * x906 - x263 * x909)
                    + x56 * (x255 * x916 + x915)
                )
            ),
            x23 * x686
            + x24 * x472
            + x48 * (-x16 * (x255 * x922 + 0.5 * x921) + x255 * x919 + 0.5 * x918)
            + x56
            * (
                x19 * (x15 * x3 * x6 * x919 - x263 * x922)
                + x56 * (x255 * x925 + 0.5 * x924)
            ),
            x23 * x712
            + x24 * x497
            + x48 * (-x16 * (x255 * x933 + x932) + x255 * x929 + x928)
            + x56
            * (x19 * (x15 * x3 * x6 * x929 - x263 * x933) + x56 * (x255 * x937 + x936)),
            x19 * (x15 * x3 * x6 * x939 - x263 * x938)
            + x23 * x741
            + x24 * x522
            + x56 * (x255 * x942 + x32 * x941),
            x19 * (x15 * x3 * x6 * x944 - x263 * x943)
            + x23 * x751
            + x24 * x539
            + x56 * (x255 * x947 + 0.5 * x946),
            x19 * (x15 * x3 * x6 * x949 - x263 * x948)
            + x23 * x767
            + x24 * x556
            + x56 * (x255 * x953 + x952),
            x23 * x775 + x24 * x564 + x255 * x955 + x32 * x954,
            x23 * x782 + x24 * x571 + x255 * x957 + x32 * x956,
            x23 * x788 + x24 * x578 + x255 * x959 + 0.5 * x958,
            x23 * x795 + x24 * x586 + x255 * x962 + x961,
            x23 * x804 + x24 * x594 + x56 * x963,
            x23 * x809 + x24 * x600 + x56 * x964,
            x23 * x814 + x24 * x605 + x56 * x965,
            x23 * x817 + x24 * x610 + x56 * x966,
            x23 * x822 + x24 * x615 + x56 * x967,
            x191 * x963 + x20 * x954 + x23 * x825 + x24 * x618 + x801,
            x191 * x964 + x23 * x827 + x24 * x620 + x48 * x956 + x807,
            x191 * x965 + x23 * x829 + x24 * x622 + x812 + x958,
            x191 * x966 + x23 * x831 + x24 * x624 + x818 + x961,
            x191 * x967 + x23 * x833 + x24 * x626 + x820,
            x20 * x960 + x23 * x835 + x234 * x967 + x24 * x628 + x614,
            x20
            * (
                -x16 * (x19 * (x15 * x3 * x6 * x970 - x263 * x974) + x6 * x978)
                + x19 * (x15 * x3 * x6 * x972 - x263 * x970)
                + x56 * x981
            )
            + x24 * x651
            + x24 * x652
            + x56
            * (
                x48 * (-x978 + x981)
                + x56
                * (
                    x19 * (x15 * x3 * x6 * x974 - x263 * x977)
                    + x56 * (x255 * x984 + x983)
                )
            ),
            x24 * x685
            + x24 * x686
            + x48 * (-x16 * (x354 * x977 + 0.5 * x986) + x354 * x974 + 0.5 * x985)
            + x56
            * (
                x19 * (x153 * x162 * x6 * x9 * x974 - x679 * x977)
                + x56 * (x354 * x984 + 0.5 * x987)
            ),
            x24 * x711
            + x24 * x712
            + x48 * (-x16 * (x255 * x995 + x994) + x255 * x991 + x990)
            + x56
            * (x19 * (x15 * x3 * x6 * x991 - x263 * x995) + x56 * (x255 * x999 + x998)),
            x19 * (-x1000 * x263 + x1001 * x15 * x3 * x6)
            + x24 * x740
            + x24 * x741
            + x56 * (x1003 * x32 + x1004 * x255),
            x19 * (x153 * x162 * x6 * x9 * x991 - x679 * x995)
            + x24 * x750
            + x24 * x751
            + x56 * (0.5 * x1005 + x354 * x999),
            x19 * (-x1006 * x263 + x1007 * x15 * x3 * x6)
            + x24 * x766
            + x24 * x767
            + x56 * (x1010 + x1011 * x255),
            x1012 * x32 + x1013 * x255 + x24 * x774 + x24 * x775,
            x1014 * x32 + x1015 * x255 + x24 * x781 + x24 * x782,
            x1011 * x354 + 0.5 * x1016 + x24 * x787 + x24 * x788,
            x1018 + x1019 * x255 + x24 * x794 + x24 * x795,
            x1020 * x56 + x24 * x802 + x24 * x804,
            x1021 * x56 + x24 * x808 + x24 * x809,
            x1022 * x56 + x24 * x813 + x24 * x814,
            x1019 * x177 + x24 * x816 + x24 * x817,
            x1023 * x56 + x24 * x821 + x24 * x822,
            x1012 * x20 + x1020 * x191 + x24 * x824 + x24 * x825,
            x1014 * x48 + x1021 * x191 + x24 * x826 + x24 * x827,
            x1016 + x1022 * x191 + x24 * x828 + x24 * x829,
            x1018 + x1019 * x239 + x24 * x830 + x24 * x831,
            x1023 * x191 + x24 * x832 + x24 * x833,
            x1017 * x20 + x1023 * x234 + x24 * x834 + x24 * x835 + 2.0 * x820,
        ]
    )


def _3center2el3d_030(a, A, b, B, c, C):
    """Cartesian (sf|s) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = (2.0 * a + 2.0 * b) ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - C[0]
    x6 = -x3 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x3 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = c + x2
    x11 = c / x10
    x12 = x11 * x2 * (x5**2 + x7**2 + x9**2)
    x13 = boys(1, x12)
    x14 = 17.4934183276249
    x15 = A[1] - B[1]
    x16 = A[2] - B[2]
    x17 = numpy.exp(-a * b * x3 * (x0**2 + x15**2 + x16**2))
    x18 = 2.0 * x14 * x17 * x3
    x19 = x10 ** (-1.5) * x18
    x20 = x13 * x19
    x21 = c ** (-1.0)
    x22 = x10 ** (-0.5)
    x23 = boys(0, x12)
    x24 = x1 * (2.0 * x14 * x17 * x21 * x22 * x23 * x3 - x20)
    x25 = -x4 - A[0]
    x26 = x20 * x5
    x27 = -2.0 * x14 * x17 * x21 * x22 * x23 * x25 * x3 + x26
    x28 = -x27
    x29 = boys(2, x12)
    x30 = x19 * x29
    x31 = 2.0 * x13 * x14 * x17 * x21 * x22 * x25 * x3 - x30 * x5
    x32 = x11 * x31
    x33 = x24 + x25 * x28 - x32 * x5
    x34 = x0 * x28 + x33
    x35 = x18 * x21 * x22 * x23
    x36 = x1 * (2.0 * x13 * x14 * x17 * x21 * x22 * x3 - x30)
    x37 = x19 * boys(3, x12)
    x38 = x11 * x5
    x39 = -x6 - A[1]
    x40 = 2.0 * x13 * x14 * x17 * x21 * x22 * x3 * x39 - x30 * x7
    x41 = x11 * x40
    x42 = x20 * x7
    x43 = -2.0 * x14 * x17 * x21 * x22 * x23 * x3 * x39 + x42
    x44 = x1 * (-x41 - x43)
    x45 = -x43
    x46 = x41 * x5
    x47 = x15 * x28 + x25 * x45 - x46
    x48 = x15 * x35 + x35 * x39 - x42
    x49 = x25 * x45 - x46
    x50 = 2.0 * x14 * x17 * x21 * x22 * x29 * x3 * x39 - x37 * x7
    x51 = -x8 - A[2]
    x52 = 2.0 * x13 * x14 * x17 * x21 * x22 * x3 * x51 - x30 * x9
    x53 = x11 * x52
    x54 = x20 * x9
    x55 = -2.0 * x14 * x17 * x21 * x22 * x23 * x3 * x51 + x54
    x56 = x1 * (-x53 - x55)
    x57 = -x55
    x58 = x5 * x53
    x59 = x16 * x28 + x25 * x57 - x58
    x60 = x16 * x35 + x35 * x51 - x54
    x61 = x25 * x57 - x58
    x62 = 2.0 * x14 * x17 * x21 * x22 * x29 * x3 * x51 - x37 * x9
    x63 = x24 + x39 * x45 - x41 * x7
    x64 = x15 * x45 + x63
    x65 = x15 * x48 + x64
    x66 = x11 * x7
    x67 = x36 + x39 * x40 - x50 * x66
    x68 = x53 * x7
    x69 = x16 * x45 + x39 * x57 - x68
    x70 = x15 * x60 + x69
    x71 = x39 * x57 - x68
    x72 = x39 * x52 - x62 * x66
    x73 = x24 + x51 * x57 - x53 * x9
    x74 = x16 * x57 + x73
    x75 = x16 * x60 + x74
    x76 = x11 * x9
    x77 = x36 + x51 * x52 - x62 * x76

    # 10 item(s)
    return numpy.array(
        [
            x0 * x33
            + x0 * x34
            + x0 * (x0 * (x0 * x35 + x25 * x35 - x26) + x34)
            + 2.0 * x1 * (-x27 - x32)
            + x25 * x33
            - x38
            * (
                x25 * x31
                + x36
                - x38 * (2.0 * x14 * x17 * x21 * x22 * x25 * x29 * x3 - x37 * x5)
            ),
            x0 * x47
            + x0 * (x0 * x48 + x47)
            + x15 * x33
            + x25 * x49
            - x38 * (x25 * x40 - x38 * x50)
            + x44,
            x0 * x59
            + x0 * (x0 * x60 + x59)
            + x16 * x33
            + x25 * x61
            - x38 * (x25 * x52 - x38 * x62)
            + x56,
            x0 * x65 + x15 * x47 + x15 * x49 + x25 * x63 - x38 * x67,
            x0 * x70 + x15 * x59 + x16 * x49 + x25 * x71 - x38 * x72,
            x0 * x75 + x16 * x59 + x16 * x61 + x25 * x73 - x38 * x77,
            x15 * x63 + x15 * x64 + x15 * x65 + x39 * x63 + 2.0 * x44 - x66 * x67,
            x15 * x69 + x15 * x70 + x16 * x63 + x39 * x71 + x56 - x66 * x72,
            x15 * x75 + x16 * x69 + x16 * x71 + x39 * x73 - x66 * x77,
            x16 * x73 + x16 * x74 + x16 * x75 + x51 * x73 + 2.0 * x56 - x76 * x77,
        ]
    )


def _3center2el3d_031(a, A, b, B, c, C):
    """Cartesian (sf|p) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = a + b
    x4 = x3 ** (-1.0)
    x5 = -x4 * (a * A[0] + b * B[0])
    x6 = -x5 - C[0]
    x7 = -x4 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x4 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = c + x3
    x12 = x11 ** (-1.0)
    x13 = c * x12
    x14 = x13 * x3 * (x10**2 + x6**2 + x8**2)
    x15 = boys(2, x14)
    x16 = x11 ** (-1.5)
    x17 = 17.4934183276249
    x18 = A[1] - B[1]
    x19 = A[2] - B[2]
    x20 = numpy.exp(-a * b * x4 * (x0**2 + x18**2 + x19**2))
    x21 = 2.0 * x17 * x20 * x4
    x22 = x16 * x21
    x23 = x15 * x22
    x24 = c ** (-1.0)
    x25 = x11 ** (-0.5)
    x26 = -x5 - A[0]
    x27 = boys(1, x14)
    x28 = -2.0 * x17 * x20 * x24 * x25 * x26 * x27 * x4 + x23 * x6
    x29 = -x28
    x30 = x2 * x29
    x31 = x1 ** (-1.0)
    x32 = x31 * (2.0 * x17 * x20 * x24 * x25 * x27 * x4 - x23)
    x33 = boys(3, x14)
    x34 = x22 * x33
    x35 = 2.0 * x15 * x17 * x20 * x24 * x25 * x26 * x4 - x34 * x6
    x36 = x13 * x35
    x37 = x26 * x29 + x32 - x36 * x6
    x38 = x12 * x3
    x39 = x38 * x6
    x40 = 2.0 * x30 + x37 * x39
    x41 = x24 * x27
    x42 = x2 * x21 * x25 * x41
    x43 = x29 * x39 + x42
    x44 = x0 * x43 + x40
    x45 = 2.0 * x16 * x17 * x20 * x41
    x46 = x0 * x45
    x47 = x2 * x37
    x48 = x31 * (2.0 * x15 * x17 * x20 * x24 * x25 * x4 - x34)
    x49 = x22 * boys(4, x14)
    x50 = x13 * x6
    x51 = (
        x26 * x37
        + 2.0 * x31 * (-x28 - x36)
        - x50
        * (
            x26 * x35
            + x48
            - x50 * (2.0 * x17 * x20 * x24 * x25 * x26 * x33 * x4 - x49 * x6)
        )
    )
    x52 = x38 * x8
    x53 = x37 * x52
    x54 = x29 * x52
    x55 = x0 * x54 + x53
    x56 = x10 * x38
    x57 = x37 * x56
    x58 = x29 * x56
    x59 = x0 * x58 + x57
    x60 = -x7 - A[1]
    x61 = -2.0 * x17 * x20 * x24 * x25 * x27 * x4 * x60 + x23 * x8
    x62 = -x61
    x63 = x2 * x62
    x64 = 2.0 * x15 * x17 * x20 * x24 * x25 * x4 * x60 - x34 * x8
    x65 = x13 * x64
    x66 = x26 * x62 - x6 * x65
    x67 = x39 * x66 + x63
    x68 = x18 * x43 + x67
    x69 = x39 * x62
    x70 = x18 * x45
    x71 = x6 * x70 + x69
    x72 = x2 * x66
    x73 = 2.0 * x72
    x74 = x31 * (-x61 - x65)
    x75 = 2.0 * x17 * x20 * x24 * x25 * x33 * x4 * x60 - x49 * x8
    x76 = x26 * x66 - x50 * (x26 * x64 - x50 * x75) + x74
    x77 = x30 + x52 * x66
    x78 = x18 * x54 + x77
    x79 = x42 + x52 * x62
    x80 = x70 * x8 + x79
    x81 = x56 * x66
    x82 = x18 * x58 + x81
    x83 = x56 * x62
    x84 = x10 * x70 + x83
    x85 = -x9 - A[2]
    x86 = x10 * x23 - 2.0 * x17 * x20 * x24 * x25 * x27 * x4 * x85
    x87 = -x86
    x88 = x2 * x87
    x89 = -x10 * x34 + 2.0 * x15 * x17 * x20 * x24 * x25 * x4 * x85
    x90 = x13 * x89
    x91 = x26 * x87 - x6 * x90
    x92 = x39 * x91 + x88
    x93 = x19 * x43 + x92
    x94 = x39 * x87
    x95 = x19 * x45
    x96 = x6 * x95 + x94
    x97 = x2 * x91
    x98 = 2.0 * x97
    x99 = x31 * (-x86 - x90)
    x100 = -x10 * x49 + 2.0 * x17 * x20 * x24 * x25 * x33 * x4 * x85
    x101 = x26 * x91 - x50 * (-x100 * x50 + x26 * x89) + x99
    x102 = x52 * x91
    x103 = x102 + x19 * x54
    x104 = x52 * x87
    x105 = x104 + x8 * x95
    x106 = x30 + x56 * x91
    x107 = x106 + x19 * x58
    x108 = x42 + x56 * x87
    x109 = x10 * x95 + x108
    x110 = x32 + x60 * x62 - x65 * x8
    x111 = x110 * x2
    x112 = x110 * x39
    x113 = x112 + x18 * x69
    x114 = x113 + x18 * x71
    x115 = x13 * x8
    x116 = -x115 * x75 + x48 + x60 * x64
    x117 = x110 * x26 - x116 * x50
    x118 = x110 * x52 + 2.0 * x63
    x119 = x118 + x18 * x79
    x120 = x119 + x18 * x80
    x121 = x110 * x56
    x122 = x121 + x18 * x83
    x123 = x122 + x18 * x84
    x124 = x60 * x87 - x8 * x90
    x125 = x124 * x2
    x126 = x124 * x39
    x127 = x126 + x19 * x69
    x128 = x127 + x18 * x96
    x129 = -x100 * x115 + x60 * x89
    x130 = x124 * x26 - x129 * x50
    x131 = x124 * x52 + x88
    x132 = x131 + x19 * x79
    x133 = x105 * x18 + x132
    x134 = x124 * x56 + x63
    x135 = x134 + x19 * x83
    x136 = x109 * x18 + x135
    x137 = -x10 * x90 + x32 + x85 * x87
    x138 = x137 * x2
    x139 = x137 * x39
    x140 = x139 + x19 * x94
    x141 = x140 + x19 * x96
    x142 = x10 * x13
    x143 = -x100 * x142 + x48 + x85 * x89
    x144 = x137 * x26 - x143 * x50
    x145 = x137 * x52
    x146 = x104 * x19 + x145
    x147 = x105 * x19 + x146
    x148 = x137 * x56 + 2.0 * x88
    x149 = x108 * x19 + x148
    x150 = x109 * x19 + x149
    x151 = x110 * x60 - x115 * x116 + 2.0 * x74
    x152 = -x115 * x129 + x124 * x60 + x99
    x153 = 2.0 * x125
    x154 = -x115 * x143 + x137 * x60
    x155 = x137 * x85 - x142 * x143 + 2.0 * x99

    # 30 item(s)
    return numpy.array(
        [
            x0 * x40
            + x0 * x44
            + x0 * (x0 * (x43 + x46 * x6) + x44)
            + x39 * x51
            + 3.0 * x47,
            x0 * x53 + x0 * x55 + x0 * (x0 * (x46 * x8 + x54) + x55) + x51 * x52,
            x0 * x57 + x0 * x59 + x0 * (x0 * (x10 * x46 + x58) + x59) + x51 * x56,
            x0 * x68 + x0 * (x0 * x71 + x68) + x18 * x40 + x39 * x76 + x73,
            x0 * x78 + x0 * (x0 * x80 + x78) + x18 * x53 + x47 + x52 * x76,
            x0 * x82 + x0 * (x0 * x84 + x82) + x18 * x57 + x56 * x76,
            x0 * x93 + x0 * (x0 * x96 + x93) + x101 * x39 + x19 * x40 + x98,
            x0 * x103 + x0 * (x0 * x105 + x103) + x101 * x52 + x19 * x53,
            x0 * x107 + x0 * (x0 * x109 + x107) + x101 * x56 + x19 * x57 + x47,
            x0 * x114 + x111 + x117 * x39 + x18 * x67 + x18 * x68,
            x0 * x120 + x117 * x52 + x18 * x77 + x18 * x78 + x73,
            x0 * x123 + x117 * x56 + x18 * x81 + x18 * x82,
            x0 * x128 + x125 + x130 * x39 + x18 * x93 + x19 * x67,
            x0 * x133 + x103 * x18 + x130 * x52 + x19 * x77 + x97,
            x0 * x136 + x107 * x18 + x130 * x56 + x19 * x81 + x72,
            x0 * x141 + x138 + x144 * x39 + x19 * x92 + x19 * x93,
            x0 * x147 + x102 * x19 + x103 * x19 + x144 * x52,
            x0 * x150 + x106 * x19 + x107 * x19 + x144 * x56 + x98,
            x112 * x18 + x113 * x18 + x114 * x18 + x151 * x39,
            3.0 * x111 + x118 * x18 + x119 * x18 + x120 * x18 + x151 * x52,
            x121 * x18 + x122 * x18 + x123 * x18 + x151 * x56,
            x112 * x19 + x127 * x18 + x128 * x18 + x152 * x39,
            x118 * x19 + x132 * x18 + x133 * x18 + x152 * x52 + x153,
            x111 + x121 * x19 + x135 * x18 + x136 * x18 + x152 * x56,
            x126 * x19 + x127 * x19 + x141 * x18 + x154 * x39,
            x131 * x19 + x132 * x19 + x138 + x147 * x18 + x154 * x52,
            x134 * x19 + x135 * x19 + x150 * x18 + x153 + x154 * x56,
            x139 * x19 + x140 * x19 + x141 * x19 + x155 * x39,
            x145 * x19 + x146 * x19 + x147 * x19 + x155 * x52,
            3.0 * x138 + x148 * x19 + x149 * x19 + x150 * x19 + x155 * x56,
        ]
    )


def _3center2el3d_032(a, A, b, B, c, C):
    """Cartesian (sf|d) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = 2.0 * a + 2.0 * b
    x2 = x1 ** (-1.0)
    x3 = a + b
    x4 = x3 ** (-1.0)
    x5 = -x4 * (a * A[0] + b * B[0])
    x6 = -x5 - C[0]
    x7 = x6**2
    x8 = -x4 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x4 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x3
    x15 = x14 ** (-1.0)
    x16 = x15 * x3
    x17 = c * x16 * (x10 + x13 + x7)
    x18 = boys(1, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x4 * (x0**2 + x21**2 + x22**2))
    x24 = x20 * x23 * x4
    x25 = 2.0 * x19 * x24
    x26 = x18 * x25
    x27 = c ** (-1.0)
    x28 = x14 ** (-0.5)
    x29 = boys(0, x17)
    x30 = -2.0 * x20 * x23 * x27 * x28 * x29 * x4
    x31 = -x26 - x30
    x32 = -x2 * x31
    x33 = -x5 - A[0]
    x34 = -2.0 * x20 * x23 * x27 * x28 * x29 * x33 * x4 + x26 * x6
    x35 = -x34
    x36 = boys(2, x17)
    x37 = x25 * x36
    x38 = x2 * (2.0 * x18 * x20 * x23 * x27 * x28 * x4 - x37)
    x39 = -2.0 * x18 * x20 * x23 * x27 * x28 * x33 * x4 + x37 * x6
    x40 = -x39
    x41 = boys(3, x17)
    x42 = x25 * x41
    x43 = -2.0 * x20 * x23 * x27 * x28 * x33 * x36 * x4 + x42 * x6
    x44 = -x43
    x45 = c * x15
    x46 = x44 * x45
    x47 = x33 * x40 + x38 - x46 * x6
    x48 = x40 * x45
    x49 = x48 * x6
    x50 = 0.5 * x27
    x51 = x50 * (-x16 * x47 - x32 + x33 * x35 - x49)
    x52 = x16 * x6
    x53 = (2.0 * c + x1) ** (-1.0)
    x54 = 2.0 * x53
    x55 = x27 * x36
    x56 = x54 * x55
    x57 = x24 * x28 * x56
    x58 = x44 * x52 + x57
    x59 = x44 * x53
    x60 = 2.0 * x59
    x61 = x2 * (2.0 * x20 * x23 * x27 * x28 * x36 * x4 - x42)
    x62 = boys(4, x17)
    x63 = x25 * x62
    x64 = 2.0 * x20 * x23 * x27 * x28 * x33 * x4 * x41 - x6 * x63
    x65 = x45 * x64
    x66 = x33 * x44 - x6 * x65 + x61
    x67 = x52 * x66 + x60
    x68 = x51 + x52 * x67 + x54 * x58
    x69 = x50 * (-x16 * x40 - x34)
    x70 = x19 * x20 * x23
    x71 = x56 * x70
    x72 = x52 * x58 + x6 * x71 + x69
    x73 = x0 * x72 + x68
    x74 = x50 * (-2.0 * x18 * x27 * x70 - x30)
    x75 = 2.0 * x14 ** (-2.5) * x20 * x23 * x3 * x55
    x76 = x7 * x75 + x74
    x77 = x2 * x31
    x78 = 2.0 * x2
    x79 = x45 * x6
    x80 = x50 * (
        -x16 * (x33 * x47 - x66 * x79 + x78 * (-x39 - x46))
        + 2.0 * x2 * (-x34 - x48)
        + x33 * (x33 * x35 - x49 + x77)
        - x47 * x79
    )
    x81 = x53 * x66
    x82 = 3.0 * x81
    x83 = x2 * (2.0 * x20 * x23 * x27 * x28 * x4 * x41 - x63)
    x84 = x25 * boys(5, x17)
    x85 = (
        x33 * x66
        + x78 * (-x43 - x65)
        - x79
        * (
            x33 * x64
            - x79 * (2.0 * x20 * x23 * x27 * x28 * x33 * x4 * x62 - x6 * x84)
            + x83
        )
    )
    x86 = x3**2 / x14**2
    x87 = x6 * x86
    x88 = x87 * x9
    x89 = x16 * x9
    x90 = x60 * x89 + x66 * x88
    x91 = x71 * x9
    x92 = x44 * x88 + x91
    x93 = x0 * x92 + x90
    x94 = x0 * x75
    x95 = x6 * x94
    x96 = x12 * x87
    x97 = x12 * x16
    x98 = x60 * x97 + x66 * x96
    x99 = x12 * x71
    x100 = x44 * x96 + x99
    x101 = x0 * x100 + x98
    x102 = x10 * x86
    x103 = x102 * x66 + x51
    x104 = x102 * x44 + x69
    x105 = x0 * x104 + x103
    x106 = x10 * x75 + x74
    x107 = x12 * x9
    x108 = x107 * x86
    x109 = x108 * x66
    x110 = x108 * x44
    x111 = x0 * x110 + x109
    x112 = x13 * x86
    x113 = x112 * x66 + x51
    x114 = x112 * x44 + x69
    x115 = x0 * x114 + x113
    x116 = x13 * x75 + x74
    x117 = -x8 - A[1]
    x118 = -2.0 * x117 * x18 * x20 * x23 * x27 * x28 * x4 + x37 * x9
    x119 = -x118
    x120 = -2.0 * x117 * x20 * x23 * x27 * x28 * x36 * x4 + x42 * x9
    x121 = -x120
    x122 = x121 * x45
    x123 = x119 * x33 - x122 * x6
    x124 = -2.0 * x117 * x20 * x23 * x27 * x28 * x29 * x4 + x26 * x9
    x125 = -x124
    x126 = x119 * x45
    x127 = -x125 * x33 + x126 * x6
    x128 = x50 * (-x123 * x16 - x127)
    x129 = x121 * x53
    x130 = 2.0 * x117 * x20 * x23 * x27 * x28 * x4 * x41 - x63 * x9
    x131 = x130 * x45
    x132 = x121 * x33 - x131 * x6
    x133 = x129 + x132 * x52
    x134 = x128 + x129 * x52 + x133 * x52
    x135 = x134 + x21 * x72
    x136 = x50 * (-x119 * x16 - x124)
    x137 = x7 * x86
    x138 = x121 * x137 + x136
    x139 = x138 + x21 * x76
    x140 = -x124 - x126
    x141 = x2 * (-x118 - x122)
    x142 = x50 * (
        -x123 * x79 - x127 * x33 + x140 * x2 - x16 * (x123 * x33 - x132 * x79 + x141)
    )
    x143 = x132 * x53
    x144 = 2.0 * x143
    x145 = x2 * (-x120 - x131)
    x146 = 2.0 * x117 * x20 * x23 * x27 * x28 * x4 * x62 - x84 * x9
    x147 = x132 * x33 + x145 - x79 * (x130 * x33 - x146 * x79)
    x148 = x121 * x89 + x57
    x149 = x148 * x53
    x150 = x132 * x89 + x59
    x151 = x149 + x150 * x52
    x152 = x151 + x21 * x92
    x153 = x148 * x52
    x154 = x21 * x75
    x155 = x154 * x6
    x156 = x153 + x155 * x9
    x157 = x150 * x54
    x158 = x147 * x89 + x81
    x159 = x129 * x97
    x160 = x132 * x96 + x159
    x161 = x100 * x21 + x160
    x162 = x121 * x96
    x163 = x12 * x155 + x162
    x164 = x144 * x97
    x165 = x128 + x150 * x89 + x59 * x89
    x166 = x104 * x21 + x165
    x167 = x136 + x148 * x89 + x91
    x168 = x106 * x21 + x167
    x169 = x59 * x97
    x170 = x108 * x132 + x169
    x171 = x110 * x21 + x170
    x172 = x108 * x121 + x99
    x173 = x107 * x154 + x172
    x174 = x81 * x97
    x175 = x112 * x132 + x128
    x176 = x114 * x21 + x175
    x177 = x112 * x121 + x136
    x178 = x116 * x21 + x177
    x179 = -x11 - A[2]
    x180 = x12 * x37 - 2.0 * x179 * x18 * x20 * x23 * x27 * x28 * x4
    x181 = -x180
    x182 = x12 * x42 - 2.0 * x179 * x20 * x23 * x27 * x28 * x36 * x4
    x183 = -x182
    x184 = x183 * x45
    x185 = x181 * x33 - x184 * x6
    x186 = x12 * x26 - 2.0 * x179 * x20 * x23 * x27 * x28 * x29 * x4
    x187 = -x186
    x188 = x181 * x45
    x189 = -x187 * x33 + x188 * x6
    x190 = x50 * (-x16 * x185 - x189)
    x191 = x183 * x53
    x192 = -x12 * x63 + 2.0 * x179 * x20 * x23 * x27 * x28 * x4 * x41
    x193 = x192 * x45
    x194 = x183 * x33 - x193 * x6
    x195 = x191 + x194 * x52
    x196 = x190 + x191 * x52 + x195 * x52
    x197 = x196 + x22 * x72
    x198 = x50 * (-x16 * x181 - x186)
    x199 = x137 * x183 + x198
    x200 = x199 + x22 * x76
    x201 = -x186 - x188
    x202 = -x2 * x201
    x203 = x2 * (-x180 - x184)
    x204 = x50 * (
        -x16 * (x185 * x33 - x194 * x79 + x203) - x185 * x79 - x189 * x33 - x202
    )
    x205 = x194 * x53
    x206 = 2.0 * x205
    x207 = x2 * (-x182 - x193)
    x208 = -x12 * x84 + 2.0 * x179 * x20 * x23 * x27 * x28 * x4 * x62
    x209 = x194 * x33 + x207 - x79 * (x192 * x33 - x208 * x79)
    x210 = x191 * x89
    x211 = x194 * x88 + x210
    x212 = x211 + x22 * x92
    x213 = x183 * x88
    x214 = x22 * x75
    x215 = x214 * x6
    x216 = x213 + x215 * x9
    x217 = x183 * x97 + x57
    x218 = x217 * x53
    x219 = x194 * x97 + x59
    x220 = x218 + x219 * x52
    x221 = x100 * x22 + x220
    x222 = x217 * x52
    x223 = x12 * x215 + x222
    x224 = x219 * x53
    x225 = 2.0 * x224
    x226 = x209 * x97 + x81
    x227 = x102 * x194 + x190
    x228 = x104 * x22 + x227
    x229 = x102 * x183 + x198
    x230 = x106 * x22 + x229
    x231 = x219 * x89
    x232 = x110 * x22 + x231
    x233 = x217 * x89
    x234 = x107 * x214 + x233
    x235 = x169 + x190 + x219 * x97
    x236 = x114 * x22 + x235
    x237 = x198 + x217 * x97 + x99
    x238 = x116 * x22 + x237
    x239 = x117 * x119 - x122 * x9 + x38
    x240 = x126 * x9
    x241 = x50 * (x117 * x125 - x16 * x239 - x240 - x32)
    x242 = x117 * x121 - x131 * x9 + x61
    x243 = x137 * x242 + x241
    x244 = x138 * x21 + x243
    x245 = x139 * x21 + x244
    x246 = x117 * x125 - x240 + x77
    x247 = x50 * (-x16 * (x239 * x33 - x242 * x79) - x239 * x79 + x246 * x33)
    x248 = x242 * x53
    x249 = x45 * x9
    x250 = x117 * x130 - x146 * x249 + x83
    x251 = x242 * x33 - x250 * x79
    x252 = 2.0 * x129
    x253 = x242 * x89 + x252
    x254 = x253 * x53
    x255 = x253 * x52
    x256 = x153 * x21 + x255
    x257 = x156 * x21 + x256
    x258 = x144 + x251 * x89
    x259 = x242 * x96
    x260 = x162 * x21 + x259
    x261 = x163 * x21 + x260
    x262 = x248 * x97
    x263 = 2.0 * x149 + x241 + x253 * x89
    x264 = x167 * x21 + x263
    x265 = x168 * x21 + x264
    x266 = x108 * x242 + x252 * x97
    x267 = x172 * x21 + x266
    x268 = x173 * x21 + x267
    x269 = x112 * x242 + x241
    x270 = x177 * x21 + x269
    x271 = x178 * x21 + x270
    x272 = x117 * x181 - x184 * x9
    x273 = -x117 * x187 + x188 * x9
    x274 = x50 * (-x16 * x272 - x273)
    x275 = x117 * x183 - x193 * x9
    x276 = x137 * x275 + x274
    x277 = x138 * x22 + x276
    x278 = x200 * x21 + x277
    x279 = -x273
    x280 = x50 * (-x16 * (x272 * x33 - x275 * x79) - x272 * x79 + x279 * x33)
    x281 = x275 * x53
    x282 = x117 * x192 - x208 * x249
    x283 = x275 * x33 - x282 * x79
    x284 = x191 + x275 * x89
    x285 = x284 * x53
    x286 = x284 * x52
    x287 = x153 * x22 + x286
    x288 = x21 * x216 + x287
    x289 = x205 + x283 * x89
    x290 = x129 + x275 * x97
    x291 = x290 * x53
    x292 = x290 * x52
    x293 = x162 * x22 + x292
    x294 = x21 * x223 + x293
    x295 = x143 + x283 * x97
    x296 = x210 + x274 + x284 * x89
    x297 = x167 * x22 + x296
    x298 = x21 * x230 + x297
    x299 = x218 + x290 * x89
    x300 = x172 * x22 + x299
    x301 = x21 * x234 + x300
    x302 = x159 + x274 + x290 * x97
    x303 = x177 * x22 + x302
    x304 = x21 * x238 + x303
    x305 = -x12 * x184 + x179 * x181 + x38
    x306 = x12 * x188
    x307 = x50 * (-x16 * x305 + x179 * x187 - x306 - x32)
    x308 = -x12 * x193 + x179 * x183 + x61
    x309 = x137 * x308 + x307
    x310 = x199 * x22 + x309
    x311 = x200 * x22 + x310
    x312 = x179 * x187 - x306 + x77
    x313 = x50 * (-x16 * (x305 * x33 - x308 * x79) - x305 * x79 + x312 * x33)
    x314 = x308 * x53
    x315 = x12 * x45
    x316 = x179 * x192 - x208 * x315 + x83
    x317 = x308 * x33 - x316 * x79
    x318 = x308 * x88
    x319 = x213 * x22 + x318
    x320 = x216 * x22 + x319
    x321 = x314 * x89
    x322 = 2.0 * x191 + x308 * x97
    x323 = x322 * x53
    x324 = x322 * x52
    x325 = x22 * x222 + x324
    x326 = x22 * x223 + x325
    x327 = x206 + x317 * x97
    x328 = x102 * x308 + x307
    x329 = x22 * x229 + x328
    x330 = x22 * x230 + x329
    x331 = x322 * x89
    x332 = x22 * x233 + x331
    x333 = x22 * x234 + x332
    x334 = 2.0 * x218 + x307 + x322 * x97
    x335 = x22 * x237 + x334
    x336 = x22 * x238 + x335
    x337 = x50 * (
        x117 * x246
        + 2.0 * x140 * x2
        - x16 * (x117 * x239 + 2.0 * x141 - x242 * x249)
        - x239 * x249
    )
    x338 = x117 * x242 + 2.0 * x145 - x249 * x250
    x339 = 3.0 * x248
    x340 = x338 * x89 + x339
    x341 = x50 * (
        x117 * x279 - x16 * (x117 * x272 + x203 - x249 * x275) - x202 - x249 * x272
    )
    x342 = x117 * x275 + x207 - x249 * x282
    x343 = 2.0 * x281
    x344 = x342 * x89 + x343
    x345 = x248 + x342 * x97
    x346 = 2.0 * x291
    x347 = x50 * (x117 * x312 - x16 * (x117 * x305 - x249 * x308) - x249 * x305)
    x348 = x117 * x308 - x249 * x316
    x349 = x314 + x348 * x89
    x350 = x343 + x348 * x97
    x351 = x50 * (
        -x16 * (x179 * x305 + 2.0 * x203 - x308 * x315)
        + x179 * x312
        + 2.0 * x2 * x201
        - x305 * x315
    )
    x352 = x179 * x308 + 2.0 * x207 - x315 * x316
    x353 = 3.0 * x314 + x352 * x97

    # 60 item(s)
    return numpy.array(
        [
            x0 * x68
            + x0 * x73
            + x0 * (x0 * (x0 * x76 + x72) + x73)
            + x52 * (x52 * x85 + x82)
            + 3.0 * x53 * x67
            + x80,
            x0 * x90
            + x0 * x93
            + x0 * (x0 * (x9 * x95 + x92) + x93)
            + x82 * x89
            + x85 * x88,
            x0 * x101
            + x0 * x98
            + x0 * (x0 * (x100 + x12 * x95) + x101)
            + x82 * x97
            + x85 * x96,
            x0 * x103
            + x0 * x105
            + x0 * (x0 * (x0 * x106 + x104) + x105)
            + x102 * x85
            + x80,
            x0 * x109 + x0 * x111 + x0 * (x0 * (x107 * x94 + x110) + x111) + x108 * x85,
            x0 * x113
            + x0 * x115
            + x0 * (x0 * (x0 * x116 + x114) + x115)
            + x112 * x85
            + x80,
            x0 * x135
            + x0 * (x0 * x139 + x135)
            + x133 * x54
            + x142
            + x21 * x68
            + x52 * (x144 + x147 * x52),
            x0 * x152 + x0 * (x0 * x156 + x152) + x157 + x158 * x52 + x21 * x90,
            x0 * x161 + x0 * (x0 * x163 + x161) + x147 * x96 + x164 + x21 * x98,
            x0 * x166
            + x0 * (x0 * x168 + x166)
            + x103 * x21
            + x142
            + x158 * x89
            + x81 * x89,
            x0 * x171 + x0 * (x0 * x173 + x171) + x108 * x147 + x109 * x21 + x174,
            x0 * x176 + x0 * (x0 * x178 + x176) + x112 * x147 + x113 * x21 + x142,
            x0 * x197
            + x0 * (x0 * x200 + x197)
            + x195 * x54
            + x204
            + x22 * x68
            + x52 * (x206 + x209 * x52),
            x0 * x212 + x0 * (x0 * x216 + x212) + x206 * x89 + x209 * x88 + x22 * x90,
            x0 * x221 + x0 * (x0 * x223 + x221) + x22 * x98 + x225 + x226 * x52,
            x0 * x228 + x0 * (x0 * x230 + x228) + x102 * x209 + x103 * x22 + x204,
            x0 * x232 + x0 * (x0 * x234 + x232) + x109 * x22 + x226 * x89,
            x0 * x236 + x0 * (x0 * x238 + x236) + x113 * x22 + x174 + x204 + x226 * x97,
            x0 * x245
            + x134 * x21
            + x135 * x21
            + x247
            + x248 * x52
            + x52 * (x248 + x251 * x52),
            x0 * x257 + x151 * x21 + x152 * x21 + x254 + x258 * x52,
            x0 * x261 + x160 * x21 + x161 * x21 + x251 * x96 + x262,
            x0 * x265 + x157 + x165 * x21 + x166 * x21 + x247 + x258 * x89,
            x0 * x268 + x108 * x251 + x164 + x170 * x21 + x171 * x21,
            x0 * x271 + x112 * x251 + x175 * x21 + x176 * x21 + x247,
            x0 * x278
            + x134 * x22
            + x197 * x21
            + x280
            + x281 * x52
            + x52 * (x281 + x283 * x52),
            x0 * x288 + x151 * x22 + x21 * x212 + x285 + x289 * x52,
            x0 * x294 + x160 * x22 + x21 * x221 + x291 + x295 * x52,
            x0 * x298 + x165 * x22 + x205 * x89 + x21 * x228 + x280 + x289 * x89,
            x0 * x301 + x170 * x22 + x21 * x232 + x224 + x295 * x89,
            x0 * x304 + x143 * x97 + x175 * x22 + x21 * x236 + x280 + x295 * x97,
            x0 * x311
            + x196 * x22
            + x197 * x22
            + x313
            + x314 * x52
            + x52 * (x314 + x317 * x52),
            x0 * x320 + x211 * x22 + x212 * x22 + x317 * x88 + x321,
            x0 * x326 + x22 * x220 + x22 * x221 + x323 + x327 * x52,
            x0 * x330 + x102 * x317 + x22 * x227 + x22 * x228 + x313,
            x0 * x333 + x22 * x231 + x22 * x232 + x327 * x89,
            x0 * x336 + x22 * x235 + x22 * x236 + x225 + x313 + x327 * x97,
            x137 * x338 + x21 * x243 + x21 * x244 + x21 * x245 + x337,
            x21 * x255 + x21 * x256 + x21 * x257 + x340 * x52,
            x21 * x259 + x21 * x260 + x21 * x261 + x338 * x96,
            x21 * x263 + x21 * x264 + x21 * x265 + 3.0 * x254 + x337 + x340 * x89,
            x108 * x338 + x21 * x266 + x21 * x267 + x21 * x268 + x339 * x97,
            x112 * x338 + x21 * x269 + x21 * x270 + x21 * x271 + x337,
            x137 * x342 + x21 * x277 + x21 * x278 + x22 * x243 + x341,
            x21 * x287 + x21 * x288 + x22 * x255 + x344 * x52,
            x21 * x293 + x21 * x294 + x22 * x259 + x345 * x52,
            x21 * x297 + x21 * x298 + x22 * x263 + 2.0 * x285 + x341 + x344 * x89,
            x21 * x300 + x21 * x301 + x22 * x266 + x345 * x89 + x346,
            x21 * x303 + x21 * x304 + x22 * x269 + x262 + x341 + x345 * x97,
            x137 * x348 + x21 * x311 + x22 * x276 + x22 * x277 + x347,
            x21 * x320 + x22 * x286 + x22 * x287 + x349 * x52,
            x21 * x326 + x22 * x292 + x22 * x293 + x350 * x52,
            x21 * x330 + x22 * x296 + x22 * x297 + x321 + x347 + x349 * x89,
            x21 * x333 + x22 * x299 + x22 * x300 + x323 + x350 * x89,
            x21 * x336 + x22 * x302 + x22 * x303 + x346 + x347 + x350 * x97,
            x137 * x352 + x22 * x309 + x22 * x310 + x22 * x311 + x351,
            x22 * x318 + x22 * x319 + x22 * x320 + x352 * x88,
            x22 * x324 + x22 * x325 + x22 * x326 + x353 * x52,
            x102 * x352 + x22 * x328 + x22 * x329 + x22 * x330 + x351,
            x22 * x331 + x22 * x332 + x22 * x333 + x353 * x89,
            x22 * x334 + x22 * x335 + x22 * x336 + 3.0 * x323 + x351 + x353 * x97,
        ]
    )


def _3center2el3d_033(a, A, b, B, c, C):
    """Cartesian (sf|f) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = x1 ** (-1.0)
    x4 = a + b
    x5 = x4 ** (-1.0)
    x6 = -x5 * (a * A[0] + b * B[0])
    x7 = -x6 - C[0]
    x8 = x7**2
    x9 = -x5 * (a * A[1] + b * B[1])
    x10 = -x9 - C[1]
    x11 = x10**2
    x12 = -x5 * (a * A[2] + b * B[2])
    x13 = -x12 - C[2]
    x14 = x13**2
    x15 = c + x4
    x16 = x15 ** (-1.0)
    x17 = c * x16
    x18 = x17 * x4 * (x11 + x14 + x8)
    x19 = boys(2, x18)
    x20 = x15 ** (-1.5)
    x21 = 17.4934183276249
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x5 * (x22**2 + x23**2 + x24**2))
    x26 = x21 * x25
    x27 = x26 * x5
    x28 = 2.0 * x20 * x27
    x29 = x19 * x28
    x30 = x15 ** (-0.5)
    x31 = boys(1, x18)
    x32 = -2.0 * x0 * x21 * x25 * x30 * x31 * x5
    x33 = -x29 - x32
    x34 = x3 * x33
    x35 = -x6 - A[0]
    x36 = -2.0 * x0 * x21 * x25 * x30 * x31 * x35 * x5 + x29 * x7
    x37 = -x36
    x38 = boys(3, x18)
    x39 = x28 * x38
    x40 = -2.0 * x0 * x19 * x21 * x25 * x30 * x35 * x5 + x39 * x7
    x41 = -x40
    x42 = x17 * x41
    x43 = x42 * x7
    x44 = x34 + x35 * x37 - x43
    x45 = x2 * x44
    x46 = x3 * (2.0 * x0 * x19 * x21 * x25 * x30 * x5 - x39)
    x47 = boys(4, x18)
    x48 = x28 * x47
    x49 = -2.0 * x0 * x21 * x25 * x30 * x35 * x38 * x5 + x48 * x7
    x50 = -x49
    x51 = x17 * x50
    x52 = x35 * x41 + x46 - x51 * x7
    x53 = x2 * x52
    x54 = 2.0 * x3
    x55 = x3 * (2.0 * x0 * x21 * x25 * x30 * x38 * x5 - x48)
    x56 = boys(5, x18)
    x57 = x28 * x56
    x58 = 2.0 * x0 * x21 * x25 * x30 * x35 * x47 * x5 - x57 * x7
    x59 = x17 * x58
    x60 = x35 * x50 + x55 - x59 * x7
    x61 = x17 * x7
    x62 = x35 * x52 + x54 * (-x40 - x51) - x60 * x61
    x63 = x16 * x4
    x64 = x62 * x63
    x65 = -x36 - x42
    x66 = x52 * x61
    x67 = x35 * x44 + x54 * x65 - x66
    x68 = x63 * x7
    x69 = x2 * x37
    x70 = x2 * x41
    x71 = x52 * x63
    x72 = x41 * x63
    x73 = 0.5 * x0
    x74 = x73 * (-x36 - x72)
    x75 = 2.0 * x2
    x76 = x0 * x38
    x77 = x75 * x76
    x78 = x27 * x30
    x79 = x77 * x78
    x80 = x50 * x68 + x79
    x81 = x20 * x26
    x82 = x77 * x81
    x83 = x68 * x80 + x7 * x82 + x74
    x84 = -x3 * x33
    x85 = x73 * (x35 * x37 - x43 - x71 - x84)
    x86 = x2 * x50
    x87 = 2.0 * x86
    x88 = x60 * x68 + x87
    x89 = x68 * x88 + x75 * x80 + x85
    x90 = (
        x0 * (x44 * x68 - x63 * (x7 * x71 + 2.0 * x70) + 2.0 * x69)
        + x68 * x89
        + x75 * x83
    )
    x91 = x0 * x19
    x92 = x75 * x78
    x93 = x91 * x92
    x94 = x0 * x31 * x92
    x95 = x73 * (-x32 - 2.0 * x81 * x91)
    x96 = x15 ** (-2.5) * x4
    x97 = 2.0 * x26 * x76
    x98 = x8 * x97
    x99 = x95 + x96 * x98
    x100 = x0 * (x37 * x68 - x63 * (x7 * x72 + x93) + x94) + x2 * x99 + x68 * x83
    x101 = x100 * x22 + x90
    x102 = x26 * x96
    x103 = x102 * x7
    x104 = 2.0 * x91
    x105 = x0 * (2.0 * x0 * x20 * x21 * x25 * x31 * x7 - x103 * x104) + x68 * x99
    x106 = 3.0 * x2
    x107 = x73 * (2.0 * x3 * x65 + x35 * x44 - x64 - x66)
    x108 = x2 * x60
    x109 = 3.0 * x108
    x110 = x3 * (2.0 * x0 * x21 * x25 * x30 * x47 * x5 - x57)
    x111 = x28 * boys(6, x18)
    x112 = (
        x35 * x60
        + x54 * (-x49 - x59)
        - x61
        * (
            x110
            + x35 * x58
            - x61 * (2.0 * x0 * x21 * x25 * x30 * x35 * x5 * x56 - x111 * x7)
        )
    )
    x113 = x4**2
    x114 = x113 / x15**2
    x115 = x10 * x114
    x116 = x0 * (x10 * x16 * x4 * x44 - x115 * x52)
    x117 = x115 * x7
    x118 = x10 * x82
    x119 = x117 * x50 + x118
    x120 = x10 * x63
    x121 = x117 * x60 + x120 * x87
    x122 = 0.5 * x116 + x119 * x75 + x121 * x68
    x123 = x0 * (x10 * x16 * x37 * x4 - x115 * x41)
    x124 = x10 * x7
    x125 = x102 * x77
    x126 = x119 * x68 + 0.5 * x123 + x124 * x125
    x127 = x122 + x126 * x22
    x128 = x102 * x104
    x129 = x0 * (2.0 * x0 * x10 * x20 * x21 * x25 * x31 - x10 * x128)
    x130 = x113 * x15 ** (-3.5)
    x131 = x130 * x98
    x132 = x10 * x131 + 0.5 * x129
    x133 = x0 * (x10 * x16 * x4 * x67 - x115 * x62)
    x134 = x114 * x13
    x135 = x0 * (x13 * x16 * x4 * x44 - x134 * x52)
    x136 = 0.5 * x135
    x137 = x134 * x7
    x138 = x13 * x82
    x139 = x137 * x50 + x138
    x140 = x13 * x63
    x141 = x137 * x60 + x140 * x87
    x142 = x136 + x139 * x75 + x141 * x68
    x143 = x0 * (x13 * x16 * x37 * x4 - x134 * x41)
    x144 = 0.5 * x143
    x145 = x103 * x13 * x77 + x139 * x68 + x144
    x146 = x142 + x145 * x22
    x147 = x0 * (2.0 * x0 * x13 * x20 * x21 * x25 * x31 - x128 * x13)
    x148 = 0.5 * x147
    x149 = x13 * x131 + x148
    x150 = x0 * (x13 * x16 * x4 * x67 - x134 * x62)
    x151 = 0.5 * x150
    x152 = x11 * x114
    x153 = x152 * x50 + x74
    x154 = x153 * x2
    x155 = x152 * x60 + x85
    x156 = 2.0 * x154 + x155 * x68
    x157 = x96 * x97
    x158 = x11 * x157 + x95
    x159 = x158 * x2
    x160 = x153 * x68 + x159
    x161 = x156 + x160 * x22
    x162 = x22 * x68
    x163 = x155 * x2
    x164 = x107 + x112 * x152
    x165 = x4**3 / x15**3
    x166 = x124 * x13
    x167 = x165 * x166
    x168 = x115 * x13
    x169 = x167 * x60 + x168 * x87
    x170 = x10 * x125 * x13
    x171 = x167 * x50 + x170
    x172 = x169 + x171 * x22
    x173 = x130 * x97
    x174 = x166 * x173
    x175 = x114 * x14
    x176 = x175 * x50 + x74
    x177 = x176 * x2
    x178 = x175 * x60 + x85
    x179 = 2.0 * x177 + x178 * x68
    x180 = x14 * x157 + x95
    x181 = x180 * x2
    x182 = x176 * x68 + x181
    x183 = x179 + x182 * x22
    x184 = x178 * x2
    x185 = x107 + x112 * x175
    x186 = x116 + x120 * x155
    x187 = x120 * x153 + x123
    x188 = x186 + x187 * x22
    x189 = x120 * x158 + x129
    x190 = x11 * x13
    x191 = x165 * x190
    x192 = x136 + x191 * x60
    x193 = x144 + x191 * x50
    x194 = x192 + x193 * x22
    x195 = x148 + x173 * x190
    x196 = x120 * x178
    x197 = x120 * x176
    x198 = x196 + x197 * x22
    x199 = x120 * x180
    x200 = x135 + x140 * x178
    x201 = x140 * x176 + x143
    x202 = x200 + x201 * x22
    x203 = x140 * x180 + x147
    x204 = -x9 - A[1]
    x205 = -2.0 * x0 * x204 * x21 * x25 * x30 * x31 * x5 + x10 * x29
    x206 = -x205
    x207 = -2.0 * x0 * x19 * x204 * x21 * x25 * x30 * x5 + x10 * x39
    x208 = -x207
    x209 = x17 * x208
    x210 = -x206 * x35 + x209 * x7
    x211 = -x210
    x212 = x2 * x211
    x213 = 2.0 * x212
    x214 = -2.0 * x0 * x204 * x21 * x25 * x30 * x38 * x5 + x10 * x48
    x215 = -x214
    x216 = x17 * x215
    x217 = x208 * x35 - x216 * x7
    x218 = x2 * x217
    x219 = 2.0 * x218
    x220 = x3 * (-x207 - x216)
    x221 = 2.0 * x0 * x204 * x21 * x25 * x30 * x47 * x5 - x10 * x57
    x222 = x17 * x221
    x223 = x215 * x35 - x222 * x7
    x224 = x217 * x35 + x220 - x223 * x61
    x225 = x224 * x63
    x226 = -x205 - x209
    x227 = x226 * x3
    x228 = x217 * x61
    x229 = x211 * x35 + x227 - x228
    x230 = x2 * x206
    x231 = x2 * x208
    x232 = x217 * x63
    x233 = x208 * x63
    x234 = x73 * (-x205 - x233)
    x235 = x114 * x8
    x236 = x215 * x235 + x234
    x237 = x73 * (-x210 - x232)
    x238 = x2 * x215
    x239 = x223 * x68 + x238
    x240 = x237 + x238 * x68 + x239 * x68
    x241 = x0 * (x211 * x68 + x230 - x63 * (x231 + x232 * x7)) + x2 * x236 + x240 * x68
    x242 = x100 * x23 + x241
    x243 = x114 * x7
    x244 = x0 * (x16 * x206 * x4 * x7 - x208 * x243) + x236 * x68
    x245 = x105 * x23 + x244
    x246 = x73 * (x211 * x35 - x225 + x226 * x3 - x228)
    x247 = x2 * x223
    x248 = 2.0 * x247
    x249 = x3 * (-x214 - x222)
    x250 = 2.0 * x0 * x204 * x21 * x25 * x30 * x5 * x56 - x10 * x111
    x251 = x223 * x35 + x249 - x61 * (x221 * x35 - x250 * x61)
    x252 = x0 * (x120 * x211 - x63 * (x10 * x232 + x70) + x69)
    x253 = x120 * x215 + x79
    x254 = x2 * x253
    x255 = x120 * x223 + x86
    x256 = x254 + x255 * x68
    x257 = 0.5 * x252 + x254 * x68 + x256 * x68
    x258 = x126 * x23 + x257
    x259 = x0 * (x120 * x206 - x63 * (x10 * x233 + x93) + x94)
    x260 = x235 * x253 + 0.5 * x259
    x261 = x132 * x23 + x260
    x262 = x0 * (x120 * x229 + x45 - x63 * (x10 * x225 + x53))
    x263 = x255 * x75
    x264 = x108 + x120 * x251
    x265 = x0 * (x13 * x16 * x211 * x4 - x134 * x217)
    x266 = 0.5 * x265
    x267 = x140 * x238
    x268 = x137 * x223 + x267
    x269 = x137 * x238 + x266 + x268 * x68
    x270 = x145 * x23 + x269
    x271 = x0 * (x13 * x16 * x206 * x4 - x134 * x208)
    x272 = 0.5 * x271
    x273 = x13 * x215
    x274 = x165 * x8
    x275 = x272 + x273 * x274
    x276 = x149 * x23 + x275
    x277 = x0 * (x13 * x16 * x229 * x4 - x134 * x224)
    x278 = 0.5 * x277
    x279 = x140 * x248
    x280 = x118 + x120 * x253 + x234
    x281 = x2 * x280
    x282 = x120 * x255 + x120 * x86 + x237
    x283 = x281 + x282 * x68
    x284 = x160 * x23 + x283
    x285 = x280 * x68
    x286 = x23 * x68
    x287 = x158 * x286 + x285
    x288 = x282 * x75
    x289 = x108 * x120 + x120 * x264 + x246
    x290 = x115 * x273 + x138
    x291 = x2 * x290
    x292 = x140 * x86
    x293 = x168 * x223 + x292
    x294 = x291 + x293 * x68
    x295 = x171 * x23 + x294
    x296 = x290 * x68
    x297 = x174 * x23 + x296
    x298 = x293 * x75
    x299 = x108 * x140
    x300 = x168 * x251 + x299
    x301 = x175 * x215 + x234
    x302 = x2 * x301
    x303 = x175 * x223 + x237
    x304 = x302 + x303 * x68
    x305 = x182 * x23 + x304
    x306 = x301 * x68
    x307 = x180 * x286 + x306
    x308 = x2 * x303
    x309 = 2.0 * x308
    x310 = x175 * x251 + x246
    x311 = x120 * x282 + x154 + x252
    x312 = x187 * x23 + x311
    x313 = x120 * x280 + x159 + x259
    x314 = x189 * x23 + x313
    x315 = x120 * x293 + x168 * x86 + x266
    x316 = x193 * x23 + x315
    x317 = x120 * x290 + x170 + x272
    x318 = x195 * x23 + x317
    x319 = x120 * x303 + x177
    x320 = x197 * x23 + x319
    x321 = x120 * x301 + x181
    x322 = x199 * x23 + x321
    x323 = x140 * x303 + x265
    x324 = x201 * x23 + x323
    x325 = x140 * x301 + x271
    x326 = x203 * x23 + x325
    x327 = -x12 - A[2]
    x328 = -2.0 * x0 * x21 * x25 * x30 * x31 * x327 * x5 + x13 * x29
    x329 = -x328
    x330 = -2.0 * x0 * x19 * x21 * x25 * x30 * x327 * x5 + x13 * x39
    x331 = -x330
    x332 = x17 * x331
    x333 = -x329 * x35 + x332 * x7
    x334 = -x333
    x335 = x2 * x334
    x336 = 2.0 * x335
    x337 = -2.0 * x0 * x21 * x25 * x30 * x327 * x38 * x5 + x13 * x48
    x338 = -x337
    x339 = x17 * x338
    x340 = x331 * x35 - x339 * x7
    x341 = x2 * x340
    x342 = 2.0 * x341
    x343 = x3 * (-x330 - x339)
    x344 = 2.0 * x0 * x21 * x25 * x30 * x327 * x47 * x5 - x13 * x57
    x345 = x17 * x344
    x346 = x338 * x35 - x345 * x7
    x347 = x340 * x35 + x343 - x346 * x61
    x348 = x347 * x63
    x349 = -x328 - x332
    x350 = x3 * x349
    x351 = x340 * x61
    x352 = x334 * x35 + x350 - x351
    x353 = x2 * x329
    x354 = x2 * x331
    x355 = x340 * x63
    x356 = x331 * x63
    x357 = x73 * (-x328 - x356)
    x358 = x235 * x338 + x357
    x359 = x73 * (-x333 - x355)
    x360 = x2 * x338
    x361 = x346 * x68 + x360
    x362 = x359 + x360 * x68 + x361 * x68
    x363 = x0 * (x334 * x68 + x353 - x63 * (x354 + x355 * x7)) + x2 * x358 + x362 * x68
    x364 = x100 * x24 + x363
    x365 = x0 * (x16 * x329 * x4 * x7 - x243 * x331) + x358 * x68
    x366 = x105 * x24 + x365
    x367 = -x3 * x349
    x368 = x73 * (x334 * x35 - x348 - x351 - x367)
    x369 = x2 * x346
    x370 = 2.0 * x369
    x371 = x3 * (-x337 - x345)
    x372 = 2.0 * x0 * x21 * x25 * x30 * x327 * x5 * x56 - x111 * x13
    x373 = x346 * x35 + x371 - x61 * (x344 * x35 - x372 * x61)
    x374 = x0 * (x10 * x16 * x334 * x4 - x115 * x340)
    x375 = x120 * x360
    x376 = x117 * x346 + x375
    x377 = x117 * x360 + 0.5 * x374 + x376 * x68
    x378 = x126 * x24 + x377
    x379 = x0 * (x10 * x16 * x329 * x4 - x115 * x331)
    x380 = x10 * x274
    x381 = x338 * x380 + 0.5 * x379
    x382 = x132 * x24 + x381
    x383 = x0 * (x10 * x16 * x352 * x4 - x115 * x347)
    x384 = x0 * (x140 * x334 - x63 * (x13 * x355 + x70) + x69)
    x385 = 0.5 * x384
    x386 = x140 * x338 + x79
    x387 = x2 * x386
    x388 = x140 * x346 + x86
    x389 = x387 + x388 * x68
    x390 = x385 + x387 * x68 + x389 * x68
    x391 = x145 * x24 + x390
    x392 = x0 * (x140 * x329 - x63 * (x13 * x356 + x93) + x94)
    x393 = 0.5 * x392
    x394 = x235 * x386 + x393
    x395 = x149 * x24 + x394
    x396 = x0 * (x140 * x352 + x45 - x63 * (x13 * x348 + x53))
    x397 = 0.5 * x396
    x398 = x2 * x388
    x399 = 2.0 * x398
    x400 = x108 + x140 * x373
    x401 = x152 * x338 + x357
    x402 = x2 * x401
    x403 = x152 * x346 + x359
    x404 = x402 + x403 * x68
    x405 = x160 * x24 + x404
    x406 = x401 * x68
    x407 = x24 * x68
    x408 = x158 * x407 + x406
    x409 = x2 * x403
    x410 = x152 * x373 + x368
    x411 = x120 * x387
    x412 = x117 * x388 + x411
    x413 = x171 * x24 + x412
    x414 = x117 * x386
    x415 = x174 * x24 + x414
    x416 = x138 + x140 * x386 + x357
    x417 = x2 * x416
    x418 = x140 * x388 + x292 + x359
    x419 = x417 + x418 * x68
    x420 = x182 * x24 + x419
    x421 = x416 * x68
    x422 = x180 * x407 + x421
    x423 = x2 * x418
    x424 = 2.0 * x423
    x425 = x140 * x400 + x299 + x368
    x426 = x120 * x403 + x374
    x427 = x187 * x24 + x426
    x428 = x120 * x401 + x379
    x429 = x189 * x24 + x428
    x430 = x152 * x388 + x385
    x431 = x193 * x24 + x430
    x432 = x152 * x386 + x393
    x433 = x195 * x24 + x432
    x434 = x120 * x418
    x435 = x197 * x24 + x434
    x436 = x120 * x416
    x437 = x199 * x24 + x436
    x438 = x140 * x418 + x177 + x384
    x439 = x201 * x24 + x438
    x440 = x140 * x416 + x181 + x392
    x441 = x203 * x24 + x440
    x442 = x10 * x209
    x443 = x204 * x206 + x34 - x442
    x444 = x2 * x443
    x445 = -x10 * x216 + x204 * x208 + x46
    x446 = x2 * x445
    x447 = -x10 * x222 + x204 * x215 + x55
    x448 = x35 * x445 - x447 * x61
    x449 = x448 * x63
    x450 = -x35 * x443 + x445 * x61
    x451 = -x450
    x452 = x445 * x63
    x453 = x73 * (x204 * x206 - x442 - x452 - x84)
    x454 = x235 * x447 + x453
    x455 = x0 * (x16 * x4 * x443 * x7 - x243 * x445) + x454 * x68
    x456 = x23 * x244 + x455
    x457 = x23 * x245 + x456
    x458 = x73 * (-x449 - x450)
    x459 = x2 * x447
    x460 = x10 * x17
    x461 = x110 + x204 * x221 - x250 * x460
    x462 = x35 * x447 - x461 * x61
    x463 = x0 * (x120 * x443 + 2.0 * x230 - x63 * (x10 * x452 + 2.0 * x231))
    x464 = 2.0 * x238
    x465 = x120 * x447 + x464
    x466 = x235 * x465 + 0.5 * x463
    x467 = x23 * x260 + x466
    x468 = x23 * x261 + x467
    x469 = x0 * (x120 * x451 + x213 - x63 * (x10 * x449 + x219))
    x470 = x2 * x465
    x471 = x120 * x462 + x248
    x472 = x0 * (x13 * x16 * x4 * x443 - x134 * x445)
    x473 = 0.5 * x472
    x474 = x13 * x274
    x475 = x447 * x474 + x473
    x476 = x23 * x275 + x475
    x477 = x23 * x276 + x476
    x478 = x0 * (x13 * x16 * x4 * x451 - x134 * x448)
    x479 = 0.5 * x478
    x480 = x140 * x459
    x481 = x120 * x465 + 2.0 * x254 + x453
    x482 = x2 * x481
    x483 = x481 * x68
    x484 = x23 * x285 + x483
    x485 = x23 * x287 + x484
    x486 = x120 * x471 + x263 + x458
    x487 = x140 * x464 + x168 * x447
    x488 = x2 * x487
    x489 = x487 * x68
    x490 = x23 * x296 + x489
    x491 = x23 * x297 + x490
    x492 = x168 * x462 + x279
    x493 = x175 * x447 + x453
    x494 = x2 * x493
    x495 = x493 * x68
    x496 = x23 * x306 + x495
    x497 = x23 * x307 + x496
    x498 = x175 * x462 + x458
    x499 = x120 * x481 + 2.0 * x281 + x463
    x500 = x23 * x313 + x499
    x501 = x23 * x314 + x500
    x502 = x120 * x487 + 2.0 * x291 + x473
    x503 = x23 * x317 + x502
    x504 = x23 * x318 + x503
    x505 = x120 * x493 + 2.0 * x302
    x506 = x23 * x321 + x505
    x507 = x23 * x322 + x506
    x508 = x140 * x493 + x472
    x509 = x23 * x325 + x508
    x510 = x23 * x326 + x509
    x511 = x10 * x332 - x204 * x329
    x512 = -x511
    x513 = x2 * x512
    x514 = -x10 * x339 + x204 * x331
    x515 = x2 * x514
    x516 = -x10 * x345 + x204 * x338
    x517 = x63 * (x35 * x514 - x516 * x61)
    x518 = -x35 * x512 + x514 * x61
    x519 = -x518
    x520 = x514 * x63
    x521 = x73 * (-x511 - x520)
    x522 = x235 * x516 + x521
    x523 = x0 * (x16 * x4 * x512 * x7 - x243 * x514) + x522 * x68
    x524 = x24 * x244 + x523
    x525 = x23 * x366 + x524
    x526 = x73 * (-x517 - x518)
    x527 = x2 * x516
    x528 = x204 * x344 - x372 * x460
    x529 = x35 * x516 - x528 * x61
    x530 = x0 * (x120 * x512 + x353 - x63 * (x10 * x520 + x354))
    x531 = x120 * x516 + x360
    x532 = x235 * x531 + 0.5 * x530
    x533 = x24 * x260 + x532
    x534 = x23 * x382 + x533
    x535 = x0 * (x120 * x519 + x335 - x63 * (x10 * x517 + x341))
    x536 = x2 * x531
    x537 = x120 * x529 + x369
    x538 = x0 * (x140 * x512 + x230 - x63 * (x13 * x520 + x231))
    x539 = 0.5 * x538
    x540 = x140 * x516 + x238
    x541 = x235 * x540 + x539
    x542 = x24 * x275 + x541
    x543 = x23 * x395 + x542
    x544 = x0 * (x140 * x519 + x212 - x63 * (x13 * x517 + x218))
    x545 = 0.5 * x544
    x546 = x2 * x540
    x547 = x140 * x529 + x247
    x548 = x120 * x531 + x375 + x521
    x549 = x2 * x548
    x550 = x548 * x68
    x551 = x24 * x285 + x550
    x552 = x23 * x408 + x551
    x553 = x120 * x369 + x120 * x537 + x526
    x554 = x120 * x540 + x387
    x555 = x2 * x554
    x556 = x554 * x68
    x557 = x24 * x296 + x556
    x558 = x23 * x415 + x557
    x559 = x120 * x547 + x398
    x560 = x140 * x540 + x267 + x521
    x561 = x2 * x560
    x562 = x560 * x68
    x563 = x24 * x306 + x562
    x564 = x23 * x422 + x563
    x565 = x140 * x247 + x140 * x547 + x526
    x566 = x120 * x548 + x402 + x530
    x567 = x24 * x313 + x566
    x568 = x23 * x429 + x567
    x569 = x120 * x554 + x411 + x539
    x570 = x24 * x317 + x569
    x571 = x23 * x433 + x570
    x572 = x120 * x560 + x417
    x573 = x24 * x321 + x572
    x574 = x23 * x437 + x573
    x575 = x140 * x560 + x302 + x538
    x576 = x24 * x325 + x575
    x577 = x23 * x441 + x576
    x578 = x13 * x332
    x579 = x327 * x329 + x34 - x578
    x580 = x2 * x579
    x581 = -x13 * x339 + x327 * x331 + x46
    x582 = x2 * x581
    x583 = -x13 * x345 + x327 * x338 + x55
    x584 = x35 * x581 - x583 * x61
    x585 = x584 * x63
    x586 = -x35 * x579 + x581 * x61
    x587 = -x586
    x588 = x581 * x63
    x589 = x73 * (x327 * x329 - x578 - x588 - x84)
    x590 = x235 * x583 + x589
    x591 = x0 * (x16 * x4 * x579 * x7 - x243 * x581) + x590 * x68
    x592 = x24 * x365 + x591
    x593 = x24 * x366 + x592
    x594 = x73 * (-x585 - x586)
    x595 = x2 * x583
    x596 = x13 * x17
    x597 = x110 + x327 * x344 - x372 * x596
    x598 = x35 * x583 - x597 * x61
    x599 = x0 * (x10 * x16 * x4 * x579 - x115 * x581)
    x600 = x380 * x583 + 0.5 * x599
    x601 = x24 * x381 + x600
    x602 = x24 * x382 + x601
    x603 = x0 * (x10 * x16 * x4 * x587 - x115 * x584)
    x604 = x120 * x595
    x605 = x0 * (x140 * x579 + 2.0 * x353 - x63 * (x13 * x588 + 2.0 * x354))
    x606 = 0.5 * x605
    x607 = x140 * x583 + 2.0 * x360
    x608 = x235 * x607 + x606
    x609 = x24 * x394 + x608
    x610 = x24 * x395 + x609
    x611 = x0 * (x140 * x587 + x336 - x63 * (x13 * x585 + x342))
    x612 = 0.5 * x611
    x613 = x2 * x607
    x614 = x140 * x598 + x370
    x615 = x152 * x583 + x589
    x616 = x2 * x615
    x617 = x615 * x68
    x618 = x24 * x406 + x617
    x619 = x24 * x408 + x618
    x620 = x152 * x598 + x594
    x621 = x117 * x607
    x622 = x24 * x414 + x621
    x623 = x24 * x415 + x622
    x624 = x120 * x613
    x625 = x140 * x607 + 2.0 * x387 + x589
    x626 = x2 * x625
    x627 = x625 * x68
    x628 = x24 * x421 + x627
    x629 = x24 * x422 + x628
    x630 = x140 * x614 + x399 + x594
    x631 = x120 * x615 + x599
    x632 = x24 * x428 + x631
    x633 = x24 * x429 + x632
    x634 = x152 * x607 + x606
    x635 = x24 * x432 + x634
    x636 = x24 * x433 + x635
    x637 = x120 * x625
    x638 = x24 * x436 + x637
    x639 = x24 * x437 + x638
    x640 = x140 * x625 + 2.0 * x417 + x605
    x641 = x24 * x440 + x640
    x642 = x24 * x441 + x641
    x643 = x204 * x445 + 2.0 * x220 - x447 * x460
    x644 = x445 * x460
    x645 = x204 * x443 + 2.0 * x227 - x644
    x646 = x63 * x643
    x647 = x73 * (x204 * x443 + 2.0 * x226 * x3 - x644 - x646)
    x648 = x204 * x447 + 2.0 * x249 - x460 * x461
    x649 = x0 * (x120 * x645 + 3.0 * x444 - x63 * (x10 * x646 + 3.0 * x446))
    x650 = 3.0 * x459
    x651 = x120 * x648 + x650
    x652 = x0 * (x13 * x16 * x4 * x645 - x134 * x643)
    x653 = 0.5 * x652
    x654 = x120 * x651 + 3.0 * x470 + x647
    x655 = x140 * x650 + x168 * x648
    x656 = x175 * x648 + x647
    x657 = x204 * x514 + x343 - x460 * x516
    x658 = x460 * x514
    x659 = x204 * x512 + x350 - x658
    x660 = x63 * x657
    x661 = x73 * (x204 * x512 - x367 - x658 - x660)
    x662 = x204 * x516 + x371 - x460 * x528
    x663 = 2.0 * x513
    x664 = 2.0 * x515
    x665 = x0 * (x120 * x659 - x63 * (x10 * x660 + x664) + x663)
    x666 = 2.0 * x527
    x667 = x120 * x662 + x666
    x668 = x0 * (x140 * x659 + x444 - x63 * (x13 * x660 + x446))
    x669 = 0.5 * x668
    x670 = x140 * x662 + x459
    x671 = x120 * x667 + 2.0 * x536 + x661
    x672 = 2.0 * x546
    x673 = x120 * x670 + x672
    x674 = x140 * x670 + x480 + x661
    x675 = 2.0 * x561
    x676 = x204 * x581 - x460 * x583
    x677 = -x204 * x579 + x460 * x581
    x678 = -x677
    x679 = x63 * x676
    x680 = x73 * (-x677 - x679)
    x681 = x204 * x583 - x460 * x597
    x682 = x0 * (x120 * x678 + x580 - x63 * (x10 * x679 + x582))
    x683 = x120 * x681 + x595
    x684 = x0 * (x140 * x678 - x63 * (x13 * x679 + x664) + x663)
    x685 = 0.5 * x684
    x686 = x140 * x681 + x666
    x687 = x120 * x683 + x604 + x680
    x688 = x120 * x686 + x613
    x689 = x140 * x686 + x672 + x680
    x690 = x327 * x581 + 2.0 * x343 - x583 * x596
    x691 = x581 * x596
    x692 = x327 * x579 + 2.0 * x350 - x691
    x693 = x63 * x690
    x694 = x73 * (2.0 * x3 * x349 + x327 * x579 - x691 - x693)
    x695 = x327 * x583 + 2.0 * x371 - x596 * x597
    x696 = x0 * (x10 * x16 * x4 * x692 - x115 * x690)
    x697 = x0 * (x140 * x692 + 3.0 * x580 - x63 * (x13 * x693 + 3.0 * x582))
    x698 = 0.5 * x697
    x699 = x140 * x695 + 3.0 * x595
    x700 = x152 * x695 + x694
    x701 = x140 * x699 + 3.0 * x613 + x694

    # 100 item(s)
    return numpy.array(
        [
            x0 * (3.0 * x45 - x63 * (3.0 * x53 + x64 * x7) + x67 * x68)
            + x101 * x22
            + x106 * x89
            + x22 * x90
            + x22 * (x101 + x22 * (x100 + x105 * x22))
            + x68 * (x106 * x88 + x107 + x68 * (x109 + x112 * x68)),
            x106 * x121
            + x122 * x22
            + x127 * x22
            + 0.5 * x133
            + x22 * (x127 + x22 * (x126 + x132 * x22))
            + x68 * (x109 * x120 + x112 * x117),
            x106 * x141
            + x142 * x22
            + x146 * x22
            + x151
            + x22 * (x146 + x22 * (x145 + x149 * x22))
            + x68 * (x109 * x140 + x112 * x137),
            x156 * x22
            + x161 * x22
            + 3.0 * x163
            + x164 * x68
            + x22 * (x161 + x22 * (x158 * x162 + x160)),
            x109 * x168
            + x112 * x167
            + x169 * x22
            + x172 * x22
            + x22 * (x172 + x22 * (x171 + x174 * x22)),
            x179 * x22
            + x183 * x22
            + 3.0 * x184
            + x185 * x68
            + x22 * (x183 + x22 * (x162 * x180 + x182)),
            x120 * x164
            + x133
            + x186 * x22
            + x188 * x22
            + x22 * (x188 + x22 * (x187 + x189 * x22)),
            x112 * x191
            + x151
            + x192 * x22
            + x194 * x22
            + x22 * (x194 + x22 * (x193 + x195 * x22)),
            x120 * x185
            + x196 * x22
            + x198 * x22
            + x22 * (x198 + x22 * (x197 + x199 * x22)),
            x140 * x185
            + x150
            + x200 * x22
            + x202 * x22
            + x22 * (x202 + x22 * (x201 + x203 * x22)),
            x0 * (x213 + x229 * x68 - x63 * (x219 + x225 * x7))
            + x22 * x242
            + x22 * (x22 * x245 + x242)
            + x23 * x90
            + x240 * x75
            + x68 * (x239 * x75 + x246 + x68 * (x248 + x251 * x68)),
            x122 * x23
            + x22 * x258
            + x22 * (x22 * x261 + x258)
            + x256 * x75
            + 0.5 * x262
            + x68 * (x263 + x264 * x68),
            x142 * x23
            + x22 * x270
            + x22 * (x22 * x276 + x270)
            + x268 * x75
            + x278
            + x68 * (x137 * x251 + x279),
            x156 * x23 + x22 * x284 + x22 * (x22 * x287 + x284) + x288 + x289 * x68,
            x169 * x23 + x22 * x295 + x22 * (x22 * x297 + x295) + x298 + x300 * x68,
            x179 * x23 + x22 * x305 + x22 * (x22 * x307 + x305) + x309 + x310 * x68,
            x120 * x289
            + x163
            + x186 * x23
            + x22 * x312
            + x22 * (x22 * x314 + x312)
            + x262,
            x108 * x168
            + x120 * x300
            + x192 * x23
            + x22 * x316
            + x22 * (x22 * x318 + x316)
            + x278,
            x120 * x310 + x184 + x196 * x23 + x22 * x320 + x22 * (x22 * x322 + x320),
            x140 * x310 + x200 * x23 + x22 * x324 + x22 * (x22 * x326 + x324) + x277,
            x0 * (x336 + x352 * x68 - x63 * (x342 + x348 * x7))
            + x22 * x364
            + x22 * (x22 * x366 + x364)
            + x24 * x90
            + x362 * x75
            + x68 * (x361 * x75 + x368 + x68 * (x370 + x373 * x68)),
            x122 * x24
            + x22 * x378
            + x22 * (x22 * x382 + x378)
            + x376 * x75
            + 0.5 * x383
            + x68 * (x117 * x373 + x120 * x370),
            x142 * x24
            + x22 * x391
            + x22 * (x22 * x395 + x391)
            + x389 * x75
            + x397
            + x68 * (x399 + x400 * x68),
            x156 * x24 + x22 * x405 + x22 * (x22 * x408 + x405) + 2.0 * x409 + x410 * x68,
            x117 * x400
            + x120 * x399
            + x169 * x24
            + x22 * x413
            + x22 * (x22 * x415 + x413),
            x179 * x24 + x22 * x420 + x22 * (x22 * x422 + x420) + x424 + x425 * x68,
            x120 * x410 + x186 * x24 + x22 * x427 + x22 * (x22 * x429 + x427) + x383,
            x152 * x400 + x192 * x24 + x22 * x431 + x22 * (x22 * x433 + x431) + x397,
            x120 * x425 + x196 * x24 + x22 * x435 + x22 * (x22 * x437 + x435),
            x140 * x425
            + x184
            + x200 * x24
            + x22 * x439
            + x22 * (x22 * x441 + x439)
            + x396,
            x0 * (x444 + x451 * x68 - x63 * (x446 + x449 * x7))
            + x2 * x454
            + x22 * x457
            + x23 * x241
            + x23 * x242
            + x68 * (x458 + x459 * x68 + x68 * (x459 + x462 * x68)),
            x22 * x468
            + x23 * x257
            + x23 * x258
            + 0.5 * x469
            + x470 * x68
            + x68 * (x470 + x471 * x68),
            x137 * x459
            + x22 * x477
            + x23 * x269
            + x23 * x270
            + x479
            + x68 * (x137 * x462 + x480),
            x22 * x485 + x23 * x283 + x23 * x284 + x482 + x486 * x68,
            x22 * x491 + x23 * x294 + x23 * x295 + x488 + x492 * x68,
            x22 * x497 + x23 * x304 + x23 * x305 + x494 + x498 * x68,
            x120 * x486 + x22 * x501 + x23 * x311 + x23 * x312 + x288 + x469,
            x120 * x492 + x22 * x504 + x23 * x315 + x23 * x316 + x298 + x479,
            x120 * x498 + x22 * x507 + x23 * x319 + x23 * x320 + x309,
            x140 * x498 + x22 * x510 + x23 * x323 + x23 * x324 + x478,
            x0 * (x513 + x519 * x68 - x63 * (x515 + x517 * x7))
            + x2 * x522
            + x22 * x525
            + x23 * x364
            + x24 * x241
            + x68 * (x526 + x527 * x68 + x68 * (x527 + x529 * x68)),
            x22 * x534
            + x23 * x378
            + x24 * x257
            + 0.5 * x535
            + x536 * x68
            + x68 * (x536 + x537 * x68),
            x22 * x543
            + x23 * x391
            + x24 * x269
            + x545
            + x546 * x68
            + x68 * (x546 + x547 * x68),
            x22 * x552 + x23 * x405 + x24 * x283 + x549 + x553 * x68,
            x22 * x558 + x23 * x413 + x24 * x294 + x555 + x559 * x68,
            x22 * x564 + x23 * x420 + x24 * x304 + x561 + x565 * x68,
            x120 * x553 + x22 * x568 + x23 * x427 + x24 * x311 + x409 + x535,
            x120 * x398 + x120 * x559 + x22 * x571 + x23 * x431 + x24 * x315 + x545,
            x120 * x565 + x22 * x574 + x23 * x435 + x24 * x319 + x423,
            x140 * x565 + x22 * x577 + x23 * x439 + x24 * x323 + x308 + x544,
            x0 * (x580 + x587 * x68 - x63 * (x582 + x585 * x7))
            + x2 * x590
            + x22 * x593
            + x24 * x363
            + x24 * x364
            + x68 * (x594 + x595 * x68 + x68 * (x595 + x598 * x68)),
            x117 * x595
            + x22 * x602
            + x24 * x377
            + x24 * x378
            + 0.5 * x603
            + x68 * (x117 * x598 + x604),
            x22 * x610
            + x24 * x390
            + x24 * x391
            + x612
            + x613 * x68
            + x68 * (x613 + x614 * x68),
            x22 * x619 + x24 * x404 + x24 * x405 + x616 + x620 * x68,
            x117 * x614 + x22 * x623 + x24 * x412 + x24 * x413 + x624,
            x22 * x629 + x24 * x419 + x24 * x420 + x626 + x630 * x68,
            x120 * x620 + x22 * x633 + x24 * x426 + x24 * x427 + x603,
            x152 * x614 + x22 * x636 + x24 * x430 + x24 * x431 + x612,
            x120 * x630 + x22 * x639 + x24 * x434 + x24 * x435,
            x140 * x630 + x22 * x642 + x24 * x438 + x24 * x439 + x424 + x611,
            x0 * (x16 * x4 * x645 * x7 - x243 * x643)
            + x23 * x455
            + x23 * x456
            + x23 * x457
            + x68 * (x235 * x648 + x647),
            x23 * x466 + x23 * x467 + x23 * x468 + x235 * x651 + 0.5 * x649,
            x23 * x475 + x23 * x476 + x23 * x477 + x474 * x648 + x653,
            x23 * x483 + x23 * x484 + x23 * x485 + x654 * x68,
            x23 * x489 + x23 * x490 + x23 * x491 + x655 * x68,
            x23 * x495 + x23 * x496 + x23 * x497 + x656 * x68,
            x120 * x654 + x23 * x499 + x23 * x500 + x23 * x501 + 3.0 * x482 + x649,
            x120 * x655 + x23 * x502 + x23 * x503 + x23 * x504 + 3.0 * x488 + x653,
            x120 * x656 + x23 * x505 + x23 * x506 + x23 * x507 + 3.0 * x494,
            x140 * x656 + x23 * x508 + x23 * x509 + x23 * x510 + x652,
            x0 * (x16 * x4 * x659 * x7 - x243 * x657)
            + x23 * x524
            + x23 * x525
            + x24 * x455
            + x68 * (x235 * x662 + x661),
            x23 * x533 + x23 * x534 + x235 * x667 + x24 * x466 + 0.5 * x665,
            x23 * x542 + x23 * x543 + x235 * x670 + x24 * x475 + x669,
            x23 * x551 + x23 * x552 + x24 * x483 + x671 * x68,
            x23 * x557 + x23 * x558 + x24 * x489 + x673 * x68,
            x23 * x563 + x23 * x564 + x24 * x495 + x674 * x68,
            x120 * x671 + x23 * x567 + x23 * x568 + x24 * x499 + 2.0 * x549 + x665,
            x120 * x673 + x23 * x570 + x23 * x571 + x24 * x502 + 2.0 * x555 + x669,
            x120 * x674 + x23 * x573 + x23 * x574 + x24 * x505 + x675,
            x140 * x674 + x23 * x576 + x23 * x577 + x24 * x508 + x494 + x668,
            x0 * (x16 * x4 * x678 * x7 - x243 * x676)
            + x23 * x593
            + x24 * x523
            + x24 * x524
            + x68 * (x235 * x681 + x680),
            x23 * x602 + x235 * x683 + x24 * x532 + x24 * x533 + 0.5 * x682,
            x23 * x610 + x235 * x686 + x24 * x541 + x24 * x542 + x685,
            x23 * x619 + x24 * x550 + x24 * x551 + x68 * x687,
            x23 * x623 + x24 * x556 + x24 * x557 + x68 * x688,
            x23 * x629 + x24 * x562 + x24 * x563 + x68 * x689,
            x120 * x687 + x23 * x633 + x24 * x566 + x24 * x567 + x616 + x682,
            x120 * x688 + x23 * x636 + x24 * x569 + x24 * x570 + x624 + x685,
            x120 * x689 + x23 * x639 + x24 * x572 + x24 * x573 + x626,
            x140 * x689 + x23 * x642 + x24 * x575 + x24 * x576 + x675 + x684,
            x0 * (x16 * x4 * x692 * x7 - x243 * x690)
            + x24 * x591
            + x24 * x592
            + x24 * x593
            + x68 * (x235 * x695 + x694),
            x24 * x600 + x24 * x601 + x24 * x602 + x380 * x695 + 0.5 * x696,
            x235 * x699 + x24 * x608 + x24 * x609 + x24 * x610 + x698,
            x24 * x617 + x24 * x618 + x24 * x619 + x68 * x700,
            x117 * x699 + x24 * x621 + x24 * x622 + x24 * x623,
            x24 * x627 + x24 * x628 + x24 * x629 + x68 * x701,
            x120 * x700 + x24 * x631 + x24 * x632 + x24 * x633 + x696,
            x152 * x699 + x24 * x634 + x24 * x635 + x24 * x636 + x698,
            x120 * x701 + x24 * x637 + x24 * x638 + x24 * x639,
            x140 * x701 + x24 * x640 + x24 * x641 + x24 * x642 + 3.0 * x626 + x697,
        ]
    )


def _3center2el3d_034(a, A, b, B, c, C):
    """Cartesian (sf|g) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = c ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - C[0]
    x6 = x5**2
    x7 = -x3 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x3 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x2
    x14 = x13 ** (-1.0)
    x15 = x14 * x2
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(4, x16)
    x18 = x13 ** (-1.5)
    x19 = 2.0 * x18
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x3 * (x0**2 + x21**2 + x22**2))
    x24 = x20 * x23 * x3
    x25 = x19 * x24
    x26 = x17 * x25
    x27 = x13 ** (-0.5)
    x28 = -x4 - A[0]
    x29 = boys(3, x16)
    x30 = -2.0 * x1 * x20 * x23 * x27 * x28 * x29 * x3 + x26 * x5
    x31 = -x30
    x32 = x15 * x31
    x33 = x1 * x20 * x23
    x34 = x29 * x33
    x35 = 2.0 * a + 2.0 * b
    x36 = (2.0 * c + x35) ** (-1.0)
    x37 = 2.0 * x36
    x38 = x27 * x3 * x37
    x39 = x34 * x38
    x40 = x32 * x5 + x39
    x41 = x15 * x40
    x42 = x25 * x29
    x43 = boys(2, x16)
    x44 = -2.0 * x1 * x20 * x23 * x27 * x28 * x3 * x43 + x42 * x5
    x45 = -x44
    x46 = x15 * x45
    x47 = x33 * x43
    x48 = x38 * x47
    x49 = x46 * x5 + x48
    x50 = -2.0 * x1 * x20 * x23 * x27 * x3 * x43
    x51 = 0.5 * x1
    x52 = x51 * (-x19 * x34 - x50)
    x53 = x17 * x33
    x54 = x13 ** (-2.5)
    x55 = x2 * x54
    x56 = 2.0 * x55
    x57 = x56 * x6
    x58 = x52 + x53 * x57
    x59 = x51 * (-x32 - x44)
    x60 = boys(5, x16)
    x61 = x25 * x60
    x62 = -2.0 * x1 * x17 * x20 * x23 * x27 * x28 * x3 + x5 * x61
    x63 = -x62
    x64 = x15 * x5
    x65 = x38 * x53
    x66 = x63 * x64 + x65
    x67 = x18 * x37
    x68 = x5 * x67
    x69 = x53 * x68 + x59 + x64 * x66
    x70 = x1 * (-x41 + x49) + x36 * x58 + x64 * x69
    x71 = x35 ** (-1.0)
    x72 = boys(1, x16)
    x73 = x19 * x72
    x74 = x24 * x73
    x75 = boys(0, x16)
    x76 = -2.0 * x1 * x20 * x23 * x27 * x3 * x75
    x77 = -x74 - x76
    x78 = -x71 * x77
    x79 = -2.0 * x1 * x20 * x23 * x27 * x28 * x3 * x75 + x5 * x74
    x80 = -x79
    x81 = x25 * x43
    x82 = -2.0 * x1 * x20 * x23 * x27 * x3 * x72
    x83 = -x81 - x82
    x84 = x71 * x83
    x85 = -2.0 * x1 * x20 * x23 * x27 * x28 * x3 * x72 + x5 * x81
    x86 = -x85
    x87 = c * x14
    x88 = x45 * x87
    x89 = x5 * x88
    x90 = x28 * x86 + x84 - x89
    x91 = x86 * x87
    x92 = x5 * x91
    x93 = x51 * (-x15 * x90 + x28 * x80 - x78 - x92)
    x94 = -x71 * x83
    x95 = -x42 - x50
    x96 = x71 * x95
    x97 = x31 * x87
    x98 = x5 * x97
    x99 = x28 * x45 + x96 - x98
    x100 = x15 * x99
    x101 = x51 * (-x100 + x28 * x86 - x89 - x94)
    x102 = x31 * x36
    x103 = 2.0 * x102
    x104 = x71 * (2.0 * x1 * x20 * x23 * x27 * x29 * x3 - x26)
    x105 = x63 * x87
    x106 = x104 - x105 * x5 + x28 * x31
    x107 = x106 * x15
    x108 = x103 + x107 * x5
    x109 = x108 * x15
    x110 = x36 * x45
    x111 = 2.0 * x110
    x112 = x100 * x5 + x111
    x113 = 1.5 * x1
    x114 = -x71 * x95
    x115 = x51 * (-x107 - x114 + x28 * x45 - x98)
    x116 = x36 * x63
    x117 = 2.0 * x116
    x118 = x71 * (2.0 * x1 * x17 * x20 * x23 * x27 * x3 - x61)
    x119 = boys(6, x16)
    x120 = x119 * x25
    x121 = 2.0 * x1 * x20 * x23 * x27 * x28 * x3 * x60 - x120 * x5
    x122 = x121 * x87
    x123 = x118 - x122 * x5 + x28 * x63
    x124 = x117 + x123 * x64
    x125 = x115 + x124 * x64 + x37 * x66
    x126 = x1 * (-x109 + x112) + x125 * x64 + x37 * x69
    x127 = (
        x113 * (x112 * x64 - x15 * (x101 + x109 * x5 + x37 * x40) + x37 * x49 + x93)
        + x126 * x64
        + x37 * x70
    )
    x128 = x34 * x56
    x129 = x1 * (2.0 * x1 * x18 * x20 * x23 * x43 * x5 - x128 * x5) + x58 * x64
    x130 = x51 * (-x15 * x86 - x79)
    x131 = x51 * (-x46 - x85)
    x132 = (
        x113 * (x130 - x15 * (x131 + x34 * x68 + x41 * x5) + x47 * x68 + x49 * x64)
        + x129 * x36
        + x64 * x70
    )
    x133 = x0 * x132 + x127
    x134 = x51 * (-x33 * x73 - x76)
    x135 = x51 * (-x19 * x47 - x82)
    x136 = 2.0 * x47 * x55
    x137 = x113 * (x134 + x136 * x6 - x15 * (x135 + x34 * x57)) + x129 * x64
    x138 = 3.0 * x36
    x139 = x71 * x77
    x140 = -x85 - x88
    x141 = 2.0 * x71
    x142 = x5 * x87
    x143 = x142 * x99
    x144 = x51 * (
        -x142 * x90
        - x15 * (x140 * x141 - x143 + x28 * x90)
        + x28 * (x139 + x28 * x80 - x92)
        + 2.0 * x71 * (-x79 - x91)
    )
    x145 = -x44 - x97
    x146 = x106 * x142
    x147 = x141 * x145 - x146 + x28 * x99
    x148 = x147 * x15
    x149 = x51 * (2.0 * x140 * x71 - x143 - x148 + x28 * x90)
    x150 = x106 * x36
    x151 = 3.0 * x150
    x152 = x106 * x28 - x123 * x142 + x141 * (-x105 - x30)
    x153 = x15 * x152
    x154 = x15 * (x151 + x153 * x5)
    x155 = x36 * x99
    x156 = 3.0 * x155
    x157 = x148 * x5 + x156
    x158 = x51 * (2.0 * x145 * x71 - x146 - x153 + x28 * x99)
    x159 = x123 * x36
    x160 = 3.0 * x159
    x161 = x71 * (2.0 * x1 * x20 * x23 * x27 * x3 * x60 - x120)
    x162 = x25 * boys(7, x16)
    x163 = (
        x123 * x28
        + x141 * (-x122 - x62)
        - x142
        * (
            x121 * x28
            - x142 * (2.0 * x1 * x119 * x20 * x23 * x27 * x28 * x3 - x162 * x5)
            + x161
        )
    )
    x164 = x2**2
    x165 = x13 ** (-2.0)
    x166 = x164 * x165
    x167 = x166 * x8
    x168 = x152 * x167
    x169 = x15 * x8
    x170 = x167 * x5
    x171 = x106 * x167
    x172 = x31 * x8
    x173 = x166 * x172
    x174 = x1 * (x14 * x2 * x45 * x8 - x173)
    x175 = x67 * x8
    x176 = x175 * x53
    x177 = x170 * x63 + x176
    x178 = x53 * x8
    x179 = x37 * x55
    x180 = x179 * x5
    x181 = 0.5 * x174 + x177 * x64 + x178 * x180
    x182 = x1 * (x14 * x2 * x8 * x99 - x171)
    x183 = x117 * x169 + x123 * x170
    x184 = x177 * x37 + 0.5 * x182 + x183 * x64
    x185 = (
        x1 * (x111 * x169 - x15 * (x103 * x169 + x171 * x5) + x170 * x99)
        + x181 * x37
        + x184 * x64
    )
    x186 = x175 * x34
    x187 = x175 * x47
    x188 = x1 * (2.0 * x1 * x18 * x20 * x23 * x43 * x8 - x128 * x8)
    x189 = x13 ** (-3.5)
    x190 = 2.0 * x164 * x189
    x191 = x190 * x6
    x192 = x178 * x191 + 0.5 * x188
    x193 = x1 * (-x15 * (x173 * x5 + x186) + x170 * x45 + x187) + x181 * x64 + x192 * x36
    x194 = x0 * x193 + x185
    x195 = x190 * x34
    x196 = (
        x1 * (2.0 * x1 * x2 * x20 * x23 * x43 * x5 * x54 * x8 - x195 * x5 * x8)
        + x192 * x64
    )
    x197 = x1 * (x14 * x147 * x2 * x8 - x168)
    x198 = x11 * x166
    x199 = x152 * x198
    x200 = x11 * x15
    x201 = x198 * x5
    x202 = x106 * x198
    x203 = x198 * x31
    x204 = x1 * (x11 * x14 * x2 * x45 - x203)
    x205 = 0.5 * x204
    x206 = x11 * x67
    x207 = x206 * x53
    x208 = x201 * x63 + x207
    x209 = x11 * x53
    x210 = x180 * x209 + x205 + x208 * x64
    x211 = x1 * (x11 * x14 * x2 * x99 - x202)
    x212 = 0.5 * x211
    x213 = x117 * x200 + x123 * x201
    x214 = x208 * x37 + x212 + x213 * x64
    x215 = (
        x1 * (x111 * x200 - x15 * (x103 * x200 + x202 * x5) + x201 * x99)
        + x210 * x37
        + x214 * x64
    )
    x216 = x206 * x34
    x217 = x206 * x47
    x218 = x1 * (2.0 * x1 * x11 * x18 * x20 * x23 * x43 - x11 * x128)
    x219 = 0.5 * x218
    x220 = x191 * x209 + x219
    x221 = x1 * (-x15 * (x203 * x5 + x216) + x201 * x45 + x217) + x210 * x64 + x220 * x36
    x222 = x0 * x221 + x215
    x223 = (
        x1 * (2.0 * x1 * x11 * x2 * x20 * x23 * x43 * x5 * x54 - x11 * x195 * x5)
        + x220 * x64
    )
    x224 = x1 * (x11 * x14 * x147 * x2 - x199)
    x225 = 0.5 * x224
    x226 = x166 * x9
    x227 = -x15 * (x101 + x106 * x226) + x226 * x99 + x93
    x228 = x53 * x56
    x229 = x228 * x9 + x52
    x230 = x229 * x36
    x231 = x226 * x63 + x59
    x232 = x230 + x231 * x64
    x233 = x231 * x36
    x234 = x115 + x123 * x226
    x235 = 2.0 * x233 + x234 * x64
    x236 = x227 * x51 + x232 * x37 + x235 * x64
    x237 = x130 - x15 * (x131 + x226 * x31) + x226 * x45
    x238 = x230 * x64 + x232 * x64 + x237 * x51
    x239 = x0 * x238 + x236
    x240 = x134 + x136 * x9 - x15 * (x128 * x9 + x135)
    x241 = x166 * x6
    x242 = x229 * x241 + x240 * x51
    x243 = x144 + x147 * x226 - x15 * (x149 + x152 * x226)
    x244 = x234 * x36
    x245 = x158 + x163 * x226
    x246 = x11 * x8
    x247 = x2**3
    x248 = x247 / x13**3
    x249 = x246 * x248
    x250 = x1 * (-x106 * x249 + x11 * x164 * x165 * x8 * x99)
    x251 = x249 * x5
    x252 = x246 * x53
    x253 = x179 * x252
    x254 = x251 * x63 + x253
    x255 = x11 * x167
    x256 = x117 * x255 + x123 * x251
    x257 = 0.5 * x250 + x254 * x37 + x256 * x64
    x258 = x11 * x248
    x259 = x1 * (x11 * x164 * x165 * x45 * x8 - x172 * x258)
    x260 = x164 * x189 * x252 * x37 * x5 + x254 * x64 + 0.5 * x259
    x261 = x0 * x260 + x257
    x262 = x1 * (2.0 * x1 * x11 * x2 * x20 * x23 * x43 * x54 * x8 - x195 * x246)
    x263 = 2.0 * x13 ** (-4.5) * x247 * x252 * x6 + 0.5 * x262
    x264 = x1 * (x11 * x147 * x164 * x165 * x8 - x152 * x249)
    x265 = x12 * x166
    x266 = -x15 * (x101 + x106 * x265) + x265 * x99 + x93
    x267 = x266 * x51
    x268 = x12 * x228 + x52
    x269 = x268 * x36
    x270 = x265 * x63 + x59
    x271 = x269 + x270 * x64
    x272 = x270 * x36
    x273 = 2.0 * x272
    x274 = x115 + x123 * x265
    x275 = x273 + x274 * x64
    x276 = x267 + x271 * x37 + x275 * x64
    x277 = x130 - x15 * (x131 + x265 * x31) + x265 * x45
    x278 = x277 * x51
    x279 = x269 * x64 + x271 * x64 + x278
    x280 = x0 * x279 + x276
    x281 = x12 * x136 + x134 - x15 * (x12 * x128 + x135)
    x282 = x281 * x51
    x283 = x241 * x268 + x282
    x284 = x144 + x147 * x265 - x15 * (x149 + x152 * x265)
    x285 = x284 * x51
    x286 = x274 * x36
    x287 = 3.0 * x286
    x288 = x158 + x163 * x265
    x289 = x169 * x231 + x174
    x290 = x289 * x36
    x291 = x169 * x234 + x182
    x292 = 2.0 * x290 + x291 * x64
    x293 = x169 * x229 + x188
    x294 = x293 * x36
    x295 = x289 * x64 + x294
    x296 = x0 * x295 + x292
    x297 = x0 * x64
    x298 = x291 * x36
    x299 = x169 * x245 + x197
    x300 = x258 * x9
    x301 = x205 + x300 * x63
    x302 = x301 * x36
    x303 = x123 * x300 + x212
    x304 = 2.0 * x302 + x303 * x64
    x305 = x190 * x209 * x9 + x219
    x306 = x305 * x36
    x307 = x301 * x64 + x306
    x308 = x0 * x307 + x304
    x309 = x303 * x36
    x310 = x163 * x300 + x225
    x311 = x169 * x273 + x170 * x274
    x312 = x169 * x269
    x313 = x170 * x270 + x312
    x314 = x0 * x313 + x311
    x315 = x170 * x268
    x316 = x200 * x270 + x204
    x317 = x316 * x36
    x318 = x200 * x274 + x211
    x319 = 2.0 * x317 + x318 * x64
    x320 = x200 * x268 + x218
    x321 = x320 * x36
    x322 = x316 * x64 + x321
    x323 = x0 * x322 + x319
    x324 = x318 * x36
    x325 = x200 * x288 + x224
    x326 = x113 * x227 + x169 * x291
    x327 = x113 * x237 + x169 * x289
    x328 = x0 * x327 + x326
    x329 = x113 * x240 + x169 * x293
    x330 = x169 * x303 + x250
    x331 = x169 * x301 + x259
    x332 = x0 * x331 + x330
    x333 = x169 * x305 + x262
    x334 = x226 * x274 + x267
    x335 = x226 * x270 + x278
    x336 = x0 * x335 + x334
    x337 = x226 * x268 + x282
    x338 = x169 * x318
    x339 = x169 * x316
    x340 = x0 * x339 + x338
    x341 = x169 * x320
    x342 = x113 * x266 + x200 * x318
    x343 = x113 * x277 + x200 * x316
    x344 = x0 * x343 + x342
    x345 = x113 * x281 + x200 * x320
    x346 = -x7 - A[1]
    x347 = -2.0 * x1 * x20 * x23 * x27 * x29 * x3 * x346 + x26 * x8
    x348 = -x347
    x349 = x166 * x5
    x350 = -2.0 * x1 * x20 * x23 * x27 * x3 * x346 * x43 + x42 * x8
    x351 = -x350
    x352 = x15 * x348
    x353 = x51 * (-x350 - x352)
    x354 = -2.0 * x1 * x17 * x20 * x23 * x27 * x3 * x346 + x61 * x8
    x355 = -x354
    x356 = x241 * x355 + x353
    x357 = x1 * (x14 * x2 * x351 * x5 - x348 * x349) + x356 * x64
    x358 = -2.0 * x1 * x20 * x23 * x27 * x3 * x346 * x72 + x8 * x81
    x359 = -x358
    x360 = x351 * x87
    x361 = -x28 * x359 + x360 * x5
    x362 = -x361
    x363 = -2.0 * x1 * x20 * x23 * x27 * x3 * x346 * x75 + x74 * x8
    x364 = -x363
    x365 = x359 * x87
    x366 = -x28 * x364 + x365 * x5
    x367 = x51 * (-x15 * x362 - x366)
    x368 = x348 * x87
    x369 = -x28 * x351 + x368 * x5
    x370 = -x369
    x371 = x15 * x370
    x372 = x51 * (-x361 - x371)
    x373 = x348 * x36
    x374 = x355 * x87
    x375 = x28 * x348 - x374 * x5
    x376 = x15 * x375
    x377 = x373 + x376 * x5
    x378 = x15 * x377
    x379 = x351 * x36
    x380 = x371 * x5 + x379
    x381 = x51 * (-x369 - x376)
    x382 = x355 * x36
    x383 = 2.0 * x1 * x20 * x23 * x27 * x3 * x346 * x60 - x120 * x8
    x384 = x383 * x87
    x385 = x28 * x355 - x384 * x5
    x386 = x382 + x385 * x64
    x387 = x381 + x382 * x64 + x386 * x64
    x388 = x1 * (-x378 + x380) + x356 * x36 + x387 * x64
    x389 = (
        x113 * (-x15 * (x372 + x373 * x64 + x378 * x5) + x367 + x379 * x64 + x380 * x64)
        + x357 * x36
        + x388 * x64
    )
    x390 = x132 * x21 + x389
    x391 = x51 * (-x15 * x359 - x363)
    x392 = x15 * x351
    x393 = x51 * (-x358 - x392)
    x394 = x113 * (-x15 * (x241 * x348 + x393) + x241 * x351 + x391) + x357 * x64
    x395 = x137 * x21 + x394
    x396 = -x363 - x365
    x397 = -x358 - x360
    x398 = x397 * x71
    x399 = x142 * x370
    x400 = x51 * (
        -x142 * x362 - x15 * (x28 * x362 + x398 - x399) - x28 * x366 + x396 * x71
    )
    x401 = -x350 - x368
    x402 = x401 * x71
    x403 = x142 * x375
    x404 = x28 * x370 + x402 - x403
    x405 = x15 * x404
    x406 = x51 * (x28 * x362 + x397 * x71 - x399 - x405)
    x407 = x36 * x375
    x408 = 2.0 * x407
    x409 = x71 * (-x347 - x374)
    x410 = -x142 * x385 + x28 * x375 + x409
    x411 = x15 * x410
    x412 = x15 * (x408 + x411 * x5)
    x413 = x36 * x370
    x414 = 2.0 * x413
    x415 = x405 * x5 + x414
    x416 = x51 * (x28 * x370 + x401 * x71 - x403 - x411)
    x417 = x36 * x385
    x418 = 2.0 * x417
    x419 = x71 * (-x354 - x384)
    x420 = 2.0 * x1 * x119 * x20 * x23 * x27 * x3 * x346 - x162 * x8
    x421 = -x142 * (-x142 * x420 + x28 * x383) + x28 * x385 + x419
    x422 = x110 + x371 * x8
    x423 = x37 * x422
    x424 = x102 + x376 * x8
    x425 = x37 * x424
    x426 = x15 * (x150 + x411 * x8)
    x427 = x155 + x405 * x8
    x428 = x392 * x8 + x48
    x429 = x36 * x428
    x430 = x352 * x8 + x39
    x431 = x36 * x430
    x432 = x15 * x424
    x433 = x15 * x430
    x434 = x1 * (x428 - x433)
    x435 = x169 * x355 + x65
    x436 = x241 * x435 + 0.5 * x434
    x437 = x1 * (x422 - x432)
    x438 = x36 * x435
    x439 = x116 + x169 * x385
    x440 = x438 + x439 * x64
    x441 = 0.5 * x437 + x438 * x64 + x440 * x64
    x442 = x1 * (-x15 * (x431 + x432 * x5) + x422 * x64 + x429) + x36 * x436 + x441 * x64
    x443 = x193 * x21 + x442
    x444 = x1 * (x14 * x2 * x428 * x5 - x349 * x430) + x436 * x64
    x445 = x196 * x21 + x444
    x446 = x1 * (-x426 + x427)
    x447 = x37 * x439
    x448 = x159 + x169 * x421
    x449 = x198 * x410
    x450 = x200 * x408
    x451 = x200 * x414
    x452 = x198 * x375
    x453 = x200 * x373
    x454 = x200 * x379
    x455 = x1 * (x11 * x14 * x2 * x351 - x198 * x348)
    x456 = 0.5 * x455
    x457 = x258 * x6
    x458 = x355 * x457 + x456
    x459 = x1 * (x11 * x14 * x2 * x370 - x452)
    x460 = 0.5 * x459
    x461 = x200 * x382
    x462 = x201 * x385 + x461
    x463 = x201 * x382 + x460 + x462 * x64
    x464 = x1 * (-x15 * (x452 * x5 + x453) + x201 * x370 + x454) + x36 * x458 + x463 * x64
    x465 = x21 * x221 + x464
    x466 = x258 * x5
    x467 = x1 * (x11 * x164 * x165 * x351 * x5 - x348 * x466) + x458 * x64
    x468 = x21 * x223 + x467
    x469 = x1 * (x11 * x14 * x2 * x404 - x449)
    x470 = 0.5 * x469
    x471 = x200 * x418
    x472 = x110 * x169 - x15 * (x102 * x169 + x372 + x432 * x8) + x169 * x422 + x367
    x473 = x169 * x435 + x176 + x353
    x474 = x36 * x473
    x475 = x116 * x169 + x169 * x439 + x381
    x476 = x474 + x475 * x64
    x477 = x472 * x51 + x474 * x64 + x476 * x64
    x478 = x21 * x238 + x477
    x479 = -x15 * (x186 + x393 + x433 * x8) + x169 * x428 + x187 + x391
    x480 = x241 * x473 + x479 * x51
    x481 = x21 * x242 + x480
    x482 = -x15 * (x150 * x169 + x406 + x426 * x8) + x155 * x169 + x169 * x427 + x400
    x483 = x37 * x475
    x484 = x159 * x169 + x169 * x448 + x416
    x485 = x102 * x200
    x486 = x110 * x200
    x487 = x1 * (-x15 * (x255 * x375 + x485) + x255 * x370 + x486)
    x488 = x207 + x255 * x355
    x489 = x36 * x488
    x490 = x116 * x200
    x491 = x255 * x385 + x490
    x492 = x489 + x491 * x64
    x493 = 0.5 * x487 + x489 * x64 + x492 * x64
    x494 = x21 * x260 + x493
    x495 = x1 * (-x15 * (x216 + x255 * x348) + x217 + x255 * x351)
    x496 = x241 * x488 + 0.5 * x495
    x497 = x21 * x263 + x496
    x498 = x150 * x200
    x499 = x155 * x200
    x500 = x1 * (-x15 * (x255 * x410 + x498) + x255 * x404 + x499)
    x501 = x37 * x491
    x502 = x159 * x200
    x503 = x255 * x421 + x502
    x504 = -x15 * (x265 * x375 + x372) + x265 * x370 + x367
    x505 = x504 * x51
    x506 = x265 * x355 + x353
    x507 = x36 * x506
    x508 = x265 * x385 + x381
    x509 = x507 + x508 * x64
    x510 = x505 + x507 * x64 + x509 * x64
    x511 = x21 * x279 + x510
    x512 = -x15 * (x265 * x348 + x393) + x265 * x351 + x391
    x513 = x51 * x512
    x514 = x241 * x506 + x513
    x515 = x21 * x283 + x514
    x516 = -x15 * (x265 * x410 + x406) + x265 * x404 + x400
    x517 = x51 * x516
    x518 = x36 * x508
    x519 = 2.0 * x518
    x520 = x265 * x421 + x416
    x521 = x169 * x473 + x230 + x434
    x522 = x36 * x521
    x523 = x169 * x475 + x233 + x437
    x524 = x522 + x523 * x64
    x525 = x21 * x295 + x524
    x526 = x521 * x64
    x527 = x21 * x64
    x528 = x293 * x527 + x526
    x529 = x37 * x523
    x530 = x169 * x484 + x244 + x446
    x531 = x169 * x488 + x253 + x456
    x532 = x36 * x531
    x533 = x116 * x255 + x169 * x491 + x460
    x534 = x532 + x533 * x64
    x535 = x21 * x307 + x534
    x536 = x531 * x64
    x537 = x305 * x527 + x536
    x538 = x37 * x533
    x539 = x159 * x255 + x169 * x503 + x470
    x540 = x169 * x506 + x269
    x541 = x36 * x540
    x542 = x169 * x508 + x272
    x543 = x541 + x542 * x64
    x544 = x21 * x313 + x543
    x545 = x540 * x64
    x546 = x21 * x315 + x545
    x547 = x37 * x542
    x548 = x169 * x520 + x286
    x549 = x200 * x506 + x455
    x550 = x36 * x549
    x551 = x200 * x508 + x459
    x552 = x550 + x551 * x64
    x553 = x21 * x322 + x552
    x554 = x549 * x64
    x555 = x320 * x527 + x554
    x556 = x36 * x551
    x557 = 2.0 * x556
    x558 = x200 * x520 + x469
    x559 = x113 * x472 + x169 * x523 + x290
    x560 = x21 * x327 + x559
    x561 = x113 * x479 + x169 * x521 + x294
    x562 = x21 * x329 + x561
    x563 = x169 * x533 + x302 + x487
    x564 = x21 * x331 + x563
    x565 = x169 * x531 + x306 + x495
    x566 = x21 * x333 + x565
    x567 = x169 * x272 + x169 * x542 + x505
    x568 = x21 * x335 + x567
    x569 = x169 * x540 + x312 + x513
    x570 = x21 * x337 + x569
    x571 = x169 * x551 + x317
    x572 = x21 * x339 + x571
    x573 = x169 * x549 + x321
    x574 = x21 * x341 + x573
    x575 = x113 * x504 + x200 * x551
    x576 = x21 * x343 + x575
    x577 = x113 * x512 + x200 * x549
    x578 = x21 * x345 + x577
    x579 = -x10 - A[2]
    x580 = -2.0 * x1 * x20 * x23 * x27 * x29 * x3 * x579 + x11 * x26
    x581 = -x580
    x582 = -2.0 * x1 * x20 * x23 * x27 * x3 * x43 * x579 + x11 * x42
    x583 = -x582
    x584 = x15 * x581
    x585 = x51 * (-x582 - x584)
    x586 = -2.0 * x1 * x17 * x20 * x23 * x27 * x3 * x579 + x11 * x61
    x587 = -x586
    x588 = x241 * x587 + x585
    x589 = x1 * (x14 * x2 * x5 * x583 - x349 * x581) + x588 * x64
    x590 = -2.0 * x1 * x20 * x23 * x27 * x3 * x579 * x72 + x11 * x81
    x591 = -x590
    x592 = x583 * x87
    x593 = -x28 * x591 + x5 * x592
    x594 = -x593
    x595 = -2.0 * x1 * x20 * x23 * x27 * x3 * x579 * x75 + x11 * x74
    x596 = -x595
    x597 = x591 * x87
    x598 = -x28 * x596 + x5 * x597
    x599 = x51 * (-x15 * x594 - x598)
    x600 = x581 * x87
    x601 = -x28 * x583 + x5 * x600
    x602 = -x601
    x603 = x15 * x602
    x604 = x51 * (-x593 - x603)
    x605 = x36 * x581
    x606 = x587 * x87
    x607 = x28 * x581 - x5 * x606
    x608 = x15 * x607
    x609 = x5 * x608 + x605
    x610 = x15 * x609
    x611 = x36 * x583
    x612 = x5 * x603 + x611
    x613 = x51 * (-x601 - x608)
    x614 = x36 * x587
    x615 = 2.0 * x1 * x20 * x23 * x27 * x3 * x579 * x60 - x11 * x120
    x616 = x615 * x87
    x617 = x28 * x587 - x5 * x616
    x618 = x614 + x617 * x64
    x619 = x613 + x614 * x64 + x618 * x64
    x620 = x1 * (-x610 + x612) + x36 * x588 + x619 * x64
    x621 = (
        x113 * (-x15 * (x5 * x610 + x604 + x605 * x64) + x599 + x611 * x64 + x612 * x64)
        + x36 * x589
        + x620 * x64
    )
    x622 = x132 * x22 + x621
    x623 = x51 * (-x15 * x591 - x595)
    x624 = x15 * x583
    x625 = x51 * (-x590 - x624)
    x626 = x113 * (-x15 * (x241 * x581 + x625) + x241 * x583 + x623) + x589 * x64
    x627 = x137 * x22 + x626
    x628 = -x595 - x597
    x629 = -x628 * x71
    x630 = -x590 - x592
    x631 = x630 * x71
    x632 = x142 * x602
    x633 = x51 * (-x142 * x594 - x15 * (x28 * x594 + x631 - x632) - x28 * x598 - x629)
    x634 = -x630 * x71
    x635 = -x582 - x600
    x636 = x635 * x71
    x637 = x142 * x607
    x638 = x28 * x602 + x636 - x637
    x639 = x15 * x638
    x640 = x51 * (x28 * x594 - x632 - x634 - x639)
    x641 = x36 * x607
    x642 = 2.0 * x641
    x643 = x71 * (-x580 - x606)
    x644 = -x142 * x617 + x28 * x607 + x643
    x645 = x15 * x644
    x646 = x15 * (x5 * x645 + x642)
    x647 = x36 * x602
    x648 = 2.0 * x647
    x649 = x5 * x639 + x648
    x650 = -x635 * x71
    x651 = x51 * (x28 * x602 - x637 - x645 - x650)
    x652 = x36 * x617
    x653 = 2.0 * x652
    x654 = x71 * (-x586 - x616)
    x655 = 2.0 * x1 * x119 * x20 * x23 * x27 * x3 * x579 - x11 * x162
    x656 = -x142 * (-x142 * x655 + x28 * x615) + x28 * x617 + x654
    x657 = x167 * x644
    x658 = x167 * x607
    x659 = x169 * x605
    x660 = x169 * x611
    x661 = x1 * (x14 * x2 * x583 * x8 - x167 * x581)
    x662 = x248 * x8
    x663 = x6 * x662
    x664 = x587 * x663 + 0.5 * x661
    x665 = x1 * (x14 * x2 * x602 * x8 - x658)
    x666 = x169 * x614
    x667 = x170 * x617 + x666
    x668 = x170 * x614 + x64 * x667 + 0.5 * x665
    x669 = x1 * (-x15 * (x5 * x658 + x659) + x170 * x602 + x660) + x36 * x664 + x64 * x668
    x670 = x193 * x22 + x669
    x671 = x5 * x662
    x672 = x1 * (x164 * x165 * x5 * x583 * x8 - x581 * x671) + x64 * x664
    x673 = x196 * x22 + x672
    x674 = x1 * (x14 * x2 * x638 * x8 - x657)
    x675 = x11 * x603 + x110
    x676 = x36 * x675
    x677 = 2.0 * x676
    x678 = x102 + x11 * x608
    x679 = x36 * x678
    x680 = 2.0 * x679
    x681 = x11 * x645 + x150
    x682 = x15 * x681
    x683 = x11 * x639 + x155
    x684 = x11 * x624 + x48
    x685 = x36 * x684
    x686 = x11 * x584 + x39
    x687 = x36 * x686
    x688 = x15 * x678
    x689 = x15 * x686
    x690 = x1 * (x684 - x689)
    x691 = 0.5 * x690
    x692 = x200 * x587 + x65
    x693 = x241 * x692 + x691
    x694 = x1 * (x675 - x688)
    x695 = 0.5 * x694
    x696 = x36 * x692
    x697 = x116 + x200 * x617
    x698 = x64 * x697 + x696
    x699 = x64 * x696 + x64 * x698 + x695
    x700 = x1 * (-x15 * (x5 * x688 + x687) + x64 * x675 + x685) + x36 * x693 + x64 * x699
    x701 = x22 * x221 + x700
    x702 = x1 * (x14 * x2 * x5 * x684 - x349 * x686) + x64 * x693
    x703 = x22 * x223 + x702
    x704 = x1 * (-x682 + x683)
    x705 = 0.5 * x704
    x706 = x36 * x697
    x707 = 2.0 * x706
    x708 = x159 + x200 * x656
    x709 = -x15 * (x226 * x607 + x604) + x226 * x602 + x599
    x710 = x226 * x587 + x585
    x711 = x36 * x710
    x712 = x226 * x617 + x613
    x713 = x64 * x712 + x711
    x714 = x51 * x709 + x64 * x711 + x64 * x713
    x715 = x22 * x238 + x714
    x716 = -x15 * (x226 * x581 + x625) + x226 * x583 + x623
    x717 = x241 * x710 + x51 * x716
    x718 = x22 * x242 + x717
    x719 = -x15 * (x226 * x644 + x640) + x226 * x638 + x633
    x720 = x36 * x712
    x721 = x226 * x656 + x651
    x722 = x1 * (x14 * x2 * x675 * x8 - x167 * x678)
    x723 = x169 * x696
    x724 = x170 * x697 + x723
    x725 = x170 * x696 + x64 * x724 + 0.5 * x722
    x726 = x22 * x260 + x725
    x727 = x1 * (x14 * x2 * x684 * x8 - x167 * x686)
    x728 = x663 * x692 + 0.5 * x727
    x729 = x22 * x263 + x728
    x730 = x1 * (x14 * x2 * x683 * x8 - x167 * x681)
    x731 = -x15 * (x11 * x688 + x485 + x604) + x200 * x675 + x486 + x599
    x732 = x51 * x731
    x733 = x200 * x692 + x207 + x585
    x734 = x36 * x733
    x735 = x200 * x697 + x490 + x613
    x736 = x64 * x735 + x734
    x737 = x64 * x734 + x64 * x736 + x732
    x738 = x22 * x279 + x737
    x739 = -x15 * (x11 * x689 + x216 + x625) + x200 * x684 + x217 + x623
    x740 = x51 * x739
    x741 = x241 * x733 + x740
    x742 = x22 * x283 + x741
    x743 = -x15 * (x11 * x682 + x498 + x640) + x200 * x683 + x499 + x633
    x744 = x51 * x743
    x745 = x36 * x735
    x746 = 2.0 * x745
    x747 = x200 * x708 + x502 + x651
    x748 = x169 * x710 + x661
    x749 = x36 * x748
    x750 = x169 * x712 + x665
    x751 = x64 * x750 + x749
    x752 = x22 * x295 + x751
    x753 = x64 * x748
    x754 = x22 * x64
    x755 = x293 * x754 + x753
    x756 = x36 * x750
    x757 = x169 * x721 + x674
    x758 = x226 * x692 + x691
    x759 = x36 * x758
    x760 = x226 * x697 + x695
    x761 = x64 * x760 + x759
    x762 = x22 * x307 + x761
    x763 = x64 * x758
    x764 = x305 * x754 + x763
    x765 = x36 * x760
    x766 = x226 * x708 + x705
    x767 = x169 * x734
    x768 = x170 * x735 + x767
    x769 = x22 * x313 + x768
    x770 = x170 * x733
    x771 = x22 * x315 + x770
    x772 = x200 * x733 + x269 + x690
    x773 = x36 * x772
    x774 = x200 * x735 + x272 + x694
    x775 = x64 * x774 + x773
    x776 = x22 * x322 + x775
    x777 = x64 * x772
    x778 = x320 * x754 + x777
    x779 = x36 * x774
    x780 = 2.0 * x779
    x781 = x200 * x747 + x286 + x704
    x782 = x113 * x709 + x169 * x750
    x783 = x22 * x327 + x782
    x784 = x113 * x716 + x169 * x748
    x785 = x22 * x329 + x784
    x786 = x169 * x760 + x722
    x787 = x22 * x331 + x786
    x788 = x169 * x758 + x727
    x789 = x22 * x333 + x788
    x790 = x226 * x735 + x732
    x791 = x22 * x335 + x790
    x792 = x226 * x733 + x740
    x793 = x22 * x337 + x792
    x794 = x169 * x774
    x795 = x22 * x339 + x794
    x796 = x169 * x772
    x797 = x22 * x341 + x796
    x798 = x113 * x731 + x200 * x774 + x317
    x799 = x22 * x343 + x798
    x800 = x113 * x739 + x200 * x772 + x321
    x801 = x22 * x345 + x800
    x802 = x104 + x346 * x348 - x374 * x8
    x803 = x368 * x8
    x804 = x346 * x351 - x803 + x96
    x805 = x15 * x802
    x806 = x51 * (-x114 + x346 * x351 - x803 - x805)
    x807 = x118 + x346 * x355 - x384 * x8
    x808 = x241 * x807 + x806
    x809 = x1 * (x14 * x2 * x5 * x804 - x349 * x802) + x64 * x808
    x810 = x360 * x8
    x811 = x346 * x359 - x810 + x84
    x812 = x365 * x8
    x813 = x51 * (-x15 * x811 + x346 * x364 - x78 - x812)
    x814 = x15 * x804
    x815 = x51 * (x346 * x359 - x810 - x814 - x94)
    x816 = x113 * (-x15 * (x241 * x802 + x815) + x241 * x804 + x813) + x64 * x809
    x817 = x21 * x394 + x816
    x818 = x21 * x395 + x817
    x819 = x139 + x346 * x364 - x812
    x820 = x142 * x804 - x28 * x811
    x821 = x51 * (-x142 * x811 + x15 * x820 + x28 * x819)
    x822 = x142 * x802 - x28 * x804
    x823 = -x822
    x824 = x15 * x823
    x825 = x51 * (-x820 - x824)
    x826 = x36 * x802
    x827 = -x142 * x807 + x28 * x802
    x828 = x15 * x827
    x829 = x15 * (x5 * x828 + x826)
    x830 = x36 * x804
    x831 = x5 * x824 + x830
    x832 = x51 * (-x822 - x828)
    x833 = x36 * x807
    x834 = x8 * x87
    x835 = x161 + x346 * x383 - x420 * x834
    x836 = -x142 * x835 + x28 * x807
    x837 = 2.0 * x379
    x838 = x8 * x814 + x837
    x839 = x36 * x838
    x840 = 2.0 * x373
    x841 = x8 * x805 + x840
    x842 = x36 * x841
    x843 = x15 * (x408 + x8 * x828)
    x844 = x414 + x8 * x824
    x845 = x15 * x841
    x846 = x1 * (x838 - x845)
    x847 = 2.0 * x382
    x848 = x169 * x807 + x847
    x849 = x241 * x848 + 0.5 * x846
    x850 = x1 * (x14 * x2 * x5 * x838 - x349 * x841) + x64 * x849
    x851 = x21 * x444 + x850
    x852 = x21 * x445 + x851
    x853 = x1 * (-x843 + x844)
    x854 = x36 * x848
    x855 = x169 * x836 + x418
    x856 = x198 * x827
    x857 = x200 * x826
    x858 = x200 * x830
    x859 = x1 * (x11 * x14 * x2 * x804 - x198 * x802)
    x860 = 0.5 * x859
    x861 = x457 * x807 + x860
    x862 = x1 * (x11 * x164 * x165 * x5 * x804 - x466 * x802) + x64 * x861
    x863 = x21 * x467 + x862
    x864 = x21 * x468 + x863
    x865 = x1 * (x11 * x14 * x2 * x823 - x856)
    x866 = 0.5 * x865
    x867 = x200 * x833
    x868 = -x15 * (2.0 * x431 + x8 * x845 + x815) + x169 * x838 + 2.0 * x429 + x813
    x869 = x169 * x848 + 2.0 * x438 + x806
    x870 = x241 * x869 + x51 * x868
    x871 = x21 * x480 + x870
    x872 = x21 * x481 + x871
    x873 = -x15 * (x425 + x8 * x843 + x825) + x169 * x844 + x423 + x821
    x874 = x36 * x869
    x875 = x169 * x855 + x447 + x832
    x876 = x1 * (-x15 * (x200 * x840 + x255 * x802) + x200 * x837 + x255 * x804)
    x877 = x200 * x847 + x255 * x807
    x878 = x241 * x877 + 0.5 * x876
    x879 = x21 * x496 + x878
    x880 = x21 * x497 + x879
    x881 = x1 * (-x15 * (x255 * x827 + x450) + x255 * x823 + x451)
    x882 = x36 * x877
    x883 = x255 * x836 + x471
    x884 = -x15 * (x265 * x802 + x815) + x265 * x804 + x813
    x885 = x51 * x884
    x886 = x265 * x807 + x806
    x887 = x241 * x886 + x885
    x888 = x21 * x514 + x887
    x889 = x21 * x515 + x888
    x890 = -x15 * (x265 * x827 + x825) + x265 * x823 + x821
    x891 = x51 * x890
    x892 = x36 * x886
    x893 = x265 * x836 + x832
    x894 = x169 * x869 + 2.0 * x474 + x846
    x895 = x36 * x894
    x896 = x64 * x894
    x897 = x21 * x526 + x896
    x898 = x21 * x528 + x897
    x899 = x169 * x875 + x483 + x853
    x900 = x169 * x877 + 2.0 * x489 + x860
    x901 = x36 * x900
    x902 = x64 * x900
    x903 = x21 * x536 + x902
    x904 = x21 * x537 + x903
    x905 = x169 * x883 + x501 + x866
    x906 = x169 * x886 + 2.0 * x507
    x907 = x36 * x906
    x908 = x64 * x906
    x909 = x21 * x545 + x908
    x910 = x21 * x546 + x909
    x911 = x169 * x893 + x519
    x912 = x200 * x886 + x859
    x913 = x36 * x912
    x914 = x64 * x912
    x915 = x21 * x554 + x914
    x916 = x21 * x555 + x915
    x917 = x200 * x893 + x865
    x918 = x113 * x868 + x169 * x894 + 2.0 * x522
    x919 = x21 * x561 + x918
    x920 = x21 * x562 + x919
    x921 = x169 * x900 + 2.0 * x532 + x876
    x922 = x21 * x565 + x921
    x923 = x21 * x566 + x922
    x924 = x169 * x906 + 2.0 * x541 + x885
    x925 = x21 * x569 + x924
    x926 = x21 * x570 + x925
    x927 = x169 * x912 + 2.0 * x550
    x928 = x21 * x573 + x927
    x929 = x21 * x574 + x928
    x930 = x113 * x884 + x200 * x912
    x931 = x21 * x577 + x930
    x932 = x21 * x578 + x931
    x933 = x346 * x581 - x606 * x8
    x934 = -x346 * x583 + x600 * x8
    x935 = -x934
    x936 = x15 * x933
    x937 = x51 * (-x934 - x936)
    x938 = x346 * x587 - x616 * x8
    x939 = x241 * x938 + x937
    x940 = x1 * (x14 * x2 * x5 * x935 - x349 * x933) + x64 * x939
    x941 = -x346 * x591 + x592 * x8
    x942 = -x941
    x943 = -x346 * x596 + x597 * x8
    x944 = x51 * (-x15 * x942 - x943)
    x945 = x15 * x935
    x946 = x51 * (-x941 - x945)
    x947 = x113 * (-x15 * (x241 * x933 + x946) + x241 * x935 + x944) + x64 * x940
    x948 = x22 * x394 + x947
    x949 = x21 * x627 + x948
    x950 = -x943
    x951 = x142 * x935 - x28 * x942
    x952 = x51 * (-x142 * x942 + x15 * x951 + x28 * x950)
    x953 = x142 * x933 - x28 * x935
    x954 = -x15 * x953
    x955 = x51 * (-x951 - x954)
    x956 = x36 * x933
    x957 = x15 * (-x142 * x938 + x28 * x933)
    x958 = x15 * (x5 * x957 + x956)
    x959 = x36 * x935
    x960 = x5 * x954 + x959
    x961 = x51 * (-x953 - x957)
    x962 = x36 * x938
    x963 = x346 * x615 - x655 * x834
    x964 = -x142 * x963 + x28 * x938
    x965 = x611 + x8 * x945
    x966 = x36 * x965
    x967 = x605 + x8 * x936
    x968 = x36 * x967
    x969 = x15 * (x641 + x8 * x957)
    x970 = x647 + x8 * x954
    x971 = x15 * x967
    x972 = x1 * (x965 - x971)
    x973 = x169 * x938 + x614
    x974 = x241 * x973 + 0.5 * x972
    x975 = x1 * (x14 * x2 * x5 * x965 - x349 * x967) + x64 * x974
    x976 = x22 * x444 + x975
    x977 = x21 * x673 + x976
    x978 = x1 * (-x969 + x970)
    x979 = x36 * x973
    x980 = x169 * x964 + x652
    x981 = x11 * x945 + x379
    x982 = x36 * x981
    x983 = x11 * x936 + x373
    x984 = x36 * x983
    x985 = x15 * (x11 * x957 + x407)
    x986 = x11 * x954 + x413
    x987 = x15 * x983
    x988 = x1 * (x981 - x987)
    x989 = 0.5 * x988
    x990 = x200 * x938 + x382
    x991 = x241 * x990 + x989
    x992 = x1 * (x14 * x2 * x5 * x981 - x349 * x983) + x64 * x991
    x993 = x22 * x467 + x992
    x994 = x21 * x703 + x993
    x995 = x1 * (-x985 + x986)
    x996 = 0.5 * x995
    x997 = x36 * x990
    x998 = x200 * x964 + x417
    x999 = -x15 * (x659 + x8 * x971 + x946) + x169 * x965 + x660 + x944
    x1000 = x169 * x973 + x666 + x937
    x1001 = x1000 * x241 + x51 * x999
    x1002 = x1001 + x22 * x480
    x1003 = x1002 + x21 * x718
    x1004 = -x15 * (x169 * x641 + x8 * x969 + x955) + x169 * x647 + x169 * x970 + x952
    x1005 = x1000 * x36
    x1006 = x169 * x652 + x169 * x980 + x961
    x1007 = x1 * (-x15 * (x687 + x8 * x987) + x169 * x981 + x685)
    x1008 = x169 * x990 + x696
    x1009 = 0.5 * x1007 + x1008 * x241
    x1010 = x1009 + x22 * x496
    x1011 = x1010 + x21 * x729
    x1012 = x1 * (-x15 * (x679 + x8 * x985) + x169 * x986 + x676)
    x1013 = x1008 * x36
    x1014 = x169 * x998 + x706
    x1015 = -x15 * (x11 * x987 + x453 + x946) + x200 * x981 + x454 + x944
    x1016 = x1015 * x51
    x1017 = x200 * x990 + x461 + x937
    x1018 = x1016 + x1017 * x241
    x1019 = x1018 + x22 * x514
    x1020 = x1019 + x21 * x742
    x1021 = -x15 * (x11 * x985 + x200 * x407 + x955) + x200 * x413 + x200 * x986 + x952
    x1022 = x1021 * x51
    x1023 = x1017 * x36
    x1024 = x200 * x417 + x200 * x998 + x961
    x1025 = x1000 * x169 + x711 + x972
    x1026 = x1025 * x36
    x1027 = x1025 * x64
    x1028 = x1027 + x22 * x526
    x1029 = x1028 + x21 * x755
    x1030 = x1006 * x169 + x720 + x978
    x1031 = x1008 * x169 + x723 + x989
    x1032 = x1031 * x36
    x1033 = x1031 * x64
    x1034 = x1033 + x22 * x536
    x1035 = x1034 + x21 * x764
    x1036 = x1014 * x169 + x169 * x706 + x996
    x1037 = x1017 * x169 + x734
    x1038 = x1037 * x36
    x1039 = x1037 * x64
    x1040 = x1039 + x22 * x545
    x1041 = x1040 + x21 * x771
    x1042 = x1024 * x169 + x745
    x1043 = x1017 * x200 + x507 + x988
    x1044 = x1043 * x36
    x1045 = x1043 * x64
    x1046 = x1045 + x22 * x554
    x1047 = x1046 + x21 * x778
    x1048 = x1024 * x200 + x518 + x995
    x1049 = x1025 * x169 + x113 * x999 + x749
    x1050 = x1049 + x22 * x561
    x1051 = x1050 + x21 * x785
    x1052 = x1007 + x1031 * x169 + x759
    x1053 = x1052 + x22 * x565
    x1054 = x1053 + x21 * x789
    x1055 = x1016 + x1037 * x169 + x767
    x1056 = x1055 + x22 * x569
    x1057 = x1056 + x21 * x793
    x1058 = x1043 * x169 + x773
    x1059 = x1058 + x22 * x573
    x1060 = x1059 + x21 * x797
    x1061 = x1015 * x113 + x1043 * x200 + x550
    x1062 = x1061 + x22 * x577
    x1063 = x1062 + x21 * x801
    x1064 = x104 - x11 * x606 + x579 * x581
    x1065 = x11 * x600
    x1066 = -x1065 + x579 * x583 + x96
    x1067 = x1064 * x15
    x1068 = x51 * (-x1065 - x1067 - x114 + x579 * x583)
    x1069 = -x11 * x616 + x118 + x579 * x587
    x1070 = x1068 + x1069 * x241
    x1071 = x1 * (-x1064 * x349 + x1066 * x14 * x2 * x5) + x1070 * x64
    x1072 = x11 * x592
    x1073 = -x1072 + x579 * x591 + x84
    x1074 = x11 * x597
    x1075 = x51 * (-x1073 * x15 - x1074 + x579 * x596 - x78)
    x1076 = x1066 * x15
    x1077 = x51 * (-x1072 - x1076 + x579 * x591 - x94)
    x1078 = x1071 * x64 + x113 * (x1066 * x241 + x1075 - x15 * (x1064 * x241 + x1077))
    x1079 = x1078 + x22 * x626
    x1080 = x1079 + x22 * x627
    x1081 = -x1074 + x139 + x579 * x596
    x1082 = x1066 * x142 - x1073 * x28
    x1083 = x51 * (-x1073 * x142 + x1081 * x28 + x1082 * x15)
    x1084 = x1064 * x142 - x1066 * x28
    x1085 = -x1084
    x1086 = x1085 * x15
    x1087 = x51 * (-x1082 - x1086)
    x1088 = x1064 * x36
    x1089 = x1064 * x28 - x1069 * x142
    x1090 = x1089 * x15
    x1091 = x15 * (x1088 + x1090 * x5)
    x1092 = x1066 * x36
    x1093 = x1086 * x5 + x1092
    x1094 = x51 * (-x1084 - x1090)
    x1095 = x1069 * x36
    x1096 = x11 * x87
    x1097 = -x1096 * x655 + x161 + x579 * x615
    x1098 = x1069 * x28 - x1097 * x142
    x1099 = x1089 * x167
    x1100 = x1088 * x169
    x1101 = x1092 * x169
    x1102 = x1 * (-x1064 * x167 + x1066 * x14 * x2 * x8)
    x1103 = x1069 * x663 + 0.5 * x1102
    x1104 = x1 * (-x1064 * x671 + x1066 * x164 * x165 * x5 * x8) + x1103 * x64
    x1105 = x1104 + x22 * x672
    x1106 = x1105 + x22 * x673
    x1107 = x1 * (x1085 * x14 * x2 * x8 - x1099)
    x1108 = x1095 * x169
    x1109 = x1076 * x11 + 2.0 * x611
    x1110 = x1109 * x36
    x1111 = x1067 * x11 + 2.0 * x605
    x1112 = x1111 * x36
    x1113 = x1090 * x11 + x642
    x1114 = x1113 * x15
    x1115 = x1086 * x11 + x648
    x1116 = x1111 * x15
    x1117 = x1 * (x1109 - x1116)
    x1118 = 0.5 * x1117
    x1119 = x1069 * x200 + 2.0 * x614
    x1120 = x1118 + x1119 * x241
    x1121 = x1 * (x1109 * x14 * x2 * x5 - x1111 * x349) + x1120 * x64
    x1122 = x1121 + x22 * x702
    x1123 = x1122 + x22 * x703
    x1124 = x1 * (-x1114 + x1115)
    x1125 = 0.5 * x1124
    x1126 = x1119 * x36
    x1127 = x1098 * x200 + x653
    x1128 = x1066 * x226 + x1075 - x15 * (x1064 * x226 + x1077)
    x1129 = x1068 + x1069 * x226
    x1130 = x1128 * x51 + x1129 * x241
    x1131 = x1130 + x22 * x717
    x1132 = x1131 + x22 * x718
    x1133 = x1083 + x1085 * x226 - x15 * (x1087 + x1089 * x226)
    x1134 = x1129 * x36
    x1135 = x1094 + x1098 * x226
    x1136 = x1 * (x1109 * x14 * x2 * x8 - x1111 * x167)
    x1137 = x1119 * x663 + 0.5 * x1136
    x1138 = x1137 + x22 * x728
    x1139 = x1138 + x22 * x729
    x1140 = x1 * (-x1113 * x167 + x1115 * x14 * x2 * x8)
    x1141 = x1126 * x169
    x1142 = x1075 + x1109 * x200 - x15 * (x1077 + x11 * x1116 + 2.0 * x687) + 2.0 * x685
    x1143 = x1142 * x51
    x1144 = x1068 + x1119 * x200 + 2.0 * x696
    x1145 = x1143 + x1144 * x241
    x1146 = x1145 + x22 * x741
    x1147 = x1146 + x22 * x742
    x1148 = x1083 + x1115 * x200 - x15 * (x1087 + x11 * x1114 + x680) + x677
    x1149 = x1148 * x51
    x1150 = x1144 * x36
    x1151 = x1094 + x1127 * x200 + x707
    x1152 = x1102 + x1129 * x169
    x1153 = x1152 * x36
    x1154 = x1152 * x64
    x1155 = x1154 + x22 * x753
    x1156 = x1155 + x22 * x755
    x1157 = x1107 + x1135 * x169
    x1158 = x1118 + x1119 * x226
    x1159 = x1158 * x36
    x1160 = x1158 * x64
    x1161 = x1160 + x22 * x763
    x1162 = x1161 + x22 * x764
    x1163 = x1125 + x1127 * x226
    x1164 = x1144 * x170
    x1165 = x1164 + x22 * x770
    x1166 = x1165 + x22 * x771
    x1167 = x1150 * x169
    x1168 = x1117 + x1144 * x200 + 2.0 * x734
    x1169 = x1168 * x36
    x1170 = x1168 * x64
    x1171 = x1170 + x22 * x777
    x1172 = x1171 + x22 * x778
    x1173 = x1124 + x1151 * x200 + x746
    x1174 = x1128 * x113 + x1152 * x169
    x1175 = x1174 + x22 * x784
    x1176 = x1175 + x22 * x785
    x1177 = x1136 + x1158 * x169
    x1178 = x1177 + x22 * x788
    x1179 = x1178 + x22 * x789
    x1180 = x1143 + x1144 * x226
    x1181 = x1180 + x22 * x792
    x1182 = x1181 + x22 * x793
    x1183 = x1168 * x169
    x1184 = x1183 + x22 * x796
    x1185 = x1184 + x22 * x797
    x1186 = x113 * x1142 + x1168 * x200 + 2.0 * x773
    x1187 = x1186 + x22 * x800
    x1188 = x1187 + x22 * x801
    x1189 = x804 * x834
    x1190 = x51 * (
        -x15 * (-x1189 + x346 * x811 + 2.0 * x398)
        + x346 * x819
        + 2.0 * x396 * x71
        - x811 * x834
    )
    x1191 = x802 * x834
    x1192 = -x1191 + x346 * x804 + 2.0 * x402
    x1193 = x1192 * x15
    x1194 = x51 * (-x1189 - x1193 + x346 * x811 + 2.0 * x397 * x71)
    x1195 = x346 * x802 + 2.0 * x409 - x807 * x834
    x1196 = x1195 * x15
    x1197 = x51 * (-x1191 - x1196 + x346 * x804 + 2.0 * x401 * x71)
    x1198 = x346 * x807 + 2.0 * x419 - x834 * x835
    x1199 = 3.0 * x826
    x1200 = x1196 * x8 + x1199
    x1201 = 3.0 * x830
    x1202 = x1193 * x8 + x1201
    x1203 = x1200 * x15
    x1204 = x1 * (x1202 - x1203)
    x1205 = 3.0 * x833
    x1206 = x1198 * x169 + x1205
    x1207 = x1 * (x11 * x1192 * x14 * x2 - x1195 * x198)
    x1208 = 0.5 * x1207
    x1209 = x1190 + x1202 * x169 - x15 * (x1194 + x1203 * x8 + 3.0 * x842) + 3.0 * x839
    x1210 = x1197 + x1206 * x169 + 3.0 * x854
    x1211 = x1 * (x1192 * x255 + x1201 * x200 - x15 * (x1195 * x255 + x1199 * x200))
    x1212 = x1198 * x255 + x1205 * x200
    x1213 = x1190 + x1192 * x265 - x15 * (x1194 + x1195 * x265)
    x1214 = x1213 * x51
    x1215 = x1197 + x1198 * x265
    x1216 = x1204 + x1210 * x169 + 3.0 * x874
    x1217 = x1208 + x1212 * x169 + 3.0 * x882
    x1218 = x1215 * x169 + 3.0 * x892
    x1219 = x1207 + x1215 * x200
    x1220 = x834 * x935
    x1221 = x51 * (
        -x15 * (-x1220 + x346 * x942 + x631) + x346 * x950 - x629 - x834 * x942
    )
    x1222 = x834 * x933
    x1223 = -x1222 + x346 * x935 + x636
    x1224 = x1223 * x15
    x1225 = x51 * (-x1220 - x1224 + x346 * x942 - x634)
    x1226 = x346 * x933 + x643 - x834 * x938
    x1227 = x1226 * x15
    x1228 = x51 * (-x1222 - x1227 + x346 * x935 - x650)
    x1229 = x346 * x938 + x654 - x834 * x963
    x1230 = 2.0 * x956
    x1231 = x1227 * x8 + x1230
    x1232 = 2.0 * x959
    x1233 = x1224 * x8 + x1232
    x1234 = x1231 * x15
    x1235 = x1 * (x1233 - x1234)
    x1236 = 2.0 * x962
    x1237 = x1229 * x169 + x1236
    x1238 = x11 * x1227 + x826
    x1239 = x11 * x1224 + x830
    x1240 = x1238 * x15
    x1241 = x1 * (x1239 - x1240)
    x1242 = 0.5 * x1241
    x1243 = x1229 * x200 + x833
    x1244 = x1221 + x1233 * x169 - x15 * (x1225 + x1234 * x8 + 2.0 * x968) + 2.0 * x966
    x1245 = x1228 + x1237 * x169 + 2.0 * x979
    x1246 = 2.0 * x982
    x1247 = 2.0 * x984
    x1248 = x1 * (x1239 * x169 + x1246 - x15 * (x1240 * x8 + x1247))
    x1249 = 2.0 * x997
    x1250 = x1243 * x169 + x1249
    x1251 = x1221 + x1239 * x200 - x15 * (x11 * x1240 + x1225 + x857) + x858
    x1252 = x1251 * x51
    x1253 = x1228 + x1243 * x200 + x867
    x1254 = 2.0 * x1005 + x1235 + x1245 * x169
    x1255 = 2.0 * x1013 + x1242 + x1250 * x169
    x1256 = 2.0 * x1023
    x1257 = x1253 * x169 + x1256
    x1258 = x1241 + x1253 * x200 + x892
    x1259 = 2.0 * x1044
    x1260 = x1066 * x834 - x1073 * x346
    x1261 = x51 * (-x1073 * x834 + x1081 * x346 + x1260 * x15)
    x1262 = x1064 * x834 - x1066 * x346
    x1263 = -x1262
    x1264 = x1263 * x15
    x1265 = x51 * (-x1260 - x1264)
    x1266 = x1064 * x346 - x1069 * x834
    x1267 = x1266 * x15
    x1268 = x51 * (-x1262 - x1267)
    x1269 = x1069 * x346 - x1097 * x834
    x1270 = x1088 + x1267 * x8
    x1271 = x1092 + x1264 * x8
    x1272 = x1270 * x15
    x1273 = x1 * (x1271 - x1272)
    x1274 = x1095 + x1269 * x169
    x1275 = x11 * x1267 + x1230
    x1276 = x11 * x1264 + x1232
    x1277 = x1275 * x15
    x1278 = x1 * (x1276 - x1277)
    x1279 = 0.5 * x1278
    x1280 = x1236 + x1269 * x200
    x1281 = x1101 + x1261 + x1271 * x169 - x15 * (x1100 + x1265 + x1272 * x8)
    x1282 = x1108 + x1268 + x1274 * x169
    x1283 = x1 * (x1110 + x1276 * x169 - x15 * (x1112 + x1277 * x8))
    x1284 = x1126 + x1280 * x169
    x1285 = x1246 + x1261 + x1276 * x200 - x15 * (x11 * x1277 + x1247 + x1265)
    x1286 = x1285 * x51
    x1287 = x1249 + x1268 + x1280 * x200
    x1288 = x1134 + x1273 + x1282 * x169
    x1289 = x1141 + x1279 + x1284 * x169
    x1290 = x1150 + x1287 * x169
    x1291 = x1256 + x1278 + x1287 * x200
    x1292 = x1066 * x1096
    x1293 = x51 * (
        -x1073 * x1096
        + x1081 * x579
        - x15 * (x1073 * x579 - x1292 + 2.0 * x631)
        + 2.0 * x628 * x71
    )
    x1294 = x1064 * x1096
    x1295 = x1066 * x579 - x1294 + 2.0 * x636
    x1296 = x1295 * x15
    x1297 = x51 * (x1073 * x579 - x1292 - x1296 + 2.0 * x630 * x71)
    x1298 = x1064 * x579 - x1069 * x1096 + 2.0 * x643
    x1299 = x1298 * x15
    x1300 = x51 * (x1066 * x579 - x1294 - x1299 + 2.0 * x635 * x71)
    x1301 = x1069 * x579 - x1096 * x1097 + 2.0 * x654
    x1302 = x1 * (x1295 * x14 * x2 * x8 - x1298 * x167)
    x1303 = 3.0 * x1088 + x11 * x1299
    x1304 = 3.0 * x1092 + x11 * x1296
    x1305 = x1303 * x15
    x1306 = x1 * (x1304 - x1305)
    x1307 = 0.5 * x1306
    x1308 = 3.0 * x1095 + x1301 * x200
    x1309 = x1293 + x1295 * x226 - x15 * (x1297 + x1298 * x226)
    x1310 = x1300 + x1301 * x226
    x1311 = x1 * (-x1303 * x167 + x1304 * x14 * x2 * x8)
    x1312 = 3.0 * x1110 + x1293 + x1304 * x200 - x15 * (x11 * x1305 + 3.0 * x1112 + x1297)
    x1313 = x1312 * x51
    x1314 = 3.0 * x1126 + x1300 + x1308 * x200
    x1315 = x1302 + x1310 * x169
    x1316 = x1307 + x1308 * x226
    x1317 = 3.0 * x1150 + x1306 + x1314 * x200

    # 150 item(s)
    return numpy.array(
        [
            x0 * x127
            + x0 * x133
            + x0 * (x0 * (x0 * x137 + x132) + x133)
            + x113
            * (x112 * x138 + x144 - x15 * (x108 * x138 + x149 + x154 * x5) + x157 * x64)
            + x126 * x138
            + x64
            * (
                x1 * (-x154 + x157)
                + x125 * x138
                + x64 * (x124 * x138 + x158 + x64 * (x160 + x163 * x64))
            ),
            x0 * x185
            + x0 * x194
            + x0 * (x0 * (x0 * x196 + x193) + x194)
            + x1 * (x147 * x170 - x15 * (x151 * x169 + x168 * x5) + x156 * x169)
            + x138 * x184
            + x64 * (x138 * x183 + 0.5 * x197 + x64 * (x160 * x169 + x163 * x170)),
            x0 * x215
            + x0 * x222
            + x0 * (x0 * (x0 * x223 + x221) + x222)
            + x1 * (x147 * x201 - x15 * (x151 * x200 + x199 * x5) + x156 * x200)
            + x138 * x214
            + x64 * (x138 * x213 + x225 + x64 * (x160 * x200 + x163 * x201)),
            x0 * x236
            + x0 * x239
            + x0 * (x0 * (x0 * x242 + x238) + x239)
            + x138 * x235
            + x243 * x51
            + x64 * (3.0 * x244 + x245 * x64),
            x0 * x257
            + x0 * x261
            + x0 * (x0 * (x0 * x263 + x260) + x261)
            + x138 * x256
            + 0.5 * x264
            + x64 * (x160 * x255 + x163 * x251),
            x0 * x276
            + x0 * x280
            + x0 * (x0 * (x0 * x283 + x279) + x280)
            + x138 * x275
            + x285
            + x64 * (x287 + x288 * x64),
            x0 * x292
            + x0 * x296
            + x0 * (x0 * (x293 * x297 + x295) + x296)
            + 3.0 * x298
            + x299 * x64,
            x0 * x304
            + x0 * x308
            + x0 * (x0 * (x297 * x305 + x307) + x308)
            + 3.0 * x309
            + x310 * x64,
            x0 * x311
            + x0 * x314
            + x0 * (x0 * (x0 * x315 + x313) + x314)
            + x169 * x287
            + x170 * x288,
            x0 * x319
            + x0 * x323
            + x0 * (x0 * (x297 * x320 + x322) + x323)
            + 3.0 * x324
            + x325 * x64,
            x0 * x326
            + x0 * x328
            + x0 * (x0 * (x0 * x329 + x327) + x328)
            + x113 * x243
            + x169 * x299,
            x0 * x330
            + x0 * x332
            + x0 * (x0 * (x0 * x333 + x331) + x332)
            + x169 * x310
            + x264,
            x0 * x334
            + x0 * x336
            + x0 * (x0 * (x0 * x337 + x335) + x336)
            + x226 * x288
            + x285,
            x0 * x338 + x0 * x340 + x0 * (x0 * (x0 * x341 + x339) + x340) + x169 * x325,
            x0 * x342
            + x0 * x344
            + x0 * (x0 * (x0 * x345 + x343) + x344)
            + x113 * x284
            + x200 * x325,
            x0 * x390
            + x0 * (x0 * x395 + x390)
            + x113
            * (-x15 * (x37 * x377 + x406 + x412 * x5) + x37 * x380 + x400 + x415 * x64)
            + x127 * x21
            + x37 * x388
            + x64
            * (
                x1 * (-x412 + x415)
                + x37 * x387
                + x64 * (x37 * x386 + x416 + x64 * (x418 + x421 * x64))
            ),
            x0 * x443
            + x0 * (x0 * x445 + x443)
            + x1 * (-x15 * (x425 + x426 * x5) + x423 + x427 * x64)
            + x185 * x21
            + x37 * x441
            + x64 * (x37 * x440 + 0.5 * x446 + x64 * (x447 + x448 * x64)),
            x0 * x465
            + x0 * (x0 * x468 + x465)
            + x1 * (-x15 * (x449 * x5 + x450) + x201 * x404 + x451)
            + x21 * x215
            + x37 * x463
            + x64 * (x37 * x462 + x470 + x64 * (x201 * x421 + x471)),
            x0 * x478
            + x0 * (x0 * x481 + x478)
            + x21 * x236
            + x37 * x476
            + x482 * x51
            + x64 * (x483 + x484 * x64),
            x0 * x494
            + x0 * (x0 * x497 + x494)
            + x21 * x257
            + x37 * x492
            + 0.5 * x500
            + x64 * (x501 + x503 * x64),
            x0 * x511
            + x0 * (x0 * x515 + x511)
            + x21 * x276
            + x37 * x509
            + x517
            + x64 * (x519 + x520 * x64),
            x0 * x525 + x0 * (x0 * x528 + x525) + x21 * x292 + x529 + x530 * x64,
            x0 * x535 + x0 * (x0 * x537 + x535) + x21 * x304 + x538 + x539 * x64,
            x0 * x544 + x0 * (x0 * x546 + x544) + x21 * x311 + x547 + x548 * x64,
            x0 * x553 + x0 * (x0 * x555 + x553) + x21 * x319 + x557 + x558 * x64,
            x0 * x560
            + x0 * (x0 * x562 + x560)
            + x113 * x482
            + x169 * x530
            + x21 * x326
            + x298,
            x0 * x564 + x0 * (x0 * x566 + x564) + x169 * x539 + x21 * x330 + x309 + x500,
            x0 * x568
            + x0 * (x0 * x570 + x568)
            + x169 * x286
            + x169 * x548
            + x21 * x334
            + x517,
            x0 * x572 + x0 * (x0 * x574 + x572) + x169 * x558 + x21 * x338 + x324,
            x0 * x576 + x0 * (x0 * x578 + x576) + x113 * x516 + x200 * x558 + x21 * x342,
            x0 * x622
            + x0 * (x0 * x627 + x622)
            + x113
            * (-x15 * (x37 * x609 + x5 * x646 + x640) + x37 * x612 + x633 + x64 * x649)
            + x127 * x22
            + x37 * x620
            + x64
            * (
                x1 * (-x646 + x649)
                + x37 * x619
                + x64 * (x37 * x618 + x64 * (x64 * x656 + x653) + x651)
            ),
            x0 * x670
            + x0 * (x0 * x673 + x670)
            + x1 * (-x15 * (x169 * x642 + x5 * x657) + x169 * x648 + x170 * x638)
            + x185 * x22
            + x37 * x668
            + x64 * (x37 * x667 + x64 * (x169 * x653 + x170 * x656) + 0.5 * x674),
            x0 * x701
            + x0 * (x0 * x703 + x701)
            + x1 * (-x15 * (x5 * x682 + x680) + x64 * x683 + x677)
            + x215 * x22
            + x37 * x699
            + x64 * (x37 * x698 + x64 * (x64 * x708 + x707) + x705),
            x0 * x715
            + x0 * (x0 * x718 + x715)
            + x22 * x236
            + x37 * x713
            + x51 * x719
            + x64 * (x64 * x721 + 2.0 * x720),
            x0 * x726
            + x0 * (x0 * x729 + x726)
            + x22 * x257
            + x37 * x724
            + x64 * (x169 * x707 + x170 * x708)
            + 0.5 * x730,
            x0 * x738
            + x0 * (x0 * x742 + x738)
            + x22 * x276
            + x37 * x736
            + x64 * (x64 * x747 + x746)
            + x744,
            x0 * x752 + x0 * (x0 * x755 + x752) + x22 * x292 + x64 * x757 + 2.0 * x756,
            x0 * x762 + x0 * (x0 * x764 + x762) + x22 * x304 + x64 * x766 + 2.0 * x765,
            x0 * x769 + x0 * (x0 * x771 + x769) + x169 * x746 + x170 * x747 + x22 * x311,
            x0 * x776 + x0 * (x0 * x778 + x776) + x22 * x319 + x64 * x781 + x780,
            x0 * x783 + x0 * (x0 * x785 + x783) + x113 * x719 + x169 * x757 + x22 * x326,
            x0 * x787 + x0 * (x0 * x789 + x787) + x169 * x766 + x22 * x330 + x730,
            x0 * x791 + x0 * (x0 * x793 + x791) + x22 * x334 + x226 * x747 + x744,
            x0 * x795 + x0 * (x0 * x797 + x795) + x169 * x781 + x22 * x338,
            x0 * x799
            + x0 * (x0 * x801 + x799)
            + x113 * x743
            + x200 * x781
            + x22 * x342
            + x324,
            x0 * x818
            + x113
            * (-x15 * (x5 * x829 + x64 * x826 + x825) + x64 * x830 + x64 * x831 + x821)
            + x21 * x389
            + x21 * x390
            + x36 * x809
            + x64
            * (
                x1 * (-x829 + x831)
                + x36 * x808
                + x64 * (x64 * x833 + x64 * (x64 * x836 + x833) + x832)
            ),
            x0 * x852
            + x1 * (-x15 * (x5 * x843 + x842) + x64 * x844 + x839)
            + x21 * x442
            + x21 * x443
            + x36 * x849
            + x64 * (x64 * x854 + x64 * (x64 * x855 + x854) + 0.5 * x853),
            x0 * x864
            + x1 * (-x15 * (x5 * x856 + x857) + x201 * x823 + x858)
            + x21 * x464
            + x21 * x465
            + x36 * x861
            + x64 * (x201 * x833 + x64 * (x201 * x836 + x867) + x866),
            x0 * x872
            + x21 * x477
            + x21 * x478
            + x51 * x873
            + x64 * x874
            + x64 * (x64 * x875 + x874),
            x0 * x880
            + x21 * x493
            + x21 * x494
            + x64 * x882
            + x64 * (x64 * x883 + x882)
            + 0.5 * x881,
            x0 * x889
            + x21 * x510
            + x21 * x511
            + x64 * x892
            + x64 * (x64 * x893 + x892)
            + x891,
            x0 * x898 + x21 * x524 + x21 * x525 + x64 * x899 + x895,
            x0 * x904 + x21 * x534 + x21 * x535 + x64 * x905 + x901,
            x0 * x910 + x21 * x543 + x21 * x544 + x64 * x911 + x907,
            x0 * x916 + x21 * x552 + x21 * x553 + x64 * x917 + x913,
            x0 * x920 + x113 * x873 + x169 * x899 + x21 * x559 + x21 * x560 + x529,
            x0 * x923 + x169 * x905 + x21 * x563 + x21 * x564 + x538 + x881,
            x0 * x926 + x169 * x911 + x21 * x567 + x21 * x568 + x547 + x891,
            x0 * x929 + x169 * x917 + x21 * x571 + x21 * x572 + x557,
            x0 * x932 + x113 * x890 + x200 * x917 + x21 * x575 + x21 * x576,
            x0 * x949
            + x113
            * (-x15 * (x5 * x958 + x64 * x956 + x955) + x64 * x959 + x64 * x960 + x952)
            + x21 * x622
            + x22 * x389
            + x36 * x940
            + x64
            * (
                x1 * (-x958 + x960)
                + x36 * x939
                + x64 * (x64 * x962 + x64 * (x64 * x964 + x962) + x961)
            ),
            x0 * x977
            + x1 * (-x15 * (x5 * x969 + x968) + x64 * x970 + x966)
            + x21 * x670
            + x22 * x442
            + x36 * x974
            + x64 * (x64 * x979 + x64 * (x64 * x980 + x979) + 0.5 * x978),
            x0 * x994
            + x1 * (-x15 * (x5 * x985 + x984) + x64 * x986 + x982)
            + x21 * x701
            + x22 * x464
            + x36 * x991
            + x64 * (x64 * x997 + x64 * (x64 * x998 + x997) + x996),
            x0 * x1003
            + x1004 * x51
            + x1005 * x64
            + x21 * x715
            + x22 * x477
            + x64 * (x1005 + x1006 * x64),
            x0 * x1011
            + 0.5 * x1012
            + x1013 * x64
            + x21 * x726
            + x22 * x493
            + x64 * (x1013 + x1014 * x64),
            x0 * x1020
            + x1022
            + x1023 * x64
            + x21 * x738
            + x22 * x510
            + x64 * (x1023 + x1024 * x64),
            x0 * x1029 + x1026 + x1030 * x64 + x21 * x752 + x22 * x524,
            x0 * x1035 + x1032 + x1036 * x64 + x21 * x762 + x22 * x534,
            x0 * x1041 + x1038 + x1042 * x64 + x21 * x769 + x22 * x543,
            x0 * x1047 + x1044 + x1048 * x64 + x21 * x776 + x22 * x552,
            x0 * x1051 + x1004 * x113 + x1030 * x169 + x21 * x783 + x22 * x559 + x756,
            x0 * x1054 + x1012 + x1036 * x169 + x21 * x787 + x22 * x563 + x765,
            x0 * x1057 + x1022 + x1042 * x169 + x169 * x745 + x21 * x791 + x22 * x567,
            x0 * x1060 + x1048 * x169 + x21 * x795 + x22 * x571 + x779,
            x0 * x1063 + x1021 * x113 + x1048 * x200 + x21 * x799 + x22 * x575 + x556,
            x0 * x1080
            + x1071 * x36
            + x113
            * (
                x1083
                + x1092 * x64
                + x1093 * x64
                - x15 * (x1087 + x1088 * x64 + x1091 * x5)
            )
            + x22 * x621
            + x22 * x622
            + x64
            * (
                x1 * (-x1091 + x1093)
                + x1070 * x36
                + x64 * (x1094 + x1095 * x64 + x64 * (x1095 + x1098 * x64))
            ),
            x0 * x1106
            + x1 * (x1085 * x170 + x1101 - x15 * (x1099 * x5 + x1100))
            + x1103 * x36
            + x22 * x669
            + x22 * x670
            + x64 * (x1095 * x170 + 0.5 * x1107 + x64 * (x1098 * x170 + x1108)),
            x0 * x1123
            + x1 * (x1110 + x1115 * x64 - x15 * (x1112 + x1114 * x5))
            + x1120 * x36
            + x22 * x700
            + x22 * x701
            + x64 * (x1125 + x1126 * x64 + x64 * (x1126 + x1127 * x64)),
            x0 * x1132
            + x1133 * x51
            + x1134 * x64
            + x22 * x714
            + x22 * x715
            + x64 * (x1134 + x1135 * x64),
            x0 * x1139
            + x1126 * x170
            + 0.5 * x1140
            + x22 * x725
            + x22 * x726
            + x64 * (x1127 * x170 + x1141),
            x0 * x1147
            + x1149
            + x1150 * x64
            + x22 * x737
            + x22 * x738
            + x64 * (x1150 + x1151 * x64),
            x0 * x1156 + x1153 + x1157 * x64 + x22 * x751 + x22 * x752,
            x0 * x1162 + x1159 + x1163 * x64 + x22 * x761 + x22 * x762,
            x0 * x1166 + x1151 * x170 + x1167 + x22 * x768 + x22 * x769,
            x0 * x1172 + x1169 + x1173 * x64 + x22 * x775 + x22 * x776,
            x0 * x1176 + x113 * x1133 + x1157 * x169 + x22 * x782 + x22 * x783,
            x0 * x1179 + x1140 + x1163 * x169 + x22 * x786 + x22 * x787,
            x0 * x1182 + x1149 + x1151 * x226 + x22 * x790 + x22 * x791,
            x0 * x1185 + x1173 * x169 + x22 * x794 + x22 * x795,
            x0 * x1188 + x113 * x1148 + x1173 * x200 + x22 * x798 + x22 * x799 + x780,
            x113 * (x1190 + x1192 * x241 - x15 * (x1194 + x1195 * x241))
            + x21 * x816
            + x21 * x817
            + x21 * x818
            + x64
            * (
                x1 * (x1192 * x14 * x2 * x5 - x1195 * x349) + x64 * (x1197 + x1198 * x241)
            ),
            x1 * (-x1200 * x349 + x1202 * x14 * x2 * x5)
            + x21 * x850
            + x21 * x851
            + x21 * x852
            + x64 * (0.5 * x1204 + x1206 * x241),
            x1 * (x11 * x1192 * x164 * x165 * x5 - x1195 * x466)
            + x21 * x862
            + x21 * x863
            + x21 * x864
            + x64 * (x1198 * x457 + x1208),
            x1209 * x51 + x1210 * x241 + x21 * x870 + x21 * x871 + x21 * x872,
            0.5 * x1211 + x1212 * x241 + x21 * x878 + x21 * x879 + x21 * x880,
            x1214 + x1215 * x241 + x21 * x887 + x21 * x888 + x21 * x889,
            x1216 * x64 + x21 * x896 + x21 * x897 + x21 * x898,
            x1217 * x64 + x21 * x902 + x21 * x903 + x21 * x904,
            x1218 * x64 + x21 * x908 + x21 * x909 + x21 * x910,
            x1219 * x64 + x21 * x914 + x21 * x915 + x21 * x916,
            x113 * x1209
            + x1216 * x169
            + x21 * x918
            + x21 * x919
            + x21 * x920
            + 3.0 * x895,
            x1211 + x1217 * x169 + x21 * x921 + x21 * x922 + x21 * x923 + 3.0 * x901,
            x1214 + x1218 * x169 + x21 * x924 + x21 * x925 + x21 * x926 + 3.0 * x907,
            x1219 * x169 + x21 * x927 + x21 * x928 + x21 * x929 + 3.0 * x913,
            x113 * x1213 + x1219 * x200 + x21 * x930 + x21 * x931 + x21 * x932,
            x113 * (x1221 + x1223 * x241 - x15 * (x1225 + x1226 * x241))
            + x21 * x948
            + x21 * x949
            + x22 * x816
            + x64
            * (
                x1 * (x1223 * x14 * x2 * x5 - x1226 * x349) + x64 * (x1228 + x1229 * x241)
            ),
            x1 * (-x1231 * x349 + x1233 * x14 * x2 * x5)
            + x21 * x976
            + x21 * x977
            + x22 * x850
            + x64 * (0.5 * x1235 + x1237 * x241),
            x1 * (-x1238 * x349 + x1239 * x14 * x2 * x5)
            + x21 * x993
            + x21 * x994
            + x22 * x862
            + x64 * (x1242 + x1243 * x241),
            x1002 * x21 + x1003 * x21 + x1244 * x51 + x1245 * x241 + x22 * x870,
            x1010 * x21 + x1011 * x21 + 0.5 * x1248 + x1250 * x241 + x22 * x878,
            x1019 * x21 + x1020 * x21 + x1252 + x1253 * x241 + x22 * x887,
            x1028 * x21 + x1029 * x21 + x1254 * x64 + x22 * x896,
            x1034 * x21 + x1035 * x21 + x1255 * x64 + x22 * x902,
            x1040 * x21 + x1041 * x21 + x1257 * x64 + x22 * x908,
            x1046 * x21 + x1047 * x21 + x1258 * x64 + x22 * x914,
            2.0 * x1026
            + x1050 * x21
            + x1051 * x21
            + x113 * x1244
            + x1254 * x169
            + x22 * x918,
            2.0 * x1032 + x1053 * x21 + x1054 * x21 + x1248 + x1255 * x169 + x22 * x921,
            2.0 * x1038 + x1056 * x21 + x1057 * x21 + x1252 + x1257 * x169 + x22 * x924,
            x1059 * x21 + x1060 * x21 + x1258 * x169 + x1259 + x22 * x927,
            x1062 * x21 + x1063 * x21 + x113 * x1251 + x1258 * x200 + x22 * x930 + x913,
            x1080 * x21
            + x113 * (x1261 + x1263 * x241 - x15 * (x1265 + x1266 * x241))
            + x22 * x947
            + x22 * x948
            + x64
            * (
                x1 * (x1263 * x14 * x2 * x5 - x1266 * x349) + x64 * (x1268 + x1269 * x241)
            ),
            x1 * (-x1270 * x349 + x1271 * x14 * x2 * x5)
            + x1106 * x21
            + x22 * x975
            + x22 * x976
            + x64 * (0.5 * x1273 + x1274 * x241),
            x1 * (-x1275 * x349 + x1276 * x14 * x2 * x5)
            + x1123 * x21
            + x22 * x992
            + x22 * x993
            + x64 * (x1279 + x1280 * x241),
            x1001 * x22 + x1002 * x22 + x1132 * x21 + x1281 * x51 + x1282 * x241,
            x1009 * x22 + x1010 * x22 + x1139 * x21 + 0.5 * x1283 + x1284 * x241,
            x1018 * x22 + x1019 * x22 + x1147 * x21 + x1286 + x1287 * x241,
            x1027 * x22 + x1028 * x22 + x1156 * x21 + x1288 * x64,
            x1033 * x22 + x1034 * x22 + x1162 * x21 + x1289 * x64,
            x1039 * x22 + x1040 * x22 + x1166 * x21 + x1290 * x64,
            x1045 * x22 + x1046 * x22 + x1172 * x21 + x1291 * x64,
            x1049 * x22 + x1050 * x22 + x113 * x1281 + x1153 + x1176 * x21 + x1288 * x169,
            x1052 * x22 + x1053 * x22 + x1159 + x1179 * x21 + x1283 + x1289 * x169,
            x1055 * x22 + x1056 * x22 + x1167 + x1182 * x21 + x1286 + x1290 * x169,
            x1058 * x22 + x1059 * x22 + x1169 + x1185 * x21 + x1291 * x169,
            x1061 * x22 + x1062 * x22 + x113 * x1285 + x1188 * x21 + x1259 + x1291 * x200,
            x1078 * x22
            + x1079 * x22
            + x1080 * x22
            + x113 * (x1293 + x1295 * x241 - x15 * (x1297 + x1298 * x241))
            + x64
            * (
                x1 * (x1295 * x14 * x2 * x5 - x1298 * x349) + x64 * (x1300 + x1301 * x241)
            ),
            x1 * (x1295 * x164 * x165 * x5 * x8 - x1298 * x671)
            + x1104 * x22
            + x1105 * x22
            + x1106 * x22
            + x64 * (x1301 * x663 + 0.5 * x1302),
            x1 * (-x1303 * x349 + x1304 * x14 * x2 * x5)
            + x1121 * x22
            + x1122 * x22
            + x1123 * x22
            + x64 * (x1307 + x1308 * x241),
            x1130 * x22 + x1131 * x22 + x1132 * x22 + x1309 * x51 + x1310 * x241,
            x1137 * x22 + x1138 * x22 + x1139 * x22 + x1308 * x663 + 0.5 * x1311,
            x1145 * x22 + x1146 * x22 + x1147 * x22 + x1313 + x1314 * x241,
            x1154 * x22 + x1155 * x22 + x1156 * x22 + x1315 * x64,
            x1160 * x22 + x1161 * x22 + x1162 * x22 + x1316 * x64,
            x1164 * x22 + x1165 * x22 + x1166 * x22 + x1314 * x170,
            x1170 * x22 + x1171 * x22 + x1172 * x22 + x1317 * x64,
            x113 * x1309 + x1174 * x22 + x1175 * x22 + x1176 * x22 + x1315 * x169,
            x1177 * x22 + x1178 * x22 + x1179 * x22 + x1311 + x1316 * x169,
            x1180 * x22 + x1181 * x22 + x1182 * x22 + x1313 + x1314 * x226,
            x1183 * x22 + x1184 * x22 + x1185 * x22 + x1317 * x169,
            x113 * x1312
            + 3.0 * x1169
            + x1186 * x22
            + x1187 * x22
            + x1188 * x22
            + x1317 * x200,
        ]
    )


def _3center2el3d_035(a, A, b, B, c, C):
    """Cartesian (sf|h) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = c ** (-1.0)
    x2 = 2.0 * a + 2.0 * b
    x3 = (2.0 * c + x2) ** (-1.0)
    x4 = a + b
    x5 = x4 ** (-1.0)
    x6 = -x5 * (a * A[0] + b * B[0])
    x7 = -x6 - C[0]
    x8 = x7**2
    x9 = -x5 * (a * A[1] + b * B[1])
    x10 = -x9 - C[1]
    x11 = x10**2
    x12 = -x5 * (a * A[2] + b * B[2])
    x13 = -x12 - C[2]
    x14 = x13**2
    x15 = c + x4
    x16 = x15 ** (-1.0)
    x17 = x16 * x4
    x18 = c * x17 * (x11 + x14 + x8)
    x19 = boys(2, x18)
    x20 = x15 ** (-1.5)
    x21 = 17.4934183276249
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x5 * (x0**2 + x22**2 + x23**2))
    x25 = x21 * x24
    x26 = x20 * x25
    x27 = 2.0 * x5
    x28 = x26 * x27
    x29 = x19 * x28
    x30 = x15 ** (-0.5)
    x31 = -x6 - A[0]
    x32 = boys(1, x18)
    x33 = -2.0 * x1 * x21 * x24 * x30 * x31 * x32 * x5 + x29 * x7
    x34 = -x33
    x35 = x3 * x34
    x36 = boys(3, x18)
    x37 = x26 * x36
    x38 = x27 * x37
    x39 = -2.0 * x1 * x19 * x21 * x24 * x30 * x31 * x5 + x38 * x7
    x40 = -x39
    x41 = x3 * x40
    x42 = x2 ** (-1.0)
    x43 = -2.0 * x1 * x19 * x21 * x24 * x30 * x5
    x44 = -x38 - x43
    x45 = x42 * x44
    x46 = boys(4, x18)
    x47 = x28 * x46
    x48 = -2.0 * x1 * x21 * x24 * x30 * x31 * x36 * x5 + x47 * x7
    x49 = -x48
    x50 = c * x16
    x51 = x49 * x50
    x52 = x51 * x7
    x53 = x31 * x40 + x45 - x52
    x54 = x17 * x53
    x55 = 2.0 * x41 + x54 * x7
    x56 = -2.0 * x1 * x21 * x24 * x30 * x32 * x5
    x57 = -x29 - x56
    x58 = x42 * x57
    x59 = x40 * x50
    x60 = x59 * x7
    x61 = x31 * x34 + x58 - x60
    x62 = x17 * x7
    x63 = x17 * x40
    x64 = 0.5 * x1
    x65 = x64 * (-x33 - x63)
    x66 = x17 * x49
    x67 = 2.0 * x3
    x68 = x1 * x67
    x69 = x25 * x68
    x70 = x30 * x5 * x69
    x71 = x36 * x70
    x72 = x66 * x7 + x71
    x73 = x17 * x72
    x74 = x68 * x7
    x75 = x37 * x74 + x65 + x7 * x73
    x76 = x3 * x49
    x77 = 2.0 * x76
    x78 = -2.0 * x1 * x21 * x24 * x30 * x36 * x5
    x79 = -x47 - x78
    x80 = x42 * x79
    x81 = boys(5, x18)
    x82 = x28 * x81
    x83 = -2.0 * x1 * x21 * x24 * x30 * x31 * x46 * x5 + x7 * x82
    x84 = -x83
    x85 = x50 * x84
    x86 = x7 * x85
    x87 = x31 * x49 + x80 - x86
    x88 = x17 * x87
    x89 = x7 * x88 + x77
    x90 = x17 * x89
    x91 = x64 * (-x39 - x66)
    x92 = x17 * x84
    x93 = x46 * x70
    x94 = x7 * x92 + x93
    x95 = x17 * x94
    x96 = x26 * x74
    x97 = x46 * x96 + x7 * x95 + x91
    x98 = -x42 * x44
    x99 = x64 * (x31 * x40 - x52 - x88 - x98)
    x100 = x3 * x84
    x101 = 2.0 * x100
    x102 = x42 * (2.0 * x1 * x21 * x24 * x30 * x46 * x5 - x82)
    x103 = boys(6, x18)
    x104 = x103 * x28
    x105 = -2.0 * x1 * x21 * x24 * x30 * x31 * x5 * x81 + x104 * x7
    x106 = -x105
    x107 = x106 * x50
    x108 = x102 - x107 * x7 + x31 * x84
    x109 = x108 * x17
    x110 = x101 + x109 * x7
    x111 = x110 * x17
    x112 = x111 * x7 + x67 * x94 + x99
    x113 = x112 * x17
    x114 = -x42 * x57
    x115 = x64 * (-x114 + x31 * x34 - x54 - x60)
    x116 = x115 + x67 * x72 + x7 * x90
    x117 = 2.0 * x1
    x118 = x117 * x25
    x119 = x118 * x46
    x120 = x15 ** (-2.5)
    x121 = x120 * x4
    x122 = x121 * x7
    x123 = x117 * x26
    x124 = x64 * (-x123 * x46 - x78)
    x125 = x121 * x8
    x126 = x118 * x81
    x127 = x124 + x125 * x126
    x128 = x1 * (2.0 * x1 * x20 * x21 * x24 * x36 * x7 - x119 * x122) + x127 * x62
    x129 = x17 * x97
    x130 = 1.5 * x1
    x131 = x64 * (-x48 - x92)
    x132 = x70 * x81
    x133 = x106 * x62 + x132
    x134 = x131 + x133 * x62 + x81 * x96
    x135 = x1 * (x72 - x95) + x127 * x3 + x134 * x62
    x136 = x128 * x3 + x130 * (-x129 + x75) + x135 * x62
    x137 = -x42 * x79
    x138 = x64 * (-x109 - x137 + x31 * x49 - x86)
    x139 = x106 * x3
    x140 = 2.0 * x139
    x141 = x42 * (2.0 * x1 * x21 * x24 * x30 * x5 * x81 - x104)
    x142 = boys(7, x18)
    x143 = x142 * x28
    x144 = 2.0 * x1 * x103 * x21 * x24 * x30 * x31 * x5 - x143 * x7
    x145 = x144 * x50
    x146 = x106 * x31 + x141 - x145 * x7
    x147 = x140 + x146 * x62
    x148 = x133 * x67 + x138 + x147 * x62
    x149 = x1 * (-x111 + x89) + x134 * x67 + x148 * x62
    x150 = x130 * (-x113 + x116) + x135 * x67 + x149 * x62
    x151 = (
        x117
        * (
            x1 * (-x17 * x55 + 2.0 * x35 + x61 * x62)
            + x116 * x62
            - x17 * (x1 * (x55 - x90) + x113 * x7 + x67 * x97)
            + x67 * x75
        )
        + x136 * x67
        + x150 * x62
    )
    x152 = x64 * (-x117 * x37 - x43)
    x153 = x119 * x125 + x152
    x154 = x153 * x17
    x155 = x64 * (-x123 * x19 - x56)
    x156 = x118 * x36
    x157 = x125 * x156 + x155
    x158 = x128 * x62 + x130 * (-x154 + x157)
    x159 = x19 * x70
    x160 = x159 + x63 * x7
    x161 = x32 * x70
    x162 = (
        x117
        * (
            x1 * (-x160 * x17 + x161 + x34 * x62)
            + x157 * x3
            - x17 * (x1 * (x160 - x73) + x129 * x7 + x153 * x3)
            + x62 * x75
        )
        + x136 * x62
        + x158 * x3
    )
    x163 = x0 * x162 + x151
    x164 = x118 * x19
    x165 = (
        x117
        * (
            x1 * (2.0 * x1 * x20 * x21 * x24 * x32 * x7 - x122 * x164)
            + x157 * x62
            - x17
            * (x1 * (2.0 * x1 * x19 * x20 * x21 * x24 * x7 - x122 * x156) + x154 * x7)
        )
        + x158 * x62
    )
    x166 = x3 * x61
    x167 = x3 * x53
    x168 = -x39 - x51
    x169 = 2.0 * x42
    x170 = x50 * x7
    x171 = x170 * x87
    x172 = x168 * x169 - x171 + x31 * x53
    x173 = x17 * x172
    x174 = 3.0 * x167 + x173 * x7
    x175 = -x33 - x59
    x176 = x170 * x53
    x177 = x169 * x175 - x176 + x31 * x61
    x178 = 3.0 * x3
    x179 = x3 * x87
    x180 = 3.0 * x179
    x181 = -x48 - x85
    x182 = x108 * x170
    x183 = x169 * x181 - x182 + x31 * x87
    x184 = x17 * x183
    x185 = x180 + x184 * x7
    x186 = x17 * x185
    x187 = x64 * (2.0 * x168 * x42 - x171 - x184 + x31 * x53)
    x188 = x108 * x3
    x189 = 3.0 * x188
    x190 = x108 * x31 - x146 * x170 + x169 * (-x107 - x83)
    x191 = x17 * x190
    x192 = x17 * (x189 + x191 * x7)
    x193 = x17 * (x110 * x178 + x187 + x192 * x7)
    x194 = x64 * (-x173 + 2.0 * x175 * x42 - x176 + x31 * x61)
    x195 = x178 * x89 + x186 * x7 + x194
    x196 = x64 * (2.0 * x181 * x42 - x182 - x191 + x31 * x87)
    x197 = x146 * x3
    x198 = 3.0 * x197
    x199 = x42 * (2.0 * x1 * x103 * x21 * x24 * x30 * x5 - x143)
    x200 = x28 * boys(8, x18)
    x201 = (
        x146 * x31
        + x169 * (-x105 - x145)
        - x170
        * (
            x144 * x31
            - x170 * (2.0 * x1 * x142 * x21 * x24 * x30 * x31 * x5 - x200 * x7)
            + x199
        )
    )
    x202 = x4**2
    x203 = x15 ** (-2.0)
    x204 = x202 * x203
    x205 = x10 * x84
    x206 = x204 * x205
    x207 = x10 * x68
    x208 = x207 * x26
    x209 = x208 * x46
    x210 = x206 * x7 + x209
    x211 = x17 * x210
    x212 = x10 * x204
    x213 = x212 * x49
    x214 = x207 * x37
    x215 = x213 * x7 + x214
    x216 = x10 * x121
    x217 = x1 * (2.0 * x1 * x10 * x20 * x21 * x24 * x36 - x119 * x216)
    x218 = x15 ** (-3.5)
    x219 = x202 * x218
    x220 = x10 * x219
    x221 = x126 * x8
    x222 = 0.5 * x217 + x220 * x221
    x223 = x1 * (x10 * x16 * x4 * x49 - x206)
    x224 = x212 * x7
    x225 = x208 * x81
    x226 = x106 * x224 + x225
    x227 = x122 * x69
    x228 = x10 * x227
    x229 = 0.5 * x223 + x226 * x62 + x228 * x81
    x230 = x1 * (-x211 + x215) + x222 * x3 + x229 * x62
    x231 = x1 * (x10 * x16 * x4 * x61 - x212 * x53)
    x232 = x212 * x87
    x233 = x1 * (x10 * x16 * x4 * x53 - x232)
    x234 = x108 * x212
    x235 = x10 * x17
    x236 = x101 * x235 + x234 * x7
    x237 = x17 * x236
    x238 = x232 * x7 + x235 * x77
    x239 = x1 * (x10 * x16 * x4 * x87 - x234)
    x240 = x140 * x235 + x146 * x224
    x241 = x226 * x67 + 0.5 * x239 + x240 * x62
    x242 = x1 * (-x237 + x238) + x229 * x67 + x241 * x62
    x243 = (
        x130
        * (
            -x17 * (x210 * x67 + 0.5 * x233 + x237 * x7)
            + x215 * x67
            + 0.5 * x231
            + x238 * x62
        )
        + x230 * x67
        + x242 * x62
    )
    x244 = x119 * x220
    x245 = (
        x1 * (2.0 * x1 * x10 * x120 * x21 * x24 * x36 * x4 * x7 - x244 * x7) + x222 * x62
    )
    x246 = x1 * (x10 * x16 * x34 * x4 - x212 * x40)
    x247 = x1 * (x10 * x16 * x4 * x40 - x213)
    x248 = (
        x130
        * (
            -x17 * (x211 * x7 + x228 * x46 + 0.5 * x247)
            + x215 * x62
            + x228 * x36
            + 0.5 * x246
        )
        + x230 * x62
        + x245 * x3
    )
    x249 = x0 * x248 + x243
    x250 = x1 * (2.0 * x1 * x10 * x20 * x21 * x24 * x32 - x164 * x216)
    x251 = x1 * (2.0 * x1 * x10 * x19 * x20 * x21 * x24 - x156 * x216)
    x252 = x156 * x8
    x253 = (
        x130 * (-x17 * (x244 * x8 + 0.5 * x251) + x220 * x252 + 0.5 * x250) + x245 * x62
    )
    x254 = x1 * (x10 * x16 * x177 * x4 - x172 * x212)
    x255 = x183 * x212
    x256 = x1 * (x10 * x16 * x172 * x4 - x255)
    x257 = x190 * x212
    x258 = x17 * (x189 * x235 + x257 * x7)
    x259 = x180 * x235 + x255 * x7
    x260 = x1 * (x10 * x16 * x183 * x4 - x257)
    x261 = x13 * x204
    x262 = x261 * x84
    x263 = x13 * x68
    x264 = x26 * x263
    x265 = x264 * x46
    x266 = x262 * x7 + x265
    x267 = x17 * x266
    x268 = x261 * x49
    x269 = x263 * x37
    x270 = x268 * x7 + x269
    x271 = x121 * x13
    x272 = x1 * (2.0 * x1 * x13 * x20 * x21 * x24 * x36 - x119 * x271)
    x273 = 0.5 * x272
    x274 = x13 * x219
    x275 = x221 * x274 + x273
    x276 = x1 * (x13 * x16 * x4 * x49 - x262)
    x277 = 0.5 * x276
    x278 = x261 * x7
    x279 = x264 * x81
    x280 = x106 * x278 + x279
    x281 = x13 * x227
    x282 = x277 + x280 * x62 + x281 * x81
    x283 = x1 * (-x267 + x270) + x275 * x3 + x282 * x62
    x284 = x1 * (x13 * x16 * x4 * x61 - x261 * x53)
    x285 = 0.5 * x284
    x286 = x261 * x87
    x287 = x1 * (x13 * x16 * x4 * x53 - x286)
    x288 = 0.5 * x287
    x289 = x108 * x261
    x290 = x13 * x17
    x291 = x101 * x290 + x289 * x7
    x292 = x17 * x291
    x293 = x286 * x7 + x290 * x77
    x294 = x1 * (x13 * x16 * x4 * x87 - x289)
    x295 = 0.5 * x294
    x296 = x140 * x290 + x146 * x278
    x297 = x280 * x67 + x295 + x296 * x62
    x298 = x1 * (-x292 + x293) + x282 * x67 + x297 * x62
    x299 = (
        x130 * (-x17 * (x266 * x67 + x288 + x292 * x7) + x270 * x67 + x285 + x293 * x62)
        + x283 * x67
        + x298 * x62
    )
    x300 = x119 * x274
    x301 = (
        x1 * (2.0 * x1 * x120 * x13 * x21 * x24 * x36 * x4 * x7 - x300 * x7) + x275 * x62
    )
    x302 = x1 * (x13 * x16 * x34 * x4 - x261 * x40)
    x303 = 0.5 * x302
    x304 = x1 * (x13 * x16 * x4 * x40 - x268)
    x305 = 0.5 * x304
    x306 = (
        x130 * (-x17 * (x267 * x7 + x281 * x46 + x305) + x270 * x62 + x281 * x36 + x303)
        + x283 * x62
        + x3 * x301
    )
    x307 = x0 * x306 + x299
    x308 = x1 * (2.0 * x1 * x13 * x20 * x21 * x24 * x32 - x164 * x271)
    x309 = 0.5 * x308
    x310 = x1 * (2.0 * x1 * x13 * x19 * x20 * x21 * x24 - x156 * x271)
    x311 = 0.5 * x310
    x312 = x130 * (-x17 * (x300 * x8 + x311) + x252 * x274 + x309) + x301 * x62
    x313 = x1 * (x13 * x16 * x177 * x4 - x172 * x261)
    x314 = 0.5 * x313
    x315 = x183 * x261
    x316 = x1 * (x13 * x16 * x172 * x4 - x315)
    x317 = 0.5 * x316
    x318 = x190 * x261
    x319 = x17 * (x189 * x290 + x318 * x7)
    x320 = x180 * x290 + x315 * x7
    x321 = x1 * (x13 * x16 * x183 * x4 - x318)
    x322 = 0.5 * x321
    x323 = x11 * x204
    x324 = x115 + x323 * x87
    x325 = x3 * x324
    x326 = x108 * x323 + x99
    x327 = x3 * x326
    x328 = x17 * (x187 + x190 * x323)
    x329 = x183 * x323 + x194
    x330 = x323 * x49 + x65
    x331 = x3 * x330
    x332 = x323 * x84 + x91
    x333 = x3 * x332
    x334 = x17 * x326
    x335 = x17 * x332
    x336 = x330 - x335
    x337 = x11 * x121
    x338 = x124 + x126 * x337
    x339 = x3 * x338
    x340 = x106 * x323 + x131
    x341 = x339 + x340 * x62
    x342 = x336 * x64 + x339 * x62 + x341 * x62
    x343 = x324 - x334
    x344 = x3 * x340
    x345 = x138 + x146 * x323
    x346 = 2.0 * x344 + x345 * x62
    x347 = x341 * x67 + x343 * x64 + x346 * x62
    x348 = (
        x1 * (-x17 * (2.0 * x333 + x334 * x7) + x324 * x62 + 2.0 * x331)
        + x342 * x67
        + x347 * x62
    )
    x349 = x155 + x156 * x337
    x350 = x3 * x349
    x351 = x119 * x337 + x152
    x352 = x3 * x351
    x353 = x17 * x351
    x354 = x349 - x353
    x355 = x204 * x8
    x356 = x338 * x355 + x354 * x64
    x357 = x1 * (-x17 * (x335 * x7 + x352) + x330 * x62 + x350) + x3 * x356 + x342 * x62
    x358 = x0 * x357 + x348
    x359 = x204 * x7
    x360 = x1 * (x16 * x349 * x4 * x7 - x351 * x359) + x356 * x62
    x361 = -x328 + x329
    x362 = x3 * x345
    x363 = x196 + x201 * x323
    x364 = x4**3
    x365 = x364 / x15**3
    x366 = x13 * x365
    x367 = x10 * x366
    x368 = x190 * x367
    x369 = x13 * x212
    x370 = x367 * x7
    x371 = x108 * x367
    x372 = x205 * x366
    x373 = x1 * (x10 * x13 * x202 * x203 * x49 - x372)
    x374 = x13 * x216 * x69
    x375 = x374 * x81
    x376 = x106 * x370 + x375
    x377 = x13 * x220 * x69 * x7 * x81 + 0.5 * x373 + x376 * x62
    x378 = x1 * (x10 * x13 * x202 * x203 * x87 - x371)
    x379 = x140 * x369 + x146 * x370
    x380 = x376 * x67 + 0.5 * x378 + x379 * x62
    x381 = (
        x1 * (-x17 * (x101 * x369 + x371 * x7) + x369 * x77 + x370 * x87)
        + x377 * x67
        + x380 * x62
    )
    x382 = x374 * x46
    x383 = x36 * x374
    x384 = x1 * (2.0 * x1 * x10 * x120 * x13 * x21 * x24 * x36 * x4 - x13 * x244)
    x385 = x10 * x13 * x15 ** (-4.5) * x364
    x386 = x221 * x385 + 0.5 * x384
    x387 = x1 * (-x17 * (x372 * x7 + x382) + x370 * x49 + x383) + x3 * x386 + x377 * x62
    x388 = x0 * x387 + x381
    x389 = (
        x1
        * (2.0 * x1 * x10 * x13 * x202 * x21 * x218 * x24 * x36 * x7 - x119 * x385 * x7)
        + x386 * x62
    )
    x390 = x1 * (x10 * x13 * x183 * x202 * x203 - x368)
    x391 = x14 * x204
    x392 = x115 + x391 * x87
    x393 = x3 * x392
    x394 = x108 * x391 + x99
    x395 = x3 * x394
    x396 = x187 + x190 * x391
    x397 = x17 * x396
    x398 = x183 * x391 + x194
    x399 = x391 * x49 + x65
    x400 = x3 * x399
    x401 = x391 * x84 + x91
    x402 = x3 * x401
    x403 = x17 * x394
    x404 = x17 * x401
    x405 = x399 - x404
    x406 = x405 * x64
    x407 = x121 * x14
    x408 = x124 + x126 * x407
    x409 = x3 * x408
    x410 = x106 * x391 + x131
    x411 = x409 + x410 * x62
    x412 = x406 + x409 * x62 + x411 * x62
    x413 = x392 - x403
    x414 = x413 * x64
    x415 = x3 * x410
    x416 = 2.0 * x415
    x417 = x138 + x146 * x391
    x418 = x416 + x417 * x62
    x419 = x411 * x67 + x414 + x418 * x62
    x420 = (
        x1 * (-x17 * (2.0 * x402 + x403 * x7) + x392 * x62 + 2.0 * x400)
        + x412 * x67
        + x419 * x62
    )
    x421 = x155 + x156 * x407
    x422 = x3 * x421
    x423 = x119 * x407 + x152
    x424 = x3 * x423
    x425 = x17 * x423
    x426 = x421 - x425
    x427 = x426 * x64
    x428 = x355 * x408 + x427
    x429 = x1 * (-x17 * (x404 * x7 + x424) + x399 * x62 + x422) + x3 * x428 + x412 * x62
    x430 = x0 * x429 + x420
    x431 = x1 * (x16 * x4 * x421 * x7 - x359 * x423) + x428 * x62
    x432 = -x397 + x398
    x433 = x432 * x64
    x434 = x3 * x417
    x435 = 3.0 * x434
    x436 = x196 + x201 * x391
    x437 = -x17 * (x10 * x334 + x233) + x231 + x235 * x324
    x438 = x217 + x235 * x338
    x439 = x3 * x438
    x440 = x223 + x235 * x340
    x441 = x439 + x440 * x62
    x442 = x3 * x440
    x443 = x235 * x345 + x239
    x444 = 2.0 * x442 + x443 * x62
    x445 = x437 * x64 + x441 * x67 + x444 * x62
    x446 = -x17 * (x10 * x335 + x247) + x235 * x330 + x246
    x447 = x439 * x62 + x441 * x62 + x446 * x64
    x448 = x0 * x447 + x445
    x449 = -x17 * (x10 * x353 + x251) + x235 * x349 + x250
    x450 = x355 * x438 + x449 * x64
    x451 = -x17 * (x10 * x328 + x256) + x235 * x329 + x254
    x452 = x3 * x443
    x453 = x235 * x363 + x260
    x454 = x11 * x366
    x455 = -x17 * (x108 * x454 + x288) + x285 + x454 * x87
    x456 = x11 * x274
    x457 = x126 * x456 + x273
    x458 = x3 * x457
    x459 = x106 * x454 + x277
    x460 = x458 + x459 * x62
    x461 = x3 * x459
    x462 = x146 * x454 + x295
    x463 = 2.0 * x461 + x462 * x62
    x464 = x455 * x64 + x460 * x67 + x463 * x62
    x465 = -x17 * (x305 + x454 * x84) + x303 + x454 * x49
    x466 = x458 * x62 + x460 * x62 + x465 * x64
    x467 = x0 * x466 + x464
    x468 = x156 * x456 - x17 * (x11 * x300 + x311) + x309
    x469 = x355 * x457 + x468 * x64
    x470 = -x17 * (x190 * x454 + x317) + x183 * x454 + x314
    x471 = x3 * x462
    x472 = x201 * x454 + x322
    x473 = x1 * (x10 * x16 * x392 * x4 - x212 * x394)
    x474 = x235 * x409
    x475 = x224 * x410 + x474
    x476 = x224 * x417 + x235 * x416
    x477 = 0.5 * x473 + x475 * x67 + x476 * x62
    x478 = x1 * (x10 * x16 * x399 * x4 - x212 * x401)
    x479 = x224 * x409 + x475 * x62 + 0.5 * x478
    x480 = x0 * x479 + x477
    x481 = x1 * (x10 * x16 * x4 * x421 - x212 * x423)
    x482 = x10 * x365
    x483 = x482 * x8
    x484 = x408 * x483 + 0.5 * x481
    x485 = x1 * (x10 * x16 * x398 * x4 - x212 * x396)
    x486 = -x17 * (x13 * x403 + x287) + x284 + x290 * x392
    x487 = x486 * x64
    x488 = x272 + x290 * x408
    x489 = x3 * x488
    x490 = x276 + x290 * x410
    x491 = x489 + x490 * x62
    x492 = x3 * x490
    x493 = 2.0 * x492
    x494 = x290 * x417 + x294
    x495 = x493 + x494 * x62
    x496 = x487 + x491 * x67 + x495 * x62
    x497 = -x17 * (x13 * x404 + x304) + x290 * x399 + x302
    x498 = x497 * x64
    x499 = x489 * x62 + x491 * x62 + x498
    x500 = x0 * x499 + x496
    x501 = -x17 * (x13 * x425 + x310) + x290 * x421 + x308
    x502 = x501 * x64
    x503 = x355 * x488 + x502
    x504 = -x17 * (x13 * x397 + x316) + x290 * x398 + x313
    x505 = x504 * x64
    x506 = x3 * x494
    x507 = 3.0 * x506
    x508 = x290 * x436 + x321
    x509 = x130 * x336 + x235 * x440
    x510 = x3 * x509
    x511 = x130 * x343 + x235 * x443
    x512 = 2.0 * x510 + x511 * x62
    x513 = x130 * x354 + x235 * x438
    x514 = x3 * x513
    x515 = x509 * x62 + x514
    x516 = x0 * x515 + x512
    x517 = x0 * x62
    x518 = x3 * x511
    x519 = x130 * x361 + x235 * x453
    x520 = x235 * x459 + x373
    x521 = x3 * x520
    x522 = x235 * x462 + x378
    x523 = 2.0 * x521 + x522 * x62
    x524 = x235 * x457 + x384
    x525 = x3 * x524
    x526 = x520 * x62 + x525
    x527 = x0 * x526 + x523
    x528 = x3 * x522
    x529 = x235 * x472 + x390
    x530 = x323 * x410 + x406
    x531 = x3 * x530
    x532 = x323 * x417 + x414
    x533 = 2.0 * x531 + x532 * x62
    x534 = x323 * x408 + x427
    x535 = x3 * x534
    x536 = x530 * x62 + x535
    x537 = x0 * x536 + x533
    x538 = x3 * x532
    x539 = x323 * x436 + x433
    x540 = x224 * x494 + x235 * x493
    x541 = x235 * x489
    x542 = x224 * x490 + x541
    x543 = x0 * x542 + x540
    x544 = x224 * x488
    x545 = x130 * x405 + x290 * x490
    x546 = x3 * x545
    x547 = x130 * x413 + x290 * x494
    x548 = 2.0 * x546 + x547 * x62
    x549 = x130 * x426 + x290 * x488
    x550 = x3 * x549
    x551 = x545 * x62 + x550
    x552 = x0 * x551 + x548
    x553 = x3 * x547
    x554 = x130 * x432 + x290 * x508
    x555 = x117 * x437 + x235 * x511
    x556 = x117 * x446 + x235 * x509
    x557 = x0 * x556 + x555
    x558 = x117 * x449 + x235 * x513
    x559 = x130 * x455 + x235 * x522
    x560 = x130 * x465 + x235 * x520
    x561 = x0 * x560 + x559
    x562 = x130 * x468 + x235 * x524
    x563 = x235 * x532 + x473
    x564 = x235 * x530 + x478
    x565 = x0 * x564 + x563
    x566 = x235 * x534 + x481
    x567 = x323 * x494 + x487
    x568 = x323 * x490 + x498
    x569 = x0 * x568 + x567
    x570 = x323 * x488 + x502
    x571 = x235 * x547
    x572 = x235 * x545
    x573 = x0 * x572 + x571
    x574 = x235 * x549
    x575 = x117 * x486 + x290 * x547
    x576 = x117 * x497 + x290 * x545
    x577 = x0 * x576 + x575
    x578 = x117 * x501 + x290 * x549
    x579 = -x9 - A[1]
    x580 = -2.0 * x1 * x21 * x24 * x30 * x36 * x5 * x579 + x10 * x47
    x581 = -x580
    x582 = x17 * x581
    x583 = -2.0 * x1 * x19 * x21 * x24 * x30 * x5 * x579 + x10 * x38
    x584 = x64 * (-x582 - x583)
    x585 = -2.0 * x1 * x21 * x24 * x30 * x46 * x5 * x579 + x10 * x82
    x586 = -x585
    x587 = x355 * x586 + x584
    x588 = x17 * x587
    x589 = -x583
    x590 = x17 * x589
    x591 = -2.0 * x1 * x21 * x24 * x30 * x32 * x5 * x579 + x10 * x29
    x592 = x64 * (-x590 - x591)
    x593 = x355 * x581 + x592
    x594 = x17 * x586
    x595 = x64 * (-x580 - x594)
    x596 = -2.0 * x1 * x21 * x24 * x30 * x5 * x579 * x81 + x10 * x104
    x597 = -x596
    x598 = x355 * x597 + x595
    x599 = x1 * (x16 * x4 * x581 * x7 - x359 * x586) + x598 * x62
    x600 = x130 * (-x588 + x593) + x599 * x62
    x601 = -x591
    x602 = x3 * x601
    x603 = x3 * x589
    x604 = x50 * x581
    x605 = -x31 * x589 + x604 * x7
    x606 = -x605
    x607 = x17 * x606
    x608 = x603 + x607 * x7
    x609 = x50 * x589
    x610 = -x31 * x601 + x609 * x7
    x611 = -x610
    x612 = x3 * x581
    x613 = x50 * x586
    x614 = -x31 * x581 + x613 * x7
    x615 = -x614
    x616 = x17 * x615
    x617 = x612 + x616 * x7
    x618 = x17 * x617
    x619 = x64 * (-x605 - x616)
    x620 = x3 * x586
    x621 = x50 * x597
    x622 = x31 * x586 - x621 * x7
    x623 = x17 * x622
    x624 = x620 + x623 * x7
    x625 = x17 * x624
    x626 = x619 + x62 * x620 + x625 * x7
    x627 = x17 * x626
    x628 = x64 * (-x607 - x610)
    x629 = x612 * x62 + x618 * x7 + x628
    x630 = x64 * (-x614 - x623)
    x631 = x3 * x597
    x632 = 2.0 * x1 * x103 * x21 * x24 * x30 * x5 * x579 - x10 * x143
    x633 = x50 * x632
    x634 = x31 * x597 - x633 * x7
    x635 = x62 * x634 + x631
    x636 = x62 * x631 + x62 * x635 + x630
    x637 = x1 * (x617 - x625) + x3 * x598 + x62 * x636
    x638 = x130 * (-x627 + x629) + x3 * x599 + x62 * x637
    x639 = (
        x117
        * (
            x1 * (-x17 * x608 + x602 + x611 * x62)
            - x17 * (x1 * (x608 - x618) + x3 * x587 + x627 * x7)
            + x3 * x593
            + x62 * x629
        )
        + x3 * x600
        + x62 * x638
    )
    x640 = x162 * x22 + x639
    x641 = (
        x117
        * (
            x1 * (x16 * x4 * x601 * x7 - x359 * x589)
            - x17 * (x1 * (x16 * x4 * x589 * x7 - x359 * x581) + x588 * x7)
            + x593 * x62
        )
        + x600 * x62
    )
    x642 = x165 * x22 + x641
    x643 = x3 * x611
    x644 = 2.0 * x643
    x645 = x3 * x606
    x646 = 2.0 * x645
    x647 = -x583 - x604
    x648 = x42 * x647
    x649 = x170 * x615
    x650 = x31 * x606 + x648 - x649
    x651 = x17 * x650
    x652 = x646 + x651 * x7
    x653 = -x591 - x609
    x654 = x42 * x653
    x655 = x170 * x606
    x656 = x31 * x611 + x654 - x655
    x657 = x3 * x615
    x658 = 2.0 * x657
    x659 = -x580 - x613
    x660 = x42 * x659
    x661 = x170 * x622
    x662 = x31 * x615 + x660 - x661
    x663 = x17 * x662
    x664 = x658 + x663 * x7
    x665 = x17 * x664
    x666 = x64 * (x31 * x606 + x42 * x647 - x649 - x663)
    x667 = x3 * x622
    x668 = 2.0 * x667
    x669 = x42 * (-x585 - x621)
    x670 = -x170 * x634 + x31 * x622 + x669
    x671 = x17 * x670
    x672 = x17 * (x668 + x671 * x7)
    x673 = x17 * (x624 * x67 + x666 + x672 * x7)
    x674 = x64 * (x31 * x611 + x42 * x653 - x651 - x655)
    x675 = x617 * x67 + x665 * x7 + x674
    x676 = x64 * (x31 * x615 + x42 * x659 - x661 - x671)
    x677 = x3 * x634
    x678 = 2.0 * x677
    x679 = x42 * (-x596 - x633)
    x680 = 2.0 * x1 * x142 * x21 * x24 * x30 * x5 * x579 - x10 * x200
    x681 = -x170 * (-x170 * x680 + x31 * x632) + x31 * x634 + x679
    x682 = x10 * x594 + x93
    x683 = x10 * x582 + x71
    x684 = x17 * x682
    x685 = x1 * (x683 - x684)
    x686 = x132 + x235 * x597
    x687 = x355 * x686 + 0.5 * x685
    x688 = x1 * (x16 * x4 * x683 * x7 - x359 * x682) + x62 * x687
    x689 = x10 * x607 + x41
    x690 = x1 * (-x17 * x689 + x235 * x611 + x35)
    x691 = x10 * x616 + x76
    x692 = x17 * x691
    x693 = x1 * (x689 - x692)
    x694 = x3 * x682
    x695 = x10 * x623 + x100
    x696 = x17 * x695
    x697 = x694 + x696 * x7
    x698 = x17 * x697
    x699 = x3 * x683
    x700 = x692 * x7 + x699
    x701 = x1 * (x691 - x696)
    x702 = x3 * x686
    x703 = x139 + x235 * x634
    x704 = x62 * x703 + x702
    x705 = x62 * x702 + x62 * x704 + 0.5 * x701
    x706 = x1 * (-x698 + x700) + x3 * x687 + x62 * x705
    x707 = (
        x130
        * (
            -x17 * (x62 * x694 + 0.5 * x693 + x698 * x7)
            + x62 * x699
            + x62 * x700
            + 0.5 * x690
        )
        + x3 * x688
        + x62 * x706
    )
    x708 = x22 * x248 + x707
    x709 = x10 * x590 + x159
    x710 = x1 * (x161 - x17 * x709 + x235 * x601)
    x711 = x17 * x683
    x712 = x1 * (x709 - x711)
    x713 = (
        x130 * (-x17 * (x355 * x682 + 0.5 * x712) + x355 * x683 + 0.5 * x710) + x62 * x688
    )
    x714 = x22 * x253 + x713
    x715 = x10 * x651 + x167
    x716 = x1 * (x166 - x17 * x715 + x235 * x656)
    x717 = x10 * x663 + x179
    x718 = x17 * x717
    x719 = x1 * (x715 - x718)
    x720 = x67 * x695
    x721 = x17 * (x10 * x671 + x188)
    x722 = x17 * (x7 * x721 + x720)
    x723 = x67 * x691
    x724 = x7 * x718 + x723
    x725 = x1 * (x717 - x721)
    x726 = x67 * x703
    x727 = x197 + x235 * x681
    x728 = x366 * x586
    x729 = x1 * (x13 * x16 * x4 * x581 - x261 * x586)
    x730 = 0.5 * x729
    x731 = x366 * x8
    x732 = x597 * x731 + x730
    x733 = x1 * (x13 * x202 * x203 * x581 * x7 - x7 * x728) + x62 * x732
    x734 = x1 * (x13 * x16 * x4 * x611 - x261 * x606)
    x735 = 0.5 * x734
    x736 = x261 * x615
    x737 = x1 * (x13 * x16 * x4 * x606 - x736)
    x738 = 0.5 * x737
    x739 = x261 * x622
    x740 = x290 * x620
    x741 = x7 * x739 + x740
    x742 = x17 * x741
    x743 = x290 * x612
    x744 = x7 * x736 + x743
    x745 = x1 * (x13 * x16 * x4 * x615 - x739)
    x746 = 0.5 * x745
    x747 = x290 * x631
    x748 = x278 * x634 + x747
    x749 = x278 * x631 + x62 * x748 + x746
    x750 = x1 * (-x742 + x744) + x3 * x732 + x62 * x749
    x751 = (
        x130 * (-x17 * (x278 * x620 + x7 * x742 + x738) + x278 * x612 + x62 * x744 + x735)
        + x3 * x733
        + x62 * x750
    )
    x752 = x22 * x306 + x751
    x753 = x1 * (x13 * x16 * x4 * x601 - x261 * x589)
    x754 = 0.5 * x753
    x755 = x1 * (x13 * x16 * x4 * x589 - x261 * x581)
    x756 = 0.5 * x755
    x757 = x130 * (-x17 * (x728 * x8 + x756) + x581 * x731 + x754) + x62 * x733
    x758 = x22 * x312 + x757
    x759 = x1 * (x13 * x16 * x4 * x656 - x261 * x650)
    x760 = 0.5 * x759
    x761 = x261 * x662
    x762 = x1 * (x13 * x16 * x4 * x650 - x761)
    x763 = 0.5 * x762
    x764 = x261 * x670
    x765 = x290 * x668
    x766 = x17 * (x7 * x764 + x765)
    x767 = x290 * x658
    x768 = x7 * x761 + x767
    x769 = x1 * (x13 * x16 * x4 * x662 - x764)
    x770 = 0.5 * x769
    x771 = x290 * x678
    x772 = x10 * x692 + x235 * x76 + x628
    x773 = x67 * x772
    x774 = x10 * x696 + x100 * x235 + x619
    x775 = x67 * x774
    x776 = x17 * (x10 * x721 + x188 * x235 + x666)
    x777 = x10 * x718 + x179 * x235 + x674
    x778 = x10 * x711 + x214 + x592
    x779 = x3 * x778
    x780 = x10 * x684 + x209 + x584
    x781 = x3 * x780
    x782 = x17 * x774
    x783 = x17 * x780
    x784 = x778 - x783
    x785 = x225 + x235 * x686 + x595
    x786 = x355 * x785 + x64 * x784
    x787 = x772 - x782
    x788 = x3 * x785
    x789 = x139 * x235 + x235 * x703 + x630
    x790 = x62 * x789 + x788
    x791 = x62 * x788 + x62 * x790 + x64 * x787
    x792 = x1 * (-x17 * (x7 * x782 + x781) + x62 * x772 + x779) + x3 * x786 + x62 * x791
    x793 = x22 * x357 + x792
    x794 = x1 * (x16 * x4 * x7 * x778 - x359 * x780) + x62 * x786
    x795 = x22 * x360 + x794
    x796 = -x776 + x777
    x797 = x67 * x789
    x798 = x197 * x235 + x235 * x727 + x676
    x799 = x290 * x76
    x800 = x369 * x615 + x799
    x801 = x67 * x800
    x802 = x100 * x290
    x803 = x369 * x622 + x802
    x804 = x67 * x803
    x805 = x188 * x290
    x806 = x17 * (x369 * x670 + x805)
    x807 = x179 * x290
    x808 = x369 * x662 + x807
    x809 = x269 + x369 * x581
    x810 = x3 * x809
    x811 = x265 + x369 * x586
    x812 = x3 * x811
    x813 = x17 * x803
    x814 = x17 * x811
    x815 = x1 * (x809 - x814)
    x816 = x279 + x369 * x597
    x817 = x355 * x816 + 0.5 * x815
    x818 = x1 * (x800 - x813)
    x819 = x3 * x816
    x820 = x139 * x290
    x821 = x369 * x634 + x820
    x822 = x62 * x821 + x819
    x823 = x62 * x819 + x62 * x822 + 0.5 * x818
    x824 = x1 * (-x17 * (x7 * x813 + x812) + x62 * x800 + x810) + x3 * x817 + x62 * x823
    x825 = x22 * x387 + x824
    x826 = x1 * (x16 * x4 * x7 * x809 - x359 * x811) + x62 * x817
    x827 = x22 * x389 + x826
    x828 = x1 * (-x806 + x808)
    x829 = x67 * x821
    x830 = x197 * x290
    x831 = x369 * x681 + x830
    x832 = x391 * x615 + x628
    x833 = x3 * x832
    x834 = 2.0 * x833
    x835 = x391 * x622 + x619
    x836 = x3 * x835
    x837 = 2.0 * x836
    x838 = x17 * (x391 * x670 + x666)
    x839 = x391 * x662 + x674
    x840 = x391 * x581 + x592
    x841 = x3 * x840
    x842 = x391 * x586 + x584
    x843 = x3 * x842
    x844 = x17 * x835
    x845 = x17 * x842
    x846 = x840 - x845
    x847 = x64 * x846
    x848 = x391 * x597 + x595
    x849 = x355 * x848 + x847
    x850 = x832 - x844
    x851 = x64 * x850
    x852 = x3 * x848
    x853 = x391 * x634 + x630
    x854 = x62 * x853 + x852
    x855 = x62 * x852 + x62 * x854 + x851
    x856 = x1 * (-x17 * (x7 * x844 + x843) + x62 * x832 + x841) + x3 * x849 + x62 * x855
    x857 = x22 * x429 + x856
    x858 = x1 * (x16 * x4 * x7 * x840 - x359 * x842) + x62 * x849
    x859 = x22 * x431 + x858
    x860 = -x838 + x839
    x861 = x64 * x860
    x862 = x3 * x853
    x863 = 2.0 * x862
    x864 = x391 * x681 + x676
    x865 = -x17 * (x10 * x782 + x333 + x693) + x235 * x772 + x331 + x690
    x866 = x235 * x785 + x339 + x685
    x867 = x3 * x866
    x868 = x235 * x789 + x344 + x701
    x869 = x62 * x868 + x867
    x870 = x62 * x867 + x62 * x869 + x64 * x865
    x871 = x22 * x447 + x870
    x872 = -x17 * (x10 * x783 + x352 + x712) + x235 * x778 + x350 + x710
    x873 = x355 * x866 + x64 * x872
    x874 = x22 * x450 + x873
    x875 = -x17 * (x10 * x776 + x327 + x719) + x235 * x777 + x325 + x716
    x876 = x67 * x868
    x877 = x235 * x798 + x362 + x725
    x878 = -x17 * (x10 * x813 + x100 * x369 + x738) + x235 * x800 + x369 * x76 + x735
    x879 = x235 * x816 + x375 + x730
    x880 = x3 * x879
    x881 = x139 * x369 + x235 * x821 + x746
    x882 = x62 * x881 + x880
    x883 = x62 * x880 + x62 * x882 + x64 * x878
    x884 = x22 * x466 + x883
    x885 = -x17 * (x10 * x814 + x382 + x756) + x235 * x809 + x383 + x754
    x886 = x355 * x879 + x64 * x885
    x887 = x22 * x469 + x886
    x888 = -x17 * (x10 * x806 + x188 * x369 + x763) + x179 * x369 + x235 * x808 + x760
    x889 = x67 * x881
    x890 = x197 * x369 + x235 * x831 + x770
    x891 = x1 * (-x17 * (x10 * x844 + x402) + x235 * x832 + x400)
    x892 = x235 * x848 + x409
    x893 = x3 * x892
    x894 = x235 * x853 + x415
    x895 = x62 * x894 + x893
    x896 = x62 * x893 + x62 * x895 + 0.5 * x891
    x897 = x22 * x479 + x896
    x898 = x1 * (-x17 * (x10 * x845 + x424) + x235 * x840 + x422)
    x899 = x355 * x892 + 0.5 * x898
    x900 = x22 * x484 + x899
    x901 = x1 * (-x17 * (x10 * x838 + x395) + x235 * x839 + x393)
    x902 = x67 * x894
    x903 = x235 * x864 + x434
    x904 = -x17 * (x13 * x844 + x737) + x290 * x832 + x734
    x905 = x64 * x904
    x906 = x290 * x848 + x729
    x907 = x3 * x906
    x908 = x290 * x853 + x745
    x909 = x62 * x908 + x907
    x910 = x62 * x907 + x62 * x909 + x905
    x911 = x22 * x499 + x910
    x912 = -x17 * (x13 * x845 + x755) + x290 * x840 + x753
    x913 = x64 * x912
    x914 = x355 * x906 + x913
    x915 = x22 * x503 + x914
    x916 = -x17 * (x13 * x838 + x762) + x290 * x839 + x759
    x917 = x64 * x916
    x918 = x3 * x908
    x919 = 2.0 * x918
    x920 = x290 * x864 + x769
    x921 = x130 * x784 + x235 * x866 + x439
    x922 = x3 * x921
    x923 = x130 * x787 + x235 * x868 + x442
    x924 = x62 * x923 + x922
    x925 = x22 * x515 + x924
    x926 = x62 * x921
    x927 = x22 * x62
    x928 = x513 * x927 + x926
    x929 = x67 * x923
    x930 = x130 * x796 + x235 * x877 + x452
    x931 = x235 * x879 + x458 + x815
    x932 = x3 * x931
    x933 = x235 * x881 + x461 + x818
    x934 = x62 * x933 + x932
    x935 = x22 * x526 + x934
    x936 = x62 * x931
    x937 = x524 * x927 + x936
    x938 = x67 * x933
    x939 = x235 * x890 + x471 + x828
    x940 = x235 * x892 + x474 + x847
    x941 = x3 * x940
    x942 = x235 * x415 + x235 * x894 + x851
    x943 = x62 * x942 + x941
    x944 = x22 * x536 + x943
    x945 = x62 * x940
    x946 = x534 * x927 + x945
    x947 = x67 * x942
    x948 = x235 * x434 + x235 * x903 + x861
    x949 = x235 * x906 + x489
    x950 = x3 * x949
    x951 = x235 * x908 + x492
    x952 = x62 * x951 + x950
    x953 = x22 * x542 + x952
    x954 = x62 * x949
    x955 = x22 * x544 + x954
    x956 = x67 * x951
    x957 = x235 * x920 + x506
    x958 = x130 * x846 + x290 * x906
    x959 = x3 * x958
    x960 = x130 * x850 + x290 * x908
    x961 = x62 * x960 + x959
    x962 = x22 * x551 + x961
    x963 = x62 * x958
    x964 = x549 * x927 + x963
    x965 = x3 * x960
    x966 = 2.0 * x965
    x967 = x130 * x860 + x290 * x920
    x968 = x117 * x865 + x235 * x923 + x510
    x969 = x22 * x556 + x968
    x970 = x117 * x872 + x235 * x921 + x514
    x971 = x22 * x558 + x970
    x972 = x130 * x878 + x235 * x933 + x521
    x973 = x22 * x560 + x972
    x974 = x130 * x885 + x235 * x931 + x525
    x975 = x22 * x562 + x974
    x976 = x235 * x942 + x531 + x891
    x977 = x22 * x564 + x976
    x978 = x235 * x940 + x535 + x898
    x979 = x22 * x566 + x978
    x980 = x235 * x492 + x235 * x951 + x905
    x981 = x22 * x568 + x980
    x982 = x235 * x949 + x541 + x913
    x983 = x22 * x570 + x982
    x984 = x235 * x960 + x546
    x985 = x22 * x572 + x984
    x986 = x235 * x958 + x550
    x987 = x22 * x574 + x986
    x988 = x117 * x904 + x290 * x960
    x989 = x22 * x576 + x988
    x990 = x117 * x912 + x290 * x958
    x991 = x22 * x578 + x990
    x992 = -x12 - A[2]
    x993 = -2.0 * x1 * x21 * x24 * x30 * x36 * x5 * x992 + x13 * x47
    x994 = -x993
    x995 = x17 * x994
    x996 = -2.0 * x1 * x19 * x21 * x24 * x30 * x5 * x992 + x13 * x38
    x997 = x64 * (-x995 - x996)
    x998 = -2.0 * x1 * x21 * x24 * x30 * x46 * x5 * x992 + x13 * x82
    x999 = -x998
    x1000 = x355 * x999 + x997
    x1001 = x1000 * x17
    x1002 = -x996
    x1003 = x1002 * x17
    x1004 = -2.0 * x1 * x21 * x24 * x30 * x32 * x5 * x992 + x13 * x29
    x1005 = x64 * (-x1003 - x1004)
    x1006 = x1005 + x355 * x994
    x1007 = x17 * x999
    x1008 = x64 * (-x1007 - x993)
    x1009 = -2.0 * x1 * x21 * x24 * x30 * x5 * x81 * x992 + x104 * x13
    x1010 = -x1009
    x1011 = x1008 + x1010 * x355
    x1012 = x1 * (x16 * x4 * x7 * x994 - x359 * x999) + x1011 * x62
    x1013 = x1012 * x62 + x130 * (-x1001 + x1006)
    x1014 = -x1004
    x1015 = x1014 * x3
    x1016 = x1002 * x3
    x1017 = x50 * x994
    x1018 = -x1002 * x31 + x1017 * x7
    x1019 = -x1018
    x1020 = x1019 * x17
    x1021 = x1016 + x1020 * x7
    x1022 = x1002 * x50
    x1023 = -x1014 * x31 + x1022 * x7
    x1024 = -x1023
    x1025 = x3 * x994
    x1026 = x50 * x999
    x1027 = x1026 * x7 - x31 * x994
    x1028 = -x1027
    x1029 = x1028 * x17
    x1030 = x1025 + x1029 * x7
    x1031 = x1030 * x17
    x1032 = x64 * (-x1018 - x1029)
    x1033 = x3 * x999
    x1034 = x1010 * x50
    x1035 = -x1034 * x7 + x31 * x999
    x1036 = x1035 * x17
    x1037 = x1033 + x1036 * x7
    x1038 = x1037 * x17
    x1039 = x1032 + x1033 * x62 + x1038 * x7
    x1040 = x1039 * x17
    x1041 = x64 * (-x1020 - x1023)
    x1042 = x1025 * x62 + x1031 * x7 + x1041
    x1043 = x64 * (-x1027 - x1036)
    x1044 = x1010 * x3
    x1045 = 2.0 * x1 * x103 * x21 * x24 * x30 * x5 * x992 - x13 * x143
    x1046 = x1045 * x50
    x1047 = x1010 * x31 - x1046 * x7
    x1048 = x1044 + x1047 * x62
    x1049 = x1043 + x1044 * x62 + x1048 * x62
    x1050 = x1 * (x1030 - x1038) + x1011 * x3 + x1049 * x62
    x1051 = x1012 * x3 + x1050 * x62 + x130 * (-x1040 + x1042)
    x1052 = (
        x1013 * x3
        + x1051 * x62
        + x117
        * (
            x1 * (x1015 - x1021 * x17 + x1024 * x62)
            + x1006 * x3
            + x1042 * x62
            - x17 * (x1 * (x1021 - x1031) + x1000 * x3 + x1040 * x7)
        )
    )
    x1053 = x1052 + x162 * x23
    x1054 = x1013 * x62 + x117 * (
        x1 * (-x1002 * x359 + x1014 * x16 * x4 * x7)
        + x1006 * x62
        - x17 * (x1 * (x1002 * x16 * x4 * x7 - x359 * x994) + x1001 * x7)
    )
    x1055 = x1054 + x165 * x23
    x1056 = x1024 * x3
    x1057 = 2.0 * x1056
    x1058 = x1019 * x3
    x1059 = 2.0 * x1058
    x1060 = -x1017 - x996
    x1061 = x1060 * x42
    x1062 = x1028 * x170
    x1063 = x1019 * x31 + x1061 - x1062
    x1064 = x1063 * x17
    x1065 = x1059 + x1064 * x7
    x1066 = -x1004 - x1022
    x1067 = x1066 * x42
    x1068 = x1019 * x170
    x1069 = x1024 * x31 + x1067 - x1068
    x1070 = x1028 * x3
    x1071 = 2.0 * x1070
    x1072 = -x1026 - x993
    x1073 = x1072 * x42
    x1074 = x1035 * x170
    x1075 = x1028 * x31 + x1073 - x1074
    x1076 = x1075 * x17
    x1077 = x1071 + x1076 * x7
    x1078 = x1077 * x17
    x1079 = -x1060 * x42
    x1080 = x64 * (x1019 * x31 - x1062 - x1076 - x1079)
    x1081 = x1035 * x3
    x1082 = 2.0 * x1081
    x1083 = x42 * (-x1034 - x998)
    x1084 = x1035 * x31 - x1047 * x170 + x1083
    x1085 = x1084 * x17
    x1086 = x17 * (x1082 + x1085 * x7)
    x1087 = x17 * (x1037 * x67 + x1080 + x1086 * x7)
    x1088 = -x1066 * x42
    x1089 = x64 * (x1024 * x31 - x1064 - x1068 - x1088)
    x1090 = x1030 * x67 + x1078 * x7 + x1089
    x1091 = -x1072 * x42
    x1092 = x64 * (x1028 * x31 - x1074 - x1085 - x1091)
    x1093 = x1047 * x3
    x1094 = 2.0 * x1093
    x1095 = x42 * (-x1009 - x1046)
    x1096 = 2.0 * x1 * x142 * x21 * x24 * x30 * x5 * x992 - x13 * x200
    x1097 = x1047 * x31 + x1095 - x170 * (x1045 * x31 - x1096 * x170)
    x1098 = x482 * x7
    x1099 = x1 * (x10 * x16 * x4 * x994 - x212 * x999)
    x1100 = x1010 * x483 + 0.5 * x1099
    x1101 = x1 * (x10 * x202 * x203 * x7 * x994 - x1098 * x999) + x1100 * x62
    x1102 = x1 * (x10 * x1024 * x16 * x4 - x1019 * x212)
    x1103 = x1028 * x212
    x1104 = x1 * (x10 * x1019 * x16 * x4 - x1103)
    x1105 = x1035 * x212
    x1106 = x1033 * x235
    x1107 = x1105 * x7 + x1106
    x1108 = x1107 * x17
    x1109 = x1025 * x235
    x1110 = x1103 * x7 + x1109
    x1111 = x1 * (x10 * x1028 * x16 * x4 - x1105)
    x1112 = x1044 * x235
    x1113 = x1047 * x224 + x1112
    x1114 = x1044 * x224 + 0.5 * x1111 + x1113 * x62
    x1115 = x1 * (-x1108 + x1110) + x1100 * x3 + x1114 * x62
    x1116 = (
        x1101 * x3
        + x1115 * x62
        + x130
        * (
            x1025 * x224
            + 0.5 * x1102
            + x1110 * x62
            - x17 * (x1033 * x224 + 0.5 * x1104 + x1108 * x7)
        )
    )
    x1117 = x1116 + x23 * x248
    x1118 = x1 * (x10 * x1014 * x16 * x4 - x1002 * x212)
    x1119 = x1 * (x10 * x1002 * x16 * x4 - x212 * x994)
    x1120 = x1101 * x62 + x130 * (
        0.5 * x1118 - x17 * (0.5 * x1119 + x483 * x999) + x483 * x994
    )
    x1121 = x1120 + x23 * x253
    x1122 = x1 * (x10 * x1069 * x16 * x4 - x1063 * x212)
    x1123 = x1075 * x212
    x1124 = x1 * (x10 * x1063 * x16 * x4 - x1123)
    x1125 = x1084 * x212
    x1126 = x17 * (x1082 * x235 + x1125 * x7)
    x1127 = x1071 * x235 + x1123 * x7
    x1128 = x1 * (x10 * x1075 * x16 * x4 - x1125)
    x1129 = x1007 * x13 + x93
    x1130 = x13 * x995 + x71
    x1131 = x1129 * x17
    x1132 = x1 * (x1130 - x1131)
    x1133 = 0.5 * x1132
    x1134 = x1010 * x290 + x132
    x1135 = x1133 + x1134 * x355
    x1136 = x1 * (-x1129 * x359 + x1130 * x16 * x4 * x7) + x1135 * x62
    x1137 = x1020 * x13 + x41
    x1138 = x1 * (x1024 * x290 - x1137 * x17 + x35)
    x1139 = 0.5 * x1138
    x1140 = x1029 * x13 + x76
    x1141 = x1140 * x17
    x1142 = x1 * (x1137 - x1141)
    x1143 = 0.5 * x1142
    x1144 = x1129 * x3
    x1145 = x100 + x1036 * x13
    x1146 = x1145 * x17
    x1147 = x1144 + x1146 * x7
    x1148 = x1147 * x17
    x1149 = x1130 * x3
    x1150 = x1141 * x7 + x1149
    x1151 = x1 * (x1140 - x1146)
    x1152 = 0.5 * x1151
    x1153 = x1134 * x3
    x1154 = x1047 * x290 + x139
    x1155 = x1153 + x1154 * x62
    x1156 = x1152 + x1153 * x62 + x1155 * x62
    x1157 = x1 * (-x1148 + x1150) + x1135 * x3 + x1156 * x62
    x1158 = (
        x1136 * x3
        + x1157 * x62
        + x130
        * (x1139 + x1149 * x62 + x1150 * x62 - x17 * (x1143 + x1144 * x62 + x1148 * x7))
    )
    x1159 = x1158 + x23 * x306
    x1160 = x1003 * x13 + x159
    x1161 = x1 * (x1014 * x290 - x1160 * x17 + x161)
    x1162 = 0.5 * x1161
    x1163 = x1130 * x17
    x1164 = x1 * (x1160 - x1163)
    x1165 = 0.5 * x1164
    x1166 = x1136 * x62 + x130 * (x1130 * x355 + x1162 - x17 * (x1129 * x355 + x1165))
    x1167 = x1166 + x23 * x312
    x1168 = x1064 * x13 + x167
    x1169 = x1 * (x1069 * x290 - x1168 * x17 + x166)
    x1170 = 0.5 * x1169
    x1171 = x1076 * x13 + x179
    x1172 = x1171 * x17
    x1173 = x1 * (x1168 - x1172)
    x1174 = 0.5 * x1173
    x1175 = x1145 * x3
    x1176 = 2.0 * x1175
    x1177 = x1085 * x13 + x188
    x1178 = x1177 * x17
    x1179 = x17 * (x1176 + x1178 * x7)
    x1180 = x1140 * x3
    x1181 = 2.0 * x1180
    x1182 = x1172 * x7 + x1181
    x1183 = x1 * (x1171 - x1178)
    x1184 = 0.5 * x1183
    x1185 = x1154 * x3
    x1186 = 2.0 * x1185
    x1187 = x1097 * x290 + x197
    x1188 = x1028 * x323 + x1041
    x1189 = x1188 * x3
    x1190 = x1032 + x1035 * x323
    x1191 = x1190 * x3
    x1192 = x17 * (x1080 + x1084 * x323)
    x1193 = x1075 * x323 + x1089
    x1194 = x1005 + x323 * x994
    x1195 = x1194 * x3
    x1196 = x323 * x999 + x997
    x1197 = x1196 * x3
    x1198 = x1190 * x17
    x1199 = x1196 * x17
    x1200 = x1194 - x1199
    x1201 = x1008 + x1010 * x323
    x1202 = x1200 * x64 + x1201 * x355
    x1203 = x1188 - x1198
    x1204 = x1201 * x3
    x1205 = x1043 + x1047 * x323
    x1206 = x1204 + x1205 * x62
    x1207 = x1203 * x64 + x1204 * x62 + x1206 * x62
    x1208 = (
        x1 * (x1188 * x62 + x1195 - x17 * (x1197 + x1198 * x7)) + x1202 * x3 + x1207 * x62
    )
    x1209 = x1208 + x23 * x357
    x1210 = x1 * (x1194 * x16 * x4 * x7 - x1196 * x359) + x1202 * x62
    x1211 = x1210 + x23 * x360
    x1212 = -x1192 + x1193
    x1213 = x1205 * x3
    x1214 = x1092 + x1097 * x323
    x1215 = x1177 * x212
    x1216 = x1145 * x212
    x1217 = x1144 * x235
    x1218 = x1149 * x235
    x1219 = x1 * (x10 * x1130 * x16 * x4 - x1129 * x212)
    x1220 = x1134 * x483 + 0.5 * x1219
    x1221 = x1 * (x10 * x1140 * x16 * x4 - x1216)
    x1222 = x1153 * x235
    x1223 = x1154 * x224 + x1222
    x1224 = x1153 * x224 + 0.5 * x1221 + x1223 * x62
    x1225 = (
        x1 * (x1140 * x224 + x1218 - x17 * (x1216 * x7 + x1217))
        + x1220 * x3
        + x1224 * x62
    )
    x1226 = x1225 + x23 * x387
    x1227 = x1 * (x10 * x1130 * x202 * x203 * x7 - x1098 * x1129) + x1220 * x62
    x1228 = x1227 + x23 * x389
    x1229 = x1 * (x10 * x1171 * x16 * x4 - x1215)
    x1230 = x1041 + x1141 * x13 + x799
    x1231 = x1230 * x3
    x1232 = 2.0 * x1231
    x1233 = x1032 + x1146 * x13 + x802
    x1234 = x1233 * x3
    x1235 = 2.0 * x1234
    x1236 = x1080 + x1178 * x13 + x805
    x1237 = x1236 * x17
    x1238 = x1089 + x1172 * x13 + x807
    x1239 = x1005 + x1163 * x13 + x269
    x1240 = x1239 * x3
    x1241 = x1131 * x13 + x265 + x997
    x1242 = x1241 * x3
    x1243 = x1233 * x17
    x1244 = x1241 * x17
    x1245 = x1239 - x1244
    x1246 = x1245 * x64
    x1247 = x1008 + x1134 * x290 + x279
    x1248 = x1246 + x1247 * x355
    x1249 = x1230 - x1243
    x1250 = x1249 * x64
    x1251 = x1247 * x3
    x1252 = x1043 + x1154 * x290 + x820
    x1253 = x1251 + x1252 * x62
    x1254 = x1250 + x1251 * x62 + x1253 * x62
    x1255 = (
        x1 * (x1230 * x62 + x1240 - x17 * (x1242 + x1243 * x7)) + x1248 * x3 + x1254 * x62
    )
    x1256 = x1255 + x23 * x429
    x1257 = x1 * (x1239 * x16 * x4 * x7 - x1241 * x359) + x1248 * x62
    x1258 = x1257 + x23 * x431
    x1259 = -x1237 + x1238
    x1260 = x1259 * x64
    x1261 = x1252 * x3
    x1262 = 2.0 * x1261
    x1263 = x1092 + x1187 * x290 + x830
    x1264 = x1102 + x1188 * x235 - x17 * (x10 * x1198 + x1104)
    x1265 = x1099 + x1201 * x235
    x1266 = x1265 * x3
    x1267 = x1111 + x1205 * x235
    x1268 = x1266 + x1267 * x62
    x1269 = x1264 * x64 + x1266 * x62 + x1268 * x62
    x1270 = x1269 + x23 * x447
    x1271 = x1118 + x1194 * x235 - x17 * (x10 * x1199 + x1119)
    x1272 = x1265 * x355 + x1271 * x64
    x1273 = x1272 + x23 * x450
    x1274 = x1122 + x1193 * x235 - x17 * (x10 * x1192 + x1124)
    x1275 = x1267 * x3
    x1276 = x1128 + x1214 * x235
    x1277 = x1139 + x1140 * x323 - x17 * (x1143 + x1145 * x323)
    x1278 = x1133 + x1134 * x323
    x1279 = x1278 * x3
    x1280 = x1152 + x1154 * x323
    x1281 = x1279 + x1280 * x62
    x1282 = x1277 * x64 + x1279 * x62 + x1281 * x62
    x1283 = x1282 + x23 * x466
    x1284 = x1130 * x323 + x1162 - x17 * (x1129 * x323 + x1165)
    x1285 = x1278 * x355 + x1284 * x64
    x1286 = x1285 + x23 * x469
    x1287 = x1170 + x1171 * x323 - x17 * (x1174 + x1177 * x323)
    x1288 = x1280 * x3
    x1289 = x1184 + x1187 * x323
    x1290 = x1 * (x10 * x1230 * x16 * x4 - x1233 * x212)
    x1291 = x1251 * x235
    x1292 = x1252 * x224 + x1291
    x1293 = x1251 * x224 + 0.5 * x1290 + x1292 * x62
    x1294 = x1293 + x23 * x479
    x1295 = x1 * (x10 * x1239 * x16 * x4 - x1241 * x212)
    x1296 = x1247 * x483 + 0.5 * x1295
    x1297 = x1296 + x23 * x484
    x1298 = x1 * (x10 * x1238 * x16 * x4 - x1236 * x212)
    x1299 = x1138 + x1230 * x290 - x17 * (x1142 + x1243 * x13 + x402) + x400
    x1300 = x1299 * x64
    x1301 = x1132 + x1247 * x290 + x409
    x1302 = x1301 * x3
    x1303 = x1151 + x1252 * x290 + x415
    x1304 = x1302 + x1303 * x62
    x1305 = x1300 + x1302 * x62 + x1304 * x62
    x1306 = x1305 + x23 * x499
    x1307 = x1161 + x1239 * x290 - x17 * (x1164 + x1244 * x13 + x424) + x422
    x1308 = x1307 * x64
    x1309 = x1301 * x355 + x1308
    x1310 = x1309 + x23 * x503
    x1311 = x1169 + x1238 * x290 - x17 * (x1173 + x1237 * x13 + x395) + x393
    x1312 = x1311 * x64
    x1313 = x1303 * x3
    x1314 = 2.0 * x1313
    x1315 = x1183 + x1263 * x290 + x434
    x1316 = x1200 * x130 + x1265 * x235
    x1317 = x1316 * x3
    x1318 = x1203 * x130 + x1267 * x235
    x1319 = x1317 + x1318 * x62
    x1320 = x1319 + x23 * x515
    x1321 = x1316 * x62
    x1322 = x23 * x62
    x1323 = x1321 + x1322 * x513
    x1324 = x1318 * x3
    x1325 = x1212 * x130 + x1276 * x235
    x1326 = x1219 + x1278 * x235
    x1327 = x1326 * x3
    x1328 = x1221 + x1280 * x235
    x1329 = x1327 + x1328 * x62
    x1330 = x1329 + x23 * x526
    x1331 = x1326 * x62
    x1332 = x1322 * x524 + x1331
    x1333 = x1328 * x3
    x1334 = x1229 + x1289 * x235
    x1335 = x1246 + x1247 * x323
    x1336 = x1335 * x3
    x1337 = x1250 + x1252 * x323
    x1338 = x1336 + x1337 * x62
    x1339 = x1338 + x23 * x536
    x1340 = x1335 * x62
    x1341 = x1322 * x534 + x1340
    x1342 = x1337 * x3
    x1343 = x1260 + x1263 * x323
    x1344 = x1302 * x235
    x1345 = x1303 * x224 + x1344
    x1346 = x1345 + x23 * x542
    x1347 = x1301 * x224
    x1348 = x1347 + x23 * x544
    x1349 = x1245 * x130 + x1301 * x290 + x489
    x1350 = x1349 * x3
    x1351 = x1249 * x130 + x1303 * x290 + x492
    x1352 = x1350 + x1351 * x62
    x1353 = x1352 + x23 * x551
    x1354 = x1349 * x62
    x1355 = x1322 * x549 + x1354
    x1356 = x1351 * x3
    x1357 = 2.0 * x1356
    x1358 = x1259 * x130 + x1315 * x290 + x506
    x1359 = x117 * x1264 + x1318 * x235
    x1360 = x1359 + x23 * x556
    x1361 = x117 * x1271 + x1316 * x235
    x1362 = x1361 + x23 * x558
    x1363 = x1277 * x130 + x1328 * x235
    x1364 = x1363 + x23 * x560
    x1365 = x1284 * x130 + x1326 * x235
    x1366 = x1365 + x23 * x562
    x1367 = x1290 + x1337 * x235
    x1368 = x1367 + x23 * x564
    x1369 = x1295 + x1335 * x235
    x1370 = x1369 + x23 * x566
    x1371 = x1300 + x1303 * x323
    x1372 = x1371 + x23 * x568
    x1373 = x1301 * x323 + x1308
    x1374 = x1373 + x23 * x570
    x1375 = x1351 * x235
    x1376 = x1375 + x23 * x572
    x1377 = x1349 * x235
    x1378 = x1377 + x23 * x574
    x1379 = x117 * x1299 + x1351 * x290 + x546
    x1380 = x1379 + x23 * x576
    x1381 = x117 * x1307 + x1349 * x290 + x550
    x1382 = x1381 + x23 * x578
    x1383 = x10 * x613
    x1384 = -x1383 + x579 * x581 + x80
    x1385 = x1384 * x17
    x1386 = x10 * x604
    x1387 = x64 * (-x1385 - x1386 + x579 * x589 - x98)
    x1388 = -x10 * x621 + x102 + x579 * x586
    x1389 = x1387 + x1388 * x355
    x1390 = x1389 * x17
    x1391 = -x1386 + x45 + x579 * x589
    x1392 = x1391 * x17
    x1393 = x10 * x609
    x1394 = x64 * (-x114 - x1392 - x1393 + x579 * x601)
    x1395 = x1384 * x355 + x1394
    x1396 = x1388 * x17
    x1397 = x64 * (-x137 - x1383 - x1396 + x579 * x581)
    x1398 = -x10 * x633 + x141 + x579 * x597
    x1399 = x1397 + x1398 * x355
    x1400 = x1 * (x1384 * x16 * x4 * x7 - x1388 * x359) + x1399 * x62
    x1401 = x130 * (-x1390 + x1395) + x1400 * x62
    x1402 = -x1393 + x579 * x601 + x58
    x1403 = (
        x117
        * (
            x1 * (-x1391 * x359 + x1402 * x16 * x4 * x7)
            + x1395 * x62
            - x17 * (x1 * (-x1384 * x359 + x1391 * x16 * x4 * x7) + x1390 * x7)
        )
        + x1401 * x62
    )
    x1404 = x1403 + x22 * x641
    x1405 = x1404 + x22 * x642
    x1406 = x1402 * x3
    x1407 = x1391 * x3
    x1408 = x1384 * x170 - x1391 * x31
    x1409 = -x1408
    x1410 = x1409 * x17
    x1411 = x1407 + x1410 * x7
    x1412 = x1391 * x170 - x1402 * x31
    x1413 = -x1412
    x1414 = x1384 * x3
    x1415 = -x1384 * x31 + x1388 * x170
    x1416 = -x1415
    x1417 = x1416 * x17
    x1418 = x1414 + x1417 * x7
    x1419 = x1418 * x17
    x1420 = x64 * (-x1408 - x1417)
    x1421 = x1388 * x3
    x1422 = x1388 * x31 - x1398 * x170
    x1423 = x1422 * x17
    x1424 = x17 * (x1421 + x1423 * x7)
    x1425 = x17 * (x1420 + x1421 * x62 + x1424 * x7)
    x1426 = x64 * (-x1410 - x1412)
    x1427 = x1414 * x62 + x1419 * x7 + x1426
    x1428 = x64 * (-x1415 - x1423)
    x1429 = x1398 * x3
    x1430 = x10 * x50
    x1431 = -x1430 * x680 + x199 + x579 * x632
    x1432 = x1398 * x31 - x1431 * x170
    x1433 = 2.0 * x620
    x1434 = x10 * x1396 + x1433
    x1435 = 2.0 * x612
    x1436 = x10 * x1385 + x1435
    x1437 = x1434 * x17
    x1438 = x1 * (x1436 - x1437)
    x1439 = 2.0 * x631
    x1440 = x1398 * x235 + x1439
    x1441 = 0.5 * x1438 + x1440 * x355
    x1442 = x1 * (-x1434 * x359 + x1436 * x16 * x4 * x7) + x1441 * x62
    x1443 = x10 * x1392 + 2.0 * x603
    x1444 = x1 * (x1402 * x235 - x1443 * x17 + 2.0 * x602)
    x1445 = x1436 * x17
    x1446 = x1 * (x1443 - x1445)
    x1447 = (
        x130 * (x1436 * x355 + 0.5 * x1444 - x17 * (x1434 * x355 + 0.5 * x1446))
        + x1442 * x62
    )
    x1448 = x1447 + x22 * x713
    x1449 = x1448 + x22 * x714
    x1450 = x10 * x1410 + x646
    x1451 = x1 * (x1413 * x235 - x1450 * x17 + x644)
    x1452 = x10 * x1417 + x658
    x1453 = x1452 * x17
    x1454 = x1 * (x1450 - x1453)
    x1455 = x1434 * x3
    x1456 = x17 * (x10 * x1423 + x668)
    x1457 = x17 * (x1455 + x1456 * x7)
    x1458 = x1436 * x3
    x1459 = x1453 * x7 + x1458
    x1460 = x1 * (x1452 - x1456)
    x1461 = x1440 * x3
    x1462 = x1432 * x235 + x678
    x1463 = x366 * x7
    x1464 = x1 * (x13 * x1384 * x16 * x4 - x1388 * x261)
    x1465 = 0.5 * x1464
    x1466 = x1398 * x731 + x1465
    x1467 = x1 * (x13 * x1384 * x202 * x203 * x7 - x1388 * x1463) + x1466 * x62
    x1468 = x1 * (x13 * x1402 * x16 * x4 - x1391 * x261)
    x1469 = 0.5 * x1468
    x1470 = x1 * (x13 * x1391 * x16 * x4 - x1384 * x261)
    x1471 = 0.5 * x1470
    x1472 = x130 * (x1384 * x731 + x1469 - x17 * (x1388 * x731 + x1471)) + x1467 * x62
    x1473 = x1472 + x22 * x757
    x1474 = x1473 + x22 * x758
    x1475 = x1 * (x13 * x1413 * x16 * x4 - x1409 * x261)
    x1476 = 0.5 * x1475
    x1477 = x1416 * x261
    x1478 = x1 * (x13 * x1409 * x16 * x4 - x1477)
    x1479 = 0.5 * x1478
    x1480 = x1422 * x261
    x1481 = x1421 * x290
    x1482 = x17 * (x1480 * x7 + x1481)
    x1483 = x1414 * x290
    x1484 = x1477 * x7 + x1483
    x1485 = x1 * (x13 * x1416 * x16 * x4 - x1480)
    x1486 = 0.5 * x1485
    x1487 = x1429 * x290
    x1488 = x10 * x1445 + x1394 + 2.0 * x699
    x1489 = x1488 * x3
    x1490 = x10 * x1437 + x1387 + 2.0 * x694
    x1491 = x1490 * x3
    x1492 = x17 * (x10 * x1456 + x1420 + x720)
    x1493 = x10 * x1453 + x1426 + x723
    x1494 = x1490 * x17
    x1495 = x1488 - x1494
    x1496 = x1397 + x1440 * x235 + 2.0 * x702
    x1497 = x1495 * x64 + x1496 * x355
    x1498 = x1 * (x1488 * x16 * x4 * x7 - x1490 * x359) + x1497 * x62
    x1499 = x1498 + x22 * x794
    x1500 = x1499 + x22 * x795
    x1501 = -x1492 + x1493
    x1502 = x1496 * x3
    x1503 = x1428 + x1462 * x235 + x726
    x1504 = x1384 * x369 + x1435 * x290
    x1505 = x1504 * x3
    x1506 = x1388 * x369 + x1433 * x290
    x1507 = x1506 * x3
    x1508 = x17 * (x1422 * x369 + x765)
    x1509 = x1416 * x369 + x767
    x1510 = x1506 * x17
    x1511 = x1 * (x1504 - x1510)
    x1512 = x1398 * x369 + x1439 * x290
    x1513 = 0.5 * x1511 + x1512 * x355
    x1514 = x1 * (x1504 * x16 * x4 * x7 - x1506 * x359) + x1513 * x62
    x1515 = x1514 + x22 * x826
    x1516 = x1515 + x22 * x827
    x1517 = x1 * (-x1508 + x1509)
    x1518 = x1512 * x3
    x1519 = x1432 * x369 + x771
    x1520 = x1384 * x391 + x1394
    x1521 = x1520 * x3
    x1522 = x1387 + x1388 * x391
    x1523 = x1522 * x3
    x1524 = x17 * (x1420 + x1422 * x391)
    x1525 = x1416 * x391 + x1426
    x1526 = x1522 * x17
    x1527 = x1520 - x1526
    x1528 = x1527 * x64
    x1529 = x1397 + x1398 * x391
    x1530 = x1528 + x1529 * x355
    x1531 = x1 * (x1520 * x16 * x4 * x7 - x1522 * x359) + x1530 * x62
    x1532 = x1531 + x22 * x858
    x1533 = x1532 + x22 * x859
    x1534 = -x1524 + x1525
    x1535 = x1534 * x64
    x1536 = x1529 * x3
    x1537 = x1428 + x1432 * x391
    x1538 = x1444 + x1488 * x235 - x17 * (x10 * x1494 + x1446 + 2.0 * x781) + 2.0 * x779
    x1539 = x1438 + x1496 * x235 + 2.0 * x788
    x1540 = x1538 * x64 + x1539 * x355
    x1541 = x1540 + x22 * x873
    x1542 = x1541 + x22 * x874
    x1543 = x1451 + x1493 * x235 - x17 * (x10 * x1492 + x1454 + x775) + x773
    x1544 = x1539 * x3
    x1545 = x1460 + x1503 * x235 + x797
    x1546 = x1469 + x1504 * x235 - x17 * (x10 * x1510 + x1471 + 2.0 * x812) + 2.0 * x810
    x1547 = x1465 + x1512 * x235 + 2.0 * x819
    x1548 = x1546 * x64 + x1547 * x355
    x1549 = x1548 + x22 * x886
    x1550 = x1549 + x22 * x887
    x1551 = x1476 + x1509 * x235 - x17 * (x10 * x1508 + x1479 + x804) + x801
    x1552 = x1547 * x3
    x1553 = x1486 + x1519 * x235 + x829
    x1554 = x1 * (x1520 * x235 - x17 * (x10 * x1526 + 2.0 * x843) + 2.0 * x841)
    x1555 = x1529 * x235 + 2.0 * x852
    x1556 = 0.5 * x1554 + x1555 * x355
    x1557 = x1556 + x22 * x899
    x1558 = x1557 + x22 * x900
    x1559 = x1 * (x1525 * x235 - x17 * (x10 * x1524 + x837) + x834)
    x1560 = x1555 * x3
    x1561 = x1537 * x235 + x863
    x1562 = x1468 + x1520 * x290 - x17 * (x13 * x1526 + x1470)
    x1563 = x1562 * x64
    x1564 = x1464 + x1529 * x290
    x1565 = x1563 + x1564 * x355
    x1566 = x1565 + x22 * x914
    x1567 = x1566 + x22 * x915
    x1568 = x1475 + x1525 * x290 - x17 * (x13 * x1524 + x1478)
    x1569 = x1568 * x64
    x1570 = x1564 * x3
    x1571 = x1485 + x1537 * x290
    x1572 = x130 * x1495 + x1539 * x235 + 2.0 * x867
    x1573 = x1572 * x3
    x1574 = x1572 * x62
    x1575 = x1574 + x22 * x926
    x1576 = x1575 + x22 * x928
    x1577 = x130 * x1501 + x1545 * x235 + x876
    x1578 = x1511 + x1547 * x235 + 2.0 * x880
    x1579 = x1578 * x3
    x1580 = x1578 * x62
    x1581 = x1580 + x22 * x936
    x1582 = x1581 + x22 * x937
    x1583 = x1517 + x1553 * x235 + x889
    x1584 = x1528 + x1555 * x235 + 2.0 * x893
    x1585 = x1584 * x3
    x1586 = x1584 * x62
    x1587 = x1586 + x22 * x945
    x1588 = x1587 + x22 * x946
    x1589 = x1535 + x1561 * x235 + x902
    x1590 = x1564 * x235 + 2.0 * x907
    x1591 = x1590 * x3
    x1592 = x1590 * x62
    x1593 = x1592 + x22 * x954
    x1594 = x1593 + x22 * x955
    x1595 = x1571 * x235 + x919
    x1596 = x130 * x1527 + x1564 * x290
    x1597 = x1596 * x3
    x1598 = x1596 * x62
    x1599 = x1598 + x22 * x963
    x1600 = x1599 + x22 * x964
    x1601 = x130 * x1534 + x1571 * x290
    x1602 = x117 * x1538 + x1572 * x235 + 2.0 * x922
    x1603 = x1602 + x22 * x970
    x1604 = x1603 + x22 * x971
    x1605 = x130 * x1546 + x1578 * x235 + 2.0 * x932
    x1606 = x1605 + x22 * x974
    x1607 = x1606 + x22 * x975
    x1608 = x1554 + x1584 * x235 + 2.0 * x941
    x1609 = x1608 + x22 * x978
    x1610 = x1609 + x22 * x979
    x1611 = x1563 + x1590 * x235 + 2.0 * x950
    x1612 = x1611 + x22 * x982
    x1613 = x1612 + x22 * x983
    x1614 = x1596 * x235 + 2.0 * x959
    x1615 = x1614 + x22 * x986
    x1616 = x1615 + x22 * x987
    x1617 = x117 * x1562 + x1596 * x290
    x1618 = x1617 + x22 * x990
    x1619 = x1618 + x22 * x991
    x1620 = x10 * x1026 - x579 * x994
    x1621 = -x1620
    x1622 = x1621 * x17
    x1623 = x10 * x1017 - x1002 * x579
    x1624 = x64 * (-x1622 - x1623)
    x1625 = -x10 * x1034 + x579 * x999
    x1626 = x1624 + x1625 * x355
    x1627 = x1626 * x17
    x1628 = -x1623
    x1629 = x1628 * x17
    x1630 = x10 * x1022 - x1014 * x579
    x1631 = x64 * (-x1629 - x1630)
    x1632 = x1621 * x355 + x1631
    x1633 = x1625 * x17
    x1634 = x64 * (-x1620 - x1633)
    x1635 = -x10 * x1046 + x1010 * x579
    x1636 = x1634 + x1635 * x355
    x1637 = x1 * (x16 * x1621 * x4 * x7 - x1625 * x359) + x1636 * x62
    x1638 = x130 * (-x1627 + x1632) + x1637 * x62
    x1639 = -x1630
    x1640 = (
        x117
        * (
            x1 * (x16 * x1639 * x4 * x7 - x1628 * x359)
            + x1632 * x62
            - x17 * (x1 * (x16 * x1628 * x4 * x7 - x1621 * x359) + x1627 * x7)
        )
        + x1638 * x62
    )
    x1641 = x1640 + x23 * x641
    x1642 = x1055 * x22 + x1641
    x1643 = x1639 * x3
    x1644 = x1628 * x3
    x1645 = x1621 * x170 - x1628 * x31
    x1646 = -x1645 * x17
    x1647 = x1644 + x1646 * x7
    x1648 = x1628 * x170 - x1639 * x31
    x1649 = -x1648
    x1650 = x1621 * x3
    x1651 = -x1621 * x31 + x1625 * x170
    x1652 = -x1651 * x17
    x1653 = x1650 + x1652 * x7
    x1654 = x1653 * x17
    x1655 = x64 * (-x1645 - x1652)
    x1656 = x1625 * x3
    x1657 = x17 * (x1625 * x31 - x1635 * x170)
    x1658 = x17 * (x1656 + x1657 * x7)
    x1659 = x17 * (x1655 + x1656 * x62 + x1658 * x7)
    x1660 = x64 * (-x1646 - x1648)
    x1661 = x1650 * x62 + x1654 * x7 + x1660
    x1662 = x64 * (-x1651 - x1657)
    x1663 = x1635 * x3
    x1664 = x1045 * x579 - x1096 * x1430
    x1665 = x1635 * x31 - x1664 * x170
    x1666 = x10 * x1633 + x1033
    x1667 = x10 * x1622 + x1025
    x1668 = x1666 * x17
    x1669 = x1 * (x1667 - x1668)
    x1670 = x1044 + x1635 * x235
    x1671 = 0.5 * x1669 + x1670 * x355
    x1672 = x1 * (x16 * x1667 * x4 * x7 - x1666 * x359) + x1671 * x62
    x1673 = x10 * x1629 + x1016
    x1674 = x1 * (x1015 + x1639 * x235 - x1673 * x17)
    x1675 = x1667 * x17
    x1676 = x1 * (x1673 - x1675)
    x1677 = (
        x130 * (x1667 * x355 + 0.5 * x1674 - x17 * (x1666 * x355 + 0.5 * x1676))
        + x1672 * x62
    )
    x1678 = x1677 + x23 * x713
    x1679 = x1121 * x22 + x1678
    x1680 = x10 * x1646 + x1058
    x1681 = x1 * (x1056 + x1649 * x235 - x1680 * x17)
    x1682 = x10 * x1652 + x1070
    x1683 = x1682 * x17
    x1684 = x1 * (x1680 - x1683)
    x1685 = x1666 * x3
    x1686 = x17 * (x10 * x1657 + x1081)
    x1687 = x17 * (x1685 + x1686 * x7)
    x1688 = x1667 * x3
    x1689 = x1683 * x7 + x1688
    x1690 = x1 * (x1682 - x1686)
    x1691 = x1670 * x3
    x1692 = x1093 + x1665 * x235
    x1693 = x13 * x1633 + x620
    x1694 = x13 * x1622 + x612
    x1695 = x1693 * x17
    x1696 = x1 * (x1694 - x1695)
    x1697 = 0.5 * x1696
    x1698 = x1635 * x290 + x631
    x1699 = x1697 + x1698 * x355
    x1700 = x1 * (x16 * x1694 * x4 * x7 - x1693 * x359) + x1699 * x62
    x1701 = x13 * x1629 + x603
    x1702 = x1 * (x1639 * x290 - x17 * x1701 + x602)
    x1703 = 0.5 * x1702
    x1704 = x1694 * x17
    x1705 = x1 * (x1701 - x1704)
    x1706 = 0.5 * x1705
    x1707 = x130 * (x1694 * x355 - x17 * (x1693 * x355 + x1706) + x1703) + x1700 * x62
    x1708 = x1707 + x23 * x757
    x1709 = x1167 * x22 + x1708
    x1710 = x13 * x1646 + x645
    x1711 = x1 * (x1649 * x290 - x17 * x1710 + x643)
    x1712 = 0.5 * x1711
    x1713 = x13 * x1652 + x657
    x1714 = x17 * x1713
    x1715 = x1 * (x1710 - x1714)
    x1716 = 0.5 * x1715
    x1717 = x1693 * x3
    x1718 = x17 * (x13 * x1657 + x667)
    x1719 = x17 * (x1717 + x1718 * x7)
    x1720 = x1694 * x3
    x1721 = x1714 * x7 + x1720
    x1722 = x1 * (x1713 - x1718)
    x1723 = 0.5 * x1722
    x1724 = x1698 * x3
    x1725 = x1665 * x290 + x677
    x1726 = x10 * x1675 + x1109 + x1631
    x1727 = x1726 * x3
    x1728 = x10 * x1668 + x1106 + x1624
    x1729 = x1728 * x3
    x1730 = x17 * (x10 * x1686 + x1081 * x235 + x1655)
    x1731 = x10 * x1683 + x1070 * x235 + x1660
    x1732 = x17 * x1728
    x1733 = x1726 - x1732
    x1734 = x1112 + x1634 + x1670 * x235
    x1735 = x1733 * x64 + x1734 * x355
    x1736 = x1 * (x16 * x1726 * x4 * x7 - x1728 * x359) + x1735 * x62
    x1737 = x1736 + x23 * x794
    x1738 = x1211 * x22 + x1737
    x1739 = -x1730 + x1731
    x1740 = x1734 * x3
    x1741 = x1093 * x235 + x1662 + x1692 * x235
    x1742 = x10 * x1704 + x1149
    x1743 = x1742 * x3
    x1744 = x10 * x1695 + x1144
    x1745 = x1744 * x3
    x1746 = x17 * (x10 * x1718 + x1175)
    x1747 = x10 * x1714 + x1180
    x1748 = x17 * x1744
    x1749 = x1 * (x1742 - x1748)
    x1750 = x1153 + x1698 * x235
    x1751 = 0.5 * x1749 + x1750 * x355
    x1752 = x1 * (x16 * x1742 * x4 * x7 - x1744 * x359) + x1751 * x62
    x1753 = x1752 + x23 * x826
    x1754 = x1228 * x22 + x1753
    x1755 = x1 * (-x1746 + x1747)
    x1756 = x1750 * x3
    x1757 = x1185 + x1725 * x235
    x1758 = x13 * x1704 + x1631 + x743
    x1759 = x1758 * x3
    x1760 = x13 * x1695 + x1624 + x740
    x1761 = x1760 * x3
    x1762 = x17 * (x13 * x1718 + x1655 + x290 * x667)
    x1763 = x13 * x1714 + x1660 + x290 * x657
    x1764 = x17 * x1760
    x1765 = x1758 - x1764
    x1766 = x1765 * x64
    x1767 = x1634 + x1698 * x290 + x747
    x1768 = x1766 + x1767 * x355
    x1769 = x1 * (x16 * x1758 * x4 * x7 - x1760 * x359) + x1768 * x62
    x1770 = x1769 + x23 * x858
    x1771 = x1258 * x22 + x1770
    x1772 = -x1762 + x1763
    x1773 = x1772 * x64
    x1774 = x1767 * x3
    x1775 = x1662 + x1725 * x290 + x290 * x677
    x1776 = x1195 + x1674 - x17 * (x10 * x1732 + x1197 + x1676) + x1726 * x235
    x1777 = x1204 + x1669 + x1734 * x235
    x1778 = x1776 * x64 + x1777 * x355
    x1779 = x1778 + x23 * x873
    x1780 = x1273 * x22 + x1779
    x1781 = x1189 + x1681 - x17 * (x10 * x1730 + x1191 + x1684) + x1731 * x235
    x1782 = x1777 * x3
    x1783 = x1213 + x1690 + x1741 * x235
    x1784 = x1218 - x17 * (x10 * x1748 + x1217 + x1706) + x1703 + x1742 * x235
    x1785 = x1222 + x1697 + x1750 * x235
    x1786 = x1784 * x64 + x1785 * x355
    x1787 = x1786 + x23 * x886
    x1788 = x1286 * x22 + x1787
    x1789 = (
        x1180 * x235 - x17 * (x10 * x1746 + x1175 * x235 + x1716) + x1712 + x1747 * x235
    )
    x1790 = x1785 * x3
    x1791 = x1185 * x235 + x1723 + x1757 * x235
    x1792 = x1 * (x1240 - x17 * (x10 * x1764 + x1242) + x1758 * x235)
    x1793 = x1251 + x1767 * x235
    x1794 = 0.5 * x1792 + x1793 * x355
    x1795 = x1794 + x23 * x899
    x1796 = x1297 * x22 + x1795
    x1797 = x1 * (x1231 - x17 * (x10 * x1762 + x1234) + x1763 * x235)
    x1798 = x1793 * x3
    x1799 = x1261 + x1775 * x235
    x1800 = -x17 * (x13 * x1764 + x1705 + x843) + x1702 + x1758 * x290 + x841
    x1801 = x1800 * x64
    x1802 = x1696 + x1767 * x290 + x852
    x1803 = x1801 + x1802 * x355
    x1804 = x1803 + x23 * x914
    x1805 = x1310 * x22 + x1804
    x1806 = -x17 * (x13 * x1762 + x1715 + x836) + x1711 + x1763 * x290 + x833
    x1807 = x1806 * x64
    x1808 = x1802 * x3
    x1809 = x1722 + x1775 * x290 + x862
    x1810 = x1266 + x130 * x1733 + x1777 * x235
    x1811 = x1810 * x3
    x1812 = x1810 * x62
    x1813 = x1812 + x23 * x926
    x1814 = x1323 * x22 + x1813
    x1815 = x1275 + x130 * x1739 + x1783 * x235
    x1816 = x1279 + x1749 + x1785 * x235
    x1817 = x1816 * x3
    x1818 = x1816 * x62
    x1819 = x1818 + x23 * x936
    x1820 = x1332 * x22 + x1819
    x1821 = x1288 + x1755 + x1791 * x235
    x1822 = x1291 + x1766 + x1793 * x235
    x1823 = x1822 * x3
    x1824 = x1822 * x62
    x1825 = x1824 + x23 * x945
    x1826 = x1341 * x22 + x1825
    x1827 = x1261 * x235 + x1773 + x1799 * x235
    x1828 = x1302 + x1802 * x235
    x1829 = x1828 * x3
    x1830 = x1828 * x62
    x1831 = x1830 + x23 * x954
    x1832 = x1348 * x22 + x1831
    x1833 = x1313 + x1809 * x235
    x1834 = x130 * x1765 + x1802 * x290 + x907
    x1835 = x1834 * x3
    x1836 = x1834 * x62
    x1837 = x1836 + x23 * x963
    x1838 = x1355 * x22 + x1837
    x1839 = x130 * x1772 + x1809 * x290 + x918
    x1840 = x117 * x1776 + x1317 + x1810 * x235
    x1841 = x1840 + x23 * x970
    x1842 = x1362 * x22 + x1841
    x1843 = x130 * x1784 + x1327 + x1816 * x235
    x1844 = x1843 + x23 * x974
    x1845 = x1366 * x22 + x1844
    x1846 = x1336 + x1792 + x1822 * x235
    x1847 = x1846 + x23 * x978
    x1848 = x1370 * x22 + x1847
    x1849 = x1344 + x1801 + x1828 * x235
    x1850 = x1849 + x23 * x982
    x1851 = x1374 * x22 + x1850
    x1852 = x1350 + x1834 * x235
    x1853 = x1852 + x23 * x986
    x1854 = x1378 * x22 + x1853
    x1855 = x117 * x1800 + x1834 * x290 + x959
    x1856 = x1855 + x23 * x990
    x1857 = x1382 * x22 + x1856
    x1858 = x1026 * x13
    x1859 = -x1858 + x80 + x992 * x994
    x1860 = x17 * x1859
    x1861 = x1017 * x13
    x1862 = x64 * (x1002 * x992 - x1860 - x1861 - x98)
    x1863 = x102 - x1034 * x13 + x992 * x999
    x1864 = x1862 + x1863 * x355
    x1865 = x17 * x1864
    x1866 = x1002 * x992 - x1861 + x45
    x1867 = x17 * x1866
    x1868 = x1022 * x13
    x1869 = x64 * (x1014 * x992 - x114 - x1867 - x1868)
    x1870 = x1859 * x355 + x1869
    x1871 = x17 * x1863
    x1872 = x64 * (-x137 - x1858 - x1871 + x992 * x994)
    x1873 = x1010 * x992 - x1046 * x13 + x141
    x1874 = x1872 + x1873 * x355
    x1875 = x1 * (x16 * x1859 * x4 * x7 - x1863 * x359) + x1874 * x62
    x1876 = x130 * (-x1865 + x1870) + x1875 * x62
    x1877 = x1014 * x992 - x1868 + x58
    x1878 = (
        x117
        * (
            x1 * (x16 * x1877 * x4 * x7 - x1866 * x359)
            - x17 * (x1 * (x16 * x1866 * x4 * x7 - x1859 * x359) + x1865 * x7)
            + x1870 * x62
        )
        + x1876 * x62
    )
    x1879 = x1054 * x23 + x1878
    x1880 = x1055 * x23 + x1879
    x1881 = x1877 * x3
    x1882 = x1866 * x3
    x1883 = x170 * x1859 - x1866 * x31
    x1884 = -x1883
    x1885 = x17 * x1884
    x1886 = x1882 + x1885 * x7
    x1887 = x170 * x1866 - x1877 * x31
    x1888 = -x1887
    x1889 = x1859 * x3
    x1890 = x170 * x1863 - x1859 * x31
    x1891 = -x1890
    x1892 = x17 * x1891
    x1893 = x1889 + x1892 * x7
    x1894 = x17 * x1893
    x1895 = x64 * (-x1883 - x1892)
    x1896 = x1863 * x3
    x1897 = -x170 * x1873 + x1863 * x31
    x1898 = x17 * x1897
    x1899 = x17 * (x1896 + x1898 * x7)
    x1900 = x17 * (x1895 + x1896 * x62 + x1899 * x7)
    x1901 = x64 * (-x1885 - x1887)
    x1902 = x1889 * x62 + x1894 * x7 + x1901
    x1903 = x64 * (-x1890 - x1898)
    x1904 = x1873 * x3
    x1905 = x13 * x50
    x1906 = x1045 * x992 - x1096 * x1905 + x199
    x1907 = -x170 * x1906 + x1873 * x31
    x1908 = x1 * (x10 * x16 * x1859 * x4 - x1863 * x212)
    x1909 = x1873 * x483 + 0.5 * x1908
    x1910 = x1 * (x10 * x1859 * x202 * x203 * x7 - x1098 * x1863) + x1909 * x62
    x1911 = x1 * (x10 * x16 * x1877 * x4 - x1866 * x212)
    x1912 = x1 * (x10 * x16 * x1866 * x4 - x1859 * x212)
    x1913 = (
        x130 * (-x17 * (x1863 * x483 + 0.5 * x1912) + x1859 * x483 + 0.5 * x1911)
        + x1910 * x62
    )
    x1914 = x1120 * x23 + x1913
    x1915 = x1121 * x23 + x1914
    x1916 = x1 * (x10 * x16 * x1888 * x4 - x1884 * x212)
    x1917 = x1891 * x212
    x1918 = x1 * (x10 * x16 * x1884 * x4 - x1917)
    x1919 = x1897 * x212
    x1920 = x1896 * x235
    x1921 = x17 * (x1919 * x7 + x1920)
    x1922 = x1889 * x235
    x1923 = x1917 * x7 + x1922
    x1924 = x1 * (x10 * x16 * x1891 * x4 - x1919)
    x1925 = x1904 * x235
    x1926 = 2.0 * x1033 + x13 * x1871
    x1927 = 2.0 * x1025 + x13 * x1860
    x1928 = x17 * x1926
    x1929 = x1 * (x1927 - x1928)
    x1930 = 0.5 * x1929
    x1931 = 2.0 * x1044 + x1873 * x290
    x1932 = x1930 + x1931 * x355
    x1933 = x1 * (x16 * x1927 * x4 * x7 - x1926 * x359) + x1932 * x62
    x1934 = 2.0 * x1016 + x13 * x1867
    x1935 = x1 * (2.0 * x1015 - x17 * x1934 + x1877 * x290)
    x1936 = 0.5 * x1935
    x1937 = x17 * x1927
    x1938 = x1 * (x1934 - x1937)
    x1939 = 0.5 * x1938
    x1940 = x130 * (-x17 * (x1926 * x355 + x1939) + x1927 * x355 + x1936) + x1933 * x62
    x1941 = x1166 * x23 + x1940
    x1942 = x1167 * x23 + x1941
    x1943 = x1059 + x13 * x1885
    x1944 = x1 * (x1057 - x17 * x1943 + x1888 * x290)
    x1945 = 0.5 * x1944
    x1946 = x1071 + x13 * x1892
    x1947 = x17 * x1946
    x1948 = x1 * (x1943 - x1947)
    x1949 = 0.5 * x1948
    x1950 = x1926 * x3
    x1951 = x1082 + x13 * x1898
    x1952 = x17 * x1951
    x1953 = x17 * (x1950 + x1952 * x7)
    x1954 = x1927 * x3
    x1955 = x1947 * x7 + x1954
    x1956 = x1 * (x1946 - x1952)
    x1957 = 0.5 * x1956
    x1958 = x1931 * x3
    x1959 = x1094 + x1907 * x290
    x1960 = x1859 * x323 + x1869
    x1961 = x1960 * x3
    x1962 = x1862 + x1863 * x323
    x1963 = x1962 * x3
    x1964 = x17 * (x1895 + x1897 * x323)
    x1965 = x1891 * x323 + x1901
    x1966 = x17 * x1962
    x1967 = x1960 - x1966
    x1968 = x1872 + x1873 * x323
    x1969 = x1967 * x64 + x1968 * x355
    x1970 = x1 * (x16 * x1960 * x4 * x7 - x1962 * x359) + x1969 * x62
    x1971 = x1210 * x23 + x1970
    x1972 = x1211 * x23 + x1971
    x1973 = -x1964 + x1965
    x1974 = x1968 * x3
    x1975 = x1903 + x1907 * x323
    x1976 = x1951 * x212
    x1977 = x1950 * x235
    x1978 = x1954 * x235
    x1979 = x1 * (x10 * x16 * x1927 * x4 - x1926 * x212)
    x1980 = x1931 * x483 + 0.5 * x1979
    x1981 = x1 * (x10 * x1927 * x202 * x203 * x7 - x1098 * x1926) + x1980 * x62
    x1982 = x1227 * x23 + x1981
    x1983 = x1228 * x23 + x1982
    x1984 = x1 * (x10 * x16 * x1946 * x4 - x1976)
    x1985 = x1958 * x235
    x1986 = 2.0 * x1149 + x13 * x1937 + x1869
    x1987 = x1986 * x3
    x1988 = 2.0 * x1144 + x13 * x1928 + x1862
    x1989 = x1988 * x3
    x1990 = x1176 + x13 * x1952 + x1895
    x1991 = x17 * x1990
    x1992 = x1181 + x13 * x1947 + x1901
    x1993 = x17 * x1988
    x1994 = x1986 - x1993
    x1995 = x1994 * x64
    x1996 = 2.0 * x1153 + x1872 + x1931 * x290
    x1997 = x1995 + x1996 * x355
    x1998 = x1 * (x16 * x1986 * x4 * x7 - x1988 * x359) + x1997 * x62
    x1999 = x1257 * x23 + x1998
    x2000 = x1258 * x23 + x1999
    x2001 = -x1991 + x1992
    x2002 = x2001 * x64
    x2003 = x1996 * x3
    x2004 = x1186 + x1903 + x1959 * x290
    x2005 = -x17 * (x10 * x1966 + x1912) + x1911 + x1960 * x235
    x2006 = x1908 + x1968 * x235
    x2007 = x2005 * x64 + x2006 * x355
    x2008 = x1272 * x23 + x2007
    x2009 = x1273 * x23 + x2008
    x2010 = -x17 * (x10 * x1964 + x1918) + x1916 + x1965 * x235
    x2011 = x2006 * x3
    x2012 = x1924 + x1975 * x235
    x2013 = -x17 * (x1926 * x323 + x1939) + x1927 * x323 + x1936
    x2014 = x1930 + x1931 * x323
    x2015 = x2013 * x64 + x2014 * x355
    x2016 = x1285 * x23 + x2015
    x2017 = x1286 * x23 + x2016
    x2018 = -x17 * (x1949 + x1951 * x323) + x1945 + x1946 * x323
    x2019 = x2014 * x3
    x2020 = x1957 + x1959 * x323
    x2021 = x1 * (x10 * x16 * x1986 * x4 - x1988 * x212)
    x2022 = x1996 * x483 + 0.5 * x2021
    x2023 = x1296 * x23 + x2022
    x2024 = x1297 * x23 + x2023
    x2025 = x1 * (x10 * x16 * x1992 * x4 - x1990 * x212)
    x2026 = x2003 * x235
    x2027 = 2.0 * x1240 - x17 * (2.0 * x1242 + x13 * x1993 + x1938) + x1935 + x1986 * x290
    x2028 = x2027 * x64
    x2029 = 2.0 * x1251 + x1929 + x1996 * x290
    x2030 = x2028 + x2029 * x355
    x2031 = x1309 * x23 + x2030
    x2032 = x1310 * x23 + x2031
    x2033 = x1232 - x17 * (x1235 + x13 * x1991 + x1948) + x1944 + x1992 * x290
    x2034 = x2033 * x64
    x2035 = x2029 * x3
    x2036 = x1262 + x1956 + x2004 * x290
    x2037 = x130 * x1967 + x2006 * x235
    x2038 = x2037 * x3
    x2039 = x2037 * x62
    x2040 = x1321 * x23 + x2039
    x2041 = x1323 * x23 + x2040
    x2042 = x130 * x1973 + x2012 * x235
    x2043 = x1979 + x2014 * x235
    x2044 = x2043 * x3
    x2045 = x2043 * x62
    x2046 = x1331 * x23 + x2045
    x2047 = x1332 * x23 + x2046
    x2048 = x1984 + x2020 * x235
    x2049 = x1995 + x1996 * x323
    x2050 = x2049 * x3
    x2051 = x2049 * x62
    x2052 = x1340 * x23 + x2051
    x2053 = x1341 * x23 + x2052
    x2054 = x2002 + x2004 * x323
    x2055 = x2029 * x224
    x2056 = x1347 * x23 + x2055
    x2057 = x1348 * x23 + x2056
    x2058 = x2035 * x235
    x2059 = x130 * x1994 + 2.0 * x1302 + x2029 * x290
    x2060 = x2059 * x3
    x2061 = x2059 * x62
    x2062 = x1354 * x23 + x2061
    x2063 = x1355 * x23 + x2062
    x2064 = x130 * x2001 + x1314 + x2036 * x290
    x2065 = x117 * x2005 + x2037 * x235
    x2066 = x1361 * x23 + x2065
    x2067 = x1362 * x23 + x2066
    x2068 = x130 * x2013 + x2043 * x235
    x2069 = x1365 * x23 + x2068
    x2070 = x1366 * x23 + x2069
    x2071 = x2021 + x2049 * x235
    x2072 = x1369 * x23 + x2071
    x2073 = x1370 * x23 + x2072
    x2074 = x2028 + x2029 * x323
    x2075 = x1373 * x23 + x2074
    x2076 = x1374 * x23 + x2075
    x2077 = x2059 * x235
    x2078 = x1377 * x23 + x2077
    x2079 = x1378 * x23 + x2078
    x2080 = x117 * x2027 + 2.0 * x1350 + x2059 * x290
    x2081 = x1381 * x23 + x2080
    x2082 = x1382 * x23 + x2081
    x2083 = x1384 * x1430
    x2084 = x1391 * x579 - x2083 + 2.0 * x648
    x2085 = x1391 * x1430
    x2086 = x1402 * x579 - x2085 + 2.0 * x654
    x2087 = x1388 * x1430
    x2088 = x1384 * x579 - x2087 + 2.0 * x660
    x2089 = x17 * x2088
    x2090 = x64 * (x1391 * x579 - x2083 - x2089 + 2.0 * x42 * x647)
    x2091 = x1388 * x579 - x1398 * x1430 + 2.0 * x669
    x2092 = x17 * (x2090 + x2091 * x355)
    x2093 = x17 * x2084
    x2094 = x64 * (x1402 * x579 - x2085 - x2093 + 2.0 * x42 * x653)
    x2095 = x2088 * x355 + x2094
    x2096 = x17 * x2091
    x2097 = x64 * (x1384 * x579 - x2087 - x2096 + 2.0 * x42 * x659)
    x2098 = x1398 * x579 - x1430 * x1431 + 2.0 * x679
    x2099 = x10 * x2093 + 3.0 * x1407
    x2100 = x1 * (3.0 * x1406 - x17 * x2099 + x2086 * x235)
    x2101 = 3.0 * x1414
    x2102 = x10 * x2089 + x2101
    x2103 = x17 * x2102
    x2104 = x1 * (x2099 - x2103)
    x2105 = 3.0 * x1421
    x2106 = x10 * x2096 + x2105
    x2107 = x17 * x2106
    x2108 = x1 * (x2102 - x2107)
    x2109 = 3.0 * x1429
    x2110 = x2098 * x235 + x2109
    x2111 = x1 * (x13 * x16 * x2086 * x4 - x2084 * x261)
    x2112 = 0.5 * x2111
    x2113 = x1 * (x13 * x16 * x2084 * x4 - x2088 * x261)
    x2114 = 0.5 * x2113
    x2115 = x1 * (x13 * x16 * x2088 * x4 - x2091 * x261)
    x2116 = 0.5 * x2115
    x2117 = x10 * x2107 + 3.0 * x1455 + x2090
    x2118 = x10 * x2103 + 3.0 * x1458 + x2094
    x2119 = x17 * x2117
    x2120 = x2118 - x2119
    x2121 = 3.0 * x1461 + x2097 + x2110 * x235
    x2122 = x2091 * x369 + x2105 * x290
    x2123 = x2088 * x369 + x2101 * x290
    x2124 = x17 * x2122
    x2125 = x1 * (x2123 - x2124)
    x2126 = x2098 * x369 + x2109 * x290
    x2127 = x2090 + x2091 * x391
    x2128 = x2088 * x391 + x2094
    x2129 = x17 * x2127
    x2130 = x2128 - x2129
    x2131 = x2130 * x64
    x2132 = x2097 + x2098 * x391
    x2133 = 3.0 * x1489 - x17 * (x10 * x2119 + 3.0 * x1491 + x2104) + x2100 + x2118 * x235
    x2134 = 3.0 * x1502 + x2108 + x2121 * x235
    x2135 = 3.0 * x1505 - x17 * (x10 * x2124 + 3.0 * x1507 + x2114) + x2112 + x2123 * x235
    x2136 = 3.0 * x1518 + x2116 + x2126 * x235
    x2137 = x1 * (3.0 * x1521 - x17 * (x10 * x2129 + 3.0 * x1523) + x2128 * x235)
    x2138 = 3.0 * x1536 + x2132 * x235
    x2139 = -x17 * (x13 * x2129 + x2113) + x2111 + x2128 * x290
    x2140 = x2139 * x64
    x2141 = x2115 + x2132 * x290
    x2142 = x130 * x2120 + 3.0 * x1544 + x2134 * x235
    x2143 = 3.0 * x1552 + x2125 + x2136 * x235
    x2144 = 3.0 * x1560 + x2131 + x2138 * x235
    x2145 = 3.0 * x1570 + x2141 * x235
    x2146 = x130 * x2130 + x2141 * x290
    x2147 = x1430 * x1621
    x2148 = x1061 + x1628 * x579 - x2147
    x2149 = x1430 * x1628
    x2150 = x1067 + x1639 * x579 - x2149
    x2151 = x1430 * x1625
    x2152 = x1073 + x1621 * x579 - x2151
    x2153 = x17 * x2152
    x2154 = x64 * (-x1079 + x1628 * x579 - x2147 - x2153)
    x2155 = x1083 - x1430 * x1635 + x1625 * x579
    x2156 = x17 * (x2154 + x2155 * x355)
    x2157 = x17 * x2148
    x2158 = x64 * (-x1088 + x1639 * x579 - x2149 - x2157)
    x2159 = x2152 * x355 + x2158
    x2160 = x17 * x2155
    x2161 = x64 * (-x1091 + x1621 * x579 - x2151 - x2160)
    x2162 = x1095 - x1430 * x1664 + x1635 * x579
    x2163 = 2.0 * x1643
    x2164 = 2.0 * x1644
    x2165 = x10 * x2157 + x2164
    x2166 = x1 * (-x17 * x2165 + x2150 * x235 + x2163)
    x2167 = 2.0 * x1650
    x2168 = x10 * x2153 + x2167
    x2169 = x17 * x2168
    x2170 = x1 * (x2165 - x2169)
    x2171 = 2.0 * x1656
    x2172 = x10 * x2160 + x2171
    x2173 = x17 * x2172
    x2174 = x1 * (x2168 - x2173)
    x2175 = 2.0 * x1663
    x2176 = x2162 * x235 + x2175
    x2177 = x13 * x2157 + x1407
    x2178 = x1 * (x1406 - x17 * x2177 + x2150 * x290)
    x2179 = 0.5 * x2178
    x2180 = x13 * x2153 + x1414
    x2181 = x17 * x2180
    x2182 = x1 * (x2177 - x2181)
    x2183 = 0.5 * x2182
    x2184 = x13 * x2160 + x1421
    x2185 = x17 * x2184
    x2186 = x1 * (x2180 - x2185)
    x2187 = 0.5 * x2186
    x2188 = x1429 + x2162 * x290
    x2189 = x10 * x2173 + 2.0 * x1685 + x2154
    x2190 = x10 * x2169 + 2.0 * x1688 + x2158
    x2191 = x17 * x2189
    x2192 = x2190 - x2191
    x2193 = 2.0 * x1691 + x2161 + x2176 * x235
    x2194 = 2.0 * x1717
    x2195 = x10 * x2185 + x2194
    x2196 = 2.0 * x1720
    x2197 = x10 * x2181 + x2196
    x2198 = x17 * x2195
    x2199 = x1 * (x2197 - x2198)
    x2200 = 2.0 * x1724
    x2201 = x2188 * x235 + x2200
    x2202 = x13 * x2185 + x1481 + x2154
    x2203 = x13 * x2181 + x1483 + x2158
    x2204 = x17 * x2202
    x2205 = x2203 - x2204
    x2206 = x2205 * x64
    x2207 = x1487 + x2161 + x2188 * x290
    x2208 = (
        -x17 * (x10 * x2191 + 2.0 * x1729 + x2170) + 2.0 * x1727 + x2166 + x2190 * x235
    )
    x2209 = 2.0 * x1740 + x2174 + x2193 * x235
    x2210 = (
        -x17 * (x10 * x2198 + 2.0 * x1745 + x2183) + 2.0 * x1743 + x2179 + x2197 * x235
    )
    x2211 = 2.0 * x1756 + x2187 + x2201 * x235
    x2212 = 2.0 * x1759
    x2213 = 2.0 * x1761
    x2214 = x1 * (-x17 * (x10 * x2204 + x2213) + x2203 * x235 + x2212)
    x2215 = 2.0 * x1774
    x2216 = x2207 * x235 + x2215
    x2217 = x1521 - x17 * (x13 * x2204 + x1523 + x2182) + x2178 + x2203 * x290
    x2218 = x2217 * x64
    x2219 = x1536 + x2186 + x2207 * x290
    x2220 = x130 * x2192 + 2.0 * x1782 + x2209 * x235
    x2221 = 2.0 * x1790 + x2199 + x2211 * x235
    x2222 = 2.0 * x1798 + x2206 + x2216 * x235
    x2223 = 2.0 * x1808
    x2224 = x2219 * x235 + x2223
    x2225 = x130 * x2205 + x1570 + x2219 * x290
    x2226 = 2.0 * x1835
    x2227 = x1430 * x1859 - x1866 * x579
    x2228 = -x2227
    x2229 = x1430 * x1866 - x1877 * x579
    x2230 = -x2229
    x2231 = x1430 * x1863 - x1859 * x579
    x2232 = -x2231
    x2233 = x17 * x2232
    x2234 = x64 * (-x2227 - x2233)
    x2235 = -x1430 * x1873 + x1863 * x579
    x2236 = x17 * (x2234 + x2235 * x355)
    x2237 = x17 * x2228
    x2238 = x64 * (-x2229 - x2237)
    x2239 = x2232 * x355 + x2238
    x2240 = x17 * x2235
    x2241 = x64 * (-x2231 - x2240)
    x2242 = -x1430 * x1906 + x1873 * x579
    x2243 = x10 * x2237 + x1882
    x2244 = x1 * (-x17 * x2243 + x1881 + x2230 * x235)
    x2245 = x10 * x2233 + x1889
    x2246 = x17 * x2245
    x2247 = x1 * (x2243 - x2246)
    x2248 = x10 * x2240 + x1896
    x2249 = x17 * x2248
    x2250 = x1 * (x2245 - x2249)
    x2251 = x1904 + x2242 * x235
    x2252 = x13 * x2237 + x2164
    x2253 = x1 * (-x17 * x2252 + x2163 + x2230 * x290)
    x2254 = 0.5 * x2253
    x2255 = x13 * x2233 + x2167
    x2256 = x17 * x2255
    x2257 = x1 * (x2252 - x2256)
    x2258 = 0.5 * x2257
    x2259 = x13 * x2240 + x2171
    x2260 = x17 * x2259
    x2261 = x1 * (x2255 - x2260)
    x2262 = 0.5 * x2261
    x2263 = x2175 + x2242 * x290
    x2264 = x10 * x2249 + x1920 + x2234
    x2265 = x10 * x2246 + x1922 + x2238
    x2266 = x17 * x2264
    x2267 = x2265 - x2266
    x2268 = x1925 + x2241 + x2251 * x235
    x2269 = x10 * x2260 + x1950
    x2270 = x10 * x2256 + x1954
    x2271 = x17 * x2269
    x2272 = x1 * (x2270 - x2271)
    x2273 = x1958 + x2263 * x235
    x2274 = x13 * x2260 + x2194 + x2234
    x2275 = x13 * x2256 + x2196 + x2238
    x2276 = x17 * x2274
    x2277 = x2275 - x2276
    x2278 = x2277 * x64
    x2279 = x2200 + x2241 + x2263 * x290
    x2280 = -x17 * (x10 * x2266 + x1963 + x2247) + x1961 + x2244 + x2265 * x235
    x2281 = x1974 + x2250 + x2268 * x235
    x2282 = -x17 * (x10 * x2271 + x1977 + x2258) + x1978 + x2254 + x2270 * x235
    x2283 = x1985 + x2262 + x2273 * x235
    x2284 = x1 * (-x17 * (x10 * x2276 + x1989) + x1987 + x2275 * x235)
    x2285 = x2003 + x2279 * x235
    x2286 = -x17 * (x13 * x2276 + x2213 + x2257) + x2212 + x2253 + x2275 * x290
    x2287 = x2286 * x64
    x2288 = x2215 + x2261 + x2279 * x290
    x2289 = x130 * x2267 + x2011 + x2281 * x235
    x2290 = x2019 + x2272 + x2283 * x235
    x2291 = x2026 + x2278 + x2285 * x235
    x2292 = x2035 + x2288 * x235
    x2293 = x130 * x2277 + x2223 + x2288 * x290
    x2294 = x1859 * x1905
    x2295 = 2.0 * x1061 + x1866 * x992 - x2294
    x2296 = x1866 * x1905
    x2297 = 2.0 * x1067 + x1877 * x992 - x2296
    x2298 = x1863 * x1905
    x2299 = 2.0 * x1073 + x1859 * x992 - x2298
    x2300 = x17 * x2299
    x2301 = x64 * (2.0 * x1060 * x42 + x1866 * x992 - x2294 - x2300)
    x2302 = 2.0 * x1083 + x1863 * x992 - x1873 * x1905
    x2303 = x17 * (x2301 + x2302 * x355)
    x2304 = x17 * x2295
    x2305 = x64 * (2.0 * x1066 * x42 + x1877 * x992 - x2296 - x2304)
    x2306 = x2299 * x355 + x2305
    x2307 = x17 * x2302
    x2308 = x64 * (2.0 * x1072 * x42 + x1859 * x992 - x2298 - x2307)
    x2309 = 2.0 * x1095 + x1873 * x992 - x1905 * x1906
    x2310 = x1 * (x10 * x16 * x2297 * x4 - x212 * x2295)
    x2311 = x1 * (x10 * x16 * x2295 * x4 - x212 * x2299)
    x2312 = x1 * (x10 * x16 * x2299 * x4 - x212 * x2302)
    x2313 = x13 * x2304 + 3.0 * x1882
    x2314 = x1 * (-x17 * x2313 + 3.0 * x1881 + x2297 * x290)
    x2315 = 0.5 * x2314
    x2316 = x13 * x2300 + 3.0 * x1889
    x2317 = x17 * x2316
    x2318 = x1 * (x2313 - x2317)
    x2319 = 0.5 * x2318
    x2320 = x13 * x2307 + 3.0 * x1896
    x2321 = x17 * x2320
    x2322 = x1 * (x2316 - x2321)
    x2323 = 0.5 * x2322
    x2324 = 3.0 * x1904 + x2309 * x290
    x2325 = x2301 + x2302 * x323
    x2326 = x2299 * x323 + x2305
    x2327 = x17 * x2325
    x2328 = x2326 - x2327
    x2329 = x2308 + x2309 * x323
    x2330 = x1 * (x10 * x16 * x2316 * x4 - x212 * x2320)
    x2331 = x13 * x2321 + 3.0 * x1950 + x2301
    x2332 = x13 * x2317 + 3.0 * x1954 + x2305
    x2333 = x17 * x2331
    x2334 = x2332 - x2333
    x2335 = x2334 * x64
    x2336 = 3.0 * x1958 + x2308 + x2324 * x290
    x2337 = -x17 * (x10 * x2327 + x2311) + x2310 + x2326 * x235
    x2338 = x2312 + x2329 * x235
    x2339 = -x17 * (x2319 + x2320 * x323) + x2315 + x2316 * x323
    x2340 = x2323 + x2324 * x323
    x2341 = x1 * (x10 * x16 * x2332 * x4 - x212 * x2331)
    x2342 = (
        -x17 * (x13 * x2333 + 3.0 * x1989 + x2318) + 3.0 * x1987 + x2314 + x2332 * x290
    )
    x2343 = x2342 * x64
    x2344 = 3.0 * x2003 + x2322 + x2336 * x290
    x2345 = x130 * x2328 + x2338 * x235
    x2346 = x2330 + x2340 * x235
    x2347 = x2335 + x2336 * x323
    x2348 = x130 * x2334 + 3.0 * x2035 + x2344 * x290

    # 210 item(s)
    return numpy.array(
        [
            x0 * x151
            + x0 * x163
            + x0 * (x0 * (x0 * x165 + x162) + x163)
            + x117
            * (
                x1 * (3.0 * x166 - x17 * x174 + x177 * x62)
                + x116 * x178
                - x17 * (x1 * (x174 - x186) + x112 * x178 + x193 * x7)
                + x195 * x62
            )
            + x150 * x178
            + x62
            * (
                x130 * (-x193 + x195)
                + x149 * x178
                + x62
                * (
                    x1 * (x185 - x192)
                    + x148 * x178
                    + x62 * (x147 * x178 + x196 + x62 * (x198 + x201 * x62))
                )
            ),
            x0 * x243
            + x0 * x249
            + x0 * (x0 * (x0 * x253 + x248) + x249)
            + x130
            * (
                -x17 * (x178 * x236 + 0.5 * x256 + x258 * x7)
                + x178 * x238
                + 0.5 * x254
                + x259 * x62
            )
            + x178 * x242
            + x62
            * (
                x1 * (-x258 + x259)
                + x178 * x241
                + x62 * (x178 * x240 + 0.5 * x260 + x62 * (x198 * x235 + x201 * x224))
            ),
            x0 * x299
            + x0 * x307
            + x0 * (x0 * (x0 * x312 + x306) + x307)
            + x130
            * (-x17 * (x178 * x291 + x317 + x319 * x7) + x178 * x293 + x314 + x320 * x62)
            + x178 * x298
            + x62
            * (
                x1 * (-x319 + x320)
                + x178 * x297
                + x62 * (x178 * x296 + x322 + x62 * (x198 * x290 + x201 * x278))
            ),
            x0 * x348
            + x0 * x358
            + x0 * (x0 * (x0 * x360 + x357) + x358)
            + x1 * (-x17 * (3.0 * x327 + x328 * x7) + 3.0 * x325 + x329 * x62)
            + x178 * x347
            + x62 * (x178 * x346 + x361 * x64 + x62 * (3.0 * x362 + x363 * x62)),
            x0 * x381
            + x0 * x388
            + x0 * (x0 * (x0 * x389 + x387) + x388)
            + x1 * (-x17 * (x189 * x369 + x368 * x7) + x180 * x369 + x183 * x370)
            + x178 * x380
            + x62 * (x178 * x379 + 0.5 * x390 + x62 * (x198 * x369 + x201 * x370)),
            x0 * x420
            + x0 * x430
            + x0 * (x0 * (x0 * x431 + x429) + x430)
            + x1 * (-x17 * (3.0 * x395 + x397 * x7) + 3.0 * x393 + x398 * x62)
            + x178 * x419
            + x62 * (x178 * x418 + x433 + x62 * (x435 + x436 * x62)),
            x0 * x445
            + x0 * x448
            + x0 * (x0 * (x0 * x450 + x447) + x448)
            + x178 * x444
            + x451 * x64
            + x62 * (3.0 * x452 + x453 * x62),
            x0 * x464
            + x0 * x467
            + x0 * (x0 * (x0 * x469 + x466) + x467)
            + x178 * x463
            + x470 * x64
            + x62 * (3.0 * x471 + x472 * x62),
            x0 * x477
            + x0 * x480
            + x0 * (x0 * (x0 * x484 + x479) + x480)
            + x178 * x476
            + 0.5 * x485
            + x62 * (x224 * x436 + x235 * x435),
            x0 * x496
            + x0 * x500
            + x0 * (x0 * (x0 * x503 + x499) + x500)
            + x178 * x495
            + x505
            + x62 * (x507 + x508 * x62),
            x0 * x512
            + x0 * x516
            + x0 * (x0 * (x513 * x517 + x515) + x516)
            + 3.0 * x518
            + x519 * x62,
            x0 * x523
            + x0 * x527
            + x0 * (x0 * (x517 * x524 + x526) + x527)
            + 3.0 * x528
            + x529 * x62,
            x0 * x533
            + x0 * x537
            + x0 * (x0 * (x517 * x534 + x536) + x537)
            + 3.0 * x538
            + x539 * x62,
            x0 * x540
            + x0 * x543
            + x0 * (x0 * (x0 * x544 + x542) + x543)
            + x224 * x508
            + x235 * x507,
            x0 * x548
            + x0 * x552
            + x0 * (x0 * (x517 * x549 + x551) + x552)
            + 3.0 * x553
            + x554 * x62,
            x0 * x555
            + x0 * x557
            + x0 * (x0 * (x0 * x558 + x556) + x557)
            + x117 * x451
            + x235 * x519,
            x0 * x559
            + x0 * x561
            + x0 * (x0 * (x0 * x562 + x560) + x561)
            + x130 * x470
            + x235 * x529,
            x0 * x563
            + x0 * x565
            + x0 * (x0 * (x0 * x566 + x564) + x565)
            + x235 * x539
            + x485,
            x0 * x567
            + x0 * x569
            + x0 * (x0 * (x0 * x570 + x568) + x569)
            + x323 * x508
            + x505,
            x0 * x571 + x0 * x573 + x0 * (x0 * (x0 * x574 + x572) + x573) + x235 * x554,
            x0 * x575
            + x0 * x577
            + x0 * (x0 * (x0 * x578 + x576) + x577)
            + x117 * x504
            + x290 * x554,
            x0 * x640
            + x0 * (x0 * x642 + x640)
            + x117
            * (
                x1 * (-x17 * x652 + x62 * x656 + x644)
                - x17 * (x1 * (x652 - x665) + x626 * x67 + x673 * x7)
                + x62 * x675
                + x629 * x67
            )
            + x151 * x22
            + x62
            * (
                x130 * (-x673 + x675)
                + x62
                * (
                    x1 * (x664 - x672)
                    + x62 * (x62 * (x62 * x681 + x678) + x635 * x67 + x676)
                    + x636 * x67
                )
                + x637 * x67
            )
            + x638 * x67,
            x0 * x708
            + x0 * (x0 * x714 + x708)
            + x130
            * (
                -x17 * (x67 * x697 + x7 * x722 + 0.5 * x719)
                + x62 * x724
                + x67 * x700
                + 0.5 * x716
            )
            + x22 * x243
            + x62
            * (
                x1 * (-x722 + x724)
                + x62 * (x62 * (x62 * x727 + x726) + x67 * x704 + 0.5 * x725)
                + x67 * x705
            )
            + x67 * x706,
            x0 * x752
            + x0 * (x0 * x758 + x752)
            + x130
            * (-x17 * (x67 * x741 + x7 * x766 + x763) + x62 * x768 + x67 * x744 + x760)
            + x22 * x299
            + x62
            * (
                x1 * (-x766 + x768)
                + x62 * (x62 * (x278 * x681 + x771) + x67 * x748 + x770)
                + x67 * x749
            )
            + x67 * x750,
            x0 * x793
            + x0 * (x0 * x795 + x793)
            + x1 * (-x17 * (x7 * x776 + x775) + x62 * x777 + x773)
            + x22 * x348
            + x62 * (x62 * (x62 * x798 + x797) + x64 * x796 + x67 * x790)
            + x67 * x791,
            x0 * x825
            + x0 * (x0 * x827 + x825)
            + x1 * (-x17 * (x7 * x806 + x804) + x62 * x808 + x801)
            + x22 * x381
            + x62 * (x62 * (x62 * x831 + x829) + x67 * x822 + 0.5 * x828)
            + x67 * x823,
            x0 * x857
            + x0 * (x0 * x859 + x857)
            + x1 * (-x17 * (x7 * x838 + x837) + x62 * x839 + x834)
            + x22 * x420
            + x62 * (x62 * (x62 * x864 + x863) + x67 * x854 + x861)
            + x67 * x855,
            x0 * x871
            + x0 * (x0 * x874 + x871)
            + x22 * x445
            + x62 * (x62 * x877 + x876)
            + x64 * x875
            + x67 * x869,
            x0 * x884
            + x0 * (x0 * x887 + x884)
            + x22 * x464
            + x62 * (x62 * x890 + x889)
            + x64 * x888
            + x67 * x882,
            x0 * x897
            + x0 * (x0 * x900 + x897)
            + x22 * x477
            + x62 * (x62 * x903 + x902)
            + x67 * x895
            + 0.5 * x901,
            x0 * x911
            + x0 * (x0 * x915 + x911)
            + x22 * x496
            + x62 * (x62 * x920 + x919)
            + x67 * x909
            + x917,
            x0 * x925 + x0 * (x0 * x928 + x925) + x22 * x512 + x62 * x930 + x929,
            x0 * x935 + x0 * (x0 * x937 + x935) + x22 * x523 + x62 * x939 + x938,
            x0 * x944 + x0 * (x0 * x946 + x944) + x22 * x533 + x62 * x948 + x947,
            x0 * x953 + x0 * (x0 * x955 + x953) + x22 * x540 + x62 * x957 + x956,
            x0 * x962 + x0 * (x0 * x964 + x962) + x22 * x548 + x62 * x967 + x966,
            x0 * x969
            + x0 * (x0 * x971 + x969)
            + x117 * x875
            + x22 * x555
            + x235 * x930
            + x518,
            x0 * x973
            + x0 * (x0 * x975 + x973)
            + x130 * x888
            + x22 * x559
            + x235 * x939
            + x528,
            x0 * x977 + x0 * (x0 * x979 + x977) + x22 * x563 + x235 * x948 + x538 + x901,
            x0 * x981
            + x0 * (x0 * x983 + x981)
            + x22 * x567
            + x235 * x506
            + x235 * x957
            + x917,
            x0 * x985 + x0 * (x0 * x987 + x985) + x22 * x571 + x235 * x967 + x553,
            x0 * x989 + x0 * (x0 * x991 + x989) + x117 * x916 + x22 * x575 + x290 * x967,
            x0 * x1053
            + x0 * (x0 * x1055 + x1053)
            + x1051 * x67
            + x117
            * (
                x1 * (x1057 - x1065 * x17 + x1069 * x62)
                + x1042 * x67
                + x1090 * x62
                - x17 * (x1 * (x1065 - x1078) + x1039 * x67 + x1087 * x7)
            )
            + x151 * x23
            + x62
            * (
                x1050 * x67
                + x130 * (-x1087 + x1090)
                + x62
                * (
                    x1 * (x1077 - x1086)
                    + x1049 * x67
                    + x62 * (x1048 * x67 + x1092 + x62 * (x1094 + x1097 * x62))
                )
            ),
            x0 * x1117
            + x0 * (x0 * x1121 + x1117)
            + x1115 * x67
            + x130
            * (
                x1110 * x67
                + 0.5 * x1122
                + x1127 * x62
                - x17 * (x1107 * x67 + 0.5 * x1124 + x1126 * x7)
            )
            + x23 * x243
            + x62
            * (
                x1 * (-x1126 + x1127)
                + x1114 * x67
                + x62 * (x1113 * x67 + 0.5 * x1128 + x62 * (x1094 * x235 + x1097 * x224))
            ),
            x0 * x1159
            + x0 * (x0 * x1167 + x1159)
            + x1157 * x67
            + x130
            * (
                x1150 * x67
                + x1170
                + x1182 * x62
                - x17 * (x1147 * x67 + x1174 + x1179 * x7)
            )
            + x23 * x299
            + x62
            * (
                x1 * (-x1179 + x1182)
                + x1156 * x67
                + x62 * (x1155 * x67 + x1184 + x62 * (x1186 + x1187 * x62))
            ),
            x0 * x1209
            + x0 * (x0 * x1211 + x1209)
            + x1 * (2.0 * x1189 + x1193 * x62 - x17 * (2.0 * x1191 + x1192 * x7))
            + x1207 * x67
            + x23 * x348
            + x62 * (x1206 * x67 + x1212 * x64 + x62 * (2.0 * x1213 + x1214 * x62)),
            x0 * x1226
            + x0 * (x0 * x1228 + x1226)
            + x1 * (x1171 * x224 + x1181 * x235 - x17 * (x1176 * x235 + x1215 * x7))
            + x1224 * x67
            + x23 * x381
            + x62 * (x1223 * x67 + 0.5 * x1229 + x62 * (x1186 * x235 + x1187 * x224)),
            x0 * x1256
            + x0 * (x0 * x1258 + x1256)
            + x1 * (x1232 + x1238 * x62 - x17 * (x1235 + x1237 * x7))
            + x1254 * x67
            + x23 * x420
            + x62 * (x1253 * x67 + x1260 + x62 * (x1262 + x1263 * x62)),
            x0 * x1270
            + x0 * (x0 * x1273 + x1270)
            + x1268 * x67
            + x1274 * x64
            + x23 * x445
            + x62 * (2.0 * x1275 + x1276 * x62),
            x0 * x1283
            + x0 * (x0 * x1286 + x1283)
            + x1281 * x67
            + x1287 * x64
            + x23 * x464
            + x62 * (2.0 * x1288 + x1289 * x62),
            x0 * x1294
            + x0 * (x0 * x1297 + x1294)
            + x1292 * x67
            + 0.5 * x1298
            + x23 * x477
            + x62 * (x1262 * x235 + x1263 * x224),
            x0 * x1306
            + x0 * (x0 * x1310 + x1306)
            + x1304 * x67
            + x1312
            + x23 * x496
            + x62 * (x1314 + x1315 * x62),
            x0 * x1320
            + x0 * (x0 * x1323 + x1320)
            + 2.0 * x1324
            + x1325 * x62
            + x23 * x512,
            x0 * x1330
            + x0 * (x0 * x1332 + x1330)
            + 2.0 * x1333
            + x1334 * x62
            + x23 * x523,
            x0 * x1339
            + x0 * (x0 * x1341 + x1339)
            + 2.0 * x1342
            + x1343 * x62
            + x23 * x533,
            x0 * x1346
            + x0 * (x0 * x1348 + x1346)
            + x1314 * x235
            + x1315 * x224
            + x23 * x540,
            x0 * x1353 + x0 * (x0 * x1355 + x1353) + x1357 + x1358 * x62 + x23 * x548,
            x0 * x1360
            + x0 * (x0 * x1362 + x1360)
            + x117 * x1274
            + x1325 * x235
            + x23 * x555,
            x0 * x1364
            + x0 * (x0 * x1366 + x1364)
            + x1287 * x130
            + x1334 * x235
            + x23 * x559,
            x0 * x1368 + x0 * (x0 * x1370 + x1368) + x1298 + x1343 * x235 + x23 * x563,
            x0 * x1372 + x0 * (x0 * x1374 + x1372) + x1312 + x1315 * x323 + x23 * x567,
            x0 * x1376 + x0 * (x0 * x1378 + x1376) + x1358 * x235 + x23 * x571,
            x0 * x1380
            + x0 * (x0 * x1382 + x1380)
            + x117 * x1311
            + x1358 * x290
            + x23 * x575
            + x553,
            x0 * x1405
            + x117
            * (
                x1 * (x1406 - x1411 * x17 + x1413 * x62)
                + x1395 * x3
                + x1427 * x62
                - x17 * (x1 * (x1411 - x1419) + x1389 * x3 + x1425 * x7)
            )
            + x1401 * x3
            + x22 * x639
            + x22 * x640
            + x62
            * (
                x130 * (-x1425 + x1427)
                + x1400 * x3
                + x62
                * (
                    x1 * (x1418 - x1424)
                    + x1399 * x3
                    + x62 * (x1428 + x1429 * x62 + x62 * (x1429 + x1432 * x62))
                )
            ),
            x0 * x1449
            + x130
            * (
                0.5 * x1451
                + x1458 * x62
                + x1459 * x62
                - x17 * (0.5 * x1454 + x1455 * x62 + x1457 * x7)
            )
            + x1442 * x3
            + x22 * x707
            + x22 * x708
            + x62
            * (
                x1 * (-x1457 + x1459)
                + x1441 * x3
                + x62 * (0.5 * x1460 + x1461 * x62 + x62 * (x1461 + x1462 * x62))
            ),
            x0 * x1474
            + x130
            * (
                x1414 * x278
                + x1476
                + x1484 * x62
                - x17 * (x1421 * x278 + x1479 + x1482 * x7)
            )
            + x1467 * x3
            + x22 * x751
            + x22 * x752
            + x62
            * (
                x1 * (-x1482 + x1484)
                + x1466 * x3
                + x62 * (x1429 * x278 + x1486 + x62 * (x1432 * x278 + x1487))
            ),
            x0 * x1500
            + x1 * (x1489 + x1493 * x62 - x17 * (x1491 + x1492 * x7))
            + x1497 * x3
            + x22 * x792
            + x22 * x793
            + x62 * (x1501 * x64 + x1502 * x62 + x62 * (x1502 + x1503 * x62)),
            x0 * x1516
            + x1 * (x1505 + x1509 * x62 - x17 * (x1507 + x1508 * x7))
            + x1513 * x3
            + x22 * x824
            + x22 * x825
            + x62 * (0.5 * x1517 + x1518 * x62 + x62 * (x1518 + x1519 * x62)),
            x0 * x1533
            + x1 * (x1521 + x1525 * x62 - x17 * (x1523 + x1524 * x7))
            + x1530 * x3
            + x22 * x856
            + x22 * x857
            + x62 * (x1535 + x1536 * x62 + x62 * (x1536 + x1537 * x62)),
            x0 * x1542
            + x1543 * x64
            + x1544 * x62
            + x22 * x870
            + x22 * x871
            + x62 * (x1544 + x1545 * x62),
            x0 * x1550
            + x1551 * x64
            + x1552 * x62
            + x22 * x883
            + x22 * x884
            + x62 * (x1552 + x1553 * x62),
            x0 * x1558
            + 0.5 * x1559
            + x1560 * x62
            + x22 * x896
            + x22 * x897
            + x62 * (x1560 + x1561 * x62),
            x0 * x1567
            + x1569
            + x1570 * x62
            + x22 * x910
            + x22 * x911
            + x62 * (x1570 + x1571 * x62),
            x0 * x1576 + x1573 + x1577 * x62 + x22 * x924 + x22 * x925,
            x0 * x1582 + x1579 + x1583 * x62 + x22 * x934 + x22 * x935,
            x0 * x1588 + x1585 + x1589 * x62 + x22 * x943 + x22 * x944,
            x0 * x1594 + x1591 + x1595 * x62 + x22 * x952 + x22 * x953,
            x0 * x1600 + x1597 + x1601 * x62 + x22 * x961 + x22 * x962,
            x0 * x1604 + x117 * x1543 + x1577 * x235 + x22 * x968 + x22 * x969 + x929,
            x0 * x1607 + x130 * x1551 + x1583 * x235 + x22 * x972 + x22 * x973 + x938,
            x0 * x1610 + x1559 + x1589 * x235 + x22 * x976 + x22 * x977 + x947,
            x0 * x1613 + x1569 + x1595 * x235 + x22 * x980 + x22 * x981 + x956,
            x0 * x1616 + x1601 * x235 + x22 * x984 + x22 * x985 + x966,
            x0 * x1619 + x117 * x1568 + x1601 * x290 + x22 * x988 + x22 * x989,
            x0 * x1642
            + x1053 * x22
            + x117
            * (
                x1 * (x1643 - x1647 * x17 + x1649 * x62)
                + x1632 * x3
                + x1661 * x62
                - x17 * (x1 * (x1647 - x1654) + x1626 * x3 + x1659 * x7)
            )
            + x1638 * x3
            + x23 * x639
            + x62
            * (
                x130 * (-x1659 + x1661)
                + x1637 * x3
                + x62
                * (
                    x1 * (x1653 - x1658)
                    + x1636 * x3
                    + x62 * (x1662 + x1663 * x62 + x62 * (x1663 + x1665 * x62))
                )
            ),
            x0 * x1679
            + x1117 * x22
            + x130
            * (
                0.5 * x1681
                + x1688 * x62
                + x1689 * x62
                - x17 * (0.5 * x1684 + x1685 * x62 + x1687 * x7)
            )
            + x1672 * x3
            + x23 * x707
            + x62
            * (
                x1 * (-x1687 + x1689)
                + x1671 * x3
                + x62 * (0.5 * x1690 + x1691 * x62 + x62 * (x1691 + x1692 * x62))
            ),
            x0 * x1709
            + x1159 * x22
            + x130
            * (
                -x17 * (x1716 + x1717 * x62 + x1719 * x7)
                + x1712
                + x1720 * x62
                + x1721 * x62
            )
            + x1700 * x3
            + x23 * x751
            + x62
            * (
                x1 * (-x1719 + x1721)
                + x1699 * x3
                + x62 * (x1723 + x1724 * x62 + x62 * (x1724 + x1725 * x62))
            ),
            x0 * x1738
            + x1 * (-x17 * (x1729 + x1730 * x7) + x1727 + x1731 * x62)
            + x1209 * x22
            + x1735 * x3
            + x23 * x792
            + x62 * (x1739 * x64 + x1740 * x62 + x62 * (x1740 + x1741 * x62)),
            x0 * x1754
            + x1 * (-x17 * (x1745 + x1746 * x7) + x1743 + x1747 * x62)
            + x1226 * x22
            + x1751 * x3
            + x23 * x824
            + x62 * (0.5 * x1755 + x1756 * x62 + x62 * (x1756 + x1757 * x62)),
            x0 * x1771
            + x1 * (-x17 * (x1761 + x1762 * x7) + x1759 + x1763 * x62)
            + x1256 * x22
            + x1768 * x3
            + x23 * x856
            + x62 * (x1773 + x1774 * x62 + x62 * (x1774 + x1775 * x62)),
            x0 * x1780
            + x1270 * x22
            + x1781 * x64
            + x1782 * x62
            + x23 * x870
            + x62 * (x1782 + x1783 * x62),
            x0 * x1788
            + x1283 * x22
            + x1789 * x64
            + x1790 * x62
            + x23 * x883
            + x62 * (x1790 + x1791 * x62),
            x0 * x1796
            + x1294 * x22
            + 0.5 * x1797
            + x1798 * x62
            + x23 * x896
            + x62 * (x1798 + x1799 * x62),
            x0 * x1805
            + x1306 * x22
            + x1807
            + x1808 * x62
            + x23 * x910
            + x62 * (x1808 + x1809 * x62),
            x0 * x1814 + x1320 * x22 + x1811 + x1815 * x62 + x23 * x924,
            x0 * x1820 + x1330 * x22 + x1817 + x1821 * x62 + x23 * x934,
            x0 * x1826 + x1339 * x22 + x1823 + x1827 * x62 + x23 * x943,
            x0 * x1832 + x1346 * x22 + x1829 + x1833 * x62 + x23 * x952,
            x0 * x1838 + x1353 * x22 + x1835 + x1839 * x62 + x23 * x961,
            x0 * x1842 + x117 * x1781 + x1324 + x1360 * x22 + x1815 * x235 + x23 * x968,
            x0 * x1845 + x130 * x1789 + x1333 + x1364 * x22 + x1821 * x235 + x23 * x972,
            x0 * x1848 + x1342 + x1368 * x22 + x1797 + x1827 * x235 + x23 * x976,
            x0 * x1851 + x1313 * x235 + x1372 * x22 + x1807 + x1833 * x235 + x23 * x980,
            x0 * x1854 + x1356 + x1376 * x22 + x1839 * x235 + x23 * x984,
            x0 * x1857 + x117 * x1806 + x1380 * x22 + x1839 * x290 + x23 * x988 + x965,
            x0 * x1880
            + x1052 * x23
            + x1053 * x23
            + x117
            * (
                x1 * (-x17 * x1886 + x1881 + x1888 * x62)
                - x17 * (x1 * (x1886 - x1894) + x1864 * x3 + x1900 * x7)
                + x1870 * x3
                + x1902 * x62
            )
            + x1876 * x3
            + x62
            * (
                x130 * (-x1900 + x1902)
                + x1875 * x3
                + x62
                * (
                    x1 * (x1893 - x1899)
                    + x1874 * x3
                    + x62 * (x1903 + x1904 * x62 + x62 * (x1904 + x1907 * x62))
                )
            ),
            x0 * x1915
            + x1116 * x23
            + x1117 * x23
            + x130
            * (
                -x17 * (x1896 * x224 + 0.5 * x1918 + x1921 * x7)
                + x1889 * x224
                + 0.5 * x1916
                + x1923 * x62
            )
            + x1910 * x3
            + x62
            * (
                x1 * (-x1921 + x1923)
                + x1909 * x3
                + x62 * (x1904 * x224 + 0.5 * x1924 + x62 * (x1907 * x224 + x1925))
            ),
            x0 * x1942
            + x1158 * x23
            + x1159 * x23
            + x130
            * (
                -x17 * (x1949 + x1950 * x62 + x1953 * x7)
                + x1945
                + x1954 * x62
                + x1955 * x62
            )
            + x1933 * x3
            + x62
            * (
                x1 * (-x1953 + x1955)
                + x1932 * x3
                + x62 * (x1957 + x1958 * x62 + x62 * (x1958 + x1959 * x62))
            ),
            x0 * x1972
            + x1 * (-x17 * (x1963 + x1964 * x7) + x1961 + x1965 * x62)
            + x1208 * x23
            + x1209 * x23
            + x1969 * x3
            + x62 * (x1973 * x64 + x1974 * x62 + x62 * (x1974 + x1975 * x62)),
            x0 * x1983
            + x1 * (-x17 * (x1976 * x7 + x1977) + x1946 * x224 + x1978)
            + x1225 * x23
            + x1226 * x23
            + x1980 * x3
            + x62 * (x1958 * x224 + 0.5 * x1984 + x62 * (x1959 * x224 + x1985)),
            x0 * x2000
            + x1 * (-x17 * (x1989 + x1991 * x7) + x1987 + x1992 * x62)
            + x1255 * x23
            + x1256 * x23
            + x1997 * x3
            + x62 * (x2002 + x2003 * x62 + x62 * (x2003 + x2004 * x62)),
            x0 * x2009
            + x1269 * x23
            + x1270 * x23
            + x2010 * x64
            + x2011 * x62
            + x62 * (x2011 + x2012 * x62),
            x0 * x2017
            + x1282 * x23
            + x1283 * x23
            + x2018 * x64
            + x2019 * x62
            + x62 * (x2019 + x2020 * x62),
            x0 * x2024
            + x1293 * x23
            + x1294 * x23
            + x2003 * x224
            + 0.5 * x2025
            + x62 * (x2004 * x224 + x2026),
            x0 * x2032
            + x1305 * x23
            + x1306 * x23
            + x2034
            + x2035 * x62
            + x62 * (x2035 + x2036 * x62),
            x0 * x2041 + x1319 * x23 + x1320 * x23 + x2038 + x2042 * x62,
            x0 * x2047 + x1329 * x23 + x1330 * x23 + x2044 + x2048 * x62,
            x0 * x2053 + x1338 * x23 + x1339 * x23 + x2050 + x2054 * x62,
            x0 * x2057 + x1345 * x23 + x1346 * x23 + x2036 * x224 + x2058,
            x0 * x2063 + x1352 * x23 + x1353 * x23 + x2060 + x2064 * x62,
            x0 * x2067 + x117 * x2010 + x1359 * x23 + x1360 * x23 + x2042 * x235,
            x0 * x2070 + x130 * x2018 + x1363 * x23 + x1364 * x23 + x2048 * x235,
            x0 * x2073 + x1367 * x23 + x1368 * x23 + x2025 + x2054 * x235,
            x0 * x2076 + x1371 * x23 + x1372 * x23 + x2034 + x2036 * x323,
            x0 * x2079 + x1375 * x23 + x1376 * x23 + x2064 * x235,
            x0 * x2082 + x117 * x2033 + x1357 + x1379 * x23 + x1380 * x23 + x2064 * x290,
            x117
            * (
                x1 * (x16 * x2086 * x4 * x7 - x2084 * x359)
                - x17 * (x1 * (x16 * x2084 * x4 * x7 - x2088 * x359) + x2092 * x7)
                + x2095 * x62
            )
            + x1403 * x22
            + x1404 * x22
            + x1405 * x22
            + x62
            * (
                x130 * (-x2092 + x2095)
                + x62
                * (
                    x1 * (x16 * x2088 * x4 * x7 - x2091 * x359)
                    + x62 * (x2097 + x2098 * x355)
                )
            ),
            x130 * (-x17 * (0.5 * x2104 + x2106 * x355) + 0.5 * x2100 + x2102 * x355)
            + x1447 * x22
            + x1448 * x22
            + x1449 * x22
            + x62
            * (
                x1 * (x16 * x2102 * x4 * x7 - x2106 * x359)
                + x62 * (0.5 * x2108 + x2110 * x355)
            ),
            x130 * (-x17 * (x2091 * x731 + x2114) + x2088 * x731 + x2112)
            + x1472 * x22
            + x1473 * x22
            + x1474 * x22
            + x62
            * (
                x1 * (x13 * x202 * x203 * x2088 * x7 - x1463 * x2091)
                + x62 * (x2098 * x731 + x2116)
            ),
            x1 * (x16 * x2118 * x4 * x7 - x2117 * x359)
            + x1498 * x22
            + x1499 * x22
            + x1500 * x22
            + x62 * (x2120 * x64 + x2121 * x355),
            x1 * (x16 * x2123 * x4 * x7 - x2122 * x359)
            + x1514 * x22
            + x1515 * x22
            + x1516 * x22
            + x62 * (0.5 * x2125 + x2126 * x355),
            x1 * (x16 * x2128 * x4 * x7 - x2127 * x359)
            + x1531 * x22
            + x1532 * x22
            + x1533 * x22
            + x62 * (x2131 + x2132 * x355),
            x1540 * x22 + x1541 * x22 + x1542 * x22 + x2133 * x64 + x2134 * x355,
            x1548 * x22 + x1549 * x22 + x1550 * x22 + x2135 * x64 + x2136 * x355,
            x1556 * x22 + x1557 * x22 + x1558 * x22 + 0.5 * x2137 + x2138 * x355,
            x1565 * x22 + x1566 * x22 + x1567 * x22 + x2140 + x2141 * x355,
            x1574 * x22 + x1575 * x22 + x1576 * x22 + x2142 * x62,
            x1580 * x22 + x1581 * x22 + x1582 * x22 + x2143 * x62,
            x1586 * x22 + x1587 * x22 + x1588 * x22 + x2144 * x62,
            x1592 * x22 + x1593 * x22 + x1594 * x22 + x2145 * x62,
            x1598 * x22 + x1599 * x22 + x1600 * x22 + x2146 * x62,
            x117 * x2133
            + 3.0 * x1573
            + x1602 * x22
            + x1603 * x22
            + x1604 * x22
            + x2142 * x235,
            x130 * x2135
            + 3.0 * x1579
            + x1605 * x22
            + x1606 * x22
            + x1607 * x22
            + x2143 * x235,
            3.0 * x1585 + x1608 * x22 + x1609 * x22 + x1610 * x22 + x2137 + x2144 * x235,
            3.0 * x1591 + x1611 * x22 + x1612 * x22 + x1613 * x22 + x2140 + x2145 * x235,
            3.0 * x1597 + x1614 * x22 + x1615 * x22 + x1616 * x22 + x2146 * x235,
            x117 * x2139 + x1617 * x22 + x1618 * x22 + x1619 * x22 + x2146 * x290,
            x117
            * (
                x1 * (x16 * x2150 * x4 * x7 - x2148 * x359)
                - x17 * (x1 * (x16 * x2148 * x4 * x7 - x2152 * x359) + x2156 * x7)
                + x2159 * x62
            )
            + x1403 * x23
            + x1641 * x22
            + x1642 * x22
            + x62
            * (
                x130 * (-x2156 + x2159)
                + x62
                * (
                    x1 * (x16 * x2152 * x4 * x7 - x2155 * x359)
                    + x62 * (x2161 + x2162 * x355)
                )
            ),
            x130 * (-x17 * (0.5 * x2170 + x2172 * x355) + 0.5 * x2166 + x2168 * x355)
            + x1447 * x23
            + x1678 * x22
            + x1679 * x22
            + x62
            * (
                x1 * (x16 * x2168 * x4 * x7 - x2172 * x359)
                + x62 * (0.5 * x2174 + x2176 * x355)
            ),
            x130 * (-x17 * (x2183 + x2184 * x355) + x2179 + x2180 * x355)
            + x1472 * x23
            + x1708 * x22
            + x1709 * x22
            + x62
            * (
                x1 * (x16 * x2180 * x4 * x7 - x2184 * x359) + x62 * (x2187 + x2188 * x355)
            ),
            x1 * (x16 * x2190 * x4 * x7 - x2189 * x359)
            + x1498 * x23
            + x1737 * x22
            + x1738 * x22
            + x62 * (x2192 * x64 + x2193 * x355),
            x1 * (x16 * x2197 * x4 * x7 - x2195 * x359)
            + x1514 * x23
            + x1753 * x22
            + x1754 * x22
            + x62 * (0.5 * x2199 + x2201 * x355),
            x1 * (x16 * x2203 * x4 * x7 - x2202 * x359)
            + x1531 * x23
            + x1770 * x22
            + x1771 * x22
            + x62 * (x2206 + x2207 * x355),
            x1540 * x23 + x1779 * x22 + x1780 * x22 + x2208 * x64 + x2209 * x355,
            x1548 * x23 + x1787 * x22 + x1788 * x22 + x2210 * x64 + x2211 * x355,
            x1556 * x23 + x1795 * x22 + x1796 * x22 + 0.5 * x2214 + x2216 * x355,
            x1565 * x23 + x1804 * x22 + x1805 * x22 + x2218 + x2219 * x355,
            x1574 * x23 + x1813 * x22 + x1814 * x22 + x2220 * x62,
            x1580 * x23 + x1819 * x22 + x1820 * x22 + x2221 * x62,
            x1586 * x23 + x1825 * x22 + x1826 * x22 + x2222 * x62,
            x1592 * x23 + x1831 * x22 + x1832 * x22 + x2224 * x62,
            x1598 * x23 + x1837 * x22 + x1838 * x22 + x2225 * x62,
            x117 * x2208
            + x1602 * x23
            + 2.0 * x1811
            + x1841 * x22
            + x1842 * x22
            + x2220 * x235,
            x130 * x2210
            + x1605 * x23
            + 2.0 * x1817
            + x1844 * x22
            + x1845 * x22
            + x2221 * x235,
            x1608 * x23 + 2.0 * x1823 + x1847 * x22 + x1848 * x22 + x2214 + x2222 * x235,
            x1611 * x23 + 2.0 * x1829 + x1850 * x22 + x1851 * x22 + x2218 + x2224 * x235,
            x1614 * x23 + x1853 * x22 + x1854 * x22 + x2225 * x235 + x2226,
            x117 * x2217 + x1597 + x1617 * x23 + x1856 * x22 + x1857 * x22 + x2225 * x290,
            x117
            * (
                x1 * (x16 * x2230 * x4 * x7 - x2228 * x359)
                - x17 * (x1 * (x16 * x2228 * x4 * x7 - x2232 * x359) + x2236 * x7)
                + x2239 * x62
            )
            + x1640 * x23
            + x1641 * x23
            + x1880 * x22
            + x62
            * (
                x130 * (-x2236 + x2239)
                + x62
                * (
                    x1 * (x16 * x2232 * x4 * x7 - x2235 * x359)
                    + x62 * (x2241 + x2242 * x355)
                )
            ),
            x130 * (-x17 * (0.5 * x2247 + x2248 * x355) + 0.5 * x2244 + x2245 * x355)
            + x1677 * x23
            + x1678 * x23
            + x1915 * x22
            + x62
            * (
                x1 * (x16 * x2245 * x4 * x7 - x2248 * x359)
                + x62 * (0.5 * x2250 + x2251 * x355)
            ),
            x130 * (-x17 * (x2258 + x2259 * x355) + x2254 + x2255 * x355)
            + x1707 * x23
            + x1708 * x23
            + x1942 * x22
            + x62
            * (
                x1 * (x16 * x2255 * x4 * x7 - x2259 * x359) + x62 * (x2262 + x2263 * x355)
            ),
            x1 * (x16 * x2265 * x4 * x7 - x2264 * x359)
            + x1736 * x23
            + x1737 * x23
            + x1972 * x22
            + x62 * (x2267 * x64 + x2268 * x355),
            x1 * (x16 * x2270 * x4 * x7 - x2269 * x359)
            + x1752 * x23
            + x1753 * x23
            + x1983 * x22
            + x62 * (0.5 * x2272 + x2273 * x355),
            x1 * (x16 * x2275 * x4 * x7 - x2274 * x359)
            + x1769 * x23
            + x1770 * x23
            + x2000 * x22
            + x62 * (x2278 + x2279 * x355),
            x1778 * x23 + x1779 * x23 + x2009 * x22 + x2280 * x64 + x2281 * x355,
            x1786 * x23 + x1787 * x23 + x2017 * x22 + x2282 * x64 + x2283 * x355,
            x1794 * x23 + x1795 * x23 + x2024 * x22 + 0.5 * x2284 + x2285 * x355,
            x1803 * x23 + x1804 * x23 + x2032 * x22 + x2287 + x2288 * x355,
            x1812 * x23 + x1813 * x23 + x2041 * x22 + x2289 * x62,
            x1818 * x23 + x1819 * x23 + x2047 * x22 + x2290 * x62,
            x1824 * x23 + x1825 * x23 + x2053 * x22 + x2291 * x62,
            x1830 * x23 + x1831 * x23 + x2057 * x22 + x2292 * x62,
            x1836 * x23 + x1837 * x23 + x2063 * x22 + x2293 * x62,
            x117 * x2280 + x1840 * x23 + x1841 * x23 + x2038 + x2067 * x22 + x2289 * x235,
            x130 * x2282 + x1843 * x23 + x1844 * x23 + x2044 + x2070 * x22 + x2290 * x235,
            x1846 * x23 + x1847 * x23 + x2050 + x2073 * x22 + x2284 + x2291 * x235,
            x1849 * x23 + x1850 * x23 + x2058 + x2076 * x22 + x2287 + x2292 * x235,
            x1852 * x23 + x1853 * x23 + x2060 + x2079 * x22 + x2293 * x235,
            x117 * x2286 + x1855 * x23 + x1856 * x23 + x2082 * x22 + x2226 + x2293 * x290,
            x117
            * (
                x1 * (x16 * x2297 * x4 * x7 - x2295 * x359)
                - x17 * (x1 * (x16 * x2295 * x4 * x7 - x2299 * x359) + x2303 * x7)
                + x2306 * x62
            )
            + x1878 * x23
            + x1879 * x23
            + x1880 * x23
            + x62
            * (
                x130 * (-x2303 + x2306)
                + x62
                * (
                    x1 * (x16 * x2299 * x4 * x7 - x2302 * x359)
                    + x62 * (x2308 + x2309 * x355)
                )
            ),
            x130 * (-x17 * (x2302 * x483 + 0.5 * x2311) + x2299 * x483 + 0.5 * x2310)
            + x1913 * x23
            + x1914 * x23
            + x1915 * x23
            + x62
            * (
                x1 * (x10 * x202 * x203 * x2299 * x7 - x1098 * x2302)
                + x62 * (x2309 * x483 + 0.5 * x2312)
            ),
            x130 * (-x17 * (x2319 + x2320 * x355) + x2315 + x2316 * x355)
            + x1940 * x23
            + x1941 * x23
            + x1942 * x23
            + x62
            * (
                x1 * (x16 * x2316 * x4 * x7 - x2320 * x359) + x62 * (x2323 + x2324 * x355)
            ),
            x1 * (x16 * x2326 * x4 * x7 - x2325 * x359)
            + x1970 * x23
            + x1971 * x23
            + x1972 * x23
            + x62 * (x2328 * x64 + x2329 * x355),
            x1 * (x10 * x202 * x203 * x2316 * x7 - x1098 * x2320)
            + x1981 * x23
            + x1982 * x23
            + x1983 * x23
            + x62 * (x2324 * x483 + 0.5 * x2330),
            x1 * (x16 * x2332 * x4 * x7 - x2331 * x359)
            + x1998 * x23
            + x1999 * x23
            + x2000 * x23
            + x62 * (x2335 + x2336 * x355),
            x2007 * x23 + x2008 * x23 + x2009 * x23 + x2337 * x64 + x2338 * x355,
            x2015 * x23 + x2016 * x23 + x2017 * x23 + x2339 * x64 + x2340 * x355,
            x2022 * x23 + x2023 * x23 + x2024 * x23 + x2336 * x483 + 0.5 * x2341,
            x2030 * x23 + x2031 * x23 + x2032 * x23 + x2343 + x2344 * x355,
            x2039 * x23 + x2040 * x23 + x2041 * x23 + x2345 * x62,
            x2045 * x23 + x2046 * x23 + x2047 * x23 + x2346 * x62,
            x2051 * x23 + x2052 * x23 + x2053 * x23 + x2347 * x62,
            x2055 * x23 + x2056 * x23 + x2057 * x23 + x224 * x2344,
            x2061 * x23 + x2062 * x23 + x2063 * x23 + x2348 * x62,
            x117 * x2337 + x2065 * x23 + x2066 * x23 + x2067 * x23 + x2345 * x235,
            x130 * x2339 + x2068 * x23 + x2069 * x23 + x2070 * x23 + x2346 * x235,
            x2071 * x23 + x2072 * x23 + x2073 * x23 + x2341 + x2347 * x235,
            x2074 * x23 + x2075 * x23 + x2076 * x23 + x2343 + x2344 * x323,
            x2077 * x23 + x2078 * x23 + x2079 * x23 + x2348 * x235,
            x117 * x2342
            + 3.0 * x2060
            + x2080 * x23
            + x2081 * x23
            + x2082 * x23
            + x2348 * x290,
        ]
    )


def _3center2el3d_040(a, A, b, B, c, C):
    """Cartesian (sg|s) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = -x3 - C[0]
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = c + x1
    x12 = c / x11
    x13 = x1 * x12 * (x10**2 + x6**2 + x8**2)
    x14 = boys(1, x13)
    x15 = 17.4934183276249
    x16 = A[1] - B[1]
    x17 = A[2] - B[2]
    x18 = numpy.exp(-a * b * x2 * (x0**2 + x16**2 + x17**2))
    x19 = 2.0 * x15 * x18 * x2
    x20 = x11 ** (-1.5) * x19
    x21 = x14 * x20
    x22 = c ** (-1.0)
    x23 = x11 ** (-0.5)
    x24 = boys(0, x13)
    x25 = 2.0 * x15 * x18 * x2 * x22 * x23 * x24 - x21
    x26 = x25 * x5
    x27 = x21 * x6
    x28 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x4 + x27
    x29 = -x28
    x30 = boys(2, x13)
    x31 = x20 * x30
    x32 = -2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x4 + x31 * x6
    x33 = -x32
    x34 = x12 * x33
    x35 = x34 * x6
    x36 = x26 + x29 * x4 - x35
    x37 = 2.0 * x5
    x38 = x5 * (2.0 * x14 * x15 * x18 * x2 * x22 * x23 - x31)
    x39 = boys(3, x13)
    x40 = x20 * x39
    x41 = 2.0 * x15 * x18 * x2 * x22 * x23 * x30 * x4 - x40 * x6
    x42 = x12 * x41
    x43 = x33 * x4 + x38 - x42 * x6
    x44 = x12 * x43
    x45 = x36 * x4 + x37 * (-x28 - x34) - x44 * x6
    x46 = x0 * x36 + x45
    x47 = x0 * x29 + x36
    x48 = x0 * x47 + x46
    x49 = x19 * x22 * x23 * x24
    x50 = -x25 * x5
    x51 = x5 * (2.0 * x15 * x18 * x2 * x22 * x23 * x30 - x40)
    x52 = x20 * boys(4, x13)
    x53 = x12 * x6
    x54 = -x7 - A[1]
    x55 = -2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x54 + x31 * x8
    x56 = -x55
    x57 = x12 * x56
    x58 = x21 * x8
    x59 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x54 + x58
    x60 = x5 * (-x57 - x59)
    x61 = -x59
    x62 = x57 * x6
    x63 = -x4 * x61 + x62
    x64 = -x63
    x65 = 2.0 * x15 * x18 * x2 * x22 * x23 * x30 * x54 - x40 * x8
    x66 = x12 * x65
    x67 = x4 * x56 - x6 * x66
    x68 = x12 * x67
    x69 = x4 * x64 - x6 * x68 + x60
    x70 = x16 * x36 + x69
    x71 = x16 * x29 + x4 * x61 - x62
    x72 = x0 * x71 + x70
    x73 = x16 * x49 + x49 * x54 - x58
    x74 = x5 * (-x55 - x66)
    x75 = 2.0 * x15 * x18 * x2 * x22 * x23 * x39 * x54 - x52 * x8
    x76 = -x9 - A[2]
    x77 = x10 * x31 - 2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x76
    x78 = -x77
    x79 = x12 * x78
    x80 = x10 * x21
    x81 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x76 + x80
    x82 = x5 * (-x79 - x81)
    x83 = -x81
    x84 = x6 * x79
    x85 = -x4 * x83 + x84
    x86 = -x85
    x87 = -x10 * x40 + 2.0 * x15 * x18 * x2 * x22 * x23 * x30 * x76
    x88 = x12 * x87
    x89 = x4 * x78 - x6 * x88
    x90 = x12 * x89
    x91 = x4 * x86 - x6 * x90 + x82
    x92 = x17 * x36 + x91
    x93 = x17 * x29 + x4 * x83 - x84
    x94 = x0 * x93 + x92
    x95 = x17 * x49 + x49 * x76 - x80
    x96 = x5 * (-x77 - x88)
    x97 = -x10 * x52 + 2.0 * x15 * x18 * x2 * x22 * x23 * x39 * x76
    x98 = x38 + x54 * x56 - x66 * x8
    x99 = x12 * x98
    x100 = x57 * x8
    x101 = x5 * (-x100 - x50 + x54 * x61 - x99)
    x102 = -x100 + x26 + x54 * x61
    x103 = x6 * x99
    x104 = x102 * x4 - x103 + x16 * x64
    x105 = x104 + x16 * x71
    x106 = x102 + x16 * x61
    x107 = x106 + x16 * x73
    x108 = x102 * x4 - x103
    x109 = x12 * x8
    x110 = -x109 * x75 + x51 + x54 * x65
    x111 = x54 * x78 - x8 * x88
    x112 = x111 * x12
    x113 = x79 * x8
    x114 = x113 - x54 * x83
    x115 = x5 * (-x112 - x114)
    x116 = -x114
    x117 = x112 * x6
    x118 = x116 * x4 - x117 + x17 * x64
    x119 = x118 + x16 * x93
    x120 = -x113 + x17 * x61 + x54 * x83
    x121 = x120 + x16 * x95
    x122 = x116 * x4 - x117
    x123 = -x109 * x97 + x54 * x87
    x124 = -x10 * x88 + x38 + x76 * x78
    x125 = x12 * x124
    x126 = x10 * x79
    x127 = x5 * (-x125 - x126 - x50 + x76 * x83)
    x128 = -x126 + x26 + x76 * x83
    x129 = x125 * x6
    x130 = x128 * x4 - x129 + x17 * x86
    x131 = x130 + x17 * x93
    x132 = x128 + x17 * x83
    x133 = x132 + x17 * x95
    x134 = x128 * x4 - x129
    x135 = x10 * x12
    x136 = -x135 * x97 + x51 + x76 * x87
    x137 = x102 * x54 + 2.0 * x60 - x8 * x99
    x138 = x102 * x16 + x137
    x139 = x106 * x16 + x138
    x140 = x107 * x16 + x139
    x141 = -x109 * x110 + x54 * x98 + 2.0 * x74
    x142 = -x112 * x8 + x116 * x54 + x82
    x143 = x102 * x17 + x142
    x144 = x120 * x16 + x143
    x145 = x121 * x16 + x144
    x146 = -x109 * x123 + x111 * x54 + x96
    x147 = x125 * x8
    x148 = x116 * x17 + x128 * x54 - x147
    x149 = x120 * x17 + x148
    x150 = x133 * x16 + x149
    x151 = x128 * x54 - x147
    x152 = -x109 * x136 + x124 * x54
    x153 = -x10 * x125 + x128 * x76 + 2.0 * x82
    x154 = x128 * x17 + x153
    x155 = x132 * x17 + x154
    x156 = x133 * x17 + x155
    x157 = x124 * x76 - x135 * x136 + 2.0 * x96

    # 15 item(s)
    return numpy.array(
        [
            x0 * x45
            + x0 * x46
            + x0 * x48
            + x0 * (x0 * (x0 * (x0 * x49 - x27 + x4 * x49) + x47) + x48)
            + x4 * x45
            + 3.0 * x5 * (x29 * x4 - x35 - x44 - x50)
            - x53
            * (
                x37 * (-x32 - x42)
                + x4 * x43
                - x53
                * (
                    x4 * x41
                    + x51
                    - x53 * (2.0 * x15 * x18 * x2 * x22 * x23 * x39 * x4 - x52 * x6)
                )
            ),
            x0 * x70
            + x0 * x72
            + x0 * (x0 * (x0 * x73 + x71) + x72)
            + x16 * x45
            + x37 * (-x63 - x68)
            + x4 * x69
            - x53 * (x4 * x67 - x53 * (x4 * x65 - x53 * x75) + x74),
            x0 * x92
            + x0 * x94
            + x0 * (x0 * (x0 * x95 + x93) + x94)
            + x17 * x45
            + x37 * (-x85 - x90)
            + x4 * x91
            - x53 * (x4 * x89 - x53 * (x4 * x87 - x53 * x97) + x96),
            x0 * x105
            + x0 * (x0 * x107 + x105)
            + x101
            + x108 * x4
            + x16 * x69
            + x16 * x70
            - x53 * (-x110 * x53 + x4 * x98),
            x0 * x119
            + x0 * (x0 * x121 + x119)
            + x115
            + x122 * x4
            + x16 * x92
            + x17 * x69
            - x53 * (x111 * x4 - x123 * x53),
            x0 * x131
            + x0 * (x0 * x133 + x131)
            + x127
            + x134 * x4
            + x17 * x91
            + x17 * x92
            - x53 * (x124 * x4 - x136 * x53),
            x0 * x140 + x104 * x16 + x105 * x16 + x108 * x16 + x137 * x4 - x141 * x53,
            x0 * x145 + x108 * x17 + x118 * x16 + x119 * x16 + x142 * x4 - x146 * x53,
            x0 * x150 + x118 * x17 + x122 * x17 + x131 * x16 + x151 * x4 - x152 * x53,
            x0 * x156 + x130 * x17 + x131 * x17 + x134 * x17 + x153 * x4 - x157 * x53,
            3.0 * x101
            - x109 * x141
            + x137 * x16
            + x137 * x54
            + x138 * x16
            + x139 * x16
            + x140 * x16,
            -x109 * x146
            + 2.0 * x115
            + x137 * x17
            + x142 * x54
            + x143 * x16
            + x144 * x16
            + x145 * x16,
            -x109 * x152
            + x127
            + x142 * x17
            + x143 * x17
            + x149 * x16
            + x150 * x16
            + x151 * x54,
            -x109 * x157 + x148 * x17 + x149 * x17 + x151 * x17 + x153 * x54 + x156 * x16,
            3.0 * x127
            - x135 * x157
            + x153 * x17
            + x153 * x76
            + x154 * x17
            + x155 * x17
            + x156 * x17,
        ]
    )


def _3center2el3d_041(a, A, b, B, c, C):
    """Cartesian (sg|p) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = x1 ** (-1.0)
    x4 = a + b
    x5 = x4 ** (-1.0)
    x6 = -x5 * (a * A[0] + b * B[0])
    x7 = -x6 - C[0]
    x8 = -x5 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = -x5 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = c + x4
    x13 = x12 ** (-1.0)
    x14 = c * x13
    x15 = x14 * x4 * (x11**2 + x7**2 + x9**2)
    x16 = boys(2, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[1] - B[1]
    x20 = A[2] - B[2]
    x21 = numpy.exp(-a * b * x5 * (x0**2 + x19**2 + x20**2))
    x22 = x18 * x21 * x5
    x23 = 2.0 * x17 * x22
    x24 = x16 * x23
    x25 = c ** (-1.0)
    x26 = x12 ** (-0.5)
    x27 = boys(1, x15)
    x28 = 2.0 * x18 * x21 * x25 * x26 * x27 * x5 - x24
    x29 = x28 * x3
    x30 = -x6 - A[0]
    x31 = -2.0 * x18 * x21 * x25 * x26 * x27 * x30 * x5 + x24 * x7
    x32 = -x31
    x33 = boys(3, x15)
    x34 = x23 * x33
    x35 = -2.0 * x16 * x18 * x21 * x25 * x26 * x30 * x5 + x34 * x7
    x36 = -x35
    x37 = x14 * x36
    x38 = x37 * x7
    x39 = x29 + x30 * x32 - x38
    x40 = x2 * x39
    x41 = 2.0 * x3
    x42 = x3 * (2.0 * x16 * x18 * x21 * x25 * x26 * x5 - x34)
    x43 = boys(4, x15)
    x44 = x23 * x43
    x45 = 2.0 * x18 * x21 * x25 * x26 * x30 * x33 * x5 - x44 * x7
    x46 = x14 * x45
    x47 = x30 * x36 + x42 - x46 * x7
    x48 = x14 * x47
    x49 = x30 * x39 + x41 * (-x31 - x37) - x48 * x7
    x50 = x13 * x4
    x51 = x50 * x7
    x52 = 3.0 * x40 + x49 * x51
    x53 = x2 * x32
    x54 = x39 * x51 + 2.0 * x53
    x55 = x0 * x54 + x52
    x56 = 2.0 * x2
    x57 = x25 * x27
    x58 = x22 * x26 * x56 * x57
    x59 = x32 * x51 + x58
    x60 = x0 * x59 + x54
    x61 = x0 * x60 + x55
    x62 = 2.0 * x17 * x18 * x21 * x57
    x63 = x0 * x62
    x64 = x2 * x49
    x65 = -x28 * x3
    x66 = x3 * (2.0 * x18 * x21 * x25 * x26 * x33 * x5 - x44)
    x67 = x23 * boys(5, x15)
    x68 = x14 * x7
    x69 = (
        3.0 * x3 * (x30 * x32 - x38 - x48 - x65)
        + x30 * x49
        - x68
        * (
            x30 * x47
            + x41 * (-x35 - x46)
            - x68
            * (
                x30 * x45
                + x66
                - x68 * (2.0 * x18 * x21 * x25 * x26 * x30 * x43 * x5 - x67 * x7)
            )
        )
    )
    x70 = x50 * x9
    x71 = x49 * x70
    x72 = x39 * x70
    x73 = x0 * x72 + x71
    x74 = x32 * x70
    x75 = x0 * x74 + x72
    x76 = x0 * x75 + x73
    x77 = x11 * x50
    x78 = x49 * x77
    x79 = x39 * x77
    x80 = x0 * x79 + x78
    x81 = x32 * x77
    x82 = x0 * x81 + x79
    x83 = x0 * x82 + x80
    x84 = -x8 - A[1]
    x85 = -2.0 * x18 * x21 * x25 * x26 * x27 * x5 * x84 + x24 * x9
    x86 = -x85
    x87 = -2.0 * x16 * x18 * x21 * x25 * x26 * x5 * x84 + x34 * x9
    x88 = -x87
    x89 = x14 * x88
    x90 = -x30 * x86 + x7 * x89
    x91 = -x90
    x92 = x2 * x91
    x93 = 2.0 * x92
    x94 = x3 * (-x85 - x89)
    x95 = 2.0 * x18 * x21 * x25 * x26 * x33 * x5 * x84 - x44 * x9
    x96 = x14 * x95
    x97 = x30 * x88 - x7 * x96
    x98 = x14 * x97
    x99 = x30 * x91 - x7 * x98 + x94
    x100 = x51 * x99 + x93
    x101 = x100 + x19 * x54
    x102 = x2 * x86
    x103 = x102 + x51 * x91
    x104 = x103 + x19 * x59
    x105 = x0 * x104 + x101
    x106 = x51 * x86
    x107 = x19 * x62
    x108 = x106 + x107 * x7
    x109 = x2 * x99
    x110 = x3 * (-x87 - x96)
    x111 = 2.0 * x18 * x21 * x25 * x26 * x43 * x5 * x84 - x67 * x9
    x112 = (
        x30 * x99
        + x41 * (-x90 - x98)
        - x68 * (x110 + x30 * x97 - x68 * (-x111 * x68 + x30 * x95))
    )
    x113 = x40 + x70 * x99
    x114 = x113 + x19 * x72
    x115 = x53 + x70 * x91
    x116 = x115 + x19 * x74
    x117 = x0 * x116 + x114
    x118 = x58 + x70 * x86
    x119 = x107 * x9 + x118
    x120 = x77 * x99
    x121 = x120 + x19 * x79
    x122 = x77 * x91
    x123 = x122 + x19 * x81
    x124 = x0 * x123 + x121
    x125 = x77 * x86
    x126 = x107 * x11 + x125
    x127 = -x10 - A[2]
    x128 = x11 * x24 - 2.0 * x127 * x18 * x21 * x25 * x26 * x27 * x5
    x129 = -x128
    x130 = x11 * x34 - 2.0 * x127 * x16 * x18 * x21 * x25 * x26 * x5
    x131 = -x130
    x132 = x131 * x14
    x133 = -x129 * x30 + x132 * x7
    x134 = -x133
    x135 = x134 * x2
    x136 = 2.0 * x135
    x137 = x3 * (-x128 - x132)
    x138 = -x11 * x44 + 2.0 * x127 * x18 * x21 * x25 * x26 * x33 * x5
    x139 = x138 * x14
    x140 = x131 * x30 - x139 * x7
    x141 = x14 * x140
    x142 = x134 * x30 + x137 - x141 * x7
    x143 = x136 + x142 * x51
    x144 = x143 + x20 * x54
    x145 = x129 * x2
    x146 = x134 * x51 + x145
    x147 = x146 + x20 * x59
    x148 = x0 * x147 + x144
    x149 = x129 * x51
    x150 = x20 * x62
    x151 = x149 + x150 * x7
    x152 = x142 * x2
    x153 = x3 * (-x130 - x139)
    x154 = -x11 * x67 + 2.0 * x127 * x18 * x21 * x25 * x26 * x43 * x5
    x155 = (
        x142 * x30
        + x41 * (-x133 - x141)
        - x68 * (x140 * x30 + x153 - x68 * (x138 * x30 - x154 * x68))
    )
    x156 = x142 * x70
    x157 = x156 + x20 * x72
    x158 = x134 * x70
    x159 = x158 + x20 * x74
    x160 = x0 * x159 + x157
    x161 = x129 * x70
    x162 = x150 * x9 + x161
    x163 = x142 * x77 + x40
    x164 = x163 + x20 * x79
    x165 = x134 * x77 + x53
    x166 = x165 + x20 * x81
    x167 = x0 * x166 + x164
    x168 = x129 * x77 + x58
    x169 = x11 * x150 + x168
    x170 = x89 * x9
    x171 = -x170 + x29 + x84 * x86
    x172 = x171 * x2
    x173 = x42 + x84 * x88 - x9 * x96
    x174 = x14 * x173
    x175 = x171 * x30 - x174 * x7
    x176 = x172 + x175 * x51
    x177 = x103 * x19 + x176
    x178 = x104 * x19 + x177
    x179 = x171 * x51
    x180 = x106 * x19 + x179
    x181 = x108 * x19 + x180
    x182 = x175 * x2
    x183 = x3 * (-x170 - x174 - x65 + x84 * x86)
    x184 = x14 * x9
    x185 = -x111 * x184 + x66 + x84 * x95
    x186 = x175 * x30 + x183 - x68 * (x173 * x30 - x185 * x68)
    x187 = x175 * x70 + x93
    x188 = x115 * x19 + x187
    x189 = x116 * x19 + x188
    x190 = 2.0 * x102 + x171 * x70
    x191 = x118 * x19 + x190
    x192 = x119 * x19 + x191
    x193 = x175 * x77
    x194 = x122 * x19 + x193
    x195 = x123 * x19 + x194
    x196 = x171 * x77
    x197 = x125 * x19 + x196
    x198 = x126 * x19 + x197
    x199 = -x129 * x84 + x132 * x9
    x200 = -x199
    x201 = x2 * x200
    x202 = x131 * x84 - x139 * x9
    x203 = x14 * x202
    x204 = x200 * x30 - x203 * x7
    x205 = x201 + x204 * x51
    x206 = x103 * x20 + x205
    x207 = x147 * x19 + x206
    x208 = x200 * x51
    x209 = x106 * x20 + x208
    x210 = x151 * x19 + x209
    x211 = x204 * x56
    x212 = x3 * (-x199 - x203)
    x213 = x138 * x84 - x154 * x184
    x214 = x204 * x30 + x212 - x68 * (x202 * x30 - x213 * x68)
    x215 = x135 + x204 * x70
    x216 = x115 * x20 + x215
    x217 = x159 * x19 + x216
    x218 = x145 + x200 * x70
    x219 = x118 * x20 + x218
    x220 = x162 * x19 + x219
    x221 = x204 * x77 + x92
    x222 = x122 * x20 + x221
    x223 = x166 * x19 + x222
    x224 = x102 + x200 * x77
    x225 = x125 * x20 + x224
    x226 = x169 * x19 + x225
    x227 = x11 * x132
    x228 = x127 * x129 - x227 + x29
    x229 = x2 * x228
    x230 = -x11 * x139 + x127 * x131 + x42
    x231 = x14 * x230
    x232 = x228 * x30 - x231 * x7
    x233 = x229 + x232 * x51
    x234 = x146 * x20 + x233
    x235 = x147 * x20 + x234
    x236 = x228 * x51
    x237 = x149 * x20 + x236
    x238 = x151 * x20 + x237
    x239 = x2 * x232
    x240 = x3 * (x127 * x129 - x227 - x231 - x65)
    x241 = x11 * x14
    x242 = x127 * x138 - x154 * x241 + x66
    x243 = x232 * x30 + x240 - x68 * (x230 * x30 - x242 * x68)
    x244 = x232 * x70
    x245 = x158 * x20 + x244
    x246 = x159 * x20 + x245
    x247 = x228 * x70
    x248 = x161 * x20 + x247
    x249 = x162 * x20 + x248
    x250 = x136 + x232 * x77
    x251 = x165 * x20 + x250
    x252 = x166 * x20 + x251
    x253 = 2.0 * x145 + x228 * x77
    x254 = x168 * x20 + x253
    x255 = x169 * x20 + x254
    x256 = x171 * x84 - x174 * x9 + 2.0 * x94
    x257 = x2 * x256
    x258 = x256 * x51
    x259 = x179 * x19 + x258
    x260 = x180 * x19 + x259
    x261 = x181 * x19 + x260
    x262 = 2.0 * x110 + x173 * x84 - x184 * x185
    x263 = x256 * x30 - x262 * x68
    x264 = 3.0 * x172 + x256 * x70
    x265 = x19 * x190 + x264
    x266 = x19 * x191 + x265
    x267 = x19 * x192 + x266
    x268 = x256 * x77
    x269 = x19 * x196 + x268
    x270 = x19 * x197 + x269
    x271 = x19 * x198 + x270
    x272 = x137 + x200 * x84 - x203 * x9
    x273 = x2 * x272
    x274 = x272 * x51
    x275 = x179 * x20 + x274
    x276 = x19 * x209 + x275
    x277 = x19 * x210 + x276
    x278 = x153 - x184 * x213 + x202 * x84
    x279 = x272 * x30 - x278 * x68
    x280 = 2.0 * x201
    x281 = x272 * x70 + x280
    x282 = x190 * x20 + x281
    x283 = x19 * x219 + x282
    x284 = x19 * x220 + x283
    x285 = x172 + x272 * x77
    x286 = x196 * x20 + x285
    x287 = x19 * x225 + x286
    x288 = x19 * x226 + x287
    x289 = x228 * x84 - x231 * x9
    x290 = x2 * x289
    x291 = x289 * x51
    x292 = x20 * x208 + x291
    x293 = x20 * x209 + x292
    x294 = x19 * x238 + x293
    x295 = -x184 * x242 + x230 * x84
    x296 = x289 * x30 - x295 * x68
    x297 = x229 + x289 * x70
    x298 = x20 * x218 + x297
    x299 = x20 * x219 + x298
    x300 = x19 * x249 + x299
    x301 = x280 + x289 * x77
    x302 = x20 * x224 + x301
    x303 = x20 * x225 + x302
    x304 = x19 * x255 + x303
    x305 = -x11 * x231 + x127 * x228 + 2.0 * x137
    x306 = x2 * x305
    x307 = x305 * x51
    x308 = x20 * x236 + x307
    x309 = x20 * x237 + x308
    x310 = x20 * x238 + x309
    x311 = x127 * x230 + 2.0 * x153 - x241 * x242
    x312 = x30 * x305 - x311 * x68
    x313 = x305 * x70
    x314 = x20 * x247 + x313
    x315 = x20 * x248 + x314
    x316 = x20 * x249 + x315
    x317 = 3.0 * x229 + x305 * x77
    x318 = x20 * x253 + x317
    x319 = x20 * x254 + x318
    x320 = x20 * x255 + x319
    x321 = 3.0 * x183 - x184 * x262 + x256 * x84
    x322 = -x184 * x278 + 2.0 * x212 + x272 * x84
    x323 = -x184 * x295 + x240 + x289 * x84
    x324 = -x184 * x311 + x305 * x84
    x325 = x127 * x305 + 3.0 * x240 - x241 * x311

    # 45 item(s)
    return numpy.array(
        [
            x0 * x52
            + x0 * x55
            + x0 * x61
            + x0 * (x0 * (x0 * (x59 + x63 * x7) + x60) + x61)
            + x51 * x69
            + 4.0 * x64,
            x0 * x71
            + x0 * x73
            + x0 * x76
            + x0 * (x0 * (x0 * (x63 * x9 + x74) + x75) + x76)
            + x69 * x70,
            x0 * x78
            + x0 * x80
            + x0 * x83
            + x0 * (x0 * (x0 * (x11 * x63 + x81) + x82) + x83)
            + x69 * x77,
            x0 * x101
            + x0 * x105
            + x0 * (x0 * (x0 * x108 + x104) + x105)
            + 3.0 * x109
            + x112 * x51
            + x19 * x52,
            x0 * x114
            + x0 * x117
            + x0 * (x0 * (x0 * x119 + x116) + x117)
            + x112 * x70
            + x19 * x71
            + x64,
            x0 * x121
            + x0 * x124
            + x0 * (x0 * (x0 * x126 + x123) + x124)
            + x112 * x77
            + x19 * x78,
            x0 * x144
            + x0 * x148
            + x0 * (x0 * (x0 * x151 + x147) + x148)
            + 3.0 * x152
            + x155 * x51
            + x20 * x52,
            x0 * x157
            + x0 * x160
            + x0 * (x0 * (x0 * x162 + x159) + x160)
            + x155 * x70
            + x20 * x71,
            x0 * x164
            + x0 * x167
            + x0 * (x0 * (x0 * x169 + x166) + x167)
            + x155 * x77
            + x20 * x78
            + x64,
            x0 * x178
            + x0 * (x0 * x181 + x178)
            + x100 * x19
            + x101 * x19
            + 2.0 * x182
            + x186 * x51,
            x0 * x189
            + x0 * (x0 * x192 + x189)
            + 2.0 * x109
            + x113 * x19
            + x114 * x19
            + x186 * x70,
            x0 * x195 + x0 * (x0 * x198 + x195) + x120 * x19 + x121 * x19 + x186 * x77,
            x0 * x207
            + x0 * (x0 * x210 + x207)
            + x100 * x20
            + x144 * x19
            + x211
            + x214 * x51,
            x0 * x217
            + x0 * (x0 * x220 + x217)
            + x113 * x20
            + x152
            + x157 * x19
            + x214 * x70,
            x0 * x223
            + x0 * (x0 * x226 + x223)
            + x109
            + x120 * x20
            + x164 * x19
            + x214 * x77,
            x0 * x235
            + x0 * (x0 * x238 + x235)
            + x143 * x20
            + x144 * x20
            + 2.0 * x239
            + x243 * x51,
            x0 * x246 + x0 * (x0 * x249 + x246) + x156 * x20 + x157 * x20 + x243 * x70,
            x0 * x252
            + x0 * (x0 * x255 + x252)
            + 2.0 * x152
            + x163 * x20
            + x164 * x20
            + x243 * x77,
            x0 * x261 + x176 * x19 + x177 * x19 + x178 * x19 + x257 + x263 * x51,
            x0 * x267 + 3.0 * x182 + x187 * x19 + x188 * x19 + x189 * x19 + x263 * x70,
            x0 * x271 + x19 * x193 + x19 * x194 + x19 * x195 + x263 * x77,
            x0 * x277 + x176 * x20 + x19 * x206 + x19 * x207 + x273 + x279 * x51,
            x0 * x284 + x187 * x20 + x19 * x216 + x19 * x217 + x211 + x279 * x70,
            x0 * x288 + x182 + x19 * x222 + x19 * x223 + x193 * x20 + x279 * x77,
            x0 * x294 + x19 * x235 + x20 * x205 + x20 * x206 + x290 + x296 * x51,
            x0 * x300 + x19 * x246 + x20 * x215 + x20 * x216 + x239 + x296 * x70,
            x0 * x304 + x19 * x252 + x20 * x221 + x20 * x222 + x211 + x296 * x77,
            x0 * x310 + x20 * x233 + x20 * x234 + x20 * x235 + x306 + x312 * x51,
            x0 * x316 + x20 * x244 + x20 * x245 + x20 * x246 + x312 * x70,
            x0 * x320 + x20 * x250 + x20 * x251 + x20 * x252 + 3.0 * x239 + x312 * x77,
            x19 * x258 + x19 * x259 + x19 * x260 + x19 * x261 + x321 * x51,
            x19 * x264 + x19 * x265 + x19 * x266 + x19 * x267 + 4.0 * x257 + x321 * x70,
            x19 * x268 + x19 * x269 + x19 * x270 + x19 * x271 + x321 * x77,
            x19 * x275 + x19 * x276 + x19 * x277 + x20 * x258 + x322 * x51,
            x19 * x282 + x19 * x283 + x19 * x284 + x20 * x264 + 3.0 * x273 + x322 * x70,
            x19 * x286 + x19 * x287 + x19 * x288 + x20 * x268 + x257 + x322 * x77,
            x19 * x293 + x19 * x294 + x20 * x274 + x20 * x275 + x323 * x51,
            x19 * x299 + x19 * x300 + x20 * x281 + x20 * x282 + 2.0 * x290 + x323 * x70,
            x19 * x303 + x19 * x304 + x20 * x285 + x20 * x286 + 2.0 * x273 + x323 * x77,
            x19 * x310 + x20 * x291 + x20 * x292 + x20 * x293 + x324 * x51,
            x19 * x316 + x20 * x297 + x20 * x298 + x20 * x299 + x306 + x324 * x70,
            x19 * x320 + x20 * x301 + x20 * x302 + x20 * x303 + 3.0 * x290 + x324 * x77,
            x20 * x307 + x20 * x308 + x20 * x309 + x20 * x310 + x325 * x51,
            x20 * x313 + x20 * x314 + x20 * x315 + x20 * x316 + x325 * x70,
            x20 * x317 + x20 * x318 + x20 * x319 + x20 * x320 + 4.0 * x306 + x325 * x77,
        ]
    )


def _3center2el3d_042(a, A, b, B, c, C):
    """Cartesian (sg|d) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = 2.0 * a + 2.0 * b
    x6 = x5 ** (-1.0)
    x7 = -x3 - C[0]
    x8 = x7**2
    x9 = -x2 * (a * A[1] + b * B[1])
    x10 = -x9 - C[1]
    x11 = x10**2
    x12 = -x2 * (a * A[2] + b * B[2])
    x13 = -x12 - C[2]
    x14 = x13**2
    x15 = c + x1
    x16 = x15 ** (-1.0)
    x17 = c * x16
    x18 = x1 * x17 * (x11 + x14 + x8)
    x19 = boys(1, x18)
    x20 = x15 ** (-1.5)
    x21 = 17.4934183276249
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x2 * (x0**2 + x22**2 + x23**2))
    x25 = x2 * x21 * x24
    x26 = 2.0 * x20 * x25
    x27 = x19 * x26
    x28 = c ** (-1.0)
    x29 = x15 ** (-0.5)
    x30 = boys(0, x18)
    x31 = -2.0 * x2 * x21 * x24 * x28 * x29 * x30
    x32 = -x27 - x31
    x33 = x32 * x6
    x34 = -2.0 * x2 * x21 * x24 * x28 * x29 * x30 * x4 + x27 * x7
    x35 = -x34
    x36 = boys(2, x18)
    x37 = x26 * x36
    x38 = -2.0 * x19 * x2 * x21 * x24 * x28 * x29 * x4 + x37 * x7
    x39 = -x38
    x40 = x17 * x39
    x41 = x40 * x7
    x42 = x33 + x35 * x4 - x41
    x43 = -x34 - x40
    x44 = 2.0 * x19 * x2 * x21 * x24 * x28 * x29 - x37
    x45 = x44 * x6
    x46 = boys(3, x18)
    x47 = x26 * x46
    x48 = -2.0 * x2 * x21 * x24 * x28 * x29 * x36 * x4 + x47 * x7
    x49 = -x48
    x50 = x17 * x49
    x51 = x50 * x7
    x52 = x39 * x4 + x45 - x51
    x53 = 2.0 * x6
    x54 = 2.0 * x2 * x21 * x24 * x28 * x29 * x36 - x47
    x55 = x54 * x6
    x56 = boys(4, x18)
    x57 = x26 * x56
    x58 = -2.0 * x2 * x21 * x24 * x28 * x29 * x4 * x46 + x57 * x7
    x59 = -x58
    x60 = x17 * x59
    x61 = x60 * x7
    x62 = x4 * x49 + x55 - x61
    x63 = x17 * x62
    x64 = x4 * x52 + x53 * (-x38 - x50) - x63 * x7
    x65 = x1 * x16
    x66 = x17 * x52
    x67 = x66 * x7
    x68 = 0.5 * x28
    x69 = x68 * (x4 * x42 + 2.0 * x43 * x6 - x64 * x65 - x67)
    x70 = (2.0 * c + x5) ** (-1.0)
    x71 = x49 * x70
    x72 = 2.0 * x71
    x73 = x65 * x7
    x74 = x62 * x73 + x72
    x75 = 3.0 * x70
    x76 = x62 * x70
    x77 = 3.0 * x76
    x78 = x6 * (2.0 * x2 * x21 * x24 * x28 * x29 * x46 - x57)
    x79 = boys(5, x18)
    x80 = x26 * x79
    x81 = 2.0 * x2 * x21 * x24 * x28 * x29 * x4 * x56 - x7 * x80
    x82 = x17 * x81
    x83 = x4 * x59 - x7 * x82 + x78
    x84 = x17 * x83
    x85 = x4 * x62 + x53 * (-x48 - x60) - x7 * x84
    x86 = x73 * x85 + x77
    x87 = x69 + x73 * x86 + x74 * x75
    x88 = -x32 * x6
    x89 = -x35 * x4 + x41 + x88
    x90 = x68 * (-x52 * x65 - x89)
    x91 = 2.0 * x70
    x92 = x28 * x36
    x93 = x91 * x92
    x94 = x25 * x29 * x93
    x95 = x49 * x73 + x94
    x96 = x73 * x74 + x90 + x91 * x95
    x97 = x0 * x96 + x87
    x98 = x68 * (-x34 - x39 * x65)
    x99 = x20 * x21 * x24
    x100 = x93 * x99
    x101 = x100 * x7 + x73 * x95 + x98
    x102 = x0 * x101 + x96
    x103 = x0 * x102 + x97
    x104 = x68 * (-2.0 * x19 * x28 * x99 - x31)
    x105 = 2.0 * x1 * x15 ** (-2.5) * x21 * x24 * x92
    x106 = x104 + x105 * x8
    x107 = -x44 * x6
    x108 = 3.0 * x6
    x109 = x17 * x7
    x110 = x68 * (
        -x109 * x64
        + x4 * (x4 * x42 + x43 * x53 - x67)
        + 3.0 * x6 * (-x66 - x89)
        - x65 * (x108 * (-x107 + x39 * x4 - x51 - x63) - x109 * x85 + x4 * x64)
    )
    x111 = x70 * x85
    x112 = 4.0 * x111
    x113 = -x54 * x6
    x114 = x6 * (2.0 * x2 * x21 * x24 * x28 * x29 * x56 - x80)
    x115 = x26 * boys(6, x18)
    x116 = (
        x108 * (-x113 + x4 * x49 - x61 - x84)
        - x109
        * (
            -x109
            * (
                -x109 * (-x115 * x7 + 2.0 * x2 * x21 * x24 * x28 * x29 * x4 * x79)
                + x114
                + x4 * x81
            )
            + x4 * x83
            + x53 * (-x58 - x82)
        )
        + x4 * x85
    )
    x117 = x1**2 / x15**2
    x118 = x117 * x7
    x119 = x10 * x118
    x120 = x10 * x65
    x121 = x119 * x85 + x120 * x77
    x122 = x119 * x62 + x120 * x72
    x123 = x0 * x122 + x121
    x124 = x10 * x100
    x125 = x119 * x49 + x124
    x126 = x0 * x125 + x122
    x127 = x0 * x126 + x123
    x128 = x0 * x105
    x129 = x128 * x7
    x130 = x118 * x13
    x131 = x13 * x65
    x132 = x130 * x85 + x131 * x77
    x133 = x130 * x62 + x131 * x72
    x134 = x0 * x133 + x132
    x135 = x100 * x13
    x136 = x130 * x49 + x135
    x137 = x0 * x136 + x133
    x138 = x0 * x137 + x134
    x139 = x11 * x117
    x140 = x139 * x85 + x69
    x141 = x139 * x62 + x90
    x142 = x0 * x141 + x140
    x143 = x139 * x49 + x98
    x144 = x0 * x143 + x141
    x145 = x0 * x144 + x142
    x146 = x104 + x105 * x11
    x147 = x10 * x13
    x148 = x117 * x147
    x149 = x148 * x85
    x150 = x148 * x62
    x151 = x0 * x150 + x149
    x152 = x148 * x49
    x153 = x0 * x152 + x150
    x154 = x0 * x153 + x151
    x155 = x117 * x14
    x156 = x155 * x85 + x69
    x157 = x155 * x62 + x90
    x158 = x0 * x157 + x156
    x159 = x155 * x49 + x98
    x160 = x0 * x159 + x157
    x161 = x0 * x160 + x158
    x162 = x104 + x105 * x14
    x163 = -x9 - A[1]
    x164 = x10 * x37 - 2.0 * x163 * x19 * x2 * x21 * x24 * x28 * x29
    x165 = -x164
    x166 = x165 * x17
    x167 = x10 * x27 - 2.0 * x163 * x2 * x21 * x24 * x28 * x29 * x30
    x168 = -x166 - x167
    x169 = -x167
    x170 = x166 * x7 - x169 * x4
    x171 = -x170
    x172 = x10 * x47 - 2.0 * x163 * x2 * x21 * x24 * x28 * x29 * x36
    x173 = -x172
    x174 = x17 * x173
    x175 = x6 * (-x164 - x174)
    x176 = -x165 * x4 + x174 * x7
    x177 = -x176
    x178 = x10 * x57 - 2.0 * x163 * x2 * x21 * x24 * x28 * x29 * x46
    x179 = -x178
    x180 = x17 * x179
    x181 = -x173 * x4 + x180 * x7
    x182 = -x181
    x183 = x17 * x182
    x184 = x175 + x177 * x4 - x183 * x7
    x185 = x17 * x177
    x186 = x185 * x7
    x187 = x68 * (x168 * x6 + x171 * x4 - x184 * x65 - x186)
    x188 = x173 * x70
    x189 = x182 * x73 + x188
    x190 = x182 * x70
    x191 = 2.0 * x190
    x192 = x6 * (-x172 - x180)
    x193 = -x10 * x80 + 2.0 * x163 * x2 * x21 * x24 * x28 * x29 * x56
    x194 = x17 * x193
    x195 = x179 * x4 - x194 * x7
    x196 = x17 * x195
    x197 = x182 * x4 + x192 - x196 * x7
    x198 = x191 + x197 * x73
    x199 = x187 + x189 * x91 + x198 * x73
    x200 = x199 + x22 * x96
    x201 = x68 * (-x170 - x177 * x65)
    x202 = x188 * x73 + x189 * x73 + x201
    x203 = x101 * x22 + x202
    x204 = x0 * x203 + x200
    x205 = x68 * (-x165 * x65 - x167)
    x206 = x117 * x8
    x207 = x173 * x206 + x205
    x208 = x106 * x22 + x207
    x209 = x168 * x6
    x210 = x68 * (
        -x109 * x184
        + x4 * (x171 * x4 - x186 + x209)
        + 2.0 * x6 * (-x170 - x185)
        - x65 * (-x109 * x197 + x184 * x4 + x53 * (-x176 - x183))
    )
    x211 = x197 * x70
    x212 = 3.0 * x211
    x213 = x6 * (-x178 - x194)
    x214 = -x10 * x115 + 2.0 * x163 * x2 * x21 * x24 * x28 * x29 * x79
    x215 = (
        -x109 * (-x109 * (-x109 * x214 + x193 * x4) + x195 * x4 + x213)
        + x197 * x4
        + x53 * (-x181 - x196)
    )
    x216 = x120 * x182 + x71
    x217 = x216 * x91
    x218 = x120 * x197 + x76
    x219 = x217 + x218 * x73
    x220 = x122 * x22 + x219
    x221 = x120 * x173 + x94
    x222 = x221 * x70
    x223 = x216 * x73 + x222
    x224 = x125 * x22 + x223
    x225 = x0 * x224 + x220
    x226 = x221 * x73
    x227 = x105 * x22
    x228 = x227 * x7
    x229 = x10 * x228 + x226
    x230 = x111 + x120 * x215
    x231 = x131 * x191
    x232 = x130 * x197 + x231
    x233 = x133 * x22 + x232
    x234 = x131 * x188
    x235 = x130 * x182 + x234
    x236 = x136 * x22 + x235
    x237 = x0 * x236 + x233
    x238 = x130 * x173
    x239 = x13 * x228 + x238
    x240 = x120 * x218 + x120 * x76 + x187
    x241 = x141 * x22 + x240
    x242 = x120 * x216 + x120 * x71 + x201
    x243 = x143 * x22 + x242
    x244 = x0 * x243 + x241
    x245 = x120 * x221 + x124 + x205
    x246 = x146 * x22 + x245
    x247 = x131 * x76
    x248 = x148 * x197 + x247
    x249 = x150 * x22 + x248
    x250 = x131 * x71
    x251 = x148 * x182 + x250
    x252 = x152 * x22 + x251
    x253 = x0 * x252 + x249
    x254 = x135 + x148 * x173
    x255 = x147 * x227 + x254
    x256 = x111 * x131
    x257 = x155 * x197 + x187
    x258 = x157 * x22 + x257
    x259 = x155 * x182 + x201
    x260 = x159 * x22 + x259
    x261 = x0 * x260 + x258
    x262 = x155 * x173 + x205
    x263 = x162 * x22 + x262
    x264 = -x12 - A[2]
    x265 = x13 * x37 - 2.0 * x19 * x2 * x21 * x24 * x264 * x28 * x29
    x266 = -x265
    x267 = x17 * x266
    x268 = x13 * x27 - 2.0 * x2 * x21 * x24 * x264 * x28 * x29 * x30
    x269 = -x267 - x268
    x270 = -x269 * x6
    x271 = -x268
    x272 = x267 * x7 - x271 * x4
    x273 = -x272
    x274 = x13 * x47 - 2.0 * x2 * x21 * x24 * x264 * x28 * x29 * x36
    x275 = -x274
    x276 = x17 * x275
    x277 = x6 * (-x265 - x276)
    x278 = -x266 * x4 + x276 * x7
    x279 = -x278
    x280 = x13 * x57 - 2.0 * x2 * x21 * x24 * x264 * x28 * x29 * x46
    x281 = -x280
    x282 = x17 * x281
    x283 = -x275 * x4 + x282 * x7
    x284 = -x283
    x285 = x17 * x284
    x286 = x277 + x279 * x4 - x285 * x7
    x287 = x17 * x279
    x288 = x287 * x7
    x289 = x68 * (-x270 + x273 * x4 - x286 * x65 - x288)
    x290 = x275 * x70
    x291 = x284 * x73 + x290
    x292 = x284 * x70
    x293 = 2.0 * x292
    x294 = x6 * (-x274 - x282)
    x295 = -x13 * x80 + 2.0 * x2 * x21 * x24 * x264 * x28 * x29 * x56
    x296 = x17 * x295
    x297 = x281 * x4 - x296 * x7
    x298 = x17 * x297
    x299 = x284 * x4 + x294 - x298 * x7
    x300 = x293 + x299 * x73
    x301 = x289 + x291 * x91 + x300 * x73
    x302 = x23 * x96 + x301
    x303 = x68 * (-x272 - x279 * x65)
    x304 = x290 * x73 + x291 * x73 + x303
    x305 = x101 * x23 + x304
    x306 = x0 * x305 + x302
    x307 = x68 * (-x266 * x65 - x268)
    x308 = x206 * x275 + x307
    x309 = x106 * x23 + x308
    x310 = x269 * x6
    x311 = x68 * (
        -x109 * x286
        + x4 * (x273 * x4 - x288 + x310)
        + 2.0 * x6 * (-x272 - x287)
        - x65 * (-x109 * x299 + x286 * x4 + x53 * (-x278 - x285))
    )
    x312 = x299 * x70
    x313 = 3.0 * x312
    x314 = x6 * (-x280 - x296)
    x315 = -x115 * x13 + 2.0 * x2 * x21 * x24 * x264 * x28 * x29 * x79
    x316 = (
        -x109 * (-x109 * (-x109 * x315 + x295 * x4) + x297 * x4 + x314)
        + x299 * x4
        + x53 * (-x283 - x298)
    )
    x317 = x119 * x299 + x120 * x293
    x318 = x122 * x23 + x317
    x319 = x120 * x290
    x320 = x119 * x284 + x319
    x321 = x125 * x23 + x320
    x322 = x0 * x321 + x318
    x323 = x119 * x275
    x324 = x105 * x23
    x325 = x324 * x7
    x326 = x10 * x325 + x323
    x327 = x131 * x284 + x71
    x328 = x327 * x70
    x329 = 2.0 * x328
    x330 = x131 * x299 + x76
    x331 = x329 + x330 * x73
    x332 = x133 * x23 + x331
    x333 = x131 * x275 + x94
    x334 = x333 * x70
    x335 = x327 * x73 + x334
    x336 = x136 * x23 + x335
    x337 = x0 * x336 + x332
    x338 = x333 * x73
    x339 = x13 * x325 + x338
    x340 = x330 * x70
    x341 = x111 + x131 * x316
    x342 = x139 * x299 + x289
    x343 = x141 * x23 + x342
    x344 = x139 * x284 + x303
    x345 = x143 * x23 + x344
    x346 = x0 * x345 + x343
    x347 = x139 * x275 + x307
    x348 = x146 * x23 + x347
    x349 = x120 * x330
    x350 = x150 * x23 + x349
    x351 = x120 * x327
    x352 = x152 * x23 + x351
    x353 = x0 * x352 + x350
    x354 = x120 * x333
    x355 = x147 * x324 + x354
    x356 = x131 * x330 + x247 + x289
    x357 = x157 * x23 + x356
    x358 = x131 * x327 + x250 + x303
    x359 = x159 * x23 + x358
    x360 = x0 * x359 + x357
    x361 = x131 * x333 + x135 + x307
    x362 = x162 * x23 + x361
    x363 = x10 * x174
    x364 = x163 * x165 - x363 + x45
    x365 = x10 * x180
    x366 = x163 * x173 - x365 + x55
    x367 = x17 * x366
    x368 = x364 * x4 - x367 * x7
    x369 = x10 * x166
    x370 = x163 * x169 + x33 - x369
    x371 = x17 * x364
    x372 = -x370 * x4 + x371 * x7
    x373 = x68 * (-x368 * x65 - x372)
    x374 = x366 * x70
    x375 = -x10 * x194 + x163 * x179 + x78
    x376 = x17 * x375
    x377 = x366 * x4 - x376 * x7
    x378 = x374 + x377 * x73
    x379 = x373 + x374 * x73 + x378 * x73
    x380 = x202 * x22 + x379
    x381 = x203 * x22 + x380
    x382 = -x163 * x169 + x369 + x88
    x383 = x68 * (-x364 * x65 - x382)
    x384 = x206 * x366 + x383
    x385 = x207 * x22 + x384
    x386 = x208 * x22 + x385
    x387 = -x371 - x382
    x388 = x6 * (-x107 + x163 * x165 - x363 - x367)
    x389 = x68 * (
        -x109 * x368 - x372 * x4 + x387 * x6 - x65 * (-x109 * x377 + x368 * x4 + x388)
    )
    x390 = x377 * x70
    x391 = 2.0 * x390
    x392 = x6 * (-x113 + x163 * x173 - x365 - x376)
    x393 = x10 * x17
    x394 = x114 + x163 * x193 - x214 * x393
    x395 = -x109 * (-x109 * x394 + x375 * x4) + x377 * x4 + x392
    x396 = 2.0 * x188
    x397 = x120 * x366 + x396
    x398 = x397 * x70
    x399 = x120 * x377 + x191
    x400 = x398 + x399 * x73
    x401 = x22 * x223 + x400
    x402 = x22 * x224 + x401
    x403 = x397 * x73
    x404 = x22 * x226 + x403
    x405 = x22 * x229 + x404
    x406 = 2.0 * x211
    x407 = x120 * x395 + x406
    x408 = x131 * x374
    x409 = x130 * x377 + x408
    x410 = x22 * x235 + x409
    x411 = x22 * x236 + x410
    x412 = x130 * x366
    x413 = x22 * x238 + x412
    x414 = x22 * x239 + x413
    x415 = x120 * x399 + x217 + x373
    x416 = x22 * x242 + x415
    x417 = x22 * x243 + x416
    x418 = x120 * x397 + 2.0 * x222 + x383
    x419 = x22 * x245 + x418
    x420 = x22 * x246 + x419
    x421 = x148 * x377 + x231
    x422 = x22 * x251 + x421
    x423 = x22 * x252 + x422
    x424 = x131 * x396 + x148 * x366
    x425 = x22 * x254 + x424
    x426 = x22 * x255 + x425
    x427 = x155 * x377 + x373
    x428 = x22 * x259 + x427
    x429 = x22 * x260 + x428
    x430 = x155 * x366 + x383
    x431 = x22 * x262 + x430
    x432 = x22 * x263 + x431
    x433 = x10 * x276 - x163 * x266
    x434 = -x433
    x435 = x10 * x282 - x163 * x275
    x436 = -x435
    x437 = x17 * x436
    x438 = x4 * x434 - x437 * x7
    x439 = x10 * x267 - x163 * x271
    x440 = -x439
    x441 = x17 * x434
    x442 = -x4 * x440 + x441 * x7
    x443 = x68 * (-x438 * x65 - x442)
    x444 = x436 * x70
    x445 = -x10 * x296 + x163 * x281
    x446 = x17 * x445
    x447 = x4 * x436 - x446 * x7
    x448 = x444 + x447 * x73
    x449 = x443 + x444 * x73 + x448 * x73
    x450 = x202 * x23 + x449
    x451 = x22 * x305 + x450
    x452 = x68 * (-x434 * x65 - x439)
    x453 = x206 * x436 + x452
    x454 = x207 * x23 + x453
    x455 = x22 * x309 + x454
    x456 = -x439 - x441
    x457 = x6 * (-x433 - x437)
    x458 = x68 * (
        -x109 * x438 - x4 * x442 + x456 * x6 - x65 * (-x109 * x447 + x4 * x438 + x457)
    )
    x459 = x447 * x91
    x460 = x6 * (-x435 - x446)
    x461 = x163 * x295 - x315 * x393
    x462 = -x109 * (-x109 * x461 + x4 * x445) + x4 * x447 + x460
    x463 = x120 * x436 + x290
    x464 = x463 * x70
    x465 = x120 * x447 + x292
    x466 = x464 + x465 * x73
    x467 = x223 * x23 + x466
    x468 = x22 * x321 + x467
    x469 = x463 * x73
    x470 = x226 * x23 + x469
    x471 = x22 * x326 + x470
    x472 = x465 * x91
    x473 = x120 * x462 + x312
    x474 = x131 * x436 + x188
    x475 = x474 * x70
    x476 = x131 * x447 + x190
    x477 = x475 + x476 * x73
    x478 = x23 * x235 + x477
    x479 = x22 * x336 + x478
    x480 = x474 * x73
    x481 = x23 * x238 + x480
    x482 = x22 * x339 + x481
    x483 = x476 * x91
    x484 = x131 * x462 + x211
    x485 = x120 * x292 + x120 * x465 + x443
    x486 = x23 * x242 + x485
    x487 = x22 * x345 + x486
    x488 = x120 * x463 + x319 + x452
    x489 = x23 * x245 + x488
    x490 = x22 * x348 + x489
    x491 = x120 * x476 + x328
    x492 = x23 * x251 + x491
    x493 = x22 * x352 + x492
    x494 = x120 * x474 + x334
    x495 = x23 * x254 + x494
    x496 = x22 * x355 + x495
    x497 = x131 * x190 + x131 * x476 + x443
    x498 = x23 * x259 + x497
    x499 = x22 * x359 + x498
    x500 = x131 * x474 + x234 + x452
    x501 = x23 * x262 + x500
    x502 = x22 * x362 + x501
    x503 = x13 * x276
    x504 = x264 * x266 + x45 - x503
    x505 = x13 * x282
    x506 = x264 * x275 - x505 + x55
    x507 = x17 * x506
    x508 = x4 * x504 - x507 * x7
    x509 = x13 * x267
    x510 = x264 * x271 + x33 - x509
    x511 = x17 * x504
    x512 = -x4 * x510 + x511 * x7
    x513 = x68 * (-x508 * x65 - x512)
    x514 = x506 * x70
    x515 = -x13 * x296 + x264 * x281 + x78
    x516 = x17 * x515
    x517 = x4 * x506 - x516 * x7
    x518 = x514 + x517 * x73
    x519 = x513 + x514 * x73 + x518 * x73
    x520 = x23 * x304 + x519
    x521 = x23 * x305 + x520
    x522 = -x264 * x271 + x509 + x88
    x523 = x68 * (-x504 * x65 - x522)
    x524 = x206 * x506 + x523
    x525 = x23 * x308 + x524
    x526 = x23 * x309 + x525
    x527 = -x511 - x522
    x528 = -x527 * x6
    x529 = x6 * (-x107 + x264 * x266 - x503 - x507)
    x530 = x68 * (
        -x109 * x508 - x4 * x512 - x528 - x65 * (-x109 * x517 + x4 * x508 + x529)
    )
    x531 = x517 * x70
    x532 = 2.0 * x531
    x533 = x6 * (-x113 + x264 * x275 - x505 - x516)
    x534 = x13 * x17
    x535 = x114 + x264 * x295 - x315 * x534
    x536 = -x109 * (-x109 * x535 + x4 * x515) + x4 * x517 + x533
    x537 = x120 * x514
    x538 = x119 * x517 + x537
    x539 = x23 * x320 + x538
    x540 = x23 * x321 + x539
    x541 = x119 * x506
    x542 = x23 * x323 + x541
    x543 = x23 * x326 + x542
    x544 = x131 * x506 + 2.0 * x290
    x545 = x544 * x70
    x546 = x131 * x517 + x293
    x547 = x545 + x546 * x73
    x548 = x23 * x335 + x547
    x549 = x23 * x336 + x548
    x550 = x544 * x73
    x551 = x23 * x338 + x550
    x552 = x23 * x339 + x551
    x553 = x546 * x70
    x554 = x131 * x536 + 2.0 * x312
    x555 = x139 * x517 + x513
    x556 = x23 * x344 + x555
    x557 = x23 * x345 + x556
    x558 = x139 * x506 + x523
    x559 = x23 * x347 + x558
    x560 = x23 * x348 + x559
    x561 = x120 * x546
    x562 = x23 * x351 + x561
    x563 = x23 * x352 + x562
    x564 = x120 * x544
    x565 = x23 * x354 + x564
    x566 = x23 * x355 + x565
    x567 = x131 * x546 + x329 + x513
    x568 = x23 * x358 + x567
    x569 = x23 * x359 + x568
    x570 = x131 * x544 + 2.0 * x334 + x523
    x571 = x23 * x361 + x570
    x572 = x23 * x362 + x571
    x573 = -x10 * x367 + x163 * x364 + 2.0 * x175
    x574 = x10 * x371
    x575 = x68 * (x163 * x370 + 2.0 * x168 * x6 - x573 * x65 - x574)
    x576 = -x10 * x376 + x163 * x366 + 2.0 * x192
    x577 = x206 * x576 + x575
    x578 = x22 * x384 + x577
    x579 = x22 * x385 + x578
    x580 = x22 * x386 + x579
    x581 = x163 * x370 + 2.0 * x209 - x574
    x582 = x68 * (-x109 * x573 + x4 * x581 - x65 * (-x109 * x576 + x4 * x573))
    x583 = x576 * x70
    x584 = x163 * x375 + 2.0 * x213 - x393 * x394
    x585 = -x109 * x584 + x4 * x576
    x586 = 3.0 * x374
    x587 = x120 * x576 + x586
    x588 = x587 * x70
    x589 = x587 * x73
    x590 = x22 * x403 + x589
    x591 = x22 * x404 + x590
    x592 = x22 * x405 + x591
    x593 = 3.0 * x390
    x594 = x120 * x585 + x593
    x595 = x130 * x576
    x596 = x22 * x412 + x595
    x597 = x22 * x413 + x596
    x598 = x22 * x414 + x597
    x599 = x131 * x583
    x600 = x120 * x587 + 3.0 * x398 + x575
    x601 = x22 * x418 + x600
    x602 = x22 * x419 + x601
    x603 = x22 * x420 + x602
    x604 = x131 * x586 + x148 * x576
    x605 = x22 * x424 + x604
    x606 = x22 * x425 + x605
    x607 = x22 * x426 + x606
    x608 = x155 * x576 + x575
    x609 = x22 * x430 + x608
    x610 = x22 * x431 + x609
    x611 = x22 * x432 + x610
    x612 = -x10 * x437 + x163 * x434 + x277
    x613 = x10 * x441
    x614 = x68 * (x163 * x440 - x270 - x612 * x65 - x613)
    x615 = -x10 * x446 + x163 * x436 + x294
    x616 = x206 * x615 + x614
    x617 = x23 * x384 + x616
    x618 = x22 * x454 + x617
    x619 = x22 * x455 + x618
    x620 = x163 * x440 + x310 - x613
    x621 = x68 * (-x109 * x612 + x4 * x620 - x65 * (-x109 * x615 + x4 * x612))
    x622 = x615 * x70
    x623 = x163 * x445 + x314 - x393 * x461
    x624 = -x109 * x623 + x4 * x615
    x625 = 2.0 * x444
    x626 = x120 * x615 + x625
    x627 = x626 * x70
    x628 = x626 * x73
    x629 = x23 * x403 + x628
    x630 = x22 * x470 + x629
    x631 = x22 * x471 + x630
    x632 = x120 * x624 + x459
    x633 = x131 * x615 + x374
    x634 = x633 * x70
    x635 = x633 * x73
    x636 = x23 * x412 + x635
    x637 = x22 * x481 + x636
    x638 = x22 * x482 + x637
    x639 = x131 * x624 + x390
    x640 = x120 * x626 + 2.0 * x464 + x614
    x641 = x23 * x418 + x640
    x642 = x22 * x489 + x641
    x643 = x22 * x490 + x642
    x644 = 2.0 * x475
    x645 = x120 * x633 + x644
    x646 = x23 * x424 + x645
    x647 = x22 * x495 + x646
    x648 = x22 * x496 + x647
    x649 = x131 * x633 + x408 + x614
    x650 = x23 * x430 + x649
    x651 = x22 * x501 + x650
    x652 = x22 * x502 + x651
    x653 = -x10 * x507 + x163 * x504
    x654 = x10 * x511 - x163 * x510
    x655 = x68 * (-x65 * x653 - x654)
    x656 = -x10 * x516 + x163 * x506
    x657 = x206 * x656 + x655
    x658 = x23 * x453 + x657
    x659 = x23 * x454 + x658
    x660 = x22 * x526 + x659
    x661 = -x654
    x662 = x68 * (-x109 * x653 + x4 * x661 - x65 * (-x109 * x656 + x4 * x653))
    x663 = x656 * x70
    x664 = x163 * x515 - x393 * x535
    x665 = -x109 * x664 + x4 * x656
    x666 = x120 * x656 + x514
    x667 = x666 * x70
    x668 = x666 * x73
    x669 = x23 * x469 + x668
    x670 = x23 * x470 + x669
    x671 = x22 * x543 + x670
    x672 = x120 * x665 + x531
    x673 = x131 * x656 + x625
    x674 = x673 * x70
    x675 = x673 * x73
    x676 = x23 * x480 + x675
    x677 = x23 * x481 + x676
    x678 = x22 * x552 + x677
    x679 = x131 * x665 + x459
    x680 = x120 * x666 + x537 + x655
    x681 = x23 * x488 + x680
    x682 = x23 * x489 + x681
    x683 = x22 * x560 + x682
    x684 = x120 * x673 + x545
    x685 = x23 * x494 + x684
    x686 = x23 * x495 + x685
    x687 = x22 * x566 + x686
    x688 = x131 * x673 + x644 + x655
    x689 = x23 * x500 + x688
    x690 = x23 * x501 + x689
    x691 = x22 * x572 + x690
    x692 = -x13 * x507 + x264 * x504 + 2.0 * x277
    x693 = x13 * x511
    x694 = x68 * (x264 * x510 + 2.0 * x269 * x6 - x65 * x692 - x693)
    x695 = -x13 * x516 + x264 * x506 + 2.0 * x294
    x696 = x206 * x695 + x694
    x697 = x23 * x524 + x696
    x698 = x23 * x525 + x697
    x699 = x23 * x526 + x698
    x700 = x264 * x510 + 2.0 * x310 - x693
    x701 = x68 * (-x109 * x692 + x4 * x700 - x65 * (-x109 * x695 + x4 * x692))
    x702 = x695 * x70
    x703 = x264 * x515 + 2.0 * x314 - x534 * x535
    x704 = -x109 * x703 + x4 * x695
    x705 = x119 * x695
    x706 = x23 * x541 + x705
    x707 = x23 * x542 + x706
    x708 = x23 * x543 + x707
    x709 = x120 * x702
    x710 = x131 * x695 + 3.0 * x514
    x711 = x70 * x710
    x712 = x710 * x73
    x713 = x23 * x550 + x712
    x714 = x23 * x551 + x713
    x715 = x23 * x552 + x714
    x716 = x131 * x704 + 3.0 * x531
    x717 = x139 * x695 + x694
    x718 = x23 * x558 + x717
    x719 = x23 * x559 + x718
    x720 = x23 * x560 + x719
    x721 = x120 * x710
    x722 = x23 * x564 + x721
    x723 = x23 * x565 + x722
    x724 = x23 * x566 + x723
    x725 = x131 * x710 + 3.0 * x545 + x694
    x726 = x23 * x570 + x725
    x727 = x23 * x571 + x726
    x728 = x23 * x572 + x727
    x729 = x68 * (
        x163 * x581
        + 3.0 * x387 * x6
        - x393 * x573
        - x65 * (x163 * x573 + 3.0 * x388 - x393 * x576)
    )
    x730 = x163 * x576 + 3.0 * x392 - x393 * x584
    x731 = 4.0 * x583
    x732 = x120 * x730 + x731
    x733 = x68 * (
        x163 * x620
        - x393 * x612
        + 2.0 * x456 * x6
        - x65 * (x163 * x612 - x393 * x615 + 2.0 * x457)
    )
    x734 = x163 * x615 - x393 * x623 + 2.0 * x460
    x735 = x120 * x734 + 3.0 * x622
    x736 = x131 * x734 + x583
    x737 = x68 * (
        x163 * x661 - x393 * x653 - x528 - x65 * (x163 * x653 - x393 * x656 + x529)
    )
    x738 = x163 * x656 - x393 * x664 + x533
    x739 = x120 * x738 + 2.0 * x663
    x740 = x131 * x738 + 2.0 * x622
    x741 = x68 * (x163 * x700 - x393 * x692 - x65 * (x163 * x692 - x393 * x695))
    x742 = x163 * x695 - x393 * x703
    x743 = x120 * x742 + x702
    x744 = x131 * x742 + 3.0 * x663
    x745 = x68 * (
        x264 * x700
        + 3.0 * x527 * x6
        - x534 * x692
        - x65 * (x264 * x692 + 3.0 * x529 - x534 * x695)
    )
    x746 = x264 * x695 + 3.0 * x533 - x534 * x703
    x747 = x131 * x746 + 4.0 * x702

    # 90 item(s)
    return numpy.array(
        [
            x0 * x103
            + x0 * x87
            + x0 * x97
            + x0 * (x0 * (x0 * (x0 * x106 + x101) + x102) + x103)
            + x110
            + 4.0 * x70 * x86
            + x73 * (x112 + x116 * x73),
            x0 * x121
            + x0 * x123
            + x0 * x127
            + x0 * (x0 * (x0 * (x10 * x129 + x125) + x126) + x127)
            + x112 * x120
            + x116 * x119,
            x0 * x132
            + x0 * x134
            + x0 * x138
            + x0 * (x0 * (x0 * (x129 * x13 + x136) + x137) + x138)
            + x112 * x131
            + x116 * x130,
            x0 * x140
            + x0 * x142
            + x0 * x145
            + x0 * (x0 * (x0 * (x0 * x146 + x143) + x144) + x145)
            + x110
            + x116 * x139,
            x0 * x149
            + x0 * x151
            + x0 * x154
            + x0 * (x0 * (x0 * (x128 * x147 + x152) + x153) + x154)
            + x116 * x148,
            x0 * x156
            + x0 * x158
            + x0 * x161
            + x0 * (x0 * (x0 * (x0 * x162 + x159) + x160) + x161)
            + x110
            + x116 * x155,
            x0 * x200
            + x0 * x204
            + x0 * (x0 * (x0 * x208 + x203) + x204)
            + x198 * x75
            + x210
            + x22 * x87
            + x73 * (x212 + x215 * x73),
            x0 * x220
            + x0 * x225
            + x0 * (x0 * (x0 * x229 + x224) + x225)
            + x121 * x22
            + x218 * x75
            + x230 * x73,
            x0 * x233
            + x0 * x237
            + x0 * (x0 * (x0 * x239 + x236) + x237)
            + x130 * x215
            + x131 * x212
            + x132 * x22,
            x0 * x241
            + x0 * x244
            + x0 * (x0 * (x0 * x246 + x243) + x244)
            + x111 * x120
            + x120 * x230
            + x140 * x22
            + x210,
            x0 * x249
            + x0 * x253
            + x0 * (x0 * (x0 * x255 + x252) + x253)
            + x148 * x215
            + x149 * x22
            + x256,
            x0 * x258
            + x0 * x261
            + x0 * (x0 * (x0 * x263 + x260) + x261)
            + x155 * x215
            + x156 * x22
            + x210,
            x0 * x302
            + x0 * x306
            + x0 * (x0 * (x0 * x309 + x305) + x306)
            + x23 * x87
            + x300 * x75
            + x311
            + x73 * (x313 + x316 * x73),
            x0 * x318
            + x0 * x322
            + x0 * (x0 * (x0 * x326 + x321) + x322)
            + x119 * x316
            + x120 * x313
            + x121 * x23,
            x0 * x332
            + x0 * x337
            + x0 * (x0 * (x0 * x339 + x336) + x337)
            + x132 * x23
            + 3.0 * x340
            + x341 * x73,
            x0 * x343
            + x0 * x346
            + x0 * (x0 * (x0 * x348 + x345) + x346)
            + x139 * x316
            + x140 * x23
            + x311,
            x0 * x350
            + x0 * x353
            + x0 * (x0 * (x0 * x355 + x352) + x353)
            + x120 * x341
            + x149 * x23,
            x0 * x357
            + x0 * x360
            + x0 * (x0 * (x0 * x362 + x359) + x360)
            + x131 * x341
            + x156 * x23
            + x256
            + x311,
            x0 * x381
            + x0 * (x0 * x386 + x381)
            + x199 * x22
            + x200 * x22
            + x378 * x91
            + x389
            + x73 * (x391 + x395 * x73),
            x0 * x402
            + x0 * (x0 * x405 + x402)
            + x219 * x22
            + x22 * x220
            + x399 * x91
            + x407 * x73,
            x0 * x411
            + x0 * (x0 * x414 + x411)
            + x130 * x395
            + x131 * x391
            + x22 * x232
            + x22 * x233,
            x0 * x417
            + x0 * (x0 * x420 + x417)
            + x120 * x407
            + x218 * x91
            + x22 * x240
            + x22 * x241
            + x389,
            x0 * x423
            + x0 * (x0 * x426 + x423)
            + x131 * x406
            + x148 * x395
            + x22 * x248
            + x22 * x249,
            x0 * x429
            + x0 * (x0 * x432 + x429)
            + x155 * x395
            + x22 * x257
            + x22 * x258
            + x389,
            x0 * x451
            + x0 * (x0 * x455 + x451)
            + x199 * x23
            + x22 * x302
            + x448 * x91
            + x458
            + x73 * (x459 + x462 * x73),
            x0 * x468
            + x0 * (x0 * x471 + x468)
            + x219 * x23
            + x22 * x318
            + x472
            + x473 * x73,
            x0 * x479
            + x0 * (x0 * x482 + x479)
            + x22 * x332
            + x23 * x232
            + x483
            + x484 * x73,
            x0 * x487
            + x0 * (x0 * x490 + x487)
            + x120 * x312
            + x120 * x473
            + x22 * x343
            + x23 * x240
            + x458,
            x0 * x493
            + x0 * (x0 * x496 + x493)
            + x120 * x484
            + x22 * x350
            + x23 * x248
            + x340,
            x0 * x499
            + x0 * (x0 * x502 + x499)
            + x131 * x211
            + x131 * x484
            + x22 * x357
            + x23 * x257
            + x458,
            x0 * x521
            + x0 * (x0 * x526 + x521)
            + x23 * x301
            + x23 * x302
            + x518 * x91
            + x530
            + x73 * (x532 + x536 * x73),
            x0 * x540
            + x0 * (x0 * x543 + x540)
            + x119 * x536
            + x120 * x532
            + x23 * x317
            + x23 * x318,
            x0 * x549
            + x0 * (x0 * x552 + x549)
            + x23 * x331
            + x23 * x332
            + 2.0 * x553
            + x554 * x73,
            x0 * x557
            + x0 * (x0 * x560 + x557)
            + x139 * x536
            + x23 * x342
            + x23 * x343
            + x530,
            x0 * x563 + x0 * (x0 * x566 + x563) + x120 * x554 + x23 * x349 + x23 * x350,
            x0 * x569
            + x0 * (x0 * x572 + x569)
            + x131 * x554
            + x23 * x356
            + x23 * x357
            + 2.0 * x340
            + x530,
            x0 * x580
            + x22 * x379
            + x22 * x380
            + x22 * x381
            + x582
            + x583 * x73
            + x73 * (x583 + x585 * x73),
            x0 * x592 + x22 * x400 + x22 * x401 + x22 * x402 + x588 + x594 * x73,
            x0 * x598 + x130 * x585 + x22 * x409 + x22 * x410 + x22 * x411 + x599,
            x0 * x603
            + x120 * x594
            + x22 * x415
            + x22 * x416
            + x22 * x417
            + x399 * x75
            + x582,
            x0 * x607 + x131 * x593 + x148 * x585 + x22 * x421 + x22 * x422 + x22 * x423,
            x0 * x611 + x155 * x585 + x22 * x427 + x22 * x428 + x22 * x429 + x582,
            x0 * x619
            + x22 * x450
            + x22 * x451
            + x23 * x379
            + x621
            + x622 * x73
            + x73 * (x622 + x624 * x73),
            x0 * x631 + x22 * x467 + x22 * x468 + x23 * x400 + x627 + x632 * x73,
            x0 * x638 + x22 * x478 + x22 * x479 + x23 * x409 + x634 + x639 * x73,
            x0 * x643 + x120 * x632 + x22 * x486 + x22 * x487 + x23 * x415 + x472 + x621,
            x0 * x648 + x120 * x639 + x22 * x492 + x22 * x493 + x23 * x421 + x483,
            x0 * x652
            + x131 * x390
            + x131 * x639
            + x22 * x498
            + x22 * x499
            + x23 * x427
            + x621,
            x0 * x660
            + x22 * x521
            + x23 * x449
            + x23 * x450
            + x662
            + x663 * x73
            + x73 * (x663 + x665 * x73),
            x0 * x671 + x22 * x540 + x23 * x466 + x23 * x467 + x667 + x672 * x73,
            x0 * x678 + x22 * x549 + x23 * x477 + x23 * x478 + x674 + x679 * x73,
            x0 * x683
            + x120 * x531
            + x120 * x672
            + x22 * x557
            + x23 * x485
            + x23 * x486
            + x662,
            x0 * x687 + x120 * x679 + x22 * x563 + x23 * x491 + x23 * x492 + x553,
            x0 * x691 + x131 * x679 + x22 * x569 + x23 * x497 + x23 * x498 + x483 + x662,
            x0 * x699
            + x23 * x519
            + x23 * x520
            + x23 * x521
            + x701
            + x702 * x73
            + x73 * (x702 + x704 * x73),
            x0 * x708 + x119 * x704 + x23 * x538 + x23 * x539 + x23 * x540 + x709,
            x0 * x715 + x23 * x547 + x23 * x548 + x23 * x549 + x711 + x716 * x73,
            x0 * x720 + x139 * x704 + x23 * x555 + x23 * x556 + x23 * x557 + x701,
            x0 * x724 + x120 * x716 + x23 * x561 + x23 * x562 + x23 * x563,
            x0 * x728
            + x131 * x716
            + x23 * x567
            + x23 * x568
            + x23 * x569
            + 3.0 * x553
            + x701,
            x206 * x730 + x22 * x577 + x22 * x578 + x22 * x579 + x22 * x580 + x729,
            x22 * x589 + x22 * x590 + x22 * x591 + x22 * x592 + x73 * x732,
            x130 * x730 + x22 * x595 + x22 * x596 + x22 * x597 + x22 * x598,
            x120 * x732
            + x22 * x600
            + x22 * x601
            + x22 * x602
            + x22 * x603
            + 4.0 * x588
            + x729,
            x131 * x731 + x148 * x730 + x22 * x604 + x22 * x605 + x22 * x606 + x22 * x607,
            x155 * x730 + x22 * x608 + x22 * x609 + x22 * x610 + x22 * x611 + x729,
            x206 * x734 + x22 * x617 + x22 * x618 + x22 * x619 + x23 * x577 + x733,
            x22 * x629 + x22 * x630 + x22 * x631 + x23 * x589 + x73 * x735,
            x22 * x636 + x22 * x637 + x22 * x638 + x23 * x595 + x73 * x736,
            x120 * x735
            + x22 * x641
            + x22 * x642
            + x22 * x643
            + x23 * x600
            + 3.0 * x627
            + x733,
            x120 * x736 + x22 * x646 + x22 * x647 + x22 * x648 + x23 * x604 + 3.0 * x634,
            x131 * x736 + x22 * x650 + x22 * x651 + x22 * x652 + x23 * x608 + x599 + x733,
            x206 * x738 + x22 * x659 + x22 * x660 + x23 * x616 + x23 * x617 + x737,
            x22 * x670 + x22 * x671 + x23 * x628 + x23 * x629 + x73 * x739,
            x22 * x677 + x22 * x678 + x23 * x635 + x23 * x636 + x73 * x740,
            x120 * x739
            + x22 * x682
            + x22 * x683
            + x23 * x640
            + x23 * x641
            + 2.0 * x667
            + x737,
            x120 * x740 + x22 * x686 + x22 * x687 + x23 * x645 + x23 * x646 + 2.0 * x674,
            x131 * x740
            + x22 * x690
            + x22 * x691
            + x23 * x649
            + x23 * x650
            + 2.0 * x634
            + x737,
            x206 * x742 + x22 * x699 + x23 * x657 + x23 * x658 + x23 * x659 + x741,
            x22 * x708 + x23 * x668 + x23 * x669 + x23 * x670 + x73 * x743,
            x22 * x715 + x23 * x675 + x23 * x676 + x23 * x677 + x73 * x744,
            x120 * x743 + x22 * x720 + x23 * x680 + x23 * x681 + x23 * x682 + x709 + x741,
            x120 * x744 + x22 * x724 + x23 * x684 + x23 * x685 + x23 * x686 + x711,
            x131 * x744
            + x22 * x728
            + x23 * x688
            + x23 * x689
            + x23 * x690
            + 3.0 * x674
            + x741,
            x206 * x746 + x23 * x696 + x23 * x697 + x23 * x698 + x23 * x699 + x745,
            x119 * x746 + x23 * x705 + x23 * x706 + x23 * x707 + x23 * x708,
            x23 * x712 + x23 * x713 + x23 * x714 + x23 * x715 + x73 * x747,
            x139 * x746 + x23 * x717 + x23 * x718 + x23 * x719 + x23 * x720 + x745,
            x120 * x747 + x23 * x721 + x23 * x722 + x23 * x723 + x23 * x724,
            x131 * x747
            + x23 * x725
            + x23 * x726
            + x23 * x727
            + x23 * x728
            + 4.0 * x711
            + x745,
        ]
    )


def _3center2el3d_043(a, A, b, B, c, C):
    """Cartesian (sg|f) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = a + b
    x4 = x3 ** (-1.0)
    x5 = -x4 * (a * A[0] + b * B[0])
    x6 = -x5 - A[0]
    x7 = x1 ** (-1.0)
    x8 = -x5 - C[0]
    x9 = x8**2
    x10 = -x4 * (a * A[1] + b * B[1])
    x11 = -x10 - C[1]
    x12 = x11**2
    x13 = -x4 * (a * A[2] + b * B[2])
    x14 = -x13 - C[2]
    x15 = x14**2
    x16 = c + x3
    x17 = x16 ** (-1.0)
    x18 = c * x17
    x19 = x18 * x3 * (x12 + x15 + x9)
    x20 = boys(2, x19)
    x21 = x16 ** (-1.5)
    x22 = 17.4934183276249
    x23 = A[0] - B[0]
    x24 = A[1] - B[1]
    x25 = A[2] - B[2]
    x26 = numpy.exp(-a * b * x4 * (x23**2 + x24**2 + x25**2))
    x27 = x22 * x26
    x28 = x27 * x4
    x29 = 2.0 * x21 * x28
    x30 = x20 * x29
    x31 = x16 ** (-0.5)
    x32 = boys(1, x19)
    x33 = -2.0 * x0 * x22 * x26 * x31 * x32 * x4
    x34 = -x30 - x33
    x35 = x34 * x7
    x36 = -2.0 * x0 * x22 * x26 * x31 * x32 * x4 * x6 + x30 * x8
    x37 = -x36
    x38 = boys(3, x19)
    x39 = x29 * x38
    x40 = -2.0 * x0 * x20 * x22 * x26 * x31 * x4 * x6 + x39 * x8
    x41 = -x40
    x42 = x18 * x41
    x43 = x42 * x8
    x44 = x35 + x37 * x6 - x43
    x45 = -x36 - x42
    x46 = 2.0 * x7
    x47 = 2.0 * x0 * x20 * x22 * x26 * x31 * x4 - x39
    x48 = x47 * x7
    x49 = boys(4, x19)
    x50 = x29 * x49
    x51 = -2.0 * x0 * x22 * x26 * x31 * x38 * x4 * x6 + x50 * x8
    x52 = -x51
    x53 = x18 * x52
    x54 = x53 * x8
    x55 = x41 * x6 + x48 - x54
    x56 = x18 * x55
    x57 = x56 * x8
    x58 = x44 * x6 + x45 * x46 - x57
    x59 = x2 * x58
    x60 = 2.0 * x0 * x22 * x26 * x31 * x38 * x4 - x50
    x61 = x60 * x7
    x62 = boys(5, x19)
    x63 = x29 * x62
    x64 = -2.0 * x0 * x22 * x26 * x31 * x4 * x49 * x6 + x63 * x8
    x65 = -x64
    x66 = x18 * x65
    x67 = x66 * x8
    x68 = x52 * x6 + x61 - x67
    x69 = x18 * x68
    x70 = x46 * (-x40 - x53) + x55 * x6 - x69 * x8
    x71 = x2 * x70
    x72 = -x47 * x7
    x73 = 3.0 * x7
    x74 = x7 * (2.0 * x0 * x22 * x26 * x31 * x4 * x49 - x63)
    x75 = boys(6, x19)
    x76 = x29 * x75
    x77 = 2.0 * x0 * x22 * x26 * x31 * x4 * x6 * x62 - x76 * x8
    x78 = x18 * x77
    x79 = x6 * x65 + x74 - x78 * x8
    x80 = x18 * x79
    x81 = x46 * (-x51 - x66) + x6 * x68 - x8 * x80
    x82 = x18 * x8
    x83 = x6 * x70 + x73 * (x41 * x6 - x54 - x69 - x72) - x81 * x82
    x84 = x17 * x3
    x85 = x83 * x84
    x86 = -x34 * x7
    x87 = -x37 * x6 + x43 + x86
    x88 = -x56 - x87
    x89 = x70 * x82
    x90 = x58 * x6 + x73 * x88 - x89
    x91 = x8 * x84
    x92 = x2 * x44
    x93 = x2 * x55
    x94 = x70 * x84
    x95 = x55 * x84
    x96 = 0.5 * x0
    x97 = x96 * (-x87 - x95)
    x98 = 2.0 * x2
    x99 = x0 * x38
    x100 = x98 * x99
    x101 = x28 * x31
    x102 = x100 * x101
    x103 = x102 + x52 * x91
    x104 = x2 * x52
    x105 = 2.0 * x104
    x106 = x105 + x68 * x91
    x107 = x103 * x98 + x106 * x91 + x97
    x108 = 3.0 * x2
    x109 = x96 * (x44 * x6 + 2.0 * x45 * x7 - x57 - x94)
    x110 = x2 * x68
    x111 = 3.0 * x110
    x112 = x111 + x81 * x91
    x113 = x106 * x108 + x109 + x112 * x91
    x114 = (
        x0 * (x58 * x91 - x84 * (x8 * x94 + 3.0 * x93) + 3.0 * x92)
        + x107 * x108
        + x113 * x91
    )
    x115 = x2 * x37
    x116 = x2 * x41
    x117 = x41 * x84
    x118 = x96 * (-x117 - x36)
    x119 = x21 * x27
    x120 = x100 * x119
    x121 = x103 * x91 + x118 + x120 * x8
    x122 = (
        x0 * (2.0 * x115 + x44 * x91 - x84 * (2.0 * x116 + x8 * x95))
        + x107 * x91
        + x121 * x98
    )
    x123 = x114 + x122 * x23
    x124 = x0 * x20
    x125 = x101 * x98
    x126 = x124 * x125
    x127 = x0 * x125 * x32
    x128 = x96 * (-2.0 * x119 * x124 - x33)
    x129 = x16 ** (-2.5) * x3
    x130 = 2.0 * x27 * x99
    x131 = x130 * x9
    x132 = x128 + x129 * x131
    x133 = x0 * (x127 + x37 * x91 - x84 * (x117 * x8 + x126)) + x121 * x91 + x132 * x2
    x134 = x122 + x133 * x23
    x135 = x123 + x134 * x23
    x136 = x129 * x27
    x137 = x136 * x8
    x138 = 2.0 * x124
    x139 = x0 * (2.0 * x0 * x21 * x22 * x26 * x32 * x8 - x137 * x138) + x132 * x91
    x140 = 4.0 * x2
    x141 = x96 * (x58 * x6 + 3.0 * x7 * x88 - x85 - x89)
    x142 = x2 * x81
    x143 = 4.0 * x142
    x144 = -x60 * x7
    x145 = x7 * (2.0 * x0 * x22 * x26 * x31 * x4 * x62 - x76)
    x146 = x29 * boys(7, x19)
    x147 = (
        x6 * x81
        + x73 * (-x144 + x52 * x6 - x67 - x80)
        - x82
        * (
            x46 * (-x64 - x78)
            + x6 * x79
            - x82
            * (
                x145
                + x6 * x77
                - x82 * (2.0 * x0 * x22 * x26 * x31 * x4 * x6 * x75 - x146 * x8)
            )
        )
    )
    x148 = x3**2
    x149 = x148 / x16**2
    x150 = x11 * x149
    x151 = x0 * (x11 * x17 * x3 * x58 - x150 * x70)
    x152 = x150 * x8
    x153 = x11 * x84
    x154 = x105 * x153 + x152 * x68
    x155 = x111 * x153 + x152 * x81
    x156 = x108 * x154 + 0.5 * x151 + x155 * x91
    x157 = x0 * (x11 * x17 * x3 * x44 - x150 * x55)
    x158 = x11 * x120
    x159 = x152 * x52 + x158
    x160 = x154 * x91 + 0.5 * x157 + x159 * x98
    x161 = x156 + x160 * x23
    x162 = x0 * (x11 * x17 * x3 * x37 - x150 * x41)
    x163 = x11 * x8
    x164 = x100 * x136
    x165 = x159 * x91 + 0.5 * x162 + x163 * x164
    x166 = x160 + x165 * x23
    x167 = x161 + x166 * x23
    x168 = x136 * x138
    x169 = x0 * (2.0 * x0 * x11 * x21 * x22 * x26 * x32 - x11 * x168)
    x170 = x148 * x16 ** (-3.5)
    x171 = x131 * x170
    x172 = x11 * x171 + 0.5 * x169
    x173 = x0 * (x11 * x17 * x3 * x90 - x150 * x83)
    x174 = x14 * x149
    x175 = x0 * (x14 * x17 * x3 * x58 - x174 * x70)
    x176 = 0.5 * x175
    x177 = x174 * x8
    x178 = x14 * x84
    x179 = x105 * x178 + x177 * x68
    x180 = x111 * x178 + x177 * x81
    x181 = x108 * x179 + x176 + x180 * x91
    x182 = x0 * (x14 * x17 * x3 * x44 - x174 * x55)
    x183 = 0.5 * x182
    x184 = x120 * x14
    x185 = x177 * x52 + x184
    x186 = x179 * x91 + x183 + x185 * x98
    x187 = x181 + x186 * x23
    x188 = x0 * (x14 * x17 * x3 * x37 - x174 * x41)
    x189 = 0.5 * x188
    x190 = x100 * x137 * x14 + x185 * x91 + x189
    x191 = x186 + x190 * x23
    x192 = x187 + x191 * x23
    x193 = x0 * (2.0 * x0 * x14 * x21 * x22 * x26 * x32 - x14 * x168)
    x194 = 0.5 * x193
    x195 = x14 * x171 + x194
    x196 = x0 * (x14 * x17 * x3 * x90 - x174 * x83)
    x197 = 0.5 * x196
    x198 = x12 * x149
    x199 = x198 * x68 + x97
    x200 = x199 * x2
    x201 = x109 + x198 * x81
    x202 = 3.0 * x200 + x201 * x91
    x203 = x118 + x198 * x52
    x204 = x2 * x203
    x205 = x199 * x91 + 2.0 * x204
    x206 = x202 + x205 * x23
    x207 = x129 * x130
    x208 = x12 * x207 + x128
    x209 = x2 * x208
    x210 = x203 * x91 + x209
    x211 = x205 + x210 * x23
    x212 = x206 + x211 * x23
    x213 = x23 * x91
    x214 = x2 * x201
    x215 = x141 + x147 * x198
    x216 = x3**3 / x16**3
    x217 = x14 * x163
    x218 = x216 * x217
    x219 = x14 * x150
    x220 = x111 * x219 + x218 * x81
    x221 = x105 * x219 + x218 * x68
    x222 = x220 + x221 * x23
    x223 = x11 * x14 * x164
    x224 = x218 * x52 + x223
    x225 = x221 + x224 * x23
    x226 = x222 + x225 * x23
    x227 = x130 * x170
    x228 = x217 * x227
    x229 = x149 * x15
    x230 = x229 * x68 + x97
    x231 = x2 * x230
    x232 = x109 + x229 * x81
    x233 = 3.0 * x231 + x232 * x91
    x234 = x118 + x229 * x52
    x235 = x2 * x234
    x236 = x230 * x91 + 2.0 * x235
    x237 = x23 * x236 + x233
    x238 = x128 + x15 * x207
    x239 = x2 * x238
    x240 = x234 * x91 + x239
    x241 = x23 * x240 + x236
    x242 = x23 * x241 + x237
    x243 = x2 * x232
    x244 = x141 + x147 * x229
    x245 = x151 + x153 * x201
    x246 = x153 * x199 + x157
    x247 = x23 * x246 + x245
    x248 = x153 * x203 + x162
    x249 = x23 * x248 + x246
    x250 = x23 * x249 + x247
    x251 = x153 * x208 + x169
    x252 = x12 * x14
    x253 = x216 * x252
    x254 = x176 + x253 * x81
    x255 = x183 + x253 * x68
    x256 = x23 * x255 + x254
    x257 = x189 + x253 * x52
    x258 = x23 * x257 + x255
    x259 = x23 * x258 + x256
    x260 = x194 + x227 * x252
    x261 = x153 * x232
    x262 = x153 * x230
    x263 = x23 * x262 + x261
    x264 = x153 * x234
    x265 = x23 * x264 + x262
    x266 = x23 * x265 + x263
    x267 = x153 * x238
    x268 = x175 + x178 * x232
    x269 = x178 * x230 + x182
    x270 = x23 * x269 + x268
    x271 = x178 * x234 + x188
    x272 = x23 * x271 + x269
    x273 = x23 * x272 + x270
    x274 = x178 * x238 + x193
    x275 = -x10 - A[1]
    x276 = -2.0 * x0 * x20 * x22 * x26 * x275 * x31 * x4 + x11 * x39
    x277 = -x276
    x278 = x18 * x277
    x279 = -2.0 * x0 * x22 * x26 * x275 * x31 * x32 * x4 + x11 * x30
    x280 = -x278 - x279
    x281 = x280 * x7
    x282 = -x279
    x283 = x278 * x8 - x282 * x6
    x284 = -x283
    x285 = -2.0 * x0 * x22 * x26 * x275 * x31 * x38 * x4 + x11 * x50
    x286 = -x285
    x287 = x18 * x286
    x288 = -x277 * x6 + x287 * x8
    x289 = -x288
    x290 = x18 * x289
    x291 = x290 * x8
    x292 = x281 + x284 * x6 - x291
    x293 = x2 * x292
    x294 = x7 * (-x276 - x287)
    x295 = -2.0 * x0 * x22 * x26 * x275 * x31 * x4 * x49 + x11 * x63
    x296 = -x295
    x297 = x18 * x296
    x298 = -x286 * x6 + x297 * x8
    x299 = -x298
    x300 = x18 * x299
    x301 = x289 * x6 + x294 - x300 * x8
    x302 = x2 * x301
    x303 = x7 * (-x285 - x297)
    x304 = 2.0 * x0 * x22 * x26 * x275 * x31 * x4 * x62 - x11 * x76
    x305 = x18 * x304
    x306 = x296 * x6 - x305 * x8
    x307 = x18 * x306
    x308 = x299 * x6 + x303 - x307 * x8
    x309 = x301 * x6 - x308 * x82 + x46 * (-x288 - x300)
    x310 = x309 * x84
    x311 = -x283 - x290
    x312 = x301 * x82
    x313 = x292 * x6 + x311 * x46 - x312
    x314 = x2 * x284
    x315 = 2.0 * x314
    x316 = x2 * x289
    x317 = 2.0 * x316
    x318 = x301 * x84
    x319 = x289 * x84
    x320 = x96 * (-x283 - x319)
    x321 = x2 * x286
    x322 = x299 * x91 + x321
    x323 = x320 + x321 * x91 + x322 * x91
    x324 = x96 * (x280 * x7 + x284 * x6 - x291 - x318)
    x325 = x2 * x299
    x326 = 2.0 * x325
    x327 = x308 * x91 + x326
    x328 = x322 * x98 + x324 + x327 * x91
    x329 = x0 * (x292 * x91 + x315 - x84 * (x317 + x318 * x8)) + x323 * x98 + x328 * x91
    x330 = x122 * x24 + x329
    x331 = x2 * x282
    x332 = x2 * x277
    x333 = x277 * x84
    x334 = x96 * (-x279 - x333)
    x335 = x149 * x9
    x336 = x286 * x335 + x334
    x337 = x0 * (x284 * x91 + x331 - x84 * (x319 * x8 + x332)) + x2 * x336 + x323 * x91
    x338 = x133 * x24 + x337
    x339 = x23 * x338 + x330
    x340 = x149 * x8
    x341 = x0 * (x17 * x282 * x3 * x8 - x277 * x340) + x336 * x91
    x342 = x139 * x24 + x341
    x343 = x96 * (x292 * x6 - x310 + 2.0 * x311 * x7 - x312)
    x344 = x2 * x308
    x345 = 3.0 * x344
    x346 = x7 * (-x295 - x305)
    x347 = 2.0 * x0 * x22 * x26 * x275 * x31 * x4 * x75 - x11 * x146
    x348 = (
        x308 * x6
        + x46 * (-x298 - x307)
        - x82 * (x306 * x6 + x346 - x82 * (x304 * x6 - x347 * x82))
    )
    x349 = x0 * (x153 * x292 - x84 * (x11 * x318 + x93) + x92)
    x350 = x102 + x153 * x286
    x351 = x2 * x350
    x352 = x104 + x153 * x299
    x353 = x351 + x352 * x91
    x354 = x352 * x98
    x355 = x110 + x153 * x308
    x356 = x354 + x355 * x91
    x357 = 0.5 * x349 + x353 * x98 + x356 * x91
    x358 = x160 * x24 + x357
    x359 = x0 * (x115 + x153 * x284 - x84 * (x11 * x319 + x116))
    x360 = x351 * x91 + x353 * x91 + 0.5 * x359
    x361 = x165 * x24 + x360
    x362 = x23 * x361 + x358
    x363 = x0 * (x127 + x153 * x282 - x84 * (x11 * x333 + x126))
    x364 = x335 * x350 + 0.5 * x363
    x365 = x172 * x24 + x364
    x366 = x0 * (x153 * x313 + x59 - x84 * (x11 * x310 + x71))
    x367 = x142 + x153 * x348
    x368 = x0 * (x14 * x17 * x292 * x3 - x174 * x301)
    x369 = 0.5 * x368
    x370 = x178 * x321
    x371 = x177 * x299 + x370
    x372 = x178 * x326
    x373 = x177 * x308 + x372
    x374 = x369 + x371 * x98 + x373 * x91
    x375 = x186 * x24 + x374
    x376 = x0 * (x14 * x17 * x284 * x3 - x174 * x289)
    x377 = 0.5 * x376
    x378 = x177 * x321 + x371 * x91 + x377
    x379 = x190 * x24 + x378
    x380 = x23 * x379 + x375
    x381 = x0 * (x14 * x17 * x282 * x3 - x174 * x277)
    x382 = 0.5 * x381
    x383 = x14 * x286
    x384 = x216 * x9
    x385 = x382 + x383 * x384
    x386 = x195 * x24 + x385
    x387 = x0 * (x14 * x17 * x3 * x313 - x174 * x309)
    x388 = 0.5 * x387
    x389 = x104 * x153 + x153 * x352 + x320
    x390 = x389 * x98
    x391 = x110 * x153 + x153 * x355 + x324
    x392 = x390 + x391 * x91
    x393 = x205 * x24 + x392
    x394 = x153 * x350 + x158 + x334
    x395 = x2 * x394
    x396 = x389 * x91 + x395
    x397 = x210 * x24 + x396
    x398 = x23 * x397 + x393
    x399 = x394 * x91
    x400 = x24 * x91
    x401 = x208 * x400 + x399
    x402 = x142 * x153 + x153 * x367 + x343
    x403 = x104 * x178
    x404 = x219 * x299 + x403
    x405 = x404 * x98
    x406 = x110 * x178
    x407 = x219 * x308 + x406
    x408 = x405 + x407 * x91
    x409 = x221 * x24 + x408
    x410 = x150 * x383 + x184
    x411 = x2 * x410
    x412 = x404 * x91 + x411
    x413 = x224 * x24 + x412
    x414 = x23 * x413 + x409
    x415 = x410 * x91
    x416 = x228 * x24 + x415
    x417 = x142 * x178
    x418 = x219 * x348 + x417
    x419 = x229 * x299 + x320
    x420 = x2 * x419
    x421 = 2.0 * x420
    x422 = x229 * x308 + x324
    x423 = x421 + x422 * x91
    x424 = x236 * x24 + x423
    x425 = x229 * x286 + x334
    x426 = x2 * x425
    x427 = x419 * x91 + x426
    x428 = x24 * x240 + x427
    x429 = x23 * x428 + x424
    x430 = x425 * x91
    x431 = x238 * x400 + x430
    x432 = x2 * x422
    x433 = x229 * x348 + x343
    x434 = x153 * x391 + x200 + x349
    x435 = x24 * x246 + x434
    x436 = x153 * x389 + x204 + x359
    x437 = x24 * x248 + x436
    x438 = x23 * x437 + x435
    x439 = x153 * x394 + x209 + x363
    x440 = x24 * x251 + x439
    x441 = x110 * x219 + x153 * x407 + x369
    x442 = x24 * x255 + x441
    x443 = x104 * x219 + x153 * x404 + x377
    x444 = x24 * x257 + x443
    x445 = x23 * x444 + x442
    x446 = x153 * x410 + x223 + x382
    x447 = x24 * x260 + x446
    x448 = x153 * x422 + x231
    x449 = x24 * x262 + x448
    x450 = x153 * x419 + x235
    x451 = x24 * x264 + x450
    x452 = x23 * x451 + x449
    x453 = x153 * x425 + x239
    x454 = x24 * x267 + x453
    x455 = x178 * x422 + x368
    x456 = x24 * x269 + x455
    x457 = x178 * x419 + x376
    x458 = x24 * x271 + x457
    x459 = x23 * x458 + x456
    x460 = x178 * x425 + x381
    x461 = x24 * x274 + x460
    x462 = -x13 - A[2]
    x463 = -2.0 * x0 * x20 * x22 * x26 * x31 * x4 * x462 + x14 * x39
    x464 = -x463
    x465 = x18 * x464
    x466 = -2.0 * x0 * x22 * x26 * x31 * x32 * x4 * x462 + x14 * x30
    x467 = -x465 - x466
    x468 = x467 * x7
    x469 = -x466
    x470 = x465 * x8 - x469 * x6
    x471 = -x470
    x472 = -2.0 * x0 * x22 * x26 * x31 * x38 * x4 * x462 + x14 * x50
    x473 = -x472
    x474 = x18 * x473
    x475 = -x464 * x6 + x474 * x8
    x476 = -x475
    x477 = x18 * x476
    x478 = x477 * x8
    x479 = x468 + x471 * x6 - x478
    x480 = x2 * x479
    x481 = x7 * (-x463 - x474)
    x482 = -2.0 * x0 * x22 * x26 * x31 * x4 * x462 * x49 + x14 * x63
    x483 = -x482
    x484 = x18 * x483
    x485 = -x473 * x6 + x484 * x8
    x486 = -x485
    x487 = x18 * x486
    x488 = x476 * x6 + x481 - x487 * x8
    x489 = x2 * x488
    x490 = x7 * (-x472 - x484)
    x491 = 2.0 * x0 * x22 * x26 * x31 * x4 * x462 * x62 - x14 * x76
    x492 = x18 * x491
    x493 = x483 * x6 - x492 * x8
    x494 = x18 * x493
    x495 = x486 * x6 + x490 - x494 * x8
    x496 = x46 * (-x475 - x487) + x488 * x6 - x495 * x82
    x497 = x496 * x84
    x498 = -x470 - x477
    x499 = x488 * x82
    x500 = x46 * x498 + x479 * x6 - x499
    x501 = x2 * x471
    x502 = 2.0 * x501
    x503 = x2 * x476
    x504 = 2.0 * x503
    x505 = x488 * x84
    x506 = x476 * x84
    x507 = x96 * (-x470 - x506)
    x508 = x2 * x473
    x509 = x486 * x91 + x508
    x510 = x507 + x508 * x91 + x509 * x91
    x511 = -x467 * x7
    x512 = x96 * (x471 * x6 - x478 - x505 - x511)
    x513 = x2 * x486
    x514 = 2.0 * x513
    x515 = x495 * x91 + x514
    x516 = x509 * x98 + x512 + x515 * x91
    x517 = x0 * (x479 * x91 + x502 - x84 * (x504 + x505 * x8)) + x510 * x98 + x516 * x91
    x518 = x122 * x25 + x517
    x519 = x2 * x469
    x520 = x2 * x464
    x521 = x464 * x84
    x522 = x96 * (-x466 - x521)
    x523 = x335 * x473 + x522
    x524 = x0 * (x471 * x91 + x519 - x84 * (x506 * x8 + x520)) + x2 * x523 + x510 * x91
    x525 = x133 * x25 + x524
    x526 = x23 * x525 + x518
    x527 = x0 * (x17 * x3 * x469 * x8 - x340 * x464) + x523 * x91
    x528 = x139 * x25 + x527
    x529 = x96 * (x479 * x6 - x497 + 2.0 * x498 * x7 - x499)
    x530 = x2 * x495
    x531 = 3.0 * x530
    x532 = x7 * (-x482 - x492)
    x533 = 2.0 * x0 * x22 * x26 * x31 * x4 * x462 * x75 - x14 * x146
    x534 = (
        x46 * (-x485 - x494)
        + x495 * x6
        - x82 * (x493 * x6 + x532 - x82 * (x491 * x6 - x533 * x82))
    )
    x535 = x0 * (x11 * x17 * x3 * x479 - x150 * x488)
    x536 = x153 * x508
    x537 = x152 * x486 + x536
    x538 = x152 * x495 + x153 * x514
    x539 = 0.5 * x535 + x537 * x98 + x538 * x91
    x540 = x160 * x25 + x539
    x541 = x0 * (x11 * x17 * x3 * x471 - x150 * x476)
    x542 = x152 * x508 + x537 * x91 + 0.5 * x541
    x543 = x165 * x25 + x542
    x544 = x23 * x543 + x540
    x545 = x0 * (x11 * x17 * x3 * x469 - x150 * x464)
    x546 = x11 * x384
    x547 = x473 * x546 + 0.5 * x545
    x548 = x172 * x25 + x547
    x549 = x0 * (x11 * x17 * x3 * x500 - x150 * x496)
    x550 = x0 * (x178 * x479 - x84 * (x14 * x505 + x93) + x92)
    x551 = 0.5 * x550
    x552 = x102 + x178 * x473
    x553 = x2 * x552
    x554 = x104 + x178 * x486
    x555 = x553 + x554 * x91
    x556 = x2 * x554
    x557 = 2.0 * x556
    x558 = x110 + x178 * x495
    x559 = x557 + x558 * x91
    x560 = x551 + x555 * x98 + x559 * x91
    x561 = x186 * x25 + x560
    x562 = x0 * (x115 + x178 * x471 - x84 * (x116 + x14 * x506))
    x563 = 0.5 * x562
    x564 = x553 * x91 + x555 * x91 + x563
    x565 = x190 * x25 + x564
    x566 = x23 * x565 + x561
    x567 = x0 * (x127 + x178 * x469 - x84 * (x126 + x14 * x521))
    x568 = 0.5 * x567
    x569 = x335 * x552 + x568
    x570 = x195 * x25 + x569
    x571 = x0 * (x178 * x500 + x59 - x84 * (x14 * x497 + x71))
    x572 = 0.5 * x571
    x573 = x2 * x558
    x574 = 3.0 * x573
    x575 = x142 + x178 * x534
    x576 = x198 * x486 + x507
    x577 = x2 * x576
    x578 = x198 * x495 + x512
    x579 = 2.0 * x577 + x578 * x91
    x580 = x205 * x25 + x579
    x581 = x198 * x473 + x522
    x582 = x2 * x581
    x583 = x576 * x91 + x582
    x584 = x210 * x25 + x583
    x585 = x23 * x584 + x580
    x586 = x581 * x91
    x587 = x25 * x91
    x588 = x208 * x587 + x586
    x589 = x2 * x578
    x590 = x198 * x534 + x529
    x591 = x152 * x558 + x153 * x557
    x592 = x221 * x25 + x591
    x593 = x153 * x553
    x594 = x152 * x554 + x593
    x595 = x224 * x25 + x594
    x596 = x23 * x595 + x592
    x597 = x152 * x552
    x598 = x228 * x25 + x597
    x599 = x178 * x554 + x403 + x507
    x600 = x2 * x599
    x601 = 2.0 * x600
    x602 = x178 * x558 + x406 + x512
    x603 = x601 + x602 * x91
    x604 = x236 * x25 + x603
    x605 = x178 * x552 + x184 + x522
    x606 = x2 * x605
    x607 = x599 * x91 + x606
    x608 = x240 * x25 + x607
    x609 = x23 * x608 + x604
    x610 = x605 * x91
    x611 = x238 * x587 + x610
    x612 = x2 * x602
    x613 = x178 * x575 + x417 + x529
    x614 = x153 * x578 + x535
    x615 = x246 * x25 + x614
    x616 = x153 * x576 + x541
    x617 = x248 * x25 + x616
    x618 = x23 * x617 + x615
    x619 = x153 * x581 + x545
    x620 = x25 * x251 + x619
    x621 = x198 * x558 + x551
    x622 = x25 * x255 + x621
    x623 = x198 * x554 + x563
    x624 = x25 * x257 + x623
    x625 = x23 * x624 + x622
    x626 = x198 * x552 + x568
    x627 = x25 * x260 + x626
    x628 = x153 * x602
    x629 = x25 * x262 + x628
    x630 = x153 * x599
    x631 = x25 * x264 + x630
    x632 = x23 * x631 + x629
    x633 = x153 * x605
    x634 = x25 * x267 + x633
    x635 = x178 * x602 + x231 + x550
    x636 = x25 * x269 + x635
    x637 = x178 * x599 + x235 + x562
    x638 = x25 * x271 + x637
    x639 = x23 * x638 + x636
    x640 = x178 * x605 + x239 + x567
    x641 = x25 * x274 + x640
    x642 = x11 * x278
    x643 = x275 * x282 + x35 - x642
    x644 = x11 * x287
    x645 = x275 * x277 + x48 - x644
    x646 = x18 * x645
    x647 = -x6 * x643 + x646 * x8
    x648 = -x647
    x649 = x2 * x648
    x650 = x11 * x297
    x651 = x275 * x286 + x61 - x650
    x652 = x18 * x651
    x653 = x6 * x645 - x652 * x8
    x654 = x2 * x653
    x655 = x7 * (x275 * x277 - x644 - x652 - x72)
    x656 = -x11 * x305 + x275 * x296 + x74
    x657 = x18 * x656
    x658 = x6 * x651 - x657 * x8
    x659 = x6 * x653 + x655 - x658 * x82
    x660 = x659 * x84
    x661 = -x275 * x282 + x642 + x86
    x662 = -x646 - x661
    x663 = x662 * x7
    x664 = x653 * x82
    x665 = x6 * x648 + x663 - x664
    x666 = x2 * x643
    x667 = x2 * x645
    x668 = x653 * x84
    x669 = x645 * x84
    x670 = x96 * (-x661 - x669)
    x671 = x335 * x651 + x670
    x672 = x96 * (-x647 - x668)
    x673 = x2 * x651
    x674 = x658 * x91 + x673
    x675 = x672 + x673 * x91 + x674 * x91
    x676 = x0 * (x648 * x91 + x666 - x84 * (x667 + x668 * x8)) + x2 * x671 + x675 * x91
    x677 = x24 * x337 + x676
    x678 = x24 * x338 + x677
    x679 = x0 * (x17 * x3 * x643 * x8 - x340 * x645) + x671 * x91
    x680 = x24 * x341 + x679
    x681 = x24 * x342 + x680
    x682 = x96 * (x6 * x648 - x660 + x662 * x7 - x664)
    x683 = x2 * x658
    x684 = 2.0 * x683
    x685 = x7 * (-x144 + x275 * x286 - x650 - x657)
    x686 = x11 * x18
    x687 = x145 + x275 * x304 - x347 * x686
    x688 = x6 * x658 + x685 - x82 * (x6 * x656 - x687 * x82)
    x689 = x0 * (x153 * x648 + x315 - x84 * (x11 * x668 + x317))
    x690 = 2.0 * x321
    x691 = x153 * x651 + x690
    x692 = x2 * x691
    x693 = x153 * x658 + x326
    x694 = x692 + x693 * x91
    x695 = 0.5 * x689 + x692 * x91 + x694 * x91
    x696 = x24 * x360 + x695
    x697 = x24 * x361 + x696
    x698 = x0 * (x153 * x643 + 2.0 * x331 - x84 * (x11 * x669 + 2.0 * x332))
    x699 = x335 * x691 + 0.5 * x698
    x700 = x24 * x364 + x699
    x701 = x24 * x365 + x700
    x702 = x0 * (x153 * x665 + 2.0 * x293 - x84 * (x11 * x660 + 2.0 * x302))
    x703 = 2.0 * x344
    x704 = x153 * x688 + x703
    x705 = x0 * (x14 * x17 * x3 * x648 - x174 * x653)
    x706 = 0.5 * x705
    x707 = x178 * x673
    x708 = x177 * x658 + x707
    x709 = x177 * x673 + x706 + x708 * x91
    x710 = x24 * x378 + x709
    x711 = x24 * x379 + x710
    x712 = x0 * (x14 * x17 * x3 * x643 - x174 * x645)
    x713 = 0.5 * x712
    x714 = x14 * x384
    x715 = x651 * x714 + x713
    x716 = x24 * x385 + x715
    x717 = x24 * x386 + x716
    x718 = x0 * (x14 * x17 * x3 * x665 - x174 * x659)
    x719 = 0.5 * x718
    x720 = x153 * x691 + 2.0 * x351 + x670
    x721 = x2 * x720
    x722 = x153 * x693 + x354 + x672
    x723 = x721 + x722 * x91
    x724 = x24 * x396 + x723
    x725 = x24 * x397 + x724
    x726 = x720 * x91
    x727 = x24 * x399 + x726
    x728 = x24 * x401 + x727
    x729 = x153 * x704 + x355 * x98 + x682
    x730 = x178 * x690 + x219 * x651
    x731 = x2 * x730
    x732 = x219 * x658 + x372
    x733 = x731 + x732 * x91
    x734 = x24 * x412 + x733
    x735 = x24 * x413 + x734
    x736 = x730 * x91
    x737 = x24 * x415 + x736
    x738 = x24 * x416 + x737
    x739 = x178 * x703 + x219 * x688
    x740 = x229 * x651 + x670
    x741 = x2 * x740
    x742 = x229 * x658 + x672
    x743 = x741 + x742 * x91
    x744 = x24 * x427 + x743
    x745 = x24 * x428 + x744
    x746 = x740 * x91
    x747 = x24 * x430 + x746
    x748 = x24 * x431 + x747
    x749 = x2 * x742
    x750 = x229 * x688 + x682
    x751 = x153 * x722 + x390 + x689
    x752 = x24 * x436 + x751
    x753 = x24 * x437 + x752
    x754 = x153 * x720 + 2.0 * x395 + x698
    x755 = x24 * x439 + x754
    x756 = x24 * x440 + x755
    x757 = x153 * x732 + x405 + x706
    x758 = x24 * x443 + x757
    x759 = x24 * x444 + x758
    x760 = x153 * x730 + 2.0 * x411 + x713
    x761 = x24 * x446 + x760
    x762 = x24 * x447 + x761
    x763 = x153 * x742 + x421
    x764 = x24 * x450 + x763
    x765 = x24 * x451 + x764
    x766 = x153 * x740 + 2.0 * x426
    x767 = x24 * x453 + x766
    x768 = x24 * x454 + x767
    x769 = x178 * x742 + x705
    x770 = x24 * x457 + x769
    x771 = x24 * x458 + x770
    x772 = x178 * x740 + x712
    x773 = x24 * x460 + x772
    x774 = x24 * x461 + x773
    x775 = x11 * x465 - x275 * x469
    x776 = -x775
    x777 = x11 * x474 - x275 * x464
    x778 = -x777
    x779 = x18 * x778
    x780 = -x6 * x776 + x779 * x8
    x781 = -x780
    x782 = x781 * x98
    x783 = x11 * x484 - x275 * x473
    x784 = -x783
    x785 = x18 * x784
    x786 = x6 * x778 - x785 * x8
    x787 = x786 * x98
    x788 = x7 * (-x777 - x785)
    x789 = -x11 * x492 + x275 * x483
    x790 = x18 * x789
    x791 = x6 * x784 - x790 * x8
    x792 = x84 * (x6 * x786 + x788 - x791 * x82)
    x793 = -x775 - x779
    x794 = x7 * x793
    x795 = x786 * x82
    x796 = x6 * x781 + x794 - x795
    x797 = x2 * x776
    x798 = x2 * x778
    x799 = x786 * x84
    x800 = x778 * x84
    x801 = x96 * (-x775 - x800)
    x802 = x335 * x784 + x801
    x803 = x96 * (-x780 - x799)
    x804 = x2 * x784
    x805 = x791 * x91 + x804
    x806 = x803 + x804 * x91 + x805 * x91
    x807 = x0 * (x781 * x91 + x797 - x84 * (x798 + x799 * x8)) + x2 * x802 + x806 * x91
    x808 = x25 * x337 + x807
    x809 = x24 * x525 + x808
    x810 = x0 * (x17 * x3 * x776 * x8 - x340 * x778) + x802 * x91
    x811 = x25 * x341 + x810
    x812 = x24 * x528 + x811
    x813 = x96 * (x6 * x781 + x7 * x793 - x792 - x795)
    x814 = x791 * x98
    x815 = x7 * (-x783 - x790)
    x816 = x275 * x491 - x533 * x686
    x817 = x6 * x791 + x815 - x82 * (x6 * x789 - x816 * x82)
    x818 = x0 * (x153 * x781 + x501 - x84 * (x11 * x799 + x503))
    x819 = x153 * x784 + x508
    x820 = x2 * x819
    x821 = x153 * x791 + x513
    x822 = x820 + x821 * x91
    x823 = 0.5 * x818 + x820 * x91 + x822 * x91
    x824 = x25 * x360 + x823
    x825 = x24 * x543 + x824
    x826 = x0 * (x153 * x776 + x519 - x84 * (x11 * x800 + x520))
    x827 = x335 * x819 + 0.5 * x826
    x828 = x25 * x364 + x827
    x829 = x24 * x548 + x828
    x830 = x0 * (x153 * x796 + x480 - x84 * (x11 * x792 + x489))
    x831 = x821 * x98
    x832 = x153 * x817 + x530
    x833 = x0 * (x178 * x781 + x314 - x84 * (x14 * x799 + x316))
    x834 = 0.5 * x833
    x835 = x178 * x784 + x321
    x836 = x2 * x835
    x837 = x178 * x791 + x325
    x838 = x836 + x837 * x91
    x839 = x834 + x836 * x91 + x838 * x91
    x840 = x25 * x378 + x839
    x841 = x24 * x565 + x840
    x842 = x0 * (x178 * x776 + x331 - x84 * (x14 * x800 + x332))
    x843 = 0.5 * x842
    x844 = x335 * x835 + x843
    x845 = x25 * x385 + x844
    x846 = x24 * x570 + x845
    x847 = x0 * (x178 * x796 + x293 - x84 * (x14 * x792 + x302))
    x848 = 0.5 * x847
    x849 = x837 * x98
    x850 = x178 * x817 + x344
    x851 = x153 * x819 + x536 + x801
    x852 = x2 * x851
    x853 = x153 * x513 + x153 * x821 + x803
    x854 = x852 + x853 * x91
    x855 = x25 * x396 + x854
    x856 = x24 * x584 + x855
    x857 = x851 * x91
    x858 = x25 * x399 + x857
    x859 = x24 * x588 + x858
    x860 = x853 * x98
    x861 = x153 * x530 + x153 * x832 + x813
    x862 = x153 * x835 + x553
    x863 = x2 * x862
    x864 = x153 * x837 + x556
    x865 = x863 + x864 * x91
    x866 = x25 * x412 + x865
    x867 = x24 * x595 + x866
    x868 = x862 * x91
    x869 = x25 * x415 + x868
    x870 = x24 * x598 + x869
    x871 = x864 * x98
    x872 = x153 * x850 + x573
    x873 = x178 * x835 + x370 + x801
    x874 = x2 * x873
    x875 = x178 * x325 + x178 * x837 + x803
    x876 = x874 + x875 * x91
    x877 = x25 * x427 + x876
    x878 = x24 * x608 + x877
    x879 = x873 * x91
    x880 = x25 * x430 + x879
    x881 = x24 * x611 + x880
    x882 = x875 * x98
    x883 = x178 * x344 + x178 * x850 + x813
    x884 = x153 * x853 + x577 + x818
    x885 = x25 * x436 + x884
    x886 = x24 * x617 + x885
    x887 = x153 * x851 + x582 + x826
    x888 = x25 * x439 + x887
    x889 = x24 * x620 + x888
    x890 = x153 * x556 + x153 * x864 + x834
    x891 = x25 * x443 + x890
    x892 = x24 * x624 + x891
    x893 = x153 * x862 + x593 + x843
    x894 = x25 * x446 + x893
    x895 = x24 * x627 + x894
    x896 = x153 * x875 + x600
    x897 = x25 * x450 + x896
    x898 = x24 * x631 + x897
    x899 = x153 * x873 + x606
    x900 = x25 * x453 + x899
    x901 = x24 * x634 + x900
    x902 = x178 * x875 + x420 + x833
    x903 = x25 * x457 + x902
    x904 = x24 * x638 + x903
    x905 = x178 * x873 + x426 + x842
    x906 = x25 * x460 + x905
    x907 = x24 * x641 + x906
    x908 = x14 * x465
    x909 = x35 + x462 * x469 - x908
    x910 = x14 * x474
    x911 = x462 * x464 + x48 - x910
    x912 = x18 * x911
    x913 = -x6 * x909 + x8 * x912
    x914 = -x913
    x915 = x2 * x914
    x916 = x14 * x484
    x917 = x462 * x473 + x61 - x916
    x918 = x18 * x917
    x919 = x6 * x911 - x8 * x918
    x920 = x2 * x919
    x921 = x7 * (x462 * x464 - x72 - x910 - x918)
    x922 = -x14 * x492 + x462 * x483 + x74
    x923 = x18 * x922
    x924 = x6 * x917 - x8 * x923
    x925 = x6 * x919 - x82 * x924 + x921
    x926 = x84 * x925
    x927 = -x462 * x469 + x86 + x908
    x928 = -x912 - x927
    x929 = x7 * x928
    x930 = x82 * x919
    x931 = x6 * x914 + x929 - x930
    x932 = x2 * x909
    x933 = x2 * x911
    x934 = x84 * x919
    x935 = x84 * x911
    x936 = x96 * (-x927 - x935)
    x937 = x335 * x917 + x936
    x938 = x96 * (-x913 - x934)
    x939 = x2 * x917
    x940 = x91 * x924 + x939
    x941 = x91 * x939 + x91 * x940 + x938
    x942 = x0 * (-x84 * (x8 * x934 + x933) + x91 * x914 + x932) + x2 * x937 + x91 * x941
    x943 = x25 * x524 + x942
    x944 = x25 * x525 + x943
    x945 = x0 * (x17 * x3 * x8 * x909 - x340 * x911) + x91 * x937
    x946 = x25 * x527 + x945
    x947 = x25 * x528 + x946
    x948 = -x7 * x928
    x949 = x96 * (x6 * x914 - x926 - x930 - x948)
    x950 = x2 * x924
    x951 = 2.0 * x950
    x952 = x7 * (-x144 + x462 * x473 - x916 - x923)
    x953 = x14 * x18
    x954 = x145 + x462 * x491 - x533 * x953
    x955 = x6 * x924 - x82 * (x6 * x922 - x82 * x954) + x952
    x956 = x0 * (x11 * x17 * x3 * x914 - x150 * x919)
    x957 = x153 * x939
    x958 = x152 * x924 + x957
    x959 = x152 * x939 + x91 * x958 + 0.5 * x956
    x960 = x25 * x542 + x959
    x961 = x25 * x543 + x960
    x962 = x0 * (x11 * x17 * x3 * x909 - x150 * x911)
    x963 = x546 * x917 + 0.5 * x962
    x964 = x25 * x547 + x963
    x965 = x25 * x548 + x964
    x966 = x0 * (x11 * x17 * x3 * x931 - x150 * x925)
    x967 = x0 * (x178 * x914 + x502 - x84 * (x14 * x934 + x504))
    x968 = 0.5 * x967
    x969 = x178 * x917 + 2.0 * x508
    x970 = x2 * x969
    x971 = x178 * x924 + x514
    x972 = x91 * x971 + x970
    x973 = x91 * x970 + x91 * x972 + x968
    x974 = x25 * x564 + x973
    x975 = x25 * x565 + x974
    x976 = x0 * (x178 * x909 + 2.0 * x519 - x84 * (x14 * x935 + 2.0 * x520))
    x977 = 0.5 * x976
    x978 = x335 * x969 + x977
    x979 = x25 * x569 + x978
    x980 = x25 * x570 + x979
    x981 = x0 * (x178 * x931 + 2.0 * x480 - x84 * (x14 * x926 + 2.0 * x489))
    x982 = 0.5 * x981
    x983 = x2 * x971
    x984 = 2.0 * x983
    x985 = x178 * x955 + 2.0 * x530
    x986 = x198 * x917 + x936
    x987 = x2 * x986
    x988 = x198 * x924 + x938
    x989 = x91 * x988 + x987
    x990 = x25 * x583 + x989
    x991 = x25 * x584 + x990
    x992 = x91 * x986
    x993 = x25 * x586 + x992
    x994 = x25 * x588 + x993
    x995 = x2 * x988
    x996 = x198 * x955 + x949
    x997 = x153 * x970
    x998 = x152 * x971 + x997
    x999 = x25 * x594 + x998
    x1000 = x25 * x595 + x999
    x1001 = x152 * x969
    x1002 = x1001 + x25 * x597
    x1003 = x1002 + x25 * x598
    x1004 = x178 * x969 + 2.0 * x553 + x936
    x1005 = x1004 * x2
    x1006 = x178 * x971 + x557 + x938
    x1007 = x1005 + x1006 * x91
    x1008 = x1007 + x25 * x607
    x1009 = x1008 + x25 * x608
    x1010 = x1004 * x91
    x1011 = x1010 + x25 * x610
    x1012 = x1011 + x25 * x611
    x1013 = x1006 * x2
    x1014 = x178 * x985 + 2.0 * x573 + x949
    x1015 = x153 * x988 + x956
    x1016 = x1015 + x25 * x616
    x1017 = x1016 + x25 * x617
    x1018 = x153 * x986 + x962
    x1019 = x1018 + x25 * x619
    x1020 = x1019 + x25 * x620
    x1021 = x198 * x971 + x968
    x1022 = x1021 + x25 * x623
    x1023 = x1022 + x25 * x624
    x1024 = x198 * x969 + x977
    x1025 = x1024 + x25 * x626
    x1026 = x1025 + x25 * x627
    x1027 = x1006 * x153
    x1028 = x1027 + x25 * x630
    x1029 = x1028 + x25 * x631
    x1030 = x1004 * x153
    x1031 = x1030 + x25 * x633
    x1032 = x1031 + x25 * x634
    x1033 = x1006 * x178 + x601 + x967
    x1034 = x1033 + x25 * x637
    x1035 = x1034 + x25 * x638
    x1036 = x1004 * x178 + 2.0 * x606 + x976
    x1037 = x1036 + x25 * x640
    x1038 = x1037 + x25 * x641
    x1039 = x11 * x646
    x1040 = -x1039 + x275 * x643 + 2.0 * x281
    x1041 = x1040 * x2
    x1042 = -x11 * x652 + x275 * x645 + 2.0 * x294
    x1043 = x1042 * x2
    x1044 = -x11 * x657 + x275 * x651 + 2.0 * x303
    x1045 = x1042 * x6 - x1044 * x82
    x1046 = x1045 * x84
    x1047 = -x1040 * x6 + x1042 * x82
    x1048 = -x1047
    x1049 = x1042 * x84
    x1050 = x96 * (-x1039 - x1049 + x275 * x643 + 2.0 * x280 * x7)
    x1051 = x1044 * x335 + x1050
    x1052 = x0 * (x1040 * x17 * x3 * x8 - x1042 * x340) + x1051 * x91
    x1053 = x1052 + x24 * x679
    x1054 = x1053 + x24 * x680
    x1055 = x1054 + x24 * x681
    x1056 = x96 * (-x1046 - x1047)
    x1057 = x1044 * x2
    x1058 = x275 * x656 + 2.0 * x346 - x686 * x687
    x1059 = x1044 * x6 - x1058 * x82
    x1060 = x0 * (x1040 * x153 + 3.0 * x666 - x84 * (x1049 * x11 + 3.0 * x667))
    x1061 = 3.0 * x673
    x1062 = x1044 * x153 + x1061
    x1063 = 0.5 * x1060 + x1062 * x335
    x1064 = x1063 + x24 * x699
    x1065 = x1064 + x24 * x700
    x1066 = x1065 + x24 * x701
    x1067 = x0 * (x1048 * x153 + 3.0 * x649 - x84 * (x1046 * x11 + 3.0 * x654))
    x1068 = x1062 * x2
    x1069 = 3.0 * x683
    x1070 = x1059 * x153 + x1069
    x1071 = x0 * (x1040 * x14 * x17 * x3 - x1042 * x174)
    x1072 = 0.5 * x1071
    x1073 = x1044 * x714 + x1072
    x1074 = x1073 + x24 * x715
    x1075 = x1074 + x24 * x716
    x1076 = x1075 + x24 * x717
    x1077 = x0 * (-x1045 * x174 + x1048 * x14 * x17 * x3)
    x1078 = 0.5 * x1077
    x1079 = x1057 * x178
    x1080 = x1050 + x1062 * x153 + 3.0 * x692
    x1081 = x1080 * x2
    x1082 = x1080 * x91
    x1083 = x1082 + x24 * x726
    x1084 = x1083 + x24 * x727
    x1085 = x1084 + x24 * x728
    x1086 = x1056 + x1070 * x153 + x108 * x693
    x1087 = x1044 * x219 + x1061 * x178
    x1088 = x1087 * x2
    x1089 = x1087 * x91
    x1090 = x1089 + x24 * x736
    x1091 = x1090 + x24 * x737
    x1092 = x1091 + x24 * x738
    x1093 = x1059 * x219 + x1069 * x178
    x1094 = x1044 * x229 + x1050
    x1095 = x1094 * x2
    x1096 = x1094 * x91
    x1097 = x1096 + x24 * x746
    x1098 = x1097 + x24 * x747
    x1099 = x1098 + x24 * x748
    x1100 = x1056 + x1059 * x229
    x1101 = x1060 + x1080 * x153 + 3.0 * x721
    x1102 = x1101 + x24 * x754
    x1103 = x1102 + x24 * x755
    x1104 = x1103 + x24 * x756
    x1105 = x1072 + x1087 * x153 + 3.0 * x731
    x1106 = x1105 + x24 * x760
    x1107 = x1106 + x24 * x761
    x1108 = x1107 + x24 * x762
    x1109 = x1094 * x153 + 3.0 * x741
    x1110 = x1109 + x24 * x766
    x1111 = x1110 + x24 * x767
    x1112 = x1111 + x24 * x768
    x1113 = x1071 + x1094 * x178
    x1114 = x1113 + x24 * x772
    x1115 = x1114 + x24 * x773
    x1116 = x1115 + x24 * x774
    x1117 = x11 * x779
    x1118 = -x1117 + x275 * x776 + x468
    x1119 = x1118 * x2
    x1120 = -x11 * x785 + x275 * x778 + x481
    x1121 = x1120 * x2
    x1122 = -x11 * x790 + x275 * x784 + x490
    x1123 = x84 * (x1120 * x6 - x1122 * x82)
    x1124 = -x1118 * x6 + x1120 * x82
    x1125 = -x1124
    x1126 = x1120 * x84
    x1127 = x96 * (-x1117 - x1126 + x275 * x776 - x511)
    x1128 = x1122 * x335 + x1127
    x1129 = x0 * (x1118 * x17 * x3 * x8 - x1120 * x340) + x1128 * x91
    x1130 = x1129 + x25 * x679
    x1131 = x1130 + x24 * x811
    x1132 = x1131 + x24 * x812
    x1133 = x96 * (-x1123 - x1124)
    x1134 = x1122 * x2
    x1135 = x275 * x789 + x532 - x686 * x816
    x1136 = x1122 * x6 - x1135 * x82
    x1137 = 2.0 * x797
    x1138 = 2.0 * x798
    x1139 = x0 * (x1118 * x153 + x1137 - x84 * (x11 * x1126 + x1138))
    x1140 = 2.0 * x804
    x1141 = x1122 * x153 + x1140
    x1142 = 0.5 * x1139 + x1141 * x335
    x1143 = x1142 + x25 * x699
    x1144 = x1143 + x24 * x828
    x1145 = x1144 + x24 * x829
    x1146 = x0 * (x1125 * x153 + x782 - x84 * (x11 * x1123 + x787))
    x1147 = x1141 * x2
    x1148 = x1136 * x153 + x814
    x1149 = x0 * (x1118 * x178 + x666 - x84 * (x1126 * x14 + x667))
    x1150 = 0.5 * x1149
    x1151 = x1122 * x178 + x673
    x1152 = x1150 + x1151 * x335
    x1153 = x1152 + x25 * x715
    x1154 = x1153 + x24 * x845
    x1155 = x1154 + x24 * x846
    x1156 = x0 * (x1125 * x178 + x649 - x84 * (x1123 * x14 + x654))
    x1157 = 0.5 * x1156
    x1158 = x1151 * x2
    x1159 = x1136 * x178 + x683
    x1160 = x1127 + x1141 * x153 + 2.0 * x820
    x1161 = x1160 * x2
    x1162 = x1160 * x91
    x1163 = x1162 + x25 * x726
    x1164 = x1163 + x24 * x858
    x1165 = x1164 + x24 * x859
    x1166 = x1133 + x1148 * x153 + x831
    x1167 = 2.0 * x836
    x1168 = x1151 * x153 + x1167
    x1169 = x1168 * x2
    x1170 = x1168 * x91
    x1171 = x1170 + x25 * x736
    x1172 = x1171 + x24 * x869
    x1173 = x1172 + x24 * x870
    x1174 = x1159 * x153 + x849
    x1175 = x1127 + x1151 * x178 + x707
    x1176 = x1175 * x2
    x1177 = x1175 * x91
    x1178 = x1177 + x25 * x746
    x1179 = x1178 + x24 * x880
    x1180 = x1179 + x24 * x881
    x1181 = x1133 + x1159 * x178 + x178 * x683
    x1182 = x1139 + x1160 * x153 + 2.0 * x852
    x1183 = x1182 + x25 * x754
    x1184 = x1183 + x24 * x888
    x1185 = x1184 + x24 * x889
    x1186 = x1150 + x1168 * x153 + 2.0 * x863
    x1187 = x1186 + x25 * x760
    x1188 = x1187 + x24 * x894
    x1189 = x1188 + x24 * x895
    x1190 = 2.0 * x874
    x1191 = x1175 * x153 + x1190
    x1192 = x1191 + x25 * x766
    x1193 = x1192 + x24 * x900
    x1194 = x1193 + x24 * x901
    x1195 = x1149 + x1175 * x178 + x741
    x1196 = x1195 + x25 * x772
    x1197 = x1196 + x24 * x906
    x1198 = x1197 + x24 * x907
    x1199 = x11 * x912 - x275 * x909
    x1200 = -x1199
    x1201 = x1200 * x2
    x1202 = -x11 * x918 + x275 * x911
    x1203 = x1202 * x2
    x1204 = -x11 * x923 + x275 * x917
    x1205 = x84 * (x1202 * x6 - x1204 * x82)
    x1206 = -x1200 * x6 + x1202 * x82
    x1207 = -x1206
    x1208 = x1202 * x84
    x1209 = x96 * (-x1199 - x1208)
    x1210 = x1204 * x335 + x1209
    x1211 = x0 * (x1200 * x17 * x3 * x8 - x1202 * x340) + x1210 * x91
    x1212 = x1211 + x25 * x810
    x1213 = x1212 + x25 * x811
    x1214 = x1213 + x24 * x947
    x1215 = x96 * (-x1205 - x1206)
    x1216 = x1204 * x2
    x1217 = x275 * x922 - x686 * x954
    x1218 = x1204 * x6 - x1217 * x82
    x1219 = x0 * (x1200 * x153 - x84 * (x11 * x1208 + x933) + x932)
    x1220 = x1204 * x153 + x939
    x1221 = 0.5 * x1219 + x1220 * x335
    x1222 = x1221 + x25 * x827
    x1223 = x1222 + x25 * x828
    x1224 = x1223 + x24 * x965
    x1225 = x0 * (x1207 * x153 - x84 * (x11 * x1205 + x920) + x915)
    x1226 = x1220 * x2
    x1227 = x1218 * x153 + x950
    x1228 = x0 * (x1137 + x1200 * x178 - x84 * (x1138 + x1208 * x14))
    x1229 = 0.5 * x1228
    x1230 = x1140 + x1204 * x178
    x1231 = x1229 + x1230 * x335
    x1232 = x1231 + x25 * x844
    x1233 = x1232 + x25 * x845
    x1234 = x1233 + x24 * x980
    x1235 = x0 * (x1207 * x178 + x782 - x84 * (x1205 * x14 + x787))
    x1236 = 0.5 * x1235
    x1237 = x1230 * x2
    x1238 = x1218 * x178 + x814
    x1239 = x1209 + x1220 * x153 + x957
    x1240 = x1239 * x2
    x1241 = x1239 * x91
    x1242 = x1241 + x25 * x857
    x1243 = x1242 + x25 * x858
    x1244 = x1243 + x24 * x994
    x1245 = x1215 + x1227 * x153 + x153 * x950
    x1246 = x1230 * x153 + x970
    x1247 = x1246 * x2
    x1248 = x1246 * x91
    x1249 = x1248 + x25 * x868
    x1250 = x1249 + x25 * x869
    x1251 = x1003 * x24 + x1250
    x1252 = x1238 * x153 + x983
    x1253 = x1167 + x1209 + x1230 * x178
    x1254 = x1253 * x2
    x1255 = x1253 * x91
    x1256 = x1255 + x25 * x879
    x1257 = x1256 + x25 * x880
    x1258 = x1012 * x24 + x1257
    x1259 = x1215 + x1238 * x178 + x849
    x1260 = x1219 + x1239 * x153 + x987
    x1261 = x1260 + x25 * x887
    x1262 = x1261 + x25 * x888
    x1263 = x1020 * x24 + x1262
    x1264 = x1229 + x1246 * x153 + x997
    x1265 = x1264 + x25 * x893
    x1266 = x1265 + x25 * x894
    x1267 = x1026 * x24 + x1266
    x1268 = x1005 + x1253 * x153
    x1269 = x1268 + x25 * x899
    x1270 = x1269 + x25 * x900
    x1271 = x1032 * x24 + x1270
    x1272 = x1190 + x1228 + x1253 * x178
    x1273 = x1272 + x25 * x905
    x1274 = x1273 + x25 * x906
    x1275 = x1038 * x24 + x1274
    x1276 = x14 * x912
    x1277 = -x1276 + x462 * x909 + 2.0 * x468
    x1278 = x1277 * x2
    x1279 = -x14 * x918 + x462 * x911 + 2.0 * x481
    x1280 = x1279 * x2
    x1281 = -x14 * x923 + x462 * x917 + 2.0 * x490
    x1282 = x1279 * x6 - x1281 * x82
    x1283 = x1282 * x84
    x1284 = -x1277 * x6 + x1279 * x82
    x1285 = -x1284
    x1286 = x1279 * x84
    x1287 = x96 * (-x1276 - x1286 + x462 * x909 + 2.0 * x467 * x7)
    x1288 = x1281 * x335 + x1287
    x1289 = x0 * (x1277 * x17 * x3 * x8 - x1279 * x340) + x1288 * x91
    x1290 = x1289 + x25 * x945
    x1291 = x1290 + x25 * x946
    x1292 = x1291 + x25 * x947
    x1293 = x96 * (-x1283 - x1284)
    x1294 = x1281 * x2
    x1295 = x462 * x922 + 2.0 * x532 - x953 * x954
    x1296 = x1281 * x6 - x1295 * x82
    x1297 = x0 * (x11 * x1277 * x17 * x3 - x1279 * x150)
    x1298 = x1281 * x546 + 0.5 * x1297
    x1299 = x1298 + x25 * x963
    x1300 = x1299 + x25 * x964
    x1301 = x1300 + x25 * x965
    x1302 = x0 * (x11 * x1285 * x17 * x3 - x1282 * x150)
    x1303 = x1294 * x153
    x1304 = x0 * (x1277 * x178 - x84 * (x1286 * x14 + 3.0 * x933) + 3.0 * x932)
    x1305 = 0.5 * x1304
    x1306 = x1281 * x178 + 3.0 * x939
    x1307 = x1305 + x1306 * x335
    x1308 = x1307 + x25 * x978
    x1309 = x1308 + x25 * x979
    x1310 = x1309 + x25 * x980
    x1311 = x0 * (x1285 * x178 - x84 * (x1283 * x14 + 3.0 * x920) + 3.0 * x915)
    x1312 = 0.5 * x1311
    x1313 = x1306 * x2
    x1314 = x1296 * x178 + 3.0 * x950
    x1315 = x1281 * x198 + x1287
    x1316 = x1315 * x2
    x1317 = x1315 * x91
    x1318 = x1317 + x25 * x992
    x1319 = x1318 + x25 * x993
    x1320 = x1319 + x25 * x994
    x1321 = x1293 + x1296 * x198
    x1322 = x1306 * x152
    x1323 = x1001 * x25 + x1322
    x1324 = x1002 * x25 + x1323
    x1325 = x1003 * x25 + x1324
    x1326 = x1313 * x153
    x1327 = x1287 + x1306 * x178 + 3.0 * x970
    x1328 = x1327 * x2
    x1329 = x1327 * x91
    x1330 = x1010 * x25 + x1329
    x1331 = x1011 * x25 + x1330
    x1332 = x1012 * x25 + x1331
    x1333 = x1293 + x1314 * x178 + 3.0 * x983
    x1334 = x1297 + x1315 * x153
    x1335 = x1018 * x25 + x1334
    x1336 = x1019 * x25 + x1335
    x1337 = x1020 * x25 + x1336
    x1338 = x1305 + x1306 * x198
    x1339 = x1024 * x25 + x1338
    x1340 = x1025 * x25 + x1339
    x1341 = x1026 * x25 + x1340
    x1342 = x1327 * x153
    x1343 = x1030 * x25 + x1342
    x1344 = x1031 * x25 + x1343
    x1345 = x1032 * x25 + x1344
    x1346 = 3.0 * x1005 + x1304 + x1327 * x178
    x1347 = x1036 * x25 + x1346
    x1348 = x1037 * x25 + x1347
    x1349 = x1038 * x25 + x1348
    x1350 = x1042 * x275 - x1044 * x686 + 3.0 * x655
    x1351 = x1042 * x686
    x1352 = x1040 * x275 - x1351 + 3.0 * x663
    x1353 = x1350 * x84
    x1354 = x96 * (x1040 * x275 - x1351 - x1353 + 3.0 * x662 * x7)
    x1355 = x1044 * x275 - x1058 * x686 + 3.0 * x685
    x1356 = x0 * (4.0 * x1041 + x1352 * x153 - x84 * (4.0 * x1043 + x11 * x1353))
    x1357 = 4.0 * x1057
    x1358 = x1355 * x153 + x1357
    x1359 = x0 * (-x1350 * x174 + x1352 * x14 * x17 * x3)
    x1360 = 0.5 * x1359
    x1361 = 4.0 * x1068 + x1354 + x1358 * x153
    x1362 = x1355 * x219 + x1357 * x178
    x1363 = x1354 + x1355 * x229
    x1364 = x1120 * x275 - x1122 * x686 + 2.0 * x788
    x1365 = x1120 * x686
    x1366 = x1118 * x275 - x1365 + 2.0 * x794
    x1367 = x1364 * x84
    x1368 = x96 * (x1118 * x275 - x1365 - x1367 + 2.0 * x7 * x793)
    x1369 = x1122 * x275 - x1135 * x686 + 2.0 * x815
    x1370 = x0 * (3.0 * x1119 + x1366 * x153 - x84 * (x11 * x1367 + 3.0 * x1121))
    x1371 = 3.0 * x1134 + x1369 * x153
    x1372 = x0 * (x1041 + x1366 * x178 - x84 * (x1043 + x1367 * x14))
    x1373 = 0.5 * x1372
    x1374 = x1057 + x1369 * x178
    x1375 = 3.0 * x1147 + x1368 + x1371 * x153
    x1376 = 3.0 * x1158 + x1374 * x153
    x1377 = x1079 + x1368 + x1374 * x178
    x1378 = x1202 * x275 - x1204 * x686 + x921
    x1379 = x1202 * x686
    x1380 = x1200 * x275 - x1379 + x929
    x1381 = x1378 * x84
    x1382 = x96 * (x1200 * x275 - x1379 - x1381 - x948)
    x1383 = x1204 * x275 - x1217 * x686 + x952
    x1384 = x0 * (2.0 * x1201 + x1380 * x153 - x84 * (x11 * x1381 + 2.0 * x1203))
    x1385 = 2.0 * x1216 + x1383 * x153
    x1386 = x0 * (2.0 * x1119 + x1380 * x178 - x84 * (2.0 * x1121 + x1381 * x14))
    x1387 = 0.5 * x1386
    x1388 = 2.0 * x1134 + x1383 * x178
    x1389 = 2.0 * x1226 + x1382 + x1385 * x153
    x1390 = 2.0 * x1237 + x1388 * x153
    x1391 = 2.0 * x1158 + x1382 + x1388 * x178
    x1392 = x1279 * x275 - x1281 * x686
    x1393 = -x1277 * x275 + x1279 * x686
    x1394 = -x1393
    x1395 = x1392 * x84
    x1396 = x96 * (-x1393 - x1395)
    x1397 = x1281 * x275 - x1295 * x686
    x1398 = x0 * (x1278 + x1394 * x153 - x84 * (x11 * x1395 + x1280))
    x1399 = x1294 + x1397 * x153
    x1400 = x0 * (3.0 * x1201 + x1394 * x178 - x84 * (3.0 * x1203 + x1395 * x14))
    x1401 = 0.5 * x1400
    x1402 = 3.0 * x1216 + x1397 * x178
    x1403 = x1303 + x1396 + x1399 * x153
    x1404 = x1313 + x1402 * x153
    x1405 = 3.0 * x1237 + x1396 + x1402 * x178
    x1406 = x1279 * x462 - x1281 * x953 + 3.0 * x921
    x1407 = x1279 * x953
    x1408 = x1277 * x462 - x1407 + 3.0 * x929
    x1409 = x1406 * x84
    x1410 = x96 * (x1277 * x462 - x1407 - x1409 + 3.0 * x7 * x928)
    x1411 = x1281 * x462 - x1295 * x953 + 3.0 * x952
    x1412 = x0 * (x11 * x1408 * x17 * x3 - x1406 * x150)
    x1413 = x0 * (4.0 * x1278 + x1408 * x178 - x84 * (4.0 * x1280 + x14 * x1409))
    x1414 = 0.5 * x1413
    x1415 = 4.0 * x1294 + x1411 * x178
    x1416 = x1410 + x1411 * x198
    x1417 = 4.0 * x1313 + x1410 + x1415 * x178

    # 150 item(s)
    return numpy.array(
        [
            x0 * (4.0 * x59 - x84 * (4.0 * x71 + x8 * x85) + x90 * x91)
            + x113 * x140
            + x114 * x23
            + x123 * x23
            + x135 * x23
            + x23 * (x135 + x23 * (x134 + x23 * (x133 + x139 * x23)))
            + x91 * (x112 * x140 + x141 + x91 * (x143 + x147 * x91)),
            x140 * x155
            + x156 * x23
            + x161 * x23
            + x167 * x23
            + 0.5 * x173
            + x23 * (x167 + x23 * (x166 + x23 * (x165 + x172 * x23)))
            + x91 * (x143 * x153 + x147 * x152),
            x140 * x180
            + x181 * x23
            + x187 * x23
            + x192 * x23
            + x197
            + x23 * (x192 + x23 * (x191 + x23 * (x190 + x195 * x23)))
            + x91 * (x143 * x178 + x147 * x177),
            x202 * x23
            + x206 * x23
            + x212 * x23
            + 4.0 * x214
            + x215 * x91
            + x23 * (x212 + x23 * (x211 + x23 * (x208 * x213 + x210))),
            x143 * x219
            + x147 * x218
            + x220 * x23
            + x222 * x23
            + x226 * x23
            + x23 * (x226 + x23 * (x225 + x23 * (x224 + x228 * x23))),
            x23 * x233
            + x23 * x237
            + x23 * x242
            + x23 * (x23 * (x23 * (x213 * x238 + x240) + x241) + x242)
            + 4.0 * x243
            + x244 * x91,
            x153 * x215
            + x173
            + x23 * x245
            + x23 * x247
            + x23 * x250
            + x23 * (x23 * (x23 * (x23 * x251 + x248) + x249) + x250),
            x147 * x253
            + x197
            + x23 * x254
            + x23 * x256
            + x23 * x259
            + x23 * (x23 * (x23 * (x23 * x260 + x257) + x258) + x259),
            x153 * x244
            + x23 * x261
            + x23 * x263
            + x23 * x266
            + x23 * (x23 * (x23 * (x23 * x267 + x264) + x265) + x266),
            x178 * x244
            + x196
            + x23 * x268
            + x23 * x270
            + x23 * x273
            + x23 * (x23 * (x23 * (x23 * x274 + x271) + x272) + x273),
            x0 * (3.0 * x293 + x313 * x91 - x84 * (3.0 * x302 + x310 * x8))
            + x108 * x328
            + x114 * x24
            + x23 * x330
            + x23 * x339
            + x23 * (x23 * (x23 * x342 + x338) + x339)
            + x91 * (x108 * x327 + x343 + x91 * (x345 + x348 * x91)),
            x108 * x356
            + x156 * x24
            + x23 * x358
            + x23 * x362
            + x23 * (x23 * (x23 * x365 + x361) + x362)
            + 0.5 * x366
            + x91 * (x108 * x355 + x367 * x91),
            x108 * x373
            + x181 * x24
            + x23 * x375
            + x23 * x380
            + x23 * (x23 * (x23 * x386 + x379) + x380)
            + x388
            + x91 * (x177 * x348 + x178 * x345),
            x108 * x391
            + x202 * x24
            + x23 * x393
            + x23 * x398
            + x23 * (x23 * (x23 * x401 + x397) + x398)
            + x402 * x91,
            x108 * x407
            + x220 * x24
            + x23 * x409
            + x23 * x414
            + x23 * (x23 * (x23 * x416 + x413) + x414)
            + x418 * x91,
            x23 * x424
            + x23 * x429
            + x23 * (x23 * (x23 * x431 + x428) + x429)
            + x233 * x24
            + 3.0 * x432
            + x433 * x91,
            x153 * x402
            + x214
            + x23 * x435
            + x23 * x438
            + x23 * (x23 * (x23 * x440 + x437) + x438)
            + x24 * x245
            + x366,
            x142 * x219
            + x153 * x418
            + x23 * x442
            + x23 * x445
            + x23 * (x23 * (x23 * x447 + x444) + x445)
            + x24 * x254
            + x388,
            x153 * x433
            + x23 * x449
            + x23 * x452
            + x23 * (x23 * (x23 * x454 + x451) + x452)
            + x24 * x261
            + x243,
            x178 * x433
            + x23 * x456
            + x23 * x459
            + x23 * (x23 * (x23 * x461 + x458) + x459)
            + x24 * x268
            + x387,
            x0 * (3.0 * x480 + x500 * x91 - x84 * (3.0 * x489 + x497 * x8))
            + x108 * x516
            + x114 * x25
            + x23 * x518
            + x23 * x526
            + x23 * (x23 * (x23 * x528 + x525) + x526)
            + x91 * (x108 * x515 + x529 + x91 * (x531 + x534 * x91)),
            x108 * x538
            + x156 * x25
            + x23 * x540
            + x23 * x544
            + x23 * (x23 * (x23 * x548 + x543) + x544)
            + 0.5 * x549
            + x91 * (x152 * x534 + x153 * x531),
            x108 * x559
            + x181 * x25
            + x23 * x561
            + x23 * x566
            + x23 * (x23 * (x23 * x570 + x565) + x566)
            + x572
            + x91 * (x574 + x575 * x91),
            x202 * x25
            + x23 * x580
            + x23 * x585
            + x23 * (x23 * (x23 * x588 + x584) + x585)
            + 3.0 * x589
            + x590 * x91,
            x152 * x575
            + x153 * x574
            + x220 * x25
            + x23 * x592
            + x23 * x596
            + x23 * (x23 * (x23 * x598 + x595) + x596),
            x23 * x604
            + x23 * x609
            + x23 * (x23 * (x23 * x611 + x608) + x609)
            + x233 * x25
            + 3.0 * x612
            + x613 * x91,
            x153 * x590
            + x23 * x615
            + x23 * x618
            + x23 * (x23 * (x23 * x620 + x617) + x618)
            + x245 * x25
            + x549,
            x198 * x575
            + x23 * x622
            + x23 * x625
            + x23 * (x23 * (x23 * x627 + x624) + x625)
            + x25 * x254
            + x572,
            x153 * x613
            + x23 * x629
            + x23 * x632
            + x23 * (x23 * (x23 * x634 + x631) + x632)
            + x25 * x261,
            x178 * x613
            + x23 * x636
            + x23 * x639
            + x23 * (x23 * (x23 * x641 + x638) + x639)
            + x243
            + x25 * x268
            + x571,
            x0 * (2.0 * x649 + x665 * x91 - x84 * (2.0 * x654 + x660 * x8))
            + x23 * x678
            + x23 * (x23 * x681 + x678)
            + x24 * x329
            + x24 * x330
            + x675 * x98
            + x91 * (x674 * x98 + x682 + x91 * (x684 + x688 * x91)),
            x23 * x697
            + x23 * (x23 * x701 + x697)
            + x24 * x357
            + x24 * x358
            + x694 * x98
            + 0.5 * x702
            + x91 * (x693 * x98 + x704 * x91),
            x23 * x711
            + x23 * (x23 * x717 + x711)
            + x24 * x374
            + x24 * x375
            + x708 * x98
            + x719
            + x91 * (x177 * x688 + x178 * x684),
            x23 * x725
            + x23 * (x23 * x728 + x725)
            + x24 * x392
            + x24 * x393
            + x722 * x98
            + x729 * x91,
            x23 * x735
            + x23 * (x23 * x738 + x735)
            + x24 * x408
            + x24 * x409
            + x732 * x98
            + x739 * x91,
            x23 * x745
            + x23 * (x23 * x748 + x745)
            + x24 * x423
            + x24 * x424
            + 2.0 * x749
            + x750 * x91,
            x153 * x729
            + x23 * x753
            + x23 * (x23 * x756 + x753)
            + x24 * x434
            + x24 * x435
            + x391 * x98
            + x702,
            x153 * x739
            + x23 * x759
            + x23 * (x23 * x762 + x759)
            + x24 * x441
            + x24 * x442
            + x407 * x98
            + x719,
            x153 * x750
            + x23 * x765
            + x23 * (x23 * x768 + x765)
            + x24 * x448
            + x24 * x449
            + 2.0 * x432,
            x178 * x750
            + x23 * x771
            + x23 * (x23 * x774 + x771)
            + x24 * x455
            + x24 * x456
            + x718,
            x0 * (x782 + x796 * x91 - x84 * (x787 + x792 * x8))
            + x23 * x809
            + x23 * (x23 * x812 + x809)
            + x24 * x518
            + x25 * x329
            + x806 * x98
            + x91 * (x805 * x98 + x813 + x91 * (x814 + x817 * x91)),
            x23 * x825
            + x23 * (x23 * x829 + x825)
            + x24 * x540
            + x25 * x357
            + x822 * x98
            + 0.5 * x830
            + x91 * (x831 + x832 * x91),
            x23 * x841
            + x23 * (x23 * x846 + x841)
            + x24 * x561
            + x25 * x374
            + x838 * x98
            + x848
            + x91 * (x849 + x850 * x91),
            x23 * x856
            + x23 * (x23 * x859 + x856)
            + x24 * x580
            + x25 * x392
            + x860
            + x861 * x91,
            x23 * x867
            + x23 * (x23 * x870 + x867)
            + x24 * x592
            + x25 * x408
            + x871
            + x872 * x91,
            x23 * x878
            + x23 * (x23 * x881 + x878)
            + x24 * x604
            + x25 * x423
            + x882
            + x883 * x91,
            x153 * x861
            + x23 * x886
            + x23 * (x23 * x889 + x886)
            + x24 * x615
            + x25 * x434
            + x589
            + x830,
            x153 * x573
            + x153 * x872
            + x23 * x892
            + x23 * (x23 * x895 + x892)
            + x24 * x622
            + x25 * x441
            + x848,
            x153 * x883
            + x23 * x898
            + x23 * (x23 * x901 + x898)
            + x24 * x629
            + x25 * x448
            + x612,
            x178 * x883
            + x23 * x904
            + x23 * (x23 * x907 + x904)
            + x24 * x636
            + x25 * x455
            + x432
            + x847,
            x0 * (-x84 * (x8 * x926 + 2.0 * x920) + x91 * x931 + 2.0 * x915)
            + x23 * x944
            + x23 * (x23 * x947 + x944)
            + x25 * x517
            + x25 * x518
            + x91 * (x91 * (x91 * x955 + x951) + x940 * x98 + x949)
            + x941 * x98,
            x23 * x961
            + x23 * (x23 * x965 + x961)
            + x25 * x539
            + x25 * x540
            + x91 * (x152 * x955 + x153 * x951)
            + x958 * x98
            + 0.5 * x966,
            x23 * x975
            + x23 * (x23 * x980 + x975)
            + x25 * x560
            + x25 * x561
            + x91 * (x91 * x985 + x984)
            + x972 * x98
            + x982,
            x23 * x991
            + x23 * (x23 * x994 + x991)
            + x25 * x579
            + x25 * x580
            + x91 * x996
            + 2.0 * x995,
            x1000 * x23
            + x152 * x985
            + x153 * x984
            + x23 * (x1000 + x1003 * x23)
            + x25 * x591
            + x25 * x592,
            x1009 * x23
            + 2.0 * x1013
            + x1014 * x91
            + x23 * (x1009 + x1012 * x23)
            + x25 * x603
            + x25 * x604,
            x1017 * x23
            + x153 * x996
            + x23 * (x1017 + x1020 * x23)
            + x25 * x614
            + x25 * x615
            + x966,
            x1023 * x23
            + x198 * x985
            + x23 * (x1023 + x1026 * x23)
            + x25 * x621
            + x25 * x622
            + x982,
            x1014 * x153
            + x1029 * x23
            + x23 * (x1029 + x1032 * x23)
            + x25 * x628
            + x25 * x629,
            x1014 * x178
            + x1035 * x23
            + x23 * (x1035 + x1038 * x23)
            + x25 * x635
            + x25 * x636
            + 2.0 * x612
            + x981,
            x0 * (x1041 + x1048 * x91 - x84 * (x1043 + x1046 * x8))
            + x1051 * x2
            + x1055 * x23
            + x24 * x676
            + x24 * x677
            + x24 * x678
            + x91 * (x1056 + x1057 * x91 + x91 * (x1057 + x1059 * x91)),
            x1066 * x23
            + 0.5 * x1067
            + x1068 * x91
            + x24 * x695
            + x24 * x696
            + x24 * x697
            + x91 * (x1068 + x1070 * x91),
            x1057 * x177
            + x1076 * x23
            + x1078
            + x24 * x709
            + x24 * x710
            + x24 * x711
            + x91 * (x1059 * x177 + x1079),
            x1081 + x1085 * x23 + x1086 * x91 + x24 * x723 + x24 * x724 + x24 * x725,
            x1088 + x1092 * x23 + x1093 * x91 + x24 * x733 + x24 * x734 + x24 * x735,
            x1095 + x1099 * x23 + x1100 * x91 + x24 * x743 + x24 * x744 + x24 * x745,
            x1067
            + x108 * x722
            + x1086 * x153
            + x1104 * x23
            + x24 * x751
            + x24 * x752
            + x24 * x753,
            x1078
            + x108 * x732
            + x1093 * x153
            + x1108 * x23
            + x24 * x757
            + x24 * x758
            + x24 * x759,
            x1100 * x153
            + x1112 * x23
            + x24 * x763
            + x24 * x764
            + x24 * x765
            + 3.0 * x749,
            x1077 + x1100 * x178 + x1116 * x23 + x24 * x769 + x24 * x770 + x24 * x771,
            x0 * (x1119 + x1125 * x91 - x84 * (x1121 + x1123 * x8))
            + x1128 * x2
            + x1132 * x23
            + x24 * x808
            + x24 * x809
            + x25 * x676
            + x91 * (x1133 + x1134 * x91 + x91 * (x1134 + x1136 * x91)),
            x1145 * x23
            + 0.5 * x1146
            + x1147 * x91
            + x24 * x824
            + x24 * x825
            + x25 * x695
            + x91 * (x1147 + x1148 * x91),
            x1155 * x23
            + x1157
            + x1158 * x91
            + x24 * x840
            + x24 * x841
            + x25 * x709
            + x91 * (x1158 + x1159 * x91),
            x1161 + x1165 * x23 + x1166 * x91 + x24 * x855 + x24 * x856 + x25 * x723,
            x1169 + x1173 * x23 + x1174 * x91 + x24 * x866 + x24 * x867 + x25 * x733,
            x1176 + x1180 * x23 + x1181 * x91 + x24 * x877 + x24 * x878 + x25 * x743,
            x1146
            + x1166 * x153
            + x1185 * x23
            + x24 * x885
            + x24 * x886
            + x25 * x751
            + x860,
            x1157
            + x1174 * x153
            + x1189 * x23
            + x24 * x891
            + x24 * x892
            + x25 * x757
            + x871,
            x1181 * x153 + x1194 * x23 + x24 * x897 + x24 * x898 + x25 * x763 + x882,
            x1156
            + x1181 * x178
            + x1198 * x23
            + x24 * x903
            + x24 * x904
            + x25 * x769
            + x749,
            x0 * (x1201 + x1207 * x91 - x84 * (x1203 + x1205 * x8))
            + x1210 * x2
            + x1214 * x23
            + x24 * x944
            + x25 * x807
            + x25 * x808
            + x91 * (x1215 + x1216 * x91 + x91 * (x1216 + x1218 * x91)),
            x1224 * x23
            + 0.5 * x1225
            + x1226 * x91
            + x24 * x961
            + x25 * x823
            + x25 * x824
            + x91 * (x1226 + x1227 * x91),
            x1234 * x23
            + x1236
            + x1237 * x91
            + x24 * x975
            + x25 * x839
            + x25 * x840
            + x91 * (x1237 + x1238 * x91),
            x1240 + x1244 * x23 + x1245 * x91 + x24 * x991 + x25 * x854 + x25 * x855,
            x1000 * x24 + x1247 + x1251 * x23 + x1252 * x91 + x25 * x865 + x25 * x866,
            x1009 * x24 + x1254 + x1258 * x23 + x1259 * x91 + x25 * x876 + x25 * x877,
            x1017 * x24
            + x1225
            + x1245 * x153
            + x1263 * x23
            + x25 * x884
            + x25 * x885
            + x995,
            x1023 * x24
            + x1236
            + x1252 * x153
            + x1267 * x23
            + x153 * x983
            + x25 * x890
            + x25 * x891,
            x1013 + x1029 * x24 + x1259 * x153 + x1271 * x23 + x25 * x896 + x25 * x897,
            x1035 * x24
            + x1235
            + x1259 * x178
            + x1275 * x23
            + x25 * x902
            + x25 * x903
            + x882,
            x0 * (x1278 + x1285 * x91 - x84 * (x1280 + x1283 * x8))
            + x1288 * x2
            + x1292 * x23
            + x25 * x942
            + x25 * x943
            + x25 * x944
            + x91 * (x1293 + x1294 * x91 + x91 * (x1294 + x1296 * x91)),
            x1294 * x152
            + x1301 * x23
            + 0.5 * x1302
            + x25 * x959
            + x25 * x960
            + x25 * x961
            + x91 * (x1296 * x152 + x1303),
            x1310 * x23
            + x1312
            + x1313 * x91
            + x25 * x973
            + x25 * x974
            + x25 * x975
            + x91 * (x1313 + x1314 * x91),
            x1316 + x1320 * x23 + x1321 * x91 + x25 * x989 + x25 * x990 + x25 * x991,
            x1000 * x25 + x1314 * x152 + x1325 * x23 + x1326 + x25 * x998 + x25 * x999,
            x1007 * x25 + x1008 * x25 + x1009 * x25 + x1328 + x1332 * x23 + x1333 * x91,
            x1015 * x25 + x1016 * x25 + x1017 * x25 + x1302 + x1321 * x153 + x1337 * x23,
            x1021 * x25 + x1022 * x25 + x1023 * x25 + x1312 + x1314 * x198 + x1341 * x23,
            x1027 * x25 + x1028 * x25 + x1029 * x25 + x1333 * x153 + x1345 * x23,
            3.0 * x1013
            + x1033 * x25
            + x1034 * x25
            + x1035 * x25
            + x1311
            + x1333 * x178
            + x1349 * x23,
            x0 * (-x1350 * x340 + x1352 * x17 * x3 * x8)
            + x1052 * x24
            + x1053 * x24
            + x1054 * x24
            + x1055 * x24
            + x91 * (x1354 + x1355 * x335),
            x1063 * x24
            + x1064 * x24
            + x1065 * x24
            + x1066 * x24
            + 0.5 * x1356
            + x1358 * x335,
            x1073 * x24 + x1074 * x24 + x1075 * x24 + x1076 * x24 + x1355 * x714 + x1360,
            x1082 * x24 + x1083 * x24 + x1084 * x24 + x1085 * x24 + x1361 * x91,
            x1089 * x24 + x1090 * x24 + x1091 * x24 + x1092 * x24 + x1362 * x91,
            x1096 * x24 + x1097 * x24 + x1098 * x24 + x1099 * x24 + x1363 * x91,
            4.0 * x1081
            + x1101 * x24
            + x1102 * x24
            + x1103 * x24
            + x1104 * x24
            + x1356
            + x1361 * x153,
            4.0 * x1088
            + x1105 * x24
            + x1106 * x24
            + x1107 * x24
            + x1108 * x24
            + x1360
            + x1362 * x153,
            4.0 * x1095
            + x1109 * x24
            + x1110 * x24
            + x1111 * x24
            + x1112 * x24
            + x1363 * x153,
            x1113 * x24 + x1114 * x24 + x1115 * x24 + x1116 * x24 + x1359 + x1363 * x178,
            x0 * (-x1364 * x340 + x1366 * x17 * x3 * x8)
            + x1052 * x25
            + x1130 * x24
            + x1131 * x24
            + x1132 * x24
            + x91 * (x1368 + x1369 * x335),
            x1063 * x25
            + x1143 * x24
            + x1144 * x24
            + x1145 * x24
            + 0.5 * x1370
            + x1371 * x335,
            x1073 * x25 + x1153 * x24 + x1154 * x24 + x1155 * x24 + x1373 + x1374 * x335,
            x1082 * x25 + x1163 * x24 + x1164 * x24 + x1165 * x24 + x1375 * x91,
            x1089 * x25 + x1171 * x24 + x1172 * x24 + x1173 * x24 + x1376 * x91,
            x1096 * x25 + x1178 * x24 + x1179 * x24 + x1180 * x24 + x1377 * x91,
            x1101 * x25
            + 3.0 * x1161
            + x1183 * x24
            + x1184 * x24
            + x1185 * x24
            + x1370
            + x1375 * x153,
            x1105 * x25
            + 3.0 * x1169
            + x1187 * x24
            + x1188 * x24
            + x1189 * x24
            + x1373
            + x1376 * x153,
            x1109 * x25
            + 3.0 * x1176
            + x1192 * x24
            + x1193 * x24
            + x1194 * x24
            + x1377 * x153,
            x1095
            + x1113 * x25
            + x1196 * x24
            + x1197 * x24
            + x1198 * x24
            + x1372
            + x1377 * x178,
            x0 * (-x1378 * x340 + x1380 * x17 * x3 * x8)
            + x1129 * x25
            + x1130 * x25
            + x1213 * x24
            + x1214 * x24
            + x91 * (x1382 + x1383 * x335),
            x1142 * x25
            + x1143 * x25
            + x1223 * x24
            + x1224 * x24
            + 0.5 * x1384
            + x1385 * x335,
            x1152 * x25 + x1153 * x25 + x1233 * x24 + x1234 * x24 + x1387 + x1388 * x335,
            x1162 * x25 + x1163 * x25 + x1243 * x24 + x1244 * x24 + x1389 * x91,
            x1170 * x25 + x1171 * x25 + x1250 * x24 + x1251 * x24 + x1390 * x91,
            x1177 * x25 + x1178 * x25 + x1257 * x24 + x1258 * x24 + x1391 * x91,
            x1182 * x25
            + x1183 * x25
            + 2.0 * x1240
            + x1262 * x24
            + x1263 * x24
            + x1384
            + x1389 * x153,
            x1186 * x25
            + x1187 * x25
            + 2.0 * x1247
            + x1266 * x24
            + x1267 * x24
            + x1387
            + x1390 * x153,
            x1191 * x25
            + x1192 * x25
            + 2.0 * x1254
            + x1270 * x24
            + x1271 * x24
            + x1391 * x153,
            2.0 * x1176
            + x1195 * x25
            + x1196 * x25
            + x1274 * x24
            + x1275 * x24
            + x1386
            + x1391 * x178,
            x0 * (-x1392 * x340 + x1394 * x17 * x3 * x8)
            + x1211 * x25
            + x1212 * x25
            + x1213 * x25
            + x1292 * x24
            + x91 * (x1396 + x1397 * x335),
            x1221 * x25
            + x1222 * x25
            + x1223 * x25
            + x1301 * x24
            + 0.5 * x1398
            + x1399 * x335,
            x1231 * x25 + x1232 * x25 + x1233 * x25 + x1310 * x24 + x1401 + x1402 * x335,
            x1241 * x25 + x1242 * x25 + x1243 * x25 + x1320 * x24 + x1403 * x91,
            x1248 * x25 + x1249 * x25 + x1250 * x25 + x1325 * x24 + x1404 * x91,
            x1255 * x25 + x1256 * x25 + x1257 * x25 + x1332 * x24 + x1405 * x91,
            x1260 * x25
            + x1261 * x25
            + x1262 * x25
            + x1316
            + x1337 * x24
            + x1398
            + x1403 * x153,
            x1264 * x25
            + x1265 * x25
            + x1266 * x25
            + x1326
            + x1341 * x24
            + x1401
            + x1404 * x153,
            x1268 * x25 + x1269 * x25 + x1270 * x25 + x1328 + x1345 * x24 + x1405 * x153,
            3.0 * x1254
            + x1272 * x25
            + x1273 * x25
            + x1274 * x25
            + x1349 * x24
            + x1400
            + x1405 * x178,
            x0 * (-x1406 * x340 + x1408 * x17 * x3 * x8)
            + x1289 * x25
            + x1290 * x25
            + x1291 * x25
            + x1292 * x25
            + x91 * (x1410 + x1411 * x335),
            x1298 * x25
            + x1299 * x25
            + x1300 * x25
            + x1301 * x25
            + x1411 * x546
            + 0.5 * x1412,
            x1307 * x25 + x1308 * x25 + x1309 * x25 + x1310 * x25 + x1414 + x1415 * x335,
            x1317 * x25 + x1318 * x25 + x1319 * x25 + x1320 * x25 + x1416 * x91,
            x1322 * x25 + x1323 * x25 + x1324 * x25 + x1325 * x25 + x1415 * x152,
            x1329 * x25 + x1330 * x25 + x1331 * x25 + x1332 * x25 + x1417 * x91,
            x1334 * x25 + x1335 * x25 + x1336 * x25 + x1337 * x25 + x1412 + x1416 * x153,
            x1338 * x25 + x1339 * x25 + x1340 * x25 + x1341 * x25 + x1414 + x1415 * x198,
            x1342 * x25 + x1343 * x25 + x1344 * x25 + x1345 * x25 + x1417 * x153,
            4.0 * x1328
            + x1346 * x25
            + x1347 * x25
            + x1348 * x25
            + x1349 * x25
            + x1413
            + x1417 * x178,
        ]
    )


def _3center2el3d_044(a, A, b, B, c, C):
    """Cartesian (sg|g) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = c ** (-1.0)
    x2 = 2.0 * a + 2.0 * b
    x3 = (2.0 * c + x2) ** (-1.0)
    x4 = a + b
    x5 = x4 ** (-1.0)
    x6 = -x5 * (a * A[0] + b * B[0])
    x7 = -x6 - C[0]
    x8 = c + x4
    x9 = x8 ** (-1.5)
    x10 = 2.0 * x9
    x11 = x7**2
    x12 = -x5 * (a * A[1] + b * B[1])
    x13 = -x12 - C[1]
    x14 = x13**2
    x15 = -x5 * (a * A[2] + b * B[2])
    x16 = -x15 - C[2]
    x17 = x16**2
    x18 = x8 ** (-1.0)
    x19 = x18 * x4
    x20 = c * x19 * (x11 + x14 + x17)
    x21 = boys(4, x20)
    x22 = 17.4934183276249
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x5 * (x0**2 + x23**2 + x24**2))
    x26 = x22 * x25 * x5
    x27 = x21 * x26
    x28 = x10 * x27
    x29 = x8 ** (-0.5)
    x30 = -x6 - A[0]
    x31 = boys(3, x20)
    x32 = -2.0 * x1 * x22 * x25 * x29 * x30 * x31 * x5 + x28 * x7
    x33 = -x32
    x34 = x3 * x33
    x35 = 2.0 * x34
    x36 = x2 ** (-1.0)
    x37 = 2.0 * x1 * x22 * x25 * x29 * x31 * x5 - x28
    x38 = x36 * x37
    x39 = boys(5, x20)
    x40 = x10 * x26
    x41 = x39 * x40
    x42 = -2.0 * x1 * x21 * x22 * x25 * x29 * x30 * x5 + x41 * x7
    x43 = -x42
    x44 = c * x18
    x45 = x43 * x44
    x46 = x45 * x7
    x47 = x30 * x33 + x38 - x46
    x48 = x19 * x47
    x49 = x35 + x48 * x7
    x50 = x19 * x49
    x51 = x31 * x40
    x52 = boys(2, x20)
    x53 = -2.0 * x1 * x22 * x25 * x29 * x30 * x5 * x52 + x51 * x7
    x54 = -x53
    x55 = x3 * x54
    x56 = 2.0 * x55
    x57 = -2.0 * x1 * x22 * x25 * x29 * x5 * x52
    x58 = -x51 - x57
    x59 = x36 * x58
    x60 = x33 * x44
    x61 = x60 * x7
    x62 = x30 * x54 + x59 - x61
    x63 = x19 * x62
    x64 = x56 + x63 * x7
    x65 = x19 * x33
    x66 = 0.5 * x1
    x67 = x66 * (-x53 - x65)
    x68 = x19 * x7
    x69 = 2.0 * x3
    x70 = x29 * x69
    x71 = x1 * x27 * x70
    x72 = x43 * x68 + x71
    x73 = x1 * x21
    x74 = x22 * x25
    x75 = x7 * x74
    x76 = x69 * x9
    x77 = x75 * x76
    x78 = x67 + x68 * x72 + x73 * x77
    x79 = -x36 * x58
    x80 = -x30 * x54 + x61 + x79
    x81 = x66 * (-x48 - x80)
    x82 = x3 * x43
    x83 = 2.0 * x82
    x84 = 2.0 * x1 * x21 * x22 * x25 * x29 * x5 - x41
    x85 = x36 * x84
    x86 = boys(6, x20)
    x87 = x40 * x86
    x88 = -2.0 * x1 * x22 * x25 * x29 * x30 * x39 * x5 + x7 * x87
    x89 = -x88
    x90 = x44 * x89
    x91 = x7 * x90
    x92 = x30 * x43 + x85 - x91
    x93 = x68 * x92 + x83
    x94 = x68 * x93 + x69 * x72 + x81
    x95 = x1 * (-x50 + x64) + x68 * x94 + x69 * x78
    x96 = 3.0 * x3
    x97 = boys(1, x20)
    x98 = x40 * x97
    x99 = boys(0, x20)
    x100 = -2.0 * x1 * x22 * x25 * x29 * x5 * x99
    x101 = -x100 - x98
    x102 = x101 * x36
    x103 = -2.0 * x1 * x22 * x25 * x29 * x30 * x5 * x99 + x7 * x98
    x104 = -x103
    x105 = x40 * x52
    x106 = -2.0 * x1 * x22 * x25 * x29 * x30 * x5 * x97 + x105 * x7
    x107 = -x106
    x108 = x107 * x44
    x109 = x108 * x7
    x110 = x102 + x104 * x30 - x109
    x111 = -x103 - x108
    x112 = -2.0 * x1 * x22 * x25 * x29 * x5 * x97
    x113 = -x105 - x112
    x114 = x113 * x36
    x115 = x44 * x54
    x116 = x115 * x7
    x117 = x107 * x30 + x114 - x116
    x118 = -x106 - x115
    x119 = 2.0 * x36
    x120 = x44 * x62
    x121 = x120 * x7
    x122 = x117 * x30 + x118 * x119 - x121
    x123 = x117 * x44
    x124 = x123 * x7
    x125 = x66 * (x110 * x30 + 2.0 * x111 * x36 - x122 * x19 - x124)
    x126 = -x53 - x60
    x127 = x44 * x47
    x128 = x127 * x7
    x129 = x119 * x126 - x128 + x30 * x62
    x130 = x129 * x19
    x131 = x66 * (x117 * x30 + 2.0 * x118 * x36 - x121 - x130)
    x132 = x3 * x47
    x133 = 3.0 * x132
    x134 = x44 * x92
    x135 = x119 * (-x32 - x45) - x134 * x7 + x30 * x47
    x136 = x135 * x19
    x137 = x133 + x136 * x7
    x138 = x137 * x19
    x139 = x3 * x62
    x140 = 3.0 * x139
    x141 = x130 * x7 + x140
    x142 = 1.5 * x1
    x143 = x66 * (2.0 * x126 * x36 - x128 - x136 + x30 * x62)
    x144 = x3 * x92
    x145 = 3.0 * x144
    x146 = x36 * (2.0 * x1 * x22 * x25 * x29 * x39 * x5 - x87)
    x147 = boys(7, x20)
    x148 = x147 * x40
    x149 = 2.0 * x1 * x22 * x25 * x29 * x30 * x5 * x86 - x148 * x7
    x150 = x149 * x44
    x151 = x146 - x150 * x7 + x30 * x89
    x152 = x151 * x44
    x153 = x119 * (-x42 - x90) - x152 * x7 + x30 * x92
    x154 = x145 + x153 * x68
    x155 = x143 + x154 * x68 + x93 * x96
    x156 = x1 * (-x138 + x141) + x155 * x68 + x94 * x96
    x157 = (
        x142 * (x125 + x141 * x68 - x19 * (x131 + x138 * x7 + x49 * x96) + x64 * x96)
        + x156 * x68
        + x95 * x96
    )
    x158 = x1 * x31
    x159 = x26 * x70
    x160 = x158 * x159
    x161 = x160 + x65 * x7
    x162 = x161 * x19
    x163 = x19 * x54
    x164 = x1 * x52
    x165 = x159 * x164
    x166 = x163 * x7 + x165
    x167 = x10 * x74
    x168 = x66 * (-x158 * x167 - x57)
    x169 = x8 ** (-2.5)
    x170 = 2.0 * x169 * x4
    x171 = x73 * x74
    x172 = x11 * x171
    x173 = x168 + x170 * x172
    x174 = x1 * (-x162 + x166) + x173 * x3 + x68 * x78
    x175 = -x101 * x36
    x176 = -x104 * x30 + x109 + x175
    x177 = x66 * (-x117 * x19 - x176)
    x178 = -x113 * x36
    x179 = -x107 * x30 + x116 + x178
    x180 = x66 * (-x179 - x63)
    x181 = (
        x142 * (x166 * x69 + x177 - x19 * (x161 * x69 + x180 + x50 * x7) + x64 * x68)
        + x174 * x69
        + x68 * x95
    )
    x182 = x0 * x181 + x157
    x183 = x158 * x170
    x184 = x1 * (2.0 * x1 * x22 * x25 * x52 * x7 * x9 - x183 * x75) + x173 * x68
    x185 = x66 * (-x103 - x107 * x19)
    x186 = x66 * (-x106 - x163)
    x187 = (
        x142 * (x164 * x77 + x166 * x68 + x185 - x19 * (x158 * x77 + x162 * x7 + x186))
        + x174 * x68
        + x184 * x3
    )
    x188 = x0 * x187 + x181
    x189 = x0 * x188 + x182
    x190 = x1 * x167
    x191 = x66 * (-x100 - x190 * x97)
    x192 = x66 * (-x112 - x190 * x52)
    x193 = x11 * x74
    x194 = x164 * x170
    x195 = x142 * (-x19 * (x183 * x193 + x192) + x191 + x193 * x194) + x184 * x68
    x196 = 4.0 * x3
    x197 = -x120 - x179
    x198 = 3.0 * x36
    x199 = x44 * x7
    x200 = x129 * x199
    x201 = x66 * (
        -x122 * x199
        - x19 * (x122 * x30 + x197 * x198 - x200)
        + x30 * (x110 * x30 + x111 * x119 - x124)
        + 3.0 * x36 * (-x123 - x176)
    )
    x202 = -x127 - x80
    x203 = x135 * x199
    x204 = x129 * x30 + x198 * x202 - x203
    x205 = x19 * x204
    x206 = x66 * (x122 * x30 + 3.0 * x197 * x36 - x200 - x205)
    x207 = x135 * x3
    x208 = 4.0 * x207
    x209 = -x36 * x37
    x210 = x135 * x30 - x153 * x199 + x198 * (-x134 - x209 + x30 * x33 - x46)
    x211 = x19 * x210
    x212 = x19 * (x208 + x211 * x7)
    x213 = x129 * x3
    x214 = 4.0 * x213
    x215 = x205 * x7 + x214
    x216 = x66 * (x129 * x30 + 3.0 * x202 * x36 - x203 - x211)
    x217 = x153 * x3
    x218 = 4.0 * x217
    x219 = -x36 * x84
    x220 = x36 * (2.0 * x1 * x22 * x25 * x29 * x5 * x86 - x148)
    x221 = x40 * boys(8, x20)
    x222 = (
        x153 * x30
        + x198 * (-x152 - x219 + x30 * x43 - x91)
        - x199
        * (
            x119 * (-x150 - x88)
            + x151 * x30
            - x199
            * (
                x149 * x30
                - x199 * (2.0 * x1 * x147 * x22 * x25 * x29 * x30 * x5 - x221 * x7)
                + x220
            )
        )
    )
    x223 = x4**2
    x224 = x8 ** (-2.0)
    x225 = x223 * x224
    x226 = x13 * x225
    x227 = x210 * x226
    x228 = x13 * x19
    x229 = x226 * x7
    x230 = x135 * x226
    x231 = x13 * x47
    x232 = x225 * x231
    x233 = x1 * (x13 * x18 * x4 * x62 - x232)
    x234 = x13 * x76
    x235 = x171 * x234
    x236 = x229 * x43 + x235
    x237 = x228 * x83 + x229 * x92
    x238 = 0.5 * x233 + x236 * x69 + x237 * x68
    x239 = x1 * (x129 * x13 * x18 * x4 - x230)
    x240 = x145 * x228 + x153 * x229
    x241 = x237 * x96 + 0.5 * x239 + x240 * x68
    x242 = (
        x1 * (x129 * x229 + x140 * x228 - x19 * (x133 * x228 + x230 * x7))
        + x238 * x96
        + x241 * x68
    )
    x243 = x226 * x33
    x244 = x1 * (x13 * x18 * x4 * x54 - x243)
    x245 = x169 * x4 * x69
    x246 = x73 * x75
    x247 = x245 * x246
    x248 = x13 * x247 + x236 * x68 + 0.5 * x244
    x249 = (
        x1 * (-x19 * (x228 * x35 + x232 * x7) + x228 * x56 + x229 * x62)
        + x238 * x68
        + x248 * x69
    )
    x250 = x0 * x249 + x242
    x251 = x234 * x74
    x252 = x158 * x251
    x253 = x164 * x251
    x254 = x183 * x74
    x255 = x1 * (2.0 * x1 * x13 * x22 * x25 * x52 * x9 - x13 * x254)
    x256 = 2.0 * x172
    x257 = x223 * x8 ** (-3.5)
    x258 = x13 * x257
    x259 = 0.5 * x255 + x256 * x258
    x260 = x1 * (-x19 * (x243 * x7 + x252) + x229 * x54 + x253) + x248 * x68 + x259 * x3
    x261 = x0 * x260 + x249
    x262 = x0 * x261 + x250
    x263 = 2.0 * x158
    x264 = x263 * x75
    x265 = (
        x1 * (2.0 * x1 * x13 * x169 * x22 * x25 * x4 * x52 * x7 - x258 * x264)
        + x259 * x68
    )
    x266 = x1 * (x13 * x18 * x204 * x4 - x227)
    x267 = x16 * x225
    x268 = x210 * x267
    x269 = x16 * x19
    x270 = x267 * x7
    x271 = x135 * x267
    x272 = x267 * x47
    x273 = x1 * (x16 * x18 * x4 * x62 - x272)
    x274 = 0.5 * x273
    x275 = x16 * x76
    x276 = x171 * x275
    x277 = x270 * x43 + x276
    x278 = x269 * x83 + x270 * x92
    x279 = x274 + x277 * x69 + x278 * x68
    x280 = x1 * (x129 * x16 * x18 * x4 - x271)
    x281 = 0.5 * x280
    x282 = x145 * x269 + x153 * x270
    x283 = x278 * x96 + x281 + x282 * x68
    x284 = (
        x1 * (x129 * x270 + x140 * x269 - x19 * (x133 * x269 + x271 * x7))
        + x279 * x96
        + x283 * x68
    )
    x285 = x267 * x33
    x286 = x1 * (x16 * x18 * x4 * x54 - x285)
    x287 = 0.5 * x286
    x288 = x16 * x247 + x277 * x68 + x287
    x289 = (
        x1 * (-x19 * (x269 * x35 + x272 * x7) + x269 * x56 + x270 * x62)
        + x279 * x68
        + x288 * x69
    )
    x290 = x0 * x289 + x284
    x291 = x275 * x74
    x292 = x158 * x291
    x293 = x164 * x291
    x294 = x1 * (2.0 * x1 * x16 * x22 * x25 * x52 * x9 - x16 * x254)
    x295 = 0.5 * x294
    x296 = x16 * x257
    x297 = x256 * x296 + x295
    x298 = x1 * (-x19 * (x285 * x7 + x292) + x270 * x54 + x293) + x288 * x68 + x297 * x3
    x299 = x0 * x298 + x289
    x300 = x0 * x299 + x290
    x301 = (
        x1 * (2.0 * x1 * x16 * x169 * x22 * x25 * x4 * x52 * x7 - x264 * x296)
        + x297 * x68
    )
    x302 = x1 * (x16 * x18 * x204 * x4 - x268)
    x303 = 0.5 * x302
    x304 = x14 * x225
    x305 = x125 + x129 * x304 - x19 * (x131 + x135 * x304)
    x306 = x304 * x43 + x67
    x307 = x3 * x306
    x308 = x304 * x92 + x81
    x309 = 2.0 * x307 + x308 * x68
    x310 = x3 * x308
    x311 = x143 + x153 * x304
    x312 = 3.0 * x310 + x311 * x68
    x313 = x305 * x66 + x309 * x96 + x312 * x68
    x314 = x177 - x19 * (x180 + x304 * x47) + x304 * x62
    x315 = x170 * x171
    x316 = x14 * x315 + x168
    x317 = x3 * x316
    x318 = x306 * x68 + x317
    x319 = x309 * x68 + x314 * x66 + x318 * x69
    x320 = x0 * x319 + x313
    x321 = x185 - x19 * (x186 + x304 * x33) + x304 * x54
    x322 = x317 * x68 + x318 * x68 + x321 * x66
    x323 = x0 * x322 + x319
    x324 = x0 * x323 + x320
    x325 = x194 * x74
    x326 = x14 * x325 - x19 * (x14 * x254 + x192) + x191
    x327 = x11 * x225
    x328 = x316 * x327 + x326 * x66
    x329 = -x19 * (x206 + x210 * x304) + x201 + x204 * x304
    x330 = x3 * x311
    x331 = x216 + x222 * x304
    x332 = x13 * x16
    x333 = x4**3
    x334 = x333 / x8**3
    x335 = x332 * x334
    x336 = x1 * (x129 * x13 * x16 * x223 * x224 - x135 * x335)
    x337 = x335 * x7
    x338 = x16 * x226
    x339 = x337 * x92 + x338 * x83
    x340 = x145 * x338 + x153 * x337
    x341 = 0.5 * x336 + x339 * x96 + x340 * x68
    x342 = x16 * x334
    x343 = x1 * (x13 * x16 * x223 * x224 * x62 - x231 * x342)
    x344 = x171 * x245 * x332
    x345 = x337 * x43 + x344
    x346 = x339 * x68 + 0.5 * x343 + x345 * x69
    x347 = x0 * x346 + x341
    x348 = x1 * (x13 * x16 * x223 * x224 * x54 - x33 * x335)
    x349 = x257 * x332
    x350 = x246 * x349 * x69 + x345 * x68 + 0.5 * x348
    x351 = x0 * x350 + x346
    x352 = x0 * x351 + x347
    x353 = x1 * (2.0 * x1 * x13 * x16 * x169 * x22 * x25 * x4 * x52 - x263 * x349 * x74)
    x354 = x256 * x332 * x333 * x8 ** (-4.5) + 0.5 * x353
    x355 = x1 * (x13 * x16 * x204 * x223 * x224 - x210 * x335)
    x356 = x17 * x225
    x357 = x125 + x129 * x356 - x19 * (x131 + x135 * x356)
    x358 = x357 * x66
    x359 = x356 * x43 + x67
    x360 = x3 * x359
    x361 = 2.0 * x360
    x362 = x356 * x92 + x81
    x363 = x361 + x362 * x68
    x364 = x3 * x362
    x365 = 3.0 * x364
    x366 = x143 + x153 * x356
    x367 = x365 + x366 * x68
    x368 = x358 + x363 * x96 + x367 * x68
    x369 = x177 - x19 * (x180 + x356 * x47) + x356 * x62
    x370 = x369 * x66
    x371 = x168 + x17 * x315
    x372 = x3 * x371
    x373 = x359 * x68 + x372
    x374 = x363 * x68 + x370 + x373 * x69
    x375 = x0 * x374 + x368
    x376 = x185 - x19 * (x186 + x33 * x356) + x356 * x54
    x377 = x376 * x66
    x378 = x372 * x68 + x373 * x68 + x377
    x379 = x0 * x378 + x374
    x380 = x0 * x379 + x375
    x381 = x17 * x325 - x19 * (x17 * x254 + x192) + x191
    x382 = x381 * x66
    x383 = x327 * x371 + x382
    x384 = -x19 * (x206 + x210 * x356) + x201 + x204 * x356
    x385 = x384 * x66
    x386 = x3 * x366
    x387 = 4.0 * x386
    x388 = x216 + x222 * x356
    x389 = x228 * x308 + x233
    x390 = x3 * x389
    x391 = x228 * x311 + x239
    x392 = 3.0 * x390 + x391 * x68
    x393 = x228 * x306 + x244
    x394 = x3 * x393
    x395 = x389 * x68 + 2.0 * x394
    x396 = x0 * x395 + x392
    x397 = x228 * x316 + x255
    x398 = x3 * x397
    x399 = x393 * x68 + x398
    x400 = x0 * x399 + x395
    x401 = x0 * x400 + x396
    x402 = x0 * x68
    x403 = x3 * x391
    x404 = x228 * x331 + x266
    x405 = x14 * x342
    x406 = x274 + x405 * x92
    x407 = x3 * x406
    x408 = x153 * x405 + x281
    x409 = 3.0 * x407 + x408 * x68
    x410 = x287 + x405 * x43
    x411 = x3 * x410
    x412 = x406 * x68 + 2.0 * x411
    x413 = x0 * x412 + x409
    x414 = 2.0 * x14 * x171 * x296 + x295
    x415 = x3 * x414
    x416 = x410 * x68 + x415
    x417 = x0 * x416 + x412
    x418 = x0 * x417 + x413
    x419 = x3 * x408
    x420 = x222 * x405 + x303
    x421 = x228 * x365 + x229 * x366
    x422 = x228 * x361 + x229 * x362
    x423 = x0 * x422 + x421
    x424 = x228 * x372
    x425 = x229 * x359 + x424
    x426 = x0 * x425 + x422
    x427 = x0 * x426 + x423
    x428 = x229 * x371
    x429 = x269 * x362 + x273
    x430 = x3 * x429
    x431 = x269 * x366 + x280
    x432 = 3.0 * x430 + x431 * x68
    x433 = x269 * x359 + x286
    x434 = x3 * x433
    x435 = x429 * x68 + 2.0 * x434
    x436 = x0 * x435 + x432
    x437 = x269 * x371 + x294
    x438 = x3 * x437
    x439 = x433 * x68 + x438
    x440 = x0 * x439 + x435
    x441 = x0 * x440 + x436
    x442 = x3 * x431
    x443 = x269 * x388 + x302
    x444 = x142 * x305 + x228 * x391
    x445 = x142 * x314 + x228 * x389
    x446 = x0 * x445 + x444
    x447 = x142 * x321 + x228 * x393
    x448 = x0 * x447 + x445
    x449 = x0 * x448 + x446
    x450 = x142 * x326 + x228 * x397
    x451 = x228 * x408 + x336
    x452 = x228 * x406 + x343
    x453 = x0 * x452 + x451
    x454 = x228 * x410 + x348
    x455 = x0 * x454 + x452
    x456 = x0 * x455 + x453
    x457 = x228 * x414 + x353
    x458 = x304 * x366 + x358
    x459 = x304 * x362 + x370
    x460 = x0 * x459 + x458
    x461 = x304 * x359 + x377
    x462 = x0 * x461 + x459
    x463 = x0 * x462 + x460
    x464 = x304 * x371 + x382
    x465 = x228 * x431
    x466 = x228 * x429
    x467 = x0 * x466 + x465
    x468 = x228 * x433
    x469 = x0 * x468 + x466
    x470 = x0 * x469 + x467
    x471 = x228 * x437
    x472 = x142 * x357 + x269 * x431
    x473 = x142 * x369 + x269 * x429
    x474 = x0 * x473 + x472
    x475 = x142 * x376 + x269 * x433
    x476 = x0 * x475 + x473
    x477 = x0 * x476 + x474
    x478 = x142 * x381 + x269 * x437
    x479 = -x12 - A[1]
    x480 = -2.0 * x1 * x22 * x25 * x29 * x31 * x479 * x5 + x13 * x28
    x481 = -x480
    x482 = x3 * x481
    x483 = -2.0 * x1 * x21 * x22 * x25 * x29 * x479 * x5 + x13 * x41
    x484 = -x483
    x485 = x44 * x484
    x486 = -x30 * x481 + x485 * x7
    x487 = -x486
    x488 = x19 * x487
    x489 = x482 + x488 * x7
    x490 = x19 * x489
    x491 = -2.0 * x1 * x22 * x25 * x29 * x479 * x5 * x52 + x13 * x51
    x492 = -x491
    x493 = x3 * x492
    x494 = x44 * x481
    x495 = -x30 * x492 + x494 * x7
    x496 = -x495
    x497 = x19 * x496
    x498 = x493 + x497 * x7
    x499 = x19 * x481
    x500 = x66 * (-x491 - x499)
    x501 = x327 * x484 + x500
    x502 = x66 * (-x488 - x495)
    x503 = x3 * x484
    x504 = -2.0 * x1 * x22 * x25 * x29 * x39 * x479 * x5 + x13 * x87
    x505 = -x504
    x506 = x44 * x505
    x507 = -x30 * x484 + x506 * x7
    x508 = -x507
    x509 = x503 + x508 * x68
    x510 = x502 + x503 * x68 + x509 * x68
    x511 = x1 * (-x490 + x498) + x3 * x501 + x510 * x68
    x512 = -2.0 * x1 * x22 * x25 * x29 * x479 * x5 * x97 + x105 * x13
    x513 = -x512
    x514 = x44 * x513
    x515 = -2.0 * x1 * x22 * x25 * x29 * x479 * x5 * x99 + x13 * x98
    x516 = -x514 - x515
    x517 = -x515
    x518 = -x30 * x517 + x514 * x7
    x519 = -x518
    x520 = x44 * x492
    x521 = -x512 - x520
    x522 = x36 * x521
    x523 = -x30 * x513 + x520 * x7
    x524 = -x523
    x525 = x44 * x496
    x526 = x525 * x7
    x527 = x30 * x524 + x522 - x526
    x528 = x44 * x524
    x529 = x528 * x7
    x530 = x66 * (-x19 * x527 + x30 * x519 + x36 * x516 - x529)
    x531 = -x491 - x494
    x532 = x36 * x531
    x533 = x44 * x487
    x534 = x533 * x7
    x535 = x30 * x496 + x532 - x534
    x536 = x19 * x535
    x537 = x66 * (x30 * x524 + x36 * x521 - x526 - x536)
    x538 = x3 * x487
    x539 = 2.0 * x538
    x540 = x36 * (-x480 - x485)
    x541 = x44 * x508
    x542 = x30 * x487 + x540 - x541 * x7
    x543 = x19 * x542
    x544 = x539 + x543 * x7
    x545 = x19 * x544
    x546 = x3 * x496
    x547 = 2.0 * x546
    x548 = x536 * x7 + x547
    x549 = x66 * (x30 * x496 + x36 * x531 - x534 - x543)
    x550 = x3 * x508
    x551 = 2.0 * x550
    x552 = x36 * (-x483 - x506)
    x553 = 2.0 * x1 * x22 * x25 * x29 * x479 * x5 * x86 - x13 * x148
    x554 = x44 * x553
    x555 = x30 * x505 - x554 * x7
    x556 = x44 * x555
    x557 = x30 * x508 + x552 - x556 * x7
    x558 = x551 + x557 * x68
    x559 = x509 * x69 + x549 + x558 * x68
    x560 = x1 * (-x545 + x548) + x510 * x69 + x559 * x68
    x561 = (
        x142 * (-x19 * (x489 * x69 + x537 + x545 * x7) + x498 * x69 + x530 + x548 * x68)
        + x511 * x69
        + x560 * x68
    )
    x562 = x181 * x23 + x561
    x563 = x225 * x7
    x564 = x1 * (x18 * x4 * x492 * x7 - x481 * x563) + x501 * x68
    x565 = x66 * (-x19 * x524 - x518)
    x566 = x66 * (-x497 - x523)
    x567 = (
        x142 * (-x19 * (x482 * x68 + x490 * x7 + x566) + x493 * x68 + x498 * x68 + x565)
        + x3 * x564
        + x511 * x68
    )
    x568 = x187 * x23 + x567
    x569 = x0 * x568 + x562
    x570 = x66 * (-x19 * x513 - x515)
    x571 = x19 * x492
    x572 = x66 * (-x512 - x571)
    x573 = x142 * (-x19 * (x327 * x481 + x572) + x327 * x492 + x570) + x564 * x68
    x574 = x195 * x23 + x573
    x575 = x36 * x516
    x576 = -x523 - x525
    x577 = x199 * x535
    x578 = x66 * (
        -x19 * (x119 * x576 + x30 * x527 - x577)
        - x199 * x527
        + x30 * (x30 * x519 - x529 + x575)
        + 2.0 * x36 * (-x518 - x528)
    )
    x579 = -x495 - x533
    x580 = x199 * x542
    x581 = x119 * x579 + x30 * x535 - x580
    x582 = x19 * x581
    x583 = x66 * (x30 * x527 + 2.0 * x36 * x576 - x577 - x582)
    x584 = x3 * x542
    x585 = 3.0 * x584
    x586 = x119 * (-x486 - x541) - x199 * x557 + x30 * x542
    x587 = x19 * x586
    x588 = x19 * (x585 + x587 * x7)
    x589 = x3 * x535
    x590 = 3.0 * x589
    x591 = x582 * x7 + x590
    x592 = x66 * (x30 * x535 + 2.0 * x36 * x579 - x580 - x587)
    x593 = x3 * x557
    x594 = 3.0 * x593
    x595 = x36 * (-x504 - x554)
    x596 = 2.0 * x1 * x147 * x22 * x25 * x29 * x479 * x5 - x13 * x221
    x597 = (
        x119 * (-x507 - x556)
        - x199 * (-x199 * (-x199 * x596 + x30 * x553) + x30 * x555 + x595)
        + x30 * x557
    )
    x598 = x13 * x536 + x139
    x599 = x13 * x543 + x132
    x600 = x19 * (x13 * x587 + x207)
    x601 = x13 * x582 + x213
    x602 = x13 * x497 + x55
    x603 = x602 * x69
    x604 = x13 * x488 + x34
    x605 = x604 * x69
    x606 = x19 * x599
    x607 = x19 * x604
    x608 = x1 * (x602 - x607)
    x609 = x228 * x484 + x71
    x610 = x3 * x609
    x611 = x228 * x508 + x82
    x612 = x610 + x611 * x68
    x613 = 0.5 * x608 + x610 * x68 + x612 * x68
    x614 = x1 * (x598 - x606)
    x615 = x611 * x69
    x616 = x144 + x228 * x557
    x617 = x615 + x616 * x68
    x618 = x612 * x69 + 0.5 * x614 + x617 * x68
    x619 = x1 * (-x19 * (x605 + x606 * x7) + x598 * x68 + x603) + x613 * x69 + x618 * x68
    x620 = x23 * x249 + x619
    x621 = x13 * x571 + x165
    x622 = x3 * x621
    x623 = x13 * x499 + x160
    x624 = x3 * x623
    x625 = x19 * x623
    x626 = x1 * (x621 - x625)
    x627 = x327 * x609 + 0.5 * x626
    x628 = x1 * (-x19 * (x607 * x7 + x624) + x602 * x68 + x622) + x3 * x627 + x613 * x68
    x629 = x23 * x260 + x628
    x630 = x0 * x629 + x620
    x631 = x1 * (x18 * x4 * x621 * x7 - x563 * x623) + x627 * x68
    x632 = x23 * x265 + x631
    x633 = x1 * (-x600 + x601)
    x634 = x217 + x228 * x597
    x635 = x267 * x586
    x636 = x267 * x542
    x637 = x269 * x539
    x638 = x269 * x547
    x639 = x267 * x487
    x640 = x1 * (x16 * x18 * x4 * x496 - x639)
    x641 = 0.5 * x640
    x642 = x269 * x503
    x643 = x270 * x508 + x642
    x644 = x270 * x503 + x641 + x643 * x68
    x645 = x1 * (x16 * x18 * x4 * x535 - x636)
    x646 = 0.5 * x645
    x647 = x269 * x551
    x648 = x270 * x557 + x647
    x649 = x643 * x69 + x646 + x648 * x68
    x650 = x1 * (-x19 * (x636 * x7 + x637) + x270 * x535 + x638) + x644 * x69 + x649 * x68
    x651 = x23 * x289 + x650
    x652 = x269 * x482
    x653 = x269 * x493
    x654 = x1 * (x16 * x18 * x4 * x492 - x267 * x481)
    x655 = 0.5 * x654
    x656 = x11 * x342
    x657 = x484 * x656 + x655
    x658 = x1 * (-x19 * (x639 * x7 + x652) + x270 * x496 + x653) + x3 * x657 + x644 * x68
    x659 = x23 * x298 + x658
    x660 = x0 * x659 + x651
    x661 = x342 * x7
    x662 = x1 * (x16 * x223 * x224 * x492 * x7 - x481 * x661) + x657 * x68
    x663 = x23 * x301 + x662
    x664 = x1 * (x16 * x18 * x4 * x581 - x635)
    x665 = 0.5 * x664
    x666 = x139 * x228 - x19 * (x13 * x606 + x132 * x228 + x537) + x228 * x598 + x530
    x667 = x228 * x609 + x235 + x500
    x668 = x3 * x667
    x669 = x228 * x611 + x228 * x82 + x502
    x670 = x668 + x669 * x68
    x671 = x669 * x69
    x672 = x144 * x228 + x228 * x616 + x549
    x673 = x671 + x672 * x68
    x674 = x66 * x666 + x670 * x69 + x673 * x68
    x675 = x23 * x319 + x674
    x676 = -x19 * (x13 * x607 + x228 * x34 + x566) + x228 * x55 + x228 * x602 + x565
    x677 = x66 * x676 + x668 * x68 + x670 * x68
    x678 = x23 * x322 + x677
    x679 = x0 * x678 + x675
    x680 = -x19 * (x13 * x625 + x252 + x572) + x228 * x621 + x253 + x570
    x681 = x327 * x667 + x66 * x680
    x682 = x23 * x328 + x681
    x683 = -x19 * (x13 * x600 + x207 * x228 + x583) + x213 * x228 + x228 * x601 + x578
    x684 = x217 * x228 + x228 * x634 + x592
    x685 = x132 * x269
    x686 = x139 * x269
    x687 = x1 * (-x19 * (x338 * x542 + x685) + x338 * x535 + x686)
    x688 = x276 + x338 * x484
    x689 = x3 * x688
    x690 = x269 * x82
    x691 = x338 * x508 + x690
    x692 = x68 * x691 + x689
    x693 = x69 * x691
    x694 = x144 * x269
    x695 = x338 * x557 + x694
    x696 = x68 * x695 + x693
    x697 = x68 * x696 + 0.5 * x687 + x69 * x692
    x698 = x23 * x346 + x697
    x699 = x269 * x34
    x700 = x269 * x55
    x701 = x1 * (-x19 * (x338 * x487 + x699) + x338 * x496 + x700)
    x702 = x68 * x689 + x68 * x692 + 0.5 * x701
    x703 = x23 * x350 + x702
    x704 = x0 * x703 + x698
    x705 = x1 * (-x19 * (x292 + x338 * x481) + x293 + x338 * x492)
    x706 = x327 * x688 + 0.5 * x705
    x707 = x23 * x354 + x706
    x708 = x207 * x269
    x709 = x213 * x269
    x710 = x1 * (-x19 * (x338 * x586 + x708) + x338 * x581 + x709)
    x711 = x217 * x269
    x712 = x338 * x597 + x711
    x713 = -x19 * (x356 * x542 + x537) + x356 * x535 + x530
    x714 = x66 * x713
    x715 = x356 * x484 + x500
    x716 = x3 * x715
    x717 = x356 * x508 + x502
    x718 = x68 * x717 + x716
    x719 = x3 * x717
    x720 = 2.0 * x719
    x721 = x356 * x557 + x549
    x722 = x68 * x721 + x720
    x723 = x68 * x722 + x69 * x718 + x714
    x724 = x23 * x374 + x723
    x725 = -x19 * (x356 * x487 + x566) + x356 * x496 + x565
    x726 = x66 * x725
    x727 = x68 * x716 + x68 * x718 + x726
    x728 = x23 * x378 + x727
    x729 = x0 * x728 + x724
    x730 = -x19 * (x356 * x481 + x572) + x356 * x492 + x570
    x731 = x66 * x730
    x732 = x327 * x715 + x731
    x733 = x23 * x383 + x732
    x734 = -x19 * (x356 * x586 + x583) + x356 * x581 + x578
    x735 = x66 * x734
    x736 = x3 * x721
    x737 = x356 * x597 + x592
    x738 = x228 * x669 + x307 + x608
    x739 = x69 * x738
    x740 = x228 * x672 + x310 + x614
    x741 = x68 * x740 + x739
    x742 = x23 * x395 + x741
    x743 = x228 * x667 + x317 + x626
    x744 = x3 * x743
    x745 = x68 * x738 + x744
    x746 = x23 * x399 + x745
    x747 = x0 * x746 + x742
    x748 = x68 * x743
    x749 = x23 * x68
    x750 = x397 * x749 + x748
    x751 = x228 * x684 + x330 + x633
    x752 = x228 * x691 + x338 * x82 + x641
    x753 = x69 * x752
    x754 = x144 * x338 + x228 * x695 + x646
    x755 = x68 * x754 + x753
    x756 = x23 * x412 + x755
    x757 = x228 * x688 + x344 + x655
    x758 = x3 * x757
    x759 = x68 * x752 + x758
    x760 = x23 * x416 + x759
    x761 = x0 * x760 + x756
    x762 = x68 * x757
    x763 = x414 * x749 + x762
    x764 = x217 * x338 + x228 * x712 + x665
    x765 = x228 * x717 + x360
    x766 = x69 * x765
    x767 = x228 * x721 + x364
    x768 = x68 * x767 + x766
    x769 = x23 * x422 + x768
    x770 = x228 * x715 + x372
    x771 = x3 * x770
    x772 = x68 * x765 + x771
    x773 = x23 * x425 + x772
    x774 = x0 * x773 + x769
    x775 = x68 * x770
    x776 = x23 * x428 + x775
    x777 = x228 * x737 + x386
    x778 = x269 * x717 + x640
    x779 = x3 * x778
    x780 = 2.0 * x779
    x781 = x269 * x721 + x645
    x782 = x68 * x781 + x780
    x783 = x23 * x435 + x782
    x784 = x269 * x715 + x654
    x785 = x3 * x784
    x786 = x68 * x778 + x785
    x787 = x23 * x439 + x786
    x788 = x0 * x787 + x783
    x789 = x68 * x784
    x790 = x437 * x749 + x789
    x791 = x3 * x781
    x792 = x269 * x737 + x664
    x793 = x142 * x666 + x228 * x740 + x390
    x794 = x23 * x445 + x793
    x795 = x142 * x676 + x228 * x738 + x394
    x796 = x23 * x447 + x795
    x797 = x0 * x796 + x794
    x798 = x142 * x680 + x228 * x743 + x398
    x799 = x23 * x450 + x798
    x800 = x228 * x754 + x407 + x687
    x801 = x23 * x452 + x800
    x802 = x228 * x752 + x411 + x701
    x803 = x23 * x454 + x802
    x804 = x0 * x803 + x801
    x805 = x228 * x757 + x415 + x705
    x806 = x23 * x457 + x805
    x807 = x228 * x364 + x228 * x767 + x714
    x808 = x23 * x459 + x807
    x809 = x228 * x360 + x228 * x765 + x726
    x810 = x23 * x461 + x809
    x811 = x0 * x810 + x808
    x812 = x228 * x770 + x424 + x731
    x813 = x23 * x464 + x812
    x814 = x228 * x781 + x430
    x815 = x23 * x466 + x814
    x816 = x228 * x778 + x434
    x817 = x23 * x468 + x816
    x818 = x0 * x817 + x815
    x819 = x228 * x784 + x438
    x820 = x23 * x471 + x819
    x821 = x142 * x713 + x269 * x781
    x822 = x23 * x473 + x821
    x823 = x142 * x725 + x269 * x778
    x824 = x23 * x475 + x823
    x825 = x0 * x824 + x822
    x826 = x142 * x730 + x269 * x784
    x827 = x23 * x478 + x826
    x828 = -x15 - A[2]
    x829 = -2.0 * x1 * x22 * x25 * x29 * x31 * x5 * x828 + x16 * x28
    x830 = -x829
    x831 = x3 * x830
    x832 = -2.0 * x1 * x21 * x22 * x25 * x29 * x5 * x828 + x16 * x41
    x833 = -x832
    x834 = x44 * x833
    x835 = -x30 * x830 + x7 * x834
    x836 = -x835
    x837 = x19 * x836
    x838 = x7 * x837 + x831
    x839 = x19 * x838
    x840 = -2.0 * x1 * x22 * x25 * x29 * x5 * x52 * x828 + x16 * x51
    x841 = -x840
    x842 = x3 * x841
    x843 = x44 * x830
    x844 = -x30 * x841 + x7 * x843
    x845 = -x844
    x846 = x19 * x845
    x847 = x7 * x846 + x842
    x848 = x19 * x830
    x849 = x66 * (-x840 - x848)
    x850 = x327 * x833 + x849
    x851 = x66 * (-x837 - x844)
    x852 = x3 * x833
    x853 = -2.0 * x1 * x22 * x25 * x29 * x39 * x5 * x828 + x16 * x87
    x854 = -x853
    x855 = x44 * x854
    x856 = -x30 * x833 + x7 * x855
    x857 = -x856
    x858 = x68 * x857 + x852
    x859 = x68 * x852 + x68 * x858 + x851
    x860 = x1 * (-x839 + x847) + x3 * x850 + x68 * x859
    x861 = -2.0 * x1 * x22 * x25 * x29 * x5 * x828 * x97 + x105 * x16
    x862 = -x861
    x863 = x44 * x862
    x864 = -2.0 * x1 * x22 * x25 * x29 * x5 * x828 * x99 + x16 * x98
    x865 = -x863 - x864
    x866 = -x36 * x865
    x867 = -x864
    x868 = -x30 * x867 + x7 * x863
    x869 = -x868
    x870 = x44 * x841
    x871 = -x861 - x870
    x872 = x36 * x871
    x873 = -x30 * x862 + x7 * x870
    x874 = -x873
    x875 = x44 * x845
    x876 = x7 * x875
    x877 = x30 * x874 + x872 - x876
    x878 = x44 * x874
    x879 = x7 * x878
    x880 = x66 * (-x19 * x877 + x30 * x869 - x866 - x879)
    x881 = -x36 * x871
    x882 = -x840 - x843
    x883 = x36 * x882
    x884 = x44 * x836
    x885 = x7 * x884
    x886 = x30 * x845 + x883 - x885
    x887 = x19 * x886
    x888 = x66 * (x30 * x874 - x876 - x881 - x887)
    x889 = x3 * x836
    x890 = 2.0 * x889
    x891 = x36 * (-x829 - x834)
    x892 = x44 * x857
    x893 = x30 * x836 - x7 * x892 + x891
    x894 = x19 * x893
    x895 = x7 * x894 + x890
    x896 = x19 * x895
    x897 = x3 * x845
    x898 = 2.0 * x897
    x899 = x7 * x887 + x898
    x900 = -x36 * x882
    x901 = x66 * (x30 * x845 - x885 - x894 - x900)
    x902 = x3 * x857
    x903 = 2.0 * x902
    x904 = x36 * (-x832 - x855)
    x905 = 2.0 * x1 * x22 * x25 * x29 * x5 * x828 * x86 - x148 * x16
    x906 = x44 * x905
    x907 = x30 * x854 - x7 * x906
    x908 = x44 * x907
    x909 = x30 * x857 - x7 * x908 + x904
    x910 = x68 * x909 + x903
    x911 = x68 * x910 + x69 * x858 + x901
    x912 = x1 * (-x896 + x899) + x68 * x911 + x69 * x859
    x913 = (
        x142 * (-x19 * (x69 * x838 + x7 * x896 + x888) + x68 * x899 + x69 * x847 + x880)
        + x68 * x912
        + x69 * x860
    )
    x914 = x181 * x24 + x913
    x915 = x1 * (x18 * x4 * x7 * x841 - x563 * x830) + x68 * x850
    x916 = x66 * (-x19 * x874 - x868)
    x917 = x66 * (-x846 - x873)
    x918 = (
        x142 * (-x19 * (x68 * x831 + x7 * x839 + x917) + x68 * x842 + x68 * x847 + x916)
        + x3 * x915
        + x68 * x860
    )
    x919 = x187 * x24 + x918
    x920 = x0 * x919 + x914
    x921 = x66 * (-x19 * x862 - x864)
    x922 = x19 * x841
    x923 = x66 * (-x861 - x922)
    x924 = x142 * (-x19 * (x327 * x830 + x923) + x327 * x841 + x921) + x68 * x915
    x925 = x195 * x24 + x924
    x926 = x36 * x865
    x927 = -x873 - x875
    x928 = x199 * x886
    x929 = x66 * (
        -x19 * (x119 * x927 + x30 * x877 - x928)
        - x199 * x877
        + x30 * (x30 * x869 - x879 + x926)
        + 2.0 * x36 * (-x868 - x878)
    )
    x930 = -x844 - x884
    x931 = x199 * x893
    x932 = x119 * x930 + x30 * x886 - x931
    x933 = x19 * x932
    x934 = x66 * (x30 * x877 + 2.0 * x36 * x927 - x928 - x933)
    x935 = x3 * x893
    x936 = 3.0 * x935
    x937 = x119 * (-x835 - x892) - x199 * x909 + x30 * x893
    x938 = x19 * x937
    x939 = x19 * (x7 * x938 + x936)
    x940 = x3 * x886
    x941 = 3.0 * x940
    x942 = x7 * x933 + x941
    x943 = x66 * (x30 * x886 + 2.0 * x36 * x930 - x931 - x938)
    x944 = x3 * x909
    x945 = 3.0 * x944
    x946 = x36 * (-x853 - x906)
    x947 = 2.0 * x1 * x147 * x22 * x25 * x29 * x5 * x828 - x16 * x221
    x948 = (
        x119 * (-x856 - x908)
        - x199 * (-x199 * (-x199 * x947 + x30 * x905) + x30 * x907 + x946)
        + x30 * x909
    )
    x949 = x226 * x937
    x950 = x226 * x893
    x951 = x226 * x836
    x952 = x1 * (x13 * x18 * x4 * x845 - x951)
    x953 = x228 * x852
    x954 = x229 * x857 + x953
    x955 = x229 * x852 + x68 * x954 + 0.5 * x952
    x956 = x1 * (x13 * x18 * x4 * x886 - x950)
    x957 = x228 * x903 + x229 * x909
    x958 = x68 * x957 + x69 * x954 + 0.5 * x956
    x959 = (
        x1 * (-x19 * (x228 * x890 + x7 * x950) + x228 * x898 + x229 * x886)
        + x68 * x958
        + x69 * x955
    )
    x960 = x24 * x249 + x959
    x961 = x228 * x831
    x962 = x228 * x842
    x963 = x1 * (x13 * x18 * x4 * x841 - x226 * x830)
    x964 = x13 * x334
    x965 = x11 * x964
    x966 = x833 * x965 + 0.5 * x963
    x967 = x1 * (-x19 * (x7 * x951 + x961) + x229 * x845 + x962) + x3 * x966 + x68 * x955
    x968 = x24 * x260 + x967
    x969 = x0 * x968 + x960
    x970 = x7 * x964
    x971 = x1 * (x13 * x223 * x224 * x7 * x841 - x830 * x970) + x68 * x966
    x972 = x24 * x265 + x971
    x973 = x1 * (x13 * x18 * x4 * x932 - x949)
    x974 = x139 + x16 * x887
    x975 = x3 * x974
    x976 = x132 + x16 * x894
    x977 = x3 * x976
    x978 = x16 * x938 + x207
    x979 = x19 * x978
    x980 = x16 * x933 + x213
    x981 = x16 * x846 + x55
    x982 = x3 * x981
    x983 = 2.0 * x982
    x984 = x16 * x837 + x34
    x985 = x3 * x984
    x986 = 2.0 * x985
    x987 = x19 * x976
    x988 = x19 * x984
    x989 = x1 * (x981 - x988)
    x990 = 0.5 * x989
    x991 = x269 * x833 + x71
    x992 = x3 * x991
    x993 = x269 * x857 + x82
    x994 = x68 * x993 + x992
    x995 = x68 * x992 + x68 * x994 + x990
    x996 = x1 * (x974 - x987)
    x997 = 0.5 * x996
    x998 = x3 * x993
    x999 = 2.0 * x998
    x1000 = x144 + x269 * x909
    x1001 = x1000 * x68 + x999
    x1002 = x1001 * x68 + x69 * x994 + x997
    x1003 = (
        x1 * (-x19 * (x7 * x987 + x986) + x68 * x974 + x983) + x1002 * x68 + x69 * x995
    )
    x1004 = x1003 + x24 * x289
    x1005 = x16 * x922 + x165
    x1006 = x1005 * x3
    x1007 = x16 * x848 + x160
    x1008 = x1007 * x3
    x1009 = x1007 * x19
    x1010 = x1 * (x1005 - x1009)
    x1011 = 0.5 * x1010
    x1012 = x1011 + x327 * x991
    x1013 = (
        x1 * (x1006 - x19 * (x1008 + x7 * x988) + x68 * x981) + x1012 * x3 + x68 * x995
    )
    x1014 = x1013 + x24 * x298
    x1015 = x0 * x1014 + x1004
    x1016 = x1 * (x1005 * x18 * x4 * x7 - x1007 * x563) + x1012 * x68
    x1017 = x1016 + x24 * x301
    x1018 = x1 * (-x979 + x980)
    x1019 = 0.5 * x1018
    x1020 = x1000 * x3
    x1021 = 3.0 * x1020
    x1022 = x217 + x269 * x948
    x1023 = -x19 * (x304 * x893 + x888) + x304 * x886 + x880
    x1024 = x304 * x833 + x849
    x1025 = x1024 * x3
    x1026 = x304 * x857 + x851
    x1027 = x1025 + x1026 * x68
    x1028 = x1026 * x3
    x1029 = x304 * x909 + x901
    x1030 = 2.0 * x1028 + x1029 * x68
    x1031 = x1023 * x66 + x1027 * x69 + x1030 * x68
    x1032 = x1031 + x24 * x319
    x1033 = -x19 * (x304 * x836 + x917) + x304 * x845 + x916
    x1034 = x1025 * x68 + x1027 * x68 + x1033 * x66
    x1035 = x1034 + x24 * x322
    x1036 = x0 * x1035 + x1032
    x1037 = -x19 * (x304 * x830 + x923) + x304 * x841 + x921
    x1038 = x1024 * x327 + x1037 * x66
    x1039 = x1038 + x24 * x328
    x1040 = -x19 * (x304 * x937 + x934) + x304 * x932 + x929
    x1041 = x1029 * x3
    x1042 = x304 * x948 + x943
    x1043 = x1 * (x13 * x18 * x4 * x974 - x226 * x976)
    x1044 = x228 * x992
    x1045 = x1044 + x229 * x993
    x1046 = x1000 * x229 + x228 * x999
    x1047 = 0.5 * x1043 + x1045 * x69 + x1046 * x68
    x1048 = x1047 + x24 * x346
    x1049 = x1 * (x13 * x18 * x4 * x981 - x226 * x984)
    x1050 = x1045 * x68 + 0.5 * x1049 + x229 * x992
    x1051 = x1050 + x24 * x350
    x1052 = x0 * x1051 + x1048
    x1053 = x1 * (x1005 * x13 * x18 * x4 - x1007 * x226)
    x1054 = 0.5 * x1053 + x965 * x991
    x1055 = x1054 + x24 * x354
    x1056 = x1 * (x13 * x18 * x4 * x980 - x226 * x978)
    x1057 = -x19 * (x16 * x987 + x685 + x888) + x269 * x974 + x686 + x880
    x1058 = x1057 * x66
    x1059 = x269 * x991 + x276 + x849
    x1060 = x1059 * x3
    x1061 = x269 * x993 + x690 + x851
    x1062 = x1060 + x1061 * x68
    x1063 = x1061 * x3
    x1064 = 2.0 * x1063
    x1065 = x1000 * x269 + x694 + x901
    x1066 = x1064 + x1065 * x68
    x1067 = x1058 + x1062 * x69 + x1066 * x68
    x1068 = x1067 + x24 * x374
    x1069 = -x19 * (x16 * x988 + x699 + x917) + x269 * x981 + x700 + x916
    x1070 = x1069 * x66
    x1071 = x1060 * x68 + x1062 * x68 + x1070
    x1072 = x1071 + x24 * x378
    x1073 = x0 * x1072 + x1068
    x1074 = x1005 * x269 - x19 * (x1009 * x16 + x292 + x923) + x293 + x921
    x1075 = x1074 * x66
    x1076 = x1059 * x327 + x1075
    x1077 = x1076 + x24 * x383
    x1078 = -x19 * (x16 * x979 + x708 + x934) + x269 * x980 + x709 + x929
    x1079 = x1078 * x66
    x1080 = x1065 * x3
    x1081 = 3.0 * x1080
    x1082 = x1022 * x269 + x711 + x943
    x1083 = x1026 * x228 + x952
    x1084 = x1083 * x3
    x1085 = x1029 * x228 + x956
    x1086 = 2.0 * x1084 + x1085 * x68
    x1087 = x1086 + x24 * x395
    x1088 = x1024 * x228 + x963
    x1089 = x1088 * x3
    x1090 = x1083 * x68 + x1089
    x1091 = x1090 + x24 * x399
    x1092 = x0 * x1091 + x1087
    x1093 = x1088 * x68
    x1094 = x24 * x68
    x1095 = x1093 + x1094 * x397
    x1096 = x1085 * x3
    x1097 = x1042 * x228 + x973
    x1098 = x304 * x993 + x990
    x1099 = x1098 * x3
    x1100 = x1000 * x304 + x997
    x1101 = 2.0 * x1099 + x1100 * x68
    x1102 = x1101 + x24 * x412
    x1103 = x1011 + x304 * x991
    x1104 = x1103 * x3
    x1105 = x1098 * x68 + x1104
    x1106 = x1105 + x24 * x416
    x1107 = x0 * x1106 + x1102
    x1108 = x1103 * x68
    x1109 = x1094 * x414 + x1108
    x1110 = x1100 * x3
    x1111 = x1019 + x1022 * x304
    x1112 = x1064 * x228 + x1065 * x229
    x1113 = x1112 + x24 * x422
    x1114 = x1060 * x228
    x1115 = x1061 * x229 + x1114
    x1116 = x1115 + x24 * x425
    x1117 = x0 * x1116 + x1113
    x1118 = x1059 * x229
    x1119 = x1118 + x24 * x428
    x1120 = x1061 * x269 + x360 + x989
    x1121 = x1120 * x3
    x1122 = 2.0 * x1121
    x1123 = x1065 * x269 + x364 + x996
    x1124 = x1122 + x1123 * x68
    x1125 = x1124 + x24 * x435
    x1126 = x1010 + x1059 * x269 + x372
    x1127 = x1126 * x3
    x1128 = x1120 * x68 + x1127
    x1129 = x1128 + x24 * x439
    x1130 = x0 * x1129 + x1125
    x1131 = x1126 * x68
    x1132 = x1094 * x437 + x1131
    x1133 = x1123 * x3
    x1134 = x1018 + x1082 * x269 + x386
    x1135 = x1023 * x142 + x1085 * x228
    x1136 = x1135 + x24 * x445
    x1137 = x1033 * x142 + x1083 * x228
    x1138 = x1137 + x24 * x447
    x1139 = x0 * x1138 + x1136
    x1140 = x1037 * x142 + x1088 * x228
    x1141 = x1140 + x24 * x450
    x1142 = x1043 + x1100 * x228
    x1143 = x1142 + x24 * x452
    x1144 = x1049 + x1098 * x228
    x1145 = x1144 + x24 * x454
    x1146 = x0 * x1145 + x1143
    x1147 = x1053 + x1103 * x228
    x1148 = x1147 + x24 * x457
    x1149 = x1058 + x1065 * x304
    x1150 = x1149 + x24 * x459
    x1151 = x1061 * x304 + x1070
    x1152 = x1151 + x24 * x461
    x1153 = x0 * x1152 + x1150
    x1154 = x1059 * x304 + x1075
    x1155 = x1154 + x24 * x464
    x1156 = x1123 * x228
    x1157 = x1156 + x24 * x466
    x1158 = x1120 * x228
    x1159 = x1158 + x24 * x468
    x1160 = x0 * x1159 + x1157
    x1161 = x1126 * x228
    x1162 = x1161 + x24 * x471
    x1163 = x1057 * x142 + x1123 * x269 + x430
    x1164 = x1163 + x24 * x473
    x1165 = x1069 * x142 + x1120 * x269 + x434
    x1166 = x1165 + x24 * x475
    x1167 = x0 * x1166 + x1164
    x1168 = x1074 * x142 + x1126 * x269 + x438
    x1169 = x1168 + x24 * x478
    x1170 = x13 * x485
    x1171 = -x1170 + x38 + x479 * x481
    x1172 = x13 * x494
    x1173 = -x1172 + x479 * x492 + x59
    x1174 = x1171 * x19
    x1175 = x1172 - x479 * x492 + x79
    x1176 = x66 * (-x1174 - x1175)
    x1177 = x13 * x506
    x1178 = -x1177 + x479 * x484 + x85
    x1179 = x1176 + x1178 * x327
    x1180 = x1 * (-x1171 * x563 + x1173 * x18 * x4 * x7) + x1179 * x68
    x1181 = x13 * x520
    x1182 = x114 - x1181 + x479 * x513
    x1183 = x1173 * x44
    x1184 = -x1182 * x30 + x1183 * x7
    x1185 = -x1184
    x1186 = x13 * x514
    x1187 = x102 - x1186 + x479 * x517
    x1188 = x1182 * x44
    x1189 = -x1187 * x30 + x1188 * x7
    x1190 = x66 * (-x1185 * x19 - x1189)
    x1191 = x1171 * x44
    x1192 = -x1173 * x30 + x1191 * x7
    x1193 = -x1192
    x1194 = x1193 * x19
    x1195 = x66 * (-x1184 - x1194)
    x1196 = x1171 * x3
    x1197 = x1178 * x44
    x1198 = x1171 * x30 - x1197 * x7
    x1199 = x1198 * x19
    x1200 = x1196 + x1199 * x7
    x1201 = x1200 * x19
    x1202 = x1173 * x3
    x1203 = x1194 * x7 + x1202
    x1204 = x66 * (-x1192 - x1199)
    x1205 = x1178 * x3
    x1206 = -x13 * x554 + x146 + x479 * x505
    x1207 = x1206 * x44
    x1208 = x1178 * x30 - x1207 * x7
    x1209 = x1205 + x1208 * x68
    x1210 = x1204 + x1205 * x68 + x1209 * x68
    x1211 = x1 * (-x1201 + x1203) + x1179 * x3 + x1210 * x68
    x1212 = (
        x1180 * x3
        + x1211 * x68
        + x142
        * (x1190 + x1202 * x68 + x1203 * x68 - x19 * (x1195 + x1196 * x68 + x1201 * x7))
    )
    x1213 = x1212 + x23 * x567
    x1214 = x1213 + x23 * x568
    x1215 = x1186 + x175 - x479 * x517
    x1216 = x66 * (-x1182 * x19 - x1215)
    x1217 = x1173 * x19
    x1218 = x1181 + x178 - x479 * x513
    x1219 = x66 * (-x1217 - x1218)
    x1220 = x1180 * x68 + x142 * (x1173 * x327 + x1216 - x19 * (x1171 * x327 + x1219))
    x1221 = x1220 + x23 * x573
    x1222 = x1221 + x23 * x574
    x1223 = -x1188 - x1215
    x1224 = -x1183 - x1218
    x1225 = x1224 * x36
    x1226 = x1193 * x199
    x1227 = x66 * (
        -x1185 * x199 - x1189 * x30 + x1223 * x36 - x19 * (x1185 * x30 + x1225 - x1226)
    )
    x1228 = -x1175 - x1191
    x1229 = x1228 * x36
    x1230 = x1198 * x199
    x1231 = x1193 * x30 + x1229 - x1230
    x1232 = x1231 * x19
    x1233 = x66 * (x1185 * x30 + x1224 * x36 - x1226 - x1232)
    x1234 = x1198 * x3
    x1235 = 2.0 * x1234
    x1236 = x36 * (-x1170 - x1197 - x209 + x479 * x481)
    x1237 = x1198 * x30 - x1208 * x199 + x1236
    x1238 = x1237 * x19
    x1239 = x19 * (x1235 + x1238 * x7)
    x1240 = x1193 * x3
    x1241 = 2.0 * x1240
    x1242 = x1232 * x7 + x1241
    x1243 = x66 * (x1193 * x30 + x1228 * x36 - x1230 - x1238)
    x1244 = x1208 * x3
    x1245 = 2.0 * x1244
    x1246 = x36 * (-x1177 - x1207 - x219 + x479 * x484)
    x1247 = x13 * x44
    x1248 = -x1247 * x596 + x220 + x479 * x553
    x1249 = x1208 * x30 + x1246 - x199 * (x1206 * x30 - x1248 * x199)
    x1250 = x1194 * x13 + x547
    x1251 = x1199 * x13 + x539
    x1252 = 2.0 * x584
    x1253 = x19 * (x1238 * x13 + x1252)
    x1254 = 2.0 * x589
    x1255 = x1232 * x13 + x1254
    x1256 = 2.0 * x493
    x1257 = x1217 * x13 + x1256
    x1258 = x1257 * x3
    x1259 = 2.0 * x482
    x1260 = x1174 * x13 + x1259
    x1261 = x1260 * x3
    x1262 = x1251 * x19
    x1263 = x1260 * x19
    x1264 = x1 * (x1257 - x1263)
    x1265 = 2.0 * x503
    x1266 = x1178 * x228 + x1265
    x1267 = 0.5 * x1264 + x1266 * x327
    x1268 = x1 * (x1250 - x1262)
    x1269 = x1266 * x3
    x1270 = x1208 * x228 + x551
    x1271 = x1269 + x1270 * x68
    x1272 = 0.5 * x1268 + x1269 * x68 + x1271 * x68
    x1273 = (
        x1 * (x1250 * x68 + x1258 - x19 * (x1261 + x1262 * x7)) + x1267 * x3 + x1272 * x68
    )
    x1274 = x1273 + x23 * x628
    x1275 = x1274 + x23 * x629
    x1276 = x1 * (x1257 * x18 * x4 * x7 - x1260 * x563) + x1267 * x68
    x1277 = x1276 + x23 * x631
    x1278 = x1277 + x23 * x632
    x1279 = x1 * (-x1253 + x1255)
    x1280 = 2.0 * x593
    x1281 = x1249 * x228 + x1280
    x1282 = x1237 * x267
    x1283 = x1198 * x267
    x1284 = x1196 * x269
    x1285 = x1202 * x269
    x1286 = x1 * (-x1171 * x267 + x1173 * x16 * x18 * x4)
    x1287 = 0.5 * x1286
    x1288 = x1178 * x656 + x1287
    x1289 = x1 * (x1193 * x16 * x18 * x4 - x1283)
    x1290 = 0.5 * x1289
    x1291 = x1205 * x269
    x1292 = x1208 * x270 + x1291
    x1293 = x1205 * x270 + x1290 + x1292 * x68
    x1294 = (
        x1 * (x1193 * x270 + x1285 - x19 * (x1283 * x7 + x1284))
        + x1288 * x3
        + x1293 * x68
    )
    x1295 = x1294 + x23 * x658
    x1296 = x1295 + x23 * x659
    x1297 = x1 * (-x1171 * x661 + x1173 * x16 * x223 * x224 * x7) + x1288 * x68
    x1298 = x1297 + x23 * x662
    x1299 = x1298 + x23 * x663
    x1300 = x1 * (x1231 * x16 * x18 * x4 - x1282)
    x1301 = 0.5 * x1300
    x1302 = x1190 + x1250 * x228 - x19 * (x1195 + x1262 * x13 + x605) + x603
    x1303 = x1176 + x1266 * x228 + 2.0 * x610
    x1304 = x1303 * x3
    x1305 = x1204 + x1270 * x228 + x615
    x1306 = x1304 + x1305 * x68
    x1307 = x1302 * x66 + x1304 * x68 + x1306 * x68
    x1308 = x1307 + x23 * x677
    x1309 = x1308 + x23 * x678
    x1310 = x1216 + x1257 * x228 - x19 * (x1219 + x1263 * x13 + 2.0 * x624) + 2.0 * x622
    x1311 = x1303 * x327 + x1310 * x66
    x1312 = x1311 + x23 * x681
    x1313 = x1312 + x23 * x682
    x1314 = x1227 + x1255 * x228 - x19 * (x1233 + x1253 * x13 + x599 * x69) + x598 * x69
    x1315 = x1243 + x1281 * x228 + x616 * x69
    x1316 = x1 * (x1193 * x338 - x19 * (x1198 * x338 + x637) + x638)
    x1317 = x1178 * x338 + x1265 * x269
    x1318 = x1317 * x3
    x1319 = x1208 * x338 + x647
    x1320 = x1318 + x1319 * x68
    x1321 = 0.5 * x1316 + x1318 * x68 + x1320 * x68
    x1322 = x1321 + x23 * x702
    x1323 = x1322 + x23 * x703
    x1324 = x1 * (x1173 * x338 + x1256 * x269 - x19 * (x1171 * x338 + x1259 * x269))
    x1325 = x1317 * x327 + 0.5 * x1324
    x1326 = x1325 + x23 * x706
    x1327 = x1326 + x23 * x707
    x1328 = x1 * (x1231 * x338 + x1254 * x269 - x19 * (x1237 * x338 + x1252 * x269))
    x1329 = x1249 * x338 + x1280 * x269
    x1330 = x1190 + x1193 * x356 - x19 * (x1195 + x1198 * x356)
    x1331 = x1330 * x66
    x1332 = x1176 + x1178 * x356
    x1333 = x1332 * x3
    x1334 = x1204 + x1208 * x356
    x1335 = x1333 + x1334 * x68
    x1336 = x1331 + x1333 * x68 + x1335 * x68
    x1337 = x1336 + x23 * x727
    x1338 = x1337 + x23 * x728
    x1339 = x1173 * x356 + x1216 - x19 * (x1171 * x356 + x1219)
    x1340 = x1339 * x66
    x1341 = x1332 * x327 + x1340
    x1342 = x1341 + x23 * x732
    x1343 = x1342 + x23 * x733
    x1344 = x1227 + x1231 * x356 - x19 * (x1233 + x1237 * x356)
    x1345 = x1344 * x66
    x1346 = x1334 * x3
    x1347 = x1243 + x1249 * x356
    x1348 = x1264 + x1303 * x228 + 2.0 * x668
    x1349 = x1348 * x3
    x1350 = x1268 + x1305 * x228 + x671
    x1351 = x1349 + x1350 * x68
    x1352 = x1351 + x23 * x745
    x1353 = x1352 + x23 * x746
    x1354 = x1348 * x68
    x1355 = x1354 + x23 * x748
    x1356 = x1355 + x23 * x750
    x1357 = x1279 + x1315 * x228 + x672 * x69
    x1358 = x1287 + x1317 * x228 + 2.0 * x689
    x1359 = x1358 * x3
    x1360 = x1290 + x1319 * x228 + x693
    x1361 = x1359 + x1360 * x68
    x1362 = x1361 + x23 * x759
    x1363 = x1362 + x23 * x760
    x1364 = x1358 * x68
    x1365 = x1364 + x23 * x762
    x1366 = x1365 + x23 * x763
    x1367 = x1301 + x1329 * x228 + x69 * x695
    x1368 = x1332 * x228 + 2.0 * x716
    x1369 = x1368 * x3
    x1370 = x1334 * x228 + x720
    x1371 = x1369 + x1370 * x68
    x1372 = x1371 + x23 * x772
    x1373 = x1372 + x23 * x773
    x1374 = x1368 * x68
    x1375 = x1374 + x23 * x775
    x1376 = x1375 + x23 * x776
    x1377 = x1347 * x228 + 2.0 * x736
    x1378 = x1286 + x1332 * x269
    x1379 = x1378 * x3
    x1380 = x1289 + x1334 * x269
    x1381 = x1379 + x1380 * x68
    x1382 = x1381 + x23 * x786
    x1383 = x1382 + x23 * x787
    x1384 = x1378 * x68
    x1385 = x1384 + x23 * x789
    x1386 = x1385 + x23 * x790
    x1387 = x1380 * x3
    x1388 = x1300 + x1347 * x269
    x1389 = x1302 * x142 + x1350 * x228 + x739
    x1390 = x1389 + x23 * x795
    x1391 = x1390 + x23 * x796
    x1392 = x1310 * x142 + x1348 * x228 + 2.0 * x744
    x1393 = x1392 + x23 * x798
    x1394 = x1393 + x23 * x799
    x1395 = x1316 + x1360 * x228 + x753
    x1396 = x1395 + x23 * x802
    x1397 = x1396 + x23 * x803
    x1398 = x1324 + x1358 * x228 + 2.0 * x758
    x1399 = x1398 + x23 * x805
    x1400 = x1399 + x23 * x806
    x1401 = x1331 + x1370 * x228 + x766
    x1402 = x1401 + x23 * x809
    x1403 = x1402 + x23 * x810
    x1404 = x1340 + x1368 * x228 + 2.0 * x771
    x1405 = x1404 + x23 * x812
    x1406 = x1405 + x23 * x813
    x1407 = x1380 * x228 + x780
    x1408 = x1407 + x23 * x816
    x1409 = x1408 + x23 * x817
    x1410 = x1378 * x228 + 2.0 * x785
    x1411 = x1410 + x23 * x819
    x1412 = x1411 + x23 * x820
    x1413 = x1330 * x142 + x1380 * x269
    x1414 = x1413 + x23 * x823
    x1415 = x1414 + x23 * x824
    x1416 = x1339 * x142 + x1378 * x269
    x1417 = x1416 + x23 * x826
    x1418 = x1417 + x23 * x827
    x1419 = x13 * x834 - x479 * x830
    x1420 = -x1419
    x1421 = x13 * x843 - x479 * x841
    x1422 = -x1421
    x1423 = x1420 * x19
    x1424 = x66 * (-x1421 - x1423)
    x1425 = x13 * x855 - x479 * x833
    x1426 = -x1425
    x1427 = x1424 + x1426 * x327
    x1428 = x1 * (-x1420 * x563 + x1422 * x18 * x4 * x7) + x1427 * x68
    x1429 = x13 * x870 - x479 * x862
    x1430 = -x1429
    x1431 = x1422 * x44
    x1432 = -x1430 * x30 + x1431 * x7
    x1433 = -x1432
    x1434 = x13 * x863 - x479 * x867
    x1435 = -x1434
    x1436 = x1430 * x44
    x1437 = -x1435 * x30 + x1436 * x7
    x1438 = x66 * (-x1433 * x19 - x1437)
    x1439 = x1420 * x44
    x1440 = -x1422 * x30 + x1439 * x7
    x1441 = -x1440
    x1442 = x1441 * x19
    x1443 = x66 * (-x1432 - x1442)
    x1444 = x1420 * x3
    x1445 = x1426 * x44
    x1446 = x1420 * x30 - x1445 * x7
    x1447 = x1446 * x19
    x1448 = x1444 + x1447 * x7
    x1449 = x1448 * x19
    x1450 = x1422 * x3
    x1451 = x1442 * x7 + x1450
    x1452 = x66 * (-x1440 - x1447)
    x1453 = x1426 * x3
    x1454 = -x13 * x906 + x479 * x854
    x1455 = x1454 * x44
    x1456 = x1426 * x30 - x1455 * x7
    x1457 = x1453 + x1456 * x68
    x1458 = x1452 + x1453 * x68 + x1457 * x68
    x1459 = x1 * (-x1449 + x1451) + x1427 * x3 + x1458 * x68
    x1460 = (
        x142
        * (x1438 + x1450 * x68 + x1451 * x68 - x19 * (x1443 + x1444 * x68 + x1449 * x7))
        + x1428 * x3
        + x1459 * x68
    )
    x1461 = x1460 + x24 * x567
    x1462 = x1461 + x23 * x919
    x1463 = x66 * (-x1430 * x19 - x1434)
    x1464 = x1422 * x19
    x1465 = x66 * (-x1429 - x1464)
    x1466 = x142 * (x1422 * x327 + x1463 - x19 * (x1420 * x327 + x1465)) + x1428 * x68
    x1467 = x1466 + x24 * x573
    x1468 = x1467 + x23 * x925
    x1469 = -x1434 - x1436
    x1470 = -x1429 - x1431
    x1471 = x1470 * x36
    x1472 = x1441 * x199
    x1473 = x66 * (
        -x1433 * x199 - x1437 * x30 + x1469 * x36 - x19 * (x1433 * x30 + x1471 - x1472)
    )
    x1474 = -x1421 - x1439
    x1475 = x1474 * x36
    x1476 = x1446 * x199
    x1477 = x19 * (x1441 * x30 + x1475 - x1476)
    x1478 = x66 * (x1433 * x30 + x1470 * x36 - x1472 - x1477)
    x1479 = x1446 * x69
    x1480 = x36 * (-x1419 - x1445)
    x1481 = x19 * (x1446 * x30 - x1456 * x199 + x1480)
    x1482 = x19 * (x1479 + x1481 * x7)
    x1483 = x1441 * x69
    x1484 = x1477 * x7 + x1483
    x1485 = x66 * (x1441 * x30 + x1474 * x36 - x1476 - x1481)
    x1486 = x1456 * x69
    x1487 = x36 * (-x1425 - x1455)
    x1488 = -x1247 * x947 + x479 * x905
    x1489 = x1456 * x30 + x1487 - x199 * (x1454 * x30 - x1488 * x199)
    x1490 = x13 * x1442 + x897
    x1491 = x1490 * x69
    x1492 = x13 * x1447 + x889
    x1493 = x1492 * x69
    x1494 = x19 * (x13 * x1481 + x935)
    x1495 = x13 * x1477 + x940
    x1496 = x13 * x1464 + x842
    x1497 = x1496 * x3
    x1498 = x13 * x1423 + x831
    x1499 = x1498 * x3
    x1500 = x1492 * x19
    x1501 = x1498 * x19
    x1502 = x1 * (x1496 - x1501)
    x1503 = x1426 * x228 + x852
    x1504 = 0.5 * x1502 + x1503 * x327
    x1505 = x1 * (x1490 - x1500)
    x1506 = x1503 * x3
    x1507 = x1456 * x228 + x902
    x1508 = x1506 + x1507 * x68
    x1509 = 0.5 * x1505 + x1506 * x68 + x1508 * x68
    x1510 = (
        x1 * (x1490 * x68 + x1497 - x19 * (x1499 + x1500 * x7)) + x1504 * x3 + x1509 * x68
    )
    x1511 = x1510 + x24 * x628
    x1512 = x1511 + x23 * x968
    x1513 = x1 * (x1496 * x18 * x4 * x7 - x1498 * x563) + x1504 * x68
    x1514 = x1513 + x24 * x631
    x1515 = x1514 + x23 * x972
    x1516 = x1 * (-x1494 + x1495)
    x1517 = x1507 * x69
    x1518 = x1489 * x228 + x944
    x1519 = x1442 * x16 + x546
    x1520 = x1519 * x69
    x1521 = x1447 * x16 + x538
    x1522 = x1521 * x69
    x1523 = x19 * (x1481 * x16 + x584)
    x1524 = x1477 * x16 + x589
    x1525 = x1464 * x16 + x493
    x1526 = x1525 * x3
    x1527 = x1423 * x16 + x482
    x1528 = x1527 * x3
    x1529 = x1521 * x19
    x1530 = x1527 * x19
    x1531 = x1 * (x1525 - x1530)
    x1532 = 0.5 * x1531
    x1533 = x1426 * x269 + x503
    x1534 = x1532 + x1533 * x327
    x1535 = x1 * (x1519 - x1529)
    x1536 = 0.5 * x1535
    x1537 = x1533 * x3
    x1538 = x1456 * x269 + x550
    x1539 = x1537 + x1538 * x68
    x1540 = x1536 + x1537 * x68 + x1539 * x68
    x1541 = (
        x1 * (x1519 * x68 + x1526 - x19 * (x1528 + x1529 * x7)) + x1534 * x3 + x1540 * x68
    )
    x1542 = x1541 + x24 * x658
    x1543 = x1014 * x23 + x1542
    x1544 = x1 * (x1525 * x18 * x4 * x7 - x1527 * x563) + x1534 * x68
    x1545 = x1544 + x24 * x662
    x1546 = x1017 * x23 + x1545
    x1547 = x1 * (-x1523 + x1524)
    x1548 = 0.5 * x1547
    x1549 = x1538 * x69
    x1550 = x1489 * x269 + x593
    x1551 = x1438 + x1490 * x228 - x19 * (x13 * x1500 + x1443 + x228 * x889) + x228 * x897
    x1552 = x1424 + x1503 * x228 + x953
    x1553 = x1552 * x3
    x1554 = x1452 + x1507 * x228 + x228 * x902
    x1555 = x1553 + x1554 * x68
    x1556 = x1551 * x66 + x1553 * x68 + x1555 * x68
    x1557 = x1556 + x24 * x677
    x1558 = x1035 * x23 + x1557
    x1559 = x1463 + x1496 * x228 - x19 * (x13 * x1501 + x1465 + x961) + x962
    x1560 = x1552 * x327 + x1559 * x66
    x1561 = x1560 + x24 * x681
    x1562 = x1039 * x23 + x1561
    x1563 = x1473 + x1495 * x228 - x19 * (x13 * x1494 + x1478 + x228 * x935) + x228 * x940
    x1564 = x1554 * x69
    x1565 = x1485 + x1518 * x228 + x228 * x944
    x1566 = x1 * (x1519 * x228 - x19 * (x13 * x1529 + x985) + x982)
    x1567 = x1533 * x228 + x992
    x1568 = x1567 * x3
    x1569 = x1538 * x228 + x998
    x1570 = x1568 + x1569 * x68
    x1571 = 0.5 * x1566 + x1568 * x68 + x1570 * x68
    x1572 = x1571 + x24 * x702
    x1573 = x1051 * x23 + x1572
    x1574 = x1 * (x1006 + x1525 * x228 - x19 * (x1008 + x13 * x1530))
    x1575 = x1567 * x327 + 0.5 * x1574
    x1576 = x1575 + x24 * x706
    x1577 = x1055 * x23 + x1576
    x1578 = x1 * (x1524 * x228 - x19 * (x13 * x1523 + x977) + x975)
    x1579 = x1569 * x69
    x1580 = x1020 + x1550 * x228
    x1581 = x1438 + x1519 * x269 - x19 * (x1443 + x1529 * x16 + x269 * x538) + x269 * x546
    x1582 = x1581 * x66
    x1583 = x1424 + x1533 * x269 + x642
    x1584 = x1583 * x3
    x1585 = x1452 + x1538 * x269 + x269 * x550
    x1586 = x1584 + x1585 * x68
    x1587 = x1582 + x1584 * x68 + x1586 * x68
    x1588 = x1587 + x24 * x727
    x1589 = x1072 * x23 + x1588
    x1590 = x1463 + x1525 * x269 - x19 * (x1465 + x1530 * x16 + x652) + x653
    x1591 = x1590 * x66
    x1592 = x1583 * x327 + x1591
    x1593 = x1592 + x24 * x732
    x1594 = x1077 * x23 + x1593
    x1595 = x1473 + x1524 * x269 - x19 * (x1478 + x1523 * x16 + x269 * x584) + x269 * x589
    x1596 = x1595 * x66
    x1597 = x1585 * x69
    x1598 = x1485 + x1550 * x269 + x269 * x593
    x1599 = x1025 + x1502 + x1552 * x228
    x1600 = x1599 * x3
    x1601 = x1028 + x1505 + x1554 * x228
    x1602 = x1600 + x1601 * x68
    x1603 = x1602 + x24 * x745
    x1604 = x1091 * x23 + x1603
    x1605 = x1599 * x68
    x1606 = x1605 + x24 * x748
    x1607 = x1095 * x23 + x1606
    x1608 = x1601 * x69
    x1609 = x1041 + x1516 + x1565 * x228
    x1610 = x1044 + x1532 + x1567 * x228
    x1611 = x1610 * x3
    x1612 = x1536 + x1569 * x228 + x228 * x998
    x1613 = x1611 + x1612 * x68
    x1614 = x1613 + x24 * x759
    x1615 = x1106 * x23 + x1614
    x1616 = x1610 * x68
    x1617 = x1616 + x24 * x762
    x1618 = x1109 * x23 + x1617
    x1619 = x1612 * x69
    x1620 = x1020 * x228 + x1548 + x1580 * x228
    x1621 = x1060 + x1583 * x228
    x1622 = x1621 * x3
    x1623 = x1063 + x1585 * x228
    x1624 = x1622 + x1623 * x68
    x1625 = x1624 + x24 * x772
    x1626 = x1116 * x23 + x1625
    x1627 = x1621 * x68
    x1628 = x1627 + x24 * x775
    x1629 = x1119 * x23 + x1628
    x1630 = x1623 * x69
    x1631 = x1080 + x1598 * x228
    x1632 = x1531 + x1583 * x269 + x716
    x1633 = x1632 * x3
    x1634 = x1535 + x1585 * x269 + x719
    x1635 = x1633 + x1634 * x68
    x1636 = x1635 + x24 * x786
    x1637 = x1129 * x23 + x1636
    x1638 = x1632 * x68
    x1639 = x1638 + x24 * x789
    x1640 = x1132 * x23 + x1639
    x1641 = x1634 * x69
    x1642 = x1547 + x1598 * x269 + x736
    x1643 = x1084 + x142 * x1551 + x1601 * x228
    x1644 = x1643 + x24 * x795
    x1645 = x1138 * x23 + x1644
    x1646 = x1089 + x142 * x1559 + x1599 * x228
    x1647 = x1646 + x24 * x798
    x1648 = x1141 * x23 + x1647
    x1649 = x1099 + x1566 + x1612 * x228
    x1650 = x1649 + x24 * x802
    x1651 = x1145 * x23 + x1650
    x1652 = x1104 + x1574 + x1610 * x228
    x1653 = x1652 + x24 * x805
    x1654 = x1148 * x23 + x1653
    x1655 = x1063 * x228 + x1582 + x1623 * x228
    x1656 = x1655 + x24 * x809
    x1657 = x1152 * x23 + x1656
    x1658 = x1114 + x1591 + x1621 * x228
    x1659 = x1658 + x24 * x812
    x1660 = x1155 * x23 + x1659
    x1661 = x1121 + x1634 * x228
    x1662 = x1661 + x24 * x816
    x1663 = x1159 * x23 + x1662
    x1664 = x1127 + x1632 * x228
    x1665 = x1664 + x24 * x819
    x1666 = x1162 * x23 + x1665
    x1667 = x142 * x1581 + x1634 * x269 + x779
    x1668 = x1667 + x24 * x823
    x1669 = x1166 * x23 + x1668
    x1670 = x142 * x1590 + x1632 * x269 + x785
    x1671 = x1670 + x24 * x826
    x1672 = x1169 * x23 + x1671
    x1673 = x16 * x834
    x1674 = -x1673 + x38 + x828 * x830
    x1675 = x16 * x843
    x1676 = -x1675 + x59 + x828 * x841
    x1677 = x1674 * x19
    x1678 = x1675 + x79 - x828 * x841
    x1679 = x66 * (-x1677 - x1678)
    x1680 = x16 * x855
    x1681 = -x1680 + x828 * x833 + x85
    x1682 = x1679 + x1681 * x327
    x1683 = x1 * (-x1674 * x563 + x1676 * x18 * x4 * x7) + x1682 * x68
    x1684 = x16 * x870
    x1685 = x114 - x1684 + x828 * x862
    x1686 = x1676 * x44
    x1687 = -x1685 * x30 + x1686 * x7
    x1688 = -x1687
    x1689 = x16 * x863
    x1690 = x102 - x1689 + x828 * x867
    x1691 = x1685 * x44
    x1692 = -x1690 * x30 + x1691 * x7
    x1693 = x66 * (-x1688 * x19 - x1692)
    x1694 = x1674 * x44
    x1695 = -x1676 * x30 + x1694 * x7
    x1696 = -x1695
    x1697 = x1696 * x19
    x1698 = x66 * (-x1687 - x1697)
    x1699 = x1674 * x3
    x1700 = x1681 * x44
    x1701 = x1674 * x30 - x1700 * x7
    x1702 = x1701 * x19
    x1703 = x1699 + x1702 * x7
    x1704 = x1703 * x19
    x1705 = x1676 * x3
    x1706 = x1697 * x7 + x1705
    x1707 = x66 * (-x1695 - x1702)
    x1708 = x1681 * x3
    x1709 = x146 - x16 * x906 + x828 * x854
    x1710 = x1709 * x44
    x1711 = x1681 * x30 - x1710 * x7
    x1712 = x1708 + x1711 * x68
    x1713 = x1707 + x1708 * x68 + x1712 * x68
    x1714 = x1 * (-x1704 + x1706) + x1682 * x3 + x1713 * x68
    x1715 = (
        x142
        * (x1693 + x1705 * x68 + x1706 * x68 - x19 * (x1698 + x1699 * x68 + x1704 * x7))
        + x1683 * x3
        + x1714 * x68
    )
    x1716 = x1715 + x24 * x918
    x1717 = x1716 + x24 * x919
    x1718 = x1689 + x175 - x828 * x867
    x1719 = x66 * (-x1685 * x19 - x1718)
    x1720 = x1676 * x19
    x1721 = x1684 + x178 - x828 * x862
    x1722 = x66 * (-x1720 - x1721)
    x1723 = x142 * (x1676 * x327 + x1719 - x19 * (x1674 * x327 + x1722)) + x1683 * x68
    x1724 = x1723 + x24 * x924
    x1725 = x1724 + x24 * x925
    x1726 = -x1691 - x1718
    x1727 = -x1726 * x36
    x1728 = -x1686 - x1721
    x1729 = x1728 * x36
    x1730 = x1696 * x199
    x1731 = x66 * (
        -x1688 * x199 - x1692 * x30 - x1727 - x19 * (x1688 * x30 + x1729 - x1730)
    )
    x1732 = -x1728 * x36
    x1733 = -x1678 - x1694
    x1734 = x1733 * x36
    x1735 = x1701 * x199
    x1736 = x1696 * x30 + x1734 - x1735
    x1737 = x1736 * x19
    x1738 = x66 * (x1688 * x30 - x1730 - x1732 - x1737)
    x1739 = x1701 * x3
    x1740 = 2.0 * x1739
    x1741 = x36 * (-x1673 - x1700 - x209 + x828 * x830)
    x1742 = x1701 * x30 - x1711 * x199 + x1741
    x1743 = x1742 * x19
    x1744 = x19 * (x1740 + x1743 * x7)
    x1745 = x1696 * x3
    x1746 = 2.0 * x1745
    x1747 = x1737 * x7 + x1746
    x1748 = -x1733 * x36
    x1749 = x66 * (x1696 * x30 - x1735 - x1743 - x1748)
    x1750 = x1711 * x3
    x1751 = 2.0 * x1750
    x1752 = x36 * (-x1680 - x1710 - x219 + x828 * x833)
    x1753 = x16 * x44
    x1754 = -x1753 * x947 + x220 + x828 * x905
    x1755 = x1711 * x30 + x1752 - x199 * (x1709 * x30 - x1754 * x199)
    x1756 = x1742 * x226
    x1757 = x1701 * x226
    x1758 = x1699 * x228
    x1759 = x1705 * x228
    x1760 = x1 * (x13 * x1676 * x18 * x4 - x1674 * x226)
    x1761 = x1681 * x965 + 0.5 * x1760
    x1762 = x1 * (x13 * x1696 * x18 * x4 - x1757)
    x1763 = x1708 * x228
    x1764 = x1711 * x229 + x1763
    x1765 = x1708 * x229 + 0.5 * x1762 + x1764 * x68
    x1766 = (
        x1 * (x1696 * x229 + x1759 - x19 * (x1757 * x7 + x1758))
        + x1761 * x3
        + x1765 * x68
    )
    x1767 = x1766 + x24 * x967
    x1768 = x1767 + x24 * x968
    x1769 = x1 * (x13 * x1676 * x223 * x224 * x7 - x1674 * x970) + x1761 * x68
    x1770 = x1769 + x24 * x971
    x1771 = x1770 + x24 * x972
    x1772 = x1 * (x13 * x1736 * x18 * x4 - x1756)
    x1773 = x16 * x1697 + x898
    x1774 = x1773 * x3
    x1775 = x16 * x1702 + x890
    x1776 = x1775 * x3
    x1777 = x16 * x1743 + 2.0 * x935
    x1778 = x1777 * x19
    x1779 = x16 * x1737 + 2.0 * x940
    x1780 = x16 * x1720 + 2.0 * x842
    x1781 = x1780 * x3
    x1782 = x16 * x1677 + 2.0 * x831
    x1783 = x1782 * x3
    x1784 = x1775 * x19
    x1785 = x1782 * x19
    x1786 = x1 * (x1780 - x1785)
    x1787 = 0.5 * x1786
    x1788 = x1681 * x269 + 2.0 * x852
    x1789 = x1787 + x1788 * x327
    x1790 = x1 * (x1773 - x1784)
    x1791 = 0.5 * x1790
    x1792 = x1788 * x3
    x1793 = x1711 * x269 + x903
    x1794 = x1792 + x1793 * x68
    x1795 = x1791 + x1792 * x68 + x1794 * x68
    x1796 = (
        x1 * (x1773 * x68 + x1781 - x19 * (x1783 + x1784 * x7)) + x1789 * x3 + x1795 * x68
    )
    x1797 = x1013 * x24 + x1796
    x1798 = x1014 * x24 + x1797
    x1799 = x1 * (x1780 * x18 * x4 * x7 - x1782 * x563) + x1789 * x68
    x1800 = x1016 * x24 + x1799
    x1801 = x1017 * x24 + x1800
    x1802 = x1 * (-x1778 + x1779)
    x1803 = 0.5 * x1802
    x1804 = x1793 * x3
    x1805 = 2.0 * x1804
    x1806 = x1755 * x269 + 2.0 * x944
    x1807 = x1693 + x1696 * x304 - x19 * (x1698 + x1701 * x304)
    x1808 = x1679 + x1681 * x304
    x1809 = x1808 * x3
    x1810 = x1707 + x1711 * x304
    x1811 = x1809 + x1810 * x68
    x1812 = x1807 * x66 + x1809 * x68 + x1811 * x68
    x1813 = x1034 * x24 + x1812
    x1814 = x1035 * x24 + x1813
    x1815 = x1676 * x304 + x1719 - x19 * (x1674 * x304 + x1722)
    x1816 = x1808 * x327 + x1815 * x66
    x1817 = x1038 * x24 + x1816
    x1818 = x1039 * x24 + x1817
    x1819 = x1731 + x1736 * x304 - x19 * (x1738 + x1742 * x304)
    x1820 = x1810 * x3
    x1821 = x1749 + x1755 * x304
    x1822 = x1 * (x13 * x1773 * x18 * x4 - x1775 * x226)
    x1823 = x1792 * x228
    x1824 = x1793 * x229 + x1823
    x1825 = x1792 * x229 + 0.5 * x1822 + x1824 * x68
    x1826 = x1050 * x24 + x1825
    x1827 = x1051 * x24 + x1826
    x1828 = x1 * (x13 * x1780 * x18 * x4 - x1782 * x226)
    x1829 = x1788 * x965 + 0.5 * x1828
    x1830 = x1054 * x24 + x1829
    x1831 = x1055 * x24 + x1830
    x1832 = x1 * (x13 * x1779 * x18 * x4 - x1777 * x226)
    x1833 = x1693 + x1773 * x269 - x19 * (x16 * x1784 + x1698 + x986) + x983
    x1834 = x1833 * x66
    x1835 = x1679 + x1788 * x269 + 2.0 * x992
    x1836 = x1835 * x3
    x1837 = x1707 + x1793 * x269 + x999
    x1838 = x1836 + x1837 * x68
    x1839 = x1834 + x1836 * x68 + x1838 * x68
    x1840 = x1071 * x24 + x1839
    x1841 = x1072 * x24 + x1840
    x1842 = 2.0 * x1006 + x1719 + x1780 * x269 - x19 * (2.0 * x1008 + x16 * x1785 + x1722)
    x1843 = x1842 * x66
    x1844 = x1835 * x327 + x1843
    x1845 = x1076 * x24 + x1844
    x1846 = x1077 * x24 + x1845
    x1847 = x1731 + x1779 * x269 - x19 * (x16 * x1778 + x1738 + 2.0 * x977) + 2.0 * x975
    x1848 = x1847 * x66
    x1849 = x1837 * x3
    x1850 = 2.0 * x1849
    x1851 = 2.0 * x1020 + x1749 + x1806 * x269
    x1852 = x1760 + x1808 * x228
    x1853 = x1852 * x3
    x1854 = x1762 + x1810 * x228
    x1855 = x1853 + x1854 * x68
    x1856 = x1090 * x24 + x1855
    x1857 = x1091 * x24 + x1856
    x1858 = x1852 * x68
    x1859 = x1093 * x24 + x1858
    x1860 = x1095 * x24 + x1859
    x1861 = x1854 * x3
    x1862 = x1772 + x1821 * x228
    x1863 = x1787 + x1788 * x304
    x1864 = x1863 * x3
    x1865 = x1791 + x1793 * x304
    x1866 = x1864 + x1865 * x68
    x1867 = x1105 * x24 + x1866
    x1868 = x1106 * x24 + x1867
    x1869 = x1863 * x68
    x1870 = x1108 * x24 + x1869
    x1871 = x1109 * x24 + x1870
    x1872 = x1865 * x3
    x1873 = x1803 + x1806 * x304
    x1874 = x1836 * x228
    x1875 = x1837 * x229 + x1874
    x1876 = x1115 * x24 + x1875
    x1877 = x1116 * x24 + x1876
    x1878 = x1835 * x229
    x1879 = x1118 * x24 + x1878
    x1880 = x1119 * x24 + x1879
    x1881 = 2.0 * x1060 + x1786 + x1835 * x269
    x1882 = x1881 * x3
    x1883 = x1064 + x1790 + x1837 * x269
    x1884 = x1882 + x1883 * x68
    x1885 = x1128 * x24 + x1884
    x1886 = x1129 * x24 + x1885
    x1887 = x1881 * x68
    x1888 = x1131 * x24 + x1887
    x1889 = x1132 * x24 + x1888
    x1890 = x1883 * x3
    x1891 = 2.0 * x1080 + x1802 + x1851 * x269
    x1892 = x142 * x1807 + x1854 * x228
    x1893 = x1137 * x24 + x1892
    x1894 = x1138 * x24 + x1893
    x1895 = x142 * x1815 + x1852 * x228
    x1896 = x1140 * x24 + x1895
    x1897 = x1141 * x24 + x1896
    x1898 = x1822 + x1865 * x228
    x1899 = x1144 * x24 + x1898
    x1900 = x1145 * x24 + x1899
    x1901 = x1828 + x1863 * x228
    x1902 = x1147 * x24 + x1901
    x1903 = x1148 * x24 + x1902
    x1904 = x1834 + x1837 * x304
    x1905 = x1151 * x24 + x1904
    x1906 = x1152 * x24 + x1905
    x1907 = x1835 * x304 + x1843
    x1908 = x1154 * x24 + x1907
    x1909 = x1155 * x24 + x1908
    x1910 = x1883 * x228
    x1911 = x1158 * x24 + x1910
    x1912 = x1159 * x24 + x1911
    x1913 = x1881 * x228
    x1914 = x1161 * x24 + x1913
    x1915 = x1162 * x24 + x1914
    x1916 = x1122 + x142 * x1833 + x1883 * x269
    x1917 = x1165 * x24 + x1916
    x1918 = x1166 * x24 + x1917
    x1919 = 2.0 * x1127 + x142 * x1842 + x1881 * x269
    x1920 = x1168 * x24 + x1919
    x1921 = x1169 * x24 + x1920
    x1922 = x1171 * x479 - x1197 * x13 + 2.0 * x540
    x1923 = x1191 * x13
    x1924 = x1173 * x479 - x1923 + 2.0 * x532
    x1925 = x19 * x1922
    x1926 = x66 * (x1173 * x479 - x1923 - x1925 + 2.0 * x36 * x531)
    x1927 = x1178 * x479 - x1207 * x13 + 2.0 * x552
    x1928 = x1926 + x1927 * x327
    x1929 = x1 * (x18 * x1924 * x4 * x7 - x1922 * x563) + x1928 * x68
    x1930 = x1183 * x13
    x1931 = x1182 * x479 - x1930 + 2.0 * x522
    x1932 = x1188 * x13
    x1933 = x66 * (x1187 * x479 - x19 * x1931 - x1932 + 2.0 * x36 * x516)
    x1934 = x19 * x1924
    x1935 = x66 * (x1182 * x479 - x1930 - x1934 + 2.0 * x36 * x521)
    x1936 = x142 * (-x19 * (x1922 * x327 + x1935) + x1924 * x327 + x1933) + x1929 * x68
    x1937 = x1220 * x23 + x1936
    x1938 = x1221 * x23 + x1937
    x1939 = x1222 * x23 + x1938
    x1940 = x1187 * x479 - x1932 + 2.0 * x575
    x1941 = x1924 * x199 - x1931 * x30
    x1942 = x66 * (x19 * x1941 - x1931 * x199 + x1940 * x30)
    x1943 = x1922 * x199 - x1924 * x30
    x1944 = -x1943
    x1945 = x19 * x1944
    x1946 = x66 * (-x1941 - x1945)
    x1947 = x1922 * x3
    x1948 = x1922 * x30 - x1927 * x199
    x1949 = x19 * x1948
    x1950 = x19 * (x1947 + x1949 * x7)
    x1951 = x1924 * x3
    x1952 = x1945 * x7 + x1951
    x1953 = x66 * (-x1943 - x1949)
    x1954 = x1927 * x3
    x1955 = x1206 * x479 - x1247 * x1248 + 2.0 * x595
    x1956 = x1927 * x30 - x1955 * x199
    x1957 = 3.0 * x1202
    x1958 = x13 * x1934 + x1957
    x1959 = x1958 * x3
    x1960 = 3.0 * x1196
    x1961 = x13 * x1925 + x1960
    x1962 = x1961 * x3
    x1963 = 3.0 * x1234
    x1964 = x19 * (x13 * x1949 + x1963)
    x1965 = 3.0 * x1240
    x1966 = x13 * x1945 + x1965
    x1967 = x19 * x1961
    x1968 = x1 * (x1958 - x1967)
    x1969 = 3.0 * x1205
    x1970 = x1927 * x228 + x1969
    x1971 = 0.5 * x1968 + x1970 * x327
    x1972 = x1 * (x18 * x1958 * x4 * x7 - x1961 * x563) + x1971 * x68
    x1973 = x1276 * x23 + x1972
    x1974 = x1277 * x23 + x1973
    x1975 = x1278 * x23 + x1974
    x1976 = x1 * (-x1964 + x1966)
    x1977 = x1970 * x3
    x1978 = 3.0 * x1244
    x1979 = x1956 * x228 + x1978
    x1980 = x1948 * x267
    x1981 = x1947 * x269
    x1982 = x1951 * x269
    x1983 = x1 * (x16 * x18 * x1924 * x4 - x1922 * x267)
    x1984 = 0.5 * x1983
    x1985 = x1927 * x656 + x1984
    x1986 = x1 * (x16 * x1924 * x223 * x224 * x7 - x1922 * x661) + x1985 * x68
    x1987 = x1297 * x23 + x1986
    x1988 = x1298 * x23 + x1987
    x1989 = x1299 * x23 + x1988
    x1990 = x1 * (x16 * x18 * x1944 * x4 - x1980)
    x1991 = 0.5 * x1990
    x1992 = x1954 * x269
    x1993 = 3.0 * x1258 - x19 * (3.0 * x1261 + x13 * x1967 + x1935) + x1933 + x1958 * x228
    x1994 = 3.0 * x1269 + x1926 + x1970 * x228
    x1995 = x1993 * x66 + x1994 * x327
    x1996 = x1311 * x23 + x1995
    x1997 = x1312 * x23 + x1996
    x1998 = x1313 * x23 + x1997
    x1999 = x1250 * x96 - x19 * (x1251 * x96 + x13 * x1964 + x1946) + x1942 + x1966 * x228
    x2000 = x1994 * x3
    x2001 = x1270 * x96 + x1953 + x1979 * x228
    x2002 = x1 * (-x19 * (x1922 * x338 + x1960 * x269) + x1924 * x338 + x1957 * x269)
    x2003 = x1927 * x338 + x1969 * x269
    x2004 = 0.5 * x2002 + x2003 * x327
    x2005 = x1325 * x23 + x2004
    x2006 = x1326 * x23 + x2005
    x2007 = x1327 * x23 + x2006
    x2008 = x1 * (-x19 * (x1948 * x338 + x1963 * x269) + x1944 * x338 + x1965 * x269)
    x2009 = x2003 * x3
    x2010 = x1956 * x338 + x1978 * x269
    x2011 = -x19 * (x1922 * x356 + x1935) + x1924 * x356 + x1933
    x2012 = x2011 * x66
    x2013 = x1926 + x1927 * x356
    x2014 = x2012 + x2013 * x327
    x2015 = x1341 * x23 + x2014
    x2016 = x1342 * x23 + x2015
    x2017 = x1343 * x23 + x2016
    x2018 = -x19 * (x1946 + x1948 * x356) + x1942 + x1944 * x356
    x2019 = x2018 * x66
    x2020 = x2013 * x3
    x2021 = x1953 + x1956 * x356
    x2022 = 3.0 * x1304 + x1968 + x1994 * x228
    x2023 = x2022 * x3
    x2024 = x2022 * x68
    x2025 = x1354 * x23 + x2024
    x2026 = x1355 * x23 + x2025
    x2027 = x1356 * x23 + x2026
    x2028 = x1305 * x96 + x1976 + x2001 * x228
    x2029 = 3.0 * x1318 + x1984 + x2003 * x228
    x2030 = x2029 * x3
    x2031 = x2029 * x68
    x2032 = x1364 * x23 + x2031
    x2033 = x1365 * x23 + x2032
    x2034 = x1366 * x23 + x2033
    x2035 = x1319 * x96 + x1991 + x2010 * x228
    x2036 = 3.0 * x1333 + x2013 * x228
    x2037 = x2036 * x3
    x2038 = x2036 * x68
    x2039 = x1374 * x23 + x2038
    x2040 = x1375 * x23 + x2039
    x2041 = x1376 * x23 + x2040
    x2042 = 3.0 * x1346 + x2021 * x228
    x2043 = x1983 + x2013 * x269
    x2044 = x2043 * x3
    x2045 = x2043 * x68
    x2046 = x1384 * x23 + x2045
    x2047 = x1385 * x23 + x2046
    x2048 = x1386 * x23 + x2047
    x2049 = x1990 + x2021 * x269
    x2050 = 3.0 * x1349 + x142 * x1993 + x2022 * x228
    x2051 = x1392 * x23 + x2050
    x2052 = x1393 * x23 + x2051
    x2053 = x1394 * x23 + x2052
    x2054 = 3.0 * x1359 + x2002 + x2029 * x228
    x2055 = x1398 * x23 + x2054
    x2056 = x1399 * x23 + x2055
    x2057 = x1400 * x23 + x2056
    x2058 = 3.0 * x1369 + x2012 + x2036 * x228
    x2059 = x1404 * x23 + x2058
    x2060 = x1405 * x23 + x2059
    x2061 = x1406 * x23 + x2060
    x2062 = 3.0 * x1379 + x2043 * x228
    x2063 = x1410 * x23 + x2062
    x2064 = x1411 * x23 + x2063
    x2065 = x1412 * x23 + x2064
    x2066 = x142 * x2011 + x2043 * x269
    x2067 = x1416 * x23 + x2066
    x2068 = x1417 * x23 + x2067
    x2069 = x1418 * x23 + x2068
    x2070 = -x13 * x1445 + x1420 * x479 + x891
    x2071 = x13 * x1439
    x2072 = x1422 * x479 - x2071 + x883
    x2073 = x19 * x2070
    x2074 = x66 * (x1422 * x479 - x2071 - x2073 - x900)
    x2075 = -x13 * x1455 + x1426 * x479 + x904
    x2076 = x2074 + x2075 * x327
    x2077 = x1 * (x18 * x2072 * x4 * x7 - x2070 * x563) + x2076 * x68
    x2078 = x13 * x1431
    x2079 = x1430 * x479 - x2078 + x872
    x2080 = x13 * x1436
    x2081 = x66 * (x1435 * x479 - x19 * x2079 - x2080 - x866)
    x2082 = x19 * x2072
    x2083 = x66 * (x1430 * x479 - x2078 - x2082 - x881)
    x2084 = x142 * (-x19 * (x2070 * x327 + x2083) + x2072 * x327 + x2081) + x2077 * x68
    x2085 = x1220 * x24 + x2084
    x2086 = x1467 * x23 + x2085
    x2087 = x1468 * x23 + x2086
    x2088 = x1435 * x479 - x2080 + x926
    x2089 = x199 * x2072 - x2079 * x30
    x2090 = x66 * (x19 * x2089 - x199 * x2079 + x2088 * x30)
    x2091 = x199 * x2070 - x2072 * x30
    x2092 = -x19 * x2091
    x2093 = x66 * (-x2089 - x2092)
    x2094 = x2070 * x3
    x2095 = x19 * (-x199 * x2075 + x2070 * x30)
    x2096 = x19 * (x2094 + x2095 * x7)
    x2097 = x2072 * x3
    x2098 = x2092 * x7 + x2097
    x2099 = x66 * (-x2091 - x2095)
    x2100 = x2075 * x3
    x2101 = -x1247 * x1488 + x1454 * x479 + x946
    x2102 = -x199 * x2101 + x2075 * x30
    x2103 = 2.0 * x1450
    x2104 = x13 * x2082 + x2103
    x2105 = x2104 * x3
    x2106 = 2.0 * x1444
    x2107 = x13 * x2073 + x2106
    x2108 = x2107 * x3
    x2109 = x19 * (x13 * x2095 + x1479)
    x2110 = x13 * x2092 + x1483
    x2111 = x19 * x2107
    x2112 = x1 * (x2104 - x2111)
    x2113 = 2.0 * x1453
    x2114 = x2075 * x228 + x2113
    x2115 = 0.5 * x2112 + x2114 * x327
    x2116 = x1 * (x18 * x2104 * x4 * x7 - x2107 * x563) + x2115 * x68
    x2117 = x1276 * x24 + x2116
    x2118 = x1514 * x23 + x2117
    x2119 = x1515 * x23 + x2118
    x2120 = x1 * (-x2109 + x2110)
    x2121 = x2114 * x3
    x2122 = x1486 + x2102 * x228
    x2123 = x1202 + x16 * x2082
    x2124 = x2123 * x3
    x2125 = x1196 + x16 * x2073
    x2126 = x2125 * x3
    x2127 = x19 * (x1234 + x16 * x2095)
    x2128 = x1240 + x16 * x2092
    x2129 = x19 * x2125
    x2130 = x1 * (x2123 - x2129)
    x2131 = 0.5 * x2130
    x2132 = x1205 + x2075 * x269
    x2133 = x2131 + x2132 * x327
    x2134 = x1 * (x18 * x2123 * x4 * x7 - x2125 * x563) + x2133 * x68
    x2135 = x1297 * x24 + x2134
    x2136 = x1545 * x23 + x2135
    x2137 = x1546 * x23 + x2136
    x2138 = x1 * (-x2127 + x2128)
    x2139 = 0.5 * x2138
    x2140 = x2132 * x3
    x2141 = x1244 + x2102 * x269
    x2142 = 2.0 * x1497 - x19 * (x13 * x2111 + 2.0 * x1499 + x2083) + x2081 + x2104 * x228
    x2143 = 2.0 * x1506 + x2074 + x2114 * x228
    x2144 = x2142 * x66 + x2143 * x327
    x2145 = x1311 * x24 + x2144
    x2146 = x1561 * x23 + x2145
    x2147 = x1562 * x23 + x2146
    x2148 = x1491 - x19 * (x13 * x2109 + x1493 + x2093) + x2090 + x2110 * x228
    x2149 = x2143 * x3
    x2150 = x1517 + x2099 + x2122 * x228
    x2151 = 2.0 * x1526
    x2152 = 2.0 * x1528
    x2153 = x1 * (-x19 * (x13 * x2129 + x2152) + x2123 * x228 + x2151)
    x2154 = 2.0 * x1537
    x2155 = x2132 * x228 + x2154
    x2156 = 0.5 * x2153 + x2155 * x327
    x2157 = x1325 * x24 + x2156
    x2158 = x1576 * x23 + x2157
    x2159 = x1577 * x23 + x2158
    x2160 = x1 * (x1520 - x19 * (x13 * x2127 + x1522) + x2128 * x228)
    x2161 = x2155 * x3
    x2162 = x1549 + x2141 * x228
    x2163 = x1285 - x19 * (x1284 + x16 * x2129 + x2083) + x2081 + x2123 * x269
    x2164 = x2163 * x66
    x2165 = x1291 + x2074 + x2132 * x269
    x2166 = x2164 + x2165 * x327
    x2167 = x1341 * x24 + x2166
    x2168 = x1593 * x23 + x2167
    x2169 = x1594 * x23 + x2168
    x2170 = (
        x1240 * x269 - x19 * (x1234 * x269 + x16 * x2127 + x2093) + x2090 + x2128 * x269
    )
    x2171 = x2170 * x66
    x2172 = x2165 * x3
    x2173 = x1244 * x269 + x2099 + x2141 * x269
    x2174 = 2.0 * x1553 + x2112 + x2143 * x228
    x2175 = x2174 * x3
    x2176 = x2174 * x68
    x2177 = x1354 * x24 + x2176
    x2178 = x1606 * x23 + x2177
    x2179 = x1607 * x23 + x2178
    x2180 = x1564 + x2120 + x2150 * x228
    x2181 = 2.0 * x1568 + x2131 + x2155 * x228
    x2182 = x2181 * x3
    x2183 = x2181 * x68
    x2184 = x1364 * x24 + x2183
    x2185 = x1617 * x23 + x2184
    x2186 = x1618 * x23 + x2185
    x2187 = x1579 + x2139 + x2162 * x228
    x2188 = 2.0 * x1584
    x2189 = x2165 * x228 + x2188
    x2190 = x2189 * x3
    x2191 = x2189 * x68
    x2192 = x1374 * x24 + x2191
    x2193 = x1628 * x23 + x2192
    x2194 = x1629 * x23 + x2193
    x2195 = x1597 + x2173 * x228
    x2196 = x1333 + x2130 + x2165 * x269
    x2197 = x2196 * x3
    x2198 = x2196 * x68
    x2199 = x1384 * x24 + x2198
    x2200 = x1639 * x23 + x2199
    x2201 = x1640 * x23 + x2200
    x2202 = x1346 + x2138 + x2173 * x269
    x2203 = x142 * x2142 + 2.0 * x1600 + x2174 * x228
    x2204 = x1392 * x24 + x2203
    x2205 = x1647 * x23 + x2204
    x2206 = x1648 * x23 + x2205
    x2207 = 2.0 * x1611 + x2153 + x2181 * x228
    x2208 = x1398 * x24 + x2207
    x2209 = x1653 * x23 + x2208
    x2210 = x1654 * x23 + x2209
    x2211 = 2.0 * x1622 + x2164 + x2189 * x228
    x2212 = x1404 * x24 + x2211
    x2213 = x1659 * x23 + x2212
    x2214 = x1660 * x23 + x2213
    x2215 = 2.0 * x1633
    x2216 = x2196 * x228 + x2215
    x2217 = x1410 * x24 + x2216
    x2218 = x1665 * x23 + x2217
    x2219 = x1666 * x23 + x2218
    x2220 = x1379 + x142 * x2163 + x2196 * x269
    x2221 = x1416 * x24 + x2220
    x2222 = x1671 * x23 + x2221
    x2223 = x1672 * x23 + x2222
    x2224 = -x13 * x1700 + x1674 * x479
    x2225 = x13 * x1694 - x1676 * x479
    x2226 = -x2225
    x2227 = x19 * x2224
    x2228 = x66 * (-x2225 - x2227)
    x2229 = -x13 * x1710 + x1681 * x479
    x2230 = x2228 + x2229 * x327
    x2231 = x1 * (x18 * x2226 * x4 * x7 - x2224 * x563) + x2230 * x68
    x2232 = x13 * x1686 - x1685 * x479
    x2233 = -x2232
    x2234 = x13 * x1691 - x1690 * x479
    x2235 = x66 * (-x19 * x2233 - x2234)
    x2236 = x19 * x2226
    x2237 = x66 * (-x2232 - x2236)
    x2238 = x142 * (-x19 * (x2224 * x327 + x2237) + x2226 * x327 + x2235) + x2231 * x68
    x2239 = x1466 * x24 + x2238
    x2240 = x1467 * x24 + x2239
    x2241 = x1725 * x23 + x2240
    x2242 = -x2234
    x2243 = x199 * x2226 - x2233 * x30
    x2244 = x66 * (x19 * x2243 - x199 * x2233 + x2242 * x30)
    x2245 = x199 * x2224 - x2226 * x30
    x2246 = -x19 * x2245
    x2247 = x66 * (-x2243 - x2246)
    x2248 = x2224 * x3
    x2249 = x19 * (-x199 * x2229 + x2224 * x30)
    x2250 = x19 * (x2248 + x2249 * x7)
    x2251 = x2226 * x3
    x2252 = x2246 * x7 + x2251
    x2253 = x66 * (-x2245 - x2249)
    x2254 = x2229 * x3
    x2255 = -x1247 * x1754 + x1709 * x479
    x2256 = -x199 * x2255 + x2229 * x30
    x2257 = x13 * x2236 + x1705
    x2258 = x2257 * x3
    x2259 = x13 * x2227 + x1699
    x2260 = x2259 * x3
    x2261 = x19 * (x13 * x2249 + x1739)
    x2262 = x13 * x2246 + x1745
    x2263 = x19 * x2259
    x2264 = x1 * (x2257 - x2263)
    x2265 = x1708 + x2229 * x228
    x2266 = 0.5 * x2264 + x2265 * x327
    x2267 = x1 * (x18 * x2257 * x4 * x7 - x2259 * x563) + x2266 * x68
    x2268 = x1513 * x24 + x2267
    x2269 = x1514 * x24 + x2268
    x2270 = x1771 * x23 + x2269
    x2271 = x1 * (-x2261 + x2262)
    x2272 = x2265 * x3
    x2273 = x1750 + x2256 * x228
    x2274 = x16 * x2236 + x2103
    x2275 = x2274 * x3
    x2276 = x16 * x2227 + x2106
    x2277 = x2276 * x3
    x2278 = x19 * (x1479 + x16 * x2249)
    x2279 = x1483 + x16 * x2246
    x2280 = x19 * x2276
    x2281 = x1 * (x2274 - x2280)
    x2282 = 0.5 * x2281
    x2283 = x2113 + x2229 * x269
    x2284 = x2282 + x2283 * x327
    x2285 = x1 * (x18 * x2274 * x4 * x7 - x2276 * x563) + x2284 * x68
    x2286 = x1544 * x24 + x2285
    x2287 = x1545 * x24 + x2286
    x2288 = x1801 * x23 + x2287
    x2289 = x1 * (-x2278 + x2279)
    x2290 = 0.5 * x2289
    x2291 = x2283 * x3
    x2292 = x1486 + x2256 * x269
    x2293 = x1759 - x19 * (x13 * x2263 + x1758 + x2237) + x2235 + x2257 * x228
    x2294 = x1763 + x2228 + x2265 * x228
    x2295 = x2293 * x66 + x2294 * x327
    x2296 = x1560 * x24 + x2295
    x2297 = x1561 * x24 + x2296
    x2298 = x1818 * x23 + x2297
    x2299 = (
        x1745 * x228 - x19 * (x13 * x2261 + x1739 * x228 + x2247) + x2244 + x2262 * x228
    )
    x2300 = x2294 * x3
    x2301 = x1750 * x228 + x2253 + x2273 * x228
    x2302 = x1 * (x1781 - x19 * (x13 * x2280 + x1783) + x2274 * x228)
    x2303 = x1792 + x228 * x2283
    x2304 = 0.5 * x2302 + x2303 * x327
    x2305 = x1575 * x24 + x2304
    x2306 = x1576 * x24 + x2305
    x2307 = x1831 * x23 + x2306
    x2308 = x1 * (x1774 - x19 * (x13 * x2278 + x1776) + x2279 * x228)
    x2309 = x2303 * x3
    x2310 = x1804 + x228 * x2292
    x2311 = -x19 * (x16 * x2280 + x2152 + x2237) + x2151 + x2235 + x2274 * x269
    x2312 = x2311 * x66
    x2313 = x2154 + x2228 + x2283 * x269
    x2314 = x2312 + x2313 * x327
    x2315 = x1592 * x24 + x2314
    x2316 = x1593 * x24 + x2315
    x2317 = x1846 * x23 + x2316
    x2318 = x1520 - x19 * (x1522 + x16 * x2278 + x2247) + x2244 + x2279 * x269
    x2319 = x2318 * x66
    x2320 = x2313 * x3
    x2321 = x1549 + x2253 + x2292 * x269
    x2322 = x1809 + x2264 + x228 * x2294
    x2323 = x2322 * x3
    x2324 = x2322 * x68
    x2325 = x1605 * x24 + x2324
    x2326 = x1606 * x24 + x2325
    x2327 = x1860 * x23 + x2326
    x2328 = x1820 + x2271 + x228 * x2301
    x2329 = x1823 + x228 * x2303 + x2282
    x2330 = x2329 * x3
    x2331 = x2329 * x68
    x2332 = x1616 * x24 + x2331
    x2333 = x1617 * x24 + x2332
    x2334 = x1871 * x23 + x2333
    x2335 = x1804 * x228 + x228 * x2310 + x2290
    x2336 = x1836 + x228 * x2313
    x2337 = x2336 * x3
    x2338 = x2336 * x68
    x2339 = x1627 * x24 + x2338
    x2340 = x1628 * x24 + x2339
    x2341 = x1880 * x23 + x2340
    x2342 = x1849 + x228 * x2321
    x2343 = x2188 + x2281 + x2313 * x269
    x2344 = x2343 * x3
    x2345 = x2343 * x68
    x2346 = x1638 * x24 + x2345
    x2347 = x1639 * x24 + x2346
    x2348 = x1889 * x23 + x2347
    x2349 = x1597 + x2289 + x2321 * x269
    x2350 = x142 * x2293 + x1853 + x228 * x2322
    x2351 = x1646 * x24 + x2350
    x2352 = x1647 * x24 + x2351
    x2353 = x1897 * x23 + x2352
    x2354 = x1864 + x228 * x2329 + x2302
    x2355 = x1652 * x24 + x2354
    x2356 = x1653 * x24 + x2355
    x2357 = x1903 * x23 + x2356
    x2358 = x1874 + x228 * x2336 + x2312
    x2359 = x1658 * x24 + x2358
    x2360 = x1659 * x24 + x2359
    x2361 = x1909 * x23 + x2360
    x2362 = x1882 + x228 * x2343
    x2363 = x1664 * x24 + x2362
    x2364 = x1665 * x24 + x2363
    x2365 = x1915 * x23 + x2364
    x2366 = x142 * x2311 + x2215 + x2343 * x269
    x2367 = x1670 * x24 + x2366
    x2368 = x1671 * x24 + x2367
    x2369 = x1921 * x23 + x2368
    x2370 = -x16 * x1700 + x1674 * x828 + 2.0 * x891
    x2371 = x16 * x1694
    x2372 = x1676 * x828 - x2371 + 2.0 * x883
    x2373 = x19 * x2370
    x2374 = x66 * (x1676 * x828 - x2371 - x2373 + 2.0 * x36 * x882)
    x2375 = -x16 * x1710 + x1681 * x828 + 2.0 * x904
    x2376 = x2374 + x2375 * x327
    x2377 = x1 * (x18 * x2372 * x4 * x7 - x2370 * x563) + x2376 * x68
    x2378 = x16 * x1686
    x2379 = x1685 * x828 - x2378 + 2.0 * x872
    x2380 = x16 * x1691
    x2381 = x66 * (x1690 * x828 - x19 * x2379 - x2380 + 2.0 * x36 * x865)
    x2382 = x19 * x2372
    x2383 = x66 * (x1685 * x828 - x2378 - x2382 + 2.0 * x36 * x871)
    x2384 = x142 * (-x19 * (x2370 * x327 + x2383) + x2372 * x327 + x2381) + x2377 * x68
    x2385 = x1723 * x24 + x2384
    x2386 = x1724 * x24 + x2385
    x2387 = x1725 * x24 + x2386
    x2388 = x1690 * x828 - x2380 + 2.0 * x926
    x2389 = x199 * x2372 - x2379 * x30
    x2390 = x66 * (x19 * x2389 - x199 * x2379 + x2388 * x30)
    x2391 = x199 * x2370 - x2372 * x30
    x2392 = -x2391
    x2393 = x19 * x2392
    x2394 = x66 * (-x2389 - x2393)
    x2395 = x2370 * x3
    x2396 = -x199 * x2375 + x2370 * x30
    x2397 = x19 * x2396
    x2398 = x19 * (x2395 + x2397 * x7)
    x2399 = x2372 * x3
    x2400 = x2393 * x7 + x2399
    x2401 = x66 * (-x2391 - x2397)
    x2402 = x2375 * x3
    x2403 = x1709 * x828 - x1753 * x1754 + 2.0 * x946
    x2404 = -x199 * x2403 + x2375 * x30
    x2405 = x226 * x2396
    x2406 = x228 * x2395
    x2407 = x228 * x2399
    x2408 = x1 * (x13 * x18 * x2372 * x4 - x226 * x2370)
    x2409 = x2375 * x965 + 0.5 * x2408
    x2410 = x1 * (x13 * x223 * x224 * x2372 * x7 - x2370 * x970) + x2409 * x68
    x2411 = x1769 * x24 + x2410
    x2412 = x1770 * x24 + x2411
    x2413 = x1771 * x24 + x2412
    x2414 = x1 * (x13 * x18 * x2392 * x4 - x2405)
    x2415 = x228 * x2402
    x2416 = x16 * x2382 + 3.0 * x1705
    x2417 = x2416 * x3
    x2418 = x16 * x2373 + 3.0 * x1699
    x2419 = x2418 * x3
    x2420 = x16 * x2397 + 3.0 * x1739
    x2421 = x19 * x2420
    x2422 = x16 * x2393 + 3.0 * x1745
    x2423 = x19 * x2418
    x2424 = x1 * (x2416 - x2423)
    x2425 = 0.5 * x2424
    x2426 = 3.0 * x1708 + x2375 * x269
    x2427 = x2425 + x2426 * x327
    x2428 = x1 * (x18 * x2416 * x4 * x7 - x2418 * x563) + x2427 * x68
    x2429 = x1799 * x24 + x2428
    x2430 = x1800 * x24 + x2429
    x2431 = x1801 * x24 + x2430
    x2432 = x1 * (-x2421 + x2422)
    x2433 = 0.5 * x2432
    x2434 = x2426 * x3
    x2435 = 3.0 * x1750 + x2404 * x269
    x2436 = -x19 * (x2370 * x304 + x2383) + x2372 * x304 + x2381
    x2437 = x2374 + x2375 * x304
    x2438 = x2436 * x66 + x2437 * x327
    x2439 = x1816 * x24 + x2438
    x2440 = x1817 * x24 + x2439
    x2441 = x1818 * x24 + x2440
    x2442 = -x19 * (x2394 + x2396 * x304) + x2390 + x2392 * x304
    x2443 = x2437 * x3
    x2444 = x2401 + x2404 * x304
    x2445 = x1 * (x13 * x18 * x2416 * x4 - x226 * x2418)
    x2446 = x2426 * x965 + 0.5 * x2445
    x2447 = x1829 * x24 + x2446
    x2448 = x1830 * x24 + x2447
    x2449 = x1831 * x24 + x2448
    x2450 = x1 * (x13 * x18 * x2422 * x4 - x226 * x2420)
    x2451 = x228 * x2434
    x2452 = 3.0 * x1781 - x19 * (x16 * x2423 + 3.0 * x1783 + x2383) + x2381 + x2416 * x269
    x2453 = x2452 * x66
    x2454 = 3.0 * x1792 + x2374 + x2426 * x269
    x2455 = x2453 + x2454 * x327
    x2456 = x1844 * x24 + x2455
    x2457 = x1845 * x24 + x2456
    x2458 = x1846 * x24 + x2457
    x2459 = 3.0 * x1774 - x19 * (x16 * x2421 + 3.0 * x1776 + x2394) + x2390 + x2422 * x269
    x2460 = x2459 * x66
    x2461 = x2454 * x3
    x2462 = 3.0 * x1804 + x2401 + x2435 * x269
    x2463 = x228 * x2437 + x2408
    x2464 = x2463 * x3
    x2465 = x2463 * x68
    x2466 = x1858 * x24 + x2465
    x2467 = x1859 * x24 + x2466
    x2468 = x1860 * x24 + x2467
    x2469 = x228 * x2444 + x2414
    x2470 = x2425 + x2426 * x304
    x2471 = x2470 * x3
    x2472 = x2470 * x68
    x2473 = x1869 * x24 + x2472
    x2474 = x1870 * x24 + x2473
    x2475 = x1871 * x24 + x2474
    x2476 = x2433 + x2435 * x304
    x2477 = x229 * x2454
    x2478 = x1878 * x24 + x2477
    x2479 = x1879 * x24 + x2478
    x2480 = x1880 * x24 + x2479
    x2481 = x228 * x2461
    x2482 = 3.0 * x1836 + x2424 + x2454 * x269
    x2483 = x2482 * x3
    x2484 = x2482 * x68
    x2485 = x1887 * x24 + x2484
    x2486 = x1888 * x24 + x2485
    x2487 = x1889 * x24 + x2486
    x2488 = 3.0 * x1849 + x2432 + x2462 * x269
    x2489 = x142 * x2436 + x228 * x2463
    x2490 = x1895 * x24 + x2489
    x2491 = x1896 * x24 + x2490
    x2492 = x1897 * x24 + x2491
    x2493 = x228 * x2470 + x2445
    x2494 = x1901 * x24 + x2493
    x2495 = x1902 * x24 + x2494
    x2496 = x1903 * x24 + x2495
    x2497 = x2453 + x2454 * x304
    x2498 = x1907 * x24 + x2497
    x2499 = x1908 * x24 + x2498
    x2500 = x1909 * x24 + x2499
    x2501 = x228 * x2482
    x2502 = x1913 * x24 + x2501
    x2503 = x1914 * x24 + x2502
    x2504 = x1915 * x24 + x2503
    x2505 = x142 * x2452 + 3.0 * x1882 + x2482 * x269
    x2506 = x1919 * x24 + x2505
    x2507 = x1920 * x24 + x2506
    x2508 = x1921 * x24 + x2507
    x2509 = x1247 * x1924
    x2510 = x66 * (
        3.0 * x1223 * x36
        - x1247 * x1931
        - x19 * (3.0 * x1225 + x1931 * x479 - x2509)
        + x1940 * x479
    )
    x2511 = x1247 * x1922
    x2512 = 3.0 * x1229 + x1924 * x479 - x2511
    x2513 = x19 * x2512
    x2514 = x66 * (3.0 * x1224 * x36 + x1931 * x479 - x2509 - x2513)
    x2515 = 3.0 * x1236 - x1247 * x1927 + x1922 * x479
    x2516 = x19 * x2515
    x2517 = x66 * (3.0 * x1228 * x36 + x1924 * x479 - x2511 - x2516)
    x2518 = 3.0 * x1246 - x1247 * x1955 + x1927 * x479
    x2519 = 4.0 * x1947
    x2520 = x13 * x2516 + x2519
    x2521 = 4.0 * x1951
    x2522 = x13 * x2513 + x2521
    x2523 = x19 * x2520
    x2524 = x1 * (x2522 - x2523)
    x2525 = 4.0 * x1954
    x2526 = x228 * x2518 + x2525
    x2527 = x1 * (x16 * x18 * x2512 * x4 - x2515 * x267)
    x2528 = 0.5 * x2527
    x2529 = (
        -x19 * (x13 * x2523 + 4.0 * x1962 + x2514) + 4.0 * x1959 + x228 * x2522 + x2510
    )
    x2530 = 4.0 * x1977 + x228 * x2526 + x2517
    x2531 = x1 * (-x19 * (x2515 * x338 + x2519 * x269) + x2512 * x338 + x2521 * x269)
    x2532 = x2518 * x338 + x2525 * x269
    x2533 = -x19 * (x2514 + x2515 * x356) + x2510 + x2512 * x356
    x2534 = x2533 * x66
    x2535 = x2517 + x2518 * x356
    x2536 = 4.0 * x2000 + x228 * x2530 + x2524
    x2537 = 4.0 * x2009 + x228 * x2532 + x2528
    x2538 = 4.0 * x2020 + x228 * x2535
    x2539 = x2527 + x2535 * x269
    x2540 = x1247 * x2072
    x2541 = x66 * (
        -x1247 * x2079
        + 2.0 * x1469 * x36
        - x19 * (2.0 * x1471 + x2079 * x479 - x2540)
        + x2088 * x479
    )
    x2542 = x1247 * x2070
    x2543 = 2.0 * x1475 + x2072 * x479 - x2542
    x2544 = x19 * x2543
    x2545 = x66 * (2.0 * x1470 * x36 + x2079 * x479 - x2540 - x2544)
    x2546 = -x1247 * x2075 + 2.0 * x1480 + x2070 * x479
    x2547 = x19 * x2546
    x2548 = x66 * (2.0 * x1474 * x36 + x2072 * x479 - x2542 - x2547)
    x2549 = -x1247 * x2101 + 2.0 * x1487 + x2075 * x479
    x2550 = x13 * x2547 + 3.0 * x2094
    x2551 = x13 * x2544 + 3.0 * x2097
    x2552 = x19 * x2550
    x2553 = x1 * (x2551 - x2552)
    x2554 = 3.0 * x2100 + x228 * x2549
    x2555 = x16 * x2547 + x1947
    x2556 = x16 * x2544 + x1951
    x2557 = x19 * x2555
    x2558 = x1 * (x2556 - x2557)
    x2559 = 0.5 * x2558
    x2560 = x1954 + x2549 * x269
    x2561 = (
        -x19 * (x13 * x2552 + 3.0 * x2108 + x2545) + 3.0 * x2105 + x228 * x2551 + x2541
    )
    x2562 = 3.0 * x2121 + x228 * x2554 + x2548
    x2563 = x1 * (-x19 * (x13 * x2557 + 3.0 * x2126) + 3.0 * x2124 + x228 * x2556)
    x2564 = 3.0 * x2140 + x228 * x2560
    x2565 = -x19 * (x16 * x2557 + x1981 + x2545) + x1982 + x2541 + x2556 * x269
    x2566 = x2565 * x66
    x2567 = x1992 + x2548 + x2560 * x269
    x2568 = 3.0 * x2149 + x228 * x2562 + x2553
    x2569 = 3.0 * x2161 + x228 * x2564 + x2559
    x2570 = 3.0 * x2172 + x228 * x2567
    x2571 = x2020 + x2558 + x2567 * x269
    x2572 = x1247 * x2226
    x2573 = x66 * (
        -x1247 * x2233 - x1727 - x19 * (x1729 + x2233 * x479 - x2572) + x2242 * x479
    )
    x2574 = x1247 * x2224
    x2575 = x1734 + x2226 * x479 - x2574
    x2576 = x19 * x2575
    x2577 = x66 * (-x1732 + x2233 * x479 - x2572 - x2576)
    x2578 = -x1247 * x2229 + x1741 + x2224 * x479
    x2579 = x19 * x2578
    x2580 = x66 * (-x1748 + x2226 * x479 - x2574 - x2579)
    x2581 = -x1247 * x2255 + x1752 + x2229 * x479
    x2582 = x13 * x2579 + 2.0 * x2248
    x2583 = x13 * x2576 + 2.0 * x2251
    x2584 = x19 * x2582
    x2585 = x1 * (x2583 - x2584)
    x2586 = 2.0 * x2254 + x228 * x2581
    x2587 = x16 * x2579 + 2.0 * x2094
    x2588 = x16 * x2576 + 2.0 * x2097
    x2589 = x19 * x2587
    x2590 = x1 * (x2588 - x2589)
    x2591 = 0.5 * x2590
    x2592 = 2.0 * x2100 + x2581 * x269
    x2593 = (
        -x19 * (x13 * x2584 + 2.0 * x2260 + x2577) + 2.0 * x2258 + x228 * x2583 + x2573
    )
    x2594 = 2.0 * x2272 + x228 * x2586 + x2580
    x2595 = x1 * (-x19 * (x13 * x2589 + 2.0 * x2277) + 2.0 * x2275 + x228 * x2588)
    x2596 = x228 * x2592 + 2.0 * x2291
    x2597 = (
        -x19 * (x16 * x2589 + 2.0 * x2126 + x2577) + 2.0 * x2124 + x2573 + x2588 * x269
    )
    x2598 = x2597 * x66
    x2599 = 2.0 * x2140 + x2580 + x2592 * x269
    x2600 = x228 * x2594 + 2.0 * x2300 + x2585
    x2601 = x228 * x2596 + 2.0 * x2309 + x2591
    x2602 = x228 * x2599 + 2.0 * x2320
    x2603 = 2.0 * x2172 + x2590 + x2599 * x269
    x2604 = x1247 * x2372 - x2379 * x479
    x2605 = x66 * (-x1247 * x2379 + x19 * x2604 + x2388 * x479)
    x2606 = x1247 * x2370 - x2372 * x479
    x2607 = -x2606
    x2608 = x19 * x2607
    x2609 = x66 * (-x2604 - x2608)
    x2610 = -x1247 * x2375 + x2370 * x479
    x2611 = x19 * x2610
    x2612 = x66 * (-x2606 - x2611)
    x2613 = -x1247 * x2403 + x2375 * x479
    x2614 = x13 * x2611 + x2395
    x2615 = x13 * x2608 + x2399
    x2616 = x19 * x2614
    x2617 = x1 * (x2615 - x2616)
    x2618 = x228 * x2613 + x2402
    x2619 = x16 * x2611 + 3.0 * x2248
    x2620 = x16 * x2608 + 3.0 * x2251
    x2621 = x19 * x2619
    x2622 = x1 * (x2620 - x2621)
    x2623 = 0.5 * x2622
    x2624 = 3.0 * x2254 + x2613 * x269
    x2625 = -x19 * (x13 * x2616 + x2406 + x2609) + x228 * x2615 + x2407 + x2605
    x2626 = x228 * x2618 + x2415 + x2612
    x2627 = x1 * (-x19 * (x13 * x2621 + x2419) + x228 * x2620 + x2417)
    x2628 = x228 * x2624 + x2434
    x2629 = (
        -x19 * (x16 * x2621 + 3.0 * x2277 + x2609) + 3.0 * x2275 + x2605 + x2620 * x269
    )
    x2630 = x2629 * x66
    x2631 = 3.0 * x2291 + x2612 + x2624 * x269
    x2632 = x228 * x2626 + x2443 + x2617
    x2633 = x228 * x2628 + x2451 + x2623
    x2634 = x228 * x2631 + x2461
    x2635 = 3.0 * x2320 + x2622 + x2631 * x269
    x2636 = x1753 * x2372
    x2637 = x66 * (
        3.0 * x1726 * x36
        - x1753 * x2379
        - x19 * (3.0 * x1729 + x2379 * x828 - x2636)
        + x2388 * x828
    )
    x2638 = x1753 * x2370
    x2639 = 3.0 * x1734 + x2372 * x828 - x2638
    x2640 = x19 * x2639
    x2641 = x66 * (3.0 * x1728 * x36 + x2379 * x828 - x2636 - x2640)
    x2642 = 3.0 * x1741 - x1753 * x2375 + x2370 * x828
    x2643 = x19 * x2642
    x2644 = x66 * (3.0 * x1733 * x36 + x2372 * x828 - x2638 - x2643)
    x2645 = 3.0 * x1752 - x1753 * x2403 + x2375 * x828
    x2646 = x1 * (x13 * x18 * x2639 * x4 - x226 * x2642)
    x2647 = x16 * x2643 + 4.0 * x2395
    x2648 = x16 * x2640 + 4.0 * x2399
    x2649 = x19 * x2647
    x2650 = x1 * (x2648 - x2649)
    x2651 = 0.5 * x2650
    x2652 = 4.0 * x2402 + x2645 * x269
    x2653 = -x19 * (x2641 + x2642 * x304) + x2637 + x2639 * x304
    x2654 = x2644 + x2645 * x304
    x2655 = x1 * (x13 * x18 * x2648 * x4 - x226 * x2647)
    x2656 = (
        -x19 * (x16 * x2649 + 4.0 * x2419 + x2641) + 4.0 * x2417 + x2637 + x2648 * x269
    )
    x2657 = x2656 * x66
    x2658 = 4.0 * x2434 + x2644 + x2652 * x269
    x2659 = x228 * x2654 + x2646
    x2660 = x2651 + x2652 * x304
    x2661 = 4.0 * x2461 + x2650 + x2658 * x269

    # 225 item(s)
    return numpy.array(
        [
            x0 * x157
            + x0 * x182
            + x0 * x189
            + x0 * (x0 * (x0 * (x0 * x195 + x187) + x188) + x189)
            + x142
            * (x141 * x196 - x19 * (x137 * x196 + x206 + x212 * x7) + x201 + x215 * x68)
            + x156 * x196
            + x68
            * (
                x1 * (-x212 + x215)
                + x155 * x196
                + x68 * (x154 * x196 + x216 + x68 * (x218 + x222 * x68))
            ),
            x0 * x242
            + x0 * x250
            + x0 * x262
            + x0 * (x0 * (x0 * (x0 * x265 + x260) + x261) + x262)
            + x1 * (-x19 * (x208 * x228 + x227 * x7) + x204 * x229 + x214 * x228)
            + x196 * x241
            + x68 * (x196 * x240 + 0.5 * x266 + x68 * (x218 * x228 + x222 * x229)),
            x0 * x284
            + x0 * x290
            + x0 * x300
            + x0 * (x0 * (x0 * (x0 * x301 + x298) + x299) + x300)
            + x1 * (-x19 * (x208 * x269 + x268 * x7) + x204 * x270 + x214 * x269)
            + x196 * x283
            + x68 * (x196 * x282 + x303 + x68 * (x218 * x269 + x222 * x270)),
            x0 * x313
            + x0 * x320
            + x0 * x324
            + x0 * (x0 * (x0 * (x0 * x328 + x322) + x323) + x324)
            + x196 * x312
            + x329 * x66
            + x68 * (4.0 * x330 + x331 * x68),
            x0 * x341
            + x0 * x347
            + x0 * x352
            + x0 * (x0 * (x0 * (x0 * x354 + x350) + x351) + x352)
            + x196 * x340
            + 0.5 * x355
            + x68 * (x218 * x338 + x222 * x337),
            x0 * x368
            + x0 * x375
            + x0 * x380
            + x0 * (x0 * (x0 * (x0 * x383 + x378) + x379) + x380)
            + x196 * x367
            + x385
            + x68 * (x387 + x388 * x68),
            x0 * x392
            + x0 * x396
            + x0 * x401
            + x0 * (x0 * (x0 * (x397 * x402 + x399) + x400) + x401)
            + 4.0 * x403
            + x404 * x68,
            x0 * x409
            + x0 * x413
            + x0 * x418
            + x0 * (x0 * (x0 * (x402 * x414 + x416) + x417) + x418)
            + 4.0 * x419
            + x420 * x68,
            x0 * x421
            + x0 * x423
            + x0 * x427
            + x0 * (x0 * (x0 * (x0 * x428 + x425) + x426) + x427)
            + x228 * x387
            + x229 * x388,
            x0 * x432
            + x0 * x436
            + x0 * x441
            + x0 * (x0 * (x0 * (x402 * x437 + x439) + x440) + x441)
            + 4.0 * x442
            + x443 * x68,
            x0 * x444
            + x0 * x446
            + x0 * x449
            + x0 * (x0 * (x0 * (x0 * x450 + x447) + x448) + x449)
            + x142 * x329
            + x228 * x404,
            x0 * x451
            + x0 * x453
            + x0 * x456
            + x0 * (x0 * (x0 * (x0 * x457 + x454) + x455) + x456)
            + x228 * x420
            + x355,
            x0 * x458
            + x0 * x460
            + x0 * x463
            + x0 * (x0 * (x0 * (x0 * x464 + x461) + x462) + x463)
            + x304 * x388
            + x385,
            x0 * x465
            + x0 * x467
            + x0 * x470
            + x0 * (x0 * (x0 * (x0 * x471 + x468) + x469) + x470)
            + x228 * x443,
            x0 * x472
            + x0 * x474
            + x0 * x477
            + x0 * (x0 * (x0 * (x0 * x478 + x475) + x476) + x477)
            + x142 * x384
            + x269 * x443,
            x0 * x562
            + x0 * x569
            + x0 * (x0 * (x0 * x574 + x568) + x569)
            + x142
            * (-x19 * (x544 * x96 + x583 + x588 * x7) + x548 * x96 + x578 + x591 * x68)
            + x157 * x23
            + x560 * x96
            + x68
            * (
                x1 * (-x588 + x591)
                + x559 * x96
                + x68 * (x558 * x96 + x592 + x68 * (x594 + x597 * x68))
            ),
            x0 * x620
            + x0 * x630
            + x0 * (x0 * (x0 * x632 + x629) + x630)
            + x1 * (-x19 * (x599 * x96 + x600 * x7) + x598 * x96 + x601 * x68)
            + x23 * x242
            + x618 * x96
            + x68 * (x617 * x96 + 0.5 * x633 + x68 * (x616 * x96 + x634 * x68)),
            x0 * x651
            + x0 * x660
            + x0 * (x0 * (x0 * x663 + x659) + x660)
            + x1 * (-x19 * (x269 * x585 + x635 * x7) + x269 * x590 + x270 * x581)
            + x23 * x284
            + x649 * x96
            + x68 * (x648 * x96 + x665 + x68 * (x269 * x594 + x270 * x597)),
            x0 * x675
            + x0 * x679
            + x0 * (x0 * (x0 * x682 + x678) + x679)
            + x23 * x313
            + x66 * x683
            + x673 * x96
            + x68 * (x672 * x96 + x68 * x684),
            x0 * x698
            + x0 * x704
            + x0 * (x0 * (x0 * x707 + x703) + x704)
            + x23 * x341
            + x68 * (x68 * x712 + x695 * x96)
            + x696 * x96
            + 0.5 * x710,
            x0 * x724
            + x0 * x729
            + x0 * (x0 * (x0 * x733 + x728) + x729)
            + x23 * x368
            + x68 * (x68 * x737 + 3.0 * x736)
            + x722 * x96
            + x735,
            x0 * x742
            + x0 * x747
            + x0 * (x0 * (x0 * x750 + x746) + x747)
            + x23 * x392
            + x68 * x751
            + x740 * x96,
            x0 * x756
            + x0 * x761
            + x0 * (x0 * (x0 * x763 + x760) + x761)
            + x23 * x409
            + x68 * x764
            + x754 * x96,
            x0 * x769
            + x0 * x774
            + x0 * (x0 * (x0 * x776 + x773) + x774)
            + x23 * x421
            + x68 * x777
            + x767 * x96,
            x0 * x783
            + x0 * x788
            + x0 * (x0 * (x0 * x790 + x787) + x788)
            + x23 * x432
            + x68 * x792
            + 3.0 * x791,
            x0 * x794
            + x0 * x797
            + x0 * (x0 * (x0 * x799 + x796) + x797)
            + x142 * x683
            + x228 * x751
            + x23 * x444
            + x403,
            x0 * x801
            + x0 * x804
            + x0 * (x0 * (x0 * x806 + x803) + x804)
            + x228 * x764
            + x23 * x451
            + x419
            + x710,
            x0 * x808
            + x0 * x811
            + x0 * (x0 * (x0 * x813 + x810) + x811)
            + x228 * x386
            + x228 * x777
            + x23 * x458
            + x735,
            x0 * x815
            + x0 * x818
            + x0 * (x0 * (x0 * x820 + x817) + x818)
            + x228 * x792
            + x23 * x465
            + x442,
            x0 * x822
            + x0 * x825
            + x0 * (x0 * (x0 * x827 + x824) + x825)
            + x142 * x734
            + x23 * x472
            + x269 * x792,
            x0 * x914
            + x0 * x920
            + x0 * (x0 * (x0 * x925 + x919) + x920)
            + x142
            * (-x19 * (x7 * x939 + x895 * x96 + x934) + x68 * x942 + x899 * x96 + x929)
            + x157 * x24
            + x68
            * (
                x1 * (-x939 + x942)
                + x68 * (x68 * (x68 * x948 + x945) + x910 * x96 + x943)
                + x911 * x96
            )
            + x912 * x96,
            x0 * x960
            + x0 * x969
            + x0 * (x0 * (x0 * x972 + x968) + x969)
            + x1 * (-x19 * (x228 * x936 + x7 * x949) + x228 * x941 + x229 * x932)
            + x24 * x242
            + x68 * (x68 * (x228 * x945 + x229 * x948) + x957 * x96 + 0.5 * x973)
            + x958 * x96,
            x0 * x1004
            + x0 * x1015
            + x0 * (x0 * (x0 * x1017 + x1014) + x1015)
            + x1 * (-x19 * (x7 * x979 + 3.0 * x977) + x68 * x980 + 3.0 * x975)
            + x1002 * x96
            + x24 * x284
            + x68 * (x1001 * x96 + x1019 + x68 * (x1021 + x1022 * x68)),
            x0 * x1032
            + x0 * x1036
            + x0 * (x0 * (x0 * x1039 + x1035) + x1036)
            + x1030 * x96
            + x1040 * x66
            + x24 * x313
            + x68 * (3.0 * x1041 + x1042 * x68),
            x0 * x1048
            + x0 * x1052
            + x0 * (x0 * (x0 * x1055 + x1051) + x1052)
            + x1046 * x96
            + 0.5 * x1056
            + x24 * x341
            + x68 * (x1021 * x228 + x1022 * x229),
            x0 * x1068
            + x0 * x1073
            + x0 * (x0 * (x0 * x1077 + x1072) + x1073)
            + x1066 * x96
            + x1079
            + x24 * x368
            + x68 * (x1081 + x1082 * x68),
            x0 * x1087
            + x0 * x1092
            + x0 * (x0 * (x0 * x1095 + x1091) + x1092)
            + 3.0 * x1096
            + x1097 * x68
            + x24 * x392,
            x0 * x1102
            + x0 * x1107
            + x0 * (x0 * (x0 * x1109 + x1106) + x1107)
            + 3.0 * x1110
            + x1111 * x68
            + x24 * x409,
            x0 * x1113
            + x0 * x1117
            + x0 * (x0 * (x0 * x1119 + x1116) + x1117)
            + x1081 * x228
            + x1082 * x229
            + x24 * x421,
            x0 * x1125
            + x0 * x1130
            + x0 * (x0 * (x0 * x1132 + x1129) + x1130)
            + 3.0 * x1133
            + x1134 * x68
            + x24 * x432,
            x0 * x1136
            + x0 * x1139
            + x0 * (x0 * (x0 * x1141 + x1138) + x1139)
            + x1040 * x142
            + x1097 * x228
            + x24 * x444,
            x0 * x1143
            + x0 * x1146
            + x0 * (x0 * (x0 * x1148 + x1145) + x1146)
            + x1056
            + x1111 * x228
            + x24 * x451,
            x0 * x1150
            + x0 * x1153
            + x0 * (x0 * (x0 * x1155 + x1152) + x1153)
            + x1079
            + x1082 * x304
            + x24 * x458,
            x0 * x1157
            + x0 * x1160
            + x0 * (x0 * (x0 * x1162 + x1159) + x1160)
            + x1134 * x228
            + x24 * x465,
            x0 * x1164
            + x0 * x1167
            + x0 * (x0 * (x0 * x1169 + x1166) + x1167)
            + x1078 * x142
            + x1134 * x269
            + x24 * x472
            + x442,
            x0 * x1214
            + x0 * (x0 * x1222 + x1214)
            + x1211 * x69
            + x142
            * (
                x1203 * x69
                + x1227
                + x1242 * x68
                - x19 * (x1200 * x69 + x1233 + x1239 * x7)
            )
            + x23 * x561
            + x23 * x562
            + x68
            * (
                x1 * (-x1239 + x1242)
                + x1210 * x69
                + x68 * (x1209 * x69 + x1243 + x68 * (x1245 + x1249 * x68))
            ),
            x0 * x1275
            + x0 * (x0 * x1278 + x1275)
            + x1 * (x1250 * x69 + x1255 * x68 - x19 * (x1251 * x69 + x1253 * x7))
            + x1272 * x69
            + x23 * x619
            + x23 * x620
            + x68 * (x1271 * x69 + 0.5 * x1279 + x68 * (x1270 * x69 + x1281 * x68)),
            x0 * x1296
            + x0 * (x0 * x1299 + x1296)
            + x1 * (x1231 * x270 + x1241 * x269 - x19 * (x1235 * x269 + x1282 * x7))
            + x1293 * x69
            + x23 * x650
            + x23 * x651
            + x68 * (x1292 * x69 + x1301 + x68 * (x1245 * x269 + x1249 * x270)),
            x0 * x1309
            + x0 * (x0 * x1313 + x1309)
            + x1306 * x69
            + x1314 * x66
            + x23 * x674
            + x23 * x675
            + x68 * (x1305 * x69 + x1315 * x68),
            x0 * x1323
            + x0 * (x0 * x1327 + x1323)
            + x1320 * x69
            + 0.5 * x1328
            + x23 * x697
            + x23 * x698
            + x68 * (x1319 * x69 + x1329 * x68),
            x0 * x1338
            + x0 * (x0 * x1343 + x1338)
            + x1335 * x69
            + x1345
            + x23 * x723
            + x23 * x724
            + x68 * (2.0 * x1346 + x1347 * x68),
            x0 * x1353
            + x0 * (x0 * x1356 + x1353)
            + x1350 * x69
            + x1357 * x68
            + x23 * x741
            + x23 * x742,
            x0 * x1363
            + x0 * (x0 * x1366 + x1363)
            + x1360 * x69
            + x1367 * x68
            + x23 * x755
            + x23 * x756,
            x0 * x1373
            + x0 * (x0 * x1376 + x1373)
            + x1370 * x69
            + x1377 * x68
            + x23 * x768
            + x23 * x769,
            x0 * x1383
            + x0 * (x0 * x1386 + x1383)
            + 2.0 * x1387
            + x1388 * x68
            + x23 * x782
            + x23 * x783,
            x0 * x1391
            + x0 * (x0 * x1394 + x1391)
            + x1314 * x142
            + x1357 * x228
            + x23 * x793
            + x23 * x794
            + x69 * x740,
            x0 * x1397
            + x0 * (x0 * x1400 + x1397)
            + x1328
            + x1367 * x228
            + x23 * x800
            + x23 * x801
            + x69 * x754,
            x0 * x1403
            + x0 * (x0 * x1406 + x1403)
            + x1345
            + x1377 * x228
            + x23 * x807
            + x23 * x808
            + x69 * x767,
            x0 * x1409
            + x0 * (x0 * x1412 + x1409)
            + x1388 * x228
            + x23 * x814
            + x23 * x815
            + 2.0 * x791,
            x0 * x1415
            + x0 * (x0 * x1418 + x1415)
            + x1344 * x142
            + x1388 * x269
            + x23 * x821
            + x23 * x822,
            x0 * x1462
            + x0 * (x0 * x1468 + x1462)
            + x142
            * (
                x1451 * x69
                + x1473
                + x1484 * x68
                - x19 * (x1448 * x69 + x1478 + x1482 * x7)
            )
            + x1459 * x69
            + x23 * x914
            + x24 * x561
            + x68
            * (
                x1 * (-x1482 + x1484)
                + x1458 * x69
                + x68 * (x1457 * x69 + x1485 + x68 * (x1486 + x1489 * x68))
            ),
            x0 * x1512
            + x0 * (x0 * x1515 + x1512)
            + x1 * (x1491 + x1495 * x68 - x19 * (x1493 + x1494 * x7))
            + x1509 * x69
            + x23 * x960
            + x24 * x619
            + x68 * (x1508 * x69 + 0.5 * x1516 + x68 * (x1517 + x1518 * x68)),
            x0 * x1543
            + x0 * (x0 * x1546 + x1543)
            + x1 * (x1520 + x1524 * x68 - x19 * (x1522 + x1523 * x7))
            + x1004 * x23
            + x1540 * x69
            + x24 * x650
            + x68 * (x1539 * x69 + x1548 + x68 * (x1549 + x1550 * x68)),
            x0 * x1558
            + x0 * (x0 * x1562 + x1558)
            + x1032 * x23
            + x1555 * x69
            + x1563 * x66
            + x24 * x674
            + x68 * (x1564 + x1565 * x68),
            x0 * x1573
            + x0 * (x0 * x1577 + x1573)
            + x1048 * x23
            + x1570 * x69
            + 0.5 * x1578
            + x24 * x697
            + x68 * (x1579 + x1580 * x68),
            x0 * x1589
            + x0 * (x0 * x1594 + x1589)
            + x1068 * x23
            + x1586 * x69
            + x1596
            + x24 * x723
            + x68 * (x1597 + x1598 * x68),
            x0 * x1604
            + x0 * (x0 * x1607 + x1604)
            + x1087 * x23
            + x1608
            + x1609 * x68
            + x24 * x741,
            x0 * x1615
            + x0 * (x0 * x1618 + x1615)
            + x1102 * x23
            + x1619
            + x1620 * x68
            + x24 * x755,
            x0 * x1626
            + x0 * (x0 * x1629 + x1626)
            + x1113 * x23
            + x1630
            + x1631 * x68
            + x24 * x768,
            x0 * x1637
            + x0 * (x0 * x1640 + x1637)
            + x1125 * x23
            + x1641
            + x1642 * x68
            + x24 * x782,
            x0 * x1645
            + x0 * (x0 * x1648 + x1645)
            + x1096
            + x1136 * x23
            + x142 * x1563
            + x1609 * x228
            + x24 * x793,
            x0 * x1651
            + x0 * (x0 * x1654 + x1651)
            + x1110
            + x1143 * x23
            + x1578
            + x1620 * x228
            + x24 * x800,
            x0 * x1657
            + x0 * (x0 * x1660 + x1657)
            + x1080 * x228
            + x1150 * x23
            + x1596
            + x1631 * x228
            + x24 * x807,
            x0 * x1663
            + x0 * (x0 * x1666 + x1663)
            + x1133
            + x1157 * x23
            + x1642 * x228
            + x24 * x814,
            x0 * x1669
            + x0 * (x0 * x1672 + x1669)
            + x1164 * x23
            + x142 * x1595
            + x1642 * x269
            + x24 * x821
            + x791,
            x0 * x1717
            + x0 * (x0 * x1725 + x1717)
            + x142
            * (
                x1706 * x69
                + x1731
                + x1747 * x68
                - x19 * (x1703 * x69 + x1738 + x1744 * x7)
            )
            + x1714 * x69
            + x24 * x913
            + x24 * x914
            + x68
            * (
                x1 * (-x1744 + x1747)
                + x1713 * x69
                + x68 * (x1712 * x69 + x1749 + x68 * (x1751 + x1755 * x68))
            ),
            x0 * x1768
            + x0 * (x0 * x1771 + x1768)
            + x1 * (x1736 * x229 + x1746 * x228 - x19 * (x1740 * x228 + x1756 * x7))
            + x1765 * x69
            + x24 * x959
            + x24 * x960
            + x68 * (x1764 * x69 + 0.5 * x1772 + x68 * (x1751 * x228 + x1755 * x229)),
            x0 * x1798
            + x0 * (x0 * x1801 + x1798)
            + x1 * (2.0 * x1774 + x1779 * x68 - x19 * (2.0 * x1776 + x1778 * x7))
            + x1003 * x24
            + x1004 * x24
            + x1795 * x69
            + x68 * (x1794 * x69 + x1803 + x68 * (x1805 + x1806 * x68)),
            x0 * x1814
            + x0 * (x0 * x1818 + x1814)
            + x1031 * x24
            + x1032 * x24
            + x1811 * x69
            + x1819 * x66
            + x68 * (2.0 * x1820 + x1821 * x68),
            x0 * x1827
            + x0 * (x0 * x1831 + x1827)
            + x1047 * x24
            + x1048 * x24
            + x1824 * x69
            + 0.5 * x1832
            + x68 * (x1805 * x228 + x1806 * x229),
            x0 * x1841
            + x0 * (x0 * x1846 + x1841)
            + x1067 * x24
            + x1068 * x24
            + x1838 * x69
            + x1848
            + x68 * (x1850 + x1851 * x68),
            x0 * x1857
            + x0 * (x0 * x1860 + x1857)
            + x1086 * x24
            + x1087 * x24
            + 2.0 * x1861
            + x1862 * x68,
            x0 * x1868
            + x0 * (x0 * x1871 + x1868)
            + x1101 * x24
            + x1102 * x24
            + 2.0 * x1872
            + x1873 * x68,
            x0 * x1877
            + x0 * (x0 * x1880 + x1877)
            + x1112 * x24
            + x1113 * x24
            + x1850 * x228
            + x1851 * x229,
            x0 * x1886
            + x0 * (x0 * x1889 + x1886)
            + x1124 * x24
            + x1125 * x24
            + 2.0 * x1890
            + x1891 * x68,
            x0 * x1894
            + x0 * (x0 * x1897 + x1894)
            + x1135 * x24
            + x1136 * x24
            + x142 * x1819
            + x1862 * x228,
            x0 * x1900
            + x0 * (x0 * x1903 + x1900)
            + x1142 * x24
            + x1143 * x24
            + x1832
            + x1873 * x228,
            x0 * x1906
            + x0 * (x0 * x1909 + x1906)
            + x1149 * x24
            + x1150 * x24
            + x1848
            + x1851 * x304,
            x0 * x1912
            + x0 * (x0 * x1915 + x1912)
            + x1156 * x24
            + x1157 * x24
            + x1891 * x228,
            x0 * x1918
            + x0 * (x0 * x1921 + x1918)
            + 2.0 * x1133
            + x1163 * x24
            + x1164 * x24
            + x142 * x1847
            + x1891 * x269,
            x0 * x1939
            + x1212 * x23
            + x1213 * x23
            + x1214 * x23
            + x142
            * (
                -x19 * (x1946 + x1947 * x68 + x1950 * x7)
                + x1942
                + x1951 * x68
                + x1952 * x68
            )
            + x1929 * x3
            + x68
            * (
                x1 * (-x1950 + x1952)
                + x1928 * x3
                + x68 * (x1953 + x1954 * x68 + x68 * (x1954 + x1956 * x68))
            ),
            x0 * x1975
            + x1 * (-x19 * (x1962 + x1964 * x7) + x1959 + x1966 * x68)
            + x1273 * x23
            + x1274 * x23
            + x1275 * x23
            + x1971 * x3
            + x68 * (0.5 * x1976 + x1977 * x68 + x68 * (x1977 + x1979 * x68)),
            x0 * x1989
            + x1 * (-x19 * (x1980 * x7 + x1981) + x1944 * x270 + x1982)
            + x1294 * x23
            + x1295 * x23
            + x1296 * x23
            + x1985 * x3
            + x68 * (x1954 * x270 + x1991 + x68 * (x1956 * x270 + x1992)),
            x0 * x1998
            + x1307 * x23
            + x1308 * x23
            + x1309 * x23
            + x1999 * x66
            + x2000 * x68
            + x68 * (x2000 + x2001 * x68),
            x0 * x2007
            + x1321 * x23
            + x1322 * x23
            + x1323 * x23
            + 0.5 * x2008
            + x2009 * x68
            + x68 * (x2009 + x2010 * x68),
            x0 * x2017
            + x1336 * x23
            + x1337 * x23
            + x1338 * x23
            + x2019
            + x2020 * x68
            + x68 * (x2020 + x2021 * x68),
            x0 * x2027 + x1351 * x23 + x1352 * x23 + x1353 * x23 + x2023 + x2028 * x68,
            x0 * x2034 + x1361 * x23 + x1362 * x23 + x1363 * x23 + x2030 + x2035 * x68,
            x0 * x2041 + x1371 * x23 + x1372 * x23 + x1373 * x23 + x2037 + x2042 * x68,
            x0 * x2048 + x1381 * x23 + x1382 * x23 + x1383 * x23 + x2044 + x2049 * x68,
            x0 * x2053
            + x1350 * x96
            + x1389 * x23
            + x1390 * x23
            + x1391 * x23
            + x142 * x1999
            + x2028 * x228,
            x0 * x2057
            + x1360 * x96
            + x1395 * x23
            + x1396 * x23
            + x1397 * x23
            + x2008
            + x2035 * x228,
            x0 * x2061
            + x1370 * x96
            + x1401 * x23
            + x1402 * x23
            + x1403 * x23
            + x2019
            + x2042 * x228,
            x0 * x2065
            + 3.0 * x1387
            + x1407 * x23
            + x1408 * x23
            + x1409 * x23
            + x2049 * x228,
            x0 * x2069
            + x1413 * x23
            + x1414 * x23
            + x1415 * x23
            + x142 * x2018
            + x2049 * x269,
            x0 * x2087
            + x1212 * x24
            + x142
            * (
                -x19 * (x2093 + x2094 * x68 + x2096 * x7)
                + x2090
                + x2097 * x68
                + x2098 * x68
            )
            + x1461 * x23
            + x1462 * x23
            + x2077 * x3
            + x68
            * (
                x1 * (-x2096 + x2098)
                + x2076 * x3
                + x68 * (x2099 + x2100 * x68 + x68 * (x2100 + x2102 * x68))
            ),
            x0 * x2119
            + x1 * (-x19 * (x2108 + x2109 * x7) + x2105 + x2110 * x68)
            + x1273 * x24
            + x1511 * x23
            + x1512 * x23
            + x2115 * x3
            + x68 * (0.5 * x2120 + x2121 * x68 + x68 * (x2121 + x2122 * x68)),
            x0 * x2137
            + x1 * (-x19 * (x2126 + x2127 * x7) + x2124 + x2128 * x68)
            + x1294 * x24
            + x1542 * x23
            + x1543 * x23
            + x2133 * x3
            + x68 * (x2139 + x2140 * x68 + x68 * (x2140 + x2141 * x68)),
            x0 * x2147
            + x1307 * x24
            + x1557 * x23
            + x1558 * x23
            + x2148 * x66
            + x2149 * x68
            + x68 * (x2149 + x2150 * x68),
            x0 * x2159
            + x1321 * x24
            + x1572 * x23
            + x1573 * x23
            + 0.5 * x2160
            + x2161 * x68
            + x68 * (x2161 + x2162 * x68),
            x0 * x2169
            + x1336 * x24
            + x1588 * x23
            + x1589 * x23
            + x2171
            + x2172 * x68
            + x68 * (x2172 + x2173 * x68),
            x0 * x2179 + x1351 * x24 + x1603 * x23 + x1604 * x23 + x2175 + x2180 * x68,
            x0 * x2186 + x1361 * x24 + x1614 * x23 + x1615 * x23 + x2182 + x2187 * x68,
            x0 * x2194 + x1371 * x24 + x1625 * x23 + x1626 * x23 + x2190 + x2195 * x68,
            x0 * x2201 + x1381 * x24 + x1636 * x23 + x1637 * x23 + x2197 + x2202 * x68,
            x0 * x2206
            + x1389 * x24
            + x142 * x2148
            + x1608
            + x1644 * x23
            + x1645 * x23
            + x2180 * x228,
            x0 * x2210
            + x1395 * x24
            + x1619
            + x1650 * x23
            + x1651 * x23
            + x2160
            + x2187 * x228,
            x0 * x2214
            + x1401 * x24
            + x1630
            + x1656 * x23
            + x1657 * x23
            + x2171
            + x2195 * x228,
            x0 * x2219 + x1407 * x24 + x1641 + x1662 * x23 + x1663 * x23 + x2202 * x228,
            x0 * x2223
            + x1387
            + x1413 * x24
            + x142 * x2170
            + x1668 * x23
            + x1669 * x23
            + x2202 * x269,
            x0 * x2241
            + x142
            * (
                -x19 * (x2247 + x2248 * x68 + x2250 * x7)
                + x2244
                + x2251 * x68
                + x2252 * x68
            )
            + x1460 * x24
            + x1461 * x24
            + x1717 * x23
            + x2231 * x3
            + x68
            * (
                x1 * (-x2250 + x2252)
                + x2230 * x3
                + x68 * (x2253 + x2254 * x68 + x68 * (x2254 + x2256 * x68))
            ),
            x0 * x2270
            + x1 * (-x19 * (x2260 + x2261 * x7) + x2258 + x2262 * x68)
            + x1510 * x24
            + x1511 * x24
            + x1768 * x23
            + x2266 * x3
            + x68 * (0.5 * x2271 + x2272 * x68 + x68 * (x2272 + x2273 * x68)),
            x0 * x2288
            + x1 * (-x19 * (x2277 + x2278 * x7) + x2275 + x2279 * x68)
            + x1541 * x24
            + x1542 * x24
            + x1798 * x23
            + x2284 * x3
            + x68 * (x2290 + x2291 * x68 + x68 * (x2291 + x2292 * x68)),
            x0 * x2298
            + x1556 * x24
            + x1557 * x24
            + x1814 * x23
            + x2299 * x66
            + x2300 * x68
            + x68 * (x2300 + x2301 * x68),
            x0 * x2307
            + x1571 * x24
            + x1572 * x24
            + x1827 * x23
            + 0.5 * x2308
            + x2309 * x68
            + x68 * (x2309 + x2310 * x68),
            x0 * x2317
            + x1587 * x24
            + x1588 * x24
            + x1841 * x23
            + x2319
            + x2320 * x68
            + x68 * (x2320 + x2321 * x68),
            x0 * x2327 + x1602 * x24 + x1603 * x24 + x1857 * x23 + x2323 + x2328 * x68,
            x0 * x2334 + x1613 * x24 + x1614 * x24 + x1868 * x23 + x2330 + x2335 * x68,
            x0 * x2341 + x1624 * x24 + x1625 * x24 + x1877 * x23 + x2337 + x2342 * x68,
            x0 * x2348 + x1635 * x24 + x1636 * x24 + x1886 * x23 + x2344 + x2349 * x68,
            x0 * x2353
            + x142 * x2299
            + x1643 * x24
            + x1644 * x24
            + x1861
            + x1894 * x23
            + x228 * x2328,
            x0 * x2357
            + x1649 * x24
            + x1650 * x24
            + x1872
            + x1900 * x23
            + x228 * x2335
            + x2308,
            x0 * x2361
            + x1655 * x24
            + x1656 * x24
            + x1849 * x228
            + x1906 * x23
            + x228 * x2342
            + x2319,
            x0 * x2365 + x1661 * x24 + x1662 * x24 + x1890 + x1912 * x23 + x228 * x2349,
            x0 * x2369
            + x142 * x2318
            + x1641
            + x1667 * x24
            + x1668 * x24
            + x1918 * x23
            + x2349 * x269,
            x0 * x2387
            + x142
            * (
                -x19 * (x2394 + x2395 * x68 + x2398 * x7)
                + x2390
                + x2399 * x68
                + x2400 * x68
            )
            + x1715 * x24
            + x1716 * x24
            + x1717 * x24
            + x2377 * x3
            + x68
            * (
                x1 * (-x2398 + x2400)
                + x2376 * x3
                + x68 * (x2401 + x2402 * x68 + x68 * (x2402 + x2404 * x68))
            ),
            x0 * x2413
            + x1 * (-x19 * (x2405 * x7 + x2406) + x229 * x2392 + x2407)
            + x1766 * x24
            + x1767 * x24
            + x1768 * x24
            + x2409 * x3
            + x68 * (x229 * x2402 + 0.5 * x2414 + x68 * (x229 * x2404 + x2415)),
            x0 * x2431
            + x1 * (-x19 * (x2419 + x2421 * x7) + x2417 + x2422 * x68)
            + x1796 * x24
            + x1797 * x24
            + x1798 * x24
            + x2427 * x3
            + x68 * (x2433 + x2434 * x68 + x68 * (x2434 + x2435 * x68)),
            x0 * x2441
            + x1812 * x24
            + x1813 * x24
            + x1814 * x24
            + x2442 * x66
            + x2443 * x68
            + x68 * (x2443 + x2444 * x68),
            x0 * x2449
            + x1825 * x24
            + x1826 * x24
            + x1827 * x24
            + x229 * x2434
            + 0.5 * x2450
            + x68 * (x229 * x2435 + x2451),
            x0 * x2458
            + x1839 * x24
            + x1840 * x24
            + x1841 * x24
            + x2460
            + x2461 * x68
            + x68 * (x2461 + x2462 * x68),
            x0 * x2468 + x1855 * x24 + x1856 * x24 + x1857 * x24 + x2464 + x2469 * x68,
            x0 * x2475 + x1866 * x24 + x1867 * x24 + x1868 * x24 + x2471 + x2476 * x68,
            x0 * x2480 + x1875 * x24 + x1876 * x24 + x1877 * x24 + x229 * x2462 + x2481,
            x0 * x2487 + x1884 * x24 + x1885 * x24 + x1886 * x24 + x2483 + x2488 * x68,
            x0 * x2492
            + x142 * x2442
            + x1892 * x24
            + x1893 * x24
            + x1894 * x24
            + x228 * x2469,
            x0 * x2496 + x1898 * x24 + x1899 * x24 + x1900 * x24 + x228 * x2476 + x2450,
            x0 * x2500 + x1904 * x24 + x1905 * x24 + x1906 * x24 + x2460 + x2462 * x304,
            x0 * x2504 + x1910 * x24 + x1911 * x24 + x1912 * x24 + x228 * x2488,
            x0 * x2508
            + x142 * x2459
            + 3.0 * x1890
            + x1916 * x24
            + x1917 * x24
            + x1918 * x24
            + x2488 * x269,
            x142 * (-x19 * (x2514 + x2515 * x327) + x2510 + x2512 * x327)
            + x1936 * x23
            + x1937 * x23
            + x1938 * x23
            + x1939 * x23
            + x68
            * (
                x1 * (x18 * x2512 * x4 * x7 - x2515 * x563) + x68 * (x2517 + x2518 * x327)
            ),
            x1 * (x18 * x2522 * x4 * x7 - x2520 * x563)
            + x1972 * x23
            + x1973 * x23
            + x1974 * x23
            + x1975 * x23
            + x68 * (0.5 * x2524 + x2526 * x327),
            x1 * (x16 * x223 * x224 * x2512 * x7 - x2515 * x661)
            + x1986 * x23
            + x1987 * x23
            + x1988 * x23
            + x1989 * x23
            + x68 * (x2518 * x656 + x2528),
            x1995 * x23
            + x1996 * x23
            + x1997 * x23
            + x1998 * x23
            + x2529 * x66
            + x2530 * x327,
            x2004 * x23
            + x2005 * x23
            + x2006 * x23
            + x2007 * x23
            + 0.5 * x2531
            + x2532 * x327,
            x2014 * x23 + x2015 * x23 + x2016 * x23 + x2017 * x23 + x2534 + x2535 * x327,
            x2024 * x23 + x2025 * x23 + x2026 * x23 + x2027 * x23 + x2536 * x68,
            x2031 * x23 + x2032 * x23 + x2033 * x23 + x2034 * x23 + x2537 * x68,
            x2038 * x23 + x2039 * x23 + x2040 * x23 + x2041 * x23 + x2538 * x68,
            x2045 * x23 + x2046 * x23 + x2047 * x23 + x2048 * x23 + x2539 * x68,
            x142 * x2529
            + 4.0 * x2023
            + x2050 * x23
            + x2051 * x23
            + x2052 * x23
            + x2053 * x23
            + x228 * x2536,
            4.0 * x2030
            + x2054 * x23
            + x2055 * x23
            + x2056 * x23
            + x2057 * x23
            + x228 * x2537
            + x2531,
            4.0 * x2037
            + x2058 * x23
            + x2059 * x23
            + x2060 * x23
            + x2061 * x23
            + x228 * x2538
            + x2534,
            4.0 * x2044
            + x2062 * x23
            + x2063 * x23
            + x2064 * x23
            + x2065 * x23
            + x228 * x2539,
            x142 * x2533
            + x2066 * x23
            + x2067 * x23
            + x2068 * x23
            + x2069 * x23
            + x2539 * x269,
            x142 * (-x19 * (x2545 + x2546 * x327) + x2541 + x2543 * x327)
            + x1936 * x24
            + x2085 * x23
            + x2086 * x23
            + x2087 * x23
            + x68
            * (
                x1 * (x18 * x2543 * x4 * x7 - x2546 * x563) + x68 * (x2548 + x2549 * x327)
            ),
            x1 * (x18 * x2551 * x4 * x7 - x2550 * x563)
            + x1972 * x24
            + x2117 * x23
            + x2118 * x23
            + x2119 * x23
            + x68 * (0.5 * x2553 + x2554 * x327),
            x1 * (x18 * x2556 * x4 * x7 - x2555 * x563)
            + x1986 * x24
            + x2135 * x23
            + x2136 * x23
            + x2137 * x23
            + x68 * (x2559 + x2560 * x327),
            x1995 * x24
            + x2145 * x23
            + x2146 * x23
            + x2147 * x23
            + x2561 * x66
            + x2562 * x327,
            x2004 * x24
            + x2157 * x23
            + x2158 * x23
            + x2159 * x23
            + 0.5 * x2563
            + x2564 * x327,
            x2014 * x24 + x2167 * x23 + x2168 * x23 + x2169 * x23 + x2566 + x2567 * x327,
            x2024 * x24 + x2177 * x23 + x2178 * x23 + x2179 * x23 + x2568 * x68,
            x2031 * x24 + x2184 * x23 + x2185 * x23 + x2186 * x23 + x2569 * x68,
            x2038 * x24 + x2192 * x23 + x2193 * x23 + x2194 * x23 + x2570 * x68,
            x2045 * x24 + x2199 * x23 + x2200 * x23 + x2201 * x23 + x2571 * x68,
            x142 * x2561
            + x2050 * x24
            + 3.0 * x2175
            + x2204 * x23
            + x2205 * x23
            + x2206 * x23
            + x228 * x2568,
            x2054 * x24
            + 3.0 * x2182
            + x2208 * x23
            + x2209 * x23
            + x2210 * x23
            + x228 * x2569
            + x2563,
            x2058 * x24
            + 3.0 * x2190
            + x2212 * x23
            + x2213 * x23
            + x2214 * x23
            + x228 * x2570
            + x2566,
            x2062 * x24
            + 3.0 * x2197
            + x2217 * x23
            + x2218 * x23
            + x2219 * x23
            + x228 * x2571,
            x142 * x2565
            + x2044
            + x2066 * x24
            + x2221 * x23
            + x2222 * x23
            + x2223 * x23
            + x2571 * x269,
            x142 * (-x19 * (x2577 + x2578 * x327) + x2573 + x2575 * x327)
            + x2084 * x24
            + x2085 * x24
            + x2240 * x23
            + x2241 * x23
            + x68
            * (
                x1 * (x18 * x2575 * x4 * x7 - x2578 * x563) + x68 * (x2580 + x2581 * x327)
            ),
            x1 * (x18 * x2583 * x4 * x7 - x2582 * x563)
            + x2116 * x24
            + x2117 * x24
            + x2269 * x23
            + x2270 * x23
            + x68 * (0.5 * x2585 + x2586 * x327),
            x1 * (x18 * x2588 * x4 * x7 - x2587 * x563)
            + x2134 * x24
            + x2135 * x24
            + x2287 * x23
            + x2288 * x23
            + x68 * (x2591 + x2592 * x327),
            x2144 * x24
            + x2145 * x24
            + x2297 * x23
            + x2298 * x23
            + x2593 * x66
            + x2594 * x327,
            x2156 * x24
            + x2157 * x24
            + x23 * x2306
            + x23 * x2307
            + 0.5 * x2595
            + x2596 * x327,
            x2166 * x24 + x2167 * x24 + x23 * x2316 + x23 * x2317 + x2598 + x2599 * x327,
            x2176 * x24 + x2177 * x24 + x23 * x2326 + x23 * x2327 + x2600 * x68,
            x2183 * x24 + x2184 * x24 + x23 * x2333 + x23 * x2334 + x2601 * x68,
            x2191 * x24 + x2192 * x24 + x23 * x2340 + x23 * x2341 + x2602 * x68,
            x2198 * x24 + x2199 * x24 + x23 * x2347 + x23 * x2348 + x2603 * x68,
            x142 * x2593
            + x2203 * x24
            + x2204 * x24
            + x228 * x2600
            + x23 * x2352
            + x23 * x2353
            + 2.0 * x2323,
            x2207 * x24
            + x2208 * x24
            + x228 * x2601
            + x23 * x2356
            + x23 * x2357
            + 2.0 * x2330
            + x2595,
            x2211 * x24
            + x2212 * x24
            + x228 * x2602
            + x23 * x2360
            + x23 * x2361
            + 2.0 * x2337
            + x2598,
            x2216 * x24
            + x2217 * x24
            + x228 * x2603
            + x23 * x2364
            + x23 * x2365
            + 2.0 * x2344,
            x142 * x2597
            + 2.0 * x2197
            + x2220 * x24
            + x2221 * x24
            + x23 * x2368
            + x23 * x2369
            + x2603 * x269,
            x142 * (-x19 * (x2609 + x2610 * x327) + x2605 + x2607 * x327)
            + x2238 * x24
            + x2239 * x24
            + x2240 * x24
            + x23 * x2387
            + x68
            * (
                x1 * (x18 * x2607 * x4 * x7 - x2610 * x563) + x68 * (x2612 + x2613 * x327)
            ),
            x1 * (x18 * x2615 * x4 * x7 - x2614 * x563)
            + x2267 * x24
            + x2268 * x24
            + x2269 * x24
            + x23 * x2413
            + x68 * (0.5 * x2617 + x2618 * x327),
            x1 * (x18 * x2620 * x4 * x7 - x2619 * x563)
            + x2285 * x24
            + x2286 * x24
            + x2287 * x24
            + x23 * x2431
            + x68 * (x2623 + x2624 * x327),
            x2295 * x24
            + x2296 * x24
            + x2297 * x24
            + x23 * x2441
            + x2625 * x66
            + x2626 * x327,
            x23 * x2449
            + x2304 * x24
            + x2305 * x24
            + x2306 * x24
            + 0.5 * x2627
            + x2628 * x327,
            x23 * x2458 + x2314 * x24 + x2315 * x24 + x2316 * x24 + x2630 + x2631 * x327,
            x23 * x2468 + x2324 * x24 + x2325 * x24 + x2326 * x24 + x2632 * x68,
            x23 * x2475 + x2331 * x24 + x2332 * x24 + x2333 * x24 + x2633 * x68,
            x23 * x2480 + x2338 * x24 + x2339 * x24 + x2340 * x24 + x2634 * x68,
            x23 * x2487 + x2345 * x24 + x2346 * x24 + x2347 * x24 + x2635 * x68,
            x142 * x2625
            + x228 * x2632
            + x23 * x2492
            + x2350 * x24
            + x2351 * x24
            + x2352 * x24
            + x2464,
            x228 * x2633
            + x23 * x2496
            + x2354 * x24
            + x2355 * x24
            + x2356 * x24
            + x2471
            + x2627,
            x228 * x2634
            + x23 * x2500
            + x2358 * x24
            + x2359 * x24
            + x2360 * x24
            + x2481
            + x2630,
            x228 * x2635 + x23 * x2504 + x2362 * x24 + x2363 * x24 + x2364 * x24 + x2483,
            x142 * x2629
            + x23 * x2508
            + 3.0 * x2344
            + x2366 * x24
            + x2367 * x24
            + x2368 * x24
            + x2635 * x269,
            x142 * (-x19 * (x2641 + x2642 * x327) + x2637 + x2639 * x327)
            + x2384 * x24
            + x2385 * x24
            + x2386 * x24
            + x2387 * x24
            + x68
            * (
                x1 * (x18 * x2639 * x4 * x7 - x2642 * x563) + x68 * (x2644 + x2645 * x327)
            ),
            x1 * (x13 * x223 * x224 * x2639 * x7 - x2642 * x970)
            + x24 * x2410
            + x24 * x2411
            + x24 * x2412
            + x24 * x2413
            + x68 * (x2645 * x965 + 0.5 * x2646),
            x1 * (x18 * x2648 * x4 * x7 - x2647 * x563)
            + x24 * x2428
            + x24 * x2429
            + x24 * x2430
            + x24 * x2431
            + x68 * (x2651 + x2652 * x327),
            x24 * x2438
            + x24 * x2439
            + x24 * x2440
            + x24 * x2441
            + x2653 * x66
            + x2654 * x327,
            x24 * x2446
            + x24 * x2447
            + x24 * x2448
            + x24 * x2449
            + x2652 * x965
            + 0.5 * x2655,
            x24 * x2455 + x24 * x2456 + x24 * x2457 + x24 * x2458 + x2657 + x2658 * x327,
            x24 * x2465 + x24 * x2466 + x24 * x2467 + x24 * x2468 + x2659 * x68,
            x24 * x2472 + x24 * x2473 + x24 * x2474 + x24 * x2475 + x2660 * x68,
            x229 * x2658 + x24 * x2477 + x24 * x2478 + x24 * x2479 + x24 * x2480,
            x24 * x2484 + x24 * x2485 + x24 * x2486 + x24 * x2487 + x2661 * x68,
            x142 * x2653
            + x228 * x2659
            + x24 * x2489
            + x24 * x2490
            + x24 * x2491
            + x24 * x2492,
            x228 * x2660 + x24 * x2493 + x24 * x2494 + x24 * x2495 + x24 * x2496 + x2655,
            x24 * x2497 + x24 * x2498 + x24 * x2499 + x24 * x2500 + x2657 + x2658 * x304,
            x228 * x2661 + x24 * x2501 + x24 * x2502 + x24 * x2503 + x24 * x2504,
            x142 * x2656
            + x24 * x2505
            + x24 * x2506
            + x24 * x2507
            + x24 * x2508
            + 4.0 * x2483
            + x2661 * x269,
        ]
    )


def _3center2el3d_045(a, A, b, B, c, C):
    """Cartesian (sg|h) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = c ** (-1.0)
    x2 = 2.0 * a + 2.0 * b
    x3 = (2.0 * c + x2) ** (-1.0)
    x4 = x2 ** (-1.0)
    x5 = a + b
    x6 = x5 ** (-1.0)
    x7 = -x6 * (a * A[0] + b * B[0])
    x8 = -x7 - C[0]
    x9 = x8**2
    x10 = -x6 * (a * A[1] + b * B[1])
    x11 = -x10 - C[1]
    x12 = x11**2
    x13 = -x6 * (a * A[2] + b * B[2])
    x14 = -x13 - C[2]
    x15 = x14**2
    x16 = c + x5
    x17 = x16 ** (-1.0)
    x18 = c * x17
    x19 = x18 * x5 * (x12 + x15 + x9)
    x20 = boys(2, x19)
    x21 = x16 ** (-1.5)
    x22 = 17.4934183276249
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x6 * (x0**2 + x23**2 + x24**2))
    x26 = x22 * x25
    x27 = x21 * x26
    x28 = x20 * x27
    x29 = 2.0 * x6
    x30 = x28 * x29
    x31 = x16 ** (-0.5)
    x32 = boys(1, x19)
    x33 = -2.0 * x1 * x22 * x25 * x31 * x32 * x6
    x34 = -x30 - x33
    x35 = x34 * x4
    x36 = -x7 - A[0]
    x37 = -2.0 * x1 * x22 * x25 * x31 * x32 * x36 * x6 + x30 * x8
    x38 = -x37
    x39 = boys(3, x19)
    x40 = x27 * x29
    x41 = x39 * x40
    x42 = -2.0 * x1 * x20 * x22 * x25 * x31 * x36 * x6 + x41 * x8
    x43 = -x42
    x44 = x18 * x43
    x45 = x44 * x8
    x46 = x35 + x36 * x38 - x45
    x47 = x3 * x46
    x48 = -2.0 * x1 * x20 * x22 * x25 * x31 * x6
    x49 = -x41 - x48
    x50 = x4 * x49
    x51 = boys(4, x19)
    x52 = x40 * x51
    x53 = -2.0 * x1 * x22 * x25 * x31 * x36 * x39 * x6 + x52 * x8
    x54 = -x53
    x55 = x18 * x54
    x56 = x55 * x8
    x57 = x36 * x43 + x50 - x56
    x58 = x3 * x57
    x59 = -x42 - x55
    x60 = 2.0 * x4
    x61 = -2.0 * x1 * x22 * x25 * x31 * x39 * x6
    x62 = -x52 - x61
    x63 = x4 * x62
    x64 = boys(5, x19)
    x65 = x40 * x64
    x66 = -2.0 * x1 * x22 * x25 * x31 * x36 * x51 * x6 + x65 * x8
    x67 = -x66
    x68 = x18 * x67
    x69 = x68 * x8
    x70 = x36 * x54 + x63 - x69
    x71 = x18 * x70
    x72 = x71 * x8
    x73 = x36 * x57 + x59 * x60 - x72
    x74 = x17 * x5
    x75 = x73 * x74
    x76 = 3.0 * x58 + x75 * x8
    x77 = -x37 - x44
    x78 = x18 * x57
    x79 = x78 * x8
    x80 = x36 * x46 + x60 * x77 - x79
    x81 = x74 * x8
    x82 = x57 * x74
    x83 = -x34 * x4
    x84 = -x36 * x38 + x45 + x83
    x85 = 0.5 * x1
    x86 = x85 * (-x82 - x84)
    x87 = x54 * x74
    x88 = 2.0 * x3
    x89 = x1 * x88
    x90 = x39 * x89
    x91 = x26 * x31 * x6
    x92 = x90 * x91
    x93 = x8 * x87 + x92
    x94 = x3 * x54
    x95 = 2.0 * x94
    x96 = x70 * x74
    x97 = x8 * x96 + x95
    x98 = x74 * x97
    x99 = x8 * x98 + x86 + x88 * x93
    x100 = 3.0 * x3
    x101 = x3 * x70
    x102 = 3.0 * x101
    x103 = -x53 - x68
    x104 = 2.0 * x1 * x22 * x25 * x31 * x51 * x6 - x65
    x105 = x104 * x4
    x106 = boys(6, x19)
    x107 = x106 * x40
    x108 = -2.0 * x1 * x22 * x25 * x31 * x36 * x6 * x64 + x107 * x8
    x109 = -x108
    x110 = x109 * x18
    x111 = x110 * x8
    x112 = x105 - x111 + x36 * x67
    x113 = x112 * x18
    x114 = x113 * x8
    x115 = x103 * x60 - x114 + x36 * x70
    x116 = x115 * x74
    x117 = x102 + x116 * x8
    x118 = x117 * x74
    x119 = -x4 * x49
    x120 = x119 - x36 * x43 + x56
    x121 = x85 * (-x120 - x96)
    x122 = x67 * x74
    x123 = x89 * x91
    x124 = x123 * x51
    x125 = x122 * x8 + x124
    x126 = x3 * x67
    x127 = 2.0 * x126
    x128 = x112 * x74
    x129 = x127 + x128 * x8
    x130 = x129 * x74
    x131 = x121 + x125 * x88 + x130 * x8
    x132 = x85 * (-x116 + x36 * x57 + 2.0 * x4 * x59 - x72)
    x133 = x112 * x3
    x134 = 3.0 * x133
    x135 = 2.0 * x1 * x22 * x25 * x31 * x6 * x64 - x107
    x136 = x135 * x4
    x137 = boys(7, x19)
    x138 = x137 * x40
    x139 = -2.0 * x1 * x106 * x22 * x25 * x31 * x36 * x6 + x138 * x8
    x140 = -x139
    x141 = x140 * x18
    x142 = x141 * x8
    x143 = x109 * x36 + x136 - x142
    x144 = x143 * x18
    x145 = x112 * x36 - x144 * x8 + x60 * (-x110 - x66)
    x146 = x145 * x74
    x147 = x134 + x146 * x8
    x148 = x147 * x74
    x149 = x100 * x129 + x132 + x148 * x8
    x150 = x149 * x74
    x151 = x85 * (x36 * x46 + 2.0 * x4 * x77 - x75 - x79)
    x152 = x100 * x97 + x118 * x8 + x151
    x153 = 2.0 * x1
    x154 = x125 * x74
    x155 = x153 * x27
    x156 = x85 * (-x155 * x51 - x61)
    x157 = x16 ** (-2.5)
    x158 = x157 * x5
    x159 = x153 * x26
    x160 = x159 * x9
    x161 = x160 * x64
    x162 = x156 + x158 * x161
    x163 = x85 * (-x122 - x53)
    x164 = x123 * x64
    x165 = x109 * x81 + x164
    x166 = x27 * x8
    x167 = x64 * x89
    x168 = x163 + x165 * x81 + x166 * x167
    x169 = x1 * (-x154 + x93) + x162 * x3 + x168 * x81
    x170 = x131 * x74
    x171 = 1.5 * x1
    x172 = -x4 * x62
    x173 = x172 - x36 * x54 + x69
    x174 = x85 * (-x128 - x173)
    x175 = x109 * x3
    x176 = 2.0 * x175
    x177 = x143 * x81 + x176
    x178 = x165 * x88 + x174 + x177 * x81
    x179 = x1 * (-x130 + x97) + x168 * x88 + x178 * x81
    x180 = x169 * x88 + x171 * (-x170 + x99) + x179 * x81
    x181 = x85 * (2.0 * x103 * x4 - x114 - x146 + x36 * x70)
    x182 = x143 * x3
    x183 = 3.0 * x182
    x184 = x4 * (2.0 * x1 * x106 * x22 * x25 * x31 * x6 - x138)
    x185 = boys(8, x19)
    x186 = x185 * x40
    x187 = 2.0 * x1 * x137 * x22 * x25 * x31 * x36 * x6 - x186 * x8
    x188 = x18 * x187
    x189 = x140 * x36 + x184 - x188 * x8
    x190 = x18 * x189
    x191 = x143 * x36 - x190 * x8 + x60 * (-x108 - x141)
    x192 = x183 + x191 * x81
    x193 = x100 * x177 + x181 + x192 * x81
    x194 = x1 * (x117 - x148) + x100 * x178 + x193 * x81
    x195 = x100 * x179 + x171 * (-x150 + x152) + x194 * x81
    x196 = (
        x100 * x180
        + x153
        * (
            x1 * (3.0 * x47 - x74 * x76 + x80 * x81)
            + x100 * x99
            + x152 * x81
            - x74 * (x1 * (-x118 + x76) + x100 * x131 + x150 * x8)
        )
        + x195 * x81
    )
    x197 = x3 * x38
    x198 = x3 * x43
    x199 = 2.0 * x198 + x8 * x82
    x200 = x43 * x74
    x201 = x85 * (-x200 - x37)
    x202 = x74 * x93
    x203 = x166 * x90 + x201 + x202 * x8
    x204 = x85 * (-x42 - x87)
    x205 = x51 * x89
    x206 = x154 * x8 + x166 * x205 + x204
    x207 = x158 * x51
    x208 = x159 * x8
    x209 = x1 * (2.0 * x1 * x21 * x22 * x25 * x39 * x8 - x207 * x208) + x162 * x81
    x210 = x206 * x74
    x211 = x169 * x81 + x171 * (x203 - x210) + x209 * x3
    x212 = (
        x153
        * (
            x1 * (2.0 * x197 - x199 * x74 + x46 * x81)
            + x203 * x88
            - x74 * (x1 * (x199 - x98) + x170 * x8 + x206 * x88)
            + x81 * x99
        )
        + x180 * x81
        + x211 * x88
    )
    x213 = x0 * x212 + x196
    x214 = x85 * (-x155 * x39 - x48)
    x215 = x160 * x207 + x214
    x216 = x215 * x74
    x217 = x85 * (-x153 * x28 - x33)
    x218 = x158 * x39
    x219 = x160 * x218 + x217
    x220 = x171 * (-x216 + x219) + x209 * x81
    x221 = x123 * x20
    x222 = x200 * x8 + x221
    x223 = x123 * x32
    x224 = (
        x153
        * (
            x1 * (-x222 * x74 + x223 + x38 * x81)
            + x203 * x81
            + x219 * x3
            - x74 * (x1 * (-x202 + x222) + x210 * x8 + x215 * x3)
        )
        + x211 * x81
        + x220 * x3
    )
    x225 = x0 * x224 + x212
    x226 = x0 * x225 + x213
    x227 = x158 * x20
    x228 = (
        x153
        * (
            x1 * (2.0 * x1 * x21 * x22 * x25 * x32 * x8 - x208 * x227)
            + x219 * x81
            - x74
            * (x1 * (2.0 * x1 * x20 * x21 * x22 * x25 * x8 - x208 * x218) + x216 * x8)
        )
        + x220 * x81
    )
    x229 = x3 * x80
    x230 = x3 * x73
    x231 = -x120 - x71
    x232 = 3.0 * x4
    x233 = x18 * x8
    x234 = x115 * x233
    x235 = x231 * x232 - x234 + x36 * x73
    x236 = x235 * x74
    x237 = 4.0 * x230 + x236 * x8
    x238 = -x78 - x84
    x239 = x233 * x73
    x240 = x232 * x238 - x239 + x36 * x80
    x241 = 4.0 * x3
    x242 = x115 * x3
    x243 = 4.0 * x242
    x244 = -x113 - x173
    x245 = x145 * x233
    x246 = x115 * x36 + x232 * x244 - x245
    x247 = x246 * x74
    x248 = x243 + x247 * x8
    x249 = x248 * x74
    x250 = x85 * (3.0 * x231 * x4 - x234 - x247 + x36 * x73)
    x251 = x145 * x3
    x252 = 4.0 * x251
    x253 = -x104 * x4
    x254 = x145 * x36 - x191 * x233 + x232 * (-x111 - x144 - x253 + x36 * x67)
    x255 = x254 * x74
    x256 = x74 * (x252 + x255 * x8)
    x257 = x74 * (x147 * x241 + x250 + x256 * x8)
    x258 = x85 * (-x236 + 3.0 * x238 * x4 - x239 + x36 * x80)
    x259 = x117 * x241 + x249 * x8 + x258
    x260 = x85 * (x115 * x36 + 3.0 * x244 * x4 - x245 - x255)
    x261 = x191 * x3
    x262 = 4.0 * x261
    x263 = -x135 * x4
    x264 = x4 * (2.0 * x1 * x137 * x22 * x25 * x31 * x6 - x186)
    x265 = x40 * boys(9, x19)
    x266 = (
        x191 * x36
        + x232 * (x109 * x36 - x142 - x190 - x263)
        - x233
        * (
            x189 * x36
            - x233
            * (
                x187 * x36
                - x233 * (2.0 * x1 * x185 * x22 * x25 * x31 * x36 * x6 - x265 * x8)
                + x264
            )
            + x60 * (-x139 - x188)
        )
    )
    x267 = x5**2
    x268 = x16 ** (-2.0)
    x269 = x267 * x268
    x270 = x11 * x269
    x271 = x112 * x270
    x272 = x11 * x74
    x273 = x127 * x272 + x271 * x8
    x274 = x273 * x74
    x275 = x270 * x70
    x276 = x272 * x95 + x275 * x8
    x277 = x11 * x67
    x278 = x269 * x277
    x279 = x1 * (x11 * x17 * x5 * x54 - x278)
    x280 = x270 * x8
    x281 = x11 * x27
    x282 = x167 * x281
    x283 = x109 * x280 + x282
    x284 = x158 * x26
    x285 = x284 * x8
    x286 = x11 * x285
    x287 = x167 * x286 + 0.5 * x279 + x283 * x81
    x288 = x1 * (x11 * x17 * x5 * x70 - x271)
    x289 = x143 * x280 + x176 * x272
    x290 = x283 * x88 + 0.5 * x288 + x289 * x81
    x291 = x1 * (-x274 + x276) + x287 * x88 + x290 * x81
    x292 = x1 * (x11 * x17 * x5 * x80 - x270 * x73)
    x293 = x115 * x270
    x294 = x1 * (x11 * x17 * x5 * x73 - x293)
    x295 = x145 * x270
    x296 = x134 * x272 + x295 * x8
    x297 = x296 * x74
    x298 = x102 * x272 + x293 * x8
    x299 = x1 * (x11 * x115 * x17 * x5 - x295)
    x300 = x183 * x272 + x191 * x280
    x301 = x100 * x289 + 0.5 * x299 + x300 * x81
    x302 = x1 * (-x297 + x298) + x100 * x290 + x301 * x81
    x303 = (
        x100 * x291
        + x171
        * (
            x100 * x276
            + 0.5 * x292
            + x298 * x81
            - x74 * (x100 * x273 + 0.5 * x294 + x297 * x8)
        )
        + x302 * x81
    )
    x304 = x205 * x281
    x305 = x278 * x8 + x304
    x306 = x305 * x74
    x307 = x270 * x54
    x308 = x281 * x90
    x309 = x307 * x8 + x308
    x310 = x11 * x159
    x311 = x1 * (2.0 * x1 * x11 * x21 * x22 * x25 * x39 - x207 * x310)
    x312 = x16 ** (-3.5)
    x313 = x267 * x312
    x314 = x11 * x313
    x315 = x161 * x314 + 0.5 * x311
    x316 = x1 * (-x306 + x309) + x287 * x81 + x3 * x315
    x317 = x1 * (x11 * x17 * x46 * x5 - x270 * x57)
    x318 = x1 * (x11 * x17 * x5 * x57 - x275)
    x319 = (
        x171
        * (
            x276 * x81
            + x309 * x88
            + 0.5 * x317
            - x74 * (x274 * x8 + x305 * x88 + 0.5 * x318)
        )
        + x291 * x81
        + x316 * x88
    )
    x320 = x0 * x319 + x303
    x321 = x314 * x51
    x322 = (
        x1 * (2.0 * x1 * x11 * x157 * x22 * x25 * x39 * x5 * x8 - x208 * x321)
        + x315 * x81
    )
    x323 = x1 * (x11 * x17 * x38 * x5 - x270 * x43)
    x324 = x1 * (x11 * x17 * x43 * x5 - x307)
    x325 = (
        x171
        * (
            x286 * x90
            + x309 * x81
            + 0.5 * x323
            - x74 * (x205 * x286 + x306 * x8 + 0.5 * x324)
        )
        + x3 * x322
        + x316 * x81
    )
    x326 = x0 * x325 + x319
    x327 = x0 * x326 + x320
    x328 = x1 * (2.0 * x1 * x11 * x21 * x22 * x25 * x32 - x227 * x310)
    x329 = x1 * (2.0 * x1 * x11 * x20 * x21 * x22 * x25 - x218 * x310)
    x330 = x160 * x39
    x331 = (
        x171 * (x314 * x330 + 0.5 * x328 - x74 * (x160 * x321 + 0.5 * x329)) + x322 * x81
    )
    x332 = x1 * (x11 * x17 * x240 * x5 - x235 * x270)
    x333 = x246 * x270
    x334 = x1 * (x11 * x17 * x235 * x5 - x333)
    x335 = x254 * x270
    x336 = x74 * (x252 * x272 + x335 * x8)
    x337 = x243 * x272 + x333 * x8
    x338 = x1 * (x11 * x17 * x246 * x5 - x335)
    x339 = x14 * x269
    x340 = x112 * x339
    x341 = x14 * x74
    x342 = x127 * x341 + x340 * x8
    x343 = x342 * x74
    x344 = x339 * x70
    x345 = x341 * x95 + x344 * x8
    x346 = x339 * x67
    x347 = x1 * (x14 * x17 * x5 * x54 - x346)
    x348 = 0.5 * x347
    x349 = x339 * x8
    x350 = x14 * x27
    x351 = x167 * x350
    x352 = x109 * x349 + x351
    x353 = x14 * x285
    x354 = x167 * x353 + x348 + x352 * x81
    x355 = x1 * (x14 * x17 * x5 * x70 - x340)
    x356 = 0.5 * x355
    x357 = x143 * x349 + x176 * x341
    x358 = x352 * x88 + x356 + x357 * x81
    x359 = x1 * (-x343 + x345) + x354 * x88 + x358 * x81
    x360 = x1 * (x14 * x17 * x5 * x80 - x339 * x73)
    x361 = 0.5 * x360
    x362 = x115 * x339
    x363 = x1 * (x14 * x17 * x5 * x73 - x362)
    x364 = 0.5 * x363
    x365 = x145 * x339
    x366 = x134 * x341 + x365 * x8
    x367 = x366 * x74
    x368 = x102 * x341 + x362 * x8
    x369 = x1 * (x115 * x14 * x17 * x5 - x365)
    x370 = 0.5 * x369
    x371 = x183 * x341 + x191 * x349
    x372 = x100 * x357 + x370 + x371 * x81
    x373 = x1 * (-x367 + x368) + x100 * x358 + x372 * x81
    x374 = (
        x100 * x359
        + x171
        * (x100 * x345 + x361 + x368 * x81 - x74 * (x100 * x342 + x364 + x367 * x8))
        + x373 * x81
    )
    x375 = x205 * x350
    x376 = x346 * x8 + x375
    x377 = x376 * x74
    x378 = x339 * x54
    x379 = x350 * x90
    x380 = x378 * x8 + x379
    x381 = x14 * x159
    x382 = x1 * (2.0 * x1 * x14 * x21 * x22 * x25 * x39 - x207 * x381)
    x383 = 0.5 * x382
    x384 = x14 * x313
    x385 = x161 * x384 + x383
    x386 = x1 * (-x377 + x380) + x3 * x385 + x354 * x81
    x387 = x1 * (x14 * x17 * x46 * x5 - x339 * x57)
    x388 = 0.5 * x387
    x389 = x1 * (x14 * x17 * x5 * x57 - x344)
    x390 = 0.5 * x389
    x391 = (
        x171 * (x345 * x81 + x380 * x88 + x388 - x74 * (x343 * x8 + x376 * x88 + x390))
        + x359 * x81
        + x386 * x88
    )
    x392 = x0 * x391 + x374
    x393 = x384 * x51
    x394 = (
        x1 * (2.0 * x1 * x14 * x157 * x22 * x25 * x39 * x5 * x8 - x208 * x393)
        + x385 * x81
    )
    x395 = x1 * (x14 * x17 * x38 * x5 - x339 * x43)
    x396 = 0.5 * x395
    x397 = x1 * (x14 * x17 * x43 * x5 - x378)
    x398 = 0.5 * x397
    x399 = (
        x171 * (x353 * x90 + x380 * x81 + x396 - x74 * (x205 * x353 + x377 * x8 + x398))
        + x3 * x394
        + x386 * x81
    )
    x400 = x0 * x399 + x391
    x401 = x0 * x400 + x392
    x402 = x1 * (2.0 * x1 * x14 * x21 * x22 * x25 * x32 - x227 * x381)
    x403 = 0.5 * x402
    x404 = x1 * (2.0 * x1 * x14 * x20 * x21 * x22 * x25 - x218 * x381)
    x405 = 0.5 * x404
    x406 = x171 * (x330 * x384 + x403 - x74 * (x160 * x393 + x405)) + x394 * x81
    x407 = x1 * (x14 * x17 * x240 * x5 - x235 * x339)
    x408 = 0.5 * x407
    x409 = x246 * x339
    x410 = x1 * (x14 * x17 * x235 * x5 - x409)
    x411 = 0.5 * x410
    x412 = x254 * x339
    x413 = x74 * (x252 * x341 + x412 * x8)
    x414 = x243 * x341 + x409 * x8
    x415 = x1 * (x14 * x17 * x246 * x5 - x412)
    x416 = 0.5 * x415
    x417 = x12 * x269
    x418 = x115 * x417 + x151
    x419 = x3 * x418
    x420 = x132 + x145 * x417
    x421 = x3 * x420
    x422 = x74 * (x250 + x254 * x417)
    x423 = x246 * x417 + x258
    x424 = x417 * x70 + x86
    x425 = x3 * x424
    x426 = x112 * x417 + x121
    x427 = x3 * x426
    x428 = x420 * x74
    x429 = x426 * x74
    x430 = x424 - x429
    x431 = x12 * x159
    x432 = x158 * x64
    x433 = x156 + x431 * x432
    x434 = x3 * x433
    x435 = x109 * x417 + x163
    x436 = x434 + x435 * x81
    x437 = x3 * x435
    x438 = x143 * x417 + x174
    x439 = 2.0 * x437 + x438 * x81
    x440 = x430 * x85 + x436 * x88 + x439 * x81
    x441 = x418 - x428
    x442 = x3 * x438
    x443 = x181 + x191 * x417
    x444 = 3.0 * x442 + x443 * x81
    x445 = x100 * x439 + x441 * x85 + x444 * x81
    x446 = (
        x1 * (x418 * x81 + 3.0 * x425 - x74 * (3.0 * x427 + x428 * x8))
        + x100 * x440
        + x445 * x81
    )
    x447 = x201 + x417 * x54
    x448 = x3 * x447
    x449 = x204 + x417 * x67
    x450 = x3 * x449
    x451 = x449 * x74
    x452 = x447 - x451
    x453 = x434 * x81 + x436 * x81 + x452 * x85
    x454 = (
        x1 * (x424 * x81 + 2.0 * x448 - x74 * (x429 * x8 + 2.0 * x450))
        + x440 * x81
        + x453 * x88
    )
    x455 = x0 * x454 + x446
    x456 = x217 + x218 * x431
    x457 = x3 * x456
    x458 = x207 * x431 + x214
    x459 = x3 * x458
    x460 = x458 * x74
    x461 = x456 - x460
    x462 = x269 * x9
    x463 = x433 * x462 + x461 * x85
    x464 = x1 * (x447 * x81 + x457 - x74 * (x451 * x8 + x459)) + x3 * x463 + x453 * x81
    x465 = x0 * x464 + x454
    x466 = x0 * x465 + x455
    x467 = x269 * x8
    x468 = x1 * (x17 * x456 * x5 * x8 - x458 * x467) + x463 * x81
    x469 = -x422 + x423
    x470 = x3 * x443
    x471 = x260 + x266 * x417
    x472 = x11 * x14
    x473 = x5**3
    x474 = x473 / x16**3
    x475 = x472 * x474
    x476 = x254 * x475
    x477 = x14 * x270
    x478 = x475 * x8
    x479 = x145 * x475
    x480 = x112 * x475
    x481 = x1 * (x11 * x14 * x267 * x268 * x70 - x480)
    x482 = x284 * x472
    x483 = x167 * x482
    x484 = x109 * x478 + x483
    x485 = x143 * x478 + x176 * x477
    x486 = 0.5 * x481 + x484 * x88 + x485 * x81
    x487 = x1 * (x11 * x115 * x14 * x267 * x268 - x479)
    x488 = x183 * x477 + x191 * x478
    x489 = x100 * x485 + 0.5 * x487 + x488 * x81
    x490 = (
        x1 * (x102 * x477 + x115 * x478 - x74 * (x134 * x477 + x479 * x8))
        + x100 * x486
        + x489 * x81
    )
    x491 = x14 * x474
    x492 = x277 * x491
    x493 = x1 * (x11 * x14 * x267 * x268 * x54 - x492)
    x494 = x167 * x26 * x313 * x472 * x8 + x484 * x81 + 0.5 * x493
    x495 = (
        x1 * (x477 * x95 + x478 * x70 - x74 * (x127 * x477 + x480 * x8))
        + x486 * x81
        + x494 * x88
    )
    x496 = x0 * x495 + x490
    x497 = x205 * x482
    x498 = x482 * x90
    x499 = x313 * x51
    x500 = x1 * (2.0 * x1 * x11 * x14 * x157 * x22 * x25 * x39 * x5 - x159 * x472 * x499)
    x501 = x16 ** (-4.5) * x472 * x473
    x502 = x161 * x501 + 0.5 * x500
    x503 = x1 * (x478 * x54 + x498 - x74 * (x492 * x8 + x497)) + x3 * x502 + x494 * x81
    x504 = x0 * x503 + x495
    x505 = x0 * x504 + x496
    x506 = (
        x1
        * (2.0 * x1 * x11 * x14 * x22 * x25 * x267 * x312 * x39 * x8 - x208 * x501 * x51)
        + x502 * x81
    )
    x507 = x1 * (x11 * x14 * x246 * x267 * x268 - x476)
    x508 = x15 * x269
    x509 = x115 * x508 + x151
    x510 = x3 * x509
    x511 = x132 + x145 * x508
    x512 = x3 * x511
    x513 = x250 + x254 * x508
    x514 = x513 * x74
    x515 = x246 * x508 + x258
    x516 = x508 * x70 + x86
    x517 = x3 * x516
    x518 = x112 * x508 + x121
    x519 = x3 * x518
    x520 = x511 * x74
    x521 = x518 * x74
    x522 = x516 - x521
    x523 = x522 * x85
    x524 = x15 * x159
    x525 = x156 + x432 * x524
    x526 = x3 * x525
    x527 = x109 * x508 + x163
    x528 = x526 + x527 * x81
    x529 = x3 * x527
    x530 = 2.0 * x529
    x531 = x143 * x508 + x174
    x532 = x530 + x531 * x81
    x533 = x523 + x528 * x88 + x532 * x81
    x534 = x509 - x520
    x535 = x534 * x85
    x536 = x3 * x531
    x537 = 3.0 * x536
    x538 = x181 + x191 * x508
    x539 = x537 + x538 * x81
    x540 = x100 * x532 + x535 + x539 * x81
    x541 = (
        x1 * (x509 * x81 + 3.0 * x517 - x74 * (3.0 * x519 + x520 * x8))
        + x100 * x533
        + x540 * x81
    )
    x542 = x201 + x508 * x54
    x543 = x3 * x542
    x544 = x204 + x508 * x67
    x545 = x3 * x544
    x546 = x544 * x74
    x547 = x542 - x546
    x548 = x547 * x85
    x549 = x526 * x81 + x528 * x81 + x548
    x550 = (
        x1 * (x516 * x81 + 2.0 * x543 - x74 * (x521 * x8 + 2.0 * x545))
        + x533 * x81
        + x549 * x88
    )
    x551 = x0 * x550 + x541
    x552 = x217 + x218 * x524
    x553 = x3 * x552
    x554 = x207 * x524 + x214
    x555 = x3 * x554
    x556 = x554 * x74
    x557 = x552 - x556
    x558 = x557 * x85
    x559 = x462 * x525 + x558
    x560 = x1 * (x542 * x81 + x553 - x74 * (x546 * x8 + x555)) + x3 * x559 + x549 * x81
    x561 = x0 * x560 + x550
    x562 = x0 * x561 + x551
    x563 = x1 * (x17 * x5 * x552 * x8 - x467 * x554) + x559 * x81
    x564 = -x514 + x515
    x565 = x564 * x85
    x566 = x3 * x538
    x567 = 4.0 * x566
    x568 = x260 + x266 * x508
    x569 = x272 * x418 + x292 - x74 * (x11 * x428 + x294)
    x570 = x272 * x435 + x279
    x571 = x3 * x570
    x572 = x272 * x438 + x288
    x573 = 2.0 * x571 + x572 * x81
    x574 = x3 * x572
    x575 = x272 * x443 + x299
    x576 = 3.0 * x574 + x575 * x81
    x577 = x100 * x573 + x569 * x85 + x576 * x81
    x578 = x272 * x424 + x317 - x74 * (x11 * x429 + x318)
    x579 = x272 * x433 + x311
    x580 = x3 * x579
    x581 = x570 * x81 + x580
    x582 = x573 * x81 + x578 * x85 + x581 * x88
    x583 = x0 * x582 + x577
    x584 = x272 * x447 + x323 - x74 * (x11 * x451 + x324)
    x585 = x580 * x81 + x581 * x81 + x584 * x85
    x586 = x0 * x585 + x582
    x587 = x0 * x586 + x583
    x588 = x272 * x456 + x328 - x74 * (x11 * x460 + x329)
    x589 = x462 * x579 + x588 * x85
    x590 = x272 * x423 + x332 - x74 * (x11 * x422 + x334)
    x591 = x3 * x575
    x592 = x272 * x471 + x338
    x593 = x12 * x491
    x594 = x115 * x593 + x361 - x74 * (x145 * x593 + x364)
    x595 = x109 * x593 + x348
    x596 = x3 * x595
    x597 = x143 * x593 + x356
    x598 = 2.0 * x596 + x597 * x81
    x599 = x3 * x597
    x600 = x191 * x593 + x370
    x601 = 3.0 * x599 + x600 * x81
    x602 = x100 * x598 + x594 * x85 + x601 * x81
    x603 = x388 + x593 * x70 - x74 * (x112 * x593 + x390)
    x604 = x12 * x381
    x605 = x313 * x604
    x606 = x383 + x605 * x64
    x607 = x3 * x606
    x608 = x595 * x81 + x607
    x609 = x598 * x81 + x603 * x85 + x608 * x88
    x610 = x0 * x609 + x602
    x611 = x396 + x54 * x593 - x74 * (x398 + x593 * x67)
    x612 = x607 * x81 + x608 * x81 + x611 * x85
    x613 = x0 * x612 + x609
    x614 = x0 * x613 + x610
    x615 = x39 * x605 + x403 - x74 * (x405 + x499 * x604)
    x616 = x462 * x606 + x615 * x85
    x617 = x246 * x593 + x408 - x74 * (x254 * x593 + x411)
    x618 = x3 * x600
    x619 = x266 * x593 + x416
    x620 = x1 * (x11 * x17 * x5 * x509 - x270 * x511)
    x621 = x272 * x530 + x280 * x531
    x622 = x272 * x537 + x280 * x538
    x623 = x100 * x621 + 0.5 * x620 + x622 * x81
    x624 = x1 * (x11 * x17 * x5 * x516 - x270 * x518)
    x625 = x272 * x526
    x626 = x280 * x527 + x625
    x627 = x621 * x81 + 0.5 * x624 + x626 * x88
    x628 = x0 * x627 + x623
    x629 = x1 * (x11 * x17 * x5 * x542 - x270 * x544)
    x630 = x280 * x526 + x626 * x81 + 0.5 * x629
    x631 = x0 * x630 + x627
    x632 = x0 * x631 + x628
    x633 = x1 * (x11 * x17 * x5 * x552 - x270 * x554)
    x634 = x11 * x474
    x635 = x634 * x9
    x636 = x525 * x635 + 0.5 * x633
    x637 = x1 * (x11 * x17 * x5 * x515 - x270 * x513)
    x638 = x341 * x509 + x360 - x74 * (x14 * x520 + x363)
    x639 = x638 * x85
    x640 = x341 * x527 + x347
    x641 = x3 * x640
    x642 = 2.0 * x641
    x643 = x341 * x531 + x355
    x644 = x642 + x643 * x81
    x645 = x3 * x643
    x646 = 3.0 * x645
    x647 = x341 * x538 + x369
    x648 = x646 + x647 * x81
    x649 = x100 * x644 + x639 + x648 * x81
    x650 = x341 * x516 + x387 - x74 * (x14 * x521 + x389)
    x651 = x650 * x85
    x652 = x341 * x525 + x382
    x653 = x3 * x652
    x654 = x640 * x81 + x653
    x655 = x644 * x81 + x651 + x654 * x88
    x656 = x0 * x655 + x649
    x657 = x341 * x542 + x395 - x74 * (x14 * x546 + x397)
    x658 = x657 * x85
    x659 = x653 * x81 + x654 * x81 + x658
    x660 = x0 * x659 + x655
    x661 = x0 * x660 + x656
    x662 = x341 * x552 + x402 - x74 * (x14 * x556 + x404)
    x663 = x662 * x85
    x664 = x462 * x652 + x663
    x665 = x341 * x515 + x407 - x74 * (x14 * x514 + x410)
    x666 = x665 * x85
    x667 = x3 * x647
    x668 = 4.0 * x667
    x669 = x341 * x568 + x415
    x670 = x171 * x430 + x272 * x572
    x671 = x3 * x670
    x672 = x171 * x441 + x272 * x575
    x673 = 3.0 * x671 + x672 * x81
    x674 = x171 * x452 + x272 * x570
    x675 = x3 * x674
    x676 = x670 * x81 + 2.0 * x675
    x677 = x0 * x676 + x673
    x678 = x171 * x461 + x272 * x579
    x679 = x3 * x678
    x680 = x674 * x81 + x679
    x681 = x0 * x680 + x676
    x682 = x0 * x681 + x677
    x683 = x0 * x81
    x684 = x3 * x672
    x685 = x171 * x469 + x272 * x592
    x686 = x272 * x597 + x481
    x687 = x3 * x686
    x688 = x272 * x600 + x487
    x689 = 3.0 * x687 + x688 * x81
    x690 = x272 * x595 + x493
    x691 = x3 * x690
    x692 = x686 * x81 + 2.0 * x691
    x693 = x0 * x692 + x689
    x694 = x272 * x606 + x500
    x695 = x3 * x694
    x696 = x690 * x81 + x695
    x697 = x0 * x696 + x692
    x698 = x0 * x697 + x693
    x699 = x3 * x688
    x700 = x272 * x619 + x507
    x701 = x417 * x531 + x523
    x702 = x3 * x701
    x703 = x417 * x538 + x535
    x704 = 3.0 * x702 + x703 * x81
    x705 = x417 * x527 + x548
    x706 = x3 * x705
    x707 = x701 * x81 + 2.0 * x706
    x708 = x0 * x707 + x704
    x709 = x417 * x525 + x558
    x710 = x3 * x709
    x711 = x705 * x81 + x710
    x712 = x0 * x711 + x707
    x713 = x0 * x712 + x708
    x714 = x3 * x703
    x715 = x417 * x568 + x565
    x716 = x272 * x646 + x280 * x647
    x717 = x272 * x642 + x280 * x643
    x718 = x0 * x717 + x716
    x719 = x272 * x653
    x720 = x280 * x640 + x719
    x721 = x0 * x720 + x717
    x722 = x0 * x721 + x718
    x723 = x280 * x652
    x724 = x171 * x522 + x341 * x643
    x725 = x3 * x724
    x726 = x171 * x534 + x341 * x647
    x727 = 3.0 * x725 + x726 * x81
    x728 = x171 * x547 + x341 * x640
    x729 = x3 * x728
    x730 = x724 * x81 + 2.0 * x729
    x731 = x0 * x730 + x727
    x732 = x171 * x557 + x341 * x652
    x733 = x3 * x732
    x734 = x728 * x81 + x733
    x735 = x0 * x734 + x730
    x736 = x0 * x735 + x731
    x737 = x3 * x726
    x738 = x171 * x564 + x341 * x669
    x739 = x153 * x569 + x272 * x672
    x740 = x153 * x578 + x272 * x670
    x741 = x0 * x740 + x739
    x742 = x153 * x584 + x272 * x674
    x743 = x0 * x742 + x740
    x744 = x0 * x743 + x741
    x745 = x153 * x588 + x272 * x678
    x746 = x171 * x594 + x272 * x688
    x747 = x171 * x603 + x272 * x686
    x748 = x0 * x747 + x746
    x749 = x171 * x611 + x272 * x690
    x750 = x0 * x749 + x747
    x751 = x0 * x750 + x748
    x752 = x171 * x615 + x272 * x694
    x753 = x272 * x703 + x620
    x754 = x272 * x701 + x624
    x755 = x0 * x754 + x753
    x756 = x272 * x705 + x629
    x757 = x0 * x756 + x754
    x758 = x0 * x757 + x755
    x759 = x272 * x709 + x633
    x760 = x417 * x647 + x639
    x761 = x417 * x643 + x651
    x762 = x0 * x761 + x760
    x763 = x417 * x640 + x658
    x764 = x0 * x763 + x761
    x765 = x0 * x764 + x762
    x766 = x417 * x652 + x663
    x767 = x272 * x726
    x768 = x272 * x724
    x769 = x0 * x768 + x767
    x770 = x272 * x728
    x771 = x0 * x770 + x768
    x772 = x0 * x771 + x769
    x773 = x272 * x732
    x774 = x153 * x638 + x341 * x726
    x775 = x153 * x650 + x341 * x724
    x776 = x0 * x775 + x774
    x777 = x153 * x657 + x341 * x728
    x778 = x0 * x777 + x775
    x779 = x0 * x778 + x776
    x780 = x153 * x662 + x341 * x732
    x781 = -x10 - A[1]
    x782 = -2.0 * x1 * x22 * x25 * x31 * x32 * x6 * x781 + x11 * x30
    x783 = -x782
    x784 = -2.0 * x1 * x20 * x22 * x25 * x31 * x6 * x781 + x11 * x41
    x785 = -x784
    x786 = x18 * x785
    x787 = -x36 * x783 + x786 * x8
    x788 = -x787
    x789 = x3 * x788
    x790 = 2.0 * x789
    x791 = -2.0 * x1 * x22 * x25 * x31 * x39 * x6 * x781 + x11 * x52
    x792 = -x791
    x793 = x18 * x792
    x794 = -x36 * x785 + x793 * x8
    x795 = -x794
    x796 = x3 * x795
    x797 = 2.0 * x796
    x798 = -x784 - x793
    x799 = x4 * x798
    x800 = -2.0 * x1 * x22 * x25 * x31 * x51 * x6 * x781 + x11 * x65
    x801 = -x800
    x802 = x18 * x801
    x803 = -x36 * x792 + x8 * x802
    x804 = -x803
    x805 = x18 * x804
    x806 = x8 * x805
    x807 = x36 * x795 + x799 - x806
    x808 = x74 * x807
    x809 = x797 + x8 * x808
    x810 = -x782 - x786
    x811 = x4 * x810
    x812 = x18 * x795
    x813 = x8 * x812
    x814 = x36 * x788 + x811 - x813
    x815 = x74 * x795
    x816 = x85 * (-x787 - x815)
    x817 = x3 * x792
    x818 = x74 * x804
    x819 = x8 * x818 + x817
    x820 = x74 * x819
    x821 = x8 * x820 + x81 * x817 + x816
    x822 = x3 * x804
    x823 = 2.0 * x822
    x824 = -x791 - x802
    x825 = x4 * x824
    x826 = -2.0 * x1 * x22 * x25 * x31 * x6 * x64 * x781 + x107 * x11
    x827 = -x826
    x828 = x18 * x827
    x829 = -x36 * x801 + x8 * x828
    x830 = -x829
    x831 = x18 * x830
    x832 = x8 * x831
    x833 = x36 * x804 + x825 - x832
    x834 = x74 * x833
    x835 = x8 * x834 + x823
    x836 = x74 * x835
    x837 = x85 * (-x794 - x818)
    x838 = x3 * x801
    x839 = x74 * x830
    x840 = x8 * x839 + x838
    x841 = x74 * x840
    x842 = x8 * x841 + x81 * x838 + x837
    x843 = x85 * (x36 * x795 + x4 * x798 - x806 - x834)
    x844 = x3 * x830
    x845 = 2.0 * x844
    x846 = x4 * (-x800 - x828)
    x847 = -2.0 * x1 * x106 * x22 * x25 * x31 * x6 * x781 + x11 * x138
    x848 = -x847
    x849 = x18 * x848
    x850 = -x36 * x827 + x8 * x849
    x851 = -x850
    x852 = x18 * x851
    x853 = x36 * x830 - x8 * x852 + x846
    x854 = x74 * x853
    x855 = x8 * x854 + x845
    x856 = x74 * x855
    x857 = x8 * x856 + x840 * x88 + x843
    x858 = x74 * x857
    x859 = x85 * (x36 * x788 + x4 * x810 - x808 - x813)
    x860 = x8 * x836 + x819 * x88 + x859
    x861 = x74 * x801
    x862 = x85 * (-x791 - x861)
    x863 = x462 * x827 + x862
    x864 = x1 * (x17 * x5 * x792 * x8 - x467 * x801) + x81 * x863
    x865 = x74 * x842
    x866 = x85 * (-x803 - x839)
    x867 = x3 * x827
    x868 = x81 * x851 + x867
    x869 = x81 * x867 + x81 * x868 + x866
    x870 = x1 * (x819 - x841) + x3 * x863 + x81 * x869
    x871 = x171 * (x821 - x865) + x3 * x864 + x81 * x870
    x872 = x85 * (x36 * x804 + x4 * x824 - x832 - x854)
    x873 = x3 * x851
    x874 = 2.0 * x873
    x875 = x4 * (-x826 - x849)
    x876 = 2.0 * x1 * x137 * x22 * x25 * x31 * x6 * x781 - x11 * x186
    x877 = x18 * x876
    x878 = x36 * x848 - x8 * x877
    x879 = x18 * x878
    x880 = x36 * x851 - x8 * x879 + x875
    x881 = x81 * x880 + x874
    x882 = x81 * x881 + x868 * x88 + x872
    x883 = x1 * (x835 - x856) + x81 * x882 + x869 * x88
    x884 = x171 * (-x858 + x860) + x81 * x883 + x870 * x88
    x885 = (
        x153
        * (
            x1 * (-x74 * x809 + x790 + x81 * x814)
            - x74 * (x1 * (x809 - x836) + x8 * x858 + x842 * x88)
            + x81 * x860
            + x821 * x88
        )
        + x81 * x884
        + x871 * x88
    )
    x886 = x212 * x23 + x885
    x887 = x74 * x792
    x888 = x85 * (-x784 - x887)
    x889 = x462 * x801 + x888
    x890 = x74 * x889
    x891 = x74 * x785
    x892 = x85 * (-x782 - x891)
    x893 = x462 * x792 + x892
    x894 = x171 * (-x890 + x893) + x81 * x864
    x895 = x3 * x783
    x896 = x3 * x785
    x897 = x8 * x815 + x896
    x898 = (
        x153
        * (
            x1 * (-x74 * x897 + x788 * x81 + x895)
            + x3 * x893
            - x74 * (x1 * (-x820 + x897) + x3 * x889 + x8 * x865)
            + x81 * x821
        )
        + x3 * x894
        + x81 * x871
    )
    x899 = x224 * x23 + x898
    x900 = x0 * x899 + x886
    x901 = (
        x153
        * (
            x1 * (x17 * x5 * x783 * x8 - x467 * x785)
            - x74 * (x1 * (x17 * x5 * x785 * x8 - x467 * x792) + x8 * x890)
            + x81 * x893
        )
        + x81 * x894
    )
    x902 = x228 * x23 + x901
    x903 = x3 * x814
    x904 = x3 * x807
    x905 = -x794 - x805
    x906 = x233 * x833
    x907 = x36 * x807 + x60 * x905 - x906
    x908 = x74 * x907
    x909 = x8 * x908 + 3.0 * x904
    x910 = -x787 - x812
    x911 = x233 * x807
    x912 = x36 * x814 + x60 * x910 - x911
    x913 = x3 * x833
    x914 = 3.0 * x913
    x915 = -x803 - x831
    x916 = x233 * x853
    x917 = x36 * x833 + x60 * x915 - x916
    x918 = x74 * x917
    x919 = x8 * x918 + x914
    x920 = x74 * x919
    x921 = x85 * (x36 * x807 + 2.0 * x4 * x905 - x906 - x918)
    x922 = x3 * x853
    x923 = 3.0 * x922
    x924 = -x233 * x880 + x36 * x853 + x60 * (-x829 - x852)
    x925 = x74 * x924
    x926 = x74 * (x8 * x925 + x923)
    x927 = x74 * (x100 * x855 + x8 * x926 + x921)
    x928 = x85 * (x36 * x814 + 2.0 * x4 * x910 - x908 - x911)
    x929 = x100 * x835 + x8 * x920 + x928
    x930 = x85 * (x36 * x833 + 2.0 * x4 * x915 - x916 - x925)
    x931 = x3 * x880
    x932 = 3.0 * x931
    x933 = x4 * (-x847 - x877)
    x934 = 2.0 * x1 * x185 * x22 * x25 * x31 * x6 * x781 - x11 * x265
    x935 = (
        -x233 * (-x233 * (-x233 * x934 + x36 * x876) + x36 * x878 + x933)
        + x36 * x880
        + x60 * (-x850 - x879)
    )
    x936 = x11 * x861 + x124
    x937 = x3 * x936
    x938 = x11 * x839 + x126
    x939 = x74 * x938
    x940 = x8 * x939 + x937
    x941 = x74 * x940
    x942 = x11 * x887 + x92
    x943 = x3 * x942
    x944 = x11 * x818 + x94
    x945 = x74 * x944
    x946 = x8 * x945 + x943
    x947 = x74 * x936
    x948 = x1 * (x942 - x947)
    x949 = x164 + x272 * x827
    x950 = x462 * x949 + 0.5 * x948
    x951 = x1 * (-x939 + x944)
    x952 = x3 * x949
    x953 = x175 + x272 * x851
    x954 = x81 * x953 + x952
    x955 = x81 * x952 + x81 * x954 + 0.5 * x951
    x956 = x1 * (-x941 + x946) + x3 * x950 + x81 * x955
    x957 = x11 * x808 + x58
    x958 = x1 * (x272 * x814 + x47 - x74 * x957)
    x959 = x101 + x11 * x834
    x960 = x74 * x959
    x961 = x1 * (x957 - x960)
    x962 = x88 * x938
    x963 = x11 * x854 + x133
    x964 = x74 * x963
    x965 = x8 * x964 + x962
    x966 = x74 * x965
    x967 = x88 * x944
    x968 = x8 * x960 + x967
    x969 = x1 * (x959 - x964)
    x970 = x88 * x953
    x971 = x182 + x272 * x880
    x972 = x81 * x971 + x970
    x973 = x81 * x972 + x88 * x954 + 0.5 * x969
    x974 = x1 * (-x966 + x968) + x81 * x973 + x88 * x955
    x975 = (
        x171
        * (
            -x74 * (x8 * x966 + x88 * x940 + 0.5 * x961)
            + x81 * x968
            + x88 * x946
            + 0.5 * x958
        )
        + x81 * x974
        + x88 * x956
    )
    x976 = x23 * x319 + x975
    x977 = x1 * (x17 * x5 * x8 * x942 - x467 * x936) + x81 * x950
    x978 = x11 * x815 + x198
    x979 = x1 * (x197 + x272 * x788 - x74 * x978)
    x980 = x1 * (-x945 + x978)
    x981 = (
        x171
        * (
            -x74 * (x8 * x941 + x81 * x937 + 0.5 * x980)
            + x81 * x943
            + x81 * x946
            + 0.5 * x979
        )
        + x3 * x977
        + x81 * x956
    )
    x982 = x23 * x325 + x981
    x983 = x0 * x982 + x976
    x984 = x11 * x891 + x221
    x985 = x1 * (x223 + x272 * x783 - x74 * x984)
    x986 = x74 * x942
    x987 = x1 * (x984 - x986)
    x988 = (
        x171 * (x462 * x942 - x74 * (x462 * x936 + 0.5 * x987) + 0.5 * x985) + x81 * x977
    )
    x989 = x23 * x331 + x988
    x990 = x11 * x908 + x230
    x991 = x1 * (x229 + x272 * x912 - x74 * x990)
    x992 = x11 * x918 + x242
    x993 = x74 * x992
    x994 = x1 * (x990 - x993)
    x995 = x74 * (x11 * x925 + x251)
    x996 = x74 * (x100 * x963 + x8 * x995)
    x997 = x100 * x959 + x8 * x993
    x998 = x1 * (x992 - x995)
    x999 = x261 + x272 * x935
    x1000 = x339 * x830
    x1001 = x341 * x838
    x1002 = x1000 * x8 + x1001
    x1003 = x1002 * x74
    x1004 = x339 * x804
    x1005 = x341 * x817
    x1006 = x1004 * x8 + x1005
    x1007 = x1 * (x14 * x17 * x5 * x792 - x339 * x801)
    x1008 = 0.5 * x1007
    x1009 = x491 * x9
    x1010 = x1008 + x1009 * x827
    x1011 = x1 * (-x1000 + x14 * x17 * x5 * x804)
    x1012 = 0.5 * x1011
    x1013 = x341 * x867
    x1014 = x1013 + x349 * x851
    x1015 = x1012 + x1014 * x81 + x349 * x867
    x1016 = x1 * (-x1003 + x1006) + x1010 * x3 + x1015 * x81
    x1017 = x1 * (x14 * x17 * x5 * x814 - x339 * x807)
    x1018 = 0.5 * x1017
    x1019 = x339 * x833
    x1020 = x1 * (-x1019 + x14 * x17 * x5 * x807)
    x1021 = 0.5 * x1020
    x1022 = x339 * x853
    x1023 = x341 * x845
    x1024 = x1022 * x8 + x1023
    x1025 = x1024 * x74
    x1026 = x341 * x823
    x1027 = x1019 * x8 + x1026
    x1028 = x1 * (-x1022 + x14 * x17 * x5 * x833)
    x1029 = 0.5 * x1028
    x1030 = x341 * x874
    x1031 = x1030 + x349 * x880
    x1032 = x1014 * x88 + x1029 + x1031 * x81
    x1033 = x1 * (-x1025 + x1027) + x1015 * x88 + x1032 * x81
    x1034 = (
        x1016 * x88
        + x1033 * x81
        + x171
        * (x1006 * x88 + x1018 + x1027 * x81 - x74 * (x1002 * x88 + x1021 + x1025 * x8))
    )
    x1035 = x1034 + x23 * x391
    x1036 = x491 * x8
    x1037 = x1 * (-x1036 * x801 + x14 * x267 * x268 * x792 * x8) + x1010 * x81
    x1038 = x1 * (x14 * x17 * x5 * x788 - x339 * x795)
    x1039 = 0.5 * x1038
    x1040 = x1 * (-x1004 + x14 * x17 * x5 * x795)
    x1041 = 0.5 * x1040
    x1042 = (
        x1016 * x81
        + x1037 * x3
        + x171
        * (x1006 * x81 + x1039 + x349 * x817 - x74 * (x1003 * x8 + x1041 + x349 * x838))
    )
    x1043 = x1042 + x23 * x399
    x1044 = x0 * x1043 + x1035
    x1045 = x1 * (x14 * x17 * x5 * x783 - x339 * x785)
    x1046 = 0.5 * x1045
    x1047 = x1 * (x14 * x17 * x5 * x785 - x339 * x792)
    x1048 = 0.5 * x1047
    x1049 = x1037 * x81 + x171 * (x1009 * x792 + x1046 - x74 * (x1009 * x801 + x1048))
    x1050 = x1049 + x23 * x406
    x1051 = x1 * (x14 * x17 * x5 * x912 - x339 * x907)
    x1052 = 0.5 * x1051
    x1053 = x339 * x917
    x1054 = x1 * (-x1053 + x14 * x17 * x5 * x907)
    x1055 = 0.5 * x1054
    x1056 = x339 * x924
    x1057 = x74 * (x1056 * x8 + x341 * x923)
    x1058 = x1053 * x8 + x341 * x914
    x1059 = x1 * (-x1056 + x14 * x17 * x5 * x917)
    x1060 = 0.5 * x1059
    x1061 = x101 * x272 + x11 * x960 + x859
    x1062 = x11 * x964 + x133 * x272 + x843
    x1063 = x74 * (x11 * x995 + x251 * x272 + x921)
    x1064 = x11 * x993 + x242 * x272 + x928
    x1065 = x11 * x945 + x272 * x94 + x816
    x1066 = x1065 * x88
    x1067 = x11 * x939 + x126 * x272 + x837
    x1068 = x1067 * x88
    x1069 = x1062 * x74
    x1070 = x1067 * x74
    x1071 = x1065 - x1070
    x1072 = x272 * x949 + x282 + x862
    x1073 = x1072 * x3
    x1074 = x175 * x272 + x272 * x953 + x866
    x1075 = x1073 + x1074 * x81
    x1076 = x1071 * x85 + x1073 * x81 + x1075 * x81
    x1077 = x1061 - x1069
    x1078 = x1074 * x88
    x1079 = x182 * x272 + x272 * x971 + x872
    x1080 = x1078 + x1079 * x81
    x1081 = x1075 * x88 + x1077 * x85 + x1080 * x81
    x1082 = (
        x1 * (x1061 * x81 + x1066 - x74 * (x1068 + x1069 * x8))
        + x1076 * x88
        + x1081 * x81
    )
    x1083 = x1082 + x23 * x454
    x1084 = x11 * x986 + x308 + x892
    x1085 = x1084 * x3
    x1086 = x11 * x947 + x304 + x888
    x1087 = x1086 * x3
    x1088 = x1086 * x74
    x1089 = x1084 - x1088
    x1090 = x1072 * x462 + x1089 * x85
    x1091 = (
        x1 * (x1065 * x81 + x1085 - x74 * (x1070 * x8 + x1087)) + x1076 * x81 + x1090 * x3
    )
    x1092 = x1091 + x23 * x464
    x1093 = x0 * x1092 + x1083
    x1094 = x1 * (x1084 * x17 * x5 * x8 - x1086 * x467) + x1090 * x81
    x1095 = x1094 + x23 * x468
    x1096 = -x1063 + x1064
    x1097 = x261 * x272 + x272 * x999 + x930
    x1098 = x101 * x341
    x1099 = x1098 + x477 * x833
    x1100 = x133 * x341
    x1101 = x1100 + x477 * x853
    x1102 = x251 * x341
    x1103 = x74 * (x1102 + x477 * x924)
    x1104 = x242 * x341
    x1105 = x1104 + x477 * x917
    x1106 = x341 * x94
    x1107 = x1106 + x477 * x804
    x1108 = x1107 * x88
    x1109 = x126 * x341
    x1110 = x1109 + x477 * x830
    x1111 = x1110 * x88
    x1112 = x1101 * x74
    x1113 = x1110 * x74
    x1114 = x1 * (x1107 - x1113)
    x1115 = x351 + x477 * x827
    x1116 = x1115 * x3
    x1117 = x175 * x341
    x1118 = x1117 + x477 * x851
    x1119 = x1116 + x1118 * x81
    x1120 = 0.5 * x1114 + x1116 * x81 + x1119 * x81
    x1121 = x1 * (x1099 - x1112)
    x1122 = x1118 * x88
    x1123 = x182 * x341
    x1124 = x1123 + x477 * x880
    x1125 = x1122 + x1124 * x81
    x1126 = x1119 * x88 + 0.5 * x1121 + x1125 * x81
    x1127 = (
        x1 * (x1099 * x81 + x1108 - x74 * (x1111 + x1112 * x8))
        + x1120 * x88
        + x1126 * x81
    )
    x1128 = x1127 + x23 * x495
    x1129 = x379 + x477 * x792
    x1130 = x1129 * x3
    x1131 = x375 + x477 * x801
    x1132 = x1131 * x3
    x1133 = x1131 * x74
    x1134 = x1 * (x1129 - x1133)
    x1135 = x1115 * x462 + 0.5 * x1134
    x1136 = (
        x1 * (x1107 * x81 + x1130 - x74 * (x1113 * x8 + x1132)) + x1120 * x81 + x1135 * x3
    )
    x1137 = x1136 + x23 * x503
    x1138 = x0 * x1137 + x1128
    x1139 = x1 * (x1129 * x17 * x5 * x8 - x1131 * x467) + x1135 * x81
    x1140 = x1139 + x23 * x506
    x1141 = x1 * (-x1103 + x1105)
    x1142 = x261 * x341
    x1143 = x1142 + x477 * x935
    x1144 = x508 * x833 + x859
    x1145 = x1144 * x3
    x1146 = x508 * x853 + x843
    x1147 = x1146 * x3
    x1148 = x74 * (x508 * x924 + x921)
    x1149 = x508 * x917 + x928
    x1150 = x508 * x804 + x816
    x1151 = x1150 * x3
    x1152 = 2.0 * x1151
    x1153 = x508 * x830 + x837
    x1154 = x1153 * x3
    x1155 = 2.0 * x1154
    x1156 = x1146 * x74
    x1157 = x1153 * x74
    x1158 = x1150 - x1157
    x1159 = x1158 * x85
    x1160 = x508 * x827 + x862
    x1161 = x1160 * x3
    x1162 = x508 * x851 + x866
    x1163 = x1161 + x1162 * x81
    x1164 = x1159 + x1161 * x81 + x1163 * x81
    x1165 = x1144 - x1156
    x1166 = x1165 * x85
    x1167 = x1162 * x3
    x1168 = 2.0 * x1167
    x1169 = x508 * x880 + x872
    x1170 = x1168 + x1169 * x81
    x1171 = x1163 * x88 + x1166 + x1170 * x81
    x1172 = (
        x1 * (x1144 * x81 + x1152 - x74 * (x1155 + x1156 * x8))
        + x1164 * x88
        + x1171 * x81
    )
    x1173 = x1172 + x23 * x550
    x1174 = x508 * x792 + x892
    x1175 = x1174 * x3
    x1176 = x508 * x801 + x888
    x1177 = x1176 * x3
    x1178 = x1176 * x74
    x1179 = x1174 - x1178
    x1180 = x1179 * x85
    x1181 = x1160 * x462 + x1180
    x1182 = (
        x1 * (x1150 * x81 + x1175 - x74 * (x1157 * x8 + x1177)) + x1164 * x81 + x1181 * x3
    )
    x1183 = x1182 + x23 * x560
    x1184 = x0 * x1183 + x1173
    x1185 = x1 * (x1174 * x17 * x5 * x8 - x1176 * x467) + x1181 * x81
    x1186 = x1185 + x23 * x563
    x1187 = -x1148 + x1149
    x1188 = x1187 * x85
    x1189 = x1169 * x3
    x1190 = x508 * x935 + x930
    x1191 = x1061 * x272 + x425 - x74 * (x1069 * x11 + x427 + x961) + x958
    x1192 = x1072 * x272 + x434 + x948
    x1193 = x1192 * x3
    x1194 = x1074 * x272 + x437 + x951
    x1195 = x1193 + x1194 * x81
    x1196 = x1194 * x88
    x1197 = x1079 * x272 + x442 + x969
    x1198 = x1196 + x1197 * x81
    x1199 = x1191 * x85 + x1195 * x88 + x1198 * x81
    x1200 = x1199 + x23 * x582
    x1201 = x1065 * x272 + x448 - x74 * (x1070 * x11 + x450 + x980) + x979
    x1202 = x1193 * x81 + x1195 * x81 + x1201 * x85
    x1203 = x1202 + x23 * x585
    x1204 = x0 * x1203 + x1200
    x1205 = x1084 * x272 + x457 - x74 * (x1088 * x11 + x459 + x987) + x985
    x1206 = x1192 * x462 + x1205 * x85
    x1207 = x1206 + x23 * x589
    x1208 = x1064 * x272 + x419 - x74 * (x1063 * x11 + x421 + x994) + x991
    x1209 = x1097 * x272 + x470 + x998
    x1210 = x101 * x477 + x1018 + x1099 * x272 - x74 * (x1021 + x11 * x1112 + x133 * x477)
    x1211 = x1008 + x1115 * x272 + x483
    x1212 = x1211 * x3
    x1213 = x1012 + x1118 * x272 + x175 * x477
    x1214 = x1212 + x1213 * x81
    x1215 = x1213 * x88
    x1216 = x1029 + x1124 * x272 + x182 * x477
    x1217 = x1215 + x1216 * x81
    x1218 = x1210 * x85 + x1214 * x88 + x1217 * x81
    x1219 = x1218 + x23 * x609
    x1220 = x1039 + x1107 * x272 + x477 * x94 - x74 * (x1041 + x11 * x1113 + x126 * x477)
    x1221 = x1212 * x81 + x1214 * x81 + x1220 * x85
    x1222 = x1221 + x23 * x612
    x1223 = x0 * x1222 + x1219
    x1224 = x1046 + x1129 * x272 + x498 - x74 * (x1048 + x11 * x1133 + x497)
    x1225 = x1211 * x462 + x1224 * x85
    x1226 = x1225 + x23 * x616
    x1227 = x1052 + x1105 * x272 + x242 * x477 - x74 * (x1055 + x11 * x1103 + x251 * x477)
    x1228 = x1060 + x1143 * x272 + x261 * x477
    x1229 = x1 * (x1144 * x272 + x517 - x74 * (x11 * x1156 + x519))
    x1230 = x1160 * x272 + x526
    x1231 = x1230 * x3
    x1232 = x1162 * x272 + x529
    x1233 = x1231 + x1232 * x81
    x1234 = x1232 * x88
    x1235 = x1169 * x272 + x536
    x1236 = x1234 + x1235 * x81
    x1237 = 0.5 * x1229 + x1233 * x88 + x1236 * x81
    x1238 = x1237 + x23 * x627
    x1239 = x1 * (x1150 * x272 + x543 - x74 * (x11 * x1157 + x545))
    x1240 = x1231 * x81 + x1233 * x81 + 0.5 * x1239
    x1241 = x1240 + x23 * x630
    x1242 = x0 * x1241 + x1238
    x1243 = x1 * (x1174 * x272 + x553 - x74 * (x11 * x1178 + x555))
    x1244 = x1230 * x462 + 0.5 * x1243
    x1245 = x1244 + x23 * x636
    x1246 = x1 * (x1149 * x272 + x510 - x74 * (x11 * x1148 + x512))
    x1247 = x1190 * x272 + x566
    x1248 = x1017 + x1144 * x341 - x74 * (x1020 + x1156 * x14)
    x1249 = x1248 * x85
    x1250 = x1007 + x1160 * x341
    x1251 = x1250 * x3
    x1252 = x1011 + x1162 * x341
    x1253 = x1251 + x1252 * x81
    x1254 = x1252 * x3
    x1255 = 2.0 * x1254
    x1256 = x1028 + x1169 * x341
    x1257 = x1255 + x1256 * x81
    x1258 = x1249 + x1253 * x88 + x1257 * x81
    x1259 = x1258 + x23 * x655
    x1260 = x1038 + x1150 * x341 - x74 * (x1040 + x1157 * x14)
    x1261 = x1260 * x85
    x1262 = x1251 * x81 + x1253 * x81 + x1261
    x1263 = x1262 + x23 * x659
    x1264 = x0 * x1263 + x1259
    x1265 = x1045 + x1174 * x341 - x74 * (x1047 + x1178 * x14)
    x1266 = x1265 * x85
    x1267 = x1250 * x462 + x1266
    x1268 = x1267 + x23 * x664
    x1269 = x1051 + x1149 * x341 - x74 * (x1054 + x1148 * x14)
    x1270 = x1269 * x85
    x1271 = x1256 * x3
    x1272 = x1059 + x1190 * x341
    x1273 = x1071 * x171 + x1194 * x272 + x571
    x1274 = x1273 * x88
    x1275 = x1077 * x171 + x1197 * x272 + x574
    x1276 = x1274 + x1275 * x81
    x1277 = x1276 + x23 * x676
    x1278 = x1089 * x171 + x1192 * x272 + x580
    x1279 = x1278 * x3
    x1280 = x1273 * x81 + x1279
    x1281 = x1280 + x23 * x680
    x1282 = x0 * x1281 + x1277
    x1283 = x1278 * x81
    x1284 = x23 * x81
    x1285 = x1283 + x1284 * x678
    x1286 = x1096 * x171 + x1209 * x272 + x591
    x1287 = x1114 + x1213 * x272 + x596
    x1288 = x1287 * x88
    x1289 = x1121 + x1216 * x272 + x599
    x1290 = x1288 + x1289 * x81
    x1291 = x1290 + x23 * x692
    x1292 = x1134 + x1211 * x272 + x607
    x1293 = x1292 * x3
    x1294 = x1287 * x81 + x1293
    x1295 = x1294 + x23 * x696
    x1296 = x0 * x1295 + x1291
    x1297 = x1292 * x81
    x1298 = x1284 * x694 + x1297
    x1299 = x1141 + x1228 * x272 + x618
    x1300 = x1159 + x1232 * x272 + x272 * x529
    x1301 = x1300 * x88
    x1302 = x1166 + x1235 * x272 + x272 * x536
    x1303 = x1301 + x1302 * x81
    x1304 = x1303 + x23 * x707
    x1305 = x1180 + x1230 * x272 + x625
    x1306 = x1305 * x3
    x1307 = x1300 * x81 + x1306
    x1308 = x1307 + x23 * x711
    x1309 = x0 * x1308 + x1304
    x1310 = x1305 * x81
    x1311 = x1284 * x709 + x1310
    x1312 = x1188 + x1247 * x272 + x272 * x566
    x1313 = x1252 * x272 + x641
    x1314 = x1313 * x88
    x1315 = x1256 * x272 + x645
    x1316 = x1314 + x1315 * x81
    x1317 = x1316 + x23 * x717
    x1318 = x1250 * x272 + x653
    x1319 = x1318 * x3
    x1320 = x1313 * x81 + x1319
    x1321 = x1320 + x23 * x720
    x1322 = x0 * x1321 + x1317
    x1323 = x1318 * x81
    x1324 = x1323 + x23 * x723
    x1325 = x1272 * x272 + x667
    x1326 = x1158 * x171 + x1252 * x341
    x1327 = x1326 * x3
    x1328 = 2.0 * x1327
    x1329 = x1165 * x171 + x1256 * x341
    x1330 = x1328 + x1329 * x81
    x1331 = x1330 + x23 * x730
    x1332 = x1179 * x171 + x1250 * x341
    x1333 = x1332 * x3
    x1334 = x1326 * x81 + x1333
    x1335 = x1334 + x23 * x734
    x1336 = x0 * x1335 + x1331
    x1337 = x1332 * x81
    x1338 = x1284 * x732 + x1337
    x1339 = x1329 * x3
    x1340 = x1187 * x171 + x1272 * x341
    x1341 = x1191 * x153 + x1275 * x272 + x671
    x1342 = x1341 + x23 * x740
    x1343 = x1201 * x153 + x1273 * x272 + x675
    x1344 = x1343 + x23 * x742
    x1345 = x0 * x1344 + x1342
    x1346 = x1205 * x153 + x1278 * x272 + x679
    x1347 = x1346 + x23 * x745
    x1348 = x1210 * x171 + x1289 * x272 + x687
    x1349 = x1348 + x23 * x747
    x1350 = x1220 * x171 + x1287 * x272 + x691
    x1351 = x1350 + x23 * x749
    x1352 = x0 * x1351 + x1349
    x1353 = x1224 * x171 + x1292 * x272 + x695
    x1354 = x1353 + x23 * x752
    x1355 = x1229 + x1302 * x272 + x702
    x1356 = x1355 + x23 * x754
    x1357 = x1239 + x1300 * x272 + x706
    x1358 = x1357 + x23 * x756
    x1359 = x0 * x1358 + x1356
    x1360 = x1243 + x1305 * x272 + x710
    x1361 = x1360 + x23 * x759
    x1362 = x1249 + x1315 * x272 + x272 * x645
    x1363 = x1362 + x23 * x761
    x1364 = x1261 + x1313 * x272 + x272 * x641
    x1365 = x1364 + x23 * x763
    x1366 = x0 * x1365 + x1363
    x1367 = x1266 + x1318 * x272 + x719
    x1368 = x1367 + x23 * x766
    x1369 = x1329 * x272 + x725
    x1370 = x1369 + x23 * x768
    x1371 = x1326 * x272 + x729
    x1372 = x1371 + x23 * x770
    x1373 = x0 * x1372 + x1370
    x1374 = x1332 * x272 + x733
    x1375 = x1374 + x23 * x773
    x1376 = x1248 * x153 + x1329 * x341
    x1377 = x1376 + x23 * x775
    x1378 = x1260 * x153 + x1326 * x341
    x1379 = x1378 + x23 * x777
    x1380 = x0 * x1379 + x1377
    x1381 = x1265 * x153 + x1332 * x341
    x1382 = x1381 + x23 * x780
    x1383 = -x13 - A[2]
    x1384 = -2.0 * x1 * x1383 * x22 * x25 * x31 * x32 * x6 + x14 * x30
    x1385 = -x1384
    x1386 = -2.0 * x1 * x1383 * x20 * x22 * x25 * x31 * x6 + x14 * x41
    x1387 = -x1386
    x1388 = x1387 * x18
    x1389 = -x1385 * x36 + x1388 * x8
    x1390 = -x1389
    x1391 = x1390 * x3
    x1392 = 2.0 * x1391
    x1393 = -2.0 * x1 * x1383 * x22 * x25 * x31 * x39 * x6 + x14 * x52
    x1394 = -x1393
    x1395 = x1394 * x18
    x1396 = -x1387 * x36 + x1395 * x8
    x1397 = -x1396
    x1398 = x1397 * x3
    x1399 = 2.0 * x1398
    x1400 = -x1386 - x1395
    x1401 = x1400 * x4
    x1402 = -2.0 * x1 * x1383 * x22 * x25 * x31 * x51 * x6 + x14 * x65
    x1403 = -x1402
    x1404 = x1403 * x18
    x1405 = -x1394 * x36 + x1404 * x8
    x1406 = -x1405
    x1407 = x1406 * x18
    x1408 = x1407 * x8
    x1409 = x1397 * x36 + x1401 - x1408
    x1410 = x1409 * x74
    x1411 = x1399 + x1410 * x8
    x1412 = -x1384 - x1388
    x1413 = x1412 * x4
    x1414 = x1397 * x18
    x1415 = x1414 * x8
    x1416 = x1390 * x36 + x1413 - x1415
    x1417 = x1397 * x74
    x1418 = x85 * (-x1389 - x1417)
    x1419 = x1394 * x3
    x1420 = x1406 * x74
    x1421 = x1419 + x1420 * x8
    x1422 = x1421 * x74
    x1423 = x1418 + x1419 * x81 + x1422 * x8
    x1424 = x1406 * x3
    x1425 = 2.0 * x1424
    x1426 = -x1393 - x1404
    x1427 = x1426 * x4
    x1428 = -2.0 * x1 * x1383 * x22 * x25 * x31 * x6 * x64 + x107 * x14
    x1429 = -x1428
    x1430 = x1429 * x18
    x1431 = -x1403 * x36 + x1430 * x8
    x1432 = -x1431
    x1433 = x1432 * x18
    x1434 = x1433 * x8
    x1435 = x1406 * x36 + x1427 - x1434
    x1436 = x1435 * x74
    x1437 = x1425 + x1436 * x8
    x1438 = x1437 * x74
    x1439 = x85 * (-x1396 - x1420)
    x1440 = x1403 * x3
    x1441 = x1432 * x74
    x1442 = x1440 + x1441 * x8
    x1443 = x1442 * x74
    x1444 = x1439 + x1440 * x81 + x1443 * x8
    x1445 = -x1400 * x4
    x1446 = x85 * (x1397 * x36 - x1408 - x1436 - x1445)
    x1447 = x1432 * x3
    x1448 = 2.0 * x1447
    x1449 = x4 * (-x1402 - x1430)
    x1450 = -2.0 * x1 * x106 * x1383 * x22 * x25 * x31 * x6 + x138 * x14
    x1451 = -x1450
    x1452 = x1451 * x18
    x1453 = -x1429 * x36 + x1452 * x8
    x1454 = -x1453
    x1455 = x1454 * x18
    x1456 = x1432 * x36 + x1449 - x1455 * x8
    x1457 = x1456 * x74
    x1458 = x1448 + x1457 * x8
    x1459 = x1458 * x74
    x1460 = x1442 * x88 + x1446 + x1459 * x8
    x1461 = x1460 * x74
    x1462 = -x1412 * x4
    x1463 = x85 * (x1390 * x36 - x1410 - x1415 - x1462)
    x1464 = x1421 * x88 + x1438 * x8 + x1463
    x1465 = x1403 * x74
    x1466 = x85 * (-x1393 - x1465)
    x1467 = x1429 * x462 + x1466
    x1468 = x1 * (x1394 * x17 * x5 * x8 - x1403 * x467) + x1467 * x81
    x1469 = x1444 * x74
    x1470 = x85 * (-x1405 - x1441)
    x1471 = x1429 * x3
    x1472 = x1454 * x81 + x1471
    x1473 = x1470 + x1471 * x81 + x1472 * x81
    x1474 = x1 * (x1421 - x1443) + x1467 * x3 + x1473 * x81
    x1475 = x1468 * x3 + x1474 * x81 + x171 * (x1423 - x1469)
    x1476 = -x1426 * x4
    x1477 = x85 * (x1406 * x36 - x1434 - x1457 - x1476)
    x1478 = x1454 * x3
    x1479 = 2.0 * x1478
    x1480 = x4 * (-x1428 - x1452)
    x1481 = 2.0 * x1 * x137 * x1383 * x22 * x25 * x31 * x6 - x14 * x186
    x1482 = x1481 * x18
    x1483 = x1451 * x36 - x1482 * x8
    x1484 = x1483 * x18
    x1485 = x1454 * x36 + x1480 - x1484 * x8
    x1486 = x1479 + x1485 * x81
    x1487 = x1472 * x88 + x1477 + x1486 * x81
    x1488 = x1 * (x1437 - x1459) + x1473 * x88 + x1487 * x81
    x1489 = x1474 * x88 + x1488 * x81 + x171 * (-x1461 + x1464)
    x1490 = (
        x1475 * x88
        + x1489 * x81
        + x153
        * (
            x1 * (x1392 - x1411 * x74 + x1416 * x81)
            + x1423 * x88
            + x1464 * x81
            - x74 * (x1 * (x1411 - x1438) + x1444 * x88 + x1461 * x8)
        )
    )
    x1491 = x1490 + x212 * x24
    x1492 = x1394 * x74
    x1493 = x85 * (-x1386 - x1492)
    x1494 = x1403 * x462 + x1493
    x1495 = x1494 * x74
    x1496 = x1387 * x74
    x1497 = x85 * (-x1384 - x1496)
    x1498 = x1394 * x462 + x1497
    x1499 = x1468 * x81 + x171 * (-x1495 + x1498)
    x1500 = x1385 * x3
    x1501 = x1387 * x3
    x1502 = x1417 * x8 + x1501
    x1503 = (
        x1475 * x81
        + x1499 * x3
        + x153
        * (
            x1 * (x1390 * x81 + x1500 - x1502 * x74)
            + x1423 * x81
            + x1498 * x3
            - x74 * (x1 * (-x1422 + x1502) + x1469 * x8 + x1494 * x3)
        )
    )
    x1504 = x1503 + x224 * x24
    x1505 = x0 * x1504 + x1491
    x1506 = x1499 * x81 + x153 * (
        x1 * (x1385 * x17 * x5 * x8 - x1387 * x467)
        + x1498 * x81
        - x74 * (x1 * (x1387 * x17 * x5 * x8 - x1394 * x467) + x1495 * x8)
    )
    x1507 = x1506 + x228 * x24
    x1508 = x1416 * x3
    x1509 = x1409 * x3
    x1510 = -x1396 - x1407
    x1511 = x1435 * x233
    x1512 = x1409 * x36 + x1510 * x60 - x1511
    x1513 = x1512 * x74
    x1514 = 3.0 * x1509 + x1513 * x8
    x1515 = -x1389 - x1414
    x1516 = x1409 * x233
    x1517 = x1416 * x36 + x1515 * x60 - x1516
    x1518 = x1435 * x3
    x1519 = 3.0 * x1518
    x1520 = -x1405 - x1433
    x1521 = x1456 * x233
    x1522 = x1435 * x36 + x1520 * x60 - x1521
    x1523 = x1522 * x74
    x1524 = x1519 + x1523 * x8
    x1525 = x1524 * x74
    x1526 = x85 * (x1409 * x36 + 2.0 * x1510 * x4 - x1511 - x1523)
    x1527 = x1456 * x3
    x1528 = 3.0 * x1527
    x1529 = x1456 * x36 - x1485 * x233 + x60 * (-x1431 - x1455)
    x1530 = x1529 * x74
    x1531 = x74 * (x1528 + x1530 * x8)
    x1532 = x74 * (x100 * x1458 + x1526 + x1531 * x8)
    x1533 = x85 * (x1416 * x36 - x1513 + 2.0 * x1515 * x4 - x1516)
    x1534 = x100 * x1437 + x1525 * x8 + x1533
    x1535 = x85 * (x1435 * x36 + 2.0 * x1520 * x4 - x1521 - x1530)
    x1536 = x1485 * x3
    x1537 = 3.0 * x1536
    x1538 = x4 * (-x1450 - x1482)
    x1539 = 2.0 * x1 * x1383 * x185 * x22 * x25 * x31 * x6 - x14 * x265
    x1540 = (
        x1485 * x36
        - x233 * (x1483 * x36 + x1538 - x233 * (x1481 * x36 - x1539 * x233))
        + x60 * (-x1453 - x1484)
    )
    x1541 = x1432 * x270
    x1542 = x1440 * x272
    x1543 = x1541 * x8 + x1542
    x1544 = x1543 * x74
    x1545 = x1406 * x270
    x1546 = x1419 * x272
    x1547 = x1545 * x8 + x1546
    x1548 = x1 * (x11 * x1394 * x17 * x5 - x1403 * x270)
    x1549 = x1429 * x635 + 0.5 * x1548
    x1550 = x1 * (x11 * x1406 * x17 * x5 - x1541)
    x1551 = x1471 * x272
    x1552 = x1454 * x280 + x1551
    x1553 = x1471 * x280 + 0.5 * x1550 + x1552 * x81
    x1554 = x1 * (-x1544 + x1547) + x1549 * x3 + x1553 * x81
    x1555 = x1 * (x11 * x1416 * x17 * x5 - x1409 * x270)
    x1556 = x1435 * x270
    x1557 = x1 * (x11 * x1409 * x17 * x5 - x1556)
    x1558 = x1456 * x270
    x1559 = x1448 * x272 + x1558 * x8
    x1560 = x1559 * x74
    x1561 = x1425 * x272 + x1556 * x8
    x1562 = x1 * (x11 * x1435 * x17 * x5 - x1558)
    x1563 = x1479 * x272 + x1485 * x280
    x1564 = x1552 * x88 + 0.5 * x1562 + x1563 * x81
    x1565 = x1 * (-x1560 + x1561) + x1553 * x88 + x1564 * x81
    x1566 = (
        x1554 * x88
        + x1565 * x81
        + x171
        * (
            x1547 * x88
            + 0.5 * x1555
            + x1561 * x81
            - x74 * (x1543 * x88 + 0.5 * x1557 + x1560 * x8)
        )
    )
    x1567 = x1566 + x24 * x319
    x1568 = x634 * x8
    x1569 = x1 * (x11 * x1394 * x267 * x268 * x8 - x1403 * x1568) + x1549 * x81
    x1570 = x1 * (x11 * x1390 * x17 * x5 - x1397 * x270)
    x1571 = x1 * (x11 * x1397 * x17 * x5 - x1545)
    x1572 = (
        x1554 * x81
        + x1569 * x3
        + x171
        * (
            x1419 * x280
            + x1547 * x81
            + 0.5 * x1570
            - x74 * (x1440 * x280 + x1544 * x8 + 0.5 * x1571)
        )
    )
    x1573 = x1572 + x24 * x325
    x1574 = x0 * x1573 + x1567
    x1575 = x1 * (x11 * x1385 * x17 * x5 - x1387 * x270)
    x1576 = x1 * (x11 * x1387 * x17 * x5 - x1394 * x270)
    x1577 = x1569 * x81 + x171 * (
        x1394 * x635 + 0.5 * x1575 - x74 * (x1403 * x635 + 0.5 * x1576)
    )
    x1578 = x1577 + x24 * x331
    x1579 = x1 * (x11 * x1517 * x17 * x5 - x1512 * x270)
    x1580 = x1522 * x270
    x1581 = x1 * (x11 * x1512 * x17 * x5 - x1580)
    x1582 = x1529 * x270
    x1583 = x74 * (x1528 * x272 + x1582 * x8)
    x1584 = x1519 * x272 + x1580 * x8
    x1585 = x1 * (x11 * x1522 * x17 * x5 - x1582)
    x1586 = x124 + x14 * x1465
    x1587 = x1586 * x3
    x1588 = x126 + x14 * x1441
    x1589 = x1588 * x74
    x1590 = x1587 + x1589 * x8
    x1591 = x1590 * x74
    x1592 = x14 * x1492 + x92
    x1593 = x1592 * x3
    x1594 = x14 * x1420 + x94
    x1595 = x1594 * x74
    x1596 = x1593 + x1595 * x8
    x1597 = x1586 * x74
    x1598 = x1 * (x1592 - x1597)
    x1599 = 0.5 * x1598
    x1600 = x1429 * x341 + x164
    x1601 = x1599 + x1600 * x462
    x1602 = x1 * (-x1589 + x1594)
    x1603 = 0.5 * x1602
    x1604 = x1600 * x3
    x1605 = x1454 * x341 + x175
    x1606 = x1604 + x1605 * x81
    x1607 = x1603 + x1604 * x81 + x1606 * x81
    x1608 = x1 * (-x1591 + x1596) + x1601 * x3 + x1607 * x81
    x1609 = x14 * x1410 + x58
    x1610 = x1 * (x1416 * x341 - x1609 * x74 + x47)
    x1611 = 0.5 * x1610
    x1612 = x101 + x14 * x1436
    x1613 = x1612 * x74
    x1614 = x1 * (x1609 - x1613)
    x1615 = 0.5 * x1614
    x1616 = x1588 * x3
    x1617 = 2.0 * x1616
    x1618 = x133 + x14 * x1457
    x1619 = x1618 * x74
    x1620 = x1617 + x1619 * x8
    x1621 = x1620 * x74
    x1622 = x1594 * x3
    x1623 = 2.0 * x1622
    x1624 = x1613 * x8 + x1623
    x1625 = x1 * (x1612 - x1619)
    x1626 = 0.5 * x1625
    x1627 = x1605 * x3
    x1628 = 2.0 * x1627
    x1629 = x1485 * x341 + x182
    x1630 = x1628 + x1629 * x81
    x1631 = x1606 * x88 + x1626 + x1630 * x81
    x1632 = x1 * (-x1621 + x1624) + x1607 * x88 + x1631 * x81
    x1633 = (
        x1608 * x88
        + x1632 * x81
        + x171
        * (x1596 * x88 + x1611 + x1624 * x81 - x74 * (x1590 * x88 + x1615 + x1621 * x8))
    )
    x1634 = x1633 + x24 * x391
    x1635 = x1 * (-x1586 * x467 + x1592 * x17 * x5 * x8) + x1601 * x81
    x1636 = x14 * x1417 + x198
    x1637 = x1 * (x1390 * x341 - x1636 * x74 + x197)
    x1638 = 0.5 * x1637
    x1639 = x1 * (-x1595 + x1636)
    x1640 = 0.5 * x1639
    x1641 = (
        x1608 * x81
        + x1635 * x3
        + x171
        * (x1593 * x81 + x1596 * x81 + x1638 - x74 * (x1587 * x81 + x1591 * x8 + x1640))
    )
    x1642 = x1641 + x24 * x399
    x1643 = x0 * x1642 + x1634
    x1644 = x14 * x1496 + x221
    x1645 = x1 * (x1385 * x341 - x1644 * x74 + x223)
    x1646 = 0.5 * x1645
    x1647 = x1592 * x74
    x1648 = x1 * (x1644 - x1647)
    x1649 = 0.5 * x1648
    x1650 = x1635 * x81 + x171 * (x1592 * x462 + x1646 - x74 * (x1586 * x462 + x1649))
    x1651 = x1650 + x24 * x406
    x1652 = x14 * x1513 + x230
    x1653 = x1 * (x1517 * x341 - x1652 * x74 + x229)
    x1654 = 0.5 * x1653
    x1655 = x14 * x1523 + x242
    x1656 = x1655 * x74
    x1657 = x1 * (x1652 - x1656)
    x1658 = 0.5 * x1657
    x1659 = x1618 * x3
    x1660 = 3.0 * x1659
    x1661 = x14 * x1530 + x251
    x1662 = x1661 * x74
    x1663 = x74 * (x1660 + x1662 * x8)
    x1664 = x1612 * x3
    x1665 = 3.0 * x1664
    x1666 = x1656 * x8 + x1665
    x1667 = x1 * (x1655 - x1662)
    x1668 = 0.5 * x1667
    x1669 = x1629 * x3
    x1670 = 3.0 * x1669
    x1671 = x1540 * x341 + x261
    x1672 = x1435 * x417 + x1463
    x1673 = x1672 * x3
    x1674 = x1446 + x1456 * x417
    x1675 = x1674 * x3
    x1676 = x74 * (x1526 + x1529 * x417)
    x1677 = x1522 * x417 + x1533
    x1678 = x1406 * x417 + x1418
    x1679 = x1678 * x3
    x1680 = x1432 * x417 + x1439
    x1681 = x1680 * x3
    x1682 = x1674 * x74
    x1683 = x1680 * x74
    x1684 = x1678 - x1683
    x1685 = x1429 * x417 + x1466
    x1686 = x1685 * x3
    x1687 = x1454 * x417 + x1470
    x1688 = x1686 + x1687 * x81
    x1689 = x1684 * x85 + x1686 * x81 + x1688 * x81
    x1690 = x1672 - x1682
    x1691 = x1687 * x3
    x1692 = x1477 + x1485 * x417
    x1693 = 2.0 * x1691 + x1692 * x81
    x1694 = x1688 * x88 + x1690 * x85 + x1693 * x81
    x1695 = (
        x1 * (x1672 * x81 + 2.0 * x1679 - x74 * (2.0 * x1681 + x1682 * x8))
        + x1689 * x88
        + x1694 * x81
    )
    x1696 = x1695 + x24 * x454
    x1697 = x1394 * x417 + x1497
    x1698 = x1697 * x3
    x1699 = x1403 * x417 + x1493
    x1700 = x1699 * x3
    x1701 = x1699 * x74
    x1702 = x1697 - x1701
    x1703 = x1685 * x462 + x1702 * x85
    x1704 = (
        x1 * (x1678 * x81 + x1698 - x74 * (x1683 * x8 + x1700)) + x1689 * x81 + x1703 * x3
    )
    x1705 = x1704 + x24 * x464
    x1706 = x0 * x1705 + x1696
    x1707 = x1 * (x1697 * x17 * x5 * x8 - x1699 * x467) + x1703 * x81
    x1708 = x1707 + x24 * x468
    x1709 = -x1676 + x1677
    x1710 = x1692 * x3
    x1711 = x1535 + x1540 * x417
    x1712 = x1661 * x270
    x1713 = x1618 * x270
    x1714 = x1588 * x270
    x1715 = x1 * (x11 * x1594 * x17 * x5 - x1714)
    x1716 = x1604 * x272
    x1717 = x1605 * x280 + x1716
    x1718 = x1604 * x280 + 0.5 * x1715 + x1717 * x81
    x1719 = x1 * (x11 * x1612 * x17 * x5 - x1713)
    x1720 = x1628 * x272 + x1629 * x280
    x1721 = x1717 * x88 + 0.5 * x1719 + x1720 * x81
    x1722 = (
        x1 * (x1612 * x280 + x1623 * x272 - x74 * (x1617 * x272 + x1713 * x8))
        + x1718 * x88
        + x1721 * x81
    )
    x1723 = x1722 + x24 * x495
    x1724 = x1587 * x272
    x1725 = x1593 * x272
    x1726 = x1 * (x11 * x1592 * x17 * x5 - x1586 * x270)
    x1727 = x1600 * x635 + 0.5 * x1726
    x1728 = (
        x1 * (x1594 * x280 + x1725 - x74 * (x1714 * x8 + x1724))
        + x1718 * x81
        + x1727 * x3
    )
    x1729 = x1728 + x24 * x503
    x1730 = x0 * x1729 + x1723
    x1731 = x1 * (x11 * x1592 * x267 * x268 * x8 - x1568 * x1586) + x1727 * x81
    x1732 = x1731 + x24 * x506
    x1733 = x1 * (x11 * x1655 * x17 * x5 - x1712)
    x1734 = x1098 + x14 * x1613 + x1463
    x1735 = x1734 * x3
    x1736 = x1100 + x14 * x1619 + x1446
    x1737 = x1736 * x3
    x1738 = x1102 + x14 * x1662 + x1526
    x1739 = x1738 * x74
    x1740 = x1104 + x14 * x1656 + x1533
    x1741 = x1106 + x14 * x1595 + x1418
    x1742 = x1741 * x3
    x1743 = 2.0 * x1742
    x1744 = x1109 + x14 * x1589 + x1439
    x1745 = x1744 * x3
    x1746 = 2.0 * x1745
    x1747 = x1736 * x74
    x1748 = x1744 * x74
    x1749 = x1741 - x1748
    x1750 = x1749 * x85
    x1751 = x1466 + x1600 * x341 + x351
    x1752 = x1751 * x3
    x1753 = x1117 + x1470 + x1605 * x341
    x1754 = x1752 + x1753 * x81
    x1755 = x1750 + x1752 * x81 + x1754 * x81
    x1756 = x1734 - x1747
    x1757 = x1756 * x85
    x1758 = x1753 * x3
    x1759 = 2.0 * x1758
    x1760 = x1123 + x1477 + x1629 * x341
    x1761 = x1759 + x1760 * x81
    x1762 = x1754 * x88 + x1757 + x1761 * x81
    x1763 = (
        x1 * (x1734 * x81 + x1743 - x74 * (x1746 + x1747 * x8))
        + x1755 * x88
        + x1762 * x81
    )
    x1764 = x1763 + x24 * x550
    x1765 = x14 * x1647 + x1497 + x379
    x1766 = x1765 * x3
    x1767 = x14 * x1597 + x1493 + x375
    x1768 = x1767 * x3
    x1769 = x1767 * x74
    x1770 = x1765 - x1769
    x1771 = x1770 * x85
    x1772 = x1751 * x462 + x1771
    x1773 = (
        x1 * (x1741 * x81 + x1766 - x74 * (x1748 * x8 + x1768)) + x1755 * x81 + x1772 * x3
    )
    x1774 = x1773 + x24 * x560
    x1775 = x0 * x1774 + x1764
    x1776 = x1 * (x17 * x1765 * x5 * x8 - x1767 * x467) + x1772 * x81
    x1777 = x1776 + x24 * x563
    x1778 = -x1739 + x1740
    x1779 = x1778 * x85
    x1780 = x1760 * x3
    x1781 = 3.0 * x1780
    x1782 = x1142 + x1535 + x1671 * x341
    x1783 = x1555 + x1672 * x272 - x74 * (x11 * x1682 + x1557)
    x1784 = x1548 + x1685 * x272
    x1785 = x1784 * x3
    x1786 = x1550 + x1687 * x272
    x1787 = x1785 + x1786 * x81
    x1788 = x1786 * x3
    x1789 = x1562 + x1692 * x272
    x1790 = 2.0 * x1788 + x1789 * x81
    x1791 = x1783 * x85 + x1787 * x88 + x1790 * x81
    x1792 = x1791 + x24 * x582
    x1793 = x1570 + x1678 * x272 - x74 * (x11 * x1683 + x1571)
    x1794 = x1785 * x81 + x1787 * x81 + x1793 * x85
    x1795 = x1794 + x24 * x585
    x1796 = x0 * x1795 + x1792
    x1797 = x1575 + x1697 * x272 - x74 * (x11 * x1701 + x1576)
    x1798 = x1784 * x462 + x1797 * x85
    x1799 = x1798 + x24 * x589
    x1800 = x1579 + x1677 * x272 - x74 * (x11 * x1676 + x1581)
    x1801 = x1789 * x3
    x1802 = x1585 + x1711 * x272
    x1803 = x1611 + x1612 * x417 - x74 * (x1615 + x1618 * x417)
    x1804 = x1599 + x1600 * x417
    x1805 = x1804 * x3
    x1806 = x1603 + x1605 * x417
    x1807 = x1805 + x1806 * x81
    x1808 = x1806 * x3
    x1809 = x1626 + x1629 * x417
    x1810 = 2.0 * x1808 + x1809 * x81
    x1811 = x1803 * x85 + x1807 * x88 + x1810 * x81
    x1812 = x1811 + x24 * x609
    x1813 = x1594 * x417 + x1638 - x74 * (x1588 * x417 + x1640)
    x1814 = x1805 * x81 + x1807 * x81 + x1813 * x85
    x1815 = x1814 + x24 * x612
    x1816 = x0 * x1815 + x1812
    x1817 = x1592 * x417 + x1646 - x74 * (x1586 * x417 + x1649)
    x1818 = x1804 * x462 + x1817 * x85
    x1819 = x1818 + x24 * x616
    x1820 = x1654 + x1655 * x417 - x74 * (x1658 + x1661 * x417)
    x1821 = x1809 * x3
    x1822 = x1668 + x1671 * x417
    x1823 = x1 * (x11 * x17 * x1734 * x5 - x1736 * x270)
    x1824 = x1752 * x272
    x1825 = x1753 * x280 + x1824
    x1826 = x1759 * x272 + x1760 * x280
    x1827 = 0.5 * x1823 + x1825 * x88 + x1826 * x81
    x1828 = x1827 + x24 * x627
    x1829 = x1 * (x11 * x17 * x1741 * x5 - x1744 * x270)
    x1830 = x1752 * x280 + x1825 * x81 + 0.5 * x1829
    x1831 = x1830 + x24 * x630
    x1832 = x0 * x1831 + x1828
    x1833 = x1 * (x11 * x17 * x1765 * x5 - x1767 * x270)
    x1834 = x1751 * x635 + 0.5 * x1833
    x1835 = x1834 + x24 * x636
    x1836 = x1 * (x11 * x17 * x1740 * x5 - x1738 * x270)
    x1837 = x1610 + x1734 * x341 + x517 - x74 * (x14 * x1747 + x1614 + x519)
    x1838 = x1837 * x85
    x1839 = x1598 + x1751 * x341 + x526
    x1840 = x1839 * x3
    x1841 = x1602 + x1753 * x341 + x529
    x1842 = x1840 + x1841 * x81
    x1843 = x1841 * x3
    x1844 = 2.0 * x1843
    x1845 = x1625 + x1760 * x341 + x536
    x1846 = x1844 + x1845 * x81
    x1847 = x1838 + x1842 * x88 + x1846 * x81
    x1848 = x1847 + x24 * x655
    x1849 = x1637 + x1741 * x341 + x543 - x74 * (x14 * x1748 + x1639 + x545)
    x1850 = x1849 * x85
    x1851 = x1840 * x81 + x1842 * x81 + x1850
    x1852 = x1851 + x24 * x659
    x1853 = x0 * x1852 + x1848
    x1854 = x1645 + x1765 * x341 + x553 - x74 * (x14 * x1769 + x1648 + x555)
    x1855 = x1854 * x85
    x1856 = x1839 * x462 + x1855
    x1857 = x1856 + x24 * x664
    x1858 = x1653 + x1740 * x341 + x510 - x74 * (x14 * x1739 + x1657 + x512)
    x1859 = x1858 * x85
    x1860 = x1845 * x3
    x1861 = 3.0 * x1860
    x1862 = x1667 + x1782 * x341 + x566
    x1863 = x1684 * x171 + x1786 * x272
    x1864 = x1863 * x3
    x1865 = x1690 * x171 + x1789 * x272
    x1866 = 2.0 * x1864 + x1865 * x81
    x1867 = x1866 + x24 * x676
    x1868 = x1702 * x171 + x1784 * x272
    x1869 = x1868 * x3
    x1870 = x1863 * x81 + x1869
    x1871 = x1870 + x24 * x680
    x1872 = x0 * x1871 + x1867
    x1873 = x1868 * x81
    x1874 = x24 * x81
    x1875 = x1873 + x1874 * x678
    x1876 = x1865 * x3
    x1877 = x1709 * x171 + x1802 * x272
    x1878 = x1715 + x1806 * x272
    x1879 = x1878 * x3
    x1880 = x1719 + x1809 * x272
    x1881 = 2.0 * x1879 + x1880 * x81
    x1882 = x1881 + x24 * x692
    x1883 = x1726 + x1804 * x272
    x1884 = x1883 * x3
    x1885 = x1878 * x81 + x1884
    x1886 = x1885 + x24 * x696
    x1887 = x0 * x1886 + x1882
    x1888 = x1883 * x81
    x1889 = x1874 * x694 + x1888
    x1890 = x1880 * x3
    x1891 = x1733 + x1822 * x272
    x1892 = x1750 + x1753 * x417
    x1893 = x1892 * x3
    x1894 = x1757 + x1760 * x417
    x1895 = 2.0 * x1893 + x1894 * x81
    x1896 = x1895 + x24 * x707
    x1897 = x1751 * x417 + x1771
    x1898 = x1897 * x3
    x1899 = x1892 * x81 + x1898
    x1900 = x1899 + x24 * x711
    x1901 = x0 * x1900 + x1896
    x1902 = x1897 * x81
    x1903 = x1874 * x709 + x1902
    x1904 = x1894 * x3
    x1905 = x1779 + x1782 * x417
    x1906 = x1844 * x272 + x1845 * x280
    x1907 = x1906 + x24 * x717
    x1908 = x1840 * x272
    x1909 = x1841 * x280 + x1908
    x1910 = x1909 + x24 * x720
    x1911 = x0 * x1910 + x1907
    x1912 = x1839 * x280
    x1913 = x1912 + x24 * x723
    x1914 = x171 * x1749 + x1841 * x341 + x641
    x1915 = x1914 * x3
    x1916 = 2.0 * x1915
    x1917 = x171 * x1756 + x1845 * x341 + x645
    x1918 = x1916 + x1917 * x81
    x1919 = x1918 + x24 * x730
    x1920 = x171 * x1770 + x1839 * x341 + x653
    x1921 = x1920 * x3
    x1922 = x1914 * x81 + x1921
    x1923 = x1922 + x24 * x734
    x1924 = x0 * x1923 + x1919
    x1925 = x1920 * x81
    x1926 = x1874 * x732 + x1925
    x1927 = x1917 * x3
    x1928 = x171 * x1778 + x1862 * x341 + x667
    x1929 = x153 * x1783 + x1865 * x272
    x1930 = x1929 + x24 * x740
    x1931 = x153 * x1793 + x1863 * x272
    x1932 = x1931 + x24 * x742
    x1933 = x0 * x1932 + x1930
    x1934 = x153 * x1797 + x1868 * x272
    x1935 = x1934 + x24 * x745
    x1936 = x171 * x1803 + x1880 * x272
    x1937 = x1936 + x24 * x747
    x1938 = x171 * x1813 + x1878 * x272
    x1939 = x1938 + x24 * x749
    x1940 = x0 * x1939 + x1937
    x1941 = x171 * x1817 + x1883 * x272
    x1942 = x1941 + x24 * x752
    x1943 = x1823 + x1894 * x272
    x1944 = x1943 + x24 * x754
    x1945 = x1829 + x1892 * x272
    x1946 = x1945 + x24 * x756
    x1947 = x0 * x1946 + x1944
    x1948 = x1833 + x1897 * x272
    x1949 = x1948 + x24 * x759
    x1950 = x1838 + x1845 * x417
    x1951 = x1950 + x24 * x761
    x1952 = x1841 * x417 + x1850
    x1953 = x1952 + x24 * x763
    x1954 = x0 * x1953 + x1951
    x1955 = x1839 * x417 + x1855
    x1956 = x1955 + x24 * x766
    x1957 = x1917 * x272
    x1958 = x1957 + x24 * x768
    x1959 = x1914 * x272
    x1960 = x1959 + x24 * x770
    x1961 = x0 * x1960 + x1958
    x1962 = x1920 * x272
    x1963 = x1962 + x24 * x773
    x1964 = x153 * x1837 + x1917 * x341 + x725
    x1965 = x1964 + x24 * x775
    x1966 = x153 * x1849 + x1914 * x341 + x729
    x1967 = x1966 + x24 * x777
    x1968 = x0 * x1967 + x1965
    x1969 = x153 * x1854 + x1920 * x341 + x733
    x1970 = x1969 + x24 * x780
    x1971 = x11 * x802
    x1972 = -x1971 + x63 + x781 * x792
    x1973 = x1972 * x74
    x1974 = x11 * x793
    x1975 = x119 + x1974 - x781 * x785
    x1976 = x85 * (-x1973 - x1975)
    x1977 = x11 * x828
    x1978 = x105 - x1977 + x781 * x801
    x1979 = x1976 + x1978 * x462
    x1980 = x1979 * x74
    x1981 = -x1974 + x50 + x781 * x785
    x1982 = x1981 * x74
    x1983 = x11 * x786
    x1984 = x1983 - x781 * x783 + x83
    x1985 = x85 * (-x1982 - x1984)
    x1986 = x1972 * x462 + x1985
    x1987 = x1978 * x74
    x1988 = x172 + x1971 - x781 * x792
    x1989 = x85 * (-x1987 - x1988)
    x1990 = x11 * x849
    x1991 = x136 - x1990 + x781 * x827
    x1992 = x1989 + x1991 * x462
    x1993 = x1 * (x17 * x1972 * x5 * x8 - x1978 * x467) + x1992 * x81
    x1994 = x171 * (-x1980 + x1986) + x1993 * x81
    x1995 = -x1983 + x35 + x781 * x783
    x1996 = x1995 * x3
    x1997 = x1981 * x3
    x1998 = x18 * x1972
    x1999 = -x1981 * x36 + x1998 * x8
    x2000 = -x1999
    x2001 = x2000 * x74
    x2002 = x1997 + x2001 * x8
    x2003 = x18 * x1981
    x2004 = -x1995 * x36 + x2003 * x8
    x2005 = -x2004
    x2006 = x1972 * x3
    x2007 = x18 * x1978
    x2008 = -x1972 * x36 + x2007 * x8
    x2009 = -x2008
    x2010 = x2009 * x74
    x2011 = x2006 + x2010 * x8
    x2012 = x2011 * x74
    x2013 = x85 * (-x1999 - x2010)
    x2014 = x1978 * x3
    x2015 = x18 * x1991
    x2016 = x1978 * x36 - x2015 * x8
    x2017 = x2016 * x74
    x2018 = x2014 + x2017 * x8
    x2019 = x2018 * x74
    x2020 = x2013 + x2014 * x81 + x2019 * x8
    x2021 = x2020 * x74
    x2022 = x85 * (-x2001 - x2004)
    x2023 = x2006 * x81 + x2012 * x8 + x2022
    x2024 = x85 * (-x2008 - x2017)
    x2025 = x1991 * x3
    x2026 = -x11 * x877 + x184 + x781 * x848
    x2027 = x18 * x2026
    x2028 = x1991 * x36 - x2027 * x8
    x2029 = x2025 + x2028 * x81
    x2030 = x2024 + x2025 * x81 + x2029 * x81
    x2031 = x1 * (x2011 - x2019) + x1992 * x3 + x2030 * x81
    x2032 = x171 * (-x2021 + x2023) + x1993 * x3 + x2031 * x81
    x2033 = (
        x153
        * (
            x1 * (x1996 - x2002 * x74 + x2005 * x81)
            + x1986 * x3
            + x2023 * x81
            - x74 * (x1 * (x2002 - x2012) + x1979 * x3 + x2021 * x8)
        )
        + x1994 * x3
        + x2032 * x81
    )
    x2034 = x2033 + x23 * x898
    x2035 = x2034 + x23 * x899
    x2036 = (
        x153
        * (
            x1 * (x17 * x1995 * x5 * x8 - x1981 * x467)
            + x1986 * x81
            - x74 * (x1 * (x17 * x1981 * x5 * x8 - x1972 * x467) + x1980 * x8)
        )
        + x1994 * x81
    )
    x2037 = x2036 + x23 * x901
    x2038 = x2037 + x23 * x902
    x2039 = x2005 * x3
    x2040 = x2000 * x3
    x2041 = -x1975 - x1998
    x2042 = x2041 * x4
    x2043 = x2009 * x233
    x2044 = x2000 * x36 + x2042 - x2043
    x2045 = x2044 * x74
    x2046 = 2.0 * x2040 + x2045 * x8
    x2047 = -x1984 - x2003
    x2048 = x2047 * x4
    x2049 = x2000 * x233
    x2050 = x2005 * x36 + x2048 - x2049
    x2051 = x2009 * x3
    x2052 = 2.0 * x2051
    x2053 = -x1988 - x2007
    x2054 = x2053 * x4
    x2055 = x2016 * x233
    x2056 = x2009 * x36 + x2054 - x2055
    x2057 = x2056 * x74
    x2058 = x2052 + x2057 * x8
    x2059 = x2058 * x74
    x2060 = x85 * (x2000 * x36 + x2041 * x4 - x2043 - x2057)
    x2061 = x2016 * x3
    x2062 = 2.0 * x2061
    x2063 = x4 * (-x1977 - x2015 - x253 + x781 * x801)
    x2064 = x2016 * x36 - x2028 * x233 + x2063
    x2065 = x2064 * x74
    x2066 = x74 * (x2062 + x2065 * x8)
    x2067 = x74 * (x2018 * x88 + x2060 + x2066 * x8)
    x2068 = x85 * (x2005 * x36 - x2045 + x2047 * x4 - x2049)
    x2069 = x2011 * x88 + x2059 * x8 + x2068
    x2070 = x85 * (x2009 * x36 + x2053 * x4 - x2055 - x2065)
    x2071 = x2028 * x3
    x2072 = 2.0 * x2071
    x2073 = x4 * (-x1990 - x2027 - x263 + x781 * x827)
    x2074 = x11 * x18
    x2075 = -x2074 * x934 + x264 + x781 * x876
    x2076 = x2028 * x36 + x2073 - x233 * (x2026 * x36 - x2075 * x233)
    x2077 = 2.0 * x838
    x2078 = x11 * x1987 + x2077
    x2079 = 2.0 * x817
    x2080 = x11 * x1973 + x2079
    x2081 = x2078 * x74
    x2082 = x1 * (x2080 - x2081)
    x2083 = 2.0 * x867
    x2084 = x1991 * x272 + x2083
    x2085 = 0.5 * x2082 + x2084 * x462
    x2086 = x1 * (x17 * x2080 * x5 * x8 - x2078 * x467) + x2085 * x81
    x2087 = x11 * x2001 + x797
    x2088 = x1 * (x2005 * x272 - x2087 * x74 + x790)
    x2089 = x11 * x2010 + x823
    x2090 = x2089 * x74
    x2091 = x1 * (x2087 - x2090)
    x2092 = x2078 * x3
    x2093 = x11 * x2017 + x845
    x2094 = x2093 * x74
    x2095 = x2092 + x2094 * x8
    x2096 = x2095 * x74
    x2097 = x2080 * x3
    x2098 = x2090 * x8 + x2097
    x2099 = x1 * (x2089 - x2094)
    x2100 = x2084 * x3
    x2101 = x2028 * x272 + x874
    x2102 = x2100 + x2101 * x81
    x2103 = 0.5 * x2099 + x2100 * x81 + x2102 * x81
    x2104 = x1 * (-x2096 + x2098) + x2085 * x3 + x2103 * x81
    x2105 = (
        x171
        * (
            0.5 * x2088
            + x2097 * x81
            + x2098 * x81
            - x74 * (0.5 * x2091 + x2092 * x81 + x2096 * x8)
        )
        + x2086 * x3
        + x2104 * x81
    )
    x2106 = x2105 + x23 * x981
    x2107 = x2106 + x23 * x982
    x2108 = x11 * x1982 + 2.0 * x896
    x2109 = x1 * (x1995 * x272 - x2108 * x74 + 2.0 * x895)
    x2110 = x2080 * x74
    x2111 = x1 * (x2108 - x2110)
    x2112 = (
        x171 * (x2080 * x462 + 0.5 * x2109 - x74 * (x2078 * x462 + 0.5 * x2111))
        + x2086 * x81
    )
    x2113 = x2112 + x23 * x988
    x2114 = x2113 + x23 * x989
    x2115 = x11 * x2045 + 2.0 * x904
    x2116 = x1 * (x2050 * x272 - x2115 * x74 + 2.0 * x903)
    x2117 = 2.0 * x913
    x2118 = x11 * x2057 + x2117
    x2119 = x2118 * x74
    x2120 = x1 * (x2115 - x2119)
    x2121 = 2.0 * x922
    x2122 = x74 * (x11 * x2065 + x2121)
    x2123 = x74 * (x2093 * x88 + x2122 * x8)
    x2124 = x2089 * x88 + x2119 * x8
    x2125 = x1 * (x2118 - x2122)
    x2126 = 2.0 * x931
    x2127 = x2076 * x272 + x2126
    x2128 = x1 * (x14 * x17 * x1972 * x5 - x1978 * x339)
    x2129 = 0.5 * x2128
    x2130 = x1009 * x1991 + x2129
    x2131 = x1 * (-x1036 * x1978 + x14 * x1972 * x267 * x268 * x8) + x2130 * x81
    x2132 = x1 * (x14 * x17 * x2005 * x5 - x2000 * x339)
    x2133 = 0.5 * x2132
    x2134 = x2009 * x339
    x2135 = x1 * (x14 * x17 * x2000 * x5 - x2134)
    x2136 = 0.5 * x2135
    x2137 = x2016 * x339
    x2138 = x2014 * x341
    x2139 = x2137 * x8 + x2138
    x2140 = x2139 * x74
    x2141 = x2006 * x341
    x2142 = x2134 * x8 + x2141
    x2143 = x1 * (x14 * x17 * x2009 * x5 - x2137)
    x2144 = 0.5 * x2143
    x2145 = x2025 * x341
    x2146 = x2028 * x349 + x2145
    x2147 = x2025 * x349 + x2144 + x2146 * x81
    x2148 = x1 * (-x2140 + x2142) + x2130 * x3 + x2147 * x81
    x2149 = (
        x171
        * (x2006 * x349 + x2133 + x2142 * x81 - x74 * (x2014 * x349 + x2136 + x2140 * x8))
        + x2131 * x3
        + x2148 * x81
    )
    x2150 = x1042 * x23 + x2149
    x2151 = x1043 * x23 + x2150
    x2152 = x1 * (x14 * x17 * x1995 * x5 - x1981 * x339)
    x2153 = 0.5 * x2152
    x2154 = x1 * (x14 * x17 * x1981 * x5 - x1972 * x339)
    x2155 = 0.5 * x2154
    x2156 = x171 * (x1009 * x1972 + x2153 - x74 * (x1009 * x1978 + x2155)) + x2131 * x81
    x2157 = x1049 * x23 + x2156
    x2158 = x1050 * x23 + x2157
    x2159 = x1 * (x14 * x17 * x2050 * x5 - x2044 * x339)
    x2160 = 0.5 * x2159
    x2161 = x2056 * x339
    x2162 = x1 * (x14 * x17 * x2044 * x5 - x2161)
    x2163 = 0.5 * x2162
    x2164 = x2064 * x339
    x2165 = x74 * (x2062 * x341 + x2164 * x8)
    x2166 = x2052 * x341 + x2161 * x8
    x2167 = x1 * (x14 * x17 * x2056 * x5 - x2164)
    x2168 = 0.5 * x2167
    x2169 = x11 * x2090 + x2022 + x967
    x2170 = x11 * x2094 + x2013 + x962
    x2171 = x74 * (x11 * x2122 + x2060 + x88 * x963)
    x2172 = x11 * x2119 + x2068 + x88 * x959
    x2173 = x11 * x2110 + x1985 + 2.0 * x943
    x2174 = x2173 * x3
    x2175 = x11 * x2081 + x1976 + 2.0 * x937
    x2176 = x2175 * x3
    x2177 = x2170 * x74
    x2178 = x2175 * x74
    x2179 = x2173 - x2178
    x2180 = x1989 + x2084 * x272 + 2.0 * x952
    x2181 = x2179 * x85 + x2180 * x462
    x2182 = x2169 - x2177
    x2183 = x2180 * x3
    x2184 = x2024 + x2101 * x272 + x970
    x2185 = x2183 + x2184 * x81
    x2186 = x2182 * x85 + x2183 * x81 + x2185 * x81
    x2187 = (
        x1 * (x2169 * x81 + x2174 - x74 * (x2176 + x2177 * x8)) + x2181 * x3 + x2186 * x81
    )
    x2188 = x1091 * x23 + x2187
    x2189 = x1092 * x23 + x2188
    x2190 = x1 * (x17 * x2173 * x5 * x8 - x2175 * x467) + x2181 * x81
    x2191 = x1094 * x23 + x2190
    x2192 = x1095 * x23 + x2191
    x2193 = -x2171 + x2172
    x2194 = x2070 + x2127 * x272 + x88 * x971
    x2195 = x1026 + x2009 * x477
    x2196 = x1023 + x2016 * x477
    x2197 = x74 * (x2064 * x477 + x2121 * x341)
    x2198 = x2056 * x477 + x2117 * x341
    x2199 = x1972 * x477 + x2079 * x341
    x2200 = x2199 * x3
    x2201 = x1978 * x477 + x2077 * x341
    x2202 = x2201 * x3
    x2203 = x2196 * x74
    x2204 = x2201 * x74
    x2205 = x1 * (x2199 - x2204)
    x2206 = x1991 * x477 + x2083 * x341
    x2207 = 0.5 * x2205 + x2206 * x462
    x2208 = x1 * (x2195 - x2203)
    x2209 = x2206 * x3
    x2210 = x1030 + x2028 * x477
    x2211 = x2209 + x2210 * x81
    x2212 = 0.5 * x2208 + x2209 * x81 + x2211 * x81
    x2213 = (
        x1 * (x2195 * x81 + x2200 - x74 * (x2202 + x2203 * x8)) + x2207 * x3 + x2212 * x81
    )
    x2214 = x1136 * x23 + x2213
    x2215 = x1137 * x23 + x2214
    x2216 = x1 * (x17 * x2199 * x5 * x8 - x2201 * x467) + x2207 * x81
    x2217 = x1139 * x23 + x2216
    x2218 = x1140 * x23 + x2217
    x2219 = x1 * (-x2197 + x2198)
    x2220 = x2076 * x477 + x2126 * x341
    x2221 = x2009 * x508 + x2022
    x2222 = x2221 * x3
    x2223 = x2013 + x2016 * x508
    x2224 = x2223 * x3
    x2225 = x74 * (x2060 + x2064 * x508)
    x2226 = x2056 * x508 + x2068
    x2227 = x1972 * x508 + x1985
    x2228 = x2227 * x3
    x2229 = x1976 + x1978 * x508
    x2230 = x2229 * x3
    x2231 = x2223 * x74
    x2232 = x2229 * x74
    x2233 = x2227 - x2232
    x2234 = x2233 * x85
    x2235 = x1989 + x1991 * x508
    x2236 = x2234 + x2235 * x462
    x2237 = x2221 - x2231
    x2238 = x2237 * x85
    x2239 = x2235 * x3
    x2240 = x2024 + x2028 * x508
    x2241 = x2239 + x2240 * x81
    x2242 = x2238 + x2239 * x81 + x2241 * x81
    x2243 = (
        x1 * (x2221 * x81 + x2228 - x74 * (x2230 + x2231 * x8)) + x2236 * x3 + x2242 * x81
    )
    x2244 = x1182 * x23 + x2243
    x2245 = x1183 * x23 + x2244
    x2246 = x1 * (x17 * x2227 * x5 * x8 - x2229 * x467) + x2236 * x81
    x2247 = x1185 * x23 + x2246
    x2248 = x1186 * x23 + x2247
    x2249 = -x2225 + x2226
    x2250 = x2249 * x85
    x2251 = x2240 * x3
    x2252 = x2070 + x2076 * x508
    x2253 = x1066 + x2088 + x2169 * x272 - x74 * (x1068 + x11 * x2177 + x2091)
    x2254 = 2.0 * x1073 + x2082 + x2180 * x272
    x2255 = x2254 * x3
    x2256 = x1078 + x2099 + x2184 * x272
    x2257 = x2255 + x2256 * x81
    x2258 = x2253 * x85 + x2255 * x81 + x2257 * x81
    x2259 = x1202 * x23 + x2258
    x2260 = x1203 * x23 + x2259
    x2261 = 2.0 * x1085 + x2109 + x2173 * x272 - x74 * (2.0 * x1087 + x11 * x2178 + x2111)
    x2262 = x2254 * x462 + x2261 * x85
    x2263 = x1206 * x23 + x2262
    x2264 = x1207 * x23 + x2263
    x2265 = x1061 * x88 + x2116 + x2172 * x272 - x74 * (x1062 * x88 + x11 * x2171 + x2120)
    x2266 = x1079 * x88 + x2125 + x2194 * x272
    x2267 = x1108 + x2133 + x2195 * x272 - x74 * (x11 * x2203 + x1111 + x2136)
    x2268 = 2.0 * x1116 + x2129 + x2206 * x272
    x2269 = x2268 * x3
    x2270 = x1122 + x2144 + x2210 * x272
    x2271 = x2269 + x2270 * x81
    x2272 = x2267 * x85 + x2269 * x81 + x2271 * x81
    x2273 = x1221 * x23 + x2272
    x2274 = x1222 * x23 + x2273
    x2275 = 2.0 * x1130 + x2153 + x2199 * x272 - x74 * (x11 * x2204 + 2.0 * x1132 + x2155)
    x2276 = x2268 * x462 + x2275 * x85
    x2277 = x1225 * x23 + x2276
    x2278 = x1226 * x23 + x2277
    x2279 = x1099 * x88 + x2160 + x2198 * x272 - x74 * (x11 * x2197 + x1101 * x88 + x2163)
    x2280 = x1124 * x88 + x2168 + x2220 * x272
    x2281 = x1 * (x1152 + x2221 * x272 - x74 * (x11 * x2231 + x1155))
    x2282 = 2.0 * x1161 + x2235 * x272
    x2283 = x2282 * x3
    x2284 = x1168 + x2240 * x272
    x2285 = x2283 + x2284 * x81
    x2286 = 0.5 * x2281 + x2283 * x81 + x2285 * x81
    x2287 = x1240 * x23 + x2286
    x2288 = x1241 * x23 + x2287
    x2289 = x1 * (2.0 * x1175 + x2227 * x272 - x74 * (x11 * x2232 + 2.0 * x1177))
    x2290 = x2282 * x462 + 0.5 * x2289
    x2291 = x1244 * x23 + x2290
    x2292 = x1245 * x23 + x2291
    x2293 = x1 * (2.0 * x1145 + x2226 * x272 - x74 * (x11 * x2225 + 2.0 * x1147))
    x2294 = 2.0 * x1189 + x2252 * x272
    x2295 = x2132 + x2221 * x341 - x74 * (x14 * x2231 + x2135)
    x2296 = x2295 * x85
    x2297 = x2128 + x2235 * x341
    x2298 = x2297 * x3
    x2299 = x2143 + x2240 * x341
    x2300 = x2298 + x2299 * x81
    x2301 = x2296 + x2298 * x81 + x2300 * x81
    x2302 = x1262 * x23 + x2301
    x2303 = x1263 * x23 + x2302
    x2304 = x2152 + x2227 * x341 - x74 * (x14 * x2232 + x2154)
    x2305 = x2304 * x85
    x2306 = x2297 * x462 + x2305
    x2307 = x1267 * x23 + x2306
    x2308 = x1268 * x23 + x2307
    x2309 = x2159 + x2226 * x341 - x74 * (x14 * x2225 + x2162)
    x2310 = x2309 * x85
    x2311 = x2299 * x3
    x2312 = x2167 + x2252 * x341
    x2313 = 2.0 * x1193 + x171 * x2179 + x2254 * x272
    x2314 = x2313 * x3
    x2315 = x1196 + x171 * x2182 + x2256 * x272
    x2316 = x2314 + x2315 * x81
    x2317 = x1280 * x23 + x2316
    x2318 = x1281 * x23 + x2317
    x2319 = x2313 * x81
    x2320 = x1283 * x23 + x2319
    x2321 = x1285 * x23 + x2320
    x2322 = x1197 * x88 + x171 * x2193 + x2266 * x272
    x2323 = 2.0 * x1212 + x2205 + x2268 * x272
    x2324 = x2323 * x3
    x2325 = x1215 + x2208 + x2270 * x272
    x2326 = x2324 + x2325 * x81
    x2327 = x1294 * x23 + x2326
    x2328 = x1295 * x23 + x2327
    x2329 = x2323 * x81
    x2330 = x1297 * x23 + x2329
    x2331 = x1298 * x23 + x2330
    x2332 = x1216 * x88 + x2219 + x2280 * x272
    x2333 = 2.0 * x1231 + x2234 + x2282 * x272
    x2334 = x2333 * x3
    x2335 = x1234 + x2238 + x2284 * x272
    x2336 = x2334 + x2335 * x81
    x2337 = x1307 * x23 + x2336
    x2338 = x1308 * x23 + x2337
    x2339 = x2333 * x81
    x2340 = x1310 * x23 + x2339
    x2341 = x1311 * x23 + x2340
    x2342 = x1235 * x88 + x2250 + x2294 * x272
    x2343 = 2.0 * x1251 + x2297 * x272
    x2344 = x2343 * x3
    x2345 = x1255 + x2299 * x272
    x2346 = x2344 + x2345 * x81
    x2347 = x1320 * x23 + x2346
    x2348 = x1321 * x23 + x2347
    x2349 = x2343 * x81
    x2350 = x1323 * x23 + x2349
    x2351 = x1324 * x23 + x2350
    x2352 = 2.0 * x1271 + x2312 * x272
    x2353 = x171 * x2233 + x2297 * x341
    x2354 = x2353 * x3
    x2355 = x171 * x2237 + x2299 * x341
    x2356 = x2354 + x2355 * x81
    x2357 = x1334 * x23 + x2356
    x2358 = x1335 * x23 + x2357
    x2359 = x2353 * x81
    x2360 = x1337 * x23 + x2359
    x2361 = x1338 * x23 + x2360
    x2362 = x2355 * x3
    x2363 = x171 * x2249 + x2312 * x341
    x2364 = x1274 + x153 * x2253 + x2315 * x272
    x2365 = x1343 * x23 + x2364
    x2366 = x1344 * x23 + x2365
    x2367 = 2.0 * x1279 + x153 * x2261 + x2313 * x272
    x2368 = x1346 * x23 + x2367
    x2369 = x1347 * x23 + x2368
    x2370 = x1288 + x171 * x2267 + x2325 * x272
    x2371 = x1350 * x23 + x2370
    x2372 = x1351 * x23 + x2371
    x2373 = 2.0 * x1293 + x171 * x2275 + x2323 * x272
    x2374 = x1353 * x23 + x2373
    x2375 = x1354 * x23 + x2374
    x2376 = x1301 + x2281 + x2335 * x272
    x2377 = x1357 * x23 + x2376
    x2378 = x1358 * x23 + x2377
    x2379 = 2.0 * x1306 + x2289 + x2333 * x272
    x2380 = x1360 * x23 + x2379
    x2381 = x1361 * x23 + x2380
    x2382 = x1314 + x2296 + x2345 * x272
    x2383 = x1364 * x23 + x2382
    x2384 = x1365 * x23 + x2383
    x2385 = 2.0 * x1319 + x2305 + x2343 * x272
    x2386 = x1367 * x23 + x2385
    x2387 = x1368 * x23 + x2386
    x2388 = x1328 + x2355 * x272
    x2389 = x1371 * x23 + x2388
    x2390 = x1372 * x23 + x2389
    x2391 = 2.0 * x1333 + x2353 * x272
    x2392 = x1374 * x23 + x2391
    x2393 = x1375 * x23 + x2392
    x2394 = x153 * x2295 + x2355 * x341
    x2395 = x1378 * x23 + x2394
    x2396 = x1379 * x23 + x2395
    x2397 = x153 * x2304 + x2353 * x341
    x2398 = x1381 * x23 + x2397
    x2399 = x1382 * x23 + x2398
    x2400 = x11 * x1404 - x1394 * x781
    x2401 = -x2400
    x2402 = x2401 * x74
    x2403 = x11 * x1395 - x1387 * x781
    x2404 = x85 * (-x2402 - x2403)
    x2405 = x11 * x1430 - x1403 * x781
    x2406 = -x2405
    x2407 = x2404 + x2406 * x462
    x2408 = x2407 * x74
    x2409 = -x2403
    x2410 = x2409 * x74
    x2411 = x11 * x1388 - x1385 * x781
    x2412 = x85 * (-x2410 - x2411)
    x2413 = x2401 * x462 + x2412
    x2414 = x2406 * x74
    x2415 = x85 * (-x2400 - x2414)
    x2416 = x11 * x1452 - x1429 * x781
    x2417 = -x2416
    x2418 = x2415 + x2417 * x462
    x2419 = x1 * (x17 * x2401 * x5 * x8 - x2406 * x467) + x2418 * x81
    x2420 = x171 * (-x2408 + x2413) + x2419 * x81
    x2421 = -x2411
    x2422 = x2421 * x3
    x2423 = x2409 * x3
    x2424 = x18 * x2401
    x2425 = -x2409 * x36 + x2424 * x8
    x2426 = -x2425
    x2427 = x2426 * x74
    x2428 = x2423 + x2427 * x8
    x2429 = x18 * x2409
    x2430 = -x2421 * x36 + x2429 * x8
    x2431 = -x2430
    x2432 = x2401 * x3
    x2433 = x18 * x2406
    x2434 = -x2401 * x36 + x2433 * x8
    x2435 = -x2434
    x2436 = x2435 * x74
    x2437 = x2432 + x2436 * x8
    x2438 = x2437 * x74
    x2439 = x85 * (-x2425 - x2436)
    x2440 = x2406 * x3
    x2441 = x18 * x2417
    x2442 = x2406 * x36 - x2441 * x8
    x2443 = x2442 * x74
    x2444 = x2440 + x2443 * x8
    x2445 = x2444 * x74
    x2446 = x2439 + x2440 * x81 + x2445 * x8
    x2447 = x2446 * x74
    x2448 = x85 * (-x2427 - x2430)
    x2449 = x2432 * x81 + x2438 * x8 + x2448
    x2450 = x85 * (-x2434 - x2443)
    x2451 = x2417 * x3
    x2452 = -x11 * x1482 + x1451 * x781
    x2453 = x18 * x2452
    x2454 = x2417 * x36 - x2453 * x8
    x2455 = x2451 + x2454 * x81
    x2456 = x2450 + x2451 * x81 + x2455 * x81
    x2457 = x1 * (x2437 - x2445) + x2418 * x3 + x2456 * x81
    x2458 = x171 * (-x2447 + x2449) + x2419 * x3 + x2457 * x81
    x2459 = (
        x153
        * (
            x1 * (x2422 - x2428 * x74 + x2431 * x81)
            + x2413 * x3
            + x2449 * x81
            - x74 * (x1 * (x2428 - x2438) + x2407 * x3 + x2447 * x8)
        )
        + x2420 * x3
        + x2458 * x81
    )
    x2460 = x24 * x898 + x2459
    x2461 = x1504 * x23 + x2460
    x2462 = (
        x153
        * (
            x1 * (x17 * x2421 * x5 * x8 - x2409 * x467)
            + x2413 * x81
            - x74 * (x1 * (x17 * x2409 * x5 * x8 - x2401 * x467) + x2408 * x8)
        )
        + x2420 * x81
    )
    x2463 = x24 * x901 + x2462
    x2464 = x1507 * x23 + x2463
    x2465 = x2431 * x88
    x2466 = x2426 * x88
    x2467 = -x2403 - x2424
    x2468 = x2467 * x4
    x2469 = x233 * x2435
    x2470 = x74 * (x2426 * x36 + x2468 - x2469)
    x2471 = x2466 + x2470 * x8
    x2472 = -x2411 - x2429
    x2473 = x2472 * x4
    x2474 = x233 * x2426
    x2475 = x2431 * x36 + x2473 - x2474
    x2476 = x2435 * x88
    x2477 = -x2400 - x2433
    x2478 = x2477 * x4
    x2479 = x233 * x2442
    x2480 = x74 * (x2435 * x36 + x2478 - x2479)
    x2481 = x2476 + x2480 * x8
    x2482 = x2481 * x74
    x2483 = x85 * (x2426 * x36 + x2467 * x4 - x2469 - x2480)
    x2484 = x2442 * x88
    x2485 = x4 * (-x2405 - x2441)
    x2486 = x74 * (-x233 * x2454 + x2442 * x36 + x2485)
    x2487 = x74 * (x2484 + x2486 * x8)
    x2488 = x74 * (x2444 * x88 + x2483 + x2487 * x8)
    x2489 = x85 * (x2431 * x36 - x2470 + x2472 * x4 - x2474)
    x2490 = x2437 * x88 + x2482 * x8 + x2489
    x2491 = x85 * (x2435 * x36 + x2477 * x4 - x2479 - x2486)
    x2492 = x2454 * x88
    x2493 = x4 * (-x2416 - x2453)
    x2494 = x1481 * x781 - x1539 * x2074
    x2495 = -x233 * (-x233 * x2494 + x2452 * x36) + x2454 * x36 + x2493
    x2496 = x11 * x2414 + x1440
    x2497 = x11 * x2402 + x1419
    x2498 = x2496 * x74
    x2499 = x1 * (x2497 - x2498)
    x2500 = x1471 + x2417 * x272
    x2501 = 0.5 * x2499 + x2500 * x462
    x2502 = x1 * (x17 * x2497 * x5 * x8 - x2496 * x467) + x2501 * x81
    x2503 = x11 * x2427 + x1398
    x2504 = x1 * (x1391 + x2431 * x272 - x2503 * x74)
    x2505 = x11 * x2436 + x1424
    x2506 = x2505 * x74
    x2507 = x1 * (x2503 - x2506)
    x2508 = x2496 * x3
    x2509 = x11 * x2443 + x1447
    x2510 = x2509 * x74
    x2511 = x2508 + x2510 * x8
    x2512 = x2511 * x74
    x2513 = x2497 * x3
    x2514 = x2506 * x8 + x2513
    x2515 = x1 * (x2505 - x2510)
    x2516 = x2500 * x3
    x2517 = x1478 + x2454 * x272
    x2518 = x2516 + x2517 * x81
    x2519 = 0.5 * x2515 + x2516 * x81 + x2518 * x81
    x2520 = x1 * (-x2512 + x2514) + x2501 * x3 + x2519 * x81
    x2521 = (
        x171
        * (
            0.5 * x2504
            + x2513 * x81
            + x2514 * x81
            - x74 * (0.5 * x2507 + x2508 * x81 + x2512 * x8)
        )
        + x2502 * x3
        + x2520 * x81
    )
    x2522 = x24 * x981 + x2521
    x2523 = x1573 * x23 + x2522
    x2524 = x11 * x2410 + x1501
    x2525 = x1 * (x1500 + x2421 * x272 - x2524 * x74)
    x2526 = x2497 * x74
    x2527 = x1 * (x2524 - x2526)
    x2528 = (
        x171 * (x2497 * x462 + 0.5 * x2525 - x74 * (x2496 * x462 + 0.5 * x2527))
        + x2502 * x81
    )
    x2529 = x24 * x988 + x2528
    x2530 = x1578 * x23 + x2529
    x2531 = x11 * x2470 + x1509
    x2532 = x1 * (x1508 + x2475 * x272 - x2531 * x74)
    x2533 = x11 * x2480 + x1518
    x2534 = x2533 * x74
    x2535 = x1 * (x2531 - x2534)
    x2536 = x2509 * x88
    x2537 = x74 * (x11 * x2486 + x1527)
    x2538 = x74 * (x2536 + x2537 * x8)
    x2539 = x2505 * x88
    x2540 = x2534 * x8 + x2539
    x2541 = x1 * (x2533 - x2537)
    x2542 = x2517 * x88
    x2543 = x1536 + x2495 * x272
    x2544 = x14 * x2414 + x838
    x2545 = x14 * x2402 + x817
    x2546 = x2544 * x74
    x2547 = x1 * (x2545 - x2546)
    x2548 = 0.5 * x2547
    x2549 = x2417 * x341 + x867
    x2550 = x2548 + x2549 * x462
    x2551 = x1 * (x17 * x2545 * x5 * x8 - x2544 * x467) + x2550 * x81
    x2552 = x14 * x2427 + x796
    x2553 = x1 * (x2431 * x341 - x2552 * x74 + x789)
    x2554 = 0.5 * x2553
    x2555 = x14 * x2436 + x822
    x2556 = x2555 * x74
    x2557 = x1 * (x2552 - x2556)
    x2558 = 0.5 * x2557
    x2559 = x2544 * x3
    x2560 = x14 * x2443 + x844
    x2561 = x2560 * x74
    x2562 = x2559 + x2561 * x8
    x2563 = x2562 * x74
    x2564 = x2545 * x3
    x2565 = x2556 * x8 + x2564
    x2566 = x1 * (x2555 - x2561)
    x2567 = 0.5 * x2566
    x2568 = x2549 * x3
    x2569 = x2454 * x341 + x873
    x2570 = x2568 + x2569 * x81
    x2571 = x2567 + x2568 * x81 + x2570 * x81
    x2572 = x1 * (-x2563 + x2565) + x2550 * x3 + x2571 * x81
    x2573 = (
        x171
        * (x2554 + x2564 * x81 + x2565 * x81 - x74 * (x2558 + x2559 * x81 + x2563 * x8))
        + x2551 * x3
        + x2572 * x81
    )
    x2574 = x1042 * x24 + x2573
    x2575 = x1642 * x23 + x2574
    x2576 = x14 * x2410 + x896
    x2577 = x1 * (x2421 * x341 - x2576 * x74 + x895)
    x2578 = 0.5 * x2577
    x2579 = x2545 * x74
    x2580 = x1 * (x2576 - x2579)
    x2581 = 0.5 * x2580
    x2582 = x171 * (x2545 * x462 + x2578 - x74 * (x2544 * x462 + x2581)) + x2551 * x81
    x2583 = x1049 * x24 + x2582
    x2584 = x1651 * x23 + x2583
    x2585 = x14 * x2470 + x904
    x2586 = x1 * (x2475 * x341 - x2585 * x74 + x903)
    x2587 = 0.5 * x2586
    x2588 = x14 * x2480 + x913
    x2589 = x2588 * x74
    x2590 = x1 * (x2585 - x2589)
    x2591 = 0.5 * x2590
    x2592 = x2560 * x88
    x2593 = x74 * (x14 * x2486 + x922)
    x2594 = x74 * (x2592 + x2593 * x8)
    x2595 = x2555 * x88
    x2596 = x2589 * x8 + x2595
    x2597 = x1 * (x2588 - x2593)
    x2598 = 0.5 * x2597
    x2599 = x2569 * x88
    x2600 = x2495 * x341 + x931
    x2601 = x11 * x2506 + x1424 * x272 + x2448
    x2602 = x2601 * x88
    x2603 = x11 * x2510 + x1447 * x272 + x2439
    x2604 = x2603 * x88
    x2605 = x74 * (x11 * x2537 + x1527 * x272 + x2483)
    x2606 = x11 * x2534 + x1518 * x272 + x2489
    x2607 = x11 * x2526 + x1546 + x2412
    x2608 = x2607 * x3
    x2609 = x11 * x2498 + x1542 + x2404
    x2610 = x2609 * x3
    x2611 = x2603 * x74
    x2612 = x2609 * x74
    x2613 = x2607 - x2612
    x2614 = x1551 + x2415 + x2500 * x272
    x2615 = x2613 * x85 + x2614 * x462
    x2616 = x2601 - x2611
    x2617 = x2614 * x3
    x2618 = x1478 * x272 + x2450 + x2517 * x272
    x2619 = x2617 + x2618 * x81
    x2620 = x2616 * x85 + x2617 * x81 + x2619 * x81
    x2621 = (
        x1 * (x2601 * x81 + x2608 - x74 * (x2610 + x2611 * x8)) + x2615 * x3 + x2620 * x81
    )
    x2622 = x1091 * x24 + x2621
    x2623 = x1705 * x23 + x2622
    x2624 = x1 * (x17 * x2607 * x5 * x8 - x2609 * x467) + x2615 * x81
    x2625 = x1094 * x24 + x2624
    x2626 = x1708 * x23 + x2625
    x2627 = -x2605 + x2606
    x2628 = x2618 * x88
    x2629 = x1536 * x272 + x2491 + x2543 * x272
    x2630 = x11 * x2556 + x1622
    x2631 = x2630 * x88
    x2632 = x11 * x2561 + x1616
    x2633 = x2632 * x88
    x2634 = x74 * (x11 * x2593 + x1659)
    x2635 = x11 * x2589 + x1664
    x2636 = x11 * x2579 + x1593
    x2637 = x2636 * x3
    x2638 = x11 * x2546 + x1587
    x2639 = x2638 * x3
    x2640 = x2632 * x74
    x2641 = x2638 * x74
    x2642 = x1 * (x2636 - x2641)
    x2643 = x1604 + x2549 * x272
    x2644 = 0.5 * x2642 + x2643 * x462
    x2645 = x1 * (x2630 - x2640)
    x2646 = x2643 * x3
    x2647 = x1627 + x2569 * x272
    x2648 = x2646 + x2647 * x81
    x2649 = 0.5 * x2645 + x2646 * x81 + x2648 * x81
    x2650 = (
        x1 * (x2630 * x81 + x2637 - x74 * (x2639 + x2640 * x8)) + x2644 * x3 + x2649 * x81
    )
    x2651 = x1136 * x24 + x2650
    x2652 = x1729 * x23 + x2651
    x2653 = x1 * (x17 * x2636 * x5 * x8 - x2638 * x467) + x2644 * x81
    x2654 = x1139 * x24 + x2653
    x2655 = x1732 * x23 + x2654
    x2656 = x1 * (-x2634 + x2635)
    x2657 = x2647 * x88
    x2658 = x1669 + x2600 * x272
    x2659 = x14 * x2556 + x2448 + x341 * x822
    x2660 = x2659 * x88
    x2661 = x14 * x2561 + x2439 + x341 * x844
    x2662 = x2661 * x88
    x2663 = x74 * (x14 * x2593 + x2483 + x341 * x922)
    x2664 = x14 * x2589 + x2489 + x341 * x913
    x2665 = x1005 + x14 * x2579 + x2412
    x2666 = x2665 * x3
    x2667 = x1001 + x14 * x2546 + x2404
    x2668 = x2667 * x3
    x2669 = x2661 * x74
    x2670 = x2667 * x74
    x2671 = x2665 - x2670
    x2672 = x2671 * x85
    x2673 = x1013 + x2415 + x2549 * x341
    x2674 = x2672 + x2673 * x462
    x2675 = x2659 - x2669
    x2676 = x2675 * x85
    x2677 = x2673 * x3
    x2678 = x2450 + x2569 * x341 + x341 * x873
    x2679 = x2677 + x2678 * x81
    x2680 = x2676 + x2677 * x81 + x2679 * x81
    x2681 = (
        x1 * (x2659 * x81 + x2666 - x74 * (x2668 + x2669 * x8)) + x2674 * x3 + x2680 * x81
    )
    x2682 = x1182 * x24 + x2681
    x2683 = x1774 * x23 + x2682
    x2684 = x1 * (x17 * x2665 * x5 * x8 - x2667 * x467) + x2674 * x81
    x2685 = x1185 * x24 + x2684
    x2686 = x1777 * x23 + x2685
    x2687 = -x2663 + x2664
    x2688 = x2687 * x85
    x2689 = x2678 * x88
    x2690 = x2491 + x2600 * x341 + x341 * x931
    x2691 = x1679 + x2504 + x2601 * x272 - x74 * (x11 * x2611 + x1681 + x2507)
    x2692 = x1686 + x2499 + x2614 * x272
    x2693 = x2692 * x3
    x2694 = x1691 + x2515 + x2618 * x272
    x2695 = x2693 + x2694 * x81
    x2696 = x2691 * x85 + x2693 * x81 + x2695 * x81
    x2697 = x1202 * x24 + x2696
    x2698 = x1795 * x23 + x2697
    x2699 = x1698 + x2525 + x2607 * x272 - x74 * (x11 * x2612 + x1700 + x2527)
    x2700 = x2692 * x462 + x2699 * x85
    x2701 = x1206 * x24 + x2700
    x2702 = x1799 * x23 + x2701
    x2703 = x1673 + x2532 + x2606 * x272 - x74 * (x11 * x2605 + x1675 + x2535)
    x2704 = x2694 * x88
    x2705 = x1710 + x2541 + x2629 * x272
    x2706 = (
        x1622 * x272 + x2554 + x2630 * x272 - x74 * (x11 * x2640 + x1616 * x272 + x2558)
    )
    x2707 = x1716 + x2548 + x2643 * x272
    x2708 = x2707 * x3
    x2709 = x1627 * x272 + x2567 + x2647 * x272
    x2710 = x2708 + x2709 * x81
    x2711 = x2706 * x85 + x2708 * x81 + x2710 * x81
    x2712 = x1221 * x24 + x2711
    x2713 = x1815 * x23 + x2712
    x2714 = x1725 + x2578 + x2636 * x272 - x74 * (x11 * x2641 + x1724 + x2581)
    x2715 = x2707 * x462 + x2714 * x85
    x2716 = x1225 * x24 + x2715
    x2717 = x1819 * x23 + x2716
    x2718 = (
        x1664 * x272 + x2587 + x2635 * x272 - x74 * (x11 * x2634 + x1659 * x272 + x2591)
    )
    x2719 = x2709 * x88
    x2720 = x1669 * x272 + x2598 + x2658 * x272
    x2721 = x1 * (x1742 + x2659 * x272 - x74 * (x11 * x2669 + x1745))
    x2722 = x1752 + x2673 * x272
    x2723 = x2722 * x3
    x2724 = x1758 + x2678 * x272
    x2725 = x2723 + x2724 * x81
    x2726 = 0.5 * x2721 + x2723 * x81 + x2725 * x81
    x2727 = x1240 * x24 + x2726
    x2728 = x1831 * x23 + x2727
    x2729 = x1 * (x1766 + x2665 * x272 - x74 * (x11 * x2670 + x1768))
    x2730 = x2722 * x462 + 0.5 * x2729
    x2731 = x1244 * x24 + x2730
    x2732 = x1835 * x23 + x2731
    x2733 = x1 * (x1735 + x2664 * x272 - x74 * (x11 * x2663 + x1737))
    x2734 = x2724 * x88
    x2735 = x1780 + x2690 * x272
    x2736 = x1151 + x2553 + x2659 * x341 - x74 * (x1154 + x14 * x2669 + x2557)
    x2737 = x2736 * x85
    x2738 = x1161 + x2547 + x2673 * x341
    x2739 = x2738 * x3
    x2740 = x1167 + x2566 + x2678 * x341
    x2741 = x2739 + x2740 * x81
    x2742 = x2737 + x2739 * x81 + x2741 * x81
    x2743 = x1262 * x24 + x2742
    x2744 = x1852 * x23 + x2743
    x2745 = x1175 + x2577 + x2665 * x341 - x74 * (x1177 + x14 * x2670 + x2580)
    x2746 = x2745 * x85
    x2747 = x2738 * x462 + x2746
    x2748 = x1267 * x24 + x2747
    x2749 = x1857 * x23 + x2748
    x2750 = x1145 + x2586 + x2664 * x341 - x74 * (x1147 + x14 * x2663 + x2590)
    x2751 = x2750 * x85
    x2752 = x2740 * x88
    x2753 = x1189 + x2597 + x2690 * x341
    x2754 = x171 * x2613 + x1785 + x2692 * x272
    x2755 = x2754 * x3
    x2756 = x171 * x2616 + x1788 + x2694 * x272
    x2757 = x2755 + x2756 * x81
    x2758 = x1280 * x24 + x2757
    x2759 = x1871 * x23 + x2758
    x2760 = x2754 * x81
    x2761 = x1283 * x24 + x2760
    x2762 = x1875 * x23 + x2761
    x2763 = x2756 * x88
    x2764 = x171 * x2627 + x1801 + x2705 * x272
    x2765 = x1805 + x2642 + x2707 * x272
    x2766 = x2765 * x3
    x2767 = x1808 + x2645 + x2709 * x272
    x2768 = x2766 + x2767 * x81
    x2769 = x1294 * x24 + x2768
    x2770 = x1886 * x23 + x2769
    x2771 = x2765 * x81
    x2772 = x1297 * x24 + x2771
    x2773 = x1889 * x23 + x2772
    x2774 = x2767 * x88
    x2775 = x1821 + x2656 + x272 * x2720
    x2776 = x1824 + x2672 + x272 * x2722
    x2777 = x2776 * x3
    x2778 = x1758 * x272 + x2676 + x272 * x2724
    x2779 = x2777 + x2778 * x81
    x2780 = x1307 * x24 + x2779
    x2781 = x1900 * x23 + x2780
    x2782 = x2776 * x81
    x2783 = x1310 * x24 + x2782
    x2784 = x1903 * x23 + x2783
    x2785 = x2778 * x88
    x2786 = x1780 * x272 + x2688 + x272 * x2735
    x2787 = x1840 + x272 * x2738
    x2788 = x2787 * x3
    x2789 = x1843 + x272 * x2740
    x2790 = x2788 + x2789 * x81
    x2791 = x1320 * x24 + x2790
    x2792 = x1910 * x23 + x2791
    x2793 = x2787 * x81
    x2794 = x1323 * x24 + x2793
    x2795 = x1913 * x23 + x2794
    x2796 = x2789 * x88
    x2797 = x1860 + x272 * x2753
    x2798 = x1251 + x171 * x2671 + x2738 * x341
    x2799 = x2798 * x3
    x2800 = x1254 + x171 * x2675 + x2740 * x341
    x2801 = x2799 + x2800 * x81
    x2802 = x1334 * x24 + x2801
    x2803 = x1923 * x23 + x2802
    x2804 = x2798 * x81
    x2805 = x1337 * x24 + x2804
    x2806 = x1926 * x23 + x2805
    x2807 = x2800 * x88
    x2808 = x1271 + x171 * x2687 + x2753 * x341
    x2809 = x153 * x2691 + x1864 + x272 * x2756
    x2810 = x1343 * x24 + x2809
    x2811 = x1932 * x23 + x2810
    x2812 = x153 * x2699 + x1869 + x272 * x2754
    x2813 = x1346 * x24 + x2812
    x2814 = x1935 * x23 + x2813
    x2815 = x171 * x2706 + x1879 + x272 * x2767
    x2816 = x1350 * x24 + x2815
    x2817 = x1939 * x23 + x2816
    x2818 = x171 * x2714 + x1884 + x272 * x2765
    x2819 = x1353 * x24 + x2818
    x2820 = x1942 * x23 + x2819
    x2821 = x1893 + x272 * x2778 + x2721
    x2822 = x1357 * x24 + x2821
    x2823 = x1946 * x23 + x2822
    x2824 = x1898 + x272 * x2776 + x2729
    x2825 = x1360 * x24 + x2824
    x2826 = x1949 * x23 + x2825
    x2827 = x1843 * x272 + x272 * x2789 + x2737
    x2828 = x1364 * x24 + x2827
    x2829 = x1953 * x23 + x2828
    x2830 = x1908 + x272 * x2787 + x2746
    x2831 = x1367 * x24 + x2830
    x2832 = x1956 * x23 + x2831
    x2833 = x1915 + x272 * x2800
    x2834 = x1371 * x24 + x2833
    x2835 = x1960 * x23 + x2834
    x2836 = x1921 + x272 * x2798
    x2837 = x1374 * x24 + x2836
    x2838 = x1963 * x23 + x2837
    x2839 = x1327 + x153 * x2736 + x2800 * x341
    x2840 = x1378 * x24 + x2839
    x2841 = x1967 * x23 + x2840
    x2842 = x1333 + x153 * x2745 + x2798 * x341
    x2843 = x1381 * x24 + x2842
    x2844 = x1970 * x23 + x2843
    x2845 = x14 * x1404
    x2846 = x1383 * x1394 - x2845 + x63
    x2847 = x2846 * x74
    x2848 = x1395 * x14
    x2849 = x119 - x1383 * x1387 + x2848
    x2850 = x85 * (-x2847 - x2849)
    x2851 = x14 * x1430
    x2852 = x105 + x1383 * x1403 - x2851
    x2853 = x2850 + x2852 * x462
    x2854 = x2853 * x74
    x2855 = x1383 * x1387 - x2848 + x50
    x2856 = x2855 * x74
    x2857 = x1388 * x14
    x2858 = -x1383 * x1385 + x2857 + x83
    x2859 = x85 * (-x2856 - x2858)
    x2860 = x2846 * x462 + x2859
    x2861 = x2852 * x74
    x2862 = -x1383 * x1394 + x172 + x2845
    x2863 = x85 * (-x2861 - x2862)
    x2864 = x14 * x1452
    x2865 = x136 + x1383 * x1429 - x2864
    x2866 = x2863 + x2865 * x462
    x2867 = x1 * (x17 * x2846 * x5 * x8 - x2852 * x467) + x2866 * x81
    x2868 = x171 * (-x2854 + x2860) + x2867 * x81
    x2869 = x1383 * x1385 - x2857 + x35
    x2870 = x2869 * x3
    x2871 = x2855 * x3
    x2872 = x18 * x2846
    x2873 = -x2855 * x36 + x2872 * x8
    x2874 = -x2873
    x2875 = x2874 * x74
    x2876 = x2871 + x2875 * x8
    x2877 = x18 * x2855
    x2878 = -x2869 * x36 + x2877 * x8
    x2879 = -x2878
    x2880 = x2846 * x3
    x2881 = x18 * x2852
    x2882 = -x2846 * x36 + x2881 * x8
    x2883 = -x2882
    x2884 = x2883 * x74
    x2885 = x2880 + x2884 * x8
    x2886 = x2885 * x74
    x2887 = x85 * (-x2873 - x2884)
    x2888 = x2852 * x3
    x2889 = x18 * x2865
    x2890 = x2852 * x36 - x2889 * x8
    x2891 = x2890 * x74
    x2892 = x2888 + x2891 * x8
    x2893 = x2892 * x74
    x2894 = x2887 + x2888 * x81 + x2893 * x8
    x2895 = x2894 * x74
    x2896 = x85 * (-x2875 - x2878)
    x2897 = x2880 * x81 + x2886 * x8 + x2896
    x2898 = x85 * (-x2882 - x2891)
    x2899 = x2865 * x3
    x2900 = x1383 * x1451 - x14 * x1482 + x184
    x2901 = x18 * x2900
    x2902 = x2865 * x36 - x2901 * x8
    x2903 = x2899 + x2902 * x81
    x2904 = x2898 + x2899 * x81 + x2903 * x81
    x2905 = x1 * (x2885 - x2893) + x2866 * x3 + x2904 * x81
    x2906 = x171 * (-x2895 + x2897) + x2867 * x3 + x2905 * x81
    x2907 = (
        x153
        * (
            x1 * (x2870 - x2876 * x74 + x2879 * x81)
            + x2860 * x3
            + x2897 * x81
            - x74 * (x1 * (x2876 - x2886) + x2853 * x3 + x2895 * x8)
        )
        + x2868 * x3
        + x2906 * x81
    )
    x2908 = x1503 * x24 + x2907
    x2909 = x1504 * x24 + x2908
    x2910 = (
        x153
        * (
            x1 * (x17 * x2869 * x5 * x8 - x2855 * x467)
            + x2860 * x81
            - x74 * (x1 * (x17 * x2855 * x5 * x8 - x2846 * x467) + x2854 * x8)
        )
        + x2868 * x81
    )
    x2911 = x1506 * x24 + x2910
    x2912 = x1507 * x24 + x2911
    x2913 = x2879 * x3
    x2914 = x2874 * x3
    x2915 = -x2849 - x2872
    x2916 = x2915 * x4
    x2917 = x233 * x2883
    x2918 = x2874 * x36 + x2916 - x2917
    x2919 = x2918 * x74
    x2920 = 2.0 * x2914 + x2919 * x8
    x2921 = -x2858 - x2877
    x2922 = x2921 * x4
    x2923 = x233 * x2874
    x2924 = x2879 * x36 + x2922 - x2923
    x2925 = x2883 * x3
    x2926 = 2.0 * x2925
    x2927 = -x2862 - x2881
    x2928 = x2927 * x4
    x2929 = x233 * x2890
    x2930 = x2883 * x36 + x2928 - x2929
    x2931 = x2930 * x74
    x2932 = x2926 + x2931 * x8
    x2933 = x2932 * x74
    x2934 = -x2915 * x4
    x2935 = x85 * (x2874 * x36 - x2917 - x2931 - x2934)
    x2936 = x2890 * x3
    x2937 = 2.0 * x2936
    x2938 = x4 * (x1383 * x1403 - x253 - x2851 - x2889)
    x2939 = -x233 * x2902 + x2890 * x36 + x2938
    x2940 = x2939 * x74
    x2941 = x74 * (x2937 + x2940 * x8)
    x2942 = x74 * (x2892 * x88 + x2935 + x2941 * x8)
    x2943 = -x2921 * x4
    x2944 = x85 * (x2879 * x36 - x2919 - x2923 - x2943)
    x2945 = x2885 * x88 + x2933 * x8 + x2944
    x2946 = -x2927 * x4
    x2947 = x85 * (x2883 * x36 - x2929 - x2940 - x2946)
    x2948 = x2902 * x3
    x2949 = 2.0 * x2948
    x2950 = x4 * (x1383 * x1429 - x263 - x2864 - x2901)
    x2951 = x14 * x18
    x2952 = x1383 * x1481 - x1539 * x2951 + x264
    x2953 = -x233 * (-x233 * x2952 + x2900 * x36) + x2902 * x36 + x2950
    x2954 = x1 * (x11 * x17 * x2846 * x5 - x270 * x2852)
    x2955 = x2865 * x635 + 0.5 * x2954
    x2956 = x1 * (x11 * x267 * x268 * x2846 * x8 - x1568 * x2852) + x2955 * x81
    x2957 = x1 * (x11 * x17 * x2879 * x5 - x270 * x2874)
    x2958 = x270 * x2883
    x2959 = x1 * (x11 * x17 * x2874 * x5 - x2958)
    x2960 = x270 * x2890
    x2961 = x272 * x2888
    x2962 = x2960 * x8 + x2961
    x2963 = x2962 * x74
    x2964 = x272 * x2880
    x2965 = x2958 * x8 + x2964
    x2966 = x1 * (x11 * x17 * x2883 * x5 - x2960)
    x2967 = x272 * x2899
    x2968 = x280 * x2902 + x2967
    x2969 = x280 * x2899 + 0.5 * x2966 + x2968 * x81
    x2970 = x1 * (-x2963 + x2965) + x2955 * x3 + x2969 * x81
    x2971 = (
        x171
        * (
            x280 * x2880
            + 0.5 * x2957
            + x2965 * x81
            - x74 * (x280 * x2888 + 0.5 * x2959 + x2963 * x8)
        )
        + x2956 * x3
        + x2970 * x81
    )
    x2972 = x1572 * x24 + x2971
    x2973 = x1573 * x24 + x2972
    x2974 = x1 * (x11 * x17 * x2869 * x5 - x270 * x2855)
    x2975 = x1 * (x11 * x17 * x2855 * x5 - x270 * x2846)
    x2976 = (
        x171 * (x2846 * x635 + 0.5 * x2974 - x74 * (x2852 * x635 + 0.5 * x2975))
        + x2956 * x81
    )
    x2977 = x1577 * x24 + x2976
    x2978 = x1578 * x24 + x2977
    x2979 = x1 * (x11 * x17 * x2924 * x5 - x270 * x2918)
    x2980 = x270 * x2930
    x2981 = x1 * (x11 * x17 * x2918 * x5 - x2980)
    x2982 = x270 * x2939
    x2983 = x74 * (x272 * x2937 + x2982 * x8)
    x2984 = x272 * x2926 + x2980 * x8
    x2985 = x1 * (x11 * x17 * x2930 * x5 - x2982)
    x2986 = x14 * x2861 + 2.0 * x1440
    x2987 = x14 * x2847 + 2.0 * x1419
    x2988 = x2986 * x74
    x2989 = x1 * (x2987 - x2988)
    x2990 = 0.5 * x2989
    x2991 = 2.0 * x1471 + x2865 * x341
    x2992 = x2990 + x2991 * x462
    x2993 = x1 * (x17 * x2987 * x5 * x8 - x2986 * x467) + x2992 * x81
    x2994 = x1399 + x14 * x2875
    x2995 = x1 * (x1392 + x2879 * x341 - x2994 * x74)
    x2996 = 0.5 * x2995
    x2997 = x14 * x2884 + x1425
    x2998 = x2997 * x74
    x2999 = x1 * (x2994 - x2998)
    x3000 = 0.5 * x2999
    x3001 = x2986 * x3
    x3002 = x14 * x2891 + x1448
    x3003 = x3002 * x74
    x3004 = x3001 + x3003 * x8
    x3005 = x3004 * x74
    x3006 = x2987 * x3
    x3007 = x2998 * x8 + x3006
    x3008 = x1 * (x2997 - x3003)
    x3009 = 0.5 * x3008
    x3010 = x2991 * x3
    x3011 = x1479 + x2902 * x341
    x3012 = x3010 + x3011 * x81
    x3013 = x3009 + x3010 * x81 + x3012 * x81
    x3014 = x1 * (-x3005 + x3007) + x2992 * x3 + x3013 * x81
    x3015 = (
        x171
        * (x2996 + x3006 * x81 + x3007 * x81 - x74 * (x3000 + x3001 * x81 + x3005 * x8))
        + x2993 * x3
        + x3014 * x81
    )
    x3016 = x1641 * x24 + x3015
    x3017 = x1642 * x24 + x3016
    x3018 = x14 * x2856 + 2.0 * x1501
    x3019 = x1 * (2.0 * x1500 + x2869 * x341 - x3018 * x74)
    x3020 = 0.5 * x3019
    x3021 = x2987 * x74
    x3022 = x1 * (x3018 - x3021)
    x3023 = 0.5 * x3022
    x3024 = x171 * (x2987 * x462 + x3020 - x74 * (x2986 * x462 + x3023)) + x2993 * x81
    x3025 = x1650 * x24 + x3024
    x3026 = x1651 * x24 + x3025
    x3027 = x14 * x2919 + 2.0 * x1509
    x3028 = x1 * (2.0 * x1508 + x2924 * x341 - x3027 * x74)
    x3029 = 0.5 * x3028
    x3030 = x14 * x2931 + 2.0 * x1518
    x3031 = x3030 * x74
    x3032 = x1 * (x3027 - x3031)
    x3033 = 0.5 * x3032
    x3034 = x3 * x3002
    x3035 = 2.0 * x3034
    x3036 = x14 * x2940 + 2.0 * x1527
    x3037 = x3036 * x74
    x3038 = x74 * (x3035 + x3037 * x8)
    x3039 = x2997 * x3
    x3040 = 2.0 * x3039
    x3041 = x3031 * x8 + x3040
    x3042 = x1 * (x3030 - x3037)
    x3043 = 0.5 * x3042
    x3044 = x3 * x3011
    x3045 = 2.0 * x3044
    x3046 = 2.0 * x1536 + x2953 * x341
    x3047 = x2883 * x417 + x2896
    x3048 = x3 * x3047
    x3049 = x2887 + x2890 * x417
    x3050 = x3 * x3049
    x3051 = x74 * (x2935 + x2939 * x417)
    x3052 = x2930 * x417 + x2944
    x3053 = x2846 * x417 + x2859
    x3054 = x3 * x3053
    x3055 = x2850 + x2852 * x417
    x3056 = x3 * x3055
    x3057 = x3049 * x74
    x3058 = x3055 * x74
    x3059 = x3053 - x3058
    x3060 = x2863 + x2865 * x417
    x3061 = x3059 * x85 + x3060 * x462
    x3062 = x3047 - x3057
    x3063 = x3 * x3060
    x3064 = x2898 + x2902 * x417
    x3065 = x3063 + x3064 * x81
    x3066 = x3062 * x85 + x3063 * x81 + x3065 * x81
    x3067 = (
        x1 * (x3047 * x81 + x3054 - x74 * (x3056 + x3057 * x8)) + x3 * x3061 + x3066 * x81
    )
    x3068 = x1704 * x24 + x3067
    x3069 = x1705 * x24 + x3068
    x3070 = x1 * (x17 * x3053 * x5 * x8 - x3055 * x467) + x3061 * x81
    x3071 = x1707 * x24 + x3070
    x3072 = x1708 * x24 + x3071
    x3073 = -x3051 + x3052
    x3074 = x3 * x3064
    x3075 = x2947 + x2953 * x417
    x3076 = x270 * x3036
    x3077 = x270 * x3002
    x3078 = x272 * x3001
    x3079 = x272 * x3006
    x3080 = x1 * (x11 * x17 * x2987 * x5 - x270 * x2986)
    x3081 = x2991 * x635 + 0.5 * x3080
    x3082 = x1 * (x11 * x17 * x2997 * x5 - x3077)
    x3083 = x272 * x3010
    x3084 = x280 * x3011 + x3083
    x3085 = x280 * x3010 + 0.5 * x3082 + x3084 * x81
    x3086 = (
        x1 * (x280 * x2997 + x3079 - x74 * (x3077 * x8 + x3078))
        + x3 * x3081
        + x3085 * x81
    )
    x3087 = x1728 * x24 + x3086
    x3088 = x1729 * x24 + x3087
    x3089 = x1 * (x11 * x267 * x268 * x2987 * x8 - x1568 * x2986) + x3081 * x81
    x3090 = x1731 * x24 + x3089
    x3091 = x1732 * x24 + x3090
    x3092 = x1 * (x11 * x17 * x3030 * x5 - x3076)
    x3093 = x14 * x2998 + x1623 + x2896
    x3094 = x3 * x3093
    x3095 = x14 * x3003 + x1617 + x2887
    x3096 = x3 * x3095
    x3097 = x14 * x3037 + 2.0 * x1659 + x2935
    x3098 = x3097 * x74
    x3099 = x14 * x3031 + 2.0 * x1664 + x2944
    x3100 = x14 * x3021 + 2.0 * x1593 + x2859
    x3101 = x3 * x3100
    x3102 = x14 * x2988 + 2.0 * x1587 + x2850
    x3103 = x3 * x3102
    x3104 = x3095 * x74
    x3105 = x3102 * x74
    x3106 = x3100 - x3105
    x3107 = x3106 * x85
    x3108 = 2.0 * x1604 + x2863 + x2991 * x341
    x3109 = x3107 + x3108 * x462
    x3110 = x3093 - x3104
    x3111 = x3110 * x85
    x3112 = x3 * x3108
    x3113 = x1628 + x2898 + x3011 * x341
    x3114 = x3112 + x3113 * x81
    x3115 = x3111 + x3112 * x81 + x3114 * x81
    x3116 = (
        x1 * (x3093 * x81 + x3101 - x74 * (x3103 + x3104 * x8)) + x3 * x3109 + x3115 * x81
    )
    x3117 = x1773 * x24 + x3116
    x3118 = x1774 * x24 + x3117
    x3119 = x1 * (x17 * x3100 * x5 * x8 - x3102 * x467) + x3109 * x81
    x3120 = x1776 * x24 + x3119
    x3121 = x1777 * x24 + x3120
    x3122 = -x3098 + x3099
    x3123 = x3122 * x85
    x3124 = x3 * x3113
    x3125 = 2.0 * x3124
    x3126 = 2.0 * x1669 + x2947 + x3046 * x341
    x3127 = x272 * x3047 + x2957 - x74 * (x11 * x3057 + x2959)
    x3128 = x272 * x3060 + x2954
    x3129 = x3 * x3128
    x3130 = x272 * x3064 + x2966
    x3131 = x3129 + x3130 * x81
    x3132 = x3127 * x85 + x3129 * x81 + x3131 * x81
    x3133 = x1794 * x24 + x3132
    x3134 = x1795 * x24 + x3133
    x3135 = x272 * x3053 + x2974 - x74 * (x11 * x3058 + x2975)
    x3136 = x3128 * x462 + x3135 * x85
    x3137 = x1798 * x24 + x3136
    x3138 = x1799 * x24 + x3137
    x3139 = x272 * x3052 + x2979 - x74 * (x11 * x3051 + x2981)
    x3140 = x3 * x3130
    x3141 = x272 * x3075 + x2985
    x3142 = x2996 + x2997 * x417 - x74 * (x3000 + x3002 * x417)
    x3143 = x2990 + x2991 * x417
    x3144 = x3 * x3143
    x3145 = x3009 + x3011 * x417
    x3146 = x3144 + x3145 * x81
    x3147 = x3142 * x85 + x3144 * x81 + x3146 * x81
    x3148 = x1814 * x24 + x3147
    x3149 = x1815 * x24 + x3148
    x3150 = x2987 * x417 + x3020 - x74 * (x2986 * x417 + x3023)
    x3151 = x3143 * x462 + x3150 * x85
    x3152 = x1818 * x24 + x3151
    x3153 = x1819 * x24 + x3152
    x3154 = x3029 + x3030 * x417 - x74 * (x3033 + x3036 * x417)
    x3155 = x3 * x3145
    x3156 = x3043 + x3046 * x417
    x3157 = x1 * (x11 * x17 * x3093 * x5 - x270 * x3095)
    x3158 = x272 * x3112
    x3159 = x280 * x3113 + x3158
    x3160 = x280 * x3112 + 0.5 * x3157 + x3159 * x81
    x3161 = x1830 * x24 + x3160
    x3162 = x1831 * x24 + x3161
    x3163 = x1 * (x11 * x17 * x3100 * x5 - x270 * x3102)
    x3164 = x3108 * x635 + 0.5 * x3163
    x3165 = x1834 * x24 + x3164
    x3166 = x1835 * x24 + x3165
    x3167 = x1 * (x11 * x17 * x3099 * x5 - x270 * x3097)
    x3168 = x1743 + x2995 + x3093 * x341 - x74 * (x14 * x3104 + x1746 + x2999)
    x3169 = x3168 * x85
    x3170 = 2.0 * x1752 + x2989 + x3108 * x341
    x3171 = x3 * x3170
    x3172 = x1759 + x3008 + x3113 * x341
    x3173 = x3171 + x3172 * x81
    x3174 = x3169 + x3171 * x81 + x3173 * x81
    x3175 = x1851 * x24 + x3174
    x3176 = x1852 * x24 + x3175
    x3177 = 2.0 * x1766 + x3019 + x3100 * x341 - x74 * (x14 * x3105 + 2.0 * x1768 + x3022)
    x3178 = x3177 * x85
    x3179 = x3170 * x462 + x3178
    x3180 = x1856 * x24 + x3179
    x3181 = x1857 * x24 + x3180
    x3182 = 2.0 * x1735 + x3028 + x3099 * x341 - x74 * (x14 * x3098 + 2.0 * x1737 + x3032)
    x3183 = x3182 * x85
    x3184 = x3 * x3172
    x3185 = 2.0 * x3184
    x3186 = 2.0 * x1780 + x3042 + x3126 * x341
    x3187 = x171 * x3059 + x272 * x3128
    x3188 = x3 * x3187
    x3189 = x171 * x3062 + x272 * x3130
    x3190 = x3188 + x3189 * x81
    x3191 = x1870 * x24 + x3190
    x3192 = x1871 * x24 + x3191
    x3193 = x3187 * x81
    x3194 = x1873 * x24 + x3193
    x3195 = x1875 * x24 + x3194
    x3196 = x3 * x3189
    x3197 = x171 * x3073 + x272 * x3141
    x3198 = x272 * x3143 + x3080
    x3199 = x3 * x3198
    x3200 = x272 * x3145 + x3082
    x3201 = x3199 + x3200 * x81
    x3202 = x1885 * x24 + x3201
    x3203 = x1886 * x24 + x3202
    x3204 = x3198 * x81
    x3205 = x1888 * x24 + x3204
    x3206 = x1889 * x24 + x3205
    x3207 = x3 * x3200
    x3208 = x272 * x3156 + x3092
    x3209 = x3107 + x3108 * x417
    x3210 = x3 * x3209
    x3211 = x3111 + x3113 * x417
    x3212 = x3210 + x3211 * x81
    x3213 = x1899 * x24 + x3212
    x3214 = x1900 * x24 + x3213
    x3215 = x3209 * x81
    x3216 = x1902 * x24 + x3215
    x3217 = x1903 * x24 + x3216
    x3218 = x3 * x3211
    x3219 = x3123 + x3126 * x417
    x3220 = x272 * x3171
    x3221 = x280 * x3172 + x3220
    x3222 = x1909 * x24 + x3221
    x3223 = x1910 * x24 + x3222
    x3224 = x280 * x3170
    x3225 = x1912 * x24 + x3224
    x3226 = x1913 * x24 + x3225
    x3227 = x171 * x3106 + 2.0 * x1840 + x3170 * x341
    x3228 = x3 * x3227
    x3229 = x171 * x3110 + x1844 + x3172 * x341
    x3230 = x3228 + x3229 * x81
    x3231 = x1922 * x24 + x3230
    x3232 = x1923 * x24 + x3231
    x3233 = x3227 * x81
    x3234 = x1925 * x24 + x3233
    x3235 = x1926 * x24 + x3234
    x3236 = x3 * x3229
    x3237 = x171 * x3122 + 2.0 * x1860 + x3186 * x341
    x3238 = x153 * x3127 + x272 * x3189
    x3239 = x1931 * x24 + x3238
    x3240 = x1932 * x24 + x3239
    x3241 = x153 * x3135 + x272 * x3187
    x3242 = x1934 * x24 + x3241
    x3243 = x1935 * x24 + x3242
    x3244 = x171 * x3142 + x272 * x3200
    x3245 = x1938 * x24 + x3244
    x3246 = x1939 * x24 + x3245
    x3247 = x171 * x3150 + x272 * x3198
    x3248 = x1941 * x24 + x3247
    x3249 = x1942 * x24 + x3248
    x3250 = x272 * x3211 + x3157
    x3251 = x1945 * x24 + x3250
    x3252 = x1946 * x24 + x3251
    x3253 = x272 * x3209 + x3163
    x3254 = x1948 * x24 + x3253
    x3255 = x1949 * x24 + x3254
    x3256 = x3169 + x3172 * x417
    x3257 = x1952 * x24 + x3256
    x3258 = x1953 * x24 + x3257
    x3259 = x3170 * x417 + x3178
    x3260 = x1955 * x24 + x3259
    x3261 = x1956 * x24 + x3260
    x3262 = x272 * x3229
    x3263 = x1959 * x24 + x3262
    x3264 = x1960 * x24 + x3263
    x3265 = x272 * x3227
    x3266 = x1962 * x24 + x3265
    x3267 = x1963 * x24 + x3266
    x3268 = x153 * x3168 + x1916 + x3229 * x341
    x3269 = x1966 * x24 + x3268
    x3270 = x1967 * x24 + x3269
    x3271 = x153 * x3177 + 2.0 * x1921 + x3227 * x341
    x3272 = x1969 * x24 + x3271
    x3273 = x1970 * x24 + x3272
    x3274 = x11 * x2007
    x3275 = x1972 * x781 - x3274 + 2.0 * x825
    x3276 = x3275 * x74
    x3277 = x11 * x1998
    x3278 = x85 * (x1981 * x781 - x3276 - x3277 + 2.0 * x4 * x798)
    x3279 = -x11 * x2015 + x1978 * x781 + 2.0 * x846
    x3280 = x3278 + x3279 * x462
    x3281 = x3280 * x74
    x3282 = x1981 * x781 - x3277 + 2.0 * x799
    x3283 = x3282 * x74
    x3284 = x11 * x2003
    x3285 = x85 * (x1995 * x781 - x3283 - x3284 + 2.0 * x4 * x810)
    x3286 = x3275 * x462 + x3285
    x3287 = x3279 * x74
    x3288 = x85 * (x1972 * x781 - x3274 - x3287 + 2.0 * x4 * x824)
    x3289 = -x11 * x2027 + x1991 * x781 + 2.0 * x875
    x3290 = x3288 + x3289 * x462
    x3291 = x1 * (x17 * x3275 * x5 * x8 - x3279 * x467) + x3290 * x81
    x3292 = x171 * (-x3281 + x3286) + x3291 * x81
    x3293 = x1995 * x781 - x3284 + 2.0 * x811
    x3294 = (
        x153
        * (
            x1 * (x17 * x3293 * x5 * x8 - x3282 * x467)
            + x3286 * x81
            - x74 * (x1 * (x17 * x3282 * x5 * x8 - x3275 * x467) + x3281 * x8)
        )
        + x3292 * x81
    )
    x3295 = x2036 * x23 + x3294
    x3296 = x2037 * x23 + x3295
    x3297 = x2038 * x23 + x3296
    x3298 = x3 * x3293
    x3299 = x3 * x3282
    x3300 = x233 * x3275 - x3282 * x36
    x3301 = -x3300
    x3302 = x3301 * x74
    x3303 = x3299 + x3302 * x8
    x3304 = x233 * x3282 - x3293 * x36
    x3305 = -x3304
    x3306 = x3 * x3275
    x3307 = x233 * x3279 - x3275 * x36
    x3308 = -x3307
    x3309 = x3308 * x74
    x3310 = x3306 + x3309 * x8
    x3311 = x3310 * x74
    x3312 = x85 * (-x3300 - x3309)
    x3313 = x3 * x3279
    x3314 = -x233 * x3289 + x3279 * x36
    x3315 = x3314 * x74
    x3316 = x74 * (x3313 + x3315 * x8)
    x3317 = x74 * (x3312 + x3313 * x81 + x3316 * x8)
    x3318 = x85 * (-x3302 - x3304)
    x3319 = x3306 * x81 + x3311 * x8 + x3318
    x3320 = x85 * (-x3307 - x3315)
    x3321 = x3 * x3289
    x3322 = x2026 * x781 - x2074 * x2075 + 2.0 * x933
    x3323 = -x233 * x3322 + x3289 * x36
    x3324 = 3.0 * x2014
    x3325 = x11 * x3287 + x3324
    x3326 = 3.0 * x2006
    x3327 = x11 * x3276 + x3326
    x3328 = x3325 * x74
    x3329 = x1 * (x3327 - x3328)
    x3330 = 3.0 * x2025
    x3331 = x272 * x3289 + x3330
    x3332 = 0.5 * x3329 + x3331 * x462
    x3333 = x1 * (x17 * x3327 * x5 * x8 - x3325 * x467) + x3332 * x81
    x3334 = x11 * x3283 + 3.0 * x1997
    x3335 = x1 * (3.0 * x1996 + x272 * x3293 - x3334 * x74)
    x3336 = x3327 * x74
    x3337 = x1 * (x3334 - x3336)
    x3338 = (
        x171 * (x3327 * x462 + 0.5 * x3335 - x74 * (x3325 * x462 + 0.5 * x3337))
        + x3333 * x81
    )
    x3339 = x2112 * x23 + x3338
    x3340 = x2113 * x23 + x3339
    x3341 = x2114 * x23 + x3340
    x3342 = x11 * x3302 + 3.0 * x2040
    x3343 = x1 * (3.0 * x2039 + x272 * x3305 - x3342 * x74)
    x3344 = 3.0 * x2051
    x3345 = x11 * x3309 + x3344
    x3346 = x3345 * x74
    x3347 = x1 * (x3342 - x3346)
    x3348 = x3 * x3325
    x3349 = 3.0 * x2061
    x3350 = x74 * (x11 * x3315 + x3349)
    x3351 = x74 * (x3348 + x3350 * x8)
    x3352 = x3 * x3327
    x3353 = x3346 * x8 + x3352
    x3354 = x1 * (x3345 - x3350)
    x3355 = x3 * x3331
    x3356 = 3.0 * x2071
    x3357 = x272 * x3323 + x3356
    x3358 = x1 * (x14 * x17 * x3275 * x5 - x3279 * x339)
    x3359 = 0.5 * x3358
    x3360 = x1009 * x3289 + x3359
    x3361 = x1 * (-x1036 * x3279 + x14 * x267 * x268 * x3275 * x8) + x3360 * x81
    x3362 = x1 * (x14 * x17 * x3293 * x5 - x3282 * x339)
    x3363 = 0.5 * x3362
    x3364 = x1 * (x14 * x17 * x3282 * x5 - x3275 * x339)
    x3365 = 0.5 * x3364
    x3366 = x171 * (x1009 * x3275 + x3363 - x74 * (x1009 * x3279 + x3365)) + x3361 * x81
    x3367 = x2156 * x23 + x3366
    x3368 = x2157 * x23 + x3367
    x3369 = x2158 * x23 + x3368
    x3370 = x1 * (x14 * x17 * x3305 * x5 - x3301 * x339)
    x3371 = 0.5 * x3370
    x3372 = x3308 * x339
    x3373 = x1 * (x14 * x17 * x3301 * x5 - x3372)
    x3374 = 0.5 * x3373
    x3375 = x3314 * x339
    x3376 = x3313 * x341
    x3377 = x74 * (x3375 * x8 + x3376)
    x3378 = x3306 * x341
    x3379 = x3372 * x8 + x3378
    x3380 = x1 * (x14 * x17 * x3308 * x5 - x3375)
    x3381 = 0.5 * x3380
    x3382 = x3321 * x341
    x3383 = x11 * x3336 + 3.0 * x2097 + x3285
    x3384 = x3 * x3383
    x3385 = x11 * x3328 + 3.0 * x2092 + x3278
    x3386 = x3 * x3385
    x3387 = x74 * (x100 * x2093 + x11 * x3350 + x3312)
    x3388 = x100 * x2089 + x11 * x3346 + x3318
    x3389 = x3385 * x74
    x3390 = x3383 - x3389
    x3391 = 3.0 * x2100 + x272 * x3331 + x3288
    x3392 = x3390 * x85 + x3391 * x462
    x3393 = x1 * (x17 * x3383 * x5 * x8 - x3385 * x467) + x3392 * x81
    x3394 = x2190 * x23 + x3393
    x3395 = x2191 * x23 + x3394
    x3396 = x2192 * x23 + x3395
    x3397 = -x3387 + x3388
    x3398 = x3 * x3391
    x3399 = x100 * x2101 + x272 * x3357 + x3320
    x3400 = x3275 * x477 + x3326 * x341
    x3401 = x3 * x3400
    x3402 = x3279 * x477 + x3324 * x341
    x3403 = x3 * x3402
    x3404 = x74 * (x3314 * x477 + x3349 * x341)
    x3405 = x3308 * x477 + x3344 * x341
    x3406 = x3402 * x74
    x3407 = x1 * (x3400 - x3406)
    x3408 = x3289 * x477 + x3330 * x341
    x3409 = 0.5 * x3407 + x3408 * x462
    x3410 = x1 * (x17 * x3400 * x5 * x8 - x3402 * x467) + x3409 * x81
    x3411 = x2216 * x23 + x3410
    x3412 = x2217 * x23 + x3411
    x3413 = x2218 * x23 + x3412
    x3414 = x1 * (-x3404 + x3405)
    x3415 = x3 * x3408
    x3416 = x3323 * x477 + x3356 * x341
    x3417 = x3275 * x508 + x3285
    x3418 = x3 * x3417
    x3419 = x3278 + x3279 * x508
    x3420 = x3 * x3419
    x3421 = x74 * (x3312 + x3314 * x508)
    x3422 = x3308 * x508 + x3318
    x3423 = x3419 * x74
    x3424 = x3417 - x3423
    x3425 = x3424 * x85
    x3426 = x3288 + x3289 * x508
    x3427 = x3425 + x3426 * x462
    x3428 = x1 * (x17 * x3417 * x5 * x8 - x3419 * x467) + x3427 * x81
    x3429 = x2246 * x23 + x3428
    x3430 = x2247 * x23 + x3429
    x3431 = x2248 * x23 + x3430
    x3432 = -x3421 + x3422
    x3433 = x3432 * x85
    x3434 = x3 * x3426
    x3435 = x3320 + x3323 * x508
    x3436 = 3.0 * x2174 + x272 * x3383 + x3335 - x74 * (x11 * x3389 + 3.0 * x2176 + x3337)
    x3437 = 3.0 * x2183 + x272 * x3391 + x3329
    x3438 = x3436 * x85 + x3437 * x462
    x3439 = x2262 * x23 + x3438
    x3440 = x2263 * x23 + x3439
    x3441 = x2264 * x23 + x3440
    x3442 = (
        x100 * x2169 + x272 * x3388 + x3343 - x74 * (x100 * x2170 + x11 * x3387 + x3347)
    )
    x3443 = x3 * x3437
    x3444 = x100 * x2184 + x272 * x3399 + x3354
    x3445 = 3.0 * x2200 + x272 * x3400 + x3363 - x74 * (x11 * x3406 + 3.0 * x2202 + x3365)
    x3446 = 3.0 * x2209 + x272 * x3408 + x3359
    x3447 = x3445 * x85 + x3446 * x462
    x3448 = x2276 * x23 + x3447
    x3449 = x2277 * x23 + x3448
    x3450 = x2278 * x23 + x3449
    x3451 = (
        x100 * x2195 + x272 * x3405 + x3371 - x74 * (x100 * x2196 + x11 * x3404 + x3374)
    )
    x3452 = x3 * x3446
    x3453 = x100 * x2210 + x272 * x3416 + x3381
    x3454 = x1 * (3.0 * x2228 + x272 * x3417 - x74 * (x11 * x3423 + 3.0 * x2230))
    x3455 = 3.0 * x2239 + x272 * x3426
    x3456 = 0.5 * x3454 + x3455 * x462
    x3457 = x2290 * x23 + x3456
    x3458 = x2291 * x23 + x3457
    x3459 = x2292 * x23 + x3458
    x3460 = x1 * (3.0 * x2222 + x272 * x3422 - x74 * (x11 * x3421 + 3.0 * x2224))
    x3461 = x3 * x3455
    x3462 = 3.0 * x2251 + x272 * x3435
    x3463 = x3362 + x341 * x3417 - x74 * (x14 * x3423 + x3364)
    x3464 = x3463 * x85
    x3465 = x3358 + x341 * x3426
    x3466 = x3464 + x3465 * x462
    x3467 = x23 * x2306 + x3466
    x3468 = x23 * x2307 + x3467
    x3469 = x23 * x2308 + x3468
    x3470 = x3370 + x341 * x3422 - x74 * (x14 * x3421 + x3373)
    x3471 = x3470 * x85
    x3472 = x3 * x3465
    x3473 = x3380 + x341 * x3435
    x3474 = x171 * x3390 + 3.0 * x2255 + x272 * x3437
    x3475 = x3 * x3474
    x3476 = x3474 * x81
    x3477 = x23 * x2319 + x3476
    x3478 = x23 * x2320 + x3477
    x3479 = x23 * x2321 + x3478
    x3480 = x100 * x2256 + x171 * x3397 + x272 * x3444
    x3481 = 3.0 * x2269 + x272 * x3446 + x3407
    x3482 = x3 * x3481
    x3483 = x3481 * x81
    x3484 = x23 * x2329 + x3483
    x3485 = x23 * x2330 + x3484
    x3486 = x23 * x2331 + x3485
    x3487 = x100 * x2270 + x272 * x3453 + x3414
    x3488 = 3.0 * x2283 + x272 * x3455 + x3425
    x3489 = x3 * x3488
    x3490 = x3488 * x81
    x3491 = x23 * x2339 + x3490
    x3492 = x23 * x2340 + x3491
    x3493 = x23 * x2341 + x3492
    x3494 = x100 * x2284 + x272 * x3462 + x3433
    x3495 = 3.0 * x2298 + x272 * x3465
    x3496 = x3 * x3495
    x3497 = x3495 * x81
    x3498 = x23 * x2349 + x3497
    x3499 = x23 * x2350 + x3498
    x3500 = x23 * x2351 + x3499
    x3501 = 3.0 * x2311 + x272 * x3473
    x3502 = x171 * x3424 + x341 * x3465
    x3503 = x3 * x3502
    x3504 = x3502 * x81
    x3505 = x23 * x2359 + x3504
    x3506 = x23 * x2360 + x3505
    x3507 = x23 * x2361 + x3506
    x3508 = x171 * x3432 + x341 * x3473
    x3509 = x153 * x3436 + 3.0 * x2314 + x272 * x3474
    x3510 = x23 * x2367 + x3509
    x3511 = x23 * x2368 + x3510
    x3512 = x23 * x2369 + x3511
    x3513 = x171 * x3445 + 3.0 * x2324 + x272 * x3481
    x3514 = x23 * x2373 + x3513
    x3515 = x23 * x2374 + x3514
    x3516 = x23 * x2375 + x3515
    x3517 = 3.0 * x2334 + x272 * x3488 + x3454
    x3518 = x23 * x2379 + x3517
    x3519 = x23 * x2380 + x3518
    x3520 = x23 * x2381 + x3519
    x3521 = 3.0 * x2344 + x272 * x3495 + x3464
    x3522 = x23 * x2385 + x3521
    x3523 = x23 * x2386 + x3522
    x3524 = x23 * x2387 + x3523
    x3525 = 3.0 * x2354 + x272 * x3502
    x3526 = x23 * x2391 + x3525
    x3527 = x23 * x2392 + x3526
    x3528 = x23 * x2393 + x3527
    x3529 = x153 * x3463 + x341 * x3502
    x3530 = x23 * x2397 + x3529
    x3531 = x23 * x2398 + x3530
    x3532 = x23 * x2399 + x3531
    x3533 = x11 * x2433
    x3534 = x1427 + x2401 * x781 - x3533
    x3535 = x3534 * x74
    x3536 = x11 * x2424
    x3537 = x85 * (-x1445 + x2409 * x781 - x3535 - x3536)
    x3538 = -x11 * x2441 + x1449 + x2406 * x781
    x3539 = x3537 + x3538 * x462
    x3540 = x3539 * x74
    x3541 = x1401 + x2409 * x781 - x3536
    x3542 = x3541 * x74
    x3543 = x11 * x2429
    x3544 = x85 * (-x1462 + x2421 * x781 - x3542 - x3543)
    x3545 = x3534 * x462 + x3544
    x3546 = x3538 * x74
    x3547 = x85 * (-x1476 + x2401 * x781 - x3533 - x3546)
    x3548 = -x11 * x2453 + x1480 + x2417 * x781
    x3549 = x3547 + x3548 * x462
    x3550 = x1 * (x17 * x3534 * x5 * x8 - x3538 * x467) + x3549 * x81
    x3551 = x171 * (-x3540 + x3545) + x3550 * x81
    x3552 = x1413 + x2421 * x781 - x3543
    x3553 = (
        x153
        * (
            x1 * (x17 * x3552 * x5 * x8 - x3541 * x467)
            + x3545 * x81
            - x74 * (x1 * (x17 * x3541 * x5 * x8 - x3534 * x467) + x3540 * x8)
        )
        + x3551 * x81
    )
    x3554 = x2036 * x24 + x3553
    x3555 = x23 * x2463 + x3554
    x3556 = x23 * x2464 + x3555
    x3557 = x3 * x3552
    x3558 = x3 * x3541
    x3559 = x233 * x3534 - x3541 * x36
    x3560 = -x3559 * x74
    x3561 = x3558 + x3560 * x8
    x3562 = x233 * x3541 - x3552 * x36
    x3563 = -x3562
    x3564 = x3 * x3534
    x3565 = x233 * x3538 - x3534 * x36
    x3566 = -x3565 * x74
    x3567 = x3564 + x3566 * x8
    x3568 = x3567 * x74
    x3569 = x85 * (-x3559 - x3566)
    x3570 = x3 * x3538
    x3571 = x74 * (-x233 * x3548 + x3538 * x36)
    x3572 = x74 * (x3570 + x3571 * x8)
    x3573 = x74 * (x3569 + x3570 * x81 + x3572 * x8)
    x3574 = x85 * (-x3560 - x3562)
    x3575 = x3564 * x81 + x3568 * x8 + x3574
    x3576 = x85 * (-x3565 - x3571)
    x3577 = x3 * x3548
    x3578 = x1538 - x2074 * x2494 + x2452 * x781
    x3579 = -x233 * x3578 + x3548 * x36
    x3580 = 2.0 * x2440
    x3581 = x11 * x3546 + x3580
    x3582 = 2.0 * x2432
    x3583 = x11 * x3535 + x3582
    x3584 = x3581 * x74
    x3585 = x1 * (x3583 - x3584)
    x3586 = 2.0 * x2451
    x3587 = x272 * x3548 + x3586
    x3588 = 0.5 * x3585 + x3587 * x462
    x3589 = x1 * (x17 * x3583 * x5 * x8 - x3581 * x467) + x3588 * x81
    x3590 = 2.0 * x2422
    x3591 = 2.0 * x2423
    x3592 = x11 * x3542 + x3591
    x3593 = x1 * (x272 * x3552 + x3590 - x3592 * x74)
    x3594 = x3583 * x74
    x3595 = x1 * (x3592 - x3594)
    x3596 = (
        x171 * (x3583 * x462 + 0.5 * x3593 - x74 * (x3581 * x462 + 0.5 * x3595))
        + x3589 * x81
    )
    x3597 = x2112 * x24 + x3596
    x3598 = x23 * x2529 + x3597
    x3599 = x23 * x2530 + x3598
    x3600 = x11 * x3560 + x2466
    x3601 = x1 * (x2465 + x272 * x3563 - x3600 * x74)
    x3602 = x11 * x3566 + x2476
    x3603 = x3602 * x74
    x3604 = x1 * (x3600 - x3603)
    x3605 = x3 * x3581
    x3606 = x74 * (x11 * x3571 + x2484)
    x3607 = x74 * (x3605 + x3606 * x8)
    x3608 = x3 * x3583
    x3609 = x3603 * x8 + x3608
    x3610 = x1 * (x3602 - x3606)
    x3611 = x3 * x3587
    x3612 = x2492 + x272 * x3579
    x3613 = x14 * x3546 + x2014
    x3614 = x14 * x3535 + x2006
    x3615 = x3613 * x74
    x3616 = x1 * (x3614 - x3615)
    x3617 = 0.5 * x3616
    x3618 = x2025 + x341 * x3548
    x3619 = x3617 + x3618 * x462
    x3620 = x1 * (x17 * x3614 * x5 * x8 - x3613 * x467) + x3619 * x81
    x3621 = x14 * x3542 + x1997
    x3622 = x1 * (x1996 + x341 * x3552 - x3621 * x74)
    x3623 = 0.5 * x3622
    x3624 = x3614 * x74
    x3625 = x1 * (x3621 - x3624)
    x3626 = 0.5 * x3625
    x3627 = x171 * (x3614 * x462 + x3623 - x74 * (x3613 * x462 + x3626)) + x3620 * x81
    x3628 = x2156 * x24 + x3627
    x3629 = x23 * x2583 + x3628
    x3630 = x23 * x2584 + x3629
    x3631 = x14 * x3560 + x2040
    x3632 = x1 * (x2039 + x341 * x3563 - x3631 * x74)
    x3633 = 0.5 * x3632
    x3634 = x14 * x3566 + x2051
    x3635 = x3634 * x74
    x3636 = x1 * (x3631 - x3635)
    x3637 = 0.5 * x3636
    x3638 = x3 * x3613
    x3639 = x74 * (x14 * x3571 + x2061)
    x3640 = x74 * (x3638 + x3639 * x8)
    x3641 = x3 * x3614
    x3642 = x3635 * x8 + x3641
    x3643 = x1 * (x3634 - x3639)
    x3644 = 0.5 * x3643
    x3645 = x3 * x3618
    x3646 = x2071 + x341 * x3579
    x3647 = x11 * x3594 + 2.0 * x2513 + x3544
    x3648 = x3 * x3647
    x3649 = x11 * x3584 + 2.0 * x2508 + x3537
    x3650 = x3 * x3649
    x3651 = x74 * (x11 * x3606 + x2536 + x3569)
    x3652 = x11 * x3603 + x2539 + x3574
    x3653 = x3649 * x74
    x3654 = x3647 - x3653
    x3655 = 2.0 * x2516 + x272 * x3587 + x3547
    x3656 = x3654 * x85 + x3655 * x462
    x3657 = x1 * (x17 * x3647 * x5 * x8 - x3649 * x467) + x3656 * x81
    x3658 = x2190 * x24 + x3657
    x3659 = x23 * x2625 + x3658
    x3660 = x23 * x2626 + x3659
    x3661 = -x3651 + x3652
    x3662 = x3 * x3655
    x3663 = x2542 + x272 * x3612 + x3576
    x3664 = 2.0 * x2564
    x3665 = x11 * x3624 + x3664
    x3666 = x3 * x3665
    x3667 = 2.0 * x2559
    x3668 = x11 * x3615 + x3667
    x3669 = x3 * x3668
    x3670 = x74 * (x11 * x3639 + x2592)
    x3671 = x11 * x3635 + x2595
    x3672 = x3668 * x74
    x3673 = x1 * (x3665 - x3672)
    x3674 = 2.0 * x2568
    x3675 = x272 * x3618 + x3674
    x3676 = 0.5 * x3673 + x3675 * x462
    x3677 = x1 * (x17 * x3665 * x5 * x8 - x3668 * x467) + x3676 * x81
    x3678 = x2216 * x24 + x3677
    x3679 = x23 * x2654 + x3678
    x3680 = x23 * x2655 + x3679
    x3681 = x1 * (-x3670 + x3671)
    x3682 = x3 * x3675
    x3683 = x2599 + x272 * x3646
    x3684 = x14 * x3624 + x2141 + x3544
    x3685 = x3 * x3684
    x3686 = x14 * x3615 + x2138 + x3537
    x3687 = x3 * x3686
    x3688 = x74 * (x14 * x3639 + x2061 * x341 + x3569)
    x3689 = x14 * x3635 + x2051 * x341 + x3574
    x3690 = x3686 * x74
    x3691 = x3684 - x3690
    x3692 = x3691 * x85
    x3693 = x2145 + x341 * x3618 + x3547
    x3694 = x3692 + x3693 * x462
    x3695 = x1 * (x17 * x3684 * x5 * x8 - x3686 * x467) + x3694 * x81
    x3696 = x2246 * x24 + x3695
    x3697 = x23 * x2685 + x3696
    x3698 = x23 * x2686 + x3697
    x3699 = -x3688 + x3689
    x3700 = x3699 * x85
    x3701 = x3 * x3693
    x3702 = x2071 * x341 + x341 * x3646 + x3576
    x3703 = 2.0 * x2608 + x272 * x3647 + x3593 - x74 * (x11 * x3653 + 2.0 * x2610 + x3595)
    x3704 = 2.0 * x2617 + x272 * x3655 + x3585
    x3705 = x3703 * x85 + x3704 * x462
    x3706 = x2262 * x24 + x3705
    x3707 = x23 * x2701 + x3706
    x3708 = x23 * x2702 + x3707
    x3709 = x2602 + x272 * x3652 + x3601 - x74 * (x11 * x3651 + x2604 + x3604)
    x3710 = x3 * x3704
    x3711 = x2628 + x272 * x3663 + x3610
    x3712 = 2.0 * x2637 + x272 * x3665 + x3623 - x74 * (x11 * x3672 + 2.0 * x2639 + x3626)
    x3713 = 2.0 * x2646 + x272 * x3675 + x3617
    x3714 = x3712 * x85 + x3713 * x462
    x3715 = x2276 * x24 + x3714
    x3716 = x23 * x2716 + x3715
    x3717 = x23 * x2717 + x3716
    x3718 = x2631 + x272 * x3671 + x3633 - x74 * (x11 * x3670 + x2633 + x3637)
    x3719 = x3 * x3713
    x3720 = x2657 + x272 * x3683 + x3644
    x3721 = 2.0 * x2666
    x3722 = 2.0 * x2668
    x3723 = x1 * (x272 * x3684 + x3721 - x74 * (x11 * x3690 + x3722))
    x3724 = 2.0 * x2677
    x3725 = x272 * x3693 + x3724
    x3726 = 0.5 * x3723 + x3725 * x462
    x3727 = x2290 * x24 + x3726
    x3728 = x23 * x2731 + x3727
    x3729 = x23 * x2732 + x3728
    x3730 = x1 * (x2660 + x272 * x3689 - x74 * (x11 * x3688 + x2662))
    x3731 = x3 * x3725
    x3732 = x2689 + x272 * x3702
    x3733 = x2228 + x341 * x3684 + x3622 - x74 * (x14 * x3690 + x2230 + x3625)
    x3734 = x3733 * x85
    x3735 = x2239 + x341 * x3693 + x3616
    x3736 = x3734 + x3735 * x462
    x3737 = x2306 * x24 + x3736
    x3738 = x23 * x2748 + x3737
    x3739 = x23 * x2749 + x3738
    x3740 = x2222 + x341 * x3689 + x3632 - x74 * (x14 * x3688 + x2224 + x3636)
    x3741 = x3740 * x85
    x3742 = x3 * x3735
    x3743 = x2251 + x341 * x3702 + x3643
    x3744 = x171 * x3654 + 2.0 * x2693 + x272 * x3704
    x3745 = x3 * x3744
    x3746 = x3744 * x81
    x3747 = x2319 * x24 + x3746
    x3748 = x23 * x2761 + x3747
    x3749 = x23 * x2762 + x3748
    x3750 = x171 * x3661 + x2704 + x272 * x3711
    x3751 = 2.0 * x2708 + x272 * x3713 + x3673
    x3752 = x3 * x3751
    x3753 = x3751 * x81
    x3754 = x2329 * x24 + x3753
    x3755 = x23 * x2772 + x3754
    x3756 = x23 * x2773 + x3755
    x3757 = x2719 + x272 * x3720 + x3681
    x3758 = x272 * x3725 + 2.0 * x2723 + x3692
    x3759 = x3 * x3758
    x3760 = x3758 * x81
    x3761 = x2339 * x24 + x3760
    x3762 = x23 * x2783 + x3761
    x3763 = x23 * x2784 + x3762
    x3764 = x272 * x3732 + x2734 + x3700
    x3765 = 2.0 * x2739
    x3766 = x272 * x3735 + x3765
    x3767 = x3 * x3766
    x3768 = x3766 * x81
    x3769 = x2349 * x24 + x3768
    x3770 = x23 * x2794 + x3769
    x3771 = x23 * x2795 + x3770
    x3772 = x272 * x3743 + x2752
    x3773 = x171 * x3691 + x2298 + x341 * x3735
    x3774 = x3 * x3773
    x3775 = x3773 * x81
    x3776 = x2359 * x24 + x3775
    x3777 = x23 * x2805 + x3776
    x3778 = x23 * x2806 + x3777
    x3779 = x171 * x3699 + x2311 + x341 * x3743
    x3780 = x153 * x3703 + x272 * x3744 + 2.0 * x2755
    x3781 = x2367 * x24 + x3780
    x3782 = x23 * x2813 + x3781
    x3783 = x23 * x2814 + x3782
    x3784 = x171 * x3712 + x272 * x3751 + 2.0 * x2766
    x3785 = x2373 * x24 + x3784
    x3786 = x23 * x2819 + x3785
    x3787 = x23 * x2820 + x3786
    x3788 = x272 * x3758 + 2.0 * x2777 + x3723
    x3789 = x2379 * x24 + x3788
    x3790 = x23 * x2825 + x3789
    x3791 = x23 * x2826 + x3790
    x3792 = x272 * x3766 + 2.0 * x2788 + x3734
    x3793 = x2385 * x24 + x3792
    x3794 = x23 * x2831 + x3793
    x3795 = x23 * x2832 + x3794
    x3796 = 2.0 * x2799
    x3797 = x272 * x3773 + x3796
    x3798 = x2391 * x24 + x3797
    x3799 = x23 * x2837 + x3798
    x3800 = x23 * x2838 + x3799
    x3801 = x153 * x3733 + x2354 + x341 * x3773
    x3802 = x2397 * x24 + x3801
    x3803 = x23 * x2843 + x3802
    x3804 = x23 * x2844 + x3803
    x3805 = x11 * x2881 - x2846 * x781
    x3806 = -x3805
    x3807 = x3806 * x74
    x3808 = x11 * x2872 - x2855 * x781
    x3809 = x85 * (-x3807 - x3808)
    x3810 = -x11 * x2889 + x2852 * x781
    x3811 = x3809 + x3810 * x462
    x3812 = x3811 * x74
    x3813 = -x3808
    x3814 = x3813 * x74
    x3815 = x11 * x2877 - x2869 * x781
    x3816 = x85 * (-x3814 - x3815)
    x3817 = x3806 * x462 + x3816
    x3818 = x3810 * x74
    x3819 = x85 * (-x3805 - x3818)
    x3820 = -x11 * x2901 + x2865 * x781
    x3821 = x3819 + x3820 * x462
    x3822 = x1 * (x17 * x3806 * x5 * x8 - x3810 * x467) + x3821 * x81
    x3823 = x171 * (-x3812 + x3817) + x3822 * x81
    x3824 = -x3815
    x3825 = (
        x153
        * (
            x1 * (x17 * x3824 * x5 * x8 - x3813 * x467)
            + x3817 * x81
            - x74 * (x1 * (x17 * x3813 * x5 * x8 - x3806 * x467) + x3812 * x8)
        )
        + x3823 * x81
    )
    x3826 = x24 * x2462 + x3825
    x3827 = x24 * x2463 + x3826
    x3828 = x23 * x2912 + x3827
    x3829 = x3 * x3824
    x3830 = x3 * x3813
    x3831 = x233 * x3806 - x36 * x3813
    x3832 = -x3831 * x74
    x3833 = x3830 + x3832 * x8
    x3834 = x233 * x3813 - x36 * x3824
    x3835 = -x3834
    x3836 = x3 * x3806
    x3837 = x233 * x3810 - x36 * x3806
    x3838 = -x3837 * x74
    x3839 = x3836 + x3838 * x8
    x3840 = x3839 * x74
    x3841 = x85 * (-x3831 - x3838)
    x3842 = x3 * x3810
    x3843 = x74 * (-x233 * x3820 + x36 * x3810)
    x3844 = x74 * (x3842 + x3843 * x8)
    x3845 = x74 * (x3841 + x3842 * x81 + x3844 * x8)
    x3846 = x85 * (-x3832 - x3834)
    x3847 = x3836 * x81 + x3840 * x8 + x3846
    x3848 = x85 * (-x3837 - x3843)
    x3849 = x3 * x3820
    x3850 = -x2074 * x2952 + x2900 * x781
    x3851 = -x233 * x3850 + x36 * x3820
    x3852 = x11 * x3818 + x2888
    x3853 = x11 * x3807 + x2880
    x3854 = x3852 * x74
    x3855 = x1 * (x3853 - x3854)
    x3856 = x272 * x3820 + x2899
    x3857 = 0.5 * x3855 + x3856 * x462
    x3858 = x1 * (x17 * x3853 * x5 * x8 - x3852 * x467) + x3857 * x81
    x3859 = x11 * x3814 + x2871
    x3860 = x1 * (x272 * x3824 + x2870 - x3859 * x74)
    x3861 = x3853 * x74
    x3862 = x1 * (x3859 - x3861)
    x3863 = (
        x171 * (x3853 * x462 + 0.5 * x3860 - x74 * (x3852 * x462 + 0.5 * x3862))
        + x3858 * x81
    )
    x3864 = x24 * x2528 + x3863
    x3865 = x24 * x2529 + x3864
    x3866 = x23 * x2978 + x3865
    x3867 = x11 * x3832 + x2914
    x3868 = x1 * (x272 * x3835 + x2913 - x3867 * x74)
    x3869 = x11 * x3838 + x2925
    x3870 = x3869 * x74
    x3871 = x1 * (x3867 - x3870)
    x3872 = x3 * x3852
    x3873 = x74 * (x11 * x3843 + x2936)
    x3874 = x74 * (x3872 + x3873 * x8)
    x3875 = x3 * x3853
    x3876 = x3870 * x8 + x3875
    x3877 = x1 * (x3869 - x3873)
    x3878 = x3 * x3856
    x3879 = x272 * x3851 + x2948
    x3880 = x14 * x3818 + x3580
    x3881 = x14 * x3807 + x3582
    x3882 = x3880 * x74
    x3883 = x1 * (x3881 - x3882)
    x3884 = 0.5 * x3883
    x3885 = x341 * x3820 + x3586
    x3886 = x3884 + x3885 * x462
    x3887 = x1 * (x17 * x3881 * x5 * x8 - x3880 * x467) + x3886 * x81
    x3888 = x14 * x3814 + x3591
    x3889 = x1 * (x341 * x3824 + x3590 - x3888 * x74)
    x3890 = 0.5 * x3889
    x3891 = x3881 * x74
    x3892 = x1 * (x3888 - x3891)
    x3893 = 0.5 * x3892
    x3894 = x171 * (x3881 * x462 + x3890 - x74 * (x3880 * x462 + x3893)) + x3887 * x81
    x3895 = x24 * x2582 + x3894
    x3896 = x24 * x2583 + x3895
    x3897 = x23 * x3026 + x3896
    x3898 = x14 * x3832 + x2466
    x3899 = x1 * (x2465 + x341 * x3835 - x3898 * x74)
    x3900 = 0.5 * x3899
    x3901 = x14 * x3838 + x2476
    x3902 = x3901 * x74
    x3903 = x1 * (x3898 - x3902)
    x3904 = 0.5 * x3903
    x3905 = x3 * x3880
    x3906 = x74 * (x14 * x3843 + x2484)
    x3907 = x74 * (x3905 + x3906 * x8)
    x3908 = x3 * x3881
    x3909 = x3902 * x8 + x3908
    x3910 = x1 * (x3901 - x3906)
    x3911 = 0.5 * x3910
    x3912 = x3 * x3885
    x3913 = x2492 + x341 * x3851
    x3914 = x11 * x3861 + x2964 + x3816
    x3915 = x3 * x3914
    x3916 = x11 * x3854 + x2961 + x3809
    x3917 = x3 * x3916
    x3918 = x74 * (x11 * x3873 + x272 * x2936 + x3841)
    x3919 = x11 * x3870 + x272 * x2925 + x3846
    x3920 = x3916 * x74
    x3921 = x3914 - x3920
    x3922 = x272 * x3856 + x2967 + x3819
    x3923 = x3921 * x85 + x3922 * x462
    x3924 = x1 * (x17 * x3914 * x5 * x8 - x3916 * x467) + x3923 * x81
    x3925 = x24 * x2624 + x3924
    x3926 = x24 * x2625 + x3925
    x3927 = x23 * x3072 + x3926
    x3928 = -x3918 + x3919
    x3929 = x3 * x3922
    x3930 = x272 * x2948 + x272 * x3879 + x3848
    x3931 = x11 * x3891 + x3006
    x3932 = x3 * x3931
    x3933 = x11 * x3882 + x3001
    x3934 = x3 * x3933
    x3935 = x74 * (x11 * x3906 + x3034)
    x3936 = x11 * x3902 + x3039
    x3937 = x3933 * x74
    x3938 = x1 * (x3931 - x3937)
    x3939 = x272 * x3885 + x3010
    x3940 = 0.5 * x3938 + x3939 * x462
    x3941 = x1 * (x17 * x3931 * x5 * x8 - x3933 * x467) + x3940 * x81
    x3942 = x24 * x2653 + x3941
    x3943 = x24 * x2654 + x3942
    x3944 = x23 * x3091 + x3943
    x3945 = x1 * (-x3935 + x3936)
    x3946 = x3 * x3939
    x3947 = x272 * x3913 + x3044
    x3948 = x14 * x3891 + x3664 + x3816
    x3949 = x3 * x3948
    x3950 = x14 * x3882 + x3667 + x3809
    x3951 = x3 * x3950
    x3952 = x74 * (x14 * x3906 + x2592 + x3841)
    x3953 = x14 * x3902 + x2595 + x3846
    x3954 = x3950 * x74
    x3955 = x3948 - x3954
    x3956 = x3955 * x85
    x3957 = x341 * x3885 + x3674 + x3819
    x3958 = x3956 + x3957 * x462
    x3959 = x1 * (x17 * x3948 * x5 * x8 - x3950 * x467) + x3958 * x81
    x3960 = x24 * x2684 + x3959
    x3961 = x24 * x2685 + x3960
    x3962 = x23 * x3121 + x3961
    x3963 = -x3952 + x3953
    x3964 = x3963 * x85
    x3965 = x3 * x3957
    x3966 = x2599 + x341 * x3913 + x3848
    x3967 = x272 * x3914 + x3054 + x3860 - x74 * (x11 * x3920 + x3056 + x3862)
    x3968 = x272 * x3922 + x3063 + x3855
    x3969 = x3967 * x85 + x3968 * x462
    x3970 = x24 * x2700 + x3969
    x3971 = x24 * x2701 + x3970
    x3972 = x23 * x3138 + x3971
    x3973 = x272 * x3919 + x3048 + x3868 - x74 * (x11 * x3918 + x3050 + x3871)
    x3974 = x3 * x3968
    x3975 = x272 * x3930 + x3074 + x3877
    x3976 = x272 * x3931 + x3079 + x3890 - x74 * (x11 * x3937 + x3078 + x3893)
    x3977 = x272 * x3939 + x3083 + x3884
    x3978 = x3976 * x85 + x3977 * x462
    x3979 = x24 * x2715 + x3978
    x3980 = x24 * x2716 + x3979
    x3981 = x23 * x3153 + x3980
    x3982 = (
        x272 * x3039 + x272 * x3936 + x3900 - x74 * (x11 * x3935 + x272 * x3034 + x3904)
    )
    x3983 = x3 * x3977
    x3984 = x272 * x3044 + x272 * x3947 + x3911
    x3985 = x1 * (x272 * x3948 + x3101 - x74 * (x11 * x3954 + x3103))
    x3986 = x272 * x3957 + x3112
    x3987 = 0.5 * x3985 + x3986 * x462
    x3988 = x24 * x2730 + x3987
    x3989 = x24 * x2731 + x3988
    x3990 = x23 * x3166 + x3989
    x3991 = x1 * (x272 * x3953 + x3094 - x74 * (x11 * x3952 + x3096))
    x3992 = x3 * x3986
    x3993 = x272 * x3966 + x3124
    x3994 = x341 * x3948 + x3721 + x3889 - x74 * (x14 * x3954 + x3722 + x3892)
    x3995 = x3994 * x85
    x3996 = x341 * x3957 + x3724 + x3883
    x3997 = x3995 + x3996 * x462
    x3998 = x24 * x2747 + x3997
    x3999 = x24 * x2748 + x3998
    x4000 = x23 * x3181 + x3999
    x4001 = x2660 + x341 * x3953 + x3899 - x74 * (x14 * x3952 + x2662 + x3903)
    x4002 = x4001 * x85
    x4003 = x3 * x3996
    x4004 = x2689 + x341 * x3966 + x3910
    x4005 = x171 * x3921 + x272 * x3968 + x3129
    x4006 = x3 * x4005
    x4007 = x4005 * x81
    x4008 = x24 * x2760 + x4007
    x4009 = x24 * x2761 + x4008
    x4010 = x23 * x3195 + x4009
    x4011 = x171 * x3928 + x272 * x3975 + x3140
    x4012 = x272 * x3977 + x3144 + x3938
    x4013 = x3 * x4012
    x4014 = x4012 * x81
    x4015 = x24 * x2771 + x4014
    x4016 = x24 * x2772 + x4015
    x4017 = x23 * x3206 + x4016
    x4018 = x272 * x3984 + x3155 + x3945
    x4019 = x272 * x3986 + x3158 + x3956
    x4020 = x3 * x4019
    x4021 = x4019 * x81
    x4022 = x24 * x2782 + x4021
    x4023 = x24 * x2783 + x4022
    x4024 = x23 * x3217 + x4023
    x4025 = x272 * x3124 + x272 * x3993 + x3964
    x4026 = x272 * x3996 + x3171
    x4027 = x3 * x4026
    x4028 = x4026 * x81
    x4029 = x24 * x2793 + x4028
    x4030 = x24 * x2794 + x4029
    x4031 = x23 * x3226 + x4030
    x4032 = x272 * x4004 + x3184
    x4033 = x171 * x3955 + x341 * x3996 + x3765
    x4034 = x3 * x4033
    x4035 = x4033 * x81
    x4036 = x24 * x2804 + x4035
    x4037 = x24 * x2805 + x4036
    x4038 = x23 * x3235 + x4037
    x4039 = x171 * x3963 + x2752 + x341 * x4004
    x4040 = x153 * x3967 + x272 * x4005 + x3188
    x4041 = x24 * x2812 + x4040
    x4042 = x24 * x2813 + x4041
    x4043 = x23 * x3243 + x4042
    x4044 = x171 * x3976 + x272 * x4012 + x3199
    x4045 = x24 * x2818 + x4044
    x4046 = x24 * x2819 + x4045
    x4047 = x23 * x3249 + x4046
    x4048 = x272 * x4019 + x3210 + x3985
    x4049 = x24 * x2824 + x4048
    x4050 = x24 * x2825 + x4049
    x4051 = x23 * x3255 + x4050
    x4052 = x272 * x4026 + x3220 + x3995
    x4053 = x24 * x2830 + x4052
    x4054 = x24 * x2831 + x4053
    x4055 = x23 * x3261 + x4054
    x4056 = x272 * x4033 + x3228
    x4057 = x24 * x2836 + x4056
    x4058 = x24 * x2837 + x4057
    x4059 = x23 * x3267 + x4058
    x4060 = x153 * x3994 + x341 * x4033 + x3796
    x4061 = x24 * x2842 + x4060
    x4062 = x24 * x2843 + x4061
    x4063 = x23 * x3273 + x4062
    x4064 = x14 * x2881
    x4065 = x1383 * x2846 + 2.0 * x1427 - x4064
    x4066 = x4065 * x74
    x4067 = x14 * x2872
    x4068 = x85 * (x1383 * x2855 + 2.0 * x1400 * x4 - x4066 - x4067)
    x4069 = x1383 * x2852 - x14 * x2889 + 2.0 * x1449
    x4070 = x4068 + x4069 * x462
    x4071 = x4070 * x74
    x4072 = x1383 * x2855 + 2.0 * x1401 - x4067
    x4073 = x4072 * x74
    x4074 = x14 * x2877
    x4075 = x85 * (x1383 * x2869 + 2.0 * x1412 * x4 - x4073 - x4074)
    x4076 = x4065 * x462 + x4075
    x4077 = x4069 * x74
    x4078 = x85 * (x1383 * x2846 + 2.0 * x1426 * x4 - x4064 - x4077)
    x4079 = x1383 * x2865 - x14 * x2901 + 2.0 * x1480
    x4080 = x4078 + x4079 * x462
    x4081 = x1 * (x17 * x4065 * x5 * x8 - x4069 * x467) + x4080 * x81
    x4082 = x171 * (-x4071 + x4076) + x4081 * x81
    x4083 = x1383 * x2869 + 2.0 * x1413 - x4074
    x4084 = (
        x153
        * (
            x1 * (x17 * x4083 * x5 * x8 - x4072 * x467)
            + x4076 * x81
            - x74 * (x1 * (x17 * x4072 * x5 * x8 - x4065 * x467) + x4071 * x8)
        )
        + x4082 * x81
    )
    x4085 = x24 * x2910 + x4084
    x4086 = x24 * x2911 + x4085
    x4087 = x24 * x2912 + x4086
    x4088 = x3 * x4083
    x4089 = x3 * x4072
    x4090 = x233 * x4065 - x36 * x4072
    x4091 = -x4090
    x4092 = x4091 * x74
    x4093 = x4089 + x4092 * x8
    x4094 = x233 * x4072 - x36 * x4083
    x4095 = -x4094
    x4096 = x3 * x4065
    x4097 = x233 * x4069 - x36 * x4065
    x4098 = -x4097
    x4099 = x4098 * x74
    x4100 = x4096 + x4099 * x8
    x4101 = x4100 * x74
    x4102 = x85 * (-x4090 - x4099)
    x4103 = x3 * x4069
    x4104 = -x233 * x4079 + x36 * x4069
    x4105 = x4104 * x74
    x4106 = x74 * (x4103 + x4105 * x8)
    x4107 = x74 * (x4102 + x4103 * x81 + x4106 * x8)
    x4108 = x85 * (-x4092 - x4094)
    x4109 = x4096 * x81 + x4101 * x8 + x4108
    x4110 = x85 * (-x4097 - x4105)
    x4111 = x3 * x4079
    x4112 = x1383 * x2900 + 2.0 * x1538 - x2951 * x2952
    x4113 = -x233 * x4112 + x36 * x4079
    x4114 = x1 * (x11 * x17 * x4065 * x5 - x270 * x4069)
    x4115 = x4079 * x635 + 0.5 * x4114
    x4116 = x1 * (x11 * x267 * x268 * x4065 * x8 - x1568 * x4069) + x4115 * x81
    x4117 = x1 * (x11 * x17 * x4083 * x5 - x270 * x4072)
    x4118 = x1 * (x11 * x17 * x4072 * x5 - x270 * x4065)
    x4119 = (
        x171 * (x4065 * x635 + 0.5 * x4117 - x74 * (x4069 * x635 + 0.5 * x4118))
        + x4116 * x81
    )
    x4120 = x24 * x2976 + x4119
    x4121 = x24 * x2977 + x4120
    x4122 = x24 * x2978 + x4121
    x4123 = x1 * (x11 * x17 * x4095 * x5 - x270 * x4091)
    x4124 = x270 * x4098
    x4125 = x1 * (x11 * x17 * x4091 * x5 - x4124)
    x4126 = x270 * x4104
    x4127 = x272 * x4103
    x4128 = x74 * (x4126 * x8 + x4127)
    x4129 = x272 * x4096
    x4130 = x4124 * x8 + x4129
    x4131 = x1 * (x11 * x17 * x4098 * x5 - x4126)
    x4132 = x272 * x4111
    x4133 = x14 * x4077 + 3.0 * x2888
    x4134 = x14 * x4066 + 3.0 * x2880
    x4135 = x4133 * x74
    x4136 = x1 * (x4134 - x4135)
    x4137 = 0.5 * x4136
    x4138 = 3.0 * x2899 + x341 * x4079
    x4139 = x4137 + x4138 * x462
    x4140 = x1 * (x17 * x4134 * x5 * x8 - x4133 * x467) + x4139 * x81
    x4141 = x14 * x4073 + 3.0 * x2871
    x4142 = x1 * (3.0 * x2870 + x341 * x4083 - x4141 * x74)
    x4143 = 0.5 * x4142
    x4144 = x4134 * x74
    x4145 = x1 * (x4141 - x4144)
    x4146 = 0.5 * x4145
    x4147 = x171 * (x4134 * x462 + x4143 - x74 * (x4133 * x462 + x4146)) + x4140 * x81
    x4148 = x24 * x3024 + x4147
    x4149 = x24 * x3025 + x4148
    x4150 = x24 * x3026 + x4149
    x4151 = x14 * x4092 + 3.0 * x2914
    x4152 = x1 * (3.0 * x2913 + x341 * x4095 - x4151 * x74)
    x4153 = 0.5 * x4152
    x4154 = x14 * x4099 + 3.0 * x2925
    x4155 = x4154 * x74
    x4156 = x1 * (x4151 - x4155)
    x4157 = 0.5 * x4156
    x4158 = x3 * x4133
    x4159 = x14 * x4105 + 3.0 * x2936
    x4160 = x4159 * x74
    x4161 = x74 * (x4158 + x4160 * x8)
    x4162 = x3 * x4134
    x4163 = x4155 * x8 + x4162
    x4164 = x1 * (x4154 - x4160)
    x4165 = 0.5 * x4164
    x4166 = x3 * x4138
    x4167 = 3.0 * x2948 + x341 * x4113
    x4168 = x4065 * x417 + x4075
    x4169 = x3 * x4168
    x4170 = x4068 + x4069 * x417
    x4171 = x3 * x4170
    x4172 = x74 * (x4102 + x4104 * x417)
    x4173 = x4098 * x417 + x4108
    x4174 = x4170 * x74
    x4175 = x4168 - x4174
    x4176 = x4078 + x4079 * x417
    x4177 = x4175 * x85 + x4176 * x462
    x4178 = x1 * (x17 * x4168 * x5 * x8 - x4170 * x467) + x4177 * x81
    x4179 = x24 * x3070 + x4178
    x4180 = x24 * x3071 + x4179
    x4181 = x24 * x3072 + x4180
    x4182 = -x4172 + x4173
    x4183 = x3 * x4176
    x4184 = x4110 + x4113 * x417
    x4185 = x270 * x4159
    x4186 = x272 * x4158
    x4187 = x272 * x4162
    x4188 = x1 * (x11 * x17 * x4134 * x5 - x270 * x4133)
    x4189 = x4138 * x635 + 0.5 * x4188
    x4190 = x1 * (x11 * x267 * x268 * x4134 * x8 - x1568 * x4133) + x4189 * x81
    x4191 = x24 * x3089 + x4190
    x4192 = x24 * x3090 + x4191
    x4193 = x24 * x3091 + x4192
    x4194 = x1 * (x11 * x17 * x4154 * x5 - x4185)
    x4195 = x272 * x4166
    x4196 = x14 * x4144 + 3.0 * x3006 + x4075
    x4197 = x3 * x4196
    x4198 = x14 * x4135 + 3.0 * x3001 + x4068
    x4199 = x3 * x4198
    x4200 = x14 * x4160 + 3.0 * x3034 + x4102
    x4201 = x4200 * x74
    x4202 = x14 * x4155 + 3.0 * x3039 + x4108
    x4203 = x4198 * x74
    x4204 = x4196 - x4203
    x4205 = x4204 * x85
    x4206 = 3.0 * x3010 + x341 * x4138 + x4078
    x4207 = x4205 + x4206 * x462
    x4208 = x1 * (x17 * x4196 * x5 * x8 - x4198 * x467) + x4207 * x81
    x4209 = x24 * x3119 + x4208
    x4210 = x24 * x3120 + x4209
    x4211 = x24 * x3121 + x4210
    x4212 = -x4201 + x4202
    x4213 = x4212 * x85
    x4214 = x3 * x4206
    x4215 = 3.0 * x3044 + x341 * x4167 + x4110
    x4216 = x272 * x4168 + x4117 - x74 * (x11 * x4174 + x4118)
    x4217 = x272 * x4176 + x4114
    x4218 = x4216 * x85 + x4217 * x462
    x4219 = x24 * x3136 + x4218
    x4220 = x24 * x3137 + x4219
    x4221 = x24 * x3138 + x4220
    x4222 = x272 * x4173 + x4123 - x74 * (x11 * x4172 + x4125)
    x4223 = x3 * x4217
    x4224 = x272 * x4184 + x4131
    x4225 = x4134 * x417 + x4143 - x74 * (x4133 * x417 + x4146)
    x4226 = x4137 + x4138 * x417
    x4227 = x4225 * x85 + x4226 * x462
    x4228 = x24 * x3151 + x4227
    x4229 = x24 * x3152 + x4228
    x4230 = x24 * x3153 + x4229
    x4231 = x4153 + x4154 * x417 - x74 * (x4157 + x4159 * x417)
    x4232 = x3 * x4226
    x4233 = x4165 + x4167 * x417
    x4234 = x1 * (x11 * x17 * x4196 * x5 - x270 * x4198)
    x4235 = x4206 * x635 + 0.5 * x4234
    x4236 = x24 * x3164 + x4235
    x4237 = x24 * x3165 + x4236
    x4238 = x24 * x3166 + x4237
    x4239 = x1 * (x11 * x17 * x4202 * x5 - x270 * x4200)
    x4240 = x272 * x4214
    x4241 = 3.0 * x3101 + x341 * x4196 + x4142 - x74 * (x14 * x4203 + 3.0 * x3103 + x4145)
    x4242 = x4241 * x85
    x4243 = 3.0 * x3112 + x341 * x4206 + x4136
    x4244 = x4242 + x4243 * x462
    x4245 = x24 * x3179 + x4244
    x4246 = x24 * x3180 + x4245
    x4247 = x24 * x3181 + x4246
    x4248 = 3.0 * x3094 + x341 * x4202 + x4152 - x74 * (x14 * x4201 + 3.0 * x3096 + x4156)
    x4249 = x4248 * x85
    x4250 = x3 * x4243
    x4251 = 3.0 * x3124 + x341 * x4215 + x4164
    x4252 = x171 * x4175 + x272 * x4217
    x4253 = x3 * x4252
    x4254 = x4252 * x81
    x4255 = x24 * x3193 + x4254
    x4256 = x24 * x3194 + x4255
    x4257 = x24 * x3195 + x4256
    x4258 = x171 * x4182 + x272 * x4224
    x4259 = x272 * x4226 + x4188
    x4260 = x3 * x4259
    x4261 = x4259 * x81
    x4262 = x24 * x3204 + x4261
    x4263 = x24 * x3205 + x4262
    x4264 = x24 * x3206 + x4263
    x4265 = x272 * x4233 + x4194
    x4266 = x417 * x4206 + x4205
    x4267 = x3 * x4266
    x4268 = x4266 * x81
    x4269 = x24 * x3215 + x4268
    x4270 = x24 * x3216 + x4269
    x4271 = x24 * x3217 + x4270
    x4272 = x417 * x4215 + x4213
    x4273 = x280 * x4243
    x4274 = x24 * x3224 + x4273
    x4275 = x24 * x3225 + x4274
    x4276 = x24 * x3226 + x4275
    x4277 = x272 * x4250
    x4278 = x171 * x4204 + 3.0 * x3171 + x341 * x4243
    x4279 = x3 * x4278
    x4280 = x4278 * x81
    x4281 = x24 * x3233 + x4280
    x4282 = x24 * x3234 + x4281
    x4283 = x24 * x3235 + x4282
    x4284 = x171 * x4212 + 3.0 * x3184 + x341 * x4251
    x4285 = x153 * x4216 + x272 * x4252
    x4286 = x24 * x3241 + x4285
    x4287 = x24 * x3242 + x4286
    x4288 = x24 * x3243 + x4287
    x4289 = x171 * x4225 + x272 * x4259
    x4290 = x24 * x3247 + x4289
    x4291 = x24 * x3248 + x4290
    x4292 = x24 * x3249 + x4291
    x4293 = x272 * x4266 + x4234
    x4294 = x24 * x3253 + x4293
    x4295 = x24 * x3254 + x4294
    x4296 = x24 * x3255 + x4295
    x4297 = x417 * x4243 + x4242
    x4298 = x24 * x3259 + x4297
    x4299 = x24 * x3260 + x4298
    x4300 = x24 * x3261 + x4299
    x4301 = x272 * x4278
    x4302 = x24 * x3265 + x4301
    x4303 = x24 * x3266 + x4302
    x4304 = x24 * x3267 + x4303
    x4305 = x153 * x4241 + 3.0 * x3228 + x341 * x4278
    x4306 = x24 * x3271 + x4305
    x4307 = x24 * x3272 + x4306
    x4308 = x24 * x3273 + x4307
    x4309 = x2074 * x3275
    x4310 = 3.0 * x2042 + x3282 * x781 - x4309
    x4311 = x2074 * x3282
    x4312 = 3.0 * x2048 + x3293 * x781 - x4311
    x4313 = x2074 * x3279
    x4314 = 3.0 * x2054 + x3275 * x781 - x4313
    x4315 = x4314 * x74
    x4316 = x85 * (3.0 * x2041 * x4 + x3282 * x781 - x4309 - x4315)
    x4317 = 3.0 * x2063 - x2074 * x3289 + x3279 * x781
    x4318 = x74 * (x4316 + x4317 * x462)
    x4319 = x4310 * x74
    x4320 = x85 * (3.0 * x2047 * x4 + x3293 * x781 - x4311 - x4319)
    x4321 = x4314 * x462 + x4320
    x4322 = x4317 * x74
    x4323 = x85 * (3.0 * x2053 * x4 + x3275 * x781 - x4313 - x4322)
    x4324 = 3.0 * x2073 - x2074 * x3322 + x3289 * x781
    x4325 = x11 * x4319 + 4.0 * x3299
    x4326 = x1 * (x272 * x4312 + 4.0 * x3298 - x4325 * x74)
    x4327 = 4.0 * x3306
    x4328 = x11 * x4315 + x4327
    x4329 = x4328 * x74
    x4330 = x1 * (x4325 - x4329)
    x4331 = 4.0 * x3313
    x4332 = x11 * x4322 + x4331
    x4333 = x4332 * x74
    x4334 = x1 * (x4328 - x4333)
    x4335 = 4.0 * x3321
    x4336 = x272 * x4324 + x4335
    x4337 = x1 * (x14 * x17 * x4312 * x5 - x339 * x4310)
    x4338 = 0.5 * x4337
    x4339 = x1 * (x14 * x17 * x4310 * x5 - x339 * x4314)
    x4340 = 0.5 * x4339
    x4341 = x1 * (x14 * x17 * x4314 * x5 - x339 * x4317)
    x4342 = 0.5 * x4341
    x4343 = x11 * x4333 + 4.0 * x3348 + x4316
    x4344 = x11 * x4329 + 4.0 * x3352 + x4320
    x4345 = x4343 * x74
    x4346 = x4344 - x4345
    x4347 = x272 * x4336 + 4.0 * x3355 + x4323
    x4348 = x341 * x4331 + x4317 * x477
    x4349 = x341 * x4327 + x4314 * x477
    x4350 = x4348 * x74
    x4351 = x1 * (x4349 - x4350)
    x4352 = x341 * x4335 + x4324 * x477
    x4353 = x4316 + x4317 * x508
    x4354 = x4314 * x508 + x4320
    x4355 = x4353 * x74
    x4356 = x4354 - x4355
    x4357 = x4356 * x85
    x4358 = x4323 + x4324 * x508
    x4359 = x272 * x4344 + 4.0 * x3384 + x4326 - x74 * (x11 * x4345 + 4.0 * x3386 + x4330)
    x4360 = x272 * x4347 + 4.0 * x3398 + x4334
    x4361 = x272 * x4349 + 4.0 * x3401 + x4338 - x74 * (x11 * x4350 + 4.0 * x3403 + x4340)
    x4362 = x272 * x4352 + 4.0 * x3415 + x4342
    x4363 = x1 * (x272 * x4354 + 4.0 * x3418 - x74 * (x11 * x4355 + 4.0 * x3420))
    x4364 = x272 * x4358 + 4.0 * x3434
    x4365 = x341 * x4354 + x4337 - x74 * (x14 * x4355 + x4339)
    x4366 = x4365 * x85
    x4367 = x341 * x4358 + x4341
    x4368 = x171 * x4346 + x272 * x4360 + 4.0 * x3443
    x4369 = x272 * x4362 + 4.0 * x3452 + x4351
    x4370 = x272 * x4364 + 4.0 * x3461 + x4357
    x4371 = x272 * x4367 + 4.0 * x3472
    x4372 = x171 * x4356 + x341 * x4367
    x4373 = x2074 * x3534
    x4374 = 2.0 * x2468 + x3541 * x781 - x4373
    x4375 = x2074 * x3541
    x4376 = 2.0 * x2473 + x3552 * x781 - x4375
    x4377 = x2074 * x3538
    x4378 = 2.0 * x2478 + x3534 * x781 - x4377
    x4379 = x4378 * x74
    x4380 = x85 * (2.0 * x2467 * x4 + x3541 * x781 - x4373 - x4379)
    x4381 = -x2074 * x3548 + 2.0 * x2485 + x3538 * x781
    x4382 = x74 * (x4380 + x4381 * x462)
    x4383 = x4374 * x74
    x4384 = x85 * (2.0 * x2472 * x4 + x3552 * x781 - x4375 - x4383)
    x4385 = x4378 * x462 + x4384
    x4386 = x4381 * x74
    x4387 = x85 * (2.0 * x2477 * x4 + x3534 * x781 - x4377 - x4386)
    x4388 = -x2074 * x3578 + 2.0 * x2493 + x3548 * x781
    x4389 = x11 * x4383 + 3.0 * x3558
    x4390 = x1 * (x272 * x4376 + 3.0 * x3557 - x4389 * x74)
    x4391 = x11 * x4379 + 3.0 * x3564
    x4392 = x4391 * x74
    x4393 = x1 * (x4389 - x4392)
    x4394 = x11 * x4386 + 3.0 * x3570
    x4395 = x4394 * x74
    x4396 = x1 * (x4391 - x4395)
    x4397 = x272 * x4388 + 3.0 * x3577
    x4398 = x14 * x4383 + x3299
    x4399 = x1 * (x3298 + x341 * x4376 - x4398 * x74)
    x4400 = 0.5 * x4399
    x4401 = x14 * x4379 + x3306
    x4402 = x4401 * x74
    x4403 = x1 * (x4398 - x4402)
    x4404 = 0.5 * x4403
    x4405 = x14 * x4386 + x3313
    x4406 = x4405 * x74
    x4407 = x1 * (x4401 - x4406)
    x4408 = 0.5 * x4407
    x4409 = x3321 + x341 * x4388
    x4410 = x11 * x4395 + 3.0 * x3605 + x4380
    x4411 = x11 * x4392 + 3.0 * x3608 + x4384
    x4412 = x4410 * x74
    x4413 = x4411 - x4412
    x4414 = x272 * x4397 + 3.0 * x3611 + x4387
    x4415 = x11 * x4406 + 3.0 * x3638
    x4416 = x11 * x4402 + 3.0 * x3641
    x4417 = x4415 * x74
    x4418 = x1 * (x4416 - x4417)
    x4419 = x272 * x4409 + 3.0 * x3645
    x4420 = x14 * x4406 + x3376 + x4380
    x4421 = x14 * x4402 + x3378 + x4384
    x4422 = x4420 * x74
    x4423 = x4421 - x4422
    x4424 = x4423 * x85
    x4425 = x3382 + x341 * x4409 + x4387
    x4426 = x272 * x4411 + 3.0 * x3648 + x4390 - x74 * (x11 * x4412 + 3.0 * x3650 + x4393)
    x4427 = x272 * x4414 + 3.0 * x3662 + x4396
    x4428 = x272 * x4416 + 3.0 * x3666 + x4400 - x74 * (x11 * x4417 + 3.0 * x3669 + x4404)
    x4429 = x272 * x4419 + 3.0 * x3682 + x4408
    x4430 = x1 * (x272 * x4421 + 3.0 * x3685 - x74 * (x11 * x4422 + 3.0 * x3687))
    x4431 = x272 * x4425 + 3.0 * x3701
    x4432 = x341 * x4421 + x3418 + x4399 - x74 * (x14 * x4422 + x3420 + x4403)
    x4433 = x4432 * x85
    x4434 = x341 * x4425 + x3434 + x4407
    x4435 = x171 * x4413 + x272 * x4427 + 3.0 * x3710
    x4436 = x272 * x4429 + 3.0 * x3719 + x4418
    x4437 = x272 * x4431 + 3.0 * x3731 + x4424
    x4438 = x272 * x4434 + 3.0 * x3742
    x4439 = x171 * x4423 + x341 * x4434 + x3472
    x4440 = x2074 * x3806
    x4441 = x2916 + x3813 * x781 - x4440
    x4442 = x2074 * x3813
    x4443 = x2922 + x3824 * x781 - x4442
    x4444 = x2074 * x3810
    x4445 = x2928 + x3806 * x781 - x4444
    x4446 = x4445 * x74
    x4447 = x85 * (-x2934 + x3813 * x781 - x4440 - x4446)
    x4448 = -x2074 * x3820 + x2938 + x3810 * x781
    x4449 = x74 * (x4447 + x4448 * x462)
    x4450 = x4441 * x74
    x4451 = x85 * (-x2943 + x3824 * x781 - x4442 - x4450)
    x4452 = x4445 * x462 + x4451
    x4453 = x4448 * x74
    x4454 = x85 * (-x2946 + x3806 * x781 - x4444 - x4453)
    x4455 = -x2074 * x3850 + x2950 + x3820 * x781
    x4456 = x11 * x4450 + 2.0 * x3830
    x4457 = x1 * (x272 * x4443 + 2.0 * x3829 - x4456 * x74)
    x4458 = x11 * x4446 + 2.0 * x3836
    x4459 = x4458 * x74
    x4460 = x1 * (x4456 - x4459)
    x4461 = x11 * x4453 + 2.0 * x3842
    x4462 = x4461 * x74
    x4463 = x1 * (x4458 - x4462)
    x4464 = x272 * x4455 + 2.0 * x3849
    x4465 = x14 * x4450 + 2.0 * x3558
    x4466 = x1 * (x341 * x4443 + 2.0 * x3557 - x4465 * x74)
    x4467 = 0.5 * x4466
    x4468 = x14 * x4446 + 2.0 * x3564
    x4469 = x4468 * x74
    x4470 = x1 * (x4465 - x4469)
    x4471 = 0.5 * x4470
    x4472 = x14 * x4453 + 2.0 * x3570
    x4473 = x4472 * x74
    x4474 = x1 * (x4468 - x4473)
    x4475 = 0.5 * x4474
    x4476 = x341 * x4455 + 2.0 * x3577
    x4477 = x11 * x4462 + 2.0 * x3872 + x4447
    x4478 = x11 * x4459 + 2.0 * x3875 + x4451
    x4479 = x4477 * x74
    x4480 = x4478 - x4479
    x4481 = x272 * x4464 + 2.0 * x3878 + x4454
    x4482 = x11 * x4473 + 2.0 * x3905
    x4483 = x11 * x4469 + 2.0 * x3908
    x4484 = x4482 * x74
    x4485 = x1 * (x4483 - x4484)
    x4486 = x272 * x4476 + 2.0 * x3912
    x4487 = x14 * x4473 + 2.0 * x3638 + x4447
    x4488 = x14 * x4469 + 2.0 * x3641 + x4451
    x4489 = x4487 * x74
    x4490 = x4488 - x4489
    x4491 = x4490 * x85
    x4492 = x341 * x4476 + 2.0 * x3645 + x4454
    x4493 = x272 * x4478 + 2.0 * x3915 + x4457 - x74 * (x11 * x4479 + 2.0 * x3917 + x4460)
    x4494 = x272 * x4481 + 2.0 * x3929 + x4463
    x4495 = x272 * x4483 + 2.0 * x3932 + x4467 - x74 * (x11 * x4484 + 2.0 * x3934 + x4471)
    x4496 = x272 * x4486 + 2.0 * x3946 + x4475
    x4497 = x1 * (x272 * x4488 + 2.0 * x3949 - x74 * (x11 * x4489 + 2.0 * x3951))
    x4498 = x272 * x4492 + 2.0 * x3965
    x4499 = x341 * x4488 + 2.0 * x3685 + x4466 - x74 * (x14 * x4489 + 2.0 * x3687 + x4470)
    x4500 = x4499 * x85
    x4501 = x341 * x4492 + 2.0 * x3701 + x4474
    x4502 = x171 * x4480 + x272 * x4494 + 2.0 * x3974
    x4503 = x272 * x4496 + 2.0 * x3983 + x4485
    x4504 = x272 * x4498 + 2.0 * x3992 + x4491
    x4505 = x272 * x4501 + 2.0 * x4003
    x4506 = x171 * x4490 + x341 * x4501 + 2.0 * x3742
    x4507 = x2074 * x4065 - x4072 * x781
    x4508 = -x4507
    x4509 = x2074 * x4072 - x4083 * x781
    x4510 = -x4509
    x4511 = x2074 * x4069 - x4065 * x781
    x4512 = -x4511
    x4513 = x4512 * x74
    x4514 = x85 * (-x4507 - x4513)
    x4515 = -x2074 * x4079 + x4069 * x781
    x4516 = x74 * (x4514 + x4515 * x462)
    x4517 = x4508 * x74
    x4518 = x85 * (-x4509 - x4517)
    x4519 = x4512 * x462 + x4518
    x4520 = x4515 * x74
    x4521 = x85 * (-x4511 - x4520)
    x4522 = -x2074 * x4112 + x4079 * x781
    x4523 = x11 * x4517 + x4089
    x4524 = x1 * (x272 * x4510 + x4088 - x4523 * x74)
    x4525 = x11 * x4513 + x4096
    x4526 = x4525 * x74
    x4527 = x1 * (x4523 - x4526)
    x4528 = x11 * x4520 + x4103
    x4529 = x4528 * x74
    x4530 = x1 * (x4525 - x4529)
    x4531 = x272 * x4522 + x4111
    x4532 = x14 * x4517 + 3.0 * x3830
    x4533 = x1 * (x341 * x4510 + 3.0 * x3829 - x4532 * x74)
    x4534 = 0.5 * x4533
    x4535 = x14 * x4513 + 3.0 * x3836
    x4536 = x4535 * x74
    x4537 = x1 * (x4532 - x4536)
    x4538 = 0.5 * x4537
    x4539 = x14 * x4520 + 3.0 * x3842
    x4540 = x4539 * x74
    x4541 = x1 * (x4535 - x4540)
    x4542 = 0.5 * x4541
    x4543 = x341 * x4522 + 3.0 * x3849
    x4544 = x11 * x4529 + x4127 + x4514
    x4545 = x11 * x4526 + x4129 + x4518
    x4546 = x4544 * x74
    x4547 = x4545 - x4546
    x4548 = x272 * x4531 + x4132 + x4521
    x4549 = x11 * x4540 + x4158
    x4550 = x11 * x4536 + x4162
    x4551 = x4549 * x74
    x4552 = x1 * (x4550 - x4551)
    x4553 = x272 * x4543 + x4166
    x4554 = x14 * x4540 + 3.0 * x3905 + x4514
    x4555 = x14 * x4536 + 3.0 * x3908 + x4518
    x4556 = x4554 * x74
    x4557 = x4555 - x4556
    x4558 = x4557 * x85
    x4559 = x341 * x4543 + 3.0 * x3912 + x4521
    x4560 = x272 * x4545 + x4169 + x4524 - x74 * (x11 * x4546 + x4171 + x4527)
    x4561 = x272 * x4548 + x4183 + x4530
    x4562 = x272 * x4550 + x4187 + x4534 - x74 * (x11 * x4551 + x4186 + x4538)
    x4563 = x272 * x4553 + x4195 + x4542
    x4564 = x1 * (x272 * x4555 + x4197 - x74 * (x11 * x4556 + x4199))
    x4565 = x272 * x4559 + x4214
    x4566 = x341 * x4555 + 3.0 * x3949 + x4533 - x74 * (x14 * x4556 + 3.0 * x3951 + x4537)
    x4567 = x4566 * x85
    x4568 = x341 * x4559 + 3.0 * x3965 + x4541
    x4569 = x171 * x4547 + x272 * x4561 + x4223
    x4570 = x272 * x4563 + x4232 + x4552
    x4571 = x272 * x4565 + x4240 + x4558
    x4572 = x272 * x4568 + x4250
    x4573 = x171 * x4557 + x341 * x4568 + 3.0 * x4003
    x4574 = x2951 * x4065
    x4575 = x1383 * x4072 + 3.0 * x2916 - x4574
    x4576 = x2951 * x4072
    x4577 = x1383 * x4083 + 3.0 * x2922 - x4576
    x4578 = x2951 * x4069
    x4579 = x1383 * x4065 + 3.0 * x2928 - x4578
    x4580 = x4579 * x74
    x4581 = x85 * (x1383 * x4072 + 3.0 * x2915 * x4 - x4574 - x4580)
    x4582 = x1383 * x4069 + 3.0 * x2938 - x2951 * x4079
    x4583 = x74 * (x4581 + x4582 * x462)
    x4584 = x4575 * x74
    x4585 = x85 * (x1383 * x4083 + 3.0 * x2921 * x4 - x4576 - x4584)
    x4586 = x4579 * x462 + x4585
    x4587 = x4582 * x74
    x4588 = x85 * (x1383 * x4065 + 3.0 * x2927 * x4 - x4578 - x4587)
    x4589 = x1383 * x4079 + 3.0 * x2950 - x2951 * x4112
    x4590 = x1 * (x11 * x17 * x4577 * x5 - x270 * x4575)
    x4591 = x1 * (x11 * x17 * x4575 * x5 - x270 * x4579)
    x4592 = x1 * (x11 * x17 * x4579 * x5 - x270 * x4582)
    x4593 = x14 * x4584 + 4.0 * x4089
    x4594 = x1 * (x341 * x4577 + 4.0 * x4088 - x4593 * x74)
    x4595 = 0.5 * x4594
    x4596 = x14 * x4580 + 4.0 * x4096
    x4597 = x4596 * x74
    x4598 = x1 * (x4593 - x4597)
    x4599 = 0.5 * x4598
    x4600 = x14 * x4587 + 4.0 * x4103
    x4601 = x4600 * x74
    x4602 = x1 * (x4596 - x4601)
    x4603 = 0.5 * x4602
    x4604 = x341 * x4589 + 4.0 * x4111
    x4605 = x417 * x4582 + x4581
    x4606 = x417 * x4579 + x4585
    x4607 = x4605 * x74
    x4608 = x4606 - x4607
    x4609 = x417 * x4589 + x4588
    x4610 = x1 * (x11 * x17 * x4596 * x5 - x270 * x4600)
    x4611 = x14 * x4601 + 4.0 * x4158 + x4581
    x4612 = x14 * x4597 + 4.0 * x4162 + x4585
    x4613 = x4611 * x74
    x4614 = x4612 - x4613
    x4615 = x4614 * x85
    x4616 = x341 * x4604 + 4.0 * x4166 + x4588
    x4617 = x272 * x4606 + x4590 - x74 * (x11 * x4607 + x4591)
    x4618 = x272 * x4609 + x4592
    x4619 = x417 * x4596 + x4595 - x74 * (x417 * x4600 + x4599)
    x4620 = x417 * x4604 + x4603
    x4621 = x1 * (x11 * x17 * x4612 * x5 - x270 * x4611)
    x4622 = x341 * x4612 + 4.0 * x4197 + x4594 - x74 * (x14 * x4613 + 4.0 * x4199 + x4598)
    x4623 = x4622 * x85
    x4624 = x341 * x4616 + 4.0 * x4214 + x4602
    x4625 = x171 * x4608 + x272 * x4618
    x4626 = x272 * x4620 + x4610
    x4627 = x417 * x4616 + x4615
    x4628 = x171 * x4614 + x341 * x4624 + 4.0 * x4250

    # 315 item(s)
    return numpy.array(
        [
            x0 * x196
            + x0 * x213
            + x0 * x226
            + x0 * (x0 * (x0 * (x0 * x228 + x224) + x225) + x226)
            + x153
            * (
                x1 * (4.0 * x229 - x237 * x74 + x240 * x81)
                + x152 * x241
                + x259 * x81
                - x74 * (x1 * (x237 - x249) + x149 * x241 + x257 * x8)
            )
            + x195 * x241
            + x81
            * (
                x171 * (-x257 + x259)
                + x194 * x241
                + x81
                * (
                    x1 * (x248 - x256)
                    + x193 * x241
                    + x81 * (x192 * x241 + x260 + x81 * (x262 + x266 * x81))
                )
            ),
            x0 * x303
            + x0 * x320
            + x0 * x327
            + x0 * (x0 * (x0 * (x0 * x331 + x325) + x326) + x327)
            + x171
            * (
                x241 * x298
                + 0.5 * x332
                + x337 * x81
                - x74 * (x241 * x296 + 0.5 * x334 + x336 * x8)
            )
            + x241 * x302
            + x81
            * (
                x1 * (-x336 + x337)
                + x241 * x301
                + x81 * (x241 * x300 + 0.5 * x338 + x81 * (x262 * x272 + x266 * x280))
            ),
            x0 * x374
            + x0 * x392
            + x0 * x401
            + x0 * (x0 * (x0 * (x0 * x406 + x399) + x400) + x401)
            + x171
            * (x241 * x368 + x408 + x414 * x81 - x74 * (x241 * x366 + x411 + x413 * x8))
            + x241 * x373
            + x81
            * (
                x1 * (-x413 + x414)
                + x241 * x372
                + x81 * (x241 * x371 + x416 + x81 * (x262 * x341 + x266 * x349))
            ),
            x0 * x446
            + x0 * x455
            + x0 * x466
            + x0 * (x0 * (x0 * (x0 * x468 + x464) + x465) + x466)
            + x1 * (4.0 * x419 + x423 * x81 - x74 * (4.0 * x421 + x422 * x8))
            + x241 * x445
            + x81 * (x241 * x444 + x469 * x85 + x81 * (4.0 * x470 + x471 * x81)),
            x0 * x490
            + x0 * x496
            + x0 * x505
            + x0 * (x0 * (x0 * (x0 * x506 + x503) + x504) + x505)
            + x1 * (x243 * x477 + x246 * x478 - x74 * (x252 * x477 + x476 * x8))
            + x241 * x489
            + x81 * (x241 * x488 + 0.5 * x507 + x81 * (x262 * x477 + x266 * x478)),
            x0 * x541
            + x0 * x551
            + x0 * x562
            + x0 * (x0 * (x0 * (x0 * x563 + x560) + x561) + x562)
            + x1 * (4.0 * x510 + x515 * x81 - x74 * (4.0 * x512 + x514 * x8))
            + x241 * x540
            + x81 * (x241 * x539 + x565 + x81 * (x567 + x568 * x81)),
            x0 * x577
            + x0 * x583
            + x0 * x587
            + x0 * (x0 * (x0 * (x0 * x589 + x585) + x586) + x587)
            + x241 * x576
            + x590 * x85
            + x81 * (4.0 * x591 + x592 * x81),
            x0 * x602
            + x0 * x610
            + x0 * x614
            + x0 * (x0 * (x0 * (x0 * x616 + x612) + x613) + x614)
            + x241 * x601
            + x617 * x85
            + x81 * (4.0 * x618 + x619 * x81),
            x0 * x623
            + x0 * x628
            + x0 * x632
            + x0 * (x0 * (x0 * (x0 * x636 + x630) + x631) + x632)
            + x241 * x622
            + 0.5 * x637
            + x81 * (x272 * x567 + x280 * x568),
            x0 * x649
            + x0 * x656
            + x0 * x661
            + x0 * (x0 * (x0 * (x0 * x664 + x659) + x660) + x661)
            + x241 * x648
            + x666
            + x81 * (x668 + x669 * x81),
            x0 * x673
            + x0 * x677
            + x0 * x682
            + x0 * (x0 * (x0 * (x678 * x683 + x680) + x681) + x682)
            + 4.0 * x684
            + x685 * x81,
            x0 * x689
            + x0 * x693
            + x0 * x698
            + x0 * (x0 * (x0 * (x683 * x694 + x696) + x697) + x698)
            + 4.0 * x699
            + x700 * x81,
            x0 * x704
            + x0 * x708
            + x0 * x713
            + x0 * (x0 * (x0 * (x683 * x709 + x711) + x712) + x713)
            + 4.0 * x714
            + x715 * x81,
            x0 * x716
            + x0 * x718
            + x0 * x722
            + x0 * (x0 * (x0 * (x0 * x723 + x720) + x721) + x722)
            + x272 * x668
            + x280 * x669,
            x0 * x727
            + x0 * x731
            + x0 * x736
            + x0 * (x0 * (x0 * (x683 * x732 + x734) + x735) + x736)
            + 4.0 * x737
            + x738 * x81,
            x0 * x739
            + x0 * x741
            + x0 * x744
            + x0 * (x0 * (x0 * (x0 * x745 + x742) + x743) + x744)
            + x153 * x590
            + x272 * x685,
            x0 * x746
            + x0 * x748
            + x0 * x751
            + x0 * (x0 * (x0 * (x0 * x752 + x749) + x750) + x751)
            + x171 * x617
            + x272 * x700,
            x0 * x753
            + x0 * x755
            + x0 * x758
            + x0 * (x0 * (x0 * (x0 * x759 + x756) + x757) + x758)
            + x272 * x715
            + x637,
            x0 * x760
            + x0 * x762
            + x0 * x765
            + x0 * (x0 * (x0 * (x0 * x766 + x763) + x764) + x765)
            + x417 * x669
            + x666,
            x0 * x767
            + x0 * x769
            + x0 * x772
            + x0 * (x0 * (x0 * (x0 * x773 + x770) + x771) + x772)
            + x272 * x738,
            x0 * x774
            + x0 * x776
            + x0 * x779
            + x0 * (x0 * (x0 * (x0 * x780 + x777) + x778) + x779)
            + x153 * x665
            + x341 * x738,
            x0 * x886
            + x0 * x900
            + x0 * (x0 * (x0 * x902 + x899) + x900)
            + x100 * x884
            + x153
            * (
                x1 * (-x74 * x909 + x81 * x912 + 3.0 * x903)
                + x100 * x860
                - x74 * (x1 * (x909 - x920) + x100 * x857 + x8 * x927)
                + x81 * x929
            )
            + x196 * x23
            + x81
            * (
                x100 * x883
                + x171 * (-x927 + x929)
                + x81
                * (
                    x1 * (x919 - x926)
                    + x100 * x882
                    + x81 * (x100 * x881 + x81 * (x81 * x935 + x932) + x930)
                )
            ),
            x0 * x976
            + x0 * x983
            + x0 * (x0 * (x0 * x989 + x982) + x983)
            + x100 * x974
            + x171
            * (
                x100 * x968
                - x74 * (x100 * x965 + x8 * x996 + 0.5 * x994)
                + x81 * x997
                + 0.5 * x991
            )
            + x23 * x303
            + x81
            * (
                x1 * (-x996 + x997)
                + x100 * x973
                + x81 * (x100 * x972 + x81 * (x100 * x971 + x81 * x999) + 0.5 * x998)
            ),
            x0 * x1035
            + x0 * x1044
            + x0 * (x0 * (x0 * x1050 + x1043) + x1044)
            + x100 * x1033
            + x171
            * (
                x100 * x1027
                + x1052
                + x1058 * x81
                - x74 * (x100 * x1024 + x1055 + x1057 * x8)
            )
            + x23 * x374
            + x81
            * (
                x1 * (-x1057 + x1058)
                + x100 * x1032
                + x81 * (x100 * x1031 + x1060 + x81 * (x341 * x932 + x349 * x935))
            ),
            x0 * x1083
            + x0 * x1093
            + x0 * (x0 * (x0 * x1095 + x1092) + x1093)
            + x1 * (x100 * x1061 + x1064 * x81 - x74 * (x100 * x1062 + x1063 * x8))
            + x100 * x1081
            + x23 * x446
            + x81 * (x100 * x1080 + x1096 * x85 + x81 * (x100 * x1079 + x1097 * x81)),
            x0 * x1128
            + x0 * x1138
            + x0 * (x0 * (x0 * x1140 + x1137) + x1138)
            + x1 * (x100 * x1099 + x1105 * x81 - x74 * (x100 * x1101 + x1103 * x8))
            + x100 * x1126
            + x23 * x490
            + x81 * (x100 * x1125 + 0.5 * x1141 + x81 * (x100 * x1124 + x1143 * x81)),
            x0 * x1173
            + x0 * x1184
            + x0 * (x0 * (x0 * x1186 + x1183) + x1184)
            + x1 * (3.0 * x1145 + x1149 * x81 - x74 * (3.0 * x1147 + x1148 * x8))
            + x100 * x1171
            + x23 * x541
            + x81 * (x100 * x1170 + x1188 + x81 * (3.0 * x1189 + x1190 * x81)),
            x0 * x1200
            + x0 * x1204
            + x0 * (x0 * (x0 * x1207 + x1203) + x1204)
            + x100 * x1198
            + x1208 * x85
            + x23 * x577
            + x81 * (x100 * x1197 + x1209 * x81),
            x0 * x1219
            + x0 * x1223
            + x0 * (x0 * (x0 * x1226 + x1222) + x1223)
            + x100 * x1217
            + x1227 * x85
            + x23 * x602
            + x81 * (x100 * x1216 + x1228 * x81),
            x0 * x1238
            + x0 * x1242
            + x0 * (x0 * (x0 * x1245 + x1241) + x1242)
            + x100 * x1236
            + 0.5 * x1246
            + x23 * x623
            + x81 * (x100 * x1235 + x1247 * x81),
            x0 * x1259
            + x0 * x1264
            + x0 * (x0 * (x0 * x1268 + x1263) + x1264)
            + x100 * x1257
            + x1270
            + x23 * x649
            + x81 * (3.0 * x1271 + x1272 * x81),
            x0 * x1277
            + x0 * x1282
            + x0 * (x0 * (x0 * x1285 + x1281) + x1282)
            + x100 * x1275
            + x1286 * x81
            + x23 * x673,
            x0 * x1291
            + x0 * x1296
            + x0 * (x0 * (x0 * x1298 + x1295) + x1296)
            + x100 * x1289
            + x1299 * x81
            + x23 * x689,
            x0 * x1304
            + x0 * x1309
            + x0 * (x0 * (x0 * x1311 + x1308) + x1309)
            + x100 * x1302
            + x1312 * x81
            + x23 * x704,
            x0 * x1317
            + x0 * x1322
            + x0 * (x0 * (x0 * x1324 + x1321) + x1322)
            + x100 * x1315
            + x1325 * x81
            + x23 * x716,
            x0 * x1331
            + x0 * x1336
            + x0 * (x0 * (x0 * x1338 + x1335) + x1336)
            + 3.0 * x1339
            + x1340 * x81
            + x23 * x727,
            x0 * x1342
            + x0 * x1345
            + x0 * (x0 * (x0 * x1347 + x1344) + x1345)
            + x1208 * x153
            + x1286 * x272
            + x23 * x739
            + x684,
            x0 * x1349
            + x0 * x1352
            + x0 * (x0 * (x0 * x1354 + x1351) + x1352)
            + x1227 * x171
            + x1299 * x272
            + x23 * x746
            + x699,
            x0 * x1356
            + x0 * x1359
            + x0 * (x0 * (x0 * x1361 + x1358) + x1359)
            + x1246
            + x1312 * x272
            + x23 * x753
            + x714,
            x0 * x1363
            + x0 * x1366
            + x0 * (x0 * (x0 * x1368 + x1365) + x1366)
            + x1270
            + x1325 * x272
            + x23 * x760
            + x272 * x667,
            x0 * x1370
            + x0 * x1373
            + x0 * (x0 * (x0 * x1375 + x1372) + x1373)
            + x1340 * x272
            + x23 * x767
            + x737,
            x0 * x1377
            + x0 * x1380
            + x0 * (x0 * (x0 * x1382 + x1379) + x1380)
            + x1269 * x153
            + x1340 * x341
            + x23 * x774,
            x0 * x1491
            + x0 * x1505
            + x0 * (x0 * (x0 * x1507 + x1504) + x1505)
            + x100 * x1489
            + x153
            * (
                x1 * (3.0 * x1508 - x1514 * x74 + x1517 * x81)
                + x100 * x1464
                + x1534 * x81
                - x74 * (x1 * (x1514 - x1525) + x100 * x1460 + x1532 * x8)
            )
            + x196 * x24
            + x81
            * (
                x100 * x1488
                + x171 * (-x1532 + x1534)
                + x81
                * (
                    x1 * (x1524 - x1531)
                    + x100 * x1487
                    + x81 * (x100 * x1486 + x1535 + x81 * (x1537 + x1540 * x81))
                )
            ),
            x0 * x1567
            + x0 * x1574
            + x0 * (x0 * (x0 * x1578 + x1573) + x1574)
            + x100 * x1565
            + x171
            * (
                x100 * x1561
                + 0.5 * x1579
                + x1584 * x81
                - x74 * (x100 * x1559 + 0.5 * x1581 + x1583 * x8)
            )
            + x24 * x303
            + x81
            * (
                x1 * (-x1583 + x1584)
                + x100 * x1564
                + x81 * (x100 * x1563 + 0.5 * x1585 + x81 * (x1537 * x272 + x1540 * x280))
            ),
            x0 * x1634
            + x0 * x1643
            + x0 * (x0 * (x0 * x1651 + x1642) + x1643)
            + x100 * x1632
            + x171
            * (
                x100 * x1624
                + x1654
                + x1666 * x81
                - x74 * (x100 * x1620 + x1658 + x1663 * x8)
            )
            + x24 * x374
            + x81
            * (
                x1 * (-x1663 + x1666)
                + x100 * x1631
                + x81 * (x100 * x1630 + x1668 + x81 * (x1670 + x1671 * x81))
            ),
            x0 * x1696
            + x0 * x1706
            + x0 * (x0 * (x0 * x1708 + x1705) + x1706)
            + x1 * (3.0 * x1673 + x1677 * x81 - x74 * (3.0 * x1675 + x1676 * x8))
            + x100 * x1694
            + x24 * x446
            + x81 * (x100 * x1693 + x1709 * x85 + x81 * (3.0 * x1710 + x1711 * x81)),
            x0 * x1723
            + x0 * x1730
            + x0 * (x0 * (x0 * x1732 + x1729) + x1730)
            + x1 * (x1655 * x280 + x1665 * x272 - x74 * (x1660 * x272 + x1712 * x8))
            + x100 * x1721
            + x24 * x490
            + x81 * (x100 * x1720 + 0.5 * x1733 + x81 * (x1670 * x272 + x1671 * x280)),
            x0 * x1764
            + x0 * x1775
            + x0 * (x0 * (x0 * x1777 + x1774) + x1775)
            + x1 * (3.0 * x1735 + x1740 * x81 - x74 * (3.0 * x1737 + x1739 * x8))
            + x100 * x1762
            + x24 * x541
            + x81 * (x100 * x1761 + x1779 + x81 * (x1781 + x1782 * x81)),
            x0 * x1792
            + x0 * x1796
            + x0 * (x0 * (x0 * x1799 + x1795) + x1796)
            + x100 * x1790
            + x1800 * x85
            + x24 * x577
            + x81 * (3.0 * x1801 + x1802 * x81),
            x0 * x1812
            + x0 * x1816
            + x0 * (x0 * (x0 * x1819 + x1815) + x1816)
            + x100 * x1810
            + x1820 * x85
            + x24 * x602
            + x81 * (3.0 * x1821 + x1822 * x81),
            x0 * x1828
            + x0 * x1832
            + x0 * (x0 * (x0 * x1835 + x1831) + x1832)
            + x100 * x1826
            + 0.5 * x1836
            + x24 * x623
            + x81 * (x1781 * x272 + x1782 * x280),
            x0 * x1848
            + x0 * x1853
            + x0 * (x0 * (x0 * x1857 + x1852) + x1853)
            + x100 * x1846
            + x1859
            + x24 * x649
            + x81 * (x1861 + x1862 * x81),
            x0 * x1867
            + x0 * x1872
            + x0 * (x0 * (x0 * x1875 + x1871) + x1872)
            + 3.0 * x1876
            + x1877 * x81
            + x24 * x673,
            x0 * x1882
            + x0 * x1887
            + x0 * (x0 * (x0 * x1889 + x1886) + x1887)
            + 3.0 * x1890
            + x1891 * x81
            + x24 * x689,
            x0 * x1896
            + x0 * x1901
            + x0 * (x0 * (x0 * x1903 + x1900) + x1901)
            + 3.0 * x1904
            + x1905 * x81
            + x24 * x704,
            x0 * x1907
            + x0 * x1911
            + x0 * (x0 * (x0 * x1913 + x1910) + x1911)
            + x1861 * x272
            + x1862 * x280
            + x24 * x716,
            x0 * x1919
            + x0 * x1924
            + x0 * (x0 * (x0 * x1926 + x1923) + x1924)
            + 3.0 * x1927
            + x1928 * x81
            + x24 * x727,
            x0 * x1930
            + x0 * x1933
            + x0 * (x0 * (x0 * x1935 + x1932) + x1933)
            + x153 * x1800
            + x1877 * x272
            + x24 * x739,
            x0 * x1937
            + x0 * x1940
            + x0 * (x0 * (x0 * x1942 + x1939) + x1940)
            + x171 * x1820
            + x1891 * x272
            + x24 * x746,
            x0 * x1944
            + x0 * x1947
            + x0 * (x0 * (x0 * x1949 + x1946) + x1947)
            + x1836
            + x1905 * x272
            + x24 * x753,
            x0 * x1951
            + x0 * x1954
            + x0 * (x0 * (x0 * x1956 + x1953) + x1954)
            + x1859
            + x1862 * x417
            + x24 * x760,
            x0 * x1958
            + x0 * x1961
            + x0 * (x0 * (x0 * x1963 + x1960) + x1961)
            + x1928 * x272
            + x24 * x767,
            x0 * x1965
            + x0 * x1968
            + x0 * (x0 * (x0 * x1970 + x1967) + x1968)
            + x153 * x1858
            + x1928 * x341
            + x24 * x774
            + x737,
            x0 * x2035
            + x0 * (x0 * x2038 + x2035)
            + x153
            * (
                x1 * (2.0 * x2039 - x2046 * x74 + x2050 * x81)
                + x2023 * x88
                + x2069 * x81
                - x74 * (x1 * (x2046 - x2059) + x2020 * x88 + x2067 * x8)
            )
            + x2032 * x88
            + x23 * x885
            + x23 * x886
            + x81
            * (
                x171 * (-x2067 + x2069)
                + x2031 * x88
                + x81
                * (
                    x1 * (x2058 - x2066)
                    + x2030 * x88
                    + x81 * (x2029 * x88 + x2070 + x81 * (x2072 + x2076 * x81))
                )
            ),
            x0 * x2107
            + x0 * (x0 * x2114 + x2107)
            + x171
            * (
                x2098 * x88
                + 0.5 * x2116
                + x2124 * x81
                - x74 * (x2095 * x88 + 0.5 * x2120 + x2123 * x8)
            )
            + x2104 * x88
            + x23 * x975
            + x23 * x976
            + x81
            * (
                x1 * (-x2123 + x2124)
                + x2103 * x88
                + x81 * (x2102 * x88 + 0.5 * x2125 + x81 * (x2101 * x88 + x2127 * x81))
            ),
            x0 * x2151
            + x0 * (x0 * x2158 + x2151)
            + x1034 * x23
            + x1035 * x23
            + x171
            * (
                x2142 * x88
                + x2160
                + x2166 * x81
                - x74 * (x2139 * x88 + x2163 + x2165 * x8)
            )
            + x2148 * x88
            + x81
            * (
                x1 * (-x2165 + x2166)
                + x2147 * x88
                + x81 * (x2146 * x88 + x2168 + x81 * (x2072 * x341 + x2076 * x349))
            ),
            x0 * x2189
            + x0 * (x0 * x2192 + x2189)
            + x1 * (x2169 * x88 + x2172 * x81 - x74 * (x2170 * x88 + x2171 * x8))
            + x1082 * x23
            + x1083 * x23
            + x2186 * x88
            + x81 * (x2185 * x88 + x2193 * x85 + x81 * (x2184 * x88 + x2194 * x81)),
            x0 * x2215
            + x0 * (x0 * x2218 + x2215)
            + x1 * (x2195 * x88 + x2198 * x81 - x74 * (x2196 * x88 + x2197 * x8))
            + x1127 * x23
            + x1128 * x23
            + x2212 * x88
            + x81 * (x2211 * x88 + 0.5 * x2219 + x81 * (x2210 * x88 + x2220 * x81)),
            x0 * x2245
            + x0 * (x0 * x2248 + x2245)
            + x1 * (2.0 * x2222 + x2226 * x81 - x74 * (2.0 * x2224 + x2225 * x8))
            + x1172 * x23
            + x1173 * x23
            + x2242 * x88
            + x81 * (x2241 * x88 + x2250 + x81 * (2.0 * x2251 + x2252 * x81)),
            x0 * x2260
            + x0 * (x0 * x2264 + x2260)
            + x1199 * x23
            + x1200 * x23
            + x2257 * x88
            + x2265 * x85
            + x81 * (x2256 * x88 + x2266 * x81),
            x0 * x2274
            + x0 * (x0 * x2278 + x2274)
            + x1218 * x23
            + x1219 * x23
            + x2271 * x88
            + x2279 * x85
            + x81 * (x2270 * x88 + x2280 * x81),
            x0 * x2288
            + x0 * (x0 * x2292 + x2288)
            + x1237 * x23
            + x1238 * x23
            + x2285 * x88
            + 0.5 * x2293
            + x81 * (x2284 * x88 + x2294 * x81),
            x0 * x2303
            + x0 * (x0 * x2308 + x2303)
            + x1258 * x23
            + x1259 * x23
            + x2300 * x88
            + x2310
            + x81 * (2.0 * x2311 + x2312 * x81),
            x0 * x2318
            + x0 * (x0 * x2321 + x2318)
            + x1276 * x23
            + x1277 * x23
            + x2315 * x88
            + x2322 * x81,
            x0 * x2328
            + x0 * (x0 * x2331 + x2328)
            + x1290 * x23
            + x1291 * x23
            + x2325 * x88
            + x2332 * x81,
            x0 * x2338
            + x0 * (x0 * x2341 + x2338)
            + x1303 * x23
            + x1304 * x23
            + x2335 * x88
            + x2342 * x81,
            x0 * x2348
            + x0 * (x0 * x2351 + x2348)
            + x1316 * x23
            + x1317 * x23
            + x2345 * x88
            + x2352 * x81,
            x0 * x2358
            + x0 * (x0 * x2361 + x2358)
            + x1330 * x23
            + x1331 * x23
            + 2.0 * x2362
            + x2363 * x81,
            x0 * x2366
            + x0 * (x0 * x2369 + x2366)
            + x1275 * x88
            + x1341 * x23
            + x1342 * x23
            + x153 * x2265
            + x2322 * x272,
            x0 * x2372
            + x0 * (x0 * x2375 + x2372)
            + x1289 * x88
            + x1348 * x23
            + x1349 * x23
            + x171 * x2279
            + x2332 * x272,
            x0 * x2378
            + x0 * (x0 * x2381 + x2378)
            + x1302 * x88
            + x1355 * x23
            + x1356 * x23
            + x2293
            + x2342 * x272,
            x0 * x2384
            + x0 * (x0 * x2387 + x2384)
            + x1315 * x88
            + x1362 * x23
            + x1363 * x23
            + x2310
            + x2352 * x272,
            x0 * x2390
            + x0 * (x0 * x2393 + x2390)
            + 2.0 * x1339
            + x1369 * x23
            + x1370 * x23
            + x2363 * x272,
            x0 * x2396
            + x0 * (x0 * x2399 + x2396)
            + x1376 * x23
            + x1377 * x23
            + x153 * x2309
            + x2363 * x341,
            x0 * x2461
            + x0 * (x0 * x2464 + x2461)
            + x1491 * x23
            + x153
            * (
                x1 * (x2465 - x2471 * x74 + x2475 * x81)
                + x2449 * x88
                + x2490 * x81
                - x74 * (x1 * (x2471 - x2482) + x2446 * x88 + x2488 * x8)
            )
            + x24 * x885
            + x2458 * x88
            + x81
            * (
                x171 * (-x2488 + x2490)
                + x2457 * x88
                + x81
                * (
                    x1 * (x2481 - x2487)
                    + x2456 * x88
                    + x81 * (x2455 * x88 + x2491 + x81 * (x2492 + x2495 * x81))
                )
            ),
            x0 * x2523
            + x0 * (x0 * x2530 + x2523)
            + x1567 * x23
            + x171
            * (
                x2514 * x88
                + 0.5 * x2532
                + x2540 * x81
                - x74 * (x2511 * x88 + 0.5 * x2535 + x2538 * x8)
            )
            + x24 * x975
            + x2520 * x88
            + x81
            * (
                x1 * (-x2538 + x2540)
                + x2519 * x88
                + x81 * (x2518 * x88 + 0.5 * x2541 + x81 * (x2542 + x2543 * x81))
            ),
            x0 * x2575
            + x0 * (x0 * x2584 + x2575)
            + x1034 * x24
            + x1634 * x23
            + x171
            * (
                x2565 * x88
                + x2587
                + x2596 * x81
                - x74 * (x2562 * x88 + x2591 + x2594 * x8)
            )
            + x2572 * x88
            + x81
            * (
                x1 * (-x2594 + x2596)
                + x2571 * x88
                + x81 * (x2570 * x88 + x2598 + x81 * (x2599 + x2600 * x81))
            ),
            x0 * x2623
            + x0 * (x0 * x2626 + x2623)
            + x1 * (x2602 + x2606 * x81 - x74 * (x2604 + x2605 * x8))
            + x1082 * x24
            + x1696 * x23
            + x2620 * x88
            + x81 * (x2619 * x88 + x2627 * x85 + x81 * (x2628 + x2629 * x81)),
            x0 * x2652
            + x0 * (x0 * x2655 + x2652)
            + x1 * (x2631 + x2635 * x81 - x74 * (x2633 + x2634 * x8))
            + x1127 * x24
            + x1723 * x23
            + x2649 * x88
            + x81 * (x2648 * x88 + 0.5 * x2656 + x81 * (x2657 + x2658 * x81)),
            x0 * x2683
            + x0 * (x0 * x2686 + x2683)
            + x1 * (x2660 + x2664 * x81 - x74 * (x2662 + x2663 * x8))
            + x1172 * x24
            + x1764 * x23
            + x2680 * x88
            + x81 * (x2679 * x88 + x2688 + x81 * (x2689 + x2690 * x81)),
            x0 * x2698
            + x0 * (x0 * x2702 + x2698)
            + x1199 * x24
            + x1792 * x23
            + x2695 * x88
            + x2703 * x85
            + x81 * (x2704 + x2705 * x81),
            x0 * x2713
            + x0 * (x0 * x2717 + x2713)
            + x1218 * x24
            + x1812 * x23
            + x2710 * x88
            + x2718 * x85
            + x81 * (x2719 + x2720 * x81),
            x0 * x2728
            + x0 * (x0 * x2732 + x2728)
            + x1237 * x24
            + x1828 * x23
            + x2725 * x88
            + 0.5 * x2733
            + x81 * (x2734 + x2735 * x81),
            x0 * x2744
            + x0 * (x0 * x2749 + x2744)
            + x1258 * x24
            + x1848 * x23
            + x2741 * x88
            + x2751
            + x81 * (x2752 + x2753 * x81),
            x0 * x2759
            + x0 * (x0 * x2762 + x2759)
            + x1276 * x24
            + x1867 * x23
            + x2763
            + x2764 * x81,
            x0 * x2770
            + x0 * (x0 * x2773 + x2770)
            + x1290 * x24
            + x1882 * x23
            + x2774
            + x2775 * x81,
            x0 * x2781
            + x0 * (x0 * x2784 + x2781)
            + x1303 * x24
            + x1896 * x23
            + x2785
            + x2786 * x81,
            x0 * x2792
            + x0 * (x0 * x2795 + x2792)
            + x1316 * x24
            + x1907 * x23
            + x2796
            + x2797 * x81,
            x0 * x2803
            + x0 * (x0 * x2806 + x2803)
            + x1330 * x24
            + x1919 * x23
            + x2807
            + x2808 * x81,
            x0 * x2811
            + x0 * (x0 * x2814 + x2811)
            + x1341 * x24
            + x153 * x2703
            + x1876
            + x1930 * x23
            + x272 * x2764,
            x0 * x2817
            + x0 * (x0 * x2820 + x2817)
            + x1348 * x24
            + x171 * x2718
            + x1890
            + x1937 * x23
            + x272 * x2775,
            x0 * x2823
            + x0 * (x0 * x2826 + x2823)
            + x1355 * x24
            + x1904
            + x1944 * x23
            + x272 * x2786
            + x2733,
            x0 * x2829
            + x0 * (x0 * x2832 + x2829)
            + x1362 * x24
            + x1860 * x272
            + x1951 * x23
            + x272 * x2797
            + x2751,
            x0 * x2835
            + x0 * (x0 * x2838 + x2835)
            + x1369 * x24
            + x1927
            + x1958 * x23
            + x272 * x2808,
            x0 * x2841
            + x0 * (x0 * x2844 + x2841)
            + x1339
            + x1376 * x24
            + x153 * x2750
            + x1965 * x23
            + x2808 * x341,
            x0 * x2909
            + x0 * (x0 * x2912 + x2909)
            + x1490 * x24
            + x1491 * x24
            + x153
            * (
                x1 * (2.0 * x2913 - x2920 * x74 + x2924 * x81)
                + x2897 * x88
                + x2945 * x81
                - x74 * (x1 * (x2920 - x2933) + x2894 * x88 + x2942 * x8)
            )
            + x2906 * x88
            + x81
            * (
                x171 * (-x2942 + x2945)
                + x2905 * x88
                + x81
                * (
                    x1 * (x2932 - x2941)
                    + x2904 * x88
                    + x81 * (x2903 * x88 + x2947 + x81 * (x2949 + x2953 * x81))
                )
            ),
            x0 * x2973
            + x0 * (x0 * x2978 + x2973)
            + x1566 * x24
            + x1567 * x24
            + x171
            * (
                x2965 * x88
                + 0.5 * x2979
                + x2984 * x81
                - x74 * (x2962 * x88 + 0.5 * x2981 + x2983 * x8)
            )
            + x2970 * x88
            + x81
            * (
                x1 * (-x2983 + x2984)
                + x2969 * x88
                + x81 * (x2968 * x88 + 0.5 * x2985 + x81 * (x272 * x2949 + x280 * x2953))
            ),
            x0 * x3017
            + x0 * (x0 * x3026 + x3017)
            + x1633 * x24
            + x1634 * x24
            + x171
            * (
                x3007 * x88
                + x3029
                + x3041 * x81
                - x74 * (x3004 * x88 + x3033 + x3038 * x8)
            )
            + x3014 * x88
            + x81
            * (
                x1 * (-x3038 + x3041)
                + x3013 * x88
                + x81 * (x3012 * x88 + x3043 + x81 * (x3045 + x3046 * x81))
            ),
            x0 * x3069
            + x0 * (x0 * x3072 + x3069)
            + x1 * (2.0 * x3048 + x3052 * x81 - x74 * (2.0 * x3050 + x3051 * x8))
            + x1695 * x24
            + x1696 * x24
            + x3066 * x88
            + x81 * (x3065 * x88 + x3073 * x85 + x81 * (2.0 * x3074 + x3075 * x81)),
            x0 * x3088
            + x0 * (x0 * x3091 + x3088)
            + x1 * (x272 * x3040 + x280 * x3030 - x74 * (x272 * x3035 + x3076 * x8))
            + x1722 * x24
            + x1723 * x24
            + x3085 * x88
            + x81 * (x3084 * x88 + 0.5 * x3092 + x81 * (x272 * x3045 + x280 * x3046)),
            x0 * x3118
            + x0 * (x0 * x3121 + x3118)
            + x1 * (2.0 * x3094 + x3099 * x81 - x74 * (2.0 * x3096 + x3098 * x8))
            + x1763 * x24
            + x1764 * x24
            + x3115 * x88
            + x81 * (x3114 * x88 + x3123 + x81 * (x3125 + x3126 * x81)),
            x0 * x3134
            + x0 * (x0 * x3138 + x3134)
            + x1791 * x24
            + x1792 * x24
            + x3131 * x88
            + x3139 * x85
            + x81 * (2.0 * x3140 + x3141 * x81),
            x0 * x3149
            + x0 * (x0 * x3153 + x3149)
            + x1811 * x24
            + x1812 * x24
            + x3146 * x88
            + x3154 * x85
            + x81 * (2.0 * x3155 + x3156 * x81),
            x0 * x3162
            + x0 * (x0 * x3166 + x3162)
            + x1827 * x24
            + x1828 * x24
            + x3159 * x88
            + 0.5 * x3167
            + x81 * (x272 * x3125 + x280 * x3126),
            x0 * x3176
            + x0 * (x0 * x3181 + x3176)
            + x1847 * x24
            + x1848 * x24
            + x3173 * x88
            + x3183
            + x81 * (x3185 + x3186 * x81),
            x0 * x3192
            + x0 * (x0 * x3195 + x3192)
            + x1866 * x24
            + x1867 * x24
            + 2.0 * x3196
            + x3197 * x81,
            x0 * x3203
            + x0 * (x0 * x3206 + x3203)
            + x1881 * x24
            + x1882 * x24
            + 2.0 * x3207
            + x3208 * x81,
            x0 * x3214
            + x0 * (x0 * x3217 + x3214)
            + x1895 * x24
            + x1896 * x24
            + 2.0 * x3218
            + x3219 * x81,
            x0 * x3223
            + x0 * (x0 * x3226 + x3223)
            + x1906 * x24
            + x1907 * x24
            + x272 * x3185
            + x280 * x3186,
            x0 * x3232
            + x0 * (x0 * x3235 + x3232)
            + x1918 * x24
            + x1919 * x24
            + 2.0 * x3236
            + x3237 * x81,
            x0 * x3240
            + x0 * (x0 * x3243 + x3240)
            + x153 * x3139
            + x1929 * x24
            + x1930 * x24
            + x272 * x3197,
            x0 * x3246
            + x0 * (x0 * x3249 + x3246)
            + x171 * x3154
            + x1936 * x24
            + x1937 * x24
            + x272 * x3208,
            x0 * x3252
            + x0 * (x0 * x3255 + x3252)
            + x1943 * x24
            + x1944 * x24
            + x272 * x3219
            + x3167,
            x0 * x3258
            + x0 * (x0 * x3261 + x3258)
            + x1950 * x24
            + x1951 * x24
            + x3183
            + x3186 * x417,
            x0 * x3264
            + x0 * (x0 * x3267 + x3264)
            + x1957 * x24
            + x1958 * x24
            + x272 * x3237,
            x0 * x3270
            + x0 * (x0 * x3273 + x3270)
            + x153 * x3182
            + 2.0 * x1927
            + x1964 * x24
            + x1965 * x24
            + x3237 * x341,
            x0 * x3297
            + x153
            * (
                x1 * (x3298 - x3303 * x74 + x3305 * x81)
                + x3 * x3286
                + x3319 * x81
                - x74 * (x1 * (x3303 - x3311) + x3 * x3280 + x3317 * x8)
            )
            + x2033 * x23
            + x2034 * x23
            + x2035 * x23
            + x3 * x3292
            + x81
            * (
                x171 * (-x3317 + x3319)
                + x3 * x3291
                + x81
                * (
                    x1 * (x3310 - x3316)
                    + x3 * x3290
                    + x81 * (x3320 + x3321 * x81 + x81 * (x3321 + x3323 * x81))
                )
            ),
            x0 * x3341
            + x171
            * (
                0.5 * x3343
                + x3352 * x81
                + x3353 * x81
                - x74 * (0.5 * x3347 + x3348 * x81 + x3351 * x8)
            )
            + x2105 * x23
            + x2106 * x23
            + x2107 * x23
            + x3 * x3333
            + x81
            * (
                x1 * (-x3351 + x3353)
                + x3 * x3332
                + x81 * (0.5 * x3354 + x3355 * x81 + x81 * (x3355 + x3357 * x81))
            ),
            x0 * x3369
            + x171
            * (
                x3306 * x349
                + x3371
                + x3379 * x81
                - x74 * (x3313 * x349 + x3374 + x3377 * x8)
            )
            + x2149 * x23
            + x2150 * x23
            + x2151 * x23
            + x3 * x3361
            + x81
            * (
                x1 * (-x3377 + x3379)
                + x3 * x3360
                + x81 * (x3321 * x349 + x3381 + x81 * (x3323 * x349 + x3382))
            ),
            x0 * x3396
            + x1 * (x3384 + x3388 * x81 - x74 * (x3386 + x3387 * x8))
            + x2187 * x23
            + x2188 * x23
            + x2189 * x23
            + x3 * x3392
            + x81 * (x3397 * x85 + x3398 * x81 + x81 * (x3398 + x3399 * x81)),
            x0 * x3413
            + x1 * (x3401 + x3405 * x81 - x74 * (x3403 + x3404 * x8))
            + x2213 * x23
            + x2214 * x23
            + x2215 * x23
            + x3 * x3409
            + x81 * (0.5 * x3414 + x3415 * x81 + x81 * (x3415 + x3416 * x81)),
            x0 * x3431
            + x1 * (x3418 + x3422 * x81 - x74 * (x3420 + x3421 * x8))
            + x2243 * x23
            + x2244 * x23
            + x2245 * x23
            + x3 * x3427
            + x81 * (x3433 + x3434 * x81 + x81 * (x3434 + x3435 * x81)),
            x0 * x3441
            + x2258 * x23
            + x2259 * x23
            + x2260 * x23
            + x3442 * x85
            + x3443 * x81
            + x81 * (x3443 + x3444 * x81),
            x0 * x3450
            + x2272 * x23
            + x2273 * x23
            + x2274 * x23
            + x3451 * x85
            + x3452 * x81
            + x81 * (x3452 + x3453 * x81),
            x0 * x3459
            + x2286 * x23
            + x2287 * x23
            + x2288 * x23
            + 0.5 * x3460
            + x3461 * x81
            + x81 * (x3461 + x3462 * x81),
            x0 * x3469
            + x23 * x2301
            + x23 * x2302
            + x23 * x2303
            + x3471
            + x3472 * x81
            + x81 * (x3472 + x3473 * x81),
            x0 * x3479 + x23 * x2316 + x23 * x2317 + x23 * x2318 + x3475 + x3480 * x81,
            x0 * x3486 + x23 * x2326 + x23 * x2327 + x23 * x2328 + x3482 + x3487 * x81,
            x0 * x3493 + x23 * x2336 + x23 * x2337 + x23 * x2338 + x3489 + x3494 * x81,
            x0 * x3500 + x23 * x2346 + x23 * x2347 + x23 * x2348 + x3496 + x3501 * x81,
            x0 * x3507 + x23 * x2356 + x23 * x2357 + x23 * x2358 + x3503 + x3508 * x81,
            x0 * x3512
            + x100 * x2315
            + x153 * x3442
            + x23 * x2364
            + x23 * x2365
            + x23 * x2366
            + x272 * x3480,
            x0 * x3516
            + x100 * x2325
            + x171 * x3451
            + x23 * x2370
            + x23 * x2371
            + x23 * x2372
            + x272 * x3487,
            x0 * x3520
            + x100 * x2335
            + x23 * x2376
            + x23 * x2377
            + x23 * x2378
            + x272 * x3494
            + x3460,
            x0 * x3524
            + x100 * x2345
            + x23 * x2382
            + x23 * x2383
            + x23 * x2384
            + x272 * x3501
            + x3471,
            x0 * x3528
            + x23 * x2388
            + x23 * x2389
            + x23 * x2390
            + 3.0 * x2362
            + x272 * x3508,
            x0 * x3532
            + x153 * x3470
            + x23 * x2394
            + x23 * x2395
            + x23 * x2396
            + x341 * x3508,
            x0 * x3556
            + x153
            * (
                x1 * (x3557 - x3561 * x74 + x3563 * x81)
                + x3 * x3545
                + x3575 * x81
                - x74 * (x1 * (x3561 - x3568) + x3 * x3539 + x3573 * x8)
            )
            + x2033 * x24
            + x23 * x2460
            + x23 * x2461
            + x3 * x3551
            + x81
            * (
                x171 * (-x3573 + x3575)
                + x3 * x3550
                + x81
                * (
                    x1 * (x3567 - x3572)
                    + x3 * x3549
                    + x81 * (x3576 + x3577 * x81 + x81 * (x3577 + x3579 * x81))
                )
            ),
            x0 * x3599
            + x171
            * (
                0.5 * x3601
                + x3608 * x81
                + x3609 * x81
                - x74 * (0.5 * x3604 + x3605 * x81 + x3607 * x8)
            )
            + x2105 * x24
            + x23 * x2522
            + x23 * x2523
            + x3 * x3589
            + x81
            * (
                x1 * (-x3607 + x3609)
                + x3 * x3588
                + x81 * (0.5 * x3610 + x3611 * x81 + x81 * (x3611 + x3612 * x81))
            ),
            x0 * x3630
            + x171
            * (
                x3633
                + x3641 * x81
                + x3642 * x81
                - x74 * (x3637 + x3638 * x81 + x3640 * x8)
            )
            + x2149 * x24
            + x23 * x2574
            + x23 * x2575
            + x3 * x3620
            + x81
            * (
                x1 * (-x3640 + x3642)
                + x3 * x3619
                + x81 * (x3644 + x3645 * x81 + x81 * (x3645 + x3646 * x81))
            ),
            x0 * x3660
            + x1 * (x3648 + x3652 * x81 - x74 * (x3650 + x3651 * x8))
            + x2187 * x24
            + x23 * x2622
            + x23 * x2623
            + x3 * x3656
            + x81 * (x3661 * x85 + x3662 * x81 + x81 * (x3662 + x3663 * x81)),
            x0 * x3680
            + x1 * (x3666 + x3671 * x81 - x74 * (x3669 + x3670 * x8))
            + x2213 * x24
            + x23 * x2651
            + x23 * x2652
            + x3 * x3676
            + x81 * (0.5 * x3681 + x3682 * x81 + x81 * (x3682 + x3683 * x81)),
            x0 * x3698
            + x1 * (x3685 + x3689 * x81 - x74 * (x3687 + x3688 * x8))
            + x2243 * x24
            + x23 * x2682
            + x23 * x2683
            + x3 * x3694
            + x81 * (x3700 + x3701 * x81 + x81 * (x3701 + x3702 * x81)),
            x0 * x3708
            + x2258 * x24
            + x23 * x2697
            + x23 * x2698
            + x3709 * x85
            + x3710 * x81
            + x81 * (x3710 + x3711 * x81),
            x0 * x3717
            + x2272 * x24
            + x23 * x2712
            + x23 * x2713
            + x3718 * x85
            + x3719 * x81
            + x81 * (x3719 + x3720 * x81),
            x0 * x3729
            + x2286 * x24
            + x23 * x2727
            + x23 * x2728
            + 0.5 * x3730
            + x3731 * x81
            + x81 * (x3731 + x3732 * x81),
            x0 * x3739
            + x23 * x2743
            + x23 * x2744
            + x2301 * x24
            + x3741
            + x3742 * x81
            + x81 * (x3742 + x3743 * x81),
            x0 * x3749 + x23 * x2758 + x23 * x2759 + x2316 * x24 + x3745 + x3750 * x81,
            x0 * x3756 + x23 * x2769 + x23 * x2770 + x2326 * x24 + x3752 + x3757 * x81,
            x0 * x3763 + x23 * x2780 + x23 * x2781 + x2336 * x24 + x3759 + x3764 * x81,
            x0 * x3771 + x23 * x2791 + x23 * x2792 + x2346 * x24 + x3767 + x3772 * x81,
            x0 * x3778 + x23 * x2802 + x23 * x2803 + x2356 * x24 + x3774 + x3779 * x81,
            x0 * x3783
            + x153 * x3709
            + x23 * x2810
            + x23 * x2811
            + x2364 * x24
            + x272 * x3750
            + x2763,
            x0 * x3787
            + x171 * x3718
            + x23 * x2816
            + x23 * x2817
            + x2370 * x24
            + x272 * x3757
            + x2774,
            x0 * x3791
            + x23 * x2822
            + x23 * x2823
            + x2376 * x24
            + x272 * x3764
            + x2785
            + x3730,
            x0 * x3795
            + x23 * x2828
            + x23 * x2829
            + x2382 * x24
            + x272 * x3772
            + x2796
            + x3741,
            x0 * x3800 + x23 * x2834 + x23 * x2835 + x2388 * x24 + x272 * x3779 + x2807,
            x0 * x3804
            + x153 * x3740
            + x23 * x2840
            + x23 * x2841
            + x2362
            + x2394 * x24
            + x341 * x3779,
            x0 * x3828
            + x153
            * (
                x1 * (x3829 - x3833 * x74 + x3835 * x81)
                + x3 * x3817
                + x3847 * x81
                - x74 * (x1 * (x3833 - x3840) + x3 * x3811 + x3845 * x8)
            )
            + x23 * x2909
            + x24 * x2459
            + x24 * x2460
            + x3 * x3823
            + x81
            * (
                x171 * (-x3845 + x3847)
                + x3 * x3822
                + x81
                * (
                    x1 * (x3839 - x3844)
                    + x3 * x3821
                    + x81 * (x3848 + x3849 * x81 + x81 * (x3849 + x3851 * x81))
                )
            ),
            x0 * x3866
            + x171
            * (
                0.5 * x3868
                + x3875 * x81
                + x3876 * x81
                - x74 * (0.5 * x3871 + x3872 * x81 + x3874 * x8)
            )
            + x23 * x2973
            + x24 * x2521
            + x24 * x2522
            + x3 * x3858
            + x81
            * (
                x1 * (-x3874 + x3876)
                + x3 * x3857
                + x81 * (0.5 * x3877 + x3878 * x81 + x81 * (x3878 + x3879 * x81))
            ),
            x0 * x3897
            + x171
            * (
                x3900
                + x3908 * x81
                + x3909 * x81
                - x74 * (x3904 + x3905 * x81 + x3907 * x8)
            )
            + x23 * x3017
            + x24 * x2573
            + x24 * x2574
            + x3 * x3887
            + x81
            * (
                x1 * (-x3907 + x3909)
                + x3 * x3886
                + x81 * (x3911 + x3912 * x81 + x81 * (x3912 + x3913 * x81))
            ),
            x0 * x3927
            + x1 * (x3915 + x3919 * x81 - x74 * (x3917 + x3918 * x8))
            + x23 * x3069
            + x24 * x2621
            + x24 * x2622
            + x3 * x3923
            + x81 * (x3928 * x85 + x3929 * x81 + x81 * (x3929 + x3930 * x81)),
            x0 * x3944
            + x1 * (x3932 + x3936 * x81 - x74 * (x3934 + x3935 * x8))
            + x23 * x3088
            + x24 * x2650
            + x24 * x2651
            + x3 * x3940
            + x81 * (0.5 * x3945 + x3946 * x81 + x81 * (x3946 + x3947 * x81)),
            x0 * x3962
            + x1 * (x3949 + x3953 * x81 - x74 * (x3951 + x3952 * x8))
            + x23 * x3118
            + x24 * x2681
            + x24 * x2682
            + x3 * x3958
            + x81 * (x3964 + x3965 * x81 + x81 * (x3965 + x3966 * x81)),
            x0 * x3972
            + x23 * x3134
            + x24 * x2696
            + x24 * x2697
            + x3973 * x85
            + x3974 * x81
            + x81 * (x3974 + x3975 * x81),
            x0 * x3981
            + x23 * x3149
            + x24 * x2711
            + x24 * x2712
            + x3982 * x85
            + x3983 * x81
            + x81 * (x3983 + x3984 * x81),
            x0 * x3990
            + x23 * x3162
            + x24 * x2726
            + x24 * x2727
            + 0.5 * x3991
            + x3992 * x81
            + x81 * (x3992 + x3993 * x81),
            x0 * x4000
            + x23 * x3176
            + x24 * x2742
            + x24 * x2743
            + x4002
            + x4003 * x81
            + x81 * (x4003 + x4004 * x81),
            x0 * x4010 + x23 * x3192 + x24 * x2757 + x24 * x2758 + x4006 + x4011 * x81,
            x0 * x4017 + x23 * x3203 + x24 * x2768 + x24 * x2769 + x4013 + x4018 * x81,
            x0 * x4024 + x23 * x3214 + x24 * x2779 + x24 * x2780 + x4020 + x4025 * x81,
            x0 * x4031 + x23 * x3223 + x24 * x2790 + x24 * x2791 + x4027 + x4032 * x81,
            x0 * x4038 + x23 * x3232 + x24 * x2801 + x24 * x2802 + x4034 + x4039 * x81,
            x0 * x4043
            + x153 * x3973
            + x23 * x3240
            + x24 * x2809
            + x24 * x2810
            + x272 * x4011
            + x3196,
            x0 * x4047
            + x171 * x3982
            + x23 * x3246
            + x24 * x2815
            + x24 * x2816
            + x272 * x4018
            + x3207,
            x0 * x4051
            + x23 * x3252
            + x24 * x2821
            + x24 * x2822
            + x272 * x4025
            + x3218
            + x3991,
            x0 * x4055
            + x23 * x3258
            + x24 * x2827
            + x24 * x2828
            + x272 * x3184
            + x272 * x4032
            + x4002,
            x0 * x4059 + x23 * x3264 + x24 * x2833 + x24 * x2834 + x272 * x4039 + x3236,
            x0 * x4063
            + x153 * x4001
            + x23 * x3270
            + x24 * x2839
            + x24 * x2840
            + x2807
            + x341 * x4039,
            x0 * x4087
            + x153
            * (
                x1 * (x4088 - x4093 * x74 + x4095 * x81)
                + x3 * x4076
                + x4109 * x81
                - x74 * (x1 * (x4093 - x4101) + x3 * x4070 + x4107 * x8)
            )
            + x24 * x2907
            + x24 * x2908
            + x24 * x2909
            + x3 * x4082
            + x81
            * (
                x171 * (-x4107 + x4109)
                + x3 * x4081
                + x81
                * (
                    x1 * (x4100 - x4106)
                    + x3 * x4080
                    + x81 * (x4110 + x4111 * x81 + x81 * (x4111 + x4113 * x81))
                )
            ),
            x0 * x4122
            + x171
            * (
                x280 * x4096
                + 0.5 * x4123
                + x4130 * x81
                - x74 * (x280 * x4103 + 0.5 * x4125 + x4128 * x8)
            )
            + x24 * x2971
            + x24 * x2972
            + x24 * x2973
            + x3 * x4116
            + x81
            * (
                x1 * (-x4128 + x4130)
                + x3 * x4115
                + x81 * (x280 * x4111 + 0.5 * x4131 + x81 * (x280 * x4113 + x4132))
            ),
            x0 * x4150
            + x171
            * (
                x4153
                + x4162 * x81
                + x4163 * x81
                - x74 * (x4157 + x4158 * x81 + x4161 * x8)
            )
            + x24 * x3015
            + x24 * x3016
            + x24 * x3017
            + x3 * x4140
            + x81
            * (
                x1 * (-x4161 + x4163)
                + x3 * x4139
                + x81 * (x4165 + x4166 * x81 + x81 * (x4166 + x4167 * x81))
            ),
            x0 * x4181
            + x1 * (x4169 + x4173 * x81 - x74 * (x4171 + x4172 * x8))
            + x24 * x3067
            + x24 * x3068
            + x24 * x3069
            + x3 * x4177
            + x81 * (x4182 * x85 + x4183 * x81 + x81 * (x4183 + x4184 * x81)),
            x0 * x4193
            + x1 * (x280 * x4154 + x4187 - x74 * (x4185 * x8 + x4186))
            + x24 * x3086
            + x24 * x3087
            + x24 * x3088
            + x3 * x4189
            + x81 * (x280 * x4166 + 0.5 * x4194 + x81 * (x280 * x4167 + x4195)),
            x0 * x4211
            + x1 * (x4197 + x4202 * x81 - x74 * (x4199 + x4201 * x8))
            + x24 * x3116
            + x24 * x3117
            + x24 * x3118
            + x3 * x4207
            + x81 * (x4213 + x4214 * x81 + x81 * (x4214 + x4215 * x81)),
            x0 * x4221
            + x24 * x3132
            + x24 * x3133
            + x24 * x3134
            + x4222 * x85
            + x4223 * x81
            + x81 * (x4223 + x4224 * x81),
            x0 * x4230
            + x24 * x3147
            + x24 * x3148
            + x24 * x3149
            + x4231 * x85
            + x4232 * x81
            + x81 * (x4232 + x4233 * x81),
            x0 * x4238
            + x24 * x3160
            + x24 * x3161
            + x24 * x3162
            + x280 * x4214
            + 0.5 * x4239
            + x81 * (x280 * x4215 + x4240),
            x0 * x4247
            + x24 * x3174
            + x24 * x3175
            + x24 * x3176
            + x4249
            + x4250 * x81
            + x81 * (x4250 + x4251 * x81),
            x0 * x4257 + x24 * x3190 + x24 * x3191 + x24 * x3192 + x4253 + x4258 * x81,
            x0 * x4264 + x24 * x3201 + x24 * x3202 + x24 * x3203 + x4260 + x4265 * x81,
            x0 * x4271 + x24 * x3212 + x24 * x3213 + x24 * x3214 + x4267 + x4272 * x81,
            x0 * x4276 + x24 * x3221 + x24 * x3222 + x24 * x3223 + x280 * x4251 + x4277,
            x0 * x4283 + x24 * x3230 + x24 * x3231 + x24 * x3232 + x4279 + x4284 * x81,
            x0 * x4288
            + x153 * x4222
            + x24 * x3238
            + x24 * x3239
            + x24 * x3240
            + x272 * x4258,
            x0 * x4292
            + x171 * x4231
            + x24 * x3244
            + x24 * x3245
            + x24 * x3246
            + x272 * x4265,
            x0 * x4296 + x24 * x3250 + x24 * x3251 + x24 * x3252 + x272 * x4272 + x4239,
            x0 * x4300 + x24 * x3256 + x24 * x3257 + x24 * x3258 + x417 * x4251 + x4249,
            x0 * x4304 + x24 * x3262 + x24 * x3263 + x24 * x3264 + x272 * x4284,
            x0 * x4308
            + x153 * x4248
            + x24 * x3268
            + x24 * x3269
            + x24 * x3270
            + 3.0 * x3236
            + x341 * x4284,
            x153
            * (
                x1 * (x17 * x4312 * x5 * x8 - x4310 * x467)
                + x4321 * x81
                - x74 * (x1 * (x17 * x4310 * x5 * x8 - x4314 * x467) + x4318 * x8)
            )
            + x23 * x3294
            + x23 * x3295
            + x23 * x3296
            + x23 * x3297
            + x81
            * (
                x171 * (-x4318 + x4321)
                + x81
                * (
                    x1 * (x17 * x4314 * x5 * x8 - x4317 * x467)
                    + x81 * (x4323 + x4324 * x462)
                )
            ),
            x171 * (0.5 * x4326 + x4328 * x462 - x74 * (0.5 * x4330 + x4332 * x462))
            + x23 * x3338
            + x23 * x3339
            + x23 * x3340
            + x23 * x3341
            + x81
            * (
                x1 * (x17 * x4328 * x5 * x8 - x4332 * x467)
                + x81 * (0.5 * x4334 + x4336 * x462)
            ),
            x171 * (x1009 * x4314 + x4338 - x74 * (x1009 * x4317 + x4340))
            + x23 * x3366
            + x23 * x3367
            + x23 * x3368
            + x23 * x3369
            + x81
            * (
                x1 * (-x1036 * x4317 + x14 * x267 * x268 * x4314 * x8)
                + x81 * (x1009 * x4324 + x4342)
            ),
            x1 * (x17 * x4344 * x5 * x8 - x4343 * x467)
            + x23 * x3393
            + x23 * x3394
            + x23 * x3395
            + x23 * x3396
            + x81 * (x4346 * x85 + x4347 * x462),
            x1 * (x17 * x4349 * x5 * x8 - x4348 * x467)
            + x23 * x3410
            + x23 * x3411
            + x23 * x3412
            + x23 * x3413
            + x81 * (0.5 * x4351 + x4352 * x462),
            x1 * (x17 * x4354 * x5 * x8 - x4353 * x467)
            + x23 * x3428
            + x23 * x3429
            + x23 * x3430
            + x23 * x3431
            + x81 * (x4357 + x4358 * x462),
            x23 * x3438
            + x23 * x3439
            + x23 * x3440
            + x23 * x3441
            + x4359 * x85
            + x4360 * x462,
            x23 * x3447
            + x23 * x3448
            + x23 * x3449
            + x23 * x3450
            + x4361 * x85
            + x4362 * x462,
            x23 * x3456
            + x23 * x3457
            + x23 * x3458
            + x23 * x3459
            + 0.5 * x4363
            + x4364 * x462,
            x23 * x3466 + x23 * x3467 + x23 * x3468 + x23 * x3469 + x4366 + x4367 * x462,
            x23 * x3476 + x23 * x3477 + x23 * x3478 + x23 * x3479 + x4368 * x81,
            x23 * x3483 + x23 * x3484 + x23 * x3485 + x23 * x3486 + x4369 * x81,
            x23 * x3490 + x23 * x3491 + x23 * x3492 + x23 * x3493 + x4370 * x81,
            x23 * x3497 + x23 * x3498 + x23 * x3499 + x23 * x3500 + x4371 * x81,
            x23 * x3504 + x23 * x3505 + x23 * x3506 + x23 * x3507 + x4372 * x81,
            x153 * x4359
            + x23 * x3509
            + x23 * x3510
            + x23 * x3511
            + x23 * x3512
            + x272 * x4368
            + 4.0 * x3475,
            x171 * x4361
            + x23 * x3513
            + x23 * x3514
            + x23 * x3515
            + x23 * x3516
            + x272 * x4369
            + 4.0 * x3482,
            x23 * x3517
            + x23 * x3518
            + x23 * x3519
            + x23 * x3520
            + x272 * x4370
            + 4.0 * x3489
            + x4363,
            x23 * x3521
            + x23 * x3522
            + x23 * x3523
            + x23 * x3524
            + x272 * x4371
            + 4.0 * x3496
            + x4366,
            x23 * x3525
            + x23 * x3526
            + x23 * x3527
            + x23 * x3528
            + x272 * x4372
            + 4.0 * x3503,
            x153 * x4365
            + x23 * x3529
            + x23 * x3530
            + x23 * x3531
            + x23 * x3532
            + x341 * x4372,
            x153
            * (
                x1 * (x17 * x4376 * x5 * x8 - x4374 * x467)
                + x4385 * x81
                - x74 * (x1 * (x17 * x4374 * x5 * x8 - x4378 * x467) + x4382 * x8)
            )
            + x23 * x3554
            + x23 * x3555
            + x23 * x3556
            + x24 * x3294
            + x81
            * (
                x171 * (-x4382 + x4385)
                + x81
                * (
                    x1 * (x17 * x4378 * x5 * x8 - x4381 * x467)
                    + x81 * (x4387 + x4388 * x462)
                )
            ),
            x171 * (0.5 * x4390 + x4391 * x462 - x74 * (0.5 * x4393 + x4394 * x462))
            + x23 * x3597
            + x23 * x3598
            + x23 * x3599
            + x24 * x3338
            + x81
            * (
                x1 * (x17 * x4391 * x5 * x8 - x4394 * x467)
                + x81 * (0.5 * x4396 + x4397 * x462)
            ),
            x171 * (x4400 + x4401 * x462 - x74 * (x4404 + x4405 * x462))
            + x23 * x3628
            + x23 * x3629
            + x23 * x3630
            + x24 * x3366
            + x81
            * (
                x1 * (x17 * x4401 * x5 * x8 - x4405 * x467) + x81 * (x4408 + x4409 * x462)
            ),
            x1 * (x17 * x4411 * x5 * x8 - x4410 * x467)
            + x23 * x3658
            + x23 * x3659
            + x23 * x3660
            + x24 * x3393
            + x81 * (x4413 * x85 + x4414 * x462),
            x1 * (x17 * x4416 * x5 * x8 - x4415 * x467)
            + x23 * x3678
            + x23 * x3679
            + x23 * x3680
            + x24 * x3410
            + x81 * (0.5 * x4418 + x4419 * x462),
            x1 * (x17 * x4421 * x5 * x8 - x4420 * x467)
            + x23 * x3696
            + x23 * x3697
            + x23 * x3698
            + x24 * x3428
            + x81 * (x4424 + x4425 * x462),
            x23 * x3706
            + x23 * x3707
            + x23 * x3708
            + x24 * x3438
            + x4426 * x85
            + x4427 * x462,
            x23 * x3715
            + x23 * x3716
            + x23 * x3717
            + x24 * x3447
            + x4428 * x85
            + x4429 * x462,
            x23 * x3727
            + x23 * x3728
            + x23 * x3729
            + x24 * x3456
            + 0.5 * x4430
            + x4431 * x462,
            x23 * x3737 + x23 * x3738 + x23 * x3739 + x24 * x3466 + x4433 + x4434 * x462,
            x23 * x3747 + x23 * x3748 + x23 * x3749 + x24 * x3476 + x4435 * x81,
            x23 * x3754 + x23 * x3755 + x23 * x3756 + x24 * x3483 + x4436 * x81,
            x23 * x3761 + x23 * x3762 + x23 * x3763 + x24 * x3490 + x4437 * x81,
            x23 * x3769 + x23 * x3770 + x23 * x3771 + x24 * x3497 + x4438 * x81,
            x23 * x3776 + x23 * x3777 + x23 * x3778 + x24 * x3504 + x4439 * x81,
            x153 * x4426
            + x23 * x3781
            + x23 * x3782
            + x23 * x3783
            + x24 * x3509
            + x272 * x4435
            + 3.0 * x3745,
            x171 * x4428
            + x23 * x3785
            + x23 * x3786
            + x23 * x3787
            + x24 * x3513
            + x272 * x4436
            + 3.0 * x3752,
            x23 * x3789
            + x23 * x3790
            + x23 * x3791
            + x24 * x3517
            + x272 * x4437
            + 3.0 * x3759
            + x4430,
            x23 * x3793
            + x23 * x3794
            + x23 * x3795
            + x24 * x3521
            + x272 * x4438
            + 3.0 * x3767
            + x4433,
            x23 * x3798
            + x23 * x3799
            + x23 * x3800
            + x24 * x3525
            + x272 * x4439
            + 3.0 * x3774,
            x153 * x4432
            + x23 * x3802
            + x23 * x3803
            + x23 * x3804
            + x24 * x3529
            + x341 * x4439
            + x3503,
            x153
            * (
                x1 * (x17 * x4443 * x5 * x8 - x4441 * x467)
                + x4452 * x81
                - x74 * (x1 * (x17 * x4441 * x5 * x8 - x4445 * x467) + x4449 * x8)
            )
            + x23 * x3827
            + x23 * x3828
            + x24 * x3553
            + x24 * x3554
            + x81
            * (
                x171 * (-x4449 + x4452)
                + x81
                * (
                    x1 * (x17 * x4445 * x5 * x8 - x4448 * x467)
                    + x81 * (x4454 + x4455 * x462)
                )
            ),
            x171 * (0.5 * x4457 + x4458 * x462 - x74 * (0.5 * x4460 + x4461 * x462))
            + x23 * x3865
            + x23 * x3866
            + x24 * x3596
            + x24 * x3597
            + x81
            * (
                x1 * (x17 * x4458 * x5 * x8 - x4461 * x467)
                + x81 * (0.5 * x4463 + x4464 * x462)
            ),
            x171 * (x4467 + x4468 * x462 - x74 * (x4471 + x4472 * x462))
            + x23 * x3896
            + x23 * x3897
            + x24 * x3627
            + x24 * x3628
            + x81
            * (
                x1 * (x17 * x4468 * x5 * x8 - x4472 * x467) + x81 * (x4475 + x4476 * x462)
            ),
            x1 * (x17 * x4478 * x5 * x8 - x4477 * x467)
            + x23 * x3926
            + x23 * x3927
            + x24 * x3657
            + x24 * x3658
            + x81 * (x4480 * x85 + x4481 * x462),
            x1 * (x17 * x4483 * x5 * x8 - x4482 * x467)
            + x23 * x3943
            + x23 * x3944
            + x24 * x3677
            + x24 * x3678
            + x81 * (0.5 * x4485 + x4486 * x462),
            x1 * (x17 * x4488 * x5 * x8 - x4487 * x467)
            + x23 * x3961
            + x23 * x3962
            + x24 * x3695
            + x24 * x3696
            + x81 * (x4491 + x4492 * x462),
            x23 * x3971
            + x23 * x3972
            + x24 * x3705
            + x24 * x3706
            + x4493 * x85
            + x4494 * x462,
            x23 * x3980
            + x23 * x3981
            + x24 * x3714
            + x24 * x3715
            + x4495 * x85
            + x4496 * x462,
            x23 * x3989
            + x23 * x3990
            + x24 * x3726
            + x24 * x3727
            + 0.5 * x4497
            + x4498 * x462,
            x23 * x3999 + x23 * x4000 + x24 * x3736 + x24 * x3737 + x4500 + x4501 * x462,
            x23 * x4009 + x23 * x4010 + x24 * x3746 + x24 * x3747 + x4502 * x81,
            x23 * x4016 + x23 * x4017 + x24 * x3753 + x24 * x3754 + x4503 * x81,
            x23 * x4023 + x23 * x4024 + x24 * x3760 + x24 * x3761 + x4504 * x81,
            x23 * x4030 + x23 * x4031 + x24 * x3768 + x24 * x3769 + x4505 * x81,
            x23 * x4037 + x23 * x4038 + x24 * x3775 + x24 * x3776 + x4506 * x81,
            x153 * x4493
            + x23 * x4042
            + x23 * x4043
            + x24 * x3780
            + x24 * x3781
            + x272 * x4502
            + 2.0 * x4006,
            x171 * x4495
            + x23 * x4046
            + x23 * x4047
            + x24 * x3784
            + x24 * x3785
            + x272 * x4503
            + 2.0 * x4013,
            x23 * x4050
            + x23 * x4051
            + x24 * x3788
            + x24 * x3789
            + x272 * x4504
            + 2.0 * x4020
            + x4497,
            x23 * x4054
            + x23 * x4055
            + x24 * x3792
            + x24 * x3793
            + x272 * x4505
            + 2.0 * x4027
            + x4500,
            x23 * x4058
            + x23 * x4059
            + x24 * x3797
            + x24 * x3798
            + x272 * x4506
            + 2.0 * x4034,
            x153 * x4499
            + x23 * x4062
            + x23 * x4063
            + x24 * x3801
            + x24 * x3802
            + x341 * x4506
            + 2.0 * x3774,
            x153
            * (
                x1 * (x17 * x4510 * x5 * x8 - x4508 * x467)
                + x4519 * x81
                - x74 * (x1 * (x17 * x4508 * x5 * x8 - x4512 * x467) + x4516 * x8)
            )
            + x23 * x4087
            + x24 * x3825
            + x24 * x3826
            + x24 * x3827
            + x81
            * (
                x171 * (-x4516 + x4519)
                + x81
                * (
                    x1 * (x17 * x4512 * x5 * x8 - x4515 * x467)
                    + x81 * (x4521 + x4522 * x462)
                )
            ),
            x171 * (0.5 * x4524 + x4525 * x462 - x74 * (0.5 * x4527 + x4528 * x462))
            + x23 * x4122
            + x24 * x3863
            + x24 * x3864
            + x24 * x3865
            + x81
            * (
                x1 * (x17 * x4525 * x5 * x8 - x4528 * x467)
                + x81 * (0.5 * x4530 + x4531 * x462)
            ),
            x171 * (x4534 + x4535 * x462 - x74 * (x4538 + x4539 * x462))
            + x23 * x4150
            + x24 * x3894
            + x24 * x3895
            + x24 * x3896
            + x81
            * (
                x1 * (x17 * x4535 * x5 * x8 - x4539 * x467) + x81 * (x4542 + x4543 * x462)
            ),
            x1 * (x17 * x4545 * x5 * x8 - x4544 * x467)
            + x23 * x4181
            + x24 * x3924
            + x24 * x3925
            + x24 * x3926
            + x81 * (x4547 * x85 + x4548 * x462),
            x1 * (x17 * x4550 * x5 * x8 - x4549 * x467)
            + x23 * x4193
            + x24 * x3941
            + x24 * x3942
            + x24 * x3943
            + x81 * (0.5 * x4552 + x4553 * x462),
            x1 * (x17 * x4555 * x5 * x8 - x4554 * x467)
            + x23 * x4211
            + x24 * x3959
            + x24 * x3960
            + x24 * x3961
            + x81 * (x4558 + x4559 * x462),
            x23 * x4221
            + x24 * x3969
            + x24 * x3970
            + x24 * x3971
            + x4560 * x85
            + x4561 * x462,
            x23 * x4230
            + x24 * x3978
            + x24 * x3979
            + x24 * x3980
            + x4562 * x85
            + x4563 * x462,
            x23 * x4238
            + x24 * x3987
            + x24 * x3988
            + x24 * x3989
            + 0.5 * x4564
            + x4565 * x462,
            x23 * x4247 + x24 * x3997 + x24 * x3998 + x24 * x3999 + x4567 + x4568 * x462,
            x23 * x4257 + x24 * x4007 + x24 * x4008 + x24 * x4009 + x4569 * x81,
            x23 * x4264 + x24 * x4014 + x24 * x4015 + x24 * x4016 + x4570 * x81,
            x23 * x4271 + x24 * x4021 + x24 * x4022 + x24 * x4023 + x4571 * x81,
            x23 * x4276 + x24 * x4028 + x24 * x4029 + x24 * x4030 + x4572 * x81,
            x23 * x4283 + x24 * x4035 + x24 * x4036 + x24 * x4037 + x4573 * x81,
            x153 * x4560
            + x23 * x4288
            + x24 * x4040
            + x24 * x4041
            + x24 * x4042
            + x272 * x4569
            + x4253,
            x171 * x4562
            + x23 * x4292
            + x24 * x4044
            + x24 * x4045
            + x24 * x4046
            + x272 * x4570
            + x4260,
            x23 * x4296
            + x24 * x4048
            + x24 * x4049
            + x24 * x4050
            + x272 * x4571
            + x4267
            + x4564,
            x23 * x4300
            + x24 * x4052
            + x24 * x4053
            + x24 * x4054
            + x272 * x4572
            + x4277
            + x4567,
            x23 * x4304 + x24 * x4056 + x24 * x4057 + x24 * x4058 + x272 * x4573 + x4279,
            x153 * x4566
            + x23 * x4308
            + x24 * x4060
            + x24 * x4061
            + x24 * x4062
            + x341 * x4573
            + 3.0 * x4034,
            x153
            * (
                x1 * (x17 * x4577 * x5 * x8 - x4575 * x467)
                + x4586 * x81
                - x74 * (x1 * (x17 * x4575 * x5 * x8 - x4579 * x467) + x4583 * x8)
            )
            + x24 * x4084
            + x24 * x4085
            + x24 * x4086
            + x24 * x4087
            + x81
            * (
                x171 * (-x4583 + x4586)
                + x81
                * (
                    x1 * (x17 * x4579 * x5 * x8 - x4582 * x467)
                    + x81 * (x4588 + x4589 * x462)
                )
            ),
            x171 * (x4579 * x635 + 0.5 * x4590 - x74 * (x4582 * x635 + 0.5 * x4591))
            + x24 * x4119
            + x24 * x4120
            + x24 * x4121
            + x24 * x4122
            + x81
            * (
                x1 * (x11 * x267 * x268 * x4579 * x8 - x1568 * x4582)
                + x81 * (x4589 * x635 + 0.5 * x4592)
            ),
            x171 * (x4595 + x4596 * x462 - x74 * (x4599 + x4600 * x462))
            + x24 * x4147
            + x24 * x4148
            + x24 * x4149
            + x24 * x4150
            + x81
            * (
                x1 * (x17 * x4596 * x5 * x8 - x4600 * x467) + x81 * (x4603 + x4604 * x462)
            ),
            x1 * (x17 * x4606 * x5 * x8 - x4605 * x467)
            + x24 * x4178
            + x24 * x4179
            + x24 * x4180
            + x24 * x4181
            + x81 * (x4608 * x85 + x4609 * x462),
            x1 * (x11 * x267 * x268 * x4596 * x8 - x1568 * x4600)
            + x24 * x4190
            + x24 * x4191
            + x24 * x4192
            + x24 * x4193
            + x81 * (x4604 * x635 + 0.5 * x4610),
            x1 * (x17 * x4612 * x5 * x8 - x4611 * x467)
            + x24 * x4208
            + x24 * x4209
            + x24 * x4210
            + x24 * x4211
            + x81 * (x4615 + x4616 * x462),
            x24 * x4218
            + x24 * x4219
            + x24 * x4220
            + x24 * x4221
            + x4617 * x85
            + x4618 * x462,
            x24 * x4227
            + x24 * x4228
            + x24 * x4229
            + x24 * x4230
            + x4619 * x85
            + x462 * x4620,
            x24 * x4235
            + x24 * x4236
            + x24 * x4237
            + x24 * x4238
            + x4616 * x635
            + 0.5 * x4621,
            x24 * x4244 + x24 * x4245 + x24 * x4246 + x24 * x4247 + x462 * x4624 + x4623,
            x24 * x4254 + x24 * x4255 + x24 * x4256 + x24 * x4257 + x4625 * x81,
            x24 * x4261 + x24 * x4262 + x24 * x4263 + x24 * x4264 + x4626 * x81,
            x24 * x4268 + x24 * x4269 + x24 * x4270 + x24 * x4271 + x4627 * x81,
            x24 * x4273 + x24 * x4274 + x24 * x4275 + x24 * x4276 + x280 * x4624,
            x24 * x4280 + x24 * x4281 + x24 * x4282 + x24 * x4283 + x4628 * x81,
            x153 * x4617
            + x24 * x4285
            + x24 * x4286
            + x24 * x4287
            + x24 * x4288
            + x272 * x4625,
            x171 * x4619
            + x24 * x4289
            + x24 * x4290
            + x24 * x4291
            + x24 * x4292
            + x272 * x4626,
            x24 * x4293 + x24 * x4294 + x24 * x4295 + x24 * x4296 + x272 * x4627 + x4621,
            x24 * x4297 + x24 * x4298 + x24 * x4299 + x24 * x4300 + x417 * x4624 + x4623,
            x24 * x4301 + x24 * x4302 + x24 * x4303 + x24 * x4304 + x272 * x4628,
            x153 * x4622
            + x24 * x4305
            + x24 * x4306
            + x24 * x4307
            + x24 * x4308
            + x341 * x4628
            + 4.0 * x4279,
        ]
    )


def _3center2el3d_100(a, A, b, B, c, C):
    """Cartesian (ps|s) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = -x1 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x1 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = c * x0 * (x3**2 + x6**2 + x8**2) / x4
    x10 = 17.4934183276249
    x11 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = 2.0 * x1 * x10 * x11 * x4 ** (-1.5) * boys(1, x9)
    x13 = c ** (-1.0)
    x14 = x4 ** (-0.5)
    x15 = boys(0, x9)

    # 3 item(s)
    return numpy.array(
        [
            2.0 * x1 * x10 * x11 * x13 * x14 * x15 * (-x2 - A[0]) - x12 * x3,
            2.0 * x1 * x10 * x11 * x13 * x14 * x15 * (-x5 - A[1]) - x12 * x6,
            2.0 * x1 * x10 * x11 * x13 * x14 * x15 * (-x7 - A[2]) - x12 * x8,
        ]
    )


def _3center2el3d_101(a, A, b, B, c, C):
    """Cartesian (ps|p) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = -x1 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x1 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = x0 / x4
    x10 = c * x9 * (x3**2 + x6**2 + x8**2)
    x11 = 17.4934183276249
    x12 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x13 = 2.0 * x1 * x11 * x12
    x14 = x13 * x4 ** (-1.5) * boys(2, x10)
    x15 = c ** (-1.0)
    x16 = x4 ** (-0.5)
    x17 = boys(1, x10)
    x18 = x9 * (2.0 * x1 * x11 * x12 * x15 * x16 * x17 * (-x2 - A[0]) - x14 * x3)
    x19 = x13 * x15 * x16 * x17 / (2.0 * a + 2.0 * b + 2.0 * c)
    x20 = x9 * (2.0 * x1 * x11 * x12 * x15 * x16 * x17 * (-x5 - A[1]) - x14 * x6)
    x21 = x9 * (2.0 * x1 * x11 * x12 * x15 * x16 * x17 * (-x7 - A[2]) - x14 * x8)

    # 9 item(s)
    return numpy.array(
        [
            x18 * x3 + x19,
            x18 * x6,
            x18 * x8,
            x20 * x3,
            x19 + x20 * x6,
            x20 * x8,
            x21 * x3,
            x21 * x6,
            x19 + x21 * x8,
        ]
    )


def _3center2el3d_102(a, A, b, B, c, C):
    """Cartesian (ps|d) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = x3**2
    x5 = -x1 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = x6**2
    x8 = -x1 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x9**2
    x11 = c + x0
    x12 = x0 / x11
    x13 = c * x12 * (x10 + x4 + x7)
    x14 = boys(2, x13)
    x15 = x11 ** (-1.5)
    x16 = 17.4934183276249
    x17 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x18 = 2.0 * x1 * x16 * x17
    x19 = x15 * x18
    x20 = x19 * x3
    x21 = c ** (-1.0)
    x22 = x11 ** (-0.5)
    x23 = -x2 - A[0]
    x24 = boys(1, x13)
    x25 = boys(0, x13)
    x26 = 0.5 * x21
    x27 = x26 * (
        2.0 * x1 * x16 * x17 * x21 * x22 * x23 * x25
        - x12 * (2.0 * x1 * x16 * x17 * x21 * x22 * x23 * x24 - x14 * x20)
        - x20 * x24
    )
    x28 = boys(3, x13)
    x29 = 2.0 * x1 * x14 * x16 * x17 * x21 * x22 * x23 - x20 * x28
    x30 = x12 * x3
    x31 = x14 / (2.0 * a + 2.0 * b + 2.0 * c)
    x32 = x18 * x21 * x22 * x31
    x33 = 2.0 * x15 * x16 * x17 * x21 * x31
    x34 = x0**2 / x11**2
    x35 = x29 * x34
    x36 = x3 * x35
    x37 = x33 * x6
    x38 = x33 * x9
    x39 = x6 * x9
    x40 = x19 * x6
    x41 = -x5 - A[1]
    x42 = x26 * (
        2.0 * x1 * x16 * x17 * x21 * x22 * x25 * x41
        - x12 * (2.0 * x1 * x16 * x17 * x21 * x22 * x24 * x41 - x14 * x40)
        - x24 * x40
    )
    x43 = 2.0 * x1 * x14 * x16 * x17 * x21 * x22 * x41 - x28 * x40
    x44 = x34 * x43
    x45 = x12 * x6
    x46 = x32 + x43 * x45
    x47 = x19 * x9
    x48 = -x8 - A[2]
    x49 = x26 * (
        2.0 * x1 * x16 * x17 * x21 * x22 * x25 * x48
        - x12 * (2.0 * x1 * x16 * x17 * x21 * x22 * x24 * x48 - x14 * x47)
        - x24 * x47
    )
    x50 = 2.0 * x1 * x14 * x16 * x17 * x21 * x22 * x48 - x28 * x47
    x51 = x34 * x50
    x52 = x12 * x9
    x53 = x32 + x50 * x52

    # 18 item(s)
    return numpy.array(
        [
            x27 + x3 * x33 + x30 * (x29 * x30 + x32),
            x36 * x6 + x37,
            x36 * x9 + x38,
            x27 + x35 * x7,
            x35 * x39,
            x10 * x35 + x27,
            x4 * x44 + x42,
            x30 * x46,
            x3 * x44 * x9,
            x37 + x42 + x45 * x46,
            x38 + x39 * x44,
            x10 * x44 + x42,
            x4 * x51 + x49,
            x3 * x51 * x6,
            x30 * x53,
            x49 + x51 * x7,
            x45 * x53,
            x38 + x49 + x52 * x53,
        ]
    )


def _3center2el3d_103(a, A, b, B, c, C):
    """Cartesian (ps|f) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x2 * x4
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(3, x16)
    x18 = 17.4934183276249
    x19 = numpy.exp(
        -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x20 = 2.0 * x13 ** (-1.5) * x18 * x19
    x21 = x17 * x20
    x22 = x13 ** (-0.5)
    x23 = -x3 - A[0]
    x24 = boys(2, x16)
    x25 = 2.0 * x0 * x18 * x19 * x2 * x22 * x23 * x24 - x21 * x5
    x26 = x15 * x25
    x27 = (2.0 * a + 2.0 * b + 2.0 * c) ** (-1.0)
    x28 = 2.0 * x0 * x18 * x19
    x29 = x2 * x22 * x28
    x30 = x24 * x27 * x29
    x31 = x20 * x24
    x32 = boys(1, x16)
    x33 = -2.0 * x0 * x18 * x19 * x2 * x22 * x23 * x32 + x31 * x5
    x34 = -x33
    x35 = x15 * x4
    x36 = x27 * x29 * x32
    x37 = 0.5 * x0
    x38 = x37 * (2.0 * x0 * x18 * x19 * x2 * x22 * x32 - x0 * x31)
    x39 = x1 * x13 ** (-2.5) * x17 * x28
    x40 = x37 * (-x26 - x33)
    x41 = x20 * boys(4, x16)
    x42 = 2.0 * x0 * x17 * x18 * x19 * x2 * x22 * x23 - x41 * x5
    x43 = x17 * x27 * x29
    x44 = x27 * x4
    x45 = x0 * x21
    x46 = x1**2 / x13**2
    x47 = x25 * x46
    x48 = x0 * (x1 * x14 * x34 * x8 - x47 * x8)
    x49 = x42 * x46
    x50 = x4 * x49
    x51 = x27 * x45
    x52 = x51 * x8
    x53 = x4 * x8
    x54 = x27 * x39
    x55 = x0 * (x1 * x11 * x14 * x34 - x11 * x47)
    x56 = 0.5 * x55
    x57 = x11 * x51
    x58 = x27 * (x38 + x39 * x9)
    x59 = x40 + x49 * x9
    x60 = x1**3 / x13**3
    x61 = x11 * x60
    x62 = x42 * x61
    x63 = x11 * x8
    x64 = x54 * x63
    x65 = x27 * (x12 * x39 + x38)
    x66 = x12 * x49 + x40
    x67 = x15 * x8
    x68 = x11 * x15
    x69 = x2 * x8
    x70 = -x7 - A[1]
    x71 = 2.0 * x0 * x18 * x19 * x2 * x22 * x24 * x70 - x21 * x69
    x72 = x46 * x71
    x73 = -2.0 * x0 * x18 * x19 * x2 * x22 * x32 * x70 + x31 * x69
    x74 = -x73
    x75 = x15 * x71
    x76 = x37 * (-x73 - x75)
    x77 = 2.0 * x0 * x17 * x18 * x19 * x2 * x22 * x70 - x41 * x69
    x78 = x46 * x6
    x79 = x0 * (-x15 * (x30 + x75 * x8) + x36 + x67 * x74)
    x80 = x43 + x67 * x77
    x81 = x0 * (x1 * x11 * x14 * x74 - x11 * x72)
    x82 = 0.5 * x81
    x83 = x52 + x67 * x80 + x76
    x84 = x46 * x77
    x85 = x57 + x63 * x84
    x86 = x12 * x84 + x76
    x87 = x11 * x2
    x88 = -x10 - A[2]
    x89 = 2.0 * x0 * x18 * x19 * x2 * x22 * x24 * x88 - x21 * x87
    x90 = x46 * x89
    x91 = -2.0 * x0 * x18 * x19 * x2 * x22 * x32 * x88 + x31 * x87
    x92 = -x91
    x93 = x15 * x89
    x94 = x37 * (-x91 - x93)
    x95 = 2.0 * x0 * x17 * x18 * x19 * x2 * x22 * x88 - x41 * x87
    x96 = x0 * (x1 * x14 * x8 * x92 - x8 * x90)
    x97 = x0 * (-x15 * (x11 * x93 + x30) + x36 + x68 * x92)
    x98 = 0.5 * x97
    x99 = x43 + x68 * x95
    x100 = x46 * x9
    x101 = x100 * x95 + x94
    x102 = x57 + x68 * x99 + x94

    # 30 item(s)
    return numpy.array(
        [
            x0 * (-x15 * (x26 * x4 + x30) + x34 * x35 + x36)
            + x27 * (x38 + x39 * x6)
            + x35 * (x35 * (x35 * x42 + x43) + x40 + x44 * x45),
            x35 * (x50 * x8 + x52) + 0.5 * x48 + x53 * x54,
            x11 * x39 * x44 + x35 * (x11 * x50 + x57) + x56,
            x35 * x59 + x58,
            x53 * x62 + x64,
            x35 * x66 + x65,
            x48 + x59 * x67,
            x56 + x62 * x9,
            x66 * x67,
            x55 + x66 * x68,
            x0 * (x1 * x14 * x4 * x74 - x4 * x72) + x35 * (x76 + x77 * x78),
            x78 * x80 + 0.5 * x79,
            x6 * x61 * x77 + x82,
            x35 * x83,
            x35 * x85,
            x35 * x86,
            x58 + x67 * x83 + x79,
            x64 + x67 * x85 + x82,
            x65 + x67 * x86,
            x68 * x86 + x81,
            x0 * (x1 * x14 * x4 * x92 - x4 * x90) + x35 * (x78 * x95 + x94),
            x6 * x60 * x8 * x95 + 0.5 * x96,
            x78 * x99 + x98,
            x101 * x35,
            x46 * x53 * x99,
            x102 * x35,
            x101 * x67 + x96,
            x100 * x99 + x98,
            x102 * x67,
            x102 * x68 + x65 + x97,
        ]
    )


def _3center2el3d_104(a, A, b, B, c, C):
    """Cartesian (ps|g) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b + 2.0 * c) ** (-1.0)
    x1 = c ** (-1.0)
    x2 = 17.4934183276249
    x3 = a + b
    x4 = c + x3
    x5 = x4 ** (-1.5)
    x6 = x3 ** (-1.0)
    x7 = -x6 * (a * A[0] + b * B[0])
    x8 = -x7 - C[0]
    x9 = x8**2
    x10 = -x6 * (a * A[1] + b * B[1])
    x11 = -x10 - C[1]
    x12 = x11**2
    x13 = -x6 * (a * A[2] + b * B[2])
    x14 = -x13 - C[2]
    x15 = x14**2
    x16 = x4 ** (-1.0)
    x17 = x16 * x3
    x18 = c * x17 * (x12 + x15 + x9)
    x19 = boys(2, x18)
    x20 = numpy.exp(
        -a * b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x21 = boys(3, x18)
    x22 = 2.0 * x1 * x2 * x20
    x23 = x22 * x3 * x4 ** (-2.5)
    x24 = x21 * x23
    x25 = x22 * x5
    x26 = x21 * x25
    x27 = x4 ** (-0.5)
    x28 = 0.5 * x1
    x29 = x28 * (2.0 * x1 * x19 * x2 * x20 * x27 * x6 - x26)
    x30 = boys(4, x18)
    x31 = x23 * x30
    x32 = x29 + x31 * x9
    x33 = x17 * x8
    x34 = x19 * x8
    x35 = 2.0 * x2 * x20 * x5
    x36 = x35 * x6
    x37 = -x7 - A[0]
    x38 = boys(1, x18)
    x39 = -2.0 * x1 * x2 * x20 * x27 * x37 * x38 * x6 + x34 * x36
    x40 = x36 * x8
    x41 = boys(0, x18)
    x42 = x28 * (2.0 * x1 * x2 * x20 * x27 * x37 * x41 * x6 + x17 * x39 - x38 * x40)
    x43 = -2.0 * x1 * x19 * x2 * x20 * x27 * x37 * x6 + x21 * x40
    x44 = -x43
    x45 = x17 * x44
    x46 = x28 * (-x39 - x45)
    x47 = 2.0 * x1 * x2 * x20 * x21 * x27 * x37 * x6 - x30 * x40
    x48 = x17 * x47
    x49 = x22 * x27
    x50 = x0 * x49 * x6
    x51 = x21 * x50
    x52 = x17 * (x48 * x8 + x51)
    x53 = x0 * x8
    x54 = x19 * x6
    x55 = x0 * x49 * x54
    x56 = x45 * x8 + x55
    x57 = 1.5 * x1
    x58 = x28 * (-x43 - x48)
    x59 = boys(5, x18)
    x60 = 2.0 * x1 * x2 * x20 * x27 * x30 * x37 * x6 - x40 * x59
    x61 = x30 * x50
    x62 = x25 * x30
    x63 = x3**2
    x64 = x4 ** (-2.0)
    x65 = x63 * x64
    x66 = x11 * x47
    x67 = x65 * x66
    x68 = x0 * x11
    x69 = x26 * x68
    x70 = x65 * x8
    x71 = x11 * x70
    x72 = x19 * x25
    x73 = x0 * x11 * x72
    x74 = x1 * (2.0 * x1 * x11 * x19 * x2 * x20 * x5 - x11 * x24)
    x75 = x22 * x30 * x4 ** (-3.5) * x63
    x76 = x75 * x9
    x77 = x1 * (x11 * x16 * x3 * x44 - x67)
    x78 = x62 * x68
    x79 = x11 * x8
    x80 = x47 * x65
    x81 = x14 * x80
    x82 = x0 * x14
    x83 = x26 * x82
    x84 = x14 * x70
    x85 = x0 * x14 * x72
    x86 = x1 * (2.0 * x1 * x14 * x19 * x2 * x20 * x5 - x14 * x24)
    x87 = 0.5 * x86
    x88 = x1 * (x14 * x16 * x3 * x44 - x81)
    x89 = 0.5 * x88
    x90 = x62 * x82
    x91 = x14 * x31
    x92 = x12 * x65
    x93 = -x17 * (x12 * x80 + x46) + x42 + x44 * x92
    x94 = x12 * x31 + x29
    x95 = x0 * x94
    x96 = x58 + x60 * x92
    x97 = x3**3 / x4**3
    x98 = x14 * x97
    x99 = x1 * (x11 * x14 * x44 * x63 * x64 - x66 * x98)
    x100 = x60 * x98
    x101 = x68 * x91
    x102 = x15 * x65
    x103 = x102 * x44 - x17 * (x15 * x80 + x46) + x42
    x104 = x103 * x28
    x105 = x15 * x31 + x29
    x106 = x0 * x105
    x107 = x102 * x60 + x58
    x108 = x11 * x17
    x109 = x0 * (x108 * x94 + x74)
    x110 = x108 * x96 + x77
    x111 = x0 * (x12 * x14 * x75 + x87)
    x112 = x100 * x12 + x89
    x113 = x106 * x108
    x114 = x14 * x17
    x115 = x0 * (x105 * x114 + x86)
    x116 = x107 * x114 + x88
    x117 = x35 * x54
    x118 = -x10 - A[1]
    x119 = -2.0 * x1 * x118 * x2 * x20 * x27 * x38 * x6 + x11 * x117
    x120 = x11 * x36
    x121 = x28 * (2.0 * x1 * x118 * x2 * x20 * x27 * x41 * x6 + x119 * x17 - x120 * x38)
    x122 = -2.0 * x1 * x118 * x19 * x2 * x20 * x27 * x6 + x120 * x21
    x123 = -x122
    x124 = x123 * x17
    x125 = x28 * (-x119 - x124)
    x126 = 2.0 * x1 * x118 * x2 * x20 * x21 * x27 * x6 - x120 * x30
    x127 = x65 * x9
    x128 = x126 * x17
    x129 = x28 * (-x122 - x128)
    x130 = 2.0 * x1 * x118 * x2 * x20 * x27 * x30 * x6 - x120 * x59
    x131 = x11 * x128 + x51
    x132 = x11 * x124 + x55
    x133 = x131 * x17
    x134 = x1 * (x132 - x133)
    x135 = x108 * x130 + x61
    x136 = x14 * x65
    x137 = x126 * x136
    x138 = x1 * (x123 * x14 * x16 * x3 - x137)
    x139 = 0.5 * x138
    x140 = x108 * x132 + x121 - x17 * (x11 * x133 + x125 + x69) + x73
    x141 = x108 * x135 + x129 + x78
    x142 = x11 * x136
    x143 = x1 * (x123 * x142 - x17 * (x11 * x137 + x83) + x85)
    x144 = x130 * x142 + x90
    x145 = x102 * x123 + x121 - x17 * (x102 * x126 + x125)
    x146 = x145 * x28
    x147 = x102 * x130 + x129
    x148 = x108 * x141 + x134 + x95
    x149 = x101 + x108 * x144 + x139
    x150 = x106 + x108 * x147
    x151 = x114 * x147 + x138
    x152 = -x13 - A[2]
    x153 = -2.0 * x1 * x152 * x2 * x20 * x27 * x38 * x6 + x117 * x14
    x154 = x14 * x36
    x155 = x28 * (2.0 * x1 * x152 * x2 * x20 * x27 * x41 * x6 + x153 * x17 - x154 * x38)
    x156 = -2.0 * x1 * x152 * x19 * x2 * x20 * x27 * x6 + x154 * x21
    x157 = -x156
    x158 = x157 * x17
    x159 = x28 * (-x153 - x158)
    x160 = 2.0 * x1 * x152 * x2 * x20 * x21 * x27 * x6 - x154 * x30
    x161 = x160 * x17
    x162 = x28 * (-x156 - x161)
    x163 = 2.0 * x1 * x152 * x2 * x20 * x27 * x30 * x6 - x154 * x59
    x164 = x11 * x97
    x165 = x11 * x65
    x166 = x1 * (x11 * x157 * x16 * x3 - x160 * x165)
    x167 = x164 * x9
    x168 = x14 * x161 + x51
    x169 = x14 * x158 + x55
    x170 = x168 * x17
    x171 = x1 * (x169 - x170)
    x172 = 0.5 * x171
    x173 = x114 * x163 + x61
    x174 = x155 + x157 * x92 - x17 * (x159 + x160 * x92)
    x175 = x162 + x163 * x92
    x176 = x1 * (x11 * x16 * x169 * x3 - x165 * x168)
    x177 = x114 * x169 + x155 - x17 * (x14 * x170 + x159 + x83) + x85
    x178 = x177 * x28
    x179 = x114 * x173 + x162 + x90
    x180 = x108 * x175 + x166
    x181 = x172 + x173 * x92
    x182 = x106 + x114 * x179 + x171

    # 45 item(s)
    return numpy.array(
        [
            x0 * (x1 * (2.0 * x1 * x19 * x2 * x20 * x5 * x8 - x24 * x8) + x32 * x33)
            + x33
            * (
                x0 * x32
                + x1 * (-x52 + x56)
                + x33 * (x33 * (x33 * x60 + x61) + x53 * x62 + x58)
            )
            + x57
            * (x0 * x25 * x34 - x17 * (x26 * x53 + x46 + x52 * x8) + x33 * x56 + x42),
            x0 * (x11 * x76 + 0.5 * x74)
            + x1 * (-x17 * (x67 * x8 + x69) + x44 * x71 + x73)
            + x33 * (x0 * x31 * x79 + x33 * (x60 * x71 + x78) + 0.5 * x77),
            x0 * (x14 * x76 + x87)
            + x1 * (-x17 * (x8 * x81 + x83) + x44 * x84 + x85)
            + x33 * (x33 * (x60 * x84 + x90) + x53 * x91 + x89),
            x28 * x93 + x33 * x95 + x33 * (x33 * x96 + x95),
            x33 * (x100 * x79 + x101) + x75 * x79 * x82 + 0.5 * x99,
            x104 + x106 * x33 + x33 * (x106 + x107 * x33),
            x109 + x110 * x33,
            x111 + x112 * x33,
            x107 * x71 + x113,
            x115 + x116 * x33,
            x108 * x110 + x57 * x93,
            x108 * x112 + x99,
            x104 + x107 * x92,
            x108 * x116,
            x103 * x57 + x114 * x116,
            x33 * (x1 * (x123 * x16 * x3 * x8 - x126 * x70) + x33 * (x127 * x130 + x129))
            + x57 * (x121 + x123 * x127 - x17 * (x125 + x126 * x127)),
            x1 * (-x131 * x70 + x132 * x16 * x3 * x8) + x33 * (x127 * x135 + 0.5 * x134),
            x1 * (x123 * x14 * x63 * x64 * x8 - x126 * x8 * x98)
            + x33 * (x130 * x9 * x98 + x139),
            x127 * x141 + x140 * x28,
            x127 * x144 + 0.5 * x143,
            x127 * x147 + x146,
            x148 * x33,
            x149 * x33,
            x150 * x33,
            x151 * x33,
            x108 * x148 + x109 + x140 * x57,
            x108 * x149 + x111 + x143,
            x108 * x150 + x113 + x146,
            x108 * x151 + x115,
            x114 * x151 + x145 * x57,
            x33 * (x1 * (x157 * x16 * x3 * x8 - x160 * x70) + x33 * (x127 * x163 + x162))
            + x57 * (x127 * x157 + x155 - x17 * (x127 * x160 + x159)),
            x1 * (x11 * x157 * x63 * x64 * x8 - x160 * x164 * x8)
            + x33 * (x163 * x167 + 0.5 * x166),
            x1 * (x16 * x169 * x3 * x8 - x168 * x70) + x33 * (x127 * x173 + x172),
            x127 * x175 + x174 * x28,
            x167 * x173 + 0.5 * x176,
            x127 * x179 + x178,
            x180 * x33,
            x181 * x33,
            x179 * x71,
            x182 * x33,
            x108 * x180 + x174 * x57,
            x108 * x181 + x176,
            x178 + x179 * x92,
            x108 * x182,
            x114 * x182 + x115 + x177 * x57,
        ]
    )


def _3center2el3d_105(a, A, b, B, c, C):
    """Cartesian (ps|h) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b + 2.0 * c) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x4**2
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x1
    x13 = x12 ** (-1.0)
    x14 = x1 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(3, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = numpy.exp(
        -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x20 = c ** (-1.0)
    x21 = 2.0 * x20
    x22 = x18 * x19 * x21
    x23 = x17 * x22
    x24 = x16 * x23
    x25 = x12 ** (-0.5)
    x26 = boys(2, x15)
    x27 = 0.5 * x20
    x28 = x27 * (2.0 * x18 * x19 * x2 * x20 * x25 * x26 - x24)
    x29 = boys(4, x15)
    x30 = x22 * x29
    x31 = x12 ** (-2.5)
    x32 = x1 * x31
    x33 = x32 * x5
    x34 = x28 + x30 * x33
    x35 = boys(1, x15)
    x36 = x27 * (2.0 * x18 * x19 * x2 * x20 * x25 * x35 - x23 * x26)
    x37 = x22 * x33
    x38 = x16 * x37 + x36
    x39 = 1.5 * x20
    x40 = x30 * x32
    x41 = x4 * x40
    x42 = x23 * x29
    x43 = x27 * (2.0 * x16 * x18 * x19 * x2 * x20 * x25 - x42)
    x44 = boys(5, x15)
    x45 = x37 * x44 + x43
    x46 = x14 * x4
    x47 = x20 * (2.0 * x16 * x17 * x18 * x19 * x20 * x4 - x41) + x45 * x46
    x48 = x16 * x4
    x49 = 2.0 * x17 * x18 * x19 * x2
    x50 = -x3 - A[0]
    x51 = -2.0 * x18 * x19 * x2 * x20 * x25 * x26 * x50 + x48 * x49
    x52 = -x51
    x53 = x14 * x52
    x54 = x2 * x22 * x25
    x55 = x0 * x26 * x54
    x56 = x4 * x53 + x55
    x57 = x4 * x49
    x58 = -2.0 * x18 * x19 * x2 * x20 * x25 * x35 * x50 + x26 * x57
    x59 = -x58
    x60 = x0 * x35 * x54
    x61 = -2.0 * x16 * x18 * x19 * x2 * x20 * x25 * x50 + x29 * x57
    x62 = -x61
    x63 = x14 * x62
    x64 = x0 * x16 * x54
    x65 = x4 * x63 + x64
    x66 = x14 * x65
    x67 = x27 * (-x51 - x63)
    x68 = 2.0 * x18 * x19 * x2 * x20 * x25 * x29 * x50 - x44 * x57
    x69 = x14 * x68
    x70 = x0 * x29 * x54
    x71 = x14 * (x4 * x69 + x70)
    x72 = x0 * x4
    x73 = x14 * (x4 * x71 + x42 * x72 + x67)
    x74 = x27 * (-x53 - x58)
    x75 = x0 * x24 * x4 + x4 * x66 + x74
    x76 = x27 * (-x61 - x69)
    x77 = boys(6, x15)
    x78 = 2.0 * x18 * x19 * x2 * x20 * x25 * x44 * x50 - x57 * x77
    x79 = x0 * x44 * x54
    x80 = x23 * x44
    x81 = x1**2
    x82 = x12 ** (-3.5) * x81
    x83 = x7 * x82
    x84 = x30 * x4
    x85 = x20 * (2.0 * x16 * x17 * x18 * x19 * x20 * x7 - x40 * x7)
    x86 = x22 * x44
    x87 = x5 * x86
    x88 = x83 * x87 + 0.5 * x85
    x89 = x12 ** (-2.0)
    x90 = x81 * x89
    x91 = x7 * x90
    x92 = x20 * (x1 * x13 * x59 * x7 - x52 * x91)
    x93 = x62 * x91
    x94 = x20 * (x1 * x13 * x52 * x7 - x93)
    x95 = x68 * x91
    x96 = x0 * x7
    x97 = x42 * x96
    x98 = x14 * (x4 * x95 + x97)
    x99 = x0 * x24 * x7
    x100 = x4 * x93 + x99
    x101 = x22 * x32
    x102 = x101 * x48
    x103 = x20 * (x1 * x13 * x62 * x7 - x95)
    x104 = x4 * x78
    x105 = x80 * x96
    x106 = x101 * x44 * x72
    x107 = x10 * x82
    x108 = x20 * (2.0 * x10 * x16 * x17 * x18 * x19 * x20 - x10 * x40)
    x109 = 0.5 * x108
    x110 = x107 * x87 + x109
    x111 = x10 * x90
    x112 = x20 * (x1 * x10 * x13 * x59 - x111 * x52)
    x113 = 0.5 * x112
    x114 = x111 * x62
    x115 = x20 * (x1 * x10 * x13 * x52 - x114)
    x116 = 0.5 * x115
    x117 = x111 * x68
    x118 = x0 * x10
    x119 = x118 * x42
    x120 = x14 * (x117 * x4 + x119)
    x121 = x0 * x10 * x24
    x122 = x114 * x4 + x121
    x123 = x20 * (x1 * x10 * x13 * x62 - x117)
    x124 = 0.5 * x123
    x125 = x118 * x80
    x126 = x101 * x8
    x127 = x126 * x16 + x36
    x128 = x0 * x127
    x129 = x28 + x40 * x8
    x130 = x0 * x129
    x131 = x8 * x90
    x132 = x14 * (x131 * x68 + x67)
    x133 = x131 * x62 + x74
    x134 = x127 - x129 * x14
    x135 = x126 * x44 + x43
    x136 = x5 * x90
    x137 = -x132 + x133
    x138 = x0 * x135
    x139 = x131 * x78 + x76
    x140 = x10 * x7
    x141 = x1**3
    x142 = x141 / x12**3
    x143 = x142 * x68
    x144 = x140 * x143
    x145 = x0 * x140 * x40
    x146 = x142 * x4
    x147 = x101 * x140
    x148 = x0 * x147 * x16
    x149 = x140 * x82
    x150 = x20 * (2.0 * x1 * x10 * x16 * x18 * x19 * x20 * x31 * x7 - x149 * x30)
    x151 = x20 * (x10 * x62 * x7 * x81 * x89 - x144)
    x152 = x0 * x147 * x44
    x153 = x101 * x11
    x154 = x153 * x16 + x36
    x155 = x0 * x154
    x156 = x11 * x40 + x28
    x157 = x0 * x156
    x158 = x11 * x90
    x159 = x158 * x68 + x67
    x160 = x14 * x159
    x161 = x158 * x62 + x74
    x162 = -x14 * x156 + x154
    x163 = x162 * x27
    x164 = x153 * x44 + x43
    x165 = -x160 + x161
    x166 = x165 * x27
    x167 = x0 * x164
    x168 = x158 * x78 + x76
    x169 = x14 * x7
    x170 = x133 * x169 - x14 * (x132 * x7 + x94) + x92
    x171 = x135 * x169 + x85
    x172 = x0 * x171
    x173 = x103 + x139 * x169
    x174 = x10 * x8
    x175 = x142 * x174
    x176 = x113 - x14 * (x116 + x143 * x174) + x175 * x62
    x177 = x109 + x174 * x82 * x86
    x178 = x0 * x177
    x179 = x124 + x175 * x78
    x180 = x20 * (x1 * x13 * x161 * x7 - x159 * x91)
    x181 = x4 * x91
    x182 = x167 * x169
    x183 = x10 * x14
    x184 = x112 - x14 * (x10 * x160 + x115) + x161 * x183
    x185 = x184 * x27
    x186 = x108 + x164 * x183
    x187 = x0 * x186
    x188 = x123 + x168 * x183
    x189 = x0 * (x134 * x39 + x169 * x171)
    x190 = x137 * x39 + x169 * x173
    x191 = x0 * (x150 + x169 * x177)
    x192 = x151 + x169 * x179
    x193 = x0 * (x131 * x164 + x163)
    x194 = x131 * x168 + x166
    x195 = x169 * x187
    x196 = x0 * (x162 * x39 + x183 * x186)
    x197 = x165 * x39 + x183 * x188
    x198 = x49 * x7
    x199 = -x6 - A[1]
    x200 = x16 * x198 - 2.0 * x18 * x19 * x199 * x2 * x20 * x25 * x26
    x201 = -x200
    x202 = x4 * x90
    x203 = -2.0 * x18 * x19 * x199 * x2 * x20 * x25 * x35 + x198 * x26
    x204 = -x203
    x205 = -2.0 * x16 * x18 * x19 * x199 * x2 * x20 * x25 + x198 * x29
    x206 = -x205
    x207 = x14 * x206
    x208 = x27 * (-x200 - x207)
    x209 = 2.0 * x18 * x19 * x199 * x2 * x20 * x25 * x29 - x198 * x44
    x210 = x14 * (x136 * x209 + x208)
    x211 = x14 * x201
    x212 = x27 * (-x203 - x211)
    x213 = x136 * x206 + x212
    x214 = x14 * x209
    x215 = x27 * (-x205 - x214)
    x216 = 2.0 * x18 * x19 * x199 * x2 * x20 * x25 * x44 - x198 * x77
    x217 = x211 * x7 + x55
    x218 = x20 * (-x14 * x217 + x169 * x204 + x60)
    x219 = x207 * x7 + x64
    x220 = x14 * x219
    x221 = x20 * (x217 - x220)
    x222 = x214 * x7 + x70
    x223 = x14 * x222
    x224 = x20 * (x219 - x223)
    x225 = x169 * x216 + x79
    x226 = x20 * (x1 * x10 * x13 * x204 - x111 * x201)
    x227 = 0.5 * x226
    x228 = x20 * (x1 * x10 * x13 * x201 - x111 * x206)
    x229 = 0.5 * x228
    x230 = x10 * x209
    x231 = x142 * x5
    x232 = x10 * x231
    x233 = x20 * (x1 * x10 * x13 * x206 - x111 * x209)
    x234 = 0.5 * x233
    x235 = x208 + x223 * x7 + x97
    x236 = x212 + x220 * x7 + x99
    x237 = x14 * x235
    x238 = x236 - x237
    x239 = x105 + x169 * x225 + x215
    x240 = x119 + x230 * x91
    x241 = x10 * x91
    x242 = x121 + x206 * x241
    x243 = x14 * x240
    x244 = x20 * (x242 - x243)
    x245 = x125 + x216 * x241
    x246 = x158 * x209 + x208
    x247 = x158 * x206 + x212
    x248 = x14 * x246
    x249 = x247 - x248
    x250 = x249 * x27
    x251 = x158 * x216 + x215
    x252 = x128 - x14 * (x130 + x221 + x237 * x7) + x169 * x236 + x218
    x253 = x138 + x169 * x239 + x224
    x254 = -x14 * (x145 + x229 + x243 * x7) + x148 + x169 * x242 + x227
    x255 = x152 + x169 * x245 + x234
    x256 = x20 * (-x14 * (x157 + x248 * x7) + x155 + x169 * x247)
    x257 = x167 + x169 * x251
    x258 = -x14 * (x10 * x248 + x228) + x183 * x247 + x226
    x259 = x258 * x27
    x260 = x183 * x251 + x233
    x261 = x169 * x253 + x172 + x238 * x39
    x262 = x169 * x255 + x178 + x244
    x263 = x169 * x257 + x182 + x250
    x264 = x169 * x260 + x187
    x265 = x183 * x260 + x249 * x39
    x266 = x10 * x49
    x267 = -x9 - A[2]
    x268 = x16 * x266 - 2.0 * x18 * x19 * x2 * x20 * x25 * x26 * x267
    x269 = -x268
    x270 = -2.0 * x18 * x19 * x2 * x20 * x25 * x267 * x35 + x26 * x266
    x271 = -x270
    x272 = -2.0 * x16 * x18 * x19 * x2 * x20 * x25 * x267 + x266 * x29
    x273 = -x272
    x274 = x14 * x273
    x275 = x27 * (-x268 - x274)
    x276 = 2.0 * x18 * x19 * x2 * x20 * x25 * x267 * x29 - x266 * x44
    x277 = x14 * (x136 * x276 + x275)
    x278 = x14 * x269
    x279 = x27 * (-x270 - x278)
    x280 = x136 * x273 + x279
    x281 = x14 * x276
    x282 = x27 * (-x272 - x281)
    x283 = 2.0 * x18 * x19 * x2 * x20 * x25 * x267 * x44 - x266 * x77
    x284 = x20 * (x1 * x13 * x271 * x7 - x269 * x91)
    x285 = x20 * (x1 * x13 * x269 * x7 - x273 * x91)
    x286 = x231 * x7
    x287 = x146 * x7
    x288 = x20 * (x1 * x13 * x273 * x7 - x276 * x91)
    x289 = x10 * x278 + x55
    x290 = x20 * (-x14 * x289 + x183 * x271 + x60)
    x291 = 0.5 * x290
    x292 = x10 * x274 + x64
    x293 = x14 * x292
    x294 = x20 * (x289 - x293)
    x295 = 0.5 * x294
    x296 = x10 * x281 + x70
    x297 = x14 * x296
    x298 = x20 * (x292 - x297)
    x299 = 0.5 * x298
    x300 = x183 * x283 + x79
    x301 = x131 * x276 + x275
    x302 = x131 * x273 + x279
    x303 = x14 * x301
    x304 = x302 - x303
    x305 = x131 * x283 + x282
    x306 = x20 * (x1 * x13 * x292 * x7 - x296 * x91)
    x307 = x10 * x297 + x119 + x275
    x308 = x10 * x293 + x121 + x279
    x309 = x14 * x307
    x310 = x308 - x309
    x311 = x27 * x310
    x312 = x125 + x183 * x300 + x282
    x313 = -x14 * (x285 + x303 * x7) + x169 * x302 + x284
    x314 = x169 * x305 + x288
    x315 = x131 * x292 - x14 * (x131 * x296 + x295) + x291
    x316 = x131 * x300 + x299
    x317 = x20 * (x1 * x13 * x308 * x7 - x307 * x91)
    x318 = -x14 * (x10 * x309 + x157 + x294) + x155 + x183 * x308 + x290
    x319 = x27 * x318
    x320 = x167 + x183 * x312 + x298
    x321 = x169 * x314 + x304 * x39
    x322 = x169 * x316 + x306
    x323 = x131 * x312 + x311
    x324 = x183 * x320 + x187 + x310 * x39

    # 63 item(s)
    return numpy.array(
        [
            x0 * (x39 * (-x14 * x34 + x38) + x46 * x47)
            + x21
            * (
                x0 * x38
                - x14 * (x0 * x34 + x20 * (x56 - x66) + x4 * x73)
                + x20 * (-x14 * x56 + x46 * x59 + x60)
                + x46 * x75
            )
            + x46
            * (
                x0 * x47
                + x39 * (-x73 + x75)
                + x46
                * (
                    x0 * x45
                    + x20 * (x65 - x71)
                    + x46 * (x46 * (x46 * x78 + x79) + x72 * x80 + x76)
                )
            ),
            x0
            * (
                x20 * (2.0 * x1 * x16 * x18 * x19 * x20 * x31 * x4 * x7 - x83 * x84)
                + x46 * x88
            )
            + x39
            * (
                x100 * x46
                + x102 * x96
                - x14 * (x4 * x98 + x41 * x96 + 0.5 * x94)
                + 0.5 * x92
            )
            + x46
            * (
                x0 * x88
                + x20 * (x100 - x98)
                + x46 * (0.5 * x103 + x106 * x7 + x46 * (x104 * x91 + x105))
            ),
            x0
            * (
                x110 * x46
                + x20 * (2.0 * x1 * x10 * x16 * x18 * x19 * x20 * x31 * x4 - x107 * x84)
            )
            + x39
            * (x102 * x118 + x113 + x122 * x46 - x14 * (x116 + x118 * x41 + x120 * x4))
            + x46
            * (
                x0 * x110
                + x20 * (-x120 + x122)
                + x46 * (x10 * x106 + x124 + x46 * (x104 * x111 + x125))
            ),
            x0 * (x134 * x27 + x135 * x136)
            + x20 * (x128 + x133 * x46 - x14 * (x130 + x132 * x4))
            + x46 * (x137 * x27 + x138 * x46 + x46 * (x138 + x139 * x46)),
            x0 * (x12 ** (-4.5) * x140 * x141 * x87 + 0.5 * x150)
            + x20 * (-x14 * (x144 * x4 + x145) + x140 * x146 * x62 + x148)
            + x46 * (x149 * x72 * x86 + 0.5 * x151 + x46 * (x104 * x140 * x142 + x152)),
            x0 * (x136 * x164 + x163)
            + x20 * (-x14 * (x157 + x160 * x4) + x155 + x161 * x46)
            + x46 * (x166 + x167 * x46 + x46 * (x167 + x168 * x46)),
            x170 * x27 + x172 * x46 + x46 * (x172 + x173 * x46),
            x176 * x27 + x178 * x46 + x46 * (x178 + x179 * x46),
            x167 * x181 + 0.5 * x180 + x46 * (x168 * x181 + x182),
            x185 + x187 * x46 + x46 * (x187 + x188 * x46),
            x189 + x190 * x46,
            x191 + x192 * x46,
            x193 + x194 * x46,
            x181 * x188 + x195,
            x196 + x197 * x46,
            x169 * x190 + x170 * x21,
            x169 * x192 + x176 * x39,
            x169 * x194 + x180,
            x131 * x188 + x185,
            x169 * x197,
            x183 * x197 + x184 * x21,
            x21
            * (
                -x14 * (x20 * (x1 * x13 * x201 * x4 - x202 * x206) + x210 * x4)
                + x20 * (x1 * x13 * x204 * x4 - x201 * x202)
                + x213 * x46
            )
            + x46
            * (
                x39 * (-x210 + x213)
                + x46
                * (
                    x20 * (x1 * x13 * x206 * x4 - x202 * x209)
                    + x46 * (x136 * x216 + x215)
                )
            ),
            x39 * (x136 * x219 - x14 * (x136 * x222 + 0.5 * x221) + 0.5 * x218)
            + x46
            * (
                x20 * (x1 * x13 * x219 * x4 - x202 * x222)
                + x46 * (x136 * x225 + 0.5 * x224)
            ),
            x39 * (-x14 * (x229 + x230 * x231) + x206 * x232 + x227)
            + x46
            * (
                x20 * (x10 * x206 * x4 * x81 * x89 - x146 * x230)
                + x46 * (x216 * x232 + x234)
            ),
            x20 * (x1 * x13 * x236 * x4 - x202 * x235) + x46 * (x136 * x239 + x238 * x27),
            x20 * (x1 * x13 * x242 * x4 - x202 * x240) + x46 * (x136 * x245 + 0.5 * x244),
            x20 * (x1 * x13 * x247 * x4 - x202 * x246) + x46 * (x136 * x251 + x250),
            x136 * x253 + x252 * x27,
            x136 * x255 + x254 * x27,
            x136 * x257 + 0.5 * x256,
            x136 * x260 + x259,
            x261 * x46,
            x262 * x46,
            x263 * x46,
            x264 * x46,
            x265 * x46,
            x169 * x261 + x189 + x21 * x252,
            x169 * x262 + x191 + x254 * x39,
            x169 * x263 + x193 + x256,
            x169 * x264 + x195 + x259,
            x169 * x265 + x196,
            x183 * x265 + x21 * x258,
            x21
            * (
                -x14 * (x20 * (x1 * x13 * x269 * x4 - x202 * x273) + x277 * x4)
                + x20 * (x1 * x13 * x271 * x4 - x202 * x269)
                + x280 * x46
            )
            + x46
            * (
                x39 * (-x277 + x280)
                + x46
                * (
                    x20 * (x1 * x13 * x273 * x4 - x202 * x276)
                    + x46 * (x136 * x283 + x282)
                )
            ),
            x39 * (-x14 * (x276 * x286 + 0.5 * x285) + x273 * x286 + 0.5 * x284)
            + x46
            * (
                x20 * (x273 * x4 * x7 * x81 * x89 - x276 * x287)
                + x46 * (x283 * x286 + 0.5 * x288)
            ),
            x39 * (x136 * x292 - x14 * (x136 * x296 + x295) + x291)
            + x46
            * (x20 * (x1 * x13 * x292 * x4 - x202 * x296) + x46 * (x136 * x300 + x299)),
            x20 * (x1 * x13 * x302 * x4 - x202 * x301) + x46 * (x136 * x305 + x27 * x304),
            x20 * (-x287 * x296 + x292 * x4 * x7 * x81 * x89)
            + x46 * (x286 * x300 + 0.5 * x306),
            x20 * (x1 * x13 * x308 * x4 - x202 * x307) + x46 * (x136 * x312 + x311),
            x136 * x314 + x27 * x313,
            x136 * x316 + x27 * x315,
            x286 * x312 + 0.5 * x317,
            x136 * x320 + x319,
            x321 * x46,
            x322 * x46,
            x323 * x46,
            x181 * x320,
            x324 * x46,
            x169 * x321 + x21 * x313,
            x169 * x322 + x315 * x39,
            x169 * x323 + x317,
            x131 * x320 + x319,
            x169 * x324,
            x183 * x324 + x196 + x21 * x318,
        ]
    )


def _3center2el3d_110(a, A, b, B, c, C):
    """Cartesian (pp|s) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = c + x0
    x9 = c / x8
    x10 = x0 * x9 * (x3**2 + x5**2 + x7**2)
    x11 = boys(1, x10)
    x12 = 17.4934183276249
    x13 = A[0] - B[0]
    x14 = A[1] - B[1]
    x15 = A[2] - B[2]
    x16 = numpy.exp(-a * b * x1 * (x13**2 + x14**2 + x15**2))
    x17 = 2.0 * x1 * x12 * x16 * x8 ** (-1.5)
    x18 = x11 * x17
    x19 = c ** (-1.0)
    x20 = x8 ** (-0.5)
    x21 = boys(0, x10)
    x22 = (2.0 * x1 * x12 * x16 * x19 * x20 * x21 - x18) / (2.0 * a + 2.0 * b)
    x23 = -x2 - A[0]
    x24 = 2.0 * x1 * x12 * x16 * x19 * x20 * x21 * x23 - x18 * x3
    x25 = x17 * boys(2, x10)
    x26 = x3 * x9
    x27 = -x4 - A[1]
    x28 = 2.0 * x1 * x12 * x16 * x19 * x20 * x21 * x27 - x18 * x5
    x29 = 2.0 * x1 * x11 * x12 * x16 * x19 * x20 * x27 - x25 * x5
    x30 = x23 * x28 - x26 * x29
    x31 = -x6 - A[2]
    x32 = 2.0 * x1 * x12 * x16 * x19 * x20 * x21 * x31 - x18 * x7
    x33 = 2.0 * x1 * x11 * x12 * x16 * x19 * x20 * x31 - x25 * x7
    x34 = x23 * x32 - x26 * x33
    x35 = x5 * x9
    x36 = x27 * x32 - x33 * x35

    # 9 item(s)
    return numpy.array(
        [
            x13 * x24
            + x22
            + x23 * x24
            - x26 * (2.0 * x1 * x11 * x12 * x16 * x19 * x20 * x23 - x25 * x3),
            x14 * x24 + x30,
            x15 * x24 + x34,
            x13 * x28 + x30,
            x14 * x28 + x22 + x27 * x28 - x29 * x35,
            x15 * x28 + x36,
            x13 * x32 + x34,
            x14 * x32 + x36,
            x15 * x32 + x22 + x31 * x32 - x33 * x7 * x9,
        ]
    )


def _3center2el3d_111(a, A, b, B, c, C):
    """Cartesian (pp|p) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x2 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x2 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = c + x1
    x10 = x9 ** (-1.0)
    x11 = x1 * x10
    x12 = c * x11 * (x4**2 + x6**2 + x8**2)
    x13 = boys(2, x12)
    x14 = 17.4934183276249
    x15 = A[1] - B[1]
    x16 = A[2] - B[2]
    x17 = numpy.exp(-a * b * x2 * (x0**2 + x15**2 + x16**2))
    x18 = 2.0 * x14 * x17 * x2
    x19 = x18 * x9 ** (-1.5)
    x20 = x13 * x19
    x21 = c ** (-1.0)
    x22 = x9 ** (-0.5)
    x23 = -x3 - A[0]
    x24 = boys(1, x12)
    x25 = 2.0 * x14 * x17 * x2 * x21 * x22 * x23 * x24 - x20 * x4
    x26 = x11 * x4
    x27 = 2.0 * a + 2.0 * b
    x28 = (2.0 * c + x27) ** (-1.0)
    x29 = x18 * x21 * x22 * x24 * x28
    x30 = x25 * x26 + x29
    x31 = x25 * x28
    x32 = (2.0 * x14 * x17 * x2 * x21 * x22 * x24 - x20) / x27
    x33 = x19 * boys(3, x12)
    x34 = c * x10
    x35 = x34 * x4
    x36 = (
        x23 * x25 + x32 - x35 * (2.0 * x13 * x14 * x17 * x2 * x21 * x22 * x23 - x33 * x4)
    )
    x37 = x11 * x36
    x38 = x11 * x6
    x39 = x0 * x25
    x40 = x11 * x8
    x41 = -x5 - A[1]
    x42 = 2.0 * x14 * x17 * x2 * x21 * x22 * x24 * x41 - x20 * x6
    x43 = x28 * x42
    x44 = 2.0 * x13 * x14 * x17 * x2 * x21 * x22 * x41 - x33 * x6
    x45 = x23 * x42 - x35 * x44
    x46 = x26 * x45 + x43
    x47 = x15 * x25
    x48 = x11 * x45
    x49 = x31 + x48 * x6
    x50 = x48 * x8
    x51 = -x7 - A[2]
    x52 = 2.0 * x14 * x17 * x2 * x21 * x22 * x24 * x51 - x20 * x8
    x53 = x28 * x52
    x54 = 2.0 * x13 * x14 * x17 * x2 * x21 * x22 * x51 - x33 * x8
    x55 = x23 * x52 - x35 * x54
    x56 = x26 * x55 + x53
    x57 = x11 * x55
    x58 = x57 * x6
    x59 = x16 * x25
    x60 = x31 + x57 * x8
    x61 = x0 * x42
    x62 = x29 + x38 * x42
    x63 = x34 * x6
    x64 = x32 + x41 * x42 - x44 * x63
    x65 = x15 * x42
    x66 = x41 * x52 - x54 * x63
    x67 = x26 * x66
    x68 = x16 * x42
    x69 = x38 * x66 + x53
    x70 = x40 * x66 + x43
    x71 = x0 * x52
    x72 = x29 + x40 * x52
    x73 = x15 * x52
    x74 = x32 - x34 * x54 * x8 + x51 * x52
    x75 = x16 * x52

    # 27 item(s)
    return numpy.array(
        [
            x0 * x30 + x26 * x36 + 2.0 * x31,
            x37 * x6 + x38 * x39,
            x37 * x8 + x39 * x40,
            x15 * x30 + x46,
            x38 * x47 + x49,
            x40 * x47 + x50,
            x16 * x30 + x56,
            x38 * x59 + x58,
            x40 * x59 + x60,
            x26 * x61 + x46,
            x0 * x62 + x49,
            x40 * x61 + x50,
            x26 * x64 + x26 * x65,
            x15 * x62 + x38 * x64 + 2.0 * x43,
            x40 * x64 + x40 * x65,
            x26 * x68 + x67,
            x16 * x62 + x69,
            x40 * x68 + x70,
            x26 * x71 + x56,
            x38 * x71 + x58,
            x0 * x72 + x60,
            x26 * x73 + x67,
            x38 * x73 + x69,
            x15 * x72 + x70,
            x26 * x74 + x26 * x75,
            x38 * x74 + x38 * x75,
            x16 * x72 + x40 * x74 + 2.0 * x53,
        ]
    )


def _3center2el3d_112(a, A, b, B, c, C):
    """Cartesian (pp|d) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x4**2
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x1
    x13 = x12 ** (-1.0)
    x14 = x1 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(2, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[1] - B[1]
    x20 = A[2] - B[2]
    x21 = numpy.exp(-a * b * x2 * (x0**2 + x19**2 + x20**2))
    x22 = x18 * x2 * x21
    x23 = 2.0 * x17 * x22
    x24 = x16 * x23
    x25 = c ** (-1.0)
    x26 = x12 ** (-0.5)
    x27 = -x3 - A[0]
    x28 = boys(1, x15)
    x29 = 2.0 * x18 * x2 * x21 * x25 * x26 * x27 * x28 - x24 * x4
    x30 = x23 * x28
    x31 = boys(0, x15)
    x32 = -2.0 * x18 * x2 * x21 * x25 * x26 * x27 * x31 + x30 * x4
    x33 = 0.5 * x25
    x34 = x33 * (-x14 * x29 - x32)
    x35 = boys(3, x15)
    x36 = x23 * x35
    x37 = 2.0 * x16 * x18 * x2 * x21 * x25 * x26 * x27 - x36 * x4
    x38 = x14 * x4
    x39 = 2.0 * a + 2.0 * b
    x40 = (2.0 * c + x39) ** (-1.0)
    x41 = 2.0 * x40
    x42 = x16 * x41
    x43 = x22 * x25 * x26 * x42
    x44 = x37 * x38 + x43
    x45 = x17 * x18 * x21 * x25 * x42
    x46 = x34 + x38 * x44 + x4 * x45
    x47 = x39 ** (-1.0)
    x48 = -x47 * (2.0 * x18 * x2 * x21 * x25 * x26 * x31 - x30)
    x49 = x47 * (2.0 * x18 * x2 * x21 * x25 * x26 * x28 - x24)
    x50 = c * x13
    x51 = x37 * x4
    x52 = x4 * x50
    x53 = x33 * (-x14 * (x27 * x29 + x49 - x50 * x51) - x27 * x32 - x29 * x52 - x48)
    x54 = x37 * x40
    x55 = 2.0 * x54
    x56 = x47 * (2.0 * x16 * x18 * x2 * x21 * x25 * x26 - x36)
    x57 = x23 * boys(4, x15)
    x58 = (
        x27 * x37 - x52 * (2.0 * x18 * x2 * x21 * x25 * x26 * x27 * x35 - x4 * x57) + x56
    )
    x59 = x1**2 / x12**2
    x60 = x59 * x7
    x61 = x45 * x7
    x62 = x51 * x60 + x61
    x63 = x4 * x58
    x64 = x14 * x7
    x65 = x10 * x59
    x66 = x10 * x45
    x67 = x51 * x65 + x66
    x68 = x10 * x14
    x69 = x59 * x8
    x70 = x34 + x37 * x69
    x71 = x10 * x60
    x72 = x37 * x71
    x73 = x11 * x59
    x74 = x34 + x37 * x73
    x75 = -x6 - A[1]
    x76 = -2.0 * x18 * x2 * x21 * x25 * x26 * x31 * x75 + x30 * x7
    x77 = -x76
    x78 = 2.0 * x18 * x2 * x21 * x25 * x26 * x28 * x75 - x24 * x7
    x79 = 2.0 * x16 * x18 * x2 * x21 * x25 * x26 * x75 - x36 * x7
    x80 = x33 * (-x14 * (x27 * x78 - x52 * x79) + x27 * x77 - x52 * x78)
    x81 = x40 * x79
    x82 = 2.0 * x18 * x2 * x21 * x25 * x26 * x35 * x75 - x57 * x7
    x83 = x27 * x79 - x52 * x82
    x84 = x38 * x81 + x38 * (x38 * x83 + x81) + x80
    x85 = x43 + x64 * x79
    x86 = x40 * x85
    x87 = x54 + x64 * x83
    x88 = x38 * x87 + x86
    x89 = x4 * x65
    x90 = x68 * x81
    x91 = x83 * x89 + x90
    x92 = x54 * x64 + x64 * x87 + x80
    x93 = x54 * x68
    x94 = x71 * x83 + x93
    x95 = x73 * x83 + x80
    x96 = -x9 - A[2]
    x97 = x10 * x30 - 2.0 * x18 * x2 * x21 * x25 * x26 * x31 * x96
    x98 = -x97
    x99 = -x10 * x24 + 2.0 * x18 * x2 * x21 * x25 * x26 * x28 * x96
    x100 = -x10 * x36 + 2.0 * x16 * x18 * x2 * x21 * x25 * x26 * x96
    x101 = x33 * (-x14 * (-x100 * x52 + x27 * x99) + x27 * x98 - x52 * x99)
    x102 = x100 * x40
    x103 = -x10 * x57 + 2.0 * x18 * x2 * x21 * x25 * x26 * x35 * x96
    x104 = x100 * x27 - x103 * x52
    x105 = x101 + x102 * x38 + x38 * (x102 + x104 * x38)
    x106 = x4 * x60
    x107 = x102 * x64
    x108 = x104 * x106 + x107
    x109 = x100 * x68 + x43
    x110 = x109 * x40
    x111 = x104 * x68 + x54
    x112 = x110 + x111 * x38
    x113 = x101 + x104 * x69
    x114 = x111 * x64
    x115 = x101 + x111 * x68 + x93
    x116 = x33 * (-x14 * x78 - x76)
    x117 = x5 * x59
    x118 = x116 + x117 * x79
    x119 = x38 * x85
    x120 = x79 * x89
    x121 = x116 + x61 + x64 * x85
    x122 = x66 + x71 * x79
    x123 = x116 + x73 * x79
    x124 = x50 * x7
    x125 = x33 * (-x124 * x78 - x14 * (-x124 * x79 + x49 + x75 * x78) - x48 + x75 * x77)
    x126 = -x124 * x82 + x56 + x75 * x79
    x127 = 2.0 * x81
    x128 = x126 * x64 + x127
    x129 = x33 * (-x124 * x99 - x14 * (-x100 * x124 + x75 * x99) + x75 * x98)
    x130 = x100 * x75 - x103 * x124
    x131 = x117 * x130 + x129
    x132 = x102 + x130 * x64
    x133 = x132 * x38
    x134 = x130 * x68 + x81
    x135 = x134 * x38
    x136 = x107 + x129 + x132 * x64
    x137 = x110 + x134 * x64
    x138 = x129 + x134 * x68 + x90
    x139 = x33 * (-x14 * x99 - x97)
    x140 = x100 * x117 + x139
    x141 = x100 * x106
    x142 = x0 * x109
    x143 = x100 * x69 + x139
    x144 = x109 * x68 + x139 + x66
    x145 = x109 * x19
    x146 = x10 * x50
    x147 = x33 * (-x14 * (-x100 * x146 + x49 + x96 * x99) - x146 * x99 - x48 + x96 * x98)
    x148 = x100 * x96 - x103 * x146 + x56
    x149 = 2.0 * x102 + x148 * x68
    x150 = x109 * x20

    # 54 item(s)
    return numpy.array(
        [
            x0 * x46 + x38 * (x38 * x58 + x55) + x41 * x44 + x53,
            x0 * x62 + x55 * x64 + x60 * x63,
            x0 * x67 + x55 * x68 + x63 * x65,
            x0 * x70 + x53 + x58 * x69,
            x0 * x72 + x58 * x71,
            x0 * x74 + x53 + x58 * x73,
            x19 * x46 + x84,
            x19 * x62 + x88,
            x19 * x67 + x91,
            x19 * x70 + x92,
            x19 * x72 + x94,
            x19 * x74 + x95,
            x105 + x20 * x46,
            x108 + x20 * x62,
            x112 + x20 * x67,
            x113 + x20 * x70,
            x114 + x20 * x72,
            x115 + x20 * x74,
            x0 * x118 + x84,
            x0 * x119 + x88,
            x0 * x120 + x91,
            x0 * x121 + x92,
            x0 * x122 + x94,
            x0 * x123 + x95,
            x117 * x126 + x118 * x19 + x125,
            x119 * x19 + x128 * x38,
            x120 * x19 + x126 * x89,
            x121 * x19 + x125 + x128 * x64 + 2.0 * x86,
            x122 * x19 + x126 * x71 + x127 * x68,
            x123 * x19 + x125 + x126 * x73,
            x118 * x20 + x131,
            x119 * x20 + x133,
            x120 * x20 + x135,
            x121 * x20 + x136,
            x122 * x20 + x137,
            x123 * x20 + x138,
            x0 * x140 + x105,
            x0 * x141 + x108,
            x112 + x142 * x38,
            x0 * x143 + x113,
            x114 + x142 * x64,
            x0 * x144 + x115,
            x131 + x140 * x19,
            x133 + x141 * x19,
            x135 + x145 * x38,
            x136 + x143 * x19,
            x137 + x145 * x64,
            x138 + x144 * x19,
            x117 * x148 + x140 * x20 + x147,
            x106 * x148 + x141 * x20,
            x149 * x38 + x150 * x38,
            x143 * x20 + x147 + x148 * x69,
            x149 * x64 + x150 * x64,
            2.0 * x110 + x144 * x20 + x147 + x149 * x68,
        ]
    )


def _3center2el3d_113(a, A, b, B, c, C):
    """Cartesian (pp|f) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c ** (-1.0)
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = a + b
    x4 = x3 ** (-1.0)
    x5 = -x4 * (a * A[0] + b * B[0])
    x6 = -x5 - C[0]
    x7 = 17.4934183276249
    x8 = A[0] - B[0]
    x9 = A[1] - B[1]
    x10 = A[2] - B[2]
    x11 = numpy.exp(-a * b * x4 * (x10**2 + x8**2 + x9**2))
    x12 = x11 * x4 * x7
    x13 = x6**2
    x14 = -x4 * (a * A[1] + b * B[1])
    x15 = -x14 - C[1]
    x16 = x15**2
    x17 = -x4 * (a * A[2] + b * B[2])
    x18 = -x17 - C[2]
    x19 = x18**2
    x20 = c + x3
    x21 = x20 ** (-1.0)
    x22 = x21 * x3
    x23 = c * x22 * (x13 + x16 + x19)
    x24 = boys(2, x23)
    x25 = x20 ** (-1.5)
    x26 = 2.0 * x25
    x27 = x24 * x26
    x28 = x12 * x27
    x29 = x20 ** (-0.5)
    x30 = -x5 - A[0]
    x31 = boys(1, x23)
    x32 = -2.0 * x0 * x11 * x29 * x30 * x31 * x4 * x7 + x28 * x6
    x33 = -x32
    x34 = x2 * x33
    x35 = boys(3, x23)
    x36 = x12 * x35
    x37 = x26 * x36
    x38 = 2.0 * x0 * x11 * x24 * x29 * x30 * x4 * x7 - x37 * x6
    x39 = x2 * x38
    x40 = x1 ** (-1.0)
    x41 = x40 * (2.0 * x0 * x11 * x24 * x29 * x4 * x7 - x37)
    x42 = boys(4, x23)
    x43 = x12 * x26
    x44 = x42 * x43
    x45 = 2.0 * x0 * x11 * x29 * x30 * x35 * x4 * x7 - x44 * x6
    x46 = x45 * x6
    x47 = c * x21
    x48 = x30 * x38 + x41 - x46 * x47
    x49 = x22 * x48
    x50 = -2.0 * x0 * x11 * x29 * x31 * x4 * x7
    x51 = -x28 - x50
    x52 = x40 * x51
    x53 = x47 * x6
    x54 = x38 * x53
    x55 = x30 * x33 + x52 - x54
    x56 = x22 * x6
    x57 = x22 * x38
    x58 = 2.0 * x2
    x59 = x0 * x29 * x58
    x60 = x12 * x59
    x61 = x24 * x60
    x62 = x31 * x60
    x63 = x0 * x11 * x7
    x64 = 0.5 * x0
    x65 = x64 * (-x27 * x63 - x50)
    x66 = x35 * x63
    x67 = x20 ** (-2.5) * x3 * x66
    x68 = 2.0 * x67
    x69 = x64 * (-x32 - x57)
    x70 = x36 * x59
    x71 = x22 * x46 + x70
    x72 = x58 * x6
    x73 = x25 * x66
    x74 = x56 * x71 + x69 + x72 * x73
    x75 = (
        x0 * (-x22 * (x57 * x6 + x61) + x33 * x56 + x62)
        + x2 * (x13 * x68 + x65)
        + x56 * x74
    )
    x76 = -x40 * x51
    x77 = x64 * (x30 * x33 - x49 - x54 - x76)
    x78 = x2 * x45
    x79 = 2.0 * x78
    x80 = x40 * (2.0 * x0 * x11 * x29 * x35 * x4 * x7 - x44)
    x81 = x43 * boys(5, x23)
    x82 = x30 * x45 - x53 * (2.0 * x0 * x11 * x29 * x30 * x4 * x42 * x7 - x6 * x81) + x80
    x83 = x3**2 / x20**2
    x84 = x15 * x83
    x85 = x0 * (x15 * x21 * x3 * x33 - x38 * x84)
    x86 = x58 * x73
    x87 = x15 * x86
    x88 = x46 * x84 + x87
    x89 = x67 * x72
    x90 = x15 * x89 + x56 * x88 + 0.5 * x85
    x91 = x0 * (x15 * x21 * x3 * x55 - x48 * x84)
    x92 = x6 * x82
    x93 = x15 * x22
    x94 = x18 * x83
    x95 = x0 * (x18 * x21 * x3 * x33 - x38 * x94)
    x96 = 0.5 * x95
    x97 = x18 * x86
    x98 = x46 * x94 + x97
    x99 = x18 * x89 + x56 * x98 + x96
    x100 = x0 * (x18 * x21 * x3 * x55 - x48 * x94)
    x101 = 0.5 * x100
    x102 = x18 * x22
    x103 = x2 * (x16 * x68 + x65)
    x104 = x16 * x83
    x105 = x104 * x45 + x69
    x106 = x103 + x105 * x56
    x107 = x105 * x2
    x108 = x104 * x82 + x77
    x109 = x3**3 / x20**3
    x110 = x109 * x18
    x111 = x110 * x15
    x112 = x15 * x18 * x58 * x67
    x113 = x111 * x46 + x112
    x114 = x18 * x84
    x115 = x2 * (x19 * x68 + x65)
    x116 = x19 * x83
    x117 = x116 * x45 + x69
    x118 = x115 + x117 * x56
    x119 = x117 * x2
    x120 = x116 * x82 + x77
    x121 = x105 * x93 + x85
    x122 = x110 * x16
    x123 = x122 * x45 + x96
    x124 = x117 * x93
    x125 = x102 * x117 + x95
    x126 = -x14 - A[1]
    x127 = -2.0 * x0 * x11 * x126 * x29 * x31 * x4 * x7 + x15 * x28
    x128 = -x127
    x129 = x128 * x2
    x130 = 2.0 * x0 * x11 * x126 * x24 * x29 * x4 * x7 - x15 * x37
    x131 = x130 * x2
    x132 = 2.0 * x0 * x11 * x126 * x29 * x35 * x4 * x7 - x15 * x44
    x133 = x130 * x30 - x132 * x53
    x134 = x133 * x22
    x135 = -x128 * x30 + x130 * x53
    x136 = -x135
    x137 = x130 * x22
    x138 = x64 * (-x127 - x137)
    x139 = x13 * x83
    x140 = x132 * x139 + x138
    x141 = x64 * (-x134 - x135)
    x142 = x132 * x2
    x143 = 2.0 * x0 * x11 * x126 * x29 * x4 * x42 * x7 - x15 * x81
    x144 = x132 * x30 - x143 * x53
    x145 = (
        x0 * (x129 + x136 * x56 - x22 * (x131 + x134 * x6))
        + x140 * x2
        + x56 * (x141 + x142 * x56 + x56 * (x142 + x144 * x56))
    )
    x146 = x0 * (x136 * x93 - x22 * (x134 * x15 + x39) + x34)
    x147 = x132 * x93 + x70
    x148 = x147 * x2
    x149 = x144 * x93 + x78
    x150 = 0.5 * x146 + x148 * x56 + x56 * (x148 + x149 * x56)
    x151 = x0 * (-x133 * x94 + x136 * x18 * x21 * x3)
    x152 = 0.5 * x151
    x153 = x6 * x94
    x154 = x102 * x142
    x155 = x142 * x153 + x152 + x56 * (x144 * x153 + x154)
    x156 = x138 + x147 * x93 + x87
    x157 = x156 * x2
    x158 = x141 + x149 * x93 + x78 * x93
    x159 = x157 + x158 * x56
    x160 = x114 * x132 + x97
    x161 = x160 * x2
    x162 = x102 * x78
    x163 = x114 * x144 + x162
    x164 = x161 + x163 * x56
    x165 = x116 * x132 + x138
    x166 = x165 * x2
    x167 = x116 * x144 + x141
    x168 = x166 + x167 * x56
    x169 = x107 + x146 + x158 * x93
    x170 = x114 * x78 + x152 + x163 * x93
    x171 = x119 + x167 * x93
    x172 = x102 * x167 + x151
    x173 = -x17 - A[2]
    x174 = -2.0 * x0 * x11 * x173 * x29 * x31 * x4 * x7 + x18 * x28
    x175 = -x174
    x176 = x175 * x2
    x177 = 2.0 * x0 * x11 * x173 * x24 * x29 * x4 * x7 - x18 * x37
    x178 = x177 * x2
    x179 = 2.0 * x0 * x11 * x173 * x29 * x35 * x4 * x7 - x18 * x44
    x180 = x177 * x30 - x179 * x53
    x181 = x180 * x22
    x182 = -x175 * x30 + x177 * x53
    x183 = -x182
    x184 = x177 * x22
    x185 = x64 * (-x174 - x184)
    x186 = x139 * x179 + x185
    x187 = x64 * (-x181 - x182)
    x188 = x179 * x2
    x189 = 2.0 * x0 * x11 * x173 * x29 * x4 * x42 * x7 - x18 * x81
    x190 = x179 * x30 - x189 * x53
    x191 = (
        x0 * (x176 + x183 * x56 - x22 * (x178 + x181 * x6))
        + x186 * x2
        + x56 * (x187 + x188 * x56 + x56 * (x188 + x190 * x56))
    )
    x192 = x0 * (x15 * x183 * x21 * x3 - x180 * x84)
    x193 = x6 * x84
    x194 = x188 * x93
    x195 = x188 * x193 + 0.5 * x192 + x56 * (x190 * x193 + x194)
    x196 = x0 * (x102 * x183 - x22 * (x18 * x181 + x39) + x34)
    x197 = 0.5 * x196
    x198 = x102 * x179 + x70
    x199 = x198 * x2
    x200 = x102 * x190 + x78
    x201 = x197 + x199 * x56 + x56 * (x199 + x200 * x56)
    x202 = x104 * x179 + x185
    x203 = x2 * x202
    x204 = x104 * x190 + x187
    x205 = x203 + x204 * x56
    x206 = x199 * x93
    x207 = x193 * x200 + x206
    x208 = x102 * x198 + x185 + x97
    x209 = x2 * x208
    x210 = x102 * x200 + x162 + x187
    x211 = x209 + x210 * x56
    x212 = x192 + x204 * x93
    x213 = x104 * x200 + x197
    x214 = x210 * x93
    x215 = x102 * x210 + x119 + x196
    x216 = x6 * x83
    x217 = x0 * (x128 * x21 * x3 * x6 - x130 * x216) + x140 * x56
    x218 = x0 * (x128 * x93 - x22 * (x137 * x15 + x61) + x62)
    x219 = x139 * x147 + 0.5 * x218
    x220 = x0 * (x128 * x18 * x21 * x3 - x130 * x94)
    x221 = 0.5 * x220
    x222 = x110 * x13
    x223 = x132 * x222 + x221
    x224 = x56 * x8
    x225 = x103 + x156 * x93 + x218
    x226 = x112 + x160 * x93 + x221
    x227 = x115 + x165 * x93
    x228 = x102 * x165 + x220
    x229 = x15 * x47
    x230 = x126 * x130 - x132 * x229 + x41
    x231 = x130 * x229
    x232 = x126 * x128 - x231 + x52
    x233 = x22 * x230
    x234 = x64 * (x126 * x128 - x231 - x233 - x76)
    x235 = x126 * x132 - x143 * x229 + x80
    x236 = x0 * (2.0 * x129 - x22 * (2.0 * x131 + x15 * x233) + x232 * x93)
    x237 = 2.0 * x142
    x238 = x235 * x93 + x237
    x239 = x0 * (x18 * x21 * x232 * x3 - x230 * x94)
    x240 = 0.5 * x239
    x241 = 2.0 * x148 + x234 + x238 * x93
    x242 = x56 * x9
    x243 = x102 * x237 + x114 * x235
    x244 = x116 * x235 + x234
    x245 = x126 * x177 - x179 * x229
    x246 = -x126 * x175 + x177 * x229
    x247 = -x246
    x248 = x22 * x245
    x249 = x64 * (-x246 - x248)
    x250 = x126 * x179 - x189 * x229
    x251 = x0 * (x21 * x247 * x3 * x6 - x216 * x245) + x56 * (x139 * x250 + x249)
    x252 = x0 * (x176 - x22 * (x15 * x248 + x178) + x247 * x93)
    x253 = x188 + x250 * x93
    x254 = x139 * x253 + 0.5 * x252
    x255 = x0 * (x102 * x247 + x129 - x22 * (x131 + x18 * x248))
    x256 = 0.5 * x255
    x257 = x102 * x250 + x142
    x258 = x139 * x257 + x256
    x259 = x194 + x249 + x253 * x93
    x260 = x259 * x56
    x261 = x10 * x56
    x262 = x199 + x257 * x93
    x263 = x262 * x56
    x264 = x102 * x257 + x154 + x249
    x265 = x264 * x56
    x266 = x203 + x252 + x259 * x93
    x267 = x206 + x256 + x262 * x93
    x268 = x209 + x264 * x93
    x269 = x102 * x264 + x166 + x255
    x270 = x0 * (x175 * x21 * x3 * x6 - x177 * x216) + x186 * x56
    x271 = x0 * (x15 * x175 * x21 * x3 - x177 * x84)
    x272 = x109 * x13 * x15
    x273 = x179 * x272 + 0.5 * x271
    x274 = x0 * (x102 * x175 - x22 * (x18 * x184 + x61) + x62)
    x275 = 0.5 * x274
    x276 = x139 * x198 + x275
    x277 = x193 * x198
    x278 = x202 * x93 + x271
    x279 = x104 * x198 + x275
    x280 = x208 * x93
    x281 = x102 * x208 + x115 + x274
    x282 = x18 * x47
    x283 = x173 * x177 - x179 * x282 + x41
    x284 = x177 * x282
    x285 = x173 * x175 - x284 + x52
    x286 = x22 * x283
    x287 = x64 * (x173 * x175 - x284 - x286 - x76)
    x288 = x173 * x179 - x189 * x282 + x80
    x289 = x0 * (x15 * x21 * x285 * x3 - x283 * x84)
    x290 = x0 * (x102 * x285 + 2.0 * x176 - x22 * (2.0 * x178 + x18 * x286))
    x291 = 0.5 * x290
    x292 = x102 * x288 + 2.0 * x188
    x293 = x104 * x288 + x287
    x294 = x102 * x292 + 2.0 * x199 + x287

    # 90 item(s)
    return numpy.array(
        [
            x0 * (-x22 * (2.0 * x39 + x49 * x6) + 2.0 * x34 + x55 * x56)
            + x56 * (x56 * (x56 * x82 + x79) + x58 * x71 + x77)
            + x58 * x74
            + x75 * x8,
            x56 * (x79 * x93 + x84 * x92) + x58 * x88 + x8 * x90 + 0.5 * x91,
            x101 + x56 * (x102 * x79 + x92 * x94) + x58 * x98 + x8 * x99,
            x106 * x8 + 2.0 * x107 + x108 * x56,
            x111 * x92 + x113 * x8 + x114 * x79,
            x118 * x8 + 2.0 * x119 + x120 * x56,
            x108 * x93 + x121 * x8 + x91,
            x101 + x122 * x82 + x123 * x8,
            x120 * x93 + x124 * x8,
            x100 + x102 * x120 + x125 * x8,
            x145 + x75 * x9,
            x150 + x9 * x90,
            x155 + x9 * x99,
            x106 * x9 + x159,
            x113 * x9 + x164,
            x118 * x9 + x168,
            x121 * x9 + x169,
            x123 * x9 + x170,
            x124 * x9 + x171,
            x125 * x9 + x172,
            x10 * x75 + x191,
            x10 * x90 + x195,
            x10 * x99 + x201,
            x10 * x106 + x205,
            x10 * x113 + x207,
            x10 * x118 + x211,
            x10 * x121 + x212,
            x10 * x123 + x213,
            x10 * x124 + x214,
            x10 * x125 + x215,
            x145 + x217 * x8,
            x150 + x219 * x8,
            x155 + x223 * x8,
            x156 * x224 + x159,
            x160 * x224 + x164,
            x165 * x224 + x168,
            x169 + x225 * x8,
            x170 + x226 * x8,
            x171 + x227 * x8,
            x172 + x228 * x8,
            x0 * (x21 * x232 * x3 * x6 - x216 * x230)
            + x217 * x9
            + x56 * (x139 * x235 + x234),
            x139 * x238 + x219 * x9 + 0.5 * x236,
            x222 * x235 + x223 * x9 + x240,
            x156 * x242 + x241 * x56,
            x160 * x242 + x243 * x56,
            x165 * x242 + x244 * x56,
            2.0 * x157 + x225 * x9 + x236 + x241 * x93,
            2.0 * x161 + x226 * x9 + x240 + x243 * x93,
            2.0 * x166 + x227 * x9 + x244 * x93,
            x102 * x244 + x228 * x9 + x239,
            x10 * x217 + x251,
            x10 * x219 + x254,
            x10 * x223 + x258,
            x156 * x261 + x260,
            x160 * x261 + x263,
            x165 * x261 + x265,
            x10 * x225 + x266,
            x10 * x226 + x267,
            x10 * x227 + x268,
            x10 * x228 + x269,
            x191 + x270 * x8,
            x195 + x273 * x8,
            x201 + x276 * x8,
            x202 * x224 + x205,
            x207 + x277 * x8,
            x208 * x224 + x211,
            x212 + x278 * x8,
            x213 + x279 * x8,
            x214 + x280 * x8,
            x215 + x281 * x8,
            x251 + x270 * x9,
            x254 + x273 * x9,
            x258 + x276 * x9,
            x202 * x242 + x260,
            x263 + x277 * x9,
            x208 * x242 + x265,
            x266 + x278 * x9,
            x267 + x279 * x9,
            x268 + x280 * x9,
            x269 + x281 * x9,
            x0 * (x21 * x285 * x3 * x6 - x216 * x283)
            + x10 * x270
            + x56 * (x139 * x288 + x287),
            x10 * x273 + x272 * x288 + 0.5 * x289,
            x10 * x276 + x139 * x292 + x291,
            x202 * x261 + x293 * x56,
            x10 * x277 + x193 * x292,
            x208 * x261 + x294 * x56,
            x10 * x278 + x289 + x293 * x93,
            x10 * x279 + x104 * x292 + x291,
            x10 * x280 + x294 * x93,
            x10 * x281 + x102 * x294 + 2.0 * x209 + x290,
        ]
    )


def _3center2el3d_114(a, A, b, B, c, C):
    """Cartesian (pp|g) three-center two-electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = 2.0 * a + 2.0 * b
    x2 = (2.0 * c + x1) ** (-1.0)
    x3 = c ** (-1.0)
    x4 = 17.4934183276249
    x5 = a + b
    x6 = c + x5
    x7 = x6 ** (-1.5)
    x8 = x5 ** (-1.0)
    x9 = -x8 * (a * A[0] + b * B[0])
    x10 = -x9 - C[0]
    x11 = x10**2
    x12 = -x8 * (a * A[1] + b * B[1])
    x13 = -x12 - C[1]
    x14 = x13**2
    x15 = -x8 * (a * A[2] + b * B[2])
    x16 = -x15 - C[2]
    x17 = x16**2
    x18 = x6 ** (-1.0)
    x19 = x18 * x5
    x20 = c * x19 * (x11 + x14 + x17)
    x21 = boys(2, x20)
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x8 * (x0**2 + x22**2 + x23**2))
    x25 = boys(3, x20)
    x26 = x24 * x3 * x4
    x27 = x25 * x26
    x28 = x10 * x27
    x29 = x5 * x6 ** (-2.5)
    x30 = 2.0 * x29
    x31 = 2.0 * x7
    x32 = x6 ** (-0.5)
    x33 = -2.0 * x21 * x24 * x3 * x32 * x4 * x8
    x34 = 0.5 * x3
    x35 = x34 * (-x27 * x31 - x33)
    x36 = boys(4, x20)
    x37 = x26 * x36
    x38 = x30 * x37
    x39 = x11 * x38 + x35
    x40 = x10 * x19
    x41 = x24 * x31 * x4
    x42 = x41 * x8
    x43 = x21 * x42
    x44 = -x9 - A[0]
    x45 = boys(1, x20)
    x46 = x10 * x43 - 2.0 * x24 * x3 * x32 * x4 * x44 * x45 * x8
    x47 = -x46
    x48 = x41 * x45 * x8
    x49 = boys(0, x20)
    x50 = x10 * x48 - 2.0 * x24 * x3 * x32 * x4 * x44 * x49 * x8
    x51 = x34 * (-x19 * x47 - x50)
    x52 = x25 * x42
    x53 = x10 * x52 - 2.0 * x21 * x24 * x3 * x32 * x4 * x44 * x8
    x54 = -x53
    x55 = x19 * x54
    x56 = x34 * (-x46 - x55)
    x57 = x36 * x42
    x58 = -x10 * x57 + 2.0 * x24 * x25 * x3 * x32 * x4 * x44 * x8
    x59 = x19 * x58
    x60 = 2.0 * x2
    x61 = x27 * x60
    x62 = x32 * x8
    x63 = x61 * x62
    x64 = x10 * x59 + x63
    x65 = x19 * x64
    x66 = x60 * x7
    x67 = x21 * x26
    x68 = x60 * x62
    x69 = x67 * x68
    x70 = x10 * x55 + x69
    x71 = x10 * x66
    x72 = 1.5 * x3
    x73 = x34 * (-x53 - x59)
    x74 = boys(5, x20)
    x75 = x42 * x74
    x76 = -x10 * x75 + 2.0 * x24 * x3 * x32 * x36 * x4 * x44 * x8
    x77 = x37 * x68
    x78 = x40 * x76 + x77
    x79 = x37 * x71 + x40 * x78 + x73
    x80 = x2 * x39 + x3 * (-x65 + x70) + x40 * x79
    x81 = (
        x2 * (x3 * (2.0 * x10 * x21 * x24 * x3 * x4 * x7 - x28 * x30) + x39 * x40)
        + x40 * x80
        + x72 * (-x19 * (x10 * x65 + x28 * x66 + x56) + x40 * x70 + x51 + x67 * x71)
    )
    x82 = x1 ** (-1.0)
    x83 = -x82 * (2.0 * x24 * x3 * x32 * x4 * x49 * x8 - x48)
    x84 = 2.0 * x24 * x3 * x32 * x4 * x45 * x8 - x43
    x85 = x82 * x84
    x86 = c * x18
    x87 = x10 * x54
    x88 = x86 * x87
    x89 = x10 * x86
    x90 = x34 * (-x19 * (x44 * x47 + x85 - x88) - x44 * x50 - x47 * x89 - x83)
    x91 = -x82 * x84
    x92 = -x33 - x52
    x93 = x82 * x92
    x94 = x58 * x89
    x95 = x44 * x54 + x93 - x94
    x96 = x19 * x95
    x97 = x34 * (x44 * x47 - x88 - x91 - x96)
    x98 = x2 * x58
    x99 = 2.0 * x98
    x100 = x82 * (2.0 * x24 * x25 * x3 * x32 * x4 * x8 - x57)
    x101 = x100 + x44 * x58 - x76 * x89
    x102 = x101 * x19
    x103 = x19 * (x10 * x102 + x99)
    x104 = x2 * x54
    x105 = 2.0 * x104
    x106 = x10 * x96 + x105
    x107 = -x82 * x92
    x108 = x34 * (-x102 - x107 + x44 * x54 - x94)
    x109 = x2 * x76
    x110 = 2.0 * x109
    x111 = x82 * (2.0 * x24 * x3 * x32 * x36 * x4 * x8 - x75)
    x112 = x42 * boys(6, x20)
    x113 = (
        x111
        + x44 * x76
        - x89 * (-x10 * x112 + 2.0 * x24 * x3 * x32 * x4 * x44 * x74 * x8)
    )
    x114 = x5**2
    x115 = x6 ** (-2.0)
    x116 = x114 * x115
    x117 = x101 * x116
    x118 = x117 * x13
    x119 = x13 * x19
    x120 = x116 * x13
    x121 = x10 * x120
    x122 = x13 * x58
    x123 = x116 * x122
    x124 = x61 * x7
    x125 = x124 * x13
    x126 = x13 * x66
    x127 = x126 * x67
    x128 = x27 * x30
    x129 = x3 * (-x128 * x13 + 2.0 * x13 * x21 * x24 * x3 * x4 * x7)
    x130 = x13 * x37
    x131 = x6 ** (-3.5)
    x132 = 2.0 * x114 * x131
    x133 = x11 * x132
    x134 = x3 * (-x123 + x13 * x18 * x5 * x54)
    x135 = x126 * x37
    x136 = x121 * x76 + x135
    x137 = x10 * x29 * x60
    x138 = x130 * x137 + 0.5 * x134 + x136 * x40
    x139 = (
        x138 * x40
        + x2 * (0.5 * x129 + x130 * x133)
        + x3 * (x120 * x87 + x127 - x19 * (x10 * x123 + x125))
    )
    x140 = x3 * (-x118 + x13 * x18 * x5 * x95)
    x141 = x117 * x16
    x142 = x16 * x19
    x143 = x116 * x16
    x144 = x10 * x143
    x145 = x116 * x58
    x146 = x145 * x16
    x147 = x124 * x16
    x148 = x16 * x66
    x149 = x148 * x67
    x150 = x3 * (-x128 * x16 + 2.0 * x16 * x21 * x24 * x3 * x4 * x7)
    x151 = 0.5 * x150
    x152 = x16 * x37
    x153 = x3 * (-x146 + x16 * x18 * x5 * x54)
    x154 = 0.5 * x153
    x155 = x148 * x37
    x156 = x144 * x76 + x155
    x157 = x137 * x152 + x154 + x156 * x40
    x158 = (
        x157 * x40
        + x2 * (x133 * x152 + x151)
        + x3 * (x143 * x87 + x149 - x19 * (x10 * x146 + x147))
    )
    x159 = x3 * (-x141 + x16 * x18 * x5 * x95)
    x160 = 0.5 * x159
    x161 = x116 * x14
    x162 = x161 * x54 - x19 * (x14 * x145 + x56) + x51
    x163 = x14 * x38 + x35
    x164 = x163 * x2
    x165 = x161 * x76 + x73
    x166 = x164 + x165 * x40
    x167 = x162 * x34 + x164 * x40 + x166 * x40
    x168 = x161 * x95 - x19 * (x117 * x14 + x97) + x90
    x169 = x165 * x2
    x170 = x108 + x113 * x161
    x171 = x5**3 / x6**3
    x172 = x16 * x171
    x173 = x3 * (x114 * x115 * x13 * x16 * x54 - x122 * x172)
    x174 = x13 * x172
    x175 = x10 * x174
    x176 = x130 * x16 * x60
    x177 = x176 * x29
    x178 = x175 * x76 + x177
    x179 = x10 * x114 * x131 * x176 + 0.5 * x173 + x178 * x40
    x180 = x3 * (-x101 * x174 + x114 * x115 * x13 * x16 * x95)
    x181 = x13 * x143
    x182 = x116 * x17
    x183 = x182 * x54 - x19 * (x145 * x17 + x56) + x51
    x184 = x183 * x34
    x185 = x17 * x38 + x35
    x186 = x185 * x2
    x187 = x182 * x76 + x73
    x188 = x186 + x187 * x40
    x189 = x184 + x186 * x40 + x188 * x40
    x190 = x182 * x95 - x19 * (x117 * x17 + x97) + x90
    x191 = x190 * x34
    x192 = x187 * x2
    x193 = 2.0 * x192
    x194 = x108 + x113 * x182
    x195 = x2 * (x119 * x163 + x129)
    x196 = x119 * x165 + x134
    x197 = x195 + x196 * x40
    x198 = x196 * x2
    x199 = x119 * x170 + x140
    x200 = x2 * (x132 * x14 * x152 + x151)
    x201 = x14 * x172
    x202 = x154 + x201 * x76
    x203 = x200 + x202 * x40
    x204 = x2 * x202
    x205 = x113 * x201 + x160
    x206 = x119 * x186
    x207 = x121 * x187 + x206
    x208 = x2 * (x142 * x185 + x150)
    x209 = x142 * x187 + x153
    x210 = x208 + x209 * x40
    x211 = x2 * x209
    x212 = x142 * x194 + x159
    x213 = x119 * x196 + x162 * x72
    x214 = x119 * x202 + x173
    x215 = x161 * x187 + x184
    x216 = x119 * x209
    x217 = x142 * x209 + x183 * x72
    x218 = -x12 - A[1]
    x219 = -x13 * x57 + 2.0 * x218 * x24 * x25 * x3 * x32 * x4 * x8
    x220 = x116 * x219
    x221 = x13 * x52 - 2.0 * x21 * x218 * x24 * x3 * x32 * x4 * x8
    x222 = -x221
    x223 = x19 * x219
    x224 = x34 * (-x221 - x223)
    x225 = -x13 * x75 + 2.0 * x218 * x24 * x3 * x32 * x36 * x4 * x8
    x226 = x11 * x116
    x227 = x224 + x225 * x226
    x228 = x227 * x40 + x3 * (x10 * x18 * x222 * x5 - x10 * x220)
    x229 = x13 * x48 - 2.0 * x218 * x24 * x3 * x32 * x4 * x49 * x8
    x230 = -x229
    x231 = x13 * x43 - 2.0 * x218 * x24 * x3 * x32 * x4 * x45 * x8
    x232 = -x231
    x233 = x222 * x89 - x232 * x44
    x234 = x34 * (x19 * x233 + x230 * x44 - x232 * x89)
    x235 = x219 * x89 - x222 * x44
    x236 = -x235
    x237 = x19 * x236
    x238 = x34 * (-x233 - x237)
    x239 = x2 * x219
    x240 = x219 * x44 - x225 * x89
    x241 = x19 * x240
    x242 = x19 * (x10 * x241 + x239)
    x243 = x2 * x222
    x244 = x10 * x237 + x243
    x245 = x34 * (-x235 - x241)
    x246 = x2 * x225
    x247 = -x112 * x13 + 2.0 * x218 * x24 * x3 * x32 * x4 * x74 * x8
    x248 = x225 * x44 - x247 * x89
    x249 = (
        x2 * x228
        + x40
        * (
            x2 * x227
            + x3 * (-x242 + x244)
            + x40 * (x245 + x246 * x40 + x40 * (x246 + x248 * x40))
        )
        + x72 * (-x19 * (x10 * x242 + x238 + x239 * x40) + x234 + x243 * x40 + x244 * x40)
    )
    x250 = x19 * x222
    x251 = x13 * x250 + x69
    x252 = x2 * x251
    x253 = x13 * x223 + x63
    x254 = x2 * x253
    x255 = x19 * (x13 * x241 + x98)
    x256 = x104 + x13 * x237
    x257 = x19 * x253
    x258 = x3 * (x251 - x257)
    x259 = x119 * x225 + x77
    x260 = x226 * x259 + 0.5 * x258
    x261 = x3 * (-x255 + x256)
    x262 = x2 * x259
    x263 = x109 + x119 * x248
    x264 = (
        x2 * x260
        + x3 * (-x19 * (x10 * x255 + x254) + x252 + x256 * x40)
        + x40 * (0.5 * x261 + x262 * x40 + x40 * (x262 + x263 * x40))
    )
    x265 = x143 * x240
    x266 = x142 * x239
    x267 = x142 * x243
    x268 = x16 * x220
    x269 = x3 * (x16 * x18 * x222 * x5 - x268)
    x270 = 0.5 * x269
    x271 = x11 * x172
    x272 = x225 * x271 + x270
    x273 = x3 * (x16 * x18 * x236 * x5 - x265)
    x274 = 0.5 * x273
    x275 = x142 * x246
    x276 = (
        x2 * x272
        + x3 * (x144 * x236 - x19 * (x10 * x265 + x266) + x267)
        + x40 * (x144 * x246 + x274 + x40 * (x144 * x248 + x275))
    )
    x277 = x104 * x119 + x119 * x256 - x19 * (x119 * x98 + x13 * x255 + x238) + x234
    x278 = x119 * x259 + x135 + x224
    x279 = x2 * x278
    x280 = x109 * x119 + x119 * x263 + x245
    x281 = x277 * x34 + x279 * x40 + x40 * (x279 + x280 * x40)
    x282 = x142 * x98
    x283 = x104 * x142
    x284 = x3 * (x181 * x236 - x19 * (x13 * x265 + x282) + x283)
    x285 = x155 + x181 * x225
    x286 = x2 * x285
    x287 = x109 * x142
    x288 = x181 * x248 + x287
    x289 = 0.5 * x284 + x286 * x40 + x40 * (x286 + x288 * x40)
    x290 = x182 * x236 - x19 * (x182 * x240 + x238) + x234
    x291 = x290 * x34
    x292 = x182 * x225 + x224
    x293 = x2 * x292
    x294 = x182 * x248 + x245
    x295 = x291 + x293 * x40 + x40 * (x293 + x294 * x40)
    x296 = x119 * x278 + x164 + x258
    x297 = x2 * x296
    x298 = x119 * x280 + x169 + x261
    x299 = x297 + x298 * x40
    x300 = x119 * x285 + x177 + x270
    x301 = x2 * x300
    x302 = x109 * x181 + x119 * x288 + x274
    x303 = x301 + x302 * x40
    x304 = x119 * x292 + x186
    x305 = x2 * x304
    x306 = x119 * x294 + x192
    x307 = x305 + x306 * x40
    x308 = x142 * x292 + x269
    x309 = x2 * x308
    x310 = x142 * x294 + x273
    x311 = x309 + x310 * x40
    x312 = x119 * x298 + x198 + x277 * x72
    x313 = x119 * x302 + x204 + x284
    x314 = x119 * x192 + x119 * x306 + x291
    x315 = x119 * x310 + x211
    x316 = x142 * x310 + x290 * x72
    x317 = -x15 - A[2]
    x318 = -x16 * x57 + 2.0 * x24 * x25 * x3 * x317 * x32 * x4 * x8
    x319 = x116 * x318
    x320 = x16 * x52 - 2.0 * x21 * x24 * x3 * x317 * x32 * x4 * x8
    x321 = -x320
    x322 = x19 * x318
    x323 = x34 * (-x320 - x322)
    x324 = -x16 * x75 + 2.0 * x24 * x3 * x317 * x32 * x36 * x4 * x8
    x325 = x226 * x324 + x323
    x326 = x3 * (x10 * x18 * x321 * x5 - x10 * x319) + x325 * x40
    x327 = x16 * x48 - 2.0 * x24 * x3 * x317 * x32 * x4 * x49 * x8
    x328 = -x327
    x329 = x16 * x43 - 2.0 * x24 * x3 * x317 * x32 * x4 * x45 * x8
    x330 = -x329
    x331 = x321 * x89 - x330 * x44
    x332 = x34 * (x19 * x331 + x328 * x44 - x330 * x89)
    x333 = x318 * x89 - x321 * x44
    x334 = -x333
    x335 = x19 * x334
    x336 = x34 * (-x331 - x335)
    x337 = x2 * x318
    x338 = x318 * x44 - x324 * x89
    x339 = x19 * x338
    x340 = x19 * (x10 * x339 + x337)
    x341 = x2 * x321
    x342 = x10 * x335 + x341
    x343 = x34 * (-x333 - x339)
    x344 = x2 * x324
    x345 = -x112 * x16 + 2.0 * x24 * x3 * x317 * x32 * x4 * x74 * x8
    x346 = x324 * x44 - x345 * x89
    x347 = (
        x2 * x326
        + x40
        * (
            x2 * x325
            + x3 * (-x340 + x342)
            + x40 * (x343 + x344 * x40 + x40 * (x344 + x346 * x40))
        )
        + x72 * (-x19 * (x10 * x340 + x336 + x337 * x40) + x332 + x341 * x40 + x342 * x40)
    )
    x348 = x120 * x338
    x349 = x119 * x337
    x350 = x119 * x341
    x351 = x3 * (x13 * x18 * x321 * x5 - x13 * x319)
    x352 = x13 * x171
    x353 = x11 * x352
    x354 = x324 * x353 + 0.5 * x351
    x355 = x3 * (x13 * x18 * x334 * x5 - x348)
    x356 = x119 * x344
    x357 = (
        x2 * x354
        + x3 * (x121 * x334 - x19 * (x10 * x348 + x349) + x350)
        + x40 * (x121 * x344 + 0.5 * x355 + x40 * (x121 * x346 + x356))
    )
    x358 = x19 * x321
    x359 = x16 * x358 + x69
    x360 = x2 * x359
    x361 = x16 * x322 + x63
    x362 = x2 * x361
    x363 = x16 * x339 + x98
    x364 = x19 * x363
    x365 = x104 + x16 * x335
    x366 = x19 * x361
    x367 = x3 * (x359 - x366)
    x368 = 0.5 * x367
    x369 = x142 * x324 + x77
    x370 = x226 * x369 + x368
    x371 = x3 * (-x364 + x365)
    x372 = 0.5 * x371
    x373 = x2 * x369
    x374 = x109 + x142 * x346
    x375 = (
        x2 * x370
        + x3 * (-x19 * (x10 * x364 + x362) + x360 + x365 * x40)
        + x40 * (x372 + x373 * x40 + x40 * (x373 + x374 * x40))
    )
    x376 = x161 * x334 - x19 * (x161 * x338 + x336) + x332
    x377 = x161 * x324 + x323
    x378 = x2 * x377
    x379 = x161 * x346 + x343
    x380 = x34 * x376 + x378 * x40 + x40 * (x378 + x379 * x40)
    x381 = x3 * (-x120 * x363 + x13 * x18 * x365 * x5)
    x382 = x119 * x373
    x383 = x121 * x373 + 0.5 * x381 + x40 * (x121 * x374 + x382)
    x384 = x142 * x365 - x19 * (x16 * x364 + x282 + x336) + x283 + x332
    x385 = x34 * x384
    x386 = x142 * x369 + x155 + x323
    x387 = x2 * x386
    x388 = x142 * x374 + x287 + x343
    x389 = x385 + x387 * x40 + x40 * (x387 + x388 * x40)
    x390 = x119 * x377 + x351
    x391 = x2 * x390
    x392 = x119 * x379 + x355
    x393 = x391 + x392 * x40
    x394 = x161 * x369 + x368
    x395 = x2 * x394
    x396 = x161 * x374 + x372
    x397 = x395 + x396 * x40
    x398 = x119 * x387
    x399 = x121 * x388 + x398
    x400 = x142 * x386 + x186 + x367
    x401 = x2 * x400
    x402 = x142 * x388 + x192 + x371
    x403 = x40 * x402 + x401
    x404 = x119 * x392 + x376 * x72
    x405 = x119 * x396 + x381
    x406 = x161 * x388 + x385
    x407 = x119 * x402
    x408 = x142 * x402 + x211 + x384 * x72
    x409 = x34 * (-x19 * x232 - x229)
    x410 = x34 * (-x231 - x250)
    x411 = x228 * x40 + x72 * (-x19 * (x11 * x220 + x410) + x222 * x226 + x409)
    x412 = x10 * x116
    x413 = x260 * x40 + x3 * (x10 * x18 * x251 * x5 - x253 * x412)
    x414 = x10 * x172
    x415 = x272 * x40 + x3 * (x10 * x114 * x115 * x16 * x222 - x219 * x414)
    x416 = x119 * x251 + x127 - x19 * (x125 + x13 * x257 + x410) + x409
    x417 = x226 * x278 + x34 * x416
    x418 = x3 * (x149 + x181 * x222 - x19 * (x13 * x268 + x147))
    x419 = x226 * x285 + 0.5 * x418
    x420 = x182 * x222 - x19 * (x182 * x219 + x410) + x409
    x421 = x34 * x420
    x422 = x226 * x292 + x421
    x423 = x0 * x40
    x424 = x119 * x296 + x195 + x416 * x72
    x425 = x119 * x300 + x200 + x418
    x426 = x119 * x304 + x206 + x421
    x427 = x119 * x308 + x208
    x428 = x142 * x308 + x420 * x72
    x429 = x13 * x86
    x430 = x222 * x429
    x431 = x34 * (-x19 * (x218 * x232 - x430 + x85) + x218 * x230 - x232 * x429 - x83)
    x432 = x219 * x429
    x433 = x218 * x222 - x432 + x93
    x434 = x19 * x433
    x435 = x34 * (x218 * x232 - x430 - x434 - x91)
    x436 = x100 + x218 * x219 - x225 * x429
    x437 = x19 * x436
    x438 = x34 * (-x107 + x218 * x222 - x432 - x437)
    x439 = x111 + x218 * x225 - x247 * x429
    x440 = 2.0 * x239
    x441 = x13 * x437 + x440
    x442 = 2.0 * x243
    x443 = x13 * x434 + x442
    x444 = x19 * x441
    x445 = x3 * (x443 - x444)
    x446 = 2.0 * x246
    x447 = x119 * x439 + x446
    x448 = x143 * x436
    x449 = x3 * (x16 * x18 * x433 * x5 - x448)
    x450 = 0.5 * x449
    x451 = x119 * x443 - x19 * (x13 * x444 + 2.0 * x254 + x435) + 2.0 * x252 + x431
    x452 = x119 * x447 + 2.0 * x262 + x438
    x453 = x3 * (x142 * x442 + x181 * x433 - x19 * (x13 * x448 + x142 * x440))
    x454 = x142 * x446 + x181 * x439
    x455 = x182 * x433 - x19 * (x182 * x436 + x435) + x431
    x456 = x34 * x455
    x457 = x182 * x439 + x438
    x458 = x119 * x452 + 2.0 * x279 + x445
    x459 = x22 * x40
    x460 = x119 * x454 + 2.0 * x286 + x450
    x461 = x119 * x457 + 2.0 * x293
    x462 = x142 * x457 + x4