import numpy

from pysisyphus.wavefunction.ints.boys import boys


def _3center2el3d_sph_000(a, A, b, B, c, C):
    """Cartesian (ss|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = c + x0

    # 1 item(s)
    return numpy.array(
        [
            34.9868366552497
            * x1
            * x2 ** (-0.5)
            * boys(
                0,
                c
                * x0
                * (
                    (x1 * (a * A[0] + b * B[0]) - C[0]) ** 2
                    + (x1 * (a * A[1] + b * B[1]) - C[1]) ** 2
                    + (x1 * (a * A[2] + b * B[2]) - C[2]) ** 2
                )
                / x2,
            )
            * numpy.exp(
                -a
                * b
                * x1
                * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
            )
            / c
        ]
    )


def _3center2el3d_sph_001(a, A, b, B, c, C):
    """Cartesian (ss|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - C[0]
    x3 = c + x0
    x4 = x1 * (a * A[1] + b * B[1]) - C[1]
    x5 = x1 * (a * A[2] + b * B[2]) - C[2]
    x6 = (
        34.9868366552497
        * x3 ** (-1.5)
        * boys(1, c * x0 * (x2**2 + x4**2 + x5**2) / x3)
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        / c
    )

    # 3 item(s)
    return numpy.array([x2 * x6, x4 * x6, x5 * x6])


def _3center2el3d_sph_002(a, A, b, B, c, C):
    """Cartesian (ss|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - C[0]
    x3 = x2**2
    x4 = c + x0
    x5 = x1 * (a * A[1] + b * B[1]) - C[1]
    x6 = x5**2
    x7 = x1 * (a * A[2] + b * B[2]) - C[2]
    x8 = x7**2
    x9 = (
        34.9868366552497
        * x0
        * x4 ** (-2.5)
        * boys(2, c * x0 * (x3 + x6 + x8) / x4)
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        / c
    )
    x10 = x2 * x9

    # 6 item(s)
    return numpy.array([x3 * x9, x10 * x5, x10 * x7, x6 * x9, x5 * x7 * x9, x8 * x9])


def _3center2el3d_sph_003(a, A, b, B, c, C):
    """Cartesian (ss|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - C[0]
    x3 = c + x0
    x4 = x2**2
    x5 = x1 * (a * A[1] + b * B[1]) - C[1]
    x6 = x5**2
    x7 = x1 * (a * A[2] + b * B[2]) - C[2]
    x8 = x7**2
    x9 = (
        34.9868366552497
        * x0**2
        * x3 ** (-3.5)
        * boys(3, c * x0 * (x4 + x6 + x8) / x3)
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        / c
    )
    x10 = x4 * x9
    x11 = x2 * x9

    # 10 item(s)
    return numpy.array(
        [
            x2**3 * x9,
            x10 * x5,
            x10 * x7,
            x11 * x6,
            x11 * x5 * x7,
            x11 * x8,
            x5**3 * x9,
            x6 * x7 * x9,
            x5 * x8 * x9,
            x7**3 * x9,
        ]
    )


def _3center2el3d_sph_004(a, A, b, B, c, C):
    """Cartesian (ss|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - C[0]
    x3 = c + x0
    x4 = x2**2
    x5 = x1 * (a * A[1] + b * B[1]) - C[1]
    x6 = x5**2
    x7 = x1 * (a * A[2] + b * B[2]) - C[2]
    x8 = x7**2
    x9 = (
        34.9868366552497
        * x0**3
        * x3 ** (-4.5)
        * boys(4, c * x0 * (x4 + x6 + x8) / x3)
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        / c
    )
    x10 = x2**3 * x9
    x11 = x4 * x9
    x12 = x5**3
    x13 = x2 * x9
    x14 = x7**3

    # 15 item(s)
    return numpy.array(
        [
            x2**4 * x9,
            x10 * x5,
            x10 * x7,
            x11 * x6,
            x11 * x5 * x7,
            x11 * x8,
            x12 * x13,
            x13 * x6 * x7,
            x13 * x5 * x8,
            x13 * x14,
            x5**4 * x9,
            x12 * x7 * x9,
            x6 * x8 * x9,
            x14 * x5 * x9,
            x7**4 * x9,
        ]
    )


def _3center2el3d_sph_005(a, A, b, B, c, C):
    """Cartesian (ss|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - C[0]
    x3 = c + x0
    x4 = x2**2
    x5 = x1 * (a * A[1] + b * B[1]) - C[1]
    x6 = x5**2
    x7 = x1 * (a * A[2] + b * B[2]) - C[2]
    x8 = x7**2
    x9 = (
        34.9868366552497
        * x0**4
        * x3 ** (-5.5)
        * boys(5, c * x0 * (x4 + x6 + x8) / x3)
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        / c
    )
    x10 = x2**4 * x9
    x11 = x2**3 * x9
    x12 = x5**3
    x13 = x4 * x9
    x14 = x7**3
    x15 = x5**4
    x16 = x2 * x9
    x17 = x7**4

    # 21 item(s)
    return numpy.array(
        [
            x2**5 * x9,
            x10 * x5,
            x10 * x7,
            x11 * x6,
            x11 * x5 * x7,
            x11 * x8,
            x12 * x13,
            x13 * x6 * x7,
            x13 * x5 * x8,
            x13 * x14,
            x15 * x16,
            x12 * x16 * x7,
            x16 * x6 * x8,
            x14 * x16 * x5,
            x16 * x17,
            x5**5 * x9,
            x15 * x7 * x9,
            x12 * x8 * x9,
            x14 * x6 * x9,
            x17 * x5 * x9,
            x7**5 * x9,
        ]
    )


def _3center2el3d_sph_010(a, A, b, B, c, C):
    """Cartesian (sp|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = -x1 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x1 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = c * x0 * (x3**2 + x6**2 + x8**2) / x4
    x10 = A[0] - B[0]
    x11 = A[1] - B[1]
    x12 = A[2] - B[2]
    x13 = (
        34.9868366552497 * x1 * numpy.exp(-a * b * x1 * (x10**2 + x11**2 + x12**2))
    )
    x14 = x13 * x4 ** (-1.5) * boys(1, x9)
    x15 = x13 * x4 ** (-0.5) * boys(0, x9) / c

    # 3 item(s)
    return numpy.array(
        [
            x10 * x15 - x14 * x3 + x15 * (-x2 - A[0]),
            x11 * x15 - x14 * x6 + x15 * (-x5 - A[1]),
            x12 * x15 - x14 * x8 + x15 * (-x7 - A[2]),
        ]
    )


def _3center2el3d_sph_011(a, A, b, B, c, C):
    """Cartesian (sp|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 / x4
    x12 = c * x11 * (x10**2 + x3**2 + x8**2)
    x13 = 17.4934183276249
    x14 = A[0] - B[0]
    x15 = A[1] - B[1]
    x16 = A[2] - B[2]
    x17 = numpy.exp(-a * b * x1 * (x14**2 + x15**2 + x16**2))
    x18 = 2.0 * x1 * x13 * x17
    x19 = x18 * boys(2, x12)
    x20 = c ** (-1.0)
    x21 = x4 ** (-0.5)
    x22 = boys(1, x12)
    x23 = 2.0 * x1 * x13 * x17 * x20 * x21 * x22 * (-x2 - A[0]) - x19 * x6
    x24 = x20 * x22
    x25 = x18 * x21 * x24 / (2.0 * a + 2.0 * b)
    x26 = 2.0 * x13 * x17 * x24
    x27 = x14 * x26
    x28 = x11 * x23
    x29 = x27 * x5
    x30 = x19 * x5
    x31 = 2.0 * x1 * x13 * x17 * x20 * x21 * x22 * (-x7 - A[1]) - x30 * x8
    x32 = x11 * x31
    x33 = x15 * x26
    x34 = x33 * x5
    x35 = 2.0 * x1 * x13 * x17 * x20 * x21 * x22 * (-x9 - A[2]) - x10 * x30
    x36 = x11 * x35
    x37 = x16 * x26
    x38 = x37 * x5

    # 9 item(s)
    return numpy.array(
        [
            x11 * (x23 * x3 + x25) + x27 * x6,
            x28 * x8 + x29 * x8,
            x10 * x28 + x10 * x29,
            x3 * x32 + x33 * x6,
            x11 * (x25 + x31 * x8) + x34 * x8,
            x10 * x32 + x10 * x34,
            x3 * x36 + x37 * x6,
            x36 * x8 + x38 * x8,
            x10 * x38 + x11 * (x10 * x35 + x25),
        ]
    )


def _3center2el3d_sph_012(a, A, b, B, c, C):
    """Cartesian (sp|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = x3**2
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = x0 / x4
    x15 = c * x14 * (x10 + x13 + x7)
    x16 = 17.4934183276249
    x17 = A[0] - B[0]
    x18 = A[1] - B[1]
    x19 = A[2] - B[2]
    x20 = numpy.exp(-a * b * x1 * (x17**2 + x18**2 + x19**2))
    x21 = 2.0 * x16 * x20
    x22 = x1 * x21
    x23 = x22 * boys(3, x15)
    x24 = c ** (-1.0)
    x25 = x4 ** (-0.5)
    x26 = boys(2, x15)
    x27 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x2 - A[0]) - x23 * x6
    x28 = x27 * x3
    x29 = (2.0 * a + 2.0 * b) ** (-1.0)
    x30 = x24 * x26
    x31 = x22 * x25 * x29 * x30
    x32 = x21 * x30
    x33 = x29 * x32
    x34 = x0 * x32 * x4 ** (-2.5)
    x35 = x17 * x34
    x36 = x14 * x9
    x37 = x33 * x5
    x38 = x37 * x9
    x39 = x3 * x9
    x40 = x12 * x14
    x41 = x12 * x37
    x42 = x12 * x3
    x43 = x0**2 / x4**2
    x44 = x27 * x43
    x45 = x12 * x9
    x46 = x23 * x5
    x47 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x8 - A[1]) - x46 * x9
    x48 = x43 * x47
    x49 = x18 * x34
    x50 = x47 * x9
    x51 = x31 + x50
    x52 = x3 * x43
    x53 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x11 - A[2]) - x12 * x46
    x54 = x43 * x53
    x55 = x19 * x34
    x56 = x12 * x53 + x31

    # 18 item(s)
    return numpy.array(
        [
            x14 * (x14 * x3 * (x28 + x31) + x33 * x6) + x35 * x7,
            x14 * (x28 * x36 + x38) + x35 * x39,
            x14 * (x28 * x40 + x41) + x35 * x42,
            x10 * x35 + x10 * x44,
            x35 * x45 + x44 * x45,
            x13 * x35 + x13 * x44,
            x48 * x7 + x49 * x7,
            x39 * x49 + x51 * x52,
            x42 * x48 + x42 * x49,
            x10 * x49 + x14 * (x36 * x51 + x38),
            x14 * (x40 * x50 + x41) + x45 * x49,
            x13 * x48 + x13 * x49,
            x54 * x7 + x55 * x7,
            x39 * x55 + x52 * x53 * x9,
            x42 * x55 + x52 * x56,
            x10 * x54 + x10 * x55,
            x43 * x56 * x9 + x45 * x55,
            x13 * x55 + x14 * (x40 * x56 + x41),
        ]
    )


def _3center2el3d_sph_013(a, A, b, B, c, C):
    """Cartesian (sp|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = x3**2
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = x0 / x4
    x15 = c * x14 * (x10 + x13 + x7)
    x16 = 17.4934183276249
    x17 = A[0] - B[0]
    x18 = A[1] - B[1]
    x19 = A[2] - B[2]
    x20 = numpy.exp(-a * b * x1 * (x17**2 + x18**2 + x19**2))
    x21 = 2.0 * x16 * x20
    x22 = x1 * x21
    x23 = x22 * boys(4, x15)
    x24 = c ** (-1.0)
    x25 = x4 ** (-0.5)
    x26 = boys(3, x15)
    x27 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x2 - A[0]) - x23 * x6
    x28 = x27 * x3
    x29 = (2.0 * a + 2.0 * b) ** (-1.0)
    x30 = x24 * x26
    x31 = x22 * x25 * x29 * x30
    x32 = x14 * x3
    x33 = x21 * x30
    x34 = x29 * x33
    x35 = x0 * x34 * x4 ** (-2.5)
    x36 = x3**3
    x37 = x0**2
    x38 = x33 * x37 * x4 ** (-3.5)
    x39 = x17 * x38
    x40 = x14 * x9
    x41 = x34 * x5
    x42 = x41 * x9
    x43 = x3 * x9
    x44 = x7 * x9
    x45 = x12 * x14
    x46 = x12 * x41
    x47 = x12 * x35
    x48 = x12 * x7
    x49 = x37 / x4**2
    x50 = x28 * x49
    x51 = x10 * x35
    x52 = x10 * x3
    x53 = x49 * x9
    x54 = x47 * x9
    x55 = x12 * x43
    x56 = x13 * x35
    x57 = x13 * x3
    x58 = x9**3
    x59 = x0**3 / x4**3
    x60 = x27 * x59
    x61 = x10 * x12
    x62 = x13 * x9
    x63 = x12**3
    x64 = x23 * x5
    x65 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x8 - A[1]) - x64 * x9
    x66 = x59 * x65
    x67 = x18 * x38
    x68 = x65 * x9
    x69 = x31 + x68
    x70 = x59 * x7
    x71 = x40 * x69 + x42
    x72 = x3 * x49
    x73 = x45 * x68 + x46
    x74 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x11 - A[2]) - x12 * x64
    x75 = x59 * x74
    x76 = x19 * x38
    x77 = x12 * x74 + x31
    x78 = x59 * x77
    x79 = x45 * x77 + x46

    # 30 item(s)
    return numpy.array(
        [
            x14 * (x32 * (x32 * (x28 + x31) + x34 * x6) + x35 * x7) + x36 * x39,
            x14 * (x32 * (x28 * x40 + x42) + x35 * x43) + x39 * x44,
            x14 * (x3 * x47 + x32 * (x28 * x45 + x46)) + x39 * x48,
            x14 * (x10 * x50 + x51) + x39 * x52,
            x14 * (x12 * x28 * x53 + x54) + x39 * x55,
            x14 * (x13 * x50 + x56) + x39 * x57,
            x39 * x58 + x58 * x60,
            x39 * x61 + x60 * x61,
            x39 * x62 + x60 * x62,
            x39 * x63 + x60 * x63,
            x36 * x66 + x36 * x67,
            x44 * x67 + x69 * x70,
            x48 * x66 + x48 * x67,
            x52 * x67 + x71 * x72,
            x55 * x67 + x72 * x73,
            x57 * x66 + x57 * x67,
            x14 * (x40 * x71 + x51) + x58 * x67,
            x14 * (x40 * x73 + x54) + x61 * x67,
            x14 * (x13 * x49 * x68 + x56) + x62 * x67,
            x63 * x66 + x63 * x67,
            x36 * x75 + x36 * x76,
            x44 * x76 + x70 * x74 * x9,
            x48 * x76 + x70 * x77,
            x52 * x75 + x52 * x76,
            x43 * x78 + x55 * x76,
            x57 * x76 + x72 * x79,
            x58 * x75 + x58 * x76,
            x10 * x78 + x61 * x76,
            x53 * x79 + x62 * x76,
            x14 * (x45 * x79 + x56) + x63 * x76,
        ]
    )


def _3center2el3d_sph_014(a, A, b, B, c, C):
    """Cartesian (sp|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = x3**2
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = x0 / x4
    x15 = c * x14 * (x10 + x13 + x7)
    x16 = 17.4934183276249
    x17 = A[0] - B[0]
    x18 = A[1] - B[1]
    x19 = A[2] - B[2]
    x20 = numpy.exp(-a * b * x1 * (x17**2 + x18**2 + x19**2))
    x21 = 2.0 * x16 * x20
    x22 = x1 * x21
    x23 = x22 * boys(5, x15)
    x24 = c ** (-1.0)
    x25 = x4 ** (-0.5)
    x26 = boys(4, x15)
    x27 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x2 - A[0]) - x23 * x6
    x28 = x27 * x3
    x29 = (2.0 * a + 2.0 * b) ** (-1.0)
    x30 = x24 * x26
    x31 = x22 * x25 * x29 * x30
    x32 = x14 * x3
    x33 = x21 * x30
    x34 = x29 * x33
    x35 = x34 * x7
    x36 = x0 * x4 ** (-2.5)
    x37 = x3**3
    x38 = x0**2
    x39 = x38 * x4 ** (-3.5)
    x40 = x34 * x39
    x41 = x3**4
    x42 = x0**3
    x43 = x33 * x4 ** (-4.5) * x42
    x44 = x17 * x43
    x45 = x14 * x9
    x46 = x34 * x5
    x47 = x46 * x9
    x48 = x3 * x9
    x49 = x34 * x36
    x50 = x7 * x9
    x51 = x37 * x9
    x52 = x12 * x14
    x53 = x12 * x46
    x54 = x12 * x49
    x55 = x12 * x37
    x56 = x38 / x4**2
    x57 = x28 * x56
    x58 = x10 * x49
    x59 = x10 * x3
    x60 = x10 * x7
    x61 = x56 * x9
    x62 = x54 * x9
    x63 = x12 * x44
    x64 = x13 * x49
    x65 = x13 * x7
    x66 = x9**3
    x67 = x42 / x4**3
    x68 = x28 * x67
    x69 = x40 * x66
    x70 = x3 * x66
    x71 = x10 * x12
    x72 = x40 * x71
    x73 = x13 * x9
    x74 = x40 * x73
    x75 = x13 * x48
    x76 = x12**3
    x77 = x40 * x76
    x78 = x3 * x76
    x79 = x9**4
    x80 = x0**4 / x4**4
    x81 = x27 * x80
    x82 = x12 * x66
    x83 = x10 * x13
    x84 = x76 * x9
    x85 = x12**4
    x86 = x23 * x5
    x87 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x8 - A[1]) - x86 * x9
    x88 = x80 * x87
    x89 = x18 * x43
    x90 = x87 * x9
    x91 = x31 + x90
    x92 = x37 * x80
    x93 = x45 * x91 + x47
    x94 = x67 * x7
    x95 = x52 * x90 + x53
    x96 = x12 * x89
    x97 = x45 * x93 + x58
    x98 = x3 * x56
    x99 = x45 * x95 + x62
    x100 = x13 * x56 * x90 + x64
    x101 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x11 - A[2]) - x12 * x86
    x102 = x101 * x80
    x103 = x19 * x43
    x104 = x101 * x12 + x31
    x105 = x104 * x80
    x106 = x103 * x12
    x107 = x104 * x52 + x53
    x108 = x107 * x67
    x109 = x107 * x52 + x64

    # 45 item(s)
    return numpy.array(
        [
            x14 * (x32 * (x32 * (x32 * (x28 + x31) + x34 * x6) + x35 * x36) + x37 * x40)
            + x41 * x44,
            x14 * (x32 * (x32 * (x28 * x45 + x47) + x48 * x49) + x40 * x50) + x44 * x51,
            x14 * (x12 * x35 * x39 + x32 * (x3 * x54 + x32 * (x28 * x52 + x53)))
            + x44 * x55,
            x14 * (x32 * (x10 * x57 + x58) + x40 * x59) + x44 * x60,
            x14 * (x12 * x40 * x48 + x32 * (x12 * x28 * x61 + x62)) + x50 * x63,
            x14 * (x13 * x3 * x40 + x32 * (x13 * x57 + x64)) + x44 * x65,
            x14 * (x66 * x68 + x69) + x44 * x70,
            x14 * (x68 * x71 + x72) + x59 * x63,
            x14 * (x68 * x73 + x74) + x44 * x75,
            x14 * (x68 * x76 + x77) + x44 * x78,
            x44 * x79 + x79 * x81,
            x44 * x82 + x81 * x82,
            x44 * x83 + x81 * x83,
            x44 * x84 + x81 * x84,
            x44 * x85 + x81 * x85,
            x41 * x88 + x41 * x89,
            x51 * x89 + x91 * x92,
            x55 * x88 + x55 * x89,
            x60 * x89 + x93 * x94,
            x50 * x96 + x94 * x95,
            x65 * x88 + x65 * x89,
            x70 * x89 + x97 * x98,
            x59 * x96 + x98 * x99,
            x100 * x98 + x75 * x89,
            x78 * x88 + x78 * x89,
            x14 * (x45 * x97 + x69) + x79 * x89,
            x14 * (x45 * x99 + x72) + x82 * x89,
            x14 * (x100 * x45 + x74) + x83 * x89,
            x14 * (x67 * x76 * x90 + x77) + x84 * x89,
            x85 * x88 + x85 * x89,
            x102 * x41 + x103 * x41,
            x101 * x9 * x92 + x103 * x51,
            x103 * x55 + x104 * x92,
            x102 * x60 + x103 * x60,
            x105 * x50 + x106 * x50,
            x103 * x65 + x107 * x94,
            x102 * x70 + x103 * x70,
            x105 * x59 + x106 * x59,
            x103 * x75 + x108 * x48,
            x103 * x78 + x109 * x98,
            x102 * x79 + x103 * x79,
            x103 * x82 + x105 * x66,
            x10 * x108 + x103 * x83,
            x103 * x84 + x109 * x61,
            x103 * x85 + x14 * (x109 * x52 + x77),
        ]
    )


def _3center2el3d_sph_015(a, A, b, B, c, C):
    """Cartesian (sp|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = x3**2
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = x0 / x4
    x15 = c * x14 * (x10 + x13 + x7)
    x16 = 17.4934183276249
    x17 = A[0] - B[0]
    x18 = A[1] - B[1]
    x19 = A[2] - B[2]
    x20 = numpy.exp(-a * b * x1 * (x17**2 + x18**2 + x19**2))
    x21 = 2.0 * x16 * x20
    x22 = x1 * x21
    x23 = x22 * boys(6, x15)
    x24 = c ** (-1.0)
    x25 = x4 ** (-0.5)
    x26 = boys(5, x15)
    x27 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x2 - A[0]) - x23 * x6
    x28 = x27 * x3
    x29 = (2.0 * a + 2.0 * b) ** (-1.0)
    x30 = x24 * x26
    x31 = x22 * x25 * x29 * x30
    x32 = x14 * x3
    x33 = x21 * x30
    x34 = x29 * x33
    x35 = x34 * x7
    x36 = x0 * x4 ** (-2.5)
    x37 = x0**2
    x38 = x37 * x4 ** (-3.5)
    x39 = x3**3
    x40 = x34 * x39
    x41 = x3**4
    x42 = x0**3
    x43 = x4 ** (-4.5) * x42
    x44 = x34 * x43
    x45 = x3**5
    x46 = x0**4
    x47 = x33 * x4 ** (-5.5) * x46
    x48 = x17 * x47
    x49 = x14 * x9
    x50 = x34 * x5
    x51 = x50 * x9
    x52 = x3 * x9
    x53 = x34 * x36
    x54 = x7 * x9
    x55 = x34 * x38
    x56 = x39 * x9
    x57 = x41 * x9
    x58 = x12 * x14
    x59 = x12 * x50
    x60 = x12 * x53
    x61 = x12 * x41
    x62 = x37 / x4**2
    x63 = x28 * x62
    x64 = x10 * x53
    x65 = x10 * x3
    x66 = x10 * x7
    x67 = x10 * x39
    x68 = x62 * x9
    x69 = x60 * x9
    x70 = x12 * x44
    x71 = x12 * x48
    x72 = x13 * x53
    x73 = x13 * x39
    x74 = x9**3
    x75 = x42 / x4**3
    x76 = x28 * x75
    x77 = x55 * x74
    x78 = x3 * x74
    x79 = x7 * x74
    x80 = x10 * x12
    x81 = x55 * x80
    x82 = x13 * x9
    x83 = x55 * x82
    x84 = x13 * x48
    x85 = x12**3
    x86 = x55 * x85
    x87 = x7 * x85
    x88 = x9**4
    x89 = x46 / x4**4
    x90 = x28 * x89
    x91 = x44 * x88
    x92 = x3 * x88
    x93 = x12 * x74
    x94 = x44 * x93
    x95 = x10 * x13
    x96 = x44 * x95
    x97 = x85 * x9
    x98 = x44 * x97
    x99 = x52 * x85
    x100 = x12**4
    x101 = x100 * x44
    x102 = x100 * x3
    x103 = x9**5
    x104 = x0**5 / x4**5
    x105 = x104 * x27
    x106 = x12 * x88
    x107 = x13 * x74
    x108 = x10 * x85
    x109 = x100 * x9
    x110 = x12**5
    x111 = x23 * x5
    x112 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x8 - A[1]) - x111 * x9
    x113 = x104 * x112
    x114 = x18 * x47
    x115 = x112 * x9
    x116 = x115 + x31
    x117 = x104 * x41
    x118 = x116 * x49 + x51
    x119 = x39 * x89
    x120 = x115 * x58 + x59
    x121 = x114 * x12
    x122 = x118 * x49 + x64
    x123 = x7 * x75
    x124 = x120 * x49 + x69
    x125 = x115 * x13 * x62 + x72
    x126 = x114 * x13
    x127 = x122 * x49 + x77
    x128 = x3 * x62
    x129 = x124 * x49 + x81
    x130 = x125 * x49 + x83
    x131 = x115 * x75 * x85 + x86
    x132 = 2.0 * x1 * x16 * x20 * x24 * x25 * x26 * (-x11 - A[2]) - x111 * x12
    x133 = x104 * x132
    x134 = x19 * x47
    x135 = x12 * x132 + x31
    x136 = x104 * x135
    x137 = x12 * x134
    x138 = x135 * x58 + x59
    x139 = x138 * x89
    x140 = x13 * x134
    x141 = x138 * x58 + x72
    x142 = x141 * x75
    x143 = x141 * x58 + x86

    # 63 item(s)
    return numpy.array(
        [
            x14
            * (
                x32
                * (x32 * (x32 * (x32 * (x28 + x31) + x34 * x6) + x35 * x36) + x38 * x40)
                + x41 * x44
            )
            + x45 * x48,
            x14
            * (
                x32 * (x32 * (x32 * (x28 * x49 + x51) + x52 * x53) + x54 * x55)
                + x44 * x56
            )
            + x48 * x57,
            x14
            * (
                x12 * x40 * x43
                + x32 * (x12 * x35 * x38 + x32 * (x3 * x60 + x32 * (x28 * x58 + x59)))
            )
            + x48 * x61,
            x14 * (x32 * (x32 * (x10 * x63 + x64) + x55 * x65) + x44 * x66) + x48 * x67,
            x14 * (x32 * (x12 * x52 * x55 + x32 * (x12 * x28 * x68 + x69)) + x54 * x70)
            + x56 * x71,
            x14 * (x13 * x35 * x43 + x32 * (x13 * x3 * x55 + x32 * (x13 * x63 + x72)))
            + x48 * x73,
            x14 * (x32 * (x74 * x76 + x77) + x44 * x78) + x48 * x79,
            x14 * (x32 * (x76 * x80 + x81) + x65 * x70) + x66 * x71,
            x14 * (x13 * x44 * x52 + x32 * (x76 * x82 + x83)) + x54 * x84,
            x14 * (x3 * x44 * x85 + x32 * (x76 * x85 + x86)) + x48 * x87,
            x14 * (x88 * x90 + x91) + x48 * x92,
            x14 * (x90 * x93 + x94) + x71 * x78,
            x14 * (x90 * x95 + x96) + x65 * x84,
            x14 * (x90 * x97 + x98) + x48 * x99,
            x102 * x48 + x14 * (x100 * x90 + x101),
            x103 * x105 + x103 * x48,
            x105 * x106 + x106 * x48,
            x105 * x107 + x107 * x48,
            x105 * x108 + x108 * x48,
            x105 * x109 + x109 * x48,
            x105 * x110 + x110 * x48,
            x113 * x45 + x114 * x45,
            x114 * x57 + x116 * x117,
            x113 * x61 + x114 * x61,
            x114 * x67 + x118 * x119,
            x119 * x120 + x121 * x56,
            x113 * x73 + x114 * x73,
            x114 * x79 + x122 * x123,
            x121 * x66 + x123 * x124,
            x123 * x125 + x126 * x54,
            x113 * x87 + x114 * x87,
            x114 * x92 + x127 * x128,
            x121 * x78 + x128 * x129,
            x126 * x65 + x128 * x130,
            x114 * x99 + x128 * x131,
            x102 * x113 + x102 * x114,
            x103 * x114 + x14 * (x127 * x49 + x91),
            x106 * x114 + x14 * (x129 * x49 + x94),
            x107 * x114 + x14 * (x130 * x49 + x96),
            x108 * x114 + x14 * (x131 * x49 + x98),
            x109 * x114 + x14 * (x100 * x115 * x89 + x101),
            x110 * x113 + x110 * x114,
            x133 * x45 + x134 * x45,
            x117 * x132 * x9 + x134 * x57,
            x117 * x135 + x134 * x61,
            x133 * x67 + x134 * x67,
            x136 * x56 + x137 * x56,
            x119 * x138 + x134 * x73,
            x133 * x79 + x134 * x79,
            x136 * x66 + x137 * x66,
            x139 * x54 + x140 * x54,
            x123 * x141 + x134 * x87,
            x133 * x92 + x134 * x92,
            x136 * x78 + x137 * x78,
            x139 * x65 + x140 * x65,
            x134 * x99 + x142 * x52,
            x102 * x134 + x128 * x143,
            x103 * x133 + x103 * x134,
            x106 * x134 + x136 * x88,
            x107 * x134 + x139 * x74,
            x10 * x142 + x108 * x134,
            x109 * x134 + x143 * x68,
            x110 * x134 + x14 * (x101 + x143 * x58),
        ]
    )


def _3center2el3d_sph_020(a, A, b, B, c, C):
    """Cartesian (sd|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = c + x0
    x9 = c / x8
    x10 = x0 * x9 * (x3**2 + x5**2 + x7**2)
    x11 = boys(1, x10)
    x12 = 17.4934183276249
    x13 = A[0] - B[0]
    x14 = A[1] - B[1]
    x15 = A[2] - B[2]
    x16 = numpy.exp(-a * b * x1 * (x13**2 + x14**2 + x15**2))
    x17 = 2.0 * x1 * x12 * x16
    x18 = x17 * x8 ** (-1.5)
    x19 = x11 * x18
    x20 = c ** (-1.0)
    x21 = x8 ** (-0.5)
    x22 = boys(0, x10)
    x23 = (2.0 * x1 * x12 * x16 * x20 * x21 * x22 - x19) / (2.0 * a + 2.0 * b)
    x24 = x19 * x3
    x25 = -x2 - A[0]
    x26 = 2.0 * x1 * x12 * x16 * x20 * x21 * x22 * x25 - x24
    x27 = x17 * x20 * x21 * x22
    x28 = x18 * boys(2, x10)
    x29 = x3 * x9
    x30 = x19 * x5
    x31 = -x4 - A[1]
    x32 = x14 * x27 + x27 * x31 - x30
    x33 = 2.0 * x1 * x12 * x16 * x20 * x21 * x22 * x31 - x30
    x34 = 2.0 * x1 * x11 * x12 * x16 * x20 * x21 * x31 - x28 * x5
    x35 = x19 * x7
    x36 = -x6 - A[2]
    x37 = x15 * x27 + x27 * x36 - x35
    x38 = 2.0 * x1 * x12 * x16 * x20 * x21 * x22 * x36 - x35
    x39 = 2.0 * x1 * x11 * x12 * x16 * x20 * x21 * x36 - x28 * x7
    x40 = x5 * x9

    # 6 item(s)
    return numpy.array(
        [
            x13 * x26
            + x13 * (x13 * x27 - x24 + x25 * x27)
            + x23
            + x25 * x26
            - x29 * (2.0 * x1 * x11 * x12 * x16 * x20 * x21 * x25 - x28 * x3),
            x13 * x32 + x14 * x26 + x25 * x33 - x29 * x34,
            x13 * x37 + x15 * x26 + x25 * x38 - x29 * x39,
            x14 * x32 + x14 * x33 + x23 + x31 * x33 - x34 * x40,
            x14 * x37 + x15 * x33 + x31 * x38 - x39 * x40,
            x15 * x37 + x15 * x38 + x23 + x36 * x38 - x39 * x7 * x9,
        ]
    )


def _3center2el3d_sph_021(a, A, b, B, c, C):
    """Cartesian (sd|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x2 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x2 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = c + x1
    x10 = x9 ** (-1.0)
    x11 = x1 * x10
    x12 = c * x11 * (x4**2 + x6**2 + x8**2)
    x13 = boys(2, x12)
    x14 = x9 ** (-1.5)
    x15 = 17.4934183276249
    x16 = A[1] - B[1]
    x17 = A[2] - B[2]
    x18 = numpy.exp(-a * b * x2 * (x0**2 + x16**2 + x17**2))
    x19 = 2.0 * x15 * x18 * x2
    x20 = x14 * x19
    x21 = x13 * x20
    x22 = c ** (-1.0)
    x23 = x9 ** (-0.5)
    x24 = -x3 - A[0]
    x25 = boys(1, x12)
    x26 = 2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x25 - x21 * x4
    x27 = (2.0 * a + 2.0 * b) ** (-1.0)
    x28 = x22 * x25
    x29 = x19 * x23 * x27 * x28
    x30 = x11 * (x26 * x4 + x29)
    x31 = 2.0 * x14 * x15 * x18 * x28
    x32 = x0 * x31
    x33 = x27 * (2.0 * x15 * x18 * x2 * x22 * x23 * x25 - x21)
    x34 = x20 * boys(3, x12)
    x35 = c * x10
    x36 = x35 * x4
    x37 = (
        x24 * x26 + x33 - x36 * (2.0 * x13 * x15 * x18 * x2 * x22 * x23 * x24 - x34 * x4)
    )
    x38 = x26 * x27
    x39 = x11 * x6
    x40 = x26 * x39
    x41 = x11 * x8
    x42 = x26 * x41
    x43 = -x5 - A[1]
    x44 = 2.0 * x15 * x18 * x2 * x22 * x23 * x25 * x43 - x21 * x6
    x45 = x11 * x4
    x46 = x44 * x45
    x47 = x16 * x31
    x48 = x4 * x47 + x46
    x49 = x27 * x44
    x50 = 2.0 * x13 * x15 * x18 * x2 * x22 * x23 * x43 - x34 * x6
    x51 = x24 * x44 - x36 * x50
    x52 = x11 * (x29 + x44 * x6)
    x53 = x47 * x6 + x52
    x54 = x41 * x44
    x55 = x47 * x8 + x54
    x56 = -x7 - A[2]
    x57 = 2.0 * x15 * x18 * x2 * x22 * x23 * x25 * x56 - x21 * x8
    x58 = x45 * x57
    x59 = x17 * x31
    x60 = x4 * x59 + x58
    x61 = x27 * x57
    x62 = 2.0 * x13 * x15 * x18 * x2 * x22 * x23 * x56 - x34 * x8
    x63 = x24 * x57 - x36 * x62
    x64 = x39 * x57
    x65 = x59 * x6 + x64
    x66 = x11 * (x29 + x57 * x8)
    x67 = x59 * x8 + x66
    x68 = x35 * x6
    x69 = x33 + x43 * x44 - x50 * x68
    x70 = x43 * x57 - x62 * x68
    x71 = x33 - x35 * x62 * x8 + x56 * x57

    # 18 item(s)
    return numpy.array(
        [
            x0 * x30 + x0 * (x30 + x32 * x4) + x11 * (x37 * x4 + 2.0 * x38),
            x0 * x40 + x0 * (x32 * x6 + x40) + x37 * x39,
            x0 * x42 + x0 * (x32 * x8 + x42) + x37 * x41,
            x0 * x48 + x11 * (x4 * x51 + x49) + x16 * x30,
            x0 * x53 + x11 * (x38 + x51 * x6) + x16 * x40,
            x0 * x55 + x16 * x42 + x41 * x51,
            x0 * x60 + x11 * (x4 * x63 + x61) + x17 * x30,
            x0 * x65 + x17 * x40 + x39 * x63,
            x0 * x67 + x11 * (x38 + x63 * x8) + x17 * x42,
            x16 * x46 + x16 * x48 + x45 * x69,
            x11 * (2.0 * x49 + x6 * x69) + x16 * x52 + x16 * x53,
            x16 * x54 + x16 * x55 + x41 * x69,
            x16 * x60 + x17 * x46 + x45 * x70,
            x11 * (x6 * x70 + x61) + x16 * x65 + x17 * x52,
            x11 * (x49 + x70 * x8) + x16 * x67 + x17 * x54,
            x17 * x58 + x17 * x60 + x45 * x71,
            x17 * x64 + x17 * x65 + x39 * x71,
            x11 * (2.0 * x61 + x71 * x8) + x17 * x66 + x17 * x67,
        ]
    )


def _3center2el3d_sph_022(a, A, b, B, c, C):
    """Cartesian (sd|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x4**2
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x1
    x13 = x12 ** (-1.0)
    x14 = x1 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(3, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[1] - B[1]
    x20 = A[2] - B[2]
    x21 = numpy.exp(-a * b * x2 * (x0**2 + x19**2 + x20**2))
    x22 = x18 * x2 * x21
    x23 = 2.0 * x17 * x22
    x24 = x16 * x23
    x25 = c ** (-1.0)
    x26 = x12 ** (-0.5)
    x27 = -x3 - A[0]
    x28 = boys(2, x15)
    x29 = 2.0 * x18 * x2 * x21 * x25 * x26 * x27 * x28 - x24 * x4
    x30 = x29 * x4
    x31 = (2.0 * a + 2.0 * b) ** (-1.0)
    x32 = 2.0 * x31
    x33 = x25 * x28
    x34 = x22 * x26 * x32 * x33
    x35 = x30 + x34
    x36 = x14 * x4
    x37 = x18 * x21 * x33
    x38 = x37 * x4
    x39 = x17 * x32
    x40 = x14 * (x35 * x36 + x38 * x39)
    x41 = 2.0 * x1 * x12 ** (-2.5)
    x42 = x37 * x41
    x43 = x0 * x42
    x44 = x31 * (2.0 * x18 * x2 * x21 * x25 * x26 * x28 - x24)
    x45 = x23 * boys(4, x15)
    x46 = c * x13
    x47 = x4 * x46
    x48 = (
        x27 * x29 + x44 - x47 * (2.0 * x16 * x18 * x2 * x21 * x25 * x26 * x27 - x4 * x45)
    )
    x49 = x4 * x48
    x50 = x29 * x31
    x51 = 2.0 * x50
    x52 = x14 * x7
    x53 = x37 * x39
    x54 = x53 * x7
    x55 = x14 * (x30 * x52 + x54)
    x56 = x38 * x41
    x57 = x0 * x56
    x58 = x10 * x14
    x59 = x10 * x53
    x60 = x14 * (x30 * x58 + x59)
    x61 = x1**2 / x12**2
    x62 = x61 * x8
    x63 = x29 * x62
    x64 = x61 * x7
    x65 = x10 * x64
    x66 = x29 * x65
    x67 = x10 * x7
    x68 = x11 * x61
    x69 = x29 * x68
    x70 = -x6 - A[1]
    x71 = 2.0 * x18 * x2 * x21 * x25 * x26 * x28 * x70 - x24 * x7
    x72 = x5 * x61
    x73 = x71 * x72
    x74 = x19 * x42
    x75 = x5 * x74 + x73
    x76 = x31 * x71
    x77 = 2.0 * x16 * x18 * x2 * x21 * x25 * x26 * x70 - x45 * x7
    x78 = x27 * x71 - x47 * x77
    x79 = x4 * x78
    x80 = x7 * x71
    x81 = x34 + x80
    x82 = x4 * x61
    x83 = x81 * x82
    x84 = x19 * x56
    x85 = x7 * x84 + x83
    x86 = x14 * x81
    x87 = x31 * x86
    x88 = x7 * x78
    x89 = x50 + x88
    x90 = x10 * x82
    x91 = x71 * x90
    x92 = x10 * x84 + x91
    x93 = x58 * x76
    x94 = x14 * (x54 + x7 * x86)
    x95 = x74 * x8 + x94
    x96 = x14 * (x58 * x80 + x59)
    x97 = x67 * x74 + x96
    x98 = x50 * x58
    x99 = x68 * x71
    x100 = x11 * x74 + x99
    x101 = -x9 - A[2]
    x102 = -x10 * x24 + 2.0 * x101 * x18 * x2 * x21 * x25 * x26 * x28
    x103 = x102 * x72
    x104 = x20 * x42
    x105 = x103 + x104 * x5
    x106 = x102 * x31
    x107 = -x10 * x45 + 2.0 * x101 * x16 * x18 * x2 * x21 * x25 * x26
    x108 = x102 * x27 - x107 * x47
    x109 = x108 * x4
    x110 = x7 * x82
    x111 = x102 * x110
    x112 = x20 * x56
    x113 = x111 + x112 * x7
    x114 = x106 * x52
    x115 = x10 * x102 + x34
    x116 = x115 * x82
    x117 = x10 * x112 + x116
    x118 = x115 * x14
    x119 = x118 * x31
    x120 = x10 * x108 + x50
    x121 = x102 * x62
    x122 = x104 * x8 + x121
    x123 = x115 * x64
    x124 = x104 * x67 + x123
    x125 = x14 * (x10 * x118 + x59)
    x126 = x104 * x11 + x125
    x127 = x46 * x7
    x128 = -x127 * x77 + x44 + x70 * x71
    x129 = x128 * x7
    x130 = 2.0 * x76
    x131 = x129 + x130
    x132 = x102 * x70 - x107 * x127
    x133 = x106 + x132 * x7
    x134 = x10 * x132 + x76
    x135 = -x10 * x107 * x46 + x101 * x102 + x44
    x136 = x10 * x135 + 2.0 * x106

    # 36 item(s)
    return numpy.array(
        [
            x0 * x40
            + x0 * (x40 + x43 * x5)
            + x14 * (x14 * x32 * x35 + x36 * (x49 + x51)),
            x0 * x55 + x0 * (x55 + x57 * x7) + x14 * (x49 * x52 + x51 * x52),
            x0 * x60 + x0 * (x10 * x57 + x60) + x14 * (x49 * x58 + x51 * x58),
            x0 * x63 + x0 * (x43 * x8 + x63) + x48 * x62,
            x0 * x66 + x0 * (x43 * x67 + x66) + x48 * x65,
            x0 * x69 + x0 * (x11 * x43 + x69) + x48 * x68,
            x0 * x75 + x14 * (x36 * x76 + x36 * (x76 + x79)) + x19 * x40,
            x0 * x85 + x14 * (x36 * x89 + x87) + x19 * x55,
            x0 * x92 + x14 * (x58 * x79 + x93) + x19 * x60,
            x0 * x95 + x14 * (x50 * x52 + x52 * x89) + x19 * x63,
            x0 * x97 + x14 * (x58 * x88 + x98) + x19 * x66,
            x0 * x100 + x19 * x69 + x68 * x78,
            x0 * x105 + x14 * (x106 * x36 + x36 * (x106 + x109)) + x20 * x40,
            x0 * x113 + x14 * (x109 * x52 + x114) + x20 * x55,
            x0 * x117 + x14 * (x119 + x120 * x36) + x20 * x60,
            x0 * x122 + x108 * x62 + x20 * x63,
            x0 * x124 + x120 * x64 + x20 * x66,
            x0 * x126 + x14 * (x120 * x58 + x98) + x20 * x69,
            x128 * x72 + x19 * x73 + x19 * x75,
            x131 * x82 + x19 * x83 + x19 * x85,
            x128 * x90 + x19 * x91 + x19 * x92,
            x14 * (x131 * x52 + 2.0 * x87) + x19 * x94 + x19 * x95,
            x14 * (x129 * x58 + x130 * x58) + x19 * x96 + x19 * x97,
            x100 * x19 + x128 * x68 + x19 * x99,
            x105 * x19 + x132 * x72 + x20 * x73,
            x113 * x19 + x133 * x82 + x20 * x83,
            x117 * x19 + x134 * x82 + x20 * x91,
            x122 * x19 + x14 * (x114 + x133 * x52) + x20 * x94,
            x124 * x19 + x14 * (x119 + x134 * x52) + x20 * x96,
            x126 * x19 + x14 * (x134 * x58 + x93) + x20 * x99,
            x103 * x20 + x105 * x20 + x135 * x72,
            x110 * x135 + x111 * x20 + x113 * x20,
            x116 * x20 + x117 * x20 + x136 * x82,
            x121 * x20 + x122 * x20 + x135 * x62,
            x123 * x20 + x124 * x20 + x136 * x64,
            x125 * x20 + x126 * x20 + x14 * (2.0 * x119 + x136 * x58),
        ]
    )


def _3center2el3d_sph_023(a, A, b, B, c, C):
    """Cartesian (sd|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x4**2
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x1
    x13 = x12 ** (-1.0)
    x14 = x1 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(4, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[1] - B[1]
    x20 = A[2] - B[2]
    x21 = numpy.exp(-a * b * x2 * (x0**2 + x19**2 + x20**2))
    x22 = 2.0 * x18 * x21
    x23 = x2 * x22
    x24 = x17 * x23
    x25 = x16 * x24
    x26 = c ** (-1.0)
    x27 = x12 ** (-0.5)
    x28 = -x3 - A[0]
    x29 = boys(3, x15)
    x30 = 2.0 * x18 * x2 * x21 * x26 * x27 * x28 * x29 - x25 * x4
    x31 = x30 * x4
    x32 = (2.0 * a + 2.0 * b) ** (-1.0)
    x33 = x26 * x29
    x34 = x23 * x27 * x32 * x33
    x35 = x31 + x34
    x36 = x14 * x4
    x37 = x22 * x33
    x38 = x32 * x37
    x39 = x17 * x38
    x40 = x35 * x36 + x39 * x4
    x41 = x1 * x12 ** (-2.5) * x38
    x42 = x14 * (x36 * x40 + x41 * x5)
    x43 = x4**3
    x44 = x1**2
    x45 = x12 ** (-3.5) * x37 * x44
    x46 = x0 * x45
    x47 = x32 * (2.0 * x18 * x2 * x21 * x26 * x27 * x29 - x25)
    x48 = x24 * boys(5, x15)
    x49 = c * x13
    x50 = x4 * x49
    x51 = (
        x28 * x30 + x47 - x50 * (2.0 * x16 * x18 * x2 * x21 * x26 * x27 * x28 - x4 * x48)
    )
    x52 = x4 * x51
    x53 = x30 * x32
    x54 = 2.0 * x53
    x55 = x14 * x32
    x56 = 2.0 * x55
    x57 = x14 * x7
    x58 = x39 * x7
    x59 = x31 * x57 + x58
    x60 = x4 * x7
    x61 = x14 * (x36 * x59 + x41 * x60)
    x62 = x46 * x5
    x63 = x10 * x14
    x64 = x10 * x39
    x65 = x31 * x63 + x64
    x66 = x10 * x41
    x67 = x14 * (x36 * x65 + x4 * x66)
    x68 = x44 / x12**2
    x69 = x68 * x8
    x70 = x41 * x8
    x71 = x14 * (x31 * x69 + x70)
    x72 = x4 * x46
    x73 = x68 * x7
    x74 = x10 * x73
    x75 = x66 * x7
    x76 = x14 * (x31 * x74 + x75)
    x77 = x10 * x60
    x78 = x11 * x68
    x79 = x11 * x41
    x80 = x14 * (x31 * x78 + x79)
    x81 = x7**3
    x82 = x1**3 / x12**3
    x83 = x81 * x82
    x84 = x30 * x83
    x85 = x8 * x82
    x86 = x10 * x85
    x87 = x30 * x86
    x88 = x10 * x8
    x89 = x11 * x82
    x90 = x7 * x89
    x91 = x30 * x90
    x92 = x11 * x7
    x93 = x10**3
    x94 = x82 * x93
    x95 = x30 * x94
    x96 = -x6 - A[1]
    x97 = 2.0 * x18 * x2 * x21 * x26 * x27 * x29 * x96 - x25 * x7
    x98 = x43 * x82
    x99 = x97 * x98
    x100 = x19 * x45
    x101 = x100 * x43 + x99
    x102 = x32 * x97
    x103 = 2.0 * x16 * x18 * x2 * x21 * x26 * x27 * x96 - x48 * x7
    x104 = -x103 * x50 + x28 * x97
    x105 = x104 * x4
    x106 = x5 * x68
    x107 = x7 * x97
    x108 = x107 + x34
    x109 = x5 * x82
    x110 = x108 * x109
    x111 = x100 * x5
    x112 = x110 + x111 * x7
    x113 = x108 * x14
    x114 = x113 * x32
    x115 = x104 * x7
    x116 = x115 + x53
    x117 = x4 * x68
    x118 = x117 * x32
    x119 = x10 * x109
    x120 = x119 * x97
    x121 = x10 * x111 + x120
    x122 = x102 * x63
    x123 = x113 * x7 + x58
    x124 = x117 * x123
    x125 = x100 * x4
    x126 = x124 + x125 * x8
    x127 = x123 * x55
    x128 = x116 * x57 + x53 * x57
    x129 = x107 * x63 + x64
    x130 = x117 * x129
    x131 = x100 * x77 + x130
    x132 = x129 * x55
    x133 = x53 * x63
    x134 = x115 * x63 + x133
    x135 = x4 * x89
    x136 = x135 * x97
    x137 = x11 * x125 + x136
    x138 = x102 * x78
    x139 = x14 * (x123 * x57 + x70)
    x140 = x100 * x81 + x139
    x141 = x14 * (x129 * x57 + x75)
    x142 = x100 * x88 + x141
    x143 = x14 * (x107 * x78 + x79)
    x144 = x100 * x92 + x143
    x145 = x53 * x78
    x146 = x94 * x97
    x147 = x100 * x93 + x146
    x148 = -x9 - A[2]
    x149 = -x10 * x25 + 2.0 * x148 * x18 * x2 * x21 * x26 * x27 * x29
    x150 = x149 * x98
    x151 = x20 * x45
    x152 = x150 + x151 * x43
    x153 = x149 * x32
    x154 = -x10 * x48 + 2.0 * x148 * x16 * x18 * x2 * x21 * x26 * x27
    x155 = x149 * x28 - x154 * x50
    x156 = x155 * x4
    x157 = x109 * x7
    x158 = x149 * x157
    x159 = x151 * x5
    x160 = x158 + x159 * x7
    x161 = x153 * x57
    x162 = x117 * x7
    x163 = x10 * x149 + x34
    x164 = x109 * x163
    x165 = x10 * x159 + x164
    x166 = x163 * x55
    x167 = x10 * x155 + x53
    x168 = x4 * x85
    x169 = x149 * x168
    x170 = x151 * x4
    x171 = x169 + x170 * x8
    x172 = x153 * x69
    x173 = x60 * x82
    x174 = x163 * x173
    x175 = x151 * x77 + x174
    x176 = x163 * x32 * x73
    x177 = x163 * x63 + x64
    x178 = x117 * x177
    x179 = x11 * x170 + x178
    x180 = x177 * x55
    x181 = x133 + x167 * x63
    x182 = x149 * x83
    x183 = x151 * x81 + x182
    x184 = x163 * x85
    x185 = x151 * x88 + x184
    x186 = x177 * x73
    x187 = x151 * x92 + x186
    x188 = x14 * (x177 * x63 + x79)
    x189 = x151 * x93 + x188
    x190 = x49 * x7
    x191 = -x103 * x190 + x47 + x96 * x97
    x192 = x191 * x7
    x193 = 2.0 * x102
    x194 = x192 + x193
    x195 = 2.0 * x114 + x194 * x57
    x196 = x192 * x63 + x193 * x63
    x197 = x149 * x96 - x154 * x190
    x198 = x153 + x197 * x7
    x199 = x10 * x197 + x102
    x200 = x161 + x198 * x57
    x201 = x166 + x199 * x57
    x202 = x122 + x199 * x63
    x203 = -x10 * x154 * x49 + x148 * x149 + x47
    x204 = x10 * x203 + 2.0 * x153
    x205 = 2.0 * x166 + x204 * x63

    # 60 item(s)
    return numpy.array(
        [
            x0 * x42
            + x0 * (x42 + x43 * x46)
            + x14 * (x36 * (x35 * x56 + x36 * (x52 + x54)) + x40 * x56),
            x0 * x61
            + x0 * (x61 + x62 * x7)
            + x14 * (x36 * (x52 * x57 + x54 * x57) + x56 * x59),
            x0 * x67
            + x0 * (x10 * x62 + x67)
            + x14 * (x36 * (x52 * x63 + x54 * x63) + x56 * x65),
            x0 * x71 + x0 * (x71 + x72 * x8) + x14 * (x52 * x69 + x54 * x69),
            x0 * x76 + x0 * (x46 * x77 + x76) + x14 * (x52 * x74 + x54 * x74),
            x0 * x80 + x0 * (x11 * x72 + x80) + x14 * (x52 * x78 + x54 * x78),
            x0 * x84 + x0 * (x46 * x81 + x84) + x51 * x83,
            x0 * x87 + x0 * (x46 * x88 + x87) + x51 * x86,
            x0 * x91 + x0 * (x46 * x92 + x91) + x51 * x90,
            x0 * x95 + x0 * (x46 * x93 + x95) + x51 * x94,
            x0 * x101
            + x14 * (x102 * x106 + x36 * (x102 * x36 + x36 * (x102 + x105)))
            + x19 * x42,
            x0 * x112 + x14 * (x108 * x118 + x36 * (x114 + x116 * x36)) + x19 * x61,
            x0 * x121 + x14 * (x10 * x102 * x117 + x36 * (x105 * x63 + x122)) + x19 * x67,
            x0 * x126 + x14 * (x127 + x128 * x36) + x19 * x71,
            x0 * x131 + x14 * (x132 + x134 * x36) + x19 * x76,
            x0 * x137 + x14 * (x105 * x78 + x138) + x19 * x80,
            x0 * x140 + x14 * (x128 * x57 + x53 * x69) + x19 * x84,
            x0 * x142 + x14 * (x134 * x57 + x53 * x74) + x19 * x87,
            x0 * x144 + x14 * (x115 * x78 + x145) + x19 * x91,
            x0 * x147 + x104 * x94 + x19 * x95,
            x0 * x152
            + x14 * (x106 * x153 + x36 * (x153 * x36 + x36 * (x153 + x156)))
            + x20 * x42,
            x0 * x160 + x14 * (x153 * x162 + x36 * (x156 * x57 + x161)) + x20 * x61,
            x0 * x165 + x14 * (x118 * x163 + x36 * (x166 + x167 * x36)) + x20 * x67,
            x0 * x171 + x14 * (x156 * x69 + x172) + x20 * x71,
            x0 * x175 + x14 * (x162 * x167 + x176) + x20 * x76,
            x0 * x179 + x14 * (x180 + x181 * x36) + x20 * x80,
            x0 * x183 + x155 * x83 + x20 * x84,
            x0 * x185 + x167 * x85 + x20 * x87,
            x0 * x187 + x181 * x73 + x20 * x91,
            x0 * x189 + x14 * (x145 + x181 * x63) + x20 * x95,
            x101 * x19 + x19 * x99 + x191 * x98,
            x109 * x194 + x110 * x19 + x112 * x19,
            x119 * x191 + x120 * x19 + x121 * x19,
            x117 * x195 + x124 * x19 + x126 * x19,
            x117 * x196 + x130 * x19 + x131 * x19,
            x135 * x191 + x136 * x19 + x137 * x19,
            x139 * x19 + x14 * (2.0 * x127 + x195 * x57) + x140 * x19,
            x14 * (2.0 * x132 + x196 * x57) + x141 * x19 + x142 * x19,
            x14 * (x192 * x78 + x193 * x78) + x143 * x19 + x144 * x19,
            x146 * x19 + x147 * x19 + x191 * x94,
            x152 * x19 + x197 * x98 + x20 * x99,
            x109 * x198 + x110 * x20 + x160 * x19,
            x109 * x199 + x120 * x20 + x165 * x19,
            x117 * x200 + x124 * x20 + x171 * x19,
            x117 * x201 + x130 * x20 + x175 * x19,
            x117 * x202 + x136 * x20 + x179 * x19,
            x139 * x20 + x14 * (x172 + x200 * x57) + x183 * x19,
            x14 * (x176 + x201 * x57) + x141 * x20 + x185 * x19,
            x14 * (x180 + x202 * x57) + x143 * x20 + x187 * x19,
            x14 * (x138 + x202 * x63) + x146 * x20 + x189 * x19,
            x150 * x20 + x152 * x20 + x203 * x98,
            x157 * x203 + x158 * x20 + x160 * x20,
            x109 * x204 + x164 * x20 + x165 * x20,
            x168 * x203 + x169 * x20 + x171 * x20,
            x173 * x204 + x174 * x20 + x175 * x20,
            x117 * x205 + x178 * x20 + x179 * x20,
            x182 * x20 + x183 * x20 + x203 * x83,
            x184 * x20 + x185 * x20 + x204 * x85,
            x186 * x20 + x187 * x20 + x205 * x73,
            x14 * (2.0 * x180 + x205 * x63) + x188 * x20 + x189 * x20,
        ]
    )


def _3center2el3d_sph_024(a, A, b, B, c, C):
    """Cartesian (sd|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x4**2
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x1
    x13 = x12 ** (-1.0)
    x14 = x1 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(5, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[1] - B[1]
    x20 = A[2] - B[2]
    x21 = numpy.exp(-a * b * x2 * (x0**2 + x19**2 + x20**2))
    x22 = 2.0 * x18 * x21
    x23 = x2 * x22
    x24 = x17 * x23
    x25 = x16 * x24
    x26 = c ** (-1.0)
    x27 = x12 ** (-0.5)
    x28 = -x3 - A[0]
    x29 = boys(4, x15)
    x30 = 2.0 * x18 * x2 * x21 * x26 * x27 * x28 * x29 - x25 * x4
    x31 = x30 * x4
    x32 = (2.0 * a + 2.0 * b) ** (-1.0)
    x33 = x26 * x29
    x34 = x23 * x27 * x32 * x33
    x35 = x31 + x34
    x36 = x14 * x4
    x37 = x22 * x33
    x38 = x32 * x37
    x39 = x17 * x38
    x40 = x35 * x36 + x39 * x4
    x41 = x38 * x5
    x42 = x1 * x12 ** (-2.5)
    x43 = x36 * x40 + x41 * x42
    x44 = x4**3
    x45 = x1**2
    x46 = x12 ** (-3.5) * x45
    x47 = x38 * x46
    x48 = x14 * (x36 * x43 + x44 * x47)
    x49 = x4**4
    x50 = x1**3
    x51 = x12 ** (-4.5) * x37 * x50
    x52 = x0 * x51
    x53 = x32 * (2.0 * x18 * x2 * x21 * x26 * x27 * x29 - x25)
    x54 = x24 * boys(6, x15)
    x55 = c * x13
    x56 = x4 * x55
    x57 = (
        x28 * x30 + x53 - x56 * (2.0 * x16 * x18 * x2 * x21 * x26 * x27 * x28 - x4 * x54)
    )
    x58 = x4 * x57
    x59 = x30 * x32
    x60 = 2.0 * x59
    x61 = x14 * x32
    x62 = 2.0 * x61
    x63 = x14 * x7
    x64 = x39 * x7
    x65 = x31 * x63 + x64
    x66 = x38 * x42
    x67 = x4 * x66
    x68 = x36 * x65 + x67 * x7
    x69 = x41 * x46
    x70 = x14 * (x36 * x68 + x69 * x7)
    x71 = x44 * x52
    x72 = x10 * x14
    x73 = x10 * x39
    x74 = x31 * x72 + x73
    x75 = x10 * x67 + x36 * x74
    x76 = x14 * (x10 * x69 + x36 * x75)
    x77 = x45 / x12**2
    x78 = x77 * x8
    x79 = x66 * x8
    x80 = x31 * x78 + x79
    x81 = x4 * x8
    x82 = x14 * (x36 * x80 + x47 * x81)
    x83 = x5 * x8
    x84 = x7 * x77
    x85 = x10 * x84
    x86 = x10 * x7
    x87 = x66 * x86
    x88 = x31 * x85 + x87
    x89 = x14 * (x36 * x88 + x4 * x47 * x86)
    x90 = x5 * x86
    x91 = x11 * x77
    x92 = x11 * x66
    x93 = x31 * x91 + x92
    x94 = x11 * x4
    x95 = x14 * (x36 * x93 + x47 * x94)
    x96 = x11 * x5
    x97 = x7**3
    x98 = x50 / x12**3
    x99 = x97 * x98
    x100 = x47 * x97
    x101 = x14 * (x100 + x31 * x99)
    x102 = x52 * x97
    x103 = x8 * x98
    x104 = x10 * x103
    x105 = x10 * x47 * x8
    x106 = x14 * (x104 * x31 + x105)
    x107 = x10 * x81
    x108 = x7 * x98
    x109 = x108 * x11
    x110 = x11 * x47 * x7
    x111 = x14 * (x109 * x31 + x110)
    x112 = x7 * x94
    x113 = x10**3
    x114 = x113 * x98
    x115 = x113 * x47
    x116 = x14 * (x114 * x31 + x115)
    x117 = x113 * x4
    x118 = x7**4
    x119 = x1**4 / x12**4
    x120 = x118 * x119
    x121 = x120 * x30
    x122 = x119 * x97
    x123 = x10 * x122
    x124 = x123 * x30
    x125 = x119 * x30
    x126 = x11 * x8
    x127 = x125 * x126
    x128 = x119 * x57
    x129 = x113 * x7
    x130 = x125 * x129
    x131 = x10**4
    x132 = x119 * x131
    x133 = x132 * x30
    x134 = -x6 - A[1]
    x135 = 2.0 * x134 * x18 * x2 * x21 * x26 * x27 * x29 - x25 * x7
    x136 = x119 * x49
    x137 = x135 * x136
    x138 = x19 * x51
    x139 = x137 + x138 * x49
    x140 = x135 * x32
    x141 = 2.0 * x134 * x16 * x18 * x2 * x21 * x26 * x27 - x54 * x7
    x142 = x135 * x28 - x141 * x56
    x143 = x142 * x4
    x144 = x5 * x77
    x145 = x44 * x98
    x146 = x135 * x7
    x147 = x146 + x34
    x148 = x119 * x44
    x149 = x147 * x148
    x150 = x138 * x44
    x151 = x149 + x150 * x7
    x152 = x14 * x147
    x153 = x152 * x32
    x154 = x142 * x7
    x155 = x154 + x59
    x156 = x4 * x77
    x157 = x147 * x32
    x158 = x5 * x98
    x159 = x10 * x148
    x160 = x135 * x159
    x161 = x10 * x150 + x160
    x162 = x140 * x72
    x163 = x10 * x140
    x164 = x152 * x7 + x64
    x165 = x158 * x164
    x166 = x138 * x83 + x165
    x167 = x164 * x61
    x168 = x155 * x63 + x59 * x63
    x169 = x156 * x32
    x170 = x146 * x72 + x73
    x171 = x158 * x170
    x172 = x138 * x90 + x171
    x173 = x170 * x61
    x174 = x59 * x72
    x175 = x154 * x72 + x174
    x176 = x119 * x135
    x177 = x176 * x96
    x178 = x138 * x96 + x177
    x179 = x140 * x91
    x180 = x164 * x63 + x79
    x181 = x156 * x180
    x182 = x138 * x97
    x183 = x181 + x182 * x4
    x184 = x180 * x61
    x185 = x168 * x63 + x59 * x78
    x186 = x170 * x63 + x87
    x187 = x156 * x186
    x188 = x107 * x138 + x187
    x189 = x186 * x61
    x190 = x175 * x63 + x59 * x85
    x191 = x146 * x91 + x92
    x192 = x156 * x191
    x193 = x112 * x138 + x192
    x194 = x191 * x61
    x195 = x59 * x91
    x196 = x154 * x91 + x195
    x197 = x117 * x176
    x198 = x117 * x138 + x197
    x199 = x114 * x140
    x200 = x14 * (x100 + x180 * x63)
    x201 = x118 * x138 + x200
    x202 = x14 * (x105 + x186 * x63)
    x203 = x10 * x182 + x202
    x204 = x14 * (x110 + x191 * x63)
    x205 = x126 * x138 + x204
    x206 = x14 * (x114 * x146 + x115)
    x207 = x129 * x138 + x206
    x208 = x114 * x59
    x209 = x132 * x135
    x210 = x131 * x138 + x209
    x211 = -x9 - A[2]
    x212 = -x10 * x25 + 2.0 * x18 * x2 * x21 * x211 * x26 * x27 * x29
    x213 = x136 * x212
    x214 = x20 * x51
    x215 = x213 + x214 * x49
    x216 = x212 * x32
    x217 = -x10 * x54 + 2.0 * x16 * x18 * x2 * x21 * x211 * x26 * x27
    x218 = x212 * x28 - x217 * x56
    x219 = x218 * x4
    x220 = x148 * x7
    x221 = x212 * x220
    x222 = x214 * x44
    x223 = x221 + x222 * x7
    x224 = x216 * x63
    x225 = x156 * x7
    x226 = x10 * x212 + x34
    x227 = x148 * x226
    x228 = x10 * x222 + x227
    x229 = x226 * x61
    x230 = x10 * x218 + x59
    x231 = x226 * x32
    x232 = x119 * x5
    x233 = x232 * x8
    x234 = x212 * x233
    x235 = x214 * x83 + x234
    x236 = x216 * x78
    x237 = x103 * x4
    x238 = x232 * x7
    x239 = x226 * x238
    x240 = x214 * x90 + x239
    x241 = x231 * x84
    x242 = x108 * x4
    x243 = x226 * x72 + x73
    x244 = x158 * x243
    x245 = x214 * x96 + x244
    x246 = x243 * x61
    x247 = x174 + x230 * x72
    x248 = x122 * x4
    x249 = x212 * x248
    x250 = x214 * x97
    x251 = x249 + x250 * x4
    x252 = x216 * x99
    x253 = x119 * x81
    x254 = x226 * x253
    x255 = x107 * x214 + x254
    x256 = x103 * x231
    x257 = x242 * x243
    x258 = x112 * x214 + x257
    x259 = x243 * x32 * x84
    x260 = x243 * x72 + x92
    x261 = x156 * x260
    x262 = x117 * x214 + x261
    x263 = x260 * x61
    x264 = x195 + x247 * x72
    x265 = x120 * x212
    x266 = x118 * x214 + x265
    x267 = x122 * x226
    x268 = x10 * x250 + x267
    x269 = x103 * x243
    x270 = x126 * x214 + x269
    x271 = x260 * x84
    x272 = x129 * x214 + x271
    x273 = x14 * (x115 + x260 * x72)
    x274 = x131 * x214 + x273
    x275 = x55 * x7
    x276 = x134 * x135 - x141 * x275 + x53
    x277 = x276 * x7
    x278 = 2.0 * x140
    x279 = x277 + x278
    x280 = 2.0 * x153 + x279 * x63
    x281 = x277 * x72 + x278 * x72
    x282 = x119 * x276
    x283 = 2.0 * x167 + x280 * x63
    x284 = 2.0 * x173 + x281 * x63
    x285 = x277 * x91 + x278 * x91
    x286 = x134 * x212 - x217 * x275
    x287 = x216 + x286 * x7
    x288 = x10 * x286 + x140
    x289 = x224 + x287 * x63
    x290 = x229 + x288 * x63
    x291 = x162 + x288 * x72
    x292 = x236 + x289 * x63
    x293 = x241 + x290 * x63
    x294 = x246 + x291 * x63
    x295 = x179 + x291 * x72
    x296 = -x10 * x217 * x55 + x211 * x212 + x53
    x297 = x10 * x296 + 2.0 * x216
    x298 = 2.0 * x229 + x297 * x72
    x299 = 2.0 * x246 + x298 * x72

    # 90 item(s)
    return numpy.array(
        [
            x0 * x48
            + x0 * (x48 + x49 * x52)
            + x14
            * (x36 * (x36 * (x35 * x62 + x36 * (x58 + x60)) + x40 * x62) + x43 * x62),
            x0 * x70
            + x0 * (x7 * x71 + x70)
            + x14 * (x36 * (x36 * (x58 * x63 + x60 * x63) + x62 * x65) + x62 * x68),
            x0 * x76
            + x0 * (x10 * x71 + x76)
            + x14 * (x36 * (x36 * (x58 * x72 + x60 * x72) + x62 * x74) + x62 * x75),
            x0 * x82
            + x0 * (x52 * x83 + x82)
            + x14 * (x36 * (x58 * x78 + x60 * x78) + x62 * x80),
            x0 * x89
            + x0 * (x52 * x90 + x89)
            + x14 * (x36 * (x58 * x85 + x60 * x85) + x62 * x88),
            x0 * x95
            + x0 * (x52 * x96 + x95)
            + x14 * (x36 * (x58 * x91 + x60 * x91) + x62 * x93),
            x0 * x101 + x0 * (x101 + x102 * x4) + x14 * (x58 * x99 + x60 * x99),
            x0 * x106 + x0 * (x106 + x107 * x52) + x14 * (x104 * x58 + x104 * x60),
            x0 * x111 + x0 * (x111 + x112 * x52) + x14 * (x109 * x58 + x109 * x60),
            x0 * x116 + x0 * (x116 + x117 * x52) + x14 * (x114 * x58 + x114 * x60),
            x0 * x121 + x0 * (x118 * x52 + x121) + x120 * x57,
            x0 * x124 + x0 * (x10 * x102 + x124) + x123 * x57,
            x0 * x127 + x0 * (x126 * x52 + x127) + x126 * x128,
            x0 * x130 + x0 * (x129 * x52 + x130) + x128 * x129,
            x0 * x133 + x0 * (x131 * x52 + x133) + x132 * x57,
            x0 * x139
            + x14
            * (
                x140 * x145
                + x36 * (x140 * x144 + x36 * (x140 * x36 + x36 * (x140 + x143)))
            )
            + x19 * x48,
            x0 * x151
            + x14 * (x157 * x158 + x36 * (x156 * x157 + x36 * (x153 + x155 * x36)))
            + x19 * x70,
            x0 * x161
            + x14 * (x158 * x163 + x36 * (x156 * x163 + x36 * (x143 * x72 + x162)))
            + x19 * x76,
            x0 * x166 + x14 * (x164 * x169 + x36 * (x167 + x168 * x36)) + x19 * x82,
            x0 * x172 + x14 * (x169 * x170 + x36 * (x173 + x175 * x36)) + x19 * x89,
            x0 * x178 + x14 * (x140 * x94 * x98 + x36 * (x143 * x91 + x179)) + x19 * x95,
            x0 * x183 + x101 * x19 + x14 * (x184 + x185 * x36),
            x0 * x188 + x106 * x19 + x14 * (x189 + x190 * x36),
            x0 * x193 + x111 * x19 + x14 * (x194 + x196 * x36),
            x0 * x198 + x116 * x19 + x14 * (x114 * x143 + x199),
            x0 * x201 + x121 * x19 + x14 * (x185 * x63 + x59 * x99),
            x0 * x203 + x124 * x19 + x14 * (x104 * x59 + x190 * x63),
            x0 * x205 + x127 * x19 + x14 * (x109 * x59 + x196 * x63),
            x0 * x207 + x130 * x19 + x14 * (x114 * x154 + x208),
            x0 * x210 + x132 * x142 + x133 * x19,
            x0 * x215
            + x14
            * (
                x145 * x216
                + x36 * (x144 * x216 + x36 * (x216 * x36 + x36 * (x216 + x219)))
            )
            + x20 * x48,
            x0 * x223
            + x14 * (x158 * x216 * x7 + x36 * (x216 * x225 + x36 * (x219 * x63 + x224)))
            + x20 * x70,
            x0 * x228
            + x14 * (x158 * x231 + x36 * (x169 * x226 + x36 * (x229 + x230 * x36)))
            + x20 * x76,
            x0 * x235 + x14 * (x216 * x237 + x36 * (x219 * x78 + x236)) + x20 * x82,
            x0 * x240 + x14 * (x231 * x242 + x36 * (x225 * x230 + x241)) + x20 * x89,
            x0 * x245 + x14 * (x169 * x243 + x36 * (x246 + x247 * x36)) + x20 * x95,
            x0 * x251 + x101 * x20 + x14 * (x219 * x99 + x252),
            x0 * x255 + x106 * x20 + x14 * (x230 * x237 + x256),
            x0 * x258 + x111 * x20 + x14 * (x225 * x247 + x259),
            x0 * x262 + x116 * x20 + x14 * (x263 + x264 * x36),
            x0 * x266 + x120 * x218 + x121 * x20,
            x0 * x268 + x122 * x230 + x124 * x20,
            x0 * x270 + x103 * x247 + x127 * x20,
            x0 * x272 + x130 * x20 + x264 * x84,
            x0 * x274 + x133 * x20 + x14 * (x208 + x264 * x72),
            x136 * x276 + x137 * x19 + x139 * x19,
            x148 * x279 + x149 * x19 + x151 * x19,
            x159 * x276 + x160 * x19 + x161 * x19,
            x158 * x280 + x165 * x19 + x166 * x19,
            x158 * x281 + x171 * x19 + x172 * x19,
            x177 * x19 + x178 * x19 + x282 * x96,
            x156 * x283 + x181 * x19 + x183 * x19,
            x156 * x284 + x187 * x19 + x188 * x19,
            x156 * x285 + x19 * x192 + x19 * x193,
            x117 * x282 + x19 * x197 + x19 * x198,
            x14 * (2.0 * x184 + x283 * x63) + x19 * x200 + x19 * x201,
            x14 * (2.0 * x189 + x284 * x63) + x19 * x202 + x19 * x203,
            x14 * (2.0 * x194 + x285 * x63) + x19 * x204 + x19 * x205,
            x14 * (x114 * x277 + x114 * x278) + x19 * x206 + x19 * x207,
            x132 * x276 + x19 * x209 + x19 * x210,
            x136 * x286 + x137 * x20 + x19 * x215,
            x148 * x287 + x149 * x20 + x19 * x223,
            x148 * x288 + x160 * x20 + x19 * x228,
            x158 * x289 + x165 * x20 + x19 * x235,
            x158 * x290 + x171 * x20 + x19 * x240,
            x158 * x291 + x177 * x20 + x19 * x245,
            x156 * x292 + x181 * x20 + x19 * x251,
            x156 * x293 + x187 * x20 + x19 * x255,
            x156 * x294 + x19 * x258 + x192 * x20,
            x156 * x295 + x19 * x262 + x197 * x20,
            x14 * (x252 + x292 * x63) + x19 * x266 + x20 * x200,
            x14 * (x256 + x293 * x63) + x19 * x268 + x20 * x202,
            x14 * (x259 + x294 * x63) + x19 * x270 + x20 * x204,
            x14 * (x263 + x295 * x63) + x19 * x272 + x20 * x206,
            x14 * (x199 + x295 * x72) + x19 * x274 + x20 * x209,
            x136 * x296 + x20 * x213 + x20 * x215,
            x20 * x221 + x20 * x223 + x220 * x296,
            x148 * x297 + x20 * x227 + x20 * x228,
            x20 * x234 + x20 * x235 + x233 * x296,
            x20 * x239 + x20 * x240 + x238 * x297,
            x158 * x298 + x20 * x244 + x20 * x245,
            x20 * x249 + x20 * x251 + x248 * x296,
            x20 * x254 + x20 * x255 + x253 * x297,
            x20 * x257 + x20 * x258 + x242 * x298,
            x156 * x299 + x20 * x261 + x20 * x262,
            x120 * x296 + x20 * x265 + x20 * x266,
            x122 * x297 + x20 * x267 + x20 * x268,
            x103 * x298 + x20 * x269 + x20 * x270,
            x20 * x271 + x20 * x272 + x299 * x84,
            x14 * (2.0 * x263 + x299 * x72) + x20 * x273 + x20 * x274,
        ]
    )


def _3center2el3d_sph_025(a, A, b, B, c, C):
    """Cartesian (sd|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = x4**2
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x1
    x13 = x12 ** (-1.0)
    x14 = x1 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(6, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[1] - B[1]
    x20 = A[2] - B[2]
    x21 = numpy.exp(-a * b * x2 * (x0**2 + x19**2 + x20**2))
    x22 = 2.0 * x18 * x21
    x23 = x2 * x22
    x24 = x17 * x23
    x25 = x16 * x24
    x26 = c ** (-1.0)
    x27 = x12 ** (-0.5)
    x28 = -x3 - A[0]
    x29 = boys(5, x15)
    x30 = 2.0 * x18 * x2 * x21 * x26 * x27 * x28 * x29 - x25 * x4
    x31 = x30 * x4
    x32 = (2.0 * a + 2.0 * b) ** (-1.0)
    x33 = x26 * x29
    x34 = x23 * x27 * x32 * x33
    x35 = x31 + x34
    x36 = x14 * x4
    x37 = x22 * x33
    x38 = x32 * x37
    x39 = x17 * x38
    x40 = x35 * x36 + x39 * x4
    x41 = x38 * x5
    x42 = x1 * x12 ** (-2.5)
    x43 = x36 * x40 + x41 * x42
    x44 = x4**3
    x45 = x38 * x44
    x46 = x1**2
    x47 = x12 ** (-3.5) * x46
    x48 = x36 * x43 + x45 * x47
    x49 = x4**4
    x50 = x1**3
    x51 = x12 ** (-4.5) * x50
    x52 = x38 * x51
    x53 = x14 * (x36 * x48 + x49 * x52)
    x54 = x4**5
    x55 = x1**4
    x56 = x12 ** (-5.5) * x37 * x55
    x57 = x0 * x56
    x58 = x32 * (2.0 * x18 * x2 * x21 * x26 * x27 * x29 - x25)
    x59 = x24 * boys(7, x15)
    x60 = c * x13
    x61 = x4 * x60
    x62 = (
        x28 * x30 + x58 - x61 * (2.0 * x16 * x18 * x2 * x21 * x26 * x27 * x28 - x4 * x59)
    )
    x63 = x4 * x62
    x64 = x30 * x32
    x65 = 2.0 * x64
    x66 = x14 * x32
    x67 = 2.0 * x66
    x68 = x14 * x7
    x69 = x39 * x7
    x70 = x31 * x68 + x69
    x71 = x38 * x42
    x72 = x4 * x71
    x73 = x36 * x70 + x7 * x72
    x74 = x5 * x7
    x75 = x38 * x47
    x76 = x36 * x73 + x74 * x75
    x77 = x45 * x51
    x78 = x14 * (x36 * x76 + x7 * x77)
    x79 = x49 * x57
    x80 = x10 * x14
    x81 = x10 * x39
    x82 = x31 * x80 + x81
    x83 = x10 * x72 + x36 * x82
    x84 = x10 * x41 * x47 + x36 * x83
    x85 = x14 * (x10 * x77 + x36 * x84)
    x86 = x46 / x12**2
    x87 = x8 * x86
    x88 = x71 * x8
    x89 = x31 * x87 + x88
    x90 = x4 * x8
    x91 = x36 * x89 + x75 * x90
    x92 = x41 * x51
    x93 = x14 * (x36 * x91 + x8 * x92)
    x94 = x44 * x8
    x95 = x7 * x86
    x96 = x10 * x95
    x97 = x10 * x7
    x98 = x71 * x97
    x99 = x31 * x96 + x98
    x100 = x36 * x99 + x4 * x75 * x97
    x101 = x10 * x52
    x102 = x14 * (x100 * x36 + x101 * x74)
    x103 = x44 * x97
    x104 = x11 * x86
    x105 = x11 * x71
    x106 = x104 * x31 + x105
    x107 = x11 * x75
    x108 = x106 * x36 + x107 * x4
    x109 = x14 * (x108 * x36 + x11 * x92)
    x110 = x11 * x44
    x111 = x7**3
    x112 = x50 / x12**3
    x113 = x111 * x112
    x114 = x111 * x75
    x115 = x113 * x31 + x114
    x116 = x111 * x4
    x117 = x14 * (x115 * x36 + x116 * x52)
    x118 = x111 * x5
    x119 = x112 * x8
    x120 = x10 * x119
    x121 = x10 * x8
    x122 = x121 * x75
    x123 = x120 * x31 + x122
    x124 = x14 * (x101 * x90 + x123 * x36)
    x125 = x121 * x5
    x126 = x112 * x7
    x127 = x11 * x126
    x128 = x107 * x7
    x129 = x127 * x31 + x128
    x130 = x14 * (x11 * x4 * x52 * x7 + x129 * x36)
    x131 = x11 * x57
    x132 = x10**3
    x133 = x112 * x132
    x134 = x132 * x75
    x135 = x133 * x31 + x134
    x136 = x132 * x4
    x137 = x14 * (x135 * x36 + x136 * x52)
    x138 = x132 * x5
    x139 = x7**4
    x140 = x55 / x12**4
    x141 = x139 * x140
    x142 = x139 * x52
    x143 = x14 * (x141 * x31 + x142)
    x144 = x139 * x57
    x145 = x111 * x140
    x146 = x10 * x145
    x147 = x101 * x111
    x148 = x14 * (x146 * x31 + x147)
    x149 = x10 * x116
    x150 = x140 * x31
    x151 = x11 * x8
    x152 = x151 * x52
    x153 = x14 * (x150 * x151 + x152)
    x154 = x140 * x63
    x155 = x140 * x65
    x156 = x132 * x7
    x157 = x156 * x52
    x158 = x14 * (x150 * x156 + x157)
    x159 = x156 * x4
    x160 = x10**4
    x161 = x140 * x160
    x162 = x160 * x52
    x163 = x14 * (x161 * x31 + x162)
    x164 = x160 * x4
    x165 = x7**5
    x166 = x1**5 / x12**5
    x167 = x165 * x166
    x168 = x167 * x30
    x169 = x139 * x166
    x170 = x10 * x169
    x171 = x170 * x30
    x172 = x166 * x30
    x173 = x11 * x111
    x174 = x172 * x173
    x175 = x166 * x62
    x176 = x132 * x8
    x177 = x172 * x176
    x178 = x160 * x7
    x179 = x172 * x178
    x180 = x10**5
    x181 = x166 * x180
    x182 = x181 * x30
    x183 = -x6 - A[1]
    x184 = 2.0 * x18 * x183 * x2 * x21 * x26 * x27 * x29 - x25 * x7
    x185 = x166 * x54
    x186 = x184 * x185
    x187 = x19 * x56
    x188 = x186 + x187 * x54
    x189 = x184 * x32
    x190 = 2.0 * x16 * x18 * x183 * x2 * x21 * x26 * x27 - x59 * x7
    x191 = x184 * x28 - x190 * x61
    x192 = x191 * x4
    x193 = x5 * x86
    x194 = x112 * x44
    x195 = x140 * x49
    x196 = x184 * x7
    x197 = x196 + x34
    x198 = x166 * x49
    x199 = x197 * x198
    x200 = x187 * x49
    x201 = x199 + x200 * x7
    x202 = x14 * x197
    x203 = x202 * x32
    x204 = x191 * x7
    x205 = x204 + x64
    x206 = x4 * x86
    x207 = x197 * x32
    x208 = x112 * x5
    x209 = x140 * x44
    x210 = x10 * x198
    x211 = x184 * x210
    x212 = x10 * x200 + x211
    x213 = x189 * x80
    x214 = x10 * x189
    x215 = x202 * x7 + x69
    x216 = x209 * x215
    x217 = x187 * x94 + x216
    x218 = x215 * x66
    x219 = x205 * x68 + x64 * x68
    x220 = x215 * x32
    x221 = x196 * x80 + x81
    x222 = x209 * x221
    x223 = x103 * x187 + x222
    x224 = x221 * x66
    x225 = x64 * x80
    x226 = x204 * x80 + x225
    x227 = x221 * x32
    x228 = x166 * x184
    x229 = x110 * x228
    x230 = x110 * x187 + x229
    x231 = x104 * x189
    x232 = x11 * x189
    x233 = x140 * x5
    x234 = x215 * x68 + x88
    x235 = x208 * x234
    x236 = x118 * x187 + x235
    x237 = x234 * x66
    x238 = x219 * x68 + x64 * x87
    x239 = x206 * x32
    x240 = x221 * x68 + x98
    x241 = x208 * x240
    x242 = x125 * x187 + x241
    x243 = x240 * x66
    x244 = x226 * x68 + x64 * x96
    x245 = x104 * x196 + x105
    x246 = x208 * x245
    x247 = x11 * x187
    x248 = x246 + x247 * x74
    x249 = x245 * x66
    x250 = x104 * x64
    x251 = x104 * x204 + x250
    x252 = x138 * x228
    x253 = x138 * x187 + x252
    x254 = x133 * x189
    x255 = x114 + x234 * x68
    x256 = x206 * x255
    x257 = x139 * x187
    x258 = x256 + x257 * x4
    x259 = x255 * x66
    x260 = x113 * x64 + x238 * x68
    x261 = x122 + x240 * x68
    x262 = x206 * x261
    x263 = x149 * x187 + x262
    x264 = x261 * x66
    x265 = x120 * x64 + x244 * x68
    x266 = x128 + x245 * x68
    x267 = x206 * x266
    x268 = x247 * x90 + x267
    x269 = x266 * x66
    x270 = x127 * x64 + x251 * x68
    x271 = x133 * x196 + x134
    x272 = x206 * x271
    x273 = x159 * x187 + x272
    x274 = x271 * x66
    x275 = x133 * x64
    x276 = x133 * x204 + x275
    x277 = x164 * x228
    x278 = x164 * x187 + x277
    x279 = x161 * x189
    x280 = x14 * (x142 + x255 * x68)
    x281 = x165 * x187 + x280
    x282 = x14 * (x147 + x261 * x68)
    x283 = x10 * x257 + x282
    x284 = x14 * (x152 + x266 * x68)
    x285 = x173 * x187 + x284
    x286 = x140 * x64
    x287 = x14 * (x157 + x271 * x68)
    x288 = x176 * x187 + x287
    x289 = x14 * (x161 * x196 + x162)
    x290 = x178 * x187 + x289
    x291 = x161 * x64
    x292 = x181 * x184
    x293 = x180 * x187 + x292
    x294 = -x9 - A[2]
    x295 = -x10 * x25 + 2.0 * x18 * x2 * x21 * x26 * x27 * x29 * x294
    x296 = x185 * x295
    x297 = x20 * x56
    x298 = x296 + x297 * x54
    x299 = x295 * x32
    x300 = -x10 * x59 + 2.0 * x16 * x18 * x2 * x21 * x26 * x27 * x294
    x301 = x28 * x295 - x300 * x61
    x302 = x301 * x4
    x303 = x198 * x7
    x304 = x295 * x303
    x305 = x297 * x49
    x306 = x304 + x305 * x7
    x307 = x299 * x68
    x308 = x206 * x7
    x309 = x299 * x7
    x310 = x10 * x295 + x34
    x311 = x198 * x310
    x312 = x10 * x305 + x311
    x313 = x310 * x66
    x314 = x10 * x301 + x64
    x315 = x310 * x32
    x316 = x166 * x44
    x317 = x316 * x8
    x318 = x295 * x317
    x319 = x297 * x94 + x318
    x320 = x299 * x87
    x321 = x119 * x4
    x322 = x316 * x7
    x323 = x310 * x322
    x324 = x103 * x297 + x323
    x325 = x315 * x95
    x326 = x126 * x4
    x327 = x140 * x315
    x328 = x310 * x80 + x81
    x329 = x209 * x328
    x330 = x110 * x297 + x329
    x331 = x328 * x66
    x332 = x225 + x314 * x80
    x333 = x32 * x328
    x334 = x166 * x5
    x335 = x111 * x334
    x336 = x295 * x335
    x337 = x118 * x297 + x336
    x338 = x113 * x299
    x339 = x334 * x8
    x340 = x310 * x339
    x341 = x125 * x297 + x340
    x342 = x119 * x315
    x343 = x314 * x4
    x344 = x140 * x328
    x345 = x344 * x74
    x346 = x11 * x297
    x347 = x345 + x346 * x74
    x348 = x333 * x95
    x349 = x105 + x328 * x80
    x350 = x208 * x349
    x351 = x138 * x297 + x350
    x352 = x349 * x66
    x353 = x250 + x332 * x80
    x354 = x169 * x4
    x355 = x295 * x354
    x356 = x139 * x297
    x357 = x355 + x356 * x4
    x358 = x141 * x299
    x359 = x116 * x166
    x360 = x310 * x359
    x361 = x149 * x297 + x360
    x362 = x145 * x315
    x363 = x344 * x90
    x364 = x346 * x90 + x363
    x365 = x119 * x333
    x366 = x326 * x349
    x367 = x159 * x297 + x366
    x368 = x32 * x349 * x95
    x369 = x134 + x349 * x80
    x370 = x206 * x369
    x371 = x164 * x297 + x370
    x372 = x369 * x66
    x373 = x275 + x353 * x80
    x374 = x167 * x295
    x375 = x165 * x297 + x374
    x376 = x169 * x310
    x377 = x10 * x356 + x376
    x378 = x145 * x328
    x379 = x173 * x297 + x378
    x380 = x119 * x349
    x381 = x176 * x297 + x380
    x382 = x369 * x95
    x383 = x178 * x297 + x382
    x384 = x14 * (x162 + x369 * x80)
    x385 = x180 * x297 + x384
    x386 = x60 * x7
    x387 = x183 * x184 - x190 * x386 + x58
    x388 = x387 * x7
    x389 = 2.0 * x189
    x390 = x388 + x389
    x391 = 2.0 * x203 + x390 * x68
    x392 = x388 * x80 + x389 * x80
    x393 = x166 * x387
    x394 = 2.0 * x218 + x391 * x68
    x395 = 2.0 * x224 + x392 * x68
    x396 = x104 * x388 + x104 * x389
    x397 = 2.0 * x237 + x394 * x68
    x398 = 2.0 * x243 + x395 * x68
    x399 = 2.0 * x249 + x396 * x68
    x400 = x133 * x388 + x133 * x389
    x401 = x183 * x295 - x300 * x386
    x402 = x299 + x401 * x7
    x403 = x10 * x401 + x189
    x404 = x307 + x402 * x68
    x405 = x313 + x403 * x68
    x406 = x213 + x403 * x80
    x407 = x320 + x404 * x68
    x408 = x325 + x405 * x68
    x409 = x331 + x406 * x68
    x410 = x231 + x406 * x80
    x411 = x338 + x407 * x68
    x412 = x342 + x408 * x68
    x413 = x348 + x409 * x68
    x414 = x352 + x410 * x68
    x415 = x254 + x410 * x80
    x416 = -x10 * x300 * x60 + x294 * x295 + x58
    x417 = x10 * x416 + 2.0 * x299
    x418 = 2.0 * x313 + x417 * x80
    x419 = x140 * x418
    x420 = 2.0 * x331 + x418 * x80
    x421 = 2.0 * x352 + x420 * x80

    # 126 item(s)
    return numpy.array(
        [
            x0 * x53
            + x0 * (x53 + x54 * x57)
            + x14
            * (
                x36
                * (x36 * (x36 * (x35 * x67 + x36 * (x63 + x65)) + x40 * x67) + x43 * x67)
                + x48 * x67
            ),
            x0 * x78
            + x0 * (x7 * x79 + x78)
            + x14
            * (
                x36 * (x36 * (x36 * (x63 * x68 + x65 * x68) + x67 * x70) + x67 * x73)
                + x67 * x76
            ),
            x0 * x85
            + x0 * (x10 * x79 + x85)
            + x14
            * (
                x36 * (x36 * (x36 * (x63 * x80 + x65 * x80) + x67 * x82) + x67 * x83)
                + x67 * x84
            ),
            x0 * x93
            + x0 * (x57 * x94 + x93)
            + x14 * (x36 * (x36 * (x63 * x87 + x65 * x87) + x67 * x89) + x67 * x91),
            x0 * x102
            + x0 * (x102 + x103 * x57)
            + x14 * (x100 * x67 + x36 * (x36 * (x63 * x96 + x65 * x96) + x67 * x99)),
            x0 * x109
            + x0 * (x109 + x110 * x57)
            + x14 * (x108 * x67 + x36 * (x106 * x67 + x36 * (x104 * x63 + x104 * x65))),
            x0 * x117
            + x0 * (x117 + x118 * x57)
            + x14 * (x115 * x67 + x36 * (x113 * x63 + x113 * x65)),
            x0 * x124
            + x0 * (x124 + x125 * x57)
            + x14 * (x123 * x67 + x36 * (x120 * x63 + x120 * x65)),
            x0 * x130
            + x0 * (x130 + x131 * x74)
            + x14 * (x129 * x67 + x36 * (x127 * x63 + x127 * x65)),
            x0 * x137
            + x0 * (x137 + x138 * x57)
            + x14 * (x135 * x67 + x36 * (x133 * x63 + x133 * x65)),
            x0 * x143 + x0 * (x143 + x144 * x4) + x14 * (x141 * x63 + x141 * x65),
            x0 * x148 + x0 * (x148 + x149 * x57) + x14 * (x146 * x63 + x146 * x65),
            x0 * x153 + x0 * (x131 * x90 + x153) + x14 * (x151 * x154 + x151 * x155),
            x0 * x158 + x0 * (x158 + x159 * x57) + x14 * (x154 * x156 + x155 * x156),
            x0 * x163 + x0 * (x163 + x164 * x57) + x14 * (x161 * x63 + x161 * x65),
            x0 * x168 + x0 * (x165 * x57 + x168) + x167 * x62,
            x0 * x171 + x0 * (x10 * x144 + x171) + x170 * x62,
            x0 * x174 + x0 * (x173 * x57 + x174) + x173 * x175,
            x0 * x177 + x0 * (x176 * x57 + x177) + x175 * x176,
            x0 * x179 + x0 * (x178 * x57 + x179) + x175 * x178,
            x0 * x182 + x0 * (x180 * x57 + x182) + x181 * x62,
            x0 * x188
            + x14
            * (
                x189 * x195
                + x36
                * (
                    x189 * x194
                    + x36 * (x189 * x193 + x36 * (x189 * x36 + x36 * (x189 + x192)))
                )
            )
            + x19 * x53,
            x0 * x201
            + x14
            * (
                x207 * x209
                + x36 * (x207 * x208 + x36 * (x206 * x207 + x36 * (x203 + x205 * x36)))
            )
            + x19 * x78,
            x0 * x212
            + x14
            * (
                x209 * x214
                + x36 * (x208 * x214 + x36 * (x206 * x214 + x36 * (x192 * x80 + x213)))
            )
            + x19 * x85,
            x0 * x217
            + x14 * (x208 * x220 + x36 * (x206 * x220 + x36 * (x218 + x219 * x36)))
            + x19 * x93,
            x0 * x223
            + x102 * x19
            + x14 * (x208 * x227 + x36 * (x206 * x227 + x36 * (x224 + x226 * x36))),
            x0 * x230
            + x109 * x19
            + x14 * (x232 * x233 + x36 * (x112 * x232 * x4 + x36 * (x104 * x192 + x231))),
            x0 * x236 + x117 * x19 + x14 * (x234 * x239 + x36 * (x237 + x238 * x36)),
            x0 * x242 + x124 * x19 + x14 * (x239 * x240 + x36 * (x243 + x244 * x36)),
            x0 * x248 + x130 * x19 + x14 * (x239 * x245 + x36 * (x249 + x251 * x36)),
            x0 * x253
            + x137 * x19
            + x14 * (x136 * x140 * x189 + x36 * (x133 * x192 + x254)),
            x0 * x258 + x14 * (x259 + x260 * x36) + x143 * x19,
            x0 * x263 + x14 * (x264 + x265 * x36) + x148 * x19,
            x0 * x268 + x14 * (x269 + x270 * x36) + x153 * x19,
            x0 * x273 + x14 * (x274 + x276 * x36) + x158 * x19,
            x0 * x278 + x14 * (x161 * x192 + x279) + x163 * x19,
            x0 * x281 + x14 * (x141 * x64 + x260 * x68) + x168 * x19,
            x0 * x283 + x14 * (x146 * x64 + x265 * x68) + x171 * x19,
            x0 * x285 + x14 * (x151 * x286 + x270 * x68) + x174 * x19,
            x0 * x288 + x14 * (x156 * x286 + x276 * x68) + x177 * x19,
            x0 * x290 + x14 * (x161 * x204 + x291) + x179 * x19,
            x0 * x293 + x181 * x191 + x182 * x19,
            x0 * x298
            + x14
            * (
                x195 * x299
                + x36
                * (
                    x194 * x299
                    + x36 * (x193 * x299 + x36 * (x299 * x36 + x36 * (x299 + x302)))
                )
            )
            + x20 * x53,
            x0 * x306
            + x14
            * (
                x209 * x309
                + x36 * (x208 * x309 + x36 * (x299 * x308 + x36 * (x302 * x68 + x307)))
            )
            + x20 * x78,
            x0 * x312
            + x14
            * (
                x209 * x315
                + x36 * (x208 * x315 + x36 * (x239 * x310 + x36 * (x313 + x314 * x36)))
            )
            + x20 * x85,
            x0 * x319
            + x14 * (x233 * x299 * x8 + x36 * (x299 * x321 + x36 * (x302 * x87 + x320)))
            + x20 * x93,
            x0 * x324
            + x102 * x20
            + x14 * (x327 * x74 + x36 * (x315 * x326 + x36 * (x308 * x314 + x325))),
            x0 * x330
            + x109 * x20
            + x14 * (x208 * x333 + x36 * (x239 * x328 + x36 * (x331 + x332 * x36))),
            x0 * x337
            + x117 * x20
            + x14 * (x145 * x299 * x4 + x36 * (x113 * x302 + x338)),
            x0 * x341 + x124 * x20 + x14 * (x327 * x90 + x36 * (x119 * x343 + x342)),
            x0 * x347 + x130 * x20 + x14 * (x326 * x333 + x36 * (x308 * x332 + x348)),
            x0 * x351 + x137 * x20 + x14 * (x239 * x349 + x36 * (x352 + x353 * x36)),
            x0 * x357 + x14 * (x141 * x302 + x358) + x143 * x20,
            x0 * x361 + x14 * (x145 * x343 + x362) + x148 * x20,
            x0 * x364 + x14 * (x321 * x332 + x365) + x153 * x20,
            x0 * x367 + x14 * (x308 * x353 + x368) + x158 * x20,
            x0 * x371 + x14 * (x36 * x373 + x372) + x163 * x20,
            x0 * x375 + x167 * x301 + x168 * x20,
            x0 * x377 + x169 * x314 + x171 * x20,
            x0 * x379 + x145 * x332 + x174 * x20,
            x0 * x381 + x119 * x353 + x177 * x20,
            x0 * x383 + x179 * x20 + x373 * x95,
            x0 * x385 + x14 * (x291 + x373 * x80) + x182 * x20,
            x185 * x387 + x186 * x19 + x188 * x19,
            x19 * x199 + x19 * x201 + x198 * x390,
            x19 * x211 + x19 * x212 + x210 * x387,
            x19 * x216 + x19 * x217 + x209 * x391,
            x19 * x222 + x19 * x223 + x209 * x392,
            x110 * x393 + x19 * x229 + x19 * x230,
            x19 * x235 + x19 * x236 + x208 * x394,
            x19 * x241 + x19 * x242 + x208 * x395,
            x19 * x246 + x19 * x248 + x208 * x396,
            x138 * x393 + x19 * x252 + x19 * x253,
            x19 * x256 + x19 * x258 + x206 * x397,
            x19 * x262 + x19 * x263 + x206 * x398,
            x19 * x267 + x19 * x268 + x206 * x399,
            x19 * x272 + x19 * x273 + x206 * x400,
            x164 * x393 + x19 * x277 + x19 * x278,
            x14 * (2.0 * x259 + x397 * x68) + x19 * x280 + x19 * x281,
            x14 * (2.0 * x264 + x398 * x68) + x19 * x282 + x19 * x283,
            x14 * (2.0 * x269 + x399 * x68) + x19 * x284 + x19 * x285,
            x14 * (2.0 * x274 + x400 * x68) + x19 * x287 + x19 * x288,
            x14 * (x161 * x388 + x161 * x389) + x19 * x289 + x19 * x290,
            x181 * x387 + x19 * x292 + x19 * x293,
            x185 * x401 + x186 * x20 + x19 * x298,
            x19 * x306 + x198 * x402 + x199 * x20,
            x19 * x312 + x198 * x403 + x20 * x211,
            x19 * x319 + x20 * x216 + x209 * x404,
            x19 * x324 + x20 * x222 + x209 * x405,
            x19 * x330 + x20 * x229 + x209 * x406,
            x19 * x337 + x20 * x235 + x208 * x407,
            x19 * x341 + x20 * x241 + x208 * x408,
            x19 * x347 + x20 * x246 + x208 * x409,
            x19 * x351 + x20 * x252 + x208 * x410,
            x19 * x357 + x20 * x256 + x206 * x411,
            x19 * x361 + x20 * x262 + x206 * x412,
            x19 * x364 + x20 * x267 + x206 * x413,
            x19 * x367 + x20 * x272 + x206 * x414,
            x19 * x371 + x20 * x277 + x206 * x415,
            x14 * (x358 + x411 * x68) + x19 * x375 + x20 * x280,
            x14 * (x362 + x412 * x68) + x19 * x377 + x20 * x282,
            x14 * (x365 + x413 * x68) + x19 * x379 + x20 * x284,
            x14 * (x368 + x414 * x68) + x19 * x381 + x20 * x287,
            x14 * (x372 + x415 * x68) + x19 * x383 + x20 * x289,
            x14 * (x279 + x415 * x80) + x19 * x385 + x20 * x292,
            x185 * x416 + x20 * x296 + x20 * x298,
            x20 * x304 + x20 * x306 + x303 * x416,
            x198 * x417 + x20 * x311 + x20 * x312,
            x20 * x318 + x20 * x319 + x317 * x416,
            x20 * x323 + x20 * x324 + x322 * x417,
            x20 * x329 + x20 * x330 + x209 * x418,
            x20 * x336 + x20 * x337 + x335 * x416,
            x20 * x340 + x20 * x341 + x339 * x417,
            x20 * x345 + x20 * x347 + x419 * x74,
            x20 * x350 + x20 * x351 + x208 * x420,
            x20 * x355 + x20 * x357 + x354 * x416,
            x20 * x360 + x20 * x361 + x359 * x417,
            x20 * x363 + x20 * x364 + x419 * x90,
            x20 * x366 + x20 * x367 + x326 * x420,
            x20 * x370 + x20 * x371 + x206 * x421,
            x167 * x416 + x20 * x374 + x20 * x375,
            x169 * x417 + x20 * x376 + x20 * x377,
            x145 * x418 + x20 * x378 + x20 * x379,
            x119 * x420 + x20 * x380 + x20 * x381,
            x20 * x382 + x20 * x383 + x421 * x95,
            x14 * (2.0 * x372 + x421 * x80) + x20 * x384 + x20 * x385,
        ]
    )


def _3center2el3d_sph_030(a, A, b, B, c, C):
    """Cartesian (sf|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = (2.0 * a + 2.0 * b) ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - C[0]
    x6 = -x3 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x3 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = c + x2
    x11 = c / x10
    x12 = x11 * x2 * (x5**2 + x7**2 + x9**2)
    x13 = boys(1, x12)
    x14 = 17.4934183276249
    x15 = A[1] - B[1]
    x16 = A[2] - B[2]
    x17 = numpy.exp(-a * b * x3 * (x0**2 + x15**2 + x16**2))
    x18 = 2.0 * x14 * x17 * x3
    x19 = x10 ** (-1.5) * x18
    x20 = x13 * x19
    x21 = c ** (-1.0)
    x22 = x10 ** (-0.5)
    x23 = boys(0, x12)
    x24 = x1 * (2.0 * x14 * x17 * x21 * x22 * x23 * x3 - x20)
    x25 = -x4 - A[0]
    x26 = x20 * x5
    x27 = -2.0 * x14 * x17 * x21 * x22 * x23 * x25 * x3 + x26
    x28 = -x27
    x29 = boys(2, x12)
    x30 = x19 * x29
    x31 = 2.0 * x13 * x14 * x17 * x21 * x22 * x25 * x3 - x30 * x5
    x32 = x11 * x31
    x33 = x24 + x25 * x28 - x32 * x5
    x34 = x0 * x28 + x33
    x35 = x18 * x21 * x22 * x23
    x36 = x1 * (2.0 * x13 * x14 * x17 * x21 * x22 * x3 - x30)
    x37 = x19 * boys(3, x12)
    x38 = x11 * x5
    x39 = -x6 - A[1]
    x40 = 2.0 * x13 * x14 * x17 * x21 * x22 * x3 * x39 - x30 * x7
    x41 = x11 * x40
    x42 = x20 * x7
    x43 = -2.0 * x14 * x17 * x21 * x22 * x23 * x3 * x39 + x42
    x44 = x1 * (-x41 - x43)
    x45 = -x43
    x46 = x41 * x5
    x47 = x15 * x28 + x25 * x45 - x46
    x48 = x15 * x35 + x35 * x39 - x42
    x49 = x25 * x45 - x46
    x50 = 2.0 * x14 * x17 * x21 * x22 * x29 * x3 * x39 - x37 * x7
    x51 = -x8 - A[2]
    x52 = 2.0 * x13 * x14 * x17 * x21 * x22 * x3 * x51 - x30 * x9
    x53 = x11 * x52
    x54 = x20 * x9
    x55 = -2.0 * x14 * x17 * x21 * x22 * x23 * x3 * x51 + x54
    x56 = x1 * (-x53 - x55)
    x57 = -x55
    x58 = x5 * x53
    x59 = x16 * x28 + x25 * x57 - x58
    x60 = x16 * x35 + x35 * x51 - x54
    x61 = x25 * x57 - x58
    x62 = 2.0 * x14 * x17 * x21 * x22 * x29 * x3 * x51 - x37 * x9
    x63 = x24 + x39 * x45 - x41 * x7
    x64 = x15 * x45 + x63
    x65 = x15 * x48 + x64
    x66 = x11 * x7
    x67 = x36 + x39 * x40 - x50 * x66
    x68 = x53 * x7
    x69 = x16 * x45 + x39 * x57 - x68
    x70 = x15 * x60 + x69
    x71 = x39 * x57 - x68
    x72 = x39 * x52 - x62 * x66
    x73 = x24 + x51 * x57 - x53 * x9
    x74 = x16 * x57 + x73
    x75 = x16 * x60 + x74
    x76 = x11 * x9
    x77 = x36 + x51 * x52 - x62 * x76

    # 10 item(s)
    return numpy.array(
        [
            x0 * x33
            + x0 * x34
            + x0 * (x0 * (x0 * x35 + x25 * x35 - x26) + x34)
            + 2.0 * x1 * (-x27 - x32)
            + x25 * x33
            - x38
            * (
                x25 * x31
                + x36
                - x38 * (2.0 * x14 * x17 * x21 * x22 * x25 * x29 * x3 - x37 * x5)
            ),
            x0 * x47
            + x0 * (x0 * x48 + x47)
            + x15 * x33
            + x25 * x49
            - x38 * (x25 * x40 - x38 * x50)
            + x44,
            x0 * x59
            + x0 * (x0 * x60 + x59)
            + x16 * x33
            + x25 * x61
            - x38 * (x25 * x52 - x38 * x62)
            + x56,
            x0 * x65 + x15 * x47 + x15 * x49 + x25 * x63 - x38 * x67,
            x0 * x70 + x15 * x59 + x16 * x49 + x25 * x71 - x38 * x72,
            x0 * x75 + x16 * x59 + x16 * x61 + x25 * x73 - x38 * x77,
            x15 * x63 + x15 * x64 + x15 * x65 + x39 * x63 + 2.0 * x44 - x66 * x67,
            x15 * x69 + x15 * x70 + x16 * x63 + x39 * x71 + x56 - x66 * x72,
            x15 * x75 + x16 * x69 + x16 * x71 + x39 * x73 - x66 * x77,
            x16 * x73 + x16 * x74 + x16 * x75 + x51 * x73 + 2.0 * x56 - x76 * x77,
        ]
    )


def _3center2el3d_sph_031(a, A, b, B, c, C):
    """Cartesian (sf|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x2 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = c + x1
    x11 = x10 ** (-1.0)
    x12 = x1 * x11
    x13 = c * x12 * (x4**2 + x7**2 + x9**2)
    x14 = boys(2, x13)
    x15 = x10 ** (-1.5)
    x16 = 17.4934183276249
    x17 = A[1] - B[1]
    x18 = A[2] - B[2]
    x19 = numpy.exp(-a * b * x2 * (x0**2 + x17**2 + x18**2))
    x20 = x16 * x19 * x2
    x21 = 2.0 * x15 * x20
    x22 = x14 * x21
    x23 = c ** (-1.0)
    x24 = x10 ** (-0.5)
    x25 = boys(1, x13)
    x26 = x5 * (2.0 * x16 * x19 * x2 * x23 * x24 * x25 - x22)
    x27 = -x3 - A[0]
    x28 = -2.0 * x16 * x19 * x2 * x23 * x24 * x25 * x27 + x22 * x4
    x29 = -x28
    x30 = boys(3, x13)
    x31 = x21 * x30
    x32 = 2.0 * x14 * x16 * x19 * x2 * x23 * x24 * x27 - x31 * x4
    x33 = c * x11
    x34 = x32 * x33
    x35 = x26 + x27 * x29 - x34 * x4
    x36 = x29 * x5
    x37 = x12 * (x35 * x4 + 2.0 * x36)
    x38 = 2.0 * x5
    x39 = x23 * x25
    x40 = x20 * x24 * x38 * x39
    x41 = x12 * (x29 * x4 + x40)
    x42 = x0 * x41 + x37
    x43 = 2.0 * x15 * x16 * x19 * x39
    x44 = x0 * x43
    x45 = x5 * (2.0 * x14 * x16 * x19 * x2 * x23 * x24 - x31)
    x46 = x21 * boys(4, x13)
    x47 = x33 * x4
    x48 = (
        x27 * x35
        + x38 * (-x28 - x34)
        - x47
        * (
            x27 * x32
            + x45
            - x47 * (2.0 * x16 * x19 * x2 * x23 * x24 * x27 * x30 - x4 * x46)
        )
    )
    x49 = x35 * x5
    x50 = x12 * x7
    x51 = x35 * x50
    x52 = x29 * x50
    x53 = x0 * x52 + x51
    x54 = x12 * x9
    x55 = x35 * x54
    x56 = x29 * x54
    x57 = x0 * x56 + x55
    x58 = -x6 - A[1]
    x59 = -2.0 * x16 * x19 * x2 * x23 * x24 * x25 * x58 + x22 * x7
    x60 = -x59
    x61 = x5 * x60
    x62 = 2.0 * x14 * x16 * x19 * x2 * x23 * x24 * x58 - x31 * x7
    x63 = x33 * x62
    x64 = x27 * x60 - x4 * x63
    x65 = x12 * (x4 * x64 + x61)
    x66 = x17 * x41 + x65
    x67 = x12 * x4
    x68 = x60 * x67
    x69 = x17 * x43
    x70 = x4 * x69 + x68
    x71 = x5 * (-x59 - x63)
    x72 = 2.0 * x16 * x19 * x2 * x23 * x24 * x30 * x58 - x46 * x7
    x73 = x27 * x64 - x47 * (x27 * x62 - x47 * x72) + x71
    x74 = x5 * x64
    x75 = 2.0 * x74
    x76 = x12 * (x36 + x64 * x7)
    x77 = x17 * x52 + x76
    x78 = x12 * (x40 + x60 * x7)
    x79 = x69 * x7 + x78
    x80 = x54 * x64
    x81 = x17 * x56 + x80
    x82 = x54 * x60
    x83 = x69 * x9 + x82
    x84 = -x8 - A[2]
    x85 = -2.0 * x16 * x19 * x2 * x23 * x24 * x25 * x84 + x22 * x9
    x86 = -x85
    x87 = x5 * x86
    x88 = 2.0 * x14 * x16 * x19 * x2 * x23 * x24 * x84 - x31 * x9
    x89 = x33 * x88
    x90 = x27 * x86 - x4 * x89
    x91 = x12 * (x4 * x90 + x87)
    x92 = x18 * x41 + x91
    x93 = x67 * x86
    x94 = x18 * x43
    x95 = x4 * x94 + x93
    x96 = x5 * (-x85 - x89)
    x97 = 2.0 * x16 * x19 * x2 * x23 * x24 * x30 * x84 - x46 * x9
    x98 = x27 * x90 - x47 * (x27 * x88 - x47 * x97) + x96
    x99 = x5 * x90
    x100 = 2.0 * x99
    x101 = x50 * x90
    x102 = x101 + x18 * x52
    x103 = x50 * x86
    x104 = x103 + x7 * x94
    x105 = x12 * (x36 + x9 * x90)
    x106 = x105 + x18 * x56
    x107 = x12 * (x40 + x86 * x9)
    x108 = x107 + x9 * x94
    x109 = x26 + x58 * x60 - x63 * x7
    x110 = x109 * x67
    x111 = x110 + x17 * x68
    x112 = x111 + x17 * x70
    x113 = x109 * x5
    x114 = x33 * x7
    x115 = -x114 * x72 + x45 + x58 * x62
    x116 = x109 * x27 - x115 * x47
    x117 = x12 * (x109 * x7 + 2.0 * x61)
    x118 = x117 + x17 * x78
    x119 = x118 + x17 * x79
    x120 = x109 * x54
    x121 = x120 + x17 * x82
    x122 = x121 + x17 * x83
    x123 = x58 * x86 - x7 * x89
    x124 = x123 * x67
    x125 = x124 + x18 * x68
    x126 = x125 + x17 * x95
    x127 = x123 * x5
    x128 = -x114 * x97 + x58 * x88
    x129 = x123 * x27 - x128 * x47
    x130 = x12 * (x123 * x7 + x87)
    x131 = x130 + x18 * x78
    x132 = x104 * x17 + x131
    x133 = x12 * (x123 * x9 + x61)
    x134 = x133 + x18 * x82
    x135 = x108 * x17 + x134
    x136 = x26 + x84 * x86 - x89 * x9
    x137 = x136 * x67
    x138 = x137 + x18 * x93
    x139 = x138 + x18 * x95
    x140 = x136 * x5
    x141 = x33 * x9
    x142 = -x141 * x97 + x45 + x84 * x88
    x143 = x136 * x27 - x142 * x47
    x144 = x136 * x50
    x145 = x103 * x18 + x144
    x146 = x104 * x18 + x145
    x147 = x12 * (x136 * x9 + 2.0 * x87)
    x148 = x107 * x18 + x147
    x149 = x108 * x18 + x148
    x150 = x109 * x58 - x114 * x115 + 2.0 * x71
    x151 = -x114 * x128 + x123 * x58 + x96
    x152 = 2.0 * x127
    x153 = -x114 * x142 + x136 * x58
    x154 = x136 * x84 - x141 * x142 + 2.0 * x96

    # 30 item(s)
    return numpy.array(
        [
            x0 * x37
            + x0 * x42
            + x0 * (x0 * (x4 * x44 + x41) + x42)
            + x12 * (x4 * x48 + 3.0 * x49),
            x0 * x51 + x0 * x53 + x0 * (x0 * (x44 * x7 + x52) + x53) + x48 * x50,
            x0 * x55 + x0 * x57 + x0 * (x0 * (x44 * x9 + x56) + x57) + x48 * x54,
            x0 * x66 + x0 * (x0 * x70 + x66) + x12 * (x4 * x73 + x75) + x17 * x37,
            x0 * x77 + x0 * (x0 * x79 + x77) + x12 * (x49 + x7 * x73) + x17 * x51,
            x0 * x81 + x0 * (x0 * x83 + x81) + x17 * x55 + x54 * x73,
            x0 * x92 + x0 * (x0 * x95 + x92) + x12 * (x100 + x4 * x98) + x18 * x37,
            x0 * x102 + x0 * (x0 * x104 + x102) + x18 * x51 + x50 * x98,
            x0 * x106 + x0 * (x0 * x108 + x106) + x12 * (x49 + x9 * x98) + x18 * x55,
            x0 * x112 + x12 * (x113 + x116 * x4) + x17 * x65 + x17 * x66,
            x0 * x119 + x12 * (x116 * x7 + x75) + x17 * x76 + x17 * x77,
            x0 * x122 + x116 * x54 + x17 * x80 + x17 * x81,
            x0 * x126 + x12 * (x127 + x129 * x4) + x17 * x92 + x18 * x65,
            x0 * x132 + x102 * x17 + x12 * (x129 * x7 + x99) + x18 * x76,
            x0 * x135 + x106 * x17 + x12 * (x129 * x9 + x74) + x18 * x80,
            x0 * x139 + x12 * (x140 + x143 * x4) + x18 * x91 + x18 * x92,
            x0 * x146 + x101 * x18 + x102 * x18 + x143 * x50,
            x0 * x149 + x105 * x18 + x106 * x18 + x12 * (x100 + x143 * x9),
            x110 * x17 + x111 * x17 + x112 * x17 + x150 * x67,
            x117 * x17 + x118 * x17 + x119 * x17 + x12 * (3.0 * x113 + x150 * x7),
            x120 * x17 + x121 * x17 + x122 * x17 + x150 * x54,
            x110 * x18 + x125 * x17 + x126 * x17 + x151 * x67,
            x117 * x18 + x12 * (x151 * x7 + x152) + x131 * x17 + x132 * x17,
            x12 * (x113 + x151 * x9) + x120 * x18 + x134 * x17 + x135 * x17,
            x124 * x18 + x125 * x18 + x139 * x17 + x153 * x67,
            x12 * (x140 + x153 * x7) + x130 * x18 + x131 * x18 + x146 * x17,
            x12 * (x152 + x153 * x9) + x133 * x18 + x134 * x18 + x149 * x17,
            x137 * x18 + x138 * x18 + x139 * x18 + x154 * x67,
            x144 * x18 + x145 * x18 + x146 * x18 + x154 * x50,
            x12 * (3.0 * x140 + x154 * x9) + x147 * x18 + x148 * x18 + x149 * x18,
        ]
    )


def _3center2el3d_sph_032(a, A, b, B, c, C):
    """Cartesian (sf|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(3, x16)
    x18 = x13 ** (-1.5)
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x2 * x22
    x24 = 2.0 * x18 * x23
    x25 = x17 * x24
    x26 = c ** (-1.0)
    x27 = x13 ** (-0.5)
    x28 = boys(2, x16)
    x29 = x5 * (2.0 * x19 * x2 * x22 * x26 * x27 * x28 - x25)
    x30 = -x3 - A[0]
    x31 = -2.0 * x19 * x2 * x22 * x26 * x27 * x28 * x30 + x25 * x4
    x32 = -x31
    x33 = boys(4, x16)
    x34 = x24 * x33
    x35 = 2.0 * x17 * x19 * x2 * x22 * x26 * x27 * x30 - x34 * x4
    x36 = c * x14
    x37 = x35 * x36
    x38 = x29 + x30 * x32 - x37 * x4
    x39 = x38 * x4
    x40 = x32 * x5
    x41 = 2.0 * x40
    x42 = x39 + x41
    x43 = x15 * x4
    x44 = x32 * x4
    x45 = 2.0 * x5
    x46 = x26 * x28
    x47 = x45 * x46
    x48 = x23 * x27 * x47
    x49 = x44 + x48
    x50 = x15 * x45
    x51 = x15 * (x42 * x43 + x49 * x50)
    x52 = x19 * x22
    x53 = x4 * x52
    x54 = x18 * x47
    x55 = x15 * (x43 * x49 + x53 * x54)
    x56 = x0 * x55 + x51
    x57 = 2.0 * x1 * x13 ** (-2.5) * x46
    x58 = x52 * x57
    x59 = x0 * x58
    x60 = x5 * (2.0 * x17 * x19 * x2 * x22 * x26 * x27 - x34)
    x61 = x24 * boys(5, x16)
    x62 = x36 * x4
    x63 = (
        x30 * x38
        + x45 * (-x31 - x37)
        - x62
        * (
            x30 * x35
            + x60
            - x62 * (2.0 * x19 * x2 * x22 * x26 * x27 * x30 * x33 - x4 * x61)
        )
    )
    x64 = x4 * x63
    x65 = x38 * x5
    x66 = 3.0 * x65
    x67 = x15 * x5
    x68 = x15 * x8
    x69 = x15 * (x39 * x68 + x41 * x68)
    x70 = x52 * x54
    x71 = x70 * x8
    x72 = x15 * (x44 * x68 + x71)
    x73 = x0 * x72 + x69
    x74 = x53 * x57
    x75 = x0 * x74
    x76 = x11 * x15
    x77 = x15 * (x39 * x76 + x41 * x76)
    x78 = x11 * x70
    x79 = x15 * (x44 * x76 + x78)
    x80 = x0 * x79 + x77
    x81 = x1**2 / x13**2
    x82 = x81 * x9
    x83 = x38 * x82
    x84 = x32 * x82
    x85 = x0 * x84 + x83
    x86 = x8 * x81
    x87 = x11 * x86
    x88 = x38 * x87
    x89 = x32 * x87
    x90 = x0 * x89 + x88
    x91 = x11 * x8
    x92 = x12 * x81
    x93 = x38 * x92
    x94 = x32 * x92
    x95 = x0 * x94 + x93
    x96 = -x7 - A[1]
    x97 = -2.0 * x19 * x2 * x22 * x26 * x27 * x28 * x96 + x25 * x8
    x98 = -x97
    x99 = x5 * x98
    x100 = 2.0 * x17 * x19 * x2 * x22 * x26 * x27 * x96 - x34 * x8
    x101 = x100 * x36
    x102 = -x101 * x4 + x30 * x98
    x103 = x102 * x4
    x104 = x103 + x99
    x105 = x15 * (x104 * x43 + x43 * x99)
    x106 = x105 + x20 * x55
    x107 = x6 * x81
    x108 = x107 * x98
    x109 = x20 * x58
    x110 = x108 + x109 * x6
    x111 = x5 * (-x101 - x97)
    x112 = 2.0 * x19 * x2 * x22 * x26 * x27 * x33 * x96 - x61 * x8
    x113 = x102 * x30 + x111 - x62 * (x100 * x30 - x112 * x62)
    x114 = x113 * x4
    x115 = x102 * x5
    x116 = 2.0 * x115
    x117 = x8 * x98
    x118 = x117 + x48
    x119 = x118 * x15
    x120 = x102 * x8
    x121 = x120 + x40
    x122 = x15 * (x119 * x5 + x121 * x43)
    x123 = x122 + x20 * x72
    x124 = x4 * x81
    x125 = x118 * x124
    x126 = x20 * x74
    x127 = x125 + x126 * x8
    x128 = x113 * x8
    x129 = x128 + x65
    x130 = x121 * x50
    x131 = x76 * x99
    x132 = x15 * (x103 * x76 + x131)
    x133 = x132 + x20 * x79
    x134 = x11 * x124
    x135 = x134 * x98
    x136 = x11 * x126 + x135
    x137 = x116 * x76
    x138 = x15 * (x121 * x68 + x40 * x68)
    x139 = x138 + x20 * x84
    x140 = x15 * (x119 * x8 + x71)
    x141 = x109 * x9 + x140
    x142 = x40 * x76
    x143 = x15 * (x120 * x76 + x142)
    x144 = x143 + x20 * x89
    x145 = x15 * (x117 * x76 + x78)
    x146 = x109 * x91 + x145
    x147 = x65 * x76
    x148 = x102 * x92
    x149 = x148 + x20 * x94
    x150 = x92 * x98
    x151 = x109 * x12 + x150
    x152 = -x10 - A[2]
    x153 = x11 * x25 - 2.0 * x152 * x19 * x2 * x22 * x26 * x27 * x28
    x154 = -x153
    x155 = x154 * x5
    x156 = -x11 * x34 + 2.0 * x152 * x17 * x19 * x2 * x22 * x26 * x27
    x157 = x156 * x36
    x158 = x154 * x30 - x157 * x4
    x159 = x158 * x4
    x160 = x155 + x159
    x161 = x15 * (x155 * x43 + x160 * x43)
    x162 = x161 + x21 * x55
    x163 = x107 * x154
    x164 = x21 * x58
    x165 = x163 + x164 * x6
    x166 = x5 * (-x153 - x157)
    x167 = -x11 * x61 + 2.0 * x152 * x19 * x2 * x22 * x26 * x27 * x33
    x168 = x158 * x30 + x166 - x62 * (x156 * x30 - x167 * x62)
    x169 = x168 * x4
    x170 = x158 * x5
    x171 = 2.0 * x170
    x172 = x155 * x68
    x173 = x15 * (x159 * x68 + x172)
    x174 = x173 + x21 * x72
    x175 = x124 * x8
    x176 = x154 * x175
    x177 = x21 * x74
    x178 = x176 + x177 * x8
    x179 = x11 * x154 + x48
    x180 = x15 * x179
    x181 = x180 * x5
    x182 = x11 * x158 + x40
    x183 = x15 * (x181 + x182 * x43)
    x184 = x183 + x21 * x79
    x185 = x124 * x179
    x186 = x11 * x177 + x185
    x187 = x11 * x168 + x65
    x188 = x182 * x50
    x189 = x158 * x82
    x190 = x189 + x21 * x84
    x191 = x154 * x82
    x192 = x164 * x9 + x191
    x193 = x182 * x86
    x194 = x193 + x21 * x89
    x195 = x179 * x86
    x196 = x164 * x91 + x195
    x197 = x15 * (x142 + x182 * x76)
    x198 = x197 + x21 * x94
    x199 = x15 * (x11 * x180 + x78)
    x200 = x12 * x164 + x199
    x201 = -x101 * x8 + x29 + x96 * x98
    x202 = x107 * x201
    x203 = x108 * x20 + x202
    x204 = x110 * x20 + x203
    x205 = x201 * x5
    x206 = x36 * x8
    x207 = x100 * x96 - x112 * x206 + x60
    x208 = x201 * x30 - x207 * x62
    x209 = x208 * x4
    x210 = x201 * x8
    x211 = 2.0 * x99
    x212 = x210 + x211
    x213 = x124 * x212
    x214 = x125 * x20 + x213
    x215 = x127 * x20 + x214
    x216 = x212 * x67
    x217 = x208 * x8
    x218 = x116 + x217
    x219 = x134 * x201
    x220 = x135 * x20 + x219
    x221 = x136 * x20 + x220
    x222 = x205 * x76
    x223 = x15 * (x119 * x45 + x212 * x68)
    x224 = x140 * x20 + x223
    x225 = x141 * x20 + x224
    x226 = x15 * (x210 * x76 + x211 * x76)
    x227 = x145 * x20 + x226
    x228 = x146 * x20 + x227
    x229 = x201 * x92
    x230 = x150 * x20 + x229
    x231 = x151 * x20 + x230
    x232 = x154 * x96 - x157 * x8
    x233 = x107 * x232
    x234 = x108 * x21 + x233
    x235 = x165 * x20 + x234
    x236 = x232 * x5
    x237 = x156 * x96 - x167 * x206
    x238 = x232 * x30 - x237 * x62
    x239 = x155 + x232 * x8
    x240 = x124 * x239
    x241 = x125 * x21 + x240
    x242 = x178 * x20 + x241
    x243 = x170 + x238 * x8
    x244 = x11 * x232 + x99
    x245 = x124 * x244
    x246 = x135 * x21 + x245
    x247 = x186 * x20 + x246
    x248 = x11 * x238 + x115
    x249 = x15 * (x172 + x239 * x68)
    x250 = x140 * x21 + x249
    x251 = x192 * x20 + x250
    x252 = x15 * (x181 + x244 * x68)
    x253 = x145 * x21 + x252
    x254 = x196 * x20 + x253
    x255 = x15 * (x131 + x244 * x76)
    x256 = x150 * x21 + x255
    x257 = x20 * x200 + x256
    x258 = -x11 * x157 + x152 * x154 + x29
    x259 = x107 * x258
    x260 = x163 * x21 + x259
    x261 = x165 * x21 + x260
    x262 = x258 * x5
    x263 = x11 * x36
    x264 = x152 * x156 - x167 * x263 + x60
    x265 = x258 * x30 - x264 * x62
    x266 = x265 * x4
    x267 = x175 * x258
    x268 = x176 * x21 + x267
    x269 = x178 * x21 + x268
    x270 = x262 * x68
    x271 = x11 * x258 + 2.0 * x155
    x272 = x124 * x271
    x273 = x185 * x21 + x272
    x274 = x186 * x21 + x273
    x275 = x271 * x67
    x276 = x11 * x265 + x171
    x277 = x258 * x82
    x278 = x191 * x21 + x277
    x279 = x192 * x21 + x278
    x280 = x271 * x86
    x281 = x195 * x21 + x280
    x282 = x196 * x21 + x281
    x283 = x15 * (x180 * x45 + x271 * x76)
    x284 = x199 * x21 + x283
    x285 = x200 * x21 + x284
    x286 = 2.0 * x111 + x201 * x96 - x206 * x207
    x287 = x286 * x8
    x288 = 3.0 * x205
    x289 = x287 + x288
    x290 = x166 - x206 * x237 + x232 * x96
    x291 = 2.0 * x236
    x292 = x290 * x8 + x291
    x293 = x11 * x290 + x205
    x294 = x244 * x50
    x295 = -x206 * x264 + x258 * x96
    x296 = x262 + x295 * x8
    x297 = x11 * x295 + x291
    x298 = x152 * x258 + 2.0 * x166 - x263 * x264
    x299 = x11 * x298 + 3.0 * x262

    # 60 item(s)
    return numpy.array(
        [
            x0 * x51
            + x0 * x56
            + x0 * (x0 * (x55 + x59 * x6) + x56)
            + x15 * (3.0 * x42 * x67 + x43 * (x64 + x66)),
            x0 * x69
            + x0 * x73
            + x0 * (x0 * (x72 + x75 * x8) + x73)
            + x15 * (x64 * x68 + x66 * x68),
            x0 * x77
            + x0 * x80
            + x0 * (x0 * (x11 * x75 + x79) + x80)
            + x15 * (x64 * x76 + x66 * x76),
            x0 * x83 + x0 * x85 + x0 * (x0 * (x59 * x9 + x84) + x85) + x63 * x82,
            x0 * x88 + x0 * x90 + x0 * (x0 * (x59 * x91 + x89) + x90) + x63 * x87,
            x0 * x93 + x0 * x95 + x0 * (x0 * (x12 * x59 + x94) + x95) + x63 * x92,
            x0 * x106
            + x0 * (x0 * x110 + x106)
            + x15 * (x104 * x50 + x43 * (x114 + x116))
            + x20 * x51,
            x0 * x123 + x0 * (x0 * x127 + x123) + x15 * (x129 * x43 + x130) + x20 * x69,
            x0 * x133 + x0 * (x0 * x136 + x133) + x15 * (x114 * x76 + x137) + x20 * x77,
            x0 * x139
            + x0 * (x0 * x141 + x139)
            + x15 * (x129 * x68 + x65 * x68)
            + x20 * x83,
            x0 * x144 + x0 * (x0 * x146 + x144) + x15 * (x128 * x76 + x147) + x20 * x88,
            x0 * x149 + x0 * (x0 * x151 + x149) + x113 * x92 + x20 * x93,
            x0 * x162
            + x0 * (x0 * x165 + x162)
            + x15 * (x160 * x50 + x43 * (x169 + x171))
            + x21 * x51,
            x0 * x174
            + x0 * (x0 * x178 + x174)
            + x15 * (x169 * x68 + x171 * x68)
            + x21 * x69,
            x0 * x184 + x0 * (x0 * x186 + x184) + x15 * (x187 * x43 + x188) + x21 * x77,
            x0 * x190 + x0 * (x0 * x192 + x190) + x168 * x82 + x21 * x83,
            x0 * x194 + x0 * (x0 * x196 + x194) + x187 * x86 + x21 * x88,
            x0 * x198 + x0 * (x0 * x200 + x198) + x15 * (x147 + x187 * x76) + x21 * x93,
            x0 * x204
            + x105 * x20
            + x106 * x20
            + x15 * (x205 * x43 + x43 * (x205 + x209)),
            x0 * x215 + x122 * x20 + x123 * x20 + x15 * (x216 + x218 * x43),
            x0 * x221 + x132 * x20 + x133 * x20 + x15 * (x209 * x76 + x222),
            x0 * x225 + x138 * x20 + x139 * x20 + x15 * (x130 + x218 * x68),
            x0 * x228 + x143 * x20 + x144 * x20 + x15 * (x137 + x217 * x76),
            x0 * x231 + x148 * x20 + x149 * x20 + x208 * x92,
            x0 * x235
            + x105 * x21
            + x15 * (x236 * x43 + x43 * (x236 + x238 * x4))
            + x162 * x20,
            x0 * x242 + x122 * x21 + x15 * (x239 * x67 + x243 * x43) + x174 * x20,
            x0 * x247 + x132 * x21 + x15 * (x244 * x67 + x248 * x43) + x184 * x20,
            x0 * x251 + x138 * x21 + x15 * (x170 * x68 + x243 * x68) + x190 * x20,
            x0 * x254 + x143 * x21 + x15 * (x182 * x67 + x248 * x68) + x194 * x20,
            x0 * x257 + x148 * x21 + x15 * (x115 * x76 + x248 * x76) + x198 * x20,
            x0 * x261
            + x15 * (x262 * x43 + x43 * (x262 + x266))
            + x161 * x21
            + x162 * x21,
            x0 * x269 + x15 * (x266 * x68 + x270) + x173 * x21 + x174 * x21,
            x0 * x274 + x15 * (x275 + x276 * x43) + x183 * x21 + x184 * x21,
            x0 * x279 + x189 * x21 + x190 * x21 + x265 * x82,
            x0 * x282 + x193 * x21 + x194 * x21 + x276 * x86,
            x0 * x285 + x15 * (x188 + x276 * x76) + x197 * x21 + x198 * x21,
            x107 * x286 + x20 * x202 + x20 * x203 + x20 * x204,
            x124 * x289 + x20 * x213 + x20 * x214 + x20 * x215,
            x134 * x286 + x20 * x219 + x20 * x220 + x20 * x221,
            x15 * (3.0 * x216 + x289 * x68) + x20 * x223 + x20 * x224 + x20 * x225,
            x15 * (x287 * x76 + x288 * x76) + x20 * x226 + x20 * x227 + x20 * x228,
            x20 * x229 + x20 * x230 + x20 * x231 + x286 * x92,
            x107 * x290 + x20 * x234 + x20 * x235 + x202 * x21,
            x124 * x292 + x20 * x241 + x20 * x242 + x21 * x213,
            x124 * x293 + x20 * x246 + x20 * x247 + x21 * x219,
            x15 * (x239 * x50 + x292 * x68) + x20 * x250 + x20 * x251 + x21 * x223,
            x15 * (x293 * x68 + x294) + x20 * x253 + x20 * x254 + x21 * x226,
            x15 * (x222 + x293 * x76) + x20 * x256 + x20 * x257 + x21 * x229,
            x107 * x295 + x20 * x261 + x21 * x233 + x21 * x234,
            x124 * x296 + x20 * x269 + x21 * x240 + x21 * x241,
            x124 * x297 + x20 * x274 + x21 * x245 + x21 * x246,
            x15 * (x270 + x296 * x68) + x20 * x279 + x21 * x249 + x21 * x250,
            x15 * (x275 + x297 * x68) + x20 * x282 + x21 * x252 + x21 * x253,
            x15 * (x294 + x297 * x76) + x20 * x285 + x21 * x255 + x21 * x256,
            x107 * x298 + x21 * x259 + x21 * x260 + x21 * x261,
            x175 * x298 + x21 * x267 + x21 * x268 + x21 * x269,
            x124 * x299 + x21 * x272 + x21 * x273 + x21 * x274,
            x21 * x277 + x21 * x278 + x21 * x279 + x298 * x82,
            x21 * x280 + x21 * x281 + x21 * x282 + x299 * x86,
            x15 * (3.0 * x275 + x299 * x76) + x21 * x283 + x21 * x284 + x21 * x285,
        ]
    )


def _3center2el3d_sph_033(a, A, b, B, c, C):
    """Cartesian (sf|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(4, x16)
    x18 = x13 ** (-1.5)
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x22
    x24 = x2 * x23
    x25 = 2.0 * x18 * x24
    x26 = x17 * x25
    x27 = c ** (-1.0)
    x28 = x13 ** (-0.5)
    x29 = boys(3, x16)
    x30 = x5 * (2.0 * x19 * x2 * x22 * x27 * x28 * x29 - x26)
    x31 = -x3 - A[0]
    x32 = -2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x31 + x26 * x4
    x33 = -x32
    x34 = boys(5, x16)
    x35 = x25 * x34
    x36 = 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x31 - x35 * x4
    x37 = c * x14
    x38 = x36 * x37
    x39 = x30 + x31 * x33 - x38 * x4
    x40 = x39 * x4
    x41 = x33 * x5
    x42 = 2.0 * x41
    x43 = x40 + x42
    x44 = x15 * x4
    x45 = x33 * x4
    x46 = 2.0 * x5
    x47 = x27 * x29
    x48 = x46 * x47
    x49 = x24 * x28 * x48
    x50 = x45 + x49
    x51 = x15 * x46
    x52 = x43 * x44 + x50 * x51
    x53 = x23 * x48
    x54 = x18 * x53
    x55 = x4 * x54 + x44 * x50
    x56 = x15 * (x44 * x52 + x51 * x55)
    x57 = x1 * x13 ** (-2.5) * x53
    x58 = x15 * (x44 * x55 + x57 * x6)
    x59 = x0 * x58 + x56
    x60 = x4**3
    x61 = x1**2
    x62 = 2.0 * x13 ** (-3.5) * x23 * x47 * x61
    x63 = x0 * x62
    x64 = x5 * (2.0 * x17 * x19 * x2 * x22 * x27 * x28 - x35)
    x65 = x25 * boys(6, x16)
    x66 = x37 * x4
    x67 = (
        x31 * x39
        + x46 * (-x32 - x38)
        - x66
        * (
            x31 * x36
            + x64
            - x66 * (2.0 * x19 * x2 * x22 * x27 * x28 * x31 * x34 - x4 * x65)
        )
    )
    x68 = x4 * x67
    x69 = x39 * x5
    x70 = 3.0 * x69
    x71 = x15 * x5
    x72 = 3.0 * x71
    x73 = x15 * x8
    x74 = x40 * x73 + x42 * x73
    x75 = x54 * x8
    x76 = x45 * x73 + x75
    x77 = x15 * (x44 * x74 + x51 * x76)
    x78 = x4 * x8
    x79 = x15 * (x44 * x76 + x57 * x78)
    x80 = x0 * x79 + x77
    x81 = x6 * x63
    x82 = x11 * x15
    x83 = x40 * x82 + x42 * x82
    x84 = x11 * x54
    x85 = x45 * x82 + x84
    x86 = x15 * (x44 * x83 + x51 * x85)
    x87 = x11 * x57
    x88 = x15 * (x4 * x87 + x44 * x85)
    x89 = x0 * x88 + x86
    x90 = x61 / x13**2
    x91 = x9 * x90
    x92 = x15 * (x40 * x91 + x42 * x91)
    x93 = x57 * x9
    x94 = x15 * (x45 * x91 + x93)
    x95 = x0 * x94 + x92
    x96 = x4 * x63
    x97 = x8 * x90
    x98 = x11 * x97
    x99 = x15 * (x40 * x98 + x42 * x98)
    x100 = x8 * x87
    x101 = x15 * (x100 + x45 * x98)
    x102 = x0 * x101 + x99
    x103 = x11 * x78
    x104 = x12 * x90
    x105 = x15 * (x104 * x40 + x104 * x42)
    x106 = x12 * x57
    x107 = x15 * (x104 * x45 + x106)
    x108 = x0 * x107 + x105
    x109 = x8**3
    x110 = x1**3 / x13**3
    x111 = x109 * x110
    x112 = x111 * x39
    x113 = x111 * x33
    x114 = x0 * x113 + x112
    x115 = x110 * x9
    x116 = x11 * x115
    x117 = x116 * x39
    x118 = x116 * x33
    x119 = x0 * x118 + x117
    x120 = x11 * x9
    x121 = x110 * x12
    x122 = x121 * x8
    x123 = x122 * x39
    x124 = x122 * x33
    x125 = x0 * x124 + x123
    x126 = x12 * x8
    x127 = x11**3
    x128 = x110 * x127
    x129 = x128 * x39
    x130 = x128 * x33
    x131 = x0 * x130 + x129
    x132 = -x7 - A[1]
    x133 = -2.0 * x132 * x19 * x2 * x22 * x27 * x28 * x29 + x26 * x8
    x134 = -x133
    x135 = x134 * x5
    x136 = 2.0 * x132 * x17 * x19 * x2 * x22 * x27 * x28 - x35 * x8
    x137 = x136 * x37
    x138 = x134 * x31 - x137 * x4
    x139 = x138 * x4
    x140 = x135 + x139
    x141 = x135 * x44 + x140 * x44
    x142 = x6 * x90
    x143 = x15 * (x135 * x142 + x141 * x44)
    x144 = x143 + x20 * x58
    x145 = x110 * x60
    x146 = x134 * x145
    x147 = x20 * x62
    x148 = x146 + x147 * x60
    x149 = x5 * (-x133 - x137)
    x150 = 2.0 * x132 * x19 * x2 * x22 * x27 * x28 * x34 - x65 * x8
    x151 = x138 * x31 + x149 - x66 * (x136 * x31 - x150 * x66)
    x152 = x151 * x4
    x153 = x138 * x5
    x154 = 2.0 * x153
    x155 = x134 * x8
    x156 = x155 + x49
    x157 = x15 * x156
    x158 = x138 * x8
    x159 = x158 + x41
    x160 = x157 * x5 + x159 * x44
    x161 = x4 * x90
    x162 = x161 * x5
    x163 = x15 * (x156 * x162 + x160 * x44)
    x164 = x163 + x20 * x79
    x165 = x110 * x6
    x166 = x156 * x165
    x167 = x147 * x6
    x168 = x166 + x167 * x8
    x169 = x151 * x8
    x170 = x169 + x69
    x171 = x159 * x51
    x172 = x135 * x82
    x173 = x139 * x82 + x172
    x174 = x11 * x161
    x175 = x15 * (x135 * x174 + x173 * x44)
    x176 = x175 + x20 * x88
    x177 = x11 * x165
    x178 = x134 * x177
    x179 = x11 * x167 + x178
    x180 = x154 * x82
    x181 = x157 * x8 + x75
    x182 = x159 * x73 + x41 * x73
    x183 = x15 * (x181 * x71 + x182 * x44)
    x184 = x183 + x20 * x94
    x185 = x161 * x181
    x186 = x147 * x4
    x187 = x185 + x186 * x9
    x188 = x170 * x73 + x69 * x73
    x189 = x182 * x51
    x190 = x155 * x82 + x84
    x191 = x41 * x82
    x192 = x158 * x82 + x191
    x193 = x15 * (x190 * x71 + x192 * x44)
    x194 = x101 * x20 + x193
    x195 = x161 * x190
    x196 = x103 * x147 + x195
    x197 = x69 * x82
    x198 = x169 * x82 + x197
    x199 = x192 * x51
    x200 = x104 * x135
    x201 = x15 * (x104 * x139 + x200)
    x202 = x107 * x20 + x201
    x203 = x121 * x4
    x204 = x134 * x203
    x205 = x12 * x186 + x204
    x206 = x104 * x154
    x207 = x15 * (x182 * x73 + x41 * x91)
    x208 = x113 * x20 + x207
    x209 = x15 * (x181 * x73 + x93)
    x210 = x109 * x147 + x209
    x211 = x15 * (x192 * x73 + x41 * x98)
    x212 = x118 * x20 + x211
    x213 = x15 * (x100 + x190 * x73)
    x214 = x120 * x147 + x213
    x215 = x104 * x41
    x216 = x15 * (x104 * x158 + x215)
    x217 = x124 * x20 + x216
    x218 = x15 * (x104 * x155 + x106)
    x219 = x126 * x147 + x218
    x220 = x104 * x69
    x221 = x128 * x138
    x222 = x130 * x20 + x221
    x223 = x128 * x134
    x224 = x127 * x147 + x223
    x225 = -x10 - A[2]
    x226 = x11 * x26 - 2.0 * x19 * x2 * x22 * x225 * x27 * x28 * x29
    x227 = -x226
    x228 = x227 * x5
    x229 = -x11 * x35 + 2.0 * x17 * x19 * x2 * x22 * x225 * x27 * x28
    x230 = x229 * x37
    x231 = x227 * x31 - x230 * x4
    x232 = x231 * x4
    x233 = x228 + x232
    x234 = x228 * x44 + x233 * x44
    x235 = x15 * (x142 * x228 + x234 * x44)
    x236 = x21 * x58 + x235
    x237 = x145 * x227
    x238 = x21 * x62
    x239 = x237 + x238 * x60
    x240 = x5 * (-x226 - x230)
    x241 = -x11 * x65 + 2.0 * x19 * x2 * x22 * x225 * x27 * x28 * x34
    x242 = x231 * x31 + x240 - x66 * (x229 * x31 - x241 * x66)
    x243 = x242 * x4
    x244 = x231 * x5
    x245 = 2.0 * x244
    x246 = x228 * x73
    x247 = x232 * x73 + x246
    x248 = x161 * x8
    x249 = x15 * (x228 * x248 + x247 * x44)
    x250 = x21 * x79 + x249
    x251 = x165 * x8
    x252 = x227 * x251
    x253 = x238 * x6
    x254 = x252 + x253 * x8
    x255 = x11 * x227 + x49
    x256 = x255 * x71
    x257 = x11 * x231 + x41
    x258 = x256 + x257 * x44
    x259 = x15 * (x162 * x255 + x258 * x44)
    x260 = x21 * x88 + x259
    x261 = x165 * x255
    x262 = x11 * x253 + x261
    x263 = x11 * x242 + x69
    x264 = x257 * x51
    x265 = x228 * x91
    x266 = x15 * (x232 * x91 + x265)
    x267 = x21 * x94 + x266
    x268 = x115 * x4
    x269 = x227 * x268
    x270 = x238 * x4
    x271 = x269 + x270 * x9
    x272 = x5 * x97
    x273 = x255 * x272
    x274 = x15 * (x248 * x257 + x273)
    x275 = x101 * x21 + x274
    x276 = x110 * x78
    x277 = x255 * x276
    x278 = x103 * x238 + x277
    x279 = x255 * x82 + x84
    x280 = x279 * x71
    x281 = x191 + x257 * x82
    x282 = x15 * (x280 + x281 * x44)
    x283 = x107 * x21 + x282
    x284 = x161 * x279
    x285 = x12 * x270 + x284
    x286 = x197 + x263 * x82
    x287 = x281 * x51
    x288 = x111 * x231
    x289 = x113 * x21 + x288
    x290 = x111 * x227
    x291 = x109 * x238 + x290
    x292 = x115 * x257
    x293 = x118 * x21 + x292
    x294 = x115 * x255
    x295 = x120 * x238 + x294
    x296 = x281 * x97
    x297 = x124 * x21 + x296
    x298 = x279 * x97
    x299 = x126 * x238 + x298
    x300 = x15 * (x215 + x281 * x82)
    x301 = x130 * x21 + x300
    x302 = x15 * (x106 + x279 * x82)
    x303 = x127 * x238 + x302
    x304 = x132 * x134 - x137 * x8 + x30
    x305 = x145 * x304
    x306 = x146 * x20 + x305
    x307 = x148 * x20 + x306
    x308 = x304 * x5
    x309 = x37 * x8
    x310 = x132 * x136 - x150 * x309 + x64
    x311 = x304 * x31 - x310 * x66
    x312 = x311 * x4
    x313 = x304 * x8
    x314 = 2.0 * x135
    x315 = x313 + x314
    x316 = x165 * x315
    x317 = x166 * x20 + x316
    x318 = x168 * x20 + x317
    x319 = x315 * x71
    x320 = x311 * x8
    x321 = x154 + x320
    x322 = x177 * x304
    x323 = x178 * x20 + x322
    x324 = x179 * x20 + x323
    x325 = x308 * x82
    x326 = x157 * x46 + x315 * x73
    x327 = x161 * x326
    x328 = x185 * x20 + x327
    x329 = x187 * x20 + x328
    x330 = x326 * x71
    x331 = x171 + x321 * x73
    x332 = x313 * x82 + x314 * x82
    x333 = x161 * x332
    x334 = x195 * x20 + x333
    x335 = x196 * x20 + x334
    x336 = x332 * x71
    x337 = x180 + x320 * x82
    x338 = x203 * x304
    x339 = x20 * x204 + x338
    x340 = x20 * x205 + x339
    x341 = x104 * x308
    x342 = x15 * (x181 * x51 + x326 * x73)
    x343 = x20 * x209 + x342
    x344 = x20 * x210 + x343
    x345 = x15 * (x190 * x51 + x332 * x73)
    x346 = x20 * x213 + x345
    x347 = x20 * x214 + x346
    x348 = x15 * (x104 * x313 + x104 * x314)
    x349 = x20 * x218 + x348
    x350 = x20 * x219 + x349
    x351 = x128 * x304
    x352 = x20 * x223 + x351
    x353 = x20 * x224 + x352
    x354 = x132 * x227 - x230 * x8
    x355 = x145 * x354
    x356 = x146 * x21 + x355
    x357 = x20 * x239 + x356
    x358 = x354 * x5
    x359 = x132 * x229 - x241 * x309
    x360 = x31 * x354 - x359 * x66
    x361 = x228 + x354 * x8
    x362 = x165 * x361
    x363 = x166 * x21 + x362
    x364 = x20 * x254 + x363
    x365 = x244 + x360 * x8
    x366 = x11 * x354 + x135
    x367 = x165 * x366
    x368 = x178 * x21 + x367
    x369 = x20 * x262 + x368
    x370 = x11 * x360 + x153
    x371 = x246 + x361 * x73
    x372 = x161 * x371
    x373 = x185 * x21 + x372
    x374 = x20 * x271 + x373
    x375 = x244 * x73 + x365 * x73
    x376 = x256 + x366 * x73
    x377 = x161 * x376
    x378 = x195 * x21 + x377
    x379 = x20 * x278 + x378
    x380 = x257 * x71 + x370 * x73
    x381 = x172 + x366 * x82
    x382 = x161 * x381
    x383 = x204 * x21 + x382
    x384 = x20 * x285 + x383
    x385 = x153 * x82 + x370 * x82
    x386 = x15 * (x265 + x371 * x73)
    x387 = x209 * x21 + x386
    x388 = x20 * x291 + x387
    x389 = x15 * (x273 + x376 * x73)
    x390 = x21 * x213 + x389
    x391 = x20 * x295 + x390
    x392 = x15 * (x280 + x381 * x73)
    x393 = x21 * x218 + x392
    x394 = x20 * x299 + x393
    x395 = x15 * (x200 + x381 * x82)
    x396 = x21 * x223 + x395
    x397 = x20 * x303 + x396
    x398 = -x11 * x230 + x225 * x227 + x30
    x399 = x145 * x398
    x400 = x21 * x237 + x399
    x401 = x21 * x239 + x400
    x402 = x398 * x5
    x403 = x11 * x37
    x404 = x225 * x229 - x241 * x403 + x64
    x405 = x31 * x398 - x404 * x66
    x406 = x4 * x405
    x407 = x251 * x398
    x408 = x21 * x252 + x407
    x409 = x21 * x254 + x408
    x410 = x402 * x73
    x411 = x11 * x398 + 2.0 * x228
    x412 = x165 * x411
    x413 = x21 * x261 + x412
    x414 = x21 * x262 + x413
    x415 = x411 * x71
    x416 = x11 * x405 + x245
    x417 = x268 * x398
    x418 = x21 * x269 + x417
    x419 = x21 * x271 + x418
    x420 = x402 * x91
    x421 = x276 * x411
    x422 = x21 * x277 + x421
    x423 = x21 * x278 + x422
    x424 = x272 * x411
    x425 = x255 * x51 + x411 * x82
    x426 = x161 * x425
    x427 = x21 * x284 + x426
    x428 = x21 * x285 + x427
    x429 = x425 * x71
    x430 = x264 + x416 * x82
    x431 = x111 * x398
    x432 = x21 * x290 + x431
    x433 = x21 * x291 + x432
    x434 = x115 * x411
    x435 = x21 * x294 + x434
    x436 = x21 * x295 + x435
    x437 = x425 * x97
    x438 = x21 * x298 + x437
    x439 = x21 * x299 + x438
    x440 = x15 * (x279 * x51 + x425 * x82)
    x441 = x21 * x302 + x440
    x442 = x21 * x303 + x441
    x443 = x132 * x304 + 2.0 * x149 - x309 * x310
    x444 = x443 * x8
    x445 = 3.0 * x308
    x446 = x444 + x445
    x447 = 3.0 * x319 + x446 * x73
    x448 = x444 * x82 + x445 * x82
    x449 = x132 * x354 + x240 - x309 * x359
    x450 = 2.0 * x358
    x451 = x449 * x8 + x450
    x452 = x11 * x449 + x308
    x453 = x361 * x51 + x451 * x73
    x454 = x366 * x51
    x455 = x452 * x73 + x454
    x456 = x325 + x452 * x82
    x457 = x381 * x51
    x458 = x132 * x398 - x309 * x404
    x459 = x402 + x458 * x8
    x460 = x11 * x458 + x450
    x461 = x410 + x459 * x73
    x462 = x415 + x460 * x73
    x463 = x454 + x460 * x82
    x464 = x225 * x398 + 2.0 * x240 - x403 * x404
    x465 = x11 * x464 + 3.0 * x402
    x466 = 3.0 * x415 + x465 * x82

    # 100 item(s)
    return numpy.array(
        [
            x0 * x56
            + x0 * x59
            + x0 * (x0 * (x58 + x60 * x63) + x59)
            + x15 * (x44 * (x43 * x72 + x44 * (x68 + x70)) + x52 * x72),
            x0 * x77
            + x0 * x80
            + x0 * (x0 * (x79 + x8 * x81) + x80)
            + x15 * (x44 * (x68 * x73 + x70 * x73) + x72 * x74),
            x0 * x86
            + x0 * x89
            + x0 * (x0 * (x11 * x81 + x88) + x89)
            + x15 * (x44 * (x68 * x82 + x70 * x82) + x72 * x83),
            x0 * x92
            + x0 * x95
            + x0 * (x0 * (x9 * x96 + x94) + x95)
            + x15 * (x68 * x91 + x70 * x91),
            x0 * x102
            + x0 * x99
            + x0 * (x0 * (x101 + x103 * x63) + x102)
            + x15 * (x68 * x98 + x70 * x98),
            x0 * x105
            + x0 * x108
            + x0 * (x0 * (x107 + x12 * x96) + x108)
            + x15 * (x104 * x68 + x104 * x70),
            x0 * x112 + x0 * x114 + x0 * (x0 * (x109 * x63 + x113) + x114) + x111 * x67,
            x0 * x117 + x0 * x119 + x0 * (x0 * (x118 + x120 * x63) + x119) + x116 * x67,
            x0 * x123 + x0 * x125 + x0 * (x0 * (x124 + x126 * x63) + x125) + x122 * x67,
            x0 * x129 + x0 * x131 + x0 * (x0 * (x127 * x63 + x130) + x131) + x128 * x67,
            x0 * x144
            + x0 * (x0 * x148 + x144)
            + x15 * (x141 * x51 + x44 * (x140 * x51 + x44 * (x152 + x154)))
            + x20 * x56,
            x0 * x164
            + x0 * (x0 * x168 + x164)
            + x15 * (x160 * x51 + x44 * (x170 * x44 + x171))
            + x20 * x77,
            x0 * x176
            + x0 * (x0 * x179 + x176)
            + x15 * (x173 * x51 + x44 * (x152 * x82 + x180))
            + x20 * x86,
            x0 * x184 + x0 * (x0 * x187 + x184) + x15 * (x188 * x44 + x189) + x20 * x92,
            x0 * x194 + x0 * (x0 * x196 + x194) + x15 * (x198 * x44 + x199) + x20 * x99,
            x0 * x202 + x0 * (x0 * x205 + x202) + x105 * x20 + x15 * (x104 * x152 + x206),
            x0 * x208
            + x0 * (x0 * x210 + x208)
            + x112 * x20
            + x15 * (x188 * x73 + x69 * x91),
            x0 * x212
            + x0 * (x0 * x214 + x212)
            + x117 * x20
            + x15 * (x198 * x73 + x69 * x98),
            x0 * x217 + x0 * (x0 * x219 + x217) + x123 * x20 + x15 * (x104 * x169 + x220),
            x0 * x222 + x0 * (x0 * x224 + x222) + x128 * x151 + x129 * x20,
            x0 * x236
            + x0 * (x0 * x239 + x236)
            + x15 * (x234 * x51 + x44 * (x233 * x51 + x44 * (x243 + x245)))
            + x21 * x56,
            x0 * x250
            + x0 * (x0 * x254 + x250)
            + x15 * (x247 * x51 + x44 * (x243 * x73 + x245 * x73))
            + x21 * x77,
            x0 * x260
            + x0 * (x0 * x262 + x260)
            + x15 * (x258 * x51 + x44 * (x263 * x44 + x264))
            + x21 * x86,
            x0 * x267
            + x0 * (x0 * x271 + x267)
            + x15 * (x243 * x91 + x245 * x91)
            + x21 * x92,
            x0 * x275
            + x0 * (x0 * x278 + x275)
            + x15 * (x248 * x263 + x257 * x46 * x97)
            + x21 * x99,
            x0 * x283 + x0 * (x0 * x285 + x283) + x105 * x21 + x15 * (x286 * x44 + x287),
            x0 * x289 + x0 * (x0 * x291 + x289) + x111 * x242 + x112 * x21,
            x0 * x293 + x0 * (x0 * x295 + x293) + x115 * x263 + x117 * x21,
            x0 * x297 + x0 * (x0 * x299 + x297) + x123 * x21 + x286 * x97,
            x0 * x301 + x0 * (x0 * x303 + x301) + x129 * x21 + x15 * (x220 + x286 * x82),
            x0 * x307
            + x143 * x20
            + x144 * x20
            + x15 * (x142 * x308 + x44 * (x308 * x44 + x44 * (x308 + x312))),
            x0 * x318
            + x15 * (x162 * x315 + x44 * (x319 + x321 * x44))
            + x163 * x20
            + x164 * x20,
            x0 * x324
            + x15 * (x174 * x308 + x44 * (x312 * x82 + x325))
            + x175 * x20
            + x176 * x20,
            x0 * x329 + x15 * (x330 + x331 * x44) + x183 * x20 + x184 * x20,
            x0 * x335 + x15 * (x336 + x337 * x44) + x193 * x20 + x194 * x20,
            x0 * x340 + x15 * (x104 * x312 + x341) + x20 * x201 + x20 * x202,
            x0 * x344 + x15 * (x189 + x331 * x73) + x20 * x207 + x20 * x208,
            x0 * x347 + x15 * (x199 + x337 * x73) + x20 * x211 + x20 * x212,
            x0 * x350 + x15 * (x104 * x320 + x206) + x20 * x216 + x20 * x217,
            x0 * x353 + x128 * x311 + x20 * x221 + x20 * x222,
            x0 * x357
            + x143 * x21
            + x15 * (x142 * x358 + x44 * (x358 * x44 + x44 * (x358 + x360 * x4)))
            + x20 * x236,
            x0 * x364
            + x15 * (x162 * x361 + x44 * (x361 * x71 + x365 * x44))
            + x163 * x21
            + x20 * x250,
            x0 * x369
            + x15 * (x162 * x366 + x44 * (x366 * x71 + x370 * x44))
            + x175 * x21
            + x20 * x260,
            x0 * x374 + x15 * (x371 * x71 + x375 * x44) + x183 * x21 + x20 * x267,
            x0 * x379 + x15 * (x376 * x71 + x380 * x44) + x193 * x21 + x20 * x275,
            x0 * x384 + x15 * (x381 * x71 + x385 * x44) + x20 * x283 + x201 * x21,
            x0 * x388 + x15 * (x244 * x91 + x375 * x73) + x20 * x289 + x207 * x21,
            x0 * x391 + x15 * (x257 * x272 + x380 * x73) + x20 * x293 + x21 * x211,
            x0 * x394 + x15 * (x281 * x71 + x385 * x73) + x20 * x297 + x21 * x216,
            x0 * x397 + x15 * (x104 * x153 + x385 * x82) + x20 * x301 + x21 * x221,
            x0 * x401
            + x15 * (x142 * x402 + x44 * (x402 * x44 + x44 * (x402 + x406)))
            + x21 * x235
            + x21 * x236,
            x0 * x409
            + x15 * (x248 * x402 + x44 * (x406 * x73 + x410))
            + x21 * x249
            + x21 * x250,
            x0 * x414
            + x15 * (x162 * x411 + x44 * (x415 + x416 * x44))
            + x21 * x259
            + x21 * x260,
            x0 * x419 + x15 * (x406 * x91 + x420) + x21 * x266 + x21 * x267,
            x0 * x423 + x15 * (x248 * x416 + x424) + x21 * x274 + x21 * x275,
            x0 * x428 + x15 * (x429 + x430 * x44) + x21 * x282 + x21 * x283,
            x0 * x433 + x111 * x405 + x21 * x288 + x21 * x289,
            x0 * x436 + x115 * x416 + x21 * x292 + x21 * x293,
            x0 * x439 + x21 * x296 + x21 * x297 + x430 * x97,
            x0 * x442 + x15 * (x287 + x430 * x82) + x21 * x300 + x21 * x301,
            x145 * x443 + x20 * x305 + x20 * x306 + x20 * x307,
            x165 * x446 + x20 * x316 + x20 * x317 + x20 * x318,
            x177 * x443 + x20 * x322 + x20 * x323 + x20 * x324,
            x161 * x447 + x20 * x327 + x20 * x328 + x20 * x329,
            x161 * x448 + x20 * x333 + x20 * x334 + x20 * x335,
            x20 * x338 + x20 * x339 + x20 * x340 + x203 * x443,
            x15 * (3.0 * x330 + x447 * x73) + x20 * x342 + x20 * x343 + x20 * x344,
            x15 * (3.0 * x336 + x448 * x73) + x20 * x345 + x20 * x346 + x20 * x347,
            x15 * (x104 * x444 + x104 * x445) + x20 * x348 + x20 * x349 + x20 * x350,
            x128 * x443 + x20 * x351 + x20 * x352 + x20 * x353,
            x145 * x449 + x20 * x356 + x20 * x357 + x21 * x305,
            x165 * x451 + x20 * x363 + x20 * x364 + x21 * x316,
            x165 * x452 + x20 * x368 + x20 * x369 + x21 * x322,
            x161 * x453 + x20 * x373 + x20 * x374 + x21 * x327,
            x161 * x455 + x20 * x378 + x20 * x379 + x21 * x333,
            x161 * x456 + x20 * x383 + x20 * x384 + x21 * x338,
            x15 * (x371 * x51 + x453 * x73) + x20 * x387 + x20 * x388 + x21 * x342,
            x15 * (x376 * x51 + x455 * x73) + x20 * x390 + x20 * x391 + x21 * x345,
            x15 * (x456 * x73 + x457) + x20 * x393 + x20 * x394 + x21 * x348,
            x15 * (x341 + x456 * x82) + x20 * x396 + x20 * x397 + x21 * x351,
            x145 * x458 + x20 * x401 + x21 * x355 + x21 * x356,
            x165 * x459 + x20 * x409 + x21 * x362 + x21 * x363,
            x165 * x460 + x20 * x414 + x21 * x367 + x21 * x368,
            x161 * x461 + x20 * x419 + x21 * x372 + x21 * x373,
            x161 * x462 + x20 * x423 + x21 * x377 + x21 * x378,
            x161 * x463 + x20 * x428 + x21 * x382 + x21 * x383,
            x15 * (x420 + x461 * x73) + x20 * x433 + x21 * x386 + x21 * x387,
            x15 * (x424 + x462 * x73) + x20 * x436 + x21 * x389 + x21 * x390,
            x15 * (x429 + x463 * x73) + x20 * x439 + x21 * x392 + x21 * x393,
            x15 * (x457 + x463 * x82) + x20 * x442 + x21 * x395 + x21 * x396,
            x145 * x464 + x21 * x399 + x21 * x400 + x21 * x401,
            x21 * x407 + x21 * x408 + x21 * x409 + x251 * x464,
            x165 * x465 + x21 * x412 + x21 * x413 + x21 * x414,
            x21 * x417 + x21 * x418 + x21 * x419 + x268 * x464,
            x21 * x421 + x21 * x422 + x21 * x423 + x276 * x465,
            x161 * x466 + x21 * x426 + x21 * x427 + x21 * x428,
            x111 * x464 + x21 * x431 + x21 * x432 + x21 * x433,
            x115 * x465 + x21 * x434 + x21 * x435 + x21 * x436,
            x21 * x437 + x21 * x438 + x21 * x439 + x466 * x97,
            x15 * (3.0 * x429 + x466 * x82) + x21 * x440 + x21 * x441 + x21 * x442,
        ]
    )


def _3center2el3d_sph_034(a, A, b, B, c, C):
    """Cartesian (sf|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(5, x16)
    x18 = x13 ** (-1.5)
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x22
    x24 = x2 * x23
    x25 = 2.0 * x18 * x24
    x26 = x17 * x25
    x27 = c ** (-1.0)
    x28 = x13 ** (-0.5)
    x29 = boys(4, x16)
    x30 = x5 * (2.0 * x19 * x2 * x22 * x27 * x28 * x29 - x26)
    x31 = -x3 - A[0]
    x32 = -2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x31 + x26 * x4
    x33 = -x32
    x34 = boys(6, x16)
    x35 = x25 * x34
    x36 = 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x31 - x35 * x4
    x37 = c * x14
    x38 = x36 * x37
    x39 = x30 + x31 * x33 - x38 * x4
    x40 = x39 * x4
    x41 = x33 * x5
    x42 = 2.0 * x41
    x43 = x40 + x42
    x44 = x15 * x4
    x45 = x33 * x4
    x46 = 2.0 * x5
    x47 = x27 * x29
    x48 = x46 * x47
    x49 = x24 * x28 * x48
    x50 = x45 + x49
    x51 = x15 * x46
    x52 = x43 * x44 + x50 * x51
    x53 = x23 * x48
    x54 = x18 * x53
    x55 = x4 * x54 + x44 * x50
    x56 = x44 * x52 + x51 * x55
    x57 = x53 * x6
    x58 = x1 * x13 ** (-2.5)
    x59 = x44 * x55 + x57 * x58
    x60 = x15 * (x44 * x56 + x51 * x59)
    x61 = x4**3
    x62 = x1**2
    x63 = x13 ** (-3.5) * x62
    x64 = x53 * x63
    x65 = x15 * (x44 * x59 + x61 * x64)
    x66 = x0 * x65 + x60
    x67 = x4**4
    x68 = x1**3
    x69 = 2.0 * x13 ** (-4.5) * x23 * x47 * x68
    x70 = x0 * x69
    x71 = x5 * (2.0 * x17 * x19 * x2 * x22 * x27 * x28 - x35)
    x72 = x25 * boys(7, x16)
    x73 = x37 * x4
    x74 = (
        x31 * x39
        + x46 * (-x32 - x38)
        - x73
        * (
            x31 * x36
            + x71
            - x73 * (2.0 * x19 * x2 * x22 * x27 * x28 * x31 * x34 - x4 * x72)
        )
    )
    x75 = x4 * x74
    x76 = x39 * x5
    x77 = 3.0 * x76
    x78 = x15 * x5
    x79 = 3.0 * x78
    x80 = x15 * x8
    x81 = x40 * x80 + x42 * x80
    x82 = x54 * x8
    x83 = x45 * x80 + x82
    x84 = x44 * x81 + x51 * x83
    x85 = x53 * x58
    x86 = x4 * x85
    x87 = x44 * x83 + x8 * x86
    x88 = x15 * (x44 * x84 + x51 * x87)
    x89 = x57 * x63
    x90 = x15 * (x44 * x87 + x8 * x89)
    x91 = x0 * x90 + x88
    x92 = x61 * x70
    x93 = x11 * x15
    x94 = x40 * x93 + x42 * x93
    x95 = x11 * x54
    x96 = x45 * x93 + x95
    x97 = x44 * x94 + x51 * x96
    x98 = x11 * x86 + x44 * x96
    x99 = x15 * (x44 * x97 + x51 * x98)
    x100 = x15 * (x11 * x89 + x44 * x98)
    x101 = x0 * x100 + x99
    x102 = x62 / x13**2
    x103 = x102 * x9
    x104 = x103 * x40 + x103 * x42
    x105 = x85 * x9
    x106 = x103 * x45 + x105
    x107 = x15 * (x104 * x44 + x106 * x51)
    x108 = x4 * x9
    x109 = x15 * (x106 * x44 + x108 * x64)
    x110 = x0 * x109 + x107
    x111 = x6 * x9
    x112 = x102 * x8
    x113 = x11 * x112
    x114 = x113 * x40 + x113 * x42
    x115 = x11 * x8
    x116 = x115 * x85
    x117 = x113 * x45 + x116
    x118 = x15 * (x114 * x44 + x117 * x51)
    x119 = x15 * (x115 * x4 * x64 + x117 * x44)
    x120 = x0 * x119 + x118
    x121 = x115 * x6
    x122 = x102 * x12
    x123 = x122 * x40 + x122 * x42
    x124 = x12 * x85
    x125 = x122 * x45 + x124
    x126 = x15 * (x123 * x44 + x125 * x51)
    x127 = x12 * x4
    x128 = x15 * (x125 * x44 + x127 * x64)
    x129 = x0 * x128 + x126
    x130 = x12 * x6
    x131 = x8**3
    x132 = x68 / x13**3
    x133 = x131 * x132
    x134 = x15 * (x133 * x40 + x133 * x42)
    x135 = x131 * x64
    x136 = x15 * (x133 * x45 + x135)
    x137 = x0 * x136 + x134
    x138 = x131 * x70
    x139 = x132 * x9
    x140 = x11 * x139
    x141 = x15 * (x140 * x40 + x140 * x42)
    x142 = x11 * x64 * x9
    x143 = x15 * (x140 * x45 + x142)
    x144 = x0 * x143 + x141
    x145 = x108 * x11
    x146 = x132 * x8
    x147 = x12 * x146
    x148 = x15 * (x147 * x40 + x147 * x42)
    x149 = x12 * x64 * x8
    x150 = x15 * (x147 * x45 + x149)
    x151 = x0 * x150 + x148
    x152 = x127 * x8
    x153 = x11**3
    x154 = x132 * x153
    x155 = x15 * (x154 * x40 + x154 * x42)
    x156 = x153 * x64
    x157 = x15 * (x154 * x45 + x156)
    x158 = x0 * x157 + x155
    x159 = x153 * x4
    x160 = x8**4
    x161 = x1**4 / x13**4
    x162 = x160 * x161
    x163 = x162 * x39
    x164 = x162 * x33
    x165 = x0 * x164 + x163
    x166 = x131 * x161
    x167 = x11 * x166
    x168 = x167 * x39
    x169 = x167 * x33
    x170 = x0 * x169 + x168
    x171 = x161 * x39
    x172 = x12 * x9
    x173 = x171 * x172
    x174 = x161 * x172
    x175 = x174 * x33
    x176 = x0 * x175 + x173
    x177 = x153 * x8
    x178 = x171 * x177
    x179 = x161 * x177
    x180 = x179 * x33
    x181 = x0 * x180 + x178
    x182 = x11**4
    x183 = x161 * x182
    x184 = x183 * x39
    x185 = x183 * x33
    x186 = x0 * x185 + x184
    x187 = -x7 - A[1]
    x188 = -2.0 * x187 * x19 * x2 * x22 * x27 * x28 * x29 + x26 * x8
    x189 = -x188
    x190 = x189 * x5
    x191 = 2.0 * x17 * x187 * x19 * x2 * x22 * x27 * x28 - x35 * x8
    x192 = x191 * x37
    x193 = x189 * x31 - x192 * x4
    x194 = x193 * x4
    x195 = x190 + x194
    x196 = x190 * x44 + x195 * x44
    x197 = x102 * x6
    x198 = x190 * x197 + x196 * x44
    x199 = x132 * x61
    x200 = x15 * (x190 * x199 + x198 * x44)
    x201 = x20 * x65 + x200
    x202 = x161 * x67
    x203 = x189 * x202
    x204 = x20 * x69
    x205 = x203 + x204 * x67
    x206 = x5 * (-x188 - x192)
    x207 = 2.0 * x187 * x19 * x2 * x22 * x27 * x28 * x34 - x72 * x8
    x208 = x193 * x31 + x206 - x73 * (x191 * x31 - x207 * x73)
    x209 = x208 * x4
    x210 = x193 * x5
    x211 = 2.0 * x210
    x212 = x189 * x8
    x213 = x212 + x49
    x214 = x15 * x213
    x215 = x193 * x8
    x216 = x215 + x41
    x217 = x214 * x5 + x216 * x44
    x218 = x102 * x4
    x219 = x213 * x5
    x220 = x217 * x44 + x218 * x219
    x221 = x132 * x6
    x222 = x15 * (x219 * x221 + x220 * x44)
    x223 = x20 * x90 + x222
    x224 = x161 * x61
    x225 = x213 * x224
    x226 = x204 * x61
    x227 = x225 + x226 * x8
    x228 = x208 * x8
    x229 = x228 + x76
    x230 = x216 * x51
    x231 = x190 * x93
    x232 = x194 * x93 + x231
    x233 = x11 * x190
    x234 = x218 * x233 + x232 * x44
    x235 = x15 * (x221 * x233 + x234 * x44)
    x236 = x100 * x20 + x235
    x237 = x11 * x224
    x238 = x189 * x237
    x239 = x11 * x226 + x238
    x240 = x211 * x93
    x241 = x214 * x8 + x82
    x242 = x216 * x80 + x41 * x80
    x243 = x241 * x78 + x242 * x44
    x244 = x218 * x5
    x245 = x15 * (x241 * x244 + x243 * x44)
    x246 = x109 * x20 + x245
    x247 = x221 * x241
    x248 = x111 * x204 + x247
    x249 = x229 * x80 + x76 * x80
    x250 = x242 * x51
    x251 = x212 * x93 + x95
    x252 = x41 * x93
    x253 = x215 * x93 + x252
    x254 = x251 * x78 + x253 * x44
    x255 = x15 * (x244 * x251 + x254 * x44)
    x256 = x119 * x20 + x255
    x257 = x221 * x251
    x258 = x121 * x204 + x257
    x259 = x76 * x93
    x260 = x228 * x93 + x259
    x261 = x253 * x51
    x262 = x122 * x190
    x263 = x122 * x194 + x262
    x264 = x127 * x132
    x265 = x15 * (x190 * x264 + x263 * x44)
    x266 = x128 * x20 + x265
    x267 = x161 * x189
    x268 = x130 * x267
    x269 = x130 * x204 + x268
    x270 = x122 * x211
    x271 = x105 + x241 * x80
    x272 = x103 * x41 + x242 * x80
    x273 = x15 * (x271 * x78 + x272 * x44)
    x274 = x136 * x20 + x273
    x275 = x218 * x271
    x276 = x131 * x204
    x277 = x275 + x276 * x4
    x278 = x103 * x76 + x249 * x80
    x279 = x272 * x51
    x280 = x116 + x251 * x80
    x281 = x113 * x41 + x253 * x80
    x282 = x15 * (x280 * x78 + x281 * x44)
    x283 = x143 * x20 + x282
    x284 = x218 * x280
    x285 = x145 * x204 + x284
    x286 = x113 * x76 + x260 * x80
    x287 = x281 * x51
    x288 = x122 * x212 + x124
    x289 = x122 * x41
    x290 = x122 * x215 + x289
    x291 = x15 * (x288 * x78 + x290 * x44)
    x292 = x150 * x20 + x291
    x293 = x218 * x288
    x294 = x152 * x204 + x293
    x295 = x122 * x76
    x296 = x122 * x228 + x295
    x297 = x290 * x51
    x298 = x154 * x190
    x299 = x15 * (x154 * x194 + x298)
    x300 = x157 * x20 + x299
    x301 = x159 * x267
    x302 = x159 * x204 + x301
    x303 = x154 * x211
    x304 = x15 * (x133 * x41 + x272 * x80)
    x305 = x164 * x20 + x304
    x306 = x15 * (x135 + x271 * x80)
    x307 = x160 * x204 + x306
    x308 = x15 * (x140 * x41 + x281 * x80)
    x309 = x169 * x20 + x308
    x310 = x15 * (x142 + x280 * x80)
    x311 = x11 * x276 + x310
    x312 = x15 * (x147 * x41 + x290 * x80)
    x313 = x175 * x20 + x312
    x314 = x15 * (x149 + x288 * x80)
    x315 = x172 * x204 + x314
    x316 = x154 * x41
    x317 = x15 * (x154 * x215 + x316)
    x318 = x180 * x20 + x317
    x319 = x15 * (x154 * x212 + x156)
    x320 = x177 * x204 + x319
    x321 = x154 * x76
    x322 = x183 * x193
    x323 = x185 * x20 + x322
    x324 = x183 * x189
    x325 = x182 * x204 + x324
    x326 = -x10 - A[2]
    x327 = x11 * x26 - 2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x326
    x328 = -x327
    x329 = x328 * x5
    x330 = -x11 * x35 + 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x326
    x331 = x330 * x37
    x332 = x31 * x328 - x331 * x4
    x333 = x332 * x4
    x334 = x329 + x333
    x335 = x329 * x44 + x334 * x44
    x336 = x197 * x329 + x335 * x44
    x337 = x15 * (x199 * x329 + x336 * x44)
    x338 = x21 * x65 + x337
    x339 = x202 * x328
    x340 = x21 * x69
    x341 = x339 + x340 * x67
    x342 = x5 * (-x327 - x331)
    x343 = -x11 * x72 + 2.0 * x19 * x2 * x22 * x27 * x28 * x326 * x34
    x344 = x31 * x332 + x342 - x73 * (x31 * x330 - x343 * x73)
    x345 = x344 * x4
    x346 = x332 * x5
    x347 = 2.0 * x346
    x348 = x329 * x80
    x349 = x333 * x80 + x348
    x350 = x218 * x8
    x351 = x329 * x350 + x349 * x44
    x352 = x221 * x8
    x353 = x15 * (x329 * x352 + x351 * x44)
    x354 = x21 * x90 + x353
    x355 = x224 * x8
    x356 = x328 * x355
    x357 = x340 * x61
    x358 = x356 + x357 * x8
    x359 = x11 * x328 + x49
    x360 = x359 * x78
    x361 = x11 * x332 + x41
    x362 = x360 + x361 * x44
    x363 = x244 * x359 + x362 * x44
    x364 = x359 * x5
    x365 = x15 * (x221 * x364 + x363 * x44)
    x366 = x100 * x21 + x365
    x367 = x224 * x359
    x368 = x11 * x357 + x367
    x369 = x11 * x344 + x76
    x370 = x361 * x51
    x371 = x103 * x329
    x372 = x103 * x333 + x371
    x373 = x139 * x4
    x374 = x15 * (x329 * x373 + x372 * x44)
    x375 = x109 * x21 + x374
    x376 = x161 * x6
    x377 = x376 * x9
    x378 = x328 * x377
    x379 = x111 * x340 + x378
    x380 = x112 * x364
    x381 = x350 * x361 + x380
    x382 = x146 * x4
    x383 = x15 * (x364 * x382 + x381 * x44)
    x384 = x119 * x21 + x383
    x385 = x376 * x8
    x386 = x359 * x385
    x387 = x121 * x340 + x386
    x388 = x361 * x46
    x389 = x359 * x93 + x95
    x390 = x389 * x78
    x391 = x252 + x361 * x93
    x392 = x390 + x391 * x44
    x393 = x15 * (x244 * x389 + x392 * x44)
    x394 = x128 * x21 + x393
    x395 = x221 * x389
    x396 = x130 * x340 + x395
    x397 = x259 + x369 * x93
    x398 = x391 * x51
    x399 = x133 * x329
    x400 = x15 * (x133 * x333 + x399)
    x401 = x136 * x21 + x400
    x402 = x166 * x4
    x403 = x328 * x402
    x404 = x131 * x340
    x405 = x4 * x404 + x403
    x406 = x139 * x364
    x407 = x15 * (x361 * x373 + x406)
    x408 = x143 * x21 + x407
    x409 = x108 * x161
    x410 = x359 * x409
    x411 = x145 * x340 + x410
    x412 = x112 * x5
    x413 = x389 * x412
    x414 = x15 * (x350 * x391 + x413)
    x415 = x150 * x21 + x414
    x416 = x382 * x389
    x417 = x152 * x340 + x416
    x418 = x124 + x389 * x93
    x419 = x418 * x78
    x420 = x289 + x391 * x93
    x421 = x15 * (x419 + x420 * x44)
    x422 = x157 * x21 + x421
    x423 = x218 * x418
    x424 = x159 * x340 + x423
    x425 = x295 + x397 * x93
    x426 = x420 * x51
    x427 = x162 * x332
    x428 = x164 * x21 + x427
    x429 = x162 * x328
    x430 = x160 * x340 + x429
    x431 = x166 * x361
    x432 = x169 * x21 + x431
    x433 = x166 * x359
    x434 = x11 * x404 + x433
    x435 = x139 * x391
    x436 = x175 * x21 + x435
    x437 = x139 * x389
    x438 = x172 * x340 + x437
    x439 = x112 * x420
    x440 = x180 * x21 + x439
    x441 = x112 * x418
    x442 = x177 * x340 + x441
    x443 = x15 * (x316 + x420 * x93)
    x444 = x185 * x21 + x443
    x445 = x15 * (x156 + x418 * x93)
    x446 = x182 * x340 + x445
    x447 = x187 * x189 - x192 * x8 + x30
    x448 = x202 * x447
    x449 = x20 * x203 + x448
    x450 = x20 * x205 + x449
    x451 = x447 * x5
    x452 = x37 * x8
    x453 = x187 * x191 - x207 * x452 + x71
    x454 = x31 * x447 - x453 * x73
    x455 = x4 * x454
    x456 = x447 * x8
    x457 = 2.0 * x190
    x458 = x456 + x457
    x459 = x224 * x458
    x460 = x20 * x225 + x459
    x461 = x20 * x227 + x460
    x462 = x458 * x78
    x463 = x454 * x8
    x464 = x211 + x463
    x465 = x221 * x5
    x466 = x237 * x447
    x467 = x20 * x238 + x466
    x468 = x20 * x239 + x467
    x469 = x451 * x93
    x470 = x11 * x451
    x471 = x214 * x46 + x458 * x80
    x472 = x221 * x471
    x473 = x20 * x247 + x472
    x474 = x20 * x248 + x473
    x475 = x471 * x78
    x476 = x230 + x464 * x80
    x477 = x456 * x93 + x457 * x93
    x478 = x221 * x477
    x479 = x20 * x257 + x478
    x480 = x20 * x258 + x479
    x481 = x477 * x78
    x482 = x240 + x463 * x93
    x483 = x161 * x447
    x484 = x130 * x483
    x485 = x20 * x268 + x484
    x486 = x20 * x269 + x485
    x487 = x122 * x451
    x488 = x241 * x51 + x471 * x80
    x489 = x218 * x488
    x490 = x20 * x275 + x489
    x491 = x20 * x277 + x490
    x492 = x488 * x78
    x493 = x250 + x476 * x80
    x494 = x251 * x51 + x477 * x80
    x495 = x218 * x494
    x496 = x20 * x284 + x495
    x497 = x20 * x285 + x496
    x498 = x494 * x78
    x499 = x261 + x482 * x80
    x500 = x122 * x456 + x122 * x457
    x501 = x218 * x500
    x502 = x20 * x293 + x501
    x503 = x20 * x294 + x502
    x504 = x500 * x78
    x505 = x122 * x463 + x270
    x506 = x159 * x483
    x507 = x20 * x301 + x506
    x508 = x20 * x302 + x507
    x509 = x154 * x451
    x510 = x15 * (x271 * x51 + x488 * x80)
    x511 = x20 * x306 + x510
    x512 = x20 * x307 + x511
    x513 = x15 * (x280 * x51 + x494 * x80)
    x514 = x20 * x310 + x513
    x515 = x20 * x311 + x514
    x516 = x15 * (x288 * x51 + x500 * x80)
    x517 = x20 * x314 + x516
    x518 = x20 * x315 + x517
    x519 = x15 * (x154 * x456 + x154 * x457)
    x520 = x20 * x319 + x519
    x521 = x20 * x320 + x520
    x522 = x183 * x447
    x523 = x20 * x324 + x522
    x524 = x20 * x325 + x523
    x525 = x187 * x328 - x331 * x8
    x526 = x202 * x525
    x527 = x203 * x21 + x526
    x528 = x20 * x341 + x527
    x529 = x5 * x525
    x530 = x187 * x330 - x343 * x452
    x531 = x31 * x525 - x530 * x73
    x532 = x329 + x525 * x8
    x533 = x224 * x532
    x534 = x21 * x225 + x533
    x535 = x20 * x358 + x534
    x536 = x346 + x531 * x8
    x537 = x11 * x525 + x190
    x538 = x224 * x537
    x539 = x21 * x238 + x538
    x540 = x20 * x368 + x539
    x541 = x11 * x531 + x210
    x542 = x348 + x532 * x80
    x543 = x221 * x542
    x544 = x21 * x247 + x543
    x545 = x20 * x379 + x544
    x546 = x346 * x80 + x536 * x80
    x547 = x360 + x537 * x80
    x548 = x221 * x547
    x549 = x21 * x257 + x548
    x550 = x20 * x387 + x549
    x551 = x361 * x78 + x541 * x80
    x552 = x231 + x537 * x93
    x553 = x221 * x552
    x554 = x21 * x268 + x553
    x555 = x20 * x396 + x554
    x556 = x210 * x93 + x541 * x93
    x557 = x371 + x542 * x80
    x558 = x218 * x557
    x559 = x21 * x275 + x558
    x560 = x20 * x405 + x559
    x561 = x103 * x346 + x546 * x80
    x562 = x380 + x547 * x80
    x563 = x218 * x562
    x564 = x21 * x284 + x563
    x565 = x20 * x411 + x564
    x566 = x361 * x412 + x551 * x80
    x567 = x390 + x552 * x80
    x568 = x218 * x567
    x569 = x21 * x293 + x568
    x570 = x20 * x417 + x569
    x571 = x391 * x78 + x556 * x80
    x572 = x262 + x552 * x93
    x573 = x218 * x572
    x574 = x21 * x301 + x573
    x575 = x20 * x424 + x574
    x576 = x122 * x210 + x556 * x93
    x577 = x15 * (x399 + x557 * x80)
    x578 = x21 * x306 + x577
    x579 = x20 * x430 + x578
    x580 = x15 * (x406 + x562 * x80)
    x581 = x21 * x310 + x580
    x582 = x20 * x434 + x581
    x583 = x139 * x5
    x584 = x15 * (x413 + x567 * x80)
    x585 = x21 * x314 + x584
    x586 = x20 * x438 + x585
    x587 = x15 * (x419 + x572 * x80)
    x588 = x21 * x319 + x587
    x589 = x20 * x442 + x588
    x590 = x15 * (x298 + x572 * x93)
    x591 = x21 * x324 + x590
    x592 = x20 * x446 + x591
    x593 = -x11 * x331 + x30 + x326 * x328
    x594 = x202 * x593
    x595 = x21 * x339 + x594
    x596 = x21 * x341 + x595
    x597 = x5 * x593
    x598 = x11 * x37
    x599 = x326 * x330 - x343 * x598 + x71
    x600 = x31 * x593 - x599 * x73
    x601 = x4 * x600
    x602 = x355 * x593
    x603 = x21 * x356 + x602
    x604 = x21 * x358 + x603
    x605 = x597 * x80
    x606 = x11 * x593 + 2.0 * x329
    x607 = x224 * x606
    x608 = x21 * x367 + x607
    x609 = x21 * x368 + x608
    x610 = x606 * x78
    x611 = x11 * x600 + x347
    x612 = x377 * x593
    x613 = x21 * x378 + x612
    x614 = x21 * x379 + x613
    x615 = x103 * x597
    x616 = x385 * x606
    x617 = x21 * x386 + x616
    x618 = x21 * x387 + x617
    x619 = x412 * x606
    x620 = x359 * x51 + x606 * x93
    x621 = x221 * x620
    x622 = x21 * x395 + x621
    x623 = x21 * x396 + x622
    x624 = x620 * x78
    x625 = x370 + x611 * x93
    x626 = x402 * x593
    x627 = x21 * x403 + x626
    x628 = x21 * x405 + x627
    x629 = x133 * x597
    x630 = x409 * x606
    x631 = x21 * x410 + x630
    x632 = x21 * x411 + x631
    x633 = x583 * x606
    x634 = x382 * x620
    x635 = x21 * x416 + x634
    x636 = x21 * x417 + x635
    x637 = x412 * x620
    x638 = x389 * x51 + x620 * x93
    x639 = x218 * x638
    x640 = x21 * x423 + x639
    x641 = x21 * x424 + x640
    x642 = x638 * x78
    x643 = x398 + x625 * x93
    x644 = x162 * x593
    x645 = x21 * x429 + x644
    x646 = x21 * x430 + x645
    x647 = x166 * x606
    x648 = x21 * x433 + x647
    x649 = x21 * x434 + x648
    x650 = x139 * x620
    x651 = x21 * x437 + x650
    x652 = x21 * x438 + x651
    x653 = x112 * x638
    x654 = x21 * x441 + x653
    x655 = x21 * x442 + x654
    x656 = x15 * (x418 * x51 + x638 * x93)
    x657 = x21 * x445 + x656
    x658 = x21 * x446 + x657
    x659 = x187 * x447 + 2.0 * x206 - x452 * x453
    x660 = x659 * x8
    x661 = 3.0 * x451
    x662 = x660 + x661
    x663 = 3.0 * x462 + x662 * x80
    x664 = x660 * x93 + x661 * x93
    x665 = x161 * x659
    x666 = 3.0 * x475 + x663 * x80
    x667 = 3.0 * x481 + x664 * x80
    x668 = x122 * x660 + x122 * x661
    x669 = x187 * x525 + x342 - x452 * x530
    x670 = 2.0 * x529
    x671 = x669 * x8 + x670
    x672 = x11 * x669 + x451
    x673 = x51 * x532 + x671 * x80
    x674 = x51 * x537
    x675 = x672 * x80 + x674
    x676 = x469 + x672 * x93
    x677 = x51 * x542 + x673 * x80
    x678 = x51 * x547 + x675 * x80
    x679 = x51 * x552
    x680 = x676 * x80 + x679
    x681 = x487 + x676 * x93
    x682 = x51 * x572
    x683 = x187 * x593 - x452 * x599
    x684 = x597 + x683 * x8
    x685 = x11 * x683 + x670
    x686 = x605 + x684 * x80
    x687 = x610 + x685 * x80
    x688 = x674 + x685 * x93
    x689 = x615 + x686 * x80
    x690 = x619 + x687 * x80
    x691 = x624 + x688 * x80
    x692 = x679 + x688 * x93
    x693 = x326 * x593 + 2.0 * x342 - x598 * x599
    x694 = x11 * x693 + 3.0 * x597
    x695 = 3.0 * x610 + x694 * x93
    x696 = 3.0 * x624 + x695 * x93

    # 150 item(s)
    return numpy.array(
        [
            x0 * x60
            + x0 * x66
            + x0 * (x0 * (x65 + x67 * x70) + x66)
            + x15
            * (x44 * (x44 * (x43 * x79 + x44 * (x75 + x77)) + x52 * x79) + x56 * x79),
            x0 * x88
            + x0 * x91
            + x0 * (x0 * (x8 * x92 + x90) + x91)
            + x15 * (x44 * (x44 * (x75 * x80 + x77 * x80) + x79 * x81) + x79 * x84),
            x0 * x101
            + x0 * x99
            + x0 * (x0 * (x100 + x11 * x92) + x101)
            + x15 * (x44 * (x44 * (x75 * x93 + x77 * x93) + x79 * x94) + x79 * x97),
            x0 * x107
            + x0 * x110
            + x0 * (x0 * (x109 + x111 * x70) + x110)
            + x15 * (x104 * x79 + x44 * (x103 * x75 + x103 * x77)),
            x0 * x118
            + x0 * x120
            + x0 * (x0 * (x119 + x121 * x70) + x120)
            + x15 * (x114 * x79 + x44 * (x113 * x75 + x113 * x77)),
            x0 * x126
            + x0 * x129
            + x0 * (x0 * (x128 + x130 * x70) + x129)
            + x15 * (x123 * x79 + x44 * (x122 * x75 + x122 * x77)),
            x0 * x134
            + x0 * x137
            + x0 * (x0 * (x136 + x138 * x4) + x137)
            + x15 * (x133 * x75 + x133 * x77),
            x0 * x141
            + x0 * x144
            + x0 * (x0 * (x143 + x145 * x70) + x144)
            + x15 * (x140 * x75 + x140 * x77),
            x0 * x148
            + x0 * x151
            + x0 * (x0 * (x150 + x152 * x70) + x151)
            + x15 * (x147 * x75 + x147 * x77),
            x0 * x155
            + x0 * x158
            + x0 * (x0 * (x157 + x159 * x70) + x158)
            + x15 * (x154 * x75 + x154 * x77),
            x0 * x163 + x0 * x165 + x0 * (x0 * (x160 * x70 + x164) + x165) + x162 * x74,
            x0 * x168 + x0 * x170 + x0 * (x0 * (x11 * x138 + x169) + x170) + x167 * x74,
            x0 * x173 + x0 * x176 + x0 * (x0 * (x172 * x70 + x175) + x176) + x174 * x74,
            x0 * x178 + x0 * x181 + x0 * (x0 * (x177 * x70 + x180) + x181) + x179 * x74,
            x0 * x184 + x0 * x186 + x0 * (x0 * (x182 * x70 + x185) + x186) + x183 * x74,
            x0 * x201
            + x0 * (x0 * x205 + x201)
            + x15
            * (x198 * x51 + x44 * (x196 * x51 + x44 * (x195 * x51 + x44 * (x209 + x211))))
            + x20 * x60,
            x0 * x223
            + x0 * (x0 * x227 + x223)
            + x15 * (x220 * x51 + x44 * (x217 * x51 + x44 * (x229 * x44 + x230)))
            + x20 * x88,
            x0 * x236
            + x0 * (x0 * x239 + x236)
            + x15 * (x234 * x51 + x44 * (x232 * x51 + x44 * (x209 * x93 + x240)))
            + x20 * x99,
            x0 * x246
            + x0 * (x0 * x248 + x246)
            + x107 * x20
            + x15 * (x243 * x51 + x44 * (x249 * x44 + x250)),
            x0 * x256
            + x0 * (x0 * x258 + x256)
            + x118 * x20
            + x15 * (x254 * x51 + x44 * (x260 * x44 + x261)),
            x0 * x266
            + x0 * (x0 * x269 + x266)
            + x126 * x20
            + x15 * (x263 * x51 + x44 * (x122 * x209 + x270)),
            x0 * x274 + x0 * (x0 * x277 + x274) + x134 * x20 + x15 * (x278 * x44 + x279),
            x0 * x283 + x0 * (x0 * x285 + x283) + x141 * x20 + x15 * (x286 * x44 + x287),
            x0 * x292 + x0 * (x0 * x294 + x292) + x148 * x20 + x15 * (x296 * x44 + x297),
            x0 * x300 + x0 * (x0 * x302 + x300) + x15 * (x154 * x209 + x303) + x155 * x20,
            x0 * x305
            + x0 * (x0 * x307 + x305)
            + x15 * (x133 * x76 + x278 * x80)
            + x163 * x20,
            x0 * x309
            + x0 * (x0 * x311 + x309)
            + x15 * (x140 * x76 + x286 * x80)
            + x168 * x20,
            x0 * x313
            + x0 * (x0 * x315 + x313)
            + x15 * (x147 * x76 + x296 * x80)
            + x173 * x20,
            x0 * x318 + x0 * (x0 * x320 + x318) + x15 * (x154 * x228 + x321) + x178 * x20,
            x0 * x323 + x0 * (x0 * x325 + x323) + x183 * x208 + x184 * x20,
            x0 * x338
            + x0 * (x0 * x341 + x338)
            + x15
            * (x336 * x51 + x44 * (x335 * x51 + x44 * (x334 * x51 + x44 * (x345 + x347))))
            + x21 * x60,
            x0 * x354
            + x0 * (x0 * x358 + x354)
            + x15 * (x351 * x51 + x44 * (x349 * x51 + x44 * (x345 * x80 + x347 * x80)))
            + x21 * x88,
            x0 * x366
            + x0 * (x0 * x368 + x366)
            + x15 * (x363 * x51 + x44 * (x362 * x51 + x44 * (x369 * x44 + x370)))
            + x21 * x99,
            x0 * x375
            + x0 * (x0 * x379 + x375)
            + x107 * x21
            + x15 * (x372 * x51 + x44 * (x103 * x345 + x103 * x347)),
            x0 * x384
            + x0 * (x0 * x387 + x384)
            + x118 * x21
            + x15 * (x381 * x51 + x44 * (x112 * x388 + x350 * x369)),
            x0 * x394
            + x0 * (x0 * x396 + x394)
            + x126 * x21
            + x15 * (x392 * x51 + x44 * (x397 * x44 + x398)),
            x0 * x401
            + x0 * (x0 * x405 + x401)
            + x134 * x21
            + x15 * (x133 * x345 + x133 * x347),
            x0 * x408
            + x0 * (x0 * x411 + x408)
            + x141 * x21
            + x15 * (x139 * x388 + x369 * x373),
            x0 * x415
            + x0 * (x0 * x417 + x415)
            + x148 * x21
            + x15 * (x112 * x391 * x46 + x350 * x397),
            x0 * x422 + x0 * (x0 * x424 + x422) + x15 * (x425 * x44 + x426) + x155 * x21,
            x0 * x428 + x0 * (x0 * x430 + x428) + x162 * x344 + x163 * x21,
            x0 * x432 + x0 * (x0 * x434 + x432) + x166 * x369 + x168 * x21,
            x0 * x436 + x0 * (x0 * x438 + x436) + x139 * x397 + x173 * x21,
            x0 * x440 + x0 * (x0 * x442 + x440) + x112 * x425 + x178 * x21,
            x0 * x444 + x0 * (x0 * x446 + x444) + x15 * (x321 + x425 * x93) + x184 * x21,
            x0 * x450
            + x15
            * (
                x199 * x451
                + x44 * (x197 * x451 + x44 * (x44 * x451 + x44 * (x451 + x455)))
            )
            + x20 * x200
            + x20 * x201,
            x0 * x461
            + x15 * (x44 * (x244 * x458 + x44 * (x44 * x464 + x462)) + x458 * x465)
            + x20 * x222
            + x20 * x223,
            x0 * x468
            + x15 * (x221 * x470 + x44 * (x218 * x470 + x44 * (x455 * x93 + x469)))
            + x20 * x235
            + x20 * x236,
            x0 * x474
            + x15 * (x244 * x471 + x44 * (x44 * x476 + x475))
            + x20 * x245
            + x20 * x246,
            x0 * x480
            + x15 * (x244 * x477 + x44 * (x44 * x482 + x481))
            + x20 * x255
            + x20 * x256,
            x0 * x486
            + x15 * (x264 * x451 + x44 * (x122 * x455 + x487))
            + x20 * x265
            + x20 * x266,
            x0 * x491 + x15 * (x44 * x493 + x492) + x20 * x273 + x20 * x274,
            x0 * x497 + x15 * (x44 * x499 + x498) + x20 * x282 + x20 * x283,
            x0 * x503 + x15 * (x44 * x505 + x504) + x20 * x291 + x20 * x292,
            x0 * x508 + x15 * (x154 * x455 + x509) + x20 * x299 + x20 * x300,
            x0 * x512 + x15 * (x279 + x493 * x80) + x20 * x304 + x20 * x305,
            x0 * x515 + x15 * (x287 + x499 * x80) + x20 * x308 + x20 * x309,
            x0 * x518 + x15 * (x297 + x505 * x80) + x20 * x312 + x20 * x313,
            x0 * x521 + x15 * (x154 * x463 + x303) + x20 * x317 + x20 * x318,
            x0 * x524 + x183 * x454 + x20 * x322 + x20 * x323,
            x0 * x528
            + x15
            * (
                x199 * x529
                + x44 * (x197 * x529 + x44 * (x44 * x529 + x44 * (x4 * x531 + x529)))
            )
            + x20 * x338
            + x200 * x21,
            x0 * x535
            + x15 * (x44 * (x244 * x532 + x44 * (x44 * x536 + x532 * x78)) + x465 * x532)
            + x20 * x354
            + x21 * x222,
            x0 * x540
            + x15 * (x44 * (x244 * x537 + x44 * (x44 * x541 + x537 * x78)) + x465 * x537)
            + x20 * x366
            + x21 * x235,
            x0 * x545
            + x15 * (x244 * x542 + x44 * (x44 * x546 + x542 * x78))
            + x20 * x375
            + x21 * x245,
            x0 * x550
            + x15 * (x244 * x547 + x44 * (x44 * x551 + x547 * x78))
            + x20 * x384
            + x21 * x255,
            x0 * x555
            + x15 * (x244 * x552 + x44 * (x44 * x556 + x552 * x78))
            + x20 * x394
            + x21 * x265,
            x0 * x560 + x15 * (x44 * x561 + x557 * x78) + x20 * x401 + x21 * x273,
            x0 * x565 + x15 * (x44 * x566 + x562 * x78) + x20 * x408 + x21 * x282,
            x0 * x570 + x15 * (x44 * x571 + x567 * x78) + x20 * x415 + x21 * x291,
            x0 * x575 + x15 * (x44 * x576 + x572 * x78) + x20 * x422 + x21 * x299,
            x0 * x579 + x15 * (x133 * x346 + x561 * x80) + x20 * x428 + x21 * x304,
            x0 * x582 + x15 * (x361 * x583 + x566 * x80) + x20 * x432 + x21 * x308,
            x0 * x586 + x15 * (x391 * x412 + x571 * x80) + x20 * x436 + x21 * x312,
            x0 * x589 + x15 * (x420 * x78 + x576 * x80) + x20 * x440 + x21 * x317,
            x0 * x592 + x15 * (x154 * x210 + x576 * x93) + x20 * x444 + x21 * x322,
            x0 * x596
            + x15
            * (
                x199 * x597
                + x44 * (x197 * x597 + x44 * (x44 * x597 + x44 * (x597 + x601)))
            )
            + x21 * x337
            + x21 * x338,
            x0 * x604
            + x15 * (x352 * x597 + x44 * (x350 * x597 + x44 * (x601 * x80 + x605)))
            + x21 * x353
            + x21 * x354,
            x0 * x609
            + x15 * (x44 * (x244 * x606 + x44 * (x44 * x611 + x610)) + x465 * x606)
            + x21 * x365
            + x21 * x366,
            x0 * x614
            + x15 * (x373 * x597 + x44 * (x103 * x601 + x615))
            + x21 * x374
            + x21 * x375,
            x0 * x618
            + x15 * (x382 * x5 * x606 + x44 * (x350 * x611 + x619))
            + x21 * x383
            + x21 * x384,
            x0 * x623
            + x15 * (x244 * x620 + x44 * (x44 * x625 + x624))
            + x21 * x393
            + x21 * x394,
            x0 * x628 + x15 * (x133 * x601 + x629) + x21 * x400 + x21 * x401,
            x0 * x632 + x15 * (x373 * x611 + x633) + x21 * x407 + x21 * x408,
            x0 * x636 + x15 * (x350 * x625 + x637) + x21 * x414 + x21 * x415,
            x0 * x641 + x15 * (x44 * x643 + x642) + x21 * x421 + x21 * x422,
            x0 * x646 + x162 * x600 + x21 * x427 + x21 * x428,
            x0 * x649 + x166 * x611 + x21 * x431 + x21 * x432,
            x0 * x652 + x139 * x625 + x21 * x435 + x21 * x436,
            x0 * x655 + x112 * x643 + x21 * x439 + x21 * x440,
            x0 * x658 + x15 * (x426 + x643 * x93) + x21 * x443 + x21 * x444,
            x20 * x448 + x20 * x449 + x20 * x450 + x202 * x659,
            x20 * x459 + x20 * x460 + x20 * x461 + x224 * x662,
            x20 * x466 + x20 * x467 + x20 * x468 + x237 * x659,
            x20 * x472 + x20 * x473 + x20 * x474 + x221 * x663,
            x20 * x478 + x20 * x479 + x20 * x480 + x221 * x664,
            x130 * x665 + x20 * x484 + x20 * x485 + x20 * x486,
            x20 * x489 + x20 * x490 + x20 * x491 + x218 * x666,
            x20 * x495 + x20 * x496 + x20 * x497 + x218 * x667,
            x20 * x501 + x20 * x502 + x20 * x503 + x218 * x668,
            x159 * x665 + x20 * x506 + x20 * x507 + x20 * x508,
            x15 * (3.0 * x492 + x666 * x80) + x20 * x510 + x20 * x511 + x20 * x512,
            x15 * (3.0 * x498 + x667 * x80) + x20 * x513 + x20 * x514 + x20 * x515,
            x15 * (3.0 * x504 + x668 * x80) + x20 * x516 + x20 * x517 + x20 * x518,
            x15 * (x154 * x660 + x154 * x661) + x20 * x519 + x20 * x520 + x20 * x521,
            x183 * x659 + x20 * x522 + x20 * x523 + x20 * x524,
            x20 * x527 + x20 * x528 + x202 * x669 + x21 * x448,
            x20 * x534 + x20 * x535 + x21 * x459 + x224 * x671,
            x20 * x539 + x20 * x540 + x21 * x466 + x224 * x672,
            x20 * x544 + x20 * x545 + x21 * x472 + x221 * x673,
            x20 * x549 + x20 * x550 + x21 * x478 + x221 * x675,
            x20 * x554 + x20 * x555 + x21 * x484 + x221 * x676,
            x20 * x559 + x20 * x560 + x21 * x489 + x218 * x677,
            x20 * x564 + x20 * x565 + x21 * x495 + x218 * x678,
            x20 * x569 + x20 * x570 + x21 * x501 + x218 * x680,
            x20 * x574 + x20 * x575 + x21 * x506 + x218 * x681,
            x15 * (x51 * x557 + x677 * x80) + x20 * x578 + x20 * x579 + x21 * x510,
            x15 * (x51 * x562 + x678 * x80) + x20 * x581 + x20 * x582 + x21 * x513,
            x15 * (x51 * x567 + x680 * x80) + x20 * x585 + x20 * x586 + x21 * x516,
            x15 * (x681 * x80 + x682) + x20 * x588 + x20 * x589 + x21 * x519,
            x15 * (x509 + x681 * x93) + x20 * x591 + x20 * x592 + x21 * x522,
            x20 * x596 + x202 * x683 + x21 * x526 + x21 * x527,
            x20 * x604 + x21 * x533 + x21 * x534 + x224 * x684,
            x20 * x609 + x21 * x538 + x21 * x539 + x224 * x685,
            x20 * x614 + x21 * x543 + x21 * x544 + x221 * x686,
            x20 * x618 + x21 * x548 + x21 * x549 + x221 * x687,
            x20 * x623 + x21 * x553 + x21 * x554 + x221 * x688,
            x20 * x628 + x21 * x558 + x21 * x559 + x218 * x689,
            x20 * x632 + x21 * x563 + x21 * x564 + x218 * x690,
            x20 * x636 + x21 * x568 + x21 * x569 + x218 * x691,
            x20 * x641 + x21 * x573 + x21 * x574 + x218 * x692,
            x15 * (x629 + x689 * x80) + x20 * x646 + x21 * x577 + x21 * x578,
            x15 * (x633 + x690 * x80) + x20 * x649 + x21 * x580 + x21 * x581,
            x15 * (x637 + x691 * x80) + x20 * x652 + x21 * x584 + x21 * x585,
            x15 * (x642 + x692 * x80) + x20 * x655 + x21 * x587 + x21 * x588,
            x15 * (x682 + x692 * x93) + x20 * x658 + x21 * x590 + x21 * x591,
            x202 * x693 + x21 * x594 + x21 * x595 + x21 * x596,
            x21 * x602 + x21 * x603 + x21 * x604 + x355 * x693,
            x21 * x607 + x21 * x608 + x21 * x609 + x224 * x694,
            x21 * x612 + x21 * x613 + x21 * x614 + x377 * x693,
            x21 * x616 + x21 * x617 + x21 * x618 + x385 * x694,
            x21 * x621 + x21 * x622 + x21 * x623 + x221 * x695,
            x21 * x626 + x21 * x627 + x21 * x628 + x402 * x693,
            x21 * x630 + x21 * x631 + x21 * x632 + x409 * x694,
            x21 * x634 + x21 * x635 + x21 * x636 + x382 * x695,
            x21 * x639 + x21 * x640 + x21 * x641 + x218 * x696,
            x162 * x693 + x21 * x644 + x21 * x645 + x21 * x646,
            x166 * x694 + x21 * x647 + x21 * x648 + x21 * x649,
            x139 * x695 + x21 * x650 + x21 * x651 + x21 * x652,
            x112 * x696 + x21 * x653 + x21 * x654 + x21 * x655,
            x15 * (3.0 * x642 + x696 * x93) + x21 * x656 + x21 * x657 + x21 * x658,
        ]
    )


def _3center2el3d_sph_035(a, A, b, B, c, C):
    """Cartesian (sf|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(6, x16)
    x18 = x13 ** (-1.5)
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x22
    x24 = x2 * x23
    x25 = 2.0 * x18 * x24
    x26 = x17 * x25
    x27 = c ** (-1.0)
    x28 = x13 ** (-0.5)
    x29 = boys(5, x16)
    x30 = x5 * (2.0 * x19 * x2 * x22 * x27 * x28 * x29 - x26)
    x31 = -x3 - A[0]
    x32 = -2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x31 + x26 * x4
    x33 = -x32
    x34 = boys(7, x16)
    x35 = x25 * x34
    x36 = 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x31 - x35 * x4
    x37 = c * x14
    x38 = x36 * x37
    x39 = x30 + x31 * x33 - x38 * x4
    x40 = x39 * x4
    x41 = x33 * x5
    x42 = 2.0 * x41
    x43 = x40 + x42
    x44 = x15 * x4
    x45 = x33 * x4
    x46 = 2.0 * x5
    x47 = x27 * x29
    x48 = x46 * x47
    x49 = x24 * x28 * x48
    x50 = x45 + x49
    x51 = x15 * x46
    x52 = x43 * x44 + x50 * x51
    x53 = x23 * x48
    x54 = x18 * x53
    x55 = x4 * x54 + x44 * x50
    x56 = x44 * x52 + x51 * x55
    x57 = x53 * x6
    x58 = x1 * x13 ** (-2.5)
    x59 = x44 * x55 + x57 * x58
    x60 = x44 * x56 + x51 * x59
    x61 = x4**3
    x62 = x53 * x61
    x63 = x1**2
    x64 = x13 ** (-3.5) * x63
    x65 = x44 * x59 + x62 * x64
    x66 = x15 * (x44 * x60 + x51 * x65)
    x67 = x4**4
    x68 = x1**3
    x69 = x13 ** (-4.5) * x68
    x70 = x53 * x69
    x71 = x15 * (x44 * x65 + x67 * x70)
    x72 = x0 * x71 + x66
    x73 = x4**5
    x74 = x1**4
    x75 = 2.0 * x13 ** (-5.5) * x23 * x47 * x74
    x76 = x0 * x75
    x77 = x5 * (2.0 * x17 * x19 * x2 * x22 * x27 * x28 - x35)
    x78 = x25 * boys(8, x16)
    x79 = x37 * x4
    x80 = (
        x31 * x39
        + x46 * (-x32 - x38)
        - x79
        * (
            x31 * x36
            + x77
            - x79 * (2.0 * x19 * x2 * x22 * x27 * x28 * x31 * x34 - x4 * x78)
        )
    )
    x81 = x4 * x80
    x82 = x39 * x5
    x83 = 3.0 * x82
    x84 = x15 * x5
    x85 = 3.0 * x84
    x86 = x15 * x8
    x87 = x40 * x86 + x42 * x86
    x88 = x54 * x8
    x89 = x45 * x86 + x88
    x90 = x44 * x87 + x51 * x89
    x91 = x53 * x58
    x92 = x4 * x91
    x93 = x44 * x89 + x8 * x92
    x94 = x44 * x90 + x51 * x93
    x95 = x6 * x8
    x96 = x53 * x64
    x97 = x44 * x93 + x95 * x96
    x98 = x15 * (x44 * x94 + x51 * x97)
    x99 = x62 * x69
    x100 = x15 * (x44 * x97 + x8 * x99)
    x101 = x0 * x100 + x98
    x102 = x67 * x76
    x103 = x11 * x15
    x104 = x103 * x40 + x103 * x42
    x105 = x11 * x54
    x106 = x103 * x45 + x105
    x107 = x104 * x44 + x106 * x51
    x108 = x106 * x44 + x11 * x92
    x109 = x107 * x44 + x108 * x51
    x110 = x108 * x44 + x11 * x57 * x64
    x111 = x15 * (x109 * x44 + x110 * x51)
    x112 = x15 * (x11 * x99 + x110 * x44)
    x113 = x0 * x112 + x111
    x114 = x63 / x13**2
    x115 = x114 * x9
    x116 = x115 * x40 + x115 * x42
    x117 = x9 * x91
    x118 = x115 * x45 + x117
    x119 = x116 * x44 + x118 * x51
    x120 = x4 * x9
    x121 = x118 * x44 + x120 * x96
    x122 = x15 * (x119 * x44 + x121 * x51)
    x123 = x57 * x69
    x124 = x15 * (x121 * x44 + x123 * x9)
    x125 = x0 * x124 + x122
    x126 = x61 * x9
    x127 = x114 * x8
    x128 = x11 * x127
    x129 = x128 * x40 + x128 * x42
    x130 = x11 * x8
    x131 = x130 * x91
    x132 = x128 * x45 + x131
    x133 = x129 * x44 + x132 * x51
    x134 = x130 * x4 * x96 + x132 * x44
    x135 = x15 * (x133 * x44 + x134 * x51)
    x136 = x11 * x70
    x137 = x15 * (x134 * x44 + x136 * x95)
    x138 = x0 * x137 + x135
    x139 = x130 * x61
    x140 = x114 * x12
    x141 = x140 * x40 + x140 * x42
    x142 = x12 * x91
    x143 = x140 * x45 + x142
    x144 = x141 * x44 + x143 * x51
    x145 = x12 * x96
    x146 = x143 * x44 + x145 * x4
    x147 = x15 * (x144 * x44 + x146 * x51)
    x148 = x15 * (x12 * x123 + x146 * x44)
    x149 = x0 * x148 + x147
    x150 = x12 * x61
    x151 = x8**3
    x152 = x68 / x13**3
    x153 = x151 * x152
    x154 = x153 * x40 + x153 * x42
    x155 = x151 * x96
    x156 = x153 * x45 + x155
    x157 = x15 * (x154 * x44 + x156 * x51)
    x158 = x151 * x4
    x159 = x15 * (x156 * x44 + x158 * x70)
    x160 = x0 * x159 + x157
    x161 = x151 * x6
    x162 = x152 * x9
    x163 = x11 * x162
    x164 = x163 * x40 + x163 * x42
    x165 = x11 * x9
    x166 = x165 * x96
    x167 = x163 * x45 + x166
    x168 = x15 * (x164 * x44 + x167 * x51)
    x169 = x15 * (x120 * x136 + x167 * x44)
    x170 = x0 * x169 + x168
    x171 = x165 * x6
    x172 = x152 * x8
    x173 = x12 * x172
    x174 = x173 * x40 + x173 * x42
    x175 = x145 * x8
    x176 = x173 * x45 + x175
    x177 = x15 * (x174 * x44 + x176 * x51)
    x178 = x15 * (x12 * x4 * x70 * x8 + x176 * x44)
    x179 = x0 * x178 + x177
    x180 = x12 * x76
    x181 = x11**3
    x182 = x152 * x181
    x183 = x182 * x40 + x182 * x42
    x184 = x181 * x96
    x185 = x182 * x45 + x184
    x186 = x15 * (x183 * x44 + x185 * x51)
    x187 = x181 * x4
    x188 = x15 * (x185 * x44 + x187 * x70)
    x189 = x0 * x188 + x186
    x190 = x181 * x6
    x191 = x8**4
    x192 = x74 / x13**4
    x193 = x191 * x192
    x194 = x15 * (x193 * x40 + x193 * x42)
    x195 = x191 * x70
    x196 = x15 * (x193 * x45 + x195)
    x197 = x0 * x196 + x194
    x198 = x191 * x76
    x199 = x151 * x192
    x200 = x11 * x199
    x201 = x15 * (x200 * x40 + x200 * x42)
    x202 = x136 * x151
    x203 = x15 * (x200 * x45 + x202)
    x204 = x0 * x203 + x201
    x205 = x11 * x158
    x206 = x192 * x40
    x207 = x12 * x9
    x208 = x192 * x207
    x209 = x15 * (x206 * x207 + x208 * x42)
    x210 = x207 * x70
    x211 = x15 * (x208 * x45 + x210)
    x212 = x0 * x211 + x209
    x213 = x181 * x8
    x214 = x192 * x213
    x215 = x15 * (x206 * x213 + x214 * x42)
    x216 = x213 * x70
    x217 = x15 * (x214 * x45 + x216)
    x218 = x0 * x217 + x215
    x219 = x213 * x4
    x220 = x11**4
    x221 = x192 * x220
    x222 = x15 * (x221 * x40 + x221 * x42)
    x223 = x220 * x70
    x224 = x15 * (x221 * x45 + x223)
    x225 = x0 * x224 + x222
    x226 = x220 * x4
    x227 = x8**5
    x228 = x1**5 / x13**5
    x229 = x227 * x228
    x230 = x229 * x39
    x231 = x229 * x33
    x232 = x0 * x231 + x230
    x233 = x191 * x228
    x234 = x11 * x233
    x235 = x234 * x39
    x236 = x234 * x33
    x237 = x0 * x236 + x235
    x238 = x228 * x39
    x239 = x12 * x151
    x240 = x238 * x239
    x241 = x228 * x239
    x242 = x241 * x33
    x243 = x0 * x242 + x240
    x244 = x181 * x9
    x245 = x238 * x244
    x246 = x228 * x244
    x247 = x246 * x33
    x248 = x0 * x247 + x245
    x249 = x220 * x8
    x250 = x238 * x249
    x251 = x228 * x249
    x252 = x251 * x33
    x253 = x0 * x252 + x250
    x254 = x11**5
    x255 = x228 * x254
    x256 = x255 * x39
    x257 = x255 * x33
    x258 = x0 * x257 + x256
    x259 = -x7 - A[1]
    x260 = -2.0 * x19 * x2 * x22 * x259 * x27 * x28 * x29 + x26 * x8
    x261 = -x260
    x262 = x261 * x5
    x263 = 2.0 * x17 * x19 * x2 * x22 * x259 * x27 * x28 - x35 * x8
    x264 = x263 * x37
    x265 = x261 * x31 - x264 * x4
    x266 = x265 * x4
    x267 = x262 + x266
    x268 = x262 * x44 + x267 * x44
    x269 = x114 * x6
    x270 = x262 * x269 + x268 * x44
    x271 = x152 * x61
    x272 = x262 * x271 + x270 * x44
    x273 = x192 * x67
    x274 = x15 * (x262 * x273 + x272 * x44)
    x275 = x20 * x71 + x274
    x276 = x228 * x73
    x277 = x261 * x276
    x278 = x20 * x75
    x279 = x277 + x278 * x73
    x280 = x5 * (-x260 - x264)
    x281 = 2.0 * x19 * x2 * x22 * x259 * x27 * x28 * x34 - x78 * x8
    x282 = x265 * x31 + x280 - x79 * (x263 * x31 - x281 * x79)
    x283 = x282 * x4
    x284 = x265 * x5
    x285 = 2.0 * x284
    x286 = x261 * x8
    x287 = x286 + x49
    x288 = x15 * x287
    x289 = x265 * x8
    x290 = x289 + x41
    x291 = x288 * x5 + x290 * x44
    x292 = x114 * x4
    x293 = x287 * x5
    x294 = x291 * x44 + x292 * x293
    x295 = x152 * x6
    x296 = x293 * x295 + x294 * x44
    x297 = x192 * x61
    x298 = x15 * (x293 * x297 + x296 * x44)
    x299 = x100 * x20 + x298
    x300 = x228 * x67
    x301 = x287 * x300
    x302 = x278 * x67
    x303 = x301 + x302 * x8
    x304 = x282 * x8
    x305 = x304 + x82
    x306 = x290 * x51
    x307 = x103 * x262
    x308 = x103 * x266 + x307
    x309 = x11 * x262
    x310 = x292 * x309 + x308 * x44
    x311 = x295 * x309 + x310 * x44
    x312 = x15 * (x297 * x309 + x311 * x44)
    x313 = x112 * x20 + x312
    x314 = x11 * x300
    x315 = x261 * x314
    x316 = x11 * x302 + x315
    x317 = x103 * x285
    x318 = x288 * x8 + x88
    x319 = x290 * x86 + x41 * x86
    x320 = x318 * x84 + x319 * x44
    x321 = x318 * x5
    x322 = x292 * x321 + x320 * x44
    x323 = x15 * (x295 * x321 + x322 * x44)
    x324 = x124 * x20 + x323
    x325 = x297 * x318
    x326 = x126 * x278 + x325
    x327 = x305 * x86 + x82 * x86
    x328 = x319 * x51
    x329 = x103 * x286 + x105
    x330 = x103 * x41
    x331 = x103 * x289 + x330
    x332 = x329 * x84 + x331 * x44
    x333 = x329 * x5
    x334 = x292 * x333 + x332 * x44
    x335 = x15 * (x295 * x333 + x334 * x44)
    x336 = x137 * x20 + x335
    x337 = x297 * x329
    x338 = x139 * x278 + x337
    x339 = x103 * x82
    x340 = x103 * x304 + x339
    x341 = x331 * x51
    x342 = x140 * x262
    x343 = x140 * x266 + x342
    x344 = x12 * x262
    x345 = x152 * x4
    x346 = x343 * x44 + x344 * x345
    x347 = x192 * x6
    x348 = x15 * (x344 * x347 + x346 * x44)
    x349 = x148 * x20 + x348
    x350 = x228 * x261
    x351 = x150 * x350
    x352 = x150 * x278 + x351
    x353 = x140 * x285
    x354 = x117 + x318 * x86
    x355 = x115 * x41 + x319 * x86
    x356 = x354 * x84 + x355 * x44
    x357 = x292 * x5
    x358 = x15 * (x354 * x357 + x356 * x44)
    x359 = x159 * x20 + x358
    x360 = x295 * x354
    x361 = x161 * x278 + x360
    x362 = x115 * x82 + x327 * x86
    x363 = x355 * x51
    x364 = x131 + x329 * x86
    x365 = x128 * x41 + x331 * x86
    x366 = x364 * x84 + x365 * x44
    x367 = x15 * (x357 * x364 + x366 * x44)
    x368 = x169 * x20 + x367
    x369 = x295 * x364
    x370 = x171 * x278 + x369
    x371 = x128 * x82 + x340 * x86
    x372 = x365 * x51
    x373 = x140 * x286 + x142
    x374 = x140 * x41
    x375 = x140 * x289 + x374
    x376 = x373 * x84 + x375 * x44
    x377 = x15 * (x357 * x373 + x376 * x44)
    x378 = x178 * x20 + x377
    x379 = x295 * x373
    x380 = x12 * x278
    x381 = x379 + x380 * x95
    x382 = x140 * x82
    x383 = x140 * x304 + x382
    x384 = x375 * x51
    x385 = x182 * x262
    x386 = x182 * x266 + x385
    x387 = x187 * x192
    x388 = x15 * (x262 * x387 + x386 * x44)
    x389 = x188 * x20 + x388
    x390 = x190 * x350
    x391 = x190 * x278 + x390
    x392 = x182 * x285
    x393 = x155 + x354 * x86
    x394 = x153 * x41 + x355 * x86
    x395 = x15 * (x393 * x84 + x394 * x44)
    x396 = x196 * x20 + x395
    x397 = x292 * x393
    x398 = x191 * x278
    x399 = x397 + x398 * x4
    x400 = x153 * x82 + x362 * x86
    x401 = x394 * x51
    x402 = x166 + x364 * x86
    x403 = x163 * x41 + x365 * x86
    x404 = x15 * (x402 * x84 + x403 * x44)
    x405 = x20 * x203 + x404
    x406 = x292 * x402
    x407 = x205 * x278 + x406
    x408 = x163 * x82 + x371 * x86
    x409 = x403 * x51
    x410 = x175 + x373 * x86
    x411 = x173 * x41 + x375 * x86
    x412 = x15 * (x410 * x84 + x411 * x44)
    x413 = x20 * x211 + x412
    x414 = x292 * x410
    x415 = x120 * x380 + x414
    x416 = x173 * x82 + x383 * x86
    x417 = x411 * x51
    x418 = x182 * x286 + x184
    x419 = x182 * x41
    x420 = x182 * x289 + x419
    x421 = x15 * (x418 * x84 + x420 * x44)
    x422 = x20 * x217 + x421
    x423 = x292 * x418
    x424 = x219 * x278 + x423
    x425 = x182 * x82
    x426 = x182 * x304 + x425
    x427 = x420 * x51
    x428 = x221 * x262
    x429 = x15 * (x221 * x266 + x428)
    x430 = x20 * x224 + x429
    x431 = x226 * x350
    x432 = x226 * x278 + x431
    x433 = x221 * x285
    x434 = x15 * (x193 * x41 + x394 * x86)
    x435 = x20 * x231 + x434
    x436 = x15 * (x195 + x393 * x86)
    x437 = x227 * x278 + x436
    x438 = x15 * (x200 * x41 + x403 * x86)
    x439 = x20 * x236 + x438
    x440 = x15 * (x202 + x402 * x86)
    x441 = x11 * x398 + x440
    x442 = x15 * (x208 * x41 + x411 * x86)
    x443 = x20 * x242 + x442
    x444 = x15 * (x210 + x410 * x86)
    x445 = x239 * x278 + x444
    x446 = x15 * (x214 * x41 + x420 * x86)
    x447 = x20 * x247 + x446
    x448 = x15 * (x216 + x418 * x86)
    x449 = x244 * x278 + x448
    x450 = x221 * x41
    x451 = x15 * (x221 * x289 + x450)
    x452 = x20 * x252 + x451
    x453 = x15 * (x221 * x286 + x223)
    x454 = x249 * x278 + x453
    x455 = x221 * x82
    x456 = x255 * x265
    x457 = x20 * x257 + x456
    x458 = x255 * x261
    x459 = x254 * x278 + x458
    x460 = -x10 - A[2]
    x461 = x11 * x26 - 2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x460
    x462 = -x461
    x463 = x462 * x5
    x464 = -x11 * x35 + 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x460
    x465 = x37 * x464
    x466 = x31 * x462 - x4 * x465
    x467 = x4 * x466
    x468 = x463 + x467
    x469 = x44 * x463 + x44 * x468
    x470 = x269 * x463 + x44 * x469
    x471 = x271 * x463 + x44 * x470
    x472 = x15 * (x273 * x463 + x44 * x471)
    x473 = x21 * x71 + x472
    x474 = x276 * x462
    x475 = x21 * x75
    x476 = x474 + x475 * x73
    x477 = x5 * (-x461 - x465)
    x478 = -x11 * x78 + 2.0 * x19 * x2 * x22 * x27 * x28 * x34 * x460
    x479 = x31 * x466 + x477 - x79 * (x31 * x464 - x478 * x79)
    x480 = x4 * x479
    x481 = x466 * x5
    x482 = 2.0 * x481
    x483 = x463 * x86
    x484 = x467 * x86 + x483
    x485 = x292 * x8
    x486 = x44 * x484 + x463 * x485
    x487 = x463 * x8
    x488 = x295 * x487 + x44 * x486
    x489 = x15 * (x297 * x487 + x44 * x488)
    x490 = x100 * x21 + x489
    x491 = x300 * x8
    x492 = x462 * x491
    x493 = x475 * x67
    x494 = x492 + x493 * x8
    x495 = x11 * x462 + x49
    x496 = x495 * x84
    x497 = x11 * x466 + x41
    x498 = x44 * x497 + x496
    x499 = x357 * x495 + x44 * x498
    x500 = x495 * x5
    x501 = x295 * x500 + x44 * x499
    x502 = x15 * (x297 * x500 + x44 * x501)
    x503 = x112 * x21 + x502
    x504 = x300 * x495
    x505 = x11 * x493 + x504
    x506 = x11 * x479 + x82
    x507 = x497 * x51
    x508 = x115 * x463
    x509 = x115 * x467 + x508
    x510 = x162 * x4
    x511 = x44 * x509 + x463 * x510
    x512 = x347 * x9
    x513 = x15 * (x44 * x511 + x463 * x512)
    x514 = x124 * x21 + x513
    x515 = x228 * x61
    x516 = x515 * x9
    x517 = x462 * x516
    x518 = x126 * x475 + x517
    x519 = x127 * x500
    x520 = x485 * x497 + x519
    x521 = x172 * x4
    x522 = x44 * x520 + x500 * x521
    x523 = x192 * x500
    x524 = x15 * (x44 * x522 + x523 * x95)
    x525 = x137 * x21 + x524
    x526 = x515 * x8
    x527 = x495 * x526
    x528 = x139 * x475 + x527
    x529 = x46 * x497
    x530 = x103 * x495 + x105
    x531 = x530 * x84
    x532 = x103 * x497 + x330
    x533 = x44 * x532 + x531
    x534 = x357 * x530 + x44 * x533
    x535 = x5 * x530
    x536 = x15 * (x295 * x535 + x44 * x534)
    x537 = x148 * x21 + x536
    x538 = x297 * x530
    x539 = x150 * x475 + x538
    x540 = x103 * x506 + x339
    x541 = x51 * x532
    x542 = x153 * x463
    x543 = x153 * x467 + x542
    x544 = x199 * x4
    x545 = x15 * (x44 * x543 + x463 * x544)
    x546 = x159 * x21 + x545
    x547 = x228 * x6
    x548 = x151 * x547
    x549 = x462 * x548
    x550 = x161 * x475 + x549
    x551 = x162 * x500
    x552 = x497 * x510 + x551
    x553 = x15 * (x120 * x523 + x44 * x552)
    x554 = x169 * x21 + x553
    x555 = x547 * x9
    x556 = x495 * x555
    x557 = x171 * x475 + x556
    x558 = x127 * x535
    x559 = x485 * x532 + x558
    x560 = x15 * (x44 * x559 + x521 * x535)
    x561 = x178 * x21 + x560
    x562 = x192 * x530
    x563 = x562 * x95
    x564 = x12 * x475
    x565 = x563 + x564 * x95
    x566 = x46 * x532
    x567 = x103 * x530 + x142
    x568 = x567 * x84
    x569 = x103 * x532 + x374
    x570 = x44 * x569 + x568
    x571 = x15 * (x357 * x567 + x44 * x570)
    x572 = x188 * x21 + x571
    x573 = x295 * x567
    x574 = x190 * x475 + x573
    x575 = x103 * x540 + x382
    x576 = x51 * x569
    x577 = x193 * x463
    x578 = x15 * (x193 * x467 + x577)
    x579 = x196 * x21 + x578
    x580 = x233 * x4
    x581 = x462 * x580
    x582 = x191 * x475
    x583 = x4 * x582 + x581
    x584 = x199 * x500
    x585 = x15 * (x497 * x544 + x584)
    x586 = x203 * x21 + x585
    x587 = x158 * x228
    x588 = x495 * x587
    x589 = x205 * x475 + x588
    x590 = x162 * x535
    x591 = x15 * (x510 * x532 + x590)
    x592 = x21 * x211 + x591
    x593 = x120 * x562
    x594 = x120 * x564 + x593
    x595 = x127 * x5
    x596 = x567 * x595
    x597 = x15 * (x485 * x569 + x596)
    x598 = x21 * x217 + x597
    x599 = x521 * x567
    x600 = x219 * x475 + x599
    x601 = x103 * x567 + x184
    x602 = x601 * x84
    x603 = x103 * x569 + x419
    x604 = x15 * (x44 * x603 + x602)
    x605 = x21 * x224 + x604
    x606 = x292 * x601
    x607 = x226 * x475 + x606
    x608 = x103 * x575 + x425
    x609 = x51 * x603
    x610 = x229 * x466
    x611 = x21 * x231 + x610
    x612 = x229 * x462
    x613 = x227 * x475 + x612
    x614 = x233 * x497
    x615 = x21 * x236 + x614
    x616 = x233 * x495
    x617 = x11 * x582 + x616
    x618 = x199 * x532
    x619 = x21 * x242 + x618
    x620 = x199 * x530
    x621 = x239 * x475 + x620
    x622 = x162 * x569
    x623 = x21 * x247 + x622
    x624 = x162 * x567
    x625 = x244 * x475 + x624
    x626 = x127 * x603
    x627 = x21 * x252 + x626
    x628 = x127 * x601
    x629 = x249 * x475 + x628
    x630 = x15 * (x103 * x603 + x450)
    x631 = x21 * x257 + x630
    x632 = x15 * (x103 * x601 + x223)
    x633 = x254 * x475 + x632
    x634 = x259 * x261 - x264 * x8 + x30
    x635 = x276 * x634
    x636 = x20 * x277 + x635
    x637 = x20 * x279 + x636
    x638 = x5 * x634
    x639 = x37 * x8
    x640 = x259 * x263 - x281 * x639 + x77
    x641 = x31 * x634 - x640 * x79
    x642 = x4 * x641
    x643 = x634 * x8
    x644 = 2.0 * x262
    x645 = x643 + x644
    x646 = x300 * x645
    x647 = x20 * x301 + x646
    x648 = x20 * x303 + x647
    x649 = x645 * x84
    x650 = x641 * x8
    x651 = x285 + x650
    x652 = x5 * x645
    x653 = x314 * x634
    x654 = x20 * x315 + x653
    x655 = x20 * x316 + x654
    x656 = x103 * x638
    x657 = x11 * x638
    x658 = x288 * x46 + x645 * x86
    x659 = x297 * x658
    x660 = x20 * x325 + x659
    x661 = x20 * x326 + x660
    x662 = x658 * x84
    x663 = x306 + x651 * x86
    x664 = x295 * x5
    x665 = x103 * x643 + x103 * x644
    x666 = x297 * x665
    x667 = x20 * x337 + x666
    x668 = x20 * x338 + x667
    x669 = x665 * x84
    x670 = x103 * x650 + x317
    x671 = x228 * x634
    x672 = x150 * x671
    x673 = x20 * x351 + x672
    x674 = x20 * x352 + x673
    x675 = x140 * x638
    x676 = x12 * x638
    x677 = x318 * x51 + x658 * x86
    x678 = x295 * x677
    x679 = x20 * x360 + x678
    x680 = x20 * x361 + x679
    x681 = x677 * x84
    x682 = x328 + x663 * x86
    x683 = x329 * x51 + x665 * x86
    x684 = x295 * x683
    x685 = x20 * x369 + x684
    x686 = x20 * x370 + x685
    x687 = x683 * x84
    x688 = x341 + x670 * x86
    x689 = x140 * x643 + x140 * x644
    x690 = x295 * x689
    x691 = x20 * x379 + x690
    x692 = x20 * x381 + x691
    x693 = x689 * x84
    x694 = x140 * x650 + x353
    x695 = x190 * x671
    x696 = x20 * x390 + x695
    x697 = x20 * x391 + x696
    x698 = x182 * x638
    x699 = x354 * x51 + x677 * x86
    x700 = x292 * x699
    x701 = x20 * x397 + x700
    x702 = x20 * x399 + x701
    x703 = x699 * x84
    x704 = x363 + x682 * x86
    x705 = x364 * x51 + x683 * x86
    x706 = x292 * x705
    x707 = x20 * x406 + x706
    x708 = x20 * x407 + x707
    x709 = x705 * x84
    x710 = x372 + x688 * x86
    x711 = x373 * x51 + x689 * x86
    x712 = x292 * x711
    x713 = x20 * x414 + x712
    x714 = x20 * x415 + x713
    x715 = x711 * x84
    x716 = x384 + x694 * x86
    x717 = x182 * x643 + x182 * x644
    x718 = x292 * x717
    x719 = x20 * x423 + x718
    x720 = x20 * x424 + x719
    x721 = x717 * x84
    x722 = x182 * x650 + x392
    x723 = x226 * x671
    x724 = x20 * x431 + x723
    x725 = x20 * x432 + x724
    x726 = x221 * x638
    x727 = x15 * (x393 * x51 + x699 * x86)
    x728 = x20 * x436 + x727
    x729 = x20 * x437 + x728
    x730 = x15 * (x402 * x51 + x705 * x86)
    x731 = x20 * x440 + x730
    x732 = x20 * x441 + x731
    x733 = x15 * (x410 * x51 + x711 * x86)
    x734 = x20 * x444 + x733
    x735 = x20 * x445 + x734
    x736 = x15 * (x418 * x51 + x717 * x86)
    x737 = x20 * x448 + x736
    x738 = x20 * x449 + x737
    x739 = x15 * (x221 * x643 + x221 * x644)
    x740 = x20 * x453 + x739
    x741 = x20 * x454 + x740
    x742 = x255 * x634
    x743 = x20 * x458 + x742
    x744 = x20 * x459 + x743
    x745 = x259 * x462 - x465 * x8
    x746 = x276 * x745
    x747 = x21 * x277 + x746
    x748 = x20 * x476 + x747
    x749 = x5 * x745
    x750 = x259 * x464 - x478 * x639
    x751 = x31 * x745 - x750 * x79
    x752 = x463 + x745 * x8
    x753 = x300 * x752
    x754 = x21 * x301 + x753
    x755 = x20 * x494 + x754
    x756 = x481 + x751 * x8
    x757 = x297 * x5
    x758 = x11 * x745 + x262
    x759 = x300 * x758
    x760 = x21 * x315 + x759
    x761 = x20 * x505 + x760
    x762 = x11 * x751 + x284
    x763 = x483 + x752 * x86
    x764 = x297 * x763
    x765 = x21 * x325 + x764
    x766 = x20 * x518 + x765
    x767 = x481 * x86 + x756 * x86
    x768 = x496 + x758 * x86
    x769 = x297 * x768
    x770 = x21 * x337 + x769
    x771 = x20 * x528 + x770
    x772 = x497 * x84 + x762 * x86
    x773 = x103 * x758 + x307
    x774 = x297 * x773
    x775 = x21 * x351 + x774
    x776 = x20 * x539 + x775
    x777 = x103 * x284 + x103 * x762
    x778 = x508 + x763 * x86
    x779 = x295 * x778
    x780 = x21 * x360 + x779
    x781 = x20 * x550 + x780
    x782 = x115 * x481 + x767 * x86
    x783 = x519 + x768 * x86
    x784 = x295 * x783
    x785 = x21 * x369 + x784
    x786 = x20 * x557 + x785
    x787 = x497 * x595 + x772 * x86
    x788 = x531 + x773 * x86
    x789 = x295 * x788
    x790 = x21 * x379 + x789
    x791 = x20 * x565 + x790
    x792 = x532 * x84 + x777 * x86
    x793 = x103 * x773 + x342
    x794 = x295 * x793
    x795 = x21 * x390 + x794
    x796 = x20 * x574 + x795
    x797 = x103 * x777 + x140 * x284
    x798 = x542 + x778 * x86
    x799 = x292 * x798
    x800 = x21 * x397 + x799
    x801 = x20 * x583 + x800
    x802 = x153 * x481 + x782 * x86
    x803 = x551 + x783 * x86
    x804 = x292 * x803
    x805 = x21 * x406 + x804
    x806 = x20 * x589 + x805
    x807 = x497 * x5
    x808 = x162 * x807 + x787 * x86
    x809 = x558 + x788 * x86
    x810 = x292 * x809
    x811 = x21 * x414 + x810
    x812 = x20 * x594 + x811
    x813 = x532 * x595 + x792 * x86
    x814 = x568 + x793 * x86
    x815 = x292 * x814
    x816 = x21 * x423 + x815
    x817 = x20 * x600 + x816
    x818 = x569 * x84 + x797 * x86
    x819 = x103 * x793 + x385
    x820 = x292 * x819
    x821 = x21 * x431 + x820
    x822 = x20 * x607 + x821
    x823 = x103 * x797 + x182 * x284
    x824 = x15 * (x577 + x798 * x86)
    x825 = x21 * x436 + x824
    x826 = x20 * x613 + x825
    x827 = x15 * (x584 + x803 * x86)
    x828 = x21 * x440 + x827
    x829 = x20 * x617 + x828
    x830 = x15 * (x590 + x809 * x86)
    x831 = x21 * x444 + x830
    x832 = x20 * x621 + x831
    x833 = x162 * x5
    x834 = x15 * (x596 + x814 * x86)
    x835 = x21 * x448 + x834
    x836 = x20 * x625 + x835
    x837 = x15 * (x602 + x819 * x86)
    x838 = x21 * x453 + x837
    x839 = x20 * x629 + x838
    x840 = x15 * (x103 * x819 + x428)
    x841 = x21 * x458 + x840
    x842 = x20 * x633 + x841
    x843 = -x11 * x465 + x30 + x460 * x462
    x844 = x276 * x843
    x845 = x21 * x474 + x844
    x846 = x21 * x476 + x845
    x847 = x5 * x843
    x848 = x11 * x37
    x849 = x460 * x464 - x478 * x848 + x77
    x850 = x31 * x843 - x79 * x849
    x851 = x4 * x850
    x852 = x491 * x843
    x853 = x21 * x492 + x852
    x854 = x21 * x494 + x853
    x855 = x847 * x86
    x856 = x8 * x847
    x857 = x11 * x843 + 2.0 * x463
    x858 = x300 * x857
    x859 = x21 * x504 + x858
    x860 = x21 * x505 + x859
    x861 = x84 * x857
    x862 = x11 * x850 + x482
    x863 = x516 * x843
    x864 = x21 * x517 + x863
    x865 = x21 * x518 + x864
    x866 = x115 * x847
    x867 = x526 * x857
    x868 = x21 * x527 + x867
    x869 = x21 * x528 + x868
    x870 = x595 * x857
    x871 = x5 * x857
    x872 = x192 * x871
    x873 = x103 * x857 + x495 * x51
    x874 = x297 * x873
    x875 = x21 * x538 + x874
    x876 = x21 * x539 + x875
    x877 = x84 * x873
    x878 = x103 * x862 + x507
    x879 = x548 * x843
    x880 = x21 * x549 + x879
    x881 = x21 * x550 + x880
    x882 = x153 * x847
    x883 = x555 * x857
    x884 = x21 * x556 + x883
    x885 = x21 * x557 + x884
    x886 = x833 * x857
    x887 = x192 * x873
    x888 = x887 * x95
    x889 = x21 * x563 + x888
    x890 = x21 * x565 + x889
    x891 = x595 * x873
    x892 = x103 * x873 + x51 * x530
    x893 = x295 * x892
    x894 = x21 * x573 + x893
    x895 = x21 * x574 + x894
    x896 = x84 * x892
    x897 = x103 * x878 + x541
    x898 = x580 * x843
    x899 = x21 * x581 + x898
    x900 = x21 * x583 + x899
    x901 = x193 * x847
    x902 = x587 * x857
    x903 = x21 * x588 + x902
    x904 = x21 * x589 + x903
    x905 = x199 * x871
    x906 = x120 * x887
    x907 = x21 * x593 + x906
    x908 = x21 * x594 + x907
    x909 = x833 * x873
    x910 = x521 * x892
    x911 = x21 * x599 + x910
    x912 = x21 * x600 + x911
    x913 = x595 * x892
    x914 = x103 * x892 + x51 * x567
    x915 = x292 * x914
    x916 = x21 * x606 + x915
    x917 = x21 * x607 + x916
    x918 = x84 * x914
    x919 = x103 * x897 + x576
    x920 = x229 * x843
    x921 = x21 * x612 + x920
    x922 = x21 * x613 + x921
    x923 = x233 * x857
    x924 = x21 * x616 + x923
    x925 = x21 * x617 + x924
    x926 = x199 * x873
    x927 = x21 * x620 + x926
    x928 = x21 * x621 + x927
    x929 = x162 * x892
    x930 = x21 * x624 + x929
    x931 = x21 * x625 + x930
    x932 = x127 * x914
    x933 = x21 * x628 + x932
    x934 = x21 * x629 + x933
    x935 = x15 * (x103 * x914 + x51 * x601)
    x936 = x21 * x632 + x935
    x937 = x21 * x633 + x936
    x938 = x259 * x634 + 2.0 * x280 - x639 * x640
    x939 = x8 * x938
    x940 = 3.0 * x638
    x941 = x939 + x940
    x942 = 3.0 * x649 + x86 * x941
    x943 = x103 * x939 + x103 * x940
    x944 = x228 * x938
    x945 = 3.0 * x662 + x86 * x942
    x946 = 3.0 * x669 + x86 * x943
    x947 = x140 * x939 + x140 * x940
    x948 = 3.0 * x681 + x86 * x945
    x949 = 3.0 * x687 + x86 * x946
    x950 = 3.0 * x693 + x86 * x947
    x951 = x182 * x939 + x182 * x940
    x952 = x259 * x745 + x477 - x639 * x750
    x953 = 2.0 * x749
    x954 = x8 * x952 + x953
    x955 = x11 * x952 + x638
    x956 = x51 * x752 + x86 * x954
    x957 = x51 * x758
    x958 = x86 * x955 + x957
    x959 = x103 * x955 + x656
    x960 = x51 * x763 + x86 * x956
    x961 = x51 * x768 + x86 * x958
    x962 = x51 * x773
    x963 = x86 * x959 + x962
    x964 = x103 * x959 + x675
    x965 = x51 * x778 + x86 * x960
    x966 = x51 * x783 + x86 * x961
    x967 = x51 * x788 + x86 * x963
    x968 = x51 * x793
    x969 = x86 * x964 + x968
    x970 = x103 * x964 + x698
    x971 = x51 * x819
    x972 = x259 * x843 - x639 * x849
    x973 = x8 * x972 + x847
    x974 = x11 * x972 + x953
    x975 = x855 + x86 * x973
    x976 = x86 * x974 + x861
    x977 = x103 * x974 + x957
    x978 = x86 * x975 + x866
    x979 = x86 * x976 + x870
    x980 = x86 * x977 + x877
    x981 = x103 * x977 + x962
    x982 = x86 * x978 + x882
    x983 = x86 * x979 + x886
    x984 = x86 * x980 + x891
    x985 = x86 * x981 + x896
    x986 = x103 * x981 + x968
    x987 = x460 * x843 + 2.0 * x477 - x848 * x849
    x988 = x11 * x987 + 3.0 * x847
    x989 = x103 * x988 + 3.0 * x861
    x990 = x192 * x989
    x991 = x103 * x989 + 3.0 * x877
    x992 = x103 * x991 + 3.0 * x896

    # 210 item(s)
    return numpy.array(
        [
            x0 * x66
            + x0 * x72
            + x0 * (x0 * (x71 + x73 * x76) + x72)
            + x15
            * (
                x44
                * (x44 * (x44 * (x43 * x85 + x44 * (x81 + x83)) + x52 * x85) + x56 * x85)
                + x60 * x85
            ),
            x0 * x101
            + x0 * x98
            + x0 * (x0 * (x100 + x102 * x8) + x101)
            + x15
            * (
                x44 * (x44 * (x44 * (x81 * x86 + x83 * x86) + x85 * x87) + x85 * x90)
                + x85 * x94
            ),
            x0 * x111
            + x0 * x113
            + x0 * (x0 * (x102 * x11 + x112) + x113)
            + x15
            * (
                x109 * x85
                + x44
                * (x107 * x85 + x44 * (x104 * x85 + x44 * (x103 * x81 + x103 * x83)))
            ),
            x0 * x122
            + x0 * x125
            + x0 * (x0 * (x124 + x126 * x76) + x125)
            + x15 * (x119 * x85 + x44 * (x116 * x85 + x44 * (x115 * x81 + x115 * x83))),
            x0 * x135
            + x0 * x138
            + x0 * (x0 * (x137 + x139 * x76) + x138)
            + x15 * (x133 * x85 + x44 * (x129 * x85 + x44 * (x128 * x81 + x128 * x83))),
            x0 * x147
            + x0 * x149
            + x0 * (x0 * (x148 + x150 * x76) + x149)
            + x15 * (x144 * x85 + x44 * (x141 * x85 + x44 * (x140 * x81 + x140 * x83))),
            x0 * x157
            + x0 * x160
            + x0 * (x0 * (x159 + x161 * x76) + x160)
            + x15 * (x154 * x85 + x44 * (x153 * x81 + x153 * x83)),
            x0 * x168
            + x0 * x170
            + x0 * (x0 * (x169 + x171 * x76) + x170)
            + x15 * (x164 * x85 + x44 * (x163 * x81 + x163 * x83)),
            x0 * x177
            + x0 * x179
            + x0 * (x0 * (x178 + x180 * x95) + x179)
            + x15 * (x174 * x85 + x44 * (x173 * x81 + x173 * x83)),
            x0 * x186
            + x0 * x189
            + x0 * (x0 * (x188 + x190 * x76) + x189)
            + x15 * (x183 * x85 + x44 * (x182 * x81 + x182 * x83)),
            x0 * x194
            + x0 * x197
            + x0 * (x0 * (x196 + x198 * x4) + x197)
            + x15 * (x193 * x81 + x193 * x83),
            x0 * x201
            + x0 * x204
            + x0 * (x0 * (x203 + x205 * x76) + x204)
            + x15 * (x200 * x81 + x200 * x83),
            x0 * x209
            + x0 * x212
            + x0 * (x0 * (x120 * x180 + x211) + x212)
            + x15 * (x208 * x81 + x208 * x83),
            x0 * x215
            + x0 * x218
            + x0 * (x0 * (x217 + x219 * x76) + x218)
            + x15 * (x214 * x81 + x214 * x83),
            x0 * x222
            + x0 * x225
            + x0 * (x0 * (x224 + x226 * x76) + x225)
            + x15 * (x221 * x81 + x221 * x83),
            x0 * x230 + x0 * x232 + x0 * (x0 * (x227 * x76 + x231) + x232) + x229 * x80,
            x0 * x235 + x0 * x237 + x0 * (x0 * (x11 * x198 + x236) + x237) + x234 * x80,
            x0 * x240 + x0 * x243 + x0 * (x0 * (x239 * x76 + x242) + x243) + x241 * x80,
            x0 * x245 + x0 * x248 + x0 * (x0 * (x244 * x76 + x247) + x248) + x246 * x80,
            x0 * x250 + x0 * x253 + x0 * (x0 * (x249 * x76 + x252) + x253) + x251 * x80,
            x0 * x256 + x0 * x258 + x0 * (x0 * (x254 * x76 + x257) + x258) + x255 * x80,
            x0 * x275
            + x0 * (x0 * x279 + x275)
            + x15
            * (
                x272 * x51
                + x44
                * (
                    x270 * x51
                    + x44 * (x268 * x51 + x44 * (x267 * x51 + x44 * (x283 + x285)))
                )
            )
            + x20 * x66,
            x0 * x299
            + x0 * (x0 * x303 + x299)
            + x15
            * (
                x296 * x51
                + x44 * (x294 * x51 + x44 * (x291 * x51 + x44 * (x305 * x44 + x306)))
            )
            + x20 * x98,
            x0 * x313
            + x0 * (x0 * x316 + x313)
            + x111 * x20
            + x15
            * (
                x311 * x51
                + x44 * (x310 * x51 + x44 * (x308 * x51 + x44 * (x103 * x283 + x317)))
            ),
            x0 * x324
            + x0 * (x0 * x326 + x324)
            + x122 * x20
            + x15 * (x322 * x51 + x44 * (x320 * x51 + x44 * (x327 * x44 + x328))),
            x0 * x336
            + x0 * (x0 * x338 + x336)
            + x135 * x20
            + x15 * (x334 * x51 + x44 * (x332 * x51 + x44 * (x340 * x44 + x341))),
            x0 * x349
            + x0 * (x0 * x352 + x349)
            + x147 * x20
            + x15 * (x346 * x51 + x44 * (x343 * x51 + x44 * (x140 * x283 + x353))),
            x0 * x359
            + x0 * (x0 * x361 + x359)
            + x15 * (x356 * x51 + x44 * (x362 * x44 + x363))
            + x157 * x20,
            x0 * x368
            + x0 * (x0 * x370 + x368)
            + x15 * (x366 * x51 + x44 * (x371 * x44 + x372))
            + x168 * x20,
            x0 * x378
            + x0 * (x0 * x381 + x378)
            + x15 * (x376 * x51 + x44 * (x383 * x44 + x384))
            + x177 * x20,
            x0 * x389
            + x0 * (x0 * x391 + x389)
            + x15 * (x386 * x51 + x44 * (x182 * x283 + x392))
            + x186 * x20,
            x0 * x396 + x0 * (x0 * x399 + x396) + x15 * (x400 * x44 + x401) + x194 * x20,
            x0 * x405 + x0 * (x0 * x407 + x405) + x15 * (x408 * x44 + x409) + x20 * x201,
            x0 * x413 + x0 * (x0 * x415 + x413) + x15 * (x416 * x44 + x417) + x20 * x209,
            x0 * x422 + x0 * (x0 * x424 + x422) + x15 * (x426 * x44 + x427) + x20 * x215,
            x0 * x430 + x0 * (x0 * x432 + x430) + x15 * (x221 * x283 + x433) + x20 * x222,
            x0 * x435
            + x0 * (x0 * x437 + x435)
            + x15 * (x193 * x82 + x400 * x86)
            + x20 * x230,
            x0 * x439
            + x0 * (x0 * x441 + x439)
            + x15 * (x200 * x82 + x408 * x86)
            + x20 * x235,
            x0 * x443
            + x0 * (x0 * x445 + x443)
            + x15 * (x208 * x82 + x416 * x86)
            + x20 * x240,
            x0 * x447
            + x0 * (x0 * x449 + x447)
            + x15 * (x214 * x82 + x426 * x86)
            + x20 * x245,
            x0 * x452 + x0 * (x0 * x454 + x452) + x15 * (x221 * x304 + x455) + x20 * x250,
            x0 * x457 + x0 * (x0 * x459 + x457) + x20 * x256 + x255 * x282,
            x0 * x473
            + x0 * (x0 * x476 + x473)
            + x15
            * (
                x44
                * (
                    x44 * (x44 * (x44 * (x480 + x482) + x468 * x51) + x469 * x51)
                    + x470 * x51
                )
                + x471 * x51
            )
            + x21 * x66,
            x0 * x490
            + x0 * (x0 * x494 + x490)
            + x15
            * (
                x44 * (x44 * (x44 * (x480 * x86 + x482 * x86) + x484 * x51) + x486 * x51)
                + x488 * x51
            )
            + x21 * x98,
            x0 * x503
            + x0 * (x0 * x505 + x503)
            + x111 * x21
            + x15
            * (
                x44 * (x44 * (x44 * (x44 * x506 + x507) + x498 * x51) + x499 * x51)
                + x501 * x51
            ),
            x0 * x514
            + x0 * (x0 * x518 + x514)
            + x122 * x21
            + x15 * (x44 * (x44 * (x115 * x480 + x115 * x482) + x509 * x51) + x51 * x511),
            x0 * x525
            + x0 * (x0 * x528 + x525)
            + x135 * x21
            + x15 * (x44 * (x44 * (x127 * x529 + x485 * x506) + x51 * x520) + x51 * x522),
            x0 * x537
            + x0 * (x0 * x539 + x537)
            + x147 * x21
            + x15 * (x44 * (x44 * (x44 * x540 + x541) + x51 * x533) + x51 * x534),
            x0 * x546
            + x0 * (x0 * x550 + x546)
            + x15 * (x44 * (x153 * x480 + x153 * x482) + x51 * x543)
            + x157 * x21,
            x0 * x554
            + x0 * (x0 * x557 + x554)
            + x15 * (x44 * (x162 * x529 + x506 * x510) + x51 * x552)
            + x168 * x21,
            x0 * x561
            + x0 * (x0 * x565 + x561)
            + x15 * (x44 * (x127 * x566 + x485 * x540) + x51 * x559)
            + x177 * x21,
            x0 * x572
            + x0 * (x0 * x574 + x572)
            + x15 * (x44 * (x44 * x575 + x576) + x51 * x570)
            + x186 * x21,
            x0 * x579
            + x0 * (x0 * x583 + x579)
            + x15 * (x193 * x480 + x193 * x482)
            + x194 * x21,
            x0 * x586
            + x0 * (x0 * x589 + x586)
            + x15 * (x199 * x529 + x506 * x544)
            + x201 * x21,
            x0 * x592
            + x0 * (x0 * x594 + x592)
            + x15 * (x162 * x566 + x510 * x540)
            + x209 * x21,
            x0 * x598
            + x0 * (x0 * x600 + x598)
            + x15 * (x127 * x46 * x569 + x485 * x575)
            + x21 * x215,
            x0 * x605 + x0 * (x0 * x607 + x605) + x15 * (x44 * x608 + x609) + x21 * x222,
            x0 * x611 + x0 * (x0 * x613 + x611) + x21 * x230 + x229 * x479,
            x0 * x615 + x0 * (x0 * x617 + x615) + x21 * x235 + x233 * x506,
            x0 * x619 + x0 * (x0 * x621 + x619) + x199 * x540 + x21 * x240,
            x0 * x623 + x0 * (x0 * x625 + x623) + x162 * x575 + x21 * x245,
            x0 * x627 + x0 * (x0 * x629 + x627) + x127 * x608 + x21 * x250,
            x0 * x631 + x0 * (x0 * x633 + x631) + x15 * (x103 * x608 + x455) + x21 * x256,
            x0 * x637
            + x15
            * (
                x273 * x638
                + x44
                * (
                    x271 * x638
                    + x44 * (x269 * x638 + x44 * (x44 * x638 + x44 * (x638 + x642)))
                )
            )
            + x20 * x274
            + x20 * x275,
            x0 * x648
            + x15
            * (
                x297 * x652
                + x44 * (x295 * x652 + x44 * (x357 * x645 + x44 * (x44 * x651 + x649)))
            )
            + x20 * x298
            + x20 * x299,
            x0 * x655
            + x15
            * (
                x297 * x657
                + x44 * (x295 * x657 + x44 * (x292 * x657 + x44 * (x103 * x642 + x656)))
            )
            + x20 * x312
            + x20 * x313,
            x0 * x661
            + x15 * (x44 * (x357 * x658 + x44 * (x44 * x663 + x662)) + x658 * x664)
            + x20 * x323
            + x20 * x324,
            x0 * x668
            + x15 * (x44 * (x357 * x665 + x44 * (x44 * x670 + x669)) + x664 * x665)
            + x20 * x335
            + x20 * x336,
            x0 * x674
            + x15 * (x347 * x676 + x44 * (x345 * x676 + x44 * (x140 * x642 + x675)))
            + x20 * x348
            + x20 * x349,
            x0 * x680
            + x15 * (x357 * x677 + x44 * (x44 * x682 + x681))
            + x20 * x358
            + x20 * x359,
            x0 * x686
            + x15 * (x357 * x683 + x44 * (x44 * x688 + x687))
            + x20 * x367
            + x20 * x368,
            x0 * x692
            + x15 * (x357 * x689 + x44 * (x44 * x694 + x693))
            + x20 * x377
            + x20 * x378,
            x0 * x697
            + x15 * (x387 * x638 + x44 * (x182 * x642 + x698))
            + x20 * x388
            + x20 * x389,
            x0 * x702 + x15 * (x44 * x704 + x703) + x20 * x395 + x20 * x396,
            x0 * x708 + x15 * (x44 * x710 + x709) + x20 * x404 + x20 * x405,
            x0 * x714 + x15 * (x44 * x716 + x715) + x20 * x412 + x20 * x413,
            x0 * x720 + x15 * (x44 * x722 + x721) + x20 * x421 + x20 * x422,
            x0 * x725 + x15 * (x221 * x642 + x726) + x20 * x429 + x20 * x430,
            x0 * x729 + x15 * (x401 + x704 * x86) + x20 * x434 + x20 * x435,
            x0 * x732 + x15 * (x409 + x710 * x86) + x20 * x438 + x20 * x439,
            x0 * x735 + x15 * (x417 + x716 * x86) + x20 * x442 + x20 * x443,
            x0 * x738 + x15 * (x427 + x722 * x86) + x20 * x446 + x20 * x447,
            x0 * x741 + x15 * (x221 * x650 + x433) + x20 * x451 + x20 * x452,
            x0 * x744 + x20 * x456 + x20 * x457 + x255 * x641,
            x0 * x748
            + x15
            * (
                x273 * x749
                + x44
                * (
                    x271 * x749
                    + x44 * (x269 * x749 + x44 * (x44 * x749 + x44 * (x4 * x751 + x749)))
                )
            )
            + x20 * x473
            + x21 * x274,
            x0 * x755
            + x15
            * (
                x44
                * (x44 * (x357 * x752 + x44 * (x44 * x756 + x752 * x84)) + x664 * x752)
                + x752 * x757
            )
            + x20 * x490
            + x21 * x298,
            x0 * x761
            + x15
            * (
                x44
                * (x44 * (x357 * x758 + x44 * (x44 * x762 + x758 * x84)) + x664 * x758)
                + x757 * x758
            )
            + x20 * x503
            + x21 * x312,
            x0 * x766
            + x15 * (x44 * (x357 * x763 + x44 * (x44 * x767 + x763 * x84)) + x664 * x763)
            + x20 * x514
            + x21 * x323,
            x0 * x771
            + x15 * (x44 * (x357 * x768 + x44 * (x44 * x772 + x768 * x84)) + x664 * x768)
            + x20 * x525
            + x21 * x335,
            x0 * x776
            + x15 * (x44 * (x357 * x773 + x44 * (x44 * x777 + x773 * x84)) + x664 * x773)
            + x20 * x537
            + x21 * x348,
            x0 * x781
            + x15 * (x357 * x778 + x44 * (x44 * x782 + x778 * x84))
            + x20 * x546
            + x21 * x358,
            x0 * x786
            + x15 * (x357 * x783 + x44 * (x44 * x787 + x783 * x84))
            + x20 * x554
            + x21 * x367,
            x0 * x791
            + x15 * (x357 * x788 + x44 * (x44 * x792 + x788 * x84))
            + x20 * x561
            + x21 * x377,
            x0 * x796
            + x15 * (x357 * x793 + x44 * (x44 * x797 + x793 * x84))
            + x20 * x572
            + x21 * x388,
            x0 * x801 + x15 * (x44 * x802 + x798 * x84) + x20 * x579 + x21 * x395,
            x0 * x806 + x15 * (x44 * x808 + x803 * x84) + x20 * x586 + x21 * x404,
            x0 * x812 + x15 * (x44 * x813 + x809 * x84) + x20 * x592 + x21 * x412,
            x0 * x817 + x15 * (x44 * x818 + x814 * x84) + x20 * x598 + x21 * x421,
            x0 * x822 + x15 * (x44 * x823 + x819 * x84) + x20 * x605 + x21 * x429,
            x0 * x826 + x15 * (x193 * x481 + x802 * x86) + x20 * x611 + x21 * x434,
            x0 * x829 + x15 * (x199 * x807 + x808 * x86) + x20 * x615 + x21 * x438,
            x0 * x832 + x15 * (x532 * x833 + x813 * x86) + x20 * x619 + x21 * x442,
            x0 * x836 + x15 * (x569 * x595 + x818 * x86) + x20 * x623 + x21 * x446,
            x0 * x839 + x15 * (x603 * x84 + x823 * x86) + x20 * x627 + x21 * x451,
            x0 * x842 + x15 * (x103 * x823 + x221 * x284) + x20 * x631 + x21 * x456,
            x0 * x846
            + x15
            * (
                x273 * x847
                + x44
                * (
                    x271 * x847
                    + x44 * (x269 * x847 + x44 * (x44 * x847 + x44 * (x847 + x851)))
                )
            )
            + x21 * x472
            + x21 * x473,
            x0 * x854
            + x15
            * (
                x297 * x856
                + x44 * (x295 * x856 + x44 * (x44 * (x851 * x86 + x855) + x485 * x847))
            )
            + x21 * x489
            + x21 * x490,
            x0 * x860
            + x15
            * (
                x44 * (x44 * (x357 * x857 + x44 * (x44 * x862 + x861)) + x664 * x857)
                + x757 * x857
            )
            + x21 * x502
            + x21 * x503,
            x0 * x865
            + x15 * (x44 * (x44 * (x115 * x851 + x866) + x510 * x847) + x512 * x847)
            + x21 * x513
            + x21 * x514,
            x0 * x869
            + x15 * (x44 * (x44 * (x485 * x862 + x870) + x521 * x871) + x872 * x95)
            + x21 * x524
            + x21 * x525,
            x0 * x876
            + x15 * (x44 * (x357 * x873 + x44 * (x44 * x878 + x877)) + x664 * x873)
            + x21 * x536
            + x21 * x537,
            x0 * x881
            + x15 * (x44 * (x153 * x851 + x882) + x544 * x847)
            + x21 * x545
            + x21 * x546,
            x0 * x885
            + x15 * (x120 * x872 + x44 * (x510 * x862 + x886))
            + x21 * x553
            + x21 * x554,
            x0 * x890
            + x15 * (x44 * (x485 * x878 + x891) + x5 * x521 * x873)
            + x21 * x560
            + x21 * x561,
            x0 * x895
            + x15 * (x357 * x892 + x44 * (x44 * x897 + x896))
            + x21 * x571
            + x21 * x572,
            x0 * x900 + x15 * (x193 * x851 + x901) + x21 * x578 + x21 * x579,
            x0 * x904 + x15 * (x544 * x862 + x905) + x21 * x585 + x21 * x586,
            x0 * x908 + x15 * (x510 * x878 + x909) + x21 * x591 + x21 * x592,
            x0 * x912 + x15 * (x485 * x897 + x913) + x21 * x597 + x21 * x598,
            x0 * x917 + x15 * (x44 * x919 + x918) + x21 * x604 + x21 * x605,
            x0 * x922 + x21 * x610 + x21 * x611 + x229 * x850,
            x0 * x925 + x21 * x614 + x21 * x615 + x233 * x862,
            x0 * x928 + x199 * x878 + x21 * x618 + x21 * x619,
            x0 * x931 + x162 * x897 + x21 * x622 + x21 * x623,
            x0 * x934 + x127 * x919 + x21 * x626 + x21 * x627,
            x0 * x937 + x15 * (x103 * x919 + x609) + x21 * x630 + x21 * x631,
            x20 * x635 + x20 * x636 + x20 * x637 + x276 * x938,
            x20 * x646 + x20 * x647 + x20 * x648 + x300 * x941,
            x20 * x653 + x20 * x654 + x20 * x655 + x314 * x938,
            x20 * x659 + x20 * x660 + x20 * x661 + x297 * x942,
            x20 * x666 + x20 * x667 + x20 * x668 + x297 * x943,
            x150 * x944 + x20 * x672 + x20 * x673 + x20 * x674,
            x20 * x678 + x20 * x679 + x20 * x680 + x295 * x945,
            x20 * x684 + x20 * x685 + x20 * x686 + x295 * x946,
            x20 * x690 + x20 * x691 + x20 * x692 + x295 * x947,
            x190 * x944 + x20 * x695 + x20 * x696 + x20 * x697,
            x20 * x700 + x20 * x701 + x20 * x702 + x292 * x948,
            x20 * x706 + x20 * x707 + x20 * x708 + x292 * x949,
            x20 * x712 + x20 * x713 + x20 * x714 + x292 * x950,
            x20 * x718 + x20 * x719 + x20 * x720 + x292 * x951,
            x20 * x723 + x20 * x724 + x20 * x725 + x226 * x944,
            x15 * (3.0 * x703 + x86 * x948) + x20 * x727 + x20 * x728 + x20 * x729,
            x15 * (3.0 * x709 + x86 * x949) + x20 * x730 + x20 * x731 + x20 * x732,
            x15 * (3.0 * x715 + x86 * x950) + x20 * x733 + x20 * x734 + x20 * x735,
            x15 * (3.0 * x721 + x86 * x951) + x20 * x736 + x20 * x737 + x20 * x738,
            x15 * (x221 * x939 + x221 * x940) + x20 * x739 + x20 * x740 + x20 * x741,
            x20 * x742 + x20 * x743 + x20 * x744 + x255 * x938,
            x20 * x747 + x20 * x748 + x21 * x635 + x276 * x952,
            x20 * x754 + x20 * x755 + x21 * x646 + x300 * x954,
            x20 * x760 + x20 * x761 + x21 * x653 + x300 * x955,
            x20 * x765 + x20 * x766 + x21 * x659 + x297 * x956,
            x20 * x770 + x20 * x771 + x21 * x666 + x297 * x958,
            x20 * x775 + x20 * x776 + x21 * x672 + x297 * x959,
            x20 * x780 + x20 * x781 + x21 * x678 + x295 * x960,
            x20 * x785 + x20 * x786 + x21 * x684 + x295 * x961,
            x20 * x790 + x20 * x791 + x21 * x690 + x295 * x963,
            x20 * x795 + x20 * x796 + x21 * x695 + x295 * x964,
            x20 * x800 + x20 * x801 + x21 * x700 + x292 * x965,
            x20 * x805 + x20 * x806 + x21 * x706 + x292 * x966,
            x20 * x811 + x20 * x812 + x21 * x712 + x292 * x967,
            x20 * x816 + x20 * x817 + x21 * x718 + x292 * x969,
            x20 * x821 + x20 * x822 + x21 * x723 + x292 * x970,
            x15 * (x51 * x798 + x86 * x965) + x20 * x825 + x20 * x826 + x21 * x727,
            x15 * (x51 * x803 + x86 * x966) + x20 * x828 + x20 * x829 + x21 * x730,
            x15 * (x51 * x809 + x86 * x967) + x20 * x831 + x20 * x832 + x21 * x733,
            x15 * (x51 * x814 + x86 * x969) + x20 * x835 + x20 * x836 + x21 * x736,
            x15 * (x86 * x970 + x971) + x20 * x838 + x20 * x839 + x21 * x739,
            x15 * (x103 * x970 + x726) + x20 * x841 + x20 * x842 + x21 * x742,
            x20 * x846 + x21 * x746 + x21 * x747 + x276 * x972,
            x20 * x854 + x21 * x753 + x21 * x754 + x300 * x973,
            x20 * x860 + x21 * x759 + x21 * x760 + x300 * x974,
            x20 * x865 + x21 * x764 + x21 * x765 + x297 * x975,
            x20 * x869 + x21 * x769 + x21 * x770 + x297 * x976,
            x20 * x876 + x21 * x774 + x21 * x775 + x297 * x977,
            x20 * x881 + x21 * x779 + x21 * x780 + x295 * x978,
            x20 * x885 + x21 * x784 + x21 * x785 + x295 * x979,
            x20 * x890 + x21 * x789 + x21 * x790 + x295 * x980,
            x20 * x895 + x21 * x794 + x21 * x795 + x295 * x981,
            x20 * x900 + x21 * x799 + x21 * x800 + x292 * x982,
            x20 * x904 + x21 * x804 + x21 * x805 + x292 * x983,
            x20 * x908 + x21 * x810 + x21 * x811 + x292 * x984,
            x20 * x912 + x21 * x815 + x21 * x816 + x292 * x985,
            x20 * x917 + x21 * x820 + x21 * x821 + x292 * x986,
            x15 * (x86 * x982 + x901) + x20 * x922 + x21 * x824 + x21 * x825,
            x15 * (x86 * x983 + x905) + x20 * x925 + x21 * x827 + x21 * x828,
            x15 * (x86 * x984 + x909) + x20 * x928 + x21 * x830 + x21 * x831,
            x15 * (x86 * x985 + x913) + x20 * x931 + x21 * x834 + x21 * x835,
            x15 * (x86 * x986 + x918) + x20 * x934 + x21 * x837 + x21 * x838,
            x15 * (x103 * x986 + x971) + x20 * x937 + x21 * x840 + x21 * x841,
            x21 * x844 + x21 * x845 + x21 * x846 + x276 * x987,
            x21 * x852 + x21 * x853 + x21 * x854 + x491 * x987,
            x21 * x858 + x21 * x859 + x21 * x860 + x300 * x988,
            x21 * x863 + x21 * x864 + x21 * x865 + x516 * x987,
            x21 * x867 + x21 * x868 + x21 * x869 + x526 * x988,
            x21 * x874 + x21 * x875 + x21 * x876 + x297 * x989,
            x21 * x879 + x21 * x880 + x21 * x881 + x548 * x987,
            x21 * x883 + x21 * x884 + x21 * x885 + x555 * x988,
            x21 * x888 + x21 * x889 + x21 * x890 + x95 * x990,
            x21 * x893 + x21 * x894 + x21 * x895 + x295 * x991,
            x21 * x898 + x21 * x899 + x21 * x900 + x580 * x987,
            x21 * x902 + x21 * x903 + x21 * x904 + x587 * x988,
            x120 * x990 + x21 * x906 + x21 * x907 + x21 * x908,
            x21 * x910 + x21 * x911 + x21 * x912 + x521 * x991,
            x21 * x915 + x21 * x916 + x21 * x917 + x292 * x992,
            x21 * x920 + x21 * x921 + x21 * x922 + x229 * x987,
            x21 * x923 + x21 * x924 + x21 * x925 + x233 * x988,
            x199 * x989 + x21 * x926 + x21 * x927 + x21 * x928,
            x162 * x991 + x21 * x929 + x21 * x930 + x21 * x931,
            x127 * x992 + x21 * x932 + x21 * x933 + x21 * x934,
            x15 * (x103 * x992 + 3.0 * x918) + x21 * x935 + x21 * x936 + x21 * x937,
        ]
    )


def _3center2el3d_sph_040(a, A, b, B, c, C):
    """Cartesian (sg|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = -x3 - C[0]
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = c + x1
    x12 = c / x11
    x13 = x1 * x12 * (x10**2 + x6**2 + x8**2)
    x14 = boys(1, x13)
    x15 = 17.4934183276249
    x16 = A[1] - B[1]
    x17 = A[2] - B[2]
    x18 = numpy.exp(-a * b * x2 * (x0**2 + x16**2 + x17**2))
    x19 = 2.0 * x15 * x18 * x2
    x20 = x11 ** (-1.5) * x19
    x21 = x14 * x20
    x22 = c ** (-1.0)
    x23 = x11 ** (-0.5)
    x24 = boys(0, x13)
    x25 = 2.0 * x15 * x18 * x2 * x22 * x23 * x24 - x21
    x26 = x25 * x5
    x27 = x21 * x6
    x28 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x4 + x27
    x29 = -x28
    x30 = boys(2, x13)
    x31 = x20 * x30
    x32 = -2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x4 + x31 * x6
    x33 = -x32
    x34 = x12 * x33
    x35 = x34 * x6
    x36 = x26 + x29 * x4 - x35
    x37 = 2.0 * x5
    x38 = x5 * (2.0 * x14 * x15 * x18 * x2 * x22 * x23 - x31)
    x39 = boys(3, x13)
    x40 = x20 * x39
    x41 = 2.0 * x15 * x18 * x2 * x22 * x23 * x30 * x4 - x40 * x6
    x42 = x12 * x41
    x43 = x33 * x4 + x38 - x42 * x6
    x44 = x12 * x43
    x45 = x36 * x4 + x37 * (-x28 - x34) - x44 * x6
    x46 = x0 * x36 + x45
    x47 = x0 * x29 + x36
    x48 = x0 * x47 + x46
    x49 = x19 * x22 * x23 * x24
    x50 = -x25 * x5
    x51 = x5 * (2.0 * x15 * x18 * x2 * x22 * x23 * x30 - x40)
    x52 = x20 * boys(4, x13)
    x53 = x12 * x6
    x54 = -x7 - A[1]
    x55 = -2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x54 + x31 * x8
    x56 = -x55
    x57 = x12 * x56
    x58 = x21 * x8
    x59 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x54 + x58
    x60 = x5 * (-x57 - x59)
    x61 = -x59
    x62 = x57 * x6
    x63 = -x4 * x61 + x62
    x64 = -x63
    x65 = 2.0 * x15 * x18 * x2 * x22 * x23 * x30 * x54 - x40 * x8
    x66 = x12 * x65
    x67 = x4 * x56 - x6 * x66
    x68 = x12 * x67
    x69 = x4 * x64 - x6 * x68 + x60
    x70 = x16 * x36 + x69
    x71 = x16 * x29 + x4 * x61 - x62
    x72 = x0 * x71 + x70
    x73 = x16 * x49 + x49 * x54 - x58
    x74 = x5 * (-x55 - x66)
    x75 = 2.0 * x15 * x18 * x2 * x22 * x23 * x39 * x54 - x52 * x8
    x76 = -x9 - A[2]
    x77 = x10 * x31 - 2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x76
    x78 = -x77
    x79 = x12 * x78
    x80 = x10 * x21
    x81 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x76 + x80
    x82 = x5 * (-x79 - x81)
    x83 = -x81
    x84 = x6 * x79
    x85 = -x4 * x83 + x84
    x86 = -x85
    x87 = -x10 * x40 + 2.0 * x15 * x18 * x2 * x22 * x23 * x30 * x76
    x88 = x12 * x87
    x89 = x4 * x78 - x6 * x88
    x90 = x12 * x89
    x91 = x4 * x86 - x6 * x90 + x82
    x92 = x17 * x36 + x91
    x93 = x17 * x29 + x4 * x83 - x84
    x94 = x0 * x93 + x92
    x95 = x17 * x49 + x49 * x76 - x80
    x96 = x5 * (-x77 - x88)
    x97 = -x10 * x52 + 2.0 * x15 * x18 * x2 * x22 * x23 * x39 * x76
    x98 = x38 + x54 * x56 - x66 * x8
    x99 = x12 * x98
    x100 = x57 * x8
    x101 = x5 * (-x100 - x50 + x54 * x61 - x99)
    x102 = -x100 + x26 + x54 * x61
    x103 = x6 * x99
    x104 = x102 * x4 - x103 + x16 * x64
    x105 = x104 + x16 * x71
    x106 = x102 + x16 * x61
    x107 = x106 + x16 * x73
    x108 = x102 * x4 - x103
    x109 = x12 * x8
    x110 = -x109 * x75 + x51 + x54 * x65
    x111 = x54 * x78 - x8 * x88
    x112 = x111 * x12
    x113 = x79 * x8
    x114 = x113 - x54 * x83
    x115 = x5 * (-x112 - x114)
    x116 = -x114
    x117 = x112 * x6
    x118 = x116 * x4 - x117 + x17 * x64
    x119 = x118 + x16 * x93
    x120 = -x113 + x17 * x61 + x54 * x83
    x121 = x120 + x16 * x95
    x122 = x116 * x4 - x117
    x123 = -x109 * x97 + x54 * x87
    x124 = -x10 * x88 + x38 + x76 * x78
    x125 = x12 * x124
    x126 = x10 * x79
    x127 = x5 * (-x125 - x126 - x50 + x76 * x83)
    x128 = -x126 + x26 + x76 * x83
    x129 = x125 * x6
    x130 = x128 * x4 - x129 + x17 * x86
    x131 = x130 + x17 * x93
    x132 = x128 + x17 * x83
    x133 = x132 + x17 * x95
    x134 = x128 * x4 - x129
    x135 = x10 * x12
    x136 = -x135 * x97 + x51 + x76 * x87
    x137 = x102 * x54 + 2.0 * x60 - x8 * x99
    x138 = x102 * x16 + x137
    x139 = x106 * x16 + x138
    x140 = x107 * x16 + x139
    x141 = -x109 * x110 + x54 * x98 + 2.0 * x74
    x142 = -x112 * x8 + x116 * x54 + x82
    x143 = x102 * x17 + x142
    x144 = x120 * x16 + x143
    x145 = x121 * x16 + x144
    x146 = -x109 * x123 + x111 * x54 + x96
    x147 = x125 * x8
    x148 = x116 * x17 + x128 * x54 - x147
    x149 = x120 * x17 + x148
    x150 = x133 * x16 + x149
    x151 = x128 * x54 - x147
    x152 = -x109 * x136 + x124 * x54
    x153 = -x10 * x125 + x128 * x76 + 2.0 * x82
    x154 = x128 * x17 + x153
    x155 = x132 * x17 + x154
    x156 = x133 * x17 + x155
    x157 = x124 * x76 - x135 * x136 + 2.0 * x96

    # 15 item(s)
    return numpy.array(
        [
            x0 * x45
            + x0 * x46
            + x0 * x48
            + x0 * (x0 * (x0 * (x0 * x49 - x27 + x4 * x49) + x47) + x48)
            + x4 * x45
            + 3.0 * x5 * (x29 * x4 - x35 - x44 - x50)
            - x53
            * (
                x37 * (-x32 - x42)
                + x4 * x43
                - x53
                * (
                    x4 * x41
                    + x51
                    - x53 * (2.0 * x15 * x18 * x2 * x22 * x23 * x39 * x4 - x52 * x6)
                )
            ),
            x0 * x70
            + x0 * x72
            + x0 * (x0 * (x0 * x73 + x71) + x72)
            + x16 * x45
            + x37 * (-x63 - x68)
            + x4 * x69
            - x53 * (x4 * x67 - x53 * (x4 * x65 - x53 * x75) + x74),
            x0 * x92
            + x0 * x94
            + x0 * (x0 * (x0 * x95 + x93) + x94)
            + x17 * x45
            + x37 * (-x85 - x90)
            + x4 * x91
            - x53 * (x4 * x89 - x53 * (x4 * x87 - x53 * x97) + x96),
            x0 * x105
            + x0 * (x0 * x107 + x105)
            + x101
            + x108 * x4
            + x16 * x69
            + x16 * x70
            - x53 * (-x110 * x53 + x4 * x98),
            x0 * x119
            + x0 * (x0 * x121 + x119)
            + x115
            + x122 * x4
            + x16 * x92
            + x17 * x69
            - x53 * (x111 * x4 - x123 * x53),
            x0 * x131
            + x0 * (x0 * x133 + x131)
            + x127
            + x134 * x4
            + x17 * x91
            + x17 * x92
            - x53 * (x124 * x4 - x136 * x53),
            x0 * x140 + x104 * x16 + x105 * x16 + x108 * x16 + x137 * x4 - x141 * x53,
            x0 * x145 + x108 * x17 + x118 * x16 + x119 * x16 + x142 * x4 - x146 * x53,
            x0 * x150 + x118 * x17 + x122 * x17 + x131 * x16 + x151 * x4 - x152 * x53,
            x0 * x156 + x130 * x17 + x131 * x17 + x134 * x17 + x153 * x4 - x157 * x53,
            3.0 * x101
            - x109 * x141
            + x137 * x16
            + x137 * x54
            + x138 * x16
            + x139 * x16
            + x140 * x16,
            -x109 * x146
            + 2.0 * x115
            + x137 * x17
            + x142 * x54
            + x143 * x16
            + x144 * x16
            + x145 * x16,
            -x109 * x152
            + x127
            + x142 * x17
            + x143 * x17
            + x149 * x16
            + x150 * x16
            + x151 * x54,
            -x109 * x157 + x148 * x17 + x149 * x17 + x151 * x17 + x153 * x54 + x156 * x16,
            3.0 * x127
            - x135 * x157
            + x153 * x17
            + x153 * x76
            + x154 * x17
            + x155 * x17
            + x156 * x17,
        ]
    )


def _3center2el3d_sph_041(a, A, b, B, c, C):
    """Cartesian (sg|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = c + x1
    x12 = x11 ** (-1.0)
    x13 = c * x12
    x14 = x1 * x13 * (x10**2 + x4**2 + x8**2)
    x15 = boys(2, x14)
    x16 = x11 ** (-1.5)
    x17 = 17.4934183276249
    x18 = A[1] - B[1]
    x19 = A[2] - B[2]
    x20 = numpy.exp(-a * b * x2 * (x0**2 + x18**2 + x19**2))
    x21 = x17 * x2 * x20
    x22 = 2.0 * x16 * x21
    x23 = x15 * x22
    x24 = c ** (-1.0)
    x25 = x11 ** (-0.5)
    x26 = boys(1, x14)
    x27 = 2.0 * x17 * x2 * x20 * x24 * x25 * x26 - x23
    x28 = x27 * x6
    x29 = -2.0 * x17 * x2 * x20 * x24 * x25 * x26 * x5 + x23 * x4
    x30 = -x29
    x31 = boys(3, x14)
    x32 = x22 * x31
    x33 = -2.0 * x15 * x17 * x2 * x20 * x24 * x25 * x5 + x32 * x4
    x34 = -x33
    x35 = x13 * x34
    x36 = x35 * x4
    x37 = x28 + x30 * x5 - x36
    x38 = 2.0 * x6
    x39 = x6 * (2.0 * x15 * x17 * x2 * x20 * x24 * x25 - x32)
    x40 = boys(4, x14)
    x41 = x22 * x40
    x42 = 2.0 * x17 * x2 * x20 * x24 * x25 * x31 * x5 - x4 * x41
    x43 = x13 * x42
    x44 = x34 * x5 + x39 - x4 * x43
    x45 = x13 * x44
    x46 = x37 * x5 + x38 * (-x29 - x35) - x4 * x45
    x47 = x37 * x6
    x48 = x1 * x12
    x49 = x48 * (x4 * x46 + 3.0 * x47)
    x50 = x30 * x6
    x51 = x48 * (x37 * x4 + 2.0 * x50)
    x52 = x0 * x51 + x49
    x53 = x24 * x26
    x54 = x21 * x25 * x38 * x53
    x55 = x48 * (x30 * x4 + x54)
    x56 = x0 * x55 + x51
    x57 = x0 * x56 + x52
    x58 = 2.0 * x16 * x17 * x20 * x53
    x59 = x0 * x58
    x60 = -x27 * x6
    x61 = x6 * (2.0 * x17 * x2 * x20 * x24 * x25 * x31 - x41)
    x62 = x22 * boys(5, x14)
    x63 = x13 * x4
    x64 = (
        x46 * x5
        + 3.0 * x6 * (x30 * x5 - x36 - x45 - x60)
        - x63
        * (
            x38 * (-x33 - x43)
            + x44 * x5
            - x63
            * (
                x42 * x5
                + x61
                - x63 * (2.0 * x17 * x2 * x20 * x24 * x25 * x40 * x5 - x4 * x62)
            )
        )
    )
    x65 = x46 * x6
    x66 = x48 * x8
    x67 = x46 * x66
    x68 = x37 * x66
    x69 = x0 * x68 + x67
    x70 = x30 * x66
    x71 = x0 * x70 + x68
    x72 = x0 * x71 + x69
    x73 = x10 * x48
    x74 = x46 * x73
    x75 = x37 * x73
    x76 = x0 * x75 + x74
    x77 = x30 * x73
    x78 = x0 * x77 + x75
    x79 = x0 * x78 + x76
    x80 = -x7 - A[1]
    x81 = -2.0 * x15 * x17 * x2 * x20 * x24 * x25 * x80 + x32 * x8
    x82 = -x81
    x83 = x13 * x82
    x84 = -2.0 * x17 * x2 * x20 * x24 * x25 * x26 * x80 + x23 * x8
    x85 = x6 * (-x83 - x84)
    x86 = -x84
    x87 = x4 * x83 - x5 * x86
    x88 = -x87
    x89 = 2.0 * x17 * x2 * x20 * x24 * x25 * x31 * x80 - x41 * x8
    x90 = x13 * x89
    x91 = -x4 * x90 + x5 * x82
    x92 = x13 * x91
    x93 = -x4 * x92 + x5 * x88 + x85
    x94 = x6 * x88
    x95 = 2.0 * x94
    x96 = x48 * (x4 * x93 + x95)
    x97 = x18 * x51 + x96
    x98 = x6 * x86
    x99 = x48 * (x4 * x88 + x98)
    x100 = x18 * x55 + x99
    x101 = x0 * x100 + x97
    x102 = x4 * x48
    x103 = x102 * x86
    x104 = x18 * x58
    x105 = x103 + x104 * x4
    x106 = x6 * (-x81 - x90)
    x107 = 2.0 * x17 * x2 * x20 * x24 * x25 * x40 * x80 - x62 * x8
    x108 = (
        x38 * (-x87 - x92)
        + x5 * x93
        - x63 * (x106 + x5 * x91 - x63 * (-x107 * x63 + x5 * x89))
    )
    x109 = x6 * x93
    x110 = x48 * (x47 + x8 * x93)
    x111 = x110 + x18 * x68
    x112 = x48 * (x50 + x8 * x88)
    x113 = x112 + x18 * x70
    x114 = x0 * x113 + x111
    x115 = x48 * (x54 + x8 * x86)
    x116 = x104 * x8 + x115
    x117 = x73 * x93
    x118 = x117 + x18 * x75
    x119 = x73 * x88
    x120 = x119 + x18 * x77
    x121 = x0 * x120 + x118
    x122 = x73 * x86
    x123 = x10 * x104 + x122
    x124 = -x9 - A[2]
    x125 = x10 * x32 - 2.0 * x124 * x15 * x17 * x2 * x20 * x24 * x25
    x126 = -x125
    x127 = x126 * x13
    x128 = x10 * x23 - 2.0 * x124 * x17 * x2 * x20 * x24 * x25 * x26
    x129 = x6 * (-x127 - x128)
    x130 = -x128
    x131 = x127 * x4 - x130 * x5
    x132 = -x131
    x133 = -x10 * x41 + 2.0 * x124 * x17 * x2 * x20 * x24 * x25 * x31
    x134 = x13 * x133
    x135 = x126 * x5 - x134 * x4
    x136 = x13 * x135
    x137 = x129 + x132 * x5 - x136 * x4
    x138 = x132 * x6
    x139 = 2.0 * x138
    x140 = x48 * (x137 * x4 + x139)
    x141 = x140 + x19 * x51
    x142 = x130 * x6
    x143 = x48 * (x132 * x4 + x142)
    x144 = x143 + x19 * x55
    x145 = x0 * x144 + x141
    x146 = x102 * x130
    x147 = x19 * x58
    x148 = x146 + x147 * x4
    x149 = x6 * (-x125 - x134)
    x150 = -x10 * x62 + 2.0 * x124 * x17 * x2 * x20 * x24 * x25 * x40
    x151 = (
        x137 * x5
        + x38 * (-x131 - x136)
        - x63 * (x135 * x5 + x149 - x63 * (x133 * x5 - x150 * x63))
    )
    x152 = x137 * x6
    x153 = x137 * x66
    x154 = x153 + x19 * x68
    x155 = x132 * x66
    x156 = x155 + x19 * x70
    x157 = x0 * x156 + x154
    x158 = x130 * x66
    x159 = x147 * x8 + x158
    x160 = x48 * (x10 * x137 + x47)
    x161 = x160 + x19 * x75
    x162 = x48 * (x10 * x132 + x50)
    x163 = x162 + x19 * x77
    x164 = x0 * x163 + x161
    x165 = x48 * (x10 * x130 + x54)
    x166 = x10 * x147 + x165
    x167 = x8 * x83
    x168 = -x167 + x28 + x80 * x86
    x169 = x168 * x6
    x170 = x39 - x8 * x90 + x80 * x82
    x171 = x13 * x170
    x172 = x168 * x5 - x171 * x4
    x173 = x48 * (x169 + x172 * x4)
    x174 = x173 + x18 * x99
    x175 = x100 * x18 + x174
    x176 = x102 * x168
    x177 = x103 * x18 + x176
    x178 = x105 * x18 + x177
    x179 = x6 * (-x167 - x171 - x60 + x80 * x86)
    x180 = x13 * x8
    x181 = -x107 * x180 + x61 + x80 * x89
    x182 = x172 * x5 + x179 - x63 * (x170 * x5 - x181 * x63)
    x183 = x172 * x6
    x184 = x48 * (x172 * x8 + x95)
    x185 = x112 * x18 + x184
    x186 = x113 * x18 + x185
    x187 = x48 * (x168 * x8 + 2.0 * x98)
    x188 = x115 * x18 + x187
    x189 = x116 * x18 + x188
    x190 = x172 * x73
    x191 = x119 * x18 + x190
    x192 = x120 * x18 + x191
    x193 = x168 * x73
    x194 = x122 * x18 + x193
    x195 = x123 * x18 + x194
    x196 = x127 * x8 - x130 * x80
    x197 = -x196
    x198 = x197 * x6
    x199 = x126 * x80 - x134 * x8
    x200 = x13 * x199
    x201 = x197 * x5 - x200 * x4
    x202 = x48 * (x198 + x201 * x4)
    x203 = x19 * x99 + x202
    x204 = x144 * x18 + x203
    x205 = x102 * x197
    x206 = x103 * x19 + x205
    x207 = x148 * x18 + x206
    x208 = x6 * (-x196 - x200)
    x209 = x133 * x80 - x150 * x180
    x210 = x201 * x5 + x208 - x63 * (x199 * x5 - x209 * x63)
    x211 = x201 * x38
    x212 = x48 * (x138 + x201 * x8)
    x213 = x112 * x19 + x212
    x214 = x156 * x18 + x213
    x215 = x48 * (x142 + x197 * x8)
    x216 = x115 * x19 + x215
    x217 = x159 * x18 + x216
    x218 = x48 * (x10 * x201 + x94)
    x219 = x119 * x19 + x218
    x220 = x163 * x18 + x219
    x221 = x48 * (x10 * x197 + x98)
    x222 = x122 * x19 + x221
    x223 = x166 * x18 + x222
    x224 = x10 * x127
    x225 = x124 * x130 - x224 + x28
    x226 = x225 * x6
    x227 = -x10 * x134 + x124 * x126 + x39
    x228 = x13 * x227
    x229 = x225 * x5 - x228 * x4
    x230 = x48 * (x226 + x229 * x4)
    x231 = x143 * x19 + x230
    x232 = x144 * x19 + x231
    x233 = x102 * x225
    x234 = x146 * x19 + x233
    x235 = x148 * x19 + x234
    x236 = x6 * (x124 * x130 - x224 - x228 - x60)
    x237 = x10 * x13
    x238 = x124 * x133 - x150 * x237 + x61
    x239 = x229 * x5 + x236 - x63 * (x227 * x5 - x238 * x63)
    x240 = x229 * x6
    x241 = x229 * x66
    x242 = x155 * x19 + x241
    x243 = x156 * x19 + x242
    x244 = x225 * x66
    x245 = x158 * x19 + x244
    x246 = x159 * x19 + x245
    x247 = x48 * (x10 * x229 + x139)
    x248 = x162 * x19 + x247
    x249 = x163 * x19 + x248
    x250 = x48 * (x10 * x225 + 2.0 * x142)
    x251 = x165 * x19 + x250
    x252 = x166 * x19 + x251
    x253 = x168 * x80 - x171 * x8 + 2.0 * x85
    x254 = x102 * x253
    x255 = x176 * x18 + x254
    x256 = x177 * x18 + x255
    x257 = x178 * x18 + x256
    x258 = x253 * x6
    x259 = 2.0 * x106 + x170 * x80 - x180 * x181
    x260 = x253 * x5 - x259 * x63
    x261 = x48 * (3.0 * x169 + x253 * x8)
    x262 = x18 * x187 + x261
    x263 = x18 * x188 + x262
    x264 = x18 * x189 + x263
    x265 = x253 * x73
    x266 = x18 * x193 + x265
    x267 = x18 * x194 + x266
    x268 = x18 * x195 + x267
    x269 = x129 + x197 * x80 - x200 * x8
    x270 = x102 * x269
    x271 = x176 * x19 + x270
    x272 = x18 * x206 + x271
    x273 = x18 * x207 + x272
    x274 = x269 * x6
    x275 = x149 - x180 * x209 + x199 * x80
    x276 = x269 * x5 - x275 * x63
    x277 = 2.0 * x198
    x278 = x48 * (x269 * x8 + x277)
    x279 = x187 * x19 + x278
    x280 = x18 * x216 + x279
    x281 = x18 * x217 + x280
    x282 = x48 * (x10 * x269 + x169)
    x283 = x19 * x193 + x282
    x284 = x18 * x222 + x283
    x285 = x18 * x223 + x284
    x286 = x225 * x80 - x228 * x8
    x287 = x102 * x286
    x288 = x19 * x205 + x287
    x289 = x19 * x206 + x288
    x290 = x18 * x235 + x289
    x291 = x286 * x6
    x292 = -x180 * x238 + x227 * x80
    x293 = x286 * x5 - x292 * x63
    x294 = x48 * (x226 + x286 * x8)
    x295 = x19 * x215 + x294
    x296 = x19 * x216 + x295
    x297 = x18 * x246 + x296
    x298 = x48 * (x10 * x286 + x277)
    x299 = x19 * x221 + x298
    x300 = x19 * x222 + x299
    x301 = x18 * x252 + x300
    x302 = -x10 * x228 + x124 * x225 + 2.0 * x129
    x303 = x102 * x302
    x304 = x19 * x233 + x303
    x305 = x19 * x234 + x304
    x306 = x19 * x235 + x305
    x307 = x302 * x6
    x308 = x124 * x227 + 2.0 * x149 - x237 * x238
    x309 = x302 * x5 - x308 * x63
    x310 = x302 * x66
    x311 = x19 * x244 + x310
    x312 = x19 * x245 + x311
    x313 = x19 * x246 + x312
    x314 = x48 * (x10 * x302 + 3.0 * x226)
    x315 = x19 * x250 + x314
    x316 = x19 * x251 + x315
    x317 = x19 * x252 + x316
    x318 = 3.0 * x179 - x180 * x259 + x253 * x80
    x319 = -x180 * x275 + 2.0 * x208 + x269 * x80
    x320 = -x180 * x292 + x236 + x286 * x80
    x321 = -x180 * x308 + x302 * x80
    x322 = x124 * x302 + 3.0 * x236 - x237 * x308

    # 45 item(s)
    return numpy.array(
        [
            x0 * x49
            + x0 * x52
            + x0 * x57
            + x0 * (x0 * (x0 * (x4 * x59 + x55) + x56) + x57)
            + x48 * (x4 * x64 + 4.0 * x65),
            x0 * x67
            + x0 * x69
            + x0 * x72
            + x0 * (x0 * (x0 * (x59 * x8 + x70) + x71) + x72)
            + x64 * x66,
            x0 * x74
            + x0 * x76
            + x0 * x79
            + x0 * (x0 * (x0 * (x10 * x59 + x77) + x78) + x79)
            + x64 * x73,
            x0 * x101
            + x0 * x97
            + x0 * (x0 * (x0 * x105 + x100) + x101)
            + x18 * x49
            + x48 * (x108 * x4 + 3.0 * x109),
            x0 * x111
            + x0 * x114
            + x0 * (x0 * (x0 * x116 + x113) + x114)
            + x18 * x67
            + x48 * (x108 * x8 + x65),
            x0 * x118
            + x0 * x121
            + x0 * (x0 * (x0 * x123 + x120) + x121)
            + x108 * x73
            + x18 * x74,
            x0 * x141
            + x0 * x145
            + x0 * (x0 * (x0 * x148 + x144) + x145)
            + x19 * x49
            + x48 * (x151 * x4 + 3.0 * x152),
            x0 * x154
            + x0 * x157
            + x0 * (x0 * (x0 * x159 + x156) + x157)
            + x151 * x66
            + x19 * x67,
            x0 * x161
            + x0 * x164
            + x0 * (x0 * (x0 * x166 + x163) + x164)
            + x19 * x74
            + x48 * (x10 * x151 + x65),
            x0 * x175
            + x0 * (x0 * x178 + x175)
            + x18 * x96
            + x18 * x97
            + x48 * (x182 * x4 + 2.0 * x183),
            x0 * x186
            + x0 * (x0 * x189 + x186)
            + x110 * x18
            + x111 * x18
            + x48 * (2.0 * x109 + x182 * x8),
            x0 * x192 + x0 * (x0 * x195 + x192) + x117 * x18 + x118 * x18 + x182 * x73,
            x0 * x204
            + x0 * (x0 * x207 + x204)
            + x141 * x18
            + x19 * x96
            + x48 * (x210 * x4 + x211),
            x0 * x214
            + x0 * (x0 * x217 + x214)
            + x110 * x19
            + x154 * x18
            + x48 * (x152 + x210 * x8),
            x0 * x220
            + x0 * (x0 * x223 + x220)
            + x117 * x19
            + x161 * x18
            + x48 * (x10 * x210 + x109),
            x0 * x232
            + x0 * (x0 * x235 + x232)
            + x140 * x19
            + x141 * x19
            + x48 * (x239 * x4 + 2.0 * x240),
            x0 * x243 + x0 * (x0 * x246 + x243) + x153 * x19 + x154 * x19 + x239 * x66,
            x0 * x249
            + x0 * (x0 * x252 + x249)
            + x160 * x19
            + x161 * x19
            + x48 * (x10 * x239 + 2.0 * x152),
            x0 * x257 + x173 * x18 + x174 * x18 + x175 * x18 + x48 * (x258 + x260 * x4),
            x0 * x264
            + x18 * x184
            + x18 * x185
            + x18 * x186
            + x48 * (3.0 * x183 + x260 * x8),
            x0 * x268 + x18 * x190 + x18 * x191 + x18 * x192 + x260 * x73,
            x0 * x273 + x173 * x19 + x18 * x203 + x18 * x204 + x48 * (x274 + x276 * x4),
            x0 * x281 + x18 * x213 + x18 * x214 + x184 * x19 + x48 * (x211 + x276 * x8),
            x0 * x285 + x18 * x219 + x18 * x220 + x19 * x190 + x48 * (x10 * x276 + x183),
            x0 * x290 + x18 * x232 + x19 * x202 + x19 * x203 + x48 * (x291 + x293 * x4),
            x0 * x297 + x18 * x243 + x19 * x212 + x19 * x213 + x48 * (x240 + x293 * x8),
            x0 * x301 + x18 * x249 + x19 * x218 + x19 * x219 + x48 * (x10 * x293 + x211),
            x0 * x306 + x19 * x230 + x19 * x231 + x19 * x232 + x48 * (x307 + x309 * x4),
            x0 * x313 + x19 * x241 + x19 * x242 + x19 * x243 + x309 * x66,
            x0 * x317
            + x19 * x247
            + x19 * x248
            + x19 * x249
            + x48 * (x10 * x309 + 3.0 * x240),
            x102 * x318 + x18 * x254 + x18 * x255 + x18 * x256 + x18 * x257,
            x18 * x261
            + x18 * x262
            + x18 * x263
            + x18 * x264
            + x48 * (4.0 * x258 + x318 * x8),
            x18 * x265 + x18 * x266 + x18 * x267 + x18 * x268 + x318 * x73,
            x102 * x319 + x18 * x271 + x18 * x272 + x18 * x273 + x19 * x254,
            x18 * x279
            + x18 * x280
            + x18 * x281
            + x19 * x261
            + x48 * (3.0 * x274 + x319 * x8),
            x18 * x283 + x18 * x284 + x18 * x285 + x19 * x265 + x48 * (x10 * x319 + x258),
            x102 * x320 + x18 * x289 + x18 * x290 + x19 * x270 + x19 * x271,
            x18 * x296
            + x18 * x297
            + x19 * x278
            + x19 * x279
            + x48 * (2.0 * x291 + x320 * x8),
            x18 * x300
            + x18 * x301
            + x19 * x282
            + x19 * x283
            + x48 * (x10 * x320 + 2.0 * x274),
            x102 * x321 + x18 * x306 + x19 * x287 + x19 * x288 + x19 * x289,
            x18 * x313 + x19 * x294 + x19 * x295 + x19 * x296 + x48 * (x307 + x321 * x8),
            x18 * x317
            + x19 * x298
            + x19 * x299
            + x19 * x300
            + x48 * (x10 * x321 + 3.0 * x291),
            x102 * x322 + x19 * x303 + x19 * x304 + x19 * x305 + x19 * x306,
            x19 * x310 + x19 * x311 + x19 * x312 + x19 * x313 + x322 * x66,
            x19 * x314
            + x19 * x315
            + x19 * x316
            + x19 * x317
            + x48 * (x10 * x322 + 4.0 * x307),
        ]
    )


def _3center2el3d_sph_042(a, A, b, B, c, C):
    """Cartesian (sg|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = x4**2
    x8 = -x2 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x2 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x1
    x15 = x14 ** (-1.0)
    x16 = c * x15
    x17 = x1 * x16 * (x10 + x13 + x7)
    x18 = boys(3, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x0**2 + x21**2 + x22**2))
    x24 = x2 * x20 * x23
    x25 = 2.0 * x19 * x24
    x26 = x18 * x25
    x27 = c ** (-1.0)
    x28 = x14 ** (-0.5)
    x29 = boys(2, x17)
    x30 = 2.0 * x2 * x20 * x23 * x27 * x28 * x29 - x26
    x31 = x30 * x6
    x32 = -2.0 * x2 * x20 * x23 * x27 * x28 * x29 * x5 + x26 * x4
    x33 = -x32
    x34 = boys(4, x17)
    x35 = x25 * x34
    x36 = -2.0 * x18 * x2 * x20 * x23 * x27 * x28 * x5 + x35 * x4
    x37 = -x36
    x38 = x16 * x37
    x39 = x38 * x4
    x40 = x31 + x33 * x5 - x39
    x41 = 2.0 * x6
    x42 = x6 * (2.0 * x18 * x2 * x20 * x23 * x27 * x28 - x35)
    x43 = boys(5, x17)
    x44 = x25 * x43
    x45 = 2.0 * x2 * x20 * x23 * x27 * x28 * x34 * x5 - x4 * x44
    x46 = x16 * x45
    x47 = x37 * x5 - x4 * x46 + x42
    x48 = x16 * x47
    x49 = -x4 * x48 + x40 * x5 + x41 * (-x32 - x38)
    x50 = x4 * x49
    x51 = x40 * x6
    x52 = 3.0 * x51
    x53 = x50 + x52
    x54 = x1 * x15
    x55 = x4 * x54
    x56 = x4 * x40
    x57 = x33 * x6
    x58 = 2.0 * x57
    x59 = x56 + x58
    x60 = 3.0 * x6
    x61 = x54 * x60
    x62 = x54 * (x53 * x55 + x59 * x61)
    x63 = x33 * x4
    x64 = x27 * x29
    x65 = x41 * x64
    x66 = x24 * x28 * x65
    x67 = x63 + x66
    x68 = x41 * x54
    x69 = x54 * (x55 * x59 + x67 * x68)
    x70 = x0 * x69 + x62
    x71 = x20 * x23
    x72 = x4 * x71
    x73 = x19 * x65
    x74 = x54 * (x55 * x67 + x72 * x73)
    x75 = x0 * x74 + x69
    x76 = x0 * x75 + x70
    x77 = 2.0 * x1 * x14 ** (-2.5) * x64
    x78 = x71 * x77
    x79 = x0 * x78
    x80 = -x30 * x6
    x81 = x6 * (2.0 * x2 * x20 * x23 * x27 * x28 * x34 - x44)
    x82 = x25 * boys(6, x17)
    x83 = x16 * x4
    x84 = (
        x49 * x5
        + x60 * (x33 * x5 - x39 - x48 - x80)
        - x83
        * (
            x41 * (-x36 - x46)
            + x47 * x5
            - x83
            * (
                x45 * x5
                + x81
                - x83 * (2.0 * x2 * x20 * x23 * x27 * x28 * x43 * x5 - x4 * x82)
            )
        )
    )
    x85 = x4 * x84
    x86 = x49 * x6
    x87 = 4.0 * x86
    x88 = x54 * x6
    x89 = x54 * x9
    x90 = x54 * (x50 * x89 + x52 * x89)
    x91 = x54 * (x56 * x89 + x58 * x89)
    x92 = x0 * x91 + x90
    x93 = x71 * x73
    x94 = x9 * x93
    x95 = x54 * (x63 * x89 + x94)
    x96 = x0 * x95 + x91
    x97 = x0 * x96 + x92
    x98 = x72 * x77
    x99 = x0 * x98
    x100 = x12 * x54
    x101 = x54 * (x100 * x50 + x100 * x52)
    x102 = x54 * (x100 * x56 + x100 * x58)
    x103 = x0 * x102 + x101
    x104 = x12 * x93
    x105 = x54 * (x100 * x63 + x104)
    x106 = x0 * x105 + x102
    x107 = x0 * x106 + x103
    x108 = x1**2 / x14**2
    x109 = x10 * x108
    x110 = x109 * x49
    x111 = x109 * x40
    x112 = x0 * x111 + x110
    x113 = x109 * x33
    x114 = x0 * x113 + x111
    x115 = x0 * x114 + x112
    x116 = x108 * x9
    x117 = x116 * x12
    x118 = x117 * x49
    x119 = x117 * x40
    x120 = x0 * x119 + x118
    x121 = x117 * x33
    x122 = x0 * x121 + x119
    x123 = x0 * x122 + x120
    x124 = x12 * x9
    x125 = x108 * x13
    x126 = x125 * x49
    x127 = x125 * x40
    x128 = x0 * x127 + x126
    x129 = x125 * x33
    x130 = x0 * x129 + x127
    x131 = x0 * x130 + x128
    x132 = -x8 - A[1]
    x133 = -2.0 * x132 * x18 * x2 * x20 * x23 * x27 * x28 + x35 * x9
    x134 = -x133
    x135 = x134 * x16
    x136 = -2.0 * x132 * x2 * x20 * x23 * x27 * x28 * x29 + x26 * x9
    x137 = x6 * (-x135 - x136)
    x138 = -x136
    x139 = x135 * x4 - x138 * x5
    x140 = -x139
    x141 = 2.0 * x132 * x2 * x20 * x23 * x27 * x28 * x34 - x44 * x9
    x142 = x141 * x16
    x143 = x134 * x5 - x142 * x4
    x144 = x143 * x16
    x145 = x137 + x140 * x5 - x144 * x4
    x146 = x145 * x4
    x147 = x140 * x6
    x148 = 2.0 * x147
    x149 = x146 + x148
    x150 = x138 * x6
    x151 = x140 * x4
    x152 = x150 + x151
    x153 = x54 * (x149 * x55 + x152 * x68)
    x154 = x153 + x21 * x69
    x155 = x54 * (x150 * x55 + x152 * x55)
    x156 = x155 + x21 * x74
    x157 = x0 * x156 + x154
    x158 = x108 * x7
    x159 = x138 * x158
    x160 = x21 * x78
    x161 = x159 + x160 * x7
    x162 = x6 * (-x133 - x142)
    x163 = 2.0 * x132 * x2 * x20 * x23 * x27 * x28 * x43 - x82 * x9
    x164 = (
        x145 * x5
        + x41 * (-x139 - x144)
        - x83 * (x143 * x5 + x162 - x83 * (x141 * x5 - x163 * x83))
    )
    x165 = x164 * x4
    x166 = x145 * x6
    x167 = 3.0 * x166
    x168 = x145 * x9
    x169 = x168 + x51
    x170 = x140 * x9
    x171 = x170 + x57
    x172 = x171 * x68
    x173 = x54 * (x169 * x55 + x172)
    x174 = x173 + x21 * x91
    x175 = x138 * x9
    x176 = x175 + x66
    x177 = x176 * x54
    x178 = x54 * (x171 * x55 + x177 * x6)
    x179 = x178 + x21 * x95
    x180 = x0 * x179 + x174
    x181 = x108 * x4
    x182 = x176 * x181
    x183 = x21 * x98
    x184 = x182 + x183 * x9
    x185 = x164 * x9
    x186 = x185 + x86
    x187 = x100 * x148
    x188 = x54 * (x100 * x146 + x187)
    x189 = x102 * x21 + x188
    x190 = x100 * x150
    x191 = x54 * (x100 * x151 + x190)
    x192 = x105 * x21 + x191
    x193 = x0 * x192 + x189
    x194 = x12 * x181
    x195 = x138 * x194
    x196 = x12 * x183 + x195
    x197 = x54 * (x169 * x89 + x51 * x89)
    x198 = x111 * x21 + x197
    x199 = x54 * (x171 * x89 + x57 * x89)
    x200 = x113 * x21 + x199
    x201 = x0 * x200 + x198
    x202 = x54 * (x177 * x9 + x94)
    x203 = x10 * x160 + x202
    x204 = x100 * x51
    x205 = x54 * (x100 * x168 + x204)
    x206 = x119 * x21 + x205
    x207 = x100 * x57
    x208 = x54 * (x100 * x170 + x207)
    x209 = x121 * x21 + x208
    x210 = x0 * x209 + x206
    x211 = x54 * (x100 * x175 + x104)
    x212 = x124 * x160 + x211
    x213 = x100 * x86
    x214 = x125 * x145
    x215 = x127 * x21 + x214
    x216 = x125 * x140
    x217 = x129 * x21 + x216
    x218 = x0 * x217 + x215
    x219 = x125 * x138
    x220 = x13 * x160 + x219
    x221 = -x11 - A[2]
    x222 = x12 * x35 - 2.0 * x18 * x2 * x20 * x221 * x23 * x27 * x28
    x223 = -x222
    x224 = x16 * x223
    x225 = x12 * x26 - 2.0 * x2 * x20 * x221 * x23 * x27 * x28 * x29
    x226 = x6 * (-x224 - x225)
    x227 = -x225
    x228 = x224 * x4 - x227 * x5
    x229 = -x228
    x230 = -x12 * x44 + 2.0 * x2 * x20 * x221 * x23 * x27 * x28 * x34
    x231 = x16 * x230
    x232 = x223 * x5 - x231 * x4
    x233 = x16 * x232
    x234 = x226 + x229 * x5 - x233 * x4
    x235 = x234 * x4
    x236 = x229 * x6
    x237 = 2.0 * x236
    x238 = x235 + x237
    x239 = x227 * x6
    x240 = x229 * x4
    x241 = x239 + x240
    x242 = x54 * (x238 * x55 + x241 * x68)
    x243 = x22 * x69 + x242
    x244 = x54 * (x239 * x55 + x241 * x55)
    x245 = x22 * x74 + x244
    x246 = x0 * x245 + x243
    x247 = x158 * x227
    x248 = x22 * x78
    x249 = x247 + x248 * x7
    x250 = x6 * (-x222 - x231)
    x251 = -x12 * x82 + 2.0 * x2 * x20 * x221 * x23 * x27 * x28 * x43
    x252 = (
        x234 * x5
        + x41 * (-x228 - x233)
        - x83 * (x232 * x5 + x250 - x83 * (x230 * x5 - x251 * x83))
    )
    x253 = x252 * x4
    x254 = x234 * x6
    x255 = 3.0 * x254
    x256 = x54 * (x235 * x89 + x237 * x89)
    x257 = x22 * x91 + x256
    x258 = x239 * x89
    x259 = x54 * (x240 * x89 + x258)
    x260 = x22 * x95 + x259
    x261 = x0 * x260 + x257
    x262 = x181 * x9
    x263 = x227 * x262
    x264 = x22 * x98
    x265 = x263 + x264 * x9
    x266 = x12 * x234 + x51
    x267 = x12 * x229 + x57
    x268 = x267 * x68
    x269 = x54 * (x266 * x55 + x268)
    x270 = x102 * x22 + x269
    x271 = x12 * x227 + x66
    x272 = x271 * x54
    x273 = x272 * x6
    x274 = x54 * (x267 * x55 + x273)
    x275 = x105 * x22 + x274
    x276 = x0 * x275 + x270
    x277 = x181 * x271
    x278 = x12 * x264 + x277
    x279 = x12 * x252 + x86
    x280 = x109 * x234
    x281 = x111 * x22 + x280
    x282 = x109 * x229
    x283 = x113 * x22 + x282
    x284 = x0 * x283 + x281
    x285 = x109 * x227
    x286 = x10 * x248 + x285
    x287 = x116 * x266
    x288 = x119 * x22 + x287
    x289 = x116 * x267
    x290 = x121 * x22 + x289
    x291 = x0 * x290 + x288
    x292 = x116 * x271
    x293 = x124 * x248 + x292
    x294 = x54 * (x100 * x266 + x204)
    x295 = x127 * x22 + x294
    x296 = x54 * (x100 * x267 + x207)
    x297 = x129 * x22 + x296
    x298 = x0 * x297 + x295
    x299 = x54 * (x104 + x12 * x272)
    x300 = x13 * x248 + x299
    x301 = x135 * x9
    x302 = x132 * x138 - x301 + x31
    x303 = x302 * x6
    x304 = x132 * x134 - x142 * x9 + x42
    x305 = x16 * x304
    x306 = x302 * x5 - x305 * x4
    x307 = x306 * x4
    x308 = x303 + x307
    x309 = x54 * (x303 * x55 + x308 * x55)
    x310 = x155 * x21 + x309
    x311 = x156 * x21 + x310
    x312 = x158 * x302
    x313 = x159 * x21 + x312
    x314 = x161 * x21 + x313
    x315 = x6 * (x132 * x138 - x301 - x305 - x80)
    x316 = x16 * x9
    x317 = x132 * x141 - x163 * x316 + x81
    x318 = x306 * x5 + x315 - x83 * (x304 * x5 - x317 * x83)
    x319 = x318 * x4
    x320 = x306 * x6
    x321 = 2.0 * x320
    x322 = x302 * x9
    x323 = 2.0 * x150
    x324 = x322 + x323
    x325 = x306 * x9
    x326 = x148 + x325
    x327 = x54 * (x324 * x88 + x326 * x55)
    x328 = x178 * x21 + x327
    x329 = x179 * x21 + x328
    x330 = x181 * x324
    x331 = x182 * x21 + x330
    x332 = x184 * x21 + x331
    x333 = x318 * x9
    x334 = 2.0 * x166
    x335 = x333 + x334
    x336 = x100 * x303
    x337 = x54 * (x100 * x307 + x336)
    x338 = x191 * x21 + x337
    x339 = x192 * x21 + x338
    x340 = x194 * x302
    x341 = x195 * x21 + x340
    x342 = x196 * x21 + x341
    x343 = x54 * (x172 + x326 * x89)
    x344 = x199 * x21 + x343
    x345 = x200 * x21 + x344
    x346 = x54 * (x177 * x41 + x324 * x89)
    x347 = x202 * x21 + x346
    x348 = x203 * x21 + x347
    x349 = x54 * (x100 * x325 + x187)
    x350 = x208 * x21 + x349
    x351 = x209 * x21 + x350
    x352 = x54 * (x100 * x322 + x100 * x323)
    x353 = x21 * x211 + x352
    x354 = x21 * x212 + x353
    x355 = x125 * x306
    x356 = x21 * x216 + x355
    x357 = x21 * x217 + x356
    x358 = x125 * x302
    x359 = x21 * x219 + x358
    x360 = x21 * x220 + x359
    x361 = -x132 * x227 + x224 * x9
    x362 = -x361
    x363 = x362 * x6
    x364 = x132 * x223 - x231 * x9
    x365 = x16 * x364
    x366 = x362 * x5 - x365 * x4
    x367 = x363 + x366 * x4
    x368 = x54 * (x363 * x55 + x367 * x55)
    x369 = x155 * x22 + x368
    x370 = x21 * x245 + x369
    x371 = x158 * x362
    x372 = x159 * x22 + x371
    x373 = x21 * x249 + x372
    x374 = x6 * (-x361 - x365)
    x375 = x132 * x230 - x251 * x316
    x376 = x366 * x5 + x374 - x83 * (x364 * x5 - x375 * x83)
    x377 = x366 * x41
    x378 = x239 + x362 * x9
    x379 = x236 + x366 * x9
    x380 = x54 * (x378 * x88 + x379 * x55)
    x381 = x178 * x22 + x380
    x382 = x21 * x260 + x381
    x383 = x181 * x378
    x384 = x182 * x22 + x383
    x385 = x21 * x265 + x384
    x386 = x254 + x376 * x9
    x387 = x379 * x68
    x388 = x12 * x362 + x150
    x389 = x12 * x366 + x147
    x390 = x54 * (x388 * x88 + x389 * x55)
    x391 = x191 * x22 + x390
    x392 = x21 * x275 + x391
    x393 = x181 * x388
    x394 = x195 * x22 + x393
    x395 = x21 * x278 + x394
    x396 = x12 * x376 + x166
    x397 = x389 * x68
    x398 = x54 * (x236 * x89 + x379 * x89)
    x399 = x199 * x22 + x398
    x400 = x21 * x283 + x399
    x401 = x54 * (x258 + x378 * x89)
    x402 = x202 * x22 + x401
    x403 = x21 * x286 + x402
    x404 = x54 * (x267 * x88 + x389 * x89)
    x405 = x208 * x22 + x404
    x406 = x21 * x290 + x405
    x407 = x54 * (x273 + x388 * x89)
    x408 = x211 * x22 + x407
    x409 = x21 * x293 + x408
    x410 = x54 * (x100 * x147 + x100 * x389)
    x411 = x216 * x22 + x410
    x412 = x21 * x297 + x411
    x413 = x54 * (x100 * x388 + x190)
    x414 = x219 * x22 + x413
    x415 = x21 * x300 + x414
    x416 = x12 * x224
    x417 = x221 * x227 + x31 - x416
    x418 = x417 * x6
    x419 = -x12 * x231 + x221 * x223 + x42
    x420 = x16 * x419
    x421 = -x4 * x420 + x417 * x5
    x422 = x4 * x421
    x423 = x418 + x422
    x424 = x54 * (x418 * x55 + x423 * x55)
    x425 = x22 * x244 + x424
    x426 = x22 * x245 + x425
    x427 = x158 * x417
    x428 = x22 * x247 + x427
    x429 = x22 * x249 + x428
    x430 = x6 * (x221 * x227 - x416 - x420 - x80)
    x431 = x12 * x16
    x432 = x221 * x230 - x251 * x431 + x81
    x433 = x421 * x5 + x430 - x83 * (x419 * x5 - x432 * x83)
    x434 = x4 * x433
    x435 = x421 * x6
    x436 = 2.0 * x435
    x437 = x418 * x89
    x438 = x54 * (x422 * x89 + x437)
    x439 = x22 * x259 + x438
    x440 = x22 * x260 + x439
    x441 = x262 * x417
    x442 = x22 * x263 + x441
    x443 = x22 * x265 + x442
    x444 = x12 * x417 + 2.0 * x239
    x445 = x444 * x88
    x446 = x12 * x421 + x237
    x447 = x54 * (x445 + x446 * x55)
    x448 = x22 * x274 + x447
    x449 = x22 * x275 + x448
    x450 = x181 * x444
    x451 = x22 * x277 + x450
    x452 = x22 * x278 + x451
    x453 = x12 * x433 + 2.0 * x254
    x454 = x109 * x421
    x455 = x22 * x282 + x454
    x456 = x22 * x283 + x455
    x457 = x109 * x417
    x458 = x22 * x285 + x457
    x459 = x22 * x286 + x458
    x460 = x116 * x446
    x461 = x22 * x289 + x460
    x462 = x22 * x290 + x461
    x463 = x116 * x444
    x464 = x22 * x292 + x463
    x465 = x22 * x293 + x464
    x466 = x54 * (x100 * x446 + x268)
    x467 = x22 * x296 + x466
    x468 = x22 * x297 + x467
    x469 = x54 * (x100 * x444 + x272 * x41)
    x470 = x22 * x299 + x469
    x471 = x22 * x300 + x470
    x472 = x132 * x302 + 2.0 * x137 - x305 * x9
    x473 = x158 * x472
    x474 = x21 * x312 + x473
    x475 = x21 * x313 + x474
    x476 = x21 * x314 + x475
    x477 = x472 * x6
    x478 = x132 * x304 + 2.0 * x162 - x316 * x317
    x479 = x472 * x5 - x478 * x83
    x480 = x4 * x479
    x481 = x472 * x9
    x482 = 3.0 * x303
    x483 = x481 + x482
    x484 = x181 * x483
    x485 = x21 * x330 + x484
    x486 = x21 * x331 + x485
    x487 = x21 * x332 + x486
    x488 = x483 * x88
    x489 = x479 * x9
    x490 = 3.0 * x320
    x491 = x489 + x490
    x492 = x194 * x472
    x493 = x21 * x340 + x492
    x494 = x21 * x341 + x493
    x495 = x21 * x342 + x494
    x496 = x100 * x477
    x497 = x54 * (x324 * x61 + x483 * x89)
    x498 = x21 * x346 + x497
    x499 = x21 * x347 + x498
    x500 = x21 * x348 + x499
    x501 = x54 * (x100 * x481 + x100 * x482)
    x502 = x21 * x352 + x501
    x503 = x21 * x353 + x502
    x504 = x21 * x354 + x503
    x505 = x125 * x472
    x506 = x21 * x358 + x505
    x507 = x21 * x359 + x506
    x508 = x21 * x360 + x507
    x509 = x132 * x362 + x226 - x365 * x9
    x510 = x158 * x509
    x511 = x22 * x312 + x510
    x512 = x21 * x372 + x511
    x513 = x21 * x373 + x512
    x514 = x509 * x6
    x515 = x132 * x364 + x250 - x316 * x375
    x516 = x5 * x509 - x515 * x83
    x517 = 2.0 * x363
    x518 = x509 * x9 + x517
    x519 = x181 * x518
    x520 = x22 * x330 + x519
    x521 = x21 * x384 + x520
    x522 = x21 * x385 + x521
    x523 = x377 + x516 * x9
    x524 = x12 * x509 + x303
    x525 = x181 * x524
    x526 = x22 * x340 + x525
    x527 = x21 * x394 + x526
    x528 = x21 * x395 + x527
    x529 = x12 * x516 + x320
    x530 = x54 * (x378 * x68 + x518 * x89)
    x531 = x22 * x346 + x530
    x532 = x21 * x402 + x531
    x533 = x21 * x403 + x532
    x534 = x388 * x68
    x535 = x54 * (x524 * x89 + x534)
    x536 = x22 * x352 + x535
    x537 = x21 * x408 + x536
    x538 = x21 * x409 + x537
    x539 = x54 * (x100 * x524 + x336)
    x540 = x22 * x358 + x539
    x541 = x21 * x414 + x540
    x542 = x21 * x415 + x541
    x543 = x132 * x417 - x420 * x9
    x544 = x158 * x543
    x545 = x22 * x371 + x544
    x546 = x22 * x372 + x545
    x547 = x21 * x429 + x546
    x548 = x543 * x6
    x549 = x132 * x419 - x316 * x432
    x550 = x5 * x543 - x549 * x83
    x551 = x418 + x543 * x9
    x552 = x181 * x551
    x553 = x22 * x383 + x552
    x554 = x22 * x384 + x553
    x555 = x21 * x443 + x554
    x556 = x435 + x550 * x9
    x557 = x12 * x543 + x517
    x558 = x181 * x557
    x559 = x22 * x393 + x558
    x560 = x22 * x394 + x559
    x561 = x21 * x452 + x560
    x562 = x12 * x550 + x377
    x563 = x54 * (x437 + x551 * x89)
    x564 = x22 * x401 + x563
    x565 = x22 * x402 + x564
    x566 = x21 * x459 + x565
    x567 = x54 * (x445 + x557 * x89)
    x568 = x22 * x407 + x567
    x569 = x22 * x408 + x568
    x570 = x21 * x465 + x569
    x571 = x54 * (x100 * x557 + x534)
    x572 = x22 * x413 + x571
    x573 = x22 * x414 + x572
    x574 = x21 * x471 + x573
    x575 = -x12 * x420 + x221 * x417 + 2.0 * x226
    x576 = x158 * x575
    x577 = x22 * x427 + x576
    x578 = x22 * x428 + x577
    x579 = x22 * x429 + x578
    x580 = x575 * x6
    x581 = x221 * x419 + 2.0 * x250 - x431 * x432
    x582 = x5 * x575 - x581 * x83
    x583 = x4 * x582
    x584 = x262 * x575
    x585 = x22 * x441 + x584
    x586 = x22 * x442 + x585
    x587 = x22 * x443 + x586
    x588 = x580 * x89
    x589 = x12 * x575 + 3.0 * x418
    x590 = x181 * x589
    x591 = x22 * x450 + x590
    x592 = x22 * x451 + x591
    x593 = x22 * x452 + x592
    x594 = x589 * x88
    x595 = x12 * x582 + 3.0 * x435
    x596 = x109 * x575
    x597 = x22 * x457 + x596
    x598 = x22 * x458 + x597
    x599 = x22 * x459 + x598
    x600 = x116 * x589
    x601 = x22 * x463 + x600
    x602 = x22 * x464 + x601
    x603 = x22 * x465 + x602
    x604 = x54 * (x100 * x589 + x444 * x61)
    x605 = x22 * x469 + x604
    x606 = x22 * x470 + x605
    x607 = x22 * x471 + x606
    x608 = x132 * x472 + 3.0 * x315 - x316 * x478
    x609 = x608 * x9
    x610 = 4.0 * x477
    x611 = x609 + x610
    x612 = x132 * x509 - x316 * x515 + 2.0 * x374
    x613 = 3.0 * x514 + x612 * x9
    x614 = x12 * x612 + x477
    x615 = x132 * x543 - x316 * x549 + x430
    x616 = 2.0 * x548 + x615 * x9
    x617 = x12 * x615 + 2.0 * x514
    x618 = x132 * x575 - x316 * x581
    x619 = x580 + x618 * x9
    x620 = x12 * x618 + 3.0 * x548
    x621 = x221 * x575 + 3.0 * x430 - x431 * x581
    x622 = x12 * x621 + 4.0 * x580

    # 90 item(s)
    return numpy.array(
        [
            x0 * x62
            + x0 * x70
            + x0 * x76
            + x0 * (x0 * (x0 * (x7 * x79 + x74) + x75) + x76)
            + x54 * (4.0 * x53 * x88 + x55 * (x85 + x87)),
            x0 * x90
            + x0 * x92
            + x0 * x97
            + x0 * (x0 * (x0 * (x9 * x99 + x95) + x96) + x97)
            + x54 * (x85 * x89 + x87 * x89),
            x0 * x101
            + x0 * x103
            + x0 * x107
            + x0 * (x0 * (x0 * (x105 + x12 * x99) + x106) + x107)
            + x54 * (x100 * x85 + x100 * x87),
            x0 * x110
            + x0 * x112
            + x0 * x115
            + x0 * (x0 * (x0 * (x10 * x79 + x113) + x114) + x115)
            + x109 * x84,
            x0 * x118
            + x0 * x120
            + x0 * x123
            + x0 * (x0 * (x0 * (x121 + x124 * x79) + x122) + x123)
            + x117 * x84,
            x0 * x126
            + x0 * x128
            + x0 * x131
            + x0 * (x0 * (x0 * (x129 + x13 * x79) + x130) + x131)
            + x125 * x84,
            x0 * x154
            + x0 * x157
            + x0 * (x0 * (x0 * x161 + x156) + x157)
            + x21 * x62
            + x54 * (x149 * x61 + x55 * (x165 + x167)),
            x0 * x174
            + x0 * x180
            + x0 * (x0 * (x0 * x184 + x179) + x180)
            + x21 * x90
            + x54 * (x169 * x61 + x186 * x55),
            x0 * x189
            + x0 * x193
            + x0 * (x0 * (x0 * x196 + x192) + x193)
            + x101 * x21
            + x54 * (x100 * x165 + x100 * x167),
            x0 * x198
            + x0 * x201
            + x0 * (x0 * (x0 * x203 + x200) + x201)
            + x110 * x21
            + x54 * (x186 * x89 + x86 * x89),
            x0 * x206
            + x0 * x210
            + x0 * (x0 * (x0 * x212 + x209) + x210)
            + x118 * x21
            + x54 * (x100 * x185 + x213),
            x0 * x215
            + x0 * x218
            + x0 * (x0 * (x0 * x220 + x217) + x218)
            + x125 * x164
            + x126 * x21,
            x0 * x243
            + x0 * x246
            + x0 * (x0 * (x0 * x249 + x245) + x246)
            + x22 * x62
            + x54 * (x238 * x61 + x55 * (x253 + x255)),
            x0 * x257
            + x0 * x261
            + x0 * (x0 * (x0 * x265 + x260) + x261)
            + x22 * x90
            + x54 * (x253 * x89 + x255 * x89),
            x0 * x270
            + x0 * x276
            + x0 * (x0 * (x0 * x278 + x275) + x276)
            + x101 * x22
            + x54 * (x266 * x61 + x279 * x55),
            x0 * x281
            + x0 * x284
            + x0 * (x0 * (x0 * x286 + x283) + x284)
            + x109 * x252
            + x110 * x22,
            x0 * x288
            + x0 * x291
            + x0 * (x0 * (x0 * x293 + x290) + x291)
            + x116 * x279
            + x118 * x22,
            x0 * x295
            + x0 * x298
            + x0 * (x0 * (x0 * x300 + x297) + x298)
            + x126 * x22
            + x54 * (x100 * x279 + x213),
            x0 * x311
            + x0 * (x0 * x314 + x311)
            + x153 * x21
            + x154 * x21
            + x54 * (x308 * x68 + x55 * (x319 + x321)),
            x0 * x329
            + x0 * (x0 * x332 + x329)
            + x173 * x21
            + x174 * x21
            + x54 * (x326 * x68 + x335 * x55),
            x0 * x339
            + x0 * (x0 * x342 + x339)
            + x188 * x21
            + x189 * x21
            + x54 * (x100 * x319 + x100 * x321),
            x0 * x345
            + x0 * (x0 * x348 + x345)
            + x197 * x21
            + x198 * x21
            + x54 * (x169 * x68 + x335 * x89),
            x0 * x351
            + x0 * (x0 * x354 + x351)
            + x205 * x21
            + x206 * x21
            + x54 * (x100 * x333 + x100 * x334),
            x0 * x357 + x0 * (x0 * x360 + x357) + x125 * x318 + x21 * x214 + x21 * x215,
            x0 * x370
            + x0 * (x0 * x373 + x370)
            + x153 * x22
            + x21 * x243
            + x54 * (x367 * x68 + x55 * (x376 * x4 + x377)),
            x0 * x382
            + x0 * (x0 * x385 + x382)
            + x173 * x22
            + x21 * x257
            + x54 * (x386 * x55 + x387),
            x0 * x392
            + x0 * (x0 * x395 + x392)
            + x188 * x22
            + x21 * x270
            + x54 * (x396 * x55 + x397),
            x0 * x400
            + x0 * (x0 * x403 + x400)
            + x197 * x22
            + x21 * x281
            + x54 * (x254 * x89 + x386 * x89),
            x0 * x406
            + x0 * (x0 * x409 + x406)
            + x205 * x22
            + x21 * x288
            + x54 * (x266 * x88 + x396 * x89),
            x0 * x412
            + x0 * (x0 * x415 + x412)
            + x21 * x295
            + x214 * x22
            + x54 * (x100 * x166 + x100 * x396),
            x0 * x426
            + x0 * (x0 * x429 + x426)
            + x22 * x242
            + x22 * x243
            + x54 * (x423 * x68 + x55 * (x434 + x436)),
            x0 * x440
            + x0 * (x0 * x443 + x440)
            + x22 * x256
            + x22 * x257
            + x54 * (x434 * x89 + x436 * x89),
            x0 * x449
            + x0 * (x0 * x452 + x449)
            + x22 * x269
            + x22 * x270
            + x54 * (x446 * x68 + x453 * x55),
            x0 * x456 + x0 * (x0 * x459 + x456) + x109 * x433 + x22 * x280 + x22 * x281,
            x0 * x462 + x0 * (x0 * x465 + x462) + x116 * x453 + x22 * x287 + x22 * x288,
            x0 * x468
            + x0 * (x0 * x471 + x468)
            + x22 * x294
            + x22 * x295
            + x54 * (x100 * x453 + x266 * x68),
            x0 * x476
            + x21 * x309
            + x21 * x310
            + x21 * x311
            + x54 * (x477 * x55 + x55 * (x477 + x480)),
            x0 * x487 + x21 * x327 + x21 * x328 + x21 * x329 + x54 * (x488 + x491 * x55),
            x0 * x495 + x21 * x337 + x21 * x338 + x21 * x339 + x54 * (x100 * x480 + x496),
            x0 * x500
            + x21 * x343
            + x21 * x344
            + x21 * x345
            + x54 * (x326 * x61 + x491 * x89),
            x0 * x504
            + x21 * x349
            + x21 * x350
            + x21 * x351
            + x54 * (x100 * x489 + x100 * x490),
            x0 * x508 + x125 * x479 + x21 * x355 + x21 * x356 + x21 * x357,
            x0 * x513
            + x21 * x369
            + x21 * x370
            + x22 * x309
            + x54 * (x514 * x55 + x55 * (x4 * x516 + x514)),
            x0 * x522
            + x21 * x381
            + x21 * x382
            + x22 * x327
            + x54 * (x518 * x88 + x523 * x55),
            x0 * x528
            + x21 * x391
            + x21 * x392
            + x22 * x337
            + x54 * (x524 * x88 + x529 * x55),
            x0 * x533 + x21 * x399 + x21 * x400 + x22 * x343 + x54 * (x387 + x523 * x89),
            x0 * x538 + x21 * x405 + x21 * x406 + x22 * x349 + x54 * (x397 + x529 * x89),
            x0 * x542
            + x21 * x411
            + x21 * x412
            + x22 * x355
            + x54 * (x100 * x320 + x100 * x529),
            x0 * x547
            + x21 * x426
            + x22 * x368
            + x22 * x369
            + x54 * (x548 * x55 + x55 * (x4 * x550 + x548)),
            x0 * x555
            + x21 * x440
            + x22 * x380
            + x22 * x381
            + x54 * (x55 * x556 + x551 * x88),
            x0 * x561
            + x21 * x449
            + x22 * x390
            + x22 * x391
            + x54 * (x55 * x562 + x557 * x88),
            x0 * x566
            + x21 * x456
            + x22 * x398
            + x22 * x399
            + x54 * (x435 * x89 + x556 * x89),
            x0 * x570
            + x21 * x462
            + x22 * x404
            + x22 * x405
            + x54 * (x446 * x88 + x562 * x89),
            x0 * x574 + x21 * x468 + x22 * x410 + x22 * x411 + x54 * (x100 * x562 + x397),
            x0 * x579
            + x22 * x424
            + x22 * x425
            + x22 * x426
            + x54 * (x55 * x580 + x55 * (x580 + x583)),
            x0 * x587 + x22 * x438 + x22 * x439 + x22 * x440 + x54 * (x583 * x89 + x588),
            x0 * x593 + x22 * x447 + x22 * x448 + x22 * x449 + x54 * (x55 * x595 + x594),
            x0 * x599 + x109 * x582 + x22 * x454 + x22 * x455 + x22 * x456,
            x0 * x603 + x116 * x595 + x22 * x460 + x22 * x461 + x22 * x462,
            x0 * x607
            + x22 * x466
            + x22 * x467
            + x22 * x468
            + x54 * (x100 * x595 + x446 * x61),
            x158 * x608 + x21 * x473 + x21 * x474 + x21 * x475 + x21 * x476,
            x181 * x611 + x21 * x484 + x21 * x485 + x21 * x486 + x21 * x487,
            x194 * x608 + x21 * x492 + x21 * x493 + x21 * x494 + x21 * x495,
            x21 * x497
            + x21 * x498
            + x21 * x499
            + x21 * x500
            + x54 * (4.0 * x488 + x611 * x89),
            x21 * x501
            + x21 * x502
            + x21 * x503
            + x21 * x504
            + x54 * (x100 * x609 + x100 * x610),
            x125 * x608 + x21 * x505 + x21 * x506 + x21 * x507 + x21 * x508,
            x158 * x612 + x21 * x511 + x21 * x512 + x21 * x513 + x22 * x473,
            x181 * x613 + x21 * x520 + x21 * x521 + x21 * x522 + x22 * x484,
            x181 * x614 + x21 * x526 + x21 * x527 + x21 * x528 + x22 * x492,
            x21 * x531
            + x21 * x532
            + x21 * x533
            + x22 * x497
            + x54 * (x518 * x61 + x613 * x89),
            x21 * x536
            + x21 * x537
            + x21 * x538
            + x22 * x501
            + x54 * (x524 * x61 + x614 * x89),
            x21 * x540
            + x21 * x541
            + x21 * x542
            + x22 * x505
            + x54 * (x100 * x614 + x496),
            x158 * x615 + x21 * x546 + x21 * x547 + x22 * x510 + x22 * x511,
            x181 * x616 + x21 * x554 + x21 * x555 + x22 * x519 + x22 * x520,
            x181 * x617 + x21 * x560 + x21 * x561 + x22 * x525 + x22 * x526,
            x21 * x565
            + x21 * x566
            + x22 * x530
            + x22 * x531
            + x54 * (x551 * x68 + x616 * x89),
            x21 * x569
            + x21 * x570
            + x22 * x535
            + x22 * x536
            + x54 * (x557 * x68 + x617 * x89),
            x21 * x573
            + x21 * x574
            + x22 * x539
            + x22 * x540
            + x54 * (x100 * x617 + x524 * x68),
            x158 * x618 + x21 * x579 + x22 * x544 + x22 * x545 + x22 * x546,
            x181 * x619 + x21 * x587 + x22 * x552 + x22 * x553 + x22 * x554,
            x181 * x620 + x21 * x593 + x22 * x558 + x22 * x559 + x22 * x560,
            x21 * x599 + x22 * x563 + x22 * x564 + x22 * x565 + x54 * (x588 + x619 * x89),
            x21 * x603 + x22 * x567 + x22 * x568 + x22 * x569 + x54 * (x594 + x620 * x89),
            x21 * x607
            + x22 * x571
            + x22 * x572
            + x22 * x573
            + x54 * (x100 * x620 + x557 * x61),
            x158 * x621 + x22 * x576 + x22 * x577 + x22 * x578 + x22 * x579,
            x22 * x584 + x22 * x585 + x22 * x586 + x22 * x587 + x262 * x621,
            x181 * x622 + x22 * x590 + x22 * x591 + x22 * x592 + x22 * x593,
            x109 * x621 + x22 * x596 + x22 * x597 + x22 * x598 + x22 * x599,
            x116 * x622 + x22 * x600 + x22 * x601 + x22 * x602 + x22 * x603,
            x22 * x604
            + x22 * x605
            + x22 * x606
            + x22 * x607
            + x54 * (x100 * x622 + 4.0 * x594),
        ]
    )


def _3center2el3d_sph_043(a, A, b, B, c, C):
    """Cartesian (sg|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = x4**2
    x8 = -x2 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x2 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x1
    x15 = x14 ** (-1.0)
    x16 = c * x15
    x17 = x1 * x16 * (x10 + x13 + x7)
    x18 = boys(4, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x0**2 + x21**2 + x22**2))
    x24 = x20 * x23
    x25 = x2 * x24
    x26 = 2.0 * x19 * x25
    x27 = x18 * x26
    x28 = c ** (-1.0)
    x29 = x14 ** (-0.5)
    x30 = boys(3, x17)
    x31 = 2.0 * x2 * x20 * x23 * x28 * x29 * x30 - x27
    x32 = x31 * x6
    x33 = -2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x5 + x27 * x4
    x34 = -x33
    x35 = boys(5, x17)
    x36 = x26 * x35
    x37 = -2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x5 + x36 * x4
    x38 = -x37
    x39 = x16 * x38
    x40 = x39 * x4
    x41 = x32 + x34 * x5 - x40
    x42 = 2.0 * x6
    x43 = x6 * (2.0 * x18 * x2 * x20 * x23 * x28 * x29 - x36)
    x44 = boys(6, x17)
    x45 = x26 * x44
    x46 = 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x5 - x4 * x45
    x47 = x16 * x46
    x48 = x38 * x5 - x4 * x47 + x43
    x49 = x16 * x48
    x50 = -x4 * x49 + x41 * x5 + x42 * (-x33 - x39)
    x51 = x4 * x50
    x52 = x41 * x6
    x53 = 3.0 * x52
    x54 = x51 + x53
    x55 = x1 * x15
    x56 = x4 * x55
    x57 = x4 * x41
    x58 = x34 * x6
    x59 = 2.0 * x58
    x60 = x57 + x59
    x61 = 3.0 * x6
    x62 = x55 * x61
    x63 = x54 * x56 + x60 * x62
    x64 = x34 * x4
    x65 = x28 * x30
    x66 = x42 * x65
    x67 = x25 * x29 * x66
    x68 = x64 + x67
    x69 = x42 * x55
    x70 = x56 * x60 + x68 * x69
    x71 = x55 * (x56 * x63 + x62 * x70)
    x72 = x24 * x66
    x73 = x19 * x72
    x74 = x4 * x73 + x56 * x68
    x75 = x55 * (x56 * x70 + x69 * x74)
    x76 = x0 * x75 + x71
    x77 = x1 * x14 ** (-2.5) * x72
    x78 = x55 * (x56 * x74 + x7 * x77)
    x79 = x0 * x78 + x75
    x80 = x0 * x79 + x76
    x81 = x4**3
    x82 = x1**2
    x83 = 2.0 * x14 ** (-3.5) * x24 * x65 * x82
    x84 = x0 * x83
    x85 = -x31 * x6
    x86 = x6 * (2.0 * x2 * x20 * x23 * x28 * x29 * x35 - x45)
    x87 = x26 * boys(7, x17)
    x88 = x16 * x4
    x89 = (
        x5 * x50
        + x61 * (x34 * x5 - x40 - x49 - x85)
        - x88
        * (
            x42 * (-x37 - x47)
            + x48 * x5
            - x88
            * (
                x46 * x5
                + x86
                - x88 * (2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x5 - x4 * x87)
            )
        )
    )
    x90 = x4 * x89
    x91 = x50 * x6
    x92 = 4.0 * x91
    x93 = x55 * x6
    x94 = 4.0 * x93
    x95 = x55 * x9
    x96 = x51 * x95 + x53 * x95
    x97 = x57 * x95 + x59 * x95
    x98 = x55 * (x56 * x96 + x62 * x97)
    x99 = x73 * x9
    x100 = x64 * x95 + x99
    x101 = x55 * (x100 * x69 + x56 * x97)
    x102 = x0 * x101 + x98
    x103 = x4 * x9
    x104 = x55 * (x100 * x56 + x103 * x77)
    x105 = x0 * x104 + x101
    x106 = x0 * x105 + x102
    x107 = x7 * x84
    x108 = x12 * x55
    x109 = x108 * x51 + x108 * x53
    x110 = x108 * x57 + x108 * x59
    x111 = x55 * (x109 * x56 + x110 * x62)
    x112 = x12 * x73
    x113 = x108 * x64 + x112
    x114 = x55 * (x110 * x56 + x113 * x69)
    x115 = x0 * x114 + x111
    x116 = x12 * x77
    x117 = x55 * (x113 * x56 + x116 * x4)
    x118 = x0 * x117 + x114
    x119 = x0 * x118 + x115
    x120 = x82 / x14**2
    x121 = x10 * x120
    x122 = x55 * (x121 * x51 + x121 * x53)
    x123 = x55 * (x121 * x57 + x121 * x59)
    x124 = x0 * x123 + x122
    x125 = x10 * x77
    x126 = x55 * (x121 * x64 + x125)
    x127 = x0 * x126 + x123
    x128 = x0 * x127 + x124
    x129 = x4 * x84
    x130 = x120 * x9
    x131 = x12 * x130
    x132 = x55 * (x131 * x51 + x131 * x53)
    x133 = x55 * (x131 * x57 + x131 * x59)
    x134 = x0 * x133 + x132
    x135 = x116 * x9
    x136 = x55 * (x131 * x64 + x135)
    x137 = x0 * x136 + x133
    x138 = x0 * x137 + x134
    x139 = x103 * x12
    x140 = x120 * x13
    x141 = x55 * (x140 * x51 + x140 * x53)
    x142 = x55 * (x140 * x57 + x140 * x59)
    x143 = x0 * x142 + x141
    x144 = x13 * x77
    x145 = x55 * (x140 * x64 + x144)
    x146 = x0 * x145 + x142
    x147 = x0 * x146 + x143
    x148 = x9**3
    x149 = x1**3 / x14**3
    x150 = x148 * x149
    x151 = x150 * x50
    x152 = x150 * x41
    x153 = x0 * x152 + x151
    x154 = x150 * x34
    x155 = x0 * x154 + x152
    x156 = x0 * x155 + x153
    x157 = x10 * x149
    x158 = x12 * x157
    x159 = x158 * x50
    x160 = x158 * x41
    x161 = x0 * x160 + x159
    x162 = x158 * x34
    x163 = x0 * x162 + x160
    x164 = x0 * x163 + x161
    x165 = x10 * x12
    x166 = x13 * x149
    x167 = x166 * x9
    x168 = x167 * x50
    x169 = x167 * x41
    x170 = x0 * x169 + x168
    x171 = x167 * x34
    x172 = x0 * x171 + x169
    x173 = x0 * x172 + x170
    x174 = x13 * x9
    x175 = x12**3
    x176 = x149 * x175
    x177 = x176 * x50
    x178 = x176 * x41
    x179 = x0 * x178 + x177
    x180 = x176 * x34
    x181 = x0 * x180 + x178
    x182 = x0 * x181 + x179
    x183 = -x8 - A[1]
    x184 = -2.0 * x18 * x183 * x2 * x20 * x23 * x28 * x29 + x36 * x9
    x185 = -x184
    x186 = x16 * x185
    x187 = -2.0 * x183 * x2 * x20 * x23 * x28 * x29 * x30 + x27 * x9
    x188 = x6 * (-x186 - x187)
    x189 = -x187
    x190 = x186 * x4 - x189 * x5
    x191 = -x190
    x192 = 2.0 * x183 * x2 * x20 * x23 * x28 * x29 * x35 - x45 * x9
    x193 = x16 * x192
    x194 = x185 * x5 - x193 * x4
    x195 = x16 * x194
    x196 = x188 + x191 * x5 - x195 * x4
    x197 = x196 * x4
    x198 = x191 * x6
    x199 = 2.0 * x198
    x200 = x197 + x199
    x201 = x189 * x6
    x202 = x191 * x4
    x203 = x201 + x202
    x204 = x200 * x56 + x203 * x69
    x205 = x201 * x56 + x203 * x56
    x206 = x55 * (x204 * x56 + x205 * x69)
    x207 = x206 + x21 * x75
    x208 = x120 * x7
    x209 = x55 * (x201 * x208 + x205 * x56)
    x210 = x209 + x21 * x78
    x211 = x0 * x210 + x207
    x212 = x149 * x81
    x213 = x189 * x212
    x214 = x21 * x83
    x215 = x213 + x214 * x81
    x216 = x6 * (-x184 - x193)
    x217 = 2.0 * x183 * x2 * x20 * x23 * x28 * x29 * x44 - x87 * x9
    x218 = (
        x196 * x5
        + x42 * (-x190 - x195)
        - x88 * (x194 * x5 + x216 - x88 * (x192 * x5 - x217 * x88))
    )
    x219 = x218 * x4
    x220 = x196 * x6
    x221 = 3.0 * x220
    x222 = x196 * x9
    x223 = x222 + x52
    x224 = x191 * x9
    x225 = x224 + x58
    x226 = x225 * x69
    x227 = x223 * x56 + x226
    x228 = x189 * x9
    x229 = x228 + x67
    x230 = x229 * x55
    x231 = x225 * x56 + x230 * x6
    x232 = x55 * (x227 * x56 + x231 * x69)
    x233 = x101 * x21 + x232
    x234 = x120 * x4
    x235 = x234 * x6
    x236 = x55 * (x229 * x235 + x231 * x56)
    x237 = x104 * x21 + x236
    x238 = x0 * x237 + x233
    x239 = x149 * x7
    x240 = x229 * x239
    x241 = x214 * x7
    x242 = x240 + x241 * x9
    x243 = x218 * x9
    x244 = x243 + x91
    x245 = x108 * x199
    x246 = x108 * x197 + x245
    x247 = x108 * x201
    x248 = x108 * x202 + x247
    x249 = x55 * (x246 * x56 + x248 * x69)
    x250 = x114 * x21 + x249
    x251 = x12 * x234
    x252 = x55 * (x201 * x251 + x248 * x56)
    x253 = x117 * x21 + x252
    x254 = x0 * x253 + x250
    x255 = x12 * x239
    x256 = x189 * x255
    x257 = x12 * x241 + x256
    x258 = x223 * x95 + x52 * x95
    x259 = x225 * x95 + x58 * x95
    x260 = x259 * x69
    x261 = x55 * (x258 * x56 + x260)
    x262 = x123 * x21 + x261
    x263 = x230 * x9 + x99
    x264 = x55 * (x259 * x56 + x263 * x93)
    x265 = x126 * x21 + x264
    x266 = x0 * x265 + x262
    x267 = x234 * x263
    x268 = x214 * x4
    x269 = x10 * x268 + x267
    x270 = x244 * x95 + x91 * x95
    x271 = x108 * x52
    x272 = x108 * x222 + x271
    x273 = x108 * x58
    x274 = x108 * x224 + x273
    x275 = x274 * x69
    x276 = x55 * (x272 * x56 + x275)
    x277 = x133 * x21 + x276
    x278 = x108 * x228 + x112
    x279 = x55 * (x274 * x56 + x278 * x93)
    x280 = x136 * x21 + x279
    x281 = x0 * x280 + x277
    x282 = x234 * x278
    x283 = x139 * x214 + x282
    x284 = x108 * x91
    x285 = x108 * x243 + x284
    x286 = x140 * x199
    x287 = x55 * (x140 * x197 + x286)
    x288 = x142 * x21 + x287
    x289 = x140 * x201
    x290 = x55 * (x140 * x202 + x289)
    x291 = x145 * x21 + x290
    x292 = x0 * x291 + x288
    x293 = x166 * x4
    x294 = x189 * x293
    x295 = x13 * x268 + x294
    x296 = x55 * (x121 * x52 + x258 * x95)
    x297 = x152 * x21 + x296
    x298 = x55 * (x121 * x58 + x259 * x95)
    x299 = x154 * x21 + x298
    x300 = x0 * x299 + x297
    x301 = x55 * (x125 + x263 * x95)
    x302 = x148 * x214 + x301
    x303 = x55 * (x131 * x52 + x272 * x95)
    x304 = x160 * x21 + x303
    x305 = x55 * (x131 * x58 + x274 * x95)
    x306 = x162 * x21 + x305
    x307 = x0 * x306 + x304
    x308 = x55 * (x135 + x278 * x95)
    x309 = x165 * x214 + x308
    x310 = x140 * x52
    x311 = x55 * (x140 * x222 + x310)
    x312 = x169 * x21 + x311
    x313 = x140 * x58
    x314 = x55 * (x140 * x224 + x313)
    x315 = x171 * x21 + x314
    x316 = x0 * x315 + x312
    x317 = x55 * (x140 * x228 + x144)
    x318 = x174 * x214 + x317
    x319 = x140 * x91
    x320 = x176 * x196
    x321 = x178 * x21 + x320
    x322 = x176 * x191
    x323 = x180 * x21 + x322
    x324 = x0 * x323 + x321
    x325 = x176 * x189
    x326 = x175 * x214 + x325
    x327 = -x11 - A[2]
    x328 = x12 * x36 - 2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x327
    x329 = -x328
    x330 = x16 * x329
    x331 = x12 * x27 - 2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x327
    x332 = x6 * (-x330 - x331)
    x333 = -x331
    x334 = x330 * x4 - x333 * x5
    x335 = -x334
    x336 = -x12 * x45 + 2.0 * x2 * x20 * x23 * x28 * x29 * x327 * x35
    x337 = x16 * x336
    x338 = x329 * x5 - x337 * x4
    x339 = x16 * x338
    x340 = x332 + x335 * x5 - x339 * x4
    x341 = x340 * x4
    x342 = x335 * x6
    x343 = 2.0 * x342
    x344 = x341 + x343
    x345 = x333 * x6
    x346 = x335 * x4
    x347 = x345 + x346
    x348 = x344 * x56 + x347 * x69
    x349 = x345 * x56 + x347 * x56
    x350 = x55 * (x348 * x56 + x349 * x69)
    x351 = x22 * x75 + x350
    x352 = x55 * (x208 * x345 + x349 * x56)
    x353 = x22 * x78 + x352
    x354 = x0 * x353 + x351
    x355 = x212 * x333
    x356 = x22 * x83
    x357 = x355 + x356 * x81
    x358 = x6 * (-x328 - x337)
    x359 = -x12 * x87 + 2.0 * x2 * x20 * x23 * x28 * x29 * x327 * x44
    x360 = (
        x340 * x5
        + x42 * (-x334 - x339)
        - x88 * (x338 * x5 + x358 - x88 * (x336 * x5 - x359 * x88))
    )
    x361 = x360 * x4
    x362 = x340 * x6
    x363 = 3.0 * x362
    x364 = x341 * x95 + x343 * x95
    x365 = x345 * x95
    x366 = x346 * x95 + x365
    x367 = x55 * (x364 * x56 + x366 * x69)
    x368 = x101 * x22 + x367
    x369 = x234 * x9
    x370 = x55 * (x345 * x369 + x366 * x56)
    x371 = x104 * x22 + x370
    x372 = x0 * x371 + x368
    x373 = x239 * x9
    x374 = x333 * x373
    x375 = x356 * x7
    x376 = x374 + x375 * x9
    x377 = x12 * x340 + x52
    x378 = x12 * x335 + x58
    x379 = x378 * x69
    x380 = x377 * x56 + x379
    x381 = x12 * x333 + x67
    x382 = x381 * x93
    x383 = x378 * x56 + x382
    x384 = x55 * (x380 * x56 + x383 * x69)
    x385 = x114 * x22 + x384
    x386 = x55 * (x235 * x381 + x383 * x56)
    x387 = x117 * x22 + x386
    x388 = x0 * x387 + x385
    x389 = x239 * x381
    x390 = x12 * x375 + x389
    x391 = x12 * x360 + x91
    x392 = x55 * (x121 * x341 + x121 * x343)
    x393 = x123 * x22 + x392
    x394 = x121 * x345
    x395 = x55 * (x121 * x346 + x394)
    x396 = x126 * x22 + x395
    x397 = x0 * x396 + x393
    x398 = x157 * x4
    x399 = x333 * x398
    x400 = x356 * x4
    x401 = x10 * x400 + x399
    x402 = x130 * x42
    x403 = x55 * (x369 * x377 + x378 * x402)
    x404 = x133 * x22 + x403
    x405 = x130 * x6
    x406 = x381 * x405
    x407 = x55 * (x369 * x378 + x406)
    x408 = x136 * x22 + x407
    x409 = x0 * x408 + x404
    x410 = x103 * x149
    x411 = x381 * x410
    x412 = x139 * x356 + x411
    x413 = x108 * x377 + x271
    x414 = x108 * x378 + x273
    x415 = x414 * x69
    x416 = x55 * (x413 * x56 + x415)
    x417 = x142 * x22 + x416
    x418 = x108 * x381 + x112
    x419 = x418 * x93
    x420 = x55 * (x414 * x56 + x419)
    x421 = x145 * x22 + x420
    x422 = x0 * x421 + x417
    x423 = x234 * x418
    x424 = x13 * x400 + x423
    x425 = x108 * x391 + x284
    x426 = x150 * x340
    x427 = x152 * x22 + x426
    x428 = x150 * x335
    x429 = x154 * x22 + x428
    x430 = x0 * x429 + x427
    x431 = x150 * x333
    x432 = x148 * x356 + x431
    x433 = x157 * x377
    x434 = x160 * x22 + x433
    x435 = x157 * x378
    x436 = x162 * x22 + x435
    x437 = x0 * x436 + x434
    x438 = x157 * x381
    x439 = x165 * x356 + x438
    x440 = x130 * x413
    x441 = x169 * x22 + x440
    x442 = x130 * x414
    x443 = x171 * x22 + x442
    x444 = x0 * x443 + x441
    x445 = x130 * x418
    x446 = x174 * x356 + x445
    x447 = x55 * (x108 * x413 + x310)
    x448 = x178 * x22 + x447
    x449 = x55 * (x108 * x414 + x313)
    x450 = x180 * x22 + x449
    x451 = x0 * x450 + x448
    x452 = x55 * (x108 * x418 + x144)
    x453 = x175 * x356 + x452
    x454 = x186 * x9
    x455 = x183 * x189 + x32 - x454
    x456 = x455 * x6
    x457 = x183 * x185 - x193 * x9 + x43
    x458 = x16 * x457
    x459 = -x4 * x458 + x455 * x5
    x460 = x4 * x459
    x461 = x456 + x460
    x462 = x456 * x56 + x461 * x56
    x463 = x55 * (x208 * x456 + x462 * x56)
    x464 = x209 * x21 + x463
    x465 = x21 * x210 + x464
    x466 = x212 * x455
    x467 = x21 * x213 + x466
    x468 = x21 * x215 + x467
    x469 = x6 * (x183 * x189 - x454 - x458 - x85)
    x470 = x16 * x9
    x471 = x183 * x192 - x217 * x470 + x86
    x472 = x459 * x5 + x469 - x88 * (x457 * x5 - x471 * x88)
    x473 = x4 * x472
    x474 = x459 * x6
    x475 = 2.0 * x474
    x476 = x455 * x9
    x477 = 2.0 * x201
    x478 = x476 + x477
    x479 = x459 * x9
    x480 = x199 + x479
    x481 = x478 * x93 + x480 * x56
    x482 = x55 * (x235 * x478 + x481 * x56)
    x483 = x21 * x236 + x482
    x484 = x21 * x237 + x483
    x485 = x239 * x478
    x486 = x21 * x240 + x485
    x487 = x21 * x242 + x486
    x488 = x472 * x9
    x489 = 2.0 * x220
    x490 = x488 + x489
    x491 = x108 * x456
    x492 = x108 * x460 + x491
    x493 = x55 * (x251 * x456 + x492 * x56)
    x494 = x21 * x252 + x493
    x495 = x21 * x253 + x494
    x496 = x255 * x455
    x497 = x21 * x256 + x496
    x498 = x21 * x257 + x497
    x499 = x230 * x42 + x478 * x95
    x500 = x226 + x480 * x95
    x501 = x55 * (x499 * x93 + x500 * x56)
    x502 = x21 * x264 + x501
    x503 = x21 * x265 + x502
    x504 = x234 * x499
    x505 = x21 * x267 + x504
    x506 = x21 * x269 + x505
    x507 = x223 * x69 + x490 * x95
    x508 = x108 * x476 + x108 * x477
    x509 = x108 * x479 + x245
    x510 = x55 * (x508 * x93 + x509 * x56)
    x511 = x21 * x279 + x510
    x512 = x21 * x280 + x511
    x513 = x234 * x508
    x514 = x21 * x282 + x513
    x515 = x21 * x283 + x514
    x516 = x108 * x488 + x108 * x489
    x517 = x140 * x456
    x518 = x55 * (x140 * x460 + x517)
    x519 = x21 * x290 + x518
    x520 = x21 * x291 + x519
    x521 = x293 * x455
    x522 = x21 * x294 + x521
    x523 = x21 * x295 + x522
    x524 = x55 * (x260 + x500 * x95)
    x525 = x21 * x298 + x524
    x526 = x21 * x299 + x525
    x527 = x55 * (x263 * x69 + x499 * x95)
    x528 = x21 * x301 + x527
    x529 = x21 * x302 + x528
    x530 = x55 * (x275 + x509 * x95)
    x531 = x21 * x305 + x530
    x532 = x21 * x306 + x531
    x533 = x55 * (x278 * x69 + x508 * x95)
    x534 = x21 * x308 + x533
    x535 = x21 * x309 + x534
    x536 = x55 * (x140 * x479 + x286)
    x537 = x21 * x314 + x536
    x538 = x21 * x315 + x537
    x539 = x55 * (x140 * x476 + x140 * x477)
    x540 = x21 * x317 + x539
    x541 = x21 * x318 + x540
    x542 = x176 * x459
    x543 = x21 * x322 + x542
    x544 = x21 * x323 + x543
    x545 = x176 * x455
    x546 = x21 * x325 + x545
    x547 = x21 * x326 + x546
    x548 = -x183 * x333 + x330 * x9
    x549 = -x548
    x550 = x549 * x6
    x551 = x183 * x329 - x337 * x9
    x552 = x16 * x551
    x553 = -x4 * x552 + x5 * x549
    x554 = x4 * x553 + x550
    x555 = x550 * x56 + x554 * x56
    x556 = x55 * (x208 * x550 + x555 * x56)
    x557 = x209 * x22 + x556
    x558 = x21 * x353 + x557
    x559 = x212 * x549
    x560 = x213 * x22 + x559
    x561 = x21 * x357 + x560
    x562 = x6 * (-x548 - x552)
    x563 = x183 * x336 - x359 * x470
    x564 = x5 * x553 + x562 - x88 * (x5 * x551 - x563 * x88)
    x565 = x42 * x553
    x566 = x345 + x549 * x9
    x567 = x342 + x553 * x9
    x568 = x56 * x567 + x566 * x93
    x569 = x55 * (x235 * x566 + x56 * x568)
    x570 = x22 * x236 + x569
    x571 = x21 * x371 + x570
    x572 = x239 * x566
    x573 = x22 * x240 + x572
    x574 = x21 * x376 + x573
    x575 = x362 + x564 * x9
    x576 = x567 * x69
    x577 = x12 * x549 + x201
    x578 = x12 * x553 + x198
    x579 = x56 * x578 + x577 * x93
    x580 = x55 * (x235 * x577 + x56 * x579)
    x581 = x22 * x252 + x580
    x582 = x21 * x387 + x581
    x583 = x239 * x577
    x584 = x22 * x256 + x583
    x585 = x21 * x390 + x584
    x586 = x12 * x564 + x220
    x587 = x578 * x69
    x588 = x365 + x566 * x95
    x589 = x342 * x95 + x567 * x95
    x590 = x55 * (x56 * x589 + x588 * x93)
    x591 = x22 * x264 + x590
    x592 = x21 * x396 + x591
    x593 = x234 * x588
    x594 = x22 * x267 + x593
    x595 = x21 * x401 + x594
    x596 = x362 * x95 + x575 * x95
    x597 = x589 * x69
    x598 = x382 + x577 * x95
    x599 = x378 * x93 + x578 * x95
    x600 = x55 * (x56 * x599 + x598 * x93)
    x601 = x22 * x279 + x600
    x602 = x21 * x408 + x601
    x603 = x234 * x598
    x604 = x22 * x282 + x603
    x605 = x21 * x412 + x604
    x606 = x377 * x93 + x586 * x95
    x607 = x599 * x69
    x608 = x108 * x577 + x247
    x609 = x108 * x198 + x108 * x578
    x610 = x55 * (x56 * x609 + x608 * x93)
    x611 = x22 * x290 + x610
    x612 = x21 * x421 + x611
    x613 = x234 * x608
    x614 = x22 * x294 + x613
    x615 = x21 * x424 + x614
    x616 = x108 * x220 + x108 * x586
    x617 = x609 * x69
    x618 = x55 * (x121 * x342 + x589 * x95)
    x619 = x22 * x298 + x618
    x620 = x21 * x429 + x619
    x621 = x55 * (x394 + x588 * x95)
    x622 = x22 * x301 + x621
    x623 = x21 * x432 + x622
    x624 = x55 * (x378 * x405 + x599 * x95)
    x625 = x22 * x305 + x624
    x626 = x21 * x436 + x625
    x627 = x55 * (x406 + x598 * x95)
    x628 = x22 * x308 + x627
    x629 = x21 * x439 + x628
    x630 = x55 * (x414 * x93 + x609 * x95)
    x631 = x22 * x314 + x630
    x632 = x21 * x443 + x631
    x633 = x55 * (x419 + x608 * x95)
    x634 = x22 * x317 + x633
    x635 = x21 * x446 + x634
    x636 = x55 * (x108 * x609 + x140 * x198)
    x637 = x22 * x322 + x636
    x638 = x21 * x450 + x637
    x639 = x55 * (x108 * x608 + x289)
    x640 = x22 * x325 + x639
    x641 = x21 * x453 + x640
    x642 = x12 * x330
    x643 = x32 + x327 * x333 - x642
    x644 = x6 * x643
    x645 = -x12 * x337 + x327 * x329 + x43
    x646 = x16 * x645
    x647 = -x4 * x646 + x5 * x643
    x648 = x4 * x647
    x649 = x644 + x648
    x650 = x56 * x644 + x56 * x649
    x651 = x55 * (x208 * x644 + x56 * x650)
    x652 = x22 * x352 + x651
    x653 = x22 * x353 + x652
    x654 = x212 * x643
    x655 = x22 * x355 + x654
    x656 = x22 * x357 + x655
    x657 = x6 * (x327 * x333 - x642 - x646 - x85)
    x658 = x12 * x16
    x659 = x327 * x336 - x359 * x658 + x86
    x660 = x5 * x647 + x657 - x88 * (x5 * x645 - x659 * x88)
    x661 = x4 * x660
    x662 = x6 * x647
    x663 = 2.0 * x662
    x664 = x644 * x95
    x665 = x648 * x95 + x664
    x666 = x55 * (x369 * x644 + x56 * x665)
    x667 = x22 * x370 + x666
    x668 = x22 * x371 + x667
    x669 = x373 * x643
    x670 = x22 * x374 + x669
    x671 = x22 * x376 + x670
    x672 = x12 * x643 + 2.0 * x345
    x673 = x672 * x93
    x674 = x12 * x647 + x343
    x675 = x56 * x674 + x673
    x676 = x55 * (x235 * x672 + x56 * x675)
    x677 = x22 * x386 + x676
    x678 = x22 * x387 + x677
    x679 = x239 * x672
    x680 = x22 * x389 + x679
    x681 = x22 * x390 + x680
    x682 = x12 * x660 + 2.0 * x362
    x683 = x121 * x644
    x684 = x55 * (x121 * x648 + x683)
    x685 = x22 * x395 + x684
    x686 = x22 * x396 + x685
    x687 = x398 * x643
    x688 = x22 * x399 + x687
    x689 = x22 * x401 + x688
    x690 = x405 * x672
    x691 = x55 * (x369 * x674 + x690)
    x692 = x22 * x407 + x691
    x693 = x22 * x408 + x692
    x694 = x410 * x672
    x695 = x22 * x411 + x694
    x696 = x22 * x412 + x695
    x697 = x108 * x672 + x381 * x69
    x698 = x697 * x93
    x699 = x108 * x674 + x379
    x700 = x55 * (x56 * x699 + x698)
    x701 = x22 * x420 + x700
    x702 = x22 * x421 + x701
    x703 = x234 * x697
    x704 = x22 * x423 + x703
    x705 = x22 * x424 + x704
    x706 = x108 * x682 + x377 * x69
    x707 = x150 * x647
    x708 = x22 * x428 + x707
    x709 = x22 * x429 + x708
    x710 = x150 * x643
    x711 = x22 * x431 + x710
    x712 = x22 * x432 + x711
    x713 = x157 * x674
    x714 = x22 * x435 + x713
    x715 = x22 * x436 + x714
    x716 = x157 * x672
    x717 = x22 * x438 + x716
    x718 = x22 * x439 + x717
    x719 = x130 * x699
    x720 = x22 * x442 + x719
    x721 = x22 * x443 + x720
    x722 = x130 * x697
    x723 = x22 * x445 + x722
    x724 = x22 * x446 + x723
    x725 = x55 * (x108 * x699 + x415)
    x726 = x22 * x449 + x725
    x727 = x22 * x450 + x726
    x728 = x55 * (x108 * x697 + x418 * x69)
    x729 = x22 * x452 + x728
    x730 = x22 * x453 + x729
    x731 = x183 * x455 + 2.0 * x188 - x458 * x9
    x732 = x212 * x731
    x733 = x21 * x466 + x732
    x734 = x21 * x467 + x733
    x735 = x21 * x468 + x734
    x736 = x6 * x731
    x737 = x183 * x457 + 2.0 * x216 - x470 * x471
    x738 = x5 * x731 - x737 * x88
    x739 = x4 * x738
    x740 = x731 * x9
    x741 = 3.0 * x456
    x742 = x740 + x741
    x743 = x239 * x742
    x744 = x21 * x485 + x743
    x745 = x21 * x486 + x744
    x746 = x21 * x487 + x745
    x747 = x742 * x93
    x748 = x738 * x9
    x749 = 3.0 * x474
    x750 = x748 + x749
    x751 = x255 * x731
    x752 = x21 * x496 + x751
    x753 = x21 * x497 + x752
    x754 = x21 * x498 + x753
    x755 = x108 * x736
    x756 = x478 * x62 + x742 * x95
    x757 = x234 * x756
    x758 = x21 * x504 + x757
    x759 = x21 * x505 + x758
    x760 = x21 * x506 + x759
    x761 = x756 * x93
    x762 = x480 * x62 + x750 * x95
    x763 = x108 * x740 + x108 * x741
    x764 = x234 * x763
    x765 = x21 * x513 + x764
    x766 = x21 * x514 + x765
    x767 = x21 * x515 + x766
    x768 = x763 * x93
    x769 = x108 * x748 + x108 * x749
    x770 = x293 * x731
    x771 = x21 * x521 + x770
    x772 = x21 * x522 + x771
    x773 = x21 * x523 + x772
    x774 = x140 * x736
    x775 = x55 * (x499 * x62 + x756 * x95)
    x776 = x21 * x527 + x775
    x777 = x21 * x528 + x776
    x778 = x21 * x529 + x777
    x779 = x55 * (x508 * x62 + x763 * x95)
    x780 = x21 * x533 + x779
    x781 = x21 * x534 + x780
    x782 = x21 * x535 + x781
    x783 = x55 * (x140 * x740 + x140 * x741)
    x784 = x21 * x539 + x783
    x785 = x21 * x540 + x784
    x786 = x21 * x541 + x785
    x787 = x176 * x731
    x788 = x21 * x545 + x787
    x789 = x21 * x546 + x788
    x790 = x21 * x547 + x789
    x791 = x183 * x549 + x332 - x552 * x9
    x792 = x212 * x791
    x793 = x22 * x466 + x792
    x794 = x21 * x560 + x793
    x795 = x21 * x561 + x794
    x796 = x6 * x791
    x797 = x183 * x551 + x358 - x470 * x563
    x798 = x5 * x791 - x797 * x88
    x799 = 2.0 * x550
    x800 = x791 * x9 + x799
    x801 = x239 * x800
    x802 = x22 * x485 + x801
    x803 = x21 * x573 + x802
    x804 = x21 * x574 + x803
    x805 = x565 + x798 * x9
    x806 = x12 * x791 + x456
    x807 = x239 * x806
    x808 = x22 * x496 + x807
    x809 = x21 * x584 + x808
    x810 = x21 * x585 + x809
    x811 = x12 * x798 + x474
    x812 = x566 * x69 + x800 * x95
    x813 = x234 * x812
    x814 = x22 * x504 + x813
    x815 = x21 * x594 + x814
    x816 = x21 * x595 + x815
    x817 = x576 + x805 * x95
    x818 = x577 * x69
    x819 = x806 * x95 + x818
    x820 = x234 * x819
    x821 = x22 * x513 + x820
    x822 = x21 * x604 + x821
    x823 = x21 * x605 + x822
    x824 = x587 + x811 * x95
    x825 = x108 * x806 + x491
    x826 = x234 * x825
    x827 = x22 * x521 + x826
    x828 = x21 * x614 + x827
    x829 = x21 * x615 + x828
    x830 = x108 * x474 + x108 * x811
    x831 = x55 * (x588 * x69 + x812 * x95)
    x832 = x22 * x527 + x831
    x833 = x21 * x622 + x832
    x834 = x21 * x623 + x833
    x835 = x55 * (x598 * x69 + x819 * x95)
    x836 = x22 * x533 + x835
    x837 = x21 * x628 + x836
    x838 = x21 * x629 + x837
    x839 = x608 * x69
    x840 = x55 * (x825 * x95 + x839)
    x841 = x22 * x539 + x840
    x842 = x21 * x634 + x841
    x843 = x21 * x635 + x842
    x844 = x55 * (x108 * x825 + x517)
    x845 = x22 * x545 + x844
    x846 = x21 * x640 + x845
    x847 = x21 * x641 + x846
    x848 = x183 * x643 - x646 * x9
    x849 = x212 * x848
    x850 = x22 * x559 + x849
    x851 = x22 * x560 + x850
    x852 = x21 * x656 + x851
    x853 = x6 * x848
    x854 = x183 * x645 - x470 * x659
    x855 = x5 * x848 - x854 * x88
    x856 = x644 + x848 * x9
    x857 = x239 * x856
    x858 = x22 * x572 + x857
    x859 = x22 * x573 + x858
    x860 = x21 * x671 + x859
    x861 = x662 + x855 * x9
    x862 = x12 * x848 + x799
    x863 = x239 * x862
    x864 = x22 * x583 + x863
    x865 = x22 * x584 + x864
    x866 = x21 * x681 + x865
    x867 = x12 * x855 + x565
    x868 = x664 + x856 * x95
    x869 = x234 * x868
    x870 = x22 * x593 + x869
    x871 = x22 * x594 + x870
    x872 = x21 * x689 + x871
    x873 = x662 * x95 + x861 * x95
    x874 = x673 + x862 * x95
    x875 = x234 * x874
    x876 = x22 * x603 + x875
    x877 = x22 * x604 + x876
    x878 = x21 * x696 + x877
    x879 = x674 * x93 + x867 * x95
    x880 = x108 * x862 + x818
    x881 = x234 * x880
    x882 = x22 * x613 + x881
    x883 = x22 * x614 + x882
    x884 = x21 * x705 + x883
    x885 = x108 * x867 + x587
    x886 = x55 * (x683 + x868 * x95)
    x887 = x22 * x621 + x886
    x888 = x22 * x622 + x887
    x889 = x21 * x712 + x888
    x890 = x55 * (x690 + x874 * x95)
    x891 = x22 * x627 + x890
    x892 = x22 * x628 + x891
    x893 = x21 * x718 + x892
    x894 = x55 * (x698 + x880 * x95)
    x895 = x22 * x633 + x894
    x896 = x22 * x634 + x895
    x897 = x21 * x724 + x896
    x898 = x55 * (x108 * x880 + x839)
    x899 = x22 * x639 + x898
    x900 = x22 * x640 + x899
    x901 = x21 * x730 + x900
    x902 = -x12 * x646 + x327 * x643 + 2.0 * x332
    x903 = x212 * x902
    x904 = x22 * x654 + x903
    x905 = x22 * x655 + x904
    x906 = x22 * x656 + x905
    x907 = x6 * x902
    x908 = x327 * x645 + 2.0 * x358 - x658 * x659
    x909 = x5 * x902 - x88 * x908
    x910 = x4 * x909
    x911 = x373 * x902
    x912 = x22 * x669 + x911
    x913 = x22 * x670 + x912
    x914 = x22 * x671 + x913
    x915 = x907 * x95
    x916 = x12 * x902 + 3.0 * x644
    x917 = x239 * x916
    x918 = x22 * x679 + x917
    x919 = x22 * x680 + x918
    x920 = x22 * x681 + x919
    x921 = x916 * x93
    x922 = x12 * x909 + 3.0 * x662
    x923 = x398 * x902
    x924 = x22 * x687 + x923
    x925 = x22 * x688 + x924
    x926 = x22 * x689 + x925
    x927 = x121 * x907
    x928 = x410 * x916
    x929 = x22 * x694 + x928
    x930 = x22 * x695 + x929
    x931 = x22 * x696 + x930
    x932 = x405 * x916
    x933 = x108 * x916 + x62 * x672
    x934 = x234 * x933
    x935 = x22 * x703 + x934
    x936 = x22 * x704 + x935
    x937 = x22 * x705 + x936
    x938 = x93 * x933
    x939 = x108 * x922 + x62 * x674
    x940 = x150 * x902
    x941 = x22 * x710 + x940
    x942 = x22 * x711 + x941
    x943 = x22 * x712 + x942
    x944 = x157 * x916
    x945 = x22 * x716 + x944
    x946 = x22 * x717 + x945
    x947 = x22 * x718 + x946
    x948 = x130 * x933
    x949 = x22 * x722 + x948
    x950 = x22 * x723 + x949
    x951 = x22 * x724 + x950
    x952 = x55 * (x108 * x933 + x62 * x697)
    x953 = x22 * x728 + x952
    x954 = x22 * x729 + x953
    x955 = x22 * x730 + x954
    x956 = x183 * x731 + 3.0 * x469 - x470 * x737
    x957 = x9 * x956
    x958 = 4.0 * x736
    x959 = x957 + x958
    x960 = 4.0 * x747 + x95 * x959
    x961 = x108 * x957 + x108 * x958
    x962 = x183 * x791 - x470 * x797 + 2.0 * x562
    x963 = 3.0 * x796 + x9 * x962
    x964 = x12 * x962 + x736
    x965 = x62 * x800 + x95 * x963
    x966 = x62 * x806 + x95 * x964
    x967 = x108 * x964 + x755
    x968 = x183 * x848 - x470 * x854 + x657
    x969 = 2.0 * x853 + x9 * x968
    x970 = x12 * x968 + 2.0 * x796
    x971 = x69 * x856 + x95 * x969
    x972 = x69 * x862 + x95 * x970
    x973 = x108 * x970 + x69 * x806
    x974 = x183 * x902 - x470 * x908
    x975 = x9 * x974 + x907
    x976 = x12 * x974 + 3.0 * x853
    x977 = x915 + x95 * x975
    x978 = x921 + x95 * x976
    x979 = x108 * x976 + x62 * x862
    x980 = x327 * x902 + 3.0 * x657 - x658 * x908
    x981 = x12 * x980 + 4.0 * x907
    x982 = x108 * x981 + 4.0 * x921

    # 150 item(s)
    return numpy.array(
        [
            x0 * x71
            + x0 * x76
            + x0 * x80
            + x0 * (x0 * (x0 * (x78 + x81 * x84) + x79) + x80)
            + x55 * (x56 * (x54 * x94 + x56 * (x90 + x92)) + x63 * x94),
            x0 * x102
            + x0 * x106
            + x0 * x98
            + x0 * (x0 * (x0 * (x104 + x107 * x9) + x105) + x106)
            + x55 * (x56 * (x90 * x95 + x92 * x95) + x94 * x96),
            x0 * x111
            + x0 * x115
            + x0 * x119
            + x0 * (x0 * (x0 * (x107 * x12 + x117) + x118) + x119)
            + x55 * (x109 * x94 + x56 * (x108 * x90 + x108 * x92)),
            x0 * x122
            + x0 * x124
            + x0 * x128
            + x0 * (x0 * (x0 * (x10 * x129 + x126) + x127) + x128)
            + x55 * (x121 * x90 + x121 * x92),
            x0 * x132
            + x0 * x134
            + x0 * x138
            + x0 * (x0 * (x0 * (x136 + x139 * x84) + x137) + x138)
            + x55 * (x131 * x90 + x131 * x92),
            x0 * x141
            + x0 * x143
            + x0 * x147
            + x0 * (x0 * (x0 * (x129 * x13 + x145) + x146) + x147)
            + x55 * (x140 * x90 + x140 * x92),
            x0 * x151
            + x0 * x153
            + x0 * x156
            + x0 * (x0 * (x0 * (x148 * x84 + x154) + x155) + x156)
            + x150 * x89,
            x0 * x159
            + x0 * x161
            + x0 * x164
            + x0 * (x0 * (x0 * (x162 + x165 * x84) + x163) + x164)
            + x158 * x89,
            x0 * x168
            + x0 * x170
            + x0 * x173
            + x0 * (x0 * (x0 * (x171 + x174 * x84) + x172) + x173)
            + x167 * x89,
            x0 * x177
            + x0 * x179
            + x0 * x182
            + x0 * (x0 * (x0 * (x175 * x84 + x180) + x181) + x182)
            + x176 * x89,
            x0 * x207
            + x0 * x211
            + x0 * (x0 * (x0 * x215 + x210) + x211)
            + x21 * x71
            + x55 * (x204 * x62 + x56 * (x200 * x62 + x56 * (x219 + x221))),
            x0 * x233
            + x0 * x238
            + x0 * (x0 * (x0 * x242 + x237) + x238)
            + x21 * x98
            + x55 * (x227 * x62 + x56 * (x223 * x62 + x244 * x56)),
            x0 * x250
            + x0 * x254
            + x0 * (x0 * (x0 * x257 + x253) + x254)
            + x111 * x21
            + x55 * (x246 * x62 + x56 * (x108 * x219 + x108 * x221)),
            x0 * x262
            + x0 * x266
            + x0 * (x0 * (x0 * x269 + x265) + x266)
            + x122 * x21
            + x55 * (x258 * x62 + x270 * x56),
            x0 * x277
            + x0 * x281
            + x0 * (x0 * (x0 * x283 + x280) + x281)
            + x132 * x21
            + x55 * (x272 * x62 + x285 * x56),
            x0 * x288
            + x0 * x292
            + x0 * (x0 * (x0 * x295 + x291) + x292)
            + x141 * x21
            + x55 * (x140 * x219 + x140 * x221),
            x0 * x297
            + x0 * x300
            + x0 * (x0 * (x0 * x302 + x299) + x300)
            + x151 * x21
            + x55 * (x121 * x91 + x270 * x95),
            x0 * x304
            + x0 * x307
            + x0 * (x0 * (x0 * x309 + x306) + x307)
            + x159 * x21
            + x55 * (x131 * x91 + x285 * x95),
            x0 * x312
            + x0 * x316
            + x0 * (x0 * (x0 * x318 + x315) + x316)
            + x168 * x21
            + x55 * (x140 * x243 + x319),
            x0 * x321
            + x0 * x324
            + x0 * (x0 * (x0 * x326 + x323) + x324)
            + x176 * x218
            + x177 * x21,
            x0 * x351
            + x0 * x354
            + x0 * (x0 * (x0 * x357 + x353) + x354)
            + x22 * x71
            + x55 * (x348 * x62 + x56 * (x344 * x62 + x56 * (x361 + x363))),
            x0 * x368
            + x0 * x372
            + x0 * (x0 * (x0 * x376 + x371) + x372)
            + x22 * x98
            + x55 * (x364 * x62 + x56 * (x361 * x95 + x363 * x95)),
            x0 * x385
            + x0 * x388
            + x0 * (x0 * (x0 * x390 + x387) + x388)
            + x111 * x22
            + x55 * (x380 * x62 + x56 * (x377 * x62 + x391 * x56)),
            x0 * x393
            + x0 * x397
            + x0 * (x0 * (x0 * x401 + x396) + x397)
            + x122 * x22
            + x55 * (x121 * x361 + x121 * x363),
            x0 * x404
            + x0 * x409
            + x0 * (x0 * (x0 * x412 + x408) + x409)
            + x132 * x22
            + x55 * (x130 * x377 * x61 + x369 * x391),
            x0 * x417
            + x0 * x422
            + x0 * (x0 * (x0 * x424 + x421) + x422)
            + x141 * x22
            + x55 * (x413 * x62 + x425 * x56),
            x0 * x427
            + x0 * x430
            + x0 * (x0 * (x0 * x432 + x429) + x430)
            + x150 * x360
            + x151 * x22,
            x0 * x434
            + x0 * x437
            + x0 * (x0 * (x0 * x439 + x436) + x437)
            + x157 * x391
            + x159 * x22,
            x0 * x441
            + x0 * x444
            + x0 * (x0 * (x0 * x446 + x443) + x444)
            + x130 * x425
            + x168 * x22,
            x0 * x448
            + x0 * x451
            + x0 * (x0 * (x0 * x453 + x450) + x451)
            + x177 * x22
            + x55 * (x108 * x425 + x319),
            x0 * x465
            + x0 * (x0 * x468 + x465)
            + x206 * x21
            + x207 * x21
            + x55 * (x462 * x69 + x56 * (x461 * x69 + x56 * (x473 + x475))),
            x0 * x484
            + x0 * (x0 * x487 + x484)
            + x21 * x232
            + x21 * x233
            + x55 * (x481 * x69 + x56 * (x480 * x69 + x490 * x56)),
            x0 * x495
            + x0 * (x0 * x498 + x495)
            + x21 * x249
            + x21 * x250
            + x55 * (x492 * x69 + x56 * (x108 * x473 + x108 * x475)),
            x0 * x503
            + x0 * (x0 * x506 + x503)
            + x21 * x261
            + x21 * x262
            + x55 * (x500 * x69 + x507 * x56),
            x0 * x512
            + x0 * (x0 * x515 + x512)
            + x21 * x276
            + x21 * x277
            + x55 * (x509 * x69 + x516 * x56),
            x0 * x520
            + x0 * (x0 * x523 + x520)
            + x21 * x287
            + x21 * x288
            + x55 * (x140 * x473 + x140 * x475),
            x0 * x526
            + x0 * (x0 * x529 + x526)
            + x21 * x296
            + x21 * x297
            + x55 * (x258 * x69 + x507 * x95),
            x0 * x532
            + x0 * (x0 * x535 + x532)
            + x21 * x303
            + x21 * x304
            + x55 * (x272 * x69 + x516 * x95),
            x0 * x538
            + x0 * (x0 * x541 + x538)
            + x21 * x311
            + x21 * x312
            + x55 * (x140 * x488 + x140 * x489),
            x0 * x544 + x0 * (x0 * x547 + x544) + x176 * x472 + x21 * x320 + x21 * x321,
            x0 * x558
            + x0 * (x0 * x561 + x558)
            + x206 * x22
            + x21 * x351
            + x55 * (x555 * x69 + x56 * (x554 * x69 + x56 * (x4 * x564 + x565))),
            x0 * x571
            + x0 * (x0 * x574 + x571)
            + x21 * x368
            + x22 * x232
            + x55 * (x56 * (x56 * x575 + x576) + x568 * x69),
            x0 * x582
            + x0 * (x0 * x585 + x582)
            + x21 * x385
            + x22 * x249
            + x55 * (x56 * (x56 * x586 + x587) + x579 * x69),
            x0 * x592
            + x0 * (x0 * x595 + x592)
            + x21 * x393
            + x22 * x261
            + x55 * (x56 * x596 + x597),
            x0 * x602
            + x0 * (x0 * x605 + x602)
            + x21 * x404
            + x22 * x276
            + x55 * (x56 * x606 + x607),
            x0 * x612
            + x0 * (x0 * x615 + x612)
            + x21 * x417
            + x22 * x287
            + x55 * (x56 * x616 + x617),
            x0 * x620
            + x0 * (x0 * x623 + x620)
            + x21 * x427
            + x22 * x296
            + x55 * (x121 * x362 + x596 * x95),
            x0 * x626
            + x0 * (x0 * x629 + x626)
            + x21 * x434
            + x22 * x303
            + x55 * (x377 * x405 + x606 * x95),
            x0 * x632
            + x0 * (x0 * x635 + x632)
            + x21 * x441
            + x22 * x311
            + x55 * (x413 * x93 + x616 * x95),
            x0 * x638
            + x0 * (x0 * x641 + x638)
            + x21 * x448
            + x22 * x320
            + x55 * (x108 * x616 + x140 * x220),
            x0 * x653
            + x0 * (x0 * x656 + x653)
            + x22 * x350
            + x22 * x351
            + x55 * (x56 * (x56 * (x661 + x663) + x649 * x69) + x650 * x69),
            x0 * x668
            + x0 * (x0 * x671 + x668)
            + x22 * x367
            + x22 * x368
            + x55 * (x56 * (x661 * x95 + x663 * x95) + x665 * x69),
            x0 * x678
            + x0 * (x0 * x681 + x678)
            + x22 * x384
            + x22 * x385
            + x55 * (x56 * (x56 * x682 + x674 * x69) + x675 * x69),
            x0 * x686
            + x0 * (x0 * x689 + x686)
            + x22 * x392
            + x22 * x393
            + x55 * (x121 * x661 + x121 * x663),
            x0 * x693
            + x0 * (x0 * x696 + x693)
            + x22 * x403
            + x22 * x404
            + x55 * (x369 * x682 + x402 * x674),
            x0 * x702
            + x0 * (x0 * x705 + x702)
            + x22 * x416
            + x22 * x417
            + x55 * (x56 * x706 + x69 * x699),
            x0 * x709 + x0 * (x0 * x712 + x709) + x150 * x660 + x22 * x426 + x22 * x427,
            x0 * x715 + x0 * (x0 * x718 + x715) + x157 * x682 + x22 * x433 + x22 * x434,
            x0 * x721 + x0 * (x0 * x724 + x721) + x130 * x706 + x22 * x440 + x22 * x441,
            x0 * x727
            + x0 * (x0 * x730 + x727)
            + x22 * x447
            + x22 * x448
            + x55 * (x108 * x706 + x413 * x69),
            x0 * x735
            + x21 * x463
            + x21 * x464
            + x21 * x465
            + x55 * (x208 * x736 + x56 * (x56 * x736 + x56 * (x736 + x739))),
            x0 * x746
            + x21 * x482
            + x21 * x483
            + x21 * x484
            + x55 * (x235 * x742 + x56 * (x56 * x750 + x747)),
            x0 * x754
            + x21 * x493
            + x21 * x494
            + x21 * x495
            + x55 * (x251 * x736 + x56 * (x108 * x739 + x755)),
            x0 * x760 + x21 * x501 + x21 * x502 + x21 * x503 + x55 * (x56 * x762 + x761),
            x0 * x767 + x21 * x510 + x21 * x511 + x21 * x512 + x55 * (x56 * x769 + x768),
            x0 * x773 + x21 * x518 + x21 * x519 + x21 * x520 + x55 * (x140 * x739 + x774),
            x0 * x778
            + x21 * x524
            + x21 * x525
            + x21 * x526
            + x55 * (x500 * x62 + x762 * x95),
            x0 * x782
            + x21 * x530
            + x21 * x531
            + x21 * x532
            + x55 * (x509 * x62 + x769 * x95),
            x0 * x786
            + x21 * x536
            + x21 * x537
            + x21 * x538
            + x55 * (x140 * x748 + x140 * x749),
            x0 * x790 + x176 * x738 + x21 * x542 + x21 * x543 + x21 * x544,
            x0 * x795
            + x21 * x557
            + x21 * x558
            + x22 * x463
            + x55 * (x208 * x796 + x56 * (x56 * x796 + x56 * (x4 * x798 + x796))),
            x0 * x804
            + x21 * x570
            + x21 * x571
            + x22 * x482
            + x55 * (x235 * x800 + x56 * (x56 * x805 + x800 * x93)),
            x0 * x810
            + x21 * x581
            + x21 * x582
            + x22 * x493
            + x55 * (x235 * x806 + x56 * (x56 * x811 + x806 * x93)),
            x0 * x816
            + x21 * x591
            + x21 * x592
            + x22 * x501
            + x55 * (x56 * x817 + x812 * x93),
            x0 * x823
            + x21 * x601
            + x21 * x602
            + x22 * x510
            + x55 * (x56 * x824 + x819 * x93),
            x0 * x829
            + x21 * x611
            + x21 * x612
            + x22 * x518
            + x55 * (x56 * x830 + x825 * x93),
            x0 * x834 + x21 * x619 + x21 * x620 + x22 * x524 + x55 * (x597 + x817 * x95),
            x0 * x838 + x21 * x625 + x21 * x626 + x22 * x530 + x55 * (x607 + x824 * x95),
            x0 * x843 + x21 * x631 + x21 * x632 + x22 * x536 + x55 * (x617 + x830 * x95),
            x0 * x847
            + x21 * x637
            + x21 * x638
            + x22 * x542
            + x55 * (x108 * x830 + x140 * x474),
            x0 * x852
            + x21 * x653
            + x22 * x556
            + x22 * x557
            + x55 * (x208 * x853 + x56 * (x56 * x853 + x56 * (x4 * x855 + x853))),
            x0 * x860
            + x21 * x668
            + x22 * x569
            + x22 * x570
            + x55 * (x235 * x856 + x56 * (x56 * x861 + x856 * x93)),
            x0 * x866
            + x21 * x678
            + x22 * x580
            + x22 * x581
            + x55 * (x235 * x862 + x56 * (x56 * x867 + x862 * x93)),
            x0 * x872
            + x21 * x686
            + x22 * x590
            + x22 * x591
            + x55 * (x56 * x873 + x868 * x93),
            x0 * x878
            + x21 * x693
            + x22 * x600
            + x22 * x601
            + x55 * (x56 * x879 + x874 * x93),
            x0 * x884
            + x21 * x702
            + x22 * x610
            + x22 * x611
            + x55 * (x56 * x885 + x880 * x93),
            x0 * x889
            + x21 * x709
            + x22 * x618
            + x22 * x619
            + x55 * (x121 * x662 + x873 * x95),
            x0 * x893
            + x21 * x715
            + x22 * x624
            + x22 * x625
            + x55 * (x405 * x674 + x879 * x95),
            x0 * x897
            + x21 * x721
            + x22 * x630
            + x22 * x631
            + x55 * (x699 * x93 + x885 * x95),
            x0 * x901 + x21 * x727 + x22 * x636 + x22 * x637 + x55 * (x108 * x885 + x617),
            x0 * x906
            + x22 * x651
            + x22 * x652
            + x22 * x653
            + x55 * (x208 * x907 + x56 * (x56 * x907 + x56 * (x907 + x910))),
            x0 * x914
            + x22 * x666
            + x22 * x667
            + x22 * x668
            + x55 * (x369 * x907 + x56 * (x910 * x95 + x915)),
            x0 * x920
            + x22 * x676
            + x22 * x677
            + x22 * x678
            + x55 * (x235 * x916 + x56 * (x56 * x922 + x921)),
            x0 * x926 + x22 * x684 + x22 * x685 + x22 * x686 + x55 * (x121 * x910 + x927),
            x0 * x931 + x22 * x691 + x22 * x692 + x22 * x693 + x55 * (x369 * x922 + x932),
            x0 * x937 + x22 * x700 + x22 * x701 + x22 * x702 + x55 * (x56 * x939 + x938),
            x0 * x943 + x150 * x909 + x22 * x707 + x22 * x708 + x22 * x709,
            x0 * x947 + x157 * x922 + x22 * x713 + x22 * x714 + x22 * x715,
            x0 * x951 + x130 * x939 + x22 * x719 + x22 * x720 + x22 * x721,
            x0 * x955
            + x22 * x725
            + x22 * x726
            + x22 * x727
            + x55 * (x108 * x939 + x62 * x699),
            x21 * x732 + x21 * x733 + x21 * x734 + x21 * x735 + x212 * x956,
            x21 * x743 + x21 * x744 + x21 * x745 + x21 * x746 + x239 * x959,
            x21 * x751 + x21 * x752 + x21 * x753 + x21 * x754 + x255 * x956,
            x21 * x757 + x21 * x758 + x21 * x759 + x21 * x760 + x234 * x960,
            x21 * x764 + x21 * x765 + x21 * x766 + x21 * x767 + x234 * x961,
            x21 * x770 + x21 * x771 + x21 * x772 + x21 * x773 + x293 * x956,
            x21 * x775
            + x21 * x776
            + x21 * x777
            + x21 * x778
            + x55 * (4.0 * x761 + x95 * x960),
            x21 * x779
            + x21 * x780
            + x21 * x781
            + x21 * x782
            + x55 * (4.0 * x768 + x95 * x961),
            x21 * x783
            + x21 * x784
            + x21 * x785
            + x21 * x786
            + x55 * (x140 * x957 + x140 * x958),
            x176 * x956 + x21 * x787 + x21 * x788 + x21 * x789 + x21 * x790,
            x21 * x793 + x21 * x794 + x21 * x795 + x212 * x962 + x22 * x732,
            x21 * x802 + x21 * x803 + x21 * x804 + x22 * x743 + x239 * x963,
            x21 * x808 + x21 * x809 + x21 * x810 + x22 * x751 + x239 * x964,
            x21 * x814 + x21 * x815 + x21 * x816 + x22 * x757 + x234 * x965,
            x21 * x821 + x21 * x822 + x21 * x823 + x22 * x764 + x234 * x966,
            x21 * x827 + x21 * x828 + x21 * x829 + x22 * x770 + x234 * x967,
            x21 * x832
            + x21 * x833
            + x21 * x834
            + x22 * x775
            + x55 * (x62 * x812 + x95 * x965),
            x21 * x836
            + x21 * x837
            + x21 * x838
            + x22 * x779
            + x55 * (x62 * x819 + x95 * x966),
            x21 * x841
            + x21 * x842
            + x21 * x843
            + x22 * x783
            + x55 * (x62 * x825 + x95 * x967),
            x21 * x845
            + x21 * x846
            + x21 * x847
            + x22 * x787
            + x55 * (x108 * x967 + x774),
            x21 * x851 + x21 * x852 + x212 * x968 + x22 * x792 + x22 * x793,
            x21 * x859 + x21 * x860 + x22 * x801 + x22 * x802 + x239 * x969,
            x21 * x865 + x21 * x866 + x22 * x807 + x22 * x808 + x239 * x970,
            x21 * x871 + x21 * x872 + x22 * x813 + x22 * x814 + x234 * x971,
            x21 * x877 + x21 * x878 + x22 * x820 + x22 * x821 + x234 * x972,
            x21 * x883 + x21 * x884 + x22 * x826 + x22 * x827 + x234 * x973,
            x21 * x888
            + x21 * x889
            + x22 * x831
            + x22 * x832
            + x55 * (x69 * x868 + x95 * x971),
            x21 * x892
            + x21 * x893
            + x22 * x835
            + x22 * x836
            + x55 * (x69 * x874 + x95 * x972),
            x21 * x896
            + x21 * x897
            + x22 * x840
            + x22 * x841
            + x55 * (x69 * x880 + x95 * x973),
            x21 * x900
            + x21 * x901
            + x22 * x844
            + x22 * x845
            + x55 * (x108 * x973 + x69 * x825),
            x21 * x906 + x212 * x974 + x22 * x849 + x22 * x850 + x22 * x851,
            x21 * x914 + x22 * x857 + x22 * x858 + x22 * x859 + x239 * x975,
            x21 * x920 + x22 * x863 + x22 * x864 + x22 * x865 + x239 * x976,
            x21 * x926 + x22 * x869 + x22 * x870 + x22 * x871 + x234 * x977,
            x21 * x931 + x22 * x875 + x22 * x876 + x22 * x877 + x234 * x978,
            x21 * x937 + x22 * x881 + x22 * x882 + x22 * x883 + x234 * x979,
            x21 * x943 + x22 * x886 + x22 * x887 + x22 * x888 + x55 * (x927 + x95 * x977),
            x21 * x947 + x22 * x890 + x22 * x891 + x22 * x892 + x55 * (x932 + x95 * x978),
            x21 * x951 + x22 * x894 + x22 * x895 + x22 * x896 + x55 * (x938 + x95 * x979),
            x21 * x955
            + x22 * x898
            + x22 * x899
            + x22 * x900
            + x55 * (x108 * x979 + x62 * x880),
            x212 * x980 + x22 * x903 + x22 * x904 + x22 * x905 + x22 * x906,
            x22 * x911 + x22 * x912 + x22 * x913 + x22 * x914 + x373 * x980,
            x22 * x917 + x22 * x918 + x22 * x919 + x22 * x920 + x239 * x981,
            x22 * x923 + x22 * x924 + x22 * x925 + x22 * x926 + x398 * x980,
            x22 * x928 + x22 * x929 + x22 * x930 + x22 * x931 + x410 * x981,
            x22 * x934 + x22 * x935 + x22 * x936 + x22 * x937 + x234 * x982,
            x150 * x980 + x22 * x940 + x22 * x941 + x22 * x942 + x22 * x943,
            x157 * x981 + x22 * x944 + x22 * x945 + x22 * x946 + x22 * x947,
            x130 * x982 + x22 * x948 + x22 * x949 + x22 * x950 + x22 * x951,
            x22 * x952
            + x22 * x953
            + x22 * x954
            + x22 * x955
            + x55 * (x108 * x982 + 4.0 * x938),
        ]
    )


def _3center2el3d_sph_044(a, A, b, B, c, C):
    """Cartesian (sg|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = x4**2
    x8 = -x2 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x2 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x1
    x15 = x14 ** (-1.0)
    x16 = c * x15
    x17 = x1 * x16 * (x10 + x13 + x7)
    x18 = boys(5, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x0**2 + x21**2 + x22**2))
    x24 = x20 * x23
    x25 = x2 * x24
    x26 = 2.0 * x19 * x25
    x27 = x18 * x26
    x28 = c ** (-1.0)
    x29 = x14 ** (-0.5)
    x30 = boys(4, x17)
    x31 = 2.0 * x2 * x20 * x23 * x28 * x29 * x30 - x27
    x32 = x31 * x6
    x33 = -2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x5 + x27 * x4
    x34 = -x33
    x35 = boys(6, x17)
    x36 = x26 * x35
    x37 = -2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x5 + x36 * x4
    x38 = -x37
    x39 = x16 * x38
    x40 = x39 * x4
    x41 = x32 + x34 * x5 - x40
    x42 = 2.0 * x6
    x43 = x6 * (2.0 * x18 * x2 * x20 * x23 * x28 * x29 - x36)
    x44 = boys(7, x17)
    x45 = x26 * x44
    x46 = 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x5 - x4 * x45
    x47 = x16 * x46
    x48 = x38 * x5 - x4 * x47 + x43
    x49 = x16 * x48
    x50 = -x4 * x49 + x41 * x5 + x42 * (-x33 - x39)
    x51 = x4 * x50
    x52 = x41 * x6
    x53 = 3.0 * x52
    x54 = x51 + x53
    x55 = x1 * x15
    x56 = x4 * x55
    x57 = x4 * x41
    x58 = x34 * x6
    x59 = 2.0 * x58
    x60 = x57 + x59
    x61 = 3.0 * x6
    x62 = x55 * x61
    x63 = x54 * x56 + x60 * x62
    x64 = x34 * x4
    x65 = x28 * x30
    x66 = x42 * x65
    x67 = x25 * x29 * x66
    x68 = x64 + x67
    x69 = x42 * x55
    x70 = x56 * x60 + x68 * x69
    x71 = x56 * x63 + x62 * x70
    x72 = x24 * x66
    x73 = x19 * x72
    x74 = x4 * x73 + x56 * x68
    x75 = x56 * x70 + x69 * x74
    x76 = x55 * (x56 * x71 + x62 * x75)
    x77 = x7 * x72
    x78 = x1 * x14 ** (-2.5)
    x79 = x56 * x74 + x77 * x78
    x80 = x55 * (x56 * x75 + x69 * x79)
    x81 = x0 * x80 + x76
    x82 = x4**3
    x83 = x1**2
    x84 = x14 ** (-3.5) * x83
    x85 = x72 * x84
    x86 = x55 * (x56 * x79 + x82 * x85)
    x87 = x0 * x86 + x80
    x88 = x0 * x87 + x81
    x89 = x4**4
    x90 = x1**3
    x91 = 2.0 * x14 ** (-4.5) * x24 * x65 * x90
    x92 = x0 * x91
    x93 = -x31 * x6
    x94 = x6 * (2.0 * x2 * x20 * x23 * x28 * x29 * x35 - x45)
    x95 = x26 * boys(8, x17)
    x96 = x16 * x4
    x97 = (
        x5 * x50
        + x61 * (x34 * x5 - x40 - x49 - x93)
        - x96
        * (
            x42 * (-x37 - x47)
            + x48 * x5
            - x96
            * (
                x46 * x5
                + x94
                - x96 * (2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x5 - x4 * x95)
            )
        )
    )
    x98 = x4 * x97
    x99 = x50 * x6
    x100 = 4.0 * x99
    x101 = x55 * x6
    x102 = 4.0 * x101
    x103 = x55 * x9
    x104 = x103 * x51 + x103 * x53
    x105 = x103 * x57 + x103 * x59
    x106 = x104 * x56 + x105 * x62
    x107 = x73 * x9
    x108 = x103 * x64 + x107
    x109 = x105 * x56 + x108 * x69
    x110 = x55 * (x106 * x56 + x109 * x62)
    x111 = x72 * x78
    x112 = x111 * x4
    x113 = x108 * x56 + x112 * x9
    x114 = x55 * (x109 * x56 + x113 * x69)
    x115 = x0 * x114 + x110
    x116 = x77 * x84
    x117 = x55 * (x113 * x56 + x116 * x9)
    x118 = x0 * x117 + x114
    x119 = x0 * x118 + x115
    x120 = x82 * x92
    x121 = x12 * x55
    x122 = x121 * x51 + x121 * x53
    x123 = x121 * x57 + x121 * x59
    x124 = x122 * x56 + x123 * x62
    x125 = x12 * x73
    x126 = x121 * x64 + x125
    x127 = x123 * x56 + x126 * x69
    x128 = x55 * (x124 * x56 + x127 * x62)
    x129 = x112 * x12 + x126 * x56
    x130 = x55 * (x127 * x56 + x129 * x69)
    x131 = x0 * x130 + x128
    x132 = x55 * (x116 * x12 + x129 * x56)
    x133 = x0 * x132 + x130
    x134 = x0 * x133 + x131
    x135 = x83 / x14**2
    x136 = x10 * x135
    x137 = x136 * x51 + x136 * x53
    x138 = x136 * x57 + x136 * x59
    x139 = x55 * (x137 * x56 + x138 * x62)
    x140 = x10 * x111
    x141 = x136 * x64 + x140
    x142 = x55 * (x138 * x56 + x141 * x69)
    x143 = x0 * x142 + x139
    x144 = x10 * x4
    x145 = x55 * (x141 * x56 + x144 * x85)
    x146 = x0 * x145 + x142
    x147 = x0 * x146 + x143
    x148 = x10 * x7
    x149 = x135 * x9
    x150 = x12 * x149
    x151 = x150 * x51 + x150 * x53
    x152 = x150 * x57 + x150 * x59
    x153 = x55 * (x151 * x56 + x152 * x62)
    x154 = x12 * x9
    x155 = x111 * x154
    x156 = x150 * x64 + x155
    x157 = x55 * (x152 * x56 + x156 * x69)
    x158 = x0 * x157 + x153
    x159 = x55 * (x154 * x4 * x85 + x156 * x56)
    x160 = x0 * x159 + x157
    x161 = x0 * x160 + x158
    x162 = x154 * x7
    x163 = x13 * x135
    x164 = x163 * x51 + x163 * x53
    x165 = x163 * x57 + x163 * x59
    x166 = x55 * (x164 * x56 + x165 * x62)
    x167 = x111 * x13
    x168 = x163 * x64 + x167
    x169 = x55 * (x165 * x56 + x168 * x69)
    x170 = x0 * x169 + x166
    x171 = x13 * x4
    x172 = x55 * (x168 * x56 + x171 * x85)
    x173 = x0 * x172 + x169
    x174 = x0 * x173 + x170
    x175 = x13 * x7
    x176 = x9**3
    x177 = x90 / x14**3
    x178 = x176 * x177
    x179 = x55 * (x178 * x51 + x178 * x53)
    x180 = x55 * (x178 * x57 + x178 * x59)
    x181 = x0 * x180 + x179
    x182 = x176 * x85
    x183 = x55 * (x178 * x64 + x182)
    x184 = x0 * x183 + x180
    x185 = x0 * x184 + x181
    x186 = x176 * x92
    x187 = x10 * x177
    x188 = x12 * x187
    x189 = x55 * (x188 * x51 + x188 * x53)
    x190 = x55 * (x188 * x57 + x188 * x59)
    x191 = x0 * x190 + x189
    x192 = x10 * x12 * x85
    x193 = x55 * (x188 * x64 + x192)
    x194 = x0 * x193 + x190
    x195 = x0 * x194 + x191
    x196 = x12 * x144
    x197 = x177 * x9
    x198 = x13 * x197
    x199 = x55 * (x198 * x51 + x198 * x53)
    x200 = x55 * (x198 * x57 + x198 * x59)
    x201 = x0 * x200 + x199
    x202 = x13 * x85 * x9
    x203 = x55 * (x198 * x64 + x202)
    x204 = x0 * x203 + x200
    x205 = x0 * x204 + x201
    x206 = x171 * x9
    x207 = x12**3
    x208 = x177 * x207
    x209 = x55 * (x208 * x51 + x208 * x53)
    x210 = x55 * (x208 * x57 + x208 * x59)
    x211 = x0 * x210 + x209
    x212 = x207 * x85
    x213 = x55 * (x208 * x64 + x212)
    x214 = x0 * x213 + x210
    x215 = x0 * x214 + x211
    x216 = x207 * x4
    x217 = x9**4
    x218 = x1**4 / x14**4
    x219 = x217 * x218
    x220 = x219 * x50
    x221 = x219 * x41
    x222 = x0 * x221 + x220
    x223 = x219 * x34
    x224 = x0 * x223 + x221
    x225 = x0 * x224 + x222
    x226 = x176 * x218
    x227 = x12 * x226
    x228 = x227 * x50
    x229 = x227 * x41
    x230 = x0 * x229 + x228
    x231 = x227 * x34
    x232 = x0 * x231 + x229
    x233 = x0 * x232 + x230
    x234 = x218 * x50
    x235 = x10 * x13
    x236 = x234 * x235
    x237 = x218 * x235
    x238 = x237 * x41
    x239 = x0 * x238 + x236
    x240 = x237 * x34
    x241 = x0 * x240 + x238
    x242 = x0 * x241 + x239
    x243 = x207 * x9
    x244 = x234 * x243
    x245 = x218 * x243
    x246 = x245 * x41
    x247 = x0 * x246 + x244
    x248 = x245 * x34
    x249 = x0 * x248 + x246
    x250 = x0 * x249 + x247
    x251 = x12**4
    x252 = x218 * x251
    x253 = x252 * x50
    x254 = x252 * x41
    x255 = x0 * x254 + x253
    x256 = x252 * x34
    x257 = x0 * x256 + x254
    x258 = x0 * x257 + x255
    x259 = -x8 - A[1]
    x260 = -2.0 * x18 * x2 * x20 * x23 * x259 * x28 * x29 + x36 * x9
    x261 = -x260
    x262 = x16 * x261
    x263 = -2.0 * x2 * x20 * x23 * x259 * x28 * x29 * x30 + x27 * x9
    x264 = x6 * (-x262 - x263)
    x265 = -x263
    x266 = x262 * x4 - x265 * x5
    x267 = -x266
    x268 = 2.0 * x2 * x20 * x23 * x259 * x28 * x29 * x35 - x45 * x9
    x269 = x16 * x268
    x270 = x261 * x5 - x269 * x4
    x271 = x16 * x270
    x272 = x264 + x267 * x5 - x271 * x4
    x273 = x272 * x4
    x274 = x267 * x6
    x275 = 2.0 * x274
    x276 = x273 + x275
    x277 = x265 * x6
    x278 = x267 * x4
    x279 = x277 + x278
    x280 = x276 * x56 + x279 * x69
    x281 = x277 * x56 + x279 * x56
    x282 = x280 * x56 + x281 * x69
    x283 = x135 * x7
    x284 = x277 * x283 + x281 * x56
    x285 = x55 * (x282 * x56 + x284 * x69)
    x286 = x21 * x80 + x285
    x287 = x177 * x82
    x288 = x55 * (x277 * x287 + x284 * x56)
    x289 = x21 * x86 + x288
    x290 = x0 * x289 + x286
    x291 = x218 * x89
    x292 = x265 * x291
    x293 = x21 * x91
    x294 = x292 + x293 * x89
    x295 = x6 * (-x260 - x269)
    x296 = 2.0 * x2 * x20 * x23 * x259 * x28 * x29 * x44 - x9 * x95
    x297 = (
        x272 * x5
        + x42 * (-x266 - x271)
        - x96 * (x270 * x5 + x295 - x96 * (x268 * x5 - x296 * x96))
    )
    x298 = x297 * x4
    x299 = x272 * x6
    x300 = 3.0 * x299
    x301 = x272 * x9
    x302 = x301 + x52
    x303 = x267 * x9
    x304 = x303 + x58
    x305 = x304 * x69
    x306 = x302 * x56 + x305
    x307 = x265 * x9
    x308 = x307 + x67
    x309 = x308 * x55
    x310 = x304 * x56 + x309 * x6
    x311 = x306 * x56 + x310 * x69
    x312 = x135 * x4
    x313 = x308 * x6
    x314 = x310 * x56 + x312 * x313
    x315 = x55 * (x311 * x56 + x314 * x69)
    x316 = x114 * x21 + x315
    x317 = x177 * x7
    x318 = x55 * (x313 * x317 + x314 * x56)
    x319 = x117 * x21 + x318
    x320 = x0 * x319 + x316
    x321 = x218 * x82
    x322 = x308 * x321
    x323 = x293 * x82
    x324 = x322 + x323 * x9
    x325 = x297 * x9
    x326 = x325 + x99
    x327 = x121 * x275
    x328 = x121 * x273 + x327
    x329 = x121 * x277
    x330 = x121 * x278 + x329
    x331 = x328 * x56 + x330 * x69
    x332 = x12 * x277
    x333 = x312 * x332 + x330 * x56
    x334 = x55 * (x331 * x56 + x333 * x69)
    x335 = x130 * x21 + x334
    x336 = x55 * (x317 * x332 + x333 * x56)
    x337 = x132 * x21 + x336
    x338 = x0 * x337 + x335
    x339 = x12 * x321
    x340 = x265 * x339
    x341 = x12 * x323 + x340
    x342 = x103 * x302 + x103 * x52
    x343 = x103 * x304 + x103 * x58
    x344 = x343 * x69
    x345 = x342 * x56 + x344
    x346 = x107 + x309 * x9
    x347 = x101 * x346 + x343 * x56
    x348 = x55 * (x345 * x56 + x347 * x69)
    x349 = x142 * x21 + x348
    x350 = x312 * x6
    x351 = x55 * (x346 * x350 + x347 * x56)
    x352 = x145 * x21 + x351
    x353 = x0 * x352 + x349
    x354 = x317 * x346
    x355 = x148 * x293 + x354
    x356 = x103 * x326 + x103 * x99
    x357 = x121 * x52
    x358 = x121 * x301 + x357
    x359 = x121 * x58
    x360 = x121 * x303 + x359
    x361 = x360 * x69
    x362 = x358 * x56 + x361
    x363 = x121 * x307 + x125
    x364 = x101 * x363 + x360 * x56
    x365 = x55 * (x362 * x56 + x364 * x69)
    x366 = x157 * x21 + x365
    x367 = x55 * (x350 * x363 + x364 * x56)
    x368 = x159 * x21 + x367
    x369 = x0 * x368 + x366
    x370 = x317 * x363
    x371 = x162 * x293 + x370
    x372 = x121 * x99
    x373 = x121 * x325 + x372
    x374 = x163 * x275
    x375 = x163 * x273 + x374
    x376 = x163 * x277
    x377 = x163 * x278 + x376
    x378 = x55 * (x375 * x56 + x377 * x69)
    x379 = x169 * x21 + x378
    x380 = x171 * x177
    x381 = x55 * (x277 * x380 + x377 * x56)
    x382 = x172 * x21 + x381
    x383 = x0 * x382 + x379
    x384 = x218 * x265
    x385 = x175 * x384
    x386 = x175 * x293 + x385
    x387 = x103 * x342 + x136 * x52
    x388 = x103 * x343 + x136 * x58
    x389 = x388 * x69
    x390 = x55 * (x387 * x56 + x389)
    x391 = x180 * x21 + x390
    x392 = x103 * x346 + x140
    x393 = x55 * (x101 * x392 + x388 * x56)
    x394 = x183 * x21 + x393
    x395 = x0 * x394 + x391
    x396 = x312 * x392
    x397 = x176 * x293
    x398 = x396 + x397 * x4
    x399 = x103 * x356 + x136 * x99
    x400 = x103 * x358 + x150 * x52
    x401 = x103 * x360 + x150 * x58
    x402 = x401 * x69
    x403 = x55 * (x400 * x56 + x402)
    x404 = x190 * x21 + x403
    x405 = x103 * x363 + x155
    x406 = x55 * (x101 * x405 + x401 * x56)
    x407 = x193 * x21 + x406
    x408 = x0 * x407 + x404
    x409 = x312 * x405
    x410 = x196 * x293 + x409
    x411 = x103 * x373 + x150 * x99
    x412 = x163 * x52
    x413 = x163 * x301 + x412
    x414 = x163 * x58
    x415 = x163 * x303 + x414
    x416 = x415 * x69
    x417 = x55 * (x413 * x56 + x416)
    x418 = x200 * x21 + x417
    x419 = x163 * x307 + x167
    x420 = x55 * (x101 * x419 + x415 * x56)
    x421 = x203 * x21 + x420
    x422 = x0 * x421 + x418
    x423 = x312 * x419
    x424 = x206 * x293 + x423
    x425 = x163 * x99
    x426 = x163 * x325 + x425
    x427 = x208 * x275
    x428 = x55 * (x208 * x273 + x427)
    x429 = x21 * x210 + x428
    x430 = x208 * x277
    x431 = x55 * (x208 * x278 + x430)
    x432 = x21 * x213 + x431
    x433 = x0 * x432 + x429
    x434 = x216 * x384
    x435 = x216 * x293 + x434
    x436 = x55 * (x103 * x387 + x178 * x52)
    x437 = x21 * x221 + x436
    x438 = x55 * (x103 * x388 + x178 * x58)
    x439 = x21 * x223 + x438
    x440 = x0 * x439 + x437
    x441 = x55 * (x103 * x392 + x182)
    x442 = x217 * x293 + x441
    x443 = x55 * (x103 * x400 + x188 * x52)
    x444 = x21 * x229 + x443
    x445 = x55 * (x103 * x401 + x188 * x58)
    x446 = x21 * x231 + x445
    x447 = x0 * x446 + x444
    x448 = x55 * (x103 * x405 + x192)
    x449 = x12 * x397 + x448
    x450 = x55 * (x103 * x413 + x198 * x52)
    x451 = x21 * x238 + x450
    x452 = x55 * (x103 * x415 + x198 * x58)
    x453 = x21 * x240 + x452
    x454 = x0 * x453 + x451
    x455 = x55 * (x103 * x419 + x202)
    x456 = x235 * x293 + x455
    x457 = x208 * x52
    x458 = x55 * (x208 * x301 + x457)
    x459 = x21 * x246 + x458
    x460 = x208 * x58
    x461 = x55 * (x208 * x303 + x460)
    x462 = x21 * x248 + x461
    x463 = x0 * x462 + x459
    x464 = x55 * (x208 * x307 + x212)
    x465 = x243 * x293 + x464
    x466 = x208 * x99
    x467 = x252 * x272
    x468 = x21 * x254 + x467
    x469 = x252 * x267
    x470 = x21 * x256 + x469
    x471 = x0 * x470 + x468
    x472 = x252 * x265
    x473 = x251 * x293 + x472
    x474 = -x11 - A[2]
    x475 = x12 * x36 - 2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x474
    x476 = -x475
    x477 = x16 * x476
    x478 = x12 * x27 - 2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x474
    x479 = x6 * (-x477 - x478)
    x480 = -x478
    x481 = x4 * x477 - x480 * x5
    x482 = -x481
    x483 = -x12 * x45 + 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x474
    x484 = x16 * x483
    x485 = -x4 * x484 + x476 * x5
    x486 = x16 * x485
    x487 = -x4 * x486 + x479 + x482 * x5
    x488 = x4 * x487
    x489 = x482 * x6
    x490 = 2.0 * x489
    x491 = x488 + x490
    x492 = x480 * x6
    x493 = x4 * x482
    x494 = x492 + x493
    x495 = x491 * x56 + x494 * x69
    x496 = x492 * x56 + x494 * x56
    x497 = x495 * x56 + x496 * x69
    x498 = x283 * x492 + x496 * x56
    x499 = x55 * (x497 * x56 + x498 * x69)
    x500 = x22 * x80 + x499
    x501 = x55 * (x287 * x492 + x498 * x56)
    x502 = x22 * x86 + x501
    x503 = x0 * x502 + x500
    x504 = x291 * x480
    x505 = x22 * x91
    x506 = x504 + x505 * x89
    x507 = x6 * (-x475 - x484)
    x508 = -x12 * x95 + 2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x474
    x509 = (
        x42 * (-x481 - x486)
        + x487 * x5
        - x96 * (x485 * x5 + x507 - x96 * (x483 * x5 - x508 * x96))
    )
    x510 = x4 * x509
    x511 = x487 * x6
    x512 = 3.0 * x511
    x513 = x103 * x488 + x103 * x490
    x514 = x103 * x492
    x515 = x103 * x493 + x514
    x516 = x513 * x56 + x515 * x69
    x517 = x312 * x9
    x518 = x492 * x517 + x515 * x56
    x519 = x55 * (x516 * x56 + x518 * x69)
    x520 = x114 * x22 + x519
    x521 = x317 * x9
    x522 = x55 * (x492 * x521 + x518 * x56)
    x523 = x117 * x22 + x522
    x524 = x0 * x523 + x520
    x525 = x321 * x9
    x526 = x480 * x525
    x527 = x505 * x82
    x528 = x526 + x527 * x9
    x529 = x12 * x487 + x52
    x530 = x12 * x482 + x58
    x531 = x530 * x69
    x532 = x529 * x56 + x531
    x533 = x12 * x480 + x67
    x534 = x101 * x533
    x535 = x530 * x56 + x534
    x536 = x532 * x56 + x535 * x69
    x537 = x350 * x533 + x535 * x56
    x538 = x55 * (x536 * x56 + x537 * x69)
    x539 = x130 * x22 + x538
    x540 = x533 * x6
    x541 = x55 * (x317 * x540 + x537 * x56)
    x542 = x132 * x22 + x541
    x543 = x0 * x542 + x539
    x544 = x321 * x533
    x545 = x12 * x527 + x544
    x546 = x12 * x509 + x99
    x547 = x136 * x488 + x136 * x490
    x548 = x136 * x492
    x549 = x136 * x493 + x548
    x550 = x55 * (x547 * x56 + x549 * x69)
    x551 = x142 * x22 + x550
    x552 = x187 * x4
    x553 = x55 * (x492 * x552 + x549 * x56)
    x554 = x145 * x22 + x553
    x555 = x0 * x554 + x551
    x556 = x218 * x7
    x557 = x10 * x556
    x558 = x480 * x557
    x559 = x148 * x505 + x558
    x560 = x42 * x530
    x561 = x149 * x560 + x517 * x529
    x562 = x149 * x540
    x563 = x517 * x530 + x562
    x564 = x55 * (x56 * x561 + x563 * x69)
    x565 = x157 * x22 + x564
    x566 = x197 * x4
    x567 = x55 * (x540 * x566 + x56 * x563)
    x568 = x159 * x22 + x567
    x569 = x0 * x568 + x565
    x570 = x556 * x9
    x571 = x533 * x570
    x572 = x162 * x505 + x571
    x573 = x529 * x61
    x574 = x121 * x529 + x357
    x575 = x121 * x530 + x359
    x576 = x575 * x69
    x577 = x56 * x574 + x576
    x578 = x121 * x533 + x125
    x579 = x101 * x578
    x580 = x56 * x575 + x579
    x581 = x55 * (x56 * x577 + x580 * x69)
    x582 = x169 * x22 + x581
    x583 = x55 * (x350 * x578 + x56 * x580)
    x584 = x172 * x22 + x583
    x585 = x0 * x584 + x582
    x586 = x317 * x578
    x587 = x175 * x505 + x586
    x588 = x121 * x546 + x372
    x589 = x55 * (x178 * x488 + x178 * x490)
    x590 = x180 * x22 + x589
    x591 = x178 * x492
    x592 = x55 * (x178 * x493 + x591)
    x593 = x183 * x22 + x592
    x594 = x0 * x593 + x590
    x595 = x226 * x4
    x596 = x480 * x595
    x597 = x176 * x505
    x598 = x4 * x597 + x596
    x599 = x55 * (x187 * x560 + x529 * x552)
    x600 = x190 * x22 + x599
    x601 = x187 * x540
    x602 = x55 * (x530 * x552 + x601)
    x603 = x193 * x22 + x602
    x604 = x0 * x603 + x600
    x605 = x144 * x218
    x606 = x533 * x605
    x607 = x196 * x505 + x606
    x608 = x149 * x42
    x609 = x55 * (x517 * x574 + x575 * x608)
    x610 = x200 * x22 + x609
    x611 = x149 * x6
    x612 = x578 * x611
    x613 = x55 * (x517 * x575 + x612)
    x614 = x203 * x22 + x613
    x615 = x0 * x614 + x610
    x616 = x566 * x578
    x617 = x206 * x505 + x616
    x618 = x121 * x574 + x412
    x619 = x121 * x575 + x414
    x620 = x619 * x69
    x621 = x55 * (x56 * x618 + x620)
    x622 = x210 * x22 + x621
    x623 = x121 * x578 + x167
    x624 = x101 * x623
    x625 = x55 * (x56 * x619 + x624)
    x626 = x213 * x22 + x625
    x627 = x0 * x626 + x622
    x628 = x312 * x623
    x629 = x216 * x505 + x628
    x630 = x121 * x588 + x425
    x631 = x219 * x487
    x632 = x22 * x221 + x631
    x633 = x219 * x482
    x634 = x22 * x223 + x633
    x635 = x0 * x634 + x632
    x636 = x219 * x480
    x637 = x217 * x505 + x636
    x638 = x226 * x529
    x639 = x22 * x229 + x638
    x640 = x226 * x530
    x641 = x22 * x231 + x640
    x642 = x0 * x641 + x639
    x643 = x226 * x533
    x644 = x12 * x597 + x643
    x645 = x187 * x574
    x646 = x22 * x238 + x645
    x647 = x187 * x575
    x648 = x22 * x240 + x647
    x649 = x0 * x648 + x646
    x650 = x187 * x578
    x651 = x235 * x505 + x650
    x652 = x149 * x618
    x653 = x22 * x246 + x652
    x654 = x149 * x619
    x655 = x22 * x248 + x654
    x656 = x0 * x655 + x653
    x657 = x149 * x623
    x658 = x243 * x505 + x657
    x659 = x55 * (x121 * x618 + x457)
    x660 = x22 * x254 + x659
    x661 = x55 * (x121 * x619 + x460)
    x662 = x22 * x256 + x661
    x663 = x0 * x662 + x660
    x664 = x55 * (x121 * x623 + x212)
    x665 = x251 * x505 + x664
    x666 = x262 * x9
    x667 = x259 * x265 + x32 - x666
    x668 = x6 * x667
    x669 = x259 * x261 - x269 * x9 + x43
    x670 = x16 * x669
    x671 = -x4 * x670 + x5 * x667
    x672 = x4 * x671
    x673 = x668 + x672
    x674 = x56 * x668 + x56 * x673
    x675 = x283 * x668 + x56 * x674
    x676 = x55 * (x287 * x668 + x56 * x675)
    x677 = x21 * x288 + x676
    x678 = x21 * x289 + x677
    x679 = x291 * x667
    x680 = x21 * x292 + x679
    x681 = x21 * x294 + x680
    x682 = x6 * (x259 * x265 - x666 - x670 - x93)
    x683 = x16 * x9
    x684 = x259 * x268 - x296 * x683 + x94
    x685 = x5 * x671 + x682 - x96 * (x5 * x669 - x684 * x96)
    x686 = x4 * x685
    x687 = x6 * x671
    x688 = 2.0 * x687
    x689 = x667 * x9
    x690 = 2.0 * x277
    x691 = x689 + x690
    x692 = x671 * x9
    x693 = x275 + x692
    x694 = x101 * x691 + x56 * x693
    x695 = x350 * x691 + x56 * x694
    x696 = x317 * x6
    x697 = x55 * (x56 * x695 + x691 * x696)
    x698 = x21 * x318 + x697
    x699 = x21 * x319 + x698
    x700 = x321 * x691
    x701 = x21 * x322 + x700
    x702 = x21 * x324 + x701
    x703 = x685 * x9
    x704 = 2.0 * x299
    x705 = x703 + x704
    x706 = x121 * x668
    x707 = x121 * x672 + x706
    x708 = x12 * x668
    x709 = x312 * x708 + x56 * x707
    x710 = x55 * (x317 * x708 + x56 * x709)
    x711 = x21 * x336 + x710
    x712 = x21 * x337 + x711
    x713 = x339 * x667
    x714 = x21 * x340 + x713
    x715 = x21 * x341 + x714
    x716 = x103 * x691 + x309 * x42
    x717 = x103 * x693 + x305
    x718 = x101 * x716 + x56 * x717
    x719 = x55 * (x350 * x716 + x56 * x718)
    x720 = x21 * x351 + x719
    x721 = x21 * x352 + x720
    x722 = x317 * x716
    x723 = x21 * x354 + x722
    x724 = x21 * x355 + x723
    x725 = x103 * x705 + x302 * x69
    x726 = x121 * x689 + x121 * x690
    x727 = x121 * x692 + x327
    x728 = x101 * x726 + x56 * x727
    x729 = x55 * (x350 * x726 + x56 * x728)
    x730 = x21 * x367 + x729
    x731 = x21 * x368 + x730
    x732 = x317 * x726
    x733 = x21 * x370 + x732
    x734 = x21 * x371 + x733
    x735 = x121 * x703 + x121 * x704
    x736 = x163 * x668
    x737 = x163 * x672 + x736
    x738 = x55 * (x380 * x668 + x56 * x737)
    x739 = x21 * x381 + x738
    x740 = x21 * x382 + x739
    x741 = x218 * x667
    x742 = x175 * x741
    x743 = x21 * x385 + x742
    x744 = x21 * x386 + x743
    x745 = x103 * x716 + x346 * x69
    x746 = x103 * x717 + x344
    x747 = x55 * (x101 * x745 + x56 * x746)
    x748 = x21 * x393 + x747
    x749 = x21 * x394 + x748
    x750 = x312 * x745
    x751 = x21 * x396 + x750
    x752 = x21 * x398 + x751
    x753 = x103 * x725 + x342 * x69
    x754 = x103 * x726 + x363 * x69
    x755 = x103 * x727 + x361
    x756 = x55 * (x101 * x754 + x56 * x755)
    x757 = x21 * x406 + x756
    x758 = x21 * x407 + x757
    x759 = x312 * x754
    x760 = x21 * x409 + x759
    x761 = x21 * x410 + x760
    x762 = x103 * x735 + x358 * x69
    x763 = x163 * x689 + x163 * x690
    x764 = x163 * x692 + x374
    x765 = x55 * (x101 * x763 + x56 * x764)
    x766 = x21 * x420 + x765
    x767 = x21 * x421 + x766
    x768 = x312 * x763
    x769 = x21 * x423 + x768
    x770 = x21 * x424 + x769
    x771 = x163 * x703 + x163 * x704
    x772 = x208 * x668
    x773 = x55 * (x208 * x672 + x772)
    x774 = x21 * x431 + x773
    x775 = x21 * x432 + x774
    x776 = x216 * x741
    x777 = x21 * x434 + x776
    x778 = x21 * x435 + x777
    x779 = x55 * (x103 * x746 + x389)
    x780 = x21 * x438 + x779
    x781 = x21 * x439 + x780
    x782 = x55 * (x103 * x745 + x392 * x69)
    x783 = x21 * x441 + x782
    x784 = x21 * x442 + x783
    x785 = x55 * (x103 * x755 + x402)
    x786 = x21 * x445 + x785
    x787 = x21 * x446 + x786
    x788 = x55 * (x103 * x754 + x405 * x69)
    x789 = x21 * x448 + x788
    x790 = x21 * x449 + x789
    x791 = x55 * (x103 * x764 + x416)
    x792 = x21 * x452 + x791
    x793 = x21 * x453 + x792
    x794 = x55 * (x103 * x763 + x419 * x69)
    x795 = x21 * x455 + x794
    x796 = x21 * x456 + x795
    x797 = x55 * (x208 * x692 + x427)
    x798 = x21 * x461 + x797
    x799 = x21 * x462 + x798
    x800 = x55 * (x208 * x689 + x208 * x690)
    x801 = x21 * x464 + x800
    x802 = x21 * x465 + x801
    x803 = x252 * x671
    x804 = x21 * x469 + x803
    x805 = x21 * x470 + x804
    x806 = x252 * x667
    x807 = x21 * x472 + x806
    x808 = x21 * x473 + x807
    x809 = -x259 * x480 + x477 * x9
    x810 = -x809
    x811 = x6 * x810
    x812 = x259 * x476 - x484 * x9
    x813 = x16 * x812
    x814 = -x4 * x813 + x5 * x810
    x815 = x4 * x814 + x811
    x816 = x56 * x811 + x56 * x815
    x817 = x283 * x811 + x56 * x816
    x818 = x55 * (x287 * x811 + x56 * x817)
    x819 = x22 * x288 + x818
    x820 = x21 * x502 + x819
    x821 = x291 * x810
    x822 = x22 * x292 + x821
    x823 = x21 * x506 + x822
    x824 = x6 * (-x809 - x813)
    x825 = x259 * x483 - x508 * x683
    x826 = x5 * x814 + x824 - x96 * (x5 * x812 - x825 * x96)
    x827 = x42 * x814
    x828 = x492 + x810 * x9
    x829 = x489 + x814 * x9
    x830 = x101 * x828 + x56 * x829
    x831 = x350 * x828 + x56 * x830
    x832 = x55 * (x56 * x831 + x696 * x828)
    x833 = x22 * x318 + x832
    x834 = x21 * x523 + x833
    x835 = x321 * x828
    x836 = x22 * x322 + x835
    x837 = x21 * x528 + x836
    x838 = x511 + x826 * x9
    x839 = x69 * x829
    x840 = x12 * x810 + x277
    x841 = x12 * x814 + x274
    x842 = x101 * x840 + x56 * x841
    x843 = x350 * x840 + x56 * x842
    x844 = x55 * (x56 * x843 + x696 * x840)
    x845 = x22 * x336 + x844
    x846 = x21 * x542 + x845
    x847 = x321 * x840
    x848 = x22 * x340 + x847
    x849 = x21 * x545 + x848
    x850 = x12 * x826 + x299
    x851 = x69 * x841
    x852 = x103 * x828 + x514
    x853 = x103 * x489 + x103 * x829
    x854 = x101 * x852 + x56 * x853
    x855 = x55 * (x350 * x852 + x56 * x854)
    x856 = x22 * x351 + x855
    x857 = x21 * x554 + x856
    x858 = x317 * x852
    x859 = x22 * x354 + x858
    x860 = x21 * x559 + x859
    x861 = x103 * x511 + x103 * x838
    x862 = x69 * x853
    x863 = x103 * x840 + x534
    x864 = x101 * x530 + x103 * x841
    x865 = x101 * x863 + x56 * x864
    x866 = x55 * (x350 * x863 + x56 * x865)
    x867 = x22 * x367 + x866
    x868 = x21 * x568 + x867
    x869 = x317 * x863
    x870 = x22 * x370 + x869
    x871 = x21 * x572 + x870
    x872 = x101 * x529 + x103 * x850
    x873 = x69 * x864
    x874 = x121 * x840 + x329
    x875 = x121 * x274 + x121 * x841
    x876 = x101 * x874 + x56 * x875
    x877 = x55 * (x350 * x874 + x56 * x876)
    x878 = x22 * x381 + x877
    x879 = x21 * x584 + x878
    x880 = x317 * x874
    x881 = x22 * x385 + x880
    x882 = x21 * x587 + x881
    x883 = x121 * x299 + x121 * x850
    x884 = x69 * x875
    x885 = x103 * x852 + x548
    x886 = x103 * x853 + x136 * x489
    x887 = x55 * (x101 * x885 + x56 * x886)
    x888 = x22 * x393 + x887
    x889 = x21 * x593 + x888
    x890 = x312 * x885
    x891 = x22 * x396 + x890
    x892 = x21 * x598 + x891
    x893 = x103 * x861 + x136 * x511
    x894 = x69 * x886
    x895 = x103 * x863 + x562
    x896 = x103 * x864 + x530 * x611
    x897 = x55 * (x101 * x895 + x56 * x896)
    x898 = x22 * x406 + x897
    x899 = x21 * x603 + x898
    x900 = x312 * x895
    x901 = x22 * x409 + x900
    x902 = x21 * x607 + x901
    x903 = x103 * x872 + x529 * x611
    x904 = x69 * x896
    x905 = x103 * x874 + x579
    x906 = x101 * x575 + x103 * x875
    x907 = x55 * (x101 * x905 + x56 * x906)
    x908 = x22 * x420 + x907
    x909 = x21 * x614 + x908
    x910 = x312 * x905
    x911 = x22 * x423 + x910
    x912 = x21 * x617 + x911
    x913 = x101 * x574 + x103 * x883
    x914 = x69 * x906
    x915 = x121 * x874 + x376
    x916 = x121 * x875 + x163 * x274
    x917 = x55 * (x101 * x915 + x56 * x916)
    x918 = x22 * x431 + x917
    x919 = x21 * x626 + x918
    x920 = x312 * x915
    x921 = x22 * x434 + x920
    x922 = x21 * x629 + x921
    x923 = x121 * x883 + x163 * x299
    x924 = x69 * x916
    x925 = x55 * (x103 * x886 + x178 * x489)
    x926 = x22 * x438 + x925
    x927 = x21 * x634 + x926
    x928 = x55 * (x103 * x885 + x591)
    x929 = x22 * x441 + x928
    x930 = x21 * x637 + x929
    x931 = x187 * x6
    x932 = x55 * (x103 * x896 + x530 * x931)
    x933 = x22 * x445 + x932
    x934 = x21 * x641 + x933
    x935 = x55 * (x103 * x895 + x601)
    x936 = x22 * x448 + x935
    x937 = x21 * x644 + x936
    x938 = x55 * (x103 * x906 + x575 * x611)
    x939 = x22 * x452 + x938
    x940 = x21 * x648 + x939
    x941 = x55 * (x103 * x905 + x612)
    x942 = x22 * x455 + x941
    x943 = x21 * x651 + x942
    x944 = x55 * (x101 * x619 + x103 * x916)
    x945 = x22 * x461 + x944
    x946 = x21 * x655 + x945
    x947 = x55 * (x103 * x915 + x624)
    x948 = x22 * x464 + x947
    x949 = x21 * x658 + x948
    x950 = x55 * (x121 * x916 + x208 * x274)
    x951 = x22 * x469 + x950
    x952 = x21 * x662 + x951
    x953 = x55 * (x121 * x915 + x430)
    x954 = x22 * x472 + x953
    x955 = x21 * x665 + x954
    x956 = x12 * x477
    x957 = x32 + x474 * x480 - x956
    x958 = x6 * x957
    x959 = -x12 * x484 + x43 + x474 * x476
    x960 = x16 * x959
    x961 = -x4 * x960 + x5 * x957
    x962 = x4 * x961
    x963 = x958 + x962
    x964 = x56 * x958 + x56 * x963
    x965 = x283 * x958 + x56 * x964
    x966 = x55 * (x287 * x958 + x56 * x965)
    x967 = x22 * x501 + x966
    x968 = x22 * x502 + x967
    x969 = x291 * x957
    x970 = x22 * x504 + x969
    x971 = x22 * x506 + x970
    x972 = x6 * (x474 * x480 - x93 - x956 - x960)
    x973 = x12 * x16
    x974 = x474 * x483 - x508 * x973 + x94
    x975 = x5 * x961 - x96 * (x5 * x959 - x96 * x974) + x972
    x976 = x4 * x975
    x977 = x6 * x961
    x978 = 2.0 * x977
    x979 = x103 * x958
    x980 = x103 * x962 + x979
    x981 = x517 * x958 + x56 * x980
    x982 = x55 * (x521 * x958 + x56 * x981)
    x983 = x22 * x522 + x982
    x984 = x22 * x523 + x983
    x985 = x525 * x957
    x986 = x22 * x526 + x985
    x987 = x22 * x528 + x986
    x988 = x12 * x957 + 2.0 * x492
    x989 = x101 * x988
    x990 = x12 * x961 + x490
    x991 = x56 * x990 + x989
    x992 = x350 * x988 + x56 * x991
    x993 = x55 * (x56 * x992 + x696 * x988)
    x994 = x22 * x541 + x993
    x995 = x22 * x542 + x994
    x996 = x321 * x988
    x997 = x22 * x544 + x996
    x998 = x22 * x545 + x997
    x999 = x12 * x975 + 2.0 * x511
    x1000 = x136 * x958
    x1001 = x1000 + x136 * x962
    x1002 = x55 * (x1001 * x56 + x552 * x958)
    x1003 = x1002 + x22 * x553
    x1004 = x1003 + x22 * x554
    x1005 = x557 * x957
    x1006 = x1005 + x22 * x558
    x1007 = x1006 + x22 * x559
    x1008 = x611 * x988
    x1009 = x1008 + x517 * x990
    x1010 = x566 * x6
    x1011 = x55 * (x1009 * x56 + x1010 * x988)
    x1012 = x1011 + x22 * x567
    x1013 = x1012 + x22 * x568
    x1014 = x570 * x988
    x1015 = x1014 + x22 * x571
    x1016 = x1015 + x22 * x572
    x1017 = x121 * x988 + x533 * x69
    x1018 = x101 * x1017
    x1019 = x121 * x990 + x531
    x1020 = x1018 + x1019 * x56
    x1021 = x55 * (x1017 * x350 + x1020 * x56)
    x1022 = x1021 + x22 * x583
    x1023 = x1022 + x22 * x584
    x1024 = x1017 * x317
    x1025 = x1024 + x22 * x586
    x1026 = x1025 + x22 * x587
    x1027 = x121 * x999 + x529 * x69
    x1028 = x178 * x958
    x1029 = x55 * (x1028 + x178 * x962)
    x1030 = x1029 + x22 * x592
    x1031 = x1030 + x22 * x593
    x1032 = x595 * x957
    x1033 = x1032 + x22 * x596
    x1034 = x1033 + x22 * x598
    x1035 = x931 * x988
    x1036 = x55 * (x1035 + x552 * x990)
    x1037 = x1036 + x22 * x602
    x1038 = x1037 + x22 * x603
    x1039 = x605 * x988
    x1040 = x1039 + x22 * x606
    x1041 = x1040 + x22 * x607
    x1042 = x1017 * x611
    x1043 = x55 * (x1019 * x517 + x1042)
    x1044 = x1043 + x22 * x613
    x1045 = x1044 + x22 * x614
    x1046 = x1017 * x566
    x1047 = x1046 + x22 * x616
    x1048 = x1047 + x22 * x617
    x1049 = x1017 * x121 + x578 * x69
    x1050 = x101 * x1049
    x1051 = x1019 * x121 + x576
    x1052 = x55 * (x1050 + x1051 * x56)
    x1053 = x1052 + x22 * x625
    x1054 = x1053 + x22 * x626
    x1055 = x1049 * x312
    x1056 = x1055 + x22 * x628
    x1057 = x1056 + x22 * x629
    x1058 = x1027 * x121 + x574 * x69
    x1059 = x219 * x961
    x1060 = x1059 + x22 * x633
    x1061 = x1060 + x22 * x634
    x1062 = x219 * x957
    x1063 = x1062 + x22 * x636
    x1064 = x1063 + x22 * x637
    x1065 = x226 * x990
    x1066 = x1065 + x22 * x640
    x1067 = x1066 + x22 * x641
    x1068 = x226 * x988
    x1069 = x1068 + x22 * x643
    x1070 = x1069 + x22 * x644
    x1071 = x1019 * x187
    x1072 = x1071 + x22 * x647
    x1073 = x1072 + x22 * x648
    x1074 = x1017 * x187
    x1075 = x1074 + x22 * x650
    x1076 = x1075 + x22 * x651
    x1077 = x1051 * x149
    x1078 = x1077 + x22 * x654
    x1079 = x1078 + x22 * x655
    x1080 = x1049 * x149
    x1081 = x1080 + x22 * x657
    x1082 = x1081 + x22 * x658
    x1083 = x55 * (x1051 * x121 + x620)
    x1084 = x1083 + x22 * x661
    x1085 = x1084 + x22 * x662
    x1086 = x55 * (x1049 * x121 + x623 * x69)
    x1087 = x1086 + x22 * x664
    x1088 = x1087 + x22 * x665
    x1089 = x259 * x667 + 2.0 * x264 - x670 * x9
    x1090 = x1089 * x291
    x1091 = x1090 + x21 * x679
    x1092 = x1091 + x21 * x680
    x1093 = x1092 + x21 * x681
    x1094 = x1089 * x6
    x1095 = x259 * x669 + 2.0 * x295 - x683 * x684
    x1096 = x1089 * x5 - x1095 * x96
    x1097 = x1096 * x4
    x1098 = x1089 * x9
    x1099 = 3.0 * x668
    x1100 = x1098 + x1099
    x1101 = x1100 * x321
    x1102 = x1101 + x21 * x700
    x1103 = x1102 + x21 * x701
    x1104 = x1103 + x21 * x702
    x1105 = x101 * x1100
    x1106 = x1096 * x9
    x1107 = 3.0 * x687
    x1108 = x1106 + x1107
    x1109 = x1089 * x339
    x1110 = x1109 + x21 * x713
    x1111 = x1110 + x21 * x714
    x1112 = x1111 + x21 * x715
    x1113 = x1094 * x121
    x1114 = x1094 * x12
    x1115 = x103 * x1100 + x62 * x691
    x1116 = x1115 * x317
    x1117 = x1116 + x21 * x722
    x1118 = x1117 + x21 * x723
    x1119 = x1118 + x21 * x724
    x1120 = x101 * x1115
    x1121 = x103 * x1108 + x62 * x693
    x1122 = x1098 * x121 + x1099 * x121
    x1123 = x1122 * x317
    x1124 = x1123 + x21 * x732
    x1125 = x1124 + x21 * x733
    x1126 = x1125 + x21 * x734
    x1127 = x101 * x1122
    x1128 = x1106 * x121 + x1107 * x121
    x1129 = x1089 * x218
    x1130 = x1129 * x175
    x1131 = x1130 + x21 * x742
    x1132 = x1131 + x21 * x743
    x1133 = x1132 + x21 * x744
    x1134 = x1094 * x163
    x1135 = x103 * x1115 + x62 * x716
    x1136 = x1135 * x312
    x1137 = x1136 + x21 * x750
    x1138 = x1137 + x21 * x751
    x1139 = x1138 + x21 * x752
    x1140 = x101 * x1135
    x1141 = x103 * x1121 + x62 * x717
    x1142 = x103 * x1122 + x62 * x726
    x1143 = x1142 * x312
    x1144 = x1143 + x21 * x759
    x1145 = x1144 + x21 * x760
    x1146 = x1145 + x21 * x761
    x1147 = x101 * x1142
    x1148 = x103 * x1128 + x62 * x727
    x1149 = x1098 * x163 + x1099 * x163
    x1150 = x1149 * x312
    x1151 = x1150 + x21 * x768
    x1152 = x1151 + x21 * x769
    x1153 = x1152 + x21 * x770
    x1154 = x101 * x1149
    x1155 = x1106 * x163 + x1107 * x163
    x1156 = x1129 * x216
    x1157 = x1156 + x21 * x776
    x1158 = x1157 + x21 * x777
    x1159 = x1158 + x21 * x778
    x1160 = x1094 * x208
    x1161 = x55 * (x103 * x1135 + x62 * x745)
    x1162 = x1161 + x21 * x782
    x1163 = x1162 + x21 * x783
    x1164 = x1163 + x21 * x784
    x1165 = x55 * (x103 * x1142 + x62 * x754)
    x1166 = x1165 + x21 * x788
    x1167 = x1166 + x21 * x789
    x1168 = x1167 + x21 * x790
    x1169 = x55 * (x103 * x1149 + x62 * x763)
    x1170 = x1169 + x21 * x794
    x1171 = x1170 + x21 * x795
    x1172 = x1171 + x21 * x796
    x1173 = x55 * (x1098 * x208 + x1099 * x208)
    x1174 = x1173 + x21 * x800
    x1175 = x1174 + x21 * x801
    x1176 = x1175 + x21 * x802
    x1177 = x1089 * x252
    x1178 = x1177 + x21 * x806
    x1179 = x1178 + x21 * x807
    x1180 = x1179 + x21 * x808
    x1181 = x259 * x810 + x479 - x813 * x9
    x1182 = x1181 * x291
    x1183 = x1182 + x22 * x679
    x1184 = x1183 + x21 * x822
    x1185 = x1184 + x21 * x823
    x1186 = x1181 * x6
    x1187 = x259 * x812 + x507 - x683 * x825
    x1188 = x1181 * x5 - x1187 * x96
    x1189 = 2.0 * x811
    x1190 = x1181 * x9 + x1189
    x1191 = x1190 * x321
    x1192 = x1191 + x22 * x700
    x1193 = x1192 + x21 * x836
    x1194 = x1193 + x21 * x837
    x1195 = x1188 * x9 + x827
    x1196 = x1181 * x12 + x668
    x1197 = x1196 * x321
    x1198 = x1197 + x22 * x713
    x1199 = x1198 + x21 * x848
    x1200 = x1199 + x21 * x849
    x1201 = x1188 * x12 + x687
    x1202 = x103 * x1190 + x69 * x828
    x1203 = x1202 * x317
    x1204 = x1203 + x22 * x722
    x1205 = x1204 + x21 * x859
    x1206 = x1205 + x21 * x860
    x1207 = x103 * x1195 + x839
    x1208 = x69 * x840
    x1209 = x103 * x1196 + x1208
    x1210 = x1209 * x317
    x1211 = x1210 + x22 * x732
    x1212 = x1211 + x21 * x870
    x1213 = x1212 + x21 * x871
    x1214 = x103 * x1201 + x851
    x1215 = x1196 * x121 + x706
    x1216 = x1215 * x317
    x1217 = x1216 + x22 * x742
    x1218 = x1217 + x21 * x881
    x1219 = x1218 + x21 * x882
    x1220 = x1201 * x121 + x121 * x687
    x1221 = x103 * x1202 + x69 * x852
    x1222 = x1221 * x312
    x1223 = x1222 + x22 * x750
    x1224 = x1223 + x21 * x891
    x1225 = x1224 + x21 * x892
    x1226 = x103 * x1207 + x862
    x1227 = x103 * x1209 + x69 * x863
    x1228 = x1227 * x312
    x1229 = x1228 + x22 * x759
    x1230 = x1229 + x21 * x901
    x1231 = x1230 + x21 * x902
    x1232 = x103 * x1214 + x873
    x1233 = x69 * x874
    x1234 = x103 * x1215 + x1233
    x1235 = x1234 * x312
    x1236 = x1235 + x22 * x768
    x1237 = x1236 + x21 * x911
    x1238 = x1237 + x21 * x912
    x1239 = x103 * x1220 + x884
    x1240 = x121 * x1215 + x736
    x1241 = x1240 * x312
    x1242 = x1241 + x22 * x776
    x1243 = x1242 + x21 * x921
    x1244 = x1243 + x21 * x922
    x1245 = x121 * x1220 + x163 * x687
    x1246 = x55 * (x103 * x1221 + x69 * x885)
    x1247 = x1246 + x22 * x782
    x1248 = x1247 + x21 * x929
    x1249 = x1248 + x21 * x930
    x1250 = x55 * (x103 * x1227 + x69 * x895)
    x1251 = x1250 + x22 * x788
    x1252 = x1251 + x21 * x936
    x1253 = x1252 + x21 * x937
    x1254 = x55 * (x103 * x1234 + x69 * x905)
    x1255 = x1254 + x22 * x794
    x1256 = x1255 + x21 * x942
    x1257 = x1256 + x21 * x943
    x1258 = x69 * x915
    x1259 = x55 * (x103 * x1240 + x1258)
    x1260 = x1259 + x22 * x800
    x1261 = x1260 + x21 * x948
    x1262 = x1261 + x21 * x949
    x1263 = x55 * (x121 * x1240 + x772)
    x1264 = x1263 + x22 * x806
    x1265 = x1264 + x21 * x954
    x1266 = x1265 + x21 * x955
    x1267 = x259 * x957 - x9 * x960
    x1268 = x1267 * x291
    x1269 = x1268 + x22 * x821
    x1270 = x1269 + x22 * x822
    x1271 = x1270 + x21 * x971
    x1272 = x1267 * x6
    x1273 = x259 * x959 - x683 * x974
    x1274 = x1267 * x5 - x1273 * x96
    x1275 = x1267 * x9 + x958
    x1276 = x1275 * x321
    x1277 = x1276 + x22 * x835
    x1278 = x1277 + x22 * x836
    x1279 = x1278 + x21 * x987
    x1280 = x1274 * x9 + x977
    x1281 = x1189 + x12 * x1267
    x1282 = x1281 * x321
    x1283 = x1282 + x22 * x847
    x1284 = x1283 + x22 * x848
    x1285 = x1284 + x21 * x998
    x1286 = x12 * x1274 + x827
    x1287 = x103 * x1275 + x979
    x1288 = x1287 * x317
    x1289 = x1288 + x22 * x858
    x1290 = x1289 + x22 * x859
    x1291 = x1007 * x21 + x1290
    x1292 = x103 * x1280 + x103 * x977
    x1293 = x103 * x1281 + x989
    x1294 = x1293 * x317
    x1295 = x1294 + x22 * x869
    x1296 = x1295 + x22 * x870
    x1297 = x1016 * x21 + x1296
    x1298 = x101 * x990 + x103 * x1286
    x1299 = x1208 + x121 * x1281
    x1300 = x1299 * x317
    x1301 = x1300 + x22 * x880
    x1302 = x1301 + x22 * x881
    x1303 = x1026 * x21 + x1302
    x1304 = x121 * x1286 + x851
    x1305 = x1000 + x103 * x1287
    x1306 = x1305 * x312
    x1307 = x1306 + x22 * x890
    x1308 = x1307 + x22 * x891
    x1309 = x1034 * x21 + x1308
    x1310 = x103 * x1292 + x136 * x977
    x1311 = x1008 + x103 * x1293
    x1312 = x1311 * x312
    x1313 = x1312 + x22 * x900
    x1314 = x1313 + x22 * x901
    x1315 = x1041 * x21 + x1314
    x1316 = x103 * x1298 + x611 * x990
    x1317 = x1018 + x103 * x1299
    x1318 = x1317 * x312
    x1319 = x1318 + x22 * x910
    x1320 = x1319 + x22 * x911
    x1321 = x1048 * x21 + x1320
    x1322 = x101 * x1019 + x103 * x1304
    x1323 = x121 * x1299 + x1233
    x1324 = x1323 * x312
    x1325 = x1324 + x22 * x920
    x1326 = x1325 + x22 * x921
    x1327 = x1057 * x21 + x1326
    x1328 = x121 * x1304 + x884
    x1329 = x55 * (x1028 + x103 * x1305)
    x1330 = x1329 + x22 * x928
    x1331 = x1330 + x22 * x929
    x1332 = x1064 * x21 + x1331
    x1333 = x55 * (x103 * x1311 + x1035)
    x1334 = x1333 + x22 * x935
    x1335 = x1334 + x22 * x936
    x1336 = x1070 * x21 + x1335
    x1337 = x55 * (x103 * x1317 + x1042)
    x1338 = x1337 + x22 * x941
    x1339 = x1338 + x22 * x942
    x1340 = x1076 * x21 + x1339
    x1341 = x55 * (x103 * x1323 + x1050)
    x1342 = x1341 + x22 * x947
    x1343 = x1342 + x22 * x948
    x1344 = x1082 * x21 + x1343
    x1345 = x55 * (x121 * x1323 + x1258)
    x1346 = x1345 + x22 * x953
    x1347 = x1346 + x22 * x954
    x1348 = x1088 * x21 + x1347
    x1349 = -x12 * x960 + x474 * x957 + 2.0 * x479
    x1350 = x1349 * x291
    x1351 = x1350 + x22 * x969
    x1352 = x1351 + x22 * x970
    x1353 = x1352 + x22 * x971
    x1354 = x1349 * x6
    x1355 = x474 * x959 + 2.0 * x507 - x973 * x974
    x1356 = x1349 * x5 - x1355 * x96
    x1357 = x1356 * x4
    x1358 = x1349 * x525
    x1359 = x1358 + x22 * x985
    x1360 = x1359 + x22 * x986
    x1361 = x1360 + x22 * x987
    x1362 = x103 * x1354
    x1363 = x12 * x1349 + 3.0 * x958
    x1364 = x1363 * x321
    x1365 = x1364 + x22 * x996
    x1366 = x1365 + x22 * x997
    x1367 = x1366 + x22 * x998
    x1368 = x101 * x1363
    x1369 = x12 * x1356 + 3.0 * x977
    x1370 = x1349 * x557
    x1371 = x1005 * x22 + x1370
    x1372 = x1006 * x22 + x1371
    x1373 = x1007 * x22 + x1372
    x1374 = x1354 * x136
    x1375 = x1363 * x570
    x1376 = x1014 * x22 + x1375
    x1377 = x1015 * x22 + x1376
    x1378 = x1016 * x22 + x1377
    x1379 = x1363 * x611
    x1380 = x121 * x1363 + x62 * x988
    x1381 = x1380 * x317
    x1382 = x1024 * x22 + x1381
    x1383 = x1025 * x22 + x1382
    x1384 = x1026 * x22 + x1383
    x1385 = x101 * x1380
    x1386 = x121 * x1369 + x62 * x990
    x1387 = x1349 * x595
    x1388 = x1032 * x22 + x1387
    x1389 = x1033 * x22 + x1388
    x1390 = x1034 * x22 + x1389
    x1391 = x1354 * x178
    x1392 = x1363 * x605
    x1393 = x1039 * x22 + x1392
    x1394 = x1040 * x22 + x1393
    x1395 = x1041 * x22 + x1394
    x1396 = x1363 * x931
    x1397 = x1380 * x566
    x1398 = x1046 * x22 + x1397
    x1399 = x1047 * x22 + x1398
    x1400 = x1048 * x22 + x1399
    x1401 = x1380 * x611
    x1402 = x1017 * x62 + x121 * x1380
    x1403 = x1402 * x312
    x1404 = x1055 * x22 + x1403
    x1405 = x1056 * x22 + x1404
    x1406 = x1057 * x22 + x1405
    x1407 = x101 * x1402
    x1408 = x1019 * x62 + x121 * x1386
    x1409 = x1349 * x219
    x1410 = x1062 * x22 + x1409
    x1411 = x1063 * x22 + x1410
    x1412 = x1064 * x22 + x1411
    x1413 = x1363 * x226
    x1414 = x1068 * x22 + x1413
    x1415 = x1069 * x22 + x1414
    x1416 = x1070 * x22 + x1415
    x1417 = x1380 * x187
    x1418 = x1074 * x22 + x1417
    x1419 = x1075 * x22 + x1418
    x1420 = x1076 * x22 + x1419
    x1421 = x1402 * x149
    x1422 = x1080 * x22 + x1421
    x1423 = x1081 * x22 + x1422
    x1424 = x1082 * x22 + x1423
    x1425 = x55 * (x1049 * x62 + x121 * x1402)
    x1426 = x1086 * x22 + x1425
    x1427 = x1087 * x22 + x1426
    x1428 = x1088 * x22 + x1427
    x1429 = x1089 * x259 - x1095 * x683 + 3.0 * x682
    x1430 = x1429 * x9
    x1431 = 4.0 * x1094
    x1432 = x1430 + x1431
    x1433 = x103 * x1432 + 4.0 * x1105
    x1434 = x121 * x1430 + x121 * x1431
    x1435 = x1429 * x218
    x1436 = x103 * x1433 + 4.0 * x1120
    x1437 = x103 * x1434 + 4.0 * x1127
    x1438 = x1430 * x163 + x1431 * x163
    x1439 = x1181 * x259 - x1187 * x683 + 2.0 * x824
    x1440 = 3.0 * x1186 + x1439 * x9
    x1441 = x1094 + x12 * x1439
    x1442 = x103 * x1440 + x1190 * x62
    x1443 = x103 * x1441 + x1196 * x62
    x1444 = x1113 + x121 * x1441
    x1445 = x103 * x1442 + x1202 * x62
    x1446 = x103 * x1443 + x1209 * x62
    x1447 = x103 * x1444 + x1215 * x62
    x1448 = x1134 + x121 * x1444
    x1449 = x1267 * x259 - x1273 * x683 + x972
    x1450 = 2.0 * x1272 + x1449 * x9
    x1451 = 2.0 * x1186 + x12 * x1449
    x1452 = x103 * x1450 + x1275 * x69
    x1453 = x103 * x1451 + x1281 * x69
    x1454 = x1196 * x69 + x121 * x1451
    x1455 = x103 * x1452 + x1287 * x69
    x1456 = x103 * x1453 + x1293 * x69
    x1457 = x103 * x1454 + x1299 * x69
    x1458 = x121 * x1454 + x1215 * x69
    x1459 = x1349 * x259 - x1355 * x683
    x1460 = x1354 + x1459 * x9
    x1461 = x12 * x1459 + 3.0 * x1272
    x1462 = x103 * x1460 + x1362
    x1463 = x103 * x1461 + x1368
    x1464 = x121 * x1461 + x1281 * x62
    x1465 = x103 * x1462 + x1374
    x1466 = x103 * x1463 + x1379
    x1467 = x103 * x1464 + x1385
    x1468 = x121 * x1464 + x1299 * x62
    x1469 = x1349 * x474 - x1355 * x973 + 3.0 * x972
    x1470 = x12 * x1469 + 4.0 * x1354
    x1471 = x121 * x1470 + 4.0 * x1368
    x1472 = x121 * x1471 + 4.0 * x1385

    # 225 item(s)
    return numpy.array(
        [
            x0 * x76
            + x0 * x81
            + x0 * x88
            + x0 * (x0 * (x0 * (x86 + x89 * x92) + x87) + x88)
            + x55
            * (x102 * x71 + x56 * (x102 * x63 + x56 * (x102 * x54 + x56 * (x100 + x98)))),
            x0 * x110
            + x0 * x115
            + x0 * x119
            + x0 * (x0 * (x0 * (x117 + x120 * x9) + x118) + x119)
            + x55
            * (x102 * x106 + x56 * (x102 * x104 + x56 * (x100 * x103 + x103 * x98))),
            x0 * x128
            + x0 * x131
            + x0 * x134
            + x0 * (x0 * (x0 * (x12 * x120 + x132) + x133) + x134)
            + x55
            * (x102 * x124 + x56 * (x102 * x122 + x56 * (x100 * x121 + x121 * x98))),
            x0 * x139
            + x0 * x143
            + x0 * x147
            + x0 * (x0 * (x0 * (x145 + x148 * x92) + x146) + x147)
            + x55 * (x102 * x137 + x56 * (x100 * x136 + x136 * x98)),
            x0 * x153
            + x0 * x158
            + x0 * x161
            + x0 * (x0 * (x0 * (x159 + x162 * x92) + x160) + x161)
            + x55 * (x102 * x151 + x56 * (x100 * x150 + x150 * x98)),
            x0 * x166
            + x0 * x170
            + x0 * x174
            + x0 * (x0 * (x0 * (x172 + x175 * x92) + x173) + x174)
            + x55 * (x102 * x164 + x56 * (x100 * x163 + x163 * x98)),
            x0 * x179
            + x0 * x181
            + x0 * x185
            + x0 * (x0 * (x0 * (x183 + x186 * x4) + x184) + x185)
            + x55 * (x100 * x178 + x178 * x98),
            x0 * x189
            + x0 * x191
            + x0 * x195
            + x0 * (x0 * (x0 * (x193 + x196 * x92) + x194) + x195)
            + x55 * (x100 * x188 + x188 * x98),
            x0 * x199
            + x0 * x201
            + x0 * x205
            + x0 * (x0 * (x0 * (x203 + x206 * x92) + x204) + x205)
            + x55 * (x100 * x198 + x198 * x98),
            x0 * x209
            + x0 * x211
            + x0 * x215
            + x0 * (x0 * (x0 * (x213 + x216 * x92) + x214) + x215)
            + x55 * (x100 * x208 + x208 * x98),
            x0 * x220
            + x0 * x222
            + x0 * x225
            + x0 * (x0 * (x0 * (x217 * x92 + x223) + x224) + x225)
            + x219 * x97,
            x0 * x228
            + x0 * x230
            + x0 * x233
            + x0 * (x0 * (x0 * (x12 * x186 + x231) + x232) + x233)
            + x227 * x97,
            x0 * x236
            + x0 * x239
            + x0 * x242
            + x0 * (x0 * (x0 * (x235 * x92 + x240) + x241) + x242)
            + x237 * x97,
            x0 * x244
            + x0 * x247
            + x0 * x250
            + x0 * (x0 * (x0 * (x243 * x92 + x248) + x249) + x250)
            + x245 * x97,
            x0 * x253
            + x0 * x255
            + x0 * x258
            + x0 * (x0 * (x0 * (x251 * x92 + x256) + x257) + x258)
            + x252 * x97,
            x0 * x286
            + x0 * x290
            + x0 * (x0 * (x0 * x294 + x289) + x290)
            + x21 * x76
            + x55
            * (
                x282 * x62 + x56 * (x280 * x62 + x56 * (x276 * x62 + x56 * (x298 + x300)))
            ),
            x0 * x316
            + x0 * x320
            + x0 * (x0 * (x0 * x324 + x319) + x320)
            + x110 * x21
            + x55 * (x311 * x62 + x56 * (x306 * x62 + x56 * (x302 * x62 + x326 * x56))),
            x0 * x335
            + x0 * x338
            + x0 * (x0 * (x0 * x341 + x337) + x338)
            + x128 * x21
            + x55 * (x331 * x62 + x56 * (x328 * x62 + x56 * (x121 * x298 + x121 * x300))),
            x0 * x349
            + x0 * x353
            + x0 * (x0 * (x0 * x355 + x352) + x353)
            + x139 * x21
            + x55 * (x345 * x62 + x56 * (x342 * x62 + x356 * x56)),
            x0 * x366
            + x0 * x369
            + x0 * (x0 * (x0 * x371 + x368) + x369)
            + x153 * x21
            + x55 * (x362 * x62 + x56 * (x358 * x62 + x373 * x56)),
            x0 * x379
            + x0 * x383
            + x0 * (x0 * (x0 * x386 + x382) + x383)
            + x166 * x21
            + x55 * (x375 * x62 + x56 * (x163 * x298 + x163 * x300)),
            x0 * x391
            + x0 * x395
            + x0 * (x0 * (x0 * x398 + x394) + x395)
            + x179 * x21
            + x55 * (x387 * x62 + x399 * x56),
            x0 * x404
            + x0 * x408
            + x0 * (x0 * (x0 * x410 + x407) + x408)
            + x189 * x21
            + x55 * (x400 * x62 + x411 * x56),
            x0 * x418
            + x0 * x422
            + x0 * (x0 * (x0 * x424 + x421) + x422)
            + x199 * x21
            + x55 * (x413 * x62 + x426 * x56),
            x0 * x429
            + x0 * x433
            + x0 * (x0 * (x0 * x435 + x432) + x433)
            + x209 * x21
            + x55 * (x208 * x298 + x208 * x300),
            x0 * x437
            + x0 * x440
            + x0 * (x0 * (x0 * x442 + x439) + x440)
            + x21 * x220
            + x55 * (x103 * x399 + x178 * x99),
            x0 * x444
            + x0 * x447
            + x0 * (x0 * (x0 * x449 + x446) + x447)
            + x21 * x228
            + x55 * (x103 * x411 + x188 * x99),
            x0 * x451
            + x0 * x454
            + x0 * (x0 * (x0 * x456 + x453) + x454)
            + x21 * x236
            + x55 * (x103 * x426 + x198 * x99),
            x0 * x459
            + x0 * x463
            + x0 * (x0 * (x0 * x465 + x462) + x463)
            + x21 * x244
            + x55 * (x208 * x325 + x466),
            x0 * x468
            + x0 * x471
            + x0 * (x0 * (x0 * x473 + x470) + x471)
            + x21 * x253
            + x252 * x297,
            x0 * x500
            + x0 * x503
            + x0 * (x0 * (x0 * x506 + x502) + x503)
            + x22 * x76
            + x55
            * (
                x497 * x62 + x56 * (x495 * x62 + x56 * (x491 * x62 + x56 * (x510 + x512)))
            ),
            x0 * x520
            + x0 * x524
            + x0 * (x0 * (x0 * x528 + x523) + x524)
            + x110 * x22
            + x55 * (x516 * x62 + x56 * (x513 * x62 + x56 * (x103 * x510 + x103 * x512))),
            x0 * x539
            + x0 * x543
            + x0 * (x0 * (x0 * x545 + x542) + x543)
            + x128 * x22
            + x55 * (x536 * x62 + x56 * (x532 * x62 + x56 * (x529 * x62 + x546 * x56))),
            x0 * x551
            + x0 * x555
            + x0 * (x0 * (x0 * x559 + x554) + x555)
            + x139 * x22
            + x55 * (x547 * x62 + x56 * (x136 * x510 + x136 * x512)),
            x0 * x565
            + x0 * x569
            + x0 * (x0 * (x0 * x572 + x568) + x569)
            + x153 * x22
            + x55 * (x56 * (x149 * x573 + x517 * x546) + x561 * x62),
            x0 * x582
            + x0 * x585
            + x0 * (x0 * (x0 * x587 + x584) + x585)
            + x166 * x22
            + x55 * (x56 * (x56 * x588 + x574 * x62) + x577 * x62),
            x0 * x590
            + x0 * x594
            + x0 * (x0 * (x0 * x598 + x593) + x594)
            + x179 * x22
            + x55 * (x178 * x510 + x178 * x512),
            x0 * x600
            + x0 * x604
            + x0 * (x0 * (x0 * x607 + x603) + x604)
            + x189 * x22
            + x55 * (x187 * x573 + x546 * x552),
            x0 * x610
            + x0 * x615
            + x0 * (x0 * (x0 * x617 + x614) + x615)
            + x199 * x22
            + x55 * (x149 * x574 * x61 + x517 * x588),
            x0 * x622
            + x0 * x627
            + x0 * (x0 * (x0 * x629 + x626) + x627)
            + x209 * x22
            + x55 * (x56 * x630 + x618 * x62),
            x0 * x632
            + x0 * x635
            + x0 * (x0 * (x0 * x637 + x634) + x635)
            + x219 * x509
            + x22 * x220,
            x0 * x639
            + x0 * x642
            + x0 * (x0 * (x0 * x644 + x641) + x642)
            + x22 * x228
            + x226 * x546,
            x0 * x646
            + x0 * x649
            + x0 * (x0 * (x0 * x651 + x648) + x649)
            + x187 * x588
            + x22 * x236,
            x0 * x653
            + x0 * x656
            + x0 * (x0 * (x0 * x658 + x655) + x656)
            + x149 * x630
            + x22 * x244,
            x0 * x660
            + x0 * x663
            + x0 * (x0 * (x0 * x665 + x662) + x663)
            + x22 * x253
            + x55 * (x121 * x630 + x466),
            x0 * x678
            + x0 * (x0 * x681 + x678)
            + x21 * x285
            + x21 * x286
            + x55
            * (
                x56 * (x56 * (x56 * (x686 + x688) + x673 * x69) + x674 * x69) + x675 * x69
            ),
            x0 * x699
            + x0 * (x0 * x702 + x699)
            + x21 * x315
            + x21 * x316
            + x55 * (x56 * (x56 * (x56 * x705 + x69 * x693) + x69 * x694) + x69 * x695),
            x0 * x712
            + x0 * (x0 * x715 + x712)
            + x21 * x334
            + x21 * x335
            + x55 * (x56 * (x56 * (x121 * x686 + x121 * x688) + x69 * x707) + x69 * x709),
            x0 * x721
            + x0 * (x0 * x724 + x721)
            + x21 * x348
            + x21 * x349
            + x55 * (x56 * (x56 * x725 + x69 * x717) + x69 * x718),
            x0 * x731
            + x0 * (x0 * x734 + x731)
            + x21 * x365
            + x21 * x366
            + x55 * (x56 * (x56 * x735 + x69 * x727) + x69 * x728),
            x0 * x740
            + x0 * (x0 * x744 + x740)
            + x21 * x378
            + x21 * x379
            + x55 * (x56 * (x163 * x686 + x163 * x688) + x69 * x737),
            x0 * x749
            + x0 * (x0 * x752 + x749)
            + x21 * x390
            + x21 * x391
            + x55 * (x56 * x753 + x69 * x746),
            x0 * x758
            + x0 * (x0 * x761 + x758)
            + x21 * x403
            + x21 * x404
            + x55 * (x56 * x762 + x69 * x755),
            x0 * x767
            + x0 * (x0 * x770 + x767)
            + x21 * x417
            + x21 * x418
            + x55 * (x56 * x771 + x69 * x764),
            x0 * x775
            + x0 * (x0 * x778 + x775)
            + x21 * x428
            + x21 * x429
            + x55 * (x208 * x686 + x208 * x688),
            x0 * x781
            + x0 * (x0 * x784 + x781)
            + x21 * x436
            + x21 * x437
            + x55 * (x103 * x753 + x387 * x69),
            x0 * x787
            + x0 * (x0 * x790 + x787)
            + x21 * x443
            + x21 * x444
            + x55 * (x103 * x762 + x400 * x69),
            x0 * x793
            + x0 * (x0 * x796 + x793)
            + x21 * x450
            + x21 * x451
            + x55 * (x103 * x771 + x413 * x69),
            x0 * x799
            + x0 * (x0 * x802 + x799)
            + x21 * x458
            + x21 * x459
            + x55 * (x208 * x703 + x208 * x704),
            x0 * x805 + x0 * (x0 * x808 + x805) + x21 * x467 + x21 * x468 + x252 * x685,
            x0 * x820
            + x0 * (x0 * x823 + x820)
            + x21 * x500
            + x22 * x285
            + x55
            * (
                x56 * (x56 * (x56 * (x4 * x826 + x827) + x69 * x815) + x69 * x816)
                + x69 * x817
            ),
            x0 * x834
            + x0 * (x0 * x837 + x834)
            + x21 * x520
            + x22 * x315
            + x55 * (x56 * (x56 * (x56 * x838 + x839) + x69 * x830) + x69 * x831),
            x0 * x846
            + x0 * (x0 * x849 + x846)
            + x21 * x539
            + x22 * x334
            + x55 * (x56 * (x56 * (x56 * x850 + x851) + x69 * x842) + x69 * x843),
            x0 * x857
            + x0 * (x0 * x860 + x857)
            + x21 * x551
            + x22 * x348
            + x55 * (x56 * (x56 * x861 + x862) + x69 * x854),
            x0 * x868
            + x0 * (x0 * x871 + x868)
            + x21 * x565
            + x22 * x365
            + x55 * (x56 * (x56 * x872 + x873) + x69 * x865),
            x0 * x879
            + x0 * (x0 * x882 + x879)
            + x21 * x582
            + x22 * x378
            + x55 * (x56 * (x56 * x883 + x884) + x69 * x876),
            x0 * x889
            + x0 * (x0 * x892 + x889)
            + x21 * x590
            + x22 * x390
            + x55 * (x56 * x893 + x894),
            x0 * x899
            + x0 * (x0 * x902 + x899)
            + x21 * x600
            + x22 * x403
            + x55 * (x56 * x903 + x904),
            x0 * x909
            + x0 * (x0 * x912 + x909)
            + x21 * x610
            + x22 * x417
            + x55 * (x56 * x913 + x914),
            x0 * x919
            + x0 * (x0 * x922 + x919)
            + x21 * x622
            + x22 * x428
            + x55 * (x56 * x923 + x924),
            x0 * x927
            + x0 * (x0 * x930 + x927)
            + x21 * x632
            + x22 * x436
            + x55 * (x103 * x893 + x178 * x511),
            x0 * x934
            + x0 * (x0 * x937 + x934)
            + x21 * x639
            + x22 * x443
            + x55 * (x103 * x903 + x529 * x931),
            x0 * x940
            + x0 * (x0 * x943 + x940)
            + x21 * x646
            + x22 * x450
            + x55 * (x103 * x913 + x574 * x611),
            x0 * x946
            + x0 * (x0 * x949 + x946)
            + x21 * x653
            + x22 * x458
            + x55 * (x101 * x618 + x103 * x923),
            x0 * x952
            + x0 * (x0 * x955 + x952)
            + x21 * x660
            + x22 * x467
            + x55 * (x121 * x923 + x208 * x299),
            x0 * x968
            + x0 * (x0 * x971 + x968)
            + x22 * x499
            + x22 * x500
            + x55
            * (
                x56 * (x56 * (x56 * (x976 + x978) + x69 * x963) + x69 * x964) + x69 * x965
            ),
            x0 * x984
            + x0 * (x0 * x987 + x984)
            + x22 * x519
            + x22 * x520
            + x55 * (x56 * (x56 * (x103 * x976 + x103 * x978) + x69 * x980) + x69 * x981),
            x0 * x995
            + x0 * (x0 * x998 + x995)
            + x22 * x538
            + x22 * x539
            + x55 * (x56 * (x56 * (x56 * x999 + x69 * x990) + x69 * x991) + x69 * x992),
            x0 * x1004
            + x0 * (x0 * x1007 + x1004)
            + x22 * x550
            + x22 * x551
            + x55 * (x1001 * x69 + x56 * (x136 * x976 + x136 * x978)),
            x0 * x1013
            + x0 * (x0 * x1016 + x1013)
            + x22 * x564
            + x22 * x565
            + x55 * (x1009 * x69 + x56 * (x517 * x999 + x608 * x990)),
            x0 * x1023
            + x0 * (x0 * x1026 + x1023)
            + x22 * x581
            + x22 * x582
            + x55 * (x1020 * x69 + x56 * (x1019 * x69 + x1027 * x56)),
            x0 * x1031
            + x0 * (x0 * x1034 + x1031)
            + x22 * x589
            + x22 * x590
            + x55 * (x178 * x976 + x178 * x978),
            x0 * x1038
            + x0 * (x0 * x1041 + x1038)
            + x22 * x599
            + x22 * x600
            + x55 * (x187 * x42 * x990 + x552 * x999),
            x0 * x1045
            + x0 * (x0 * x1048 + x1045)
            + x22 * x609
            + x22 * x610
            + x55 * (x1019 * x608 + x1027 * x517),
            x0 * x1054
            + x0 * (x0 * x1057 + x1054)
            + x22 * x621
            + x22 * x622
            + x55 * (x1051 * x69 + x1058 * x56),
            x0 * x1061
            + x0 * (x0 * x1064 + x1061)
            + x219 * x975
            + x22 * x631
            + x22 * x632,
            x0 * x1067
            + x0 * (x0 * x1070 + x1067)
            + x22 * x638
            + x22 * x639
            + x226 * x999,
            x0 * x1073
            + x0 * (x0 * x1076 + x1073)
            + x1027 * x187
            + x22 * x645
            + x22 * x646,
            x0 * x1079
            + x0 * (x0 * x1082 + x1079)
            + x1058 * x149
            + x22 * x652
            + x22 * x653,
            x0 * x1085
            + x0 * (x0 * x1088 + x1085)
            + x22 * x659
            + x22 * x660
            + x55 * (x1058 * x121 + x618 * x69),
            x0 * x1093
            + x21 * x676
            + x21 * x677
            + x21 * x678
            + x55
            * (
                x1094 * x287
                + x56 * (x1094 * x283 + x56 * (x1094 * x56 + x56 * (x1094 + x1097)))
            ),
            x0 * x1104
            + x21 * x697
            + x21 * x698
            + x21 * x699
            + x55 * (x1100 * x696 + x56 * (x1100 * x350 + x56 * (x1105 + x1108 * x56))),
            x0 * x1112
            + x21 * x710
            + x21 * x711
            + x21 * x712
            + x55 * (x1114 * x317 + x56 * (x1114 * x312 + x56 * (x1097 * x121 + x1113))),
            x0 * x1119
            + x21 * x719
            + x21 * x720
            + x21 * x721
            + x55 * (x1115 * x350 + x56 * (x1120 + x1121 * x56)),
            x0 * x1126
            + x21 * x729
            + x21 * x730
            + x21 * x731
            + x55 * (x1122 * x350 + x56 * (x1127 + x1128 * x56)),
            x0 * x1133
            + x21 * x738
            + x21 * x739
            + x21 * x740
            + x55 * (x1094 * x380 + x56 * (x1097 * x163 + x1134)),
            x0 * x1139
            + x21 * x747
            + x21 * x748
            + x21 * x749
            + x55 * (x1140 + x1141 * x56),
            x0 * x1146
            + x21 * x756
            + x21 * x757
            + x21 * x758
            + x55 * (x1147 + x1148 * x56),
            x0 * x1153
            + x21 * x765
            + x21 * x766
            + x21 * x767
            + x55 * (x1154 + x1155 * x56),
            x0 * x1159
            + x21 * x773
            + x21 * x774
            + x21 * x775
            + x55 * (x1097 * x208 + x1160),
            x0 * x1164
            + x21 * x779
            + x21 * x780
            + x21 * x781
            + x55 * (x103 * x1141 + x62 * x746),
            x0 * x1168
            + x21 * x785
            + x21 * x786
            + x21 * x787
            + x55 * (x103 * x1148 + x62 * x755),
            x0 * x1172
            + x21 * x791
            + x21 * x792
            + x21 * x793
            + x55 * (x103 * x1155 + x62 * x764),
            x0 * x1176
            + x21 * x797
            + x21 * x798
            + x21 * x799
            + x55 * (x1106 * x208 + x1107 * x208),
            x0 * x1180 + x1096 * x252 + x21 * x803 + x21 * x804 + x21 * x805,
            x0 * x1185
            + x21 * x819
            + x21 * x820
            + x22 * x676
            + x55
            * (
                x1186 * x287
                + x56 * (x1186 * x283 + x56 * (x1186 * x56 + x56 * (x1186 + x1188 * x4)))
            ),
            x0 * x1194
            + x21 * x833
            + x21 * x834
            + x22 * x697
            + x55
            * (x1190 * x696 + x56 * (x1190 * x350 + x56 * (x101 * x1190 + x1195 * x56))),
            x0 * x1200
            + x21 * x845
            + x21 * x846
            + x22 * x710
            + x55
            * (x1196 * x696 + x56 * (x1196 * x350 + x56 * (x101 * x1196 + x1201 * x56))),
            x0 * x1206
            + x21 * x856
            + x21 * x857
            + x22 * x719
            + x55 * (x1202 * x350 + x56 * (x101 * x1202 + x1207 * x56)),
            x0 * x1213
            + x21 * x867
            + x21 * x868
            + x22 * x729
            + x55 * (x1209 * x350 + x56 * (x101 * x1209 + x1214 * x56)),
            x0 * x1219
            + x21 * x878
            + x21 * x879
            + x22 * x738
            + x55 * (x1215 * x350 + x56 * (x101 * x1215 + x1220 * x56)),
            x0 * x1225
            + x21 * x888
            + x21 * x889
            + x22 * x747
            + x55 * (x101 * x1221 + x1226 * x56),
            x0 * x1231
            + x21 * x898
            + x21 * x899
            + x22 * x756
            + x55 * (x101 * x1227 + x1232 * x56),
            x0 * x1238
            + x21 * x908
            + x21 * x909
            + x22 * x765
            + x55 * (x101 * x1234 + x1239 * x56),
            x0 * x1244
            + x21 * x918
            + x21 * x919
            + x22 * x773
            + x55 * (x101 * x1240 + x1245 * x56),
            x0 * x1249
            + x21 * x926
            + x21 * x927
            + x22 * x779
            + x55 * (x103 * x1226 + x894),
            x0 * x1253
            + x21 * x933
            + x21 * x934
            + x22 * x785
            + x55 * (x103 * x1232 + x904),
            x0 * x1257
            + x21 * x939
            + x21 * x940
            + x22 * x791
            + x55 * (x103 * x1239 + x914),
            x0 * x1262
            + x21 * x945
            + x21 * x946
            + x22 * x797
            + x55 * (x103 * x1245 + x924),
            x0 * x1266
            + x21 * x951
            + x21 * x952
            + x22 * x803
            + x55 * (x121 * x1245 + x208 * x687),
            x0 * x1271
            + x21 * x968
            + x22 * x818
            + x22 * x819
            + x55
            * (
                x1272 * x287
                + x56 * (x1272 * x283 + x56 * (x1272 * x56 + x56 * (x1272 + x1274 * x4)))
            ),
            x0 * x1279
            + x21 * x984
            + x22 * x832
            + x22 * x833
            + x55
            * (x1275 * x696 + x56 * (x1275 * x350 + x56 * (x101 * x1275 + x1280 * x56))),
            x0 * x1285
            + x21 * x995
            + x22 * x844
            + x22 * x845
            + x55
            * (x1281 * x696 + x56 * (x1281 * x350 + x56 * (x101 * x1281 + x1286 * x56))),
            x0 * x1291
            + x1004 * x21
            + x22 * x855
            + x22 * x856
            + x55 * (x1287 * x350 + x56 * (x101 * x1287 + x1292 * x56)),
            x0 * x1297
            + x1013 * x21
            + x22 * x866
            + x22 * x867
            + x55 * (x1293 * x350 + x56 * (x101 * x1293 + x1298 * x56)),
            x0 * x1303
            + x1023 * x21
            + x22 * x877
            + x22 * x878
            + x55 * (x1299 * x350 + x56 * (x101 * x1299 + x1304 * x56)),
            x0 * x1309
            + x1031 * x21
            + x22 * x887
            + x22 * x888
            + x55 * (x101 * x1305 + x1310 * x56),
            x0 * x1315
            + x1038 * x21
            + x22 * x897
            + x22 * x898
            + x55 * (x101 * x1311 + x1316 * x56),
            x0 * x1321
            + x1045 * x21
            + x22 * x907
            + x22 * x908
            + x55 * (x101 * x1317 + x1322 * x56),
            x0 * x1327
            + x1054 * x21
            + x22 * x917
            + x22 * x918
            + x55 * (x101 * x1323 + x1328 * x56),
            x0 * x1332
            + x1061 * x21
            + x22 * x925
            + x22 * x926
            + x55 * (x103 * x1310 + x178 * x977),
            x0 * x1336
            + x1067 * x21
            + x22 * x932
            + x22 * x933
            + x55 * (x103 * x1316 + x931 * x990),
            x0 * x1340
            + x1073 * x21
            + x22 * x938
            + x22 * x939
            + x55 * (x1019 * x611 + x103 * x1322),
            x0 * x1344
            + x1079 * x21
            + x22 * x944
            + x22 * x945
            + x55 * (x101 * x1051 + x103 * x1328),
            x0 * x1348
            + x1085 * x21
            + x22 * x950
            + x22 * x951
            + x55 * (x121 * x1328 + x924),
            x0 * x1353
            + x22 * x966
            + x22 * x967
            + x22 * x968
            + x55
            * (
                x1354 * x287
                + x56 * (x1354 * x283 + x56 * (x1354 * x56 + x56 * (x1354 + x1357)))
            ),
            x0 * x1361
            + x22 * x982
            + x22 * x983
            + x22 * x984
            + x55 * (x1354 * x521 + x56 * (x1354 * x517 + x56 * (x103 * x1357 + x1362))),
            x0 * x1367
            + x22 * x993
            + x22 * x994
            + x22 * x995
            + x55 * (x1363 * x696 + x56 * (x1363 * x350 + x56 * (x1368 + x1369 * x56))),
            x0 * x1373
            + x1002 * x22
            + x1003 * x22
            + x1004 * x22
            + x55 * (x1354 * x552 + x56 * (x1357 * x136 + x1374)),
            x0 * x1378
            + x1011 * x22
            + x1012 * x22
            + x1013 * x22
            + x55 * (x1010 * x1363 + x56 * (x1369 * x517 + x1379)),
            x0 * x1384
            + x1021 * x22
            + x1022 * x22
            + x1023 * x22
            + x55 * (x1380 * x350 + x56 * (x1385 + x1386 * x56)),
            x0 * x1390
            + x1029 * x22
            + x1030 * x22
            + x1031 * x22
            + x55 * (x1357 * x178 + x1391),
            x0 * x1395
            + x1036 * x22
            + x1037 * x22
            + x1038 * x22
            + x55 * (x1369 * x552 + x1396),
            x0 * x1400
            + x1043 * x22
            + x1044 * x22
            + x1045 * x22
            + x55 * (x1386 * x517 + x1401),
            x0 * x1406
            + x1052 * x22
            + x1053 * x22
            + x1054 * x22
            + x55 * (x1407 + x1408 * x56),
            x0 * x1412 + x1059 * x22 + x1060 * x22 + x1061 * x22 + x1356 * x219,
            x0 * x1416 + x1065 * x22 + x1066 * x22 + x1067 * x22 + x1369 * x226,
            x0 * x1420 + x1071 * x22 + x1072 * x22 + x1073 * x22 + x1386 * x187,
            x0 * x1424 + x1077 * x22 + x1078 * x22 + x1079 * x22 + x1408 * x149,
            x0 * x1428
            + x1083 * x22
            + x1084 * x22
            + x1085 * x22
            + x55 * (x1051 * x62 + x121 * x1408),
            x1090 * x21 + x1091 * x21 + x1092 * x21 + x1093 * x21 + x1429 * x291,
            x1101 * x21 + x1102 * x21 + x1103 * x21 + x1104 * x21 + x1432 * x321,
            x1109 * x21 + x1110 * x21 + x1111 * x21 + x1112 * x21 + x1429 * x339,
            x1116 * x21 + x1117 * x21 + x1118 * x21 + x1119 * x21 + x1433 * x317,
            x1123 * x21 + x1124 * x21 + x1125 * x21 + x1126 * x21 + x1434 * x317,
            x1130 * x21 + x1131 * x21 + x1132 * x21 + x1133 * x21 + x1435 * x175,
            x1136 * x21 + x1137 * x21 + x1138 * x21 + x1139 * x21 + x1436 * x312,
            x1143 * x21 + x1144 * x21 + x1145 * x21 + x1146 * x21 + x1437 * x312,
            x1150 * x21 + x1151 * x21 + x1152 * x21 + x1153 * x21 + x1438 * x312,
            x1156 * x21 + x1157 * x21 + x1158 * x21 + x1159 * x21 + x1435 * x216,
            x1161 * x21
            + x1162 * x21
            + x1163 * x21
            + x1164 * x21
            + x55 * (x103 * x1436 + 4.0 * x1140),
            x1165 * x21
            + x1166 * x21
            + x1167 * x21
            + x1168 * x21
            + x55 * (x103 * x1437 + 4.0 * x1147),
            x1169 * x21
            + x1170 * x21
            + x1171 * x21
            + x1172 * x21
            + x55 * (x103 * x1438 + 4.0 * x1154),
            x1173 * x21
            + x1174 * x21
            + x1175 * x21
            + x1176 * x21
            + x55 * (x1430 * x208 + x1431 * x208),
            x1177 * x21 + x1178 * x21 + x1179 * x21 + x1180 * x21 + x1429 * x252,
            x1090 * x22 + x1183 * x21 + x1184 * x21 + x1185 * x21 + x1439 * x291,
            x1101 * x22 + x1192 * x21 + x1193 * x21 + x1194 * x21 + x1440 * x321,
            x1109 * x22 + x1198 * x21 + x1199 * x21 + x1200 * x21 + x1441 * x321,
            x1116 * x22 + x1204 * x21 + x1205 * x21 + x1206 * x21 + x1442 * x317,
            x1123 * x22 + x1211 * x21 + x1212 * x21 + x1213 * x21 + x1443 * x317,
            x1130 * x22 + x1217 * x21 + x1218 * x21 + x1219 * x21 + x1444 * x317,
            x1136 * x22 + x1223 * x21 + x1224 * x21 + x1225 * x21 + x1445 * x312,
            x1143 * x22 + x1229 * x21 + x1230 * x21 + x1231 * x21 + x1446 * x312,
            x1150 * x22 + x1236 * x21 + x1237 * x21 + x1238 * x21 + x1447 * x312,
            x1156 * x22 + x1242 * x21 + x1243 * x21 + x1244 * x21 + x1448 * x312,
            x1161 * x22
            + x1247 * x21
            + x1248 * x21
            + x1249 * x21
            + x55 * (x103 * x1445 + x1221 * x62),
            x1165 * x22
            + x1251 * x21
            + x1252 * x21
            + x1253 * x21
            + x55 * (x103 * x1446 + x1227 * x62),
            x1169 * x22
            + x1255 * x21
            + x1256 * x21
            + x1257 * x21
            + x55 * (x103 * x1447 + x1234 * x62),
            x1173 * x22
            + x1260 * x21
            + x1261 * x21
            + x1262 * x21
            + x55 * (x103 * x1448 + x1240 * x62),
            x1177 * x22
            + x1264 * x21
            + x1265 * x21
            + x1266 * x21
            + x55 * (x1160 + x121 * x1448),
            x1182 * x22 + x1183 * x22 + x1270 * x21 + x1271 * x21 + x1449 * x291,
            x1191 * x22 + x1192 * x22 + x1278 * x21 + x1279 * x21 + x1450 * x321,
            x1197 * x22 + x1198 * x22 + x1284 * x21 + x1285 * x21 + x1451 * x321,
            x1203 * x22 + x1204 * x22 + x1290 * x21 + x1291 * x21 + x1452 * x317,
            x1210 * x22 + x1211 * x22 + x1296 * x21 + x1297 * x21 + x1453 * x317,
            x1216 * x22 + x1217 * x22 + x1302 * x21 + x1303 * x21 + x1454 * x317,
            x1222 * x22 + x1223 * x22 + x1308 * x21 + x1309 * x21 + x1455 * x312,
            x1228 * x22 + x1229 * x22 + x1314 * x21 + x1315 * x21 + x1456 * x312,
            x1235 * x22 + x1236 * x22 + x1320 * x21 + x1321 * x21 + x1457 * x312,
            x1241 * x22 + x1242 * x22 + x1326 * x21 + x1327 * x21 + x1458 * x312,
            x1246 * x22
            + x1247 * x22
            + x1331 * x21
            + x1332 * x21
            + x55 * (x103 * x1455 + x1305 * x69),
            x1250 * x22
            + x1251 * x22
            + x1335 * x21
            + x1336 * x21
            + x55 * (x103 * x1456 + x1311 * x69),
            x1254 * x22
            + x1255 * x22
            + x1339 * x21
            + x1340 * x21
            + x55 * (x103 * x1457 + x1317 * x69),
            x1259 * x22
            + x1260 * x22
            + x1343 * x21
            + x1344 * x21
            + x55 * (x103 * x1458 + x1323 * x69),
            x1263 * x22
            + x1264 * x22
            + x1347 * x21
            + x1348 * x21
            + x55 * (x121 * x1458 + x1240 * x69),
            x1268 * x22 + x1269 * x22 + x1270 * x22 + x1353 * x21 + x1459 * x291,
            x1276 * x22 + x1277 * x22 + x1278 * x22 + x1361 * x21 + x1460 * x321,
            x1282 * x22 + x1283 * x22 + x1284 * x22 + x1367 * x21 + x1461 * x321,
            x1288 * x22 + x1289 * x22 + x1290 * x22 + x1373 * x21 + x1462 * x317,
            x1294 * x22 + x1295 * x22 + x1296 * x22 + x1378 * x21 + x1463 * x317,
            x1300 * x22 + x1301 * x22 + x1302 * x22 + x1384 * x21 + x1464 * x317,
            x1306 * x22 + x1307 * x22 + x1308 * x22 + x1390 * x21 + x1465 * x312,
            x1312 * x22 + x1313 * x22 + x1314 * x22 + x1395 * x21 + x1466 * x312,
            x1318 * x22 + x1319 * x22 + x1320 * x22 + x1400 * x21 + x1467 * x312,
            x1324 * x22 + x1325 * x22 + x1326 * x22 + x1406 * x21 + x1468 * x312,
            x1329 * x22
            + x1330 * x22
            + x1331 * x22
            + x1412 * x21
            + x55 * (x103 * x1465 + x1391),
            x1333 * x22
            + x1334 * x22
            + x1335 * x22
            + x1416 * x21
            + x55 * (x103 * x1466 + x1396),
            x1337 * x22
            + x1338 * x22
            + x1339 * x22
            + x1420 * x21
            + x55 * (x103 * x1467 + x1401),
            x1341 * x22
            + x1342 * x22
            + x1343 * x22
            + x1424 * x21
            + x55 * (x103 * x1468 + x1407),
            x1345 * x22
            + x1346 * x22
            + x1347 * x22
            + x1428 * x21
            + x55 * (x121 * x1468 + x1323 * x62),
            x1350 * x22 + x1351 * x22 + x1352 * x22 + x1353 * x22 + x1469 * x291,
            x1358 * x22 + x1359 * x22 + x1360 * x22 + x1361 * x22 + x1469 * x525,
            x1364 * x22 + x1365 * x22 + x1366 * x22 + x1367 * x22 + x1470 * x321,
            x1370 * x22 + x1371 * x22 + x1372 * x22 + x1373 * x22 + x1469 * x557,
            x1375 * x22 + x1376 * x22 + x1377 * x22 + x1378 * x22 + x1470 * x570,
            x1381 * x22 + x1382 * x22 + x1383 * x22 + x1384 * x22 + x1471 * x317,
            x1387 * x22 + x1388 * x22 + x1389 * x22 + x1390 * x22 + x1469 * x595,
            x1392 * x22 + x1393 * x22 + x1394 * x22 + x1395 * x22 + x1470 * x605,
            x1397 * x22 + x1398 * x22 + x1399 * x22 + x1400 * x22 + x1471 * x566,
            x1403 * x22 + x1404 * x22 + x1405 * x22 + x1406 * x22 + x1472 * x312,
            x1409 * x22 + x1410 * x22 + x1411 * x22 + x1412 * x22 + x1469 * x219,
            x1413 * x22 + x1414 * x22 + x1415 * x22 + x1416 * x22 + x1470 * x226,
            x1417 * x22 + x1418 * x22 + x1419 * x22 + x1420 * x22 + x1471 * x187,
            x1421 * x22 + x1422 * x22 + x1423 * x22 + x1424 * x22 + x1472 * x149,
            x1425 * x22
            + x1426 * x22
            + x1427 * x22
            + x1428 * x22
            + x55 * (x121 * x1472 + 4.0 * x1407),
        ]
    )


def _3center2el3d_sph_045(a, A, b, B, c, C):
    """Cartesian (sg|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = x4**2
    x8 = -x2 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x2 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x1
    x15 = x14 ** (-1.0)
    x16 = c * x15
    x17 = x1 * x16 * (x10 + x13 + x7)
    x18 = boys(6, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x0**2 + x21**2 + x22**2))
    x24 = x20 * x23
    x25 = x2 * x24
    x26 = 2.0 * x19 * x25
    x27 = x18 * x26
    x28 = c ** (-1.0)
    x29 = x14 ** (-0.5)
    x30 = boys(5, x17)
    x31 = 2.0 * x2 * x20 * x23 * x28 * x29 * x30 - x27
    x32 = x31 * x6
    x33 = -2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x5 + x27 * x4
    x34 = -x33
    x35 = boys(7, x17)
    x36 = x26 * x35
    x37 = -2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x5 + x36 * x4
    x38 = -x37
    x39 = x16 * x38
    x40 = x39 * x4
    x41 = x32 + x34 * x5 - x40
    x42 = 2.0 * x6
    x43 = x6 * (2.0 * x18 * x2 * x20 * x23 * x28 * x29 - x36)
    x44 = boys(8, x17)
    x45 = x26 * x44
    x46 = 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x5 - x4 * x45
    x47 = x16 * x46
    x48 = x38 * x5 - x4 * x47 + x43
    x49 = x16 * x48
    x50 = -x4 * x49 + x41 * x5 + x42 * (-x33 - x39)
    x51 = x4 * x50
    x52 = x41 * x6
    x53 = 3.0 * x52
    x54 = x51 + x53
    x55 = x1 * x15
    x56 = x4 * x55
    x57 = x4 * x41
    x58 = x34 * x6
    x59 = 2.0 * x58
    x60 = x57 + x59
    x61 = 3.0 * x6
    x62 = x55 * x61
    x63 = x54 * x56 + x60 * x62
    x64 = x34 * x4
    x65 = x28 * x30
    x66 = x42 * x65
    x67 = x25 * x29 * x66
    x68 = x64 + x67
    x69 = x42 * x55
    x70 = x56 * x60 + x68 * x69
    x71 = x56 * x63 + x62 * x70
    x72 = x24 * x66
    x73 = x19 * x72
    x74 = x4 * x73 + x56 * x68
    x75 = x56 * x70 + x69 * x74
    x76 = x56 * x71 + x62 * x75
    x77 = x7 * x72
    x78 = x1 * x14 ** (-2.5)
    x79 = x56 * x74 + x77 * x78
    x80 = x56 * x75 + x69 * x79
    x81 = x55 * (x56 * x76 + x62 * x80)
    x82 = x4**3
    x83 = x72 * x82
    x84 = x1**2
    x85 = x14 ** (-3.5) * x84
    x86 = x56 * x79 + x83 * x85
    x87 = x55 * (x56 * x80 + x69 * x86)
    x88 = x0 * x87 + x81
    x89 = x4**4
    x90 = x1**3
    x91 = x14 ** (-4.5) * x90
    x92 = x72 * x91
    x93 = x55 * (x56 * x86 + x89 * x92)
    x94 = x0 * x93 + x87
    x95 = x0 * x94 + x88
    x96 = x4**5
    x97 = x1**4
    x98 = 2.0 * x14 ** (-5.5) * x24 * x65 * x97
    x99 = x0 * x98
    x100 = -x31 * x6
    x101 = x6 * (2.0 * x2 * x20 * x23 * x28 * x29 * x35 - x45)
    x102 = x26 * boys(9, x17)
    x103 = x16 * x4
    x104 = (
        -x103
        * (
            -x103
            * (
                x101
                - x103 * (-x102 * x4 + 2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x5)
                + x46 * x5
            )
            + x42 * (-x37 - x47)
            + x48 * x5
        )
        + x5 * x50
        + x61 * (-x100 + x34 * x5 - x40 - x49)
    )
    x105 = x104 * x4
    x106 = x50 * x6
    x107 = 4.0 * x106
    x108 = x55 * x6
    x109 = 4.0 * x108
    x110 = x55 * x9
    x111 = x110 * x51 + x110 * x53
    x112 = x110 * x57 + x110 * x59
    x113 = x111 * x56 + x112 * x62
    x114 = x73 * x9
    x115 = x110 * x64 + x114
    x116 = x112 * x56 + x115 * x69
    x117 = x113 * x56 + x116 * x62
    x118 = x72 * x78
    x119 = x118 * x4
    x120 = x115 * x56 + x119 * x9
    x121 = x116 * x56 + x120 * x69
    x122 = x55 * (x117 * x56 + x121 * x62)
    x123 = x7 * x9
    x124 = x72 * x85
    x125 = x120 * x56 + x123 * x124
    x126 = x55 * (x121 * x56 + x125 * x69)
    x127 = x0 * x126 + x122
    x128 = x83 * x91
    x129 = x55 * (x125 * x56 + x128 * x9)
    x130 = x0 * x129 + x126
    x131 = x0 * x130 + x127
    x132 = x89 * x99
    x133 = x12 * x55
    x134 = x133 * x51 + x133 * x53
    x135 = x133 * x57 + x133 * x59
    x136 = x134 * x56 + x135 * x62
    x137 = x12 * x73
    x138 = x133 * x64 + x137
    x139 = x135 * x56 + x138 * x69
    x140 = x136 * x56 + x139 * x62
    x141 = x119 * x12 + x138 * x56
    x142 = x139 * x56 + x141 * x69
    x143 = x55 * (x140 * x56 + x142 * x62)
    x144 = x12 * x77 * x85 + x141 * x56
    x145 = x55 * (x142 * x56 + x144 * x69)
    x146 = x0 * x145 + x143
    x147 = x55 * (x12 * x128 + x144 * x56)
    x148 = x0 * x147 + x145
    x149 = x0 * x148 + x146
    x150 = x84 / x14**2
    x151 = x10 * x150
    x152 = x151 * x51 + x151 * x53
    x153 = x151 * x57 + x151 * x59
    x154 = x152 * x56 + x153 * x62
    x155 = x10 * x118
    x156 = x151 * x64 + x155
    x157 = x153 * x56 + x156 * x69
    x158 = x55 * (x154 * x56 + x157 * x62)
    x159 = x10 * x4
    x160 = x124 * x159 + x156 * x56
    x161 = x55 * (x157 * x56 + x160 * x69)
    x162 = x0 * x161 + x158
    x163 = x77 * x91
    x164 = x55 * (x10 * x163 + x160 * x56)
    x165 = x0 * x164 + x161
    x166 = x0 * x165 + x162
    x167 = x10 * x82
    x168 = x150 * x9
    x169 = x12 * x168
    x170 = x169 * x51 + x169 * x53
    x171 = x169 * x57 + x169 * x59
    x172 = x170 * x56 + x171 * x62
    x173 = x12 * x9
    x174 = x118 * x173
    x175 = x169 * x64 + x174
    x176 = x171 * x56 + x175 * x69
    x177 = x55 * (x172 * x56 + x176 * x62)
    x178 = x124 * x173 * x4 + x175 * x56
    x179 = x55 * (x176 * x56 + x178 * x69)
    x180 = x0 * x179 + x177
    x181 = x12 * x92
    x182 = x55 * (x123 * x181 + x178 * x56)
    x183 = x0 * x182 + x179
    x184 = x0 * x183 + x180
    x185 = x173 * x82
    x186 = x13 * x150
    x187 = x186 * x51 + x186 * x53
    x188 = x186 * x57 + x186 * x59
    x189 = x187 * x56 + x188 * x62
    x190 = x118 * x13
    x191 = x186 * x64 + x190
    x192 = x188 * x56 + x191 * x69
    x193 = x55 * (x189 * x56 + x192 * x62)
    x194 = x124 * x13
    x195 = x191 * x56 + x194 * x4
    x196 = x55 * (x192 * x56 + x195 * x69)
    x197 = x0 * x196 + x193
    x198 = x55 * (x13 * x163 + x195 * x56)
    x199 = x0 * x198 + x196
    x200 = x0 * x199 + x197
    x201 = x13 * x82
    x202 = x9**3
    x203 = x90 / x14**3
    x204 = x202 * x203
    x205 = x204 * x51 + x204 * x53
    x206 = x204 * x57 + x204 * x59
    x207 = x55 * (x205 * x56 + x206 * x62)
    x208 = x124 * x202
    x209 = x204 * x64 + x208
    x210 = x55 * (x206 * x56 + x209 * x69)
    x211 = x0 * x210 + x207
    x212 = x202 * x4
    x213 = x55 * (x209 * x56 + x212 * x92)
    x214 = x0 * x213 + x210
    x215 = x0 * x214 + x211
    x216 = x202 * x7
    x217 = x10 * x203
    x218 = x12 * x217
    x219 = x218 * x51 + x218 * x53
    x220 = x218 * x57 + x218 * x59
    x221 = x55 * (x219 * x56 + x220 * x62)
    x222 = x10 * x12
    x223 = x124 * x222
    x224 = x218 * x64 + x223
    x225 = x55 * (x220 * x56 + x224 * x69)
    x226 = x0 * x225 + x221
    x227 = x55 * (x159 * x181 + x224 * x56)
    x228 = x0 * x227 + x225
    x229 = x0 * x228 + x226
    x230 = x222 * x7
    x231 = x203 * x9
    x232 = x13 * x231
    x233 = x232 * x51 + x232 * x53
    x234 = x232 * x57 + x232 * x59
    x235 = x55 * (x233 * x56 + x234 * x62)
    x236 = x194 * x9
    x237 = x232 * x64 + x236
    x238 = x55 * (x234 * x56 + x237 * x69)
    x239 = x0 * x238 + x235
    x240 = x55 * (x13 * x4 * x9 * x92 + x237 * x56)
    x241 = x0 * x240 + x238
    x242 = x0 * x241 + x239
    x243 = x13 * x99
    x244 = x12**3
    x245 = x203 * x244
    x246 = x245 * x51 + x245 * x53
    x247 = x245 * x57 + x245 * x59
    x248 = x55 * (x246 * x56 + x247 * x62)
    x249 = x124 * x244
    x250 = x245 * x64 + x249
    x251 = x55 * (x247 * x56 + x250 * x69)
    x252 = x0 * x251 + x248
    x253 = x244 * x4
    x254 = x55 * (x250 * x56 + x253 * x92)
    x255 = x0 * x254 + x251
    x256 = x0 * x255 + x252
    x257 = x244 * x7
    x258 = x9**4
    x259 = x97 / x14**4
    x260 = x258 * x259
    x261 = x55 * (x260 * x51 + x260 * x53)
    x262 = x55 * (x260 * x57 + x260 * x59)
    x263 = x0 * x262 + x261
    x264 = x258 * x92
    x265 = x55 * (x260 * x64 + x264)
    x266 = x0 * x265 + x262
    x267 = x0 * x266 + x263
    x268 = x258 * x99
    x269 = x202 * x259
    x270 = x12 * x269
    x271 = x55 * (x270 * x51 + x270 * x53)
    x272 = x55 * (x270 * x57 + x270 * x59)
    x273 = x0 * x272 + x271
    x274 = x181 * x202
    x275 = x55 * (x270 * x64 + x274)
    x276 = x0 * x275 + x272
    x277 = x0 * x276 + x273
    x278 = x12 * x212
    x279 = x259 * x51
    x280 = x10 * x13
    x281 = x259 * x280
    x282 = x55 * (x279 * x280 + x281 * x53)
    x283 = x55 * (x281 * x57 + x281 * x59)
    x284 = x0 * x283 + x282
    x285 = x280 * x92
    x286 = x55 * (x281 * x64 + x285)
    x287 = x0 * x286 + x283
    x288 = x0 * x287 + x284
    x289 = x244 * x9
    x290 = x259 * x289
    x291 = x55 * (x279 * x289 + x290 * x53)
    x292 = x55 * (x290 * x57 + x290 * x59)
    x293 = x0 * x292 + x291
    x294 = x289 * x92
    x295 = x55 * (x290 * x64 + x294)
    x296 = x0 * x295 + x292
    x297 = x0 * x296 + x293
    x298 = x289 * x4
    x299 = x12**4
    x300 = x259 * x299
    x301 = x55 * (x300 * x51 + x300 * x53)
    x302 = x55 * (x300 * x57 + x300 * x59)
    x303 = x0 * x302 + x301
    x304 = x299 * x92
    x305 = x55 * (x300 * x64 + x304)
    x306 = x0 * x305 + x302
    x307 = x0 * x306 + x303
    x308 = x299 * x4
    x309 = x9**5
    x310 = x1**5 / x14**5
    x311 = x309 * x310
    x312 = x311 * x50
    x313 = x311 * x41
    x314 = x0 * x313 + x312
    x315 = x311 * x34
    x316 = x0 * x315 + x313
    x317 = x0 * x316 + x314
    x318 = x258 * x310
    x319 = x12 * x318
    x320 = x319 * x50
    x321 = x319 * x41
    x322 = x0 * x321 + x320
    x323 = x319 * x34
    x324 = x0 * x323 + x321
    x325 = x0 * x324 + x322
    x326 = x310 * x50
    x327 = x13 * x202
    x328 = x326 * x327
    x329 = x310 * x327
    x330 = x329 * x41
    x331 = x0 * x330 + x328
    x332 = x329 * x34
    x333 = x0 * x332 + x330
    x334 = x0 * x333 + x331
    x335 = x10 * x244
    x336 = x326 * x335
    x337 = x310 * x335
    x338 = x337 * x41
    x339 = x0 * x338 + x336
    x340 = x337 * x34
    x341 = x0 * x340 + x338
    x342 = x0 * x341 + x339
    x343 = x299 * x9
    x344 = x326 * x343
    x345 = x310 * x343
    x346 = x345 * x41
    x347 = x0 * x346 + x344
    x348 = x34 * x345
    x349 = x0 * x348 + x346
    x350 = x0 * x349 + x347
    x351 = x12**5
    x352 = x310 * x351
    x353 = x352 * x50
    x354 = x352 * x41
    x355 = x0 * x354 + x353
    x356 = x34 * x352
    x357 = x0 * x356 + x354
    x358 = x0 * x357 + x355
    x359 = -x8 - A[1]
    x360 = -2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x359 + x36 * x9
    x361 = -x360
    x362 = x16 * x361
    x363 = -2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x359 + x27 * x9
    x364 = x6 * (-x362 - x363)
    x365 = -x363
    x366 = x362 * x4 - x365 * x5
    x367 = -x366
    x368 = 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x359 - x45 * x9
    x369 = x16 * x368
    x370 = x361 * x5 - x369 * x4
    x371 = x16 * x370
    x372 = x364 + x367 * x5 - x371 * x4
    x373 = x372 * x4
    x374 = x367 * x6
    x375 = 2.0 * x374
    x376 = x373 + x375
    x377 = x365 * x6
    x378 = x367 * x4
    x379 = x377 + x378
    x380 = x376 * x56 + x379 * x69
    x381 = x377 * x56 + x379 * x56
    x382 = x380 * x56 + x381 * x69
    x383 = x150 * x7
    x384 = x377 * x383 + x381 * x56
    x385 = x382 * x56 + x384 * x69
    x386 = x203 * x82
    x387 = x377 * x386 + x384 * x56
    x388 = x55 * (x385 * x56 + x387 * x69)
    x389 = x21 * x87 + x388
    x390 = x259 * x89
    x391 = x55 * (x377 * x390 + x387 * x56)
    x392 = x21 * x93 + x391
    x393 = x0 * x392 + x389
    x394 = x310 * x96
    x395 = x365 * x394
    x396 = x21 * x98
    x397 = x395 + x396 * x96
    x398 = x6 * (-x360 - x369)
    x399 = -x102 * x9 + 2.0 * x2 * x20 * x23 * x28 * x29 * x359 * x44
    x400 = (
        -x103 * (-x103 * (-x103 * x399 + x368 * x5) + x370 * x5 + x398)
        + x372 * x5
        + x42 * (-x366 - x371)
    )
    x401 = x4 * x400
    x402 = x372 * x6
    x403 = 3.0 * x402
    x404 = x372 * x9
    x405 = x404 + x52
    x406 = x367 * x9
    x407 = x406 + x58
    x408 = x407 * x69
    x409 = x405 * x56 + x408
    x410 = x365 * x9
    x411 = x410 + x67
    x412 = x411 * x55
    x413 = x407 * x56 + x412 * x6
    x414 = x409 * x56 + x413 * x69
    x415 = x150 * x4
    x416 = x411 * x6
    x417 = x413 * x56 + x415 * x416
    x418 = x414 * x56 + x417 * x69
    x419 = x203 * x7
    x420 = x416 * x419 + x417 * x56
    x421 = x55 * (x418 * x56 + x420 * x69)
    x422 = x126 * x21 + x421
    x423 = x259 * x82
    x424 = x55 * (x416 * x423 + x420 * x56)
    x425 = x129 * x21 + x424
    x426 = x0 * x425 + x422
    x427 = x310 * x89
    x428 = x411 * x427
    x429 = x396 * x89
    x430 = x428 + x429 * x9
    x431 = x400 * x9
    x432 = x106 + x431
    x433 = x133 * x375
    x434 = x133 * x373 + x433
    x435 = x133 * x377
    x436 = x133 * x378 + x435
    x437 = x434 * x56 + x436 * x69
    x438 = x12 * x377
    x439 = x415 * x438 + x436 * x56
    x440 = x437 * x56 + x439 * x69
    x441 = x419 * x438 + x439 * x56
    x442 = x55 * (x440 * x56 + x441 * x69)
    x443 = x145 * x21 + x442
    x444 = x55 * (x423 * x438 + x441 * x56)
    x445 = x147 * x21 + x444
    x446 = x0 * x445 + x443
    x447 = x12 * x427
    x448 = x365 * x447
    x449 = x12 * x429 + x448
    x450 = x110 * x405 + x110 * x52
    x451 = x110 * x407 + x110 * x58
    x452 = x451 * x69
    x453 = x450 * x56 + x452
    x454 = x114 + x412 * x9
    x455 = x108 * x454 + x451 * x56
    x456 = x453 * x56 + x455 * x69
    x457 = x454 * x6
    x458 = x415 * x457 + x455 * x56
    x459 = x55 * (x456 * x56 + x458 * x69)
    x460 = x161 * x21 + x459
    x461 = x55 * (x419 * x457 + x458 * x56)
    x462 = x164 * x21 + x461
    x463 = x0 * x462 + x460
    x464 = x423 * x454
    x465 = x167 * x396 + x464
    x466 = x106 * x110 + x110 * x432
    x467 = x133 * x52
    x468 = x133 * x404 + x467
    x469 = x133 * x58
    x470 = x133 * x406 + x469
    x471 = x470 * x69
    x472 = x468 * x56 + x471
    x473 = x133 * x410 + x137
    x474 = x108 * x473 + x470 * x56
    x475 = x472 * x56 + x474 * x69
    x476 = x473 * x6
    x477 = x415 * x476 + x474 * x56
    x478 = x55 * (x475 * x56 + x477 * x69)
    x479 = x179 * x21 + x478
    x480 = x55 * (x419 * x476 + x477 * x56)
    x481 = x182 * x21 + x480
    x482 = x0 * x481 + x479
    x483 = x423 * x473
    x484 = x185 * x396 + x483
    x485 = x106 * x133
    x486 = x133 * x431 + x485
    x487 = x186 * x375
    x488 = x186 * x373 + x487
    x489 = x186 * x377
    x490 = x186 * x378 + x489
    x491 = x488 * x56 + x490 * x69
    x492 = x13 * x377
    x493 = x203 * x4
    x494 = x490 * x56 + x492 * x493
    x495 = x55 * (x491 * x56 + x494 * x69)
    x496 = x196 * x21 + x495
    x497 = x259 * x7
    x498 = x55 * (x492 * x497 + x494 * x56)
    x499 = x198 * x21 + x498
    x500 = x0 * x499 + x496
    x501 = x310 * x365
    x502 = x201 * x501
    x503 = x201 * x396 + x502
    x504 = x110 * x450 + x151 * x52
    x505 = x110 * x451 + x151 * x58
    x506 = x505 * x69
    x507 = x504 * x56 + x506
    x508 = x110 * x454 + x155
    x509 = x108 * x508 + x505 * x56
    x510 = x55 * (x507 * x56 + x509 * x69)
    x511 = x21 * x210 + x510
    x512 = x415 * x6
    x513 = x55 * (x508 * x512 + x509 * x56)
    x514 = x21 * x213 + x513
    x515 = x0 * x514 + x511
    x516 = x419 * x508
    x517 = x216 * x396 + x516
    x518 = x106 * x151 + x110 * x466
    x519 = x110 * x468 + x169 * x52
    x520 = x110 * x470 + x169 * x58
    x521 = x520 * x69
    x522 = x519 * x56 + x521
    x523 = x110 * x473 + x174
    x524 = x108 * x523 + x520 * x56
    x525 = x55 * (x522 * x56 + x524 * x69)
    x526 = x21 * x225 + x525
    x527 = x55 * (x512 * x523 + x524 * x56)
    x528 = x21 * x227 + x527
    x529 = x0 * x528 + x526
    x530 = x419 * x523
    x531 = x230 * x396 + x530
    x532 = x106 * x169 + x110 * x486
    x533 = x186 * x52
    x534 = x186 * x404 + x533
    x535 = x186 * x58
    x536 = x186 * x406 + x535
    x537 = x536 * x69
    x538 = x534 * x56 + x537
    x539 = x186 * x410 + x190
    x540 = x108 * x539 + x536 * x56
    x541 = x55 * (x538 * x56 + x540 * x69)
    x542 = x21 * x238 + x541
    x543 = x55 * (x512 * x539 + x540 * x56)
    x544 = x21 * x240 + x543
    x545 = x0 * x544 + x542
    x546 = x419 * x539
    x547 = x13 * x396
    x548 = x123 * x547 + x546
    x549 = x106 * x186
    x550 = x186 * x431 + x549
    x551 = x245 * x375
    x552 = x245 * x373 + x551
    x553 = x245 * x377
    x554 = x245 * x378 + x553
    x555 = x55 * (x552 * x56 + x554 * x69)
    x556 = x21 * x251 + x555
    x557 = x253 * x259
    x558 = x55 * (x377 * x557 + x554 * x56)
    x559 = x21 * x254 + x558
    x560 = x0 * x559 + x556
    x561 = x257 * x501
    x562 = x257 * x396 + x561
    x563 = x110 * x504 + x204 * x52
    x564 = x110 * x505 + x204 * x58
    x565 = x564 * x69
    x566 = x55 * (x56 * x563 + x565)
    x567 = x21 * x262 + x566
    x568 = x110 * x508 + x208
    x569 = x55 * (x108 * x568 + x56 * x564)
    x570 = x21 * x265 + x569
    x571 = x0 * x570 + x567
    x572 = x415 * x568
    x573 = x258 * x396
    x574 = x4 * x573 + x572
    x575 = x106 * x204 + x110 * x518
    x576 = x110 * x519 + x218 * x52
    x577 = x110 * x520 + x218 * x58
    x578 = x577 * x69
    x579 = x55 * (x56 * x576 + x578)
    x580 = x21 * x272 + x579
    x581 = x110 * x523 + x223
    x582 = x55 * (x108 * x581 + x56 * x577)
    x583 = x21 * x275 + x582
    x584 = x0 * x583 + x580
    x585 = x415 * x581
    x586 = x278 * x396 + x585
    x587 = x106 * x218 + x110 * x532
    x588 = x110 * x534 + x232 * x52
    x589 = x110 * x536 + x232 * x58
    x590 = x589 * x69
    x591 = x55 * (x56 * x588 + x590)
    x592 = x21 * x283 + x591
    x593 = x110 * x539 + x236
    x594 = x55 * (x108 * x593 + x56 * x589)
    x595 = x21 * x286 + x594
    x596 = x0 * x595 + x592
    x597 = x415 * x593
    x598 = x159 * x547 + x597
    x599 = x106 * x232 + x110 * x550
    x600 = x245 * x52
    x601 = x245 * x404 + x600
    x602 = x245 * x58
    x603 = x245 * x406 + x602
    x604 = x603 * x69
    x605 = x55 * (x56 * x601 + x604)
    x606 = x21 * x292 + x605
    x607 = x245 * x410 + x249
    x608 = x55 * (x108 * x607 + x56 * x603)
    x609 = x21 * x295 + x608
    x610 = x0 * x609 + x606
    x611 = x415 * x607
    x612 = x298 * x396 + x611
    x613 = x106 * x245
    x614 = x245 * x431 + x613
    x615 = x300 * x375
    x616 = x55 * (x300 * x373 + x615)
    x617 = x21 * x302 + x616
    x618 = x300 * x377
    x619 = x55 * (x300 * x378 + x618)
    x620 = x21 * x305 + x619
    x621 = x0 * x620 + x617
    x622 = x308 * x501
    x623 = x308 * x396 + x622
    x624 = x55 * (x110 * x563 + x260 * x52)
    x625 = x21 * x313 + x624
    x626 = x55 * (x110 * x564 + x260 * x58)
    x627 = x21 * x315 + x626
    x628 = x0 * x627 + x625
    x629 = x55 * (x110 * x568 + x264)
    x630 = x309 * x396 + x629
    x631 = x55 * (x110 * x576 + x270 * x52)
    x632 = x21 * x321 + x631
    x633 = x55 * (x110 * x577 + x270 * x58)
    x634 = x21 * x323 + x633
    x635 = x0 * x634 + x632
    x636 = x55 * (x110 * x581 + x274)
    x637 = x12 * x573 + x636
    x638 = x55 * (x110 * x588 + x281 * x52)
    x639 = x21 * x330 + x638
    x640 = x55 * (x110 * x589 + x281 * x58)
    x641 = x21 * x332 + x640
    x642 = x0 * x641 + x639
    x643 = x55 * (x110 * x593 + x285)
    x644 = x327 * x396 + x643
    x645 = x55 * (x110 * x601 + x290 * x52)
    x646 = x21 * x338 + x645
    x647 = x55 * (x110 * x603 + x290 * x58)
    x648 = x21 * x340 + x647
    x649 = x0 * x648 + x646
    x650 = x55 * (x110 * x607 + x294)
    x651 = x335 * x396 + x650
    x652 = x300 * x52
    x653 = x55 * (x300 * x404 + x652)
    x654 = x21 * x346 + x653
    x655 = x300 * x58
    x656 = x55 * (x300 * x406 + x655)
    x657 = x21 * x348 + x656
    x658 = x0 * x657 + x654
    x659 = x55 * (x300 * x410 + x304)
    x660 = x343 * x396 + x659
    x661 = x106 * x300
    x662 = x352 * x372
    x663 = x21 * x354 + x662
    x664 = x352 * x367
    x665 = x21 * x356 + x664
    x666 = x0 * x665 + x663
    x667 = x352 * x365
    x668 = x351 * x396 + x667
    x669 = -x11 - A[2]
    x670 = x12 * x36 - 2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x669
    x671 = -x670
    x672 = x16 * x671
    x673 = x12 * x27 - 2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x669
    x674 = x6 * (-x672 - x673)
    x675 = -x673
    x676 = x4 * x672 - x5 * x675
    x677 = -x676
    x678 = -x12 * x45 + 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x669
    x679 = x16 * x678
    x680 = -x4 * x679 + x5 * x671
    x681 = x16 * x680
    x682 = -x4 * x681 + x5 * x677 + x674
    x683 = x4 * x682
    x684 = x6 * x677
    x685 = 2.0 * x684
    x686 = x683 + x685
    x687 = x6 * x675
    x688 = x4 * x677
    x689 = x687 + x688
    x690 = x56 * x686 + x689 * x69
    x691 = x56 * x687 + x56 * x689
    x692 = x56 * x690 + x69 * x691
    x693 = x383 * x687 + x56 * x691
    x694 = x56 * x692 + x69 * x693
    x695 = x386 * x687 + x56 * x693
    x696 = x55 * (x56 * x694 + x69 * x695)
    x697 = x22 * x87 + x696
    x698 = x55 * (x390 * x687 + x56 * x695)
    x699 = x22 * x93 + x698
    x700 = x0 * x699 + x697
    x701 = x394 * x675
    x702 = x22 * x98
    x703 = x701 + x702 * x96
    x704 = x6 * (-x670 - x679)
    x705 = -x102 * x12 + 2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x669
    x706 = (
        -x103 * (-x103 * (-x103 * x705 + x5 * x678) + x5 * x680 + x704)
        + x42 * (-x676 - x681)
        + x5 * x682
    )
    x707 = x4 * x706
    x708 = x6 * x682
    x709 = 3.0 * x708
    x710 = x110 * x683 + x110 * x685
    x711 = x110 * x687
    x712 = x110 * x688 + x711
    x713 = x56 * x710 + x69 * x712
    x714 = x415 * x9
    x715 = x56 * x712 + x687 * x714
    x716 = x56 * x713 + x69 * x715
    x717 = x687 * x9
    x718 = x419 * x717 + x56 * x715
    x719 = x55 * (x56 * x716 + x69 * x718)
    x720 = x126 * x22 + x719
    x721 = x55 * (x423 * x717 + x56 * x718)
    x722 = x129 * x22 + x721
    x723 = x0 * x722 + x720
    x724 = x427 * x9
    x725 = x675 * x724
    x726 = x702 * x89
    x727 = x725 + x726 * x9
    x728 = x12 * x682 + x52
    x729 = x12 * x677 + x58
    x730 = x69 * x729
    x731 = x56 * x728 + x730
    x732 = x12 * x675 + x67
    x733 = x108 * x732
    x734 = x56 * x729 + x733
    x735 = x56 * x731 + x69 * x734
    x736 = x512 * x732 + x56 * x734
    x737 = x56 * x735 + x69 * x736
    x738 = x6 * x732
    x739 = x419 * x738 + x56 * x736
    x740 = x55 * (x56 * x737 + x69 * x739)
    x741 = x145 * x22 + x740
    x742 = x55 * (x423 * x738 + x56 * x739)
    x743 = x147 * x22 + x742
    x744 = x0 * x743 + x741
    x745 = x427 * x732
    x746 = x12 * x726 + x745
    x747 = x106 + x12 * x706
    x748 = x151 * x683 + x151 * x685
    x749 = x151 * x687
    x750 = x151 * x688 + x749
    x751 = x56 * x748 + x69 * x750
    x752 = x217 * x4
    x753 = x56 * x750 + x687 * x752
    x754 = x55 * (x56 * x751 + x69 * x753)
    x755 = x161 * x22 + x754
    x756 = x10 * x497
    x757 = x55 * (x56 * x753 + x687 * x756)
    x758 = x164 * x22 + x757
    x759 = x0 * x758 + x755
    x760 = x310 * x82
    x761 = x10 * x760
    x762 = x675 * x761
    x763 = x167 * x702 + x762
    x764 = x42 * x729
    x765 = x168 * x764 + x714 * x728
    x766 = x168 * x738
    x767 = x714 * x729 + x766
    x768 = x56 * x765 + x69 * x767
    x769 = x231 * x4
    x770 = x56 * x767 + x738 * x769
    x771 = x55 * (x56 * x768 + x69 * x770)
    x772 = x179 * x22 + x771
    x773 = x259 * x738
    x774 = x55 * (x123 * x773 + x56 * x770)
    x775 = x182 * x22 + x774
    x776 = x0 * x775 + x772
    x777 = x760 * x9
    x778 = x732 * x777
    x779 = x185 * x702 + x778
    x780 = x61 * x728
    x781 = x133 * x728 + x467
    x782 = x133 * x729 + x469
    x783 = x69 * x782
    x784 = x56 * x781 + x783
    x785 = x133 * x732 + x137
    x786 = x108 * x785
    x787 = x56 * x782 + x786
    x788 = x56 * x784 + x69 * x787
    x789 = x512 * x785 + x56 * x787
    x790 = x55 * (x56 * x788 + x69 * x789)
    x791 = x196 * x22 + x790
    x792 = x6 * x785
    x793 = x55 * (x419 * x792 + x56 * x789)
    x794 = x198 * x22 + x793
    x795 = x0 * x794 + x791
    x796 = x423 * x785
    x797 = x201 * x702 + x796
    x798 = x133 * x747 + x485
    x799 = x204 * x683 + x204 * x685
    x800 = x204 * x687
    x801 = x204 * x688 + x800
    x802 = x55 * (x56 * x799 + x69 * x801)
    x803 = x210 * x22 + x802
    x804 = x269 * x4
    x805 = x55 * (x56 * x801 + x687 * x804)
    x806 = x213 * x22 + x805
    x807 = x0 * x806 + x803
    x808 = x310 * x7
    x809 = x202 * x808
    x810 = x675 * x809
    x811 = x216 * x702 + x810
    x812 = x217 * x764 + x728 * x752
    x813 = x217 * x738
    x814 = x729 * x752 + x813
    x815 = x55 * (x56 * x812 + x69 * x814)
    x816 = x22 * x225 + x815
    x817 = x55 * (x159 * x773 + x56 * x814)
    x818 = x22 * x227 + x817
    x819 = x0 * x818 + x816
    x820 = x10 * x808
    x821 = x732 * x820
    x822 = x230 * x702 + x821
    x823 = x42 * x782
    x824 = x168 * x823 + x714 * x781
    x825 = x168 * x792
    x826 = x714 * x782 + x825
    x827 = x55 * (x56 * x824 + x69 * x826)
    x828 = x22 * x238 + x827
    x829 = x55 * (x56 * x826 + x769 * x792)
    x830 = x22 * x240 + x829
    x831 = x0 * x830 + x828
    x832 = x259 * x785
    x833 = x123 * x832
    x834 = x13 * x702
    x835 = x123 * x834 + x833
    x836 = x61 * x781
    x837 = x133 * x781 + x533
    x838 = x133 * x782 + x535
    x839 = x69 * x838
    x840 = x56 * x837 + x839
    x841 = x133 * x785 + x190
    x842 = x108 * x841
    x843 = x56 * x838 + x842
    x844 = x55 * (x56 * x840 + x69 * x843)
    x845 = x22 * x251 + x844
    x846 = x55 * (x512 * x841 + x56 * x843)
    x847 = x22 * x254 + x846
    x848 = x0 * x847 + x845
    x849 = x419 * x841
    x850 = x257 * x702 + x849
    x851 = x133 * x798 + x549
    x852 = x55 * (x260 * x683 + x260 * x685)
    x853 = x22 * x262 + x852
    x854 = x260 * x687
    x855 = x55 * (x260 * x688 + x854)
    x856 = x22 * x265 + x855
    x857 = x0 * x856 + x853
    x858 = x318 * x4
    x859 = x675 * x858
    x860 = x258 * x702
    x861 = x4 * x860 + x859
    x862 = x55 * (x269 * x764 + x728 * x804)
    x863 = x22 * x272 + x862
    x864 = x269 * x738
    x865 = x55 * (x729 * x804 + x864)
    x866 = x22 * x275 + x865
    x867 = x0 * x866 + x863
    x868 = x212 * x310
    x869 = x732 * x868
    x870 = x278 * x702 + x869
    x871 = x55 * (x217 * x823 + x752 * x781)
    x872 = x22 * x283 + x871
    x873 = x217 * x792
    x874 = x55 * (x752 * x782 + x873)
    x875 = x22 * x286 + x874
    x876 = x0 * x875 + x872
    x877 = x159 * x832
    x878 = x159 * x834 + x877
    x879 = x168 * x42
    x880 = x55 * (x714 * x837 + x838 * x879)
    x881 = x22 * x292 + x880
    x882 = x168 * x6
    x883 = x841 * x882
    x884 = x55 * (x714 * x838 + x883)
    x885 = x22 * x295 + x884
    x886 = x0 * x885 + x881
    x887 = x769 * x841
    x888 = x298 * x702 + x887
    x889 = x133 * x837 + x600
    x890 = x133 * x838 + x602
    x891 = x69 * x890
    x892 = x55 * (x56 * x889 + x891)
    x893 = x22 * x302 + x892
    x894 = x133 * x841 + x249
    x895 = x108 * x894
    x896 = x55 * (x56 * x890 + x895)
    x897 = x22 * x305 + x896
    x898 = x0 * x897 + x893
    x899 = x415 * x894
    x900 = x308 * x702 + x899
    x901 = x133 * x851 + x613
    x902 = x311 * x682
    x903 = x22 * x313 + x902
    x904 = x311 * x677
    x905 = x22 * x315 + x904
    x906 = x0 * x905 + x903
    x907 = x311 * x675
    x908 = x309 * x702 + x907
    x909 = x318 * x728
    x910 = x22 * x321 + x909
    x911 = x318 * x729
    x912 = x22 * x323 + x911
    x913 = x0 * x912 + x910
    x914 = x318 * x732
    x915 = x12 * x860 + x914
    x916 = x269 * x781
    x917 = x22 * x330 + x916
    x918 = x269 * x782
    x919 = x22 * x332 + x918
    x920 = x0 * x919 + x917
    x921 = x269 * x785
    x922 = x327 * x702 + x921
    x923 = x217 * x837
    x924 = x22 * x338 + x923
    x925 = x217 * x838
    x926 = x22 * x340 + x925
    x927 = x0 * x926 + x924
    x928 = x217 * x841
    x929 = x335 * x702 + x928
    x930 = x168 * x889
    x931 = x22 * x346 + x930
    x932 = x168 * x890
    x933 = x22 * x348 + x932
    x934 = x0 * x933 + x931
    x935 = x168 * x894
    x936 = x343 * x702 + x935
    x937 = x55 * (x133 * x889 + x652)
    x938 = x22 * x354 + x937
    x939 = x55 * (x133 * x890 + x655)
    x940 = x22 * x356 + x939
    x941 = x0 * x940 + x938
    x942 = x55 * (x133 * x894 + x304)
    x943 = x351 * x702 + x942
    x944 = x362 * x9
    x945 = x32 + x359 * x365 - x944
    x946 = x6 * x945
    x947 = x359 * x361 - x369 * x9 + x43
    x948 = x16 * x947
    x949 = -x4 * x948 + x5 * x945
    x950 = x4 * x949
    x951 = x946 + x950
    x952 = x56 * x946 + x56 * x951
    x953 = x383 * x946 + x56 * x952
    x954 = x386 * x946 + x56 * x953
    x955 = x55 * (x390 * x946 + x56 * x954)
    x956 = x21 * x391 + x955
    x957 = x21 * x392 + x956
    x958 = x394 * x945
    x959 = x21 * x395 + x958
    x960 = x21 * x397 + x959
    x961 = x6 * (-x100 + x359 * x365 - x944 - x948)
    x962 = x16 * x9
    x963 = x101 + x359 * x368 - x399 * x962
    x964 = -x103 * (-x103 * x963 + x5 * x947) + x5 * x949 + x961
    x965 = x4 * x964
    x966 = x6 * x949
    x967 = 2.0 * x966
    x968 = x9 * x945
    x969 = 2.0 * x377
    x970 = x968 + x969
    x971 = x9 * x949
    x972 = x375 + x971
    x973 = x108 * x970 + x56 * x972
    x974 = x512 * x970 + x56 * x973
    x975 = x6 * x970
    x976 = x419 * x975 + x56 * x974
    x977 = x55 * (x423 * x975 + x56 * x976)
    x978 = x21 * x424 + x977
    x979 = x21 * x425 + x978
    x980 = x427 * x970
    x981 = x21 * x428 + x980
    x982 = x21 * x430 + x981
    x983 = x9 * x964
    x984 = 2.0 * x402
    x985 = x983 + x984
    x986 = x133 * x946
    x987 = x133 * x950 + x986
    x988 = x12 * x946
    x989 = x415 * x988 + x56 * x987
    x990 = x419 * x988 + x56 * x989
    x991 = x55 * (x423 * x988 + x56 * x990)
    x992 = x21 * x444 + x991
    x993 = x21 * x445 + x992
    x994 = x447 * x945
    x995 = x21 * x448 + x994
    x996 = x21 * x449 + x995
    x997 = x110 * x970 + x412 * x42
    x998 = x110 * x972 + x408
    x999 = x108 * x997 + x56 * x998
    x1000 = x512 * x997 + x56 * x999
    x1001 = x419 * x6
    x1002 = x55 * (x1000 * x56 + x1001 * x997)
    x1003 = x1002 + x21 * x461
    x1004 = x1003 + x21 * x462
    x1005 = x423 * x997
    x1006 = x1005 + x21 * x464
    x1007 = x1006 + x21 * x465
    x1008 = x110 * x985 + x405 * x69
    x1009 = x133 * x968 + x133 * x969
    x1010 = x133 * x971 + x433
    x1011 = x1009 * x108 + x1010 * x56
    x1012 = x1009 * x512 + x1011 * x56
    x1013 = x55 * (x1001 * x1009 + x1012 * x56)
    x1014 = x1013 + x21 * x480
    x1015 = x1014 + x21 * x481
    x1016 = x1009 * x423
    x1017 = x1016 + x21 * x483
    x1018 = x1017 + x21 * x484
    x1019 = x133 * x983 + x133 * x984
    x1020 = x186 * x946
    x1021 = x1020 + x186 * x950
    x1022 = x13 * x946
    x1023 = x1021 * x56 + x1022 * x493
    x1024 = x55 * (x1022 * x497 + x1023 * x56)
    x1025 = x1024 + x21 * x498
    x1026 = x1025 + x21 * x499
    x1027 = x310 * x945
    x1028 = x1027 * x201
    x1029 = x1028 + x21 * x502
    x1030 = x1029 + x21 * x503
    x1031 = x110 * x997 + x454 * x69
    x1032 = x110 * x998 + x452
    x1033 = x1031 * x108 + x1032 * x56
    x1034 = x55 * (x1031 * x512 + x1033 * x56)
    x1035 = x1034 + x21 * x513
    x1036 = x1035 + x21 * x514
    x1037 = x1031 * x419
    x1038 = x1037 + x21 * x516
    x1039 = x1038 + x21 * x517
    x1040 = x1008 * x110 + x450 * x69
    x1041 = x1009 * x110 + x473 * x69
    x1042 = x1010 * x110 + x471
    x1043 = x1041 * x108 + x1042 * x56
    x1044 = x55 * (x1041 * x512 + x1043 * x56)
    x1045 = x1044 + x21 * x527
    x1046 = x1045 + x21 * x528
    x1047 = x1041 * x419
    x1048 = x1047 + x21 * x530
    x1049 = x1048 + x21 * x531
    x1050 = x1019 * x110 + x468 * x69
    x1051 = x186 * x968 + x186 * x969
    x1052 = x186 * x971 + x487
    x1053 = x1051 * x108 + x1052 * x56
    x1054 = x55 * (x1051 * x512 + x1053 * x56)
    x1055 = x1054 + x21 * x543
    x1056 = x1055 + x21 * x544
    x1057 = x1051 * x419
    x1058 = x1057 + x21 * x546
    x1059 = x1058 + x21 * x548
    x1060 = x186 * x983 + x186 * x984
    x1061 = x245 * x946
    x1062 = x1061 + x245 * x950
    x1063 = x55 * (x1062 * x56 + x557 * x946)
    x1064 = x1063 + x21 * x558
    x1065 = x1064 + x21 * x559
    x1066 = x1027 * x257
    x1067 = x1066 + x21 * x561
    x1068 = x1067 + x21 * x562
    x1069 = x1031 * x110 + x508 * x69
    x1070 = x1032 * x110 + x506
    x1071 = x55 * (x1069 * x108 + x1070 * x56)
    x1072 = x1071 + x21 * x569
    x1073 = x1072 + x21 * x570
    x1074 = x1069 * x415
    x1075 = x1074 + x21 * x572
    x1076 = x1075 + x21 * x574
    x1077 = x1040 * x110 + x504 * x69
    x1078 = x1041 * x110 + x523 * x69
    x1079 = x1042 * x110 + x521
    x1080 = x55 * (x1078 * x108 + x1079 * x56)
    x1081 = x1080 + x21 * x582
    x1082 = x1081 + x21 * x583
    x1083 = x1078 * x415
    x1084 = x1083 + x21 * x585
    x1085 = x1084 + x21 * x586
    x1086 = x1050 * x110 + x519 * x69
    x1087 = x1051 * x110 + x539 * x69
    x1088 = x1052 * x110 + x537
    x1089 = x55 * (x108 * x1087 + x1088 * x56)
    x1090 = x1089 + x21 * x594
    x1091 = x1090 + x21 * x595
    x1092 = x1087 * x415
    x1093 = x1092 + x21 * x597
    x1094 = x1093 + x21 * x598
    x1095 = x1060 * x110 + x534 * x69
    x1096 = x245 * x968 + x245 * x969
    x1097 = x245 * x971 + x551
    x1098 = x55 * (x108 * x1096 + x1097 * x56)
    x1099 = x1098 + x21 * x608
    x1100 = x1099 + x21 * x609
    x1101 = x1096 * x415
    x1102 = x1101 + x21 * x611
    x1103 = x1102 + x21 * x612
    x1104 = x245 * x983 + x245 * x984
    x1105 = x300 * x946
    x1106 = x55 * (x1105 + x300 * x950)
    x1107 = x1106 + x21 * x619
    x1108 = x1107 + x21 * x620
    x1109 = x1027 * x308
    x1110 = x1109 + x21 * x622
    x1111 = x1110 + x21 * x623
    x1112 = x55 * (x1070 * x110 + x565)
    x1113 = x1112 + x21 * x626
    x1114 = x1113 + x21 * x627
    x1115 = x55 * (x1069 * x110 + x568 * x69)
    x1116 = x1115 + x21 * x629
    x1117 = x1116 + x21 * x630
    x1118 = x55 * (x1079 * x110 + x578)
    x1119 = x1118 + x21 * x633
    x1120 = x1119 + x21 * x634
    x1121 = x55 * (x1078 * x110 + x581 * x69)
    x1122 = x1121 + x21 * x636
    x1123 = x1122 + x21 * x637
    x1124 = x55 * (x1088 * x110 + x590)
    x1125 = x1124 + x21 * x640
    x1126 = x1125 + x21 * x641
    x1127 = x55 * (x1087 * x110 + x593 * x69)
    x1128 = x1127 + x21 * x643
    x1129 = x1128 + x21 * x644
    x1130 = x55 * (x1097 * x110 + x604)
    x1131 = x1130 + x21 * x647
    x1132 = x1131 + x21 * x648
    x1133 = x55 * (x1096 * x110 + x607 * x69)
    x1134 = x1133 + x21 * x650
    x1135 = x1134 + x21 * x651
    x1136 = x55 * (x300 * x971 + x615)
    x1137 = x1136 + x21 * x656
    x1138 = x1137 + x21 * x657
    x1139 = x55 * (x300 * x968 + x300 * x969)
    x1140 = x1139 + x21 * x659
    x1141 = x1140 + x21 * x660
    x1142 = x352 * x949
    x1143 = x1142 + x21 * x664
    x1144 = x1143 + x21 * x665
    x1145 = x352 * x945
    x1146 = x1145 + x21 * x667
    x1147 = x1146 + x21 * x668
    x1148 = -x359 * x675 + x672 * x9
    x1149 = -x1148
    x1150 = x1149 * x6
    x1151 = x359 * x671 - x679 * x9
    x1152 = x1151 * x16
    x1153 = x1149 * x5 - x1152 * x4
    x1154 = x1150 + x1153 * x4
    x1155 = x1150 * x56 + x1154 * x56
    x1156 = x1150 * x383 + x1155 * x56
    x1157 = x1150 * x386 + x1156 * x56
    x1158 = x55 * (x1150 * x390 + x1157 * x56)
    x1159 = x1158 + x22 * x391
    x1160 = x1159 + x21 * x699
    x1161 = x1149 * x394
    x1162 = x1161 + x22 * x395
    x1163 = x1162 + x21 * x703
    x1164 = x6 * (-x1148 - x1152)
    x1165 = x359 * x678 - x705 * x962
    x1166 = -x103 * (-x103 * x1165 + x1151 * x5) + x1153 * x5 + x1164
    x1167 = x1153 * x42
    x1168 = x1149 * x9 + x687
    x1169 = x1153 * x9 + x684
    x1170 = x108 * x1168 + x1169 * x56
    x1171 = x1168 * x512 + x1170 * x56
    x1172 = x1001 * x1168 + x1171 * x56
    x1173 = x423 * x6
    x1174 = x55 * (x1168 * x1173 + x1172 * x56)
    x1175 = x1174 + x22 * x424
    x1176 = x1175 + x21 * x722
    x1177 = x1168 * x427
    x1178 = x1177 + x22 * x428
    x1179 = x1178 + x21 * x727
    x1180 = x1166 * x9 + x708
    x1181 = x1169 * x69
    x1182 = x1149 * x12 + x377
    x1183 = x1153 * x12 + x374
    x1184 = x108 * x1182 + x1183 * x56
    x1185 = x1182 * x512 + x1184 * x56
    x1186 = x1001 * x1182 + x1185 * x56
    x1187 = x55 * (x1173 * x1182 + x1186 * x56)
    x1188 = x1187 + x22 * x444
    x1189 = x1188 + x21 * x743
    x1190 = x1182 * x427
    x1191 = x1190 + x22 * x448
    x1192 = x1191 + x21 * x746
    x1193 = x1166 * x12 + x402
    x1194 = x1183 * x69
    x1195 = x110 * x1168 + x711
    x1196 = x110 * x1169 + x110 * x684
    x1197 = x108 * x1195 + x1196 * x56
    x1198 = x1195 * x512 + x1197 * x56
    x1199 = x55 * (x1001 * x1195 + x1198 * x56)
    x1200 = x1199 + x22 * x461
    x1201 = x1200 + x21 * x758
    x1202 = x1195 * x423
    x1203 = x1202 + x22 * x464
    x1204 = x1203 + x21 * x763
    x1205 = x110 * x1180 + x110 * x708
    x1206 = x1196 * x69
    x1207 = x110 * x1182 + x733
    x1208 = x108 * x729 + x110 * x1183
    x1209 = x108 * x1207 + x1208 * x56
    x1210 = x1207 * x512 + x1209 * x56
    x1211 = x55 * (x1001 * x1207 + x1210 * x56)
    x1212 = x1211 + x22 * x480
    x1213 = x1212 + x21 * x775
    x1214 = x1207 * x423
    x1215 = x1214 + x22 * x483
    x1216 = x1215 + x21 * x779
    x1217 = x108 * x728 + x110 * x1193
    x1218 = x1208 * x69
    x1219 = x1182 * x133 + x435
    x1220 = x1183 * x133 + x133 * x374
    x1221 = x108 * x1219 + x1220 * x56
    x1222 = x1219 * x512 + x1221 * x56
    x1223 = x55 * (x1001 * x1219 + x1222 * x56)
    x1224 = x1223 + x22 * x498
    x1225 = x1224 + x21 * x794
    x1226 = x1219 * x423
    x1227 = x1226 + x22 * x502
    x1228 = x1227 + x21 * x797
    x1229 = x1193 * x133 + x133 * x402
    x1230 = x1220 * x69
    x1231 = x110 * x1195 + x749
    x1232 = x110 * x1196 + x151 * x684
    x1233 = x108 * x1231 + x1232 * x56
    x1234 = x55 * (x1231 * x512 + x1233 * x56)
    x1235 = x1234 + x22 * x513
    x1236 = x1235 + x21 * x806
    x1237 = x1231 * x419
    x1238 = x1237 + x22 * x516
    x1239 = x1238 + x21 * x811
    x1240 = x110 * x1205 + x151 * x708
    x1241 = x1232 * x69
    x1242 = x110 * x1207 + x766
    x1243 = x110 * x1208 + x729 * x882
    x1244 = x108 * x1242 + x1243 * x56
    x1245 = x55 * (x1242 * x512 + x1244 * x56)
    x1246 = x1245 + x22 * x527
    x1247 = x1246 + x21 * x818
    x1248 = x1242 * x419
    x1249 = x1248 + x22 * x530
    x1250 = x1249 + x21 * x822
    x1251 = x110 * x1217 + x728 * x882
    x1252 = x1243 * x69
    x1253 = x110 * x1219 + x786
    x1254 = x108 * x782 + x110 * x1220
    x1255 = x108 * x1253 + x1254 * x56
    x1256 = x55 * (x1253 * x512 + x1255 * x56)
    x1257 = x1256 + x22 * x543
    x1258 = x1257 + x21 * x830
    x1259 = x1253 * x419
    x1260 = x1259 + x22 * x546
    x1261 = x1260 + x21 * x835
    x1262 = x108 * x781 + x110 * x1229
    x1263 = x1254 * x69
    x1264 = x1219 * x133 + x489
    x1265 = x1220 * x133 + x186 * x374
    x1266 = x108 * x1264 + x1265 * x56
    x1267 = x55 * (x1264 * x512 + x1266 * x56)
    x1268 = x1267 + x22 * x558
    x1269 = x1268 + x21 * x847
    x1270 = x1264 * x419
    x1271 = x1270 + x22 * x561
    x1272 = x1271 + x21 * x850
    x1273 = x1229 * x133 + x186 * x402
    x1274 = x1265 * x69
    x1275 = x110 * x1231 + x800
    x1276 = x110 * x1232 + x204 * x684
    x1277 = x55 * (x108 * x1275 + x1276 * x56)
    x1278 = x1277 + x22 * x569
    x1279 = x1278 + x21 * x856
    x1280 = x1275 * x415
    x1281 = x1280 + x22 * x572
    x1282 = x1281 + x21 * x861
    x1283 = x110 * x1240 + x204 * x708
    x1284 = x1276 * x69
    x1285 = x110 * x1242 + x813
    x1286 = x217 * x6
    x1287 = x110 * x1243 + x1286 * x729
    x1288 = x55 * (x108 * x1285 + x1287 * x56)
    x1289 = x1288 + x22 * x582
    x1290 = x1289 + x21 * x866
    x1291 = x1285 * x415
    x1292 = x1291 + x22 * x585
    x1293 = x1292 + x21 * x870
    x1294 = x110 * x1251 + x1286 * x728
    x1295 = x1287 * x69
    x1296 = x110 * x1253 + x825
    x1297 = x110 * x1254 + x782 * x882
    x1298 = x55 * (x108 * x1296 + x1297 * x56)
    x1299 = x1298 + x22 * x594
    x1300 = x1299 + x21 * x875
    x1301 = x1296 * x415
    x1302 = x1301 + x22 * x597
    x1303 = x1302 + x21 * x878
    x1304 = x110 * x1262 + x781 * x882
    x1305 = x1297 * x69
    x1306 = x110 * x1264 + x842
    x1307 = x108 * x838 + x110 * x1265
    x1308 = x55 * (x108 * x1306 + x1307 * x56)
    x1309 = x1308 + x22 * x608
    x1310 = x1309 + x21 * x885
    x1311 = x1306 * x415
    x1312 = x1311 + x22 * x611
    x1313 = x1312 + x21 * x888
    x1314 = x108 * x837 + x110 * x1273
    x1315 = x1307 * x69
    x1316 = x1264 * x133 + x553
    x1317 = x1265 * x133 + x245 * x374
    x1318 = x55 * (x108 * x1316 + x1317 * x56)
    x1319 = x1318 + x22 * x619
    x1320 = x1319 + x21 * x897
    x1321 = x1316 * x415
    x1322 = x1321 + x22 * x622
    x1323 = x1322 + x21 * x900
    x1324 = x1273 * x133 + x245 * x402
    x1325 = x1317 * x69
    x1326 = x55 * (x110 * x1276 + x260 * x684)
    x1327 = x1326 + x22 * x626
    x1328 = x1327 + x21 * x905
    x1329 = x55 * (x110 * x1275 + x854)
    x1330 = x1329 + x22 * x629
    x1331 = x1330 + x21 * x908
    x1332 = x269 * x6
    x1333 = x55 * (x110 * x1287 + x1332 * x729)
    x1334 = x1333 + x22 * x633
    x1335 = x1334 + x21 * x912
    x1336 = x55 * (x110 * x1285 + x864)
    x1337 = x1336 + x22 * x636
    x1338 = x1337 + x21 * x915
    x1339 = x55 * (x110 * x1297 + x1286 * x782)
    x1340 = x1339 + x22 * x640
    x1341 = x1340 + x21 * x919
    x1342 = x55 * (x110 * x1296 + x873)
    x1343 = x1342 + x22 * x643
    x1344 = x1343 + x21 * x922
    x1345 = x55 * (x110 * x1307 + x838 * x882)
    x1346 = x1345 + x22 * x647
    x1347 = x1346 + x21 * x926
    x1348 = x55 * (x110 * x1306 + x883)
    x1349 = x1348 + x22 * x650
    x1350 = x1349 + x21 * x929
    x1351 = x55 * (x108 * x890 + x110 * x1317)
    x1352 = x1351 + x22 * x656
    x1353 = x1352 + x21 * x933
    x1354 = x55 * (x110 * x1316 + x895)
    x1355 = x1354 + x22 * x659
    x1356 = x1355 + x21 * x936
    x1357 = x55 * (x1317 * x133 + x300 * x374)
    x1358 = x1357 + x22 * x664
    x1359 = x1358 + x21 * x940
    x1360 = x55 * (x1316 * x133 + x618)
    x1361 = x1360 + x22 * x667
    x1362 = x1361 + x21 * x943
    x1363 = x12 * x672
    x1364 = -x1363 + x32 + x669 * x675
    x1365 = x1364 * x6
    x1366 = -x12 * x679 + x43 + x669 * x671
    x1367 = x1366 * x16
    x1368 = x1364 * x5 - x1367 * x4
    x1369 = x1368 * x4
    x1370 = x1365 + x1369
    x1371 = x1365 * x56 + x1370 * x56
    x1372 = x1365 * x383 + x1371 * x56
    x1373 = x1365 * x386 + x1372 * x56
    x1374 = x55 * (x1365 * x390 + x1373 * x56)
    x1375 = x1374 + x22 * x698
    x1376 = x1375 + x22 * x699
    x1377 = x1364 * x394
    x1378 = x1377 + x22 * x701
    x1379 = x1378 + x22 * x703
    x1380 = x6 * (-x100 - x1363 - x1367 + x669 * x675)
    x1381 = x12 * x16
    x1382 = x101 - x1381 * x705 + x669 * x678
    x1383 = -x103 * (-x103 * x1382 + x1366 * x5) + x1368 * x5 + x1380
    x1384 = x1383 * x4
    x1385 = x1368 * x6
    x1386 = 2.0 * x1385
    x1387 = x110 * x1365
    x1388 = x110 * x1369 + x1387
    x1389 = x1365 * x714 + x1388 * x56
    x1390 = x1365 * x9
    x1391 = x1389 * x56 + x1390 * x419
    x1392 = x55 * (x1390 * x423 + x1391 * x56)
    x1393 = x1392 + x22 * x721
    x1394 = x1393 + x22 * x722
    x1395 = x1364 * x724
    x1396 = x1395 + x22 * x725
    x1397 = x1396 + x22 * x727
    x1398 = x12 * x1364 + 2.0 * x687
    x1399 = x108 * x1398
    x1400 = x12 * x1368 + x685
    x1401 = x1399 + x1400 * x56
    x1402 = x1398 * x512 + x1401 * x56
    x1403 = x1001 * x1398 + x1402 * x56
    x1404 = x55 * (x1173 * x1398 + x1403 * x56)
    x1405 = x1404 + x22 * x742
    x1406 = x1405 + x22 * x743
    x1407 = x1398 * x427
    x1408 = x1407 + x22 * x745
    x1409 = x1408 + x22 * x746
    x1410 = x12 * x1383 + 2.0 * x708
    x1411 = x1365 * x151
    x1412 = x1369 * x151 + x1411
    x1413 = x1365 * x752 + x1412 * x56
    x1414 = x55 * (x1365 * x756 + x1413 * x56)
    x1415 = x1414 + x22 * x757
    x1416 = x1415 + x22 * x758
    x1417 = x1364 * x761
    x1418 = x1417 + x22 * x762
    x1419 = x1418 + x22 * x763
    x1420 = x1398 * x882
    x1421 = x1400 * x714 + x1420
    x1422 = x1398 * x6
    x1423 = x1421 * x56 + x1422 * x769
    x1424 = x1422 * x259
    x1425 = x55 * (x123 * x1424 + x1423 * x56)
    x1426 = x1425 + x22 * x774
    x1427 = x1426 + x22 * x775
    x1428 = x1398 * x777
    x1429 = x1428 + x22 * x778
    x1430 = x1429 + x22 * x779
    x1431 = x133 * x1398 + x69 * x732
    x1432 = x108 * x1431
    x1433 = x133 * x1400 + x730
    x1434 = x1432 + x1433 * x56
    x1435 = x1431 * x512 + x1434 * x56
    x1436 = x55 * (x1001 * x1431 + x1435 * x56)
    x1437 = x1436 + x22 * x793
    x1438 = x1437 + x22 * x794
    x1439 = x1431 * x423
    x1440 = x1439 + x22 * x796
    x1441 = x1440 + x22 * x797
    x1442 = x133 * x1410 + x69 * x728
    x1443 = x1365 * x204
    x1444 = x1369 * x204 + x1443
    x1445 = x55 * (x1365 * x804 + x1444 * x56)
    x1446 = x1445 + x22 * x805
    x1447 = x1446 + x22 * x806
    x1448 = x1364 * x809
    x1449 = x1448 + x22 * x810
    x1450 = x1449 + x22 * x811
    x1451 = x1286 * x1398
    x1452 = x1400 * x752 + x1451
    x1453 = x55 * (x1424 * x159 + x1452 * x56)
    x1454 = x1453 + x22 * x817
    x1455 = x1454 + x22 * x818
    x1456 = x1398 * x820
    x1457 = x1456 + x22 * x821
    x1458 = x1457 + x22 * x822
    x1459 = x1400 * x42
    x1460 = x1431 * x882
    x1461 = x1433 * x714 + x1460
    x1462 = x6 * x769
    x1463 = x55 * (x1431 * x1462 + x1461 * x56)
    x1464 = x1463 + x22 * x829
    x1465 = x1464 + x22 * x830
    x1466 = x1431 * x259
    x1467 = x123 * x1466
    x1468 = x1467 + x22 * x833
    x1469 = x1468 + x22 * x835
    x1470 = x133 * x1431 + x69 * x785
    x1471 = x108 * x1470
    x1472 = x133 * x1433 + x783
    x1473 = x1471 + x1472 * x56
    x1474 = x55 * (x1470 * x512 + x1473 * x56)
    x1475 = x1474 + x22 * x846
    x1476 = x1475 + x22 * x847
    x1477 = x1470 * x419
    x1478 = x1477 + x22 * x849
    x1479 = x1478 + x22 * x850
    x1480 = x133 * x1442 + x69 * x781
    x1481 = x1365 * x260
    x1482 = x55 * (x1369 * x260 + x1481)
    x1483 = x1482 + x22 * x855
    x1484 = x1483 + x22 * x856
    x1485 = x1364 * x858
    x1486 = x1485 + x22 * x859
    x1487 = x1486 + x22 * x861
    x1488 = x1332 * x1398
    x1489 = x55 * (x1400 * x804 + x1488)
    x1490 = x1489 + x22 * x865
    x1491 = x1490 + x22 * x866
    x1492 = x1398 * x868
    x1493 = x1492 + x22 * x869
    x1494 = x1493 + x22 * x870
    x1495 = x1286 * x1431
    x1496 = x55 * (x1433 * x752 + x1495)
    x1497 = x1496 + x22 * x874
    x1498 = x1497 + x22 * x875
    x1499 = x1466 * x159
    x1500 = x1499 + x22 * x877
    x1501 = x1500 + x22 * x878
    x1502 = x1470 * x882
    x1503 = x55 * (x1472 * x714 + x1502)
    x1504 = x1503 + x22 * x884
    x1505 = x1504 + x22 * x885
    x1506 = x1470 * x769
    x1507 = x1506 + x22 * x887
    x1508 = x1507 + x22 * x888
    x1509 = x133 * x1470 + x69 * x841
    x1510 = x108 * x1509
    x1511 = x133 * x1472 + x839
    x1512 = x55 * (x1510 + x1511 * x56)
    x1513 = x1512 + x22 * x896
    x1514 = x1513 + x22 * x897
    x1515 = x1509 * x415
    x1516 = x1515 + x22 * x899
    x1517 = x1516 + x22 * x900
    x1518 = x133 * x1480 + x69 * x837
    x1519 = x1368 * x311
    x1520 = x1519 + x22 * x904
    x1521 = x1520 + x22 * x905
    x1522 = x1364 * x311
    x1523 = x1522 + x22 * x907
    x1524 = x1523 + x22 * x908
    x1525 = x1400 * x318
    x1526 = x1525 + x22 * x911
    x1527 = x1526 + x22 * x912
    x1528 = x1398 * x318
    x1529 = x1528 + x22 * x914
    x1530 = x1529 + x22 * x915
    x1531 = x1433 * x269
    x1532 = x1531 + x22 * x918
    x1533 = x1532 + x22 * x919
    x1534 = x1431 * x269
    x1535 = x1534 + x22 * x921
    x1536 = x1535 + x22 * x922
    x1537 = x1472 * x217
    x1538 = x1537 + x22 * x925
    x1539 = x1538 + x22 * x926
    x1540 = x1470 * x217
    x1541 = x1540 + x22 * x928
    x1542 = x1541 + x22 * x929
    x1543 = x1511 * x168
    x1544 = x1543 + x22 * x932
    x1545 = x1544 + x22 * x933
    x1546 = x1509 * x168
    x1547 = x1546 + x22 * x935
    x1548 = x1547 + x22 * x936
    x1549 = x55 * (x133 * x1511 + x891)
    x1550 = x1549 + x22 * x939
    x1551 = x1550 + x22 * x940
    x1552 = x55 * (x133 * x1509 + x69 * x894)
    x1553 = x1552 + x22 * x942
    x1554 = x1553 + x22 * x943
    x1555 = x359 * x945 + 2.0 * x364 - x9 * x948
    x1556 = x1555 * x394
    x1557 = x1556 + x21 * x958
    x1558 = x1557 + x21 * x959
    x1559 = x1558 + x21 * x960
    x1560 = x1555 * x6
    x1561 = x359 * x947 + 2.0 * x398 - x962 * x963
    x1562 = -x103 * x1561 + x1555 * x5
    x1563 = x1562 * x4
    x1564 = x1555 * x9
    x1565 = 3.0 * x946
    x1566 = x1564 + x1565
    x1567 = x1566 * x427
    x1568 = x1567 + x21 * x980
    x1569 = x1568 + x21 * x981
    x1570 = x1569 + x21 * x982
    x1571 = x108 * x1566
    x1572 = x1562 * x9
    x1573 = 3.0 * x966
    x1574 = x1572 + x1573
    x1575 = x1555 * x447
    x1576 = x1575 + x21 * x994
    x1577 = x1576 + x21 * x995
    x1578 = x1577 + x21 * x996
    x1579 = x133 * x1560
    x1580 = x12 * x1560
    x1581 = x110 * x1566 + x62 * x970
    x1582 = x1581 * x423
    x1583 = x1005 * x21 + x1582
    x1584 = x1006 * x21 + x1583
    x1585 = x1007 * x21 + x1584
    x1586 = x108 * x1581
    x1587 = x110 * x1574 + x62 * x972
    x1588 = x133 * x1564 + x133 * x1565
    x1589 = x1588 * x423
    x1590 = x1016 * x21 + x1589
    x1591 = x1017 * x21 + x1590
    x1592 = x1018 * x21 + x1591
    x1593 = x108 * x1588
    x1594 = x133 * x1572 + x133 * x1573
    x1595 = x1555 * x310
    x1596 = x1595 * x201
    x1597 = x1028 * x21 + x1596
    x1598 = x1029 * x21 + x1597
    x1599 = x1030 * x21 + x1598
    x1600 = x1560 * x186
    x1601 = x13 * x1560
    x1602 = x110 * x1581 + x62 * x997
    x1603 = x1602 * x419
    x1604 = x1037 * x21 + x1603
    x1605 = x1038 * x21 + x1604
    x1606 = x1039 * x21 + x1605
    x1607 = x108 * x1602
    x1608 = x110 * x1587 + x62 * x998
    x1609 = x1009 * x62 + x110 * x1588
    x1610 = x1609 * x419
    x1611 = x1047 * x21 + x1610
    x1612 = x1048 * x21 + x1611
    x1613 = x1049 * x21 + x1612
    x1614 = x108 * x1609
    x1615 = x1010 * x62 + x110 * x1594
    x1616 = x1564 * x186 + x1565 * x186
    x1617 = x1616 * x419
    x1618 = x1057 * x21 + x1617
    x1619 = x1058 * x21 + x1618
    x1620 = x1059 * x21 + x1619
    x1621 = x108 * x1616
    x1622 = x1572 * x186 + x1573 * x186
    x1623 = x1595 * x257
    x1624 = x1066 * x21 + x1623
    x1625 = x1067 * x21 + x1624
    x1626 = x1068 * x21 + x1625
    x1627 = x1560 * x245
    x1628 = x1031 * x62 + x110 * x1602
    x1629 = x1628 * x415
    x1630 = x1074 * x21 + x1629
    x1631 = x1075 * x21 + x1630
    x1632 = x1076 * x21 + x1631
    x1633 = x108 * x1628
    x1634 = x1032 * x62 + x110 * x1608
    x1635 = x1041 * x62 + x110 * x1609
    x1636 = x1635 * x415
    x1637 = x1083 * x21 + x1636
    x1638 = x1084 * x21 + x1637
    x1639 = x1085 * x21 + x1638
    x1640 = x108 * x1635
    x1641 = x1042 * x62 + x110 * x1615
    x1642 = x1051 * x62 + x110 * x1616
    x1643 = x1642 * x415
    x1644 = x1092 * x21 + x1643
    x1645 = x1093 * x21 + x1644
    x1646 = x1094 * x21 + x1645
    x1647 = x108 * x1642
    x1648 = x1052 * x62 + x110 * x1622
    x1649 = x1564 * x245 + x1565 * x245
    x1650 = x1649 * x415
    x1651 = x1101 * x21 + x1650
    x1652 = x1102 * x21 + x1651
    x1653 = x1103 * x21 + x1652
    x1654 = x108 * x1649
    x1655 = x1572 * x245 + x1573 * x245
    x1656 = x1595 * x308
    x1657 = x1109 * x21 + x1656
    x1658 = x1110 * x21 + x1657
    x1659 = x1111 * x21 + x1658
    x1660 = x1560 * x300
    x1661 = x55 * (x1069 * x62 + x110 * x1628)
    x1662 = x1115 * x21 + x1661
    x1663 = x1116 * x21 + x1662
    x1664 = x1117 * x21 + x1663
    x1665 = x55 * (x1078 * x62 + x110 * x1635)
    x1666 = x1121 * x21 + x1665
    x1667 = x1122 * x21 + x1666
    x1668 = x1123 * x21 + x1667
    x1669 = x55 * (x1087 * x62 + x110 * x1642)
    x1670 = x1127 * x21 + x1669
    x1671 = x1128 * x21 + x1670
    x1672 = x1129 * x21 + x1671
    x1673 = x55 * (x1096 * x62 + x110 * x1649)
    x1674 = x1133 * x21 + x1673
    x1675 = x1134 * x21 + x1674
    x1676 = x1135 * x21 + x1675
    x1677 = x55 * (x1564 * x300 + x1565 * x300)
    x1678 = x1139 * x21 + x1677
    x1679 = x1140 * x21 + x1678
    x1680 = x1141 * x21 + x1679
    x1681 = x1555 * x352
    x1682 = x1145 * x21 + x1681
    x1683 = x1146 * x21 + x1682
    x1684 = x1147 * x21 + x1683
    x1685 = x1149 * x359 - x1152 * x9 + x674
    x1686 = x1685 * x394
    x1687 = x1686 + x22 * x958
    x1688 = x1162 * x21 + x1687
    x1689 = x1163 * x21 + x1688
    x1690 = x1685 * x6
    x1691 = x1151 * x359 - x1165 * x962 + x704
    x1692 = -x103 * x1691 + x1685 * x5
    x1693 = 2.0 * x1150
    x1694 = x1685 * x9 + x1693
    x1695 = x1694 * x427
    x1696 = x1695 + x22 * x980
    x1697 = x1178 * x21 + x1696
    x1698 = x1179 * x21 + x1697
    x1699 = x1167 + x1692 * x9
    x1700 = x12 * x1685 + x946
    x1701 = x1700 * x427
    x1702 = x1701 + x22 * x994
    x1703 = x1191 * x21 + x1702
    x1704 = x1192 * x21 + x1703
    x1705 = x12 * x1692 + x966
    x1706 = x110 * x1694 + x1168 * x69
    x1707 = x1706 * x423
    x1708 = x1005 * x22 + x1707
    x1709 = x1203 * x21 + x1708
    x1710 = x1204 * x21 + x1709
    x1711 = x110 * x1699 + x1181
    x1712 = x1182 * x69
    x1713 = x110 * x1700 + x1712
    x1714 = x1713 * x423
    x1715 = x1016 * x22 + x1714
    x1716 = x1215 * x21 + x1715
    x1717 = x1216 * x21 + x1716
    x1718 = x110 * x1705 + x1194
    x1719 = x133 * x1700 + x986
    x1720 = x1719 * x423
    x1721 = x1028 * x22 + x1720
    x1722 = x1227 * x21 + x1721
    x1723 = x1228 * x21 + x1722
    x1724 = x133 * x1705 + x133 * x966
    x1725 = x110 * x1706 + x1195 * x69
    x1726 = x1725 * x419
    x1727 = x1037 * x22 + x1726
    x1728 = x1238 * x21 + x1727
    x1729 = x1239 * x21 + x1728
    x1730 = x110 * x1711 + x1206
    x1731 = x110 * x1713 + x1207 * x69
    x1732 = x1731 * x419
    x1733 = x1047 * x22 + x1732
    x1734 = x1249 * x21 + x1733
    x1735 = x1250 * x21 + x1734
    x1736 = x110 * x1718 + x1218
    x1737 = x1219 * x69
    x1738 = x110 * x1719 + x1737
    x1739 = x1738 * x419
    x1740 = x1057 * x22 + x1739
    x1741 = x1260 * x21 + x1740
    x1742 = x1261 * x21 + x1741
    x1743 = x110 * x1724 + x1230
    x1744 = x1020 + x133 * x1719
    x1745 = x1744 * x419
    x1746 = x1066 * x22 + x1745
    x1747 = x1271 * x21 + x1746
    x1748 = x1272 * x21 + x1747
    x1749 = x133 * x1724 + x186 * x966
    x1750 = x110 * x1725 + x1231 * x69
    x1751 = x1750 * x415
    x1752 = x1074 * x22 + x1751
    x1753 = x1281 * x21 + x1752
    x1754 = x1282 * x21 + x1753
    x1755 = x110 * x1730 + x1241
    x1756 = x110 * x1731 + x1242 * x69
    x1757 = x1756 * x415
    x1758 = x1083 * x22 + x1757
    x1759 = x1292 * x21 + x1758
    x1760 = x1293 * x21 + x1759
    x1761 = x110 * x1736 + x1252
    x1762 = x110 * x1738 + x1253 * x69
    x1763 = x1762 * x415
    x1764 = x1092 * x22 + x1763
    x1765 = x1302 * x21 + x1764
    x1766 = x1303 * x21 + x1765
    x1767 = x110 * x1743 + x1263
    x1768 = x1264 * x69
    x1769 = x110 * x1744 + x1768
    x1770 = x1769 * x415
    x1771 = x1101 * x22 + x1770
    x1772 = x1312 * x21 + x1771
    x1773 = x1313 * x21 + x1772
    x1774 = x110 * x1749 + x1274
    x1775 = x1061 + x133 * x1744
    x1776 = x1775 * x415
    x1777 = x1109 * x22 + x1776
    x1778 = x1322 * x21 + x1777
    x1779 = x1323 * x21 + x1778
    x1780 = x133 * x1749 + x245 * x966
    x1781 = x55 * (x110 * x1750 + x1275 * x69)
    x1782 = x1115 * x22 + x1781
    x1783 = x1330 * x21 + x1782
    x1784 = x1331 * x21 + x1783
    x1785 = x55 * (x110 * x1756 + x1285 * x69)
    x1786 = x1121 * x22 + x1785
    x1787 = x1337 * x21 + x1786
    x1788 = x1338 * x21 + x1787
    x1789 = x55 * (x110 * x1762 + x1296 * x69)
    x1790 = x1127 * x22 + x1789
    x1791 = x1343 * x21 + x1790
    x1792 = x1344 * x21 + x1791
    x1793 = x55 * (x110 * x1769 + x1306 * x69)
    x1794 = x1133 * x22 + x1793
    x1795 = x1349 * x21 + x1794
    x1796 = x1350 * x21 + x1795
    x1797 = x1316 * x69
    x1798 = x55 * (x110 * x1775 + x1797)
    x1799 = x1139 * x22 + x1798
    x1800 = x1355 * x21 + x1799
    x1801 = x1356 * x21 + x1800
    x1802 = x55 * (x1105 + x133 * x1775)
    x1803 = x1145 * x22 + x1802
    x1804 = x1361 * x21 + x1803
    x1805 = x1362 * x21 + x1804
    x1806 = x1364 * x359 - x1367 * x9
    x1807 = x1806 * x394
    x1808 = x1161 * x22 + x1807
    x1809 = x1162 * x22 + x1808
    x1810 = x1379 * x21 + x1809
    x1811 = x1806 * x6
    x1812 = x1366 * x359 - x1382 * x962
    x1813 = -x103 * x1812 + x1806 * x5
    x1814 = x1365 + x1806 * x9
    x1815 = x1814 * x427
    x1816 = x1177 * x22 + x1815
    x1817 = x1178 * x22 + x1816
    x1818 = x1397 * x21 + x1817
    x1819 = x1385 + x1813 * x9
    x1820 = x12 * x1806 + x1693
    x1821 = x1820 * x427
    x1822 = x1190 * x22 + x1821
    x1823 = x1191 * x22 + x1822
    x1824 = x1409 * x21 + x1823
    x1825 = x1167 + x12 * x1813
    x1826 = x110 * x1814 + x1387
    x1827 = x1826 * x423
    x1828 = x1202 * x22 + x1827
    x1829 = x1203 * x22 + x1828
    x1830 = x1419 * x21 + x1829
    x1831 = x110 * x1385 + x110 * x1819
    x1832 = x110 * x1820 + x1399
    x1833 = x1832 * x423
    x1834 = x1214 * x22 + x1833
    x1835 = x1215 * x22 + x1834
    x1836 = x1430 * x21 + x1835
    x1837 = x108 * x1400 + x110 * x1825
    x1838 = x133 * x1820 + x1712
    x1839 = x1838 * x423
    x1840 = x1226 * x22 + x1839
    x1841 = x1227 * x22 + x1840
    x1842 = x1441 * x21 + x1841
    x1843 = x1194 + x133 * x1825
    x1844 = x110 * x1826 + x1411
    x1845 = x1844 * x419
    x1846 = x1237 * x22 + x1845
    x1847 = x1238 * x22 + x1846
    x1848 = x1450 * x21 + x1847
    x1849 = x110 * x1831 + x1385 * x151
    x1850 = x110 * x1832 + x1420
    x1851 = x1850 * x419
    x1852 = x1248 * x22 + x1851
    x1853 = x1249 * x22 + x1852
    x1854 = x1458 * x21 + x1853
    x1855 = x110 * x1837 + x1400 * x882
    x1856 = x110 * x1838 + x1432
    x1857 = x1856 * x419
    x1858 = x1259 * x22 + x1857
    x1859 = x1260 * x22 + x1858
    x1860 = x1469 * x21 + x1859
    x1861 = x108 * x1433 + x110 * x1843
    x1862 = x133 * x1838 + x1737
    x1863 = x1862 * x419
    x1864 = x1270 * x22 + x1863
    x1865 = x1271 * x22 + x1864
    x1866 = x1479 * x21 + x1865
    x1867 = x1230 + x133 * x1843
    x1868 = x110 * x1844 + x1443
    x1869 = x1868 * x415
    x1870 = x1280 * x22 + x1869
    x1871 = x1281 * x22 + x1870
    x1872 = x1487 * x21 + x1871
    x1873 = x110 * x1849 + x1385 * x204
    x1874 = x110 * x1850 + x1451
    x1875 = x1874 * x415
    x1876 = x1291 * x22 + x1875
    x1877 = x1292 * x22 + x1876
    x1878 = x1494 * x21 + x1877
    x1879 = x110 * x1855 + x1286 * x1400
    x1880 = x110 * x1856 + x1460
    x1881 = x1880 * x415
    x1882 = x1301 * x22 + x1881
    x1883 = x1302 * x22 + x1882
    x1884 = x1501 * x21 + x1883
    x1885 = x110 * x1861 + x1433 * x882
    x1886 = x110 * x1862 + x1471
    x1887 = x1886 * x415
    x1888 = x1311 * x22 + x1887
    x1889 = x1312 * x22 + x1888
    x1890 = x1508 * x21 + x1889
    x1891 = x108 * x1472 + x110 * x1867
    x1892 = x133 * x1862 + x1768
    x1893 = x1892 * x415
    x1894 = x1321 * x22 + x1893
    x1895 = x1322 * x22 + x1894
    x1896 = x1517 * x21 + x1895
    x1897 = x1274 + x133 * x1867
    x1898 = x55 * (x110 * x1868 + x1481)
    x1899 = x1329 * x22 + x1898
    x1900 = x1330 * x22 + x1899
    x1901 = x1524 * x21 + x1900
    x1902 = x55 * (x110 * x1874 + x1488)
    x1903 = x1336 * x22 + x1902
    x1904 = x1337 * x22 + x1903
    x1905 = x1530 * x21 + x1904
    x1906 = x55 * (x110 * x1880 + x1495)
    x1907 = x1342 * x22 + x1906
    x1908 = x1343 * x22 + x1907
    x1909 = x1536 * x21 + x1908
    x1910 = x55 * (x110 * x1886 + x1502)
    x1911 = x1348 * x22 + x1910
    x1912 = x1349 * x22 + x1911
    x1913 = x1542 * x21 + x1912
    x1914 = x55 * (x110 * x1892 + x1510)
    x1915 = x1354 * x22 + x1914
    x1916 = x1355 * x22 + x1915
    x1917 = x1548 * x21 + x1916
    x1918 = x55 * (x133 * x1892 + x1797)
    x1919 = x1360 * x22 + x1918
    x1920 = x1361 * x22 + x1919
    x1921 = x1554 * x21 + x1920
    x1922 = -x12 * x1367 + x1364 * x669 + 2.0 * x674
    x1923 = x1922 * x394
    x1924 = x1377 * x22 + x1923
    x1925 = x1378 * x22 + x1924
    x1926 = x1379 * x22 + x1925
    x1927 = x1922 * x6
    x1928 = x1366 * x669 - x1381 * x1382 + 2.0 * x704
    x1929 = -x103 * x1928 + x1922 * x5
    x1930 = x1929 * x4
    x1931 = x1922 * x724
    x1932 = x1395 * x22 + x1931
    x1933 = x1396 * x22 + x1932
    x1934 = x1397 * x22 + x1933
    x1935 = x110 * x1927
    x1936 = x1927 * x9
    x1937 = x12 * x1922 + 3.0 * x1365
    x1938 = x1937 * x427
    x1939 = x1407 * x22 + x1938
    x1940 = x1408 * x22 + x1939
    x1941 = x1409 * x22 + x1940
    x1942 = x108 * x1937
    x1943 = x12 * x1929 + 3.0 * x1385
    x1944 = x1922 * x761
    x1945 = x1417 * x22 + x1944
    x1946 = x1418 * x22 + x1945
    x1947 = x1419 * x22 + x1946
    x1948 = x151 * x1927
    x1949 = x1937 * x777
    x1950 = x1428 * x22 + x1949
    x1951 = x1429 * x22 + x1950
    x1952 = x1430 * x22 + x1951
    x1953 = x1937 * x882
    x1954 = x1937 * x259 * x6
    x1955 = x133 * x1937 + x1398 * x62
    x1956 = x1955 * x423
    x1957 = x1439 * x22 + x1956
    x1958 = x1440 * x22 + x1957
    x1959 = x1441 * x22 + x1958
    x1960 = x108 * x1955
    x1961 = x133 * x1943 + x1400 * x62
    x1962 = x1922 * x809
    x1963 = x1448 * x22 + x1962
    x1964 = x1449 * x22 + x1963
    x1965 = x1450 * x22 + x1964
    x1966 = x1927 * x204
    x1967 = x1937 * x820
    x1968 = x1456 * x22 + x1967
    x1969 = x1457 * x22 + x1968
    x1970 = x1458 * x22 + x1969
    x1971 = x1286 * x1937
    x1972 = x1955 * x259
    x1973 = x123 * x1972
    x1974 = x1467 * x22 + x1973
    x1975 = x1468 * x22 + x1974
    x1976 = x1469 * x22 + x1975
    x1977 = x1955 * x882
    x1978 = x133 * x1955 + x1431 * x62
    x1979 = x1978 * x419
    x1980 = x1477 * x22 + x1979
    x1981 = x1478 * x22 + x1980
    x1982 = x1479 * x22 + x1981
    x1983 = x108 * x1978
    x1984 = x133 * x1961 + x1433 * x62
    x1985 = x1922 * x858
    x1986 = x1485 * x22 + x1985
    x1987 = x1486 * x22 + x1986
    x1988 = x1487 * x22 + x1987
    x1989 = x1927 * x260
    x1990 = x1937 * x868
    x1991 = x1492 * x22 + x1990
    x1992 = x1493 * x22 + x1991
    x1993 = x1494 * x22 + x1992
    x1994 = x1332 * x1937
    x1995 = x159 * x1972
    x1996 = x1499 * x22 + x1995
    x1997 = x1500 * x22 + x1996
    x1998 = x1501 * x22 + x1997
    x1999 = x1286 * x1955
    x2000 = x1978 * x769
    x2001 = x1506 * x22 + x2000
    x2002 = x1507 * x22 + x2001
    x2003 = x1508 * x22 + x2002
    x2004 = x1978 * x882
    x2005 = x133 * x1978 + x1470 * x62
    x2006 = x2005 * x415
    x2007 = x1515 * x22 + x2006
    x2008 = x1516 * x22 + x2007
    x2009 = x1517 * x22 + x2008
    x2010 = x108 * x2005
    x2011 = x133 * x1984 + x1472 * x62
    x2012 = x1922 * x311
    x2013 = x1522 * x22 + x2012
    x2014 = x1523 * x22 + x2013
    x2015 = x1524 * x22 + x2014
    x2016 = x1937 * x318
    x2017 = x1528 * x22 + x2016
    x2018 = x1529 * x22 + x2017
    x2019 = x1530 * x22 + x2018
    x2020 = x1955 * x269
    x2021 = x1534 * x22 + x2020
    x2022 = x1535 * x22 + x2021
    x2023 = x1536 * x22 + x2022
    x2024 = x1978 * x217
    x2025 = x1540 * x22 + x2024
    x2026 = x1541 * x22 + x2025
    x2027 = x1542 * x22 + x2026
    x2028 = x168 * x2005
    x2029 = x1546 * x22 + x2028
    x2030 = x1547 * x22 + x2029
    x2031 = x1548 * x22 + x2030
    x2032 = x55 * (x133 * x2005 + x1509 * x62)
    x2033 = x1552 * x22 + x2032
    x2034 = x1553 * x22 + x2033
    x2035 = x1554 * x22 + x2034
    x2036 = x1555 * x359 - x1561 * x962 + 3.0 * x961
    x2037 = x2036 * x9
    x2038 = 4.0 * x1560
    x2039 = x2037 + x2038
    x2040 = x110 * x2039 + 4.0 * x1571
    x2041 = x133 * x2037 + x133 * x2038
    x2042 = x2036 * x310
    x2043 = x110 * x2040 + 4.0 * x1586
    x2044 = x110 * x2041 + 4.0 * x1593
    x2045 = x186 * x2037 + x186 * x2038
    x2046 = x110 * x2043 + 4.0 * x1607
    x2047 = x110 * x2044 + 4.0 * x1614
    x2048 = x110 * x2045 + 4.0 * x1621
    x2049 = x2037 * x245 + x2038 * x245
    x2050 = 2.0 * x1164 + x1685 * x359 - x1691 * x962
    x2051 = 3.0 * x1690 + x2050 * x9
    x2052 = x12 * x2050 + x1560
    x2053 = x110 * x2051 + x1694 * x62
    x2054 = x110 * x2052 + x1700 * x62
    x2055 = x133 * x2052 + x1579
    x2056 = x110 * x2053 + x1706 * x62
    x2057 = x110 * x2054 + x1713 * x62
    x2058 = x110 * x2055 + x1719 * x62
    x2059 = x133 * x2055 + x1600
    x2060 = x110 * x2056 + x1725 * x62
    x2061 = x110 * x2057 + x1731 * x62
    x2062 = x110 * x2058 + x1738 * x62
    x2063 = x110 * x2059 + x1744 * x62
    x2064 = x133 * x2059 + x1627
    x2065 = x1380 + x1806 * x359 - x1812 * x962
    x2066 = 2.0 * x1811 + x2065 * x9
    x2067 = x12 * x2065 + 2.0 * x1690
    x2068 = x110 * x2066 + x1814 * x69
    x2069 = x110 * x2067 + x1820 * x69
    x2070 = x133 * x2067 + x1700 * x69
    x2071 = x110 * x2068 + x1826 * x69
    x2072 = x110 * x2069 + x1832 * x69
    x2073 = x110 * x2070 + x1838 * x69
    x2074 = x133 * x2070 + x1719 * x69
    x2075 = x110 * x2071 + x1844 * x69
    x2076 = x110 * x2072 + x1850 * x69
    x2077 = x110 * x2073 + x1856 * x69
    x2078 = x110 * x2074 + x1862 * x69
    x2079 = x133 * x2074 + x1744 * x69
    x2080 = x1922 * x359 - x1928 * x962
    x2081 = x1927 + x2080 * x9
    x2082 = x12 * x2080 + 3.0 * x1811
    x2083 = x110 * x2081 + x1935
    x2084 = x110 * x2082 + x1942
    x2085 = x133 * x2082 + x1820 * x62
    x2086 = x110 * x2083 + x1948
    x2087 = x110 * x2084 + x1953
    x2088 = x110 * x2085 + x1960
    x2089 = x133 * x2085 + x1838 * x62
    x2090 = x110 * x2086 + x1966
    x2091 = x110 * x2087 + x1971
    x2092 = x110 * x2088 + x1977
    x2093 = x110 * x2089 + x1983
    x2094 = x133 * x2089 + x1862 * x62
    x2095 = 3.0 * x1380 - x1381 * x1928 + x1922 * x669
    x2096 = x12 * x2095 + 4.0 * x1927
    x2097 = x133 * x2096 + 4.0 * x1942
    x2098 = x2097 * x259
    x2099 = x133 * x2097 + 4.0 * x1960
    x2100 = x133 * x2099 + 4.0 * x1983

    # 315 item(s)
    return numpy.array(
        [
            x0 * x81
            + x0 * x88
            + x0 * x95
            + x0 * (x0 * (x0 * (x93 + x96 * x99) + x94) + x95)
            + x55
            * (
                x109 * x76
                + x56
                * (
                    x109 * x71
                    + x56 * (x109 * x63 + x56 * (x109 * x54 + x56 * (x105 + x107)))
                )
            ),
            x0 * x122
            + x0 * x127
            + x0 * x131
            + x0 * (x0 * (x0 * (x129 + x132 * x9) + x130) + x131)
            + x55
            * (
                x109 * x117
                + x56
                * (x109 * x113 + x56 * (x109 * x111 + x56 * (x105 * x110 + x107 * x110)))
            ),
            x0 * x143
            + x0 * x146
            + x0 * x149
            + x0 * (x0 * (x0 * (x12 * x132 + x147) + x148) + x149)
            + x55
            * (
                x109 * x140
                + x56
                * (x109 * x136 + x56 * (x109 * x134 + x56 * (x105 * x133 + x107 * x133)))
            ),
            x0 * x158
            + x0 * x162
            + x0 * x166
            + x0 * (x0 * (x0 * (x164 + x167 * x99) + x165) + x166)
            + x55
            * (x109 * x154 + x56 * (x109 * x152 + x56 * (x105 * x151 + x107 * x151))),
            x0 * x177
            + x0 * x180
            + x0 * x184
            + x0 * (x0 * (x0 * (x182 + x185 * x99) + x183) + x184)
            + x55
            * (x109 * x172 + x56 * (x109 * x170 + x56 * (x105 * x169 + x107 * x169))),
            x0 * x193
            + x0 * x197
            + x0 * x200
            + x0 * (x0 * (x0 * (x198 + x201 * x99) + x199) + x200)
            + x55
            * (x109 * x189 + x56 * (x109 * x187 + x56 * (x105 * x186 + x107 * x186))),
            x0 * x207
            + x0 * x211
            + x0 * x215
            + x0 * (x0 * (x0 * (x213 + x216 * x99) + x214) + x215)
            + x55 * (x109 * x205 + x56 * (x105 * x204 + x107 * x204)),
            x0 * x221
            + x0 * x226
            + x0 * x229
            + x0 * (x0 * (x0 * (x227 + x230 * x99) + x228) + x229)
            + x55 * (x109 * x219 + x56 * (x105 * x218 + x107 * x218)),
            x0 * x235
            + x0 * x239
            + x0 * x242
            + x0 * (x0 * (x0 * (x123 * x243 + x240) + x241) + x242)
            + x55 * (x109 * x233 + x56 * (x105 * x232 + x107 * x232)),
            x0 * x248
            + x0 * x252
            + x0 * x256
            + x0 * (x0 * (x0 * (x254 + x257 * x99) + x255) + x256)
            + x55 * (x109 * x246 + x56 * (x105 * x245 + x107 * x245)),
            x0 * x261
            + x0 * x263
            + x0 * x267
            + x0 * (x0 * (x0 * (x265 + x268 * x4) + x266) + x267)
            + x55 * (x105 * x260 + x107 * x260),
            x0 * x271
            + x0 * x273
            + x0 * x277
            + x0 * (x0 * (x0 * (x275 + x278 * x99) + x276) + x277)
            + x55 * (x105 * x270 + x107 * x270),
            x0 * x282
            + x0 * x284
            + x0 * x288
            + x0 * (x0 * (x0 * (x159 * x243 + x286) + x287) + x288)
            + x55 * (x105 * x281 + x107 * x281),
            x0 * x291
            + x0 * x293
            + x0 * x297
            + x0 * (x0 * (x0 * (x295 + x298 * x99) + x296) + x297)
            + x55 * (x105 * x290 + x107 * x290),
            x0 * x301
            + x0 * x303
            + x0 * x307
            + x0 * (x0 * (x0 * (x305 + x308 * x99) + x306) + x307)
            + x55 * (x105 * x300 + x107 * x300),
            x0 * x312
            + x0 * x314
            + x0 * x317
            + x0 * (x0 * (x0 * (x309 * x99 + x315) + x316) + x317)
            + x104 * x311,
            x0 * x320
            + x0 * x322
            + x0 * x325
            + x0 * (x0 * (x0 * (x12 * x268 + x323) + x324) + x325)
            + x104 * x319,
            x0 * x328
            + x0 * x331
            + x0 * x334
            + x0 * (x0 * (x0 * (x327 * x99 + x332) + x333) + x334)
            + x104 * x329,
            x0 * x336
            + x0 * x339
            + x0 * x342
            + x0 * (x0 * (x0 * (x335 * x99 + x340) + x341) + x342)
            + x104 * x337,
            x0 * x344
            + x0 * x347
            + x0 * x350
            + x0 * (x0 * (x0 * (x343 * x99 + x348) + x349) + x350)
            + x104 * x345,
            x0 * x353
            + x0 * x355
            + x0 * x358
            + x0 * (x0 * (x0 * (x351 * x99 + x356) + x357) + x358)
            + x104 * x352,
            x0 * x389
            + x0 * x393
            + x0 * (x0 * (x0 * x397 + x392) + x393)
            + x21 * x81
            + x55
            * (
                x385 * x62
                + x56
                * (
                    x382 * x62
                    + x56 * (x380 * x62 + x56 * (x376 * x62 + x56 * (x401 + x403)))
                )
            ),
            x0 * x422
            + x0 * x426
            + x0 * (x0 * (x0 * x430 + x425) + x426)
            + x122 * x21
            + x55
            * (
                x418 * x62
                + x56
                * (x414 * x62 + x56 * (x409 * x62 + x56 * (x405 * x62 + x432 * x56)))
            ),
            x0 * x443
            + x0 * x446
            + x0 * (x0 * (x0 * x449 + x445) + x446)
            + x143 * x21
            + x55
            * (
                x440 * x62
                + x56
                * (x437 * x62 + x56 * (x434 * x62 + x56 * (x133 * x401 + x133 * x403)))
            ),
            x0 * x460
            + x0 * x463
            + x0 * (x0 * (x0 * x465 + x462) + x463)
            + x158 * x21
            + x55 * (x456 * x62 + x56 * (x453 * x62 + x56 * (x450 * x62 + x466 * x56))),
            x0 * x479
            + x0 * x482
            + x0 * (x0 * (x0 * x484 + x481) + x482)
            + x177 * x21
            + x55 * (x475 * x62 + x56 * (x472 * x62 + x56 * (x468 * x62 + x486 * x56))),
            x0 * x496
            + x0 * x500
            + x0 * (x0 * (x0 * x503 + x499) + x500)
            + x193 * x21
            + x55 * (x491 * x62 + x56 * (x488 * x62 + x56 * (x186 * x401 + x186 * x403))),
            x0 * x511
            + x0 * x515
            + x0 * (x0 * (x0 * x517 + x514) + x515)
            + x207 * x21
            + x55 * (x507 * x62 + x56 * (x504 * x62 + x518 * x56)),
            x0 * x526
            + x0 * x529
            + x0 * (x0 * (x0 * x531 + x528) + x529)
            + x21 * x221
            + x55 * (x522 * x62 + x56 * (x519 * x62 + x532 * x56)),
            x0 * x542
            + x0 * x545
            + x0 * (x0 * (x0 * x548 + x544) + x545)
            + x21 * x235
            + x55 * (x538 * x62 + x56 * (x534 * x62 + x550 * x56)),
            x0 * x556
            + x0 * x560
            + x0 * (x0 * (x0 * x562 + x559) + x560)
            + x21 * x248
            + x55 * (x552 * x62 + x56 * (x245 * x401 + x245 * x403)),
            x0 * x567
            + x0 * x571
            + x0 * (x0 * (x0 * x574 + x570) + x571)
            + x21 * x261
            + x55 * (x56 * x575 + x563 * x62),
            x0 * x580
            + x0 * x584
            + x0 * (x0 * (x0 * x586 + x583) + x584)
            + x21 * x271
            + x55 * (x56 * x587 + x576 * x62),
            x0 * x592
            + x0 * x596
            + x0 * (x0 * (x0 * x598 + x595) + x596)
            + x21 * x282
            + x55 * (x56 * x599 + x588 * x62),
            x0 * x606
            + x0 * x610
            + x0 * (x0 * (x0 * x612 + x609) + x610)
            + x21 * x291
            + x55 * (x56 * x614 + x601 * x62),
            x0 * x617
            + x0 * x621
            + x0 * (x0 * (x0 * x623 + x620) + x621)
            + x21 * x301
            + x55 * (x300 * x401 + x300 * x403),
            x0 * x625
            + x0 * x628
            + x0 * (x0 * (x0 * x630 + x627) + x628)
            + x21 * x312
            + x55 * (x106 * x260 + x110 * x575),
            x0 * x632
            + x0 * x635
            + x0 * (x0 * (x0 * x637 + x634) + x635)
            + x21 * x320
            + x55 * (x106 * x270 + x110 * x587),
            x0 * x639
            + x0 * x642
            + x0 * (x0 * (x0 * x644 + x641) + x642)
            + x21 * x328
            + x55 * (x106 * x281 + x110 * x599),
            x0 * x646
            + x0 * x649
            + x0 * (x0 * (x0 * x651 + x648) + x649)
            + x21 * x336
            + x55 * (x106 * x290 + x110 * x614),
            x0 * x654
            + x0 * x658
            + x0 * (x0 * (x0 * x660 + x657) + x658)
            + x21 * x344
            + x55 * (x300 * x431 + x661),
            x0 * x663
            + x0 * x666
            + x0 * (x0 * (x0 * x668 + x665) + x666)
            + x21 * x353
            + x352 * x400,
            x0 * x697
            + x0 * x700
            + x0 * (x0 * (x0 * x703 + x699) + x700)
            + x22 * x81
            + x55
            * (
                x56
                * (
                    x56 * (x56 * (x56 * (x707 + x709) + x62 * x686) + x62 * x690)
                    + x62 * x692
                )
                + x62 * x694
            ),
            x0 * x720
            + x0 * x723
            + x0 * (x0 * (x0 * x727 + x722) + x723)
            + x122 * x22
            + x55
            * (
                x56
                * (x56 * (x56 * (x110 * x707 + x110 * x709) + x62 * x710) + x62 * x713)
                + x62 * x716
            ),
            x0 * x741
            + x0 * x744
            + x0 * (x0 * (x0 * x746 + x743) + x744)
            + x143 * x22
            + x55
            * (
                x56 * (x56 * (x56 * (x56 * x747 + x62 * x728) + x62 * x731) + x62 * x735)
                + x62 * x737
            ),
            x0 * x755
            + x0 * x759
            + x0 * (x0 * (x0 * x763 + x758) + x759)
            + x158 * x22
            + x55 * (x56 * (x56 * (x151 * x707 + x151 * x709) + x62 * x748) + x62 * x751),
            x0 * x772
            + x0 * x776
            + x0 * (x0 * (x0 * x779 + x775) + x776)
            + x177 * x22
            + x55 * (x56 * (x56 * (x168 * x780 + x714 * x747) + x62 * x765) + x62 * x768),
            x0 * x791
            + x0 * x795
            + x0 * (x0 * (x0 * x797 + x794) + x795)
            + x193 * x22
            + x55 * (x56 * (x56 * (x56 * x798 + x62 * x781) + x62 * x784) + x62 * x788),
            x0 * x803
            + x0 * x807
            + x0 * (x0 * (x0 * x811 + x806) + x807)
            + x207 * x22
            + x55 * (x56 * (x204 * x707 + x204 * x709) + x62 * x799),
            x0 * x816
            + x0 * x819
            + x0 * (x0 * (x0 * x822 + x818) + x819)
            + x22 * x221
            + x55 * (x56 * (x217 * x780 + x747 * x752) + x62 * x812),
            x0 * x828
            + x0 * x831
            + x0 * (x0 * (x0 * x835 + x830) + x831)
            + x22 * x235
            + x55 * (x56 * (x168 * x836 + x714 * x798) + x62 * x824),
            x0 * x845
            + x0 * x848
            + x0 * (x0 * (x0 * x850 + x847) + x848)
            + x22 * x248
            + x55 * (x56 * (x56 * x851 + x62 * x837) + x62 * x840),
            x0 * x853
            + x0 * x857
            + x0 * (x0 * (x0 * x861 + x856) + x857)
            + x22 * x261
            + x55 * (x260 * x707 + x260 * x709),
            x0 * x863
            + x0 * x867
            + x0 * (x0 * (x0 * x870 + x866) + x867)
            + x22 * x271
            + x55 * (x269 * x780 + x747 * x804),
            x0 * x872
            + x0 * x876
            + x0 * (x0 * (x0 * x878 + x875) + x876)
            + x22 * x282
            + x55 * (x217 * x836 + x752 * x798),
            x0 * x881
            + x0 * x886
            + x0 * (x0 * (x0 * x888 + x885) + x886)
            + x22 * x291
            + x55 * (x168 * x61 * x837 + x714 * x851),
            x0 * x893
            + x0 * x898
            + x0 * (x0 * (x0 * x900 + x897) + x898)
            + x22 * x301
            + x55 * (x56 * x901 + x62 * x889),
            x0 * x903
            + x0 * x906
            + x0 * (x0 * (x0 * x908 + x905) + x906)
            + x22 * x312
            + x311 * x706,
            x0 * x910
            + x0 * x913
            + x0 * (x0 * (x0 * x915 + x912) + x913)
            + x22 * x320
            + x318 * x747,
            x0 * x917
            + x0 * x920
            + x0 * (x0 * (x0 * x922 + x919) + x920)
            + x22 * x328
            + x269 * x798,
            x0 * x924
            + x0 * x927
            + x0 * (x0 * (x0 * x929 + x926) + x927)
            + x217 * x851
            + x22 * x336,
            x0 * x931
            + x0 * x934
            + x0 * (x0 * (x0 * x936 + x933) + x934)
            + x168 * x901
            + x22 * x344,
            x0 * x938
            + x0 * x941
            + x0 * (x0 * (x0 * x943 + x940) + x941)
            + x22 * x353
            + x55 * (x133 * x901 + x661),
            x0 * x957
            + x0 * (x0 * x960 + x957)
            + x21 * x388
            + x21 * x389
            + x55
            * (
                x56
                * (
                    x56 * (x56 * (x56 * (x965 + x967) + x69 * x951) + x69 * x952)
                    + x69 * x953
                )
                + x69 * x954
            ),
            x0 * x979
            + x0 * (x0 * x982 + x979)
            + x21 * x421
            + x21 * x422
            + x55
            * (
                x56 * (x56 * (x56 * (x56 * x985 + x69 * x972) + x69 * x973) + x69 * x974)
                + x69 * x976
            ),
            x0 * x993
            + x0 * (x0 * x996 + x993)
            + x21 * x442
            + x21 * x443
            + x55
            * (
                x56
                * (x56 * (x56 * (x133 * x965 + x133 * x967) + x69 * x987) + x69 * x989)
                + x69 * x990
            ),
            x0 * x1004
            + x0 * (x0 * x1007 + x1004)
            + x21 * x459
            + x21 * x460
            + x55 * (x1000 * x69 + x56 * (x56 * (x1008 * x56 + x69 * x998) + x69 * x999)),
            x0 * x1015
            + x0 * (x0 * x1018 + x1015)
            + x21 * x478
            + x21 * x479
            + x55
            * (x1012 * x69 + x56 * (x1011 * x69 + x56 * (x1010 * x69 + x1019 * x56))),
            x0 * x1026
            + x0 * (x0 * x1030 + x1026)
            + x21 * x495
            + x21 * x496
            + x55
            * (x1023 * x69 + x56 * (x1021 * x69 + x56 * (x186 * x965 + x186 * x967))),
            x0 * x1036
            + x0 * (x0 * x1039 + x1036)
            + x21 * x510
            + x21 * x511
            + x55 * (x1033 * x69 + x56 * (x1032 * x69 + x1040 * x56)),
            x0 * x1046
            + x0 * (x0 * x1049 + x1046)
            + x21 * x525
            + x21 * x526
            + x55 * (x1043 * x69 + x56 * (x1042 * x69 + x1050 * x56)),
            x0 * x1056
            + x0 * (x0 * x1059 + x1056)
            + x21 * x541
            + x21 * x542
            + x55 * (x1053 * x69 + x56 * (x1052 * x69 + x1060 * x56)),
            x0 * x1065
            + x0 * (x0 * x1068 + x1065)
            + x21 * x555
            + x21 * x556
            + x55 * (x1062 * x69 + x56 * (x245 * x965 + x245 * x967)),
            x0 * x1073
            + x0 * (x0 * x1076 + x1073)
            + x21 * x566
            + x21 * x567
            + x55 * (x1070 * x69 + x1077 * x56),
            x0 * x1082
            + x0 * (x0 * x1085 + x1082)
            + x21 * x579
            + x21 * x580
            + x55 * (x1079 * x69 + x1086 * x56),
            x0 * x1091
            + x0 * (x0 * x1094 + x1091)
            + x21 * x591
            + x21 * x592
            + x55 * (x1088 * x69 + x1095 * x56),
            x0 * x1100
            + x0 * (x0 * x1103 + x1100)
            + x21 * x605
            + x21 * x606
            + x55 * (x1097 * x69 + x1104 * x56),
            x0 * x1108
            + x0 * (x0 * x1111 + x1108)
            + x21 * x616
            + x21 * x617
            + x55 * (x300 * x965 + x300 * x967),
            x0 * x1114
            + x0 * (x0 * x1117 + x1114)
            + x21 * x624
            + x21 * x625
            + x55 * (x1077 * x110 + x563 * x69),
            x0 * x1120
            + x0 * (x0 * x1123 + x1120)
            + x21 * x631
            + x21 * x632
            + x55 * (x1086 * x110 + x576 * x69),
            x0 * x1126
            + x0 * (x0 * x1129 + x1126)
            + x21 * x638
            + x21 * x639
            + x55 * (x1095 * x110 + x588 * x69),
            x0 * x1132
            + x0 * (x0 * x1135 + x1132)
            + x21 * x645
            + x21 * x646
            + x55 * (x110 * x1104 + x601 * x69),
            x0 * x1138
            + x0 * (x0 * x1141 + x1138)
            + x21 * x653
            + x21 * x654
            + x55 * (x300 * x983 + x300 * x984),
            x0 * x1144
            + x0 * (x0 * x1147 + x1144)
            + x21 * x662
            + x21 * x663
            + x352 * x964,
            x0 * x1160
            + x0 * (x0 * x1163 + x1160)
            + x21 * x697
            + x22 * x388
            + x55
            * (
                x1157 * x69
                + x56
                * (
                    x1156 * x69
                    + x56
                    * (x1155 * x69 + x56 * (x1154 * x69 + x56 * (x1166 * x4 + x1167)))
                )
            ),
            x0 * x1176
            + x0 * (x0 * x1179 + x1176)
            + x21 * x720
            + x22 * x421
            + x55
            * (
                x1172 * x69
                + x56 * (x1171 * x69 + x56 * (x1170 * x69 + x56 * (x1180 * x56 + x1181)))
            ),
            x0 * x1189
            + x0 * (x0 * x1192 + x1189)
            + x21 * x741
            + x22 * x442
            + x55
            * (
                x1186 * x69
                + x56 * (x1185 * x69 + x56 * (x1184 * x69 + x56 * (x1193 * x56 + x1194)))
            ),
            x0 * x1201
            + x0 * (x0 * x1204 + x1201)
            + x21 * x755
            + x22 * x459
            + x55 * (x1198 * x69 + x56 * (x1197 * x69 + x56 * (x1205 * x56 + x1206))),
            x0 * x1213
            + x0 * (x0 * x1216 + x1213)
            + x21 * x772
            + x22 * x478
            + x55 * (x1210 * x69 + x56 * (x1209 * x69 + x56 * (x1217 * x56 + x1218))),
            x0 * x1225
            + x0 * (x0 * x1228 + x1225)
            + x21 * x791
            + x22 * x495
            + x55 * (x1222 * x69 + x56 * (x1221 * x69 + x56 * (x1229 * x56 + x1230))),
            x0 * x1236
            + x0 * (x0 * x1239 + x1236)
            + x21 * x803
            + x22 * x510
            + x55 * (x1233 * x69 + x56 * (x1240 * x56 + x1241)),
            x0 * x1247
            + x0 * (x0 * x1250 + x1247)
            + x21 * x816
            + x22 * x525
            + x55 * (x1244 * x69 + x56 * (x1251 * x56 + x1252)),
            x0 * x1258
            + x0 * (x0 * x1261 + x1258)
            + x21 * x828
            + x22 * x541
            + x55 * (x1255 * x69 + x56 * (x1262 * x56 + x1263)),
            x0 * x1269
            + x0 * (x0 * x1272 + x1269)
            + x21 * x845
            + x22 * x555
            + x55 * (x1266 * x69 + x56 * (x1273 * x56 + x1274)),
            x0 * x1279
            + x0 * (x0 * x1282 + x1279)
            + x21 * x853
            + x22 * x566
            + x55 * (x1283 * x56 + x1284),
            x0 * x1290
            + x0 * (x0 * x1293 + x1290)
            + x21 * x863
            + x22 * x579
            + x55 * (x1294 * x56 + x1295),
            x0 * x1300
            + x0 * (x0 * x1303 + x1300)
            + x21 * x872
            + x22 * x591
            + x55 * (x1304 * x56 + x1305),
            x0 * x1310
            + x0 * (x0 * x1313 + x1310)
            + x21 * x881
            + x22 * x605
            + x55 * (x1314 * x56 + x1315),
            x0 * x1320
            + x0 * (x0 * x1323 + x1320)
            + x21 * x893
            + x22 * x616
            + x55 * (x1324 * x56 + x1325),
            x0 * x1328
            + x0 * (x0 * x1331 + x1328)
            + x21 * x903
            + x22 * x624
            + x55 * (x110 * x1283 + x260 * x708),
            x0 * x1335
            + x0 * (x0 * x1338 + x1335)
            + x21 * x910
            + x22 * x631
            + x55 * (x110 * x1294 + x1332 * x728),
            x0 * x1341
            + x0 * (x0 * x1344 + x1341)
            + x21 * x917
            + x22 * x638
            + x55 * (x110 * x1304 + x1286 * x781),
            x0 * x1347
            + x0 * (x0 * x1350 + x1347)
            + x21 * x924
            + x22 * x645
            + x55 * (x110 * x1314 + x837 * x882),
            x0 * x1353
            + x0 * (x0 * x1356 + x1353)
            + x21 * x931
            + x22 * x653
            + x55 * (x108 * x889 + x110 * x1324),
            x0 * x1359
            + x0 * (x0 * x1362 + x1359)
            + x21 * x938
            + x22 * x662
            + x55 * (x1324 * x133 + x300 * x402),
            x0 * x1376
            + x0 * (x0 * x1379 + x1376)
            + x22 * x696
            + x22 * x697
            + x55
            * (
                x1373 * x69
                + x56
                * (
                    x1372 * x69
                    + x56 * (x1371 * x69 + x56 * (x1370 * x69 + x56 * (x1384 + x1386)))
                )
            ),
            x0 * x1394
            + x0 * (x0 * x1397 + x1394)
            + x22 * x719
            + x22 * x720
            + x55
            * (
                x1391 * x69
                + x56
                * (
                    x1389 * x69
                    + x56 * (x1388 * x69 + x56 * (x110 * x1384 + x110 * x1386))
                )
            ),
            x0 * x1406
            + x0 * (x0 * x1409 + x1406)
            + x22 * x740
            + x22 * x741
            + x55
            * (
                x1403 * x69
                + x56
                * (x1402 * x69 + x56 * (x1401 * x69 + x56 * (x1400 * x69 + x1410 * x56)))
            ),
            x0 * x1416
            + x0 * (x0 * x1419 + x1416)
            + x22 * x754
            + x22 * x755
            + x55
            * (x1413 * x69 + x56 * (x1412 * x69 + x56 * (x1384 * x151 + x1386 * x151))),
            x0 * x1427
            + x0 * (x0 * x1430 + x1427)
            + x22 * x771
            + x22 * x772
            + x55
            * (x1423 * x69 + x56 * (x1421 * x69 + x56 * (x1400 * x879 + x1410 * x714))),
            x0 * x1438
            + x0 * (x0 * x1441 + x1438)
            + x22 * x790
            + x22 * x791
            + x55
            * (x1435 * x69 + x56 * (x1434 * x69 + x56 * (x1433 * x69 + x1442 * x56))),
            x0 * x1447
            + x0 * (x0 * x1450 + x1447)
            + x22 * x802
            + x22 * x803
            + x55 * (x1444 * x69 + x56 * (x1384 * x204 + x1386 * x204)),
            x0 * x1455
            + x0 * (x0 * x1458 + x1455)
            + x22 * x815
            + x22 * x816
            + x55 * (x1452 * x69 + x56 * (x1410 * x752 + x1459 * x217)),
            x0 * x1465
            + x0 * (x0 * x1469 + x1465)
            + x22 * x827
            + x22 * x828
            + x55 * (x1461 * x69 + x56 * (x1433 * x879 + x1442 * x714)),
            x0 * x1476
            + x0 * (x0 * x1479 + x1476)
            + x22 * x844
            + x22 * x845
            + x55 * (x1473 * x69 + x56 * (x1472 * x69 + x1480 * x56)),
            x0 * x1484
            + x0 * (x0 * x1487 + x1484)
            + x22 * x852
            + x22 * x853
            + x55 * (x1384 * x260 + x1386 * x260),
            x0 * x1491
            + x0 * (x0 * x1494 + x1491)
            + x22 * x862
            + x22 * x863
            + x55 * (x1410 * x804 + x1459 * x269),
            x0 * x1498
            + x0 * (x0 * x1501 + x1498)
            + x22 * x871
            + x22 * x872
            + x55 * (x1433 * x217 * x42 + x1442 * x752),
            x0 * x1505
            + x0 * (x0 * x1508 + x1505)
            + x22 * x880
            + x22 * x881
            + x55 * (x1472 * x879 + x1480 * x714),
            x0 * x1514
            + x0 * (x0 * x1517 + x1514)
            + x22 * x892
            + x22 * x893
            + x55 * (x1511 * x69 + x1518 * x56),
            x0 * x1521
            + x0 * (x0 * x1524 + x1521)
            + x1383 * x311
            + x22 * x902
            + x22 * x903,
            x0 * x1527
            + x0 * (x0 * x1530 + x1527)
            + x1410 * x318
            + x22 * x909
            + x22 * x910,
            x0 * x1533
            + x0 * (x0 * x1536 + x1533)
            + x1442 * x269
            + x22 * x916
            + x22 * x917,
            x0 * x1539
            + x0 * (x0 * x1542 + x1539)
            + x1480 * x217
            + x22 * x923
            + x22 * x924,
            x0 * x1545
            + x0 * (x0 * x1548 + x1545)
            + x1518 * x168
            + x22 * x930
            + x22 * x931,
            x0 * x1551
            + x0 * (x0 * x1554 + x1551)
            + x22 * x937
            + x22 * x938
            + x55 * (x133 * x1518 + x69 * x889),
            x0 * x1559
            + x21 * x955
            + x21 * x956
            + x21 * x957
            + x55
            * (
                x1560 * x390
                + x56
                * (
                    x1560 * x386
                    + x56 * (x1560 * x383 + x56 * (x1560 * x56 + x56 * (x1560 + x1563)))
                )
            ),
            x0 * x1570
            + x21 * x977
            + x21 * x978
            + x21 * x979
            + x55
            * (
                x1173 * x1566
                + x56
                * (x1001 * x1566 + x56 * (x1566 * x512 + x56 * (x1571 + x1574 * x56)))
            ),
            x0 * x1578
            + x21 * x991
            + x21 * x992
            + x21 * x993
            + x55
            * (
                x1580 * x423
                + x56
                * (x1580 * x419 + x56 * (x1580 * x415 + x56 * (x133 * x1563 + x1579)))
            ),
            x0 * x1585
            + x1002 * x21
            + x1003 * x21
            + x1004 * x21
            + x55 * (x1001 * x1581 + x56 * (x1581 * x512 + x56 * (x1586 + x1587 * x56))),
            x0 * x1592
            + x1013 * x21
            + x1014 * x21
            + x1015 * x21
            + x55 * (x1001 * x1588 + x56 * (x1588 * x512 + x56 * (x1593 + x1594 * x56))),
            x0 * x1599
            + x1024 * x21
            + x1025 * x21
            + x1026 * x21
            + x55 * (x1601 * x497 + x56 * (x1601 * x493 + x56 * (x1563 * x186 + x1600))),
            x0 * x1606
            + x1034 * x21
            + x1035 * x21
            + x1036 * x21
            + x55 * (x1602 * x512 + x56 * (x1607 + x1608 * x56)),
            x0 * x1613
            + x1044 * x21
            + x1045 * x21
            + x1046 * x21
            + x55 * (x1609 * x512 + x56 * (x1614 + x1615 * x56)),
            x0 * x1620
            + x1054 * x21
            + x1055 * x21
            + x1056 * x21
            + x55 * (x1616 * x512 + x56 * (x1621 + x1622 * x56)),
            x0 * x1626
            + x1063 * x21
            + x1064 * x21
            + x1065 * x21
            + x55 * (x1560 * x557 + x56 * (x1563 * x245 + x1627)),
            x0 * x1632
            + x1071 * x21
            + x1072 * x21
            + x1073 * x21
            + x55 * (x1633 + x1634 * x56),
            x0 * x1639
            + x1080 * x21
            + x1081 * x21
            + x1082 * x21
            + x55 * (x1640 + x1641 * x56),
            x0 * x1646
            + x1089 * x21
            + x1090 * x21
            + x1091 * x21
            + x55 * (x1647 + x1648 * x56),
            x0 * x1653
            + x1098 * x21
            + x1099 * x21
            + x1100 * x21
            + x55 * (x1654 + x1655 * x56),
            x0 * x1659
            + x1106 * x21
            + x1107 * x21
            + x1108 * x21
            + x55 * (x1563 * x300 + x1660),
            x0 * x1664
            + x1112 * x21
            + x1113 * x21
            + x1114 * x21
            + x55 * (x1070 * x62 + x110 * x1634),
            x0 * x1668
            + x1118 * x21
            + x1119 * x21
            + x1120 * x21
            + x55 * (x1079 * x62 + x110 * x1641),
            x0 * x1672
            + x1124 * x21
            + x1125 * x21
            + x1126 * x21
            + x55 * (x1088 * x62 + x110 * x1648),
            x0 * x1676
            + x1130 * x21
            + x1131 * x21
            + x1132 * x21
            + x55 * (x1097 * x62 + x110 * x1655),
            x0 * x1680
            + x1136 * x21
            + x1137 * x21
            + x1138 * x21
            + x55 * (x1572 * x300 + x1573 * x300),
            x0 * x1684 + x1142 * x21 + x1143 * x21 + x1144 * x21 + x1562 * x352,
            x0 * x1689
            + x1159 * x21
            + x1160 * x21
            + x22 * x955
            + x55
            * (
                x1690 * x390
                + x56
                * (
                    x1690 * x386
                    + x56
                    * (x1690 * x383 + x56 * (x1690 * x56 + x56 * (x1690 + x1692 * x4)))
                )
            ),
            x0 * x1698
            + x1175 * x21
            + x1176 * x21
            + x22 * x977
            + x55
            * (
                x1173 * x1694
                + x56
                * (
                    x1001 * x1694
                    + x56 * (x1694 * x512 + x56 * (x108 * x1694 + x1699 * x56))
                )
            ),
            x0 * x1704
            + x1188 * x21
            + x1189 * x21
            + x22 * x991
            + x55
            * (
                x1173 * x1700
                + x56
                * (
                    x1001 * x1700
                    + x56 * (x1700 * x512 + x56 * (x108 * x1700 + x1705 * x56))
                )
            ),
            x0 * x1710
            + x1002 * x22
            + x1200 * x21
            + x1201 * x21
            + x55
            * (x1001 * x1706 + x56 * (x1706 * x512 + x56 * (x108 * x1706 + x1711 * x56))),
            x0 * x1717
            + x1013 * x22
            + x1212 * x21
            + x1213 * x21
            + x55
            * (x1001 * x1713 + x56 * (x1713 * x512 + x56 * (x108 * x1713 + x1718 * x56))),
            x0 * x1723
            + x1024 * x22
            + x1224 * x21
            + x1225 * x21
            + x55
            * (x1001 * x1719 + x56 * (x1719 * x512 + x56 * (x108 * x1719 + x1724 * x56))),
            x0 * x1729
            + x1034 * x22
            + x1235 * x21
            + x1236 * x21
            + x55 * (x1725 * x512 + x56 * (x108 * x1725 + x1730 * x56)),
            x0 * x1735
            + x1044 * x22
            + x1246 * x21
            + x1247 * x21
            + x55 * (x1731 * x512 + x56 * (x108 * x1731 + x1736 * x56)),
            x0 * x1742
            + x1054 * x22
            + x1257 * x21
            + x1258 * x21
            + x55 * (x1738 * x512 + x56 * (x108 * x1738 + x1743 * x56)),
            x0 * x1748
            + x1063 * x22
            + x1268 * x21
            + x1269 * x21
            + x55 * (x1744 * x512 + x56 * (x108 * x1744 + x1749 * x56)),
            x0 * x1754
            + x1071 * x22
            + x1278 * x21
            + x1279 * x21
            + x55 * (x108 * x1750 + x1755 * x56),
            x0 * x1760
            + x1080 * x22
            + x1289 * x21
            + x1290 * x21
            + x55 * (x108 * x1756 + x1761 * x56),
            x0 * x1766
            + x1089 * x22
            + x1299 * x21
            + x1300 * x21
            + x55 * (x108 * x1762 + x1767 * x56),
            x0 * x1773
            + x1098 * x22
            + x1309 * x21
            + x1310 * x21
            + x55 * (x108 * x1769 + x1774 * x56),
            x0 * x1779
            + x1106 * x22
            + x1319 * x21
            + x1320 * x21
            + x55 * (x108 * x1775 + x1780 * x56),
            x0 * x1784
            + x1112 * x22
            + x1327 * x21
            + x1328 * x21
            + x55 * (x110 * x1755 + x1284),
            x0 * x1788
            + x1118 * x22
            + x1334 * x21
            + x1335 * x21
            + x55 * (x110 * x1761 + x1295),
            x0 * x1792
            + x1124 * x22
            + x1340 * x21
            + x1341 * x21
            + x55 * (x110 * x1767 + x1305),
            x0 * x1796
            + x1130 * x22
            + x1346 * x21
            + x1347 * x21
            + x55 * (x110 * x1774 + x1315),
            x0 * x1801
            + x1136 * x22
            + x1352 * x21
            + x1353 * x21
            + x55 * (x110 * x1780 + x1325),
            x0 * x1805
            + x1142 * x22
            + x1358 * x21
            + x1359 * x21
            + x55 * (x133 * x1780 + x300 * x966),
            x0 * x1810
            + x1158 * x22
            + x1159 * x22
            + x1376 * x21
            + x55
            * (
                x1811 * x390
                + x56
                * (
                    x1811 * x386
                    + x56
                    * (x1811 * x383 + x56 * (x1811 * x56 + x56 * (x1811 + x1813 * x4)))
                )
            ),
            x0 * x1818
            + x1174 * x22
            + x1175 * x22
            + x1394 * x21
            + x55
            * (
                x1173 * x1814
                + x56
                * (
                    x1001 * x1814
                    + x56 * (x1814 * x512 + x56 * (x108 * x1814 + x1819 * x56))
                )
            ),
            x0 * x1824
            + x1187 * x22
            + x1188 * x22
            + x1406 * x21
            + x55
            * (
                x1173 * x1820
                + x56
                * (
                    x1001 * x1820
                    + x56 * (x1820 * x512 + x56 * (x108 * x1820 + x1825 * x56))
                )
            ),
            x0 * x1830
            + x1199 * x22
            + x1200 * x22
            + x1416 * x21
            + x55
            * (x1001 * x1826 + x56 * (x1826 * x512 + x56 * (x108 * x1826 + x1831 * x56))),
            x0 * x1836
            + x1211 * x22
            + x1212 * x22
            + x1427 * x21
            + x55
            * (x1001 * x1832 + x56 * (x1832 * x512 + x56 * (x108 * x1832 + x1837 * x56))),
            x0 * x1842
            + x1223 * x22
            + x1224 * x22
            + x1438 * x21
            + x55
            * (x1001 * x1838 + x56 * (x1838 * x512 + x56 * (x108 * x1838 + x1843 * x56))),
            x0 * x1848
            + x1234 * x22
            + x1235 * x22
            + x1447 * x21
            + x55 * (x1844 * x512 + x56 * (x108 * x1844 + x1849 * x56)),
            x0 * x1854
            + x1245 * x22
            + x1246 * x22
            + x1455 * x21
            + x55 * (x1850 * x512 + x56 * (x108 * x1850 + x1855 * x56)),
            x0 * x1860
            + x1256 * x22
            + x1257 * x22
            + x1465 * x21
            + x55 * (x1856 * x512 + x56 * (x108 * x1856 + x1861 * x56)),
            x0 * x1866
            + x1267 * x22
            + x1268 * x22
            + x1476 * x21
            + x55 * (x1862 * x512 + x56 * (x108 * x1862 + x1867 * x56)),
            x0 * x1872
            + x1277 * x22
            + x1278 * x22
            + x1484 * x21
            + x55 * (x108 * x1868 + x1873 * x56),
            x0 * x1878
            + x1288 * x22
            + x1289 * x22
            + x1491 * x21
            + x55 * (x108 * x1874 + x1879 * x56),
            x0 * x1884
            + x1298 * x22
            + x1299 * x22
            + x1498 * x21
            + x55 * (x108 * x1880 + x1885 * x56),
            x0 * x1890
            + x1308 * x22
            + x1309 * x22
            + x1505 * x21
            + x55 * (x108 * x1886 + x1891 * x56),
            x0 * x1896
            + x1318 * x22
            + x1319 * x22
            + x1514 * x21
            + x55 * (x108 * x1892 + x1897 * x56),
            x0 * x1901
            + x1326 * x22
            + x1327 * x22
            + x1521 * x21
            + x55 * (x110 * x1873 + x1385 * x260),
            x0 * x1905
            + x1333 * x22
            + x1334 * x22
            + x1527 * x21
            + x55 * (x110 * x1879 + x1332 * x1400),
            x0 * x1909
            + x1339 * x22
            + x1340 * x22
            + x1533 * x21
            + x55 * (x110 * x1885 + x1286 * x1433),
            x0 * x1913
            + x1345 * x22
            + x1346 * x22
            + x1539 * x21
            + x55 * (x110 * x1891 + x1472 * x882),
            x0 * x1917
            + x1351 * x22
            + x1352 * x22
            + x1545 * x21
            + x55 * (x108 * x1511 + x110 * x1897),
            x0 * x1921
            + x1357 * x22
            + x1358 * x22
            + x1551 * x21
            + x55 * (x1325 + x133 * x1897),
            x0 * x1926
            + x1374 * x22
            + x1375 * x22
            + x1376 * x22
            + x55
            * (
                x1927 * x390
                + x56
                * (
                    x1927 * x386
                    + x56 * (x1927 * x383 + x56 * (x1927 * x56 + x56 * (x1927 + x1930)))
                )
            ),
            x0 * x1934
            + x1392 * x22
            + x1393 * x22
            + x1394 * x22
            + x55
            * (
                x1936 * x423
                + x56
                * (x1936 * x419 + x56 * (x1927 * x714 + x56 * (x110 * x1930 + x1935)))
            ),
            x0 * x1941
            + x1404 * x22
            + x1405 * x22
            + x1406 * x22
            + x55
            * (
                x1173 * x1937
                + x56
                * (x1001 * x1937 + x56 * (x1937 * x512 + x56 * (x1942 + x1943 * x56)))
            ),
            x0 * x1947
            + x1414 * x22
            + x1415 * x22
            + x1416 * x22
            + x55 * (x1927 * x756 + x56 * (x1927 * x752 + x56 * (x151 * x1930 + x1948))),
            x0 * x1952
            + x1425 * x22
            + x1426 * x22
            + x1427 * x22
            + x55 * (x123 * x1954 + x56 * (x1462 * x1937 + x56 * (x1943 * x714 + x1953))),
            x0 * x1959
            + x1436 * x22
            + x1437 * x22
            + x1438 * x22
            + x55 * (x1001 * x1955 + x56 * (x1955 * x512 + x56 * (x1960 + x1961 * x56))),
            x0 * x1965
            + x1445 * x22
            + x1446 * x22
            + x1447 * x22
            + x55 * (x1927 * x804 + x56 * (x1930 * x204 + x1966)),
            x0 * x1970
            + x1453 * x22
            + x1454 * x22
            + x1455 * x22
            + x55 * (x159 * x1954 + x56 * (x1943 * x752 + x1971)),
            x0 * x1976
            + x1463 * x22
            + x1464 * x22
            + x1465 * x22
            + x55 * (x1462 * x1955 + x56 * (x1961 * x714 + x1977)),
            x0 * x1982
            + x1474 * x22
            + x1475 * x22
            + x1476 * x22
            + x55 * (x1978 * x512 + x56 * (x1983 + x1984 * x56)),
            x0 * x1988
            + x1482 * x22
            + x1483 * x22
            + x1484 * x22
            + x55 * (x1930 * x260 + x1989),
            x0 * x1993
            + x1489 * x22
            + x1490 * x22
            + x1491 * x22
            + x55 * (x1943 * x804 + x1994),
            x0 * x1998
            + x1496 * x22
            + x1497 * x22
            + x1498 * x22
            + x55 * (x1961 * x752 + x1999),
            x0 * x2003
            + x1503 * x22
            + x1504 * x22
            + x1505 * x22
            + x55 * (x1984 * x714 + x2004),
            x0 * x2009
            + x1512 * x22
            + x1513 * x22
            + x1514 * x22
            + x55 * (x2010 + x2011 * x56),
            x0 * x2015 + x1519 * x22 + x1520 * x22 + x1521 * x22 + x1929 * x311,
            x0 * x2019 + x1525 * x22 + x1526 * x22 + x1527 * x22 + x1943 * x318,
            x0 * x2023 + x1531 * x22 + x1532 * x22 + x1533 * x22 + x1961 * x269,
            x0 * x2027 + x1537 * x22 + x1538 * x22 + x1539 * x22 + x1984 * x217,
            x0 * x2031 + x1543 * x22 + x1544 * x22 + x1545 * x22 + x168 * x2011,
            x0 * x2035
            + x1549 * x22
            + x1550 * x22
            + x1551 * x22
            + x55 * (x133 * x2011 + x1511 * x62),
            x1556 * x21 + x1557 * x21 + x1558 * x21 + x1559 * x21 + x2036 * x394,
            x1567 * x21 + x1568 * x21 + x1569 * x21 + x1570 * x21 + x2039 * x427,
            x1575 * x21 + x1576 * x21 + x1577 * x21 + x1578 * x21 + x2036 * x447,
            x1582 * x21 + x1583 * x21 + x1584 * x21 + x1585 * x21 + x2040 * x423,
            x1589 * x21 + x1590 * x21 + x1591 * x21 + x1592 * x21 + x2041 * x423,
            x1596 * x21 + x1597 * x21 + x1598 * x21 + x1599 * x21 + x201 * x2042,
            x1603 * x21 + x1604 * x21 + x1605 * x21 + x1606 * x21 + x2043 * x419,
            x1610 * x21 + x1611 * x21 + x1612 * x21 + x1613 * x21 + x2044 * x419,
            x1617 * x21 + x1618 * x21 + x1619 * x21 + x1620 * x21 + x2045 * x419,
            x1623 * x21 + x1624 * x21 + x1625 * x21 + x1626 * x21 + x2042 * x257,
            x1629 * x21 + x1630 * x21 + x1631 * x21 + x1632 * x21 + x2046 * x415,
            x1636 * x21 + x1637 * x21 + x1638 * x21 + x1639 * x21 + x2047 * x415,
            x1643 * x21 + x1644 * x21 + x1645 * x21 + x1646 * x21 + x2048 * x415,
            x1650 * x21 + x1651 * x21 + x1652 * x21 + x1653 * x21 + x2049 * x415,
            x1656 * x21 + x1657 * x21 + x1658 * x21 + x1659 * x21 + x2042 * x308,
            x1661 * x21
            + x1662 * x21
            + x1663 * x21
            + x1664 * x21
            + x55 * (x110 * x2046 + 4.0 * x1633),
            x1665 * x21
            + x1666 * x21
            + x1667 * x21
            + x1668 * x21
            + x55 * (x110 * x2047 + 4.0 * x1640),
            x1669 * x21
            + x1670 * x21
            + x1671 * x21
            + x1672 * x21
            + x55 * (x110 * x2048 + 4.0 * x1647),
            x1673 * x21
            + x1674 * x21
            + x1675 * x21
            + x1676 * x21
            + x55 * (x110 * x2049 + 4.0 * x1654),
            x1677 * x21
            + x1678 * x21
            + x1679 * x21
            + x1680 * x21
            + x55 * (x2037 * x300 + x2038 * x300),
            x1681 * x21 + x1682 * x21 + x1683 * x21 + x1684 * x21 + x2036 * x352,
            x1556 * x22 + x1687 * x21 + x1688 * x21 + x1689 * x21 + x2050 * x394,
            x1567 * x22 + x1696 * x21 + x1697 * x21 + x1698 * x21 + x2051 * x427,
            x1575 * x22 + x1702 * x21 + x1703 * x21 + x1704 * x21 + x2052 * x427,
            x1582 * x22 + x1708 * x21 + x1709 * x21 + x1710 * x21 + x2053 * x423,
            x1589 * x22 + x1715 * x21 + x1716 * x21 + x1717 * x21 + x2054 * x423,
            x1596 * x22 + x1721 * x21 + x1722 * x21 + x1723 * x21 + x2055 * x423,
            x1603 * x22 + x1727 * x21 + x1728 * x21 + x1729 * x21 + x2056 * x419,
            x1610 * x22 + x1733 * x21 + x1734 * x21 + x1735 * x21 + x2057 * x419,
            x1617 * x22 + x1740 * x21 + x1741 * x21 + x1742 * x21 + x2058 * x419,
            x1623 * x22 + x1746 * x21 + x1747 * x21 + x1748 * x21 + x2059 * x419,
            x1629 * x22 + x1752 * x21 + x1753 * x21 + x1754 * x21 + x2060 * x415,
            x1636 * x22 + x1758 * x21 + x1759 * x21 + x1760 * x21 + x2061 * x415,
            x1643 * x22 + x1764 * x21 + x1765 * x21 + x1766 * x21 + x2062 * x415,
            x1650 * x22 + x1771 * x21 + x1772 * x21 + x1773 * x21 + x2063 * x415,
            x1656 * x22 + x1777 * x21 + x1778 * x21 + x1779 * x21 + x2064 * x415,
            x1661 * x22
            + x1782 * x21
            + x1783 * x21
            + x1784 * x21
            + x55 * (x110 * x2060 + x1750 * x62),
            x1665 * x22
            + x1786 * x21
            + x1787 * x21
            + x1788 * x21
            + x55 * (x110 * x2061 + x1756 * x62),
            x1669 * x22
            + x1790 * x21
            + x1791 * x21
            + x1792 * x21
            + x55 * (x110 * x2062 + x1762 * x62),
            x1673 * x22
            + x1794 * x21
            + x1795 * x21
            + x1796 * x21
            + x55 * (x110 * x2063 + x1769 * x62),
            x1677 * x22
            + x1799 * x21
            + x1800 * x21
            + x1801 * x21
            + x55 * (x110 * x2064 + x1775 * x62),
            x1681 * x22
            + x1803 * x21
            + x1804 * x21
            + x1805 * x21
            + x55 * (x133 * x2064 + x1660),
            x1686 * x22 + x1687 * x22 + x1809 * x21 + x1810 * x21 + x2065 * x394,
            x1695 * x22 + x1696 * x22 + x1817 * x21 + x1818 * x21 + x2066 * x427,
            x1701 * x22 + x1702 * x22 + x1823 * x21 + x1824 * x21 + x2067 * x427,
            x1707 * x22 + x1708 * x22 + x1829 * x21 + x1830 * x21 + x2068 * x423,
            x1714 * x22 + x1715 * x22 + x1835 * x21 + x1836 * x21 + x2069 * x423,
            x1720 * x22 + x1721 * x22 + x1841 * x21 + x1842 * x21 + x2070 * x423,
            x1726 * x22 + x1727 * x22 + x1847 * x21 + x1848 * x21 + x2071 * x419,
            x1732 * x22 + x1733 * x22 + x1853 * x21 + x1854 * x21 + x2072 * x419,
            x1739 * x22 + x1740 * x22 + x1859 * x21 + x1860 * x21 + x2073 * x419,
            x1745 * x22 + x1746 * x22 + x1865 * x21 + x1866 * x21 + x2074 * x419,
            x1751 * x22 + x1752 * x22 + x1871 * x21 + x1872 * x21 + x2075 * x415,
            x1757 * x22 + x1758 * x22 + x1877 * x21 + x1878 * x21 + x2076 * x415,
            x1763 * x22 + x1764 * x22 + x1883 * x21 + x1884 * x21 + x2077 * x415,
            x1770 * x22 + x1771 * x22 + x1889 * x21 + x1890 * x21 + x2078 * x415,
            x1776 * x22 + x1777 * x22 + x1895 * x21 + x1896 * x21 + x2079 * x415,
            x1781 * x22
            + x1782 * x22
            + x1900 * x21
            + x1901 * x21
            + x55 * (x110 * x2075 + x1868 * x69),
            x1785 * x22
            + x1786 * x22
            + x1904 * x21
            + x1905 * x21
            + x55 * (x110 * x2076 + x1874 * x69),
            x1789 * x22
            + x1790 * x22
            + x1908 * x21
            + x1909 * x21
            + x55 * (x110 * x2077 + x1880 * x69),
            x1793 * x22
            + x1794 * x22
            + x1912 * x21
            + x1913 * x21
            + x55 * (x110 * x2078 + x1886 * x69),
            x1798 * x22
            + x1799 * x22
            + x1916 * x21
            + x1917 * x21
            + x55 * (x110 * x2079 + x1892 * x69),
            x1802 * x22
            + x1803 * x22
            + x1920 * x21
            + x1921 * x21
            + x55 * (x133 * x2079 + x1775 * x69),
            x1807 * x22 + x1808 * x22 + x1809 * x22 + x1926 * x21 + x2080 * x394,
            x1815 * x22 + x1816 * x22 + x1817 * x22 + x1934 * x21 + x2081 * x427,
            x1821 * x22 + x1822 * x22 + x1823 * x22 + x1941 * x21 + x2082 * x427,
            x1827 * x22 + x1828 * x22 + x1829 * x22 + x1947 * x21 + x2083 * x423,
            x1833 * x22 + x1834 * x22 + x1835 * x22 + x1952 * x21 + x2084 * x423,
            x1839 * x22 + x1840 * x22 + x1841 * x22 + x1959 * x21 + x2085 * x423,
            x1845 * x22 + x1846 * x22 + x1847 * x22 + x1965 * x21 + x2086 * x419,
            x1851 * x22 + x1852 * x22 + x1853 * x22 + x1970 * x21 + x2087 * x419,
            x1857 * x22 + x1858 * x22 + x1859 * x22 + x1976 * x21 + x2088 * x419,
            x1863 * x22 + x1864 * x22 + x1865 * x22 + x1982 * x21 + x2089 * x419,
            x1869 * x22 + x1870 * x22 + x1871 * x22 + x1988 * x21 + x2090 * x415,
            x1875 * x22 + x1876 * x22 + x1877 * x22 + x1993 * x21 + x2091 * x415,
            x1881 * x22 + x1882 * x22 + x1883 * x22 + x1998 * x21 + x2092 * x415,
            x1887 * x22 + x1888 * x22 + x1889 * x22 + x2003 * x21 + x2093 * x415,
            x1893 * x22 + x1894 * x22 + x1895 * x22 + x2009 * x21 + x2094 * x415,
            x1898 * x22
            + x1899 * x22
            + x1900 * x22
            + x2015 * x21
            + x55 * (x110 * x2090 + x1989),
            x1902 * x22
            + x1903 * x22
            + x1904 * x22
            + x2019 * x21
            + x55 * (x110 * x2091 + x1994),
            x1906 * x22
            + x1907 * x22
            + x1908 * x22
            + x2023 * x21
            + x55 * (x110 * x2092 + x1999),
            x1910 * x22
            + x1911 * x22
            + x1912 * x22
            + x2027 * x21
            + x55 * (x110 * x2093 + x2004),
            x1914 * x22
            + x1915 * x22
            + x1916 * x22
            + x2031 * x21
            + x55 * (x110 * x2094 + x2010),
            x1918 * x22
            + x1919 * x22
            + x1920 * x22
            + x2035 * x21
            + x55 * (x133 * x2094 + x1892 * x62),
            x1923 * x22 + x1924 * x22 + x1925 * x22 + x1926 * x22 + x2095 * x394,
            x1931 * x22 + x1932 * x22 + x1933 * x22 + x1934 * x22 + x2095 * x724,
            x1938 * x22 + x1939 * x22 + x1940 * x22 + x1941 * x22 + x2096 * x427,
            x1944 * x22 + x1945 * x22 + x1946 * x22 + x1947 * x22 + x2095 * x761,
            x1949 * x22 + x1950 * x22 + x1951 * x22 + x1952 * x22 + x2096 * x777,
            x1956 * x22 + x1957 * x22 + x1958 * x22 + x1959 * x22 + x2097 * x423,
            x1962 * x22 + x1963 * x22 + x1964 * x22 + x1965 * x22 + x2095 * x809,
            x1967 * x22 + x1968 * x22 + x1969 * x22 + x1970 * x22 + x2096 * x820,
            x123 * x2098 + x1973 * x22 + x1974 * x22 + x1975 * x22 + x1976 * x22,
            x1979 * x22 + x1980 * x22 + x1981 * x22 + x1982 * x22 + x2099 * x419,
            x1985 * x22 + x1986 * x22 + x1987 * x22 + x1988 * x22 + x2095 * x858,
            x1990 * x22 + x1991 * x22 + x1992 * x22 + x1993 * x22 + x2096 * x868,
            x159 * x2098 + x1995 * x22 + x1996 * x22 + x1997 * x22 + x1998 * x22,
            x2000 * x22 + x2001 * x22 + x2002 * x22 + x2003 * x22 + x2099 * x769,
            x2006 * x22 + x2007 * x22 + x2008 * x22 + x2009 * x22 + x2100 * x415,
            x2012 * x22 + x2013 * x22 + x2014 * x22 + x2015 * x22 + x2095 * x311,
            x2016 * x22 + x2017 * x22 + x2018 * x22 + x2019 * x22 + x2096 * x318,
            x2020 * x22 + x2021 * x22 + x2022 * x22 + x2023 * x22 + x2097 * x269,
            x2024 * x22 + x2025 * x22 + x2026 * x22 + x2027 * x22 + x2099 * x217,
            x168 * x2100 + x2028 * x22 + x2029 * x22 + x2030 * x22 + x2031 * x22,
            x2032 * x22
            + x2033 * x22
            + x2034 * x22
            + x2035 * x22
            + x55 * (x133 * x2100 + 4.0 * x2010),
        ]
    )


def _3center2el3d_sph_100(a, A, b, B, c, C):
    """Cartesian (ps|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = -x1 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x1 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = c * x0 * (x3**2 + x6**2 + x8**2) / x4
    x10 = 17.4934183276249
    x11 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = 2.0 * x1 * x10 * x11 * x4 ** (-1.5) * boys(1, x9)
    x13 = c ** (-1.0)
    x14 = x4 ** (-0.5)
    x15 = boys(0, x9)

    # 3 item(s)
    return numpy.array(
        [
            2.0 * x1 * x10 * x11 * x13 * x14 * x15 * (-x2 - A[0]) - x12 * x3,
            2.0 * x1 * x10 * x11 * x13 * x14 * x15 * (-x5 - A[1]) - x12 * x6,
            2.0 * x1 * x10 * x11 * x13 * x14 * x15 * (-x7 - A[2]) - x12 * x8,
        ]
    )


def _3center2el3d_sph_101(a, A, b, B, c, C):
    """Cartesian (ps|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = -x1 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x1 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = x0 / x4
    x10 = c * x9 * (x3**2 + x6**2 + x8**2)
    x11 = 17.4934183276249
    x12 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x13 = 2.0 * x1 * x11 * x12
    x14 = x13 * x4 ** (-1.5) * boys(2, x10)
    x15 = c ** (-1.0)
    x16 = x4 ** (-0.5)
    x17 = boys(1, x10)
    x18 = 2.0 * x1 * x11 * x12 * x15 * x16 * x17 * (-x2 - A[0]) - x14 * x3
    x19 = x13 * x15 * x16 * x17 / (2.0 * a + 2.0 * b)
    x20 = x18 * x9
    x21 = 2.0 * x1 * x11 * x12 * x15 * x16 * x17 * (-x5 - A[1]) - x14 * x6
    x22 = x21 * x9
    x23 = 2.0 * x1 * x11 * x12 * x15 * x16 * x17 * (-x7 - A[2]) - x14 * x8
    x24 = x23 * x9

    # 9 item(s)
    return numpy.array(
        [
            x9 * (x18 * x3 + x19),
            x20 * x6,
            x20 * x8,
            x22 * x3,
            x9 * (x19 + x21 * x6),
            x22 * x8,
            x24 * x3,
            x24 * x6,
            x9 * (x19 + x23 * x8),
        ]
    )


def _3center2el3d_sph_102(a, A, b, B, c, C):
    """Cartesian (ps|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = x3**2
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = x0 / x4
    x15 = c * x14 * (x10 + x13 + x7)
    x16 = 17.4934183276249
    x17 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x18 = 2.0 * x1 * x16 * x17
    x19 = x18 * boys(3, x15)
    x20 = c ** (-1.0)
    x21 = x4 ** (-0.5)
    x22 = boys(2, x15)
    x23 = 2.0 * x1 * x16 * x17 * x20 * x21 * x22 * (-x2 - A[0]) - x19 * x6
    x24 = x23 * x3
    x25 = (2.0 * a + 2.0 * b) ** (-1.0)
    x26 = x20 * x22
    x27 = x18 * x21 * x25 * x26
    x28 = 2.0 * x16 * x17 * x25 * x26
    x29 = x14 * x9
    x30 = x28 * x5
    x31 = x30 * x9
    x32 = x12 * x14
    x33 = x12 * x30
    x34 = x0**2 / x4**2
    x35 = x23 * x34
    x36 = x19 * x5
    x37 = 2.0 * x1 * x16 * x17 * x20 * x21 * x22 * (-x8 - A[1]) - x36 * x9
    x38 = x34 * x37
    x39 = x37 * x9
    x40 = x27 + x39
    x41 = x3 * x34
    x42 = 2.0 * x1 * x16 * x17 * x20 * x21 * x22 * (-x11 - A[2]) - x12 * x36
    x43 = x34 * x42
    x44 = x12 * x42 + x27

    # 18 item(s)
    return numpy.array(
        [
            x14 * (x14 * x3 * (x24 + x27) + x28 * x6),
            x14 * (x24 * x29 + x31),
            x14 * (x24 * x32 + x33),
            x10 * x35,
            x12 * x35 * x9,
            x13 * x35,
            x38 * x7,
            x40 * x41,
            x12 * x3 * x38,
            x14 * (x29 * x40 + x31),
            x14 * (x32 * x39 + x33),
            x13 * x38,
            x43 * x7,
            x41 * x42 * x9,
            x41 * x44,
            x10 * x43,
            x34 * x44 * x9,
            x14 * (x32 * x44 + x33),
        ]
    )


def _3center2el3d_sph_103(a, A, b, B, c, C):
    """Cartesian (ps|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = x3**2
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = x0 / x4
    x15 = c * x14 * (x10 + x13 + x7)
    x16 = 17.4934183276249
    x17 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x18 = 2.0 * x16 * x17
    x19 = x1 * x18
    x20 = x19 * boys(4, x15)
    x21 = c ** (-1.0)
    x22 = x4 ** (-0.5)
    x23 = boys(3, x15)
    x24 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x2 - A[0]) - x20 * x6
    x25 = x24 * x3
    x26 = (2.0 * a + 2.0 * b) ** (-1.0)
    x27 = x21 * x23
    x28 = x19 * x22 * x26 * x27
    x29 = x14 * x3
    x30 = x18 * x26 * x27
    x31 = x0 * x30 * x4 ** (-2.5)
    x32 = x14 * x9
    x33 = x30 * x5
    x34 = x33 * x9
    x35 = x3 * x9
    x36 = x12 * x14
    x37 = x12 * x33
    x38 = x12 * x31
    x39 = x0**2 / x4**2
    x40 = x25 * x39
    x41 = x10 * x31
    x42 = x39 * x9
    x43 = x38 * x9
    x44 = x13 * x31
    x45 = x9**3
    x46 = x0**3 / x4**3
    x47 = x24 * x46
    x48 = x12**3
    x49 = x3**3
    x50 = x20 * x5
    x51 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x8 - A[1]) - x50 * x9
    x52 = x46 * x51
    x53 = x51 * x9
    x54 = x28 + x53
    x55 = x46 * x7
    x56 = x32 * x54 + x34
    x57 = x3 * x39
    x58 = x36 * x53 + x37
    x59 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x11 - A[2]) - x12 * x50
    x60 = x46 * x59
    x61 = x12 * x59 + x28
    x62 = x46 * x61
    x63 = x36 * x61 + x37

    # 30 item(s)
    return numpy.array(
        [
            x14 * (x29 * (x29 * (x25 + x28) + x30 * x6) + x31 * x7),
            x14 * (x29 * (x25 * x32 + x34) + x31 * x35),
            x14 * (x29 * (x25 * x36 + x37) + x3 * x38),
            x14 * (x10 * x40 + x41),
            x14 * (x12 * x25 * x42 + x43),
            x14 * (x13 * x40 + x44),
            x45 * x47,
            x10 * x12 * x47,
            x13 * x47 * x9,
            x47 * x48,
            x49 * x52,
            x54 * x55,
            x12 * x52 * x7,
            x56 * x57,
            x57 * x58,
            x13 * x3 * x52,
            x14 * (x32 * x56 + x41),
            x14 * (x32 * x58 + x43),
            x14 * (x13 * x39 * x53 + x44),
            x48 * x52,
            x49 * x60,
            x55 * x59 * x9,
            x55 * x61,
            x10 * x3 * x60,
            x35 * x62,
            x57 * x63,
            x45 * x60,
            x10 * x62,
            x42 * x63,
            x14 * (x36 * x63 + x44),
        ]
    )


def _3center2el3d_sph_104(a, A, b, B, c, C):
    """Cartesian (ps|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = x3**2
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = x0 / x4
    x15 = c * x14 * (x10 + x13 + x7)
    x16 = 17.4934183276249
    x17 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x18 = 2.0 * x16 * x17
    x19 = x1 * x18
    x20 = x19 * boys(5, x15)
    x21 = c ** (-1.0)
    x22 = x4 ** (-0.5)
    x23 = boys(4, x15)
    x24 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x2 - A[0]) - x20 * x6
    x25 = x24 * x3
    x26 = (2.0 * a + 2.0 * b) ** (-1.0)
    x27 = x21 * x23
    x28 = x19 * x22 * x26 * x27
    x29 = x14 * x3
    x30 = x18 * x26 * x27
    x31 = x30 * x7
    x32 = x0 * x4 ** (-2.5)
    x33 = x3**3
    x34 = x0**2
    x35 = x34 * x4 ** (-3.5)
    x36 = x30 * x35
    x37 = x14 * x9
    x38 = x30 * x5
    x39 = x38 * x9
    x40 = x3 * x9
    x41 = x30 * x32
    x42 = x7 * x9
    x43 = x12 * x14
    x44 = x12 * x38
    x45 = x12 * x41
    x46 = x34 / x4**2
    x47 = x25 * x46
    x48 = x10 * x41
    x49 = x10 * x3
    x50 = x46 * x9
    x51 = x45 * x9
    x52 = x13 * x41
    x53 = x9**3
    x54 = x0**3 / x4**3
    x55 = x25 * x54
    x56 = x36 * x53
    x57 = x10 * x12
    x58 = x36 * x57
    x59 = x13 * x9
    x60 = x36 * x59
    x61 = x12**3
    x62 = x36 * x61
    x63 = x9**4
    x64 = x0**4 / x4**4
    x65 = x24 * x64
    x66 = x12**4
    x67 = x3**4
    x68 = x20 * x5
    x69 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x8 - A[1]) - x68 * x9
    x70 = x64 * x69
    x71 = x69 * x9
    x72 = x28 + x71
    x73 = x33 * x64
    x74 = x37 * x72 + x39
    x75 = x54 * x7
    x76 = x43 * x71 + x44
    x77 = x37 * x74 + x48
    x78 = x3 * x46
    x79 = x37 * x76 + x51
    x80 = x13 * x46 * x71 + x52
    x81 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x11 - A[2]) - x12 * x68
    x82 = x64 * x81
    x83 = x12 * x81 + x28
    x84 = x64 * x83
    x85 = x43 * x83 + x44
    x86 = x54 * x85
    x87 = x43 * x85 + x52

    # 45 item(s)
    return numpy.array(
        [
            x14 * (x29 * (x29 * (x29 * (x25 + x28) + x30 * x6) + x31 * x32) + x33 * x36),
            x14 * (x29 * (x29 * (x25 * x37 + x39) + x40 * x41) + x36 * x42),
            x14 * (x12 * x31 * x35 + x29 * (x29 * (x25 * x43 + x44) + x3 * x45)),
            x14 * (x29 * (x10 * x47 + x48) + x36 * x49),
            x14 * (x12 * x36 * x40 + x29 * (x12 * x25 * x50 + x51)),
            x14 * (x13 * x3 * x36 + x29 * (x13 * x47 + x52)),
            x14 * (x53 * x55 + x56),
            x14 * (x55 * x57 + x58),
            x14 * (x55 * x59 + x60),
            x14 * (x55 * x61 + x62),
            x63 * x65,
            x12 * x53 * x65,
            x10 * x13 * x65,
            x61 * x65 * x9,
            x65 * x66,
            x67 * x70,
            x72 * x73,
            x12 * x33 * x70,
            x74 * x75,
            x75 * x76,
            x13 * x7 * x70,
            x77 * x78,
            x78 * x79,
            x78 * x80,
            x3 * x61 * x70,
            x14 * (x37 * x77 + x56),
            x14 * (x37 * x79 + x58),
            x14 * (x37 * x80 + x60),
            x14 * (x54 * x61 * x71 + x62),
            x66 * x70,
            x67 * x82,
            x73 * x81 * x9,
            x73 * x83,
            x10 * x7 * x82,
            x42 * x84,
            x75 * x85,
            x3 * x53 * x82,
            x49 * x84,
            x40 * x86,
            x78 * x87,
            x63 * x82,
            x53 * x84,
            x10 * x86,
            x50 * x87,
            x14 * (x43 * x87 + x62),
        ]
    )


def _3center2el3d_sph_105(a, A, b, B, c, C):
    """Cartesian (ps|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = c + x0
    x5 = x4 ** (-1.5)
    x6 = x3 * x5
    x7 = x3**2
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x1 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = x0 / x4
    x15 = c * x14 * (x10 + x13 + x7)
    x16 = 17.4934183276249
    x17 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x18 = 2.0 * x16 * x17
    x19 = x1 * x18
    x20 = x19 * boys(6, x15)
    x21 = c ** (-1.0)
    x22 = x4 ** (-0.5)
    x23 = boys(5, x15)
    x24 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x2 - A[0]) - x20 * x6
    x25 = x24 * x3
    x26 = (2.0 * a + 2.0 * b) ** (-1.0)
    x27 = x21 * x23
    x28 = x19 * x22 * x26 * x27
    x29 = x14 * x3
    x30 = x18 * x26 * x27
    x31 = x30 * x7
    x32 = x0 * x4 ** (-2.5)
    x33 = x0**2
    x34 = x33 * x4 ** (-3.5)
    x35 = x3**3
    x36 = x30 * x35
    x37 = x3**4
    x38 = x0**3
    x39 = x38 * x4 ** (-4.5)
    x40 = x30 * x39
    x41 = x14 * x9
    x42 = x30 * x5
    x43 = x42 * x9
    x44 = x3 * x9
    x45 = x30 * x32
    x46 = x7 * x9
    x47 = x30 * x34
    x48 = x35 * x9
    x49 = x12 * x14
    x50 = x12 * x42
    x51 = x12 * x45
    x52 = x33 / x4**2
    x53 = x25 * x52
    x54 = x10 * x45
    x55 = x10 * x3
    x56 = x10 * x7
    x57 = x52 * x9
    x58 = x51 * x9
    x59 = x12 * x40
    x60 = x13 * x45
    x61 = x9**3
    x62 = x38 / x4**3
    x63 = x25 * x62
    x64 = x47 * x61
    x65 = x3 * x61
    x66 = x10 * x12
    x67 = x47 * x66
    x68 = x13 * x9
    x69 = x47 * x68
    x70 = x12**3
    x71 = x47 * x70
    x72 = x9**4
    x73 = x0**4 / x4**4
    x74 = x25 * x73
    x75 = x40 * x72
    x76 = x12 * x61
    x77 = x40 * x76
    x78 = x10 * x13
    x79 = x40 * x78
    x80 = x70 * x9
    x81 = x40 * x80
    x82 = x12**4
    x83 = x40 * x82
    x84 = x9**5
    x85 = x0**5 / x4**5
    x86 = x24 * x85
    x87 = x12**5
    x88 = x3**5
    x89 = x20 * x5
    x90 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x8 - A[1]) - x89 * x9
    x91 = x85 * x90
    x92 = x9 * x90
    x93 = x28 + x92
    x94 = x37 * x85
    x95 = x41 * x93 + x43
    x96 = x35 * x73
    x97 = x49 * x92 + x50
    x98 = x41 * x95 + x54
    x99 = x62 * x7
    x100 = x41 * x97 + x58
    x101 = x13 * x52 * x92 + x60
    x102 = x41 * x98 + x64
    x103 = x3 * x52
    x104 = x100 * x41 + x67
    x105 = x101 * x41 + x69
    x106 = x62 * x70 * x92 + x71
    x107 = 2.0 * x1 * x16 * x17 * x21 * x22 * x23 * (-x11 - A[2]) - x12 * x89
    x108 = x107 * x85
    x109 = x107 * x12 + x28
    x110 = x109 * x85
    x111 = x109 * x49 + x50
    x112 = x111 * x73
    x113 = x111 * x49 + x60
    x114 = x113 * x62
    x115 = x113 * x49 + x71

    # 63 item(s)
    return numpy.array(
        [
            x14
            * (
                x29
                * (x29 * (x29 * (x29 * (x25 + x28) + x30 * x6) + x31 * x32) + x34 * x36)
                + x37 * x40
            ),
            x14
            * (
                x29 * (x29 * (x29 * (x25 * x41 + x43) + x44 * x45) + x46 * x47)
                + x40 * x48
            ),
            x14
            * (
                x12 * x36 * x39
                + x29 * (x12 * x31 * x34 + x29 * (x29 * (x25 * x49 + x50) + x3 * x51))
            ),
            x14 * (x29 * (x29 * (x10 * x53 + x54) + x47 * x55) + x40 * x56),
            x14 * (x29 * (x12 * x44 * x47 + x29 * (x12 * x25 * x57 + x58)) + x46 * x59),
            x14 * (x13 * x31 * x39 + x29 * (x13 * x3 * x47 + x29 * (x13 * x53 + x60))),
            x14 * (x29 * (x61 * x63 + x64) + x40 * x65),
            x14 * (x29 * (x63 * x66 + x67) + x55 * x59),
            x14 * (x13 * x40 * x44 + x29 * (x63 * x68 + x69)),
            x14 * (x29 * (x63 * x70 + x71) + x3 * x40 * x70),
            x14 * (x72 * x74 + x75),
            x14 * (x74 * x76 + x77),
            x14 * (x74 * x78 + x79),
            x14 * (x74 * x80 + x81),
            x14 * (x74 * x82 + x83),
            x84 * x86,
            x12 * x72 * x86,
            x13 * x61 * x86,
            x10 * x70 * x86,
            x82 * x86 * x9,
            x86 * x87,
            x88 * x91,
            x93 * x94,
            x12 * x37 * x91,
            x95 * x96,
            x96 * x97,
            x13 * x35 * x91,
            x98 * x99,
            x100 * x99,
            x101 * x99,
            x7 * x70 * x91,
            x102 * x103,
            x103 * x104,
            x103 * x105,
            x103 * x106,
            x3 * x82 * x91,
            x14 * (x102 * x41 + x75),
            x14 * (x104 * x41 + x77),
            x14 * (x105 * x41 + x79),
            x14 * (x106 * x41 + x81),
            x14 * (x73 * x82 * x92 + x83),
            x87 * x91,
            x108 * x88,
            x107 * x9 * x94,
            x109 * x94,
            x10 * x108 * x35,
            x110 * x48,
            x111 * x96,
            x108 * x61 * x7,
            x110 * x56,
            x112 * x46,
            x113 * x99,
            x108 * x3 * x72,
            x110 * x65,
            x112 * x55,
            x114 * x44,
            x103 * x115,
            x108 * x84,
            x110 * x72,
            x112 * x61,
            x10 * x114,
            x115 * x57,
            x14 * (x115 * x49 + x83),
        ]
    )


def _3center2el3d_sph_110(a, A, b, B, c, C):
    """Cartesian (pp|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = c + x0
    x9 = c / x8
    x10 = x0 * x9 * (x3**2 + x5**2 + x7**2)
    x11 = boys(1, x10)
    x12 = 17.4934183276249
    x13 = A[0] - B[0]
    x14 = A[1] - B[1]
    x15 = A[2] - B[2]
    x16 = numpy.exp(-a * b * x1 * (x13**2 + x14**2 + x15**2))
    x17 = 2.0 * x1 * x12 * x16 * x8 ** (-1.5)
    x18 = x11 * x17
    x19 = c ** (-1.0)
    x20 = x8 ** (-0.5)
    x21 = boys(0, x10)
    x22 = (2.0 * x1 * x12 * x16 * x19 * x20 * x21 - x18) / (2.0 * a + 2.0 * b)
    x23 = -x2 - A[0]
    x24 = 2.0 * x1 * x12 * x16 * x19 * x20 * x21 * x23 - x18 * x3
    x25 = x17 * boys(2, x10)
    x26 = x3 * x9
    x27 = -x4 - A[1]
    x28 = 2.0 * x1 * x12 * x16 * x19 * x20 * x21 * x27 - x18 * x5
    x29 = 2.0 * x1 * x11 * x12 * x16 * x19 * x20 * x27 - x25 * x5
    x30 = x23 * x28 - x26 * x29
    x31 = -x6 - A[2]
    x32 = 2.0 * x1 * x12 * x16 * x19 * x20 * x21 * x31 - x18 * x7
    x33 = 2.0 * x1 * x11 * x12 * x16 * x19 * x20 * x31 - x25 * x7
    x34 = x23 * x32 - x26 * x33
    x35 = x5 * x9
    x36 = x27 * x32 - x33 * x35

    # 9 item(s)
    return numpy.array(
        [
            x13 * x24
            + x22
            + x23 * x24
            - x26 * (2.0 * x1 * x11 * x12 * x16 * x19 * x20 * x23 - x25 * x3),
            x14 * x24 + x30,
            x15 * x24 + x34,
            x13 * x28 + x30,
            x14 * x28 + x22 + x27 * x28 - x29 * x35,
            x15 * x28 + x36,
            x13 * x32 + x34,
            x14 * x32 + x36,
            x15 * x32 + x22 + x31 * x32 - x33 * x7 * x9,
        ]
    )


def _3center2el3d_sph_111(a, A, b, B, c, C):
    """Cartesian (pp|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x1 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x1 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = c + x0
    x10 = x9 ** (-1.0)
    x11 = x0 * x10
    x12 = c * x11 * (x3**2 + x6**2 + x8**2)
    x13 = boys(2, x12)
    x14 = 17.4934183276249
    x15 = A[0] - B[0]
    x16 = A[1] - B[1]
    x17 = A[2] - B[2]
    x18 = numpy.exp(-a * b * x1 * (x15**2 + x16**2 + x17**2))
    x19 = 2.0 * x1 * x14 * x18
    x20 = x19 * x9 ** (-1.5)
    x21 = x13 * x20
    x22 = c ** (-1.0)
    x23 = x9 ** (-0.5)
    x24 = boys(1, x12)
    x25 = x4 * (2.0 * x1 * x14 * x18 * x22 * x23 * x24 - x21)
    x26 = -x2 - A[0]
    x27 = 2.0 * x1 * x14 * x18 * x22 * x23 * x24 * x26 - x21 * x3
    x28 = x20 * boys(3, x12)
    x29 = c * x10
    x30 = x29 * x3
    x31 = (
        x25 + x26 * x27 - x30 * (2.0 * x1 * x13 * x14 * x18 * x22 * x23 * x26 - x28 * x3)
    )
    x32 = x27 * x4
    x33 = x19 * x22 * x23 * x24 * x4
    x34 = x11 * (x27 * x3 + x33)
    x35 = x11 * x31
    x36 = x11 * x6
    x37 = x15 * x27
    x38 = x11 * x8
    x39 = -x5 - A[1]
    x40 = 2.0 * x1 * x14 * x18 * x22 * x23 * x24 * x39 - x21 * x6
    x41 = x4 * x40
    x42 = 2.0 * x1 * x13 * x14 * x18 * x22 * x23 * x39 - x28 * x6
    x43 = x26 * x40 - x30 * x42
    x44 = x11 * (x3 * x43 + x41)
    x45 = x11 * (x32 + x43 * x6)
    x46 = x16 * x27
    x47 = x38 * x43
    x48 = -x7 - A[2]
    x49 = 2.0 * x1 * x14 * x18 * x22 * x23 * x24 * x48 - x21 * x8
    x50 = x4 * x49
    x51 = 2.0 * x1 * x13 * x14 * x18 * x22 * x23 * x48 - x28 * x8
    x52 = x26 * x49 - x30 * x51
    x53 = x11 * (x3 * x52 + x50)
    x54 = x36 * x52
    x55 = x17 * x27
    x56 = x11 * (x32 + x52 * x8)
    x57 = x11 * x3
    x58 = x15 * x40
    x59 = x11 * (x33 + x40 * x6)
    x60 = x29 * x6
    x61 = x25 + x39 * x40 - x42 * x60
    x62 = x16 * x40
    x63 = x39 * x49 - x51 * x60
    x64 = x57 * x63
    x65 = x17 * x40
    x66 = x11 * (x50 + x6 * x63)
    x67 = x11 * (x41 + x63 * x8)
    x68 = x15 * x49
    x69 = x11 * (x33 + x49 * x8)
    x70 = x16 * x49
    x71 = x25 - x29 * x51 * x8 + x48 * x49
    x72 = x17 * x49

    # 27 item(s)
    return numpy.array(
        [
            x11 * (x3 * x31 + 2.0 * x32) + x15 * x34,
            x35 * x6 + x36 * x37,
            x35 * x8 + x37 * x38,
            x16 * x34 + x44,
            x36 * x46 + x45,
            x38 * x46 + x47,
            x17 * x34 + x53,
            x36 * x55 + x54,
            x38 * x55 + x56,
            x44 + x57 * x58,
            x15 * x59 + x45,
            x38 * x58 + x47,
            x57 * x61 + x57 * x62,
            x11 * (2.0 * x41 + x6 * x61) + x16 * x59,
            x38 * x61 + x38 * x62,
            x57 * x65 + x64,
            x17 * x59 + x66,
            x38 * x65 + x67,
            x53 + x57 * x68,
            x36 * x68 + x54,
            x15 * x69 + x56,
            x57 * x70 + x64,
            x36 * x70 + x66,
            x16 * x69 + x67,
            x57 * x71 + x57 * x72,
            x36 * x71 + x36 * x72,
            x11 * (2.0 * x50 + x71 * x8) + x17 * x69,
        ]
    )


def _3center2el3d_sph_112(a, A, b, B, c, C):
    """Cartesian (pp|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = x3**2
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x0
    x13 = x12 ** (-1.0)
    x14 = x0 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(3, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[0] - B[0]
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x1 * (x19**2 + x20**2 + x21**2))
    x23 = 2.0 * x1 * x18 * x22
    x24 = x17 * x23
    x25 = x16 * x24
    x26 = c ** (-1.0)
    x27 = x12 ** (-0.5)
    x28 = boys(2, x15)
    x29 = x4 * (2.0 * x1 * x18 * x22 * x26 * x27 * x28 - x25)
    x30 = -x2 - A[0]
    x31 = 2.0 * x1 * x18 * x22 * x26 * x27 * x28 * x30 - x25 * x3
    x32 = x24 * boys(4, x15)
    x33 = c * x13
    x34 = x3 * x33
    x35 = (
        x29 + x30 * x31 - x34 * (2.0 * x1 * x16 * x18 * x22 * x26 * x27 * x30 - x3 * x32)
    )
    x36 = x3 * x35
    x37 = x31 * x4
    x38 = 2.0 * x37
    x39 = x14 * x3
    x40 = x3 * x31
    x41 = x26 * x28
    x42 = x23 * x27 * x4 * x41
    x43 = x40 + x42
    x44 = x14 * x4
    x45 = 2.0 * x17 * x18 * x22 * x4 * x41
    x46 = x3 * x45 + x39 * x43
    x47 = x14 * x19
    x48 = x14 * x7
    x49 = x45 * x7
    x50 = x40 * x48 + x49
    x51 = x10 * x14
    x52 = x10 * x45
    x53 = x40 * x51 + x52
    x54 = x0**2 / x12**2
    x55 = x35 * x54
    x56 = x54 * x8
    x57 = x19 * x31
    x58 = x54 * x7
    x59 = x10 * x58
    x60 = x11 * x54
    x61 = -x6 - A[1]
    x62 = 2.0 * x1 * x18 * x22 * x26 * x27 * x28 * x61 - x25 * x7
    x63 = x4 * x62
    x64 = 2.0 * x1 * x16 * x18 * x22 * x26 * x27 * x61 - x32 * x7
    x65 = x30 * x62 - x34 * x64
    x66 = x3 * x65
    x67 = x14 * (x39 * x63 + x39 * (x63 + x66))
    x68 = x14 * x20
    x69 = x62 * x7
    x70 = x42 + x69
    x71 = x44 * x70
    x72 = x65 * x7
    x73 = x37 + x72
    x74 = x14 * (x39 * x73 + x71)
    x75 = x51 * x63
    x76 = x14 * (x51 * x66 + x75)
    x77 = x14 * (x37 * x48 + x48 * x73)
    x78 = x20 * x31
    x79 = x37 * x51
    x80 = x14 * (x51 * x72 + x79)
    x81 = x60 * x65
    x82 = -x9 - A[2]
    x83 = 2.0 * x1 * x18 * x22 * x26 * x27 * x28 * x82 - x10 * x25
    x84 = x4 * x83
    x85 = 2.0 * x1 * x16 * x18 * x22 * x26 * x27 * x82 - x10 * x32
    x86 = x30 * x83 - x34 * x85
    x87 = x3 * x86
    x88 = x14 * (x39 * x84 + x39 * (x84 + x87))
    x89 = x14 * x21
    x90 = x48 * x84
    x91 = x14 * (x48 * x87 + x90)
    x92 = x10 * x83 + x42
    x93 = x44 * x92
    x94 = x10 * x86 + x37
    x95 = x14 * (x39 * x94 + x93)
    x96 = x56 * x86
    x97 = x21 * x31
    x98 = x58 * x94
    x99 = x14 * (x51 * x94 + x79)
    x100 = x5 * x54
    x101 = x19 * x62
    x102 = x3 * x54
    x103 = x102 * x70
    x104 = x10 * x102
    x105 = x48 * x70 + x49
    x106 = x51 * x69 + x52
    x107 = x33 * x7
    x108 = -x107 * x64 + x29 + x61 * x62
    x109 = x20 * x62
    x110 = x108 * x7
    x111 = 2.0 * x63
    x112 = x110 + x111
    x113 = -x107 * x85 + x61 * x83
    x114 = x100 * x113
    x115 = x21 * x62
    x116 = x113 * x7 + x84
    x117 = x102 * x116
    x118 = x10 * x113 + x63
    x119 = x102 * x118
    x120 = x14 * (x116 * x48 + x90)
    x121 = x14 * (x118 * x48 + x93)
    x122 = x14 * (x118 * x51 + x75)
    x123 = x19 * x83
    x124 = x3 * x58
    x125 = x19 * x92
    x126 = x51 * x92 + x52
    x127 = x20 * x83
    x128 = x20 * x92
    x129 = -x10 * x33 * x85 + x29 + x82 * x83
    x130 = x21 * x83
    x131 = x10 * x129 + 2.0 * x84
    x132 = x21 * x92

    # 54 item(s)
    return numpy.array(
        [
            x14 * (x39 * (x36 + x38) + 2.0 * x43 * x44) + x46 * x47,
            x14 * (x36 * x48 + x38 * x48) + x47 * x50,
            x14 * (x36 * x51 + x38 * x51) + x47 * x53,
            x55 * x8 + x56 * x57,
            x10 * x55 * x7 + x57 * x59,
            x11 * x55 + x57 * x60,
            x46 * x68 + x67,
            x50 * x68 + x74,
            x53 * x68 + x76,
            x56 * x78 + x77,
            x59 * x78 + x80,
            x60 * x78 + x81,
            x46 * x89 + x88,
            x50 * x89 + x91,
            x53 * x89 + x95,
            x56 * x97 + x96,
            x59 * x97 + x98,
            x60 * x97 + x99,
            x100 * x101 + x67,
            x103 * x19 + x74,
            x101 * x104 + x76,
            x105 * x47 + x77,
            x106 * x47 + x80,
            x101 * x60 + x81,
            x100 * x108 + x100 * x109,
            x102 * x112 + x103 * x20,
            x104 * x108 + x104 * x109,
            x105 * x68 + x14 * (x112 * x48 + 2.0 * x71),
            x106 * x68 + x14 * (x110 * x51 + x111 * x51),
            x108 * x60 + x109 * x60,
            x100 * x115 + x114,
            x103 * x21 + x117,
            x104 * x115 + x119,
            x105 * x89 + x120,
            x106 * x89 + x121,
            x115 * x60 + x122,
            x100 * x123 + x88,
            x123 * x124 + x91,
            x102 * x125 + x95,
            x123 * x56 + x96,
            x125 * x58 + x98,
            x126 * x47 + x99,
            x100 * x127 + x114,
            x117 + x124 * x127,
            x102 * x128 + x119,
            x120 + x127 * x56,
            x121 + x128 * x58,
            x122 + x126 * x68,
            x100 * x129 + x100 * x130,
            x124 * x129 + x124 * x130,
            x102 * x131 + x102 * x132,
            x129 * x56 + x130 * x56,
            x131 * x58 + x132 * x58,
            x126 * x89 + x14 * (x131 * x51 + 2.0 * x93),
        ]
    )


def _3center2el3d_sph_113(a, A, b, B, c, C):
    """Cartesian (pp|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = x3**2
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x0
    x13 = x12 ** (-1.0)
    x14 = x0 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(4, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[0] - B[0]
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x1 * (x19**2 + x20**2 + x21**2))
    x23 = 2.0 * x18 * x22
    x24 = x1 * x23
    x25 = x17 * x24
    x26 = x16 * x25
    x27 = c ** (-1.0)
    x28 = x12 ** (-0.5)
    x29 = boys(3, x15)
    x30 = x4 * (2.0 * x1 * x18 * x22 * x27 * x28 * x29 - x26)
    x31 = -x2 - A[0]
    x32 = 2.0 * x1 * x18 * x22 * x27 * x28 * x29 * x31 - x26 * x3
    x33 = x25 * boys(5, x15)
    x34 = c * x13
    x35 = x3 * x34
    x36 = (
        x30 + x31 * x32 - x35 * (2.0 * x1 * x16 * x18 * x22 * x27 * x28 * x31 - x3 * x33)
    )
    x37 = x3 * x36
    x38 = x32 * x4
    x39 = 2.0 * x38
    x40 = x14 * x3
    x41 = x3 * x32
    x42 = x27 * x29
    x43 = x24 * x28 * x4 * x42
    x44 = x41 + x43
    x45 = x14 * x4
    x46 = 2.0 * x45
    x47 = x23 * x4 * x42
    x48 = x17 * x47
    x49 = x3 * x48 + x40 * x44
    x50 = x0 * x12 ** (-2.5) * x47
    x51 = x40 * x49 + x5 * x50
    x52 = x14 * x19
    x53 = x14 * x7
    x54 = x48 * x7
    x55 = x41 * x53 + x54
    x56 = x3 * x50
    x57 = x40 * x55 + x56 * x7
    x58 = x10 * x14
    x59 = x10 * x48
    x60 = x41 * x58 + x59
    x61 = x10 * x56 + x40 * x60
    x62 = x0**2 / x12**2
    x63 = x62 * x8
    x64 = x50 * x8
    x65 = x41 * x63 + x64
    x66 = x62 * x7
    x67 = x10 * x66
    x68 = x10 * x50 * x7
    x69 = x41 * x67 + x68
    x70 = x11 * x62
    x71 = x11 * x50
    x72 = x41 * x70 + x71
    x73 = x7**3
    x74 = x0**3 / x12**3
    x75 = x36 * x74
    x76 = x73 * x74
    x77 = x19 * x32
    x78 = x74 * x8
    x79 = x10 * x78
    x80 = x11 * x7
    x81 = x74 * x80
    x82 = x10**3
    x83 = x74 * x82
    x84 = -x6 - A[1]
    x85 = 2.0 * x1 * x18 * x22 * x27 * x28 * x29 * x84 - x26 * x7
    x86 = x4 * x85
    x87 = 2.0 * x1 * x16 * x18 * x22 * x27 * x28 * x84 - x33 * x7
    x88 = x31 * x85 - x35 * x87
    x89 = x3 * x88
    x90 = x5 * x62
    x91 = x14 * (x40 * (x40 * x86 + x40 * (x86 + x89)) + x86 * x90)
    x92 = x14 * x20
    x93 = x7 * x85
    x94 = x43 + x93
    x95 = x14 * x94
    x96 = x4 * x95
    x97 = x7 * x88
    x98 = x38 + x97
    x99 = x3 * x62
    x100 = x4 * x99
    x101 = x14 * (x100 * x94 + x40 * (x40 * x98 + x96))
    x102 = x58 * x86
    x103 = x14 * (x10 * x86 * x99 + x40 * (x102 + x58 * x89))
    x104 = x54 + x7 * x95
    x105 = x104 * x45
    x106 = x38 * x53 + x53 * x98
    x107 = x14 * (x105 + x106 * x40)
    x108 = x58 * x93 + x59
    x109 = x108 * x45
    x110 = x38 * x58
    x111 = x110 + x58 * x97
    x112 = x14 * (x109 + x111 * x40)
    x113 = x70 * x86
    x114 = x14 * (x113 + x70 * x89)
    x115 = x14 * (x106 * x53 + x38 * x63)
    x116 = x20 * x32
    x117 = x14 * (x111 * x53 + x38 * x67)
    x118 = x38 * x70
    x119 = x14 * (x118 + x70 * x97)
    x120 = x83 * x88
    x121 = -x9 - A[2]
    x122 = 2.0 * x1 * x121 * x18 * x22 * x27 * x28 * x29 - x10 * x26
    x123 = x122 * x4
    x124 = 2.0 * x1 * x121 * x16 * x18 * x22 * x27 * x28 - x10 * x33
    x125 = x122 * x31 - x124 * x35
    x126 = x125 * x3
    x127 = x14 * (x123 * x90 + x40 * (x123 * x40 + x40 * (x123 + x126)))
    x128 = x14 * x21
    x129 = x123 * x53
    x130 = x3 * x66
    x131 = x14 * (x123 * x130 + x40 * (x126 * x53 + x129))
    x132 = x10 * x122 + x43
    x133 = x132 * x45
    x134 = x10 * x125 + x38
    x135 = x14 * (x100 * x132 + x40 * (x133 + x134 * x40))
    x136 = x123 * x63
    x137 = x14 * (x126 * x63 + x136)
    x138 = x132 * x4 * x66
    x139 = x14 * (x130 * x134 + x138)
    x140 = x132 * x58 + x59
    x141 = x140 * x45
    x142 = x110 + x134 * x58
    x143 = x14 * (x141 + x142 * x40)
    x144 = x125 * x76
    x145 = x21 * x32
    x146 = x134 * x78
    x147 = x142 * x66
    x148 = x14 * (x118 + x142 * x58)
    x149 = x3**3 * x74
    x150 = x19 * x85
    x151 = x5 * x74
    x152 = x151 * x94
    x153 = x10 * x151
    x154 = x19 * x99
    x155 = x3 * x74
    x156 = x11 * x155
    x157 = x104 * x53 + x64
    x158 = x108 * x53 + x68
    x159 = x70 * x93 + x71
    x160 = x34 * x7
    x161 = -x160 * x87 + x30 + x84 * x85
    x162 = x20 * x85
    x163 = x161 * x7
    x164 = 2.0 * x86
    x165 = x163 + x164
    x166 = x165 * x53 + 2.0 * x96
    x167 = x20 * x99
    x168 = x163 * x58 + x164 * x58
    x169 = x122 * x84 - x124 * x160
    x170 = x149 * x169
    x171 = x21 * x85
    x172 = x123 + x169 * x7
    x173 = x151 * x172
    x174 = x10 * x169 + x86
    x175 = x151 * x174
    x176 = x129 + x172 * x53
    x177 = x176 * x99
    x178 = x21 * x99
    x179 = x133 + x174 * x53
    x180 = x179 * x99
    x181 = x102 + x174 * x58
    x182 = x181 * x99
    x183 = x14 * (x136 + x176 * x53)
    x184 = x14 * (x138 + x179 * x53)
    x185 = x14 * (x141 + x181 * x53)
    x186 = x14 * (x113 + x181 * x58)
    x187 = x122 * x19
    x188 = x151 * x7
    x189 = x132 * x19
    x190 = x3 * x78
    x191 = x155 * x7
    x192 = x140 * x66
    x193 = x140 * x58 + x71
    x194 = x122 * x20
    x195 = x132 * x20
    x196 = -x10 * x124 * x34 + x121 * x122 + x30
    x197 = x122 * x21
    x198 = x10 * x196 + 2.0 * x123
    x199 = x132 * x21
    x200 = 2.0 * x133 + x198 * x58

    # 90 item(s)
    return numpy.array(
        [
            x14 * (x40 * (x40 * (x37 + x39) + x44 * x46) + x46 * x49) + x51 * x52,
            x14 * (x40 * (x37 * x53 + x39 * x53) + x46 * x55) + x52 * x57,
            x14 * (x40 * (x37 * x58 + x39 * x58) + x46 * x60) + x52 * x61,
            x14 * (x37 * x63 + x39 * x63) + x52 * x65,
            x14 * (x37 * x67 + x39 * x67) + x52 * x69,
            x14 * (x37 * x70 + x39 * x70) + x52 * x72,
            x73 * x75 + x76 * x77,
            x10 * x75 * x8 + x77 * x79,
            x75 * x80 + x77 * x81,
            x75 * x82 + x77 * x83,
            x51 * x92 + x91,
            x101 + x57 * x92,
            x103 + x61 * x92,
            x107 + x65 * x92,
            x112 + x69 * x92,
            x114 + x72 * x92,
            x115 + x116 * x76,
            x116 * x79 + x117,
            x116 * x81 + x119,
            x116 * x83 + x120,
            x127 + x128 * x51,
            x128 * x57 + x131,
            x128 * x61 + x135,
            x128 * x65 + x137,
            x128 * x69 + x139,
            x128 * x72 + x143,
            x144 + x145 * x76,
            x145 * x79 + x146,
            x145 * x81 + x147,
            x145 * x83 + x148,
            x149 * x150 + x91,
            x101 + x152 * x19,
            x103 + x150 * x153,
            x104 * x154 + x107,
            x108 * x154 + x112,
            x114 + x150 * x156,
            x115 + x157 * x52,
            x117 + x158 * x52,
            x119 + x159 * x52,
            x120 + x150 * x83,
            x149 * x161 + x149 * x162,
            x151 * x165 + x152 * x20,
            x153 * x161 + x153 * x162,
            x104 * x167 + x166 * x99,
            x108 * x167 + x168 * x99,
            x156 * x161 + x156 * x162,
            x14 * (2.0 * x105 + x166 * x53) + x157 * x92,
            x14 * (2.0 * x109 + x168 * x53) + x158 * x92,
            x14 * (x163 * x70 + x164 * x70) + x159 * x92,
            x161 * x83 + x162 * x83,
            x149 * x171 + x170,
            x152 * x21 + x173,
            x153 * x171 + x175,
            x104 * x178 + x177,
            x108 * x178 + x180,
            x156 * x171 + x182,
            x128 * x157 + x183,
            x128 * x158 + x184,
            x128 * x159 + x185,
            x171 * x83 + x186,
            x127 + x149 * x187,
            x131 + x187 * x188,
            x135 + x151 * x189,
            x137 + x187 * x190,
            x139 + x189 * x191,
            x140 * x154 + x143,
            x144 + x187 * x76,
            x146 + x189 * x78,
            x147 + x19 * x192,
            x148 + x193 * x52,
            x149 * x194 + x170,
            x173 + x188 * x194,
            x151 * x195 + x175,
            x177 + x190 * x194,
            x180 + x191 * x195,
            x140 * x167 + x182,
            x183 + x194 * x76,
            x184 + x195 * x78,
            x185 + x192 * x20,
            x186 + x193 * x92,
            x149 * x196 + x149 * x197,
            x188 * x196 + x188 * x197,
            x151 * x198 + x151 * x199,
            x190 * x196 + x190 * x197,
            x191 * x198 + x191 * x199,
            x140 * x178 + x200 * x99,
            x196 * x76 + x197 * x76,
            x198 * x78 + x199 * x78,
            x192 * x21 + x200 * x66,
            x128 * x193 + x14 * (2.0 * x141 + x200 * x58),
        ]
    )


def _3center2el3d_sph_114(a, A, b, B, c, C):
    """Cartesian (pp|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = x3**2
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x0
    x13 = x12 ** (-1.0)
    x14 = x0 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(5, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[0] - B[0]
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x1 * (x19**2 + x20**2 + x21**2))
    x23 = 2.0 * x18 * x22
    x24 = x1 * x23
    x25 = x17 * x24
    x26 = x16 * x25
    x27 = c ** (-1.0)
    x28 = x12 ** (-0.5)
    x29 = boys(4, x15)
    x30 = x4 * (2.0 * x1 * x18 * x22 * x27 * x28 * x29 - x26)
    x31 = -x2 - A[0]
    x32 = 2.0 * x1 * x18 * x22 * x27 * x28 * x29 * x31 - x26 * x3
    x33 = x25 * boys(6, x15)
    x34 = c * x13
    x35 = x3 * x34
    x36 = (
        x30 + x31 * x32 - x35 * (2.0 * x1 * x16 * x18 * x22 * x27 * x28 * x31 - x3 * x33)
    )
    x37 = x3 * x36
    x38 = x32 * x4
    x39 = 2.0 * x38
    x40 = x14 * x3
    x41 = x3 * x32
    x42 = x27 * x29
    x43 = x24 * x28 * x4 * x42
    x44 = x41 + x43
    x45 = x14 * x4
    x46 = 2.0 * x45
    x47 = x23 * x4 * x42
    x48 = x17 * x47
    x49 = x3 * x48 + x40 * x44
    x50 = x47 * x5
    x51 = x0 * x12 ** (-2.5)
    x52 = x40 * x49 + x50 * x51
    x53 = x3**3
    x54 = x0**2
    x55 = x12 ** (-3.5) * x54
    x56 = x47 * x55
    x57 = x40 * x52 + x53 * x56
    x58 = x14 * x19
    x59 = x14 * x7
    x60 = x48 * x7
    x61 = x41 * x59 + x60
    x62 = x47 * x51
    x63 = x3 * x62
    x64 = x40 * x61 + x63 * x7
    x65 = x50 * x55
    x66 = x40 * x64 + x65 * x7
    x67 = x10 * x14
    x68 = x10 * x48
    x69 = x41 * x67 + x68
    x70 = x10 * x63 + x40 * x69
    x71 = x10 * x65 + x40 * x70
    x72 = x54 / x12**2
    x73 = x72 * x8
    x74 = x62 * x8
    x75 = x41 * x73 + x74
    x76 = x3 * x8
    x77 = x40 * x75 + x56 * x76
    x78 = x7 * x72
    x79 = x10 * x78
    x80 = x10 * x7
    x81 = x62 * x80
    x82 = x41 * x79 + x81
    x83 = x3 * x56 * x80 + x40 * x82
    x84 = x11 * x72
    x85 = x11 * x62
    x86 = x41 * x84 + x85
    x87 = x11 * x3
    x88 = x40 * x86 + x56 * x87
    x89 = x7**3
    x90 = x0**3 / x12**3
    x91 = x89 * x90
    x92 = x56 * x89
    x93 = x41 * x91 + x92
    x94 = x8 * x90
    x95 = x10 * x94
    x96 = x10 * x56 * x8
    x97 = x41 * x95 + x96
    x98 = x7 * x90
    x99 = x11 * x98
    x100 = x11 * x56 * x7
    x101 = x100 + x41 * x99
    x102 = x10**3
    x103 = x102 * x90
    x104 = x102 * x56
    x105 = x103 * x41 + x104
    x106 = x7**4
    x107 = x0**4 / x12**4
    x108 = x107 * x36
    x109 = x106 * x107
    x110 = x19 * x32
    x111 = x107 * x89
    x112 = x10 * x111
    x113 = x11 * x8
    x114 = x107 * x110
    x115 = x102 * x7
    x116 = x10**4
    x117 = x107 * x116
    x118 = -x6 - A[1]
    x119 = 2.0 * x1 * x118 * x18 * x22 * x27 * x28 * x29 - x26 * x7
    x120 = x119 * x4
    x121 = 2.0 * x1 * x118 * x16 * x18 * x22 * x27 * x28 - x33 * x7
    x122 = x119 * x31 - x121 * x35
    x123 = x122 * x3
    x124 = x5 * x72
    x125 = x53 * x90
    x126 = x14 * (
        x120 * x125 + x40 * (x120 * x124 + x40 * (x120 * x40 + x40 * (x120 + x123)))
    )
    x127 = x14 * x20
    x128 = x119 * x7
    x129 = x128 + x43
    x130 = x129 * x14
    x131 = x130 * x4
    x132 = x122 * x7
    x133 = x132 + x38
    x134 = x3 * x72
    x135 = x129 * x4
    x136 = x5 * x90
    x137 = x14 * (x135 * x136 + x40 * (x134 * x135 + x40 * (x131 + x133 * x40)))
    x138 = x120 * x67
    x139 = x10 * x120
    x140 = x14 * (x136 * x139 + x40 * (x134 * x139 + x40 * (x123 * x67 + x138)))
    x141 = x130 * x7 + x60
    x142 = x141 * x45
    x143 = x133 * x59 + x38 * x59
    x144 = x134 * x4
    x145 = x14 * (x141 * x144 + x40 * (x142 + x143 * x40))
    x146 = x128 * x67 + x68
    x147 = x146 * x45
    x148 = x38 * x67
    x149 = x132 * x67 + x148
    x150 = x14 * (x144 * x146 + x40 * (x147 + x149 * x40))
    x151 = x120 * x84
    x152 = x14 * (x120 * x87 * x90 + x40 * (x123 * x84 + x151))
    x153 = x141 * x59 + x74
    x154 = x153 * x45
    x155 = x143 * x59 + x38 * x73
    x156 = x14 * (x154 + x155 * x40)
    x157 = x146 * x59 + x81
    x158 = x157 * x45
    x159 = x149 * x59 + x38 * x79
    x160 = x14 * (x158 + x159 * x40)
    x161 = x128 * x84 + x85
    x162 = x161 * x45
    x163 = x38 * x84
    x164 = x132 * x84 + x163
    x165 = x14 * (x162 + x164 * x40)
    x166 = x103 * x120
    x167 = x14 * (x103 * x123 + x166)
    x168 = x14 * (x155 * x59 + x38 * x91)
    x169 = x20 * x32
    x170 = x14 * (x159 * x59 + x38 * x95)
    x171 = x14 * (x164 * x59 + x38 * x99)
    x172 = x107 * x169
    x173 = x103 * x38
    x174 = x14 * (x103 * x132 + x173)
    x175 = x117 * x122
    x176 = -x9 - A[2]
    x177 = 2.0 * x1 * x176 * x18 * x22 * x27 * x28 * x29 - x10 * x26
    x178 = x177 * x4
    x179 = 2.0 * x1 * x16 * x176 * x18 * x22 * x27 * x28 - x10 * x33
    x180 = x177 * x31 - x179 * x35
    x181 = x180 * x3
    x182 = x14 * (
        x125 * x178 + x40 * (x124 * x178 + x40 * (x178 * x40 + x40 * (x178 + x181)))
    )
    x183 = x14 * x21
    x184 = x178 * x59
    x185 = x3 * x78
    x186 = x14 * (x136 * x178 * x7 + x40 * (x178 * x185 + x40 * (x181 * x59 + x184)))
    x187 = x10 * x177 + x43
    x188 = x187 * x45
    x189 = x10 * x180 + x38
    x190 = x187 * x4
    x191 = x14 * (x136 * x190 + x40 * (x144 * x187 + x40 * (x188 + x189 * x40)))
    x192 = x178 * x73
    x193 = x14 * (x178 * x3 * x94 + x40 * (x181 * x73 + x192))
    x194 = x190 * x78
    x195 = x189 * x3
    x196 = x3 * x98
    x197 = x14 * (x190 * x196 + x40 * (x194 + x195 * x78))
    x198 = x187 * x67 + x68
    x199 = x198 * x45
    x200 = x148 + x189 * x67
    x201 = x14 * (x144 * x198 + x40 * (x199 + x200 * x40))
    x202 = x178 * x91
    x203 = x14 * (x181 * x91 + x202)
    x204 = x190 * x94
    x205 = x14 * (x195 * x94 + x204)
    x206 = x198 * x4 * x78
    x207 = x14 * (x185 * x200 + x206)
    x208 = x198 * x67 + x85
    x209 = x208 * x45
    x210 = x163 + x200 * x67
    x211 = x14 * (x209 + x210 * x40)
    x212 = x109 * x180
    x213 = x21 * x32
    x214 = x111 * x189
    x215 = x200 * x94
    x216 = x107 * x213
    x217 = x210 * x78
    x218 = x14 * (x173 + x210 * x67)
    x219 = x107 * x3**4
    x220 = x119 * x19
    x221 = x107 * x53
    x222 = x129 * x221
    x223 = x10 * x221
    x224 = x136 * x19
    x225 = x11 * x5
    x226 = x107 * x220
    x227 = x134 * x19
    x228 = x102 * x3
    x229 = x153 * x59 + x92
    x230 = x157 * x59 + x96
    x231 = x100 + x161 * x59
    x232 = x103 * x128 + x104
    x233 = x34 * x7
    x234 = x118 * x119 - x121 * x233 + x30
    x235 = x119 * x20
    x236 = x234 * x7
    x237 = 2.0 * x120
    x238 = x236 + x237
    x239 = 2.0 * x131 + x238 * x59
    x240 = x136 * x20
    x241 = x236 * x67 + x237 * x67
    x242 = x107 * x234
    x243 = x107 * x235
    x244 = 2.0 * x142 + x239 * x59
    x245 = x134 * x20
    x246 = 2.0 * x147 + x241 * x59
    x247 = x236 * x84 + x237 * x84
    x248 = x118 * x177 - x179 * x233
    x249 = x219 * x248
    x250 = x119 * x21
    x251 = x178 + x248 * x7
    x252 = x221 * x251
    x253 = x10 * x248 + x120
    x254 = x221 * x253
    x255 = x184 + x251 * x59
    x256 = x136 * x255
    x257 = x136 * x21
    x258 = x188 + x253 * x59
    x259 = x136 * x258
    x260 = x138 + x253 * x67
    x261 = x136 * x260
    x262 = x107 * x250
    x263 = x192 + x255 * x59
    x264 = x134 * x263
    x265 = x134 * x21
    x266 = x194 + x258 * x59
    x267 = x134 * x266
    x268 = x199 + x260 * x59
    x269 = x134 * x268
    x270 = x151 + x260 * x67
    x271 = x134 * x270
    x272 = x14 * (x202 + x263 * x59)
    x273 = x14 * (x204 + x266 * x59)
    x274 = x14 * (x206 + x268 * x59)
    x275 = x14 * (x209 + x270 * x59)
    x276 = x14 * (x166 + x270 * x67)
    x277 = x177 * x19
    x278 = x221 * x7
    x279 = x187 * x19
    x280 = x107 * x5
    x281 = x280 * x8
    x282 = x280 * x7
    x283 = x111 * x3
    x284 = x107 * x76
    x285 = x196 * x198
    x286 = x198 * x94
    x287 = x208 * x78
    x288 = x104 + x208 * x67
    x289 = x177 * x20
    x290 = x187 * x20
    x291 = -x10 * x179 * x34 + x176 * x177 + x30
    x292 = x177 * x21
    x293 = x10 * x291 + 2.0 * x178
    x294 = x187 * x21
    x295 = 2.0 * x188 + x293 * x67
    x296 = 2.0 * x199 + x295 * x67

    # 135 item(s)
    return numpy.array(
        [
            x14 * (x40 * (x40 * (x40 * (x37 + x39) + x44 * x46) + x46 * x49) + x46 * x52)
            + x57 * x58,
            x14 * (x40 * (x40 * (x37 * x59 + x39 * x59) + x46 * x61) + x46 * x64)
            + x58 * x66,
            x14 * (x40 * (x40 * (x37 * x67 + x39 * x67) + x46 * x69) + x46 * x70)
            + x58 * x71,
            x14 * (x40 * (x37 * x73 + x39 * x73) + x46 * x75) + x58 * x77,
            x14 * (x40 * (x37 * x79 + x39 * x79) + x46 * x82) + x58 * x83,
            x14 * (x40 * (x37 * x84 + x39 * x84) + x46 * x86) + x58 * x88,
            x14 * (x37 * x91 + x39 * x91) + x58 * x93,
            x14 * (x37 * x95 + x39 * x95) + x58 * x97,
            x101 * x58 + x14 * (x37 * x99 + x39 * x99),
            x105 * x58 + x14 * (x103 * x37 + x103 * x39),
            x106 * x108 + x109 * x110,
            x10 * x108 * x89 + x110 * x112,
            x108 * x113 + x113 * x114,
            x108 * x115 + x114 * x115,
            x108 * x116 + x110 * x117,
            x126 + x127 * x57,
            x127 * x66 + x137,
            x127 * x71 + x140,
            x127 * x77 + x145,
            x127 * x83 + x150,
            x127 * x88 + x152,
            x127 * x93 + x156,
            x127 * x97 + x160,
            x101 * x127 + x165,
            x105 * x127 + x167,
            x109 * x169 + x168,
            x112 * x169 + x170,
            x113 * x172 + x171,
            x115 * x172 + x174,
            x117 * x169 + x175,
            x182 + x183 * x57,
            x183 * x66 + x186,
            x183 * x71 + x191,
            x183 * x77 + x193,
            x183 * x83 + x197,
            x183 * x88 + x201,
            x183 * x93 + x203,
            x183 * x97 + x205,
            x101 * x183 + x207,
            x105 * x183 + x211,
            x109 * x213 + x212,
            x112 * x213 + x214,
            x113 * x216 + x215,
            x115 * x216 + x217,
            x117 * x213 + x218,
            x126 + x219 * x220,
            x137 + x19 * x222,
            x140 + x220 * x223,
            x141 * x224 + x145,
            x146 * x224 + x150,
            x152 + x225 * x226,
            x153 * x227 + x156,
            x157 * x227 + x160,
            x161 * x227 + x165,
            x167 + x226 * x228,
            x168 + x229 * x58,
            x170 + x230 * x58,
            x171 + x231 * x58,
            x174 + x232 * x58,
            x117 * x220 + x175,
            x219 * x234 + x219 * x235,
            x20 * x222 + x221 * x238,
            x223 * x234 + x223 * x235,
            x136 * x239 + x141 * x240,
            x136 * x241 + x146 * x240,
            x225 * x242 + x225 * x243,
            x134 * x244 + x153 * x245,
            x134 * x246 + x157 * x245,
            x134 * x247 + x161 * x245,
            x228 * x242 + x228 * x243,
            x127 * x229 + x14 * (2.0 * x154 + x244 * x59),
            x127 * x230 + x14 * (2.0 * x158 + x246 * x59),
            x127 * x231 + x14 * (2.0 * x162 + x247 * x59),
            x127 * x232 + x14 * (x103 * x236 + x103 * x237),
            x117 * x234 + x117 * x235,
            x219 * x250 + x249,
            x21 * x222 + x252,
            x223 * x250 + x254,
            x141 * x257 + x256,
            x146 * x257 + x259,
            x225 * x262 + x261,
            x153 * x265 + x264,
            x157 * x265 + x267,
            x161 * x265 + x269,
            x228 * x262 + x271,
            x183 * x229 + x272,
            x183 * x230 + x273,
            x183 * x231 + x274,
            x183 * x232 + x275,
            x117 * x250 + x276,
            x182 + x219 * x277,
            x186 + x277 * x278,
            x191 + x221 * x279,
            x193 + x277 * x281,
            x197 + x279 * x282,
            x198 * x224 + x201,
            x203 + x277 * x283,
            x205 + x279 * x284,
            x19 * x285 + x207,
            x208 * x227 + x211,
            x109 * x277 + x212,
            x111 * x279 + x214,
            x19 * x286 + x215,
            x19 * x287 + x217,
            x218 + x288 * x58,
            x219 * x289 + x249,
            x252 + x278 * x289,
            x221 * x290 + x254,
            x256 + x281 * x289,
            x259 + x282 * x290,
            x198 * x240 + x261,
            x264 + x283 * x289,
            x267 + x284 * x290,
            x20 * x285 + x269,
            x208 * x245 + x271,
            x109 * x289 + x272,
            x111 * x290 + x273,
            x20 * x286 + x274,
            x20 * x287 + x275,
            x127 * x288 + x276,
            x219 * x291 + x219 * x292,
            x278 * x291 + x278 * x292,
            x221 * x293 + x221 * x294,
            x281 * x291 + x281 * x292,
            x282 * x293 + x282 * x294,
            x136 * x295 + x198 * x257,
            x283 * x291 + x283 * x292,
            x284 * x293 + x284 * x294,
            x196 * x295 + x21 * x285,
            x134 * x296 + x208 * x265,
            x109 * x291 + x109 * x292,
            x111 * x293 + x111 * x294,
            x21 * x286 + x295 * x94,
            x21 * x287 + x296 * x78,
            x14 * (2.0 * x209 + x296 * x67) + x183 * x288,
        ]
    )


def _3center2el3d_sph_115(a, A, b, B, c, C):
    """Cartesian (pp|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = x3**2
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = x7**2
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x10**2
    x12 = c + x0
    x13 = x12 ** (-1.0)
    x14 = x0 * x13
    x15 = c * x14 * (x11 + x5 + x8)
    x16 = boys(6, x15)
    x17 = x12 ** (-1.5)
    x18 = 17.4934183276249
    x19 = A[0] - B[0]
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x1 * (x19**2 + x20**2 + x21**2))
    x23 = 2.0 * x18 * x22
    x24 = x1 * x23
    x25 = x17 * x24
    x26 = x16 * x25
    x27 = c ** (-1.0)
    x28 = x12 ** (-0.5)
    x29 = boys(5, x15)
    x30 = x4 * (2.0 * x1 * x18 * x22 * x27 * x28 * x29 - x26)
    x31 = -x2 - A[0]
    x32 = 2.0 * x1 * x18 * x22 * x27 * x28 * x29 * x31 - x26 * x3
    x33 = x25 * boys(7, x15)
    x34 = c * x13
    x35 = x3 * x34
    x36 = (
        x30 + x31 * x32 - x35 * (2.0 * x1 * x16 * x18 * x22 * x27 * x28 * x31 - x3 * x33)
    )
    x37 = x3 * x36
    x38 = x32 * x4
    x39 = 2.0 * x38
    x40 = x14 * x3
    x41 = x3 * x32
    x42 = x27 * x29
    x43 = x24 * x28 * x4 * x42
    x44 = x41 + x43
    x45 = x14 * x4
    x46 = 2.0 * x45
    x47 = x23 * x4 * x42
    x48 = x17 * x47
    x49 = x3 * x48 + x40 * x44
    x50 = x47 * x5
    x51 = x0 * x12 ** (-2.5)
    x52 = x40 * x49 + x50 * x51
    x53 = x3**3
    x54 = x47 * x53
    x55 = x0**2
    x56 = x12 ** (-3.5) * x55
    x57 = x40 * x52 + x54 * x56
    x58 = x3**4
    x59 = x0**3
    x60 = x12 ** (-4.5) * x59
    x61 = x47 * x60
    x62 = x40 * x57 + x58 * x61
    x63 = x14 * x19
    x64 = x14 * x7
    x65 = x48 * x7
    x66 = x41 * x64 + x65
    x67 = x47 * x51
    x68 = x3 * x67
    x69 = x40 * x66 + x68 * x7
    x70 = x5 * x7
    x71 = x47 * x56
    x72 = x40 * x69 + x70 * x71
    x73 = x54 * x60
    x74 = x40 * x72 + x7 * x73
    x75 = x10 * x14
    x76 = x10 * x48
    x77 = x41 * x75 + x76
    x78 = x10 * x68 + x40 * x77
    x79 = x10 * x50 * x56 + x40 * x78
    x80 = x10 * x73 + x40 * x79
    x81 = x55 / x12**2
    x82 = x8 * x81
    x83 = x67 * x8
    x84 = x41 * x82 + x83
    x85 = x3 * x8
    x86 = x40 * x84 + x71 * x85
    x87 = x50 * x60
    x88 = x40 * x86 + x8 * x87
    x89 = x7 * x81
    x90 = x10 * x89
    x91 = x10 * x7
    x92 = x67 * x91
    x93 = x41 * x90 + x92
    x94 = x3 * x71 * x91 + x40 * x93
    x95 = x10 * x61
    x96 = x40 * x94 + x70 * x95
    x97 = x11 * x81
    x98 = x11 * x67
    x99 = x41 * x97 + x98
    x100 = x11 * x71
    x101 = x100 * x3 + x40 * x99
    x102 = x101 * x40 + x11 * x87
    x103 = x7**3
    x104 = x59 / x12**3
    x105 = x103 * x104
    x106 = x103 * x71
    x107 = x105 * x41 + x106
    x108 = x103 * x3
    x109 = x107 * x40 + x108 * x61
    x110 = x104 * x8
    x111 = x10 * x110
    x112 = x10 * x71 * x8
    x113 = x111 * x41 + x112
    x114 = x113 * x40 + x85 * x95
    x115 = x104 * x7
    x116 = x11 * x115
    x117 = x100 * x7
    x118 = x116 * x41 + x117
    x119 = x11 * x3 * x61 * x7 + x118 * x40
    x120 = x10**3
    x121 = x104 * x120
    x122 = x120 * x71
    x123 = x121 * x41 + x122
    x124 = x120 * x3
    x125 = x123 * x40 + x124 * x61
    x126 = x7**4
    x127 = x0**4 / x12**4
    x128 = x126 * x127
    x129 = x126 * x61
    x130 = x128 * x41 + x129
    x131 = x103 * x127
    x132 = x10 * x131
    x133 = x103 * x95
    x134 = x132 * x41 + x133
    x135 = x127 * x37
    x136 = x11 * x8
    x137 = x127 * x39
    x138 = x127 * x41
    x139 = x136 * x61
    x140 = x136 * x138 + x139
    x141 = x120 * x7
    x142 = x141 * x61
    x143 = x138 * x141 + x142
    x144 = x10**4
    x145 = x127 * x144
    x146 = x144 * x61
    x147 = x145 * x41 + x146
    x148 = x7**5
    x149 = x0**5 / x12**5
    x150 = x149 * x36
    x151 = x148 * x149
    x152 = x19 * x32
    x153 = x126 * x149
    x154 = x10 * x153
    x155 = x103 * x11
    x156 = x149 * x152
    x157 = x120 * x8
    x158 = x144 * x7
    x159 = x10**5
    x160 = x149 * x159
    x161 = -x6 - A[1]
    x162 = 2.0 * x1 * x161 * x18 * x22 * x27 * x28 * x29 - x26 * x7
    x163 = x162 * x4
    x164 = 2.0 * x1 * x16 * x161 * x18 * x22 * x27 * x28 - x33 * x7
    x165 = x162 * x31 - x164 * x35
    x166 = x165 * x3
    x167 = x5 * x81
    x168 = x104 * x53
    x169 = x127 * x58
    x170 = x14 * (
        x163 * x169
        + x40
        * (x163 * x168 + x40 * (x163 * x167 + x40 * (x163 * x40 + x40 * (x163 + x166))))
    )
    x171 = x14 * x20
    x172 = x162 * x7
    x173 = x172 + x43
    x174 = x14 * x173
    x175 = x174 * x4
    x176 = x165 * x7
    x177 = x176 + x38
    x178 = x3 * x81
    x179 = x173 * x4
    x180 = x104 * x5
    x181 = x127 * x53
    x182 = x14 * (
        x179 * x181
        + x40 * (x179 * x180 + x40 * (x178 * x179 + x40 * (x175 + x177 * x40)))
    )
    x183 = x163 * x75
    x184 = x10 * x163
    x185 = x14 * (
        x181 * x184
        + x40 * (x180 * x184 + x40 * (x178 * x184 + x40 * (x166 * x75 + x183)))
    )
    x186 = x174 * x7 + x65
    x187 = x186 * x45
    x188 = x177 * x64 + x38 * x64
    x189 = x186 * x4
    x190 = x14 * (x180 * x189 + x40 * (x178 * x189 + x40 * (x187 + x188 * x40)))
    x191 = x172 * x75 + x76
    x192 = x191 * x45
    x193 = x38 * x75
    x194 = x176 * x75 + x193
    x195 = x191 * x4
    x196 = x14 * (x180 * x195 + x40 * (x178 * x195 + x40 * (x192 + x194 * x40)))
    x197 = x163 * x97
    x198 = x11 * x163
    x199 = x127 * x5
    x200 = x14 * (x198 * x199 + x40 * (x104 * x198 * x3 + x40 * (x166 * x97 + x197)))
    x201 = x186 * x64 + x83
    x202 = x201 * x45
    x203 = x188 * x64 + x38 * x82
    x204 = x178 * x4
    x205 = x14 * (x201 * x204 + x40 * (x202 + x203 * x40))
    x206 = x191 * x64 + x92
    x207 = x206 * x45
    x208 = x194 * x64 + x38 * x90
    x209 = x14 * (x204 * x206 + x40 * (x207 + x208 * x40))
    x210 = x172 * x97 + x98
    x211 = x210 * x45
    x212 = x38 * x97
    x213 = x176 * x97 + x212
    x214 = x14 * (x204 * x210 + x40 * (x211 + x213 * x40))
    x215 = x121 * x163
    x216 = x14 * (x124 * x127 * x163 + x40 * (x121 * x166 + x215))
    x217 = x106 + x201 * x64
    x218 = x217 * x45
    x219 = x105 * x38 + x203 * x64
    x220 = x14 * (x218 + x219 * x40)
    x221 = x112 + x206 * x64
    x222 = x221 * x45
    x223 = x111 * x38 + x208 * x64
    x224 = x14 * (x222 + x223 * x40)
    x225 = x117 + x210 * x64
    x226 = x225 * x45
    x227 = x116 * x38 + x213 * x64
    x228 = x14 * (x226 + x227 * x40)
    x229 = x121 * x172 + x122
    x230 = x229 * x45
    x231 = x121 * x38
    x232 = x121 * x176 + x231
    x233 = x14 * (x230 + x232 * x40)
    x234 = x145 * x163
    x235 = x14 * (x145 * x166 + x234)
    x236 = x14 * (x128 * x38 + x219 * x64)
    x237 = x20 * x32
    x238 = x14 * (x132 * x38 + x223 * x64)
    x239 = x127 * x38
    x240 = x14 * (x136 * x239 + x227 * x64)
    x241 = x149 * x237
    x242 = x14 * (x141 * x239 + x232 * x64)
    x243 = x145 * x38
    x244 = x14 * (x145 * x176 + x243)
    x245 = x160 * x165
    x246 = -x9 - A[2]
    x247 = 2.0 * x1 * x18 * x22 * x246 * x27 * x28 * x29 - x10 * x26
    x248 = x247 * x4
    x249 = 2.0 * x1 * x16 * x18 * x22 * x246 * x27 * x28 - x10 * x33
    x250 = x247 * x31 - x249 * x35
    x251 = x250 * x3
    x252 = x14 * (
        x169 * x248
        + x40
        * (x168 * x248 + x40 * (x167 * x248 + x40 * (x248 * x40 + x40 * (x248 + x251))))
    )
    x253 = x14 * x21
    x254 = x248 * x64
    x255 = x3 * x89
    x256 = x248 * x7
    x257 = x14 * (
        x181 * x256
        + x40 * (x180 * x256 + x40 * (x248 * x255 + x40 * (x251 * x64 + x254)))
    )
    x258 = x10 * x247 + x43
    x259 = x258 * x45
    x260 = x10 * x250 + x38
    x261 = x258 * x4
    x262 = x14 * (
        x181 * x261
        + x40 * (x180 * x261 + x40 * (x204 * x258 + x40 * (x259 + x260 * x40)))
    )
    x263 = x248 * x82
    x264 = x248 * x3
    x265 = x14 * (x199 * x248 * x8 + x40 * (x110 * x264 + x40 * (x251 * x82 + x263)))
    x266 = x261 * x89
    x267 = x260 * x3
    x268 = x115 * x3
    x269 = x127 * x261
    x270 = x14 * (x269 * x70 + x40 * (x261 * x268 + x40 * (x266 + x267 * x89)))
    x271 = x258 * x75 + x76
    x272 = x271 * x45
    x273 = x193 + x260 * x75
    x274 = x271 * x4
    x275 = x14 * (x180 * x274 + x40 * (x204 * x271 + x40 * (x272 + x273 * x40)))
    x276 = x105 * x248
    x277 = x14 * (x131 * x264 + x40 * (x105 * x251 + x276))
    x278 = x110 * x261
    x279 = x14 * (x269 * x85 + x40 * (x110 * x267 + x278))
    x280 = x274 * x89
    x281 = x273 * x3
    x282 = x14 * (x268 * x274 + x40 * (x280 + x281 * x89))
    x283 = x271 * x75 + x98
    x284 = x283 * x45
    x285 = x212 + x273 * x75
    x286 = x14 * (x204 * x283 + x40 * (x284 + x285 * x40))
    x287 = x128 * x248
    x288 = x14 * (x128 * x251 + x287)
    x289 = x131 * x261
    x290 = x14 * (x131 * x267 + x289)
    x291 = x110 * x274
    x292 = x14 * (x110 * x281 + x291)
    x293 = x283 * x4 * x89
    x294 = x14 * (x255 * x285 + x293)
    x295 = x122 + x283 * x75
    x296 = x295 * x45
    x297 = x231 + x285 * x75
    x298 = x14 * (x296 + x297 * x40)
    x299 = x151 * x250
    x300 = x21 * x32
    x301 = x153 * x260
    x302 = x131 * x273
    x303 = x149 * x300
    x304 = x110 * x285
    x305 = x297 * x89
    x306 = x14 * (x243 + x297 * x75)
    x307 = x149 * x3**5
    x308 = x162 * x19
    x309 = x149 * x58
    x310 = x173 * x309
    x311 = x10 * x309
    x312 = x181 * x19
    x313 = x11 * x53
    x314 = x149 * x308
    x315 = x180 * x19
    x316 = x120 * x5
    x317 = x178 * x19
    x318 = x144 * x3
    x319 = x129 + x217 * x64
    x320 = x133 + x221 * x64
    x321 = x139 + x225 * x64
    x322 = x142 + x229 * x64
    x323 = x145 * x172 + x146
    x324 = x34 * x7
    x325 = x161 * x162 - x164 * x324 + x30
    x326 = x162 * x20
    x327 = x325 * x7
    x328 = 2.0 * x163
    x329 = x327 + x328
    x330 = 2.0 * x175 + x329 * x64
    x331 = x181 * x20
    x332 = x327 * x75 + x328 * x75
    x333 = x149 * x325
    x334 = x149 * x326
    x335 = 2.0 * x187 + x330 * x64
    x336 = x180 * x20
    x337 = 2.0 * x192 + x332 * x64
    x338 = x327 * x97 + x328 * x97
    x339 = 2.0 * x202 + x335 * x64
    x340 = x178 * x20
    x341 = 2.0 * x207 + x337 * x64
    x342 = 2.0 * x211 + x338 * x64
    x343 = x121 * x327 + x121 * x328
    x344 = x161 * x247 - x249 * x324
    x345 = x307 * x344
    x346 = x162 * x21
    x347 = x248 + x344 * x7
    x348 = x309 * x347
    x349 = x10 * x344 + x163
    x350 = x309 * x349
    x351 = x254 + x347 * x64
    x352 = x181 * x351
    x353 = x181 * x21
    x354 = x259 + x349 * x64
    x355 = x181 * x354
    x356 = x183 + x349 * x75
    x357 = x181 * x356
    x358 = x149 * x346
    x359 = x263 + x351 * x64
    x360 = x180 * x359
    x361 = x180 * x21
    x362 = x266 + x354 * x64
    x363 = x180 * x362
    x364 = x272 + x356 * x64
    x365 = x180 * x364
    x366 = x197 + x356 * x75
    x367 = x180 * x366
    x368 = x276 + x359 * x64
    x369 = x178 * x368
    x370 = x178 * x21
    x371 = x278 + x362 * x64
    x372 = x178 * x371
    x373 = x280 + x364 * x64
    x374 = x178 * x373
    x375 = x284 + x366 * x64
    x376 = x178 * x375
    x377 = x215 + x366 * x75
    x378 = x178 * x377
    x379 = x14 * (x287 + x368 * x64)
    x380 = x14 * (x289 + x371 * x64)
    x381 = x14 * (x291 + x373 * x64)
    x382 = x14 * (x293 + x375 * x64)
    x383 = x14 * (x296 + x377 * x64)
    x384 = x14 * (x234 + x377 * x75)
    x385 = x19 * x247
    x386 = x309 * x7
    x387 = x19 * x258
    x388 = x149 * x53
    x389 = x388 * x8
    x390 = x388 * x7
    x391 = x149 * x5
    x392 = x103 * x391
    x393 = x391 * x8
    x394 = x127 * x271
    x395 = x19 * x394
    x396 = x153 * x3
    x397 = x108 * x149
    x398 = x268 * x283
    x399 = x131 * x271
    x400 = x110 * x283
    x401 = x295 * x89
    x402 = x146 + x295 * x75
    x403 = x20 * x247
    x404 = x20 * x258
    x405 = x20 * x394
    x406 = -x10 * x249 * x34 + x246 * x247 + x30
    x407 = x21 * x247
    x408 = x10 * x406 + 2.0 * x248
    x409 = x21 * x258
    x410 = 2.0 * x259 + x408 * x75
    x411 = x127 * x410
    x412 = x21 * x394
    x413 = 2.0 * x272 + x410 * x75
    x414 = 2.0 * x284 + x413 * x75

    # 189 item(s)
    return numpy.array(
        [
            x14
            * (
                x40
                * (x40 * (x40 * (x40 * (x37 + x39) + x44 * x46) + x46 * x49) + x46 * x52)
                + x46 * x57
            )
            + x62 * x63,
            x14
            * (
                x40 * (x40 * (x40 * (x37 * x64 + x39 * x64) + x46 * x66) + x46 * x69)
                + x46 * x72
            )
            + x63 * x74,
            x14
            * (
                x40 * (x40 * (x40 * (x37 * x75 + x39 * x75) + x46 * x77) + x46 * x78)
                + x46 * x79
            )
            + x63 * x80,
            x14 * (x40 * (x40 * (x37 * x82 + x39 * x82) + x46 * x84) + x46 * x86)
            + x63 * x88,
            x14 * (x40 * (x40 * (x37 * x90 + x39 * x90) + x46 * x93) + x46 * x94)
            + x63 * x96,
            x102 * x63
            + x14 * (x101 * x46 + x40 * (x40 * (x37 * x97 + x39 * x97) + x46 * x99)),
            x109 * x63 + x14 * (x107 * x46 + x40 * (x105 * x37 + x105 * x39)),
            x114 * x63 + x14 * (x113 * x46 + x40 * (x111 * x37 + x111 * x39)),
            x119 * x63 + x14 * (x118 * x46 + x40 * (x116 * x37 + x116 * x39)),
            x125 * x63 + x14 * (x123 * x46 + x40 * (x121 * x37 + x121 * x39)),
            x130 * x63 + x14 * (x128 * x37 + x128 * x39),
            x134 * x63 + x14 * (x132 * x37 + x132 * x39),
            x14 * (x135 * x136 + x136 * x137) + x140 * x63,
            x14 * (x135 * x141 + x137 * x141) + x143 * x63,
            x14 * (x145 * x37 + x145 * x39) + x147 * x63,
            x148 * x150 + x151 * x152,
            x10 * x126 * x150 + x152 * x154,
            x150 * x155 + x155 * x156,
            x150 * x157 + x156 * x157,
            x150 * x158 + x156 * x158,
            x150 * x159 + x152 * x160,
            x170 + x171 * x62,
            x171 * x74 + x182,
            x171 * x80 + x185,
            x171 * x88 + x190,
            x171 * x96 + x196,
            x102 * x171 + x200,
            x109 * x171 + x205,
            x114 * x171 + x209,
            x119 * x171 + x214,
            x125 * x171 + x216,
            x130 * x171 + x220,
            x134 * x171 + x224,
            x140 * x171 + x228,
            x143 * x171 + x233,
            x147 * x171 + x235,
            x151 * x237 + x236,
            x154 * x237 + x238,
            x155 * x241 + x240,
            x157 * x241 + x242,
            x158 * x241 + x244,
            x160 * x237 + x245,
            x252 + x253 * x62,
            x253 * x74 + x257,
            x253 * x80 + x262,
            x253 * x88 + x265,
            x253 * x96 + x270,
            x102 * x253 + x275,
            x109 * x253 + x277,
            x114 * x253 + x279,
            x119 * x253 + x282,
            x125 * x253 + x286,
            x130 * x253 + x288,
            x134 * x253 + x290,
            x140 * x253 + x292,
            x143 * x253 + x294,
            x147 * x253 + x298,
            x151 * x300 + x299,
            x154 * x300 + x301,
            x155 * x303 + x302,
            x157 * x303 + x304,
            x158 * x303 + x305,
            x160 * x300 + x306,
            x170 + x307 * x308,
            x182 + x19 * x310,
            x185 + x308 * x311,
            x186 * x312 + x190,
            x191 * x312 + x196,
            x200 + x313 * x314,
            x201 * x315 + x205,
            x206 * x315 + x209,
            x210 * x315 + x214,
            x216 + x314 * x316,
            x217 * x317 + x220,
            x221 * x317 + x224,
            x225 * x317 + x228,
            x229 * x317 + x233,
            x235 + x314 * x318,
            x236 + x319 * x63,
            x238 + x320 * x63,
            x240 + x321 * x63,
            x242 + x322 * x63,
            x244 + x323 * x63,
            x160 * x308 + x245,
            x307 * x325 + x307 * x326,
            x20 * x310 + x309 * x329,
            x311 * x325 + x311 * x326,
            x181 * x330 + x186 * x331,
            x181 * x332 + x191 * x331,
            x313 * x333 + x313 * x334,
            x180 * x335 + x201 * x336,
            x180 * x337 + x206 * x336,
            x180 * x338 + x210 * x336,
            x316 * x333 + x316 * x334,
            x178 * x339 + x217 * x340,
            x178 * x341 + x221 * x340,
            x178 * x342 + x225 * x340,
            x178 * x343 + x229 * x340,
            x318 * x333 + x318 * x334,
            x14 * (2.0 * x218 + x339 * x64) + x171 * x319,
            x14 * (2.0 * x222 + x341 * x64) + x171 * x320,
            x14 * (2.0 * x226 + x342 * x64) + x171 * x321,
            x14 * (2.0 * x230 + x343 * x64) + x171 * x322,
            x14 * (x145 * x327 + x145 * x328) + x171 * x323,
            x160 * x325 + x160 * x326,
            x307 * x346 + x345,
            x21 * x310 + x348,
            x311 * x346 + x350,
            x186 * x353 + x352,
            x191 * x353 + x355,
            x313 * x358 + x357,
            x201 * x361 + x360,
            x206 * x361 + x363,
            x210 * x361 + x365,
            x316 * x358 + x367,
            x217 * x370 + x369,
            x221 * x370 + x372,
            x225 * x370 + x374,
            x229 * x370 + x376,
            x318 * x358 + x378,
            x253 * x319 + x379,
            x253 * x320 + x380,
            x253 * x321 + x381,
            x253 * x322 + x382,
            x253 * x323 + x383,
            x160 * x346 + x384,
            x252 + x307 * x385,
            x257 + x385 * x386,
            x262 + x309 * x387,
            x265 + x385 * x389,
            x270 + x387 * x390,
            x271 * x312 + x275,
            x277 + x385 * x392,
            x279 + x387 * x393,
            x282 + x395 * x70,
            x283 * x315 + x286,
            x288 + x385 * x396,
            x290 + x387 * x397,
            x292 + x395 * x85,
            x19 * x398 + x294,
            x295 * x317 + x298,
            x151 * x385 + x299,
            x153 * x387 + x301,
            x19 * x399 + x302,
            x19 * x400 + x304,
            x19 * x401 + x305,
            x306 + x402 * x63,
            x307 * x403 + x345,
            x348 + x386 * x403,
            x309 * x404 + x350,
            x352 + x389 * x403,
            x355 + x390 * x404,
            x271 * x331 + x357,
            x360 + x392 * x403,
            x363 + x393 * x404,
            x365 + x405 * x70,
            x283 * x336 + x367,
            x369 + x396 * x403,
            x372 + x397 * x404,
            x374 + x405 * x85,
            x20 * x398 + x376,
            x295 * x340 + x378,
            x151 * x403 + x379,
            x153 * x404 + x380,
            x20 * x399 + x381,
            x20 * x400 + x382,
            x20 * x401 + x383,
            x171 * x402 + x384,
            x307 * x406 + x307 * x407,
            x386 * x406 + x386 * x407,
            x309 * x408 + x309 * x409,
            x389 * x406 + x389 * x407,
            x390 * x408 + x390 * x409,
            x181 * x410 + x271 * x353,
            x392 * x406 + x392 * x407,
            x393 * x408 + x393 * x409,
            x411 * x70 + x412 * x70,
            x180 * x413 + x283 * x361,
            x396 * x406 + x396 * x407,
            x397 * x408 + x397 * x409,
            x411 * x85 + x412 * x85,
            x21 * x398 + x268 * x413,
            x178 * x414 + x295 * x370,
            x151 * x406 + x151 * x407,
            x153 * x408 + x153 * x409,
            x131 * x410 + x21 * x399,
            x110 * x413 + x21 * x400,
            x21 * x401 + x414 * x89,
            x14 * (2.0 * x296 + x414 * x75) + x253 * x402,
        ]
    )


def _3center2el3d_sph_120(a, A, b, B, c, C):
    """Cartesian (pd|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = (2.0 * a + 2.0 * b) ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - C[0]
    x6 = -x3 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x3 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = c + x2
    x11 = c / x10
    x12 = x11 * x2 * (x5**2 + x7**2 + x9**2)
    x13 = boys(1, x12)
    x14 = 17.4934183276249
    x15 = A[1] - B[1]
    x16 = A[2] - B[2]
    x17 = numpy.exp(-a * b * x3 * (x0**2 + x15**2 + x16**2))
    x18 = 2.0 * x10 ** (-1.5) * x14 * x17 * x3
    x19 = x13 * x18
    x20 = c ** (-1.0)
    x21 = x10 ** (-0.5)
    x22 = boys(0, x12)
    x23 = x1 * (2.0 * x14 * x17 * x20 * x21 * x22 * x3 - x19)
    x24 = -x4 - A[0]
    x25 = -2.0 * x14 * x17 * x20 * x21 * x22 * x24 * x3 + x19 * x5
    x26 = -x25
    x27 = boys(2, x12)
    x28 = x18 * x27
    x29 = 2.0 * x13 * x14 * x17 * x20 * x21 * x24 * x3 - x28 * x5
    x30 = x11 * x29
    x31 = x23 + x24 * x26 - x30 * x5
    x32 = x1 * (2.0 * x13 * x14 * x17 * x20 * x21 * x3 - x28)
    x33 = x18 * boys(3, x12)
    x34 = x11 * x5
    x35 = -x6 - A[1]
    x36 = -2.0 * x14 * x17 * x20 * x21 * x22 * x3 * x35 + x19 * x7
    x37 = -x36
    x38 = 2.0 * x13 * x14 * x17 * x20 * x21 * x3 * x35 - x28 * x7
    x39 = x11 * x38
    x40 = x39 * x5
    x41 = x24 * x37 - x40
    x42 = x15 * x26 + x41
    x43 = x1 * (-x36 - x39)
    x44 = x24 * x37 - x40
    x45 = 2.0 * x14 * x17 * x20 * x21 * x27 * x3 * x35 - x33 * x7
    x46 = x24 * x44 - x34 * (x24 * x38 - x34 * x45) + x43
    x47 = -x8 - A[2]
    x48 = -2.0 * x14 * x17 * x20 * x21 * x22 * x3 * x47 + x19 * x9
    x49 = -x48
    x50 = 2.0 * x13 * x14 * x17 * x20 * x21 * x3 * x47 - x28 * x9
    x51 = x11 * x50
    x52 = x5 * x51
    x53 = x24 * x49 - x52
    x54 = x16 * x26 + x53
    x55 = x1 * (-x48 - x51)
    x56 = x24 * x49 - x52
    x57 = 2.0 * x14 * x17 * x20 * x21 * x27 * x3 * x47 - x33 * x9
    x58 = x24 * x56 - x34 * (x24 * x50 - x34 * x57) + x55
    x59 = x23 + x35 * x37 - x39 * x7
    x60 = x11 * x7
    x61 = x32 + x35 * x38 - x45 * x60
    x62 = x15 * x44 + x24 * x59 - x34 * x61
    x63 = x51 * x7
    x64 = x35 * x49 - x63
    x65 = x35 * x50 - x57 * x60
    x66 = x24 * x64 - x34 * x65
    x67 = x16 * x44 + x66
    x68 = x23 + x47 * x49 - x51 * x9
    x69 = x11 * x9
    x70 = x32 + x47 * x50 - x57 * x69
    x71 = x16 * x56 + x24 * x68 - x34 * x70
    x72 = x15 * x37 + x59
    x73 = x35 * x49 - x63
    x74 = x16 * x37 + x73
    x75 = x35 * x64 + x55 - x60 * x65
    x76 = x16 * x64 + x35 * x68 - x60 * x70
    x77 = x15 * x49 + x73
    x78 = x16 * x49 + x68

    # 18 item(s)
    return numpy.array(
        [
            x0 * x31
            + x0 * (x0 * x26 + x31)
            + 2.0 * x1 * (-x25 - x30)
            + x24 * x31
            - x34
            * (
                x24 * x29
                + x32
                - x34 * (2.0 * x14 * x17 * x20 * x21 * x24 * x27 * x3 - x33 * x5)
            ),
            x0 * x42 + x15 * x31 + x46,
            x0 * x54 + x16 * x31 + x58,
            x15 * x42 + x62,
            x15 * x54 + x67,
            x16 * x54 + x71,
            x0 * x44 + x0 * (x0 * x37 + x41) + x46,
            x0 * x72 + x62,
            x0 * x74 + x67,
            x15 * x59 + x15 * x72 + x35 * x59 + 2.0 * x43 - x60 * x61,
            x15 * x74 + x16 * x59 + x75,
            x16 * x74 + x76,
            x0 * x56 + x0 * (x0 * x49 + x53) + x58,
            x0 * x77 + x15 * x56 + x66,
            x0 * x78 + x71,
            x15 * x64 + x15 * x77 + x75,
            x15 * x78 + x76,
            x16 * x68 + x16 * x78 + x47 * x68 + 2.0 * x55 - x69 * x70,
        ]
    )


def _3center2el3d_sph_121(a, A, b, B, c, C):
    """Cartesian (pd|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x2 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = c + x1
    x11 = x10 ** (-1.0)
    x12 = x1 * x11
    x13 = c * x12 * (x4**2 + x7**2 + x9**2)
    x14 = boys(2, x13)
    x15 = 17.4934183276249
    x16 = A[1] - B[1]
    x17 = A[2] - B[2]
    x18 = numpy.exp(-a * b * x2 * (x0**2 + x16**2 + x17**2))
    x19 = x15 * x18 * x2
    x20 = 2.0 * x10 ** (-1.5) * x19
    x21 = x14 * x20
    x22 = c ** (-1.0)
    x23 = x10 ** (-0.5)
    x24 = boys(1, x13)
    x25 = x5 * (2.0 * x15 * x18 * x2 * x22 * x23 * x24 - x21)
    x26 = -x3 - A[0]
    x27 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x26 + x21 * x4
    x28 = -x27
    x29 = boys(3, x13)
    x30 = x20 * x29
    x31 = 2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x26 - x30 * x4
    x32 = c * x11
    x33 = x31 * x32
    x34 = x25 + x26 * x28 - x33 * x4
    x35 = x28 * x5
    x36 = x12 * (x34 * x4 + 2.0 * x35)
    x37 = 2.0 * x5
    x38 = x19 * x22 * x23 * x24 * x37
    x39 = x12 * (x28 * x4 + x38)
    x40 = x5 * (2.0 * x14 * x15 * x18 * x2 * x22 * x23 - x30)
    x41 = x20 * boys(4, x13)
    x42 = x32 * x4
    x43 = (
        x26 * x34
        + x37 * (-x27 - x33)
        - x42
        * (
            x26 * x31
            + x40
            - x42 * (2.0 * x15 * x18 * x2 * x22 * x23 * x26 * x29 - x4 * x41)
        )
    )
    x44 = x34 * x5
    x45 = x12 * x7
    x46 = x34 * x45
    x47 = x0 * x28
    x48 = x12 * x9
    x49 = x34 * x48
    x50 = -x6 - A[1]
    x51 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x50 + x21 * x7
    x52 = -x51
    x53 = x5 * x52
    x54 = 2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x50 - x30 * x7
    x55 = x32 * x54
    x56 = x26 * x52 - x4 * x55
    x57 = x12 * (x4 * x56 + x53)
    x58 = x16 * x39 + x57
    x59 = x5 * (-x51 - x55)
    x60 = 2.0 * x15 * x18 * x2 * x22 * x23 * x29 * x50 - x41 * x7
    x61 = x26 * x56 - x42 * (x26 * x54 - x42 * x60) + x59
    x62 = x5 * x56
    x63 = 2.0 * x62
    x64 = x12 * (x4 * x61 + x63)
    x65 = x12 * (x35 + x56 * x7)
    x66 = x16 * x28
    x67 = x45 * x66 + x65
    x68 = x12 * (x44 + x61 * x7)
    x69 = x48 * x56
    x70 = x48 * x66 + x69
    x71 = x48 * x61
    x72 = -x8 - A[2]
    x73 = -2.0 * x15 * x18 * x2 * x22 * x23 * x24 * x72 + x21 * x9
    x74 = -x73
    x75 = x5 * x74
    x76 = 2.0 * x14 * x15 * x18 * x2 * x22 * x23 * x72 - x30 * x9
    x77 = x32 * x76
    x78 = x26 * x74 - x4 * x77
    x79 = x12 * (x4 * x78 + x75)
    x80 = x17 * x39 + x79
    x81 = x5 * (-x73 - x77)
    x82 = 2.0 * x15 * x18 * x2 * x22 * x23 * x29 * x72 - x41 * x9
    x83 = x26 * x78 - x42 * (x26 * x76 - x42 * x82) + x81
    x84 = x5 * x78
    x85 = 2.0 * x84
    x86 = x12 * (x4 * x83 + x85)
    x87 = x45 * x78
    x88 = x17 * x28
    x89 = x45 * x88 + x87
    x90 = x45 * x83
    x91 = x12 * (x35 + x78 * x9)
    x92 = x48 * x88 + x91
    x93 = x12 * (x44 + x83 * x9)
    x94 = x25 + x50 * x52 - x55 * x7
    x95 = x5 * x94
    x96 = x32 * x7
    x97 = x40 + x50 * x54 - x60 * x96
    x98 = x26 * x94 - x42 * x97
    x99 = x12 * (x4 * x98 + x95) + x16 * x57
    x100 = x12 * (x63 + x7 * x98) + x16 * x65
    x101 = x16 * x69 + x48 * x98
    x102 = x50 * x74 - x7 * x77
    x103 = x102 * x5
    x104 = x50 * x76 - x82 * x96
    x105 = x102 * x26 - x104 * x42
    x106 = x12 * (x103 + x105 * x4)
    x107 = x106 + x17 * x57
    x108 = x12 * (x105 * x7 + x84)
    x109 = x108 + x17 * x65
    x110 = x12 * (x105 * x9 + x62)
    x111 = x110 + x17 * x69
    x112 = x25 + x72 * x74 - x77 * x9
    x113 = x112 * x5
    x114 = x32 * x9
    x115 = -x114 * x82 + x40 + x72 * x76
    x116 = x112 * x26 - x115 * x42
    x117 = x12 * (x113 + x116 * x4) + x17 * x79
    x118 = x116 * x45 + x17 * x87
    x119 = x12 * (x116 * x9 + x85) + x17 * x91
    x120 = x12 * x4
    x121 = x0 * x52
    x122 = x12 * (x38 + x52 * x7)
    x123 = x120 * x94
    x124 = x16 * x52
    x125 = x120 * x124 + x123
    x126 = x12 * (2.0 * x53 + x7 * x94)
    x127 = x122 * x16 + x126
    x128 = x48 * x94
    x129 = x124 * x48 + x128
    x130 = x102 * x120
    x131 = x17 * x52
    x132 = x120 * x131 + x130
    x133 = x12 * (x102 * x7 + x75)
    x134 = x122 * x17 + x133
    x135 = x12 * (x102 * x9 + x53)
    x136 = x131 * x48 + x135
    x137 = x50 * x94 + 2.0 * x59 - x96 * x97
    x138 = x102 * x50 - x104 * x96 + x81
    x139 = x120 * x138
    x140 = 2.0 * x103
    x141 = x12 * (x138 * x7 + x140)
    x142 = x12 * (x138 * x9 + x95)
    x143 = x112 * x50 - x115 * x96
    x144 = x120 * x143 + x130 * x17
    x145 = x12 * (x113 + x143 * x7) + x133 * x17
    x146 = x12 * (x140 + x143 * x9) + x135 * x17
    x147 = x0 * x74
    x148 = x12 * (x38 + x74 * x9)
    x149 = x16 * x74
    x150 = x120 * x149 + x130
    x151 = x133 + x149 * x45
    x152 = x135 + x148 * x16
    x153 = x112 * x120
    x154 = x17 * x74
    x155 = x120 * x154 + x153
    x156 = x112 * x45
    x157 = x154 * x45 + x156
    x158 = x12 * (x112 * x9 + 2.0 * x75)
    x159 = x148 * x17 + x158
    x160 = x112 * x72 - x114 * x115 + 2.0 * x81

    # 54 item(s)
    return numpy.array(
        [
            x0 * x36 + x0 * (x0 * x39 + x36) + x12 * (x4 * x43 + 3.0 * x44),
            x0 * x46 + x0 * (x45 * x47 + x46) + x43 * x45,
            x0 * x49 + x0 * (x47 * x48 + x49) + x43 * x48,
            x0 * x58 + x16 * x36 + x64,
            x0 * x67 + x16 * x46 + x68,
            x0 * x70 + x16 * x49 + x71,
            x0 * x80 + x17 * x36 + x86,
            x0 * x89 + x17 * x46 + x90,
            x0 * x92 + x17 * x49 + x93,
            x16 * x58 + x99,
            x100 + x16 * x67,
            x101 + x16 * x70,
            x107 + x16 * x80,
            x109 + x16 * x89,
            x111 + x16 * x92,
            x117 + x17 * x80,
            x118 + x17 * x89,
            x119 + x17 * x92,
            x0 * x57 + x0 * (x120 * x121 + x57) + x64,
            x0 * x65 + x0 * (x0 * x122 + x65) + x68,
            x0 * x69 + x0 * (x121 * x48 + x69) + x71,
            x0 * x125 + x99,
            x0 * x127 + x100,
            x0 * x129 + x101,
            x0 * x132 + x107,
            x0 * x134 + x109,
            x0 * x136 + x111,
            x120 * x137 + x123 * x16 + x125 * x16,
            x12 * (x137 * x7 + 3.0 * x95) + x126 * x16 + x127 * x16,
            x128 * x16 + x129 * x16 + x137 * x48,
            x123 * x17 + x132 * x16 + x139,
            x126 * x17 + x134 * x16 + x141,
            x128 * x17 + x136 * x16 + x142,
            x132 * x17 + x144,
            x134 * x17 + x145,
            x136 * x17 + x146,
            x0 * x79 + x0 * (x120 * x147 + x79) + x86,
            x0 * x87 + x0 * (x147 * x45 + x87) + x90,
            x0 * x91 + x0 * (x0 * x148 + x91) + x93,
            x0 * x150 + x106 + x16 * x79,
            x0 * x151 + x108 + x16 * x87,
            x0 * x152 + x110 + x16 * x91,
            x0 * x155 + x117,
            x0 * x157 + x118,
            x0 * x159 + x119,
            x130 * x16 + x139 + x150 * x16,
            x133 * x16 + x141 + x151 * x16,
            x135 * x16 + x142 + x152 * x16,
            x144 + x155 * x16,
            x145 + x157 * x16,
            x146 + x159 * x16,
            x120 * x160 + x153 * x17 + x155 * x17,
            x156 * x17 + x157 * x17 + x160 * x45,
            x12 * (3.0 * x113 + x160 * x9) + x158 * x17 + x159 * x17,
        ]
    )


def _3center2el3d_sph_122(a, A, b, B, c, C):
    """Cartesian (pd|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(3, x16)
    x18 = x13 ** (-1.5)
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x2 * x22
    x24 = 2.0 * x18 * x23
    x25 = x17 * x24
    x26 = c ** (-1.0)
    x27 = x13 ** (-0.5)
    x28 = boys(2, x16)
    x29 = x5 * (2.0 * x19 * x2 * x22 * x26 * x27 * x28 - x25)
    x30 = -x3 - A[0]
    x31 = -2.0 * x19 * x2 * x22 * x26 * x27 * x28 * x30 + x25 * x4
    x32 = -x31
    x33 = boys(4, x16)
    x34 = x24 * x33
    x35 = 2.0 * x17 * x19 * x2 * x22 * x26 * x27 * x30 - x34 * x4
    x36 = c * x14
    x37 = x35 * x36
    x38 = x29 + x30 * x32 - x37 * x4
    x39 = x38 * x4
    x40 = x32 * x5
    x41 = 2.0 * x40
    x42 = x39 + x41
    x43 = x15 * x4
    x44 = x32 * x4
    x45 = 2.0 * x5
    x46 = x26 * x28 * x45
    x47 = x23 * x27 * x46
    x48 = x44 + x47
    x49 = x15 * x45
    x50 = x15 * (x42 * x43 + x48 * x49)
    x51 = x18 * x19 * x22 * x46
    x52 = x4 * x51 + x43 * x48
    x53 = x0 * x15
    x54 = x5 * (2.0 * x17 * x19 * x2 * x22 * x26 * x27 - x34)
    x55 = x24 * boys(5, x16)
    x56 = x36 * x4
    x57 = (
        x30 * x38
        + x45 * (-x31 - x37)
        - x56
        * (
            x30 * x35
            + x54
            - x56 * (2.0 * x19 * x2 * x22 * x26 * x27 * x30 * x33 - x4 * x55)
        )
    )
    x58 = x4 * x57
    x59 = x38 * x5
    x60 = 3.0 * x59
    x61 = x15 * x5
    x62 = x15 * x8
    x63 = x15 * (x39 * x62 + x41 * x62)
    x64 = x51 * x8
    x65 = x44 * x62 + x64
    x66 = x11 * x15
    x67 = x15 * (x39 * x66 + x41 * x66)
    x68 = x11 * x51
    x69 = x44 * x66 + x68
    x70 = x1**2 / x13**2
    x71 = x70 * x9
    x72 = x38 * x71
    x73 = x0 * x32
    x74 = x70 * x8
    x75 = x11 * x74
    x76 = x38 * x75
    x77 = x12 * x70
    x78 = x38 * x77
    x79 = -x7 - A[1]
    x80 = -2.0 * x19 * x2 * x22 * x26 * x27 * x28 * x79 + x25 * x8
    x81 = -x80
    x82 = x5 * x81
    x83 = 2.0 * x17 * x19 * x2 * x22 * x26 * x27 * x79 - x34 * x8
    x84 = x36 * x83
    x85 = x30 * x81 - x4 * x84
    x86 = x4 * x85
    x87 = x82 + x86
    x88 = x15 * (x43 * x82 + x43 * x87)
    x89 = x15 * x20
    x90 = x52 * x89 + x88
    x91 = x5 * (-x80 - x84)
    x92 = 2.0 * x19 * x2 * x22 * x26 * x27 * x33 * x79 - x55 * x8
    x93 = x30 * x85 - x56 * (x30 * x83 - x56 * x92) + x91
    x94 = x4 * x93
    x95 = x5 * x85
    x96 = 2.0 * x95
    x97 = x15 * (x43 * (x94 + x96) + x49 * x87)
    x98 = x8 * x81
    x99 = x47 + x98
    x100 = x8 * x85
    x101 = x100 + x40
    x102 = x15 * (x101 * x43 + x61 * x99)
    x103 = x102 + x65 * x89
    x104 = x8 * x93
    x105 = x104 + x59
    x106 = x101 * x49
    x107 = x15 * (x105 * x43 + x106)
    x108 = x66 * x82
    x109 = x15 * (x108 + x66 * x86)
    x110 = x109 + x69 * x89
    x111 = x66 * x96
    x112 = x15 * (x111 + x66 * x94)
    x113 = x15 * (x101 * x62 + x40 * x62)
    x114 = x20 * x32
    x115 = x113 + x114 * x71
    x116 = x15 * (x105 * x62 + x59 * x62)
    x117 = x40 * x66
    x118 = x15 * (x100 * x66 + x117)
    x119 = x114 * x75 + x118
    x120 = x59 * x66
    x121 = x15 * (x104 * x66 + x120)
    x122 = x77 * x85
    x123 = x114 * x77 + x122
    x124 = x77 * x93
    x125 = -x10 - A[2]
    x126 = x11 * x25 - 2.0 * x125 * x19 * x2 * x22 * x26 * x27 * x28
    x127 = -x126
    x128 = x127 * x5
    x129 = -x11 * x34 + 2.0 * x125 * x17 * x19 * x2 * x22 * x26 * x27
    x130 = x129 * x36
    x131 = x127 * x30 - x130 * x4
    x132 = x131 * x4
    x133 = x128 + x132
    x134 = x15 * (x128 * x43 + x133 * x43)
    x135 = x15 * x21
    x136 = x134 + x135 * x52
    x137 = x5 * (-x126 - x130)
    x138 = -x11 * x55 + 2.0 * x125 * x19 * x2 * x22 * x26 * x27 * x33
    x139 = x131 * x30 + x137 - x56 * (x129 * x30 - x138 * x56)
    x140 = x139 * x4
    x141 = x131 * x5
    x142 = 2.0 * x141
    x143 = x15 * (x133 * x49 + x43 * (x140 + x142))
    x144 = x128 * x62
    x145 = x15 * (x132 * x62 + x144)
    x146 = x135 * x65 + x145
    x147 = x15 * (x140 * x62 + x142 * x62)
    x148 = x11 * x127 + x47
    x149 = x148 * x61
    x150 = x11 * x131 + x40
    x151 = x15 * (x149 + x150 * x43)
    x152 = x135 * x69 + x151
    x153 = x11 * x139 + x59
    x154 = x150 * x49
    x155 = x15 * (x153 * x43 + x154)
    x156 = x131 * x71
    x157 = x21 * x32
    x158 = x156 + x157 * x71
    x159 = x139 * x71
    x160 = x150 * x74
    x161 = x157 * x75 + x160
    x162 = x153 * x74
    x163 = x15 * (x117 + x150 * x66)
    x164 = x157 * x77 + x163
    x165 = x15 * (x120 + x153 * x66)
    x166 = x29 + x79 * x81 - x8 * x84
    x167 = x166 * x5
    x168 = x36 * x8
    x169 = -x168 * x92 + x54 + x79 * x83
    x170 = x166 * x30 - x169 * x56
    x171 = x170 * x4
    x172 = x15 * (x167 * x43 + x43 * (x167 + x171)) + x20 * x88
    x173 = x166 * x8
    x174 = 2.0 * x82
    x175 = x173 + x174
    x176 = x175 * x61
    x177 = x170 * x8
    x178 = x177 + x96
    x179 = x102 * x20 + x15 * (x176 + x178 * x43)
    x180 = x167 * x66
    x181 = x109 * x20 + x15 * (x171 * x66 + x180)
    x182 = x113 * x20 + x15 * (x106 + x178 * x62)
    x183 = x118 * x20 + x15 * (x111 + x177 * x66)
    x184 = x122 * x20 + x170 * x77
    x185 = x127 * x79 - x130 * x8
    x186 = x185 * x5
    x187 = x129 * x79 - x138 * x168
    x188 = x185 * x30 - x187 * x56
    x189 = x15 * (x186 * x43 + x43 * (x186 + x188 * x4))
    x190 = x189 + x21 * x88
    x191 = x128 + x185 * x8
    x192 = x141 + x188 * x8
    x193 = x15 * (x191 * x61 + x192 * x43)
    x194 = x102 * x21 + x193
    x195 = x11 * x185 + x82
    x196 = x11 * x188 + x95
    x197 = x15 * (x195 * x61 + x196 * x43)
    x198 = x109 * x21 + x197
    x199 = x15 * (x141 * x62 + x192 * x62)
    x200 = x113 * x21 + x199
    x201 = x15 * (x150 * x61 + x196 * x62)
    x202 = x118 * x21 + x201
    x203 = x15 * (x196 * x66 + x66 * x95)
    x204 = x122 * x21 + x203
    x205 = -x11 * x130 + x125 * x127 + x29
    x206 = x205 * x5
    x207 = x11 * x36
    x208 = x125 * x129 - x138 * x207 + x54
    x209 = x205 * x30 - x208 * x56
    x210 = x209 * x4
    x211 = x134 * x21 + x15 * (x206 * x43 + x43 * (x206 + x210))
    x212 = x206 * x62
    x213 = x145 * x21 + x15 * (x210 * x62 + x212)
    x214 = x11 * x205 + 2.0 * x128
    x215 = x214 * x61
    x216 = x11 * x209 + x142
    x217 = x15 * (x215 + x216 * x43) + x151 * x21
    x218 = x156 * x21 + x209 * x71
    x219 = x160 * x21 + x216 * x74
    x220 = x15 * (x154 + x216 * x66) + x163 * x21
    x221 = x6 * x70
    x222 = x0 * x81
    x223 = x4 * x70
    x224 = x223 * x99
    x225 = x11 * x223
    x226 = x62 * x99 + x64
    x227 = x66 * x98 + x68
    x228 = x166 * x221
    x229 = x20 * x81
    x230 = x221 * x229 + x228
    x231 = x175 * x223
    x232 = x20 * x224 + x231
    x233 = x166 * x225
    x234 = x225 * x229 + x233
    x235 = x15 * (x175 * x62 + x49 * x99)
    x236 = x226 * x89 + x235
    x237 = x15 * (x173 * x66 + x174 * x66)
    x238 = x227 * x89 + x237
    x239 = x166 * x77
    x240 = x229 * x77 + x239
    x241 = x185 * x221
    x242 = x21 * x81
    x243 = x221 * x242 + x241
    x244 = x191 * x223
    x245 = x21 * x224 + x244
    x246 = x195 * x223
    x247 = x225 * x242 + x246
    x248 = x15 * (x144 + x191 * x62)
    x249 = x135 * x226 + x248
    x250 = x15 * (x149 + x195 * x62)
    x251 = x135 * x227 + x250
    x252 = x15 * (x108 + x195 * x66)
    x253 = x242 * x77 + x252
    x254 = x166 * x79 - x168 * x169 + 2.0 * x91
    x255 = x254 * x8
    x256 = 3.0 * x167
    x257 = x255 + x256
    x258 = x137 - x168 * x187 + x185 * x79
    x259 = x221 * x258
    x260 = 2.0 * x186
    x261 = x258 * x8 + x260
    x262 = x223 * x261
    x263 = x11 * x258 + x167
    x264 = x223 * x263
    x265 = x15 * (x191 * x49 + x261 * x62)
    x266 = x195 * x49
    x267 = x15 * (x263 * x62 + x266)
    x268 = x15 * (x180 + x263 * x66)
    x269 = -x168 * x208 + x205 * x79
    x270 = x21 * x241 + x221 * x269
    x271 = x206 + x269 * x8
    x272 = x21 * x244 + x223 * x271
    x273 = x11 * x269 + x260
    x274 = x21 * x246 + x223 * x273
    x275 = x15 * (x212 + x271 * x62) + x21 * x248
    x276 = x15 * (x215 + x273 * x62) + x21 * x250
    x277 = x15 * (x266 + x273 * x66) + x21 * x252
    x278 = x0 * x127
    x279 = x4 * x74
    x280 = x0 * x148
    x281 = x148 * x66 + x68
    x282 = x127 * x20
    x283 = x221 * x282 + x241
    x284 = x244 + x279 * x282
    x285 = x148 * x20
    x286 = x223 * x285 + x246
    x287 = x248 + x282 * x71
    x288 = x250 + x285 * x74
    x289 = x252 + x281 * x89
    x290 = x205 * x221
    x291 = x127 * x21
    x292 = x221 * x291 + x290
    x293 = x205 * x279
    x294 = x279 * x291 + x293
    x295 = x214 * x223
    x296 = x148 * x21
    x297 = x223 * x296 + x295
    x298 = x205 * x71
    x299 = x291 * x71 + x298
    x300 = x214 * x74
    x301 = x296 * x74 + x300
    x302 = x15 * (x148 * x49 + x214 * x66)
    x303 = x135 * x281 + x302
    x304 = x125 * x205 + 2.0 * x137 - x207 * x208
    x305 = x11 * x304 + 3.0 * x206

    # 108 item(s)
    return numpy.array(
        [
            x0 * x50
            + x0 * (x50 + x52 * x53)
            + x15 * (3.0 * x42 * x61 + x43 * (x58 + x60)),
            x0 * x63 + x0 * (x53 * x65 + x63) + x15 * (x58 * x62 + x60 * x62),
            x0 * x67 + x0 * (x53 * x69 + x67) + x15 * (x58 * x66 + x60 * x66),
            x0 * x72 + x0 * (x71 * x73 + x72) + x57 * x71,
            x0 * x76 + x0 * (x73 * x75 + x76) + x57 * x75,
            x0 * x78 + x0 * (x73 * x77 + x78) + x57 * x77,
            x0 * x90 + x20 * x50 + x97,
            x0 * x103 + x107 + x20 * x63,
            x0 * x110 + x112 + x20 * x67,
            x0 * x115 + x116 + x20 * x72,
            x0 * x119 + x121 + x20 * x76,
            x0 * x123 + x124 + x20 * x78,
            x0 * x136 + x143 + x21 * x50,
            x0 * x146 + x147 + x21 * x63,
            x0 * x152 + x155 + x21 * x67,
            x0 * x158 + x159 + x21 * x72,
            x0 * x161 + x162 + x21 * x76,
            x0 * x164 + x165 + x21 * x78,
            x172 + x20 * x90,
            x103 * x20 + x179,
            x110 * x20 + x181,
            x115 * x20 + x182,
            x119 * x20 + x183,
            x123 * x20 + x184,
            x136 * x20 + x190,
            x146 * x20 + x194,
            x152 * x20 + x198,
            x158 * x20 + x200,
            x161 * x20 + x202,
            x164 * x20 + x204,
            x136 * x21 + x211,
            x146 * x21 + x213,
            x152 * x21 + x217,
            x158 * x21 + x218,
            x161 * x21 + x219,
            x164 * x21 + x220,
            x0 * x88 + x0 * (x221 * x222 + x88) + x97,
            x0 * x102 + x0 * (x0 * x224 + x102) + x107,
            x0 * x109 + x0 * (x109 + x222 * x225) + x112,
            x0 * x113 + x0 * (x113 + x226 * x53) + x116,
            x0 * x118 + x0 * (x118 + x227 * x53) + x121,
            x0 * x122 + x0 * (x122 + x222 * x77) + x124,
            x0 * x230 + x172,
            x0 * x232 + x179,
            x0 * x234 + x181,
            x0 * x236 + x182,
            x0 * x238 + x183,
            x0 * x240 + x184,
            x0 * x243 + x190,
            x0 * x245 + x194,
            x0 * x247 + x198,
            x0 * x249 + x200,
            x0 * x251 + x202,
            x0 * x253 + x204,
            x20 * x228 + x20 * x230 + x221 * x254,
            x20 * x231 + x20 * x232 + x223 * x257,
            x20 * x233 + x20 * x234 + x225 * x254,
            x15 * (3.0 * x176 + x257 * x62) + x20 * x235 + x20 * x236,
            x15 * (x255 * x66 + x256 * x66) + x20 * x237 + x20 * x238,
            x20 * x239 + x20 * x240 + x254 * x77,
            x20 * x243 + x21 * x228 + x259,
            x20 * x245 + x21 * x231 + x262,
            x20 * x247 + x21 * x233 + x264,
            x20 * x249 + x21 * x235 + x265,
            x20 * x251 + x21 * x237 + x267,
            x20 * x253 + x21 * x239 + x268,
            x21 * x243 + x270,
            x21 * x245 + x272,
            x21 * x247 + x274,
            x21 * x249 + x275,
            x21 * x251 + x276,
            x21 * x253 + x277,
            x0 * x134 + x0 * (x134 + x221 * x278) + x143,
            x0 * x145 + x0 * (x145 + x278 * x279) + x147,
            x0 * x151 + x0 * (x151 + x223 * x280) + x155,
            x0 * x156 + x0 * (x156 + x278 * x71) + x159,
            x0 * x160 + x0 * (x160 + x280 * x74) + x162,
            x0 * x163 + x0 * (x163 + x281 * x53) + x165,
            x0 * x283 + x134 * x20 + x189,
            x0 * x284 + x145 * x20 + x193,
            x0 * x286 + x151 * x20 + x197,
            x0 * x287 + x156 * x20 + x199,
            x0 * x288 + x160 * x20 + x201,
            x0 * x289 + x163 * x20 + x203,
            x0 * x292 + x211,
            x0 * x294 + x213,
            x0 * x297 + x217,
            x0 * x299 + x218,
            x0 * x301 + x219,
            x0 * x303 + x220,
            x20 * x241 + x20 * x283 + x259,
            x20 * x244 + x20 * x284 + x262,
            x20 * x246 + x20 * x286 + x264,
            x20 * x248 + x20 * x287 + x265,
            x20 * x250 + x20 * x288 + x267,
            x20 * x252 + x20 * x289 + x268,
            x20 * x292 + x270,
            x20 * x294 + x272,
            x20 * x297 + x274,
            x20 * x299 + x275,
            x20 * x301 + x276,
            x20 * x303 + x277,
            x21 * x290 + x21 * x292 + x221 * x304,
            x21 * x293 + x21 * x294 + x279 * x304,
            x21 * x295 + x21 * x297 + x223 * x305,
            x21 * x298 + x21 * x299 + x304 * x71,
            x21 * x300 + x21 * x301 + x305 * x74,
            x15 * (3.0 * x215 + x305 * x66) + x21 * x302 + x21 * x303,
        ]
    )


def _3center2el3d_sph_123(a, A, b, B, c, C):
    """Cartesian (pd|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(4, x16)
    x18 = x13 ** (-1.5)
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x22
    x24 = x2 * x23
    x25 = 2.0 * x18 * x24
    x26 = x17 * x25
    x27 = c ** (-1.0)
    x28 = x13 ** (-0.5)
    x29 = boys(3, x16)
    x30 = x5 * (2.0 * x19 * x2 * x22 * x27 * x28 * x29 - x26)
    x31 = -x3 - A[0]
    x32 = -2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x31 + x26 * x4
    x33 = -x32
    x34 = boys(5, x16)
    x35 = x25 * x34
    x36 = 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x31 - x35 * x4
    x37 = c * x14
    x38 = x36 * x37
    x39 = x30 + x31 * x33 - x38 * x4
    x40 = x39 * x4
    x41 = x33 * x5
    x42 = 2.0 * x41
    x43 = x40 + x42
    x44 = x15 * x4
    x45 = x33 * x4
    x46 = 2.0 * x5
    x47 = x27 * x29 * x46
    x48 = x24 * x28 * x47
    x49 = x45 + x48
    x50 = x15 * x46
    x51 = x43 * x44 + x49 * x50
    x52 = x23 * x47
    x53 = x18 * x52
    x54 = x4 * x53 + x44 * x49
    x55 = x15 * (x44 * x51 + x50 * x54)
    x56 = x1 * x13 ** (-2.5) * x52
    x57 = x44 * x54 + x56 * x6
    x58 = x0 * x15
    x59 = x5 * (2.0 * x17 * x19 * x2 * x22 * x27 * x28 - x35)
    x60 = x25 * boys(6, x16)
    x61 = x37 * x4
    x62 = (
        x31 * x39
        + x46 * (-x32 - x38)
        - x61
        * (
            x31 * x36
            + x59
            - x61 * (2.0 * x19 * x2 * x22 * x27 * x28 * x31 * x34 - x4 * x60)
        )
    )
    x63 = x4 * x62
    x64 = x39 * x5
    x65 = 3.0 * x64
    x66 = x15 * x5
    x67 = 3.0 * x66
    x68 = x15 * x8
    x69 = x40 * x68 + x42 * x68
    x70 = x53 * x8
    x71 = x45 * x68 + x70
    x72 = x15 * (x44 * x69 + x50 * x71)
    x73 = x4 * x8
    x74 = x44 * x71 + x56 * x73
    x75 = x11 * x15
    x76 = x40 * x75 + x42 * x75
    x77 = x11 * x53
    x78 = x45 * x75 + x77
    x79 = x15 * (x44 * x76 + x50 * x78)
    x80 = x11 * x56
    x81 = x4 * x80 + x44 * x78
    x82 = x1**2 / x13**2
    x83 = x82 * x9
    x84 = x15 * (x40 * x83 + x42 * x83)
    x85 = x56 * x9
    x86 = x45 * x83 + x85
    x87 = x8 * x82
    x88 = x11 * x87
    x89 = x15 * (x40 * x88 + x42 * x88)
    x90 = x8 * x80
    x91 = x45 * x88 + x90
    x92 = x12 * x82
    x93 = x15 * (x40 * x92 + x42 * x92)
    x94 = x12 * x56
    x95 = x45 * x92 + x94
    x96 = x1**3 / x13**3
    x97 = x8**3 * x96
    x98 = x39 * x97
    x99 = x0 * x33
    x100 = x9 * x96
    x101 = x100 * x11
    x102 = x101 * x39
    x103 = x12 * x96
    x104 = x103 * x8
    x105 = x104 * x39
    x106 = x11**3 * x96
    x107 = x106 * x39
    x108 = -x7 - A[1]
    x109 = -2.0 * x108 * x19 * x2 * x22 * x27 * x28 * x29 + x26 * x8
    x110 = -x109
    x111 = x110 * x5
    x112 = 2.0 * x108 * x17 * x19 * x2 * x22 * x27 * x28 - x35 * x8
    x113 = x112 * x37
    x114 = x110 * x31 - x113 * x4
    x115 = x114 * x4
    x116 = x111 + x115
    x117 = x111 * x44 + x116 * x44
    x118 = x6 * x82
    x119 = x15 * (x111 * x118 + x117 * x44)
    x120 = x15 * x20
    x121 = x119 + x120 * x57
    x122 = x5 * (-x109 - x113)
    x123 = 2.0 * x108 * x19 * x2 * x22 * x27 * x28 * x34 - x60 * x8
    x124 = x114 * x31 + x122 - x61 * (x112 * x31 - x123 * x61)
    x125 = x124 * x4
    x126 = x114 * x5
    x127 = 2.0 * x126
    x128 = x15 * (x117 * x50 + x44 * (x116 * x50 + x44 * (x125 + x127)))
    x129 = x110 * x8
    x130 = x129 + x48
    x131 = x130 * x15
    x132 = x114 * x8
    x133 = x132 + x41
    x134 = x131 * x5 + x133 * x44
    x135 = x4 * x82
    x136 = x135 * x5
    x137 = x15 * (x130 * x136 + x134 * x44)
    x138 = x120 * x74 + x137
    x139 = x124 * x8
    x140 = x139 + x64
    x141 = x133 * x50
    x142 = x15 * (x134 * x50 + x44 * (x140 * x44 + x141))
    x143 = x111 * x75
    x144 = x115 * x75 + x143
    x145 = x11 * x135
    x146 = x15 * (x111 * x145 + x144 * x44)
    x147 = x120 * x81 + x146
    x148 = x127 * x75
    x149 = x15 * (x144 * x50 + x44 * (x125 * x75 + x148))
    x150 = x131 * x8 + x70
    x151 = x133 * x68 + x41 * x68
    x152 = x15 * (x150 * x66 + x151 * x44)
    x153 = x120 * x86 + x152
    x154 = x140 * x68 + x64 * x68
    x155 = x151 * x50
    x156 = x15 * (x154 * x44 + x155)
    x157 = x129 * x75 + x77
    x158 = x41 * x75
    x159 = x132 * x75 + x158
    x160 = x15 * (x157 * x66 + x159 * x44)
    x161 = x120 * x91 + x160
    x162 = x64 * x75
    x163 = x139 * x75 + x162
    x164 = x159 * x50
    x165 = x15 * (x163 * x44 + x164)
    x166 = x111 * x92
    x167 = x15 * (x115 * x92 + x166)
    x168 = x120 * x95 + x167
    x169 = x127 * x92
    x170 = x15 * (x125 * x92 + x169)
    x171 = x15 * (x151 * x68 + x41 * x83)
    x172 = x20 * x33
    x173 = x171 + x172 * x97
    x174 = x15 * (x154 * x68 + x64 * x83)
    x175 = x15 * (x159 * x68 + x41 * x88)
    x176 = x101 * x172 + x175
    x177 = x15 * (x163 * x68 + x64 * x88)
    x178 = x41 * x92
    x179 = x15 * (x132 * x92 + x178)
    x180 = x104 * x172 + x179
    x181 = x64 * x92
    x182 = x15 * (x139 * x92 + x181)
    x183 = x106 * x114
    x184 = x106 * x172 + x183
    x185 = x106 * x124
    x186 = -x10 - A[2]
    x187 = x11 * x26 - 2.0 * x186 * x19 * x2 * x22 * x27 * x28 * x29
    x188 = -x187
    x189 = x188 * x5
    x190 = -x11 * x35 + 2.0 * x17 * x186 * x19 * x2 * x22 * x27 * x28
    x191 = x190 * x37
    x192 = x188 * x31 - x191 * x4
    x193 = x192 * x4
    x194 = x189 + x193
    x195 = x189 * x44 + x194 * x44
    x196 = x15 * (x118 * x189 + x195 * x44)
    x197 = x15 * x21
    x198 = x196 + x197 * x57
    x199 = x5 * (-x187 - x191)
    x200 = -x11 * x60 + 2.0 * x186 * x19 * x2 * x22 * x27 * x28 * x34
    x201 = x192 * x31 + x199 - x61 * (x190 * x31 - x200 * x61)
    x202 = x201 * x4
    x203 = x192 * x5
    x204 = 2.0 * x203
    x205 = x15 * (x195 * x50 + x44 * (x194 * x50 + x44 * (x202 + x204)))
    x206 = x189 * x68
    x207 = x193 * x68 + x206
    x208 = x4 * x87
    x209 = x15 * (x189 * x208 + x207 * x44)
    x210 = x197 * x74 + x209
    x211 = x15 * (x207 * x50 + x44 * (x202 * x68 + x204 * x68))
    x212 = x11 * x188 + x48
    x213 = x212 * x66
    x214 = x11 * x192 + x41
    x215 = x213 + x214 * x44
    x216 = x15 * (x136 * x212 + x215 * x44)
    x217 = x197 * x81 + x216
    x218 = x11 * x201 + x64
    x219 = x214 * x50
    x220 = x15 * (x215 * x50 + x44 * (x218 * x44 + x219))
    x221 = x189 * x83
    x222 = x15 * (x193 * x83 + x221)
    x223 = x197 * x86 + x222
    x224 = x15 * (x202 * x83 + x204 * x83)
    x225 = x5 * x87
    x226 = x212 * x225
    x227 = x15 * (x208 * x214 + x226)
    x228 = x197 * x91 + x227
    x229 = x15 * (x208 * x218 + x214 * x46 * x87)
    x230 = x212 * x75 + x77
    x231 = x230 * x66
    x232 = x158 + x214 * x75
    x233 = x15 * (x231 + x232 * x44)
    x234 = x197 * x95 + x233
    x235 = x162 + x218 * x75
    x236 = x232 * x50
    x237 = x15 * (x235 * x44 + x236)
    x238 = x192 * x97
    x239 = x21 * x33
    x240 = x238 + x239 * x97
    x241 = x201 * x97
    x242 = x100 * x214
    x243 = x101 * x239 + x242
    x244 = x100 * x218
    x245 = x232 * x87
    x246 = x104 * x239 + x245
    x247 = x235 * x87
    x248 = x15 * (x178 + x232 * x75)
    x249 = x106 * x239 + x248
    x250 = x15 * (x181 + x235 * x75)
    x251 = x108 * x110 - x113 * x8 + x30
    x252 = x251 * x5
    x253 = x37 * x8
    x254 = x108 * x112 - x123 * x253 + x59
    x255 = x251 * x31 - x254 * x61
    x256 = x255 * x4
    x257 = x119 * x20 + x15 * (x118 * x252 + x44 * (x252 * x44 + x44 * (x252 + x256)))
    x258 = x251 * x8
    x259 = 2.0 * x111
    x260 = x258 + x259
    x261 = x260 * x66
    x262 = x255 * x8
    x263 = x127 + x262
    x264 = x137 * x20 + x15 * (x136 * x260 + x44 * (x261 + x263 * x44))
    x265 = x252 * x75
    x266 = x146 * x20 + x15 * (x145 * x252 + x44 * (x256 * x75 + x265))
    x267 = x131 * x46 + x260 * x68
    x268 = x267 * x66
    x269 = x141 + x263 * x68
    x270 = x15 * (x268 + x269 * x44) + x152 * x20
    x271 = x258 * x75 + x259 * x75
    x272 = x271 * x66
    x273 = x148 + x262 * x75
    x274 = x15 * (x272 + x273 * x44) + x160 * x20
    x275 = x252 * x92
    x276 = x15 * (x256 * x92 + x275) + x167 * x20
    x277 = x15 * (x155 + x269 * x68) + x171 * x20
    x278 = x15 * (x164 + x273 * x68) + x175 * x20
    x279 = x15 * (x169 + x262 * x92) + x179 * x20
    x280 = x106 * x255 + x183 * x20
    x281 = x108 * x188 - x191 * x8
    x282 = x281 * x5
    x283 = x108 * x190 - x200 * x253
    x284 = x281 * x31 - x283 * x61
    x285 = x15 * (x118 * x282 + x44 * (x282 * x44 + x44 * (x282 + x284 * x4)))
    x286 = x119 * x21 + x285
    x287 = x189 + x281 * x8
    x288 = x203 + x284 * x8
    x289 = x15 * (x136 * x287 + x44 * (x287 * x66 + x288 * x44))
    x290 = x137 * x21 + x289
    x291 = x11 * x281 + x111
    x292 = x11 * x284 + x126
    x293 = x15 * (x136 * x291 + x44 * (x291 * x66 + x292 * x44))
    x294 = x146 * x21 + x293
    x295 = x206 + x287 * x68
    x296 = x203 * x68 + x288 * x68
    x297 = x15 * (x295 * x66 + x296 * x44)
    x298 = x152 * x21 + x297
    x299 = x213 + x291 * x68
    x300 = x214 * x66 + x292 * x68
    x301 = x15 * (x299 * x66 + x300 * x44)
    x302 = x160 * x21 + x301
    x303 = x143 + x291 * x75
    x304 = x126 * x75 + x292 * x75
    x305 = x15 * (x303 * x66 + x304 * x44)
    x306 = x167 * x21 + x305
    x307 = x15 * (x203 * x83 + x296 * x68)
    x308 = x171 * x21 + x307
    x309 = x15 * (x214 * x225 + x300 * x68)
    x310 = x175 * x21 + x309
    x311 = x15 * (x232 * x66 + x304 * x68)
    x312 = x179 * x21 + x311
    x313 = x15 * (x126 * x92 + x304 * x75)
    x314 = x183 * x21 + x313
    x315 = -x11 * x191 + x186 * x188 + x30
    x316 = x315 * x5
    x317 = x11 * x37
    x318 = x186 * x190 - x200 * x317 + x59
    x319 = x31 * x315 - x318 * x61
    x320 = x319 * x4
    x321 = x15 * (x118 * x316 + x44 * (x316 * x44 + x44 * (x316 + x320))) + x196 * x21
    x322 = x316 * x68
    x323 = x15 * (x208 * x316 + x44 * (x320 * x68 + x322)) + x209 * x21
    x324 = x11 * x315 + 2.0 * x189
    x325 = x324 * x66
    x326 = x11 * x319 + x204
    x327 = x15 * (x136 * x324 + x44 * (x325 + x326 * x44)) + x21 * x216
    x328 = x316 * x83
    x329 = x15 * (x320 * x83 + x328) + x21 * x222
    x330 = x225 * x324
    x331 = x15 * (x208 * x326 + x330) + x21 * x227
    x332 = x212 * x50 + x324 * x75
    x333 = x332 * x66
    x334 = x219 + x326 * x75
    x335 = x15 * (x333 + x334 * x44) + x21 * x233
    x336 = x21 * x238 + x319 * x97
    x337 = x100 * x326 + x21 * x242
    x338 = x21 * x245 + x334 * x87
    x339 = x15 * (x236 + x334 * x75) + x21 * x248
    x340 = x4**3 * x96
    x341 = x0 * x110
    x342 = x6 * x96
    x343 = x130 * x342
    x344 = x11 * x342
    x345 = x0 * x135
    x346 = x103 * x4
    x347 = x150 * x68 + x85
    x348 = x157 * x68 + x90
    x349 = x129 * x92 + x94
    x350 = x251 * x340
    x351 = x110 * x20
    x352 = x340 * x351 + x350
    x353 = x260 * x342
    x354 = x20 * x343 + x353
    x355 = x251 * x344
    x356 = x344 * x351 + x355
    x357 = x135 * x267
    x358 = x135 * x20
    x359 = x150 * x358 + x357
    x360 = x135 * x271
    x361 = x157 * x358 + x360
    x362 = x251 * x346
    x363 = x346 * x351 + x362
    x364 = x15 * (x150 * x50 + x267 * x68)
    x365 = x120 * x347 + x364
    x366 = x15 * (x157 * x50 + x271 * x68)
    x367 = x120 * x348 + x366
    x368 = x15 * (x258 * x92 + x259 * x92)
    x369 = x120 * x349 + x368
    x370 = x106 * x251
    x371 = x106 * x351 + x370
    x372 = x281 * x340
    x373 = x110 * x21
    x374 = x340 * x373 + x372
    x375 = x287 * x342
    x376 = x21 * x343 + x375
    x377 = x291 * x342
    x378 = x344 * x373 + x377
    x379 = x135 * x295
    x380 = x135 * x21
    x381 = x150 * x380 + x379
    x382 = x135 * x299
    x383 = x157 * x380 + x382
    x384 = x135 * x303
    x385 = x346 * x373 + x384
    x386 = x15 * (x221 + x295 * x68)
    x387 = x197 * x347 + x386
    x388 = x15 * (x226 + x299 * x68)
    x389 = x197 * x348 + x388
    x390 = x15 * (x231 + x303 * x68)
    x391 = x197 * x349 + x390
    x392 = x15 * (x166 + x303 * x75)
    x393 = x106 * x373 + x392
    x394 = x108 * x251 + 2.0 * x122 - x253 * x254
    x395 = x394 * x8
    x396 = 3.0 * x252
    x397 = x395 + x396
    x398 = 3.0 * x261 + x397 * x68
    x399 = x395 * x75 + x396 * x75
    x400 = x108 * x281 + x199 - x253 * x283
    x401 = x340 * x400
    x402 = 2.0 * x282
    x403 = x400 * x8 + x402
    x404 = x342 * x403
    x405 = x11 * x400 + x252
    x406 = x342 * x405
    x407 = x287 * x50 + x403 * x68
    x408 = x135 * x407
    x409 = x291 * x50
    x410 = x405 * x68 + x409
    x411 = x135 * x410
    x412 = x265 + x405 * x75
    x413 = x135 * x412
    x414 = x15 * (x295 * x50 + x407 * x68)
    x415 = x15 * (x299 * x50 + x410 * x68)
    x416 = x303 * x50
    x417 = x15 * (x412 * x68 + x416)
    x418 = x15 * (x275 + x412 * x75)
    x419 = x108 * x315 - x253 * x318
    x420 = x21 * x372 + x340 * x419
    x421 = x316 + x419 * x8
    x422 = x21 * x375 + x342 * x421
    x423 = x11 * x419 + x402
    x424 = x21 * x377 + x342 * x423
    x425 = x322 + x421 * x68
    x426 = x135 * x425 + x21 * x379
    x427 = x325 + x423 * x68
    x428 = x135 * x427 + x21 * x382
    x429 = x409 + x423 * x75
    x430 = x135 * x429 + x21 * x384
    x431 = x15 * (x328 + x425 * x68) + x21 * x386
    x432 = x15 * (x330 + x427 * x68) + x21 * x388
    x433 = x15 * (x333 + x429 * x68) + x21 * x390
    x434 = x15 * (x416 + x429 * x75) + x21 * x392
    x435 = x0 * x188
    x436 = x342 * x8
    x437 = x0 * x212
    x438 = x100 * x4
    x439 = x73 * x96
    x440 = x230 * x87
    x441 = x230 * x75 + x94
    x442 = x188 * x20
    x443 = x340 * x442 + x372
    x444 = x375 + x436 * x442
    x445 = x20 * x212
    x446 = x342 * x445 + x377
    x447 = x379 + x438 * x442
    x448 = x382 + x439 * x445
    x449 = x230 * x358 + x384
    x450 = x386 + x442 * x97
    x451 = x100 * x445 + x388
    x452 = x20 * x440 + x390
    x453 = x120 * x441 + x392
    x454 = x315 * x340
    x455 = x188 * x21
    x456 = x340 * x455 + x454
    x457 = x315 * x436
    x458 = x436 * x455 + x457
    x459 = x324 * x342
    x460 = x21 * x212
    x461 = x342 * x460 + x459
    x462 = x315 * x438
    x463 = x438 * x455 + x462
    x464 = x324 * x439
    x465 = x439 * x460 + x464
    x466 = x135 * x332
    x467 = x230 * x380 + x466
    x468 = x315 * x97
    x469 = x455 * x97 + x468
    x470 = x100 * x324
    x471 = x100 * x460 + x470
    x472 = x332 * x87
    x473 = x21 * x440 + x472
    x474 = x15 * (x230 * x50 + x332 * x75)
    x475 = x197 * x441 + x474
    x476 = x186 * x315 + 2.0 * x199 - x317 * x318
    x477 = x11 * x476 + 3.0 * x316
    x478 = 3.0 * x325 + x477 * x75

    # 180 item(s)
    return numpy.array(
        [
            x0 * x55
            + x0 * (x55 + x57 * x58)
            + x15 * (x44 * (x43 * x67 + x44 * (x63 + x65)) + x51 * x67),
            x0 * x72
            + x0 * (x58 * x74 + x72)
            + x15 * (x44 * (x63 * x68 + x65 * x68) + x67 * x69),
            x0 * x79
            + x0 * (x58 * x81 + x79)
            + x15 * (x44 * (x63 * x75 + x65 * x75) + x67 * x76),
            x0 * x84 + x0 * (x58 * x86 + x84) + x15 * (x63 * x83 + x65 * x83),
            x0 * x89 + x0 * (x58 * x91 + x89) + x15 * (x63 * x88 + x65 * x88),
            x0 * x93 + x0 * (x58 * x95 + x93) + x15 * (x63 * x92 + x65 * x92),
            x0 * x98 + x0 * (x97 * x99 + x98) + x62 * x97,
            x0 * x102 + x0 * (x101 * x99 + x102) + x101 * x62,
            x0 * x105 + x0 * (x104 * x99 + x105) + x104 * x62,
            x0 * x107 + x0 * (x106 * x99 + x107) + x106 * x62,
            x0 * x121 + x128 + x20 * x55,
            x0 * x138 + x142 + x20 * x72,
            x0 * x147 + x149 + x20 * x79,
            x0 * x153 + x156 + x20 * x84,
            x0 * x161 + x165 + x20 * x89,
            x0 * x168 + x170 + x20 * x93,
            x0 * x173 + x174 + x20 * x98,
            x0 * x176 + x102 * x20 + x177,
            x0 * x180 + x105 * x20 + x182,
            x0 * x184 + x107 * x20 + x185,
            x0 * x198 + x205 + x21 * x55,
            x0 * x210 + x21 * x72 + x211,
            x0 * x217 + x21 * x79 + x220,
            x0 * x223 + x21 * x84 + x224,
            x0 * x228 + x21 * x89 + x229,
            x0 * x234 + x21 * x93 + x237,
            x0 * x240 + x21 * x98 + x241,
            x0 * x243 + x102 * x21 + x244,
            x0 * x246 + x105 * x21 + x247,
            x0 * x249 + x107 * x21 + x250,
            x121 * x20 + x257,
            x138 * x20 + x264,
            x147 * x20 + x266,
            x153 * x20 + x270,
            x161 * x20 + x274,
            x168 * x20 + x276,
            x173 * x20 + x277,
            x176 * x20 + x278,
            x180 * x20 + x279,
            x184 * x20 + x280,
            x198 * x20 + x286,
            x20 * x210 + x290,
            x20 * x217 + x294,
            x20 * x223 + x298,
            x20 * x228 + x302,
            x20 * x234 + x306,
            x20 * x240 + x308,
            x20 * x243 + x310,
            x20 * x246 + x312,
            x20 * x249 + x314,
            x198 * x21 + x321,
            x21 * x210 + x323,
            x21 * x217 + x327,
            x21 * x223 + x329,
            x21 * x228 + x331,
            x21 * x234 + x335,
            x21 * x240 + x336,
            x21 * x243 + x337,
            x21 * x246 + x338,
            x21 * x249 + x339,
            x0 * x119 + x0 * (x119 + x340 * x341) + x128,
            x0 * x137 + x0 * (x0 * x343 + x137) + x142,
            x0 * x146 + x0 * (x146 + x341 * x344) + x149,
            x0 * x152 + x0 * (x150 * x345 + x152) + x156,
            x0 * x160 + x0 * (x157 * x345 + x160) + x165,
            x0 * x167 + x0 * (x167 + x341 * x346) + x170,
            x0 * x171 + x0 * (x171 + x347 * x58) + x174,
            x0 * x175 + x0 * (x175 + x348 * x58) + x177,
            x0 * x179 + x0 * (x179 + x349 * x58) + x182,
            x0 * x183 + x0 * (x106 * x341 + x183) + x185,
            x0 * x352 + x257,
            x0 * x354 + x264,
            x0 * x356 + x266,
            x0 * x359 + x270,
            x0 * x361 + x274,
            x0 * x363 + x276,
            x0 * x365 + x277,
            x0 * x367 + x278,
            x0 * x369 + x279,
            x0 * x371 + x280,
            x0 * x374 + x286,
            x0 * x376 + x290,
            x0 * x378 + x294,
            x0 * x381 + x298,
            x0 * x383 + x302,
            x0 * x385 + x306,
            x0 * x387 + x308,
            x0 * x389 + x310,
            x0 * x391 + x312,
            x0 * x393 + x314,
            x20 * x350 + x20 * x352 + x340 * x394,
            x20 * x353 + x20 * x354 + x342 * x397,
            x20 * x355 + x20 * x356 + x344 * x394,
            x135 * x398 + x20 * x357 + x20 * x359,
            x135 * x399 + x20 * x360 + x20 * x361,
            x20 * x362 + x20 * x363 + x346 * x394,
            x15 * (3.0 * x268 + x398 * x68) + x20 * x364 + x20 * x365,
            x15 * (3.0 * x272 + x399 * x68) + x20 * x366 + x20 * x367,
            x15 * (x395 * x92 + x396 * x92) + x20 * x368 + x20 * x369,
            x106 * x394 + x20 * x370 + x20 * x371,
            x20 * x374 + x21 * x350 + x401,
            x20 * x376 + x21 * x353 + x404,
            x20 * x378 + x21 * x355 + x406,
            x20 * x381 + x21 * x357 + x408,
            x20 * x383 + x21 * x360 + x411,
            x20 * x385 + x21 * x362 + x413,
            x20 * x387 + x21 * x364 + x414,
            x20 * x389 + x21 * x366 + x415,
            x20 * x391 + x21 * x368 + x417,
            x20 * x393 + x21 * x370 + x418,
            x21 * x374 + x420,
            x21 * x376 + x422,
            x21 * x378 + x424,
            x21 * x381 + x426,
            x21 * x383 + x428,
            x21 * x385 + x430,
            x21 * x387 + x431,
            x21 * x389 + x432,
            x21 * x391 + x433,
            x21 * x393 + x434,
            x0 * x196 + x0 * (x196 + x340 * x435) + x205,
            x0 * x209 + x0 * (x209 + x435 * x436) + x211,
            x0 * x216 + x0 * (x216 + x342 * x437) + x220,
            x0 * x222 + x0 * (x222 + x435 * x438) + x224,
            x0 * x227 + x0 * (x227 + x437 * x439) + x229,
            x0 * x233 + x0 * (x230 * x345 + x233) + x237,
            x0 * x238 + x0 * (x238 + x435 * x97) + x241,
            x0 * x242 + x0 * (x100 * x437 + x242) + x244,
            x0 * x245 + x0 * (x0 * x440 + x245) + x247,
            x0 * x248 + x0 * (x248 + x441 * x58) + x250,
            x0 * x443 + x196 * x20 + x285,
            x0 * x444 + x20 * x209 + x289,
            x0 * x446 + x20 * x216 + x293,
            x0 * x447 + x20 * x222 + x297,
            x0 * x448 + x20 * x227 + x301,
            x0 * x449 + x20 * x233 + x305,
            x0 * x450 + x20 * x238 + x307,
            x0 * x451 + x20 * x242 + x309,
            x0 * x452 + x20 * x245 + x311,
            x0 * x453 + x20 * x248 + x313,
            x0 * x456 + x321,
            x0 * x458 + x323,
            x0 * x461 + x327,
            x0 * x463 + x329,
            x0 * x465 + x331,
            x0 * x467 + x335,
            x0 * x469 + x336,
            x0 * x471 + x337,
            x0 * x473 + x338,
            x0 * x475 + x339,
            x20 * x372 + x20 * x443 + x401,
            x20 * x375 + x20 * x444 + x404,
            x20 * x377 + x20 * x446 + x406,
            x20 * x379 + x20 * x447 + x408,
            x20 * x382 + x20 * x448 + x411,
            x20 * x384 + x20 * x449 + x413,
            x20 * x386 + x20 * x450 + x414,
            x20 * x388 + x20 * x451 + x415,
            x20 * x390 + x20 * x452 + x417,
            x20 * x392 + x20 * x453 + x418,
            x20 * x456 + x420,
            x20 * x458 + x422,
            x20 * x461 + x424,
            x20 * x463 + x426,
            x20 * x465 + x428,
            x20 * x467 + x430,
            x20 * x469 + x431,
            x20 * x471 + x432,
            x20 * x473 + x433,
            x20 * x475 + x434,
            x21 * x454 + x21 * x456 + x340 * x476,
            x21 * x457 + x21 * x458 + x436 * x476,
            x21 * x459 + x21 * x461 + x342 * x477,
            x21 * x462 + x21 * x463 + x438 * x476,
            x21 * x464 + x21 * x465 + x439 * x477,
            x135 * x478 + x21 * x466 + x21 * x467,
            x21 * x468 + x21 * x469 + x476 * x97,
            x100 * x477 + x21 * x470 + x21 * x471,
            x21 * x472 + x21 * x473 + x478 * x87,
            x15 * (3.0 * x333 + x478 * x75) + x21 * x474 + x21 * x475,
        ]
    )


def _3center2el3d_sph_124(a, A, b, B, c, C):
    """Cartesian (pd|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(5, x16)
    x18 = x13 ** (-1.5)
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x22
    x24 = x2 * x23
    x25 = 2.0 * x18 * x24
    x26 = x17 * x25
    x27 = c ** (-1.0)
    x28 = x13 ** (-0.5)
    x29 = boys(4, x16)
    x30 = x5 * (2.0 * x19 * x2 * x22 * x27 * x28 * x29 - x26)
    x31 = -x3 - A[0]
    x32 = -2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x31 + x26 * x4
    x33 = -x32
    x34 = boys(6, x16)
    x35 = x25 * x34
    x36 = 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x31 - x35 * x4
    x37 = c * x14
    x38 = x36 * x37
    x39 = x30 + x31 * x33 - x38 * x4
    x40 = x39 * x4
    x41 = x33 * x5
    x42 = 2.0 * x41
    x43 = x40 + x42
    x44 = x15 * x4
    x45 = x33 * x4
    x46 = 2.0 * x5
    x47 = x27 * x29 * x46
    x48 = x24 * x28 * x47
    x49 = x45 + x48
    x50 = x15 * x46
    x51 = x43 * x44 + x49 * x50
    x52 = x23 * x47
    x53 = x18 * x52
    x54 = x4 * x53 + x44 * x49
    x55 = x44 * x51 + x50 * x54
    x56 = x52 * x6
    x57 = x1 * x13 ** (-2.5)
    x58 = x44 * x54 + x56 * x57
    x59 = x15 * (x44 * x55 + x50 * x58)
    x60 = x4**3
    x61 = x1**2
    x62 = x13 ** (-3.5) * x61
    x63 = x52 * x62
    x64 = x44 * x58 + x60 * x63
    x65 = x0 * x15
    x66 = x5 * (2.0 * x17 * x19 * x2 * x22 * x27 * x28 - x35)
    x67 = x25 * boys(7, x16)
    x68 = x37 * x4
    x69 = (
        x31 * x39
        + x46 * (-x32 - x38)
        - x68
        * (
            x31 * x36
            + x66
            - x68 * (2.0 * x19 * x2 * x22 * x27 * x28 * x31 * x34 - x4 * x67)
        )
    )
    x70 = x4 * x69
    x71 = x39 * x5
    x72 = 3.0 * x71
    x73 = x15 * x5
    x74 = 3.0 * x73
    x75 = x15 * x8
    x76 = x40 * x75 + x42 * x75
    x77 = x53 * x8
    x78 = x45 * x75 + x77
    x79 = x44 * x76 + x50 * x78
    x80 = x52 * x57
    x81 = x4 * x80
    x82 = x44 * x78 + x8 * x81
    x83 = x15 * (x44 * x79 + x50 * x82)
    x84 = x56 * x62
    x85 = x44 * x82 + x8 * x84
    x86 = x11 * x15
    x87 = x40 * x86 + x42 * x86
    x88 = x11 * x53
    x89 = x45 * x86 + x88
    x90 = x44 * x87 + x50 * x89
    x91 = x11 * x81 + x44 * x89
    x92 = x15 * (x44 * x90 + x50 * x91)
    x93 = x11 * x84 + x44 * x91
    x94 = x61 / x13**2
    x95 = x9 * x94
    x96 = x40 * x95 + x42 * x95
    x97 = x80 * x9
    x98 = x45 * x95 + x97
    x99 = x15 * (x44 * x96 + x50 * x98)
    x100 = x63 * x9
    x101 = x100 * x4 + x44 * x98
    x102 = x8 * x94
    x103 = x102 * x11
    x104 = x103 * x40 + x103 * x42
    x105 = x11 * x8
    x106 = x105 * x80
    x107 = x103 * x45 + x106
    x108 = x15 * (x104 * x44 + x107 * x50)
    x109 = x105 * x4 * x63 + x107 * x44
    x110 = x12 * x94
    x111 = x110 * x40 + x110 * x42
    x112 = x12 * x80
    x113 = x110 * x45 + x112
    x114 = x15 * (x111 * x44 + x113 * x50)
    x115 = x12 * x4
    x116 = x113 * x44 + x115 * x63
    x117 = x8**3
    x118 = x1**3 / x13**3
    x119 = x117 * x118
    x120 = x15 * (x119 * x40 + x119 * x42)
    x121 = x117 * x63
    x122 = x119 * x45 + x121
    x123 = x118 * x9
    x124 = x11 * x123
    x125 = x15 * (x124 * x40 + x124 * x42)
    x126 = x100 * x11
    x127 = x124 * x45 + x126
    x128 = x118 * x8
    x129 = x12 * x128
    x130 = x15 * (x129 * x40 + x129 * x42)
    x131 = x12 * x63 * x8
    x132 = x129 * x45 + x131
    x133 = x11**3
    x134 = x118 * x133
    x135 = x15 * (x134 * x40 + x134 * x42)
    x136 = x133 * x63
    x137 = x134 * x45 + x136
    x138 = x1**4 / x13**4
    x139 = x138 * x8**4
    x140 = x139 * x39
    x141 = x0 * x33
    x142 = x117 * x138
    x143 = x11 * x142
    x144 = x143 * x39
    x145 = x138 * x39
    x146 = x12 * x9
    x147 = x145 * x146
    x148 = x138 * x141
    x149 = x138 * x69
    x150 = x133 * x8
    x151 = x145 * x150
    x152 = x11**4 * x138
    x153 = x152 * x39
    x154 = -x7 - A[1]
    x155 = -2.0 * x154 * x19 * x2 * x22 * x27 * x28 * x29 + x26 * x8
    x156 = -x155
    x157 = x156 * x5
    x158 = 2.0 * x154 * x17 * x19 * x2 * x22 * x27 * x28 - x35 * x8
    x159 = x158 * x37
    x160 = x156 * x31 - x159 * x4
    x161 = x160 * x4
    x162 = x157 + x161
    x163 = x157 * x44 + x162 * x44
    x164 = x6 * x94
    x165 = x157 * x164 + x163 * x44
    x166 = x118 * x60
    x167 = x15 * (x157 * x166 + x165 * x44)
    x168 = x15 * x20
    x169 = x167 + x168 * x64
    x170 = x5 * (-x155 - x159)
    x171 = 2.0 * x154 * x19 * x2 * x22 * x27 * x28 * x34 - x67 * x8
    x172 = x160 * x31 + x170 - x68 * (x158 * x31 - x171 * x68)
    x173 = x172 * x4
    x174 = x160 * x5
    x175 = 2.0 * x174
    x176 = x15 * (
        x165 * x50 + x44 * (x163 * x50 + x44 * (x162 * x50 + x44 * (x173 + x175)))
    )
    x177 = x156 * x8
    x178 = x177 + x48
    x179 = x15 * x178
    x180 = x160 * x8
    x181 = x180 + x41
    x182 = x179 * x5 + x181 * x44
    x183 = x4 * x94
    x184 = x178 * x5
    x185 = x182 * x44 + x183 * x184
    x186 = x118 * x6
    x187 = x15 * (x184 * x186 + x185 * x44)
    x188 = x168 * x85 + x187
    x189 = x172 * x8
    x190 = x189 + x71
    x191 = x181 * x50
    x192 = x15 * (x185 * x50 + x44 * (x182 * x50 + x44 * (x190 * x44 + x191)))
    x193 = x157 * x86
    x194 = x161 * x86 + x193
    x195 = x11 * x157
    x196 = x183 * x195 + x194 * x44
    x197 = x15 * (x186 * x195 + x196 * x44)
    x198 = x168 * x93 + x197
    x199 = x175 * x86
    x200 = x15 * (x196 * x50 + x44 * (x194 * x50 + x44 * (x173 * x86 + x199)))
    x201 = x179 * x8 + x77
    x202 = x181 * x75 + x41 * x75
    x203 = x201 * x73 + x202 * x44
    x204 = x183 * x5
    x205 = x15 * (x201 * x204 + x203 * x44)
    x206 = x101 * x168 + x205
    x207 = x190 * x75 + x71 * x75
    x208 = x202 * x50
    x209 = x15 * (x203 * x50 + x44 * (x207 * x44 + x208))
    x210 = x177 * x86 + x88
    x211 = x41 * x86
    x212 = x180 * x86 + x211
    x213 = x210 * x73 + x212 * x44
    x214 = x15 * (x204 * x210 + x213 * x44)
    x215 = x109 * x168 + x214
    x216 = x71 * x86
    x217 = x189 * x86 + x216
    x218 = x212 * x50
    x219 = x15 * (x213 * x50 + x44 * (x217 * x44 + x218))
    x220 = x110 * x157
    x221 = x110 * x161 + x220
    x222 = x115 * x118
    x223 = x15 * (x157 * x222 + x221 * x44)
    x224 = x116 * x168 + x223
    x225 = x110 * x175
    x226 = x15 * (x221 * x50 + x44 * (x110 * x173 + x225))
    x227 = x201 * x75 + x97
    x228 = x202 * x75 + x41 * x95
    x229 = x15 * (x227 * x73 + x228 * x44)
    x230 = x122 * x168 + x229
    x231 = x207 * x75 + x71 * x95
    x232 = x228 * x50
    x233 = x15 * (x231 * x44 + x232)
    x234 = x106 + x210 * x75
    x235 = x103 * x41 + x212 * x75
    x236 = x15 * (x234 * x73 + x235 * x44)
    x237 = x127 * x168 + x236
    x238 = x103 * x71 + x217 * x75
    x239 = x235 * x50
    x240 = x15 * (x238 * x44 + x239)
    x241 = x110 * x177 + x112
    x242 = x110 * x41
    x243 = x110 * x180 + x242
    x244 = x15 * (x241 * x73 + x243 * x44)
    x245 = x132 * x168 + x244
    x246 = x110 * x71
    x247 = x110 * x189 + x246
    x248 = x243 * x50
    x249 = x15 * (x247 * x44 + x248)
    x250 = x134 * x157
    x251 = x15 * (x134 * x161 + x250)
    x252 = x137 * x168 + x251
    x253 = x134 * x175
    x254 = x15 * (x134 * x173 + x253)
    x255 = x15 * (x119 * x41 + x228 * x75)
    x256 = x20 * x33
    x257 = x139 * x256 + x255
    x258 = x15 * (x119 * x71 + x231 * x75)
    x259 = x15 * (x124 * x41 + x235 * x75)
    x260 = x143 * x256 + x259
    x261 = x15 * (x124 * x71 + x238 * x75)
    x262 = x15 * (x129 * x41 + x243 * x75)
    x263 = x138 * x256
    x264 = x146 * x263 + x262
    x265 = x15 * (x129 * x71 + x247 * x75)
    x266 = x134 * x41
    x267 = x15 * (x134 * x180 + x266)
    x268 = x150 * x263 + x267
    x269 = x134 * x71
    x270 = x15 * (x134 * x189 + x269)
    x271 = x152 * x160
    x272 = x152 * x256 + x271
    x273 = x152 * x172
    x274 = -x10 - A[2]
    x275 = x11 * x26 - 2.0 * x19 * x2 * x22 * x27 * x274 * x28 * x29
    x276 = -x275
    x277 = x276 * x5
    x278 = -x11 * x35 + 2.0 * x17 * x19 * x2 * x22 * x27 * x274 * x28
    x279 = x278 * x37
    x280 = x276 * x31 - x279 * x4
    x281 = x280 * x4
    x282 = x277 + x281
    x283 = x277 * x44 + x282 * x44
    x284 = x164 * x277 + x283 * x44
    x285 = x15 * (x166 * x277 + x284 * x44)
    x286 = x15 * x21
    x287 = x285 + x286 * x64
    x288 = x5 * (-x275 - x279)
    x289 = -x11 * x67 + 2.0 * x19 * x2 * x22 * x27 * x274 * x28 * x34
    x290 = x280 * x31 + x288 - x68 * (x278 * x31 - x289 * x68)
    x291 = x290 * x4
    x292 = x280 * x5
    x293 = 2.0 * x292
    x294 = x15 * (
        x284 * x50 + x44 * (x283 * x50 + x44 * (x282 * x50 + x44 * (x291 + x293)))
    )
    x295 = x277 * x75
    x296 = x281 * x75 + x295
    x297 = x102 * x4
    x298 = x277 * x297 + x296 * x44
    x299 = x186 * x8
    x300 = x15 * (x277 * x299 + x298 * x44)
    x301 = x286 * x85 + x300
    x302 = x15 * (x298 * x50 + x44 * (x296 * x50 + x44 * (x291 * x75 + x293 * x75)))
    x303 = x11 * x276 + x48
    x304 = x303 * x73
    x305 = x11 * x280 + x41
    x306 = x304 + x305 * x44
    x307 = x204 * x303 + x306 * x44
    x308 = x303 * x5
    x309 = x15 * (x186 * x308 + x307 * x44)
    x310 = x286 * x93 + x309
    x311 = x11 * x290 + x71
    x312 = x305 * x50
    x313 = x15 * (x307 * x50 + x44 * (x306 * x50 + x44 * (x311 * x44 + x312)))
    x314 = x277 * x95
    x315 = x281 * x95 + x314
    x316 = x123 * x4
    x317 = x15 * (x277 * x316 + x315 * x44)
    x318 = x101 * x286 + x317
    x319 = x15 * (x315 * x50 + x44 * (x291 * x95 + x293 * x95))
    x320 = x102 * x308
    x321 = x297 * x305 + x320
    x322 = x128 * x4
    x323 = x15 * (x308 * x322 + x321 * x44)
    x324 = x109 * x286 + x323
    x325 = x305 * x46
    x326 = x15 * (x321 * x50 + x44 * (x102 * x325 + x297 * x311))
    x327 = x303 * x86 + x88
    x328 = x327 * x73
    x329 = x211 + x305 * x86
    x330 = x328 + x329 * x44
    x331 = x15 * (x204 * x327 + x330 * x44)
    x332 = x116 * x286 + x331
    x333 = x216 + x311 * x86
    x334 = x329 * x50
    x335 = x15 * (x330 * x50 + x44 * (x333 * x44 + x334))
    x336 = x119 * x277
    x337 = x15 * (x119 * x281 + x336)
    x338 = x122 * x286 + x337
    x339 = x15 * (x119 * x291 + x119 * x293)
    x340 = x123 * x308
    x341 = x15 * (x305 * x316 + x340)
    x342 = x127 * x286 + x341
    x343 = x15 * (x123 * x325 + x311 * x316)
    x344 = x102 * x5
    x345 = x327 * x344
    x346 = x15 * (x297 * x329 + x345)
    x347 = x132 * x286 + x346
    x348 = x15 * (x102 * x329 * x46 + x297 * x333)
    x349 = x112 + x327 * x86
    x350 = x349 * x73
    x351 = x242 + x329 * x86
    x352 = x15 * (x350 + x351 * x44)
    x353 = x137 * x286 + x352
    x354 = x246 + x333 * x86
    x355 = x351 * x50
    x356 = x15 * (x354 * x44 + x355)
    x357 = x139 * x280
    x358 = x21 * x33
    x359 = x139 * x358 + x357
    x360 = x139 * x290
    x361 = x142 * x305
    x362 = x143 * x358 + x361
    x363 = x142 * x311
    x364 = x123 * x329
    x365 = x138 * x358
    x366 = x146 * x365 + x364
    x367 = x123 * x333
    x368 = x102 * x351
    x369 = x150 * x365 + x368
    x370 = x102 * x354
    x371 = x15 * (x266 + x351 * x86)
    x372 = x152 * x358 + x371
    x373 = x15 * (x269 + x354 * x86)
    x374 = x154 * x156 - x159 * x8 + x30
    x375 = x374 * x5
    x376 = x37 * x8
    x377 = x154 * x158 - x171 * x376 + x66
    x378 = x31 * x374 - x377 * x68
    x379 = x378 * x4
    x380 = (
        x15
        * (x166 * x375 + x44 * (x164 * x375 + x44 * (x375 * x44 + x44 * (x375 + x379))))
        + x167 * x20
    )
    x381 = x374 * x8
    x382 = 2.0 * x157
    x383 = x381 + x382
    x384 = x383 * x73
    x385 = x378 * x8
    x386 = x175 + x385
    x387 = x186 * x5
    x388 = (
        x15 * (x383 * x387 + x44 * (x204 * x383 + x44 * (x384 + x386 * x44))) + x187 * x20
    )
    x389 = x375 * x86
    x390 = x11 * x375
    x391 = (
        x15 * (x186 * x390 + x44 * (x183 * x390 + x44 * (x379 * x86 + x389))) + x197 * x20
    )
    x392 = x179 * x46 + x383 * x75
    x393 = x392 * x73
    x394 = x191 + x386 * x75
    x395 = x15 * (x204 * x392 + x44 * (x393 + x394 * x44)) + x20 * x205
    x396 = x381 * x86 + x382 * x86
    x397 = x396 * x73
    x398 = x199 + x385 * x86
    x399 = x15 * (x204 * x396 + x44 * (x397 + x398 * x44)) + x20 * x214
    x400 = x110 * x375
    x401 = x15 * (x222 * x375 + x44 * (x110 * x379 + x400)) + x20 * x223
    x402 = x201 * x50 + x392 * x75
    x403 = x402 * x73
    x404 = x208 + x394 * x75
    x405 = x15 * (x403 + x404 * x44) + x20 * x229
    x406 = x210 * x50 + x396 * x75
    x407 = x406 * x73
    x408 = x218 + x398 * x75
    x409 = x15 * (x407 + x408 * x44) + x20 * x236
    x410 = x110 * x381 + x110 * x382
    x411 = x410 * x73
    x412 = x110 * x385 + x225
    x413 = x15 * (x411 + x412 * x44) + x20 * x244
    x414 = x134 * x375
    x415 = x15 * (x134 * x379 + x414) + x20 * x251
    x416 = x15 * (x232 + x404 * x75) + x20 * x255
    x417 = x15 * (x239 + x408 * x75) + x20 * x259
    x418 = x15 * (x248 + x412 * x75) + x20 * x262
    x419 = x15 * (x134 * x385 + x253) + x20 * x267
    x420 = x152 * x378 + x20 * x271
    x421 = x154 * x276 - x279 * x8
    x422 = x421 * x5
    x423 = x154 * x278 - x289 * x376
    x424 = x31 * x421 - x423 * x68
    x425 = x15 * (
        x166 * x422 + x44 * (x164 * x422 + x44 * (x422 * x44 + x44 * (x4 * x424 + x422)))
    )
    x426 = x167 * x21 + x425
    x427 = x277 + x421 * x8
    x428 = x292 + x424 * x8
    x429 = x15 * (x387 * x427 + x44 * (x204 * x427 + x44 * (x427 * x73 + x428 * x44)))
    x430 = x187 * x21 + x429
    x431 = x11 * x421 + x157
    x432 = x11 * x424 + x174
    x433 = x15 * (x387 * x431 + x44 * (x204 * x431 + x44 * (x431 * x73 + x432 * x44)))
    x434 = x197 * x21 + x433
    x435 = x295 + x427 * x75
    x436 = x292 * x75 + x428 * x75
    x437 = x15 * (x204 * x435 + x44 * (x435 * x73 + x436 * x44))
    x438 = x205 * x21 + x437
    x439 = x304 + x431 * x75
    x440 = x305 * x73 + x432 * x75
    x441 = x15 * (x204 * x439 + x44 * (x439 * x73 + x44 * x440))
    x442 = x21 * x214 + x441
    x443 = x193 + x431 * x86
    x444 = x174 * x86 + x432 * x86
    x445 = x15 * (x204 * x443 + x44 * (x44 * x444 + x443 * x73))
    x446 = x21 * x223 + x445
    x447 = x314 + x435 * x75
    x448 = x292 * x95 + x436 * x75
    x449 = x15 * (x44 * x448 + x447 * x73)
    x450 = x21 * x229 + x449
    x451 = x320 + x439 * x75
    x452 = x305 * x344 + x440 * x75
    x453 = x15 * (x44 * x452 + x451 * x73)
    x454 = x21 * x236 + x453
    x455 = x328 + x443 * x75
    x456 = x329 * x73 + x444 * x75
    x457 = x15 * (x44 * x456 + x455 * x73)
    x458 = x21 * x244 + x457
    x459 = x220 + x443 * x86
    x460 = x110 * x174 + x444 * x86
    x461 = x15 * (x44 * x460 + x459 * x73)
    x462 = x21 * x251 + x461
    x463 = x15 * (x119 * x292 + x448 * x75)
    x464 = x21 * x255 + x463
    x465 = x123 * x5
    x466 = x15 * (x305 * x465 + x452 * x75)
    x467 = x21 * x259 + x466
    x468 = x15 * (x329 * x344 + x456 * x75)
    x469 = x21 * x262 + x468
    x470 = x15 * (x351 * x73 + x460 * x75)
    x471 = x21 * x267 + x470
    x472 = x15 * (x134 * x174 + x460 * x86)
    x473 = x21 * x271 + x472
    x474 = -x11 * x279 + x274 * x276 + x30
    x475 = x474 * x5
    x476 = x11 * x37
    x477 = x274 * x278 - x289 * x476 + x66
    x478 = x31 * x474 - x477 * x68
    x479 = x4 * x478
    x480 = (
        x15
        * (x166 * x475 + x44 * (x164 * x475 + x44 * (x44 * x475 + x44 * (x475 + x479))))
        + x21 * x285
    )
    x481 = x475 * x75
    x482 = (
        x15 * (x299 * x475 + x44 * (x297 * x475 + x44 * (x479 * x75 + x481))) + x21 * x300
    )
    x483 = x11 * x474 + 2.0 * x277
    x484 = x483 * x73
    x485 = x11 * x478 + x293
    x486 = (
        x15 * (x387 * x483 + x44 * (x204 * x483 + x44 * (x44 * x485 + x484))) + x21 * x309
    )
    x487 = x475 * x95
    x488 = x15 * (x316 * x475 + x44 * (x479 * x95 + x487)) + x21 * x317
    x489 = x344 * x483
    x490 = x4 * x483
    x491 = x15 * (x128 * x490 * x5 + x44 * (x297 * x485 + x489)) + x21 * x323
    x492 = x303 * x50 + x483 * x86
    x493 = x492 * x73
    x494 = x312 + x485 * x86
    x495 = x15 * (x204 * x492 + x44 * (x44 * x494 + x493)) + x21 * x331
    x496 = x119 * x475
    x497 = x15 * (x119 * x479 + x496) + x21 * x337
    x498 = x465 * x483
    x499 = x15 * (x316 * x485 + x498) + x21 * x341
    x500 = x344 * x492
    x501 = x15 * (x297 * x494 + x500) + x21 * x346
    x502 = x327 * x50 + x492 * x86
    x503 = x502 * x73
    x504 = x334 + x494 * x86
    x505 = x15 * (x44 * x504 + x503) + x21 * x352
    x506 = x139 * x478 + x21 * x357
    x507 = x142 * x485 + x21 * x361
    x508 = x123 * x494 + x21 * x364
    x509 = x102 * x504 + x21 * x368
    x510 = x15 * (x355 + x504 * x86) + x21 * x371
    x511 = x138 * x4**4
    x512 = x0 * x156
    x513 = x138 * x60
    x514 = x178 * x513
    x515 = x11 * x513
    x516 = x0 * x186
    x517 = x12 * x6
    x518 = x138 * x512
    x519 = x0 * x183
    x520 = x133 * x4
    x521 = x121 + x227 * x75
    x522 = x126 + x234 * x75
    x523 = x131 + x241 * x75
    x524 = x134 * x177 + x136
    x525 = x374 * x511
    x526 = x156 * x20
    x527 = x511 * x526 + x525
    x528 = x383 * x513
    x529 = x20 * x514 + x528
    x530 = x374 * x515
    x531 = x515 * x526 + x530
    x532 = x186 * x392
    x533 = x186 * x20
    x534 = x201 * x533 + x532
    x535 = x186 * x396
    x536 = x210 * x533 + x535
    x537 = x138 * x374
    x538 = x517 * x537
    x539 = x138 * x526
    x540 = x517 * x539 + x538
    x541 = x183 * x402
    x542 = x183 * x20
    x543 = x227 * x542 + x541
    x544 = x183 * x406
    x545 = x234 * x542 + x544
    x546 = x183 * x410
    x547 = x241 * x542 + x546
    x548 = x520 * x537
    x549 = x520 * x539 + x548
    x550 = x15 * (x227 * x50 + x402 * x75)
    x551 = x168 * x521 + x550
    x552 = x15 * (x234 * x50 + x406 * x75)
    x553 = x168 * x522 + x552
    x554 = x15 * (x241 * x50 + x410 * x75)
    x555 = x168 * x523 + x554
    x556 = x15 * (x134 * x381 + x134 * x382)
    x557 = x168 * x524 + x556
    x558 = x152 * x374
    x559 = x152 * x526 + x558
    x560 = x421 * x511
    x561 = x156 * x21
    x562 = x511 * x561 + x560
    x563 = x427 * x513
    x564 = x21 * x514 + x563
    x565 = x431 * x513
    x566 = x515 * x561 + x565
    x567 = x186 * x435
    x568 = x186 * x21
    x569 = x201 * x568 + x567
    x570 = x186 * x439
    x571 = x210 * x568 + x570
    x572 = x186 * x443
    x573 = x138 * x561
    x574 = x517 * x573 + x572
    x575 = x183 * x447
    x576 = x183 * x21
    x577 = x227 * x576 + x575
    x578 = x183 * x451
    x579 = x234 * x576 + x578
    x580 = x183 * x455
    x581 = x241 * x576 + x580
    x582 = x183 * x459
    x583 = x520 * x573 + x582
    x584 = x15 * (x336 + x447 * x75)
    x585 = x286 * x521 + x584
    x586 = x15 * (x340 + x451 * x75)
    x587 = x286 * x522 + x586
    x588 = x15 * (x345 + x455 * x75)
    x589 = x286 * x523 + x588
    x590 = x15 * (x350 + x459 * x75)
    x591 = x286 * x524 + x590
    x592 = x15 * (x250 + x459 * x86)
    x593 = x152 * x561 + x592
    x594 = x154 * x374 + 2.0 * x170 - x376 * x377
    x595 = x594 * x8
    x596 = 3.0 * x375
    x597 = x595 + x596
    x598 = 3.0 * x384 + x597 * x75
    x599 = x595 * x86 + x596 * x86
    x600 = x138 * x594
    x601 = 3.0 * x393 + x598 * x75
    x602 = 3.0 * x397 + x599 * x75
    x603 = x110 * x595 + x110 * x596
    x604 = x154 * x421 + x288 - x376 * x423
    x605 = x511 * x604
    x606 = 2.0 * x422
    x607 = x604 * x8 + x606
    x608 = x513 * x607
    x609 = x11 * x604 + x375
    x610 = x513 * x609
    x611 = x427 * x50 + x607 * x75
    x612 = x186 * x611
    x613 = x431 * x50
    x614 = x609 * x75 + x613
    x615 = x186 * x614
    x616 = x389 + x609 * x86
    x617 = x186 * x616
    x618 = x435 * x50 + x611 * x75
    x619 = x183 * x618
    x620 = x439 * x50 + x614 * x75
    x621 = x183 * x620
    x622 = x443 * x50
    x623 = x616 * x75 + x622
    x624 = x183 * x623
    x625 = x400 + x616 * x86
    x626 = x183 * x625
    x627 = x15 * (x447 * x50 + x618 * x75)
    x628 = x15 * (x451 * x50 + x620 * x75)
    x629 = x15 * (x455 * x50 + x623 * x75)
    x630 = x459 * x50
    x631 = x15 * (x625 * x75 + x630)
    x632 = x15 * (x414 + x625 * x86)
    x633 = x154 * x474 - x376 * x477
    x634 = x21 * x560 + x511 * x633
    x635 = x475 + x633 * x8
    x636 = x21 * x563 + x513 * x635
    x637 = x11 * x633 + x606
    x638 = x21 * x565 + x513 * x637
    x639 = x481 + x635 * x75
    x640 = x186 * x639 + x21 * x567
    x641 = x484 + x637 * x75
    x642 = x186 * x641 + x21 * x570
    x643 = x613 + x637 * x86
    x644 = x186 * x643 + x21 * x572
    x645 = x487 + x639 * x75
    x646 = x183 * x645 + x21 * x575
    x647 = x489 + x641 * x75
    x648 = x183 * x647 + x21 * x578
    x649 = x493 + x643 * x75
    x650 = x183 * x649 + x21 * x580
    x651 = x622 + x643 * x86
    x652 = x183 * x651 + x21 * x582
    x653 = x15 * (x496 + x645 * x75) + x21 * x584
    x654 = x15 * (x498 + x647 * x75) + x21 * x586
    x655 = x15 * (x500 + x649 * x75) + x21 * x588
    x656 = x15 * (x503 + x651 * x75) + x21 * x590
    x657 = x15 * (x630 + x651 * x86) + x21 * x592
    x658 = x0 * x276
    x659 = x513 * x8
    x660 = x0 * x303
    x661 = x138 * x6
    x662 = x661 * x9
    x663 = x661 * x8
    x664 = x142 * x4
    x665 = x138 * x9
    x666 = x4 * x665
    x667 = x322 * x327
    x668 = x123 * x327
    x669 = x102 * x349
    x670 = x136 + x349 * x86
    x671 = x20 * x276
    x672 = x511 * x671 + x560
    x673 = x563 + x659 * x671
    x674 = x20 * x303
    x675 = x513 * x674 + x565
    x676 = x567 + x662 * x671
    x677 = x570 + x663 * x674
    x678 = x327 * x533 + x572
    x679 = x575 + x664 * x671
    x680 = x578 + x666 * x674
    x681 = x20 * x667 + x580
    x682 = x349 * x542 + x582
    x683 = x139 * x671 + x584
    x684 = x142 * x674 + x586
    x685 = x20 * x668 + x588
    x686 = x20 * x669 + x590
    x687 = x168 * x670 + x592
    x688 = x474 * x511
    x689 = x21 * x276
    x690 = x511 * x689 + x688
    x691 = x474 * x659
    x692 = x659 * x689 + x691
    x693 = x483 * x513
    x694 = x21 * x303
    x695 = x513 * x694 + x693
    x696 = x474 * x662
    x697 = x662 * x689 + x696
    x698 = x483 * x663
    x699 = x663 * x694 + x698
    x700 = x186 * x492
    x701 = x327 * x568 + x700
    x702 = x474 * x664
    x703 = x664 * x689 + x702
    x704 = x490 * x665
    x705 = x666 * x694 + x704
    x706 = x322 * x492
    x707 = x21 * x667 + x706
    x708 = x183 * x502
    x709 = x349 * x576 + x708
    x710 = x139 * x474
    x711 = x139 * x689 + x710
    x712 = x142 * x483
    x713 = x142 * x694 + x712
    x714 = x123 * x492
    x715 = x21 * x668 + x714
    x716 = x102 * x502
    x717 = x21 * x669 + x716
    x718 = x15 * (x349 * x50 + x502 * x86)
    x719 = x286 * x670 + x718
    x720 = x274 * x474 + 2.0 * x288 - x476 * x477
    x721 = x11 * x720 + 3.0 * x475
    x722 = 3.0 * x484 + x721 * x86
    x723 = 3.0 * x493 + x722 * x86

    # 270 item(s)
    return numpy.array(
        [
            x0 * x59
            + x0 * (x59 + x64 * x65)
            + x15
            * (x44 * (x44 * (x43 * x74 + x44 * (x70 + x72)) + x51 * x74) + x55 * x74),
            x0 * x83
            + x0 * (x65 * x85 + x83)
            + x15 * (x44 * (x44 * (x70 * x75 + x72 * x75) + x74 * x76) + x74 * x79),
            x0 * x92
            + x0 * (x65 * x93 + x92)
            + x15 * (x44 * (x44 * (x70 * x86 + x72 * x86) + x74 * x87) + x74 * x90),
            x0 * x99
            + x0 * (x101 * x65 + x99)
            + x15 * (x44 * (x70 * x95 + x72 * x95) + x74 * x96),
            x0 * x108
            + x0 * (x108 + x109 * x65)
            + x15 * (x104 * x74 + x44 * (x103 * x70 + x103 * x72)),
            x0 * x114
            + x0 * (x114 + x116 * x65)
            + x15 * (x111 * x74 + x44 * (x110 * x70 + x110 * x72)),
            x0 * x120 + x0 * (x120 + x122 * x65) + x15 * (x119 * x70 + x119 * x72),
            x0 * x125 + x0 * (x125 + x127 * x65) + x15 * (x124 * x70 + x124 * x72),
            x0 * x130 + x0 * (x130 + x132 * x65) + x15 * (x129 * x70 + x129 * x72),
            x0 * x135 + x0 * (x135 + x137 * x65) + x15 * (x134 * x70 + x134 * x72),
            x0 * x140 + x0 * (x139 * x141 + x140) + x139 * x69,
            x0 * x144 + x0 * (x141 * x143 + x144) + x143 * x69,
            x0 * x147 + x0 * (x146 * x148 + x147) + x146 * x149,
            x0 * x151 + x0 * (x148 * x150 + x151) + x149 * x150,
            x0 * x153 + x0 * (x141 * x152 + x153) + x152 * x69,
            x0 * x169 + x176 + x20 * x59,
            x0 * x188 + x192 + x20 * x83,
            x0 * x198 + x20 * x92 + x200,
            x0 * x206 + x20 * x99 + x209,
            x0 * x215 + x108 * x20 + x219,
            x0 * x224 + x114 * x20 + x226,
            x0 * x230 + x120 * x20 + x233,
            x0 * x237 + x125 * x20 + x240,
            x0 * x245 + x130 * x20 + x249,
            x0 * x252 + x135 * x20 + x254,
            x0 * x257 + x140 * x20 + x258,
            x0 * x260 + x144 * x20 + x261,
            x0 * x264 + x147 * x20 + x265,
            x0 * x268 + x151 * x20 + x270,
            x0 * x272 + x153 * x20 + x273,
            x0 * x287 + x21 * x59 + x294,
            x0 * x301 + x21 * x83 + x302,
            x0 * x310 + x21 * x92 + x313,
            x0 * x318 + x21 * x99 + x319,
            x0 * x324 + x108 * x21 + x326,
            x0 * x332 + x114 * x21 + x335,
            x0 * x338 + x120 * x21 + x339,
            x0 * x342 + x125 * x21 + x343,
            x0 * x347 + x130 * x21 + x348,
            x0 * x353 + x135 * x21 + x356,
            x0 * x359 + x140 * x21 + x360,
            x0 * x362 + x144 * x21 + x363,
            x0 * x366 + x147 * x21 + x367,
            x0 * x369 + x151 * x21 + x370,
            x0 * x372 + x153 * x21 + x373,
            x169 * x20 + x380,
            x188 * x20 + x388,
            x198 * x20 + x391,
            x20 * x206 + x395,
            x20 * x215 + x399,
            x20 * x224 + x401,
            x20 * x230 + x405,
            x20 * x237 + x409,
            x20 * x245 + x413,
            x20 * x252 + x415,
            x20 * x257 + x416,
            x20 * x260 + x417,
            x20 * x264 + x418,
            x20 * x268 + x419,
            x20 * x272 + x420,
            x20 * x287 + x426,
            x20 * x301 + x430,
            x20 * x310 + x434,
            x20 * x318 + x438,
            x20 * x324 + x442,
            x20 * x332 + x446,
            x20 * x338 + x450,
            x20 * x342 + x454,
            x20 * x347 + x458,
            x20 * x353 + x462,
            x20 * x359 + x464,
            x20 * x362 + x467,
            x20 * x366 + x469,
            x20 * x369 + x471,
            x20 * x372 + x473,
            x21 * x287 + x480,
            x21 * x301 + x482,
            x21 * x310 + x486,
            x21 * x318 + x488,
            x21 * x324 + x491,
            x21 * x332 + x495,
            x21 * x338 + x497,
            x21 * x342 + x499,
            x21 * x347 + x501,
            x21 * x353 + x505,
            x21 * x359 + x506,
            x21 * x362 + x507,
            x21 * x366 + x508,
            x21 * x369 + x509,
            x21 * x372 + x510,
            x0 * x167 + x0 * (x167 + x511 * x512) + x176,
            x0 * x187 + x0 * (x0 * x514 + x187) + x192,
            x0 * x197 + x0 * (x197 + x512 * x515) + x200,
            x0 * x205 + x0 * (x201 * x516 + x205) + x209,
            x0 * x214 + x0 * (x210 * x516 + x214) + x219,
            x0 * x223 + x0 * (x223 + x517 * x518) + x226,
            x0 * x229 + x0 * (x227 * x519 + x229) + x233,
            x0 * x236 + x0 * (x234 * x519 + x236) + x240,
            x0 * x244 + x0 * (x241 * x519 + x244) + x249,
            x0 * x251 + x0 * (x251 + x518 * x520) + x254,
            x0 * x255 + x0 * (x255 + x521 * x65) + x258,
            x0 * x259 + x0 * (x259 + x522 * x65) + x261,
            x0 * x262 + x0 * (x262 + x523 * x65) + x265,
            x0 * x267 + x0 * (x267 + x524 * x65) + x270,
            x0 * x271 + x0 * (x152 * x512 + x271) + x273,
            x0 * x527 + x380,
            x0 * x529 + x388,
            x0 * x531 + x391,
            x0 * x534 + x395,
            x0 * x536 + x399,
            x0 * x540 + x401,
            x0 * x543 + x405,
            x0 * x545 + x409,
            x0 * x547 + x413,
            x0 * x549 + x415,
            x0 * x551 + x416,
            x0 * x553 + x417,
            x0 * x555 + x418,
            x0 * x557 + x419,
            x0 * x559 + x420,
            x0 * x562 + x426,
            x0 * x564 + x430,
            x0 * x566 + x434,
            x0 * x569 + x438,
            x0 * x571 + x442,
            x0 * x574 + x446,
            x0 * x577 + x450,
            x0 * x579 + x454,
            x0 * x581 + x458,
            x0 * x583 + x462,
            x0 * x585 + x464,
            x0 * x587 + x467,
            x0 * x589 + x469,
            x0 * x591 + x471,
            x0 * x593 + x473,
            x20 * x525 + x20 * x527 + x511 * x594,
            x20 * x528 + x20 * x529 + x513 * x597,
            x20 * x530 + x20 * x531 + x515 * x594,
            x186 * x598 + x20 * x532 + x20 * x534,
            x186 * x599 + x20 * x535 + x20 * x536,
            x20 * x538 + x20 * x540 + x517 * x600,
            x183 * x601 + x20 * x541 + x20 * x543,
            x183 * x602 + x20 * x544 + x20 * x545,
            x183 * x603 + x20 * x546 + x20 * x547,
            x20 * x548 + x20 * x549 + x520 * x600,
            x15 * (3.0 * x403 + x601 * x75) + x20 * x550 + x20 * x551,
            x15 * (3.0 * x407 + x602 * x75) + x20 * x552 + x20 * x553,
            x15 * (3.0 * x411 + x603 * x75) + x20 * x554 + x20 * x555,
            x15 * (x134 * x595 + x134 * x596) + x20 * x556 + x20 * x557,
            x152 * x594 + x20 * x558 + x20 * x559,
            x20 * x562 + x21 * x525 + x605,
            x20 * x564 + x21 * x528 + x608,
            x20 * x566 + x21 * x530 + x610,
            x20 * x569 + x21 * x532 + x612,
            x20 * x571 + x21 * x535 + x615,
            x20 * x574 + x21 * x538 + x617,
            x20 * x577 + x21 * x541 + x619,
            x20 * x579 + x21 * x544 + x621,
            x20 * x581 + x21 * x546 + x624,
            x20 * x583 + x21 * x548 + x626,
            x20 * x585 + x21 * x550 + x627,
            x20 * x587 + x21 * x552 + x628,
            x20 * x589 + x21 * x554 + x629,
            x20 * x591 + x21 * x556 + x631,
            x20 * x593 + x21 * x558 + x632,
            x21 * x562 + x634,
            x21 * x564 + x636,
            x21 * x566 + x638,
            x21 * x569 + x640,
            x21 * x571 + x642,
            x21 * x574 + x644,
            x21 * x577 + x646,
            x21 * x579 + x648,
            x21 * x581 + x650,
            x21 * x583 + x652,
            x21 * x585 + x653,
            x21 * x587 + x654,
            x21 * x589 + x655,
            x21 * x591 + x656,
            x21 * x593 + x657,
            x0 * x285 + x0 * (x285 + x511 * x658) + x294,
            x0 * x300 + x0 * (x300 + x658 * x659) + x302,
            x0 * x309 + x0 * (x309 + x513 * x660) + x313,
            x0 * x317 + x0 * (x317 + x658 * x662) + x319,
            x0 * x323 + x0 * (x323 + x660 * x663) + x326,
            x0 * x331 + x0 * (x327 * x516 + x331) + x335,
            x0 * x337 + x0 * (x337 + x658 * x664) + x339,
            x0 * x341 + x0 * (x341 + x660 * x666) + x343,
            x0 * x346 + x0 * (x0 * x667 + x346) + x348,
            x0 * x352 + x0 * (x349 * x519 + x352) + x356,
            x0 * x357 + x0 * (x139 * x658 + x357) + x360,
            x0 * x361 + x0 * (x142 * x660 + x361) + x363,
            x0 * x364 + x0 * (x0 * x668 + x364) + x367,
            x0 * x368 + x0 * (x0 * x669 + x368) + x370,
            x0 * x371 + x0 * (x371 + x65 * x670) + x373,
            x0 * x672 + x20 * x285 + x425,
            x0 * x673 + x20 * x300 + x429,
            x0 * x675 + x20 * x309 + x433,
            x0 * x676 + x20 * x317 + x437,
            x0 * x677 + x20 * x323 + x441,
            x0 * x678 + x20 * x331 + x445,
            x0 * x679 + x20 * x337 + x449,
            x0 * x680 + x20 * x341 + x453,
            x0 * x681 + x20 * x346 + x457,
            x0 * x682 + x20 * x352 + x461,
            x0 * x683 + x20 * x357 + x463,
            x0 * x684 + x20 * x361 + x466,
            x0 * x685 + x20 * x364 + x468,
            x0 * x686 + x20 * x368 + x470,
            x0 * x687 + x20 * x371 + x472,
            x0 * x690 + x480,
            x0 * x692 + x482,
            x0 * x695 + x486,
            x0 * x697 + x488,
            x0 * x699 + x491,
            x0 * x701 + x495,
            x0 * x703 + x497,
            x0 * x705 + x499,
            x0 * x707 + x501,
            x0 * x709 + x505,
            x0 * x711 + x506,
            x0 * x713 + x507,
            x0 * x715 + x508,
            x0 * x717 + x509,
            x0 * x719 + x510,
            x20 * x560 + x20 * x672 + x605,
            x20 * x563 + x20 * x673 + x608,
            x20 * x565 + x20 * x675 + x610,
            x20 * x567 + x20 * x676 + x612,
            x20 * x570 + x20 * x677 + x615,
            x20 * x572 + x20 * x678 + x617,
            x20 * x575 + x20 * x679 + x619,
            x20 * x578 + x20 * x680 + x621,
            x20 * x580 + x20 * x681 + x624,
            x20 * x582 + x20 * x682 + x626,
            x20 * x584 + x20 * x683 + x627,
            x20 * x586 + x20 * x684 + x628,
            x20 * x588 + x20 * x685 + x629,
            x20 * x590 + x20 * x686 + x631,
            x20 * x592 + x20 * x687 + x632,
            x20 * x690 + x634,
            x20 * x692 + x636,
            x20 * x695 + x638,
            x20 * x697 + x640,
            x20 * x699 + x642,
            x20 * x701 + x644,
            x20 * x703 + x646,
            x20 * x705 + x648,
            x20 * x707 + x650,
            x20 * x709 + x652,
            x20 * x711 + x653,
            x20 * x713 + x654,
            x20 * x715 + x655,
            x20 * x717 + x656,
            x20 * x719 + x657,
            x21 * x688 + x21 * x690 + x511 * x720,
            x21 * x691 + x21 * x692 + x659 * x720,
            x21 * x693 + x21 * x695 + x513 * x721,
            x21 * x696 + x21 * x697 + x662 * x720,
            x21 * x698 + x21 * x699 + x663 * x721,
            x186 * x722 + x21 * x700 + x21 * x701,
            x21 * x702 + x21 * x703 + x664 * x720,
            x21 * x704 + x21 * x705 + x666 * x721,
            x21 * x706 + x21 * x707 + x322 * x722,
            x183 * x723 + x21 * x708 + x21 * x709,
            x139 * x720 + x21 * x710 + x21 * x711,
            x142 * x721 + x21 * x712 + x21 * x713,
            x123 * x722 + x21 * x714 + x21 * x715,
            x102 * x723 + x21 * x716 + x21 * x717,
            x15 * (3.0 * x503 + x723 * x86) + x21 * x718 + x21 * x719,
        ]
    )


def _3center2el3d_sph_125(a, A, b, B, c, C):
    """Cartesian (pd|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = x4**2
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = x8**2
    x10 = -x2 * (a * A[2] + b * B[2])
    x11 = -x10 - C[2]
    x12 = x11**2
    x13 = c + x1
    x14 = x13 ** (-1.0)
    x15 = x1 * x14
    x16 = c * x15 * (x12 + x6 + x9)
    x17 = boys(6, x16)
    x18 = x13 ** (-1.5)
    x19 = 17.4934183276249
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = numpy.exp(-a * b * x2 * (x0**2 + x20**2 + x21**2))
    x23 = x19 * x22
    x24 = x2 * x23
    x25 = 2.0 * x18 * x24
    x26 = x17 * x25
    x27 = c ** (-1.0)
    x28 = x13 ** (-0.5)
    x29 = boys(5, x16)
    x30 = x5 * (2.0 * x19 * x2 * x22 * x27 * x28 * x29 - x26)
    x31 = -x3 - A[0]
    x32 = -2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x31 + x26 * x4
    x33 = -x32
    x34 = boys(7, x16)
    x35 = x25 * x34
    x36 = 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x31 - x35 * x4
    x37 = c * x14
    x38 = x36 * x37
    x39 = x30 + x31 * x33 - x38 * x4
    x40 = x39 * x4
    x41 = x33 * x5
    x42 = 2.0 * x41
    x43 = x40 + x42
    x44 = x15 * x4
    x45 = x33 * x4
    x46 = 2.0 * x5
    x47 = x27 * x29 * x46
    x48 = x24 * x28 * x47
    x49 = x45 + x48
    x50 = x15 * x46
    x51 = x43 * x44 + x49 * x50
    x52 = x23 * x47
    x53 = x18 * x52
    x54 = x4 * x53 + x44 * x49
    x55 = x44 * x51 + x50 * x54
    x56 = x52 * x6
    x57 = x1 * x13 ** (-2.5)
    x58 = x44 * x54 + x56 * x57
    x59 = x44 * x55 + x50 * x58
    x60 = x4**3
    x61 = x52 * x60
    x62 = x1**2
    x63 = x13 ** (-3.5) * x62
    x64 = x44 * x58 + x61 * x63
    x65 = x15 * (x44 * x59 + x50 * x64)
    x66 = x4**4
    x67 = x1**3
    x68 = x13 ** (-4.5) * x67
    x69 = x52 * x68
    x70 = x44 * x64 + x66 * x69
    x71 = x0 * x15
    x72 = x5 * (2.0 * x17 * x19 * x2 * x22 * x27 * x28 - x35)
    x73 = x25 * boys(8, x16)
    x74 = x37 * x4
    x75 = (
        x31 * x39
        + x46 * (-x32 - x38)
        - x74
        * (
            x31 * x36
            + x72
            - x74 * (2.0 * x19 * x2 * x22 * x27 * x28 * x31 * x34 - x4 * x73)
        )
    )
    x76 = x4 * x75
    x77 = x39 * x5
    x78 = 3.0 * x77
    x79 = x15 * x5
    x80 = 3.0 * x79
    x81 = x15 * x8
    x82 = x40 * x81 + x42 * x81
    x83 = x53 * x8
    x84 = x45 * x81 + x83
    x85 = x44 * x82 + x50 * x84
    x86 = x52 * x57
    x87 = x4 * x86
    x88 = x44 * x84 + x8 * x87
    x89 = x44 * x85 + x50 * x88
    x90 = x6 * x8
    x91 = x52 * x63
    x92 = x44 * x88 + x90 * x91
    x93 = x15 * (x44 * x89 + x50 * x92)
    x94 = x61 * x68
    x95 = x44 * x92 + x8 * x94
    x96 = x11 * x15
    x97 = x40 * x96 + x42 * x96
    x98 = x11 * x53
    x99 = x45 * x96 + x98
    x100 = x44 * x97 + x50 * x99
    x101 = x11 * x87 + x44 * x99
    x102 = x100 * x44 + x101 * x50
    x103 = x101 * x44 + x11 * x56 * x63
    x104 = x15 * (x102 * x44 + x103 * x50)
    x105 = x103 * x44 + x11 * x94
    x106 = x62 / x13**2
    x107 = x106 * x9
    x108 = x107 * x40 + x107 * x42
    x109 = x86 * x9
    x110 = x107 * x45 + x109
    x111 = x108 * x44 + x110 * x50
    x112 = x4 * x9
    x113 = x110 * x44 + x112 * x91
    x114 = x15 * (x111 * x44 + x113 * x50)
    x115 = x56 * x68
    x116 = x113 * x44 + x115 * x9
    x117 = x106 * x8
    x118 = x11 * x117
    x119 = x118 * x40 + x118 * x42
    x120 = x11 * x8
    x121 = x120 * x86
    x122 = x118 * x45 + x121
    x123 = x119 * x44 + x122 * x50
    x124 = x120 * x4 * x91 + x122 * x44
    x125 = x15 * (x123 * x44 + x124 * x50)
    x126 = x11 * x69
    x127 = x124 * x44 + x126 * x90
    x128 = x106 * x12
    x129 = x128 * x40 + x128 * x42
    x130 = x12 * x86
    x131 = x128 * x45 + x130
    x132 = x129 * x44 + x131 * x50
    x133 = x12 * x91
    x134 = x131 * x44 + x133 * x4
    x135 = x15 * (x132 * x44 + x134 * x50)
    x136 = x115 * x12 + x134 * x44
    x137 = x8**3
    x138 = x67 / x13**3
    x139 = x137 * x138
    x140 = x139 * x40 + x139 * x42
    x141 = x137 * x91
    x142 = x139 * x45 + x141
    x143 = x15 * (x140 * x44 + x142 * x50)
    x144 = x137 * x4
    x145 = x142 * x44 + x144 * x69
    x146 = x138 * x9
    x147 = x11 * x146
    x148 = x147 * x40 + x147 * x42
    x149 = x11 * x9 * x91
    x150 = x147 * x45 + x149
    x151 = x15 * (x148 * x44 + x150 * x50)
    x152 = x112 * x126 + x150 * x44
    x153 = x138 * x8
    x154 = x12 * x153
    x155 = x154 * x40 + x154 * x42
    x156 = x133 * x8
    x157 = x154 * x45 + x156
    x158 = x15 * (x155 * x44 + x157 * x50)
    x159 = x12 * x4 * x69 * x8 + x157 * x44
    x160 = x11**3
    x161 = x138 * x160
    x162 = x161 * x40 + x161 * x42
    x163 = x160 * x91
    x164 = x161 * x45 + x163
    x165 = x15 * (x162 * x44 + x164 * x50)
    x166 = x160 * x4
    x167 = x164 * x44 + x166 * x69
    x168 = x8**4
    x169 = x1**4 / x13**4
    x170 = x168 * x169
    x171 = x15 * (x170 * x40 + x170 * x42)
    x172 = x168 * x69
    x173 = x170 * x45 + x172
    x174 = x137 * x169
    x175 = x11 * x174
    x176 = x15 * (x175 * x40 + x175 * x42)
    x177 = x126 * x137
    x178 = x175 * x45 + x177
    x179 = x169 * x40
    x180 = x12 * x9
    x181 = x169 * x180
    x182 = x15 * (x179 * x180 + x181 * x42)
    x183 = x180 * x69
    x184 = x181 * x45 + x183
    x185 = x160 * x8
    x186 = x169 * x185
    x187 = x15 * (x179 * x185 + x186 * x42)
    x188 = x185 * x69
    x189 = x186 * x45 + x188
    x190 = x11**4
    x191 = x169 * x190
    x192 = x15 * (x191 * x40 + x191 * x42)
    x193 = x190 * x69
    x194 = x191 * x45 + x193
    x195 = x1**5 / x13**5
    x196 = x195 * x8**5
    x197 = x196 * x39
    x198 = x0 * x33
    x199 = x168 * x195
    x200 = x11 * x199
    x201 = x200 * x39
    x202 = x195 * x39
    x203 = x12 * x137
    x204 = x202 * x203
    x205 = x195 * x198
    x206 = x195 * x75
    x207 = x160 * x9
    x208 = x202 * x207
    x209 = x190 * x8
    x210 = x202 * x209
    x211 = x11**5 * x195
    x212 = x211 * x39
    x213 = -x7 - A[1]
    x214 = -2.0 * x19 * x2 * x213 * x22 * x27 * x28 * x29 + x26 * x8
    x215 = -x214
    x216 = x215 * x5
    x217 = 2.0 * x17 * x19 * x2 * x213 * x22 * x27 * x28 - x35 * x8
    x218 = x217 * x37
    x219 = x215 * x31 - x218 * x4
    x220 = x219 * x4
    x221 = x216 + x220
    x222 = x216 * x44 + x221 * x44
    x223 = x106 * x6
    x224 = x216 * x223 + x222 * x44
    x225 = x138 * x60
    x226 = x216 * x225 + x224 * x44
    x227 = x169 * x66
    x228 = x15 * (x216 * x227 + x226 * x44)
    x229 = x15 * x20
    x230 = x228 + x229 * x70
    x231 = x5 * (-x214 - x218)
    x232 = 2.0 * x19 * x2 * x213 * x22 * x27 * x28 * x34 - x73 * x8
    x233 = x219 * x31 + x231 - x74 * (x217 * x31 - x232 * x74)
    x234 = x233 * x4
    x235 = x219 * x5
    x236 = 2.0 * x235
    x237 = x15 * (
        x226 * x50
        + x44
        * (x224 * x50 + x44 * (x222 * x50 + x44 * (x221 * x50 + x44 * (x234 + x236))))
    )
    x238 = x215 * x8
    x239 = x238 + x48
    x240 = x15 * x239
    x241 = x219 * x8
    x242 = x241 + x41
    x243 = x240 * x5 + x242 * x44
    x244 = x106 * x4
    x245 = x239 * x5
    x246 = x243 * x44 + x244 * x245
    x247 = x138 * x6
    x248 = x245 * x247 + x246 * x44
    x249 = x169 * x60
    x250 = x15 * (x245 * x249 + x248 * x44)
    x251 = x229 * x95 + x250
    x252 = x233 * x8
    x253 = x252 + x77
    x254 = x242 * x50
    x255 = x15 * (
        x248 * x50 + x44 * (x246 * x50 + x44 * (x243 * x50 + x44 * (x253 * x44 + x254)))
    )
    x256 = x216 * x96
    x257 = x220 * x96 + x256
    x258 = x11 * x216
    x259 = x244 * x258 + x257 * x44
    x260 = x247 * x258 + x259 * x44
    x261 = x15 * (x249 * x258 + x260 * x44)
    x262 = x105 * x229 + x261
    x263 = x236 * x96
    x264 = x15 * (
        x260 * x50 + x44 * (x259 * x50 + x44 * (x257 * x50 + x44 * (x234 * x96 + x263)))
    )
    x265 = x240 * x8 + x83
    x266 = x242 * x81 + x41 * x81
    x267 = x265 * x79 + x266 * x44
    x268 = x265 * x5
    x269 = x244 * x268 + x267 * x44
    x270 = x15 * (x247 * x268 + x269 * x44)
    x271 = x116 * x229 + x270
    x272 = x253 * x81 + x77 * x81
    x273 = x266 * x50
    x274 = x15 * (x269 * x50 + x44 * (x267 * x50 + x44 * (x272 * x44 + x273)))
    x275 = x238 * x96 + x98
    x276 = x41 * x96
    x277 = x241 * x96 + x276
    x278 = x275 * x79 + x277 * x44
    x279 = x275 * x5
    x280 = x244 * x279 + x278 * x44
    x281 = x15 * (x247 * x279 + x280 * x44)
    x282 = x127 * x229 + x281
    x283 = x77 * x96
    x284 = x252 * x96 + x283
    x285 = x277 * x50
    x286 = x15 * (x280 * x50 + x44 * (x278 * x50 + x44 * (x284 * x44 + x285)))
    x287 = x128 * x216
    x288 = x128 * x220 + x287
    x289 = x12 * x216
    x290 = x138 * x4
    x291 = x288 * x44 + x289 * x290
    x292 = x169 * x6
    x293 = x15 * (x289 * x292 + x291 * x44)
    x294 = x136 * x229 + x293
    x295 = x128 * x236
    x296 = x15 * (x291 * x50 + x44 * (x288 * x50 + x44 * (x128 * x234 + x295)))
    x297 = x109 + x265 * x81
    x298 = x107 * x41 + x266 * x81
    x299 = x297 * x79 + x298 * x44
    x300 = x244 * x5
    x301 = x15 * (x297 * x300 + x299 * x44)
    x302 = x145 * x229 + x301
    x303 = x107 * x77 + x272 * x81
    x304 = x298 * x50
    x305 = x15 * (x299 * x50 + x44 * (x303 * x44 + x304))
    x306 = x121 + x275 * x81
    x307 = x118 * x41 + x277 * x81
    x308 = x306 * x79 + x307 * x44
    x309 = x15 * (x300 * x306 + x308 * x44)
    x310 = x152 * x229 + x309
    x311 = x118 * x77 + x284 * x81
    x312 = x307 * x50
    x313 = x15 * (x308 * x50 + x44 * (x311 * x44 + x312))
    x314 = x128 * x238 + x130
    x315 = x128 * x41
    x316 = x128 * x241 + x315
    x317 = x314 * x79 + x316 * x44
    x318 = x15 * (x300 * x314 + x317 * x44)
    x319 = x159 * x229 + x318
    x320 = x128 * x77
    x321 = x128 * x252 + x320
    x322 = x316 * x50
    x323 = x15 * (x317 * x50 + x44 * (x321 * x44 + x322))
    x324 = x161 * x216
    x325 = x161 * x220 + x324
    x326 = x166 * x169
    x327 = x15 * (x216 * x326 + x325 * x44)
    x328 = x167 * x229 + x327
    x329 = x161 * x236
    x330 = x15 * (x325 * x50 + x44 * (x161 * x234 + x329))
    x331 = x141 + x297 * x81
    x332 = x139 * x41 + x298 * x81
    x333 = x15 * (x331 * x79 + x332 * x44)
    x334 = x173 * x229 + x333
    x335 = x139 * x77 + x303 * x81
    x336 = x332 * x50
    x337 = x15 * (x335 * x44 + x336)
    x338 = x149 + x306 * x81
    x339 = x147 * x41 + x307 * x81
    x340 = x15 * (x338 * x79 + x339 * x44)
    x341 = x178 * x229 + x340
    x342 = x147 * x77 + x311 * x81
    x343 = x339 * x50
    x344 = x15 * (x342 * x44 + x343)
    x345 = x156 + x314 * x81
    x346 = x154 * x41 + x316 * x81
    x347 = x15 * (x345 * x79 + x346 * x44)
    x348 = x184 * x229 + x347
    x349 = x154 * x77 + x321 * x81
    x350 = x346 * x50
    x351 = x15 * (x349 * x44 + x350)
    x352 = x161 * x238 + x163
    x353 = x161 * x41
    x354 = x161 * x241 + x353
    x355 = x15 * (x352 * x79 + x354 * x44)
    x356 = x189 * x229 + x355
    x357 = x161 * x77
    x358 = x161 * x252 + x357
    x359 = x354 * x50
    x360 = x15 * (x358 * x44 + x359)
    x361 = x191 * x216
    x362 = x15 * (x191 * x220 + x361)
    x363 = x194 * x229 + x362
    x364 = x191 * x236
    x365 = x15 * (x191 * x234 + x364)
    x366 = x15 * (x170 * x41 + x332 * x81)
    x367 = x20 * x33
    x368 = x196 * x367 + x366
    x369 = x15 * (x170 * x77 + x335 * x81)
    x370 = x15 * (x175 * x41 + x339 * x81)
    x371 = x200 * x367 + x370
    x372 = x15 * (x175 * x77 + x342 * x81)
    x373 = x15 * (x181 * x41 + x346 * x81)
    x374 = x195 * x367
    x375 = x203 * x374 + x373
    x376 = x15 * (x181 * x77 + x349 * x81)
    x377 = x15 * (x186 * x41 + x354 * x81)
    x378 = x207 * x374 + x377
    x379 = x15 * (x186 * x77 + x358 * x81)
    x380 = x191 * x41
    x381 = x15 * (x191 * x241 + x380)
    x382 = x209 * x374 + x381
    x383 = x191 * x77
    x384 = x15 * (x191 * x252 + x383)
    x385 = x211 * x219
    x386 = x211 * x367 + x385
    x387 = x211 * x233
    x388 = -x10 - A[2]
    x389 = x11 * x26 - 2.0 * x19 * x2 * x22 * x27 * x28 * x29 * x388
    x390 = -x389
    x391 = x390 * x5
    x392 = -x11 * x35 + 2.0 * x17 * x19 * x2 * x22 * x27 * x28 * x388
    x393 = x37 * x392
    x394 = x31 * x390 - x393 * x4
    x395 = x394 * x4
    x396 = x391 + x395
    x397 = x391 * x44 + x396 * x44
    x398 = x223 * x391 + x397 * x44
    x399 = x225 * x391 + x398 * x44
    x400 = x15 * (x227 * x391 + x399 * x44)
    x401 = x15 * x21
    x402 = x400 + x401 * x70
    x403 = x5 * (-x389 - x393)
    x404 = -x11 * x73 + 2.0 * x19 * x2 * x22 * x27 * x28 * x34 * x388
    x405 = x31 * x394 + x403 - x74 * (x31 * x392 - x404 * x74)
    x406 = x4 * x405
    x407 = x394 * x5
    x408 = 2.0 * x407
    x409 = x15 * (
        x399 * x50
        + x44
        * (x398 * x50 + x44 * (x397 * x50 + x44 * (x396 * x50 + x44 * (x406 + x408))))
    )
    x410 = x391 * x81
    x411 = x395 * x81 + x410
    x412 = x117 * x4
    x413 = x391 * x412 + x411 * x44
    x414 = x391 * x8
    x415 = x247 * x414 + x413 * x44
    x416 = x15 * (x249 * x414 + x415 * x44)
    x417 = x401 * x95 + x416
    x418 = x15 * (
        x415 * x50
        + x44 * (x413 * x50 + x44 * (x411 * x50 + x44 * (x406 * x81 + x408 * x81)))
    )
    x419 = x11 * x390 + x48
    x420 = x419 * x79
    x421 = x11 * x394 + x41
    x422 = x420 + x421 * x44
    x423 = x300 * x419 + x422 * x44
    x424 = x419 * x5
    x425 = x247 * x424 + x423 * x44
    x426 = x15 * (x249 * x424 + x425 * x44)
    x427 = x105 * x401 + x426
    x428 = x11 * x405 + x77
    x429 = x421 * x50
    x430 = x15 * (
        x425 * x50 + x44 * (x423 * x50 + x44 * (x422 * x50 + x44 * (x428 * x44 + x429)))
    )
    x431 = x107 * x391
    x432 = x107 * x395 + x431
    x433 = x146 * x4
    x434 = x391 * x433 + x432 * x44
    x435 = x292 * x9
    x436 = x15 * (x391 * x435 + x434 * x44)
    x437 = x116 * x401 + x436
    x438 = x15 * (x434 * x50 + x44 * (x432 * x50 + x44 * (x107 * x406 + x107 * x408)))
    x439 = x117 * x424
    x440 = x412 * x421 + x439
    x441 = x153 * x4
    x442 = x424 * x441 + x44 * x440
    x443 = x169 * x424
    x444 = x15 * (x44 * x442 + x443 * x90)
    x445 = x127 * x401 + x444
    x446 = x421 * x46
    x447 = x15 * (x44 * (x44 * (x117 * x446 + x412 * x428) + x440 * x50) + x442 * x50)
    x448 = x419 * x96 + x98
    x449 = x448 * x79
    x450 = x276 + x421 * x96
    x451 = x44 * x450 + x449
    x452 = x300 * x448 + x44 * x451
    x453 = x448 * x5
    x454 = x15 * (x247 * x453 + x44 * x452)
    x455 = x136 * x401 + x454
    x456 = x283 + x428 * x96
    x457 = x450 * x50
    x458 = x15 * (x44 * (x44 * (x44 * x456 + x457) + x451 * x50) + x452 * x50)
    x459 = x139 * x391
    x460 = x139 * x395 + x459
    x461 = x174 * x4
    x462 = x15 * (x391 * x461 + x44 * x460)
    x463 = x145 * x401 + x462
    x464 = x15 * (x44 * (x139 * x406 + x139 * x408) + x460 * x50)
    x465 = x146 * x424
    x466 = x421 * x433 + x465
    x467 = x15 * (x112 * x443 + x44 * x466)
    x468 = x152 * x401 + x467
    x469 = x15 * (x44 * (x146 * x446 + x428 * x433) + x466 * x50)
    x470 = x117 * x453
    x471 = x412 * x450 + x470
    x472 = x15 * (x44 * x471 + x441 * x453)
    x473 = x159 * x401 + x472
    x474 = x450 * x46
    x475 = x15 * (x44 * (x117 * x474 + x412 * x456) + x471 * x50)
    x476 = x130 + x448 * x96
    x477 = x476 * x79
    x478 = x315 + x450 * x96
    x479 = x44 * x478 + x477
    x480 = x15 * (x300 * x476 + x44 * x479)
    x481 = x167 * x401 + x480
    x482 = x320 + x456 * x96
    x483 = x478 * x50
    x484 = x15 * (x44 * (x44 * x482 + x483) + x479 * x50)
    x485 = x170 * x391
    x486 = x15 * (x170 * x395 + x485)
    x487 = x173 * x401 + x486
    x488 = x15 * (x170 * x406 + x170 * x408)
    x489 = x174 * x424
    x490 = x15 * (x421 * x461 + x489)
    x491 = x178 * x401 + x490
    x492 = x15 * (x174 * x446 + x428 * x461)
    x493 = x146 * x453
    x494 = x15 * (x433 * x450 + x493)
    x495 = x184 * x401 + x494
    x496 = x15 * (x146 * x474 + x433 * x456)
    x497 = x117 * x5
    x498 = x476 * x497
    x499 = x15 * (x412 * x478 + x498)
    x500 = x189 * x401 + x499
    x501 = x15 * (x117 * x46 * x478 + x412 * x482)
    x502 = x163 + x476 * x96
    x503 = x502 * x79
    x504 = x353 + x478 * x96
    x505 = x15 * (x44 * x504 + x503)
    x506 = x194 * x401 + x505
    x507 = x357 + x482 * x96
    x508 = x50 * x504
    x509 = x15 * (x44 * x507 + x508)
    x510 = x196 * x394
    x511 = x21 * x33
    x512 = x196 * x511 + x510
    x513 = x196 * x405
    x514 = x199 * x421
    x515 = x200 * x511 + x514
    x516 = x199 * x428
    x517 = x174 * x450
    x518 = x195 * x511
    x519 = x203 * x518 + x517
    x520 = x174 * x456
    x521 = x146 * x478
    x522 = x207 * x518 + x521
    x523 = x146 * x482
    x524 = x117 * x504
    x525 = x209 * x518 + x524
    x526 = x117 * x507
    x527 = x15 * (x380 + x504 * x96)
    x528 = x211 * x511 + x527
    x529 = x15 * (x383 + x507 * x96)
    x530 = x213 * x215 - x218 * x8 + x30
    x531 = x5 * x530
    x532 = x37 * x8
    x533 = x213 * x217 - x232 * x532 + x72
    x534 = x31 * x530 - x533 * x74
    x535 = x4 * x534
    x536 = (
        x15
        * (
            x227 * x531
            + x44
            * (
                x225 * x531
                + x44 * (x223 * x531 + x44 * (x44 * x531 + x44 * (x531 + x535)))
            )
        )
        + x20 * x228
    )
    x537 = x530 * x8
    x538 = 2.0 * x216
    x539 = x537 + x538
    x540 = x539 * x79
    x541 = x534 * x8
    x542 = x236 + x541
    x543 = x5 * x539
    x544 = (
        x15
        * (
            x249 * x543
            + x44 * (x247 * x543 + x44 * (x300 * x539 + x44 * (x44 * x542 + x540)))
        )
        + x20 * x250
    )
    x545 = x531 * x96
    x546 = x11 * x531
    x547 = (
        x15
        * (
            x249 * x546
            + x44 * (x247 * x546 + x44 * (x244 * x546 + x44 * (x535 * x96 + x545)))
        )
        + x20 * x261
    )
    x548 = x240 * x46 + x539 * x81
    x549 = x548 * x79
    x550 = x254 + x542 * x81
    x551 = x247 * x5
    x552 = (
        x15 * (x44 * (x300 * x548 + x44 * (x44 * x550 + x549)) + x548 * x551) + x20 * x270
    )
    x553 = x537 * x96 + x538 * x96
    x554 = x553 * x79
    x555 = x263 + x541 * x96
    x556 = (
        x15 * (x44 * (x300 * x553 + x44 * (x44 * x555 + x554)) + x551 * x553) + x20 * x281
    )
    x557 = x128 * x531
    x558 = x12 * x531
    x559 = (
        x15 * (x292 * x558 + x44 * (x290 * x558 + x44 * (x128 * x535 + x557)))
        + x20 * x293
    )
    x560 = x265 * x50 + x548 * x81
    x561 = x560 * x79
    x562 = x273 + x550 * x81
    x563 = x15 * (x300 * x560 + x44 * (x44 * x562 + x561)) + x20 * x301
    x564 = x275 * x50 + x553 * x81
    x565 = x564 * x79
    x566 = x285 + x555 * x81
    x567 = x15 * (x300 * x564 + x44 * (x44 * x566 + x565)) + x20 * x309
    x568 = x128 * x537 + x128 * x538
    x569 = x568 * x79
    x570 = x128 * x541 + x295
    x571 = x15 * (x300 * x568 + x44 * (x44 * x570 + x569)) + x20 * x318
    x572 = x161 * x531
    x573 = x15 * (x326 * x531 + x44 * (x161 * x535 + x572)) + x20 * x327
    x574 = x297 * x50 + x560 * x81
    x575 = x574 * x79
    x576 = x304 + x562 * x81
    x577 = x15 * (x44 * x576 + x575) + x20 * x333
    x578 = x306 * x50 + x564 * x81
    x579 = x578 * x79
    x580 = x312 + x566 * x81
    x581 = x15 * (x44 * x580 + x579) + x20 * x340
    x582 = x314 * x50 + x568 * x81
    x583 = x582 * x79
    x584 = x322 + x570 * x81
    x585 = x15 * (x44 * x584 + x583) + x20 * x347
    x586 = x161 * x537 + x161 * x538
    x587 = x586 * x79
    x588 = x161 * x541 + x329
    x589 = x15 * (x44 * x588 + x587) + x20 * x355
    x590 = x191 * x531
    x591 = x15 * (x191 * x535 + x590) + x20 * x362
    x592 = x15 * (x336 + x576 * x81) + x20 * x366
    x593 = x15 * (x343 + x580 * x81) + x20 * x370
    x594 = x15 * (x350 + x584 * x81) + x20 * x373
    x595 = x15 * (x359 + x588 * x81) + x20 * x377
    x596 = x15 * (x191 * x541 + x364) + x20 * x381
    x597 = x20 * x385 + x211 * x534
    x598 = x213 * x390 - x393 * x8
    x599 = x5 * x598
    x600 = x213 * x392 - x404 * x532
    x601 = x31 * x598 - x600 * x74
    x602 = x15 * (
        x227 * x599
        + x44
        * (
            x225 * x599
            + x44 * (x223 * x599 + x44 * (x44 * x599 + x44 * (x4 * x601 + x599)))
        )
    )
    x603 = x21 * x228 + x602
    x604 = x391 + x598 * x8
    x605 = x407 + x601 * x8
    x606 = x249 * x5
    x607 = x15 * (
        x44 * (x44 * (x300 * x604 + x44 * (x44 * x605 + x604 * x79)) + x551 * x604)
        + x604 * x606
    )
    x608 = x21 * x250 + x607
    x609 = x11 * x598 + x216
    x610 = x11 * x601 + x235
    x611 = x15 * (
        x44 * (x44 * (x300 * x609 + x44 * (x44 * x610 + x609 * x79)) + x551 * x609)
        + x606 * x609
    )
    x612 = x21 * x261 + x611
    x613 = x410 + x604 * x81
    x614 = x407 * x81 + x605 * x81
    x615 = x15 * (x44 * (x300 * x613 + x44 * (x44 * x614 + x613 * x79)) + x551 * x613)
    x616 = x21 * x270 + x615
    x617 = x420 + x609 * x81
    x618 = x421 * x79 + x610 * x81
    x619 = x15 * (x44 * (x300 * x617 + x44 * (x44 * x618 + x617 * x79)) + x551 * x617)
    x620 = x21 * x281 + x619
    x621 = x256 + x609 * x96
    x622 = x235 * x96 + x610 * x96
    x623 = x15 * (x44 * (x300 * x621 + x44 * (x44 * x622 + x621 * x79)) + x551 * x621)
    x624 = x21 * x293 + x623
    x625 = x431 + x613 * x81
    x626 = x107 * x407 + x614 * x81
    x627 = x15 * (x300 * x625 + x44 * (x44 * x626 + x625 * x79))
    x628 = x21 * x301 + x627
    x629 = x439 + x617 * x81
    x630 = x421 * x497 + x618 * x81
    x631 = x15 * (x300 * x629 + x44 * (x44 * x630 + x629 * x79))
    x632 = x21 * x309 + x631
    x633 = x449 + x621 * x81
    x634 = x450 * x79 + x622 * x81
    x635 = x15 * (x300 * x633 + x44 * (x44 * x634 + x633 * x79))
    x636 = x21 * x318 + x635
    x637 = x287 + x621 * x96
    x638 = x128 * x235 + x622 * x96
    x639 = x15 * (x300 * x637 + x44 * (x44 * x638 + x637 * x79))
    x640 = x21 * x327 + x639
    x641 = x459 + x625 * x81
    x642 = x139 * x407 + x626 * x81
    x643 = x15 * (x44 * x642 + x641 * x79)
    x644 = x21 * x333 + x643
    x645 = x465 + x629 * x81
    x646 = x421 * x5
    x647 = x146 * x646 + x630 * x81
    x648 = x15 * (x44 * x647 + x645 * x79)
    x649 = x21 * x340 + x648
    x650 = x470 + x633 * x81
    x651 = x450 * x497 + x634 * x81
    x652 = x15 * (x44 * x651 + x650 * x79)
    x653 = x21 * x347 + x652
    x654 = x477 + x637 * x81
    x655 = x478 * x79 + x638 * x81
    x656 = x15 * (x44 * x655 + x654 * x79)
    x657 = x21 * x355 + x656
    x658 = x324 + x637 * x96
    x659 = x161 * x235 + x638 * x96
    x660 = x15 * (x44 * x659 + x658 * x79)
    x661 = x21 * x362 + x660
    x662 = x15 * (x170 * x407 + x642 * x81)
    x663 = x21 * x366 + x662
    x664 = x15 * (x174 * x646 + x647 * x81)
    x665 = x21 * x370 + x664
    x666 = x146 * x5
    x667 = x15 * (x450 * x666 + x651 * x81)
    x668 = x21 * x373 + x667
    x669 = x15 * (x478 * x497 + x655 * x81)
    x670 = x21 * x377 + x669
    x671 = x15 * (x504 * x79 + x659 * x81)
    x672 = x21 * x381 + x671
    x673 = x15 * (x191 * x235 + x659 * x96)
    x674 = x21 * x385 + x673
    x675 = -x11 * x393 + x30 + x388 * x390
    x676 = x5 * x675
    x677 = x11 * x37
    x678 = x388 * x392 - x404 * x677 + x72
    x679 = x31 * x675 - x678 * x74
    x680 = x4 * x679
    x681 = (
        x15
        * (
            x227 * x676
            + x44
            * (
                x225 * x676
                + x44 * (x223 * x676 + x44 * (x44 * x676 + x44 * (x676 + x680)))
            )
        )
        + x21 * x400
    )
    x682 = x676 * x81
    x683 = x676 * x8
    x684 = (
        x15
        * (
            x249 * x683
            + x44 * (x247 * x683 + x44 * (x412 * x676 + x44 * (x680 * x81 + x682)))
        )
        + x21 * x416
    )
    x685 = x11 * x675 + 2.0 * x391
    x686 = x685 * x79
    x687 = x11 * x679 + x408
    x688 = (
        x15
        * (
            x44 * (x44 * (x300 * x685 + x44 * (x44 * x687 + x686)) + x551 * x685)
            + x606 * x685
        )
        + x21 * x426
    )
    x689 = x107 * x676
    x690 = (
        x15 * (x435 * x676 + x44 * (x433 * x676 + x44 * (x107 * x680 + x689)))
        + x21 * x436
    )
    x691 = x497 * x685
    x692 = x5 * x685
    x693 = x169 * x692
    x694 = (
        x15 * (x44 * (x44 * (x412 * x687 + x691) + x441 * x692) + x693 * x90) + x21 * x444
    )
    x695 = x419 * x50 + x685 * x96
    x696 = x695 * x79
    x697 = x429 + x687 * x96
    x698 = (
        x15 * (x44 * (x300 * x695 + x44 * (x44 * x697 + x696)) + x551 * x695) + x21 * x454
    )
    x699 = x139 * x676
    x700 = x15 * (x44 * (x139 * x680 + x699) + x461 * x676) + x21 * x462
    x701 = x666 * x685
    x702 = x15 * (x112 * x693 + x44 * (x433 * x687 + x701)) + x21 * x467
    x703 = x497 * x695
    x704 = x15 * (x44 * (x412 * x697 + x703) + x441 * x5 * x695) + x21 * x472
    x705 = x448 * x50 + x695 * x96
    x706 = x705 * x79
    x707 = x457 + x697 * x96
    x708 = x15 * (x300 * x705 + x44 * (x44 * x707 + x706)) + x21 * x480
    x709 = x170 * x676
    x710 = x15 * (x170 * x680 + x709) + x21 * x486
    x711 = x174 * x692
    x712 = x15 * (x461 * x687 + x711) + x21 * x490
    x713 = x666 * x695
    x714 = x15 * (x433 * x697 + x713) + x21 * x494
    x715 = x497 * x705
    x716 = x15 * (x412 * x707 + x715) + x21 * x499
    x717 = x476 * x50 + x705 * x96
    x718 = x717 * x79
    x719 = x483 + x707 * x96
    x720 = x15 * (x44 * x719 + x718) + x21 * x505
    x721 = x196 * x679 + x21 * x510
    x722 = x199 * x687 + x21 * x514
    x723 = x174 * x697 + x21 * x517
    x724 = x146 * x707 + x21 * x521
    x725 = x117 * x719 + x21 * x524
    x726 = x15 * (x508 + x719 * x96) + x21 * x527
    x727 = x195 * x4**5
    x728 = x0 * x215
    x729 = x195 * x66
    x730 = x239 * x729
    x731 = x11 * x729
    x732 = x0 * x249
    x733 = x12 * x60
    x734 = x195 * x728
    x735 = x0 * x247
    x736 = x160 * x6
    x737 = x0 * x244
    x738 = x190 * x4
    x739 = x172 + x331 * x81
    x740 = x177 + x338 * x81
    x741 = x183 + x345 * x81
    x742 = x188 + x352 * x81
    x743 = x191 * x238 + x193
    x744 = x530 * x727
    x745 = x20 * x215
    x746 = x727 * x745 + x744
    x747 = x539 * x729
    x748 = x20 * x730 + x747
    x749 = x530 * x731
    x750 = x731 * x745 + x749
    x751 = x249 * x548
    x752 = x20 * x249
    x753 = x265 * x752 + x751
    x754 = x249 * x553
    x755 = x275 * x752 + x754
    x756 = x195 * x530
    x757 = x733 * x756
    x758 = x195 * x745
    x759 = x733 * x758 + x757
    x760 = x247 * x560
    x761 = x20 * x247
    x762 = x297 * x761 + x760
    x763 = x247 * x564
    x764 = x306 * x761 + x763
    x765 = x247 * x568
    x766 = x314 * x761 + x765
    x767 = x736 * x756
    x768 = x736 * x758 + x767
    x769 = x244 * x574
    x770 = x20 * x244
    x771 = x331 * x770 + x769
    x772 = x244 * x578
    x773 = x338 * x770 + x772
    x774 = x244 * x582
    x775 = x345 * x770 + x774
    x776 = x244 * x586
    x777 = x352 * x770 + x776
    x778 = x738 * x756
    x779 = x738 * x758 + x778
    x780 = x15 * (x331 * x50 + x574 * x81)
    x781 = x229 * x739 + x780
    x782 = x15 * (x338 * x50 + x578 * x81)
    x783 = x229 * x740 + x782
    x784 = x15 * (x345 * x50 + x582 * x81)
    x785 = x229 * x741 + x784
    x786 = x15 * (x352 * x50 + x586 * x81)
    x787 = x229 * x742 + x786
    x788 = x15 * (x191 * x537 + x191 * x538)
    x789 = x229 * x743 + x788
    x790 = x211 * x530
    x791 = x211 * x745 + x790
    x792 = x598 * x727
    x793 = x21 * x215
    x794 = x727 * x793 + x792
    x795 = x604 * x729
    x796 = x21 * x730 + x795
    x797 = x609 * x729
    x798 = x731 * x793 + x797
    x799 = x249 * x613
    x800 = x21 * x249
    x801 = x265 * x800 + x799
    x802 = x249 * x617
    x803 = x275 * x800 + x802
    x804 = x249 * x621
    x805 = x195 * x793
    x806 = x733 * x805 + x804
    x807 = x247 * x625
    x808 = x21 * x247
    x809 = x297 * x808 + x807
    x810 = x247 * x629
    x811 = x306 * x808 + x810
    x812 = x247 * x633
    x813 = x314 * x808 + x812
    x814 = x247 * x637
    x815 = x736 * x805 + x814
    x816 = x244 * x641
    x817 = x21 * x244
    x818 = x331 * x817 + x816
    x819 = x244 * x645
    x820 = x338 * x817 + x819
    x821 = x244 * x650
    x822 = x345 * x817 + x821
    x823 = x244 * x654
    x824 = x352 * x817 + x823
    x825 = x244 * x658
    x826 = x738 * x805 + x825
    x827 = x15 * (x485 + x641 * x81)
    x828 = x401 * x739 + x827
    x829 = x15 * (x489 + x645 * x81)
    x830 = x401 * x740 + x829
    x831 = x15 * (x493 + x650 * x81)
    x832 = x401 * x741 + x831
    x833 = x15 * (x498 + x654 * x81)
    x834 = x401 * x742 + x833
    x835 = x15 * (x503 + x658 * x81)
    x836 = x401 * x743 + x835
    x837 = x15 * (x361 + x658 * x96)
    x838 = x211 * x793 + x837
    x839 = x213 * x530 + 2.0 * x231 - x532 * x533
    x840 = x8 * x839
    x841 = 3.0 * x531
    x842 = x840 + x841
    x843 = 3.0 * x540 + x81 * x842
    x844 = x840 * x96 + x841 * x96
    x845 = x195 * x839
    x846 = 3.0 * x549 + x81 * x843
    x847 = 3.0 * x554 + x81 * x844
    x848 = x128 * x840 + x128 * x841
    x849 = 3.0 * x561 + x81 * x846
    x850 = 3.0 * x565 + x81 * x847
    x851 = 3.0 * x569 + x81 * x848
    x852 = x161 * x840 + x161 * x841
    x853 = x213 * x598 + x403 - x532 * x600
    x854 = x727 * x853
    x855 = 2.0 * x599
    x856 = x8 * x853 + x855
    x857 = x729 * x856
    x858 = x11 * x853 + x531
    x859 = x729 * x858
    x860 = x50 * x604 + x81 * x856
    x861 = x249 * x860
    x862 = x50 * x609
    x863 = x81 * x858 + x862
    x864 = x249 * x863
    x865 = x545 + x858 * x96
    x866 = x249 * x865
    x867 = x50 * x613 + x81 * x860
    x868 = x247 * x867
    x869 = x50 * x617 + x81 * x863
    x870 = x247 * x869
    x871 = x50 * x621
    x872 = x81 * x865 + x871
    x873 = x247 * x872
    x874 = x557 + x865 * x96
    x875 = x247 * x874
    x876 = x50 * x625 + x81 * x867
    x877 = x244 * x876
    x878 = x50 * x629 + x81 * x869
    x879 = x244 * x878
    x880 = x50 * x633 + x81 * x872
    x881 = x244 * x880
    x882 = x50 * x637
    x883 = x81 * x874 + x882
    x884 = x244 * x883
    x885 = x572 + x874 * x96
    x886 = x244 * x885
    x887 = x15 * (x50 * x641 + x81 * x876)
    x888 = x15 * (x50 * x645 + x81 * x878)
    x889 = x15 * (x50 * x650 + x81 * x880)
    x890 = x15 * (x50 * x654 + x81 * x883)
    x891 = x50 * x658
    x892 = x15 * (x81 * x885 + x891)
    x893 = x15 * (x590 + x885 * x96)
    x894 = x213 * x675 - x532 * x678
    x895 = x21 * x792 + x727 * x894
    x896 = x676 + x8 * x894
    x897 = x21 * x795 + x729 * x896
    x898 = x11 * x894 + x855
    x899 = x21 * x797 + x729 * x898
    x900 = x682 + x81 * x896
    x901 = x21 * x799 + x249 * x900
    x902 = x686 + x81 * x898
    x903 = x21 * x802 + x249 * x902
    x904 = x862 + x898 * x96
    x905 = x21 * x804 + x249 * x904
    x906 = x689 + x81 * x900
    x907 = x21 * x807 + x247 * x906
    x908 = x691 + x81 * x902
    x909 = x21 * x810 + x247 * x908
    x910 = x696 + x81 * x904
    x911 = x21 * x812 + x247 * x910
    x912 = x871 + x904 * x96
    x913 = x21 * x814 + x247 * x912
    x914 = x699 + x81 * x906
    x915 = x21 * x816 + x244 * x914
    x916 = x701 + x81 * x908
    x917 = x21 * x819 + x244 * x916
    x918 = x703 + x81 * x910
    x919 = x21 * x821 + x244 * x918
    x920 = x706 + x81 * x912
    x921 = x21 * x823 + x244 * x920
    x922 = x882 + x912 * x96
    x923 = x21 * x825 + x244 * x922
    x924 = x15 * (x709 + x81 * x914) + x21 * x827
    x925 = x15 * (x711 + x81 * x916) + x21 * x829
    x926 = x15 * (x713 + x81 * x918) + x21 * x831
    x927 = x15 * (x715 + x81 * x920) + x21 * x833
    x928 = x15 * (x718 + x81 * x922) + x21 * x835
    x929 = x15 * (x891 + x922 * x96) + x21 * x837
    x930 = x0 * x390
    x931 = x729 * x8
    x932 = x0 * x419
    x933 = x195 * x60
    x934 = x9 * x933
    x935 = x8 * x933
    x936 = x195 * x6
    x937 = x137 * x936
    x938 = x9 * x936
    x939 = x169 * x448
    x940 = x0 * x939
    x941 = x199 * x4
    x942 = x144 * x195
    x943 = x441 * x476
    x944 = x174 * x448
    x945 = x146 * x476
    x946 = x117 * x502
    x947 = x193 + x502 * x96
    x948 = x20 * x390
    x949 = x727 * x948 + x792
    x950 = x795 + x931 * x948
    x951 = x20 * x419
    x952 = x729 * x951 + x797
    x953 = x799 + x934 * x948
    x954 = x802 + x935 * x951
    x955 = x448 * x752 + x804
    x956 = x807 + x937 * x948
    x957 = x810 + x938 * x951
    x958 = x20 * x939
    x959 = x812 + x90 * x958
    x960 = x476 * x761 + x814
    x961 = x816 + x941 * x948
    x962 = x819 + x942 * x951
    x963 = x112 * x958 + x821
    x964 = x20 * x943 + x823
    x965 = x502 * x770 + x825
    x966 = x196 * x948 + x827
    x967 = x199 * x951 + x829
    x968 = x20 * x944 + x831
    x969 = x20 * x945 + x833
    x970 = x20 * x946 + x835
    x971 = x229 * x947 + x837
    x972 = x675 * x727
    x973 = x21 * x390
    x974 = x727 * x973 + x972
    x975 = x675 * x931
    x976 = x931 * x973 + x975
    x977 = x685 * x729
    x978 = x21 * x419
    x979 = x729 * x978 + x977
    x980 = x675 * x934
    x981 = x934 * x973 + x980
    x982 = x685 * x935
    x983 = x935 * x978 + x982
    x984 = x249 * x695
    x985 = x448 * x800 + x984
    x986 = x675 * x937
    x987 = x937 * x973 + x986
    x988 = x685 * x938
    x989 = x938 * x978 + x988
    x990 = x169 * x695
    x991 = x90 * x990
    x992 = x21 * x939
    x993 = x90 * x992 + x991
    x994 = x247 * x705
    x995 = x476 * x808 + x994
    x996 = x675 * x941
    x997 = x941 * x973 + x996
    x998 = x685 * x942
    x999 = x942 * x978 + x998
    x1000 = x112 * x990
    x1001 = x1000 + x112 * x992
    x1002 = x441 * x705
    x1003 = x1002 + x21 * x943
    x1004 = x244 * x717
    x1005 = x1004 + x502 * x817
    x1006 = x196 * x675
    x1007 = x1006 + x196 * x973
    x1008 = x199 * x685
    x1009 = x1008 + x199 * x978
    x1010 = x174 * x695
    x1011 = x1010 + x21 * x944
    x1012 = x146 * x705
    x1013 = x1012 + x21 * x945
    x1014 = x117 * x717
    x1015 = x1014 + x21 * x946
    x1016 = x15 * (x50 * x502 + x717 * x96)
    x1017 = x1016 + x401 * x947
    x1018 = x388 * x675 + 2.0 * x403 - x677 * x678
    x1019 = x1018 * x11 + 3.0 * x676
    x1020 = x1019 * x96 + 3.0 * x686
    x1021 = x1020 * x169
    x1022 = x1020 * x96 + 3.0 * x696
    x1023 = x1022 * x96 + 3.0 * x706

    # 378 item(s)
    return numpy.array(
        [
            x0 * x65
            + x0 * (x65 + x70 * x71)
            + x15
            * (
                x44
                * (x44 * (x44 * (x43 * x80 + x44 * (x76 + x78)) + x51 * x80) + x55 * x80)
                + x59 * x80
            ),
            x0 * x93
            + x0 * (x71 * x95 + x93)
            + x15
            * (
                x44 * (x44 * (x44 * (x76 * x81 + x78 * x81) + x80 * x82) + x80 * x85)
                + x80 * x89
            ),
            x0 * x104
            + x0 * (x104 + x105 * x71)
            + x15
            * (
                x102 * x80
                + x44 * (x100 * x80 + x44 * (x44 * (x76 * x96 + x78 * x96) + x80 * x97))
            ),
            x0 * x114
            + x0 * (x114 + x116 * x71)
            + x15 * (x111 * x80 + x44 * (x108 * x80 + x44 * (x107 * x76 + x107 * x78))),
            x0 * x125
            + x0 * (x125 + x127 * x71)
            + x15 * (x123 * x80 + x44 * (x119 * x80 + x44 * (x118 * x76 + x118 * x78))),
            x0 * x135
            + x0 * (x135 + x136 * x71)
            + x15 * (x132 * x80 + x44 * (x129 * x80 + x44 * (x128 * x76 + x128 * x78))),
            x0 * x143
            + x0 * (x143 + x145 * x71)
            + x15 * (x140 * x80 + x44 * (x139 * x76 + x139 * x78)),
            x0 * x151
            + x0 * (x151 + x152 * x71)
            + x15 * (x148 * x80 + x44 * (x147 * x76 + x147 * x78)),
            x0 * x158
            + x0 * (x158 + x159 * x71)
            + x15 * (x155 * x80 + x44 * (x154 * x76 + x154 * x78)),
            x0 * x165
            + x0 * (x165 + x167 * x71)
            + x15 * (x162 * x80 + x44 * (x161 * x76 + x161 * x78)),
            x0 * x171 + x0 * (x171 + x173 * x71) + x15 * (x170 * x76 + x170 * x78),
            x0 * x176 + x0 * (x176 + x178 * x71) + x15 * (x175 * x76 + x175 * x78),
            x0 * x182 + x0 * (x182 + x184 * x71) + x15 * (x181 * x76 + x181 * x78),
            x0 * x187 + x0 * (x187 + x189 * x71) + x15 * (x186 * x76 + x186 * x78),
            x0 * x192 + x0 * (x192 + x194 * x71) + x15 * (x191 * x76 + x191 * x78),
            x0 * x197 + x0 * (x196 * x198 + x197) + x196 * x75,
            x0 * x201 + x0 * (x198 * x200 + x201) + x200 * x75,
            x0 * x204 + x0 * (x203 * x205 + x204) + x203 * x206,
            x0 * x208 + x0 * (x205 * x207 + x208) + x206 * x207,
            x0 * x210 + x0 * (x205 * x209 + x210) + x206 * x209,
            x0 * x212 + x0 * (x198 * x211 + x212) + x211 * x75,
            x0 * x230 + x20 * x65 + x237,
            x0 * x251 + x20 * x93 + x255,
            x0 * x262 + x104 * x20 + x264,
            x0 * x271 + x114 * x20 + x274,
            x0 * x282 + x125 * x20 + x286,
            x0 * x294 + x135 * x20 + x296,
            x0 * x302 + x143 * x20 + x305,
            x0 * x310 + x151 * x20 + x313,
            x0 * x319 + x158 * x20 + x323,
            x0 * x328 + x165 * x20 + x330,
            x0 * x334 + x171 * x20 + x337,
            x0 * x341 + x176 * x20 + x344,
            x0 * x348 + x182 * x20 + x351,
            x0 * x356 + x187 * x20 + x360,
            x0 * x363 + x192 * x20 + x365,
            x0 * x368 + x197 * x20 + x369,
            x0 * x371 + x20 * x201 + x372,
            x0 * x375 + x20 * x204 + x376,
            x0 * x378 + x20 * x208 + x379,
            x0 * x382 + x20 * x210 + x384,
            x0 * x386 + x20 * x212 + x387,
            x0 * x402 + x21 * x65 + x409,
            x0 * x417 + x21 * x93 + x418,
            x0 * x427 + x104 * x21 + x430,
            x0 * x437 + x114 * x21 + x438,
            x0 * x445 + x125 * x21 + x447,
            x0 * x455 + x135 * x21 + x458,
            x0 * x463 + x143 * x21 + x464,
            x0 * x468 + x151 * x21 + x469,
            x0 * x473 + x158 * x21 + x475,
            x0 * x481 + x165 * x21 + x484,
            x0 * x487 + x171 * x21 + x488,
            x0 * x491 + x176 * x21 + x492,
            x0 * x495 + x182 * x21 + x496,
            x0 * x500 + x187 * x21 + x501,
            x0 * x506 + x192 * x21 + x509,
            x0 * x512 + x197 * x21 + x513,
            x0 * x515 + x201 * x21 + x516,
            x0 * x519 + x204 * x21 + x520,
            x0 * x522 + x208 * x21 + x523,
            x0 * x525 + x21 * x210 + x526,
            x0 * x528 + x21 * x212 + x529,
            x20 * x230 + x536,
            x20 * x251 + x544,
            x20 * x262 + x547,
            x20 * x271 + x552,
            x20 * x282 + x556,
            x20 * x294 + x559,
            x20 * x302 + x563,
            x20 * x310 + x567,
            x20 * x319 + x571,
            x20 * x328 + x573,
            x20 * x334 + x577,
            x20 * x341 + x581,
            x20 * x348 + x585,
            x20 * x356 + x589,
            x20 * x363 + x591,
            x20 * x368 + x592,
            x20 * x371 + x593,
            x20 * x375 + x594,
            x20 * x378 + x595,
            x20 * x382 + x596,
            x20 * x386 + x597,
            x20 * x402 + x603,
            x20 * x417 + x608,
            x20 * x427 + x612,
            x20 * x437 + x616,
            x20 * x445 + x620,
            x20 * x455 + x624,
            x20 * x463 + x628,
            x20 * x468 + x632,
            x20 * x473 + x636,
            x20 * x481 + x640,
            x20 * x487 + x644,
            x20 * x491 + x649,
            x20 * x495 + x653,
            x20 * x500 + x657,
            x20 * x506 + x661,
            x20 * x512 + x663,
            x20 * x515 + x665,
            x20 * x519 + x668,
            x20 * x522 + x670,
            x20 * x525 + x672,
            x20 * x528 + x674,
            x21 * x402 + x681,
            x21 * x417 + x684,
            x21 * x427 + x688,
            x21 * x437 + x690,
            x21 * x445 + x694,
            x21 * x455 + x698,
            x21 * x463 + x700,
            x21 * x468 + x702,
            x21 * x473 + x704,
            x21 * x481 + x708,
            x21 * x487 + x710,
            x21 * x491 + x712,
            x21 * x495 + x714,
            x21 * x500 + x716,
            x21 * x506 + x720,
            x21 * x512 + x721,
            x21 * x515 + x722,
            x21 * x519 + x723,
            x21 * x522 + x724,
            x21 * x525 + x725,
            x21 * x528 + x726,
            x0 * x228 + x0 * (x228 + x727 * x728) + x237,
            x0 * x250 + x0 * (x0 * x730 + x250) + x255,
            x0 * x261 + x0 * (x261 + x728 * x731) + x264,
            x0 * x270 + x0 * (x265 * x732 + x270) + x274,
            x0 * x281 + x0 * (x275 * x732 + x281) + x286,
            x0 * x293 + x0 * (x293 + x733 * x734) + x296,
            x0 * x301 + x0 * (x297 * x735 + x301) + x305,
            x0 * x309 + x0 * (x306 * x735 + x309) + x313,
            x0 * x318 + x0 * (x314 * x735 + x318) + x323,
            x0 * x327 + x0 * (x327 + x734 * x736) + x330,
            x0 * x333 + x0 * (x331 * x737 + x333) + x337,
            x0 * x340 + x0 * (x338 * x737 + x340) + x344,
            x0 * x347 + x0 * (x345 * x737 + x347) + x351,
            x0 * x355 + x0 * (x352 * x737 + x355) + x360,
            x0 * x362 + x0 * (x362 + x734 * x738) + x365,
            x0 * x366 + x0 * (x366 + x71 * x739) + x369,
            x0 * x370 + x0 * (x370 + x71 * x740) + x372,
            x0 * x373 + x0 * (x373 + x71 * x741) + x376,
            x0 * x377 + x0 * (x377 + x71 * x742) + x379,
            x0 * x381 + x0 * (x381 + x71 * x743) + x384,
            x0 * x385 + x0 * (x211 * x728 + x385) + x387,
            x0 * x746 + x536,
            x0 * x748 + x544,
            x0 * x750 + x547,
            x0 * x753 + x552,
            x0 * x755 + x556,
            x0 * x759 + x559,
            x0 * x762 + x563,
            x0 * x764 + x567,
            x0 * x766 + x571,
            x0 * x768 + x573,
            x0 * x771 + x577,
            x0 * x773 + x581,
            x0 * x775 + x585,
            x0 * x777 + x589,
            x0 * x779 + x591,
            x0 * x781 + x592,
            x0 * x783 + x593,
            x0 * x785 + x594,
            x0 * x787 + x595,
            x0 * x789 + x596,
            x0 * x791 + x597,
            x0 * x794 + x603,
            x0 * x796 + x608,
            x0 * x798 + x612,
            x0 * x801 + x616,
            x0 * x803 + x620,
            x0 * x806 + x624,
            x0 * x809 + x628,
            x0 * x811 + x632,
            x0 * x813 + x636,
            x0 * x815 + x640,
            x0 * x818 + x644,
            x0 * x820 + x649,
            x0 * x822 + x653,
            x0 * x824 + x657,
            x0 * x826 + x661,
            x0 * x828 + x663,
            x0 * x830 + x665,
            x0 * x832 + x668,
            x0 * x834 + x670,
            x0 * x836 + x672,
            x0 * x838 + x674,
            x20 * x744 + x20 * x746 + x727 * x839,
            x20 * x747 + x20 * x748 + x729 * x842,
            x20 * x749 + x20 * x750 + x731 * x839,
            x20 * x751 + x20 * x753 + x249 * x843,
            x20 * x754 + x20 * x755 + x249 * x844,
            x20 * x757 + x20 * x759 + x733 * x845,
            x20 * x760 + x20 * x762 + x247 * x846,
            x20 * x763 + x20 * x764 + x247 * x847,
            x20 * x765 + x20 * x766 + x247 * x848,
            x20 * x767 + x20 * x768 + x736 * x845,
            x20 * x769 + x20 * x771 + x244 * x849,
            x20 * x772 + x20 * x773 + x244 * x850,
            x20 * x774 + x20 * x775 + x244 * x851,
            x20 * x776 + x20 * x777 + x244 * x852,
            x20 * x778 + x20 * x779 + x738 * x845,
            x15 * (3.0 * x575 + x81 * x849) + x20 * x780 + x20 * x781,
            x15 * (3.0 * x579 + x81 * x850) + x20 * x782 + x20 * x783,
            x15 * (3.0 * x583 + x81 * x851) + x20 * x784 + x20 * x785,
            x15 * (3.0 * x587 + x81 * x852) + x20 * x786 + x20 * x787,
            x15 * (x191 * x840 + x191 * x841) + x20 * x788 + x20 * x789,
            x20 * x790 + x20 * x791 + x211 * x839,
            x20 * x794 + x21 * x744 + x854,
            x20 * x796 + x21 * x747 + x857,
            x20 * x798 + x21 * x749 + x859,
            x20 * x801 + x21 * x751 + x861,
            x20 * x803 + x21 * x754 + x864,
            x20 * x806 + x21 * x757 + x866,
            x20 * x809 + x21 * x760 + x868,
            x20 * x811 + x21 * x763 + x870,
            x20 * x813 + x21 * x765 + x873,
            x20 * x815 + x21 * x767 + x875,
            x20 * x818 + x21 * x769 + x877,
            x20 * x820 + x21 * x772 + x879,
            x20 * x822 + x21 * x774 + x881,
            x20 * x824 + x21 * x776 + x884,
            x20 * x826 + x21 * x778 + x886,
            x20 * x828 + x21 * x780 + x887,
            x20 * x830 + x21 * x782 + x888,
            x20 * x832 + x21 * x784 + x889,
            x20 * x834 + x21 * x786 + x890,
            x20 * x836 + x21 * x788 + x892,
            x20 * x838 + x21 * x790 + x893,
            x21 * x794 + x895,
            x21 * x796 + x897,
            x21 * x798 + x899,
            x21 * x801 + x901,
            x21 * x803 + x903,
            x21 * x806 + x905,
            x21 * x809 + x907,
            x21 * x811 + x909,
            x21 * x813 + x911,
            x21 * x815 + x913,
            x21 * x818 + x915,
            x21 * x820 + x917,
            x21 * x822 + x919,
            x21 * x824 + x921,
            x21 * x826 + x923,
            x21 * x828 + x924,
            x21 * x830 + x925,
            x21 * x832 + x926,
            x21 * x834 + x927,
            x21 * x836 + x928,
            x21 * x838 + x929,
            x0 * x400 + x0 * (x400 + x727 * x930) + x409,
            x0 * x416 + x0 * (x416 + x930 * x931) + x418,
            x0 * x426 + x0 * (x426 + x729 * x932) + x430,
            x0 * x436 + x0 * (x436 + x930 * x934) + x438,
            x0 * x444 + x0 * (x444 + x932 * x935) + x447,
            x0 * x454 + x0 * (x448 * x732 + x454) + x458,
            x0 * x462 + x0 * (x462 + x930 * x937) + x464,
            x0 * x467 + x0 * (x467 + x932 * x938) + x469,
            x0 * x472 + x0 * (x472 + x90 * x940) + x475,
            x0 * x480 + x0 * (x476 * x735 + x480) + x484,
            x0 * x486 + x0 * (x486 + x930 * x941) + x488,
            x0 * x490 + x0 * (x490 + x932 * x942) + x492,
            x0 * x494 + x0 * (x112 * x940 + x494) + x496,
            x0 * x499 + x0 * (x0 * x943 + x499) + x501,
            x0 * x505 + x0 * (x502 * x737 + x505) + x509,
            x0 * x510 + x0 * (x196 * x930 + x510) + x513,
            x0 * x514 + x0 * (x199 * x932 + x514) + x516,
            x0 * x517 + x0 * (x0 * x944 + x517) + x520,
            x0 * x521 + x0 * (x0 * x945 + x521) + x523,
            x0 * x524 + x0 * (x0 * x946 + x524) + x526,
            x0 * x527 + x0 * (x527 + x71 * x947) + x529,
            x0 * x949 + x20 * x400 + x602,
            x0 * x950 + x20 * x416 + x607,
            x0 * x952 + x20 * x426 + x611,
            x0 * x953 + x20 * x436 + x615,
            x0 * x954 + x20 * x444 + x619,
            x0 * x955 + x20 * x454 + x623,
            x0 * x956 + x20 * x462 + x627,
            x0 * x957 + x20 * x467 + x631,
            x0 * x959 + x20 * x472 + x635,
            x0 * x960 + x20 * x480 + x639,
            x0 * x961 + x20 * x486 + x643,
            x0 * x962 + x20 * x490 + x648,
            x0 * x963 + x20 * x494 + x652,
            x0 * x964 + x20 * x499 + x656,
            x0 * x965 + x20 * x505 + x660,
            x0 * x966 + x20 * x510 + x662,
            x0 * x967 + x20 * x514 + x664,
            x0 * x968 + x20 * x517 + x667,
            x0 * x969 + x20 * x521 + x669,
            x0 * x970 + x20 * x524 + x671,
            x0 * x971 + x20 * x527 + x673,
            x0 * x974 + x681,
            x0 * x976 + x684,
            x0 * x979 + x688,
            x0 * x981 + x690,
            x0 * x983 + x694,
            x0 * x985 + x698,
            x0 * x987 + x700,
            x0 * x989 + x702,
            x0 * x993 + x704,
            x0 * x995 + x708,
            x0 * x997 + x710,
            x0 * x999 + x712,
            x0 * x1001 + x714,
            x0 * x1003 + x716,
            x0 * x1005 + x720,
            x0 * x1007 + x721,
            x0 * x1009 + x722,
            x0 * x1011 + x723,
            x0 * x1013 + x724,
            x0 * x1015 + x725,
            x0 * x1017 + x726,
            x20 * x792 + x20 * x949 + x854,
            x20 * x795 + x20 * x950 + x857,
            x20 * x797 + x20 * x952 + x859,
            x20 * x799 + x20 * x953 + x861,
            x20 * x802 + x20 * x954 + x864,
            x20 * x804 + x20 * x955 + x866,
            x20 * x807 + x20 * x956 + x868,
            x20 * x810 + x20 * x957 + x870,
            x20 * x812 + x20 * x959 + x873,
            x20 * x814 + x20 * x960 + x875,
            x20 * x816 + x20 * x961 + x877,
            x20 * x819 + x20 * x962 + x879,
            x20 * x821 + x20 * x963 + x881,
            x20 * x823 + x20 * x964 + x884,
            x20 * x825 + x20 * x965 + x886,
            x20 * x827 + x20 * x966 + x887,
            x20 * x829 + x20 * x967 + x888,
            x20 * x831 + x20 * x968 + x889,
            x20 * x833 + x20 * x969 + x890,
            x20 * x835 + x20 * x970 + x892,
            x20 * x837 + x20 * x971 + x893,
            x20 * x974 + x895,
            x20 * x976 + x897,
            x20 * x979 + x899,
            x20 * x981 + x901,
            x20 * x983 + x903,
            x20 * x985 + x905,
            x20 * x987 + x907,
            x20 * x989 + x909,
            x20 * x993 + x911,
            x20 * x995 + x913,
            x20 * x997 + x915,
            x20 * x999 + x917,
            x1001 * x20 + x919,
            x1003 * x20 + x921,
            x1005 * x20 + x923,
            x1007 * x20 + x924,
            x1009 * x20 + x925,
            x1011 * x20 + x926,
            x1013 * x20 + x927,
            x1015 * x20 + x928,
            x1017 * x20 + x929,
            x1018 * x727 + x21 * x972 + x21 * x974,
            x1018 * x931 + x21 * x975 + x21 * x976,
            x1019 * x729 + x21 * x977 + x21 * x979,
            x1018 * x934 + x21 * x980 + x21 * x981,
            x1019 * x935 + x21 * x982 + x21 * x983,
            x1020 * x249 + x21 * x984 + x21 * x985,
            x1018 * x937 + x21 * x986 + x21 * x987,
            x1019 * x938 + x21 * x988 + x21 * x989,
            x1021 * x90 + x21 * x991 + x21 * x993,
            x1022 * x247 + x21 * x994 + x21 * x995,
            x1018 * x941 + x21 * x996 + x21 * x997,
            x1019 * x942 + x21 * x998 + x21 * x999,
            x1000 * x21 + x1001 * x21 + x1021 * x112,
            x1002 * x21 + x1003 * x21 + x1022 * x441,
            x1004 * x21 + x1005 * x21 + x1023 * x244,
            x1006 * x21 + x1007 * x21 + x1018 * x196,
            x1008 * x21 + x1009 * x21 + x1019 * x199,
            x1010 * x21 + x1011 * x21 + x1020 * x174,
            x1012 * x21 + x1013 * x21 + x1022 * x146,
            x1014 * x21 + x1015 * x21 + x1023 * x117,
            x1016 * x21 + x1017 * x21 + x15 * (x1023 * x96 + 3.0 * x718),
        ]
    )


def _3center2el3d_sph_130(a, A, b, B, c, C):
    """Cartesian (pf|s) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = -x3 - C[0]
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = c + x1
    x12 = c / x11
    x13 = x1 * x12 * (x10**2 + x6**2 + x8**2)
    x14 = boys(1, x13)
    x15 = 17.4934183276249
    x16 = A[1] - B[1]
    x17 = A[2] - B[2]
    x18 = numpy.exp(-a * b * x2 * (x0**2 + x16**2 + x17**2))
    x19 = 2.0 * x11 ** (-1.5) * x15 * x18 * x2
    x20 = x14 * x19
    x21 = c ** (-1.0)
    x22 = x11 ** (-0.5)
    x23 = boys(0, x13)
    x24 = 2.0 * x15 * x18 * x2 * x21 * x22 * x23 - x20
    x25 = x24 * x5
    x26 = -2.0 * x15 * x18 * x2 * x21 * x22 * x23 * x4 + x20 * x6
    x27 = -x26
    x28 = boys(2, x13)
    x29 = x19 * x28
    x30 = -2.0 * x14 * x15 * x18 * x2 * x21 * x22 * x4 + x29 * x6
    x31 = -x30
    x32 = x12 * x31
    x33 = x32 * x6
    x34 = x25 + x27 * x4 - x33
    x35 = 2.0 * x5
    x36 = x5 * (2.0 * x14 * x15 * x18 * x2 * x21 * x22 - x29)
    x37 = boys(3, x13)
    x38 = x19 * x37
    x39 = 2.0 * x15 * x18 * x2 * x21 * x22 * x28 * x4 - x38 * x6
    x40 = x12 * x39
    x41 = x31 * x4 + x36 - x40 * x6
    x42 = x12 * x41
    x43 = x34 * x4 + x35 * (-x26 - x32) - x42 * x6
    x44 = x0 * x34 + x43
    x45 = -x24 * x5
    x46 = x5 * (2.0 * x15 * x18 * x2 * x21 * x22 * x28 - x38)
    x47 = x19 * boys(4, x13)
    x48 = x12 * x6
    x49 = -x7 - A[1]
    x50 = -2.0 * x14 * x15 * x18 * x2 * x21 * x22 * x49 + x29 * x8
    x51 = -x50
    x52 = x12 * x51
    x53 = -2.0 * x15 * x18 * x2 * x21 * x22 * x23 * x49 + x20 * x8
    x54 = x5 * (-x52 - x53)
    x55 = -x53
    x56 = x52 * x6
    x57 = -x4 * x55 + x56
    x58 = -x57
    x59 = 2.0 * x15 * x18 * x2 * x21 * x22 * x28 * x49 - x38 * x8
    x60 = x12 * x59
    x61 = x4 * x51 - x6 * x60
    x62 = x12 * x61
    x63 = x4 * x58 + x54 - x6 * x62
    x64 = x16 * x34 + x63
    x65 = x4 * x55 - x56
    x66 = x16 * x27 + x65
    x67 = x5 * (-x50 - x60)
    x68 = 2.0 * x15 * x18 * x2 * x21 * x22 * x37 * x49 - x47 * x8
    x69 = (
        x35 * (-x57 - x62)
        + x4 * x63
        - x48 * (x4 * x61 - x48 * (x4 * x59 - x48 * x68) + x67)
    )
    x70 = -x9 - A[2]
    x71 = x10 * x29 - 2.0 * x14 * x15 * x18 * x2 * x21 * x22 * x70
    x72 = -x71
    x73 = x12 * x72
    x74 = x10 * x20 - 2.0 * x15 * x18 * x2 * x21 * x22 * x23 * x70
    x75 = x5 * (-x73 - x74)
    x76 = -x74
    x77 = x6 * x73
    x78 = -x4 * x76 + x77
    x79 = -x78
    x80 = -x10 * x38 + 2.0 * x15 * x18 * x2 * x21 * x22 * x28 * x70
    x81 = x12 * x80
    x82 = x4 * x72 - x6 * x81
    x83 = x12 * x82
    x84 = x4 * x79 - x6 * x83 + x75
    x85 = x17 * x34 + x84
    x86 = x4 * x76 - x77
    x87 = x17 * x27 + x86
    x88 = x5 * (-x71 - x81)
    x89 = -x10 * x47 + 2.0 * x15 * x18 * x2 * x21 * x22 * x37 * x70
    x90 = (
        x35 * (-x78 - x83)
        + x4 * x84
        - x48 * (x4 * x82 - x48 * (x4 * x80 - x48 * x89) + x88)
    )
    x91 = x52 * x8
    x92 = x25 + x49 * x55 - x91
    x93 = x36 + x49 * x51 - x60 * x8
    x94 = x12 * x93
    x95 = x6 * x94
    x96 = x16 * x58 + x4 * x92 - x95
    x97 = x16 * x66 + x96
    x98 = x5 * (-x45 + x49 * x55 - x91 - x94)
    x99 = x4 * x92 - x95
    x100 = x12 * x8
    x101 = -x100 * x68 + x46 + x49 * x59
    x102 = x16 * x63 + x4 * x99 - x48 * (-x101 * x48 + x4 * x93) + x98
    x103 = x73 * x8
    x104 = x103 - x49 * x76
    x105 = -x104
    x106 = x49 * x72 - x8 * x81
    x107 = x106 * x12
    x108 = x107 * x6
    x109 = x105 * x4 - x108
    x110 = x109 + x17 * x58
    x111 = x110 + x16 * x87
    x112 = x5 * (-x104 - x107)
    x113 = x105 * x4 - x108
    x114 = -x100 * x89 + x49 * x80
    x115 = x112 + x113 * x4 - x48 * (x106 * x4 - x114 * x48)
    x116 = x115 + x17 * x63
    x117 = x10 * x73
    x118 = -x117 + x25 + x70 * x76
    x119 = -x10 * x81 + x36 + x70 * x72
    x120 = x119 * x12
    x121 = x120 * x6
    x122 = x118 * x4 - x121 + x17 * x79
    x123 = x122 + x17 * x87
    x124 = x5 * (-x117 - x120 - x45 + x70 * x76)
    x125 = x118 * x4 - x121
    x126 = x10 * x12
    x127 = -x126 * x89 + x46 + x70 * x80
    x128 = x124 + x125 * x4 + x17 * x84 - x48 * (x119 * x4 - x127 * x48)
    x129 = x49 * x92 + 2.0 * x54 - x8 * x94
    x130 = -x100 * x101 + x49 * x93 + 2.0 * x67
    x131 = x129 * x4 - x130 * x48 + x16 * x96 + x16 * x99
    x132 = x105 * x49 - x107 * x8 + x75
    x133 = -x100 * x114 + x106 * x49 + x88
    x134 = x132 * x4 - x133 * x48
    x135 = x110 * x16 + x134 + x17 * x99
    x136 = x120 * x8
    x137 = x118 * x49 - x136
    x138 = -x100 * x127 + x119 * x49
    x139 = x113 * x17 + x137 * x4 - x138 * x48
    x140 = x110 * x17 + x139
    x141 = -x10 * x120 + x118 * x70 + 2.0 * x75
    x142 = x119 * x70 - x126 * x127 + 2.0 * x88
    x143 = x122 * x17 + x125 * x17 + x141 * x4 - x142 * x48
    x144 = x0 * x58 + x63
    x145 = x16 * x55 + x92
    x146 = -x103 + x49 * x76
    x147 = x146 + x17 * x55
    x148 = x129 + x16 * x92
    x149 = x145 * x16 + x148
    x150 = x132 + x17 * x92
    x151 = x147 * x16 + x150
    x152 = x105 * x17 + x118 * x49 - x136
    x153 = x147 * x17 + x152
    x154 = -x100 * x133 + 2.0 * x112 + x132 * x49
    x155 = -x100 * x138 + x124 + x132 * x17 + x137 * x49
    x156 = -x100 * x142 + x137 * x17 + x141 * x49 + x152 * x17
    x157 = x0 * x79 + x84
    x158 = x109 + x16 * x79
    x159 = x146 + x16 * x76
    x160 = x118 + x17 * x76
    x161 = x105 * x16 + x132
    x162 = x159 * x16 + x161
    x163 = x152 + x16 * x160
    x164 = x118 * x17 + x141
    x165 = x160 * x17 + x164

    # 30 item(s)
    return numpy.array(
        [
            x0 * x43
            + x0 * x44
            + x0 * (x0 * (x0 * x27 + x34) + x44)
            + x4 * x43
            - x48
            * (
                x35 * (-x30 - x40)
                + x4 * x41
                - x48
                * (
                    x39 * x4
                    + x46
                    - x48 * (2.0 * x15 * x18 * x2 * x21 * x22 * x37 * x4 - x47 * x6)
                )
            )
            + 3.0 * x5 * (x27 * x4 - x33 - x42 - x45),
            x0 * x64 + x0 * (x0 * x66 + x64) + x16 * x43 + x69,
            x0 * x85 + x0 * (x0 * x87 + x85) + x17 * x43 + x90,
            x0 * x97 + x102 + x16 * x64,
            x0 * x111 + x116 + x16 * x85,
            x0 * x123 + x128 + x17 * x85,
            x131 + x16 * x97,
            x111 * x16 + x135,
            x123 * x16 + x140,
            x123 * x17 + x143,
            x0 * x144 + x0 * x63 + x0 * (x0 * (x0 * x55 + x65) + x144) + x69,
            x0 * x96 + x0 * (x0 * x145 + x96) + x102,
            x0 * x110 + x0 * (x0 * x147 + x110) + x116,
            x0 * x149 + x131,
            x0 * x151 + x135,
            x0 * x153 + x140,
            -x100 * x130 + x129 * x16 + x129 * x49 + x148 * x16 + x149 * x16 + 3.0 * x98,
            x129 * x17 + x150 * x16 + x151 * x16 + x154,
            x150 * x17 + x153 * x16 + x155,
            x153 * x17 + x156,
            x0 * x157 + x0 * x84 + x0 * (x0 * (x0 * x76 + x86) + x157) + x90,
            x0 * x158 + x0 * (x0 * x159 + x158) + x115 + x16 * x84,
            x0 * x122 + x0 * (x0 * x160 + x122) + x128,
            x0 * x162 + x113 * x16 + x134 + x158 * x16,
            x0 * x163 + x122 * x16 + x139,
            x0 * x165 + x143,
            x132 * x16 + x154 + x16 * x161 + x16 * x162,
            x152 * x16 + x155 + x16 * x163,
            x156 + x16 * x165,
            3.0 * x124 - x126 * x142 + x141 * x17 + x141 * x70 + x164 * x17 + x165 * x17,
        ]
    )


def _3center2el3d_sph_131(a, A, b, B, c, C):
    """Cartesian (pf|p) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = -x2 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x2 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = c + x1
    x12 = x11 ** (-1.0)
    x13 = c * x12
    x14 = x1 * x13 * (x10**2 + x4**2 + x8**2)
    x15 = boys(2, x14)
    x16 = 17.4934183276249
    x17 = A[1] - B[1]
    x18 = A[2] - B[2]
    x19 = numpy.exp(-a * b * x2 * (x0**2 + x17**2 + x18**2))
    x20 = x16 * x19 * x2
    x21 = 2.0 * x11 ** (-1.5) * x20
    x22 = x15 * x21
    x23 = c ** (-1.0)
    x24 = x11 ** (-0.5)
    x25 = boys(1, x14)
    x26 = 2.0 * x16 * x19 * x2 * x23 * x24 * x25 - x22
    x27 = x26 * x6
    x28 = -2.0 * x16 * x19 * x2 * x23 * x24 * x25 * x5 + x22 * x4
    x29 = -x28
    x30 = boys(3, x14)
    x31 = x21 * x30
    x32 = -2.0 * x15 * x16 * x19 * x2 * x23 * x24 * x5 + x31 * x4
    x33 = -x32
    x34 = x13 * x33
    x35 = x34 * x4
    x36 = x27 + x29 * x5 - x35
    x37 = 2.0 * x6
    x38 = x6 * (2.0 * x15 * x16 * x19 * x2 * x23 * x24 - x31)
    x39 = boys(4, x14)
    x40 = x21 * x39
    x41 = 2.0 * x16 * x19 * x2 * x23 * x24 * x30 * x5 - x4 * x40
    x42 = x13 * x41
    x43 = x33 * x5 + x38 - x4 * x42
    x44 = x13 * x43
    x45 = x36 * x5 + x37 * (-x28 - x34) - x4 * x44
    x46 = x36 * x6
    x47 = x1 * x12
    x48 = x47 * (x4 * x45 + 3.0 * x46)
    x49 = x29 * x6
    x50 = x47 * (x36 * x4 + 2.0 * x49)
    x51 = x0 * x50 + x48
    x52 = x20 * x23 * x24 * x25 * x37
    x53 = x47 * (x29 * x4 + x52)
    x54 = -x26 * x6
    x55 = x6 * (2.0 * x16 * x19 * x2 * x23 * x24 * x30 - x40)
    x56 = x21 * boys(5, x14)
    x57 = x13 * x4
    x58 = (
        x45 * x5
        - x57
        * (
            x37 * (-x32 - x42)
            + x43 * x5
            - x57
            * (
                x41 * x5
                + x55
                - x57 * (2.0 * x16 * x19 * x2 * x23 * x24 * x39 * x5 - x4 * x56)
            )
        )
        + 3.0 * x6 * (x29 * x5 - x35 - x44 - x54)
    )
    x59 = x45 * x6
    x60 = x47 * x8
    x61 = x45 * x60
    x62 = x36 * x60
    x63 = x0 * x62 + x61
    x64 = x0 * x29
    x65 = x10 * x47
    x66 = x45 * x65
    x67 = x36 * x65
    x68 = x0 * x67 + x66
    x69 = -x7 - A[1]
    x70 = -2.0 * x15 * x16 * x19 * x2 * x23 * x24 * x69 + x31 * x8
    x71 = -x70
    x72 = x13 * x71
    x73 = -2.0 * x16 * x19 * x2 * x23 * x24 * x25 * x69 + x22 * x8
    x74 = x6 * (-x72 - x73)
    x75 = -x73
    x76 = x4 * x72 - x5 * x75
    x77 = -x76
    x78 = 2.0 * x16 * x19 * x2 * x23 * x24 * x30 * x69 - x40 * x8
    x79 = x13 * x78
    x80 = -x4 * x79 + x5 * x71
    x81 = x13 * x80
    x82 = -x4 * x81 + x5 * x77 + x74
    x83 = x6 * x77
    x84 = 2.0 * x83
    x85 = x47 * (x4 * x82 + x84)
    x86 = x17 * x50 + x85
    x87 = x6 * x75
    x88 = x47 * (x4 * x77 + x87)
    x89 = x17 * x53 + x88
    x90 = x6 * (-x70 - x79)
    x91 = 2.0 * x16 * x19 * x2 * x23 * x24 * x39 * x69 - x56 * x8
    x92 = (
        x37 * (-x76 - x81)
        + x5 * x82
        - x57 * (x5 * x80 - x57 * (x5 * x78 - x57 * x91) + x90)
    )
    x93 = x6 * x82
    x94 = x47 * (x4 * x92 + 3.0 * x93)
    x95 = x47 * (x46 + x8 * x82)
    x96 = x17 * x62 + x95
    x97 = x47 * (x49 + x77 * x8)
    x98 = x17 * x29
    x99 = x60 * x98 + x97
    x100 = x47 * (x59 + x8 * x92)
    x101 = x65 * x82
    x102 = x101 + x17 * x67
    x103 = x65 * x77
    x104 = x103 + x65 * x98
    x105 = x65 * x92
    x106 = -x9 - A[2]
    x107 = x10 * x31 - 2.0 * x106 * x15 * x16 * x19 * x2 * x23 * x24
    x108 = -x107
    x109 = x108 * x13
    x110 = x10 * x22 - 2.0 * x106 * x16 * x19 * x2 * x23 * x24 * x25
    x111 = x6 * (-x109 - x110)
    x112 = -x110
    x113 = x109 * x4 - x112 * x5
    x114 = -x113
    x115 = -x10 * x40 + 2.0 * x106 * x16 * x19 * x2 * x23 * x24 * x30
    x116 = x115 * x13
    x117 = x108 * x5 - x116 * x4
    x118 = x117 * x13
    x119 = x111 + x114 * x5 - x118 * x4
    x120 = x114 * x6
    x121 = 2.0 * x120
    x122 = x47 * (x119 * x4 + x121)
    x123 = x122 + x18 * x50
    x124 = x112 * x6
    x125 = x47 * (x114 * x4 + x124)
    x126 = x125 + x18 * x53
    x127 = x6 * (-x107 - x116)
    x128 = -x10 * x56 + 2.0 * x106 * x16 * x19 * x2 * x23 * x24 * x39
    x129 = (
        x119 * x5
        + x37 * (-x113 - x118)
        - x57 * (x117 * x5 + x127 - x57 * (x115 * x5 - x128 * x57))
    )
    x130 = x119 * x6
    x131 = x47 * (x129 * x4 + 3.0 * x130)
    x132 = x119 * x60
    x133 = x132 + x18 * x62
    x134 = x114 * x60
    x135 = x18 * x29
    x136 = x134 + x135 * x60
    x137 = x129 * x60
    x138 = x47 * (x10 * x119 + x46)
    x139 = x138 + x18 * x67
    x140 = x47 * (x10 * x114 + x49)
    x141 = x135 * x65 + x140
    x142 = x47 * (x10 * x129 + x59)
    x143 = x72 * x8
    x144 = -x143 + x27 + x69 * x75
    x145 = x144 * x6
    x146 = x38 + x69 * x71 - x79 * x8
    x147 = x13 * x146
    x148 = x144 * x5 - x147 * x4
    x149 = x47 * (x145 + x148 * x4)
    x150 = x149 + x17 * x88
    x151 = x150 + x17 * x89
    x152 = x6 * (-x143 - x147 - x54 + x69 * x75)
    x153 = x13 * x8
    x154 = -x153 * x91 + x55 + x69 * x78
    x155 = x148 * x5 + x152 - x57 * (x146 * x5 - x154 * x57)
    x156 = x148 * x6
    x157 = x17 * x85 + x47 * (x155 * x4 + 2.0 * x156)
    x158 = x47 * (x148 * x8 + x84)
    x159 = x158 + x17 * x97
    x160 = x159 + x17 * x99
    x161 = x17 * x95 + x47 * (x155 * x8 + 2.0 * x93)
    x162 = x148 * x65
    x163 = x103 * x17 + x162
    x164 = x104 * x17 + x163
    x165 = x101 * x17 + x155 * x65
    x166 = x109 * x8 - x112 * x69
    x167 = -x166
    x168 = x167 * x6
    x169 = x108 * x69 - x116 * x8
    x170 = x13 * x169
    x171 = x167 * x5 - x170 * x4
    x172 = x47 * (x168 + x171 * x4)
    x173 = x172 + x18 * x88
    x174 = x126 * x17 + x173
    x175 = x6 * (-x166 - x170)
    x176 = x115 * x69 - x128 * x153
    x177 = x171 * x5 + x175 - x57 * (x169 * x5 - x176 * x57)
    x178 = x171 * x37
    x179 = x47 * (x177 * x4 + x178)
    x180 = x179 + x18 * x85
    x181 = x47 * (x120 + x171 * x8)
    x182 = x18 * x97 + x181
    x183 = x136 * x17 + x182
    x184 = x47 * (x130 + x177 * x8)
    x185 = x18 * x95 + x184
    x186 = x47 * (x10 * x171 + x83)
    x187 = x103 * x18 + x186
    x188 = x141 * x17 + x187
    x189 = x47 * (x10 * x177 + x93)
    x190 = x101 * x18 + x189
    x191 = x10 * x109
    x192 = x106 * x112 - x191 + x27
    x193 = x192 * x6
    x194 = -x10 * x116 + x106 * x108 + x38
    x195 = x13 * x194
    x196 = x192 * x5 - x195 * x4
    x197 = x47 * (x193 + x196 * x4)
    x198 = x125 * x18 + x197
    x199 = x126 * x18 + x198
    x200 = x6 * (x106 * x112 - x191 - x195 - x54)
    x201 = x10 * x13
    x202 = x106 * x115 - x128 * x201 + x55
    x203 = x196 * x5 + x200 - x57 * (x194 * x5 - x202 * x57)
    x204 = x196 * x6
    x205 = x122 * x18 + x47 * (x203 * x4 + 2.0 * x204)
    x206 = x196 * x60
    x207 = x134 * x18 + x206
    x208 = x136 * x18 + x207
    x209 = x132 * x18 + x203 * x60
    x210 = x47 * (x10 * x196 + x121)
    x211 = x140 * x18 + x210
    x212 = x141 * x18 + x211
    x213 = x138 * x18 + x47 * (x10 * x203 + 2.0 * x130)
    x214 = x144 * x69 - x147 * x8 + 2.0 * x74
    x215 = x214 * x6
    x216 = x146 * x69 - x153 * x154 + 2.0 * x90
    x217 = x214 * x5 - x216 * x57
    x218 = x149 * x17 + x150 * x17 + x47 * (x215 + x217 * x4)
    x219 = x158 * x17 + x159 * x17 + x47 * (3.0 * x156 + x217 * x8)
    x220 = x162 * x17 + x163 * x17 + x217 * x65
    x221 = x111 + x167 * x69 - x170 * x8
    x222 = x221 * x6
    x223 = x127 - x153 * x176 + x169 * x69
    x224 = x221 * x5 - x223 * x57
    x225 = x47 * (x222 + x224 * x4)
    x226 = x149 * x18 + x17 * x173 + x225
    x227 = x47 * (x178 + x224 * x8)
    x228 = x158 * x18 + x17 * x182 + x227
    x229 = x47 * (x10 * x224 + x156)
    x230 = x162 * x18 + x17 * x187 + x229
    x231 = x192 * x69 - x195 * x8
    x232 = x231 * x6
    x233 = -x153 * x202 + x194 * x69
    x234 = x231 * x5 - x233 * x57
    x235 = x172 * x18 + x47 * (x232 + x234 * x4)
    x236 = x173 * x18 + x235
    x237 = x18 * x181 + x47 * (x204 + x234 * x8)
    x238 = x18 * x182 + x237
    x239 = x18 * x186 + x47 * (x10 * x234 + x178)
    x240 = x18 * x187 + x239
    x241 = -x10 * x195 + x106 * x192 + 2.0 * x111
    x242 = x241 * x6
    x243 = x106 * x194 + 2.0 * x127 - x201 * x202
    x244 = x241 * x5 - x243 * x57
    x245 = x18 * x197 + x18 * x198 + x47 * (x242 + x244 * x4)
    x246 = x18 * x206 + x18 * x207 + x244 * x60
    x247 = x18 * x210 + x18 * x211 + x47 * (x10 * x244 + 3.0 * x204)
    x248 = x0 * x88 + x85
    x249 = x4 * x47
    x250 = x0 * x75
    x251 = x0 * x97 + x95
    x252 = x47 * (x52 + x75 * x8)
    x253 = x0 * x103 + x101
    x254 = x144 * x249
    x255 = x17 * x75
    x256 = x249 * x255 + x254
    x257 = x47 * (x144 * x8 + 2.0 * x87)
    x258 = x17 * x252 + x257
    x259 = x144 * x65
    x260 = x255 * x65 + x259
    x261 = x167 * x249
    x262 = x18 * x75
    x263 = x249 * x262 + x261
    x264 = x47 * (x124 + x167 * x8)
    x265 = x18 * x252 + x264
    x266 = x47 * (x10 * x167 + x87)
    x267 = x262 * x65 + x266
    x268 = x214 * x249
    x269 = x17 * x254 + x268
    x270 = x17 * x256 + x269
    x271 = x47 * (3.0 * x145 + x214 * x8)
    x272 = x17 * x257 + x271
    x273 = x17 * x258 + x272
    x274 = x214 * x65
    x275 = x17 * x259 + x274
    x276 = x17 * x260 + x275
    x277 = x221 * x249
    x278 = x18 * x254 + x277
    x279 = x17 * x263 + x278
    x280 = 2.0 * x168
    x281 = x47 * (x221 * x8 + x280)
    x282 = x18 * x257 + x281
    x283 = x17 * x265 + x282
    x284 = x47 * (x10 * x221 + x145)
    x285 = x18 * x259 + x284
    x286 = x17 * x267 + x285
    x287 = x231 * x249
    x288 = x18 * x261 + x287
    x289 = x18 * x263 + x288
    x290 = x47 * (x193 + x231 * x8)
    x291 = x18 * x264 + x290
    x292 = x18 * x265 + x291
    x293 = x47 * (x10 * x231 + x280)
    x294 = x18 * x266 + x293
    x295 = x18 * x267 + x294
    x296 = 3.0 * x152 - x153 * x216 + x214 * x69
    x297 = -x153 * x223 + 2.0 * x175 + x221 * x69
    x298 = x249 * x297
    x299 = x47 * (3.0 * x222 + x297 * x8)
    x300 = x47 * (x10 * x297 + x215)
    x301 = -x153 * x233 + x200 + x231 * x69
    x302 = x18 * x277 + x249 * x301
    x303 = x18 * x281 + x47 * (2.0 * x232 + x301 * x8)
    x304 = x18 * x284 + x47 * (x10 * x301 + 2.0 * x222)
    x305 = -x153 * x243 + x241 * x69
    x306 = x18 * x287 + x18 * x288 + x249 * x305
    x307 = x18 * x290 + x18 * x291 + x47 * (x242 + x305 * x8)
    x308 = x18 * x293 + x18 * x294 + x47 * (x10 * x305 + 3.0 * x232)
    x309 = x0 * x125 + x122
    x310 = x0 * x112
    x311 = x0 * x134 + x132
    x312 = x0 * x140 + x138
    x313 = x47 * (x10 * x112 + x52)
    x314 = x125 * x17 + x172
    x315 = x112 * x17
    x316 = x249 * x315 + x261
    x317 = x134 * x17 + x181
    x318 = x264 + x315 * x60
    x319 = x140 * x17 + x186
    x320 = x17 * x313 + x266
    x321 = x192 * x249
    x322 = x112 * x18
    x323 = x249 * x322 + x321
    x324 = x192 * x60
    x325 = x322 * x60 + x324
    x326 = x47 * (x10 * x192 + 2.0 * x124)
    x327 = x18 * x313 + x326
    x328 = x17 * x261 + x277
    x329 = x17 * x316 + x328
    x330 = x17 * x264 + x281
    x331 = x17 * x318 + x330
    x332 = x17 * x266 + x284
    x333 = x17 * x320 + x332
    x334 = x17 * x323 + x288
    x335 = x17 * x325 + x291
    x336 = x17 * x327 + x294
    x337 = x241 * x249
    x338 = x18 * x321 + x337
    x339 = x18 * x323 + x338
    x340 = x241 * x60
    x341 = x18 * x324 + x340
    x342 = x18 * x325 + x341
    x343 = x47 * (x10 * x241 + 3.0 * x193)
    x344 = x18 * x326 + x343
    x345 = x18 * x327 + x344
    x346 = x106 * x241 + 3.0 * x200 - x201 * x243

    # 90 item(s)
    return numpy.array(
        [
            x0 * x48
            + x0 * x51
            + x0 * (x0 * (x0 * x53 + x50) + x51)
            + x47 * (x4 * x58 + 4.0 * x59),
            x0 * x61 + x0 * x63 + x0 * (x0 * (x60 * x64 + x62) + x63) + x58 * x60,
            x0 * x66 + x0 * x68 + x0 * (x0 * (x64 * x65 + x67) + x68) + x58 * x65,
            x0 * x86 + x0 * (x0 * x89 + x86) + x17 * x48 + x94,
            x0 * x96 + x0 * (x0 * x99 + x96) + x100 + x17 * x61,
            x0 * x102 + x0 * (x0 * x104 + x102) + x105 + x17 * x66,
            x0 * x123 + x0 * (x0 * x126 + x123) + x131 + x18 * x48,
            x0 * x133 + x0 * (x0 * x136 + x133) + x137 + x18 * x61,
            x0 * x139 + x0 * (x0 * x141 + x139) + x142 + x18 * x66,
            x0 * x151 + x157 + x17 * x86,
            x0 * x160 + x161 + x17 * x96,
            x0 * x164 + x102 * x17 + x165,
            x0 * x174 + x123 * x17 + x180,
            x0 * x183 + x133 * x17 + x185,
            x0 * x188 + x139 * x17 + x190,
            x0 * x199 + x123 * x18 + x205,
            x0 * x208 + x133 * x18 + x209,
            x0 * x212 + x139 * x18 + x213,
            x151 * x17 + x218,
            x160 * x17 + x219,
            x164 * x17 + x220,
            x17 * x174 + x226,
            x17 * x183 + x228,
            x17 * x188 + x230,
            x17 * x199 + x236,
            x17 * x208 + x238,
            x17 * x212 + x240,
            x18 * x199 + x245,
            x18 * x208 + x246,
            x18 * x212 + x247,
            x0 * x248 + x0 * x85 + x0 * (x0 * (x249 * x250 + x88) + x248) + x94,
            x0 * x251 + x0 * x95 + x0 * (x0 * (x0 * x252 + x97) + x251) + x100,
            x0 * x101 + x0 * x253 + x0 * (x0 * (x103 + x250 * x65) + x253) + x105,
            x0 * x150 + x0 * (x0 * x256 + x150) + x157,
            x0 * x159 + x0 * (x0 * x258 + x159) + x161,
            x0 * x163 + x0 * (x0 * x260 + x163) + x165,
            x0 * x173 + x0 * (x0 * x263 + x173) + x180,
            x0 * x182 + x0 * (x0 * x265 + x182) + x185,
            x0 * x187 + x0 * (x0 * x267 + x187) + x190,
            x0 * x270 + x218,
            x0 * x273 + x219,
            x0 * x276 + x220,
            x0 * x279 + x226,
            x0 * x283 + x228,
            x0 * x286 + x230,
            x0 * x289 + x236,
            x0 * x292 + x238,
            x0 * x295 + x240,
            x17 * x268 + x17 * x269 + x17 * x270 + x249 * x296,
            x17 * x271 + x17 * x272 + x17 * x273 + x47 * (4.0 * x215 + x296 * x8),
            x17 * x274 + x17 * x275 + x17 * x276 + x296 * x65,
            x17 * x278 + x17 * x279 + x18 * x268 + x298,
            x17 * x282 + x17 * x283 + x18 * x271 + x299,
            x17 * x285 + x17 * x286 + x18 * x274 + x300,
            x17 * x289 + x18 * x278 + x302,
            x17 * x292 + x18 * x282 + x303,
            x17 * x295 + x18 * x285 + x304,
            x18 * x289 + x306,
            x18 * x292 + x307,
            x18 * x295 + x308,
            x0 * x122 + x0 * x309 + x0 * (x0 * (x125 + x249 * x310) + x309) + x131,
            x0 * x132 + x0 * x311 + x0 * (x0 * (x134 + x310 * x60) + x311) + x137,
            x0 * x138 + x0 * x312 + x0 * (x0 * (x0 * x313 + x140) + x312) + x142,
            x0 * x314 + x0 * (x0 * x316 + x314) + x122 * x17 + x179,
            x0 * x317 + x0 * (x0 * x318 + x317) + x132 * x17 + x184,
            x0 * x319 + x0 * (x0 * x320 + x319) + x138 * x17 + x189,
            x0 * x198 + x0 * (x0 * x323 + x198) + x205,
            x0 * x207 + x0 * (x0 * x325 + x207) + x209,
            x0 * x211 + x0 * (x0 * x327 + x211) + x213,
            x0 * x329 + x17 * x172 + x17 * x314 + x225,
            x0 * x331 + x17 * x181 + x17 * x317 + x227,
            x0 * x333 + x17 * x186 + x17 * x319 + x229,
            x0 * x334 + x17 * x198 + x235,
            x0 * x335 + x17 * x207 + x237,
            x0 * x336 + x17 * x211 + x239,
            x0 * x339 + x245,
            x0 * x342 + x246,
            x0 * x345 + x247,
            x17 * x277 + x17 * x328 + x17 * x329 + x298,
            x17 * x281 + x17 * x330 + x17 * x331 + x299,
            x17 * x284 + x17 * x332 + x17 * x333 + x300,
            x17 * x288 + x17 * x334 + x302,
            x17 * x291 + x17 * x335 + x303,
            x17 * x294 + x17 * x336 + x304,
            x17 * x339 + x306,
            x17 * x342 + x307,
            x17 * x345 + x308,
            x18 * x337 + x18 * x338 + x18 * x339 + x249 * x346,
            x18 * x340 + x18 * x341 + x18 * x342 + x346 * x60,
            x18 * x343 + x18 * x344 + x18 * x345 + x47 * (x10 * x346 + 4.0 * x242),
        ]
    )


def _3center2el3d_sph_132(a, A, b, B, c, C):
    """Cartesian (pf|d) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = x4**2
    x8 = -x2 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x2 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x1
    x15 = x14 ** (-1.0)
    x16 = c * x15
    x17 = x1 * x16 * (x10 + x13 + x7)
    x18 = boys(3, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x0**2 + x21**2 + x22**2))
    x24 = x2 * x20 * x23
    x25 = 2.0 * x19 * x24
    x26 = x18 * x25
    x27 = c ** (-1.0)
    x28 = x14 ** (-0.5)
    x29 = boys(2, x17)
    x30 = 2.0 * x2 * x20 * x23 * x27 * x28 * x29 - x26
    x31 = x30 * x6
    x32 = -2.0 * x2 * x20 * x23 * x27 * x28 * x29 * x5 + x26 * x4
    x33 = -x32
    x34 = boys(4, x17)
    x35 = x25 * x34
    x36 = -2.0 * x18 * x2 * x20 * x23 * x27 * x28 * x5 + x35 * x4
    x37 = -x36
    x38 = x16 * x37
    x39 = x38 * x4
    x40 = x31 + x33 * x5 - x39
    x41 = 2.0 * x6
    x42 = x6 * (2.0 * x18 * x2 * x20 * x23 * x27 * x28 - x35)
    x43 = boys(5, x17)
    x44 = x25 * x43
    x45 = 2.0 * x2 * x20 * x23 * x27 * x28 * x34 * x5 - x4 * x44
    x46 = x16 * x45
    x47 = x37 * x5 - x4 * x46 + x42
    x48 = x16 * x47
    x49 = -x4 * x48 + x40 * x5 + x41 * (-x32 - x38)
    x50 = x4 * x49
    x51 = x40 * x6
    x52 = 3.0 * x51
    x53 = x50 + x52
    x54 = x1 * x15
    x55 = x4 * x54
    x56 = x4 * x40
    x57 = x33 * x6
    x58 = 2.0 * x57
    x59 = x56 + x58
    x60 = 3.0 * x6
    x61 = x54 * x60
    x62 = x54 * (x53 * x55 + x59 * x61)
    x63 = x33 * x4
    x64 = x27 * x29 * x41
    x65 = x24 * x28 * x64
    x66 = x63 + x65
    x67 = x41 * x54
    x68 = x54 * (x55 * x59 + x66 * x67)
    x69 = x0 * x68 + x62
    x70 = x19 * x20 * x23 * x64
    x71 = x4 * x70 + x55 * x66
    x72 = x0 * x54
    x73 = -x30 * x6
    x74 = x6 * (2.0 * x2 * x20 * x23 * x27 * x28 * x34 - x44)
    x75 = x25 * boys(6, x17)
    x76 = x16 * x4
    x77 = (
        x49 * x5
        + x60 * (x33 * x5 - x39 - x48 - x73)
        - x76
        * (
            x41 * (-x36 - x46)
            + x47 * x5
            - x76
            * (
                x45 * x5
                + x74
                - x76 * (2.0 * x2 * x20 * x23 * x27 * x28 * x43 * x5 - x4 * x75)
            )
        )
    )
    x78 = x4 * x77
    x79 = x49 * x6
    x80 = 4.0 * x79
    x81 = x54 * x6
    x82 = x54 * x9
    x83 = x54 * (x50 * x82 + x52 * x82)
    x84 = x54 * (x56 * x82 + x58 * x82)
    x85 = x0 * x84 + x83
    x86 = x70 * x9
    x87 = x63 * x82 + x86
    x88 = x12 * x54
    x89 = x54 * (x50 * x88 + x52 * x88)
    x90 = x54 * (x56 * x88 + x58 * x88)
    x91 = x0 * x90 + x89
    x92 = x12 * x70
    x93 = x63 * x88 + x92
    x94 = x1**2 / x14**2
    x95 = x10 * x94
    x96 = x49 * x95
    x97 = x40 * x95
    x98 = x0 * x97 + x96
    x99 = x0 * x33
    x100 = x9 * x94
    x101 = x100 * x12
    x102 = x101 * x49
    x103 = x101 * x40
    x104 = x0 * x103 + x102
    x105 = x13 * x94
    x106 = x105 * x49
    x107 = x105 * x40
    x108 = x0 * x107 + x106
    x109 = -x8 - A[1]
    x110 = -2.0 * x109 * x18 * x2 * x20 * x23 * x27 * x28 + x35 * x9
    x111 = -x110
    x112 = x111 * x16
    x113 = -2.0 * x109 * x2 * x20 * x23 * x27 * x28 * x29 + x26 * x9
    x114 = x6 * (-x112 - x113)
    x115 = -x113
    x116 = x112 * x4 - x115 * x5
    x117 = -x116
    x118 = 2.0 * x109 * x2 * x20 * x23 * x27 * x28 * x34 - x44 * x9
    x119 = x118 * x16
    x120 = x111 * x5 - x119 * x4
    x121 = x120 * x16
    x122 = x114 + x117 * x5 - x121 * x4
    x123 = x122 * x4
    x124 = x117 * x6
    x125 = 2.0 * x124
    x126 = x123 + x125
    x127 = x115 * x6
    x128 = x117 * x4
    x129 = x127 + x128
    x130 = x54 * (x126 * x55 + x129 * x67)
    x131 = x130 + x21 * x68
    x132 = x54 * (x127 * x55 + x129 * x55)
    x133 = x21 * x54
    x134 = x132 + x133 * x71
    x135 = x6 * (-x110 - x119)
    x136 = 2.0 * x109 * x2 * x20 * x23 * x27 * x28 * x43 - x75 * x9
    x137 = (
        x122 * x5
        + x41 * (-x116 - x121)
        - x76 * (x120 * x5 + x135 - x76 * (x118 * x5 - x136 * x76))
    )
    x138 = x137 * x4
    x139 = x122 * x6
    x140 = 3.0 * x139
    x141 = x54 * (x126 * x61 + x55 * (x138 + x140))
    x142 = x122 * x9
    x143 = x142 + x51
    x144 = x117 * x9
    x145 = x144 + x57
    x146 = x145 * x67
    x147 = x54 * (x143 * x55 + x146)
    x148 = x147 + x21 * x84
    x149 = x115 * x9
    x150 = x149 + x65
    x151 = x54 * (x145 * x55 + x150 * x81)
    x152 = x133 * x87 + x151
    x153 = x137 * x9
    x154 = x153 + x79
    x155 = x54 * (x143 * x61 + x154 * x55)
    x156 = x125 * x88
    x157 = x54 * (x123 * x88 + x156)
    x158 = x157 + x21 * x90
    x159 = x127 * x88
    x160 = x54 * (x128 * x88 + x159)
    x161 = x133 * x93 + x160
    x162 = x54 * (x138 * x88 + x140 * x88)
    x163 = x54 * (x143 * x82 + x51 * x82)
    x164 = x163 + x21 * x97
    x165 = x54 * (x145 * x82 + x57 * x82)
    x166 = x21 * x33
    x167 = x165 + x166 * x95
    x168 = x54 * (x154 * x82 + x79 * x82)
    x169 = x51 * x88
    x170 = x54 * (x142 * x88 + x169)
    x171 = x103 * x21 + x170
    x172 = x57 * x88
    x173 = x54 * (x144 * x88 + x172)
    x174 = x101 * x166 + x173
    x175 = x79 * x88
    x176 = x54 * (x153 * x88 + x175)
    x177 = x105 * x122
    x178 = x107 * x21 + x177
    x179 = x105 * x117
    x180 = x105 * x166 + x179
    x181 = x105 * x137
    x182 = -x11 - A[2]
    x183 = x12 * x35 - 2.0 * x18 * x182 * x2 * x20 * x23 * x27 * x28
    x184 = -x183
    x185 = x16 * x184
    x186 = x12 * x26 - 2.0 * x182 * x2 * x20 * x23 * x27 * x28 * x29
    x187 = x6 * (-x185 - x186)
    x188 = -x186
    x189 = x185 * x4 - x188 * x5
    x190 = -x189
    x191 = -x12 * x44 + 2.0 * x182 * x2 * x20 * x23 * x27 * x28 * x34
    x192 = x16 * x191
    x193 = x184 * x5 - x192 * x4
    x194 = x16 * x193
    x195 = x187 + x190 * x5 - x194 * x4
    x196 = x195 * x4
    x197 = x190 * x6
    x198 = 2.0 * x197
    x199 = x196 + x198
    x200 = x188 * x6
    x201 = x190 * x4
    x202 = x200 + x201
    x203 = x54 * (x199 * x55 + x202 * x67)
    x204 = x203 + x22 * x68
    x205 = x54 * (x200 * x55 + x202 * x55)
    x206 = x22 * x54
    x207 = x205 + x206 * x71
    x208 = x6 * (-x183 - x192)
    x209 = -x12 * x75 + 2.0 * x182 * x2 * x20 * x23 * x27 * x28 * x43
    x210 = (
        x195 * x5
        + x41 * (-x189 - x194)
        - x76 * (x193 * x5 + x208 - x76 * (x191 * x5 - x209 * x76))
    )
    x211 = x210 * x4
    x212 = x195 * x6
    x213 = 3.0 * x212
    x214 = x54 * (x199 * x61 + x55 * (x211 + x213))
    x215 = x54 * (x196 * x82 + x198 * x82)
    x216 = x215 + x22 * x84
    x217 = x200 * x82
    x218 = x54 * (x201 * x82 + x217)
    x219 = x206 * x87 + x218
    x220 = x54 * (x211 * x82 + x213 * x82)
    x221 = x12 * x195 + x51
    x222 = x12 * x190 + x57
    x223 = x222 * x67
    x224 = x54 * (x221 * x55 + x223)
    x225 = x22 * x90 + x224
    x226 = x12 * x188 + x65
    x227 = x226 * x81
    x228 = x54 * (x222 * x55 + x227)
    x229 = x206 * x93 + x228
    x230 = x12 * x210 + x79
    x231 = x54 * (x221 * x61 + x230 * x55)
    x232 = x195 * x95
    x233 = x22 * x97 + x232
    x234 = x190 * x95
    x235 = x22 * x33
    x236 = x234 + x235 * x95
    x237 = x210 * x95
    x238 = x100 * x221
    x239 = x103 * x22 + x238
    x240 = x100 * x222
    x241 = x101 * x235 + x240
    x242 = x100 * x230
    x243 = x54 * (x169 + x221 * x88)
    x244 = x107 * x22 + x243
    x245 = x54 * (x172 + x222 * x88)
    x246 = x105 * x235 + x245
    x247 = x54 * (x175 + x230 * x88)
    x248 = x112 * x9
    x249 = x109 * x115 - x248 + x31
    x250 = x249 * x6
    x251 = x109 * x111 - x119 * x9 + x42
    x252 = x16 * x251
    x253 = x249 * x5 - x252 * x4
    x254 = x253 * x4
    x255 = x250 + x254
    x256 = x54 * (x250 * x55 + x255 * x55)
    x257 = x132 * x21 + x256
    x258 = x134 * x21 + x257
    x259 = x6 * (x109 * x115 - x248 - x252 - x73)
    x260 = x16 * x9
    x261 = x109 * x118 - x136 * x260 + x74
    x262 = x253 * x5 + x259 - x76 * (x251 * x5 - x261 * x76)
    x263 = x262 * x4
    x264 = x253 * x6
    x265 = 2.0 * x264
    x266 = x130 * x21 + x54 * (x255 * x67 + x55 * (x263 + x265))
    x267 = x249 * x9
    x268 = 2.0 * x127
    x269 = x267 + x268
    x270 = x253 * x9
    x271 = x125 + x270
    x272 = x54 * (x269 * x81 + x271 * x55)
    x273 = x151 * x21 + x272
    x274 = x152 * x21 + x273
    x275 = x262 * x9
    x276 = 2.0 * x139
    x277 = x275 + x276
    x278 = x147 * x21 + x54 * (x271 * x67 + x277 * x55)
    x279 = x250 * x88
    x280 = x54 * (x254 * x88 + x279)
    x281 = x160 * x21 + x280
    x282 = x161 * x21 + x281
    x283 = x157 * x21 + x54 * (x263 * x88 + x265 * x88)
    x284 = x54 * (x146 + x271 * x82)
    x285 = x165 * x21 + x284
    x286 = x167 * x21 + x285
    x287 = x163 * x21 + x54 * (x143 * x67 + x277 * x82)
    x288 = x54 * (x156 + x270 * x88)
    x289 = x173 * x21 + x288
    x290 = x174 * x21 + x289
    x291 = x170 * x21 + x54 * (x275 * x88 + x276 * x88)
    x292 = x105 * x253
    x293 = x179 * x21 + x292
    x294 = x180 * x21 + x293
    x295 = x105 * x262 + x177 * x21
    x296 = -x109 * x188 + x185 * x9
    x297 = -x296
    x298 = x297 * x6
    x299 = x109 * x184 - x192 * x9
    x300 = x16 * x299
    x301 = x297 * x5 - x300 * x4
    x302 = x298 + x301 * x4
    x303 = x54 * (x298 * x55 + x302 * x55)
    x304 = x132 * x22 + x303
    x305 = x207 * x21 + x304
    x306 = x6 * (-x296 - x300)
    x307 = x109 * x191 - x209 * x260
    x308 = x301 * x5 + x306 - x76 * (x299 * x5 - x307 * x76)
    x309 = x301 * x41
    x310 = x54 * (x302 * x67 + x55 * (x308 * x4 + x309))
    x311 = x130 * x22 + x310
    x312 = x200 + x297 * x9
    x313 = x197 + x301 * x9
    x314 = x54 * (x312 * x81 + x313 * x55)
    x315 = x151 * x22 + x314
    x316 = x21 * x219 + x315
    x317 = x212 + x308 * x9
    x318 = x313 * x67
    x319 = x54 * (x317 * x55 + x318)
    x320 = x147 * x22 + x319
    x321 = x12 * x297 + x127
    x322 = x12 * x301 + x124
    x323 = x54 * (x321 * x81 + x322 * x55)
    x324 = x160 * x22 + x323
    x325 = x21 * x229 + x324
    x326 = x12 * x308 + x139
    x327 = x322 * x67
    x328 = x54 * (x326 * x55 + x327)
    x329 = x157 * x22 + x328
    x330 = x54 * (x197 * x82 + x313 * x82)
    x331 = x165 * x22 + x330
    x332 = x21 * x236 + x331
    x333 = x54 * (x212 * x82 + x317 * x82)
    x334 = x163 * x22 + x333
    x335 = x54 * (x222 * x81 + x322 * x82)
    x336 = x173 * x22 + x335
    x337 = x21 * x241 + x336
    x338 = x54 * (x221 * x81 + x326 * x82)
    x339 = x170 * x22 + x338
    x340 = x54 * (x124 * x88 + x322 * x88)
    x341 = x179 * x22 + x340
    x342 = x21 * x246 + x341
    x343 = x54 * (x139 * x88 + x326 * x88)
    x344 = x177 * x22 + x343
    x345 = x12 * x185
    x346 = x182 * x188 + x31 - x345
    x347 = x346 * x6
    x348 = -x12 * x192 + x182 * x184 + x42
    x349 = x16 * x348
    x350 = x346 * x5 - x349 * x4
    x351 = x350 * x4
    x352 = x347 + x351
    x353 = x54 * (x347 * x55 + x352 * x55)
    x354 = x205 * x22 + x353
    x355 = x207 * x22 + x354
    x356 = x6 * (x182 * x188 - x345 - x349 - x73)
    x357 = x12 * x16
    x358 = x182 * x191 - x209 * x357 + x74
    x359 = x350 * x5 + x356 - x76 * (x348 * x5 - x358 * x76)
    x360 = x359 * x4
    x361 = x350 * x6
    x362 = 2.0 * x361
    x363 = x203 * x22 + x54 * (x352 * x67 + x55 * (x360 + x362))
    x364 = x347 * x82
    x365 = x54 * (x351 * x82 + x364)
    x366 = x218 * x22 + x365
    x367 = x219 * x22 + x366
    x368 = x215 * x22 + x54 * (x360 * x82 + x362 * x82)
    x369 = x12 * x346 + 2.0 * x200
    x370 = x369 * x81
    x371 = x12 * x350 + x198
    x372 = x54 * (x370 + x371 * x55)
    x373 = x22 * x228 + x372
    x374 = x22 * x229 + x373
    x375 = x12 * x359 + 2.0 * x212
    x376 = x22 * x224 + x54 * (x371 * x67 + x375 * x55)
    x377 = x350 * x95
    x378 = x22 * x234 + x377
    x379 = x22 * x236 + x378
    x380 = x22 * x232 + x359 * x95
    x381 = x100 * x371
    x382 = x22 * x240 + x381
    x383 = x22 * x241 + x382
    x384 = x100 * x375 + x22 * x238
    x385 = x54 * (x223 + x371 * x88)
    x386 = x22 * x245 + x385
    x387 = x22 * x246 + x386
    x388 = x22 * x243 + x54 * (x221 * x67 + x375 * x88)
    x389 = x109 * x249 + 2.0 * x114 - x252 * x9
    x390 = x389 * x6
    x391 = x109 * x251 + 2.0 * x135 - x260 * x261
    x392 = x389 * x5 - x391 * x76
    x393 = x392 * x4
    x394 = x21 * x256 + x21 * x257 + x54 * (x390 * x55 + x55 * (x390 + x393))
    x395 = x389 * x9
    x396 = 3.0 * x250
    x397 = x395 + x396
    x398 = x397 * x81
    x399 = x392 * x9
    x400 = 3.0 * x264
    x401 = x399 + x400
    x402 = x21 * x272 + x21 * x273 + x54 * (x398 + x401 * x55)
    x403 = x390 * x88
    x404 = x21 * x280 + x21 * x281 + x54 * (x393 * x88 + x403)
    x405 = x21 * x284 + x21 * x285 + x54 * (x271 * x61 + x401 * x82)
    x406 = x21 * x288 + x21 * x289 + x54 * (x399 * x88 + x400 * x88)
    x407 = x105 * x392 + x21 * x292 + x21 * x293
    x408 = x109 * x297 + x187 - x300 * x9
    x409 = x408 * x6
    x410 = x109 * x299 + x208 - x260 * x307
    x411 = x408 * x5 - x410 * x76
    x412 = x54 * (x409 * x55 + x55 * (x4 * x411 + x409))
    x413 = x21 * x304 + x22 * x256 + x412
    x414 = 2.0 * x298
    x415 = x408 * x9 + x414
    x416 = x309 + x411 * x9
    x417 = x54 * (x415 * x81 + x416 * x55)
    x418 = x21 * x315 + x22 * x272 + x417
    x419 = x12 * x408 + x250
    x420 = x12 * x411 + x264
    x421 = x54 * (x419 * x81 + x420 * x55)
    x422 = x21 * x324 + x22 * x280 + x421
    x423 = x54 * (x318 + x416 * x82)
    x424 = x21 * x331 + x22 * x284 + x423
    x425 = x54 * (x327 + x420 * x82)
    x426 = x21 * x336 + x22 * x288 + x425
    x427 = x54 * (x264 * x88 + x420 * x88)
    x428 = x21 * x341 + x22 * x292 + x427
    x429 = x109 * x346 - x349 * x9
    x430 = x429 * x6
    x431 = x109 * x348 - x260 * x358
    x432 = x429 * x5 - x431 * x76
    x433 = x22 * x303 + x54 * (x430 * x55 + x55 * (x4 * x432 + x430))
    x434 = x22 * x304 + x433
    x435 = x347 + x429 * x9
    x436 = x361 + x432 * x9
    x437 = x22 * x314 + x54 * (x435 * x81 + x436 * x55)
    x438 = x22 * x315 + x437
    x439 = x12 * x429 + x414
    x440 = x12 * x432 + x309
    x441 = x22 * x323 + x54 * (x439 * x81 + x440 * x55)
    x442 = x22 * x324 + x441
    x443 = x22 * x330 + x54 * (x361 * x82 + x436 * x82)
    x444 = x22 * x331 + x443
    x445 = x22 * x335 + x54 * (x371 * x81 + x440 * x82)
    x446 = x22 * x336 + x445
    x447 = x22 * x340 + x54 * (x327 + x440 * x88)
    x448 = x22 * x341 + x447
    x449 = -x12 * x349 + x182 * x346 + 2.0 * x187
    x450 = x449 * x6
    x451 = x182 * x348 + 2.0 * x208 - x357 * x358
    x452 = x449 * x5 - x451 * x76
    x453 = x4 * x452
    x454 = x22 * x353 + x22 * x354 + x54 * (x450 * x55 + x55 * (x450 + x453))
    x455 = x450 * x82
    x456 = x22 * x365 + x22 * x366 + x54 * (x453 * x82 + x455)
    x457 = x12 * x449 + 3.0 * x347
    x458 = x457 * x81
    x459 = x12 * x452 + 3.0 * x361
    x460 = x22 * x372 + x22 * x373 + x54 * (x458 + x459 * x55)
    x461 = x22 * x377 + x22 * x378 + x452 * x95
    x462 = x100 * x459 + x22 * x381 + x22 * x382
    x463 = x22 * x385 + x22 * x386 + x54 * (x371 * x61 + x459 * x88)
    x464 = x0 * x132 + x130
    x465 = x7 * x94
    x466 = x0 * x115
    x467 = x0 * x151 + x147
    x468 = x4 * x94
    x469 = x150 * x468
    x470 = x0 * x160 + x157
    x471 = x12 * x468
    x472 = x0 * x165 + x163
    x473 = x150 * x82 + x86
    x474 = x0 * x173 + x170
    x475 = x149 * x88 + x92
    x476 = x0 * x179 + x177
    x477 = x249 * x465
    x478 = x115 * x21
    x479 = x465 * x478 + x477
    x480 = x269 * x468
    x481 = x21 * x469 + x480
    x482 = x249 * x471
    x483 = x471 * x478 + x482
    x484 = x54 * (x150 * x67 + x269 * x82)
    x485 = x133 * x473 + x484
    x486 = x54 * (x267 * x88 + x268 * x88)
    x487 = x133 * x475 + x486
    x488 = x105 * x249
    x489 = x105 * x478 + x488
    x490 = x297 * x465
    x491 = x115 * x22
    x492 = x465 * x491 + x490
    x493 = x312 * x468
    x494 = x22 * x469 + x493
    x495 = x321 * x468
    x496 = x471 * x491 + x495
    x497 = x54 * (x217 + x312 * x82)
    x498 = x206 * x473 + x497
    x499 = x54 * (x227 + x321 * x82)
    x500 = x206 * x475 + x499
    x501 = x54 * (x159 + x321 * x88)
    x502 = x105 * x491 + x501
    x503 = x389 * x465
    x504 = x21 * x477 + x503
    x505 = x21 * x479 + x504
    x506 = x397 * x468
    x507 = x21 * x480 + x506
    x508 = x21 * x481 + x507
    x509 = x389 * x471
    x510 = x21 * x482 + x509
    x511 = x21 * x483 + x510
    x512 = x54 * (x269 * x61 + x397 * x82)
    x513 = x21 * x484 + x512
    x514 = x21 * x485 + x513
    x515 = x54 * (x395 * x88 + x396 * x88)
    x516 = x21 * x486 + x515
    x517 = x21 * x487 + x516
    x518 = x105 * x389
    x519 = x21 * x488 + x518
    x520 = x21 * x489 + x519
    x521 = x408 * x465
    x522 = x22 * x477 + x521
    x523 = x21 * x492 + x522
    x524 = x415 * x468
    x525 = x22 * x480 + x524
    x526 = x21 * x494 + x525
    x527 = x419 * x468
    x528 = x22 * x482 + x527
    x529 = x21 * x496 + x528
    x530 = x54 * (x312 * x67 + x415 * x82)
    x531 = x22 * x484 + x530
    x532 = x21 * x498 + x531
    x533 = x321 * x67
    x534 = x54 * (x419 * x82 + x533)
    x535 = x22 * x486 + x534
    x536 = x21 * x500 + x535
    x537 = x54 * (x279 + x419 * x88)
    x538 = x22 * x488 + x537
    x539 = x21 * x502 + x538
    x540 = x429 * x465
    x541 = x22 * x490 + x540
    x542 = x22 * x492 + x541
    x543 = x435 * x468
    x544 = x22 * x493 + x543
    x545 = x22 * x494 + x544
    x546 = x439 * x468
    x547 = x22 * x495 + x546
    x548 = x22 * x496 + x547
    x549 = x54 * (x364 + x435 * x82)
    x550 = x22 * x497 + x549
    x551 = x22 * x498 + x550
    x552 = x54 * (x370 + x439 * x82)
    x553 = x22 * x499 + x552
    x554 = x22 * x500 + x553
    x555 = x54 * (x439 * x88 + x533)
    x556 = x22 * x501 + x555
    x557 = x22 * x502 + x556
    x558 = x109 * x389 + 3.0 * x259 - x260 * x391
    x559 = x558 * x9
    x560 = 4.0 * x390
    x561 = x559 + x560
    x562 = x109 * x408 - x260 * x410 + 2.0 * x306
    x563 = x465 * x562
    x564 = 3.0 * x409 + x562 * x9
    x565 = x468 * x564
    x566 = x12 * x562 + x390
    x567 = x468 * x566
    x568 = x54 * (x415 * x61 + x564 * x82)
    x569 = x54 * (x419 * x61 + x566 * x82)
    x570 = x54 * (x403 + x566 * x88)
    x571 = x109 * x429 - x260 * x431 + x356
    x572 = x22 * x521 + x465 * x571
    x573 = 2.0 * x430 + x571 * x9
    x574 = x22 * x524 + x468 * x573
    x575 = x12 * x571 + 2.0 * x409
    x576 = x22 * x527 + x468 * x575
    x577 = x22 * x530 + x54 * (x435 * x67 + x573 * x82)
    x578 = x22 * x534 + x54 * (x439 * x67 + x575 * x82)
    x579 = x22 * x537 + x54 * (x419 * x67 + x575 * x88)
    x580 = x109 * x449 - x260 * x451
    x581 = x22 * x540 + x22 * x541 + x465 * x580
    x582 = x450 + x580 * x9
    x583 = x22 * x543 + x22 * x544 + x468 * x582
    x584 = x12 * x580 + 3.0 * x430
    x585 = x22 * x546 + x22 * x547 + x468 * x584
    x586 = x22 * x549 + x22 * x550 + x54 * (x455 + x582 * x82)
    x587 = x22 * x552 + x22 * x553 + x54 * (x458 + x584 * x82)
    x588 = x22 * x555 + x22 * x556 + x54 * (x439 * x61 + x584 * x88)
    x589 = x0 * x205 + x203
    x590 = x0 * x188
    x591 = x0 * x218 + x215
    x592 = x100 * x4
    x593 = x0 * x228 + x224
    x594 = x0 * x226
    x595 = x0 * x234 + x232
    x596 = x0 * x240 + x238
    x597 = x0 * x245 + x243
    x598 = x226 * x88 + x92
    x599 = x205 * x21 + x303
    x600 = x188 * x21
    x601 = x465 * x600 + x490
    x602 = x21 * x218 + x314
    x603 = x493 + x592 * x600
    x604 = x21 * x228 + x323
    x605 = x21 * x226
    x606 = x468 * x605 + x495
    x607 = x21 * x234 + x330
    x608 = x497 + x600 * x95
    x609 = x21 * x240 + x335
    x610 = x100 * x605 + x499
    x611 = x21 * x245 + x340
    x612 = x133 * x598 + x501
    x613 = x346 * x465
    x614 = x188 * x22
    x615 = x465 * x614 + x613
    x616 = x346 * x592
    x617 = x592 * x614 + x616
    x618 = x369 * x468
    x619 = x22 * x226
    x620 = x468 * x619 + x618
    x621 = x346 * x95
    x622 = x614 * x95 + x621
    x623 = x100 * x369
    x624 = x100 * x619 + x623
    x625 = x54 * (x226 * x67 + x369 * x88)
    x626 = x206 * x598 + x625
    x627 = x21 * x490 + x521
    x628 = x21 * x601 + x627
    x629 = x21 * x493 + x524
    x630 = x21 * x603 + x629
    x631 = x21 * x495 + x527
    x632 = x21 * x606 + x631
    x633 = x21 * x497 + x530
    x634 = x21 * x608 + x633
    x635 = x21 * x499 + x534
    x636 = x21 * x610 + x635
    x637 = x21 * x501 + x537
    x638 = x21 * x612 + x637
    x639 = x21 * x615 + x541
    x640 = x21 * x617 + x544
    x641 = x21 * x620 + x547
    x642 = x21 * x622 + x550
    x643 = x21 * x624 + x553
    x644 = x21 * x626 + x556
    x645 = x449 * x465
    x646 = x22 * x613 + x645
    x647 = x22 * x615 + x646
    x648 = x449 * x592
    x649 = x22 * x616 + x648
    x650 = x22 * x617 + x649
    x651 = x457 * x468
    x652 = x22 * x618 + x651
    x653 = x22 * x620 + x652
    x654 = x449 * x95
    x655 = x22 * x621 + x654
    x656 = x22 * x622 + x655
    x657 = x100 * x457
    x658 = x22 * x623 + x657
    x659 = x22 * x624 + x658
    x660 = x54 * (x369 * x61 + x457 * x88)
    x661 = x22 * x625 + x660
    x662 = x22 * x626 + x661
    x663 = x182 * x449 + 3.0 * x356 - x357 * x451
    x664 = x12 * x663 + 4.0 * x450

    # 180 item(s)
    return numpy.array(
        [
            x0 * x62
            + x0 * x69
            + x0 * (x0 * (x68 + x71 * x72) + x69)
            + x54 * (4.0 * x53 * x81 + x55 * (x78 + x80)),
            x0 * x83
            + x0 * x85
            + x0 * (x0 * (x72 * x87 + x84) + x85)
            + x54 * (x78 * x82 + x80 * x82),
            x0 * x89
            + x0 * x91
            + x0 * (x0 * (x72 * x93 + x90) + x91)
            + x54 * (x78 * x88 + x80 * x88),
            x0 * x96 + x0 * x98 + x0 * (x0 * (x95 * x99 + x97) + x98) + x77 * x95,
            x0 * x102 + x0 * x104 + x0 * (x0 * (x101 * x99 + x103) + x104) + x101 * x77,
            x0 * x106 + x0 * x108 + x0 * (x0 * (x105 * x99 + x107) + x108) + x105 * x77,
            x0 * x131 + x0 * (x0 * x134 + x131) + x141 + x21 * x62,
            x0 * x148 + x0 * (x0 * x152 + x148) + x155 + x21 * x83,
            x0 * x158 + x0 * (x0 * x161 + x158) + x162 + x21 * x89,
            x0 * x164 + x0 * (x0 * x167 + x164) + x168 + x21 * x96,
            x0 * x171 + x0 * (x0 * x174 + x171) + x102 * x21 + x176,
            x0 * x178 + x0 * (x0 * x180 + x178) + x106 * x21 + x181,
            x0 * x204 + x0 * (x0 * x207 + x204) + x214 + x22 * x62,
            x0 * x216 + x0 * (x0 * x219 + x216) + x22 * x83 + x220,
            x0 * x225 + x0 * (x0 * x229 + x225) + x22 * x89 + x231,
            x0 * x233 + x0 * (x0 * x236 + x233) + x22 * x96 + x237,
            x0 * x239 + x0 * (x0 * x241 + x239) + x102 * x22 + x242,
            x0 * x244 + x0 * (x0 * x246 + x244) + x106 * x22 + x247,
            x0 * x258 + x131 * x21 + x266,
            x0 * x274 + x148 * x21 + x278,
            x0 * x282 + x158 * x21 + x283,
            x0 * x286 + x164 * x21 + x287,
            x0 * x290 + x171 * x21 + x291,
            x0 * x294 + x178 * x21 + x295,
            x0 * x305 + x204 * x21 + x311,
            x0 * x316 + x21 * x216 + x320,
            x0 * x325 + x21 * x225 + x329,
            x0 * x332 + x21 * x233 + x334,
            x0 * x337 + x21 * x239 + x339,
            x0 * x342 + x21 * x244 + x344,
            x0 * x355 + x204 * x22 + x363,
            x0 * x367 + x216 * x22 + x368,
            x0 * x374 + x22 * x225 + x376,
            x0 * x379 + x22 * x233 + x380,
            x0 * x383 + x22 * x239 + x384,
            x0 * x387 + x22 * x244 + x388,
            x21 * x258 + x394,
            x21 * x274 + x402,
            x21 * x282 + x404,
            x21 * x286 + x405,
            x21 * x290 + x406,
            x21 * x294 + x407,
            x21 * x305 + x413,
            x21 * x316 + x418,
            x21 * x325 + x422,
            x21 * x332 + x424,
            x21 * x337 + x426,
            x21 * x342 + x428,
            x21 * x355 + x434,
            x21 * x367 + x438,
            x21 * x374 + x442,
            x21 * x379 + x444,
            x21 * x383 + x446,
            x21 * x387 + x448,
            x22 * x355 + x454,
            x22 * x367 + x456,
            x22 * x374 + x460,
            x22 * x379 + x461,
            x22 * x383 + x462,
            x22 * x387 + x463,
            x0 * x130 + x0 * x464 + x0 * (x0 * (x132 + x465 * x466) + x464) + x141,
            x0 * x147 + x0 * x467 + x0 * (x0 * (x0 * x469 + x151) + x467) + x155,
            x0 * x157 + x0 * x470 + x0 * (x0 * (x160 + x466 * x471) + x470) + x162,
            x0 * x163 + x0 * x472 + x0 * (x0 * (x165 + x473 * x72) + x472) + x168,
            x0 * x170 + x0 * x474 + x0 * (x0 * (x173 + x475 * x72) + x474) + x176,
            x0 * x177 + x0 * x476 + x0 * (x0 * (x105 * x466 + x179) + x476) + x181,
            x0 * x257 + x0 * (x0 * x479 + x257) + x266,
            x0 * x273 + x0 * (x0 * x481 + x273) + x278,
            x0 * x281 + x0 * (x0 * x483 + x281) + x283,
            x0 * x285 + x0 * (x0 * x485 + x285) + x287,
            x0 * x289 + x0 * (x0 * x487 + x289) + x291,
            x0 * x293 + x0 * (x0 * x489 + x293) + x295,
            x0 * x304 + x0 * (x0 * x492 + x304) + x311,
            x0 * x315 + x0 * (x0 * x494 + x315) + x320,
            x0 * x324 + x0 * (x0 * x496 + x324) + x329,
            x0 * x331 + x0 * (x0 * x498 + x331) + x334,
            x0 * x336 + x0 * (x0 * x500 + x336) + x339,
            x0 * x341 + x0 * (x0 * x502 + x341) + x344,
            x0 * x505 + x394,
            x0 * x508 + x402,
            x0 * x511 + x404,
            x0 * x514 + x405,
            x0 * x517 + x406,
            x0 * x520 + x407,
            x0 * x523 + x413,
            x0 * x526 + x418,
            x0 * x529 + x422,
            x0 * x532 + x424,
            x0 * x536 + x426,
            x0 * x539 + x428,
            x0 * x542 + x434,
            x0 * x545 + x438,
            x0 * x548 + x442,
            x0 * x551 + x444,
            x0 * x554 + x446,
            x0 * x557 + x448,
            x21 * x503 + x21 * x504 + x21 * x505 + x465 * x558,
            x21 * x506 + x21 * x507 + x21 * x508 + x468 * x561,
            x21 * x509 + x21 * x510 + x21 * x511 + x471 * x558,
            x21 * x512 + x21 * x513 + x21 * x514 + x54 * (4.0 * x398 + x561 * x82),
            x21 * x515 + x21 * x516 + x21 * x517 + x54 * (x559 * x88 + x560 * x88),
            x105 * x558 + x21 * x518 + x21 * x519 + x21 * x520,
            x21 * x522 + x21 * x523 + x22 * x503 + x563,
            x21 * x525 + x21 * x526 + x22 * x506 + x565,
            x21 * x528 + x21 * x529 + x22 * x509 + x567,
            x21 * x531 + x21 * x532 + x22 * x512 + x568,
            x21 * x535 + x21 * x536 + x22 * x515 + x569,
            x21 * x538 + x21 * x539 + x22 * x518 + x570,
            x21 * x542 + x22 * x522 + x572,
            x21 * x545 + x22 * x525 + x574,
            x21 * x548 + x22 * x528 + x576,
            x21 * x551 + x22 * x531 + x577,
            x21 * x554 + x22 * x535 + x578,
            x21 * x557 + x22 * x538 + x579,
            x22 * x542 + x581,
            x22 * x545 + x583,
            x22 * x548 + x585,
            x22 * x551 + x586,
            x22 * x554 + x587,
            x22 * x557 + x588,
            x0 * x203 + x0 * x589 + x0 * (x0 * (x205 + x465 * x590) + x589) + x214,
            x0 * x215 + x0 * x591 + x0 * (x0 * (x218 + x590 * x592) + x591) + x220,
            x0 * x224 + x0 * x593 + x0 * (x0 * (x228 + x468 * x594) + x593) + x231,
            x0 * x232 + x0 * x595 + x0 * (x0 * (x234 + x590 * x95) + x595) + x237,
            x0 * x238 + x0 * x596 + x0 * (x0 * (x100 * x594 + x240) + x596) + x242,
            x0 * x243 + x0 * x597 + x0 * (x0 * (x245 + x598 * x72) + x597) + x247,
            x0 * x599 + x0 * (x0 * x601 + x599) + x203 * x21 + x310,
            x0 * x602 + x0 * (x0 * x603 + x602) + x21 * x215 + x319,
            x0 * x604 + x0 * (x0 * x606 + x604) + x21 * x224 + x328,
            x0 * x607 + x0 * (x0 * x608 + x607) + x21 * x232 + x333,
            x0 * x609 + x0 * (x0 * x610 + x609) + x21 * x238 + x338,
            x0 * x611 + x0 * (x0 * x612 + x611) + x21 * x243 + x343,
            x0 * x354 + x0 * (x0 * x615 + x354) + x363,
            x0 * x366 + x0 * (x0 * x617 + x366) + x368,
            x0 * x373 + x0 * (x0 * x620 + x373) + x376,
            x0 * x378 + x0 * (x0 * x622 + x378) + x380,
            x0 * x382 + x0 * (x0 * x624 + x382) + x384,
            x0 * x386 + x0 * (x0 * x626 + x386) + x388,
            x0 * x628 + x21 * x303 + x21 * x599 + x412,
            x0 * x630 + x21 * x314 + x21 * x602 + x417,
            x0 * x632 + x21 * x323 + x21 * x604 + x421,
            x0 * x634 + x21 * x330 + x21 * x607 + x423,
            x0 * x636 + x21 * x335 + x21 * x609 + x425,
            x0 * x638 + x21 * x340 + x21 * x611 + x427,
            x0 * x639 + x21 * x354 + x433,
            x0 * x640 + x21 * x366 + x437,
            x0 * x641 + x21 * x373 + x441,
            x0 * x642 + x21 * x378 + x443,
            x0 * x643 + x21 * x382 + x445,
            x0 * x644 + x21 * x386 + x447,
            x0 * x647 + x454,
            x0 * x650 + x456,
            x0 * x653 + x460,
            x0 * x656 + x461,
            x0 * x659 + x462,
            x0 * x662 + x463,
            x21 * x521 + x21 * x627 + x21 * x628 + x563,
            x21 * x524 + x21 * x629 + x21 * x630 + x565,
            x21 * x527 + x21 * x631 + x21 * x632 + x567,
            x21 * x530 + x21 * x633 + x21 * x634 + x568,
            x21 * x534 + x21 * x635 + x21 * x636 + x569,
            x21 * x537 + x21 * x637 + x21 * x638 + x570,
            x21 * x541 + x21 * x639 + x572,
            x21 * x544 + x21 * x640 + x574,
            x21 * x547 + x21 * x641 + x576,
            x21 * x550 + x21 * x642 + x577,
            x21 * x553 + x21 * x643 + x578,
            x21 * x556 + x21 * x644 + x579,
            x21 * x647 + x581,
            x21 * x650 + x583,
            x21 * x653 + x585,
            x21 * x656 + x586,
            x21 * x659 + x587,
            x21 * x662 + x588,
            x22 * x645 + x22 * x646 + x22 * x647 + x465 * x663,
            x22 * x648 + x22 * x649 + x22 * x650 + x592 * x663,
            x22 * x651 + x22 * x652 + x22 * x653 + x468 * x664,
            x22 * x654 + x22 * x655 + x22 * x656 + x663 * x95,
            x100 * x664 + x22 * x657 + x22 * x658 + x22 * x659,
            x22 * x660 + x22 * x661 + x22 * x662 + x54 * (4.0 * x458 + x664 * x88),
        ]
    )


def _3center2el3d_sph_133(a, A, b, B, c, C):
    """Cartesian (pf|f) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = x4**2
    x8 = -x2 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x2 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x1
    x15 = x14 ** (-1.0)
    x16 = c * x15
    x17 = x1 * x16 * (x10 + x13 + x7)
    x18 = boys(4, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x0**2 + x21**2 + x22**2))
    x24 = x20 * x23
    x25 = x2 * x24
    x26 = 2.0 * x19 * x25
    x27 = x18 * x26
    x28 = c ** (-1.0)
    x29 = x14 ** (-0.5)
    x30 = boys(3, x17)
    x31 = 2.0 * x2 * x20 * x23 * x28 * x29 * x30 - x27
    x32 = x31 * x6
    x33 = -2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x5 + x27 * x4
    x34 = -x33
    x35 = boys(5, x17)
    x36 = x26 * x35
    x37 = -2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x5 + x36 * x4
    x38 = -x37
    x39 = x16 * x38
    x40 = x39 * x4
    x41 = x32 + x34 * x5 - x40
    x42 = 2.0 * x6
    x43 = x6 * (2.0 * x18 * x2 * x20 * x23 * x28 * x29 - x36)
    x44 = boys(6, x17)
    x45 = x26 * x44
    x46 = 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x5 - x4 * x45
    x47 = x16 * x46
    x48 = x38 * x5 - x4 * x47 + x43
    x49 = x16 * x48
    x50 = -x4 * x49 + x41 * x5 + x42 * (-x33 - x39)
    x51 = x4 * x50
    x52 = x41 * x6
    x53 = 3.0 * x52
    x54 = x51 + x53
    x55 = x1 * x15
    x56 = x4 * x55
    x57 = x4 * x41
    x58 = x34 * x6
    x59 = 2.0 * x58
    x60 = x57 + x59
    x61 = 3.0 * x6
    x62 = x55 * x61
    x63 = x54 * x56 + x60 * x62
    x64 = x34 * x4
    x65 = x28 * x30 * x42
    x66 = x25 * x29 * x65
    x67 = x64 + x66
    x68 = x42 * x55
    x69 = x56 * x60 + x67 * x68
    x70 = x55 * (x56 * x63 + x62 * x69)
    x71 = x24 * x65
    x72 = x19 * x71
    x73 = x4 * x72 + x56 * x67
    x74 = x55 * (x56 * x69 + x68 * x73)
    x75 = x0 * x74 + x70
    x76 = x1 * x14 ** (-2.5) * x71
    x77 = x56 * x73 + x7 * x76
    x78 = x0 * x55
    x79 = -x31 * x6
    x80 = x6 * (2.0 * x2 * x20 * x23 * x28 * x29 * x35 - x45)
    x81 = x26 * boys(7, x17)
    x82 = x16 * x4
    x83 = (
        x5 * x50
        + x61 * (x34 * x5 - x40 - x49 - x79)
        - x82
        * (
            x42 * (-x37 - x47)
            + x48 * x5
            - x82
            * (
                x46 * x5
                + x80
                - x82 * (2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x5 - x4 * x81)
            )
        )
    )
    x84 = x4 * x83
    x85 = x50 * x6
    x86 = 4.0 * x85
    x87 = x55 * x6
    x88 = 4.0 * x87
    x89 = x55 * x9
    x90 = x51 * x89 + x53 * x89
    x91 = x57 * x89 + x59 * x89
    x92 = x55 * (x56 * x90 + x62 * x91)
    x93 = x72 * x9
    x94 = x64 * x89 + x93
    x95 = x55 * (x56 * x91 + x68 * x94)
    x96 = x0 * x95 + x92
    x97 = x4 * x9
    x98 = x56 * x94 + x76 * x97
    x99 = x12 * x55
    x100 = x51 * x99 + x53 * x99
    x101 = x57 * x99 + x59 * x99
    x102 = x55 * (x100 * x56 + x101 * x62)
    x103 = x12 * x72
    x104 = x103 + x64 * x99
    x105 = x55 * (x101 * x56 + x104 * x68)
    x106 = x0 * x105 + x102
    x107 = x12 * x76
    x108 = x104 * x56 + x107 * x4
    x109 = x1**2 / x14**2
    x110 = x10 * x109
    x111 = x55 * (x110 * x51 + x110 * x53)
    x112 = x55 * (x110 * x57 + x110 * x59)
    x113 = x0 * x112 + x111
    x114 = x10 * x76
    x115 = x110 * x64 + x114
    x116 = x109 * x9
    x117 = x116 * x12
    x118 = x55 * (x117 * x51 + x117 * x53)
    x119 = x55 * (x117 * x57 + x117 * x59)
    x120 = x0 * x119 + x118
    x121 = x107 * x9
    x122 = x117 * x64 + x121
    x123 = x109 * x13
    x124 = x55 * (x123 * x51 + x123 * x53)
    x125 = x55 * (x123 * x57 + x123 * x59)
    x126 = x0 * x125 + x124
    x127 = x13 * x76
    x128 = x123 * x64 + x127
    x129 = x1**3 / x14**3
    x130 = x129 * x9**3
    x131 = x130 * x50
    x132 = x130 * x41
    x133 = x0 * x132 + x131
    x134 = x0 * x34
    x135 = x10 * x129
    x136 = x12 * x135
    x137 = x136 * x50
    x138 = x136 * x41
    x139 = x0 * x138 + x137
    x140 = x129 * x13
    x141 = x140 * x9
    x142 = x141 * x50
    x143 = x141 * x41
    x144 = x0 * x143 + x142
    x145 = x12**3 * x129
    x146 = x145 * x50
    x147 = x145 * x41
    x148 = x0 * x147 + x146
    x149 = -x8 - A[1]
    x150 = -2.0 * x149 * x18 * x2 * x20 * x23 * x28 * x29 + x36 * x9
    x151 = -x150
    x152 = x151 * x16
    x153 = -2.0 * x149 * x2 * x20 * x23 * x28 * x29 * x30 + x27 * x9
    x154 = x6 * (-x152 - x153)
    x155 = -x153
    x156 = x152 * x4 - x155 * x5
    x157 = -x156
    x158 = 2.0 * x149 * x2 * x20 * x23 * x28 * x29 * x35 - x45 * x9
    x159 = x158 * x16
    x160 = x151 * x5 - x159 * x4
    x161 = x16 * x160
    x162 = x154 + x157 * x5 - x161 * x4
    x163 = x162 * x4
    x164 = x157 * x6
    x165 = 2.0 * x164
    x166 = x163 + x165
    x167 = x155 * x6
    x168 = x157 * x4
    x169 = x167 + x168
    x170 = x166 * x56 + x169 * x68
    x171 = x167 * x56 + x169 * x56
    x172 = x55 * (x170 * x56 + x171 * x68)
    x173 = x172 + x21 * x74
    x174 = x109 * x7
    x175 = x55 * (x167 * x174 + x171 * x56)
    x176 = x21 * x55
    x177 = x175 + x176 * x77
    x178 = x6 * (-x150 - x159)
    x179 = 2.0 * x149 * x2 * x20 * x23 * x28 * x29 * x44 - x81 * x9
    x180 = (
        x162 * x5
        + x42 * (-x156 - x161)
        - x82 * (x160 * x5 + x178 - x82 * (x158 * x5 - x179 * x82))
    )
    x181 = x180 * x4
    x182 = x162 * x6
    x183 = 3.0 * x182
    x184 = x55 * (x170 * x62 + x56 * (x166 * x62 + x56 * (x181 + x183)))
    x185 = x162 * x9
    x186 = x185 + x52
    x187 = x157 * x9
    x188 = x187 + x58
    x189 = x188 * x68
    x190 = x186 * x56 + x189
    x191 = x155 * x9
    x192 = x191 + x66
    x193 = x192 * x55
    x194 = x188 * x56 + x193 * x6
    x195 = x55 * (x190 * x56 + x194 * x68)
    x196 = x195 + x21 * x95
    x197 = x109 * x4
    x198 = x197 * x6
    x199 = x55 * (x192 * x198 + x194 * x56)
    x200 = x176 * x98 + x199
    x201 = x180 * x9
    x202 = x201 + x85
    x203 = x55 * (x190 * x62 + x56 * (x186 * x62 + x202 * x56))
    x204 = x165 * x99
    x205 = x163 * x99 + x204
    x206 = x167 * x99
    x207 = x168 * x99 + x206
    x208 = x55 * (x205 * x56 + x207 * x68)
    x209 = x105 * x21 + x208
    x210 = x12 * x197
    x211 = x55 * (x167 * x210 + x207 * x56)
    x212 = x108 * x176 + x211
    x213 = x55 * (x205 * x62 + x56 * (x181 * x99 + x183 * x99))
    x214 = x186 * x89 + x52 * x89
    x215 = x188 * x89 + x58 * x89
    x216 = x215 * x68
    x217 = x55 * (x214 * x56 + x216)
    x218 = x112 * x21 + x217
    x219 = x193 * x9 + x93
    x220 = x55 * (x215 * x56 + x219 * x87)
    x221 = x115 * x176 + x220
    x222 = x202 * x89 + x85 * x89
    x223 = x55 * (x214 * x62 + x222 * x56)
    x224 = x52 * x99
    x225 = x185 * x99 + x224
    x226 = x58 * x99
    x227 = x187 * x99 + x226
    x228 = x227 * x68
    x229 = x55 * (x225 * x56 + x228)
    x230 = x119 * x21 + x229
    x231 = x103 + x191 * x99
    x232 = x55 * (x227 * x56 + x231 * x87)
    x233 = x122 * x176 + x232
    x234 = x85 * x99
    x235 = x201 * x99 + x234
    x236 = x55 * (x225 * x62 + x235 * x56)
    x237 = x123 * x165
    x238 = x55 * (x123 * x163 + x237)
    x239 = x125 * x21 + x238
    x240 = x123 * x167
    x241 = x55 * (x123 * x168 + x240)
    x242 = x128 * x176 + x241
    x243 = x55 * (x123 * x181 + x123 * x183)
    x244 = x55 * (x110 * x52 + x214 * x89)
    x245 = x132 * x21 + x244
    x246 = x55 * (x110 * x58 + x215 * x89)
    x247 = x21 * x34
    x248 = x130 * x247 + x246
    x249 = x55 * (x110 * x85 + x222 * x89)
    x250 = x55 * (x117 * x52 + x225 * x89)
    x251 = x138 * x21 + x250
    x252 = x55 * (x117 * x58 + x227 * x89)
    x253 = x136 * x247 + x252
    x254 = x55 * (x117 * x85 + x235 * x89)
    x255 = x123 * x52
    x256 = x55 * (x123 * x185 + x255)
    x257 = x143 * x21 + x256
    x258 = x123 * x58
    x259 = x55 * (x123 * x187 + x258)
    x260 = x141 * x247 + x259
    x261 = x123 * x85
    x262 = x55 * (x123 * x201 + x261)
    x263 = x145 * x162
    x264 = x147 * x21 + x263
    x265 = x145 * x157
    x266 = x145 * x247 + x265
    x267 = x145 * x180
    x268 = -x11 - A[2]
    x269 = x12 * x36 - 2.0 * x18 * x2 * x20 * x23 * x268 * x28 * x29
    x270 = -x269
    x271 = x16 * x270
    x272 = x12 * x27 - 2.0 * x2 * x20 * x23 * x268 * x28 * x29 * x30
    x273 = x6 * (-x271 - x272)
    x274 = -x272
    x275 = x271 * x4 - x274 * x5
    x276 = -x275
    x277 = -x12 * x45 + 2.0 * x2 * x20 * x23 * x268 * x28 * x29 * x35
    x278 = x16 * x277
    x279 = x270 * x5 - x278 * x4
    x280 = x16 * x279
    x281 = x273 + x276 * x5 - x280 * x4
    x282 = x281 * x4
    x283 = x276 * x6
    x284 = 2.0 * x283
    x285 = x282 + x284
    x286 = x274 * x6
    x287 = x276 * x4
    x288 = x286 + x287
    x289 = x285 * x56 + x288 * x68
    x290 = x286 * x56 + x288 * x56
    x291 = x55 * (x289 * x56 + x290 * x68)
    x292 = x22 * x74 + x291
    x293 = x55 * (x174 * x286 + x290 * x56)
    x294 = x22 * x55
    x295 = x293 + x294 * x77
    x296 = x6 * (-x269 - x278)
    x297 = -x12 * x81 + 2.0 * x2 * x20 * x23 * x268 * x28 * x29 * x44
    x298 = (
        x281 * x5
        + x42 * (-x275 - x280)
        - x82 * (x279 * x5 + x296 - x82 * (x277 * x5 - x297 * x82))
    )
    x299 = x298 * x4
    x300 = x281 * x6
    x301 = 3.0 * x300
    x302 = x55 * (x289 * x62 + x56 * (x285 * x62 + x56 * (x299 + x301)))
    x303 = x282 * x89 + x284 * x89
    x304 = x286 * x89
    x305 = x287 * x89 + x304
    x306 = x55 * (x303 * x56 + x305 * x68)
    x307 = x22 * x95 + x306
    x308 = x116 * x4
    x309 = x55 * (x286 * x308 + x305 * x56)
    x310 = x294 * x98 + x309
    x311 = x55 * (x303 * x62 + x56 * (x299 * x89 + x301 * x89))
    x312 = x12 * x281 + x52
    x313 = x12 * x276 + x58
    x314 = x313 * x68
    x315 = x312 * x56 + x314
    x316 = x12 * x274 + x66
    x317 = x316 * x87
    x318 = x313 * x56 + x317
    x319 = x55 * (x315 * x56 + x318 * x68)
    x320 = x105 * x22 + x319
    x321 = x55 * (x198 * x316 + x318 * x56)
    x322 = x108 * x294 + x321
    x323 = x12 * x298 + x85
    x324 = x55 * (x315 * x62 + x56 * (x312 * x62 + x323 * x56))
    x325 = x55 * (x110 * x282 + x110 * x284)
    x326 = x112 * x22 + x325
    x327 = x110 * x286
    x328 = x55 * (x110 * x287 + x327)
    x329 = x115 * x294 + x328
    x330 = x55 * (x110 * x299 + x110 * x301)
    x331 = x116 * x42
    x332 = x55 * (x308 * x312 + x313 * x331)
    x333 = x119 * x22 + x332
    x334 = x116 * x6
    x335 = x316 * x334
    x336 = x55 * (x308 * x313 + x335)
    x337 = x122 * x294 + x336
    x338 = x55 * (x116 * x312 * x61 + x308 * x323)
    x339 = x224 + x312 * x99
    x340 = x226 + x313 * x99
    x341 = x340 * x68
    x342 = x55 * (x339 * x56 + x341)
    x343 = x125 * x22 + x342
    x344 = x103 + x316 * x99
    x345 = x344 * x87
    x346 = x55 * (x340 * x56 + x345)
    x347 = x128 * x294 + x346
    x348 = x234 + x323 * x99
    x349 = x55 * (x339 * x62 + x348 * x56)
    x350 = x130 * x281
    x351 = x132 * x22 + x350
    x352 = x130 * x276
    x353 = x22 * x34
    x354 = x130 * x353 + x352
    x355 = x130 * x298
    x356 = x135 * x312
    x357 = x138 * x22 + x356
    x358 = x135 * x313
    x359 = x136 * x353 + x358
    x360 = x135 * x323
    x361 = x116 * x339
    x362 = x143 * x22 + x361
    x363 = x116 * x340
    x364 = x141 * x353 + x363
    x365 = x116 * x348
    x366 = x55 * (x255 + x339 * x99)
    x367 = x147 * x22 + x366
    x368 = x55 * (x258 + x340 * x99)
    x369 = x145 * x353 + x368
    x370 = x55 * (x261 + x348 * x99)
    x371 = x152 * x9
    x372 = x149 * x155 + x32 - x371
    x373 = x372 * x6
    x374 = x149 * x151 - x159 * x9 + x43
    x375 = x16 * x374
    x376 = x372 * x5 - x375 * x4
    x377 = x376 * x4
    x378 = x373 + x377
    x379 = x373 * x56 + x378 * x56
    x380 = x55 * (x174 * x373 + x379 * x56)
    x381 = x175 * x21 + x380
    x382 = x177 * x21 + x381
    x383 = x6 * (x149 * x155 - x371 - x375 - x79)
    x384 = x16 * x9
    x385 = x149 * x158 - x179 * x384 + x80
    x386 = x376 * x5 + x383 - x82 * (x374 * x5 - x385 * x82)
    x387 = x386 * x4
    x388 = x376 * x6
    x389 = 2.0 * x388
    x390 = x172 * x21 + x55 * (x379 * x68 + x56 * (x378 * x68 + x56 * (x387 + x389)))
    x391 = x372 * x9
    x392 = 2.0 * x167
    x393 = x391 + x392
    x394 = x376 * x9
    x395 = x165 + x394
    x396 = x393 * x87 + x395 * x56
    x397 = x55 * (x198 * x393 + x396 * x56)
    x398 = x199 * x21 + x397
    x399 = x200 * x21 + x398
    x400 = x386 * x9
    x401 = 2.0 * x182
    x402 = x400 + x401
    x403 = x195 * x21 + x55 * (x396 * x68 + x56 * (x395 * x68 + x402 * x56))
    x404 = x373 * x99
    x405 = x377 * x99 + x404
    x406 = x55 * (x210 * x373 + x405 * x56)
    x407 = x21 * x211 + x406
    x408 = x21 * x212 + x407
    x409 = x208 * x21 + x55 * (x405 * x68 + x56 * (x387 * x99 + x389 * x99))
    x410 = x193 * x42 + x393 * x89
    x411 = x189 + x395 * x89
    x412 = x55 * (x410 * x87 + x411 * x56)
    x413 = x21 * x220 + x412
    x414 = x21 * x221 + x413
    x415 = x186 * x68 + x402 * x89
    x416 = x21 * x217 + x55 * (x411 * x68 + x415 * x56)
    x417 = x391 * x99 + x392 * x99
    x418 = x204 + x394 * x99
    x419 = x55 * (x417 * x87 + x418 * x56)
    x420 = x21 * x232 + x419
    x421 = x21 * x233 + x420
    x422 = x400 * x99 + x401 * x99
    x423 = x21 * x229 + x55 * (x418 * x68 + x422 * x56)
    x424 = x123 * x373
    x425 = x55 * (x123 * x377 + x424)
    x426 = x21 * x241 + x425
    x427 = x21 * x242 + x426
    x428 = x21 * x238 + x55 * (x123 * x387 + x123 * x389)
    x429 = x55 * (x216 + x411 * x89)
    x430 = x21 * x246 + x429
    x431 = x21 * x248 + x430
    x432 = x21 * x244 + x55 * (x214 * x68 + x415 * x89)
    x433 = x55 * (x228 + x418 * x89)
    x434 = x21 * x252 + x433
    x435 = x21 * x253 + x434
    x436 = x21 * x250 + x55 * (x225 * x68 + x422 * x89)
    x437 = x55 * (x123 * x394 + x237)
    x438 = x21 * x259 + x437
    x439 = x21 * x260 + x438
    x440 = x21 * x256 + x55 * (x123 * x400 + x123 * x401)
    x441 = x145 * x376
    x442 = x21 * x265 + x441
    x443 = x21 * x266 + x442
    x444 = x145 * x386 + x21 * x263
    x445 = -x149 * x274 + x271 * x9
    x446 = -x445
    x447 = x446 * x6
    x448 = x149 * x270 - x278 * x9
    x449 = x16 * x448
    x450 = -x4 * x449 + x446 * x5
    x451 = x4 * x450 + x447
    x452 = x447 * x56 + x451 * x56
    x453 = x55 * (x174 * x447 + x452 * x56)
    x454 = x175 * x22 + x453
    x455 = x21 * x295 + x454
    x456 = x6 * (-x445 - x449)
    x457 = x149 * x277 - x297 * x384
    x458 = x450 * x5 + x456 - x82 * (x448 * x5 - x457 * x82)
    x459 = x42 * x450
    x460 = x55 * (x452 * x68 + x56 * (x451 * x68 + x56 * (x4 * x458 + x459)))
    x461 = x172 * x22 + x460
    x462 = x286 + x446 * x9
    x463 = x283 + x450 * x9
    x464 = x462 * x87 + x463 * x56
    x465 = x55 * (x198 * x462 + x464 * x56)
    x466 = x199 * x22 + x465
    x467 = x21 * x310 + x466
    x468 = x300 + x458 * x9
    x469 = x463 * x68
    x470 = x55 * (x464 * x68 + x56 * (x468 * x56 + x469))
    x471 = x195 * x22 + x470
    x472 = x12 * x446 + x167
    x473 = x12 * x450 + x164
    x474 = x472 * x87 + x473 * x56
    x475 = x55 * (x198 * x472 + x474 * x56)
    x476 = x211 * x22 + x475
    x477 = x21 * x322 + x476
    x478 = x12 * x458 + x182
    x479 = x473 * x68
    x480 = x55 * (x474 * x68 + x56 * (x478 * x56 + x479))
    x481 = x208 * x22 + x480
    x482 = x304 + x462 * x89
    x483 = x283 * x89 + x463 * x89
    x484 = x55 * (x482 * x87 + x483 * x56)
    x485 = x22 * x220 + x484
    x486 = x21 * x329 + x485
    x487 = x300 * x89 + x468 * x89
    x488 = x483 * x68
    x489 = x55 * (x487 * x56 + x488)
    x490 = x217 * x22 + x489
    x491 = x317 + x472 * x89
    x492 = x313 * x87 + x473 * x89
    x493 = x55 * (x491 * x87 + x492 * x56)
    x494 = x22 * x232 + x493
    x495 = x21 * x337 + x494
    x496 = x312 * x87 + x478 * x89
    x497 = x492 * x68
    x498 = x55 * (x496 * x56 + x497)
    x499 = x22 * x229 + x498
    x500 = x206 + x472 * x99
    x501 = x164 * x99 + x473 * x99
    x502 = x55 * (x500 * x87 + x501 * x56)
    x503 = x22 * x241 + x502
    x504 = x21 * x347 + x503
    x505 = x182 * x99 + x478 * x99
    x506 = x501 * x68
    x507 = x55 * (x505 * x56 + x506)
    x508 = x22 * x238 + x507
    x509 = x55 * (x110 * x283 + x483 * x89)
    x510 = x22 * x246 + x509
    x511 = x21 * x354 + x510
    x512 = x55 * (x110 * x300 + x487 * x89)
    x513 = x22 * x244 + x512
    x514 = x55 * (x313 * x334 + x492 * x89)
    x515 = x22 * x252 + x514
    x516 = x21 * x359 + x515
    x517 = x55 * (x312 * x334 + x496 * x89)
    x518 = x22 * x250 + x517
    x519 = x55 * (x340 * x87 + x501 * x89)
    x520 = x22 * x259 + x519
    x521 = x21 * x364 + x520
    x522 = x55 * (x339 * x87 + x505 * x89)
    x523 = x22 * x256 + x522
    x524 = x55 * (x123 * x164 + x501 * x99)
    x525 = x22 * x265 + x524
    x526 = x21 * x369 + x525
    x527 = x55 * (x123 * x182 + x505 * x99)
    x528 = x22 * x263 + x527
    x529 = x12 * x271
    x530 = x268 * x274 + x32 - x529
    x531 = x530 * x6
    x532 = -x12 * x278 + x268 * x270 + x43
    x533 = x16 * x532
    x534 = -x4 * x533 + x5 * x530
    x535 = x4 * x534
    x536 = x531 + x535
    x537 = x531 * x56 + x536 * x56
    x538 = x55 * (x174 * x531 + x537 * x56)
    x539 = x22 * x293 + x538
    x540 = x22 * x295 + x539
    x541 = x6 * (x268 * x274 - x529 - x533 - x79)
    x542 = x12 * x16
    x543 = x268 * x277 - x297 * x542 + x80
    x544 = x5 * x534 + x541 - x82 * (x5 * x532 - x543 * x82)
    x545 = x4 * x544
    x546 = x534 * x6
    x547 = 2.0 * x546
    x548 = x22 * x291 + x55 * (x537 * x68 + x56 * (x536 * x68 + x56 * (x545 + x547)))
    x549 = x531 * x89
    x550 = x535 * x89 + x549
    x551 = x55 * (x308 * x531 + x550 * x56)
    x552 = x22 * x309 + x551
    x553 = x22 * x310 + x552
    x554 = x22 * x306 + x55 * (x550 * x68 + x56 * (x545 * x89 + x547 * x89))
    x555 = x12 * x530 + 2.0 * x286
    x556 = x555 * x87
    x557 = x12 * x534 + x284
    x558 = x556 + x557 * x56
    x559 = x55 * (x198 * x555 + x558 * x56)
    x560 = x22 * x321 + x559
    x561 = x22 * x322 + x560
    x562 = x12 * x544 + 2.0 * x300
    x563 = x22 * x319 + x55 * (x558 * x68 + x56 * (x557 * x68 + x56 * x562))
    x564 = x110 * x531
    x565 = x55 * (x110 * x535 + x564)
    x566 = x22 * x328 + x565
    x567 = x22 * x329 + x566
    x568 = x22 * x325 + x55 * (x110 * x545 + x110 * x547)
    x569 = x334 * x555
    x570 = x55 * (x308 * x557 + x569)
    x571 = x22 * x336 + x570
    x572 = x22 * x337 + x571
    x573 = x22 * x332 + x55 * (x308 * x562 + x331 * x557)
    x574 = x316 * x68 + x555 * x99
    x575 = x574 * x87
    x576 = x314 + x557 * x99
    x577 = x55 * (x56 * x576 + x575)
    x578 = x22 * x346 + x577
    x579 = x22 * x347 + x578
    x580 = x312 * x68 + x562 * x99
    x581 = x22 * x342 + x55 * (x56 * x580 + x576 * x68)
    x582 = x130 * x534
    x583 = x22 * x352 + x582
    x584 = x22 * x354 + x583
    x585 = x130 * x544 + x22 * x350
    x586 = x135 * x557
    x587 = x22 * x358 + x586
    x588 = x22 * x359 + x587
    x589 = x135 * x562 + x22 * x356
    x590 = x116 * x576
    x591 = x22 * x363 + x590
    x592 = x22 * x364 + x591
    x593 = x116 * x580 + x22 * x361
    x594 = x55 * (x341 + x576 * x99)
    x595 = x22 * x368 + x594
    x596 = x22 * x369 + x595
    x597 = x22 * x366 + x55 * (x339 * x68 + x580 * x99)
    x598 = x149 * x372 + 2.0 * x154 - x375 * x9
    x599 = x598 * x6
    x600 = x149 * x374 + 2.0 * x178 - x384 * x385
    x601 = x5 * x598 - x600 * x82
    x602 = x4 * x601
    x603 = (
        x21 * x380
        + x21 * x381
        + x55 * (x174 * x599 + x56 * (x56 * x599 + x56 * (x599 + x602)))
    )
    x604 = x598 * x9
    x605 = 3.0 * x373
    x606 = x604 + x605
    x607 = x606 * x87
    x608 = x601 * x9
    x609 = 3.0 * x388
    x610 = x608 + x609
    x611 = x21 * x397 + x21 * x398 + x55 * (x198 * x606 + x56 * (x56 * x610 + x607))
    x612 = x599 * x99
    x613 = x21 * x406 + x21 * x407 + x55 * (x210 * x599 + x56 * (x602 * x99 + x612))
    x614 = x393 * x62 + x606 * x89
    x615 = x614 * x87
    x616 = x395 * x62 + x610 * x89
    x617 = x21 * x412 + x21 * x413 + x55 * (x56 * x616 + x615)
    x618 = x604 * x99 + x605 * x99
    x619 = x618 * x87
    x620 = x608 * x99 + x609 * x99
    x621 = x21 * x419 + x21 * x420 + x55 * (x56 * x620 + x619)
    x622 = x123 * x599
    x623 = x21 * x425 + x21 * x426 + x55 * (x123 * x602 + x622)
    x624 = x21 * x429 + x21 * x430 + x55 * (x411 * x62 + x616 * x89)
    x625 = x21 * x433 + x21 * x434 + x55 * (x418 * x62 + x620 * x89)
    x626 = x21 * x437 + x21 * x438 + x55 * (x123 * x608 + x123 * x609)
    x627 = x145 * x601 + x21 * x441 + x21 * x442
    x628 = x149 * x446 + x273 - x449 * x9
    x629 = x6 * x628
    x630 = x149 * x448 + x296 - x384 * x457
    x631 = x5 * x628 - x630 * x82
    x632 = x55 * (x174 * x629 + x56 * (x56 * x629 + x56 * (x4 * x631 + x629)))
    x633 = x21 * x454 + x22 * x380 + x632
    x634 = 2.0 * x447
    x635 = x628 * x9 + x634
    x636 = x459 + x631 * x9
    x637 = x55 * (x198 * x635 + x56 * (x56 * x636 + x635 * x87))
    x638 = x21 * x466 + x22 * x397 + x637
    x639 = x12 * x628 + x373
    x640 = x12 * x631 + x388
    x641 = x55 * (x198 * x639 + x56 * (x56 * x640 + x639 * x87))
    x642 = x21 * x476 + x22 * x406 + x641
    x643 = x462 * x68 + x635 * x89
    x644 = x469 + x636 * x89
    x645 = x55 * (x56 * x644 + x643 * x87)
    x646 = x21 * x485 + x22 * x412 + x645
    x647 = x472 * x68
    x648 = x639 * x89 + x647
    x649 = x479 + x640 * x89
    x650 = x55 * (x56 * x649 + x648 * x87)
    x651 = x21 * x494 + x22 * x419 + x650
    x652 = x404 + x639 * x99
    x653 = x388 * x99 + x640 * x99
    x654 = x55 * (x56 * x653 + x652 * x87)
    x655 = x21 * x503 + x22 * x425 + x654
    x656 = x55 * (x488 + x644 * x89)
    x657 = x21 * x510 + x22 * x429 + x656
    x658 = x55 * (x497 + x649 * x89)
    x659 = x21 * x515 + x22 * x433 + x658
    x660 = x55 * (x506 + x653 * x89)
    x661 = x21 * x520 + x22 * x437 + x660
    x662 = x55 * (x123 * x388 + x653 * x99)
    x663 = x21 * x525 + x22 * x441 + x662
    x664 = x149 * x530 - x533 * x9
    x665 = x6 * x664
    x666 = x149 * x532 - x384 * x543
    x667 = x5 * x664 - x666 * x82
    x668 = x22 * x453 + x55 * (
        x174 * x665 + x56 * (x56 * x665 + x56 * (x4 * x667 + x665))
    )
    x669 = x22 * x454 + x668
    x670 = x531 + x664 * x9
    x671 = x546 + x667 * x9
    x672 = x22 * x465 + x55 * (x198 * x670 + x56 * (x56 * x671 + x670 * x87))
    x673 = x22 * x466 + x672
    x674 = x12 * x664 + x634
    x675 = x12 * x667 + x459
    x676 = x22 * x475 + x55 * (x198 * x674 + x56 * (x56 * x675 + x674 * x87))
    x677 = x22 * x476 + x676
    x678 = x549 + x670 * x89
    x679 = x546 * x89 + x671 * x89
    x680 = x22 * x484 + x55 * (x56 * x679 + x678 * x87)
    x681 = x22 * x485 + x680
    x682 = x556 + x674 * x89
    x683 = x557 * x87 + x675 * x89
    x684 = x22 * x493 + x55 * (x56 * x683 + x682 * x87)
    x685 = x22 * x494 + x684
    x686 = x647 + x674 * x99
    x687 = x479 + x675 * x99
    x688 = x22 * x502 + x55 * (x56 * x687 + x686 * x87)
    x689 = x22 * x503 + x688
    x690 = x22 * x509 + x55 * (x110 * x546 + x679 * x89)
    x691 = x22 * x510 + x690
    x692 = x22 * x514 + x55 * (x334 * x557 + x683 * x89)
    x693 = x22 * x515 + x692
    x694 = x22 * x519 + x55 * (x576 * x87 + x687 * x89)
    x695 = x22 * x520 + x694
    x696 = x22 * x524 + x55 * (x506 + x687 * x99)
    x697 = x22 * x525 + x696
    x698 = -x12 * x533 + x268 * x530 + 2.0 * x273
    x699 = x6 * x698
    x700 = x268 * x532 + 2.0 * x296 - x542 * x543
    x701 = x5 * x698 - x700 * x82
    x702 = x4 * x701
    x703 = (
        x22 * x538
        + x22 * x539
        + x55 * (x174 * x699 + x56 * (x56 * x699 + x56 * (x699 + x702)))
    )
    x704 = x699 * x89
    x705 = x22 * x551 + x22 * x552 + x55 * (x308 * x699 + x56 * (x702 * x89 + x704))
    x706 = x12 * x698 + 3.0 * x531
    x707 = x706 * x87
    x708 = x12 * x701 + 3.0 * x546
    x709 = x22 * x559 + x22 * x560 + x55 * (x198 * x706 + x56 * (x56 * x708 + x707))
    x710 = x110 * x699
    x711 = x22 * x565 + x22 * x566 + x55 * (x110 * x702 + x710)
    x712 = x334 * x706
    x713 = x22 * x570 + x22 * x571 + x55 * (x308 * x708 + x712)
    x714 = x555 * x62 + x706 * x99
    x715 = x714 * x87
    x716 = x557 * x62 + x708 * x99
    x717 = x22 * x577 + x22 * x578 + x55 * (x56 * x716 + x715)
    x718 = x130 * x701 + x22 * x582 + x22 * x583
    x719 = x135 * x708 + x22 * x586 + x22 * x587
    x720 = x116 * x716 + x22 * x590 + x22 * x591
    x721 = x22 * x594 + x22 * x595 + x55 * (x576 * x62 + x716 * x99)
    x722 = x0 * x175 + x172
    x723 = x129 * x4**3
    x724 = x0 * x155
    x725 = x0 * x199 + x195
    x726 = x129 * x7
    x727 = x192 * x726
    x728 = x0 * x211 + x208
    x729 = x12 * x726
    x730 = x0 * x220 + x217
    x731 = x0 * x197
    x732 = x0 * x232 + x229
    x733 = x0 * x241 + x238
    x734 = x140 * x4
    x735 = x0 * x246 + x244
    x736 = x114 + x219 * x89
    x737 = x0 * x252 + x250
    x738 = x121 + x231 * x89
    x739 = x0 * x259 + x256
    x740 = x123 * x191 + x127
    x741 = x0 * x265 + x263
    x742 = x372 * x723
    x743 = x155 * x21
    x744 = x723 * x743 + x742
    x745 = x393 * x726
    x746 = x21 * x727 + x745
    x747 = x372 * x729
    x748 = x729 * x743 + x747
    x749 = x197 * x410
    x750 = x197 * x21
    x751 = x219 * x750 + x749
    x752 = x197 * x417
    x753 = x231 * x750 + x752
    x754 = x372 * x734
    x755 = x734 * x743 + x754
    x756 = x55 * (x219 * x68 + x410 * x89)
    x757 = x176 * x736 + x756
    x758 = x55 * (x231 * x68 + x417 * x89)
    x759 = x176 * x738 + x758
    x760 = x55 * (x123 * x391 + x123 * x392)
    x761 = x176 * x740 + x760
    x762 = x145 * x372
    x763 = x145 * x743 + x762
    x764 = x446 * x723
    x765 = x155 * x22
    x766 = x723 * x765 + x764
    x767 = x462 * x726
    x768 = x22 * x727 + x767
    x769 = x472 * x726
    x770 = x729 * x765 + x769
    x771 = x197 * x482
    x772 = x197 * x22
    x773 = x219 * x772 + x771
    x774 = x197 * x491
    x775 = x231 * x772 + x774
    x776 = x197 * x500
    x777 = x734 * x765 + x776
    x778 = x55 * (x327 + x482 * x89)
    x779 = x294 * x736 + x778
    x780 = x55 * (x335 + x491 * x89)
    x781 = x294 * x738 + x780
    x782 = x55 * (x345 + x500 * x89)
    x783 = x294 * x740 + x782
    x784 = x55 * (x240 + x500 * x99)
    x785 = x145 * x765 + x784
    x786 = x598 * x723
    x787 = x21 * x742 + x786
    x788 = x21 * x744 + x787
    x789 = x606 * x726
    x790 = x21 * x745 + x789
    x791 = x21 * x746 + x790
    x792 = x598 * x729
    x793 = x21 * x747 + x792
    x794 = x21 * x748 + x793
    x795 = x197 * x614
    x796 = x21 * x749 + x795
    x797 = x21 * x751 + x796
    x798 = x197 * x618
    x799 = x21 * x752 + x798
    x800 = x21 * x753 + x799
    x801 = x598 * x734
    x802 = x21 * x754 + x801
    x803 = x21 * x755 + x802
    x804 = x55 * (x410 * x62 + x614 * x89)
    x805 = x21 * x756 + x804
    x806 = x21 * x757 + x805
    x807 = x55 * (x417 * x62 + x618 * x89)
    x808 = x21 * x758 + x807
    x809 = x21 * x759 + x808
    x810 = x55 * (x123 * x604 + x123 * x605)
    x811 = x21 * x760 + x810
    x812 = x21 * x761 + x811
    x813 = x145 * x598
    x814 = x21 * x762 + x813
    x815 = x21 * x763 + x814
    x816 = x628 * x723
    x817 = x22 * x742 + x816
    x818 = x21 * x766 + x817
    x819 = x635 * x726
    x820 = x22 * x745 + x819
    x821 = x21 * x768 + x820
    x822 = x639 * x726
    x823 = x22 * x747 + x822
    x824 = x21 * x770 + x823
    x825 = x197 * x643
    x826 = x22 * x749 + x825
    x827 = x21 * x773 + x826
    x828 = x197 * x648
    x829 = x22 * x752 + x828
    x830 = x21 * x775 + x829
    x831 = x197 * x652
    x832 = x22 * x754 + x831
    x833 = x21 * x777 + x832
    x834 = x55 * (x482 * x68 + x643 * x89)
    x835 = x22 * x756 + x834
    x836 = x21 * x779 + x835
    x837 = x55 * (x491 * x68 + x648 * x89)
    x838 = x22 * x758 + x837
    x839 = x21 * x781 + x838
    x840 = x500 * x68
    x841 = x55 * (x652 * x89 + x840)
    x842 = x22 * x760 + x841
    x843 = x21 * x783 + x842
    x844 = x55 * (x424 + x652 * x99)
    x845 = x22 * x762 + x844
    x846 = x21 * x785 + x845
    x847 = x664 * x723
    x848 = x22 * x764 + x847
    x849 = x22 * x766 + x848
    x850 = x670 * x726
    x851 = x22 * x767 + x850
    x852 = x22 * x768 + x851
    x853 = x674 * x726
    x854 = x22 * x769 + x853
    x855 = x22 * x770 + x854
    x856 = x197 * x678
    x857 = x22 * x771 + x856
    x858 = x22 * x773 + x857
    x859 = x197 * x682
    x860 = x22 * x774 + x859
    x861 = x22 * x775 + x860
    x862 = x197 * x686
    x863 = x22 * x776 + x862
    x864 = x22 * x777 + x863
    x865 = x55 * (x564 + x678 * x89)
    x866 = x22 * x778 + x865
    x867 = x22 * x779 + x866
    x868 = x55 * (x569 + x682 * x89)
    x869 = x22 * x780 + x868
    x870 = x22 * x781 + x869
    x871 = x55 * (x575 + x686 * x89)
    x872 = x22 * x782 + x871
    x873 = x22 * x783 + x872
    x874 = x55 * (x686 * x99 + x840)
    x875 = x22 * x784 + x874
    x876 = x22 * x785 + x875
    x877 = x149 * x598 + 3.0 * x383 - x384 * x600
    x878 = x877 * x9
    x879 = 4.0 * x599
    x880 = x878 + x879
    x881 = 4.0 * x607 + x880 * x89
    x882 = x878 * x99 + x879 * x99
    x883 = x149 * x628 - x384 * x630 + 2.0 * x456
    x884 = x723 * x883
    x885 = 3.0 * x629 + x883 * x9
    x886 = x726 * x885
    x887 = x12 * x883 + x599
    x888 = x726 * x887
    x889 = x62 * x635 + x885 * x89
    x890 = x197 * x889
    x891 = x62 * x639 + x887 * x89
    x892 = x197 * x891
    x893 = x612 + x887 * x99
    x894 = x197 * x893
    x895 = x55 * (x62 * x643 + x889 * x89)
    x896 = x55 * (x62 * x648 + x89 * x891)
    x897 = x55 * (x62 * x652 + x89 * x893)
    x898 = x55 * (x622 + x893 * x99)
    x899 = x149 * x664 - x384 * x666 + x541
    x900 = x22 * x816 + x723 * x899
    x901 = 2.0 * x665 + x899 * x9
    x902 = x22 * x819 + x726 * x901
    x903 = x12 * x899 + 2.0 * x629
    x904 = x22 * x822 + x726 * x903
    x905 = x670 * x68 + x89 * x901
    x906 = x197 * x905 + x22 * x825
    x907 = x674 * x68 + x89 * x903
    x908 = x197 * x907 + x22 * x828
    x909 = x639 * x68 + x903 * x99
    x910 = x197 * x909 + x22 * x831
    x911 = x22 * x834 + x55 * (x678 * x68 + x89 * x905)
    x912 = x22 * x837 + x55 * (x68 * x682 + x89 * x907)
    x913 = x22 * x841 + x55 * (x68 * x686 + x89 * x909)
    x914 = x22 * x844 + x55 * (x652 * x68 + x909 * x99)
    x915 = x149 * x698 - x384 * x700
    x916 = x22 * x847 + x22 * x848 + x723 * x915
    x917 = x699 + x9 * x915
    x918 = x22 * x850 + x22 * x851 + x726 * x917
    x919 = x12 * x915 + 3.0 * x665
    x920 = x22 * x853 + x22 * x854 + x726 * x919
    x921 = x704 + x89 * x917
    x922 = x197 * x921 + x22 * x856 + x22 * x857
    x923 = x707 + x89 * x919
    x924 = x197 * x923 + x22 * x859 + x22 * x860
    x925 = x62 * x674 + x919 * x99
    x926 = x197 * x925 + x22 * x862 + x22 * x863
    x927 = x22 * x865 + x22 * x866 + x55 * (x710 + x89 * x921)
    x928 = x22 * x868 + x22 * x869 + x55 * (x712 + x89 * x923)
    x929 = x22 * x871 + x22 * x872 + x55 * (x715 + x89 * x925)
    x930 = x22 * x874 + x22 * x875 + x55 * (x62 * x686 + x925 * x99)
    x931 = x0 * x293 + x291
    x932 = x0 * x274
    x933 = x0 * x309 + x306
    x934 = x726 * x9
    x935 = x0 * x321 + x319
    x936 = x0 * x316
    x937 = x0 * x328 + x325
    x938 = x135 * x4
    x939 = x0 * x336 + x332
    x940 = x129 * x97
    x941 = x0 * x346 + x342
    x942 = x0 * x352 + x350
    x943 = x0 * x358 + x356
    x944 = x0 * x363 + x361
    x945 = x116 * x344
    x946 = x0 * x368 + x366
    x947 = x127 + x344 * x99
    x948 = x21 * x293 + x453
    x949 = x21 * x274
    x950 = x723 * x949 + x764
    x951 = x21 * x309 + x465
    x952 = x767 + x934 * x949
    x953 = x21 * x321 + x475
    x954 = x21 * x316
    x955 = x726 * x954 + x769
    x956 = x21 * x328 + x484
    x957 = x771 + x938 * x949
    x958 = x21 * x336 + x493
    x959 = x774 + x940 * x954
    x960 = x21 * x346 + x502
    x961 = x344 * x750 + x776
    x962 = x21 * x352 + x509
    x963 = x130 * x949 + x778
    x964 = x21 * x358 + x514
    x965 = x135 * x954 + x780
    x966 = x21 * x363 + x519
    x967 = x21 * x945 + x782
    x968 = x21 * x368 + x524
    x969 = x176 * x947 + x784
    x970 = x530 * x723
    x971 = x22 * x274
    x972 = x723 * x971 + x970
    x973 = x530 * x934
    x974 = x934 * x971 + x973
    x975 = x555 * x726
    x976 = x22 * x316
    x977 = x726 * x976 + x975
    x978 = x530 * x938
    x979 = x938 * x971 + x978
    x980 = x555 * x940
    x981 = x940 * x976 + x980
    x982 = x197 * x574
    x983 = x344 * x772 + x982
    x984 = x130 * x530
    x985 = x130 * x971 + x984
    x986 = x135 * x555
    x987 = x135 * x976 + x986
    x988 = x116 * x574
    x989 = x22 * x945 + x988
    x990 = x55 * (x344 * x68 + x574 * x99)
    x991 = x294 * x947 + x990
    x992 = x21 * x764 + x816
    x993 = x21 * x950 + x992
    x994 = x21 * x767 + x819
    x995 = x21 * x952 + x994
    x996 = x21 * x769 + x822
    x997 = x21 * x955 + x996
    x998 = x21 * x771 + x825
    x999 = x21 * x957 + x998
    x1000 = x21 * x774 + x828
    x1001 = x1000 + x21 * x959
    x1002 = x21 * x776 + x831
    x1003 = x1002 + x21 * x961
    x1004 = x21 * x778 + x834
    x1005 = x1004 + x21 * x963
    x1006 = x21 * x780 + x837
    x1007 = x1006 + x21 * x965
    x1008 = x21 * x782 + x841
    x1009 = x1008 + x21 * x967
    x1010 = x21 * x784 + x844
    x1011 = x1010 + x21 * x969
    x1012 = x21 * x972 + x848
    x1013 = x21 * x974 + x851
    x1014 = x21 * x977 + x854
    x1015 = x21 * x979 + x857
    x1016 = x21 * x981 + x860
    x1017 = x21 * x983 + x863
    x1018 = x21 * x985 + x866
    x1019 = x21 * x987 + x869
    x1020 = x21 * x989 + x872
    x1021 = x21 * x991 + x875
    x1022 = x698 * x723
    x1023 = x1022 + x22 * x970
    x1024 = x1023 + x22 * x972
    x1025 = x698 * x934
    x1026 = x1025 + x22 * x973
    x1027 = x1026 + x22 * x974
    x1028 = x706 * x726
    x1029 = x1028 + x22 * x975
    x1030 = x1029 + x22 * x977
    x1031 = x698 * x938
    x1032 = x1031 + x22 * x978
    x1033 = x1032 + x22 * x979
    x1034 = x706 * x940
    x1035 = x1034 + x22 * x980
    x1036 = x1035 + x22 * x981
    x1037 = x197 * x714
    x1038 = x1037 + x22 * x982
    x1039 = x1038 + x22 * x983
    x1040 = x130 * x698
    x1041 = x1040 + x22 * x984
    x1042 = x1041 + x22 * x985
    x1043 = x135 * x706
    x1044 = x1043 + x22 * x986
    x1045 = x1044 + x22 * x987
    x1046 = x116 * x714
    x1047 = x1046 + x22 * x988
    x1048 = x1047 + x22 * x989
    x1049 = x55 * (x574 * x62 + x714 * x99)
    x1050 = x1049 + x22 * x990
    x1051 = x1050 + x22 * x991
    x1052 = x268 * x698 + 3.0 * x541 - x542 * x700
    x1053 = x1052 * x12 + 4.0 * x699
    x1054 = x1053 * x99 + 4.0 * x707

    # 300 item(s)
    return numpy.array(
        [
            x0 * x70
            + x0 * x75
            + x0 * (x0 * (x74 + x77 * x78) + x75)
            + x55 * (x56 * (x54 * x88 + x56 * (x84 + x86)) + x63 * x88),
            x0 * x92
            + x0 * x96
            + x0 * (x0 * (x78 * x98 + x95) + x96)
            + x55 * (x56 * (x84 * x89 + x86 * x89) + x88 * x90),
            x0 * x102
            + x0 * x106
            + x0 * (x0 * (x105 + x108 * x78) + x106)
            + x55 * (x100 * x88 + x56 * (x84 * x99 + x86 * x99)),
            x0 * x111
            + x0 * x113
            + x0 * (x0 * (x112 + x115 * x78) + x113)
            + x55 * (x110 * x84 + x110 * x86),
            x0 * x118
            + x0 * x120
            + x0 * (x0 * (x119 + x122 * x78) + x120)
            + x55 * (x117 * x84 + x117 * x86),
            x0 * x124
            + x0 * x126
            + x0 * (x0 * (x125 + x128 * x78) + x126)
            + x55 * (x123 * x84 + x123 * x86),
            x0 * x131 + x0 * x133 + x0 * (x0 * (x130 * x134 + x132) + x133) + x130 * x83,
            x0 * x137 + x0 * x139 + x0 * (x0 * (x134 * x136 + x138) + x139) + x136 * x83,
            x0 * x142 + x0 * x144 + x0 * (x0 * (x134 * x141 + x143) + x144) + x141 * x83,
            x0 * x146 + x0 * x148 + x0 * (x0 * (x134 * x145 + x147) + x148) + x145 * x83,
            x0 * x173 + x0 * (x0 * x177 + x173) + x184 + x21 * x70,
            x0 * x196 + x0 * (x0 * x200 + x196) + x203 + x21 * x92,
            x0 * x209 + x0 * (x0 * x212 + x209) + x102 * x21 + x213,
            x0 * x218 + x0 * (x0 * x221 + x218) + x111 * x21 + x223,
            x0 * x230 + x0 * (x0 * x233 + x230) + x118 * x21 + x236,
            x0 * x239 + x0 * (x0 * x242 + x239) + x124 * x21 + x243,
            x0 * x245 + x0 * (x0 * x248 + x245) + x131 * x21 + x249,
            x0 * x251 + x0 * (x0 * x253 + x251) + x137 * x21 + x254,
            x0 * x257 + x0 * (x0 * x260 + x257) + x142 * x21 + x262,
            x0 * x264 + x0 * (x0 * x266 + x264) + x146 * x21 + x267,
            x0 * x292 + x0 * (x0 * x295 + x292) + x22 * x70 + x302,
            x0 * x307 + x0 * (x0 * x310 + x307) + x22 * x92 + x311,
            x0 * x320 + x0 * (x0 * x322 + x320) + x102 * x22 + x324,
            x0 * x326 + x0 * (x0 * x329 + x326) + x111 * x22 + x330,
            x0 * x333 + x0 * (x0 * x337 + x333) + x118 * x22 + x338,
            x0 * x343 + x0 * (x0 * x347 + x343) + x124 * x22 + x349,
            x0 * x351 + x0 * (x0 * x354 + x351) + x131 * x22 + x355,
            x0 * x357 + x0 * (x0 * x359 + x357) + x137 * x22 + x360,
            x0 * x362 + x0 * (x0 * x364 + x362) + x142 * x22 + x365,
            x0 * x367 + x0 * (x0 * x369 + x367) + x146 * x22 + x370,
            x0 * x382 + x173 * x21 + x390,
            x0 * x399 + x196 * x21 + x403,
            x0 * x408 + x209 * x21 + x409,
            x0 * x414 + x21 * x218 + x416,
            x0 * x421 + x21 * x230 + x423,
            x0 * x427 + x21 * x239 + x428,
            x0 * x431 + x21 * x245 + x432,
            x0 * x435 + x21 * x251 + x436,
            x0 * x439 + x21 * x257 + x440,
            x0 * x443 + x21 * x264 + x444,
            x0 * x455 + x21 * x292 + x461,
            x0 * x467 + x21 * x307 + x471,
            x0 * x477 + x21 * x320 + x481,
            x0 * x486 + x21 * x326 + x490,
            x0 * x495 + x21 * x333 + x499,
            x0 * x504 + x21 * x343 + x508,
            x0 * x511 + x21 * x351 + x513,
            x0 * x516 + x21 * x357 + x518,
            x0 * x521 + x21 * x362 + x523,
            x0 * x526 + x21 * x367 + x528,
            x0 * x540 + x22 * x292 + x548,
            x0 * x553 + x22 * x307 + x554,
            x0 * x561 + x22 * x320 + x563,
            x0 * x567 + x22 * x326 + x568,
            x0 * x572 + x22 * x333 + x573,
            x0 * x579 + x22 * x343 + x581,
            x0 * x584 + x22 * x351 + x585,
            x0 * x588 + x22 * x357 + x589,
            x0 * x592 + x22 * x362 + x593,
            x0 * x596 + x22 * x367 + x597,
            x21 * x382 + x603,
            x21 * x399 + x611,
            x21 * x408 + x613,
            x21 * x414 + x617,
            x21 * x421 + x621,
            x21 * x427 + x623,
            x21 * x431 + x624,
            x21 * x435 + x625,
            x21 * x439 + x626,
            x21 * x443 + x627,
            x21 * x455 + x633,
            x21 * x467 + x638,
            x21 * x477 + x642,
            x21 * x486 + x646,
            x21 * x495 + x651,
            x21 * x504 + x655,
            x21 * x511 + x657,
            x21 * x516 + x659,
            x21 * x521 + x661,
            x21 * x526 + x663,
            x21 * x540 + x669,
            x21 * x553 + x673,
            x21 * x561 + x677,
            x21 * x567 + x681,
            x21 * x572 + x685,
            x21 * x579 + x689,
            x21 * x584 + x691,
            x21 * x588 + x693,
            x21 * x592 + x695,
            x21 * x596 + x697,
            x22 * x540 + x703,
            x22 * x553 + x705,
            x22 * x561 + x709,
            x22 * x567 + x711,
            x22 * x572 + x713,
            x22 * x579 + x717,
            x22 * x584 + x718,
            x22 * x588 + x719,
            x22 * x592 + x720,
            x22 * x596 + x721,
            x0 * x172 + x0 * x722 + x0 * (x0 * (x175 + x723 * x724) + x722) + x184,
            x0 * x195 + x0 * x725 + x0 * (x0 * (x0 * x727 + x199) + x725) + x203,
            x0 * x208 + x0 * x728 + x0 * (x0 * (x211 + x724 * x729) + x728) + x213,
            x0 * x217 + x0 * x730 + x0 * (x0 * (x219 * x731 + x220) + x730) + x223,
            x0 * x229 + x0 * x732 + x0 * (x0 * (x231 * x731 + x232) + x732) + x236,
            x0 * x238 + x0 * x733 + x0 * (x0 * (x241 + x724 * x734) + x733) + x243,
            x0 * x244 + x0 * x735 + x0 * (x0 * (x246 + x736 * x78) + x735) + x249,
            x0 * x250 + x0 * x737 + x0 * (x0 * (x252 + x738 * x78) + x737) + x254,
            x0 * x256 + x0 * x739 + x0 * (x0 * (x259 + x740 * x78) + x739) + x262,
            x0 * x263 + x0 * x741 + x0 * (x0 * (x145 * x724 + x265) + x741) + x267,
            x0 * x381 + x0 * (x0 * x744 + x381) + x390,
            x0 * x398 + x0 * (x0 * x746 + x398) + x403,
            x0 * x407 + x0 * (x0 * x748 + x407) + x409,
            x0 * x413 + x0 * (x0 * x751 + x413) + x416,
            x0 * x420 + x0 * (x0 * x753 + x420) + x423,
            x0 * x426 + x0 * (x0 * x755 + x426) + x428,
            x0 * x430 + x0 * (x0 * x757 + x430) + x432,
            x0 * x434 + x0 * (x0 * x759 + x434) + x436,
            x0 * x438 + x0 * (x0 * x761 + x438) + x440,
            x0 * x442 + x0 * (x0 * x763 + x442) + x444,
            x0 * x454 + x0 * (x0 * x766 + x454) + x461,
            x0 * x466 + x0 * (x0 * x768 + x466) + x471,
            x0 * x476 + x0 * (x0 * x770 + x476) + x481,
            x0 * x485 + x0 * (x0 * x773 + x485) + x490,
            x0 * x494 + x0 * (x0 * x775 + x494) + x499,
            x0 * x503 + x0 * (x0 * x777 + x503) + x508,
            x0 * x510 + x0 * (x0 * x779 + x510) + x513,
            x0 * x515 + x0 * (x0 * x781 + x515) + x518,
            x0 * x520 + x0 * (x0 * x783 + x520) + x523,
            x0 * x525 + x0 * (x0 * x785 + x525) + x528,
            x0 * x788 + x603,
            x0 * x791 + x611,
            x0 * x794 + x613,
            x0 * x797 + x617,
            x0 * x800 + x621,
            x0 * x803 + x623,
            x0 * x806 + x624,
            x0 * x809 + x625,
            x0 * x812 + x626,
            x0 * x815 + x627,
            x0 * x818 + x633,
            x0 * x821 + x638,
            x0 * x824 + x642,
            x0 * x827 + x646,
            x0 * x830 + x651,
            x0 * x833 + x655,
            x0 * x836 + x657,
            x0 * x839 + x659,
            x0 * x843 + x661,
            x0 * x846 + x663,
            x0 * x849 + x669,
            x0 * x852 + x673,
            x0 * x855 + x677,
            x0 * x858 + x681,
            x0 * x861 + x685,
            x0 * x864 + x689,
            x0 * x867 + x691,
            x0 * x870 + x693,
            x0 * x873 + x695,
            x0 * x876 + x697,
            x21 * x786 + x21 * x787 + x21 * x788 + x723 * x877,
            x21 * x789 + x21 * x790 + x21 * x791 + x726 * x880,
            x21 * x792 + x21 * x793 + x21 * x794 + x729 * x877,
            x197 * x881 + x21 * x795 + x21 * x796 + x21 * x797,
            x197 * x882 + x21 * x798 + x21 * x799 + x21 * x800,
            x21 * x801 + x21 * x802 + x21 * x803 + x734 * x877,
            x21 * x804 + x21 * x805 + x21 * x806 + x55 * (4.0 * x615 + x881 * x89),
            x21 * x807 + x21 * x808 + x21 * x809 + x55 * (4.0 * x619 + x882 * x89),
            x21 * x810 + x21 * x811 + x21 * x812 + x55 * (x123 * x878 + x123 * x879),
            x145 * x877 + x21 * x813 + x21 * x814 + x21 * x815,
            x21 * x817 + x21 * x818 + x22 * x786 + x884,
            x21 * x820 + x21 * x821 + x22 * x789 + x886,
            x21 * x823 + x21 * x824 + x22 * x792 + x888,
            x21 * x826 + x21 * x827 + x22 * x795 + x890,
            x21 * x829 + x21 * x830 + x22 * x798 + x892,
            x21 * x832 + x21 * x833 + x22 * x801 + x894,
            x21 * x835 + x21 * x836 + x22 * x804 + x895,
            x21 * x838 + x21 * x839 + x22 * x807 + x896,
            x21 * x842 + x21 * x843 + x22 * x810 + x897,
            x21 * x845 + x21 * x846 + x22 * x813 + x898,
            x21 * x849 + x22 * x817 + x900,
            x21 * x852 + x22 * x820 + x902,
            x21 * x855 + x22 * x823 + x904,
            x21 * x858 + x22 * x826 + x906,
            x21 * x861 + x22 * x829 + x908,
            x21 * x864 + x22 * x832 + x910,
            x21 * x867 + x22 * x835 + x911,
            x21 * x870 + x22 * x838 + x912,
            x21 * x873 + x22 * x842 + x913,
            x21 * x876 + x22 * x845 + x914,
            x22 * x849 + x916,
            x22 * x852 + x918,
            x22 * x855 + x920,
            x22 * x858 + x922,
            x22 * x861 + x924,
            x22 * x864 + x926,
            x22 * x867 + x927,
            x22 * x870 + x928,
            x22 * x873 + x929,
            x22 * x876 + x930,
            x0 * x291 + x0 * x931 + x0 * (x0 * (x293 + x723 * x932) + x931) + x302,
            x0 * x306 + x0 * x933 + x0 * (x0 * (x309 + x932 * x934) + x933) + x311,
            x0 * x319 + x0 * x935 + x0 * (x0 * (x321 + x726 * x936) + x935) + x324,
            x0 * x325 + x0 * x937 + x0 * (x0 * (x328 + x932 * x938) + x937) + x330,
            x0 * x332 + x0 * x939 + x0 * (x0 * (x336 + x936 * x940) + x939) + x338,
            x0 * x342 + x0 * x941 + x0 * (x0 * (x344 * x731 + x346) + x941) + x349,
            x0 * x350 + x0 * x942 + x0 * (x0 * (x130 * x932 + x352) + x942) + x355,
            x0 * x356 + x0 * x943 + x0 * (x0 * (x135 * x936 + x358) + x943) + x360,
            x0 * x361 + x0 * x944 + x0 * (x0 * (x0 * x945 + x363) + x944) + x365,
            x0 * x366 + x0 * x946 + x0 * (x0 * (x368 + x78 * x947) + x946) + x370,
            x0 * x948 + x0 * (x0 * x950 + x948) + x21 * x291 + x460,
            x0 * x951 + x0 * (x0 * x952 + x951) + x21 * x306 + x470,
            x0 * x953 + x0 * (x0 * x955 + x953) + x21 * x319 + x480,
            x0 * x956 + x0 * (x0 * x957 + x956) + x21 * x325 + x489,
            x0 * x958 + x0 * (x0 * x959 + x958) + x21 * x332 + x498,
            x0 * x960 + x0 * (x0 * x961 + x960) + x21 * x342 + x507,
            x0 * x962 + x0 * (x0 * x963 + x962) + x21 * x350 + x512,
            x0 * x964 + x0 * (x0 * x965 + x964) + x21 * x356 + x517,
            x0 * x966 + x0 * (x0 * x967 + x966) + x21 * x361 + x522,
            x0 * x968 + x0 * (x0 * x969 + x968) + x21 * x366 + x527,
            x0 * x539 + x0 * (x0 * x972 + x539) + x548,
            x0 * x552 + x0 * (x0 * x974 + x552) + x554,
            x0 * x560 + x0 * (x0 * x977 + x560) + x563,
            x0 * x566 + x0 * (x0 * x979 + x566) + x568,
            x0 * x571 + x0 * (x0 * x981 + x571) + x573,
            x0 * x578 + x0 * (x0 * x983 + x578) + x581,
            x0 * x583 + x0 * (x0 * x985 + x583) + x585,
            x0 * x587 + x0 * (x0 * x987 + x587) + x589,
            x0 * x591 + x0 * (x0 * x989 + x591) + x593,
            x0 * x595 + x0 * (x0 * x991 + x595) + x597,
            x0 * x993 + x21 * x453 + x21 * x948 + x632,
            x0 * x995 + x21 * x465 + x21 * x951 + x637,
            x0 * x997 + x21 * x475 + x21 * x953 + x641,
            x0 * x999 + x21 * x484 + x21 * x956 + x645,
            x0 * x1001 + x21 * x493 + x21 * x958 + x650,
            x0 * x1003 + x21 * x502 + x21 * x960 + x654,
            x0 * x1005 + x21 * x509 + x21 * x962 + x656,
            x0 * x1007 + x21 * x514 + x21 * x964 + x658,
            x0 * x1009 + x21 * x519 + x21 * x966 + x660,
            x0 * x1011 + x21 * x524 + x21 * x968 + x662,
            x0 * x1012 + x21 * x539 + x668,
            x0 * x1013 + x21 * x552 + x672,
            x0 * x1014 + x21 * x560 + x676,
            x0 * x1015 + x21 * x566 + x680,
            x0 * x1016 + x21 * x571 + x684,
            x0 * x1017 + x21 * x578 + x688,
            x0 * x1018 + x21 * x583 + x690,
            x0 * x1019 + x21 * x587 + x692,
            x0 * x1020 + x21 * x591 + x694,
            x0 * x1021 + x21 * x595 + x696,
            x0 * x1024 + x703,
            x0 * x1027 + x705,
            x0 * x1030 + x709,
            x0 * x1033 + x711,
            x0 * x1036 + x713,
            x0 * x1039 + x717,
            x0 * x1042 + x718,
            x0 * x1045 + x719,
            x0 * x1048 + x720,
            x0 * x1051 + x721,
            x21 * x816 + x21 * x992 + x21 * x993 + x884,
            x21 * x819 + x21 * x994 + x21 * x995 + x886,
            x21 * x822 + x21 * x996 + x21 * x997 + x888,
            x21 * x825 + x21 * x998 + x21 * x999 + x890,
            x1000 * x21 + x1001 * x21 + x21 * x828 + x892,
            x1002 * x21 + x1003 * x21 + x21 * x831 + x894,
            x1004 * x21 + x1005 * x21 + x21 * x834 + x895,
            x1006 * x21 + x1007 * x21 + x21 * x837 + x896,
            x1008 * x21 + x1009 * x21 + x21 * x841 + x897,
            x1010 * x21 + x1011 * x21 + x21 * x844 + x898,
            x1012 * x21 + x21 * x848 + x900,
            x1013 * x21 + x21 * x851 + x902,
            x1014 * x21 + x21 * x854 + x904,
            x1015 * x21 + x21 * x857 + x906,
            x1016 * x21 + x21 * x860 + x908,
            x1017 * x21 + x21 * x863 + x910,
            x1018 * x21 + x21 * x866 + x911,
            x1019 * x21 + x21 * x869 + x912,
            x1020 * x21 + x21 * x872 + x913,
            x1021 * x21 + x21 * x875 + x914,
            x1024 * x21 + x916,
            x1027 * x21 + x918,
            x1030 * x21 + x920,
            x1033 * x21 + x922,
            x1036 * x21 + x924,
            x1039 * x21 + x926,
            x1042 * x21 + x927,
            x1045 * x21 + x928,
            x1048 * x21 + x929,
            x1051 * x21 + x930,
            x1022 * x22 + x1023 * x22 + x1024 * x22 + x1052 * x723,
            x1025 * x22 + x1026 * x22 + x1027 * x22 + x1052 * x934,
            x1028 * x22 + x1029 * x22 + x1030 * x22 + x1053 * x726,
            x1031 * x22 + x1032 * x22 + x1033 * x22 + x1052 * x938,
            x1034 * x22 + x1035 * x22 + x1036 * x22 + x1053 * x940,
            x1037 * x22 + x1038 * x22 + x1039 * x22 + x1054 * x197,
            x1040 * x22 + x1041 * x22 + x1042 * x22 + x1052 * x130,
            x1043 * x22 + x1044 * x22 + x1045 * x22 + x1053 * x135,
            x1046 * x22 + x1047 * x22 + x1048 * x22 + x1054 * x116,
            x1049 * x22 + x1050 * x22 + x1051 * x22 + x55 * (x1054 * x99 + 4.0 * x715),
        ]
    )


def _3center2el3d_sph_134(a, A, b, B, c, C):
    """Cartesian (pf|g) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = x4**2
    x8 = -x2 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x2 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x1
    x15 = x14 ** (-1.0)
    x16 = c * x15
    x17 = x1 * x16 * (x10 + x13 + x7)
    x18 = boys(5, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x0**2 + x21**2 + x22**2))
    x24 = x20 * x23
    x25 = x2 * x24
    x26 = 2.0 * x19 * x25
    x27 = x18 * x26
    x28 = c ** (-1.0)
    x29 = x14 ** (-0.5)
    x30 = boys(4, x17)
    x31 = 2.0 * x2 * x20 * x23 * x28 * x29 * x30 - x27
    x32 = x31 * x6
    x33 = -2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x5 + x27 * x4
    x34 = -x33
    x35 = boys(6, x17)
    x36 = x26 * x35
    x37 = -2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x5 + x36 * x4
    x38 = -x37
    x39 = x16 * x38
    x40 = x39 * x4
    x41 = x32 + x34 * x5 - x40
    x42 = 2.0 * x6
    x43 = x6 * (2.0 * x18 * x2 * x20 * x23 * x28 * x29 - x36)
    x44 = boys(7, x17)
    x45 = x26 * x44
    x46 = 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x5 - x4 * x45
    x47 = x16 * x46
    x48 = x38 * x5 - x4 * x47 + x43
    x49 = x16 * x48
    x50 = -x4 * x49 + x41 * x5 + x42 * (-x33 - x39)
    x51 = x4 * x50
    x52 = x41 * x6
    x53 = 3.0 * x52
    x54 = x51 + x53
    x55 = x1 * x15
    x56 = x4 * x55
    x57 = x4 * x41
    x58 = x34 * x6
    x59 = 2.0 * x58
    x60 = x57 + x59
    x61 = 3.0 * x6
    x62 = x55 * x61
    x63 = x54 * x56 + x60 * x62
    x64 = x34 * x4
    x65 = x28 * x30 * x42
    x66 = x25 * x29 * x65
    x67 = x64 + x66
    x68 = x42 * x55
    x69 = x56 * x60 + x67 * x68
    x70 = x56 * x63 + x62 * x69
    x71 = x24 * x65
    x72 = x19 * x71
    x73 = x4 * x72 + x56 * x67
    x74 = x56 * x69 + x68 * x73
    x75 = x55 * (x56 * x70 + x62 * x74)
    x76 = x7 * x71
    x77 = x1 * x14 ** (-2.5)
    x78 = x56 * x73 + x76 * x77
    x79 = x55 * (x56 * x74 + x68 * x78)
    x80 = x0 * x79 + x75
    x81 = x4**3
    x82 = x1**2
    x83 = x14 ** (-3.5) * x82
    x84 = x71 * x83
    x85 = x56 * x78 + x81 * x84
    x86 = x0 * x55
    x87 = -x31 * x6
    x88 = x6 * (2.0 * x2 * x20 * x23 * x28 * x29 * x35 - x45)
    x89 = x26 * boys(8, x17)
    x90 = x16 * x4
    x91 = (
        x5 * x50
        + x61 * (x34 * x5 - x40 - x49 - x87)
        - x90
        * (
            x42 * (-x37 - x47)
            + x48 * x5
            - x90
            * (
                x46 * x5
                + x88
                - x90 * (2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x5 - x4 * x89)
            )
        )
    )
    x92 = x4 * x91
    x93 = x50 * x6
    x94 = 4.0 * x93
    x95 = x55 * x6
    x96 = 4.0 * x95
    x97 = x55 * x9
    x98 = x51 * x97 + x53 * x97
    x99 = x57 * x97 + x59 * x97
    x100 = x56 * x98 + x62 * x99
    x101 = x72 * x9
    x102 = x101 + x64 * x97
    x103 = x102 * x68 + x56 * x99
    x104 = x55 * (x100 * x56 + x103 * x62)
    x105 = x71 * x77
    x106 = x105 * x4
    x107 = x102 * x56 + x106 * x9
    x108 = x55 * (x103 * x56 + x107 * x68)
    x109 = x0 * x108 + x104
    x110 = x76 * x83
    x111 = x107 * x56 + x110 * x9
    x112 = x12 * x55
    x113 = x112 * x51 + x112 * x53
    x114 = x112 * x57 + x112 * x59
    x115 = x113 * x56 + x114 * x62
    x116 = x12 * x72
    x117 = x112 * x64 + x116
    x118 = x114 * x56 + x117 * x68
    x119 = x55 * (x115 * x56 + x118 * x62)
    x120 = x106 * x12 + x117 * x56
    x121 = x55 * (x118 * x56 + x120 * x68)
    x122 = x0 * x121 + x119
    x123 = x110 * x12 + x120 * x56
    x124 = x82 / x14**2
    x125 = x10 * x124
    x126 = x125 * x51 + x125 * x53
    x127 = x125 * x57 + x125 * x59
    x128 = x55 * (x126 * x56 + x127 * x62)
    x129 = x10 * x105
    x130 = x125 * x64 + x129
    x131 = x55 * (x127 * x56 + x130 * x68)
    x132 = x0 * x131 + x128
    x133 = x10 * x84
    x134 = x130 * x56 + x133 * x4
    x135 = x124 * x9
    x136 = x12 * x135
    x137 = x136 * x51 + x136 * x53
    x138 = x136 * x57 + x136 * x59
    x139 = x55 * (x137 * x56 + x138 * x62)
    x140 = x12 * x9
    x141 = x105 * x140
    x142 = x136 * x64 + x141
    x143 = x55 * (x138 * x56 + x142 * x68)
    x144 = x0 * x143 + x139
    x145 = x140 * x4 * x84 + x142 * x56
    x146 = x124 * x13
    x147 = x146 * x51 + x146 * x53
    x148 = x146 * x57 + x146 * x59
    x149 = x55 * (x147 * x56 + x148 * x62)
    x150 = x105 * x13
    x151 = x146 * x64 + x150
    x152 = x55 * (x148 * x56 + x151 * x68)
    x153 = x0 * x152 + x149
    x154 = x13 * x4
    x155 = x151 * x56 + x154 * x84
    x156 = x9**3
    x157 = x1**3 / x14**3
    x158 = x156 * x157
    x159 = x55 * (x158 * x51 + x158 * x53)
    x160 = x55 * (x158 * x57 + x158 * x59)
    x161 = x0 * x160 + x159
    x162 = x156 * x84
    x163 = x158 * x64 + x162
    x164 = x10 * x157
    x165 = x12 * x164
    x166 = x55 * (x165 * x51 + x165 * x53)
    x167 = x55 * (x165 * x57 + x165 * x59)
    x168 = x0 * x167 + x166
    x169 = x12 * x133
    x170 = x165 * x64 + x169
    x171 = x157 * x9
    x172 = x13 * x171
    x173 = x55 * (x172 * x51 + x172 * x53)
    x174 = x55 * (x172 * x57 + x172 * x59)
    x175 = x0 * x174 + x173
    x176 = x13 * x84 * x9
    x177 = x172 * x64 + x176
    x178 = x12**3
    x179 = x157 * x178
    x180 = x55 * (x179 * x51 + x179 * x53)
    x181 = x55 * (x179 * x57 + x179 * x59)
    x182 = x0 * x181 + x180
    x183 = x178 * x84
    x184 = x179 * x64 + x183
    x185 = x1**4 / x14**4
    x186 = x185 * x9**4
    x187 = x186 * x50
    x188 = x186 * x41
    x189 = x0 * x188 + x187
    x190 = x0 * x34
    x191 = x156 * x185
    x192 = x12 * x191
    x193 = x192 * x50
    x194 = x192 * x41
    x195 = x0 * x194 + x193
    x196 = x185 * x50
    x197 = x10 * x13
    x198 = x196 * x197
    x199 = x185 * x197
    x200 = x199 * x41
    x201 = x0 * x200 + x198
    x202 = x178 * x9
    x203 = x196 * x202
    x204 = x185 * x202
    x205 = x204 * x41
    x206 = x0 * x205 + x203
    x207 = x12**4 * x185
    x208 = x207 * x50
    x209 = x207 * x41
    x210 = x0 * x209 + x208
    x211 = -x8 - A[1]
    x212 = -2.0 * x18 * x2 * x20 * x211 * x23 * x28 * x29 + x36 * x9
    x213 = -x212
    x214 = x16 * x213
    x215 = -2.0 * x2 * x20 * x211 * x23 * x28 * x29 * x30 + x27 * x9
    x216 = x6 * (-x214 - x215)
    x217 = -x215
    x218 = x214 * x4 - x217 * x5
    x219 = -x218
    x220 = 2.0 * x2 * x20 * x211 * x23 * x28 * x29 * x35 - x45 * x9
    x221 = x16 * x220
    x222 = x213 * x5 - x221 * x4
    x223 = x16 * x222
    x224 = x216 + x219 * x5 - x223 * x4
    x225 = x224 * x4
    x226 = x219 * x6
    x227 = 2.0 * x226
    x228 = x225 + x227
    x229 = x217 * x6
    x230 = x219 * x4
    x231 = x229 + x230
    x232 = x228 * x56 + x231 * x68
    x233 = x229 * x56 + x231 * x56
    x234 = x232 * x56 + x233 * x68
    x235 = x124 * x7
    x236 = x229 * x235 + x233 * x56
    x237 = x55 * (x234 * x56 + x236 * x68)
    x238 = x21 * x79 + x237
    x239 = x157 * x81
    x240 = x55 * (x229 * x239 + x236 * x56)
    x241 = x21 * x55
    x242 = x240 + x241 * x85
    x243 = x6 * (-x212 - x221)
    x244 = 2.0 * x2 * x20 * x211 * x23 * x28 * x29 * x44 - x89 * x9
    x245 = (
        x224 * x5
        + x42 * (-x218 - x223)
        - x90 * (x222 * x5 + x243 - x90 * (x220 * x5 - x244 * x90))
    )
    x246 = x245 * x4
    x247 = x224 * x6
    x248 = 3.0 * x247
    x249 = x55 * (
        x234 * x62 + x56 * (x232 * x62 + x56 * (x228 * x62 + x56 * (x246 + x248)))
    )
    x250 = x224 * x9
    x251 = x250 + x52
    x252 = x219 * x9
    x253 = x252 + x58
    x254 = x253 * x68
    x255 = x251 * x56 + x254
    x256 = x217 * x9
    x257 = x256 + x66
    x258 = x257 * x55
    x259 = x253 * x56 + x258 * x6
    x260 = x255 * x56 + x259 * x68
    x261 = x124 * x4
    x262 = x257 * x6
    x263 = x259 * x56 + x261 * x262
    x264 = x55 * (x260 * x56 + x263 * x68)
    x265 = x108 * x21 + x264
    x266 = x157 * x7
    x267 = x55 * (x262 * x266 + x263 * x56)
    x268 = x111 * x241 + x267
    x269 = x245 * x9
    x270 = x269 + x93
    x271 = x55 * (x260 * x62 + x56 * (x255 * x62 + x56 * (x251 * x62 + x270 * x56)))
    x272 = x112 * x227
    x273 = x112 * x225 + x272
    x274 = x112 * x229
    x275 = x112 * x230 + x274
    x276 = x273 * x56 + x275 * x68
    x277 = x12 * x229
    x278 = x261 * x277 + x275 * x56
    x279 = x55 * (x276 * x56 + x278 * x68)
    x280 = x121 * x21 + x279
    x281 = x55 * (x266 * x277 + x278 * x56)
    x282 = x123 * x241 + x281
    x283 = x55 * (x276 * x62 + x56 * (x273 * x62 + x56 * (x112 * x246 + x112 * x248)))
    x284 = x251 * x97 + x52 * x97
    x285 = x253 * x97 + x58 * x97
    x286 = x285 * x68
    x287 = x284 * x56 + x286
    x288 = x101 + x258 * x9
    x289 = x285 * x56 + x288 * x95
    x290 = x55 * (x287 * x56 + x289 * x68)
    x291 = x131 * x21 + x290
    x292 = x261 * x6
    x293 = x55 * (x288 * x292 + x289 * x56)
    x294 = x134 * x241 + x293
    x295 = x270 * x97 + x93 * x97
    x296 = x55 * (x287 * x62 + x56 * (x284 * x62 + x295 * x56))
    x297 = x112 * x52
    x298 = x112 * x250 + x297
    x299 = x112 * x58
    x300 = x112 * x252 + x299
    x301 = x300 * x68
    x302 = x298 * x56 + x301
    x303 = x112 * x256 + x116
    x304 = x300 * x56 + x303 * x95
    x305 = x55 * (x302 * x56 + x304 * x68)
    x306 = x143 * x21 + x305
    x307 = x55 * (x292 * x303 + x304 * x56)
    x308 = x145 * x241 + x307
    x309 = x112 * x93
    x310 = x112 * x269 + x309
    x311 = x55 * (x302 * x62 + x56 * (x298 * x62 + x310 * x56))
    x312 = x146 * x227
    x313 = x146 * x225 + x312
    x314 = x146 * x229
    x315 = x146 * x230 + x314
    x316 = x55 * (x313 * x56 + x315 * x68)
    x317 = x152 * x21 + x316
    x318 = x154 * x157
    x319 = x55 * (x229 * x318 + x315 * x56)
    x320 = x155 * x241 + x319
    x321 = x55 * (x313 * x62 + x56 * (x146 * x246 + x146 * x248))
    x322 = x125 * x52 + x284 * x97
    x323 = x125 * x58 + x285 * x97
    x324 = x323 * x68
    x325 = x55 * (x322 * x56 + x324)
    x326 = x160 * x21 + x325
    x327 = x129 + x288 * x97
    x328 = x55 * (x323 * x56 + x327 * x95)
    x329 = x163 * x241 + x328
    x330 = x125 * x93 + x295 * x97
    x331 = x55 * (x322 * x62 + x330 * x56)
    x332 = x136 * x52 + x298 * x97
    x333 = x136 * x58 + x300 * x97
    x334 = x333 * x68
    x335 = x55 * (x332 * x56 + x334)
    x336 = x167 * x21 + x335
    x337 = x141 + x303 * x97
    x338 = x55 * (x333 * x56 + x337 * x95)
    x339 = x170 * x241 + x338
    x340 = x136 * x93 + x310 * x97
    x341 = x55 * (x332 * x62 + x340 * x56)
    x342 = x146 * x52
    x343 = x146 * x250 + x342
    x344 = x146 * x58
    x345 = x146 * x252 + x344
    x346 = x345 * x68
    x347 = x55 * (x343 * x56 + x346)
    x348 = x174 * x21 + x347
    x349 = x146 * x256 + x150
    x350 = x55 * (x345 * x56 + x349 * x95)
    x351 = x177 * x241 + x350
    x352 = x146 * x93
    x353 = x146 * x269 + x352
    x354 = x55 * (x343 * x62 + x353 * x56)
    x355 = x179 * x227
    x356 = x55 * (x179 * x225 + x355)
    x357 = x181 * x21 + x356
    x358 = x179 * x229
    x359 = x55 * (x179 * x230 + x358)
    x360 = x184 * x241 + x359
    x361 = x55 * (x179 * x246 + x179 * x248)
    x362 = x55 * (x158 * x52 + x322 * x97)
    x363 = x188 * x21 + x362
    x364 = x55 * (x158 * x58 + x323 * x97)
    x365 = x21 * x34
    x366 = x186 * x365 + x364
    x367 = x55 * (x158 * x93 + x330 * x97)
    x368 = x55 * (x165 * x52 + x332 * x97)
    x369 = x194 * x21 + x368
    x370 = x55 * (x165 * x58 + x333 * x97)
    x371 = x192 * x365 + x370
    x372 = x55 * (x165 * x93 + x340 * x97)
    x373 = x55 * (x172 * x52 + x343 * x97)
    x374 = x200 * x21 + x373
    x375 = x55 * (x172 * x58 + x345 * x97)
    x376 = x199 * x365 + x375
    x377 = x55 * (x172 * x93 + x353 * x97)
    x378 = x179 * x52
    x379 = x55 * (x179 * x250 + x378)
    x380 = x205 * x21 + x379
    x381 = x179 * x58
    x382 = x55 * (x179 * x252 + x381)
    x383 = x204 * x365 + x382
    x384 = x179 * x93
    x385 = x55 * (x179 * x269 + x384)
    x386 = x207 * x224
    x387 = x209 * x21 + x386
    x388 = x207 * x219
    x389 = x207 * x365 + x388
    x390 = x207 * x245
    x391 = -x11 - A[2]
    x392 = x12 * x36 - 2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x391
    x393 = -x392
    x394 = x16 * x393
    x395 = x12 * x27 - 2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x391
    x396 = x6 * (-x394 - x395)
    x397 = -x395
    x398 = x394 * x4 - x397 * x5
    x399 = -x398
    x400 = -x12 * x45 + 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x391
    x401 = x16 * x400
    x402 = x393 * x5 - x4 * x401
    x403 = x16 * x402
    x404 = x396 + x399 * x5 - x4 * x403
    x405 = x4 * x404
    x406 = x399 * x6
    x407 = 2.0 * x406
    x408 = x405 + x407
    x409 = x397 * x6
    x410 = x399 * x4
    x411 = x409 + x410
    x412 = x408 * x56 + x411 * x68
    x413 = x409 * x56 + x411 * x56
    x414 = x412 * x56 + x413 * x68
    x415 = x235 * x409 + x413 * x56
    x416 = x55 * (x414 * x56 + x415 * x68)
    x417 = x22 * x79 + x416
    x418 = x55 * (x239 * x409 + x415 * x56)
    x419 = x22 * x55
    x420 = x418 + x419 * x85
    x421 = x6 * (-x392 - x401)
    x422 = -x12 * x89 + 2.0 * x2 * x20 * x23 * x28 * x29 * x391 * x44
    x423 = (
        x404 * x5
        + x42 * (-x398 - x403)
        - x90 * (x402 * x5 + x421 - x90 * (x400 * x5 - x422 * x90))
    )
    x424 = x4 * x423
    x425 = x404 * x6
    x426 = 3.0 * x425
    x427 = x55 * (
        x414 * x62 + x56 * (x412 * x62 + x56 * (x408 * x62 + x56 * (x424 + x426)))
    )
    x428 = x405 * x97 + x407 * x97
    x429 = x409 * x97
    x430 = x410 * x97 + x429
    x431 = x428 * x56 + x430 * x68
    x432 = x135 * x4
    x433 = x409 * x432 + x430 * x56
    x434 = x55 * (x431 * x56 + x433 * x68)
    x435 = x108 * x22 + x434
    x436 = x266 * x9
    x437 = x55 * (x409 * x436 + x433 * x56)
    x438 = x111 * x419 + x437
    x439 = x55 * (x431 * x62 + x56 * (x428 * x62 + x56 * (x424 * x97 + x426 * x97)))
    x440 = x12 * x404 + x52
    x441 = x12 * x399 + x58
    x442 = x441 * x68
    x443 = x440 * x56 + x442
    x444 = x12 * x397 + x66
    x445 = x444 * x95
    x446 = x441 * x56 + x445
    x447 = x443 * x56 + x446 * x68
    x448 = x292 * x444 + x446 * x56
    x449 = x55 * (x447 * x56 + x448 * x68)
    x450 = x121 * x22 + x449
    x451 = x444 * x6
    x452 = x55 * (x266 * x451 + x448 * x56)
    x453 = x123 * x419 + x452
    x454 = x12 * x423 + x93
    x455 = x55 * (x447 * x62 + x56 * (x443 * x62 + x56 * (x440 * x62 + x454 * x56)))
    x456 = x125 * x405 + x125 * x407
    x457 = x125 * x409
    x458 = x125 * x410 + x457
    x459 = x55 * (x456 * x56 + x458 * x68)
    x460 = x131 * x22 + x459
    x461 = x164 * x4
    x462 = x55 * (x409 * x461 + x458 * x56)
    x463 = x134 * x419 + x462
    x464 = x55 * (x456 * x62 + x56 * (x125 * x424 + x125 * x426))
    x465 = x42 * x441
    x466 = x135 * x465 + x432 * x440
    x467 = x135 * x451
    x468 = x432 * x441 + x467
    x469 = x55 * (x466 * x56 + x468 * x68)
    x470 = x143 * x22 + x469
    x471 = x171 * x4
    x472 = x55 * (x451 * x471 + x468 * x56)
    x473 = x145 * x419 + x472
    x474 = x440 * x61
    x475 = x55 * (x466 * x62 + x56 * (x135 * x474 + x432 * x454))
    x476 = x112 * x440 + x297
    x477 = x112 * x441 + x299
    x478 = x477 * x68
    x479 = x476 * x56 + x478
    x480 = x112 * x444 + x116
    x481 = x480 * x95
    x482 = x477 * x56 + x481
    x483 = x55 * (x479 * x56 + x482 * x68)
    x484 = x152 * x22 + x483
    x485 = x55 * (x292 * x480 + x482 * x56)
    x486 = x155 * x419 + x485
    x487 = x112 * x454 + x309
    x488 = x55 * (x479 * x62 + x56 * (x476 * x62 + x487 * x56))
    x489 = x55 * (x158 * x405 + x158 * x407)
    x490 = x160 * x22 + x489
    x491 = x158 * x409
    x492 = x55 * (x158 * x410 + x491)
    x493 = x163 * x419 + x492
    x494 = x55 * (x158 * x424 + x158 * x426)
    x495 = x55 * (x164 * x465 + x440 * x461)
    x496 = x167 * x22 + x495
    x497 = x164 * x451
    x498 = x55 * (x441 * x461 + x497)
    x499 = x170 * x419 + x498
    x500 = x55 * (x164 * x474 + x454 * x461)
    x501 = x135 * x42
    x502 = x55 * (x432 * x476 + x477 * x501)
    x503 = x174 * x22 + x502
    x504 = x135 * x6
    x505 = x480 * x504
    x506 = x55 * (x432 * x477 + x505)
    x507 = x177 * x419 + x506
    x508 = x55 * (x135 * x476 * x61 + x432 * x487)
    x509 = x112 * x476 + x342
    x510 = x112 * x477 + x344
    x511 = x510 * x68
    x512 = x55 * (x509 * x56 + x511)
    x513 = x181 * x22 + x512
    x514 = x112 * x480 + x150
    x515 = x514 * x95
    x516 = x55 * (x510 * x56 + x515)
    x517 = x184 * x419 + x516
    x518 = x112 * x487 + x352
    x519 = x55 * (x509 * x62 + x518 * x56)
    x520 = x186 * x404
    x521 = x188 * x22 + x520
    x522 = x186 * x399
    x523 = x22 * x34
    x524 = x186 * x523 + x522
    x525 = x186 * x423
    x526 = x191 * x440
    x527 = x194 * x22 + x526
    x528 = x191 * x441
    x529 = x192 * x523 + x528
    x530 = x191 * x454
    x531 = x164 * x476
    x532 = x200 * x22 + x531
    x533 = x164 * x477
    x534 = x199 * x523 + x533
    x535 = x164 * x487
    x536 = x135 * x509
    x537 = x205 * x22 + x536
    x538 = x135 * x510
    x539 = x204 * x523 + x538
    x540 = x135 * x518
    x541 = x55 * (x112 * x509 + x378)
    x542 = x209 * x22 + x541
    x543 = x55 * (x112 * x510 + x381)
    x544 = x207 * x523 + x543
    x545 = x55 * (x112 * x518 + x384)
    x546 = x214 * x9
    x547 = x211 * x217 + x32 - x546
    x548 = x547 * x6
    x549 = x211 * x213 - x221 * x9 + x43
    x550 = x16 * x549
    x551 = -x4 * x550 + x5 * x547
    x552 = x4 * x551
    x553 = x548 + x552
    x554 = x548 * x56 + x553 * x56
    x555 = x235 * x548 + x554 * x56
    x556 = x55 * (x239 * x548 + x555 * x56)
    x557 = x21 * x240 + x556
    x558 = x21 * x242 + x557
    x559 = x6 * (x211 * x217 - x546 - x550 - x87)
    x560 = x16 * x9
    x561 = x211 * x220 - x244 * x560 + x88
    x562 = x5 * x551 + x559 - x90 * (x5 * x549 - x561 * x90)
    x563 = x4 * x562
    x564 = x551 * x6
    x565 = 2.0 * x564
    x566 = x21 * x237 + x55 * (
        x555 * x68 + x56 * (x554 * x68 + x56 * (x553 * x68 + x56 * (x563 + x565)))
    )
    x567 = x547 * x9
    x568 = 2.0 * x229
    x569 = x567 + x568
    x570 = x551 * x9
    x571 = x227 + x570
    x572 = x56 * x571 + x569 * x95
    x573 = x292 * x569 + x56 * x572
    x574 = x266 * x6
    x575 = x55 * (x56 * x573 + x569 * x574)
    x576 = x21 * x267 + x575
    x577 = x21 * x268 + x576
    x578 = x562 * x9
    x579 = 2.0 * x247
    x580 = x578 + x579
    x581 = x21 * x264 + x55 * (
        x56 * (x56 * (x56 * x580 + x571 * x68) + x572 * x68) + x573 * x68
    )
    x582 = x112 * x548
    x583 = x112 * x552 + x582
    x584 = x12 * x548
    x585 = x261 * x584 + x56 * x583
    x586 = x55 * (x266 * x584 + x56 * x585)
    x587 = x21 * x281 + x586
    x588 = x21 * x282 + x587
    x589 = x21 * x279 + x55 * (
        x56 * (x56 * (x112 * x563 + x112 * x565) + x583 * x68) + x585 * x68
    )
    x590 = x258 * x42 + x569 * x97
    x591 = x254 + x571 * x97
    x592 = x56 * x591 + x590 * x95
    x593 = x55 * (x292 * x590 + x56 * x592)
    x594 = x21 * x293 + x593
    x595 = x21 * x294 + x594
    x596 = x251 * x68 + x580 * x97
    x597 = x21 * x290 + x55 * (x56 * (x56 * x596 + x591 * x68) + x592 * x68)
    x598 = x112 * x567 + x112 * x568
    x599 = x112 * x570 + x272
    x600 = x56 * x599 + x598 * x95
    x601 = x55 * (x292 * x598 + x56 * x600)
    x602 = x21 * x307 + x601
    x603 = x21 * x308 + x602
    x604 = x112 * x578 + x112 * x579
    x605 = x21 * x305 + x55 * (x56 * (x56 * x604 + x599 * x68) + x600 * x68)
    x606 = x146 * x548
    x607 = x146 * x552 + x606
    x608 = x55 * (x318 * x548 + x56 * x607)
    x609 = x21 * x319 + x608
    x610 = x21 * x320 + x609
    x611 = x21 * x316 + x55 * (x56 * (x146 * x563 + x146 * x565) + x607 * x68)
    x612 = x288 * x68 + x590 * x97
    x613 = x286 + x591 * x97
    x614 = x55 * (x56 * x613 + x612 * x95)
    x615 = x21 * x328 + x614
    x616 = x21 * x329 + x615
    x617 = x284 * x68 + x596 * x97
    x618 = x21 * x325 + x55 * (x56 * x617 + x613 * x68)
    x619 = x303 * x68 + x598 * x97
    x620 = x301 + x599 * x97
    x621 = x55 * (x56 * x620 + x619 * x95)
    x622 = x21 * x338 + x621
    x623 = x21 * x339 + x622
    x624 = x298 * x68 + x604 * x97
    x625 = x21 * x335 + x55 * (x56 * x624 + x620 * x68)
    x626 = x146 * x567 + x146 * x568
    x627 = x146 * x570 + x312
    x628 = x55 * (x56 * x627 + x626 * x95)
    x629 = x21 * x350 + x628
    x630 = x21 * x351 + x629
    x631 = x146 * x578 + x146 * x579
    x632 = x21 * x347 + x55 * (x56 * x631 + x627 * x68)
    x633 = x179 * x548
    x634 = x55 * (x179 * x552 + x633)
    x635 = x21 * x359 + x634
    x636 = x21 * x360 + x635
    x637 = x21 * x356 + x55 * (x179 * x563 + x179 * x565)
    x638 = x55 * (x324 + x613 * x97)
    x639 = x21 * x364 + x638
    x640 = x21 * x366 + x639
    x641 = x21 * x362 + x55 * (x322 * x68 + x617 * x97)
    x642 = x55 * (x334 + x620 * x97)
    x643 = x21 * x370 + x642
    x644 = x21 * x371 + x643
    x645 = x21 * x368 + x55 * (x332 * x68 + x624 * x97)
    x646 = x55 * (x346 + x627 * x97)
    x647 = x21 * x375 + x646
    x648 = x21 * x376 + x647
    x649 = x21 * x373 + x55 * (x343 * x68 + x631 * x97)
    x650 = x55 * (x179 * x570 + x355)
    x651 = x21 * x382 + x650
    x652 = x21 * x383 + x651
    x653 = x21 * x379 + x55 * (x179 * x578 + x179 * x579)
    x654 = x207 * x551
    x655 = x21 * x388 + x654
    x656 = x21 * x389 + x655
    x657 = x207 * x562 + x21 * x386
    x658 = -x211 * x397 + x394 * x9
    x659 = -x658
    x660 = x6 * x659
    x661 = x211 * x393 - x401 * x9
    x662 = x16 * x661
    x663 = -x4 * x662 + x5 * x659
    x664 = x4 * x663 + x660
    x665 = x56 * x660 + x56 * x664
    x666 = x235 * x660 + x56 * x665
    x667 = x55 * (x239 * x660 + x56 * x666)
    x668 = x22 * x240 + x667
    x669 = x21 * x420 + x668
    x670 = x6 * (-x658 - x662)
    x671 = x211 * x400 - x422 * x560
    x672 = x5 * x663 + x670 - x90 * (x5 * x661 - x671 * x90)
    x673 = x42 * x663
    x674 = x55 * (
        x56 * (x56 * (x56 * (x4 * x672 + x673) + x664 * x68) + x665 * x68) + x666 * x68
    )
    x675 = x22 * x237 + x674
    x676 = x409 + x659 * x9
    x677 = x406 + x663 * x9
    x678 = x56 * x677 + x676 * x95
    x679 = x292 * x676 + x56 * x678
    x680 = x55 * (x56 * x679 + x574 * x676)
    x681 = x22 * x267 + x680
    x682 = x21 * x438 + x681
    x683 = x425 + x672 * x9
    x684 = x677 * x68
    x685 = x55 * (x56 * (x56 * (x56 * x683 + x684) + x678 * x68) + x679 * x68)
    x686 = x22 * x264 + x685
    x687 = x12 * x659 + x229
    x688 = x12 * x663 + x226
    x689 = x56 * x688 + x687 * x95
    x690 = x292 * x687 + x56 * x689
    x691 = x55 * (x56 * x690 + x574 * x687)
    x692 = x22 * x281 + x691
    x693 = x21 * x453 + x692
    x694 = x12 * x672 + x247
    x695 = x68 * x688
    x696 = x55 * (x56 * (x56 * (x56 * x694 + x695) + x68 * x689) + x68 * x690)
    x697 = x22 * x279 + x696
    x698 = x429 + x676 * x97
    x699 = x406 * x97 + x677 * x97
    x700 = x56 * x699 + x698 * x95
    x701 = x55 * (x292 * x698 + x56 * x700)
    x702 = x22 * x293 + x701
    x703 = x21 * x463 + x702
    x704 = x425 * x97 + x683 * x97
    x705 = x68 * x699
    x706 = x55 * (x56 * (x56 * x704 + x705) + x68 * x700)
    x707 = x22 * x290 + x706
    x708 = x445 + x687 * x97
    x709 = x441 * x95 + x688 * x97
    x710 = x56 * x709 + x708 * x95
    x711 = x55 * (x292 * x708 + x56 * x710)
    x712 = x22 * x307 + x711
    x713 = x21 * x473 + x712
    x714 = x440 * x95 + x694 * x97
    x715 = x68 * x709
    x716 = x55 * (x56 * (x56 * x714 + x715) + x68 * x710)
    x717 = x22 * x305 + x716
    x718 = x112 * x687 + x274
    x719 = x112 * x226 + x112 * x688
    x720 = x56 * x719 + x718 * x95
    x721 = x55 * (x292 * x718 + x56 * x720)
    x722 = x22 * x319 + x721
    x723 = x21 * x486 + x722
    x724 = x112 * x247 + x112 * x694
    x725 = x68 * x719
    x726 = x55 * (x56 * (x56 * x724 + x725) + x68 * x720)
    x727 = x22 * x316 + x726
    x728 = x457 + x698 * x97
    x729 = x125 * x406 + x699 * x97
    x730 = x55 * (x56 * x729 + x728 * x95)
    x731 = x22 * x328 + x730
    x732 = x21 * x493 + x731
    x733 = x125 * x425 + x704 * x97
    x734 = x68 * x729
    x735 = x55 * (x56 * x733 + x734)
    x736 = x22 * x325 + x735
    x737 = x467 + x708 * x97
    x738 = x441 * x504 + x709 * x97
    x739 = x55 * (x56 * x738 + x737 * x95)
    x740 = x22 * x338 + x739
    x741 = x21 * x499 + x740
    x742 = x440 * x504 + x714 * x97
    x743 = x68 * x738
    x744 = x55 * (x56 * x742 + x743)
    x745 = x22 * x335 + x744
    x746 = x481 + x718 * x97
    x747 = x477 * x95 + x719 * x97
    x748 = x55 * (x56 * x747 + x746 * x95)
    x749 = x22 * x350 + x748
    x750 = x21 * x507 + x749
    x751 = x476 * x95 + x724 * x97
    x752 = x68 * x747
    x753 = x55 * (x56 * x751 + x752)
    x754 = x22 * x347 + x753
    x755 = x112 * x718 + x314
    x756 = x112 * x719 + x146 * x226
    x757 = x55 * (x56 * x756 + x755 * x95)
    x758 = x22 * x359 + x757
    x759 = x21 * x517 + x758
    x760 = x112 * x724 + x146 * x247
    x761 = x68 * x756
    x762 = x55 * (x56 * x760 + x761)
    x763 = x22 * x356 + x762
    x764 = x55 * (x158 * x406 + x729 * x97)
    x765 = x22 * x364 + x764
    x766 = x21 * x524 + x765
    x767 = x55 * (x158 * x425 + x733 * x97)
    x768 = x22 * x362 + x767
    x769 = x164 * x6
    x770 = x55 * (x441 * x769 + x738 * x97)
    x771 = x22 * x370 + x770
    x772 = x21 * x529 + x771
    x773 = x55 * (x440 * x769 + x742 * x97)
    x774 = x22 * x368 + x773
    x775 = x55 * (x477 * x504 + x747 * x97)
    x776 = x22 * x375 + x775
    x777 = x21 * x534 + x776
    x778 = x55 * (x476 * x504 + x751 * x97)
    x779 = x22 * x373 + x778
    x780 = x55 * (x510 * x95 + x756 * x97)
    x781 = x22 * x382 + x780
    x782 = x21 * x539 + x781
    x783 = x55 * (x509 * x95 + x760 * x97)
    x784 = x22 * x379 + x783
    x785 = x55 * (x112 * x756 + x179 * x226)
    x786 = x22 * x388 + x785
    x787 = x21 * x544 + x786
    x788 = x55 * (x112 * x760 + x179 * x247)
    x789 = x22 * x386 + x788
    x790 = x12 * x394
    x791 = x32 + x391 * x397 - x790
    x792 = x6 * x791
    x793 = -x12 * x401 + x391 * x393 + x43
    x794 = x16 * x793
    x795 = -x4 * x794 + x5 * x791
    x796 = x4 * x795
    x797 = x792 + x796
    x798 = x56 * x792 + x56 * x797
    x799 = x235 * x792 + x56 * x798
    x800 = x55 * (x239 * x792 + x56 * x799)
    x801 = x22 * x418 + x800
    x802 = x22 * x420 + x801
    x803 = x6 * (x391 * x397 - x790 - x794 - x87)
    x804 = x12 * x16
    x805 = x391 * x400 - x422 * x804 + x88
    x806 = x5 * x795 + x803 - x90 * (x5 * x793 - x805 * x90)
    x807 = x4 * x806
    x808 = x6 * x795
    x809 = 2.0 * x808
    x810 = x22 * x416 + x55 * (
        x56 * (x56 * (x56 * (x807 + x809) + x68 * x797) + x68 * x798) + x68 * x799
    )
    x811 = x792 * x97
    x812 = x796 * x97 + x811
    x813 = x432 * x792 + x56 * x812
    x814 = x55 * (x436 * x792 + x56 * x813)
    x815 = x22 * x437 + x814
    x816 = x22 * x438 + x815
    x817 = x22 * x434 + x55 * (
        x56 * (x56 * (x807 * x97 + x809 * x97) + x68 * x812) + x68 * x813
    )
    x818 = x12 * x791 + 2.0 * x409
    x819 = x818 * x95
    x820 = x12 * x795 + x407
    x821 = x56 * x820 + x819
    x822 = x292 * x818 + x56 * x821
    x823 = x55 * (x56 * x822 + x574 * x818)
    x824 = x22 * x452 + x823
    x825 = x22 * x453 + x824
    x826 = x12 * x806 + 2.0 * x425
    x827 = x22 * x449 + x55 * (
        x56 * (x56 * (x56 * x826 + x68 * x820) + x68 * x821) + x68 * x822
    )
    x828 = x125 * x792
    x829 = x125 * x796 + x828
    x830 = x55 * (x461 * x792 + x56 * x829)
    x831 = x22 * x462 + x830
    x832 = x22 * x463 + x831
    x833 = x22 * x459 + x55 * (x56 * (x125 * x807 + x125 * x809) + x68 * x829)
    x834 = x504 * x818
    x835 = x432 * x820 + x834
    x836 = x4 * x818
    x837 = x55 * (x171 * x6 * x836 + x56 * x835)
    x838 = x22 * x472 + x837
    x839 = x22 * x473 + x838
    x840 = x22 * x469 + x55 * (x56 * (x432 * x826 + x501 * x820) + x68 * x835)
    x841 = x112 * x818 + x444 * x68
    x842 = x841 * x95
    x843 = x112 * x820 + x442
    x844 = x56 * x843 + x842
    x845 = x55 * (x292 * x841 + x56 * x844)
    x846 = x22 * x485 + x845
    x847 = x22 * x486 + x846
    x848 = x112 * x826 + x440 * x68
    x849 = x22 * x483 + x55 * (x56 * (x56 * x848 + x68 * x843) + x68 * x844)
    x850 = x158 * x792
    x851 = x55 * (x158 * x796 + x850)
    x852 = x22 * x492 + x851
    x853 = x22 * x493 + x852
    x854 = x22 * x489 + x55 * (x158 * x807 + x158 * x809)
    x855 = x769 * x818
    x856 = x55 * (x461 * x820 + x855)
    x857 = x22 * x498 + x856
    x858 = x22 * x499 + x857
    x859 = x22 * x495 + x55 * (x164 * x42 * x820 + x461 * x826)
    x860 = x504 * x841
    x861 = x55 * (x432 * x843 + x860)
    x862 = x22 * x506 + x861
    x863 = x22 * x507 + x862
    x864 = x22 * x502 + x55 * (x432 * x848 + x501 * x843)
    x865 = x112 * x841 + x480 * x68
    x866 = x865 * x95
    x867 = x112 * x843 + x478
    x868 = x55 * (x56 * x867 + x866)
    x869 = x22 * x516 + x868
    x870 = x22 * x517 + x869
    x871 = x112 * x848 + x476 * x68
    x872 = x22 * x512 + x55 * (x56 * x871 + x68 * x867)
    x873 = x186 * x795
    x874 = x22 * x522 + x873
    x875 = x22 * x524 + x874
    x876 = x186 * x806 + x22 * x520
    x877 = x191 * x820
    x878 = x22 * x528 + x877
    x879 = x22 * x529 + x878
    x880 = x191 * x826 + x22 * x526
    x881 = x164 * x843
    x882 = x22 * x533 + x881
    x883 = x22 * x534 + x882
    x884 = x164 * x848 + x22 * x531
    x885 = x135 * x867
    x886 = x22 * x538 + x885
    x887 = x22 * x539 + x886
    x888 = x135 * x871 + x22 * x536
    x889 = x55 * (x112 * x867 + x511)
    x890 = x22 * x543 + x889
    x891 = x22 * x544 + x890
    x892 = x22 * x541 + x55 * (x112 * x871 + x509 * x68)
    x893 = x211 * x547 + 2.0 * x216 - x550 * x9
    x894 = x6 * x893
    x895 = x211 * x549 + 2.0 * x243 - x560 * x561
    x896 = x5 * x893 - x895 * x90
    x897 = x4 * x896
    x898 = (
        x21 * x556
        + x21 * x557
        + x55
        * (x239 * x894 + x56 * (x235 * x894 + x56 * (x56 * x894 + x56 * (x894 + x897))))
    )
    x899 = x893 * x9
    x900 = 3.0 * x548
    x901 = x899 + x900
    x902 = x901 * x95
    x903 = x896 * x9
    x904 = 3.0 * x564
    x905 = x903 + x904
    x906 = (
        x21 * x575
        + x21 * x576
        + x55 * (x56 * (x292 * x901 + x56 * (x56 * x905 + x902)) + x574 * x901)
    )
    x907 = x112 * x894
    x908 = x12 * x894
    x909 = (
        x21 * x586
        + x21 * x587
        + x55 * (x266 * x908 + x56 * (x261 * x908 + x56 * (x112 * x897 + x907)))
    )
    x910 = x569 * x62 + x901 * x97
    x911 = x910 * x95
    x912 = x571 * x62 + x905 * x97
    x913 = x21 * x593 + x21 * x594 + x55 * (x292 * x910 + x56 * (x56 * x912 + x911))
    x914 = x112 * x899 + x112 * x900
    x915 = x914 * x95
    x916 = x112 * x903 + x112 * x904
    x917 = x21 * x601 + x21 * x602 + x55 * (x292 * x914 + x56 * (x56 * x916 + x915))
    x918 = x146 * x894
    x919 = x21 * x608 + x21 * x609 + x55 * (x318 * x894 + x56 * (x146 * x897 + x918))
    x920 = x590 * x62 + x910 * x97
    x921 = x920 * x95
    x922 = x591 * x62 + x912 * x97
    x923 = x21 * x614 + x21 * x615 + x55 * (x56 * x922 + x921)
    x924 = x598 * x62 + x914 * x97
    x925 = x924 * x95
    x926 = x599 * x62 + x916 * x97
    x927 = x21 * x621 + x21 * x622 + x55 * (x56 * x926 + x925)
    x928 = x146 * x899 + x146 * x900
    x929 = x928 * x95
    x930 = x146 * x903 + x146 * x904
    x931 = x21 * x628 + x21 * x629 + x55 * (x56 * x930 + x929)
    x932 = x179 * x894
    x933 = x21 * x634 + x21 * x635 + x55 * (x179 * x897 + x932)
    x934 = x21 * x638 + x21 * x639 + x55 * (x613 * x62 + x922 * x97)
    x935 = x21 * x642 + x21 * x643 + x55 * (x62 * x620 + x926 * x97)
    x936 = x21 * x646 + x21 * x647 + x55 * (x62 * x627 + x930 * x97)
    x937 = x21 * x650 + x21 * x651 + x55 * (x179 * x903 + x179 * x904)
    x938 = x207 * x896 + x21 * x654 + x21 * x655
    x939 = x211 * x659 + x396 - x662 * x9
    x940 = x6 * x939
    x941 = x211 * x661 + x421 - x560 * x671
    x942 = x5 * x939 - x90 * x941
    x943 = x55 * (
        x239 * x940 + x56 * (x235 * x940 + x56 * (x56 * x940 + x56 * (x4 * x942 + x940)))
    )
    x944 = x21 * x668 + x22 * x556 + x943
    x945 = 2.0 * x660
    x946 = x9 * x939 + x945
    x947 = x673 + x9 * x942
    x948 = x55 * (x56 * (x292 * x946 + x56 * (x56 * x947 + x946 * x95)) + x574 * x946)
    x949 = x21 * x681 + x22 * x575 + x948
    x950 = x12 * x939 + x548
    x951 = x12 * x942 + x564
    x952 = x55 * (x56 * (x292 * x950 + x56 * (x56 * x951 + x95 * x950)) + x574 * x950)
    x953 = x21 * x692 + x22 * x586 + x952
    x954 = x676 * x68 + x946 * x97
    x955 = x684 + x947 * x97
    x956 = x55 * (x292 * x954 + x56 * (x56 * x955 + x95 * x954))
    x957 = x21 * x702 + x22 * x593 + x956
    x958 = x68 * x687
    x959 = x950 * x97 + x958
    x960 = x695 + x951 * x97
    x961 = x55 * (x292 * x959 + x56 * (x56 * x960 + x95 * x959))
    x962 = x21 * x712 + x22 * x601 + x961
    x963 = x112 * x950 + x582
    x964 = x112 * x564 + x112 * x951
    x965 = x55 * (x292 * x963 + x56 * (x56 * x964 + x95 * x963))
    x966 = x21 * x722 + x22 * x608 + x965
    x967 = x68 * x698 + x954 * x97
    x968 = x705 + x955 * x97
    x969 = x55 * (x56 * x968 + x95 * x967)
    x970 = x21 * x731 + x22 * x614 + x969
    x971 = x68 * x708 + x959 * x97
    x972 = x715 + x960 * x97
    x973 = x55 * (x56 * x972 + x95 * x971)
    x974 = x21 * x740 + x22 * x621 + x973
    x975 = x68 * x718
    x976 = x963 * x97 + x975
    x977 = x725 + x964 * x97
    x978 = x55 * (x56 * x977 + x95 * x976)
    x979 = x21 * x749 + x22 * x628 + x978
    x980 = x112 * x963 + x606
    x981 = x112 * x964 + x146 * x564
    x982 = x55 * (x56 * x981 + x95 * x980)
    x983 = x21 * x758 + x22 * x634 + x982
    x984 = x55 * (x734 + x968 * x97)
    x985 = x21 * x765 + x22 * x638 + x984
    x986 = x55 * (x743 + x97 * x972)
    x987 = x21 * x771 + x22 * x642 + x986
    x988 = x55 * (x752 + x97 * x977)
    x989 = x21 * x776 + x22 * x646 + x988
    x990 = x55 * (x761 + x97 * x981)
    x991 = x21 * x781 + x22 * x650 + x990
    x992 = x55 * (x112 * x981 + x179 * x564)
    x993 = x21 * x786 + x22 * x654 + x992
    x994 = x211 * x791 - x794 * x9
    x995 = x6 * x994
    x996 = x211 * x793 - x560 * x805
    x997 = x5 * x994 - x90 * x996
    x998 = x22 * x667 + x55 * (
        x239 * x995 + x56 * (x235 * x995 + x56 * (x56 * x995 + x56 * (x4 * x997 + x995)))
    )
    x999 = x22 * x668 + x998
    x1000 = x792 + x9 * x994
    x1001 = x808 + x9 * x997
    x1002 = x22 * x680 + x55 * (
        x1000 * x574 + x56 * (x1000 * x292 + x56 * (x1000 * x95 + x1001 * x56))
    )
    x1003 = x1002 + x22 * x681
    x1004 = x12 * x994 + x945
    x1005 = x12 * x997 + x673
    x1006 = x22 * x691 + x55 * (
        x1004 * x574 + x56 * (x1004 * x292 + x56 * (x1004 * x95 + x1005 * x56))
    )
    x1007 = x1006 + x22 * x692
    x1008 = x1000 * x97 + x811
    x1009 = x1001 * x97 + x808 * x97
    x1010 = x22 * x701 + x55 * (x1008 * x292 + x56 * (x1008 * x95 + x1009 * x56))
    x1011 = x1010 + x22 * x702
    x1012 = x1004 * x97 + x819
    x1013 = x1005 * x97 + x820 * x95
    x1014 = x22 * x711 + x55 * (x1012 * x292 + x56 * (x1012 * x95 + x1013 * x56))
    x1015 = x1014 + x22 * x712
    x1016 = x1004 * x112 + x958
    x1017 = x1005 * x112 + x695
    x1018 = x22 * x721 + x55 * (x1016 * x292 + x56 * (x1016 * x95 + x1017 * x56))
    x1019 = x1018 + x22 * x722
    x1020 = x1008 * x97 + x828
    x1021 = x1009 * x97 + x125 * x808
    x1022 = x22 * x730 + x55 * (x1020 * x95 + x1021 * x56)
    x1023 = x1022 + x22 * x731
    x1024 = x1012 * x97 + x834
    x1025 = x1013 * x97 + x504 * x820
    x1026 = x22 * x739 + x55 * (x1024 * x95 + x1025 * x56)
    x1027 = x1026 + x22 * x740
    x1028 = x1016 * x97 + x842
    x1029 = x1017 * x97 + x843 * x95
    x1030 = x22 * x748 + x55 * (x1028 * x95 + x1029 * x56)
    x1031 = x1030 + x22 * x749
    x1032 = x1016 * x112 + x975
    x1033 = x1017 * x112 + x725
    x1034 = x22 * x757 + x55 * (x1032 * x95 + x1033 * x56)
    x1035 = x1034 + x22 * x758
    x1036 = x22 * x764 + x55 * (x1021 * x97 + x158 * x808)
    x1037 = x1036 + x22 * x765
    x1038 = x22 * x770 + x55 * (x1025 * x97 + x769 * x820)
    x1039 = x1038 + x22 * x771
    x1040 = x22 * x775 + x55 * (x1029 * x97 + x504 * x843)
    x1041 = x1040 + x22 * x776
    x1042 = x22 * x780 + x55 * (x1033 * x97 + x867 * x95)
    x1043 = x1042 + x22 * x781
    x1044 = x22 * x785 + x55 * (x1033 * x112 + x761)
    x1045 = x1044 + x22 * x786
    x1046 = -x12 * x794 + x391 * x791 + 2.0 * x396
    x1047 = x1046 * x6
    x1048 = x391 * x793 + 2.0 * x421 - x804 * x805
    x1049 = x1046 * x5 - x1048 * x90
    x1050 = x1049 * x4
    x1051 = (
        x22 * x800
        + x22 * x801
        + x55
        * (
            x1047 * x239
            + x56 * (x1047 * x235 + x56 * (x1047 * x56 + x56 * (x1047 + x1050)))
        )
    )
    x1052 = x1047 * x97
    x1053 = (
        x22 * x814
        + x22 * x815
        + x55 * (x1047 * x436 + x56 * (x1047 * x432 + x56 * (x1050 * x97 + x1052)))
    )
    x1054 = x1046 * x12 + 3.0 * x792
    x1055 = x1054 * x95
    x1056 = x1049 * x12 + 3.0 * x808
    x1057 = (
        x22 * x823
        + x22 * x824
        + x55 * (x1054 * x574 + x56 * (x1054 * x292 + x56 * (x1055 + x1056 * x56)))
    )
    x1058 = x1047 * x125
    x1059 = x22 * x830 + x22 * x831 + x55 * (x1047 * x461 + x56 * (x1050 * x125 + x1058))
    x1060 = x1054 * x504
    x1061 = (
        x22 * x837 + x22 * x838 + x55 * (x1054 * x471 * x6 + x56 * (x1056 * x432 + x1060))
    )
    x1062 = x1054 * x112 + x62 * x818
    x1063 = x1062 * x95
    x1064 = x1056 * x112 + x62 * x820
    x1065 = x22 * x845 + x22 * x846 + x55 * (x1062 * x292 + x56 * (x1063 + x1064 * x56))
    x1066 = x1047 * x158
    x1067 = x22 * x851 + x22 * x852 + x55 * (x1050 * x158 + x1066)
    x1068 = x1054 * x769
    x1069 = x22 * x856 + x22 * x857 + x55 * (x1056 * x461 + x1068)
    x1070 = x1062 * x504
    x1071 = x22 * x861 + x22 * x862 + x55 * (x1064 * x432 + x1070)
    x1072 = x1062 * x112 + x62 * x841
    x1073 = x1072 * x95
    x1074 = x1064 * x112 + x62 * x843
    x1075 = x22 * x868 + x22 * x869 + x55 * (x1073 + x1074 * x56)
    x1076 = x1049 * x186 + x22 * x873 + x22 * x874
    x1077 = x1056 * x191 + x22 * x877 + x22 * x878
    x1078 = x1064 * x164 + x22 * x881 + x22 * x882
    x1079 = x1074 * x135 + x22 * x885 + x22 * x886
    x1080 = x22 * x889 + x22 * x890 + x55 * (x1074 * x112 + x62 * x867)
    x1081 = x0 * x240 + x237
    x1082 = x185 * x4**4
    x1083 = x0 * x217
    x1084 = x0 * x267 + x264
    x1085 = x185 * x81
    x1086 = x1085 * x257
    x1087 = x0 * x281 + x279
    x1088 = x1085 * x12
    x1089 = x0 * x293 + x290
    x1090 = x0 * x266
    x1091 = x0 * x307 + x305
    x1092 = x0 * x319 + x316
    x1093 = x13 * x7
    x1094 = x1083 * x185
    x1095 = x0 * x328 + x325
    x1096 = x0 * x261
    x1097 = x0 * x338 + x335
    x1098 = x0 * x350 + x347
    x1099 = x0 * x359 + x356
    x1100 = x178 * x4
    x1101 = x0 * x364 + x362
    x1102 = x162 + x327 * x97
    x1103 = x0 * x370 + x368
    x1104 = x169 + x337 * x97
    x1105 = x0 * x375 + x373
    x1106 = x176 + x349 * x97
    x1107 = x0 * x382 + x379
    x1108 = x179 * x256 + x183
    x1109 = x0 * x388 + x386
    x1110 = x1082 * x547
    x1111 = x21 * x217
    x1112 = x1082 * x1111 + x1110
    x1113 = x1085 * x569
    x1114 = x1086 * x21 + x1113
    x1115 = x1088 * x547
    x1116 = x1088 * x1111 + x1115
    x1117 = x266 * x590
    x1118 = x21 * x266
    x1119 = x1117 + x1118 * x288
    x1120 = x266 * x598
    x1121 = x1118 * x303 + x1120
    x1122 = x185 * x547
    x1123 = x1093 * x1122
    x1124 = x1111 * x185
    x1125 = x1093 * x1124 + x1123
    x1126 = x261 * x612
    x1127 = x21 * x261
    x1128 = x1126 + x1127 * x327
    x1129 = x261 * x619
    x1130 = x1127 * x337 + x1129
    x1131 = x261 * x626
    x1132 = x1127 * x349 + x1131
    x1133 = x1100 * x1122
    x1134 = x1100 * x1124 + x1133
    x1135 = x55 * (x327 * x68 + x612 * x97)
    x1136 = x1102 * x241 + x1135
    x1137 = x55 * (x337 * x68 + x619 * x97)
    x1138 = x1104 * x241 + x1137
    x1139 = x55 * (x349 * x68 + x626 * x97)
    x1140 = x1106 * x241 + x1139
    x1141 = x55 * (x179 * x567 + x179 * x568)
    x1142 = x1108 * x241 + x1141
    x1143 = x207 * x547
    x1144 = x1111 * x207 + x1143
    x1145 = x1082 * x659
    x1146 = x217 * x22
    x1147 = x1082 * x1146 + x1145
    x1148 = x1085 * x676
    x1149 = x1086 * x22 + x1148
    x1150 = x1085 * x687
    x1151 = x1088 * x1146 + x1150
    x1152 = x266 * x698
    x1153 = x22 * x266
    x1154 = x1152 + x1153 * x288
    x1155 = x266 * x708
    x1156 = x1153 * x303 + x1155
    x1157 = x266 * x718
    x1158 = x1146 * x185
    x1159 = x1093 * x1158 + x1157
    x1160 = x261 * x728
    x1161 = x22 * x261
    x1162 = x1160 + x1161 * x327
    x1163 = x261 * x737
    x1164 = x1161 * x337 + x1163
    x1165 = x261 * x746
    x1166 = x1161 * x349 + x1165
    x1167 = x261 * x755
    x1168 = x1100 * x1158 + x1167
    x1169 = x55 * (x491 + x728 * x97)
    x1170 = x1102 * x419 + x1169
    x1171 = x55 * (x497 + x737 * x97)
    x1172 = x1104 * x419 + x1171
    x1173 = x55 * (x505 + x746 * x97)
    x1174 = x1106 * x419 + x1173
    x1175 = x55 * (x515 + x755 * x97)
    x1176 = x1108 * x419 + x1175
    x1177 = x55 * (x112 * x755 + x358)
    x1178 = x1146 * x207 + x1177
    x1179 = x1082 * x893
    x1180 = x1110 * x21 + x1179
    x1181 = x1112 * x21 + x1180
    x1182 = x1085 * x901
    x1183 = x1113 * x21 + x1182
    x1184 = x1114 * x21 + x1183
    x1185 = x1088 * x893
    x1186 = x1115 * x21 + x1185
    x1187 = x1116 * x21 + x1186
    x1188 = x266 * x910
    x1189 = x1117 * x21 + x1188
    x1190 = x1119 * x21 + x1189
    x1191 = x266 * x914
    x1192 = x1120 * x21 + x1191
    x1193 = x1121 * x21 + x1192
    x1194 = x185 * x893
    x1195 = x1093 * x1194
    x1196 = x1123 * x21 + x1195
    x1197 = x1125 * x21 + x1196
    x1198 = x261 * x920
    x1199 = x1126 * x21 + x1198
    x1200 = x1128 * x21 + x1199
    x1201 = x261 * x924
    x1202 = x1129 * x21 + x1201
    x1203 = x1130 * x21 + x1202
    x1204 = x261 * x928
    x1205 = x1131 * x21 + x1204
    x1206 = x1132 * x21 + x1205
    x1207 = x1100 * x1194
    x1208 = x1133 * x21 + x1207
    x1209 = x1134 * x21 + x1208
    x1210 = x55 * (x612 * x62 + x920 * x97)
    x1211 = x1135 * x21 + x1210
    x1212 = x1136 * x21 + x1211
    x1213 = x55 * (x619 * x62 + x924 * x97)
    x1214 = x1137 * x21 + x1213
    x1215 = x1138 * x21 + x1214
    x1216 = x55 * (x62 * x626 + x928 * x97)
    x1217 = x1139 * x21 + x1216
    x1218 = x1140 * x21 + x1217
    x1219 = x55 * (x179 * x899 + x179 * x900)
    x1220 = x1141 * x21 + x1219
    x1221 = x1142 * x21 + x1220
    x1222 = x207 * x893
    x1223 = x1143 * x21 + x1222
    x1224 = x1144 * x21 + x1223
    x1225 = x1082 * x939
    x1226 = x1110 * x22 + x1225
    x1227 = x1147 * x21 + x1226
    x1228 = x1085 * x946
    x1229 = x1113 * x22 + x1228
    x1230 = x1149 * x21 + x1229
    x1231 = x1085 * x950
    x1232 = x1115 * x22 + x1231
    x1233 = x1151 * x21 + x1232
    x1234 = x266 * x954
    x1235 = x1117 * x22 + x1234
    x1236 = x1154 * x21 + x1235
    x1237 = x266 * x959
    x1238 = x1120 * x22 + x1237
    x1239 = x1156 * x21 + x1238
    x1240 = x266 * x963
    x1241 = x1123 * x22 + x1240
    x1242 = x1159 * x21 + x1241
    x1243 = x261 * x967
    x1244 = x1126 * x22 + x1243
    x1245 = x1162 * x21 + x1244
    x1246 = x261 * x971
    x1247 = x1129 * x22 + x1246
    x1248 = x1164 * x21 + x1247
    x1249 = x261 * x976
    x1250 = x1131 * x22 + x1249
    x1251 = x1166 * x21 + x1250
    x1252 = x261 * x980
    x1253 = x1133 * x22 + x1252
    x1254 = x1168 * x21 + x1253
    x1255 = x55 * (x68 * x728 + x967 * x97)
    x1256 = x1135 * x22 + x1255
    x1257 = x1170 * x21 + x1256
    x1258 = x55 * (x68 * x737 + x97 * x971)
    x1259 = x1137 * x22 + x1258
    x1260 = x1172 * x21 + x1259
    x1261 = x55 * (x68 * x746 + x97 * x976)
    x1262 = x1139 * x22 + x1261
    x1263 = x1174 * x21 + x1262
    x1264 = x68 * x755
    x1265 = x55 * (x1264 + x97 * x980)
    x1266 = x1141 * x22 + x1265
    x1267 = x1176 * x21 + x1266
    x1268 = x55 * (x112 * x980 + x633)
    x1269 = x1143 * x22 + x1268
    x1270 = x1178 * x21 + x1269
    x1271 = x1082 * x994
    x1272 = x1145 * x22 + x1271
    x1273 = x1147 * x22 + x1272
    x1274 = x1000 * x1085
    x1275 = x1148 * x22 + x1274
    x1276 = x1149 * x22 + x1275
    x1277 = x1004 * x1085
    x1278 = x1150 * x22 + x1277
    x1279 = x1151 * x22 + x1278
    x1280 = x1008 * x266
    x1281 = x1152 * x22 + x1280
    x1282 = x1154 * x22 + x1281
    x1283 = x1012 * x266
    x1284 = x1155 * x22 + x1283
    x1285 = x1156 * x22 + x1284
    x1286 = x1016 * x266
    x1287 = x1157 * x22 + x1286
    x1288 = x1159 * x22 + x1287
    x1289 = x1020 * x261
    x1290 = x1160 * x22 + x1289
    x1291 = x1162 * x22 + x1290
    x1292 = x1024 * x261
    x1293 = x1163 * x22 + x1292
    x1294 = x1164 * x22 + x1293
    x1295 = x1028 * x261
    x1296 = x1165 * x22 + x1295
    x1297 = x1166 * x22 + x1296
    x1298 = x1032 * x261
    x1299 = x1167 * x22 + x1298
    x1300 = x1168 * x22 + x1299
    x1301 = x55 * (x1020 * x97 + x850)
    x1302 = x1169 * x22 + x1301
    x1303 = x1170 * x22 + x1302
    x1304 = x55 * (x1024 * x97 + x855)
    x1305 = x1171 * x22 + x1304
    x1306 = x1172 * x22 + x1305
    x1307 = x55 * (x1028 * x97 + x860)
    x1308 = x1173 * x22 + x1307
    x1309 = x1174 * x22 + x1308
    x1310 = x55 * (x1032 * x97 + x866)
    x1311 = x1175 * x22 + x1310
    x1312 = x1176 * x22 + x1311
    x1313 = x55 * (x1032 * x112 + x1264)
    x1314 = x1177 * x22 + x1313
    x1315 = x1178 * x22 + x1314
    x1316 = x211 * x893 + 3.0 * x559 - x560 * x895
    x1317 = x1316 * x9
    x1318 = 4.0 * x894
    x1319 = x1317 + x1318
    x1320 = x1319 * x97 + 4.0 * x902
    x1321 = x112 * x1317 + x112 * x1318
    x1322 = x1316 * x185
    x1323 = x1320 * x97 + 4.0 * x911
    x1324 = x1321 * x97 + 4.0 * x915
    x1325 = x1317 * x146 + x1318 * x146
    x1326 = x211 * x939 - x560 * x941 + 2.0 * x670
    x1327 = x1082 * x1326
    x1328 = x1326 * x9 + 3.0 * x940
    x1329 = x1085 * x1328
    x1330 = x12 * x1326 + x894
    x1331 = x1085 * x1330
    x1332 = x1328 * x97 + x62 * x946
    x1333 = x1332 * x266
    x1334 = x1330 * x97 + x62 * x950
    x1335 = x1334 * x266
    x1336 = x112 * x1330 + x907
    x1337 = x1336 * x266
    x1338 = x1332 * x97 + x62 * x954
    x1339 = x1338 * x261
    x1340 = x1334 * x97 + x62 * x959
    x1341 = x1340 * x261
    x1342 = x1336 * x97 + x62 * x963
    x1343 = x1342 * x261
    x1344 = x112 * x1336 + x918
    x1345 = x1344 * x261
    x1346 = x55 * (x1338 * x97 + x62 * x967)
    x1347 = x55 * (x1340 * x97 + x62 * x971)
    x1348 = x55 * (x1342 * x97 + x62 * x976)
    x1349 = x55 * (x1344 * x97 + x62 * x980)
    x1350 = x55 * (x112 * x1344 + x932)
    x1351 = x211 * x994 - x560 * x996 + x803
    x1352 = x1082 * x1351 + x1225 * x22
    x1353 = x1351 * x9 + 2.0 * x995
    x1354 = x1085 * x1353 + x1228 * x22
    x1355 = x12 * x1351 + 2.0 * x940
    x1356 = x1085 * x1355 + x1231 * x22
    x1357 = x1000 * x68 + x1353 * x97
    x1358 = x1234 * x22 + x1357 * x266
    x1359 = x1004 * x68 + x1355 * x97
    x1360 = x1237 * x22 + x1359 * x266
    x1361 = x112 * x1355 + x68 * x950
    x1362 = x1240 * x22 + x1361 * x266
    x1363 = x1008 * x68 + x1357 * x97
    x1364 = x1243 * x22 + x1363 * x261
    x1365 = x1012 * x68 + x1359 * x97
    x1366 = x1246 * x22 + x1365 * x261
    x1367 = x1016 * x68 + x1361 * x97
    x1368 = x1249 * x22 + x1367 * x261
    x1369 = x112 * x1361 + x68 * x963
    x1370 = x1252 * x22 + x1369 * x261
    x1371 = x1255 * x22 + x55 * (x1020 * x68 + x1363 * x97)
    x1372 = x1258 * x22 + x55 * (x1024 * x68 + x1365 * x97)
    x1373 = x1261 * x22 + x55 * (x1028 * x68 + x1367 * x97)
    x1374 = x1265 * x22 + x55 * (x1032 * x68 + x1369 * x97)
    x1375 = x1268 * x22 + x55 * (x112 * x1369 + x68 * x980)
    x1376 = x1046 * x211 - x1048 * x560
    x1377 = x1082 * x1376 + x1271 * x22 + x1272 * x22
    x1378 = x1047 + x1376 * x9
    x1379 = x1085 * x1378 + x1274 * x22 + x1275 * x22
    x1380 = x12 * x1376 + 3.0 * x995
    x1381 = x1085 * x1380 + x1277 * x22 + x1278 * x22
    x1382 = x1052 + x1378 * x97
    x1383 = x1280 * x22 + x1281 * x22 + x1382 * x266
    x1384 = x1055 + x1380 * x97
    x1385 = x1283 * x22 + x1284 * x22 + x1384 * x266
    x1386 = x1004 * x62 + x112 * x1380
    x1387 = x1286 * x22 + x1287 * x22 + x1386 * x266
    x1388 = x1058 + x1382 * x97
    x1389 = x1289 * x22 + x1290 * x22 + x1388 * x261
    x1390 = x1060 + x1384 * x97
    x1391 = x1292 * x22 + x1293 * x22 + x1390 * x261
    x1392 = x1063 + x1386 * x97
    x1393 = x1295 * x22 + x1296 * x22 + x1392 * x261
    x1394 = x1016 * x62 + x112 * x1386
    x1395 = x1298 * x22 + x1299 * x22 + x1394 * x261
    x1396 = x1301 * x22 + x1302 * x22 + x55 * (x1066 + x1388 * x97)
    x1397 = x1304 * x22 + x1305 * x22 + x55 * (x1068 + x1390 * x97)
    x1398 = x1307 * x22 + x1308 * x22 + x55 * (x1070 + x1392 * x97)
    x1399 = x1310 * x22 + x1311 * x22 + x55 * (x1073 + x1394 * x97)
    x1400 = x1313 * x22 + x1314 * x22 + x55 * (x1032 * x62 + x112 * x1394)
    x1401 = x0 * x418 + x416
    x1402 = x0 * x397
    x1403 = x0 * x437 + x434
    x1404 = x1085 * x9
    x1405 = x0 * x452 + x449
    x1406 = x0 * x444
    x1407 = x0 * x462 + x459
    x1408 = x185 * x7
    x1409 = x10 * x1408
    x1410 = x0 * x472 + x469
    x1411 = x1408 * x9
    x1412 = x0 * x485 + x483
    x1413 = x0 * x492 + x489
    x1414 = x191 * x4
    x1415 = x0 * x498 + x495
    x1416 = x10 * x185
    x1417 = x1416 * x4
    x1418 = x0 * x506 + x502
    x1419 = x471 * x480
    x1420 = x0 * x516 + x512
    x1421 = x0 * x522 + x520
    x1422 = x0 * x528 + x526
    x1423 = x0 * x533 + x531
    x1424 = x164 * x480
    x1425 = x0 * x538 + x536
    x1426 = x135 * x514
    x1427 = x0 * x543 + x541
    x1428 = x112 * x514 + x183
    x1429 = x21 * x418 + x667
    x1430 = x21 * x397
    x1431 = x1082 * x1430 + x1145
    x1432 = x21 * x437 + x680
    x1433 = x1148 + x1404 * x1430
    x1434 = x21 * x452 + x691
    x1435 = x21 * x444
    x1436 = x1085 * x1435 + x1150
    x1437 = x21 * x462 + x701
    x1438 = x1152 + x1409 * x1430
    x1439 = x21 * x472 + x711
    x1440 = x1155 + x1411 * x1435
    x1441 = x21 * x485 + x721
    x1442 = x1118 * x480 + x1157
    x1443 = x21 * x492 + x730
    x1444 = x1160 + x1414 * x1430
    x1445 = x21 * x498 + x739
    x1446 = x1163 + x1417 * x1435
    x1447 = x21 * x506 + x748
    x1448 = x1165 + x1419 * x21
    x1449 = x21 * x516 + x757
    x1450 = x1127 * x514 + x1167
    x1451 = x21 * x522 + x764
    x1452 = x1169 + x1430 * x186
    x1453 = x21 * x528 + x770
    x1454 = x1171 + x1435 * x191
    x1455 = x21 * x533 + x775
    x1456 = x1173 + x1424 * x21
    x1457 = x21 * x538 + x780
    x1458 = x1175 + x1426 * x21
    x1459 = x21 * x543 + x785
    x1460 = x1177 + x1428 * x241
    x1461 = x1082 * x791
    x1462 = x22 * x397
    x1463 = x1082 * x1462 + x1461
    x1464 = x1404 * x791
    x1465 = x1404 * x1462 + x1464
    x1466 = x1085 * x818
    x1467 = x22 * x444
    x1468 = x1085 * x1467 + x1466
    x1469 = x1409 * x791
    x1470 = x1409 * x1462 + x1469
    x1471 = x1411 * x818
    x1472 = x1411 * x1467 + x1471
    x1473 = x266 * x841
    x1474 = x1153 * x480 + x1473
    x1475 = x1414 * x791
    x1476 = x1414 * x1462 + x1475
    x1477 = x1416 * x836
    x1478 = x1417 * x1467 + x1477
    x1479 = x471 * x841
    x1480 = x1419 * x22 + x1479
    x1481 = x261 * x865
    x1482 = x1161 * x514 + x1481
    x1483 = x186 * x791
    x1484 = x1462 * x186 + x1483
    x1485 = x191 * x818
    x1486 = x1467 * x191 + x1485
    x1487 = x164 * x841
    x1488 = x1424 * x22 + x1487
    x1489 = x135 * x865
    x1490 = x1426 * x22 + x1489
    x1491 = x55 * (x112 * x865 + x514 * x68)
    x1492 = x1428 * x419 + x1491
    x1493 = x1145 * x21 + x1225
    x1494 = x1431 * x21 + x1493
    x1495 = x1148 * x21 + x1228
    x1496 = x1433 * x21 + x1495
    x1497 = x1150 * x21 + x1231
    x1498 = x1436 * x21 + x1497
    x1499 = x1152 * x21 + x1234
    x1500 = x1438 * x21 + x1499
    x1501 = x1155 * x21 + x1237
    x1502 = x1440 * x21 + x1501
    x1503 = x1157 * x21 + x1240
    x1504 = x1442 * x21 + x1503
    x1505 = x1160 * x21 + x1243
    x1506 = x1444 * x21 + x1505
    x1507 = x1163 * x21 + x1246
    x1508 = x1446 * x21 + x1507
    x1509 = x1165 * x21 + x1249
    x1510 = x1448 * x21 + x1509
    x1511 = x1167 * x21 + x1252
    x1512 = x1450 * x21 + x1511
    x1513 = x1169 * x21 + x1255
    x1514 = x1452 * x21 + x1513
    x1515 = x1171 * x21 + x1258
    x1516 = x1454 * x21 + x1515
    x1517 = x1173 * x21 + x1261
    x1518 = x1456 * x21 + x1517
    x1519 = x1175 * x21 + x1265
    x1520 = x1458 * x21 + x1519
    x1521 = x1177 * x21 + x1268
    x1522 = x1460 * x21 + x1521
    x1523 = x1272 + x1463 * x21
    x1524 = x1275 + x1465 * x21
    x1525 = x1278 + x1468 * x21
    x1526 = x1281 + x1470 * x21
    x1527 = x1284 + x1472 * x21
    x1528 = x1287 + x1474 * x21
    x1529 = x1290 + x1476 * x21
    x1530 = x1293 + x1478 * x21
    x1531 = x1296 + x1480 * x21
    x1532 = x1299 + x1482 * x21
    x1533 = x1302 + x1484 * x21
    x1534 = x1305 + x1486 * x21
    x1535 = x1308 + x1488 * x21
    x1536 = x1311 + x1490 * x21
    x1537 = x1314 + x1492 * x21
    x1538 = x1046 * x1082
    x1539 = x1461 * x22 + x1538
    x1540 = x1463 * x22 + x1539
    x1541 = x1046 * x1404
    x1542 = x1464 * x22 + x1541
    x1543 = x1465 * x22 + x1542
    x1544 = x1054 * x1085
    x1545 = x1466 * x22 + x1544
    x1546 = x1468 * x22 + x1545
    x1547 = x1046 * x1409
    x1548 = x1469 * x22 + x1547
    x1549 = x1470 * x22 + x1548
    x1550 = x1054 * x1411
    x1551 = x1471 * x22 + x1550
    x1552 = x1472 * x22 + x1551
    x1553 = x1062 * x266
    x1554 = x1473 * x22 + x1553
    x1555 = x1474 * x22 + x1554
    x1556 = x1046 * x1414
    x1557 = x1475 * x22 + x1556
    x1558 = x1476 * x22 + x1557
    x1559 = x1054 * x1417
    x1560 = x1477 * x22 + x1559
    x1561 = x1478 * x22 + x1560
    x1562 = x1062 * x471
    x1563 = x1479 * x22 + x1562
    x1564 = x1480 * x22 + x1563
    x1565 = x1072 * x261
    x1566 = x1481 * x22 + x1565
    x1567 = x1482 * x22 + x1566
    x1568 = x1046 * x186
    x1569 = x1483 * x22 + x1568
    x1570 = x1484 * x22 + x1569
    x1571 = x1054 * x191
    x1572 = x1485 * x22 + x1571
    x1573 = x1486 * x22 + x1572
    x1574 = x1062 * x164
    x1575 = x1487 * x22 + x1574
    x1576 = x1488 * x22 + x1575
    x1577 = x1072 * x135
    x1578 = x1489 * x22 + x1577
    x1579 = x1490 * x22 + x1578
    x1580 = x55 * (x1072 * x112 + x62 * x865)
    x1581 = x1491 * x22 + x1580
    x1582 = x1492 * x22 + x1581
    x1583 = x1046 * x391 - x1048 * x804 + 3.0 * x803
    x1584 = 4.0 * x1047 + x12 * x1583
    x1585 = 4.0 * x1055 + x112 * x1584
    x1586 = 4.0 * x1063 + x112 * x1585

    # 450 item(s)
    return numpy.array(
        [
            x0 * x75
            + x0 * x80
            + x0 * (x0 * (x79 + x85 * x86) + x80)
            + x55
            * (x56 * (x56 * (x54 * x96 + x56 * (x92 + x94)) + x63 * x96) + x70 * x96),
            x0 * x104
            + x0 * x109
            + x0 * (x0 * (x108 + x111 * x86) + x109)
            + x55 * (x100 * x96 + x56 * (x56 * (x92 * x97 + x94 * x97) + x96 * x98)),
            x0 * x119
            + x0 * x122
            + x0 * (x0 * (x121 + x123 * x86) + x122)
            + x55 * (x115 * x96 + x56 * (x113 * x96 + x56 * (x112 * x92 + x112 * x94))),
            x0 * x128
            + x0 * x132
            + x0 * (x0 * (x131 + x134 * x86) + x132)
            + x55 * (x126 * x96 + x56 * (x125 * x92 + x125 * x94)),
            x0 * x139
            + x0 * x144
            + x0 * (x0 * (x143 + x145 * x86) + x144)
            + x55 * (x137 * x96 + x56 * (x136 * x92 + x136 * x94)),
            x0 * x149
            + x0 * x153
            + x0 * (x0 * (x152 + x155 * x86) + x153)
            + x55 * (x147 * x96 + x56 * (x146 * x92 + x146 * x94)),
            x0 * x159
            + x0 * x161
            + x0 * (x0 * (x160 + x163 * x86) + x161)
            + x55 * (x158 * x92 + x158 * x94),
            x0 * x166
            + x0 * x168
            + x0 * (x0 * (x167 + x170 * x86) + x168)
            + x55 * (x165 * x92 + x165 * x94),
            x0 * x173
            + x0 * x175
            + x0 * (x0 * (x174 + x177 * x86) + x175)
            + x55 * (x172 * x92 + x172 * x94),
            x0 * x180
            + x0 * x182
            + x0 * (x0 * (x181 + x184 * x86) + x182)
            + x55 * (x179 * x92 + x179 * x94),
            x0 * x187 + x0 * x189 + x0 * (x0 * (x186 * x190 + x188) + x189) + x186 * x91,
            x0 * x193 + x0 * x195 + x0 * (x0 * (x190 * x192 + x194) + x195) + x192 * x91,
            x0 * x198 + x0 * x201 + x0 * (x0 * (x190 * x199 + x200) + x201) + x199 * x91,
            x0 * x203 + x0 * x206 + x0 * (x0 * (x190 * x204 + x205) + x206) + x204 * x91,
            x0 * x208 + x0 * x210 + x0 * (x0 * (x190 * x207 + x209) + x210) + x207 * x91,
            x0 * x238 + x0 * (x0 * x242 + x238) + x21 * x75 + x249,
            x0 * x265 + x0 * (x0 * x268 + x265) + x104 * x21 + x271,
            x0 * x280 + x0 * (x0 * x282 + x280) + x119 * x21 + x283,
            x0 * x291 + x0 * (x0 * x294 + x291) + x128 * x21 + x296,
            x0 * x306 + x0 * (x0 * x308 + x306) + x139 * x21 + x311,
            x0 * x317 + x0 * (x0 * x320 + x317) + x149 * x21 + x321,
            x0 * x326 + x0 * (x0 * x329 + x326) + x159 * x21 + x331,
            x0 * x336 + x0 * (x0 * x339 + x336) + x166 * x21 + x341,
            x0 * x348 + x0 * (x0 * x351 + x348) + x173 * x21 + x354,
            x0 * x357 + x0 * (x0 * x360 + x357) + x180 * x21 + x361,
            x0 * x363 + x0 * (x0 * x366 + x363) + x187 * x21 + x367,
            x0 * x369 + x0 * (x0 * x371 + x369) + x193 * x21 + x372,
            x0 * x374 + x0 * (x0 * x376 + x374) + x198 * x21 + x377,
            x0 * x380 + x0 * (x0 * x383 + x380) + x203 * x21 + x385,
            x0 * x387 + x0 * (x0 * x389 + x387) + x208 * x21 + x390,
            x0 * x417 + x0 * (x0 * x420 + x417) + x22 * x75 + x427,
            x0 * x435 + x0 * (x0 * x438 + x435) + x104 * x22 + x439,
            x0 * x450 + x0 * (x0 * x453 + x450) + x119 * x22 + x455,
            x0 * x460 + x0 * (x0 * x463 + x460) + x128 * x22 + x464,
            x0 * x470 + x0 * (x0 * x473 + x470) + x139 * x22 + x475,
            x0 * x484 + x0 * (x0 * x486 + x484) + x149 * x22 + x488,
            x0 * x490 + x0 * (x0 * x493 + x490) + x159 * x22 + x494,
            x0 * x496 + x0 * (x0 * x499 + x496) + x166 * x22 + x500,
            x0 * x503 + x0 * (x0 * x507 + x503) + x173 * x22 + x508,
            x0 * x513 + x0 * (x0 * x517 + x513) + x180 * x22 + x519,
            x0 * x521 + x0 * (x0 * x524 + x521) + x187 * x22 + x525,
            x0 * x527 + x0 * (x0 * x529 + x527) + x193 * x22 + x530,
            x0 * x532 + x0 * (x0 * x534 + x532) + x198 * x22 + x535,
            x0 * x537 + x0 * (x0 * x539 + x537) + x203 * x22 + x540,
            x0 * x542 + x0 * (x0 * x544 + x542) + x208 * x22 + x545,
            x0 * x558 + x21 * x238 + x566,
            x0 * x577 + x21 * x265 + x581,
            x0 * x588 + x21 * x280 + x589,
            x0 * x595 + x21 * x291 + x597,
            x0 * x603 + x21 * x306 + x605,
            x0 * x610 + x21 * x317 + x611,
            x0 * x616 + x21 * x326 + x618,
            x0 * x623 + x21 * x336 + x625,
            x0 * x630 + x21 * x348 + x632,
            x0 * x636 + x21 * x357 + x637,
            x0 * x640 + x21 * x363 + x641,
            x0 * x644 + x21 * x369 + x645,
            x0 * x648 + x21 * x374 + x649,
            x0 * x652 + x21 * x380 + x653,
            x0 * x656 + x21 * x387 + x657,
            x0 * x669 + x21 * x417 + x675,
            x0 * x682 + x21 * x435 + x686,
            x0 * x693 + x21 * x450 + x697,
            x0 * x703 + x21 * x460 + x707,
            x0 * x713 + x21 * x470 + x717,
            x0 * x723 + x21 * x484 + x727,
            x0 * x732 + x21 * x490 + x736,
            x0 * x741 + x21 * x496 + x745,
            x0 * x750 + x21 * x503 + x754,
            x0 * x759 + x21 * x513 + x763,
            x0 * x766 + x21 * x521 + x768,
            x0 * x772 + x21 * x527 + x774,
            x0 * x777 + x21 * x532 + x779,
            x0 * x782 + x21 * x537 + x784,
            x0 * x787 + x21 * x542 + x789,
            x0 * x802 + x22 * x417 + x810,
            x0 * x816 + x22 * x435 + x817,
            x0 * x825 + x22 * x450 + x827,
            x0 * x832 + x22 * x460 + x833,
            x0 * x839 + x22 * x470 + x840,
            x0 * x847 + x22 * x484 + x849,
            x0 * x853 + x22 * x490 + x854,
            x0 * x858 + x22 * x496 + x859,
            x0 * x863 + x22 * x503 + x864,
            x0 * x870 + x22 * x513 + x872,
            x0 * x875 + x22 * x521 + x876,
            x0 * x879 + x22 * x527 + x880,
            x0 * x883 + x22 * x532 + x884,
            x0 * x887 + x22 * x537 + x888,
            x0 * x891 + x22 * x542 + x892,
            x21 * x558 + x898,
            x21 * x577 + x906,
            x21 * x588 + x909,
            x21 * x595 + x913,
            x21 * x603 + x917,
            x21 * x610 + x919,
            x21 * x616 + x923,
            x21 * x623 + x927,
            x21 * x630 + x931,
            x21 * x636 + x933,
            x21 * x640 + x934,
            x21 * x644 + x935,
            x21 * x648 + x936,
            x21 * x652 + x937,
            x21 * x656 + x938,
            x21 * x669 + x944,
            x21 * x682 + x949,
            x21 * x693 + x953,
            x21 * x703 + x957,
            x21 * x713 + x962,
            x21 * x723 + x966,
            x21 * x732 + x970,
            x21 * x741 + x974,
            x21 * x750 + x979,
            x21 * x759 + x983,
            x21 * x766 + x985,
            x21 * x772 + x987,
            x21 * x777 + x989,
            x21 * x782 + x991,
            x21 * x787 + x993,
            x21 * x802 + x999,
            x1003 + x21 * x816,
            x1007 + x21 * x825,
            x1011 + x21 * x832,
            x1015 + x21 * x839,
            x1019 + x21 * x847,
            x1023 + x21 * x853,
            x1027 + x21 * x858,
            x1031 + x21 * x863,
            x1035 + x21 * x870,
            x1037 + x21 * x875,
            x1039 + x21 * x879,
            x1041 + x21 * x883,
            x1043 + x21 * x887,
            x1045 + x21 * x891,
            x1051 + x22 * x802,
            x1053 + x22 * x816,
            x1057 + x22 * x825,
            x1059 + x22 * x832,
            x1061 + x22 * x839,
            x1065 + x22 * x847,
            x1067 + x22 * x853,
            x1069 + x22 * x858,
            x1071 + x22 * x863,
            x1075 + x22 * x870,
            x1076 + x22 * x875,
            x1077 + x22 * x879,
            x1078 + x22 * x883,
            x1079 + x22 * x887,
            x1080 + x22 * x891,
            x0 * x1081 + x0 * x237 + x0 * (x0 * (x1082 * x1083 + x240) + x1081) + x249,
            x0 * x1084 + x0 * x264 + x0 * (x0 * (x0 * x1086 + x267) + x1084) + x271,
            x0 * x1087 + x0 * x279 + x0 * (x0 * (x1083 * x1088 + x281) + x1087) + x283,
            x0 * x1089 + x0 * x290 + x0 * (x0 * (x1090 * x288 + x293) + x1089) + x296,
            x0 * x1091 + x0 * x305 + x0 * (x0 * (x1090 * x303 + x307) + x1091) + x311,
            x0 * x1092 + x0 * x316 + x0 * (x0 * (x1093 * x1094 + x319) + x1092) + x321,
            x0 * x1095 + x0 * x325 + x0 * (x0 * (x1096 * x327 + x328) + x1095) + x331,
            x0 * x1097 + x0 * x335 + x0 * (x0 * (x1096 * x337 + x338) + x1097) + x341,
            x0 * x1098 + x0 * x347 + x0 * (x0 * (x1096 * x349 + x350) + x1098) + x354,
            x0 * x1099 + x0 * x356 + x0 * (x0 * (x1094 * x1100 + x359) + x1099) + x361,
            x0 * x1101 + x0 * x362 + x0 * (x0 * (x1102 * x86 + x364) + x1101) + x367,
            x0 * x1103 + x0 * x368 + x0 * (x0 * (x1104 * x86 + x370) + x1103) + x372,
            x0 * x1105 + x0 * x373 + x0 * (x0 * (x1106 * x86 + x375) + x1105) + x377,
            x0 * x1107 + x0 * x379 + x0 * (x0 * (x1108 * x86 + x382) + x1107) + x385,
            x0 * x1109 + x0 * x386 + x0 * (x0 * (x1083 * x207 + x388) + x1109) + x390,
            x0 * x557 + x0 * (x0 * x1112 + x557) + x566,
            x0 * x576 + x0 * (x0 * x1114 + x576) + x581,
            x0 * x587 + x0 * (x0 * x1116 + x587) + x589,
            x0 * x594 + x0 * (x0 * x1119 + x594) + x597,
            x0 * x602 + x0 * (x0 * x1121 + x602) + x605,
            x0 * x609 + x0 * (x0 * x1125 + x609) + x611,
            x0 * x615 + x0 * (x0 * x1128 + x615) + x618,
            x0 * x622 + x0 * (x0 * x1130 + x622) + x625,
            x0 * x629 + x0 * (x0 * x1132 + x629) + x632,
            x0 * x635 + x0 * (x0 * x1134 + x635) + x637,
            x0 * x639 + x0 * (x0 * x1136 + x639) + x641,
            x0 * x643 + x0 * (x0 * x1138 + x643) + x645,
            x0 * x647 + x0 * (x0 * x1140 + x647) + x649,
            x0 * x651 + x0 * (x0 * x1142 + x651) + x653,
            x0 * x655 + x0 * (x0 * x1144 + x655) + x657,
            x0 * x668 + x0 * (x0 * x1147 + x668) + x675,
            x0 * x681 + x0 * (x0 * x1149 + x681) + x686,
            x0 * x692 + x0 * (x0 * x1151 + x692) + x697,
            x0 * x702 + x0 * (x0 * x1154 + x702) + x707,
            x0 * x712 + x0 * (x0 * x1156 + x712) + x717,
            x0 * x722 + x0 * (x0 * x1159 + x722) + x727,
            x0 * x731 + x0 * (x0 * x1162 + x731) + x736,
            x0 * x740 + x0 * (x0 * x1164 + x740) + x745,
            x0 * x749 + x0 * (x0 * x1166 + x749) + x754,
            x0 * x758 + x0 * (x0 * x1168 + x758) + x763,
            x0 * x765 + x0 * (x0 * x1170 + x765) + x768,
            x0 * x771 + x0 * (x0 * x1172 + x771) + x774,
            x0 * x776 + x0 * (x0 * x1174 + x776) + x779,
            x0 * x781 + x0 * (x0 * x1176 + x781) + x784,
            x0 * x786 + x0 * (x0 * x1178 + x786) + x789,
            x0 * x1181 + x898,
            x0 * x1184 + x906,
            x0 * x1187 + x909,
            x0 * x1190 + x913,
            x0 * x1193 + x917,
            x0 * x1197 + x919,
            x0 * x1200 + x923,
            x0 * x1203 + x927,
            x0 * x1206 + x931,
            x0 * x1209 + x933,
            x0 * x1212 + x934,
            x0 * x1215 + x935,
            x0 * x1218 + x936,
            x0 * x1221 + x937,
            x0 * x1224 + x938,
            x0 * x1227 + x944,
            x0 * x1230 + x949,
            x0 * x1233 + x953,
            x0 * x1236 + x957,
            x0 * x1239 + x962,
            x0 * x1242 + x966,
            x0 * x1245 + x970,
            x0 * x1248 + x974,
            x0 * x1251 + x979,
            x0 * x1254 + x983,
            x0 * x1257 + x985,
            x0 * x1260 + x987,
            x0 * x1263 + x989,
            x0 * x1267 + x991,
            x0 * x1270 + x993,
            x0 * x1273 + x999,
            x0 * x1276 + x1003,
            x0 * x1279 + x1007,
            x0 * x1282 + x1011,
            x0 * x1285 + x1015,
            x0 * x1288 + x1019,
            x0 * x1291 + x1023,
            x0 * x1294 + x1027,
            x0 * x1297 + x1031,
            x0 * x1300 + x1035,
            x0 * x1303 + x1037,
            x0 * x1306 + x1039,
            x0 * x1309 + x1041,
            x0 * x1312 + x1043,
            x0 * x1315 + x1045,
            x1082 * x1316 + x1179 * x21 + x1180 * x21 + x1181 * x21,
            x1085 * x1319 + x1182 * x21 + x1183 * x21 + x1184 * x21,
            x1088 * x1316 + x1185 * x21 + x1186 * x21 + x1187 * x21,
            x1188 * x21 + x1189 * x21 + x1190 * x21 + x1320 * x266,
            x1191 * x21 + x1192 * x21 + x1193 * x21 + x1321 * x266,
            x1093 * x1322 + x1195 * x21 + x1196 * x21 + x1197 * x21,
            x1198 * x21 + x1199 * x21 + x1200 * x21 + x1323 * x261,
            x1201 * x21 + x1202 * x21 + x1203 * x21 + x1324 * x261,
            x1204 * x21 + x1205 * x21 + x1206 * x21 + x1325 * x261,
            x1100 * x1322 + x1207 * x21 + x1208 * x21 + x1209 * x21,
            x1210 * x21 + x1211 * x21 + x1212 * x21 + x55 * (x1323 * x97 + 4.0 * x921),
            x1213 * x21 + x1214 * x21 + x1215 * x21 + x55 * (x1324 * x97 + 4.0 * x925),
            x1216 * x21 + x1217 * x21 + x1218 * x21 + x55 * (x1325 * x97 + 4.0 * x929),
            x1219 * x21 + x1220 * x21 + x1221 * x21 + x55 * (x1317 * x179 + x1318 * x179),
            x1222 * x21 + x1223 * x21 + x1224 * x21 + x1316 * x207,
            x1179 * x22 + x1226 * x21 + x1227 * x21 + x1327,
            x1182 * x22 + x1229 * x21 + x1230 * x21 + x1329,
            x1185 * x22 + x1232 * x21 + x1233 * x21 + x1331,
            x1188 * x22 + x1235 * x21 + x1236 * x21 + x1333,
            x1191 * x22 + x1238 * x21 + x1239 * x21 + x1335,
            x1195 * x22 + x1241 * x21 + x1242 * x21 + x1337,
            x1198 * x22 + x1244 * x21 + x1245 * x21 + x1339,
            x1201 * x22 + x1247 * x21 + x1248 * x21 + x1341,
            x1204 * x22 + x1250 * x21 + x1251 * x21 + x1343,
            x1207 * x22 + x1253 * x21 + x1254 * x21 + x1345,
            x1210 * x22 + x1256 * x21 + x1257 * x21 + x1346,
            x1213 * x22 + x1259 * x21 + x1260 * x21 + x1347,
            x1216 * x22 + x1262 * x21 + x1263 * x21 + x1348,
            x1219 * x22 + x1266 * x21 + x1267 * x21 + x1349,
            x1222 * x22 + x1269 * x21 + x1270 * x21 + x1350,
            x1226 * x22 + x1273 * x21 + x1352,
            x1229 * x22 + x1276 * x21 + x1354,
            x1232 * x22 + x1279 * x21 + x1356,
            x1235 * x22 + x1282 * x21 + x1358,
            x1238 * x22 + x1285 * x21 + x1360,
            x1241 * x22 + x1288 * x21 + x1362,
            x1244 * x22 + x1291 * x21 + x1364,
            x1247 * x22 + x1294 * x21 + x1366,
            x1250 * x22 + x1297 * x21 + x1368,
            x1253 * x22 + x1300 * x21 + x1370,
            x1256 * x22 + x1303 * x21 + x1371,
            x1259 * x22 + x1306 * x21 + x1372,
            x1262 * x22 + x1309 * x21 + x1373,
            x1266 * x22 + x1312 * x21 + x1374,
            x1269 * x22 + x1315 * x21 + x1375,
            x1273 * x22 + x1377,
            x1276 * x22 + x1379,
            x1279 * x22 + x1381,
            x1282 * x22 + x1383,
            x1285 * x22 + x1385,
            x1288 * x22 + x1387,
            x1291 * x22 + x1389,
            x1294 * x22 + x1391,
            x1297 * x22 + x1393,
            x1300 * x22 + x1395,
            x1303 * x22 + x1396,
            x1306 * x22 + x1397,
            x1309 * x22 + x1398,
            x1312 * x22 + x1399,
            x1315 * x22 + x1400,
            x0 * x1401 + x0 * x416 + x0 * (x0 * (x1082 * x1402 + x418) + x1401) + x427,
            x0 * x1403 + x0 * x434 + x0 * (x0 * (x1402 * x1404 + x437) + x1403) + x439,
            x0 * x1405 + x0 * x449 + x0 * (x0 * (x1085 * x1406 + x452) + x1405) + x455,
            x0 * x1407 + x0 * x459 + x0 * (x0 * (x1402 * x1409 + x462) + x1407) + x464,
            x0 * x1410 + x0 * x469 + x0 * (x0 * (x1406 * x1411 + x472) + x1410) + x475,
            x0 * x1412 + x0 * x483 + x0 * (x0 * (x1090 * x480 + x485) + x1412) + x488,
            x0 * x1413 + x0 * x489 + x0 * (x0 * (x1402 * x1414 + x492) + x1413) + x494,
            x0 * x1415 + x0 * x495 + x0 * (x0 * (x1406 * x1417 + x498) + x1415) + x500,
            x0 * x1418 + x0 * x502 + x0 * (x0 * (x0 * x1419 + x506) + x1418) + x508,
            x0 * x1420 + x0 * x512 + x0 * (x0 * (x1096 * x514 + x516) + x1420) + x519,
            x0 * x1421 + x0 * x520 + x0 * (x0 * (x1402 * x186 + x522) + x1421) + x525,
            x0 * x1422 + x0 * x526 + x0 * (x0 * (x1406 * x191 + x528) + x1422) + x530,
            x0 * x1423 + x0 * x531 + x0 * (x0 * (x0 * x1424 + x533) + x1423) + x535,
            x0 * x1425 + x0 * x536 + x0 * (x0 * (x0 * x1426 + x538) + x1425) + x540,
            x0 * x1427 + x0 * x541 + x0 * (x0 * (x1428 * x86 + x543) + x1427) + x545,
            x0 * x1429 + x0 * (x0 * x1431 + x1429) + x21 * x416 + x674,
            x0 * x1432 + x0 * (x0 * x1433 + x1432) + x21 * x434 + x685,
            x0 * x1434 + x0 * (x0 * x1436 + x1434) + x21 * x449 + x696,
            x0 * x1437 + x0 * (x0 * x1438 + x1437) + x21 * x459 + x706,
            x0 * x1439 + x0 * (x0 * x1440 + x1439) + x21 * x469 + x716,
            x0 * x1441 + x0 * (x0 * x1442 + x1441) + x21 * x483 + x726,
            x0 * x1443 + x0 * (x0 * x1444 + x1443) + x21 * x489 + x735,
            x0 * x1445 + x0 * (x0 * x1446 + x1445) + x21 * x495 + x744,
            x0 * x1447 + x0 * (x0 * x1448 + x1447) + x21 * x502 + x753,
            x0 * x1449 + x0 * (x0 * x1450 + x1449) + x21 * x512 + x762,
            x0 * x1451 + x0 * (x0 * x1452 + x1451) + x21 * x520 + x767,
            x0 * x1453 + x0 * (x0 * x1454 + x1453) + x21 * x526 + x773,
            x0 * x1455 + x0 * (x0 * x1456 + x1455) + x21 * x531 + x778,
            x0 * x1457 + x0 * (x0 * x1458 + x1457) + x21 * x536 + x783,
            x0 * x1459 + x0 * (x0 * x1460 + x1459) + x21 * x541 + x788,
            x0 * x801 + x0 * (x0 * x1463 + x801) + x810,
            x0 * x815 + x0 * (x0 * x1465 + x815) + x817,
            x0 * x824 + x0 * (x0 * x1468 + x824) + x827,
            x0 * x831 + x0 * (x0 * x1470 + x831) + x833,
            x0 * x838 + x0 * (x0 * x1472 + x838) + x840,
            x0 * x846 + x0 * (x0 * x1474 + x846) + x849,
            x0 * x852 + x0 * (x0 * x1476 + x852) + x854,
            x0 * x857 + x0 * (x0 * x1478 + x857) + x859,
            x0 * x862 + x0 * (x0 * x1480 + x862) + x864,
            x0 * x869 + x0 * (x0 * x1482 + x869) + x872,
            x0 * x874 + x0 * (x0 * x1484 + x874) + x876,
            x0 * x878 + x0 * (x0 * x1486 + x878) + x880,
            x0 * x882 + x0 * (x0 * x1488 + x882) + x884,
            x0 * x886 + x0 * (x0 * x1490 + x886) + x888,
            x0 * x890 + x0 * (x0 * x1492 + x890) + x892,
            x0 * x1494 + x1429 * x21 + x21 * x667 + x943,
            x0 * x1496 + x1432 * x21 + x21 * x680 + x948,
            x0 * x1498 + x1434 * x21 + x21 * x691 + x952,
            x0 * x1500 + x1437 * x21 + x21 * x701 + x956,
            x0 * x1502 + x1439 * x21 + x21 * x711 + x961,
            x0 * x1504 + x1441 * x21 + x21 * x721 + x965,
            x0 * x1506 + x1443 * x21 + x21 * x730 + x969,
            x0 * x1508 + x1445 * x21 + x21 * x739 + x973,
            x0 * x1510 + x1447 * x21 + x21 * x748 + x978,
            x0 * x1512 + x1449 * x21 + x21 * x757 + x982,
            x0 * x1514 + x1451 * x21 + x21 * x764 + x984,
            x0 * x1516 + x1453 * x21 + x21 * x770 + x986,
            x0 * x1518 + x1455 * x21 + x21 * x775 + x988,
            x0 * x1520 + x1457 * x21 + x21 * x780 + x990,
            x0 * x1522 + x1459 * x21 + x21 * x785 + x992,
            x0 * x1523 + x21 * x801 + x998,
            x0 * x1524 + x1002 + x21 * x815,
            x0 * x1525 + x1006 + x21 * x824,
            x0 * x1526 + x1010 + x21 * x831,
            x0 * x1527 + x1014 + x21 * x838,
            x0 * x1528 + x1018 + x21 * x846,
            x0 * x1529 + x1022 + x21 * x852,
            x0 * x1530 + x1026 + x21 * x857,
            x0 * x1531 + x1030 + x21 * x862,
            x0 * x1532 + x1034 + x21 * x869,
            x0 * x1533 + x1036 + x21 * x874,
            x0 * x1534 + x1038 + x21 * x878,
            x0 * x1535 + x1040 + x21 * x882,
            x0 * x1536 + x1042 + x21 * x886,
            x0 * x1537 + x1044 + x21 * x890,
            x0 * x1540 + x1051,
            x0 * x1543 + x1053,
            x0 * x1546 + x1057,
            x0 * x1549 + x1059,
            x0 * x1552 + x1061,
            x0 * x1555 + x1065,
            x0 * x1558 + x1067,
            x0 * x1561 + x1069,
            x0 * x1564 + x1071,
            x0 * x1567 + x1075,
            x0 * x1570 + x1076,
            x0 * x1573 + x1077,
            x0 * x1576 + x1078,
            x0 * x1579 + x1079,
            x0 * x1582 + x1080,
            x1225 * x21 + x1327 + x1493 * x21 + x1494 * x21,
            x1228 * x21 + x1329 + x1495 * x21 + x1496 * x21,
            x1231 * x21 + x1331 + x1497 * x21 + x1498 * x21,
            x1234 * x21 + x1333 + x1499 * x21 + x1500 * x21,
            x1237 * x21 + x1335 + x1501 * x21 + x1502 * x21,
            x1240 * x21 + x1337 + x1503 * x21 + x1504 * x21,
            x1243 * x21 + x1339 + x1505 * x21 + x1506 * x21,
            x1246 * x21 + x1341 + x1507 * x21 + x1508 * x21,
            x1249 * x21 + x1343 + x1509 * x21 + x1510 * x21,
            x1252 * x21 + x1345 + x1511 * x21 + x1512 * x21,
            x1255 * x21 + x1346 + x1513 * x21 + x1514 * x21,
            x1258 * x21 + x1347 + x1515 * x21 + x1516 * x21,
            x1261 * x21 + x1348 + x1517 * x21 + x1518 * x21,
            x1265 * x21 + x1349 + x1519 * x21 + x1520 * x21,
            x1268 * x21 + x1350 + x1521 * x21 + x1522 * x21,
            x1272 * x21 + x1352 + x1523 * x21,
            x1275 * x21 + x1354 + x1524 * x21,
            x1278 * x21 + x1356 + x1525 * x21,
            x1281 * x21 + x1358 + x1526 * x21,
            x1284 * x21 + x1360 + x1527 * x21,
            x1287 * x21 + x1362 + x1528 * x21,
            x1290 * x21 + x1364 + x1529 * x21,
            x1293 * x21 + x1366 + x1530 * x21,
            x1296 * x21 + x1368 + x1531 * x21,
            x1299 * x21 + x1370 + x1532 * x21,
            x1302 * x21 + x1371 + x1533 * x21,
            x1305 * x21 + x1372 + x1534 * x21,
            x1308 * x21 + x1373 + x1535 * x21,
            x1311 * x21 + x1374 + x1536 * x21,
            x1314 * x21 + x1375 + x1537 * x21,
            x1377 + x1540 * x21,
            x1379 + x1543 * x21,
            x1381 + x1546 * x21,
            x1383 + x1549 * x21,
            x1385 + x1552 * x21,
            x1387 + x1555 * x21,
            x1389 + x1558 * x21,
            x1391 + x1561 * x21,
            x1393 + x1564 * x21,
            x1395 + x1567 * x21,
            x1396 + x1570 * x21,
            x1397 + x1573 * x21,
            x1398 + x1576 * x21,
            x1399 + x1579 * x21,
            x1400 + x1582 * x21,
            x1082 * x1583 + x1538 * x22 + x1539 * x22 + x1540 * x22,
            x1404 * x1583 + x1541 * x22 + x1542 * x22 + x1543 * x22,
            x1085 * x1584 + x1544 * x22 + x1545 * x22 + x1546 * x22,
            x1409 * x1583 + x1547 * x22 + x1548 * x22 + x1549 * x22,
            x1411 * x1584 + x1550 * x22 + x1551 * x22 + x1552 * x22,
            x1553 * x22 + x1554 * x22 + x1555 * x22 + x1585 * x266,
            x1414 * x1583 + x1556 * x22 + x1557 * x22 + x1558 * x22,
            x1417 * x1584 + x1559 * x22 + x1560 * x22 + x1561 * x22,
            x1562 * x22 + x1563 * x22 + x1564 * x22 + x1585 * x471,
            x1565 * x22 + x1566 * x22 + x1567 * x22 + x1586 * x261,
            x1568 * x22 + x1569 * x22 + x1570 * x22 + x1583 * x186,
            x1571 * x22 + x1572 * x22 + x1573 * x22 + x1584 * x191,
            x1574 * x22 + x1575 * x22 + x1576 * x22 + x1585 * x164,
            x135 * x1586 + x1577 * x22 + x1578 * x22 + x1579 * x22,
            x1580 * x22 + x1581 * x22 + x1582 * x22 + x55 * (4.0 * x1073 + x112 * x1586),
        ]
    )


def _3center2el3d_sph_135(a, A, b, B, c, C):
    """Cartesian (pf|h) three-center two-electron repulsion integral for conversion to spherical harmonics.
    Uses Ahlrichs' vertical recursion relation, that leaves out some terms, that cancel
    when convertig to spherical harmonics.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x3 - A[0]
    x6 = (2.0 * a + 2.0 * b) ** (-1.0)
    x7 = x4**2
    x8 = -x2 * (a * A[1] + b * B[1])
    x9 = -x8 - C[1]
    x10 = x9**2
    x11 = -x2 * (a * A[2] + b * B[2])
    x12 = -x11 - C[2]
    x13 = x12**2
    x14 = c + x1
    x15 = x14 ** (-1.0)
    x16 = c * x15
    x17 = x1 * x16 * (x10 + x13 + x7)
    x18 = boys(6, x17)
    x19 = x14 ** (-1.5)
    x20 = 17.4934183276249
    x21 = A[1] - B[1]
    x22 = A[2] - B[2]
    x23 = numpy.exp(-a * b * x2 * (x0**2 + x21**2 + x22**2))
    x24 = x20 * x23
    x25 = x2 * x24
    x26 = 2.0 * x19 * x25
    x27 = x18 * x26
    x28 = c ** (-1.0)
    x29 = x14 ** (-0.5)
    x30 = boys(5, x17)
    x31 = 2.0 * x2 * x20 * x23 * x28 * x29 * x30 - x27
    x32 = x31 * x6
    x33 = -2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x5 + x27 * x4
    x34 = -x33
    x35 = boys(7, x17)
    x36 = x26 * x35
    x37 = -2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x5 + x36 * x4
    x38 = -x37
    x39 = x16 * x38
    x40 = x39 * x4
    x41 = x32 + x34 * x5 - x40
    x42 = 2.0 * x6
    x43 = x6 * (2.0 * x18 * x2 * x20 * x23 * x28 * x29 - x36)
    x44 = boys(8, x17)
    x45 = x26 * x44
    x46 = 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x5 - x4 * x45
    x47 = x16 * x46
    x48 = x38 * x5 - x4 * x47 + x43
    x49 = x16 * x48
    x50 = -x4 * x49 + x41 * x5 + x42 * (-x33 - x39)
    x51 = x4 * x50
    x52 = x41 * x6
    x53 = 3.0 * x52
    x54 = x51 + x53
    x55 = x1 * x15
    x56 = x4 * x55
    x57 = x4 * x41
    x58 = x34 * x6
    x59 = 2.0 * x58
    x60 = x57 + x59
    x61 = 3.0 * x6
    x62 = x55 * x61
    x63 = x54 * x56 + x60 * x62
    x64 = x34 * x4
    x65 = x28 * x30 * x42
    x66 = x25 * x29 * x65
    x67 = x64 + x66
    x68 = x42 * x55
    x69 = x56 * x60 + x67 * x68
    x70 = x56 * x63 + x62 * x69
    x71 = x24 * x65
    x72 = x19 * x71
    x73 = x4 * x72 + x56 * x67
    x74 = x56 * x69 + x68 * x73
    x75 = x56 * x70 + x62 * x74
    x76 = x7 * x71
    x77 = x1 * x14 ** (-2.5)
    x78 = x56 * x73 + x76 * x77
    x79 = x56 * x74 + x68 * x78
    x80 = x55 * (x56 * x75 + x62 * x79)
    x81 = x4**3
    x82 = x71 * x81
    x83 = x1**2
    x84 = x14 ** (-3.5) * x83
    x85 = x56 * x78 + x82 * x84
    x86 = x55 * (x56 * x79 + x68 * x85)
    x87 = x0 * x86 + x80
    x88 = x4**4
    x89 = x1**3
    x90 = x14 ** (-4.5) * x89
    x91 = x71 * x90
    x92 = x56 * x85 + x88 * x91
    x93 = x0 * x55
    x94 = -x31 * x6
    x95 = x6 * (2.0 * x2 * x20 * x23 * x28 * x29 * x35 - x45)
    x96 = x26 * boys(9, x17)
    x97 = x16 * x4
    x98 = (
        x5 * x50
        + x61 * (x34 * x5 - x40 - x49 - x94)
        - x97
        * (
            x42 * (-x37 - x47)
            + x48 * x5
            - x97
            * (
                x46 * x5
                + x95
                - x97 * (2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x5 - x4 * x96)
            )
        )
    )
    x99 = x4 * x98
    x100 = x50 * x6
    x101 = 4.0 * x100
    x102 = x55 * x6
    x103 = 4.0 * x102
    x104 = x55 * x9
    x105 = x104 * x51 + x104 * x53
    x106 = x104 * x57 + x104 * x59
    x107 = x105 * x56 + x106 * x62
    x108 = x72 * x9
    x109 = x104 * x64 + x108
    x110 = x106 * x56 + x109 * x68
    x111 = x107 * x56 + x110 * x62
    x112 = x71 * x77
    x113 = x112 * x4
    x114 = x109 * x56 + x113 * x9
    x115 = x110 * x56 + x114 * x68
    x116 = x55 * (x111 * x56 + x115 * x62)
    x117 = x7 * x9
    x118 = x71 * x84
    x119 = x114 * x56 + x117 * x118
    x120 = x55 * (x115 * x56 + x119 * x68)
    x121 = x0 * x120 + x116
    x122 = x82 * x90
    x123 = x119 * x56 + x122 * x9
    x124 = x12 * x55
    x125 = x124 * x51 + x124 * x53
    x126 = x124 * x57 + x124 * x59
    x127 = x125 * x56 + x126 * x62
    x128 = x12 * x72
    x129 = x124 * x64 + x128
    x130 = x126 * x56 + x129 * x68
    x131 = x127 * x56 + x130 * x62
    x132 = x113 * x12 + x129 * x56
    x133 = x130 * x56 + x132 * x68
    x134 = x55 * (x131 * x56 + x133 * x62)
    x135 = x12 * x76 * x84 + x132 * x56
    x136 = x55 * (x133 * x56 + x135 * x68)
    x137 = x0 * x136 + x134
    x138 = x12 * x122 + x135 * x56
    x139 = x83 / x14**2
    x140 = x10 * x139
    x141 = x140 * x51 + x140 * x53
    x142 = x140 * x57 + x140 * x59
    x143 = x141 * x56 + x142 * x62
    x144 = x10 * x112
    x145 = x140 * x64 + x144
    x146 = x142 * x56 + x145 * x68
    x147 = x55 * (x143 * x56 + x146 * x62)
    x148 = x10 * x4
    x149 = x118 * x148 + x145 * x56
    x150 = x55 * (x146 * x56 + x149 * x68)
    x151 = x0 * x150 + x147
    x152 = x76 * x90
    x153 = x10 * x152 + x149 * x56
    x154 = x139 * x9
    x155 = x12 * x154
    x156 = x155 * x51 + x155 * x53
    x157 = x155 * x57 + x155 * x59
    x158 = x156 * x56 + x157 * x62
    x159 = x12 * x9
    x160 = x112 * x159
    x161 = x155 * x64 + x160
    x162 = x157 * x56 + x161 * x68
    x163 = x55 * (x158 * x56 + x162 * x62)
    x164 = x118 * x159 * x4 + x161 * x56
    x165 = x55 * (x162 * x56 + x164 * x68)
    x166 = x0 * x165 + x163
    x167 = x12 * x91
    x168 = x117 * x167 + x164 * x56
    x169 = x13 * x139
    x170 = x169 * x51 + x169 * x53
    x171 = x169 * x57 + x169 * x59
    x172 = x170 * x56 + x171 * x62
    x173 = x112 * x13
    x174 = x169 * x64 + x173
    x175 = x171 * x56 + x174 * x68
    x176 = x55 * (x172 * x56 + x175 * x62)
    x177 = x118 * x13
    x178 = x174 * x56 + x177 * x4
    x179 = x55 * (x175 * x56 + x178 * x68)
    x180 = x0 * x179 + x176
    x181 = x13 * x152 + x178 * x56
    x182 = x9**3
    x183 = x89 / x14**3
    x184 = x182 * x183
    x185 = x184 * x51 + x184 * x53
    x186 = x184 * x57 + x184 * x59
    x187 = x55 * (x185 * x56 + x186 * x62)
    x188 = x118 * x182
    x189 = x184 * x64 + x188
    x190 = x55 * (x186 * x56 + x189 * x68)
    x191 = x0 * x190 + x187
    x192 = x182 * x91
    x193 = x189 * x56 + x192 * x4
    x194 = x10 * x183
    x195 = x12 * x194
    x196 = x195 * x51 + x195 * x53
    x197 = x195 * x57 + x195 * x59
    x198 = x55 * (x196 * x56 + x197 * x62)
    x199 = x10 * x118 * x12
    x200 = x195 * x64 + x199
    x201 = x55 * (x197 * x56 + x200 * x68)
    x202 = x0 * x201 + x198
    x203 = x148 * x167 + x200 * x56
    x204 = x183 * x9
    x205 = x13 * x204
    x206 = x205 * x51 + x205 * x53
    x207 = x205 * x57 + x205 * x59
    x208 = x55 * (x206 * x56 + x207 * x62)
    x209 = x177 * x9
    x210 = x205 * x64 + x209
    x211 = x55 * (x207 * x56 + x210 * x68)
    x212 = x0 * x211 + x208
    x213 = x13 * x4 * x9 * x91 + x210 * x56
    x214 = x12**3
    x215 = x183 * x214
    x216 = x215 * x51 + x215 * x53
    x217 = x215 * x57 + x215 * x59
    x218 = x55 * (x216 * x56 + x217 * x62)
    x219 = x118 * x214
    x220 = x215 * x64 + x219
    x221 = x55 * (x217 * x56 + x220 * x68)
    x222 = x0 * x221 + x218
    x223 = x214 * x4
    x224 = x220 * x56 + x223 * x91
    x225 = x9**4
    x226 = x1**4 / x14**4
    x227 = x225 * x226
    x228 = x55 * (x227 * x51 + x227 * x53)
    x229 = x55 * (x227 * x57 + x227 * x59)
    x230 = x0 * x229 + x228
    x231 = x225 * x91
    x232 = x227 * x64 + x231
    x233 = x182 * x226
    x234 = x12 * x233
    x235 = x55 * (x234 * x51 + x234 * x53)
    x236 = x55 * (x234 * x57 + x234 * x59)
    x237 = x0 * x236 + x235
    x238 = x12 * x192
    x239 = x234 * x64 + x238
    x240 = x226 * x51
    x241 = x10 * x13
    x242 = x226 * x241
    x243 = x55 * (x240 * x241 + x242 * x53)
    x244 = x55 * (x242 * x57 + x242 * x59)
    x245 = x0 * x244 + x243
    x246 = x241 * x91
    x247 = x242 * x64 + x246
    x248 = x214 * x9
    x249 = x226 * x248
    x250 = x55 * (x240 * x248 + x249 * x53)
    x251 = x55 * (x249 * x57 + x249 * x59)
    x252 = x0 * x251 + x250
    x253 = x248 * x91
    x254 = x249 * x64 + x253
    x255 = x12**4
    x256 = x226 * x255
    x257 = x55 * (x256 * x51 + x256 * x53)
    x258 = x55 * (x256 * x57 + x256 * x59)
    x259 = x0 * x258 + x257
    x260 = x255 * x91
    x261 = x256 * x64 + x260
    x262 = x1**5 / x14**5
    x263 = x262 * x9**5
    x264 = x263 * x50
    x265 = x263 * x41
    x266 = x0 * x265 + x264
    x267 = x0 * x34
    x268 = x225 * x262
    x269 = x12 * x268
    x270 = x269 * x50
    x271 = x269 * x41
    x272 = x0 * x271 + x270
    x273 = x262 * x50
    x274 = x13 * x182
    x275 = x273 * x274
    x276 = x262 * x274
    x277 = x276 * x41
    x278 = x0 * x277 + x275
    x279 = x10 * x214
    x280 = x273 * x279
    x281 = x262 * x279
    x282 = x281 * x41
    x283 = x0 * x282 + x280
    x284 = x255 * x9
    x285 = x273 * x284
    x286 = x262 * x284
    x287 = x286 * x41
    x288 = x0 * x287 + x285
    x289 = x12**5 * x262
    x290 = x289 * x50
    x291 = x289 * x41
    x292 = x0 * x291 + x290
    x293 = -x8 - A[1]
    x294 = -2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x293 + x36 * x9
    x295 = -x294
    x296 = x16 * x295
    x297 = -2.0 * x2 * x20 * x23 * x28 * x29 * x293 * x30 + x27 * x9
    x298 = x6 * (-x296 - x297)
    x299 = -x297
    x300 = x296 * x4 - x299 * x5
    x301 = -x300
    x302 = 2.0 * x2 * x20 * x23 * x28 * x29 * x293 * x35 - x45 * x9
    x303 = x16 * x302
    x304 = x295 * x5 - x303 * x4
    x305 = x16 * x304
    x306 = x298 + x301 * x5 - x305 * x4
    x307 = x306 * x4
    x308 = x301 * x6
    x309 = 2.0 * x308
    x310 = x307 + x309
    x311 = x299 * x6
    x312 = x301 * x4
    x313 = x311 + x312
    x314 = x310 * x56 + x313 * x68
    x315 = x311 * x56 + x313 * x56
    x316 = x314 * x56 + x315 * x68
    x317 = x139 * x7
    x318 = x311 * x317 + x315 * x56
    x319 = x316 * x56 + x318 * x68
    x320 = x183 * x81
    x321 = x311 * x320 + x318 * x56
    x322 = x55 * (x319 * x56 + x321 * x68)
    x323 = x21 * x86 + x322
    x324 = x226 * x88
    x325 = x55 * (x311 * x324 + x321 * x56)
    x326 = x21 * x55
    x327 = x325 + x326 * x92
    x328 = x6 * (-x294 - x303)
    x329 = 2.0 * x2 * x20 * x23 * x28 * x29 * x293 * x44 - x9 * x96
    x330 = (
        x306 * x5
        + x42 * (-x300 - x305)
        - x97 * (x304 * x5 + x328 - x97 * (x302 * x5 - x329 * x97))
    )
    x331 = x330 * x4
    x332 = x306 * x6
    x333 = 3.0 * x332
    x334 = x55 * (
        x319 * x62
        + x56
        * (x316 * x62 + x56 * (x314 * x62 + x56 * (x310 * x62 + x56 * (x331 + x333))))
    )
    x335 = x306 * x9
    x336 = x335 + x52
    x337 = x301 * x9
    x338 = x337 + x58
    x339 = x338 * x68
    x340 = x336 * x56 + x339
    x341 = x299 * x9
    x342 = x341 + x66
    x343 = x342 * x55
    x344 = x338 * x56 + x343 * x6
    x345 = x340 * x56 + x344 * x68
    x346 = x139 * x4
    x347 = x342 * x6
    x348 = x344 * x56 + x346 * x347
    x349 = x345 * x56 + x348 * x68
    x350 = x183 * x7
    x351 = x347 * x350 + x348 * x56
    x352 = x55 * (x349 * x56 + x351 * x68)
    x353 = x120 * x21 + x352
    x354 = x226 * x81
    x355 = x55 * (x347 * x354 + x351 * x56)
    x356 = x123 * x326 + x355
    x357 = x330 * x9
    x358 = x100 + x357
    x359 = x55 * (
        x349 * x62
        + x56 * (x345 * x62 + x56 * (x340 * x62 + x56 * (x336 * x62 + x358 * x56)))
    )
    x360 = x124 * x309
    x361 = x124 * x307 + x360
    x362 = x124 * x311
    x363 = x124 * x312 + x362
    x364 = x361 * x56 + x363 * x68
    x365 = x12 * x311
    x366 = x346 * x365 + x363 * x56
    x367 = x364 * x56 + x366 * x68
    x368 = x350 * x365 + x366 * x56
    x369 = x55 * (x367 * x56 + x368 * x68)
    x370 = x136 * x21 + x369
    x371 = x55 * (x354 * x365 + x368 * x56)
    x372 = x138 * x326 + x371
    x373 = x55 * (
        x367 * x62
        + x56 * (x364 * x62 + x56 * (x361 * x62 + x56 * (x124 * x331 + x124 * x333)))
    )
    x374 = x104 * x336 + x104 * x52
    x375 = x104 * x338 + x104 * x58
    x376 = x375 * x68
    x377 = x374 * x56 + x376
    x378 = x108 + x343 * x9
    x379 = x102 * x378 + x375 * x56
    x380 = x377 * x56 + x379 * x68
    x381 = x378 * x6
    x382 = x346 * x381 + x379 * x56
    x383 = x55 * (x380 * x56 + x382 * x68)
    x384 = x150 * x21 + x383
    x385 = x55 * (x350 * x381 + x382 * x56)
    x386 = x153 * x326 + x385
    x387 = x100 * x104 + x104 * x358
    x388 = x55 * (x380 * x62 + x56 * (x377 * x62 + x56 * (x374 * x62 + x387 * x56)))
    x389 = x124 * x52
    x390 = x124 * x335 + x389
    x391 = x124 * x58
    x392 = x124 * x337 + x391
    x393 = x392 * x68
    x394 = x390 * x56 + x393
    x395 = x124 * x341 + x128
    x396 = x102 * x395 + x392 * x56
    x397 = x394 * x56 + x396 * x68
    x398 = x395 * x6
    x399 = x346 * x398 + x396 * x56
    x400 = x55 * (x397 * x56 + x399 * x68)
    x401 = x165 * x21 + x400
    x402 = x55 * (x350 * x398 + x399 * x56)
    x403 = x168 * x326 + x402
    x404 = x100 * x124
    x405 = x124 * x357 + x404
    x406 = x55 * (x397 * x62 + x56 * (x394 * x62 + x56 * (x390 * x62 + x405 * x56)))
    x407 = x169 * x309
    x408 = x169 * x307 + x407
    x409 = x169 * x311
    x410 = x169 * x312 + x409
    x411 = x408 * x56 + x410 * x68
    x412 = x13 * x311
    x413 = x183 * x4
    x414 = x410 * x56 + x412 * x413
    x415 = x55 * (x411 * x56 + x414 * x68)
    x416 = x179 * x21 + x415
    x417 = x226 * x7
    x418 = x55 * (x412 * x417 + x414 * x56)
    x419 = x181 * x326 + x418
    x420 = x55 * (x411 * x62 + x56 * (x408 * x62 + x56 * (x169 * x331 + x169 * x333)))
    x421 = x104 * x374 + x140 * x52
    x422 = x104 * x375 + x140 * x58
    x423 = x422 * x68
    x424 = x421 * x56 + x423
    x425 = x104 * x378 + x144
    x426 = x102 * x425 + x422 * x56
    x427 = x55 * (x424 * x56 + x426 * x68)
    x428 = x190 * x21 + x427
    x429 = x346 * x6
    x430 = x55 * (x425 * x429 + x426 * x56)
    x431 = x193 * x326 + x430
    x432 = x100 * x140 + x104 * x387
    x433 = x55 * (x424 * x62 + x56 * (x421 * x62 + x432 * x56))
    x434 = x104 * x390 + x155 * x52
    x435 = x104 * x392 + x155 * x58
    x436 = x435 * x68
    x437 = x434 * x56 + x436
    x438 = x104 * x395 + x160
    x439 = x102 * x438 + x435 * x56
    x440 = x55 * (x437 * x56 + x439 * x68)
    x441 = x201 * x21 + x440
    x442 = x55 * (x429 * x438 + x439 * x56)
    x443 = x203 * x326 + x442
    x444 = x100 * x155 + x104 * x405
    x445 = x55 * (x437 * x62 + x56 * (x434 * x62 + x444 * x56))
    x446 = x169 * x52
    x447 = x169 * x335 + x446
    x448 = x169 * x58
    x449 = x169 * x337 + x448
    x450 = x449 * x68
    x451 = x447 * x56 + x450
    x452 = x169 * x341 + x173
    x453 = x102 * x452 + x449 * x56
    x454 = x55 * (x451 * x56 + x453 * x68)
    x455 = x21 * x211 + x454
    x456 = x55 * (x429 * x452 + x453 * x56)
    x457 = x213 * x326 + x456
    x458 = x100 * x169
    x459 = x169 * x357 + x458
    x460 = x55 * (x451 * x62 + x56 * (x447 * x62 + x459 * x56))
    x461 = x215 * x309
    x462 = x215 * x307 + x461
    x463 = x215 * x311
    x464 = x215 * x312 + x463
    x465 = x55 * (x462 * x56 + x464 * x68)
    x466 = x21 * x221 + x465
    x467 = x223 * x226
    x468 = x55 * (x311 * x467 + x464 * x56)
    x469 = x224 * x326 + x468
    x470 = x55 * (x462 * x62 + x56 * (x215 * x331 + x215 * x333))
    x471 = x104 * x421 + x184 * x52
    x472 = x104 * x422 + x184 * x58
    x473 = x472 * x68
    x474 = x55 * (x471 * x56 + x473)
    x475 = x21 * x229 + x474
    x476 = x104 * x425 + x188
    x477 = x55 * (x102 * x476 + x472 * x56)
    x478 = x232 * x326 + x477
    x479 = x100 * x184 + x104 * x432
    x480 = x55 * (x471 * x62 + x479 * x56)
    x481 = x104 * x434 + x195 * x52
    x482 = x104 * x435 + x195 * x58
    x483 = x482 * x68
    x484 = x55 * (x481 * x56 + x483)
    x485 = x21 * x236 + x484
    x486 = x104 * x438 + x199
    x487 = x55 * (x102 * x486 + x482 * x56)
    x488 = x239 * x326 + x487
    x489 = x100 * x195 + x104 * x444
    x490 = x55 * (x481 * x62 + x489 * x56)
    x491 = x104 * x447 + x205 * x52
    x492 = x104 * x449 + x205 * x58
    x493 = x492 * x68
    x494 = x55 * (x491 * x56 + x493)
    x495 = x21 * x244 + x494
    x496 = x104 * x452 + x209
    x497 = x55 * (x102 * x496 + x492 * x56)
    x498 = x247 * x326 + x497
    x499 = x100 * x205 + x104 * x459
    x500 = x55 * (x491 * x62 + x499 * x56)
    x501 = x215 * x52
    x502 = x215 * x335 + x501
    x503 = x215 * x58
    x504 = x215 * x337 + x503
    x505 = x504 * x68
    x506 = x55 * (x502 * x56 + x505)
    x507 = x21 * x251 + x506
    x508 = x215 * x341 + x219
    x509 = x55 * (x102 * x508 + x504 * x56)
    x510 = x254 * x326 + x509
    x511 = x100 * x215
    x512 = x215 * x357 + x511
    x513 = x55 * (x502 * x62 + x512 * x56)
    x514 = x256 * x309
    x515 = x55 * (x256 * x307 + x514)
    x516 = x21 * x258 + x515
    x517 = x256 * x311
    x518 = x55 * (x256 * x312 + x517)
    x519 = x261 * x326 + x518
    x520 = x55 * (x256 * x331 + x256 * x333)
    x521 = x55 * (x104 * x471 + x227 * x52)
    x522 = x21 * x265 + x521
    x523 = x55 * (x104 * x472 + x227 * x58)
    x524 = x21 * x34
    x525 = x263 * x524 + x523
    x526 = x55 * (x100 * x227 + x104 * x479)
    x527 = x55 * (x104 * x481 + x234 * x52)
    x528 = x21 * x271 + x527
    x529 = x55 * (x104 * x482 + x234 * x58)
    x530 = x269 * x524 + x529
    x531 = x55 * (x100 * x234 + x104 * x489)
    x532 = x55 * (x104 * x491 + x242 * x52)
    x533 = x21 * x277 + x532
    x534 = x55 * (x104 * x492 + x242 * x58)
    x535 = x276 * x524 + x534
    x536 = x55 * (x100 * x242 + x104 * x499)
    x537 = x55 * (x104 * x502 + x249 * x52)
    x538 = x21 * x282 + x537
    x539 = x55 * (x104 * x504 + x249 * x58)
    x540 = x281 * x524 + x539
    x541 = x55 * (x100 * x249 + x104 * x512)
    x542 = x256 * x52
    x543 = x55 * (x256 * x335 + x542)
    x544 = x21 * x287 + x543
    x545 = x256 * x58
    x546 = x55 * (x256 * x337 + x545)
    x547 = x286 * x524 + x546
    x548 = x100 * x256
    x549 = x55 * (x256 * x357 + x548)
    x550 = x289 * x306
    x551 = x21 * x291 + x550
    x552 = x289 * x301
    x553 = x289 * x524 + x552
    x554 = x289 * x330
    x555 = -x11 - A[2]
    x556 = x12 * x36 - 2.0 * x18 * x2 * x20 * x23 * x28 * x29 * x555
    x557 = -x556
    x558 = x16 * x557
    x559 = x12 * x27 - 2.0 * x2 * x20 * x23 * x28 * x29 * x30 * x555
    x560 = x6 * (-x558 - x559)
    x561 = -x559
    x562 = x4 * x558 - x5 * x561
    x563 = -x562
    x564 = -x12 * x45 + 2.0 * x2 * x20 * x23 * x28 * x29 * x35 * x555
    x565 = x16 * x564
    x566 = -x4 * x565 + x5 * x557
    x567 = x16 * x566
    x568 = -x4 * x567 + x5 * x563 + x560
    x569 = x4 * x568
    x570 = x563 * x6
    x571 = 2.0 * x570
    x572 = x569 + x571
    x573 = x561 * x6
    x574 = x4 * x563
    x575 = x573 + x574
    x576 = x56 * x572 + x575 * x68
    x577 = x56 * x573 + x56 * x575
    x578 = x56 * x576 + x577 * x68
    x579 = x317 * x573 + x56 * x577
    x580 = x56 * x578 + x579 * x68
    x581 = x320 * x573 + x56 * x579
    x582 = x55 * (x56 * x580 + x581 * x68)
    x583 = x22 * x86 + x582
    x584 = x55 * (x324 * x573 + x56 * x581)
    x585 = x22 * x55
    x586 = x584 + x585 * x92
    x587 = x6 * (-x556 - x565)
    x588 = -x12 * x96 + 2.0 * x2 * x20 * x23 * x28 * x29 * x44 * x555
    x589 = (
        x42 * (-x562 - x567)
        + x5 * x568
        - x97 * (x5 * x566 + x587 - x97 * (x5 * x564 - x588 * x97))
    )
    x590 = x4 * x589
    x591 = x568 * x6
    x592 = 3.0 * x591
    x593 = x55 * (
        x56 * (x56 * (x56 * (x56 * (x590 + x592) + x572 * x62) + x576 * x62) + x578 * x62)
        + x580 * x62
    )
    x594 = x104 * x569 + x104 * x571
    x595 = x104 * x573
    x596 = x104 * x574 + x595
    x597 = x56 * x594 + x596 * x68
    x598 = x154 * x4
    x599 = x56 * x596 + x573 * x598
    x600 = x56 * x597 + x599 * x68
    x601 = x573 * x9
    x602 = x350 * x601 + x56 * x599
    x603 = x55 * (x56 * x600 + x602 * x68)
    x604 = x120 * x22 + x603
    x605 = x55 * (x354 * x601 + x56 * x602)
    x606 = x123 * x585 + x605
    x607 = x55 * (
        x56 * (x56 * (x56 * (x104 * x590 + x104 * x592) + x594 * x62) + x597 * x62)
        + x600 * x62
    )
    x608 = x12 * x568 + x52
    x609 = x12 * x563 + x58
    x610 = x609 * x68
    x611 = x56 * x608 + x610
    x612 = x12 * x561 + x66
    x613 = x102 * x612
    x614 = x56 * x609 + x613
    x615 = x56 * x611 + x614 * x68
    x616 = x429 * x612 + x56 * x614
    x617 = x56 * x615 + x616 * x68
    x618 = x6 * x612
    x619 = x350 * x618 + x56 * x616
    x620 = x55 * (x56 * x617 + x619 * x68)
    x621 = x136 * x22 + x620
    x622 = x55 * (x354 * x618 + x56 * x619)
    x623 = x138 * x585 + x622
    x624 = x100 + x12 * x589
    x625 = x55 * (
        x56 * (x56 * (x56 * (x56 * x624 + x608 * x62) + x611 * x62) + x615 * x62)
        + x617 * x62
    )
    x626 = x140 * x569 + x140 * x571
    x627 = x140 * x573
    x628 = x140 * x574 + x627
    x629 = x56 * x626 + x628 * x68
    x630 = x194 * x4
    x631 = x56 * x628 + x573 * x630
    x632 = x55 * (x56 * x629 + x631 * x68)
    x633 = x150 * x22 + x632
    x634 = x10 * x417
    x635 = x55 * (x56 * x631 + x573 * x634)
    x636 = x153 * x585 + x635
    x637 = x55 * (x56 * (x56 * (x140 * x590 + x140 * x592) + x62 * x626) + x62 * x629)
    x638 = x42 * x609
    x639 = x154 * x638 + x598 * x608
    x640 = x154 * x618
    x641 = x598 * x609 + x640
    x642 = x56 * x639 + x641 * x68
    x643 = x204 * x4
    x644 = x56 * x641 + x618 * x643
    x645 = x55 * (x56 * x642 + x644 * x68)
    x646 = x165 * x22 + x645
    x647 = x226 * x618
    x648 = x55 * (x117 * x647 + x56 * x644)
    x649 = x168 * x585 + x648
    x650 = x608 * x61
    x651 = x55 * (x56 * (x56 * (x154 * x650 + x598 * x624) + x62 * x639) + x62 * x642)
    x652 = x124 * x608 + x389
    x653 = x124 * x609 + x391
    x654 = x653 * x68
    x655 = x56 * x652 + x654
    x656 = x124 * x612 + x128
    x657 = x102 * x656
    x658 = x56 * x653 + x657
    x659 = x56 * x655 + x658 * x68
    x660 = x429 * x656 + x56 * x658
    x661 = x55 * (x56 * x659 + x660 * x68)
    x662 = x179 * x22 + x661
    x663 = x6 * x656
    x664 = x55 * (x350 * x663 + x56 * x660)
    x665 = x181 * x585 + x664
    x666 = x124 * x624 + x404
    x667 = x55 * (x56 * (x56 * (x56 * x666 + x62 * x652) + x62 * x655) + x62 * x659)
    x668 = x184 * x569 + x184 * x571
    x669 = x184 * x573
    x670 = x184 * x574 + x669
    x671 = x55 * (x56 * x668 + x670 * x68)
    x672 = x190 * x22 + x671
    x673 = x233 * x4
    x674 = x55 * (x56 * x670 + x573 * x673)
    x675 = x193 * x585 + x674
    x676 = x55 * (x56 * (x184 * x590 + x184 * x592) + x62 * x668)
    x677 = x194 * x638 + x608 * x630
    x678 = x194 * x618
    x679 = x609 * x630 + x678
    x680 = x55 * (x56 * x677 + x679 * x68)
    x681 = x201 * x22 + x680
    x682 = x55 * (x148 * x647 + x56 * x679)
    x683 = x203 * x585 + x682
    x684 = x55 * (x56 * (x194 * x650 + x624 * x630) + x62 * x677)
    x685 = x42 * x653
    x686 = x154 * x685 + x598 * x652
    x687 = x154 * x663
    x688 = x598 * x653 + x687
    x689 = x55 * (x56 * x686 + x68 * x688)
    x690 = x211 * x22 + x689
    x691 = x55 * (x56 * x688 + x643 * x663)
    x692 = x213 * x585 + x691
    x693 = x61 * x652
    x694 = x55 * (x56 * (x154 * x693 + x598 * x666) + x62 * x686)
    x695 = x124 * x652 + x446
    x696 = x124 * x653 + x448
    x697 = x68 * x696
    x698 = x56 * x695 + x697
    x699 = x124 * x656 + x173
    x700 = x102 * x699
    x701 = x56 * x696 + x700
    x702 = x55 * (x56 * x698 + x68 * x701)
    x703 = x22 * x221 + x702
    x704 = x55 * (x429 * x699 + x56 * x701)
    x705 = x224 * x585 + x704
    x706 = x124 * x666 + x458
    x707 = x55 * (x56 * (x56 * x706 + x62 * x695) + x62 * x698)
    x708 = x55 * (x227 * x569 + x227 * x571)
    x709 = x22 * x229 + x708
    x710 = x227 * x573
    x711 = x55 * (x227 * x574 + x710)
    x712 = x232 * x585 + x711
    x713 = x55 * (x227 * x590 + x227 * x592)
    x714 = x55 * (x233 * x638 + x608 * x673)
    x715 = x22 * x236 + x714
    x716 = x233 * x618
    x717 = x55 * (x609 * x673 + x716)
    x718 = x239 * x585 + x717
    x719 = x55 * (x233 * x650 + x624 * x673)
    x720 = x55 * (x194 * x685 + x630 * x652)
    x721 = x22 * x244 + x720
    x722 = x194 * x663
    x723 = x55 * (x630 * x653 + x722)
    x724 = x247 * x585 + x723
    x725 = x55 * (x194 * x693 + x630 * x666)
    x726 = x154 * x42
    x727 = x55 * (x598 * x695 + x696 * x726)
    x728 = x22 * x251 + x727
    x729 = x154 * x6
    x730 = x699 * x729
    x731 = x55 * (x598 * x696 + x730)
    x732 = x254 * x585 + x731
    x733 = x55 * (x154 * x61 * x695 + x598 * x706)
    x734 = x124 * x695 + x501
    x735 = x124 * x696 + x503
    x736 = x68 * x735
    x737 = x55 * (x56 * x734 + x736)
    x738 = x22 * x258 + x737
    x739 = x124 * x699 + x219
    x740 = x102 * x739
    x741 = x55 * (x56 * x735 + x740)
    x742 = x261 * x585 + x741
    x743 = x124 * x706 + x511
    x744 = x55 * (x56 * x743 + x62 * x734)
    x745 = x263 * x568
    x746 = x22 * x265 + x745
    x747 = x263 * x563
    x748 = x22 * x34
    x749 = x263 * x748 + x747
    x750 = x263 * x589
    x751 = x268 * x608
    x752 = x22 * x271 + x751
    x753 = x268 * x609
    x754 = x269 * x748 + x753
    x755 = x268 * x624
    x756 = x233 * x652
    x757 = x22 * x277 + x756
    x758 = x233 * x653
    x759 = x276 * x748 + x758
    x760 = x233 * x666
    x761 = x194 * x695
    x762 = x22 * x282 + x761
    x763 = x194 * x696
    x764 = x281 * x748 + x763
    x765 = x194 * x706
    x766 = x154 * x734
    x767 = x22 * x287 + x766
    x768 = x154 * x735
    x769 = x286 * x748 + x768
    x770 = x154 * x743
    x771 = x55 * (x124 * x734 + x542)
    x772 = x22 * x291 + x771
    x773 = x55 * (x124 * x735 + x545)
    x774 = x289 * x748 + x773
    x775 = x55 * (x124 * x743 + x548)
    x776 = x296 * x9
    x777 = x293 * x299 + x32 - x776
    x778 = x6 * x777
    x779 = x293 * x295 - x303 * x9 + x43
    x780 = x16 * x779
    x781 = -x4 * x780 + x5 * x777
    x782 = x4 * x781
    x783 = x778 + x782
    x784 = x56 * x778 + x56 * x783
    x785 = x317 * x778 + x56 * x784
    x786 = x320 * x778 + x56 * x785
    x787 = x55 * (x324 * x778 + x56 * x786)
    x788 = x21 * x325 + x787
    x789 = x21 * x327 + x788
    x790 = x6 * (x293 * x299 - x776 - x780 - x94)
    x791 = x16 * x9
    x792 = x293 * x302 - x329 * x791 + x95
    x793 = x5 * x781 + x790 - x97 * (x5 * x779 - x792 * x97)
    x794 = x4 * x793
    x795 = x6 * x781
    x796 = 2.0 * x795
    x797 = x21 * x322 + x55 * (
        x56 * (x56 * (x56 * (x56 * (x794 + x796) + x68 * x783) + x68 * x784) + x68 * x785)
        + x68 * x786
    )
    x798 = x777 * x9
    x799 = 2.0 * x311
    x800 = x798 + x799
    x801 = x781 * x9
    x802 = x309 + x801
    x803 = x102 * x800 + x56 * x802
    x804 = x429 * x800 + x56 * x803
    x805 = x6 * x800
    x806 = x350 * x805 + x56 * x804
    x807 = x55 * (x354 * x805 + x56 * x806)
    x808 = x21 * x355 + x807
    x809 = x21 * x356 + x808
    x810 = x793 * x9
    x811 = 2.0 * x332
    x812 = x810 + x811
    x813 = x21 * x352 + x55 * (
        x56 * (x56 * (x56 * (x56 * x812 + x68 * x802) + x68 * x803) + x68 * x804)
        + x68 * x806
    )
    x814 = x124 * x778
    x815 = x124 * x782 + x814
    x816 = x12 * x778
    x817 = x346 * x816 + x56 * x815
    x818 = x350 * x816 + x56 * x817
    x819 = x55 * (x354 * x816 + x56 * x818)
    x820 = x21 * x371 + x819
    x821 = x21 * x372 + x820
    x822 = x21 * x369 + x55 * (
        x56 * (x56 * (x56 * (x124 * x794 + x124 * x796) + x68 * x815) + x68 * x817)
        + x68 * x818
    )
    x823 = x104 * x800 + x343 * x42
    x824 = x104 * x802 + x339
    x825 = x102 * x823 + x56 * x824
    x826 = x429 * x823 + x56 * x825
    x827 = x350 * x6
    x828 = x55 * (x56 * x826 + x823 * x827)
    x829 = x21 * x385 + x828
    x830 = x21 * x386 + x829
    x831 = x104 * x812 + x336 * x68
    x832 = x21 * x383 + x55 * (
        x56 * (x56 * (x56 * x831 + x68 * x824) + x68 * x825) + x68 * x826
    )
    x833 = x124 * x798 + x124 * x799
    x834 = x124 * x801 + x360
    x835 = x102 * x833 + x56 * x834
    x836 = x429 * x833 + x56 * x835
    x837 = x55 * (x56 * x836 + x827 * x833)
    x838 = x21 * x402 + x837
    x839 = x21 * x403 + x838
    x840 = x124 * x810 + x124 * x811
    x841 = x21 * x400 + x55 * (
        x56 * (x56 * (x56 * x840 + x68 * x834) + x68 * x835) + x68 * x836
    )
    x842 = x169 * x778
    x843 = x169 * x782 + x842
    x844 = x13 * x778
    x845 = x413 * x844 + x56 * x843
    x846 = x55 * (x417 * x844 + x56 * x845)
    x847 = x21 * x418 + x846
    x848 = x21 * x419 + x847
    x849 = x21 * x415 + x55 * (
        x56 * (x56 * (x169 * x794 + x169 * x796) + x68 * x843) + x68 * x845
    )
    x850 = x104 * x823 + x378 * x68
    x851 = x104 * x824 + x376
    x852 = x102 * x850 + x56 * x851
    x853 = x55 * (x429 * x850 + x56 * x852)
    x854 = x21 * x430 + x853
    x855 = x21 * x431 + x854
    x856 = x104 * x831 + x374 * x68
    x857 = x21 * x427 + x55 * (x56 * (x56 * x856 + x68 * x851) + x68 * x852)
    x858 = x104 * x833 + x395 * x68
    x859 = x104 * x834 + x393
    x860 = x102 * x858 + x56 * x859
    x861 = x55 * (x429 * x858 + x56 * x860)
    x862 = x21 * x442 + x861
    x863 = x21 * x443 + x862
    x864 = x104 * x840 + x390 * x68
    x865 = x21 * x440 + x55 * (x56 * (x56 * x864 + x68 * x859) + x68 * x860)
    x866 = x169 * x798 + x169 * x799
    x867 = x169 * x801 + x407
    x868 = x102 * x866 + x56 * x867
    x869 = x55 * (x429 * x866 + x56 * x868)
    x870 = x21 * x456 + x869
    x871 = x21 * x457 + x870
    x872 = x169 * x810 + x169 * x811
    x873 = x21 * x454 + x55 * (x56 * (x56 * x872 + x68 * x867) + x68 * x868)
    x874 = x215 * x778
    x875 = x215 * x782 + x874
    x876 = x55 * (x467 * x778 + x56 * x875)
    x877 = x21 * x468 + x876
    x878 = x21 * x469 + x877
    x879 = x21 * x465 + x55 * (x56 * (x215 * x794 + x215 * x796) + x68 * x875)
    x880 = x104 * x850 + x425 * x68
    x881 = x104 * x851 + x423
    x882 = x55 * (x102 * x880 + x56 * x881)
    x883 = x21 * x477 + x882
    x884 = x21 * x478 + x883
    x885 = x104 * x856 + x421 * x68
    x886 = x21 * x474 + x55 * (x56 * x885 + x68 * x881)
    x887 = x104 * x858 + x438 * x68
    x888 = x104 * x859 + x436
    x889 = x55 * (x102 * x887 + x56 * x888)
    x890 = x21 * x487 + x889
    x891 = x21 * x488 + x890
    x892 = x104 * x864 + x434 * x68
    x893 = x21 * x484 + x55 * (x56 * x892 + x68 * x888)
    x894 = x104 * x866 + x452 * x68
    x895 = x104 * x867 + x450
    x896 = x55 * (x102 * x894 + x56 * x895)
    x897 = x21 * x497 + x896
    x898 = x21 * x498 + x897
    x899 = x104 * x872 + x447 * x68
    x900 = x21 * x494 + x55 * (x56 * x899 + x68 * x895)
    x901 = x215 * x798 + x215 * x799
    x902 = x215 * x801 + x461
    x903 = x55 * (x102 * x901 + x56 * x902)
    x904 = x21 * x509 + x903
    x905 = x21 * x510 + x904
    x906 = x215 * x810 + x215 * x811
    x907 = x21 * x506 + x55 * (x56 * x906 + x68 * x902)
    x908 = x256 * x778
    x909 = x55 * (x256 * x782 + x908)
    x910 = x21 * x518 + x909
    x911 = x21 * x519 + x910
    x912 = x21 * x515 + x55 * (x256 * x794 + x256 * x796)
    x913 = x55 * (x104 * x881 + x473)
    x914 = x21 * x523 + x913
    x915 = x21 * x525 + x914
    x916 = x21 * x521 + x55 * (x104 * x885 + x471 * x68)
    x917 = x55 * (x104 * x888 + x483)
    x918 = x21 * x529 + x917
    x919 = x21 * x530 + x918
    x920 = x21 * x527 + x55 * (x104 * x892 + x481 * x68)
    x921 = x55 * (x104 * x895 + x493)
    x922 = x21 * x534 + x921
    x923 = x21 * x535 + x922
    x924 = x21 * x532 + x55 * (x104 * x899 + x491 * x68)
    x925 = x55 * (x104 * x902 + x505)
    x926 = x21 * x539 + x925
    x927 = x21 * x540 + x926
    x928 = x21 * x537 + x55 * (x104 * x906 + x502 * x68)
    x929 = x55 * (x256 * x801 + x514)
    x930 = x21 * x546 + x929
    x931 = x21 * x547 + x930
    x932 = x21 * x543 + x55 * (x256 * x810 + x256 * x811)
    x933 = x289 * x781
    x934 = x21 * x552 + x933
    x935 = x21 * x553 + x934
    x936 = x21 * x550 + x289 * x793
    x937 = -x293 * x561 + x558 * x9
    x938 = -x937
    x939 = x6 * x938
    x940 = x293 * x557 - x565 * x9
    x941 = x16 * x940
    x942 = -x4 * x941 + x5 * x938
    x943 = x4 * x942 + x939
    x944 = x56 * x939 + x56 * x943
    x945 = x317 * x939 + x56 * x944
    x946 = x320 * x939 + x56 * x945
    x947 = x55 * (x324 * x939 + x56 * x946)
    x948 = x22 * x325 + x947
    x949 = x21 * x586 + x948
    x950 = x6 * (-x937 - x941)
    x951 = x293 * x564 - x588 * x791
    x952 = x5 * x942 + x950 - x97 * (x5 * x940 - x951 * x97)
    x953 = x42 * x942
    x954 = x55 * (
        x56
        * (
            x56 * (x56 * (x56 * (x4 * x952 + x953) + x68 * x943) + x68 * x944)
            + x68 * x945
        )
        + x68 * x946
    )
    x955 = x22 * x322 + x954
    x956 = x573 + x9 * x938
    x957 = x570 + x9 * x942
    x958 = x102 * x956 + x56 * x957
    x959 = x429 * x956 + x56 * x958
    x960 = x56 * x959 + x827 * x956
    x961 = x354 * x6
    x962 = x55 * (x56 * x960 + x956 * x961)
    x963 = x22 * x355 + x962
    x964 = x21 * x606 + x963
    x965 = x591 + x9 * x952
    x966 = x68 * x957
    x967 = x55 * (
        x56 * (x56 * (x56 * (x56 * x965 + x966) + x68 * x958) + x68 * x959) + x68 * x960
    )
    x968 = x22 * x352 + x967
    x969 = x12 * x938 + x311
    x970 = x12 * x942 + x308
    x971 = x102 * x969 + x56 * x970
    x972 = x429 * x969 + x56 * x971
    x973 = x56 * x972 + x827 * x969
    x974 = x55 * (x56 * x973 + x961 * x969)
    x975 = x22 * x371 + x974
    x976 = x21 * x623 + x975
    x977 = x12 * x952 + x332
    x978 = x68 * x970
    x979 = x55 * (
        x56 * (x56 * (x56 * (x56 * x977 + x978) + x68 * x971) + x68 * x972) + x68 * x973
    )
    x980 = x22 * x369 + x979
    x981 = x104 * x956 + x595
    x982 = x104 * x570 + x104 * x957
    x983 = x102 * x981 + x56 * x982
    x984 = x429 * x981 + x56 * x983
    x985 = x55 * (x56 * x984 + x827 * x981)
    x986 = x22 * x385 + x985
    x987 = x21 * x636 + x986
    x988 = x104 * x591 + x104 * x965
    x989 = x68 * x982
    x990 = x55 * (x56 * (x56 * (x56 * x988 + x989) + x68 * x983) + x68 * x984)
    x991 = x22 * x383 + x990
    x992 = x104 * x969 + x613
    x993 = x102 * x609 + x104 * x970
    x994 = x102 * x992 + x56 * x993
    x995 = x429 * x992 + x56 * x994
    x996 = x55 * (x56 * x995 + x827 * x992)
    x997 = x22 * x402 + x996
    x998 = x21 * x649 + x997
    x999 = x102 * x608 + x104 * x977
    x1000 = x68 * x993
    x1001 = x55 * (x56 * (x56 * (x1000 + x56 * x999) + x68 * x994) + x68 * x995)
    x1002 = x1001 + x22 * x400
    x1003 = x124 * x969 + x362
    x1004 = x124 * x308 + x124 * x970
    x1005 = x1003 * x102 + x1004 * x56
    x1006 = x1003 * x429 + x1005 * x56
    x1007 = x55 * (x1003 * x827 + x1006 * x56)
    x1008 = x1007 + x22 * x418
    x1009 = x1008 + x21 * x665
    x1010 = x124 * x332 + x124 * x977
    x1011 = x1004 * x68
    x1012 = x55 * (x1006 * x68 + x56 * (x1005 * x68 + x56 * (x1010 * x56 + x1011)))
    x1013 = x1012 + x22 * x415
    x1014 = x104 * x981 + x627
    x1015 = x104 * x982 + x140 * x570
    x1016 = x1014 * x102 + x1015 * x56
    x1017 = x55 * (x1014 * x429 + x1016 * x56)
    x1018 = x1017 + x22 * x430
    x1019 = x1018 + x21 * x675
    x1020 = x104 * x988 + x140 * x591
    x1021 = x1015 * x68
    x1022 = x55 * (x1016 * x68 + x56 * (x1020 * x56 + x1021))
    x1023 = x1022 + x22 * x427
    x1024 = x104 * x992 + x640
    x1025 = x104 * x993 + x609 * x729
    x1026 = x102 * x1024 + x1025 * x56
    x1027 = x55 * (x1024 * x429 + x1026 * x56)
    x1028 = x1027 + x22 * x442
    x1029 = x1028 + x21 * x683
    x1030 = x104 * x999 + x608 * x729
    x1031 = x1025 * x68
    x1032 = x55 * (x1026 * x68 + x56 * (x1030 * x56 + x1031))
    x1033 = x1032 + x22 * x440
    x1034 = x1003 * x104 + x657
    x1035 = x1004 * x104 + x102 * x653
    x1036 = x102 * x1034 + x1035 * x56
    x1037 = x55 * (x1034 * x429 + x1036 * x56)
    x1038 = x1037 + x22 * x456
    x1039 = x1038 + x21 * x692
    x1040 = x1010 * x104 + x102 * x652
    x1041 = x1035 * x68
    x1042 = x55 * (x1036 * x68 + x56 * (x1040 * x56 + x1041))
    x1043 = x1042 + x22 * x454
    x1044 = x1003 * x124 + x409
    x1045 = x1004 * x124 + x169 * x308
    x1046 = x102 * x1044 + x1045 * x56
    x1047 = x55 * (x1044 * x429 + x1046 * x56)
    x1048 = x1047 + x22 * x468
    x1049 = x1048 + x21 * x705
    x1050 = x1010 * x124 + x169 * x332
    x1051 = x1045 * x68
    x1052 = x55 * (x1046 * x68 + x56 * (x1050 * x56 + x1051))
    x1053 = x1052 + x22 * x465
    x1054 = x1014 * x104 + x669
    x1055 = x1015 * x104 + x184 * x570
    x1056 = x55 * (x102 * x1054 + x1055 * x56)
    x1057 = x1056 + x22 * x477
    x1058 = x1057 + x21 * x712
    x1059 = x1020 * x104 + x184 * x591
    x1060 = x1055 * x68
    x1061 = x55 * (x1059 * x56 + x1060)
    x1062 = x1061 + x22 * x474
    x1063 = x1024 * x104 + x678
    x1064 = x194 * x6
    x1065 = x1025 * x104 + x1064 * x609
    x1066 = x55 * (x102 * x1063 + x1065 * x56)
    x1067 = x1066 + x22 * x487
    x1068 = x1067 + x21 * x718
    x1069 = x1030 * x104 + x1064 * x608
    x1070 = x1065 * x68
    x1071 = x55 * (x1069 * x56 + x1070)
    x1072 = x1071 + x22 * x484
    x1073 = x1034 * x104 + x687
    x1074 = x1035 * x104 + x653 * x729
    x1075 = x55 * (x102 * x1073 + x1074 * x56)
    x1076 = x1075 + x22 * x497
    x1077 = x1076 + x21 * x724
    x1078 = x104 * x1040 + x652 * x729
    x1079 = x1074 * x68
    x1080 = x55 * (x1078 * x56 + x1079)
    x1081 = x1080 + x22 * x494
    x1082 = x104 * x1044 + x700
    x1083 = x102 * x696 + x104 * x1045
    x1084 = x55 * (x102 * x1082 + x1083 * x56)
    x1085 = x1084 + x22 * x509
    x1086 = x1085 + x21 * x732
    x1087 = x102 * x695 + x104 * x1050
    x1088 = x1083 * x68
    x1089 = x55 * (x1087 * x56 + x1088)
    x1090 = x1089 + x22 * x506
    x1091 = x1044 * x124 + x463
    x1092 = x1045 * x124 + x215 * x308
    x1093 = x55 * (x102 * x1091 + x1092 * x56)
    x1094 = x1093 + x22 * x518
    x1095 = x1094 + x21 * x742
    x1096 = x1050 * x124 + x215 * x332
    x1097 = x1092 * x68
    x1098 = x55 * (x1096 * x56 + x1097)
    x1099 = x1098 + x22 * x515
    x1100 = x55 * (x104 * x1055 + x227 * x570)
    x1101 = x1100 + x22 * x523
    x1102 = x1101 + x21 * x749
    x1103 = x55 * (x104 * x1059 + x227 * x591)
    x1104 = x1103 + x22 * x521
    x1105 = x233 * x6
    x1106 = x55 * (x104 * x1065 + x1105 * x609)
    x1107 = x1106 + x22 * x529
    x1108 = x1107 + x21 * x754
    x1109 = x55 * (x104 * x1069 + x1105 * x608)
    x1110 = x1109 + x22 * x527
    x1111 = x55 * (x104 * x1074 + x1064 * x653)
    x1112 = x1111 + x22 * x534
    x1113 = x1112 + x21 * x759
    x1114 = x55 * (x104 * x1078 + x1064 * x652)
    x1115 = x1114 + x22 * x532
    x1116 = x55 * (x104 * x1083 + x696 * x729)
    x1117 = x1116 + x22 * x539
    x1118 = x1117 + x21 * x764
    x1119 = x55 * (x104 * x1087 + x695 * x729)
    x1120 = x1119 + x22 * x537
    x1121 = x55 * (x102 * x735 + x104 * x1092)
    x1122 = x1121 + x22 * x546
    x1123 = x1122 + x21 * x769
    x1124 = x55 * (x102 * x734 + x104 * x1096)
    x1125 = x1124 + x22 * x543
    x1126 = x55 * (x1092 * x124 + x256 * x308)
    x1127 = x1126 + x22 * x552
    x1128 = x1127 + x21 * x774
    x1129 = x55 * (x1096 * x124 + x256 * x332)
    x1130 = x1129 + x22 * x550
    x1131 = x12 * x558
    x1132 = -x1131 + x32 + x555 * x561
    x1133 = x1132 * x6
    x1134 = -x12 * x565 + x43 + x555 * x557
    x1135 = x1134 * x16
    x1136 = x1132 * x5 - x1135 * x4
    x1137 = x1136 * x4
    x1138 = x1133 + x1137
    x1139 = x1133 * x56 + x1138 * x56
    x1140 = x1133 * x317 + x1139 * x56
    x1141 = x1133 * x320 + x1140 * x56
    x1142 = x55 * (x1133 * x324 + x1141 * x56)
    x1143 = x1142 + x22 * x584
    x1144 = x1143 + x22 * x586
    x1145 = x6 * (-x1131 - x1135 + x555 * x561 - x94)
    x1146 = x12 * x16
    x1147 = -x1146 * x588 + x555 * x564 + x95
    x1148 = x1136 * x5 + x1145 - x97 * (x1134 * x5 - x1147 * x97)
    x1149 = x1148 * x4
    x1150 = x1136 * x6
    x1151 = 2.0 * x1150
    x1152 = x22 * x582 + x55 * (
        x1141 * x68
        + x56
        * (
            x1140 * x68
            + x56 * (x1139 * x68 + x56 * (x1138 * x68 + x56 * (x1149 + x1151)))
        )
    )
    x1153 = x104 * x1133
    x1154 = x104 * x1137 + x1153
    x1155 = x1133 * x598 + x1154 * x56
    x1156 = x1133 * x9
    x1157 = x1155 * x56 + x1156 * x350
    x1158 = x55 * (x1156 * x354 + x1157 * x56)
    x1159 = x1158 + x22 * x605
    x1160 = x1159 + x22 * x606
    x1161 = x22 * x603 + x55 * (
        x1157 * x68
        + x56 * (x1155 * x68 + x56 * (x1154 * x68 + x56 * (x104 * x1149 + x104 * x1151)))
    )
    x1162 = x1132 * x12 + 2.0 * x573
    x1163 = x102 * x1162
    x1164 = x1136 * x12 + x571
    x1165 = x1163 + x1164 * x56
    x1166 = x1162 * x429 + x1165 * x56
    x1167 = x1162 * x827 + x1166 * x56
    x1168 = x55 * (x1162 * x961 + x1167 * x56)
    x1169 = x1168 + x22 * x622
    x1170 = x1169 + x22 * x623
    x1171 = x1148 * x12 + 2.0 * x591
    x1172 = x22 * x620 + x55 * (
        x1167 * x68
        + x56 * (x1166 * x68 + x56 * (x1165 * x68 + x56 * (x1164 * x68 + x1171 * x56)))
    )
    x1173 = x1133 * x140
    x1174 = x1137 * x140 + x1173
    x1175 = x1133 * x630 + x1174 * x56
    x1176 = x55 * (x1133 * x634 + x1175 * x56)
    x1177 = x1176 + x22 * x635
    x1178 = x1177 + x22 * x636
    x1179 = x22 * x632 + x55 * (
        x1175 * x68 + x56 * (x1174 * x68 + x56 * (x1149 * x140 + x1151 * x140))
    )
    x1180 = x1162 * x729
    x1181 = x1164 * x598 + x1180
    x1182 = x1162 * x4
    x1183 = x1182 * x6
    x1184 = x1181 * x56 + x1183 * x204
    x1185 = x226 * x6
    x1186 = x117 * x1185
    x1187 = x55 * (x1162 * x1186 + x1184 * x56)
    x1188 = x1187 + x22 * x648
    x1189 = x1188 + x22 * x649
    x1190 = x22 * x645 + x55 * (
        x1184 * x68 + x56 * (x1181 * x68 + x56 * (x1164 * x726 + x1171 * x598))
    )
    x1191 = x1162 * x124 + x612 * x68
    x1192 = x102 * x1191
    x1193 = x1164 * x124 + x610
    x1194 = x1192 + x1193 * x56
    x1195 = x1191 * x429 + x1194 * x56
    x1196 = x55 * (x1191 * x827 + x1195 * x56)
    x1197 = x1196 + x22 * x664
    x1198 = x1197 + x22 * x665
    x1199 = x1171 * x124 + x608 * x68
    x1200 = x22 * x661 + x55 * (
        x1195 * x68 + x56 * (x1194 * x68 + x56 * (x1193 * x68 + x1199 * x56))
    )
    x1201 = x1133 * x184
    x1202 = x1137 * x184 + x1201
    x1203 = x55 * (x1133 * x673 + x1202 * x56)
    x1204 = x1203 + x22 * x674
    x1205 = x1204 + x22 * x675
    x1206 = x22 * x671 + x55 * (x1202 * x68 + x56 * (x1149 * x184 + x1151 * x184))
    x1207 = x1064 * x1162
    x1208 = x1164 * x630 + x1207
    x1209 = x55 * (x10 * x1183 * x226 + x1208 * x56)
    x1210 = x1209 + x22 * x682
    x1211 = x1210 + x22 * x683
    x1212 = x1164 * x42
    x1213 = x22 * x680 + x55 * (x1208 * x68 + x56 * (x1171 * x630 + x1212 * x194))
    x1214 = x1191 * x729
    x1215 = x1193 * x598 + x1214
    x1216 = x6 * x643
    x1217 = x55 * (x1191 * x1216 + x1215 * x56)
    x1218 = x1217 + x22 * x691
    x1219 = x1218 + x22 * x692
    x1220 = x22 * x689 + x55 * (x1215 * x68 + x56 * (x1193 * x726 + x1199 * x598))
    x1221 = x1191 * x124 + x656 * x68
    x1222 = x102 * x1221
    x1223 = x1193 * x124 + x654
    x1224 = x1222 + x1223 * x56
    x1225 = x55 * (x1221 * x429 + x1224 * x56)
    x1226 = x1225 + x22 * x704
    x1227 = x1226 + x22 * x705
    x1228 = x1199 * x124 + x652 * x68
    x1229 = x22 * x702 + x55 * (x1224 * x68 + x56 * (x1223 * x68 + x1228 * x56))
    x1230 = x1133 * x227
    x1231 = x55 * (x1137 * x227 + x1230)
    x1232 = x1231 + x22 * x711
    x1233 = x1232 + x22 * x712
    x1234 = x22 * x708 + x55 * (x1149 * x227 + x1151 * x227)
    x1235 = x1105 * x1162
    x1236 = x55 * (x1164 * x673 + x1235)
    x1237 = x1236 + x22 * x717
    x1238 = x1237 + x22 * x718
    x1239 = x22 * x714 + x55 * (x1171 * x673 + x1212 * x233)
    x1240 = x1064 * x1191
    x1241 = x55 * (x1193 * x630 + x1240)
    x1242 = x1241 + x22 * x723
    x1243 = x1242 + x22 * x724
    x1244 = x22 * x720 + x55 * (x1193 * x194 * x42 + x1199 * x630)
    x1245 = x1221 * x729
    x1246 = x55 * (x1223 * x598 + x1245)
    x1247 = x1246 + x22 * x731
    x1248 = x1247 + x22 * x732
    x1249 = x22 * x727 + x55 * (x1223 * x726 + x1228 * x598)
    x1250 = x1221 * x124 + x68 * x699
    x1251 = x102 * x1250
    x1252 = x1223 * x124 + x697
    x1253 = x55 * (x1251 + x1252 * x56)
    x1254 = x1253 + x22 * x741
    x1255 = x1254 + x22 * x742
    x1256 = x1228 * x124 + x68 * x695
    x1257 = x22 * x737 + x55 * (x1252 * x68 + x1256 * x56)
    x1258 = x1136 * x263
    x1259 = x1258 + x22 * x747
    x1260 = x1259 + x22 * x749
    x1261 = x1148 * x263 + x22 * x745
    x1262 = x1164 * x268
    x1263 = x1262 + x22 * x753
    x1264 = x1263 + x22 * x754
    x1265 = x1171 * x268 + x22 * x751
    x1266 = x1193 * x233
    x1267 = x1266 + x22 * x758
    x1268 = x1267 + x22 * x759
    x1269 = x1199 * x233 + x22 * x756
    x1270 = x1223 * x194
    x1271 = x1270 + x22 * x763
    x1272 = x1271 + x22 * x764
    x1273 = x1228 * x194 + x22 * x761
    x1274 = x1252 * x154
    x1275 = x1274 + x22 * x768
    x1276 = x1275 + x22 * x769
    x1277 = x1256 * x154 + x22 * x766
    x1278 = x55 * (x124 * x1252 + x736)
    x1279 = x1278 + x22 * x773
    x1280 = x1279 + x22 * x774
    x1281 = x22 * x771 + x55 * (x124 * x1256 + x68 * x734)
    x1282 = x293 * x777 + 2.0 * x298 - x780 * x9
    x1283 = x1282 * x6
    x1284 = x293 * x779 + 2.0 * x328 - x791 * x792
    x1285 = x1282 * x5 - x1284 * x97
    x1286 = x1285 * x4
    x1287 = (
        x21 * x787
        + x21 * x788
        + x55
        * (
            x1283 * x324
            + x56
            * (
                x1283 * x320
                + x56 * (x1283 * x317 + x56 * (x1283 * x56 + x56 * (x1283 + x1286)))
            )
        )
    )
    x1288 = x1282 * x9
    x1289 = 3.0 * x778
    x1290 = x1288 + x1289
    x1291 = x102 * x1290
    x1292 = x1285 * x9
    x1293 = 3.0 * x795
    x1294 = x1292 + x1293
    x1295 = (
        x21 * x807
        + x21 * x808
        + x55
        * (
            x1290 * x961
            + x56 * (x1290 * x827 + x56 * (x1290 * x429 + x56 * (x1291 + x1294 * x56)))
        )
    )
    x1296 = x124 * x1283
    x1297 = x12 * x1283
    x1298 = (
        x21 * x819
        + x21 * x820
        + x55
        * (
            x1297 * x354
            + x56 * (x1297 * x350 + x56 * (x1297 * x346 + x56 * (x124 * x1286 + x1296)))
        )
    )
    x1299 = x104 * x1290 + x62 * x800
    x1300 = x102 * x1299
    x1301 = x104 * x1294 + x62 * x802
    x1302 = (
        x21 * x828
        + x21 * x829
        + x55 * (x1299 * x827 + x56 * (x1299 * x429 + x56 * (x1300 + x1301 * x56)))
    )
    x1303 = x124 * x1288 + x124 * x1289
    x1304 = x102 * x1303
    x1305 = x124 * x1292 + x124 * x1293
    x1306 = (
        x21 * x837
        + x21 * x838
        + x55 * (x1303 * x827 + x56 * (x1303 * x429 + x56 * (x1304 + x1305 * x56)))
    )
    x1307 = x1283 * x169
    x1308 = x1283 * x13
    x1309 = (
        x21 * x846
        + x21 * x847
        + x55 * (x1308 * x417 + x56 * (x1308 * x413 + x56 * (x1286 * x169 + x1307)))
    )
    x1310 = x104 * x1299 + x62 * x823
    x1311 = x102 * x1310
    x1312 = x104 * x1301 + x62 * x824
    x1313 = x21 * x853 + x21 * x854 + x55 * (x1310 * x429 + x56 * (x1311 + x1312 * x56))
    x1314 = x104 * x1303 + x62 * x833
    x1315 = x102 * x1314
    x1316 = x104 * x1305 + x62 * x834
    x1317 = x21 * x861 + x21 * x862 + x55 * (x1314 * x429 + x56 * (x1315 + x1316 * x56))
    x1318 = x1288 * x169 + x1289 * x169
    x1319 = x102 * x1318
    x1320 = x1292 * x169 + x1293 * x169
    x1321 = x21 * x869 + x21 * x870 + x55 * (x1318 * x429 + x56 * (x1319 + x1320 * x56))
    x1322 = x1283 * x215
    x1323 = x21 * x876 + x21 * x877 + x55 * (x1283 * x467 + x56 * (x1286 * x215 + x1322))
    x1324 = x104 * x1310 + x62 * x850
    x1325 = x102 * x1324
    x1326 = x104 * x1312 + x62 * x851
    x1327 = x21 * x882 + x21 * x883 + x55 * (x1325 + x1326 * x56)
    x1328 = x104 * x1314 + x62 * x858
    x1329 = x102 * x1328
    x1330 = x104 * x1316 + x62 * x859
    x1331 = x21 * x889 + x21 * x890 + x55 * (x1329 + x1330 * x56)
    x1332 = x104 * x1318 + x62 * x866
    x1333 = x102 * x1332
    x1334 = x104 * x1320 + x62 * x867
    x1335 = x21 * x896 + x21 * x897 + x55 * (x1333 + x1334 * x56)
    x1336 = x1288 * x215 + x1289 * x215
    x1337 = x102 * x1336
    x1338 = x1292 * x215 + x1293 * x215
    x1339 = x21 * x903 + x21 * x904 + x55 * (x1337 + x1338 * x56)
    x1340 = x1283 * x256
    x1341 = x21 * x909 + x21 * x910 + x55 * (x1286 * x256 + x1340)
    x1342 = x21 * x913 + x21 * x914 + x55 * (x104 * x1326 + x62 * x881)
    x1343 = x21 * x917 + x21 * x918 + x55 * (x104 * x1330 + x62 * x888)
    x1344 = x21 * x921 + x21 * x922 + x55 * (x104 * x1334 + x62 * x895)
    x1345 = x21 * x925 + x21 * x926 + x55 * (x104 * x1338 + x62 * x902)
    x1346 = x21 * x929 + x21 * x930 + x55 * (x1292 * x256 + x1293 * x256)
    x1347 = x1285 * x289 + x21 * x933 + x21 * x934
    x1348 = x293 * x938 + x560 - x9 * x941
    x1349 = x1348 * x6
    x1350 = x293 * x940 + x587 - x791 * x951
    x1351 = x1348 * x5 - x1350 * x97
    x1352 = x55 * (
        x1349 * x324
        + x56
        * (
            x1349 * x320
            + x56 * (x1349 * x317 + x56 * (x1349 * x56 + x56 * (x1349 + x1351 * x4)))
        )
    )
    x1353 = x1352 + x21 * x948 + x22 * x787
    x1354 = 2.0 * x939
    x1355 = x1348 * x9 + x1354
    x1356 = x1351 * x9 + x953
    x1357 = x55 * (
        x1355 * x961
        + x56 * (x1355 * x827 + x56 * (x1355 * x429 + x56 * (x102 * x1355 + x1356 * x56)))
    )
    x1358 = x1357 + x21 * x963 + x22 * x807
    x1359 = x12 * x1348 + x778
    x1360 = x12 * x1351 + x795
    x1361 = x55 * (
        x1359 * x961
        + x56 * (x1359 * x827 + x56 * (x1359 * x429 + x56 * (x102 * x1359 + x1360 * x56)))
    )
    x1362 = x1361 + x21 * x975 + x22 * x819
    x1363 = x104 * x1355 + x68 * x956
    x1364 = x104 * x1356 + x966
    x1365 = x55 * (
        x1363 * x827 + x56 * (x1363 * x429 + x56 * (x102 * x1363 + x1364 * x56))
    )
    x1366 = x1365 + x21 * x986 + x22 * x828
    x1367 = x68 * x969
    x1368 = x104 * x1359 + x1367
    x1369 = x104 * x1360 + x978
    x1370 = x55 * (
        x1368 * x827 + x56 * (x1368 * x429 + x56 * (x102 * x1368 + x1369 * x56))
    )
    x1371 = x1370 + x21 * x997 + x22 * x837
    x1372 = x124 * x1359 + x814
    x1373 = x124 * x1360 + x124 * x795
    x1374 = x55 * (
        x1372 * x827 + x56 * (x1372 * x429 + x56 * (x102 * x1372 + x1373 * x56))
    )
    x1375 = x1008 * x21 + x1374 + x22 * x846
    x1376 = x104 * x1363 + x68 * x981
    x1377 = x104 * x1364 + x989
    x1378 = x55 * (x1376 * x429 + x56 * (x102 * x1376 + x1377 * x56))
    x1379 = x1018 * x21 + x1378 + x22 * x853
    x1380 = x104 * x1368 + x68 * x992
    x1381 = x1000 + x104 * x1369
    x1382 = x55 * (x1380 * x429 + x56 * (x102 * x1380 + x1381 * x56))
    x1383 = x1028 * x21 + x1382 + x22 * x861
    x1384 = x1003 * x68
    x1385 = x104 * x1372 + x1384
    x1386 = x1011 + x104 * x1373
    x1387 = x55 * (x1385 * x429 + x56 * (x102 * x1385 + x1386 * x56))
    x1388 = x1038 * x21 + x1387 + x22 * x869
    x1389 = x124 * x1372 + x842
    x1390 = x124 * x1373 + x169 * x795
    x1391 = x55 * (x1389 * x429 + x56 * (x102 * x1389 + x1390 * x56))
    x1392 = x1048 * x21 + x1391 + x22 * x876
    x1393 = x1014 * x68 + x104 * x1376
    x1394 = x1021 + x104 * x1377
    x1395 = x55 * (x102 * x1393 + x1394 * x56)
    x1396 = x1057 * x21 + x1395 + x22 * x882
    x1397 = x1024 * x68 + x104 * x1380
    x1398 = x1031 + x104 * x1381
    x1399 = x55 * (x102 * x1397 + x1398 * x56)
    x1400 = x1067 * x21 + x1399 + x22 * x889
    x1401 = x1034 * x68 + x104 * x1385
    x1402 = x104 * x1386 + x1041
    x1403 = x55 * (x102 * x1401 + x1402 * x56)
    x1404 = x1076 * x21 + x1403 + x22 * x896
    x1405 = x1044 * x68
    x1406 = x104 * x1389 + x1405
    x1407 = x104 * x1390 + x1051
    x1408 = x55 * (x102 * x1406 + x1407 * x56)
    x1409 = x1085 * x21 + x1408 + x22 * x903
    x1410 = x124 * x1389 + x874
    x1411 = x124 * x1390 + x215 * x795
    x1412 = x55 * (x102 * x1410 + x1411 * x56)
    x1413 = x1094 * x21 + x1412 + x22 * x909
    x1414 = x55 * (x104 * x1394 + x1060)
    x1415 = x1101 * x21 + x1414 + x22 * x913
    x1416 = x55 * (x104 * x1398 + x1070)
    x1417 = x1107 * x21 + x1416 + x22 * x917
    x1418 = x55 * (x104 * x1402 + x1079)
    x1419 = x1112 * x21 + x1418 + x22 * x921
    x1420 = x55 * (x104 * x1407 + x1088)
    x1421 = x1117 * x21 + x1420 + x22 * x925
    x1422 = x55 * (x104 * x1411 + x1097)
    x1423 = x1122 * x21 + x1422 + x22 * x929
    x1424 = x55 * (x124 * x1411 + x256 * x795)
    x1425 = x1127 * x21 + x1424 + x22 * x933
    x1426 = x1132 * x293 - x1135 * x9
    x1427 = x1426 * x6
    x1428 = x1134 * x293 - x1147 * x791
    x1429 = x1426 * x5 - x1428 * x97
    x1430 = x22 * x947 + x55 * (
        x1427 * x324
        + x56
        * (
            x1427 * x320
            + x56 * (x1427 * x317 + x56 * (x1427 * x56 + x56 * (x1427 + x1429 * x4)))
        )
    )
    x1431 = x1430 + x22 * x948
    x1432 = x1133 + x1426 * x9
    x1433 = x1150 + x1429 * x9
    x1434 = x22 * x962 + x55 * (
        x1432 * x961
        + x56 * (x1432 * x827 + x56 * (x1432 * x429 + x56 * (x102 * x1432 + x1433 * x56)))
    )
    x1435 = x1434 + x22 * x963
    x1436 = x12 * x1426 + x1354
    x1437 = x12 * x1429 + x953
    x1438 = x22 * x974 + x55 * (
        x1436 * x961
        + x56 * (x1436 * x827 + x56 * (x1436 * x429 + x56 * (x102 * x1436 + x1437 * x56)))
    )
    x1439 = x1438 + x22 * x975
    x1440 = x104 * x1432 + x1153
    x1441 = x104 * x1150 + x104 * x1433
    x1442 = x22 * x985 + x55 * (
        x1440 * x827 + x56 * (x1440 * x429 + x56 * (x102 * x1440 + x1441 * x56))
    )
    x1443 = x1442 + x22 * x986
    x1444 = x104 * x1436 + x1163
    x1445 = x102 * x1164 + x104 * x1437
    x1446 = x22 * x996 + x55 * (
        x1444 * x827 + x56 * (x1444 * x429 + x56 * (x102 * x1444 + x1445 * x56))
    )
    x1447 = x1446 + x22 * x997
    x1448 = x124 * x1436 + x1367
    x1449 = x124 * x1437 + x978
    x1450 = x1007 * x22 + x55 * (
        x1448 * x827 + x56 * (x1448 * x429 + x56 * (x102 * x1448 + x1449 * x56))
    )
    x1451 = x1008 * x22 + x1450
    x1452 = x104 * x1440 + x1173
    x1453 = x104 * x1441 + x1150 * x140
    x1454 = x1017 * x22 + x55 * (x1452 * x429 + x56 * (x102 * x1452 + x1453 * x56))
    x1455 = x1018 * x22 + x1454
    x1456 = x104 * x1444 + x1180
    x1457 = x104 * x1445 + x1164 * x729
    x1458 = x1027 * x22 + x55 * (x1456 * x429 + x56 * (x102 * x1456 + x1457 * x56))
    x1459 = x1028 * x22 + x1458
    x1460 = x104 * x1448 + x1192
    x1461 = x102 * x1193 + x104 * x1449
    x1462 = x1037 * x22 + x55 * (x1460 * x429 + x56 * (x102 * x1460 + x1461 * x56))
    x1463 = x1038 * x22 + x1462
    x1464 = x124 * x1448 + x1384
    x1465 = x1011 + x124 * x1449
    x1466 = x1047 * x22 + x55 * (x1464 * x429 + x56 * (x102 * x1464 + x1465 * x56))
    x1467 = x1048 * x22 + x1466
    x1468 = x104 * x1452 + x1201
    x1469 = x104 * x1453 + x1150 * x184
    x1470 = x1056 * x22 + x55 * (x102 * x1468 + x1469 * x56)
    x1471 = x1057 * x22 + x1470
    x1472 = x104 * x1456 + x1207
    x1473 = x104 * x1457 + x1064 * x1164
    x1474 = x1066 * x22 + x55 * (x102 * x1472 + x1473 * x56)
    x1475 = x1067 * x22 + x1474
    x1476 = x104 * x1460 + x1214
    x1477 = x104 * x1461 + x1193 * x729
    x1478 = x1075 * x22 + x55 * (x102 * x1476 + x1477 * x56)
    x1479 = x1076 * x22 + x1478
    x1480 = x104 * x1464 + x1222
    x1481 = x102 * x1223 + x104 * x1465
    x1482 = x1084 * x22 + x55 * (x102 * x1480 + x1481 * x56)
    x1483 = x1085 * x22 + x1482
    x1484 = x124 * x1464 + x1405
    x1485 = x1051 + x124 * x1465
    x1486 = x1093 * x22 + x55 * (x102 * x1484 + x1485 * x56)
    x1487 = x1094 * x22 + x1486
    x1488 = x1100 * x22 + x55 * (x104 * x1469 + x1150 * x227)
    x1489 = x1101 * x22 + x1488
    x1490 = x1106 * x22 + x55 * (x104 * x1473 + x1105 * x1164)
    x1491 = x1107 * x22 + x1490
    x1492 = x1111 * x22 + x55 * (x104 * x1477 + x1064 * x1193)
    x1493 = x1112 * x22 + x1492
    x1494 = x1116 * x22 + x55 * (x104 * x1481 + x1223 * x729)
    x1495 = x1117 * x22 + x1494
    x1496 = x1121 * x22 + x55 * (x102 * x1252 + x104 * x1485)
    x1497 = x1122 * x22 + x1496
    x1498 = x1126 * x22 + x55 * (x1097 + x124 * x1485)
    x1499 = x1127 * x22 + x1498
    x1500 = x1132 * x555 - x1135 * x12 + 2.0 * x560
    x1501 = x1500 * x6
    x1502 = x1134 * x555 - x1146 * x1147 + 2.0 * x587
    x1503 = x1500 * x5 - x1502 * x97
    x1504 = x1503 * x4
    x1505 = (
        x1142 * x22
        + x1143 * x22
        + x55
        * (
            x1501 * x324
            + x56
            * (
                x1501 * x320
                + x56 * (x1501 * x317 + x56 * (x1501 * x56 + x56 * (x1501 + x1504)))
            )
        )
    )
    x1506 = x104 * x1501
    x1507 = x1501 * x9
    x1508 = (
        x1158 * x22
        + x1159 * x22
        + x55
        * (
            x1507 * x354
            + x56 * (x1507 * x350 + x56 * (x1501 * x598 + x56 * (x104 * x1504 + x1506)))
        )
    )
    x1509 = 3.0 * x1133 + x12 * x1500
    x1510 = x102 * x1509
    x1511 = 3.0 * x1150 + x12 * x1503
    x1512 = (
        x1168 * x22
        + x1169 * x22
        + x55
        * (
            x1509 * x961
            + x56 * (x1509 * x827 + x56 * (x1509 * x429 + x56 * (x1510 + x1511 * x56)))
        )
    )
    x1513 = x140 * x1501
    x1514 = (
        x1176 * x22
        + x1177 * x22
        + x55 * (x1501 * x634 + x56 * (x1501 * x630 + x56 * (x140 * x1504 + x1513)))
    )
    x1515 = x1509 * x729
    x1516 = (
        x1187 * x22
        + x1188 * x22
        + x55 * (x1186 * x1509 + x56 * (x1216 * x1509 + x56 * (x1511 * x598 + x1515)))
    )
    x1517 = x1162 * x62 + x124 * x1509
    x1518 = x102 * x1517
    x1519 = x1164 * x62 + x124 * x1511
    x1520 = (
        x1196 * x22
        + x1197 * x22
        + x55 * (x1517 * x827 + x56 * (x1517 * x429 + x56 * (x1518 + x1519 * x56)))
    )
    x1521 = x1501 * x184
    x1522 = (
        x1203 * x22 + x1204 * x22 + x55 * (x1501 * x673 + x56 * (x1504 * x184 + x1521))
    )
    x1523 = x1064 * x1509
    x1524 = (
        x1209 * x22
        + x1210 * x22
        + x55 * (x1185 * x148 * x1509 + x56 * (x1511 * x630 + x1523))
    )
    x1525 = x1517 * x729
    x1526 = (
        x1217 * x22 + x1218 * x22 + x55 * (x1216 * x1517 + x56 * (x1519 * x598 + x1525))
    )
    x1527 = x1191 * x62 + x124 * x1517
    x1528 = x102 * x1527
    x1529 = x1193 * x62 + x124 * x1519
    x1530 = x1225 * x22 + x1226 * x22 + x55 * (x1527 * x429 + x56 * (x1528 + x1529 * x56))
    x1531 = x1501 * x227
    x1532 = x1231 * x22 + x1232 * x22 + x55 * (x1504 * x227 + x1531)
    x1533 = x1105 * x1509
    x1534 = x1236 * x22 + x1237 * x22 + x55 * (x1511 * x673 + x1533)
    x1535 = x1064 * x1517
    x1536 = x1241 * x22 + x1242 * x22 + x55 * (x1519 * x630 + x1535)
    x1537 = x1527 * x729
    x1538 = x1246 * x22 + x1247 * x22 + x55 * (x1529 * x598 + x1537)
    x1539 = x1221 * x62 + x124 * x1527
    x1540 = x102 * x1539
    x1541 = x1223 * x62 + x124 * x1529
    x1542 = x1253 * x22 + x1254 * x22 + x55 * (x1540 + x1541 * x56)
    x1543 = x1258 * x22 + x1259 * x22 + x1503 * x263
    x1544 = x1262 * x22 + x1263 * x22 + x1511 * x268
    x1545 = x1266 * x22 + x1267 * x22 + x1519 * x233
    x1546 = x1270 * x22 + x1271 * x22 + x1529 * x194
    x1547 = x1274 * x22 + x1275 * x22 + x154 * x1541
    x1548 = x1278 * x22 + x1279 * x22 + x55 * (x124 * x1541 + x1252 * x62)
    x1549 = x0 * x325 + x322
    x1550 = x262 * x4**5
    x1551 = x0 * x299
    x1552 = x0 * x355 + x352
    x1553 = x262 * x88
    x1554 = x1553 * x342
    x1555 = x0 * x371 + x369
    x1556 = x12 * x1553
    x1557 = x0 * x385 + x383
    x1558 = x0 * x354
    x1559 = x0 * x402 + x400
    x1560 = x0 * x418 + x415
    x1561 = x13 * x81
    x1562 = x1551 * x262
    x1563 = x0 * x430 + x427
    x1564 = x0 * x350
    x1565 = x0 * x442 + x440
    x1566 = x0 * x456 + x454
    x1567 = x0 * x468 + x465
    x1568 = x214 * x7
    x1569 = x0 * x477 + x474
    x1570 = x0 * x346
    x1571 = x0 * x487 + x484
    x1572 = x0 * x497 + x494
    x1573 = x0 * x509 + x506
    x1574 = x0 * x518 + x515
    x1575 = x255 * x4
    x1576 = x0 * x523 + x521
    x1577 = x104 * x476 + x231
    x1578 = x0 * x529 + x527
    x1579 = x104 * x486 + x238
    x1580 = x0 * x534 + x532
    x1581 = x104 * x496 + x246
    x1582 = x0 * x539 + x537
    x1583 = x104 * x508 + x253
    x1584 = x0 * x546 + x543
    x1585 = x256 * x341 + x260
    x1586 = x0 * x552 + x550
    x1587 = x1550 * x777
    x1588 = x21 * x299
    x1589 = x1550 * x1588 + x1587
    x1590 = x1553 * x800
    x1591 = x1554 * x21 + x1590
    x1592 = x1556 * x777
    x1593 = x1556 * x1588 + x1592
    x1594 = x354 * x823
    x1595 = x21 * x354
    x1596 = x1594 + x1595 * x378
    x1597 = x354 * x833
    x1598 = x1595 * x395 + x1597
    x1599 = x262 * x777
    x1600 = x1561 * x1599
    x1601 = x1588 * x262
    x1602 = x1561 * x1601 + x1600
    x1603 = x350 * x850
    x1604 = x21 * x350
    x1605 = x1603 + x1604 * x425
    x1606 = x350 * x858
    x1607 = x1604 * x438 + x1606
    x1608 = x350 * x866
    x1609 = x1604 * x452 + x1608
    x1610 = x1568 * x1599
    x1611 = x1568 * x1601 + x1610
    x1612 = x346 * x880
    x1613 = x21 * x346
    x1614 = x1612 + x1613 * x476
    x1615 = x346 * x887
    x1616 = x1613 * x486 + x1615
    x1617 = x346 * x894
    x1618 = x1613 * x496 + x1617
    x1619 = x346 * x901
    x1620 = x1613 * x508 + x1619
    x1621 = x1575 * x1599
    x1622 = x1575 * x1601 + x1621
    x1623 = x55 * (x104 * x880 + x476 * x68)
    x1624 = x1577 * x326 + x1623
    x1625 = x55 * (x104 * x887 + x486 * x68)
    x1626 = x1579 * x326 + x1625
    x1627 = x55 * (x104 * x894 + x496 * x68)
    x1628 = x1581 * x326 + x1627
    x1629 = x55 * (x104 * x901 + x508 * x68)
    x1630 = x1583 * x326 + x1629
    x1631 = x55 * (x256 * x798 + x256 * x799)
    x1632 = x1585 * x326 + x1631
    x1633 = x289 * x777
    x1634 = x1588 * x289 + x1633
    x1635 = x1550 * x938
    x1636 = x22 * x299
    x1637 = x1550 * x1636 + x1635
    x1638 = x1553 * x956
    x1639 = x1554 * x22 + x1638
    x1640 = x1553 * x969
    x1641 = x1556 * x1636 + x1640
    x1642 = x354 * x981
    x1643 = x22 * x354
    x1644 = x1642 + x1643 * x378
    x1645 = x354 * x992
    x1646 = x1643 * x395 + x1645
    x1647 = x1003 * x354
    x1648 = x1636 * x262
    x1649 = x1561 * x1648 + x1647
    x1650 = x1014 * x350
    x1651 = x22 * x350
    x1652 = x1650 + x1651 * x425
    x1653 = x1024 * x350
    x1654 = x1651 * x438 + x1653
    x1655 = x1034 * x350
    x1656 = x1651 * x452 + x1655
    x1657 = x1044 * x350
    x1658 = x1568 * x1648 + x1657
    x1659 = x1054 * x346
    x1660 = x22 * x346
    x1661 = x1659 + x1660 * x476
    x1662 = x1063 * x346
    x1663 = x1660 * x486 + x1662
    x1664 = x1073 * x346
    x1665 = x1660 * x496 + x1664
    x1666 = x1082 * x346
    x1667 = x1660 * x508 + x1666
    x1668 = x1091 * x346
    x1669 = x1575 * x1648 + x1668
    x1670 = x55 * (x104 * x1054 + x710)
    x1671 = x1577 * x585 + x1670
    x1672 = x55 * (x104 * x1063 + x716)
    x1673 = x1579 * x585 + x1672
    x1674 = x55 * (x104 * x1073 + x722)
    x1675 = x1581 * x585 + x1674
    x1676 = x55 * (x104 * x1082 + x730)
    x1677 = x1583 * x585 + x1676
    x1678 = x55 * (x104 * x1091 + x740)
    x1679 = x1585 * x585 + x1678
    x1680 = x55 * (x1091 * x124 + x517)
    x1681 = x1636 * x289 + x1680
    x1682 = x1282 * x1550
    x1683 = x1587 * x21 + x1682
    x1684 = x1589 * x21 + x1683
    x1685 = x1290 * x1553
    x1686 = x1590 * x21 + x1685
    x1687 = x1591 * x21 + x1686
    x1688 = x1282 * x1556
    x1689 = x1592 * x21 + x1688
    x1690 = x1593 * x21 + x1689
    x1691 = x1299 * x354
    x1692 = x1594 * x21 + x1691
    x1693 = x1596 * x21 + x1692
    x1694 = x1303 * x354
    x1695 = x1597 * x21 + x1694
    x1696 = x1598 * x21 + x1695
    x1697 = x1282 * x262
    x1698 = x1561 * x1697
    x1699 = x1600 * x21 + x1698
    x1700 = x1602 * x21 + x1699
    x1701 = x1310 * x350
    x1702 = x1603 * x21 + x1701
    x1703 = x1605 * x21 + x1702
    x1704 = x1314 * x350
    x1705 = x1606 * x21 + x1704
    x1706 = x1607 * x21 + x1705
    x1707 = x1318 * x350
    x1708 = x1608 * x21 + x1707
    x1709 = x1609 * x21 + x1708
    x1710 = x1568 * x1697
    x1711 = x1610 * x21 + x1710
    x1712 = x1611 * x21 + x1711
    x1713 = x1324 * x346
    x1714 = x1612 * x21 + x1713
    x1715 = x1614 * x21 + x1714
    x1716 = x1328 * x346
    x1717 = x1615 * x21 + x1716
    x1718 = x1616 * x21 + x1717
    x1719 = x1332 * x346
    x1720 = x1617 * x21 + x1719
    x1721 = x1618 * x21 + x1720
    x1722 = x1336 * x346
    x1723 = x1619 * x21 + x1722
    x1724 = x1620 * x21 + x1723
    x1725 = x1575 * x1697
    x1726 = x1621 * x21 + x1725
    x1727 = x1622 * x21 + x1726
    x1728 = x55 * (x104 * x1324 + x62 * x880)
    x1729 = x1623 * x21 + x1728
    x1730 = x1624 * x21 + x1729
    x1731 = x55 * (x104 * x1328 + x62 * x887)
    x1732 = x1625 * x21 + x1731
    x1733 = x1626 * x21 + x1732
    x1734 = x55 * (x104 * x1332 + x62 * x894)
    x1735 = x1627 * x21 + x1734
    x1736 = x1628 * x21 + x1735
    x1737 = x55 * (x104 * x1336 + x62 * x901)
    x1738 = x1629 * x21 + x1737
    x1739 = x1630 * x21 + x1738
    x1740 = x55 * (x1288 * x256 + x1289 * x256)
    x1741 = x1631 * x21 + x1740
    x1742 = x1632 * x21 + x1741
    x1743 = x1282 * x289
    x1744 = x1633 * x21 + x1743
    x1745 = x1634 * x21 + x1744
    x1746 = x1348 * x1550
    x1747 = x1587 * x22 + x1746
    x1748 = x1637 * x21 + x1747
    x1749 = x1355 * x1553
    x1750 = x1590 * x22 + x1749
    x1751 = x1639 * x21 + x1750
    x1752 = x1359 * x1553
    x1753 = x1592 * x22 + x1752
    x1754 = x1641 * x21 + x1753
    x1755 = x1363 * x354
    x1756 = x1594 * x22 + x1755
    x1757 = x1644 * x21 + x1756
    x1758 = x1368 * x354
    x1759 = x1597 * x22 + x1758
    x1760 = x1646 * x21 + x1759
    x1761 = x1372 * x354
    x1762 = x1600 * x22 + x1761
    x1763 = x1649 * x21 + x1762
    x1764 = x1376 * x350
    x1765 = x1603 * x22 + x1764
    x1766 = x1652 * x21 + x1765
    x1767 = x1380 * x350
    x1768 = x1606 * x22 + x1767
    x1769 = x1654 * x21 + x1768
    x1770 = x1385 * x350
    x1771 = x1608 * x22 + x1770
    x1772 = x1656 * x21 + x1771
    x1773 = x1389 * x350
    x1774 = x1610 * x22 + x1773
    x1775 = x1658 * x21 + x1774
    x1776 = x1393 * x346
    x1777 = x1612 * x22 + x1776
    x1778 = x1661 * x21 + x1777
    x1779 = x1397 * x346
    x1780 = x1615 * x22 + x1779
    x1781 = x1663 * x21 + x1780
    x1782 = x1401 * x346
    x1783 = x1617 * x22 + x1782
    x1784 = x1665 * x21 + x1783
    x1785 = x1406 * x346
    x1786 = x1619 * x22 + x1785
    x1787 = x1667 * x21 + x1786
    x1788 = x1410 * x346
    x1789 = x1621 * x22 + x1788
    x1790 = x1669 * x21 + x1789
    x1791 = x55 * (x104 * x1393 + x1054 * x68)
    x1792 = x1623 * x22 + x1791
    x1793 = x1671 * x21 + x1792
    x1794 = x55 * (x104 * x1397 + x1063 * x68)
    x1795 = x1625 * x22 + x1794
    x1796 = x1673 * x21 + x1795
    x1797 = x55 * (x104 * x1401 + x1073 * x68)
    x1798 = x1627 * x22 + x1797
    x1799 = x1675 * x21 + x1798
    x1800 = x55 * (x104 * x1406 + x1082 * x68)
    x1801 = x1629 * x22 + x1800
    x1802 = x1677 * x21 + x1801
    x1803 = x1091 * x68
    x1804 = x55 * (x104 * x1410 + x1803)
    x1805 = x1631 * x22 + x1804
    x1806 = x1679 * x21 + x1805
    x1807 = x55 * (x124 * x1410 + x908)
    x1808 = x1633 * x22 + x1807
    x1809 = x1681 * x21 + x1808
    x1810 = x1426 * x1550
    x1811 = x1635 * x22 + x1810
    x1812 = x1637 * x22 + x1811
    x1813 = x1432 * x1553
    x1814 = x1638 * x22 + x1813
    x1815 = x1639 * x22 + x1814
    x1816 = x1436 * x1553
    x1817 = x1640 * x22 + x1816
    x1818 = x1641 * x22 + x1817
    x1819 = x1440 * x354
    x1820 = x1642 * x22 + x1819
    x1821 = x1644 * x22 + x1820
    x1822 = x1444 * x354
    x1823 = x1645 * x22 + x1822
    x1824 = x1646 * x22 + x1823
    x1825 = x1448 * x354
    x1826 = x1647 * x22 + x1825
    x1827 = x1649 * x22 + x1826
    x1828 = x1452 * x350
    x1829 = x1650 * x22 + x1828
    x1830 = x1652 * x22 + x1829
    x1831 = x1456 * x350
    x1832 = x1653 * x22 + x1831
    x1833 = x1654 * x22 + x1832
    x1834 = x1460 * x350
    x1835 = x1655 * x22 + x1834
    x1836 = x1656 * x22 + x1835
    x1837 = x1464 * x350
    x1838 = x1657 * x22 + x1837
    x1839 = x1658 * x22 + x1838
    x1840 = x1468 * x346
    x1841 = x1659 * x22 + x1840
    x1842 = x1661 * x22 + x1841
    x1843 = x1472 * x346
    x1844 = x1662 * x22 + x1843
    x1845 = x1663 * x22 + x1844
    x1846 = x1476 * x346
    x1847 = x1664 * x22 + x1846
    x1848 = x1665 * x22 + x1847
    x1849 = x1480 * x346
    x1850 = x1666 * x22 + x1849
    x1851 = x1667 * x22 + x1850
    x1852 = x1484 * x346
    x1853 = x1668 * x22 + x1852
    x1854 = x1669 * x22 + x1853
    x1855 = x55 * (x104 * x1468 + x1230)
    x1856 = x1670 * x22 + x1855
    x1857 = x1671 * x22 + x1856
    x1858 = x55 * (x104 * x1472 + x1235)
    x1859 = x1672 * x22 + x1858
    x1860 = x1673 * x22 + x1859
    x1861 = x55 * (x104 * x1476 + x1240)
    x1862 = x1674 * x22 + x1861
    x1863 = x1675 * x22 + x1862
    x1864 = x55 * (x104 * x1480 + x1245)
    x1865 = x1676 * x22 + x1864
    x1866 = x1677 * x22 + x1865
    x1867 = x55 * (x104 * x1484 + x1251)
    x1868 = x1678 * x22 + x1867
    x1869 = x1679 * x22 + x1868
    x1870 = x55 * (x124 * x1484 + x1803)
    x1871 = x1680 * x22 + x1870
    x1872 = x1681 * x22 + x1871
    x1873 = x1282 * x293 - x1284 * x791 + 3.0 * x790
    x1874 = x1873 * x9
    x1875 = 4.0 * x1283
    x1876 = x1874 + x1875
    x1877 = x104 * x1876 + 4.0 * x1291
    x1878 = x124 * x1874 + x124 * x1875
    x1879 = x1873 * x262
    x1880 = x104 * x1877 + 4.0 * x1300
    x1881 = x104 * x1878 + 4.0 * x1304
    x1882 = x169 * x1874 + x169 * x1875
    x1883 = x104 * x1880 + 4.0 * x1311
    x1884 = x104 * x1881 + 4.0 * x1315
    x1885 = x104 * x1882 + 4.0 * x1319
    x1886 = x1874 * x215 + x1875 * x215
    x1887 = x1348 * x293 - x1350 * x791 + 2.0 * x950
    x1888 = x1550 * x1887
    x1889 = 3.0 * x1349 + x1887 * x9
    x1890 = x1553 * x1889
    x1891 = x12 * x1887 + x1283
    x1892 = x1553 * x1891
    x1893 = x104 * x1889 + x1355 * x62
    x1894 = x1893 * x354
    x1895 = x104 * x1891 + x1359 * x62
    x1896 = x1895 * x354
    x1897 = x124 * x1891 + x1296
    x1898 = x1897 * x354
    x1899 = x104 * x1893 + x1363 * x62
    x1900 = x1899 * x350
    x1901 = x104 * x1895 + x1368 * x62
    x1902 = x1901 * x350
    x1903 = x104 * x1897 + x1372 * x62
    x1904 = x1903 * x350
    x1905 = x124 * x1897 + x1307
    x1906 = x1905 * x350
    x1907 = x104 * x1899 + x1376 * x62
    x1908 = x1907 * x346
    x1909 = x104 * x1901 + x1380 * x62
    x1910 = x1909 * x346
    x1911 = x104 * x1903 + x1385 * x62
    x1912 = x1911 * x346
    x1913 = x104 * x1905 + x1389 * x62
    x1914 = x1913 * x346
    x1915 = x124 * x1905 + x1322
    x1916 = x1915 * x346
    x1917 = x55 * (x104 * x1907 + x1393 * x62)
    x1918 = x55 * (x104 * x1909 + x1397 * x62)
    x1919 = x55 * (x104 * x1911 + x1401 * x62)
    x1920 = x55 * (x104 * x1913 + x1406 * x62)
    x1921 = x55 * (x104 * x1915 + x1410 * x62)
    x1922 = x55 * (x124 * x1915 + x1340)
    x1923 = x1145 + x1426 * x293 - x1428 * x791
    x1924 = x1550 * x1923 + x1746 * x22
    x1925 = 2.0 * x1427 + x1923 * x9
    x1926 = x1553 * x1925 + x1749 * x22
    x1927 = x12 * x1923 + 2.0 * x1349
    x1928 = x1553 * x1927 + x1752 * x22
    x1929 = x104 * x1925 + x1432 * x68
    x1930 = x1755 * x22 + x1929 * x354
    x1931 = x104 * x1927 + x1436 * x68
    x1932 = x1758 * x22 + x1931 * x354
    x1933 = x124 * x1927 + x1359 * x68
    x1934 = x1761 * x22 + x1933 * x354
    x1935 = x104 * x1929 + x1440 * x68
    x1936 = x1764 * x22 + x1935 * x350
    x1937 = x104 * x1931 + x1444 * x68
    x1938 = x1767 * x22 + x1937 * x350
    x1939 = x104 * x1933 + x1448 * x68
    x1940 = x1770 * x22 + x1939 * x350
    x1941 = x124 * x1933 + x1372 * x68
    x1942 = x1773 * x22 + x1941 * x350
    x1943 = x104 * x1935 + x1452 * x68
    x1944 = x1776 * x22 + x1943 * x346
    x1945 = x104 * x1937 + x1456 * x68
    x1946 = x1779 * x22 + x1945 * x346
    x1947 = x104 * x1939 + x1460 * x68
    x1948 = x1782 * x22 + x1947 * x346
    x1949 = x104 * x1941 + x1464 * x68
    x1950 = x1785 * x22 + x1949 * x346
    x1951 = x124 * x1941 + x1389 * x68
    x1952 = x1788 * x22 + x1951 * x346
    x1953 = x1791 * x22 + x55 * (x104 * x1943 + x1468 * x68)
    x1954 = x1794 * x22 + x55 * (x104 * x1945 + x1472 * x68)
    x1955 = x1797 * x22 + x55 * (x104 * x1947 + x1476 * x68)
    x1956 = x1800 * x22 + x55 * (x104 * x1949 + x1480 * x68)
    x1957 = x1804 * x22 + x55 * (x104 * x1951 + x1484 * x68)
    x1958 = x1807 * x22 + x55 * (x124 * x1951 + x1410 * x68)
    x1959 = x1500 * x293 - x1502 * x791
    x1960 = x1550 * x1959 + x1810 * x22 + x1811 * x22
    x1961 = x1501 + x1959 * x9
    x1962 = x1553 * x1961 + x1813 * x22 + x1814 * x22
    x1963 = x12 * x1959 + 3.0 * x1427
    x1964 = x1553 * x1963 + x1816 * x22 + x1817 * x22
    x1965 = x104 * x1961 + x1506
    x1966 = x1819 * x22 + x1820 * x22 + x1965 * x354
    x1967 = x104 * x1963 + x1510
    x1968 = x1822 * x22 + x1823 * x22 + x1967 * x354
    x1969 = x124 * x1963 + x1436 * x62
    x1970 = x1825 * x22 + x1826 * x22 + x1969 * x354
    x1971 = x104 * x1965 + x1513
    x1972 = x1828 * x22 + x1829 * x22 + x1971 * x350
    x1973 = x104 * x1967 + x1515
    x1974 = x1831 * x22 + x1832 * x22 + x1973 * x350
    x1975 = x104 * x1969 + x1518
    x1976 = x1834 * x22 + x1835 * x22 + x1975 * x350
    x1977 = x124 * x1969 + x1448 * x62
    x1978 = x1837 * x22 + x1838 * x22 + x1977 * x350
    x1979 = x104 * x1971 + x1521
    x1980 = x1840 * x22 + x1841 * x22 + x1979 * x346
    x1981 = x104 * x1973 + x1523
    x1982 = x1843 * x22 + x1844 * x22 + x1981 * x346
    x1983 = x104 * x1975 + x1525
    x1984 = x1846 * x22 + x1847 * x22 + x1983 * x346
    x1985 = x104 * x1977 + x1528
    x1986 = x1849 * x22 + x1850 * x22 + x1985 * x346
    x1987 = x124 * x1977 + x1464 * x62
    x1988 = x1852 * x22 + x1853 * x22 + x1987 * x346
    x1989 = x1855 * x22 + x1856 * x22 + x55 * (x104 * x1979 + x1531)
    x1990 = x1858 * x22 + x1859 * x22 + x55 * (x104 * x1981 + x1533)
    x1991 = x1861 * x22 + x1862 * x22 + x55 * (x104 * x1983 + x1535)
    x1992 = x1864 * x22 + x1865 * x22 + x55 * (x104 * x1985 + x1537)
    x1993 = x1867 * x22 + x1868 * x22 + x55 * (x104 * x1987 + x1540)
    x1994 = x1870 * x22 + x1871 * x22 + x55 * (x124 * x1987 + x1484 * x62)
    x1995 = x0 * x584 + x582
    x1996 = x0 * x561
    x1997 = x0 * x605 + x603
    x1998 = x1553 * x9
    x1999 = x0 * x622 + x620
    x2000 = x0 * x612
    x2001 = x0 * x635 + x632
    x2002 = x262 * x81
    x2003 = x10 * x2002
    x2004 = x0 * x648 + x645
    x2005 = x2002 * x9
    x2006 = x0 * x664 + x661
    x2007 = x0 * x674 + x671
    x2008 = x262 * x7
    x2009 = x182 * x2008
    x2010 = x0 * x682 + x680
    x2011 = x10 * x2008
    x2012 = x0 * x691 + x689
    x2013 = x226 * x656
    x2014 = x0 * x2013
    x2015 = x0 * x704 + x702
    x2016 = x0 * x711 + x708
    x2017 = x268 * x4
    x2018 = x0 * x717 + x714
    x2019 = x182 * x262
    x2020 = x2019 * x4
    x2021 = x0 * x723 + x720
    x2022 = x0 * x731 + x727
    x2023 = x643 * x699
    x2024 = x0 * x741 + x737
    x2025 = x0 * x747 + x745
    x2026 = x0 * x753 + x751
    x2027 = x0 * x758 + x756
    x2028 = x233 * x656
    x2029 = x0 * x763 + x761
    x2030 = x194 * x699
    x2031 = x0 * x768 + x766
    x2032 = x154 * x739
    x2033 = x0 * x773 + x771
    x2034 = x124 * x739 + x260
    x2035 = x21 * x584 + x947
    x2036 = x21 * x561
    x2037 = x1550 * x2036 + x1635
    x2038 = x21 * x605 + x962
    x2039 = x1638 + x1998 * x2036
    x2040 = x21 * x622 + x974
    x2041 = x21 * x612
    x2042 = x1553 * x2041 + x1640
    x2043 = x21 * x635 + x985
    x2044 = x1642 + x2003 * x2036
    x2045 = x21 * x648 + x996
    x2046 = x1645 + x2005 * x2041
    x2047 = x1007 + x21 * x664
    x2048 = x1595 * x656 + x1647
    x2049 = x1017 + x21 * x674
    x2050 = x1650 + x2009 * x2036
    x2051 = x1027 + x21 * x682
    x2052 = x1653 + x2011 * x2041
    x2053 = x1037 + x21 * x691
    x2054 = x2013 * x21
    x2055 = x117 * x2054 + x1655
    x2056 = x1047 + x21 * x704
    x2057 = x1604 * x699 + x1657
    x2058 = x1056 + x21 * x711
    x2059 = x1659 + x2017 * x2036
    x2060 = x1066 + x21 * x717
    x2061 = x1662 + x2020 * x2041
    x2062 = x1075 + x21 * x723
    x2063 = x148 * x2054 + x1664
    x2064 = x1084 + x21 * x731
    x2065 = x1666 + x2023 * x21
    x2066 = x1093 + x21 * x741
    x2067 = x1613 * x739 + x1668
    x2068 = x1100 + x21 * x747
    x2069 = x1670 + x2036 * x263
    x2070 = x1106 + x21 * x753
    x2071 = x1672 + x2041 * x268
    x2072 = x1111 + x21 * x758
    x2073 = x1674 + x2028 * x21
    x2074 = x1116 + x21 * x763
    x2075 = x1676 + x2030 * x21
    x2076 = x1121 + x21 * x768
    x2077 = x1678 + x2032 * x21
    x2078 = x1126 + x21 * x773
    x2079 = x1680 + x2034 * x326
    x2080 = x1132 * x1550
    x2081 = x22 * x561
    x2082 = x1550 * x2081 + x2080
    x2083 = x1132 * x1998
    x2084 = x1998 * x2081 + x2083
    x2085 = x1162 * x1553
    x2086 = x22 * x612
    x2087 = x1553 * x2086 + x2085
    x2088 = x1132 * x2003
    x2089 = x2003 * x2081 + x2088
    x2090 = x1162 * x2005
    x2091 = x2005 * x2086 + x2090
    x2092 = x1191 * x354
    x2093 = x1643 * x656 + x2092
    x2094 = x1132 * x2009
    x2095 = x2009 * x2081 + x2094
    x2096 = x1162 * x2011
    x2097 = x2011 * x2086 + x2096
    x2098 = x1191 * x226
    x2099 = x117 * x2098
    x2100 = x2013 * x22
    x2101 = x117 * x2100 + x2099
    x2102 = x1221 * x350
    x2103 = x1651 * x699 + x2102
    x2104 = x1132 * x2017
    x2105 = x2017 * x2081 + x2104
    x2106 = x1182 * x2019
    x2107 = x2020 * x2086 + x2106
    x2108 = x148 * x2098
    x2109 = x148 * x2100 + x2108
    x2110 = x1221 * x643
    x2111 = x2023 * x22 + x2110
    x2112 = x1250 * x346
    x2113 = x1660 * x739 + x2112
    x2114 = x1132 * x263
    x2115 = x2081 * x263 + x2114
    x2116 = x1162 * x268
    x2117 = x2086 * x268 + x2116
    x2118 = x1191 * x233
    x2119 = x2028 * x22 + x2118
    x2120 = x1221 * x194
    x2121 = x2030 * x22 + x2120
    x2122 = x1250 * x154
    x2123 = x2032 * x22 + x2122
    x2124 = x55 * (x124 * x1250 + x68 * x739)
    x2125 = x2034 * x585 + x2124
    x2126 = x1635 * x21 + x1746
    x2127 = x2037 * x21 + x2126
    x2128 = x1638 * x21 + x1749
    x2129 = x2039 * x21 + x2128
    x2130 = x1640 * x21 + x1752
    x2131 = x2042 * x21 + x2130
    x2132 = x1642 * x21 + x1755
    x2133 = x2044 * x21 + x2132
    x2134 = x1645 * x21 + x1758
    x2135 = x2046 * x21 + x2134
    x2136 = x1647 * x21 + x1761
    x2137 = x2048 * x21 + x2136
    x2138 = x1650 * x21 + x1764
    x2139 = x2050 * x21 + x2138
    x2140 = x1653 * x21 + x1767
    x2141 = x2052 * x21 + x2140
    x2142 = x1655 * x21 + x1770
    x2143 = x2055 * x21 + x2142
    x2144 = x1657 * x21 + x1773
    x2145 = x2057 * x21 + x2144
    x2146 = x1659 * x21 + x1776
    x2147 = x2059 * x21 + x2146
    x2148 = x1662 * x21 + x1779
    x2149 = x2061 * x21 + x2148
    x2150 = x1664 * x21 + x1782
    x2151 = x2063 * x21 + x2150
    x2152 = x1666 * x21 + x1785
    x2153 = x2065 * x21 + x2152
    x2154 = x1668 * x21 + x1788
    x2155 = x2067 * x21 + x2154
    x2156 = x1670 * x21 + x1791
    x2157 = x2069 * x21 + x2156
    x2158 = x1672 * x21 + x1794
    x2159 = x2071 * x21 + x2158
    x2160 = x1674 * x21 + x1797
    x2161 = x2073 * x21 + x2160
    x2162 = x1676 * x21 + x1800
    x2163 = x2075 * x21 + x2162
    x2164 = x1678 * x21 + x1804
    x2165 = x2077 * x21 + x2164
    x2166 = x1680 * x21 + x1807
    x2167 = x2079 * x21 + x2166
    x2168 = x1811 + x2082 * x21
    x2169 = x1814 + x2084 * x21
    x2170 = x1817 + x2087 * x21
    x2171 = x1820 + x2089 * x21
    x2172 = x1823 + x2091 * x21
    x2173 = x1826 + x2093 * x21
    x2174 = x1829 + x2095 * x21
    x2175 = x1832 + x2097 * x21
    x2176 = x1835 + x21 * x2101
    x2177 = x1838 + x21 * x2103
    x2178 = x1841 + x21 * x2105
    x2179 = x1844 + x21 * x2107
    x2180 = x1847 + x21 * x2109
    x2181 = x1850 + x21 * x2111
    x2182 = x1853 + x21 * x2113
    x2183 = x1856 + x21 * x2115
    x2184 = x1859 + x21 * x2117
    x2185 = x1862 + x21 * x2119
    x2186 = x1865 + x21 * x2121
    x2187 = x1868 + x21 * x2123
    x2188 = x1871 + x21 * x2125
    x2189 = x1500 * x1550
    x2190 = x2080 * x22 + x2189
    x2191 = x2082 * x22 + x2190
    x2192 = x1500 * x1998
    x2193 = x2083 * x22 + x2192
    x2194 = x2084 * x22 + x2193
    x2195 = x1509 * x1553
    x2196 = x2085 * x22 + x2195
    x2197 = x2087 * x22 + x2196
    x2198 = x1500 * x2003
    x2199 = x2088 * x22 + x2198
    x2200 = x2089 * x22 + x2199
    x2201 = x1509 * x2005
    x2202 = x2090 * x22 + x2201
    x2203 = x2091 * x22 + x2202
    x2204 = x1517 * x354
    x2205 = x2092 * x22 + x2204
    x2206 = x2093 * x22 + x2205
    x2207 = x1500 * x2009
    x2208 = x2094 * x22 + x2207
    x2209 = x2095 * x22 + x2208
    x2210 = x1509 * x2011
    x2211 = x2096 * x22 + x2210
    x2212 = x2097 * x22 + x2211
    x2213 = x1517 * x226
    x2214 = x117 * x2213
    x2215 = x2099 * x22 + x2214
    x2216 = x2101 * x22 + x2215
    x2217 = x1527 * x350
    x2218 = x2102 * x22 + x2217
    x2219 = x2103 * x22 + x2218
    x2220 = x1500 * x2017
    x2221 = x2104 * x22 + x2220
    x2222 = x2105 * x22 + x2221
    x2223 = x1509 * x2020
    x2224 = x2106 * x22 + x2223
    x2225 = x2107 * x22 + x2224
    x2226 = x148 * x2213
    x2227 = x2108 * x22 + x2226
    x2228 = x2109 * x22 + x2227
    x2229 = x1527 * x643
    x2230 = x2110 * x22 + x2229
    x2231 = x2111 * x22 + x2230
    x2232 = x1539 * x346
    x2233 = x2112 * x22 + x2232
    x2234 = x2113 * x22 + x2233
    x2235 = x1500 * x263
    x2236 = x2114 * x22 + x2235
    x2237 = x2115 * x22 + x2236
    x2238 = x1509 * x268
    x2239 = x2116 * x22 + x2238
    x2240 = x2117 * x22 + x2239
    x2241 = x1517 * x233
    x2242 = x2118 * x22 + x2241
    x2243 = x2119 * x22 + x2242
    x2244 = x1527 * x194
    x2245 = x2120 * x22 + x2244
    x2246 = x2121 * x22 + x2245
    x2247 = x1539 * x154
    x2248 = x2122 * x22 + x2247
    x2249 = x2123 * x22 + x2248
    x2250 = x55 * (x124 * x1539 + x1250 * x62)
    x2251 = x2124 * x22 + x2250
    x2252 = x2125 * x22 + x2251
    x2253 = 3.0 * x1145 - x1146 * x1502 + x1500 * x555
    x2254 = x12 * x2253 + 4.0 * x1501
    x2255 = x124 * x2254 + 4.0 * x1510
    x2256 = x2255 * x226
    x2257 = x124 * x2255 + 4.0 * x1518
    x2258 = x124 * x2257 + 4.0 * x1528

    # 630 item(s)
    return numpy.array(
        [
            x0 * x80
            + x0 * x87
            + x0 * (x0 * (x86 + x92 * x93) + x87)
            + x55
            * (
                x103 * x75
                + x56
                * (
                    x103 * x70
                    + x56 * (x103 * x63 + x56 * (x103 * x54 + x56 * (x101 + x99)))
                )
            ),
            x0 * x116
            + x0 * x121
            + x0 * (x0 * (x120 + x123 * x93) + x121)
            + x55
            * (
                x103 * x111
                + x56
                * (x103 * x107 + x56 * (x103 * x105 + x56 * (x101 * x104 + x104 * x99)))
            ),
            x0 * x134
            + x0 * x137
            + x0 * (x0 * (x136 + x138 * x93) + x137)
            + x55
            * (
                x103 * x131
                + x56
                * (x103 * x127 + x56 * (x103 * x125 + x56 * (x101 * x124 + x124 * x99)))
            ),
            x0 * x147
            + x0 * x151
            + x0 * (x0 * (x150 + x153 * x93) + x151)
            + x55
            * (x103 * x143 + x56 * (x103 * x141 + x56 * (x101 * x140 + x140 * x99))),
            x0 * x163
            + x0 * x166
            + x0 * (x0 * (x165 + x168 * x93) + x166)
            + x55
            * (x103 * x158 + x56 * (x103 * x156 + x56 * (x101 * x155 + x155 * x99))),
            x0 * x176
            + x0 * x180
            + x0 * (x0 * (x179 + x181 * x93) + x180)
            + x55
            * (x103 * x172 + x56 * (x103 * x170 + x56 * (x101 * x169 + x169 * x99))),
            x0 * x187
            + x0 * x191
            + x0 * (x0 * (x190 + x193 * x93) + x191)
            + x55 * (x103 * x185 + x56 * (x101 * x184 + x184 * x99)),
            x0 * x198
            + x0 * x202
            + x0 * (x0 * (x201 + x203 * x93) + x202)
            + x55 * (x103 * x196 + x56 * (x101 * x195 + x195 * x99)),
            x0 * x208
            + x0 * x212
            + x0 * (x0 * (x211 + x213 * x93) + x212)
            + x55 * (x103 * x206 + x56 * (x101 * x205 + x205 * x99)),
            x0 * x218
            + x0 * x222
            + x0 * (x0 * (x221 + x224 * x93) + x222)
            + x55 * (x103 * x216 + x56 * (x101 * x215 + x215 * x99)),
            x0 * x228
            + x0 * x230
            + x0 * (x0 * (x229 + x232 * x93) + x230)
            + x55 * (x101 * x227 + x227 * x99),
            x0 * x235
            + x0 * x237
            + x0 * (x0 * (x236 + x239 * x93) + x237)
            + x55 * (x101 * x234 + x234 * x99),
            x0 * x243
            + x0 * x245
            + x0 * (x0 * (x244 + x247 * x93) + x245)
            + x55 * (x101 * x242 + x242 * x99),
            x0 * x250
            + x0 * x252
            + x0 * (x0 * (x251 + x254 * x93) + x252)
            + x55 * (x101 * x249 + x249 * x99),
            x0 * x257
            + x0 * x259
            + x0 * (x0 * (x258 + x261 * x93) + x259)
            + x55 * (x101 * x256 + x256 * x99),
            x0 * x264 + x0 * x266 + x0 * (x0 * (x263 * x267 + x265) + x266) + x263 * x98,
            x0 * x270 + x0 * x272 + x0 * (x0 * (x267 * x269 + x271) + x272) + x269 * x98,
            x0 * x275 + x0 * x278 + x0 * (x0 * (x267 * x276 + x277) + x278) + x276 * x98,
            x0 * x280 + x0 * x283 + x0 * (x0 * (x267 * x281 + x282) + x283) + x281 * x98,
            x0 * x285 + x0 * x288 + x0 * (x0 * (x267 * x286 + x287)