import numpy

from pysisyphus.wavefunction.ints.boys import boys


def coulomb3d_00(a, A, b, B, C):
    """Cartesian (ss) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)

    # 1 item(s)
    return numpy.array(
        [
            6.28318530717959
            * x1
            * boys(
                0,
                x0
                * (
                    (x1 * (a * A[0] + b * B[0]) - C[0]) ** 2
                    + (x1 * (a * A[1] + b * B[1]) - C[1]) ** 2
                    + (x1 * (a * A[2] + b * B[2]) - C[2]) ** 2
                ),
            )
            * numpy.exp(
                -a
                * b
                * x1
                * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
            )
        ]
    )


def coulomb3d_01(a, A, b, B, C):
    """Cartesian (sp) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = x0 * (x3**2 + x5**2 + x7**2)
    x9 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x10 = x9 * boys(1, x8)
    x11 = x9 * boys(0, x8)

    # 3 item(s)
    return numpy.array(
        [
            -x10 * x3 + x11 * (-x2 - B[0]),
            -x10 * x5 + x11 * (-x4 - B[1]),
            -x10 * x7 + x11 * (-x6 - B[2]),
        ]
    )


def coulomb3d_02(a, A, b, B, C):
    """Cartesian (sd) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = x0 * (x3**2 + x5**2 + x7**2)
    x9 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x10 = x9 * boys(1, x8)
    x11 = x9 * boys(0, x8)
    x12 = (-x10 + x11) / (2.0 * a + 2.0 * b)
    x13 = -x2 - B[0]
    x14 = x9 * boys(2, x8)
    x15 = -x4 - B[1]
    x16 = -x10 * x5 + x11 * x15
    x17 = x10 * x15 - x14 * x5
    x18 = -x6 - B[2]
    x19 = -x10 * x7 + x11 * x18
    x20 = x10 * x18 - x14 * x7

    # 6 item(s)
    return numpy.array(
        [
            x12 + x13 * (-x10 * x3 + x11 * x13) - x3 * (x10 * x13 - x14 * x3),
            x13 * x16 - x17 * x3,
            x13 * x19 - x20 * x3,
            x12 + x15 * x16 - x17 * x5,
            x15 * x19 - x20 * x5,
            x12 + x18 * x19 - x20 * x7,
        ]
    )


def coulomb3d_03(a, A, b, B, C):
    """Cartesian (sf) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - C[0]
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x1 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x0 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(1, x10)
    x13 = x11 * boys(0, x10)
    x14 = x4 * (-x12 + x13)
    x15 = -x12 * x5 + x13 * x3
    x16 = x11 * boys(2, x10)
    x17 = x16 * x5
    x18 = x12 * x3
    x19 = -x17 + x18
    x20 = x4 * (x12 - x16)
    x21 = x11 * boys(3, x10)
    x22 = -x6 - B[1]
    x23 = x12 * x22
    x24 = x16 * x7
    x25 = -x12 * x7 + x13 * x22
    x26 = x4 * (-x23 + x24 + x25)
    x27 = x23 - x24
    x28 = x16 * x22 - x21 * x7
    x29 = -x8 - B[2]
    x30 = x12 * x29
    x31 = x16 * x9
    x32 = -x12 * x9 + x13 * x29
    x33 = x4 * (-x30 + x31 + x32)
    x34 = x30 - x31
    x35 = x16 * x29 - x21 * x9
    x36 = x14 + x22 * x25 - x27 * x7
    x37 = x20 + x22 * x27 - x28 * x7
    x38 = x22 * x32 - x34 * x7
    x39 = x22 * x34 - x35 * x7
    x40 = x14 + x29 * x32 - x34 * x9
    x41 = x20 + x29 * x34 - x35 * x9

    # 10 item(s)
    return numpy.array(
        [
            x3 * (x14 + x15 * x3 - x19 * x5)
            + 2.0 * x4 * (x15 + x17 - x18)
            - x5 * (x19 * x3 + x20 - x5 * (x16 * x3 - x21 * x5)),
            x26 + x3 * (x25 * x3 - x27 * x5) - x5 * (x27 * x3 - x28 * x5),
            x3 * (x3 * x32 - x34 * x5) + x33 - x5 * (x3 * x34 - x35 * x5),
            x3 * x36 - x37 * x5,
            x3 * x38 - x39 * x5,
            x3 * x40 - x41 * x5,
            x22 * x36 + 2.0 * x26 - x37 * x7,
            x22 * x38 + x33 - x39 * x7,
            x22 * x40 - x41 * x7,
            x29 * x40 + 2.0 * x33 - x41 * x9,
        ]
    )


def coulomb3d_04(a, A, b, B, C):
    """Cartesian (sg) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - C[0]
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x1 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x0 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(1, x10)
    x13 = x11 * boys(0, x10)
    x14 = x4 * (-x12 + x13)
    x15 = -x12 * x5 + x13 * x3
    x16 = x11 * boys(2, x10)
    x17 = x16 * x5
    x18 = x12 * x3
    x19 = -x17 + x18
    x20 = x14 + x15 * x3 - x19 * x5
    x21 = x4 * (x12 - x16)
    x22 = x19 * x3
    x23 = x11 * boys(3, x10)
    x24 = x23 * x5
    x25 = x16 * x3
    x26 = -x24 + x25
    x27 = x26 * x5
    x28 = x21 + x22 - x27
    x29 = 2.0 * x4
    x30 = x4 * (x16 - x23)
    x31 = x11 * boys(4, x10)
    x32 = -x21
    x33 = -x6 - B[1]
    x34 = x12 * x33
    x35 = x16 * x7
    x36 = -x12 * x7 + x13 * x33
    x37 = x4 * (-x34 + x35 + x36)
    x38 = x34 - x35
    x39 = x3 * x36 - x38 * x5
    x40 = x3 * x38
    x41 = x23 * x7
    x42 = x16 * x33
    x43 = -x41 + x42
    x44 = x43 * x5
    x45 = x40 - x44
    x46 = x4 * (x38 + x41 - x42)
    x47 = x23 * x33 - x31 * x7
    x48 = -x8 - B[2]
    x49 = x12 * x48
    x50 = x16 * x9
    x51 = -x12 * x9 + x13 * x48
    x52 = x4 * (-x49 + x50 + x51)
    x53 = x49 - x50
    x54 = x3 * x51 - x5 * x53
    x55 = x3 * x53
    x56 = x23 * x9
    x57 = x16 * x48
    x58 = -x56 + x57
    x59 = x5 * x58
    x60 = x55 - x59
    x61 = x4 * (x53 + x56 - x57)
    x62 = x23 * x48 - x31 * x9
    x63 = x43 * x7
    x64 = x33 * x38
    x65 = x14 + x33 * x36 - x38 * x7
    x66 = x4 * (x32 + x63 - x64 + x65)
    x67 = x21 - x63 + x64
    x68 = x30 + x33 * x43 - x47 * x7
    x69 = x58 * x7
    x70 = x33 * x53
    x71 = x33 * x51 - x53 * x7
    x72 = x4 * (x69 - x70 + x71)
    x73 = -x69 + x70
    x74 = x33 * x58 - x62 * x7
    x75 = x58 * x9
    x76 = x48 * x53
    x77 = x14 + x48 * x51 - x53 * x9
    x78 = x4 * (x32 + x75 - x76 + x77)
    x79 = x21 - x75 + x76
    x80 = x30 + x48 * x58 - x62 * x9
    x81 = x33 * x65 + 2.0 * x37 - x67 * x7
    x82 = x33 * x67 + 2.0 * x46 - x68 * x7
    x83 = x33 * x71 + x52 - x7 * x73
    x84 = x33 * x73 + x61 - x7 * x74
    x85 = x33 * x77 - x7 * x79
    x86 = x33 * x79 - x7 * x80
    x87 = x48 * x77 + 2.0 * x52 - x79 * x9
    x88 = x48 * x79 + 2.0 * x61 - x80 * x9

    # 15 item(s)
    return numpy.array(
        [
            x3 * (x20 * x3 - x28 * x5 + x29 * (x15 + x17 - x18))
            + 3.0 * x4 * (x20 - x22 + x27 + x32)
            - x5
            * (
                x28 * x3
                + x29 * (x19 + x24 - x25)
                - x5 * (x26 * x3 + x30 - x5 * (x23 * x3 - x31 * x5))
            ),
            x29 * (x39 - x40 + x44)
            + x3 * (x3 * x39 + x37 - x45 * x5)
            - x5 * (x3 * x45 + x46 - x5 * (x3 * x43 - x47 * x5)),
            x29 * (x54 - x55 + x59)
            + x3 * (x3 * x54 - x5 * x60 + x52)
            - x5 * (x3 * x60 - x5 * (x3 * x58 - x5 * x62) + x61),
            x3 * (x3 * x65 - x5 * x67) - x5 * (x3 * x67 - x5 * x68) + x66,
            x3 * (x3 * x71 - x5 * x73) - x5 * (x3 * x73 - x5 * x74) + x72,
            x3 * (x3 * x77 - x5 * x79) - x5 * (x3 * x79 - x5 * x80) + x78,
            x3 * x81 - x5 * x82,
            x3 * x83 - x5 * x84,
            x3 * x85 - x5 * x86,
            x3 * x87 - x5 * x88,
            x33 * x81 + 3.0 * x66 - x7 * x82,
            x33 * x83 - x7 * x84 + 2.0 * x72,
            x33 * x85 - x7 * x86 + x78,
            x33 * x87 - x7 * x88,
            x48 * x87 + 3.0 * x78 - x88 * x9,
        ]
    )


def coulomb3d_10(a, A, b, B, C):
    """Cartesian (ps) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = x0 * (x3**2 + x5**2 + x7**2)
    x9 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x10 = x9 * boys(1, x8)
    x11 = x9 * boys(0, x8)

    # 3 item(s)
    return numpy.array(
        [
            -x10 * x3 + x11 * (-x2 - A[0]),
            -x10 * x5 + x11 * (-x4 - A[1]),
            -x10 * x7 + x11 * (-x6 - A[2]),
        ]
    )


def coulomb3d_11(a, A, b, B, C):
    """Cartesian (pp) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = x0 * (x3**2 + x5**2 + x7**2)
    x9 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x10 = x9 * boys(1, x8)
    x11 = x9 * boys(0, x8)
    x12 = (-x10 + x11) / (2.0 * a + 2.0 * b)
    x13 = -x2 - A[0]
    x14 = -x2 - B[0]
    x15 = x9 * boys(2, x8)
    x16 = -x10 * x5
    x17 = -x4 - B[1]
    x18 = x11 * x17 + x16
    x19 = -x15 * x5
    x20 = x10 * x17 + x19
    x21 = -x10 * x7
    x22 = -x6 - B[2]
    x23 = x11 * x22 + x21
    x24 = -x15 * x7
    x25 = x10 * x22 + x24
    x26 = -x4 - A[1]
    x27 = -x6 - A[2]
    x28 = x11 * x27 + x21
    x29 = x10 * x27 + x24

    # 9 item(s)
    return numpy.array(
        [
            x12 + x13 * (-x10 * x3 + x11 * x14) - x3 * (x10 * x14 - x15 * x3),
            x13 * x18 - x20 * x3,
            x13 * x23 - x25 * x3,
            x14 * (x11 * x26 + x16) - x3 * (x10 * x26 + x19),
            x12 + x18 * x26 - x20 * x5,
            x23 * x26 - x25 * x5,
            x14 * x28 - x29 * x3,
            x17 * x28 - x29 * x5,
            x12 + x23 * x27 - x25 * x7,
        ]
    )


def coulomb3d_12(a, A, b, B, C):
    """Cartesian (pd) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - C[0]
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x1 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x0 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(1, x10)
    x13 = x11 * boys(0, x10)
    x14 = x4 * (-x12 + x13)
    x15 = -x2 - B[0]
    x16 = -x12 * x5 + x13 * x15
    x17 = x11 * boys(2, x10)
    x18 = x17 * x5
    x19 = x12 * x15
    x20 = -x18 + x19
    x21 = x4 * (x12 - x17)
    x22 = x11 * boys(3, x10)
    x23 = -x6 - B[1]
    x24 = x12 * x23
    x25 = x17 * x7
    x26 = -x12 * x7
    x27 = x13 * x23 + x26
    x28 = x4 * (-x24 + x25 + x27)
    x29 = -x25
    x30 = x24 + x29
    x31 = -x22 * x7
    x32 = x17 * x23 + x31
    x33 = -x8 - B[2]
    x34 = x12 * x33
    x35 = x17 * x9
    x36 = -x12 * x9
    x37 = x13 * x33 + x36
    x38 = x4 * (-x34 + x35 + x37)
    x39 = -x35
    x40 = x34 + x39
    x41 = -x22 * x9
    x42 = x17 * x33 + x41
    x43 = x14 - x30 * x7
    x44 = x23 * x27 + x43
    x45 = x21 - x32 * x7
    x46 = x23 * x30 + x45
    x47 = -x40 * x7
    x48 = x23 * x37 + x47
    x49 = -x42 * x7
    x50 = x23 * x40 + x49
    x51 = x14 - x40 * x9
    x52 = x33 * x37 + x51
    x53 = x21 - x42 * x9
    x54 = x33 * x40 + x53
    x55 = -x6 - A[1]
    x56 = x12 * x55
    x57 = x13 * x55 + x26
    x58 = x29 + x56
    x59 = -x8 - A[2]
    x60 = x12 * x59
    x61 = x13 * x59 + x36
    x62 = x4 * (x35 - x60 + x61)
    x63 = x39 + x60
    x64 = x17 * x59 + x41
    x65 = x23 * x61 - x63 * x7
    x66 = x23 * x63 - x64 * x7
    x67 = x37 * x59 + x51
    x68 = x40 * x59 + x53

    # 18 item(s)
    return numpy.array(
        [
            x3 * (x14 + x15 * x16 - x20 * x5)
            + 2.0 * x4 * (x16 + x18 - x19)
            - x5 * (x15 * x20 + x21 - x5 * (x15 * x17 - x22 * x5)),
            x28 + x3 * (x15 * x27 - x30 * x5) - x5 * (x15 * x30 - x32 * x5),
            x3 * (x15 * x37 - x40 * x5) + x38 - x5 * (x15 * x40 - x42 * x5),
            x3 * x44 - x46 * x5,
            x3 * x48 - x5 * x50,
            x3 * x52 - x5 * x54,
            x15 * (x15 * x57 - x5 * x58)
            + x4 * (x25 - x56 + x57)
            - x5 * (x15 * x58 - x5 * (x17 * x55 + x31)),
            x15 * (x27 * x55 + x43) - x5 * (x30 * x55 + x45),
            x15 * (x37 * x55 + x47) - x5 * (x40 * x55 + x49),
            2.0 * x28 + x44 * x55 - x46 * x7,
            x38 + x48 * x55 - x50 * x7,
            x52 * x55 - x54 * x7,
            x15 * (x15 * x61 - x5 * x63) - x5 * (x15 * x63 - x5 * x64) + x62,
            x15 * x65 - x5 * x66,
            x15 * x67 - x5 * x68,
            x23 * x65 + x62 - x66 * x7,
            x23 * x67 - x68 * x7,
            2.0 * x38 + x52 * x59 - x54 * x9,
        ]
    )


def coulomb3d_13(a, A, b, B, C):
    """Cartesian (pf) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = -x2 - B[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = -x2 - C[0]
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 * (x10**2 + x6**2 + x8**2)
    x12 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x13 = x12 * boys(1, x11)
    x14 = x12 * boys(0, x11)
    x15 = x5 * (-x13 + x14)
    x16 = -x13 * x6 + x14 * x4
    x17 = x12 * boys(2, x11)
    x18 = x17 * x6
    x19 = x13 * x4
    x20 = -x18 + x19
    x21 = x15 + x16 * x4 - x20 * x6
    x22 = x5 * (x13 - x17)
    x23 = x20 * x4
    x24 = x12 * boys(3, x11)
    x25 = x24 * x6
    x26 = x17 * x4
    x27 = -x25 + x26
    x28 = x27 * x6
    x29 = x22 + x23 - x28
    x30 = 2.0 * x5
    x31 = x5 * (x17 - x24)
    x32 = x12 * boys(4, x11)
    x33 = -x22
    x34 = -x7 - B[1]
    x35 = x13 * x34
    x36 = x17 * x8
    x37 = -x13 * x8
    x38 = x14 * x34 + x37
    x39 = x5 * (-x35 + x36 + x38)
    x40 = -x36
    x41 = x35 + x40
    x42 = x38 * x4 - x41 * x6
    x43 = x4 * x41
    x44 = x24 * x8
    x45 = -x44
    x46 = x17 * x34
    x47 = x45 + x46
    x48 = x47 * x6
    x49 = x43 - x48
    x50 = x5 * (x41 + x44 - x46)
    x51 = -x32 * x8
    x52 = x24 * x34 + x51
    x53 = -x9 - B[2]
    x54 = x13 * x53
    x55 = x10 * x17
    x56 = -x10 * x13
    x57 = x14 * x53 + x56
    x58 = x5 * (-x54 + x55 + x57)
    x59 = -x55
    x60 = x54 + x59
    x61 = x4 * x57 - x6 * x60
    x62 = x4 * x60
    x63 = x10 * x24
    x64 = -x63
    x65 = x17 * x53
    x66 = x64 + x65
    x67 = x6 * x66
    x68 = x62 - x67
    x69 = x5 * (x60 + x63 - x65)
    x70 = -x10 * x32
    x71 = x24 * x53 + x70
    x72 = x34 * x41
    x73 = x15 - x41 * x8
    x74 = x34 * x38 + x73
    x75 = x47 * x8
    x76 = x33 + x75
    x77 = x5 * (-x72 + x74 + x76)
    x78 = x22 - x75
    x79 = x72 + x78
    x80 = x31 - x52 * x8
    x81 = x34 * x47 + x80
    x82 = x66 * x8
    x83 = x34 * x60
    x84 = -x60 * x8
    x85 = x34 * x57 + x84
    x86 = x5 * (x82 - x83 + x85)
    x87 = -x82
    x88 = x83 + x87
    x89 = -x71 * x8
    x90 = x34 * x66 + x89
    x91 = x53 * x60
    x92 = -x10 * x60 + x15
    x93 = x53 * x57 + x92
    x94 = x10 * x66
    x95 = x33 + x94
    x96 = x5 * (-x91 + x93 + x95)
    x97 = x22 - x94
    x98 = x91 + x97
    x99 = -x10 * x71 + x31
    x100 = x53 * x66 + x99
    x101 = 2.0 * x39 - x79 * x8
    x102 = x101 + x34 * x74
    x103 = 2.0 * x50 - x8 * x81
    x104 = x103 + x34 * x79
    x105 = x58 - x8 * x88
    x106 = x105 + x34 * x85
    x107 = x69 - x8 * x90
    x108 = x107 + x34 * x88
    x109 = -x8 * x98
    x110 = x109 + x34 * x93
    x111 = -x100 * x8
    x112 = x111 + x34 * x98
    x113 = -x10 * x98 + 2.0 * x58
    x114 = x113 + x53 * x93
    x115 = -x10 * x100 + 2.0 * x69
    x116 = x115 + x53 * x98
    x117 = -x7 - A[1]
    x118 = x117 * x13
    x119 = x117 * x14 + x37
    x120 = x118 + x40
    x121 = x119 * x4 - x120 * x6
    x122 = x120 * x4
    x123 = x117 * x17
    x124 = x123 + x45
    x125 = x124 * x6
    x126 = x122 - x125
    x127 = x117 * x41
    x128 = x117 * x38 + x73
    x129 = x127 + x78
    x130 = x117 * x60
    x131 = x117 * x57 + x84
    x132 = x130 + x87
    x133 = -x9 - A[2]
    x134 = x13 * x133
    x135 = x133 * x14 + x56
    x136 = x5 * (-x134 + x135 + x55)
    x137 = x134 + x59
    x138 = x135 * x4 - x137 * x6
    x139 = x137 * x4
    x140 = x133 * x17
    x141 = x140 + x64
    x142 = x141 * x6
    x143 = x139 - x142
    x144 = x5 * (x137 - x140 + x63)
    x145 = x133 * x24 + x70
    x146 = x141 * x8
    x147 = x137 * x34
    x148 = x135 * x34 - x137 * x8
    x149 = x5 * (x146 - x147 + x148)
    x150 = -x146 + x147
    x151 = x141 * x34 - x145 * x8
    x152 = x133 * x60
    x153 = x133 * x57 + x92
    x154 = x5 * (-x152 + x153 + x95)
    x155 = x152 + x97
    x156 = x133 * x66 + x99
    x157 = x136 + x148 * x34 - x150 * x8
    x158 = x144 + x150 * x34 - x151 * x8
    x159 = x153 * x34 - x155 * x8
    x160 = x155 * x34 - x156 * x8
    x161 = x113 + x133 * x93
    x162 = x115 + x133 * x98

    # 30 item(s)
    return numpy.array(
        [
            x3 * (x21 * x4 - x29 * x6 + x30 * (x16 + x18 - x19))
            + 3.0 * x5 * (x21 - x23 + x28 + x33)
            - x6
            * (
                x29 * x4
                + x30 * (x20 + x25 - x26)
                - x6 * (x27 * x4 + x31 - x6 * (x24 * x4 - x32 * x6))
            ),
            x3 * (x39 + x4 * x42 - x49 * x6)
            + x30 * (x42 - x43 + x48)
            - x6 * (x4 * x49 + x50 - x6 * (x4 * x47 - x52 * x6)),
            x3 * (x4 * x61 + x58 - x6 * x68)
            + x30 * (x61 - x62 + x67)
            - x6 * (x4 * x68 - x6 * (x4 * x66 - x6 * x71) + x69),
            x3 * (x4 * x74 - x6 * x79) - x6 * (x4 * x79 - x6 * x81) + x77,
            x3 * (x4 * x85 - x6 * x88) - x6 * (x4 * x88 - x6 * x90) + x86,
            x3 * (x4 * x93 - x6 * x98) - x6 * (-x100 * x6 + x4 * x98) + x96,
            x102 * x3 - x104 * x6,
            x106 * x3 - x108 * x6,
            x110 * x3 - x112 * x6,
            x114 * x3 - x116 * x6,
            x30 * (x121 - x122 + x125)
            + x4 * (x121 * x4 - x126 * x6 + x5 * (-x118 + x119 + x36))
            - x6
            * (
                x126 * x4
                + x5 * (x120 - x123 + x44)
                - x6 * (x124 * x4 - x6 * (x117 * x24 + x51))
            ),
            x4 * (x128 * x4 - x129 * x6)
            + x5 * (-x127 + x128 + x76)
            - x6 * (x129 * x4 - x6 * (x117 * x47 + x80)),
            x4 * (x131 * x4 - x132 * x6)
            + x5 * (-x130 + x131 + x82)
            - x6 * (x132 * x4 - x6 * (x117 * x66 + x89)),
            x4 * (x101 + x117 * x74) - x6 * (x103 + x117 * x79),
            x4 * (x105 + x117 * x85) - x6 * (x107 + x117 * x88),
            x4 * (x109 + x117 * x93) - x6 * (x111 + x117 * x98),
            x102 * x117 - x104 * x8 + 3.0 * x77,
            x106 * x117 - x108 * x8 + 2.0 * x86,
            x110 * x117 - x112 * x8 + x96,
            x114 * x117 - x116 * x8,
            x30 * (x138 - x139 + x142)
            + x4 * (x136 + x138 * x4 - x143 * x6)
            - x6 * (x143 * x4 + x144 - x6 * (x141 * x4 - x145 * x6)),
            x149 + x4 * (x148 * x4 - x150 * x6) - x6 * (x150 * x4 - x151 * x6),
            x154 + x4 * (x153 * x4 - x155 * x6) - x6 * (x155 * x4 - x156 * x6),
            x157 * x4 - x158 * x6,
            x159 * x4 - x160 * x6,
            x161 * x4 - x162 * x6,
            2.0 * x149 + x157 * x34 - x158 * x8,
            x154 + x159 * x34 - x160 * x8,
            x161 * x34 - x162 * x8,
            -x10 * x116 + x114 * x133 + 3.0 * x96,
        ]
    )


def coulomb3d_14(a, A, b, B, C):
    """Cartesian (pg) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = -x2 - B[0]
    x5 = (2.0 * a + 2.0 * b) ** (-1.0)
    x6 = -x2 - C[0]
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 * (x10**2 + x6**2 + x8**2)
    x12 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x13 = x12 * boys(1, x11)
    x14 = x12 * boys(0, x11)
    x15 = x5 * (-x13 + x14)
    x16 = -x13 * x6 + x14 * x4
    x17 = x12 * boys(2, x11)
    x18 = x17 * x6
    x19 = x13 * x4
    x20 = -x18 + x19
    x21 = x15 + x16 * x4 - x20 * x6
    x22 = x5 * (x13 - x17)
    x23 = x20 * x4
    x24 = x12 * boys(3, x11)
    x25 = x24 * x6
    x26 = x17 * x4
    x27 = -x25 + x26
    x28 = x27 * x6
    x29 = x22 + x23 - x28
    x30 = 2.0 * x5
    x31 = x21 * x4 - x29 * x6 + x30 * (x16 + x18 - x19)
    x32 = x29 * x4
    x33 = x5 * (x17 - x24)
    x34 = x27 * x4
    x35 = x12 * boys(4, x11)
    x36 = x35 * x6
    x37 = x24 * x4
    x38 = -x36 + x37
    x39 = x38 * x6
    x40 = x33 + x34 - x39
    x41 = x40 * x6
    x42 = x30 * (x20 + x25 - x26)
    x43 = x32 - x41 + x42
    x44 = -x22
    x45 = 3.0 * x5
    x46 = x5 * (x24 - x35)
    x47 = x12 * boys(5, x11)
    x48 = -x33
    x49 = -x7 - B[1]
    x50 = x13 * x49
    x51 = x17 * x8
    x52 = -x13 * x8
    x53 = x14 * x49 + x52
    x54 = x5 * (-x50 + x51 + x53)
    x55 = -x51
    x56 = x50 + x55
    x57 = x4 * x53 - x56 * x6
    x58 = x4 * x56
    x59 = x24 * x8
    x60 = -x59
    x61 = x17 * x49
    x62 = x60 + x61
    x63 = x6 * x62
    x64 = x58 - x63
    x65 = x4 * x57 + x54 - x6 * x64
    x66 = x5 * (x56 + x59 - x61)
    x67 = x4 * x64
    x68 = x4 * x62
    x69 = x35 * x8
    x70 = -x69
    x71 = x24 * x49
    x72 = x70 + x71
    x73 = x6 * x72
    x74 = x68 - x73
    x75 = x6 * x74
    x76 = x66 + x67 - x75
    x77 = x5 * (x62 + x69 - x71)
    x78 = -x47 * x8
    x79 = x35 * x49 + x78
    x80 = -x9 - B[2]
    x81 = x13 * x80
    x82 = x10 * x17
    x83 = -x10 * x13
    x84 = x14 * x80 + x83
    x85 = x5 * (-x81 + x82 + x84)
    x86 = -x82
    x87 = x81 + x86
    x88 = x4 * x84 - x6 * x87
    x89 = x4 * x87
    x90 = x10 * x24
    x91 = -x90
    x92 = x17 * x80
    x93 = x91 + x92
    x94 = x6 * x93
    x95 = x89 - x94
    x96 = x4 * x88 - x6 * x95 + x85
    x97 = x5 * (x87 + x90 - x92)
    x98 = x4 * x95
    x99 = x4 * x93
    x100 = x10 * x35
    x101 = -x100
    x102 = x24 * x80
    x103 = x101 + x102
    x104 = x103 * x6
    x105 = -x104 + x99
    x106 = x105 * x6
    x107 = -x106 + x97 + x98
    x108 = x5 * (x100 - x102 + x93)
    x109 = -x10 * x47
    x110 = x109 + x35 * x80
    x111 = -x97
    x112 = x49 * x56
    x113 = x15 - x56 * x8
    x114 = x113 + x49 * x53
    x115 = x62 * x8
    x116 = x115 + x44
    x117 = x5 * (-x112 + x114 + x116)
    x118 = -x115 + x22
    x119 = x112 + x118
    x120 = x114 * x4 - x119 * x6
    x121 = x119 * x4
    x122 = x49 * x62
    x123 = x72 * x8
    x124 = -x123 + x33
    x125 = x122 + x124
    x126 = x125 * x6
    x127 = x121 - x126
    x128 = x123 + x48
    x129 = x5 * (x119 - x122 + x128)
    x130 = x46 - x79 * x8
    x131 = x130 + x49 * x72
    x132 = x8 * x93
    x133 = x49 * x87
    x134 = -x8 * x87
    x135 = x134 + x49 * x84
    x136 = x5 * (x132 - x133 + x135)
    x137 = -x132
    x138 = x133 + x137
    x139 = x135 * x4 - x138 * x6
    x140 = x138 * x4
    x141 = x49 * x93
    x142 = x103 * x8
    x143 = -x142
    x144 = x141 + x143
    x145 = x144 * x6
    x146 = x140 - x145
    x147 = x5 * (x138 - x141 + x142)
    x148 = -x110 * x8
    x149 = x103 * x49 + x148
    x150 = x80 * x87
    x151 = -x10 * x87 + x15
    x152 = x151 + x80 * x84
    x153 = x10 * x93
    x154 = x153 + x44
    x155 = x5 * (-x150 + x152 + x154)
    x156 = -x153 + x22
    x157 = x150 + x156
    x158 = x152 * x4 - x157 * x6
    x159 = x157 * x4
    x160 = x80 * x93
    x161 = x10 * x103
    x162 = -x161 + x33
    x163 = x160 + x162
    x164 = x163 * x6
    x165 = x159 - x164
    x166 = x161 + x48
    x167 = x5 * (x157 - x160 + x166)
    x168 = -x10 * x110 + x46
    x169 = x103 * x80 + x168
    x170 = x119 * x49
    x171 = -x119 * x8 + 2.0 * x54
    x172 = x114 * x49 + x171
    x173 = x125 * x8
    x174 = 2.0 * x66
    x175 = x173 - x174
    x176 = x5 * (-x170 + x172 + x175)
    x177 = -x173 + x174
    x178 = x170 + x177
    x179 = -x131 * x8 + 2.0 * x77
    x180 = x125 * x49 + x179
    x181 = x138 * x49
    x182 = -x138 * x8 + x85
    x183 = x135 * x49 + x182
    x184 = x144 * x8
    x185 = x111 + x184
    x186 = x5 * (-x181 + x183 + x185)
    x187 = -x184 + x97
    x188 = x181 + x187
    x189 = x108 - x149 * x8
    x190 = x144 * x49 + x189
    x191 = x163 * x8
    x192 = x157 * x49
    x193 = -x157 * x8
    x194 = x152 * x49 + x193
    x195 = x5 * (x191 - x192 + x194)
    x196 = -x191
    x197 = x192 + x196
    x198 = -x169 * x8
    x199 = x163 * x49 + x198
    x200 = x157 * x80
    x201 = -x10 * x157 + 2.0 * x85
    x202 = x152 * x80 + x201
    x203 = x10 * x163
    x204 = 2.0 * x97
    x205 = x203 - x204
    x206 = x5 * (-x200 + x202 + x205)
    x207 = -x203 + x204
    x208 = x200 + x207
    x209 = -x10 * x169 + 2.0 * x108
    x210 = x163 * x80 + x209
    x211 = 3.0 * x117 - x178 * x8
    x212 = x172 * x49 + x211
    x213 = 3.0 * x129 - x180 * x8
    x214 = x178 * x49 + x213
    x215 = 2.0 * x136 - x188 * x8
    x216 = x183 * x49 + x215
    x217 = 2.0 * x147 - x190 * x8
    x218 = x188 * x49 + x217
    x219 = x155 - x197 * x8
    x220 = x194 * x49 + x219
    x221 = x167 - x199 * x8
    x222 = x197 * x49 + x221
    x223 = -x208 * x8
    x224 = x202 * x49 + x223
    x225 = -x210 * x8
    x226 = x208 * x49 + x225
    x227 = -x10 * x208 + 3.0 * x155
    x228 = x202 * x80 + x227
    x229 = -x10 * x210 + 3.0 * x167
    x230 = x208 * x80 + x229
    x231 = -x7 - A[1]
    x232 = x13 * x231
    x233 = x14 * x231 + x52
    x234 = x232 + x55
    x235 = x233 * x4 - x234 * x6
    x236 = x234 * x4
    x237 = x17 * x231
    x238 = x237 + x60
    x239 = x238 * x6
    x240 = x236 - x239
    x241 = x235 * x4 - x240 * x6 + x5 * (-x232 + x233 + x51)
    x242 = x5 * (x234 - x237 + x59)
    x243 = x240 * x4
    x244 = x238 * x4
    x245 = x231 * x24
    x246 = x245 + x70
    x247 = x246 * x6
    x248 = x244 - x247
    x249 = x248 * x6
    x250 = x242 + x243 - x249
    x251 = x231 * x56
    x252 = x113 + x231 * x53
    x253 = x118 + x251
    x254 = x252 * x4 - x253 * x6
    x255 = x253 * x4
    x256 = x231 * x62
    x257 = x124 + x256
    x258 = x257 * x6
    x259 = x255 - x258
    x260 = x231 * x87
    x261 = x134 + x231 * x84
    x262 = x137 + x260
    x263 = x261 * x4 - x262 * x6
    x264 = x262 * x4
    x265 = x231 * x93
    x266 = x143 + x265
    x267 = x266 * x6
    x268 = x264 - x267
    x269 = x119 * x231
    x270 = x114 * x231 + x171
    x271 = x177 + x269
    x272 = x138 * x231
    x273 = x135 * x231 + x182
    x274 = x187 + x272
    x275 = x157 * x231
    x276 = x152 * x231 + x193
    x277 = x196 + x275
    x278 = -x9 - A[2]
    x279 = x13 * x278
    x280 = x14 * x278 + x83
    x281 = x5 * (-x279 + x280 + x82)
    x282 = x279 + x86
    x283 = x280 * x4 - x282 * x6
    x284 = x282 * x4
    x285 = x17 * x278
    x286 = x285 + x91
    x287 = x286 * x6
    x288 = x284 - x287
    x289 = x281 + x283 * x4 - x288 * x6
    x290 = x5 * (x282 - x285 + x90)
    x291 = x288 * x4
    x292 = x286 * x4
    x293 = x24 * x278
    x294 = x101 + x293
    x295 = x294 * x6
    x296 = x292 - x295
    x297 = x296 * x6
    x298 = x290 + x291 - x297
    x299 = x5 * (x100 + x286 - x293)
    x300 = x109 + x278 * x35
    x301 = -x290
    x302 = x286 * x8
    x303 = x282 * x49
    x304 = x280 * x49 - x282 * x8
    x305 = x5 * (x302 - x303 + x304)
    x306 = -x302 + x303
    x307 = x304 * x4 - x306 * x6
    x308 = x306 * x4
    x309 = x286 * x49
    x310 = x294 * x8
    x311 = x309 - x310
    x312 = x311 * x6
    x313 = x308 - x312
    x314 = x5 * (x306 - x309 + x310)
    x315 = x294 * x49 - x300 * x8
    x316 = x278 * x87
    x317 = x151 + x278 * x84
    x318 = x5 * (x154 - x316 + x317)
    x319 = x156 + x316
    x320 = x317 * x4 - x319 * x6
    x321 = x319 * x4
    x322 = x278 * x93
    x323 = x162 + x322
    x324 = x323 * x6
    x325 = x321 - x324
    x326 = x5 * (x166 + x319 - x322)
    x327 = x103 * x278 + x168
    x328 = x311 * x8
    x329 = x306 * x49
    x330 = x281 + x304 * x49 - x306 * x8
    x331 = x5 * (x301 + x328 - x329 + x330)
    x332 = x290 - x328 + x329
    x333 = x299 + x311 * x49 - x315 * x8
    x334 = x323 * x8
    x335 = x319 * x49
    x336 = x317 * x49 - x319 * x8
    x337 = x5 * (x334 - x335 + x336)
    x338 = -x334 + x335
    x339 = x323 * x49 - x327 * x8
    x340 = x157 * x278
    x341 = x152 * x278 + x201
    x342 = x5 * (x205 - x340 + x341)
    x343 = x207 + x340
    x344 = x163 * x278 + x209
    x345 = 2.0 * x305 + x330 * x49 - x332 * x8
    x346 = 2.0 * x314 + x332 * x49 - x333 * x8
    x347 = x318 + x336 * x49 - x338 * x8
    x348 = x326 + x338 * x49 - x339 * x8
    x349 = x341 * x49 - x343 * x8
    x350 = x343 * x49 - x344 * x8
    x351 = x202 * x278 + x227
    x352 = x208 * x278 + x229

    # 45 item(s)
    return numpy.array(
        [
            x3 * (x31 * x4 - x43 * x6 + x45 * (x21 - x23 + x28 + x44))
            + 4.0 * x5 * (x31 - x32 + x41 - x42)
            - x6
            * (
                x4 * x43
                + x45 * (x29 - x34 + x39 + x48)
                - x6
                * (
                    x30 * (x27 + x36 - x37)
                    + x4 * x40
                    - x6 * (x38 * x4 + x46 - x6 * (x35 * x4 - x47 * x6))
                )
            ),
            x3 * (x30 * (x57 - x58 + x63) + x4 * x65 - x6 * x76)
            + x45 * (x65 - x66 - x67 + x75)
            - x6
            * (
                x30 * (x64 - x68 + x73)
                + x4 * x76
                - x6 * (x4 * x74 - x6 * (x4 * x72 - x6 * x79) + x77)
            ),
            x3 * (-x107 * x6 + x30 * (x88 - x89 + x94) + x4 * x96)
            + x45 * (x106 + x111 + x96 - x98)
            - x6
            * (
                x107 * x4
                + x30 * (x104 + x95 - x99)
                - x6 * (x105 * x4 + x108 - x6 * (x103 * x4 - x110 * x6))
            ),
            x3 * (x117 + x120 * x4 - x127 * x6)
            + x30 * (x120 - x121 + x126)
            - x6 * (x127 * x4 + x129 - x6 * (x125 * x4 - x131 * x6)),
            x3 * (x136 + x139 * x4 - x146 * x6)
            + x30 * (x139 - x140 + x145)
            - x6 * (x146 * x4 + x147 - x6 * (x144 * x4 - x149 * x6)),
            x3 * (x155 + x158 * x4 - x165 * x6)
            + x30 * (x158 - x159 + x164)
            - x6 * (x165 * x4 + x167 - x6 * (x163 * x4 - x169 * x6)),
            x176 + x3 * (x172 * x4 - x178 * x6) - x6 * (x178 * x4 - x180 * x6),
            x186 + x3 * (x183 * x4 - x188 * x6) - x6 * (x188 * x4 - x190 * x6),
            x195 + x3 * (x194 * x4 - x197 * x6) - x6 * (x197 * x4 - x199 * x6),
            x206 + x3 * (x202 * x4 - x208 * x6) - x6 * (x208 * x4 - x210 * x6),
            x212 * x3 - x214 * x6,
            x216 * x3 - x218 * x6,
            x220 * x3 - x222 * x6,
            x224 * x3 - x226 * x6,
            x228 * x3 - x230 * x6,
            x4 * (x241 * x4 - x250 * x6 + x30 * (x235 - x236 + x239))
            + x45 * (x241 - x242 - x243 + x249)
            - x6
            * (
                x250 * x4
                + x30 * (x240 - x244 + x247)
                - x6
                * (
                    x248 * x4
                    + x5 * (x238 - x245 + x69)
                    - x6 * (x246 * x4 - x6 * (x231 * x35 + x78))
                )
            ),
            x30 * (x254 - x255 + x258)
            + x4 * (x254 * x4 - x259 * x6 + x5 * (x116 - x251 + x252))
            - x6
            * (
                x259 * x4
                + x5 * (x128 + x253 - x256)
                - x6 * (x257 * x4 - x6 * (x130 + x231 * x72))
            ),
            x30 * (x263 - x264 + x267)
            + x4 * (x263 * x4 - x268 * x6 + x5 * (x132 - x260 + x261))
            - x6
            * (
                x268 * x4
                + x5 * (x142 + x262 - x265)
                - x6 * (x266 * x4 - x6 * (x103 * x231 + x148))
            ),
            x4 * (x270 * x4 - x271 * x6)
            + x5 * (x175 - x269 + x270)
            - x6 * (x271 * x4 - x6 * (x125 * x231 + x179)),
            x4 * (x273 * x4 - x274 * x6)
            + x5 * (x185 - x272 + x273)
            - x6 * (x274 * x4 - x6 * (x144 * x231 + x189)),
            x4 * (x276 * x4 - x277 * x6)
            + x5 * (x191 - x275 + x276)
            - x6 * (x277 * x4 - x6 * (x163 * x231 + x198)),
            x4 * (x172 * x231 + x211) - x6 * (x178 * x231 + x213),
            x4 * (x183 * x231 + x215) - x6 * (x188 * x231 + x217),
            x4 * (x194 * x231 + x219) - x6 * (x197 * x231 + x221),
            x4 * (x202 * x231 + x223) - x6 * (x208 * x231 + x225),
            4.0 * x176 + x212 * x231 - x214 * x8,
            3.0 * x186 + x216 * x231 - x218 * x8,
            2.0 * x195 + x220 * x231 - x222 * x8,
            x206 + x224 * x231 - x226 * x8,
            x228 * x231 - x230 * x8,
            x4 * (x289 * x4 - x298 * x6 + x30 * (x283 - x284 + x287))
            + x45 * (x289 - x291 + x297 + x301)
            - x6
            * (
                x298 * x4
                + x30 * (x288 - x292 + x295)
                - x6 * (x296 * x4 + x299 - x6 * (x294 * x4 - x300 * x6))
            ),
            x30 * (x307 - x308 + x312)
            + x4 * (x305 + x307 * x4 - x313 * x6)
            - x6 * (x313 * x4 + x314 - x6 * (x311 * x4 - x315 * x6)),
            x30 * (x320 - x321 + x324)
            + x4 * (x318 + x320 * x4 - x325 * x6)
            - x6 * (x325 * x4 + x326 - x6 * (x323 * x4 - x327 * x6)),
            x331 + x4 * (x330 * x4 - x332 * x6) - x6 * (x332 * x4 - x333 * x6),
            x337 + x4 * (x336 * x4 - x338 * x6) - x6 * (x338 * x4 - x339 * x6),
            x342 + x4 * (x341 * x4 - x343 * x6) - x6 * (x343 * x4 - x344 * x6),
            x345 * x4 - x346 * x6,
            x347 * x4 - x348 * x6,
            x349 * x4 - x350 * x6,
            x351 * x4 - x352 * x6,
            3.0 * x331 + x345 * x49 - x346 * x8,
            2.0 * x337 + x347 * x49 - x348 * x8,
            x342 + x349 * x49 - x350 * x8,
            x351 * x49 - x352 * x8,
            -x10 * x230 + 4.0 * x206 + x228 * x278,
        ]
    )


def coulomb3d_20(a, A, b, B, C):
    """Cartesian (ds) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x1 * (a * A[1] + b * B[1])
    x5 = -x4 - C[1]
    x6 = -x1 * (a * A[2] + b * B[2])
    x7 = -x6 - C[2]
    x8 = x0 * (x3**2 + x5**2 + x7**2)
    x9 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x10 = x9 * boys(1, x8)
    x11 = x9 * boys(0, x8)
    x12 = (-x10 + x11) / (2.0 * a + 2.0 * b)
    x13 = -x2 - A[0]
    x14 = x9 * boys(2, x8)
    x15 = -x4 - A[1]
    x16 = -x10 * x5 + x11 * x15
    x17 = x10 * x15 - x14 * x5
    x18 = -x6 - A[2]
    x19 = -x10 * x7 + x11 * x18
    x20 = x10 * x18 - x14 * x7

    # 6 item(s)
    return numpy.array(
        [
            x12 + x13 * (-x10 * x3 + x11 * x13) - x3 * (x10 * x13 - x14 * x3),
            x13 * x16 - x17 * x3,
            x13 * x19 - x20 * x3,
            x12 + x15 * x16 - x17 * x5,
            x15 * x19 - x20 * x5,
            x12 + x18 * x19 - x20 * x7,
        ]
    )


def coulomb3d_21(a, A, b, B, C):
    """Cartesian (dp) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = -x3 - C[0]
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x2 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x1 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x2
        * numpy.exp(
            -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(1, x10)
    x13 = -x12 * x5
    x14 = x11 * boys(0, x10)
    x15 = x11 * boys(2, x10)
    x16 = x15 * x5
    x17 = -x3 - B[0]
    x18 = x12 * x17
    x19 = x13 + x14 * x17
    x20 = x0 * (-x12 + x14)
    x21 = -x16 + x18
    x22 = x0 * (x12 - x15)
    x23 = x11 * boys(3, x10)
    x24 = -x6 - B[1]
    x25 = x12 * x24
    x26 = x15 * x7
    x27 = -x12 * x7
    x28 = x14 * x24 + x27
    x29 = x0 * (-x25 + x26 + x28)
    x30 = -x26
    x31 = x25 + x30
    x32 = -x23 * x7
    x33 = x15 * x24 + x32
    x34 = -x8 - B[2]
    x35 = x12 * x34
    x36 = x15 * x9
    x37 = -x12 * x9
    x38 = x14 * x34 + x37
    x39 = x0 * (-x35 + x36 + x38)
    x40 = -x36
    x41 = x35 + x40
    x42 = -x23 * x9
    x43 = x15 * x34 + x42
    x44 = -x6 - A[1]
    x45 = x12 * x44
    x46 = x14 * x44 + x27
    x47 = x0 * (x26 - x45 + x46)
    x48 = x30 + x45
    x49 = x15 * x44 + x32
    x50 = x20 + x28 * x44 - x31 * x7
    x51 = x22 + x31 * x44 - x33 * x7
    x52 = x38 * x44 - x41 * x7
    x53 = x41 * x44 - x43 * x7
    x54 = -x8 - A[2]
    x55 = x12 * x54
    x56 = x14 * x54 + x37
    x57 = x0 * (x36 - x55 + x56)
    x58 = x40 + x55
    x59 = x15 * x54 + x42
    x60 = -x58 * x7
    x61 = x24 * x56 + x60
    x62 = -x59 * x7
    x63 = x24 * x58 + x62
    x64 = x20 + x38 * x54 - x41 * x9
    x65 = x22 + x41 * x54 - x43 * x9
    x66 = x20 + x54 * x56 - x58 * x9
    x67 = x22 + x54 * x58 - x59 * x9

    # 18 item(s)
    return numpy.array(
        [
            x0 * (x16 - x18 + x19)
            + x0 * (-x12 * x4 + x13 + x14 * x4 + x16)
            + x4 * (x19 * x4 + x20 - x21 * x5)
            - x5 * (x21 * x4 + x22 - x5 * (x15 * x17 - x23 * x5)),
            x29 + x4 * (x28 * x4 - x31 * x5) - x5 * (x31 * x4 - x33 * x5),
            x39 + x4 * (x38 * x4 - x41 * x5) - x5 * (x4 * x41 - x43 * x5),
            x4 * (x17 * x46 - x48 * x5) + x47 - x5 * (x17 * x48 - x49 * x5),
            x4 * x50 - x5 * x51,
            x4 * x52 - x5 * x53,
            x4 * (x17 * x56 - x5 * x58) - x5 * (x17 * x58 - x5 * x59) + x57,
            x4 * x61 - x5 * x63,
            x4 * x64 - x5 * x65,
            x17 * (x20 + x44 * x46 - x48 * x7) - x5 * (x22 + x44 * x48 - x49 * x7),
            x29 + x44 * x50 + x47 - x51 * x7,
            x39 + x44 * x52 - x53 * x7,
            x17 * (x44 * x56 + x60) - x5 * (x44 * x58 + x62),
            x44 * x61 + x57 - x63 * x7,
            x44 * x64 - x65 * x7,
            x17 * x66 - x5 * x67,
            x24 * x66 - x67 * x7,
            x39 + x54 * x64 + x57 - x65 * x9,
        ]
    )


def coulomb3d_22(a, A, b, B, C):
    """Cartesian (dd) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - B[0]
    x5 = -x3 - C[0]
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x2 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x1 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x2
        * numpy.exp(
            -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(2, x10)
    x13 = x12 * x5
    x14 = x11 * boys(1, x10)
    x15 = x14 * x4
    x16 = -x13 + x15
    x17 = x16 * x4
    x18 = x11 * boys(0, x10)
    x19 = -x14 * x5 + x18 * x4
    x20 = x0 * (-x14 + x18)
    x21 = -x16 * x5 + x20
    x22 = x19 * x4 + x21
    x23 = x11 * boys(3, x10)
    x24 = x23 * x5
    x25 = x12 * x4
    x26 = -x24 + x25
    x27 = x26 * x5
    x28 = x0 * (-x12 + x14)
    x29 = -x28
    x30 = x27 + x29
    x31 = -x3 - A[0]
    x32 = x17 - x27 + x28
    x33 = 2.0 * x0
    x34 = x0 * (x12 - x23)
    x35 = x11 * boys(4, x10)
    x36 = -x14 * x7
    x37 = -x6 - B[1]
    x38 = x18 * x37 + x36
    x39 = x23 * x7
    x40 = -x39
    x41 = x12 * x37
    x42 = x40 + x41
    x43 = x42 * x5
    x44 = x12 * x7
    x45 = -x44
    x46 = x14 * x37
    x47 = x45 + x46
    x48 = -x47 * x5
    x49 = x4 * x47
    x50 = x38 * x4 + x48
    x51 = x0 * (x38 + x44 - x46)
    x52 = -x43 + x49
    x53 = x0 * (x39 - x41 + x47)
    x54 = -x35 * x7
    x55 = x23 * x37 + x54
    x56 = -x14 * x9
    x57 = -x8 - B[2]
    x58 = x18 * x57 + x56
    x59 = x23 * x9
    x60 = -x59
    x61 = x12 * x57
    x62 = x60 + x61
    x63 = x5 * x62
    x64 = x12 * x9
    x65 = -x64
    x66 = x14 * x57
    x67 = x65 + x66
    x68 = -x5 * x67
    x69 = x4 * x67
    x70 = x4 * x58 + x68
    x71 = x0 * (x58 + x64 - x66)
    x72 = -x63 + x69
    x73 = x0 * (x59 - x61 + x67)
    x74 = -x35 * x9
    x75 = x23 * x57 + x74
    x76 = x37 * x47
    x77 = x20 - x47 * x7
    x78 = x37 * x38 + x77
    x79 = x42 * x7
    x80 = x29 + x79
    x81 = x0 * (-x76 + x78 + x80)
    x82 = x28 - x79
    x83 = x76 + x82
    x84 = x34 - x55 * x7
    x85 = x37 * x42 + x84
    x86 = x62 * x7
    x87 = x37 * x67
    x88 = -x67 * x7
    x89 = x37 * x58 + x88
    x90 = x0 * (x86 - x87 + x89)
    x91 = -x86
    x92 = x87 + x91
    x93 = -x7 * x75
    x94 = x37 * x62 + x93
    x95 = x57 * x67
    x96 = x20 - x67 * x9
    x97 = x57 * x58 + x96
    x98 = x62 * x9
    x99 = x29 + x98
    x100 = x0 * (-x95 + x97 + x99)
    x101 = x28 - x98
    x102 = x101 + x95
    x103 = x34 - x75 * x9
    x104 = x103 + x57 * x62
    x105 = -x6 - A[1]
    x106 = x105 * x14
    x107 = x105 * x18 + x36
    x108 = x0 * (-x106 + x107 + x44)
    x109 = x106 + x45
    x110 = x107 * x4 - x109 * x5
    x111 = x109 * x4
    x112 = x105 * x12
    x113 = x112 + x40
    x114 = x113 * x5
    x115 = x111 - x114
    x116 = x0 * (x109 - x112 + x39)
    x117 = x105 * x23 + x54
    x118 = x105 * x47
    x119 = x105 * x38 + x77
    x120 = x0 * (-x118 + x119 + x80)
    x121 = x118 + x82
    x122 = x105 * x42 + x84
    x123 = x105 * x67
    x124 = x105 * x58 + x88
    x125 = x0 * (-x123 + x124 + x86)
    x126 = x123 + x91
    x127 = x105 * x62 + x93
    x128 = x105 * x78 + 2.0 * x51 - x7 * x83
    x129 = x105 * x83 + 2.0 * x53 - x7 * x85
    x130 = x105 * x89 - x7 * x92 + x71
    x131 = x105 * x92 - x7 * x94 + x73
    x132 = -x102 * x7 + x105 * x97
    x133 = x102 * x105 - x104 * x7
    x134 = -x8 - A[2]
    x135 = x134 * x14
    x136 = x134 * x18 + x56
    x137 = x0 * (-x135 + x136 + x64)
    x138 = x135 + x65
    x139 = x136 * x4 - x138 * x5
    x140 = x138 * x4
    x141 = x12 * x134
    x142 = x141 + x60
    x143 = x142 * x5
    x144 = x140 - x143
    x145 = x0 * (x138 - x141 + x59)
    x146 = x134 * x23 + x74
    x147 = x142 * x7
    x148 = x138 * x37
    x149 = -x138 * x7
    x150 = x136 * x37 + x149
    x151 = x0 * (x147 - x148 + x150)
    x152 = -x147
    x153 = x148 + x152
    x154 = -x146 * x7
    x155 = x142 * x37 + x154
    x156 = x134 * x67
    x157 = x134 * x58 + x96
    x158 = x0 * (-x156 + x157 + x99)
    x159 = x101 + x156
    x160 = x103 + x134 * x62
    x161 = x137 - x153 * x7
    x162 = x150 * x37 + x161
    x163 = x145 - x155 * x7
    x164 = x153 * x37 + x163
    x165 = -x159 * x7
    x166 = x157 * x37 + x165
    x167 = -x160 * x7
    x168 = x159 * x37 + x167
    x169 = -x102 * x9 + x134 * x97 + 2.0 * x71
    x170 = x102 * x134 - x104 * x9 + 2.0 * x73
    x171 = x113 * x7
    x172 = x105 * x109
    x173 = x105 * x107 - x109 * x7 + x20
    x174 = -x171 + x172 + x28
    x175 = x105 * x138
    x176 = x105 * x136 + x149
    x177 = x152 + x175
    x178 = x142 * x9
    x179 = x134 * x138
    x180 = x134 * x136 - x138 * x9 + x20
    x181 = x0 * (x178 - x179 + x180 + x29)
    x182 = -x178 + x179 + x28
    x183 = x134 * x142 - x146 * x9 + x34
    x184 = x180 * x37 - x182 * x7
    x185 = x182 * x37 - x183 * x7
    x186 = x134 * x157 + x137 - x159 * x9 + x71
    x187 = x134 * x159 + x145 - x160 * x9 + x73

    # 36 item(s)
    return numpy.array(
        [
            x0 * (-x17 + x22 + x30)
            + x31 * (x22 * x31 - x32 * x5 + x33 * (x13 - x15 + x19))
            + x33 * (-x16 * x31 + x19 * x31 + x21 + x30)
            - x5
            * (
                x31 * x32
                + x33 * (x16 + x24 - x25)
                - x5 * (x26 * x4 + x34 - x5 * (x23 * x4 - x35 * x5))
            ),
            x0 * (x43 - x49 + x50)
            + x0 * (x31 * x38 - x31 * x47 + x43 + x48)
            + x31 * (x31 * x50 - x5 * x52 + x51)
            - x5 * (x31 * x52 - x5 * (x4 * x42 - x5 * x55) + x53),
            x0 * (x63 - x69 + x70)
            + x0 * (x31 * x58 - x31 * x67 + x63 + x68)
            + x31 * (x31 * x70 - x5 * x72 + x71)
            - x5 * (x31 * x72 - x5 * (x4 * x62 - x5 * x75) + x73),
            x31 * (x31 * x78 - x5 * x83) - x5 * (x31 * x83 - x5 * x85) + x81,
            x31 * (x31 * x89 - x5 * x92) - x5 * (x31 * x92 - x5 * x94) + x90,
            x100 + x31 * (-x102 * x5 + x31 * x97) - x5 * (x102 * x31 - x104 * x5),
            x31 * (x108 + x110 * x4 - x115 * x5)
            + x33 * (x110 - x111 + x114)
            - x5 * (x115 * x4 + x116 - x5 * (x113 * x4 - x117 * x5)),
            x120 + x31 * (x119 * x4 - x121 * x5) - x5 * (x121 * x4 - x122 * x5),
            x125 + x31 * (x124 * x4 - x126 * x5) - x5 * (x126 * x4 - x127 * x5),
            x128 * x31 - x129 * x5,
            x130 * x31 - x131 * x5,
            x132 * x31 - x133 * x5,
            x31 * (x137 + x139 * x4 - x144 * x5)
            + x33 * (x139 - x140 + x143)
            - x5 * (x144 * x4 + x145 - x5 * (x142 * x4 - x146 * x5)),
            x151 + x31 * (x150 * x4 - x153 * x5) - x5 * (x153 * x4 - x155 * x5),
            x158 + x31 * (x157 * x4 - x159 * x5) - x5 * (x159 * x4 - x160 * x5),
            x162 * x31 - x164 * x5,
            x166 * x31 - x168 * x5,
            x169 * x31 - x170 * x5,
            x0 * (x171 - x172 + x173 + x29)
            + x4 * (x173 * x4 - x174 * x5)
            - x5 * (x174 * x4 - x5 * (x105 * x113 - x117 * x7 + x34)),
            x4 * (x105 * x119 + x108 - x121 * x7 + x51)
            - x5 * (x105 * x121 + x116 - x122 * x7 + x53),
            x4 * (x105 * x124 - x126 * x7 + x71) - x5 * (x105 * x126 - x127 * x7 + x73),
            x105 * x128 + 2.0 * x120 - x129 * x7 + x81,
            x105 * x130 + x125 - x131 * x7 + x90,
            x100 + x105 * x132 - x133 * x7,
            x0 * (x147 - x175 + x176)
            + x4 * (x176 * x4 - x177 * x5)
            - x5 * (x177 * x4 - x5 * (x105 * x142 + x154)),
            x4 * (x105 * x150 + x161) - x5 * (x105 * x153 + x163),
            x4 * (x105 * x157 + x165) - x5 * (x105 * x159 + x167),
            x105 * x162 + 2.0 * x151 - x164 * x7,
            x105 * x166 + x158 - x168 * x7,
            x105 * x169 - x170 * x7,
            x181 + x4 * (x180 * x4 - x182 * x5) - x5 * (x182 * x4 - x183 * x5),
            x184 * x4 - x185 * x5,
            x186 * x4 - x187 * x5,
            x181 + x184 * x37 - x185 * x7,
            x186 * x37 - x187 * x7,
            x100 + x134 * x169 + 2.0 * x158 - x170 * x9,
        ]
    )


def coulomb3d_23(a, A, b, B, C):
    """Cartesian (df) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - B[0]
    x5 = -x3 - C[0]
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x2 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x1 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x2
        * numpy.exp(
            -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(2, x10)
    x13 = x11 * boys(1, x10)
    x14 = x0 * (-x12 + x13)
    x15 = x12 * x5
    x16 = x13 * x4
    x17 = -x15 + x16
    x18 = x17 * x4
    x19 = x11 * boys(3, x10)
    x20 = x19 * x5
    x21 = x12 * x4
    x22 = -x20 + x21
    x23 = x22 * x5
    x24 = x14 + x18 - x23
    x25 = x24 * x4
    x26 = x11 * boys(0, x10)
    x27 = x0 * (-x13 + x26)
    x28 = -x13 * x5 + x26 * x4
    x29 = -x17 * x5 + x27 + x28 * x4
    x30 = 2.0 * x0
    x31 = -x24 * x5 + x30 * (x15 - x16 + x28)
    x32 = x29 * x4 + x31
    x33 = x0 * (x12 - x19)
    x34 = x22 * x4
    x35 = x11 * boys(4, x10)
    x36 = x35 * x5
    x37 = x19 * x4
    x38 = -x36 + x37
    x39 = x38 * x5
    x40 = x33 + x34 - x39
    x41 = x40 * x5
    x42 = x30 * (x17 + x20 - x21)
    x43 = x41 - x42
    x44 = -x3 - A[0]
    x45 = x25 - x41 + x42
    x46 = -x14
    x47 = 3.0 * x0
    x48 = x0 * (x19 - x35)
    x49 = x11 * boys(5, x10)
    x50 = -x33
    x51 = x12 * x7
    x52 = -x51
    x53 = -x6 - B[1]
    x54 = x13 * x53
    x55 = x52 + x54
    x56 = x4 * x55
    x57 = x19 * x7
    x58 = -x57
    x59 = x12 * x53
    x60 = x58 + x59
    x61 = x5 * x60
    x62 = x56 - x61
    x63 = x4 * x62
    x64 = -x13 * x7
    x65 = x26 * x53 + x64
    x66 = x4 * x65 - x5 * x55
    x67 = x0 * (x51 - x54 + x65)
    x68 = -x5 * x62 + x67
    x69 = x4 * x66 + x68
    x70 = x4 * x60
    x71 = x35 * x7
    x72 = -x71
    x73 = x19 * x53
    x74 = x72 + x73
    x75 = x5 * x74
    x76 = x70 - x75
    x77 = x5 * x76
    x78 = x0 * (x55 + x57 - x59)
    x79 = -x78
    x80 = x77 + x79
    x81 = x63 - x77 + x78
    x82 = x0 * (x60 + x71 - x73)
    x83 = -x49 * x7
    x84 = x35 * x53 + x83
    x85 = x12 * x9
    x86 = -x85
    x87 = -x8 - B[2]
    x88 = x13 * x87
    x89 = x86 + x88
    x90 = x4 * x89
    x91 = x19 * x9
    x92 = -x91
    x93 = x12 * x87
    x94 = x92 + x93
    x95 = x5 * x94
    x96 = x90 - x95
    x97 = x4 * x96
    x98 = -x13 * x9
    x99 = x26 * x87 + x98
    x100 = x4 * x99 - x5 * x89
    x101 = x0 * (x85 - x88 + x99)
    x102 = x101 - x5 * x96
    x103 = x100 * x4 + x102
    x104 = x4 * x94
    x105 = x35 * x9
    x106 = -x105
    x107 = x19 * x87
    x108 = x106 + x107
    x109 = x108 * x5
    x110 = x104 - x109
    x111 = x110 * x5
    x112 = x0 * (x89 + x91 - x93)
    x113 = -x112
    x114 = x111 + x113
    x115 = -x111 + x112 + x97
    x116 = x0 * (x105 - x107 + x94)
    x117 = -x49 * x9
    x118 = x117 + x35 * x87
    x119 = x27 - x55 * x7
    x120 = x119 + x53 * x65
    x121 = x53 * x60
    x122 = x7 * x74
    x123 = -x122 + x33
    x124 = x121 + x123
    x125 = x124 * x5
    x126 = x53 * x55
    x127 = x60 * x7
    x128 = -x127 + x14
    x129 = x126 + x128
    x130 = -x129 * x5
    x131 = x129 * x4
    x132 = x120 * x4 + x130
    x133 = x127 + x46
    x134 = x0 * (x120 - x126 + x133)
    x135 = -x125 + x131
    x136 = x122 + x50
    x137 = x0 * (-x121 + x129 + x136)
    x138 = x48 - x7 * x84
    x139 = x138 + x53 * x74
    x140 = -x7 * x89
    x141 = x140 + x53 * x99
    x142 = x53 * x94
    x143 = x108 * x7
    x144 = -x143
    x145 = x142 + x144
    x146 = x145 * x5
    x147 = x53 * x89
    x148 = x7 * x94
    x149 = -x148
    x150 = x147 + x149
    x151 = -x150 * x5
    x152 = x150 * x4
    x153 = x141 * x4 + x151
    x154 = x0 * (x141 - x147 + x148)
    x155 = -x146 + x152
    x156 = x0 * (-x142 + x143 + x150)
    x157 = -x118 * x7
    x158 = x108 * x53 + x157
    x159 = x27 - x89 * x9
    x160 = x159 + x87 * x99
    x161 = x87 * x94
    x162 = x108 * x9
    x163 = -x162 + x33
    x164 = x161 + x163
    x165 = x164 * x5
    x166 = x87 * x89
    x167 = x9 * x94
    x168 = x14 - x167
    x169 = x166 + x168
    x170 = -x169 * x5
    x171 = x169 * x4
    x172 = x160 * x4 + x170
    x173 = x167 + x46
    x174 = x0 * (x160 - x166 + x173)
    x175 = -x165 + x171
    x176 = x162 + x50
    x177 = x0 * (-x161 + x169 + x176)
    x178 = -x118 * x9 + x48
    x179 = x108 * x87 + x178
    x180 = x129 * x53
    x181 = -x129 * x7 + 2.0 * x67
    x182 = x120 * x53 + x181
    x183 = x124 * x7
    x184 = 2.0 * x78
    x185 = x183 - x184
    x186 = x0 * (-x180 + x182 + x185)
    x187 = -x183 + x184
    x188 = x180 + x187
    x189 = -x139 * x7 + 2.0 * x82
    x190 = x124 * x53 + x189
    x191 = x150 * x53
    x192 = x101 - x150 * x7
    x193 = x141 * x53 + x192
    x194 = x145 * x7
    x195 = x113 + x194
    x196 = x0 * (-x191 + x193 + x195)
    x197 = x112 - x194
    x198 = x191 + x197
    x199 = x116 - x158 * x7
    x200 = x145 * x53 + x199
    x201 = x164 * x7
    x202 = x169 * x53
    x203 = -x169 * x7
    x204 = x160 * x53 + x203
    x205 = x0 * (x201 - x202 + x204)
    x206 = -x201
    x207 = x202 + x206
    x208 = -x179 * x7
    x209 = x164 * x53 + x208
    x210 = x169 * x87
    x211 = 2.0 * x101 - x169 * x9
    x212 = x160 * x87 + x211
    x213 = x164 * x9
    x214 = 2.0 * x112
    x215 = x213 - x214
    x216 = x0 * (-x210 + x212 + x215)
    x217 = -x213 + x214
    x218 = x210 + x217
    x219 = 2.0 * x116 - x179 * x9
    x220 = x164 * x87 + x219
    x221 = -x6 - A[1]
    x222 = x13 * x221
    x223 = x221 * x26 + x64
    x224 = x0 * (-x222 + x223 + x51)
    x225 = x222 + x52
    x226 = x223 * x4 - x225 * x5
    x227 = x225 * x4
    x228 = x12 * x221
    x229 = x228 + x58
    x230 = x229 * x5
    x231 = x227 - x230
    x232 = x224 + x226 * x4 - x231 * x5
    x233 = x0 * (x225 - x228 + x57)
    x234 = x231 * x4
    x235 = x229 * x4
    x236 = x19 * x221
    x237 = x236 + x72
    x238 = x237 * x5
    x239 = x235 - x238
    x240 = x239 * x5
    x241 = x233 + x234 - x240
    x242 = x0 * (x229 - x236 + x71)
    x243 = x221 * x35 + x83
    x244 = -x233
    x245 = x221 * x55
    x246 = x119 + x221 * x65
    x247 = x0 * (x133 - x245 + x246)
    x248 = x128 + x245
    x249 = x246 * x4 - x248 * x5
    x250 = x248 * x4
    x251 = x221 * x60
    x252 = x123 + x251
    x253 = x252 * x5
    x254 = x250 - x253
    x255 = x0 * (x136 + x248 - x251)
    x256 = x138 + x221 * x74
    x257 = x221 * x89
    x258 = x140 + x221 * x99
    x259 = x0 * (x148 - x257 + x258)
    x260 = x149 + x257
    x261 = x258 * x4 - x260 * x5
    x262 = x260 * x4
    x263 = x221 * x94
    x264 = x144 + x263
    x265 = x264 * x5
    x266 = x262 - x265
    x267 = x0 * (x143 + x260 - x263)
    x268 = x108 * x221 + x157
    x269 = x129 * x221
    x270 = x120 * x221 + x181
    x271 = x0 * (x185 - x269 + x270)
    x272 = x187 + x269
    x273 = x124 * x221 + x189
    x274 = x150 * x221
    x275 = x141 * x221 + x192
    x276 = x0 * (x195 - x274 + x275)
    x277 = x197 + x274
    x278 = x145 * x221 + x199
    x279 = x169 * x221
    x280 = x160 * x221 + x203
    x281 = x0 * (x201 - x279 + x280)
    x282 = x206 + x279
    x283 = x164 * x221 + x208
    x284 = 3.0 * x134 + x182 * x221 - x188 * x7
    x285 = 3.0 * x137 + x188 * x221 - x190 * x7
    x286 = 2.0 * x154 + x193 * x221 - x198 * x7
    x287 = 2.0 * x156 + x198 * x221 - x200 * x7
    x288 = x174 + x204 * x221 - x207 * x7
    x289 = x177 + x207 * x221 - x209 * x7
    x290 = x212 * x221 - x218 * x7
    x291 = x218 * x221 - x220 * x7
    x292 = -x8 - A[2]
    x293 = x13 * x292
    x294 = x26 * x292 + x98
    x295 = x0 * (-x293 + x294 + x85)
    x296 = x293 + x86
    x297 = x294 * x4 - x296 * x5
    x298 = x296 * x4
    x299 = x12 * x292
    x300 = x299 + x92
    x301 = x300 * x5
    x302 = x298 - x301
    x303 = x295 + x297 * x4 - x302 * x5
    x304 = x0 * (x296 - x299 + x91)
    x305 = x302 * x4
    x306 = x300 * x4
    x307 = x19 * x292
    x308 = x106 + x307
    x309 = x308 * x5
    x310 = x306 - x309
    x311 = x310 * x5
    x312 = x304 + x305 - x311
    x313 = x0 * (x105 + x300 - x307)
    x314 = x117 + x292 * x35
    x315 = -x304
    x316 = x300 * x7
    x317 = x296 * x53
    x318 = -x296 * x7
    x319 = x294 * x53 + x318
    x320 = x0 * (x316 - x317 + x319)
    x321 = -x316
    x322 = x317 + x321
    x323 = x319 * x4 - x322 * x5
    x324 = x322 * x4
    x325 = x300 * x53
    x326 = x308 * x7
    x327 = -x326
    x328 = x325 + x327
    x329 = x328 * x5
    x330 = x324 - x329
    x331 = x0 * (x322 - x325 + x326)
    x332 = -x314 * x7
    x333 = x308 * x53 + x332
    x334 = x292 * x89
    x335 = x159 + x292 * x99
    x336 = x0 * (x173 - x334 + x335)
    x337 = x168 + x334
    x338 = x335 * x4 - x337 * x5
    x339 = x337 * x4
    x340 = x292 * x94
    x341 = x163 + x340
    x342 = x341 * x5
    x343 = x339 - x342
    x344 = x0 * (x176 + x337 - x340)
    x345 = x108 * x292 + x178
    x346 = x322 * x53
    x347 = x295 - x322 * x7
    x348 = x319 * x53 + x347
    x349 = x328 * x7
    x350 = x315 + x349
    x351 = x0 * (-x346 + x348 + x350)
    x352 = x304 - x349
    x353 = x346 + x352
    x354 = x313 - x333 * x7
    x355 = x328 * x53 + x354
    x356 = x341 * x7
    x357 = x337 * x53
    x358 = -x337 * x7
    x359 = x335 * x53 + x358
    x360 = x0 * (x356 - x357 + x359)
    x361 = -x356
    x362 = x357 + x361
    x363 = -x345 * x7
    x364 = x341 * x53 + x363
    x365 = x169 * x292
    x366 = x160 * x292 + x211
    x367 = x0 * (x215 - x365 + x366)
    x368 = x217 + x365
    x369 = x164 * x292 + x219
    x370 = 2.0 * x320 - x353 * x7
    x371 = x348 * x53 + x370
    x372 = 2.0 * x331 - x355 * x7
    x373 = x353 * x53 + x372
    x374 = x336 - x362 * x7
    x375 = x359 * x53 + x374
    x376 = x344 - x364 * x7
    x377 = x362 * x53 + x376
    x378 = -x368 * x7
    x379 = x366 * x53 + x378
    x380 = -x369 * x7
    x381 = x368 * x53 + x380
    x382 = 3.0 * x174 + x212 * x292 - x218 * x9
    x383 = 3.0 * x177 + x218 * x292 - x220 * x9
    x384 = x229 * x7
    x385 = x221 * x225
    x386 = x221 * x223 - x225 * x7 + x27
    x387 = x14 - x384 + x385
    x388 = x386 * x4 - x387 * x5
    x389 = x387 * x4
    x390 = x221 * x229
    x391 = x237 * x7
    x392 = x33 + x390 - x391
    x393 = x392 * x5
    x394 = x389 - x393
    x395 = x252 * x7
    x396 = x221 * x248
    x397 = x221 * x246 + x224 - x248 * x7 + x67
    x398 = x233 - x395 + x396 + x78
    x399 = x264 * x7
    x400 = x221 * x260
    x401 = x101 + x221 * x258 - x260 * x7
    x402 = x112 - x399 + x400
    x403 = x221 * x296
    x404 = x221 * x294 + x318
    x405 = x321 + x403
    x406 = x4 * x404 - x405 * x5
    x407 = x4 * x405
    x408 = x221 * x300
    x409 = x327 + x408
    x410 = x409 * x5
    x411 = x407 - x410
    x412 = x221 * x322
    x413 = x221 * x319 + x347
    x414 = x352 + x412
    x415 = x221 * x337
    x416 = x221 * x335 + x358
    x417 = x361 + x415
    x418 = x300 * x9
    x419 = x292 * x296
    x420 = x27 + x292 * x294 - x296 * x9
    x421 = x0 * (x418 - x419 + x420 + x46)
    x422 = x14 - x418 + x419
    x423 = x4 * x420 - x422 * x5
    x424 = x4 * x422
    x425 = x292 * x300
    x426 = x308 * x9
    x427 = x33 + x425 - x426
    x428 = x427 * x5
    x429 = x424 - x428
    x430 = x0 * (x422 - x425 + x426 + x50)
    x431 = x292 * x308 - x314 * x9 + x48
    x432 = x427 * x7
    x433 = x422 * x53
    x434 = x420 * x53 - x422 * x7
    x435 = x0 * (x432 - x433 + x434)
    x436 = -x432 + x433
    x437 = x427 * x53 - x431 * x7
    x438 = x341 * x9
    x439 = x292 * x337
    x440 = x101 + x292 * x335 + x295 - x337 * x9
    x441 = x0 * (x113 + x315 + x438 - x439 + x440)
    x442 = x112 + x304 - x438 + x439
    x443 = x116 + x292 * x341 + x313 - x345 * x9
    x444 = x421 + x434 * x53 - x436 * x7
    x445 = x430 + x436 * x53 - x437 * x7
    x446 = x440 * x53 - x442 * x7
    x447 = x442 * x53 - x443 * x7
    x448 = x174 + x292 * x366 + 2.0 * x336 - x368 * x9
    x449 = x177 + x292 * x368 + 2.0 * x344 - x369 * x9

    # 60 item(s)
    return numpy.array(
        [
            x0 * (-x25 + x32 + x43)
            + x44 * (x32 * x44 - x45 * x5 + x47 * (-x18 + x23 + x29 + x46))
            + x47 * (-x24 * x44 + x29 * x44 + x31 + x43)
            - x5
            * (
                x44 * x45
                + x47 * (x24 - x34 + x39 + x50)
                - x5
                * (
                    x30 * (x22 + x36 - x37)
                    + x4 * x40
                    - x5 * (x38 * x4 + x48 - x5 * (x35 * x4 - x49 * x5))
                )
            ),
            x0 * (-x63 + x69 + x80)
            + x30 * (-x44 * x62 + x44 * x66 + x68 + x80)
            + x44 * (x30 * (-x56 + x61 + x66) + x44 * x69 - x5 * x81)
            - x5
            * (
                x30 * (x62 - x70 + x75)
                + x44 * x81
                - x5 * (x4 * x76 - x5 * (x4 * x74 - x5 * x84) + x82)
            ),
            x0 * (x103 + x114 - x97)
            + x30 * (x100 * x44 + x102 + x114 - x44 * x96)
            + x44 * (x103 * x44 - x115 * x5 + x30 * (x100 - x90 + x95))
            - x5
            * (
                x115 * x44
                + x30 * (-x104 + x109 + x96)
                - x5 * (x110 * x4 + x116 - x5 * (x108 * x4 - x118 * x5))
            ),
            x0 * (x125 - x131 + x132)
            + x0 * (x120 * x44 + x125 - x129 * x44 + x130)
            + x44 * (x132 * x44 + x134 - x135 * x5)
            - x5 * (x135 * x44 + x137 - x5 * (x124 * x4 - x139 * x5)),
            x0 * (x146 - x152 + x153)
            + x0 * (x141 * x44 + x146 - x150 * x44 + x151)
            + x44 * (x153 * x44 + x154 - x155 * x5)
            - x5 * (x155 * x44 + x156 - x5 * (x145 * x4 - x158 * x5)),
            x0 * (x165 - x171 + x172)
            + x0 * (x160 * x44 + x165 - x169 * x44 + x170)
            + x44 * (x172 * x44 + x174 - x175 * x5)
            - x5 * (x175 * x44 + x177 - x5 * (x164 * x4 - x179 * x5)),
            x186 + x44 * (x182 * x44 - x188 * x5) - x5 * (x188 * x44 - x190 * x5),
            x196 + x44 * (x193 * x44 - x198 * x5) - x5 * (x198 * x44 - x200 * x5),
            x205 + x44 * (x204 * x44 - x207 * x5) - x5 * (x207 * x44 - x209 * x5),
            x216 + x44 * (x212 * x44 - x218 * x5) - x5 * (x218 * x44 - x220 * x5),
            x44 * (x232 * x4 - x241 * x5 + x30 * (x226 - x227 + x230))
            + x47 * (x232 - x234 + x240 + x244)
            - x5
            * (
                x241 * x4
                + x30 * (x231 - x235 + x238)
                - x5 * (x239 * x4 + x242 - x5 * (x237 * x4 - x243 * x5))
            ),
            x30 * (x249 - x250 + x253)
            + x44 * (x247 + x249 * x4 - x254 * x5)
            - x5 * (x254 * x4 + x255 - x5 * (x252 * x4 - x256 * x5)),
            x30 * (x261 - x262 + x265)
            + x44 * (x259 + x261 * x4 - x266 * x5)
            - x5 * (x266 * x4 + x267 - x5 * (x264 * x4 - x268 * x5)),
            x271 + x44 * (x270 * x4 - x272 * x5) - x5 * (x272 * x4 - x273 * x5),
            x276 + x44 * (x275 * x4 - x277 * x5) - x5 * (x277 * x4 - x278 * x5),
            x281 + x44 * (x280 * x4 - x282 * x5) - x5 * (x282 * x4 - x283 * x5),
            x284 * x44 - x285 * x5,
            x286 * x44 - x287 * x5,
            x288 * x44 - x289 * x5,
            x290 * x44 - x291 * x5,
            x44 * (x30 * (x297 - x298 + x301) + x303 * x4 - x312 * x5)
            + x47 * (x303 - x305 + x311 + x315)
            - x5
            * (
                x30 * (x302 - x306 + x309)
                + x312 * x4
                - x5 * (x310 * x4 + x313 - x5 * (x308 * x4 - x314 * x5))
            ),
            x30 * (x323 - x324 + x329)
            + x44 * (x320 + x323 * x4 - x330 * x5)
            - x5 * (x330 * x4 + x331 - x5 * (x328 * x4 - x333 * x5)),
            x30 * (x338 - x339 + x342)
            + x44 * (x336 + x338 * x4 - x343 * x5)
            - x5 * (x343 * x4 + x344 - x5 * (x341 * x4 - x345 * x5)),
            x351 + x44 * (x348 * x4 - x353 * x5) - x5 * (x353 * x4 - x355 * x5),
            x360 + x44 * (x359 * x4 - x362 * x5) - x5 * (x362 * x4 - x364 * x5),
            x367 + x44 * (x366 * x4 - x368 * x5) - x5 * (x368 * x4 - x369 * x5),
            x371 * x44 - x373 * x5,
            x375 * x44 - x377 * x5,
            x379 * x44 - x381 * x5,
            x382 * x44 - x383 * x5,
            x30 * (x388 - x389 + x393)
            + x4 * (x0 * (x384 - x385 + x386 + x46) + x388 * x4 - x394 * x5)
            - x5
            * (
                x0 * (x387 - x390 + x391 + x50)
                + x394 * x4
                - x5 * (x392 * x4 - x5 * (x221 * x237 - x243 * x7 + x48))
            ),
            x0 * (x244 + x395 - x396 + x397 + x79)
            + x4 * (x397 * x4 - x398 * x5)
            - x5 * (x398 * x4 - x5 * (x221 * x252 + x242 - x256 * x7 + x82)),
            x0 * (x113 + x399 - x400 + x401)
            + x4 * (x4 * x401 - x402 * x5)
            - x5 * (x4 * x402 - x5 * (x116 + x221 * x264 - x268 * x7)),
            x4 * (x134 + x221 * x270 + 2.0 * x247 - x272 * x7)
            - x5 * (x137 + x221 * x272 + 2.0 * x255 - x273 * x7),
            x4 * (x154 + x221 * x275 + x259 - x277 * x7)
            - x5 * (x156 + x221 * x277 + x267 - x278 * x7),
            x4 * (x174 + x221 * x280 - x282 * x7) - x5 * (x177 + x221 * x282 - x283 * x7),
            x186 + x221 * x284 + 3.0 * x271 - x285 * x7,
            x196 + x221 * x286 + 2.0 * x276 - x287 * x7,
            x205 + x221 * x288 + x281 - x289 * x7,
            x216 + x221 * x290 - x291 * x7,
            x30 * (x406 - x407 + x410)
            + x4 * (x0 * (x316 - x403 + x404) + x4 * x406 - x411 * x5)
            - x5
            * (
                x0 * (x326 + x405 - x408)
                + x4 * x411
                - x5 * (x4 * x409 - x5 * (x221 * x308 + x332))
            ),
            x0 * (x350 - x412 + x413)
            + x4 * (x4 * x413 - x414 * x5)
            - x5 * (x4 * x414 - x5 * (x221 * x328 + x354)),
            x0 * (x356 - x415 + x416)
            + x4 * (x4 * x416 - x417 * x5)
            - x5 * (x4 * x417 - x5 * (x221 * x341 + x363)),
            x4 * (x221 * x348 + x370) - x5 * (x221 * x353 + x372),
            x4 * (x221 * x359 + x374) - x5 * (x221 * x362 + x376),
            x4 * (x221 * x366 + x378) - x5 * (x221 * x368 + x380),
            x221 * x371 + 3.0 * x351 - x373 * x7,
            x221 * x375 + 2.0 * x360 - x377 * x7,
            x221 * x379 + x367 - x381 * x7,
            x221 * x382 - x383 * x7,
            x30 * (x423 - x424 + x428)
            + x4 * (x4 * x423 + x421 - x429 * x5)
            - x5 * (x4 * x429 + x430 - x5 * (x4 * x427 - x431 * x5)),
            x4 * (x4 * x434 - x436 * x5) + x435 - x5 * (x4 * x436 - x437 * x5),
            x4 * (x4 * x440 - x442 * x5) + x441 - x5 * (x4 * x442 - x443 * x5),
            x4 * x444 - x445 * x5,
            x4 * x446 - x447 * x5,
            x4 * x448 - x449 * x5,
            2.0 * x435 + x444 * x53 - x445 * x7,
            x441 + x446 * x53 - x447 * x7,
            x448 * x53 - x449 * x7,
            x216 + x292 * x382 + 3.0 * x367 - x383 * x9,
        ]
    )


def coulomb3d_24(a, A, b, B, C):
    """Cartesian (dg) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - B[0]
    x5 = -x3 - C[0]
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x2 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x1 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x2
        * numpy.exp(
            -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(2, x10)
    x13 = x11 * boys(1, x10)
    x14 = x0 * (-x12 + x13)
    x15 = x12 * x5
    x16 = x13 * x4
    x17 = -x15 + x16
    x18 = x17 * x4
    x19 = x11 * boys(3, x10)
    x20 = x19 * x5
    x21 = x12 * x4
    x22 = -x20 + x21
    x23 = x22 * x5
    x24 = x14 + x18 - x23
    x25 = x24 * x4
    x26 = x0 * (x12 - x19)
    x27 = x22 * x4
    x28 = x11 * boys(4, x10)
    x29 = x28 * x5
    x30 = x19 * x4
    x31 = -x29 + x30
    x32 = x31 * x5
    x33 = x26 + x27 - x32
    x34 = x33 * x5
    x35 = 2.0 * x0
    x36 = x35 * (x17 + x20 - x21)
    x37 = x25 - x34 + x36
    x38 = x37 * x4
    x39 = x11 * boys(0, x10)
    x40 = x0 * (-x13 + x39)
    x41 = -x13 * x5 + x39 * x4
    x42 = -x17 * x5 + x4 * x41 + x40
    x43 = -x24 * x5 + x35 * (x15 - x16 + x41) + x4 * x42
    x44 = -x14
    x45 = 3.0 * x0
    x46 = -x37 * x5 + x45 * (-x18 + x23 + x42 + x44)
    x47 = x4 * x43 + x46
    x48 = x33 * x4
    x49 = x0 * (x19 - x28)
    x50 = x31 * x4
    x51 = x11 * boys(5, x10)
    x52 = x5 * x51
    x53 = x28 * x4
    x54 = -x52 + x53
    x55 = x5 * x54
    x56 = x49 + x50 - x55
    x57 = x5 * x56
    x58 = x35 * (x22 + x29 - x30)
    x59 = x48 - x57 + x58
    x60 = x5 * x59
    x61 = -x26
    x62 = x45 * (x24 - x27 + x32 + x61)
    x63 = x60 - x62
    x64 = -x3 - A[0]
    x65 = x38 - x60 + x62
    x66 = 4.0 * x0
    x67 = x0 * (x28 - x51)
    x68 = x11 * boys(6, x10)
    x69 = -x49
    x70 = -x6 - B[1]
    x71 = x12 * x70
    x72 = x19 * x7
    x73 = x12 * x7
    x74 = -x73
    x75 = x13 * x70
    x76 = x74 + x75
    x77 = x0 * (-x71 + x72 + x76)
    x78 = x4 * x76
    x79 = -x72
    x80 = x71 + x79
    x81 = x5 * x80
    x82 = x78 - x81
    x83 = x4 * x82
    x84 = x4 * x80
    x85 = x28 * x7
    x86 = -x85
    x87 = x19 * x70
    x88 = x86 + x87
    x89 = x5 * x88
    x90 = x84 - x89
    x91 = x5 * x90
    x92 = x77 + x83 - x91
    x93 = x4 * x92
    x94 = -x13 * x7
    x95 = x39 * x70 + x94
    x96 = x0 * (x73 - x75 + x95)
    x97 = x4 * x95 - x5 * x76
    x98 = x4 * x97 - x5 * x82 + x96
    x99 = x35 * (-x78 + x81 + x97) - x5 * x92
    x100 = x4 * x98 + x99
    x101 = x0 * (x80 + x85 - x87)
    x102 = x4 * x90
    x103 = x4 * x88
    x104 = x51 * x7
    x105 = -x104
    x106 = x28 * x70
    x107 = x105 + x106
    x108 = x107 * x5
    x109 = x103 - x108
    x110 = x109 * x5
    x111 = x101 + x102 - x110
    x112 = x111 * x5
    x113 = x35 * (x82 - x84 + x89)
    x114 = x112 - x113
    x115 = -x112 + x113 + x93
    x116 = -x77
    x117 = x0 * (x104 - x106 + x88)
    x118 = -x68 * x7
    x119 = x118 + x51 * x70
    x120 = -x101
    x121 = -x8 - B[2]
    x122 = x12 * x121
    x123 = x19 * x9
    x124 = x12 * x9
    x125 = -x124
    x126 = x121 * x13
    x127 = x125 + x126
    x128 = x0 * (-x122 + x123 + x127)
    x129 = x127 * x4
    x130 = -x123
    x131 = x122 + x130
    x132 = x131 * x5
    x133 = x129 - x132
    x134 = x133 * x4
    x135 = x131 * x4
    x136 = x28 * x9
    x137 = -x136
    x138 = x121 * x19
    x139 = x137 + x138
    x140 = x139 * x5
    x141 = x135 - x140
    x142 = x141 * x5
    x143 = x128 + x134 - x142
    x144 = x143 * x4
    x145 = -x13 * x9
    x146 = x121 * x39 + x145
    x147 = x0 * (x124 - x126 + x146)
    x148 = -x127 * x5 + x146 * x4
    x149 = -x133 * x5 + x147 + x148 * x4
    x150 = -x143 * x5 + x35 * (-x129 + x132 + x148)
    x151 = x149 * x4 + x150
    x152 = x0 * (x131 + x136 - x138)
    x153 = x141 * x4
    x154 = x139 * x4
    x155 = x51 * x9
    x156 = -x155
    x157 = x121 * x28
    x158 = x156 + x157
    x159 = x158 * x5
    x160 = x154 - x159
    x161 = x160 * x5
    x162 = x152 + x153 - x161
    x163 = x162 * x5
    x164 = x35 * (x133 - x135 + x140)
    x165 = x163 - x164
    x166 = x144 - x163 + x164
    x167 = -x128
    x168 = x0 * (x139 + x155 - x157)
    x169 = -x68 * x9
    x170 = x121 * x51 + x169
    x171 = -x152
    x172 = x70 * x76
    x173 = x7 * x80
    x174 = x14 - x173
    x175 = x172 + x174
    x176 = x175 * x4
    x177 = x70 * x80
    x178 = x7 * x88
    x179 = -x178 + x26
    x180 = x177 + x179
    x181 = x180 * x5
    x182 = x176 - x181
    x183 = x182 * x4
    x184 = x40 - x7 * x76
    x185 = x184 + x70 * x95
    x186 = -x175 * x5 + x185 * x4
    x187 = x173 + x44
    x188 = x0 * (-x172 + x185 + x187)
    x189 = -x182 * x5 + x188
    x190 = x186 * x4 + x189
    x191 = x180 * x4
    x192 = x70 * x88
    x193 = x107 * x7
    x194 = -x193 + x49
    x195 = x192 + x194
    x196 = x195 * x5
    x197 = x191 - x196
    x198 = x197 * x5
    x199 = x178 + x61
    x200 = x0 * (x175 - x177 + x199)
    x201 = -x200
    x202 = x198 + x201
    x203 = x183 - x198 + x200
    x204 = x193 + x69
    x205 = x0 * (x180 - x192 + x204)
    x206 = -x119 * x7 + x67
    x207 = x107 * x70 + x206
    x208 = x127 * x70
    x209 = x131 * x7
    x210 = -x209
    x211 = x208 + x210
    x212 = x211 * x4
    x213 = x131 * x70
    x214 = x139 * x7
    x215 = -x214
    x216 = x213 + x215
    x217 = x216 * x5
    x218 = x212 - x217
    x219 = x218 * x4
    x220 = -x127 * x7
    x221 = x146 * x70 + x220
    x222 = -x211 * x5 + x221 * x4
    x223 = x0 * (-x208 + x209 + x221)
    x224 = -x218 * x5 + x223
    x225 = x222 * x4 + x224
    x226 = x216 * x4
    x227 = x139 * x70
    x228 = x158 * x7
    x229 = -x228
    x230 = x227 + x229
    x231 = x230 * x5
    x232 = x226 - x231
    x233 = x232 * x5
    x234 = x0 * (x211 - x213 + x214)
    x235 = -x234
    x236 = x233 + x235
    x237 = x219 - x233 + x234
    x238 = x0 * (x216 - x227 + x228)
    x239 = -x170 * x7
    x240 = x158 * x70 + x239
    x241 = x121 * x127
    x242 = x131 * x9
    x243 = x14 - x242
    x244 = x241 + x243
    x245 = x244 * x4
    x246 = x121 * x131
    x247 = x139 * x9
    x248 = -x247 + x26
    x249 = x246 + x248
    x250 = x249 * x5
    x251 = x245 - x250
    x252 = x251 * x4
    x253 = -x127 * x9 + x40
    x254 = x121 * x146 + x253
    x255 = -x244 * x5 + x254 * x4
    x256 = x242 + x44
    x257 = x0 * (-x241 + x254 + x256)
    x258 = -x251 * x5 + x257
    x259 = x255 * x4 + x258
    x260 = x249 * x4
    x261 = x121 * x139
    x262 = x158 * x9
    x263 = -x262 + x49
    x264 = x261 + x263
    x265 = x264 * x5
    x266 = x260 - x265
    x267 = x266 * x5
    x268 = x247 + x61
    x269 = x0 * (x244 - x246 + x268)
    x270 = -x269
    x271 = x267 + x270
    x272 = x252 - x267 + x269
    x273 = x262 + x69
    x274 = x0 * (x249 - x261 + x273)
    x275 = -x170 * x9 + x67
    x276 = x121 * x158 + x275
    x277 = -x175 * x7 + 2.0 * x96
    x278 = x185 * x70 + x277
    x279 = x180 * x70
    x280 = x195 * x7
    x281 = 2.0 * x101
    x282 = -x280 + x281
    x283 = x279 + x282
    x284 = x283 * x5
    x285 = x175 * x70
    x286 = x180 * x7
    x287 = 2.0 * x77
    x288 = -x286 + x287
    x289 = x285 + x288
    x290 = -x289 * x5
    x291 = x289 * x4
    x292 = x278 * x4 + x290
    x293 = x286 - x287
    x294 = x0 * (x278 - x285 + x293)
    x295 = -x284 + x291
    x296 = x280 - x281
    x297 = x0 * (-x279 + x289 + x296)
    x298 = 2.0 * x117 - x207 * x7
    x299 = x195 * x70 + x298
    x300 = x147 - x211 * x7
    x301 = x221 * x70 + x300
    x302 = x216 * x70
    x303 = x230 * x7
    x304 = x152 - x303
    x305 = x302 + x304
    x306 = x305 * x5
    x307 = x211 * x70
    x308 = x216 * x7
    x309 = x128 - x308
    x310 = x307 + x309
    x311 = -x310 * x5
    x312 = x310 * x4
    x313 = x301 * x4 + x311
    x314 = x167 + x308
    x315 = x0 * (x301 - x307 + x314)
    x316 = -x306 + x312
    x317 = x171 + x303
    x318 = x0 * (-x302 + x310 + x317)
    x319 = x168 - x240 * x7
    x320 = x230 * x70 + x319
    x321 = -x244 * x7
    x322 = x254 * x70 + x321
    x323 = x249 * x70
    x324 = x264 * x7
    x325 = -x324
    x326 = x323 + x325
    x327 = x326 * x5
    x328 = x244 * x70
    x329 = x249 * x7
    x330 = -x329
    x331 = x328 + x330
    x332 = -x331 * x5
    x333 = x331 * x4
    x334 = x322 * x4 + x332
    x335 = x0 * (x322 - x328 + x329)
    x336 = -x327 + x333
    x337 = x0 * (-x323 + x324 + x331)
    x338 = -x276 * x7
    x339 = x264 * x70 + x338
    x340 = 2.0 * x147 - x244 * x9
    x341 = x121 * x254 + x340
    x342 = x121 * x249
    x343 = x264 * x9
    x344 = 2.0 * x152
    x345 = -x343 + x344
    x346 = x342 + x345
    x347 = x346 * x5
    x348 = x121 * x244
    x349 = x249 * x9
    x350 = 2.0 * x128
    x351 = -x349 + x350
    x352 = x348 + x351
    x353 = -x352 * x5
    x354 = x352 * x4
    x355 = x341 * x4 + x353
    x356 = x349 - x350
    x357 = x0 * (x341 - x348 + x356)
    x358 = -x347 + x354
    x359 = x343 - x344
    x360 = x0 * (-x342 + x352 + x359)
    x361 = 2.0 * x168 - x276 * x9
    x362 = x121 * x264 + x361
    x363 = x289 * x70
    x364 = 3.0 * x188 - x289 * x7
    x365 = x278 * x70 + x364
    x366 = x283 * x7
    x367 = 3.0 * x200
    x368 = x366 - x367
    x369 = x0 * (-x363 + x365 + x368)
    x370 = -x366 + x367
    x371 = x363 + x370
    x372 = 3.0 * x205 - x299 * x7
    x373 = x283 * x70 + x372
    x374 = x310 * x70
    x375 = 2.0 * x223 - x310 * x7
    x376 = x301 * x70 + x375
    x377 = x305 * x7
    x378 = 2.0 * x234
    x379 = x377 - x378
    x380 = x0 * (-x374 + x376 + x379)
    x381 = -x377 + x378
    x382 = x374 + x381
    x383 = 2.0 * x238 - x320 * x7
    x384 = x305 * x70 + x383
    x385 = x331 * x70
    x386 = x257 - x331 * x7
    x387 = x322 * x70 + x386
    x388 = x326 * x7
    x389 = x270 + x388
    x390 = x0 * (-x385 + x387 + x389)
    x391 = x269 - x388
    x392 = x385 + x391
    x393 = x274 - x339 * x7
    x394 = x326 * x70 + x393
    x395 = x346 * x7
    x396 = x352 * x70
    x397 = -x352 * x7
    x398 = x341 * x70 + x397
    x399 = x0 * (x395 - x396 + x398)
    x400 = -x395
    x401 = x396 + x400
    x402 = -x362 * x7
    x403 = x346 * x70 + x402
    x404 = x121 * x352
    x405 = 3.0 * x257 - x352 * x9
    x406 = x121 * x341 + x405
    x407 = x346 * x9
    x408 = 3.0 * x269
    x409 = x407 - x408
    x410 = x0 * (-x404 + x406 + x409)
    x411 = -x407 + x408
    x412 = x404 + x411
    x413 = 3.0 * x274 - x362 * x9
    x414 = x121 * x346 + x413
    x415 = -x6 - A[1]
    x416 = x13 * x415
    x417 = x39 * x415 + x94
    x418 = x0 * (-x416 + x417 + x73)
    x419 = x416 + x74
    x420 = x4 * x417 - x419 * x5
    x421 = x4 * x419
    x422 = x12 * x415
    x423 = x422 + x79
    x424 = x423 * x5
    x425 = x421 - x424
    x426 = x4 * x420 + x418 - x425 * x5
    x427 = x0 * (x419 - x422 + x72)
    x428 = x4 * x425
    x429 = x4 * x423
    x430 = x19 * x415
    x431 = x430 + x86
    x432 = x431 * x5
    x433 = x429 - x432
    x434 = x433 * x5
    x435 = x427 + x428 - x434
    x436 = x35 * (x420 - x421 + x424) + x4 * x426 - x435 * x5
    x437 = x4 * x435
    x438 = x0 * (x423 - x430 + x85)
    x439 = x4 * x433
    x440 = x4 * x431
    x441 = x28 * x415
    x442 = x105 + x441
    x443 = x442 * x5
    x444 = x440 - x443
    x445 = x444 * x5
    x446 = x438 + x439 - x445
    x447 = x446 * x5
    x448 = x35 * (x425 - x429 + x432)
    x449 = x437 - x447 + x448
    x450 = -x427
    x451 = x0 * (x104 + x431 - x441)
    x452 = x118 + x415 * x51
    x453 = -x438
    x454 = x415 * x76
    x455 = x184 + x415 * x95
    x456 = x0 * (x187 - x454 + x455)
    x457 = x174 + x454
    x458 = x4 * x455 - x457 * x5
    x459 = x4 * x457
    x460 = x415 * x80
    x461 = x179 + x460
    x462 = x461 * x5
    x463 = x459 - x462
    x464 = x4 * x458 + x456 - x463 * x5
    x465 = x0 * (x199 + x457 - x460)
    x466 = x4 * x463
    x467 = x4 * x461
    x468 = x415 * x88
    x469 = x194 + x468
    x470 = x469 * x5
    x471 = x467 - x470
    x472 = x471 * x5
    x473 = x465 + x466 - x472
    x474 = x0 * (x204 + x461 - x468)
    x475 = x107 * x415 + x206
    x476 = x127 * x415
    x477 = x146 * x415 + x220
    x478 = x0 * (x209 - x476 + x477)
    x479 = x210 + x476
    x480 = x4 * x477 - x479 * x5
    x481 = x4 * x479
    x482 = x131 * x415
    x483 = x215 + x482
    x484 = x483 * x5
    x485 = x481 - x484
    x486 = x4 * x480 + x478 - x485 * x5
    x487 = x0 * (x214 + x479 - x482)
    x488 = x4 * x485
    x489 = x4 * x483
    x490 = x139 * x415
    x491 = x229 + x490
    x492 = x491 * x5
    x493 = x489 - x492
    x494 = x493 * x5
    x495 = x487 + x488 - x494
    x496 = x0 * (x228 + x483 - x490)
    x497 = x158 * x415 + x239
    x498 = -x487
    x499 = x175 * x415
    x500 = x185 * x415 + x277
    x501 = x0 * (x293 - x499 + x500)
    x502 = x288 + x499
    x503 = x4 * x500 - x5 * x502
    x504 = x4 * x502
    x505 = x180 * x415
    x506 = x282 + x505
    x507 = x5 * x506
    x508 = x504 - x507
    x509 = x0 * (x296 + x502 - x505)
    x510 = x195 * x415 + x298
    x511 = x211 * x415
    x512 = x221 * x415 + x300
    x513 = x0 * (x314 - x511 + x512)
    x514 = x309 + x511
    x515 = x4 * x512 - x5 * x514
    x516 = x4 * x514
    x517 = x216 * x415
    x518 = x304 + x517
    x519 = x5 * x518
    x520 = x516 - x519
    x521 = x0 * (x317 + x514 - x517)
    x522 = x230 * x415 + x319
    x523 = x244 * x415
    x524 = x254 * x415 + x321
    x525 = x0 * (x329 - x523 + x524)
    x526 = x330 + x523
    x527 = x4 * x524 - x5 * x526
    x528 = x4 * x526
    x529 = x249 * x415
    x530 = x325 + x529
    x531 = x5 * x530
    x532 = x528 - x531
    x533 = x0 * (x324 + x526 - x529)
    x534 = x264 * x415 + x338
    x535 = x289 * x415
    x536 = x278 * x415 + x364
    x537 = x0 * (x368 - x535 + x536)
    x538 = x370 + x535
    x539 = x283 * x415 + x372
    x540 = x310 * x415
    x541 = x301 * x415 + x375
    x542 = x0 * (x379 - x540 + x541)
    x543 = x381 + x540
    x544 = x305 * x415 + x383
    x545 = x331 * x415
    x546 = x322 * x415 + x386
    x547 = x0 * (x389 - x545 + x546)
    x548 = x391 + x545
    x549 = x326 * x415 + x393
    x550 = x352 * x415
    x551 = x341 * x415 + x397
    x552 = x0 * (x395 - x550 + x551)
    x553 = x400 + x550
    x554 = x346 * x415 + x402
    x555 = 4.0 * x294 + x365 * x415 - x371 * x7
    x556 = 4.0 * x297 + x371 * x415 - x373 * x7
    x557 = 3.0 * x315 + x376 * x415 - x382 * x7
    x558 = 3.0 * x318 + x382 * x415 - x384 * x7
    x559 = 2.0 * x335 + x387 * x415 - x392 * x7
    x560 = 2.0 * x337 + x392 * x415 - x394 * x7
    x561 = x357 + x398 * x415 - x401 * x7
    x562 = x360 + x401 * x415 - x403 * x7
    x563 = x406 * x415 - x412 * x7
    x564 = x412 * x415 - x414 * x7
    x565 = -x8 - A[2]
    x566 = x13 * x565
    x567 = x145 + x39 * x565
    x568 = x0 * (x124 - x566 + x567)
    x569 = x125 + x566
    x570 = x4 * x567 - x5 * x569
    x571 = x4 * x569
    x572 = x12 * x565
    x573 = x130 + x572
    x574 = x5 * x573
    x575 = x571 - x574
    x576 = x4 * x570 - x5 * x575 + x568
    x577 = x0 * (x123 + x569 - x572)
    x578 = x4 * x575
    x579 = x4 * x573
    x580 = x19 * x565
    x581 = x137 + x580
    x582 = x5 * x581
    x583 = x579 - x582
    x584 = x5 * x583
    x585 = x577 + x578 - x584
    x586 = x35 * (x570 - x571 + x574) + x4 * x576 - x5 * x585
    x587 = x4 * x585
    x588 = x0 * (x136 + x573 - x580)
    x589 = x4 * x583
    x590 = x4 * x581
    x591 = x28 * x565
    x592 = x156 + x591
    x593 = x5 * x592
    x594 = x590 - x593
    x595 = x5 * x594
    x596 = x588 + x589 - x595
    x597 = x5 * x596
    x598 = x35 * (x575 - x579 + x582)
    x599 = x587 - x597 + x598
    x600 = -x577
    x601 = x0 * (x155 + x581 - x591)
    x602 = x169 + x51 * x565
    x603 = -x588
    x604 = x573 * x7
    x605 = x569 * x70
    x606 = -x569 * x7
    x607 = x567 * x70 + x606
    x608 = x0 * (x604 - x605 + x607)
    x609 = -x604
    x610 = x605 + x609
    x611 = x4 * x607 - x5 * x610
    x612 = x4 * x610
    x613 = x573 * x70
    x614 = x581 * x7
    x615 = -x614
    x616 = x613 + x615
    x617 = x5 * x616
    x618 = x612 - x617
    x619 = x4 * x611 - x5 * x618 + x608
    x620 = x0 * (x610 - x613 + x614)
    x621 = x4 * x618
    x622 = x4 * x616
    x623 = x581 * x70
    x624 = x592 * x7
    x625 = -x624
    x626 = x623 + x625
    x627 = x5 * x626
    x628 = x622 - x627
    x629 = x5 * x628
    x630 = x620 + x621 - x629
    x631 = x0 * (x616 - x623 + x624)
    x632 = -x602 * x7
    x633 = x592 * x70 + x632
    x634 = x127 * x565
    x635 = x146 * x565 + x253
    x636 = x0 * (x256 - x634 + x635)
    x637 = x243 + x634
    x638 = x4 * x635 - x5 * x637
    x639 = x4 * x637
    x640 = x131 * x565
    x641 = x248 + x640
    x642 = x5 * x641
    x643 = x639 - x642
    x644 = x4 * x638 - x5 * x643 + x636
    x645 = x0 * (x268 + x637 - x640)
    x646 = x4 * x643
    x647 = x4 * x641
    x648 = x139 * x565
    x649 = x263 + x648
    x650 = x5 * x649
    x651 = x647 - x650
    x652 = x5 * x651
    x653 = x645 + x646 - x652
    x654 = x0 * (x273 + x641 - x648)
    x655 = x158 * x565 + x275
    x656 = -x645
    x657 = x610 * x70
    x658 = x568 - x610 * x7
    x659 = x607 * x70 + x658
    x660 = x616 * x7
    x661 = x600 + x660
    x662 = x0 * (-x657 + x659 + x661)
    x663 = x577 - x660
    x664 = x657 + x663
    x665 = x4 * x659 - x5 * x664
    x666 = x4 * x664
    x667 = x616 * x70
    x668 = x626 * x7
    x669 = x588 - x668
    x670 = x667 + x669
    x671 = x5 * x670
    x672 = x666 - x671
    x673 = x603 + x668
    x674 = x0 * (x664 - x667 + x673)
    x675 = x601 - x633 * x7
    x676 = x626 * x70 + x675
    x677 = x641 * x7
    x678 = x637 * x70
    x679 = -x637 * x7
    x680 = x635 * x70 + x679
    x681 = x0 * (x677 - x678 + x680)
    x682 = -x677
    x683 = x678 + x682
    x684 = x4 * x680 - x5 * x683
    x685 = x4 * x683
    x686 = x641 * x70
    x687 = x649 * x7
    x688 = -x687
    x689 = x686 + x688
    x690 = x5 * x689
    x691 = x685 - x690
    x692 = x0 * (x683 - x686 + x687)
    x693 = -x655 * x7
    x694 = x649 * x70 + x693
    x695 = x244 * x565
    x696 = x254 * x565 + x340
    x697 = x0 * (x356 - x695 + x696)
    x698 = x351 + x695
    x699 = x4 * x696 - x5 * x698
    x700 = x4 * x698
    x701 = x249 * x565
    x702 = x345 + x701
    x703 = x5 * x702
    x704 = x700 - x703
    x705 = x0 * (x359 + x698 - x701)
    x706 = x264 * x565 + x361
    x707 = x664 * x70
    x708 = 2.0 * x608 - x664 * x7
    x709 = x659 * x70 + x708
    x710 = x670 * x7
    x711 = 2.0 * x620
    x712 = x710 - x711
    x713 = x0 * (-x707 + x709 + x712)
    x714 = -x710 + x711
    x715 = x707 + x714
    x716 = 2.0 * x631 - x676 * x7
    x717 = x670 * x70 + x716
    x718 = x683 * x70
    x719 = x636 - x683 * x7
    x720 = x680 * x70 + x719
    x721 = x689 * x7
    x722 = x656 + x721
    x723 = x0 * (-x718 + x720 + x722)
    x724 = x645 - x721
    x725 = x718 + x724
    x726 = x654 - x694 * x7
    x727 = x689 * x70 + x726
    x728 = x7 * x702
    x729 = x698 * x70
    x730 = -x698 * x7
    x731 = x696 * x70 + x730
    x732 = x0 * (x728 - x729 + x731)
    x733 = -x728
    x734 = x729 + x733
    x735 = -x7 * x706
    x736 = x70 * x702 + x735
    x737 = x352 * x565
    x738 = x341 * x565 + x405
    x739 = x0 * (x409 - x737 + x738)
    x740 = x411 + x737
    x741 = x346 * x565 + x413
    x742 = 3.0 * x662 - x7 * x715
    x743 = x70 * x709 + x742
    x744 = 3.0 * x674 - x7 * x717
    x745 = x70 * x715 + x744
    x746 = 2.0 * x681 - x7 * x725
    x747 = x70 * x720 + x746
    x748 = 2.0 * x692 - x7 * x727
    x749 = x70 * x725 + x748
    x750 = x697 - x7 * x734
    x751 = x70 * x731 + x750
    x752 = -x7 * x736 + x705
    x753 = x70 * x734 + x752
    x754 = -x7 * x740
    x755 = x70 * x738 + x754
    x756 = -x7 * x741
    x757 = x70 * x740 + x756
    x758 = 4.0 * x357 + x406 * x565 - x412 * x9
    x759 = 4.0 * x360 + x412 * x565 - x414 * x9
    x760 = x423 * x7
    x761 = x415 * x419
    x762 = x40 + x415 * x417 - x419 * x7
    x763 = x14 - x760 + x761
    x764 = x4 * x762 - x5 * x763
    x765 = x4 * x763
    x766 = x415 * x423
    x767 = x431 * x7
    x768 = x26 + x766 - x767
    x769 = x5 * x768
    x770 = x765 - x769
    x771 = x0 * (x44 + x760 - x761 + x762) + x4 * x764 - x5 * x770
    x772 = x0 * (x61 + x763 - x766 + x767)
    x773 = x4 * x770
    x774 = x4 * x768
    x775 = x415 * x431
    x776 = x442 * x7
    x777 = x49 + x775 - x776
    x778 = x5 * x777
    x779 = x774 - x778
    x780 = x5 * x779
    x781 = x772 + x773 - x780
    x782 = x461 * x7
    x783 = x415 * x457
    x784 = x415 * x455 + x418 - x457 * x7 + x96
    x785 = x427 + x77 - x782 + x783
    x786 = x4 * x784 - x5 * x785
    x787 = x4 * x785
    x788 = x415 * x461
    x789 = x469 * x7
    x790 = x101 + x438 + x788 - x789
    x791 = x5 * x790
    x792 = x787 - x791
    x793 = x483 * x7
    x794 = x415 * x479
    x795 = x147 + x415 * x477 - x479 * x7
    x796 = x128 - x793 + x794
    x797 = x4 * x795 - x5 * x796
    x798 = x4 * x796
    x799 = x415 * x483
    x800 = x491 * x7
    x801 = x152 + x799 - x800
    x802 = x5 * x801
    x803 = x798 - x802
    x804 = x506 * x7
    x805 = x415 * x502
    x806 = 2.0 * x465
    x807 = x188 + x415 * x500 + 2.0 * x456 - x502 * x7
    x808 = x200 - x804 + x805 + x806
    x809 = x518 * x7
    x810 = x415 * x514
    x811 = x223 + x415 * x512 + x478 - x514 * x7
    x812 = x234 + x487 - x809 + x810
    x813 = x530 * x7
    x814 = x415 * x526
    x815 = x257 + x415 * x524 - x526 * x7
    x816 = x269 - x813 + x814
    x817 = x415 * x569
    x818 = x415 * x567 + x606
    x819 = x609 + x817
    x820 = x4 * x818 - x5 * x819
    x821 = x4 * x819
    x822 = x415 * x573
    x823 = x615 + x822
    x824 = x5 * x823
    x825 = x821 - x824
    x826 = x0 * (x604 - x817 + x818) + x4 * x820 - x5 * x825
    x827 = x0 * (x614 + x819 - x822)
    x828 = x4 * x825
    x829 = x4 * x823
    x830 = x415 * x581
    x831 = x625 + x830
    x832 = x5 * x831
    x833 = x829 - x832
    x834 = x5 * x833
    x835 = x827 + x828 - x834
    x836 = x415 * x610
    x837 = x415 * x607 + x658
    x838 = x663 + x836
    x839 = x4 * x837 - x5 * x838
    x840 = x4 * x838
    x841 = x415 * x616
    x842 = x669 + x841
    x843 = x5 * x842
    x844 = x840 - x843
    x845 = x415 * x637
    x846 = x415 * x635 + x679
    x847 = x682 + x845
    x848 = x4 * x846 - x5 * x847
    x849 = x4 * x847
    x850 = x415 * x641
    x851 = x688 + x850
    x852 = x5 * x851
    x853 = x849 - x852
    x854 = x415 * x664
    x855 = x415 * x659 + x708
    x856 = x714 + x854
    x857 = x415 * x683
    x858 = x415 * x680 + x719
    x859 = x724 + x857
    x860 = x415 * x698
    x861 = x415 * x696 + x730
    x862 = x733 + x860
    x863 = x573 * x9
    x864 = x565 * x569
    x865 = x40 + x565 * x567 - x569 * x9
    x866 = x0 * (x44 + x863 - x864 + x865)
    x867 = x14 - x863 + x864
    x868 = x4 * x865 - x5 * x867
    x869 = x4 * x867
    x870 = x565 * x573
    x871 = x581 * x9
    x872 = x26 + x870 - x871
    x873 = x5 * x872
    x874 = x869 - x873
    x875 = x4 * x868 - x5 * x874 + x866
    x876 = x0 * (x61 + x867 - x870 + x871)
    x877 = x4 * x874
    x878 = x4 * x872
    x879 = x565 * x581
    x880 = x592 * x9
    x881 = x49 + x879 - x880
    x882 = x5 * x881
    x883 = x878 - x882
    x884 = x5 * x883
    x885 = x876 + x877 - x884
    x886 = x0 * (x69 + x872 - x879 + x880)
    x887 = x565 * x592 - x602 * x9 + x67
    x888 = -x876
    x889 = x7 * x872
    x890 = x70 * x867
    x891 = -x7 * x867 + x70 * x865
    x892 = x0 * (x889 - x890 + x891)
    x893 = -x889 + x890
    x894 = x4 * x891 - x5 * x893
    x895 = x4 * x893
    x896 = x70 * x872
    x897 = x7 * x881
    x898 = x896 - x897
    x899 = x5 * x898
    x900 = x895 - x899
    x901 = x0 * (x893 - x896 + x897)
    x902 = -x7 * x887 + x70 * x881
    x903 = x641 * x9
    x904 = x565 * x637
    x905 = x147 + x565 * x635 + x568 - x637 * x9
    x906 = x0 * (x167 + x600 + x903 - x904 + x905)
    x907 = x128 + x577 - x903 + x904
    x908 = x4 * x905 - x5 * x907
    x909 = x4 * x907
    x910 = x565 * x641
    x911 = x649 * x9
    x912 = x152 + x588 + x910 - x911
    x913 = x5 * x912
    x914 = x909 - x913
    x915 = x0 * (x171 + x603 + x907 - x910 + x911)
    x916 = x168 + x565 * x649 + x601 - x655 * x9
    x917 = x7 * x898
    x918 = x70 * x893
    x919 = -x7 * x893 + x70 * x891 + x866
    x920 = x0 * (x888 + x917 - x918 + x919)
    x921 = x876 - x917 + x918
    x922 = -x7 * x902 + x70 * x898 + x886
    x923 = x7 * x912
    x924 = x70 * x907
    x925 = -x7 * x907 + x70 * x905
    x926 = x0 * (x923 - x924 + x925)
    x927 = -x923 + x924
    x928 = -x7 * x916 + x70 * x912
    x929 = x702 * x9
    x930 = x565 * x698
    x931 = 2.0 * x645
    x932 = x257 + x565 * x696 + 2.0 * x636 - x698 * x9
    x933 = x0 * (x270 + x929 - x930 - x931 + x932)
    x934 = x269 - x929 + x930 + x931
    x935 = x274 + x565 * x702 + 2.0 * x654 - x706 * x9
    x936 = -x7 * x921 + x70 * x919 + 2.0 * x892
    x937 = -x7 * x922 + x70 * x921 + 2.0 * x901
    x938 = -x7 * x927 + x70 * x925 + x906
    x939 = -x7 * x928 + x70 * x927 + x915
    x940 = -x7 * x934 + x70 * x932
    x941 = -x7 * x935 + x70 * x934
    x942 = x357 + x565 * x738 + 3.0 * x697 - x740 * x9
    x943 = x360 + x565 * x740 + 3.0 * x705 - x741 * x9

    # 90 item(s)
    return numpy.array(
        [
            x0 * (-x38 + x47 + x63)
            - x5
            * (
                -x5
                * (
                    x4 * x59
                    + x45 * (x33 - x50 + x55 + x69)
                    - x5
                    * (
                        x35 * (x31 + x52 - x53)
                        + x4 * x56
                        - x5 * (x4 * x54 - x5 * (x4 * x51 - x5 * x68) + x67)
                    )
                )
                + x64 * x65
                + x66 * (x37 - x48 + x57 - x58)
            )
            + x64 * (x47 * x64 - x5 * x65 + x66 * (-x25 + x34 - x36 + x43))
            + x66 * (-x37 * x64 + x43 * x64 + x46 + x63),
            x0 * (x100 + x114 - x93)
            + x45 * (x114 - x64 * x92 + x64 * x98 + x99)
            - x5
            * (
                x115 * x64
                + x45 * (-x102 + x110 + x120 + x92)
                - x5
                * (
                    x111 * x4
                    + x35 * (-x103 + x108 + x90)
                    - x5 * (x109 * x4 + x117 - x5 * (x107 * x4 - x119 * x5))
                )
            )
            + x64 * (x100 * x64 - x115 * x5 + x45 * (x116 - x83 + x91 + x98)),
            x0 * (-x144 + x151 + x165)
            + x45 * (-x143 * x64 + x149 * x64 + x150 + x165)
            - x5
            * (
                x166 * x64
                + x45 * (x143 - x153 + x161 + x171)
                - x5
                * (
                    x162 * x4
                    + x35 * (x141 - x154 + x159)
                    - x5 * (x160 * x4 + x168 - x5 * (x158 * x4 - x170 * x5))
                )
            )
            + x64 * (x151 * x64 - x166 * x5 + x45 * (-x134 + x142 + x149 + x167)),
            x0 * (-x183 + x190 + x202)
            + x35 * (-x182 * x64 + x186 * x64 + x189 + x202)
            - x5
            * (
                x203 * x64
                + x35 * (x182 - x191 + x196)
                - x5 * (x197 * x4 + x205 - x5 * (x195 * x4 - x207 * x5))
            )
            + x64 * (x190 * x64 - x203 * x5 + x35 * (-x176 + x181 + x186)),
            x0 * (-x219 + x225 + x236)
            + x35 * (-x218 * x64 + x222 * x64 + x224 + x236)
            - x5
            * (
                x237 * x64
                + x35 * (x218 - x226 + x231)
                - x5 * (x232 * x4 + x238 - x5 * (x230 * x4 - x240 * x5))
            )
            + x64 * (x225 * x64 - x237 * x5 + x35 * (-x212 + x217 + x222)),
            x0 * (-x252 + x259 + x271)
            + x35 * (-x251 * x64 + x255 * x64 + x258 + x271)
            - x5
            * (
                x272 * x64
                + x35 * (x251 - x260 + x265)
                - x5 * (x266 * x4 + x274 - x5 * (x264 * x4 - x276 * x5))
            )
            + x64 * (x259 * x64 - x272 * x5 + x35 * (-x245 + x250 + x255)),
            x0 * (x284 - x291 + x292)
            + x0 * (x278 * x64 + x284 - x289 * x64 + x290)
            - x5 * (x295 * x64 + x297 - x5 * (x283 * x4 - x299 * x5))
            + x64 * (x292 * x64 + x294 - x295 * x5),
            x0 * (x306 - x312 + x313)
            + x0 * (x301 * x64 + x306 - x310 * x64 + x311)
            - x5 * (x316 * x64 + x318 - x5 * (x305 * x4 - x320 * x5))
            + x64 * (x313 * x64 + x315 - x316 * x5),
            x0 * (x327 - x333 + x334)
            + x0 * (x322 * x64 + x327 - x331 * x64 + x332)
            - x5 * (x336 * x64 + x337 - x5 * (x326 * x4 - x339 * x5))
            + x64 * (x334 * x64 + x335 - x336 * x5),
            x0 * (x347 - x354 + x355)
            + x0 * (x341 * x64 + x347 - x352 * x64 + x353)
            - x5 * (x358 * x64 + x360 - x5 * (x346 * x4 - x362 * x5))
            + x64 * (x355 * x64 + x357 - x358 * x5),
            x369 - x5 * (x371 * x64 - x373 * x5) + x64 * (x365 * x64 - x371 * x5),
            x380 - x5 * (x382 * x64 - x384 * x5) + x64 * (x376 * x64 - x382 * x5),
            x390 - x5 * (x392 * x64 - x394 * x5) + x64 * (x387 * x64 - x392 * x5),
            x399 - x5 * (x401 * x64 - x403 * x5) + x64 * (x398 * x64 - x401 * x5),
            x410 - x5 * (x412 * x64 - x414 * x5) + x64 * (x406 * x64 - x412 * x5),
            -x5
            * (
                x4 * x449
                + x45 * (x435 - x439 + x445 + x453)
                - x5
                * (
                    x35 * (x433 - x440 + x443)
                    + x4 * x446
                    - x5 * (x4 * x444 + x451 - x5 * (x4 * x442 - x452 * x5))
                )
            )
            + x64 * (x4 * x436 - x449 * x5 + x45 * (x426 - x428 + x434 + x450))
            + x66 * (x436 - x437 + x447 - x448),
            x45 * (x464 - x465 - x466 + x472)
            - x5
            * (
                x35 * (x463 - x467 + x470)
                + x4 * x473
                - x5 * (x4 * x471 + x474 - x5 * (x4 * x469 - x475 * x5))
            )
            + x64 * (x35 * (x458 - x459 + x462) + x4 * x464 - x473 * x5),
            x45 * (x486 - x488 + x494 + x498)
            - x5
            * (
                x35 * (x485 - x489 + x492)
                + x4 * x495
                - x5 * (x4 * x493 + x496 - x5 * (x4 * x491 - x497 * x5))
            )
            + x64 * (x35 * (x480 - x481 + x484) + x4 * x486 - x495 * x5),
            x35 * (x503 - x504 + x507)
            - x5 * (x4 * x508 - x5 * (x4 * x506 - x5 * x510) + x509)
            + x64 * (x4 * x503 - x5 * x508 + x501),
            x35 * (x515 - x516 + x519)
            - x5 * (x4 * x520 - x5 * (x4 * x518 - x5 * x522) + x521)
            + x64 * (x4 * x515 - x5 * x520 + x513),
            x35 * (x527 - x528 + x531)
            - x5 * (x4 * x532 - x5 * (x4 * x530 - x5 * x534) + x533)
            + x64 * (x4 * x527 - x5 * x532 + x525),
            -x5 * (x4 * x538 - x5 * x539) + x537 + x64 * (x4 * x536 - x5 * x538),
            -x5 * (x4 * x543 - x5 * x544) + x542 + x64 * (x4 * x541 - x5 * x543),
            -x5 * (x4 * x548 - x5 * x549) + x547 + x64 * (x4 * x546 - x5 * x548),
            -x5 * (x4 * x553 - x5 * x554) + x552 + x64 * (x4 * x551 - x5 * x553),
            -x5 * x556 + x555 * x64,
            -x5 * x558 + x557 * x64,
            -x5 * x560 + x559 * x64,
            -x5 * x562 + x561 * x64,
            -x5 * x564 + x563 * x64,
            -x5
            * (
                x4 * x599
                + x45 * (x585 - x589 + x595 + x603)
                - x5
                * (
                    x35 * (x583 - x590 + x593)
                    + x4 * x596
                    - x5 * (x4 * x594 - x5 * (x4 * x592 - x5 * x602) + x601)
                )
            )
            + x64 * (x4 * x586 + x45 * (x576 - x578 + x584 + x600) - x5 * x599)
            + x66 * (x586 - x587 + x597 - x598),
            x45 * (x619 - x620 - x621 + x629)
            - x5
            * (
                x35 * (x618 - x622 + x627)
                + x4 * x630
                - x5 * (x4 * x628 - x5 * (x4 * x626 - x5 * x633) + x631)
            )
            + x64 * (x35 * (x611 - x612 + x617) + x4 * x619 - x5 * x630),
            x45 * (x644 - x646 + x652 + x656)
            - x5
            * (
                x35 * (x643 - x647 + x650)
                + x4 * x653
                - x5 * (x4 * x651 - x5 * (x4 * x649 - x5 * x655) + x654)
            )
            + x64 * (x35 * (x638 - x639 + x642) + x4 * x644 - x5 * x653),
            x35 * (x665 - x666 + x671)
            - x5 * (x4 * x672 - x5 * (x4 * x670 - x5 * x676) + x674)
            + x64 * (x4 * x665 - x5 * x672 + x662),
            x35 * (x684 - x685 + x690)
            - x5 * (x4 * x691 - x5 * (x4 * x689 - x5 * x694) + x692)
            + x64 * (x4 * x684 - x5 * x691 + x681),
            x35 * (x699 - x700 + x703)
            - x5 * (x4 * x704 - x5 * (x4 * x702 - x5 * x706) + x705)
            + x64 * (x4 * x699 - x5 * x704 + x697),
            -x5 * (x4 * x715 - x5 * x717) + x64 * (x4 * x709 - x5 * x715) + x713,
            -x5 * (x4 * x725 - x5 * x727) + x64 * (x4 * x720 - x5 * x725) + x723,
            -x5 * (x4 * x734 - x5 * x736) + x64 * (x4 * x731 - x5 * x734) + x732,
            -x5 * (x4 * x740 - x5 * x741) + x64 * (x4 * x738 - x5 * x740) + x739,
            -x5 * x745 + x64 * x743,
            -x5 * x749 + x64 * x747,
            -x5 * x753 + x64 * x751,
            -x5 * x757 + x64 * x755,
            -x5 * x759 + x64 * x758,
            x4 * (x35 * (x764 - x765 + x769) + x4 * x771 - x5 * x781)
            + x45 * (x771 - x772 - x773 + x780)
            - x5
            * (
                x35 * (x770 - x774 + x778)
                + x4 * x781
                - x5
                * (
                    x0 * (x69 + x768 - x775 + x776)
                    + x4 * x779
                    - x5 * (x4 * x777 - x5 * (x415 * x442 - x452 * x7 + x67))
                )
            ),
            x35 * (x786 - x787 + x791)
            + x4 * (x0 * (x116 + x450 + x782 - x783 + x784) + x4 * x786 - x5 * x792)
            - x5
            * (
                x0 * (x120 + x453 + x785 - x788 + x789)
                + x4 * x792
                - x5 * (x4 * x790 - x5 * (x117 + x415 * x469 + x451 - x475 * x7))
            ),
            x35 * (x797 - x798 + x802)
            + x4 * (x0 * (x167 + x793 - x794 + x795) + x4 * x797 - x5 * x803)
            - x5
            * (
                x0 * (x171 + x796 - x799 + x800)
                + x4 * x803
                - x5 * (x4 * x801 - x5 * (x168 + x415 * x491 - x497 * x7))
            ),
            x0 * (x201 + x804 - x805 - x806 + x807)
            + x4 * (x4 * x807 - x5 * x808)
            - x5 * (x4 * x808 - x5 * (x205 + x415 * x506 + 2.0 * x474 - x510 * x7)),
            x0 * (x235 + x498 + x809 - x810 + x811)
            + x4 * (x4 * x811 - x5 * x812)
            - x5 * (x4 * x812 - x5 * (x238 + x415 * x518 + x496 - x522 * x7)),
            x0 * (x270 + x813 - x814 + x815)
            + x4 * (x4 * x815 - x5 * x816)
            - x5 * (x4 * x816 - x5 * (x274 + x415 * x530 - x534 * x7)),
            x4 * (x294 + x415 * x536 + 3.0 * x501 - x538 * x7)
            - x5 * (x297 + x415 * x538 + 3.0 * x509 - x539 * x7),
            x4 * (x315 + x415 * x541 + 2.0 * x513 - x543 * x7)
            - x5 * (x318 + x415 * x543 + 2.0 * x521 - x544 * x7),
            x4 * (x335 + x415 * x546 + x525 - x548 * x7)
            - x5 * (x337 + x415 * x548 + x533 - x549 * x7),
            x4 * (x357 + x415 * x551 - x553 * x7) - x5 * (x360 + x415 * x553 - x554 * x7),
            x369 + x415 * x555 + 4.0 * x537 - x556 * x7,
            x380 + x415 * x557 + 3.0 * x542 - x558 * x7,
            x390 + x415 * x559 + 2.0 * x547 - x560 * x7,
            x399 + x415 * x561 + x552 - x562 * x7,
            x410 + x415 * x563 - x564 * x7,
            x4 * (x35 * (x820 - x821 + x824) + x4 * x826 - x5 * x835)
            + x45 * (x826 - x827 - x828 + x834)
            - x5
            * (
                x35 * (x825 - x829 + x832)
                + x4 * x835
                - x5
                * (
                    x0 * (x624 + x823 - x830)
                    + x4 * x833
                    - x5 * (x4 * x831 - x5 * (x415 * x592 + x632))
                )
            ),
            x35 * (x839 - x840 + x843)
            + x4 * (x0 * (x661 - x836 + x837) + x4 * x839 - x5 * x844)
            - x5
            * (
                x0 * (x673 + x838 - x841)
                + x4 * x844
                - x5 * (x4 * x842 - x5 * (x415 * x626 + x675))
            ),
            x35 * (x848 - x849 + x852)
            + x4 * (x0 * (x677 - x845 + x846) + x4 * x848 - x5 * x853)
            - x5
            * (
                x0 * (x687 + x847 - x850)
                + x4 * x853
                - x5 * (x4 * x851 - x5 * (x415 * x649 + x693))
            ),
            x0 * (x712 - x854 + x855)
            + x4 * (x4 * x855 - x5 * x856)
            - x5 * (x4 * x856 - x5 * (x415 * x670 + x716)),
            x0 * (x722 - x857 + x858)
            + x4 * (x4 * x858 - x5 * x859)
            - x5 * (x4 * x859 - x5 * (x415 * x689 + x726)),
            x0 * (x728 - x860 + x861)
            + x4 * (x4 * x861 - x5 * x862)
            - x5 * (x4 * x862 - x5 * (x415 * x702 + x735)),
            x4 * (x415 * x709 + x742) - x5 * (x415 * x715 + x744),
            x4 * (x415 * x720 + x746) - x5 * (x415 * x725 + x748),
            x4 * (x415 * x731 + x750) - x5 * (x415 * x734 + x752),
            x4 * (x415 * x738 + x754) - x5 * (x415 * x740 + x756),
            x415 * x743 - x7 * x745 + 4.0 * x713,
            x415 * x747 - x7 * x749 + 3.0 * x723,
            x415 * x751 - x7 * x753 + 2.0 * x732,
            x415 * x755 - x7 * x757 + x739,
            x415 * x758 - x7 * x759,
            x4 * (x35 * (x868 - x869 + x873) + x4 * x875 - x5 * x885)
            + x45 * (x875 - x877 + x884 + x888)
            - x5
            * (
                x35 * (x874 - x878 + x882)
                + x4 * x885
                - x5 * (x4 * x883 - x5 * (x4 * x881 - x5 * x887) + x886)
            ),
            x35 * (x894 - x895 + x899)
            + x4 * (x4 * x894 - x5 * x900 + x892)
            - x5 * (x4 * x900 - x5 * (x4 * x898 - x5 * x902) + x901),
            x35 * (x908 - x909 + x913)
            + x4 * (x4 * x908 - x5 * x914 + x906)
            - x5 * (x4 * x914 - x5 * (x4 * x912 - x5 * x916) + x915),
            x4 * (x4 * x919 - x5 * x921) - x5 * (x4 * x921 - x5 * x922) + x920,
            x4 * (x4 * x925 - x5 * x927) - x5 * (x4 * x927 - x5 * x928) + x926,
            x4 * (x4 * x932 - x5 * x934) - x5 * (x4 * x934 - x5 * x935) + x933,
            x4 * x936 - x5 * x937,
            x4 * x938 - x5 * x939,
            x4 * x940 - x5 * x941,
            x4 * x942 - x5 * x943,
            -x7 * x937 + x70 * x936 + 3.0 * x920,
            -x7 * x939 + x70 * x938 + 2.0 * x926,
            -x7 * x941 + x70 * x940 + x933,
            -x7 * x943 + x70 * x942,
            x410 + x565 * x758 + 4.0 * x739 - x759 * x9,
        ]
    )


def coulomb3d_30(a, A, b, B, C):
    """Cartesian (fs) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - C[0]
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x1 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x0 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(1, x10)
    x13 = x11 * boys(0, x10)
    x14 = x4 * (-x12 + x13)
    x15 = -x12 * x5 + x13 * x3
    x16 = x11 * boys(2, x10)
    x17 = x16 * x5
    x18 = x12 * x3
    x19 = -x17 + x18
    x20 = x4 * (x12 - x16)
    x21 = x11 * boys(3, x10)
    x22 = -x6 - A[1]
    x23 = x12 * x22
    x24 = x16 * x7
    x25 = -x12 * x7 + x13 * x22
    x26 = x4 * (-x23 + x24 + x25)
    x27 = x23 - x24
    x28 = x16 * x22 - x21 * x7
    x29 = -x8 - A[2]
    x30 = x12 * x29
    x31 = x16 * x9
    x32 = -x12 * x9 + x13 * x29
    x33 = x4 * (-x30 + x31 + x32)
    x34 = x30 - x31
    x35 = x16 * x29 - x21 * x9
    x36 = x14 + x22 * x25 - x27 * x7
    x37 = x20 + x22 * x27 - x28 * x7
    x38 = x22 * x32 - x34 * x7
    x39 = x22 * x34 - x35 * x7
    x40 = x14 + x29 * x32 - x34 * x9
    x41 = x20 + x29 * x34 - x35 * x9

    # 10 item(s)
    return numpy.array(
        [
            x3 * (x14 + x15 * x3 - x19 * x5)
            + 2.0 * x4 * (x15 + x17 - x18)
            - x5 * (x19 * x3 + x20 - x5 * (x16 * x3 - x21 * x5)),
            x26 + x3 * (x25 * x3 - x27 * x5) - x5 * (x27 * x3 - x28 * x5),
            x3 * (x3 * x32 - x34 * x5) + x33 - x5 * (x3 * x34 - x35 * x5),
            x3 * x36 - x37 * x5,
            x3 * x38 - x39 * x5,
            x3 * x40 - x41 * x5,
            x22 * x36 + 2.0 * x26 - x37 * x7,
            x22 * x38 + x33 - x39 * x7,
            x22 * x40 - x41 * x7,
            x29 * x40 + 2.0 * x33 - x41 * x9,
        ]
    )


def coulomb3d_31(a, A, b, B, C):
    """Cartesian (fp) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - C[0]
    x5 = -x2 * (a * A[1] + b * B[1])
    x6 = -x5 - C[1]
    x7 = -x2 * (a * A[2] + b * B[2])
    x8 = -x7 - C[2]
    x9 = x1 * (x4**2 + x6**2 + x8**2)
    x10 = (
        6.28318530717959
        * x2
        * numpy.exp(
            -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x11 = x10 * boys(1, x9)
    x12 = x10 * boys(0, x9)
    x13 = x0 * (-x11 + x12)
    x14 = -x3 - A[0]
    x15 = -x11 * x4
    x16 = x12 * x14 + x15
    x17 = x10 * boys(3, x9)
    x18 = x17 * x4
    x19 = -x18
    x20 = x10 * boys(2, x9)
    x21 = x14 * x20
    x22 = x0 * (x11 - x20)
    x23 = -x22
    x24 = x20 * x4
    x25 = -x24
    x26 = x11 * x14
    x27 = x25 + x26
    x28 = -x3 - B[0]
    x29 = x11 * x28
    x30 = x12 * x28 + x15
    x31 = x25 + x29
    x32 = x13 + x14 * x30 - x31 * x4
    x33 = x14 * x31
    x34 = x20 * x28
    x35 = x19 + x34
    x36 = x35 * x4
    x37 = x22 + x33 - x36
    x38 = x0 * (-x17 + x20)
    x39 = x10 * boys(4, x9)
    x40 = 2.0 * x0
    x41 = -x5 - B[1]
    x42 = x11 * x41
    x43 = x20 * x6
    x44 = -x11 * x6
    x45 = x12 * x41 + x44
    x46 = x0 * (-x42 + x43 + x45)
    x47 = -x43
    x48 = x42 + x47
    x49 = x14 * x45 - x4 * x48
    x50 = x14 * x48
    x51 = x17 * x6
    x52 = -x51
    x53 = x20 * x41
    x54 = x52 + x53
    x55 = x4 * x54
    x56 = x50 - x55
    x57 = x0 * (x48 + x51 - x53)
    x58 = -x39 * x6
    x59 = x17 * x41 + x58
    x60 = -x7 - B[2]
    x61 = x11 * x60
    x62 = x20 * x8
    x63 = -x11 * x8
    x64 = x12 * x60 + x63
    x65 = x0 * (-x61 + x62 + x64)
    x66 = -x62
    x67 = x61 + x66
    x68 = x14 * x64 - x4 * x67
    x69 = x14 * x67
    x70 = x17 * x8
    x71 = -x70
    x72 = x20 * x60
    x73 = x71 + x72
    x74 = x4 * x73
    x75 = x69 - x74
    x76 = x0 * (x67 + x70 - x72)
    x77 = -x39 * x8
    x78 = x17 * x60 + x77
    x79 = -x5 - A[1]
    x80 = x12 * x79 + x44
    x81 = x20 * x79
    x82 = x52 + x81
    x83 = x4 * x82
    x84 = x11 * x79
    x85 = x47 + x84
    x86 = -x4 * x85
    x87 = x28 * x85
    x88 = x28 * x80 + x86
    x89 = x0 * (x43 + x80 - x84)
    x90 = -x83 + x87
    x91 = x0 * (x51 - x81 + x85)
    x92 = x17 * x79 + x58
    x93 = x54 * x6
    x94 = x48 * x79
    x95 = x13 + x45 * x79 - x48 * x6
    x96 = x0 * (x23 + x93 - x94 + x95)
    x97 = x22 - x93 + x94
    x98 = x38 + x54 * x79 - x59 * x6
    x99 = x6 * x73
    x100 = x67 * x79
    x101 = -x6 * x67 + x64 * x79
    x102 = x0 * (-x100 + x101 + x99)
    x103 = x100 - x99
    x104 = -x6 * x78 + x73 * x79
    x105 = -x7 - A[2]
    x106 = x105 * x12 + x63
    x107 = x105 * x20
    x108 = x107 + x71
    x109 = x108 * x4
    x110 = x105 * x11
    x111 = x110 + x66
    x112 = -x111 * x4
    x113 = x111 * x28
    x114 = x106 * x28 + x112
    x115 = x0 * (x106 - x110 + x62)
    x116 = -x109 + x113
    x117 = x0 * (-x107 + x111 + x70)
    x118 = x105 * x17 + x77
    x119 = x108 * x6
    x120 = x111 * x41
    x121 = -x111 * x6
    x122 = x106 * x41 + x121
    x123 = x0 * (x119 - x120 + x122)
    x124 = -x119
    x125 = x120 + x124
    x126 = -x118 * x6
    x127 = x108 * x41 + x126
    x128 = x73 * x8
    x129 = x105 * x67
    x130 = x105 * x64 + x13 - x67 * x8
    x131 = x0 * (x128 - x129 + x130 + x23)
    x132 = -x128 + x129 + x22
    x133 = x105 * x73 + x38 - x78 * x8
    x134 = x6 * x82
    x135 = x79 * x85
    x136 = x13 - x6 * x85 + x79 * x80
    x137 = x0 * (x134 - x135 + x136 + x23)
    x138 = -x134 + x135 + x22
    x139 = x38 - x6 * x92 + x79 * x82
    x140 = x46 - x6 * x97 + x79 * x95 + x89
    x141 = x57 - x6 * x98 + x79 * x97 + x91
    x142 = x101 * x79 - x103 * x6 + x65
    x143 = x103 * x79 - x104 * x6 + x76
    x144 = x111 * x79
    x145 = x106 * x79 + x121
    x146 = x0 * (x119 - x144 + x145)
    x147 = x124 + x144
    x148 = x108 * x79 + x126
    x149 = x115 + x122 * x79 - x125 * x6
    x150 = x117 + x125 * x79 - x127 * x6
    x151 = x130 * x79 - x132 * x6
    x152 = x132 * x79 - x133 * x6
    x153 = x108 * x8
    x154 = x105 * x111
    x155 = x105 * x106 - x111 * x8 + x13
    x156 = x0 * (x153 - x154 + x155 + x23)
    x157 = -x153 + x154 + x22
    x158 = x105 * x108 - x118 * x8 + x38
    x159 = -x157 * x6
    x160 = x155 * x41 + x159
    x161 = -x158 * x6
    x162 = x157 * x41 + x161
    x163 = x105 * x130 + x115 - x132 * x8 + x65
    x164 = x105 * x132 + x117 - x133 * x8 + x76
    x165 = x105 * x155 + 2.0 * x115 - x157 * x8
    x166 = x105 * x157 + 2.0 * x117 - x158 * x8

    # 30 item(s)
    return numpy.array(
        [
            x0 * (x13 + x14 * x16 - x14 * x27 + x23 - x27 * x4 + x4 * (x19 + x21))
            + x14
            * (x0 * (x16 + x24 - x26) + x0 * (x24 - x29 + x30) + x14 * x32 - x37 * x4)
            - x4
            * (
                x0 * (x18 - x21 + x27)
                + x0 * (x18 + x31 - x34)
                + x14 * x37
                - x4 * (x14 * x35 + x38 - x4 * (x17 * x28 - x39 * x4))
            )
            + x40 * (x23 + x32 - x33 + x36),
            x14 * (x14 * x49 - x4 * x56 + x46)
            - x4 * (x14 * x56 - x4 * (x14 * x54 - x4 * x59) + x57)
            + x40 * (x49 - x50 + x55),
            x14 * (x14 * x68 - x4 * x75 + x65)
            - x4 * (x14 * x75 - x4 * (x14 * x73 - x4 * x78) + x76)
            + x40 * (x68 - x69 + x74),
            x0 * (x83 - x87 + x88)
            + x0 * (x14 * x80 - x14 * x85 + x83 + x86)
            + x14 * (x14 * x88 - x4 * x90 + x89)
            - x4 * (x14 * x90 - x4 * (x28 * x82 - x4 * x92) + x91),
            x14 * (x14 * x95 - x4 * x97) - x4 * (x14 * x97 - x4 * x98) + x96,
            x102 + x14 * (x101 * x14 - x103 * x4) - x4 * (x103 * x14 - x104 * x4),
            x0 * (x109 - x113 + x114)
            + x0 * (x106 * x14 + x109 - x111 * x14 + x112)
            + x14 * (x114 * x14 + x115 - x116 * x4)
            - x4 * (x116 * x14 + x117 - x4 * (x108 * x28 - x118 * x4)),
            x123 + x14 * (x122 * x14 - x125 * x4) - x4 * (x125 * x14 - x127 * x4),
            x131 + x14 * (x130 * x14 - x132 * x4) - x4 * (x132 * x14 - x133 * x4),
            x137 + x14 * (x136 * x28 - x138 * x4) - x4 * (x138 * x28 - x139 * x4),
            x14 * x140 - x141 * x4,
            x14 * x142 - x143 * x4,
            x14 * (x145 * x28 - x147 * x4) + x146 - x4 * (x147 * x28 - x148 * x4),
            x14 * x149 - x150 * x4,
            x14 * x151 - x152 * x4,
            x14 * (x155 * x28 - x157 * x4) + x156 - x4 * (x157 * x28 - x158 * x4),
            x14 * x160 - x162 * x4,
            x14 * x163 - x164 * x4,
            x28 * (x136 * x79 - x138 * x6 + 2.0 * x89)
            - x4 * (x138 * x79 - x139 * x6 + 2.0 * x91),
            x137 + x140 * x79 - x141 * x6 + 2.0 * x96,
            2.0 * x102 + x142 * x79 - x143 * x6,
            x28 * (x115 + x145 * x79 - x147 * x6) - x4 * (x117 + x147 * x79 - x148 * x6),
            x123 + x146 + x149 * x79 - x150 * x6,
            x131 + x151 * x79 - x152 * x6,
            x28 * (x155 * x79 + x159) - x4 * (x157 * x79 + x161),
            x156 + x160 * x79 - x162 * x6,
            x163 * x79 - x164 * x6,
            x165 * x28 - x166 * x4,
            x165 * x41 - x166 * x6,
            x105 * x163 + 2.0 * x131 + x156 - x164 * x8,
        ]
    )


def coulomb3d_32(a, A, b, B, C):
    """Cartesian (fd) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - B[0]
    x6 = -x2 - C[0]
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 * (x10**2 + x6**2 + x8**2)
    x12 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x13 = x12 * boys(2, x11)
    x14 = x13 * x6
    x15 = -x14
    x16 = x12 * boys(1, x11)
    x17 = x16 * x5
    x18 = x15 + x17
    x19 = x18 * x5
    x20 = -x16 * x6
    x21 = x12 * boys(0, x11)
    x22 = x20 + x21 * x5
    x23 = x4 * (-x16 + x21)
    x24 = -x18 * x6 + x23
    x25 = x22 * x5 + x24
    x26 = x12 * boys(3, x11)
    x27 = x26 * x6
    x28 = x13 * x5
    x29 = -x27 + x28
    x30 = x29 * x6
    x31 = x4 * (-x13 + x16)
    x32 = -x31
    x33 = x30 + x32
    x34 = -x30 + x31
    x35 = x19 + x34
    x36 = x4 * (x14 - x17 + x22)
    x37 = x25 * x3 - x35 * x6 + 2.0 * x36
    x38 = x3 * x35
    x39 = x29 * x5
    x40 = x4 * (x13 - x26)
    x41 = x12 * boys(4, x11)
    x42 = x41 * x6
    x43 = x26 * x5
    x44 = -x42 + x43
    x45 = x44 * x6
    x46 = x40 - x45
    x47 = x39 + x46
    x48 = x47 * x6
    x49 = x4 * (x18 + x27 - x28)
    x50 = 2.0 * x49
    x51 = x38 - x48 + x50
    x52 = x18 * x3
    x53 = x22 * x3 + x24
    x54 = 2.0 * x4
    x55 = -x40
    x56 = x45 + x55
    x57 = x4 * (x26 - x41)
    x58 = x12 * boys(5, x11)
    x59 = x29 * x3
    x60 = x34 + x52
    x61 = x16 * x3
    x62 = -x7 - B[1]
    x63 = x16 * x62
    x64 = x13 * x8
    x65 = -x16 * x8
    x66 = x21 * x62 + x65
    x67 = x4 * (-x63 + x64 + x66)
    x68 = -x64
    x69 = x63 + x68
    x70 = -x6 * x69
    x71 = x3 * x66 + x70
    x72 = x26 * x8
    x73 = -x72
    x74 = x13 * x62
    x75 = x73 + x74
    x76 = x3 * x75
    x77 = x41 * x8
    x78 = -x77
    x79 = x26 * x62
    x80 = x78 + x79
    x81 = x6 * x80
    x82 = -x81
    x83 = x4 * (x69 + x72 - x74)
    x84 = -x83
    x85 = x3 * x69
    x86 = x6 * x75
    x87 = -x86
    x88 = x85 + x87
    x89 = x5 * x69
    x90 = x5 * x66 + x70
    x91 = x87 + x89
    x92 = x3 * x90 - x6 * x91 + x67
    x93 = x3 * x91
    x94 = x5 * x75
    x95 = x82 + x94
    x96 = x6 * x95
    x97 = x83 + x93 - x96
    x98 = x4 * (x75 + x77 - x79)
    x99 = -x58 * x8
    x100 = x41 * x62 + x99
    x101 = -x9 - B[2]
    x102 = x101 * x16
    x103 = x10 * x13
    x104 = -x10 * x16
    x105 = x101 * x21 + x104
    x106 = x4 * (-x102 + x103 + x105)
    x107 = -x103
    x108 = x102 + x107
    x109 = -x108 * x6
    x110 = x105 * x3 + x109
    x111 = x10 * x26
    x112 = -x111
    x113 = x101 * x13
    x114 = x112 + x113
    x115 = x114 * x3
    x116 = x10 * x41
    x117 = -x116
    x118 = x101 * x26
    x119 = x117 + x118
    x120 = x119 * x6
    x121 = -x120
    x122 = x4 * (x108 + x111 - x113)
    x123 = -x122
    x124 = x108 * x3
    x125 = x114 * x6
    x126 = -x125
    x127 = x124 + x126
    x128 = x108 * x5
    x129 = x105 * x5 + x109
    x130 = x126 + x128
    x131 = x106 + x129 * x3 - x130 * x6
    x132 = x130 * x3
    x133 = x114 * x5
    x134 = x121 + x133
    x135 = x134 * x6
    x136 = x122 + x132 - x135
    x137 = x4 * (x114 + x116 - x118)
    x138 = -x10 * x58
    x139 = x101 * x41 + x138
    x140 = x62 * x69
    x141 = x23 - x69 * x8
    x142 = x141 + x62 * x66
    x143 = x75 * x8
    x144 = x143 + x32
    x145 = x4 * (-x140 + x142 + x144)
    x146 = -x143 + x31
    x147 = x140 + x146
    x148 = x142 * x3 - x147 * x6
    x149 = x147 * x3
    x150 = x62 * x75
    x151 = x8 * x80
    x152 = -x151 + x40
    x153 = x150 + x152
    x154 = x153 * x6
    x155 = x149 - x154
    x156 = x151 + x55
    x157 = x4 * (x147 - x150 + x156)
    x158 = -x100 * x8 + x57
    x159 = x158 + x62 * x80
    x160 = x114 * x8
    x161 = x108 * x62
    x162 = -x108 * x8
    x163 = x105 * x62 + x162
    x164 = x4 * (x160 - x161 + x163)
    x165 = -x160
    x166 = x161 + x165
    x167 = x163 * x3 - x166 * x6
    x168 = x166 * x3
    x169 = x114 * x62
    x170 = x119 * x8
    x171 = -x170
    x172 = x169 + x171
    x173 = x172 * x6
    x174 = x168 - x173
    x175 = x4 * (x166 - x169 + x170)
    x176 = -x139 * x8
    x177 = x119 * x62 + x176
    x178 = x101 * x108
    x179 = -x10 * x108 + x23
    x180 = x101 * x105 + x179
    x181 = x10 * x114
    x182 = x181 + x32
    x183 = x4 * (-x178 + x180 + x182)
    x184 = -x181 + x31
    x185 = x178 + x184
    x186 = x180 * x3 - x185 * x6
    x187 = x185 * x3
    x188 = x101 * x114
    x189 = x10 * x119
    x190 = -x189 + x40
    x191 = x188 + x190
    x192 = x191 * x6
    x193 = x187 - x192
    x194 = x189 + x55
    x195 = x4 * (x185 - x188 + x194)
    x196 = -x10 * x139 + x57
    x197 = x101 * x119 + x196
    x198 = -x7 - A[1]
    x199 = x16 * x198
    x200 = x199 + x68
    x201 = x200 * x5
    x202 = x13 * x198
    x203 = x202 + x73
    x204 = x203 * x6
    x205 = x201 - x204
    x206 = x205 * x5
    x207 = x198 * x21 + x65
    x208 = -x200 * x6 + x207 * x5
    x209 = x4 * (-x199 + x207 + x64)
    x210 = -x205 * x6 + x209
    x211 = x208 * x5 + x210
    x212 = x203 * x5
    x213 = x198 * x26
    x214 = x213 + x78
    x215 = x214 * x6
    x216 = x212 - x215
    x217 = x216 * x6
    x218 = x4 * (x200 - x202 + x72)
    x219 = -x218
    x220 = x217 + x219
    x221 = x206 - x217 + x218
    x222 = x4 * (x203 - x213 + x77)
    x223 = x198 * x41 + x99
    x224 = x141 + x198 * x66
    x225 = x198 * x75
    x226 = x152 + x225
    x227 = x226 * x6
    x228 = x198 * x69
    x229 = x146 + x228
    x230 = -x229 * x6
    x231 = x229 * x5
    x232 = x224 * x5 + x230
    x233 = x4 * (x144 + x224 - x228)
    x234 = -x227 + x231
    x235 = x4 * (x156 - x225 + x229)
    x236 = x158 + x198 * x80
    x237 = x105 * x198 + x162
    x238 = x114 * x198
    x239 = x171 + x238
    x240 = x239 * x6
    x241 = x108 * x198
    x242 = x165 + x241
    x243 = -x242 * x6
    x244 = x242 * x5
    x245 = x237 * x5 + x243
    x246 = x4 * (x160 + x237 - x241)
    x247 = -x240 + x244
    x248 = x4 * (x170 - x238 + x242)
    x249 = x119 * x198 + x176
    x250 = x153 * x8
    x251 = x147 * x198
    x252 = 2.0 * x83
    x253 = x142 * x198 - x147 * x8 + 2.0 * x67
    x254 = x4 * (x250 - x251 - x252 + x253)
    x255 = -x250 + x251 + x252
    x256 = x153 * x198 - x159 * x8 + 2.0 * x98
    x257 = x172 * x8
    x258 = x166 * x198
    x259 = x106 + x163 * x198 - x166 * x8
    x260 = x4 * (x123 + x257 - x258 + x259)
    x261 = x122 - x257 + x258
    x262 = x137 + x172 * x198 - x177 * x8
    x263 = x191 * x8
    x264 = x185 * x198
    x265 = x180 * x198 - x185 * x8
    x266 = x4 * (x263 - x264 + x265)
    x267 = -x263 + x264
    x268 = x191 * x198 - x197 * x8
    x269 = -x9 - A[2]
    x270 = x16 * x269
    x271 = x107 + x270
    x272 = x271 * x5
    x273 = x13 * x269
    x274 = x112 + x273
    x275 = x274 * x6
    x276 = x272 - x275
    x277 = x276 * x5
    x278 = x104 + x21 * x269
    x279 = -x271 * x6 + x278 * x5
    x280 = x4 * (x103 - x270 + x278)
    x281 = -x276 * x6 + x280
    x282 = x279 * x5 + x281
    x283 = x274 * x5
    x284 = x26 * x269
    x285 = x117 + x284
    x286 = x285 * x6
    x287 = x283 - x286
    x288 = x287 * x6
    x289 = x4 * (x111 + x271 - x273)
    x290 = -x289
    x291 = x288 + x290
    x292 = x277 - x288 + x289
    x293 = x4 * (x116 + x274 - x284)
    x294 = x138 + x269 * x41
    x295 = -x271 * x8
    x296 = x278 * x62 + x295
    x297 = x274 * x62
    x298 = x285 * x8
    x299 = -x298
    x300 = x297 + x299
    x301 = x300 * x6
    x302 = x271 * x62
    x303 = x274 * x8
    x304 = -x303
    x305 = x302 + x304
    x306 = -x305 * x6
    x307 = x305 * x5
    x308 = x296 * x5 + x306
    x309 = x4 * (x296 - x302 + x303)
    x310 = -x301 + x307
    x311 = x4 * (-x297 + x298 + x305)
    x312 = -x294 * x8
    x313 = x285 * x62 + x312
    x314 = x105 * x269 + x179
    x315 = x114 * x269
    x316 = x190 + x315
    x317 = x316 * x6
    x318 = x108 * x269
    x319 = x184 + x318
    x320 = -x319 * x6
    x321 = x319 * x5
    x322 = x314 * x5 + x320
    x323 = x4 * (x182 + x314 - x318)
    x324 = -x317 + x321
    x325 = x4 * (x194 - x315 + x319)
    x326 = x119 * x269 + x196
    x327 = x305 * x62
    x328 = x280 - x305 * x8
    x329 = x296 * x62 + x328
    x330 = x300 * x8
    x331 = x290 + x330
    x332 = x4 * (-x327 + x329 + x331)
    x333 = x289 - x330
    x334 = x327 + x333
    x335 = x293 - x313 * x8
    x336 = x300 * x62 + x335
    x337 = x316 * x8
    x338 = x319 * x62
    x339 = -x319 * x8
    x340 = x314 * x62 + x339
    x341 = x4 * (x337 - x338 + x340)
    x342 = -x337
    x343 = x338 + x342
    x344 = -x326 * x8
    x345 = x316 * x62 + x344
    x346 = x10 * x191
    x347 = x185 * x269
    x348 = 2.0 * x122
    x349 = -x10 * x185 + 2.0 * x106 + x180 * x269
    x350 = x4 * (x346 - x347 - x348 + x349)
    x351 = -x346 + x347 + x348
    x352 = -x10 * x197 + 2.0 * x137 + x191 * x269
    x353 = x203 * x8
    x354 = x198 * x200
    x355 = x198 * x207 - x200 * x8 + x23
    x356 = x4 * (x32 + x353 - x354 + x355)
    x357 = x31 - x353 + x354
    x358 = x355 * x5 - x357 * x6
    x359 = x357 * x5
    x360 = x198 * x203
    x361 = x214 * x8
    x362 = x360 - x361 + x40
    x363 = x362 * x6
    x364 = x359 - x363
    x365 = x4 * (x357 - x360 + x361 + x55)
    x366 = x198 * x214 - x223 * x8 + x57
    x367 = x226 * x8
    x368 = x198 * x229
    x369 = x198 * x224 + x209 - x229 * x8 + x67
    x370 = x4 * (x219 + x367 - x368 + x369 + x84)
    x371 = x218 - x367 + x368 + x83
    x372 = x198 * x226 + x222 - x236 * x8 + x98
    x373 = x239 * x8
    x374 = x198 * x242
    x375 = x106 + x198 * x237 - x242 * x8
    x376 = x4 * (x123 + x373 - x374 + x375)
    x377 = x122 - x373 + x374
    x378 = x137 + x198 * x239 - x249 * x8
    x379 = 2.0 * x233
    x380 = x145 + x198 * x253 - x255 * x8 + x379
    x381 = 2.0 * x235
    x382 = x157 + x198 * x255 - x256 * x8 + x381
    x383 = x164 + x198 * x259 + x246 - x261 * x8
    x384 = x175 + x198 * x261 + x248 - x262 * x8
    x385 = x183 + x198 * x265 - x267 * x8
    x386 = x195 + x198 * x267 - x268 * x8
    x387 = x198 * x271
    x388 = x198 * x278 + x295
    x389 = x4 * (x303 - x387 + x388)
    x390 = x304 + x387
    x391 = x388 * x5 - x390 * x6
    x392 = x390 * x5
    x393 = x198 * x274
    x394 = x299 + x393
    x395 = x394 * x6
    x396 = x392 - x395
    x397 = x4 * (x298 + x390 - x393)
    x398 = x198 * x285 + x312
    x399 = x198 * x305
    x400 = x198 * x296 + x328
    x401 = x4 * (x331 - x399 + x400)
    x402 = x333 + x399
    x403 = x198 * x300 + x335
    x404 = x198 * x319
    x405 = x198 * x314 + x339
    x406 = x4 * (x337 - x404 + x405)
    x407 = x342 + x404
    x408 = x198 * x316 + x344
    x409 = x198 * x329 + 2.0 * x309 - x334 * x8
    x410 = x198 * x334 + 2.0 * x311 - x336 * x8
    x411 = x198 * x340 + x323 - x343 * x8
    x412 = x198 * x343 + x325 - x345 * x8
    x413 = x198 * x349 - x351 * x8
    x414 = x198 * x351 - x352 * x8
    x415 = x10 * x274
    x416 = x269 * x271
    x417 = -x10 * x271 + x23 + x269 * x278
    x418 = x4 * (x32 + x415 - x416 + x417)
    x419 = x31 - x415 + x416
    x420 = x417 * x5 - x419 * x6
    x421 = x419 * x5
    x422 = x269 * x274
    x423 = x10 * x285
    x424 = x40 + x422 - x423
    x425 = x424 * x6
    x426 = x421 - x425
    x427 = x4 * (x419 - x422 + x423 + x55)
    x428 = -x10 * x294 + x269 * x285 + x57
    x429 = x424 * x8
    x430 = x419 * x62
    x431 = -x419 * x8
    x432 = x417 * x62 + x431
    x433 = x4 * (x429 - x430 + x432)
    x434 = -x429
    x435 = x430 + x434
    x436 = -x428 * x8
    x437 = x424 * x62 + x436
    x438 = x10 * x316
    x439 = x269 * x319
    x440 = -x10 * x319 + x106 + x269 * x314 + x280
    x441 = x4 * (x123 + x290 + x438 - x439 + x440)
    x442 = x122 + x289 - x438 + x439
    x443 = -x10 * x326 + x137 + x269 * x316 + x293
    x444 = x418 - x435 * x8
    x445 = x432 * x62 + x444
    x446 = x427 - x437 * x8
    x447 = x435 * x62 + x446
    x448 = -x442 * x8
    x449 = x440 * x62 + x448
    x450 = -x443 * x8
    x451 = x442 * x62 + x450
    x452 = 2.0 * x323
    x453 = -x10 * x351 + x183 + x269 * x349 + x452
    x454 = 2.0 * x325
    x455 = -x10 * x352 + x195 + x269 * x351 + x454
    x456 = x362 * x8
    x457 = x198 * x357
    x458 = 2.0 * x218
    x459 = x198 * x355 + 2.0 * x209 - x357 * x8
    x460 = -x456 + x457 + x458
    x461 = x394 * x8
    x462 = x198 * x390
    x463 = x198 * x388 + x280 - x390 * x8
    x464 = x289 - x461 + x462
    x465 = x198 * x419
    x466 = x198 * x417 + x431
    x467 = x434 + x465
    x468 = x10 * x424
    x469 = x269 * x419
    x470 = 2.0 * x289
    x471 = -x10 * x419 + x269 * x417 + 2.0 * x280
    x472 = x4 * (x468 - x469 - x470 + x471)
    x473 = -x468 + x469 + x470
    x474 = -x10 * x428 + x269 * x424 + 2.0 * x293
    x475 = x471 * x62 - x473 * x8
    x476 = x473 * x62 - x474 * x8
    x477 = -x10 * x442 + x269 * x440 + x418 + x452
    x478 = -x10 * x443 + x269 * x442 + x427 + x454

    # 60 item(s)
    return numpy.array(
        [
            x3 * (x3 * x37 + x4 * (-x19 + x25 + x33) - x51 * x6 + x54 * (x33 - x52 + x53))
            + x54 * (x37 - x38 + x48 - x50)
            + x54
            * (
                x3 * x53
                - x3 * x60
                + x36
                + x4 * (x14 + x20 + x21 * x3 - x61)
                - x4 * (-x13 * x3 + x15 + x27 + x61)
                - x49
                - x6 * x60
                + x6 * (x46 + x59)
            )
            - x6
            * (
                x3 * x51
                + x4 * (x35 - x39 + x56)
                + x54 * (x56 - x59 + x60)
                - x6
                * (
                    x3 * x47
                    + x54 * (x29 + x42 - x43)
                    - x6 * (x44 * x5 + x57 - x6 * (x41 * x5 - x58 * x6))
                )
            ),
            x3 * (x3 * x92 + x4 * (x71 - x85 + x86) + x4 * (x86 - x89 + x90) - x6 * x97)
            + x4 * (x3 * x71 - x3 * x88 - x6 * x88 + x6 * (x76 + x82) + x67 + x84)
            + x54 * (x84 + x92 - x93 + x96)
            - x6
            * (
                x3 * x97
                + x4 * (-x76 + x81 + x88)
                + x4 * (x81 + x91 - x94)
                - x6 * (x3 * x95 - x6 * (-x100 * x6 + x5 * x80) + x98)
            ),
            x3
            * (
                x131 * x3
                - x136 * x6
                + x4 * (x110 - x124 + x125)
                + x4 * (x125 - x128 + x129)
            )
            + x4 * (x106 + x110 * x3 + x123 - x127 * x3 - x127 * x6 + x6 * (x115 + x121))
            + x54 * (x123 + x131 - x132 + x135)
            - x6
            * (
                x136 * x3
                + x4 * (-x115 + x120 + x127)
                + x4 * (x120 + x130 - x133)
                - x6 * (x134 * x3 + x137 - x6 * (x119 * x5 - x139 * x6))
            ),
            x3 * (x145 + x148 * x3 - x155 * x6)
            + x54 * (x148 - x149 + x154)
            - x6 * (x155 * x3 + x157 - x6 * (x153 * x3 - x159 * x6)),
            x3 * (x164 + x167 * x3 - x174 * x6)
            + x54 * (x167 - x168 + x173)
            - x6 * (x174 * x3 + x175 - x6 * (x172 * x3 - x177 * x6)),
            x3 * (x183 + x186 * x3 - x193 * x6)
            + x54 * (x186 - x187 + x192)
            - x6 * (x193 * x3 + x195 - x6 * (x191 * x3 - x197 * x6)),
            x3 * (x211 * x3 - x221 * x6 + x54 * (-x201 + x204 + x208))
            + x4 * (-x206 + x211 + x220)
            + x54 * (-x205 * x3 + x208 * x3 + x210 + x220)
            - x6
            * (
                x221 * x3
                + x54 * (x205 - x212 + x215)
                - x6 * (x216 * x5 + x222 - x6 * (x214 * x5 - x223 * x6))
            ),
            x3 * (x232 * x3 + x233 - x234 * x6)
            + x4 * (x227 - x231 + x232)
            + x4 * (x224 * x3 + x227 - x229 * x3 + x230)
            - x6 * (x234 * x3 + x235 - x6 * (x226 * x5 - x236 * x6)),
            x3 * (x245 * x3 + x246 - x247 * x6)
            + x4 * (x240 - x244 + x245)
            + x4 * (x237 * x3 + x240 - x242 * x3 + x243)
            - x6 * (x247 * x3 + x248 - x6 * (x239 * x5 - x249 * x6)),
            x254 + x3 * (x253 * x3 - x255 * x6) - x6 * (x255 * x3 - x256 * x6),
            x260 + x3 * (x259 * x3 - x261 * x6) - x6 * (x261 * x3 - x262 * x6),
            x266 + x3 * (x265 * x3 - x267 * x6) - x6 * (x267 * x3 - x268 * x6),
            x3 * (x282 * x3 - x292 * x6 + x54 * (-x272 + x275 + x279))
            + x4 * (-x277 + x282 + x291)
            + x54 * (-x276 * x3 + x279 * x3 + x281 + x291)
            - x6
            * (
                x292 * x3
                + x54 * (x276 - x283 + x286)
                - x6 * (x287 * x5 + x293 - x6 * (x285 * x5 - x294 * x6))
            ),
            x3 * (x3 * x308 + x309 - x310 * x6)
            + x4 * (x301 - x307 + x308)
            + x4 * (x296 * x3 - x3 * x305 + x301 + x306)
            - x6 * (x3 * x310 + x311 - x6 * (x300 * x5 - x313 * x6)),
            x3 * (x3 * x322 + x323 - x324 * x6)
            + x4 * (x317 - x321 + x322)
            + x4 * (x3 * x314 - x3 * x319 + x317 + x320)
            - x6 * (x3 * x324 + x325 - x6 * (x316 * x5 - x326 * x6)),
            x3 * (x3 * x329 - x334 * x6) + x332 - x6 * (x3 * x334 - x336 * x6),
            x3 * (x3 * x340 - x343 * x6) + x341 - x6 * (x3 * x343 - x345 * x6),
            x3 * (x3 * x349 - x351 * x6) + x350 - x6 * (x3 * x351 - x352 * x6),
            x3 * (x356 + x358 * x5 - x364 * x6)
            + x54 * (x358 - x359 + x363)
            - x6 * (x364 * x5 + x365 - x6 * (x362 * x5 - x366 * x6)),
            x3 * (x369 * x5 - x371 * x6) + x370 - x6 * (x371 * x5 - x372 * x6),
            x3 * (x375 * x5 - x377 * x6) + x376 - x6 * (x377 * x5 - x378 * x6),
            x3 * x380 - x382 * x6,
            x3 * x383 - x384 * x6,
            x3 * x385 - x386 * x6,
            x3 * (x389 + x391 * x5 - x396 * x6)
            + x54 * (x391 - x392 + x395)
            - x6 * (x396 * x5 + x397 - x6 * (x394 * x5 - x398 * x6)),
            x3 * (x400 * x5 - x402 * x6) + x401 - x6 * (x402 * x5 - x403 * x6),
            x3 * (x405 * x5 - x407 * x6) + x406 - x6 * (x407 * x5 - x408 * x6),
            x3 * x409 - x410 * x6,
            x3 * x411 - x412 * x6,
            x3 * x413 - x414 * x6,
            x3 * (x418 + x420 * x5 - x426 * x6)
            + x54 * (x420 - x421 + x425)
            - x6 * (x426 * x5 + x427 - x6 * (x424 * x5 - x428 * x6)),
            x3 * (x432 * x5 - x435 * x6) + x433 - x6 * (x435 * x5 - x437 * x6),
            x3 * (x440 * x5 - x442 * x6) + x441 - x6 * (x442 * x5 - x443 * x6),
            x3 * x445 - x447 * x6,
            x3 * x449 - x451 * x6,
            x3 * x453 - x455 * x6,
            x4 * (x456 - x457 - x458 + x459)
            + x5 * (x459 * x5 - x460 * x6)
            - x6 * (x460 * x5 - x6 * (x198 * x362 + 2.0 * x222 - x366 * x8)),
            x5 * (x198 * x369 + x356 - x371 * x8 + x379)
            - x6 * (x198 * x371 + x365 - x372 * x8 + x381),
            x5 * (x198 * x375 + 2.0 * x246 - x377 * x8)
            - x6 * (x198 * x377 + 2.0 * x248 - x378 * x8),
            x198 * x380 + 2.0 * x254 + 2.0 * x370 - x382 * x8,
            x198 * x383 + 2.0 * x260 + x376 - x384 * x8,
            x198 * x385 + 2.0 * x266 - x386 * x8,
            x4 * (x290 + x461 - x462 + x463)
            + x5 * (x463 * x5 - x464 * x6)
            - x6 * (x464 * x5 - x6 * (x198 * x394 + x293 - x398 * x8)),
            x5 * (x198 * x400 + x309 + x389 - x402 * x8)
            - x6 * (x198 * x402 + x311 + x397 - x403 * x8),
            x5 * (x198 * x405 + x323 - x407 * x8) - x6 * (x198 * x407 + x325 - x408 * x8),
            x198 * x409 + x332 + 2.0 * x401 - x410 * x8,
            x198 * x411 + x341 + x406 - x412 * x8,
            x198 * x413 + x350 - x414 * x8,
            x4 * (x429 - x465 + x466)
            + x5 * (x466 * x5 - x467 * x6)
            - x6 * (x467 * x5 - x6 * (x198 * x424 + x436)),
            x5 * (x198 * x432 + x444) - x6 * (x198 * x435 + x446),
            x5 * (x198 * x440 + x448) - x6 * (x198 * x442 + x450),
            x198 * x445 + 2.0 * x433 - x447 * x8,
            x198 * x449 + x441 - x451 * x8,
            x198 * x453 - x455 * x8,
            x472 + x5 * (x471 * x5 - x473 * x6) - x6 * (x473 * x5 - x474 * x6),
            x475 * x5 - x476 * x6,
            x477 * x5 - x478 * x6,
            x472 + x475 * x62 - x476 * x8,
            x477 * x62 - x478 * x8,
            -x10 * x455 + x269 * x453 + 2.0 * x350 + 2.0 * x441,
        ]
    )


def coulomb3d_33(a, A, b, B, C):
    """Cartesian (ff) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - B[0]
    x6 = -x2 - C[0]
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 * (x10**2 + x6**2 + x8**2)
    x12 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x13 = x12 * boys(2, x11)
    x14 = x13 * x6
    x15 = x12 * boys(1, x11)
    x16 = x15 * x5
    x17 = -x14 + x16
    x18 = x17 * x5
    x19 = x4 * (-x13 + x15)
    x20 = x12 * boys(3, x11)
    x21 = x20 * x6
    x22 = x13 * x5
    x23 = -x21 + x22
    x24 = x23 * x6
    x25 = x19 - x24
    x26 = x18 + x25
    x27 = x26 * x5
    x28 = x12 * boys(0, x11)
    x29 = -x15 * x6 + x28 * x5
    x30 = x4 * (-x15 + x28)
    x31 = -x17 * x6 + x30
    x32 = x29 * x5 + x31
    x33 = 2.0 * x4
    x34 = -x26 * x6 + x33 * (x14 - x16 + x29)
    x35 = x32 * x5 + x34
    x36 = x4 * (x13 - x20)
    x37 = x23 * x5
    x38 = x12 * boys(4, x11)
    x39 = x38 * x6
    x40 = x20 * x5
    x41 = -x39 + x40
    x42 = x41 * x6
    x43 = x36 + x37 - x42
    x44 = x43 * x6
    x45 = x33 * (x17 + x21 - x22)
    x46 = x44 - x45
    x47 = -x44 + x45
    x48 = x27 + x47
    x49 = -x19
    x50 = x24 + x49
    x51 = x4 * (-x18 + x32 + x50)
    x52 = x3 * x35 - x48 * x6 + 3.0 * x51
    x53 = x3 * x48
    x54 = x43 * x5
    x55 = x4 * (x20 - x38)
    x56 = x41 * x5
    x57 = x12 * boys(5, x11)
    x58 = x57 * x6
    x59 = x38 * x5
    x60 = -x58 + x59
    x61 = x6 * x60
    x62 = x55 + x56 - x61
    x63 = x6 * x62
    x64 = x33 * (x23 + x39 - x40)
    x65 = -x63 + x64
    x66 = x54 + x65
    x67 = x6 * x66
    x68 = -x36
    x69 = x42 + x68
    x70 = x4 * (x26 - x37 + x69)
    x71 = 3.0 * x70
    x72 = x53 - x67 + x71
    x73 = x26 * x3
    x74 = x3 * x32 + x34
    x75 = 3.0 * x4
    x76 = x63 - x64
    x77 = x4 * (x38 - x57)
    x78 = x12 * boys(6, x11)
    x79 = -x55
    x80 = x3 * x43
    x81 = x47 + x73
    x82 = x17 * x3
    x83 = x13 * x8
    x84 = -x83
    x85 = -x7 - B[1]
    x86 = x15 * x85
    x87 = x84 + x86
    x88 = x5 * x87
    x89 = x20 * x8
    x90 = -x89
    x91 = x13 * x85
    x92 = x90 + x91
    x93 = x6 * x92
    x94 = -x93
    x95 = x88 + x94
    x96 = x5 * x95
    x97 = -x15 * x8
    x98 = x28 * x85 + x97
    x99 = -x6 * x87
    x100 = x5 * x98 + x99
    x101 = x4 * (x83 - x86 + x98)
    x102 = x101 - x6 * x95
    x103 = x100 * x5 + x102
    x104 = x5 * x92
    x105 = x38 * x8
    x106 = -x105
    x107 = x20 * x85
    x108 = x106 + x107
    x109 = x108 * x6
    x110 = x104 - x109
    x111 = x110 * x6
    x112 = x4 * (x87 + x89 - x91)
    x113 = -x112
    x114 = x111 + x113
    x115 = -x111 + x112
    x116 = x115 + x96
    x117 = x4 * (x100 - x88 + x93)
    x118 = x103 * x3 - x116 * x6 + 2.0 * x117
    x119 = x116 * x3
    x120 = x110 * x5
    x121 = x4 * (x105 - x107 + x92)
    x122 = x108 * x5
    x123 = x57 * x8
    x124 = -x123
    x125 = x38 * x85
    x126 = x124 + x125
    x127 = x126 * x6
    x128 = x122 - x127
    x129 = x128 * x6
    x130 = x121 - x129
    x131 = x120 + x130
    x132 = x131 * x6
    x133 = x4 * (-x104 + x109 + x95)
    x134 = 2.0 * x133
    x135 = x119 - x132 + x134
    x136 = x3 * x95
    x137 = x100 * x3 + x102
    x138 = -x121
    x139 = x129 + x138
    x140 = x4 * (x108 + x123 - x125)
    x141 = -x78 * x8
    x142 = x141 + x57 * x85
    x143 = x110 * x3
    x144 = x115 + x136
    x145 = x3 * x87
    x146 = x10 * x13
    x147 = -x146
    x148 = -x9 - B[2]
    x149 = x148 * x15
    x150 = x147 + x149
    x151 = x150 * x5
    x152 = x10 * x20
    x153 = -x152
    x154 = x13 * x148
    x155 = x153 + x154
    x156 = x155 * x6
    x157 = -x156
    x158 = x151 + x157
    x159 = x158 * x5
    x160 = -x10 * x15
    x161 = x148 * x28 + x160
    x162 = -x150 * x6
    x163 = x161 * x5 + x162
    x164 = x4 * (x146 - x149 + x161)
    x165 = -x158 * x6 + x164
    x166 = x163 * x5 + x165
    x167 = x155 * x5
    x168 = x10 * x38
    x169 = -x168
    x170 = x148 * x20
    x171 = x169 + x170
    x172 = x171 * x6
    x173 = x167 - x172
    x174 = x173 * x6
    x175 = x4 * (x150 + x152 - x154)
    x176 = -x175
    x177 = x174 + x176
    x178 = -x174 + x175
    x179 = x159 + x178
    x180 = x4 * (-x151 + x156 + x163)
    x181 = x166 * x3 - x179 * x6 + 2.0 * x180
    x182 = x179 * x3
    x183 = x173 * x5
    x184 = x4 * (x155 + x168 - x170)
    x185 = x171 * x5
    x186 = x10 * x57
    x187 = -x186
    x188 = x148 * x38
    x189 = x187 + x188
    x190 = x189 * x6
    x191 = x185 - x190
    x192 = x191 * x6
    x193 = x184 - x192
    x194 = x183 + x193
    x195 = x194 * x6
    x196 = x4 * (x158 - x167 + x172)
    x197 = 2.0 * x196
    x198 = x182 - x195 + x197
    x199 = x158 * x3
    x200 = x163 * x3 + x165
    x201 = -x184
    x202 = x192 + x201
    x203 = x4 * (x171 + x186 - x188)
    x204 = -x10 * x78
    x205 = x148 * x57 + x204
    x206 = x173 * x3
    x207 = x178 + x199
    x208 = x150 * x3
    x209 = x85 * x87
    x210 = x30 - x8 * x87
    x211 = x210 + x85 * x98
    x212 = x8 * x92
    x213 = x212 + x49
    x214 = x4 * (-x209 + x211 + x213)
    x215 = x19 - x212
    x216 = x209 + x215
    x217 = -x216 * x6
    x218 = x211 * x3 + x217
    x219 = x85 * x92
    x220 = x108 * x8
    x221 = -x220 + x36
    x222 = x219 + x221
    x223 = x222 * x3
    x224 = x108 * x85
    x225 = x126 * x8
    x226 = -x225 + x55
    x227 = x224 + x226
    x228 = x227 * x6
    x229 = -x228
    x230 = x220 + x68
    x231 = x4 * (x216 - x219 + x230)
    x232 = -x231
    x233 = x216 * x3
    x234 = x222 * x6
    x235 = -x234
    x236 = x233 + x235
    x237 = x216 * x5
    x238 = x211 * x5 + x217
    x239 = x235 + x237
    x240 = x214 + x238 * x3 - x239 * x6
    x241 = x239 * x3
    x242 = x222 * x5
    x243 = x229 + x242
    x244 = x243 * x6
    x245 = x231 + x241 - x244
    x246 = x225 + x79
    x247 = x4 * (x222 - x224 + x246)
    x248 = -x142 * x8 + x77
    x249 = x126 * x85 + x248
    x250 = x155 * x8
    x251 = x150 * x85
    x252 = -x150 * x8
    x253 = x161 * x85 + x252
    x254 = x4 * (x250 - x251 + x253)
    x255 = -x250
    x256 = x251 + x255
    x257 = -x256 * x6
    x258 = x253 * x3 + x257
    x259 = x155 * x85
    x260 = x171 * x8
    x261 = -x260
    x262 = x259 + x261
    x263 = x262 * x3
    x264 = x171 * x85
    x265 = x189 * x8
    x266 = -x265
    x267 = x264 + x266
    x268 = x267 * x6
    x269 = -x268
    x270 = x4 * (x256 - x259 + x260)
    x271 = -x270
    x272 = x256 * x3
    x273 = x262 * x6
    x274 = -x273
    x275 = x272 + x274
    x276 = x256 * x5
    x277 = x253 * x5 + x257
    x278 = x274 + x276
    x279 = x254 + x277 * x3 - x278 * x6
    x280 = x278 * x3
    x281 = x262 * x5
    x282 = x269 + x281
    x283 = x282 * x6
    x284 = x270 + x280 - x283
    x285 = x4 * (x262 - x264 + x265)
    x286 = -x205 * x8
    x287 = x189 * x85 + x286
    x288 = x148 * x150
    x289 = -x10 * x150 + x30
    x290 = x148 * x161 + x289
    x291 = x10 * x155
    x292 = x291 + x49
    x293 = x4 * (-x288 + x290 + x292)
    x294 = x19 - x291
    x295 = x288 + x294
    x296 = -x295 * x6
    x297 = x290 * x3 + x296
    x298 = x148 * x155
    x299 = x10 * x171
    x300 = -x299 + x36
    x301 = x298 + x300
    x302 = x3 * x301
    x303 = x148 * x171
    x304 = x10 * x189
    x305 = -x304 + x55
    x306 = x303 + x305
    x307 = x306 * x6
    x308 = -x307
    x309 = x299 + x68
    x310 = x4 * (x295 - x298 + x309)
    x311 = -x310
    x312 = x295 * x3
    x313 = x301 * x6
    x314 = -x313
    x315 = x312 + x314
    x316 = x295 * x5
    x317 = x290 * x5 + x296
    x318 = x314 + x316
    x319 = x293 + x3 * x317 - x318 * x6
    x320 = x3 * x318
    x321 = x301 * x5
    x322 = x308 + x321
    x323 = x322 * x6
    x324 = x310 + x320 - x323
    x325 = x304 + x79
    x326 = x4 * (x301 - x303 + x325)
    x327 = -x10 * x205 + x77
    x328 = x148 * x189 + x327
    x329 = x216 * x85
    x330 = 2.0 * x101 - x216 * x8
    x331 = x211 * x85 + x330
    x332 = x222 * x8
    x333 = 2.0 * x112
    x334 = x332 - x333
    x335 = x4 * (-x329 + x331 + x334)
    x336 = -x332 + x333
    x337 = x329 + x336
    x338 = x3 * x331 - x337 * x6
    x339 = x3 * x337
    x340 = x222 * x85
    x341 = x227 * x8
    x342 = 2.0 * x121
    x343 = -x341 + x342
    x344 = x340 + x343
    x345 = x344 * x6
    x346 = x339 - x345
    x347 = x341 - x342
    x348 = x4 * (x337 - x340 + x347)
    x349 = 2.0 * x140 - x249 * x8
    x350 = x227 * x85 + x349
    x351 = x256 * x85
    x352 = x164 - x256 * x8
    x353 = x253 * x85 + x352
    x354 = x262 * x8
    x355 = x176 + x354
    x356 = x4 * (-x351 + x353 + x355)
    x357 = x175 - x354
    x358 = x351 + x357
    x359 = x3 * x353 - x358 * x6
    x360 = x3 * x358
    x361 = x262 * x85
    x362 = x267 * x8
    x363 = x184 - x362
    x364 = x361 + x363
    x365 = x364 * x6
    x366 = x360 - x365
    x367 = x201 + x362
    x368 = x4 * (x358 - x361 + x367)
    x369 = x203 - x287 * x8
    x370 = x267 * x85 + x369
    x371 = x301 * x8
    x372 = x295 * x85
    x373 = -x295 * x8
    x374 = x290 * x85 + x373
    x375 = x4 * (x371 - x372 + x374)
    x376 = -x371
    x377 = x372 + x376
    x378 = x3 * x374 - x377 * x6
    x379 = x3 * x377
    x380 = x301 * x85
    x381 = x306 * x8
    x382 = -x381
    x383 = x380 + x382
    x384 = x383 * x6
    x385 = x379 - x384
    x386 = x4 * (x377 - x380 + x381)
    x387 = -x328 * x8
    x388 = x306 * x85 + x387
    x389 = x148 * x295
    x390 = -x10 * x295 + 2.0 * x164
    x391 = x148 * x290 + x390
    x392 = x10 * x301
    x393 = 2.0 * x175
    x394 = x392 - x393
    x395 = x4 * (-x389 + x391 + x394)
    x396 = -x392 + x393
    x397 = x389 + x396
    x398 = x3 * x391 - x397 * x6
    x399 = x3 * x397
    x400 = x148 * x301
    x401 = x10 * x306
    x402 = 2.0 * x184
    x403 = -x401 + x402
    x404 = x400 + x403
    x405 = x404 * x6
    x406 = x399 - x405
    x407 = x401 - x402
    x408 = x4 * (x397 - x400 + x407)
    x409 = -x10 * x328 + 2.0 * x203
    x410 = x148 * x306 + x409
    x411 = -x7 - A[1]
    x412 = x13 * x411
    x413 = x15 * x411
    x414 = x413 + x84
    x415 = x4 * (-x412 + x414 + x89)
    x416 = x414 * x5
    x417 = x412 + x90
    x418 = x417 * x6
    x419 = x416 - x418
    x420 = x419 * x5
    x421 = x417 * x5
    x422 = x20 * x411
    x423 = x106 + x422
    x424 = x423 * x6
    x425 = x421 - x424
    x426 = x425 * x6
    x427 = x415 + x420 - x426
    x428 = x427 * x5
    x429 = x28 * x411 + x97
    x430 = x4 * (-x413 + x429 + x83)
    x431 = -x414 * x6 + x429 * x5
    x432 = -x419 * x6 + x430 + x431 * x5
    x433 = x33 * (-x416 + x418 + x431) - x427 * x6
    x434 = x432 * x5 + x433
    x435 = x4 * (x105 + x417 - x422)
    x436 = x425 * x5
    x437 = x423 * x5
    x438 = x38 * x411
    x439 = x124 + x438
    x440 = x439 * x6
    x441 = x437 - x440
    x442 = x441 * x6
    x443 = x435 + x436 - x442
    x444 = x443 * x6
    x445 = x33 * (x419 - x421 + x424)
    x446 = x444 - x445
    x447 = x428 - x444 + x445
    x448 = -x415
    x449 = x4 * (x123 + x423 - x438)
    x450 = x141 + x411 * x57
    x451 = -x435
    x452 = x411 * x87
    x453 = x215 + x452
    x454 = x453 * x5
    x455 = x411 * x92
    x456 = x221 + x455
    x457 = x456 * x6
    x458 = x454 - x457
    x459 = x458 * x5
    x460 = x210 + x411 * x98
    x461 = -x453 * x6 + x460 * x5
    x462 = x4 * (x213 - x452 + x460)
    x463 = -x458 * x6 + x462
    x464 = x461 * x5 + x463
    x465 = x456 * x5
    x466 = x108 * x411
    x467 = x226 + x466
    x468 = x467 * x6
    x469 = x465 - x468
    x470 = x469 * x6
    x471 = x4 * (x230 + x453 - x455)
    x472 = x470 - x471
    x473 = x459 - x470 + x471
    x474 = x4 * (x246 + x456 - x466)
    x475 = x126 * x411 + x248
    x476 = x150 * x411
    x477 = x255 + x476
    x478 = x477 * x5
    x479 = x155 * x411
    x480 = x261 + x479
    x481 = x480 * x6
    x482 = x478 - x481
    x483 = x482 * x5
    x484 = x161 * x411 + x252
    x485 = -x477 * x6 + x484 * x5
    x486 = x4 * (x250 - x476 + x484)
    x487 = -x482 * x6 + x486
    x488 = x485 * x5 + x487
    x489 = x480 * x5
    x490 = x171 * x411
    x491 = x266 + x490
    x492 = x491 * x6
    x493 = x489 - x492
    x494 = x493 * x6
    x495 = x4 * (x260 + x477 - x479)
    x496 = -x495
    x497 = x494 + x496
    x498 = x483 - x494 + x495
    x499 = x4 * (x265 + x480 - x490)
    x500 = x189 * x411 + x286
    x501 = x211 * x411 + x330
    x502 = x222 * x411
    x503 = x343 + x502
    x504 = x503 * x6
    x505 = x216 * x411
    x506 = x336 + x505
    x507 = -x506 * x6
    x508 = x5 * x506
    x509 = x5 * x501 + x507
    x510 = x4 * (x334 + x501 - x505)
    x511 = -x504 + x508
    x512 = x4 * (x347 - x502 + x506)
    x513 = x227 * x411 + x349
    x514 = x253 * x411 + x352
    x515 = x262 * x411
    x516 = x363 + x515
    x517 = x516 * x6
    x518 = x256 * x411
    x519 = x357 + x518
    x520 = -x519 * x6
    x521 = x5 * x519
    x522 = x5 * x514 + x520
    x523 = x4 * (x355 + x514 - x518)
    x524 = -x517 + x521
    x525 = x4 * (x367 - x515 + x519)
    x526 = x267 * x411 + x369
    x527 = x290 * x411 + x373
    x528 = x301 * x411
    x529 = x382 + x528
    x530 = x529 * x6
    x531 = x295 * x411
    x532 = x376 + x531
    x533 = -x532 * x6
    x534 = x5 * x532
    x535 = x5 * x527 + x533
    x536 = x4 * (x371 + x527 - x531)
    x537 = -x530 + x534
    x538 = x4 * (x381 - x528 + x532)
    x539 = x306 * x411 + x387
    x540 = x344 * x8
    x541 = x337 * x411
    x542 = 3.0 * x231
    x543 = 3.0 * x214 + x331 * x411 - x337 * x8
    x544 = x4 * (x540 - x541 - x542 + x543)
    x545 = -x540 + x541 + x542
    x546 = 3.0 * x247 + x344 * x411 - x350 * x8
    x547 = x364 * x8
    x548 = x358 * x411
    x549 = 2.0 * x270
    x550 = 2.0 * x254 + x353 * x411 - x358 * x8
    x551 = x4 * (x547 - x548 - x549 + x550)
    x552 = -x547 + x548 + x549
    x553 = 2.0 * x285 + x364 * x411 - x370 * x8
    x554 = x383 * x8
    x555 = x377 * x411
    x556 = x293 + x374 * x411 - x377 * x8
    x557 = x4 * (x311 + x554 - x555 + x556)
    x558 = x310 - x554 + x555
    x559 = x326 + x383 * x411 - x388 * x8
    x560 = x404 * x8
    x561 = x397 * x411
    x562 = x391 * x411 - x397 * x8
    x563 = x4 * (x560 - x561 + x562)
    x564 = -x560 + x561
    x565 = x404 * x411 - x410 * x8
    x566 = -x9 - A[2]
    x567 = x13 * x566
    x568 = x15 * x566
    x569 = x147 + x568
    x570 = x4 * (x152 - x567 + x569)
    x571 = x5 * x569
    x572 = x153 + x567
    x573 = x572 * x6
    x574 = x571 - x573
    x575 = x5 * x574
    x576 = x5 * x572
    x577 = x20 * x566
    x578 = x169 + x577
    x579 = x578 * x6
    x580 = x576 - x579
    x581 = x580 * x6
    x582 = x570 + x575 - x581
    x583 = x5 * x582
    x584 = x160 + x28 * x566
    x585 = x4 * (x146 - x568 + x584)
    x586 = x5 * x584 - x569 * x6
    x587 = x5 * x586 - x574 * x6 + x585
    x588 = x33 * (-x571 + x573 + x586) - x582 * x6
    x589 = x5 * x587 + x588
    x590 = x4 * (x168 + x572 - x577)
    x591 = x5 * x580
    x592 = x5 * x578
    x593 = x38 * x566
    x594 = x187 + x593
    x595 = x594 * x6
    x596 = x592 - x595
    x597 = x596 * x6
    x598 = x590 + x591 - x597
    x599 = x598 * x6
    x600 = x33 * (x574 - x576 + x579)
    x601 = x599 - x600
    x602 = x583 - x599 + x600
    x603 = -x570
    x604 = x4 * (x186 + x578 - x593)
    x605 = x204 + x566 * x57
    x606 = -x590
    x607 = x569 * x85
    x608 = x572 * x8
    x609 = -x608
    x610 = x607 + x609
    x611 = x5 * x610
    x612 = x572 * x85
    x613 = x578 * x8
    x614 = -x613
    x615 = x612 + x614
    x616 = x6 * x615
    x617 = x611 - x616
    x618 = x5 * x617
    x619 = -x569 * x8
    x620 = x584 * x85 + x619
    x621 = x5 * x620 - x6 * x610
    x622 = x4 * (-x607 + x608 + x620)
    x623 = -x6 * x617 + x622
    x624 = x5 * x621 + x623
    x625 = x5 * x615
    x626 = x578 * x85
    x627 = x594 * x8
    x628 = -x627
    x629 = x626 + x628
    x630 = x6 * x629
    x631 = x625 - x630
    x632 = x6 * x631
    x633 = x4 * (x610 - x612 + x613)
    x634 = -x633
    x635 = x632 + x634
    x636 = x618 - x632 + x633
    x637 = x4 * (x615 - x626 + x627)
    x638 = -x605 * x8
    x639 = x594 * x85 + x638
    x640 = x150 * x566
    x641 = x294 + x640
    x642 = x5 * x641
    x643 = x155 * x566
    x644 = x300 + x643
    x645 = x6 * x644
    x646 = x642 - x645
    x647 = x5 * x646
    x648 = x161 * x566 + x289
    x649 = x5 * x648 - x6 * x641
    x650 = x4 * (x292 - x640 + x648)
    x651 = -x6 * x646 + x650
    x652 = x5 * x649 + x651
    x653 = x5 * x644
    x654 = x171 * x566
    x655 = x305 + x654
    x656 = x6 * x655
    x657 = x653 - x656
    x658 = x6 * x657
    x659 = x4 * (x309 + x641 - x643)
    x660 = -x659
    x661 = x658 + x660
    x662 = x647 - x658 + x659
    x663 = x4 * (x325 + x644 - x654)
    x664 = x189 * x566 + x327
    x665 = x585 - x610 * x8
    x666 = x620 * x85 + x665
    x667 = x615 * x85
    x668 = x629 * x8
    x669 = x590 - x668
    x670 = x667 + x669
    x671 = x6 * x670
    x672 = x610 * x85
    x673 = x615 * x8
    x674 = x570 - x673
    x675 = x672 + x674
    x676 = -x6 * x675
    x677 = x5 * x675
    x678 = x5 * x666 + x676
    x679 = x603 + x673
    x680 = x4 * (x666 - x672 + x679)
    x681 = -x671 + x677
    x682 = x606 + x668
    x683 = x4 * (-x667 + x675 + x682)
    x684 = x604 - x639 * x8
    x685 = x629 * x85 + x684
    x686 = -x641 * x8
    x687 = x648 * x85 + x686
    x688 = x644 * x85
    x689 = x655 * x8
    x690 = -x689
    x691 = x688 + x690
    x692 = x6 * x691
    x693 = x641 * x85
    x694 = x644 * x8
    x695 = -x694
    x696 = x693 + x695
    x697 = -x6 * x696
    x698 = x5 * x696
    x699 = x5 * x687 + x697
    x700 = x4 * (x687 - x693 + x694)
    x701 = -x692 + x698
    x702 = x4 * (-x688 + x689 + x696)
    x703 = -x664 * x8
    x704 = x655 * x85 + x703
    x705 = x290 * x566 + x390
    x706 = x301 * x566
    x707 = x403 + x706
    x708 = x6 * x707
    x709 = x295 * x566
    x710 = x396 + x709
    x711 = -x6 * x710
    x712 = x5 * x710
    x713 = x5 * x705 + x711
    x714 = x4 * (x394 + x705 - x709)
    x715 = -x708 + x712
    x716 = x4 * (x407 - x706 + x710)
    x717 = x306 * x566 + x409
    x718 = x675 * x85
    x719 = 2.0 * x622 - x675 * x8
    x720 = x666 * x85 + x719
    x721 = x670 * x8
    x722 = 2.0 * x633
    x723 = x721 - x722
    x724 = x4 * (-x718 + x720 + x723)
    x725 = -x721 + x722
    x726 = x718 + x725
    x727 = 2.0 * x637 - x685 * x8
    x728 = x670 * x85 + x727
    x729 = x696 * x85
    x730 = x650 - x696 * x8
    x731 = x687 * x85 + x730
    x732 = x691 * x8
    x733 = x660 + x732
    x734 = x4 * (-x729 + x731 + x733)
    x735 = x659 - x732
    x736 = x729 + x735
    x737 = x663 - x704 * x8
    x738 = x691 * x85 + x737
    x739 = x707 * x8
    x740 = x710 * x85
    x741 = -x710 * x8
    x742 = x705 * x85 + x741
    x743 = x4 * (x739 - x740 + x742)
    x744 = -x739
    x745 = x740 + x744
    x746 = -x717 * x8
    x747 = x707 * x85 + x746
    x748 = x10 * x404
    x749 = x397 * x566
    x750 = 3.0 * x310
    x751 = -x10 * x397 + 3.0 * x293 + x391 * x566
    x752 = x4 * (x748 - x749 - x750 + x751)
    x753 = -x748 + x749 + x750
    x754 = -x10 * x410 + 3.0 * x326 + x404 * x566
    x755 = x417 * x8
    x756 = x411 * x414
    x757 = x30 + x411 * x429 - x414 * x8
    x758 = x4 * (x49 + x755 - x756 + x757)
    x759 = x19 - x755 + x756
    x760 = x5 * x757 - x6 * x759
    x761 = x5 * x759
    x762 = x411 * x417
    x763 = x423 * x8
    x764 = x36 + x762 - x763
    x765 = x6 * x764
    x766 = x761 - x765
    x767 = x5 * x760 - x6 * x766 + x758
    x768 = x4 * (x68 + x759 - x762 + x763)
    x769 = x5 * x766
    x770 = x5 * x764
    x771 = x411 * x423
    x772 = x439 * x8
    x773 = x55 + x771 - x772
    x774 = x6 * x773
    x775 = x770 - x774
    x776 = x6 * x775
    x777 = x768 + x769 - x776
    x778 = x4 * (x764 - x771 + x772 + x79)
    x779 = x411 * x439 - x450 * x8 + x77
    x780 = -x768
    x781 = x456 * x8
    x782 = x411 * x453
    x783 = x101 + x411 * x460 + x430 - x453 * x8
    x784 = x4 * (x113 + x448 + x781 - x782 + x783)
    x785 = x112 + x415 - x781 + x782
    x786 = x5 * x783 - x6 * x785
    x787 = x5 * x785
    x788 = x411 * x456
    x789 = x467 * x8
    x790 = x121 + x435 + x788 - x789
    x791 = x6 * x790
    x792 = x787 - x791
    x793 = x4 * (x138 + x451 + x785 - x788 + x789)
    x794 = x140 + x411 * x467 + x449 - x475 * x8
    x795 = x480 * x8
    x796 = x411 * x477
    x797 = x164 + x411 * x484 - x477 * x8
    x798 = x4 * (x176 + x795 - x796 + x797)
    x799 = x175 - x795 + x796
    x800 = x5 * x797 - x6 * x799
    x801 = x5 * x799
    x802 = x411 * x480
    x803 = x491 * x8
    x804 = x184 + x802 - x803
    x805 = x6 * x804
    x806 = x801 - x805
    x807 = x4 * (x201 + x799 - x802 + x803)
    x808 = x203 + x411 * x491 - x500 * x8
    x809 = x503 * x8
    x810 = x411 * x506
    x811 = 2.0 * x471
    x812 = -x811
    x813 = 2.0 * x462
    x814 = x214 + x411 * x501 - x506 * x8 + x813
    x815 = x4 * (x232 + x809 - x810 + x812 + x814)
    x816 = x231 - x809 + x810 + x811
    x817 = 2.0 * x474
    x818 = x247 + x411 * x503 - x513 * x8 + x817
    x819 = x516 * x8
    x820 = x411 * x519
    x821 = x254 + x411 * x514 + x486 - x519 * x8
    x822 = x4 * (x271 + x496 + x819 - x820 + x821)
    x823 = x270 + x495 - x819 + x820
    x824 = x285 + x411 * x516 + x499 - x526 * x8
    x825 = x529 * x8
    x826 = x411 * x532
    x827 = x293 + x411 * x527 - x532 * x8
    x828 = x4 * (x311 + x825 - x826 + x827)
    x829 = x310 - x825 + x826
    x830 = x326 + x411 * x529 - x539 * x8
    x831 = x335 + x411 * x543 + 3.0 * x510 - x545 * x8
    x832 = x348 + x411 * x545 + 3.0 * x512 - x546 * x8
    x833 = 2.0 * x523
    x834 = x356 + x411 * x550 - x552 * x8 + x833
    x835 = 2.0 * x525
    x836 = x368 + x411 * x552 - x553 * x8 + x835
    x837 = x375 + x411 * x556 + x536 - x558 * x8
    x838 = x386 + x411 * x558 + x538 - x559 * x8
    x839 = x395 + x411 * x562 - x564 * x8
    x840 = x408 + x411 * x564 - x565 * x8
    x841 = x411 * x569
    x842 = x411 * x584 + x619
    x843 = x4 * (x608 - x841 + x842)
    x844 = x609 + x841
    x845 = x5 * x842 - x6 * x844
    x846 = x5 * x844
    x847 = x411 * x572
    x848 = x614 + x847
    x849 = x6 * x848
    x850 = x846 - x849
    x851 = x5 * x845 - x6 * x850 + x843
    x852 = x4 * (x613 + x844 - x847)
    x853 = x5 * x850
    x854 = x5 * x848
    x855 = x411 * x578
    x856 = x628 + x855
    x857 = x6 * x856
    x858 = x854 - x857
    x859 = x6 * x858
    x860 = x852 + x853 - x859
    x861 = x4 * (x627 + x848 - x855)
    x862 = x411 * x594 + x638
    x863 = -x852
    x864 = x411 * x610
    x865 = x411 * x620 + x665
    x866 = x4 * (x679 - x864 + x865)
    x867 = x674 + x864
    x868 = x5 * x865 - x6 * x867
    x869 = x5 * x867
    x870 = x411 * x615
    x871 = x669 + x870
    x872 = x6 * x871
    x873 = x869 - x872
    x874 = x4 * (x682 + x867 - x870)
    x875 = x411 * x629 + x684
    x876 = x411 * x641
    x877 = x411 * x648 + x686
    x878 = x4 * (x694 - x876 + x877)
    x879 = x695 + x876
    x880 = x5 * x877 - x6 * x879
    x881 = x5 * x879
    x882 = x411 * x644
    x883 = x690 + x882
    x884 = x6 * x883
    x885 = x881 - x884
    x886 = x4 * (x689 + x879 - x882)
    x887 = x411 * x655 + x703
    x888 = x411 * x675
    x889 = x411 * x666 + x719
    x890 = x4 * (x723 - x888 + x889)
    x891 = x725 + x888
    x892 = x411 * x670 + x727
    x893 = x411 * x696
    x894 = x411 * x687 + x730
    x895 = x4 * (x733 - x893 + x894)
    x896 = x735 + x893
    x897 = x411 * x691 + x737
    x898 = x411 * x710
    x899 = x411 * x705 + x741
    x900 = x4 * (x739 - x898 + x899)
    x901 = x744 + x898
    x902 = x411 * x707 + x746
    x903 = x411 * x720 + 3.0 * x680 - x726 * x8
    x904 = x411 * x726 + 3.0 * x683 - x728 * x8
    x905 = x411 * x731 + 2.0 * x700 - x736 * x8
    x906 = x411 * x736 + 2.0 * x702 - x738 * x8
    x907 = x411 * x742 + x714 - x745 * x8
    x908 = x411 * x745 + x716 - x747 * x8
    x909 = x411 * x751 - x753 * x8
    x910 = x411 * x753 - x754 * x8
    x911 = x10 * x572
    x912 = x566 * x569
    x913 = -x10 * x569 + x30 + x566 * x584
    x914 = x4 * (x49 + x911 - x912 + x913)
    x915 = x19 - x911 + x912
    x916 = x5 * x913 - x6 * x915
    x917 = x5 * x915
    x918 = x566 * x572
    x919 = x10 * x578
    x920 = x36 + x918 - x919
    x921 = x6 * x920
    x922 = x917 - x921
    x923 = x5 * x916 - x6 * x922 + x914
    x924 = x4 * (x68 + x915 - x918 + x919)
    x925 = x5 * x922
    x926 = x5 * x920
    x927 = x566 * x578
    x928 = x10 * x594
    x929 = x55 + x927 - x928
    x930 = x6 * x929
    x931 = x926 - x930
    x932 = x6 * x931
    x933 = x924 + x925 - x932
    x934 = x4 * (x79 + x920 - x927 + x928)
    x935 = -x10 * x605 + x566 * x594 + x77
    x936 = -x924
    x937 = x8 * x920
    x938 = x85 * x915
    x939 = -x8 * x915
    x940 = x85 * x913 + x939
    x941 = x4 * (x937 - x938 + x940)
    x942 = -x937
    x943 = x938 + x942
    x944 = x5 * x940 - x6 * x943
    x945 = x5 * x943
    x946 = x85 * x920
    x947 = x8 * x929
    x948 = -x947
    x949 = x946 + x948
    x950 = x6 * x949
    x951 = x945 - x950
    x952 = x4 * (x943 - x946 + x947)
    x953 = -x8 * x935
    x954 = x85 * x929 + x953
    x955 = x10 * x644
    x956 = x566 * x641
    x957 = -x10 * x641 + x164 + x566 * x648 + x585
    x958 = x4 * (x176 + x603 + x955 - x956 + x957)
    x959 = x175 + x570 - x955 + x956
    x960 = x5 * x957 - x6 * x959
    x961 = x5 * x959
    x962 = x566 * x644
    x963 = x10 * x655
    x964 = x184 + x590 + x962 - x963
    x965 = x6 * x964
    x966 = x961 - x965
    x967 = x4 * (x201 + x606 + x959 - x962 + x963)
    x968 = -x10 * x664 + x203 + x566 * x655 + x604
    x969 = x85 * x943
    x970 = -x8 * x943 + x914
    x971 = x85 * x940 + x970
    x972 = x8 * x949
    x973 = x936 + x972
    x974 = x4 * (-x969 + x971 + x973)
    x975 = x924 - x972
    x976 = x969 + x975
    x977 = -x8 * x954 + x934
    x978 = x85 * x949 + x977
    x979 = x8 * x964
    x980 = x85 * x959
    x981 = -x8 * x959
    x982 = x85 * x957 + x981
    x983 = x4 * (x979 - x980 + x982)
    x984 = -x979
    x985 = x980 + x984
    x986 = -x8 * x968
    x987 = x85 * x964 + x986
    x988 = x10 * x707
    x989 = x566 * x710
    x990 = 2.0 * x659
    x991 = -x990
    x992 = 2.0 * x650
    x993 = -x10 * x710 + x293 + x566 * x705 + x992
    x994 = x4 * (x311 + x988 - x989 + x991 + x993)
    x995 = x310 - x988 + x989 + x990
    x996 = 2.0 * x663
    x997 = -x10 * x717 + x326 + x566 * x707 + x996
    x998 = -x8 * x976 + 2.0 * x941
    x999 = x85 * x971 + x998
    x1000 = -x8 * x978 + 2.0 * x952
    x1001 = x1000 + x85 * x976
    x1002 = -x8 * x985 + x958
    x1003 = x1002 + x85 * x982
    x1004 = -x8 * x987 + x967
    x1005 = x1004 + x85 * x985
    x1006 = -x8 * x995
    x1007 = x1006 + x85 * x993
    x1008 = -x8 * x997
    x1009 = x1008 + x85 * x995
    x1010 = -x10 * x753 + x395 + x566 * x751 + 3.0 * x714
    x1011 = -x10 * x754 + x408 + x566 * x753 + 3.0 * x716
    x1012 = x764 * x8
    x1013 = x411 * x759
    x1014 = 2.0 * x415
    x1015 = x411 * x757 + 2.0 * x430 - x759 * x8
    x1016 = -x1012 + x1013 + x1014
    x1017 = x1015 * x5 - x1016 * x6
    x1018 = x1016 * x5
    x1019 = x411 * x764
    x1020 = x773 * x8
    x1021 = 2.0 * x435
    x1022 = x1019 - x1020 + x1021
    x1023 = x1022 * x6
    x1024 = x1018 - x1023
    x1025 = x790 * x8
    x1026 = x411 * x785
    x1027 = x411 * x783 + x758 - x785 * x8 + x813
    x1028 = -x1025 + x1026 + x768 + x811
    x1029 = x8 * x804
    x1030 = x411 * x799
    x1031 = 2.0 * x495
    x1032 = x411 * x797 + 2.0 * x486 - x799 * x8
    x1033 = -x1029 + x1030 + x1031
    x1034 = x8 * x848
    x1035 = x411 * x844
    x1036 = x411 * x842 + x585 - x8 * x844
    x1037 = -x1034 + x1035 + x570
    x1038 = x1036 * x5 - x1037 * x6
    x1039 = x1037 * x5
    x1040 = x411 * x848
    x1041 = x8 * x856
    x1042 = x1040 - x1041 + x590
    x1043 = x1042 * x6
    x1044 = x1039 - x1043
    x1045 = x8 * x871
    x1046 = x411 * x867
    x1047 = x411 * x865 + x622 - x8 * x867 + x843
    x1048 = -x1045 + x1046 + x633 + x852
    x1049 = x8 * x883
    x1050 = x411 * x879
    x1051 = x411 * x877 + x650 - x8 * x879
    x1052 = -x1049 + x1050 + x659
    x1053 = x411 * x915
    x1054 = x411 * x913 + x939
    x1055 = x1053 + x942
    x1056 = x1054 * x5 - x1055 * x6
    x1057 = x1055 * x5
    x1058 = x411 * x920
    x1059 = x1058 + x948
    x1060 = x1059 * x6
    x1061 = x1057 - x1060
    x1062 = x411 * x943
    x1063 = x411 * x940 + x970
    x1064 = x1062 + x975
    x1065 = x411 * x959
    x1066 = x411 * x957 + x981
    x1067 = x1065 + x984
    x1068 = x10 * x920
    x1069 = x566 * x915
    x1070 = 2.0 * x570
    x1071 = -x10 * x915 + x566 * x913 + 2.0 * x585
    x1072 = x4 * (x1068 - x1069 - x1070 + x1071)
    x1073 = -x1068 + x1069 + x1070
    x1074 = x1071 * x5 - x1073 * x6
    x1075 = x1073 * x5
    x1076 = x566 * x920
    x1077 = x10 * x929
    x1078 = 2.0 * x590
    x1079 = x1076 - x1077 + x1078
    x1080 = x1079 * x6
    x1081 = x1075 - x1080
    x1082 = x4 * (x1073 - x1076 + x1077 - x1078)
    x1083 = -x10 * x935 + x566 * x929 + 2.0 * x604
    x1084 = x1079 * x8
    x1085 = x1073 * x85
    x1086 = x1071 * x85 - x1073 * x8
    x1087 = x4 * (x1084 - x1085 + x1086)
    x1088 = -x1084 + x1085
    x1089 = x1079 * x85 - x1083 * x8
    x1090 = x10 * x964
    x1091 = x566 * x959
    x1092 = -x10 * x959 + x566 * x957 + x914 + x992
    x1093 = x4 * (x1090 - x1091 + x1092 + x936 + x991)
    x1094 = -x1090 + x1091 + x924 + x990
    x1095 = -x10 * x968 + x566 * x964 + x934 + x996
    x1096 = x1072 + x1086 * x85 - x1088 * x8
    x1097 = x1082 + x1088 * x85 - x1089 * x8
    x1098 = x1092 * x85 - x1094 * x8
    x1099 = x1094 * x85 - x1095 * x8
    x1100 = -x10 * x995 + x566 * x993 + 2.0 * x714 + 2.0 * x958
    x1101 = -x10 * x997 + x566 * x995 + 2.0 * x716 + 2.0 * x967

    # 100 item(s)
    return numpy.array(
        [
            x3 * (x3 * x52 + x4 * (-x27 + x35 + x46) - x6 * x72 + x75 * (x46 - x73 + x74))
            + x33 * (x52 - x53 + x67 - x71)
            - x6
            * (
                x3 * x72
                + x4 * (x48 - x54 + x76)
                - x6
                * (
                    x3 * x66
                    - x6
                    * (
                        x33 * (x41 + x58 - x59)
                        + x5 * x62
                        - x6 * (x5 * x60 - x6 * (x5 * x57 - x6 * x78) + x77)
                    )
                    + x75 * (x43 - x56 + x61 + x79)
                )
                + x75 * (x76 - x80 + x81)
            )
            + x75
            * (
                x3 * x74
                - x3 * x81
                - x33 * (-x23 * x3 + x25 + x69 + x82)
                + x33 * (x29 * x3 + x31 + x50 - x82)
                + x51
                - x6 * x81
                + x6 * (x65 + x80)
                - x70
            ),
            x3
            * (
                x118 * x3
                - x135 * x6
                + x33 * (x114 - x136 + x137)
                + x4 * (x103 + x114 - x96)
            )
            + x33 * (x118 - x119 + x132 - x134)
            + x33
            * (
                x117
                - x133
                + x137 * x3
                - x144 * x3
                - x144 * x6
                - x4 * (x109 + x145 - x3 * x92 + x94)
                + x4 * (-x145 + x3 * x98 + x93 + x99)
                + x6 * (x130 + x143)
            )
            - x6
            * (
                x135 * x3
                + x33 * (x139 - x143 + x144)
                + x4 * (x116 - x120 + x139)
                - x6
                * (
                    x131 * x3
                    + x33 * (x110 - x122 + x127)
                    - x6 * (x128 * x5 + x140 - x6 * (x126 * x5 - x142 * x6))
                )
            ),
            x3
            * (
                x181 * x3
                - x198 * x6
                + x33 * (x177 - x199 + x200)
                + x4 * (-x159 + x166 + x177)
            )
            + x33 * (x181 - x182 + x195 - x197)
            + x33
            * (
                x180
                - x196
                + x200 * x3
                - x207 * x3
                - x207 * x6
                + x4 * (x156 + x161 * x3 + x162 - x208)
                - x4 * (-x155 * x3 + x157 + x172 + x208)
                + x6 * (x193 + x206)
            )
            - x6
            * (
                x198 * x3
                + x33 * (x202 - x206 + x207)
                + x4 * (x179 - x183 + x202)
                - x6
                * (
                    x194 * x3
                    + x33 * (x173 - x185 + x190)
                    - x6 * (x191 * x5 + x203 - x6 * (x189 * x5 - x205 * x6))
                )
            ),
            x3
            * (
                x240 * x3
                - x245 * x6
                + x4 * (x218 - x233 + x234)
                + x4 * (x234 - x237 + x238)
            )
            + x33 * (x232 + x240 - x241 + x244)
            + x4 * (x214 + x218 * x3 + x232 - x236 * x3 - x236 * x6 + x6 * (x223 + x229))
            - x6
            * (
                x245 * x3
                + x4 * (-x223 + x228 + x236)
                + x4 * (x228 + x239 - x242)
                - x6 * (x243 * x3 + x247 - x6 * (x227 * x5 - x249 * x6))
            ),
            x3
            * (
                x279 * x3
                - x284 * x6
                + x4 * (x258 - x272 + x273)
                + x4 * (x273 - x276 + x277)
            )
            + x33 * (x271 + x279 - x280 + x283)
            + x4 * (x254 + x258 * x3 + x271 - x275 * x3 - x275 * x6 + x6 * (x263 + x269))
            - x6
            * (
                x284 * x3
                + x4 * (-x263 + x268 + x275)
                + x4 * (x268 + x278 - x281)
                - x6 * (x282 * x3 + x285 - x6 * (x267 * x5 - x287 * x6))
            ),
            x3
            * (
                x3 * x319
                - x324 * x6
                + x4 * (x297 - x312 + x313)
                + x4 * (x313 - x316 + x317)
            )
            + x33 * (x311 + x319 - x320 + x323)
            + x4 * (x293 + x297 * x3 - x3 * x315 + x311 - x315 * x6 + x6 * (x302 + x308))
            - x6
            * (
                x3 * x324
                + x4 * (-x302 + x307 + x315)
                + x4 * (x307 + x318 - x321)
                - x6 * (x3 * x322 + x326 - x6 * (x306 * x5 - x328 * x6))
            ),
            x3 * (x3 * x338 + x335 - x346 * x6)
            + x33 * (x338 - x339 + x345)
            - x6 * (x3 * x346 + x348 - x6 * (x3 * x344 - x350 * x6)),
            x3 * (x3 * x359 + x356 - x366 * x6)
            + x33 * (x359 - x360 + x365)
            - x6 * (x3 * x366 + x368 - x6 * (x3 * x364 - x370 * x6)),
            x3 * (x3 * x378 + x375 - x385 * x6)
            + x33 * (x378 - x379 + x384)
            - x6 * (x3 * x385 + x386 - x6 * (x3 * x383 - x388 * x6)),
            x3 * (x3 * x398 + x395 - x406 * x6)
            + x33 * (x398 - x399 + x405)
            - x6 * (x3 * x406 + x408 - x6 * (x3 * x404 - x410 * x6)),
            x3 * (x3 * x434 - x447 * x6 + x75 * (-x420 + x426 + x432 + x448))
            + x4 * (-x428 + x434 + x446)
            - x6
            * (
                x3 * x447
                - x6
                * (
                    x33 * (x425 - x437 + x440)
                    + x443 * x5
                    - x6 * (x441 * x5 + x449 - x6 * (x439 * x5 - x450 * x6))
                )
                + x75 * (x427 - x436 + x442 + x451)
            )
            + x75 * (-x3 * x427 + x3 * x432 + x433 + x446),
            x3 * (x3 * x464 + x33 * (-x454 + x457 + x461) - x473 * x6)
            + x33 * (-x3 * x458 + x3 * x461 + x463 + x472)
            + x4 * (-x459 + x464 + x472)
            - x6
            * (
                x3 * x473
                + x33 * (x458 - x465 + x468)
                - x6 * (x469 * x5 + x474 - x6 * (x467 * x5 - x475 * x6))
            ),
            x3 * (x3 * x488 + x33 * (-x478 + x481 + x485) - x498 * x6)
            + x33 * (-x3 * x482 + x3 * x485 + x487 + x497)
            + x4 * (-x483 + x488 + x497)
            - x6
            * (
                x3 * x498
                + x33 * (x482 - x489 + x492)
                - x6 * (x493 * x5 + x499 - x6 * (x491 * x5 - x500 * x6))
            ),
            x3 * (x3 * x509 + x510 - x511 * x6)
            + x4 * (x504 - x508 + x509)
            + x4 * (x3 * x501 - x3 * x506 + x504 + x507)
            - x6 * (x3 * x511 + x512 - x6 * (x5 * x503 - x513 * x6)),
            x3 * (x3 * x522 + x523 - x524 * x6)
            + x4 * (x517 - x521 + x522)
            + x4 * (x3 * x514 - x3 * x519 + x517 + x520)
            - x6 * (x3 * x524 + x525 - x6 * (x5 * x516 - x526 * x6)),
            x3 * (x3 * x535 + x536 - x537 * x6)
            + x4 * (x530 - x534 + x535)
            + x4 * (x3 * x527 - x3 * x532 + x530 + x533)
            - x6 * (x3 * x537 + x538 - x6 * (x5 * x529 - x539 * x6)),
            x3 * (x3 * x543 - x545 * x6) + x544 - x6 * (x3 * x545 - x546 * x6),
            x3 * (x3 * x550 - x552 * x6) + x551 - x6 * (x3 * x552 - x553 * x6),
            x3 * (x3 * x556 - x558 * x6) + x557 - x6 * (x3 * x558 - x559 * x6),
            x3 * (x3 * x562 - x564 * x6) + x563 - x6 * (x3 * x564 - x565 * x6),
            x3 * (x3 * x589 - x6 * x602 + x75 * (-x575 + x581 + x587 + x603))
            + x4 * (-x583 + x589 + x601)
            - x6
            * (
                x3 * x602
                - x6
                * (
                    x33 * (x580 - x592 + x595)
                    + x5 * x598
                    - x6 * (x5 * x596 - x6 * (x5 * x594 - x6 * x605) + x604)
                )
                + x75 * (x582 - x591 + x597 + x606)
            )
            + x75 * (-x3 * x582 + x3 * x587 + x588 + x601),
            x3 * (x3 * x624 + x33 * (-x611 + x616 + x621) - x6 * x636)
            + x33 * (-x3 * x617 + x3 * x621 + x623 + x635)
            + x4 * (-x618 + x624 + x635)
            - x6
            * (
                x3 * x636
                + x33 * (x617 - x625 + x630)
                - x6 * (x5 * x631 - x6 * (x5 * x629 - x6 * x639) + x637)
            ),
            x3 * (x3 * x652 + x33 * (-x642 + x645 + x649) - x6 * x662)
            + x33 * (-x3 * x646 + x3 * x649 + x651 + x661)
            + x4 * (-x647 + x652 + x661)
            - x6
            * (
                x3 * x662
                + x33 * (x646 - x653 + x656)
                - x6 * (x5 * x657 - x6 * (x5 * x655 - x6 * x664) + x663)
            ),
            x3 * (x3 * x678 - x6 * x681 + x680)
            + x4 * (x671 - x677 + x678)
            + x4 * (x3 * x666 - x3 * x675 + x671 + x676)
            - x6 * (x3 * x681 - x6 * (x5 * x670 - x6 * x685) + x683),
            x3 * (x3 * x699 - x6 * x701 + x700)
            + x4 * (x692 - x698 + x699)
            + x4 * (x3 * x687 - x3 * x696 + x692 + x697)
            - x6 * (x3 * x701 - x6 * (x5 * x691 - x6 * x704) + x702),
            x3 * (x3 * x713 - x6 * x715 + x714)
            + x4 * (x708 - x712 + x713)
            + x4 * (x3 * x705 - x3 * x710 + x708 + x711)
            - x6 * (x3 * x715 - x6 * (x5 * x707 - x6 * x717) + x716),
            x3 * (x3 * x720 - x6 * x726) - x6 * (x3 * x726 - x6 * x728) + x724,
            x3 * (x3 * x731 - x6 * x736) - x6 * (x3 * x736 - x6 * x738) + x734,
            x3 * (x3 * x742 - x6 * x745) - x6 * (x3 * x745 - x6 * x747) + x743,
            x3 * (x3 * x751 - x6 * x753) - x6 * (x3 * x753 - x6 * x754) + x752,
            x3 * (x33 * (x760 - x761 + x765) + x5 * x767 - x6 * x777)
            - x6
            * (
                x33 * (x766 - x770 + x774)
                + x5 * x777
                - x6 * (x5 * x775 - x6 * (x5 * x773 - x6 * x779) + x778)
            )
            + x75 * (x767 - x769 + x776 + x780),
            x3 * (x5 * x786 - x6 * x792 + x784)
            + x33 * (x786 - x787 + x791)
            - x6 * (x5 * x792 - x6 * (x5 * x790 - x6 * x794) + x793),
            x3 * (x5 * x800 - x6 * x806 + x798)
            + x33 * (x800 - x801 + x805)
            - x6 * (x5 * x806 - x6 * (x5 * x804 - x6 * x808) + x807),
            x3 * (x5 * x814 - x6 * x816) - x6 * (x5 * x816 - x6 * x818) + x815,
            x3 * (x5 * x821 - x6 * x823) - x6 * (x5 * x823 - x6 * x824) + x822,
            x3 * (x5 * x827 - x6 * x829) - x6 * (x5 * x829 - x6 * x830) + x828,
            x3 * x831 - x6 * x832,
            x3 * x834 - x6 * x836,
            x3 * x837 - x6 * x838,
            x3 * x839 - x6 * x840,
            x3 * (x33 * (x845 - x846 + x849) + x5 * x851 - x6 * x860)
            - x6
            * (
                x33 * (x850 - x854 + x857)
                + x5 * x860
                - x6 * (x5 * x858 - x6 * (x5 * x856 - x6 * x862) + x861)
            )
            + x75 * (x851 - x853 + x859 + x863),
            x3 * (x5 * x868 - x6 * x873 + x866)
            + x33 * (x868 - x869 + x872)
            - x6 * (x5 * x873 - x6 * (x5 * x871 - x6 * x875) + x874),
            x3 * (x5 * x880 - x6 * x885 + x878)
            + x33 * (x880 - x881 + x884)
            - x6 * (x5 * x885 - x6 * (x5 * x883 - x6 * x887) + x886),
            x3 * (x5 * x889 - x6 * x891) - x6 * (x5 * x891 - x6 * x892) + x890,
            x3 * (x5 * x894 - x6 * x896) - x6 * (x5 * x896 - x6 * x897) + x895,
            x3 * (x5 * x899 - x6 * x901) - x6 * (x5 * x901 - x6 * x902) + x900,
            x3 * x903 - x6 * x904,
            x3 * x905 - x6 * x906,
            x3 * x907 - x6 * x908,
            x3 * x909 - x6 * x910,
            x3 * (x33 * (x916 - x917 + x921) + x5 * x923 - x6 * x933)
            - x6
            * (
                x33 * (x922 - x926 + x930)
                + x5 * x933
                - x6 * (x5 * x931 - x6 * (x5 * x929 - x6 * x935) + x934)
            )
            + x75 * (x923 - x925 + x932 + x936),
            x3 * (x5 * x944 - x6 * x951 + x941)
            + x33 * (x944 - x945 + x950)
            - x6 * (x5 * x951 - x6 * (x5 * x949 - x6 * x954) + x952),
            x3 * (x5 * x960 - x6 * x966 + x958)
            + x33 * (x960 - x961 + x965)
            - x6 * (x5 * x966 - x6 * (x5 * x964 - x6 * x968) + x967),
            x3 * (x5 * x971 - x6 * x976) - x6 * (x5 * x976 - x6 * x978) + x974,
            x3 * (x5 * x982 - x6 * x985) - x6 * (x5 * x985 - x6 * x987) + x983,
            x3 * (x5 * x993 - x6 * x995) - x6 * (x5 * x995 - x6 * x997) + x994,
            -x1001 * x6 + x3 * x999,
            x1003 * x3 - x1005 * x6,
            x1007 * x3 - x1009 * x6,
            x1010 * x3 - x1011 * x6,
            x33 * (x1017 - x1018 + x1023)
            + x5 * (x1017 * x5 - x1024 * x6 + x4 * (x1012 - x1013 - x1014 + x1015))
            - x6
            * (
                x1024 * x5
                + x4 * (x1016 - x1019 + x1020 - x1021)
                - x6 * (x1022 * x5 - x6 * (x411 * x773 + 2.0 * x449 - x779 * x8))
            ),
            x4 * (x1025 - x1026 + x1027 + x780 + x812)
            + x5 * (x1027 * x5 - x1028 * x6)
            - x6 * (x1028 * x5 - x6 * (x411 * x790 + x778 - x794 * x8 + x817)),
            x4 * (x1029 - x1030 - x1031 + x1032)
            + x5 * (x1032 * x5 - x1033 * x6)
            - x6 * (x1033 * x5 - x6 * (x411 * x804 + 2.0 * x499 - x8 * x808)),
            x5 * (x411 * x814 + 2.0 * x510 + 2.0 * x784 - x8 * x816)
            - x6 * (x411 * x816 + 2.0 * x512 + 2.0 * x793 - x8 * x818),
            x5 * (x411 * x821 + x798 - x8 * x823 + x833)
            - x6 * (x411 * x823 - x8 * x824 + x807 + x835),
            x5 * (x411 * x827 + 2.0 * x536 - x8 * x829)
            - x6 * (x411 * x829 + 2.0 * x538 - x8 * x830),
            x411 * x831 + 2.0 * x544 - x8 * x832 + 3.0 * x815,
            x411 * x834 + 2.0 * x551 - x8 * x836 + 2.0 * x822,
            x411 * x837 + 2.0 * x557 - x8 * x838 + x828,
            x411 * x839 + 2.0 * x563 - x8 * x840,
            x33 * (x1038 - x1039 + x1043)
            + x5 * (x1038 * x5 - x1044 * x6 + x4 * (x1034 - x1035 + x1036 + x603))
            - x6
            * (
                x1044 * x5
                + x4 * (x1037 - x1040 + x1041 + x606)
                - x6 * (x1042 * x5 - x6 * (x411 * x856 + x604 - x8 * x862))
            ),
            x4 * (x1045 - x1046 + x1047 + x634 + x863)
            + x5 * (x1047 * x5 - x1048 * x6)
            - x6 * (x1048 * x5 - x6 * (x411 * x871 + x637 - x8 * x875 + x861)),
            x4 * (x1049 - x1050 + x1051 + x660)
            + x5 * (x1051 * x5 - x1052 * x6)
            - x6 * (x1052 * x5 - x6 * (x411 * x883 + x663 - x8 * x887)),
            x5 * (x411 * x889 + x680 - x8 * x891 + 2.0 * x866)
            - x6 * (x411 * x891 + x683 - x8 * x892 + 2.0 * x874),
            x5 * (x411 * x894 + x700 - x8 * x896 + x878)
            - x6 * (x411 * x896 + x702 - x8 * x897 + x886),
            x5 * (x411 * x899 + x714 - x8 * x901) - x6 * (x411 * x901 + x716 - x8 * x902),
            x411 * x903 + x724 - x8 * x904 + 3.0 * x890,
            x411 * x905 + x734 - x8 * x906 + 2.0 * x895,
            x411 * x907 + x743 - x8 * x908 + x900,
            x411 * x909 + x752 - x8 * x910,
            x33 * (x1056 - x1057 + x1060)
            + x5 * (x1056 * x5 - x1061 * x6 + x4 * (-x1053 + x1054 + x937))
            - x6
            * (
                x1061 * x5
                + x4 * (x1055 - x1058 + x947)
                - x6 * (x1059 * x5 - x6 * (x411 * x929 + x953))
            ),
            x4 * (-x1062 + x1063 + x973)
            + x5 * (x1063 * x5 - x1064 * x6)
            - x6 * (x1064 * x5 - x6 * (x411 * x949 + x977)),
            x4 * (-x1065 + x1066 + x979)
            + x5 * (x1066 * x5 - x1067 * x6)
            - x6 * (x1067 * x5 - x6 * (x411 * x964 + x986)),
            x5 * (x411 * x971 + x998) - x6 * (x1000 + x411 * x976),
            x5 * (x1002 + x411 * x982) - x6 * (x1004 + x411 * x985),
            x5 * (x1006 + x411 * x993) - x6 * (x1008 + x411 * x995),
            -x1001 * x8 + x411 * x999 + 3.0 * x974,
            x1003 * x411 - x1005 * x8 + 2.0 * x983,
            x1007 * x411 - x1009 * x8 + x994,
            x1010 * x411 - x1011 * x8,
            x33 * (x1074 - x1075 + x1080)
            + x5 * (x1072 + x1074 * x5 - x1081 * x6)
            - x6 * (x1081 * x5 + x1082 - x6 * (x1079 * x5 - x1083 * x6)),
            x1087 + x5 * (x1086 * x5 - x1088 * x6) - x6 * (x1088 * x5 - x1089 * x6),
            x1093 + x5 * (x1092 * x5 - x1094 * x6) - x6 * (x1094 * x5 - x1095 * x6),
            x1096 * x5 - x1097 * x6,
            x1098 * x5 - x1099 * x6,
            x1100 * x5 - x1101 * x6,
            2.0 * x1087 + x1096 * x85 - x1097 * x8,
            x1093 + x1098 * x85 - x1099 * x8,
            x1100 * x85 - x1101 * x8,
            -x10 * x1011 + x1010 * x566 + 2.0 * x752 + 3.0 * x994,
        ]
    )


def coulomb3d_34(a, A, b, B, C):
    """Cartesian (fg) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - B[0]
    x6 = -x2 - C[0]
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 * (x10**2 + x6**2 + x8**2)
    x12 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x13 = x12 * boys(2, x11)
    x14 = x12 * boys(1, x11)
    x15 = x4 * (-x13 + x14)
    x16 = x13 * x6
    x17 = x14 * x5
    x18 = -x16 + x17
    x19 = x18 * x5
    x20 = x12 * boys(3, x11)
    x21 = x20 * x6
    x22 = x13 * x5
    x23 = -x21 + x22
    x24 = x23 * x6
    x25 = x15 + x19 - x24
    x26 = x25 * x5
    x27 = x4 * (x13 - x20)
    x28 = x23 * x5
    x29 = x12 * boys(4, x11)
    x30 = x29 * x6
    x31 = x20 * x5
    x32 = -x30 + x31
    x33 = x32 * x6
    x34 = x27 + x28 - x33
    x35 = x34 * x6
    x36 = 2.0 * x4
    x37 = x36 * (x18 + x21 - x22)
    x38 = -x35 + x37
    x39 = x26 + x38
    x40 = x39 * x5
    x41 = x12 * boys(0, x11)
    x42 = x4 * (-x14 + x41)
    x43 = -x14 * x6 + x41 * x5
    x44 = -x18 * x6 + x42 + x43 * x5
    x45 = -x25 * x6 + x36 * (x16 - x17 + x43)
    x46 = x44 * x5 + x45
    x47 = -x15
    x48 = 3.0 * x4
    x49 = -x39 * x6 + x48 * (-x19 + x24 + x44 + x47)
    x50 = x46 * x5 + x49
    x51 = x34 * x5
    x52 = x4 * (x20 - x29)
    x53 = x32 * x5
    x54 = x12 * boys(5, x11)
    x55 = x54 * x6
    x56 = x29 * x5
    x57 = -x55 + x56
    x58 = x57 * x6
    x59 = x52 + x53 - x58
    x60 = x59 * x6
    x61 = x36 * (x23 + x30 - x31)
    x62 = x51 - x60 + x61
    x63 = x6 * x62
    x64 = -x27
    x65 = x48 * (x25 - x28 + x33 + x64)
    x66 = x63 - x65
    x67 = -x63 + x65
    x68 = x40 + x67
    x69 = x35 - x37
    x70 = x4 * (-x26 + x46 + x69)
    x71 = x3 * x50 - x6 * x68 + 4.0 * x70
    x72 = x3 * x68
    x73 = x5 * x62
    x74 = x5 * x59
    x75 = x4 * (x29 - x54)
    x76 = x5 * x57
    x77 = x12 * boys(6, x11)
    x78 = x6 * x77
    x79 = x5 * x54
    x80 = -x78 + x79
    x81 = x6 * x80
    x82 = x75 + x76 - x81
    x83 = x6 * x82
    x84 = x36 * (x32 + x55 - x56)
    x85 = x74 - x83 + x84
    x86 = x6 * x85
    x87 = -x52
    x88 = x48 * (x34 - x53 + x58 + x87)
    x89 = -x86 + x88
    x90 = x73 + x89
    x91 = x6 * x90
    x92 = x60 - x61
    x93 = x4 * (x39 - x51 + x92)
    x94 = 4.0 * x93
    x95 = x72 - x91 + x94
    x96 = x3 * x39
    x97 = x3 * x46 + x49
    x98 = 4.0 * x4
    x99 = x86 - x88
    x100 = x4 * (x54 - x77)
    x101 = x12 * boys(7, x11)
    x102 = -x75
    x103 = x3 * x62
    x104 = x67 + x96
    x105 = x25 * x3
    x106 = x13 * x8
    x107 = -x106
    x108 = -x7 - B[1]
    x109 = x108 * x14
    x110 = x107 + x109
    x111 = x110 * x5
    x112 = x20 * x8
    x113 = -x112
    x114 = x108 * x13
    x115 = x113 + x114
    x116 = x115 * x6
    x117 = x111 - x116
    x118 = x117 * x5
    x119 = x4 * (x110 + x112 - x114)
    x120 = x115 * x5
    x121 = x29 * x8
    x122 = -x121
    x123 = x108 * x20
    x124 = x122 + x123
    x125 = x124 * x6
    x126 = x120 - x125
    x127 = x126 * x6
    x128 = x119 - x127
    x129 = x118 + x128
    x130 = x129 * x5
    x131 = -x14 * x8
    x132 = x108 * x41 + x131
    x133 = -x110 * x6 + x132 * x5
    x134 = x4 * (x106 - x109 + x132)
    x135 = -x117 * x6 + x134
    x136 = x133 * x5 + x135
    x137 = -x129 * x6 + x36 * (-x111 + x116 + x133)
    x138 = x136 * x5 + x137
    x139 = x4 * (x115 + x121 - x123)
    x140 = x126 * x5
    x141 = x124 * x5
    x142 = x54 * x8
    x143 = -x142
    x144 = x108 * x29
    x145 = x143 + x144
    x146 = x145 * x6
    x147 = x141 - x146
    x148 = x147 * x6
    x149 = x139 + x140 - x148
    x150 = x149 * x6
    x151 = x36 * (x117 - x120 + x125)
    x152 = x150 - x151
    x153 = -x150 + x151
    x154 = x130 + x153
    x155 = -x119
    x156 = x127 + x155
    x157 = x4 * (-x118 + x136 + x156)
    x158 = x138 * x3 - x154 * x6 + 3.0 * x157
    x159 = x154 * x3
    x160 = x149 * x5
    x161 = x4 * (x124 + x142 - x144)
    x162 = x147 * x5
    x163 = x145 * x5
    x164 = x77 * x8
    x165 = -x164
    x166 = x108 * x54
    x167 = x165 + x166
    x168 = x167 * x6
    x169 = x163 - x168
    x170 = x169 * x6
    x171 = x161 + x162 - x170
    x172 = x171 * x6
    x173 = x36 * (x126 - x141 + x146)
    x174 = -x172 + x173
    x175 = x160 + x174
    x176 = x175 * x6
    x177 = -x139
    x178 = x148 + x177
    x179 = x4 * (x129 - x140 + x178)
    x180 = 3.0 * x179
    x181 = x159 - x176 + x180
    x182 = x129 * x3
    x183 = x136 * x3 + x137
    x184 = x172 - x173
    x185 = x4 * (x145 + x164 - x166)
    x186 = -x101 * x8
    x187 = x108 * x77 + x186
    x188 = -x161
    x189 = x149 * x3
    x190 = x153 + x182
    x191 = x117 * x3
    x192 = x10 * x13
    x193 = -x192
    x194 = -x9 - B[2]
    x195 = x14 * x194
    x196 = x193 + x195
    x197 = x196 * x5
    x198 = x10 * x20
    x199 = -x198
    x200 = x13 * x194
    x201 = x199 + x200
    x202 = x201 * x6
    x203 = x197 - x202
    x204 = x203 * x5
    x205 = x4 * (x196 + x198 - x200)
    x206 = x201 * x5
    x207 = x10 * x29
    x208 = -x207
    x209 = x194 * x20
    x210 = x208 + x209
    x211 = x210 * x6
    x212 = x206 - x211
    x213 = x212 * x6
    x214 = x205 - x213
    x215 = x204 + x214
    x216 = x215 * x5
    x217 = -x10 * x14
    x218 = x194 * x41 + x217
    x219 = -x196 * x6 + x218 * x5
    x220 = x4 * (x192 - x195 + x218)
    x221 = -x203 * x6 + x220
    x222 = x219 * x5 + x221
    x223 = -x215 * x6 + x36 * (-x197 + x202 + x219)
    x224 = x222 * x5 + x223
    x225 = x4 * (x201 + x207 - x209)
    x226 = x212 * x5
    x227 = x210 * x5
    x228 = x10 * x54
    x229 = -x228
    x230 = x194 * x29
    x231 = x229 + x230
    x232 = x231 * x6
    x233 = x227 - x232
    x234 = x233 * x6
    x235 = x225 + x226 - x234
    x236 = x235 * x6
    x237 = x36 * (x203 - x206 + x211)
    x238 = x236 - x237
    x239 = -x236 + x237
    x240 = x216 + x239
    x241 = -x205
    x242 = x213 + x241
    x243 = x4 * (-x204 + x222 + x242)
    x244 = x224 * x3 - x240 * x6 + 3.0 * x243
    x245 = x240 * x3
    x246 = x235 * x5
    x247 = x4 * (x210 + x228 - x230)
    x248 = x233 * x5
    x249 = x231 * x5
    x250 = x10 * x77
    x251 = -x250
    x252 = x194 * x54
    x253 = x251 + x252
    x254 = x253 * x6
    x255 = x249 - x254
    x256 = x255 * x6
    x257 = x247 + x248 - x256
    x258 = x257 * x6
    x259 = x36 * (x212 - x227 + x232)
    x260 = -x258 + x259
    x261 = x246 + x260
    x262 = x261 * x6
    x263 = -x225
    x264 = x234 + x263
    x265 = x4 * (x215 - x226 + x264)
    x266 = 3.0 * x265
    x267 = x245 - x262 + x266
    x268 = x215 * x3
    x269 = x222 * x3 + x223
    x270 = x258 - x259
    x271 = x4 * (x231 + x250 - x252)
    x272 = -x10 * x101
    x273 = x194 * x77 + x272
    x274 = -x247
    x275 = x235 * x3
    x276 = x239 + x268
    x277 = x203 * x3
    x278 = x108 * x110
    x279 = x115 * x8
    x280 = x15 - x279
    x281 = x278 + x280
    x282 = x281 * x5
    x283 = x108 * x115
    x284 = x124 * x8
    x285 = x27 - x284
    x286 = x283 + x285
    x287 = x286 * x6
    x288 = -x287
    x289 = x282 + x288
    x290 = x289 * x5
    x291 = -x110 * x8 + x42
    x292 = x108 * x132 + x291
    x293 = -x281 * x6
    x294 = x292 * x5 + x293
    x295 = x279 + x47
    x296 = x4 * (-x278 + x292 + x295)
    x297 = -x289 * x6 + x296
    x298 = x294 * x5 + x297
    x299 = x286 * x5
    x300 = x108 * x124
    x301 = x145 * x8
    x302 = -x301 + x52
    x303 = x300 + x302
    x304 = x303 * x6
    x305 = x299 - x304
    x306 = x305 * x6
    x307 = x284 + x64
    x308 = x4 * (x281 - x283 + x307)
    x309 = -x308
    x310 = x306 + x309
    x311 = -x306 + x308
    x312 = x290 + x311
    x313 = x4 * (-x282 + x287 + x294)
    x314 = x298 * x3 - x312 * x6 + 2.0 * x313
    x315 = x3 * x312
    x316 = x305 * x5
    x317 = x301 + x87
    x318 = x4 * (x286 - x300 + x317)
    x319 = x303 * x5
    x320 = x108 * x145
    x321 = x167 * x8
    x322 = -x321 + x75
    x323 = x320 + x322
    x324 = x323 * x6
    x325 = x319 - x324
    x326 = x325 * x6
    x327 = x318 - x326
    x328 = x316 + x327
    x329 = x328 * x6
    x330 = x4 * (x289 - x299 + x304)
    x331 = 2.0 * x330
    x332 = x315 - x329 + x331
    x333 = x289 * x3
    x334 = x294 * x3 + x297
    x335 = -x318
    x336 = x326 + x335
    x337 = x102 + x321
    x338 = x4 * (x303 - x320 + x337)
    x339 = x100 - x187 * x8
    x340 = x108 * x167 + x339
    x341 = x3 * x305
    x342 = x311 + x333
    x343 = x281 * x3
    x344 = x108 * x196
    x345 = x201 * x8
    x346 = -x345
    x347 = x344 + x346
    x348 = x347 * x5
    x349 = x108 * x201
    x350 = x210 * x8
    x351 = -x350
    x352 = x349 + x351
    x353 = x352 * x6
    x354 = -x353
    x355 = x348 + x354
    x356 = x355 * x5
    x357 = -x196 * x8
    x358 = x108 * x218 + x357
    x359 = -x347 * x6
    x360 = x358 * x5 + x359
    x361 = x4 * (-x344 + x345 + x358)
    x362 = -x355 * x6 + x361
    x363 = x360 * x5 + x362
    x364 = x352 * x5
    x365 = x108 * x210
    x366 = x231 * x8
    x367 = -x366
    x368 = x365 + x367
    x369 = x368 * x6
    x370 = x364 - x369
    x371 = x370 * x6
    x372 = x4 * (x347 - x349 + x350)
    x373 = -x372
    x374 = x371 + x373
    x375 = -x371 + x372
    x376 = x356 + x375
    x377 = x4 * (-x348 + x353 + x360)
    x378 = x3 * x363 - x376 * x6 + 2.0 * x377
    x379 = x3 * x376
    x380 = x370 * x5
    x381 = x4 * (x352 - x365 + x366)
    x382 = x368 * x5
    x383 = x108 * x231
    x384 = x253 * x8
    x385 = -x384
    x386 = x383 + x385
    x387 = x386 * x6
    x388 = x382 - x387
    x389 = x388 * x6
    x390 = x381 - x389
    x391 = x380 + x390
    x392 = x391 * x6
    x393 = x4 * (x355 - x364 + x369)
    x394 = 2.0 * x393
    x395 = x379 - x392 + x394
    x396 = x3 * x355
    x397 = x3 * x360 + x362
    x398 = -x381
    x399 = x389 + x398
    x400 = x4 * (x368 - x383 + x384)
    x401 = -x273 * x8
    x402 = x108 * x253 + x401
    x403 = x3 * x370
    x404 = x375 + x396
    x405 = x3 * x347
    x406 = x194 * x196
    x407 = x10 * x201
    x408 = x15 - x407
    x409 = x406 + x408
    x410 = x409 * x5
    x411 = x194 * x201
    x412 = x10 * x210
    x413 = x27 - x412
    x414 = x411 + x413
    x415 = x414 * x6
    x416 = -x415
    x417 = x410 + x416
    x418 = x417 * x5
    x419 = -x10 * x196 + x42
    x420 = x194 * x218 + x419
    x421 = -x409 * x6
    x422 = x420 * x5 + x421
    x423 = x407 + x47
    x424 = x4 * (-x406 + x420 + x423)
    x425 = -x417 * x6 + x424
    x426 = x422 * x5 + x425
    x427 = x414 * x5
    x428 = x194 * x210
    x429 = x10 * x231
    x430 = -x429 + x52
    x431 = x428 + x430
    x432 = x431 * x6
    x433 = x427 - x432
    x434 = x433 * x6
    x435 = x412 + x64
    x436 = x4 * (x409 - x411 + x435)
    x437 = -x436
    x438 = x434 + x437
    x439 = -x434 + x436
    x440 = x418 + x439
    x441 = x4 * (-x410 + x415 + x422)
    x442 = x3 * x426 - x440 * x6 + 2.0 * x441
    x443 = x3 * x440
    x444 = x433 * x5
    x445 = x429 + x87
    x446 = x4 * (x414 - x428 + x445)
    x447 = x431 * x5
    x448 = x194 * x231
    x449 = x10 * x253
    x450 = -x449 + x75
    x451 = x448 + x450
    x452 = x451 * x6
    x453 = x447 - x452
    x454 = x453 * x6
    x455 = x446 - x454
    x456 = x444 + x455
    x457 = x456 * x6
    x458 = x4 * (x417 - x427 + x432)
    x459 = 2.0 * x458
    x460 = x443 - x457 + x459
    x461 = x3 * x417
    x462 = x3 * x422 + x425
    x463 = -x446
    x464 = x454 + x463
    x465 = x102 + x449
    x466 = x4 * (x431 - x448 + x465)
    x467 = -x10 * x273 + x100
    x468 = x194 * x253 + x467
    x469 = x3 * x433
    x470 = x439 + x461
    x471 = x3 * x409
    x472 = x108 * x281
    x473 = 2.0 * x134 - x281 * x8
    x474 = x108 * x292 + x473
    x475 = x286 * x8
    x476 = 2.0 * x119
    x477 = x475 - x476
    x478 = x4 * (-x472 + x474 + x477)
    x479 = -x475 + x476
    x480 = x472 + x479
    x481 = -x480 * x6
    x482 = x3 * x474 + x481
    x483 = x108 * x286
    x484 = x303 * x8
    x485 = 2.0 * x139
    x486 = -x484 + x485
    x487 = x483 + x486
    x488 = x3 * x487
    x489 = x108 * x303
    x490 = x323 * x8
    x491 = 2.0 * x161
    x492 = -x490 + x491
    x493 = x489 + x492
    x494 = x493 * x6
    x495 = -x494
    x496 = x484 - x485
    x497 = x4 * (x480 - x483 + x496)
    x498 = -x497
    x499 = x3 * x480
    x500 = x487 * x6
    x501 = -x500
    x502 = x499 + x501
    x503 = x480 * x5
    x504 = x474 * x5 + x481
    x505 = x501 + x503
    x506 = x3 * x504 + x478 - x505 * x6
    x507 = x3 * x505
    x508 = x487 * x5
    x509 = x495 + x508
    x510 = x509 * x6
    x511 = x497 + x507 - x510
    x512 = x490 - x491
    x513 = x4 * (x487 - x489 + x512)
    x514 = 2.0 * x185 - x340 * x8
    x515 = x108 * x323 + x514
    x516 = x108 * x347
    x517 = x220 - x347 * x8
    x518 = x108 * x358 + x517
    x519 = x352 * x8
    x520 = x241 + x519
    x521 = x4 * (-x516 + x518 + x520)
    x522 = x205 - x519
    x523 = x516 + x522
    x524 = -x523 * x6
    x525 = x3 * x518 + x524
    x526 = x108 * x352
    x527 = x368 * x8
    x528 = x225 - x527
    x529 = x526 + x528
    x530 = x3 * x529
    x531 = x108 * x368
    x532 = x386 * x8
    x533 = x247 - x532
    x534 = x531 + x533
    x535 = x534 * x6
    x536 = -x535
    x537 = x263 + x527
    x538 = x4 * (x523 - x526 + x537)
    x539 = -x538
    x540 = x3 * x523
    x541 = x529 * x6
    x542 = -x541
    x543 = x540 + x542
    x544 = x5 * x523
    x545 = x5 * x518 + x524
    x546 = x542 + x544
    x547 = x3 * x545 + x521 - x546 * x6
    x548 = x3 * x546
    x549 = x5 * x529
    x550 = x536 + x549
    x551 = x550 * x6
    x552 = x538 + x548 - x551
    x553 = x274 + x532
    x554 = x4 * (x529 - x531 + x553)
    x555 = x271 - x402 * x8
    x556 = x108 * x386 + x555
    x557 = x414 * x8
    x558 = x108 * x409
    x559 = -x409 * x8
    x560 = x108 * x420 + x559
    x561 = x4 * (x557 - x558 + x560)
    x562 = -x557
    x563 = x558 + x562
    x564 = -x563 * x6
    x565 = x3 * x560 + x564
    x566 = x108 * x414
    x567 = x431 * x8
    x568 = -x567
    x569 = x566 + x568
    x570 = x3 * x569
    x571 = x108 * x431
    x572 = x451 * x8
    x573 = -x572
    x574 = x571 + x573
    x575 = x574 * x6
    x576 = -x575
    x577 = x4 * (x563 - x566 + x567)
    x578 = -x577
    x579 = x3 * x563
    x580 = x569 * x6
    x581 = -x580
    x582 = x579 + x581
    x583 = x5 * x563
    x584 = x5 * x560 + x564
    x585 = x581 + x583
    x586 = x3 * x584 + x561 - x585 * x6
    x587 = x3 * x585
    x588 = x5 * x569
    x589 = x576 + x588
    x590 = x589 * x6
    x591 = x577 + x587 - x590
    x592 = x4 * (x569 - x571 + x572)
    x593 = -x468 * x8
    x594 = x108 * x451 + x593
    x595 = x194 * x409
    x596 = -x10 * x409 + 2.0 * x220
    x597 = x194 * x420 + x596
    x598 = x10 * x414
    x599 = 2.0 * x205
    x600 = x598 - x599
    x601 = x4 * (-x595 + x597 + x600)
    x602 = -x598 + x599
    x603 = x595 + x602
    x604 = -x6 * x603
    x605 = x3 * x597 + x604
    x606 = x194 * x414
    x607 = x10 * x431
    x608 = 2.0 * x225
    x609 = -x607 + x608
    x610 = x606 + x609
    x611 = x3 * x610
    x612 = x194 * x431
    x613 = x10 * x451
    x614 = 2.0 * x247
    x615 = -x613 + x614
    x616 = x612 + x615
    x617 = x6 * x616
    x618 = -x617
    x619 = x607 - x608
    x620 = x4 * (x603 - x606 + x619)
    x621 = -x620
    x622 = x3 * x603
    x623 = x6 * x610
    x624 = -x623
    x625 = x622 + x624
    x626 = x5 * x603
    x627 = x5 * x597 + x604
    x628 = x624 + x626
    x629 = x3 * x627 - x6 * x628 + x601
    x630 = x3 * x628
    x631 = x5 * x610
    x632 = x618 + x631
    x633 = x6 * x632
    x634 = x620 + x630 - x633
    x635 = x613 - x614
    x636 = x4 * (x610 - x612 + x635)
    x637 = -x10 * x468 + 2.0 * x271
    x638 = x194 * x451 + x637
    x639 = x108 * x480
    x640 = 3.0 * x296 - x480 * x8
    x641 = x108 * x474 + x640
    x642 = x487 * x8
    x643 = 3.0 * x308
    x644 = x642 - x643
    x645 = x4 * (-x639 + x641 + x644)
    x646 = -x642 + x643
    x647 = x639 + x646
    x648 = x3 * x641 - x6 * x647
    x649 = x3 * x647
    x650 = x108 * x487
    x651 = x493 * x8
    x652 = 3.0 * x318
    x653 = -x651 + x652
    x654 = x650 + x653
    x655 = x6 * x654
    x656 = x649 - x655
    x657 = x651 - x652
    x658 = x4 * (x647 - x650 + x657)
    x659 = 3.0 * x338 - x515 * x8
    x660 = x108 * x493 + x659
    x661 = x108 * x523
    x662 = 2.0 * x361 - x523 * x8
    x663 = x108 * x518 + x662
    x664 = x529 * x8
    x665 = 2.0 * x372
    x666 = x664 - x665
    x667 = x4 * (-x661 + x663 + x666)
    x668 = -x664 + x665
    x669 = x661 + x668
    x670 = x3 * x663 - x6 * x669
    x671 = x3 * x669
    x672 = x108 * x529
    x673 = x534 * x8
    x674 = 2.0 * x381
    x675 = -x673 + x674
    x676 = x672 + x675
    x677 = x6 * x676
    x678 = x671 - x677
    x679 = x673 - x674
    x680 = x4 * (x669 - x672 + x679)
    x681 = 2.0 * x400 - x556 * x8
    x682 = x108 * x534 + x681
    x683 = x108 * x563
    x684 = x424 - x563 * x8
    x685 = x108 * x560 + x684
    x686 = x569 * x8
    x687 = x437 + x686
    x688 = x4 * (-x683 + x685 + x687)
    x689 = x436 - x686
    x690 = x683 + x689
    x691 = x3 * x685 - x6 * x690
    x692 = x3 * x690
    x693 = x108 * x569
    x694 = x574 * x8
    x695 = x446 - x694
    x696 = x693 + x695
    x697 = x6 * x696
    x698 = x692 - x697
    x699 = x463 + x694
    x700 = x4 * (x690 - x693 + x699)
    x701 = x466 - x594 * x8
    x702 = x108 * x574 + x701
    x703 = x610 * x8
    x704 = x108 * x603
    x705 = -x603 * x8
    x706 = x108 * x597 + x705
    x707 = x4 * (x703 - x704 + x706)
    x708 = -x703
    x709 = x704 + x708
    x710 = x3 * x706 - x6 * x709
    x711 = x3 * x709
    x712 = x108 * x610
    x713 = x616 * x8
    x714 = -x713
    x715 = x712 + x714
    x716 = x6 * x715
    x717 = x711 - x716
    x718 = x4 * (x709 - x712 + x713)
    x719 = -x638 * x8
    x720 = x108 * x616 + x719
    x721 = x194 * x603
    x722 = -x10 * x603 + 3.0 * x424
    x723 = x194 * x597 + x722
    x724 = x10 * x610
    x725 = 3.0 * x436
    x726 = x724 - x725
    x727 = x4 * (-x721 + x723 + x726)
    x728 = -x724 + x725
    x729 = x721 + x728
    x730 = x3 * x723 - x6 * x729
    x731 = x3 * x729
    x732 = x194 * x610
    x733 = x10 * x616
    x734 = 3.0 * x446
    x735 = -x733 + x734
    x736 = x732 + x735
    x737 = x6 * x736
    x738 = x731 - x737
    x739 = x733 - x734
    x740 = x4 * (x729 - x732 + x739)
    x741 = -x10 * x638 + 3.0 * x466
    x742 = x194 * x616 + x741
    x743 = -x7 - A[1]
    x744 = x13 * x743
    x745 = x14 * x743
    x746 = x107 + x745
    x747 = x4 * (x112 - x744 + x746)
    x748 = x5 * x746
    x749 = x113 + x744
    x750 = x6 * x749
    x751 = x748 - x750
    x752 = x5 * x751
    x753 = x5 * x749
    x754 = x20 * x743
    x755 = x122 + x754
    x756 = x6 * x755
    x757 = x753 - x756
    x758 = x6 * x757
    x759 = x747 + x752 - x758
    x760 = x5 * x759
    x761 = x4 * (x121 + x749 - x754)
    x762 = x5 * x757
    x763 = x5 * x755
    x764 = x29 * x743
    x765 = x143 + x764
    x766 = x6 * x765
    x767 = x763 - x766
    x768 = x6 * x767
    x769 = x761 + x762 - x768
    x770 = x6 * x769
    x771 = x36 * (x751 - x753 + x756)
    x772 = x760 - x770 + x771
    x773 = x5 * x772
    x774 = x131 + x41 * x743
    x775 = x4 * (x106 - x745 + x774)
    x776 = x5 * x774 - x6 * x746
    x777 = x5 * x776 - x6 * x751 + x775
    x778 = x36 * (-x748 + x750 + x776) + x5 * x777 - x6 * x759
    x779 = -x747
    x780 = x48 * (-x752 + x758 + x777 + x779) - x6 * x772
    x781 = x5 * x778 + x780
    x782 = x5 * x769
    x783 = x4 * (x142 + x755 - x764)
    x784 = x5 * x767
    x785 = x5 * x765
    x786 = x54 * x743
    x787 = x165 + x786
    x788 = x6 * x787
    x789 = x785 - x788
    x790 = x6 * x789
    x791 = x783 + x784 - x790
    x792 = x6 * x791
    x793 = x36 * (x757 - x763 + x766)
    x794 = x782 - x792 + x793
    x795 = x6 * x794
    x796 = -x761
    x797 = x48 * (x759 - x762 + x768 + x796)
    x798 = x795 - x797
    x799 = x773 - x795 + x797
    x800 = x4 * (x164 + x765 - x786)
    x801 = x186 + x743 * x77
    x802 = -x783
    x803 = x115 * x743
    x804 = x110 * x743
    x805 = x280 + x804
    x806 = x4 * (x307 - x803 + x805)
    x807 = x5 * x805
    x808 = x285 + x803
    x809 = x6 * x808
    x810 = x807 - x809
    x811 = x5 * x810
    x812 = x5 * x808
    x813 = x124 * x743
    x814 = x302 + x813
    x815 = x6 * x814
    x816 = x812 - x815
    x817 = x6 * x816
    x818 = x806 + x811 - x817
    x819 = x5 * x818
    x820 = x132 * x743 + x291
    x821 = x4 * (x295 - x804 + x820)
    x822 = x5 * x820 - x6 * x805
    x823 = x5 * x822 - x6 * x810 + x821
    x824 = x36 * (-x807 + x809 + x822) - x6 * x818
    x825 = x5 * x823 + x824
    x826 = x4 * (x317 + x808 - x813)
    x827 = x5 * x816
    x828 = x5 * x814
    x829 = x145 * x743
    x830 = x322 + x829
    x831 = x6 * x830
    x832 = x828 - x831
    x833 = x6 * x832
    x834 = x826 + x827 - x833
    x835 = x6 * x834
    x836 = x36 * (x810 - x812 + x815)
    x837 = x835 - x836
    x838 = x819 - x835 + x836
    x839 = x4 * (x337 + x814 - x829)
    x840 = x167 * x743 + x339
    x841 = x201 * x743
    x842 = x196 * x743
    x843 = x346 + x842
    x844 = x4 * (x350 - x841 + x843)
    x845 = x5 * x843
    x846 = x351 + x841
    x847 = x6 * x846
    x848 = x845 - x847
    x849 = x5 * x848
    x850 = x5 * x846
    x851 = x210 * x743
    x852 = x367 + x851
    x853 = x6 * x852
    x854 = x850 - x853
    x855 = x6 * x854
    x856 = x844 + x849 - x855
    x857 = x5 * x856
    x858 = x218 * x743 + x357
    x859 = x4 * (x345 - x842 + x858)
    x860 = x5 * x858 - x6 * x843
    x861 = x5 * x860 - x6 * x848 + x859
    x862 = x36 * (-x845 + x847 + x860) - x6 * x856
    x863 = x5 * x861 + x862
    x864 = x4 * (x366 + x846 - x851)
    x865 = x5 * x854
    x866 = x5 * x852
    x867 = x231 * x743
    x868 = x385 + x867
    x869 = x6 * x868
    x870 = x866 - x869
    x871 = x6 * x870
    x872 = x864 + x865 - x871
    x873 = x6 * x872
    x874 = x36 * (x848 - x850 + x853)
    x875 = x873 - x874
    x876 = x857 - x873 + x874
    x877 = -x844
    x878 = x4 * (x384 + x852 - x867)
    x879 = x253 * x743 + x401
    x880 = -x864
    x881 = x281 * x743
    x882 = x479 + x881
    x883 = x5 * x882
    x884 = x286 * x743
    x885 = x486 + x884
    x886 = x6 * x885
    x887 = x883 - x886
    x888 = x5 * x887
    x889 = x292 * x743 + x473
    x890 = x5 * x889 - x6 * x882
    x891 = x4 * (x477 - x881 + x889)
    x892 = -x6 * x887 + x891
    x893 = x5 * x890 + x892
    x894 = x5 * x885
    x895 = x303 * x743
    x896 = x492 + x895
    x897 = x6 * x896
    x898 = x894 - x897
    x899 = x6 * x898
    x900 = x4 * (x496 + x882 - x884)
    x901 = x899 - x900
    x902 = x888 - x899 + x900
    x903 = x4 * (x512 + x885 - x895)
    x904 = x323 * x743 + x514
    x905 = x347 * x743
    x906 = x522 + x905
    x907 = x5 * x906
    x908 = x352 * x743
    x909 = x528 + x908
    x910 = x6 * x909
    x911 = x907 - x910
    x912 = x5 * x911
    x913 = x358 * x743 + x517
    x914 = x5 * x913 - x6 * x906
    x915 = x4 * (x520 - x905 + x913)
    x916 = -x6 * x911 + x915
    x917 = x5 * x914 + x916
    x918 = x5 * x909
    x919 = x368 * x743
    x920 = x533 + x919
    x921 = x6 * x920
    x922 = x918 - x921
    x923 = x6 * x922
    x924 = x4 * (x537 + x906 - x908)
    x925 = x923 - x924
    x926 = x912 - x923 + x924
    x927 = x4 * (x553 + x909 - x919)
    x928 = x386 * x743 + x555
    x929 = x409 * x743
    x930 = x562 + x929
    x931 = x5 * x930
    x932 = x414 * x743
    x933 = x568 + x932
    x934 = x6 * x933
    x935 = x931 - x934
    x936 = x5 * x935
    x937 = x420 * x743 + x559
    x938 = x5 * x937 - x6 * x930
    x939 = x4 * (x557 - x929 + x937)
    x940 = -x6 * x935 + x939
    x941 = x5 * x938 + x940
    x942 = x5 * x933
    x943 = x431 * x743
    x944 = x573 + x943
    x945 = x6 * x944
    x946 = x942 - x945
    x947 = x6 * x946
    x948 = x4 * (x567 + x930 - x932)
    x949 = -x948
    x950 = x947 + x949
    x951 = x936 - x947 + x948
    x952 = x4 * (x572 + x933 - x943)
    x953 = x451 * x743 + x593
    x954 = x474 * x743 + x640
    x955 = x487 * x743
    x956 = x653 + x955
    x957 = x6 * x956
    x958 = x480 * x743
    x959 = x646 + x958
    x960 = -x6 * x959
    x961 = x5 * x959
    x962 = x5 * x954 + x960
    x963 = x4 * (x644 + x954 - x958)
    x964 = -x957 + x961
    x965 = x4 * (x657 - x955 + x959)
    x966 = x493 * x743 + x659
    x967 = x518 * x743 + x662
    x968 = x529 * x743
    x969 = x675 + x968
    x970 = x6 * x969
    x971 = x523 * x743
    x972 = x668 + x971
    x973 = -x6 * x972
    x974 = x5 * x972
    x975 = x5 * x967 + x973
    x976 = x4 * (x666 + x967 - x971)
    x977 = -x970 + x974
    x978 = x4 * (x679 - x968 + x972)
    x979 = x534 * x743 + x681
    x980 = x560 * x743 + x684
    x981 = x569 * x743
    x982 = x695 + x981
    x983 = x6 * x982
    x984 = x563 * x743
    x985 = x689 + x984
    x986 = -x6 * x985
    x987 = x5 * x985
    x988 = x5 * x980 + x986
    x989 = x4 * (x687 + x980 - x984)
    x990 = -x983 + x987
    x991 = x4 * (x699 - x981 + x985)
    x992 = x574 * x743 + x701
    x993 = x597 * x743 + x705
    x994 = x610 * x743
    x995 = x714 + x994
    x996 = x6 * x995
    x997 = x603 * x743
    x998 = x708 + x997
    x999 = -x6 * x998
    x1000 = x5 * x998
    x1001 = x5 * x993 + x999
    x1002 = x4 * (x703 + x993 - x997)
    x1003 = x1000 - x996
    x1004 = x4 * (x713 - x994 + x998)
    x1005 = x616 * x743 + x719
    x1006 = x654 * x8
    x1007 = x647 * x743
    x1008 = 4.0 * x497
    x1009 = 4.0 * x478 + x641 * x743 - x647 * x8
    x1010 = x4 * (x1006 - x1007 - x1008 + x1009)
    x1011 = -x1006 + x1007 + x1008
    x1012 = 4.0 * x513 + x654 * x743 - x660 * x8
    x1013 = x676 * x8
    x1014 = x669 * x743
    x1015 = 3.0 * x538
    x1016 = 3.0 * x521 + x663 * x743 - x669 * x8
    x1017 = x4 * (x1013 - x1014 - x1015 + x1016)
    x1018 = -x1013 + x1014 + x1015
    x1019 = 3.0 * x554 + x676 * x743 - x682 * x8
    x1020 = x696 * x8
    x1021 = x690 * x743
    x1022 = 2.0 * x577
    x1023 = 2.0 * x561 + x685 * x743 - x690 * x8
    x1024 = x4 * (x1020 - x1021 - x1022 + x1023)
    x1025 = -x1020 + x1021 + x1022
    x1026 = 2.0 * x592 + x696 * x743 - x702 * x8
    x1027 = x715 * x8
    x1028 = x709 * x743
    x1029 = x601 + x706 * x743 - x709 * x8
    x1030 = x4 * (x1027 - x1028 + x1029 + x621)
    x1031 = -x1027 + x1028 + x620
    x1032 = x636 + x715 * x743 - x720 * x8
    x1033 = x736 * x8
    x1034 = x729 * x743
    x1035 = x723 * x743 - x729 * x8
    x1036 = x4 * (x1033 - x1034 + x1035)
    x1037 = -x1033 + x1034
    x1038 = x736 * x743 - x742 * x8
    x1039 = -x9 - A[2]
    x1040 = x1039 * x13
    x1041 = x1039 * x14
    x1042 = x1041 + x193
    x1043 = x4 * (-x1040 + x1042 + x198)
    x1044 = x1042 * x5
    x1045 = x1040 + x199
    x1046 = x1045 * x6
    x1047 = x1044 - x1046
    x1048 = x1047 * x5
    x1049 = x1045 * x5
    x1050 = x1039 * x20
    x1051 = x1050 + x208
    x1052 = x1051 * x6
    x1053 = x1049 - x1052
    x1054 = x1053 * x6
    x1055 = x1043 + x1048 - x1054
    x1056 = x1055 * x5
    x1057 = x4 * (x1045 - x1050 + x207)
    x1058 = x1053 * x5
    x1059 = x1051 * x5
    x1060 = x1039 * x29
    x1061 = x1060 + x229
    x1062 = x1061 * x6
    x1063 = x1059 - x1062
    x1064 = x1063 * x6
    x1065 = x1057 + x1058 - x1064
    x1066 = x1065 * x6
    x1067 = x36 * (x1047 - x1049 + x1052)
    x1068 = x1056 - x1066 + x1067
    x1069 = x1068 * x5
    x1070 = x1039 * x41 + x217
    x1071 = x4 * (-x1041 + x1070 + x192)
    x1072 = -x1042 * x6 + x1070 * x5
    x1073 = -x1047 * x6 + x1071 + x1072 * x5
    x1074 = -x1055 * x6 + x1073 * x5 + x36 * (-x1044 + x1046 + x1072)
    x1075 = -x1043
    x1076 = -x1068 * x6 + x48 * (-x1048 + x1054 + x1073 + x1075)
    x1077 = x1074 * x5 + x1076
    x1078 = x1065 * x5
    x1079 = x4 * (x1051 - x1060 + x228)
    x1080 = x1063 * x5
    x1081 = x1061 * x5
    x1082 = x1039 * x54
    x1083 = x1082 + x251
    x1084 = x1083 * x6
    x1085 = x1081 - x1084
    x1086 = x1085 * x6
    x1087 = x1079 + x1080 - x1086
    x1088 = x1087 * x6
    x1089 = x36 * (x1053 - x1059 + x1062)
    x1090 = x1078 - x1088 + x1089
    x1091 = x1090 * x6
    x1092 = -x1057
    x1093 = x48 * (x1055 - x1058 + x1064 + x1092)
    x1094 = x1091 - x1093
    x1095 = x1069 - x1091 + x1093
    x1096 = x4 * (x1061 - x1082 + x250)
    x1097 = x1039 * x77 + x272
    x1098 = -x1079
    x1099 = x1051 * x8
    x1100 = x1045 * x108
    x1101 = x1042 * x108
    x1102 = x1045 * x8
    x1103 = -x1102
    x1104 = x1101 + x1103
    x1105 = x4 * (x1099 - x1100 + x1104)
    x1106 = x1104 * x5
    x1107 = -x1099
    x1108 = x1100 + x1107
    x1109 = x1108 * x6
    x1110 = x1106 - x1109
    x1111 = x1110 * x5
    x1112 = x1108 * x5
    x1113 = x1051 * x108
    x1114 = x1061 * x8
    x1115 = -x1114
    x1116 = x1113 + x1115
    x1117 = x1116 * x6
    x1118 = x1112 - x1117
    x1119 = x1118 * x6
    x1120 = x1105 + x1111 - x1119
    x1121 = x1120 * x5
    x1122 = -x1042 * x8
    x1123 = x1070 * x108 + x1122
    x1124 = x4 * (-x1101 + x1102 + x1123)
    x1125 = -x1104 * x6 + x1123 * x5
    x1126 = -x1110 * x6 + x1124 + x1125 * x5
    x1127 = -x1120 * x6 + x36 * (-x1106 + x1109 + x1125)
    x1128 = x1126 * x5 + x1127
    x1129 = x4 * (x1108 - x1113 + x1114)
    x1130 = x1118 * x5
    x1131 = x1116 * x5
    x1132 = x1061 * x108
    x1133 = x1083 * x8
    x1134 = -x1133
    x1135 = x1132 + x1134
    x1136 = x1135 * x6
    x1137 = x1131 - x1136
    x1138 = x1137 * x6
    x1139 = x1129 + x1130 - x1138
    x1140 = x1139 * x6
    x1141 = x36 * (x1110 - x1112 + x1117)
    x1142 = x1140 - x1141
    x1143 = x1121 - x1140 + x1141
    x1144 = -x1105
    x1145 = x4 * (x1116 - x1132 + x1133)
    x1146 = -x1097 * x8
    x1147 = x108 * x1083 + x1146
    x1148 = -x1129
    x1149 = x1039 * x201
    x1150 = x1039 * x196
    x1151 = x1150 + x408
    x1152 = x4 * (-x1149 + x1151 + x435)
    x1153 = x1151 * x5
    x1154 = x1149 + x413
    x1155 = x1154 * x6
    x1156 = x1153 - x1155
    x1157 = x1156 * x5
    x1158 = x1154 * x5
    x1159 = x1039 * x210
    x1160 = x1159 + x430
    x1161 = x1160 * x6
    x1162 = x1158 - x1161
    x1163 = x1162 * x6
    x1164 = x1152 + x1157 - x1163
    x1165 = x1164 * x5
    x1166 = x1039 * x218 + x419
    x1167 = x4 * (-x1150 + x1166 + x423)
    x1168 = -x1151 * x6 + x1166 * x5
    x1169 = -x1156 * x6 + x1167 + x1168 * x5
    x1170 = -x1164 * x6 + x36 * (-x1153 + x1155 + x1168)
    x1171 = x1169 * x5 + x1170
    x1172 = x4 * (x1154 - x1159 + x445)
    x1173 = x1162 * x5
    x1174 = x1160 * x5
    x1175 = x1039 * x231
    x1176 = x1175 + x450
    x1177 = x1176 * x6
    x1178 = x1174 - x1177
    x1179 = x1178 * x6
    x1180 = x1172 + x1173 - x1179
    x1181 = x1180 * x6
    x1182 = x36 * (x1156 - x1158 + x1161)
    x1183 = x1181 - x1182
    x1184 = x1165 - x1181 + x1182
    x1185 = -x1152
    x1186 = x4 * (x1160 - x1175 + x465)
    x1187 = x1039 * x253 + x467
    x1188 = -x1172
    x1189 = x108 * x1104
    x1190 = x1108 * x8
    x1191 = x1043 - x1190
    x1192 = x1189 + x1191
    x1193 = x1192 * x5
    x1194 = x108 * x1108
    x1195 = x1116 * x8
    x1196 = x1057 - x1195
    x1197 = x1194 + x1196
    x1198 = x1197 * x6
    x1199 = x1193 - x1198
    x1200 = x1199 * x5
    x1201 = x1071 - x1104 * x8
    x1202 = x108 * x1123 + x1201
    x1203 = -x1192 * x6 + x1202 * x5
    x1204 = x1075 + x1190
    x1205 = x4 * (-x1189 + x1202 + x1204)
    x1206 = -x1199 * x6 + x1205
    x1207 = x1203 * x5 + x1206
    x1208 = x1197 * x5
    x1209 = x108 * x1116
    x1210 = x1135 * x8
    x1211 = x1079 - x1210
    x1212 = x1209 + x1211
    x1213 = x1212 * x6
    x1214 = x1208 - x1213
    x1215 = x1214 * x6
    x1216 = x1092 + x1195
    x1217 = x4 * (x1192 - x1194 + x1216)
    x1218 = -x1217
    x1219 = x1215 + x1218
    x1220 = x1200 - x1215 + x1217
    x1221 = x1098 + x1210
    x1222 = x4 * (x1197 - x1209 + x1221)
    x1223 = x1096 - x1147 * x8
    x1224 = x108 * x1135 + x1223
    x1225 = x108 * x1151
    x1226 = x1154 * x8
    x1227 = -x1226
    x1228 = x1225 + x1227
    x1229 = x1228 * x5
    x1230 = x108 * x1154
    x1231 = x1160 * x8
    x1232 = -x1231
    x1233 = x1230 + x1232
    x1234 = x1233 * x6
    x1235 = x1229 - x1234
    x1236 = x1235 * x5
    x1237 = -x1151 * x8
    x1238 = x108 * x1166 + x1237
    x1239 = -x1228 * x6 + x1238 * x5
    x1240 = x4 * (-x1225 + x1226 + x1238)
    x1241 = -x1235 * x6 + x1240
    x1242 = x1239 * x5 + x1241
    x1243 = x1233 * x5
    x1244 = x108 * x1160
    x1245 = x1176 * x8
    x1246 = -x1245
    x1247 = x1244 + x1246
    x1248 = x1247 * x6
    x1249 = x1243 - x1248
    x1250 = x1249 * x6
    x1251 = x4 * (x1228 - x1230 + x1231)
    x1252 = -x1251
    x1253 = x1250 + x1252
    x1254 = x1236 - x1250 + x1251
    x1255 = x4 * (x1233 - x1244 + x1245)
    x1256 = -x1187 * x8
    x1257 = x108 * x1176 + x1256
    x1258 = x1039 * x409
    x1259 = x1258 + x602
    x1260 = x1259 * x5
    x1261 = x1039 * x414
    x1262 = x1261 + x609
    x1263 = x1262 * x6
    x1264 = x1260 - x1263
    x1265 = x1264 * x5
    x1266 = x1039 * x420 + x596
    x1267 = -x1259 * x6 + x1266 * x5
    x1268 = x4 * (-x1258 + x1266 + x600)
    x1269 = -x1264 * x6 + x1268
    x1270 = x1267 * x5 + x1269
    x1271 = x1262 * x5
    x1272 = x1039 * x431
    x1273 = x1272 + x615
    x1274 = x1273 * x6
    x1275 = x1271 - x1274
    x1276 = x1275 * x6
    x1277 = x4 * (x1259 - x1261 + x619)
    x1278 = -x1277
    x1279 = x1276 + x1278
    x1280 = x1265 - x1276 + x1277
    x1281 = x4 * (x1262 - x1272 + x635)
    x1282 = x1039 * x451 + x637
    x1283 = 2.0 * x1124 - x1192 * x8
    x1284 = x108 * x1202 + x1283
    x1285 = x108 * x1197
    x1286 = x1212 * x8
    x1287 = 2.0 * x1129
    x1288 = -x1286 + x1287
    x1289 = x1285 + x1288
    x1290 = x1289 * x6
    x1291 = x108 * x1192
    x1292 = x1197 * x8
    x1293 = 2.0 * x1105
    x1294 = -x1292 + x1293
    x1295 = x1291 + x1294
    x1296 = -x1295 * x6
    x1297 = x1295 * x5
    x1298 = x1284 * x5 + x1296
    x1299 = x1292 - x1293
    x1300 = x4 * (x1284 - x1291 + x1299)
    x1301 = -x1290 + x1297
    x1302 = x1286 - x1287
    x1303 = x4 * (-x1285 + x1295 + x1302)
    x1304 = 2.0 * x1145 - x1224 * x8
    x1305 = x108 * x1212 + x1304
    x1306 = x1167 - x1228 * x8
    x1307 = x108 * x1238 + x1306
    x1308 = x108 * x1233
    x1309 = x1247 * x8
    x1310 = x1172 - x1309
    x1311 = x1308 + x1310
    x1312 = x1311 * x6
    x1313 = x108 * x1228
    x1314 = x1233 * x8
    x1315 = x1152 - x1314
    x1316 = x1313 + x1315
    x1317 = -x1316 * x6
    x1318 = x1316 * x5
    x1319 = x1307 * x5 + x1317
    x1320 = x1185 + x1314
    x1321 = x4 * (x1307 - x1313 + x1320)
    x1322 = -x1312 + x1318
    x1323 = x1188 + x1309
    x1324 = x4 * (-x1308 + x1316 + x1323)
    x1325 = x1186 - x1257 * x8
    x1326 = x108 * x1247 + x1325
    x1327 = -x1259 * x8
    x1328 = x108 * x1266 + x1327
    x1329 = x108 * x1262
    x1330 = x1273 * x8
    x1331 = -x1330
    x1332 = x1329 + x1331
    x1333 = x1332 * x6
    x1334 = x108 * x1259
    x1335 = x1262 * x8
    x1336 = -x1335
    x1337 = x1334 + x1336
    x1338 = -x1337 * x6
    x1339 = x1337 * x5
    x1340 = x1328 * x5 + x1338
    x1341 = x4 * (x1328 - x1334 + x1335)
    x1342 = -x1333 + x1339
    x1343 = x4 * (-x1329 + x1330 + x1337)
    x1344 = -x1282 * x8
    x1345 = x108 * x1273 + x1344
    x1346 = x1039 * x597 + x722
    x1347 = x1039 * x610
    x1348 = x1347 + x735
    x1349 = x1348 * x6
    x1350 = x1039 * x603
    x1351 = x1350 + x728
    x1352 = -x1351 * x6
    x1353 = x1351 * x5
    x1354 = x1346 * x5 + x1352
    x1355 = x4 * (x1346 - x1350 + x726)
    x1356 = -x1349 + x1353
    x1357 = x4 * (-x1347 + x1351 + x739)
    x1358 = x1039 * x616 + x741
    x1359 = x108 * x1295
    x1360 = 3.0 * x1205 - x1295 * x8
    x1361 = x108 * x1284 + x1360
    x1362 = x1289 * x8
    x1363 = 3.0 * x1217
    x1364 = x1362 - x1363
    x1365 = x4 * (-x1359 + x1361 + x1364)
    x1366 = -x1362 + x1363
    x1367 = x1359 + x1366
    x1368 = 3.0 * x1222 - x1305 * x8
    x1369 = x108 * x1289 + x1368
    x1370 = x108 * x1316
    x1371 = 2.0 * x1240 - x1316 * x8
    x1372 = x108 * x1307 + x1371
    x1373 = x1311 * x8
    x1374 = 2.0 * x1251
    x1375 = x1373 - x1374
    x1376 = x4 * (-x1370 + x1372 + x1375)
    x1377 = -x1373 + x1374
    x1378 = x1370 + x1377
    x1379 = 2.0 * x1255 - x1326 * x8
    x1380 = x108 * x1311 + x1379
    x1381 = x108 * x1337
    x1382 = x1268 - x1337 * x8
    x1383 = x108 * x1328 + x1382
    x1384 = x1332 * x8
    x1385 = x1278 + x1384
    x1386 = x4 * (-x1381 + x1383 + x1385)
    x1387 = x1277 - x1384
    x1388 = x1381 + x1387
    x1389 = x1281 - x1345 * x8
    x1390 = x108 * x1332 + x1389
    x1391 = x1348 * x8
    x1392 = x108 * x1351
    x1393 = -x1351 * x8
    x1394 = x108 * x1346 + x1393
    x1395 = x4 * (x1391 - x1392 + x1394)
    x1396 = -x1391
    x1397 = x1392 + x1396
    x1398 = -x1358 * x8
    x1399 = x108 * x1348 + x1398
    x1400 = x10 * x736
    x1401 = x1039 * x729
    x1402 = 4.0 * x620
    x1403 = -x10 * x729 + x1039 * x723 + 4.0 * x601
    x1404 = x4 * (x1400 - x1401 - x1402 + x1403)
    x1405 = -x1400 + x1401 + x1402
    x1406 = -x10 * x742 + x1039 * x736 + 4.0 * x636
    x1407 = x749 * x8
    x1408 = x743 * x746
    x1409 = x42 + x743 * x774 - x746 * x8
    x1410 = x4 * (x1407 - x1408 + x1409 + x47)
    x1411 = -x1407 + x1408 + x15
    x1412 = x1409 * x5 - x1411 * x6
    x1413 = x1411 * x5
    x1414 = x743 * x749
    x1415 = x755 * x8
    x1416 = x1414 - x1415 + x27
    x1417 = x1416 * x6
    x1418 = x1413 - x1417
    x1419 = x1410 + x1412 * x5 - x1418 * x6
    x1420 = x4 * (x1411 - x1414 + x1415 + x64)
    x1421 = x1418 * x5
    x1422 = x1416 * x5
    x1423 = x743 * x755
    x1424 = x765 * x8
    x1425 = x1423 - x1424 + x52
    x1426 = x1425 * x6
    x1427 = x1422 - x1426
    x1428 = x1427 * x6
    x1429 = x1420 + x1421 - x1428
    x1430 = x1419 * x5 - x1429 * x6 + x36 * (x1412 - x1413 + x1417)
    x1431 = x1429 * x5
    x1432 = x4 * (x1416 - x1423 + x1424 + x87)
    x1433 = x1427 * x5
    x1434 = x1425 * x5
    x1435 = x743 * x765
    x1436 = x787 * x8
    x1437 = x1435 - x1436 + x75
    x1438 = x1437 * x6
    x1439 = x1434 - x1438
    x1440 = x1439 * x6
    x1441 = x1432 + x1433 - x1440
    x1442 = x1441 * x6
    x1443 = x36 * (x1418 - x1422 + x1426)
    x1444 = x1431 - x1442 + x1443
    x1445 = -x1420
    x1446 = x4 * (x102 + x1425 - x1435 + x1436)
    x1447 = x100 + x743 * x787 - x8 * x801
    x1448 = -x1432
    x1449 = x8 * x808
    x1450 = x743 * x805
    x1451 = x134 + x743 * x820 + x775 - x8 * x805
    x1452 = x4 * (x1449 - x1450 + x1451 + x155 + x779)
    x1453 = x119 - x1449 + x1450 + x747
    x1454 = x1451 * x5 - x1453 * x6
    x1455 = x1453 * x5
    x1456 = x743 * x808
    x1457 = x8 * x814
    x1458 = x139 + x1456 - x1457 + x761
    x1459 = x1458 * x6
    x1460 = x1455 - x1459
    x1461 = x1452 + x1454 * x5 - x1460 * x6
    x1462 = x4 * (x1453 - x1456 + x1457 + x177 + x796)
    x1463 = x1460 * x5
    x1464 = x1458 * x5
    x1465 = x743 * x814
    x1466 = x8 * x830
    x1467 = x1465 - x1466 + x161 + x783
    x1468 = x1467 * x6
    x1469 = x1464 - x1468
    x1470 = x1469 * x6
    x1471 = x1462 + x1463 - x1470
    x1472 = x4 * (x1458 - x1465 + x1466 + x188 + x802)
    x1473 = x185 + x743 * x830 - x8 * x840 + x800
    x1474 = x8 * x846
    x1475 = x743 * x843
    x1476 = x220 + x743 * x858 - x8 * x843
    x1477 = x4 * (x1474 - x1475 + x1476 + x241)
    x1478 = -x1474 + x1475 + x205
    x1479 = x1476 * x5 - x1478 * x6
    x1480 = x1478 * x5
    x1481 = x743 * x846
    x1482 = x8 * x852
    x1483 = x1481 - x1482 + x225
    x1484 = x1483 * x6
    x1485 = x1480 - x1484
    x1486 = x1477 + x1479 * x5 - x1485 * x6
    x1487 = x4 * (x1478 - x1481 + x1482 + x263)
    x1488 = x1485 * x5
    x1489 = x1483 * x5
    x1490 = x743 * x852
    x1491 = x8 * x868
    x1492 = x1490 - x1491 + x247
    x1493 = x1492 * x6
    x1494 = x1489 - x1493
    x1495 = x1494 * x6
    x1496 = x1487 + x1488 - x1495
    x1497 = x4 * (x1483 - x1490 + x1491 + x274)
    x1498 = x271 + x743 * x868 - x8 * x879
    x1499 = -x1487
    x1500 = x8 * x885
    x1501 = x743 * x882
    x1502 = 2.0 * x806
    x1503 = -x1502
    x1504 = 2.0 * x821
    x1505 = x1504 + x296 + x743 * x889 - x8 * x882
    x1506 = x4 * (x1500 - x1501 + x1503 + x1505 + x309)
    x1507 = -x1500 + x1501 + x1502 + x308
    x1508 = x1505 * x5 - x1507 * x6
    x1509 = x1507 * x5
    x1510 = x743 * x885
    x1511 = x8 * x896
    x1512 = 2.0 * x826
    x1513 = x1510 - x1511 + x1512 + x318
    x1514 = x1513 * x6
    x1515 = x1509 - x1514
    x1516 = -x1512
    x1517 = x4 * (x1507 - x1510 + x1511 + x1516 + x335)
    x1518 = 2.0 * x839
    x1519 = x1518 + x338 + x743 * x896 - x8 * x904
    x1520 = x8 * x909
    x1521 = x743 * x906
    x1522 = x361 + x743 * x913 - x8 * x906 + x859
    x1523 = x4 * (x1520 - x1521 + x1522 + x373 + x877)
    x1524 = -x1520 + x1521 + x372 + x844
    x1525 = x1522 * x5 - x1524 * x6
    x1526 = x1524 * x5
    x1527 = x743 * x909
    x1528 = x8 * x920
    x1529 = x1527 - x1528 + x381 + x864
    x1530 = x1529 * x6
    x1531 = x1526 - x1530
    x1532 = x4 * (x1524 - x1527 + x1528 + x398 + x880)
    x1533 = x400 + x743 * x920 - x8 * x928 + x878
    x1534 = x8 * x933
    x1535 = x743 * x930
    x1536 = x424 + x743 * x937 - x8 * x930
    x1537 = x4 * (x1534 - x1535 + x1536 + x437)
    x1538 = -x1534 + x1535 + x436
    x1539 = x1536 * x5 - x1538 * x6
    x1540 = x1538 * x5
    x1541 = x743 * x933
    x1542 = x8 * x944
    x1543 = x1541 - x1542 + x446
    x1544 = x1543 * x6
    x1545 = x1540 - x1544
    x1546 = x4 * (x1538 - x1541 + x1542 + x463)
    x1547 = x466 + x743 * x944 - x8 * x953
    x1548 = x8 * x956
    x1549 = x743 * x959
    x1550 = 3.0 * x900
    x1551 = x478 + x743 * x954 - x8 * x959 + 3.0 * x891
    x1552 = x4 * (x1548 - x1549 - x1550 + x1551 + x498)
    x1553 = -x1548 + x1549 + x1550 + x497
    x1554 = x513 + x743 * x956 - x8 * x966 + 3.0 * x903
    x1555 = x8 * x969
    x1556 = x743 * x972
    x1557 = 2.0 * x924
    x1558 = -x1557
    x1559 = 2.0 * x915
    x1560 = x1559 + x521 + x743 * x967 - x8 * x972
    x1561 = x4 * (x1555 - x1556 + x1558 + x1560 + x539)
    x1562 = -x1555 + x1556 + x1557 + x538
    x1563 = 2.0 * x927
    x1564 = x1563 + x554 + x743 * x969 - x8 * x979
    x1565 = x8 * x982
    x1566 = x743 * x985
    x1567 = x561 + x743 * x980 - x8 * x985 + x939
    x1568 = x4 * (x1565 - x1566 + x1567 + x578 + x949)
    x1569 = -x1565 + x1566 + x577 + x948
    x1570 = x592 + x743 * x982 - x8 * x992 + x952
    x1571 = x8 * x995
    x1572 = x743 * x998
    x1573 = x601 + x743 * x993 - x8 * x998
    x1574 = x4 * (x1571 - x1572 + x1573 + x621)
    x1575 = -x1571 + x1572 + x620
    x1576 = -x1005 * x8 + x636 + x743 * x995
    x1577 = x1009 * x743 - x1011 * x8 + x645 + 4.0 * x963
    x1578 = x1011 * x743 - x1012 * x8 + x658 + 4.0 * x965
    x1579 = x1016 * x743 - x1018 * x8 + x667 + 3.0 * x976
    x1580 = x1018 * x743 - x1019 * x8 + x680 + 3.0 * x978
    x1581 = 2.0 * x989
    x1582 = x1023 * x743 - x1025 * x8 + x1581 + x688
    x1583 = 2.0 * x991
    x1584 = x1025 * x743 - x1026 * x8 + x1583 + x700
    x1585 = x1002 + x1029 * x743 - x1031 * x8 + x707
    x1586 = x1004 + x1031 * x743 - x1032 * x8 + x718
    x1587 = x1035 * x743 - x1037 * x8 + x727
    x1588 = x1037 * x743 - x1038 * x8 + x740
    x1589 = x1042 * x743
    x1590 = x1070 * x743 + x1122
    x1591 = x4 * (x1102 - x1589 + x1590)
    x1592 = x1103 + x1589
    x1593 = x1590 * x5 - x1592 * x6
    x1594 = x1592 * x5
    x1595 = x1045 * x743
    x1596 = x1107 + x1595
    x1597 = x1596 * x6
    x1598 = x1594 - x1597
    x1599 = x1591 + x1593 * x5 - x1598 * x6
    x1600 = x4 * (x1099 + x1592 - x1595)
    x1601 = x1598 * x5
    x1602 = x1596 * x5
    x1603 = x1051 * x743
    x1604 = x1115 + x1603
    x1605 = x1604 * x6
    x1606 = x1602 - x1605
    x1607 = x1606 * x6
    x1608 = x1600 + x1601 - x1607
    x1609 = x1599 * x5 - x1608 * x6 + x36 * (x1593 - x1594 + x1597)
    x1610 = x1608 * x5
    x1611 = x4 * (x1114 + x1596 - x1603)
    x1612 = x1606 * x5
    x1613 = x1604 * x5
    x1614 = x1061 * x743
    x1615 = x1134 + x1614
    x1616 = x1615 * x6
    x1617 = x1613 - x1616
    x1618 = x1617 * x6
    x1619 = x1611 + x1612 - x1618
    x1620 = x1619 * x6
    x1621 = x36 * (x1598 - x1602 + x1605)
    x1622 = x1610 - x1620 + x1621
    x1623 = -x1600
    x1624 = x4 * (x1133 + x1604 - x1614)
    x1625 = x1083 * x743 + x1146
    x1626 = -x1611
    x1627 = x1104 * x743
    x1628 = x1123 * x743 + x1201
    x1629 = x4 * (x1204 - x1627 + x1628)
    x1630 = x1191 + x1627
    x1631 = x1628 * x5 - x1630 * x6
    x1632 = x1630 * x5
    x1633 = x1108 * x743
    x1634 = x1196 + x1633
    x1635 = x1634 * x6
    x1636 = x1632 - x1635
    x1637 = x1629 + x1631 * x5 - x1636 * x6
    x1638 = x4 * (x1216 + x1630 - x1633)
    x1639 = x1636 * x5
    x1640 = x1634 * x5
    x1641 = x1116 * x743
    x1642 = x1211 + x1641
    x1643 = x1642 * x6
    x1644 = x1640 - x1643
    x1645 = x1644 * x6
    x1646 = x1638 + x1639 - x1645
    x1647 = x4 * (x1221 + x1634 - x1641)
    x1648 = x1135 * x743 + x1223
    x1649 = x1151 * x743
    x1650 = x1166 * x743 + x1237
    x1651 = x4 * (x1226 - x1649 + x1650)
    x1652 = x1227 + x1649
    x1653 = x1650 * x5 - x1652 * x6
    x1654 = x1652 * x5
    x1655 = x1154 * x743
    x1656 = x1232 + x1655
    x1657 = x1656 * x6
    x1658 = x1654 - x1657
    x1659 = x1651 + x1653 * x5 - x1658 * x6
    x1660 = x4 * (x1231 + x1652 - x1655)
    x1661 = x1658 * x5
    x1662 = x1656 * x5
    x1663 = x1160 * x743
    x1664 = x1246 + x1663
    x1665 = x1664 * x6
    x1666 = x1662 - x1665
    x1667 = x1666 * x6
    x1668 = x1660 + x1661 - x1667
    x1669 = x4 * (x1245 + x1656 - x1663)
    x1670 = x1176 * x743 + x1256
    x1671 = -x1660
    x1672 = x1192 * x743
    x1673 = x1202 * x743 + x1283
    x1674 = x4 * (x1299 - x1672 + x1673)
    x1675 = x1294 + x1672
    x1676 = x1673 * x5 - x1675 * x6
    x1677 = x1675 * x5
    x1678 = x1197 * x743
    x1679 = x1288 + x1678
    x1680 = x1679 * x6
    x1681 = x1677 - x1680
    x1682 = x4 * (x1302 + x1675 - x1678)
    x1683 = x1212 * x743 + x1304
    x1684 = x1228 * x743
    x1685 = x1238 * x743 + x1306
    x1686 = x4 * (x1320 - x1684 + x1685)
    x1687 = x1315 + x1684
    x1688 = x1685 * x5 - x1687 * x6
    x1689 = x1687 * x5
    x1690 = x1233 * x743
    x1691 = x1310 + x1690
    x1692 = x1691 * x6
    x1693 = x1689 - x1692
    x1694 = x4 * (x1323 + x1687 - x1690)
    x1695 = x1247 * x743 + x1325
    x1696 = x1259 * x743
    x1697 = x1266 * x743 + x1327
    x1698 = x4 * (x1335 - x1696 + x1697)
    x1699 = x1336 + x1696
    x1700 = x1697 * x5 - x1699 * x6
    x1701 = x1699 * x5
    x1702 = x1262 * x743
    x1703 = x1331 + x1702
    x1704 = x1703 * x6
    x1705 = x1701 - x1704
    x1706 = x4 * (x1330 + x1699 - x1702)
    x1707 = x1273 * x743 + x1344
    x1708 = x1295 * x743
    x1709 = x1284 * x743 + x1360
    x1710 = x4 * (x1364 - x1708 + x1709)
    x1711 = x1366 + x1708
    x1712 = x1289 * x743 + x1368
    x1713 = x1316 * x743
    x1714 = x1307 * x743 + x1371
    x1715 = x4 * (x1375 - x1713 + x1714)
    x1716 = x1377 + x1713
    x1717 = x1311 * x743 + x1379
    x1718 = x1337 * x743
    x1719 = x1328 * x743 + x1382
    x1720 = x4 * (x1385 - x1718 + x1719)
    x1721 = x1387 + x1718
    x1722 = x1332 * x743 + x1389
    x1723 = x1351 * x743
    x1724 = x1346 * x743 + x1393
    x1725 = x4 * (x1391 - x1723 + x1724)
    x1726 = x1396 + x1723
    x1727 = x1348 * x743 + x1398
    x1728 = 4.0 * x1300 + x1361 * x743 - x1367 * x8
    x1729 = 4.0 * x1303 + x1367 * x743 - x1369 * x8
    x1730 = 3.0 * x1321 + x1372 * x743 - x1378 * x8
    x1731 = 3.0 * x1324 + x1378 * x743 - x1380 * x8
    x1732 = 2.0 * x1341 + x1383 * x743 - x1388 * x8
    x1733 = 2.0 * x1343 + x1388 * x743 - x1390 * x8
    x1734 = x1355 + x1394 * x743 - x1397 * x8
    x1735 = x1357 + x1397 * x743 - x1399 * x8
    x1736 = x1403 * x743 - x1405 * x8
    x1737 = x1405 * x743 - x1406 * x8
    x1738 = x10 * x1045
    x1739 = x1039 * x1042
    x1740 = -x10 * x1042 + x1039 * x1070 + x42
    x1741 = x4 * (x1738 - x1739 + x1740 + x47)
    x1742 = x15 - x1738 + x1739
    x1743 = x1740 * x5 - x1742 * x6
    x1744 = x1742 * x5
    x1745 = x1039 * x1045
    x1746 = x10 * x1051
    x1747 = x1745 - x1746 + x27
    x1748 = x1747 * x6
    x1749 = x1744 - x1748
    x1750 = x1741 + x1743 * x5 - x1749 * x6
    x1751 = x4 * (x1742 - x1745 + x1746 + x64)
    x1752 = x1749 * x5
    x1753 = x1747 * x5
    x1754 = x1039 * x1051
    x1755 = x10 * x1061
    x1756 = x1754 - x1755 + x52
    x1757 = x1756 * x6
    x1758 = x1753 - x1757
    x1759 = x1758 * x6
    x1760 = x1751 + x1752 - x1759
    x1761 = x1750 * x5 - x1760 * x6 + x36 * (x1743 - x1744 + x1748)
    x1762 = x1760 * x5
    x1763 = x4 * (x1747 - x1754 + x1755 + x87)
    x1764 = x1758 * x5
    x1765 = x1756 * x5
    x1766 = x1039 * x1061
    x1767 = x10 * x1083
    x1768 = x1766 - x1767 + x75
    x1769 = x1768 * x6
    x1770 = x1765 - x1769
    x1771 = x1770 * x6
    x1772 = x1763 + x1764 - x1771
    x1773 = x1772 * x6
    x1774 = x36 * (x1749 - x1753 + x1757)
    x1775 = x1762 - x1773 + x1774
    x1776 = -x1751
    x1777 = x4 * (x102 + x1756 - x1766 + x1767)
    x1778 = -x10 * x1097 + x100 + x1039 * x1083
    x1779 = -x1763
    x1780 = x1747 * x8
    x1781 = x108 * x1742
    x1782 = -x1742 * x8
    x1783 = x108 * x1740 + x1782
    x1784 = x4 * (x1780 - x1781 + x1783)
    x1785 = -x1780
    x1786 = x1781 + x1785
    x1787 = x1783 * x5 - x1786 * x6
    x1788 = x1786 * x5
    x1789 = x108 * x1747
    x1790 = x1756 * x8
    x1791 = -x1790
    x1792 = x1789 + x1791
    x1793 = x1792 * x6
    x1794 = x1788 - x1793
    x1795 = x1784 + x1787 * x5 - x1794 * x6
    x1796 = x4 * (x1786 - x1789 + x1790)
    x1797 = x1794 * x5
    x1798 = x1792 * x5
    x1799 = x108 * x1756
    x1800 = x1768 * x8
    x1801 = -x1800
    x1802 = x1799 + x1801
    x1803 = x1802 * x6
    x1804 = x1798 - x1803
    x1805 = x1804 * x6
    x1806 = x1796 + x1797 - x1805
    x1807 = x4 * (x1792 - x1799 + x1800)
    x1808 = -x1778 * x8
    x1809 = x108 * x1768 + x1808
    x1810 = x10 * x1154
    x1811 = x1039 * x1151
    x1812 = -x10 * x1151 + x1039 * x1166 + x1071 + x220
    x1813 = x4 * (x1075 + x1810 - x1811 + x1812 + x241)
    x1814 = x1043 - x1810 + x1811 + x205
    x1815 = x1812 * x5 - x1814 * x6
    x1816 = x1814 * x5
    x1817 = x1039 * x1154
    x1818 = x10 * x1160
    x1819 = x1057 + x1817 - x1818 + x225
    x1820 = x1819 * x6
    x1821 = x1816 - x1820
    x1822 = x1813 + x1815 * x5 - x1821 * x6
    x1823 = x4 * (x1092 + x1814 - x1817 + x1818 + x263)
    x1824 = x1821 * x5
    x1825 = x1819 * x5
    x1826 = x1039 * x1160
    x1827 = x10 * x1176
    x1828 = x1079 + x1826 - x1827 + x247
    x1829 = x1828 * x6
    x1830 = x1825 - x1829
    x1831 = x1830 * x6
    x1832 = x1823 + x1824 - x1831
    x1833 = x4 * (x1098 + x1819 - x1826 + x1827 + x274)
    x1834 = -x10 * x1187 + x1039 * x1176 + x1096 + x271
    x1835 = -x1823
    x1836 = x108 * x1786
    x1837 = x1741 - x1786 * x8
    x1838 = x108 * x1783 + x1837
    x1839 = x1792 * x8
    x1840 = x1776 + x1839
    x1841 = x4 * (-x1836 + x1838 + x1840)
    x1842 = x1751 - x1839
    x1843 = x1836 + x1842
    x1844 = x1838 * x5 - x1843 * x6
    x1845 = x1843 * x5
    x1846 = x108 * x1792
    x1847 = x1802 * x8
    x1848 = x1763 - x1847
    x1849 = x1846 + x1848
    x1850 = x1849 * x6
    x1851 = x1845 - x1850
    x1852 = x1779 + x1847
    x1853 = x4 * (x1843 - x1846 + x1852)
    x1854 = x1777 - x1809 * x8
    x1855 = x108 * x1802 + x1854
    x1856 = x1819 * x8
    x1857 = x108 * x1814
    x1858 = -x1814 * x8
    x1859 = x108 * x1812 + x1858
    x1860 = x4 * (x1856 - x1857 + x1859)
    x1861 = -x1856
    x1862 = x1857 + x1861
    x1863 = x1859 * x5 - x1862 * x6
    x1864 = x1862 * x5
    x1865 = x108 * x1819
    x1866 = x1828 * x8
    x1867 = -x1866
    x1868 = x1865 + x1867
    x1869 = x1868 * x6
    x1870 = x1864 - x1869
    x1871 = x4 * (x1862 - x1865 + x1866)
    x1872 = -x1834 * x8
    x1873 = x108 * x1828 + x1872
    x1874 = x10 * x1262
    x1875 = x1039 * x1259
    x1876 = 2.0 * x1152
    x1877 = -x1876
    x1878 = 2.0 * x1167
    x1879 = -x10 * x1259 + x1039 * x1266 + x1878 + x424
    x1880 = x4 * (x1874 - x1875 + x1877 + x1879 + x437)
    x1881 = -x1874 + x1875 + x1876 + x436
    x1882 = x1879 * x5 - x1881 * x6
    x1883 = x1881 * x5
    x1884 = x1039 * x1262
    x1885 = x10 * x1273
    x1886 = 2.0 * x1172
    x1887 = x1884 - x1885 + x1886 + x446
    x1888 = x1887 * x6
    x1889 = x1883 - x1888
    x1890 = -x1886
    x1891 = x4 * (x1881 - x1884 + x1885 + x1890 + x463)
    x1892 = 2.0 * x1186
    x1893 = -x10 * x1282 + x1039 * x1273 + x1892 + x466
    x1894 = x108 * x1843
    x1895 = 2.0 * x1784 - x1843 * x8
    x1896 = x108 * x1838 + x1895
    x1897 = x1849 * x8
    x1898 = 2.0 * x1796
    x1899 = x1897 - x1898
    x1900 = x4 * (-x1894 + x1896 + x1899)
    x1901 = -x1897 + x1898
    x1902 = x1894 + x1901
    x1903 = 2.0 * x1807 - x1855 * x8
    x1904 = x108 * x1849 + x1903
    x1905 = x108 * x1862
    x1906 = x1813 - x1862 * x8
    x1907 = x108 * x1859 + x1906
    x1908 = x1868 * x8
    x1909 = x1835 + x1908
    x1910 = x4 * (-x1905 + x1907 + x1909)
    x1911 = x1823 - x1908
    x1912 = x1905 + x1911
    x1913 = x1833 - x1873 * x8
    x1914 = x108 * x1868 + x1913
    x1915 = x1887 * x8
    x1916 = x108 * x1881
    x1917 = -x1881 * x8
    x1918 = x108 * x1879 + x1917
    x1919 = x4 * (x1915 - x1916 + x1918)
    x1920 = -x1915
    x1921 = x1916 + x1920
    x1922 = -x1893 * x8
    x1923 = x108 * x1887 + x1922
    x1924 = x10 * x1348
    x1925 = x1039 * x1351
    x1926 = 3.0 * x1277
    x1927 = -x10 * x1351 + x1039 * x1346 + 3.0 * x1268 + x601
    x1928 = x4 * (x1924 - x1925 - x1926 + x1927 + x621)
    x1929 = -x1924 + x1925 + x1926 + x620
    x1930 = -x10 * x1358 + x1039 * x1348 + 3.0 * x1281 + x636
    x1931 = 3.0 * x1841 - x1902 * x8
    x1932 = x108 * x1896 + x1931
    x1933 = 3.0 * x1853 - x1904 * x8
    x1934 = x108 * x1902 + x1933
    x1935 = 2.0 * x1860 - x1912 * x8
    x1936 = x108 * x1907 + x1935
    x1937 = 2.0 * x1871 - x1914 * x8
    x1938 = x108 * x1912 + x1937
    x1939 = x1880 - x1921 * x8
    x1940 = x108 * x1918 + x1939
    x1941 = x1891 - x1923 * x8
    x1942 = x108 * x1921 + x1941
    x1943 = -x1929 * x8
    x1944 = x108 * x1927 + x1943
    x1945 = -x1930 * x8
    x1946 = x108 * x1929 + x1945
    x1947 = -x10 * x1405 + x1039 * x1403 + 4.0 * x1355 + x727
    x1948 = -x10 * x1406 + x1039 * x1405 + 4.0 * x1357 + x740
    x1949 = x1416 * x8
    x1950 = x1411 * x743
    x1951 = 2.0 * x747
    x1952 = x1409 * x743 - x1411 * x8 + 2.0 * x775
    x1953 = -x1949 + x1950 + x1951
    x1954 = x1952 * x5 - x1953 * x6
    x1955 = x1953 * x5
    x1956 = x1416 * x743
    x1957 = x1425 * x8
    x1958 = 2.0 * x761
    x1959 = x1956 - x1957 + x1958
    x1960 = x1959 * x6
    x1961 = x1955 - x1960
    x1962 = x1954 * x5 - x1961 * x6 + x4 * (x1949 - x1950 - x1951 + x1952)
    x1963 = x4 * (x1953 - x1956 + x1957 - x1958)
    x1964 = x1961 * x5
    x1965 = x1959 * x5
    x1966 = x1425 * x743
    x1967 = x1437 * x8
    x1968 = 2.0 * x783
    x1969 = x1966 - x1967 + x1968
    x1970 = x1969 * x6
    x1971 = x1965 - x1970
    x1972 = x1971 * x6
    x1973 = x1963 + x1964 - x1972
    x1974 = x1458 * x8
    x1975 = x1453 * x743
    x1976 = x1410 + x1451 * x743 - x1453 * x8 + x1504
    x1977 = x1420 + x1502 - x1974 + x1975
    x1978 = x1976 * x5 - x1977 * x6
    x1979 = x1977 * x5
    x1980 = x1458 * x743
    x1981 = x1467 * x8
    x1982 = x1432 + x1512 + x1980 - x1981
    x1983 = x1982 * x6
    x1984 = x1979 - x1983
    x1985 = x1483 * x8
    x1986 = x1478 * x743
    x1987 = 2.0 * x844
    x1988 = x1476 * x743 - x1478 * x8 + 2.0 * x859
    x1989 = -x1985 + x1986 + x1987
    x1990 = x1988 * x5 - x1989 * x6
    x1991 = x1989 * x5
    x1992 = x1483 * x743
    x1993 = x1492 * x8
    x1994 = 2.0 * x864
    x1995 = x1992 - x1993 + x1994
    x1996 = x1995 * x6
    x1997 = x1991 - x1996
    x1998 = x1513 * x8
    x1999 = x1507 * x743
    x2000 = 2.0 * x900
    x2001 = 2.0 * x1462
    x2002 = 2.0 * x1452 + x1505 * x743 - x1507 * x8 + 2.0 * x891
    x2003 = -x1998 + x1999 + x2000 + x2001
    x2004 = x1529 * x8
    x2005 = x1524 * x743
    x2006 = x1477 + x1522 * x743 - x1524 * x8 + x1559
    x2007 = x1487 + x1557 - x2004 + x2005
    x2008 = x1543 * x8
    x2009 = x1538 * x743
    x2010 = 2.0 * x948
    x2011 = x1536 * x743 - x1538 * x8 + 2.0 * x939
    x2012 = -x2008 + x2009 + x2010
    x2013 = x1596 * x8
    x2014 = x1592 * x743
    x2015 = x1071 + x1590 * x743 - x1592 * x8
    x2016 = x1043 - x2013 + x2014
    x2017 = x2015 * x5 - x2016 * x6
    x2018 = x2016 * x5
    x2019 = x1596 * x743
    x2020 = x1604 * x8
    x2021 = x1057 + x2019 - x2020
    x2022 = x2021 * x6
    x2023 = x2018 - x2022
    x2024 = x2017 * x5 - x2023 * x6 + x4 * (x1075 + x2013 - x2014 + x2015)
    x2025 = x4 * (x1092 + x2016 - x2019 + x2020)
    x2026 = x2023 * x5
    x2027 = x2021 * x5
    x2028 = x1604 * x743
    x2029 = x1615 * x8
    x2030 = x1079 + x2028 - x2029
    x2031 = x2030 * x6
    x2032 = x2027 - x2031
    x2033 = x2032 * x6
    x2034 = x2025 + x2026 - x2033
    x2035 = x1634 * x8
    x2036 = x1630 * x743
    x2037 = x1124 + x1591 + x1628 * x743 - x1630 * x8
    x2038 = x1105 + x1600 - x2035 + x2036
    x2039 = x2037 * x5 - x2038 * x6
    x2040 = x2038 * x5
    x2041 = x1634 * x743
    x2042 = x1642 * x8
    x2043 = x1129 + x1611 + x2041 - x2042
    x2044 = x2043 * x6
    x2045 = x2040 - x2044
    x2046 = x1656 * x8
    x2047 = x1652 * x743
    x2048 = x1167 + x1650 * x743 - x1652 * x8
    x2049 = x1152 - x2046 + x2047
    x2050 = x2048 * x5 - x2049 * x6
    x2051 = x2049 * x5
    x2052 = x1656 * x743
    x2053 = x1664 * x8
    x2054 = x1172 + x2052 - x2053
    x2055 = x2054 * x6
    x2056 = x2051 - x2055
    x2057 = x1679 * x8
    x2058 = x1675 * x743
    x2059 = 2.0 * x1638
    x2060 = x1205 + 2.0 * x1629 + x1673 * x743 - x1675 * x8
    x2061 = x1217 - x2057 + x2058 + x2059
    x2062 = x1691 * x8
    x2063 = x1687 * x743
    x2064 = x1240 + x1651 + x1685 * x743 - x1687 * x8
    x2065 = x1251 + x1660 - x2062 + x2063
    x2066 = x1703 * x8
    x2067 = x1699 * x743
    x2068 = x1268 + x1697 * x743 - x1699 * x8
    x2069 = x1277 - x2066 + x2067
    x2070 = x1742 * x743
    x2071 = x1740 * x743 + x1782
    x2072 = x1785 + x2070
    x2073 = x2071 * x5 - x2072 * x6
    x2074 = x2072 * x5
    x2075 = x1747 * x743
    x2076 = x1791 + x2075
    x2077 = x2076 * x6
    x2078 = x2074 - x2077
    x2079 = x2073 * x5 - x2078 * x6 + x4 * (x1780 - x2070 + x2071)
    x2080 = x4 * (x1790 + x2072 - x2075)
    x2081 = x2078 * x5
    x2082 = x2076 * x5
    x2083 = x1756 * x743
    x2084 = x1801 + x2083
    x2085 = x2084 * x6
    x2086 = x2082 - x2085
    x2087 = x2086 * x6
    x2088 = x2080 + x2081 - x2087
    x2089 = x1786 * x743
    x2090 = x1783 * x743 + x1837
    x2091 = x1842 + x2089
    x2092 = x2090 * x5 - x2091 * x6
    x2093 = x2091 * x5
    x2094 = x1792 * x743
    x2095 = x1848 + x2094
    x2096 = x2095 * x6
    x2097 = x2093 - x2096
    x2098 = x1814 * x743
    x2099 = x1812 * x743 + x1858
    x2100 = x1861 + x2098
    x2101 = x2099 * x5 - x2100 * x6
    x2102 = x2100 * x5
    x2103 = x1819 * x743
    x2104 = x1867 + x2103
    x2105 = x2104 * x6
    x2106 = x2102 - x2105
    x2107 = x1843 * x743
    x2108 = x1838 * x743 + x1895
    x2109 = x1901 + x2107
    x2110 = x1862 * x743
    x2111 = x1859 * x743 + x1906
    x2112 = x1911 + x2110
    x2113 = x1881 * x743
    x2114 = x1879 * x743 + x1917
    x2115 = x1920 + x2113
    x2116 = x10 * x1747
    x2117 = x1039 * x1742
    x2118 = 2.0 * x1043
    x2119 = -x10 * x1742 + x1039 * x1740 + 2.0 * x1071
    x2120 = x4 * (x2116 - x2117 - x2118 + x2119)
    x2121 = -x2116 + x2117 + x2118
    x2122 = x2119 * x5 - x2121 * x6
    x2123 = x2121 * x5
    x2124 = x1039 * x1747
    x2125 = x10 * x1756
    x2126 = 2.0 * x1057
    x2127 = x2124 - x2125 + x2126
    x2128 = x2127 * x6
    x2129 = x2123 - x2128
    x2130 = x2120 + x2122 * x5 - x2129 * x6
    x2131 = x4 * (x2121 - x2124 + x2125 - x2126)
    x2132 = x2129 * x5
    x2133 = x2127 * x5
    x2134 = x1039 * x1756
    x2135 = x10 * x1768
    x2136 = 2.0 * x1079
    x2137 = x2134 - x2135 + x2136
    x2138 = x2137 * x6
    x2139 = x2133 - x2138
    x2140 = x2139 * x6
    x2141 = x2131 + x2132 - x2140
    x2142 = x4 * (x2127 - x2134 + x2135 - x2136)
    x2143 = -x10 * x1778 + x1039 * x1768 + 2.0 * x1096
    x2144 = -x2131
    x2145 = x2127 * x8
    x2146 = x108 * x2121
    x2147 = x108 * x2119 - x2121 * x8
    x2148 = x4 * (x2145 - x2146 + x2147)
    x2149 = -x2145 + x2146
    x2150 = x2147 * x5 - x2149 * x6
    x2151 = x2149 * x5
    x2152 = x108 * x2127
    x2153 = x2137 * x8
    x2154 = x2152 - x2153
    x2155 = x2154 * x6
    x2156 = x2151 - x2155
    x2157 = x4 * (x2149 - x2152 + x2153)
    x2158 = x108 * x2137 - x2143 * x8
    x2159 = x10 * x1819
    x2160 = x1039 * x1814
    x2161 = -x10 * x1814 + x1039 * x1812 + x1741 + x1878
    x2162 = x4 * (x1776 + x1877 + x2159 - x2160 + x2161)
    x2163 = x1751 + x1876 - x2159 + x2160
    x2164 = x2161 * x5 - x2163 * x6
    x2165 = x2163 * x5
    x2166 = x1039 * x1819
    x2167 = x10 * x1828
    x2168 = x1763 + x1886 + x2166 - x2167
    x2169 = x2168 * x6
    x2170 = x2165 - x2169
    x2171 = x4 * (x1779 + x1890 + x2163 - x2166 + x2167)
    x2172 = -x10 * x1834 + x1039 * x1828 + x1777 + x1892
    x2173 = x2154 * x8
    x2174 = x108 * x2149
    x2175 = x108 * x2147 + x2120 - x2149 * x8
    x2176 = x4 * (x2144 + x2173 - x2174 + x2175)
    x2177 = x2131 - x2173 + x2174
    x2178 = x108 * x2154 + x2142 - x2158 * x8
    x2179 = x2168 * x8
    x2180 = x108 * x2163
    x2181 = x108 * x2161 - x2163 * x8
    x2182 = x4 * (x2179 - x2180 + x2181)
    x2183 = -x2179 + x2180
    x2184 = x108 * x2168 - x2172 * x8
    x2185 = x10 * x1887
    x2186 = x1039 * x1881
    x2187 = 2.0 * x1277
    x2188 = 2.0 * x1823
    x2189 = -x10 * x1881 + x1039 * x1879 + 2.0 * x1268 + 2.0 * x1813
    x2190 = x4 * (x2185 - x2186 - x2187 - x2188 + x2189)
    x2191 = -x2185 + x2186 + x2187 + x2188
    x2192 = -x10 * x1893 + x1039 * x1887 + 2.0 * x1281 + 2.0 * x1833
    x2193 = x108 * x2175 + 2.0 * x2148 - x2177 * x8
    x2194 = x108 * x2177 + 2.0 * x2157 - x2178 * x8
    x2195 = x108 * x2181 + x2162 - x2183 * x8
    x2196 = x108 * x2183 + x2171 - x2184 * x8
    x2197 = x108 * x2189 - x2191 * x8
    x2198 = x108 * x2191 - x2192 * x8
    x2199 = -x10 * x1929 + x1039 * x1927 + 2.0 * x1355 + 3.0 * x1880
    x2200 = -x10 * x1930 + x1039 * x1929 + 2.0 * x1357 + 3.0 * x1891

    # 150 item(s)
    return numpy.array(
        [
            x3 * (x3 * x71 + x4 * (-x40 + x50 + x66) - x6 * x95 + x98 * (x66 - x96 + x97))
            + x36 * (x71 - x72 + x91 - x94)
            - x6
            * (
                x3 * x95
                + x4 * (x68 - x73 + x99)
                - x6
                * (
                    x3 * x90
                    - x6
                    * (
                        x48 * (x102 + x59 - x76 + x81)
                        + x5 * x85
                        - x6
                        * (
                            x36 * (x57 + x78 - x79)
                            + x5 * x82
                            - x6 * (x100 + x5 * x80 - x6 * (-x101 * x6 + x5 * x77))
                        )
                    )
                    + x98 * (x62 - x74 + x83 - x84)
                )
                + x98 * (-x103 + x104 + x99)
            )
            + x98
            * (
                -x104 * x3
                - x104 * x6
                + x3 * x97
                + x48 * (-x105 + x3 * x44 + x45 + x69)
                - x48 * (x105 - x3 * x34 + x38 + x92)
                + x6 * (x103 + x89)
                + x70
                - x93
            ),
            x3
            * (
                x158 * x3
                - x181 * x6
                + x4 * (-x130 + x138 + x152)
                + x48 * (x152 - x182 + x183)
            )
            + x36 * (x158 - x159 + x176 - x180)
            + x48
            * (
                x157
                - x179
                + x183 * x3
                - x190 * x3
                - x190 * x6
                - x36 * (-x126 * x3 + x128 + x178 + x191)
                + x36 * (x133 * x3 + x135 + x156 - x191)
                + x6 * (x174 + x189)
            )
            - x6
            * (
                x181 * x3
                + x4 * (x154 - x160 + x184)
                + x48 * (x184 - x189 + x190)
                - x6
                * (
                    x175 * x3
                    + x48 * (x149 - x162 + x170 + x188)
                    - x6
                    * (
                        x171 * x5
                        + x36 * (x147 - x163 + x168)
                        - x6 * (x169 * x5 + x185 - x6 * (x167 * x5 - x187 * x6))
                    )
                )
            ),
            x3
            * (
                x244 * x3
                - x267 * x6
                + x4 * (-x216 + x224 + x238)
                + x48 * (x238 - x268 + x269)
            )
            + x36 * (x244 - x245 + x262 - x266)
            + x48
            * (
                x243
                - x265
                + x269 * x3
                - x276 * x3
                - x276 * x6
                - x36 * (-x212 * x3 + x214 + x264 + x277)
                + x36 * (x219 * x3 + x221 + x242 - x277)
                + x6 * (x260 + x275)
            )
            - x6
            * (
                x267 * x3
                + x4 * (x240 - x246 + x270)
                + x48 * (x270 - x275 + x276)
                - x6
                * (
                    x261 * x3
                    + x48 * (x235 - x248 + x256 + x274)
                    - x6
                    * (
                        x257 * x5
                        + x36 * (x233 - x249 + x254)
                        - x6 * (x255 * x5 + x271 - x6 * (x253 * x5 - x273 * x6))
                    )
                )
            ),
            x3
            * (
                x3 * x314
                - x332 * x6
                + x36 * (x310 - x333 + x334)
                + x4 * (-x290 + x298 + x310)
            )
            + x36 * (x314 - x315 + x329 - x331)
            + x36
            * (
                x3 * x334
                - x3 * x342
                + x313
                - x330
                - x342 * x6
                + x4 * (x287 + x292 * x3 + x293 - x343)
                - x4 * (-x286 * x3 + x288 + x304 + x343)
                + x6 * (x327 + x341)
            )
            - x6
            * (
                x3 * x332
                + x36 * (x336 - x341 + x342)
                + x4 * (x312 - x316 + x336)
                - x6
                * (
                    x3 * x328
                    + x36 * (x305 - x319 + x324)
                    - x6 * (x325 * x5 + x338 - x6 * (x323 * x5 - x340 * x6))
                )
            ),
            x3
            * (
                x3 * x378
                + x36 * (x374 - x396 + x397)
                - x395 * x6
                + x4 * (-x356 + x363 + x374)
            )
            + x36 * (x378 - x379 + x392 - x394)
            + x36
            * (
                x3 * x397
                - x3 * x404
                + x377
                - x393
                - x4 * (-x3 * x352 + x354 + x369 + x405)
                + x4 * (x3 * x358 + x353 + x359 - x405)
                - x404 * x6
                + x6 * (x390 + x403)
            )
            - x6
            * (
                x3 * x395
                + x36 * (x399 - x403 + x404)
                + x4 * (x376 - x380 + x399)
                - x6
                * (
                    x3 * x391
                    + x36 * (x370 - x382 + x387)
                    - x6 * (x388 * x5 + x400 - x6 * (x386 * x5 - x402 * x6))
                )
            ),
            x3
            * (
                x3 * x442
                + x36 * (x438 - x461 + x462)
                + x4 * (-x418 + x426 + x438)
                - x460 * x6
            )
            + x36 * (x442 - x443 + x457 - x459)
            + x36
            * (
                x3 * x462
                - x3 * x470
                - x4 * (-x3 * x414 + x416 + x432 + x471)
                + x4 * (x3 * x420 + x415 + x421 - x471)
                + x441
                - x458
                - x470 * x6
                + x6 * (x455 + x469)
            )
            - x6
            * (
                x3 * x460
                + x36 * (x464 - x469 + x470)
                + x4 * (x440 - x444 + x464)
                - x6
                * (
                    x3 * x456
                    + x36 * (x433 - x447 + x452)
                    - x6 * (x453 * x5 + x466 - x6 * (x451 * x5 - x468 * x6))
                )
            ),
            x3
            * (
                x3 * x506
                + x4 * (x482 - x499 + x500)
                + x4 * (x500 - x503 + x504)
                - x511 * x6
            )
            + x36 * (x498 + x506 - x507 + x510)
            + x4 * (x3 * x482 - x3 * x502 + x478 + x498 - x502 * x6 + x6 * (x488 + x495))
            - x6
            * (
                x3 * x511
                + x4 * (-x488 + x494 + x502)
                + x4 * (x494 + x505 - x508)
                - x6 * (x3 * x509 + x513 - x6 * (x493 * x5 - x515 * x6))
            ),
            x3
            * (
                x3 * x547
                + x4 * (x525 - x540 + x541)
                + x4 * (x541 - x544 + x545)
                - x552 * x6
            )
            + x36 * (x539 + x547 - x548 + x551)
            + x4 * (x3 * x525 - x3 * x543 + x521 + x539 - x543 * x6 + x6 * (x530 + x536))
            - x6
            * (
                x3 * x552
                + x4 * (-x530 + x535 + x543)
                + x4 * (x535 + x546 - x549)
                - x6 * (x3 * x550 + x554 - x6 * (x5 * x534 - x556 * x6))
            ),
            x3
            * (
                x3 * x586
                + x4 * (x565 - x579 + x580)
                + x4 * (x580 - x583 + x584)
                - x591 * x6
            )
            + x36 * (x578 + x586 - x587 + x590)
            + x4 * (x3 * x565 - x3 * x582 + x561 + x578 - x582 * x6 + x6 * (x570 + x576))
            - x6
            * (
                x3 * x591
                + x4 * (-x570 + x575 + x582)
                + x4 * (x575 + x585 - x588)
                - x6 * (x3 * x589 + x592 - x6 * (x5 * x574 - x594 * x6))
            ),
            x3
            * (
                x3 * x629
                + x4 * (x605 - x622 + x623)
                + x4 * (x623 - x626 + x627)
                - x6 * x634
            )
            + x36 * (x621 + x629 - x630 + x633)
            + x4 * (x3 * x605 - x3 * x625 - x6 * x625 + x6 * (x611 + x618) + x601 + x621)
            - x6
            * (
                x3 * x634
                + x4 * (-x611 + x617 + x625)
                + x4 * (x617 + x628 - x631)
                - x6 * (x3 * x632 - x6 * (x5 * x616 - x6 * x638) + x636)
            ),
            x3 * (x3 * x648 - x6 * x656 + x645)
            + x36 * (x648 - x649 + x655)
            - x6 * (x3 * x656 - x6 * (x3 * x654 - x6 * x660) + x658),
            x3 * (x3 * x670 - x6 * x678 + x667)
            + x36 * (x670 - x671 + x677)
            - x6 * (x3 * x678 - x6 * (x3 * x676 - x6 * x682) + x680),
            x3 * (x3 * x691 - x6 * x698 + x688)
            + x36 * (x691 - x692 + x697)
            - x6 * (x3 * x698 - x6 * (x3 * x696 - x6 * x702) + x700),
            x3 * (x3 * x710 - x6 * x717 + x707)
            + x36 * (x710 - x711 + x716)
            - x6 * (x3 * x717 - x6 * (x3 * x715 - x6 * x720) + x718),
            x3 * (x3 * x730 - x6 * x738 + x727)
            + x36 * (x730 - x731 + x737)
            - x6 * (x3 * x738 - x6 * (x3 * x736 - x6 * x742) + x740),
            x3 * (x3 * x781 - x6 * x799 + x98 * (-x760 + x770 - x771 + x778))
            + x4 * (-x773 + x781 + x798)
            - x6
            * (
                x3 * x799
                - x6
                * (
                    x48 * (x769 - x784 + x790 + x802)
                    + x5 * x794
                    - x6
                    * (
                        x36 * (x767 - x785 + x788)
                        + x5 * x791
                        - x6 * (x5 * x789 - x6 * (x5 * x787 - x6 * x801) + x800)
                    )
                )
                + x98 * (x772 - x782 + x792 - x793)
            )
            + x98 * (-x3 * x772 + x3 * x778 + x780 + x798),
            x3 * (x3 * x825 + x48 * (-x806 - x811 + x817 + x823) - x6 * x838)
            + x4 * (-x819 + x825 + x837)
            + x48 * (-x3 * x818 + x3 * x823 + x824 + x837)
            - x6
            * (
                x3 * x838
                + x48 * (x818 - x826 - x827 + x833)
                - x6
                * (
                    x36 * (x816 - x828 + x831)
                    + x5 * x834
                    - x6 * (x5 * x832 - x6 * (x5 * x830 - x6 * x840) + x839)
                )
            ),
            x3 * (x3 * x863 + x48 * (-x849 + x855 + x861 + x877) - x6 * x876)
            + x4 * (-x857 + x863 + x875)
            + x48 * (-x3 * x856 + x3 * x861 + x862 + x875)
            - x6
            * (
                x3 * x876
                + x48 * (x856 - x865 + x871 + x880)
                - x6
                * (
                    x36 * (x854 - x866 + x869)
                    + x5 * x872
                    - x6 * (x5 * x870 - x6 * (x5 * x868 - x6 * x879) + x878)
                )
            ),
            x3 * (x3 * x893 + x36 * (-x883 + x886 + x890) - x6 * x902)
            + x36 * (-x3 * x887 + x3 * x890 + x892 + x901)
            + x4 * (-x888 + x893 + x901)
            - x6
            * (
                x3 * x902
                + x36 * (x887 - x894 + x897)
                - x6 * (x5 * x898 - x6 * (x5 * x896 - x6 * x904) + x903)
            ),
            x3 * (x3 * x917 + x36 * (-x907 + x910 + x914) - x6 * x926)
            + x36 * (-x3 * x911 + x3 * x914 + x916 + x925)
            + x4 * (-x912 + x917 + x925)
            - x6
            * (
                x3 * x926
                + x36 * (x911 - x918 + x921)
                - x6 * (x5 * x922 - x6 * (x5 * x920 - x6 * x928) + x927)
            ),
            x3 * (x3 * x941 + x36 * (-x931 + x934 + x938) - x6 * x951)
            + x36 * (-x3 * x935 + x3 * x938 + x940 + x950)
            + x4 * (-x936 + x941 + x950)
            - x6
            * (
                x3 * x951
                + x36 * (x935 - x942 + x945)
                - x6 * (x5 * x946 - x6 * (x5 * x944 - x6 * x953) + x952)
            ),
            x3 * (x3 * x962 - x6 * x964 + x963)
            + x4 * (x957 - x961 + x962)
            + x4 * (x3 * x954 - x3 * x959 + x957 + x960)
            - x6 * (x3 * x964 - x6 * (x5 * x956 - x6 * x966) + x965),
            x3 * (x3 * x975 - x6 * x977 + x976)
            + x4 * (x970 - x974 + x975)
            + x4 * (x3 * x967 - x3 * x972 + x970 + x973)
            - x6 * (x3 * x977 - x6 * (x5 * x969 - x6 * x979) + x978),
            x3 * (x3 * x988 - x6 * x990 + x989)
            + x4 * (x983 - x987 + x988)
            + x4 * (x3 * x980 - x3 * x985 + x983 + x986)
            - x6 * (x3 * x990 - x6 * (x5 * x982 - x6 * x992) + x991),
            x3 * (x1001 * x3 + x1002 - x1003 * x6)
            + x4 * (-x1000 + x1001 + x996)
            + x4 * (x3 * x993 - x3 * x998 + x996 + x999)
            - x6 * (x1003 * x3 + x1004 - x6 * (-x1005 * x6 + x5 * x995)),
            x1010 + x3 * (x1009 * x3 - x1011 * x6) - x6 * (x1011 * x3 - x1012 * x6),
            x1017 + x3 * (x1016 * x3 - x1018 * x6) - x6 * (x1018 * x3 - x1019 * x6),
            x1024 + x3 * (x1023 * x3 - x1025 * x6) - x6 * (x1025 * x3 - x1026 * x6),
            x1030 + x3 * (x1029 * x3 - x1031 * x6) - x6 * (x1031 * x3 - x1032 * x6),
            x1036 + x3 * (x1035 * x3 - x1037 * x6) - x6 * (x1037 * x3 - x1038 * x6),
            x3 * (x1077 * x3 - x1095 * x6 + x98 * (-x1056 + x1066 - x1067 + x1074))
            + x4 * (-x1069 + x1077 + x1094)
            - x6
            * (
                x1095 * x3
                - x6
                * (
                    x1090 * x5
                    + x48 * (x1065 - x1080 + x1086 + x1098)
                    - x6
                    * (
                        x1087 * x5
                        + x36 * (x1063 - x1081 + x1084)
                        - x6 * (x1085 * x5 + x1096 - x6 * (x1083 * x5 - x1097 * x6))
                    )
                )
                + x98 * (x1068 - x1078 + x1088 - x1089)
            )
            + x98 * (-x1068 * x3 + x1074 * x3 + x1076 + x1094),
            x3 * (x1128 * x3 - x1143 * x6 + x48 * (-x1111 + x1119 + x1126 + x1144))
            + x4 * (-x1121 + x1128 + x1142)
            + x48 * (-x1120 * x3 + x1126 * x3 + x1127 + x1142)
            - x6
            * (
                x1143 * x3
                + x48 * (x1120 - x1130 + x1138 + x1148)
                - x6
                * (
                    x1139 * x5
                    + x36 * (x1118 - x1131 + x1136)
                    - x6 * (x1137 * x5 + x1145 - x6 * (x1135 * x5 - x1147 * x6))
                )
            ),
            x3 * (x1171 * x3 - x1184 * x6 + x48 * (-x1157 + x1163 + x1169 + x1185))
            + x4 * (-x1165 + x1171 + x1183)
            + x48 * (-x1164 * x3 + x1169 * x3 + x1170 + x1183)
            - x6
            * (
                x1184 * x3
                + x48 * (x1164 - x1173 + x1179 + x1188)
                - x6
                * (
                    x1180 * x5
                    + x36 * (x1162 - x1174 + x1177)
                    - x6 * (x1178 * x5 + x1186 - x6 * (x1176 * x5 - x1187 * x6))
                )
            ),
            x3 * (x1207 * x3 - x1220 * x6 + x36 * (-x1193 + x1198 + x1203))
            + x36 * (-x1199 * x3 + x1203 * x3 + x1206 + x1219)
            + x4 * (-x1200 + x1207 + x1219)
            - x6
            * (
                x1220 * x3
                + x36 * (x1199 - x1208 + x1213)
                - x6 * (x1214 * x5 + x1222 - x6 * (x1212 * x5 - x1224 * x6))
            ),
            x3 * (x1242 * x3 - x1254 * x6 + x36 * (-x1229 + x1234 + x1239))
            + x36 * (-x1235 * x3 + x1239 * x3 + x1241 + x1253)
            + x4 * (-x1236 + x1242 + x1253)
            - x6
            * (
                x1254 * x3
                + x36 * (x1235 - x1243 + x1248)
                - x6 * (x1249 * x5 + x1255 - x6 * (x1247 * x5 - x1257 * x6))
            ),
            x3 * (x1270 * x3 - x1280 * x6 + x36 * (-x1260 + x1263 + x1267))
            + x36 * (-x1264 * x3 + x1267 * x3 + x1269 + x1279)
            + x4 * (-x1265 + x1270 + x1279)
            - x6
            * (
                x1280 * x3
                + x36 * (x1264 - x1271 + x1274)
                - x6 * (x1275 * x5 + x1281 - x6 * (x1273 * x5 - x1282 * x6))
            ),
            x3 * (x1298 * x3 + x1300 - x1301 * x6)
            + x4 * (x1290 - x1297 + x1298)
            + x4 * (x1284 * x3 + x1290 - x1295 * x3 + x1296)
            - x6 * (x1301 * x3 + x1303 - x6 * (x1289 * x5 - x1305 * x6)),
            x3 * (x1319 * x3 + x1321 - x1322 * x6)
            + x4 * (x1312 - x1318 + x1319)
            + x4 * (x1307 * x3 + x1312 - x1316 * x3 + x1317)
            - x6 * (x1322 * x3 + x1324 - x6 * (x1311 * x5 - x1326 * x6)),
            x3 * (x1340 * x3 + x1341 - x1342 * x6)
            + x4 * (x1333 - x1339 + x1340)
            + x4 * (x1328 * x3 + x1333 - x1337 * x3 + x1338)
            - x6 * (x1342 * x3 + x1343 - x6 * (x1332 * x5 - x1345 * x6)),
            x3 * (x1354 * x3 + x1355 - x1356 * x6)
            + x4 * (x1349 - x1353 + x1354)
            + x4 * (x1346 * x3 + x1349 - x1351 * x3 + x1352)
            - x6 * (x1356 * x3 + x1357 - x6 * (x1348 * x5 - x1358 * x6)),
            x1365 + x3 * (x1361 * x3 - x1367 * x6) - x6 * (x1367 * x3 - x1369 * x6),
            x1376 + x3 * (x1372 * x3 - x1378 * x6) - x6 * (x1378 * x3 - x1380 * x6),
            x1386 + x3 * (x1383 * x3 - x1388 * x6) - x6 * (x1388 * x3 - x1390 * x6),
            x1395 + x3 * (x1394 * x3 - x1397 * x6) - x6 * (x1397 * x3 - x1399 * x6),
            x1404 + x3 * (x1403 * x3 - x1405 * x6) - x6 * (x1405 * x3 - x1406 * x6),
            x3 * (x1430 * x5 - x1444 * x6 + x48 * (x1419 - x1421 + x1428 + x1445))
            - x6
            * (
                x1444 * x5
                + x48 * (x1429 - x1433 + x1440 + x1448)
                - x6
                * (
                    x1441 * x5
                    + x36 * (x1427 - x1434 + x1438)
                    - x6 * (x1439 * x5 + x1446 - x6 * (x1437 * x5 - x1447 * x6))
                )
            )
            + x98 * (x1430 - x1431 + x1442 - x1443),
            x3 * (x1461 * x5 - x1471 * x6 + x36 * (x1454 - x1455 + x1459))
            + x48 * (x1461 - x1462 - x1463 + x1470)
            - x6
            * (
                x1471 * x5
                + x36 * (x1460 - x1464 + x1468)
                - x6 * (x1469 * x5 + x1472 - x6 * (x1467 * x5 - x1473 * x6))
            ),
            x3 * (x1486 * x5 - x1496 * x6 + x36 * (x1479 - x1480 + x1484))
            + x48 * (x1486 - x1488 + x1495 + x1499)
            - x6
            * (
                x1496 * x5
                + x36 * (x1485 - x1489 + x1493)
                - x6 * (x1494 * x5 + x1497 - x6 * (x1492 * x5 - x1498 * x6))
            ),
            x3 * (x1506 + x1508 * x5 - x1515 * x6)
            + x36 * (x1508 - x1509 + x1514)
            - x6 * (x1515 * x5 + x1517 - x6 * (x1513 * x5 - x1519 * x6)),
            x3 * (x1523 + x1525 * x5 - x1531 * x6)
            + x36 * (x1525 - x1526 + x1530)
            - x6 * (x1531 * x5 + x1532 - x6 * (x1529 * x5 - x1533 * x6)),
            x3 * (x1537 + x1539 * x5 - x1545 * x6)
            + x36 * (x1539 - x1540 + x1544)
            - x6 * (x1545 * x5 + x1546 - x6 * (x1543 * x5 - x1547 * x6)),
            x1552 + x3 * (x1551 * x5 - x1553 * x6) - x6 * (x1553 * x5 - x1554 * x6),
            x1561 + x3 * (x1560 * x5 - x1562 * x6) - x6 * (x1562 * x5 - x1564 * x6),
            x1568 + x3 * (x1567 * x5 - x1569 * x6) - x6 * (x1569 * x5 - x1570 * x6),
            x1574 + x3 * (x1573 * x5 - x1575 * x6) - x6 * (x1575 * x5 - x1576 * x6),
            x1577 * x3 - x1578 * x6,
            x1579 * x3 - x1580 * x6,
            x1582 * x3 - x1584 * x6,
            x1585 * x3 - x1586 * x6,
            x1587 * x3 - x1588 * x6,
            x3 * (x1609 * x5 - x1622 * x6 + x48 * (x1599 - x1601 + x1607 + x1623))
            - x6
            * (
                x1622 * x5
                + x48 * (x1608 - x1612 + x1618 + x1626)
                - x6
                * (
                    x1619 * x5
                    + x36 * (x1606 - x1613 + x1616)
                    - x6 * (x1617 * x5 + x1624 - x6 * (x1615 * x5 - x1625 * x6))
                )
            )
            + x98 * (x1609 - x1610 + x1620 - x1621),
            x3 * (x1637 * x5 - x1646 * x6 + x36 * (x1631 - x1632 + x1635))
            + x48 * (x1637 - x1638 - x1639 + x1645)
            - x6
            * (
                x1646 * x5
                + x36 * (x1636 - x1640 + x1643)
                - x6 * (x1644 * x5 + x1647 - x6 * (x1642 * x5 - x1648 * x6))
            ),
            x3 * (x1659 * x5 - x1668 * x6 + x36 * (x1653 - x1654 + x1657))
            + x48 * (x1659 - x1661 + x1667 + x1671)
            - x6
            * (
                x1668 * x5
                + x36 * (x1658 - x1662 + x1665)
                - x6 * (x1666 * x5 + x1669 - x6 * (x1664 * x5 - x1670 * x6))
            ),
            x3 * (x1674 + x1676 * x5 - x1681 * x6)
            + x36 * (x1676 - x1677 + x1680)
            - x6 * (x1681 * x5 + x1682 - x6 * (x1679 * x5 - x1683 * x6)),
            x3 * (x1686 + x1688 * x5 - x1693 * x6)
            + x36 * (x1688 - x1689 + x1692)
            - x6 * (x1693 * x5 + x1694 - x6 * (x1691 * x5 - x1695 * x6)),
            x3 * (x1698 + x1700 * x5 - x1705 * x6)
            + x36 * (x1700 - x1701 + x1704)
            - x6 * (x1705 * x5 + x1706 - x6 * (x1703 * x5 - x1707 * x6)),
            x1710 + x3 * (x1709 * x5 - x1711 * x6) - x6 * (x1711 * x5 - x1712 * x6),
            x1715 + x3 * (x1714 * x5 - x1716 * x6) - x6 * (x1716 * x5 - x1717 * x6),
            x1720 + x3 * (x1719 * x5 - x1721 * x6) - x6 * (x1721 * x5 - x1722 * x6),
            x1725 + x3 * (x1724 * x5 - x1726 * x6) - x6 * (x1726 * x5 - x1727 * x6),
            x1728 * x3 - x1729 * x6,
            x1730 * x3 - x1731 * x6,
            x1732 * x3 - x1733 * x6,
            x1734 * x3 - x1735 * x6,
            x1736 * x3 - x1737 * x6,
            x3 * (x1761 * x5 - x1775 * x6 + x48 * (x1750 - x1752 + x1759 + x1776))
            - x6
            * (
                x1775 * x5
                + x48 * (x1760 - x1764 + x1771 + x1779)
                - x6
                * (
                    x1772 * x5
                    + x36 * (x1758 - x1765 + x1769)
                    - x6 * (x1770 * x5 + x1777 - x6 * (x1768 * x5 - x1778 * x6))
                )
            )
            + x98 * (x1761 - x1762 + x1773 - x1774),
            x3 * (x1795 * x5 - x1806 * x6 + x36 * (x1787 - x1788 + x1793))
            + x48 * (x1795 - x1796 - x1797 + x1805)
            - x6
            * (
                x1806 * x5
                + x36 * (x1794 - x1798 + x1803)
                - x6 * (x1804 * x5 + x1807 - x6 * (x1802 * x5 - x1809 * x6))
            ),
            x3 * (x1822 * x5 - x1832 * x6 + x36 * (x1815 - x1816 + x1820))
            + x48 * (x1822 - x1824 + x1831 + x1835)
            - x6
            * (
                x1832 * x5
                + x36 * (x1821 - x1825 + x1829)
                - x6 * (x1830 * x5 + x1833 - x6 * (x1828 * x5 - x1834 * x6))
            ),
            x3 * (x1841 + x1844 * x5 - x1851 * x6)
            + x36 * (x1844 - x1845 + x1850)
            - x6 * (x1851 * x5 + x1853 - x6 * (x1849 * x5 - x1855 * x6)),
            x3 * (x1860 + x1863 * x5 - x1870 * x6)
            + x36 * (x1863 - x1864 + x1869)
            - x6 * (x1870 * x5 + x1871 - x6 * (x1868 * x5 - x1873 * x6)),
            x3 * (x1880 + x1882 * x5 - x1889 * x6)
            + x36 * (x1882 - x1883 + x1888)
            - x6 * (x1889 * x5 + x1891 - x6 * (x1887 * x5 - x1893 * x6)),
            x1900 + x3 * (x1896 * x5 - x1902 * x6) - x6 * (x1902 * x5 - x1904 * x6),
            x1910 + x3 * (x1907 * x5 - x1912 * x6) - x6 * (x1912 * x5 - x1914 * x6),
            x1919 + x3 * (x1918 * x5 - x1921 * x6) - x6 * (x1921 * x5 - x1923 * x6),
            x1928 + x3 * (x1927 * x5 - x1929 * x6) - x6 * (x1929 * x5 - x1930 * x6),
            x1932 * x3 - x1934 * x6,
            x1936 * x3 - x1938 * x6,
            x1940 * x3 - x1942 * x6,
            x1944 * x3 - x1946 * x6,
            x1947 * x3 - x1948 * x6,
            x48 * (x1962 - x1963 - x1964 + x1972)
            + x5 * (x1962 * x5 - x1973 * x6 + x36 * (x1954 - x1955 + x1960))
            - x6
            * (
                x1973 * x5
                + x36 * (x1961 - x1965 + x1970)
                - x6
                * (
                    x1971 * x5
                    + x4 * (x1959 - x1966 + x1967 - x1968)
                    - x6 * (x1969 * x5 - x6 * (x1437 * x743 - x1447 * x8 + 2.0 * x800))
                )
            ),
            x36 * (x1978 - x1979 + x1983)
            + x5
            * (x1978 * x5 - x1984 * x6 + x4 * (x1445 + x1503 + x1974 - x1975 + x1976))
            - x6
            * (
                x1984 * x5
                + x4 * (x1448 + x1516 + x1977 - x1980 + x1981)
                - x6 * (x1982 * x5 - x6 * (x1446 + x1467 * x743 - x1473 * x8 + x1518))
            ),
            x36 * (x1990 - x1991 + x1996)
            + x5 * (x1990 * x5 - x1997 * x6 + x4 * (x1985 - x1986 - x1987 + x1988))
            - x6
            * (
                x1997 * x5
                + x4 * (x1989 - x1992 + x1993 - x1994)
                - x6 * (x1995 * x5 - x6 * (x1492 * x743 - x1498 * x8 + 2.0 * x878))
            ),
            x4 * (x1998 - x1999 - x2000 - x2001 + x2002)
            + x5 * (x2002 * x5 - x2003 * x6)
            - x6
            * (x2003 * x5 - x6 * (2.0 * x1472 + x1513 * x743 - x1519 * x8 + 2.0 * x903)),
            x4 * (x1499 + x1558 + x2004 - x2005 + x2006)
            + x5 * (x2006 * x5 - x2007 * x6)
            - x6 * (x2007 * x5 - x6 * (x1497 + x1529 * x743 - x1533 * x8 + x1563)),
            x4 * (x2008 - x2009 - x2010 + x2011)
            + x5 * (x2011 * x5 - x2012 * x6)
            - x6 * (x2012 * x5 - x6 * (x1543 * x743 - x1547 * x8 + 2.0 * x952)),
            x5 * (3.0 * x1506 + x1551 * x743 - x1553 * x8 + 2.0 * x963)
            - x6 * (3.0 * x1517 + x1553 * x743 - x1554 * x8 + 2.0 * x965),
            x5 * (2.0 * x1523 + x1560 * x743 - x1562 * x8 + 2.0 * x976)
            - x6 * (2.0 * x1532 + x1562 * x743 - x1564 * x8 + 2.0 * x978),
            x5 * (x1537 + x1567 * x743 - x1569 * x8 + x1581)
            - x6 * (x1546 + x1569 * x743 - x1570 * x8 + x1583),
            x5 * (2.0 * x1002 + x1573 * x743 - x1575 * x8)
            - x6 * (2.0 * x1004 + x1575 * x743 - x1576 * x8),
            2.0 * x1010 + 4.0 * x1552 + x1577 * x743 - x1578 * x8,
            2.0 * x1017 + 3.0 * x1561 + x1579 * x743 - x1580 * x8,
            2.0 * x1024 + 2.0 * x1568 + x1582 * x743 - x1584 * x8,
            2.0 * x1030 + x1574 + x1585 * x743 - x1586 * x8,
            2.0 * x1036 + x1587 * x743 - x1588 * x8,
            x48 * (x2024 - x2025 - x2026 + x2033)
            + x5 * (x2024 * x5 - x2034 * x6 + x36 * (x2017 - x2018 + x2022))
            - x6
            * (
                x2034 * x5
                + x36 * (x2023 - x2027 + x2031)
                - x6
                * (
                    x2032 * x5
                    + x4 * (x1098 + x2021 - x2028 + x2029)
                    - x6 * (x2030 * x5 - x6 * (x1096 + x1615 * x743 - x1625 * x8))
                )
            ),
            x36 * (x2039 - x2040 + x2044)
            + x5
            * (x2039 * x5 - x2045 * x6 + x4 * (x1144 + x1623 + x2035 - x2036 + x2037))
            - x6
            * (
                x2045 * x5
                + x4 * (x1148 + x1626 + x2038 - x2041 + x2042)
                - x6 * (x2043 * x5 - x6 * (x1145 + x1624 + x1642 * x743 - x1648 * x8))
            ),
            x36 * (x2050 - x2051 + x2055)
            + x5 * (x2050 * x5 - x2056 * x6 + x4 * (x1185 + x2046 - x2047 + x2048))
            - x6
            * (
                x2056 * x5
                + x4 * (x1188 + x2049 - x2052 + x2053)
                - x6 * (x2054 * x5 - x6 * (x1186 + x1664 * x743 - x1670 * x8))
            ),
            x4 * (x1218 + x2057 - x2058 - x2059 + x2060)
            + x5 * (x2060 * x5 - x2061 * x6)
            - x6 * (x2061 * x5 - x6 * (x1222 + 2.0 * x1647 + x1679 * x743 - x1683 * x8)),
            x4 * (x1252 + x1671 + x2062 - x2063 + x2064)
            + x5 * (x2064 * x5 - x2065 * x6)
            - x6 * (x2065 * x5 - x6 * (x1255 + x1669 + x1691 * x743 - x1695 * x8)),
            x4 * (x1278 + x2066 - x2067 + x2068)
            + x5 * (x2068 * x5 - x2069 * x6)
            - x6 * (x2069 * x5 - x6 * (x1281 + x1703 * x743 - x1707 * x8)),
            x5 * (x1300 + 3.0 * x1674 + x1709 * x743 - x1711 * x8)
            - x6 * (x1303 + 3.0 * x1682 + x1711 * x743 - x1712 * x8),
            x5 * (x1321 + 2.0 * x1686 + x1714 * x743 - x1716 * x8)
            - x6 * (x1324 + 2.0 * x1694 + x1716 * x743 - x1717 * x8),
            x5 * (x1341 + x1698 + x1719 * x743 - x1721 * x8)
            - x6 * (x1343 + x1706 + x1721 * x743 - x1722 * x8),
            x5 * (x1355 + x1724 * x743 - x1726 * x8)
            - x6 * (x1357 + x1726 * x743 - x1727 * x8),
            x1365 + 4.0 * x1710 + x1728 * x743 - x1729 * x8,
            x1376 + 3.0 * x1715 + x1730 * x743 - x1731 * x8,
            x1386 + 2.0 * x1720 + x1732 * x743 - x1733 * x8,
            x1395 + x1725 + x1734 * x743 - x1735 * x8,
            x1404 + x1736 * x743 - x1737 * x8,
            x48 * (x2079 - x2080 - x2081 + x2087)
            + x5 * (x2079 * x5 - x2088 * x6 + x36 * (x2073 - x2074 + x2077))
            - x6
            * (
                x2088 * x5
                + x36 * (x2078 - x2082 + x2085)
                - x6
                * (
                    x2086 * x5
                    + x4 * (x1800 + x2076 - x2083)
                    - x6 * (x2084 * x5 - x6 * (x1768 * x743 + x1808))
                )
            ),
            x36 * (x2092 - x2093 + x2096)
            + x5 * (x2092 * x5 - x2097 * x6 + x4 * (x1840 - x2089 + x2090))
            - x6
            * (
                x2097 * x5
                + x4 * (x1852 + x2091 - x2094)
                - x6 * (x2095 * x5 - x6 * (x1802 * x743 + x1854))
            ),
            x36 * (x2101 - x2102 + x2105)
            + x5 * (x2101 * x5 - x2106 * x6 + x4 * (x1856 - x2098 + x2099))
            - x6
            * (
                x2106 * x5
                + x4 * (x1866 + x2100 - x2103)
                - x6 * (x2104 * x5 - x6 * (x1828 * x743 + x1872))
            ),
            x4 * (x1899 - x2107 + x2108)
            + x5 * (x2108 * x5 - x2109 * x6)
            - x6 * (x2109 * x5 - x6 * (x1849 * x743 + x1903)),
            x4 * (x1909 - x2110 + x2111)
            + x5 * (x2111 * x5 - x2112 * x6)
            - x6 * (x2112 * x5 - x6 * (x1868 * x743 + x1913)),
            x4 * (x1915 - x2113 + x2114)
            + x5 * (x2114 * x5 - x2115 * x6)
            - x6 * (x2115 * x5 - x6 * (x1887 * x743 + x1922)),
            x5 * (x1896 * x743 + x1931) - x6 * (x1902 * x743 + x1933),
            x5 * (x1907 * x743 + x1935) - x6 * (x1912 * x743 + x1937),
            x5 * (x1918 * x743 + x1939) - x6 * (x1921 * x743 + x1941),
            x5 * (x1927 * x743 + x1943) - x6 * (x1929 * x743 + x1945),
            4.0 * x1900 + x1932 * x743 - x1934 * x8,
            3.0 * x1910 + x1936 * x743 - x1938 * x8,
            2.0 * x1919 + x1940 * x743 - x1942 * x8,
            x1928 + x1944 * x743 - x1946 * x8,
            x1947 * x743 - x1948 * x8,
            x48 * (x2130 - x2132 + x2140 + x2144)
            + x5 * (x2130 * x5 - x2141 * x6 + x36 * (x2122 - x2123 + x2128))
            - x6
            * (
                x2141 * x5
                + x36 * (x2129 - x2133 + x2138)
                - x6 * (x2139 * x5 + x2142 - x6 * (x2137 * x5 - x2143 * x6))
            ),
            x36 * (x2150 - x2151 + x2155)
            + x5 * (x2148 + x2150 * x5 - x2156 * x6)
            - x6 * (x2156 * x5 + x2157 - x6 * (x2154 * x5 - x2158 * x6)),
            x36 * (x2164 - x2165 + x2169)
            + x5 * (x2162 + x2164 * x5 - x2170 * x6)
            - x6 * (x2170 * x5 + x2171 - x6 * (x2168 * x5 - x2172 * x6)),
            x2176 + x5 * (x2175 * x5 - x2177 * x6) - x6 * (x2177 * x5 - x2178 * x6),
            x2182 + x5 * (x2181 * x5 - x2183 * x6) - x6 * (x2183 * x5 - x2184 * x6),
            x2190 + x5 * (x2189 * x5 - x2191 * x6) - x6 * (x2191 * x5 - x2192 * x6),
            x2193 * x5 - x2194 * x6,
            x2195 * x5 - x2196 * x6,
            x2197 * x5 - x2198 * x6,
            x2199 * x5 - x2200 * x6,
            x108 * x2193 + 3.0 * x2176 - x2194 * x8,
            x108 * x2195 + 2.0 * x2182 - x2196 * x8,
            x108 * x2197 + x2190 - x2198 * x8,
            x108 * x2199 - x2200 * x8,
            -x10 * x1948 + x1039 * x1947 + 2.0 * x1404 + 4.0 * x1928,
        ]
    )


def coulomb3d_40(a, A, b, B, C):
    """Cartesian (gs) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - C[0]
    x6 = -x1 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x1 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x0 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(1, x10)
    x13 = x11 * boys(0, x10)
    x14 = x4 * (-x12 + x13)
    x15 = -x12 * x5 + x13 * x3
    x16 = x11 * boys(2, x10)
    x17 = x16 * x5
    x18 = x12 * x3
    x19 = -x17 + x18
    x20 = x14 + x15 * x3 - x19 * x5
    x21 = x4 * (x12 - x16)
    x22 = x19 * x3
    x23 = x11 * boys(3, x10)
    x24 = x23 * x5
    x25 = x16 * x3
    x26 = -x24 + x25
    x27 = x26 * x5
    x28 = x21 + x22 - x27
    x29 = 2.0 * x4
    x30 = x4 * (x16 - x23)
    x31 = x11 * boys(4, x10)
    x32 = -x21
    x33 = -x6 - A[1]
    x34 = x12 * x33
    x35 = x16 * x7
    x36 = -x12 * x7 + x13 * x33
    x37 = x4 * (-x34 + x35 + x36)
    x38 = x34 - x35
    x39 = x3 * x36 - x38 * x5
    x40 = x3 * x38
    x41 = x23 * x7
    x42 = x16 * x33
    x43 = -x41 + x42
    x44 = x43 * x5
    x45 = x40 - x44
    x46 = x4 * (x38 + x41 - x42)
    x47 = x23 * x33 - x31 * x7
    x48 = -x8 - A[2]
    x49 = x12 * x48
    x50 = x16 * x9
    x51 = -x12 * x9 + x13 * x48
    x52 = x4 * (-x49 + x50 + x51)
    x53 = x49 - x50
    x54 = x3 * x51 - x5 * x53
    x55 = x3 * x53
    x56 = x23 * x9
    x57 = x16 * x48
    x58 = -x56 + x57
    x59 = x5 * x58
    x60 = x55 - x59
    x61 = x4 * (x53 + x56 - x57)
    x62 = x23 * x48 - x31 * x9
    x63 = x43 * x7
    x64 = x33 * x38
    x65 = x14 + x33 * x36 - x38 * x7
    x66 = x4 * (x32 + x63 - x64 + x65)
    x67 = x21 - x63 + x64
    x68 = x30 + x33 * x43 - x47 * x7
    x69 = x58 * x7
    x70 = x33 * x53
    x71 = x33 * x51 - x53 * x7
    x72 = x4 * (x69 - x70 + x71)
    x73 = -x69 + x70
    x74 = x33 * x58 - x62 * x7
    x75 = x58 * x9
    x76 = x48 * x53
    x77 = x14 + x48 * x51 - x53 * x9
    x78 = x4 * (x32 + x75 - x76 + x77)
    x79 = x21 - x75 + x76
    x80 = x30 + x48 * x58 - x62 * x9
    x81 = x33 * x65 + 2.0 * x37 - x67 * x7
    x82 = x33 * x67 + 2.0 * x46 - x68 * x7
    x83 = x33 * x71 + x52 - x7 * x73
    x84 = x33 * x73 + x61 - x7 * x74
    x85 = x33 * x77 - x7 * x79
    x86 = x33 * x79 - x7 * x80
    x87 = x48 * x77 + 2.0 * x52 - x79 * x9
    x88 = x48 * x79 + 2.0 * x61 - x80 * x9

    # 15 item(s)
    return numpy.array(
        [
            x3 * (x20 * x3 - x28 * x5 + x29 * (x15 + x17 - x18))
            + 3.0 * x4 * (x20 - x22 + x27 + x32)
            - x5
            * (
                x28 * x3
                + x29 * (x19 + x24 - x25)
                - x5 * (x26 * x3 + x30 - x5 * (x23 * x3 - x31 * x5))
            ),
            x29 * (x39 - x40 + x44)
            + x3 * (x3 * x39 + x37 - x45 * x5)
            - x5 * (x3 * x45 + x46 - x5 * (x3 * x43 - x47 * x5)),
            x29 * (x54 - x55 + x59)
            + x3 * (x3 * x54 - x5 * x60 + x52)
            - x5 * (x3 * x60 - x5 * (x3 * x58 - x5 * x62) + x61),
            x3 * (x3 * x65 - x5 * x67) - x5 * (x3 * x67 - x5 * x68) + x66,
            x3 * (x3 * x71 - x5 * x73) - x5 * (x3 * x73 - x5 * x74) + x72,
            x3 * (x3 * x77 - x5 * x79) - x5 * (x3 * x79 - x5 * x80) + x78,
            x3 * x81 - x5 * x82,
            x3 * x83 - x5 * x84,
            x3 * x85 - x5 * x86,
            x3 * x87 - x5 * x88,
            x33 * x81 + 3.0 * x66 - x7 * x82,
            x33 * x83 - x7 * x84 + 2.0 * x72,
            x33 * x85 - x7 * x86 + x78,
            x33 * x87 - x7 * x88,
            x48 * x87 + 3.0 * x78 - x88 * x9,
        ]
    )


def coulomb3d_41(a, A, b, B, C):
    """Cartesian (gp) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = -x3 - C[0]
    x6 = -x2 * (a * A[1] + b * B[1])
    x7 = -x6 - C[1]
    x8 = -x2 * (a * A[2] + b * B[2])
    x9 = -x8 - C[2]
    x10 = x1 * (x5**2 + x7**2 + x9**2)
    x11 = (
        6.28318530717959
        * x2
        * numpy.exp(
            -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x12 = x11 * boys(1, x10)
    x13 = x11 * boys(0, x10)
    x14 = x0 * (-x12 + x13)
    x15 = -x12 * x5
    x16 = x13 * x4 + x15
    x17 = x11 * boys(2, x10)
    x18 = x17 * x5
    x19 = -x18
    x20 = x12 * x4
    x21 = x19 + x20
    x22 = x14 + x16 * x4 - x21 * x5
    x23 = x11 * boys(3, x10)
    x24 = x0 * (x17 - x23)
    x25 = x23 * x5
    x26 = -x25
    x27 = x17 * x4
    x28 = x26 + x27
    x29 = x28 * x4
    x30 = x11 * boys(4, x10)
    x31 = x30 * x5
    x32 = -x31
    x33 = x23 * x4
    x34 = x5 * (x32 + x33)
    x35 = x0 * (x12 - x17)
    x36 = x21 * x4
    x37 = x28 * x5
    x38 = x35 + x36 - x37
    x39 = x0 * (x21 + x25 - x27)
    x40 = x0 * (x16 + x18 - x20)
    x41 = -x35
    x42 = -x3 - B[0]
    x43 = x12 * x42
    x44 = x13 * x42 + x15
    x45 = x19 + x43
    x46 = x14 + x4 * x44 - x45 * x5
    x47 = x4 * x45
    x48 = x17 * x42
    x49 = x26 + x48
    x50 = x49 * x5
    x51 = x35 + x47 - x50
    x52 = x0 * (x18 - x43 + x44) + x4 * x46 + x40 - x5 * x51
    x53 = x0 * (x25 + x45 - x48)
    x54 = x4 * x51
    x55 = x4 * x49
    x56 = x23 * x42
    x57 = x32 + x56
    x58 = x5 * x57
    x59 = x24 + x55 - x58
    x60 = x5 * x59
    x61 = x39 + x53 + x54 - x60
    x62 = 2.0 * x0
    x63 = -x24
    x64 = x0 * (x23 - x30)
    x65 = x11 * boys(5, x10)
    x66 = 3.0 * x0
    x67 = -x6 - B[1]
    x68 = x12 * x67
    x69 = x17 * x7
    x70 = -x12 * x7
    x71 = x13 * x67 + x70
    x72 = x0 * (-x68 + x69 + x71)
    x73 = -x69
    x74 = x68 + x73
    x75 = x4 * x71 - x5 * x74
    x76 = x4 * x74
    x77 = x23 * x7
    x78 = -x77
    x79 = x17 * x67
    x80 = x78 + x79
    x81 = x5 * x80
    x82 = x76 - x81
    x83 = x4 * x75 - x5 * x82 + x72
    x84 = x0 * (x74 + x77 - x79)
    x85 = x4 * x82
    x86 = x4 * x80
    x87 = x30 * x7
    x88 = -x87
    x89 = x23 * x67
    x90 = x88 + x89
    x91 = x5 * x90
    x92 = x86 - x91
    x93 = x5 * x92
    x94 = x84 + x85 - x93
    x95 = x0 * (x80 + x87 - x89)
    x96 = -x65 * x7
    x97 = x30 * x67 + x96
    x98 = -x84
    x99 = -x8 - B[2]
    x100 = x12 * x99
    x101 = x17 * x9
    x102 = -x12 * x9
    x103 = x102 + x13 * x99
    x104 = x0 * (-x100 + x101 + x103)
    x105 = -x101
    x106 = x100 + x105
    x107 = x103 * x4 - x106 * x5
    x108 = x106 * x4
    x109 = x23 * x9
    x110 = -x109
    x111 = x17 * x99
    x112 = x110 + x111
    x113 = x112 * x5
    x114 = x108 - x113
    x115 = x104 + x107 * x4 - x114 * x5
    x116 = x0 * (x106 + x109 - x111)
    x117 = x114 * x4
    x118 = x112 * x4
    x119 = x30 * x9
    x120 = -x119
    x121 = x23 * x99
    x122 = x120 + x121
    x123 = x122 * x5
    x124 = x118 - x123
    x125 = x124 * x5
    x126 = x116 + x117 - x125
    x127 = x0 * (x112 + x119 - x121)
    x128 = -x65 * x9
    x129 = x128 + x30 * x99
    x130 = -x116
    x131 = -x6 - A[1]
    x132 = x12 * x131
    x133 = x13 * x131 + x70
    x134 = x0 * (-x132 + x133 + x69)
    x135 = x132 + x73
    x136 = -x135 * x5
    x137 = x133 * x4 + x136
    x138 = x131 * x17
    x139 = x138 + x78
    x140 = x139 * x4
    x141 = x131 * x23
    x142 = x141 + x88
    x143 = x142 * x5
    x144 = -x143
    x145 = x0 * (x135 - x138 + x77)
    x146 = -x145
    x147 = x135 * x4
    x148 = x139 * x5
    x149 = -x148
    x150 = x147 + x149
    x151 = x135 * x42
    x152 = x133 * x42 + x136
    x153 = x149 + x151
    x154 = x134 + x152 * x4 - x153 * x5
    x155 = x153 * x4
    x156 = x139 * x42
    x157 = x144 + x156
    x158 = x157 * x5
    x159 = x145 + x155 - x158
    x160 = x0 * (x139 - x141 + x87)
    x161 = x131 * x30 + x96
    x162 = x7 * x80
    x163 = x131 * x74
    x164 = x131 * x71 + x14 - x7 * x74
    x165 = x0 * (x162 - x163 + x164 + x41)
    x166 = -x162 + x163 + x35
    x167 = x164 * x4 - x166 * x5
    x168 = x166 * x4
    x169 = x131 * x80
    x170 = x7 * x90
    x171 = x169 - x170 + x24
    x172 = x171 * x5
    x173 = x168 - x172
    x174 = x0 * (x166 - x169 + x170 + x63)
    x175 = x131 * x90 + x64 - x7 * x97
    x176 = x112 * x7
    x177 = x106 * x131
    x178 = x103 * x131 - x106 * x7
    x179 = x0 * (x176 - x177 + x178)
    x180 = -x176 + x177
    x181 = x178 * x4 - x180 * x5
    x182 = x180 * x4
    x183 = x112 * x131
    x184 = x122 * x7
    x185 = x183 - x184
    x186 = x185 * x5
    x187 = x182 - x186
    x188 = x0 * (x180 - x183 + x184)
    x189 = x122 * x131 - x129 * x7
    x190 = -x8 - A[2]
    x191 = x12 * x190
    x192 = x102 + x13 * x190
    x193 = x0 * (x101 - x191 + x192)
    x194 = x105 + x191
    x195 = -x194 * x5
    x196 = x192 * x4 + x195
    x197 = x17 * x190
    x198 = x110 + x197
    x199 = x198 * x4
    x200 = x190 * x23
    x201 = x120 + x200
    x202 = x201 * x5
    x203 = -x202
    x204 = x0 * (x109 + x194 - x197)
    x205 = -x204
    x206 = x194 * x4
    x207 = x198 * x5
    x208 = -x207
    x209 = x206 + x208
    x210 = x194 * x42
    x211 = x192 * x42 + x195
    x212 = x208 + x210
    x213 = x193 + x211 * x4 - x212 * x5
    x214 = x212 * x4
    x215 = x198 * x42
    x216 = x203 + x215
    x217 = x216 * x5
    x218 = x204 + x214 - x217
    x219 = x0 * (x119 + x198 - x200)
    x220 = x128 + x190 * x30
    x221 = x198 * x7
    x222 = x194 * x67
    x223 = -x194 * x7
    x224 = x192 * x67 + x223
    x225 = x0 * (x221 - x222 + x224)
    x226 = -x221
    x227 = x222 + x226
    x228 = x224 * x4 - x227 * x5
    x229 = x227 * x4
    x230 = x198 * x67
    x231 = x201 * x7
    x232 = -x231
    x233 = x230 + x232
    x234 = x233 * x5
    x235 = x229 - x234
    x236 = x0 * (x227 - x230 + x231)
    x237 = -x220 * x7
    x238 = x201 * x67 + x237
    x239 = x112 * x9
    x240 = x106 * x190
    x241 = x103 * x190 - x106 * x9 + x14
    x242 = x0 * (x239 - x240 + x241 + x41)
    x243 = -x239 + x240 + x35
    x244 = x241 * x4 - x243 * x5
    x245 = x243 * x4
    x246 = x112 * x190
    x247 = x122 * x9
    x248 = x24 + x246 - x247
    x249 = x248 * x5
    x250 = x245 - x249
    x251 = x0 * (x243 - x246 + x247 + x63)
    x252 = x122 * x190 - x129 * x9 + x64
    x253 = x131 * x133 - x135 * x7 + x14
    x254 = x131 * x139
    x255 = x142 * x7
    x256 = x24 + x254 - x255
    x257 = x256 * x5
    x258 = x131 * x135
    x259 = x139 * x7
    x260 = x258 - x259 + x35
    x261 = -x260 * x5
    x262 = x260 * x42
    x263 = x253 * x42 + x261
    x264 = x0 * (x253 - x258 + x259 + x41)
    x265 = -x257 + x262
    x266 = x0 * (-x254 + x255 + x260 + x63)
    x267 = x131 * x142 - x161 * x7 + x64
    x268 = x171 * x7
    x269 = x131 * x166
    x270 = x131 * x164 + x134 - x166 * x7 + x72
    x271 = x0 * (x146 + x268 - x269 + x270 + x98)
    x272 = x145 - x268 + x269 + x84
    x273 = x131 * x171 + x160 - x175 * x7 + x95
    x274 = x185 * x7
    x275 = x131 * x180
    x276 = x104 + x131 * x178 - x180 * x7
    x277 = x0 * (x130 + x274 - x275 + x276)
    x278 = x116 - x274 + x275
    x279 = x127 + x131 * x185 - x189 * x7
    x280 = x131 * x192 + x223
    x281 = x131 * x198
    x282 = x232 + x281
    x283 = x282 * x5
    x284 = x131 * x194
    x285 = x226 + x284
    x286 = -x285 * x5
    x287 = x285 * x42
    x288 = x280 * x42 + x286
    x289 = x0 * (x221 + x280 - x284)
    x290 = -x283 + x287
    x291 = x0 * (x231 - x281 + x285)
    x292 = x131 * x201 + x237
    x293 = x233 * x7
    x294 = x131 * x227
    x295 = x131 * x224 + x193 - x227 * x7
    x296 = x0 * (x205 + x293 - x294 + x295)
    x297 = x204 - x293 + x294
    x298 = x131 * x233 + x219 - x238 * x7
    x299 = x248 * x7
    x300 = x131 * x243
    x301 = x131 * x241 - x243 * x7
    x302 = x0 * (x299 - x300 + x301)
    x303 = -x299 + x300
    x304 = x131 * x248 - x252 * x7
    x305 = x14 + x190 * x192 - x194 * x9
    x306 = x190 * x198
    x307 = x201 * x9
    x308 = x24 + x306 - x307
    x309 = x308 * x5
    x310 = x190 * x194
    x311 = x198 * x9
    x312 = x310 - x311 + x35
    x313 = -x312 * x5
    x314 = x312 * x42
    x315 = x305 * x42 + x313
    x316 = x0 * (x305 - x310 + x311 + x41)
    x317 = -x309 + x314
    x318 = x0 * (-x306 + x307 + x312 + x63)
    x319 = x190 * x201 - x220 * x9 + x64
    x320 = x308 * x7
    x321 = x312 * x67
    x322 = -x312 * x7
    x323 = x305 * x67 + x322
    x324 = x0 * (x320 - x321 + x323)
    x325 = -x320
    x326 = x321 + x325
    x327 = -x319 * x7
    x328 = x308 * x67 + x327
    x329 = x248 * x9
    x330 = x190 * x243
    x331 = x104 + x190 * x241 + x193 - x243 * x9
    x332 = x0 * (x130 + x205 + x329 - x330 + x331)
    x333 = x116 + x204 - x329 + x330
    x334 = x127 + x190 * x248 + x219 - x252 * x9
    x335 = x256 * x7
    x336 = x131 * x260
    x337 = 2.0 * x145
    x338 = x131 * x253 + 2.0 * x134 - x260 * x7
    x339 = x0 * (x335 - x336 - x337 + x338)
    x340 = -x335 + x336 + x337
    x341 = x131 * x256 + 2.0 * x160 - x267 * x7
    x342 = x131 * x270 + 2.0 * x165 + x264 - x272 * x7
    x343 = x131 * x272 + 2.0 * x174 + x266 - x273 * x7
    x344 = x131 * x276 + 2.0 * x179 - x278 * x7
    x345 = x131 * x278 + 2.0 * x188 - x279 * x7
    x346 = x282 * x7
    x347 = x131 * x285
    x348 = x131 * x280 + x193 - x285 * x7
    x349 = x0 * (x205 + x346 - x347 + x348)
    x350 = x204 - x346 + x347
    x351 = x131 * x282 + x219 - x292 * x7
    x352 = x131 * x295 + x225 + x289 - x297 * x7
    x353 = x131 * x297 + x236 + x291 - x298 * x7
    x354 = x131 * x301 + x242 - x303 * x7
    x355 = x131 * x303 + x251 - x304 * x7
    x356 = x131 * x312
    x357 = x131 * x305 + x322
    x358 = x0 * (x320 - x356 + x357)
    x359 = x325 + x356
    x360 = x131 * x308 + x327
    x361 = x131 * x323 + x316 - x326 * x7
    x362 = x131 * x326 + x318 - x328 * x7
    x363 = x131 * x331 - x333 * x7
    x364 = x131 * x333 - x334 * x7
    x365 = x308 * x9
    x366 = x190 * x312
    x367 = 2.0 * x204
    x368 = x190 * x305 + 2.0 * x193 - x312 * x9
    x369 = x0 * (x365 - x366 - x367 + x368)
    x370 = -x365 + x366 + x367
    x371 = x190 * x308 + 2.0 * x219 - x319 * x9
    x372 = -x370 * x7
    x373 = x368 * x67 + x372
    x374 = -x371 * x7
    x375 = x370 * x67 + x374
    x376 = x190 * x331 + 2.0 * x242 + x316 - x333 * x9
    x377 = x190 * x333 + 2.0 * x251 + x318 - x334 * x9
    x378 = x190 * x368 + 3.0 * x316 - x370 * x9
    x379 = x190 * x370 + 3.0 * x318 - x371 * x9

    # 45 item(s)
    return numpy.array(
        [
            x0
            * (
                x22 * x4
                - x38 * x4
                - x38 * x5
                - 2.0 * x39
                + 2.0 * x40
                + x5 * (x24 + x29 - x34)
            )
            + x4
            * (
                x0 * (x22 - x36 + x37 + x41)
                + x4 * x52
                - x5 * x61
                + x62 * (x41 + x46 - x47 + x50)
            )
            - x5
            * (
                x0 * (-x29 + x34 + x38 + x63)
                + x4 * x61
                - x5
                * (
                    x0 * (x28 + x31 - x33)
                    + x0 * (x31 + x49 - x56)
                    + x4 * x59
                    - x5 * (x4 * x57 - x5 * (x30 * x42 - x5 * x65) + x64)
                )
                + x62 * (x51 - x55 + x58 + x63)
            )
            + x66 * (-x39 + x52 - x53 - x54 + x60),
            x4 * (x4 * x83 - x5 * x94 + x62 * (x75 - x76 + x81))
            - x5
            * (
                x4 * x94
                - x5 * (x4 * x92 - x5 * (x4 * x90 - x5 * x97) + x95)
                + x62 * (x82 - x86 + x91)
            )
            + x66 * (x83 - x85 + x93 + x98),
            x4 * (x115 * x4 - x126 * x5 + x62 * (x107 - x108 + x113))
            - x5
            * (
                x126 * x4
                - x5 * (x124 * x4 + x127 - x5 * (x122 * x4 - x129 * x5))
                + x62 * (x114 - x118 + x123)
            )
            + x66 * (x115 - x117 + x125 + x130),
            x0 * (x134 + x137 * x4 + x146 - x150 * x4 - x150 * x5 + x5 * (x140 + x144))
            + x4
            * (
                x0 * (x137 - x147 + x148)
                + x0 * (x148 - x151 + x152)
                + x154 * x4
                - x159 * x5
            )
            - x5
            * (
                x0 * (-x140 + x143 + x150)
                + x0 * (x143 + x153 - x156)
                + x159 * x4
                - x5 * (x157 * x4 + x160 - x5 * (x142 * x42 - x161 * x5))
            )
            + x62 * (x146 + x154 - x155 + x158),
            x4 * (x165 + x167 * x4 - x173 * x5)
            - x5 * (x173 * x4 + x174 - x5 * (x171 * x4 - x175 * x5))
            + x62 * (x167 - x168 + x172),
            x4 * (x179 + x181 * x4 - x187 * x5)
            - x5 * (x187 * x4 + x188 - x5 * (x185 * x4 - x189 * x5))
            + x62 * (x181 - x182 + x186),
            x0 * (x193 + x196 * x4 + x205 - x209 * x4 - x209 * x5 + x5 * (x199 + x203))
            + x4
            * (
                x0 * (x196 - x206 + x207)
                + x0 * (x207 - x210 + x211)
                + x213 * x4
                - x218 * x5
            )
            - x5
            * (
                x0 * (-x199 + x202 + x209)
                + x0 * (x202 + x212 - x215)
                + x218 * x4
                - x5 * (x216 * x4 + x219 - x5 * (x201 * x42 - x220 * x5))
            )
            + x62 * (x205 + x213 - x214 + x217),
            x4 * (x225 + x228 * x4 - x235 * x5)
            - x5 * (x235 * x4 + x236 - x5 * (x233 * x4 - x238 * x5))
            + x62 * (x228 - x229 + x234),
            x4 * (x242 + x244 * x4 - x250 * x5)
            - x5 * (x250 * x4 + x251 - x5 * (x248 * x4 - x252 * x5))
            + x62 * (x244 - x245 + x249),
            x0 * (x257 - x262 + x263)
            + x0 * (x253 * x4 + x257 - x260 * x4 + x261)
            + x4 * (x263 * x4 + x264 - x265 * x5)
            - x5 * (x265 * x4 + x266 - x5 * (x256 * x42 - x267 * x5)),
            x271 + x4 * (x270 * x4 - x272 * x5) - x5 * (x272 * x4 - x273 * x5),
            x277 + x4 * (x276 * x4 - x278 * x5) - x5 * (x278 * x4 - x279 * x5),
            x0 * (x283 - x287 + x288)
            + x0 * (x280 * x4 + x283 - x285 * x4 + x286)
            + x4 * (x288 * x4 + x289 - x290 * x5)
            - x5 * (x290 * x4 + x291 - x5 * (x282 * x42 - x292 * x5)),
            x296 + x4 * (x295 * x4 - x297 * x5) - x5 * (x297 * x4 - x298 * x5),
            x302 + x4 * (x301 * x4 - x303 * x5) - x5 * (x303 * x4 - x304 * x5),
            x0 * (x309 - x314 + x315)
            + x0 * (x305 * x4 + x309 - x312 * x4 + x313)
            + x4 * (x315 * x4 + x316 - x317 * x5)
            - x5 * (x317 * x4 + x318 - x5 * (x308 * x42 - x319 * x5)),
            x324 + x4 * (x323 * x4 - x326 * x5) - x5 * (x326 * x4 - x328 * x5),
            x332 + x4 * (x331 * x4 - x333 * x5) - x5 * (x333 * x4 - x334 * x5),
            x339 + x4 * (x338 * x42 - x340 * x5) - x5 * (x340 * x42 - x341 * x5),
            x342 * x4 - x343 * x5,
            x344 * x4 - x345 * x5,
            x349 + x4 * (x348 * x42 - x350 * x5) - x5 * (x350 * x42 - x351 * x5),
            x352 * x4 - x353 * x5,
            x354 * x4 - x355 * x5,
            x358 + x4 * (x357 * x42 - x359 * x5) - x5 * (x359 * x42 - x360 * x5),
            x361 * x4 - x362 * x5,
            x363 * x4 - x364 * x5,
            x369 + x4 * (x368 * x42 - x370 * x5) - x5 * (x370 * x42 - x371 * x5),
            x373 * x4 - x375 * x5,
            x376 * x4 - x377 * x5,
            x42 * (x131 * x338 + 3.0 * x264 - x340 * x7)
            - x5 * (x131 * x340 + 3.0 * x266 - x341 * x7),
            x131 * x342 + 3.0 * x271 + x339 - x343 * x7,
            x131 * x344 + 3.0 * x277 - x345 * x7,
            x42 * (x131 * x348 + 2.0 * x289 - x350 * x7)
            - x5 * (x131 * x350 + 2.0 * x291 - x351 * x7),
            x131 * x352 + 2.0 * x296 + x349 - x353 * x7,
            x131 * x354 + 2.0 * x302 - x355 * x7,
            x42 * (x131 * x357 + x316 - x359 * x7)
            - x5 * (x131 * x359 + x318 - x360 * x7),
            x131 * x361 + x324 + x358 - x362 * x7,
            x131 * x363 + x332 - x364 * x7,
            x42 * (x131 * x368 + x372) - x5 * (x131 * x370 + x374),
            x131 * x373 + x369 - x375 * x7,
            x131 * x376 - x377 * x7,
            x378 * x42 - x379 * x5,
            x378 * x67 - x379 * x7,
            x190 * x376 + 3.0 * x332 + x369 - x377 * x9,
        ]
    )


def coulomb3d_42(a, A, b, B, C):
    """Cartesian (gd) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - B[0]
    x6 = -x2 - C[0]
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 * (x10**2 + x6**2 + x8**2)
    x12 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x13 = x12 * boys(2, x11)
    x14 = x13 * x6
    x15 = -x14
    x16 = x12 * boys(1, x11)
    x17 = x16 * x5
    x18 = x15 + x17
    x19 = x18 * x5
    x20 = -x16 * x6
    x21 = x12 * boys(0, x11)
    x22 = x20 + x21 * x5
    x23 = x4 * (-x16 + x21)
    x24 = -x18 * x6 + x23
    x25 = x22 * x5 + x24
    x26 = x12 * boys(3, x11)
    x27 = x26 * x6
    x28 = -x27
    x29 = x13 * x5
    x30 = x28 + x29
    x31 = x30 * x6
    x32 = x4 * (-x13 + x16)
    x33 = -x32
    x34 = x31 + x33
    x35 = -x31 + x32
    x36 = x19 + x35
    x37 = x4 * (x14 - x17 + x22)
    x38 = x25 * x3 - x36 * x6 + 2.0 * x37
    x39 = x3 * x36
    x40 = x30 * x5
    x41 = x4 * (x13 - x26)
    x42 = x12 * boys(4, x11)
    x43 = x42 * x6
    x44 = -x43
    x45 = x26 * x5
    x46 = x44 + x45
    x47 = x46 * x6
    x48 = x41 - x47
    x49 = x40 + x48
    x50 = x49 * x6
    x51 = x4 * (x18 + x27 - x29)
    x52 = 2.0 * x51
    x53 = x39 - x50 + x52
    x54 = x18 * x3
    x55 = x22 * x3 + x24
    x56 = 2.0 * x4
    x57 = x56 * (x34 - x54 + x55)
    x58 = x3 * x38 + x4 * (-x19 + x25 + x34) - x53 * x6 + x57
    x59 = -x41
    x60 = x47 + x59
    x61 = x4 * (x36 - x40 + x60)
    x62 = x3 * x53
    x63 = x3 * x49
    x64 = x46 * x5
    x65 = x4 * (x26 - x42)
    x66 = x12 * boys(5, x11)
    x67 = x6 * x66
    x68 = x42 * x5
    x69 = -x67 + x68
    x70 = x6 * x69
    x71 = x65 - x70
    x72 = x64 + x71
    x73 = x6 * x72
    x74 = x4 * (x30 + x43 - x45)
    x75 = 2.0 * x74
    x76 = x63 - x73 + x75
    x77 = x6 * x76
    x78 = x3 * x30
    x79 = x35 + x54
    x80 = x56 * (x60 - x78 + x79)
    x81 = x61 + x62 - x77 + x80
    x82 = x48 + x78
    x83 = x6 * x82
    x84 = x13 * x3
    x85 = x16 * x3
    x86 = x15 + x85
    x87 = x4 * (x27 - x84 + x86)
    x88 = x3 * x79
    x89 = x20 + x21 * x3
    x90 = x3 * x55 + x37 + x4 * (x14 - x85 + x89) - x6 * x79
    x91 = -x65
    x92 = x70 + x91
    x93 = x4 * (x42 - x66)
    x94 = x12 * boys(6, x11)
    x95 = x3 * x46
    x96 = x6 * (x71 + x95)
    x97 = x26 * x3
    x98 = x28 + x84
    x99 = x4 * (x43 - x97 + x98)
    x100 = x3 * x82
    x101 = x51 - x83 + x87 + x88
    x102 = x6 * x98
    x103 = x3 * x86
    x104 = -x80
    x105 = 3.0 * x4
    x106 = -x7 - B[1]
    x107 = x106 * x16
    x108 = x13 * x8
    x109 = -x16 * x8
    x110 = x106 * x21 + x109
    x111 = x4 * (-x107 + x108 + x110)
    x112 = -x108
    x113 = x107 + x112
    x114 = -x113 * x6
    x115 = x110 * x3 + x114
    x116 = x113 * x3
    x117 = x26 * x8
    x118 = -x117
    x119 = x106 * x13
    x120 = x118 + x119
    x121 = x120 * x6
    x122 = -x121
    x123 = x116 + x122
    x124 = x111 + x115 * x3 - x123 * x6
    x125 = x106 * x26
    x126 = x42 * x8
    x127 = x4 * (x120 - x125 + x126)
    x128 = x120 * x3
    x129 = -x126
    x130 = x125 + x129
    x131 = x130 * x6
    x132 = -x131
    x133 = x128 + x132
    x134 = x133 * x3
    x135 = x130 * x3
    x136 = x66 * x8
    x137 = -x136
    x138 = x106 * x42
    x139 = x137 + x138
    x140 = x139 * x6
    x141 = -x140
    x142 = x6 * (x135 + x141)
    x143 = x4 * (x113 + x117 - x119)
    x144 = x123 * x3
    x145 = x133 * x6
    x146 = x143 + x144 - x145
    x147 = x4 * (x123 - x128 + x131)
    x148 = x4 * (x115 - x116 + x121)
    x149 = -x143
    x150 = x113 * x5
    x151 = x110 * x5 + x114
    x152 = x122 + x150
    x153 = x111 + x151 * x3 - x152 * x6
    x154 = x152 * x3
    x155 = x120 * x5
    x156 = x132 + x155
    x157 = x156 * x6
    x158 = x143 + x154 - x157
    x159 = x148 + x153 * x3 - x158 * x6 + x4 * (x121 - x150 + x151)
    x160 = x4 * (x131 + x152 - x155)
    x161 = x158 * x3
    x162 = x156 * x3
    x163 = x130 * x5
    x164 = x141 + x163
    x165 = x164 * x6
    x166 = x127 + x162 - x165
    x167 = x166 * x6
    x168 = x147 + x160 + x161 - x167
    x169 = -x127
    x170 = x4 * (x130 + x136 - x138)
    x171 = -x8 * x94
    x172 = x106 * x66 + x171
    x173 = -x9 - B[2]
    x174 = x16 * x173
    x175 = x10 * x13
    x176 = -x10 * x16
    x177 = x173 * x21 + x176
    x178 = x4 * (-x174 + x175 + x177)
    x179 = -x175
    x180 = x174 + x179
    x181 = -x180 * x6
    x182 = x177 * x3 + x181
    x183 = x180 * x3
    x184 = x10 * x26
    x185 = -x184
    x186 = x13 * x173
    x187 = x185 + x186
    x188 = x187 * x6
    x189 = -x188
    x190 = x183 + x189
    x191 = x178 + x182 * x3 - x190 * x6
    x192 = x173 * x26
    x193 = x10 * x42
    x194 = x4 * (x187 - x192 + x193)
    x195 = x187 * x3
    x196 = -x193
    x197 = x192 + x196
    x198 = x197 * x6
    x199 = -x198
    x200 = x195 + x199
    x201 = x200 * x3
    x202 = x197 * x3
    x203 = x10 * x66
    x204 = -x203
    x205 = x173 * x42
    x206 = x204 + x205
    x207 = x206 * x6
    x208 = -x207
    x209 = x6 * (x202 + x208)
    x210 = x4 * (x180 + x184 - x186)
    x211 = x190 * x3
    x212 = x200 * x6
    x213 = x210 + x211 - x212
    x214 = x4 * (x190 - x195 + x198)
    x215 = x4 * (x182 - x183 + x188)
    x216 = -x210
    x217 = x180 * x5
    x218 = x177 * x5 + x181
    x219 = x189 + x217
    x220 = x178 + x218 * x3 - x219 * x6
    x221 = x219 * x3
    x222 = x187 * x5
    x223 = x199 + x222
    x224 = x223 * x6
    x225 = x210 + x221 - x224
    x226 = x215 + x220 * x3 - x225 * x6 + x4 * (x188 - x217 + x218)
    x227 = x4 * (x198 + x219 - x222)
    x228 = x225 * x3
    x229 = x223 * x3
    x230 = x197 * x5
    x231 = x208 + x230
    x232 = x231 * x6
    x233 = x194 + x229 - x232
    x234 = x233 * x6
    x235 = x214 + x227 + x228 - x234
    x236 = -x194
    x237 = x4 * (x197 + x203 - x205)
    x238 = -x10 * x94
    x239 = x173 * x66 + x238
    x240 = x106 * x113
    x241 = -x113 * x8 + x23
    x242 = x106 * x110 + x241
    x243 = x120 * x8
    x244 = x243 + x33
    x245 = x4 * (-x240 + x242 + x244)
    x246 = -x243 + x32
    x247 = x240 + x246
    x248 = x242 * x3 - x247 * x6
    x249 = x247 * x3
    x250 = x106 * x120
    x251 = x130 * x8
    x252 = -x251 + x41
    x253 = x250 + x252
    x254 = x253 * x6
    x255 = x249 - x254
    x256 = x245 + x248 * x3 - x255 * x6
    x257 = x251 + x59
    x258 = x4 * (x247 - x250 + x257)
    x259 = x255 * x3
    x260 = x253 * x3
    x261 = x106 * x130
    x262 = x139 * x8
    x263 = -x262 + x65
    x264 = x261 + x263
    x265 = x264 * x6
    x266 = x260 - x265
    x267 = x266 * x6
    x268 = x258 + x259 - x267
    x269 = x262 + x91
    x270 = x4 * (x253 - x261 + x269)
    x271 = -x172 * x8 + x93
    x272 = x106 * x139 + x271
    x273 = -x258
    x274 = x187 * x8
    x275 = x106 * x180
    x276 = -x180 * x8
    x277 = x106 * x177 + x276
    x278 = x4 * (x274 - x275 + x277)
    x279 = -x274
    x280 = x275 + x279
    x281 = x277 * x3 - x280 * x6
    x282 = x280 * x3
    x283 = x106 * x187
    x284 = x197 * x8
    x285 = -x284
    x286 = x283 + x285
    x287 = x286 * x6
    x288 = x282 - x287
    x289 = x278 + x281 * x3 - x288 * x6
    x290 = x4 * (x280 - x283 + x284)
    x291 = x288 * x3
    x292 = x286 * x3
    x293 = x106 * x197
    x294 = x206 * x8
    x295 = -x294
    x296 = x293 + x295
    x297 = x296 * x6
    x298 = x292 - x297
    x299 = x298 * x6
    x300 = x290 + x291 - x299
    x301 = x4 * (x286 - x293 + x294)
    x302 = -x239 * x8
    x303 = x106 * x206 + x302
    x304 = -x290
    x305 = x173 * x180
    x306 = -x10 * x180 + x23
    x307 = x173 * x177 + x306
    x308 = x10 * x187
    x309 = x308 + x33
    x310 = x4 * (-x305 + x307 + x309)
    x311 = -x308 + x32
    x312 = x305 + x311
    x313 = x3 * x307 - x312 * x6
    x314 = x3 * x312
    x315 = x173 * x187
    x316 = x10 * x197
    x317 = -x316 + x41
    x318 = x315 + x317
    x319 = x318 * x6
    x320 = x314 - x319
    x321 = x3 * x313 + x310 - x320 * x6
    x322 = x316 + x59
    x323 = x4 * (x312 - x315 + x322)
    x324 = x3 * x320
    x325 = x3 * x318
    x326 = x173 * x197
    x327 = x10 * x206
    x328 = -x327 + x65
    x329 = x326 + x328
    x330 = x329 * x6
    x331 = x325 - x330
    x332 = x331 * x6
    x333 = x323 + x324 - x332
    x334 = x327 + x91
    x335 = x4 * (x318 - x326 + x334)
    x336 = -x10 * x239 + x93
    x337 = x173 * x206 + x336
    x338 = -x323
    x339 = -x7 - A[1]
    x340 = x16 * x339
    x341 = x112 + x340
    x342 = x341 * x5
    x343 = x13 * x339
    x344 = x118 + x343
    x345 = x344 * x6
    x346 = -x345
    x347 = x342 + x346
    x348 = x347 * x5
    x349 = x109 + x21 * x339
    x350 = -x341 * x6
    x351 = x349 * x5 + x350
    x352 = x4 * (x108 - x340 + x349)
    x353 = -x347 * x6 + x352
    x354 = x351 * x5 + x353
    x355 = x344 * x5
    x356 = x26 * x339
    x357 = x129 + x356
    x358 = x357 * x6
    x359 = x355 - x358
    x360 = x359 * x6
    x361 = x4 * (x117 + x341 - x343)
    x362 = -x361
    x363 = x360 + x362
    x364 = -x360 + x361
    x365 = x348 + x364
    x366 = x4 * (-x342 + x345 + x351)
    x367 = x3 * x354 - x365 * x6 + 2.0 * x366
    x368 = x3 * x365
    x369 = x359 * x5
    x370 = x4 * (x126 + x344 - x356)
    x371 = x357 * x5
    x372 = x339 * x42
    x373 = x137 + x372
    x374 = x373 * x6
    x375 = x371 - x374
    x376 = x375 * x6
    x377 = x370 - x376
    x378 = x369 + x377
    x379 = x378 * x6
    x380 = x4 * (x347 - x355 + x358)
    x381 = 2.0 * x380
    x382 = x368 - x379 + x381
    x383 = x3 * x347
    x384 = x3 * x351 + x353
    x385 = -x370
    x386 = x376 + x385
    x387 = x4 * (x136 + x357 - x372)
    x388 = x171 + x339 * x66
    x389 = x3 * x359
    x390 = x364 + x383
    x391 = x3 * x341
    x392 = x113 * x339
    x393 = x110 * x339 + x241
    x394 = x4 * (x244 - x392 + x393)
    x395 = x246 + x392
    x396 = -x395 * x6
    x397 = x3 * x393 + x396
    x398 = x120 * x339
    x399 = x252 + x398
    x400 = x3 * x399
    x401 = x130 * x339
    x402 = x263 + x401
    x403 = x402 * x6
    x404 = -x403
    x405 = x4 * (x257 + x395 - x398)
    x406 = -x405
    x407 = x3 * x395
    x408 = x399 * x6
    x409 = -x408
    x410 = x407 + x409
    x411 = x395 * x5
    x412 = x393 * x5 + x396
    x413 = x409 + x411
    x414 = x3 * x412 + x394 - x413 * x6
    x415 = x3 * x413
    x416 = x399 * x5
    x417 = x404 + x416
    x418 = x417 * x6
    x419 = x405 + x415 - x418
    x420 = x4 * (x269 + x399 - x401)
    x421 = x139 * x339 + x271
    x422 = x180 * x339
    x423 = x177 * x339 + x276
    x424 = x4 * (x274 - x422 + x423)
    x425 = x279 + x422
    x426 = -x425 * x6
    x427 = x3 * x423 + x426
    x428 = x187 * x339
    x429 = x285 + x428
    x430 = x3 * x429
    x431 = x197 * x339
    x432 = x295 + x431
    x433 = x432 * x6
    x434 = -x433
    x435 = x4 * (x284 + x425 - x428)
    x436 = -x435
    x437 = x3 * x425
    x438 = x429 * x6
    x439 = -x438
    x440 = x437 + x439
    x441 = x425 * x5
    x442 = x423 * x5 + x426
    x443 = x439 + x441
    x444 = x3 * x442 + x424 - x443 * x6
    x445 = x3 * x443
    x446 = x429 * x5
    x447 = x434 + x446
    x448 = x447 * x6
    x449 = x435 + x445 - x448
    x450 = x4 * (x294 + x429 - x431)
    x451 = x206 * x339 + x302
    x452 = x253 * x8
    x453 = x247 * x339
    x454 = 2.0 * x143
    x455 = 2.0 * x111 + x242 * x339 - x247 * x8
    x456 = x4 * (x452 - x453 - x454 + x455)
    x457 = -x452 + x453 + x454
    x458 = x3 * x455 - x457 * x6
    x459 = x3 * x457
    x460 = x253 * x339
    x461 = x264 * x8
    x462 = 2.0 * x127
    x463 = x460 - x461 + x462
    x464 = x463 * x6
    x465 = x459 - x464
    x466 = x4 * (x457 - x460 + x461 - x462)
    x467 = 2.0 * x170 + x264 * x339 - x272 * x8
    x468 = x286 * x8
    x469 = x280 * x339
    x470 = x178 + x277 * x339 - x280 * x8
    x471 = x4 * (x216 + x468 - x469 + x470)
    x472 = x210 - x468 + x469
    x473 = x3 * x470 - x472 * x6
    x474 = x3 * x472
    x475 = x286 * x339
    x476 = x296 * x8
    x477 = x194 + x475 - x476
    x478 = x477 * x6
    x479 = x474 - x478
    x480 = x4 * (x236 + x472 - x475 + x476)
    x481 = x237 + x296 * x339 - x303 * x8
    x482 = x318 * x8
    x483 = x312 * x339
    x484 = x307 * x339 - x312 * x8
    x485 = x4 * (x482 - x483 + x484)
    x486 = -x482 + x483
    x487 = x3 * x484 - x486 * x6
    x488 = x3 * x486
    x489 = x318 * x339
    x490 = x329 * x8
    x491 = x489 - x490
    x492 = x491 * x6
    x493 = x488 - x492
    x494 = x4 * (x486 - x489 + x490)
    x495 = x329 * x339 - x337 * x8
    x496 = -x9 - A[2]
    x497 = x16 * x496
    x498 = x179 + x497
    x499 = x498 * x5
    x500 = x13 * x496
    x501 = x185 + x500
    x502 = x501 * x6
    x503 = -x502
    x504 = x499 + x503
    x505 = x5 * x504
    x506 = x176 + x21 * x496
    x507 = -x498 * x6
    x508 = x5 * x506 + x507
    x509 = x4 * (x175 - x497 + x506)
    x510 = -x504 * x6 + x509
    x511 = x5 * x508 + x510
    x512 = x5 * x501
    x513 = x26 * x496
    x514 = x196 + x513
    x515 = x514 * x6
    x516 = x512 - x515
    x517 = x516 * x6
    x518 = x4 * (x184 + x498 - x500)
    x519 = -x518
    x520 = x517 + x519
    x521 = -x517 + x518
    x522 = x505 + x521
    x523 = x4 * (-x499 + x502 + x508)
    x524 = x3 * x511 - x522 * x6 + 2.0 * x523
    x525 = x3 * x522
    x526 = x5 * x516
    x527 = x4 * (x193 + x501 - x513)
    x528 = x5 * x514
    x529 = x42 * x496
    x530 = x204 + x529
    x531 = x530 * x6
    x532 = x528 - x531
    x533 = x532 * x6
    x534 = x527 - x533
    x535 = x526 + x534
    x536 = x535 * x6
    x537 = x4 * (x504 - x512 + x515)
    x538 = 2.0 * x537
    x539 = x525 - x536 + x538
    x540 = x3 * x504
    x541 = x3 * x508 + x510
    x542 = -x527
    x543 = x533 + x542
    x544 = x4 * (x203 + x514 - x529)
    x545 = x238 + x496 * x66
    x546 = x3 * x516
    x547 = x521 + x540
    x548 = x3 * x498
    x549 = x501 * x8
    x550 = x106 * x498
    x551 = -x498 * x8
    x552 = x106 * x506 + x551
    x553 = x4 * (x549 - x550 + x552)
    x554 = -x549
    x555 = x550 + x554
    x556 = -x555 * x6
    x557 = x3 * x552 + x556
    x558 = x106 * x501
    x559 = x514 * x8
    x560 = -x559
    x561 = x558 + x560
    x562 = x3 * x561
    x563 = x106 * x514
    x564 = x530 * x8
    x565 = -x564
    x566 = x563 + x565
    x567 = x566 * x6
    x568 = -x567
    x569 = x4 * (x555 - x558 + x559)
    x570 = -x569
    x571 = x3 * x555
    x572 = x561 * x6
    x573 = -x572
    x574 = x571 + x573
    x575 = x5 * x555
    x576 = x5 * x552 + x556
    x577 = x573 + x575
    x578 = x3 * x576 + x553 - x577 * x6
    x579 = x3 * x577
    x580 = x5 * x561
    x581 = x568 + x580
    x582 = x581 * x6
    x583 = x569 + x579 - x582
    x584 = x4 * (x561 - x563 + x564)
    x585 = -x545 * x8
    x586 = x106 * x530 + x585
    x587 = x180 * x496
    x588 = x177 * x496 + x306
    x589 = x4 * (x309 - x587 + x588)
    x590 = x311 + x587
    x591 = -x590 * x6
    x592 = x3 * x588 + x591
    x593 = x187 * x496
    x594 = x317 + x593
    x595 = x3 * x594
    x596 = x197 * x496
    x597 = x328 + x596
    x598 = x597 * x6
    x599 = -x598
    x600 = x4 * (x322 + x590 - x593)
    x601 = -x600
    x602 = x3 * x590
    x603 = x594 * x6
    x604 = -x603
    x605 = x602 + x604
    x606 = x5 * x590
    x607 = x5 * x588 + x591
    x608 = x604 + x606
    x609 = x3 * x607 + x589 - x6 * x608
    x610 = x3 * x608
    x611 = x5 * x594
    x612 = x599 + x611
    x613 = x6 * x612
    x614 = x600 + x610 - x613
    x615 = x4 * (x334 + x594 - x596)
    x616 = x206 * x496 + x336
    x617 = x106 * x555
    x618 = x509 - x555 * x8
    x619 = x106 * x552 + x618
    x620 = x561 * x8
    x621 = x519 + x620
    x622 = x4 * (-x617 + x619 + x621)
    x623 = x518 - x620
    x624 = x617 + x623
    x625 = x3 * x619 - x6 * x624
    x626 = x3 * x624
    x627 = x106 * x561
    x628 = x566 * x8
    x629 = x527 - x628
    x630 = x627 + x629
    x631 = x6 * x630
    x632 = x626 - x631
    x633 = x542 + x628
    x634 = x4 * (x624 - x627 + x633)
    x635 = x544 - x586 * x8
    x636 = x106 * x566 + x635
    x637 = x594 * x8
    x638 = x106 * x590
    x639 = -x590 * x8
    x640 = x106 * x588 + x639
    x641 = x4 * (x637 - x638 + x640)
    x642 = -x637
    x643 = x638 + x642
    x644 = x3 * x640 - x6 * x643
    x645 = x3 * x643
    x646 = x106 * x594
    x647 = x597 * x8
    x648 = -x647
    x649 = x646 + x648
    x650 = x6 * x649
    x651 = x645 - x650
    x652 = x4 * (x643 - x646 + x647)
    x653 = -x616 * x8
    x654 = x106 * x597 + x653
    x655 = x10 * x318
    x656 = x312 * x496
    x657 = 2.0 * x210
    x658 = -x10 * x312 + 2.0 * x178 + x307 * x496
    x659 = x4 * (x655 - x656 - x657 + x658)
    x660 = -x655 + x656 + x657
    x661 = x3 * x658 - x6 * x660
    x662 = x3 * x660
    x663 = x318 * x496
    x664 = x10 * x329
    x665 = 2.0 * x194
    x666 = x663 - x664 + x665
    x667 = x6 * x666
    x668 = x662 - x667
    x669 = x4 * (x660 - x663 + x664 - x665)
    x670 = -x10 * x337 + 2.0 * x237 + x329 * x496
    x671 = x339 * x341
    x672 = x344 * x8
    x673 = x32 + x671 - x672
    x674 = x5 * x673
    x675 = x339 * x344
    x676 = x357 * x8
    x677 = x41 + x675 - x676
    x678 = x6 * x677
    x679 = x674 - x678
    x680 = x5 * x679
    x681 = x23 + x339 * x349 - x341 * x8
    x682 = x5 * x681 - x6 * x673
    x683 = x4 * (x33 - x671 + x672 + x681)
    x684 = -x6 * x679 + x683
    x685 = x5 * x682 + x684
    x686 = x5 * x677
    x687 = x339 * x357
    x688 = x373 * x8
    x689 = x65 + x687 - x688
    x690 = x6 * x689
    x691 = x686 - x690
    x692 = x6 * x691
    x693 = x4 * (x59 + x673 - x675 + x676)
    x694 = -x693
    x695 = x692 + x694
    x696 = x680 - x692 + x693
    x697 = x4 * (x677 - x687 + x688 + x91)
    x698 = x339 * x373 - x388 * x8 + x93
    x699 = x111 + x339 * x393 + x352 - x395 * x8
    x700 = x339 * x399
    x701 = x402 * x8
    x702 = x127 + x370 + x700 - x701
    x703 = x6 * x702
    x704 = x339 * x395
    x705 = x399 * x8
    x706 = x143 + x361 + x704 - x705
    x707 = -x6 * x706
    x708 = x5 * x706
    x709 = x5 * x699 + x707
    x710 = x4 * (x149 + x362 + x699 - x704 + x705)
    x711 = -x703 + x708
    x712 = x4 * (x169 + x385 - x700 + x701 + x706)
    x713 = x170 + x339 * x402 + x387 - x421 * x8
    x714 = x178 + x339 * x423 - x425 * x8
    x715 = x339 * x429
    x716 = x432 * x8
    x717 = x194 + x715 - x716
    x718 = x6 * x717
    x719 = x339 * x425
    x720 = x429 * x8
    x721 = x210 + x719 - x720
    x722 = -x6 * x721
    x723 = x5 * x721
    x724 = x5 * x714 + x722
    x725 = x4 * (x216 + x714 - x719 + x720)
    x726 = -x718 + x723
    x727 = x4 * (x236 - x715 + x716 + x721)
    x728 = x237 + x339 * x432 - x451 * x8
    x729 = x463 * x8
    x730 = x339 * x457
    x731 = 2.0 * x405
    x732 = -x731
    x733 = 2.0 * x394
    x734 = x245 + x339 * x455 - x457 * x8 + x733
    x735 = x4 * (x273 + x729 - x730 + x732 + x734)
    x736 = x258 - x729 + x730 + x731
    x737 = 2.0 * x420
    x738 = x270 + x339 * x463 - x467 * x8 + x737
    x739 = x477 * x8
    x740 = x339 * x472
    x741 = x278 + x339 * x470 + x424 - x472 * x8
    x742 = x4 * (x304 + x436 + x739 - x740 + x741)
    x743 = x290 + x435 - x739 + x740
    x744 = x301 + x339 * x477 + x450 - x481 * x8
    x745 = x491 * x8
    x746 = x339 * x486
    x747 = x310 + x339 * x484 - x486 * x8
    x748 = x4 * (x338 + x745 - x746 + x747)
    x749 = x323 - x745 + x746
    x750 = x335 + x339 * x491 - x495 * x8
    x751 = x339 * x498
    x752 = x554 + x751
    x753 = x5 * x752
    x754 = x339 * x501
    x755 = x560 + x754
    x756 = x6 * x755
    x757 = x753 - x756
    x758 = x5 * x757
    x759 = x339 * x506 + x551
    x760 = x5 * x759 - x6 * x752
    x761 = x4 * (x549 - x751 + x759)
    x762 = -x6 * x757 + x761
    x763 = x5 * x760 + x762
    x764 = x5 * x755
    x765 = x339 * x514
    x766 = x565 + x765
    x767 = x6 * x766
    x768 = x764 - x767
    x769 = x6 * x768
    x770 = x4 * (x559 + x752 - x754)
    x771 = -x770
    x772 = x769 + x771
    x773 = x758 - x769 + x770
    x774 = x4 * (x564 + x755 - x765)
    x775 = x339 * x530 + x585
    x776 = x339 * x552 + x618
    x777 = x339 * x561
    x778 = x629 + x777
    x779 = x6 * x778
    x780 = x339 * x555
    x781 = x623 + x780
    x782 = -x6 * x781
    x783 = x5 * x781
    x784 = x5 * x776 + x782
    x785 = x4 * (x621 + x776 - x780)
    x786 = -x779 + x783
    x787 = x4 * (x633 - x777 + x781)
    x788 = x339 * x566 + x635
    x789 = x339 * x588 + x639
    x790 = x339 * x594
    x791 = x648 + x790
    x792 = x6 * x791
    x793 = x339 * x590
    x794 = x642 + x793
    x795 = -x6 * x794
    x796 = x5 * x794
    x797 = x5 * x789 + x795
    x798 = x4 * (x637 + x789 - x793)
    x799 = -x792 + x796
    x800 = x4 * (x647 - x790 + x794)
    x801 = x339 * x597 + x653
    x802 = x630 * x8
    x803 = x339 * x624
    x804 = 2.0 * x569
    x805 = x339 * x619 + 2.0 * x553 - x624 * x8
    x806 = x4 * (x802 - x803 - x804 + x805)
    x807 = -x802 + x803 + x804
    x808 = x339 * x630 + 2.0 * x584 - x636 * x8
    x809 = x649 * x8
    x810 = x339 * x643
    x811 = x339 * x640 + x589 - x643 * x8
    x812 = x4 * (x601 + x809 - x810 + x811)
    x813 = x600 - x809 + x810
    x814 = x339 * x649 + x615 - x654 * x8
    x815 = x666 * x8
    x816 = x339 * x660
    x817 = x339 * x658 - x660 * x8
    x818 = x4 * (x815 - x816 + x817)
    x819 = -x815 + x816
    x820 = x339 * x666 - x670 * x8
    x821 = x496 * x498
    x822 = x10 * x501
    x823 = x32 + x821 - x822
    x824 = x5 * x823
    x825 = x496 * x501
    x826 = x10 * x514
    x827 = x41 + x825 - x826
    x828 = x6 * x827
    x829 = x824 - x828
    x830 = x5 * x829
    x831 = -x10 * x498 + x23 + x496 * x506
    x832 = x5 * x831 - x6 * x823
    x833 = x4 * (x33 - x821 + x822 + x831)
    x834 = -x6 * x829 + x833
    x835 = x5 * x832 + x834
    x836 = x5 * x827
    x837 = x496 * x514
    x838 = x10 * x530
    x839 = x65 + x837 - x838
    x840 = x6 * x839
    x841 = x836 - x840
    x842 = x6 * x841
    x843 = x4 * (x59 + x823 - x825 + x826)
    x844 = -x843
    x845 = x842 + x844
    x846 = x830 - x842 + x843
    x847 = x4 * (x827 - x837 + x838 + x91)
    x848 = -x10 * x545 + x496 * x530 + x93
    x849 = -x8 * x823
    x850 = x106 * x831 + x849
    x851 = x106 * x827
    x852 = x8 * x839
    x853 = -x852
    x854 = x851 + x853
    x855 = x6 * x854
    x856 = x106 * x823
    x857 = x8 * x827
    x858 = -x857
    x859 = x856 + x858
    x860 = -x6 * x859
    x861 = x5 * x859
    x862 = x5 * x850 + x860
    x863 = x4 * (x850 - x856 + x857)
    x864 = -x855 + x861
    x865 = x4 * (-x851 + x852 + x859)
    x866 = -x8 * x848
    x867 = x106 * x839 + x866
    x868 = -x10 * x590 + x178 + x496 * x588 + x509
    x869 = x496 * x594
    x870 = x10 * x597
    x871 = x194 + x527 + x869 - x870
    x872 = x6 * x871
    x873 = x496 * x590
    x874 = x10 * x594
    x875 = x210 + x518 + x873 - x874
    x876 = -x6 * x875
    x877 = x5 * x875
    x878 = x5 * x868 + x876
    x879 = x4 * (x216 + x519 + x868 - x873 + x874)
    x880 = -x872 + x877
    x881 = x4 * (x236 + x542 - x869 + x870 + x875)
    x882 = -x10 * x616 + x237 + x496 * x597 + x544
    x883 = x106 * x859
    x884 = -x8 * x859 + x833
    x885 = x106 * x850 + x884
    x886 = x8 * x854
    x887 = x844 + x886
    x888 = x4 * (-x883 + x885 + x887)
    x889 = x843 - x886
    x890 = x883 + x889
    x891 = -x8 * x867 + x847
    x892 = x106 * x854 + x891
    x893 = x8 * x871
    x894 = x106 * x875
    x895 = -x8 * x875
    x896 = x106 * x868 + x895
    x897 = x4 * (x893 - x894 + x896)
    x898 = -x893
    x899 = x894 + x898
    x900 = -x8 * x882
    x901 = x106 * x871 + x900
    x902 = x10 * x666
    x903 = x496 * x660
    x904 = 2.0 * x600
    x905 = -x904
    x906 = 2.0 * x589
    x907 = -x10 * x660 + x310 + x496 * x658 + x906
    x908 = x4 * (x338 + x902 - x903 + x905 + x907)
    x909 = x323 - x902 + x903 + x904
    x910 = 2.0 * x615
    x911 = -x10 * x670 + x335 + x496 * x666 + x910
    x912 = x677 * x8
    x913 = x339 * x673
    x914 = 2.0 * x361
    x915 = x339 * x681 + 2.0 * x352 - x673 * x8
    x916 = x4 * (x912 - x913 - x914 + x915)
    x917 = -x912 + x913 + x914
    x918 = x5 * x915 - x6 * x917
    x919 = x5 * x917
    x920 = x339 * x677
    x921 = x689 * x8
    x922 = 2.0 * x370
    x923 = x920 - x921 + x922
    x924 = x6 * x923
    x925 = x919 - x924
    x926 = x4 * (x917 - x920 + x921 - x922)
    x927 = x339 * x689 + 2.0 * x387 - x698 * x8
    x928 = x702 * x8
    x929 = x339 * x706
    x930 = x339 * x699 + x683 - x706 * x8 + x733
    x931 = x4 * (x694 + x732 + x928 - x929 + x930)
    x932 = x693 + x731 - x928 + x929
    x933 = x339 * x702 + x697 - x713 * x8 + x737
    x934 = x717 * x8
    x935 = x339 * x721
    x936 = 2.0 * x435
    x937 = x339 * x714 + 2.0 * x424 - x721 * x8
    x938 = x4 * (x934 - x935 - x936 + x937)
    x939 = -x934 + x935 + x936
    x940 = x339 * x717 + 2.0 * x450 - x728 * x8
    x941 = x339 * x734 + 2.0 * x456 + 2.0 * x710 - x736 * x8
    x942 = x339 * x736 + 2.0 * x466 + 2.0 * x712 - x738 * x8
    x943 = x339 * x741 + 2.0 * x471 + x725 - x743 * x8
    x944 = x339 * x743 + 2.0 * x480 + x727 - x744 * x8
    x945 = x339 * x747 + 2.0 * x485 - x749 * x8
    x946 = x339 * x749 + 2.0 * x494 - x750 * x8
    x947 = x755 * x8
    x948 = x339 * x752
    x949 = x339 * x759 + x509 - x752 * x8
    x950 = x4 * (x519 + x947 - x948 + x949)
    x951 = x518 - x947 + x948
    x952 = x5 * x949 - x6 * x951
    x953 = x5 * x951
    x954 = x339 * x755
    x955 = x766 * x8
    x956 = x527 + x954 - x955
    x957 = x6 * x956
    x958 = x953 - x957
    x959 = x4 * (x542 + x951 - x954 + x955)
    x960 = x339 * x766 + x544 - x775 * x8
    x961 = x778 * x8
    x962 = x339 * x781
    x963 = x339 * x776 + x553 + x761 - x781 * x8
    x964 = x4 * (x570 + x771 + x961 - x962 + x963)
    x965 = x569 + x770 - x961 + x962
    x966 = x339 * x778 + x584 + x774 - x788 * x8
    x967 = x791 * x8
    x968 = x339 * x794
    x969 = x339 * x789 + x589 - x794 * x8
    x970 = x4 * (x601 + x967 - x968 + x969)
    x971 = x600 - x967 + x968
    x972 = x339 * x791 + x615 - x8 * x801
    x973 = 2.0 * x785
    x974 = x339 * x805 + x622 - x8 * x807 + x973
    x975 = 2.0 * x787
    x976 = x339 * x807 + x634 - x8 * x808 + x975
    x977 = x339 * x811 + x641 + x798 - x8 * x813
    x978 = x339 * x813 + x652 - x8 * x814 + x800
    x979 = x339 * x817 + x659 - x8 * x819
    x980 = x339 * x819 + x669 - x8 * x820
    x981 = x339 * x823
    x982 = x339 * x831 + x849
    x983 = x4 * (x857 - x981 + x982)
    x984 = x858 + x981
    x985 = x5 * x982 - x6 * x984
    x986 = x5 * x984
    x987 = x339 * x827
    x988 = x853 + x987
    x989 = x6 * x988
    x990 = x986 - x989
    x991 = x4 * (x852 + x984 - x987)
    x992 = x339 * x839 + x866
    x993 = x339 * x859
    x994 = x339 * x850 + x884
    x995 = x4 * (x887 - x993 + x994)
    x996 = x889 + x993
    x997 = x339 * x854 + x891
    x998 = x339 * x875
    x999 = x339 * x868 + x895
    x1000 = x4 * (x893 - x998 + x999)
    x1001 = x898 + x998
    x1002 = x339 * x871 + x900
    x1003 = x339 * x885 - x8 * x890 + 2.0 * x863
    x1004 = x339 * x890 - x8 * x892 + 2.0 * x865
    x1005 = x339 * x896 - x8 * x899 + x879
    x1006 = x339 * x899 - x8 * x901 + x881
    x1007 = x339 * x907 - x8 * x909
    x1008 = x339 * x909 - x8 * x911
    x1009 = x10 * x827
    x1010 = x496 * x823
    x1011 = 2.0 * x518
    x1012 = -x10 * x823 + x496 * x831 + 2.0 * x509
    x1013 = x4 * (x1009 - x1010 - x1011 + x1012)
    x1014 = -x1009 + x1010 + x1011
    x1015 = x1012 * x5 - x1014 * x6
    x1016 = x1014 * x5
    x1017 = x496 * x827
    x1018 = x10 * x839
    x1019 = 2.0 * x527
    x1020 = x1017 - x1018 + x1019
    x1021 = x1020 * x6
    x1022 = x1016 - x1021
    x1023 = x4 * (x1014 - x1017 + x1018 - x1019)
    x1024 = -x10 * x848 + x496 * x839 + 2.0 * x544
    x1025 = x1020 * x8
    x1026 = x1014 * x106
    x1027 = -x1014 * x8
    x1028 = x1012 * x106 + x1027
    x1029 = x4 * (x1025 - x1026 + x1028)
    x1030 = -x1025
    x1031 = x1026 + x1030
    x1032 = -x1024 * x8
    x1033 = x1020 * x106 + x1032
    x1034 = x10 * x871
    x1035 = x496 * x875
    x1036 = -x10 * x875 + x496 * x868 + x833 + x906
    x1037 = x4 * (x1034 - x1035 + x1036 + x844 + x905)
    x1038 = -x1034 + x1035 + x843 + x904
    x1039 = -x10 * x882 + x496 * x871 + x847 + x910
    x1040 = x1013 - x1031 * x8
    x1041 = x1028 * x106 + x1040
    x1042 = x1023 - x1033 * x8
    x1043 = x1031 * x106 + x1042
    x1044 = -x1038 * x8
    x1045 = x1036 * x106 + x1044
    x1046 = -x1039 * x8
    x1047 = x1038 * x106 + x1046
    x1048 = -x10 * x909 + x496 * x907 + 2.0 * x659 + 2.0 * x879
    x1049 = -x10 * x911 + x496 * x909 + 2.0 * x669 + 2.0 * x881
    x1050 = x8 * x923
    x1051 = x339 * x917
    x1052 = 3.0 * x693
    x1053 = x339 * x915 + 3.0 * x683 - x8 * x917
    x1054 = -x1050 + x1051 + x1052
    x1055 = x8 * x956
    x1056 = x339 * x951
    x1057 = 2.0 * x770
    x1058 = x339 * x949 + 2.0 * x761 - x8 * x951
    x1059 = -x1055 + x1056 + x1057
    x1060 = x8 * x988
    x1061 = x339 * x984
    x1062 = x339 * x982 - x8 * x984 + x833
    x1063 = -x1060 + x1061 + x843
    x1064 = x1014 * x339
    x1065 = x1012 * x339 + x1027
    x1066 = x1030 + x1064
    x1067 = x10 * x1020
    x1068 = x1014 * x496
    x1069 = 3.0 * x843
    x1070 = -x10 * x1014 + x1012 * x496 + 3.0 * x833
    x1071 = x4 * (x1067 - x1068 - x1069 + x1070)
    x1072 = -x1067 + x1068 + x1069
    x1073 = -x10 * x1024 + x1020 * x496 + 3.0 * x847
    x1074 = x106 * x1070 - x1072 * x8
    x1075 = x106 * x1072 - x1073 * x8
    x1076 = -x10 * x1038 + x1013 + x1036 * x496 + 3.0 * x879
    x1077 = -x10 * x1039 + x1023 + x1038 * x496 + 3.0 * x881

    # 90 item(s)
    return numpy.array(
        [
            x105 * (x104 + x58 - x61 - x62 + x77)
            + x3
            * (
                x3 * x58
                + x56 * (x38 - x39 + x50 - x52)
                + x56 * (-x51 + x83 - x87 - x88 + x90)
                - x6 * x81
            )
            + x56
            * (
                -x101 * x3
                - x101 * x6
                + x104
                + x3 * x90
                - x4 * (-x102 + x103 - x3 * x98 + x32 + x59 + x6 * (x44 + x97))
                + x4 * (x102 - x103 + x23 + x3 * x89 + x33 - x6 * x86)
                + x57
                + x6 * (x100 + x74 - x96 + x99)
            )
            - x6
            * (
                x3 * x81
                + x56 * (x53 - x63 + x73 - x75)
                + x56 * (-x100 + x101 - x74 + x96 - x99)
                - x6
                * (
                    x3 * x76
                    + x4 * (x49 - x64 + x92)
                    + x56 * (x82 + x92 - x95)
                    - x6
                    * (
                        x3 * x72
                        + x56 * (x46 + x67 - x68)
                        - x6 * (x5 * x69 - x6 * (x5 * x66 - x6 * x94) + x93)
                    )
                )
            ),
            x105 * (-x147 + x159 - x160 - x161 + x167)
            + x3
            * (
                x159 * x3
                - x168 * x6
                + x4 * (x124 - x144 + x145 + x149)
                + x56 * (x149 + x153 - x154 + x157)
            )
            + x4
            * (
                x124 * x3
                - x146 * x3
                - x146 * x6
                - 2.0 * x147
                + 2.0 * x148
                + x6 * (x127 + x134 - x142)
            )
            - x6
            * (
                x168 * x3
                + x4 * (-x134 + x142 + x146 + x169)
                + x56 * (x158 - x162 + x165 + x169)
                - x6
                * (
                    x166 * x3
                    + x4 * (x133 - x135 + x140)
                    + x4 * (x140 + x156 - x163)
                    - x6 * (x164 * x3 + x170 - x6 * (x139 * x5 - x172 * x6))
                )
            ),
            x105 * (-x214 + x226 - x227 - x228 + x234)
            + x3
            * (
                x226 * x3
                - x235 * x6
                + x4 * (x191 - x211 + x212 + x216)
                + x56 * (x216 + x220 - x221 + x224)
            )
            + x4
            * (
                x191 * x3
                - x213 * x3
                - x213 * x6
                - 2.0 * x214
                + 2.0 * x215
                + x6 * (x194 + x201 - x209)
            )
            - x6
            * (
                x235 * x3
                + x4 * (-x201 + x209 + x213 + x236)
                + x56 * (x225 - x229 + x232 + x236)
                - x6
                * (
                    x233 * x3
                    + x4 * (x200 - x202 + x207)
                    + x4 * (x207 + x223 - x230)
                    - x6 * (x231 * x3 + x237 - x6 * (x206 * x5 - x239 * x6))
                )
            ),
            x105 * (x256 - x259 + x267 + x273)
            + x3 * (x256 * x3 - x268 * x6 + x56 * (x248 - x249 + x254))
            - x6
            * (
                x268 * x3
                + x56 * (x255 - x260 + x265)
                - x6 * (x266 * x3 + x270 - x6 * (x264 * x3 - x272 * x6))
            ),
            x105 * (x289 - x291 + x299 + x304)
            + x3 * (x289 * x3 - x300 * x6 + x56 * (x281 - x282 + x287))
            - x6
            * (
                x3 * x300
                + x56 * (x288 - x292 + x297)
                - x6 * (x298 * x3 + x301 - x6 * (x296 * x3 - x303 * x6))
            ),
            x105 * (x321 - x324 + x332 + x338)
            + x3 * (x3 * x321 - x333 * x6 + x56 * (x313 - x314 + x319))
            - x6
            * (
                x3 * x333
                + x56 * (x320 - x325 + x330)
                - x6 * (x3 * x331 + x335 - x6 * (x3 * x329 - x337 * x6))
            ),
            x3
            * (
                x3 * x367
                - x382 * x6
                + x4 * (-x348 + x354 + x363)
                + x56 * (x363 - x383 + x384)
            )
            + x56 * (x367 - x368 + x379 - x381)
            + x56
            * (
                x3 * x384
                - x3 * x390
                + x366
                - x380
                - x390 * x6
                - x4 * (-x3 * x344 + x346 + x358 + x391)
                + x4 * (x3 * x349 + x345 + x350 - x391)
                + x6 * (x377 + x389)
            )
            - x6
            * (
                x3 * x382
                + x4 * (x365 - x369 + x386)
                + x56 * (x386 - x389 + x390)
                - x6
                * (
                    x3 * x378
                    + x56 * (x359 - x371 + x374)
                    - x6 * (x375 * x5 + x387 - x6 * (x373 * x5 - x388 * x6))
                )
            ),
            x3
            * (
                x3 * x414
                + x4 * (x397 - x407 + x408)
                + x4 * (x408 - x411 + x412)
                - x419 * x6
            )
            + x4 * (x3 * x397 - x3 * x410 + x394 + x406 - x410 * x6 + x6 * (x400 + x404))
            + x56 * (x406 + x414 - x415 + x418)
            - x6
            * (
                x3 * x419
                + x4 * (-x400 + x403 + x410)
                + x4 * (x403 + x413 - x416)
                - x6 * (x3 * x417 + x420 - x6 * (x402 * x5 - x421 * x6))
            ),
            x3
            * (
                x3 * x444
                + x4 * (x427 - x437 + x438)
                + x4 * (x438 - x441 + x442)
                - x449 * x6
            )
            + x4 * (x3 * x427 - x3 * x440 + x424 + x436 - x440 * x6 + x6 * (x430 + x434))
            + x56 * (x436 + x444 - x445 + x448)
            - x6
            * (
                x3 * x449
                + x4 * (-x430 + x433 + x440)
                + x4 * (x433 + x443 - x446)
                - x6 * (x3 * x447 + x450 - x6 * (x432 * x5 - x451 * x6))
            ),
            x3 * (x3 * x458 + x456 - x465 * x6)
            + x56 * (x458 - x459 + x464)
            - x6 * (x3 * x465 + x466 - x6 * (x3 * x463 - x467 * x6)),
            x3 * (x3 * x473 + x471 - x479 * x6)
            + x56 * (x473 - x474 + x478)
            - x6 * (x3 * x479 + x480 - x6 * (x3 * x477 - x481 * x6)),
            x3 * (x3 * x487 + x485 - x493 * x6)
            + x56 * (x487 - x488 + x492)
            - x6 * (x3 * x493 + x494 - x6 * (x3 * x491 - x495 * x6)),
            x3
            * (
                x3 * x524
                + x4 * (-x505 + x511 + x520)
                - x539 * x6
                + x56 * (x520 - x540 + x541)
            )
            + x56 * (x524 - x525 + x536 - x538)
            + x56
            * (
                x3 * x541
                - x3 * x547
                - x4 * (-x3 * x501 + x503 + x515 + x548)
                + x4 * (x3 * x506 + x502 + x507 - x548)
                + x523
                - x537
                - x547 * x6
                + x6 * (x534 + x546)
            )
            - x6
            * (
                x3 * x539
                + x4 * (x522 - x526 + x543)
                + x56 * (x543 - x546 + x547)
                - x6
                * (
                    x3 * x535
                    + x56 * (x516 - x528 + x531)
                    - x6 * (x5 * x532 + x544 - x6 * (x5 * x530 - x545 * x6))
                )
            ),
            x3
            * (
                x3 * x578
                + x4 * (x557 - x571 + x572)
                + x4 * (x572 - x575 + x576)
                - x583 * x6
            )
            + x4 * (x3 * x557 - x3 * x574 + x553 + x570 - x574 * x6 + x6 * (x562 + x568))
            + x56 * (x570 + x578 - x579 + x582)
            - x6
            * (
                x3 * x583
                + x4 * (-x562 + x567 + x574)
                + x4 * (x567 + x577 - x580)
                - x6 * (x3 * x581 + x584 - x6 * (x5 * x566 - x586 * x6))
            ),
            x3
            * (
                x3 * x609
                + x4 * (x592 - x602 + x603)
                + x4 * (x603 - x606 + x607)
                - x6 * x614
            )
            + x4 * (x3 * x592 - x3 * x605 + x589 - x6 * x605 + x6 * (x595 + x599) + x601)
            + x56 * (x601 + x609 - x610 + x613)
            - x6
            * (
                x3 * x614
                + x4 * (-x595 + x598 + x605)
                + x4 * (x598 + x608 - x611)
                - x6 * (x3 * x612 - x6 * (x5 * x597 - x6 * x616) + x615)
            ),
            x3 * (x3 * x625 - x6 * x632 + x622)
            + x56 * (x625 - x626 + x631)
            - x6 * (x3 * x632 - x6 * (x3 * x630 - x6 * x636) + x634),
            x3 * (x3 * x644 - x6 * x651 + x641)
            + x56 * (x644 - x645 + x650)
            - x6 * (x3 * x651 - x6 * (x3 * x649 - x6 * x654) + x652),
            x3 * (x3 * x661 - x6 * x668 + x659)
            + x56 * (x661 - x662 + x667)
            - x6 * (x3 * x668 - x6 * (x3 * x666 - x6 * x670) + x669),
            x3 * (x3 * x685 + x56 * (-x674 + x678 + x682) - x6 * x696)
            + x4 * (-x680 + x685 + x695)
            + x56 * (-x3 * x679 + x3 * x682 + x684 + x695)
            - x6
            * (
                x3 * x696
                + x56 * (x679 - x686 + x690)
                - x6 * (x5 * x691 - x6 * (x5 * x689 - x6 * x698) + x697)
            ),
            x3 * (x3 * x709 - x6 * x711 + x710)
            + x4 * (x703 - x708 + x709)
            + x4 * (x3 * x699 - x3 * x706 + x703 + x707)
            - x6 * (x3 * x711 - x6 * (x5 * x702 - x6 * x713) + x712),
            x3 * (x3 * x724 - x6 * x726 + x725)
            + x4 * (x718 - x723 + x724)
            + x4 * (x3 * x714 - x3 * x721 + x718 + x722)
            - x6 * (x3 * x726 - x6 * (x5 * x717 - x6 * x728) + x727),
            x3 * (x3 * x734 - x6 * x736) - x6 * (x3 * x736 - x6 * x738) + x735,
            x3 * (x3 * x741 - x6 * x743) - x6 * (x3 * x743 - x6 * x744) + x742,
            x3 * (x3 * x747 - x6 * x749) - x6 * (x3 * x749 - x6 * x750) + x748,
            x3 * (x3 * x763 + x56 * (-x753 + x756 + x760) - x6 * x773)
            + x4 * (-x758 + x763 + x772)
            + x56 * (-x3 * x757 + x3 * x760 + x762 + x772)
            - x6
            * (
                x3 * x773
                + x56 * (x757 - x764 + x767)
                - x6 * (x5 * x768 - x6 * (x5 * x766 - x6 * x775) + x774)
            ),
            x3 * (x3 * x784 - x6 * x786 + x785)
            + x4 * (x779 - x783 + x784)
            + x4 * (x3 * x776 - x3 * x781 + x779 + x782)
            - x6 * (x3 * x786 - x6 * (x5 * x778 - x6 * x788) + x787),
            x3 * (x3 * x797 - x6 * x799 + x798)
            + x4 * (x792 - x796 + x797)
            + x4 * (x3 * x789 - x3 * x794 + x792 + x795)
            - x6 * (x3 * x799 - x6 * (x5 * x791 - x6 * x801) + x800),
            x3 * (x3 * x805 - x6 * x807) - x6 * (x3 * x807 - x6 * x808) + x806,
            x3 * (x3 * x811 - x6 * x813) - x6 * (x3 * x813 - x6 * x814) + x812,
            x3 * (x3 * x817 - x6 * x819) - x6 * (x3 * x819 - x6 * x820) + x818,
            x3 * (x3 * x835 + x56 * (-x824 + x828 + x832) - x6 * x846)
            + x4 * (-x830 + x835 + x845)
            + x56 * (-x3 * x829 + x3 * x832 + x834 + x845)
            - x6
            * (
                x3 * x846
                + x56 * (x829 - x836 + x840)
                - x6 * (x5 * x841 - x6 * (x5 * x839 - x6 * x848) + x847)
            ),
            x3 * (x3 * x862 - x6 * x864 + x863)
            + x4 * (x855 - x861 + x862)
            + x4 * (x3 * x850 - x3 * x859 + x855 + x860)
            - x6 * (x3 * x864 - x6 * (x5 * x854 - x6 * x867) + x865),
            x3 * (x3 * x878 - x6 * x880 + x879)
            + x4 * (x872 - x877 + x878)
            + x4 * (x3 * x868 - x3 * x875 + x872 + x876)
            - x6 * (x3 * x880 - x6 * (x5 * x871 - x6 * x882) + x881),
            x3 * (x3 * x885 - x6 * x890) - x6 * (x3 * x890 - x6 * x892) + x888,
            x3 * (x3 * x896 - x6 * x899) - x6 * (x3 * x899 - x6 * x901) + x897,
            x3 * (x3 * x907 - x6 * x909) - x6 * (x3 * x909 - x6 * x911) + x908,
            x3 * (x5 * x918 - x6 * x925 + x916)
            + x56 * (x918 - x919 + x924)
            - x6 * (x5 * x925 - x6 * (x5 * x923 - x6 * x927) + x926),
            x3 * (x5 * x930 - x6 * x932) - x6 * (x5 * x932 - x6 * x933) + x931,
            x3 * (x5 * x937 - x6 * x939) - x6 * (x5 * x939 - x6 * x940) + x938,
            x3 * x941 - x6 * x942,
            x3 * x943 - x6 * x944,
            x3 * x945 - x6 * x946,
            x3 * (x5 * x952 - x6 * x958 + x950)
            + x56 * (x952 - x953 + x957)
            - x6 * (x5 * x958 - x6 * (x5 * x956 - x6 * x960) + x959),
            x3 * (x5 * x963 - x6 * x965) - x6 * (x5 * x965 - x6 * x966) + x964,
            x3 * (x5 * x969 - x6 * x971) - x6 * (x5 * x971 - x6 * x972) + x970,
            x3 * x974 - x6 * x976,
            x3 * x977 - x6 * x978,
            x3 * x979 - x6 * x980,
            x3 * (x5 * x985 - x6 * x990 + x983)
            + x56 * (x985 - x986 + x989)
            - x6 * (x5 * x990 - x6 * (x5 * x988 - x6 * x992) + x991),
            x3 * (x5 * x994 - x6 * x996) - x6 * (x5 * x996 - x6 * x997) + x995,
            x1000 + x3 * (-x1001 * x6 + x5 * x999) - x6 * (x1001 * x5 - x1002 * x6),
            x1003 * x3 - x1004 * x6,
            x1005 * x3 - x1006 * x6,
            x1007 * x3 - x1008 * x6,
            x3 * (x1013 + x1015 * x5 - x1022 * x6)
            + x56 * (x1015 - x1016 + x1021)
            - x6 * (x1022 * x5 + x1023 - x6 * (x1020 * x5 - x1024 * x6)),
            x1029 + x3 * (x1028 * x5 - x1031 * x6) - x6 * (x1031 * x5 - x1033 * x6),
            x1037 + x3 * (x1036 * x5 - x1038 * x6) - x6 * (x1038 * x5 - x1039 * x6),
            x1041 * x3 - x1043 * x6,
            x1045 * x3 - x1047 * x6,
            x1048 * x3 - x1049 * x6,
            x4 * (x1050 - x1051 - x1052 + x1053)
            + x5 * (x1053 * x5 - x1054 * x6)
            - x6 * (x1054 * x5 - x6 * (x339 * x923 + 3.0 * x697 - x8 * x927)),
            x5 * (x339 * x930 + 3.0 * x710 - x8 * x932 + x916)
            - x6 * (x339 * x932 + 3.0 * x712 - x8 * x933 + x926),
            x5 * (x339 * x937 + 3.0 * x725 - x8 * x939)
            - x6 * (x339 * x939 + 3.0 * x727 - x8 * x940),
            x339 * x941 + 3.0 * x735 - x8 * x942 + 2.0 * x931,
            x339 * x943 + 3.0 * x742 - x8 * x944 + x938,
            x339 * x945 + 3.0 * x748 - x8 * x946,
            x4 * (x1055 - x1056 - x1057 + x1058)
            + x5 * (x1058 * x5 - x1059 * x6)
            - x6 * (x1059 * x5 - x6 * (x339 * x956 + 2.0 * x774 - x8 * x960)),
            x5 * (x339 * x963 - x8 * x965 + x950 + x973)
            - x6 * (x339 * x965 - x8 * x966 + x959 + x975),
            x5 * (x339 * x969 + 2.0 * x798 - x8 * x971)
            - x6 * (x339 * x971 - x8 * x972 + 2.0 * x800),
            x339 * x974 - x8 * x976 + 2.0 * x806 + 2.0 * x964,
            x339 * x977 - x8 * x978 + 2.0 * x812 + x970,
            x339 * x979 - x8 * x980 + 2.0 * x818,
            x4 * (x1060 - x1061 + x1062 + x844)
            + x5 * (x1062 * x5 - x1063 * x6)
            - x6 * (x1063 * x5 - x6 * (x339 * x988 - x8 * x992 + x847)),
            x5 * (x339 * x994 - x8 * x996 + x863 + x983)
            - x6 * (x339 * x996 - x8 * x997 + x865 + x991),
            x5 * (-x1001 * x8 + x339 * x999 + x879)
            - x6 * (x1001 * x339 - x1002 * x8 + x881),
            x1003 * x339 - x1004 * x8 + x888 + 2.0 * x995,
            x1000 + x1005 * x339 - x1006 * x8 + x897,
            x1007 * x339 - x1008 * x8 + x908,
            x4 * (x1025 - x1064 + x1065)
            + x5 * (x1065 * x5 - x1066 * x6)
            - x6 * (x1066 * x5 - x6 * (x1020 * x339 + x1032)),
            x5 * (x1028 * x339 + x1040) - x6 * (x1031 * x339 + x1042),
            x5 * (x1036 * x339 + x1044) - x6 * (x1038 * x339 + x1046),
            2.0 * x1029 + x1041 * x339 - x1043 * x8,
            x1037 + x1045 * x339 - x1047 * x8,
            x1048 * x339 - x1049 * x8,
            x1071 + x5 * (x1070 * x5 - x1072 * x6) - x6 * (x1072 * x5 - x1073 * x6),
            x1074 * x5 - x1075 * x6,
            x1076 * x5 - x1077 * x6,
            x106 * x1074 + x1071 - x1075 * x8,
            x106 * x1076 - x1077 * x8,
            -x10 * x1049 + 2.0 * x1037 + x1048 * x496 + 3.0 * x908,
        ]
    )


def coulomb3d_43(a, A, b, B, C):
    """Cartesian (gf) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - B[0]
    x6 = -x2 - C[0]
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 * (x10**2 + x6**2 + x8**2)
    x12 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x13 = x12 * boys(2, x11)
    x14 = x13 * x6
    x15 = -x14
    x16 = x12 * boys(1, x11)
    x17 = x16 * x5
    x18 = x15 + x17
    x19 = x18 * x5
    x20 = x4 * (-x13 + x16)
    x21 = x12 * boys(3, x11)
    x22 = x21 * x6
    x23 = -x22
    x24 = x13 * x5
    x25 = x23 + x24
    x26 = x25 * x6
    x27 = x20 - x26
    x28 = x19 + x27
    x29 = x28 * x5
    x30 = -x16 * x6
    x31 = x12 * boys(0, x11)
    x32 = x30 + x31 * x5
    x33 = x4 * (-x16 + x31)
    x34 = -x18 * x6 + x33
    x35 = x32 * x5 + x34
    x36 = x4 * (x14 - x17 + x32)
    x37 = -x28 * x6 + 2.0 * x36
    x38 = x35 * x5 + x37
    x39 = x25 * x5
    x40 = x4 * (x13 - x21)
    x41 = x12 * boys(4, x11)
    x42 = x41 * x6
    x43 = x21 * x5
    x44 = -x42 + x43
    x45 = x44 * x6
    x46 = x40 - x45
    x47 = x39 + x46
    x48 = x47 * x6
    x49 = x4 * (x18 + x22 - x24)
    x50 = 2.0 * x49
    x51 = x48 - x50
    x52 = -x48 + x50
    x53 = x29 + x52
    x54 = -x20
    x55 = x26 + x54
    x56 = x4 * (-x19 + x35 + x55)
    x57 = x3 * x38 - x53 * x6 + 3.0 * x56
    x58 = x3 * x53
    x59 = x47 * x5
    x60 = x44 * x5
    x61 = x4 * (x21 - x41)
    x62 = x12 * boys(5, x11)
    x63 = x6 * x62
    x64 = x41 * x5
    x65 = -x63 + x64
    x66 = x6 * x65
    x67 = x61 - x66
    x68 = x60 + x67
    x69 = x6 * x68
    x70 = x4 * (x25 + x42 - x43)
    x71 = 2.0 * x70
    x72 = -x69 + x71
    x73 = x59 + x72
    x74 = x6 * x73
    x75 = -x40
    x76 = x45 + x75
    x77 = x4 * (x28 - x39 + x76)
    x78 = 3.0 * x77
    x79 = x58 - x74 + x78
    x80 = x28 * x3
    x81 = x3 * x35 + x37
    x82 = x51 - x80 + x81
    x83 = 3.0 * x4
    x84 = x3 * x57 + x4 * (-x29 + x38 + x51) - x6 * x79 + x82 * x83
    x85 = x69 - x71
    x86 = x4 * (x53 - x59 + x85)
    x87 = x3 * x79
    x88 = x3 * x73
    x89 = x5 * x68
    x90 = x4 * (x41 - x62)
    x91 = x5 * x65
    x92 = x12 * boys(6, x11)
    x93 = x6 * x92
    x94 = x5 * x62
    x95 = -x93 + x94
    x96 = x6 * x95
    x97 = x90 + x91 - x96
    x98 = x6 * x97
    x99 = 2.0 * x4
    x100 = x99 * (x44 + x63 - x64)
    x101 = x100 - x98
    x102 = x101 + x89
    x103 = x102 * x6
    x104 = -x61
    x105 = x104 + x66
    x106 = x4 * (x105 + x47 - x60)
    x107 = 3.0 * x106
    x108 = -x103 + x107 + x88
    x109 = x108 * x6
    x110 = x3 * x47
    x111 = x52 + x80
    x112 = -x110 + x111 + x85
    x113 = x112 * x83
    x114 = -x109 + x113 + x86 + x87
    x115 = x110 + x72
    x116 = x115 * x6
    x117 = x111 * x3
    x118 = x25 * x3
    x119 = x18 * x3
    x120 = x119 + x27
    x121 = x99 * (-x118 + x120 + x76)
    x122 = x3 * x32 + x34
    x123 = -x111 * x6 + x3 * x81 + x56 + x99 * (-x119 + x122 + x55)
    x124 = -x100 + x98
    x125 = x4 * (x62 - x92)
    x126 = x12 * boys(7, x11)
    x127 = -x90
    x128 = x3 * x68
    x129 = x6 * (x101 + x128)
    x130 = x115 * x3
    x131 = x3 * x44
    x132 = x118 + x46
    x133 = x99 * (x105 - x131 + x132)
    x134 = -x116 + x117 + x121 + x77
    x135 = x13 * x3
    x136 = x16 * x3
    x137 = x4 * (-x135 + x136 + x15 + x22)
    x138 = x120 * x3
    x139 = x132 * x6
    x140 = x13 * x8
    x141 = -x140
    x142 = -x7 - B[1]
    x143 = x142 * x16
    x144 = x141 + x143
    x145 = x144 * x5
    x146 = x21 * x8
    x147 = -x146
    x148 = x13 * x142
    x149 = x147 + x148
    x150 = x149 * x6
    x151 = -x150
    x152 = x145 + x151
    x153 = x152 * x5
    x154 = -x16 * x8
    x155 = x142 * x31 + x154
    x156 = -x144 * x6
    x157 = x155 * x5 + x156
    x158 = x4 * (x140 - x143 + x155)
    x159 = -x152 * x6 + x158
    x160 = x157 * x5 + x159
    x161 = x149 * x5
    x162 = x41 * x8
    x163 = -x162
    x164 = x142 * x21
    x165 = x163 + x164
    x166 = x165 * x6
    x167 = -x166
    x168 = x161 + x167
    x169 = x168 * x6
    x170 = x4 * (x144 + x146 - x148)
    x171 = -x170
    x172 = x169 + x171
    x173 = -x169 + x170
    x174 = x153 + x173
    x175 = x4 * (-x145 + x150 + x157)
    x176 = x160 * x3 - x174 * x6 + 2.0 * x175
    x177 = x174 * x3
    x178 = x168 * x5
    x179 = x4 * (x149 + x162 - x164)
    x180 = x165 * x5
    x181 = x62 * x8
    x182 = -x181
    x183 = x142 * x41
    x184 = x182 + x183
    x185 = x184 * x6
    x186 = -x185
    x187 = x180 + x186
    x188 = x187 * x6
    x189 = x179 - x188
    x190 = x178 + x189
    x191 = x190 * x6
    x192 = x4 * (x152 - x161 + x166)
    x193 = 2.0 * x192
    x194 = x177 - x191 + x193
    x195 = x152 * x3
    x196 = x157 * x3 + x159
    x197 = x99 * (x172 - x195 + x196)
    x198 = x176 * x3 - x194 * x6 + x197 + x4 * (-x153 + x160 + x172)
    x199 = -x179
    x200 = x188 + x199
    x201 = x4 * (x174 - x178 + x200)
    x202 = x194 * x3
    x203 = x190 * x3
    x204 = x187 * x5
    x205 = x4 * (x165 + x181 - x183)
    x206 = x184 * x5
    x207 = x8 * x92
    x208 = -x207
    x209 = x142 * x62
    x210 = x208 + x209
    x211 = x210 * x6
    x212 = x206 - x211
    x213 = x212 * x6
    x214 = x205 - x213
    x215 = x204 + x214
    x216 = x215 * x6
    x217 = x4 * (x168 - x180 + x185)
    x218 = 2.0 * x217
    x219 = x203 - x216 + x218
    x220 = x219 * x6
    x221 = x168 * x3
    x222 = x173 + x195
    x223 = x99 * (x200 - x221 + x222)
    x224 = x201 + x202 - x220 + x223
    x225 = x189 + x221
    x226 = x225 * x6
    x227 = x149 * x3
    x228 = x144 * x3
    x229 = x151 + x228
    x230 = x4 * (x166 - x227 + x229)
    x231 = x222 * x3
    x232 = x155 * x3 + x156
    x233 = x175 + x196 * x3 - x222 * x6 + x4 * (x150 - x228 + x232)
    x234 = -x205
    x235 = x213 + x234
    x236 = x4 * (x184 + x207 - x209)
    x237 = -x126 * x8
    x238 = x142 * x92 + x237
    x239 = x187 * x3
    x240 = x6 * (x214 + x239)
    x241 = x165 * x3
    x242 = x167 + x227
    x243 = x4 * (x185 - x241 + x242)
    x244 = x225 * x3
    x245 = x192 - x226 + x230 + x231
    x246 = x242 * x6
    x247 = x229 * x3
    x248 = -x223
    x249 = x10 * x13
    x250 = -x249
    x251 = -x9 - B[2]
    x252 = x16 * x251
    x253 = x250 + x252
    x254 = x253 * x5
    x255 = x10 * x21
    x256 = -x255
    x257 = x13 * x251
    x258 = x256 + x257
    x259 = x258 * x6
    x260 = -x259
    x261 = x254 + x260
    x262 = x261 * x5
    x263 = -x10 * x16
    x264 = x251 * x31 + x263
    x265 = -x253 * x6
    x266 = x264 * x5 + x265
    x267 = x4 * (x249 - x252 + x264)
    x268 = -x261 * x6 + x267
    x269 = x266 * x5 + x268
    x270 = x258 * x5
    x271 = x10 * x41
    x272 = -x271
    x273 = x21 * x251
    x274 = x272 + x273
    x275 = x274 * x6
    x276 = -x275
    x277 = x270 + x276
    x278 = x277 * x6
    x279 = x4 * (x253 + x255 - x257)
    x280 = -x279
    x281 = x278 + x280
    x282 = -x278 + x279
    x283 = x262 + x282
    x284 = x4 * (-x254 + x259 + x266)
    x285 = x269 * x3 - x283 * x6 + 2.0 * x284
    x286 = x283 * x3
    x287 = x277 * x5
    x288 = x4 * (x258 + x271 - x273)
    x289 = x274 * x5
    x290 = x10 * x62
    x291 = -x290
    x292 = x251 * x41
    x293 = x291 + x292
    x294 = x293 * x6
    x295 = -x294
    x296 = x289 + x295
    x297 = x296 * x6
    x298 = x288 - x297
    x299 = x287 + x298
    x300 = x299 * x6
    x301 = x4 * (x261 - x270 + x275)
    x302 = 2.0 * x301
    x303 = x286 - x300 + x302
    x304 = x261 * x3
    x305 = x266 * x3 + x268
    x306 = x99 * (x281 - x304 + x305)
    x307 = x285 * x3 - x303 * x6 + x306 + x4 * (-x262 + x269 + x281)
    x308 = -x288
    x309 = x297 + x308
    x310 = x4 * (x283 - x287 + x309)
    x311 = x3 * x303
    x312 = x299 * x3
    x313 = x296 * x5
    x314 = x4 * (x274 + x290 - x292)
    x315 = x293 * x5
    x316 = x10 * x92
    x317 = -x316
    x318 = x251 * x62
    x319 = x317 + x318
    x320 = x319 * x6
    x321 = x315 - x320
    x322 = x321 * x6
    x323 = x314 - x322
    x324 = x313 + x323
    x325 = x324 * x6
    x326 = x4 * (x277 - x289 + x294)
    x327 = 2.0 * x326
    x328 = x312 - x325 + x327
    x329 = x328 * x6
    x330 = x277 * x3
    x331 = x282 + x304
    x332 = x99 * (x309 - x330 + x331)
    x333 = x310 + x311 - x329 + x332
    x334 = x298 + x330
    x335 = x334 * x6
    x336 = x258 * x3
    x337 = x253 * x3
    x338 = x260 + x337
    x339 = x4 * (x275 - x336 + x338)
    x340 = x3 * x331
    x341 = x264 * x3 + x265
    x342 = x284 + x3 * x305 - x331 * x6 + x4 * (x259 - x337 + x341)
    x343 = -x314
    x344 = x322 + x343
    x345 = x4 * (x293 + x316 - x318)
    x346 = -x10 * x126
    x347 = x251 * x92 + x346
    x348 = x296 * x3
    x349 = x6 * (x323 + x348)
    x350 = x274 * x3
    x351 = x276 + x336
    x352 = x4 * (x294 - x350 + x351)
    x353 = x3 * x334
    x354 = x301 - x335 + x339 + x340
    x355 = x351 * x6
    x356 = x3 * x338
    x357 = -x332
    x358 = x142 * x144
    x359 = -x144 * x8 + x33
    x360 = x142 * x155 + x359
    x361 = x149 * x8
    x362 = x361 + x54
    x363 = x4 * (-x358 + x360 + x362)
    x364 = x20 - x361
    x365 = x358 + x364
    x366 = -x365 * x6
    x367 = x3 * x360 + x366
    x368 = x3 * x365
    x369 = x142 * x149
    x370 = x165 * x8
    x371 = -x370 + x40
    x372 = x369 + x371
    x373 = x372 * x6
    x374 = -x373
    x375 = x368 + x374
    x376 = x3 * x367 + x363 - x375 * x6
    x377 = x142 * x165
    x378 = x184 * x8
    x379 = x104 + x378
    x380 = x4 * (x372 - x377 + x379)
    x381 = x3 * x372
    x382 = -x378 + x61
    x383 = x377 + x382
    x384 = x383 * x6
    x385 = -x384
    x386 = x381 + x385
    x387 = x3 * x386
    x388 = x3 * x383
    x389 = x142 * x184
    x390 = x210 * x8
    x391 = -x390 + x90
    x392 = x389 + x391
    x393 = x392 * x6
    x394 = -x393
    x395 = x6 * (x388 + x394)
    x396 = x370 + x75
    x397 = x4 * (x365 - x369 + x396)
    x398 = x3 * x375
    x399 = x386 * x6
    x400 = x397 + x398 - x399
    x401 = x4 * (x375 - x381 + x384)
    x402 = x4 * (x367 - x368 + x373)
    x403 = -x397
    x404 = x365 * x5
    x405 = x360 * x5 + x366
    x406 = x374 + x404
    x407 = x3 * x405 + x363 - x406 * x6
    x408 = x3 * x406
    x409 = x372 * x5
    x410 = x385 + x409
    x411 = x410 * x6
    x412 = x397 + x408 - x411
    x413 = x3 * x407 + x4 * (x373 - x404 + x405) + x402 - x412 * x6
    x414 = x4 * (x384 + x406 - x409)
    x415 = x3 * x412
    x416 = x3 * x410
    x417 = x383 * x5
    x418 = x394 + x417
    x419 = x418 * x6
    x420 = x380 + x416 - x419
    x421 = x420 * x6
    x422 = x401 + x414 + x415 - x421
    x423 = -x380
    x424 = x127 + x390
    x425 = x4 * (x383 - x389 + x424)
    x426 = x125 - x238 * x8
    x427 = x142 * x210 + x426
    x428 = x258 * x8
    x429 = x142 * x253
    x430 = -x253 * x8
    x431 = x142 * x264 + x430
    x432 = x4 * (x428 - x429 + x431)
    x433 = -x428
    x434 = x429 + x433
    x435 = -x434 * x6
    x436 = x3 * x431 + x435
    x437 = x3 * x434
    x438 = x142 * x258
    x439 = x274 * x8
    x440 = -x439
    x441 = x438 + x440
    x442 = x441 * x6
    x443 = -x442
    x444 = x437 + x443
    x445 = x3 * x436 + x432 - x444 * x6
    x446 = x293 * x8
    x447 = x142 * x274
    x448 = x4 * (x441 + x446 - x447)
    x449 = x3 * x441
    x450 = -x446
    x451 = x447 + x450
    x452 = x451 * x6
    x453 = -x452
    x454 = x449 + x453
    x455 = x3 * x454
    x456 = x3 * x451
    x457 = x142 * x293
    x458 = x319 * x8
    x459 = -x458
    x460 = x457 + x459
    x461 = x460 * x6
    x462 = -x461
    x463 = x6 * (x456 + x462)
    x464 = x4 * (x434 - x438 + x439)
    x465 = x3 * x444
    x466 = x454 * x6
    x467 = x464 + x465 - x466
    x468 = x4 * (x444 - x449 + x452)
    x469 = x4 * (x436 - x437 + x442)
    x470 = -x464
    x471 = x434 * x5
    x472 = x431 * x5 + x435
    x473 = x443 + x471
    x474 = x3 * x472 + x432 - x473 * x6
    x475 = x3 * x473
    x476 = x441 * x5
    x477 = x453 + x476
    x478 = x477 * x6
    x479 = x464 + x475 - x478
    x480 = x3 * x474 + x4 * (x442 - x471 + x472) + x469 - x479 * x6
    x481 = x4 * (x452 + x473 - x476)
    x482 = x3 * x479
    x483 = x3 * x477
    x484 = x451 * x5
    x485 = x462 + x484
    x486 = x485 * x6
    x487 = x448 + x483 - x486
    x488 = x487 * x6
    x489 = x468 + x481 + x482 - x488
    x490 = -x448
    x491 = x4 * (x451 - x457 + x458)
    x492 = -x347 * x8
    x493 = x142 * x319 + x492
    x494 = x251 * x253
    x495 = -x10 * x253 + x33
    x496 = x251 * x264 + x495
    x497 = x10 * x258
    x498 = x497 + x54
    x499 = x4 * (-x494 + x496 + x498)
    x500 = x20 - x497
    x501 = x494 + x500
    x502 = -x501 * x6
    x503 = x3 * x496 + x502
    x504 = x3 * x501
    x505 = x251 * x258
    x506 = x10 * x274
    x507 = x40 - x506
    x508 = x505 + x507
    x509 = x508 * x6
    x510 = -x509
    x511 = x504 + x510
    x512 = x3 * x503 + x499 - x511 * x6
    x513 = x251 * x274
    x514 = x10 * x293
    x515 = x104 + x514
    x516 = x4 * (x508 - x513 + x515)
    x517 = x3 * x508
    x518 = -x514 + x61
    x519 = x513 + x518
    x520 = x519 * x6
    x521 = -x520
    x522 = x517 + x521
    x523 = x3 * x522
    x524 = x3 * x519
    x525 = x251 * x293
    x526 = x10 * x319
    x527 = -x526 + x90
    x528 = x525 + x527
    x529 = x528 * x6
    x530 = -x529
    x531 = x6 * (x524 + x530)
    x532 = x506 + x75
    x533 = x4 * (x501 - x505 + x532)
    x534 = x3 * x511
    x535 = x522 * x6
    x536 = x533 + x534 - x535
    x537 = x4 * (x511 - x517 + x520)
    x538 = x4 * (x503 - x504 + x509)
    x539 = -x533
    x540 = x5 * x501
    x541 = x496 * x5 + x502
    x542 = x510 + x540
    x543 = x3 * x541 + x499 - x542 * x6
    x544 = x3 * x542
    x545 = x5 * x508
    x546 = x521 + x545
    x547 = x546 * x6
    x548 = x533 + x544 - x547
    x549 = x3 * x543 + x4 * (x509 - x540 + x541) + x538 - x548 * x6
    x550 = x4 * (x520 + x542 - x545)
    x551 = x3 * x548
    x552 = x3 * x546
    x553 = x5 * x519
    x554 = x530 + x553
    x555 = x554 * x6
    x556 = x516 + x552 - x555
    x557 = x556 * x6
    x558 = x537 + x550 + x551 - x557
    x559 = -x516
    x560 = x127 + x526
    x561 = x4 * (x519 - x525 + x560)
    x562 = -x10 * x347 + x125
    x563 = x251 * x319 + x562
    x564 = x142 * x365
    x565 = 2.0 * x158 - x365 * x8
    x566 = x142 * x360 + x565
    x567 = x372 * x8
    x568 = 2.0 * x170
    x569 = x567 - x568
    x570 = x4 * (-x564 + x566 + x569)
    x571 = -x567 + x568
    x572 = x564 + x571
    x573 = x3 * x566 - x572 * x6
    x574 = x3 * x572
    x575 = x142 * x372
    x576 = x383 * x8
    x577 = 2.0 * x179
    x578 = -x576 + x577
    x579 = x575 + x578
    x580 = x579 * x6
    x581 = x574 - x580
    x582 = x3 * x573 + x570 - x581 * x6
    x583 = x576 - x577
    x584 = x4 * (x572 - x575 + x583)
    x585 = x3 * x581
    x586 = x3 * x579
    x587 = x142 * x383
    x588 = x392 * x8
    x589 = 2.0 * x205
    x590 = -x588 + x589
    x591 = x587 + x590
    x592 = x591 * x6
    x593 = x586 - x592
    x594 = x593 * x6
    x595 = x584 + x585 - x594
    x596 = x588 - x589
    x597 = x4 * (x579 - x587 + x596)
    x598 = 2.0 * x236 - x427 * x8
    x599 = x142 * x392 + x598
    x600 = -x584
    x601 = x142 * x434
    x602 = x267 - x434 * x8
    x603 = x142 * x431 + x602
    x604 = x441 * x8
    x605 = x280 + x604
    x606 = x4 * (-x601 + x603 + x605)
    x607 = x279 - x604
    x608 = x601 + x607
    x609 = x3 * x603 - x6 * x608
    x610 = x3 * x608
    x611 = x142 * x441
    x612 = x451 * x8
    x613 = x288 - x612
    x614 = x611 + x613
    x615 = x6 * x614
    x616 = x610 - x615
    x617 = x3 * x609 - x6 * x616 + x606
    x618 = x308 + x612
    x619 = x4 * (x608 - x611 + x618)
    x620 = x3 * x616
    x621 = x3 * x614
    x622 = x142 * x451
    x623 = x460 * x8
    x624 = x314 - x623
    x625 = x622 + x624
    x626 = x6 * x625
    x627 = x621 - x626
    x628 = x6 * x627
    x629 = x619 + x620 - x628
    x630 = x343 + x623
    x631 = x4 * (x614 - x622 + x630)
    x632 = x345 - x493 * x8
    x633 = x142 * x460 + x632
    x634 = -x619
    x635 = x508 * x8
    x636 = x142 * x501
    x637 = -x501 * x8
    x638 = x142 * x496 + x637
    x639 = x4 * (x635 - x636 + x638)
    x640 = -x635
    x641 = x636 + x640
    x642 = x3 * x638 - x6 * x641
    x643 = x3 * x641
    x644 = x142 * x508
    x645 = x519 * x8
    x646 = -x645
    x647 = x644 + x646
    x648 = x6 * x647
    x649 = x643 - x648
    x650 = x3 * x642 - x6 * x649 + x639
    x651 = x4 * (x641 - x644 + x645)
    x652 = x3 * x649
    x653 = x3 * x647
    x654 = x142 * x519
    x655 = x528 * x8
    x656 = -x655
    x657 = x654 + x656
    x658 = x6 * x657
    x659 = x653 - x658
    x660 = x6 * x659
    x661 = x651 + x652 - x660
    x662 = x4 * (x647 - x654 + x655)
    x663 = -x563 * x8
    x664 = x142 * x528 + x663
    x665 = -x651
    x666 = x251 * x501
    x667 = -x10 * x501 + 2.0 * x267
    x668 = x251 * x496 + x667
    x669 = x10 * x508
    x670 = 2.0 * x279
    x671 = x669 - x670
    x672 = x4 * (-x666 + x668 + x671)
    x673 = -x669 + x670
    x674 = x666 + x673
    x675 = x3 * x668 - x6 * x674
    x676 = x3 * x674
    x677 = x251 * x508
    x678 = x10 * x519
    x679 = 2.0 * x288
    x680 = -x678 + x679
    x681 = x677 + x680
    x682 = x6 * x681
    x683 = x676 - x682
    x684 = x3 * x675 - x6 * x683 + x672
    x685 = x678 - x679
    x686 = x4 * (x674 - x677 + x685)
    x687 = x3 * x683
    x688 = x3 * x681
    x689 = x251 * x519
    x690 = x10 * x528
    x691 = 2.0 * x314
    x692 = -x690 + x691
    x693 = x689 + x692
    x694 = x6 * x693
    x695 = x688 - x694
    x696 = x6 * x695
    x697 = x686 + x687 - x696
    x698 = x690 - x691
    x699 = x4 * (x681 - x689 + x698)
    x700 = -x10 * x563 + 2.0 * x345
    x701 = x251 * x528 + x700
    x702 = -x686
    x703 = -x7 - A[1]
    x704 = x16 * x703
    x705 = x141 + x704
    x706 = x5 * x705
    x707 = x13 * x703
    x708 = x147 + x707
    x709 = x6 * x708
    x710 = x706 - x709
    x711 = x5 * x710
    x712 = x4 * (x146 + x705 - x707)
    x713 = x5 * x708
    x714 = x21 * x703
    x715 = x163 + x714
    x716 = x6 * x715
    x717 = x713 - x716
    x718 = x6 * x717
    x719 = x712 - x718
    x720 = x711 + x719
    x721 = x5 * x720
    x722 = x154 + x31 * x703
    x723 = x5 * x722 - x6 * x705
    x724 = x4 * (x140 - x704 + x722)
    x725 = -x6 * x710 + x724
    x726 = x5 * x723 + x725
    x727 = -x6 * x720 + x99 * (-x706 + x709 + x723)
    x728 = x5 * x726 + x727
    x729 = x4 * (x162 + x708 - x714)
    x730 = x5 * x717
    x731 = x5 * x715
    x732 = x41 * x703
    x733 = x182 + x732
    x734 = x6 * x733
    x735 = x731 - x734
    x736 = x6 * x735
    x737 = x729 + x730 - x736
    x738 = x6 * x737
    x739 = x99 * (x710 - x713 + x716)
    x740 = x738 - x739
    x741 = -x738 + x739
    x742 = x721 + x741
    x743 = -x712
    x744 = x718 + x743
    x745 = x4 * (-x711 + x726 + x744)
    x746 = x3 * x728 - x6 * x742 + 3.0 * x745
    x747 = x3 * x742
    x748 = x5 * x737
    x749 = x4 * (x181 + x715 - x732)
    x750 = x5 * x735
    x751 = x5 * x733
    x752 = x62 * x703
    x753 = x208 + x752
    x754 = x6 * x753
    x755 = x751 - x754
    x756 = x6 * x755
    x757 = x749 + x750 - x756
    x758 = x6 * x757
    x759 = x99 * (x717 - x731 + x734)
    x760 = -x758 + x759
    x761 = x748 + x760
    x762 = x6 * x761
    x763 = -x729
    x764 = x736 + x763
    x765 = x4 * (x720 - x730 + x764)
    x766 = 3.0 * x765
    x767 = x747 - x762 + x766
    x768 = x3 * x720
    x769 = x3 * x726 + x727
    x770 = x758 - x759
    x771 = x4 * (x207 + x733 - x752)
    x772 = x237 + x703 * x92
    x773 = -x749
    x774 = x3 * x737
    x775 = x741 + x768
    x776 = x3 * x710
    x777 = x144 * x703
    x778 = x364 + x777
    x779 = x5 * x778
    x780 = x149 * x703
    x781 = x371 + x780
    x782 = x6 * x781
    x783 = -x782
    x784 = x779 + x783
    x785 = x5 * x784
    x786 = x155 * x703 + x359
    x787 = -x6 * x778
    x788 = x5 * x786 + x787
    x789 = x4 * (x362 - x777 + x786)
    x790 = -x6 * x784 + x789
    x791 = x5 * x788 + x790
    x792 = x5 * x781
    x793 = x165 * x703
    x794 = x382 + x793
    x795 = x6 * x794
    x796 = x792 - x795
    x797 = x6 * x796
    x798 = x4 * (x396 + x778 - x780)
    x799 = x797 - x798
    x800 = -x797 + x798
    x801 = x785 + x800
    x802 = x4 * (-x779 + x782 + x788)
    x803 = x3 * x791 - x6 * x801 + 2.0 * x802
    x804 = x3 * x801
    x805 = x5 * x796
    x806 = x4 * (x379 + x781 - x793)
    x807 = x5 * x794
    x808 = x184 * x703
    x809 = x391 + x808
    x810 = x6 * x809
    x811 = x807 - x810
    x812 = x6 * x811
    x813 = x806 - x812
    x814 = x805 + x813
    x815 = x6 * x814
    x816 = x4 * (x784 - x792 + x795)
    x817 = 2.0 * x816
    x818 = x804 - x815 + x817
    x819 = x3 * x784
    x820 = x3 * x788 + x790
    x821 = -x806 + x812
    x822 = x4 * (x424 + x794 - x808)
    x823 = x210 * x703 + x426
    x824 = x3 * x796
    x825 = x800 + x819
    x826 = x3 * x778
    x827 = x253 * x703
    x828 = x433 + x827
    x829 = x5 * x828
    x830 = x258 * x703
    x831 = x440 + x830
    x832 = x6 * x831
    x833 = -x832
    x834 = x829 + x833
    x835 = x5 * x834
    x836 = x264 * x703 + x430
    x837 = -x6 * x828
    x838 = x5 * x836 + x837
    x839 = x4 * (x428 - x827 + x836)
    x840 = -x6 * x834 + x839
    x841 = x5 * x838 + x840
    x842 = x5 * x831
    x843 = x274 * x703
    x844 = x450 + x843
    x845 = x6 * x844
    x846 = x842 - x845
    x847 = x6 * x846
    x848 = x4 * (x439 + x828 - x830)
    x849 = -x848
    x850 = x847 + x849
    x851 = -x847 + x848
    x852 = x835 + x851
    x853 = x4 * (-x829 + x832 + x838)
    x854 = x3 * x841 - x6 * x852 + 2.0 * x853
    x855 = x3 * x852
    x856 = x5 * x846
    x857 = x4 * (x446 + x831 - x843)
    x858 = x5 * x844
    x859 = x293 * x703
    x860 = x459 + x859
    x861 = x6 * x860
    x862 = x858 - x861
    x863 = x6 * x862
    x864 = x857 - x863
    x865 = x856 + x864
    x866 = x6 * x865
    x867 = x4 * (x834 - x842 + x845)
    x868 = 2.0 * x867
    x869 = x855 - x866 + x868
    x870 = x3 * x834
    x871 = x3 * x838 + x840
    x872 = -x857
    x873 = x863 + x872
    x874 = x4 * (x458 + x844 - x859)
    x875 = x319 * x703 + x492
    x876 = x3 * x846
    x877 = x851 + x870
    x878 = x3 * x828
    x879 = x365 * x703
    x880 = x360 * x703 + x565
    x881 = x4 * (x569 - x879 + x880)
    x882 = x571 + x879
    x883 = -x6 * x882
    x884 = x3 * x880 + x883
    x885 = x372 * x703
    x886 = x578 + x885
    x887 = x3 * x886
    x888 = x383 * x703
    x889 = x590 + x888
    x890 = x6 * x889
    x891 = -x890
    x892 = x4 * (x583 + x882 - x885)
    x893 = -x892
    x894 = x3 * x882
    x895 = x6 * x886
    x896 = -x895
    x897 = x894 + x896
    x898 = x5 * x882
    x899 = x5 * x880 + x883
    x900 = x896 + x898
    x901 = x3 * x899 - x6 * x900 + x881
    x902 = x3 * x900
    x903 = x5 * x886
    x904 = x891 + x903
    x905 = x6 * x904
    x906 = x892 + x902 - x905
    x907 = x4 * (x596 + x886 - x888)
    x908 = x392 * x703 + x598
    x909 = x434 * x703
    x910 = x431 * x703 + x602
    x911 = x4 * (x605 - x909 + x910)
    x912 = x607 + x909
    x913 = -x6 * x912
    x914 = x3 * x910 + x913
    x915 = x441 * x703
    x916 = x613 + x915
    x917 = x3 * x916
    x918 = x451 * x703
    x919 = x624 + x918
    x920 = x6 * x919
    x921 = -x920
    x922 = x4 * (x618 + x912 - x915)
    x923 = -x922
    x924 = x3 * x912
    x925 = x6 * x916
    x926 = -x925
    x927 = x924 + x926
    x928 = x5 * x912
    x929 = x5 * x910 + x913
    x930 = x926 + x928
    x931 = x3 * x929 - x6 * x930 + x911
    x932 = x3 * x930
    x933 = x5 * x916
    x934 = x921 + x933
    x935 = x6 * x934
    x936 = x922 + x932 - x935
    x937 = x4 * (x630 + x916 - x918)
    x938 = x460 * x703 + x632
    x939 = x501 * x703
    x940 = x496 * x703 + x637
    x941 = x4 * (x635 - x939 + x940)
    x942 = x640 + x939
    x943 = -x6 * x942
    x944 = x3 * x940 + x943
    x945 = x508 * x703
    x946 = x646 + x945
    x947 = x3 * x946
    x948 = x519 * x703
    x949 = x656 + x948
    x950 = x6 * x949
    x951 = -x950
    x952 = x4 * (x645 + x942 - x945)
    x953 = -x952
    x954 = x3 * x942
    x955 = x6 * x946
    x956 = -x955
    x957 = x954 + x956
    x958 = x5 * x942
    x959 = x5 * x940 + x943
    x960 = x956 + x958
    x961 = x3 * x959 - x6 * x960 + x941
    x962 = x3 * x960
    x963 = x5 * x946
    x964 = x951 + x963
    x965 = x6 * x964
    x966 = x952 + x962 - x965
    x967 = x4 * (x655 + x946 - x948)
    x968 = x528 * x703 + x663
    x969 = x579 * x8
    x970 = x572 * x703
    x971 = 3.0 * x397
    x972 = 3.0 * x363 + x566 * x703 - x572 * x8
    x973 = x4 * (x969 - x970 - x971 + x972)
    x974 = -x969 + x970 + x971
    x975 = x3 * x972 - x6 * x974
    x976 = x3 * x974
    x977 = x579 * x703
    x978 = x591 * x8
    x979 = 3.0 * x380
    x980 = x977 - x978 + x979
    x981 = x6 * x980
    x982 = x976 - x981
    x983 = x4 * (x974 - x977 + x978 - x979)
    x984 = 3.0 * x425 + x591 * x703 - x599 * x8
    x985 = x614 * x8
    x986 = x608 * x703
    x987 = 2.0 * x464
    x988 = 2.0 * x432 + x603 * x703 - x608 * x8
    x989 = x4 * (x985 - x986 - x987 + x988)
    x990 = -x985 + x986 + x987
    x991 = x3 * x988 - x6 * x990
    x992 = x3 * x990
    x993 = x614 * x703
    x994 = x625 * x8
    x995 = 2.0 * x448
    x996 = x993 - x994 + x995
    x997 = x6 * x996
    x998 = x992 - x997
    x999 = x4 * (x990 - x993 + x994 - x995)
    x1000 = 2.0 * x491 + x625 * x703 - x633 * x8
    x1001 = x647 * x8
    x1002 = x641 * x703
    x1003 = x499 + x638 * x703 - x641 * x8
    x1004 = x4 * (x1001 - x1002 + x1003 + x539)
    x1005 = -x1001 + x1002 + x533
    x1006 = x1003 * x3 - x1005 * x6
    x1007 = x1005 * x3
    x1008 = x647 * x703
    x1009 = x657 * x8
    x1010 = x1008 - x1009 + x516
    x1011 = x1010 * x6
    x1012 = x1007 - x1011
    x1013 = x4 * (x1005 - x1008 + x1009 + x559)
    x1014 = x561 + x657 * x703 - x664 * x8
    x1015 = x681 * x8
    x1016 = x674 * x703
    x1017 = x668 * x703 - x674 * x8
    x1018 = x4 * (x1015 - x1016 + x1017)
    x1019 = -x1015 + x1016
    x1020 = x1017 * x3 - x1019 * x6
    x1021 = x1019 * x3
    x1022 = x681 * x703
    x1023 = x693 * x8
    x1024 = x1022 - x1023
    x1025 = x1024 * x6
    x1026 = x1021 - x1025
    x1027 = x4 * (x1019 - x1022 + x1023)
    x1028 = x693 * x703 - x701 * x8
    x1029 = -x9 - A[2]
    x1030 = x1029 * x16
    x1031 = x1030 + x250
    x1032 = x1031 * x5
    x1033 = x1029 * x13
    x1034 = x1033 + x256
    x1035 = x1034 * x6
    x1036 = x1032 - x1035
    x1037 = x1036 * x5
    x1038 = x4 * (x1031 - x1033 + x255)
    x1039 = x1034 * x5
    x1040 = x1029 * x21
    x1041 = x1040 + x272
    x1042 = x1041 * x6
    x1043 = x1039 - x1042
    x1044 = x1043 * x6
    x1045 = x1038 - x1044
    x1046 = x1037 + x1045
    x1047 = x1046 * x5
    x1048 = x1029 * x31 + x263
    x1049 = -x1031 * x6 + x1048 * x5
    x1050 = x4 * (-x1030 + x1048 + x249)
    x1051 = -x1036 * x6 + x1050
    x1052 = x1049 * x5 + x1051
    x1053 = -x1046 * x6 + x99 * (-x1032 + x1035 + x1049)
    x1054 = x1052 * x5 + x1053
    x1055 = x4 * (x1034 - x1040 + x271)
    x1056 = x1043 * x5
    x1057 = x1041 * x5
    x1058 = x1029 * x41
    x1059 = x1058 + x291
    x1060 = x1059 * x6
    x1061 = x1057 - x1060
    x1062 = x1061 * x6
    x1063 = x1055 + x1056 - x1062
    x1064 = x1063 * x6
    x1065 = x99 * (x1036 - x1039 + x1042)
    x1066 = x1064 - x1065
    x1067 = -x1064 + x1065
    x1068 = x1047 + x1067
    x1069 = -x1038
    x1070 = x1044 + x1069
    x1071 = x4 * (-x1037 + x1052 + x1070)
    x1072 = x1054 * x3 - x1068 * x6 + 3.0 * x1071
    x1073 = x1068 * x3
    x1074 = x1063 * x5
    x1075 = x4 * (x1041 - x1058 + x290)
    x1076 = x1061 * x5
    x1077 = x1059 * x5
    x1078 = x1029 * x62
    x1079 = x1078 + x317
    x1080 = x1079 * x6
    x1081 = x1077 - x1080
    x1082 = x1081 * x6
    x1083 = x1075 + x1076 - x1082
    x1084 = x1083 * x6
    x1085 = x99 * (x1043 - x1057 + x1060)
    x1086 = -x1084 + x1085
    x1087 = x1074 + x1086
    x1088 = x1087 * x6
    x1089 = -x1055
    x1090 = x1062 + x1089
    x1091 = x4 * (x1046 - x1056 + x1090)
    x1092 = 3.0 * x1091
    x1093 = x1073 - x1088 + x1092
    x1094 = x1046 * x3
    x1095 = x1052 * x3 + x1053
    x1096 = x1084 - x1085
    x1097 = x4 * (x1059 - x1078 + x316)
    x1098 = x1029 * x92 + x346
    x1099 = -x1075
    x1100 = x1063 * x3
    x1101 = x1067 + x1094
    x1102 = x1036 * x3
    x1103 = x1031 * x142
    x1104 = x1034 * x8
    x1105 = -x1104
    x1106 = x1103 + x1105
    x1107 = x1106 * x5
    x1108 = x1034 * x142
    x1109 = x1041 * x8
    x1110 = -x1109
    x1111 = x1108 + x1110
    x1112 = x1111 * x6
    x1113 = -x1112
    x1114 = x1107 + x1113
    x1115 = x1114 * x5
    x1116 = -x1031 * x8
    x1117 = x1048 * x142 + x1116
    x1118 = -x1106 * x6
    x1119 = x1117 * x5 + x1118
    x1120 = x4 * (-x1103 + x1104 + x1117)
    x1121 = -x1114 * x6 + x1120
    x1122 = x1119 * x5 + x1121
    x1123 = x1111 * x5
    x1124 = x1041 * x142
    x1125 = x1059 * x8
    x1126 = -x1125
    x1127 = x1124 + x1126
    x1128 = x1127 * x6
    x1129 = x1123 - x1128
    x1130 = x1129 * x6
    x1131 = x4 * (x1106 - x1108 + x1109)
    x1132 = -x1131
    x1133 = x1130 + x1132
    x1134 = -x1130 + x1131
    x1135 = x1115 + x1134
    x1136 = x4 * (-x1107 + x1112 + x1119)
    x1137 = x1122 * x3 - x1135 * x6 + 2.0 * x1136
    x1138 = x1135 * x3
    x1139 = x1129 * x5
    x1140 = x4 * (x1111 - x1124 + x1125)
    x1141 = x1127 * x5
    x1142 = x1059 * x142
    x1143 = x1079 * x8
    x1144 = -x1143
    x1145 = x1142 + x1144
    x1146 = x1145 * x6
    x1147 = x1141 - x1146
    x1148 = x1147 * x6
    x1149 = x1140 - x1148
    x1150 = x1139 + x1149
    x1151 = x1150 * x6
    x1152 = x4 * (x1114 - x1123 + x1128)
    x1153 = 2.0 * x1152
    x1154 = x1138 - x1151 + x1153
    x1155 = x1114 * x3
    x1156 = x1119 * x3 + x1121
    x1157 = -x1140
    x1158 = x1148 + x1157
    x1159 = x4 * (x1127 - x1142 + x1143)
    x1160 = -x1098 * x8
    x1161 = x1079 * x142 + x1160
    x1162 = x1129 * x3
    x1163 = x1134 + x1155
    x1164 = x1106 * x3
    x1165 = x1029 * x253
    x1166 = x1165 + x500
    x1167 = x1166 * x5
    x1168 = x1029 * x258
    x1169 = x1168 + x507
    x1170 = x1169 * x6
    x1171 = -x1170
    x1172 = x1167 + x1171
    x1173 = x1172 * x5
    x1174 = x1029 * x264 + x495
    x1175 = -x1166 * x6
    x1176 = x1174 * x5 + x1175
    x1177 = x4 * (-x1165 + x1174 + x498)
    x1178 = -x1172 * x6 + x1177
    x1179 = x1176 * x5 + x1178
    x1180 = x1169 * x5
    x1181 = x1029 * x274
    x1182 = x1181 + x518
    x1183 = x1182 * x6
    x1184 = x1180 - x1183
    x1185 = x1184 * x6
    x1186 = x4 * (x1166 - x1168 + x532)
    x1187 = -x1186
    x1188 = x1185 + x1187
    x1189 = -x1185 + x1186
    x1190 = x1173 + x1189
    x1191 = x4 * (-x1167 + x1170 + x1176)
    x1192 = x1179 * x3 - x1190 * x6 + 2.0 * x1191
    x1193 = x1190 * x3
    x1194 = x1184 * x5
    x1195 = x4 * (x1169 - x1181 + x515)
    x1196 = x1182 * x5
    x1197 = x1029 * x293
    x1198 = x1197 + x527
    x1199 = x1198 * x6
    x1200 = x1196 - x1199
    x1201 = x1200 * x6
    x1202 = x1195 - x1201
    x1203 = x1194 + x1202
    x1204 = x1203 * x6
    x1205 = x4 * (x1172 - x1180 + x1183)
    x1206 = 2.0 * x1205
    x1207 = x1193 - x1204 + x1206
    x1208 = x1172 * x3
    x1209 = x1176 * x3 + x1178
    x1210 = -x1195
    x1211 = x1201 + x1210
    x1212 = x4 * (x1182 - x1197 + x560)
    x1213 = x1029 * x319 + x562
    x1214 = x1184 * x3
    x1215 = x1189 + x1208
    x1216 = x1166 * x3
    x1217 = x1106 * x142
    x1218 = x1050 - x1106 * x8
    x1219 = x1117 * x142 + x1218
    x1220 = x1111 * x8
    x1221 = x1069 + x1220
    x1222 = x4 * (-x1217 + x1219 + x1221)
    x1223 = x1038 - x1220
    x1224 = x1217 + x1223
    x1225 = -x1224 * x6
    x1226 = x1219 * x3 + x1225
    x1227 = x1111 * x142
    x1228 = x1127 * x8
    x1229 = x1055 - x1228
    x1230 = x1227 + x1229
    x1231 = x1230 * x3
    x1232 = x1127 * x142
    x1233 = x1145 * x8
    x1234 = x1075 - x1233
    x1235 = x1232 + x1234
    x1236 = x1235 * x6
    x1237 = -x1236
    x1238 = x1089 + x1228
    x1239 = x4 * (x1224 - x1227 + x1238)
    x1240 = -x1239
    x1241 = x1224 * x3
    x1242 = x1230 * x6
    x1243 = -x1242
    x1244 = x1241 + x1243
    x1245 = x1224 * x5
    x1246 = x1219 * x5 + x1225
    x1247 = x1243 + x1245
    x1248 = x1222 + x1246 * x3 - x1247 * x6
    x1249 = x1247 * x3
    x1250 = x1230 * x5
    x1251 = x1237 + x1250
    x1252 = x1251 * x6
    x1253 = x1239 + x1249 - x1252
    x1254 = x1099 + x1233
    x1255 = x4 * (x1230 - x1232 + x1254)
    x1256 = x1097 - x1161 * x8
    x1257 = x1145 * x142 + x1256
    x1258 = x1169 * x8
    x1259 = x1166 * x142
    x1260 = -x1166 * x8
    x1261 = x1174 * x142 + x1260
    x1262 = x4 * (x1258 - x1259 + x1261)
    x1263 = -x1258
    x1264 = x1259 + x1263
    x1265 = -x1264 * x6
    x1266 = x1261 * x3 + x1265
    x1267 = x1169 * x142
    x1268 = x1182 * x8
    x1269 = -x1268
    x1270 = x1267 + x1269
    x1271 = x1270 * x3
    x1272 = x1182 * x142
    x1273 = x1198 * x8
    x1274 = -x1273
    x1275 = x1272 + x1274
    x1276 = x1275 * x6
    x1277 = -x1276
    x1278 = x4 * (x1264 - x1267 + x1268)
    x1279 = -x1278
    x1280 = x1264 * x3
    x1281 = x1270 * x6
    x1282 = -x1281
    x1283 = x1280 + x1282
    x1284 = x1264 * x5
    x1285 = x1261 * x5 + x1265
    x1286 = x1282 + x1284
    x1287 = x1262 + x1285 * x3 - x1286 * x6
    x1288 = x1286 * x3
    x1289 = x1270 * x5
    x1290 = x1277 + x1289
    x1291 = x1290 * x6
    x1292 = x1278 + x1288 - x1291
    x1293 = x4 * (x1270 - x1272 + x1273)
    x1294 = -x1213 * x8
    x1295 = x1198 * x142 + x1294
    x1296 = x1029 * x501
    x1297 = x1029 * x496 + x667
    x1298 = x4 * (-x1296 + x1297 + x671)
    x1299 = x1296 + x673
    x1300 = -x1299 * x6
    x1301 = x1297 * x3 + x1300
    x1302 = x1029 * x508
    x1303 = x1302 + x680
    x1304 = x1303 * x3
    x1305 = x1029 * x519
    x1306 = x1305 + x692
    x1307 = x1306 * x6
    x1308 = -x1307
    x1309 = x4 * (x1299 - x1302 + x685)
    x1310 = -x1309
    x1311 = x1299 * x3
    x1312 = x1303 * x6
    x1313 = -x1312
    x1314 = x1311 + x1313
    x1315 = x1299 * x5
    x1316 = x1297 * x5 + x1300
    x1317 = x1313 + x1315
    x1318 = x1298 + x1316 * x3 - x1317 * x6
    x1319 = x1317 * x3
    x1320 = x1303 * x5
    x1321 = x1308 + x1320
    x1322 = x1321 * x6
    x1323 = x1309 + x1319 - x1322
    x1324 = x4 * (x1303 - x1305 + x698)
    x1325 = x1029 * x528 + x700
    x1326 = x1224 * x142
    x1327 = 2.0 * x1120 - x1224 * x8
    x1328 = x1219 * x142 + x1327
    x1329 = x1230 * x8
    x1330 = 2.0 * x1131
    x1331 = x1329 - x1330
    x1332 = x4 * (-x1326 + x1328 + x1331)
    x1333 = -x1329 + x1330
    x1334 = x1326 + x1333
    x1335 = x1328 * x3 - x1334 * x6
    x1336 = x1334 * x3
    x1337 = x1230 * x142
    x1338 = x1235 * x8
    x1339 = 2.0 * x1140
    x1340 = -x1338 + x1339
    x1341 = x1337 + x1340
    x1342 = x1341 * x6
    x1343 = x1336 - x1342
    x1344 = x1338 - x1339
    x1345 = x4 * (x1334 - x1337 + x1344)
    x1346 = 2.0 * x1159 - x1257 * x8
    x1347 = x1235 * x142 + x1346
    x1348 = x1264 * x142
    x1349 = x1177 - x1264 * x8
    x1350 = x1261 * x142 + x1349
    x1351 = x1270 * x8
    x1352 = x1187 + x1351
    x1353 = x4 * (-x1348 + x1350 + x1352)
    x1354 = x1186 - x1351
    x1355 = x1348 + x1354
    x1356 = x1350 * x3 - x1355 * x6
    x1357 = x1355 * x3
    x1358 = x1270 * x142
    x1359 = x1275 * x8
    x1360 = x1195 - x1359
    x1361 = x1358 + x1360
    x1362 = x1361 * x6
    x1363 = x1357 - x1362
    x1364 = x1210 + x1359
    x1365 = x4 * (x1355 - x1358 + x1364)
    x1366 = x1212 - x1295 * x8
    x1367 = x1275 * x142 + x1366
    x1368 = x1303 * x8
    x1369 = x1299 * x142
    x1370 = -x1299 * x8
    x1371 = x1297 * x142 + x1370
    x1372 = x4 * (x1368 - x1369 + x1371)
    x1373 = -x1368
    x1374 = x1369 + x1373
    x1375 = x1371 * x3 - x1374 * x6
    x1376 = x1374 * x3
    x1377 = x1303 * x142
    x1378 = x1306 * x8
    x1379 = -x1378
    x1380 = x1377 + x1379
    x1381 = x1380 * x6
    x1382 = x1376 - x1381
    x1383 = x4 * (x1374 - x1377 + x1378)
    x1384 = -x1325 * x8
    x1385 = x1306 * x142 + x1384
    x1386 = x10 * x681
    x1387 = x1029 * x674
    x1388 = 3.0 * x533
    x1389 = -x10 * x674 + x1029 * x668 + 3.0 * x499
    x1390 = x4 * (x1386 - x1387 - x1388 + x1389)
    x1391 = -x1386 + x1387 + x1388
    x1392 = x1389 * x3 - x1391 * x6
    x1393 = x1391 * x3
    x1394 = x1029 * x681
    x1395 = x10 * x693
    x1396 = 3.0 * x516
    x1397 = x1394 - x1395 + x1396
    x1398 = x1397 * x6
    x1399 = x1393 - x1398
    x1400 = x4 * (x1391 - x1394 + x1395 - x1396)
    x1401 = -x10 * x701 + x1029 * x693 + 3.0 * x561
    x1402 = x715 * x8
    x1403 = x703 * x708
    x1404 = x703 * x705
    x1405 = x708 * x8
    x1406 = x1404 - x1405 + x20
    x1407 = x4 * (x1402 - x1403 + x1406 + x75)
    x1408 = x1406 * x5
    x1409 = -x1402 + x1403 + x40
    x1410 = x1409 * x6
    x1411 = x1408 - x1410
    x1412 = x1411 * x5
    x1413 = x1409 * x5
    x1414 = x703 * x715
    x1415 = x733 * x8
    x1416 = x1414 - x1415 + x61
    x1417 = x1416 * x6
    x1418 = x1413 - x1417
    x1419 = x1418 * x6
    x1420 = x1407 + x1412 - x1419
    x1421 = x1420 * x5
    x1422 = x33 + x703 * x722 - x705 * x8
    x1423 = x4 * (-x1404 + x1405 + x1422 + x54)
    x1424 = -x1406 * x6 + x1422 * x5
    x1425 = -x1411 * x6 + x1423 + x1424 * x5
    x1426 = -x1420 * x6 + x99 * (-x1408 + x1410 + x1424)
    x1427 = x1425 * x5 + x1426
    x1428 = x4 * (x104 + x1409 - x1414 + x1415)
    x1429 = x1418 * x5
    x1430 = x1416 * x5
    x1431 = x703 * x733
    x1432 = x753 * x8
    x1433 = x1431 - x1432 + x90
    x1434 = x1433 * x6
    x1435 = x1430 - x1434
    x1436 = x1435 * x6
    x1437 = x1428 + x1429 - x1436
    x1438 = x1437 * x6
    x1439 = x99 * (x1411 - x1413 + x1417)
    x1440 = x1438 - x1439
    x1441 = x1421 - x1438 + x1439
    x1442 = -x1407
    x1443 = x4 * (x127 + x1416 - x1431 + x1432)
    x1444 = x125 + x703 * x753 - x772 * x8
    x1445 = -x1428
    x1446 = x703 * x778
    x1447 = x781 * x8
    x1448 = x1446 - x1447 + x170 + x712
    x1449 = x1448 * x5
    x1450 = x703 * x781
    x1451 = x794 * x8
    x1452 = x1450 - x1451 + x179 + x729
    x1453 = x1452 * x6
    x1454 = x1449 - x1453
    x1455 = x1454 * x5
    x1456 = x158 + x703 * x786 + x724 - x778 * x8
    x1457 = -x1448 * x6 + x1456 * x5
    x1458 = x4 * (-x1446 + x1447 + x1456 + x171 + x743)
    x1459 = -x1454 * x6 + x1458
    x1460 = x1457 * x5 + x1459
    x1461 = x1452 * x5
    x1462 = x703 * x794
    x1463 = x8 * x809
    x1464 = x1462 - x1463 + x205 + x749
    x1465 = x1464 * x6
    x1466 = x1461 - x1465
    x1467 = x1466 * x6
    x1468 = x4 * (x1448 - x1450 + x1451 + x199 + x763)
    x1469 = x1467 - x1468
    x1470 = x1455 - x1467 + x1468
    x1471 = x4 * (x1452 - x1462 + x1463 + x234 + x773)
    x1472 = x236 + x703 * x809 + x771 - x8 * x823
    x1473 = x703 * x828
    x1474 = x8 * x831
    x1475 = x1473 - x1474 + x279
    x1476 = x1475 * x5
    x1477 = x703 * x831
    x1478 = x8 * x844
    x1479 = x1477 - x1478 + x288
    x1480 = x1479 * x6
    x1481 = x1476 - x1480
    x1482 = x1481 * x5
    x1483 = x267 + x703 * x836 - x8 * x828
    x1484 = -x1475 * x6 + x1483 * x5
    x1485 = x4 * (-x1473 + x1474 + x1483 + x280)
    x1486 = -x1481 * x6 + x1485
    x1487 = x1484 * x5 + x1486
    x1488 = x1479 * x5
    x1489 = x703 * x844
    x1490 = x8 * x860
    x1491 = x1489 - x1490 + x314
    x1492 = x1491 * x6
    x1493 = x1488 - x1492
    x1494 = x1493 * x6
    x1495 = x4 * (x1475 - x1477 + x1478 + x308)
    x1496 = -x1495
    x1497 = x1494 + x1496
    x1498 = x1482 - x1494 + x1495
    x1499 = x4 * (x1479 - x1489 + x1490 + x343)
    x1500 = x345 + x703 * x860 - x8 * x875
    x1501 = 2.0 * x789
    x1502 = x1501 + x363 + x703 * x880 - x8 * x882
    x1503 = x703 * x886
    x1504 = x8 * x889
    x1505 = 2.0 * x806
    x1506 = x1503 - x1504 + x1505 + x380
    x1507 = x1506 * x6
    x1508 = x703 * x882
    x1509 = x8 * x886
    x1510 = 2.0 * x798
    x1511 = x1508 - x1509 + x1510 + x397
    x1512 = -x1511 * x6
    x1513 = x1511 * x5
    x1514 = x1502 * x5 + x1512
    x1515 = -x1510
    x1516 = x4 * (x1502 - x1508 + x1509 + x1515 + x403)
    x1517 = -x1507 + x1513
    x1518 = -x1505
    x1519 = x4 * (-x1503 + x1504 + x1511 + x1518 + x423)
    x1520 = 2.0 * x822
    x1521 = x1520 + x425 + x703 * x889 - x8 * x908
    x1522 = x432 + x703 * x910 - x8 * x912 + x839
    x1523 = x703 * x916
    x1524 = x8 * x919
    x1525 = x1523 - x1524 + x448 + x857
    x1526 = x1525 * x6
    x1527 = x703 * x912
    x1528 = x8 * x916
    x1529 = x1527 - x1528 + x464 + x848
    x1530 = -x1529 * x6
    x1531 = x1529 * x5
    x1532 = x1522 * x5 + x1530
    x1533 = x4 * (x1522 - x1527 + x1528 + x470 + x849)
    x1534 = -x1526 + x1531
    x1535 = x4 * (-x1523 + x1524 + x1529 + x490 + x872)
    x1536 = x491 + x703 * x919 - x8 * x938 + x874
    x1537 = x499 + x703 * x940 - x8 * x942
    x1538 = x703 * x946
    x1539 = x8 * x949
    x1540 = x1538 - x1539 + x516
    x1541 = x1540 * x6
    x1542 = x703 * x942
    x1543 = x8 * x946
    x1544 = x1542 - x1543 + x533
    x1545 = -x1544 * x6
    x1546 = x1544 * x5
    x1547 = x1537 * x5 + x1545
    x1548 = x4 * (x1537 - x1542 + x1543 + x539)
    x1549 = -x1541 + x1546
    x1550 = x4 * (-x1538 + x1539 + x1544 + x559)
    x1551 = x561 + x703 * x949 - x8 * x968
    x1552 = x8 * x980
    x1553 = x703 * x974
    x1554 = 3.0 * x892
    x1555 = x570 + x703 * x972 - x8 * x974 + 3.0 * x881
    x1556 = x4 * (x1552 - x1553 - x1554 + x1555 + x600)
    x1557 = -x1552 + x1553 + x1554 + x584
    x1558 = x597 + x703 * x980 - x8 * x984 + 3.0 * x907
    x1559 = x8 * x996
    x1560 = x703 * x990
    x1561 = 2.0 * x922
    x1562 = -x1561
    x1563 = 2.0 * x911
    x1564 = x1563 + x606 + x703 * x988 - x8 * x990
    x1565 = x4 * (x1559 - x1560 + x1562 + x1564 + x634)
    x1566 = -x1559 + x1560 + x1561 + x619
    x1567 = 2.0 * x937
    x1568 = -x1000 * x8 + x1567 + x631 + x703 * x996
    x1569 = x1010 * x8
    x1570 = x1005 * x703
    x1571 = x1003 * x703 - x1005 * x8 + x639 + x941
    x1572 = x4 * (x1569 - x1570 + x1571 + x665 + x953)
    x1573 = -x1569 + x1570 + x651 + x952
    x1574 = x1010 * x703 - x1014 * x8 + x662 + x967
    x1575 = x1024 * x8
    x1576 = x1019 * x703
    x1577 = x1017 * x703 - x1019 * x8 + x672
    x1578 = x4 * (x1575 - x1576 + x1577 + x702)
    x1579 = -x1575 + x1576 + x686
    x1580 = x1024 * x703 - x1028 * x8 + x699
    x1581 = x1034 * x703
    x1582 = x1031 * x703
    x1583 = x1105 + x1582
    x1584 = x4 * (x1109 - x1581 + x1583)
    x1585 = x1583 * x5
    x1586 = x1110 + x1581
    x1587 = x1586 * x6
    x1588 = x1585 - x1587
    x1589 = x1588 * x5
    x1590 = x1586 * x5
    x1591 = x1041 * x703
    x1592 = x1126 + x1591
    x1593 = x1592 * x6
    x1594 = x1590 - x1593
    x1595 = x1594 * x6
    x1596 = x1584 + x1589 - x1595
    x1597 = x1596 * x5
    x1598 = x1048 * x703 + x1116
    x1599 = x4 * (x1104 - x1582 + x1598)
    x1600 = -x1583 * x6 + x1598 * x5
    x1601 = -x1588 * x6 + x1599 + x1600 * x5
    x1602 = -x1596 * x6 + x99 * (-x1585 + x1587 + x1600)
    x1603 = x1601 * x5 + x1602
    x1604 = x4 * (x1125 + x1586 - x1591)
    x1605 = x1594 * x5
    x1606 = x1592 * x5
    x1607 = x1059 * x703
    x1608 = x1144 + x1607
    x1609 = x1608 * x6
    x1610 = x1606 - x1609
    x1611 = x1610 * x6
    x1612 = x1604 + x1605 - x1611
    x1613 = x1612 * x6
    x1614 = x99 * (x1588 - x1590 + x1593)
    x1615 = x1613 - x1614
    x1616 = x1597 - x1613 + x1614
    x1617 = -x1584
    x1618 = x4 * (x1143 + x1592 - x1607)
    x1619 = x1079 * x703 + x1160
    x1620 = -x1604
    x1621 = x1106 * x703
    x1622 = x1223 + x1621
    x1623 = x1622 * x5
    x1624 = x1111 * x703
    x1625 = x1229 + x1624
    x1626 = x1625 * x6
    x1627 = x1623 - x1626
    x1628 = x1627 * x5
    x1629 = x1117 * x703 + x1218
    x1630 = -x1622 * x6 + x1629 * x5
    x1631 = x4 * (x1221 - x1621 + x1629)
    x1632 = -x1627 * x6 + x1631
    x1633 = x1630 * x5 + x1632
    x1634 = x1625 * x5
    x1635 = x1127 * x703
    x1636 = x1234 + x1635
    x1637 = x1636 * x6
    x1638 = x1634 - x1637
    x1639 = x1638 * x6
    x1640 = x4 * (x1238 + x1622 - x1624)
    x1641 = x1639 - x1640
    x1642 = x1628 - x1639 + x1640
    x1643 = x4 * (x1254 + x1625 - x1635)
    x1644 = x1145 * x703 + x1256
    x1645 = x1166 * x703
    x1646 = x1263 + x1645
    x1647 = x1646 * x5
    x1648 = x1169 * x703
    x1649 = x1269 + x1648
    x1650 = x1649 * x6
    x1651 = x1647 - x1650
    x1652 = x1651 * x5
    x1653 = x1174 * x703 + x1260
    x1654 = -x1646 * x6 + x1653 * x5
    x1655 = x4 * (x1258 - x1645 + x1653)
    x1656 = -x1651 * x6 + x1655
    x1657 = x1654 * x5 + x1656
    x1658 = x1649 * x5
    x1659 = x1182 * x703
    x1660 = x1274 + x1659
    x1661 = x1660 * x6
    x1662 = x1658 - x1661
    x1663 = x1662 * x6
    x1664 = x4 * (x1268 + x1646 - x1648)
    x1665 = -x1664
    x1666 = x1663 + x1665
    x1667 = x1652 - x1663 + x1664
    x1668 = x4 * (x1273 + x1649 - x1659)
    x1669 = x1198 * x703 + x1294
    x1670 = x1219 * x703 + x1327
    x1671 = x1230 * x703
    x1672 = x1340 + x1671
    x1673 = x1672 * x6
    x1674 = x1224 * x703
    x1675 = x1333 + x1674
    x1676 = -x1675 * x6
    x1677 = x1675 * x5
    x1678 = x1670 * x5 + x1676
    x1679 = x4 * (x1331 + x1670 - x1674)
    x1680 = -x1673 + x1677
    x1681 = x4 * (x1344 - x1671 + x1675)
    x1682 = x1235 * x703 + x1346
    x1683 = x1261 * x703 + x1349
    x1684 = x1270 * x703
    x1685 = x1360 + x1684
    x1686 = x1685 * x6
    x1687 = x1264 * x703
    x1688 = x1354 + x1687
    x1689 = -x1688 * x6
    x1690 = x1688 * x5
    x1691 = x1683 * x5 + x1689
    x1692 = x4 * (x1352 + x1683 - x1687)
    x1693 = -x1686 + x1690
    x1694 = x4 * (x1364 - x1684 + x1688)
    x1695 = x1275 * x703 + x1366
    x1696 = x1297 * x703 + x1370
    x1697 = x1303 * x703
    x1698 = x1379 + x1697
    x1699 = x1698 * x6
    x1700 = x1299 * x703
    x1701 = x1373 + x1700
    x1702 = -x1701 * x6
    x1703 = x1701 * x5
    x1704 = x1696 * x5 + x1702
    x1705 = x4 * (x1368 + x1696 - x1700)
    x1706 = -x1699 + x1703
    x1707 = x4 * (x1378 - x1697 + x1701)
    x1708 = x1306 * x703 + x1384
    x1709 = x1341 * x8
    x1710 = x1334 * x703
    x1711 = 3.0 * x1239
    x1712 = 3.0 * x1222 + x1328 * x703 - x1334 * x8
    x1713 = x4 * (x1709 - x1710 - x1711 + x1712)
    x1714 = -x1709 + x1710 + x1711
    x1715 = 3.0 * x1255 + x1341 * x703 - x1347 * x8
    x1716 = x1361 * x8
    x1717 = x1355 * x703
    x1718 = 2.0 * x1278
    x1719 = 2.0 * x1262 + x1350 * x703 - x1355 * x8
    x1720 = x4 * (x1716 - x1717 - x1718 + x1719)
    x1721 = -x1716 + x1717 + x1718
    x1722 = 2.0 * x1293 + x1361 * x703 - x1367 * x8
    x1723 = x1380 * x8
    x1724 = x1374 * x703
    x1725 = x1298 + x1371 * x703 - x1374 * x8
    x1726 = x4 * (x1310 + x1723 - x1724 + x1725)
    x1727 = x1309 - x1723 + x1724
    x1728 = x1324 + x1380 * x703 - x1385 * x8
    x1729 = x1397 * x8
    x1730 = x1391 * x703
    x1731 = x1389 * x703 - x1391 * x8
    x1732 = x4 * (x1729 - x1730 + x1731)
    x1733 = -x1729 + x1730
    x1734 = x1397 * x703 - x1401 * x8
    x1735 = x10 * x1041
    x1736 = x1029 * x1034
    x1737 = x1029 * x1031
    x1738 = x10 * x1034
    x1739 = x1737 - x1738 + x20
    x1740 = x4 * (x1735 - x1736 + x1739 + x75)
    x1741 = x1739 * x5
    x1742 = -x1735 + x1736 + x40
    x1743 = x1742 * x6
    x1744 = x1741 - x1743
    x1745 = x1744 * x5
    x1746 = x1742 * x5
    x1747 = x1029 * x1041
    x1748 = x10 * x1059
    x1749 = x1747 - x1748 + x61
    x1750 = x1749 * x6
    x1751 = x1746 - x1750
    x1752 = x1751 * x6
    x1753 = x1740 + x1745 - x1752
    x1754 = x1753 * x5
    x1755 = -x10 * x1031 + x1029 * x1048 + x33
    x1756 = x4 * (-x1737 + x1738 + x1755 + x54)
    x1757 = -x1739 * x6 + x1755 * x5
    x1758 = -x1744 * x6 + x1756 + x1757 * x5
    x1759 = -x1753 * x6 + x99 * (-x1741 + x1743 + x1757)
    x1760 = x1758 * x5 + x1759
    x1761 = x4 * (x104 + x1742 - x1747 + x1748)
    x1762 = x1751 * x5
    x1763 = x1749 * x5
    x1764 = x1029 * x1059
    x1765 = x10 * x1079
    x1766 = x1764 - x1765 + x90
    x1767 = x1766 * x6
    x1768 = x1763 - x1767
    x1769 = x1768 * x6
    x1770 = x1761 + x1762 - x1769
    x1771 = x1770 * x6
    x1772 = x99 * (x1744 - x1746 + x1750)
    x1773 = x1771 - x1772
    x1774 = x1754 - x1771 + x1772
    x1775 = -x1740
    x1776 = x4 * (x127 + x1749 - x1764 + x1765)
    x1777 = -x10 * x1098 + x1029 * x1079 + x125
    x1778 = -x1761
    x1779 = x142 * x1739
    x1780 = x1742 * x8
    x1781 = -x1780
    x1782 = x1779 + x1781
    x1783 = x1782 * x5
    x1784 = x142 * x1742
    x1785 = x1749 * x8
    x1786 = -x1785
    x1787 = x1784 + x1786
    x1788 = x1787 * x6
    x1789 = x1783 - x1788
    x1790 = x1789 * x5
    x1791 = -x1739 * x8
    x1792 = x142 * x1755 + x1791
    x1793 = -x1782 * x6 + x1792 * x5
    x1794 = x4 * (-x1779 + x1780 + x1792)
    x1795 = -x1789 * x6 + x1794
    x1796 = x1793 * x5 + x1795
    x1797 = x1787 * x5
    x1798 = x142 * x1749
    x1799 = x1766 * x8
    x1800 = -x1799
    x1801 = x1798 + x1800
    x1802 = x1801 * x6
    x1803 = x1797 - x1802
    x1804 = x1803 * x6
    x1805 = x4 * (x1782 - x1784 + x1785)
    x1806 = -x1805
    x1807 = x1804 + x1806
    x1808 = x1790 - x1804 + x1805
    x1809 = x4 * (x1787 - x1798 + x1799)
    x1810 = -x1777 * x8
    x1811 = x142 * x1766 + x1810
    x1812 = x1029 * x1166
    x1813 = x10 * x1169
    x1814 = x1038 + x1812 - x1813 + x279
    x1815 = x1814 * x5
    x1816 = x1029 * x1169
    x1817 = x10 * x1182
    x1818 = x1055 + x1816 - x1817 + x288
    x1819 = x1818 * x6
    x1820 = x1815 - x1819
    x1821 = x1820 * x5
    x1822 = -x10 * x1166 + x1029 * x1174 + x1050 + x267
    x1823 = -x1814 * x6 + x1822 * x5
    x1824 = x4 * (x1069 - x1812 + x1813 + x1822 + x280)
    x1825 = -x1820 * x6 + x1824
    x1826 = x1823 * x5 + x1825
    x1827 = x1818 * x5
    x1828 = x1029 * x1182
    x1829 = x10 * x1198
    x1830 = x1075 + x1828 - x1829 + x314
    x1831 = x1830 * x6
    x1832 = x1827 - x1831
    x1833 = x1832 * x6
    x1834 = x4 * (x1089 + x1814 - x1816 + x1817 + x308)
    x1835 = -x1834
    x1836 = x1833 + x1835
    x1837 = x1821 - x1833 + x1834
    x1838 = x4 * (x1099 + x1818 - x1828 + x1829 + x343)
    x1839 = -x10 * x1213 + x1029 * x1198 + x1097 + x345
    x1840 = x1756 - x1782 * x8
    x1841 = x142 * x1792 + x1840
    x1842 = x142 * x1787
    x1843 = x1801 * x8
    x1844 = x1761 - x1843
    x1845 = x1842 + x1844
    x1846 = x1845 * x6
    x1847 = x142 * x1782
    x1848 = x1787 * x8
    x1849 = x1740 - x1848
    x1850 = x1847 + x1849
    x1851 = -x1850 * x6
    x1852 = x1850 * x5
    x1853 = x1841 * x5 + x1851
    x1854 = x1775 + x1848
    x1855 = x4 * (x1841 - x1847 + x1854)
    x1856 = -x1846 + x1852
    x1857 = x1778 + x1843
    x1858 = x4 * (-x1842 + x1850 + x1857)
    x1859 = x1776 - x1811 * x8
    x1860 = x142 * x1801 + x1859
    x1861 = -x1814 * x8
    x1862 = x142 * x1822 + x1861
    x1863 = x142 * x1818
    x1864 = x1830 * x8
    x1865 = -x1864
    x1866 = x1863 + x1865
    x1867 = x1866 * x6
    x1868 = x142 * x1814
    x1869 = x1818 * x8
    x1870 = -x1869
    x1871 = x1868 + x1870
    x1872 = -x1871 * x6
    x1873 = x1871 * x5
    x1874 = x1862 * x5 + x1872
    x1875 = x4 * (x1862 - x1868 + x1869)
    x1876 = -x1867 + x1873
    x1877 = x4 * (-x1863 + x1864 + x1871)
    x1878 = -x1839 * x8
    x1879 = x142 * x1830 + x1878
    x1880 = 2.0 * x1177
    x1881 = -x10 * x1299 + x1029 * x1297 + x1880 + x499
    x1882 = x1029 * x1303
    x1883 = x10 * x1306
    x1884 = 2.0 * x1195
    x1885 = x1882 - x1883 + x1884 + x516
    x1886 = x1885 * x6
    x1887 = x1029 * x1299
    x1888 = x10 * x1303
    x1889 = 2.0 * x1186
    x1890 = x1887 - x1888 + x1889 + x533
    x1891 = -x1890 * x6
    x1892 = x1890 * x5
    x1893 = x1881 * x5 + x1891
    x1894 = -x1889
    x1895 = x4 * (x1881 - x1887 + x1888 + x1894 + x539)
    x1896 = -x1886 + x1892
    x1897 = -x1884
    x1898 = x4 * (-x1882 + x1883 + x1890 + x1897 + x559)
    x1899 = 2.0 * x1212
    x1900 = -x10 * x1325 + x1029 * x1306 + x1899 + x561
    x1901 = x142 * x1850
    x1902 = 2.0 * x1794 - x1850 * x8
    x1903 = x142 * x1841 + x1902
    x1904 = x1845 * x8
    x1905 = 2.0 * x1805
    x1906 = x1904 - x1905
    x1907 = x4 * (-x1901 + x1903 + x1906)
    x1908 = -x1904 + x1905
    x1909 = x1901 + x1908
    x1910 = 2.0 * x1809 - x1860 * x8
    x1911 = x142 * x1845 + x1910
    x1912 = x142 * x1871
    x1913 = x1824 - x1871 * x8
    x1914 = x142 * x1862 + x1913
    x1915 = x1866 * x8
    x1916 = x1835 + x1915
    x1917 = x4 * (-x1912 + x1914 + x1916)
    x1918 = x1834 - x1915
    x1919 = x1912 + x1918
    x1920 = x1838 - x1879 * x8
    x1921 = x142 * x1866 + x1920
    x1922 = x1885 * x8
    x1923 = x142 * x1890
    x1924 = -x1890 * x8
    x1925 = x142 * x1881 + x1924
    x1926 = x4 * (x1922 - x1923 + x1925)
    x1927 = -x1922
    x1928 = x1923 + x1927
    x1929 = -x1900 * x8
    x1930 = x142 * x1885 + x1929
    x1931 = x10 * x1397
    x1932 = x1029 * x1391
    x1933 = 3.0 * x1309
    x1934 = -x10 * x1391 + x1029 * x1389 + 3.0 * x1298 + x672
    x1935 = x4 * (x1931 - x1932 - x1933 + x1934 + x702)
    x1936 = -x1931 + x1932 + x1933 + x686
    x1937 = -x10 * x1401 + x1029 * x1397 + 3.0 * x1324 + x699
    x1938 = x1409 * x8
    x1939 = x1406 * x703
    x1940 = 2.0 * x712
    x1941 = -x1406 * x8 + x1422 * x703 + 2.0 * x724
    x1942 = x4 * (x1938 - x1939 - x1940 + x1941)
    x1943 = -x1938 + x1939 + x1940
    x1944 = x1941 * x5 - x1943 * x6
    x1945 = x1943 * x5
    x1946 = x1409 * x703
    x1947 = x1416 * x8
    x1948 = 2.0 * x729
    x1949 = x1946 - x1947 + x1948
    x1950 = x1949 * x6
    x1951 = x1945 - x1950
    x1952 = x1942 + x1944 * x5 - x1951 * x6
    x1953 = x4 * (x1943 - x1946 + x1947 - x1948)
    x1954 = x1951 * x5
    x1955 = x1949 * x5
    x1956 = x1416 * x703
    x1957 = x1433 * x8
    x1958 = 2.0 * x749
    x1959 = x1956 - x1957 + x1958
    x1960 = x1959 * x6
    x1961 = x1955 - x1960
    x1962 = x1961 * x6
    x1963 = x1953 + x1954 - x1962
    x1964 = x4 * (x1949 - x1956 + x1957 - x1958)
    x1965 = x1433 * x703 - x1444 * x8 + 2.0 * x771
    x1966 = -x1953
    x1967 = x1452 * x8
    x1968 = x1448 * x703
    x1969 = x1423 - x1448 * x8 + x1456 * x703 + x1501
    x1970 = x4 * (x1442 + x1515 + x1967 - x1968 + x1969)
    x1971 = x1407 + x1510 - x1967 + x1968
    x1972 = x1969 * x5 - x1971 * x6
    x1973 = x1971 * x5
    x1974 = x1452 * x703
    x1975 = x1464 * x8
    x1976 = x1428 + x1505 + x1974 - x1975
    x1977 = x1976 * x6
    x1978 = x1973 - x1977
    x1979 = x4 * (x1445 + x1518 + x1971 - x1974 + x1975)
    x1980 = x1443 + x1464 * x703 - x1472 * x8 + x1520
    x1981 = x1479 * x8
    x1982 = x1475 * x703
    x1983 = 2.0 * x848
    x1984 = -x1475 * x8 + x1483 * x703 + 2.0 * x839
    x1985 = x4 * (x1981 - x1982 - x1983 + x1984)
    x1986 = -x1981 + x1982 + x1983
    x1987 = x1984 * x5 - x1986 * x6
    x1988 = x1986 * x5
    x1989 = x1479 * x703
    x1990 = x1491 * x8
    x1991 = 2.0 * x857
    x1992 = x1989 - x1990 + x1991
    x1993 = x1992 * x6
    x1994 = x1988 - x1993
    x1995 = x4 * (x1986 - x1989 + x1990 - x1991)
    x1996 = x1491 * x703 - x1500 * x8 + 2.0 * x874
    x1997 = x1506 * x8
    x1998 = x1511 * x703
    x1999 = 2.0 * x892
    x2000 = 2.0 * x1468
    x2001 = 2.0 * x1458 + x1502 * x703 - x1511 * x8 + 2.0 * x881
    x2002 = x4 * (x1997 - x1998 - x1999 - x2000 + x2001)
    x2003 = -x1997 + x1998 + x1999 + x2000
    x2004 = 2.0 * x1471 + x1506 * x703 - x1521 * x8 + 2.0 * x907
    x2005 = x1525 * x8
    x2006 = x1529 * x703
    x2007 = x1485 + x1522 * x703 - x1529 * x8 + x1563
    x2008 = x4 * (x1496 + x1562 + x2005 - x2006 + x2007)
    x2009 = x1495 + x1561 - x2005 + x2006
    x2010 = x1499 + x1525 * x703 - x1536 * x8 + x1567
    x2011 = x1540 * x8
    x2012 = x1544 * x703
    x2013 = 2.0 * x952
    x2014 = x1537 * x703 - x1544 * x8 + 2.0 * x941
    x2015 = x4 * (x2011 - x2012 - x2013 + x2014)
    x2016 = -x2011 + x2012 + x2013
    x2017 = x1540 * x703 - x1551 * x8 + 2.0 * x967
    x2018 = 3.0 * x1516
    x2019 = x1555 * x703 - x1557 * x8 + x2018 + 2.0 * x973
    x2020 = 3.0 * x1519
    x2021 = x1557 * x703 - x1558 * x8 + x2020 + 2.0 * x983
    x2022 = 2.0 * x1533 + x1564 * x703 - x1566 * x8 + 2.0 * x989
    x2023 = 2.0 * x1535 + x1566 * x703 - x1568 * x8 + 2.0 * x999
    x2024 = 2.0 * x1004 + x1548 + x1571 * x703 - x1573 * x8
    x2025 = 2.0 * x1013 + x1550 + x1573 * x703 - x1574 * x8
    x2026 = 2.0 * x1018 + x1577 * x703 - x1579 * x8
    x2027 = 2.0 * x1027 + x1579 * x703 - x1580 * x8
    x2028 = x1586 * x8
    x2029 = x1583 * x703
    x2030 = x1050 - x1583 * x8 + x1598 * x703
    x2031 = x4 * (x1069 + x2028 - x2029 + x2030)
    x2032 = x1038 - x2028 + x2029
    x2033 = x2030 * x5 - x2032 * x6
    x2034 = x2032 * x5
    x2035 = x1586 * x703
    x2036 = x1592 * x8
    x2037 = x1055 + x2035 - x2036
    x2038 = x2037 * x6
    x2039 = x2034 - x2038
    x2040 = x2031 + x2033 * x5 - x2039 * x6
    x2041 = x4 * (x1089 + x2032 - x2035 + x2036)
    x2042 = x2039 * x5
    x2043 = x2037 * x5
    x2044 = x1592 * x703
    x2045 = x1608 * x8
    x2046 = x1075 + x2044 - x2045
    x2047 = x2046 * x6
    x2048 = x2043 - x2047
    x2049 = x2048 * x6
    x2050 = x2041 + x2042 - x2049
    x2051 = x4 * (x1099 + x2037 - x2044 + x2045)
    x2052 = x1097 + x1608 * x703 - x1619 * x8
    x2053 = -x2041
    x2054 = x1625 * x8
    x2055 = x1622 * x703
    x2056 = x1120 + x1599 - x1622 * x8 + x1629 * x703
    x2057 = x4 * (x1132 + x1617 + x2054 - x2055 + x2056)
    x2058 = x1131 + x1584 - x2054 + x2055
    x2059 = x2056 * x5 - x2058 * x6
    x2060 = x2058 * x5
    x2061 = x1625 * x703
    x2062 = x1636 * x8
    x2063 = x1140 + x1604 + x2061 - x2062
    x2064 = x2063 * x6
    x2065 = x2060 - x2064
    x2066 = x4 * (x1157 + x1620 + x2058 - x2061 + x2062)
    x2067 = x1159 + x1618 + x1636 * x703 - x1644 * x8
    x2068 = x1649 * x8
    x2069 = x1646 * x703
    x2070 = x1177 - x1646 * x8 + x1653 * x703
    x2071 = x4 * (x1187 + x2068 - x2069 + x2070)
    x2072 = x1186 - x2068 + x2069
    x2073 = x2070 * x5 - x2072 * x6
    x2074 = x2072 * x5
    x2075 = x1649 * x703
    x2076 = x1660 * x8
    x2077 = x1195 + x2075 - x2076
    x2078 = x2077 * x6
    x2079 = x2074 - x2078
    x2080 = x4 * (x1210 + x2072 - x2075 + x2076)
    x2081 = x1212 + x1660 * x703 - x1669 * x8
    x2082 = x1672 * x8
    x2083 = x1675 * x703
    x2084 = 2.0 * x1640
    x2085 = -x2084
    x2086 = 2.0 * x1631
    x2087 = x1222 + x1670 * x703 - x1675 * x8 + x2086
    x2088 = x4 * (x1240 + x2082 - x2083 + x2085 + x2087)
    x2089 = x1239 - x2082 + x2083 + x2084
    x2090 = 2.0 * x1643
    x2091 = x1255 + x1672 * x703 - x1682 * x8 + x2090
    x2092 = x1685 * x8
    x2093 = x1688 * x703
    x2094 = x1262 + x1655 + x1683 * x703 - x1688 * x8
    x2095 = x4 * (x1279 + x1665 + x2092 - x2093 + x2094)
    x2096 = x1278 + x1664 - x2092 + x2093
    x2097 = x1293 + x1668 + x1685 * x703 - x1695 * x8
    x2098 = x1698 * x8
    x2099 = x1701 * x703
    x2100 = x1298 + x1696 * x703 - x1701 * x8
    x2101 = x4 * (x1310 + x2098 - x2099 + x2100)
    x2102 = x1309 - x2098 + x2099
    x2103 = x1324 + x1698 * x703 - x1708 * x8
    x2104 = x1332 + 3.0 * x1679 + x1712 * x703 - x1714 * x8
    x2105 = x1345 + 3.0 * x1681 + x1714 * x703 - x1715 * x8
    x2106 = 2.0 * x1692
    x2107 = x1353 + x1719 * x703 - x1721 * x8 + x2106
    x2108 = 2.0 * x1694
    x2109 = x1365 + x1721 * x703 - x1722 * x8 + x2108
    x2110 = x1372 + x1705 + x1725 * x703 - x1727 * x8
    x2111 = x1383 + x1707 + x1727 * x703 - x1728 * x8
    x2112 = x1390 + x1731 * x703 - x1733 * x8
    x2113 = x1400 + x1733 * x703 - x1734 * x8
    x2114 = x1739 * x703
    x2115 = x1755 * x703 + x1791
    x2116 = x4 * (x1780 - x2114 + x2115)
    x2117 = x1781 + x2114
    x2118 = x2115 * x5 - x2117 * x6
    x2119 = x2117 * x5
    x2120 = x1742 * x703
    x2121 = x1786 + x2120
    x2122 = x2121 * x6
    x2123 = x2119 - x2122
    x2124 = x2116 + x2118 * x5 - x2123 * x6
    x2125 = x4 * (x1785 + x2117 - x2120)
    x2126 = x2123 * x5
    x2127 = x2121 * x5
    x2128 = x1749 * x703
    x2129 = x1800 + x2128
    x2130 = x2129 * x6
    x2131 = x2127 - x2130
    x2132 = x2131 * x6
    x2133 = x2125 + x2126 - x2132
    x2134 = x4 * (x1799 + x2121 - x2128)
    x2135 = x1766 * x703 + x1810
    x2136 = -x2125
    x2137 = x1782 * x703
    x2138 = x1792 * x703 + x1840
    x2139 = x4 * (x1854 - x2137 + x2138)
    x2140 = x1849 + x2137
    x2141 = x2138 * x5 - x2140 * x6
    x2142 = x2140 * x5
    x2143 = x1787 * x703
    x2144 = x1844 + x2143
    x2145 = x2144 * x6
    x2146 = x2142 - x2145
    x2147 = x4 * (x1857 + x2140 - x2143)
    x2148 = x1801 * x703 + x1859
    x2149 = x1814 * x703
    x2150 = x1822 * x703 + x1861
    x2151 = x4 * (x1869 - x2149 + x2150)
    x2152 = x1870 + x2149
    x2153 = x2150 * x5 - x2152 * x6
    x2154 = x2152 * x5
    x2155 = x1818 * x703
    x2156 = x1865 + x2155
    x2157 = x2156 * x6
    x2158 = x2154 - x2157
    x2159 = x4 * (x1864 + x2152 - x2155)
    x2160 = x1830 * x703 + x1878
    x2161 = x1850 * x703
    x2162 = x1841 * x703 + x1902
    x2163 = x4 * (x1906 - x2161 + x2162)
    x2164 = x1908 + x2161
    x2165 = x1845 * x703 + x1910
    x2166 = x1871 * x703
    x2167 = x1862 * x703 + x1913
    x2168 = x4 * (x1916 - x2166 + x2167)
    x2169 = x1918 + x2166
    x2170 = x1866 * x703 + x1920
    x2171 = x1890 * x703
    x2172 = x1881 * x703 + x1924
    x2173 = x4 * (x1922 - x2171 + x2172)
    x2174 = x1927 + x2171
    x2175 = x1885 * x703 + x1929
    x2176 = 3.0 * x1855 + x1903 * x703 - x1909 * x8
    x2177 = 3.0 * x1858 + x1909 * x703 - x1911 * x8
    x2178 = 2.0 * x1875 + x1914 * x703 - x1919 * x8
    x2179 = 2.0 * x1877 + x1919 * x703 - x1921 * x8
    x2180 = x1895 + x1925 * x703 - x1928 * x8
    x2181 = x1898 + x1928 * x703 - x1930 * x8
    x2182 = x1934 * x703 - x1936 * x8
    x2183 = x1936 * x703 - x1937 * x8
    x2184 = x10 * x1742
    x2185 = x1029 * x1739
    x2186 = 2.0 * x1038
    x2187 = -x10 * x1739 + x1029 * x1755 + 2.0 * x1050
    x2188 = x4 * (x2184 - x2185 - x2186 + x2187)
    x2189 = -x2184 + x2185 + x2186
    x2190 = x2187 * x5 - x2189 * x6
    x2191 = x2189 * x5
    x2192 = x1029 * x1742
    x2193 = x10 * x1749
    x2194 = 2.0 * x1055
    x2195 = x2192 - x2193 + x2194
    x2196 = x2195 * x6
    x2197 = x2191 - x2196
    x2198 = x2188 + x2190 * x5 - x2197 * x6
    x2199 = x4 * (x2189 - x2192 + x2193 - x2194)
    x2200 = x2197 * x5
    x2201 = x2195 * x5
    x2202 = x1029 * x1749
    x2203 = x10 * x1766
    x2204 = 2.0 * x1075
    x2205 = x2202 - x2203 + x2204
    x2206 = x2205 * x6
    x2207 = x2201 - x2206
    x2208 = x2207 * x6
    x2209 = x2199 + x2200 - x2208
    x2210 = x4 * (x2195 - x2202 + x2203 - x2204)
    x2211 = -x10 * x1777 + x1029 * x1766 + 2.0 * x1097
    x2212 = -x2199
    x2213 = x2195 * x8
    x2214 = x142 * x2189
    x2215 = -x2189 * x8
    x2216 = x142 * x2187 + x2215
    x2217 = x4 * (x2213 - x2214 + x2216)
    x2218 = -x2213
    x2219 = x2214 + x2218
    x2220 = x2216 * x5 - x2219 * x6
    x2221 = x2219 * x5
    x2222 = x142 * x2195
    x2223 = x2205 * x8
    x2224 = -x2223
    x2225 = x2222 + x2224
    x2226 = x2225 * x6
    x2227 = x2221 - x2226
    x2228 = x4 * (x2219 - x2222 + x2223)
    x2229 = -x2211 * x8
    x2230 = x142 * x2205 + x2229
    x2231 = x10 * x1818
    x2232 = x1029 * x1814
    x2233 = -x10 * x1814 + x1029 * x1822 + x1756 + x1880
    x2234 = x4 * (x1775 + x1894 + x2231 - x2232 + x2233)
    x2235 = x1740 + x1889 - x2231 + x2232
    x2236 = x2233 * x5 - x2235 * x6
    x2237 = x2235 * x5
    x2238 = x1029 * x1818
    x2239 = x10 * x1830
    x2240 = x1761 + x1884 + x2238 - x2239
    x2241 = x2240 * x6
    x2242 = x2237 - x2241
    x2243 = x4 * (x1778 + x1897 + x2235 - x2238 + x2239)
    x2244 = -x10 * x1839 + x1029 * x1830 + x1776 + x1899
    x2245 = x142 * x2219
    x2246 = x2188 - x2219 * x8
    x2247 = x142 * x2216 + x2246
    x2248 = x2225 * x8
    x2249 = x2212 + x2248
    x2250 = x4 * (-x2245 + x2247 + x2249)
    x2251 = x2199 - x2248
    x2252 = x2245 + x2251
    x2253 = x2210 - x2230 * x8
    x2254 = x142 * x2225 + x2253
    x2255 = x2240 * x8
    x2256 = x142 * x2235
    x2257 = -x2235 * x8
    x2258 = x142 * x2233 + x2257
    x2259 = x4 * (x2255 - x2256 + x2258)
    x2260 = -x2255
    x2261 = x2256 + x2260
    x2262 = -x2244 * x8
    x2263 = x142 * x2240 + x2262
    x2264 = x10 * x1885
    x2265 = x1029 * x1890
    x2266 = 2.0 * x1309
    x2267 = 2.0 * x1834
    x2268 = -x10 * x1890 + x1029 * x1881 + 2.0 * x1298 + 2.0 * x1824
    x2269 = x4 * (x2264 - x2265 - x2266 - x2267 + x2268)
    x2270 = -x2264 + x2265 + x2266 + x2267
    x2271 = -x10 * x1900 + x1029 * x1885 + 2.0 * x1324 + 2.0 * x1838
    x2272 = 2.0 * x2217 - x2252 * x8
    x2273 = x142 * x2247 + x2272
    x2274 = 2.0 * x2228 - x2254 * x8
    x2275 = x142 * x2252 + x2274
    x2276 = x2234 - x2261 * x8
    x2277 = x142 * x2258 + x2276
    x2278 = x2243 - x2263 * x8
    x2279 = x142 * x2261 + x2278
    x2280 = -x2270 * x8
    x2281 = x142 * x2268 + x2280
    x2282 = -x2271 * x8
    x2283 = x142 * x2270 + x2282
    x2284 = 3.0 * x1895
    x2285 = -x10 * x1936 + x1029 * x1934 + 2.0 * x1390 + x2284
    x2286 = 3.0 * x1898
    x2287 = -x10 * x1937 + x1029 * x1936 + 2.0 * x1400 + x2286
    x2288 = x1949 * x8
    x2289 = x1943 * x703
    x2290 = 3.0 * x1407
    x2291 = 3.0 * x1423 + x1941 * x703 - x1943 * x8
    x2292 = -x2288 + x2289 + x2290
    x2293 = x2291 * x5 - x2292 * x6
    x2294 = x2292 * x5
    x2295 = x1949 * x703
    x2296 = x1959 * x8
    x2297 = 3.0 * x1428
    x2298 = x2295 - x2296 + x2297
    x2299 = x2298 * x6
    x2300 = x2294 - x2299
    x2301 = x1976 * x8
    x2302 = x1971 * x703
    x2303 = 3.0 * x1468
    x2304 = 3.0 * x1458 + x1942 + x1969 * x703 - x1971 * x8
    x2305 = x1953 - x2301 + x2302 + x2303
    x2306 = x1992 * x8
    x2307 = x1986 * x703
    x2308 = 3.0 * x1495
    x2309 = 3.0 * x1485 + x1984 * x703 - x1986 * x8
    x2310 = -x2306 + x2307 + x2308
    x2311 = x2037 * x8
    x2312 = x2032 * x703
    x2313 = 2.0 * x1584
    x2314 = 2.0 * x1599 + x2030 * x703 - x2032 * x8
    x2315 = -x2311 + x2312 + x2313
    x2316 = x2314 * x5 - x2315 * x6
    x2317 = x2315 * x5
    x2318 = x2037 * x703
    x2319 = x2046 * x8
    x2320 = 2.0 * x1604
    x2321 = x2318 - x2319 + x2320
    x2322 = x2321 * x6
    x2323 = x2317 - x2322
    x2324 = x2063 * x8
    x2325 = x2058 * x703
    x2326 = x2031 + x2056 * x703 - x2058 * x8 + x2086
    x2327 = x2041 + x2084 - x2324 + x2325
    x2328 = x2077 * x8
    x2329 = x2072 * x703
    x2330 = 2.0 * x1664
    x2331 = 2.0 * x1655 + x2070 * x703 - x2072 * x8
    x2332 = -x2328 + x2329 + x2330
    x2333 = x2121 * x8
    x2334 = x2117 * x703
    x2335 = x1756 + x2115 * x703 - x2117 * x8
    x2336 = x1740 - x2333 + x2334
    x2337 = x2335 * x5 - x2336 * x6
    x2338 = x2336 * x5
    x2339 = x2121 * x703
    x2340 = x2129 * x8
    x2341 = x1761 + x2339 - x2340
    x2342 = x2341 * x6
    x2343 = x2338 - x2342
    x2344 = x2144 * x8
    x2345 = x2140 * x703
    x2346 = x1794 + x2116 + x2138 * x703 - x2140 * x8
    x2347 = x1805 + x2125 - x2344 + x2345
    x2348 = x2156 * x8
    x2349 = x2152 * x703
    x2350 = x1824 + x2150 * x703 - x2152 * x8
    x2351 = x1834 - x2348 + x2349
    x2352 = x2189 * x703
    x2353 = x2187 * x703 + x2215
    x2354 = x2218 + x2352
    x2355 = x2353 * x5 - x2354 * x6
    x2356 = x2354 * x5
    x2357 = x2195 * x703
    x2358 = x2224 + x2357
    x2359 = x2358 * x6
    x2360 = x2356 - x2359
    x2361 = x2219 * x703
    x2362 = x2216 * x703 + x2246
    x2363 = x2251 + x2361
    x2364 = x2235 * x703
    x2365 = x2233 * x703 + x2257
    x2366 = x2260 + x2364
    x2367 = x10 * x2195
    x2368 = x1029 * x2189
    x2369 = 3.0 * x1740
    x2370 = -x10 * x2189 + x1029 * x2187 + 3.0 * x1756
    x2371 = x4 * (x2367 - x2368 - x2369 + x2370)
    x2372 = -x2367 + x2368 + x2369
    x2373 = x2370 * x5 - x2372 * x6
    x2374 = x2372 * x5
    x2375 = x1029 * x2195
    x2376 = x10 * x2205
    x2377 = 3.0 * x1761
    x2378 = x2375 - x2376 + x2377
    x2379 = x2378 * x6
    x2380 = x2374 - x2379
    x2381 = x4 * (x2372 - x2375 + x2376 - x2377)
    x2382 = -x10 * x2211 + x1029 * x2205 + 3.0 * x1776
    x2383 = x2378 * x8
    x2384 = x142 * x2372
    x2385 = x142 * x2370 - x2372 * x8
    x2386 = x4 * (x2383 - x2384 + x2385)
    x2387 = -x2383 + x2384
    x2388 = x142 * x2378 - x2382 * x8
    x2389 = x10 * x2240
    x2390 = x1029 * x2235
    x2391 = 3.0 * x1834
    x2392 = -x10 * x2235 + x1029 * x2233 + 3.0 * x1824 + x2188
    x2393 = x4 * (x2212 + x2389 - x2390 - x2391 + x2392)
    x2394 = x2199 - x2389 + x2390 + x2391
    x2395 = -x10 * x2244 + x1029 * x2240 + 3.0 * x1838 + x2210
    x2396 = x142 * x2385 + x2371 - x2387 * x8
    x2397 = x142 * x2387 + x2381 - x2388 * x8
    x2398 = x142 * x2392 - x2394 * x8
    x2399 = x142 * x2394 - x2395 * x8
    x2400 = -x10 * x2270 + x1029 * x2268 + 2.0 * x2234 + x2284
    x2401 = -x10 * x2271 + x1029 * x2270 + 2.0 * x2243 + x2286

    # 150 item(s)
    return numpy.array(
        [
            x3
            * (
                -x114 * x6
                + x3 * x84
                + x83 * (x116 - x117 - x121 + x123 - x77)
                + x99 * (x57 - x58 + x74 - x78)
            )
            - x6
            * (
                x114 * x3
                - x6
                * (
                    x108 * x3
                    + x4 * (x124 + x73 - x89)
                    - x6
                    * (
                        x102 * x3
                        - x6
                        * (
                            x5 * x97
                            - x6 * (x125 + x5 * x95 - x6 * (-x126 * x6 + x5 * x92))
                            + x99 * (x65 + x93 - x94)
                        )
                        + x83 * (x127 + x68 - x91 + x96)
                    )
                    + x83 * (x115 + x124 - x128)
                )
                + x83 * (-x106 + x129 - x130 - x133 + x134)
                + x99 * (x103 - x107 + x79 - x88)
            )
            + x83 * (x109 - x113 + x84 - x86 - x87)
            + x83
            * (
                -x112 * x99
                + x123 * x3
                - x134 * x3
                - x134 * x6
                + x6 * (x106 - x129 + x130 + x133)
                + x82 * x99
                + x99
                * (
                    -x120 * x6
                    + x122 * x3
                    - x137
                    - x138
                    + x139
                    + x36
                    + x4 * (-x136 + x14 + x3 * x31 + x30)
                    - x49
                )
                - x99
                * (
                    -x132 * x3
                    + x137
                    + x138
                    - x139
                    - x4 * (x135 - x21 * x3 + x23 + x42)
                    + x49
                    + x6 * (x131 + x67)
                    - x70
                )
            ),
            x3
            * (
                x198 * x3
                - x224 * x6
                + x99 * (x176 - x177 + x191 - x193)
                + x99 * (-x192 + x226 - x230 - x231 + x233)
            )
            - x6
            * (
                x224 * x3
                - x6
                * (
                    x219 * x3
                    + x4 * (x190 - x204 + x235)
                    - x6
                    * (
                        x215 * x3
                        - x6 * (x212 * x5 + x236 - x6 * (x210 * x5 - x238 * x6))
                        + x99 * (x187 - x206 + x211)
                    )
                    + x99 * (x225 + x235 - x239)
                )
                + x99 * (x194 - x203 + x216 - x218)
                + x99 * (-x217 + x240 - x243 - x244 + x245)
            )
            + x83 * (x198 - x201 - x202 + x220 + x248)
            + x99
            * (
                x197
                + x233 * x3
                - x245 * x3
                - x245 * x6
                + x248
                + x4 * (x158 + x171 - x229 * x6 + x232 * x3 + x246 - x247)
                - x4 * (x170 + x199 - x242 * x3 - x246 + x247 + x6 * (x186 + x241))
                + x6 * (x217 - x240 + x243 + x244)
            ),
            x3
            * (
                x3 * x307
                - x333 * x6
                + x99 * (x285 - x286 + x300 - x302)
                + x99 * (-x301 + x335 - x339 - x340 + x342)
            )
            - x6
            * (
                x3 * x333
                - x6
                * (
                    x3 * x328
                    + x4 * (x299 - x313 + x344)
                    - x6
                    * (
                        x3 * x324
                        - x6 * (x321 * x5 + x345 - x6 * (x319 * x5 - x347 * x6))
                        + x99 * (x296 - x315 + x320)
                    )
                    + x99 * (x334 + x344 - x348)
                )
                + x99 * (x303 - x312 + x325 - x327)
                + x99 * (-x326 + x349 - x352 - x353 + x354)
            )
            + x83 * (x307 - x310 - x311 + x329 + x357)
            + x99
            * (
                x3 * x342
                - x3 * x354
                + x306
                - x354 * x6
                + x357
                + x4 * (x267 + x280 + x3 * x341 - x338 * x6 + x355 - x356)
                - x4 * (x279 - x3 * x351 + x308 - x355 + x356 + x6 * (x295 + x350))
                + x6 * (x326 - x349 + x352 + x353)
            ),
            x3
            * (
                x3 * x413
                + x4 * (x376 - x398 + x399 + x403)
                - x422 * x6
                + x99 * (x403 + x407 - x408 + x411)
            )
            + x4
            * (
                x3 * x376
                - x3 * x400
                - x400 * x6
                - 2.0 * x401
                + 2.0 * x402
                + x6 * (x380 + x387 - x395)
            )
            - x6
            * (
                x3 * x422
                + x4 * (-x387 + x395 + x400 + x423)
                - x6
                * (
                    x3 * x420
                    + x4 * (x386 - x388 + x393)
                    + x4 * (x393 + x410 - x417)
                    - x6 * (x3 * x418 + x425 - x6 * (x392 * x5 - x427 * x6))
                )
                + x99 * (x412 - x416 + x419 + x423)
            )
            + x83 * (-x401 + x413 - x414 - x415 + x421),
            x3
            * (
                x3 * x480
                + x4 * (x445 - x465 + x466 + x470)
                - x489 * x6
                + x99 * (x470 + x474 - x475 + x478)
            )
            + x4
            * (
                x3 * x445
                - x3 * x467
                - x467 * x6
                - 2.0 * x468
                + 2.0 * x469
                + x6 * (x448 + x455 - x463)
            )
            - x6
            * (
                x3 * x489
                + x4 * (-x455 + x463 + x467 + x490)
                - x6
                * (
                    x3 * x487
                    + x4 * (x454 - x456 + x461)
                    + x4 * (x461 + x477 - x484)
                    - x6 * (x3 * x485 + x491 - x6 * (x460 * x5 - x493 * x6))
                )
                + x99 * (x479 - x483 + x486 + x490)
            )
            + x83 * (-x468 + x480 - x481 - x482 + x488),
            x3
            * (
                x3 * x549
                + x4 * (x512 - x534 + x535 + x539)
                - x558 * x6
                + x99 * (x539 + x543 - x544 + x547)
            )
            + x4
            * (
                x3 * x512
                - x3 * x536
                - x536 * x6
                - 2.0 * x537
                + 2.0 * x538
                + x6 * (x516 + x523 - x531)
            )
            - x6
            * (
                x3 * x558
                + x4 * (-x523 + x531 + x536 + x559)
                - x6
                * (
                    x3 * x556
                    + x4 * (x522 - x524 + x529)
                    + x4 * (x529 + x546 - x553)
                    - x6 * (x3 * x554 + x561 - x6 * (x5 * x528 - x563 * x6))
                )
                + x99 * (x548 - x552 + x555 + x559)
            )
            + x83 * (-x537 + x549 - x550 - x551 + x557),
            x3 * (x3 * x582 - x595 * x6 + x99 * (x573 - x574 + x580))
            - x6
            * (
                x3 * x595
                - x6 * (x3 * x593 + x597 - x6 * (x3 * x591 - x599 * x6))
                + x99 * (x581 - x586 + x592)
            )
            + x83 * (x582 - x585 + x594 + x600),
            x3 * (x3 * x617 - x6 * x629 + x99 * (x609 - x610 + x615))
            - x6
            * (
                x3 * x629
                - x6 * (x3 * x627 - x6 * (x3 * x625 - x6 * x633) + x631)
                + x99 * (x616 - x621 + x626)
            )
            + x83 * (x617 - x620 + x628 + x634),
            x3 * (x3 * x650 - x6 * x661 + x99 * (x642 - x643 + x648))
            - x6
            * (
                x3 * x661
                - x6 * (x3 * x659 - x6 * (x3 * x657 - x6 * x664) + x662)
                + x99 * (x649 - x653 + x658)
            )
            + x83 * (x650 - x652 + x660 + x665),
            x3 * (x3 * x684 - x6 * x697 + x99 * (x675 - x676 + x682))
            - x6
            * (
                x3 * x697
                - x6 * (x3 * x695 - x6 * (x3 * x693 - x6 * x701) + x699)
                + x99 * (x683 - x688 + x694)
            )
            + x83 * (x684 - x687 + x696 + x702),
            x3
            * (
                x3 * x746
                + x4 * (-x721 + x728 + x740)
                - x6 * x767
                + x83 * (x740 - x768 + x769)
            )
            - x6
            * (
                x3 * x767
                + x4 * (x742 - x748 + x770)
                - x6
                * (
                    x3 * x761
                    - x6
                    * (
                        x5 * x757
                        - x6 * (x5 * x755 - x6 * (x5 * x753 - x6 * x772) + x771)
                        + x99 * (x735 - x751 + x754)
                    )
                    + x83 * (x737 - x750 + x756 + x773)
                )
                + x83 * (x770 - x774 + x775)
            )
            + x83
            * (
                x3 * x769
                - x3 * x775
                - x6 * x775
                + x6 * (x760 + x774)
                + x745
                - x765
                - x99 * (-x3 * x717 + x719 + x764 + x776)
                + x99 * (x3 * x723 + x725 + x744 - x776)
            )
            + x99 * (x746 - x747 + x762 - x766),
            x3
            * (
                x3 * x803
                + x4 * (-x785 + x791 + x799)
                - x6 * x818
                + x99 * (x799 - x819 + x820)
            )
            - x6
            * (
                x3 * x818
                + x4 * (x801 - x805 + x821)
                - x6
                * (
                    x3 * x814
                    - x6 * (x5 * x811 - x6 * (x5 * x809 - x6 * x823) + x822)
                    + x99 * (x796 - x807 + x810)
                )
                + x99 * (x821 - x824 + x825)
            )
            + x99 * (x803 - x804 + x815 - x817)
            + x99
            * (
                x3 * x820
                - x3 * x825
                - x4 * (-x3 * x781 + x783 + x795 + x826)
                + x4 * (x3 * x786 + x782 + x787 - x826)
                - x6 * x825
                + x6 * (x813 + x824)
                + x802
                - x816
            ),
            x3
            * (
                x3 * x854
                + x4 * (-x835 + x841 + x850)
                - x6 * x869
                + x99 * (x850 - x870 + x871)
            )
            - x6
            * (
                x3 * x869
                + x4 * (x852 - x856 + x873)
                - x6
                * (
                    x3 * x865
                    - x6 * (x5 * x862 - x6 * (x5 * x860 - x6 * x875) + x874)
                    + x99 * (x846 - x858 + x861)
                )
                + x99 * (x873 - x876 + x877)
            )
            + x99 * (x854 - x855 + x866 - x868)
            + x99
            * (
                x3 * x871
                - x3 * x877
                - x4 * (-x3 * x831 + x833 + x845 + x878)
                + x4 * (x3 * x836 + x832 + x837 - x878)
                - x6 * x877
                + x6 * (x864 + x876)
                + x853
                - x867
            ),
            x3
            * (
                x3 * x901
                + x4 * (x884 - x894 + x895)
                + x4 * (x895 - x898 + x899)
                - x6 * x906
            )
            + x4 * (x3 * x884 - x3 * x897 - x6 * x897 + x6 * (x887 + x891) + x881 + x893)
            - x6
            * (
                x3 * x906
                + x4 * (-x887 + x890 + x897)
                + x4 * (x890 + x900 - x903)
                - x6 * (x3 * x904 - x6 * (x5 * x889 - x6 * x908) + x907)
            )
            + x99 * (x893 + x901 - x902 + x905),
            x3
            * (
                x3 * x931
                + x4 * (x914 - x924 + x925)
                + x4 * (x925 - x928 + x929)
                - x6 * x936
            )
            + x4 * (x3 * x914 - x3 * x927 - x6 * x927 + x6 * (x917 + x921) + x911 + x923)
            - x6
            * (
                x3 * x936
                + x4 * (-x917 + x920 + x927)
                + x4 * (x920 + x930 - x933)
                - x6 * (x3 * x934 - x6 * (x5 * x919 - x6 * x938) + x937)
            )
            + x99 * (x923 + x931 - x932 + x935),
            x3
            * (
                x3 * x961
                + x4 * (x944 - x954 + x955)
                + x4 * (x955 - x958 + x959)
                - x6 * x966
            )
            + x4 * (x3 * x944 - x3 * x957 - x6 * x957 + x6 * (x947 + x951) + x941 + x953)
            - x6
            * (
                x3 * x966
                + x4 * (-x947 + x950 + x957)
                + x4 * (x950 + x960 - x963)
                - x6 * (x3 * x964 - x6 * (x5 * x949 - x6 * x968) + x967)
            )
            + x99 * (x953 + x961 - x962 + x965),
            x3 * (x3 * x975 - x6 * x982 + x973)
            - x6 * (x3 * x982 - x6 * (x3 * x980 - x6 * x984) + x983)
            + x99 * (x975 - x976 + x981),
            x3 * (x3 * x991 - x6 * x998 + x989)
            - x6 * (x3 * x998 - x6 * (-x1000 * x6 + x3 * x996) + x999)
            + x99 * (x991 - x992 + x997),
            x3 * (x1004 + x1006 * x3 - x1012 * x6)
            - x6 * (x1012 * x3 + x1013 - x6 * (x1010 * x3 - x1014 * x6))
            + x99 * (x1006 - x1007 + x1011),
            x3 * (x1018 + x1020 * x3 - x1026 * x6)
            - x6 * (x1026 * x3 + x1027 - x6 * (x1024 * x3 - x1028 * x6))
            + x99 * (x1020 - x1021 + x1025),
            x3
            * (
                x1072 * x3
                - x1093 * x6
                + x4 * (-x1047 + x1054 + x1066)
                + x83 * (x1066 - x1094 + x1095)
            )
            - x6
            * (
                x1093 * x3
                + x4 * (x1068 - x1074 + x1096)
                - x6
                * (
                    x1087 * x3
                    - x6
                    * (
                        x1083 * x5
                        - x6 * (x1081 * x5 + x1097 - x6 * (x1079 * x5 - x1098 * x6))
                        + x99 * (x1061 - x1077 + x1080)
                    )
                    + x83 * (x1063 - x1076 + x1082 + x1099)
                )
                + x83 * (x1096 - x1100 + x1101)
            )
            + x83
            * (
                x1071
                - x1091
                + x1095 * x3
                - x1101 * x3
                - x1101 * x6
                + x6 * (x1086 + x1100)
                - x99 * (-x1043 * x3 + x1045 + x1090 + x1102)
                + x99 * (x1049 * x3 + x1051 + x1070 - x1102)
            )
            + x99 * (x1072 - x1073 + x1088 - x1092),
            x3
            * (
                x1137 * x3
                - x1154 * x6
                + x4 * (-x1115 + x1122 + x1133)
                + x99 * (x1133 - x1155 + x1156)
            )
            - x6
            * (
                x1154 * x3
                + x4 * (x1135 - x1139 + x1158)
                - x6
                * (
                    x1150 * x3
                    - x6 * (x1147 * x5 + x1159 - x6 * (x1145 * x5 - x1161 * x6))
                    + x99 * (x1129 - x1141 + x1146)
                )
                + x99 * (x1158 - x1162 + x1163)
            )
            + x99 * (x1137 - x1138 + x1151 - x1153)
            + x99
            * (
                x1136
                - x1152
                + x1156 * x3
                - x1163 * x3
                - x1163 * x6
                + x4 * (x1112 + x1117 * x3 + x1118 - x1164)
                - x4 * (-x1111 * x3 + x1113 + x1128 + x1164)
                + x6 * (x1149 + x1162)
            ),
            x3
            * (
                x1192 * x3
                - x1207 * x6
                + x4 * (-x1173 + x1179 + x1188)
                + x99 * (x1188 - x1208 + x1209)
            )
            - x6
            * (
                x1207 * x3
                + x4 * (x1190 - x1194 + x1211)
                - x6
                * (
                    x1203 * x3
                    - x6 * (x1200 * x5 + x1212 - x6 * (x1198 * x5 - x1213 * x6))
                    + x99 * (x1184 - x1196 + x1199)
                )
                + x99 * (x1211 - x1214 + x1215)
            )
            + x99 * (x1192 - x1193 + x1204 - x1206)
            + x99
            * (
                x1191
                - x1205
                + x1209 * x3
                - x1215 * x3
                - x1215 * x6
                + x4 * (x1170 + x1174 * x3 + x1175 - x1216)
                - x4 * (-x1169 * x3 + x1171 + x1183 + x1216)
                + x6 * (x1202 + x1214)
            ),
            x3
            * (
                x1248 * x3
                - x1253 * x6
                + x4 * (x1226 - x1241 + x1242)
                + x4 * (x1242 - x1245 + x1246)
            )
            + x4
            * (
                x1222
                + x1226 * x3
                + x1240
                - x1244 * x3
                - x1244 * x6
                + x6 * (x1231 + x1237)
            )
            - x6
            * (
                x1253 * x3
                + x4 * (-x1231 + x1236 + x1244)
                + x4 * (x1236 + x1247 - x1250)
                - x6 * (x1251 * x3 + x1255 - x6 * (x1235 * x5 - x1257 * x6))
            )
            + x99 * (x1240 + x1248 - x1249 + x1252),
            x3
            * (
                x1287 * x3
                - x1292 * x6
                + x4 * (x1266 - x1280 + x1281)
                + x4 * (x1281 - x1284 + x1285)
            )
            + x4
            * (
                x1262
                + x1266 * x3
                + x1279
                - x1283 * x3
                - x1283 * x6
                + x6 * (x1271 + x1277)
            )
            - x6
            * (
                x1292 * x3
                + x4 * (-x1271 + x1276 + x1283)
                + x4 * (x1276 + x1286 - x1289)
                - x6 * (x1290 * x3 + x1293 - x6 * (x1275 * x5 - x1295 * x6))
            )
            + x99 * (x1279 + x1287 - x1288 + x1291),
            x3
            * (
                x1318 * x3
                - x1323 * x6
                + x4 * (x1301 - x1311 + x1312)
                + x4 * (x1312 - x1315 + x1316)
            )
            + x4
            * (
                x1298
                + x1301 * x3
                + x1310
                - x1314 * x3
                - x1314 * x6
                + x6 * (x1304 + x1308)
            )
            - x6
            * (
                x1323 * x3
                + x4 * (-x1304 + x1307 + x1314)
                + x4 * (x1307 + x1317 - x1320)
                - x6 * (x1321 * x3 + x1324 - x6 * (x1306 * x5 - x1325 * x6))
            )
            + x99 * (x1310 + x1318 - x1319 + x1322),
            x3 * (x1332 + x1335 * x3 - x1343 * x6)
            - x6 * (x1343 * x3 + x1345 - x6 * (x1341 * x3 - x1347 * x6))
            + x99 * (x1335 - x1336 + x1342),
            x3 * (x1353 + x1356 * x3 - x1363 * x6)
            - x6 * (x1363 * x3 + x1365 - x6 * (x1361 * x3 - x1367 * x6))
            + x99 * (x1356 - x1357 + x1362),
            x3 * (x1372 + x1375 * x3 - x1382 * x6)
            - x6 * (x1382 * x3 + x1383 - x6 * (x1380 * x3 - x1385 * x6))
            + x99 * (x1375 - x1376 + x1381),
            x3 * (x1390 + x1392 * x3 - x1399 * x6)
            - x6 * (x1399 * x3 + x1400 - x6 * (x1397 * x3 - x1401 * x6))
            + x99 * (x1392 - x1393 + x1398),
            x3 * (x1427 * x3 - x1441 * x6 + x83 * (-x1412 + x1419 + x1425 + x1442))
            + x4 * (-x1421 + x1427 + x1440)
            - x6
            * (
                x1441 * x3
                - x6
                * (
                    x1437 * x5
                    - x6 * (x1435 * x5 + x1443 - x6 * (x1433 * x5 - x1444 * x6))
                    + x99 * (x1418 - x1430 + x1434)
                )
                + x83 * (x1420 - x1429 + x1436 + x1445)
            )
            + x83 * (-x1420 * x3 + x1425 * x3 + x1426 + x1440),
            x3 * (x1460 * x3 - x1470 * x6 + x99 * (-x1449 + x1453 + x1457))
            + x4 * (-x1455 + x1460 + x1469)
            - x6
            * (
                x1470 * x3
                - x6 * (x1466 * x5 + x1471 - x6 * (x1464 * x5 - x1472 * x6))
                + x99 * (x1454 - x1461 + x1465)
            )
            + x99 * (-x1454 * x3 + x1457 * x3 + x1459 + x1469),
            x3 * (x1487 * x3 - x1498 * x6 + x99 * (-x1476 + x1480 + x1484))
            + x4 * (-x1482 + x1487 + x1497)
            - x6
            * (
                x1498 * x3
                - x6 * (x1493 * x5 + x1499 - x6 * (x1491 * x5 - x1500 * x6))
                + x99 * (x1481 - x1488 + x1492)
            )
            + x99 * (-x1481 * x3 + x1484 * x3 + x1486 + x1497),
            x3 * (x1514 * x3 + x1516 - x1517 * x6)
            + x4 * (x1507 - x1513 + x1514)
            + x4 * (x1502 * x3 + x1507 - x1511 * x3 + x1512)
            - x6 * (x1517 * x3 + x1519 - x6 * (x1506 * x5 - x1521 * x6)),
            x3 * (x1532 * x3 + x1533 - x1534 * x6)
            + x4 * (x1526 - x1531 + x1532)
            + x4 * (x1522 * x3 + x1526 - x1529 * x3 + x1530)
            - x6 * (x1534 * x3 + x1535 - x6 * (x1525 * x5 - x1536 * x6)),
            x3 * (x1547 * x3 + x1548 - x1549 * x6)
            + x4 * (x1541 - x1546 + x1547)
            + x4 * (x1537 * x3 + x1541 - x1544 * x3 + x1545)
            - x6 * (x1549 * x3 + x1550 - x6 * (x1540 * x5 - x1551 * x6)),
            x1556 + x3 * (x1555 * x3 - x1557 * x6) - x6 * (x1557 * x3 - x1558 * x6),
            x1565 + x3 * (x1564 * x3 - x1566 * x6) - x6 * (x1566 * x3 - x1568 * x6),
            x1572 + x3 * (x1571 * x3 - x1573 * x6) - x6 * (x1573 * x3 - x1574 * x6),
            x1578 + x3 * (x1577 * x3 - x1579 * x6) - x6 * (x1579 * x3 - x1580 * x6),
            x3 * (x1603 * x3 - x1616 * x6 + x83 * (-x1589 + x1595 + x1601 + x1617))
            + x4 * (-x1597 + x1603 + x1615)
            - x6
            * (
                x1616 * x3
                - x6
                * (
                    x1612 * x5
                    - x6 * (x1610 * x5 + x1618 - x6 * (x1608 * x5 - x1619 * x6))
                    + x99 * (x1594 - x1606 + x1609)
                )
                + x83 * (x1596 - x1605 + x1611 + x1620)
            )
            + x83 * (-x1596 * x3 + x1601 * x3 + x1602 + x1615),
            x3 * (x1633 * x3 - x1642 * x6 + x99 * (-x1623 + x1626 + x1630))
            + x4 * (-x1628 + x1633 + x1641)
            - x6
            * (
                x1642 * x3
                - x6 * (x1638 * x5 + x1643 - x6 * (x1636 * x5 - x1644 * x6))
                + x99 * (x1627 - x1634 + x1637)
            )
            + x99 * (-x1627 * x3 + x1630 * x3 + x1632 + x1641),
            x3 * (x1657 * x3 - x1667 * x6 + x99 * (-x1647 + x1650 + x1654))
            + x4 * (-x1652 + x1657 + x1666)
            - x6
            * (
                x1667 * x3
                - x6 * (x1662 * x5 + x1668 - x6 * (x1660 * x5 - x1669 * x6))
                + x99 * (x1651 - x1658 + x1661)
            )
            + x99 * (-x1651 * x3 + x1654 * x3 + x1656 + x1666),
            x3 * (x1678 * x3 + x1679 - x1680 * x6)
            + x4 * (x1673 - x1677 + x1678)
            + x4 * (x1670 * x3 + x1673 - x1675 * x3 + x1676)
            - x6 * (x1680 * x3 + x1681 - x6 * (x1672 * x5 - x1682 * x6)),
            x3 * (x1691 * x3 + x1692 - x1693 * x6)
            + x4 * (x1686 - x1690 + x1691)
            + x4 * (x1683 * x3 + x1686 - x1688 * x3 + x1689)
            - x6 * (x1693 * x3 + x1694 - x6 * (x1685 * x5 - x1695 * x6)),
            x3 * (x1704 * x3 + x1705 - x1706 * x6)
            + x4 * (x1699 - x1703 + x1704)
            + x4 * (x1696 * x3 + x1699 - x1701 * x3 + x1702)
            - x6 * (x1706 * x3 + x1707 - x6 * (x1698 * x5 - x1708 * x6)),
            x1713 + x3 * (x1712 * x3 - x1714 * x6) - x6 * (x1714 * x3 - x1715 * x6),
            x1720 + x3 * (x1719 * x3 - x1721 * x6) - x6 * (x1721 * x3 - x1722 * x6),
            x1726 + x3 * (x1725 * x3 - x1727 * x6) - x6 * (x1727 * x3 - x1728 * x6),
            x1732 + x3 * (x1731 * x3 - x1733 * x6) - x6 * (x1733 * x3 - x1734 * x6),
            x3 * (x1760 * x3 - x1774 * x6 + x83 * (-x1745 + x1752 + x1758 + x1775))
            + x4 * (-x1754 + x1760 + x1773)
            - x6
            * (
                x1774 * x3
                - x6
                * (
                    x1770 * x5
                    - x6 * (x1768 * x5 + x1776 - x6 * (x1766 * x5 - x1777 * x6))
                    + x99 * (x1751 - x1763 + x1767)
                )
                + x83 * (x1753 - x1762 + x1769 + x1778)
            )
            + x83 * (-x1753 * x3 + x1758 * x3 + x1759 + x1773),
            x3 * (x1796 * x3 - x1808 * x6 + x99 * (-x1783 + x1788 + x1793))
            + x4 * (-x1790 + x1796 + x1807)
            - x6
            * (
                x1808 * x3
                - x6 * (x1803 * x5 + x1809 - x6 * (x1801 * x5 - x1811 * x6))
                + x99 * (x1789 - x1797 + x1802)
            )
            + x99 * (-x1789 * x3 + x1793 * x3 + x1795 + x1807),
            x3 * (x1826 * x3 - x1837 * x6 + x99 * (-x1815 + x1819 + x1823))
            + x4 * (-x1821 + x1826 + x1836)
            - x6
            * (
                x1837 * x3
                - x6 * (x1832 * x5 + x1838 - x6 * (x1830 * x5 - x1839 * x6))
                + x99 * (x1820 - x1827 + x1831)
            )
            + x99 * (-x1820 * x3 + x1823 * x3 + x1825 + x1836),
            x3 * (x1853 * x3 + x1855 - x1856 * x6)
            + x4 * (x1846 - x1852 + x1853)
            + x4 * (x1841 * x3 + x1846 - x1850 * x3 + x1851)
            - x6 * (x1856 * x3 + x1858 - x6 * (x1845 * x5 - x1860 * x6)),
            x3 * (x1874 * x3 + x1875 - x1876 * x6)
            + x4 * (x1867 - x1873 + x1874)
            + x4 * (x1862 * x3 + x1867 - x1871 * x3 + x1872)
            - x6 * (x1876 * x3 + x1877 - x6 * (x1866 * x5 - x1879 * x6)),
            x3 * (x1893 * x3 + x1895 - x1896 * x6)
            + x4 * (x1886 - x1892 + x1893)
            + x4 * (x1881 * x3 + x1886 - x1890 * x3 + x1891)
            - x6 * (x1896 * x3 + x1898 - x6 * (x1885 * x5 - x1900 * x6)),
            x1907 + x3 * (x1903 * x3 - x1909 * x6) - x6 * (x1909 * x3 - x1911 * x6),
            x1917 + x3 * (x1914 * x3 - x1919 * x6) - x6 * (x1919 * x3 - x1921 * x6),
            x1926 + x3 * (x1925 * x3 - x1928 * x6) - x6 * (x1928 * x3 - x1930 * x6),
            x1935 + x3 * (x1934 * x3 - x1936 * x6) - x6 * (x1936 * x3 - x1937 * x6),
            x3 * (x1952 * x5 - x1963 * x6 + x99 * (x1944 - x1945 + x1950))
            - x6
            * (
                x1963 * x5
                - x6 * (x1961 * x5 + x1964 - x6 * (x1959 * x5 - x1965 * x6))
                + x99 * (x1951 - x1955 + x1960)
            )
            + x83 * (x1952 - x1954 + x1962 + x1966),
            x3 * (x1970 + x1972 * x5 - x1978 * x6)
            - x6 * (x1978 * x5 + x1979 - x6 * (x1976 * x5 - x1980 * x6))
            + x99 * (x1972 - x1973 + x1977),
            x3 * (x1985 + x1987 * x5 - x1994 * x6)
            - x6 * (x1994 * x5 + x1995 - x6 * (x1992 * x5 - x1996 * x6))
            + x99 * (x1987 - x1988 + x1993),
            x2002 + x3 * (x2001 * x5 - x2003 * x6) - x6 * (x2003 * x5 - x2004 * x6),
            x2008 + x3 * (x2007 * x5 - x2009 * x6) - x6 * (x2009 * x5 - x2010 * x6),
            x2015 + x3 * (x2014 * x5 - x2016 * x6) - x6 * (x2016 * x5 - x2017 * x6),
            x2019 * x3 - x2021 * x6,
            x2022 * x3 - x2023 * x6,
            x2024 * x3 - x2025 * x6,
            x2026 * x3 - x2027 * x6,
            x3 * (x2040 * x5 - x2050 * x6 + x99 * (x2033 - x2034 + x2038))
            - x6
            * (
                x2050 * x5
                - x6 * (x2048 * x5 + x2051 - x6 * (x2046 * x5 - x2052 * x6))
                + x99 * (x2039 - x2043 + x2047)
            )
            + x83 * (x2040 - x2042 + x2049 + x2053),
            x3 * (x2057 + x2059 * x5 - x2065 * x6)
            - x6 * (x2065 * x5 + x2066 - x6 * (x2063 * x5 - x2067 * x6))
            + x99 * (x2059 - x2060 + x2064),
            x3 * (x2071 + x2073 * x5 - x2079 * x6)
            - x6 * (x2079 * x5 + x2080 - x6 * (x2077 * x5 - x2081 * x6))
            + x99 * (x2073 - x2074 + x2078),
            x2088 + x3 * (x2087 * x5 - x2089 * x6) - x6 * (x2089 * x5 - x2091 * x6),
            x2095 + x3 * (x2094 * x5 - x2096 * x6) - x6 * (x2096 * x5 - x2097 * x6),
            x2101 + x3 * (x2100 * x5 - x2102 * x6) - x6 * (x2102 * x5 - x2103 * x6),
            x2104 * x3 - x2105 * x6,
            x2107 * x3 - x2109 * x6,
            x2110 * x3 - x2111 * x6,
            x2112 * x3 - x2113 * x6,
            x3 * (x2124 * x5 - x2133 * x6 + x99 * (x2118 - x2119 + x2122))
            - x6
            * (
                x2133 * x5
                - x6 * (x2131 * x5 + x2134 - x6 * (x2129 * x5 - x2135 * x6))
                + x99 * (x2123 - x2127 + x2130)
            )
            + x83 * (x2124 - x2126 + x2132 + x2136),
            x3 * (x2139 + x2141 * x5 - x2146 * x6)
            - x6 * (x2146 * x5 + x2147 - x6 * (x2144 * x5 - x2148 * x6))
            + x99 * (x2141 - x2142 + x2145),
            x3 * (x2151 + x2153 * x5 - x2158 * x6)
            - x6 * (x2158 * x5 + x2159 - x6 * (x2156 * x5 - x2160 * x6))
            + x99 * (x2153 - x2154 + x2157),
            x2163 + x3 * (x2162 * x5 - x2164 * x6) - x6 * (x2164 * x5 - x2165 * x6),
            x2168 + x3 * (x2167 * x5 - x2169 * x6) - x6 * (x2169 * x5 - x2170 * x6),
            x2173 + x3 * (x2172 * x5 - x2174 * x6) - x6 * (x2174 * x5 - x2175 * x6),
            x2176 * x3 - x2177 * x6,
            x2178 * x3 - x2179 * x6,
            x2180 * x3 - x2181 * x6,
            x2182 * x3 - x2183 * x6,
            x3 * (x2198 * x5 - x2209 * x6 + x99 * (x2190 - x2191 + x2196))
            - x6
            * (
                x2209 * x5
                - x6 * (x2207 * x5 + x2210 - x6 * (x2205 * x5 - x2211 * x6))
                + x99 * (x2197 - x2201 + x2206)
            )
            + x83 * (x2198 - x2200 + x2208 + x2212),
            x3 * (x2217 + x2220 * x5 - x2227 * x6)
            - x6 * (x2227 * x5 + x2228 - x6 * (x2225 * x5 - x2230 * x6))
            + x99 * (x2220 - x2221 + x2226),
            x3 * (x2234 + x2236 * x5 - x2242 * x6)
            - x6 * (x2242 * x5 + x2243 - x6 * (x2240 * x5 - x2244 * x6))
            + x99 * (x2236 - x2237 + x2241),
            x2250 + x3 * (x2247 * x5 - x2252 * x6) - x6 * (x2252 * x5 - x2254 * x6),
            x2259 + x3 * (x2258 * x5 - x2261 * x6) - x6 * (x2261 * x5 - x2263 * x6),
            x2269 + x3 * (x2268 * x5 - x2270 * x6) - x6 * (x2270 * x5 - x2271 * x6),
            x2273 * x3 - x2275 * x6,
            x2277 * x3 - x2279 * x6,
            x2281 * x3 - x2283 * x6,
            x2285 * x3 - x2287 * x6,
            x5 * (x2293 * x5 - x2300 * x6 + x4 * (x2288 - x2289 - x2290 + x2291))
            - x6
            * (
                x2300 * x5
                + x4 * (x2292 - x2295 + x2296 - x2297)
                - x6 * (x2298 * x5 - x6 * (3.0 * x1443 + x1959 * x703 - x1965 * x8))
            )
            + x99 * (x2293 - x2294 + x2299),
            x4 * (x1966 + x2301 - x2302 - x2303 + x2304)
            + x5 * (x2304 * x5 - x2305 * x6)
            - x6 * (x2305 * x5 - x6 * (3.0 * x1471 + x1964 + x1976 * x703 - x1980 * x8)),
            x4 * (x2306 - x2307 - x2308 + x2309)
            + x5 * (x2309 * x5 - x2310 * x6)
            - x6 * (x2310 * x5 - x6 * (3.0 * x1499 + x1992 * x703 - x1996 * x8)),
            x5 * (2.0 * x1970 + x2001 * x703 - x2003 * x8 + x2018)
            - x6 * (2.0 * x1979 + x2003 * x703 - x2004 * x8 + x2020),
            x5 * (3.0 * x1533 + x1985 + x2007 * x703 - x2009 * x8)
            - x6 * (3.0 * x1535 + x1995 + x2009 * x703 - x2010 * x8),
            x5 * (3.0 * x1548 + x2014 * x703 - x2016 * x8)
            - x6 * (3.0 * x1550 + x2016 * x703 - x2017 * x8),
            3.0 * x1556 + 3.0 * x2002 + x2019 * x703 - x2021 * x8,
            3.0 * x1565 + 2.0 * x2008 + x2022 * x703 - x2023 * x8,
            3.0 * x1572 + x2015 + x2024 * x703 - x2025 * x8,
            3.0 * x1578 + x2026 * x703 - x2027 * x8,
            x5 * (x2316 * x5 - x2323 * x6 + x4 * (x2311 - x2312 - x2313 + x2314))
            - x6
            * (
                x2323 * x5
                + x4 * (x2315 - x2318 + x2319 - x2320)
                - x6 * (x2321 * x5 - x6 * (2.0 * x1618 + x2046 * x703 - x2052 * x8))
            )
            + x99 * (x2316 - x2317 + x2322),
            x4 * (x2053 + x2085 + x2324 - x2325 + x2326)
            + x5 * (x2326 * x5 - x2327 * x6)
            - x6 * (x2327 * x5 - x6 * (x2051 + x2063 * x703 - x2067 * x8 + x2090)),
            x4 * (x2328 - x2329 - x2330 + x2331)
            + x5 * (x2331 * x5 - x2332 * x6)
            - x6 * (x2332 * x5 - x6 * (2.0 * x1668 + x2077 * x703 - x2081 * x8)),
            x5 * (2.0 * x1679 + 2.0 * x2057 + x2087 * x703 - x2089 * x8)
            - x6 * (2.0 * x1681 + 2.0 * x2066 + x2089 * x703 - x2091 * x8),
            x5 * (x2071 + x2094 * x703 - x2096 * x8 + x2106)
            - x6 * (x2080 + x2096 * x703 - x2097 * x8 + x2108),
            x5 * (2.0 * x1705 + x2100 * x703 - x2102 * x8)
            - x6 * (2.0 * x1707 + x2102 * x703 - x2103 * x8),
            2.0 * x1713 + 3.0 * x2088 + x2104 * x703 - x2105 * x8,
            2.0 * x1720 + 2.0 * x2095 + x2107 * x703 - x2109 * x8,
            2.0 * x1726 + x2101 + x2110 * x703 - x2111 * x8,
            2.0 * x1732 + x2112 * x703 - x2113 * x8,
            x5 * (x2337 * x5 - x2343 * x6 + x4 * (x1775 + x2333 - x2334 + x2335))
            - x6
            * (
                x2343 * x5
                + x4 * (x1778 + x2336 - x2339 + x2340)
                - x6 * (x2341 * x5 - x6 * (x1776 + x2129 * x703 - x2135 * x8))
            )
            + x99 * (x2337 - x2338 + x2342),
            x4 * (x1806 + x2136 + x2344 - x2345 + x2346)
            + x5 * (x2346 * x5 - x2347 * x6)
            - x6 * (x2347 * x5 - x6 * (x1809 + x2134 + x2144 * x703 - x2148 * x8)),
            x4 * (x1835 + x2348 - x2349 + x2350)
            + x5 * (x2350 * x5 - x2351 * x6)
            - x6 * (x2351 * x5 - x6 * (x1838 + x2156 * x703 - x2160 * x8)),
            x5 * (x1855 + 2.0 * x2139 + x2162 * x703 - x2164 * x8)
            - x6 * (x1858 + 2.0 * x2147 + x2164 * x703 - x2165 * x8),
            x5 * (x1875 + x2151 + x2167 * x703 - x2169 * x8)
            - x6 * (x1877 + x2159 + x2169 * x703 - x2170 * x8),
            x5 * (x1895 + x2172 * x703 - x2174 * x8)
            - x6 * (x1898 + x2174 * x703 - x2175 * x8),
            x1907 + 3.0 * x2163 + x2176 * x703 - x2177 * x8,
            x1917 + 2.0 * x2168 + x2178 * x703 - x2179 * x8,
            x1926 + x2173 + x2180 * x703 - x2181 * x8,
            x1935 + x2182 * x703 - x2183 * x8,
            x5 * (x2355 * x5 - x2360 * x6 + x4 * (x2213 - x2352 + x2353))
            - x6
            * (
                x2360 * x5
                + x4 * (x2223 + x2354 - x2357)
                - x6 * (x2358 * x5 - x6 * (x2205 * x703 + x2229))
            )
            + x99 * (x2355 - x2356 + x2359),
            x4 * (x2249 - x2361 + x2362)
            + x5 * (x2362 * x5 - x2363 * x6)
            - x6 * (x2363 * x5 - x6 * (x2225 * x703 + x2253)),
            x4 * (x2255 - x2364 + x2365)
            + x5 * (x2365 * x5 - x2366 * x6)
            - x6 * (x2366 * x5 - x6 * (x2240 * x703 + x2262)),
            x5 * (x2247 * x703 + x2272) - x6 * (x2252 * x703 + x2274),
            x5 * (x2258 * x703 + x2276) - x6 * (x2261 * x703 + x2278),
            x5 * (x2268 * x703 + x2280) - x6 * (x2270 * x703 + x2282),
            3.0 * x2250 + x2273 * x703 - x2275 * x8,
            2.0 * x2259 + x2277 * x703 - x2279 * x8,
            x2269 + x2281 * x703 - x2283 * x8,
            x2285 * x703 - x2287 * x8,
            x5 * (x2371 + x2373 * x5 - x2380 * x6)
            - x6 * (x2380 * x5 + x2381 - x6 * (x2378 * x5 - x2382 * x6))
            + x99 * (x2373 - x2374 + x2379),
            x2386 + x5 * (x2385 * x5 - x2387 * x6) - x6 * (x2387 * x5 - x2388 * x6),
            x2393 + x5 * (x2392 * x5 - x2394 * x6) - x6 * (x2394 * x5 - x2395 * x6),
            x2396 * x5 - x2397 * x6,
            x2398 * x5 - x2399 * x6,
            x2400 * x5 - x2401 * x6,
            x142 * x2396 + 2.0 * x2386 - x2397 * x8,
            x142 * x2398 + x2393 - x2399 * x8,
            x142 * x2400 - x2401 * x8,
            -x10 * x2287 + x1029 * x2285 + 3.0 * x1935 + 3.0 * x2269,
        ]
    )


def coulomb3d_44(a, A, b, B, C):
    """Cartesian (gg) 1-electron Coulomb integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = (2.0 * a + 2.0 * b) ** (-1.0)
    x5 = -x2 - B[0]
    x6 = -x2 - C[0]
    x7 = -x1 * (a * A[1] + b * B[1])
    x8 = -x7 - C[1]
    x9 = -x1 * (a * A[2] + b * B[2])
    x10 = -x9 - C[2]
    x11 = x0 * (x10**2 + x6**2 + x8**2)
    x12 = (
        6.28318530717959
        * x1
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
    )
    x13 = x12 * boys(2, x11)
    x14 = x13 * x6
    x15 = x12 * boys(1, x11)
    x16 = x15 * x5
    x17 = -x14 + x16
    x18 = x17 * x5
    x19 = x4 * (-x13 + x15)
    x20 = x12 * boys(3, x11)
    x21 = x20 * x6
    x22 = x13 * x5
    x23 = -x21 + x22
    x24 = x23 * x6
    x25 = x19 - x24
    x26 = x18 + x25
    x27 = x26 * x5
    x28 = x23 * x5
    x29 = x4 * (x13 - x20)
    x30 = x12 * boys(4, x11)
    x31 = x30 * x6
    x32 = x20 * x5
    x33 = -x31 + x32
    x34 = x33 * x6
    x35 = x29 - x34
    x36 = x28 + x35
    x37 = x36 * x6
    x38 = 2.0 * x4
    x39 = x38 * (x17 + x21 - x22)
    x40 = -x37 + x39
    x41 = x27 + x40
    x42 = x41 * x5
    x43 = x12 * boys(0, x11)
    x44 = -x15 * x6 + x43 * x5
    x45 = x4 * (-x15 + x43)
    x46 = -x17 * x6 + x45
    x47 = x44 * x5 + x46
    x48 = -x26 * x6 + x38 * (x14 - x16 + x44)
    x49 = x47 * x5 + x48
    x50 = -x19
    x51 = x24 + x50
    x52 = x4 * (-x18 + x47 + x51)
    x53 = -x41 * x6 + 3.0 * x52
    x54 = x49 * x5 + x53
    x55 = x36 * x5
    x56 = x4 * (x20 - x30)
    x57 = x33 * x5
    x58 = x12 * boys(5, x11)
    x59 = x58 * x6
    x60 = x30 * x5
    x61 = -x59 + x60
    x62 = x6 * x61
    x63 = x56 + x57 - x62
    x64 = x6 * x63
    x65 = x38 * (x23 + x31 - x32)
    x66 = -x64 + x65
    x67 = x55 + x66
    x68 = x6 * x67
    x69 = -x29
    x70 = x34 + x69
    x71 = x4 * (x26 - x28 + x70)
    x72 = 3.0 * x71
    x73 = x68 - x72
    x74 = -x68 + x72
    x75 = x42 + x74
    x76 = x37 - x39
    x77 = x4 * (-x27 + x49 + x76)
    x78 = x3 * x54 - x6 * x75 + 4.0 * x77
    x79 = x3 * x75
    x80 = x5 * x67
    x81 = x5 * x63
    x82 = x4 * (x30 - x58)
    x83 = x5 * x61
    x84 = x12 * boys(6, x11)
    x85 = x6 * x84
    x86 = x5 * x58
    x87 = -x85 + x86
    x88 = x6 * x87
    x89 = x82 + x83 - x88
    x90 = x6 * x89
    x91 = x38 * (x33 + x59 - x60)
    x92 = -x90 + x91
    x93 = x81 + x92
    x94 = x6 * x93
    x95 = -x56
    x96 = x62 + x95
    x97 = x4 * (x36 - x57 + x96)
    x98 = 3.0 * x97
    x99 = -x94 + x98
    x100 = x80 + x99
    x101 = x100 * x6
    x102 = x64 - x65
    x103 = x4 * (x102 + x41 - x55)
    x104 = 4.0 * x103
    x105 = -x101 + x104 + x79
    x106 = x3 * x41
    x107 = x3 * x49 + x53
    x108 = -x106 + x107 + x73
    x109 = 4.0 * x4
    x110 = -x105 * x6 + x108 * x109 + x3 * x78 + x4 * (-x42 + x54 + x73)
    x111 = x94 - x98
    x112 = x4 * (x111 + x75 - x80)
    x113 = x105 * x3
    x114 = x100 * x3
    x115 = x5 * x93
    x116 = x5 * x89
    x117 = x4 * (x58 - x84)
    x118 = x5 * x87
    x119 = x12 * boys(7, x11)
    x120 = x119 * x6
    x121 = x5 * x84
    x122 = -x120 + x121
    x123 = x122 * x6
    x124 = x117 + x118 - x123
    x125 = x124 * x6
    x126 = x38 * (x61 + x85 - x86)
    x127 = x116 - x125 + x126
    x128 = x127 * x6
    x129 = -x82
    x130 = 3.0 * x4
    x131 = x130 * (x129 + x63 - x83 + x88)
    x132 = -x128 + x131
    x133 = x115 + x132
    x134 = x133 * x6
    x135 = x90 - x91
    x136 = x4 * (x135 + x67 - x81)
    x137 = 4.0 * x136
    x138 = x114 - x134 + x137
    x139 = x138 * x6
    x140 = x3 * x67
    x141 = x106 + x74
    x142 = x111 - x140 + x141
    x143 = x109 * x142
    x144 = x112 + x113 - x139 + x143
    x145 = x140 + x99
    x146 = x145 * x6
    x147 = x141 * x3
    x148 = x3 * x36
    x149 = x26 * x3
    x150 = x149 + x40
    x151 = x130 * (x102 - x148 + x150)
    x152 = x3 * x47 + x48
    x153 = x107 * x3 + x130 * (-x149 + x152 + x76) - x141 * x6 + x77
    x154 = x128 - x131
    x155 = x4 * (-x119 + x84)
    x156 = x12 * boys(8, x11)
    x157 = -x117
    x158 = x3 * x93
    x159 = x6 * (x132 + x158)
    x160 = x145 * x3
    x161 = x3 * x63
    x162 = x148 + x66
    x163 = x130 * (x135 - x161 + x162)
    x164 = x103 - x146 + x147 + x151
    x165 = x150 * x3
    x166 = x162 * x6
    x167 = x23 * x3
    x168 = x17 * x3
    x169 = x38 * (-x167 + x168 + x25 + x70)
    x170 = x13 * x8
    x171 = -x170
    x172 = -x7 - B[1]
    x173 = x15 * x172
    x174 = x171 + x173
    x175 = x174 * x5
    x176 = x20 * x8
    x177 = -x176
    x178 = x13 * x172
    x179 = x177 + x178
    x180 = x179 * x6
    x181 = -x180
    x182 = x175 + x181
    x183 = x182 * x5
    x184 = x4 * (x174 + x176 - x178)
    x185 = x179 * x5
    x186 = x30 * x8
    x187 = -x186
    x188 = x172 * x20
    x189 = x187 + x188
    x190 = x189 * x6
    x191 = -x190
    x192 = x185 + x191
    x193 = x192 * x6
    x194 = x184 - x193
    x195 = x183 + x194
    x196 = x195 * x5
    x197 = -x15 * x8
    x198 = x172 * x43 + x197
    x199 = -x174 * x6
    x200 = x198 * x5 + x199
    x201 = x4 * (x170 - x173 + x198)
    x202 = -x182 * x6 + x201
    x203 = x200 * x5 + x202
    x204 = x4 * (-x175 + x180 + x200)
    x205 = -x195 * x6 + 2.0 * x204
    x206 = x203 * x5 + x205
    x207 = x192 * x5
    x208 = x4 * (x179 + x186 - x188)
    x209 = x189 * x5
    x210 = x58 * x8
    x211 = -x210
    x212 = x172 * x30
    x213 = x211 + x212
    x214 = x213 * x6
    x215 = x209 - x214
    x216 = x215 * x6
    x217 = x208 - x216
    x218 = x207 + x217
    x219 = x218 * x6
    x220 = x4 * (x182 - x185 + x190)
    x221 = 2.0 * x220
    x222 = x219 - x221
    x223 = -x219 + x221
    x224 = x196 + x223
    x225 = -x184
    x226 = x193 + x225
    x227 = x4 * (-x183 + x203 + x226)
    x228 = x206 * x3 - x224 * x6 + 3.0 * x227
    x229 = x224 * x3
    x230 = x218 * x5
    x231 = x215 * x5
    x232 = x4 * (x189 + x210 - x212)
    x233 = x213 * x5
    x234 = x8 * x84
    x235 = -x234
    x236 = x172 * x58
    x237 = x235 + x236
    x238 = x237 * x6
    x239 = x233 - x238
    x240 = x239 * x6
    x241 = x232 - x240
    x242 = x231 + x241
    x243 = x242 * x6
    x244 = x4 * (x192 - x209 + x214)
    x245 = 2.0 * x244
    x246 = -x243 + x245
    x247 = x230 + x246
    x248 = x247 * x6
    x249 = -x208
    x250 = x216 + x249
    x251 = x4 * (x195 - x207 + x250)
    x252 = 3.0 * x251
    x253 = x229 - x248 + x252
    x254 = x195 * x3
    x255 = x203 * x3 + x205
    x256 = x222 - x254 + x255
    x257 = x130 * x256 + x228 * x3 - x253 * x6 + x4 * (-x196 + x206 + x222)
    x258 = x243 - x245
    x259 = x4 * (x224 - x230 + x258)
    x260 = x253 * x3
    x261 = x247 * x3
    x262 = x242 * x5
    x263 = x4 * (x213 + x234 - x236)
    x264 = x239 * x5
    x265 = x237 * x5
    x266 = x119 * x8
    x267 = -x266
    x268 = x172 * x84
    x269 = x267 + x268
    x270 = x269 * x6
    x271 = x265 - x270
    x272 = x271 * x6
    x273 = x263 + x264 - x272
    x274 = x273 * x6
    x275 = x38 * (x215 - x233 + x238)
    x276 = -x274 + x275
    x277 = x262 + x276
    x278 = x277 * x6
    x279 = -x232
    x280 = x240 + x279
    x281 = x4 * (x218 - x231 + x280)
    x282 = 3.0 * x281
    x283 = x261 - x278 + x282
    x284 = x283 * x6
    x285 = x218 * x3
    x286 = x223 + x254
    x287 = x258 - x285 + x286
    x288 = x130 * x287
    x289 = x259 + x260 - x284 + x288
    x290 = x246 + x285
    x291 = x290 * x6
    x292 = x286 * x3
    x293 = x192 * x3
    x294 = x182 * x3
    x295 = x194 + x294
    x296 = x38 * (x250 - x293 + x295)
    x297 = x200 * x3 + x202
    x298 = x227 + x255 * x3 - x286 * x6 + x38 * (x226 - x294 + x297)
    x299 = x274 - x275
    x300 = x4 * (x237 + x266 - x268)
    x301 = -x156 * x8
    x302 = x119 * x172 + x301
    x303 = -x263
    x304 = x242 * x3
    x305 = x6 * (x276 + x304)
    x306 = x290 * x3
    x307 = x215 * x3
    x308 = x217 + x293
    x309 = x38 * (x280 - x307 + x308)
    x310 = x251 - x291 + x292 + x296
    x311 = x174 * x3
    x312 = x179 * x3
    x313 = x4 * (x181 + x190 + x311 - x312)
    x314 = x295 * x3
    x315 = x308 * x6
    x316 = x10 * x13
    x317 = -x316
    x318 = -x9 - B[2]
    x319 = x15 * x318
    x320 = x317 + x319
    x321 = x320 * x5
    x322 = x10 * x20
    x323 = -x322
    x324 = x13 * x318
    x325 = x323 + x324
    x326 = x325 * x6
    x327 = -x326
    x328 = x321 + x327
    x329 = x328 * x5
    x330 = x4 * (x320 + x322 - x324)
    x331 = x325 * x5
    x332 = x10 * x30
    x333 = -x332
    x334 = x20 * x318
    x335 = x333 + x334
    x336 = x335 * x6
    x337 = -x336
    x338 = x331 + x337
    x339 = x338 * x6
    x340 = x330 - x339
    x341 = x329 + x340
    x342 = x341 * x5
    x343 = -x10 * x15
    x344 = x318 * x43 + x343
    x345 = -x320 * x6
    x346 = x344 * x5 + x345
    x347 = x4 * (x316 - x319 + x344)
    x348 = -x328 * x6 + x347
    x349 = x346 * x5 + x348
    x350 = x4 * (-x321 + x326 + x346)
    x351 = -x341 * x6 + 2.0 * x350
    x352 = x349 * x5 + x351
    x353 = x338 * x5
    x354 = x4 * (x325 + x332 - x334)
    x355 = x335 * x5
    x356 = x10 * x58
    x357 = -x356
    x358 = x30 * x318
    x359 = x357 + x358
    x360 = x359 * x6
    x361 = x355 - x360
    x362 = x361 * x6
    x363 = x354 - x362
    x364 = x353 + x363
    x365 = x364 * x6
    x366 = x4 * (x328 - x331 + x336)
    x367 = 2.0 * x366
    x368 = x365 - x367
    x369 = -x365 + x367
    x370 = x342 + x369
    x371 = -x330
    x372 = x339 + x371
    x373 = x4 * (-x329 + x349 + x372)
    x374 = x3 * x352 - x370 * x6 + 3.0 * x373
    x375 = x3 * x370
    x376 = x364 * x5
    x377 = x361 * x5
    x378 = x4 * (x335 + x356 - x358)
    x379 = x359 * x5
    x380 = x10 * x84
    x381 = -x380
    x382 = x318 * x58
    x383 = x381 + x382
    x384 = x383 * x6
    x385 = x379 - x384
    x386 = x385 * x6
    x387 = x378 - x386
    x388 = x377 + x387
    x389 = x388 * x6
    x390 = x4 * (x338 - x355 + x360)
    x391 = 2.0 * x390
    x392 = -x389 + x391
    x393 = x376 + x392
    x394 = x393 * x6
    x395 = -x354
    x396 = x362 + x395
    x397 = x4 * (x341 - x353 + x396)
    x398 = 3.0 * x397
    x399 = x375 - x394 + x398
    x400 = x3 * x341
    x401 = x3 * x349 + x351
    x402 = x368 - x400 + x401
    x403 = x130 * x402 + x3 * x374 - x399 * x6 + x4 * (-x342 + x352 + x368)
    x404 = x389 - x391
    x405 = x4 * (x370 - x376 + x404)
    x406 = x3 * x399
    x407 = x3 * x393
    x408 = x388 * x5
    x409 = x4 * (x359 + x380 - x382)
    x410 = x385 * x5
    x411 = x383 * x5
    x412 = x10 * x119
    x413 = -x412
    x414 = x318 * x84
    x415 = x413 + x414
    x416 = x415 * x6
    x417 = x411 - x416
    x418 = x417 * x6
    x419 = x409 + x410 - x418
    x420 = x419 * x6
    x421 = x38 * (x361 - x379 + x384)
    x422 = -x420 + x421
    x423 = x408 + x422
    x424 = x423 * x6
    x425 = -x378
    x426 = x386 + x425
    x427 = x4 * (x364 - x377 + x426)
    x428 = 3.0 * x427
    x429 = x407 - x424 + x428
    x430 = x429 * x6
    x431 = x3 * x364
    x432 = x369 + x400
    x433 = x404 - x431 + x432
    x434 = x130 * x433
    x435 = x405 + x406 - x430 + x434
    x436 = x392 + x431
    x437 = x436 * x6
    x438 = x3 * x432
    x439 = x3 * x338
    x440 = x3 * x328
    x441 = x340 + x440
    x442 = x38 * (x396 - x439 + x441)
    x443 = x3 * x346 + x348
    x444 = x3 * x401 + x373 + x38 * (x372 - x440 + x443) - x432 * x6
    x445 = x420 - x421
    x446 = x4 * (x383 + x412 - x414)
    x447 = -x10 * x156
    x448 = x119 * x318 + x447
    x449 = -x409
    x450 = x3 * x388
    x451 = x6 * (x422 + x450)
    x452 = x3 * x436
    x453 = x3 * x361
    x454 = x363 + x439
    x455 = x38 * (x426 - x453 + x454)
    x456 = x397 - x437 + x438 + x442
    x457 = x3 * x320
    x458 = x3 * x325
    x459 = x4 * (x327 + x336 + x457 - x458)
    x460 = x3 * x441
    x461 = x454 * x6
    x462 = x172 * x174
    x463 = x179 * x8
    x464 = x19 - x463
    x465 = x462 + x464
    x466 = x465 * x5
    x467 = x172 * x179
    x468 = x189 * x8
    x469 = x29 - x468
    x470 = x467 + x469
    x471 = x470 * x6
    x472 = -x471
    x473 = x466 + x472
    x474 = x473 * x5
    x475 = -x174 * x8 + x45
    x476 = x172 * x198 + x475
    x477 = -x465 * x6
    x478 = x476 * x5 + x477
    x479 = x463 + x50
    x480 = x4 * (-x462 + x476 + x479)
    x481 = -x473 * x6 + x480
    x482 = x478 * x5 + x481
    x483 = x470 * x5
    x484 = x172 * x189
    x485 = x213 * x8
    x486 = -x485 + x56
    x487 = x484 + x486
    x488 = x487 * x6
    x489 = -x488
    x490 = x483 + x489
    x491 = x490 * x6
    x492 = x468 + x69
    x493 = x4 * (x465 - x467 + x492)
    x494 = -x493
    x495 = x491 + x494
    x496 = -x491 + x493
    x497 = x474 + x496
    x498 = x4 * (-x466 + x471 + x478)
    x499 = x3 * x482 - x497 * x6 + 2.0 * x498
    x500 = x3 * x497
    x501 = x490 * x5
    x502 = x485 + x95
    x503 = x4 * (x470 - x484 + x502)
    x504 = x487 * x5
    x505 = x172 * x213
    x506 = x237 * x8
    x507 = -x506 + x82
    x508 = x505 + x507
    x509 = x508 * x6
    x510 = -x509
    x511 = x504 + x510
    x512 = x511 * x6
    x513 = x503 - x512
    x514 = x501 + x513
    x515 = x514 * x6
    x516 = x4 * (x473 - x483 + x488)
    x517 = 2.0 * x516
    x518 = x500 - x515 + x517
    x519 = x3 * x473
    x520 = x3 * x478 + x481
    x521 = x38 * (x495 - x519 + x520)
    x522 = x3 * x499 + x4 * (-x474 + x482 + x495) - x518 * x6 + x521
    x523 = -x503
    x524 = x512 + x523
    x525 = x4 * (x497 - x501 + x524)
    x526 = x3 * x518
    x527 = x3 * x514
    x528 = x5 * x511
    x529 = x129 + x506
    x530 = x4 * (x487 - x505 + x529)
    x531 = x5 * x508
    x532 = x172 * x237
    x533 = x269 * x8
    x534 = x117 - x533
    x535 = x532 + x534
    x536 = x535 * x6
    x537 = x531 - x536
    x538 = x537 * x6
    x539 = x530 - x538
    x540 = x528 + x539
    x541 = x540 * x6
    x542 = x4 * (x490 - x504 + x509)
    x543 = 2.0 * x542
    x544 = x527 - x541 + x543
    x545 = x544 * x6
    x546 = x3 * x490
    x547 = x496 + x519
    x548 = x38 * (x524 - x546 + x547)
    x549 = x525 + x526 - x545 + x548
    x550 = x513 + x546
    x551 = x550 * x6
    x552 = x3 * x470
    x553 = x3 * x465
    x554 = x472 + x553
    x555 = x4 * (x488 - x552 + x554)
    x556 = x3 * x547
    x557 = x3 * x476 + x477
    x558 = x3 * x520 + x4 * (x471 - x553 + x557) + x498 - x547 * x6
    x559 = -x530
    x560 = x538 + x559
    x561 = x157 + x533
    x562 = x4 * (x508 - x532 + x561)
    x563 = x155 - x302 * x8
    x564 = x172 * x269 + x563
    x565 = x3 * x511
    x566 = x6 * (x539 + x565)
    x567 = x3 * x487
    x568 = x489 + x552
    x569 = x4 * (x509 - x567 + x568)
    x570 = x3 * x550
    x571 = x516 - x551 + x555 + x556
    x572 = x568 * x6
    x573 = x3 * x554
    x574 = -x548
    x575 = x172 * x320
    x576 = x325 * x8
    x577 = -x576
    x578 = x575 + x577
    x579 = x5 * x578
    x580 = x172 * x325
    x581 = x335 * x8
    x582 = -x581
    x583 = x580 + x582
    x584 = x583 * x6
    x585 = -x584
    x586 = x579 + x585
    x587 = x5 * x586
    x588 = -x320 * x8
    x589 = x172 * x344 + x588
    x590 = -x578 * x6
    x591 = x5 * x589 + x590
    x592 = x4 * (-x575 + x576 + x589)
    x593 = -x586 * x6 + x592
    x594 = x5 * x591 + x593
    x595 = x5 * x583
    x596 = x172 * x335
    x597 = x359 * x8
    x598 = -x597
    x599 = x596 + x598
    x600 = x599 * x6
    x601 = -x600
    x602 = x595 + x601
    x603 = x6 * x602
    x604 = x4 * (x578 - x580 + x581)
    x605 = -x604
    x606 = x603 + x605
    x607 = -x603 + x604
    x608 = x587 + x607
    x609 = x4 * (-x579 + x584 + x591)
    x610 = x3 * x594 - x6 * x608 + 2.0 * x609
    x611 = x3 * x608
    x612 = x5 * x602
    x613 = x4 * (x583 - x596 + x597)
    x614 = x5 * x599
    x615 = x172 * x359
    x616 = x383 * x8
    x617 = -x616
    x618 = x615 + x617
    x619 = x6 * x618
    x620 = -x619
    x621 = x614 + x620
    x622 = x6 * x621
    x623 = x613 - x622
    x624 = x612 + x623
    x625 = x6 * x624
    x626 = x4 * (x586 - x595 + x600)
    x627 = 2.0 * x626
    x628 = x611 - x625 + x627
    x629 = x3 * x586
    x630 = x3 * x591 + x593
    x631 = x38 * (x606 - x629 + x630)
    x632 = x3 * x610 + x4 * (-x587 + x594 + x606) - x6 * x628 + x631
    x633 = -x613
    x634 = x622 + x633
    x635 = x4 * (x608 - x612 + x634)
    x636 = x3 * x628
    x637 = x3 * x624
    x638 = x5 * x621
    x639 = x4 * (x599 - x615 + x616)
    x640 = x5 * x618
    x641 = x172 * x383
    x642 = x415 * x8
    x643 = -x642
    x644 = x641 + x643
    x645 = x6 * x644
    x646 = x640 - x645
    x647 = x6 * x646
    x648 = x639 - x647
    x649 = x638 + x648
    x650 = x6 * x649
    x651 = x4 * (x602 - x614 + x619)
    x652 = 2.0 * x651
    x653 = x637 - x650 + x652
    x654 = x6 * x653
    x655 = x3 * x602
    x656 = x607 + x629
    x657 = x38 * (x634 - x655 + x656)
    x658 = x635 + x636 - x654 + x657
    x659 = x623 + x655
    x660 = x6 * x659
    x661 = x3 * x583
    x662 = x3 * x578
    x663 = x585 + x662
    x664 = x4 * (x600 - x661 + x663)
    x665 = x3 * x656
    x666 = x3 * x589 + x590
    x667 = x3 * x630 + x4 * (x584 - x662 + x666) - x6 * x656 + x609
    x668 = -x639
    x669 = x647 + x668
    x670 = x4 * (x618 - x641 + x642)
    x671 = -x448 * x8
    x672 = x172 * x415 + x671
    x673 = x3 * x621
    x674 = x6 * (x648 + x673)
    x675 = x3 * x599
    x676 = x601 + x661
    x677 = x4 * (x619 - x675 + x676)
    x678 = x3 * x659
    x679 = x626 - x660 + x664 + x665
    x680 = x6 * x676
    x681 = x3 * x663
    x682 = -x657
    x683 = x318 * x320
    x684 = x10 * x325
    x685 = x19 - x684
    x686 = x683 + x685
    x687 = x5 * x686
    x688 = x318 * x325
    x689 = x10 * x335
    x690 = x29 - x689
    x691 = x688 + x690
    x692 = x6 * x691
    x693 = -x692
    x694 = x687 + x693
    x695 = x5 * x694
    x696 = -x10 * x320 + x45
    x697 = x318 * x344 + x696
    x698 = -x6 * x686
    x699 = x5 * x697 + x698
    x700 = x50 + x684
    x701 = x4 * (-x683 + x697 + x700)
    x702 = -x6 * x694 + x701
    x703 = x5 * x699 + x702
    x704 = x5 * x691
    x705 = x318 * x335
    x706 = x10 * x359
    x707 = x56 - x706
    x708 = x705 + x707
    x709 = x6 * x708
    x710 = -x709
    x711 = x704 + x710
    x712 = x6 * x711
    x713 = x689 + x69
    x714 = x4 * (x686 - x688 + x713)
    x715 = -x714
    x716 = x712 + x715
    x717 = -x712 + x714
    x718 = x695 + x717
    x719 = x4 * (-x687 + x692 + x699)
    x720 = x3 * x703 - x6 * x718 + 2.0 * x719
    x721 = x3 * x718
    x722 = x5 * x711
    x723 = x706 + x95
    x724 = x4 * (x691 - x705 + x723)
    x725 = x5 * x708
    x726 = x318 * x359
    x727 = x10 * x383
    x728 = -x727 + x82
    x729 = x726 + x728
    x730 = x6 * x729
    x731 = -x730
    x732 = x725 + x731
    x733 = x6 * x732
    x734 = x724 - x733
    x735 = x722 + x734
    x736 = x6 * x735
    x737 = x4 * (x694 - x704 + x709)
    x738 = 2.0 * x737
    x739 = x721 - x736 + x738
    x740 = x3 * x694
    x741 = x3 * x699 + x702
    x742 = x38 * (x716 - x740 + x741)
    x743 = x3 * x720 + x4 * (-x695 + x703 + x716) - x6 * x739 + x742
    x744 = -x724
    x745 = x733 + x744
    x746 = x4 * (x718 - x722 + x745)
    x747 = x3 * x739
    x748 = x3 * x735
    x749 = x5 * x732
    x750 = x129 + x727
    x751 = x4 * (x708 - x726 + x750)
    x752 = x5 * x729
    x753 = x318 * x383
    x754 = x10 * x415
    x755 = x117 - x754
    x756 = x753 + x755
    x757 = x6 * x756
    x758 = x752 - x757
    x759 = x6 * x758
    x760 = x751 - x759
    x761 = x749 + x760
    x762 = x6 * x761
    x763 = x4 * (x711 - x725 + x730)
    x764 = 2.0 * x763
    x765 = x748 - x762 + x764
    x766 = x6 * x765
    x767 = x3 * x711
    x768 = x717 + x740
    x769 = x38 * (x745 - x767 + x768)
    x770 = x746 + x747 - x766 + x769
    x771 = x734 + x767
    x772 = x6 * x771
    x773 = x3 * x691
    x774 = x3 * x686
    x775 = x693 + x774
    x776 = x4 * (x709 - x773 + x775)
    x777 = x3 * x768
    x778 = x3 * x697 + x698
    x779 = x3 * x741 + x4 * (x692 - x774 + x778) - x6 * x768 + x719
    x780 = -x751
    x781 = x759 + x780
    x782 = x157 + x754
    x783 = x4 * (x729 - x753 + x782)
    x784 = -x10 * x448 + x155
    x785 = x318 * x415 + x784
    x786 = x3 * x732
    x787 = x6 * (x760 + x786)
    x788 = x3 * x708
    x789 = x710 + x773
    x790 = x4 * (x730 - x788 + x789)
    x791 = x3 * x771
    x792 = x737 - x772 + x776 + x777
    x793 = x6 * x789
    x794 = x3 * x775
    x795 = -x769
    x796 = x172 * x465
    x797 = 2.0 * x201 - x465 * x8
    x798 = x172 * x476 + x797
    x799 = x470 * x8
    x800 = 2.0 * x184
    x801 = x799 - x800
    x802 = x4 * (-x796 + x798 + x801)
    x803 = -x799 + x800
    x804 = x796 + x803
    x805 = -x6 * x804
    x806 = x3 * x798 + x805
    x807 = x3 * x804
    x808 = x172 * x470
    x809 = x487 * x8
    x810 = 2.0 * x208
    x811 = -x809 + x810
    x812 = x808 + x811
    x813 = x6 * x812
    x814 = -x813
    x815 = x807 + x814
    x816 = x3 * x806 - x6 * x815 + x802
    x817 = x172 * x487
    x818 = x508 * x8
    x819 = 2.0 * x232
    x820 = x818 - x819
    x821 = x4 * (x812 - x817 + x820)
    x822 = x3 * x812
    x823 = -x818 + x819
    x824 = x817 + x823
    x825 = x6 * x824
    x826 = -x825
    x827 = x822 + x826
    x828 = x3 * x827
    x829 = x3 * x824
    x830 = x172 * x508
    x831 = x535 * x8
    x832 = 2.0 * x263
    x833 = -x831 + x832
    x834 = x830 + x833
    x835 = x6 * x834
    x836 = -x835
    x837 = x6 * (x829 + x836)
    x838 = x809 - x810
    x839 = x4 * (x804 - x808 + x838)
    x840 = x3 * x815
    x841 = x6 * x827
    x842 = x839 + x840 - x841
    x843 = x4 * (x815 - x822 + x825)
    x844 = x4 * (x806 - x807 + x813)
    x845 = -x839
    x846 = x5 * x804
    x847 = x5 * x798 + x805
    x848 = x814 + x846
    x849 = x3 * x847 - x6 * x848 + x802
    x850 = x3 * x848
    x851 = x5 * x812
    x852 = x826 + x851
    x853 = x6 * x852
    x854 = x839 + x850 - x853
    x855 = x3 * x849 + x4 * (x813 - x846 + x847) - x6 * x854 + x844
    x856 = x4 * (x825 + x848 - x851)
    x857 = x3 * x854
    x858 = x3 * x852
    x859 = x5 * x824
    x860 = x836 + x859
    x861 = x6 * x860
    x862 = x821 + x858 - x861
    x863 = x6 * x862
    x864 = x843 + x856 + x857 - x863
    x865 = -x821
    x866 = x831 - x832
    x867 = x4 * (x824 - x830 + x866)
    x868 = 2.0 * x300 - x564 * x8
    x869 = x172 * x535 + x868
    x870 = x172 * x578
    x871 = x347 - x578 * x8
    x872 = x172 * x589 + x871
    x873 = x583 * x8
    x874 = x371 + x873
    x875 = x4 * (-x870 + x872 + x874)
    x876 = x330 - x873
    x877 = x870 + x876
    x878 = -x6 * x877
    x879 = x3 * x872 + x878
    x880 = x3 * x877
    x881 = x172 * x583
    x882 = x599 * x8
    x883 = x354 - x882
    x884 = x881 + x883
    x885 = x6 * x884
    x886 = -x885
    x887 = x880 + x886
    x888 = x3 * x879 - x6 * x887 + x875
    x889 = x172 * x599
    x890 = x618 * x8
    x891 = x425 + x890
    x892 = x4 * (x884 - x889 + x891)
    x893 = x3 * x884
    x894 = x378 - x890
    x895 = x889 + x894
    x896 = x6 * x895
    x897 = -x896
    x898 = x893 + x897
    x899 = x3 * x898
    x900 = x3 * x895
    x901 = x172 * x618
    x902 = x644 * x8
    x903 = x409 - x902
    x904 = x901 + x903
    x905 = x6 * x904
    x906 = -x905
    x907 = x6 * (x900 + x906)
    x908 = x395 + x882
    x909 = x4 * (x877 - x881 + x908)
    x910 = x3 * x887
    x911 = x6 * x898
    x912 = x909 + x910 - x911
    x913 = x4 * (x887 - x893 + x896)
    x914 = x4 * (x879 - x880 + x885)
    x915 = -x909
    x916 = x5 * x877
    x917 = x5 * x872 + x878
    x918 = x886 + x916
    x919 = x3 * x917 - x6 * x918 + x875
    x920 = x3 * x918
    x921 = x5 * x884
    x922 = x897 + x921
    x923 = x6 * x922
    x924 = x909 + x920 - x923
    x925 = x3 * x919 + x4 * (x885 - x916 + x917) - x6 * x924 + x914
    x926 = x4 * (x896 + x918 - x921)
    x927 = x3 * x924
    x928 = x3 * x922
    x929 = x5 * x895
    x930 = x906 + x929
    x931 = x6 * x930
    x932 = x892 + x928 - x931
    x933 = x6 * x932
    x934 = x913 + x926 + x927 - x933
    x935 = -x892
    x936 = x449 + x902
    x937 = x4 * (x895 - x901 + x936)
    x938 = x446 - x672 * x8
    x939 = x172 * x644 + x938
    x940 = x691 * x8
    x941 = x172 * x686
    x942 = -x686 * x8
    x943 = x172 * x697 + x942
    x944 = x4 * (x940 - x941 + x943)
    x945 = -x940
    x946 = x941 + x945
    x947 = -x6 * x946
    x948 = x3 * x943 + x947
    x949 = x3 * x946
    x950 = x172 * x691
    x951 = x708 * x8
    x952 = -x951
    x953 = x950 + x952
    x954 = x6 * x953
    x955 = -x954
    x956 = x949 + x955
    x957 = x3 * x948 - x6 * x956 + x944
    x958 = x729 * x8
    x959 = x172 * x708
    x960 = x4 * (x953 + x958 - x959)
    x961 = x3 * x953
    x962 = -x958
    x963 = x959 + x962
    x964 = x6 * x963
    x965 = -x964
    x966 = x961 + x965
    x967 = x3 * x966
    x968 = x3 * x963
    x969 = x172 * x729
    x970 = x756 * x8
    x971 = -x970
    x972 = x969 + x971
    x973 = x6 * x972
    x974 = -x973
    x975 = x6 * (x968 + x974)
    x976 = x4 * (x946 - x950 + x951)
    x977 = x3 * x956
    x978 = x6 * x966
    x979 = x976 + x977 - x978
    x980 = x4 * (x956 - x961 + x964)
    x981 = x4 * (x948 - x949 + x954)
    x982 = -x976
    x983 = x5 * x946
    x984 = x5 * x943 + x947
    x985 = x955 + x983
    x986 = x3 * x984 - x6 * x985 + x944
    x987 = x3 * x985
    x988 = x5 * x953
    x989 = x965 + x988
    x990 = x6 * x989
    x991 = x976 + x987 - x990
    x992 = x3 * x986 + x4 * (x954 - x983 + x984) - x6 * x991 + x981
    x993 = x4 * (x964 + x985 - x988)
    x994 = x3 * x991
    x995 = x3 * x989
    x996 = x5 * x963
    x997 = x974 + x996
    x998 = x6 * x997
    x999 = x960 + x995 - x998
    x1000 = x6 * x999
    x1001 = -x1000 + x980 + x993 + x994
    x1002 = -x960
    x1003 = x4 * (x963 - x969 + x970)
    x1004 = -x785 * x8
    x1005 = x1004 + x172 * x756
    x1006 = x318 * x686
    x1007 = -x10 * x686 + 2.0 * x347
    x1008 = x1007 + x318 * x697
    x1009 = x10 * x691
    x1010 = 2.0 * x330
    x1011 = x1009 - x1010
    x1012 = x4 * (-x1006 + x1008 + x1011)
    x1013 = -x1009 + x1010
    x1014 = x1006 + x1013
    x1015 = -x1014 * x6
    x1016 = x1008 * x3 + x1015
    x1017 = x1014 * x3
    x1018 = x318 * x691
    x1019 = x10 * x708
    x1020 = 2.0 * x354
    x1021 = -x1019 + x1020
    x1022 = x1018 + x1021
    x1023 = x1022 * x6
    x1024 = -x1023
    x1025 = x1017 + x1024
    x1026 = x1012 + x1016 * x3 - x1025 * x6
    x1027 = x318 * x708
    x1028 = x10 * x729
    x1029 = 2.0 * x378
    x1030 = x1028 - x1029
    x1031 = x4 * (x1022 - x1027 + x1030)
    x1032 = x1022 * x3
    x1033 = -x1028 + x1029
    x1034 = x1027 + x1033
    x1035 = x1034 * x6
    x1036 = -x1035
    x1037 = x1032 + x1036
    x1038 = x1037 * x3
    x1039 = x1034 * x3
    x1040 = x318 * x729
    x1041 = x10 * x756
    x1042 = 2.0 * x409
    x1043 = -x1041 + x1042
    x1044 = x1040 + x1043
    x1045 = x1044 * x6
    x1046 = -x1045
    x1047 = x6 * (x1039 + x1046)
    x1048 = x1019 - x1020
    x1049 = x4 * (x1014 - x1018 + x1048)
    x1050 = x1025 * x3
    x1051 = x1037 * x6
    x1052 = x1049 + x1050 - x1051
    x1053 = x4 * (x1025 - x1032 + x1035)
    x1054 = x4 * (x1016 - x1017 + x1023)
    x1055 = -x1049
    x1056 = x1014 * x5
    x1057 = x1008 * x5 + x1015
    x1058 = x1024 + x1056
    x1059 = x1012 + x1057 * x3 - x1058 * x6
    x1060 = x1058 * x3
    x1061 = x1022 * x5
    x1062 = x1036 + x1061
    x1063 = x1062 * x6
    x1064 = x1049 + x1060 - x1063
    x1065 = x1054 + x1059 * x3 - x1064 * x6 + x4 * (x1023 - x1056 + x1057)
    x1066 = x4 * (x1035 + x1058 - x1061)
    x1067 = x1064 * x3
    x1068 = x1062 * x3
    x1069 = x1034 * x5
    x1070 = x1046 + x1069
    x1071 = x1070 * x6
    x1072 = x1031 + x1068 - x1071
    x1073 = x1072 * x6
    x1074 = x1053 + x1066 + x1067 - x1073
    x1075 = -x1031
    x1076 = x1041 - x1042
    x1077 = x4 * (x1034 - x1040 + x1076)
    x1078 = -x10 * x785 + 2.0 * x446
    x1079 = x1078 + x318 * x756
    x1080 = x172 * x804
    x1081 = 3.0 * x480 - x8 * x804
    x1082 = x1081 + x172 * x798
    x1083 = x8 * x812
    x1084 = 3.0 * x493
    x1085 = x1083 - x1084
    x1086 = x4 * (-x1080 + x1082 + x1085)
    x1087 = -x1083 + x1084
    x1088 = x1080 + x1087
    x1089 = x1082 * x3 - x1088 * x6
    x1090 = x1088 * x3
    x1091 = x172 * x812
    x1092 = x8 * x824
    x1093 = 3.0 * x503
    x1094 = -x1092 + x1093
    x1095 = x1091 + x1094
    x1096 = x1095 * x6
    x1097 = x1090 - x1096
    x1098 = x1086 + x1089 * x3 - x1097 * x6
    x1099 = x1092 - x1093
    x1100 = x4 * (x1088 - x1091 + x1099)
    x1101 = x1097 * x3
    x1102 = x1095 * x3
    x1103 = x172 * x824
    x1104 = x8 * x834
    x1105 = 3.0 * x530
    x1106 = -x1104 + x1105
    x1107 = x1103 + x1106
    x1108 = x1107 * x6
    x1109 = x1102 - x1108
    x1110 = x1109 * x6
    x1111 = x1100 + x1101 - x1110
    x1112 = x1104 - x1105
    x1113 = x4 * (x1095 - x1103 + x1112)
    x1114 = 3.0 * x562 - x8 * x869
    x1115 = x1114 + x172 * x834
    x1116 = -x1100
    x1117 = x172 * x877
    x1118 = 2.0 * x592 - x8 * x877
    x1119 = x1118 + x172 * x872
    x1120 = x8 * x884
    x1121 = 2.0 * x604
    x1122 = x1120 - x1121
    x1123 = x4 * (-x1117 + x1119 + x1122)
    x1124 = -x1120 + x1121
    x1125 = x1117 + x1124
    x1126 = x1119 * x3 - x1125 * x6
    x1127 = x1125 * x3
    x1128 = x172 * x884
    x1129 = x8 * x895
    x1130 = 2.0 * x613
    x1131 = -x1129 + x1130
    x1132 = x1128 + x1131
    x1133 = x1132 * x6
    x1134 = x1127 - x1133
    x1135 = x1123 + x1126 * x3 - x1134 * x6
    x1136 = x1129 - x1130
    x1137 = x4 * (x1125 - x1128 + x1136)
    x1138 = x1134 * x3
    x1139 = x1132 * x3
    x1140 = x172 * x895
    x1141 = x8 * x904
    x1142 = 2.0 * x639
    x1143 = -x1141 + x1142
    x1144 = x1140 + x1143
    x1145 = x1144 * x6
    x1146 = x1139 - x1145
    x1147 = x1146 * x6
    x1148 = x1137 + x1138 - x1147
    x1149 = x1141 - x1142
    x1150 = x4 * (x1132 - x1140 + x1149)
    x1151 = 2.0 * x670 - x8 * x939
    x1152 = x1151 + x172 * x904
    x1153 = -x1137
    x1154 = x172 * x946
    x1155 = x701 - x8 * x946
    x1156 = x1155 + x172 * x943
    x1157 = x8 * x953
    x1158 = x1157 + x715
    x1159 = x4 * (-x1154 + x1156 + x1158)
    x1160 = -x1157 + x714
    x1161 = x1154 + x1160
    x1162 = x1156 * x3 - x1161 * x6
    x1163 = x1161 * x3
    x1164 = x172 * x953
    x1165 = x8 * x963
    x1166 = -x1165 + x724
    x1167 = x1164 + x1166
    x1168 = x1167 * x6
    x1169 = x1163 - x1168
    x1170 = x1159 + x1162 * x3 - x1169 * x6
    x1171 = x1165 + x744
    x1172 = x4 * (x1161 - x1164 + x1171)
    x1173 = x1169 * x3
    x1174 = x1167 * x3
    x1175 = x172 * x963
    x1176 = x8 * x972
    x1177 = -x1176 + x751
    x1178 = x1175 + x1177
    x1179 = x1178 * x6
    x1180 = x1174 - x1179
    x1181 = x1180 * x6
    x1182 = x1172 + x1173 - x1181
    x1183 = x1176 + x780
    x1184 = x4 * (x1167 - x1175 + x1183)
    x1185 = -x1005 * x8 + x783
    x1186 = x1185 + x172 * x972
    x1187 = -x1172
    x1188 = x1022 * x8
    x1189 = x1014 * x172
    x1190 = -x1014 * x8
    x1191 = x1008 * x172 + x1190
    x1192 = x4 * (x1188 - x1189 + x1191)
    x1193 = -x1188
    x1194 = x1189 + x1193
    x1195 = x1191 * x3 - x1194 * x6
    x1196 = x1194 * x3
    x1197 = x1022 * x172
    x1198 = x1034 * x8
    x1199 = -x1198
    x1200 = x1197 + x1199
    x1201 = x1200 * x6
    x1202 = x1196 - x1201
    x1203 = x1192 + x1195 * x3 - x1202 * x6
    x1204 = x4 * (x1194 - x1197 + x1198)
    x1205 = x1202 * x3
    x1206 = x1200 * x3
    x1207 = x1034 * x172
    x1208 = x1044 * x8
    x1209 = -x1208
    x1210 = x1207 + x1209
    x1211 = x1210 * x6
    x1212 = x1206 - x1211
    x1213 = x1212 * x6
    x1214 = x1204 + x1205 - x1213
    x1215 = x4 * (x1200 - x1207 + x1208)
    x1216 = -x1079 * x8
    x1217 = x1044 * x172 + x1216
    x1218 = -x1204
    x1219 = x1014 * x318
    x1220 = -x10 * x1014 + 3.0 * x701
    x1221 = x1008 * x318 + x1220
    x1222 = x10 * x1022
    x1223 = 3.0 * x714
    x1224 = x1222 - x1223
    x1225 = x4 * (-x1219 + x1221 + x1224)
    x1226 = -x1222 + x1223
    x1227 = x1219 + x1226
    x1228 = x1221 * x3 - x1227 * x6
    x1229 = x1227 * x3
    x1230 = x1022 * x318
    x1231 = x10 * x1034
    x1232 = 3.0 * x724
    x1233 = -x1231 + x1232
    x1234 = x1230 + x1233
    x1235 = x1234 * x6
    x1236 = x1229 - x1235
    x1237 = x1225 + x1228 * x3 - x1236 * x6
    x1238 = x1231 - x1232
    x1239 = x4 * (x1227 - x1230 + x1238)
    x1240 = x1236 * x3
    x1241 = x1234 * x3
    x1242 = x1034 * x318
    x1243 = x10 * x1044
    x1244 = 3.0 * x751
    x1245 = -x1243 + x1244
    x1246 = x1242 + x1245
    x1247 = x1246 * x6
    x1248 = x1241 - x1247
    x1249 = x1248 * x6
    x1250 = x1239 + x1240 - x1249
    x1251 = x1243 - x1244
    x1252 = x4 * (x1234 - x1242 + x1251)
    x1253 = -x10 * x1079 + 3.0 * x783
    x1254 = x1044 * x318 + x1253
    x1255 = -x1239
    x1256 = -x7 - A[1]
    x1257 = x1256 * x13
    x1258 = x1256 * x15
    x1259 = x1258 + x171
    x1260 = x4 * (-x1257 + x1259 + x176)
    x1261 = x1259 * x5
    x1262 = x1257 + x177
    x1263 = x1262 * x6
    x1264 = x1261 - x1263
    x1265 = x1264 * x5
    x1266 = x1262 * x5
    x1267 = x1256 * x20
    x1268 = x1267 + x187
    x1269 = x1268 * x6
    x1270 = x1266 - x1269
    x1271 = x1270 * x6
    x1272 = x1260 + x1265 - x1271
    x1273 = x1272 * x5
    x1274 = x4 * (x1262 - x1267 + x186)
    x1275 = x1270 * x5
    x1276 = x1268 * x5
    x1277 = x1256 * x30
    x1278 = x1277 + x211
    x1279 = x1278 * x6
    x1280 = x1276 - x1279
    x1281 = x1280 * x6
    x1282 = x1274 + x1275 - x1281
    x1283 = x1282 * x6
    x1284 = x38 * (x1264 - x1266 + x1269)
    x1285 = -x1283 + x1284
    x1286 = x1273 + x1285
    x1287 = x1286 * x5
    x1288 = x1256 * x43 + x197
    x1289 = x4 * (-x1258 + x1288 + x170)
    x1290 = -x1259 * x6 + x1288 * x5
    x1291 = -x1264 * x6 + x1289 + x1290 * x5
    x1292 = -x1272 * x6 + x38 * (-x1261 + x1263 + x1290)
    x1293 = x1291 * x5 + x1292
    x1294 = -x1260
    x1295 = -x1286 * x6 + x130 * (-x1265 + x1271 + x1291 + x1294)
    x1296 = x1293 * x5 + x1295
    x1297 = x1282 * x5
    x1298 = x4 * (x1268 - x1277 + x210)
    x1299 = x1280 * x5
    x1300 = x1278 * x5
    x1301 = x1256 * x58
    x1302 = x1301 + x235
    x1303 = x1302 * x6
    x1304 = x1300 - x1303
    x1305 = x1304 * x6
    x1306 = x1298 + x1299 - x1305
    x1307 = x1306 * x6
    x1308 = x38 * (x1270 - x1276 + x1279)
    x1309 = x1297 - x1307 + x1308
    x1310 = x1309 * x6
    x1311 = -x1274
    x1312 = x130 * (x1272 - x1275 + x1281 + x1311)
    x1313 = x1310 - x1312
    x1314 = -x1310 + x1312
    x1315 = x1287 + x1314
    x1316 = x1283 - x1284
    x1317 = x4 * (-x1273 + x1293 + x1316)
    x1318 = x1296 * x3 - x1315 * x6 + 4.0 * x1317
    x1319 = x1315 * x3
    x1320 = x1309 * x5
    x1321 = x1306 * x5
    x1322 = x4 * (x1278 - x1301 + x234)
    x1323 = x1304 * x5
    x1324 = x1302 * x5
    x1325 = x1256 * x84
    x1326 = x1325 + x267
    x1327 = x1326 * x6
    x1328 = x1324 - x1327
    x1329 = x1328 * x6
    x1330 = x1322 + x1323 - x1329
    x1331 = x1330 * x6
    x1332 = x38 * (x1280 - x1300 + x1303)
    x1333 = x1321 - x1331 + x1332
    x1334 = x1333 * x6
    x1335 = -x1298
    x1336 = x130 * (x1282 - x1299 + x1305 + x1335)
    x1337 = -x1334 + x1336
    x1338 = x1320 + x1337
    x1339 = x1338 * x6
    x1340 = x1307 - x1308
    x1341 = x4 * (x1286 - x1297 + x1340)
    x1342 = 4.0 * x1341
    x1343 = x1319 - x1339 + x1342
    x1344 = x1286 * x3
    x1345 = x1293 * x3 + x1295
    x1346 = x1334 - x1336
    x1347 = x4 * (x1302 - x1325 + x266)
    x1348 = x119 * x1256 + x301
    x1349 = -x1322
    x1350 = x1309 * x3
    x1351 = x1314 + x1344
    x1352 = x1272 * x3
    x1353 = x1256 * x174
    x1354 = x1353 + x464
    x1355 = x1354 * x5
    x1356 = x1256 * x179
    x1357 = x1356 + x469
    x1358 = x1357 * x6
    x1359 = x1355 - x1358
    x1360 = x1359 * x5
    x1361 = x4 * (x1354 - x1356 + x492)
    x1362 = x1357 * x5
    x1363 = x1256 * x189
    x1364 = x1363 + x486
    x1365 = x1364 * x6
    x1366 = x1362 - x1365
    x1367 = x1366 * x6
    x1368 = x1361 - x1367
    x1369 = x1360 + x1368
    x1370 = x1369 * x5
    x1371 = x1256 * x198 + x475
    x1372 = -x1354 * x6 + x1371 * x5
    x1373 = x4 * (-x1353 + x1371 + x479)
    x1374 = -x1359 * x6 + x1373
    x1375 = x1372 * x5 + x1374
    x1376 = -x1369 * x6 + x38 * (-x1355 + x1358 + x1372)
    x1377 = x1375 * x5 + x1376
    x1378 = x4 * (x1357 - x1363 + x502)
    x1379 = x1366 * x5
    x1380 = x1364 * x5
    x1381 = x1256 * x213
    x1382 = x1381 + x507
    x1383 = x1382 * x6
    x1384 = x1380 - x1383
    x1385 = x1384 * x6
    x1386 = x1378 + x1379 - x1385
    x1387 = x1386 * x6
    x1388 = x38 * (x1359 - x1362 + x1365)
    x1389 = x1387 - x1388
    x1390 = -x1387 + x1388
    x1391 = x1370 + x1390
    x1392 = -x1361 + x1367
    x1393 = x4 * (-x1360 + x1375 + x1392)
    x1394 = x1377 * x3 - x1391 * x6 + 3.0 * x1393
    x1395 = x1391 * x3
    x1396 = x1386 * x5
    x1397 = x4 * (x1364 - x1381 + x529)
    x1398 = x1384 * x5
    x1399 = x1382 * x5
    x1400 = x1256 * x237
    x1401 = x1400 + x534
    x1402 = x1401 * x6
    x1403 = x1399 - x1402
    x1404 = x1403 * x6
    x1405 = x1397 + x1398 - x1404
    x1406 = x1405 * x6
    x1407 = x38 * (x1366 - x1380 + x1383)
    x1408 = -x1406 + x1407
    x1409 = x1396 + x1408
    x1410 = x1409 * x6
    x1411 = -x1378 + x1385
    x1412 = x4 * (x1369 - x1379 + x1411)
    x1413 = 3.0 * x1412
    x1414 = x1395 - x1410 + x1413
    x1415 = x1369 * x3
    x1416 = x1375 * x3 + x1376
    x1417 = x1406 - x1407
    x1418 = x4 * (x1382 - x1400 + x561)
    x1419 = x1256 * x269 + x563
    x1420 = x1386 * x3
    x1421 = x1390 + x1415
    x1422 = x1359 * x3
    x1423 = x1256 * x320
    x1424 = x1423 + x577
    x1425 = x1424 * x5
    x1426 = x1256 * x325
    x1427 = x1426 + x582
    x1428 = x1427 * x6
    x1429 = x1425 - x1428
    x1430 = x1429 * x5
    x1431 = x4 * (x1424 - x1426 + x581)
    x1432 = x1427 * x5
    x1433 = x1256 * x335
    x1434 = x1433 + x598
    x1435 = x1434 * x6
    x1436 = x1432 - x1435
    x1437 = x1436 * x6
    x1438 = x1431 - x1437
    x1439 = x1430 + x1438
    x1440 = x1439 * x5
    x1441 = x1256 * x344 + x588
    x1442 = -x1424 * x6 + x1441 * x5
    x1443 = x4 * (-x1423 + x1441 + x576)
    x1444 = -x1429 * x6 + x1443
    x1445 = x1442 * x5 + x1444
    x1446 = -x1439 * x6 + x38 * (-x1425 + x1428 + x1442)
    x1447 = x1445 * x5 + x1446
    x1448 = x4 * (x1427 - x1433 + x597)
    x1449 = x1436 * x5
    x1450 = x1434 * x5
    x1451 = x1256 * x359
    x1452 = x1451 + x617
    x1453 = x1452 * x6
    x1454 = x1450 - x1453
    x1455 = x1454 * x6
    x1456 = x1448 + x1449 - x1455
    x1457 = x1456 * x6
    x1458 = x38 * (x1429 - x1432 + x1435)
    x1459 = x1457 - x1458
    x1460 = -x1457 + x1458
    x1461 = x1440 + x1460
    x1462 = -x1431
    x1463 = x1437 + x1462
    x1464 = x4 * (-x1430 + x1445 + x1463)
    x1465 = x1447 * x3 - x1461 * x6 + 3.0 * x1464
    x1466 = x1461 * x3
    x1467 = x1456 * x5
    x1468 = x4 * (x1434 - x1451 + x616)
    x1469 = x1454 * x5
    x1470 = x1452 * x5
    x1471 = x1256 * x383
    x1472 = x1471 + x643
    x1473 = x1472 * x6
    x1474 = x1470 - x1473
    x1475 = x1474 * x6
    x1476 = x1468 + x1469 - x1475
    x1477 = x1476 * x6
    x1478 = x38 * (x1436 - x1450 + x1453)
    x1479 = -x1477 + x1478
    x1480 = x1467 + x1479
    x1481 = x1480 * x6
    x1482 = -x1448
    x1483 = x1455 + x1482
    x1484 = x4 * (x1439 - x1449 + x1483)
    x1485 = 3.0 * x1484
    x1486 = x1466 - x1481 + x1485
    x1487 = x1439 * x3
    x1488 = x1445 * x3 + x1446
    x1489 = x1477 - x1478
    x1490 = x4 * (x1452 - x1471 + x642)
    x1491 = x1256 * x415 + x671
    x1492 = -x1468
    x1493 = x1456 * x3
    x1494 = x1460 + x1487
    x1495 = x1429 * x3
    x1496 = x1256 * x465
    x1497 = x1496 + x803
    x1498 = x1497 * x5
    x1499 = x1256 * x470
    x1500 = x1499 + x811
    x1501 = x1500 * x6
    x1502 = -x1501
    x1503 = x1498 + x1502
    x1504 = x1503 * x5
    x1505 = x1256 * x476 + x797
    x1506 = -x1497 * x6
    x1507 = x1505 * x5 + x1506
    x1508 = x4 * (-x1496 + x1505 + x801)
    x1509 = -x1503 * x6 + x1508
    x1510 = x1507 * x5 + x1509
    x1511 = x1500 * x5
    x1512 = x1256 * x487
    x1513 = x1512 + x823
    x1514 = x1513 * x6
    x1515 = x1511 - x1514
    x1516 = x1515 * x6
    x1517 = x4 * (x1497 - x1499 + x838)
    x1518 = x1516 - x1517
    x1519 = -x1516 + x1517
    x1520 = x1504 + x1519
    x1521 = x4 * (-x1498 + x1501 + x1507)
    x1522 = x1510 * x3 - x1520 * x6 + 2.0 * x1521
    x1523 = x1520 * x3
    x1524 = x1515 * x5
    x1525 = x4 * (x1500 - x1512 + x820)
    x1526 = x1513 * x5
    x1527 = x1256 * x508
    x1528 = x1527 + x833
    x1529 = x1528 * x6
    x1530 = x1526 - x1529
    x1531 = x1530 * x6
    x1532 = x1525 - x1531
    x1533 = x1524 + x1532
    x1534 = x1533 * x6
    x1535 = x4 * (x1503 - x1511 + x1514)
    x1536 = 2.0 * x1535
    x1537 = x1523 - x1534 + x1536
    x1538 = x1503 * x3
    x1539 = x1507 * x3 + x1509
    x1540 = -x1525 + x1531
    x1541 = x4 * (x1513 - x1527 + x866)
    x1542 = x1256 * x535 + x868
    x1543 = x1515 * x3
    x1544 = x1519 + x1538
    x1545 = x1497 * x3
    x1546 = x1256 * x578
    x1547 = x1546 + x876
    x1548 = x1547 * x5
    x1549 = x1256 * x583
    x1550 = x1549 + x883
    x1551 = x1550 * x6
    x1552 = -x1551
    x1553 = x1548 + x1552
    x1554 = x1553 * x5
    x1555 = x1256 * x589 + x871
    x1556 = -x1547 * x6
    x1557 = x1555 * x5 + x1556
    x1558 = x4 * (-x1546 + x1555 + x874)
    x1559 = -x1553 * x6 + x1558
    x1560 = x1557 * x5 + x1559
    x1561 = x1550 * x5
    x1562 = x1256 * x599
    x1563 = x1562 + x894
    x1564 = x1563 * x6
    x1565 = x1561 - x1564
    x1566 = x1565 * x6
    x1567 = x4 * (x1547 - x1549 + x908)
    x1568 = x1566 - x1567
    x1569 = -x1566 + x1567
    x1570 = x1554 + x1569
    x1571 = x4 * (-x1548 + x1551 + x1557)
    x1572 = x1560 * x3 - x1570 * x6 + 2.0 * x1571
    x1573 = x1570 * x3
    x1574 = x1565 * x5
    x1575 = x4 * (x1550 - x1562 + x891)
    x1576 = x1563 * x5
    x1577 = x1256 * x618
    x1578 = x1577 + x903
    x1579 = x1578 * x6
    x1580 = x1576 - x1579
    x1581 = x1580 * x6
    x1582 = x1575 - x1581
    x1583 = x1574 + x1582
    x1584 = x1583 * x6
    x1585 = x4 * (x1553 - x1561 + x1564)
    x1586 = 2.0 * x1585
    x1587 = x1573 - x1584 + x1586
    x1588 = x1553 * x3
    x1589 = x1557 * x3 + x1559
    x1590 = -x1575 + x1581
    x1591 = x4 * (x1563 - x1577 + x936)
    x1592 = x1256 * x644 + x938
    x1593 = x1565 * x3
    x1594 = x1569 + x1588
    x1595 = x1547 * x3
    x1596 = x1256 * x686
    x1597 = x1596 + x945
    x1598 = x1597 * x5
    x1599 = x1256 * x691
    x1600 = x1599 + x952
    x1601 = x1600 * x6
    x1602 = -x1601
    x1603 = x1598 + x1602
    x1604 = x1603 * x5
    x1605 = x1256 * x697 + x942
    x1606 = -x1597 * x6
    x1607 = x1605 * x5 + x1606
    x1608 = x4 * (-x1596 + x1605 + x940)
    x1609 = -x1603 * x6 + x1608
    x1610 = x1607 * x5 + x1609
    x1611 = x1600 * x5
    x1612 = x1256 * x708
    x1613 = x1612 + x962
    x1614 = x1613 * x6
    x1615 = x1611 - x1614
    x1616 = x1615 * x6
    x1617 = x4 * (x1597 - x1599 + x951)
    x1618 = -x1617
    x1619 = x1616 + x1618
    x1620 = -x1616 + x1617
    x1621 = x1604 + x1620
    x1622 = x4 * (-x1598 + x1601 + x1607)
    x1623 = x1610 * x3 - x1621 * x6 + 2.0 * x1622
    x1624 = x1621 * x3
    x1625 = x1615 * x5
    x1626 = x4 * (x1600 - x1612 + x958)
    x1627 = x1613 * x5
    x1628 = x1256 * x729
    x1629 = x1628 + x971
    x1630 = x1629 * x6
    x1631 = x1627 - x1630
    x1632 = x1631 * x6
    x1633 = x1626 - x1632
    x1634 = x1625 + x1633
    x1635 = x1634 * x6
    x1636 = x4 * (x1603 - x1611 + x1614)
    x1637 = 2.0 * x1636
    x1638 = x1624 - x1635 + x1637
    x1639 = x1603 * x3
    x1640 = x1607 * x3 + x1609
    x1641 = -x1626
    x1642 = x1632 + x1641
    x1643 = x4 * (x1613 - x1628 + x970)
    x1644 = x1004 + x1256 * x756
    x1645 = x1615 * x3
    x1646 = x1620 + x1639
    x1647 = x1597 * x3
    x1648 = x1256 * x804
    x1649 = x1081 + x1256 * x798
    x1650 = x4 * (x1085 - x1648 + x1649)
    x1651 = x1087 + x1648
    x1652 = -x1651 * x6
    x1653 = x1649 * x3 + x1652
    x1654 = x1256 * x812
    x1655 = x1094 + x1654
    x1656 = x1655 * x3
    x1657 = x1256 * x824
    x1658 = x1106 + x1657
    x1659 = x1658 * x6
    x1660 = -x1659
    x1661 = x4 * (x1099 + x1651 - x1654)
    x1662 = -x1661
    x1663 = x1651 * x3
    x1664 = x1655 * x6
    x1665 = -x1664
    x1666 = x1663 + x1665
    x1667 = x1651 * x5
    x1668 = x1649 * x5 + x1652
    x1669 = x1665 + x1667
    x1670 = x1650 + x1668 * x3 - x1669 * x6
    x1671 = x1669 * x3
    x1672 = x1655 * x5
    x1673 = x1660 + x1672
    x1674 = x1673 * x6
    x1675 = x1661 + x1671 - x1674
    x1676 = x4 * (x1112 + x1655 - x1657)
    x1677 = x1114 + x1256 * x834
    x1678 = x1256 * x877
    x1679 = x1118 + x1256 * x872
    x1680 = x4 * (x1122 - x1678 + x1679)
    x1681 = x1124 + x1678
    x1682 = -x1681 * x6
    x1683 = x1679 * x3 + x1682
    x1684 = x1256 * x884
    x1685 = x1131 + x1684
    x1686 = x1685 * x3
    x1687 = x1256 * x895
    x1688 = x1143 + x1687
    x1689 = x1688 * x6
    x1690 = -x1689
    x1691 = x4 * (x1136 + x1681 - x1684)
    x1692 = -x1691
    x1693 = x1681 * x3
    x1694 = x1685 * x6
    x1695 = -x1694
    x1696 = x1693 + x1695
    x1697 = x1681 * x5
    x1698 = x1679 * x5 + x1682
    x1699 = x1695 + x1697
    x1700 = x1680 + x1698 * x3 - x1699 * x6
    x1701 = x1699 * x3
    x1702 = x1685 * x5
    x1703 = x1690 + x1702
    x1704 = x1703 * x6
    x1705 = x1691 + x1701 - x1704
    x1706 = x4 * (x1149 + x1685 - x1687)
    x1707 = x1151 + x1256 * x904
    x1708 = x1256 * x946
    x1709 = x1155 + x1256 * x943
    x1710 = x4 * (x1158 - x1708 + x1709)
    x1711 = x1160 + x1708
    x1712 = -x1711 * x6
    x1713 = x1709 * x3 + x1712
    x1714 = x1256 * x953
    x1715 = x1166 + x1714
    x1716 = x1715 * x3
    x1717 = x1256 * x963
    x1718 = x1177 + x1717
    x1719 = x1718 * x6
    x1720 = -x1719
    x1721 = x4 * (x1171 + x1711 - x1714)
    x1722 = -x1721
    x1723 = x1711 * x3
    x1724 = x1715 * x6
    x1725 = -x1724
    x1726 = x1723 + x1725
    x1727 = x1711 * x5
    x1728 = x1709 * x5 + x1712
    x1729 = x1725 + x1727
    x1730 = x1710 + x1728 * x3 - x1729 * x6
    x1731 = x1729 * x3
    x1732 = x1715 * x5
    x1733 = x1720 + x1732
    x1734 = x1733 * x6
    x1735 = x1721 + x1731 - x1734
    x1736 = x4 * (x1183 + x1715 - x1717)
    x1737 = x1185 + x1256 * x972
    x1738 = x1014 * x1256
    x1739 = x1008 * x1256 + x1190
    x1740 = x4 * (x1188 - x1738 + x1739)
    x1741 = x1193 + x1738
    x1742 = -x1741 * x6
    x1743 = x1739 * x3 + x1742
    x1744 = x1022 * x1256
    x1745 = x1199 + x1744
    x1746 = x1745 * x3
    x1747 = x1034 * x1256
    x1748 = x1209 + x1747
    x1749 = x1748 * x6
    x1750 = -x1749
    x1751 = x4 * (x1198 + x1741 - x1744)
    x1752 = -x1751
    x1753 = x1741 * x3
    x1754 = x1745 * x6
    x1755 = -x1754
    x1756 = x1753 + x1755
    x1757 = x1741 * x5
    x1758 = x1739 * x5 + x1742
    x1759 = x1755 + x1757
    x1760 = x1740 + x1758 * x3 - x1759 * x6
    x1761 = x1759 * x3
    x1762 = x1745 * x5
    x1763 = x1750 + x1762
    x1764 = x1763 * x6
    x1765 = x1751 + x1761 - x1764
    x1766 = x4 * (x1208 + x1745 - x1747)
    x1767 = x1044 * x1256 + x1216
    x1768 = x1095 * x8
    x1769 = x1088 * x1256
    x1770 = 4.0 * x839
    x1771 = x1082 * x1256 - x1088 * x8 + 4.0 * x802
    x1772 = x4 * (x1768 - x1769 - x1770 + x1771)
    x1773 = -x1768 + x1769 + x1770
    x1774 = x1771 * x3 - x1773 * x6
    x1775 = x1773 * x3
    x1776 = x1095 * x1256
    x1777 = x1107 * x8
    x1778 = 4.0 * x821
    x1779 = x1776 - x1777 + x1778
    x1780 = x1779 * x6
    x1781 = x1775 - x1780
    x1782 = x4 * (x1773 - x1776 + x1777 - x1778)
    x1783 = x1107 * x1256 - x1115 * x8 + 4.0 * x867
    x1784 = x1132 * x8
    x1785 = x1125 * x1256
    x1786 = 3.0 * x909
    x1787 = x1119 * x1256 - x1125 * x8 + 3.0 * x875
    x1788 = x4 * (x1784 - x1785 - x1786 + x1787)
    x1789 = -x1784 + x1785 + x1786
    x1790 = x1787 * x3 - x1789 * x6
    x1791 = x1789 * x3
    x1792 = x1132 * x1256
    x1793 = x1144 * x8
    x1794 = 3.0 * x892
    x1795 = x1792 - x1793 + x1794
    x1796 = x1795 * x6
    x1797 = x1791 - x1796
    x1798 = x4 * (x1789 - x1792 + x1793 - x1794)
    x1799 = x1144 * x1256 - x1152 * x8 + 3.0 * x937
    x1800 = x1167 * x8
    x1801 = x1161 * x1256
    x1802 = 2.0 * x976
    x1803 = x1156 * x1256 - x1161 * x8 + 2.0 * x944
    x1804 = x4 * (x1800 - x1801 - x1802 + x1803)
    x1805 = -x1800 + x1801 + x1802
    x1806 = x1803 * x3 - x1805 * x6
    x1807 = x1805 * x3
    x1808 = x1167 * x1256
    x1809 = x1178 * x8
    x1810 = 2.0 * x960
    x1811 = x1808 - x1809 + x1810
    x1812 = x1811 * x6
    x1813 = x1807 - x1812
    x1814 = x4 * (x1805 - x1808 + x1809 - x1810)
    x1815 = 2.0 * x1003 + x1178 * x1256 - x1186 * x8
    x1816 = x1200 * x8
    x1817 = x1194 * x1256
    x1818 = x1012 + x1191 * x1256 - x1194 * x8
    x1819 = x4 * (x1055 + x1816 - x1817 + x1818)
    x1820 = x1049 - x1816 + x1817
    x1821 = x1818 * x3 - x1820 * x6
    x1822 = x1820 * x3
    x1823 = x1200 * x1256
    x1824 = x1210 * x8
    x1825 = x1031 + x1823 - x1824
    x1826 = x1825 * x6
    x1827 = x1822 - x1826
    x1828 = x4 * (x1075 + x1820 - x1823 + x1824)
    x1829 = x1077 + x1210 * x1256 - x1217 * x8
    x1830 = x1234 * x8
    x1831 = x1227 * x1256
    x1832 = x1221 * x1256 - x1227 * x8
    x1833 = x4 * (x1830 - x1831 + x1832)
    x1834 = -x1830 + x1831
    x1835 = x1832 * x3 - x1834 * x6
    x1836 = x1834 * x3
    x1837 = x1234 * x1256
    x1838 = x1246 * x8
    x1839 = x1837 - x1838
    x1840 = x1839 * x6
    x1841 = x1836 - x1840
    x1842 = x4 * (x1834 - x1837 + x1838)
    x1843 = x1246 * x1256 - x1254 * x8
    x1844 = -x9 - A[2]
    x1845 = x13 * x1844
    x1846 = x15 * x1844
    x1847 = x1846 + x317
    x1848 = x4 * (-x1845 + x1847 + x322)
    x1849 = x1847 * x5
    x1850 = x1845 + x323
    x1851 = x1850 * x6
    x1852 = x1849 - x1851
    x1853 = x1852 * x5
    x1854 = x1850 * x5
    x1855 = x1844 * x20
    x1856 = x1855 + x333
    x1857 = x1856 * x6
    x1858 = x1854 - x1857
    x1859 = x1858 * x6
    x1860 = x1848 + x1853 - x1859
    x1861 = x1860 * x5
    x1862 = x4 * (x1850 - x1855 + x332)
    x1863 = x1858 * x5
    x1864 = x1856 * x5
    x1865 = x1844 * x30
    x1866 = x1865 + x357
    x1867 = x1866 * x6
    x1868 = x1864 - x1867
    x1869 = x1868 * x6
    x1870 = x1862 + x1863 - x1869
    x1871 = x1870 * x6
    x1872 = x38 * (x1852 - x1854 + x1857)
    x1873 = -x1871 + x1872
    x1874 = x1861 + x1873
    x1875 = x1874 * x5
    x1876 = x1844 * x43 + x343
    x1877 = x4 * (-x1846 + x1876 + x316)
    x1878 = -x1847 * x6 + x1876 * x5
    x1879 = -x1852 * x6 + x1877 + x1878 * x5
    x1880 = -x1860 * x6 + x38 * (-x1849 + x1851 + x1878)
    x1881 = x1879 * x5 + x1880
    x1882 = -x1848
    x1883 = x130 * (-x1853 + x1859 + x1879 + x1882) - x1874 * x6
    x1884 = x1881 * x5 + x1883
    x1885 = x1870 * x5
    x1886 = x4 * (x1856 - x1865 + x356)
    x1887 = x1868 * x5
    x1888 = x1866 * x5
    x1889 = x1844 * x58
    x1890 = x1889 + x381
    x1891 = x1890 * x6
    x1892 = x1888 - x1891
    x1893 = x1892 * x6
    x1894 = x1886 + x1887 - x1893
    x1895 = x1894 * x6
    x1896 = x38 * (x1858 - x1864 + x1867)
    x1897 = x1885 - x1895 + x1896
    x1898 = x1897 * x6
    x1899 = -x1862
    x1900 = x130 * (x1860 - x1863 + x1869 + x1899)
    x1901 = x1898 - x1900
    x1902 = -x1898 + x1900
    x1903 = x1875 + x1902
    x1904 = x1871 - x1872
    x1905 = x4 * (-x1861 + x1881 + x1904)
    x1906 = x1884 * x3 - x1903 * x6 + 4.0 * x1905
    x1907 = x1903 * x3
    x1908 = x1897 * x5
    x1909 = x1894 * x5
    x1910 = x4 * (x1866 - x1889 + x380)
    x1911 = x1892 * x5
    x1912 = x1890 * x5
    x1913 = x1844 * x84
    x1914 = x1913 + x413
    x1915 = x1914 * x6
    x1916 = x1912 - x1915
    x1917 = x1916 * x6
    x1918 = x1910 + x1911 - x1917
    x1919 = x1918 * x6
    x1920 = x38 * (x1868 - x1888 + x1891)
    x1921 = x1909 - x1919 + x1920
    x1922 = x1921 * x6
    x1923 = -x1886
    x1924 = x130 * (x1870 - x1887 + x1893 + x1923)
    x1925 = -x1922 + x1924
    x1926 = x1908 + x1925
    x1927 = x1926 * x6
    x1928 = x1895 - x1896
    x1929 = x4 * (x1874 - x1885 + x1928)
    x1930 = 4.0 * x1929
    x1931 = x1907 - x1927 + x1930
    x1932 = x1874 * x3
    x1933 = x1881 * x3 + x1883
    x1934 = x1922 - x1924
    x1935 = x4 * (x1890 - x1913 + x412)
    x1936 = x119 * x1844 + x447
    x1937 = -x1910
    x1938 = x1897 * x3
    x1939 = x1902 + x1932
    x1940 = x1860 * x3
    x1941 = x172 * x1847
    x1942 = x1850 * x8
    x1943 = -x1942
    x1944 = x1941 + x1943
    x1945 = x1944 * x5
    x1946 = x172 * x1850
    x1947 = x1856 * x8
    x1948 = -x1947
    x1949 = x1946 + x1948
    x1950 = x1949 * x6
    x1951 = x1945 - x1950
    x1952 = x1951 * x5
    x1953 = x4 * (x1944 - x1946 + x1947)
    x1954 = x1949 * x5
    x1955 = x172 * x1856
    x1956 = x1866 * x8
    x1957 = -x1956
    x1958 = x1955 + x1957
    x1959 = x1958 * x6
    x1960 = x1954 - x1959
    x1961 = x1960 * x6
    x1962 = x1953 - x1961
    x1963 = x1952 + x1962
    x1964 = x1963 * x5
    x1965 = -x1847 * x8
    x1966 = x172 * x1876 + x1965
    x1967 = -x1944 * x6 + x1966 * x5
    x1968 = x4 * (-x1941 + x1942 + x1966)
    x1969 = -x1951 * x6 + x1968
    x1970 = x1967 * x5 + x1969
    x1971 = -x1963 * x6 + x38 * (-x1945 + x1950 + x1967)
    x1972 = x1970 * x5 + x1971
    x1973 = x4 * (x1949 - x1955 + x1956)
    x1974 = x1960 * x5
    x1975 = x1958 * x5
    x1976 = x172 * x1866
    x1977 = x1890 * x8
    x1978 = -x1977
    x1979 = x1976 + x1978
    x1980 = x1979 * x6
    x1981 = x1975 - x1980
    x1982 = x1981 * x6
    x1983 = x1973 + x1974 - x1982
    x1984 = x1983 * x6
    x1985 = x38 * (x1951 - x1954 + x1959)
    x1986 = x1984 - x1985
    x1987 = -x1984 + x1985
    x1988 = x1964 + x1987
    x1989 = -x1953
    x1990 = x1961 + x1989
    x1991 = x4 * (-x1952 + x1970 + x1990)
    x1992 = x1972 * x3 - x1988 * x6 + 3.0 * x1991
    x1993 = x1988 * x3
    x1994 = x1983 * x5
    x1995 = x4 * (x1958 - x1976 + x1977)
    x1996 = x1981 * x5
    x1997 = x1979 * x5
    x1998 = x172 * x1890
    x1999 = x1914 * x8
    x2000 = -x1999
    x2001 = x1998 + x2000
    x2002 = x2001 * x6
    x2003 = x1997 - x2002
    x2004 = x2003 * x6
    x2005 = x1995 + x1996 - x2004
    x2006 = x2005 * x6
    x2007 = x38 * (x1960 - x1975 + x1980)
    x2008 = -x2006 + x2007
    x2009 = x1994 + x2008
    x2010 = x2009 * x6
    x2011 = -x1973
    x2012 = x1982 + x2011
    x2013 = x4 * (x1963 - x1974 + x2012)
    x2014 = 3.0 * x2013
    x2015 = x1993 - x2010 + x2014
    x2016 = x1963 * x3
    x2017 = x1970 * x3 + x1971
    x2018 = x2006 - x2007
    x2019 = x4 * (x1979 - x1998 + x1999)
    x2020 = -x1936 * x8
    x2021 = x172 * x1914 + x2020
    x2022 = -x1995
    x2023 = x1983 * x3
    x2024 = x1987 + x2016
    x2025 = x1951 * x3
    x2026 = x1844 * x320
    x2027 = x2026 + x685
    x2028 = x2027 * x5
    x2029 = x1844 * x325
    x2030 = x2029 + x690
    x2031 = x2030 * x6
    x2032 = x2028 - x2031
    x2033 = x2032 * x5
    x2034 = x4 * (x2027 - x2029 + x713)
    x2035 = x2030 * x5
    x2036 = x1844 * x335
    x2037 = x2036 + x707
    x2038 = x2037 * x6
    x2039 = x2035 - x2038
    x2040 = x2039 * x6
    x2041 = x2034 - x2040
    x2042 = x2033 + x2041
    x2043 = x2042 * x5
    x2044 = x1844 * x344 + x696
    x2045 = -x2027 * x6 + x2044 * x5
    x2046 = x4 * (-x2026 + x2044 + x700)
    x2047 = -x2032 * x6 + x2046
    x2048 = x2045 * x5 + x2047
    x2049 = -x2042 * x6 + x38 * (-x2028 + x2031 + x2045)
    x2050 = x2048 * x5 + x2049
    x2051 = x4 * (x2030 - x2036 + x723)
    x2052 = x2039 * x5
    x2053 = x2037 * x5
    x2054 = x1844 * x359
    x2055 = x2054 + x728
    x2056 = x2055 * x6
    x2057 = x2053 - x2056
    x2058 = x2057 * x6
    x2059 = x2051 + x2052 - x2058
    x2060 = x2059 * x6
    x2061 = x38 * (x2032 - x2035 + x2038)
    x2062 = x2060 - x2061
    x2063 = -x2060 + x2061
    x2064 = x2043 + x2063
    x2065 = -x2034
    x2066 = x2040 + x2065
    x2067 = x4 * (-x2033 + x2048 + x2066)
    x2068 = x2050 * x3 - x2064 * x6 + 3.0 * x2067
    x2069 = x2064 * x3
    x2070 = x2059 * x5
    x2071 = x4 * (x2037 - x2054 + x750)
    x2072 = x2057 * x5
    x2073 = x2055 * x5
    x2074 = x1844 * x383
    x2075 = x2074 + x755
    x2076 = x2075 * x6
    x2077 = x2073 - x2076
    x2078 = x2077 * x6
    x2079 = x2071 + x2072 - x2078
    x2080 = x2079 * x6
    x2081 = x38 * (x2039 - x2053 + x2056)
    x2082 = -x2080 + x2081
    x2083 = x2070 + x2082
    x2084 = x2083 * x6
    x2085 = -x2051
    x2086 = x2058 + x2085
    x2087 = x4 * (x2042 - x2052 + x2086)
    x2088 = 3.0 * x2087
    x2089 = x2069 - x2084 + x2088
    x2090 = x2042 * x3
    x2091 = x2048 * x3 + x2049
    x2092 = x2080 - x2081
    x2093 = x4 * (x2055 - x2074 + x782)
    x2094 = x1844 * x415 + x784
    x2095 = -x2071
    x2096 = x2059 * x3
    x2097 = x2063 + x2090
    x2098 = x2032 * x3
    x2099 = x172 * x1944
    x2100 = x1949 * x8
    x2101 = x1848 - x2100
    x2102 = x2099 + x2101
    x2103 = x2102 * x5
    x2104 = x172 * x1949
    x2105 = x1958 * x8
    x2106 = x1862 - x2105
    x2107 = x2104 + x2106
    x2108 = x2107 * x6
    x2109 = -x2108
    x2110 = x2103 + x2109
    x2111 = x2110 * x5
    x2112 = x1877 - x1944 * x8
    x2113 = x172 * x1966 + x2112
    x2114 = -x2102 * x6
    x2115 = x2113 * x5 + x2114
    x2116 = x1882 + x2100
    x2117 = x4 * (-x2099 + x2113 + x2116)
    x2118 = -x2110 * x6 + x2117
    x2119 = x2115 * x5 + x2118
    x2120 = x2107 * x5
    x2121 = x172 * x1958
    x2122 = x1979 * x8
    x2123 = x1886 - x2122
    x2124 = x2121 + x2123
    x2125 = x2124 * x6
    x2126 = x2120 - x2125
    x2127 = x2126 * x6
    x2128 = x1899 + x2105
    x2129 = x4 * (x2102 - x2104 + x2128)
    x2130 = -x2129
    x2131 = x2127 + x2130
    x2132 = -x2127 + x2129
    x2133 = x2111 + x2132
    x2134 = x4 * (-x2103 + x2108 + x2115)
    x2135 = x2119 * x3 - x2133 * x6 + 2.0 * x2134
    x2136 = x2133 * x3
    x2137 = x2126 * x5
    x2138 = x1923 + x2122
    x2139 = x4 * (x2107 - x2121 + x2138)
    x2140 = x2124 * x5
    x2141 = x172 * x1979
    x2142 = x2001 * x8
    x2143 = x1910 - x2142
    x2144 = x2141 + x2143
    x2145 = x2144 * x6
    x2146 = x2140 - x2145
    x2147 = x2146 * x6
    x2148 = x2139 - x2147
    x2149 = x2137 + x2148
    x2150 = x2149 * x6
    x2151 = x4 * (x2110 - x2120 + x2125)
    x2152 = 2.0 * x2151
    x2153 = x2136 - x2150 + x2152
    x2154 = x2110 * x3
    x2155 = x2115 * x3 + x2118
    x2156 = -x2139
    x2157 = x2147 + x2156
    x2158 = x1937 + x2142
    x2159 = x4 * (x2124 - x2141 + x2158)
    x2160 = x1935 - x2021 * x8
    x2161 = x172 * x2001 + x2160
    x2162 = x2126 * x3
    x2163 = x2132 + x2154
    x2164 = x2102 * x3
    x2165 = x172 * x2027
    x2166 = x2030 * x8
    x2167 = -x2166
    x2168 = x2165 + x2167
    x2169 = x2168 * x5
    x2170 = x172 * x2030
    x2171 = x2037 * x8
    x2172 = -x2171
    x2173 = x2170 + x2172
    x2174 = x2173 * x6
    x2175 = -x2174
    x2176 = x2169 + x2175
    x2177 = x2176 * x5
    x2178 = -x2027 * x8
    x2179 = x172 * x2044 + x2178
    x2180 = -x2168 * x6
    x2181 = x2179 * x5 + x2180
    x2182 = x4 * (-x2165 + x2166 + x2179)
    x2183 = -x2176 * x6 + x2182
    x2184 = x2181 * x5 + x2183
    x2185 = x2173 * x5
    x2186 = x172 * x2037
    x2187 = x2055 * x8
    x2188 = -x2187
    x2189 = x2186 + x2188
    x2190 = x2189 * x6
    x2191 = x2185 - x2190
    x2192 = x2191 * x6
    x2193 = x4 * (x2168 - x2170 + x2171)
    x2194 = -x2193
    x2195 = x2192 + x2194
    x2196 = -x2192 + x2193
    x2197 = x2177 + x2196
    x2198 = x4 * (-x2169 + x2174 + x2181)
    x2199 = x2184 * x3 - x2197 * x6 + 2.0 * x2198
    x2200 = x2197 * x3
    x2201 = x2191 * x5
    x2202 = x4 * (x2173 - x2186 + x2187)
    x2203 = x2189 * x5
    x2204 = x172 * x2055
    x2205 = x2075 * x8
    x2206 = -x2205
    x2207 = x2204 + x2206
    x2208 = x2207 * x6
    x2209 = x2203 - x2208
    x2210 = x2209 * x6
    x2211 = x2202 - x2210
    x2212 = x2201 + x2211
    x2213 = x2212 * x6
    x2214 = x4 * (x2176 - x2185 + x2190)
    x2215 = 2.0 * x2214
    x2216 = x2200 - x2213 + x2215
    x2217 = x2176 * x3
    x2218 = x2181 * x3 + x2183
    x2219 = -x2202
    x2220 = x2210 + x2219
    x2221 = x4 * (x2189 - x2204 + x2205)
    x2222 = -x2094 * x8
    x2223 = x172 * x2075 + x2222
    x2224 = x2191 * x3
    x2225 = x2196 + x2217
    x2226 = x2168 * x3
    x2227 = x1844 * x686
    x2228 = x1013 + x2227
    x2229 = x2228 * x5
    x2230 = x1844 * x691
    x2231 = x1021 + x2230
    x2232 = x2231 * x6
    x2233 = -x2232
    x2234 = x2229 + x2233
    x2235 = x2234 * x5
    x2236 = x1007 + x1844 * x697
    x2237 = -x2228 * x6
    x2238 = x2236 * x5 + x2237
    x2239 = x4 * (x1011 - x2227 + x2236)
    x2240 = -x2234 * x6 + x2239
    x2241 = x2238 * x5 + x2240
    x2242 = x2231 * x5
    x2243 = x1844 * x708
    x2244 = x1033 + x2243
    x2245 = x2244 * x6
    x2246 = x2242 - x2245
    x2247 = x2246 * x6
    x2248 = x4 * (x1048 + x2228 - x2230)
    x2249 = -x2248
    x2250 = x2247 + x2249
    x2251 = -x2247 + x2248
    x2252 = x2235 + x2251
    x2253 = x4 * (-x2229 + x2232 + x2238)
    x2254 = x2241 * x3 - x2252 * x6 + 2.0 * x2253
    x2255 = x2252 * x3
    x2256 = x2246 * x5
    x2257 = x4 * (x1030 + x2231 - x2243)
    x2258 = x2244 * x5
    x2259 = x1844 * x729
    x2260 = x1043 + x2259
    x2261 = x2260 * x6
    x2262 = x2258 - x2261
    x2263 = x2262 * x6
    x2264 = x2257 - x2263
    x2265 = x2256 + x2264
    x2266 = x2265 * x6
    x2267 = x4 * (x2234 - x2242 + x2245)
    x2268 = 2.0 * x2267
    x2269 = x2255 - x2266 + x2268
    x2270 = x2234 * x3
    x2271 = x2238 * x3 + x2240
    x2272 = -x2257
    x2273 = x2263 + x2272
    x2274 = x4 * (x1076 + x2244 - x2259)
    x2275 = x1078 + x1844 * x756
    x2276 = x2246 * x3
    x2277 = x2251 + x2270
    x2278 = x2228 * x3
    x2279 = x172 * x2102
    x2280 = 2.0 * x1968 - x2102 * x8
    x2281 = x172 * x2113 + x2280
    x2282 = x2107 * x8
    x2283 = 2.0 * x1953
    x2284 = x2282 - x2283
    x2285 = x4 * (-x2279 + x2281 + x2284)
    x2286 = -x2282 + x2283
    x2287 = x2279 + x2286
    x2288 = -x2287 * x6
    x2289 = x2281 * x3 + x2288
    x2290 = x172 * x2107
    x2291 = x2124 * x8
    x2292 = 2.0 * x1973
    x2293 = -x2291 + x2292
    x2294 = x2290 + x2293
    x2295 = x2294 * x3
    x2296 = x172 * x2124
    x2297 = x2144 * x8
    x2298 = 2.0 * x1995
    x2299 = -x2297 + x2298
    x2300 = x2296 + x2299
    x2301 = x2300 * x6
    x2302 = -x2301
    x2303 = x2291 - x2292
    x2304 = x4 * (x2287 - x2290 + x2303)
    x2305 = -x2304
    x2306 = x2287 * x3
    x2307 = x2294 * x6
    x2308 = -x2307
    x2309 = x2306 + x2308
    x2310 = x2287 * x5
    x2311 = x2281 * x5 + x2288
    x2312 = x2308 + x2310
    x2313 = x2285 + x2311 * x3 - x2312 * x6
    x2314 = x2312 * x3
    x2315 = x2294 * x5
    x2316 = x2302 + x2315
    x2317 = x2316 * x6
    x2318 = x2304 + x2314 - x2317
    x2319 = x2297 - x2298
    x2320 = x4 * (x2294 - x2296 + x2319)
    x2321 = 2.0 * x2019 - x2161 * x8
    x2322 = x172 * x2144 + x2321
    x2323 = x172 * x2168
    x2324 = x2046 - x2168 * x8
    x2325 = x172 * x2179 + x2324
    x2326 = x2173 * x8
    x2327 = x2065 + x2326
    x2328 = x4 * (-x2323 + x2325 + x2327)
    x2329 = x2034 - x2326
    x2330 = x2323 + x2329
    x2331 = -x2330 * x6
    x2332 = x2325 * x3 + x2331
    x2333 = x172 * x2173
    x2334 = x2189 * x8
    x2335 = x2051 - x2334
    x2336 = x2333 + x2335
    x2337 = x2336 * x3
    x2338 = x172 * x2189
    x2339 = x2207 * x8
    x2340 = x2071 - x2339
    x2341 = x2338 + x2340
    x2342 = x2341 * x6
    x2343 = -x2342
    x2344 = x2085 + x2334
    x2345 = x4 * (x2330 - x2333 + x2344)
    x2346 = -x2345
    x2347 = x2330 * x3
    x2348 = x2336 * x6
    x2349 = -x2348
    x2350 = x2347 + x2349
    x2351 = x2330 * x5
    x2352 = x2325 * x5 + x2331
    x2353 = x2349 + x2351
    x2354 = x2328 + x2352 * x3 - x2353 * x6
    x2355 = x2353 * x3
    x2356 = x2336 * x5
    x2357 = x2343 + x2356
    x2358 = x2357 * x6
    x2359 = x2345 + x2355 - x2358
    x2360 = x2095 + x2339
    x2361 = x4 * (x2336 - x2338 + x2360)
    x2362 = x2093 - x2223 * x8
    x2363 = x172 * x2207 + x2362
    x2364 = x2231 * x8
    x2365 = x172 * x2228
    x2366 = -x2228 * x8
    x2367 = x172 * x2236 + x2366
    x2368 = x4 * (x2364 - x2365 + x2367)
    x2369 = -x2364
    x2370 = x2365 + x2369
    x2371 = -x2370 * x6
    x2372 = x2367 * x3 + x2371
    x2373 = x172 * x2231
    x2374 = x2244 * x8
    x2375 = -x2374
    x2376 = x2373 + x2375
    x2377 = x2376 * x3
    x2378 = x172 * x2244
    x2379 = x2260 * x8
    x2380 = -x2379
    x2381 = x2378 + x2380
    x2382 = x2381 * x6
    x2383 = -x2382
    x2384 = x4 * (x2370 - x2373 + x2374)
    x2385 = -x2384
    x2386 = x2370 * x3
    x2387 = x2376 * x6
    x2388 = -x2387
    x2389 = x2386 + x2388
    x2390 = x2370 * x5
    x2391 = x2367 * x5 + x2371
    x2392 = x2388 + x2390
    x2393 = x2368 + x2391 * x3 - x2392 * x6
    x2394 = x2392 * x3
    x2395 = x2376 * x5
    x2396 = x2383 + x2395
    x2397 = x2396 * x6
    x2398 = x2384 + x2394 - x2397
    x2399 = x4 * (x2376 - x2378 + x2379)
    x2400 = -x2275 * x8
    x2401 = x172 * x2260 + x2400
    x2402 = x1014 * x1844
    x2403 = x1008 * x1844 + x1220
    x2404 = x4 * (x1224 - x2402 + x2403)
    x2405 = x1226 + x2402
    x2406 = -x2405 * x6
    x2407 = x2403 * x3 + x2406
    x2408 = x1022 * x1844
    x2409 = x1233 + x2408
    x2410 = x2409 * x3
    x2411 = x1034 * x1844
    x2412 = x1245 + x2411
    x2413 = x2412 * x6
    x2414 = -x2413
    x2415 = x4 * (x1238 + x2405 - x2408)
    x2416 = -x2415
    x2417 = x2405 * x3
    x2418 = x2409 * x6
    x2419 = -x2418
    x2420 = x2417 + x2419
    x2421 = x2405 * x5
    x2422 = x2403 * x5 + x2406
    x2423 = x2419 + x2421
    x2424 = x2404 + x2422 * x3 - x2423 * x6
    x2425 = x2423 * x3
    x2426 = x2409 * x5
    x2427 = x2414 + x2426
    x2428 = x2427 * x6
    x2429 = x2415 + x2425 - x2428
    x2430 = x4 * (x1251 + x2409 - x2411)
    x2431 = x1044 * x1844 + x1253
    x2432 = x172 * x2287
    x2433 = 3.0 * x2117 - x2287 * x8
    x2434 = x172 * x2281 + x2433
    x2435 = x2294 * x8
    x2436 = 3.0 * x2129
    x2437 = x2435 - x2436
    x2438 = x4 * (-x2432 + x2434 + x2437)
    x2439 = -x2435 + x2436
    x2440 = x2432 + x2439
    x2441 = x2434 * x3 - x2440 * x6
    x2442 = x2440 * x3
    x2443 = x172 * x2294
    x2444 = x2300 * x8
    x2445 = 3.0 * x2139
    x2446 = -x2444 + x2445
    x2447 = x2443 + x2446
    x2448 = x2447 * x6
    x2449 = x2442 - x2448
    x2450 = x2444 - x2445
    x2451 = x4 * (x2440 - x2443 + x2450)
    x2452 = 3.0 * x2159 - x2322 * x8
    x2453 = x172 * x2300 + x2452
    x2454 = x172 * x2330
    x2455 = 2.0 * x2182 - x2330 * x8
    x2456 = x172 * x2325 + x2455
    x2457 = x2336 * x8
    x2458 = 2.0 * x2193
    x2459 = x2457 - x2458
    x2460 = x4 * (-x2454 + x2456 + x2459)
    x2461 = -x2457 + x2458
    x2462 = x2454 + x2461
    x2463 = x2456 * x3 - x2462 * x6
    x2464 = x2462 * x3
    x2465 = x172 * x2336
    x2466 = x2341 * x8
    x2467 = 2.0 * x2202
    x2468 = -x2466 + x2467
    x2469 = x2465 + x2468
    x2470 = x2469 * x6
    x2471 = x2464 - x2470
    x2472 = x2466 - x2467
    x2473 = x4 * (x2462 - x2465 + x2472)
    x2474 = 2.0 * x2221 - x2363 * x8
    x2475 = x172 * x2341 + x2474
    x2476 = x172 * x2370
    x2477 = x2239 - x2370 * x8
    x2478 = x172 * x2367 + x2477
    x2479 = x2376 * x8
    x2480 = x2249 + x2479
    x2481 = x4 * (-x2476 + x2478 + x2480)
    x2482 = x2248 - x2479
    x2483 = x2476 + x2482
    x2484 = x2478 * x3 - x2483 * x6
    x2485 = x2483 * x3
    x2486 = x172 * x2376
    x2487 = x2381 * x8
    x2488 = x2257 - x2487
    x2489 = x2486 + x2488
    x2490 = x2489 * x6
    x2491 = x2485 - x2490
    x2492 = x2272 + x2487
    x2493 = x4 * (x2483 - x2486 + x2492)
    x2494 = x2274 - x2401 * x8
    x2495 = x172 * x2381 + x2494
    x2496 = x2409 * x8
    x2497 = x172 * x2405
    x2498 = -x2405 * x8
    x2499 = x172 * x2403 + x2498
    x2500 = x4 * (x2496 - x2497 + x2499)
    x2501 = -x2496
    x2502 = x2497 + x2501
    x2503 = x2499 * x3 - x2502 * x6
    x2504 = x2502 * x3
    x2505 = x172 * x2409
    x2506 = x2412 * x8
    x2507 = -x2506
    x2508 = x2505 + x2507
    x2509 = x2508 * x6
    x2510 = x2504 - x2509
    x2511 = x4 * (x2502 - x2505 + x2506)
    x2512 = -x2431 * x8
    x2513 = x172 * x2412 + x2512
    x2514 = x10 * x1234
    x2515 = x1227 * x1844
    x2516 = 4.0 * x1049
    x2517 = -x10 * x1227 + 4.0 * x1012 + x1221 * x1844
    x2518 = x4 * (x2514 - x2515 - x2516 + x2517)
    x2519 = -x2514 + x2515 + x2516
    x2520 = x2517 * x3 - x2519 * x6
    x2521 = x2519 * x3
    x2522 = x1234 * x1844
    x2523 = x10 * x1246
    x2524 = 4.0 * x1031
    x2525 = x2522 - x2523 + x2524
    x2526 = x2525 * x6
    x2527 = x2521 - x2526
    x2528 = x4 * (x2519 - x2522 + x2523 - x2524)
    x2529 = -x10 * x1254 + 4.0 * x1077 + x1246 * x1844
    x2530 = x1268 * x8
    x2531 = x1256 * x1262
    x2532 = x1256 * x1259
    x2533 = x1262 * x8
    x2534 = x19 + x2532 - x2533
    x2535 = x4 * (x2530 - x2531 + x2534 + x69)
    x2536 = x2534 * x5
    x2537 = -x2530 + x2531 + x29
    x2538 = x2537 * x6
    x2539 = x2536 - x2538
    x2540 = x2539 * x5
    x2541 = x2537 * x5
    x2542 = x1256 * x1268
    x2543 = x1278 * x8
    x2544 = x2542 - x2543 + x56
    x2545 = x2544 * x6
    x2546 = x2541 - x2545
    x2547 = x2546 * x6
    x2548 = x2535 + x2540 - x2547
    x2549 = x2548 * x5
    x2550 = x4 * (x2537 - x2542 + x2543 + x95)
    x2551 = x2546 * x5
    x2552 = x2544 * x5
    x2553 = x1256 * x1278
    x2554 = x1302 * x8
    x2555 = x2553 - x2554 + x82
    x2556 = x2555 * x6
    x2557 = x2552 - x2556
    x2558 = x2557 * x6
    x2559 = x2550 + x2551 - x2558
    x2560 = x2559 * x6
    x2561 = x38 * (x2539 - x2541 + x2545)
    x2562 = x2549 - x2560 + x2561
    x2563 = x2562 * x5
    x2564 = x1256 * x1288 - x1259 * x8 + x45
    x2565 = x4 * (-x2532 + x2533 + x2564 + x50)
    x2566 = -x2534 * x6 + x2564 * x5
    x2567 = -x2539 * x6 + x2565 + x2566 * x5
    x2568 = -x2548 * x6 + x2567 * x5 + x38 * (-x2536 + x2538 + x2566)
    x2569 = -x2535
    x2570 = x130 * (-x2540 + x2547 + x2567 + x2569) - x2562 * x6
    x2571 = x2568 * x5 + x2570
    x2572 = x2559 * x5
    x2573 = x4 * (x129 + x2544 - x2553 + x2554)
    x2574 = x2557 * x5
    x2575 = x2555 * x5
    x2576 = x1256 * x1302
    x2577 = x1326 * x8
    x2578 = x117 + x2576 - x2577
    x2579 = x2578 * x6
    x2580 = x2575 - x2579
    x2581 = x2580 * x6
    x2582 = x2573 + x2574 - x2581
    x2583 = x2582 * x6
    x2584 = x38 * (x2546 - x2552 + x2556)
    x2585 = x2572 - x2583 + x2584
    x2586 = x2585 * x6
    x2587 = -x2550
    x2588 = x130 * (x2548 - x2551 + x2558 + x2587)
    x2589 = x2586 - x2588
    x2590 = x2563 - x2586 + x2588
    x2591 = x4 * (x157 + x2555 - x2576 + x2577)
    x2592 = x1256 * x1326 - x1348 * x8 + x155
    x2593 = -x2573
    x2594 = x1364 * x8
    x2595 = x1256 * x1357
    x2596 = x1256 * x1354
    x2597 = x1357 * x8
    x2598 = x1260 + x184 + x2596 - x2597
    x2599 = x4 * (x1311 + x249 + x2594 - x2595 + x2598)
    x2600 = x2598 * x5
    x2601 = x1274 + x208 - x2594 + x2595
    x2602 = x2601 * x6
    x2603 = x2600 - x2602
    x2604 = x2603 * x5
    x2605 = x2601 * x5
    x2606 = x1256 * x1364
    x2607 = x1382 * x8
    x2608 = x1298 + x232 + x2606 - x2607
    x2609 = x2608 * x6
    x2610 = x2605 - x2609
    x2611 = x2610 * x6
    x2612 = x2599 + x2604 - x2611
    x2613 = x2612 * x5
    x2614 = x1256 * x1371 + x1289 - x1354 * x8 + x201
    x2615 = x4 * (x1294 + x225 - x2596 + x2597 + x2614)
    x2616 = -x2598 * x6 + x2614 * x5
    x2617 = -x2603 * x6 + x2615 + x2616 * x5
    x2618 = -x2612 * x6 + x38 * (-x2600 + x2602 + x2616)
    x2619 = x2617 * x5 + x2618
    x2620 = x4 * (x1335 + x2601 - x2606 + x2607 + x279)
    x2621 = x2610 * x5
    x2622 = x2608 * x5
    x2623 = x1256 * x1382
    x2624 = x1401 * x8
    x2625 = x1322 + x2623 - x2624 + x263
    x2626 = x2625 * x6
    x2627 = x2622 - x2626
    x2628 = x2627 * x6
    x2629 = x2620 + x2621 - x2628
    x2630 = x2629 * x6
    x2631 = x38 * (x2603 - x2605 + x2609)
    x2632 = x2630 - x2631
    x2633 = x2613 - x2630 + x2631
    x2634 = x4 * (x1349 + x2608 - x2623 + x2624 + x303)
    x2635 = x1256 * x1401 + x1347 - x1419 * x8 + x300
    x2636 = x1434 * x8
    x2637 = x1256 * x1427
    x2638 = x1256 * x1424
    x2639 = x1427 * x8
    x2640 = x2638 - x2639 + x330
    x2641 = x4 * (x2636 - x2637 + x2640 + x395)
    x2642 = x2640 * x5
    x2643 = -x2636 + x2637 + x354
    x2644 = x2643 * x6
    x2645 = x2642 - x2644
    x2646 = x2645 * x5
    x2647 = x2643 * x5
    x2648 = x1256 * x1434
    x2649 = x1452 * x8
    x2650 = x2648 - x2649 + x378
    x2651 = x2650 * x6
    x2652 = x2647 - x2651
    x2653 = x2652 * x6
    x2654 = x2641 + x2646 - x2653
    x2655 = x2654 * x5
    x2656 = x1256 * x1441 - x1424 * x8 + x347
    x2657 = x4 * (-x2638 + x2639 + x2656 + x371)
    x2658 = -x2640 * x6 + x2656 * x5
    x2659 = -x2645 * x6 + x2657 + x2658 * x5
    x2660 = -x2654 * x6 + x38 * (-x2642 + x2644 + x2658)
    x2661 = x2659 * x5 + x2660
    x2662 = x4 * (x2643 - x2648 + x2649 + x425)
    x2663 = x2652 * x5
    x2664 = x2650 * x5
    x2665 = x1256 * x1452
    x2666 = x1472 * x8
    x2667 = x2665 - x2666 + x409
    x2668 = x2667 * x6
    x2669 = x2664 - x2668
    x2670 = x2669 * x6
    x2671 = x2662 + x2663 - x2670
    x2672 = x2671 * x6
    x2673 = x38 * (x2645 - x2647 + x2651)
    x2674 = x2672 - x2673
    x2675 = x2655 - x2672 + x2673
    x2676 = -x2641
    x2677 = x4 * (x2650 - x2665 + x2666 + x449)
    x2678 = x1256 * x1472 - x1491 * x8 + x446
    x2679 = -x2662
    x2680 = x1256 * x1497
    x2681 = x1500 * x8
    x2682 = 2.0 * x1361
    x2683 = x2680 - x2681 + x2682 + x493
    x2684 = x2683 * x5
    x2685 = x1256 * x1500
    x2686 = x1513 * x8
    x2687 = 2.0 * x1378
    x2688 = x2685 - x2686 + x2687 + x503
    x2689 = x2688 * x6
    x2690 = x2684 - x2689
    x2691 = x2690 * x5
    x2692 = 2.0 * x1373
    x2693 = x1256 * x1505 - x1497 * x8 + x2692 + x480
    x2694 = -x2683 * x6 + x2693 * x5
    x2695 = -x2682
    x2696 = x4 * (-x2680 + x2681 + x2693 + x2695 + x494)
    x2697 = -x2690 * x6 + x2696
    x2698 = x2694 * x5 + x2697
    x2699 = x2688 * x5
    x2700 = x1256 * x1513
    x2701 = x1528 * x8
    x2702 = 2.0 * x1397
    x2703 = x2700 - x2701 + x2702 + x530
    x2704 = x2703 * x6
    x2705 = x2699 - x2704
    x2706 = x2705 * x6
    x2707 = -x2687
    x2708 = x4 * (x2683 - x2685 + x2686 + x2707 + x523)
    x2709 = x2706 - x2708
    x2710 = x2691 - x2706 + x2708
    x2711 = -x2702
    x2712 = x4 * (x2688 - x2700 + x2701 + x2711 + x559)
    x2713 = 2.0 * x1418
    x2714 = x1256 * x1528 - x1542 * x8 + x2713 + x562
    x2715 = x1256 * x1547
    x2716 = x1550 * x8
    x2717 = x1431 + x2715 - x2716 + x604
    x2718 = x2717 * x5
    x2719 = x1256 * x1550
    x2720 = x1563 * x8
    x2721 = x1448 + x2719 - x2720 + x613
    x2722 = x2721 * x6
    x2723 = x2718 - x2722
    x2724 = x2723 * x5
    x2725 = x1256 * x1555 + x1443 - x1547 * x8 + x592
    x2726 = -x2717 * x6 + x2725 * x5
    x2727 = x4 * (x1462 - x2715 + x2716 + x2725 + x605)
    x2728 = -x2723 * x6 + x2727
    x2729 = x2726 * x5 + x2728
    x2730 = x2721 * x5
    x2731 = x1256 * x1563
    x2732 = x1578 * x8
    x2733 = x1468 + x2731 - x2732 + x639
    x2734 = x2733 * x6
    x2735 = x2730 - x2734
    x2736 = x2735 * x6
    x2737 = x4 * (x1482 + x2717 - x2719 + x2720 + x633)
    x2738 = x2736 - x2737
    x2739 = x2724 - x2736 + x2737
    x2740 = x4 * (x1492 + x2721 - x2731 + x2732 + x668)
    x2741 = x1256 * x1578 + x1490 - x1592 * x8 + x670
    x2742 = x1256 * x1597
    x2743 = x1600 * x8
    x2744 = x2742 - x2743 + x714
    x2745 = x2744 * x5
    x2746 = x1256 * x1600
    x2747 = x1613 * x8
    x2748 = x2746 - x2747 + x724
    x2749 = x2748 * x6
    x2750 = x2745 - x2749
    x2751 = x2750 * x5
    x2752 = x1256 * x1605 - x1597 * x8 + x701
    x2753 = -x2744 * x6 + x2752 * x5
    x2754 = x4 * (-x2742 + x2743 + x2752 + x715)
    x2755 = -x2750 * x6 + x2754
    x2756 = x2753 * x5 + x2755
    x2757 = x2748 * x5
    x2758 = x1256 * x1613
    x2759 = x1629 * x8
    x2760 = x2758 - x2759 + x751
    x2761 = x2760 * x6
    x2762 = x2757 - x2761
    x2763 = x2762 * x6
    x2764 = x4 * (x2744 - x2746 + x2747 + x744)
    x2765 = -x2764
    x2766 = x2763 + x2765
    x2767 = x2751 - x2763 + x2764
    x2768 = x4 * (x2748 - x2758 + x2759 + x780)
    x2769 = x1256 * x1629 - x1644 * x8 + x783
    x2770 = x1256 * x1649 + 3.0 * x1508 - x1651 * x8 + x802
    x2771 = x1256 * x1655
    x2772 = x1658 * x8
    x2773 = 3.0 * x1525
    x2774 = x2771 - x2772 + x2773 + x821
    x2775 = x2774 * x6
    x2776 = x1256 * x1651
    x2777 = x1655 * x8
    x2778 = 3.0 * x1517
    x2779 = x2776 - x2777 + x2778 + x839
    x2780 = -x2779 * x6
    x2781 = x2779 * x5
    x2782 = x2770 * x5 + x2780
    x2783 = x4 * (x2770 - x2776 + x2777 - x2778 + x845)
    x2784 = -x2775 + x2781
    x2785 = x4 * (-x2771 + x2772 - x2773 + x2779 + x865)
    x2786 = x1256 * x1658 + 3.0 * x1541 - x1677 * x8 + x867
    x2787 = 2.0 * x1558
    x2788 = x1256 * x1679 - x1681 * x8 + x2787 + x875
    x2789 = x1256 * x1685
    x2790 = x1688 * x8
    x2791 = 2.0 * x1575
    x2792 = x2789 - x2790 + x2791 + x892
    x2793 = x2792 * x6
    x2794 = x1256 * x1681
    x2795 = x1685 * x8
    x2796 = 2.0 * x1567
    x2797 = x2794 - x2795 + x2796 + x909
    x2798 = -x2797 * x6
    x2799 = x2797 * x5
    x2800 = x2788 * x5 + x2798
    x2801 = -x2796
    x2802 = x4 * (x2788 - x2794 + x2795 + x2801 + x915)
    x2803 = -x2793 + x2799
    x2804 = -x2791
    x2805 = x4 * (-x2789 + x2790 + x2797 + x2804 + x935)
    x2806 = 2.0 * x1591
    x2807 = x1256 * x1688 - x1707 * x8 + x2806 + x937
    x2808 = x1256 * x1709 + x1608 - x1711 * x8 + x944
    x2809 = x1256 * x1715
    x2810 = x1718 * x8
    x2811 = x1626 + x2809 - x2810 + x960
    x2812 = x2811 * x6
    x2813 = x1256 * x1711
    x2814 = x1715 * x8
    x2815 = x1617 + x2813 - x2814 + x976
    x2816 = -x2815 * x6
    x2817 = x2815 * x5
    x2818 = x2808 * x5 + x2816
    x2819 = x4 * (x1618 + x2808 - x2813 + x2814 + x982)
    x2820 = -x2812 + x2817
    x2821 = x4 * (x1002 + x1641 - x2809 + x2810 + x2815)
    x2822 = x1003 + x1256 * x1718 + x1643 - x1737 * x8
    x2823 = x1012 + x1256 * x1739 - x1741 * x8
    x2824 = x1256 * x1745
    x2825 = x1748 * x8
    x2826 = x1031 + x2824 - x2825
    x2827 = x2826 * x6
    x2828 = x1256 * x1741
    x2829 = x1745 * x8
    x2830 = x1049 + x2828 - x2829
    x2831 = -x2830 * x6
    x2832 = x2830 * x5
    x2833 = x2823 * x5 + x2831
    x2834 = x4 * (x1055 + x2823 - x2828 + x2829)
    x2835 = -x2827 + x2832
    x2836 = x4 * (x1075 - x2824 + x2825 + x2830)
    x2837 = x1077 + x1256 * x1748 - x1767 * x8
    x2838 = x1779 * x8
    x2839 = x1256 * x1773
    x2840 = 4.0 * x1661
    x2841 = x1086 + x1256 * x1771 + 4.0 * x1650 - x1773 * x8
    x2842 = x4 * (x1116 + x2838 - x2839 - x2840 + x2841)
    x2843 = x1100 - x2838 + x2839 + x2840
    x2844 = x1113 + x1256 * x1779 + 4.0 * x1676 - x1783 * x8
    x2845 = x1795 * x8
    x2846 = x1256 * x1789
    x2847 = 3.0 * x1691
    x2848 = x1123 + x1256 * x1787 + 3.0 * x1680 - x1789 * x8
    x2849 = x4 * (x1153 + x2845 - x2846 - x2847 + x2848)
    x2850 = x1137 - x2845 + x2846 + x2847
    x2851 = x1150 + x1256 * x1795 + 3.0 * x1706 - x1799 * x8
    x2852 = x1811 * x8
    x2853 = x1256 * x1805
    x2854 = 2.0 * x1721
    x2855 = -x2854
    x2856 = 2.0 * x1710
    x2857 = x1159 + x1256 * x1803 - x1805 * x8 + x2856
    x2858 = x4 * (x1187 + x2852 - x2853 + x2855 + x2857)
    x2859 = x1172 - x2852 + x2853 + x2854
    x2860 = 2.0 * x1736
    x2861 = x1184 + x1256 * x1811 - x1815 * x8 + x2860
    x2862 = x1825 * x8
    x2863 = x1256 * x1820
    x2864 = x1192 + x1256 * x1818 + x1740 - x1820 * x8
    x2865 = x4 * (x1218 + x1752 + x2862 - x2863 + x2864)
    x2866 = x1204 + x1751 - x2862 + x2863
    x2867 = x1215 + x1256 * x1825 + x1766 - x1829 * x8
    x2868 = x1839 * x8
    x2869 = x1256 * x1834
    x2870 = x1225 + x1256 * x1832 - x1834 * x8
    x2871 = x4 * (x1255 + x2868 - x2869 + x2870)
    x2872 = x1239 - x2868 + x2869
    x2873 = x1252 + x1256 * x1839 - x1843 * x8
    x2874 = x1256 * x1850
    x2875 = x1256 * x1847
    x2876 = x1943 + x2875
    x2877 = x4 * (x1947 - x2874 + x2876)
    x2878 = x2876 * x5
    x2879 = x1948 + x2874
    x2880 = x2879 * x6
    x2881 = x2878 - x2880
    x2882 = x2881 * x5
    x2883 = x2879 * x5
    x2884 = x1256 * x1856
    x2885 = x1957 + x2884
    x2886 = x2885 * x6
    x2887 = x2883 - x2886
    x2888 = x2887 * x6
    x2889 = x2877 + x2882 - x2888
    x2890 = x2889 * x5
    x2891 = x4 * (x1956 + x2879 - x2884)
    x2892 = x2887 * x5
    x2893 = x2885 * x5
    x2894 = x1256 * x1866
    x2895 = x1978 + x2894
    x2896 = x2895 * x6
    x2897 = x2893 - x2896
    x2898 = x2897 * x6
    x2899 = x2891 + x2892 - x2898
    x2900 = x2899 * x6
    x2901 = x38 * (x2881 - x2883 + x2886)
    x2902 = x2890 - x2900 + x2901
    x2903 = x2902 * x5
    x2904 = x1256 * x1876 + x1965
    x2905 = x4 * (x1942 - x2875 + x2904)
    x2906 = -x2876 * x6 + x2904 * x5
    x2907 = -x2881 * x6 + x2905 + x2906 * x5
    x2908 = -x2889 * x6 + x2907 * x5 + x38 * (-x2878 + x2880 + x2906)
    x2909 = -x2877
    x2910 = x130 * (-x2882 + x2888 + x2907 + x2909) - x2902 * x6
    x2911 = x2908 * x5 + x2910
    x2912 = x2899 * x5
    x2913 = x4 * (x1977 + x2885 - x2894)
    x2914 = x2897 * x5
    x2915 = x2895 * x5
    x2916 = x1256 * x1890
    x2917 = x2000 + x2916
    x2918 = x2917 * x6
    x2919 = x2915 - x2918
    x2920 = x2919 * x6
    x2921 = x2913 + x2914 - x2920
    x2922 = x2921 * x6
    x2923 = x38 * (x2887 - x2893 + x2896)
    x2924 = x2912 - x2922 + x2923
    x2925 = x2924 * x6
    x2926 = -x2891
    x2927 = x130 * (x2889 - x2892 + x2898 + x2926)
    x2928 = x2925 - x2927
    x2929 = x2903 - x2925 + x2927
    x2930 = x4 * (x1999 + x2895 - x2916)
    x2931 = x1256 * x1914 + x2020
    x2932 = -x2913
    x2933 = x1256 * x1949
    x2934 = x1256 * x1944
    x2935 = x2101 + x2934
    x2936 = x4 * (x2128 - x2933 + x2935)
    x2937 = x2935 * x5
    x2938 = x2106 + x2933
    x2939 = x2938 * x6
    x2940 = x2937 - x2939
    x2941 = x2940 * x5
    x2942 = x2938 * x5
    x2943 = x1256 * x1958
    x2944 = x2123 + x2943
    x2945 = x2944 * x6
    x2946 = x2942 - x2945
    x2947 = x2946 * x6
    x2948 = x2936 + x2941 - x2947
    x2949 = x2948 * x5
    x2950 = x1256 * x1966 + x2112
    x2951 = x4 * (x2116 - x2934 + x2950)
    x2952 = -x2935 * x6 + x2950 * x5
    x2953 = -x2940 * x6 + x2951 + x2952 * x5
    x2954 = -x2948 * x6 + x38 * (-x2937 + x2939 + x2952)
    x2955 = x2953 * x5 + x2954
    x2956 = x4 * (x2138 + x2938 - x2943)
    x2957 = x2946 * x5
    x2958 = x2944 * x5
    x2959 = x1256 * x1979
    x2960 = x2143 + x2959
    x2961 = x2960 * x6
    x2962 = x2958 - x2961
    x2963 = x2962 * x6
    x2964 = x2956 + x2957 - x2963
    x2965 = x2964 * x6
    x2966 = x38 * (x2940 - x2942 + x2945)
    x2967 = x2965 - x2966
    x2968 = x2949 - x2965 + x2966
    x2969 = x4 * (x2158 + x2944 - x2959)
    x2970 = x1256 * x2001 + x2160
    x2971 = x1256 * x2030
    x2972 = x1256 * x2027
    x2973 = x2167 + x2972
    x2974 = x4 * (x2171 - x2971 + x2973)
    x2975 = x2973 * x5
    x2976 = x2172 + x2971
    x2977 = x2976 * x6
    x2978 = x2975 - x2977
    x2979 = x2978 * x5
    x2980 = x2976 * x5
    x2981 = x1256 * x2037
    x2982 = x2188 + x2981
    x2983 = x2982 * x6
    x2984 = x2980 - x2983
    x2985 = x2984 * x6
    x2986 = x2974 + x2979 - x2985
    x2987 = x2986 * x5
    x2988 = x1256 * x2044 + x2178
    x2989 = x4 * (x2166 - x2972 + x2988)
    x2990 = -x2973 * x6 + x2988 * x5
    x2991 = -x2978 * x6 + x2989 + x2990 * x5
    x2992 = -x2986 * x6 + x38 * (-x2975 + x2977 + x2990)
    x2993 = x2991 * x5 + x2992
    x2994 = x4 * (x2187 + x2976 - x2981)
    x2995 = x2984 * x5
    x2996 = x2982 * x5
    x2997 = x1256 * x2055
    x2998 = x2206 + x2997
    x2999 = x2998 * x6
    x3000 = x2996 - x2999
    x3001 = x3000 * x6
    x3002 = x2994 + x2995 - x3001
    x3003 = x3002 * x6
    x3004 = x38 * (x2978 - x2980 + x2983)
    x3005 = x3003 - x3004
    x3006 = x2987 - x3003 + x3004
    x3007 = -x2974
    x3008 = x4 * (x2205 + x2982 - x2997)
    x3009 = x1256 * x2075 + x2222
    x3010 = -x2994
    x3011 = x1256 * x2102
    x3012 = x2286 + x3011
    x3013 = x3012 * x5
    x3014 = x1256 * x2107
    x3015 = x2293 + x3014
    x3016 = x3015 * x6
    x3017 = x3013 - x3016
    x3018 = x3017 * x5
    x3019 = x1256 * x2113 + x2280
    x3020 = -x3012 * x6 + x3019 * x5
    x3021 = x4 * (x2284 - x3011 + x3019)
    x3022 = -x3017 * x6 + x3021
    x3023 = x3020 * x5 + x3022
    x3024 = x3015 * x5
    x3025 = x1256 * x2124
    x3026 = x2299 + x3025
    x3027 = x3026 * x6
    x3028 = x3024 - x3027
    x3029 = x3028 * x6
    x3030 = x4 * (x2303 + x3012 - x3014)
    x3031 = x3029 - x3030
    x3032 = x3018 - x3029 + x3030
    x3033 = x4 * (x2319 + x3015 - x3025)
    x3034 = x1256 * x2144 + x2321
    x3035 = x1256 * x2168
    x3036 = x2329 + x3035
    x3037 = x3036 * x5
    x3038 = x1256 * x2173
    x3039 = x2335 + x3038
    x3040 = x3039 * x6
    x3041 = x3037 - x3040
    x3042 = x3041 * x5
    x3043 = x1256 * x2179 + x2324
    x3044 = -x3036 * x6 + x3043 * x5
    x3045 = x4 * (x2327 - x3035 + x3043)
    x3046 = -x3041 * x6 + x3045
    x3047 = x3044 * x5 + x3046
    x3048 = x3039 * x5
    x3049 = x1256 * x2189
    x3050 = x2340 + x3049
    x3051 = x3050 * x6
    x3052 = x3048 - x3051
    x3053 = x3052 * x6
    x3054 = x4 * (x2344 + x3036 - x3038)
    x3055 = x3053 - x3054
    x3056 = x3042 - x3053 + x3054
    x3057 = x4 * (x2360 + x3039 - x3049)
    x3058 = x1256 * x2207 + x2362
    x3059 = x1256 * x2228
    x3060 = x2369 + x3059
    x3061 = x3060 * x5
    x3062 = x1256 * x2231
    x3063 = x2375 + x3062
    x3064 = x3063 * x6
    x3065 = x3061 - x3064
    x3066 = x3065 * x5
    x3067 = x1256 * x2236 + x2366
    x3068 = -x3060 * x6 + x3067 * x5
    x3069 = x4 * (x2364 - x3059 + x3067)
    x3070 = -x3065 * x6 + x3069
    x3071 = x3068 * x5 + x3070
    x3072 = x3063 * x5
    x3073 = x1256 * x2244
    x3074 = x2380 + x3073
    x3075 = x3074 * x6
    x3076 = x3072 - x3075
    x3077 = x3076 * x6
    x3078 = x4 * (x2374 + x3060 - x3062)
    x3079 = -x3078
    x3080 = x3077 + x3079
    x3081 = x3066 - x3077 + x3078
    x3082 = x4 * (x2379 + x3063 - x3073)
    x3083 = x1256 * x2260 + x2400
    x3084 = x1256 * x2281 + x2433
    x3085 = x1256 * x2294
    x3086 = x2446 + x3085
    x3087 = x3086 * x6
    x3088 = x1256 * x2287
    x3089 = x2439 + x3088
    x3090 = -x3089 * x6
    x3091 = x3089 * x5
    x3092 = x3084 * x5 + x3090
    x3093 = x4 * (x2437 + x3084 - x3088)
    x3094 = -x3087 + x3091
    x3095 = x4 * (x2450 - x3085 + x3089)
    x3096 = x1256 * x2300 + x2452
    x3097 = x1256 * x2325 + x2455
    x3098 = x1256 * x2336
    x3099 = x2468 + x3098
    x3100 = x3099 * x6
    x3101 = x1256 * x2330
    x3102 = x2461 + x3101
    x3103 = -x3102 * x6
    x3104 = x3102 * x5
    x3105 = x3097 * x5 + x3103
    x3106 = x4 * (x2459 + x3097 - x3101)
    x3107 = -x3100 + x3104
    x3108 = x4 * (x2472 - x3098 + x3102)
    x3109 = x1256 * x2341 + x2474
    x3110 = x1256 * x2367 + x2477
    x3111 = x1256 * x2376
    x3112 = x2488 + x3111
    x3113 = x3112 * x6
    x3114 = x1256 * x2370
    x3115 = x2482 + x3114
    x3116 = -x3115 * x6
    x3117 = x3115 * x5
    x3118 = x3110 * x5 + x3116
    x3119 = x4 * (x2480 + x3110 - x3114)
    x3120 = -x3113 + x3117
    x3121 = x4 * (x2492 - x3111 + x3115)
    x3122 = x1256 * x2381 + x2494
    x3123 = x1256 * x2403 + x2498
    x3124 = x1256 * x2409
    x3125 = x2507 + x3124
    x3126 = x3125 * x6
    x3127 = x1256 * x2405
    x3128 = x2501 + x3127
    x3129 = -x3128 * x6
    x3130 = x3128 * x5
    x3131 = x3123 * x5 + x3129
    x3132 = x4 * (x2496 + x3123 - x3127)
    x3133 = -x3126 + x3130
    x3134 = x4 * (x2506 - x3124 + x3128)
    x3135 = x1256 * x2412 + x2512
    x3136 = x2447 * x8
    x3137 = x1256 * x2440
    x3138 = 4.0 * x2304
    x3139 = x1256 * x2434 + 4.0 * x2285 - x2440 * x8
    x3140 = x4 * (x3136 - x3137 - x3138 + x3139)
    x3141 = -x3136 + x3137 + x3138
    x3142 = x1256 * x2447 + 4.0 * x2320 - x2453 * x8
    x3143 = x2469 * x8
    x3144 = x1256 * x2462
    x3145 = 3.0 * x2345
    x3146 = x1256 * x2456 + 3.0 * x2328 - x2462 * x8
    x3147 = x4 * (x3143 - x3144 - x3145 + x3146)
    x3148 = -x3143 + x3144 + x3145
    x3149 = x1256 * x2469 + 3.0 * x2361 - x2475 * x8
    x3150 = x2489 * x8
    x3151 = x1256 * x2483
    x3152 = 2.0 * x2384
    x3153 = x1256 * x2478 + 2.0 * x2368 - x2483 * x8
    x3154 = x4 * (x3150 - x3151 - x3152 + x3153)
    x3155 = -x3150 + x3151 + x3152
    x3156 = x1256 * x2489 + 2.0 * x2399 - x2495 * x8
    x3157 = x2508 * x8
    x3158 = x1256 * x2502
    x3159 = x1256 * x2499 + x2404 - x2502 * x8
    x3160 = x4 * (x2416 + x3157 - x3158 + x3159)
    x3161 = x2415 - x3157 + x3158
    x3162 = x1256 * x2508 + x2430 - x2513 * x8
    x3163 = x2525 * x8
    x3164 = x1256 * x2519
    x3165 = x1256 * x2517 - x2519 * x8
    x3166 = x4 * (x3163 - x3164 + x3165)
    x3167 = -x3163 + x3164
    x3168 = x1256 * x2525 - x2529 * x8
    x3169 = x10 * x1856
    x3170 = x1844 * x1850
    x3171 = x1844 * x1847
    x3172 = x10 * x1850
    x3173 = x19 + x3171 - x3172
    x3174 = x4 * (x3169 - x3170 + x3173 + x69)
    x3175 = x3173 * x5
    x3176 = x29 - x3169 + x3170
    x3177 = x3176 * x6
    x3178 = x3175 - x3177
    x3179 = x3178 * x5
    x3180 = x3176 * x5
    x3181 = x1844 * x1856
    x3182 = x10 * x1866
    x3183 = x3181 - x3182 + x56
    x3184 = x3183 * x6
    x3185 = x3180 - x3184
    x3186 = x3185 * x6
    x3187 = x3174 + x3179 - x3186
    x3188 = x3187 * x5
    x3189 = x4 * (x3176 - x3181 + x3182 + x95)
    x3190 = x3185 * x5
    x3191 = x3183 * x5
    x3192 = x1844 * x1866
    x3193 = x10 * x1890
    x3194 = x3192 - x3193 + x82
    x3195 = x3194 * x6
    x3196 = x3191 - x3195
    x3197 = x3196 * x6
    x3198 = x3189 + x3190 - x3197
    x3199 = x3198 * x6
    x3200 = x38 * (x3178 - x3180 + x3184)
    x3201 = x3188 - x3199 + x3200
    x3202 = x3201 * x5
    x3203 = -x10 * x1847 + x1844 * x1876 + x45
    x3204 = x4 * (-x3171 + x3172 + x3203 + x50)
    x3205 = -x3173 * x6 + x3203 * x5
    x3206 = -x3178 * x6 + x3204 + x3205 * x5
    x3207 = -x3187 * x6 + x3206 * x5 + x38 * (-x3175 + x3177 + x3205)
    x3208 = -x3174
    x3209 = x130 * (-x3179 + x3186 + x3206 + x3208) - x3201 * x6
    x3210 = x3207 * x5 + x3209
    x3211 = x3198 * x5
    x3212 = x4 * (x129 + x3183 - x3192 + x3193)
    x3213 = x3196 * x5
    x3214 = x3194 * x5
    x3215 = x1844 * x1890
    x3216 = x10 * x1914
    x3217 = x117 + x3215 - x3216
    x3218 = x3217 * x6
    x3219 = x3214 - x3218
    x3220 = x3219 * x6
    x3221 = x3212 + x3213 - x3220
    x3222 = x3221 * x6
    x3223 = x38 * (x3185 - x3191 + x3195)
    x3224 = x3211 - x3222 + x3223
    x3225 = x3224 * x6
    x3226 = -x3189
    x3227 = x130 * (x3187 - x3190 + x3197 + x3226)
    x3228 = x3225 - x3227
    x3229 = x3202 - x3225 + x3227
    x3230 = x4 * (x157 + x3194 - x3215 + x3216)
    x3231 = -x10 * x1936 + x155 + x1844 * x1914
    x3232 = -x3212
    x3233 = x3183 * x8
    x3234 = x172 * x3176
    x3235 = x172 * x3173
    x3236 = x3176 * x8
    x3237 = -x3236
    x3238 = x3235 + x3237
    x3239 = x4 * (x3233 - x3234 + x3238)
    x3240 = x3238 * x5
    x3241 = -x3233
    x3242 = x3234 + x3241
    x3243 = x3242 * x6
    x3244 = x3240 - x3243
    x3245 = x3244 * x5
    x3246 = x3242 * x5
    x3247 = x172 * x3183
    x3248 = x3194 * x8
    x3249 = -x3248
    x3250 = x3247 + x3249
    x3251 = x3250 * x6
    x3252 = x3246 - x3251
    x3253 = x3252 * x6
    x3254 = x3239 + x3245 - x3253
    x3255 = x3254 * x5
    x3256 = -x3173 * x8
    x3257 = x172 * x3203 + x3256
    x3258 = x4 * (-x3235 + x3236 + x3257)
    x3259 = -x3238 * x6 + x3257 * x5
    x3260 = -x3244 * x6 + x3258 + x3259 * x5
    x3261 = -x3254 * x6 + x38 * (-x3240 + x3243 + x3259)
    x3262 = x3260 * x5 + x3261
    x3263 = x4 * (x3242 - x3247 + x3248)
    x3264 = x3252 * x5
    x3265 = x3250 * x5
    x3266 = x172 * x3194
    x3267 = x3217 * x8
    x3268 = -x3267
    x3269 = x3266 + x3268
    x3270 = x3269 * x6
    x3271 = x3265 - x3270
    x3272 = x3271 * x6
    x3273 = x3263 + x3264 - x3272
    x3274 = x3273 * x6
    x3275 = x38 * (x3244 - x3246 + x3251)
    x3276 = x3274 - x3275
    x3277 = x3255 - x3274 + x3275
    x3278 = -x3239
    x3279 = x4 * (x3250 - x3266 + x3267)
    x3280 = -x3231 * x8
    x3281 = x172 * x3217 + x3280
    x3282 = -x3263
    x3283 = x10 * x2037
    x3284 = x1844 * x2030
    x3285 = x1844 * x2027
    x3286 = x10 * x2030
    x3287 = x1848 + x3285 - x3286 + x330
    x3288 = x4 * (x1899 + x3283 - x3284 + x3287 + x395)
    x3289 = x3287 * x5
    x3290 = x1862 - x3283 + x3284 + x354
    x3291 = x3290 * x6
    x3292 = x3289 - x3291
    x3293 = x3292 * x5
    x3294 = x3290 * x5
    x3295 = x1844 * x2037
    x3296 = x10 * x2055
    x3297 = x1886 + x3295 - x3296 + x378
    x3298 = x3297 * x6
    x3299 = x3294 - x3298
    x3300 = x3299 * x6
    x3301 = x3288 + x3293 - x3300
    x3302 = x3301 * x5
    x3303 = -x10 * x2027 + x1844 * x2044 + x1877 + x347
    x3304 = x4 * (x1882 - x3285 + x3286 + x3303 + x371)
    x3305 = -x3287 * x6 + x3303 * x5
    x3306 = -x3292 * x6 + x3304 + x3305 * x5
    x3307 = -x3301 * x6 + x38 * (-x3289 + x3291 + x3305)
    x3308 = x3306 * x5 + x3307
    x3309 = x4 * (x1923 + x3290 - x3295 + x3296 + x425)
    x3310 = x3299 * x5
    x3311 = x3297 * x5
    x3312 = x1844 * x2055
    x3313 = x10 * x2075
    x3314 = x1910 + x3312 - x3313 + x409
    x3315 = x3314 * x6
    x3316 = x3311 - x3315
    x3317 = x3316 * x6
    x3318 = x3309 + x3310 - x3317
    x3319 = x3318 * x6
    x3320 = x38 * (x3292 - x3294 + x3298)
    x3321 = x3319 - x3320
    x3322 = x3302 - x3319 + x3320
    x3323 = -x3288
    x3324 = x4 * (x1937 + x3297 - x3312 + x3313 + x449)
    x3325 = -x10 * x2094 + x1844 * x2075 + x1935 + x446
    x3326 = -x3309
    x3327 = x172 * x3238
    x3328 = x3242 * x8
    x3329 = x3174 - x3328
    x3330 = x3327 + x3329
    x3331 = x3330 * x5
    x3332 = x172 * x3242
    x3333 = x3250 * x8
    x3334 = x3189 - x3333
    x3335 = x3332 + x3334
    x3336 = x3335 * x6
    x3337 = x3331 - x3336
    x3338 = x3337 * x5
    x3339 = x3204 - x3238 * x8
    x3340 = x172 * x3257 + x3339
    x3341 = -x3330 * x6 + x3340 * x5
    x3342 = x3208 + x3328
    x3343 = x4 * (-x3327 + x3340 + x3342)
    x3344 = -x3337 * x6 + x3343
    x3345 = x3341 * x5 + x3344
    x3346 = x3335 * x5
    x3347 = x172 * x3250
    x3348 = x3269 * x8
    x3349 = x3212 - x3348
    x3350 = x3347 + x3349
    x3351 = x3350 * x6
    x3352 = x3346 - x3351
    x3353 = x3352 * x6
    x3354 = x3226 + x3333
    x3355 = x4 * (x3330 - x3332 + x3354)
    x3356 = -x3355
    x3357 = x3353 + x3356
    x3358 = x3338 - x3353 + x3355
    x3359 = x3232 + x3348
    x3360 = x4 * (x3335 - x3347 + x3359)
    x3361 = x3230 - x3281 * x8
    x3362 = x172 * x3269 + x3361
    x3363 = x172 * x3287
    x3364 = x3290 * x8
    x3365 = -x3364
    x3366 = x3363 + x3365
    x3367 = x3366 * x5
    x3368 = x172 * x3290
    x3369 = x3297 * x8
    x3370 = -x3369
    x3371 = x3368 + x3370
    x3372 = x3371 * x6
    x3373 = x3367 - x3372
    x3374 = x3373 * x5
    x3375 = -x3287 * x8
    x3376 = x172 * x3303 + x3375
    x3377 = -x3366 * x6 + x3376 * x5
    x3378 = x4 * (-x3363 + x3364 + x3376)
    x3379 = -x3373 * x6 + x3378
    x3380 = x3377 * x5 + x3379
    x3381 = x3371 * x5
    x3382 = x172 * x3297
    x3383 = x3314 * x8
    x3384 = -x3383
    x3385 = x3382 + x3384
    x3386 = x3385 * x6
    x3387 = x3381 - x3386
    x3388 = x3387 * x6
    x3389 = x4 * (x3366 - x3368 + x3369)
    x3390 = -x3389
    x3391 = x3388 + x3390
    x3392 = x3374 - x3388 + x3389
    x3393 = x4 * (x3371 - x3382 + x3383)
    x3394 = -x3325 * x8
    x3395 = x172 * x3314 + x3394
    x3396 = x1844 * x2228
    x3397 = x10 * x2231
    x3398 = 2.0 * x2034
    x3399 = x3396 - x3397 + x3398 + x714
    x3400 = x3399 * x5
    x3401 = x1844 * x2231
    x3402 = x10 * x2244
    x3403 = 2.0 * x2051
    x3404 = x3401 - x3402 + x3403 + x724
    x3405 = x3404 * x6
    x3406 = x3400 - x3405
    x3407 = x3406 * x5
    x3408 = 2.0 * x2046
    x3409 = -x10 * x2228 + x1844 * x2236 + x3408 + x701
    x3410 = -x3399 * x6 + x3409 * x5
    x3411 = -x3398
    x3412 = x4 * (-x3396 + x3397 + x3409 + x3411 + x715)
    x3413 = -x3406 * x6 + x3412
    x3414 = x3410 * x5 + x3413
    x3415 = x3404 * x5
    x3416 = x1844 * x2244
    x3417 = x10 * x2260
    x3418 = 2.0 * x2071
    x3419 = x3416 - x3417 + x3418 + x751
    x3420 = x3419 * x6
    x3421 = x3415 - x3420
    x3422 = x3421 * x6
    x3423 = -x3403
    x3424 = x4 * (x3399 - x3401 + x3402 + x3423 + x744)
    x3425 = -x3424
    x3426 = x3422 + x3425
    x3427 = x3407 - x3422 + x3424
    x3428 = -x3418
    x3429 = x4 * (x3404 - x3416 + x3417 + x3428 + x780)
    x3430 = 2.0 * x2093
    x3431 = -x10 * x2275 + x1844 * x2260 + x3430 + x783
    x3432 = 2.0 * x3258 - x3330 * x8
    x3433 = x172 * x3340 + x3432
    x3434 = x172 * x3335
    x3435 = x3350 * x8
    x3436 = 2.0 * x3263
    x3437 = -x3435 + x3436
    x3438 = x3434 + x3437
    x3439 = x3438 * x6
    x3440 = x172 * x3330
    x3441 = x3335 * x8
    x3442 = 2.0 * x3239
    x3443 = -x3441 + x3442
    x3444 = x3440 + x3443
    x3445 = -x3444 * x6
    x3446 = x3444 * x5
    x3447 = x3433 * x5 + x3445
    x3448 = x3441 - x3442
    x3449 = x4 * (x3433 - x3440 + x3448)
    x3450 = -x3439 + x3446
    x3451 = x3435 - x3436
    x3452 = x4 * (-x3434 + x3444 + x3451)
    x3453 = 2.0 * x3279 - x3362 * x8
    x3454 = x172 * x3350 + x3453
    x3455 = x3304 - x3366 * x8
    x3456 = x172 * x3376 + x3455
    x3457 = x172 * x3371
    x3458 = x3385 * x8
    x3459 = x3309 - x3458
    x3460 = x3457 + x3459
    x3461 = x3460 * x6
    x3462 = x172 * x3366
    x3463 = x3371 * x8
    x3464 = x3288 - x3463
    x3465 = x3462 + x3464
    x3466 = -x3465 * x6
    x3467 = x3465 * x5
    x3468 = x3456 * x5 + x3466
    x3469 = x3323 + x3463
    x3470 = x4 * (x3456 - x3462 + x3469)
    x3471 = -x3461 + x3467
    x3472 = x3326 + x3458
    x3473 = x4 * (-x3457 + x3465 + x3472)
    x3474 = x3324 - x3395 * x8
    x3475 = x172 * x3385 + x3474
    x3476 = -x3399 * x8
    x3477 = x172 * x3409 + x3476
    x3478 = x172 * x3404
    x3479 = x3419 * x8
    x3480 = -x3479
    x3481 = x3478 + x3480
    x3482 = x3481 * x6
    x3483 = x172 * x3399
    x3484 = x3404 * x8
    x3485 = -x3484
    x3486 = x3483 + x3485
    x3487 = -x3486 * x6
    x3488 = x3486 * x5
    x3489 = x3477 * x5 + x3487
    x3490 = x4 * (x3477 - x3483 + x3484)
    x3491 = -x3482 + x3488
    x3492 = x4 * (-x3478 + x3479 + x3486)
    x3493 = -x3431 * x8
    x3494 = x172 * x3419 + x3493
    x3495 = -x10 * x2405 + x1012 + x1844 * x2403 + 3.0 * x2239
    x3496 = x1844 * x2409
    x3497 = x10 * x2412
    x3498 = 3.0 * x2257
    x3499 = x1031 + x3496 - x3497 + x3498
    x3500 = x3499 * x6
    x3501 = x1844 * x2405
    x3502 = x10 * x2409
    x3503 = 3.0 * x2248
    x3504 = x1049 + x3501 - x3502 + x3503
    x3505 = -x3504 * x6
    x3506 = x3504 * x5
    x3507 = x3495 * x5 + x3505
    x3508 = x4 * (x1055 + x3495 - x3501 + x3502 - x3503)
    x3509 = -x3500 + x3506
    x3510 = x4 * (x1075 - x3496 + x3497 - x3498 + x3504)
    x3511 = -x10 * x2431 + x1077 + x1844 * x2412 + 3.0 * x2274
    x3512 = x172 * x3444
    x3513 = 3.0 * x3343 - x3444 * x8
    x3514 = x172 * x3433 + x3513
    x3515 = x3438 * x8
    x3516 = 3.0 * x3355
    x3517 = x3515 - x3516
    x3518 = x4 * (-x3512 + x3514 + x3517)
    x3519 = -x3515 + x3516
    x3520 = x3512 + x3519
    x3521 = 3.0 * x3360 - x3454 * x8
    x3522 = x172 * x3438 + x3521
    x3523 = x172 * x3465
    x3524 = 2.0 * x3378 - x3465 * x8
    x3525 = x172 * x3456 + x3524
    x3526 = x3460 * x8
    x3527 = 2.0 * x3389
    x3528 = x3526 - x3527
    x3529 = x4 * (-x3523 + x3525 + x3528)
    x3530 = -x3526 + x3527
    x3531 = x3523 + x3530
    x3532 = 2.0 * x3393 - x3475 * x8
    x3533 = x172 * x3460 + x3532
    x3534 = x172 * x3486
    x3535 = x3412 - x3486 * x8
    x3536 = x172 * x3477 + x3535
    x3537 = x3481 * x8
    x3538 = x3425 + x3537
    x3539 = x4 * (-x3534 + x3536 + x3538)
    x3540 = x3424 - x3537
    x3541 = x3534 + x3540
    x3542 = x3429 - x3494 * x8
    x3543 = x172 * x3481 + x3542
    x3544 = x3499 * x8
    x3545 = x172 * x3504
    x3546 = -x3504 * x8
    x3547 = x172 * x3495 + x3546
    x3548 = x4 * (x3544 - x3545 + x3547)
    x3549 = -x3544
    x3550 = x3545 + x3549
    x3551 = -x3511 * x8
    x3552 = x172 * x3499 + x3551
    x3553 = x10 * x2525
    x3554 = x1844 * x2519
    x3555 = 4.0 * x2415
    x3556 = -x10 * x2519 + x1225 + x1844 * x2517 + 4.0 * x2404
    x3557 = x4 * (x1255 + x3553 - x3554 - x3555 + x3556)
    x3558 = x1239 - x3553 + x3554 + x3555
    x3559 = -x10 * x2529 + x1252 + x1844 * x2525 + 4.0 * x2430
    x3560 = x2537 * x8
    x3561 = x1256 * x2534
    x3562 = 2.0 * x1260
    x3563 = x1256 * x2564 + 2.0 * x1289 - x2534 * x8
    x3564 = x4 * (x3560 - x3561 - x3562 + x3563)
    x3565 = -x3560 + x3561 + x3562
    x3566 = x3563 * x5 - x3565 * x6
    x3567 = x3565 * x5
    x3568 = x1256 * x2537
    x3569 = x2544 * x8
    x3570 = 2.0 * x1274
    x3571 = x3568 - x3569 + x3570
    x3572 = x3571 * x6
    x3573 = x3567 - x3572
    x3574 = x3564 + x3566 * x5 - x3573 * x6
    x3575 = x4 * (x3565 - x3568 + x3569 - x3570)
    x3576 = x3573 * x5
    x3577 = x3571 * x5
    x3578 = x1256 * x2544
    x3579 = x2555 * x8
    x3580 = 2.0 * x1298
    x3581 = x3578 - x3579 + x3580
    x3582 = x3581 * x6
    x3583 = x3577 - x3582
    x3584 = x3583 * x6
    x3585 = x3575 + x3576 - x3584
    x3586 = x3574 * x5 - x3585 * x6 + x38 * (x3566 - x3567 + x3572)
    x3587 = x3585 * x5
    x3588 = x4 * (x3571 - x3578 + x3579 - x3580)
    x3589 = x3583 * x5
    x3590 = x3581 * x5
    x3591 = x1256 * x2555
    x3592 = x2578 * x8
    x3593 = 2.0 * x1322
    x3594 = x3591 - x3592 + x3593
    x3595 = x3594 * x6
    x3596 = x3590 - x3595
    x3597 = x3596 * x6
    x3598 = x3588 + x3589 - x3597
    x3599 = x3598 * x6
    x3600 = x38 * (x3573 - x3577 + x3582)
    x3601 = x3587 - x3599 + x3600
    x3602 = -x3575
    x3603 = x4 * (x3581 - x3591 + x3592 - x3593)
    x3604 = x1256 * x2578 + 2.0 * x1347 - x2592 * x8
    x3605 = -x3588
    x3606 = x2601 * x8
    x3607 = x1256 * x2598
    x3608 = x1256 * x2614 + x2565 - x2598 * x8 + x2692
    x3609 = x4 * (x2569 + x2695 + x3606 - x3607 + x3608)
    x3610 = x2535 + x2682 - x3606 + x3607
    x3611 = x3608 * x5 - x3610 * x6
    x3612 = x3610 * x5
    x3613 = x1256 * x2601
    x3614 = x2608 * x8
    x3615 = x2550 + x2687 + x3613 - x3614
    x3616 = x3615 * x6
    x3617 = x3612 - x3616
    x3618 = x3609 + x3611 * x5 - x3617 * x6
    x3619 = x4 * (x2587 + x2707 + x3610 - x3613 + x3614)
    x3620 = x3617 * x5
    x3621 = x3615 * x5
    x3622 = x1256 * x2608
    x3623 = x2625 * x8
    x3624 = x2573 + x2702 + x3622 - x3623
    x3625 = x3624 * x6
    x3626 = x3621 - x3625
    x3627 = x3626 * x6
    x3628 = x3619 + x3620 - x3627
    x3629 = x4 * (x2593 + x2711 + x3615 - x3622 + x3623)
    x3630 = x1256 * x2625 + x2591 - x2635 * x8 + x2713
    x3631 = x2643 * x8
    x3632 = x1256 * x2640
    x3633 = 2.0 * x1431
    x3634 = x1256 * x2656 + 2.0 * x1443 - x2640 * x8
    x3635 = x4 * (x3631 - x3632 - x3633 + x3634)
    x3636 = -x3631 + x3632 + x3633
    x3637 = x3634 * x5 - x3636 * x6
    x3638 = x3636 * x5
    x3639 = x1256 * x2643
    x3640 = x2650 * x8
    x3641 = 2.0 * x1448
    x3642 = x3639 - x3640 + x3641
    x3643 = x3642 * x6
    x3644 = x3638 - x3643
    x3645 = x3635 + x3637 * x5 - x3644 * x6
    x3646 = x4 * (x3636 - x3639 + x3640 - x3641)
    x3647 = x3644 * x5
    x3648 = x3642 * x5
    x3649 = x1256 * x2650
    x3650 = x2667 * x8
    x3651 = 2.0 * x1468
    x3652 = x3649 - x3650 + x3651
    x3653 = x3652 * x6
    x3654 = x3648 - x3653
    x3655 = x3654 * x6
    x3656 = x3646 + x3647 - x3655
    x3657 = x4 * (x3642 - x3649 + x3650 - x3651)
    x3658 = x1256 * x2667 + 2.0 * x1490 - x2678 * x8
    x3659 = -x3646
    x3660 = x2688 * x8
    x3661 = x1256 * x2683
    x3662 = 2.0 * x1517
    x3663 = 2.0 * x2599
    x3664 = x1256 * x2693 + 2.0 * x1508 + 2.0 * x2615 - x2683 * x8
    x3665 = x4 * (x3660 - x3661 - x3662 - x3663 + x3664)
    x3666 = -x3660 + x3661 + x3662 + x3663
    x3667 = x3664 * x5 - x3666 * x6
    x3668 = x3666 * x5
    x3669 = x1256 * x2688
    x3670 = x2703 * x8
    x3671 = 2.0 * x1525
    x3672 = 2.0 * x2620
    x3673 = x3669 - x3670 + x3671 + x3672
    x3674 = x3673 * x6
    x3675 = x3668 - x3674
    x3676 = x4 * (x3666 - x3669 + x3670 - x3671 - x3672)
    x3677 = x1256 * x2703 + 2.0 * x1541 + 2.0 * x2634 - x2714 * x8
    x3678 = x2721 * x8
    x3679 = x1256 * x2717
    x3680 = x1256 * x2725 + x2657 - x2717 * x8 + x2787
    x3681 = x4 * (x2676 + x2801 + x3678 - x3679 + x3680)
    x3682 = x2641 + x2796 - x3678 + x3679
    x3683 = x3680 * x5 - x3682 * x6
    x3684 = x3682 * x5
    x3685 = x1256 * x2721
    x3686 = x2733 * x8
    x3687 = x2662 + x2791 + x3685 - x3686
    x3688 = x3687 * x6
    x3689 = x3684 - x3688
    x3690 = x4 * (x2679 + x2804 + x3682 - x3685 + x3686)
    x3691 = x1256 * x2733 + x2677 - x2741 * x8 + x2806
    x3692 = x2748 * x8
    x3693 = x1256 * x2744
    x3694 = 2.0 * x1617
    x3695 = x1256 * x2752 + 2.0 * x1608 - x2744 * x8
    x3696 = x4 * (x3692 - x3693 - x3694 + x3695)
    x3697 = -x3692 + x3693 + x3694
    x3698 = x3695 * x5 - x3697 * x6
    x3699 = x3697 * x5
    x3700 = x1256 * x2748
    x3701 = x2760 * x8
    x3702 = 2.0 * x1626
    x3703 = x3700 - x3701 + x3702
    x3704 = x3703 * x6
    x3705 = x3699 - x3704
    x3706 = x4 * (x3697 - x3700 + x3701 - x3702)
    x3707 = x1256 * x2760 + 2.0 * x1643 - x2769 * x8
    x3708 = x2774 * x8
    x3709 = x1256 * x2779
    x3710 = 3.0 * x2708
    x3711 = -x3710
    x3712 = 2.0 * x1661
    x3713 = 3.0 * x2696
    x3714 = x1256 * x2770 + 2.0 * x1650 - x2779 * x8 + x3713
    x3715 = x4 * (x3708 - x3709 + x3711 - x3712 + x3714)
    x3716 = -x3708 + x3709 + x3710 + x3712
    x3717 = 3.0 * x2712
    x3718 = x1256 * x2774 + 2.0 * x1676 - x2786 * x8 + x3717
    x3719 = x2792 * x8
    x3720 = x1256 * x2797
    x3721 = 2.0 * x1691
    x3722 = 2.0 * x2737
    x3723 = x1256 * x2788 + 2.0 * x1680 + 2.0 * x2727 - x2797 * x8
    x3724 = x4 * (x3719 - x3720 - x3721 - x3722 + x3723)
    x3725 = -x3719 + x3720 + x3721 + x3722
    x3726 = x1256 * x2792 + 2.0 * x1706 + 2.0 * x2740 - x2807 * x8
    x3727 = x2811 * x8
    x3728 = x1256 * x2815
    x3729 = x1256 * x2808 + x2754 - x2815 * x8 + x2856
    x3730 = x4 * (x2765 + x2855 + x3727 - x3728 + x3729)
    x3731 = x2764 + x2854 - x3727 + x3728
    x3732 = x1256 * x2811 + x2768 - x2822 * x8 + x2860
    x3733 = x2826 * x8
    x3734 = x1256 * x2830
    x3735 = 2.0 * x1751
    x3736 = x1256 * x2823 + 2.0 * x1740 - x2830 * x8
    x3737 = x4 * (x3733 - x3734 - x3735 + x3736)
    x3738 = -x3733 + x3734 + x3735
    x3739 = x1256 * x2826 + 2.0 * x1766 - x2837 * x8
    x3740 = x1256 * x2841 + 2.0 * x1772 + 4.0 * x2783 - x2843 * x8
    x3741 = x1256 * x2843 + 2.0 * x1782 + 4.0 * x2785 - x2844 * x8
    x3742 = 3.0 * x2802
    x3743 = x1256 * x2848 + 2.0 * x1788 - x2850 * x8 + x3742
    x3744 = 3.0 * x2805
    x3745 = x1256 * x2850 + 2.0 * x1798 - x2851 * x8 + x3744
    x3746 = x1256 * x2857 + 2.0 * x1804 + 2.0 * x2819 - x2859 * x8
    x3747 = x1256 * x2859 + 2.0 * x1814 + 2.0 * x2821 - x2861 * x8
    x3748 = x1256 * x2864 + 2.0 * x1819 + x2834 - x2866 * x8
    x3749 = x1256 * x2866 + 2.0 * x1828 + x2836 - x2867 * x8
    x3750 = x1256 * x2870 + 2.0 * x1833 - x2872 * x8
    x3751 = x1256 * x2872 + 2.0 * x1842 - x2873 * x8
    x3752 = x2879 * x8
    x3753 = x1256 * x2876
    x3754 = x1256 * x2904 + x1877 - x2876 * x8
    x3755 = x4 * (x1882 + x3752 - x3753 + x3754)
    x3756 = x1848 - x3752 + x3753
    x3757 = x3754 * x5 - x3756 * x6
    x3758 = x3756 * x5
    x3759 = x1256 * x2879
    x3760 = x2885 * x8
    x3761 = x1862 + x3759 - x3760
    x3762 = x3761 * x6
    x3763 = x3758 - x3762
    x3764 = x3755 + x3757 * x5 - x3763 * x6
    x3765 = x4 * (x1899 + x3756 - x3759 + x3760)
    x3766 = x3763 * x5
    x3767 = x3761 * x5
    x3768 = x1256 * x2885
    x3769 = x2895 * x8
    x3770 = x1886 + x3768 - x3769
    x3771 = x3770 * x6
    x3772 = x3767 - x3771
    x3773 = x3772 * x6
    x3774 = x3765 + x3766 - x3773
    x3775 = x3764 * x5 - x3774 * x6 + x38 * (x3757 - x3758 + x3762)
    x3776 = x3774 * x5
    x3777 = x4 * (x1923 + x3761 - x3768 + x3769)
    x3778 = x3772 * x5
    x3779 = x3770 * x5
    x3780 = x1256 * x2895
    x3781 = x2917 * x8
    x3782 = x1910 + x3780 - x3781
    x3783 = x3782 * x6
    x3784 = x3779 - x3783
    x3785 = x3784 * x6
    x3786 = x3777 + x3778 - x3785
    x3787 = x3786 * x6
    x3788 = x38 * (x3763 - x3767 + x3771)
    x3789 = x3776 - x3787 + x3788
    x3790 = -x3765
    x3791 = x4 * (x1937 + x3770 - x3780 + x3781)
    x3792 = x1256 * x2917 + x1935 - x2931 * x8
    x3793 = -x3777
    x3794 = x2938 * x8
    x3795 = x1256 * x2935
    x3796 = x1256 * x2950 + x1968 + x2905 - x2935 * x8
    x3797 = x4 * (x1989 + x2909 + x3794 - x3795 + x3796)
    x3798 = x1953 + x2877 - x3794 + x3795
    x3799 = x3796 * x5 - x3798 * x6
    x3800 = x3798 * x5
    x3801 = x1256 * x2938
    x3802 = x2944 * x8
    x3803 = x1973 + x2891 + x3801 - x3802
    x3804 = x3803 * x6
    x3805 = x3800 - x3804
    x3806 = x3797 + x3799 * x5 - x3805 * x6
    x3807 = x4 * (x2011 + x2926 + x3798 - x3801 + x3802)
    x3808 = x3805 * x5
    x3809 = x3803 * x5
    x3810 = x1256 * x2944
    x3811 = x2960 * x8
    x3812 = x1995 + x2913 + x3810 - x3811
    x3813 = x3812 * x6
    x3814 = x3809 - x3813
    x3815 = x3814 * x6
    x3816 = x3807 + x3808 - x3815
    x3817 = x4 * (x2022 + x2932 + x3803 - x3810 + x3811)
    x3818 = x1256 * x2960 + x2019 + x2930 - x2970 * x8
    x3819 = x2976 * x8
    x3820 = x1256 * x2973
    x3821 = x1256 * x2988 + x2046 - x2973 * x8
    x3822 = x4 * (x2065 + x3819 - x3820 + x3821)
    x3823 = x2034 - x3819 + x3820
    x3824 = x3821 * x5 - x3823 * x6
    x3825 = x3823 * x5
    x3826 = x1256 * x2976
    x3827 = x2982 * x8
    x3828 = x2051 + x3826 - x3827
    x3829 = x3828 * x6
    x3830 = x3825 - x3829
    x3831 = x3822 + x3824 * x5 - x3830 * x6
    x3832 = x4 * (x2085 + x3823 - x3826 + x3827)
    x3833 = x3830 * x5
    x3834 = x3828 * x5
    x3835 = x1256 * x2982
    x3836 = x2998 * x8
    x3837 = x2071 + x3835 - x3836
    x3838 = x3837 * x6
    x3839 = x3834 - x3838
    x3840 = x3839 * x6
    x3841 = x3832 + x3833 - x3840
    x3842 = x4 * (x2095 + x3828 - x3835 + x3836)
    x3843 = x1256 * x2998 + x2093 - x3009 * x8
    x3844 = -x3832
    x3845 = x3015 * x8
    x3846 = x1256 * x3012
    x3847 = 2.0 * x2936
    x3848 = -x3847
    x3849 = 2.0 * x2951
    x3850 = x1256 * x3019 + x2117 - x3012 * x8 + x3849
    x3851 = x4 * (x2130 + x3845 - x3846 + x3848 + x3850)
    x3852 = x2129 - x3845 + x3846 + x3847
    x3853 = x3850 * x5 - x3852 * x6
    x3854 = x3852 * x5
    x3855 = x1256 * x3015
    x3856 = x3026 * x8
    x3857 = 2.0 * x2956
    x3858 = x2139 + x3855 - x3856 + x3857
    x3859 = x3858 * x6
    x3860 = x3854 - x3859
    x3861 = -x3857
    x3862 = x4 * (x2156 + x3852 - x3855 + x3856 + x3861)
    x3863 = 2.0 * x2969
    x3864 = x1256 * x3026 + x2159 - x3034 * x8 + x3863
    x3865 = x3039 * x8
    x3866 = x1256 * x3036
    x3867 = x1256 * x3043 + x2182 + x2989 - x3036 * x8
    x3868 = x4 * (x2194 + x3007 + x3865 - x3866 + x3867)
    x3869 = x2193 + x2974 - x3865 + x3866
    x3870 = x3867 * x5 - x3869 * x6
    x3871 = x3869 * x5
    x3872 = x1256 * x3039
    x3873 = x3050 * x8
    x3874 = x2202 + x2994 + x3872 - x3873
    x3875 = x3874 * x6
    x3876 = x3871 - x3875
    x3877 = x4 * (x2219 + x3010 + x3869 - x3872 + x3873)
    x3878 = x1256 * x3050 + x2221 + x3008 - x3058 * x8
    x3879 = x3063 * x8
    x3880 = x1256 * x3060
    x3881 = x1256 * x3067 + x2239 - x3060 * x8
    x3882 = x4 * (x2249 + x3879 - x3880 + x3881)
    x3883 = x2248 - x3879 + x3880
    x3884 = x3881 * x5 - x3883 * x6
    x3885 = x3883 * x5
    x3886 = x1256 * x3063
    x3887 = x3074 * x8
    x3888 = x2257 + x3886 - x3887
    x3889 = x3888 * x6
    x3890 = x3885 - x3889
    x3891 = x4 * (x2272 + x3883 - x3886 + x3887)
    x3892 = x1256 * x3074 + x2274 - x3083 * x8
    x3893 = x3086 * x8
    x3894 = x1256 * x3089
    x3895 = 3.0 * x3030
    x3896 = x1256 * x3084 + x2285 + 3.0 * x3021 - x3089 * x8
    x3897 = x4 * (x2305 + x3893 - x3894 - x3895 + x3896)
    x3898 = x2304 - x3893 + x3894 + x3895
    x3899 = x1256 * x3086 + x2320 + 3.0 * x3033 - x3096 * x8
    x3900 = x3099 * x8
    x3901 = x1256 * x3102
    x3902 = 2.0 * x3054
    x3903 = -x3902
    x3904 = 2.0 * x3045
    x3905 = x1256 * x3097 + x2328 - x3102 * x8 + x3904
    x3906 = x4 * (x2346 + x3900 - x3901 + x3903 + x3905)
    x3907 = x2345 - x3900 + x3901 + x3902
    x3908 = 2.0 * x3057
    x3909 = x1256 * x3099 + x2361 - x3109 * x8 + x3908
    x3910 = x3112 * x8
    x3911 = x1256 * x3115
    x3912 = x1256 * x3110 + x2368 + x3069 - x3115 * x8
    x3913 = x4 * (x2385 + x3079 + x3910 - x3911 + x3912)
    x3914 = x2384 + x3078 - x3910 + x3911
    x3915 = x1256 * x3112 + x2399 + x3082 - x3122 * x8
    x3916 = x3125 * x8
    x3917 = x1256 * x3128
    x3918 = x1256 * x3123 + x2404 - x3128 * x8
    x3919 = x4 * (x2416 + x3916 - x3917 + x3918)
    x3920 = x2415 - x3916 + x3917
    x3921 = x1256 * x3125 + x2430 - x3135 * x8
    x3922 = x1256 * x3139 + x2438 + 4.0 * x3093 - x3141 * x8
    x3923 = x1256 * x3141 + x2451 + 4.0 * x3095 - x3142 * x8
    x3924 = x1256 * x3146 + x2460 + 3.0 * x3106 - x3148 * x8
    x3925 = x1256 * x3148 + x2473 + 3.0 * x3108 - x3149 * x8
    x3926 = 2.0 * x3119
    x3927 = x1256 * x3153 + x2481 - x3155 * x8 + x3926
    x3928 = 2.0 * x3121
    x3929 = x1256 * x3155 + x2493 - x3156 * x8 + x3928
    x3930 = x1256 * x3159 + x2500 + x3132 - x3161 * x8
    x3931 = x1256 * x3161 + x2511 + x3134 - x3162 * x8
    x3932 = x1256 * x3165 + x2518 - x3167 * x8
    x3933 = x1256 * x3167 + x2528 - x3168 * x8
    x3934 = x1256 * x3173
    x3935 = x1256 * x3203 + x3256
    x3936 = x4 * (x3236 - x3934 + x3935)
    x3937 = x3237 + x3934
    x3938 = x3935 * x5 - x3937 * x6
    x3939 = x3937 * x5
    x3940 = x1256 * x3176
    x3941 = x3241 + x3940
    x3942 = x3941 * x6
    x3943 = x3939 - x3942
    x3944 = x3936 + x3938 * x5 - x3943 * x6
    x3945 = x4 * (x3233 + x3937 - x3940)
    x3946 = x3943 * x5
    x3947 = x3941 * x5
    x3948 = x1256 * x3183
    x3949 = x3249 + x3948
    x3950 = x3949 * x6
    x3951 = x3947 - x3950
    x3952 = x3951 * x6
    x3953 = x3945 + x3946 - x3952
    x3954 = x38 * (x3938 - x3939 + x3942) + x3944 * x5 - x3953 * x6
    x3955 = x3953 * x5
    x3956 = x4 * (x3248 + x3941 - x3948)
    x3957 = x3951 * x5
    x3958 = x3949 * x5
    x3959 = x1256 * x3194
    x3960 = x3268 + x3959
    x3961 = x3960 * x6
    x3962 = x3958 - x3961
    x3963 = x3962 * x6
    x3964 = x3956 + x3957 - x3963
    x3965 = x3964 * x6
    x3966 = x38 * (x3943 - x3947 + x3950)
    x3967 = x3955 - x3965 + x3966
    x3968 = -x3945
    x3969 = x4 * (x3267 + x3949 - x3959)
    x3970 = x1256 * x3217 + x3280
    x3971 = -x3956
    x3972 = x1256 * x3238
    x3973 = x1256 * x3257 + x3339
    x3974 = x4 * (x3342 - x3972 + x3973)
    x3975 = x3329 + x3972
    x3976 = x3973 * x5 - x3975 * x6
    x3977 = x3975 * x5
    x3978 = x1256 * x3242
    x3979 = x3334 + x3978
    x3980 = x3979 * x6
    x3981 = x3977 - x3980
    x3982 = x3974 + x3976 * x5 - x3981 * x6
    x3983 = x4 * (x3354 + x3975 - x3978)
    x3984 = x3981 * x5
    x3985 = x3979 * x5
    x3986 = x1256 * x3250
    x3987 = x3349 + x3986
    x3988 = x3987 * x6
    x3989 = x3985 - x3988
    x3990 = x3989 * x6
    x3991 = x3983 + x3984 - x3990
    x3992 = x4 * (x3359 + x3979 - x3986)
    x3993 = x1256 * x3269 + x3361
    x3994 = x1256 * x3287
    x3995 = x1256 * x3303 + x3375
    x3996 = x4 * (x3364 - x3994 + x3995)
    x3997 = x3365 + x3994
    x3998 = x3995 * x5 - x3997 * x6
    x3999 = x3997 * x5
    x4000 = x1256 * x3290
    x4001 = x3370 + x4000
    x4002 = x4001 * x6
    x4003 = x3999 - x4002
    x4004 = x3996 + x3998 * x5 - x4003 * x6
    x4005 = x4 * (x3369 + x3997 - x4000)
    x4006 = x4003 * x5
    x4007 = x4001 * x5
    x4008 = x1256 * x3297
    x4009 = x3384 + x4008
    x4010 = x4009 * x6
    x4011 = x4007 - x4010
    x4012 = x4011 * x6
    x4013 = x4005 + x4006 - x4012
    x4014 = x4 * (x3383 + x4001 - x4008)
    x4015 = x1256 * x3314 + x3394
    x4016 = -x4005
    x4017 = x1256 * x3330
    x4018 = x1256 * x3340 + x3432
    x4019 = x4 * (x3448 - x4017 + x4018)
    x4020 = x3443 + x4017
    x4021 = x4018 * x5 - x4020 * x6
    x4022 = x4020 * x5
    x4023 = x1256 * x3335
    x4024 = x3437 + x4023
    x4025 = x4024 * x6
    x4026 = x4022 - x4025
    x4027 = x4 * (x3451 + x4020 - x4023)
    x4028 = x1256 * x3350 + x3453
    x4029 = x1256 * x3366
    x4030 = x1256 * x3376 + x3455
    x4031 = x4 * (x3469 - x4029 + x4030)
    x4032 = x3464 + x4029
    x4033 = x4030 * x5 - x4032 * x6
    x4034 = x4032 * x5
    x4035 = x1256 * x3371
    x4036 = x3459 + x4035
    x4037 = x4036 * x6
    x4038 = x4034 - x4037
    x4039 = x4 * (x3472 + x4032 - x4035)
    x4040 = x1256 * x3385 + x3474
    x4041 = x1256 * x3399
    x4042 = x1256 * x3409 + x3476
    x4043 = x4 * (x3484 - x4041 + x4042)
    x4044 = x3485 + x4041
    x4045 = x4042 * x5 - x4044 * x6
    x4046 = x4044 * x5
    x4047 = x1256 * x3404
    x4048 = x3480 + x4047
    x4049 = x4048 * x6
    x4050 = x4046 - x4049
    x4051 = x4 * (x3479 + x4044 - x4047)
    x4052 = x1256 * x3419 + x3493
    x4053 = x1256 * x3444
    x4054 = x1256 * x3433 + x3513
    x4055 = x4 * (x3517 - x4053 + x4054)
    x4056 = x3519 + x4053
    x4057 = x1256 * x3438 + x3521
    x4058 = x1256 * x3465
    x4059 = x1256 * x3456 + x3524
    x4060 = x4 * (x3528 - x4058 + x4059)
    x4061 = x3530 + x4058
    x4062 = x1256 * x3460 + x3532
    x4063 = x1256 * x3486
    x4064 = x1256 * x3477 + x3535
    x4065 = x4 * (x3538 - x4063 + x4064)
    x4066 = x3540 + x4063
    x4067 = x1256 * x3481 + x3542
    x4068 = x1256 * x3504
    x4069 = x1256 * x3495 + x3546
    x4070 = x4 * (x3544 - x4068 + x4069)
    x4071 = x3549 + x4068
    x4072 = x1256 * x3499 + x3551
    x4073 = x1256 * x3514 + 4.0 * x3449 - x3520 * x8
    x4074 = x1256 * x3520 + 4.0 * x3452 - x3522 * x8
    x4075 = x1256 * x3525 + 3.0 * x3470 - x3531 * x8
    x4076 = x1256 * x3531 + 3.0 * x3473 - x3533 * x8
    x4077 = x1256 * x3536 + 2.0 * x3490 - x3541 * x8
    x4078 = x1256 * x3541 + 2.0 * x3492 - x3543 * x8
    x4079 = x1256 * x3547 + x3508 - x3550 * x8
    x4080 = x1256 * x3550 + x3510 - x3552 * x8
    x4081 = x1256 * x3556 - x3558 * x8
    x4082 = x1256 * x3558 - x3559 * x8
    x4083 = x10 * x3176
    x4084 = x1844 * x3173
    x4085 = 2.0 * x1848
    x4086 = -x10 * x3173 + x1844 * x3203 + 2.0 * x1877
    x4087 = x4 * (x4083 - x4084 - x4085 + x4086)
    x4088 = -x4083 + x4084 + x4085
    x4089 = x4086 * x5 - x4088 * x6
    x4090 = x4088 * x5
    x4091 = x1844 * x3176
    x4092 = x10 * x3183
    x4093 = 2.0 * x1862
    x4094 = x4091 - x4092 + x4093
    x4095 = x4094 * x6
    x4096 = x4090 - x4095
    x4097 = x4087 + x4089 * x5 - x4096 * x6
    x4098 = x4 * (x4088 - x4091 + x4092 - x4093)
    x4099 = x4096 * x5
    x4100 = x4094 * x5
    x4101 = x1844 * x3183
    x4102 = x10 * x3194
    x4103 = 2.0 * x1886
    x4104 = x4101 - x4102 + x4103
    x4105 = x4104 * x6
    x4106 = x4100 - x4105
    x4107 = x4106 * x6
    x4108 = x4098 + x4099 - x4107
    x4109 = x38 * (x4089 - x4090 + x4095) + x4097 * x5 - x4108 * x6
    x4110 = x4108 * x5
    x4111 = x4 * (x4094 - x4101 + x4102 - x4103)
    x4112 = x4106 * x5
    x4113 = x4104 * x5
    x4114 = x1844 * x3194
    x4115 = x10 * x3217
    x4116 = 2.0 * x1910
    x4117 = x4114 - x4115 + x4116
    x4118 = x4117 * x6
    x4119 = x4113 - x4118
    x4120 = x4119 * x6
    x4121 = x4111 + x4112 - x4120
    x4122 = x4121 * x6
    x4123 = x38 * (x4096 - x4100 + x4105)
    x4124 = x4110 - x4122 + x4123
    x4125 = -x4098
    x4126 = x4 * (x4104 - x4114 + x4115 - x4116)
    x4127 = -x10 * x3231 + x1844 * x3217 + 2.0 * x1935
    x4128 = -x4111
    x4129 = x4094 * x8
    x4130 = x172 * x4088
    x4131 = -x4088 * x8
    x4132 = x172 * x4086 + x4131
    x4133 = x4 * (x4129 - x4130 + x4132)
    x4134 = -x4129
    x4135 = x4130 + x4134
    x4136 = x4132 * x5 - x4135 * x6
    x4137 = x4135 * x5
    x4138 = x172 * x4094
    x4139 = x4104 * x8
    x4140 = -x4139
    x4141 = x4138 + x4140
    x4142 = x4141 * x6
    x4143 = x4137 - x4142
    x4144 = x4133 + x4136 * x5 - x4143 * x6
    x4145 = x4 * (x4135 - x4138 + x4139)
    x4146 = x4143 * x5
    x4147 = x4141 * x5
    x4148 = x172 * x4104
    x4149 = x4117 * x8
    x4150 = -x4149
    x4151 = x4148 + x4150
    x4152 = x4151 * x6
    x4153 = x4147 - x4152
    x4154 = x4153 * x6
    x4155 = x4145 + x4146 - x4154
    x4156 = x4 * (x4141 - x4148 + x4149)
    x4157 = -x4127 * x8
    x4158 = x172 * x4117 + x4157
    x4159 = x10 * x3290
    x4160 = x1844 * x3287
    x4161 = -x10 * x3287 + x1844 * x3303 + x3204 + x3408
    x4162 = x4 * (x3208 + x3411 + x4159 - x4160 + x4161)
    x4163 = x3174 + x3398 - x4159 + x4160
    x4164 = x4161 * x5 - x4163 * x6
    x4165 = x4163 * x5
    x4166 = x1844 * x3290
    x4167 = x10 * x3297
    x4168 = x3189 + x3403 + x4166 - x4167
    x4169 = x4168 * x6
    x4170 = x4165 - x4169
    x4171 = x4162 + x4164 * x5 - x4170 * x6
    x4172 = x4 * (x3226 + x3423 + x4163 - x4166 + x4167)
    x4173 = x4170 * x5
    x4174 = x4168 * x5
    x4175 = x1844 * x3297
    x4176 = x10 * x3314
    x4177 = x3212 + x3418 + x4175 - x4176
    x4178 = x4177 * x6
    x4179 = x4174 - x4178
    x4180 = x4179 * x6
    x4181 = x4172 + x4173 - x4180
    x4182 = x4 * (x3232 + x3428 + x4168 - x4175 + x4176)
    x4183 = -x10 * x3325 + x1844 * x3314 + x3230 + x3430
    x4184 = -x4172
    x4185 = x172 * x4135
    x4186 = x4087 - x4135 * x8
    x4187 = x172 * x4132 + x4186
    x4188 = x4141 * x8
    x4189 = x4125 + x4188
    x4190 = x4 * (-x4185 + x4187 + x4189)
    x4191 = x4098 - x4188
    x4192 = x4185 + x4191
    x4193 = x4187 * x5 - x4192 * x6
    x4194 = x4192 * x5
    x4195 = x172 * x4141
    x4196 = x4151 * x8
    x4197 = x4111 - x4196
    x4198 = x4195 + x4197
    x4199 = x4198 * x6
    x4200 = x4194 - x4199
    x4201 = x4128 + x4196
    x4202 = x4 * (x4192 - x4195 + x4201)
    x4203 = x4126 - x4158 * x8
    x4204 = x172 * x4151 + x4203
    x4205 = x4168 * x8
    x4206 = x172 * x4163
    x4207 = -x4163 * x8
    x4208 = x172 * x4161 + x4207
    x4209 = x4 * (x4205 - x4206 + x4208)
    x4210 = -x4205
    x4211 = x4206 + x4210
    x4212 = x4208 * x5 - x4211 * x6
    x4213 = x4211 * x5
    x4214 = x172 * x4168
    x4215 = x4177 * x8
    x4216 = -x4215
    x4217 = x4214 + x4216
    x4218 = x4217 * x6
    x4219 = x4213 - x4218
    x4220 = x4 * (x4211 - x4214 + x4215)
    x4221 = -x4183 * x8
    x4222 = x172 * x4177 + x4221
    x4223 = x10 * x3404
    x4224 = x1844 * x3399
    x4225 = 2.0 * x2248
    x4226 = 2.0 * x3288
    x4227 = -x10 * x3399 + x1844 * x3409 + 2.0 * x2239 + 2.0 * x3304
    x4228 = x4 * (x4223 - x4224 - x4225 - x4226 + x4227)
    x4229 = -x4223 + x4224 + x4225 + x4226
    x4230 = x4227 * x5 - x4229 * x6
    x4231 = x4229 * x5
    x4232 = x1844 * x3404
    x4233 = x10 * x3419
    x4234 = 2.0 * x2257
    x4235 = 2.0 * x3309
    x4236 = x4232 - x4233 + x4234 + x4235
    x4237 = x4236 * x6
    x4238 = x4231 - x4237
    x4239 = x4 * (x4229 - x4232 + x4233 - x4234 - x4235)
    x4240 = -x10 * x3431 + x1844 * x3419 + 2.0 * x2274 + 2.0 * x3324
    x4241 = x172 * x4192
    x4242 = 2.0 * x4133 - x4192 * x8
    x4243 = x172 * x4187 + x4242
    x4244 = x4198 * x8
    x4245 = 2.0 * x4145
    x4246 = x4244 - x4245
    x4247 = x4 * (-x4241 + x4243 + x4246)
    x4248 = -x4244 + x4245
    x4249 = x4241 + x4248
    x4250 = 2.0 * x4156 - x4204 * x8
    x4251 = x172 * x4198 + x4250
    x4252 = x172 * x4211
    x4253 = x4162 - x4211 * x8
    x4254 = x172 * x4208 + x4253
    x4255 = x4217 * x8
    x4256 = x4184 + x4255
    x4257 = x4 * (-x4252 + x4254 + x4256)
    x4258 = x4172 - x4255
    x4259 = x4252 + x4258
    x4260 = x4182 - x4222 * x8
    x4261 = x172 * x4217 + x4260
    x4262 = x4236 * x8
    x4263 = x172 * x4229
    x4264 = -x4229 * x8
    x4265 = x172 * x4227 + x4264
    x4266 = x4 * (x4262 - x4263 + x4265)
    x4267 = -x4262
    x4268 = x4263 + x4267
    x4269 = -x4240 * x8
    x4270 = x172 * x4236 + x4269
    x4271 = x10 * x3499
    x4272 = x1844 * x3504
    x4273 = 3.0 * x3424
    x4274 = -x4273
    x4275 = 2.0 * x2415
    x4276 = 3.0 * x3412
    x4277 = -x10 * x3504 + x1844 * x3495 + 2.0 * x2404 + x4276
    x4278 = x4 * (x4271 - x4272 + x4274 - x4275 + x4277)
    x4279 = -x4271 + x4272 + x4273 + x4275
    x4280 = 3.0 * x3429
    x4281 = -x10 * x3511 + x1844 * x3499 + 2.0 * x2430 + x4280
    x4282 = 3.0 * x4190 - x4249 * x8
    x4283 = x172 * x4243 + x4282
    x4284 = 3.0 * x4202 - x4251 * x8
    x4285 = x172 * x4249 + x4284
    x4286 = 2.0 * x4209 - x4259 * x8
    x4287 = x172 * x4254 + x4286
    x4288 = 2.0 * x4220 - x4261 * x8
    x4289 = x172 * x4259 + x4288
    x4290 = x4228 - x4268 * x8
    x4291 = x172 * x4265 + x4290
    x4292 = x4239 - x4270 * x8
    x4293 = x172 * x4268 + x4292
    x4294 = -x4279 * x8
    x4295 = x172 * x4277 + x4294
    x4296 = -x4281 * x8
    x4297 = x172 * x4279 + x4296
    x4298 = -x10 * x3558 + x1844 * x3556 + 2.0 * x2518 + 4.0 * x3508
    x4299 = -x10 * x3559 + x1844 * x3558 + 2.0 * x2528 + 4.0 * x3510
    x4300 = x3571 * x8
    x4301 = x1256 * x3565
    x4302 = 3.0 * x2535
    x4303 = x1256 * x3563 + 3.0 * x2565 - x3565 * x8
    x4304 = -x4300 + x4301 + x4302
    x4305 = x4303 * x5 - x4304 * x6
    x4306 = x4304 * x5
    x4307 = x1256 * x3571
    x4308 = x3581 * x8
    x4309 = 3.0 * x2550
    x4310 = x4307 - x4308 + x4309
    x4311 = x4310 * x6
    x4312 = x4306 - x4311
    x4313 = x4 * (x4300 - x4301 - x4302 + x4303) + x4305 * x5 - x4312 * x6
    x4314 = x4 * (x4304 - x4307 + x4308 - x4309)
    x4315 = x4312 * x5
    x4316 = x4310 * x5
    x4317 = x1256 * x3581
    x4318 = x3594 * x8
    x4319 = 3.0 * x2573
    x4320 = x4317 - x4318 + x4319
    x4321 = x4320 * x6
    x4322 = x4316 - x4321
    x4323 = x4322 * x6
    x4324 = x4314 + x4315 - x4323
    x4325 = x3615 * x8
    x4326 = x1256 * x3610
    x4327 = 3.0 * x2599
    x4328 = x1256 * x3608 + 3.0 * x2615 + x3564 - x3610 * x8
    x4329 = x3575 - x4325 + x4326 + x4327
    x4330 = x4328 * x5 - x4329 * x6
    x4331 = x4329 * x5
    x4332 = x1256 * x3615
    x4333 = x3624 * x8
    x4334 = 3.0 * x2620
    x4335 = x3588 + x4332 - x4333 + x4334
    x4336 = x4335 * x6
    x4337 = x4331 - x4336
    x4338 = x3642 * x8
    x4339 = x1256 * x3636
    x4340 = 3.0 * x2641
    x4341 = x1256 * x3634 + 3.0 * x2657 - x3636 * x8
    x4342 = -x4338 + x4339 + x4340
    x4343 = x4341 * x5 - x4342 * x6
    x4344 = x4342 * x5
    x4345 = x1256 * x3642
    x4346 = x3652 * x8
    x4347 = 3.0 * x2662
    x4348 = x4345 - x4346 + x4347
    x4349 = x4348 * x6
    x4350 = x4344 - x4349
    x4351 = x3673 * x8
    x4352 = x1256 * x3666
    x4353 = 2.0 * x3619
    x4354 = x1256 * x3664 + 2.0 * x3609 - x3666 * x8 + x3713
    x4355 = x3710 - x4351 + x4352 + x4353
    x4356 = x3687 * x8
    x4357 = x1256 * x3682
    x4358 = 3.0 * x2737
    x4359 = x1256 * x3680 + 3.0 * x2727 + x3635 - x3682 * x8
    x4360 = x3646 - x4356 + x4357 + x4358
    x4361 = x3703 * x8
    x4362 = x1256 * x3697
    x4363 = 3.0 * x2764
    x4364 = x1256 * x3695 + 3.0 * x2754 - x3697 * x8
    x4365 = -x4361 + x4362 + x4363
    x4366 = x3761 * x8
    x4367 = x1256 * x3756
    x4368 = 2.0 * x2877
    x4369 = x1256 * x3754 + 2.0 * x2905 - x3756 * x8
    x4370 = -x4366 + x4367 + x4368
    x4371 = x4369 * x5 - x4370 * x6
    x4372 = x4370 * x5
    x4373 = x1256 * x3761
    x4374 = x3770 * x8
    x4375 = 2.0 * x2891
    x4376 = x4373 - x4374 + x4375
    x4377 = x4376 * x6
    x4378 = x4372 - x4377
    x4379 = x4 * (x4366 - x4367 - x4368 + x4369) + x4371 * x5 - x4378 * x6
    x4380 = x4 * (x4370 - x4373 + x4374 - x4375)
    x4381 = x4378 * x5
    x4382 = x4376 * x5
    x4383 = x1256 * x3770
    x4384 = x3782 * x8
    x4385 = 2.0 * x2913
    x4386 = x4383 - x4384 + x4385
    x4387 = x4386 * x6
    x4388 = x4382 - x4387
    x4389 = x4388 * x6
    x4390 = x4380 + x4381 - x4389
    x4391 = x3803 * x8
    x4392 = x1256 * x3798
    x4393 = x1256 * x3796 + x3755 - x3798 * x8 + x3849
    x4394 = x3765 + x3847 - x4391 + x4392
    x4395 = x4393 * x5 - x4394 * x6
    x4396 = x4394 * x5
    x4397 = x1256 * x3803
    x4398 = x3812 * x8
    x4399 = x3777 + x3857 + x4397 - x4398
    x4400 = x4399 * x6
    x4401 = x4396 - x4400
    x4402 = x3828 * x8
    x4403 = x1256 * x3823
    x4404 = 2.0 * x2974
    x4405 = x1256 * x3821 + 2.0 * x2989 - x3823 * x8
    x4406 = -x4402 + x4403 + x4404
    x4407 = x4405 * x5 - x4406 * x6
    x4408 = x4406 * x5
    x4409 = x1256 * x3828
    x4410 = x3837 * x8
    x4411 = 2.0 * x2994
    x4412 = x4409 - x4410 + x4411
    x4413 = x4412 * x6
    x4414 = x4408 - x4413
    x4415 = x3858 * x8
    x4416 = x1256 * x3852
    x4417 = 2.0 * x3030
    x4418 = 2.0 * x3807
    x4419 = x1256 * x3850 + 2.0 * x3021 + 2.0 * x3797 - x3852 * x8
    x4420 = -x4415 + x4416 + x4417 + x4418
    x4421 = x3874 * x8
    x4422 = x1256 * x3869
    x4423 = x1256 * x3867 + x3822 - x3869 * x8 + x3904
    x4424 = x3832 + x3902 - x4421 + x4422
    x4425 = x3888 * x8
    x4426 = x1256 * x3883
    x4427 = 2.0 * x3078
    x4428 = x1256 * x3881 + 2.0 * x3069 - x3883 * x8
    x4429 = -x4425 + x4426 + x4427
    x4430 = x3941 * x8
    x4431 = x1256 * x3937
    x4432 = x1256 * x3935 + x3204 - x3937 * x8
    x4433 = x3174 - x4430 + x4431
    x4434 = x4432 * x5 - x4433 * x6
    x4435 = x4433 * x5
    x4436 = x1256 * x3941
    x4437 = x3949 * x8
    x4438 = x3189 + x4436 - x4437
    x4439 = x4438 * x6
    x4440 = x4435 - x4439
    x4441 = x4 * (x3208 + x4430 - x4431 + x4432) + x4434 * x5 - x4440 * x6
    x4442 = x4 * (x3226 + x4433 - x4436 + x4437)
    x4443 = x4440 * x5
    x4444 = x4438 * x5
    x4445 = x1256 * x3949
    x4446 = x3960 * x8
    x4447 = x3212 + x4445 - x4446
    x4448 = x4447 * x6
    x4449 = x4444 - x4448
    x4450 = x4449 * x6
    x4451 = x4442 + x4443 - x4450
    x4452 = x3979 * x8
    x4453 = x1256 * x3975
    x4454 = x1256 * x3973 + x3258 + x3936 - x3975 * x8
    x4455 = x3239 + x3945 - x4452 + x4453
    x4456 = x4454 * x5 - x4455 * x6
    x4457 = x4455 * x5
    x4458 = x1256 * x3979
    x4459 = x3987 * x8
    x4460 = x3263 + x3956 + x4458 - x4459
    x4461 = x4460 * x6
    x4462 = x4457 - x4461
    x4463 = x4001 * x8
    x4464 = x1256 * x3997
    x4465 = x1256 * x3995 + x3304 - x3997 * x8
    x4466 = x3288 - x4463 + x4464
    x4467 = x4465 * x5 - x4466 * x6
    x4468 = x4466 * x5
    x4469 = x1256 * x4001
    x4470 = x4009 * x8
    x4471 = x3309 + x4469 - x4470
    x4472 = x4471 * x6
    x4473 = x4468 - x4472
    x4474 = x4024 * x8
    x4475 = x1256 * x4020
    x4476 = 2.0 * x3983
    x4477 = x1256 * x4018 + x3343 + 2.0 * x3974 - x4020 * x8
    x4478 = x3355 - x4474 + x4475 + x4476
    x4479 = x4036 * x8
    x4480 = x1256 * x4032
    x4481 = x1256 * x4030 + x3378 + x3996 - x4032 * x8
    x4482 = x3389 + x4005 - x4479 + x4480
    x4483 = x4048 * x8
    x4484 = x1256 * x4044
    x4485 = x1256 * x4042 + x3412 - x4044 * x8
    x4486 = x3424 - x4483 + x4484
    x4487 = x1256 * x4088
    x4488 = x1256 * x4086 + x4131
    x4489 = x4134 + x4487
    x4490 = x4488 * x5 - x4489 * x6
    x4491 = x4489 * x5
    x4492 = x1256 * x4094
    x4493 = x4140 + x4492
    x4494 = x4493 * x6
    x4495 = x4491 - x4494
    x4496 = x4 * (x4129 - x4487 + x4488) + x4490 * x5 - x4495 * x6
    x4497 = x4 * (x4139 + x4489 - x4492)
    x4498 = x4495 * x5
    x4499 = x4493 * x5
    x4500 = x1256 * x4104
    x4501 = x4150 + x4500
    x4502 = x4501 * x6
    x4503 = x4499 - x4502
    x4504 = x4503 * x6
    x4505 = x4497 + x4498 - x4504
    x4506 = x1256 * x4135
    x4507 = x1256 * x4132 + x4186
    x4508 = x4191 + x4506
    x4509 = x4507 * x5 - x4508 * x6
    x4510 = x4508 * x5
    x4511 = x1256 * x4141
    x4512 = x4197 + x4511
    x4513 = x4512 * x6
    x4514 = x4510 - x4513
    x4515 = x1256 * x4163
    x4516 = x1256 * x4161 + x4207
    x4517 = x4210 + x4515
    x4518 = x4516 * x5 - x4517 * x6
    x4519 = x4517 * x5
    x4520 = x1256 * x4168
    x4521 = x4216 + x4520
    x4522 = x4521 * x6
    x4523 = x4519 - x4522
    x4524 = x1256 * x4192
    x4525 = x1256 * x4187 + x4242
    x4526 = x4248 + x4524
    x4527 = x1256 * x4211
    x4528 = x1256 * x4208 + x4253
    x4529 = x4258 + x4527
    x4530 = x1256 * x4229
    x4531 = x1256 * x4227 + x4264
    x4532 = x4267 + x4530
    x4533 = x10 * x4094
    x4534 = x1844 * x4088
    x4535 = 3.0 * x3174
    x4536 = -x10 * x4088 + x1844 * x4086 + 3.0 * x3204
    x4537 = x4 * (x4533 - x4534 - x4535 + x4536)
    x4538 = -x4533 + x4534 + x4535
    x4539 = x4536 * x5 - x4538 * x6
    x4540 = x4538 * x5
    x4541 = x1844 * x4094
    x4542 = x10 * x4104
    x4543 = 3.0 * x3189
    x4544 = x4541 - x4542 + x4543
    x4545 = x4544 * x6
    x4546 = x4540 - x4545
    x4547 = x4537 + x4539 * x5 - x4546 * x6
    x4548 = x4 * (x4538 - x4541 + x4542 - x4543)
    x4549 = x4546 * x5
    x4550 = x4544 * x5
    x4551 = x1844 * x4104
    x4552 = x10 * x4117
    x4553 = 3.0 * x3212
    x4554 = x4551 - x4552 + x4553
    x4555 = x4554 * x6
    x4556 = x4550 - x4555
    x4557 = x4556 * x6
    x4558 = x4548 + x4549 - x4557
    x4559 = x4 * (x4544 - x4551 + x4552 - x4553)
    x4560 = -x10 * x4127 + x1844 * x4117 + 3.0 * x3230
    x4561 = -x4548
    x4562 = x4544 * x8
    x4563 = x172 * x4538
    x4564 = x172 * x4536 - x4538 * x8
    x4565 = x4 * (x4562 - x4563 + x4564)
    x4566 = -x4562 + x4563
    x4567 = x4564 * x5 - x4566 * x6
    x4568 = x4566 * x5
    x4569 = x172 * x4544
    x4570 = x4554 * x8
    x4571 = x4569 - x4570
    x4572 = x4571 * x6
    x4573 = x4568 - x4572
    x4574 = x4 * (x4566 - x4569 + x4570)
    x4575 = x172 * x4554 - x4560 * x8
    x4576 = x10 * x4168
    x4577 = x1844 * x4163
    x4578 = 3.0 * x3288
    x4579 = -x10 * x4163 + x1844 * x4161 + 3.0 * x3304 + x4087
    x4580 = x4 * (x4125 + x4576 - x4577 - x4578 + x4579)
    x4581 = x4098 - x4576 + x4577 + x4578
    x4582 = x4579 * x5 - x4581 * x6
    x4583 = x4581 * x5
    x4584 = x1844 * x4168
    x4585 = x10 * x4177
    x4586 = 3.0 * x3309
    x4587 = x4111 + x4584 - x4585 + x4586
    x4588 = x4587 * x6
    x4589 = x4583 - x4588
    x4590 = x4 * (x4128 + x4581 - x4584 + x4585 - x4586)
    x4591 = -x10 * x4183 + x1844 * x4177 + 3.0 * x3324 + x4126
    x4592 = x4571 * x8
    x4593 = x172 * x4566
    x4594 = x172 * x4564 + x4537 - x4566 * x8
    x4595 = x4 * (x4561 + x4592 - x4593 + x4594)
    x4596 = x4548 - x4592 + x4593
    x4597 = x172 * x4571 + x4559 - x4575 * x8
    x4598 = x4587 * x8
    x4599 = x172 * x4581
    x4600 = x172 * x4579 - x4581 * x8
    x4601 = x4 * (x4598 - x4599 + x4600)
    x4602 = -x4598 + x4599
    x4603 = x172 * x4587 - x4591 * x8
    x4604 = x10 * x4236
    x4605 = x1844 * x4229
    x4606 = 2.0 * x4172
    x4607 = -x10 * x4229 + x1844 * x4227 + 2.0 * x4162 + x4276
    x4608 = x4 * (x4274 + x4604 - x4605 - x4606 + x4607)
    x4609 = x4273 - x4604 + x4605 + x4606
    x4610 = -x10 * x4240 + x1844 * x4236 + 2.0 * x4182 + x4280
    x4611 = x172 * x4594 + 2.0 * x4565 - x4596 * x8
    x4612 = x172 * x4596 + 2.0 * x4574 - x4597 * x8
    x4613 = x172 * x4600 + x4580 - x4602 * x8
    x4614 = x172 * x4602 + x4590 - x4603 * x8
    x4615 = x172 * x4607 - x4609 * x8
    x4616 = x172 * x4609 - x4610 * x8
    x4617 = -x10 * x4279 + x1844 * x4277 + 3.0 * x3508 + 3.0 * x4228
    x4618 = -x10 * x4281 + x1844 * x4279 + 3.0 * x3510 + 3.0 * x4239

    # 225 item(s)
    return numpy.array(
        [
            x109
            * (
                x108 * x38
                + x130
                * (
                    -x150 * x6
                    + x152 * x3
                    - x165
                    + x166
                    - x169
                    + x38 * (-x168 + x3 * x44 + x46 + x51)
                    + x52
                    - x71
                )
                - x130
                * (
                    -x162 * x3
                    + x165
                    - x166
                    + x169
                    - x38 * (x167 - x3 * x33 + x35 + x96)
                    + x6 * (x161 + x92)
                    + x71
                    - x97
                )
                - x142 * x38
                + x153 * x3
                - x164 * x3
                - x164 * x6
                + x6 * (x136 - x159 + x160 + x163)
            )
            + x130 * (x110 - x112 - x113 + x139 - x143)
            + x3
            * (
                x109 * (-x103 + x146 - x147 - x151 + x153)
                + x110 * x3
                - x144 * x6
                + x38 * (x101 - x104 + x78 - x79)
            )
            - x6
            * (
                x109 * (-x136 + x159 - x160 - x163 + x164)
                + x144 * x3
                + x38 * (x105 - x114 + x134 - x137)
                - x6
                * (
                    x109 * (x145 + x154 - x158)
                    + x138 * x3
                    + x4 * (x100 - x115 + x154)
                    - x6
                    * (
                        x109 * (-x116 + x125 - x126 + x93)
                        + x133 * x3
                        - x6
                        * (
                            x127 * x5
                            + x130 * (-x118 + x123 + x157 + x89)
                            - x6
                            * (
                                x124 * x5
                                + x38 * (x120 - x121 + x87)
                                - x6 * (x122 * x5 + x155 - x6 * (x119 * x5 - x156 * x6))
                            )
                        )
                    )
                )
            ),
            x130 * (x257 - x259 - x260 + x284 - x288)
            + x130
            * (
                x256 * x38
                - x287 * x38
                + x298 * x3
                - x3 * x310
                - x310 * x6
                + x38
                * (
                    x204
                    - x220
                    - x295 * x6
                    + x297 * x3
                    - x313
                    - x314
                    + x315
                    + x4 * (x180 + x198 * x3 + x199 - x311)
                )
                - x38
                * (
                    x220
                    - x244
                    - x3 * x308
                    + x313
                    + x314
                    - x315
                    - x4 * (-x189 * x3 + x191 + x214 + x312)
                    + x6 * (x241 + x307)
                )
                + x6 * (x281 - x305 + x306 + x309)
            )
            + x3
            * (
                x130 * (-x251 + x291 - x292 - x296 + x298)
                + x257 * x3
                - x289 * x6
                + x38 * (x228 - x229 + x248 - x252)
            )
            - x6
            * (
                x130 * (-x281 + x305 - x306 - x309 + x310)
                + x289 * x3
                + x38 * (x253 - x261 + x278 - x282)
                - x6
                * (
                    x130 * (x290 + x299 - x304)
                    + x283 * x3
                    + x4 * (x247 - x262 + x299)
                    - x6
                    * (
                        x130 * (x242 - x264 + x272 + x303)
                        + x277 * x3
                        - x6
                        * (
                            x273 * x5
                            + x38 * (x239 - x265 + x270)
                            - x6 * (x271 * x5 + x300 - x6 * (x269 * x5 - x302 * x6))
                        )
                    )
                )
            ),
            x130 * (x403 - x405 - x406 + x430 - x434)
            + x130
            * (
                x3 * x444
                - x3 * x456
                + x38 * x402
                - x38 * x433
                + x38
                * (
                    x3 * x443
                    + x350
                    - x366
                    + x4 * (x3 * x344 + x326 + x345 - x457)
                    - x441 * x6
                    - x459
                    - x460
                    + x461
                )
                - x38
                * (
                    -x3 * x454
                    + x366
                    - x390
                    - x4 * (-x3 * x335 + x337 + x360 + x458)
                    + x459
                    + x460
                    - x461
                    + x6 * (x387 + x453)
                )
                - x456 * x6
                + x6 * (x427 - x451 + x452 + x455)
            )
            + x3
            * (
                x130 * (-x397 + x437 - x438 - x442 + x444)
                + x3 * x403
                + x38 * (x374 - x375 + x394 - x398)
                - x435 * x6
            )
            - x6
            * (
                x130 * (-x427 + x451 - x452 - x455 + x456)
                + x3 * x435
                + x38 * (x399 - x407 + x424 - x428)
                - x6
                * (
                    x130 * (x436 + x445 - x450)
                    + x3 * x429
                    + x4 * (x393 - x408 + x445)
                    - x6
                    * (
                        x130 * (x388 - x410 + x418 + x449)
                        + x3 * x423
                        - x6
                        * (
                            x38 * (x385 - x411 + x416)
                            + x419 * x5
                            - x6 * (x417 * x5 + x446 - x6 * (x415 * x5 - x448 * x6))
                        )
                    )
                )
            ),
            x130 * (x522 - x525 - x526 + x545 + x574)
            + x3
            * (
                x3 * x522
                + x38 * (x499 - x500 + x515 - x517)
                + x38 * (-x516 + x551 - x555 - x556 + x558)
                - x549 * x6
            )
            + x38
            * (
                x3 * x558
                - x3 * x571
                + x4 * (x3 * x557 + x480 + x494 - x554 * x6 + x572 - x573)
                - x4 * (-x3 * x568 + x493 + x523 - x572 + x573 + x6 * (x510 + x567))
                + x521
                - x571 * x6
                + x574
                + x6 * (x542 - x566 + x569 + x570)
            )
            - x6
            * (
                x3 * x549
                + x38 * (x518 - x527 + x541 - x543)
                + x38 * (-x542 + x566 - x569 - x570 + x571)
                - x6
                * (
                    x3 * x544
                    + x38 * (x550 + x560 - x565)
                    + x4 * (x514 - x528 + x560)
                    - x6
                    * (
                        x3 * x540
                        + x38 * (x511 - x531 + x536)
                        - x6 * (x5 * x537 + x562 - x6 * (x5 * x535 - x564 * x6))
                    )
                )
            ),
            x130 * (x632 - x635 - x636 + x654 + x682)
            + x3
            * (
                x3 * x632
                + x38 * (x610 - x611 + x625 - x627)
                + x38 * (-x626 + x660 - x664 - x665 + x667)
                - x6 * x658
            )
            + x38
            * (
                x3 * x667
                - x3 * x679
                + x4 * (x3 * x666 + x592 - x6 * x663 + x605 + x680 - x681)
                - x4 * (-x3 * x676 + x6 * (x620 + x675) + x604 + x633 - x680 + x681)
                - x6 * x679
                + x6 * (x651 - x674 + x677 + x678)
                + x631
                + x682
            )
            - x6
            * (
                x3 * x658
                + x38 * (x628 - x637 + x650 - x652)
                + x38 * (-x651 + x674 - x677 - x678 + x679)
                - x6
                * (
                    x3 * x653
                    + x38 * (x659 + x669 - x673)
                    + x4 * (x624 - x638 + x669)
                    - x6
                    * (
                        x3 * x649
                        + x38 * (x621 - x640 + x645)
                        - x6 * (x5 * x646 - x6 * (x5 * x644 - x6 * x672) + x670)
                    )
                )
            ),
            x130 * (x743 - x746 - x747 + x766 + x795)
            + x3
            * (
                x3 * x743
                + x38 * (x720 - x721 + x736 - x738)
                + x38 * (-x737 + x772 - x776 - x777 + x779)
                - x6 * x770
            )
            + x38
            * (
                x3 * x779
                - x3 * x792
                + x4 * (x3 * x778 - x6 * x775 + x701 + x715 + x793 - x794)
                - x4 * (-x3 * x789 + x6 * (x731 + x788) + x714 + x744 - x793 + x794)
                - x6 * x792
                + x6 * (x763 - x787 + x790 + x791)
                + x742
                + x795
            )
            - x6
            * (
                x3 * x770
                + x38 * (x739 - x748 + x762 - x764)
                + x38 * (-x763 + x787 - x790 - x791 + x792)
                - x6
                * (
                    x3 * x765
                    + x38 * (x771 + x781 - x786)
                    + x4 * (x735 - x749 + x781)
                    - x6
                    * (
                        x3 * x761
                        + x38 * (x732 - x752 + x757)
                        - x6 * (x5 * x758 - x6 * (x5 * x756 - x6 * x785) + x783)
                    )
                )
            ),
            x130 * (-x843 + x855 - x856 - x857 + x863)
            + x3
            * (
                x3 * x855
                + x38 * (x845 + x849 - x850 + x853)
                + x4 * (x816 - x840 + x841 + x845)
                - x6 * x864
            )
            + x4
            * (
                x3 * x816
                - x3 * x842
                - x6 * x842
                + x6 * (x821 + x828 - x837)
                - 2.0 * x843
                + 2.0 * x844
            )
            - x6
            * (
                x3 * x864
                + x38 * (x854 - x858 + x861 + x865)
                + x4 * (-x828 + x837 + x842 + x865)
                - x6
                * (
                    x3 * x862
                    + x4 * (x827 - x829 + x835)
                    + x4 * (x835 + x852 - x859)
                    - x6 * (x3 * x860 - x6 * (x5 * x834 - x6 * x869) + x867)
                )
            ),
            x130 * (-x913 + x925 - x926 - x927 + x933)
            + x3
            * (
                x3 * x925
                + x38 * (x915 + x919 - x920 + x923)
                + x4 * (x888 - x910 + x911 + x915)
                - x6 * x934
            )
            + x4
            * (
                x3 * x888
                - x3 * x912
                - x6 * x912
                + x6 * (x892 + x899 - x907)
                - 2.0 * x913
                + 2.0 * x914
            )
            - x6
            * (
                x3 * x934
                + x38 * (x924 - x928 + x931 + x935)
                + x4 * (-x899 + x907 + x912 + x935)
                - x6
                * (
                    x3 * x932
                    + x4 * (x898 - x900 + x905)
                    + x4 * (x905 + x922 - x929)
                    - x6 * (x3 * x930 - x6 * (x5 * x904 - x6 * x939) + x937)
                )
            ),
            x130 * (x1000 - x980 + x992 - x993 - x994)
            + x3
            * (
                -x1001 * x6
                + x3 * x992
                + x38 * (x982 + x986 - x987 + x990)
                + x4 * (x957 - x977 + x978 + x982)
            )
            + x4
            * (
                x3 * x957
                - x3 * x979
                - x6 * x979
                + x6 * (x960 + x967 - x975)
                - 2.0 * x980
                + 2.0 * x981
            )
            - x6
            * (
                x1001 * x3
                + x38 * (x1002 + x991 - x995 + x998)
                + x4 * (x1002 - x967 + x975 + x979)
                - x6
                * (
                    x3 * x999
                    + x4 * (x966 - x968 + x973)
                    + x4 * (x973 + x989 - x996)
                    - x6 * (x1003 + x3 * x997 - x6 * (-x1005 * x6 + x5 * x972))
                )
            ),
            x130 * (-x1053 + x1065 - x1066 - x1067 + x1073)
            + x3
            * (
                x1065 * x3
                - x1074 * x6
                + x38 * (x1055 + x1059 - x1060 + x1063)
                + x4 * (x1026 - x1050 + x1051 + x1055)
            )
            + x4
            * (
                x1026 * x3
                - x1052 * x3
                - x1052 * x6
                - 2.0 * x1053
                + 2.0 * x1054
                + x6 * (x1031 + x1038 - x1047)
            )
            - x6
            * (
                x1074 * x3
                + x38 * (x1064 - x1068 + x1071 + x1075)
                + x4 * (-x1038 + x1047 + x1052 + x1075)
                - x6
                * (
                    x1072 * x3
                    + x4 * (x1037 - x1039 + x1045)
                    + x4 * (x1045 + x1062 - x1069)
                    - x6 * (x1070 * x3 + x1077 - x6 * (x1044 * x5 - x1079 * x6))
                )
            ),
            x130 * (x1098 - x1101 + x1110 + x1116)
            + x3 * (x1098 * x3 - x1111 * x6 + x38 * (x1089 - x1090 + x1096))
            - x6
            * (
                x1111 * x3
                + x38 * (x1097 - x1102 + x1108)
                - x6 * (x1109 * x3 + x1113 - x6 * (x1107 * x3 - x1115 * x6))
            ),
            x130 * (x1135 - x1138 + x1147 + x1153)
            + x3 * (x1135 * x3 - x1148 * x6 + x38 * (x1126 - x1127 + x1133))
            - x6
            * (
                x1148 * x3
                + x38 * (x1134 - x1139 + x1145)
                - x6 * (x1146 * x3 + x1150 - x6 * (x1144 * x3 - x1152 * x6))
            ),
            x130 * (x1170 - x1173 + x1181 + x1187)
            + x3 * (x1170 * x3 - x1182 * x6 + x38 * (x1162 - x1163 + x1168))
            - x6
            * (
                x1182 * x3
                + x38 * (x1169 - x1174 + x1179)
                - x6 * (x1180 * x3 + x1184 - x6 * (x1178 * x3 - x1186 * x6))
            ),
            x130 * (x1203 - x1205 + x1213 + x1218)
            + x3 * (x1203 * x3 - x1214 * x6 + x38 * (x1195 - x1196 + x1201))
            - x6
            * (
                x1214 * x3
                + x38 * (x1202 - x1206 + x1211)
                - x6 * (x1212 * x3 + x1215 - x6 * (x1210 * x3 - x1217 * x6))
            ),
            x130 * (x1237 - x1240 + x1249 + x1255)
            + x3 * (x1237 * x3 - x1250 * x6 + x38 * (x1228 - x1229 + x1235))
            - x6
            * (
                x1250 * x3
                + x38 * (x1236 - x1241 + x1247)
                - x6 * (x1248 * x3 + x1252 - x6 * (x1246 * x3 - x1254 * x6))
            ),
            x109
            * (
                -x130 * (-x1282 * x3 + x1285 + x1340 + x1352)
                + x130 * (x1291 * x3 + x1292 + x1316 - x1352)
                + x1317
                - x1341
                + x1345 * x3
                - x1351 * x3
                - x1351 * x6
                + x6 * (x1337 + x1350)
            )
            + x3
            * (
                x109 * (x1313 - x1344 + x1345)
                + x1318 * x3
                - x1343 * x6
                + x4 * (-x1287 + x1296 + x1313)
            )
            + x38 * (x1318 - x1319 + x1339 - x1342)
            - x6
            * (
                x109 * (x1346 - x1350 + x1351)
                + x1343 * x3
                + x4 * (x1315 - x1320 + x1346)
                - x6
                * (
                    x109 * (x1309 - x1321 + x1331 - x1332)
                    + x1338 * x3
                    - x6
                    * (
                        x130 * (x1306 - x1323 + x1329 + x1349)
                        + x1333 * x5
                        - x6
                        * (
                            x1330 * x5
                            + x38 * (x1304 - x1324 + x1327)
                            - x6 * (x1328 * x5 + x1347 - x6 * (x1326 * x5 - x1348 * x6))
                        )
                    )
                )
            ),
            x130
            * (
                x1393
                - x1412
                + x1416 * x3
                - x1421 * x3
                - x1421 * x6
                - x38 * (-x1366 * x3 + x1368 + x1411 + x1422)
                + x38 * (x1372 * x3 + x1374 + x1392 - x1422)
                + x6 * (x1408 + x1420)
            )
            + x3
            * (
                x130 * (x1389 - x1415 + x1416)
                + x1394 * x3
                - x1414 * x6
                + x4 * (-x1370 + x1377 + x1389)
            )
            + x38 * (x1394 - x1395 + x1410 - x1413)
            - x6
            * (
                x130 * (x1417 - x1420 + x1421)
                + x1414 * x3
                + x4 * (x1391 - x1396 + x1417)
                - x6
                * (
                    x130 * (x1386 - x1397 - x1398 + x1404)
                    + x1409 * x3
                    - x6
                    * (
                        x1405 * x5
                        + x38 * (x1384 - x1399 + x1402)
                        - x6 * (x1403 * x5 + x1418 - x6 * (x1401 * x5 - x1419 * x6))
                    )
                )
            ),
            x130
            * (
                x1464
                - x1484
                + x1488 * x3
                - x1494 * x3
                - x1494 * x6
                - x38 * (-x1436 * x3 + x1438 + x1483 + x1495)
                + x38 * (x1442 * x3 + x1444 + x1463 - x1495)
                + x6 * (x1479 + x1493)
            )
            + x3
            * (
                x130 * (x1459 - x1487 + x1488)
                + x1465 * x3
                - x1486 * x6
                + x4 * (-x1440 + x1447 + x1459)
            )
            + x38 * (x1465 - x1466 + x1481 - x1485)
            - x6
            * (
                x130 * (x1489 - x1493 + x1494)
                + x1486 * x3
                + x4 * (x1461 - x1467 + x1489)
                - x6
                * (
                    x130 * (x1456 - x1469 + x1475 + x1492)
                    + x1480 * x3
                    - x6
                    * (
                        x1476 * x5
                        + x38 * (x1454 - x1470 + x1473)
                        - x6 * (x1474 * x5 + x1490 - x6 * (x1472 * x5 - x1491 * x6))
                    )
                )
            ),
            x3
            * (
                x1522 * x3
                - x1537 * x6
                + x38 * (x1518 - x1538 + x1539)
                + x4 * (-x1504 + x1510 + x1518)
            )
            + x38 * (x1522 - x1523 + x1534 - x1536)
            + x38
            * (
                x1521
                - x1535
                + x1539 * x3
                - x1544 * x3
                - x1544 * x6
                + x4 * (x1501 + x1505 * x3 + x1506 - x1545)
                - x4 * (-x1500 * x3 + x1502 + x1514 + x1545)
                + x6 * (x1532 + x1543)
            )
            - x6
            * (
                x1537 * x3
                + x38 * (x1540 - x1543 + x1544)
                + x4 * (x1520 - x1524 + x1540)
                - x6
                * (
                    x1533 * x3
                    + x38 * (x1515 - x1526 + x1529)
                    - x6 * (x1530 * x5 + x1541 - x6 * (x1528 * x5 - x1542 * x6))
                )
            ),
            x3
            * (
                x1572 * x3
                - x1587 * x6
                + x38 * (x1568 - x1588 + x1589)
                + x4 * (-x1554 + x1560 + x1568)
            )
            + x38 * (x1572 - x1573 + x1584 - x1586)
            + x38
            * (
                x1571
                - x1585
                + x1589 * x3
                - x1594 * x3
                - x1594 * x6
                + x4 * (x1551 + x1555 * x3 + x1556 - x1595)
                - x4 * (-x1550 * x3 + x1552 + x1564 + x1595)
                + x6 * (x1582 + x1593)
            )
            - x6
            * (
                x1587 * x3
                + x38 * (x1590 - x1593 + x1594)
                + x4 * (x1570 - x1574 + x1590)
                - x6
                * (
                    x1583 * x3
                    + x38 * (x1565 - x1576 + x1579)
                    - x6 * (x1580 * x5 + x1591 - x6 * (x1578 * x5 - x1592 * x6))
                )
            ),
            x3
            * (
                x1623 * x3
                - x1638 * x6
                + x38 * (x1619 - x1639 + x1640)
                + x4 * (-x1604 + x1610 + x1619)
            )
            + x38 * (x1623 - x1624 + x1635 - x1637)
            + x38
            * (
                x1622
                - x1636
                + x1640 * x3
                - x1646 * x3
                - x1646 * x6
                + x4 * (x1601 + x1605 * x3 + x1606 - x1647)
                - x4 * (-x1600 * x3 + x1602 + x1614 + x1647)
                + x6 * (x1633 + x1645)
            )
            - x6
            * (
                x1638 * x3
                + x38 * (x1642 - x1645 + x1646)
                + x4 * (x1621 - x1625 + x1642)
                - x6
                * (
                    x1634 * x3
                    + x38 * (x1615 - x1627 + x1630)
                    - x6 * (x1631 * x5 + x1643 - x6 * (x1629 * x5 - x1644 * x6))
                )
            ),
            x3
            * (
                x1670 * x3
                - x1675 * x6
                + x4 * (x1653 - x1663 + x1664)
                + x4 * (x1664 - x1667 + x1668)
            )
            + x38 * (x1662 + x1670 - x1671 + x1674)
            + x4
            * (
                x1650
                + x1653 * x3
                + x1662
                - x1666 * x3
                - x1666 * x6
                + x6 * (x1656 + x1660)
            )
            - x6
            * (
                x1675 * x3
                + x4 * (-x1656 + x1659 + x1666)
                + x4 * (x1659 + x1669 - x1672)
                - x6 * (x1673 * x3 + x1676 - x6 * (x1658 * x5 - x1677 * x6))
            ),
            x3
            * (
                x1700 * x3
                - x1705 * x6
                + x4 * (x1683 - x1693 + x1694)
                + x4 * (x1694 - x1697 + x1698)
            )
            + x38 * (x1692 + x1700 - x1701 + x1704)
            + x4
            * (
                x1680
                + x1683 * x3
                + x1692
                - x1696 * x3
                - x1696 * x6
                + x6 * (x1686 + x1690)
            )
            - x6
            * (
                x1705 * x3
                + x4 * (-x1686 + x1689 + x1696)
                + x4 * (x1689 + x1699 - x1702)
                - x6 * (x1703 * x3 + x1706 - x6 * (x1688 * x5 - x1707 * x6))
            ),
            x3
            * (
                x1730 * x3
                - x1735 * x6
                + x4 * (x1713 - x1723 + x1724)
                + x4 * (x1724 - x1727 + x1728)
            )
            + x38 * (x1722 + x1730 - x1731 + x1734)
            + x4
            * (
                x1710
                + x1713 * x3
                + x1722
                - x1726 * x3
                - x1726 * x6
                + x6 * (x1716 + x1720)
            )
            - x6
            * (
                x1735 * x3
                + x4 * (-x1716 + x1719 + x1726)
                + x4 * (x1719 + x1729 - x1732)
                - x6 * (x1733 * x3 + x1736 - x6 * (x1718 * x5 - x1737 * x6))
            ),
            x3
            * (
                x1760 * x3
                - x1765 * x6
                + x4 * (x1743 - x1753 + x1754)
                + x4 * (x1754 - x1757 + x1758)
            )
            + x38 * (x1752 + x1760 - x1761 + x1764)
            + x4
            * (
                x1740
                + x1743 * x3
                + x1752
                - x1756 * x3
                - x1756 * x6
                + x6 * (x1746 + x1750)
            )
            - x6
            * (
                x1765 * x3
                + x4 * (-x1746 + x1749 + x1756)
                + x4 * (x1749 + x1759 - x1762)
                - x6 * (x1763 * x3 + x1766 - x6 * (x1748 * x5 - x1767 * x6))
            ),
            x3 * (x1772 + x1774 * x3 - x1781 * x6)
            + x38 * (x1774 - x1775 + x1780)
            - x6 * (x1781 * x3 + x1782 - x6 * (x1779 * x3 - x1783 * x6)),
            x3 * (x1788 + x1790 * x3 - x1797 * x6)
            + x38 * (x1790 - x1791 + x1796)
            - x6 * (x1797 * x3 + x1798 - x6 * (x1795 * x3 - x1799 * x6)),
            x3 * (x1804 + x1806 * x3 - x1813 * x6)
            + x38 * (x1806 - x1807 + x1812)
            - x6 * (x1813 * x3 + x1814 - x6 * (x1811 * x3 - x1815 * x6)),
            x3 * (x1819 + x1821 * x3 - x1827 * x6)
            + x38 * (x1821 - x1822 + x1826)
            - x6 * (x1827 * x3 + x1828 - x6 * (x1825 * x3 - x1829 * x6)),
            x3 * (x1833 + x1835 * x3 - x1841 * x6)
            + x38 * (x1835 - x1836 + x1840)
            - x6 * (x1841 * x3 + x1842 - x6 * (x1839 * x3 - x1843 * x6)),
            x109
            * (
                -x130 * (-x1870 * x3 + x1873 + x1928 + x1940)
                + x130 * (x1879 * x3 + x1880 + x1904 - x1940)
                + x1905
                - x1929
                + x1933 * x3
                - x1939 * x3
                - x1939 * x6
                + x6 * (x1925 + x1938)
            )
            + x3
            * (
                x109 * (x1901 - x1932 + x1933)
                + x1906 * x3
                - x1931 * x6
                + x4 * (-x1875 + x1884 + x1901)
            )
            + x38 * (x1906 - x1907 + x1927 - x1930)
            - x6
            * (
                x109 * (x1934 - x1938 + x1939)
                + x1931 * x3
                + x4 * (x1903 - x1908 + x1934)
                - x6
                * (
                    x109 * (x1897 - x1909 + x1919 - x1920)
                    + x1926 * x3
                    - x6
                    * (
                        x130 * (x1894 - x1911 + x1917 + x1937)
                        + x1921 * x5
                        - x6
                        * (
                            x1918 * x5
                            + x38 * (x1892 - x1912 + x1915)
                            - x6 * (x1916 * x5 + x1935 - x6 * (x1914 * x5 - x1936 * x6))
                        )
                    )
                )
            ),
            x130
            * (
                x1991
                - x2013
                + x2017 * x3
                - x2024 * x3
                - x2024 * x6
                - x38 * (-x1960 * x3 + x1962 + x2012 + x2025)
                + x38 * (x1967 * x3 + x1969 + x1990 - x2025)
                + x6 * (x2008 + x2023)
            )
            + x3
            * (
                x130 * (x1986 - x2016 + x2017)
                + x1992 * x3
                - x2015 * x6
                + x4 * (-x1964 + x1972 + x1986)
            )
            + x38 * (x1992 - x1993 + x2010 - x2014)
            - x6
            * (
                x130 * (x2018 - x2023 + x2024)
                + x2015 * x3
                + x4 * (x1988 - x1994 + x2018)
                - x6
                * (
                    x130 * (x1983 - x1996 + x2004 + x2022)
                    + x2009 * x3
                    - x6
                    * (
                        x2005 * x5
                        + x38 * (x1981 - x1997 + x2002)
                        - x6 * (x2003 * x5 + x2019 - x6 * (x2001 * x5 - x2021 * x6))
                    )
                )
            ),
            x130
            * (
                x2067
                - x2087
                + x2091 * x3
                - x2097 * x3
                - x2097 * x6
                - x38 * (-x2039 * x3 + x2041 + x2086 + x2098)
                + x38 * (x2045 * x3 + x2047 + x2066 - x2098)
                + x6 * (x2082 + x2096)
            )
            + x3
            * (
                x130 * (x2062 - x2090 + x2091)
                + x2068 * x3
                - x2089 * x6
                + x4 * (-x2043 + x2050 + x2062)
            )
            + x38 * (x2068 - x2069 + x2084 - x2088)
            - x6
            * (
                x130 * (x2092 - x2096 + x2097)
                + x2089 * x3
                + x4 * (x2064 - x2070 + x2092)
                - x6
                * (
                    x130 * (x2059 - x2072 + x2078 + x2095)
                    + x2083 * x3
                    - x6
                    * (
                        x2079 * x5
                        + x38 * (x2057 - x2073 + x2076)
                        - x6 * (x2077 * x5 + x2093 - x6 * (x2075 * x5 - x2094 * x6))
                    )
                )
            ),
            x3
            * (
                x2135 * x3
                - x2153 * x6
                + x38 * (x2131 - x2154 + x2155)
                + x4 * (-x2111 + x2119 + x2131)
            )
            + x38 * (x2135 - x2136 + x2150 - x2152)
            + x38
            * (
                x2134
                - x2151
                + x2155 * x3
                - x2163 * x3
                - x2163 * x6
                + x4 * (x2108 + x2113 * x3 + x2114 - x2164)
                - x4 * (-x2107 * x3 + x2109 + x2125 + x2164)
                + x6 * (x2148 + x2162)
            )
            - x6
            * (
                x2153 * x3
                + x38 * (x2157 - x2162 + x2163)
                + x4 * (x2133 - x2137 + x2157)
                - x6
                * (
                    x2149 * x3
                    + x38 * (x2126 - x2140 + x2145)
                    - x6 * (x2146 * x5 + x2159 - x6 * (x2144 * x5 - x2161 * x6))
                )
            ),
            x3
            * (
                x2199 * x3
                - x2216 * x6
                + x38 * (x2195 - x2217 + x2218)
                + x4 * (-x2177 + x2184 + x2195)
            )
            + x38 * (x2199 - x2200 + x2213 - x2215)
            + x38
            * (
                x2198
                - x2214
                + x2218 * x3
                - x2225 * x3
                - x2225 * x6
                + x4 * (x2174 + x2179 * x3 + x2180 - x2226)
                - x4 * (-x2173 * x3 + x2175 + x2190 + x2226)
                + x6 * (x2211 + x2224)
            )
            - x6
            * (
                x2216 * x3
                + x38 * (x2220 - x2224 + x2225)
                + x4 * (x2197 - x2201 + x2220)
                - x6
                * (
                    x2212 * x3
                    + x38 * (x2191 - x2203 + x2208)
                    - x6 * (x2209 * x5 + x2221 - x6 * (x2207 * x5 - x2223 * x6))
                )
            ),
            x3
            * (
                x2254 * x3
                - x2269 * x6
                + x38 * (x2250 - x2270 + x2271)
                + x4 * (-x2235 + x2241 + x2250)
            )
            + x38 * (x2254 - x2255 + x2266 - x2268)
            + x38
            * (
                x2253
                - x2267
                + x2271 * x3
                - x2277 * x3
                - x2277 * x6
                + x4 * (x2232 + x2236 * x3 + x2237 - x2278)
                - x4 * (-x2231 * x3 + x2233 + x2245 + x2278)
                + x6 * (x2264 + x2276)
            )
            - x6
            * (
                x2269 * x3
                + x38 * (x2273 - x2276 + x2277)
                + x4 * (x2252 - x2256 + x2273)
                - x6
                * (
                    x2265 * x3
                    + x38 * (x2246 - x2258 + x2261)
                    - x6 * (x2262 * x5 + x2274 - x6 * (x2260 * x5 - x2275 * x6))
                )
            ),
            x3
            * (
                x2313 * x3
                - x2318 * x6
                + x4 * (x2289 - x2306 + x2307)
                + x4 * (x2307 - x2310 + x2311)
            )
            + x38 * (x2305 + x2313 - x2314 + x2317)
            + x4
            * (
                x2285
                + x2289 * x3
                + x2305
                - x2309 * x3
                - x2309 * x6
                + x6 * (x2295 + x2302)
            )
            - x6
            * (
                x2318 * x3
                + x4 * (-x2295 + x2301 + x2309)
                + x4 * (x2301 + x2312 - x2315)
                - x6 * (x2316 * x3 + x2320 - x6 * (x2300 * x5 - x2322 * x6))
            ),
            x3
            * (
                x2354 * x3
                - x2359 * x6
                + x4 * (x2332 - x2347 + x2348)
                + x4 * (x2348 - x2351 + x2352)
            )
            + x38 * (x2346 + x2354 - x2355 + x2358)
            + x4
            * (
                x2328
                + x2332 * x3
                + x2346
                - x2350 * x3
                - x2350 * x6
                + x6 * (x2337 + x2343)
            )
            - x6
            * (
                x2359 * x3
                + x4 * (-x2337 + x2342 + x2350)
                + x4 * (x2342 + x2353 - x2356)
                - x6 * (x2357 * x3 + x2361 - x6 * (x2341 * x5 - x2363 * x6))
            ),
            x3
            * (
                x2393 * x3
                - x2398 * x6
                + x4 * (x2372 - x2386 + x2387)
                + x4 * (x2387 - x2390 + x2391)
            )
            + x38 * (x2385 + x2393 - x2394 + x2397)
            + x4
            * (
                x2368
                + x2372 * x3
                + x2385
                - x2389 * x3
                - x2389 * x6
                + x6 * (x2377 + x2383)
            )
            - x6
            * (
                x2398 * x3
                + x4 * (-x2377 + x2382 + x2389)
                + x4 * (x2382 + x2392 - x2395)
                - x6 * (x2396 * x3 + x2399 - x6 * (x2381 * x5 - x2401 * x6))
            ),
            x3
            * (
                x2424 * x3
                - x2429 * x6
                + x4 * (x2407 - x2417 + x2418)
                + x4 * (x2418 - x2421 + x2422)
            )
            + x38 * (x2416 + x2424 - x2425 + x2428)
            + x4
            * (
                x2404
                + x2407 * x3
                + x2416
                - x2420 * x3
                - x2420 * x6
                + x6 * (x2410 + x2414)
            )
            - x6
            * (
                x2429 * x3
                + x4 * (-x2410 + x2413 + x2420)
                + x4 * (x2413 + x2423 - x2426)
                - x6 * (x2427 * x3 + x2430 - x6 * (x2412 * x5 - x2431 * x6))
            ),
            x3 * (x2438 + x2441 * x3 - x2449 * x6)
            + x38 * (x2441 - x2442 + x2448)
            - x6 * (x2449 * x3 + x2451 - x6 * (x2447 * x3 - x2453 * x6)),
            x3 * (x2460 + x2463 * x3 - x2471 * x6)
            + x38 * (x2463 - x2464 + x2470)
            - x6 * (x2471 * x3 + x2473 - x6 * (x2469 * x3 - x2475 * x6)),
            x3 * (x2481 + x2484 * x3 - x2491 * x6)
            + x38 * (x2484 - x2485 + x2490)
            - x6 * (x2491 * x3 + x2493 - x6 * (x2489 * x3 - x2495 * x6)),
            x3 * (x2500 + x2503 * x3 - x2510 * x6)
            + x38 * (x2503 - x2504 + x2509)
            - x6 * (x2510 * x3 + x2511 - x6 * (x2508 * x3 - x2513 * x6)),
            x3 * (x2518 + x2520 * x3 - x2527 * x6)
            + x38 * (x2520 - x2521 + x2526)
            - x6 * (x2527 * x3 + x2528 - x6 * (x2525 * x3 - x2529 * x6)),
            x109 * (-x2562 * x3 + x2568 * x3 + x2570 + x2589)
            + x3 * (x109 * (-x2549 + x2560 - x2561 + x2568) + x2571 * x3 - x2590 * x6)
            + x4 * (-x2563 + x2571 + x2589)
            - x6
            * (
                x109 * (x2562 - x2572 + x2583 - x2584)
                + x2590 * x3
                - x6
                * (
                    x130 * (x2559 - x2574 + x2581 + x2593)
                    + x2585 * x5
                    - x6
                    * (
                        x2582 * x5
                        + x38 * (x2557 - x2575 + x2579)
                        - x6 * (x2580 * x5 + x2591 - x6 * (x2578 * x5 - x2592 * x6))
                    )
                )
            ),
            x130 * (-x2612 * x3 + x2617 * x3 + x2618 + x2632)
            + x3 * (x130 * (-x2599 - x2604 + x2611 + x2617) + x2619 * x3 - x2633 * x6)
            + x4 * (-x2613 + x2619 + x2632)
            - x6
            * (
                x130 * (x2612 - x2620 - x2621 + x2628)
                + x2633 * x3
                - x6
                * (
                    x2629 * x5
                    + x38 * (x2610 - x2622 + x2626)
                    - x6 * (x2627 * x5 + x2634 - x6 * (x2625 * x5 - x2635 * x6))
                )
            ),
            x130 * (-x2654 * x3 + x2659 * x3 + x2660 + x2674)
            + x3 * (x130 * (-x2646 + x2653 + x2659 + x2676) + x2661 * x3 - x2675 * x6)
            + x4 * (-x2655 + x2661 + x2674)
            - x6
            * (
                x130 * (x2654 - x2663 + x2670 + x2679)
                + x2675 * x3
                - x6
                * (
                    x2671 * x5
                    + x38 * (x2652 - x2664 + x2668)
                    - x6 * (x2669 * x5 + x2677 - x6 * (x2667 * x5 - x2678 * x6))
                )
            ),
            x3 * (x2698 * x3 - x2710 * x6 + x38 * (-x2684 + x2689 + x2694))
            + x38 * (-x2690 * x3 + x2694 * x3 + x2697 + x2709)
            + x4 * (-x2691 + x2698 + x2709)
            - x6
            * (
                x2710 * x3
                + x38 * (x2690 - x2699 + x2704)
                - x6 * (x2705 * x5 + x2712 - x6 * (x2703 * x5 - x2714 * x6))
            ),
            x3 * (x2729 * x3 - x2739 * x6 + x38 * (-x2718 + x2722 + x2726))
            + x38 * (-x2723 * x3 + x2726 * x3 + x2728 + x2738)
            + x4 * (-x2724 + x2729 + x2738)
            - x6
            * (
                x2739 * x3
                + x38 * (x2723 - x2730 + x2734)
                - x6 * (x2735 * x5 + x2740 - x6 * (x2733 * x5 - x2741 * x6))
            ),
            x3 * (x2756 * x3 - x2767 * x6 + x38 * (-x2745 + x2749 + x2753))
            + x38 * (-x2750 * x3 + x2753 * x3 + x2755 + x2766)
            + x4 * (-x2751 + x2756 + x2766)
            - x6
            * (
                x2767 * x3
                + x38 * (x2750 - x2757 + x2761)
                - x6 * (x2762 * x5 + x2768 - x6 * (x2760 * x5 - x2769 * x6))
            ),
            x3 * (x2782 * x3 + x2783 - x2784 * x6)
            + x4 * (x2775 - x2781 + x2782)
            + x4 * (x2770 * x3 + x2775 - x2779 * x3 + x2780)
            - x6 * (x2784 * x3 + x2785 - x6 * (x2774 * x5 - x2786 * x6)),
            x3 * (x2800 * x3 + x2802 - x2803 * x6)
            + x4 * (x2793 - x2799 + x2800)
            + x4 * (x2788 * x3 + x2793 - x2797 * x3 + x2798)
            - x6 * (x2803 * x3 + x2805 - x6 * (x2792 * x5 - x2807 * x6)),
            x3 * (x2818 * x3 + x2819 - x2820 * x6)
            + x4 * (x2812 - x2817 + x2818)
            + x4 * (x2808 * x3 + x2812 - x2815 * x3 + x2816)
            - x6 * (x2820 * x3 + x2821 - x6 * (x2811 * x5 - x2822 * x6)),
            x3 * (x2833 * x3 + x2834 - x2835 * x6)
            + x4 * (x2827 - x2832 + x2833)
            + x4 * (x2823 * x3 + x2827 - x2830 * x3 + x2831)
            - x6 * (x2835 * x3 + x2836 - x6 * (x2826 * x5 - x2837 * x6)),
            x2842 + x3 * (x2841 * x3 - x2843 * x6) - x6 * (x2843 * x3 - x2844 * x6),
            x2849 + x3 * (x2848 * x3 - x2850 * x6) - x6 * (x2850 * x3 - x2851 * x6),
            x2858 + x3 * (x2857 * x3 - x2859 * x6) - x6 * (x2859 * x3 - x2861 * x6),
            x2865 + x3 * (x2864 * x3 - x2866 * x6) - x6 * (x2866 * x3 - x2867 * x6),
            x2871 + x3 * (x2870 * x3 - x2872 * x6) - x6 * (x2872 * x3 - x2873 * x6),
            x109 * (-x2902 * x3 + x2908 * x3 + x2910 + x2928)
            + x3 * (x109 * (-x2890 + x2900 - x2901 + x2908) + x2911 * x3 - x2929 * x6)
            + x4 * (-x2903 + x2911 + x2928)
            - x6
            * (
                x109 * (x2902 - x2912 + x2922 - x2923)
                + x2929 * x3
                - x6
                * (
                    x130 * (x2899 - x2914 + x2920 + x2932)
                    + x2924 * x5
                    - x6
                    * (
                        x2921 * x5
                        + x38 * (x2897 - x2915 + x2918)
                        - x6 * (x2919 * x5 + x2930 - x6 * (x2917 * x5 - x2931 * x6))
                    )
                )
            ),
            x130 * (-x2948 * x3 + x2953 * x3 + x2954 + x2967)
            + x3 * (x130 * (-x2936 - x2941 + x2947 + x2953) + x2955 * x3 - x2968 * x6)
            + x4 * (-x2949 + x2955 + x2967)
            - x6
            * (
                x130 * (x2948 - x2956 - x2957 + x2963)
                + x2968 * x3
                - x6
                * (
                    x2964 * x5
                    + x38 * (x2946 - x2958 + x2961)
                    - x6 * (x2962 * x5 + x2969 - x6 * (x2960 * x5 - x2970 * x6))
                )
            ),
            x130 * (-x2986 * x3 + x2991 * x3 + x2992 + x3005)
            + x3 * (x130 * (-x2979 + x2985 + x2991 + x3007) + x2993 * x3 - x3006 * x6)
            + x4 * (-x2987 + x2993 + x3005)
            - x6
            * (
                x130 * (x2986 - x2995 + x3001 + x3010)
                + x3 * x3006
                - x6
                * (
                    x3002 * x5
                    + x38 * (x2984 - x2996 + x2999)
                    - x6 * (x3000 * x5 + x3008 - x6 * (x2998 * x5 - x3009 * x6))
                )
            ),
            x3 * (x3 * x3023 - x3032 * x6 + x38 * (-x3013 + x3016 + x3020))
            + x38 * (-x3 * x3017 + x3 * x3020 + x3022 + x3031)
            + x4 * (-x3018 + x3023 + x3031)
            - x6
            * (
                x3 * x3032
                + x38 * (x3017 - x3024 + x3027)
                - x6 * (x3028 * x5 + x3033 - x6 * (x3026 * x5 - x3034 * x6))
            ),
            x3 * (x3 * x3047 - x3056 * x6 + x38 * (-x3037 + x3040 + x3044))
            + x38 * (-x3 * x3041 + x3 * x3044 + x3046 + x3055)
            + x4 * (-x3042 + x3047 + x3055)
            - x6
            * (
                x3 * x3056
                + x38 * (x3041 - x3048 + x3051)
                - x6 * (x3052 * x5 + x3057 - x6 * (x3050 * x5 - x3058 * x6))
            ),
            x3 * (x3 * x3071 - x3081 * x6 + x38 * (-x3061 + x3064 + x3068))
            + x38 * (-x3 * x3065 + x3 * x3068 + x3070 + x3080)
            + x4 * (-x3066 + x3071 + x3080)
            - x6
            * (
                x3 * x3081
                + x38 * (x3065 - x3072 + x3075)
                - x6 * (x3076 * x5 + x3082 - x6 * (x3074 * x5 - x3083 * x6))
            ),
            x3 * (x3 * x3092 + x3093 - x3094 * x6)
            + x4 * (x3087 - x3091 + x3092)
            + x4 * (x3 * x3084 - x3 * x3089 + x3087 + x3090)
            - x6 * (x3 * x3094 + x3095 - x6 * (x3086 * x5 - x3096 * x6)),
            x3 * (x3 * x3105 + x3106 - x3107 * x6)
            + x4 * (x3100 - x3104 + x3105)
            + x4 * (x3 * x3097 - x3 * x3102 + x3100 + x3103)
            - x6 * (x3 * x3107 + x3108 - x6 * (x3099 * x5 - x3109 * x6)),
            x3 * (x3 * x3118 + x3119 - x3120 * x6)
            + x4 * (x3113 - x3117 + x3118)
            + x4 * (x3 * x3110 - x3 * x3115 + x3113 + x3116)
            - x6 * (x3 * x3120 + x3121 - x6 * (x3112 * x5 - x3122 * x6)),
            x3 * (x3 * x3131 + x3132 - x3133 * x6)
            + x4 * (x3126 - x3130 + x3131)
            + x4 * (x3 * x3123 - x3 * x3128 + x3126 + x3129)
            - x6 * (x3 * x3133 + x3134 - x6 * (x3125 * x5 - x3135 * x6)),
            x3 * (x3 * x3139 - x3141 * x6) + x3140 - x6 * (x3 * x3141 - x3142 * x6),
            x3 * (x3 * x3146 - x3148 * x6) + x3147 - x6 * (x3 * x3148 - x3149 * x6),
            x3 * (x3 * x3153 - x3155 * x6) + x3154 - x6 * (x3 * x3155 - x3156 * x6),
            x3 * (x3 * x3159 - x3161 * x6) + x3160 - x6 * (x3 * x3161 - x3162 * x6),
            x3 * (x3 * x3165 - x3167 * x6) + x3166 - x6 * (x3 * x3167 - x3168 * x6),
            x109 * (-x3 * x3201 + x3 * x3207 + x3209 + x3228)
            + x3 * (x109 * (-x3188 + x3199 - x3200 + x3207) + x3 * x3210 - x3229 * x6)
            + x4 * (-x3202 + x3210 + x3228)
            - x6
            * (
                x109 * (x3201 - x3211 + x3222 - x3223)
                + x3 * x3229
                - x6
                * (
                    x130 * (x3198 - x3213 + x3220 + x3232)
                    + x3224 * x5
                    - x6
                    * (
                        x3221 * x5
                        + x38 * (x3196 - x3214 + x3218)
                        - x6 * (x3219 * x5 + x3230 - x6 * (x3217 * x5 - x3231 * x6))
                    )
                )
            ),
            x130 * (-x3 * x3254 + x3 * x3260 + x3261 + x3276)
            + x3 * (x130 * (-x3245 + x3253 + x3260 + x3278) + x3 * x3262 - x3277 * x6)
            + x4 * (-x3255 + x3262 + x3276)
            - x6
            * (
                x130 * (x3254 - x3264 + x3272 + x3282)
                + x3 * x3277
                - x6
                * (
                    x3273 * x5
                    + x38 * (x3252 - x3265 + x3270)
                    - x6 * (x3271 * x5 + x3279 - x6 * (x3269 * x5 - x3281 * x6))
                )
            ),
            x130 * (-x3 * x3301 + x3 * x3306 + x3307 + x3321)
            + x3 * (x130 * (-x3293 + x3300 + x3306 + x3323) + x3 * x3308 - x3322 * x6)
            + x4 * (-x3302 + x3308 + x3321)
            - x6
            * (
                x130 * (x3301 - x3310 + x3317 + x3326)
                + x3 * x3322
                - x6
                * (
                    x3318 * x5
                    + x38 * (x3299 - x3311 + x3315)
                    - x6 * (x3316 * x5 + x3324 - x6 * (x3314 * x5 - x3325 * x6))
                )
            ),
            x3 * (x3 * x3345 - x3358 * x6 + x38 * (-x3331 + x3336 + x3341))
            + x38 * (-x3 * x3337 + x3 * x3341 + x3344 + x3357)
            + x4 * (-x3338 + x3345 + x3357)
            - x6
            * (
                x3 * x3358
                + x38 * (x3337 - x3346 + x3351)
                - x6 * (x3352 * x5 + x3360 - x6 * (x3350 * x5 - x3362 * x6))
            ),
            x3 * (x3 * x3380 - x3392 * x6 + x38 * (-x3367 + x3372 + x3377))
            + x38 * (-x3 * x3373 + x3 * x3377 + x3379 + x3391)
            + x4 * (-x3374 + x3380 + x3391)
            - x6
            * (
                x3 * x3392
                + x38 * (x3373 - x3381 + x3386)
                - x6 * (x3387 * x5 + x3393 - x6 * (x3385 * x5 - x3395 * x6))
            ),
            x3 * (x3 * x3414 - x3427 * x6 + x38 * (-x3400 + x3405 + x3410))
            + x38 * (-x3 * x3406 + x3 * x3410 + x3413 + x3426)
            + x4 * (-x3407 + x3414 + x3426)
            - x6
            * (
                x3 * x3427
                + x38 * (x3406 - x3415 + x3420)
                - x6 * (x3421 * x5 + x3429 - x6 * (x3419 * x5 - x3431 * x6))
            ),
            x3 * (x3 * x3447 + x3449 - x3450 * x6)
            + x4 * (x3439 - x3446 + x3447)
            + x4 * (x3 * x3433 - x3 * x3444 + x3439 + x3445)
            - x6 * (x3 * x3450 + x3452 - x6 * (x3438 * x5 - x3454 * x6)),
            x3 * (x3 * x3468 + x3470 - x3471 * x6)
            + x4 * (x3461 - x3467 + x3468)
            + x4 * (x3 * x3456 - x3 * x3465 + x3461 + x3466)
            - x6 * (x3 * x3471 + x3473 - x6 * (x3460 * x5 - x3475 * x6)),
            x3 * (x3 * x3489 + x3490 - x3491 * x6)
            + x4 * (x3482 - x3488 + x3489)
            + x4 * (x3 * x3477 - x3 * x3486 + x3482 + x3487)
            - x6 * (x3 * x3491 + x3492 - x6 * (x3481 * x5 - x3494 * x6)),
            x3 * (x3 * x3507 + x3508 - x3509 * x6)
            + x4 * (x3500 - x3506 + x3507)
            + x4 * (x3 * x3495 - x3 * x3504 + x3500 + x3505)
            - x6 * (x3 * x3509 + x3510 - x6 * (x3499 * x5 - x3511 * x6)),
            x3 * (x3 * x3514 - x3520 * x6) + x3518 - x6 * (x3 * x3520 - x3522 * x6),
            x3 * (x3 * x3525 - x3531 * x6) + x3529 - x6 * (x3 * x3531 - x3533 * x6),
            x3 * (x3 * x3536 - x3541 * x6) + x3539 - x6 * (x3 * x3541 - x3543 * x6),
            x3 * (x3 * x3547 - x3550 * x6) + x3548 - x6 * (x3 * x3550 - x3552 * x6),
            x3 * (x3 * x3556 - x3558 * x6) + x3557 - x6 * (x3 * x3558 - x3559 * x6),
            x109 * (x3586 - x3587 + x3599 - x3600)
            + x3 * (x130 * (x3574 - x3576 + x3584 + x3602) + x3586 * x5 - x3601 * x6)
            - x6
            * (
                x130 * (x3585 - x3589 + x3597 + x3605)
                + x3601 * x5
                - x6
                * (
                    x3598 * x5
                    + x38 * (x3583 - x3590 + x3595)
                    - x6 * (x3596 * x5 + x3603 - x6 * (x3594 * x5 - x3604 * x6))
                )
            ),
            x130 * (x3618 - x3619 - x3620 + x3627)
            + x3 * (x3618 * x5 - x3628 * x6 + x38 * (x3611 - x3612 + x3616))
            - x6
            * (
                x3628 * x5
                + x38 * (x3617 - x3621 + x3625)
                - x6 * (x3626 * x5 + x3629 - x6 * (x3624 * x5 - x3630 * x6))
            ),
            x130 * (x3645 - x3647 + x3655 + x3659)
            + x3 * (x3645 * x5 - x3656 * x6 + x38 * (x3637 - x3638 + x3643))
            - x6
            * (
                x3656 * x5
                + x38 * (x3644 - x3648 + x3653)
                - x6 * (x3654 * x5 + x3657 - x6 * (x3652 * x5 - x3658 * x6))
            ),
            x3 * (x3665 + x3667 * x5 - x3675 * x6)
            + x38 * (x3667 - x3668 + x3674)
            - x6 * (x3675 * x5 + x3676 - x6 * (x3673 * x5 - x3677 * x6)),
            x3 * (x3681 + x3683 * x5 - x3689 * x6)
            + x38 * (x3683 - x3684 + x3688)
            - x6 * (x3689 * x5 + x3690 - x6 * (x3687 * x5 - x3691 * x6)),
            x3 * (x3696 + x3698 * x5 - x3705 * x6)
            + x38 * (x3698 - x3699 + x3704)
            - x6 * (x3705 * x5 + x3706 - x6 * (x3703 * x5 - x3707 * x6)),
            x3 * (x3714 * x5 - x3716 * x6) + x3715 - x6 * (x3716 * x5 - x3718 * x6),
            x3 * (x3723 * x5 - x3725 * x6) + x3724 - x6 * (x3725 * x5 - x3726 * x6),
            x3 * (x3729 * x5 - x3731 * x6) + x3730 - x6 * (x3731 * x5 - x3732 * x6),
            x3 * (x3736 * x5 - x3738 * x6) + x3737 - x6 * (x3738 * x5 - x3739 * x6),
            x3 * x3740 - x3741 * x6,
            x3 * x3743 - x3745 * x6,
            x3 * x3746 - x3747 * x6,
            x3 * x3748 - x3749 * x6,
            x3 * x3750 - x3751 * x6,
            x109 * (x3775 - x3776 + x3787 - x3788)
            + x3 * (x130 * (x3764 - x3766 + x3773 + x3790) + x3775 * x5 - x3789 * x6)
            - x6
            * (
                x130 * (x3774 - x3778 + x3785 + x3793)
                + x3789 * x5
                - x6
                * (
                    x3786 * x5
                    + x38 * (x3772 - x3779 + x3783)
                    - x6 * (x3784 * x5 + x3791 - x6 * (x3782 * x5 - x3792 * x6))
                )
            ),
            x130 * (x3806 - x3807 - x3808 + x3815)
            + x3 * (x38 * (x3799 - x3800 + x3804) + x3806 * x5 - x3816 * x6)
            - x6
            * (
                x38 * (x3805 - x3809 + x3813)
                + x3816 * x5
                - x6 * (x3814 * x5 + x3817 - x6 * (x3812 * x5 - x3818 * x6))
            ),
            x130 * (x3831 - x3833 + x3840 + x3844)
            + x3 * (x38 * (x3824 - x3825 + x3829) + x3831 * x5 - x3841 * x6)
            - x6
            * (
                x38 * (x3830 - x3834 + x3838)
                + x3841 * x5
                - x6 * (x3839 * x5 + x3842 - x6 * (x3837 * x5 - x3843 * x6))
            ),
            x3 * (x3851 + x3853 * x5 - x3860 * x6)
            + x38 * (x3853 - x3854 + x3859)
            - x6 * (x3860 * x5 + x3862 - x6 * (x3858 * x5 - x3864 * x6)),
            x3 * (x3868 + x3870 * x5 - x3876 * x6)
            + x38 * (x3870 - x3871 + x3875)
            - x6 * (x3876 * x5 + x3877 - x6 * (x3874 * x5 - x3878 * x6)),
            x3 * (x3882 + x3884 * x5 - x3890 * x6)
            + x38 * (x3884 - x3885 + x3889)
            - x6 * (x3890 * x5 + x3891 - x6 * (x3888 * x5 - x3892 * x6)),
            x3 * (x3896 * x5 - x3898 * x6) + x3897 - x6 * (x3898 * x5 - x3899 * x6),
            x3 * (x3905 * x5 - x3907 * x6) + x3906 - x6 * (x3907 * x5 - x3909 * x6),
            x3 * (x3912 * x5 - x3914 * x6) + x3913 - x6 * (x3914 * x5 - x3915 * x6),
            x3 * (x3918 * x5 - x3920 * x6) + x3919 - x6 * (x3920 * x5 - x3921 * x6),
            x3 * x3922 - x3923 * x6,
            x3 * x3924 - x3925 * x6,
            x3 * x3927 - x3929 * x6,
            x3 * x3930 - x3931 * x6,
            x3 * x3932 - x3933 * x6,
            x109 * (x3954 - x3955 + x3965 - x3966)
            + x3 * (x130 * (x3944 - x3946 + x3952 + x3968) + x3954 * x5 - x3967 * x6)
            - x6
            * (
                x130 * (x3953 - x3957 + x3963 + x3971)
                + x3967 * x5
                - x6
                * (
                    x38 * (x3951 - x3958 + x3961)
                    + x3964 * x5
                    - x6 * (x3962 * x5 + x3969 - x6 * (x3960 * x5 - x3970 * x6))
                )
            ),
            x130 * (x3982 - x3983 - x3984 + x3990)
            + x3 * (x38 * (x3976 - x3977 + x3980) + x3982 * x5 - x3991 * x6)
            - x6
            * (
                x38 * (x3981 - x3985 + x3988)
                + x3991 * x5
                - x6 * (x3989 * x5 + x3992 - x6 * (x3987 * x5 - x3993 * x6))
            ),
            x130 * (x4004 - x4006 + x4012 + x4016)
            + x3 * (x38 * (x3998 - x3999 + x4002) + x4004 * x5 - x4013 * x6)
            - x6
            * (
                x38 * (x4003 - x4007 + x4010)
                + x4013 * x5
                - x6 * (x4011 * x5 + x4014 - x6 * (x4009 * x5 - x4015 * x6))
            ),
            x3 * (x4019 + x4021 * x5 - x4026 * x6)
            + x38 * (x4021 - x4022 + x4025)
            - x6 * (x4026 * x5 + x4027 - x6 * (x4024 * x5 - x4028 * x6)),
            x3 * (x4031 + x4033 * x5 - x4038 * x6)
            + x38 * (x4033 - x4034 + x4037)
            - x6 * (x4038 * x5 + x4039 - x6 * (x4036 * x5 - x4040 * x6)),
            x3 * (x4043 + x4045 * x5 - x4050 * x6)
            + x38 * (x4045 - x4046 + x4049)
            - x6 * (x4050 * x5 + x4051 - x6 * (x4048 * x5 - x4052 * x6)),
            x3 * (x4054 * x5 - x4056 * x6) + x4055 - x6 * (x4056 * x5 - x4057 * x6),
            x3 * (x4059 * x5 - x4061 * x6) + x4060 - x6 * (x4061 * x5 - x4062 * x6),
            x3 * (x4064 * x5 - x4066 * x6) + x4065 - x6 * (x4066 * x5 - x4067 * x6),
            x3 * (x4069 * x5 - x4071 * x6) + x4070 - x6 * (x4071 * x5 - x4072 * x6),
            x3 * x4073 - x4074 * x6,
            x3 * x4075 - x4076 * x6,
            x3 * x4077 - x4078 * x6,
            x3 * x4079 - x4080 * x6,
            x3 * x4081 - x4082 * x6,
            x109 * (x4109 - x4110 + x4122 - x4123)
            + x3 * (x130 * (x4097 - x4099 + x4107 + x4125) + x4109 * x5 - x4124 * x6)
            - x6
            * (
                x130 * (x4108 - x4112 + x4120 + x4128)
                + x4124 * x5
                - x6
                * (
                    x38 * (x4106 - x4113 + x4118)
                    + x4121 * x5
                    - x6 * (x4119 * x5 + x4126 - x6 * (x4117 * x5 - x4127 * x6))
                )
            ),
            x130 * (x4144 - x4145 - x4146 + x4154)
            + x3 * (x38 * (x4136 - x4137 + x4142) + x4144 * x5 - x4155 * x6)
            - x6
            * (
                x38 * (x4143 - x4147 + x4152)
                + x4155 * x5
                - x6 * (x4153 * x5 + x4156 - x6 * (x4151 * x5 - x4158 * x6))
            ),
            x130 * (x4171 - x4173 + x4180 + x4184)
            + x3 * (x38 * (x4164 - x4165 + x4169) + x4171 * x5 - x4181 * x6)
            - x6
            * (
                x38 * (x4170 - x4174 + x4178)
                + x4181 * x5
                - x6 * (x4179 * x5 + x4182 - x6 * (x4177 * x5 - x4183 * x6))
            ),
            x3 * (x4190 + x4193 * x5 - x4200 * x6)
            + x38 * (x4193 - x4194 + x4199)
            - x6 * (x4200 * x5 + x4202 - x6 * (x4198 * x5 - x4204 * x6)),
            x3 * (x4209 + x4212 * x5 - x4219 * x6)
            + x38 * (x4212 - x4213 + x4218)
            - x6 * (x4219 * x5 + x4220 - x6 * (x4217 * x5 - x4222 * x6)),
            x3 * (x4228 + x4230 * x5 - x4238 * x6)
            + x38 * (x4230 - x4231 + x4237)
            - x6 * (x4238 * x5 + x4239 - x6 * (x4236 * x5 - x4240 * x6)),
            x3 * (x4243 * x5 - x4249 * x6) + x4247 - x6 * (x4249 * x5 - x4251 * x6),
            x3 * (x4254 * x5 - x4259 * x6) + x4257 - x6 * (x4259 * x5 - x4261 * x6),
            x3 * (x4265 * x5 - x4268 * x6) + x4266 - x6 * (x4268 * x5 - x4270 * x6),
            x3 * (x4277 * x5 - x4279 * x6) + x4278 - x6 * (x4279 * x5 - x4281 * x6),
            x3 * x4283 - x4285 * x6,
            x3 * x4287 - x4289 * x6,
            x3 * x4291 - x4293 * x6,
            x3 * x4295 - x4297 * x6,
            x3 * x4298 - x4299 * x6,
            x130 * (x4313 - x4314 - x4315 + x4323)
            + x5 * (x38 * (x4305 - x4306 + x4311) + x4313 * x5 - x4324 * x6)
            - x6
            * (
                x38 * (x4312 - x4316 + x4321)
                + x4324 * x5
                - x6
                * (
                    x4 * (x4310 - x4317 + x4318 - x4319)
                    + x4322 * x5
                    - x6 * (x4320 * x5 - x6 * (x1256 * x3594 + 3.0 * x2591 - x3604 * x8))
                )
            ),
            x38 * (x4330 - x4331 + x4336)
            + x5
            * (x4 * (x3602 + x4325 - x4326 - x4327 + x4328) + x4330 * x5 - x4337 * x6)
            - x6
            * (
                x4 * (x3605 + x4329 - x4332 + x4333 - x4334)
                + x4337 * x5
                - x6
                * (x4335 * x5 - x6 * (x1256 * x3624 + 3.0 * x2634 + x3603 - x3630 * x8))
            ),
            x38 * (x4343 - x4344 + x4349)
            + x5 * (x4 * (x4338 - x4339 - x4340 + x4341) + x4343 * x5 - x4350 * x6)
            - x6
            * (
                x4 * (x4342 - x4345 + x4346 - x4347)
                + x4350 * x5
                - x6 * (x4348 * x5 - x6 * (x1256 * x3652 + 3.0 * x2677 - x3658 * x8))
            ),
            x4 * (x3711 + x4351 - x4352 - x4353 + x4354)
            + x5 * (x4354 * x5 - x4355 * x6)
            - x6 * (x4355 * x5 - x6 * (x1256 * x3673 + 2.0 * x3629 - x3677 * x8 + x3717)),
            x4 * (x3659 + x4356 - x4357 - x4358 + x4359)
            + x5 * (x4359 * x5 - x4360 * x6)
            - x6 * (x4360 * x5 - x6 * (x1256 * x3687 + 3.0 * x2740 + x3657 - x3691 * x8)),
            x4 * (x4361 - x4362 - x4363 + x4364)
            + x5 * (x4364 * x5 - x4365 * x6)
            - x6 * (x4365 * x5 - x6 * (x1256 * x3703 + 3.0 * x2768 - x3707 * x8)),
            x5 * (x1256 * x3714 + 3.0 * x2783 + 3.0 * x3665 - x3716 * x8)
            - x6 * (x1256 * x3716 + 3.0 * x2785 + 3.0 * x3676 - x3718 * x8),
            x5 * (x1256 * x3723 + 2.0 * x3681 - x3725 * x8 + x3742)
            - x6 * (x1256 * x3725 + 2.0 * x3690 - x3726 * x8 + x3744),
            x5 * (x1256 * x3729 + 3.0 * x2819 + x3696 - x3731 * x8)
            - x6 * (x1256 * x3731 + 3.0 * x2821 + x3706 - x3732 * x8),
            x5 * (x1256 * x3736 + 3.0 * x2834 - x3738 * x8)
            - x6 * (x1256 * x3738 + 3.0 * x2836 - x3739 * x8),
            x1256 * x3740 + 3.0 * x2842 + 4.0 * x3715 - x3741 * x8,
            x1256 * x3743 + 3.0 * x2849 + 3.0 * x3724 - x3745 * x8,
            x1256 * x3746 + 3.0 * x2858 + 2.0 * x3730 - x3747 * x8,
            x1256 * x3748 + 3.0 * x2865 + x3737 - x3749 * x8,
            x1256 * x3750 + 3.0 * x2871 - x3751 * x8,
            x130 * (x4379 - x4380 - x4381 + x4389)
            + x5 * (x38 * (x4371 - x4372 + x4377) + x4379 * x5 - x4390 * x6)
            - x6
            * (
                x38 * (x4378 - x4382 + x4387)
                + x4390 * x5
                - x6
                * (
                    x4 * (x4376 - x4383 + x4384 - x4385)
                    + x4388 * x5
                    - x6 * (x4386 * x5 - x6 * (x1256 * x3782 + 2.0 * x2930 - x3792 * x8))
                )
            ),
            x38 * (x4395 - x4396 + x4400)
            + x5
            * (x4 * (x3790 + x3848 + x4391 - x4392 + x4393) + x4395 * x5 - x4401 * x6)
            - x6
            * (
                x4 * (x3793 + x3861 + x4394 - x4397 + x4398)
                + x4401 * x5
                - x6 * (x4399 * x5 - x6 * (x1256 * x3812 + x3791 - x3818 * x8 + x3863))
            ),
            x38 * (x4407 - x4408 + x4413)
            + x5 * (x4 * (x4402 - x4403 - x4404 + x4405) + x4407 * x5 - x4414 * x6)
            - x6
            * (
                x4 * (x4406 - x4409 + x4410 - x4411)
                + x4414 * x5
                - x6 * (x4412 * x5 - x6 * (x1256 * x3837 + 2.0 * x3008 - x3843 * x8))
            ),
            x4 * (x4415 - x4416 - x4417 - x4418 + x4419)
            + x5 * (x4419 * x5 - x4420 * x6)
            - x6
            * (
                x4420 * x5 - x6 * (x1256 * x3858 + 2.0 * x3033 + 2.0 * x3817 - x3864 * x8)
            ),
            x4 * (x3844 + x3903 + x4421 - x4422 + x4423)
            + x5 * (x4423 * x5 - x4424 * x6)
            - x6 * (x4424 * x5 - x6 * (x1256 * x3874 + x3842 - x3878 * x8 + x3908)),
            x4 * (x4425 - x4426 - x4427 + x4428)
            + x5 * (x4428 * x5 - x4429 * x6)
            - x6 * (x4429 * x5 - x6 * (x1256 * x3888 + 2.0 * x3082 - x3892 * x8)),
            x5 * (x1256 * x3896 + 2.0 * x3093 + 3.0 * x3851 - x3898 * x8)
            - x6 * (x1256 * x3898 + 2.0 * x3095 + 3.0 * x3862 - x3899 * x8),
            x5 * (x1256 * x3905 + 2.0 * x3106 + 2.0 * x3868 - x3907 * x8)
            - x6 * (x1256 * x3907 + 2.0 * x3108 + 2.0 * x3877 - x3909 * x8),
            x5 * (x1256 * x3912 + x3882 - x3914 * x8 + x3926)
            - x6 * (x1256 * x3914 + x3891 - x3915 * x8 + x3928),
            x5 * (x1256 * x3918 + 2.0 * x3132 - x3920 * x8)
            - x6 * (x1256 * x3920 + 2.0 * x3134 - x3921 * x8),
            x1256 * x3922 + 2.0 * x3140 + 4.0 * x3897 - x3923 * x8,
            x1256 * x3924 + 2.0 * x3147 + 3.0 * x3906 - x3925 * x8,
            x1256 * x3927 + 2.0 * x3154 + 2.0 * x3913 - x3929 * x8,
            x1256 * x3930 + 2.0 * x3160 + x3919 - x3931 * x8,
            x1256 * x3932 + 2.0 * x3166 - x3933 * x8,
            x130 * (x4441 - x4442 - x4443 + x4450)
            + x5 * (x38 * (x4434 - x4435 + x4439) + x4441 * x5 - x4451 * x6)
            - x6
            * (
                x38 * (x4440 - x4444 + x4448)
                + x4451 * x5
                - x6
                * (
                    x4 * (x3232 + x4438 - x4445 + x4446)
                    + x4449 * x5
                    - x6 * (x4447 * x5 - x6 * (x1256 * x3960 + x3230 - x3970 * x8))
                )
            ),
            x38 * (x4456 - x4457 + x4461)
            + x5
            * (x4 * (x3278 + x3968 + x4452 - x4453 + x4454) + x4456 * x5 - x4462 * x6)
            - x6
            * (
                x4 * (x3282 + x3971 + x4455 - x4458 + x4459)
                + x4462 * x5
                - x6 * (x4460 * x5 - x6 * (x1256 * x3987 + x3279 + x3969 - x3993 * x8))
            ),
            x38 * (x4467 - x4468 + x4472)
            + x5 * (x4 * (x3323 + x4463 - x4464 + x4465) + x4467 * x5 - x4473 * x6)
            - x6
            * (
                x4 * (x3326 + x4466 - x4469 + x4470)
                + x4473 * x5
                - x6 * (x4471 * x5 - x6 * (x1256 * x4009 + x3324 - x4015 * x8))
            ),
            x4 * (x3356 + x4474 - x4475 - x4476 + x4477)
            + x5 * (x4477 * x5 - x4478 * x6)
            - x6 * (x4478 * x5 - x6 * (x1256 * x4024 + x3360 + 2.0 * x3992 - x4028 * x8)),
            x4 * (x3390 + x4016 + x4479 - x4480 + x4481)
            + x5 * (x4481 * x5 - x4482 * x6)
            - x6 * (x4482 * x5 - x6 * (x1256 * x4036 + x3393 + x4014 - x4040 * x8)),
            x4 * (x3425 + x4483 - x4484 + x4485)
            + x5 * (x4485 * x5 - x4486 * x6)
            - x6 * (x4486 * x5 - x6 * (x1256 * x4048 + x3429 - x4052 * x8)),
            x5 * (x1256 * x4054 + x3449 + 3.0 * x4019 - x4056 * x8)
            - x6 * (x1256 * x4056 + x3452 + 3.0 * x4027 - x4057 * x8),
            x5 * (x1256 * x4059 + x3470 + 2.0 * x4031 - x4061 * x8)
            - x6 * (x1256 * x4061 + x3473 + 2.0 * x4039 - x4062 * x8),
            x5 * (x1256 * x4064 + x3490 + x4043 - x4066 * x8)
            - x6 * (x1256 * x4066 + x3492 + x4051 - x4067 * x8),
            x5 * (x1256 * x4069 + x3508 - x4071 * x8)
            - x6 * (x1256 * x4071 + x3510 - x4072 * x8),
            x1256 * x4073 + x3518 + 4.0 * x4055 - x4074 * x8,
            x1256 * x4075 + x3529 + 3.0 * x4060 - x4076 * x8,
            x1256 * x4077 + x3539 + 2.0 * x4065 - x4078 * x8,
            x1256 * x4079 + x3548 + x4070 - x4080 * x8,
            x1256 * x4081 + x3557 - x4082 * x8,
            x130 * (x4496 - x4497 - x4498 + x4504)
            + x5 * (x38 * (x4490 - x4491 + x4494) + x4496 * x5 - x4505 * x6)
            - x6
            * (
                x38 * (x4495 - x4499 + x4502)
                + x4505 * x5
                - x6
                * (
                    x4 * (x4149 + x4493 - x4500)
                    + x4503 * x5
                    - x6 * (x4501 * x5 - x6 * (x1256 * x4117 + x4157))
                )
            ),
            x38 * (x4509 - x4510 + x4513)
            + x5 * (x4 * (x4189 - x4506 + x4507) + x4509 * x5 - x4514 * x6)
            - x6
            * (
                x4 * (x4201 + x4508 - x4511)
                + x4514 * x5
                - x6 * (x4512 * x5 - x6 * (x1256 * x4151 + x4203))
            ),
            x38 * (x4518 - x4519 + x4522)
            + x5 * (x4 * (x4205 - x4515 + x4516) + x4518 * x5 - x4523 * x6)
            - x6
            * (
                x4 * (x4215 + x4517 - x4520)
                + x4523 * x5
                - x6 * (x4521 * x5 - x6 * (x1256 * x4177 + x4221))
            ),
            x4 * (x4246 - x4524 + x4525)
            + x5 * (x4525 * x5 - x4526 * x6)
            - x6 * (x4526 * x5 - x6 * (x1256 * x4198 + x4250)),
            x4 * (x4256 - x4527 + x4528)
            + x5 * (x4528 * x5 - x4529 * x6)
            - x6 * (x4529 * x5 - x6 * (x1256 * x4217 + x4260)),
            x4 * (x4262 - x4530 + x4531)
            + x5 * (x4531 * x5 - x4532 * x6)
            - x6 * (x4532 * x5 - x6 * (x1256 * x4236 + x4269)),
            x5 * (x1256 * x4243 + x4282) - x6 * (x1256 * x4249 + x4284),
            x5 * (x1256 * x4254 + x4286) - x6 * (x1256 * x4259 + x4288),
            x5 * (x1256 * x4265 + x4290) - x6 * (x1256 * x4268 + x4292),
            x5 * (x1256 * x4277 + x4294) - x6 * (x1256 * x4279 + x4296),
            x1256 * x4283 + 4.0 * x4247 - x4285 * x8,
            x1256 * x4287 + 3.0 * x4257 - x4289 * x8,
            x1256 * x4291 + 2.0 * x4266 - x4293 * x8,
            x1256 * x4295 + x4278 - x4297 * x8,
            x1256 * x4298 - x4299 * x8,
            x130 * (x4547 - x4549 + x4557 + x4561)
            + x5 * (x38 * (x4539 - x4540 + x4545) + x4547 * x5 - x4558 * x6)
            - x6
            * (
                x38 * (x4546 - x4550 + x4555)
                + x4558 * x5
                - x6 * (x4556 * x5 + x4559 - x6 * (x4554 * x5 - x4560 * x6))
            ),
            x38 * (x4567 - x4568 + x4572)
            + x5 * (x4565 + x4567 * x5 - x4573 * x6)
            - x6 * (x4573 * x5 + x4574 - x6 * (x4571 * x5 - x4575 * x6)),
            x38 * (x4582 - x4583 + x4588)
            + x5 * (x4580 + x4582 * x5 - x4589 * x6)
            - x6 * (x4589 * x5 + x4590 - x6 * (x4587 * x5 - x4591 * x6)),
            x4595 + x5 * (x4594 * x5 - x4596 * x6) - x6 * (x4596 * x5 - x4597 * x6),
            x4601 + x5 * (x4600 * x5 - x4602 * x6) - x6 * (x4602 * x5 - x4603 * x6),
            x4608 + x5 * (x4607 * x5 - x4609 * x6) - x6 * (x4609 * x5 - x4610 * x6),
            x4611 * x5 - x4612 * x6,
            x4613 * x5 - x4614 * x6,
            x4615 * x5 - x4616 * x6,
            x4617 * x5 - x4618 * x6,
            x172 * x4611 + 3.0 * x4595 - x4612 * x8,
            x172 * x4613 + 2.0 * x4601 - x4614 * x8,
            x172 * x4615 + x4608 - x4616 * x8,
            x172 * x4617 - x4618 * x8,
            -x10 * x4299 + x1844 * x4298 + 3.0 * x3557 + 4.0 * x4278,
        ]
    )
