import numpy

from pysisyphus.wavefunction.ints.boys import boys


def eri_0000(a, A, b, B, c, C, d, D):
    """Cartesian [ss|ss] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = c + d
    x2 = x0 * x1
    x3 = x0 + x1
    x4 = x0 ** (-1.0)
    x5 = x1 ** (-1.0)

    # 1 item(s)
    S = numpy.array(
        [
            2
            * numpy.pi**2.5
            * boys(
                0,
                x2
                * (
                    (x4 * (a * A[0] + b * B[0]) - x5 * (c * C[0] + d * D[0])) ** 2
                    + (x4 * (a * A[1] + b * B[1]) - x5 * (c * C[1] + d * D[1])) ** 2
                    + (x4 * (a * A[2] + b * B[2]) - x5 * (c * C[2] + d * D[2])) ** 2
                )
                / x3,
            )
            * numpy.exp(
                -a
                * b
                * x4
                * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
            )
            * numpy.exp(
                -c
                * d
                * x5
                * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
            )
            / (x2 + numpy.sqrt(x3))
        ]
    )
    return S


def eri_0001(a, A, b, B, c, C, d, D):
    """Cartesian [ss|sp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = C[0] - D[0]
    x1 = a + b
    x2 = c + d
    x3 = x1 + x2
    x4 = x3 ** (-1.0)
    x5 = x2 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x1 ** (-1.0)
    x8 = -x6 + x7 * (a * A[0] + b * B[0])
    x9 = x5 * (c * C[1] + d * D[1])
    x10 = x7 * (a * A[1] + b * B[1]) - x9
    x11 = x1 * x2
    x12 = (
        x11
        * x4
        * (
            x10**2
            + x8**2
            + (-x5 * (c * C[2] + d * D[2]) + x7 * (a * A[2] + b * B[2])) ** 2
        )
    )
    x13 = C[1] - D[1]
    x14 = C[2] - D[2]
    x15 = (
        2
        * numpy.pi**2.5
        * numpy.exp(
            -a * b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        * numpy.exp(-c * d * x5 * (x0**2 + x13**2 + x14**2))
        / (x11 + numpy.sqrt(x3))
    )
    x16 = x15 * boys(0, x12)
    x17 = x1 * x15 * x4 * boys(1, x12)

    # 3 item(s)
    S = numpy.array(
        [
            x0 * x16 + x16 * (x6 - C[0]) + x17 * x8,
            x10 * x17 + x13 * x16 + x16 * (x9 - C[1]),
            x14 * x16,
        ]
    )
    return S


def eri_0002(a, A, b, B, c, C, d, D):
    """Cartesian [ss|sd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = numpy.pi**2.5
    x1 = a + b
    x2 = c + d
    x3 = x1 * x2
    x4 = x1 + x2
    x5 = (x3 + numpy.sqrt(x4)) ** (-1.0)
    x6 = x1 ** (-1.0)
    x7 = numpy.exp(
        -a * b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x8 = x2 ** (-1.0)
    x9 = C[0] - D[0]
    x10 = C[1] - D[1]
    x11 = C[2] - D[2]
    x12 = x11**2
    x13 = numpy.exp(-c * d * x8 * (x10**2 + x12 + x9**2))
    x14 = x4 ** (-1.0)
    x15 = x8 * (c * C[0] + d * D[0])
    x16 = -x15 + x6 * (a * A[0] + b * B[0])
    x17 = x8 * (c * C[1] + d * D[1])
    x18 = -x17 + x6 * (a * A[1] + b * B[1])
    x19 = (
        x14
        * x3
        * (
            x16**2
            + x18**2
            + (x6 * (a * A[2] + b * B[2]) - x8 * (c * C[2] + d * D[2])) ** 2
        )
    )
    x20 = boys(0, x19)
    x21 = x1 * x14
    x22 = 2 * x0 * x13 * x5 * x7
    x23 = x22 * boys(1, x19)
    x24 = (2 * x0 * x13 * x20 * x5 * x7 - x21 * x23) / (2 * c + 2 * d)
    x25 = x15 - C[0]
    x26 = x20 * x22
    x27 = x16 * x21
    x28 = x23 * x27 + x25 * x26
    x29 = x22 * boys(2, x19)
    x30 = x26 * x9
    x31 = x17 - C[1]
    x32 = x18 * x21
    x33 = x23 * x32 + x26 * x31
    x34 = x23 * x31 + x29 * x32
    x35 = x10 * x26
    x36 = x33 + x35

    # 6 item(s)
    S = numpy.array(
        [
            x24 + x25 * x28 + x27 * (x23 * x25 + x27 * x29) + x28 * x9 + x9 * (x28 + x30),
            x10 * x28 + x25 * x33 + x27 * x34 + x36 * x9,
            x11 * x28 + x11 * x30,
            x10 * x33 + x10 * x36 + x24 + x31 * x33 + x32 * x34,
            x11 * x33 + x11 * x35,
            x12 * x26,
        ]
    )
    return S


def eri_0010(a, A, b, B, c, C, d, D):
    """Cartesian [ss|ps] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = c + d
    x1 = x0 ** (-1.0)
    x2 = x1 * (c * C[0] + d * D[0])
    x3 = a + b
    x4 = x0 + x3
    x5 = x4 ** (-1.0)
    x6 = x3 ** (-1.0)
    x7 = -x2 + x6 * (a * A[0] + b * B[0])
    x8 = x1 * (c * C[1] + d * D[1])
    x9 = x6 * (a * A[1] + b * B[1]) - x8
    x10 = x0 * x3
    x11 = (
        x10
        * x5
        * (
            x7**2
            + x9**2
            + (-x1 * (c * C[2] + d * D[2]) + x6 * (a * A[2] + b * B[2])) ** 2
        )
    )
    x12 = (
        2
        * numpy.pi**2.5
        * numpy.exp(
            -a * b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        * numpy.exp(
            -c * d * x1 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
        )
        / (x10 + numpy.sqrt(x4))
    )
    x13 = x12 * boys(0, x11)
    x14 = x12 * x3 * x5 * boys(1, x11)

    # 3 item(s)
    S = numpy.array([x13 * (x2 - C[0]) + x14 * x7, x13 * (x8 - C[1]) + x14 * x9, 0])
    return S


def eri_0011(a, A, b, B, c, C, d, D):
    """Cartesian [ss|pp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = numpy.pi**2.5
    x1 = a + b
    x2 = c + d
    x3 = x1 * x2
    x4 = x1 + x2
    x5 = (x3 + numpy.sqrt(x4)) ** (-1.0)
    x6 = x1 ** (-1.0)
    x7 = numpy.exp(
        -a * b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x8 = x2 ** (-1.0)
    x9 = C[0] - D[0]
    x10 = C[1] - D[1]
    x11 = C[2] - D[2]
    x12 = numpy.exp(-c * d * x8 * (x10**2 + x11**2 + x9**2))
    x13 = x4 ** (-1.0)
    x14 = x8 * (c * C[0] + d * D[0])
    x15 = -x14 + x6 * (a * A[0] + b * B[0])
    x16 = x8 * (c * C[1] + d * D[1])
    x17 = -x16 + x6 * (a * A[1] + b * B[1])
    x18 = (
        x13
        * x3
        * (
            x15**2
            + x17**2
            + (x6 * (a * A[2] + b * B[2]) - x8 * (c * C[2] + d * D[2])) ** 2
        )
    )
    x19 = boys(0, x18)
    x20 = x1 * x13
    x21 = 2 * x0 * x12 * x5 * x7
    x22 = x21 * boys(1, x18)
    x23 = (2 * x0 * x12 * x19 * x5 * x7 - x20 * x22) / (2 * c + 2 * d)
    x24 = x14 - C[0]
    x25 = x19 * x21
    x26 = x15 * x20
    x27 = x22 * x26 + x24 * x25
    x28 = x21 * boys(2, x18)
    x29 = x16 - C[1]
    x30 = x17 * x20
    x31 = x22 * x30 + x25 * x29
    x32 = x22 * x29 + x28 * x30
    x33 = x24 * x31 + x26 * x32

    # 9 item(s)
    S = numpy.array(
        [
            x23 + x24 * x27 + x26 * (x22 * x24 + x26 * x28) + x27 * x9,
            x10 * x27 + x33,
            x11 * x27,
            x31 * x9 + x33,
            x10 * x31 + x23 + x29 * x31 + x30 * x32,
            x11 * x31,
            0,
            0,
            0,
        ]
    )
    return S


def eri_0012(a, A, b, B, c, C, d, D):
    """Cartesian [ss|pd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2 * c + 2 * d) ** (-1.0)
    x1 = c + d
    x2 = x1 ** (-1.0)
    x3 = x2 * (c * C[0] + d * D[0])
    x4 = x3 - C[0]
    x5 = a + b
    x6 = x1 + x5
    x7 = x6 ** (-1.0)
    x8 = x5 ** (-1.0)
    x9 = -x3 + x8 * (a * A[0] + b * B[0])
    x10 = x2 * (c * C[1] + d * D[1])
    x11 = -x10 + x8 * (a * A[1] + b * B[1])
    x12 = x1 * x5
    x13 = (
        x12
        * x7
        * (
            x11**2
            + x9**2
            + (-x2 * (c * C[2] + d * D[2]) + x8 * (a * A[2] + b * B[2])) ** 2
        )
    )
    x14 = boys(1, x13)
    x15 = numpy.pi**2.5
    x16 = (x12 + numpy.sqrt(x6)) ** (-1.0)
    x17 = numpy.exp(
        -a * b * x8 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x18 = C[0] - D[0]
    x19 = C[1] - D[1]
    x20 = C[2] - D[2]
    x21 = x20**2
    x22 = numpy.exp(-c * d * x2 * (x18**2 + x19**2 + x21))
    x23 = 2 * x15 * x16 * x17 * x22
    x24 = x14 * x23
    x25 = x5 * x7
    x26 = x25 * x9
    x27 = x23 * boys(2, x13)
    x28 = x24 * x4 + x26 * x27
    x29 = x25 * x28
    x30 = boys(0, x13)
    x31 = x23 * x30
    x32 = x24 * x26 + x31 * x4
    x33 = x0 * (2 * x15 * x16 * x17 * x22 * x30 - x24 * x25)
    x34 = x29 * x9 + x32 * x4 + x33
    x35 = x0 * (2 * x14 * x15 * x16 * x17 * x22 - x25 * x27)
    x36 = x23 * boys(3, x13)
    x37 = x18 * x32
    x38 = x19 * x32
    x39 = x10 - C[1]
    x40 = x11 * x25
    x41 = x24 * x40 + x31 * x39
    x42 = x24 * x39 + x27 * x40
    x43 = x25 * x42
    x44 = x4 * x41 + x43 * x9
    x45 = x38 + x44
    x46 = x0 * (x41 - x43)
    x47 = x27 * x39 + x36 * x40
    x48 = x26 * (x26 * x47 + x4 * x42) + x4 * x44 + x46
    x49 = x11 * x43 + x33 + x39 * x41
    x50 = x35 + x39 * x42 + x40 * x47
    x51 = x19 * x44 + x26 * x50 + x4 * x49
    x52 = x20 * x44
    x53 = x18 * x41
    x54 = x19 * x41
    x55 = x49 + x54

    # 18 item(s)
    S = numpy.array(
        [
            2 * x0 * (-x29 + x32)
            + x18 * x34
            + x18 * (x34 + x37)
            + x26 * (x26 * (x26 * x36 + x27 * x4) + x28 * x4 + x35)
            + x34 * x4,
            x18 * x45 + x19 * x34 + x48,
            x20 * x34 + x20 * x37,
            x19 * x45 + x51,
            x20 * x38 + x52,
            x21 * x32,
            x18 * x44 + x18 * (x44 + x53) + x48,
            x18 * x55 + x51,
            x20 * x53 + x52,
            x19 * x49 + x19 * x55 + x39 * x49 + x40 * x50 + 2 * x46,
            x20 * x49 + x20 * x54,
            x21 * x41,
            0,
            0,
            0,
            0,
            0,
            0,
        ]
    )
    return S


def eri_0020(a, A, b, B, c, C, d, D):
    """Cartesian [ss|ds] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = numpy.pi**2.5
    x1 = a + b
    x2 = c + d
    x3 = x1 * x2
    x4 = x1 + x2
    x5 = (x3 + numpy.sqrt(x4)) ** (-1.0)
    x6 = x1 ** (-1.0)
    x7 = numpy.exp(
        -a * b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x8 = x2 ** (-1.0)
    x9 = numpy.exp(
        -c * d * x8 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x10 = x4 ** (-1.0)
    x11 = x8 * (c * C[0] + d * D[0])
    x12 = -x11 + x6 * (a * A[0] + b * B[0])
    x13 = x8 * (c * C[1] + d * D[1])
    x14 = -x13 + x6 * (a * A[1] + b * B[1])
    x15 = (
        x10
        * x3
        * (
            x12**2
            + x14**2
            + (x6 * (a * A[2] + b * B[2]) - x8 * (c * C[2] + d * D[2])) ** 2
        )
    )
    x16 = boys(0, x15)
    x17 = x1 * x10
    x18 = 2 * x0 * x5 * x7 * x9
    x19 = x18 * boys(1, x15)
    x20 = (2 * x0 * x16 * x5 * x7 * x9 - x17 * x19) / (2 * c + 2 * d)
    x21 = x11 - C[0]
    x22 = x16 * x18
    x23 = x12 * x17
    x24 = x18 * boys(2, x15)
    x25 = x13 - C[1]
    x26 = x14 * x17
    x27 = x19 * x26 + x22 * x25
    x28 = x19 * x25 + x24 * x26

    # 6 item(s)
    S = numpy.array(
        [
            x20 + x21 * (x19 * x23 + x21 * x22) + x23 * (x19 * x21 + x23 * x24),
            x21 * x27 + x23 * x28,
            0,
            x20 + x25 * x27 + x26 * x28,
            0,
            0,
        ]
    )
    return S


def eri_0021(a, A, b, B, c, C, d, D):
    """Cartesian [ss|dp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2 * c + 2 * d) ** (-1.0)
    x1 = c + d
    x2 = x1 ** (-1.0)
    x3 = x2 * (c * C[0] + d * D[0])
    x4 = x3 - C[0]
    x5 = a + b
    x6 = x1 + x5
    x7 = x6 ** (-1.0)
    x8 = x5 ** (-1.0)
    x9 = -x3 + x8 * (a * A[0] + b * B[0])
    x10 = x2 * (c * C[1] + d * D[1])
    x11 = -x10 + x8 * (a * A[1] + b * B[1])
    x12 = x1 * x5
    x13 = (
        x12
        * x7
        * (
            x11**2
            + x9**2
            + (-x2 * (c * C[2] + d * D[2]) + x8 * (a * A[2] + b * B[2])) ** 2
        )
    )
    x14 = boys(1, x13)
    x15 = numpy.pi**2.5
    x16 = (x12 + numpy.sqrt(x6)) ** (-1.0)
    x17 = numpy.exp(
        -a * b * x8 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x18 = C[0] - D[0]
    x19 = C[1] - D[1]
    x20 = C[2] - D[2]
    x21 = numpy.exp(-c * d * x2 * (x18**2 + x19**2 + x20**2))
    x22 = 2 * x15 * x16 * x17 * x21
    x23 = x14 * x22
    x24 = x5 * x7
    x25 = x24 * x9
    x26 = x22 * boys(2, x13)
    x27 = x23 * x4 + x25 * x26
    x28 = x24 * x27
    x29 = boys(0, x13)
    x30 = x22 * x29
    x31 = x23 * x25 + x30 * x4
    x32 = x0 * (2 * x15 * x16 * x17 * x21 * x29 - x23 * x24)
    x33 = x28 * x9 + x31 * x4 + x32
    x34 = x0 * (2 * x14 * x15 * x16 * x17 * x21 - x24 * x26)
    x35 = x22 * boys(3, x13)
    x36 = x10 - C[1]
    x37 = x11 * x24
    x38 = x23 * x36 + x26 * x37
    x39 = x24 * x38
    x40 = x23 * x37 + x30 * x36
    x41 = x0 * (-x39 + x40)
    x42 = x39 * x9 + x4 * x40
    x43 = x26 * x36 + x35 * x37
    x44 = x25 * (x25 * x43 + x38 * x4) + x4 * x42 + x41
    x45 = x11 * x39 + x32 + x36 * x40
    x46 = x34 + x36 * x38 + x37 * x43
    x47 = x25 * x46 + x4 * x45

    # 18 item(s)
    S = numpy.array(
        [
            2 * x0 * (-x28 + x31)
            + x18 * x33
            + x25 * (x25 * (x25 * x35 + x26 * x4) + x27 * x4 + x34)
            + x33 * x4,
            x19 * x33 + x44,
            x20 * x33,
            x18 * x42 + x44,
            x19 * x42 + x47,
            x20 * x42,
            0,
            0,
            0,
            x18 * x45 + x47,
            x19 * x45 + x36 * x45 + x37 * x46 + 2 * x41,
            x20 * x45,
            0,
            0,
            0,
            0,
            0,
            0,
        ]
    )
    return S


def eri_0022(a, A, b, B, c, C, d, D):
    """Cartesian [ss|dd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2 * c + 2 * d) ** (-1.0)
    x1 = numpy.pi**2.5
    x2 = a + b
    x3 = c + d
    x4 = x2 * x3
    x5 = x2 + x3
    x6 = (x4 + numpy.sqrt(x5)) ** (-1.0)
    x7 = x2 ** (-1.0)
    x8 = numpy.exp(
        -a * b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x9 = x3 ** (-1.0)
    x10 = C[0] - D[0]
    x11 = C[1] - D[1]
    x12 = C[2] - D[2]
    x13 = x12**2
    x14 = numpy.exp(-c * d * x9 * (x10**2 + x11**2 + x13))
    x15 = x5 ** (-1.0)
    x16 = x9 * (c * C[0] + d * D[0])
    x17 = -x16 + x7 * (a * A[0] + b * B[0])
    x18 = x9 * (c * C[1] + d * D[1])
    x19 = -x18 + x7 * (a * A[1] + b * B[1])
    x20 = (
        x15
        * x4
        * (
            x17**2
            + x19**2
            + (x7 * (a * A[2] + b * B[2]) - x9 * (c * C[2] + d * D[2])) ** 2
        )
    )
    x21 = boys(1, x20)
    x22 = x15 * x2
    x23 = boys(2, x20)
    x24 = 2 * x1 * x14 * x6 * x8
    x25 = x23 * x24
    x26 = x0 * (2 * x1 * x14 * x21 * x6 * x8 - x22 * x25)
    x27 = x16 - C[0]
    x28 = x21 * x24
    x29 = x17 * x22
    x30 = x25 * x29 + x27 * x28
    x31 = x24 * boys(3, x20)
    x32 = x25 * x27 + x29 * x31
    x33 = x22 * x32
    x34 = x17 * x33 + x26 + x27 * x30
    x35 = x22 * x34
    x36 = boys(0, x20)
    x37 = x0 * (2 * x1 * x14 * x36 * x6 * x8 - x22 * x28)
    x38 = x24 * x36
    x39 = x27 * x38 + x28 * x29
    x40 = x22 * x30
    x41 = x17 * x40 + x27 * x39 + x37
    x42 = 2 * x0
    x43 = x17 * x35 + x27 * x41 + x42 * (x39 - x40)
    x44 = x0 * (2 * x1 * x14 * x23 * x6 * x8 - x22 * x31)
    x45 = x24 * boys(4, x20)
    x46 = x10 * x41
    x47 = x11 * x41
    x48 = x18 - C[1]
    x49 = x19 * x22
    x50 = x25 * x49 + x28 * x48
    x51 = x22 * x50
    x52 = x28 * x49 + x38 * x48
    x53 = x0 * (-x51 + x52)
    x54 = x17 * x51 + x27 * x52
    x55 = x25 * x48 + x31 * x49
    x56 = x22 * x55
    x57 = x17 * x56 + x27 * x50
    x58 = x22 * x57
    x59 = x17 * x58 + x27 * x54 + x53
    x60 = x47 + x59
    x61 = x0 * (x50 - x56)
    x62 = x31 * x48 + x45 * x49
    x63 = (
        x27 * x59
        + x29 * (x27 * x57 + x29 * (x27 * x55 + x29 * x62) + x61)
        + x42 * (x54 - x58)
    )
    x64 = x19 * x56 + x26 + x48 * x50
    x65 = x22 * x64
    x66 = x19 * x51 + x37 + x48 * x52
    x67 = x0 * (-x65 + x66)
    x68 = x17 * x65 + x27 * x66
    x69 = x44 + x48 * x55 + x49 * x62
    x70 = x27 * x68 + x29 * (x27 * x64 + x29 * x69) + x67
    x71 = x11 * x59 + x70
    x72 = x12 * x59
    x73 = x10 * x54
    x74 = x11 * x54
    x75 = x68 + x74
    x76 = x19 * x65 + x48 * x66 + 2 * x53
    x77 = x48 * x64 + x49 * x69 + 2 * x61
    x78 = x11 * x68 + x27 * x76 + x29 * x77
    x79 = x12 * x68
    x80 = x10 * x66
    x81 = x11 * x66
    x82 = x76 + x81

    # 36 item(s)
    S = numpy.array(
        [
            3 * x0 * (-x35 + x41)
            + x10 * x43
            + x10 * (x43 + x46)
            + x27 * x43
            + x29
            * (
                x27 * x34
                + x29 * (x27 * x32 + x29 * (x27 * x31 + x29 * x45) + x44)
                + x42 * (x30 - x33)
            ),
            x10 * x60 + x11 * x43 + x63,
            x12 * x43 + x12 * x46,
            x11 * x60 + x71,
            x12 * x47 + x72,
            x13 * x41,
            x10 * x59 + x10 * (x59 + x73) + x63,
            x10 * x75 + x71,
            x12 * x73 + x72,
            x11 * x75 + x78,
            x12 * x74 + x79,
            x13 * x54,
            0,
            0,
            0,
            0,
            0,
            0,
            x10 * x68 + x10 * (x68 + x80) + x70,
            x10 * x82 + x78,
            x12 * x80 + x79,
            x11 * x76 + x11 * x82 + x48 * x76 + x49 * x77 + 3 * x67,
            x12 * x76 + x12 * x81,
            x13 * x66,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
        ]
    )
    return S


def eri_0100(a, A, b, B, c, C, d, D):
    """Cartesian [sp|ss] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = a + b
    x2 = c + d
    x3 = x1 + x2
    x4 = x3 ** (-1.0)
    x5 = x2 ** (-1.0)
    x6 = x1 ** (-1.0)
    x7 = -x6 * (a * A[0] + b * B[0])
    x8 = -x5 * (c * C[0] + d * D[0]) - x7
    x9 = -x6 * (a * A[1] + b * B[1])
    x10 = -x5 * (c * C[1] + d * D[1]) - x9
    x11 = -x6 * (a * A[2] + b * B[2])
    x12 = -x11 - x5 * (c * C[2] + d * D[2])
    x13 = x1 * x2
    x14 = x13 * x4 * (x10**2 + x12**2 + x8**2)
    x15 = A[1] - B[1]
    x16 = A[2] - B[2]
    x17 = (
        2
        * numpy.pi**2.5
        * numpy.exp(-a * b * x6 * (x0**2 + x15**2 + x16**2))
        * numpy.exp(
            -c * d * x5 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
        )
        / (x13 + numpy.sqrt(x3))
    )
    x18 = x17 * boys(0, x14)
    x19 = x17 * x2 * x4 * boys(1, x14)

    # 3 item(s)
    S = numpy.array(
        [
            x0 * x18 + x18 * (-x7 - A[0]) - x19 * x8,
            -x10 * x19 + x15 * x18 + x18 * (-x9 - A[1]),
            -x12 * x19 + x16 * x18 + x18 * (-x11 - A[2]),
        ]
    )
    return S


def eri_0101(a, A, b, B, c, C, d, D):
    """Cartesian [sp|sp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = C[0] - D[0]
    x1 = a + b
    x2 = c + d
    x3 = x1 + x2
    x4 = x3 ** (-1.0)
    x5 = x2 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x1 ** (-1.0)
    x8 = -x7 * (a * A[0] + b * B[0])
    x9 = -x6 - x8
    x10 = x5 * (c * C[1] + d * D[1])
    x11 = -x7 * (a * A[1] + b * B[1])
    x12 = -x10 - x11
    x13 = -x7 * (a * A[2] + b * B[2])
    x14 = -x13 - x5 * (c * C[2] + d * D[2])
    x15 = x1 * x2
    x16 = x15 * x4 * (x12**2 + x14**2 + x9**2)
    x17 = boys(0, x16)
    x18 = -x8 - A[0]
    x19 = A[0] - B[0]
    x20 = A[1] - B[1]
    x21 = A[2] - B[2]
    x22 = C[1] - D[1]
    x23 = C[2] - D[2]
    x24 = (
        2
        * numpy.pi**2.5
        * numpy.exp(-a * b * x7 * (x19**2 + x20**2 + x21**2))
        * numpy.exp(-c * d * x5 * (x0**2 + x22**2 + x23**2))
        / (x15 + numpy.sqrt(x3))
    )
    x25 = x18 * x24
    x26 = x2 * x4
    x27 = x26 * x9
    x28 = boys(1, x16)
    x29 = x24 * x28
    x30 = x17 * x25 - x27 * x29
    x31 = (2 * a + 2 * b + 2 * c + 2 * d) ** (-1.0)
    x32 = x24 * boys(2, x16)
    x33 = x6 - C[0]
    x34 = x17 * x24
    x35 = x1 * x4
    x36 = x35 * x9
    x37 = x29 * x36 + x33 * x34
    x38 = x29 * x33 + x32 * x36
    x39 = x0 * x34 + x37
    x40 = x10 - C[1]
    x41 = x12 * x35
    x42 = x29 * x41 + x34 * x40
    x43 = x29 * x40 + x32 * x41
    x44 = x22 * x34 + x42
    x45 = x23 * x34
    x46 = -x11 - A[1]
    x47 = x12 * x26
    x48 = -x29 * x47 + x34 * x46
    x49 = -x13 - A[2]
    x50 = x14 * x26
    x51 = -x29 * x50 + x34 * x49

    # 9 item(s)
    S = numpy.array(
        [
            x0 * x30 + x18 * x37 + x19 * x39 - x27 * x38 + x31 * (x25 * x28 - x27 * x32),
            x18 * x42 + x19 * x44 + x22 * x30 - x27 * x43,
            x19 * x45 + x23 * x30,
            x0 * x48 + x20 * x39 + x37 * x46 - x38 * x47,
            x20 * x44 + x22 * x48 + x31 * (x29 * x46 - x32 * x47) + x42 * x46 - x43 * x47,
            x20 * x45 + x23 * x48,
            x0 * x51 + x21 * x39 + x37 * x49 - x38 * x50,
            x21 * x44 + x22 * x51 + x42 * x49 - x43 * x50,
            x21 * x45 + x23 * x51 + x31 * (x29 * x49 - x32 * x50),
        ]
    )
    return S


def eri_0102(a, A, b, B, c, C, d, D):
    """Cartesian [sp|sd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x9 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x2 - x22
    x24 = x15 * (c * C[1] + d * D[1])
    x25 = -x1 * (a * A[1] + b * B[1])
    x26 = -x24 - x25
    x27 = -x1 * (a * A[2] + b * B[2])
    x28 = -x15 * (c * C[2] + d * D[2]) - x27
    x29 = x21 * x8 * (x23**2 + x26**2 + x28**2)
    x30 = boys(0, x29)
    x31 = boys(1, x29)
    x32 = 2 * x10 * x14 * x20 * x6
    x33 = x31 * x32
    x34 = x0 * x21
    x35 = x5 * (2 * x10 * x14 * x20 * x30 * x6 - x33 * x34)
    x36 = x22 - C[0]
    x37 = x30 * x32
    x38 = x21 * x23
    x39 = x0 * x38
    x40 = x33 * x39 + x36 * x37
    x41 = x32 * boys(2, x29)
    x42 = x33 * x36 + x39 * x41
    x43 = x38 * x42
    x44 = x0 * x43 + x35 + x36 * x40
    x45 = x5 * (2 * x10 * x14 * x20 * x31 * x6 - x34 * x41)
    x46 = x32 * boys(3, x29)
    x47 = x36 * x41 + x39 * x46
    x48 = x38 * x47
    x49 = x0 * x48 + x36 * x42 + x45
    x50 = x38 * x7
    x51 = 2 * a + 2 * b + x4
    x52 = x51 ** (-1.0)
    x53 = x3 * x40 - x43 * x7 + x52 * (x3 * x33 - x41 * x50)
    x54 = 2 * x52
    x55 = x3 * x37 - x33 * x50
    x56 = x16 * x55
    x57 = x16 * x37
    x58 = x16 * x40 + x16 * (x40 + x57) + x44
    x59 = x24 - C[1]
    x60 = x21 * x26
    x61 = x0 * x60
    x62 = x33 * x59 + x41 * x61
    x63 = x41 * x59 + x46 * x61
    x64 = x33 * x61 + x37 * x59
    x65 = x36 * x64 + x39 * x62
    x66 = x36 * x62 + x39 * x63
    x67 = x17 * x55
    x68 = x3 * x64 - x50 * x62
    x69 = x67 + x68
    x70 = x17 * x37
    x71 = x64 + x70
    x72 = x16 * x71 + x17 * x40 + x65
    x73 = x18 * x40 + x18 * x57
    x74 = x35 + x59 * x64 + x61 * x62
    x75 = x45 + x59 * x62 + x61 * x63
    x76 = x17 * x64 + x17 * x71 + x74
    x77 = x18 * x64 + x18 * x70
    x78 = x19 * x37
    x79 = -x25 - A[1]
    x80 = x60 * x7
    x81 = x40 * x79 - x42 * x80
    x82 = -x33 * x80 + x37 * x79
    x83 = x16 * x82
    x84 = x17 * x82
    x85 = x52 * (x33 * x79 - x41 * x80) - x62 * x80 + x64 * x79
    x86 = x84 + x85
    x87 = -x27 - A[2]
    x88 = x21 * x28 * x7
    x89 = x40 * x87 - x42 * x88
    x90 = -x33 * x88 + x37 * x87
    x91 = -x62 * x88 + x64 * x87
    x92 = x17 * x90 + x91
    x93 = x52 * (x33 * x87 - x41 * x88)
    x94 = x18 * x90 + x93

    # 18 item(s)
    S = numpy.array(
        [
            x11 * x58
            + x16 * x53
            + x16 * (x53 + x56)
            + x3 * x44
            - x49 * x50
            + x54 * (x3 * x42 - x48 * x7 + x52 * (x3 * x41 - x46 * x50)),
            x11 * x72
            + x16 * x69
            + x17 * x53
            + x3 * x65
            - x50 * x66
            + x52 * (x3 * x62 - x50 * x63),
            x11 * x73 + x18 * x53 + x18 * x56,
            x11 * x76 + x17 * x68 + x17 * x69 + x3 * x74 - x50 * x75,
            x11 * x77 + x18 * x67 + x18 * x68,
            x11 * x78 + x19 * x55,
            x12 * x58 + x16 * x81 + x16 * (x81 + x83) + x44 * x79 - x49 * x80,
            x12 * x72
            + x16 * x86
            + x17 * x81
            + x52 * (x42 * x79 - x47 * x80)
            + x65 * x79
            - x66 * x80,
            x12 * x73 + x18 * x81 + x18 * x83,
            x12 * x76
            + x17 * x85
            + x17 * x86
            + x54 * (x52 * (x41 * x79 - x46 * x80) + x62 * x79 - x63 * x80)
            + x74 * x79
            - x75 * x80,
            x12 * x77 + x18 * x84 + x18 * x85,
            x12 * x78 + x19 * x82,
            x13 * x58 + x16 * x89 + x16 * (x16 * x90 + x89) + x44 * x87 - x49 * x88,
            x13 * x72 + x16 * x92 + x17 * x89 + x65 * x87 - x66 * x88,
            x13 * x73 + x16 * x94 + x18 * x89 + x52 * (x42 * x87 - x47 * x88),
            x13 * x76 + x17 * x91 + x17 * x92 + x74 * x87 - x75 * x88,
            x13 * x77 + x17 * x94 + x18 * x91 + x52 * (x62 * x87 - x63 * x88),
            x13 * x78 + x18 * x93 + x18 * x94 + 2 * (x41 * x87 - x46 * x88) / x51**2,
        ]
    )
    return S


def eri_0110(a, A, b, B, c, C, d, D):
    """Cartesian [sp|ps] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = c + d
    x2 = x1 ** (-1.0)
    x3 = x2 * (c * C[0] + d * D[0])
    x4 = x3 - C[0]
    x5 = a + b
    x6 = x1 + x5
    x7 = x6 ** (-1.0)
    x8 = x5 ** (-1.0)
    x9 = -x8 * (a * A[0] + b * B[0])
    x10 = -x3 - x9
    x11 = x2 * (c * C[1] + d * D[1])
    x12 = -x8 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x8 * (a * A[2] + b * B[2])
    x15 = -x14 - x2 * (c * C[2] + d * D[2])
    x16 = x1 * x5
    x17 = x16 * x7 * (x10**2 + x13**2 + x15**2)
    x18 = A[1] - B[1]
    x19 = A[2] - B[2]
    x20 = (
        2
        * numpy.pi**2.5
        * numpy.exp(-a * b * x8 * (x0**2 + x18**2 + x19**2))
        * numpy.exp(
            -c * d * x2 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
        )
        / (x16 + numpy.sqrt(x6))
    )
    x21 = x20 * boys(0, x17)
    x22 = x20 * boys(1, x17)
    x23 = x5 * x7
    x24 = x10 * x23
    x25 = x21 * x4 + x22 * x24
    x26 = (2 * a + 2 * b + 2 * c + 2 * d) ** (-1.0)
    x27 = -x9 - A[0]
    x28 = x1 * x7
    x29 = x10 * x28
    x30 = x20 * boys(2, x17)
    x31 = x22 * x4 + x24 * x30
    x32 = x11 - C[1]
    x33 = x13 * x23
    x34 = x21 * x32 + x22 * x33
    x35 = x22 * x32 + x30 * x33
    x36 = -x12 - A[1]
    x37 = x13 * x28
    x38 = -x14 - A[2]
    x39 = x15 * x28

    # 9 item(s)
    S = numpy.array(
        [
            x0 * x25 + x25 * x27 + x26 * (x22 * x27 - x29 * x30) - x29 * x31,
            x0 * x34 + x27 * x34 - x29 * x35,
            0,
            x18 * x25 + x25 * x36 - x31 * x37,
            x18 * x34 + x26 * (x22 * x36 - x30 * x37) + x34 * x36 - x35 * x37,
            0,
            x19 * x25 + x25 * x38 - x31 * x39,
            x19 * x34 + x34 * x38 - x35 * x39,
            x26 * (x22 * x38 - x30 * x39),
        ]
    )
    return S


def eri_0111(a, A, b, B, c, C, d, D):
    """Cartesian [sp|pp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x18**2))
    x20 = x9 ** (-1.0)
    x21 = x15 * (c * C[0] + d * D[0])
    x22 = -x2 - x21
    x23 = x15 * (c * C[1] + d * D[1])
    x24 = -x1 * (a * A[1] + b * B[1])
    x25 = -x23 - x24
    x26 = -x1 * (a * A[2] + b * B[2])
    x27 = -x15 * (c * C[2] + d * D[2]) - x26
    x28 = x20 * x8 * (x22**2 + x25**2 + x27**2)
    x29 = boys(0, x28)
    x30 = boys(1, x28)
    x31 = 2 * x10 * x14 * x19 * x6
    x32 = x30 * x31
    x33 = x0 * x20
    x34 = x5 * (2 * x10 * x14 * x19 * x29 * x6 - x32 * x33)
    x35 = x21 - C[0]
    x36 = x29 * x31
    x37 = x20 * x22
    x38 = x0 * x37
    x39 = x32 * x38 + x35 * x36
    x40 = x31 * boys(2, x28)
    x41 = x32 * x35 + x38 * x40
    x42 = x37 * x41
    x43 = x0 * x42 + x34 + x35 * x39
    x44 = x5 * (2 * x10 * x14 * x19 * x30 * x6 - x33 * x40)
    x45 = x31 * boys(3, x28)
    x46 = x35 * x40 + x38 * x45
    x47 = x37 * x46
    x48 = x0 * x47 + x35 * x41 + x44
    x49 = x37 * x7
    x50 = 2 * a + 2 * b + x4
    x51 = x50 ** (-1.0)
    x52 = x3 * x39 - x42 * x7 + x51 * (x3 * x32 - x40 * x49)
    x53 = 2 * x51
    x54 = x16 * x39 + x43
    x55 = x23 - C[1]
    x56 = x20 * x25
    x57 = x0 * x56
    x58 = x32 * x57 + x36 * x55
    x59 = x32 * x55 + x40 * x57
    x60 = x35 * x58 + x38 * x59
    x61 = x17 * x39 + x60
    x62 = x40 * x55 + x45 * x57
    x63 = x35 * x59 + x38 * x62
    x64 = x3 * x60 - x49 * x63 + x51 * (x3 * x59 - x49 * x62)
    x65 = x11 * x18
    x66 = x16 * x58 + x60
    x67 = x3 * x58 - x49 * x59
    x68 = x34 + x55 * x58 + x57 * x59
    x69 = x44 + x55 * x59 + x57 * x62
    x70 = x17 * x58 + x68
    x71 = -x24 - A[1]
    x72 = x56 * x7
    x73 = x39 * x71 - x41 * x72
    x74 = x51 * (x41 * x71 - x46 * x72) + x60 * x71 - x63 * x72
    x75 = x12 * x18
    x76 = x51 * (x32 * x71 - x40 * x72) + x58 * x71 - x59 * x72
    x77 = -x26 - A[2]
    x78 = x20 * x27 * x7
    x79 = x39 * x77 - x41 * x78
    x80 = x60 * x77 - x63 * x78
    x81 = x13 * x18
    x82 = x51 * (x41 * x77 - x46 * x78)
    x83 = x58 * x77 - x59 * x78
    x84 = x51 * (x59 * x77 - x62 * x78)
    x85 = x51 * (x32 * x77 - x40 * x78)

    # 27 item(s)
    S = numpy.array(
        [
            x11 * x54
            + x16 * x52
            + x3 * x43
            - x48 * x49
            + x53 * (x3 * x41 - x47 * x7 + x51 * (x3 * x40 - x45 * x49)),
            x11 * x61 + x17 * x52 + x64,
            x18 * x52 + x39 * x65,
            x11 * x66 + x16 * x67 + x64,
            x11 * x70 + x17 * x67 + x3 * x68 - x49 * x69,
            x18 * x67 + x58 * x65,
            0,
            0,
            0,
            x12 * x54 + x16 * x73 + x43 * x71 - x48 * x72,
            x12 * x61 + x17 * x73 + x74,
            x18 * x73 + x39 * x75,
            x12 * x66 + x16 * x76 + x74,
            x12 * x70
            + x17 * x76
            + x53 * (x51 * (x40 * x71 - x45 * x72) + x59 * x71 - x62 * x72)
            + x68 * x71
            - x69 * x72,
            x18 * x76 + x58 * x75,
            0,
            0,
            0,
            x13 * x54 + x16 * x79 + x43 * x77 - x48 * x78,
            x13 * x61 + x17 * x79 + x80,
            x18 * x79 + x39 * x81 + x82,
            x13 * x66 + x16 * x83 + x80,
            x13 * x70 + x17 * x83 + x68 * x77 - x69 * x78,
            x18 * x83 + x58 * x81 + x84,
            x16 * x85 + x82,
            x17 * x85 + x84,
            x18 * x85 + 2 * (x40 * x77 - x45 * x78) / x50**2,
        ]
    )
    return S


def eri_0112(a, A, b, B, c, C, d, D):
    """Cartesian [sp|pd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = c + d
    x5 = x4 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x6 - C[0]
    x8 = x0 + x4
    x9 = x8 ** (-1.0)
    x10 = -x2 - x6
    x11 = x5 * (c * C[1] + d * D[1])
    x12 = -x1 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x1 * (a * A[2] + b * B[2])
    x15 = -x14 - x5 * (c * C[2] + d * D[2])
    x16 = x0 * x4
    x17 = x16 * x9 * (x10**2 + x13**2 + x15**2)
    x18 = boys(1, x17)
    x19 = numpy.pi**2.5
    x20 = (x16 + numpy.sqrt(x8)) ** (-1.0)
    x21 = A[0] - B[0]
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x1 * (x21**2 + x22**2 + x23**2))
    x25 = C[0] - D[0]
    x26 = C[1] - D[1]
    x27 = C[2] - D[2]
    x28 = x27**2
    x29 = numpy.exp(-c * d * x5 * (x25**2 + x26**2 + x28))
    x30 = 2 * x19 * x20 * x24 * x29
    x31 = x18 * x30
    x32 = x0 * x9
    x33 = x10 * x32
    x34 = boys(2, x17)
    x35 = x30 * x34
    x36 = x31 * x7 + x33 * x35
    x37 = x32 * x36
    x38 = boys(0, x17)
    x39 = x30 * x38
    x40 = x31 * x33 + x39 * x7
    x41 = 2 * c + 2 * d
    x42 = x41 ** (-1.0)
    x43 = 2 * x42
    x44 = x42 * (2 * x19 * x20 * x24 * x29 * x38 - x31 * x32)
    x45 = x10 * x37 + x40 * x7 + x44
    x46 = x42 * (2 * x18 * x19 * x20 * x24 * x29 - x32 * x35)
    x47 = x30 * boys(3, x17)
    x48 = x33 * x47 + x35 * x7
    x49 = x32 * x48
    x50 = x10 * x49 + x36 * x7 + x46
    x51 = x10 * x50
    x52 = x32 * x51 + x43 * (-x37 + x40) + x45 * x7
    x53 = x42 * (2 * x19 * x20 * x24 * x29 * x34 - x32 * x47)
    x54 = x30 * boys(4, x17)
    x55 = x33 * x54 + x47 * x7
    x56 = x33 * x55 + x48 * x7 + x53
    x57 = x33 * x56 + x43 * (x36 - x49) + x50 * x7
    x58 = x4 * x9
    x59 = x10 * x58
    x60 = 2 * a + 2 * b + x41
    x61 = x60 ** (-1.0)
    x62 = 2 * x61
    x63 = (
        x3 * x45 - x51 * x58 + x62 * (x3 * x36 - x48 * x59 + x61 * (x3 * x35 - x47 * x59))
    )
    x64 = 3 * x61
    x65 = x3 * x40 - x36 * x59 + x61 * (x3 * x31 - x35 * x59)
    x66 = x25 * x65
    x67 = x25 * x40
    x68 = x25 * x45 + x25 * (x45 + x67) + x52
    x69 = x26 * x40
    x70 = x11 - C[1]
    x71 = x13 * x32
    x72 = x31 * x71 + x39 * x70
    x73 = x31 * x70 + x35 * x71
    x74 = x32 * x73
    x75 = x10 * x74 + x7 * x72
    x76 = x69 + x75
    x77 = x42 * (x72 - x74)
    x78 = x35 * x70 + x47 * x71
    x79 = x32 * x78
    x80 = x10 * x79 + x7 * x73
    x81 = x33 * x80 + x7 * x75 + x77
    x82 = x25 * x76 + x26 * x45 + x81
    x83 = x26 * x65
    x84 = x3 * x75 - x59 * x80 + x61 * (x3 * x73 - x59 * x78)
    x85 = x83 + x84
    x86 = x47 * x70 + x54 * x71
    x87 = x33 * x86 + x7 * x78
    x88 = x42 * (x73 - x79)
    x89 = x33 * x87 + x7 * x80 + x88
    x90 = (
        x3 * x81 - x59 * x89 + x62 * (x3 * x80 - x59 * x87 + x61 * (x3 * x78 - x59 * x86))
    )
    x91 = x27 * x45 + x27 * x67
    x92 = x13 * x74 + x44 + x70 * x72
    x93 = x13 * x79 + x46 + x70 * x73
    x94 = x33 * x93 + x7 * x92
    x95 = x26 * x75 + x94
    x96 = x26 * x76 + x95
    x97 = x53 + x70 * x78 + x71 * x86
    x98 = x33 * x97 + x7 * x93
    x99 = x26 * x84 + x3 * x94 - x59 * x98 + x61 * (x3 * x93 - x59 * x97)
    x100 = x27 * x75
    x101 = x100 + x27 * x69
    x102 = x27 * x84
    x103 = x21 * x28
    x104 = x25 * x72
    x105 = x25 * x75 + x25 * (x104 + x75) + x81
    x106 = x3 * x72 - x59 * x73
    x107 = x106 * x25
    x108 = x26 * x72
    x109 = x108 + x92
    x110 = x109 * x25 + x95
    x111 = x106 * x26
    x112 = x3 * x92 - x59 * x93
    x113 = x111 + x112
    x114 = x100 + x104 * x27
    x115 = x70 * x92 + x71 * x93 + 2 * x77
    x116 = x70 * x93 + x71 * x97 + 2 * x88
    x117 = x109 * x26 + x115 + x26 * x92
    x118 = x108 * x27 + x27 * x92
    x119 = -x12 - A[1]
    x120 = x13 * x58
    x121 = x119 * x45 - x120 * x50
    x122 = x119 * x40 - x120 * x36
    x123 = x122 * x25
    x124 = x122 * x26
    x125 = x119 * x75 - x120 * x80 + x61 * (x119 * x36 - x120 * x48)
    x126 = x124 + x125
    x127 = x119 * x81 - x120 * x89 + x61 * (x119 * x50 - x120 * x56)
    x128 = (
        x119 * x94
        - x120 * x98
        + x125 * x26
        + x62 * (x119 * x80 - x120 * x87 + x61 * (x119 * x48 - x120 * x55))
    )
    x129 = x125 * x27
    x130 = x22 * x28
    x131 = x119 * x72 - x120 * x73 + x61 * (x119 * x31 - x120 * x35)
    x132 = x131 * x25
    x133 = x131 * x26
    x134 = (
        x119 * x92
        - x120 * x93
        + x62 * (x119 * x73 - x120 * x78 + x61 * (x119 * x35 - x120 * x47))
    )
    x135 = x133 + x134
    x136 = -x14 - A[2]
    x137 = x15 * x58
    x138 = x136 * x45 - x137 * x50
    x139 = x136 * x40 - x137 * x36
    x140 = x136 * x75 - x137 * x80
    x141 = x139 * x26 + x140
    x142 = x136 * x81 - x137 * x89
    x143 = x61 * (x136 * x36 - x137 * x48)
    x144 = x139 * x27 + x143
    x145 = x61 * (x136 * x50 - x137 * x56)
    x146 = x136 * x94 - x137 * x98 + x140 * x26
    x147 = x61 * (x136 * x80 - x137 * x87)
    x148 = x140 * x27 + x147
    x149 = x23 * x28
    x150 = 2 / x60**2
    x151 = x143 * x27 + x150 * (x136 * x48 - x137 * x55)
    x152 = x136 * x72 - x137 * x73
    x153 = x136 * x92 - x137 * x93
    x154 = x152 * x26 + x153
    x155 = x61 * (x136 * x73 - x137 * x78)
    x156 = x152 * x27 + x155
    x157 = x61 * (x136 * x93 - x137 * x97)
    x158 = x150 * (x136 * x78 - x137 * x86) + x155 * x27
    x159 = x61 * (x136 * x31 - x137 * x35)
    x160 = x155 + x159 * x26
    x161 = x150 * (x136 * x35 - x137 * x47)
    x162 = x159 * x27 + x161

    # 54 item(s)
    S = numpy.array(
        [
            x21 * x68
            + x25 * x63
            + x25 * (x63 + x66)
            + x3 * x52
            - x57 * x59
            + x64
            * (
                x3 * x50
                - x56 * x59
                + x62 * (x3 * x48 - x55 * x59 + x61 * (x3 * x47 - x54 * x59))
            ),
            x21 * x82 + x25 * x85 + x26 * x63 + x90,
            x21 * x91 + x27 * x63 + x27 * x66,
            x21 * x96 + x26 * x85 + x99,
            x101 * x21 + x102 + x27 * x83,
            x103 * x40 + x28 * x65,
            x105 * x21 + x25 * x84 + x25 * (x107 + x84) + x90,
            x110 * x21 + x113 * x25 + x99,
            x102 + x107 * x27 + x114 * x21,
            x112 * x26 + x113 * x26 + x115 * x3 - x116 * x59 + x117 * x21,
            x111 * x27 + x112 * x27 + x118 * x21,
            x103 * x72 + x106 * x28,
            0,
            0,
            0,
            0,
            0,
            0,
            x119 * x52 - x120 * x57 + x121 * x25 + x22 * x68 + x25 * (x121 + x123),
            x121 * x26 + x126 * x25 + x127 + x22 * x82,
            x121 * x27 + x123 * x27 + x22 * x91,
            x126 * x26 + x128 + x22 * x96,
            x101 * x22 + x124 * x27 + x129,
            x122 * x28 + x130 * x40,
            x105 * x22 + x125 * x25 + x127 + x25 * (x125 + x132),
            x110 * x22 + x128 + x135 * x25,
            x114 * x22 + x129 + x132 * x27,
            x115 * x119
            - x116 * x120
            + x117 * x22
            + x134 * x26
            + x135 * x26
            + x64
            * (
                x119 * x93
                - x120 * x97
                + x62 * (x119 * x78 - x120 * x86 + x61 * (x119 * x47 - x120 * x54))
            ),
            x118 * x22 + x133 * x27 + x134 * x27,
            x130 * x72 + x131 * x28,
            0,
            0,
            0,
            0,
            0,
            0,
            x136 * x52 - x137 * x57 + x138 * x25 + x23 * x68 + x25 * (x138 + x139 * x25),
            x138 * x26 + x141 * x25 + x142 + x23 * x82,
            x138 * x27 + x144 * x25 + x145 + x23 * x91,
            x141 * x26 + x146 + x23 * x96,
            x101 * x23 + x144 * x26 + x148,
            x144 * x27 + x149 * x40 + x151,
            x105 * x23 + x140 * x25 + x142 + x25 * (x140 + x152 * x25),
            x110 * x23 + x146 + x154 * x25,
            x114 * x23 + x148 + x156 * x25,
            x115 * x136 - x116 * x137 + x117 * x23 + x153 * x26 + x154 * x26,
            x118 * x23 + x153 * x27 + x156 * x26 + x157,
            x149 * x72 + x156 * x27 + x158,
            x143 * x25 + x145 + x25 * (x143 + x159 * x25),
            x143 * x26 + x147 + x160 * x25,
            x151 + x162 * x25,
            x155 * x26 + x157 + x160 * x26,
            x158 + x162 * x26,
            x161 * x27 + x162 * x27 + 6 * (x136 * x47 - x137 * x54) / x60**3,
        ]
    )
    return S


def eri_0120(a, A, b, B, c, C, d, D):
    """Cartesian [sp|ds] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = A[0] - B[0]
    x1 = 2 * c + 2 * d
    x2 = x1 ** (-1.0)
    x3 = numpy.pi**2.5
    x4 = a + b
    x5 = c + d
    x6 = x4 * x5
    x7 = x4 + x5
    x8 = (x6 + numpy.sqrt(x7)) ** (-1.0)
    x9 = x4 ** (-1.0)
    x10 = A[1] - B[1]
    x11 = A[2] - B[2]
    x12 = numpy.exp(-a * b * x9 * (x0**2 + x10**2 + x11**2))
    x13 = x5 ** (-1.0)
    x14 = numpy.exp(
        -c * d * x13 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x15 = x7 ** (-1.0)
    x16 = x13 * (c * C[0] + d * D[0])
    x17 = -x9 * (a * A[0] + b * B[0])
    x18 = -x16 - x17
    x19 = x13 * (c * C[1] + d * D[1])
    x20 = -x9 * (a * A[1] + b * B[1])
    x21 = -x19 - x20
    x22 = -x9 * (a * A[2] + b * B[2])
    x23 = -x13 * (c * C[2] + d * D[2]) - x22
    x24 = x15 * x6 * (x18**2 + x21**2 + x23**2)
    x25 = boys(0, x24)
    x26 = boys(1, x24)
    x27 = 2 * x12 * x14 * x3 * x8
    x28 = x26 * x27
    x29 = x15 * x4
    x30 = x2 * (2 * x12 * x14 * x25 * x3 * x8 - x28 * x29)
    x31 = x16 - C[0]
    x32 = x25 * x27
    x33 = x15 * x18
    x34 = x33 * x4
    x35 = x27 * boys(2, x24)
    x36 = x28 * x31 + x34 * x35
    x37 = x30 + x31 * (x28 * x34 + x31 * x32) + x34 * x36
    x38 = -x17 - A[0]
    x39 = x2 * (2 * x12 * x14 * x26 * x3 * x8 - x29 * x35)
    x40 = x27 * boys(3, x24)
    x41 = x31 * x35 + x34 * x40
    x42 = x31 * x36 + x34 * x41 + x39
    x43 = x33 * x5
    x44 = 2 * a + 2 * b + x1
    x45 = x44 ** (-1.0)
    x46 = 2 * x45
    x47 = x19 - C[1]
    x48 = x15 * x21
    x49 = x4 * x48
    x50 = x28 * x49 + x32 * x47
    x51 = x28 * x47 + x35 * x49
    x52 = x31 * x50 + x34 * x51
    x53 = x35 * x47 + x40 * x49
    x54 = x31 * x51 + x34 * x53
    x55 = x30 + x47 * x50 + x49 * x51
    x56 = x39 + x47 * x51 + x49 * x53
    x57 = -x20 - A[1]
    x58 = x48 * x5
    x59 = -x22 - A[2]
    x60 = x15 * x23 * x5

    # 18 item(s)
    S = numpy.array(
        [
            x0 * x37
            + x37 * x38
            - x42 * x43
            + x46 * (x36 * x38 - x41 * x43 + x45 * (x35 * x38 - x40 * x43)),
            x0 * x52 + x38 * x52 - x43 * x54 + x45 * (x38 * x51 - x43 * x53),
            0,
            x0 * x55 + x38 * x55 - x43 * x56,
            0,
            0,
            x10 * x37 + x37 * x57 - x42 * x58,
            x10 * x52 + x45 * (x36 * x57 - x41 * x58) + x52 * x57 - x54 * x58,
            0,
            x10 * x55
            + x46 * (x45 * (x35 * x57 - x40 * x58) + x51 * x57 - x53 * x58)
            + x55 * x57
            - x56 * x58,
            0,
            0,
            x11 * x37 + x37 * x59 - x42 * x60,
            x11 * x52 + x52 * x59 - x54 * x60,
            x45 * (x36 * x59 - x41 * x60),
            x11 * x55 + x55 * x59 - x56 * x60,
            x45 * (x51 * x59 - x53 * x60),
            2 * (x35 * x59 - x40 * x60) / x44**2,
        ]
    )
    return S


def eri_0121(a, A, b, B, c, C, d, D):
    """Cartesian [sp|dp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = c + d
    x5 = x4 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x6 - C[0]
    x8 = x0 + x4
    x9 = x8 ** (-1.0)
    x10 = -x2 - x6
    x11 = x5 * (c * C[1] + d * D[1])
    x12 = -x1 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x1 * (a * A[2] + b * B[2])
    x15 = -x14 - x5 * (c * C[2] + d * D[2])
    x16 = x0 * x4
    x17 = x16 * x9 * (x10**2 + x13**2 + x15**2)
    x18 = boys(1, x17)
    x19 = numpy.pi**2.5
    x20 = (x16 + numpy.sqrt(x8)) ** (-1.0)
    x21 = A[0] - B[0]
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x1 * (x21**2 + x22**2 + x23**2))
    x25 = C[0] - D[0]
    x26 = C[1] - D[1]
    x27 = C[2] - D[2]
    x28 = numpy.exp(-c * d * x5 * (x25**2 + x26**2 + x27**2))
    x29 = 2 * x19 * x20 * x24 * x28
    x30 = x18 * x29
    x31 = x0 * x9
    x32 = x10 * x31
    x33 = boys(2, x17)
    x34 = x29 * x33
    x35 = x30 * x7 + x32 * x34
    x36 = x31 * x35
    x37 = boys(0, x17)
    x38 = x29 * x37
    x39 = x30 * x32 + x38 * x7
    x40 = 2 * c + 2 * d
    x41 = x40 ** (-1.0)
    x42 = 2 * x41
    x43 = x41 * (2 * x19 * x20 * x24 * x28 * x37 - x30 * x31)
    x44 = x10 * x36 + x39 * x7 + x43
    x45 = x41 * (2 * x18 * x19 * x20 * x24 * x28 - x31 * x34)
    x46 = x29 * boys(3, x17)
    x47 = x32 * x46 + x34 * x7
    x48 = x31 * x47
    x49 = x10 * x48 + x35 * x7 + x45
    x50 = x10 * x49
    x51 = x31 * x50 + x42 * (-x36 + x39) + x44 * x7
    x52 = x41 * (2 * x19 * x20 * x24 * x28 * x33 - x31 * x46)
    x53 = x29 * boys(4, x17)
    x54 = x32 * x53 + x46 * x7
    x55 = x32 * x54 + x47 * x7 + x52
    x56 = x32 * x55 + x42 * (x35 - x48) + x49 * x7
    x57 = x4 * x9
    x58 = x10 * x57
    x59 = 2 * a + 2 * b + x40
    x60 = x59 ** (-1.0)
    x61 = 2 * x60
    x62 = (
        x3 * x44 - x50 * x57 + x61 * (x3 * x35 - x47 * x58 + x60 * (x3 * x34 - x46 * x58))
    )
    x63 = 3 * x60
    x64 = x25 * x44 + x51
    x65 = x11 - C[1]
    x66 = x13 * x31
    x67 = x30 * x65 + x34 * x66
    x68 = x31 * x67
    x69 = x30 * x66 + x38 * x65
    x70 = x41 * (-x68 + x69)
    x71 = x10 * x68 + x69 * x7
    x72 = x34 * x65 + x46 * x66
    x73 = x31 * x72
    x74 = x10 * x73 + x67 * x7
    x75 = x32 * x74 + x7 * x71 + x70
    x76 = x26 * x44 + x75
    x77 = x46 * x65 + x53 * x66
    x78 = x32 * x77 + x7 * x72
    x79 = x41 * (x67 - x73)
    x80 = x32 * x78 + x7 * x74 + x79
    x81 = (
        x3 * x75 - x58 * x80 + x61 * (x3 * x74 - x58 * x78 + x60 * (x3 * x72 - x58 * x77))
    )
    x82 = x21 * x27
    x83 = x25 * x71 + x75
    x84 = x3 * x71 - x58 * x74 + x60 * (x3 * x67 - x58 * x72)
    x85 = x13 * x68 + x43 + x65 * x69
    x86 = x13 * x73 + x45 + x65 * x67
    x87 = x32 * x86 + x7 * x85
    x88 = x26 * x71 + x87
    x89 = x52 + x65 * x72 + x66 * x77
    x90 = x32 * x89 + x7 * x86
    x91 = x3 * x87 - x58 * x90 + x60 * (x3 * x86 - x58 * x89)
    x92 = x25 * x85 + x87
    x93 = x3 * x85 - x58 * x86
    x94 = x65 * x85 + x66 * x86 + 2 * x70
    x95 = x65 * x86 + x66 * x89 + 2 * x79
    x96 = x26 * x85 + x94
    x97 = -x12 - A[1]
    x98 = x13 * x57
    x99 = x44 * x97 - x49 * x98
    x100 = x60 * (x49 * x97 - x55 * x98) + x75 * x97 - x80 * x98
    x101 = x22 * x27
    x102 = x60 * (x35 * x97 - x47 * x98) + x71 * x97 - x74 * x98
    x103 = (
        x61 * (x60 * (x47 * x97 - x54 * x98) + x74 * x97 - x78 * x98)
        + x87 * x97
        - x90 * x98
    )
    x104 = (
        x61 * (x60 * (x34 * x97 - x46 * x98) + x67 * x97 - x72 * x98)
        + x85 * x97
        - x86 * x98
    )
    x105 = -x14 - A[2]
    x106 = x15 * x57
    x107 = x105 * x44 - x106 * x49
    x108 = x105 * x75 - x106 * x80
    x109 = x23 * x27
    x110 = x60 * (x105 * x49 - x106 * x55)
    x111 = x105 * x71 - x106 * x74
    x112 = x105 * x87 - x106 * x90
    x113 = x60 * (x105 * x74 - x106 * x78)
    x114 = x60 * (x105 * x35 - x106 * x47)
    x115 = 2 / x59**2
    x116 = x115 * (x105 * x47 - x106 * x54)
    x117 = x105 * x85 - x106 * x86
    x118 = x60 * (x105 * x86 - x106 * x89)
    x119 = x60 * (x105 * x67 - x106 * x72)
    x120 = x115 * (x105 * x72 - x106 * x77)
    x121 = x115 * (x105 * x34 - x106 * x46)

    # 54 item(s)
    S = numpy.array(
        [
            x21 * x64
            + x25 * x62
            + x3 * x51
            - x56 * x58
            + x63
            * (
                x3 * x49
                - x55 * x58
                + x61 * (x3 * x47 - x54 * x58 + x60 * (x3 * x46 - x53 * x58))
            ),
            x21 * x76 + x26 * x62 + x81,
            x27 * x62 + x44 * x82,
            x21 * x83 + x25 * x84 + x81,
            x21 * x88 + x26 * x84 + x91,
            x27 * x84 + x71 * x82,
            0,
            0,
            0,
            x21 * x92 + x25 * x93 + x91,
            x21 * x96 + x26 * x93 + x3 * x94 - x58 * x95,
            x27 * x93 + x82 * x85,
            0,
            0,
            0,
            0,
            0,
            0,
            x22 * x64 + x25 * x99 + x51 * x97 - x56 * x98,
            x100 + x22 * x76 + x26 * x99,
            x101 * x44 + x27 * x99,
            x100 + x102 * x25 + x22 * x83,
            x102 * x26 + x103 + x22 * x88,
            x101 * x71 + x102 * x27,
            0,
            0,
            0,
            x103 + x104 * x25 + x22 * x92,
            x104 * x26
            + x22 * x96
            + x63
            * (
                x61 * (x60 * (x46 * x97 - x53 * x98) + x72 * x97 - x77 * x98)
                + x86 * x97
                - x89 * x98
            )
            + x94 * x97
            - x95 * x98,
            x101 * x85 + x104 * x27,
            0,
            0,
            0,
            0,
            0,
            0,
            x105 * x51 - x106 * x56 + x107 * x25 + x23 * x64,
            x107 * x26 + x108 + x23 * x76,
            x107 * x27 + x109 * x44 + x110,
            x108 + x111 * x25 + x23 * x83,
            x111 * x26 + x112 + x23 * x88,
            x109 * x71 + x111 * x27 + x113,
            x110 + x114 * x25,
            x113 + x114 * x26,
            x114 * x27 + x116,
            x112 + x117 * x25 + x23 * x92,
            x105 * x94 - x106 * x95 + x117 * x26 + x23 * x96,
            x109 * x85 + x117 * x27 + x118,
            x113 + x119 * x25,
            x118 + x119 * x26,
            x119 * x27 + x120,
            x116 + x121 * x25,
            x120 + x121 * x26,
            x121 * x27 + 6 * (x105 * x46 - x106 * x53) / x59**3,
        ]
    )
    return S


def eri_0122(a, A, b, B, c, C, d, D):
    """Cartesian [sp|dd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x9 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x2 - x22
    x24 = x15 * (c * C[1] + d * D[1])
    x25 = -x1 * (a * A[1] + b * B[1])
    x26 = -x24 - x25
    x27 = -x1 * (a * A[2] + b * B[2])
    x28 = -x15 * (c * C[2] + d * D[2]) - x27
    x29 = x21 * x8 * (x23**2 + x26**2 + x28**2)
    x30 = boys(1, x29)
    x31 = x0 * x21
    x32 = boys(2, x29)
    x33 = 2 * x10 * x14 * x20 * x6
    x34 = x32 * x33
    x35 = x5 * (2 * x10 * x14 * x20 * x30 * x6 - x31 * x34)
    x36 = x22 - C[0]
    x37 = x30 * x33
    x38 = x23 * x31
    x39 = x34 * x38 + x36 * x37
    x40 = boys(3, x29)
    x41 = x33 * x40
    x42 = x34 * x36 + x38 * x41
    x43 = x31 * x42
    x44 = x23 * x43 + x35 + x36 * x39
    x45 = x31 * x44
    x46 = boys(0, x29)
    x47 = x5 * (2 * x10 * x14 * x20 * x46 * x6 - x31 * x37)
    x48 = x33 * x46
    x49 = x36 * x48 + x37 * x38
    x50 = x31 * x39
    x51 = x23 * x50 + x36 * x49 + x47
    x52 = 3 * x5
    x53 = 2 * x5
    x54 = x23 * x45 + x36 * x51 + x53 * (x49 - x50)
    x55 = x5 * (2 * x10 * x14 * x20 * x32 * x6 - x31 * x41)
    x56 = x33 * boys(4, x29)
    x57 = x36 * x41 + x38 * x56
    x58 = x31 * x57
    x59 = x23 * x58 + x36 * x42 + x55
    x60 = x31 * x59
    x61 = x23 * x60 + x36 * x44 + x53 * (x39 - x43)
    x62 = x23 * x61
    x63 = x31 * x62 + x36 * x54 + x52 * (-x45 + x51)
    x64 = x5 * (2 * x10 * x14 * x20 * x40 * x6 - x31 * x56)
    x65 = x33 * boys(5, x29)
    x66 = x36 * x56 + x38 * x65
    x67 = x36 * x57 + x38 * x66 + x64
    x68 = x36 * x59 + x38 * x67 + x53 * (x42 - x58)
    x69 = x36 * x61 + x38 * x68 + x52 * (x44 - x60)
    x70 = x21 * x7
    x71 = x23 * x70
    x72 = 2 * a + 2 * b + x4
    x73 = x72 ** (-1.0)
    x74 = 2 * x73
    x75 = 3 * x73
    x76 = (
        x3 * x54
        - x62 * x70
        + x75
        * (
            x3 * x44
            - x59 * x71
            + x74 * (x3 * x42 - x57 * x71 + x73 * (x3 * x41 - x56 * x71))
        )
    )
    x77 = 4 * x73
    x78 = (
        x3 * x51 - x44 * x71 + x74 * (x3 * x39 - x42 * x71 + x73 * (x3 * x34 - x41 * x71))
    )
    x79 = x16 * x78
    x80 = x16 * x51
    x81 = x16 * x54 + x16 * (x54 + x80) + x63
    x82 = x17 * x51
    x83 = x24 - C[1]
    x84 = x26 * x31
    x85 = x34 * x84 + x37 * x83
    x86 = x31 * x85
    x87 = x37 * x84 + x48 * x83
    x88 = x5 * (-x86 + x87)
    x89 = x23 * x86 + x36 * x87
    x90 = x34 * x83 + x41 * x84
    x91 = x31 * x90
    x92 = x23 * x91 + x36 * x85
    x93 = x31 * x92
    x94 = x23 * x93 + x36 * x89 + x88
    x95 = x82 + x94
    x96 = x5 * (x85 - x91)
    x97 = x41 * x83 + x56 * x84
    x98 = x31 * x97
    x99 = x23 * x98 + x36 * x90
    x100 = x31 * x99
    x101 = x100 * x23 + x36 * x92 + x96
    x102 = x101 * x38 + x36 * x94 + x53 * (x89 - x93)
    x103 = x102 + x16 * x95 + x17 * x54
    x104 = x17 * x78
    x105 = (
        -x101 * x71
        + x3 * x94
        + x74 * (x3 * x92 - x71 * x99 + x73 * (x3 * x90 - x71 * x97))
    )
    x106 = x104 + x105
    x107 = x5 * (x90 - x98)
    x108 = x56 * x83 + x65 * x84
    x109 = x108 * x38 + x36 * x97
    x110 = x107 + x109 * x38 + x36 * x99
    x111 = x101 * x36 + x110 * x38 + x53 * (-x100 + x92)
    x112 = (
        x102 * x3
        - x111 * x71
        + x75
        * (
            x101 * x3
            - x110 * x71
            + x74 * (-x109 * x71 + x3 * x99 + x73 * (-x108 * x71 + x3 * x97))
        )
    )
    x113 = x18 * x54 + x18 * x80
    x114 = x26 * x91 + x35 + x83 * x85
    x115 = x114 * x31
    x116 = x26 * x86 + x47 + x83 * x87
    x117 = x5 * (-x115 + x116)
    x118 = x115 * x23 + x116 * x36
    x119 = x26 * x98 + x55 + x83 * x90
    x120 = x119 * x31
    x121 = x114 * x36 + x120 * x23
    x122 = x117 + x118 * x36 + x121 * x38
    x123 = x122 + x17 * x94
    x124 = x123 + x17 * x95
    x125 = x108 * x84 + x64 + x83 * x97
    x126 = x119 * x36 + x125 * x38
    x127 = x5 * (x114 - x120)
    x128 = x121 * x36 + x126 * x38 + x127
    x129 = (
        x122 * x3
        - x128 * x71
        + x74 * (x121 * x3 - x126 * x71 + x73 * (x119 * x3 - x125 * x71))
    )
    x130 = x105 * x17 + x129
    x131 = x18 * x94
    x132 = x131 + x18 * x82
    x133 = x105 * x18
    x134 = x11 * x19
    x135 = x16 * x89
    x136 = x102 + x16 * x94 + x16 * (x135 + x94)
    x137 = x3 * x89 - x71 * x92 + x73 * (x3 * x85 - x71 * x90)
    x138 = x137 * x16
    x139 = x17 * x89
    x140 = x118 + x139
    x141 = x123 + x140 * x16
    x142 = x137 * x17
    x143 = x118 * x3 - x121 * x71 + x73 * (x114 * x3 - x119 * x71)
    x144 = x142 + x143
    x145 = x131 + x135 * x18
    x146 = x115 * x26 + x116 * x83 + 2 * x88
    x147 = x114 * x83 + x120 * x26 + 2 * x96
    x148 = x146 * x36 + x147 * x38
    x149 = x118 * x17 + x148
    x150 = x140 * x17 + x149
    x151 = 2 * x107 + x119 * x83 + x125 * x84
    x152 = x147 * x36 + x151 * x38
    x153 = x143 * x17 + x148 * x3 - x152 * x71 + x73 * (x147 * x3 - x151 * x71)
    x154 = x118 * x18
    x155 = x139 * x18 + x154
    x156 = x143 * x18
    x157 = x116 * x16
    x158 = x118 * x16 + x122 + x16 * (x118 + x157)
    x159 = -x114 * x71 + x116 * x3
    x160 = x159 * x16
    x161 = x116 * x17
    x162 = x146 + x161
    x163 = x149 + x16 * x162
    x164 = x159 * x17
    x165 = x146 * x3 - x147 * x71
    x166 = x164 + x165
    x167 = x154 + x157 * x18
    x168 = 3 * x117 + x146 * x83 + x147 * x84
    x169 = 3 * x127 + x147 * x83 + x151 * x84
    x170 = x146 * x17 + x162 * x17 + x168
    x171 = x146 * x18 + x161 * x18
    x172 = -x25 - A[1]
    x173 = x26 * x70
    x174 = x172 * x54 - x173 * x61
    x175 = x172 * x51 - x173 * x44
    x176 = x16 * x175
    x177 = x17 * x175
    x178 = -x101 * x173 + x172 * x94 + x73 * (x172 * x44 - x173 * x59)
    x179 = x177 + x178
    x180 = x102 * x172 - x111 * x173 + x73 * (x172 * x61 - x173 * x68)
    x181 = (
        x122 * x172
        - x128 * x173
        + x74 * (x101 * x172 - x110 * x173 + x73 * (x172 * x59 - x173 * x67))
    )
    x182 = x17 * x178 + x181
    x183 = x178 * x18
    x184 = x12 * x19
    x185 = x172 * x89 - x173 * x92 + x73 * (x172 * x39 - x173 * x42)
    x186 = x16 * x185
    x187 = x17 * x185
    x188 = (
        x118 * x172
        - x121 * x173
        + x74 * (x172 * x92 - x173 * x99 + x73 * (x172 * x42 - x173 * x57))
    )
    x189 = x187 + x188
    x190 = (
        x148 * x172
        - x152 * x173
        + x17 * x188
        + x75
        * (
            x121 * x172
            - x126 * x173
            + x74 * (-x109 * x173 + x172 * x99 + x73 * (x172 * x57 - x173 * x66))
        )
    )
    x191 = x18 * x188
    x192 = (
        -x114 * x173
        + x116 * x172
        + x74 * (x172 * x85 - x173 * x90 + x73 * (x172 * x34 - x173 * x41))
    )
    x193 = x16 * x192
    x194 = x17 * x192
    x195 = (
        x146 * x172
        - x147 * x173
        + x75
        * (
            x114 * x172
            - x119 * x173
            + x74 * (x172 * x90 - x173 * x97 + x73 * (x172 * x41 - x173 * x56))
        )
    )
    x196 = x194 + x195
    x197 = -x27 - A[2]
    x198 = x28 * x70
    x199 = x197 * x54 - x198 * x61
    x200 = x197 * x51 - x198 * x44
    x201 = -x101 * x198 + x197 * x94
    x202 = x17 * x200 + x201
    x203 = x102 * x197 - x111 * x198
    x204 = x73 * (x197 * x44 - x198 * x59)
    x205 = x18 * x200 + x204
    x206 = x73 * (x197 * x61 - x198 * x68)
    x207 = x122 * x197 - x128 * x198
    x208 = x17 * x201 + x207
    x209 = x73 * (x101 * x197 - x110 * x198)
    x210 = x18 * x201 + x209
    x211 = x13 * x19
    x212 = 2 / x72**2
    x213 = x212 * (x197 * x59 - x198 * x67)
    x214 = x18 * x204 + x213
    x215 = x197 * x89 - x198 * x92
    x216 = x118 * x197 - x121 * x198
    x217 = x17 * x215 + x216
    x218 = x73 * (x197 * x92 - x198 * x99)
    x219 = x18 * x215 + x218
    x220 = x148 * x197 - x152 * x198 + x17 * x216
    x221 = x73 * (x121 * x197 - x126 * x198)
    x222 = x18 * x216 + x221
    x223 = x212 * (-x109 * x198 + x197 * x99)
    x224 = x18 * x218 + x223
    x225 = x73 * (x197 * x39 - x198 * x42)
    x226 = x17 * x225 + x218
    x227 = x212 * (x197 * x42 - x198 * x57)
    x228 = x18 * x225 + x227
    x229 = x17 * x218 + x221
    x230 = 6 / x72**3
    x231 = x18 * x227 + x230 * (x197 * x57 - x198 * x66)
    x232 = -x114 * x198 + x116 * x197
    x233 = x146 * x197 - x147 * x198
    x234 = x17 * x232 + x233
    x235 = x73 * (x114 * x197 - x119 * x198)
    x236 = x18 * x232 + x235
    x237 = x73 * (x147 * x197 - x151 * x198)
    x238 = x212 * (x119 * x197 - x125 * x198)
    x239 = x18 * x235 + x238
    x240 = x73 * (x197 * x85 - x198 * x90)
    x241 = x17 * x240 + x235
    x242 = x212 * (x197 * x90 - x198 * x97)
    x243 = x18 * x240 + x242
    x244 = x18 * x242 + x230 * (-x108 * x198 + x197 * x97)
    x245 = x212 * (x197 * x34 - x198 * x41)
    x246 = x17 * x245 + x242
    x247 = x230 * (x197 * x41 - x198 * x56)
    x248 = x18 * x245 + x247

    # 108 item(s)
    S = numpy.array(
        [
            x11 * x81
            + x16 * x76
            + x16 * (x76 + x79)
            + x3 * x63
            - x69 * x71
            + x77
            * (
                x3 * x61
                - x68 * x71
                + x75
                * (
                    x3 * x59
                    - x67 * x71
                    + x74 * (x3 * x57 - x66 * x71 + x73 * (x3 * x56 - x65 * x71))
                )
            ),
            x103 * x11 + x106 * x16 + x112 + x17 * x76,
            x11 * x113 + x18 * x76 + x18 * x79,
            x106 * x17 + x11 * x124 + x130,
            x104 * x18 + x11 * x132 + x133,
            x134 * x51 + x19 * x78,
            x105 * x16 + x11 * x136 + x112 + x16 * (x105 + x138),
            x11 * x141 + x130 + x144 * x16,
            x11 * x145 + x133 + x138 * x18,
            x11 * x150 + x144 * x17 + x153,
            x11 * x155 + x142 * x18 + x156,
            x134 * x89 + x137 * x19,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x158 + x129 + x143 * x16 + x16 * (x143 + x160),
            x11 * x163 + x153 + x16 * x166,
            x11 * x167 + x156 + x160 * x18,
            x11 * x170 + x165 * x17 + x166 * x17 + x168 * x3 - x169 * x71,
            x11 * x171 + x164 * x18 + x165 * x18,
            x116 * x134 + x159 * x19,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x81 + x16 * x174 + x16 * (x174 + x176) + x172 * x63 - x173 * x69,
            x103 * x12 + x16 * x179 + x17 * x174 + x180,
            x113 * x12 + x174 * x18 + x176 * x18,
            x12 * x124 + x17 * x179 + x182,
            x12 * x132 + x177 * x18 + x183,
            x175 * x19 + x184 * x51,
            x12 * x136 + x16 * x178 + x16 * (x178 + x186) + x180,
            x12 * x141 + x16 * x189 + x182,
            x12 * x145 + x18 * x186 + x183,
            x12 * x150 + x17 * x189 + x190,
            x12 * x155 + x18 * x187 + x191,
            x184 * x89 + x185 * x19,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x158 + x16 * x188 + x16 * (x188 + x193) + x181,
            x12 * x163 + x16 * x196 + x190,
            x12 * x167 + x18 * x193 + x191,
            x12 * x170
            + x168 * x172
            - x169 * x173
            + x17 * x195
            + x17 * x196
            + x77
            * (
                x147 * x172
                - x151 * x173
                + x75
                * (
                    x119 * x172
                    - x125 * x173
                    + x74 * (-x108 * x173 + x172 * x97 + x73 * (x172 * x56 - x173 * x65))
                )
            ),
            x12 * x171 + x18 * x194 + x18 * x195,
            x116 * x184 + x19 * x192,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x81 + x16 * x199 + x16 * (x16 * x200 + x199) + x197 * x63 - x198 * x69,
            x103 * x13 + x16 * x202 + x17 * x199 + x203,
            x113 * x13 + x16 * x205 + x18 * x199 + x206,
            x124 * x13 + x17 * x202 + x208,
            x13 * x132 + x17 * x205 + x210,
            x18 * x205 + x211 * x51 + x214,
            x13 * x136 + x16 * x201 + x16 * (x16 * x215 + x201) + x203,
            x13 * x141 + x16 * x217 + x208,
            x13 * x145 + x16 * x219 + x210,
            x13 * x150 + x17 * x217 + x220,
            x13 * x155 + x17 * x219 + x222,
            x18 * x219 + x211 * x89 + x224,
            x16 * x204 + x16 * (x16 * x225 + x204) + x206,
            x16 * x226 + x17 * x204 + x209,
            x16 * x228 + x214,
            x17 * x226 + x229,
            x17 * x228 + x224,
            x18 * x228 + x231,
            x13 * x158 + x16 * x216 + x16 * (x16 * x232 + x216) + x207,
            x13 * x163 + x16 * x234 + x220,
            x13 * x167 + x16 * x236 + x222,
            x13 * x170 + x168 * x197 - x169 * x198 + x17 * x233 + x17 * x234,
            x13 * x171 + x17 * x236 + x18 * x233 + x237,
            x116 * x211 + x18 * x236 + x239,
            x16 * x218 + x16 * (x16 * x240 + x218) + x209,
            x16 * x241 + x229,
            x16 * x243 + x224,
            x17 * x235 + x17 * x241 + x237,
            x17 * x243 + x239,
            x18 * x243 + x244,
            x16 * x227 + x16 * (x16 * x245 + x227) + x213,
            x16 * x246 + x17 * x227 + x223,
            x16 * x248 + x231,
            x17 * x242 + x17 * x246 + x238,
            x17 * x248 + x244,
            x18 * x247 + x18 * x248 + 24 * (x197 * x56 - x198 * x65) / x72**4,
        ]
    )
    return S


def eri_0200(a, A, b, B, c, C, d, D):
    """Cartesian [sd|ss] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = numpy.pi**2.5
    x1 = a + b
    x2 = c + d
    x3 = x1 * x2
    x4 = x1 + x2
    x5 = (x3 + numpy.sqrt(x4)) ** (-1.0)
    x6 = x1 ** (-1.0)
    x7 = A[0] - B[0]
    x8 = A[1] - B[1]
    x9 = A[2] - B[2]
    x10 = numpy.exp(-a * b * x6 * (x7**2 + x8**2 + x9**2))
    x11 = x2 ** (-1.0)
    x12 = numpy.exp(
        -c * d * x11 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x13 = x4 ** (-1.0)
    x14 = -x6 * (a * A[0] + b * B[0])
    x15 = -x11 * (c * C[0] + d * D[0]) - x14
    x16 = -x6 * (a * A[1] + b * B[1])
    x17 = -x11 * (c * C[1] + d * D[1]) - x16
    x18 = -x6 * (a * A[2] + b * B[2])
    x19 = -x11 * (c * C[2] + d * D[2]) - x18
    x20 = x13 * x3 * (x15**2 + x17**2 + x19**2)
    x21 = boys(0, x20)
    x22 = x13 * x2
    x23 = 2 * x0 * x10 * x12 * x5
    x24 = x23 * boys(1, x20)
    x25 = (2 * x0 * x10 * x12 * x21 * x5 - x22 * x24) / (2 * a + 2 * b)
    x26 = -x14 - A[0]
    x27 = x21 * x23
    x28 = x15 * x22
    x29 = -x24 * x28 + x26 * x27
    x30 = x23 * boys(2, x20)
    x31 = -x16 - A[1]
    x32 = x17 * x22
    x33 = -x24 * x32 + x27 * x31
    x34 = x24 * x31 - x30 * x32
    x35 = x27 * x8 + x33
    x36 = -x18 - A[2]
    x37 = x19 * x22
    x38 = -x24 * x37 + x27 * x36
    x39 = x24 * x36 - x30 * x37
    x40 = x27 * x9 + x38

    # 6 item(s)
    S = numpy.array(
        [
            x25
            + x26 * x29
            - x28 * (x24 * x26 - x28 * x30)
            + x29 * x7
            + x7 * (x27 * x7 + x29),
            x26 * x33 - x28 * x34 + x29 * x8 + x35 * x7,
            x26 * x38 - x28 * x39 + x29 * x9 + x40 * x7,
            x25 + x31 * x33 - x32 * x34 + x33 * x8 + x35 * x8,
            x31 * x38 - x32 * x39 + x33 * x9 + x40 * x8,
            x25 + x36 * x38 - x37 * x39 + x38 * x9 + x40 * x9,
        ]
    )
    return S


def eri_0201(a, A, b, B, c, C, d, D):
    """Cartesian [sd|sp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(1, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x9 * (x22**2 + x23**2 + x24**2))
    x26 = C[0] - D[0]
    x27 = C[1] - D[1]
    x28 = C[2] - D[2]
    x29 = numpy.exp(-c * d * x3 * (x26**2 + x27**2 + x28**2))
    x30 = 2 * x20 * x21 * x25 * x29
    x31 = x19 * x30
    x32 = x30 * boys(2, x18)
    x33 = x6 * x8
    x34 = x11 * x33
    x35 = x31 * x5 + x32 * x34
    x36 = x2 * x8
    x37 = x35 * x36
    x38 = boys(0, x18)
    x39 = x30 * x38
    x40 = x31 * x34 + x39 * x5
    x41 = x1 * (-x37 + x40)
    x42 = x1 * (2 * x20 * x21 * x25 * x29 * x38 - x31 * x36)
    x43 = -x10 - A[0]
    x44 = x11 * x36
    x45 = -x31 * x44 + x39 * x43
    x46 = x31 * x43 - x32 * x44
    x47 = x42 + x43 * x45 - x44 * x46
    x48 = (2 * c + 2 * d + x0) ** (-1.0)
    x49 = x1 * (2 * x19 * x20 * x21 * x25 * x29 - x32 * x36)
    x50 = x30 * boys(3, x18)
    x51 = x32 * x43 - x44 * x50
    x52 = -x11 * x37 + x40 * x43 + x46 * x48
    x53 = x32 * x5 + x34 * x50
    x54 = x26 * x45 + x52
    x55 = x26 * x39 + x40
    x56 = x12 - C[1]
    x57 = x14 * x33
    x58 = x31 * x56 + x32 * x57
    x59 = x36 * x58
    x60 = x31 * x57 + x39 * x56
    x61 = x1 * (-x59 + x60)
    x62 = -x11 * x59 + x43 * x60
    x63 = x32 * x56 + x50 * x57
    x64 = x27 * x45 + x62
    x65 = x27 * x39 + x60
    x66 = x28 * x45
    x67 = x28 * x39
    x68 = -x13 - A[1]
    x69 = x14 * x36
    x70 = -x31 * x69 + x39 * x68
    x71 = x31 * x68 - x32 * x69
    x72 = x43 * x70 - x44 * x71
    x73 = x32 * x68 - x50 * x69
    x74 = -x14 * x37 + x40 * x68
    x75 = x35 * x68 - x53 * x69
    x76 = x26 * x70 + x74
    x77 = x23 * x55 + x76
    x78 = -x14 * x59 + x48 * x71 + x60 * x68
    x79 = x48 * x73 + x58 * x68 - x63 * x69
    x80 = x27 * x70 + x78
    x81 = x23 * x65 + x80
    x82 = x28 * x70
    x83 = x23 * x67 + x82
    x84 = -x15 - A[2]
    x85 = x16 * x36
    x86 = -x31 * x85 + x39 * x84
    x87 = x31 * x84 - x32 * x85
    x88 = x43 * x86 - x44 * x87
    x89 = x43 * x87
    x90 = x32 * x84 - x50 * x85
    x91 = x44 * x90
    x92 = -x16 * x37 + x40 * x84
    x93 = x35 * x84 - x53 * x85
    x94 = x26 * x86 + x92
    x95 = x24 * x55 + x94
    x96 = -x16 * x59 + x60 * x84
    x97 = x58 * x84 - x63 * x85
    x98 = x27 * x86 + x96
    x99 = x24 * x65 + x98
    x100 = x48 * x87
    x101 = x100 + x28 * x86
    x102 = x101 + x24 * x67
    x103 = x42 + x68 * x70 - x69 * x71
    x104 = x68 * x86 - x69 * x87
    x105 = x69 * x90
    x106 = x42 + x84 * x86 - x85 * x87
    x107 = x85 * x90

    # 18 item(s)
    S = numpy.array(
        [
            x22 * x54
            + x22 * (x22 * x55 + x54)
            + x26 * x47
            + x41
            + x43 * x52
            - x44 * (x35 * x43 - x44 * x53 + x48 * x51)
            + x48 * (x43 * x46 - x44 * x51 + x49),
            x22 * x64
            + x22 * (x22 * x65 + x64)
            + x27 * x47
            + x43 * x62
            - x44 * (x43 * x58 - x44 * x63)
            + x61,
            x22 * x66 + x22 * (x22 * x67 + x66) + x28 * x47,
            x22 * x77
            + x23 * x54
            + x26 * x72
            + x43 * x74
            - x44 * x75
            + x48 * (x43 * x71 - x44 * x73),
            x22 * x81 + x23 * x64 + x27 * x72 + x43 * x78 - x44 * x79,
            x22 * x83 + x23 * x66 + x28 * x72,
            x22 * x95 + x24 * x54 + x26 * x88 + x43 * x92 - x44 * x93 + x48 * (x89 - x91),
            x22 * x99 + x24 * x64 + x27 * x88 + x43 * x96 - x44 * x97,
            x102 * x22 + x24 * x66 + x28 * x88 + x48 * x89 - x48 * x91,
            x103 * x26 + x23 * x76 + x23 * x77 + x41 + x68 * x74 - x69 * x75,
            x103 * x27
            + x23 * x80
            + x23 * x81
            + x48 * (x49 + x68 * x71 - x69 * x73)
            + x61
            + x68 * x78
            - x69 * x79,
            x103 * x28 + x23 * x82 + x23 * x83,
            x104 * x26 + x23 * x95 + x24 * x76 + x68 * x92 - x69 * x93,
            x104 * x27
            + x23 * x99
            + x24 * x80
            + x48 * (-x105 + x68 * x87)
            + x68 * x96
            - x69 * x97,
            x100 * x68 + x102 * x23 + x104 * x28 - x105 * x48 + x24 * x82,
            x106 * x26 + x24 * x94 + x24 * x95 + x41 + x84 * x92 - x85 * x93,
            x106 * x27 + x24 * x98 + x24 * x99 + x61 + x84 * x96 - x85 * x97,
            x100 * x84
            + x101 * x24
            + x102 * x24
            + x106 * x28
            - x107 * x48
            + x48 * (-x107 + x49 + x84 * x87),
        ]
    )
    return S


def eri_0202(a, A, b, B, c, C, d, D):
    """Cartesian [sd|sd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x10 * (x11**2 + x12**2 + x13**2))
    x15 = x6 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x8 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x10 * (a * A[0] + b * B[0])
    x24 = -x22 - x23
    x25 = x15 * (c * C[1] + d * D[1])
    x26 = -x10 * (a * A[1] + b * B[1])
    x27 = -x25 - x26
    x28 = -x10 * (a * A[2] + b * B[2])
    x29 = -x15 * (c * C[2] + d * D[2]) - x28
    x30 = x21 * x7 * (x24**2 + x27**2 + x29**2)
    x31 = boys(1, x30)
    x32 = -2 * x14 * x20 * x31 * x4 * x9
    x33 = x21 * x5
    x34 = boys(2, x30)
    x35 = 2 * x14 * x20 * x4 * x9
    x36 = x34 * x35
    x37 = x3 * (-x32 - x33 * x36)
    x38 = x22 - C[0]
    x39 = x31 * x35
    x40 = x24 * x33
    x41 = x36 * x40 + x38 * x39
    x42 = x35 * boys(3, x30)
    x43 = x36 * x38 + x40 * x42
    x44 = x37 + x38 * x41 + x40 * x43
    x45 = x21 * x6
    x46 = x44 * x45
    x47 = boys(0, x30)
    x48 = -2 * x14 * x20 * x4 * x47 * x9
    x49 = x3 * (-x33 * x39 - x48)
    x50 = x35 * x47
    x51 = x38 * x50 + x39 * x40
    x52 = x38 * x51 + x40 * x41 + x49
    x53 = x1 * (-x46 + x52)
    x54 = -x23 - A[0]
    x55 = x0 + x2
    x56 = x55 ** (-1.0)
    x57 = x24 * x45
    x58 = x36 * x54 - x42 * x57
    x59 = x43 * x45
    x60 = -x24 * x59 + x41 * x54 + x56 * x58
    x61 = 2 * x56
    x62 = -x24 * x46 + x52 * x54 + x60 * x61
    x63 = -2 * x14 * x20 * x34 * x4 * x9
    x64 = x3 * (-x33 * x42 - x63)
    x65 = x35 * boys(4, x30)
    x66 = x38 * x42 + x40 * x65
    x67 = x38 * x43 + x40 * x66 + x64
    x68 = x42 * x54 - x57 * x65
    x69 = x43 * x54 + x56 * x68 - x57 * x66
    x70 = x41 * x45
    x71 = x1 * (x51 - x70)
    x72 = x1 * (-x32 - x36 * x45)
    x73 = -x36 * x57 + x39 * x54
    x74 = -x24 * x70 + x51 * x54 + x56 * x73
    x75 = x54 * x74 + x56 * (x54 * x73 - x57 * x58 + x72) - x57 * x60 + x71
    x76 = x1 * (x41 - x59)
    x77 = x1 * (-x42 * x45 - x63)
    x78 = x1 * (-x39 * x45 - x48)
    x79 = -x39 * x57 + x50 * x54
    x80 = x54 * x79 - x57 * x73 + x78
    x81 = x16 * x80
    x82 = x16 * x79
    x83 = x16 * x74 + x16 * (x74 + x82) + x62
    x84 = x16 * x50
    x85 = x16 * x51 + x16 * (x51 + x84) + x52
    x86 = x25 - C[1]
    x87 = x27 * x33
    x88 = x36 * x87 + x39 * x86
    x89 = x36 * x86 + x42 * x87
    x90 = x38 * x88 + x40 * x89
    x91 = x45 * x90
    x92 = x39 * x87 + x50 * x86
    x93 = x38 * x92 + x40 * x88
    x94 = x1 * (-x91 + x93)
    x95 = x45 * x89
    x96 = x1 * (x88 - x95)
    x97 = -x24 * x95 + x54 * x88
    x98 = x42 * x86 + x65 * x87
    x99 = x54 * x89 - x57 * x98
    x100 = -x24 * x91 + x54 * x93 + x56 * x97
    x101 = x38 * x89 + x40 * x98
    x102 = x17 * x80
    x103 = x45 * x88
    x104 = x1 * (-x103 + x92)
    x105 = -x103 * x24 + x54 * x92
    x106 = x104 + x105 * x54 - x57 * x97
    x107 = x102 + x106
    x108 = x17 * x79
    x109 = x105 + x108
    x110 = x100 + x109 * x16 + x17 * x74
    x111 = x17 * x50
    x112 = x111 + x92
    x113 = x112 * x16 + x17 * x51 + x93
    x114 = x18 * x74 + x18 * x82
    x115 = x18 * x51 + x18 * x84
    x116 = x37 + x86 * x88 + x87 * x89
    x117 = x116 * x45
    x118 = x49 + x86 * x92 + x87 * x88
    x119 = x1 * (-x117 + x118)
    x120 = -x117 * x24 + x118 * x54
    x121 = x64 + x86 * x89 + x87 * x98
    x122 = x105 * x17 + x109 * x17 + x120
    x123 = x112 * x17 + x118 + x17 * x92
    x124 = x105 * x18 + x108 * x18
    x125 = x111 * x18 + x18 * x92
    x126 = x19 * x79
    x127 = x19 * x50
    x128 = -x26 - A[1]
    x129 = x128 * x52 - x27 * x46
    x130 = x27 * x45
    x131 = x128 * x44 - x130 * x67
    x132 = x128 * x39 - x130 * x36
    x133 = x128 * x36 - x130 * x42
    x134 = x128 * x51 - x27 * x70
    x135 = x128 * x41 - x27 * x59
    x136 = x134 * x54 - x135 * x57 + x56 * (x132 * x54 - x133 * x57)
    x137 = x128 * x42 - x130 * x65
    x138 = x128 * x43 - x130 * x66
    x139 = x128 * x50 - x130 * x39
    x140 = -x132 * x57 + x139 * x54
    x141 = x140 * x16
    x142 = x139 * x16
    x143 = x129 + x134 * x16 + x16 * (x134 + x142)
    x144 = x12 * x85 + x143
    x145 = x128 * x88 + x133 * x56 - x27 * x95
    x146 = x128 * x89 - x130 * x98 + x137 * x56
    x147 = x128 * x93 + x135 * x56 - x27 * x91
    x148 = -x101 * x130 + x128 * x90 + x138 * x56
    x149 = x140 * x17
    x150 = -x103 * x27 + x128 * x92 + x132 * x56
    x151 = -x145 * x57 + x150 * x54
    x152 = x149 + x151
    x153 = x139 * x17
    x154 = x150 + x153
    x155 = x134 * x17 + x147 + x154 * x16
    x156 = x113 * x12 + x155
    x157 = x134 * x18 + x142 * x18
    x158 = x115 * x12 + x157
    x159 = -x117 * x27 + x118 * x128 + x145 * x61
    x160 = x116 * x128 - x121 * x130 + x146 * x61
    x161 = x150 * x17 + x154 * x17 + x159
    x162 = x12 * x123 + x161
    x163 = x150 * x18 + x153 * x18
    x164 = x12 * x125 + x163
    x165 = x139 * x19
    x166 = x12 * x127 + x165
    x167 = -x28 - A[2]
    x168 = x167 * x52 - x29 * x46
    x169 = x29 * x45
    x170 = x167 * x44 - x169 * x67
    x171 = x167 * x39 - x169 * x36
    x172 = x171 * x54
    x173 = x167 * x36 - x169 * x42
    x174 = x173 * x57
    x175 = x167 * x51 - x29 * x70
    x176 = x167 * x41 - x29 * x59
    x177 = x175 * x54 - x176 * x57 + x56 * (x172 - x174)
    x178 = x173 * x54
    x179 = x167 * x42 - x169 * x65
    x180 = x179 * x57
    x181 = x176 * x54
    x182 = x167 * x43 - x169 * x66
    x183 = x182 * x57
    x184 = x167 * x50 - x169 * x39
    x185 = -x171 * x57 + x184 * x54
    x186 = x16 * x175 + x16 * (x16 * x184 + x175) + x168
    x187 = x13 * x85 + x186
    x188 = x167 * x93 - x29 * x91
    x189 = x167 * x88 - x29 * x95
    x190 = x189 * x54
    x191 = x167 * x89 - x169 * x98
    x192 = x191 * x57
    x193 = -x101 * x169 + x167 * x90
    x194 = -x103 * x29 + x167 * x92
    x195 = -x189 * x57 + x194 * x54
    x196 = x17 * x185 + x195
    x197 = x17 * x184 + x194
    x198 = x16 * x197 + x17 * x175 + x188
    x199 = x113 * x13 + x198
    x200 = x172 * x56 - x174 * x56
    x201 = x18 * x185 + x200
    x202 = x171 * x56
    x203 = x18 * x184 + x202
    x204 = x176 * x56
    x205 = x16 * x203 + x175 * x18 + x204
    x206 = x115 * x13 + x205
    x207 = -x117 * x29 + x118 * x167
    x208 = x116 * x167 - x121 * x169
    x209 = x17 * x194 + x17 * x197 + x207
    x210 = x123 * x13 + x209
    x211 = x189 * x56
    x212 = x17 * x203 + x18 * x194 + x211
    x213 = x125 * x13 + x212
    x214 = 2 / x55**2
    x215 = x173 * x214 + x18 * x202 + x18 * x203
    x216 = x127 * x13 + x215
    x217 = x128 * x134 - x130 * x135 + x71
    x218 = x128 * x139 - x130 * x132 + x78
    x219 = x16 * x218
    x220 = x17 * x218
    x221 = x104 + x128 * x150 - x130 * x145 + x56 * (x128 * x132 - x130 * x133 + x72)
    x222 = x220 + x221
    x223 = x128 * x175 - x130 * x176
    x224 = x128 * x184 - x130 * x171
    x225 = x130 * x182
    x226 = x130 * x173
    x227 = x128 * x194 - x130 * x189 + x56 * (x128 * x171 - x226)
    x228 = x17 * x224 + x227
    x229 = x128 * x202 - x226 * x56
    x230 = x18 * x224 + x229
    x231 = x128 * x173
    x232 = x130 * x179
    x233 = x130 * x191
    x234 = x167 * x175 - x169 * x176 + x71
    x235 = x167 * x184 - x169 * x171 + x78
    x236 = x104 + x167 * x194 - x169 * x189
    x237 = x17 * x235 + x236
    x238 = x169 * x182
    x239 = x169 * x173
    x240 = x167 * x202 - x239 * x56 + x56 * (x167 * x171 - x239 + x72)
    x241 = x18 * x235 + x240
    x242 = x169 * x191
    x243 = x167 * x173
    x244 = x169 * x179

    # 36 item(s)
    S = numpy.array(
        [
            x11 * x83
            + x11 * (x11 * x85 + x83)
            + x16 * x75
            + x16 * (x75 + x81)
            + x53
            + x54 * x62
            - x57 * (x44 * x54 - x57 * x67 + x61 * x69)
            + x61 * (x54 * x60 + x56 * (x54 * x58 - x57 * x68 + x77) - x57 * x69 + x76),
            x100 * x54
            + x107 * x16
            + x11 * x110
            + x11 * (x11 * x113 + x110)
            + x17 * x75
            + x56 * (x54 * x97 - x57 * x99 + x96)
            - x57 * (-x101 * x57 + x54 * x90 + x56 * x99)
            + x94,
            x11 * x114 + x11 * (x11 * x115 + x114) + x18 * x75 + x18 * x81,
            x106 * x17
            + x107 * x17
            + x11 * x122
            + x11 * (x11 * x123 + x122)
            + x119
            + x120 * x54
            - x57 * (x116 * x54 - x121 * x57),
            x102 * x18 + x106 * x18 + x11 * x124 + x11 * (x11 * x125 + x124),
            x11 * x126 + x11 * (x11 * x127 + x126) + x19 * x80,
            x11 * x144
            + x12 * x83
            + x129 * x54
            - x131 * x57
            + x136 * x16
            + x16 * (x136 + x141)
            + x61 * (x135 * x54 - x138 * x57 + x56 * (x133 * x54 - x137 * x57)),
            x11 * x156
            + x110 * x12
            + x136 * x17
            + x147 * x54
            - x148 * x57
            + x152 * x16
            + x56 * (x145 * x54 - x146 * x57),
            x11 * x158 + x114 * x12 + x136 * x18 + x141 * x18,
            x11 * x162 + x12 * x122 + x151 * x17 + x152 * x17 + x159 * x54 - x160 * x57,
            x11 * x164 + x12 * x124 + x149 * x18 + x151 * x18,
            x11 * x166 + x12 * x126 + x140 * x19,
            x11 * x187
            + x13 * x83
            + x16 * x177
            + x16 * (x16 * x185 + x177)
            + x168 * x54
            - x170 * x57
            + x61 * (x181 - x183 + x56 * (x178 - x180)),
            x11 * x199
            + x110 * x13
            + x16 * x196
            + x17 * x177
            + x188 * x54
            - x193 * x57
            + x56 * (x190 - x192),
            x11 * x206
            + x114 * x13
            + x16 * x201
            + x177 * x18
            + x181 * x56
            - x183 * x56
            + x56 * (x178 * x56 - x180 * x56),
            x11 * x210 + x122 * x13 + x17 * x195 + x17 * x196 + x207 * x54 - x208 * x57,
            x11 * x213 + x124 * x13 + x17 * x201 + x18 * x195 + x190 * x56 - x192 * x56,
            x11 * x216 + x126 * x13 + x178 * x214 + x18 * x200 + x18 * x201 - x180 * x214,
            x12 * x143
            + x12 * x144
            + x128 * x129
            - x130 * x131
            + x16 * x217
            + x16 * (x217 + x219)
            + x53,
            x12 * x155
            + x12 * x156
            + x128 * x147
            - x130 * x148
            + x16 * x222
            + x17 * x217
            + x56 * (x128 * x135 - x130 * x138 + x76)
            + x94,
            x12 * x157 + x12 * x158 + x18 * x217 + x18 * x219,
            x119
            + x12 * x161
            + x12 * x162
            + x128 * x159
            - x130 * x160
            + x17 * x221
            + x17 * x222
            + x61
            * (x128 * x145 - x130 * x146 + x56 * (x128 * x133 - x130 * x137 + x77) + x96),
            x12 * x163 + x12 * x164 + x18 * x220 + x18 * x221,
            x12 * x165 + x12 * x166 + x19 * x218,
            x12 * x187
            + x128 * x168
            + x13 * x143
            - x130 * x170
            + x16 * x223
            + x16 * (x16 * x224 + x223),
            x12 * x199
            + x128 * x188
            + x13 * x155
            - x130 * x193
            + x16 * x228
            + x17 * x223
            + x56 * (x128 * x176 - x225),
            x12 * x206 + x128 * x204 + x13 * x157 + x16 * x230 + x18 * x223 - x225 * x56,
            x12 * x210
            + x128 * x207
            + x13 * x161
            - x130 * x208
            + x17 * x227
            + x17 * x228
            + x61 * (x128 * x189 - x233 + x56 * (x231 - x232)),
            x12 * x213
            + x128 * x211
            + x13 * x163
            + x17 * x230
            + x18 * x227
            - x233 * x56
            + x56 * (x231 * x56 - x232 * x56),
            x12 * x216 + x13 * x165 + x18 * x229 + x18 * x230 + x214 * x231 - x214 * x232,
            x13 * x186
            + x13 * x187
            + x16 * x234
            + x16 * (x16 * x235 + x234)
            + x167 * x168
            - x169 * x170
            + x53,
            x13 * x198
            + x13 * x199
            + x16 * x237
            + x167 * x188
            - x169 * x193
            + x17 * x234
            + x94,
            x13 * x205
            + x13 * x206
            + x16 * x241
            + x167 * x204
            + x18 * x234
            - x238 * x56
            + x56 * (x167 * x176 - x238 + x76),
            x119
            + x13 * x209
            + x13 * x210
            + x167 * x207
            - x169 * x208
            + x17 * x236
            + x17 * x237,
            x13 * x212
            + x13 * x213
            + x167 * x211
            + x17 * x241
            + x18 * x236
            - x242 * x56
            + x56 * (x167 * x189 - x242 + x96),
            x13 * x215
            + x13 * x216
            + x18 * x240
            + x18 * x241
            + x214 * x243
            - x214 * x244
            + x61 * (x243 * x56 - x244 * x56 + x56 * (x243 - x244 + x77)),
        ]
    )
    return S


def eri_0210(a, A, b, B, c, C, d, D):
    """Cartesian [sd|ps] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(1, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x9 * (x22**2 + x23**2 + x24**2))
    x26 = numpy.exp(
        -c * d * x3 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x27 = 2 * x20 * x21 * x25 * x26
    x28 = x19 * x27
    x29 = boys(2, x18)
    x30 = x27 * x29
    x31 = x6 * x8
    x32 = x11 * x31
    x33 = x28 * x5 + x30 * x32
    x34 = x2 * x8
    x35 = x33 * x34
    x36 = boys(0, x18)
    x37 = x27 * x5
    x38 = x28 * x32 + x36 * x37
    x39 = x1 * (-x35 + x38)
    x40 = (2 * c + 2 * d + x0) ** (-1.0)
    x41 = x1 * (2 * x19 * x20 * x21 * x25 * x26 - x30 * x34)
    x42 = -x10 - A[0]
    x43 = x11 * x34
    x44 = x28 * x42 - x30 * x43
    x45 = x27 * boys(3, x18)
    x46 = x30 * x42 - x43 * x45
    x47 = -x11 * x35 + x38 * x42 + x40 * x44
    x48 = x29 * x37 + x32 * x45
    x49 = x12 - C[1]
    x50 = x14 * x31
    x51 = x28 * x49 + x30 * x50
    x52 = x34 * x51
    x53 = x27 * x36 * x49 + x28 * x50
    x54 = x1 * (-x52 + x53)
    x55 = -x11 * x52 + x42 * x53
    x56 = x30 * x49 + x45 * x50
    x57 = -x13 - A[1]
    x58 = x14 * x34
    x59 = x28 * x57 - x30 * x58
    x60 = x30 * x57 - x45 * x58
    x61 = -x14 * x35 + x38 * x57
    x62 = x33 * x57 - x48 * x58
    x63 = x23 * x38 + x61
    x64 = -x14 * x52 + x40 * x59 + x53 * x57
    x65 = x40 * x60 + x51 * x57 - x56 * x58
    x66 = x23 * x53 + x64
    x67 = -x15 - A[2]
    x68 = x16 * x34
    x69 = x28 * x67 - x30 * x68
    x70 = x42 * x69
    x71 = x30 * x67 - x45 * x68
    x72 = x43 * x71
    x73 = -x16 * x35 + x38 * x67
    x74 = x33 * x67 - x48 * x68
    x75 = x24 * x38 + x73
    x76 = -x16 * x52 + x53 * x67
    x77 = x51 * x67 - x56 * x68
    x78 = x24 * x53 + x76
    x79 = x40 * x69
    x80 = x57 * x69
    x81 = x58 * x71
    x82 = x67 * x69
    x83 = x68 * x71

    # 18 item(s)
    S = numpy.array(
        [
            x22 * x47
            + x22 * (x22 * x38 + x47)
            + x39
            + x40 * (x41 + x42 * x44 - x43 * x46)
            + x42 * x47
            - x43 * (x33 * x42 + x40 * x46 - x43 * x48),
            x22 * x55
            + x22 * (x22 * x53 + x55)
            + x42 * x55
            - x43 * (x42 * x51 - x43 * x56)
            + x54,
            0,
            x22 * x63 + x23 * x47 + x40 * (x42 * x59 - x43 * x60) + x42 * x61 - x43 * x62,
            x22 * x66 + x23 * x55 + x42 * x64 - x43 * x65,
            0,
            x22 * x75 + x24 * x47 + x40 * (x70 - x72) + x42 * x73 - x43 * x74,
            x22 * x78 + x24 * x55 + x42 * x76 - x43 * x77,
            x22 * x79 + x40 * x70 - x40 * x72,
            x23 * x61 + x23 * x63 + x39 + x57 * x61 - x58 * x62,
            x23 * x64
            + x23 * x66
            + x40 * (x41 + x57 * x59 - x58 * x60)
            + x54
            + x57 * x64
            - x58 * x65,
            0,
            x23 * x75 + x24 * x61 + x57 * x73 - x58 * x74,
            x23 * x78 + x24 * x64 + x40 * (x80 - x81) + x57 * x76 - x58 * x77,
            x23 * x79 + x40 * x80 - x40 * x81,
            x24 * x73 + x24 * x75 + x39 + x67 * x73 - x68 * x74,
            x24 * x76 + x24 * x78 + x54 + x67 * x76 - x68 * x77,
            2 * x24 * x79 + x40 * x82 - x40 * x83 + x40 * (x41 + x82 - x83),
        ]
    )
    return S


def eri_0211(a, A, b, B, c, C, d, D):
    """Cartesian [sd|pp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x10 * (x11**2 + x12**2 + x13**2))
    x15 = x6 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x18**2))
    x20 = x8 ** (-1.0)
    x21 = x15 * (c * C[0] + d * D[0])
    x22 = -x10 * (a * A[0] + b * B[0])
    x23 = -x21 - x22
    x24 = x15 * (c * C[1] + d * D[1])
    x25 = -x10 * (a * A[1] + b * B[1])
    x26 = -x24 - x25
    x27 = -x10 * (a * A[2] + b * B[2])
    x28 = -x15 * (c * C[2] + d * D[2]) - x27
    x29 = x20 * x7 * (x23**2 + x26**2 + x28**2)
    x30 = boys(1, x29)
    x31 = -2 * x14 * x19 * x30 * x4 * x9
    x32 = x20 * x5
    x33 = boys(2, x29)
    x34 = 2 * x14 * x19 * x4 * x9
    x35 = x33 * x34
    x36 = x3 * (-x31 - x32 * x35)
    x37 = x21 - C[0]
    x38 = x30 * x34
    x39 = x23 * x32
    x40 = x35 * x39 + x37 * x38
    x41 = x34 * boys(3, x29)
    x42 = x35 * x37 + x39 * x41
    x43 = x36 + x37 * x40 + x39 * x42
    x44 = x20 * x6
    x45 = x43 * x44
    x46 = boys(0, x29)
    x47 = x3 * (2 * x14 * x19 * x4 * x46 * x9 - x32 * x38)
    x48 = x34 * x46
    x49 = x37 * x48 + x38 * x39
    x50 = x37 * x49 + x39 * x40 + x47
    x51 = x1 * (-x45 + x50)
    x52 = -x22 - A[0]
    x53 = x0 + x2
    x54 = x53 ** (-1.0)
    x55 = x23 * x44
    x56 = x35 * x52 - x41 * x55
    x57 = x42 * x44
    x58 = -x23 * x57 + x40 * x52 + x54 * x56
    x59 = 2 * x54
    x60 = -x23 * x45 + x50 * x52 + x58 * x59
    x61 = -2 * x14 * x19 * x33 * x4 * x9
    x62 = x3 * (-x32 * x41 - x61)
    x63 = x34 * boys(4, x29)
    x64 = x37 * x41 + x39 * x63
    x65 = x37 * x42 + x39 * x64 + x62
    x66 = x41 * x52 - x55 * x63
    x67 = x42 * x52 + x54 * x66 - x55 * x64
    x68 = x40 * x44
    x69 = x1 * (x49 - x68)
    x70 = x1 * (-x31 - x35 * x44)
    x71 = -x35 * x55 + x38 * x52
    x72 = -x23 * x68 + x49 * x52 + x54 * x71
    x73 = x52 * x72 + x54 * (x52 * x71 - x55 * x56 + x70) - x55 * x58 + x69
    x74 = x1 * (x40 - x57)
    x75 = x1 * (-x41 * x44 - x61)
    x76 = x16 * x72 + x60
    x77 = x16 * x49 + x50
    x78 = x24 - C[1]
    x79 = x26 * x32
    x80 = x35 * x79 + x38 * x78
    x81 = x35 * x78 + x41 * x79
    x82 = x44 * x81
    x83 = -x23 * x82 + x52 * x80
    x84 = x38 * x79 + x48 * x78
    x85 = x37 * x84 + x39 * x80
    x86 = x37 * x80 + x39 * x81
    x87 = x44 * x86
    x88 = -x23 * x87 + x52 * x85 + x54 * x83
    x89 = x17 * x72 + x88
    x90 = x17 * x49 + x85
    x91 = x1 * (x85 - x87)
    x92 = x1 * (x80 - x82)
    x93 = x41 * x78 + x63 * x79
    x94 = x52 * x81 - x55 * x93
    x95 = x37 * x81 + x39 * x93
    x96 = (
        x52 * x88
        + x54 * (x52 * x83 - x55 * x94 + x92)
        - x55 * (x52 * x86 + x54 * x94 - x55 * x95)
        + x91
    )
    x97 = x18 * x72
    x98 = x11 * x18
    x99 = x44 * x80
    x100 = -x23 * x99 + x52 * x84
    x101 = x100 * x16 + x88
    x102 = x16 * x84 + x85
    x103 = x1 * (x84 - x99)
    x104 = x100 * x52 + x103 - x55 * x83
    x105 = x36 + x78 * x80 + x79 * x81
    x106 = x105 * x44
    x107 = x47 + x78 * x84 + x79 * x80
    x108 = x1 * (-x106 + x107)
    x109 = -x106 * x23 + x107 * x52
    x110 = x62 + x78 * x81 + x79 * x93
    x111 = x100 * x17 + x109
    x112 = x107 + x17 * x84
    x113 = x100 * x18
    x114 = -x25 - A[1]
    x115 = x114 * x50 - x26 * x45
    x116 = x26 * x44
    x117 = x114 * x43 - x116 * x65
    x118 = x114 * x38 - x116 * x35
    x119 = x114 * x35 - x116 * x41
    x120 = x114 * x49 - x26 * x68
    x121 = x114 * x40 - x26 * x57
    x122 = x120 * x52 - x121 * x55 + x54 * (x118 * x52 - x119 * x55)
    x123 = x114 * x41 - x116 * x63
    x124 = x114 * x42 - x116 * x64
    x125 = x115 + x120 * x16
    x126 = x12 * x77 + x125
    x127 = x114 * x85 + x121 * x54 - x26 * x87
    x128 = x120 * x17 + x127
    x129 = x12 * x90 + x128
    x130 = x114 * x80 + x119 * x54 - x26 * x82
    x131 = x114 * x81 - x116 * x93 + x123 * x54
    x132 = x114 * x86 - x116 * x95 + x124 * x54
    x133 = x127 * x52 - x132 * x55 + x54 * (x130 * x52 - x131 * x55)
    x134 = x12 * x18
    x135 = x120 * x18
    x136 = x134 * x49 + x135
    x137 = x114 * x84 + x118 * x54 - x26 * x99
    x138 = x127 + x137 * x16
    x139 = x102 * x12 + x138
    x140 = -x130 * x55 + x137 * x52
    x141 = -x106 * x26 + x107 * x114 + x130 * x59
    x142 = x105 * x114 - x110 * x116 + x131 * x59
    x143 = x137 * x17 + x141
    x144 = x112 * x12 + x143
    x145 = x137 * x18
    x146 = x134 * x84 + x145
    x147 = -x27 - A[2]
    x148 = x147 * x50 - x28 * x45
    x149 = x28 * x44
    x150 = x147 * x43 - x149 * x65
    x151 = x147 * x38 - x149 * x35
    x152 = x151 * x52
    x153 = x147 * x35 - x149 * x41
    x154 = x153 * x55
    x155 = x147 * x49 - x28 * x68
    x156 = x147 * x40 - x28 * x57
    x157 = x155 * x52 - x156 * x55 + x54 * (x152 - x154)
    x158 = x153 * x52
    x159 = x147 * x41 - x149 * x63
    x160 = x159 * x55
    x161 = x156 * x52
    x162 = x147 * x42 - x149 * x64
    x163 = x162 * x55
    x164 = x148 + x155 * x16
    x165 = x13 * x77 + x164
    x166 = x147 * x85 - x28 * x87
    x167 = x155 * x17 + x166
    x168 = x13 * x90 + x167
    x169 = x147 * x80 - x28 * x82
    x170 = x169 * x52
    x171 = x147 * x81 - x149 * x93
    x172 = x171 * x55
    x173 = x147 * x86 - x149 * x95
    x174 = x166 * x52 - x173 * x55 + x54 * (x170 - x172)
    x175 = x13 * x18
    x176 = x156 * x54
    x177 = x155 * x18 + x176
    x178 = x175 * x49 + x177
    x179 = x161 * x54 - x163 * x54 + x54 * (x158 * x54 - x160 * x54)
    x180 = x147 * x84 - x28 * x99
    x181 = x16 * x180 + x166
    x182 = x102 * x13 + x181
    x183 = -x169 * x55 + x180 * x52
    x184 = -x106 * x28 + x107 * x147
    x185 = x105 * x147 - x110 * x149
    x186 = x17 * x180 + x184
    x187 = x112 * x13 + x186
    x188 = x169 * x54
    x189 = x18 * x180 + x188
    x190 = x175 * x84 + x189
    x191 = x170 * x54 - x172 * x54
    x192 = x151 * x54
    x193 = x16 * x192 + x176
    x194 = x152 * x54 - x154 * x54
    x195 = x17 * x192 + x188
    x196 = 2 / x53**2
    x197 = x153 * x196 + x18 * x192
    x198 = x114 * x120 - x116 * x121 + x69
    x199 = x114 * x127 - x116 * x132 + x54 * (x114 * x121 - x116 * x124 + x74) + x91
    x200 = x103 + x114 * x137 - x116 * x130 + x54 * (x114 * x118 - x116 * x119 + x70)
    x201 = x114 * x155 - x116 * x156
    x202 = x116 * x162
    x203 = x114 * x166 - x116 * x173 + x54 * (x114 * x156 - x202)
    x204 = x114 * x176 - x202 * x54
    x205 = x114 * x151
    x206 = x116 * x153
    x207 = x114 * x180 - x116 * x169 + x54 * (x205 - x206)
    x208 = x114 * x153
    x209 = x116 * x159
    x210 = x116 * x171
    x211 = x114 * x188 - x210 * x54 + x54 * (x208 * x54 - x209 * x54)
    x212 = x205 * x54 - x206 * x54
    x213 = x147 * x155 - x149 * x156 + x69
    x214 = x147 * x166 - x149 * x173 + x91
    x215 = x149 * x162
    x216 = x147 * x176 - x215 * x54 + x54 * (x147 * x156 - x215 + x74)
    x217 = x103 + x147 * x180 - x149 * x169
    x218 = x149 * x171
    x219 = x147 * x188 - x218 * x54 + x54 * (x147 * x169 - x218 + x92)
    x220 = x147 * x151
    x221 = x149 * x153
    x222 = x220 * x54 - x221 * x54 + x54 * (x220 - x221 + x70)
    x223 = 2 * x13
    x224 = x147 * x153
    x225 = x149 * x159

    # 54 item(s)
    S = numpy.array(
        [
            x11 * x76
            + x11 * (x11 * x77 + x76)
            + x16 * x73
            + x51
            + x52 * x60
            - x55 * (x43 * x52 - x55 * x65 + x59 * x67)
            + x59 * (x52 * x58 + x54 * (x52 * x56 - x55 * x66 + x75) - x55 * x67 + x74),
            x11 * x89 + x11 * (x11 * x90 + x89) + x17 * x73 + x96,
            x11 * x97 + x11 * (x49 * x98 + x97) + x18 * x73,
            x101 * x11 + x104 * x16 + x11 * (x101 + x102 * x11) + x96,
            x104 * x17
            + x108
            + x109 * x52
            + x11 * x111
            + x11 * (x11 * x112 + x111)
            - x55 * (x105 * x52 - x110 * x55),
            x104 * x18 + x11 * x113 + x11 * (x113 + x84 * x98),
            0,
            0,
            0,
            x11 * x126
            + x115 * x52
            - x117 * x55
            + x12 * x76
            + x122 * x16
            + x59 * (x121 * x52 - x124 * x55 + x54 * (x119 * x52 - x123 * x55)),
            x11 * x129 + x12 * x89 + x122 * x17 + x133,
            x11 * x136 + x12 * x97 + x122 * x18,
            x101 * x12 + x11 * x139 + x133 + x140 * x16,
            x11 * x144 + x111 * x12 + x140 * x17 + x141 * x52 - x142 * x55,
            x11 * x146 + x113 * x12 + x140 * x18,
            0,
            0,
            0,
            x11 * x165
            + x13 * x76
            + x148 * x52
            - x150 * x55
            + x157 * x16
            + x59 * (x161 - x163 + x54 * (x158 - x160)),
            x11 * x168 + x13 * x89 + x157 * x17 + x174,
            x11 * x178 + x13 * x97 + x157 * x18 + x179,
            x101 * x13 + x11 * x182 + x16 * x183 + x174,
            x11 * x187 + x111 * x13 + x17 * x183 + x184 * x52 - x185 * x55,
            x11 * x190 + x113 * x13 + x18 * x183 + x191,
            x11 * x193 + x16 * x194 + x179,
            x11 * x195 + x17 * x194 + x191,
            x11 * x197 + x158 * x196 - x160 * x196 + x18 * x194,
            x114 * x115 - x116 * x117 + x12 * x125 + x12 * x126 + x16 * x198 + x51,
            x12 * x128 + x12 * x129 + x17 * x198 + x199,
            x12 * x135 + x12 * x136 + x18 * x198,
            x12 * x138 + x12 * x139 + x16 * x200 + x199,
            x108
            + x114 * x141
            - x116 * x142
            + x12 * x143
            + x12 * x144
            + x17 * x200
            + x59
            * (x114 * x130 - x116 * x131 + x54 * (x114 * x119 - x116 * x123 + x75) + x92),
            x12 * x145 + x12 * x146 + x18 * x200,
            0,
            0,
            0,
            x114 * x148 - x116 * x150 + x12 * x165 + x125 * x13 + x16 * x201,
            x12 * x168 + x128 * x13 + x17 * x201 + x203,
            x12 * x178 + x13 * x135 + x18 * x201 + x204,
            x12 * x182 + x13 * x138 + x16 * x207 + x203,
            x114 * x184
            - x116 * x185
            + x12 * x187
            + x13 * x143
            + x17 * x207
            + x59 * (x114 * x169 - x210 + x54 * (x208 - x209)),
            x12 * x190 + x13 * x145 + x18 * x207 + x211,
            x12 * x193 + x16 * x212 + x204,
            x12 * x195 + x17 * x212 + x211,
            x12 * x197 + x18 * x212 + x196 * x208 - x196 * x209,
            x13 * x164 + x13 * x165 + x147 * x148 - x149 * x150 + x16 * x213 + x51,
            x13 * x167 + x13 * x168 + x17 * x213 + x214,
            x13 * x177 + x13 * x178 + x18 * x213 + x216,
            x13 * x181 + x13 * x182 + x16 * x217 + x214,
            x108 + x13 * x186 + x13 * x187 + x147 * x184 - x149 * x185 + x17 * x217,
            x13 * x189 + x13 * x190 + x18 * x217 + x219,
            x16 * x222 + x193 * x223 + x216,
            x17 * x222 + x195 * x223 + x219,
            x18 * x222
            + x196 * x224
            - x196 * x225
            + x197 * x223
            + x59 * (x224 * x54 - x225 * x54 + x54 * (x224 - x225 + x75)),
        ]
    )
    return S


def eri_0212(a, A, b, B, c, C, d, D):
    """Cartesian [sd|pd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x9 * (x22**2 + x23**2 + x24**2))
    x26 = C[0] - D[0]
    x27 = C[1] - D[1]
    x28 = C[2] - D[2]
    x29 = x28**2
    x30 = numpy.exp(-c * d * x3 * (x26**2 + x27**2 + x29))
    x31 = 2 * x20 * x21 * x25 * x30
    x32 = x19 * x31
    x33 = x6 * x8
    x34 = x11 * x33
    x35 = boys(3, x18)
    x36 = x31 * x35
    x37 = x32 * x5 + x34 * x36
    x38 = x33 * x37
    x39 = boys(1, x18)
    x40 = x31 * x39
    x41 = x32 * x34 + x40 * x5
    x42 = 2 * c + 2 * d
    x43 = x42 ** (-1.0)
    x44 = 2 * x43
    x45 = -2 * x20 * x21 * x25 * x30 * x39
    x46 = x43 * (-x32 * x33 - x45)
    x47 = x11 * x38 + x41 * x5 + x46
    x48 = -2 * x19 * x20 * x21 * x25 * x30
    x49 = x43 * (-x33 * x36 - x48)
    x50 = x31 * boys(4, x18)
    x51 = x34 * x50 + x36 * x5
    x52 = x33 * x51
    x53 = x11 * x52 + x37 * x5 + x49
    x54 = x34 * x53 + x44 * (-x38 + x41) + x47 * x5
    x55 = x2 * x8
    x56 = x54 * x55
    x57 = x33 * x41
    x58 = boys(0, x18)
    x59 = x31 * x58
    x60 = x34 * x40 + x5 * x59
    x61 = x43 * (2 * x20 * x21 * x25 * x30 * x58 - x33 * x40)
    x62 = x11 * x57 + x5 * x60 + x61
    x63 = x34 * x47 + x44 * (-x57 + x60) + x5 * x62
    x64 = x1 * (-x56 + x63)
    x65 = -x10 - A[0]
    x66 = x53 * x55
    x67 = x0 + x42
    x68 = x67 ** (-1.0)
    x69 = x11 * x55
    x70 = x36 * x65 - x50 * x69
    x71 = x51 * x55
    x72 = -x11 * x71 + x37 * x65 + x68 * x70
    x73 = 2 * x68
    x74 = -x11 * x66 + x47 * x65 + x72 * x73
    x75 = 3 * x68
    x76 = -x11 * x56 + x63 * x65 + x74 * x75
    x77 = -2 * x20 * x21 * x25 * x30 * x35
    x78 = x43 * (-x33 * x50 - x77)
    x79 = x31 * boys(5, x18)
    x80 = x34 * x79 + x5 * x50
    x81 = x34 * x80 + x5 * x51 + x78
    x82 = x34 * x81 + x44 * (x37 - x52) + x5 * x53
    x83 = x50 * x65 - x69 * x79
    x84 = x51 * x65 + x68 * x83 - x69 * x80
    x85 = x53 * x65 - x69 * x81 + x73 * x84
    x86 = x47 * x55
    x87 = x1 * (x62 - x86)
    x88 = x32 * x65 - x36 * x69
    x89 = x37 * x55
    x90 = -x11 * x89 + x41 * x65 + x68 * x88
    x91 = -x11 * x86 + x62 * x65 + x73 * x90
    x92 = x1 * (x41 - x89)
    x93 = x1 * (-x36 * x55 - x48)
    x94 = (
        x65 * x91
        - x69 * x74
        + x73 * (x65 * x90 + x68 * (x65 * x88 - x69 * x70 + x93) - x69 * x72 + x92)
        + x87
    )
    x95 = x1 * (x47 - x66)
    x96 = x1 * (x37 - x71)
    x97 = x1 * (-x50 * x55 - x77)
    x98 = -x32 * x69 + x40 * x65
    x99 = x41 * x55
    x100 = -x11 * x99 + x60 * x65 + x68 * x98
    x101 = x100 * x26
    x102 = x26 * x91 + x26 * (x101 + x91) + x76
    x103 = x1 * (x60 - x99)
    x104 = x1 * (-x32 * x55 - x45)
    x105 = x100 * x65 + x103 + x68 * (x104 + x65 * x98 - x69 * x88) - x69 * x90
    x106 = x105 * x26
    x107 = x26 * x60
    x108 = x26 * x62 + x26 * (x107 + x62) + x63
    x109 = x100 * x27
    x110 = x12 - C[1]
    x111 = x14 * x33
    x112 = x110 * x40 + x111 * x32
    x113 = x110 * x32 + x111 * x36
    x114 = x113 * x55
    x115 = -x11 * x114 + x112 * x65
    x116 = x110 * x59 + x111 * x40
    x117 = x112 * x33
    x118 = x11 * x117 + x116 * x5
    x119 = x113 * x33
    x120 = x11 * x119 + x112 * x5
    x121 = x120 * x55
    x122 = -x11 * x121 + x115 * x68 + x118 * x65
    x123 = x109 + x122
    x124 = x43 * (x116 - x117)
    x125 = x118 * x5 + x120 * x34 + x124
    x126 = x43 * (x112 - x119)
    x127 = x110 * x36 + x111 * x50
    x128 = x127 * x33
    x129 = x11 * x128 + x113 * x5
    x130 = x120 * x5 + x126 + x129 * x34
    x131 = x130 * x55
    x132 = x127 * x55
    x133 = -x11 * x132 + x113 * x65
    x134 = x129 * x55
    x135 = -x11 * x134 + x120 * x65 + x133 * x68
    x136 = -x11 * x131 + x125 * x65 + x135 * x73
    x137 = x123 * x26 + x136 + x27 * x91
    x138 = x27 * x60
    x139 = x118 + x138
    x140 = x125 + x139 * x26 + x27 * x62
    x141 = x105 * x27
    x142 = x1 * (x118 - x121)
    x143 = x1 * (x112 - x114)
    x144 = x122 * x65 - x135 * x69 + x142 + x68 * (x115 * x65 - x133 * x69 + x143)
    x145 = x141 + x144
    x146 = x1 * (x125 - x131)
    x147 = x1 * (x120 - x134)
    x148 = x1 * (x113 - x132)
    x149 = x110 * x50 + x111 * x79
    x150 = x127 * x65 - x149 * x69
    x151 = x127 * x5 + x149 * x34
    x152 = x129 * x65 + x150 * x68 - x151 * x69
    x153 = x43 * (x113 - x128)
    x154 = x129 * x5 + x151 * x34 + x153
    x155 = (
        x136 * x65
        + x146
        - x69 * (x130 * x65 + x152 * x73 - x154 * x69)
        + x73 * (x135 * x65 + x147 - x152 * x69 + x68 * (x133 * x65 + x148 - x150 * x69))
    )
    x156 = x101 * x28 + x28 * x91
    x157 = x107 * x28 + x28 * x62
    x158 = x110 * x112 + x119 * x14 + x46
    x159 = x110 * x113 + x128 * x14 + x49
    x160 = x159 * x55
    x161 = -x11 * x160 + x158 * x65
    x162 = x110 * x116 + x117 * x14 + x61
    x163 = x158 * x34 + x162 * x5
    x164 = x158 * x5 + x159 * x34
    x165 = x164 * x55
    x166 = -x11 * x165 + x161 * x68 + x163 * x65
    x167 = x122 * x27 + x166
    x168 = x123 * x27 + x167
    x169 = x118 * x27 + x163
    x170 = x139 * x27 + x169
    x171 = x1 * (x163 - x165)
    x172 = x1 * (x158 - x160)
    x173 = x110 * x127 + x111 * x149 + x78
    x174 = x159 * x65 - x173 * x69
    x175 = x159 * x5 + x173 * x34
    x176 = (
        x144 * x27
        + x166 * x65
        + x171
        + x68 * (x161 * x65 + x172 - x174 * x69)
        - x69 * (x164 * x65 + x174 * x68 - x175 * x69)
    )
    x177 = x122 * x28
    x178 = x109 * x28 + x177
    x179 = x118 * x28
    x180 = x138 * x28 + x179
    x181 = x144 * x28
    x182 = x100 * x29
    x183 = x22 * x29
    x184 = x112 * x55
    x185 = -x11 * x184 + x116 * x65
    x186 = x185 * x26
    x187 = x122 * x26 + x136 + x26 * (x122 + x186)
    x188 = x116 * x26
    x189 = x118 * x26 + x125 + x26 * (x118 + x188)
    x190 = x1 * (x116 - x184)
    x191 = -x115 * x69 + x185 * x65 + x190
    x192 = x191 * x26
    x193 = x185 * x27
    x194 = x158 * x55
    x195 = -x11 * x194 + x162 * x65
    x196 = x193 + x195
    x197 = x167 + x196 * x26
    x198 = x116 * x27
    x199 = x162 + x198
    x200 = x169 + x199 * x26
    x201 = x191 * x27
    x202 = x1 * (x162 - x194)
    x203 = -x161 * x69 + x195 * x65 + x202
    x204 = x201 + x203
    x205 = x177 + x186 * x28
    x206 = x179 + x188 * x28
    x207 = x110 * x158 + x111 * x159 + 2 * x126
    x208 = x207 * x55
    x209 = x110 * x162 + x111 * x158 + 2 * x124
    x210 = x1 * (-x208 + x209)
    x211 = -x11 * x208 + x209 * x65
    x212 = x110 * x159 + x111 * x173 + 2 * x153
    x213 = x195 * x27 + x196 * x27 + x211
    x214 = x162 * x27 + x199 * x27 + x209
    x215 = x193 * x28 + x195 * x28
    x216 = x162 * x28 + x198 * x28
    x217 = x185 * x29
    x218 = -x13 - A[1]
    x219 = -x14 * x56 + x218 * x63
    x220 = x14 * x55
    x221 = x218 * x54 - x220 * x82
    x222 = -x14 * x86 + x218 * x62
    x223 = -x14 * x66 + x218 * x47
    x224 = x218 * x32 - x220 * x36
    x225 = x218 * x36 - x220 * x50
    x226 = -x14 * x89 + x218 * x41
    x227 = -x14 * x71 + x218 * x37
    x228 = (
        x222 * x65
        - x223 * x69
        + x73 * (x226 * x65 - x227 * x69 + x68 * (x224 * x65 - x225 * x69))
    )
    x229 = x218 * x53 - x220 * x81
    x230 = x218 * x50 - x220 * x79
    x231 = x218 * x51 - x220 * x80
    x232 = x218 * x40 - x220 * x32
    x233 = -x14 * x99 + x218 * x60
    x234 = -x226 * x69 + x233 * x65 + x68 * (-x224 * x69 + x232 * x65)
    x235 = x234 * x26
    x236 = x233 * x26
    x237 = x219 + x222 * x26 + x26 * (x222 + x236)
    x238 = x108 * x23 + x237
    x239 = x233 * x27
    x240 = x118 * x218 - x121 * x14 + x226 * x68
    x241 = x239 + x240
    x242 = x125 * x218 - x131 * x14 + x223 * x68
    x243 = x222 * x27 + x241 * x26 + x242
    x244 = x140 * x23 + x243
    x245 = x234 * x27
    x246 = x112 * x218 - x114 * x14 + x224 * x68
    x247 = x113 * x218 - x132 * x14 + x225 * x68
    x248 = x120 * x218 - x134 * x14 + x227 * x68
    x249 = x240 * x65 - x248 * x69 + x68 * (x246 * x65 - x247 * x69)
    x250 = x245 + x249
    x251 = x127 * x218 - x149 * x220 + x230 * x68
    x252 = x129 * x218 - x151 * x220 + x231 * x68
    x253 = x130 * x218 - x154 * x220 + x229 * x68
    x254 = (
        x242 * x65
        - x253 * x69
        + x73 * (x248 * x65 - x252 * x69 + x68 * (x247 * x65 - x251 * x69))
    )
    x255 = x222 * x28 + x236 * x28
    x256 = x157 * x23 + x255
    x257 = -x14 * x165 + x163 * x218 + x248 * x73
    x258 = x240 * x27 + x257
    x259 = x241 * x27 + x258
    x260 = x170 * x23 + x259
    x261 = -x14 * x160 + x158 * x218 + x247 * x73
    x262 = x159 * x218 - x173 * x220 + x251 * x73
    x263 = x164 * x218 - x175 * x220 + x252 * x73
    x264 = x249 * x27 + x257 * x65 - x263 * x69 + x68 * (x261 * x65 - x262 * x69)
    x265 = x240 * x28
    x266 = x239 * x28 + x265
    x267 = x180 * x23 + x266
    x268 = x249 * x28
    x269 = x23 * x29
    x270 = x233 * x29
    x271 = x269 * x60 + x270
    x272 = x116 * x218 - x14 * x184 + x232 * x68
    x273 = x26 * x272
    x274 = x240 * x26 + x242 + x26 * (x240 + x273)
    x275 = x189 * x23 + x274
    x276 = -x246 * x69 + x272 * x65
    x277 = x26 * x276
    x278 = x27 * x272
    x279 = -x14 * x194 + x162 * x218 + x246 * x73
    x280 = x278 + x279
    x281 = x258 + x26 * x280
    x282 = x200 * x23 + x281
    x283 = x27 * x276
    x284 = -x261 * x69 + x279 * x65
    x285 = x283 + x284
    x286 = x265 + x273 * x28
    x287 = x206 * x23 + x286
    x288 = -x14 * x208 + x209 * x218 + x261 * x75
    x289 = x207 * x218 - x212 * x220 + x262 * x75
    x290 = x27 * x279 + x27 * x280 + x288
    x291 = x214 * x23 + x290
    x292 = x278 * x28 + x279 * x28
    x293 = x216 * x23 + x292
    x294 = x272 * x29
    x295 = x116 * x269 + x294
    x296 = -x15 - A[2]
    x297 = -x16 * x56 + x296 * x63
    x298 = x16 * x55
    x299 = x296 * x54 - x298 * x82
    x300 = -x16 * x86 + x296 * x62
    x301 = -x16 * x66 + x296 * x47
    x302 = x296 * x32 - x298 * x36
    x303 = x302 * x65
    x304 = x296 * x36 - x298 * x50
    x305 = x304 * x69
    x306 = -x16 * x89 + x296 * x41
    x307 = x306 * x65
    x308 = -x16 * x71 + x296 * x37
    x309 = x308 * x69
    x310 = x300 * x65 - x301 * x69 + x73 * (x307 - x309 + x68 * (x303 - x305))
    x311 = x301 * x65
    x312 = x296 * x53 - x298 * x81
    x313 = x312 * x69
    x314 = x304 * x65
    x315 = x296 * x50 - x298 * x79
    x316 = x315 * x69
    x317 = x308 * x65
    x318 = x296 * x51 - x298 * x80
    x319 = x318 * x69
    x320 = x296 * x40 - x298 * x32
    x321 = x320 * x65
    x322 = x302 * x69
    x323 = -x16 * x99 + x296 * x60
    x324 = -x306 * x69 + x323 * x65 + x68 * (x321 - x322)
    x325 = x26 * x300 + x26 * (x26 * x323 + x300) + x297
    x326 = x108 * x24 + x325
    x327 = x118 * x296 - x121 * x16
    x328 = x27 * x323 + x327
    x329 = x125 * x296 - x131 * x16
    x330 = x26 * x328 + x27 * x300 + x329
    x331 = x140 * x24 + x330
    x332 = x112 * x296 - x114 * x16
    x333 = x332 * x65
    x334 = x113 * x296 - x132 * x16
    x335 = x334 * x69
    x336 = x120 * x296 - x134 * x16
    x337 = x327 * x65 - x336 * x69 + x68 * (x333 - x335)
    x338 = x27 * x324 + x337
    x339 = x336 * x65
    x340 = x334 * x65
    x341 = x127 * x296 - x149 * x298
    x342 = x341 * x69
    x343 = x129 * x296 - x151 * x298
    x344 = x343 * x69
    x345 = x130 * x296 - x154 * x298
    x346 = x329 * x65 - x345 * x69 + x73 * (x339 - x344 + x68 * (x340 - x342))
    x347 = x306 * x68
    x348 = x28 * x323 + x347
    x349 = x301 * x68
    x350 = x26 * x348 + x28 * x300 + x349
    x351 = x157 * x24 + x350
    x352 = x307 * x68 - x309 * x68 + x68 * (x303 * x68 - x305 * x68)
    x353 = x28 * x324 + x352
    x354 = (
        x311 * x68
        - x313 * x68
        + x73 * (x317 * x68 - x319 * x68 + x68 * (x314 * x68 - x316 * x68))
    )
    x355 = -x16 * x165 + x163 * x296
    x356 = x27 * x327 + x355
    x357 = x27 * x328 + x356
    x358 = x170 * x24 + x357
    x359 = x158 * x296 - x16 * x160
    x360 = x359 * x65
    x361 = x159 * x296 - x173 * x298
    x362 = x361 * x69
    x363 = x164 * x296 - x175 * x298
    x364 = x27 * x337 + x355 * x65 - x363 * x69 + x68 * (x360 - x362)
    x365 = x336 * x68
    x366 = x28 * x327 + x365
    x367 = x27 * x348 + x366
    x368 = x180 * x24 + x367
    x369 = x339 * x68 - x344 * x68 + x68 * (x340 * x68 - x342 * x68)
    x370 = x28 * x337 + x369
    x371 = x24 * x29
    x372 = 2 / x67**2
    x373 = x28 * x347 + x308 * x372
    x374 = x28 * x348 + x373
    x375 = x371 * x60 + x374
    x376 = x28 * x352 + x317 * x372 - x319 * x372 + x68 * (x314 * x372 - x316 * x372)
    x377 = x116 * x296 - x16 * x184
    x378 = x26 * x327 + x26 * (x26 * x377 + x327) + x329
    x379 = x189 * x24 + x378
    x380 = -x332 * x69 + x377 * x65
    x381 = -x16 * x194 + x162 * x296
    x382 = x27 * x377 + x381
    x383 = x26 * x382 + x356
    x384 = x200 * x24 + x383
    x385 = -x359 * x69 + x381 * x65
    x386 = x27 * x380 + x385
    x387 = x332 * x68
    x388 = x28 * x377 + x387
    x389 = x26 * x388 + x366
    x390 = x206 * x24 + x389
    x391 = x333 * x68 - x335 * x68
    x392 = x28 * x380 + x391
    x393 = -x16 * x208 + x209 * x296
    x394 = x207 * x296 - x212 * x298
    x395 = x27 * x381 + x27 * x382 + x393
    x396 = x214 * x24 + x395
    x397 = x359 * x68
    x398 = x27 * x388 + x28 * x381 + x397
    x399 = x216 * x24 + x398
    x400 = x360 * x68 - x362 * x68
    x401 = x28 * x387 + x334 * x372
    x402 = x28 * x388 + x401
    x403 = x116 * x371 + x402
    x404 = x28 * x391 + x340 * x372 - x342 * x372
    x405 = x320 * x68
    x406 = x26 * x347 + x26 * (x26 * x405 + x347) + x349
    x407 = x321 * x68 - x322 * x68
    x408 = x27 * x405 + x387
    x409 = x26 * x408 + x27 * x347 + x365
    x410 = x27 * x407 + x391
    x411 = x302 * x372
    x412 = x28 * x405 + x411
    x413 = x26 * x412 + x373
    x414 = x303 * x372 - x305 * x372
    x415 = x28 * x407 + x414
    x416 = x27 * x387 + x27 * x408 + x397
    x417 = x27 * x412 + x401
    x418 = 6 / x67**3
    x419 = x28 * x411 + x28 * x412 + x304 * x418
    x420 = x218 * x222 - x220 * x223 + x87
    x421 = x103 + x218 * x233 - x220 * x226
    x422 = x26 * x421
    x423 = x27 * x421
    x424 = x142 + x218 * x240 - x220 * x248 + x68 * (x218 * x226 - x220 * x227 + x92)
    x425 = x423 + x424
    x426 = x146 + x218 * x242 - x220 * x253 + x68 * (x218 * x223 - x220 * x229 + x95)
    x427 = (
        x171
        + x218 * x257
        - x220 * x263
        + x27 * x424
        + x73
        * (x147 + x218 * x248 - x220 * x252 + x68 * (x218 * x227 - x220 * x231 + x96))
    )
    x428 = x28 * x424
    x429 = x190 + x218 * x272 - x220 * x246 + x68 * (x104 + x218 * x232 - x220 * x224)
    x430 = x26 * x429
    x431 = x27 * x429
    x432 = (
        x202
        + x218 * x279
        - x220 * x261
        + x73
        * (x143 + x218 * x246 - x220 * x247 + x68 * (x218 * x224 - x220 * x225 + x93))
    )
    x433 = x431 + x432
    x434 = x218 * x300 - x220 * x301
    x435 = x218 * x323 - x220 * x306
    x436 = x220 * x308
    x437 = x218 * x327 - x220 * x336 + x68 * (x218 * x306 - x436)
    x438 = x27 * x435 + x437
    x439 = x220 * x312
    x440 = x218 * x329 - x220 * x345 + x68 * (x218 * x301 - x439)
    x441 = x218 * x347 - x436 * x68
    x442 = x28 * x435 + x441
    x443 = x218 * x349 - x439 * x68
    x444 = x218 * x308
    x445 = x220 * x318
    x446 = x220 * x343
    x447 = (
        x218 * x355
        - x220 * x363
        + x27 * x437
        + x73 * (x218 * x336 - x446 + x68 * (x444 - x445))
    )
    x448 = x218 * x365 - x446 * x68 + x68 * (x444 * x68 - x445 * x68)
    x449 = x28 * x437 + x448
    x450 = x28 * x441 + x372 * x444 - x372 * x445
    x451 = x218 * x320
    x452 = x220 * x302
    x453 = x218 * x377 - x220 * x332 + x68 * (x451 - x452)
    x454 = x218 * x302
    x455 = x220 * x304
    x456 = x220 * x334
    x457 = x218 * x381 - x220 * x359 + x73 * (x218 * x332 - x456 + x68 * (x454 - x455))
    x458 = x27 * x453 + x457
    x459 = x218 * x387 - x456 * x68 + x68 * (x454 * x68 - x455 * x68)
    x460 = x28 * x453 + x459
    x461 = x220 * x361
    x462 = x218 * x304
    x463 = x220 * x315
    x464 = x218 * x334
    x465 = x220 * x341
    x466 = (
        x218 * x397
        - x461 * x68
        + x73 * (x464 * x68 - x465 * x68 + x68 * (x462 * x68 - x463 * x68))
    )
    x467 = x28 * x459 + x372 * x464 - x372 * x465 + x68 * (x372 * x462 - x372 * x463)
    x468 = x451 * x68 - x452 * x68
    x469 = x27 * x468 + x459
    x470 = x372 * x454 - x372 * x455
    x471 = x28 * x468 + x470
    x472 = x296 * x300 - x298 * x301 + x87
    x473 = x103 + x296 * x323 - x298 * x306
    x474 = x142 + x296 * x327 - x298 * x336
    x475 = x27 * x473 + x474
    x476 = x146 + x296 * x329 - x298 * x345
    x477 = x298 * x308
    x478 = x296 * x347 - x477 * x68 + x68 * (x296 * x306 - x477 + x92)
    x479 = x28 * x473 + x478
    x480 = x298 * x312
    x481 = x296 * x349 - x480 * x68 + x68 * (x296 * x301 - x480 + x95)
    x482 = x171 + x27 * x474 + x296 * x355 - x298 * x363
    x483 = x298 * x343
    x484 = x296 * x365 - x483 * x68 + x68 * (x147 + x296 * x336 - x483)
    x485 = x28 * x474 + x484
    x486 = x296 * x308
    x487 = x298 * x318
    x488 = (
        x28 * x478
        + x372 * x486
        - x372 * x487
        + x73 * (x486 * x68 - x487 * x68 + x68 * (x486 - x487 + x96))
    )
    x489 = x190 + x296 * x377 - x298 * x332
    x490 = x202 + x296 * x381 - x298 * x359
    x491 = x27 * x489 + x490
    x492 = x298 * x334
    x493 = x296 * x387 - x492 * x68 + x68 * (x143 + x296 * x332 - x492)
    x494 = x28 * x489 + x493
    x495 = x298 * x361
    x496 = x296 * x397 - x495 * x68 + x68 * (x172 + x296 * x359 - x495)
    x497 = x296 * x334
    x498 = x298 * x341
    x499 = (
        x28 * x493
        + x372 * x497
        - x372 * x498
        + x73 * (x497 * x68 - x498 * x68 + x68 * (x148 + x497 - x498))
    )
    x500 = x296 * x320
    x501 = x298 * x302
    x502 = x500 * x68 - x501 * x68 + x68 * (x104 + x500 - x501)
    x503 = 2 * x24
    x504 = x27 * x502 + x493
    x505 = x296 * x302
    x506 = x298 * x304
    x507 = (
        x372 * x505
        - x372 * x506
        + x73 * (x505 * x68 - x506 * x68 + x68 * (x505 - x506 + x93))
    )
    x508 = x28 * x502 + x507
    x509 = x296 * x304
    x510 = x298 * x315

    # 108 item(s)
    S = numpy.array(
        [
            x102 * x22
            + x22 * (x102 + x108 * x22)
            + x26 * x94
            + x26 * (x106 + x94)
            + x64
            + x65 * x76
            - x69 * (x54 * x65 - x69 * x82 + x75 * x85)
            + x75
            * (
                x65 * x74
                - x69 * x85
                + x73
                * (x65 * x72 + x68 * (x65 * x70 - x69 * x83 + x97) - x69 * x84 + x96)
                + x95
            ),
            x137 * x22 + x145 * x26 + x155 + x22 * (x137 + x140 * x22) + x27 * x94,
            x106 * x28 + x156 * x22 + x22 * (x156 + x157 * x22) + x28 * x94,
            x145 * x27 + x168 * x22 + x176 + x22 * (x168 + x170 * x22),
            x141 * x28 + x178 * x22 + x181 + x22 * (x178 + x180 * x22),
            x105 * x29 + x182 * x22 + x22 * (x182 + x183 * x60),
            x144 * x26
            + x155
            + x187 * x22
            + x22 * (x187 + x189 * x22)
            + x26 * (x144 + x192),
            x176 + x197 * x22 + x204 * x26 + x22 * (x197 + x200 * x22),
            x181 + x192 * x28 + x205 * x22 + x22 * (x205 + x206 * x22),
            x203 * x27
            + x204 * x27
            + x210
            + x211 * x65
            + x213 * x22
            + x22 * (x213 + x214 * x22)
            - x69 * (x207 * x65 - x212 * x69),
            x201 * x28 + x203 * x28 + x215 * x22 + x22 * (x215 + x216 * x22),
            x191 * x29 + x217 * x22 + x22 * (x116 * x183 + x217),
            0,
            0,
            0,
            0,
            0,
            0,
            x102 * x23
            + x219 * x65
            + x22 * x238
            - x221 * x69
            + x228 * x26
            + x26 * (x228 + x235)
            + x75
            * (
                x223 * x65
                - x229 * x69
                + x73 * (x227 * x65 - x231 * x69 + x68 * (x225 * x65 - x230 * x69))
            ),
            x137 * x23 + x22 * x244 + x228 * x27 + x250 * x26 + x254,
            x156 * x23 + x22 * x256 + x228 * x28 + x235 * x28,
            x168 * x23 + x22 * x260 + x250 * x27 + x264,
            x178 * x23 + x22 * x267 + x245 * x28 + x268,
            x182 * x23 + x22 * x271 + x234 * x29,
            x187 * x23 + x22 * x275 + x249 * x26 + x254 + x26 * (x249 + x277),
            x197 * x23 + x22 * x282 + x26 * x285 + x264,
            x205 * x23 + x22 * x287 + x268 + x277 * x28,
            x213 * x23 + x22 * x291 + x27 * x284 + x27 * x285 + x288 * x65 - x289 * x69,
            x215 * x23 + x22 * x293 + x28 * x283 + x28 * x284,
            x217 * x23 + x22 * x295 + x276 * x29,
            0,
            0,
            0,
            0,
            0,
            0,
            x102 * x24
            + x22 * x326
            + x26 * x310
            + x26 * (x26 * x324 + x310)
            + x297 * x65
            - x299 * x69
            + x75 * (x311 - x313 + x73 * (x317 - x319 + x68 * (x314 - x316))),
            x137 * x24 + x22 * x331 + x26 * x338 + x27 * x310 + x346,
            x156 * x24 + x22 * x351 + x26 * x353 + x28 * x310 + x354,
            x168 * x24 + x22 * x358 + x27 * x338 + x364,
            x178 * x24 + x22 * x368 + x27 * x353 + x370,
            x182 * x24 + x22 * x375 + x28 * x353 + x376,
            x187 * x24 + x22 * x379 + x26 * x337 + x26 * (x26 * x380 + x337) + x346,
            x197 * x24 + x22 * x384 + x26 * x386 + x364,
            x205 * x24 + x22 * x390 + x26 * x392 + x370,
            x213 * x24 + x22 * x396 + x27 * x385 + x27 * x386 + x393 * x65 - x394 * x69,
            x215 * x24 + x22 * x399 + x27 * x392 + x28 * x385 + x400,
            x217 * x24 + x22 * x403 + x28 * x392 + x404,
            x22 * x406 + x26 * x352 + x26 * (x26 * x407 + x352) + x354,
            x22 * x409 + x26 * x410 + x27 * x352 + x369,
            x22 * x413 + x26 * x415 + x376,
            x22 * x416 + x27 * x391 + x27 * x410 + x400,
            x22 * x417 + x27 * x415 + x404,
            x22 * x419 + x28 * x414 + x28 * x415 + x314 * x418 - x316 * x418,
            x218 * x219
            - x220 * x221
            + x23 * x237
            + x23 * x238
            + x26 * x420
            + x26 * (x420 + x422)
            + x64,
            x23 * x243 + x23 * x244 + x26 * x425 + x27 * x420 + x426,
            x23 * x255 + x23 * x256 + x28 * x420 + x28 * x422,
            x23 * x259 + x23 * x260 + x27 * x425 + x427,
            x23 * x266 + x23 * x267 + x28 * x423 + x428,
            x23 * x270 + x23 * x271 + x29 * x421,
            x23 * x274 + x23 * x275 + x26 * x424 + x26 * (x424 + x430) + x426,
            x23 * x281 + x23 * x282 + x26 * x433 + x427,
            x23 * x286 + x23 * x287 + x28 * x430 + x428,
            x210
            + x218 * x288
            - x220 * x289
            + x23 * x290
            + x23 * x291
            + x27 * x432
            + x27 * x433
            + x75
            * (
                x172
                + x218 * x261
                - x220 * x262
                + x73
                * (
                    x148
                    + x218 * x247
                    - x220 * x251
                    + x68 * (x218 * x225 - x220 * x230 + x97)
                )
            ),
            x23 * x292 + x23 * x293 + x28 * x431 + x28 * x432,
            x23 * x294 + x23 * x295 + x29 * x429,
            0,
            0,
            0,
            0,
            0,
            0,
            x218 * x297
            - x220 * x299
            + x23 * x326
            + x237 * x24
            + x26 * x434
            + x26 * (x26 * x435 + x434),
            x23 * x331 + x24 * x243 + x26 * x438 + x27 * x434 + x440,
            x23 * x351 + x24 * x255 + x26 * x442 + x28 * x434 + x443,
            x23 * x358 + x24 * x259 + x27 * x438 + x447,
            x23 * x368 + x24 * x266 + x27 * x442 + x449,
            x23 * x375 + x24 * x270 + x28 * x442 + x450,
            x23 * x379 + x24 * x274 + x26 * x437 + x26 * (x26 * x453 + x437) + x440,
            x23 * x384 + x24 * x281 + x26 * x458 + x447,
            x23 * x390 + x24 * x286 + x26 * x460 + x449,
            x218 * x393
            - x220 * x394
            + x23 * x396
            + x24 * x290
            + x27 * x457
            + x27 * x458
            + x75 * (x218 * x359 - x461 + x73 * (x464 - x465 + x68 * (x462 - x463))),
            x23 * x399 + x24 * x292 + x27 * x460 + x28 * x457 + x466,
            x23 * x403 + x24 * x294 + x28 * x460 + x467,
            x23 * x406 + x26 * x441 + x26 * (x26 * x468 + x441) + x443,
            x23 * x409 + x26 * x469 + x27 * x441 + x448,
            x23 * x413 + x26 * x471 + x450,
            x23 * x416 + x27 * x459 + x27 * x469 + x466,
            x23 * x417 + x27 * x471 + x467,
            x23 * x419 + x28 * x470 + x28 * x471 + x418 * x462 - x418 * x463,
            x24 * x325
            + x24 * x326
            + x26 * x472
            + x26 * (x26 * x473 + x472)
            + x296 * x297
            - x298 * x299
            + x64,
            x24 * x330 + x24 * x331 + x26 * x475 + x27 * x472 + x476,
            x24 * x350 + x24 * x351 + x26 * x479 + x28 * x472 + x481,
            x24 * x357 + x24 * x358 + x27 * x475 + x482,
            x24 * x367 + x24 * x368 + x27 * x479 + x485,
            x24 * x374 + x24 * x375 + x28 * x479 + x488,
            x24 * x378 + x24 * x379 + x26 * x474 + x26 * (x26 * x489 + x474) + x476,
            x24 * x383 + x24 * x384 + x26 * x491 + x482,
            x24 * x389 + x24 * x390 + x26 * x494 + x485,
            x210
            + x24 * x395
            + x24 * x396
            + x27 * x490
            + x27 * x491
            + x296 * x393
            - x298 * x394,
            x24 * x398 + x24 * x399 + x27 * x494 + x28 * x490 + x496,
            x24 * x402 + x24 * x403 + x28 * x494 + x499,
            x26 * x478 + x26 * (x26 * x502 + x478) + x406 * x503 + x481,
            x26 * x504 + x27 * x478 + x409 * x503 + x484,
            x26 * x508 + x413 * x503 + x488,
            x27 * x493 + x27 * x504 + x416 * x503 + x496,
            x27 * x508 + x417 * x503 + x499,
            x28 * x507
            + x28 * x508
            + x418 * x509
            - x418 * x510
            + x419 * x503
            + x75
            * (
                x372 * x509
                - x372 * x510
                + x73 * (x509 * x68 - x510 * x68 + x68 * (x509 - x510 + x97))
            ),
        ]
    )
    return S


def eri_0220(a, A, b, B, c, C, d, D):
    """Cartesian [sd|ds] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x10 * (x11**2 + x12**2 + x13**2))
    x15 = x6 ** (-1.0)
    x16 = numpy.exp(
        -c * d * x15 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x17 = x8 ** (-1.0)
    x18 = x15 * (c * C[0] + d * D[0])
    x19 = -x10 * (a * A[0] + b * B[0])
    x20 = -x18 - x19
    x21 = x15 * (c * C[1] + d * D[1])
    x22 = -x10 * (a * A[1] + b * B[1])
    x23 = -x21 - x22
    x24 = -x10 * (a * A[2] + b * B[2])
    x25 = -x15 * (c * C[2] + d * D[2]) - x24
    x26 = x17 * x7 * (x20**2 + x23**2 + x25**2)
    x27 = boys(1, x26)
    x28 = x17 * x5
    x29 = boys(2, x26)
    x30 = 2 * x14 * x16 * x4 * x9
    x31 = x29 * x30
    x32 = x3 * (2 * x14 * x16 * x27 * x4 * x9 - x28 * x31)
    x33 = x18 - C[0]
    x34 = x27 * x30
    x35 = x20 * x28
    x36 = x31 * x35 + x33 * x34
    x37 = x30 * boys(3, x26)
    x38 = x31 * x33 + x35 * x37
    x39 = x32 + x33 * x36 + x35 * x38
    x40 = x17 * x6
    x41 = x39 * x40
    x42 = boys(0, x26)
    x43 = x3 * (2 * x14 * x16 * x4 * x42 * x9 - x28 * x34)
    x44 = x30 * x42
    x45 = x33 * (x33 * x44 + x34 * x35) + x35 * x36 + x43
    x46 = x1 * (-x41 + x45)
    x47 = -x19 - A[0]
    x48 = x0 + x2
    x49 = x48 ** (-1.0)
    x50 = x20 * x40
    x51 = x31 * x47 - x37 * x50
    x52 = x38 * x40
    x53 = -x20 * x52 + x36 * x47 + x49 * x51
    x54 = 2 * x49
    x55 = -x20 * x41 + x45 * x47 + x53 * x54
    x56 = -2 * x14 * x16 * x29 * x4 * x9
    x57 = x3 * (-x28 * x37 - x56)
    x58 = x30 * boys(4, x26)
    x59 = x33 * x37 + x35 * x58
    x60 = x33 * x38 + x35 * x59 + x57
    x61 = x37 * x47 - x50 * x58
    x62 = x38 * x47 + x49 * x61 - x50 * x59
    x63 = x1 * (x36 - x52)
    x64 = x1 * (-x37 * x40 - x56)
    x65 = x21 - C[1]
    x66 = x23 * x28
    x67 = x31 * x66 + x34 * x65
    x68 = x31 * x65 + x37 * x66
    x69 = x33 * x67 + x35 * x68
    x70 = x40 * x69
    x71 = x34 * x66 + x44 * x65
    x72 = x33 * x71 + x35 * x67
    x73 = x1 * (-x70 + x72)
    x74 = x40 * x68
    x75 = x1 * (x67 - x74)
    x76 = -x20 * x74 + x47 * x67
    x77 = x37 * x65 + x58 * x66
    x78 = x47 * x68 - x50 * x77
    x79 = -x20 * x70 + x47 * x72 + x49 * x76
    x80 = x33 * x68 + x35 * x77
    x81 = x32 + x65 * x67 + x66 * x68
    x82 = x40 * x81
    x83 = x43 + x65 * x71 + x66 * x67
    x84 = x1 * (-x82 + x83)
    x85 = -x20 * x82 + x47 * x83
    x86 = x57 + x65 * x68 + x66 * x77
    x87 = -x22 - A[1]
    x88 = -x23 * x41 + x45 * x87
    x89 = x23 * x40
    x90 = x39 * x87 - x60 * x89
    x91 = x31 * x87 - x37 * x89
    x92 = x37 * x87 - x58 * x89
    x93 = -x23 * x52 + x36 * x87
    x94 = x38 * x87 - x59 * x89
    x95 = x12 * x45 + x88
    x96 = -x23 * x74 + x49 * x91 + x67 * x87
    x97 = x49 * x92 + x68 * x87 - x77 * x89
    x98 = -x23 * x70 + x49 * x93 + x72 * x87
    x99 = x49 * x94 + x69 * x87 - x80 * x89
    x100 = x12 * x72 + x98
    x101 = -x23 * x82 + x54 * x96 + x83 * x87
    x102 = x54 * x97 + x81 * x87 - x86 * x89
    x103 = x101 + x12 * x83
    x104 = -x24 - A[2]
    x105 = x104 * x45 - x25 * x41
    x106 = x25 * x40
    x107 = x104 * x39 - x106 * x60
    x108 = x104 * x31 - x106 * x37
    x109 = x108 * x47
    x110 = x104 * x37 - x106 * x58
    x111 = x110 * x50
    x112 = x104 * x36 - x25 * x52
    x113 = x112 * x47
    x114 = x104 * x38 - x106 * x59
    x115 = x114 * x50
    x116 = x105 + x13 * x45
    x117 = x104 * x72 - x25 * x70
    x118 = x104 * x67 - x25 * x74
    x119 = x118 * x47
    x120 = x104 * x68 - x106 * x77
    x121 = x120 * x50
    x122 = x104 * x69 - x106 * x80
    x123 = x117 + x13 * x72
    x124 = x11 * x49
    x125 = x104 * x83 - x25 * x82
    x126 = x104 * x81 - x106 * x86
    x127 = x125 + x13 * x83
    x128 = x48 ** (-2.0)
    x129 = 2 * x128
    x130 = x108 * x129
    x131 = x112 * x87
    x132 = x114 * x89
    x133 = x12 * x49
    x134 = x108 * x87
    x135 = x110 * x89
    x136 = x118 * x87
    x137 = x120 * x89
    x138 = x13 * x54
    x139 = x104 * x112
    x140 = x106 * x114
    x141 = x104 * x118
    x142 = x106 * x120
    x143 = x104 * x108
    x144 = x106 * x110

    # 36 item(s)
    S = numpy.array(
        [
            x11 * x55
            + x11 * (x11 * x45 + x55)
            + x46
            + x47 * x55
            - x50 * (x39 * x47 - x50 * x60 + x54 * x62)
            + x54 * (x47 * x53 + x49 * (x47 * x51 - x50 * x61 + x64) - x50 * x62 + x63),
            x11 * x79
            + x11 * (x11 * x72 + x79)
            + x47 * x79
            + x49 * (x47 * x76 - x50 * x78 + x75)
            - x50 * (x47 * x69 + x49 * x78 - x50 * x80)
            + x73,
            0,
            x11 * x85
            + x11 * (x11 * x83 + x85)
            + x47 * x85
            - x50 * (x47 * x81 - x50 * x86)
            + x84,
            0,
            0,
            x11 * x95
            + x12 * x55
            + x47 * x88
            - x50 * x90
            + x54 * (x47 * x93 + x49 * (x47 * x91 - x50 * x92) - x50 * x94),
            x100 * x11
            + x12 * x79
            + x47 * x98
            + x49 * (x47 * x96 - x50 * x97)
            - x50 * x99,
            0,
            x101 * x47 - x102 * x50 + x103 * x11 + x12 * x85,
            0,
            0,
            x105 * x47
            - x107 * x50
            + x11 * x116
            + x13 * x55
            + x54 * (x113 - x115 + x49 * (x109 - x111)),
            x11 * x123 + x117 * x47 - x122 * x50 + x13 * x79 + x49 * (x119 - x121),
            x112 * x124 + x113 * x49 - x115 * x49 + x49 * (x109 * x49 - x111 * x49),
            x11 * x127 + x125 * x47 - x126 * x50 + x13 * x85,
            x118 * x124 + x119 * x49 - x121 * x49,
            x109 * x129 + x11 * x130 - x111 * x129,
            x12 * x88 + x12 * x95 + x46 + x87 * x88 - x89 * x90,
            x100 * x12
            + x12 * x98
            + x49 * (x63 + x87 * x93 - x89 * x94)
            + x73
            + x87 * x98
            - x89 * x99,
            0,
            x101 * x12
            + x101 * x87
            - x102 * x89
            + x103 * x12
            + x54 * (x49 * (x64 + x87 * x91 - x89 * x92) + x75 + x87 * x96 - x89 * x97)
            + x84,
            0,
            0,
            x105 * x87 - x107 * x89 + x116 * x12 + x13 * x88,
            x117 * x87 + x12 * x123 - x122 * x89 + x13 * x98 + x49 * (x131 - x132),
            x112 * x133 + x131 * x49 - x132 * x49,
            x101 * x13
            + x12 * x127
            + x125 * x87
            - x126 * x89
            + x54 * (x136 - x137 + x49 * (x134 - x135)),
            x118 * x133 + x136 * x49 - x137 * x49 + x49 * (x134 * x49 - x135 * x49),
            x12 * x130 + x129 * x134 - x129 * x135,
            x104 * x105 + x105 * x13 - x106 * x107 + x116 * x13 + x46,
            x104 * x117 - x106 * x122 + x117 * x13 + x123 * x13 + x73,
            x112 * x138 + x139 * x49 - x140 * x49 + x49 * (x139 - x140 + x63),
            x104 * x125 - x106 * x126 + x125 * x13 + x127 * x13 + x84,
            x118 * x138 + x141 * x49 - x142 * x49 + x49 * (x141 - x142 + x75),
            4 * x108 * x128 * x13
            + x129 * x143
            - x129 * x144
            + x54 * (x143 * x49 - x144 * x49 + x49 * (x143 - x144 + x64)),
        ]
    )
    return S


def eri_0221(a, A, b, B, c, C, d, D):
    """Cartesian [sd|dp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x9 * (x22**2 + x23**2 + x24**2))
    x26 = C[0] - D[0]
    x27 = C[1] - D[1]
    x28 = C[2] - D[2]
    x29 = numpy.exp(-c * d * x3 * (x26**2 + x27**2 + x28**2))
    x30 = 2 * x20 * x21 * x25 * x29
    x31 = x19 * x30
    x32 = x6 * x8
    x33 = x11 * x32
    x34 = boys(3, x18)
    x35 = x30 * x34
    x36 = x31 * x5 + x33 * x35
    x37 = x32 * x36
    x38 = boys(1, x18)
    x39 = x30 * x38
    x40 = x31 * x33 + x39 * x5
    x41 = 2 * c + 2 * d
    x42 = x41 ** (-1.0)
    x43 = 2 * x42
    x44 = x42 * (2 * x20 * x21 * x25 * x29 * x38 - x31 * x32)
    x45 = x11 * x37 + x40 * x5 + x44
    x46 = -2 * x19 * x20 * x21 * x25 * x29
    x47 = x42 * (-x32 * x35 - x46)
    x48 = x30 * boys(4, x18)
    x49 = x33 * x48 + x35 * x5
    x50 = x32 * x49
    x51 = x11 * x50 + x36 * x5 + x47
    x52 = x33 * x51 + x43 * (-x37 + x40) + x45 * x5
    x53 = x2 * x8
    x54 = x52 * x53
    x55 = x32 * x40
    x56 = boys(0, x18)
    x57 = x30 * x56
    x58 = x33 * x39 + x5 * x57
    x59 = x42 * (2 * x20 * x21 * x25 * x29 * x56 - x32 * x39)
    x60 = x11 * x55 + x5 * x58 + x59
    x61 = x33 * x45 + x43 * (-x55 + x58) + x5 * x60
    x62 = x1 * (-x54 + x61)
    x63 = -x10 - A[0]
    x64 = x51 * x53
    x65 = x0 + x41
    x66 = x65 ** (-1.0)
    x67 = x11 * x53
    x68 = x35 * x63 - x48 * x67
    x69 = x49 * x53
    x70 = -x11 * x69 + x36 * x63 + x66 * x68
    x71 = 2 * x66
    x72 = -x11 * x64 + x45 * x63 + x70 * x71
    x73 = 3 * x66
    x74 = -x11 * x54 + x61 * x63 + x72 * x73
    x75 = -2 * x20 * x21 * x25 * x29 * x34
    x76 = x42 * (-x32 * x48 - x75)
    x77 = x30 * boys(5, x18)
    x78 = x33 * x77 + x48 * x5
    x79 = x33 * x78 + x49 * x5 + x76
    x80 = x33 * x79 + x43 * (x36 - x50) + x5 * x51
    x81 = x48 * x63 - x67 * x77
    x82 = x49 * x63 + x66 * x81 - x67 * x78
    x83 = x51 * x63 - x67 * x79 + x71 * x82
    x84 = x45 * x53
    x85 = x31 * x63 - x35 * x67
    x86 = x36 * x53
    x87 = -x11 * x86 + x40 * x63 + x66 * x85
    x88 = -x11 * x84 + x60 * x63 + x71 * x87
    x89 = x26 * x88 + x74
    x90 = x1 * (x60 - x84)
    x91 = x1 * (x40 - x86)
    x92 = x1 * (-x35 * x53 - x46)
    x93 = (
        x63 * x88
        - x67 * x72
        + x71 * (x63 * x87 + x66 * (x63 * x85 - x67 * x68 + x92) - x67 * x70 + x91)
        + x90
    )
    x94 = x1 * (x45 - x64)
    x95 = x1 * (x36 - x69)
    x96 = x1 * (-x48 * x53 - x75)
    x97 = x26 * x60 + x61
    x98 = x12 - C[1]
    x99 = x14 * x32
    x100 = x31 * x99 + x39 * x98
    x101 = x100 * x32
    x102 = x39 * x99 + x57 * x98
    x103 = x42 * (-x101 + x102)
    x104 = x101 * x11 + x102 * x5
    x105 = x31 * x98 + x35 * x99
    x106 = x105 * x32
    x107 = x100 * x5 + x106 * x11
    x108 = x103 + x104 * x5 + x107 * x33
    x109 = x42 * (x100 - x106)
    x110 = x35 * x98 + x48 * x99
    x111 = x110 * x32
    x112 = x105 * x5 + x11 * x111
    x113 = x107 * x5 + x109 + x112 * x33
    x114 = x113 * x53
    x115 = x110 * x53
    x116 = x105 * x63 - x11 * x115
    x117 = x112 * x53
    x118 = x107 * x63 - x11 * x117 + x116 * x66
    x119 = x108 * x63 - x11 * x114 + x118 * x71
    x120 = x119 + x27 * x88
    x121 = x108 + x27 * x60
    x122 = x1 * (x108 - x114)
    x123 = x1 * (x107 - x117)
    x124 = x1 * (x105 - x115)
    x125 = x48 * x98 + x77 * x99
    x126 = x110 * x63 - x125 * x67
    x127 = x110 * x5 + x125 * x33
    x128 = x112 * x63 + x126 * x66 - x127 * x67
    x129 = x42 * (x105 - x111)
    x130 = x112 * x5 + x127 * x33 + x129
    x131 = (
        x119 * x63
        + x122
        - x67 * (x113 * x63 + x128 * x71 - x130 * x67)
        + x71 * (x118 * x63 + x123 - x128 * x67 + x66 * (x116 * x63 + x124 - x126 * x67))
    )
    x132 = x28 * x88
    x133 = x22 * x28
    x134 = x105 * x53
    x135 = x100 * x63 - x11 * x134
    x136 = x107 * x53
    x137 = x104 * x63 - x11 * x136 + x135 * x66
    x138 = x119 + x137 * x26
    x139 = x104 * x26 + x108
    x140 = x1 * (x104 - x136)
    x141 = x1 * (x100 - x134)
    x142 = -x118 * x67 + x137 * x63 + x140 + x66 * (-x116 * x67 + x135 * x63 + x141)
    x143 = x100 * x98 + x106 * x14 + x44
    x144 = x105 * x98 + x111 * x14 + x47
    x145 = x144 * x53
    x146 = -x11 * x145 + x143 * x63
    x147 = x101 * x14 + x102 * x98 + x59
    x148 = x143 * x33 + x147 * x5
    x149 = x143 * x5 + x144 * x33
    x150 = x149 * x53
    x151 = -x11 * x150 + x146 * x66 + x148 * x63
    x152 = x137 * x27 + x151
    x153 = x104 * x27 + x148
    x154 = x1 * (x148 - x150)
    x155 = x1 * (x143 - x145)
    x156 = x110 * x98 + x125 * x99 + x76
    x157 = x144 * x63 - x156 * x67
    x158 = x144 * x5 + x156 * x33
    x159 = (
        x151 * x63
        + x154
        + x66 * (x146 * x63 + x155 - x157 * x67)
        - x67 * (x149 * x63 + x157 * x66 - x158 * x67)
    )
    x160 = x137 * x28
    x161 = x143 * x53
    x162 = -x11 * x161 + x147 * x63
    x163 = x151 + x162 * x26
    x164 = x147 * x26 + x148
    x165 = x1 * (x147 - x161)
    x166 = -x146 * x67 + x162 * x63 + x165
    x167 = 2 * x109 + x143 * x98 + x144 * x99
    x168 = x167 * x53
    x169 = 2 * x103 + x143 * x99 + x147 * x98
    x170 = x1 * (-x168 + x169)
    x171 = -x11 * x168 + x169 * x63
    x172 = 2 * x129 + x144 * x98 + x156 * x99
    x173 = x162 * x27 + x171
    x174 = x147 * x27 + x169
    x175 = x162 * x28
    x176 = -x13 - A[1]
    x177 = -x14 * x54 + x176 * x61
    x178 = x14 * x53
    x179 = x176 * x52 - x178 * x80
    x180 = -x14 * x84 + x176 * x60
    x181 = -x14 * x64 + x176 * x45
    x182 = x176 * x31 - x178 * x35
    x183 = x176 * x35 - x178 * x48
    x184 = -x14 * x86 + x176 * x40
    x185 = -x14 * x69 + x176 * x36
    x186 = (
        x180 * x63
        - x181 * x67
        + x71 * (x184 * x63 - x185 * x67 + x66 * (x182 * x63 - x183 * x67))
    )
    x187 = x176 * x51 - x178 * x79
    x188 = x176 * x48 - x178 * x77
    x189 = x176 * x49 - x178 * x78
    x190 = x177 + x180 * x26
    x191 = x190 + x23 * x97
    x192 = x108 * x176 - x114 * x14 + x181 * x66
    x193 = x180 * x27 + x192
    x194 = x121 * x23 + x193
    x195 = x105 * x176 - x115 * x14 + x183 * x66
    x196 = x110 * x176 - x125 * x178 + x188 * x66
    x197 = x107 * x176 - x117 * x14 + x185 * x66
    x198 = x112 * x176 - x127 * x178 + x189 * x66
    x199 = x113 * x176 - x130 * x178 + x187 * x66
    x200 = (
        x192 * x63
        - x199 * x67
        + x71 * (x197 * x63 - x198 * x67 + x66 * (x195 * x63 - x196 * x67))
    )
    x201 = x23 * x28
    x202 = x180 * x28
    x203 = x201 * x60 + x202
    x204 = x104 * x176 - x136 * x14 + x184 * x66
    x205 = x192 + x204 * x26
    x206 = x139 * x23 + x205
    x207 = x100 * x176 - x134 * x14 + x182 * x66
    x208 = -x197 * x67 + x204 * x63 + x66 * (-x195 * x67 + x207 * x63)
    x209 = -x14 * x150 + x148 * x176 + x197 * x71
    x210 = x204 * x27 + x209
    x211 = x153 * x23 + x210
    x212 = -x14 * x145 + x143 * x176 + x195 * x71
    x213 = x144 * x176 - x156 * x178 + x196 * x71
    x214 = x149 * x176 - x158 * x178 + x198 * x71
    x215 = x209 * x63 - x214 * x67 + x66 * (x212 * x63 - x213 * x67)
    x216 = x204 * x28
    x217 = x104 * x201 + x216
    x218 = -x14 * x161 + x147 * x176 + x207 * x71
    x219 = x209 + x218 * x26
    x220 = x164 * x23 + x219
    x221 = -x212 * x67 + x218 * x63
    x222 = -x14 * x168 + x169 * x176 + x212 * x73
    x223 = x167 * x176 - x172 * x178 + x213 * x73
    x224 = x218 * x27 + x222
    x225 = x174 * x23 + x224
    x226 = x218 * x28
    x227 = x147 * x201 + x226
    x228 = -x15 - A[2]
    x229 = -x16 * x54 + x228 * x61
    x230 = x16 * x53
    x231 = x228 * x52 - x230 * x80
    x232 = -x16 * x84 + x228 * x60
    x233 = -x16 * x64 + x228 * x45
    x234 = x228 * x31 - x230 * x35
    x235 = x234 * x63
    x236 = x228 * x35 - x230 * x48
    x237 = x236 * x67
    x238 = -x16 * x86 + x228 * x40
    x239 = x238 * x63
    x240 = -x16 * x69 + x228 * x36
    x241 = x240 * x67
    x242 = x232 * x63 - x233 * x67 + x71 * (x239 - x241 + x66 * (x235 - x237))
    x243 = x233 * x63
    x244 = x228 * x51 - x230 * x79
    x245 = x244 * x67
    x246 = x236 * x63
    x247 = x228 * x48 - x230 * x77
    x248 = x247 * x67
    x249 = x240 * x63
    x250 = x228 * x49 - x230 * x78
    x251 = x250 * x67
    x252 = x229 + x232 * x26
    x253 = x24 * x97 + x252
    x254 = x108 * x228 - x114 * x16
    x255 = x232 * x27 + x254
    x256 = x121 * x24 + x255
    x257 = x107 * x228 - x117 * x16
    x258 = x257 * x63
    x259 = x105 * x228 - x115 * x16
    x260 = x259 * x63
    x261 = x110 * x228 - x125 * x230
    x262 = x261 * x67
    x263 = x112 * x228 - x127 * x230
    x264 = x263 * x67
    x265 = x113 * x228 - x130 * x230
    x266 = x254 * x63 - x265 * x67 + x71 * (x258 - x264 + x66 * (x260 - x262))
    x267 = x24 * x28
    x268 = x233 * x66
    x269 = x232 * x28 + x268
    x270 = x267 * x60 + x269
    x271 = (
        x243 * x66
        - x245 * x66
        + x71 * (x249 * x66 - x251 * x66 + x66 * (x246 * x66 - x248 * x66))
    )
    x272 = x104 * x228 - x136 * x16
    x273 = x254 + x26 * x272
    x274 = x139 * x24 + x273
    x275 = x100 * x228 - x134 * x16
    x276 = x275 * x63
    x277 = x259 * x67
    x278 = -x257 * x67 + x272 * x63 + x66 * (x276 - x277)
    x279 = x148 * x228 - x150 * x16
    x280 = x27 * x272 + x279
    x281 = x153 * x24 + x280
    x282 = x143 * x228 - x145 * x16
    x283 = x282 * x63
    x284 = x144 * x228 - x156 * x230
    x285 = x284 * x67
    x286 = x149 * x228 - x158 * x230
    x287 = x279 * x63 - x286 * x67 + x66 * (x283 - x285)
    x288 = x257 * x66
    x289 = x272 * x28 + x288
    x290 = x104 * x267 + x289
    x291 = x258 * x66 - x264 * x66 + x66 * (x260 * x66 - x262 * x66)
    x292 = x238 * x66
    x293 = x26 * x292 + x268
    x294 = x239 * x66 - x241 * x66 + x66 * (x235 * x66 - x237 * x66)
    x295 = x27 * x292 + x288
    x296 = 2 / x65**2
    x297 = x240 * x296
    x298 = x28 * x292 + x297
    x299 = x249 * x296 - x251 * x296 + x66 * (x246 * x296 - x248 * x296)
    x300 = x147 * x228 - x16 * x161
    x301 = x26 * x300 + x279
    x302 = x164 * x24 + x301
    x303 = -x282 * x67 + x300 * x63
    x304 = -x16 * x168 + x169 * x228
    x305 = x167 * x228 - x172 * x230
    x306 = x27 * x300 + x304
    x307 = x174 * x24 + x306
    x308 = x282 * x66
    x309 = x28 * x300 + x308
    x310 = x147 * x267 + x309
    x311 = x283 * x66 - x285 * x66
    x312 = x275 * x66
    x313 = x26 * x312 + x288
    x314 = x276 * x66 - x277 * x66
    x315 = x27 * x312 + x308
    x316 = x259 * x296
    x317 = x28 * x312 + x316
    x318 = x260 * x296 - x262 * x296
    x319 = x234 * x296
    x320 = x26 * x319 + x297
    x321 = x235 * x296 - x237 * x296
    x322 = x27 * x319 + x316
    x323 = 6 / x65**3
    x324 = x236 * x323 + x28 * x319
    x325 = x176 * x180 - x178 * x181 + x90
    x326 = x122 + x176 * x192 - x178 * x199 + x66 * (x176 * x181 - x178 * x187 + x94)
    x327 = x140 + x176 * x204 - x178 * x197 + x66 * (x176 * x184 - x178 * x185 + x91)
    x328 = (
        x154
        + x176 * x209
        - x178 * x214
        + x71
        * (x123 + x176 * x197 - x178 * x198 + x66 * (x176 * x185 - x178 * x189 + x95))
    )
    x329 = (
        x165
        + x176 * x218
        - x178 * x212
        + x71
        * (x141 + x176 * x207 - x178 * x195 + x66 * (x176 * x182 - x178 * x183 + x92))
    )
    x330 = x176 * x232 - x178 * x233
    x331 = x178 * x244
    x332 = x176 * x254 - x178 * x265 + x66 * (x176 * x233 - x331)
    x333 = x176 * x268 - x331 * x66
    x334 = x176 * x238
    x335 = x178 * x240
    x336 = x176 * x272 - x178 * x257 + x66 * (x334 - x335)
    x337 = x176 * x240
    x338 = x178 * x250
    x339 = x178 * x263
    x340 = x176 * x279 - x178 * x286 + x71 * (x176 * x257 - x339 + x66 * (x337 - x338))
    x341 = x176 * x288 - x339 * x66 + x66 * (x337 * x66 - x338 * x66)
    x342 = x334 * x66 - x335 * x66
    x343 = x296 * x337 - x296 * x338
    x344 = x176 * x234
    x345 = x178 * x236
    x346 = x176 * x275
    x347 = x178 * x259
    x348 = x176 * x300 - x178 * x282 + x71 * (x346 - x347 + x66 * (x344 - x345))
    x349 = x178 * x284
    x350 = x176 * x236
    x351 = x178 * x247
    x352 = x176 * x259
    x353 = x178 * x261
    x354 = (
        x176 * x308
        - x349 * x66
        + x71 * (x352 * x66 - x353 * x66 + x66 * (x350 * x66 - x351 * x66))
    )
    x355 = x346 * x66 - x347 * x66 + x66 * (x344 * x66 - x345 * x66)
    x356 = x296 * x352 - x296 * x353 + x66 * (x296 * x350 - x296 * x351)
    x357 = x296 * x344 - x296 * x345
    x358 = x228 * x232 - x230 * x233 + x90
    x359 = x122 + x228 * x254 - x230 * x265
    x360 = x230 * x244
    x361 = x228 * x268 - x360 * x66 + x66 * (x228 * x233 - x360 + x94)
    x362 = x140 + x228 * x272 - x230 * x257
    x363 = x154 + x228 * x279 - x230 * x286
    x364 = x230 * x263
    x365 = x228 * x288 - x364 * x66 + x66 * (x123 + x228 * x257 - x364)
    x366 = x228 * x238
    x367 = x230 * x240
    x368 = x366 * x66 - x367 * x66 + x66 * (x366 - x367 + x91)
    x369 = 2 * x24
    x370 = x228 * x240
    x371 = x230 * x250
    x372 = (
        x296 * x370
        - x296 * x371
        + x71 * (x370 * x66 - x371 * x66 + x66 * (x370 - x371 + x95))
    )
    x373 = x165 + x228 * x300 - x230 * x282
    x374 = x230 * x284
    x375 = x228 * x308 - x374 * x66 + x66 * (x155 + x228 * x282 - x374)
    x376 = x228 * x275
    x377 = x230 * x259
    x378 = x376 * x66 - x377 * x66 + x66 * (x141 + x376 - x377)
    x379 = x228 * x259
    x380 = x230 * x261
    x381 = (
        x296 * x379
        - x296 * x380
        + x71 * (x379 * x66 - x380 * x66 + x66 * (x124 + x379 - x380))
    )
    x382 = x228 * x234
    x383 = x230 * x236
    x384 = (
        x296 * x382
        - x296 * x383
        + x71 * (x382 * x66 - x383 * x66 + x66 * (x382 - x383 + x92))
    )
    x385 = x228 * x236
    x386 = x230 * x247

    # 108 item(s)
    S = numpy.array(
        [
            x22 * x89
            + x22 * (x22 * x97 + x89)
            + x26 * x93
            + x62
            + x63 * x74
            - x67 * (x52 * x63 - x67 * x80 + x73 * x83)
            + x73
            * (
                x63 * x72
                - x67 * x83
                + x71
                * (x63 * x70 + x66 * (x63 * x68 - x67 * x81 + x96) - x67 * x82 + x95)
                + x94
            ),
            x120 * x22 + x131 + x22 * (x120 + x121 * x22) + x27 * x93,
            x132 * x22 + x22 * (x132 + x133 * x60) + x28 * x93,
            x131 + x138 * x22 + x142 * x26 + x22 * (x138 + x139 * x22),
            x142 * x27 + x152 * x22 + x159 + x22 * (x152 + x153 * x22),
            x142 * x28 + x160 * x22 + x22 * (x104 * x133 + x160),
            0,
            0,
            0,
            x159 + x163 * x22 + x166 * x26 + x22 * (x163 + x164 * x22),
            x166 * x27
            + x170
            + x171 * x63
            + x173 * x22
            + x22 * (x173 + x174 * x22)
            - x67 * (x167 * x63 - x172 * x67),
            x166 * x28 + x175 * x22 + x22 * (x133 * x147 + x175),
            0,
            0,
            0,
            0,
            0,
            0,
            x177 * x63
            - x179 * x67
            + x186 * x26
            + x191 * x22
            + x23 * x89
            + x73
            * (
                x181 * x63
                - x187 * x67
                + x71 * (x185 * x63 - x189 * x67 + x66 * (x183 * x63 - x188 * x67))
            ),
            x120 * x23 + x186 * x27 + x194 * x22 + x200,
            x132 * x23 + x186 * x28 + x203 * x22,
            x138 * x23 + x200 + x206 * x22 + x208 * x26,
            x152 * x23 + x208 * x27 + x211 * x22 + x215,
            x160 * x23 + x208 * x28 + x217 * x22,
            0,
            0,
            0,
            x163 * x23 + x215 + x22 * x220 + x221 * x26,
            x173 * x23 + x22 * x225 + x221 * x27 + x222 * x63 - x223 * x67,
            x175 * x23 + x22 * x227 + x221 * x28,
            0,
            0,
            0,
            0,
            0,
            0,
            x22 * x253
            + x229 * x63
            - x231 * x67
            + x24 * x89
            + x242 * x26
            + x73 * (x243 - x245 + x71 * (x249 - x251 + x66 * (x246 - x248))),
            x120 * x24 + x22 * x256 + x242 * x27 + x266,
            x132 * x24 + x22 * x270 + x242 * x28 + x271,
            x138 * x24 + x22 * x274 + x26 * x278 + x266,
            x152 * x24 + x22 * x281 + x27 * x278 + x287,
            x160 * x24 + x22 * x290 + x278 * x28 + x291,
            x22 * x293 + x26 * x294 + x271,
            x22 * x295 + x27 * x294 + x291,
            x22 * x298 + x28 * x294 + x299,
            x163 * x24 + x22 * x302 + x26 * x303 + x287,
            x173 * x24 + x22 * x307 + x27 * x303 + x304 * x63 - x305 * x67,
            x175 * x24 + x22 * x310 + x28 * x303 + x311,
            x22 * x313 + x26 * x314 + x291,
            x22 * x315 + x27 * x314 + x311,
            x22 * x317 + x28 * x314 + x318,
            x22 * x320 + x26 * x321 + x299,
            x22 * x322 + x27 * x321 + x318,
            x22 * x324 + x246 * x323 - x248 * x323 + x28 * x321,
            x176 * x177 - x178 * x179 + x190 * x23 + x191 * x23 + x26 * x325 + x62,
            x193 * x23 + x194 * x23 + x27 * x325 + x326,
            x202 * x23 + x203 * x23 + x28 * x325,
            x205 * x23 + x206 * x23 + x26 * x327 + x326,
            x210 * x23 + x211 * x23 + x27 * x327 + x328,
            x216 * x23 + x217 * x23 + x28 * x327,
            0,
            0,
            0,
            x219 * x23 + x220 * x23 + x26 * x329 + x328,
            x170
            + x176 * x222
            - x178 * x223
            + x224 * x23
            + x225 * x23
            + x27 * x329
            + x73
            * (
                x155
                + x176 * x212
                - x178 * x213
                + x71
                * (
                    x124
                    + x176 * x195
                    - x178 * x196
                    + x66 * (x176 * x183 - x178 * x188 + x96)
                )
            ),
            x226 * x23 + x227 * x23 + x28 * x329,
            0,
            0,
            0,
            0,
            0,
            0,
            x176 * x229 - x178 * x231 + x190 * x24 + x23 * x253 + x26 * x330,
            x193 * x24 + x23 * x256 + x27 * x330 + x332,
            x202 * x24 + x23 * x270 + x28 * x330 + x333,
            x205 * x24 + x23 * x274 + x26 * x336 + x332,
            x210 * x24 + x23 * x281 + x27 * x336 + x340,
            x216 * x24 + x23 * x290 + x28 * x336 + x341,
            x23 * x293 + x26 * x342 + x333,
            x23 * x295 + x27 * x342 + x341,
            x23 * x298 + x28 * x342 + x343,
            x219 * x24 + x23 * x302 + x26 * x348 + x340,
            x176 * x304
            - x178 * x305
            + x224 * x24
            + x23 * x307
            + x27 * x348
            + x73 * (x176 * x282 - x349 + x71 * (x352 - x353 + x66 * (x350 - x351))),
            x226 * x24 + x23 * x310 + x28 * x348 + x354,
            x23 * x313 + x26 * x355 + x341,
            x23 * x315 + x27 * x355 + x354,
            x23 * x317 + x28 * x355 + x356,
            x23 * x320 + x26 * x357 + x343,
            x23 * x322 + x27 * x357 + x356,
            x23 * x324 + x28 * x357 + x323 * x350 - x323 * x351,
            x228 * x229 - x230 * x231 + x24 * x252 + x24 * x253 + x26 * x358 + x62,
            x24 * x255 + x24 * x256 + x27 * x358 + x359,
            x24 * x269 + x24 * x270 + x28 * x358 + x361,
            x24 * x273 + x24 * x274 + x26 * x362 + x359,
            x24 * x280 + x24 * x281 + x27 * x362 + x363,
            x24 * x289 + x24 * x290 + x28 * x362 + x365,
            x26 * x368 + x293 * x369 + x361,
            x27 * x368 + x295 * x369 + x365,
            x28 * x368 + x298 * x369 + x372,
            x24 * x301 + x24 * x302 + x26 * x373 + x363,
            x170 + x228 * x304 - x230 * x305 + x24 * x306 + x24 * x307 + x27 * x373,
            x24 * x309 + x24 * x310 + x28 * x373 + x375,
            x26 * x378 + x313 * x369 + x365,
            x27 * x378 + x315 * x369 + x375,
            x28 * x378 + x317 * x369 + x381,
            x26 * x384 + x320 * x369 + x372,
            x27 * x384 + x322 * x369 + x381,
            x28 * x384
            + x323 * x385
            - x323 * x386
            + x324 * x369
            + x73
            * (
                x296 * x385
                - x296 * x386
                + x71 * (x385 * x66 - x386 * x66 + x66 * (x385 - x386 + x96))
            ),
        ]
    )
    return S


def eri_0222(a, A, b, B, c, C, d, D):
    """Cartesian [sd|dd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x10 * (x11**2 + x12**2 + x13**2))
    x15 = x6 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x8 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x10 * (a * A[0] + b * B[0])
    x24 = -x22 - x23
    x25 = x15 * (c * C[1] + d * D[1])
    x26 = -x10 * (a * A[1] + b * B[1])
    x27 = -x25 - x26
    x28 = -x10 * (a * A[2] + b * B[2])
    x29 = -x15 * (c * C[2] + d * D[2]) - x28
    x30 = x21 * x7 * (x24**2 + x27**2 + x29**2)
    x31 = boys(2, x30)
    x32 = -2 * x14 * x20 * x31 * x4 * x9
    x33 = x21 * x5
    x34 = boys(3, x30)
    x35 = 2 * x14 * x20 * x4 * x9
    x36 = x34 * x35
    x37 = x3 * (-x32 - x33 * x36)
    x38 = x22 - C[0]
    x39 = x31 * x35
    x40 = x24 * x33
    x41 = x36 * x40 + x38 * x39
    x42 = boys(4, x30)
    x43 = x35 * x42
    x44 = x36 * x38 + x40 * x43
    x45 = x33 * x44
    x46 = x24 * x45 + x37 + x38 * x41
    x47 = x33 * x46
    x48 = boys(1, x30)
    x49 = x3 * (2 * x14 * x20 * x4 * x48 * x9 - x33 * x39)
    x50 = x35 * x48
    x51 = x38 * x50 + x39 * x40
    x52 = x33 * x41
    x53 = x24 * x52 + x38 * x51 + x49
    x54 = 3 * x3
    x55 = 2 * x3
    x56 = x24 * x47 + x38 * x53 + x55 * (x51 - x52)
    x57 = -2 * x14 * x20 * x34 * x4 * x9
    x58 = x3 * (-x33 * x43 - x57)
    x59 = x35 * boys(5, x30)
    x60 = x38 * x43 + x40 * x59
    x61 = x33 * x60
    x62 = x24 * x61 + x38 * x44 + x58
    x63 = x33 * x62
    x64 = x24 * x63 + x38 * x46 + x55 * (x41 - x45)
    x65 = x38 * x56 + x40 * x64 + x54 * (-x47 + x53)
    x66 = x21 * x6
    x67 = x65 * x66
    x68 = x33 * x53
    x69 = boys(0, x30)
    x70 = x3 * (2 * x14 * x20 * x4 * x69 * x9 - x33 * x50)
    x71 = x35 * x69
    x72 = x38 * x71 + x40 * x50
    x73 = x33 * x51
    x74 = x24 * x73 + x38 * x72 + x70
    x75 = x24 * x68 + x38 * x74 + x55 * (x72 - x73)
    x76 = x38 * x75 + x40 * x56 + x54 * (-x68 + x74)
    x77 = x1 * (-x67 + x76)
    x78 = -x23 - A[0]
    x79 = x64 * x66
    x80 = x62 * x66
    x81 = x0 + x2
    x82 = x81 ** (-1.0)
    x83 = x24 * x66
    x84 = x43 * x78 - x59 * x83
    x85 = x60 * x66
    x86 = -x24 * x85 + x44 * x78 + x82 * x84
    x87 = 2 * x82
    x88 = -x24 * x80 + x46 * x78 + x86 * x87
    x89 = 3 * x82
    x90 = -x24 * x79 + x56 * x78 + x88 * x89
    x91 = 4 * x82
    x92 = -x24 * x67 + x76 * x78 + x90 * x91
    x93 = -2 * x14 * x20 * x4 * x42 * x9
    x94 = x3 * (-x33 * x59 - x93)
    x95 = x35 * boys(6, x30)
    x96 = x38 * x59 + x40 * x95
    x97 = x38 * x60 + x40 * x96 + x94
    x98 = x38 * x62 + x40 * x97 + x55 * (x44 - x61)
    x99 = x38 * x64 + x40 * x98 + x54 * (x46 - x63)
    x100 = x59 * x78 - x83 * x95
    x101 = x100 * x82 + x60 * x78 - x83 * x96
    x102 = x101 * x87 + x62 * x78 - x83 * x97
    x103 = x102 * x89 + x64 * x78 - x83 * x98
    x104 = x56 * x66
    x105 = x1 * (-x104 + x75)
    x106 = x46 * x66
    x107 = x36 * x78 - x43 * x83
    x108 = x44 * x66
    x109 = x107 * x82 - x108 * x24 + x41 * x78
    x110 = -x106 * x24 + x109 * x87 + x53 * x78
    x111 = -x104 * x24 + x110 * x89 + x75 * x78
    x112 = x1 * (-x106 + x53)
    x113 = x1 * (-x108 + x41)
    x114 = x1 * (-x43 * x66 - x57)
    x115 = (
        x105
        + x111 * x78
        - x83 * x90
        + x89
        * (
            x110 * x78
            + x112
            - x83 * x88
            + x87
            * (x109 * x78 + x113 + x82 * (x107 * x78 + x114 - x83 * x84) - x83 * x86)
        )
    )
    x116 = x1 * (x56 - x79)
    x117 = x1 * (x46 - x80)
    x118 = x1 * (x44 - x85)
    x119 = x1 * (-x59 * x66 - x93)
    x120 = x53 * x66
    x121 = -x36 * x83 + x39 * x78
    x122 = x41 * x66
    x123 = x121 * x82 - x122 * x24 + x51 * x78
    x124 = -x120 * x24 + x123 * x87 + x74 * x78
    x125 = x124 * x16
    x126 = x111 * x16 + x16 * (x111 + x125) + x92
    x127 = x1 * (-x120 + x74)
    x128 = x1 * (-x122 + x51)
    x129 = x1 * (-x32 - x36 * x66)
    x130 = (
        -x110 * x83
        + x124 * x78
        + x127
        + x87
        * (-x109 * x83 + x123 * x78 + x128 + x82 * (-x107 * x83 + x121 * x78 + x129))
    )
    x131 = x130 * x16
    x132 = x16 * x74
    x133 = x16 * x75 + x16 * (x132 + x75) + x76
    x134 = x124 * x17
    x135 = x25 - C[1]
    x136 = x27 * x33
    x137 = x135 * x50 + x136 * x39
    x138 = x137 * x33
    x139 = x135 * x71 + x136 * x50
    x140 = x3 * (-x138 + x139)
    x141 = x138 * x24 + x139 * x38
    x142 = x135 * x39 + x136 * x36
    x143 = x142 * x33
    x144 = x137 * x38 + x143 * x24
    x145 = x144 * x33
    x146 = x140 + x141 * x38 + x145 * x24
    x147 = x3 * (x137 - x143)
    x148 = x135 * x36 + x136 * x43
    x149 = x148 * x33
    x150 = x142 * x38 + x149 * x24
    x151 = x150 * x33
    x152 = x144 * x38 + x147 + x151 * x24
    x153 = x152 * x66
    x154 = x148 * x66
    x155 = x142 * x78 - x154 * x24
    x156 = x150 * x66
    x157 = x144 * x78 + x155 * x82 - x156 * x24
    x158 = x146 * x78 - x153 * x24 + x157 * x87
    x159 = x134 + x158
    x160 = x146 * x38 + x152 * x40 + x55 * (x141 - x145)
    x161 = x3 * (x142 - x149)
    x162 = x135 * x43 + x136 * x59
    x163 = x162 * x33
    x164 = x148 * x38 + x163 * x24
    x165 = x164 * x33
    x166 = x150 * x38 + x161 + x165 * x24
    x167 = x152 * x38 + x166 * x40 + x55 * (x144 - x151)
    x168 = x167 * x66
    x169 = x166 * x66
    x170 = x162 * x66
    x171 = x148 * x78 - x170 * x24
    x172 = x164 * x66
    x173 = x150 * x78 + x171 * x82 - x172 * x24
    x174 = x152 * x78 - x169 * x24 + x173 * x87
    x175 = x160 * x78 - x168 * x24 + x174 * x89
    x176 = x111 * x17 + x159 * x16 + x175
    x177 = x17 * x74
    x178 = x146 + x177
    x179 = x16 * x178 + x160 + x17 * x75
    x180 = x130 * x17
    x181 = x1 * (x146 - x153)
    x182 = x1 * (x144 - x156)
    x183 = x1 * (x142 - x154)
    x184 = (
        x158 * x78
        - x174 * x83
        + x181
        + x87 * (x157 * x78 - x173 * x83 + x182 + x82 * (x155 * x78 - x171 * x83 + x183))
    )
    x185 = x180 + x184
    x186 = x1 * (x160 - x168)
    x187 = x1 * (x152 - x169)
    x188 = x3 * (x148 - x163)
    x189 = x135 * x59 + x136 * x95
    x190 = x162 * x38 + x189 * x40
    x191 = x164 * x38 + x188 + x190 * x40
    x192 = x162 * x78 - x189 * x83
    x193 = x164 * x78 - x190 * x83 + x192 * x82
    x194 = x166 * x78 - x191 * x83 + x193 * x87
    x195 = x1 * (x150 - x172)
    x196 = x1 * (x148 - x170)
    x197 = x166 * x38 + x191 * x40 + x55 * (x150 - x165)
    x198 = (
        x175 * x78
        + x186
        - x83 * (x167 * x78 + x194 * x89 - x197 * x83)
        + x89
        * (
            x174 * x78
            + x187
            - x194 * x83
            + x87
            * (x173 * x78 - x193 * x83 + x195 + x82 * (x171 * x78 - x192 * x83 + x196))
        )
    )
    x199 = x111 * x18 + x125 * x18
    x200 = x132 * x18 + x18 * x75
    x201 = x135 * x137 + x143 * x27 + x49
    x202 = x201 * x33
    x203 = x135 * x139 + x138 * x27 + x70
    x204 = x3 * (-x202 + x203)
    x205 = x202 * x24 + x203 * x38
    x206 = x135 * x142 + x149 * x27 + x37
    x207 = x206 * x33
    x208 = x201 * x38 + x207 * x24
    x209 = x204 + x205 * x38 + x208 * x40
    x210 = x3 * (x201 - x207)
    x211 = x135 * x148 + x163 * x27 + x58
    x212 = x211 * x33
    x213 = x206 * x38 + x212 * x24
    x214 = x208 * x38 + x210 + x213 * x40
    x215 = x214 * x66
    x216 = x211 * x66
    x217 = x206 * x78 - x216 * x24
    x218 = x213 * x66
    x219 = x208 * x78 + x217 * x82 - x218 * x24
    x220 = x209 * x78 - x215 * x24 + x219 * x87
    x221 = x158 * x17 + x220
    x222 = x159 * x17 + x221
    x223 = x146 * x17 + x209
    x224 = x17 * x178 + x223
    x225 = x1 * (x209 - x215)
    x226 = x1 * (x208 - x218)
    x227 = x1 * (x206 - x216)
    x228 = x135 * x162 + x136 * x189 + x94
    x229 = x211 * x78 - x228 * x83
    x230 = x211 * x38 + x228 * x40
    x231 = x213 * x78 + x229 * x82 - x230 * x83
    x232 = x3 * (x206 - x212)
    x233 = x213 * x38 + x230 * x40 + x232
    x234 = (
        x220 * x78
        + x225
        - x83 * (x214 * x78 + x231 * x87 - x233 * x83)
        + x87 * (x219 * x78 + x226 - x231 * x83 + x82 * (x217 * x78 + x227 - x229 * x83))
    )
    x235 = x17 * x184 + x234
    x236 = x158 * x18
    x237 = x134 * x18 + x236
    x238 = x146 * x18
    x239 = x177 * x18 + x238
    x240 = x18 * x184
    x241 = x124 * x19
    x242 = x11 * x19
    x243 = x142 * x66
    x244 = x137 * x78 - x24 * x243
    x245 = x144 * x66
    x246 = x141 * x78 - x24 * x245 + x244 * x82
    x247 = x16 * x246
    x248 = x158 * x16 + x16 * (x158 + x247) + x175
    x249 = x141 * x16
    x250 = x146 * x16 + x16 * (x146 + x249) + x160
    x251 = x1 * (x141 - x245)
    x252 = x1 * (x137 - x243)
    x253 = -x157 * x83 + x246 * x78 + x251 + x82 * (-x155 * x83 + x244 * x78 + x252)
    x254 = x16 * x253
    x255 = x17 * x246
    x256 = x206 * x66
    x257 = x201 * x78 - x24 * x256
    x258 = x208 * x66
    x259 = x205 * x78 - x24 * x258 + x257 * x82
    x260 = x255 + x259
    x261 = x16 * x260 + x221
    x262 = x141 * x17
    x263 = x205 + x262
    x264 = x16 * x263 + x223
    x265 = x17 * x253
    x266 = x1 * (x205 - x258)
    x267 = x1 * (x201 - x256)
    x268 = -x219 * x83 + x259 * x78 + x266 + x82 * (-x217 * x83 + x257 * x78 + x267)
    x269 = x265 + x268
    x270 = x18 * x247 + x236
    x271 = x18 * x249 + x238
    x272 = x135 * x201 + 2 * x147 + x207 * x27
    x273 = x135 * x206 + 2 * x161 + x212 * x27
    x274 = x273 * x66
    x275 = -x24 * x274 + x272 * x78
    x276 = x135 * x203 + 2 * x140 + x202 * x27
    x277 = x272 * x40 + x276 * x38
    x278 = x272 * x38 + x273 * x40
    x279 = x278 * x66
    x280 = -x24 * x279 + x275 * x82 + x277 * x78
    x281 = x17 * x259 + x280
    x282 = x17 * x260 + x281
    x283 = x17 * x205 + x277
    x284 = x17 * x263 + x283
    x285 = x1 * (x277 - x279)
    x286 = x1 * (x272 - x274)
    x287 = x135 * x211 + x136 * x228 + 2 * x188
    x288 = x273 * x78 - x287 * x83
    x289 = x273 * x38 + x287 * x40
    x290 = (
        x17 * x268
        + x280 * x78
        + x285
        + x82 * (x275 * x78 + x286 - x288 * x83)
        - x83 * (x278 * x78 + x288 * x82 - x289 * x83)
    )
    x291 = x18 * x259
    x292 = x18 * x255 + x291
    x293 = x18 * x205
    x294 = x18 * x262 + x293
    x295 = x18 * x268
    x296 = x19 * x246
    x297 = x201 * x66
    x298 = x203 * x78 - x24 * x297
    x299 = x16 * x298
    x300 = x16 * x259 + x16 * (x259 + x299) + x220
    x301 = x16 * x203
    x302 = x16 * x205 + x16 * (x205 + x301) + x209
    x303 = x1 * (x203 - x297)
    x304 = -x257 * x83 + x298 * x78 + x303
    x305 = x16 * x304
    x306 = x17 * x298
    x307 = x272 * x66
    x308 = -x24 * x307 + x276 * x78
    x309 = x306 + x308
    x310 = x16 * x309 + x281
    x311 = x17 * x203
    x312 = x276 + x311
    x313 = x16 * x312 + x283
    x314 = x17 * x304
    x315 = x1 * (x276 - x307)
    x316 = -x275 * x83 + x308 * x78 + x315
    x317 = x314 + x316
    x318 = x18 * x299 + x291
    x319 = x18 * x301 + x293
    x320 = x135 * x272 + x136 * x273 + 3 * x210
    x321 = x320 * x66
    x322 = x135 * x276 + x136 * x272 + 3 * x204
    x323 = x1 * (-x321 + x322)
    x324 = -x24 * x321 + x322 * x78
    x325 = x135 * x273 + x136 * x287 + 3 * x232
    x326 = x17 * x308 + x17 * x309 + x324
    x327 = x17 * x276 + x17 * x312 + x322
    x328 = x18 * x306 + x18 * x308
    x329 = x18 * x276 + x18 * x311
    x330 = x19 * x298
    x331 = -x26 - A[1]
    x332 = -x27 * x67 + x331 * x76
    x333 = x27 * x66
    x334 = x331 * x65 - x333 * x99
    x335 = -x104 * x27 + x331 * x75
    x336 = -x27 * x79 + x331 * x56
    x337 = -x106 * x27 + x331 * x53
    x338 = -x27 * x80 + x331 * x46
    x339 = x331 * x36 - x333 * x43
    x340 = x331 * x43 - x333 * x59
    x341 = -x108 * x27 + x331 * x41
    x342 = -x27 * x85 + x331 * x44
    x343 = (
        x335 * x78
        - x336 * x83
        + x89
        * (
            x337 * x78
            - x338 * x83
            + x87 * (x341 * x78 - x342 * x83 + x82 * (x339 * x78 - x340 * x83))
        )
    )
    x344 = x331 * x64 - x333 * x98
    x345 = x331 * x62 - x333 * x97
    x346 = x331 * x59 - x333 * x95
    x347 = x331 * x60 - x333 * x96
    x348 = -x120 * x27 + x331 * x74
    x349 = x331 * x39 - x333 * x36
    x350 = -x122 * x27 + x331 * x51
    x351 = (
        -x337 * x83
        + x348 * x78
        + x87 * (-x341 * x83 + x350 * x78 + x82 * (-x339 * x83 + x349 * x78))
    )
    x352 = x16 * x351
    x353 = x16 * x348
    x354 = x16 * x335 + x16 * (x335 + x353) + x332
    x355 = x12 * x133 + x354
    x356 = x17 * x348
    x357 = x146 * x331 - x153 * x27 + x337 * x82
    x358 = x356 + x357
    x359 = x160 * x331 - x168 * x27 + x336 * x82
    x360 = x16 * x358 + x17 * x335 + x359
    x361 = x12 * x179 + x360
    x362 = x17 * x351
    x363 = x152 * x331 - x169 * x27 + x338 * x82
    x364 = x142 * x331 - x154 * x27 + x339 * x82
    x365 = x148 * x331 - x170 * x27 + x340 * x82
    x366 = x144 * x331 - x156 * x27 + x341 * x82
    x367 = x150 * x331 - x172 * x27 + x342 * x82
    x368 = (
        x357 * x78
        - x363 * x83
        + x87 * (x366 * x78 - x367 * x83 + x82 * (x364 * x78 - x365 * x83))
    )
    x369 = x362 + x368
    x370 = x166 * x331 - x191 * x333 + x345 * x82
    x371 = x162 * x331 - x189 * x333 + x346 * x82
    x372 = x164 * x331 - x190 * x333 + x347 * x82
    x373 = x167 * x331 - x197 * x333 + x344 * x82
    x374 = (
        x359 * x78
        - x373 * x83
        + x89
        * (
            x363 * x78
            - x370 * x83
            + x87 * (x367 * x78 - x372 * x83 + x82 * (x365 * x78 - x371 * x83))
        )
    )
    x375 = x18 * x335 + x18 * x353
    x376 = x12 * x200 + x375
    x377 = x209 * x331 - x215 * x27 + x363 * x87
    x378 = x17 * x357 + x377
    x379 = x17 * x358 + x378
    x380 = x12 * x224 + x379
    x381 = x206 * x331 - x216 * x27 + x365 * x87
    x382 = x211 * x331 - x228 * x333 + x371 * x87
    x383 = x208 * x331 - x218 * x27 + x367 * x87
    x384 = x213 * x331 - x230 * x333 + x372 * x87
    x385 = x214 * x331 - x233 * x333 + x370 * x87
    x386 = (
        x377 * x78
        - x385 * x83
        + x87 * (x383 * x78 - x384 * x83 + x82 * (x381 * x78 - x382 * x83))
    )
    x387 = x17 * x368 + x386
    x388 = x18 * x357
    x389 = x18 * x356 + x388
    x390 = x12 * x239 + x389
    x391 = x18 * x368
    x392 = x12 * x19
    x393 = x19 * x348
    x394 = x392 * x74 + x393
    x395 = x141 * x331 - x245 * x27 + x350 * x82
    x396 = x16 * x395
    x397 = x16 * x357 + x16 * (x357 + x396) + x359
    x398 = x12 * x250 + x397
    x399 = x137 * x331 - x243 * x27 + x349 * x82
    x400 = -x366 * x83 + x395 * x78 + x82 * (-x364 * x83 + x399 * x78)
    x401 = x16 * x400
    x402 = x17 * x395
    x403 = x205 * x331 - x258 * x27 + x366 * x87
    x404 = x402 + x403
    x405 = x16 * x404 + x378
    x406 = x12 * x264 + x405
    x407 = x17 * x400
    x408 = x201 * x331 - x256 * x27 + x364 * x87
    x409 = -x383 * x83 + x403 * x78 + x82 * (-x381 * x83 + x408 * x78)
    x410 = x407 + x409
    x411 = x18 * x396 + x388
    x412 = x12 * x271 + x411
    x413 = -x27 * x279 + x277 * x331 + x383 * x89
    x414 = x17 * x403 + x413
    x415 = x17 * x404 + x414
    x416 = x12 * x284 + x415
    x417 = -x27 * x274 + x272 * x331 + x381 * x89
    x418 = x273 * x331 - x287 * x333 + x382 * x89
    x419 = x278 * x331 - x289 * x333 + x384 * x89
    x420 = x17 * x409 + x413 * x78 - x419 * x83 + x82 * (x417 * x78 - x418 * x83)
    x421 = x18 * x403
    x422 = x18 * x402 + x421
    x423 = x12 * x294 + x422
    x424 = x18 * x409
    x425 = x19 * x395
    x426 = x141 * x392 + x425
    x427 = x203 * x331 - x27 * x297 + x399 * x87
    x428 = x16 * x427
    x429 = x16 * x403 + x16 * (x403 + x428) + x377
    x430 = x12 * x302 + x429
    x431 = -x408 * x83 + x427 * x78
    x432 = x16 * x431
    x433 = x17 * x427
    x434 = -x27 * x307 + x276 * x331 + x408 * x89
    x435 = x433 + x434
    x436 = x16 * x435 + x414
    x437 = x12 * x313 + x436
    x438 = x17 * x431
    x439 = -x417 * x83 + x434 * x78
    x440 = x438 + x439
    x441 = x18 * x428 + x421
    x442 = x12 * x319 + x441
    x443 = -x27 * x321 + x322 * x331 + x417 * x91
    x444 = x320 * x331 - x325 * x333 + x418 * x91
    x445 = x17 * x434 + x17 * x435 + x443
    x446 = x12 * x327 + x445
    x447 = x18 * x433 + x18 * x434
    x448 = x12 * x329 + x447
    x449 = x19 * x427
    x450 = x203 * x392 + x449
    x451 = -x28 - A[2]
    x452 = -x29 * x67 + x451 * x76
    x453 = x29 * x66
    x454 = x451 * x65 - x453 * x99
    x455 = -x104 * x29 + x451 * x75
    x456 = -x29 * x79 + x451 * x56
    x457 = -x106 * x29 + x451 * x53
    x458 = x457 * x78
    x459 = -x29 * x80 + x451 * x46
    x460 = x459 * x83
    x461 = x36 * x451 - x43 * x453
    x462 = x461 * x78
    x463 = x43 * x451 - x453 * x59
    x464 = x463 * x83
    x465 = -x108 * x29 + x41 * x451
    x466 = x465 * x78
    x467 = -x29 * x85 + x44 * x451
    x468 = x467 * x83
    x469 = (
        x455 * x78
        - x456 * x83
        + x89 * (x458 - x460 + x87 * (x466 - x468 + x82 * (x462 - x464)))
    )
    x470 = x456 * x78
    x471 = x451 * x64 - x453 * x98
    x472 = x471 * x83
    x473 = x459 * x78
    x474 = x451 * x62 - x453 * x97
    x475 = x474 * x83
    x476 = x463 * x78
    x477 = x451 * x59 - x453 * x95
    x478 = x477 * x83
    x479 = x467 * x78
    x480 = x451 * x60 - x453 * x96
    x481 = x480 * x83
    x482 = -x120 * x29 + x451 * x74
    x483 = -x36 * x453 + x39 * x451
    x484 = x483 * x78
    x485 = x461 * x83
    x486 = -x122 * x29 + x451 * x51
    x487 = x486 * x78
    x488 = x465 * x83
    x489 = -x457 * x83 + x482 * x78 + x87 * (x487 - x488 + x82 * (x484 - x485))
    x490 = x16 * x455 + x16 * (x16 * x482 + x455) + x452
    x491 = x13 * x133 + x490
    x492 = x146 * x451 - x153 * x29
    x493 = x17 * x482 + x492
    x494 = x160 * x451 - x168 * x29
    x495 = x16 * x493 + x17 * x455 + x494
    x496 = x13 * x179 + x495
    x497 = x152 * x451 - x169 * x29
    x498 = x144 * x451 - x156 * x29
    x499 = x498 * x78
    x500 = x142 * x451 - x154 * x29
    x501 = x500 * x78
    x502 = x148 * x451 - x170 * x29
    x503 = x502 * x83
    x504 = x150 * x451 - x172 * x29
    x505 = x504 * x83
    x506 = x492 * x78 - x497 * x83 + x87 * (x499 - x505 + x82 * (x501 - x503))
    x507 = x17 * x489 + x506
    x508 = x497 * x78
    x509 = x166 * x451 - x191 * x453
    x510 = x509 * x83
    x511 = x504 * x78
    x512 = x502 * x78
    x513 = x162 * x451 - x189 * x453
    x514 = x513 * x83
    x515 = x164 * x451 - x190 * x453
    x516 = x515 * x83
    x517 = x167 * x451 - x197 * x453
    x518 = (
        x494 * x78
        - x517 * x83
        + x89 * (x508 - x510 + x87 * (x511 - x516 + x82 * (x512 - x514)))
    )
    x519 = x457 * x82
    x520 = x18 * x482 + x519
    x521 = x456 * x82
    x522 = x16 * x520 + x18 * x455 + x521
    x523 = x13 * x200 + x522
    x524 = (
        x458 * x82
        - x460 * x82
        + x87 * (x466 * x82 - x468 * x82 + x82 * (x462 * x82 - x464 * x82))
    )
    x525 = x18 * x489 + x524
    x526 = (
        x470 * x82
        - x472 * x82
        + x89
        * (
            x473 * x82
            - x475 * x82
            + x87 * (x479 * x82 - x481 * x82 + x82 * (x476 * x82 - x478 * x82))
        )
    )
    x527 = x209 * x451 - x215 * x29
    x528 = x17 * x492 + x527
    x529 = x17 * x493 + x528
    x530 = x13 * x224 + x529
    x531 = x208 * x451 - x218 * x29
    x532 = x531 * x78
    x533 = x206 * x451 - x216 * x29
    x534 = x533 * x78
    x535 = x211 * x451 - x228 * x453
    x536 = x535 * x83
    x537 = x213 * x451 - x230 * x453
    x538 = x537 * x83
    x539 = x214 * x451 - x233 * x453
    x540 = x527 * x78 - x539 * x83 + x87 * (x532 - x538 + x82 * (x534 - x536))
    x541 = x17 * x506 + x540
    x542 = x497 * x82
    x543 = x18 * x492 + x542
    x544 = x17 * x520 + x543
    x545 = x13 * x239 + x544
    x546 = (
        x508 * x82
        - x510 * x82
        + x87 * (x511 * x82 - x516 * x82 + x82 * (x512 * x82 - x514 * x82))
    )
    x547 = x18 * x506 + x546
    x548 = x13 * x19
    x549 = 2 / x81**2
    x550 = x459 * x549
    x551 = x18 * x519 + x550
    x552 = x18 * x520 + x551
    x553 = x548 * x74 + x552
    x554 = (
        x473 * x549
        - x475 * x549
        + x87 * (x479 * x549 - x481 * x549 + x82 * (x476 * x549 - x478 * x549))
    )
    x555 = x18 * x524 + x554
    x556 = x141 * x451 - x245 * x29
    x557 = x16 * x492 + x16 * (x16 * x556 + x492) + x494
    x558 = x13 * x250 + x557
    x559 = x137 * x451 - x243 * x29
    x560 = x559 * x78
    x561 = x500 * x83
    x562 = -x498 * x83 + x556 * x78 + x82 * (x560 - x561)
    x563 = x205 * x451 - x258 * x29
    x564 = x17 * x556 + x563
    x565 = x16 * x564 + x528
    x566 = x13 * x264 + x565
    x567 = x201 * x451 - x256 * x29
    x568 = x567 * x78
    x569 = x533 * x83
    x570 = -x531 * x83 + x563 * x78 + x82 * (x568 - x569)
    x571 = x17 * x562 + x570
    x572 = x498 * x82
    x573 = x18 * x556 + x572
    x574 = x16 * x573 + x543
    x575 = x13 * x271 + x574
    x576 = x499 * x82 - x505 * x82 + x82 * (x501 * x82 - x503 * x82)
    x577 = x18 * x562 + x576
    x578 = x277 * x451 - x279 * x29
    x579 = x17 * x563 + x578
    x580 = x17 * x564 + x579
    x581 = x13 * x284 + x580
    x582 = x272 * x451 - x274 * x29
    x583 = x582 * x78
    x584 = x273 * x451 - x287 * x453
    x585 = x584 * x83
    x586 = x278 * x451 - x289 * x453
    x587 = x17 * x570 + x578 * x78 - x586 * x83 + x82 * (x583 - x585)
    x588 = x531 * x82
    x589 = x18 * x563 + x588
    x590 = x17 * x573 + x589
    x591 = x13 * x294 + x590
    x592 = x532 * x82 - x538 * x82 + x82 * (x534 * x82 - x536 * x82)
    x593 = x18 * x570 + x592
    x594 = x504 * x549
    x595 = x18 * x572 + x594
    x596 = x18 * x573 + x595
    x597 = x141 * x548 + x596
    x598 = x511 * x549 - x516 * x549 + x82 * (x512 * x549 - x514 * x549)
    x599 = x18 * x576 + x598
    x600 = x486 * x82
    x601 = x16 * x519 + x16 * (x16 * x600 + x519) + x521
    x602 = x487 * x82 - x488 * x82 + x82 * (x484 * x82 - x485 * x82)
    x603 = x17 * x600 + x572
    x604 = x16 * x603 + x17 * x519 + x542
    x605 = x17 * x602 + x576
    x606 = x465 * x549
    x607 = x18 * x600 + x606
    x608 = x16 * x607 + x551
    x609 = x466 * x549 - x468 * x549 + x82 * (x462 * x549 - x464 * x549)
    x610 = x18 * x602 + x609
    x611 = x17 * x572 + x588
    x612 = x17 * x603 + x611
    x613 = x17 * x576 + x592
    x614 = x17 * x607 + x595
    x615 = 6 / x81**3
    x616 = x18 * x606 + x467 * x615
    x617 = x18 * x607 + x616
    x618 = x18 * x609 + x479 * x615 - x481 * x615 + x82 * (x476 * x615 - x478 * x615)
    x619 = x203 * x451 - x29 * x297
    x620 = x16 * x563 + x16 * (x16 * x619 + x563) + x527
    x621 = x13 * x302 + x620
    x622 = -x567 * x83 + x619 * x78
    x623 = x276 * x451 - x29 * x307
    x624 = x17 * x619 + x623
    x625 = x16 * x624 + x579
    x626 = x13 * x313 + x625
    x627 = -x582 * x83 + x623 * x78
    x628 = x17 * x622 + x627
    x629 = x567 * x82
    x630 = x18 * x619 + x629
    x631 = x16 * x630 + x589
    x632 = x13 * x319 + x631
    x633 = x568 * x82 - x569 * x82
    x634 = x18 * x622 + x633
    x635 = -x29 * x321 + x322 * x451
    x636 = x320 * x451 - x325 * x453
    x637 = x17 * x623 + x17 * x624 + x635
    x638 = x13 * x327 + x637
    x639 = x582 * x82
    x640 = x17 * x630 + x18 * x623 + x639
    x641 = x13 * x329 + x640
    x642 = x583 * x82 - x585 * x82
    x643 = x533 * x549
    x644 = x18 * x629 + x643
    x645 = x18 * x630 + x644
    x646 = x203 * x548 + x645
    x647 = x534 * x549 - x536 * x549
    x648 = x18 * x633 + x647
    x649 = x559 * x82
    x650 = x16 * x572 + x16 * (x16 * x649 + x572) + x542
    x651 = x560 * x82 - x561 * x82
    x652 = x17 * x649 + x629
    x653 = x16 * x652 + x611
    x654 = x17 * x651 + x633
    x655 = x500 * x549
    x656 = x18 * x649 + x655
    x657 = x16 * x656 + x595
    x658 = x501 * x549 - x503 * x549
    x659 = x18 * x651 + x658
    x660 = x17 * x629 + x17 * x652 + x639
    x661 = x17 * x656 + x644
    x662 = x18 * x655 + x502 * x615
    x663 = x18 * x656 + x662
    x664 = x18 * x658 + x512 * x615 - x514 * x615
    x665 = x483 * x549
    x666 = x16 * x606 + x16 * (x16 * x665 + x606) + x550
    x667 = x484 * x549 - x485 * x549
    x668 = x17 * x665 + x655
    x669 = x16 * x668 + x17 * x606 + x594
    x670 = x17 * x667 + x658
    x671 = x461 * x615
    x672 = x18 * x665 + x671
    x673 = x16 * x672 + x616
    x674 = x462 * x615 - x464 * x615
    x675 = x18 * x667 + x674
    x676 = x17 * x655 + x17 * x668 + x643
    x677 = x17 * x672 + x662
    x678 = 24 / x81**4
    x679 = x18 * x671 + x18 * x672 + x463 * x678
    x680 = x105 + x331 * x335 - x333 * x336
    x681 = x127 + x331 * x348 - x333 * x337
    x682 = x16 * x681
    x683 = x17 * x681
    x684 = x181 + x331 * x357 - x333 * x363 + x82 * (x112 + x331 * x337 - x333 * x338)
    x685 = x683 + x684
    x686 = x186 + x331 * x359 - x333 * x373 + x82 * (x116 + x331 * x336 - x333 * x344)
    x687 = (
        x225
        + x331 * x377
        - x333 * x385
        + x87
        * (x187 + x331 * x363 - x333 * x370 + x82 * (x117 + x331 * x338 - x333 * x345))
    )
    x688 = x17 * x684 + x687
    x689 = x18 * x684
    x690 = x251 + x331 * x395 - x333 * x366 + x82 * (x128 + x331 * x350 - x333 * x341)
    x691 = x16 * x690
    x692 = x17 * x690
    x693 = (
        x266
        + x331 * x403
        - x333 * x383
        + x87
        * (x182 + x331 * x366 - x333 * x367 + x82 * (x113 + x331 * x341 - x333 * x342))
    )
    x694 = x692 + x693
    x695 = (
        x17 * x693
        + x285
        + x331 * x413
        - x333 * x419
        + x89
        * (
            x226
            + x331 * x383
            - x333 * x384
            + x87
            * (
                x195
                + x331 * x367
                - x333 * x372
                + x82 * (x118 + x331 * x342 - x333 * x347)
            )
        )
    )
    x696 = x18 * x693
    x697 = (
        x303
        + x331 * x427
        - x333 * x408
        + x87
        * (x252 + x331 * x399 - x333 * x364 + x82 * (x129 + x331 * x349 - x333 * x339))
    )
    x698 = x16 * x697
    x699 = x17 * x697
    x700 = (
        x315
        + x331 * x434
        - x333 * x417
        + x89
        * (
            x267
            + x331 * x408
            - x333 * x381
            + x87
            * (
                x183
                + x331 * x364
                - x333 * x365
                + x82 * (x114 + x331 * x339 - x333 * x340)
            )
        )
    )
    x701 = x699 + x700
    x702 = x331 * x455 - x333 * x456
    x703 = x331 * x482 - x333 * x457
    x704 = x333 * x459
    x705 = x331 * x492 - x333 * x497 + x82 * (x331 * x457 - x704)
    x706 = x17 * x703 + x705
    x707 = x333 * x471
    x708 = x331 * x494 - x333 * x517 + x82 * (x331 * x456 - x707)
    x709 = x331 * x519 - x704 * x82
    x710 = x18 * x703 + x709
    x711 = x331 * x521 - x707 * x82
    x712 = x331 * x459
    x713 = x333 * x474
    x714 = x333 * x509
    x715 = x331 * x527 - x333 * x539 + x87 * (x331 * x497 - x714 + x82 * (x712 - x713))
    x716 = x17 * x705 + x715
    x717 = x331 * x542 - x714 * x82 + x82 * (x712 * x82 - x713 * x82)
    x718 = x18 * x705 + x717
    x719 = x549 * x712 - x549 * x713
    x720 = x18 * x709 + x719
    x721 = x331 * x486
    x722 = x333 * x465
    x723 = x331 * x556 - x333 * x498 + x82 * (x721 - x722)
    x724 = x331 * x465
    x725 = x333 * x467
    x726 = x333 * x504
    x727 = x331 * x563 - x333 * x531 + x87 * (x331 * x498 - x726 + x82 * (x724 - x725))
    x728 = x17 * x723 + x727
    x729 = x331 * x572 - x726 * x82 + x82 * (x724 * x82 - x725 * x82)
    x730 = x18 * x723 + x729
    x731 = x333 * x537
    x732 = x331 * x504
    x733 = x331 * x467
    x734 = x333 * x480
    x735 = x333 * x515
    x736 = (
        x17 * x727
        + x331 * x578
        - x333 * x586
        + x89 * (x331 * x531 - x731 + x87 * (x732 - x735 + x82 * (x733 - x734)))
    )
    x737 = (
        x331 * x588
        - x731 * x82
        + x87 * (x732 * x82 - x735 * x82 + x82 * (x733 * x82 - x734 * x82))
    )
    x738 = x18 * x727 + x737
    x739 = x549 * x732 - x549 * x735 + x82 * (x549 * x733 - x549 * x734)
    x740 = x18 * x729 + x739
    x741 = x721 * x82 - x722 * x82
    x742 = x17 * x741 + x729
    x743 = x549 * x724 - x549 * x725
    x744 = x18 * x741 + x743
    x745 = x17 * x729 + x737
    x746 = x18 * x743 + x615 * x733 - x615 * x734
    x747 = x331 * x483
    x748 = x333 * x461
    x749 = x331 * x559
    x750 = x333 * x500
    x751 = x331 * x619 - x333 * x567 + x87 * (x749 - x750 + x82 * (x747 - x748))
    x752 = x333 * x533
    x753 = x331 * x461
    x754 = x333 * x463
    x755 = x331 * x500
    x756 = x333 * x502
    x757 = (
        x331 * x623
        - x333 * x582
        + x89 * (x331 * x567 - x752 + x87 * (x755 - x756 + x82 * (x753 - x754)))
    )
    x758 = x17 * x751 + x757
    x759 = (
        x331 * x629
        - x752 * x82
        + x87 * (x755 * x82 - x756 * x82 + x82 * (x753 * x82 - x754 * x82))
    )
    x760 = x18 * x751 + x759
    x761 = x333 * x584
    x762 = x331 * x533
    x763 = x333 * x535
    x764 = x331 * x463
    x765 = x333 * x477
    x766 = x331 * x502
    x767 = x333 * x513
    x768 = (
        x331 * x639
        - x761 * x82
        + x89
        * (
            x762 * x82
            - x763 * x82
            + x87 * (x766 * x82 - x767 * x82 + x82 * (x764 * x82 - x765 * x82))
        )
    )
    x769 = (
        x549 * x762
        - x549 * x763
        + x87 * (x549 * x766 - x549 * x767 + x82 * (x549 * x764 - x549 * x765))
    )
    x770 = x18 * x759 + x769
    x771 = x749 * x82 - x750 * x82 + x82 * (x747 * x82 - x748 * x82)
    x772 = x17 * x771 + x759
    x773 = x549 * x755 - x549 * x756 + x82 * (x549 * x753 - x549 * x754)
    x774 = x18 * x771 + x773
    x775 = x18 * x773 + x615 * x766 - x615 * x767 + x82 * (x615 * x764 - x615 * x765)
    x776 = x549 * x747 - x549 * x748
    x777 = x17 * x776 + x773
    x778 = x615 * x753 - x615 * x754
    x779 = x18 * x776 + x778
    x780 = x105 + x451 * x455 - x453 * x456
    x781 = x127 + x451 * x482 - x453 * x457
    x782 = x181 + x451 * x492 - x453 * x497
    x783 = x17 * x781 + x782
    x784 = x186 + x451 * x494 - x453 * x517
    x785 = x453 * x459
    x786 = x451 * x519 - x785 * x82 + x82 * (x112 + x451 * x457 - x785)
    x787 = x18 * x781 + x786
    x788 = x453 * x471
    x789 = x451 * x521 - x788 * x82 + x82 * (x116 + x451 * x456 - x788)
    x790 = x225 + x451 * x527 - x453 * x539
    x791 = x17 * x782 + x790
    x792 = x453 * x509
    x793 = x451 * x542 - x792 * x82 + x82 * (x187 + x451 * x497 - x792)
    x794 = x18 * x782 + x793
    x795 = x451 * x459
    x796 = x453 * x474
    x797 = (
        x549 * x795
        - x549 * x796
        + x87 * (x795 * x82 - x796 * x82 + x82 * (x117 + x795 - x796))
    )
    x798 = x18 * x786 + x797
    x799 = x251 + x451 * x556 - x453 * x498
    x800 = x266 + x451 * x563 - x453 * x531
    x801 = x17 * x799 + x800
    x802 = x453 * x504
    x803 = x451 * x572 - x802 * x82 + x82 * (x182 + x451 * x498 - x802)
    x804 = x18 * x799 + x803
    x805 = x17 * x800 + x285 + x451 * x578 - x453 * x586
    x806 = x453 * x537
    x807 = x451 * x588 - x806 * x82 + x82 * (x226 + x451 * x531 - x806)
    x808 = x18 * x800 + x807
    x809 = x451 * x504
    x810 = x453 * x515
    x811 = (
        x549 * x809
        - x549 * x810
        + x87 * (x809 * x82 - x810 * x82 + x82 * (x195 + x809 - x810))
    )
    x812 = x18 * x803 + x811
    x813 = x451 * x486
    x814 = x453 * x465
    x815 = x813 * x82 - x814 * x82 + x82 * (x128 + x813 - x814)
    x816 = 2 * x13
    x817 = x17 * x815 + x803
    x818 = x451 * x465
    x819 = x453 * x467
    x820 = (
        x549 * x818
        - x549 * x819
        + x87 * (x818 * x82 - x819 * x82 + x82 * (x113 + x818 - x819))
    )
    x821 = x18 * x815 + x820
    x822 = x17 * x803 + x807
    x823 = x451 * x467
    x824 = x453 * x480
    x825 = (
        x18 * x820
        + x615 * x823
        - x615 * x824
        + x89
        * (
            x549 * x823
            - x549 * x824
            + x87 * (x82 * x823 - x82 * x824 + x82 * (x118 + x823 - x824))
        )
    )
    x826 = x303 + x451 * x619 - x453 * x567
    x827 = x315 + x451 * x623 - x453 * x582
    x828 = x17 * x826 + x827
    x829 = x453 * x533
    x830 = x451 * x629 - x82 * x829 + x82 * (x267 + x451 * x567 - x829)
    x831 = x18 * x826 + x830
    x832 = x453 * x584
    x833 = x451 * x639 - x82 * x832 + x82 * (x286 + x451 * x582 - x832)
    x834 = x451 * x533
    x835 = x453 * x535
    x836 = (
        x549 * x834
        - x549 * x835
        + x87 * (x82 * x834 - x82 * x835 + x82 * (x227 + x834 - x835))
    )
    x837 = x18 * x830 + x836
    x838 = x451 * x559
    x839 = x453 * x500
    x840 = x82 * x838 - x82 * x839 + x82 * (x252 + x838 - x839)
    x841 = x17 * x840 + x830
    x842 = x451 * x500
    x843 = x453 * x502
    x844 = (
        x549 * x842
        - x549 * x843
        + x87 * (x82 * x842 - x82 * x843 + x82 * (x183 + x842 - x843))
    )
    x845 = x18 * x840 + x844
    x846 = x451 * x502
    x847 = x453 * x513
    x848 = (
        x18 * x844
        + x615 * x846
        - x615 * x847
        + x89
        * (
            x549 * x846
            - x549 * x847
            + x87 * (x82 * x846 - x82 * x847 + x82 * (x196 + x846 - x847))
        )
    )
    x849 = x451 * x483
    x850 = x453 * x461
    x851 = (
        x549 * x849
        - x549 * x850
        + x87 * (x82 * x849 - x82 * x850 + x82 * (x129 + x849 - x850))
    )
    x852 = x17 * x851 + x844
    x853 = x451 * x461
    x854 = x453 * x463
    x855 = (
        x615 * x853
        - x615 * x854
        + x89
        * (
            x549 * x853
            - x549 * x854
            + x87 * (x82 * x853 - x82 * x854 + x82 * (x114 + x853 - x854))
        )
    )
    x856 = x18 * x851 + x855
    x857 = x451 * x463
    x858 = x453 * x477

    # 216 item(s)
    S = numpy.array(
        [
            x11 * x126
            + x11 * (x11 * x133 + x126)
            + x115 * x16
            + x16 * (x115 + x131)
            + x77
            + x78 * x92
            - x83 * (x103 * x91 + x65 * x78 - x83 * x99)
            + x91
            * (
                -x103 * x83
                + x116
                + x78 * x90
                + x89
                * (
                    -x102 * x83
                    + x117
                    + x78 * x88
                    + x87
                    * (
                        -x101 * x83
                        + x118
                        + x78 * x86
                        + x82 * (-x100 * x83 + x119 + x78 * x84)
                    )
                )
            ),
            x11 * x176 + x11 * (x11 * x179 + x176) + x115 * x17 + x16 * x185 + x198,
            x11 * x199 + x11 * (x11 * x200 + x199) + x115 * x18 + x131 * x18,
            x11 * x222 + x11 * (x11 * x224 + x222) + x17 * x185 + x235,
            x11 * x237 + x11 * (x11 * x239 + x237) + x18 * x180 + x240,
            x11 * x241 + x11 * (x241 + x242 * x74) + x130 * x19,
            x11 * x248
            + x11 * (x11 * x250 + x248)
            + x16 * x184
            + x16 * (x184 + x254)
            + x198,
            x11 * x261 + x11 * (x11 * x264 + x261) + x16 * x269 + x235,
            x11 * x270 + x11 * (x11 * x271 + x270) + x18 * x254 + x240,
            x11 * x282 + x11 * (x11 * x284 + x282) + x17 * x269 + x290,
            x11 * x292 + x11 * (x11 * x294 + x292) + x18 * x265 + x295,
            x11 * x296 + x11 * (x141 * x242 + x296) + x19 * x253,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x300
            + x11 * (x11 * x302 + x300)
            + x16 * x268
            + x16 * (x268 + x305)
            + x234,
            x11 * x310 + x11 * (x11 * x313 + x310) + x16 * x317 + x290,
            x11 * x318 + x11 * (x11 * x319 + x318) + x18 * x305 + x295,
            x11 * x326
            + x11 * (x11 * x327 + x326)
            + x17 * x316
            + x17 * x317
            + x323
            + x324 * x78
            - x83 * (x320 * x78 - x325 * x83),
            x11 * x328 + x11 * (x11 * x329 + x328) + x18 * x314 + x18 * x316,
            x11 * x330 + x11 * (x203 * x242 + x330) + x19 * x304,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x355
            + x12 * x126
            + x16 * x343
            + x16 * (x343 + x352)
            + x332 * x78
            - x334 * x83
            + x91
            * (
                x336 * x78
                - x344 * x83
                + x89
                * (
                    x338 * x78
                    - x345 * x83
                    + x87 * (x342 * x78 - x347 * x83 + x82 * (x340 * x78 - x346 * x83))
                )
            ),
            x11 * x361 + x12 * x176 + x16 * x369 + x17 * x343 + x374,
            x11 * x376 + x12 * x199 + x18 * x343 + x18 * x352,
            x11 * x380 + x12 * x222 + x17 * x369 + x387,
            x11 * x390 + x12 * x237 + x18 * x362 + x391,
            x11 * x394 + x12 * x241 + x19 * x351,
            x11 * x398 + x12 * x248 + x16 * x368 + x16 * (x368 + x401) + x374,
            x11 * x406 + x12 * x261 + x16 * x410 + x387,
            x11 * x412 + x12 * x270 + x18 * x401 + x391,
            x11 * x416 + x12 * x282 + x17 * x410 + x420,
            x11 * x423 + x12 * x292 + x18 * x407 + x424,
            x11 * x426 + x12 * x296 + x19 * x400,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x430 + x12 * x300 + x16 * x409 + x16 * (x409 + x432) + x386,
            x11 * x437 + x12 * x310 + x16 * x440 + x420,
            x11 * x442 + x12 * x318 + x18 * x432 + x424,
            x11 * x446 + x12 * x326 + x17 * x439 + x17 * x440 + x443 * x78 - x444 * x83,
            x11 * x448 + x12 * x328 + x18 * x438 + x18 * x439,
            x11 * x450 + x12 * x330 + x19 * x431,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x491
            + x126 * x13
            + x16 * x469
            + x16 * (x16 * x489 + x469)
            + x452 * x78
            - x454 * x83
            + x91
            * (
                x470
                - x472
                + x89 * (x473 - x475 + x87 * (x479 - x481 + x82 * (x476 - x478)))
            ),
            x11 * x496 + x13 * x176 + x16 * x507 + x17 * x469 + x518,
            x11 * x523 + x13 * x199 + x16 * x525 + x18 * x469 + x526,
            x11 * x530 + x13 * x222 + x17 * x507 + x541,
            x11 * x545 + x13 * x237 + x17 * x525 + x547,
            x11 * x553 + x13 * x241 + x18 * x525 + x555,
            x11 * x558 + x13 * x248 + x16 * x506 + x16 * (x16 * x562 + x506) + x518,
            x11 * x566 + x13 * x261 + x16 * x571 + x541,
            x11 * x575 + x13 * x270 + x16 * x577 + x547,
            x11 * x581 + x13 * x282 + x17 * x571 + x587,
            x11 * x591 + x13 * x292 + x17 * x577 + x593,
            x11 * x597 + x13 * x296 + x18 * x577 + x599,
            x11 * x601 + x16 * x524 + x16 * (x16 * x602 + x524) + x526,
            x11 * x604 + x16 * x605 + x17 * x524 + x546,
            x11 * x608 + x16 * x610 + x555,
            x11 * x612 + x17 * x605 + x613,
            x11 * x614 + x17 * x610 + x599,
            x11 * x617 + x18 * x610 + x618,
            x11 * x621 + x13 * x300 + x16 * x570 + x16 * (x16 * x622 + x570) + x540,
            x11 * x626 + x13 * x310 + x16 * x628 + x587,
            x11 * x632 + x13 * x318 + x16 * x634 + x593,
            x11 * x638 + x13 * x326 + x17 * x627 + x17 * x628 + x635 * x78 - x636 * x83,
            x11 * x641 + x13 * x328 + x17 * x634 + x18 * x627 + x642,
            x11 * x646 + x13 * x330 + x18 * x634 + x648,
            x11 * x650 + x16 * x576 + x16 * (x16 * x651 + x576) + x546,
            x11 * x653 + x16 * x654 + x613,
            x11 * x657 + x16 * x659 + x599,
            x11 * x660 + x17 * x633 + x17 * x654 + x642,
            x11 * x661 + x17 * x659 + x648,
            x11 * x663 + x18 * x659 + x664,
            x11 * x666 + x16 * x609 + x16 * (x16 * x667 + x609) + x554,
            x11 * x669 + x16 * x670 + x17 * x609 + x598,
            x11 * x673 + x16 * x675 + x618,
            x11 * x676 + x17 * x658 + x17 * x670 + x647,
            x11 * x677 + x17 * x675 + x664,
            x11 * x679 + x18 * x674 + x18 * x675 + x476 * x678 - x478 * x678,
            x12 * x354
            + x12 * x355
            + x16 * x680
            + x16 * (x680 + x682)
            + x331 * x332
            - x333 * x334
            + x77,
            x12 * x360 + x12 * x361 + x16 * x685 + x17 * x680 + x686,
            x12 * x375 + x12 * x376 + x18 * x680 + x18 * x682,
            x12 * x379 + x12 * x380 + x17 * x685 + x688,
            x12 * x389 + x12 * x390 + x18 * x683 + x689,
            x12 * x393 + x12 * x394 + x19 * x681,
            x12 * x397 + x12 * x398 + x16 * x684 + x16 * (x684 + x691) + x686,
            x12 * x405 + x12 * x406 + x16 * x694 + x688,
            x12 * x411 + x12 * x412 + x18 * x691 + x689,
            x12 * x415 + x12 * x416 + x17 * x694 + x695,
            x12 * x422 + x12 * x423 + x18 * x692 + x696,
            x12 * x425 + x12 * x426 + x19 * x690,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x429 + x12 * x430 + x16 * x693 + x16 * (x693 + x698) + x687,
            x12 * x436 + x12 * x437 + x16 * x701 + x695,
            x12 * x441 + x12 * x442 + x18 * x698 + x696,
            x12 * x445
            + x12 * x446
            + x17 * x700
            + x17 * x701
            + x323
            + x331 * x443
            - x333 * x444
            + x91
            * (
                x286
                + x331 * x417
                - x333 * x418
                + x89
                * (
                    x227
                    + x331 * x381
                    - x333 * x382
                    + x87
                    * (
                        x196
                        + x331 * x365
                        - x333 * x371
                        + x82 * (x119 + x331 * x340 - x333 * x346)
                    )
                )
            ),
            x12 * x447 + x12 * x448 + x18 * x699 + x18 * x700,
            x12 * x449 + x12 * x450 + x19 * x697,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x491
            + x13 * x354
            + x16 * x702
            + x16 * (x16 * x703 + x702)
            + x331 * x452
            - x333 * x454,
            x12 * x496 + x13 * x360 + x16 * x706 + x17 * x702 + x708,
            x12 * x523 + x13 * x375 + x16 * x710 + x18 * x702 + x711,
            x12 * x530 + x13 * x379 + x17 * x706 + x716,
            x12 * x545 + x13 * x389 + x17 * x710 + x718,
            x12 * x553 + x13 * x393 + x18 * x710 + x720,
            x12 * x558 + x13 * x397 + x16 * x705 + x16 * (x16 * x723 + x705) + x708,
            x12 * x566 + x13 * x405 + x16 * x728 + x716,
            x12 * x575 + x13 * x411 + x16 * x730 + x718,
            x12 * x581 + x13 * x415 + x17 * x728 + x736,
            x12 * x591 + x13 * x422 + x17 * x730 + x738,
            x12 * x597 + x13 * x425 + x18 * x730 + x740,
            x12 * x601 + x16 * x709 + x16 * (x16 * x741 + x709) + x711,
            x12 * x604 + x16 * x742 + x17 * x709 + x717,
            x12 * x608 + x16 * x744 + x720,
            x12 * x612 + x17 * x742 + x745,
            x12 * x614 + x17 * x744 + x740,
            x12 * x617 + x18 * x744 + x746,
            x12 * x621 + x13 * x429 + x16 * x727 + x16 * (x16 * x751 + x727) + x715,
            x12 * x626 + x13 * x436 + x16 * x758 + x736,
            x12 * x632 + x13 * x441 + x16 * x760 + x738,
            x12 * x638
            + x13 * x445
            + x17 * x757
            + x17 * x758
            + x331 * x635
            - x333 * x636
            + x91
            * (
                x331 * x582
                - x761
                + x89 * (x762 - x763 + x87 * (x766 - x767 + x82 * (x764 - x765)))
            ),
            x12 * x641 + x13 * x447 + x17 * x760 + x18 * x757 + x768,
            x12 * x646 + x13 * x449 + x18 * x760 + x770,
            x12 * x650 + x16 * x729 + x16 * (x16 * x771 + x729) + x717,
            x12 * x653 + x16 * x772 + x745,
            x12 * x657 + x16 * x774 + x740,
            x12 * x660 + x17 * x759 + x17 * x772 + x768,
            x12 * x661 + x17 * x774 + x770,
            x12 * x663 + x18 * x774 + x775,
            x12 * x666 + x16 * x743 + x16 * (x16 * x776 + x743) + x719,
            x12 * x669 + x16 * x777 + x17 * x743 + x739,
            x12 * x673 + x16 * x779 + x746,
            x12 * x676 + x17 * x773 + x17 * x777 + x769,
            x12 * x677 + x17 * x779 + x775,
            x12 * x679 + x18 * x778 + x18 * x779 + x678 * x764 - x678 * x765,
            x13 * x490
            + x13 * x491
            + x16 * x780
            + x16 * (x16 * x781 + x780)
            + x451 * x452
            - x453 * x454
            + x77,
            x13 * x495 + x13 * x496 + x16 * x783 + x17 * x780 + x784,
            x13 * x522 + x13 * x523 + x16 * x787 + x18 * x780 + x789,
            x13 * x529 + x13 * x530 + x17 * x783 + x791,
            x13 * x544 + x13 * x545 + x17 * x787 + x794,
            x13 * x552 + x13 * x553 + x18 * x787 + x798,
            x13 * x557 + x13 * x558 + x16 * x782 + x16 * (x16 * x799 + x782) + x784,
            x13 * x565 + x13 * x566 + x16 * x801 + x791,
            x13 * x574 + x13 * x575 + x16 * x804 + x794,
            x13 * x580 + x13 * x581 + x17 * x801 + x805,
            x13 * x590 + x13 * x591 + x17 * x804 + x808,
            x13 * x596 + x13 * x597 + x18 * x804 + x812,
            x16 * x786 + x16 * (x16 * x815 + x786) + x601 * x816 + x789,
            x16 * x817 + x17 * x786 + x604 * x816 + x793,
            x16 * x821 + x608 * x816 + x798,
            x17 * x817 + x612 * x816 + x822,
            x17 * x821 + x614 * x816 + x812,
            x18 * x821 + x617 * x816 + x825,
            x13 * x620 + x13 * x621 + x16 * x800 + x16 * (x16 * x826 + x800) + x790,
            x13 * x625 + x13 * x626 + x16 * x828 + x805,
            x13 * x631 + x13 * x632 + x16 * x831 + x808,
            x13 * x637
            + x13 * x638
            + x17 * x827
            + x17 * x828
            + x323
            + x451 * x635
            - x453 * x636,
            x13 * x640 + x13 * x641 + x17 * x831 + x18 * x827 + x833,
            x13 * x645 + x13 * x646 + x18 * x831 + x837,
            x16 * x803 + x16 * (x16 * x840 + x803) + x650 * x816 + x793,
            x16 * x841 + x653 * x816 + x822,
            x16 * x845 + x657 * x816 + x812,
            x17 * x830 + x17 * x841 + x660 * x816 + x833,
            x17 * x845 + x661 * x816 + x837,
            x18 * x845 + x663 * x816 + x848,
            x16 * x820 + x16 * (x16 * x851 + x820) + x666 * x816 + x797,
            x16 * x852 + x17 * x820 + x669 * x816 + x811,
            x16 * x856 + x673 * x816 + x825,
            x17 * x844 + x17 * x852 + x676 * x816 + x836,
            x17 * x856 + x677 * x816 + x848,
            x18 * x855
            + x18 * x856
            + x678 * x857
            - x678 * x858
            + x679 * x816
            + x91
            * (
                x615 * x857
                - x615 * x858
                + x89
                * (
                    x549 * x857
                    - x549 * x858
                    + x87 * (x82 * x857 - x82 * x858 + x82 * (x119 + x857 - x858))
                )
            ),
        ]
    )
    return S


def eri_1000(a, A, b, B, c, C, d, D):
    """Cartesian [ps|ss] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = c + d
    x4 = x0 + x3
    x5 = x4 ** (-1.0)
    x6 = x3 ** (-1.0)
    x7 = -x2 - x6 * (c * C[0] + d * D[0])
    x8 = -x1 * (a * A[1] + b * B[1])
    x9 = -x6 * (c * C[1] + d * D[1]) - x8
    x10 = -x1 * (a * A[2] + b * B[2])
    x11 = -x10 - x6 * (c * C[2] + d * D[2])
    x12 = x0 * x3
    x13 = x12 * x5 * (x11**2 + x7**2 + x9**2)
    x14 = (
        2
        * numpy.pi**2.5
        * numpy.exp(
            -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        * numpy.exp(
            -c * d * x6 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
        )
        / (x12 + numpy.sqrt(x4))
    )
    x15 = x14 * boys(0, x13)
    x16 = x14 * x3 * x5 * boys(1, x13)

    # 3 item(s)
    S = numpy.array(
        [
            x15 * (-x2 - A[0]) - x16 * x7,
            x15 * (-x8 - A[1]) - x16 * x9,
            -x11 * x16 + x15 * (-x10 - A[2]),
        ]
    )
    return S


def eri_1001(a, A, b, B, c, C, d, D):
    """Cartesian [ps|sp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = C[0] - D[0]
    x1 = a + b
    x2 = c + d
    x3 = x1 + x2
    x4 = x3 ** (-1.0)
    x5 = x2 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x1 ** (-1.0)
    x8 = -x7 * (a * A[0] + b * B[0])
    x9 = -x6 - x8
    x10 = x5 * (c * C[1] + d * D[1])
    x11 = -x7 * (a * A[1] + b * B[1])
    x12 = -x10 - x11
    x13 = -x7 * (a * A[2] + b * B[2])
    x14 = -x13 - x5 * (c * C[2] + d * D[2])
    x15 = x1 * x2
    x16 = x15 * x4 * (x12**2 + x14**2 + x9**2)
    x17 = boys(0, x16)
    x18 = -x8 - A[0]
    x19 = C[1] - D[1]
    x20 = C[2] - D[2]
    x21 = (
        2
        * numpy.pi**2.5
        * numpy.exp(
            -a * b * x7 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        * numpy.exp(-c * d * x5 * (x0**2 + x19**2 + x20**2))
        / (x15 + numpy.sqrt(x3))
    )
    x22 = x18 * x21
    x23 = boys(1, x16)
    x24 = x2 * x4
    x25 = x24 * x9
    x26 = x21 * x25
    x27 = x17 * x22 - x23 * x26
    x28 = (2 * a + 2 * b + 2 * c + 2 * d) ** (-1.0)
    x29 = boys(2, x16)
    x30 = x21 * (x6 - C[0])
    x31 = x21 * x23
    x32 = x1 * x4
    x33 = x32 * x9
    x34 = x17 * x30 + x31 * x33
    x35 = x21 * x29
    x36 = x23 * x30 + x33 * x35
    x37 = x21 * (x10 - C[1])
    x38 = x12 * x32
    x39 = x17 * x37 + x31 * x38
    x40 = x23 * x37 + x35 * x38
    x41 = -x11 - A[1]
    x42 = x21 * x41
    x43 = x12 * x24
    x44 = x17 * x42 - x31 * x43
    x45 = -x13 - A[2]
    x46 = x21 * x45
    x47 = x14 * x24
    x48 = x17 * x46 - x31 * x47

    # 9 item(s)
    S = numpy.array(
        [
            x0 * x27 + x18 * x34 - x25 * x36 + x28 * (x22 * x23 - x26 * x29),
            x18 * x39 + x19 * x27 - x25 * x40,
            x20 * x27,
            x0 * x44 + x34 * x41 - x36 * x43,
            x19 * x44 + x28 * (x23 * x42 - x35 * x43) + x39 * x41 - x40 * x43,
            x20 * x44,
            x0 * x48 + x34 * x45 - x36 * x47,
            x19 * x48 + x39 * x45 - x40 * x47,
            x20 * x48 + x28 * (x23 * x46 - x35 * x47),
        ]
    )
    return S


def eri_1002(a, A, b, B, c, C, d, D):
    """Cartesian [ps|sd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = x7 ** (-1.0)
    x13 = C[0] - D[0]
    x14 = C[1] - D[1]
    x15 = C[2] - D[2]
    x16 = x15**2
    x17 = numpy.exp(-c * d * x12 * (x13**2 + x14**2 + x16))
    x18 = x9 ** (-1.0)
    x19 = x12 * (c * C[0] + d * D[0])
    x20 = -x19 - x2
    x21 = x12 * (c * C[1] + d * D[1])
    x22 = -x1 * (a * A[1] + b * B[1])
    x23 = -x21 - x22
    x24 = -x1 * (a * A[2] + b * B[2])
    x25 = -x12 * (c * C[2] + d * D[2]) - x24
    x26 = x18 * x8 * (x20**2 + x23**2 + x25**2)
    x27 = boys(0, x26)
    x28 = boys(1, x26)
    x29 = 2 * x10 * x11 * x17 * x6
    x30 = x28 * x29
    x31 = x0 * x18
    x32 = x5 * (2 * x10 * x11 * x17 * x27 * x6 - x30 * x31)
    x33 = x19 - C[0]
    x34 = x27 * x29
    x35 = x18 * x20
    x36 = x0 * x35
    x37 = x30 * x36 + x33 * x34
    x38 = x29 * boys(2, x26)
    x39 = x30 * x33 + x36 * x38
    x40 = x35 * x39
    x41 = x0 * x40 + x32 + x33 * x37
    x42 = x5 * (2 * x10 * x11 * x17 * x28 * x6 - x31 * x38)
    x43 = x29 * boys(3, x26)
    x44 = x33 * x38 + x36 * x43
    x45 = x35 * x44
    x46 = x0 * x45 + x33 * x39 + x42
    x47 = x35 * x7
    x48 = 2 * a + 2 * b + x4
    x49 = x48 ** (-1.0)
    x50 = x3 * x37 - x40 * x7 + x49 * (x3 * x30 - x38 * x47)
    x51 = 2 * x49
    x52 = x3 * x34 - x30 * x47
    x53 = x13 * x52
    x54 = x21 - C[1]
    x55 = x18 * x23
    x56 = x0 * x55
    x57 = x30 * x54 + x38 * x56
    x58 = x38 * x54 + x43 * x56
    x59 = x30 * x56 + x34 * x54
    x60 = x33 * x59 + x36 * x57
    x61 = x33 * x57 + x36 * x58
    x62 = x14 * x52
    x63 = x3 * x59 - x47 * x57
    x64 = x62 + x63
    x65 = x32 + x54 * x59 + x56 * x57
    x66 = x42 + x54 * x57 + x56 * x58
    x67 = -x22 - A[1]
    x68 = x55 * x7
    x69 = x37 * x67 - x39 * x68
    x70 = -x30 * x68 + x34 * x67
    x71 = x13 * x70
    x72 = x14 * x70
    x73 = x49 * (x30 * x67 - x38 * x68) - x57 * x68 + x59 * x67
    x74 = x72 + x73
    x75 = -x24 - A[2]
    x76 = x18 * x25 * x7
    x77 = x37 * x75 - x39 * x76
    x78 = -x30 * x76 + x34 * x75
    x79 = -x57 * x76 + x59 * x75
    x80 = x14 * x78 + x79
    x81 = x49 * (x30 * x75 - x38 * x76)
    x82 = x15 * x78 + x81

    # 18 item(s)
    S = numpy.array(
        [
            x13 * x50
            + x13 * (x50 + x53)
            + x3 * x41
            - x46 * x47
            + x51 * (x3 * x39 - x45 * x7 + x49 * (x3 * x38 - x43 * x47)),
            x13 * x64 + x14 * x50 + x3 * x60 - x47 * x61 + x49 * (x3 * x57 - x47 * x58),
            x15 * x50 + x15 * x53,
            x14 * x63 + x14 * x64 + x3 * x65 - x47 * x66,
            x15 * x62 + x15 * x63,
            x16 * x52,
            x13 * x69 + x13 * (x69 + x71) + x41 * x67 - x46 * x68,
            x13 * x74 + x14 * x69 + x49 * (x39 * x67 - x44 * x68) + x60 * x67 - x61 * x68,
            x15 * x69 + x15 * x71,
            x14 * x73
            + x14 * x74
            + x51 * (x49 * (x38 * x67 - x43 * x68) + x57 * x67 - x58 * x68)
            + x65 * x67
            - x66 * x68,
            x15 * x72 + x15 * x73,
            x16 * x70,
            x13 * x77 + x13 * (x13 * x78 + x77) + x41 * x75 - x46 * x76,
            x13 * x80 + x14 * x77 + x60 * x75 - x61 * x76,
            x13 * x82 + x15 * x77 + x49 * (x39 * x75 - x44 * x76),
            x14 * x79 + x14 * x80 + x65 * x75 - x66 * x76,
            x14 * x82 + x15 * x79 + x49 * (x57 * x75 - x58 * x76),
            x15 * x81 + x15 * x82 + 2 * (x38 * x75 - x43 * x76) / x48**2,
        ]
    )
    return S


def eri_1010(a, A, b, B, c, C, d, D):
    """Cartesian [ps|ps] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2 * a + 2 * b + 2 * c + 2 * d) ** (-1.0)
    x1 = a + b
    x2 = x1 ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = c + d
    x6 = x1 + x5
    x7 = x6 ** (-1.0)
    x8 = x5 ** (-1.0)
    x9 = x8 * (c * C[0] + d * D[0])
    x10 = -x3 - x9
    x11 = x8 * (c * C[1] + d * D[1])
    x12 = -x2 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x2 * (a * A[2] + b * B[2])
    x15 = -x14 - x8 * (c * C[2] + d * D[2])
    x16 = x1 * x5
    x17 = x16 * x7 * (x10**2 + x13**2 + x15**2)
    x18 = (
        2
        * numpy.pi**2.5
        * numpy.exp(
            -a * b * x2 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
        )
        * numpy.exp(
            -c * d * x8 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
        )
        / (x16 + numpy.sqrt(x6))
    )
    x19 = x18 * boys(1, x17)
    x20 = x5 * x7
    x21 = x10 * x20
    x22 = x18 * boys(2, x17)
    x23 = x9 - C[0]
    x24 = x18 * boys(0, x17)
    x25 = x1 * x7
    x26 = x10 * x25
    x27 = x19 * x26 + x23 * x24
    x28 = x19 * x23 + x22 * x26
    x29 = x11 - C[1]
    x30 = x13 * x25
    x31 = x19 * x30 + x24 * x29
    x32 = x19 * x29 + x22 * x30
    x33 = -x12 - A[1]
    x34 = x13 * x20
    x35 = -x14 - A[2]
    x36 = x15 * x20

    # 9 item(s)
    S = numpy.array(
        [
            x0 * (x19 * x4 - x21 * x22) - x21 * x28 + x27 * x4,
            -x21 * x32 + x31 * x4,
            0,
            x27 * x33 - x28 * x34,
            x0 * (x19 * x33 - x22 * x34) + x31 * x33 - x32 * x34,
            0,
            x27 * x35 - x28 * x36,
            x31 * x35 - x32 * x36,
            x0 * (x19 * x35 - x22 * x36),
        ]
    )
    return S


def eri_1011(a, A, b, B, c, C, d, D):
    """Cartesian [ps|pp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = x7 ** (-1.0)
    x13 = C[0] - D[0]
    x14 = C[1] - D[1]
    x15 = C[2] - D[2]
    x16 = numpy.exp(-c * d * x12 * (x13**2 + x14**2 + x15**2))
    x17 = x9 ** (-1.0)
    x18 = x12 * (c * C[0] + d * D[0])
    x19 = -x18 - x2
    x20 = x12 * (c * C[1] + d * D[1])
    x21 = -x1 * (a * A[1] + b * B[1])
    x22 = -x20 - x21
    x23 = -x1 * (a * A[2] + b * B[2])
    x24 = -x12 * (c * C[2] + d * D[2]) - x23
    x25 = x17 * x8 * (x19**2 + x22**2 + x24**2)
    x26 = boys(0, x25)
    x27 = boys(1, x25)
    x28 = 2 * x10 * x11 * x16 * x6
    x29 = x27 * x28
    x30 = x0 * x17
    x31 = x5 * (2 * x10 * x11 * x16 * x26 * x6 - x29 * x30)
    x32 = x18 - C[0]
    x33 = x26 * x28
    x34 = x17 * x19
    x35 = x0 * x34
    x36 = x29 * x35 + x32 * x33
    x37 = x28 * boys(2, x25)
    x38 = x29 * x32 + x35 * x37
    x39 = x34 * x38
    x40 = x0 * x39 + x31 + x32 * x36
    x41 = x5 * (2 * x10 * x11 * x16 * x27 * x6 - x30 * x37)
    x42 = x28 * boys(3, x25)
    x43 = x32 * x37 + x35 * x42
    x44 = x34 * x43
    x45 = x0 * x44 + x32 * x38 + x41
    x46 = x34 * x7
    x47 = 2 * a + 2 * b + x4
    x48 = x47 ** (-1.0)
    x49 = x3 * x36 - x39 * x7 + x48 * (x29 * x3 - x37 * x46)
    x50 = 2 * x48
    x51 = x20 - C[1]
    x52 = x17 * x22
    x53 = x0 * x52
    x54 = x29 * x51 + x37 * x53
    x55 = x37 * x51 + x42 * x53
    x56 = x29 * x53 + x33 * x51
    x57 = x32 * x56 + x35 * x54
    x58 = x32 * x54 + x35 * x55
    x59 = x3 * x57 - x46 * x58 + x48 * (x3 * x54 - x46 * x55)
    x60 = x3 * x56 - x46 * x54
    x61 = x31 + x51 * x56 + x53 * x54
    x62 = x41 + x51 * x54 + x53 * x55
    x63 = -x21 - A[1]
    x64 = x52 * x7
    x65 = x36 * x63 - x38 * x64
    x66 = x48 * (x38 * x63 - x43 * x64) + x57 * x63 - x58 * x64
    x67 = x48 * (x29 * x63 - x37 * x64) - x54 * x64 + x56 * x63
    x68 = -x23 - A[2]
    x69 = x17 * x24 * x7
    x70 = x36 * x68 - x38 * x69
    x71 = x57 * x68 - x58 * x69
    x72 = x48 * (x38 * x68 - x43 * x69)
    x73 = -x54 * x69 + x56 * x68
    x74 = x48 * (x54 * x68 - x55 * x69)
    x75 = x48 * (x29 * x68 - x37 * x69)

    # 27 item(s)
    S = numpy.array(
        [
            x13 * x49
            + x3 * x40
            - x45 * x46
            + x50 * (x3 * x38 - x44 * x7 + x48 * (x3 * x37 - x42 * x46)),
            x14 * x49 + x59,
            x15 * x49,
            x13 * x60 + x59,
            x14 * x60 + x3 * x61 - x46 * x62,
            x15 * x60,
            0,
            0,
            0,
            x13 * x65 + x40 * x63 - x45 * x64,
            x14 * x65 + x66,
            x15 * x65,
            x13 * x67 + x66,
            x14 * x67
            + x50 * (x48 * (x37 * x63 - x42 * x64) + x54 * x63 - x55 * x64)
            + x61 * x63
            - x62 * x64,
            x15 * x67,
            0,
            0,
            0,
            x13 * x70 + x40 * x68 - x45 * x69,
            x14 * x70 + x71,
            x15 * x70 + x72,
            x13 * x73 + x71,
            x14 * x73 + x61 * x68 - x62 * x69,
            x15 * x73 + x74,
            x13 * x75 + x72,
            x14 * x75 + x74,
            x15 * x75 + 2 * (x37 * x68 - x42 * x69) / x47**2,
        ]
    )
    return S


def eri_1012(a, A, b, B, c, C, d, D):
    """Cartesian [ps|pd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = c + d
    x5 = x4 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x6 - C[0]
    x8 = x0 + x4
    x9 = x8 ** (-1.0)
    x10 = -x2 - x6
    x11 = x5 * (c * C[1] + d * D[1])
    x12 = -x1 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x1 * (a * A[2] + b * B[2])
    x15 = -x14 - x5 * (c * C[2] + d * D[2])
    x16 = x0 * x4
    x17 = x16 * x9 * (x10**2 + x13**2 + x15**2)
    x18 = boys(1, x17)
    x19 = numpy.pi**2.5
    x20 = (x16 + numpy.sqrt(x8)) ** (-1.0)
    x21 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x22 = C[0] - D[0]
    x23 = C[1] - D[1]
    x24 = C[2] - D[2]
    x25 = x24**2
    x26 = numpy.exp(-c * d * x5 * (x22**2 + x23**2 + x25))
    x27 = 2 * x19 * x20 * x21 * x26
    x28 = x18 * x27
    x29 = x0 * x9
    x30 = x10 * x29
    x31 = boys(2, x17)
    x32 = x27 * x31
    x33 = x28 * x7 + x30 * x32
    x34 = x29 * x33
    x35 = boys(0, x17)
    x36 = x27 * x35
    x37 = x28 * x30 + x36 * x7
    x38 = 2 * c + 2 * d
    x39 = x38 ** (-1.0)
    x40 = 2 * x39
    x41 = x39 * (2 * x19 * x20 * x21 * x26 * x35 - x28 * x29)
    x42 = x10 * x34 + x37 * x7 + x41
    x43 = x39 * (2 * x18 * x19 * x20 * x21 * x26 - x29 * x32)
    x44 = x27 * boys(3, x17)
    x45 = x30 * x44 + x32 * x7
    x46 = x29 * x45
    x47 = x10 * x46 + x33 * x7 + x43
    x48 = x30 * x47 + x40 * (-x34 + x37) + x42 * x7
    x49 = x39 * (2 * x19 * x20 * x21 * x26 * x31 - x29 * x44)
    x50 = x27 * boys(4, x17)
    x51 = x30 * x50 + x44 * x7
    x52 = x30 * x51 + x45 * x7 + x49
    x53 = x30 * x52 + x40 * (x33 - x46) + x47 * x7
    x54 = x4 * x9
    x55 = x10 * x54
    x56 = 2 * a + 2 * b + x38
    x57 = x56 ** (-1.0)
    x58 = 2 * x57
    x59 = (
        x3 * x42 - x47 * x55 + x58 * (x3 * x33 - x45 * x55 + x57 * (x3 * x32 - x44 * x55))
    )
    x60 = 3 * x57
    x61 = x3 * x37 - x33 * x55 + x57 * (x28 * x3 - x32 * x55)
    x62 = x22 * x61
    x63 = x23 * x61
    x64 = x11 - C[1]
    x65 = x13 * x29
    x66 = x28 * x64 + x32 * x65
    x67 = x32 * x64 + x44 * x65
    x68 = x28 * x65 + x36 * x64
    x69 = x29 * x66
    x70 = x10 * x69 + x68 * x7
    x71 = x29 * x67
    x72 = x10 * x71 + x66 * x7
    x73 = x3 * x70 - x55 * x72 + x57 * (x3 * x66 - x55 * x67)
    x74 = x63 + x73
    x75 = x39 * (x68 - x69)
    x76 = x30 * x72 + x7 * x70 + x75
    x77 = x44 * x64 + x50 * x65
    x78 = x30 * x77 + x67 * x7
    x79 = x39 * (x66 - x71)
    x80 = x30 * x78 + x7 * x72 + x79
    x81 = (
        x3 * x76 - x55 * x80 + x58 * (x3 * x72 - x55 * x78 + x57 * (x3 * x67 - x55 * x77))
    )
    x82 = x13 * x71 + x43 + x64 * x66
    x83 = x49 + x64 * x67 + x65 * x77
    x84 = x13 * x69 + x41 + x64 * x68
    x85 = x30 * x82 + x7 * x84
    x86 = x30 * x83 + x7 * x82
    x87 = x23 * x73 + x3 * x85 - x55 * x86 + x57 * (x3 * x82 - x55 * x83)
    x88 = x24 * x73
    x89 = x3 * x68 - x55 * x66
    x90 = x22 * x89
    x91 = x23 * x89
    x92 = x3 * x84 - x55 * x82
    x93 = x91 + x92
    x94 = x64 * x84 + x65 * x82 + 2 * x75
    x95 = x64 * x82 + x65 * x83 + 2 * x79
    x96 = -x12 - A[1]
    x97 = x13 * x54
    x98 = x42 * x96 - x47 * x97
    x99 = -x33 * x97 + x37 * x96
    x100 = x22 * x99
    x101 = x23 * x99
    x102 = x57 * (x33 * x96 - x45 * x97) + x70 * x96 - x72 * x97
    x103 = x101 + x102
    x104 = x57 * (x47 * x96 - x52 * x97) + x76 * x96 - x80 * x97
    x105 = (
        x102 * x23
        + x58 * (x57 * (x45 * x96 - x51 * x97) + x72 * x96 - x78 * x97)
        + x85 * x96
        - x86 * x97
    )
    x106 = x102 * x24
    x107 = x57 * (x28 * x96 - x32 * x97) - x66 * x97 + x68 * x96
    x108 = x107 * x22
    x109 = x107 * x23
    x110 = (
        x58 * (x57 * (x32 * x96 - x44 * x97) + x66 * x96 - x67 * x97)
        - x82 * x97
        + x84 * x96
    )
    x111 = x109 + x110
    x112 = -x14 - A[2]
    x113 = x15 * x54
    x114 = x112 * x42 - x113 * x47
    x115 = x112 * x37 - x113 * x33
    x116 = x112 * x70 - x113 * x72
    x117 = x115 * x23 + x116
    x118 = x112 * x76 - x113 * x80
    x119 = x57 * (x112 * x33 - x113 * x45)
    x120 = x115 * x24 + x119
    x121 = x57 * (x112 * x47 - x113 * x52)
    x122 = x112 * x85 - x113 * x86 + x116 * x23
    x123 = x57 * (x112 * x72 - x113 * x78)
    x124 = x116 * x24 + x123
    x125 = 2 / x56**2
    x126 = x119 * x24 + x125 * (x112 * x45 - x113 * x51)
    x127 = x112 * x68 - x113 * x66
    x128 = x112 * x84 - x113 * x82
    x129 = x127 * x23 + x128
    x130 = x57 * (x112 * x66 - x113 * x67)
    x131 = x127 * x24 + x130
    x132 = x57 * (x112 * x82 - x113 * x83)
    x133 = x125 * (x112 * x67 - x113 * x77) + x130 * x24
    x134 = x57 * (x112 * x28 - x113 * x32)
    x135 = x130 + x134 * x23
    x136 = x125 * (x112 * x32 - x113 * x44)
    x137 = x134 * x24 + x136

    # 54 item(s)
    S = numpy.array(
        [
            x22 * x59
            + x22 * (x59 + x62)
            + x3 * x48
            - x53 * x55
            + x60
            * (
                x3 * x47
                - x52 * x55
                + x58 * (x3 * x45 - x51 * x55 + x57 * (x3 * x44 - x50 * x55))
            ),
            x22 * x74 + x23 * x59 + x81,
            x24 * x59 + x24 * x62,
            x23 * x74 + x87,
            x24 * x63 + x88,
            x25 * x61,
            x22 * x73 + x22 * (x73 + x90) + x81,
            x22 * x93 + x87,
            x24 * x90 + x88,
            x23 * x92 + x23 * x93 + x3 * x94 - x55 * x95,
            x24 * x91 + x24 * x92,
            x25 * x89,
            0,
            0,
            0,
            0,
            0,
            0,
            x22 * x98 + x22 * (x100 + x98) + x48 * x96 - x53 * x97,
            x103 * x22 + x104 + x23 * x98,
            x100 * x24 + x24 * x98,
            x103 * x23 + x105,
            x101 * x24 + x106,
            x25 * x99,
            x102 * x22 + x104 + x22 * (x102 + x108),
            x105 + x111 * x22,
            x106 + x108 * x24,
            x110 * x23
            + x111 * x23
            + x60
            * (
                x58 * (x57 * (x44 * x96 - x50 * x97) + x67 * x96 - x77 * x97)
                + x82 * x96
                - x83 * x97
            )
            + x94 * x96
            - x95 * x97,
            x109 * x24 + x110 * x24,
            x107 * x25,
            0,
            0,
            0,
            0,
            0,
            0,
            x112 * x48 - x113 * x53 + x114 * x22 + x22 * (x114 + x115 * x22),
            x114 * x23 + x117 * x22 + x118,
            x114 * x24 + x120 * x22 + x121,
            x117 * x23 + x122,
            x120 * x23 + x124,
            x120 * x24 + x126,
            x116 * x22 + x118 + x22 * (x116 + x127 * x22),
            x122 + x129 * x22,
            x124 + x131 * x22,
            x112 * x94 - x113 * x95 + x128 * x23 + x129 * x23,
            x128 * x24 + x131 * x23 + x132,
            x131 * x24 + x133,
            x119 * x22 + x121 + x22 * (x119 + x134 * x22),
            x119 * x23 + x123 + x135 * x22,
            x126 + x137 * x22,
            x130 * x23 + x132 + x135 * x23,
            x133 + x137 * x23,
            x136 * x24 + x137 * x24 + 6 * (x112 * x44 - x113 * x50) / x56**3,
        ]
    )
    return S


def eri_1020(a, A, b, B, c, C, d, D):
    """Cartesian [ps|ds] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = x7 ** (-1.0)
    x13 = numpy.exp(
        -c * d * x12 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x14 = x9 ** (-1.0)
    x15 = x12 * (c * C[0] + d * D[0])
    x16 = -x15 - x2
    x17 = x12 * (c * C[1] + d * D[1])
    x18 = -x1 * (a * A[1] + b * B[1])
    x19 = -x17 - x18
    x20 = -x1 * (a * A[2] + b * B[2])
    x21 = -x12 * (c * C[2] + d * D[2]) - x20
    x22 = x14 * x8 * (x16**2 + x19**2 + x21**2)
    x23 = boys(0, x22)
    x24 = boys(1, x22)
    x25 = 2 * x10 * x11 * x13 * x6
    x26 = x24 * x25
    x27 = x0 * x14
    x28 = x5 * (2 * x10 * x11 * x13 * x23 * x6 - x26 * x27)
    x29 = x15 - C[0]
    x30 = x23 * x25
    x31 = x14 * x16
    x32 = x0 * x31
    x33 = x25 * boys(2, x22)
    x34 = x26 * x29 + x32 * x33
    x35 = x28 + x29 * (x26 * x32 + x29 * x30) + x32 * x34
    x36 = x5 * (2 * x10 * x11 * x13 * x24 * x6 - x27 * x33)
    x37 = x25 * boys(3, x22)
    x38 = x29 * x33 + x32 * x37
    x39 = x29 * x34 + x32 * x38 + x36
    x40 = x31 * x7
    x41 = 2 * a + 2 * b + x4
    x42 = x41 ** (-1.0)
    x43 = 2 * x42
    x44 = x17 - C[1]
    x45 = x14 * x19
    x46 = x0 * x45
    x47 = x26 * x44 + x33 * x46
    x48 = x33 * x44 + x37 * x46
    x49 = x26 * x46 + x30 * x44
    x50 = x29 * x49 + x32 * x47
    x51 = x29 * x47 + x32 * x48
    x52 = x28 + x44 * x49 + x46 * x47
    x53 = x36 + x44 * x47 + x46 * x48
    x54 = -x18 - A[1]
    x55 = x45 * x7
    x56 = -x20 - A[2]
    x57 = x14 * x21 * x7

    # 18 item(s)
    S = numpy.array(
        [
            x3 * x35
            - x39 * x40
            + x43 * (x3 * x34 - x38 * x40 + x42 * (x3 * x33 - x37 * x40)),
            x3 * x50 - x40 * x51 + x42 * (x3 * x47 - x40 * x48),
            0,
            x3 * x52 - x40 * x53,
            0,
            0,
            x35 * x54 - x39 * x55,
            x42 * (x34 * x54 - x38 * x55) + x50 * x54 - x51 * x55,
            0,
            x43 * (x42 * (x33 * x54 - x37 * x55) + x47 * x54 - x48 * x55)
            + x52 * x54
            - x53 * x55,
            0,
            0,
            x35 * x56 - x39 * x57,
            x50 * x56 - x51 * x57,
            x42 * (x34 * x56 - x38 * x57),
            x52 * x56 - x53 * x57,
            x42 * (x47 * x56 - x48 * x57),
            2 * (x33 * x56 - x37 * x57) / x41**2,
        ]
    )
    return S


def eri_1021(a, A, b, B, c, C, d, D):
    """Cartesian [ps|dp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = c + d
    x5 = x4 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x6 - C[0]
    x8 = x0 + x4
    x9 = x8 ** (-1.0)
    x10 = -x2 - x6
    x11 = x5 * (c * C[1] + d * D[1])
    x12 = -x1 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x1 * (a * A[2] + b * B[2])
    x15 = -x14 - x5 * (c * C[2] + d * D[2])
    x16 = x0 * x4
    x17 = x16 * x9 * (x10**2 + x13**2 + x15**2)
    x18 = boys(1, x17)
    x19 = numpy.pi**2.5
    x20 = (x16 + numpy.sqrt(x8)) ** (-1.0)
    x21 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x22 = C[0] - D[0]
    x23 = C[1] - D[1]
    x24 = C[2] - D[2]
    x25 = numpy.exp(-c * d * x5 * (x22**2 + x23**2 + x24**2))
    x26 = 2 * x19 * x20 * x21 * x25
    x27 = x18 * x26
    x28 = x0 * x9
    x29 = x10 * x28
    x30 = boys(2, x17)
    x31 = x26 * x30
    x32 = x27 * x7 + x29 * x31
    x33 = x28 * x32
    x34 = boys(0, x17)
    x35 = x26 * x34
    x36 = x27 * x29 + x35 * x7
    x37 = 2 * c + 2 * d
    x38 = x37 ** (-1.0)
    x39 = 2 * x38
    x40 = x38 * (2 * x19 * x20 * x21 * x25 * x34 - x27 * x28)
    x41 = x10 * x33 + x36 * x7 + x40
    x42 = x38 * (2 * x18 * x19 * x20 * x21 * x25 - x28 * x31)
    x43 = x26 * boys(3, x17)
    x44 = x29 * x43 + x31 * x7
    x45 = x28 * x44
    x46 = x10 * x45 + x32 * x7 + x42
    x47 = x29 * x46 + x39 * (-x33 + x36) + x41 * x7
    x48 = x38 * (2 * x19 * x20 * x21 * x25 * x30 - x28 * x43)
    x49 = x26 * boys(4, x17)
    x50 = x29 * x49 + x43 * x7
    x51 = x29 * x50 + x44 * x7 + x48
    x52 = x29 * x51 + x39 * (x32 - x45) + x46 * x7
    x53 = x4 * x9
    x54 = x10 * x53
    x55 = 2 * a + 2 * b + x37
    x56 = x55 ** (-1.0)
    x57 = 2 * x56
    x58 = (
        x3 * x41 - x46 * x54 + x57 * (x3 * x32 - x44 * x54 + x56 * (x3 * x31 - x43 * x54))
    )
    x59 = 3 * x56
    x60 = x11 - C[1]
    x61 = x13 * x28
    x62 = x27 * x60 + x31 * x61
    x63 = x28 * x62
    x64 = x27 * x61 + x35 * x60
    x65 = x38 * (-x63 + x64)
    x66 = x10 * x63 + x64 * x7
    x67 = x31 * x60 + x43 * x61
    x68 = x28 * x67
    x69 = x10 * x68 + x62 * x7
    x70 = x29 * x69 + x65 + x66 * x7
    x71 = x43 * x60 + x49 * x61
    x72 = x29 * x71 + x67 * x7
    x73 = x38 * (x62 - x68)
    x74 = x29 * x72 + x69 * x7 + x73
    x75 = (
        x3 * x70 - x54 * x74 + x57 * (x3 * x69 - x54 * x72 + x56 * (x3 * x67 - x54 * x71))
    )
    x76 = x3 * x66 - x54 * x69 + x56 * (x3 * x62 - x54 * x67)
    x77 = x13 * x68 + x42 + x60 * x62
    x78 = x48 + x60 * x67 + x61 * x71
    x79 = x13 * x63 + x40 + x60 * x64
    x80 = x29 * x77 + x7 * x79
    x81 = x29 * x78 + x7 * x77
    x82 = x3 * x80 - x54 * x81 + x56 * (x3 * x77 - x54 * x78)
    x83 = x3 * x79 - x54 * x77
    x84 = x60 * x79 + x61 * x77 + 2 * x65
    x85 = x60 * x77 + x61 * x78 + 2 * x73
    x86 = -x12 - A[1]
    x87 = x13 * x53
    x88 = x41 * x86 - x46 * x87
    x89 = x56 * (x46 * x86 - x51 * x87) + x70 * x86 - x74 * x87
    x90 = x56 * (x32 * x86 - x44 * x87) + x66 * x86 - x69 * x87
    x91 = (
        x57 * (x56 * (x44 * x86 - x50 * x87) + x69 * x86 - x72 * x87)
        + x80 * x86
        - x81 * x87
    )
    x92 = (
        x57 * (x56 * (x31 * x86 - x43 * x87) + x62 * x86 - x67 * x87)
        - x77 * x87
        + x79 * x86
    )
    x93 = -x14 - A[2]
    x94 = x15 * x53
    x95 = x41 * x93 - x46 * x94
    x96 = x70 * x93 - x74 * x94
    x97 = x56 * (x46 * x93 - x51 * x94)
    x98 = x66 * x93 - x69 * x94
    x99 = x80 * x93 - x81 * x94
    x100 = x56 * (x69 * x93 - x72 * x94)
    x101 = x56 * (x32 * x93 - x44 * x94)
    x102 = 2 / x55**2
    x103 = x102 * (x44 * x93 - x50 * x94)
    x104 = -x77 * x94 + x79 * x93
    x105 = x56 * (x77 * x93 - x78 * x94)
    x106 = x56 * (x62 * x93 - x67 * x94)
    x107 = x102 * (x67 * x93 - x71 * x94)
    x108 = x102 * (x31 * x93 - x43 * x94)

    # 54 item(s)
    S = numpy.array(
        [
            x22 * x58
            + x3 * x47
            - x52 * x54
            + x59
            * (
                x3 * x46
                - x51 * x54
                + x57 * (x3 * x44 - x50 * x54 + x56 * (x3 * x43 - x49 * x54))
            ),
            x23 * x58 + x75,
            x24 * x58,
            x22 * x76 + x75,
            x23 * x76 + x82,
            x24 * x76,
            0,
            0,
            0,
            x22 * x83 + x82,
            x23 * x83 + x3 * x84 - x54 * x85,
            x24 * x83,
            0,
            0,
            0,
            0,
            0,
            0,
            x22 * x88 + x47 * x86 - x52 * x87,
            x23 * x88 + x89,
            x24 * x88,
            x22 * x90 + x89,
            x23 * x90 + x91,
            x24 * x90,
            0,
            0,
            0,
            x22 * x92 + x91,
            x23 * x92
            + x59
            * (
                x57 * (x56 * (x43 * x86 - x49 * x87) + x67 * x86 - x71 * x87)
                + x77 * x86
                - x78 * x87
            )
            + x84 * x86
            - x85 * x87,
            x24 * x92,
            0,
            0,
            0,
            0,
            0,
            0,
            x22 * x95 + x47 * x93 - x52 * x94,
            x23 * x95 + x96,
            x24 * x95 + x97,
            x22 * x98 + x96,
            x23 * x98 + x99,
            x100 + x24 * x98,
            x101 * x22 + x97,
            x100 + x101 * x23,
            x101 * x24 + x103,
            x104 * x22 + x99,
            x104 * x23 + x84 * x93 - x85 * x94,
            x104 * x24 + x105,
            x100 + x106 * x22,
            x105 + x106 * x23,
            x106 * x24 + x107,
            x103 + x108 * x22,
            x107 + x108 * x23,
            x108 * x24 + 6 * (x43 * x93 - x49 * x94) / x55**3,
        ]
    )
    return S


def eri_1022(a, A, b, B, c, C, d, D):
    """Cartesian [ps|dd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = numpy.exp(
        -a * b * x1 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = x7 ** (-1.0)
    x13 = C[0] - D[0]
    x14 = C[1] - D[1]
    x15 = C[2] - D[2]
    x16 = x15**2
    x17 = numpy.exp(-c * d * x12 * (x13**2 + x14**2 + x16))
    x18 = x9 ** (-1.0)
    x19 = x12 * (c * C[0] + d * D[0])
    x20 = -x19 - x2
    x21 = x12 * (c * C[1] + d * D[1])
    x22 = -x1 * (a * A[1] + b * B[1])
    x23 = -x21 - x22
    x24 = -x1 * (a * A[2] + b * B[2])
    x25 = -x12 * (c * C[2] + d * D[2]) - x24
    x26 = x18 * x8 * (x20**2 + x23**2 + x25**2)
    x27 = boys(1, x26)
    x28 = x0 * x18
    x29 = boys(2, x26)
    x30 = 2 * x10 * x11 * x17 * x6
    x31 = x29 * x30
    x32 = x5 * (2 * x10 * x11 * x17 * x27 * x6 - x28 * x31)
    x33 = x19 - C[0]
    x34 = x27 * x30
    x35 = x20 * x28
    x36 = x31 * x35 + x33 * x34
    x37 = boys(3, x26)
    x38 = x30 * x37
    x39 = x31 * x33 + x35 * x38
    x40 = x28 * x39
    x41 = x20 * x40 + x32 + x33 * x36
    x42 = x28 * x41
    x43 = boys(0, x26)
    x44 = x5 * (2 * x10 * x11 * x17 * x43 * x6 - x28 * x34)
    x45 = x30 * x43
    x46 = x33 * x45 + x34 * x35
    x47 = x28 * x36
    x48 = x20 * x47 + x33 * x46 + x44
    x49 = 3 * x5
    x50 = 2 * x5
    x51 = x20 * x42 + x33 * x48 + x50 * (x46 - x47)
    x52 = x5 * (2 * x10 * x11 * x17 * x29 * x6 - x28 * x38)
    x53 = x30 * boys(4, x26)
    x54 = x33 * x38 + x35 * x53
    x55 = x28 * x54
    x56 = x20 * x55 + x33 * x39 + x52
    x57 = x28 * x56
    x58 = x20 * x57 + x33 * x41 + x50 * (x36 - x40)
    x59 = x33 * x51 + x35 * x58 + x49 * (-x42 + x48)
    x60 = x5 * (2 * x10 * x11 * x17 * x37 * x6 - x28 * x53)
    x61 = x30 * boys(5, x26)
    x62 = x33 * x53 + x35 * x61
    x63 = x33 * x54 + x35 * x62 + x60
    x64 = x33 * x56 + x35 * x63 + x50 * (x39 - x55)
    x65 = x33 * x58 + x35 * x64 + x49 * (x41 - x57)
    x66 = x18 * x7
    x67 = x20 * x66
    x68 = 2 * a + 2 * b + x4
    x69 = x68 ** (-1.0)
    x70 = 2 * x69
    x71 = 3 * x69
    x72 = (
        x3 * x51
        - x58 * x67
        + x71
        * (
            x3 * x41
            - x56 * x67
            + x70 * (x3 * x39 - x54 * x67 + x69 * (x3 * x38 - x53 * x67))
        )
    )
    x73 = 4 * x69
    x74 = (
        x3 * x48 - x41 * x67 + x70 * (x3 * x36 - x39 * x67 + x69 * (x3 * x31 - x38 * x67))
    )
    x75 = x13 * x74
    x76 = x14 * x74
    x77 = x21 - C[1]
    x78 = x23 * x28
    x79 = x31 * x78 + x34 * x77
    x80 = x28 * x79
    x81 = x34 * x78 + x45 * x77
    x82 = x5 * (-x80 + x81)
    x83 = x20 * x80 + x33 * x81
    x84 = x31 * x77 + x38 * x78
    x85 = x28 * x84
    x86 = x20 * x85 + x33 * x79
    x87 = x28 * x86
    x88 = x20 * x87 + x33 * x83 + x82
    x89 = x5 * (x79 - x85)
    x90 = x38 * x77 + x53 * x78
    x91 = x28 * x90
    x92 = x20 * x91 + x33 * x84
    x93 = x28 * x92
    x94 = x20 * x93 + x33 * x86 + x89
    x95 = (
        x3 * x88 - x67 * x94 + x70 * (x3 * x86 - x67 * x92 + x69 * (x3 * x84 - x67 * x90))
    )
    x96 = x76 + x95
    x97 = x33 * x88 + x35 * x94 + x50 * (x83 - x87)
    x98 = x5 * (x84 - x91)
    x99 = x53 * x77 + x61 * x78
    x100 = x33 * x90 + x35 * x99
    x101 = x100 * x35 + x33 * x92 + x98
    x102 = x101 * x35 + x33 * x94 + x50 * (x86 - x93)
    x103 = (
        -x102 * x67
        + x3 * x97
        + x71
        * (
            -x101 * x67
            + x3 * x94
            + x70 * (-x100 * x67 + x3 * x92 + x69 * (x3 * x90 - x67 * x99))
        )
    )
    x104 = x23 * x85 + x32 + x77 * x79
    x105 = x104 * x28
    x106 = x23 * x80 + x44 + x77 * x81
    x107 = x5 * (-x105 + x106)
    x108 = x105 * x20 + x106 * x33
    x109 = x23 * x91 + x52 + x77 * x84
    x110 = x109 * x28
    x111 = x104 * x33 + x110 * x20
    x112 = x107 + x108 * x33 + x111 * x35
    x113 = x60 + x77 * x90 + x78 * x99
    x114 = x109 * x33 + x113 * x35
    x115 = x5 * (x104 - x110)
    x116 = x111 * x33 + x114 * x35 + x115
    x117 = (
        x112 * x3
        - x116 * x67
        + x70 * (x111 * x3 - x114 * x67 + x69 * (x109 * x3 - x113 * x67))
    )
    x118 = x117 + x14 * x95
    x119 = x15 * x95
    x120 = x3 * x83 - x67 * x86 + x69 * (x3 * x79 - x67 * x84)
    x121 = x120 * x13
    x122 = x120 * x14
    x123 = x108 * x3 - x111 * x67 + x69 * (x104 * x3 - x109 * x67)
    x124 = x122 + x123
    x125 = x104 * x77 + x110 * x23 + 2 * x89
    x126 = x109 * x77 + x113 * x78 + 2 * x98
    x127 = x105 * x23 + x106 * x77 + 2 * x82
    x128 = x125 * x35 + x127 * x33
    x129 = x125 * x33 + x126 * x35
    x130 = x123 * x14 + x128 * x3 - x129 * x67 + x69 * (x125 * x3 - x126 * x67)
    x131 = x123 * x15
    x132 = -x104 * x67 + x106 * x3
    x133 = x13 * x132
    x134 = x132 * x14
    x135 = -x125 * x67 + x127 * x3
    x136 = x134 + x135
    x137 = 3 * x107 + x125 * x78 + x127 * x77
    x138 = 3 * x115 + x125 * x77 + x126 * x78
    x139 = -x22 - A[1]
    x140 = x23 * x66
    x141 = x139 * x51 - x140 * x58
    x142 = x139 * x48 - x140 * x41
    x143 = x13 * x142
    x144 = x14 * x142
    x145 = x139 * x88 - x140 * x94 + x69 * (x139 * x41 - x140 * x56)
    x146 = x144 + x145
    x147 = -x102 * x140 + x139 * x97 + x69 * (x139 * x58 - x140 * x64)
    x148 = (
        x112 * x139
        - x116 * x140
        + x70 * (-x101 * x140 + x139 * x94 + x69 * (x139 * x56 - x140 * x63))
    )
    x149 = x14 * x145 + x148
    x150 = x145 * x15
    x151 = x139 * x83 - x140 * x86 + x69 * (x139 * x36 - x140 * x39)
    x152 = x13 * x151
    x153 = x14 * x151
    x154 = (
        x108 * x139
        - x111 * x140
        + x70 * (x139 * x86 - x140 * x92 + x69 * (x139 * x39 - x140 * x54))
    )
    x155 = x153 + x154
    x156 = (
        x128 * x139
        - x129 * x140
        + x14 * x154
        + x71
        * (
            x111 * x139
            - x114 * x140
            + x70 * (-x100 * x140 + x139 * x92 + x69 * (x139 * x54 - x140 * x62))
        )
    )
    x157 = x15 * x154
    x158 = (
        -x104 * x140
        + x106 * x139
        + x70 * (x139 * x79 - x140 * x84 + x69 * (x139 * x31 - x140 * x38))
    )
    x159 = x13 * x158
    x160 = x14 * x158
    x161 = (
        -x125 * x140
        + x127 * x139
        + x71
        * (
            x104 * x139
            - x109 * x140
            + x70 * (x139 * x84 - x140 * x90 + x69 * (x139 * x38 - x140 * x53))
        )
    )
    x162 = x160 + x161
    x163 = -x24 - A[2]
    x164 = x25 * x66
    x165 = x163 * x51 - x164 * x58
    x166 = x163 * x48 - x164 * x41
    x167 = x163 * x88 - x164 * x94
    x168 = x14 * x166 + x167
    x169 = -x102 * x164 + x163 * x97
    x170 = x69 * (x163 * x41 - x164 * x56)
    x171 = x15 * x166 + x170
    x172 = x69 * (x163 * x58 - x164 * x64)
    x173 = x112 * x163 - x116 * x164
    x174 = x14 * x167 + x173
    x175 = x69 * (-x101 * x164 + x163 * x94)
    x176 = x15 * x167 + x175
    x177 = 2 / x68**2
    x178 = x177 * (x163 * x56 - x164 * x63)
    x179 = x15 * x170 + x178
    x180 = x163 * x83 - x164 * x86
    x181 = x108 * x163 - x111 * x164
    x182 = x14 * x180 + x181
    x183 = x69 * (x163 * x86 - x164 * x92)
    x184 = x15 * x180 + x183
    x185 = x128 * x163 - x129 * x164 + x14 * x181
    x186 = x69 * (x111 * x163 - x114 * x164)
    x187 = x15 * x181 + x186
    x188 = x177 * (-x100 * x164 + x163 * x92)
    x189 = x15 * x183 + x188
    x190 = x69 * (x163 * x36 - x164 * x39)
    x191 = x14 * x190 + x183
    x192 = x177 * (x163 * x39 - x164 * x54)
    x193 = x15 * x190 + x192
    x194 = x14 * x183 + x186
    x195 = 6 / x68**3
    x196 = x15 * x192 + x195 * (x163 * x54 - x164 * x62)
    x197 = -x104 * x164 + x106 * x163
    x198 = -x125 * x164 + x127 * x163
    x199 = x14 * x197 + x198
    x200 = x69 * (x104 * x163 - x109 * x164)
    x201 = x15 * x197 + x200
    x202 = x69 * (x125 * x163 - x126 * x164)
    x203 = x177 * (x109 * x163 - x113 * x164)
    x204 = x15 * x200 + x203
    x205 = x69 * (x163 * x79 - x164 * x84)
    x206 = x14 * x205 + x200
    x207 = x177 * (x163 * x84 - x164 * x90)
    x208 = x15 * x205 + x207
    x209 = x15 * x207 + x195 * (x163 * x90 - x164 * x99)
    x210 = x177 * (x163 * x31 - x164 * x38)
    x211 = x14 * x210 + x207
    x212 = x195 * (x163 * x38 - x164 * x53)
    x213 = x15 * x210 + x212

    # 108 item(s)
    S = numpy.array(
        [
            x13 * x72
            + x13 * (x72 + x75)
            + x3 * x59
            - x65 * x67
            + x73
            * (
                x3 * x58
                - x64 * x67
                + x71
                * (
                    x3 * x56
                    - x63 * x67
                    + x70 * (x3 * x54 - x62 * x67 + x69 * (x3 * x53 - x61 * x67))
                )
            ),
            x103 + x13 * x96 + x14 * x72,
            x15 * x72 + x15 * x75,
            x118 + x14 * x96,
            x119 + x15 * x76,
            x16 * x74,
            x103 + x13 * x95 + x13 * (x121 + x95),
            x118 + x124 * x13,
            x119 + x121 * x15,
            x124 * x14 + x130,
            x122 * x15 + x131,
            x120 * x16,
            0,
            0,
            0,
            0,
            0,
            0,
            x117 + x123 * x13 + x13 * (x123 + x133),
            x13 * x136 + x130,
            x131 + x133 * x15,
            x135 * x14 + x136 * x14 + x137 * x3 - x138 * x67,
            x134 * x15 + x135 * x15,
            x132 * x16,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x141 + x13 * (x141 + x143) + x139 * x59 - x140 * x65,
            x13 * x146 + x14 * x141 + x147,
            x141 * x15 + x143 * x15,
            x14 * x146 + x149,
            x144 * x15 + x150,
            x142 * x16,
            x13 * x145 + x13 * (x145 + x152) + x147,
            x13 * x155 + x149,
            x15 * x152 + x150,
            x14 * x155 + x156,
            x15 * x153 + x157,
            x151 * x16,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x154 + x13 * (x154 + x159) + x148,
            x13 * x162 + x156,
            x15 * x159 + x157,
            x137 * x139
            - x138 * x140
            + x14 * x161
            + x14 * x162
            + x73
            * (
                x125 * x139
                - x126 * x140
                + x71
                * (
                    x109 * x139
                    - x113 * x140
                    + x70 * (x139 * x90 - x140 * x99 + x69 * (x139 * x53 - x140 * x61))
                )
            ),
            x15 * x160 + x15 * x161,
            x158 * x16,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x165 + x13 * (x13 * x166 + x165) + x163 * x59 - x164 * x65,
            x13 * x168 + x14 * x165 + x169,
            x13 * x171 + x15 * x165 + x172,
            x14 * x168 + x174,
            x14 * x171 + x176,
            x15 * x171 + x179,
            x13 * x167 + x13 * (x13 * x180 + x167) + x169,
            x13 * x182 + x174,
            x13 * x184 + x176,
            x14 * x182 + x185,
            x14 * x184 + x187,
            x15 * x184 + x189,
            x13 * x170 + x13 * (x13 * x190 + x170) + x172,
            x13 * x191 + x14 * x170 + x175,
            x13 * x193 + x179,
            x14 * x191 + x194,
            x14 * x193 + x189,
            x15 * x193 + x196,
            x13 * x181 + x13 * (x13 * x197 + x181) + x173,
            x13 * x199 + x185,
            x13 * x201 + x187,
            x137 * x163 - x138 * x164 + x14 * x198 + x14 * x199,
            x14 * x201 + x15 * x198 + x202,
            x15 * x201 + x204,
            x13 * x183 + x13 * (x13 * x205 + x183) + x175,
            x13 * x206 + x194,
            x13 * x208 + x189,
            x14 * x200 + x14 * x206 + x202,
            x14 * x208 + x204,
            x15 * x208 + x209,
            x13 * x192 + x13 * (x13 * x210 + x192) + x178,
            x13 * x211 + x14 * x192 + x188,
            x13 * x213 + x196,
            x14 * x207 + x14 * x211 + x203,
            x14 * x213 + x209,
            x15 * x212 + x15 * x213 + 24 * (x163 * x53 - x164 * x61) / x68**4,
        ]
    )
    return S


def eri_1100(a, A, b, B, c, C, d, D):
    """Cartesian [pp|ss] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = numpy.pi**2.5
    x1 = a + b
    x2 = c + d
    x3 = x1 * x2
    x4 = x1 + x2
    x5 = (x3 + numpy.sqrt(x4)) ** (-1.0)
    x6 = x1 ** (-1.0)
    x7 = A[0] - B[0]
    x8 = A[1] - B[1]
    x9 = A[2] - B[2]
    x10 = numpy.exp(-a * b * x6 * (x7**2 + x8**2 + x9**2))
    x11 = x2 ** (-1.0)
    x12 = numpy.exp(
        -c * d * x11 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x13 = x4 ** (-1.0)
    x14 = -x6 * (a * A[0] + b * B[0])
    x15 = -x11 * (c * C[0] + d * D[0]) - x14
    x16 = -x6 * (a * A[1] + b * B[1])
    x17 = -x11 * (c * C[1] + d * D[1]) - x16
    x18 = -x6 * (a * A[2] + b * B[2])
    x19 = -x11 * (c * C[2] + d * D[2]) - x18
    x20 = x13 * x3 * (x15**2 + x17**2 + x19**2)
    x21 = boys(0, x20)
    x22 = x13 * x2
    x23 = 2 * x0 * x10 * x12 * x5
    x24 = x23 * boys(1, x20)
    x25 = (2 * x0 * x10 * x12 * x21 * x5 - x22 * x24) / (2 * a + 2 * b)
    x26 = -x14 - A[0]
    x27 = x21 * x23
    x28 = x15 * x22
    x29 = -x24 * x28 + x26 * x27
    x30 = x23 * boys(2, x20)
    x31 = -x16 - A[1]
    x32 = x17 * x22
    x33 = -x24 * x32 + x27 * x31
    x34 = x24 * x31 - x30 * x32
    x35 = x26 * x33 - x28 * x34
    x36 = -x18 - A[2]
    x37 = x19 * x22
    x38 = -x24 * x37 + x27 * x36
    x39 = x24 * x36 - x30 * x37
    x40 = x26 * x38 - x28 * x39
    x41 = x31 * x38 - x32 * x39

    # 9 item(s)
    S = numpy.array(
        [
            x25 + x26 * x29 - x28 * (x24 * x26 - x28 * x30) + x29 * x7,
            x29 * x8 + x35,
            x29 * x9 + x40,
            x33 * x7 + x35,
            x25 + x31 * x33 - x32 * x34 + x33 * x8,
            x33 * x9 + x41,
            x38 * x7 + x40,
            x38 * x8 + x41,
            x25 + x36 * x38 - x37 * x39 + x38 * x9,
        ]
    )
    return S


def eri_1101(a, A, b, B, c, C, d, D):
    """Cartesian [pp|sp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(1, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x9 * (x22**2 + x23**2 + x24**2))
    x26 = C[0] - D[0]
    x27 = C[1] - D[1]
    x28 = C[2] - D[2]
    x29 = numpy.exp(-c * d * x3 * (x26**2 + x27**2 + x28**2))
    x30 = 2 * x20 * x21 * x25 * x29
    x31 = x19 * x30
    x32 = x30 * boys(2, x18)
    x33 = x6 * x8
    x34 = x11 * x33
    x35 = x31 * x5 + x32 * x34
    x36 = x2 * x8
    x37 = x35 * x36
    x38 = boys(0, x18)
    x39 = x30 * x38
    x40 = x31 * x34 + x39 * x5
    x41 = x1 * (-x37 + x40)
    x42 = x1 * (2 * x20 * x21 * x25 * x29 * x38 - x31 * x36)
    x43 = -x10 - A[0]
    x44 = x11 * x36
    x45 = -x31 * x44 + x39 * x43
    x46 = x31 * x43 - x32 * x44
    x47 = x42 + x43 * x45 - x44 * x46
    x48 = (2 * c + 2 * d + x0) ** (-1.0)
    x49 = x1 * (2 * x19 * x20 * x21 * x25 * x29 - x32 * x36)
    x50 = x30 * boys(3, x18)
    x51 = x32 * x43 - x44 * x50
    x52 = -x11 * x37 + x40 * x43 + x46 * x48
    x53 = x32 * x5 + x34 * x50
    x54 = x26 * x45 + x52
    x55 = x12 - C[1]
    x56 = x14 * x33
    x57 = x31 * x55 + x32 * x56
    x58 = x36 * x57
    x59 = x31 * x56 + x39 * x55
    x60 = x1 * (-x58 + x59)
    x61 = -x11 * x58 + x43 * x59
    x62 = x32 * x55 + x50 * x56
    x63 = x27 * x45 + x61
    x64 = x28 * x45
    x65 = -x13 - A[1]
    x66 = x14 * x36
    x67 = x31 * x65 - x32 * x66
    x68 = x32 * x65 - x50 * x66
    x69 = -x31 * x66 + x39 * x65
    x70 = x43 * x69 - x44 * x67
    x71 = -x14 * x37 + x40 * x65
    x72 = x35 * x65 - x53 * x66
    x73 = x26 * x70 + x43 * x71 - x44 * x72 + x48 * (x43 * x67 - x44 * x68)
    x74 = -x14 * x58 + x48 * x67 + x59 * x65
    x75 = x48 * x68 + x57 * x65 - x62 * x66
    x76 = x27 * x70 + x43 * x74 - x44 * x75
    x77 = x28 * x70
    x78 = -x15 - A[2]
    x79 = x16 * x36
    x80 = x31 * x78 - x32 * x79
    x81 = x43 * x80
    x82 = x32 * x78 - x50 * x79
    x83 = x44 * x82
    x84 = -x31 * x79 + x39 * x78
    x85 = x43 * x84 - x44 * x80
    x86 = -x16 * x37 + x40 * x78
    x87 = x35 * x78 - x53 * x79
    x88 = x26 * x85 + x43 * x86 - x44 * x87 + x48 * (x81 - x83)
    x89 = -x16 * x58 + x59 * x78
    x90 = x57 * x78 - x62 * x79
    x91 = x27 * x85 + x43 * x89 - x44 * x90
    x92 = x28 * x85 + x48 * x81 - x48 * x83
    x93 = x26 * x69 + x71
    x94 = x27 * x69 + x74
    x95 = x28 * x69
    x96 = x42 + x65 * x69 - x66 * x67
    x97 = x65 * x84 - x66 * x80
    x98 = x26 * x97 + x65 * x86 - x66 * x87
    x99 = x65 * x80
    x100 = x66 * x82
    x101 = x27 * x97 + x48 * (-x100 + x99) + x65 * x89 - x66 * x90
    x102 = -x100 * x48 + x28 * x97 + x48 * x99
    x103 = x26 * x84 + x86
    x104 = x27 * x84 + x89
    x105 = x48 * x80
    x106 = x105 + x28 * x84
    x107 = x42 + x78 * x84 - x79 * x80
    x108 = x79 * x82

    # 27 item(s)
    S = numpy.array(
        [
            x22 * x54
            + x26 * x47
            + x41
            + x43 * x52
            - x44 * (x35 * x43 - x44 * x53 + x48 * x51)
            + x48 * (x43 * x46 - x44 * x51 + x49),
            x22 * x63 + x27 * x47 + x43 * x61 - x44 * (x43 * x57 - x44 * x62) + x60,
            x22 * x64 + x28 * x47,
            x23 * x54 + x73,
            x23 * x63 + x76,
            x23 * x64 + x77,
            x24 * x54 + x88,
            x24 * x63 + x91,
            x24 * x64 + x92,
            x22 * x93 + x73,
            x22 * x94 + x76,
            x22 * x95 + x77,
            x23 * x93 + x26 * x96 + x41 + x65 * x71 - x66 * x72,
            x23 * x94
            + x27 * x96
            + x48 * (x49 + x65 * x67 - x66 * x68)
            + x60
            + x65 * x74
            - x66 * x75,
            x23 * x95 + x28 * x96,
            x24 * x93 + x98,
            x101 + x24 * x94,
            x102 + x24 * x95,
            x103 * x22 + x88,
            x104 * x22 + x91,
            x106 * x22 + x92,
            x103 * x23 + x98,
            x101 + x104 * x23,
            x102 + x106 * x23,
            x103 * x24 + x107 * x26 + x41 + x78 * x86 - x79 * x87,
            x104 * x24 + x107 * x27 + x60 + x78 * x89 - x79 * x90,
            x105 * x78
            + x106 * x24
            + x107 * x28
            - x108 * x48
            + x48 * (-x108 + x49 + x78 * x80),
        ]
    )
    return S


def eri_1102(a, A, b, B, c, C, d, D):
    """Cartesian [pp|sd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x10 * (x11**2 + x12**2 + x13**2))
    x15 = x6 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x8 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x10 * (a * A[0] + b * B[0])
    x24 = -x22 - x23
    x25 = x15 * (c * C[1] + d * D[1])
    x26 = -x10 * (a * A[1] + b * B[1])
    x27 = -x25 - x26
    x28 = -x10 * (a * A[2] + b * B[2])
    x29 = -x15 * (c * C[2] + d * D[2]) - x28
    x30 = x21 * x7 * (x24**2 + x27**2 + x29**2)
    x31 = boys(1, x30)
    x32 = -2 * x14 * x20 * x31 * x4 * x9
    x33 = x21 * x5
    x34 = boys(2, x30)
    x35 = 2 * x14 * x20 * x4 * x9
    x36 = x34 * x35
    x37 = x3 * (-x32 - x33 * x36)
    x38 = x22 - C[0]
    x39 = x31 * x35
    x40 = x24 * x33
    x41 = x36 * x40 + x38 * x39
    x42 = x35 * boys(3, x30)
    x43 = x36 * x38 + x40 * x42
    x44 = x37 + x38 * x41 + x40 * x43
    x45 = x21 * x6
    x46 = x44 * x45
    x47 = boys(0, x30)
    x48 = -2 * x14 * x20 * x4 * x47 * x9
    x49 = x3 * (-x33 * x39 - x48)
    x50 = x35 * x47
    x51 = x38 * x50 + x39 * x40
    x52 = x38 * x51 + x40 * x41 + x49
    x53 = x1 * (-x46 + x52)
    x54 = -x23 - A[0]
    x55 = x0 + x2
    x56 = x55 ** (-1.0)
    x57 = x24 * x45
    x58 = x36 * x54 - x42 * x57
    x59 = x43 * x45
    x60 = -x24 * x59 + x41 * x54 + x56 * x58
    x61 = 2 * x56
    x62 = -x24 * x46 + x52 * x54 + x60 * x61
    x63 = -2 * x14 * x20 * x34 * x4 * x9
    x64 = x3 * (-x33 * x42 - x63)
    x65 = x35 * boys(4, x30)
    x66 = x38 * x42 + x40 * x65
    x67 = x38 * x43 + x40 * x66 + x64
    x68 = x42 * x54 - x57 * x65
    x69 = x43 * x54 + x56 * x68 - x57 * x66
    x70 = x41 * x45
    x71 = x1 * (x51 - x70)
    x72 = x1 * (-x32 - x36 * x45)
    x73 = -x36 * x57 + x39 * x54
    x74 = -x24 * x70 + x51 * x54 + x56 * x73
    x75 = x54 * x74 + x56 * (x54 * x73 - x57 * x58 + x72) - x57 * x60 + x71
    x76 = x1 * (x41 - x59)
    x77 = x1 * (-x42 * x45 - x63)
    x78 = x1 * (-x39 * x45 - x48)
    x79 = -x39 * x57 + x50 * x54
    x80 = x54 * x79 - x57 * x73 + x78
    x81 = x16 * x80
    x82 = x16 * x79
    x83 = x16 * x74 + x16 * (x74 + x82) + x62
    x84 = x25 - C[1]
    x85 = x27 * x33
    x86 = x36 * x85 + x39 * x84
    x87 = x36 * x84 + x42 * x85
    x88 = x38 * x86 + x40 * x87
    x89 = x45 * x88
    x90 = x39 * x85 + x50 * x84
    x91 = x38 * x90 + x40 * x86
    x92 = x1 * (-x89 + x91)
    x93 = x45 * x87
    x94 = x1 * (x86 - x93)
    x95 = -x24 * x93 + x54 * x86
    x96 = x42 * x84 + x65 * x85
    x97 = x54 * x87 - x57 * x96
    x98 = -x24 * x89 + x54 * x91 + x56 * x95
    x99 = x38 * x87 + x40 * x96
    x100 = x17 * x80
    x101 = x45 * x86
    x102 = x1 * (-x101 + x90)
    x103 = -x101 * x24 + x54 * x90
    x104 = x102 + x103 * x54 - x57 * x95
    x105 = x100 + x104
    x106 = x17 * x79
    x107 = x103 + x106
    x108 = x107 * x16 + x17 * x74 + x98
    x109 = x18 * x74 + x18 * x82
    x110 = x37 + x84 * x86 + x85 * x87
    x111 = x110 * x45
    x112 = x49 + x84 * x90 + x85 * x86
    x113 = x1 * (-x111 + x112)
    x114 = -x111 * x24 + x112 * x54
    x115 = x64 + x84 * x87 + x85 * x96
    x116 = x103 * x17 + x107 * x17 + x114
    x117 = x103 * x18 + x106 * x18
    x118 = x19 * x79
    x119 = -x26 - A[1]
    x120 = x27 * x45
    x121 = x119 * x39 - x120 * x36
    x122 = x119 * x36 - x120 * x42
    x123 = x119 * x51 - x27 * x70
    x124 = x119 * x41 - x27 * x59
    x125 = x123 * x54 - x124 * x57 + x56 * (x121 * x54 - x122 * x57)
    x126 = x119 * x50 - x120 * x39
    x127 = -x121 * x57 + x126 * x54
    x128 = x127 * x16
    x129 = x119 * x52 - x27 * x46
    x130 = x119 * x42 - x120 * x65
    x131 = x119 * x43 - x120 * x66
    x132 = x119 * x44 - x120 * x67
    x133 = (
        x125 * x16
        + x129 * x54
        - x132 * x57
        + x16 * (x125 + x128)
        + x61 * (x124 * x54 - x131 * x57 + x56 * (x122 * x54 - x130 * x57))
    )
    x134 = x119 * x86 + x122 * x56 - x27 * x93
    x135 = x119 * x87 - x120 * x96 + x130 * x56
    x136 = x127 * x17
    x137 = -x101 * x27 + x119 * x90 + x121 * x56
    x138 = -x134 * x57 + x137 * x54
    x139 = x136 + x138
    x140 = x119 * x91 + x124 * x56 - x27 * x89
    x141 = x119 * x88 - x120 * x99 + x131 * x56
    x142 = (
        x125 * x17
        + x139 * x16
        + x140 * x54
        - x141 * x57
        + x56 * (x134 * x54 - x135 * x57)
    )
    x143 = x125 * x18 + x128 * x18
    x144 = -x111 * x27 + x112 * x119 + x134 * x61
    x145 = x110 * x119 - x115 * x120 + x135 * x61
    x146 = x138 * x17 + x139 * x17 + x144 * x54 - x145 * x57
    x147 = x136 * x18 + x138 * x18
    x148 = x127 * x19
    x149 = -x28 - A[2]
    x150 = x29 * x45
    x151 = x149 * x39 - x150 * x36
    x152 = x151 * x54
    x153 = x149 * x36 - x150 * x42
    x154 = x153 * x57
    x155 = x149 * x51 - x29 * x70
    x156 = x149 * x41 - x29 * x59
    x157 = x155 * x54 - x156 * x57 + x56 * (x152 - x154)
    x158 = x149 * x50 - x150 * x39
    x159 = -x151 * x57 + x158 * x54
    x160 = x149 * x52 - x29 * x46
    x161 = x153 * x54
    x162 = x149 * x42 - x150 * x65
    x163 = x162 * x57
    x164 = x156 * x54
    x165 = x149 * x43 - x150 * x66
    x166 = x165 * x57
    x167 = x149 * x44 - x150 * x67
    x168 = (
        x157 * x16
        + x16 * (x157 + x159 * x16)
        + x160 * x54
        - x167 * x57
        + x61 * (x164 - x166 + x56 * (x161 - x163))
    )
    x169 = x149 * x86 - x29 * x93
    x170 = x169 * x54
    x171 = x149 * x87 - x150 * x96
    x172 = x171 * x57
    x173 = -x101 * x29 + x149 * x90
    x174 = -x169 * x57 + x173 * x54
    x175 = x159 * x17 + x174
    x176 = x149 * x91 - x29 * x89
    x177 = x149 * x88 - x150 * x99
    x178 = x157 * x17 + x16 * x175 + x176 * x54 - x177 * x57 + x56 * (x170 - x172)
    x179 = x152 * x56 - x154 * x56
    x180 = x159 * x18 + x179
    x181 = (
        x157 * x18
        + x16 * x180
        + x164 * x56
        - x166 * x56
        + x56 * (x161 * x56 - x163 * x56)
    )
    x182 = -x111 * x29 + x112 * x149
    x183 = x110 * x149 - x115 * x150
    x184 = x17 * x174 + x17 * x175 + x182 * x54 - x183 * x57
    x185 = x17 * x180 + x170 * x56 - x172 * x56 + x174 * x18
    x186 = 2 / x55**2
    x187 = x161 * x186 - x163 * x186 + x179 * x18 + x18 * x180
    x188 = x126 * x16
    x189 = x123 * x16 + x129 + x16 * (x123 + x188)
    x190 = x126 * x17
    x191 = x137 + x190
    x192 = x123 * x17 + x140 + x16 * x191
    x193 = x123 * x18 + x18 * x188
    x194 = x137 * x17 + x144 + x17 * x191
    x195 = x137 * x18 + x18 * x190
    x196 = x126 * x19
    x197 = x119 * x123 - x120 * x124 + x71
    x198 = x119 * x126 - x120 * x121 + x78
    x199 = x16 * x198
    x200 = x17 * x198
    x201 = x102 + x119 * x137 - x120 * x134 + x56 * (x119 * x121 - x120 * x122 + x72)
    x202 = x200 + x201
    x203 = x119 * x155 - x120 * x156
    x204 = x119 * x158 - x120 * x151
    x205 = x119 * x160 - x120 * x167 + x16 * x203 + x16 * (x16 * x204 + x203)
    x206 = x119 * x156
    x207 = x120 * x165
    x208 = x119 * x151
    x209 = x120 * x153
    x210 = x119 * x173 - x120 * x169 + x56 * (x208 - x209)
    x211 = x17 * x204 + x210
    x212 = x119 * x176 - x120 * x177 + x16 * x211 + x17 * x203 + x56 * (x206 - x207)
    x213 = x208 * x56 - x209 * x56
    x214 = x18 * x204 + x213
    x215 = x16 * x214 + x18 * x203 + x206 * x56 - x207 * x56
    x216 = x119 * x153
    x217 = x120 * x162
    x218 = x119 * x169
    x219 = x120 * x171
    x220 = (
        x119 * x182
        - x120 * x183
        + x17 * x210
        + x17 * x211
        + x61 * (x218 - x219 + x56 * (x216 - x217))
    )
    x221 = (
        x17 * x214
        + x18 * x210
        + x218 * x56
        - x219 * x56
        + x56 * (x216 * x56 - x217 * x56)
    )
    x222 = x18 * x213 + x18 * x214 + x186 * x216 - x186 * x217
    x223 = x155 * x16 + x16 * (x155 + x158 * x16) + x160
    x224 = x158 * x17 + x173
    x225 = x155 * x17 + x16 * x224 + x176
    x226 = x151 * x56
    x227 = x158 * x18 + x226
    x228 = x156 * x56
    x229 = x155 * x18 + x16 * x227 + x228
    x230 = x17 * x173 + x17 * x224 + x182
    x231 = x169 * x56
    x232 = x17 * x227 + x173 * x18 + x231
    x233 = x153 * x186 + x18 * x226 + x18 * x227
    x234 = x149 * x155 - x150 * x156 + x71
    x235 = x149 * x158 - x150 * x151 + x78
    x236 = x102 + x149 * x173 - x150 * x169
    x237 = x17 * x235 + x236
    x238 = x150 * x165
    x239 = x150 * x153
    x240 = x149 * x226 - x239 * x56 + x56 * (x149 * x151 - x239 + x72)
    x241 = x18 * x235 + x240
    x242 = x150 * x171
    x243 = x149 * x153
    x244 = x150 * x162

    # 54 item(s)
    S = numpy.array(
        [
            x11 * x83
            + x16 * x75
            + x16 * (x75 + x81)
            + x53
            + x54 * x62
            - x57 * (x44 * x54 - x57 * x67 + x61 * x69)
            + x61 * (x54 * x60 + x56 * (x54 * x58 - x57 * x68 + x77) - x57 * x69 + x76),
            x105 * x16
            + x108 * x11
            + x17 * x75
            + x54 * x98
            + x56 * (x54 * x95 - x57 * x97 + x94)
            - x57 * (x54 * x88 + x56 * x97 - x57 * x99)
            + x92,
            x109 * x11 + x18 * x75 + x18 * x81,
            x104 * x17
            + x105 * x17
            + x11 * x116
            + x113
            + x114 * x54
            - x57 * (x110 * x54 - x115 * x57),
            x100 * x18 + x104 * x18 + x11 * x117,
            x11 * x118 + x19 * x80,
            x12 * x83 + x133,
            x108 * x12 + x142,
            x109 * x12 + x143,
            x116 * x12 + x146,
            x117 * x12 + x147,
            x118 * x12 + x148,
            x13 * x83 + x168,
            x108 * x13 + x178,
            x109 * x13 + x181,
            x116 * x13 + x184,
            x117 * x13 + x185,
            x118 * x13 + x187,
            x11 * x189 + x133,
            x11 * x192 + x142,
            x11 * x193 + x143,
            x11 * x194 + x146,
            x11 * x195 + x147,
            x11 * x196 + x148,
            x119 * x129
            + x12 * x189
            - x120 * x132
            + x16 * x197
            + x16 * (x197 + x199)
            + x53,
            x119 * x140
            + x12 * x192
            - x120 * x141
            + x16 * x202
            + x17 * x197
            + x56 * (x119 * x124 - x120 * x131 + x76)
            + x92,
            x12 * x193 + x18 * x197 + x18 * x199,
            x113
            + x119 * x144
            + x12 * x194
            - x120 * x145
            + x17 * x201
            + x17 * x202
            + x61
            * (x119 * x134 - x120 * x135 + x56 * (x119 * x122 - x120 * x130 + x77) + x94),
            x12 * x195 + x18 * x200 + x18 * x201,
            x12 * x196 + x19 * x198,
            x13 * x189 + x205,
            x13 * x192 + x212,
            x13 * x193 + x215,
            x13 * x194 + x220,
            x13 * x195 + x221,
            x13 * x196 + x222,
            x11 * x223 + x168,
            x11 * x225 + x178,
            x11 * x229 + x181,
            x11 * x230 + x184,
            x11 * x232 + x185,
            x11 * x233 + x187,
            x12 * x223 + x205,
            x12 * x225 + x212,
            x12 * x229 + x215,
            x12 * x230 + x220,
            x12 * x232 + x221,
            x12 * x233 + x222,
            x13 * x223
            + x149 * x160
            - x150 * x167
            + x16 * x234
            + x16 * (x16 * x235 + x234)
            + x53,
            x13 * x225 + x149 * x176 - x150 * x177 + x16 * x237 + x17 * x234 + x92,
            x13 * x229
            + x149 * x228
            + x16 * x241
            + x18 * x234
            - x238 * x56
            + x56 * (x149 * x156 - x238 + x76),
            x113 + x13 * x230 + x149 * x182 - x150 * x183 + x17 * x236 + x17 * x237,
            x13 * x232
            + x149 * x231
            + x17 * x241
            + x18 * x236
            - x242 * x56
            + x56 * (x149 * x169 - x242 + x94),
            x13 * x233
            + x18 * x240
            + x18 * x241
            + x186 * x243
            - x186 * x244
            + x61 * (x243 * x56 - x244 * x56 + x56 * (x243 - x244 + x77)),
        ]
    )
    return S


def eri_1110(a, A, b, B, c, C, d, D):
    """Cartesian [pp|ps] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(1, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x9 * (x22**2 + x23**2 + x24**2))
    x26 = numpy.exp(
        -c * d * x3 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x27 = 2 * x20 * x21 * x25 * x26
    x28 = x19 * x27
    x29 = boys(2, x18)
    x30 = x27 * x29
    x31 = x6 * x8
    x32 = x11 * x31
    x33 = x28 * x5 + x30 * x32
    x34 = x2 * x8
    x35 = x33 * x34
    x36 = boys(0, x18)
    x37 = x27 * x5
    x38 = x28 * x32 + x36 * x37
    x39 = x1 * (-x35 + x38)
    x40 = (2 * c + 2 * d + x0) ** (-1.0)
    x41 = x1 * (2 * x19 * x20 * x21 * x25 * x26 - x30 * x34)
    x42 = -x10 - A[0]
    x43 = x11 * x34
    x44 = x28 * x42 - x30 * x43
    x45 = x27 * boys(3, x18)
    x46 = x30 * x42 - x43 * x45
    x47 = -x11 * x35 + x38 * x42 + x40 * x44
    x48 = x29 * x37 + x32 * x45
    x49 = x12 - C[1]
    x50 = x14 * x31
    x51 = x28 * x49 + x30 * x50
    x52 = x34 * x51
    x53 = x27 * x36 * x49 + x28 * x50
    x54 = x1 * (-x52 + x53)
    x55 = -x11 * x52 + x42 * x53
    x56 = x30 * x49 + x45 * x50
    x57 = -x13 - A[1]
    x58 = x14 * x34
    x59 = x28 * x57 - x30 * x58
    x60 = x30 * x57 - x45 * x58
    x61 = -x14 * x35 + x38 * x57
    x62 = x33 * x57 - x48 * x58
    x63 = x40 * (x42 * x59 - x43 * x60) + x42 * x61 - x43 * x62
    x64 = -x14 * x52 + x40 * x59 + x53 * x57
    x65 = x40 * x60 + x51 * x57 - x56 * x58
    x66 = x42 * x64 - x43 * x65
    x67 = -x15 - A[2]
    x68 = x16 * x34
    x69 = x28 * x67 - x30 * x68
    x70 = x42 * x69
    x71 = x30 * x67 - x45 * x68
    x72 = x43 * x71
    x73 = -x16 * x35 + x38 * x67
    x74 = x33 * x67 - x48 * x68
    x75 = x40 * (x70 - x72) + x42 * x73 - x43 * x74
    x76 = -x16 * x52 + x53 * x67
    x77 = x51 * x67 - x56 * x68
    x78 = x42 * x76 - x43 * x77
    x79 = x40 * x70 - x40 * x72
    x80 = x57 * x73 - x58 * x74
    x81 = x57 * x69
    x82 = x58 * x71
    x83 = x40 * (x81 - x82) + x57 * x76 - x58 * x77
    x84 = x40 * x81 - x40 * x82
    x85 = x40 * x69
    x86 = x67 * x69
    x87 = x68 * x71

    # 27 item(s)
    S = numpy.array(
        [
            x22 * x47
            + x39
            + x40 * (x41 + x42 * x44 - x43 * x46)
            + x42 * x47
            - x43 * (x33 * x42 + x40 * x46 - x43 * x48),
            x22 * x55 + x42 * x55 - x43 * (x42 * x51 - x43 * x56) + x54,
            0,
            x23 * x47 + x63,
            x23 * x55 + x66,
            0,
            x24 * x47 + x75,
            x24 * x55 + x78,
            x79,
            x22 * x61 + x63,
            x22 * x64 + x66,
            0,
            x23 * x61 + x39 + x57 * x61 - x58 * x62,
            x23 * x64 + x40 * (x41 + x57 * x59 - x58 * x60) + x54 + x57 * x64 - x58 * x65,
            0,
            x24 * x61 + x80,
            x24 * x64 + x83,
            x84,
            x22 * x73 + x75,
            x22 * x76 + x78,
            x22 * x85 + x79,
            x23 * x73 + x80,
            x23 * x76 + x83,
            x23 * x85 + x84,
            x24 * x73 + x39 + x67 * x73 - x68 * x74,
            x24 * x76 + x54 + x67 * x76 - x68 * x77,
            x24 * x85 + x40 * x86 - x40 * x87 + x40 * (x41 + x86 - x87),
        ]
    )
    return S


def eri_1111(a, A, b, B, c, C, d, D):
    """Cartesian [pp|pp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x10 * (x11**2 + x12**2 + x13**2))
    x15 = x6 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x18**2))
    x20 = x8 ** (-1.0)
    x21 = x15 * (c * C[0] + d * D[0])
    x22 = -x10 * (a * A[0] + b * B[0])
    x23 = -x21 - x22
    x24 = x15 * (c * C[1] + d * D[1])
    x25 = -x10 * (a * A[1] + b * B[1])
    x26 = -x24 - x25
    x27 = -x10 * (a * A[2] + b * B[2])
    x28 = -x15 * (c * C[2] + d * D[2]) - x27
    x29 = x20 * x7 * (x23**2 + x26**2 + x28**2)
    x30 = boys(1, x29)
    x31 = -2 * x14 * x19 * x30 * x4 * x9
    x32 = x20 * x5
    x33 = boys(2, x29)
    x34 = 2 * x14 * x19 * x4 * x9
    x35 = x33 * x34
    x36 = x3 * (-x31 - x32 * x35)
    x37 = x21 - C[0]
    x38 = x30 * x34
    x39 = x23 * x32
    x40 = x35 * x39 + x37 * x38
    x41 = x34 * boys(3, x29)
    x42 = x35 * x37 + x39 * x41
    x43 = x36 + x37 * x40 + x39 * x42
    x44 = x20 * x6
    x45 = x43 * x44
    x46 = boys(0, x29)
    x47 = x3 * (2 * x14 * x19 * x4 * x46 * x9 - x32 * x38)
    x48 = x34 * x46
    x49 = x37 * x48 + x38 * x39
    x50 = x37 * x49 + x39 * x40 + x47
    x51 = x1 * (-x45 + x50)
    x52 = -x22 - A[0]
    x53 = x0 + x2
    x54 = x53 ** (-1.0)
    x55 = x23 * x44
    x56 = x35 * x52 - x41 * x55
    x57 = x42 * x44
    x58 = -x23 * x57 + x40 * x52 + x54 * x56
    x59 = 2 * x54
    x60 = -x23 * x45 + x50 * x52 + x58 * x59
    x61 = -2 * x14 * x19 * x33 * x4 * x9
    x62 = x3 * (-x32 * x41 - x61)
    x63 = x34 * boys(4, x29)
    x64 = x37 * x41 + x39 * x63
    x65 = x37 * x42 + x39 * x64 + x62
    x66 = x41 * x52 - x55 * x63
    x67 = x42 * x52 + x54 * x66 - x55 * x64
    x68 = x40 * x44
    x69 = x1 * (x49 - x68)
    x70 = x1 * (-x31 - x35 * x44)
    x71 = -x35 * x55 + x38 * x52
    x72 = -x23 * x68 + x49 * x52 + x54 * x71
    x73 = x52 * x72 + x54 * (x52 * x71 - x55 * x56 + x70) - x55 * x58 + x69
    x74 = x1 * (x40 - x57)
    x75 = x1 * (-x41 * x44 - x61)
    x76 = x16 * x72 + x60
    x77 = x24 - C[1]
    x78 = x26 * x32
    x79 = x35 * x78 + x38 * x77
    x80 = x35 * x77 + x41 * x78
    x81 = x44 * x80
    x82 = -x23 * x81 + x52 * x79
    x83 = x38 * x78 + x48 * x77
    x84 = x37 * x83 + x39 * x79
    x85 = x37 * x79 + x39 * x80
    x86 = x44 * x85
    x87 = -x23 * x86 + x52 * x84 + x54 * x82
    x88 = x17 * x72 + x87
    x89 = x1 * (x84 - x86)
    x90 = x1 * (x79 - x81)
    x91 = x41 * x77 + x63 * x78
    x92 = x52 * x80 - x55 * x91
    x93 = x37 * x80 + x39 * x91
    x94 = (
        x52 * x87
        + x54 * (x52 * x82 - x55 * x92 + x90)
        - x55 * (x52 * x85 + x54 * x92 - x55 * x93)
        + x89
    )
    x95 = x11 * x18
    x96 = x44 * x79
    x97 = -x23 * x96 + x52 * x83
    x98 = x16 * x97 + x87
    x99 = x1 * (x83 - x96)
    x100 = x52 * x97 - x55 * x82 + x99
    x101 = x36 + x77 * x79 + x78 * x80
    x102 = x101 * x44
    x103 = x47 + x77 * x83 + x78 * x79
    x104 = x1 * (-x102 + x103)
    x105 = -x102 * x23 + x103 * x52
    x106 = x62 + x77 * x80 + x78 * x91
    x107 = x105 + x17 * x97
    x108 = -x25 - A[1]
    x109 = x26 * x44
    x110 = x108 * x38 - x109 * x35
    x111 = x108 * x35 - x109 * x41
    x112 = x108 * x49 - x26 * x68
    x113 = x108 * x40 - x26 * x57
    x114 = x112 * x52 - x113 * x55 + x54 * (x110 * x52 - x111 * x55)
    x115 = x108 * x50 - x26 * x45
    x116 = x108 * x41 - x109 * x63
    x117 = x108 * x42 - x109 * x64
    x118 = x108 * x43 - x109 * x65
    x119 = (
        x114 * x16
        + x115 * x52
        - x118 * x55
        + x59 * (x113 * x52 - x117 * x55 + x54 * (x111 * x52 - x116 * x55))
    )
    x120 = x108 * x79 + x111 * x54 - x26 * x81
    x121 = x108 * x80 - x109 * x91 + x116 * x54
    x122 = x108 * x84 + x113 * x54 - x26 * x86
    x123 = x108 * x85 - x109 * x93 + x117 * x54
    x124 = x122 * x52 - x123 * x55 + x54 * (x120 * x52 - x121 * x55)
    x125 = x114 * x17 + x124
    x126 = x12 * x18
    x127 = x114 * x18
    x128 = x108 * x83 + x110 * x54 - x26 * x96
    x129 = -x120 * x55 + x128 * x52
    x130 = x124 + x129 * x16
    x131 = -x102 * x26 + x103 * x108 + x120 * x59
    x132 = x101 * x108 - x106 * x109 + x121 * x59
    x133 = x129 * x17 + x131 * x52 - x132 * x55
    x134 = x129 * x18
    x135 = -x27 - A[2]
    x136 = x28 * x44
    x137 = x135 * x38 - x136 * x35
    x138 = x137 * x52
    x139 = x135 * x35 - x136 * x41
    x140 = x139 * x55
    x141 = x135 * x49 - x28 * x68
    x142 = x135 * x40 - x28 * x57
    x143 = x141 * x52 - x142 * x55 + x54 * (x138 - x140)
    x144 = x135 * x50 - x28 * x45
    x145 = x139 * x52
    x146 = x135 * x41 - x136 * x63
    x147 = x146 * x55
    x148 = x142 * x52
    x149 = x135 * x42 - x136 * x64
    x150 = x149 * x55
    x151 = x135 * x43 - x136 * x65
    x152 = (
        x143 * x16 + x144 * x52 - x151 * x55 + x59 * (x148 - x150 + x54 * (x145 - x147))
    )
    x153 = x135 * x79 - x28 * x81
    x154 = x153 * x52
    x155 = x135 * x80 - x136 * x91
    x156 = x155 * x55
    x157 = x135 * x84 - x28 * x86
    x158 = x135 * x85 - x136 * x93
    x159 = x157 * x52 - x158 * x55 + x54 * (x154 - x156)
    x160 = x143 * x17 + x159
    x161 = x13 * x18
    x162 = x148 * x54 - x150 * x54 + x54 * (x145 * x54 - x147 * x54)
    x163 = x143 * x18 + x162
    x164 = x135 * x83 - x28 * x96
    x165 = -x153 * x55 + x164 * x52
    x166 = x159 + x16 * x165
    x167 = -x102 * x28 + x103 * x135
    x168 = x101 * x135 - x106 * x136
    x169 = x165 * x17 + x167 * x52 - x168 * x55
    x170 = x154 * x54 - x156 * x54
    x171 = x165 * x18 + x170
    x172 = x138 * x54 - x140 * x54
    x173 = x16 * x172 + x162
    x174 = x17 * x172 + x170
    x175 = 2 / x53**2
    x176 = x145 * x175 - x147 * x175 + x172 * x18
    x177 = x112 * x16 + x115
    x178 = x112 * x17 + x122
    x179 = x122 + x128 * x16
    x180 = x128 * x17 + x131
    x181 = x108 * x112 - x109 * x113 + x69
    x182 = x108 * x122 - x109 * x123 + x54 * (x108 * x113 - x109 * x117 + x74) + x89
    x183 = x108 * x128 - x109 * x120 + x54 * (x108 * x110 - x109 * x111 + x70) + x99
    x184 = x108 * x141 - x109 * x142
    x185 = x108 * x144 - x109 * x151 + x16 * x184
    x186 = x108 * x142
    x187 = x109 * x149
    x188 = x108 * x157 - x109 * x158 + x54 * (x186 - x187)
    x189 = x17 * x184 + x188
    x190 = x186 * x54 - x187 * x54
    x191 = x18 * x184 + x190
    x192 = x108 * x137
    x193 = x109 * x139
    x194 = x108 * x164 - x109 * x153 + x54 * (x192 - x193)
    x195 = x16 * x194 + x188
    x196 = x108 * x139
    x197 = x109 * x146
    x198 = x108 * x153
    x199 = x109 * x155
    x200 = (
        x108 * x167 - x109 * x168 + x17 * x194 + x59 * (x198 - x199 + x54 * (x196 - x197))
    )
    x201 = x198 * x54 - x199 * x54 + x54 * (x196 * x54 - x197 * x54)
    x202 = x18 * x194 + x201
    x203 = x192 * x54 - x193 * x54
    x204 = x16 * x203 + x190
    x205 = x17 * x203 + x201
    x206 = x175 * x196 - x175 * x197 + x18 * x203
    x207 = x141 * x16 + x144
    x208 = x141 * x17 + x157
    x209 = x142 * x54
    x210 = x141 * x18 + x209
    x211 = x157 + x16 * x164
    x212 = x164 * x17 + x167
    x213 = x153 * x54
    x214 = x164 * x18 + x213
    x215 = x137 * x54
    x216 = x16 * x215 + x209
    x217 = x17 * x215 + x213
    x218 = x139 * x175 + x18 * x215
    x219 = x135 * x141 - x136 * x142 + x69
    x220 = x135 * x157 - x136 * x158 + x89
    x221 = x136 * x149
    x222 = x135 * x209 - x221 * x54 + x54 * (x135 * x142 - x221 + x74)
    x223 = x135 * x164 - x136 * x153 + x99
    x224 = x136 * x155
    x225 = x135 * x213 - x224 * x54 + x54 * (x135 * x153 - x224 + x90)
    x226 = x135 * x137
    x227 = x136 * x139
    x228 = x226 * x54 - x227 * x54 + x54 * (x226 - x227 + x70)
    x229 = x135 * x139
    x230 = x136 * x146

    # 81 item(s)
    S = numpy.array(
        [
            x11 * x76
            + x16 * x73
            + x51
            + x52 * x60
            - x55 * (x43 * x52 - x55 * x65 + x59 * x67)
            + x59 * (x52 * x58 + x54 * (x52 * x56 - x55 * x66 + x75) - x55 * x67 + x74),
            x11 * x88 + x17 * x73 + x94,
            x18 * x73 + x72 * x95,
            x100 * x16 + x11 * x98 + x94,
            x100 * x17 + x104 + x105 * x52 + x107 * x11 - x55 * (x101 * x52 - x106 * x55),
            x100 * x18 + x95 * x97,
            0,
            0,
            0,
            x119 + x12 * x76,
            x12 * x88 + x125,
            x126 * x72 + x127,
            x12 * x98 + x130,
            x107 * x12 + x133,
            x126 * x97 + x134,
            0,
            0,
            0,
            x13 * x76 + x152,
            x13 * x88 + x160,
            x161 * x72 + x163,
            x13 * x98 + x166,
            x107 * x13 + x169,
            x161 * x97 + x171,
            x173,
            x174,
            x176,
            x11 * x177 + x119,
            x11 * x178 + x125,
            x112 * x95 + x127,
            x11 * x179 + x130,
            x11 * x180 + x133,
            x128 * x95 + x134,
            0,
            0,
            0,
            x108 * x115 - x109 * x118 + x12 * x177 + x16 * x181 + x51,
            x12 * x178 + x17 * x181 + x182,
            x112 * x126 + x18 * x181,
            x12 * x179 + x16 * x183 + x182,
            x104
            + x108 * x131
            - x109 * x132
            + x12 * x180
            + x17 * x183
            + x59
            * (x108 * x120 - x109 * x121 + x54 * (x108 * x111 - x109 * x116 + x75) + x90),
            x126 * x128 + x18 * x183,
            0,
            0,
            0,
            x13 * x177 + x185,
            x13 * x178 + x189,
            x112 * x161 + x191,
            x13 * x179 + x195,
            x13 * x180 + x200,
            x128 * x161 + x202,
            x204,
            x205,
            x206,
            x11 * x207 + x152,
            x11 * x208 + x160,
            x11 * x210 + x163,
            x11 * x211 + x166,
            x11 * x212 + x169,
            x11 * x214 + x171,
            x11 * x216 + x173,
            x11 * x217 + x174,
            x11 * x218 + x176,
            x12 * x207 + x185,
            x12 * x208 + x189,
            x12 * x210 + x191,
            x12 * x211 + x195,
            x12 * x212 + x200,
            x12 * x214 + x202,
            x12 * x216 + x204,
            x12 * x217 + x205,
            x12 * x218 + x206,
            x13 * x207 + x135 * x144 - x136 * x151 + x16 * x219 + x51,
            x13 * x208 + x17 * x219 + x220,
            x13 * x210 + x18 * x219 + x222,
            x13 * x211 + x16 * x223 + x220,
            x104 + x13 * x212 + x135 * x167 - x136 * x168 + x17 * x223,
            x13 * x214 + x18 * x223 + x225,
            x13 * x216 + x16 * x228 + x222,
            x13 * x217 + x17 * x228 + x225,
            x13 * x218
            + x175 * x229
            - x175 * x230
            + x18 * x228
            + x59 * (x229 * x54 - x230 * x54 + x54 * (x229 - x230 + x75)),
        ]
    )
    return S


def eri_1112(a, A, b, B, c, C, d, D):
    """Cartesian [pp|pd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x9 * (x22**2 + x23**2 + x24**2))
    x26 = C[0] - D[0]
    x27 = C[1] - D[1]
    x28 = C[2] - D[2]
    x29 = x28**2
    x30 = numpy.exp(-c * d * x3 * (x26**2 + x27**2 + x29))
    x31 = 2 * x20 * x21 * x25 * x30
    x32 = x19 * x31
    x33 = x6 * x8
    x34 = x11 * x33
    x35 = boys(3, x18)
    x36 = x31 * x35
    x37 = x32 * x5 + x34 * x36
    x38 = x33 * x37
    x39 = boys(1, x18)
    x40 = x31 * x39
    x41 = x32 * x34 + x40 * x5
    x42 = 2 * c + 2 * d
    x43 = x42 ** (-1.0)
    x44 = 2 * x43
    x45 = -2 * x20 * x21 * x25 * x30 * x39
    x46 = x43 * (-x32 * x33 - x45)
    x47 = x11 * x38 + x41 * x5 + x46
    x48 = -2 * x19 * x20 * x21 * x25 * x30
    x49 = x43 * (-x33 * x36 - x48)
    x50 = x31 * boys(4, x18)
    x51 = x34 * x50 + x36 * x5
    x52 = x33 * x51
    x53 = x11 * x52 + x37 * x5 + x49
    x54 = x34 * x53 + x44 * (-x38 + x41) + x47 * x5
    x55 = x2 * x8
    x56 = x54 * x55
    x57 = x33 * x41
    x58 = boys(0, x18)
    x59 = x31 * x58
    x60 = x34 * x40 + x5 * x59
    x61 = x43 * (2 * x20 * x21 * x25 * x30 * x58 - x33 * x40)
    x62 = x11 * x57 + x5 * x60 + x61
    x63 = x34 * x47 + x44 * (-x57 + x60) + x5 * x62
    x64 = x1 * (-x56 + x63)
    x65 = -x10 - A[0]
    x66 = x53 * x55
    x67 = x0 + x42
    x68 = x67 ** (-1.0)
    x69 = x11 * x55
    x70 = x36 * x65 - x50 * x69
    x71 = x51 * x55
    x72 = -x11 * x71 + x37 * x65 + x68 * x70
    x73 = 2 * x68
    x74 = -x11 * x66 + x47 * x65 + x72 * x73
    x75 = 3 * x68
    x76 = -x11 * x56 + x63 * x65 + x74 * x75
    x77 = -2 * x20 * x21 * x25 * x30 * x35
    x78 = x43 * (-x33 * x50 - x77)
    x79 = x31 * boys(5, x18)
    x80 = x34 * x79 + x5 * x50
    x81 = x34 * x80 + x5 * x51 + x78
    x82 = x34 * x81 + x44 * (x37 - x52) + x5 * x53
    x83 = x50 * x65 - x69 * x79
    x84 = x51 * x65 + x68 * x83 - x69 * x80
    x85 = x53 * x65 - x69 * x81 + x73 * x84
    x86 = x47 * x55
    x87 = x1 * (x62 - x86)
    x88 = x32 * x65 - x36 * x69
    x89 = x37 * x55
    x90 = -x11 * x89 + x41 * x65 + x68 * x88
    x91 = -x11 * x86 + x62 * x65 + x73 * x90
    x92 = x1 * (x41 - x89)
    x93 = x1 * (-x36 * x55 - x48)
    x94 = (
        x65 * x91
        - x69 * x74
        + x73 * (x65 * x90 + x68 * (x65 * x88 - x69 * x70 + x93) - x69 * x72 + x92)
        + x87
    )
    x95 = x1 * (x47 - x66)
    x96 = x1 * (x37 - x71)
    x97 = x1 * (-x50 * x55 - x77)
    x98 = -x32 * x69 + x40 * x65
    x99 = x41 * x55
    x100 = -x11 * x99 + x60 * x65 + x68 * x98
    x101 = x100 * x26
    x102 = x26 * x91 + x26 * (x101 + x91) + x76
    x103 = x1 * (x60 - x99)
    x104 = x1 * (-x32 * x55 - x45)
    x105 = x100 * x65 + x103 + x68 * (x104 + x65 * x98 - x69 * x88) - x69 * x90
    x106 = x105 * x26
    x107 = x100 * x27
    x108 = x12 - C[1]
    x109 = x14 * x33
    x110 = x108 * x40 + x109 * x32
    x111 = x108 * x32 + x109 * x36
    x112 = x111 * x55
    x113 = -x11 * x112 + x110 * x65
    x114 = x108 * x59 + x109 * x40
    x115 = x110 * x33
    x116 = x11 * x115 + x114 * x5
    x117 = x111 * x33
    x118 = x11 * x117 + x110 * x5
    x119 = x118 * x55
    x120 = -x11 * x119 + x113 * x68 + x116 * x65
    x121 = x107 + x120
    x122 = x43 * (x114 - x115)
    x123 = x116 * x5 + x118 * x34 + x122
    x124 = x43 * (x110 - x117)
    x125 = x108 * x36 + x109 * x50
    x126 = x125 * x33
    x127 = x11 * x126 + x111 * x5
    x128 = x118 * x5 + x124 + x127 * x34
    x129 = x128 * x55
    x130 = x125 * x55
    x131 = -x11 * x130 + x111 * x65
    x132 = x127 * x55
    x133 = -x11 * x132 + x118 * x65 + x131 * x68
    x134 = -x11 * x129 + x123 * x65 + x133 * x73
    x135 = x121 * x26 + x134 + x27 * x91
    x136 = x105 * x27
    x137 = x1 * (x116 - x119)
    x138 = x1 * (x110 - x112)
    x139 = x120 * x65 - x133 * x69 + x137 + x68 * (x113 * x65 - x131 * x69 + x138)
    x140 = x136 + x139
    x141 = x1 * (x123 - x129)
    x142 = x1 * (x118 - x132)
    x143 = x1 * (x111 - x130)
    x144 = x108 * x50 + x109 * x79
    x145 = x125 * x65 - x144 * x69
    x146 = x125 * x5 + x144 * x34
    x147 = x127 * x65 + x145 * x68 - x146 * x69
    x148 = x43 * (x111 - x126)
    x149 = x127 * x5 + x146 * x34 + x148
    x150 = (
        x134 * x65
        + x141
        - x69 * (x128 * x65 + x147 * x73 - x149 * x69)
        + x73 * (x133 * x65 + x142 - x147 * x69 + x68 * (x131 * x65 + x143 - x145 * x69))
    )
    x151 = x101 * x28 + x28 * x91
    x152 = x108 * x110 + x117 * x14 + x46
    x153 = x108 * x111 + x126 * x14 + x49
    x154 = x153 * x55
    x155 = -x11 * x154 + x152 * x65
    x156 = x108 * x114 + x115 * x14 + x61
    x157 = x152 * x34 + x156 * x5
    x158 = x152 * x5 + x153 * x34
    x159 = x158 * x55
    x160 = -x11 * x159 + x155 * x68 + x157 * x65
    x161 = x120 * x27 + x160
    x162 = x121 * x27 + x161
    x163 = x1 * (x157 - x159)
    x164 = x1 * (x152 - x154)
    x165 = x108 * x125 + x109 * x144 + x78
    x166 = x153 * x65 - x165 * x69
    x167 = x153 * x5 + x165 * x34
    x168 = (
        x139 * x27
        + x160 * x65
        + x163
        + x68 * (x155 * x65 + x164 - x166 * x69)
        - x69 * (x158 * x65 + x166 * x68 - x167 * x69)
    )
    x169 = x120 * x28
    x170 = x107 * x28 + x169
    x171 = x139 * x28
    x172 = x22 * x29
    x173 = x110 * x55
    x174 = -x11 * x173 + x114 * x65
    x175 = x174 * x26
    x176 = x120 * x26 + x134 + x26 * (x120 + x175)
    x177 = x1 * (x114 - x173)
    x178 = -x113 * x69 + x174 * x65 + x177
    x179 = x178 * x26
    x180 = x174 * x27
    x181 = x152 * x55
    x182 = -x11 * x181 + x156 * x65
    x183 = x180 + x182
    x184 = x161 + x183 * x26
    x185 = x178 * x27
    x186 = x1 * (x156 - x181)
    x187 = -x155 * x69 + x182 * x65 + x186
    x188 = x185 + x187
    x189 = x169 + x175 * x28
    x190 = x108 * x152 + x109 * x153 + 2 * x124
    x191 = x190 * x55
    x192 = x108 * x156 + x109 * x152 + 2 * x122
    x193 = x1 * (-x191 + x192)
    x194 = -x11 * x191 + x192 * x65
    x195 = x108 * x153 + x109 * x165 + 2 * x148
    x196 = x182 * x27 + x183 * x27 + x194
    x197 = x180 * x28 + x182 * x28
    x198 = -x13 - A[1]
    x199 = -x14 * x86 + x198 * x62
    x200 = -x14 * x66 + x198 * x47
    x201 = x14 * x55
    x202 = x198 * x32 - x201 * x36
    x203 = x198 * x36 - x201 * x50
    x204 = -x14 * x89 + x198 * x41
    x205 = -x14 * x71 + x198 * x37
    x206 = (
        x199 * x65
        - x200 * x69
        + x73 * (x204 * x65 - x205 * x69 + x68 * (x202 * x65 - x203 * x69))
    )
    x207 = x198 * x40 - x201 * x32
    x208 = -x14 * x99 + x198 * x60
    x209 = -x204 * x69 + x208 * x65 + x68 * (-x202 * x69 + x207 * x65)
    x210 = x209 * x26
    x211 = -x14 * x56 + x198 * x63
    x212 = x198 * x53 - x201 * x81
    x213 = x198 * x50 - x201 * x79
    x214 = x198 * x51 - x201 * x80
    x215 = x198 * x54 - x201 * x82
    x216 = (
        x206 * x26
        + x211 * x65
        - x215 * x69
        + x26 * (x206 + x210)
        + x75
        * (
            x200 * x65
            - x212 * x69
            + x73 * (x205 * x65 - x214 * x69 + x68 * (x203 * x65 - x213 * x69))
        )
    )
    x217 = x209 * x27
    x218 = x110 * x198 - x112 * x14 + x202 * x68
    x219 = x111 * x198 - x130 * x14 + x203 * x68
    x220 = x116 * x198 - x119 * x14 + x204 * x68
    x221 = x118 * x198 - x132 * x14 + x205 * x68
    x222 = x220 * x65 - x221 * x69 + x68 * (x218 * x65 - x219 * x69)
    x223 = x217 + x222
    x224 = x123 * x198 - x129 * x14 + x200 * x68
    x225 = x125 * x198 - x144 * x201 + x213 * x68
    x226 = x127 * x198 - x146 * x201 + x214 * x68
    x227 = x128 * x198 - x149 * x201 + x212 * x68
    x228 = (
        x224 * x65
        - x227 * x69
        + x73 * (x221 * x65 - x226 * x69 + x68 * (x219 * x65 - x225 * x69))
    )
    x229 = x206 * x27 + x223 * x26 + x228
    x230 = x206 * x28 + x210 * x28
    x231 = -x14 * x154 + x152 * x198 + x219 * x73
    x232 = x153 * x198 - x165 * x201 + x225 * x73
    x233 = -x14 * x159 + x157 * x198 + x221 * x73
    x234 = x158 * x198 - x167 * x201 + x226 * x73
    x235 = x222 * x27 + x233 * x65 - x234 * x69 + x68 * (x231 * x65 - x232 * x69)
    x236 = x223 * x27 + x235
    x237 = x222 * x28
    x238 = x217 * x28 + x237
    x239 = x23 * x29
    x240 = x209 * x29
    x241 = x114 * x198 - x14 * x173 + x207 * x68
    x242 = -x218 * x69 + x241 * x65
    x243 = x242 * x26
    x244 = x222 * x26 + x228 + x26 * (x222 + x243)
    x245 = x242 * x27
    x246 = -x14 * x181 + x156 * x198 + x218 * x73
    x247 = -x231 * x69 + x246 * x65
    x248 = x245 + x247
    x249 = x235 + x248 * x26
    x250 = x237 + x243 * x28
    x251 = -x14 * x191 + x192 * x198 + x231 * x75
    x252 = x190 * x198 - x195 * x201 + x232 * x75
    x253 = x247 * x27 + x248 * x27 + x251 * x65 - x252 * x69
    x254 = x245 * x28 + x247 * x28
    x255 = x242 * x29
    x256 = -x15 - A[2]
    x257 = -x16 * x86 + x256 * x62
    x258 = -x16 * x66 + x256 * x47
    x259 = x16 * x55
    x260 = x256 * x32 - x259 * x36
    x261 = x260 * x65
    x262 = x256 * x36 - x259 * x50
    x263 = x262 * x69
    x264 = -x16 * x89 + x256 * x41
    x265 = x264 * x65
    x266 = -x16 * x71 + x256 * x37
    x267 = x266 * x69
    x268 = x257 * x65 - x258 * x69 + x73 * (x265 - x267 + x68 * (x261 - x263))
    x269 = x256 * x40 - x259 * x32
    x270 = x269 * x65
    x271 = x260 * x69
    x272 = -x16 * x99 + x256 * x60
    x273 = -x264 * x69 + x272 * x65 + x68 * (x270 - x271)
    x274 = -x16 * x56 + x256 * x63
    x275 = x258 * x65
    x276 = x256 * x53 - x259 * x81
    x277 = x276 * x69
    x278 = x262 * x65
    x279 = x256 * x50 - x259 * x79
    x280 = x279 * x69
    x281 = x266 * x65
    x282 = x256 * x51 - x259 * x80
    x283 = x282 * x69
    x284 = x256 * x54 - x259 * x82
    x285 = (
        x26 * x268
        + x26 * (x26 * x273 + x268)
        + x274 * x65
        - x284 * x69
        + x75 * (x275 - x277 + x73 * (x281 - x283 + x68 * (x278 - x280)))
    )
    x286 = x116 * x256 - x119 * x16
    x287 = x110 * x256 - x112 * x16
    x288 = x287 * x65
    x289 = x111 * x256 - x130 * x16
    x290 = x289 * x69
    x291 = x118 * x256 - x132 * x16
    x292 = x286 * x65 - x291 * x69 + x68 * (x288 - x290)
    x293 = x27 * x273 + x292
    x294 = x123 * x256 - x129 * x16
    x295 = x291 * x65
    x296 = x289 * x65
    x297 = x125 * x256 - x144 * x259
    x298 = x297 * x69
    x299 = x127 * x256 - x146 * x259
    x300 = x299 * x69
    x301 = x128 * x256 - x149 * x259
    x302 = x294 * x65 - x301 * x69 + x73 * (x295 - x300 + x68 * (x296 - x298))
    x303 = x26 * x293 + x268 * x27 + x302
    x304 = x265 * x68 - x267 * x68 + x68 * (x261 * x68 - x263 * x68)
    x305 = x273 * x28 + x304
    x306 = (
        x275 * x68
        - x277 * x68
        + x73 * (x281 * x68 - x283 * x68 + x68 * (x278 * x68 - x280 * x68))
    )
    x307 = x26 * x305 + x268 * x28 + x306
    x308 = x152 * x256 - x154 * x16
    x309 = x308 * x65
    x310 = x153 * x256 - x165 * x259
    x311 = x310 * x69
    x312 = x157 * x256 - x159 * x16
    x313 = x158 * x256 - x167 * x259
    x314 = x27 * x292 + x312 * x65 - x313 * x69 + x68 * (x309 - x311)
    x315 = x27 * x293 + x314
    x316 = x295 * x68 - x300 * x68 + x68 * (x296 * x68 - x298 * x68)
    x317 = x28 * x292 + x316
    x318 = x27 * x305 + x317
    x319 = x24 * x29
    x320 = 2 / x67**2
    x321 = x28 * x304 + x281 * x320 - x283 * x320 + x68 * (x278 * x320 - x280 * x320)
    x322 = x28 * x305 + x321
    x323 = x114 * x256 - x16 * x173
    x324 = -x287 * x69 + x323 * x65
    x325 = x26 * x292 + x26 * (x26 * x324 + x292) + x302
    x326 = x156 * x256 - x16 * x181
    x327 = -x308 * x69 + x326 * x65
    x328 = x27 * x324 + x327
    x329 = x26 * x328 + x314
    x330 = x288 * x68 - x290 * x68
    x331 = x28 * x324 + x330
    x332 = x26 * x331 + x317
    x333 = -x16 * x191 + x192 * x256
    x334 = x190 * x256 - x195 * x259
    x335 = x27 * x327 + x27 * x328 + x333 * x65 - x334 * x69
    x336 = x309 * x68 - x311 * x68
    x337 = x27 * x331 + x28 * x327 + x336
    x338 = x28 * x330 + x296 * x320 - x298 * x320
    x339 = x28 * x331 + x338
    x340 = x270 * x68 - x271 * x68
    x341 = x26 * x304 + x26 * (x26 * x340 + x304) + x306
    x342 = x27 * x340 + x330
    x343 = x26 * x342 + x27 * x304 + x316
    x344 = x261 * x320 - x263 * x320
    x345 = x28 * x340 + x344
    x346 = x26 * x345 + x321
    x347 = x27 * x330 + x27 * x342 + x336
    x348 = x27 * x345 + x338
    x349 = 6 / x67**3
    x350 = x278 * x349 + x28 * x344 + x28 * x345 - x280 * x349
    x351 = x208 * x26
    x352 = x199 * x26 + x211 + x26 * (x199 + x351)
    x353 = x208 * x27
    x354 = x220 + x353
    x355 = x199 * x27 + x224 + x26 * x354
    x356 = x199 * x28 + x28 * x351
    x357 = x220 * x27 + x233
    x358 = x27 * x354 + x357
    x359 = x220 * x28
    x360 = x28 * x353 + x359
    x361 = x241 * x26
    x362 = x220 * x26 + x224 + x26 * (x220 + x361)
    x363 = x241 * x27
    x364 = x246 + x363
    x365 = x26 * x364 + x357
    x366 = x28 * x361 + x359
    x367 = x246 * x27 + x251 + x27 * x364
    x368 = x246 * x28 + x28 * x363
    x369 = x198 * x199 - x200 * x201 + x87
    x370 = x103 + x198 * x208 - x201 * x204
    x371 = x26 * x370
    x372 = x27 * x370
    x373 = x137 + x198 * x220 - x201 * x221 + x68 * (x198 * x204 - x201 * x205 + x92)
    x374 = x372 + x373
    x375 = x141 + x198 * x224 - x201 * x227 + x68 * (x198 * x200 - x201 * x212 + x95)
    x376 = (
        x163
        + x198 * x233
        - x201 * x234
        + x27 * x373
        + x73
        * (x142 + x198 * x221 - x201 * x226 + x68 * (x198 * x205 - x201 * x214 + x96))
    )
    x377 = x28 * x373
    x378 = x177 + x198 * x241 - x201 * x218 + x68 * (x104 + x198 * x207 - x201 * x202)
    x379 = x26 * x378
    x380 = x27 * x378
    x381 = (
        x186
        + x198 * x246
        - x201 * x231
        + x73
        * (x138 + x198 * x218 - x201 * x219 + x68 * (x198 * x202 - x201 * x203 + x93))
    )
    x382 = x380 + x381
    x383 = x198 * x257 - x201 * x258
    x384 = x198 * x272 - x201 * x264
    x385 = x198 * x274 - x201 * x284 + x26 * x383 + x26 * (x26 * x384 + x383)
    x386 = x198 * x264
    x387 = x201 * x266
    x388 = x198 * x286 - x201 * x291 + x68 * (x386 - x387)
    x389 = x27 * x384 + x388
    x390 = x198 * x258
    x391 = x201 * x276
    x392 = x198 * x294 - x201 * x301 + x68 * (x390 - x391)
    x393 = x26 * x389 + x27 * x383 + x392
    x394 = x386 * x68 - x387 * x68
    x395 = x28 * x384 + x394
    x396 = x390 * x68 - x391 * x68
    x397 = x26 * x395 + x28 * x383 + x396
    x398 = x198 * x291
    x399 = x198 * x266
    x400 = x201 * x282
    x401 = x201 * x299
    x402 = (
        x198 * x312 - x201 * x313 + x27 * x388 + x73 * (x398 - x401 + x68 * (x399 - x400))
    )
    x403 = x27 * x389 + x402
    x404 = x398 * x68 - x401 * x68 + x68 * (x399 * x68 - x400 * x68)
    x405 = x28 * x388 + x404
    x406 = x27 * x395 + x405
    x407 = x28 * x394 + x320 * x399 - x320 * x400
    x408 = x28 * x395 + x407
    x409 = x198 * x269
    x410 = x201 * x260
    x411 = x198 * x323 - x201 * x287 + x68 * (x409 - x410)
    x412 = x26 * x388 + x26 * (x26 * x411 + x388) + x392
    x413 = x198 * x260
    x414 = x201 * x262
    x415 = x198 * x287
    x416 = x201 * x289
    x417 = x198 * x326 - x201 * x308 + x73 * (x415 - x416 + x68 * (x413 - x414))
    x418 = x27 * x411 + x417
    x419 = x26 * x418 + x402
    x420 = x415 * x68 - x416 * x68 + x68 * (x413 * x68 - x414 * x68)
    x421 = x28 * x411 + x420
    x422 = x26 * x421 + x405
    x423 = x198 * x308
    x424 = x201 * x310
    x425 = x198 * x262
    x426 = x201 * x279
    x427 = x198 * x289
    x428 = x201 * x297
    x429 = (
        x198 * x333
        - x201 * x334
        + x27 * x417
        + x27 * x418
        + x75 * (x423 - x424 + x73 * (x427 - x428 + x68 * (x425 - x426)))
    )
    x430 = (
        x423 * x68
        - x424 * x68
        + x73 * (x427 * x68 - x428 * x68 + x68 * (x425 * x68 - x426 * x68))
    )
    x431 = x27 * x421 + x28 * x417 + x430
    x432 = x28 * x420 + x320 * x427 - x320 * x428 + x68 * (x320 * x425 - x320 * x426)
    x433 = x28 * x421 + x432
    x434 = x409 * x68 - x410 * x68
    x435 = x26 * x394 + x26 * (x26 * x434 + x394) + x396
    x436 = x27 * x434 + x420
    x437 = x26 * x436 + x27 * x394 + x404
    x438 = x320 * x413 - x320 * x414
    x439 = x28 * x434 + x438
    x440 = x26 * x439 + x407
    x441 = x27 * x420 + x27 * x436 + x430
    x442 = x27 * x439 + x432
    x443 = x28 * x438 + x28 * x439 + x349 * x425 - x349 * x426
    x444 = x257 * x26 + x26 * (x257 + x26 * x272) + x274
    x445 = x27 * x272 + x286
    x446 = x257 * x27 + x26 * x445 + x294
    x447 = x264 * x68
    x448 = x272 * x28 + x447
    x449 = x258 * x68
    x450 = x257 * x28 + x26 * x448 + x449
    x451 = x27 * x286 + x312
    x452 = x27 * x445 + x451
    x453 = x291 * x68
    x454 = x28 * x286 + x453
    x455 = x27 * x448 + x454
    x456 = x266 * x320 + x28 * x447
    x457 = x28 * x448 + x456
    x458 = x26 * x286 + x26 * (x26 * x323 + x286) + x294
    x459 = x27 * x323 + x326
    x460 = x26 * x459 + x451
    x461 = x287 * x68
    x462 = x28 * x323 + x461
    x463 = x26 * x462 + x454
    x464 = x27 * x326 + x27 * x459 + x333
    x465 = x308 * x68
    x466 = x27 * x462 + x28 * x326 + x465
    x467 = x28 * x461 + x289 * x320
    x468 = x28 * x462 + x467
    x469 = x269 * x68
    x470 = x26 * x447 + x26 * (x26 * x469 + x447) + x449
    x471 = x27 * x469 + x461
    x472 = x26 * x471 + x27 * x447 + x453
    x473 = x260 * x320
    x474 = x28 * x469 + x473
    x475 = x26 * x474 + x456
    x476 = x27 * x461 + x27 * x471 + x465
    x477 = x27 * x474 + x467
    x478 = x262 * x349 + x28 * x473 + x28 * x474
    x479 = x256 * x257 - x258 * x259 + x87
    x480 = x103 + x256 * x272 - x259 * x264
    x481 = x137 + x256 * x286 - x259 * x291
    x482 = x27 * x480 + x481
    x483 = x141 + x256 * x294 - x259 * x301
    x484 = x259 * x266
    x485 = x256 * x447 - x484 * x68 + x68 * (x256 * x264 - x484 + x92)
    x486 = x28 * x480 + x485
    x487 = x259 * x276
    x488 = x256 * x449 - x487 * x68 + x68 * (x256 * x258 - x487 + x95)
    x489 = x163 + x256 * x312 - x259 * x313 + x27 * x481
    x490 = x259 * x299
    x491 = x256 * x453 - x490 * x68 + x68 * (x142 + x256 * x291 - x490)
    x492 = x28 * x481 + x491
    x493 = x256 * x266
    x494 = x259 * x282
    x495 = (
        x28 * x485
        + x320 * x493
        - x320 * x494
        + x73 * (x493 * x68 - x494 * x68 + x68 * (x493 - x494 + x96))
    )
    x496 = x177 + x256 * x323 - x259 * x287
    x497 = x186 + x256 * x326 - x259 * x308
    x498 = x27 * x496 + x497
    x499 = x259 * x289
    x500 = x256 * x461 - x499 * x68 + x68 * (x138 + x256 * x287 - x499)
    x501 = x28 * x496 + x500
    x502 = x259 * x310
    x503 = x256 * x465 - x502 * x68 + x68 * (x164 + x256 * x308 - x502)
    x504 = x256 * x289
    x505 = x259 * x297
    x506 = (
        x28 * x500
        + x320 * x504
        - x320 * x505
        + x73 * (x504 * x68 - x505 * x68 + x68 * (x143 + x504 - x505))
    )
    x507 = x256 * x269
    x508 = x259 * x260
    x509 = x507 * x68 - x508 * x68 + x68 * (x104 + x507 - x508)
    x510 = x27 * x509 + x500
    x511 = x256 * x260
    x512 = x259 * x262
    x513 = (
        x320 * x511
        - x320 * x512
        + x73 * (x511 * x68 - x512 * x68 + x68 * (x511 - x512 + x93))
    )
    x514 = x28 * x509 + x513
    x515 = x256 * x262
    x516 = x259 * x279

    # 162 item(s)
    S = numpy.array(
        [
            x102 * x22
            + x26 * x94
            + x26 * (x106 + x94)
            + x64
            + x65 * x76
            - x69 * (x54 * x65 - x69 * x82 + x75 * x85)
            + x75
            * (
                x65 * x74
                - x69 * x85
                + x73
                * (x65 * x72 + x68 * (x65 * x70 - x69 * x83 + x97) - x69 * x84 + x96)
                + x95
            ),
            x135 * x22 + x140 * x26 + x150 + x27 * x94,
            x106 * x28 + x151 * x22 + x28 * x94,
            x140 * x27 + x162 * x22 + x168,
            x136 * x28 + x170 * x22 + x171,
            x100 * x172 + x105 * x29,
            x139 * x26 + x150 + x176 * x22 + x26 * (x139 + x179),
            x168 + x184 * x22 + x188 * x26,
            x171 + x179 * x28 + x189 * x22,
            x187 * x27
            + x188 * x27
            + x193
            + x194 * x65
            + x196 * x22
            - x69 * (x190 * x65 - x195 * x69),
            x185 * x28 + x187 * x28 + x197 * x22,
            x172 * x174 + x178 * x29,
            0,
            0,
            0,
            0,
            0,
            0,
            x102 * x23 + x216,
            x135 * x23 + x229,
            x151 * x23 + x230,
            x162 * x23 + x236,
            x170 * x23 + x238,
            x100 * x239 + x240,
            x176 * x23 + x244,
            x184 * x23 + x249,
            x189 * x23 + x250,
            x196 * x23 + x253,
            x197 * x23 + x254,
            x174 * x239 + x255,
            0,
            0,
            0,
            0,
            0,
            0,
            x102 * x24 + x285,
            x135 * x24 + x303,
            x151 * x24 + x307,
            x162 * x24 + x315,
            x170 * x24 + x318,
            x100 * x319 + x322,
            x176 * x24 + x325,
            x184 * x24 + x329,
            x189 * x24 + x332,
            x196 * x24 + x335,
            x197 * x24 + x337,
            x174 * x319 + x339,
            x341,
            x343,
            x346,
            x347,
            x348,
            x350,
            x216 + x22 * x352,
            x22 * x355 + x229,
            x22 * x356 + x230,
            x22 * x358 + x236,
            x22 * x360 + x238,
            x172 * x208 + x240,
            x22 * x362 + x244,
            x22 * x365 + x249,
            x22 * x366 + x250,
            x22 * x367 + x253,
            x22 * x368 + x254,
            x172 * x241 + x255,
            0,
            0,
            0,
            0,
            0,
            0,
            x198 * x211
            - x201 * x215
            + x23 * x352
            + x26 * x369
            + x26 * (x369 + x371)
            + x64,
            x23 * x355 + x26 * x374 + x27 * x369 + x375,
            x23 * x356 + x28 * x369 + x28 * x371,
            x23 * x358 + x27 * x374 + x376,
            x23 * x360 + x28 * x372 + x377,
            x208 * x239 + x29 * x370,
            x23 * x362 + x26 * x373 + x26 * (x373 + x379) + x375,
            x23 * x365 + x26 * x382 + x376,
            x23 * x366 + x28 * x379 + x377,
            x193
            + x198 * x251
            - x201 * x252
            + x23 * x367
            + x27 * x381
            + x27 * x382
            + x75
            * (
                x164
                + x198 * x231
                - x201 * x232
                + x73
                * (
                    x143
                    + x198 * x219
                    - x201 * x225
                    + x68 * (x198 * x203 - x201 * x213 + x97)
                )
            ),
            x23 * x368 + x28 * x380 + x28 * x381,
            x239 * x241 + x29 * x378,
            0,
            0,
            0,
            0,
            0,
            0,
            x24 * x352 + x385,
            x24 * x355 + x393,
            x24 * x356 + x397,
            x24 * x358 + x403,
            x24 * x360 + x406,
            x208 * x319 + x408,
            x24 * x362 + x412,
            x24 * x365 + x419,
            x24 * x366 + x422,
            x24 * x367 + x429,
            x24 * x368 + x431,
            x241 * x319 + x433,
            x435,
            x437,
            x440,
            x441,
            x442,
            x443,
            x22 * x444 + x285,
            x22 * x446 + x303,
            x22 * x450 + x307,
            x22 * x452 + x315,
            x22 * x455 + x318,
            x22 * x457 + x322,
            x22 * x458 + x325,
            x22 * x460 + x329,
            x22 * x463 + x332,
            x22 * x464 + x335,
            x22 * x466 + x337,
            x22 * x468 + x339,
            x22 * x470 + x341,
            x22 * x472 + x343,
            x22 * x475 + x346,
            x22 * x476 + x347,
            x22 * x477 + x348,
            x22 * x478 + x350,
            x23 * x444 + x385,
            x23 * x446 + x393,
            x23 * x450 + x397,
            x23 * x452 + x403,
            x23 * x455 + x406,
            x23 * x457 + x408,
            x23 * x458 + x412,
            x23 * x460 + x419,
            x23 * x463 + x422,
            x23 * x464 + x429,
            x23 * x466 + x431,
            x23 * x468 + x433,
            x23 * x470 + x435,
            x23 * x472 + x437,
            x23 * x475 + x440,
            x23 * x476 + x441,
            x23 * x477 + x442,
            x23 * x478 + x443,
            x24 * x444
            + x256 * x274
            - x259 * x284
            + x26 * x479
            + x26 * (x26 * x480 + x479)
            + x64,
            x24 * x446 + x26 * x482 + x27 * x479 + x483,
            x24 * x450 + x26 * x486 + x28 * x479 + x488,
            x24 * x452 + x27 * x482 + x489,
            x24 * x455 + x27 * x486 + x492,
            x24 * x457 + x28 * x486 + x495,
            x24 * x458 + x26 * x481 + x26 * (x26 * x496 + x481) + x483,
            x24 * x460 + x26 * x498 + x489,
            x24 * x463 + x26 * x501 + x492,
            x193 + x24 * x464 + x256 * x333 - x259 * x334 + x27 * x497 + x27 * x498,
            x24 * x466 + x27 * x501 + x28 * x497 + x503,
            x24 * x468 + x28 * x501 + x506,
            x24 * x470 + x26 * x485 + x26 * (x26 * x509 + x485) + x488,
            x24 * x472 + x26 * x510 + x27 * x485 + x491,
            x24 * x475 + x26 * x514 + x495,
            x24 * x476 + x27 * x500 + x27 * x510 + x503,
            x24 * x477 + x27 * x514 + x506,
            x24 * x478
            + x28 * x513
            + x28 * x514
            + x349 * x515
            - x349 * x516
            + x75
            * (
                x320 * x515
                - x320 * x516
                + x73 * (x515 * x68 - x516 * x68 + x68 * (x515 - x516 + x97))
            ),
        ]
    )
    return S


def eri_1120(a, A, b, B, c, C, d, D):
    """Cartesian [pp|ds] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x10 * (x11**2 + x12**2 + x13**2))
    x15 = x6 ** (-1.0)
    x16 = numpy.exp(
        -c * d * x15 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x17 = x8 ** (-1.0)
    x18 = x15 * (c * C[0] + d * D[0])
    x19 = -x10 * (a * A[0] + b * B[0])
    x20 = -x18 - x19
    x21 = x15 * (c * C[1] + d * D[1])
    x22 = -x10 * (a * A[1] + b * B[1])
    x23 = -x21 - x22
    x24 = -x10 * (a * A[2] + b * B[2])
    x25 = -x15 * (c * C[2] + d * D[2]) - x24
    x26 = x17 * x7 * (x20**2 + x23**2 + x25**2)
    x27 = boys(1, x26)
    x28 = x17 * x5
    x29 = boys(2, x26)
    x30 = 2 * x14 * x16 * x4 * x9
    x31 = x29 * x30
    x32 = x3 * (2 * x14 * x16 * x27 * x4 * x9 - x28 * x31)
    x33 = x18 - C[0]
    x34 = x27 * x30
    x35 = x20 * x28
    x36 = x31 * x35 + x33 * x34
    x37 = x30 * boys(3, x26)
    x38 = x31 * x33 + x35 * x37
    x39 = x32 + x33 * x36 + x35 * x38
    x40 = x17 * x6
    x41 = x39 * x40
    x42 = boys(0, x26)
    x43 = x3 * (2 * x14 * x16 * x4 * x42 * x9 - x28 * x34)
    x44 = x30 * x42
    x45 = x33 * (x33 * x44 + x34 * x35) + x35 * x36 + x43
    x46 = x1 * (-x41 + x45)
    x47 = -x19 - A[0]
    x48 = x0 + x2
    x49 = x48 ** (-1.0)
    x50 = x20 * x40
    x51 = x31 * x47 - x37 * x50
    x52 = x38 * x40
    x53 = -x20 * x52 + x36 * x47 + x49 * x51
    x54 = 2 * x49
    x55 = -x20 * x41 + x45 * x47 + x53 * x54
    x56 = -2 * x14 * x16 * x29 * x4 * x9
    x57 = x3 * (-x28 * x37 - x56)
    x58 = x30 * boys(4, x26)
    x59 = x33 * x37 + x35 * x58
    x60 = x33 * x38 + x35 * x59 + x57
    x61 = x37 * x47 - x50 * x58
    x62 = x38 * x47 + x49 * x61 - x50 * x59
    x63 = x1 * (x36 - x52)
    x64 = x1 * (-x37 * x40 - x56)
    x65 = x21 - C[1]
    x66 = x23 * x28
    x67 = x31 * x66 + x34 * x65
    x68 = x31 * x65 + x37 * x66
    x69 = x33 * x67 + x35 * x68
    x70 = x40 * x69
    x71 = x34 * x66 + x44 * x65
    x72 = x33 * x71 + x35 * x67
    x73 = x1 * (-x70 + x72)
    x74 = x40 * x68
    x75 = x1 * (x67 - x74)
    x76 = -x20 * x74 + x47 * x67
    x77 = x37 * x65 + x58 * x66
    x78 = x47 * x68 - x50 * x77
    x79 = -x20 * x70 + x47 * x72 + x49 * x76
    x80 = x33 * x68 + x35 * x77
    x81 = x32 + x65 * x67 + x66 * x68
    x82 = x40 * x81
    x83 = x43 + x65 * x71 + x66 * x67
    x84 = x1 * (-x82 + x83)
    x85 = -x20 * x82 + x47 * x83
    x86 = x57 + x65 * x68 + x66 * x77
    x87 = -x22 - A[1]
    x88 = -x23 * x41 + x45 * x87
    x89 = x23 * x40
    x90 = x31 * x87 - x37 * x89
    x91 = x37 * x87 - x58 * x89
    x92 = -x23 * x52 + x36 * x87
    x93 = x38 * x87 - x59 * x89
    x94 = x39 * x87 - x60 * x89
    x95 = (
        x47 * x88
        - x50 * x94
        + x54 * (x47 * x92 + x49 * (x47 * x90 - x50 * x91) - x50 * x93)
    )
    x96 = -x23 * x74 + x49 * x90 + x67 * x87
    x97 = x49 * x91 + x68 * x87 - x77 * x89
    x98 = -x23 * x70 + x49 * x92 + x72 * x87
    x99 = x49 * x93 + x69 * x87 - x80 * x89
    x100 = x47 * x98 + x49 * (x47 * x96 - x50 * x97) - x50 * x99
    x101 = -x23 * x82 + x54 * x96 + x83 * x87
    x102 = x54 * x97 + x81 * x87 - x86 * x89
    x103 = x101 * x47 - x102 * x50
    x104 = -x24 - A[2]
    x105 = x104 * x45 - x25 * x41
    x106 = x25 * x40
    x107 = x104 * x31 - x106 * x37
    x108 = x107 * x47
    x109 = x104 * x37 - x106 * x58
    x110 = x109 * x50
    x111 = x104 * x36 - x25 * x52
    x112 = x111 * x47
    x113 = x104 * x38 - x106 * x59
    x114 = x113 * x50
    x115 = x104 * x39 - x106 * x60
    x116 = x105 * x47 - x115 * x50 + x54 * (x112 - x114 + x49 * (x108 - x110))
    x117 = x104 * x67 - x25 * x74
    x118 = x117 * x47
    x119 = x104 * x68 - x106 * x77
    x120 = x119 * x50
    x121 = x104 * x72 - x25 * x70
    x122 = x104 * x69 - x106 * x80
    x123 = x121 * x47 - x122 * x50 + x49 * (x118 - x120)
    x124 = x112 * x49 - x114 * x49 + x49 * (x108 * x49 - x110 * x49)
    x125 = x104 * x83 - x25 * x82
    x126 = x104 * x81 - x106 * x86
    x127 = x125 * x47 - x126 * x50
    x128 = x118 * x49 - x120 * x49
    x129 = 2 / x48**2
    x130 = x108 * x129 - x110 * x129
    x131 = x105 * x87 - x115 * x89
    x132 = x111 * x87
    x133 = x113 * x89
    x134 = x121 * x87 - x122 * x89 + x49 * (x132 - x133)
    x135 = x132 * x49 - x133 * x49
    x136 = x107 * x87
    x137 = x109 * x89
    x138 = x117 * x87
    x139 = x119 * x89
    x140 = x125 * x87 - x126 * x89 + x54 * (x138 - x139 + x49 * (x136 - x137))
    x141 = x138 * x49 - x139 * x49 + x49 * (x136 * x49 - x137 * x49)
    x142 = x129 * x136 - x129 * x137
    x143 = x11 * x49
    x144 = x107 * x129
    x145 = x12 * x49
    x146 = x13 * x49
    x147 = x104 * x111
    x148 = x106 * x113
    x149 = x104 * x117
    x150 = x106 * x119
    x151 = x104 * x107
    x152 = x106 * x109

    # 54 item(s)
    S = numpy.array(
        [
            x11 * x55
            + x46
            + x47 * x55
            - x50 * (x39 * x47 - x50 * x60 + x54 * x62)
            + x54 * (x47 * x53 + x49 * (x47 * x51 - x50 * x61 + x64) - x50 * x62 + x63),
            x11 * x79
            + x47 * x79
            + x49 * (x47 * x76 - x50 * x78 + x75)
            - x50 * (x47 * x69 + x49 * x78 - x50 * x80)
            + x73,
            0,
            x11 * x85 + x47 * x85 - x50 * (x47 * x81 - x50 * x86) + x84,
            0,
            0,
            x12 * x55 + x95,
            x100 + x12 * x79,
            0,
            x103 + x12 * x85,
            0,
            0,
            x116 + x13 * x55,
            x123 + x13 * x79,
            x124,
            x127 + x13 * x85,
            x128,
            x130,
            x11 * x88 + x95,
            x100 + x11 * x98,
            0,
            x101 * x11 + x103,
            0,
            0,
            x12 * x88 + x46 + x87 * x88 - x89 * x94,
            x12 * x98 + x49 * (x63 + x87 * x92 - x89 * x93) + x73 + x87 * x98 - x89 * x99,
            0,
            x101 * x12
            + x101 * x87
            - x102 * x89
            + x54 * (x49 * (x64 + x87 * x90 - x89 * x91) + x75 + x87 * x96 - x89 * x97)
            + x84,
            0,
            0,
            x13 * x88 + x131,
            x13 * x98 + x134,
            x135,
            x101 * x13 + x140,
            x141,
            x142,
            x105 * x11 + x116,
            x11 * x121 + x123,
            x111 * x143 + x124,
            x11 * x125 + x127,
            x117 * x143 + x128,
            x11 * x144 + x130,
            x105 * x12 + x131,
            x12 * x121 + x134,
            x111 * x145 + x135,
            x12 * x125 + x140,
            x117 * x145 + x141,
            x12 * x144 + x142,
            x104 * x105 + x105 * x13 - x106 * x115 + x46,
            x104 * x121 - x106 * x122 + x121 * x13 + x73,
            x111 * x146 + x147 * x49 - x148 * x49 + x49 * (x147 - x148 + x63),
            x104 * x125 - x106 * x126 + x125 * x13 + x84,
            x117 * x146 + x149 * x49 - x150 * x49 + x49 * (x149 - x150 + x75),
            x129 * x151
            - x129 * x152
            + x13 * x144
            + x54 * (x151 * x49 - x152 * x49 + x49 * (x151 - x152 + x64)),
        ]
    )
    return S


def eri_1121(a, A, b, B, c, C, d, D):
    """Cartesian [pp|dp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x9 * (x22**2 + x23**2 + x24**2))
    x26 = C[0] - D[0]
    x27 = C[1] - D[1]
    x28 = C[2] - D[2]
    x29 = numpy.exp(-c * d * x3 * (x26**2 + x27**2 + x28**2))
    x30 = 2 * x20 * x21 * x25 * x29
    x31 = x19 * x30
    x32 = x6 * x8
    x33 = x11 * x32
    x34 = boys(3, x18)
    x35 = x30 * x34
    x36 = x31 * x5 + x33 * x35
    x37 = x32 * x36
    x38 = boys(1, x18)
    x39 = x30 * x38
    x40 = x31 * x33 + x39 * x5
    x41 = 2 * c + 2 * d
    x42 = x41 ** (-1.0)
    x43 = 2 * x42
    x44 = x42 * (2 * x20 * x21 * x25 * x29 * x38 - x31 * x32)
    x45 = x11 * x37 + x40 * x5 + x44
    x46 = -2 * x19 * x20 * x21 * x25 * x29
    x47 = x42 * (-x32 * x35 - x46)
    x48 = x30 * boys(4, x18)
    x49 = x33 * x48 + x35 * x5
    x50 = x32 * x49
    x51 = x11 * x50 + x36 * x5 + x47
    x52 = x33 * x51 + x43 * (-x37 + x40) + x45 * x5
    x53 = x2 * x8
    x54 = x52 * x53
    x55 = x32 * x40
    x56 = boys(0, x18)
    x57 = x30 * x56
    x58 = x33 * x39 + x5 * x57
    x59 = x42 * (2 * x20 * x21 * x25 * x29 * x56 - x32 * x39)
    x60 = x11 * x55 + x5 * x58 + x59
    x61 = x33 * x45 + x43 * (-x55 + x58) + x5 * x60
    x62 = x1 * (-x54 + x61)
    x63 = -x10 - A[0]
    x64 = x51 * x53
    x65 = x0 + x41
    x66 = x65 ** (-1.0)
    x67 = x11 * x53
    x68 = x35 * x63 - x48 * x67
    x69 = x49 * x53
    x70 = -x11 * x69 + x36 * x63 + x66 * x68
    x71 = 2 * x66
    x72 = -x11 * x64 + x45 * x63 + x70 * x71
    x73 = 3 * x66
    x74 = -x11 * x54 + x61 * x63 + x72 * x73
    x75 = -2 * x20 * x21 * x25 * x29 * x34
    x76 = x42 * (-x32 * x48 - x75)
    x77 = x30 * boys(5, x18)
    x78 = x33 * x77 + x48 * x5
    x79 = x33 * x78 + x49 * x5 + x76
    x80 = x33 * x79 + x43 * (x36 - x50) + x5 * x51
    x81 = x48 * x63 - x67 * x77
    x82 = x49 * x63 + x66 * x81 - x67 * x78
    x83 = x51 * x63 - x67 * x79 + x71 * x82
    x84 = x45 * x53
    x85 = x31 * x63 - x35 * x67
    x86 = x36 * x53
    x87 = -x11 * x86 + x40 * x63 + x66 * x85
    x88 = -x11 * x84 + x60 * x63 + x71 * x87
    x89 = x26 * x88 + x74
    x90 = x1 * (x60 - x84)
    x91 = x1 * (x40 - x86)
    x92 = x1 * (-x35 * x53 - x46)
    x93 = (
        x63 * x88
        - x67 * x72
        + x71 * (x63 * x87 + x66 * (x63 * x85 - x67 * x68 + x92) - x67 * x70 + x91)
        + x90
    )
    x94 = x1 * (x45 - x64)
    x95 = x1 * (x36 - x69)
    x96 = x1 * (-x48 * x53 - x75)
    x97 = x12 - C[1]
    x98 = x14 * x32
    x99 = x31 * x98 + x39 * x97
    x100 = x32 * x99
    x101 = x39 * x98 + x57 * x97
    x102 = x42 * (-x100 + x101)
    x103 = x100 * x11 + x101 * x5
    x104 = x31 * x97 + x35 * x98
    x105 = x104 * x32
    x106 = x105 * x11 + x5 * x99
    x107 = x102 + x103 * x5 + x106 * x33
    x108 = x42 * (-x105 + x99)
    x109 = x35 * x97 + x48 * x98
    x110 = x109 * x32
    x111 = x104 * x5 + x11 * x110
    x112 = x106 * x5 + x108 + x111 * x33
    x113 = x112 * x53
    x114 = x109 * x53
    x115 = x104 * x63 - x11 * x114
    x116 = x111 * x53
    x117 = x106 * x63 - x11 * x116 + x115 * x66
    x118 = x107 * x63 - x11 * x113 + x117 * x71
    x119 = x118 + x27 * x88
    x120 = x1 * (x107 - x113)
    x121 = x1 * (x106 - x116)
    x122 = x1 * (x104 - x114)
    x123 = x48 * x97 + x77 * x98
    x124 = x109 * x63 - x123 * x67
    x125 = x109 * x5 + x123 * x33
    x126 = x111 * x63 + x124 * x66 - x125 * x67
    x127 = x42 * (x104 - x110)
    x128 = x111 * x5 + x125 * x33 + x127
    x129 = (
        x118 * x63
        + x120
        - x67 * (x112 * x63 + x126 * x71 - x128 * x67)
        + x71 * (x117 * x63 + x121 - x126 * x67 + x66 * (x115 * x63 + x122 - x124 * x67))
    )
    x130 = x22 * x28
    x131 = x104 * x53
    x132 = -x11 * x131 + x63 * x99
    x133 = x106 * x53
    x134 = x103 * x63 - x11 * x133 + x132 * x66
    x135 = x118 + x134 * x26
    x136 = x1 * (x103 - x133)
    x137 = x1 * (-x131 + x99)
    x138 = -x117 * x67 + x134 * x63 + x136 + x66 * (-x115 * x67 + x132 * x63 + x137)
    x139 = x105 * x14 + x44 + x97 * x99
    x140 = x104 * x97 + x110 * x14 + x47
    x141 = x140 * x53
    x142 = -x11 * x141 + x139 * x63
    x143 = x100 * x14 + x101 * x97 + x59
    x144 = x139 * x33 + x143 * x5
    x145 = x139 * x5 + x140 * x33
    x146 = x145 * x53
    x147 = -x11 * x146 + x142 * x66 + x144 * x63
    x148 = x134 * x27 + x147
    x149 = x1 * (x144 - x146)
    x150 = x1 * (x139 - x141)
    x151 = x109 * x97 + x123 * x98 + x76
    x152 = x140 * x63 - x151 * x67
    x153 = x140 * x5 + x151 * x33
    x154 = (
        x147 * x63
        + x149
        + x66 * (x142 * x63 + x150 - x152 * x67)
        - x67 * (x145 * x63 + x152 * x66 - x153 * x67)
    )
    x155 = x139 * x53
    x156 = -x11 * x155 + x143 * x63
    x157 = x147 + x156 * x26
    x158 = x1 * (x143 - x155)
    x159 = -x142 * x67 + x156 * x63 + x158
    x160 = 2 * x108 + x139 * x97 + x140 * x98
    x161 = x160 * x53
    x162 = 2 * x102 + x139 * x98 + x143 * x97
    x163 = x1 * (-x161 + x162)
    x164 = -x11 * x161 + x162 * x63
    x165 = 2 * x127 + x140 * x97 + x151 * x98
    x166 = x156 * x27 + x164
    x167 = -x13 - A[1]
    x168 = -x14 * x84 + x167 * x60
    x169 = -x14 * x64 + x167 * x45
    x170 = x14 * x53
    x171 = x167 * x31 - x170 * x35
    x172 = x167 * x35 - x170 * x48
    x173 = -x14 * x86 + x167 * x40
    x174 = -x14 * x69 + x167 * x36
    x175 = (
        x168 * x63
        - x169 * x67
        + x71 * (x173 * x63 - x174 * x67 + x66 * (x171 * x63 - x172 * x67))
    )
    x176 = -x14 * x54 + x167 * x61
    x177 = x167 * x51 - x170 * x79
    x178 = x167 * x48 - x170 * x77
    x179 = x167 * x49 - x170 * x78
    x180 = x167 * x52 - x170 * x80
    x181 = (
        x175 * x26
        + x176 * x63
        - x180 * x67
        + x73
        * (
            x169 * x63
            - x177 * x67
            + x71 * (x174 * x63 - x179 * x67 + x66 * (x172 * x63 - x178 * x67))
        )
    )
    x182 = x107 * x167 - x113 * x14 + x169 * x66
    x183 = x104 * x167 - x114 * x14 + x172 * x66
    x184 = x109 * x167 - x123 * x170 + x178 * x66
    x185 = x106 * x167 - x116 * x14 + x174 * x66
    x186 = x111 * x167 - x125 * x170 + x179 * x66
    x187 = x112 * x167 - x128 * x170 + x177 * x66
    x188 = (
        x182 * x63
        - x187 * x67
        + x71 * (x185 * x63 - x186 * x67 + x66 * (x183 * x63 - x184 * x67))
    )
    x189 = x175 * x27 + x188
    x190 = x23 * x28
    x191 = x175 * x28
    x192 = -x131 * x14 + x167 * x99 + x171 * x66
    x193 = x103 * x167 - x133 * x14 + x173 * x66
    x194 = -x185 * x67 + x193 * x63 + x66 * (-x183 * x67 + x192 * x63)
    x195 = x188 + x194 * x26
    x196 = x139 * x167 - x14 * x141 + x183 * x71
    x197 = x140 * x167 - x151 * x170 + x184 * x71
    x198 = -x14 * x146 + x144 * x167 + x185 * x71
    x199 = x145 * x167 - x153 * x170 + x186 * x71
    x200 = x198 * x63 - x199 * x67 + x66 * (x196 * x63 - x197 * x67)
    x201 = x194 * x27 + x200
    x202 = x194 * x28
    x203 = -x14 * x155 + x143 * x167 + x192 * x71
    x204 = -x196 * x67 + x203 * x63
    x205 = x200 + x204 * x26
    x206 = -x14 * x161 + x162 * x167 + x196 * x73
    x207 = x160 * x167 - x165 * x170 + x197 * x73
    x208 = x204 * x27 + x206 * x63 - x207 * x67
    x209 = x204 * x28
    x210 = -x15 - A[2]
    x211 = -x16 * x84 + x210 * x60
    x212 = -x16 * x64 + x210 * x45
    x213 = x16 * x53
    x214 = x210 * x31 - x213 * x35
    x215 = x214 * x63
    x216 = x210 * x35 - x213 * x48
    x217 = x216 * x67
    x218 = -x16 * x86 + x210 * x40
    x219 = x218 * x63
    x220 = -x16 * x69 + x210 * x36
    x221 = x220 * x67
    x222 = x211 * x63 - x212 * x67 + x71 * (x219 - x221 + x66 * (x215 - x217))
    x223 = -x16 * x54 + x210 * x61
    x224 = x212 * x63
    x225 = x210 * x51 - x213 * x79
    x226 = x225 * x67
    x227 = x216 * x63
    x228 = x210 * x48 - x213 * x77
    x229 = x228 * x67
    x230 = x220 * x63
    x231 = x210 * x49 - x213 * x78
    x232 = x231 * x67
    x233 = x210 * x52 - x213 * x80
    x234 = (
        x222 * x26
        + x223 * x63
        - x233 * x67
        + x73 * (x224 - x226 + x71 * (x230 - x232 + x66 * (x227 - x229)))
    )
    x235 = x107 * x210 - x113 * x16
    x236 = x106 * x210 - x116 * x16
    x237 = x236 * x63
    x238 = x104 * x210 - x114 * x16
    x239 = x238 * x63
    x240 = x109 * x210 - x123 * x213
    x241 = x240 * x67
    x242 = x111 * x210 - x125 * x213
    x243 = x242 * x67
    x244 = x112 * x210 - x128 * x213
    x245 = x235 * x63 - x244 * x67 + x71 * (x237 - x243 + x66 * (x239 - x241))
    x246 = x222 * x27 + x245
    x247 = x24 * x28
    x248 = (
        x224 * x66
        - x226 * x66
        + x71 * (x230 * x66 - x232 * x66 + x66 * (x227 * x66 - x229 * x66))
    )
    x249 = x222 * x28 + x248
    x250 = x103 * x210 - x133 * x16
    x251 = -x131 * x16 + x210 * x99
    x252 = x251 * x63
    x253 = x238 * x67
    x254 = -x236 * x67 + x250 * x63 + x66 * (x252 - x253)
    x255 = x245 + x254 * x26
    x256 = x139 * x210 - x141 * x16
    x257 = x256 * x63
    x258 = x140 * x210 - x151 * x213
    x259 = x258 * x67
    x260 = x144 * x210 - x146 * x16
    x261 = x145 * x210 - x153 * x213
    x262 = x260 * x63 - x261 * x67 + x66 * (x257 - x259)
    x263 = x254 * x27 + x262
    x264 = x237 * x66 - x243 * x66 + x66 * (x239 * x66 - x241 * x66)
    x265 = x254 * x28 + x264
    x266 = x219 * x66 - x221 * x66 + x66 * (x215 * x66 - x217 * x66)
    x267 = x248 + x26 * x266
    x268 = x264 + x266 * x27
    x269 = 2 / x65**2
    x270 = x230 * x269 - x232 * x269 + x66 * (x227 * x269 - x229 * x269)
    x271 = x266 * x28 + x270
    x272 = x143 * x210 - x155 * x16
    x273 = -x256 * x67 + x272 * x63
    x274 = x26 * x273 + x262
    x275 = -x16 * x161 + x162 * x210
    x276 = x160 * x210 - x165 * x213
    x277 = x27 * x273 + x275 * x63 - x276 * x67
    x278 = x257 * x66 - x259 * x66
    x279 = x273 * x28 + x278
    x280 = x252 * x66 - x253 * x66
    x281 = x26 * x280 + x264
    x282 = x27 * x280 + x278
    x283 = x239 * x269 - x241 * x269
    x284 = x28 * x280 + x283
    x285 = x215 * x269 - x217 * x269
    x286 = x26 * x285 + x270
    x287 = x27 * x285 + x283
    x288 = 6 / x65**3
    x289 = x227 * x288 - x229 * x288 + x28 * x285
    x290 = x168 * x26 + x176
    x291 = x168 * x27 + x182
    x292 = x182 + x193 * x26
    x293 = x193 * x27 + x198
    x294 = x198 + x203 * x26
    x295 = x203 * x27 + x206
    x296 = x167 * x168 - x169 * x170 + x90
    x297 = x120 + x167 * x182 - x170 * x187 + x66 * (x167 * x169 - x170 * x177 + x94)
    x298 = x136 + x167 * x193 - x170 * x185 + x66 * (x167 * x173 - x170 * x174 + x91)
    x299 = (
        x149
        + x167 * x198
        - x170 * x199
        + x71
        * (x121 + x167 * x185 - x170 * x186 + x66 * (x167 * x174 - x170 * x179 + x95))
    )
    x300 = (
        x158
        + x167 * x203
        - x170 * x196
        + x71
        * (x137 + x167 * x192 - x170 * x183 + x66 * (x167 * x171 - x170 * x172 + x92))
    )
    x301 = x167 * x211 - x170 * x212
    x302 = x167 * x223 - x170 * x233 + x26 * x301
    x303 = x167 * x212
    x304 = x170 * x225
    x305 = x167 * x235 - x170 * x244 + x66 * (x303 - x304)
    x306 = x27 * x301 + x305
    x307 = x303 * x66 - x304 * x66
    x308 = x28 * x301 + x307
    x309 = x167 * x218
    x310 = x170 * x220
    x311 = x167 * x250 - x170 * x236 + x66 * (x309 - x310)
    x312 = x26 * x311 + x305
    x313 = x167 * x236
    x314 = x167 * x220
    x315 = x170 * x231
    x316 = x170 * x242
    x317 = x167 * x260 - x170 * x261 + x71 * (x313 - x316 + x66 * (x314 - x315))
    x318 = x27 * x311 + x317
    x319 = x313 * x66 - x316 * x66 + x66 * (x314 * x66 - x315 * x66)
    x320 = x28 * x311 + x319
    x321 = x309 * x66 - x310 * x66
    x322 = x26 * x321 + x307
    x323 = x27 * x321 + x319
    x324 = x269 * x314 - x269 * x315
    x325 = x28 * x321 + x324
    x326 = x167 * x214
    x327 = x170 * x216
    x328 = x167 * x251
    x329 = x170 * x238
    x330 = x167 * x272 - x170 * x256 + x71 * (x328 - x329 + x66 * (x326 - x327))
    x331 = x26 * x330 + x317
    x332 = x167 * x256
    x333 = x170 * x258
    x334 = x167 * x216
    x335 = x170 * x228
    x336 = x167 * x238
    x337 = x170 * x240
    x338 = (
        x167 * x275
        - x170 * x276
        + x27 * x330
        + x73 * (x332 - x333 + x71 * (x336 - x337 + x66 * (x334 - x335)))
    )
    x339 = (
        x332 * x66
        - x333 * x66
        + x71 * (x336 * x66 - x337 * x66 + x66 * (x334 * x66 - x335 * x66))
    )
    x340 = x28 * x330 + x339
    x341 = x328 * x66 - x329 * x66 + x66 * (x326 * x66 - x327 * x66)
    x342 = x26 * x341 + x319
    x343 = x27 * x341 + x339
    x344 = x269 * x336 - x269 * x337 + x66 * (x269 * x334 - x269 * x335)
    x345 = x28 * x341 + x344
    x346 = x269 * x326 - x269 * x327
    x347 = x26 * x346 + x324
    x348 = x27 * x346 + x344
    x349 = x28 * x346 + x288 * x334 - x288 * x335
    x350 = x211 * x26 + x223
    x351 = x211 * x27 + x235
    x352 = x212 * x66
    x353 = x211 * x28 + x352
    x354 = x235 + x250 * x26
    x355 = x250 * x27 + x260
    x356 = x236 * x66
    x357 = x250 * x28 + x356
    x358 = x218 * x66
    x359 = x26 * x358 + x352
    x360 = x27 * x358 + x356
    x361 = x220 * x269
    x362 = x28 * x358 + x361
    x363 = x26 * x272 + x260
    x364 = x27 * x272 + x275
    x365 = x256 * x66
    x366 = x272 * x28 + x365
    x367 = x251 * x66
    x368 = x26 * x367 + x356
    x369 = x27 * x367 + x365
    x370 = x238 * x269
    x371 = x28 * x367 + x370
    x372 = x214 * x269
    x373 = x26 * x372 + x361
    x374 = x27 * x372 + x370
    x375 = x216 * x288 + x28 * x372
    x376 = x210 * x211 - x212 * x213 + x90
    x377 = x120 + x210 * x235 - x213 * x244
    x378 = x213 * x225
    x379 = x210 * x352 - x378 * x66 + x66 * (x210 * x212 - x378 + x94)
    x380 = x136 + x210 * x250 - x213 * x236
    x381 = x149 + x210 * x260 - x213 * x261
    x382 = x213 * x242
    x383 = x210 * x356 - x382 * x66 + x66 * (x121 + x210 * x236 - x382)
    x384 = x210 * x218
    x385 = x213 * x220
    x386 = x384 * x66 - x385 * x66 + x66 * (x384 - x385 + x91)
    x387 = x210 * x220
    x388 = x213 * x231
    x389 = (
        x269 * x387
        - x269 * x388
        + x71 * (x387 * x66 - x388 * x66 + x66 * (x387 - x388 + x95))
    )
    x390 = x158 + x210 * x272 - x213 * x256
    x391 = x213 * x258
    x392 = x210 * x365 - x391 * x66 + x66 * (x150 + x210 * x256 - x391)
    x393 = x210 * x251
    x394 = x213 * x238
    x395 = x393 * x66 - x394 * x66 + x66 * (x137 + x393 - x394)
    x396 = x210 * x238
    x397 = x213 * x240
    x398 = (
        x269 * x396
        - x269 * x397
        + x71 * (x396 * x66 - x397 * x66 + x66 * (x122 + x396 - x397))
    )
    x399 = x210 * x214
    x400 = x213 * x216
    x401 = (
        x269 * x399
        - x269 * x400
        + x71 * (x399 * x66 - x400 * x66 + x66 * (x399 - x400 + x92))
    )
    x402 = x210 * x216
    x403 = x213 * x228

    # 162 item(s)
    S = numpy.array(
        [
            x22 * x89
            + x26 * x93
            + x62
            + x63 * x74
            - x67 * (x52 * x63 - x67 * x80 + x73 * x83)
            + x73
            * (
                x63 * x72
                - x67 * x83
                + x71
                * (x63 * x70 + x66 * (x63 * x68 - x67 * x81 + x96) - x67 * x82 + x95)
                + x94
            ),
            x119 * x22 + x129 + x27 * x93,
            x130 * x88 + x28 * x93,
            x129 + x135 * x22 + x138 * x26,
            x138 * x27 + x148 * x22 + x154,
            x130 * x134 + x138 * x28,
            0,
            0,
            0,
            x154 + x157 * x22 + x159 * x26,
            x159 * x27 + x163 + x164 * x63 + x166 * x22 - x67 * (x160 * x63 - x165 * x67),
            x130 * x156 + x159 * x28,
            0,
            0,
            0,
            0,
            0,
            0,
            x181 + x23 * x89,
            x119 * x23 + x189,
            x190 * x88 + x191,
            x135 * x23 + x195,
            x148 * x23 + x201,
            x134 * x190 + x202,
            0,
            0,
            0,
            x157 * x23 + x205,
            x166 * x23 + x208,
            x156 * x190 + x209,
            0,
            0,
            0,
            0,
            0,
            0,
            x234 + x24 * x89,
            x119 * x24 + x246,
            x247 * x88 + x249,
            x135 * x24 + x255,
            x148 * x24 + x263,
            x134 * x247 + x265,
            x267,
            x268,
            x271,
            x157 * x24 + x274,
            x166 * x24 + x277,
            x156 * x247 + x279,
            x281,
            x282,
            x284,
            x286,
            x287,
            x289,
            x181 + x22 * x290,
            x189 + x22 * x291,
            x130 * x168 + x191,
            x195 + x22 * x292,
            x201 + x22 * x293,
            x130 * x193 + x202,
            0,
            0,
            0,
            x205 + x22 * x294,
            x208 + x22 * x295,
            x130 * x203 + x209,
            0,
            0,
            0,
            0,
            0,
            0,
            x167 * x176 - x170 * x180 + x23 * x290 + x26 * x296 + x62,
            x23 * x291 + x27 * x296 + x297,
            x168 * x190 + x28 * x296,
            x23 * x292 + x26 * x298 + x297,
            x23 * x293 + x27 * x298 + x299,
            x190 * x193 + x28 * x298,
            0,
            0,
            0,
            x23 * x294 + x26 * x300 + x299,
            x163
            + x167 * x206
            - x170 * x207
            + x23 * x295
            + x27 * x300
            + x73
            * (
                x150
                + x167 * x196
                - x170 * x197
                + x71
                * (
                    x122
                    + x167 * x183
                    - x170 * x184
                    + x66 * (x167 * x172 - x170 * x178 + x96)
                )
            ),
            x190 * x203 + x28 * x300,
            0,
            0,
            0,
            0,
            0,
            0,
            x24 * x290 + x302,
            x24 * x291 + x306,
            x168 * x247 + x308,
            x24 * x292 + x312,
            x24 * x293 + x318,
            x193 * x247 + x320,
            x322,
            x323,
            x325,
            x24 * x294 + x331,
            x24 * x295 + x338,
            x203 * x247 + x340,
            x342,
            x343,
            x345,
            x347,
            x348,
            x349,
            x22 * x350 + x234,
            x22 * x351 + x246,
            x22 * x353 + x249,
            x22 * x354 + x255,
            x22 * x355 + x263,
            x22 * x357 + x265,
            x22 * x359 + x267,
            x22 * x360 + x268,
            x22 * x362 + x271,
            x22 * x363 + x274,
            x22 * x364 + x277,
            x22 * x366 + x279,
            x22 * x368 + x281,
            x22 * x369 + x282,
            x22 * x371 + x284,
            x22 * x373 + x286,
            x22 * x374 + x287,
            x22 * x375 + x289,
            x23 * x350 + x302,
            x23 * x351 + x306,
            x23 * x353 + x308,
            x23 * x354 + x312,
            x23 * x355 + x318,
            x23 * x357 + x320,
            x23 * x359 + x322,
            x23 * x360 + x323,
            x23 * x362 + x325,
            x23 * x363 + x331,
            x23 * x364 + x338,
            x23 * x366 + x340,
            x23 * x368 + x342,
            x23 * x369 + x343,
            x23 * x371 + x345,
            x23 * x373 + x347,
            x23 * x374 + x348,
            x23 * x375 + x349,
            x210 * x223 - x213 * x233 + x24 * x350 + x26 * x376 + x62,
            x24 * x351 + x27 * x376 + x377,
            x24 * x353 + x28 * x376 + x379,
            x24 * x354 + x26 * x380 + x377,
            x24 * x355 + x27 * x380 + x381,
            x24 * x357 + x28 * x380 + x383,
            x24 * x359 + x26 * x386 + x379,
            x24 * x360 + x27 * x386 + x383,
            x24 * x362 + x28 * x386 + x389,
            x24 * x363 + x26 * x390 + x381,
            x163 + x210 * x275 - x213 * x276 + x24 * x364 + x27 * x390,
            x24 * x366 + x28 * x390 + x392,
            x24 * x368 + x26 * x395 + x383,
            x24 * x369 + x27 * x395 + x392,
            x24 * x371 + x28 * x395 + x398,
            x24 * x373 + x26 * x401 + x389,
            x24 * x374 + x27 * x401 + x398,
            x24 * x375
            + x28 * x401
            + x288 * x402
            - x288 * x403
            + x73
            * (
                x269 * x402
                - x269 * x403
                + x71 * (x402 * x66 - x403 * x66 + x66 * (x402 - x403 + x96))
            ),
        ]
    )
    return S


def eri_1122(a, A, b, B, c, C, d, D):
    """Cartesian [pp|dd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x10 * (x11**2 + x12**2 + x13**2))
    x15 = x6 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x8 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x10 * (a * A[0] + b * B[0])
    x24 = -x22 - x23
    x25 = x15 * (c * C[1] + d * D[1])
    x26 = -x10 * (a * A[1] + b * B[1])
    x27 = -x25 - x26
    x28 = -x10 * (a * A[2] + b * B[2])
    x29 = -x15 * (c * C[2] + d * D[2]) - x28
    x30 = x21 * x7 * (x24**2 + x27**2 + x29**2)
    x31 = boys(2, x30)
    x32 = -2 * x14 * x20 * x31 * x4 * x9
    x33 = x21 * x5
    x34 = boys(3, x30)
    x35 = 2 * x14 * x20 * x4 * x9
    x36 = x34 * x35
    x37 = x3 * (-x32 - x33 * x36)
    x38 = x22 - C[0]
    x39 = x31 * x35
    x40 = x24 * x33
    x41 = x36 * x40 + x38 * x39
    x42 = boys(4, x30)
    x43 = x35 * x42
    x44 = x36 * x38 + x40 * x43
    x45 = x33 * x44
    x46 = x24 * x45 + x37 + x38 * x41
    x47 = x33 * x46
    x48 = boys(1, x30)
    x49 = x3 * (2 * x14 * x20 * x4 * x48 * x9 - x33 * x39)
    x50 = x35 * x48
    x51 = x38 * x50 + x39 * x40
    x52 = x33 * x41
    x53 = x24 * x52 + x38 * x51 + x49
    x54 = 3 * x3
    x55 = 2 * x3
    x56 = x24 * x47 + x38 * x53 + x55 * (x51 - x52)
    x57 = -2 * x14 * x20 * x34 * x4 * x9
    x58 = x3 * (-x33 * x43 - x57)
    x59 = x35 * boys(5, x30)
    x60 = x38 * x43 + x40 * x59
    x61 = x33 * x60
    x62 = x24 * x61 + x38 * x44 + x58
    x63 = x33 * x62
    x64 = x24 * x63 + x38 * x46 + x55 * (x41 - x45)
    x65 = x38 * x56 + x40 * x64 + x54 * (-x47 + x53)
    x66 = x21 * x6
    x67 = x65 * x66
    x68 = x33 * x53
    x69 = boys(0, x30)
    x70 = x3 * (2 * x14 * x20 * x4 * x69 * x9 - x33 * x50)
    x71 = x35 * x69
    x72 = x38 * x71 + x40 * x50
    x73 = x33 * x51
    x74 = x24 * x73 + x38 * x72 + x70
    x75 = x24 * x68 + x38 * x74 + x55 * (x72 - x73)
    x76 = x38 * x75 + x40 * x56 + x54 * (-x68 + x74)
    x77 = x1 * (-x67 + x76)
    x78 = -x23 - A[0]
    x79 = x64 * x66
    x80 = x62 * x66
    x81 = x0 + x2
    x82 = x81 ** (-1.0)
    x83 = x24 * x66
    x84 = x43 * x78 - x59 * x83
    x85 = x60 * x66
    x86 = -x24 * x85 + x44 * x78 + x82 * x84
    x87 = 2 * x82
    x88 = -x24 * x80 + x46 * x78 + x86 * x87
    x89 = 3 * x82
    x90 = -x24 * x79 + x56 * x78 + x88 * x89
    x91 = 4 * x82
    x92 = -x24 * x67 + x76 * x78 + x90 * x91
    x93 = -2 * x14 * x20 * x4 * x42 * x9
    x94 = x3 * (-x33 * x59 - x93)
    x95 = x35 * boys(6, x30)
    x96 = x38 * x59 + x40 * x95
    x97 = x38 * x60 + x40 * x96 + x94
    x98 = x38 * x62 + x40 * x97 + x55 * (x44 - x61)
    x99 = x38 * x64 + x40 * x98 + x54 * (x46 - x63)
    x100 = x59 * x78 - x83 * x95
    x101 = x100 * x82 + x60 * x78 - x83 * x96
    x102 = x101 * x87 + x62 * x78 - x83 * x97
    x103 = x102 * x89 + x64 * x78 - x83 * x98
    x104 = x56 * x66
    x105 = x1 * (-x104 + x75)
    x106 = x46 * x66
    x107 = x36 * x78 - x43 * x83
    x108 = x44 * x66
    x109 = x107 * x82 - x108 * x24 + x41 * x78
    x110 = -x106 * x24 + x109 * x87 + x53 * x78
    x111 = -x104 * x24 + x110 * x89 + x75 * x78
    x112 = x1 * (-x106 + x53)
    x113 = x1 * (-x108 + x41)
    x114 = x1 * (-x43 * x66 - x57)
    x115 = (
        x105
        + x111 * x78
        - x83 * x90
        + x89
        * (
            x110 * x78
            + x112
            - x83 * x88
            + x87
            * (x109 * x78 + x113 + x82 * (x107 * x78 + x114 - x83 * x84) - x83 * x86)
        )
    )
    x116 = x1 * (x56 - x79)
    x117 = x1 * (x46 - x80)
    x118 = x1 * (x44 - x85)
    x119 = x1 * (-x59 * x66 - x93)
    x120 = x53 * x66
    x121 = -x36 * x83 + x39 * x78
    x122 = x41 * x66
    x123 = x121 * x82 - x122 * x24 + x51 * x78
    x124 = -x120 * x24 + x123 * x87 + x74 * x78
    x125 = x124 * x16
    x126 = x111 * x16 + x16 * (x111 + x125) + x92
    x127 = x1 * (-x120 + x74)
    x128 = x1 * (-x122 + x51)
    x129 = x1 * (-x32 - x36 * x66)
    x130 = (
        -x110 * x83
        + x124 * x78
        + x127
        + x87
        * (-x109 * x83 + x123 * x78 + x128 + x82 * (-x107 * x83 + x121 * x78 + x129))
    )
    x131 = x130 * x16
    x132 = x124 * x17
    x133 = x25 - C[1]
    x134 = x27 * x33
    x135 = x133 * x50 + x134 * x39
    x136 = x135 * x33
    x137 = x133 * x71 + x134 * x50
    x138 = x3 * (-x136 + x137)
    x139 = x136 * x24 + x137 * x38
    x140 = x133 * x39 + x134 * x36
    x141 = x140 * x33
    x142 = x135 * x38 + x141 * x24
    x143 = x142 * x33
    x144 = x138 + x139 * x38 + x143 * x24
    x145 = x3 * (x135 - x141)
    x146 = x133 * x36 + x134 * x43
    x147 = x146 * x33
    x148 = x140 * x38 + x147 * x24
    x149 = x148 * x33
    x150 = x142 * x38 + x145 + x149 * x24
    x151 = x150 * x66
    x152 = x146 * x66
    x153 = x140 * x78 - x152 * x24
    x154 = x148 * x66
    x155 = x142 * x78 + x153 * x82 - x154 * x24
    x156 = x144 * x78 - x151 * x24 + x155 * x87
    x157 = x132 + x156
    x158 = x144 * x38 + x150 * x40 + x55 * (x139 - x143)
    x159 = x3 * (x140 - x147)
    x160 = x133 * x43 + x134 * x59
    x161 = x160 * x33
    x162 = x146 * x38 + x161 * x24
    x163 = x162 * x33
    x164 = x148 * x38 + x159 + x163 * x24
    x165 = x150 * x38 + x164 * x40 + x55 * (x142 - x149)
    x166 = x165 * x66
    x167 = x164 * x66
    x168 = x160 * x66
    x169 = x146 * x78 - x168 * x24
    x170 = x162 * x66
    x171 = x148 * x78 + x169 * x82 - x170 * x24
    x172 = x150 * x78 - x167 * x24 + x171 * x87
    x173 = x158 * x78 - x166 * x24 + x172 * x89
    x174 = x111 * x17 + x157 * x16 + x173
    x175 = x130 * x17
    x176 = x1 * (x144 - x151)
    x177 = x1 * (x142 - x154)
    x178 = x1 * (x140 - x152)
    x179 = (
        x156 * x78
        - x172 * x83
        + x176
        + x87 * (x155 * x78 - x171 * x83 + x177 + x82 * (x153 * x78 - x169 * x83 + x178))
    )
    x180 = x175 + x179
    x181 = x1 * (x158 - x166)
    x182 = x1 * (x150 - x167)
    x183 = x3 * (x146 - x161)
    x184 = x133 * x59 + x134 * x95
    x185 = x160 * x38 + x184 * x40
    x186 = x162 * x38 + x183 + x185 * x40
    x187 = x160 * x78 - x184 * x83
    x188 = x162 * x78 - x185 * x83 + x187 * x82
    x189 = x164 * x78 - x186 * x83 + x188 * x87
    x190 = x1 * (x148 - x170)
    x191 = x1 * (x146 - x168)
    x192 = x164 * x38 + x186 * x40 + x55 * (x148 - x163)
    x193 = (
        x173 * x78
        + x181
        - x83 * (x165 * x78 + x189 * x89 - x192 * x83)
        + x89
        * (
            x172 * x78
            + x182
            - x189 * x83
            + x87
            * (x171 * x78 - x188 * x83 + x190 + x82 * (x169 * x78 - x187 * x83 + x191))
        )
    )
    x194 = x111 * x18 + x125 * x18
    x195 = x133 * x135 + x141 * x27 + x49
    x196 = x195 * x33
    x197 = x133 * x137 + x136 * x27 + x70
    x198 = x3 * (-x196 + x197)
    x199 = x196 * x24 + x197 * x38
    x200 = x133 * x140 + x147 * x27 + x37
    x201 = x200 * x33
    x202 = x195 * x38 + x201 * x24
    x203 = x198 + x199 * x38 + x202 * x40
    x204 = x3 * (x195 - x201)
    x205 = x133 * x146 + x161 * x27 + x58
    x206 = x205 * x33
    x207 = x200 * x38 + x206 * x24
    x208 = x202 * x38 + x204 + x207 * x40
    x209 = x208 * x66
    x210 = x205 * x66
    x211 = x200 * x78 - x210 * x24
    x212 = x207 * x66
    x213 = x202 * x78 + x211 * x82 - x212 * x24
    x214 = x203 * x78 - x209 * x24 + x213 * x87
    x215 = x156 * x17 + x214
    x216 = x157 * x17 + x215
    x217 = x1 * (x203 - x209)
    x218 = x1 * (x202 - x212)
    x219 = x1 * (x200 - x210)
    x220 = x133 * x160 + x134 * x184 + x94
    x221 = x205 * x78 - x220 * x83
    x222 = x205 * x38 + x220 * x40
    x223 = x207 * x78 + x221 * x82 - x222 * x83
    x224 = x3 * (x200 - x206)
    x225 = x207 * x38 + x222 * x40 + x224
    x226 = (
        x214 * x78
        + x217
        - x83 * (x208 * x78 + x223 * x87 - x225 * x83)
        + x87 * (x213 * x78 + x218 - x223 * x83 + x82 * (x211 * x78 + x219 - x221 * x83))
    )
    x227 = x17 * x179 + x226
    x228 = x156 * x18
    x229 = x132 * x18 + x228
    x230 = x179 * x18
    x231 = x11 * x19
    x232 = x140 * x66
    x233 = x135 * x78 - x232 * x24
    x234 = x142 * x66
    x235 = x139 * x78 + x233 * x82 - x234 * x24
    x236 = x16 * x235
    x237 = x156 * x16 + x16 * (x156 + x236) + x173
    x238 = x1 * (x139 - x234)
    x239 = x1 * (x135 - x232)
    x240 = -x155 * x83 + x235 * x78 + x238 + x82 * (-x153 * x83 + x233 * x78 + x239)
    x241 = x16 * x240
    x242 = x17 * x235
    x243 = x200 * x66
    x244 = x195 * x78 - x24 * x243
    x245 = x202 * x66
    x246 = x199 * x78 - x24 * x245 + x244 * x82
    x247 = x242 + x246
    x248 = x16 * x247 + x215
    x249 = x17 * x240
    x250 = x1 * (x199 - x245)
    x251 = x1 * (x195 - x243)
    x252 = -x213 * x83 + x246 * x78 + x250 + x82 * (-x211 * x83 + x244 * x78 + x251)
    x253 = x249 + x252
    x254 = x18 * x236 + x228
    x255 = x133 * x195 + 2 * x145 + x201 * x27
    x256 = x133 * x200 + 2 * x159 + x206 * x27
    x257 = x256 * x66
    x258 = -x24 * x257 + x255 * x78
    x259 = x133 * x197 + 2 * x138 + x196 * x27
    x260 = x255 * x40 + x259 * x38
    x261 = x255 * x38 + x256 * x40
    x262 = x261 * x66
    x263 = -x24 * x262 + x258 * x82 + x260 * x78
    x264 = x17 * x246 + x263
    x265 = x17 * x247 + x264
    x266 = x1 * (x260 - x262)
    x267 = x1 * (x255 - x257)
    x268 = x133 * x205 + x134 * x220 + 2 * x183
    x269 = x256 * x78 - x268 * x83
    x270 = x256 * x38 + x268 * x40
    x271 = (
        x17 * x252
        + x263 * x78
        + x266
        + x82 * (x258 * x78 + x267 - x269 * x83)
        - x83 * (x261 * x78 + x269 * x82 - x270 * x83)
    )
    x272 = x18 * x246
    x273 = x18 * x242 + x272
    x274 = x18 * x252
    x275 = x195 * x66
    x276 = x197 * x78 - x24 * x275
    x277 = x16 * x276
    x278 = x16 * x246 + x16 * (x246 + x277) + x214
    x279 = x1 * (x197 - x275)
    x280 = -x244 * x83 + x276 * x78 + x279
    x281 = x16 * x280
    x282 = x17 * x276
    x283 = x255 * x66
    x284 = -x24 * x283 + x259 * x78
    x285 = x282 + x284
    x286 = x16 * x285 + x264
    x287 = x17 * x280
    x288 = x1 * (x259 - x283)
    x289 = -x258 * x83 + x284 * x78 + x288
    x290 = x287 + x289
    x291 = x18 * x277 + x272
    x292 = x133 * x255 + x134 * x256 + 3 * x204
    x293 = x292 * x66
    x294 = x133 * x259 + x134 * x255 + 3 * x198
    x295 = x1 * (-x293 + x294)
    x296 = -x24 * x293 + x294 * x78
    x297 = x133 * x256 + x134 * x268 + 3 * x224
    x298 = x17 * x284 + x17 * x285 + x296
    x299 = x18 * x282 + x18 * x284
    x300 = -x26 - A[1]
    x301 = -x104 * x27 + x300 * x75
    x302 = -x27 * x79 + x300 * x56
    x303 = -x106 * x27 + x300 * x53
    x304 = -x27 * x80 + x300 * x46
    x305 = x27 * x66
    x306 = x300 * x36 - x305 * x43
    x307 = x300 * x43 - x305 * x59
    x308 = -x108 * x27 + x300 * x41
    x309 = -x27 * x85 + x300 * x44
    x310 = (
        x301 * x78
        - x302 * x83
        + x89
        * (
            x303 * x78
            - x304 * x83
            + x87 * (x308 * x78 - x309 * x83 + x82 * (x306 * x78 - x307 * x83))
        )
    )
    x311 = -x120 * x27 + x300 * x74
    x312 = x300 * x39 - x305 * x36
    x313 = -x122 * x27 + x300 * x51
    x314 = (
        -x303 * x83
        + x311 * x78
        + x87 * (-x308 * x83 + x313 * x78 + x82 * (-x306 * x83 + x312 * x78))
    )
    x315 = x16 * x314
    x316 = -x27 * x67 + x300 * x76
    x317 = x300 * x64 - x305 * x98
    x318 = x300 * x62 - x305 * x97
    x319 = x300 * x59 - x305 * x95
    x320 = x300 * x60 - x305 * x96
    x321 = x300 * x65 - x305 * x99
    x322 = (
        x16 * x310
        + x16 * (x310 + x315)
        + x316 * x78
        - x321 * x83
        + x91
        * (
            x302 * x78
            - x317 * x83
            + x89
            * (
                x304 * x78
                - x318 * x83
                + x87 * (x309 * x78 - x320 * x83 + x82 * (x307 * x78 - x319 * x83))
            )
        )
    )
    x323 = x17 * x314
    x324 = x144 * x300 - x151 * x27 + x303 * x82
    x325 = x150 * x300 - x167 * x27 + x304 * x82
    x326 = x140 * x300 - x152 * x27 + x306 * x82
    x327 = x146 * x300 - x168 * x27 + x307 * x82
    x328 = x142 * x300 - x154 * x27 + x308 * x82
    x329 = x148 * x300 - x170 * x27 + x309 * x82
    x330 = (
        x324 * x78
        - x325 * x83
        + x87 * (x328 * x78 - x329 * x83 + x82 * (x326 * x78 - x327 * x83))
    )
    x331 = x323 + x330
    x332 = x158 * x300 - x166 * x27 + x302 * x82
    x333 = x164 * x300 - x186 * x305 + x318 * x82
    x334 = x160 * x300 - x184 * x305 + x319 * x82
    x335 = x162 * x300 - x185 * x305 + x320 * x82
    x336 = x165 * x300 - x192 * x305 + x317 * x82
    x337 = (
        x332 * x78
        - x336 * x83
        + x89
        * (
            x325 * x78
            - x333 * x83
            + x87 * (x329 * x78 - x335 * x83 + x82 * (x327 * x78 - x334 * x83))
        )
    )
    x338 = x16 * x331 + x17 * x310 + x337
    x339 = x18 * x310 + x18 * x315
    x340 = x203 * x300 - x209 * x27 + x325 * x87
    x341 = x200 * x300 - x210 * x27 + x327 * x87
    x342 = x205 * x300 - x220 * x305 + x334 * x87
    x343 = x202 * x300 - x212 * x27 + x329 * x87
    x344 = x207 * x300 - x222 * x305 + x335 * x87
    x345 = x208 * x300 - x225 * x305 + x333 * x87
    x346 = (
        x340 * x78
        - x345 * x83
        + x87 * (x343 * x78 - x344 * x83 + x82 * (x341 * x78 - x342 * x83))
    )
    x347 = x17 * x330 + x346
    x348 = x17 * x331 + x347
    x349 = x18 * x330
    x350 = x18 * x323 + x349
    x351 = x12 * x19
    x352 = x19 * x314
    x353 = x135 * x300 - x232 * x27 + x312 * x82
    x354 = x139 * x300 - x234 * x27 + x313 * x82
    x355 = -x328 * x83 + x354 * x78 + x82 * (-x326 * x83 + x353 * x78)
    x356 = x16 * x355
    x357 = x16 * x330 + x16 * (x330 + x356) + x337
    x358 = x17 * x355
    x359 = x195 * x300 - x243 * x27 + x326 * x87
    x360 = x199 * x300 - x245 * x27 + x328 * x87
    x361 = -x343 * x83 + x360 * x78 + x82 * (-x341 * x83 + x359 * x78)
    x362 = x358 + x361
    x363 = x16 * x362 + x347
    x364 = x18 * x356 + x349
    x365 = x255 * x300 - x257 * x27 + x341 * x89
    x366 = x256 * x300 - x268 * x305 + x342 * x89
    x367 = x260 * x300 - x262 * x27 + x343 * x89
    x368 = x261 * x300 - x270 * x305 + x344 * x89
    x369 = x17 * x361 + x367 * x78 - x368 * x83 + x82 * (x365 * x78 - x366 * x83)
    x370 = x17 * x362 + x369
    x371 = x18 * x361
    x372 = x18 * x358 + x371
    x373 = x19 * x355
    x374 = x197 * x300 - x27 * x275 + x353 * x87
    x375 = -x359 * x83 + x374 * x78
    x376 = x16 * x375
    x377 = x16 * x361 + x16 * (x361 + x376) + x346
    x378 = x17 * x375
    x379 = x259 * x300 - x27 * x283 + x359 * x89
    x380 = -x365 * x83 + x379 * x78
    x381 = x378 + x380
    x382 = x16 * x381 + x369
    x383 = x18 * x376 + x371
    x384 = -x27 * x293 + x294 * x300 + x365 * x91
    x385 = x292 * x300 - x297 * x305 + x366 * x91
    x386 = x17 * x380 + x17 * x381 + x384 * x78 - x385 * x83
    x387 = x18 * x378 + x18 * x380
    x388 = x19 * x375
    x389 = -x28 - A[2]
    x390 = -x104 * x29 + x389 * x75
    x391 = -x29 * x79 + x389 * x56
    x392 = -x106 * x29 + x389 * x53
    x393 = x392 * x78
    x394 = -x29 * x80 + x389 * x46
    x395 = x394 * x83
    x396 = x29 * x66
    x397 = x36 * x389 - x396 * x43
    x398 = x397 * x78
    x399 = x389 * x43 - x396 * x59
    x400 = x399 * x83
    x401 = -x108 * x29 + x389 * x41
    x402 = x401 * x78
    x403 = -x29 * x85 + x389 * x44
    x404 = x403 * x83
    x405 = (
        x390 * x78
        - x391 * x83
        + x89 * (x393 - x395 + x87 * (x402 - x404 + x82 * (x398 - x400)))
    )
    x406 = -x120 * x29 + x389 * x74
    x407 = -x36 * x396 + x389 * x39
    x408 = x407 * x78
    x409 = x397 * x83
    x410 = -x122 * x29 + x389 * x51
    x411 = x410 * x78
    x412 = x401 * x83
    x413 = -x392 * x83 + x406 * x78 + x87 * (x411 - x412 + x82 * (x408 - x409))
    x414 = -x29 * x67 + x389 * x76
    x415 = x391 * x78
    x416 = x389 * x64 - x396 * x98
    x417 = x416 * x83
    x418 = x394 * x78
    x419 = x389 * x62 - x396 * x97
    x420 = x419 * x83
    x421 = x399 * x78
    x422 = x389 * x59 - x396 * x95
    x423 = x422 * x83
    x424 = x403 * x78
    x425 = x389 * x60 - x396 * x96
    x426 = x425 * x83
    x427 = x389 * x65 - x396 * x99
    x428 = (
        x16 * x405
        + x16 * (x16 * x413 + x405)
        + x414 * x78
        - x427 * x83
        + x91
        * (x415 - x417 + x89 * (x418 - x420 + x87 * (x424 - x426 + x82 * (x421 - x423))))
    )
    x429 = x144 * x389 - x151 * x29
    x430 = x150 * x389 - x167 * x29
    x431 = x142 * x389 - x154 * x29
    x432 = x431 * x78
    x433 = x140 * x389 - x152 * x29
    x434 = x433 * x78
    x435 = x146 * x389 - x168 * x29
    x436 = x435 * x83
    x437 = x148 * x389 - x170 * x29
    x438 = x437 * x83
    x439 = x429 * x78 - x430 * x83 + x87 * (x432 - x438 + x82 * (x434 - x436))
    x440 = x17 * x413 + x439
    x441 = x158 * x389 - x166 * x29
    x442 = x430 * x78
    x443 = x164 * x389 - x186 * x396
    x444 = x443 * x83
    x445 = x437 * x78
    x446 = x435 * x78
    x447 = x160 * x389 - x184 * x396
    x448 = x447 * x83
    x449 = x162 * x389 - x185 * x396
    x450 = x449 * x83
    x451 = x165 * x389 - x192 * x396
    x452 = (
        x441 * x78
        - x451 * x83
        + x89 * (x442 - x444 + x87 * (x445 - x450 + x82 * (x446 - x448)))
    )
    x453 = x16 * x440 + x17 * x405 + x452
    x454 = (
        x393 * x82
        - x395 * x82
        + x87 * (x402 * x82 - x404 * x82 + x82 * (x398 * x82 - x400 * x82))
    )
    x455 = x18 * x413 + x454
    x456 = (
        x415 * x82
        - x417 * x82
        + x89
        * (
            x418 * x82
            - x420 * x82
            + x87 * (x424 * x82 - x426 * x82 + x82 * (x421 * x82 - x423 * x82))
        )
    )
    x457 = x16 * x455 + x18 * x405 + x456
    x458 = x203 * x389 - x209 * x29
    x459 = x202 * x389 - x212 * x29
    x460 = x459 * x78
    x461 = x200 * x389 - x210 * x29
    x462 = x461 * x78
    x463 = x205 * x389 - x220 * x396
    x464 = x463 * x83
    x465 = x207 * x389 - x222 * x396
    x466 = x465 * x83
    x467 = x208 * x389 - x225 * x396
    x468 = x458 * x78 - x467 * x83 + x87 * (x460 - x466 + x82 * (x462 - x464))
    x469 = x17 * x439 + x468
    x470 = x17 * x440 + x469
    x471 = (
        x442 * x82
        - x444 * x82
        + x87 * (x445 * x82 - x450 * x82 + x82 * (x446 * x82 - x448 * x82))
    )
    x472 = x18 * x439 + x471
    x473 = x17 * x455 + x472
    x474 = x13 * x19
    x475 = 2 / x81**2
    x476 = (
        x418 * x475
        - x420 * x475
        + x87 * (x424 * x475 - x426 * x475 + x82 * (x421 * x475 - x423 * x475))
    )
    x477 = x18 * x454 + x476
    x478 = x18 * x455 + x477
    x479 = x139 * x389 - x234 * x29
    x480 = x135 * x389 - x232 * x29
    x481 = x480 * x78
    x482 = x433 * x83
    x483 = -x431 * x83 + x479 * x78 + x82 * (x481 - x482)
    x484 = x16 * x439 + x16 * (x16 * x483 + x439) + x452
    x485 = x199 * x389 - x245 * x29
    x486 = x195 * x389 - x243 * x29
    x487 = x486 * x78
    x488 = x461 * x83
    x489 = -x459 * x83 + x485 * x78 + x82 * (x487 - x488)
    x490 = x17 * x483 + x489
    x491 = x16 * x490 + x469
    x492 = x432 * x82 - x438 * x82 + x82 * (x434 * x82 - x436 * x82)
    x493 = x18 * x483 + x492
    x494 = x16 * x493 + x472
    x495 = x255 * x389 - x257 * x29
    x496 = x495 * x78
    x497 = x256 * x389 - x268 * x396
    x498 = x497 * x83
    x499 = x260 * x389 - x262 * x29
    x500 = x261 * x389 - x270 * x396
    x501 = x17 * x489 + x499 * x78 - x500 * x83 + x82 * (x496 - x498)
    x502 = x17 * x490 + x501
    x503 = x460 * x82 - x466 * x82 + x82 * (x462 * x82 - x464 * x82)
    x504 = x18 * x489 + x503
    x505 = x17 * x493 + x504
    x506 = x445 * x475 - x450 * x475 + x82 * (x446 * x475 - x448 * x475)
    x507 = x18 * x492 + x506
    x508 = x18 * x493 + x507
    x509 = x411 * x82 - x412 * x82 + x82 * (x408 * x82 - x409 * x82)
    x510 = x16 * x454 + x16 * (x16 * x509 + x454) + x456
    x511 = x17 * x509 + x492
    x512 = x16 * x511 + x17 * x454 + x471
    x513 = x402 * x475 - x404 * x475 + x82 * (x398 * x475 - x400 * x475)
    x514 = x18 * x509 + x513
    x515 = x16 * x514 + x477
    x516 = x17 * x492 + x503
    x517 = x17 * x511 + x516
    x518 = x17 * x514 + x507
    x519 = 6 / x81**3
    x520 = x18 * x513 + x424 * x519 - x426 * x519 + x82 * (x421 * x519 - x423 * x519)
    x521 = x18 * x514 + x520
    x522 = x197 * x389 - x275 * x29
    x523 = -x486 * x83 + x522 * x78
    x524 = x16 * x489 + x16 * (x16 * x523 + x489) + x468
    x525 = x259 * x389 - x283 * x29
    x526 = -x495 * x83 + x525 * x78
    x527 = x17 * x523 + x526
    x528 = x16 * x527 + x501
    x529 = x487 * x82 - x488 * x82
    x530 = x18 * x523 + x529
    x531 = x16 * x530 + x504
    x532 = -x29 * x293 + x294 * x389
    x533 = x292 * x389 - x297 * x396
    x534 = x17 * x526 + x17 * x527 + x532 * x78 - x533 * x83
    x535 = x496 * x82 - x498 * x82
    x536 = x17 * x530 + x18 * x526 + x535
    x537 = x462 * x475 - x464 * x475
    x538 = x18 * x529 + x537
    x539 = x18 * x530 + x538
    x540 = x481 * x82 - x482 * x82
    x541 = x16 * x492 + x16 * (x16 * x540 + x492) + x471
    x542 = x17 * x540 + x529
    x543 = x16 * x542 + x516
    x544 = x434 * x475 - x436 * x475
    x545 = x18 * x540 + x544
    x546 = x16 * x545 + x507
    x547 = x17 * x529 + x17 * x542 + x535
    x548 = x17 * x545 + x538
    x549 = x18 * x544 + x446 * x519 - x448 * x519
    x550 = x18 * x545 + x549
    x551 = x408 * x475 - x409 * x475
    x552 = x16 * x513 + x16 * (x16 * x551 + x513) + x476
    x553 = x17 * x551 + x544
    x554 = x16 * x553 + x17 * x513 + x506
    x555 = x398 * x519 - x400 * x519
    x556 = x18 * x551 + x555
    x557 = x16 * x556 + x520
    x558 = x17 * x544 + x17 * x553 + x537
    x559 = x17 * x556 + x549
    x560 = 24 / x81**4
    x561 = x18 * x555 + x18 * x556 + x421 * x560 - x423 * x560
    x562 = x16 * x311
    x563 = x16 * x301 + x16 * (x301 + x562) + x316
    x564 = x17 * x311
    x565 = x324 + x564
    x566 = x16 * x565 + x17 * x301 + x332
    x567 = x18 * x301 + x18 * x562
    x568 = x17 * x324 + x340
    x569 = x17 * x565 + x568
    x570 = x18 * x324
    x571 = x18 * x564 + x570
    x572 = x16 * x354
    x573 = x16 * x324 + x16 * (x324 + x572) + x332
    x574 = x17 * x354
    x575 = x360 + x574
    x576 = x16 * x575 + x568
    x577 = x18 * x572 + x570
    x578 = x17 * x360 + x367
    x579 = x17 * x575 + x578
    x580 = x18 * x360
    x581 = x18 * x574 + x580
    x582 = x16 * x374
    x583 = x16 * x360 + x16 * (x360 + x582) + x340
    x584 = x17 * x374
    x585 = x379 + x584
    x586 = x16 * x585 + x578
    x587 = x18 * x582 + x580
    x588 = x17 * x379 + x17 * x585 + x384
    x589 = x18 * x379 + x18 * x584
    x590 = x105 + x300 * x301 - x302 * x305
    x591 = x127 + x300 * x311 - x303 * x305
    x592 = x16 * x591
    x593 = x17 * x591
    x594 = x176 + x300 * x324 - x305 * x325 + x82 * (x112 + x300 * x303 - x304 * x305)
    x595 = x593 + x594
    x596 = x181 + x300 * x332 - x305 * x336 + x82 * (x116 + x300 * x302 - x305 * x317)
    x597 = (
        x217
        + x300 * x340
        - x305 * x345
        + x87
        * (x182 + x300 * x325 - x305 * x333 + x82 * (x117 + x300 * x304 - x305 * x318))
    )
    x598 = x17 * x594 + x597
    x599 = x18 * x594
    x600 = x238 + x300 * x354 - x305 * x328 + x82 * (x128 + x300 * x313 - x305 * x308)
    x601 = x16 * x600
    x602 = x17 * x600
    x603 = (
        x250
        + x300 * x360
        - x305 * x343
        + x87
        * (x177 + x300 * x328 - x305 * x329 + x82 * (x113 + x300 * x308 - x305 * x309))
    )
    x604 = x602 + x603
    x605 = (
        x17 * x603
        + x266
        + x300 * x367
        - x305 * x368
        + x89
        * (
            x218
            + x300 * x343
            - x305 * x344
            + x87
            * (
                x190
                + x300 * x329
                - x305 * x335
                + x82 * (x118 + x300 * x309 - x305 * x320)
            )
        )
    )
    x606 = x18 * x603
    x607 = (
        x279
        + x300 * x374
        - x305 * x359
        + x87
        * (x239 + x300 * x353 - x305 * x326 + x82 * (x129 + x300 * x312 - x305 * x306))
    )
    x608 = x16 * x607
    x609 = x17 * x607
    x610 = (
        x288
        + x300 * x379
        - x305 * x365
        + x89
        * (
            x251
            + x300 * x359
            - x305 * x341
            + x87
            * (
                x178
                + x300 * x326
                - x305 * x327
                + x82 * (x114 + x300 * x306 - x305 * x307)
            )
        )
    )
    x611 = x609 + x610
    x612 = x300 * x390 - x305 * x391
    x613 = x300 * x406 - x305 * x392
    x614 = x16 * x612 + x16 * (x16 * x613 + x612) + x300 * x414 - x305 * x427
    x615 = x300 * x392
    x616 = x305 * x394
    x617 = x300 * x429 - x305 * x430 + x82 * (x615 - x616)
    x618 = x17 * x613 + x617
    x619 = x300 * x391
    x620 = x305 * x416
    x621 = x300 * x441 - x305 * x451 + x82 * (x619 - x620)
    x622 = x16 * x618 + x17 * x612 + x621
    x623 = x615 * x82 - x616 * x82
    x624 = x18 * x613 + x623
    x625 = x619 * x82 - x620 * x82
    x626 = x16 * x624 + x18 * x612 + x625
    x627 = x300 * x394
    x628 = x305 * x419
    x629 = x300 * x430
    x630 = x305 * x443
    x631 = x300 * x458 - x305 * x467 + x87 * (x629 - x630 + x82 * (x627 - x628))
    x632 = x17 * x617 + x631
    x633 = x17 * x618 + x632
    x634 = x629 * x82 - x630 * x82 + x82 * (x627 * x82 - x628 * x82)
    x635 = x18 * x617 + x634
    x636 = x17 * x624 + x635
    x637 = x475 * x627 - x475 * x628
    x638 = x18 * x623 + x637
    x639 = x18 * x624 + x638
    x640 = x300 * x410
    x641 = x305 * x401
    x642 = x300 * x479 - x305 * x431 + x82 * (x640 - x641)
    x643 = x16 * x617 + x16 * (x16 * x642 + x617) + x621
    x644 = x300 * x431
    x645 = x300 * x401
    x646 = x305 * x403
    x647 = x305 * x437
    x648 = x300 * x485 - x305 * x459 + x87 * (x644 - x647 + x82 * (x645 - x646))
    x649 = x17 * x642 + x648
    x650 = x16 * x649 + x632
    x651 = x644 * x82 - x647 * x82 + x82 * (x645 * x82 - x646 * x82)
    x652 = x18 * x642 + x651
    x653 = x16 * x652 + x635
    x654 = x300 * x459
    x655 = x305 * x465
    x656 = x300 * x437
    x657 = x300 * x403
    x658 = x305 * x425
    x659 = x305 * x449
    x660 = (
        x17 * x648
        + x300 * x499
        - x305 * x500
        + x89 * (x654 - x655 + x87 * (x656 - x659 + x82 * (x657 - x658)))
    )
    x661 = x17 * x649 + x660
    x662 = (
        x654 * x82
        - x655 * x82
        + x87 * (x656 * x82 - x659 * x82 + x82 * (x657 * x82 - x658 * x82))
    )
    x663 = x18 * x648 + x662
    x664 = x17 * x652 + x663
    x665 = x475 * x656 - x475 * x659 + x82 * (x475 * x657 - x475 * x658)
    x666 = x18 * x651 + x665
    x667 = x18 * x652 + x666
    x668 = x640 * x82 - x641 * x82
    x669 = x16 * x623 + x16 * (x16 * x668 + x623) + x625
    x670 = x17 * x668 + x651
    x671 = x16 * x670 + x17 * x623 + x634
    x672 = x475 * x645 - x475 * x646
    x673 = x18 * x668 + x672
    x674 = x16 * x673 + x638
    x675 = x17 * x651 + x662
    x676 = x17 * x670 + x675
    x677 = x17 * x673 + x666
    x678 = x18 * x672 + x519 * x657 - x519 * x658
    x679 = x18 * x673 + x678
    x680 = x300 * x407
    x681 = x305 * x397
    x682 = x300 * x480
    x683 = x305 * x433
    x684 = x300 * x522 - x305 * x486 + x87 * (x682 - x683 + x82 * (x680 - x681))
    x685 = x16 * x648 + x16 * (x16 * x684 + x648) + x631
    x686 = x300 * x486
    x687 = x305 * x461
    x688 = x300 * x397
    x689 = x305 * x399
    x690 = x300 * x433
    x691 = x305 * x435
    x692 = (
        x300 * x525
        - x305 * x495
        + x89 * (x686 - x687 + x87 * (x690 - x691 + x82 * (x688 - x689)))
    )
    x693 = x17 * x684 + x692
    x694 = x16 * x693 + x660
    x695 = (
        x686 * x82
        - x687 * x82
        + x87 * (x690 * x82 - x691 * x82 + x82 * (x688 * x82 - x689 * x82))
    )
    x696 = x18 * x684 + x695
    x697 = x16 * x696 + x663
    x698 = x300 * x495
    x699 = x305 * x497
    x700 = x300 * x461
    x701 = x305 * x463
    x702 = x300 * x399
    x703 = x305 * x422
    x704 = x300 * x435
    x705 = x305 * x447
    x706 = (
        x17 * x692
        + x17 * x693
        + x300 * x532
        - x305 * x533
        + x91
        * (x698 - x699 + x89 * (x700 - x701 + x87 * (x704 - x705 + x82 * (x702 - x703))))
    )
    x707 = (
        x698 * x82
        - x699 * x82
        + x89
        * (
            x700 * x82
            - x701 * x82
            + x87 * (x704 * x82 - x705 * x82 + x82 * (x702 * x82 - x703 * x82))
        )
    )
    x708 = x17 * x696 + x18 * x692 + x707
    x709 = (
        x475 * x700
        - x475 * x701
        + x87 * (x475 * x704 - x475 * x705 + x82 * (x475 * x702 - x475 * x703))
    )
    x710 = x18 * x695 + x709
    x711 = x18 * x696 + x710
    x712 = x682 * x82 - x683 * x82 + x82 * (x680 * x82 - x681 * x82)
    x713 = x16 * x651 + x16 * (x16 * x712 + x651) + x634
    x714 = x17 * x712 + x695
    x715 = x16 * x714 + x675
    x716 = x475 * x690 - x475 * x691 + x82 * (x475 * x688 - x475 * x689)
    x717 = x18 * x712 + x716
    x718 = x16 * x717 + x666
    x719 = x17 * x695 + x17 * x714 + x707
    x720 = x17 * x717 + x710
    x721 = x18 * x716 + x519 * x704 - x519 * x705 + x82 * (x519 * x702 - x519 * x703)
    x722 = x18 * x717 + x721
    x723 = x475 * x680 - x475 * x681
    x724 = x16 * x672 + x16 * (x16 * x723 + x672) + x637
    x725 = x17 * x723 + x716
    x726 = x16 * x725 + x17 * x672 + x665
    x727 = x519 * x688 - x519 * x689
    x728 = x18 * x723 + x727
    x729 = x16 * x728 + x678
    x730 = x17 * x716 + x17 * x725 + x709
    x731 = x17 * x728 + x721
    x732 = x18 * x727 + x18 * x728 + x560 * x702 - x560 * x703
    x733 = x16 * x390 + x16 * (x16 * x406 + x390) + x414
    x734 = x17 * x406 + x429
    x735 = x16 * x734 + x17 * x390 + x441
    x736 = x392 * x82
    x737 = x18 * x406 + x736
    x738 = x391 * x82
    x739 = x16 * x737 + x18 * x390 + x738
    x740 = x17 * x429 + x458
    x741 = x17 * x734 + x740
    x742 = x430 * x82
    x743 = x18 * x429 + x742
    x744 = x17 * x737 + x743
    x745 = x394 * x475
    x746 = x18 * x736 + x745
    x747 = x18 * x737 + x746
    x748 = x16 * x429 + x16 * (x16 * x479 + x429) + x441
    x749 = x17 * x479 + x485
    x750 = x16 * x749 + x740
    x751 = x431 * x82
    x752 = x18 * x479 + x751
    x753 = x16 * x752 + x743
    x754 = x17 * x485 + x499
    x755 = x17 * x749 + x754
    x756 = x459 * x82
    x757 = x18 * x485 + x756
    x758 = x17 * x752 + x757
    x759 = x437 * x475
    x760 = x18 * x751 + x759
    x761 = x18 * x752 + x760
    x762 = x410 * x82
    x763 = x16 * x736 + x16 * (x16 * x762 + x736) + x738
    x764 = x17 * x762 + x751
    x765 = x16 * x764 + x17 * x736 + x742
    x766 = x401 * x475
    x767 = x18 * x762 + x766
    x768 = x16 * x767 + x746
    x769 = x17 * x751 + x756
    x770 = x17 * x764 + x769
    x771 = x17 * x767 + x760
    x772 = x18 * x766 + x403 * x519
    x773 = x18 * x767 + x772
    x774 = x16 * x485 + x16 * (x16 * x522 + x485) + x458
    x775 = x17 * x522 + x525
    x776 = x16 * x775 + x754
    x777 = x486 * x82
    x778 = x18 * x522 + x777
    x779 = x16 * x778 + x757
    x780 = x17 * x525 + x17 * x775 + x532
    x781 = x495 * x82
    x782 = x17 * x778 + x18 * x525 + x781
    x783 = x461 * x475
    x784 = x18 * x777 + x783
    x785 = x18 * x778 + x784
    x786 = x480 * x82
    x787 = x16 * x751 + x16 * (x16 * x786 + x751) + x742
    x788 = x17 * x786 + x777
    x789 = x16 * x788 + x769
    x790 = x433 * x475
    x791 = x18 * x786 + x790
    x792 = x16 * x791 + x760
    x793 = x17 * x777 + x17 * x788 + x781
    x794 = x17 * x791 + x784
    x795 = x18 * x790 + x435 * x519
    x796 = x18 * x791 + x795
    x797 = x407 * x475
    x798 = x16 * x766 + x16 * (x16 * x797 + x766) + x745
    x799 = x17 * x797 + x790
    x800 = x16 * x799 + x17 * x766 + x759
    x801 = x397 * x519
    x802 = x18 * x797 + x801
    x803 = x16 * x802 + x772
    x804 = x17 * x790 + x17 * x799 + x783
    x805 = x17 * x802 + x795
    x806 = x18 * x801 + x18 * x802 + x399 * x560
    x807 = x105 + x389 * x390 - x391 * x396
    x808 = x127 + x389 * x406 - x392 * x396
    x809 = x176 + x389 * x429 - x396 * x430
    x810 = x17 * x808 + x809
    x811 = x181 + x389 * x441 - x396 * x451
    x812 = x394 * x396
    x813 = x389 * x736 - x812 * x82 + x82 * (x112 + x389 * x392 - x812)
    x814 = x18 * x808 + x813
    x815 = x396 * x416
    x816 = x389 * x738 - x815 * x82 + x82 * (x116 + x389 * x391 - x815)
    x817 = x217 + x389 * x458 - x396 * x467
    x818 = x17 * x809 + x817
    x819 = x396 * x443
    x820 = x389 * x742 - x819 * x82 + x82 * (x182 + x389 * x430 - x819)
    x821 = x18 * x809 + x820
    x822 = x389 * x394
    x823 = x396 * x419
    x824 = (
        x475 * x822
        - x475 * x823
        + x87 * (x82 * x822 - x82 * x823 + x82 * (x117 + x822 - x823))
    )
    x825 = x18 * x813 + x824
    x826 = x238 + x389 * x479 - x396 * x431
    x827 = x250 + x389 * x485 - x396 * x459
    x828 = x17 * x826 + x827
    x829 = x396 * x437
    x830 = x389 * x751 - x82 * x829 + x82 * (x177 + x389 * x431 - x829)
    x831 = x18 * x826 + x830
    x832 = x17 * x827 + x266 + x389 * x499 - x396 * x500
    x833 = x396 * x465
    x834 = x389 * x756 - x82 * x833 + x82 * (x218 + x389 * x459 - x833)
    x835 = x18 * x827 + x834
    x836 = x389 * x437
    x837 = x396 * x449
    x838 = (
        x475 * x836
        - x475 * x837
        + x87 * (x82 * x836 - x82 * x837 + x82 * (x190 + x836 - x837))
    )
    x839 = x18 * x830 + x838
    x840 = x389 * x410
    x841 = x396 * x401
    x842 = x82 * x840 - x82 * x841 + x82 * (x128 + x840 - x841)
    x843 = x17 * x842 + x830
    x844 = x389 * x401
    x845 = x396 * x403
    x846 = (
        x475 * x844
        - x475 * x845
        + x87 * (x82 * x844 - x82 * x845 + x82 * (x113 + x844 - x845))
    )
    x847 = x18 * x842 + x846
    x848 = x17 * x830 + x834
    x849 = x389 * x403
    x850 = x396 * x425
    x851 = (
        x18 * x846
        + x519 * x849
        - x519 * x850
        + x89
        * (
            x475 * x849
            - x475 * x850
            + x87 * (x82 * x849 - x82 * x850 + x82 * (x118 + x849 - x850))
        )
    )
    x852 = x279 + x389 * x522 - x396 * x486
    x853 = x288 + x389 * x525 - x396 * x495
    x854 = x17 * x852 + x853
    x855 = x396 * x461
    x856 = x389 * x777 - x82 * x855 + x82 * (x251 + x389 * x486 - x855)
    x857 = x18 * x852 + x856
    x858 = x396 * x497
    x859 = x389 * x781 - x82 * x858 + x82 * (x267 + x389 * x495 - x858)
    x860 = x389 * x461
    x861 = x396 * x463
    x862 = (
        x475 * x860
        - x475 * x861
        + x87 * (x82 * x860 - x82 * x861 + x82 * (x219 + x860 - x861))
    )
    x863 = x18 * x856 + x862
    x864 = x389 * x480
    x865 = x396 * x433
    x866 = x82 * x864 - x82 * x865 + x82 * (x239 + x864 - x865)
    x867 = x17 * x866 + x856
    x868 = x389 * x433
    x869 = x396 * x435
    x870 = (
        x475 * x868
        - x475 * x869
        + x87 * (x82 * x868 - x82 * x869 + x82 * (x178 + x868 - x869))
    )
    x871 = x18 * x866 + x870
    x872 = x389 * x435
    x873 = x396 * x447
    x874 = (
        x18 * x870
        + x519 * x872
        - x519 * x873
        + x89
        * (
            x475 * x872
            - x475 * x873
            + x87 * (x82 * x872 - x82 * x873 + x82 * (x191 + x872 - x873))
        )
    )
    x875 = x389 * x407
    x876 = x396 * x397
    x877 = (
        x475 * x875
        - x475 * x876
        + x87 * (x82 * x875 - x82 * x876 + x82 * (x129 + x875 - x876))
    )
    x878 = x17 * x877 + x870
    x879 = x389 * x397
    x880 = x396 * x399
    x881 = (
        x519 * x879
        - x519 * x880
        + x89
        * (
            x475 * x879
            - x475 * x880
            + x87 * (x82 * x879 - x82 * x880 + x82 * (x114 + x879 - x880))
        )
    )
    x882 = x18 * x877 + x881
    x883 = x389 * x399
    x884 = x396 * x422

    # 324 item(s)
    S = numpy.array(
        [
            x11 * x126
            + x115 * x16
            + x16 * (x115 + x131)
            + x77
            + x78 * x92
            - x83 * (x103 * x91 + x65 * x78 - x83 * x99)
            + x91
            * (
                -x103 * x83
                + x116
                + x78 * x90
                + x89
                * (
                    -x102 * x83
                    + x117
                    + x78 * x88
                    + x87
                    * (
                        -x101 * x83
                        + x118
                        + x78 * x86
                        + x82 * (-x100 * x83 + x119 + x78 * x84)
                    )
                )
            ),
            x11 * x174 + x115 * x17 + x16 * x180 + x193,
            x11 * x194 + x115 * x18 + x131 * x18,
            x11 * x216 + x17 * x180 + x227,
            x11 * x229 + x175 * x18 + x230,
            x124 * x231 + x130 * x19,
            x11 * x237 + x16 * x179 + x16 * (x179 + x241) + x193,
            x11 * x248 + x16 * x253 + x227,
            x11 * x254 + x18 * x241 + x230,
            x11 * x265 + x17 * x253 + x271,
            x11 * x273 + x18 * x249 + x274,
            x19 * x240 + x231 * x235,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x278 + x16 * x252 + x16 * (x252 + x281) + x226,
            x11 * x286 + x16 * x290 + x271,
            x11 * x291 + x18 * x281 + x274,
            x11 * x298
            + x17 * x289
            + x17 * x290
            + x295
            + x296 * x78
            - x83 * (x292 * x78 - x297 * x83),
            x11 * x299 + x18 * x287 + x18 * x289,
            x19 * x280 + x231 * x276,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x126 + x322,
            x12 * x174 + x338,
            x12 * x194 + x339,
            x12 * x216 + x348,
            x12 * x229 + x350,
            x124 * x351 + x352,
            x12 * x237 + x357,
            x12 * x248 + x363,
            x12 * x254 + x364,
            x12 * x265 + x370,
            x12 * x273 + x372,
            x235 * x351 + x373,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x278 + x377,
            x12 * x286 + x382,
            x12 * x291 + x383,
            x12 * x298 + x386,
            x12 * x299 + x387,
            x276 * x351 + x388,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x126 * x13 + x428,
            x13 * x174 + x453,
            x13 * x194 + x457,
            x13 * x216 + x470,
            x13 * x229 + x473,
            x124 * x474 + x478,
            x13 * x237 + x484,
            x13 * x248 + x491,
            x13 * x254 + x494,
            x13 * x265 + x502,
            x13 * x273 + x505,
            x235 * x474 + x508,
            x510,
            x512,
            x515,
            x517,
            x518,
            x521,
            x13 * x278 + x524,
            x13 * x286 + x528,
            x13 * x291 + x531,
            x13 * x298 + x534,
            x13 * x299 + x536,
            x276 * x474 + x539,
            x541,
            x543,
            x546,
            x547,
            x548,
            x550,
            x552,
            x554,
            x557,
            x558,
            x559,
            x561,
            x11 * x563 + x322,
            x11 * x566 + x338,
            x11 * x567 + x339,
            x11 * x569 + x348,
            x11 * x571 + x350,
            x231 * x311 + x352,
            x11 * x573 + x357,
            x11 * x576 + x363,
            x11 * x577 + x364,
            x11 * x579 + x370,
            x11 * x581 + x372,
            x231 * x354 + x373,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x583 + x377,
            x11 * x586 + x382,
            x11 * x587 + x383,
            x11 * x588 + x386,
            x11 * x589 + x387,
            x231 * x374 + x388,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x563
            + x16 * x590
            + x16 * (x590 + x592)
            + x300 * x316
            - x305 * x321
            + x77,
            x12 * x566 + x16 * x595 + x17 * x590 + x596,
            x12 * x567 + x18 * x590 + x18 * x592,
            x12 * x569 + x17 * x595 + x598,
            x12 * x571 + x18 * x593 + x599,
            x19 * x591 + x311 * x351,
            x12 * x573 + x16 * x594 + x16 * (x594 + x601) + x596,
            x12 * x576 + x16 * x604 + x598,
            x12 * x577 + x18 * x601 + x599,
            x12 * x579 + x17 * x604 + x605,
            x12 * x581 + x18 * x602 + x606,
            x19 * x600 + x351 * x354,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x583 + x16 * x603 + x16 * (x603 + x608) + x597,
            x12 * x586 + x16 * x611 + x605,
            x12 * x587 + x18 * x608 + x606,
            x12 * x588
            + x17 * x610
            + x17 * x611
            + x295
            + x300 * x384
            - x305 * x385
            + x91
            * (
                x267
                + x300 * x365
                - x305 * x366
                + x89
                * (
                    x219
                    + x300 * x341
                    - x305 * x342
                    + x87
                    * (
                        x191
                        + x300 * x327
                        - x305 * x334
                        + x82 * (x119 + x300 * x307 - x305 * x319)
                    )
                )
            ),
            x12 * x589 + x18 * x609 + x18 * x610,
            x19 * x607 + x351 * x374,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x563 + x614,
            x13 * x566 + x622,
            x13 * x567 + x626,
            x13 * x569 + x633,
            x13 * x571 + x636,
            x311 * x474 + x639,
            x13 * x573 + x643,
            x13 * x576 + x650,
            x13 * x577 + x653,
            x13 * x579 + x661,
            x13 * x581 + x664,
            x354 * x474 + x667,
            x669,
            x671,
            x674,
            x676,
            x677,
            x679,
            x13 * x583 + x685,
            x13 * x586 + x694,
            x13 * x587 + x697,
            x13 * x588 + x706,
            x13 * x589 + x708,
            x374 * x474 + x711,
            x713,
            x715,
            x718,
            x719,
            x720,
            x722,
            x724,
            x726,
            x729,
            x730,
            x731,
            x732,
            x11 * x733 + x428,
            x11 * x735 + x453,
            x11 * x739 + x457,
            x11 * x741 + x470,
            x11 * x744 + x473,
            x11 * x747 + x478,
            x11 * x748 + x484,
            x11 * x750 + x491,
            x11 * x753 + x494,
            x11 * x755 + x502,
            x11 * x758 + x505,
            x11 * x761 + x508,
            x11 * x763 + x510,
            x11 * x765 + x512,
            x11 * x768 + x515,
            x11 * x770 + x517,
            x11 * x771 + x518,
            x11 * x773 + x521,
            x11 * x774 + x524,
            x11 * x776 + x528,
            x11 * x779 + x531,
            x11 * x780 + x534,
            x11 * x782 + x536,
            x11 * x785 + x539,
            x11 * x787 + x541,
            x11 * x789 + x543,
            x11 * x792 + x546,
            x11 * x793 + x547,
            x11 * x794 + x548,
            x11 * x796 + x550,
            x11 * x798 + x552,
            x11 * x800 + x554,
            x11 * x803 + x557,
            x11 * x804 + x558,
            x11 * x805 + x559,
            x11 * x806 + x561,
            x12 * x733 + x614,
            x12 * x735 + x622,
            x12 * x739 + x626,
            x12 * x741 + x633,
            x12 * x744 + x636,
            x12 * x747 + x639,
            x12 * x748 + x643,
            x12 * x750 + x650,
            x12 * x753 + x653,
            x12 * x755 + x661,
            x12 * x758 + x664,
            x12 * x761 + x667,
            x12 * x763 + x669,
            x12 * x765 + x671,
            x12 * x768 + x674,
            x12 * x770 + x676,
            x12 * x771 + x677,
            x12 * x773 + x679,
            x12 * x774 + x685,
            x12 * x776 + x694,
            x12 * x779 + x697,
            x12 * x780 + x706,
            x12 * x782 + x708,
            x12 * x785 + x711,
            x12 * x787 + x713,
            x12 * x789 + x715,
            x12 * x792 + x718,
            x12 * x793 + x719,
            x12 * x794 + x720,
            x12 * x796 + x722,
            x12 * x798 + x724,
            x12 * x800 + x726,
            x12 * x803 + x729,
            x12 * x804 + x730,
            x12 * x805 + x731,
            x12 * x806 + x732,
            x13 * x733
            + x16 * x807
            + x16 * (x16 * x808 + x807)
            + x389 * x414
            - x396 * x427
            + x77,
            x13 * x735 + x16 * x810 + x17 * x807 + x811,
            x13 * x739 + x16 * x814 + x18 * x807 + x816,
            x13 * x741 + x17 * x810 + x818,
            x13 * x744 + x17 * x814 + x821,
            x13 * x747 + x18 * x814 + x825,
            x13 * x748 + x16 * x809 + x16 * (x16 * x826 + x809) + x811,
            x13 * x750 + x16 * x828 + x818,
            x13 * x753 + x16 * x831 + x821,
            x13 * x755 + x17 * x828 + x832,
            x13 * x758 + x17 * x831 + x835,
            x13 * x761 + x18 * x831 + x839,
            x13 * x763 + x16 * x813 + x16 * (x16 * x842 + x813) + x816,
            x13 * x765 + x16 * x843 + x17 * x813 + x820,
            x13 * x768 + x16 * x847 + x825,
            x13 * x770 + x17 * x843 + x848,
            x13 * x771 + x17 * x847 + x839,
            x13 * x773 + x18 * x847 + x851,
            x13 * x774 + x16 * x827 + x16 * (x16 * x852 + x827) + x817,
            x13 * x776 + x16 * x854 + x832,
            x13 * x779 + x16 * x857 + x835,
            x13 * x780 + x17 * x853 + x17 * x854 + x295 + x389 * x532 - x396 * x533,
            x13 * x782 + x17 * x857 + x18 * x853 + x859,
            x13 * x785 + x18 * x857 + x863,
            x13 * x787 + x16 * x830 + x16 * (x16 * x866 + x830) + x820,
            x13 * x789 + x16 * x867 + x848,
            x13 * x792 + x16 * x871 + x839,
            x13 * x793 + x17 * x856 + x17 * x867 + x859,
            x13 * x794 + x17 * x871 + x863,
            x13 * x796 + x18 * x871 + x874,
            x13 * x798 + x16 * x846 + x16 * (x16 * x877 + x846) + x824,
            x13 * x800 + x16 * x878 + x17 * x846 + x838,
            x13 * x803 + x16 * x882 + x851,
            x13 * x804 + x17 * x870 + x17 * x878 + x862,
            x13 * x805 + x17 * x882 + x874,
            x13 * x806
            + x18 * x881
            + x18 * x882
            + x560 * x883
            - x560 * x884
            + x91
            * (
                x519 * x883
                - x519 * x884
                + x89
                * (
                    x475 * x883
                    - x475 * x884
                    + x87 * (x82 * x883 - x82 * x884 + x82 * (x119 + x883 - x884))
                )
            ),
        ]
    )
    return S


def eri_1200(a, A, b, B, c, C, d, D):
    """Cartesian [pd|ss] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2 * a + 2 * b) ** (-1.0)
    x1 = numpy.pi**2.5
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = c + d
    x7 = x2 * x6
    x8 = x2 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = A[0] - B[0]
    x11 = A[1] - B[1]
    x12 = A[2] - B[2]
    x13 = numpy.exp(-a * b * x3 * (x10**2 + x11**2 + x12**2))
    x14 = x6 ** (-1.0)
    x15 = numpy.exp(
        -c * d * x14 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x16 = x8 ** (-1.0)
    x17 = -x14 * (c * C[0] + d * D[0]) - x4
    x18 = -x3 * (a * A[1] + b * B[1])
    x19 = -x14 * (c * C[1] + d * D[1]) - x18
    x20 = -x3 * (a * A[2] + b * B[2])
    x21 = -x14 * (c * C[2] + d * D[2]) - x20
    x22 = x16 * x7 * (x17**2 + x19**2 + x21**2)
    x23 = boys(0, x22)
    x24 = x16 * x6
    x25 = x17 * x24
    x26 = boys(1, x22)
    x27 = 2 * x1 * x13 * x15 * x9
    x28 = x26 * x27
    x29 = x25 * x28
    x30 = x27 * boys(2, x22)
    x31 = -x25 * x30 + x28 * x5
    x32 = x24 * x31
    x33 = x0 * (2 * x1 * x13 * x15 * x23 * x9 - x24 * x28)
    x34 = x23 * x27
    x35 = -x29 + x34 * x5
    x36 = -x17 * x32 + x33 + x35 * x5
    x37 = x0 * (2 * x1 * x13 * x15 * x26 * x9 - x24 * x30)
    x38 = x27 * boys(3, x22)
    x39 = -x18 - A[1]
    x40 = x19 * x24
    x41 = x28 * x40
    x42 = x34 * x39 - x41
    x43 = x28 * x39 - x30 * x40
    x44 = x24 * x43
    x45 = -x17 * x44 + x42 * x5
    x46 = x11 * x35 + x45
    x47 = x0 * (2 * x1 * x13 * x15 * x23 * x39 * x9 - x41 - x44)
    x48 = x30 * x39 - x38 * x40
    x49 = -x25 * (-x25 * x48 + x43 * x5) + x45 * x5 + x47
    x50 = -x20 - A[2]
    x51 = x21 * x24
    x52 = x28 * x51
    x53 = x34 * x50 - x52
    x54 = x28 * x50 - x30 * x51
    x55 = x24 * x54
    x56 = -x17 * x55 + x5 * x53
    x57 = x12 * x35 + x56
    x58 = x0 * (2 * x1 * x13 * x15 * x23 * x50 * x9 - x52 - x55)
    x59 = x30 * x50 - x38 * x51
    x60 = -x25 * (-x25 * x59 + x5 * x54) + x5 * x56 + x58
    x61 = -x19 * x44 + x33 + x39 * x42
    x62 = x37 + x39 * x43 - x40 * x48
    x63 = x11 * x45 - x25 * x62 + x5 * x61
    x64 = -x19 * x55 + x39 * x53
    x65 = x39 * x54 - x40 * x59
    x66 = -x25 * x65 + x5 * x64
    x67 = x12 * x45 + x66
    x68 = -x21 * x55 + x33 + x50 * x53
    x69 = x37 + x50 * x54 - x51 * x59
    x70 = x12 * x56 - x25 * x69 + x5 * x68
    x71 = x11 * x42 + x61
    x72 = x12 * x42 + x64
    x73 = x39 * x64 - x40 * x65 + x58
    x74 = x12 * x64 + x39 * x68 - x40 * x69
    x75 = x11 * x53 + x64
    x76 = x12 * x53 + x68

    # 18 item(s)
    S = numpy.array(
        [
            2 * x0 * (2 * x1 * x13 * x15 * x23 * x5 * x9 - x29 - x32)
            + x10 * x36
            + x10 * (x10 * x35 + x36)
            - x25 * (-x25 * (-x25 * x38 + x30 * x5) + x31 * x5 + x37)
            + x36 * x5,
            x10 * x46 + x11 * x36 + x49,
            x10 * x57 + x12 * x36 + x60,
            x11 * x46 + x63,
            x11 * x57 + x67,
            x12 * x57 + x70,
            x10 * x45 + x10 * (x10 * x42 + x45) + x49,
            x10 * x71 + x63,
            x10 * x72 + x67,
            x11 * x61 + x11 * x71 + x39 * x61 - x40 * x62 + 2 * x47,
            x11 * x72 + x12 * x61 + x73,
            x12 * x72 + x74,
            x10 * x56 + x10 * (x10 * x53 + x56) + x60,
            x10 * x75 + x11 * x56 + x66,
            x10 * x76 + x70,
            x11 * x64 + x11 * x75 + x73,
            x11 * x76 + x74,
            x12 * x68 + x12 * x76 + x50 * x68 - x51 * x69 + 2 * x58,
        ]
    )
    return S


def eri_1201(a, A, b, B, c, C, d, D):
    """Cartesian [pd|sp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = (2 * c + 2 * d + x0) ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = c + d
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = x9 * (c * C[0] + d * D[0])
    x11 = -x10 - x4
    x12 = x9 * (c * C[1] + d * D[1])
    x13 = -x3 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x3 * (a * A[2] + b * B[2])
    x16 = -x15 - x9 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x3 * (x22**2 + x23**2 + x24**2))
    x26 = C[0] - D[0]
    x27 = C[1] - D[1]
    x28 = C[2] - D[2]
    x29 = numpy.exp(-c * d * x9 * (x26**2 + x27**2 + x28**2))
    x30 = 2 * x20 * x21 * x25 * x29
    x31 = x19 * x30
    x32 = x6 * x8
    x33 = x11 * x32
    x34 = x30 * boys(3, x18)
    x35 = x31 * x5 - x33 * x34
    x36 = x10 - C[0]
    x37 = boys(1, x18)
    x38 = x30 * x37
    x39 = x2 * x8
    x40 = x11 * x39
    x41 = x31 * x40 + x36 * x38
    x42 = x31 * x36 + x34 * x40
    x43 = x32 * x42
    x44 = x1 * x35 - x11 * x43 + x41 * x5
    x45 = x32 * x44
    x46 = x31 * x33
    x47 = x38 * x5 - x46
    x48 = boys(0, x18)
    x49 = x30 * x48
    x50 = x36 * x49 + x38 * x40
    x51 = x32 * x41
    x52 = x1 * x47 - x11 * x51 + x5 * x50
    x53 = x0 ** (-1.0)
    x54 = 2 * x53
    x55 = x33 * x38
    x56 = x32 * x47
    x57 = x53 * (2 * x20 * x21 * x25 * x29 * x48 - x32 * x38)
    x58 = x49 * x5 - x55
    x59 = -x11 * x56 + x5 * x58 + x57
    x60 = x53 * (2 * x20 * x21 * x25 * x29 * x37 - x31 * x32)
    x61 = x32 * x35
    x62 = -x11 * x61 + x47 * x5 + x60
    x63 = -x33 * x62 + x5 * x59 + x54 * (2 * x20 * x21 * x25 * x29 * x48 * x5 - x55 - x56)
    x64 = x53 * (2 * x19 * x20 * x21 * x25 * x29 - x32 * x34)
    x65 = x30 * boys(4, x18)
    x66 = -x33 * x65 + x34 * x5
    x67 = -x33 * x66 + x35 * x5 + x64
    x68 = x53 * (x50 - x51)
    x69 = x1 * x62 - x11 * x45 + x5 * x52 + x68
    x70 = x53 * (x41 - x43)
    x71 = x34 * x36 + x40 * x65
    x72 = x26 * x59 + x69
    x73 = x26 * x58 + x52
    x74 = x12 - C[1]
    x75 = x14 * x39
    x76 = x38 * x75 + x49 * x74
    x77 = x31 * x75 + x38 * x74
    x78 = x32 * x77
    x79 = x11 * x78
    x80 = x31 * x74 + x34 * x75
    x81 = x32 * x80
    x82 = -x11 * x81 + x5 * x77
    x83 = x32 * x82
    x84 = x53 * (x76 - x78)
    x85 = x5 * x76 - x79
    x86 = -x11 * x83 + x5 * x85 + x84
    x87 = x53 * (x77 - x81)
    x88 = x34 * x74 + x65 * x75
    x89 = x27 * x59 + x86
    x90 = x27 * x58 + x85
    x91 = x28 * x59
    x92 = x28 * x58
    x93 = -x13 - A[1]
    x94 = x14 * x32
    x95 = x38 * x94
    x96 = x49 * x93 - x95
    x97 = x31 * x94
    x98 = x38 * x93 - x97
    x99 = x32 * x98
    x100 = -x11 * x99 + x5 * x96
    x101 = x31 * x93 - x34 * x94
    x102 = x101 * x32
    x103 = -x102 * x11 + x5 * x98
    x104 = x14 * x51
    x105 = -x104 + x50 * x93
    x106 = -x14 * x43 + x41 * x93
    x107 = x106 * x32
    x108 = x1 * x103 + x105 * x5 - x107 * x11
    x109 = x100 * x26 + x108
    x110 = x109 + x23 * x73
    x111 = x53 * (-x104 - x107 + x50 * x93)
    x112 = x53 * (-x102 + 2 * x20 * x21 * x25 * x29 * x37 * x93 - x97)
    x113 = x34 * x93 - x65 * x94
    x114 = x101 * x5 - x113 * x33
    x115 = x53 * (2 * x20 * x21 * x25 * x29 * x48 * x93 - x95 - x99)
    x116 = x100 * x5 - x103 * x33 + x115
    x117 = x42 * x93 - x71 * x94
    x118 = (
        x1 * (x103 * x5 + x112 - x114 * x33)
        + x108 * x5
        + x111
        + x116 * x26
        - x33 * (x1 * x114 + x106 * x5 - x117 * x33)
    )
    x119 = x1 * x98 - x14 * x78 + x76 * x93
    x120 = x1 * x101 - x14 * x81 + x77 * x93
    x121 = x120 * x32
    x122 = -x11 * x121 + x119 * x5
    x123 = x100 * x27 + x122
    x124 = x123 + x23 * x90
    x125 = x53 * (x119 - x121)
    x126 = x1 * x113 + x80 * x93 - x88 * x94
    x127 = x116 * x27 + x122 * x5 + x125 - x33 * (x120 * x5 - x126 * x33)
    x128 = x100 * x28
    x129 = x128 + x23 * x92
    x130 = x116 * x28
    x131 = -x15 - A[2]
    x132 = x16 * x32
    x133 = x132 * x38
    x134 = x131 * x49 - x133
    x135 = x132 * x31
    x136 = x131 * x38 - x135
    x137 = x136 * x32
    x138 = -x11 * x137 + x134 * x5
    x139 = x136 * x5
    x140 = x131 * x31 - x132 * x34
    x141 = x140 * x32
    x142 = x11 * x141
    x143 = x139 - x142
    x144 = x16 * x51
    x145 = x131 * x50 - x144
    x146 = x131 * x41 - x16 * x43
    x147 = x146 * x32
    x148 = x1 * x143 - x11 * x147 + x145 * x5
    x149 = x138 * x26 + x148
    x150 = x149 + x24 * x73
    x151 = x53 * (x131 * x50 - x144 - x147)
    x152 = x53 * (2 * x131 * x20 * x21 * x25 * x29 * x37 - x135 - x141)
    x153 = x140 * x5
    x154 = x131 * x34 - x132 * x65
    x155 = x154 * x33
    x156 = x153 - x155
    x157 = x53 * (2 * x131 * x20 * x21 * x25 * x29 * x48 - x133 - x137)
    x158 = x138 * x5 - x143 * x33 + x157
    x159 = x131 * x42 - x132 * x71
    x160 = (
        x1 * (x143 * x5 + x152 - x156 * x33)
        + x148 * x5
        + x151
        + x158 * x26
        - x33 * (x1 * x156 + x146 * x5 - x159 * x33)
    )
    x161 = x16 * x78
    x162 = x131 * x76 - x161
    x163 = x131 * x77 - x16 * x81
    x164 = x163 * x32
    x165 = -x11 * x164 + x162 * x5
    x166 = x138 * x27 + x165
    x167 = x166 + x24 * x90
    x168 = x53 * (x131 * x76 - x161 - x164)
    x169 = x131 * x80 - x132 * x88
    x170 = x158 * x27 + x165 * x5 + x168 - x33 * (x163 * x5 - x169 * x33)
    x171 = x1 * x139 - x1 * x142
    x172 = x138 * x28 + x171
    x173 = x172 + x24 * x92
    x174 = x1 * x141
    x175 = x53 * (x1 * x136 - x174)
    x176 = x158 * x28 + x171 * x5 + x175 - x33 * (x1 * x153 - x1 * x155)
    x177 = -x102 * x14 + x60 + x93 * x98
    x178 = x101 * x93 - x113 * x94 + x64
    x179 = -x14 * x99 + x57 + x93 * x96
    x180 = -x177 * x33 + x179 * x5
    x181 = x105 * x93 - x107 * x14 + x68
    x182 = x106 * x93 - x117 * x94 + x70
    x183 = (
        x1 * (x177 * x5 - x178 * x33) + x109 * x23 + x180 * x26 + x181 * x5 - x182 * x33
    )
    x184 = x1 * x177 + x119 * x93 - x121 * x14 + x84
    x185 = x1 * x178 + x120 * x93 - x126 * x94 + x87
    x186 = x123 * x23 + x180 * x27 + x184 * x5 - x185 * x33
    x187 = x128 * x23 + x180 * x28
    x188 = x136 * x93 - x14 * x141
    x189 = x140 * x93
    x190 = x154 * x94
    x191 = x189 - x190
    x192 = x134 * x93 - x137 * x14
    x193 = -x188 * x33 + x192 * x5
    x194 = -x14 * x147 + x145 * x93
    x195 = x146 * x93 - x159 * x94
    x196 = x1 * (x188 * x5 - x191 * x33) + x193 * x26 + x194 * x5 - x195 * x33
    x197 = x109 * x24 + x196
    x198 = x1 * x188 - x14 * x164 + x162 * x93
    x199 = x1 * x191 + x163 * x93 - x169 * x94
    x200 = x193 * x27 + x198 * x5 - x199 * x33
    x201 = x123 * x24 + x200
    x202 = x1 * x136
    x203 = -x14 * x174 + x202 * x93
    x204 = x1 * x189 - x1 * x190
    x205 = x193 * x28 + x203 * x5 - x204 * x33
    x206 = x128 * x24 + x205
    x207 = x131 * x136 - x141 * x16 + x60
    x208 = x131 * x140
    x209 = x132 * x154
    x210 = x208 - x209 + x64
    x211 = x131 * x134 - x137 * x16 + x57
    x212 = -x207 * x33 + x211 * x5
    x213 = x131 * x145 - x147 * x16 + x68
    x214 = x131 * x146 - x132 * x159 + x70
    x215 = (
        x1 * (x207 * x5 - x210 * x33) + x149 * x24 + x212 * x26 + x213 * x5 - x214 * x33
    )
    x216 = x131 * x162 - x16 * x164 + x84
    x217 = x131 * x163 - x132 * x169 + x87
    x218 = x166 * x24 + x212 * x27 + x216 * x5 - x217 * x33
    x219 = x1 * x207 + x131 * x202 - x16 * x174
    x220 = x1 * x208 - x1 * x209 + x1 * x210
    x221 = x172 * x24 + x212 * x28 + x219 * x5 - x220 * x33
    x222 = x105 + x26 * x96
    x223 = x119 + x27 * x96
    x224 = x28 * x96
    x225 = x179 * x26 + x181
    x226 = x222 * x23 + x225
    x227 = x179 * x27 + x184
    x228 = x223 * x23 + x227
    x229 = x179 * x28
    x230 = x224 * x23 + x229
    x231 = x192 * x26 + x194
    x232 = x222 * x24 + x231
    x233 = x192 * x27 + x198
    x234 = x223 * x24 + x233
    x235 = x192 * x28 + x203
    x236 = x224 * x24 + x235
    x237 = 2 * x115 - x177 * x94 + x179 * x93
    x238 = x157 - x188 * x94 + x192 * x93
    x239 = x151 + x194 * x93 - x195 * x94 + x238 * x26
    x240 = (
        x1 * (x152 + x188 * x93 - x191 * x94)
        + x168
        + x198 * x93
        - x199 * x94
        + x238 * x27
    )
    x241 = x175 + x203 * x93 - x204 * x94 + x238 * x28
    x242 = -x207 * x94 + x211 * x93
    x243 = x213 * x93 - x214 * x94 + x231 * x24 + x242 * x26
    x244 = (
        x1 * (x207 * x93 - x210 * x94) + x216 * x93 - x217 * x94 + x233 * x24 + x242 * x27
    )
    x245 = x219 * x93 - x220 * x94 + x235 * x24 + x242 * x28
    x246 = x134 * x26 + x145
    x247 = x134 * x27 + x162
    x248 = x134 * x28 + x202
    x249 = x23 * x246 + x231
    x250 = x23 * x247 + x233
    x251 = x23 * x248 + x235
    x252 = x211 * x26 + x213
    x253 = x24 * x246 + x252
    x254 = x211 * x27 + x216
    x255 = x24 * x247 + x254
    x256 = x211 * x28 + x219
    x257 = x24 * x248 + x256
    x258 = x131 * x211 - x132 * x207 + 2 * x157

    # 54 item(s)
    S = numpy.array(
        [
            x1
            * (
                -x33 * x67
                + x5 * x62
                + x54 * (2 * x20 * x21 * x25 * x29 * x37 * x5 - x46 - x61)
            )
            + x22 * x72
            + x22 * (x22 * x73 + x72)
            + x26 * x63
            - x33 * (x1 * x67 - x33 * (x1 * x66 - x33 * x71 + x42 * x5) + x44 * x5 + x70)
            + x5 * x69
            + x54 * (-x45 + x52),
            x22 * x89
            + x22 * (x22 * x90 + x89)
            + x27 * x63
            - x33 * (-x33 * (-x33 * x88 + x5 * x80) + x5 * x82 + x87)
            + x5 * x86
            + x54 * (x5 * x76 - x79 - x83),
            x22 * x91 + x22 * (x22 * x92 + x91) + x28 * x63,
            x110 * x22 + x118 + x23 * x72,
            x124 * x22 + x127 + x23 * x89,
            x129 * x22 + x130 + x23 * x91,
            x150 * x22 + x160 + x24 * x72,
            x167 * x22 + x170 + x24 * x89,
            x173 * x22 + x176 + x24 * x91,
            x110 * x23 + x183,
            x124 * x23 + x186,
            x129 * x23 + x187,
            x150 * x23 + x197,
            x167 * x23 + x201,
            x173 * x23 + x206,
            x150 * x24 + x215,
            x167 * x24 + x218,
            x173 * x24 + x221,
            x109 * x22 + x118 + x22 * (x109 + x22 * x222),
            x123 * x22 + x127 + x22 * (x123 + x22 * x223),
            x128 * x22 + x130 + x22 * (x128 + x22 * x224),
            x183 + x22 * x226,
            x186 + x22 * x228,
            x187 + x22 * x230,
            x197 + x22 * x232,
            x201 + x22 * x234,
            x206 + x22 * x236,
            2 * x111 + x181 * x93 - x182 * x94 + x225 * x23 + x226 * x23 + x237 * x26,
            x1 * (2 * x112 + x177 * x93 - x178 * x94)
            + 2 * x125
            + x184 * x93
            - x185 * x94
            + x227 * x23
            + x228 * x23
            + x237 * x27,
            x229 * x23 + x23 * x230 + x237 * x28,
            x225 * x24 + x23 * x232 + x239,
            x227 * x24 + x23 * x234 + x240,
            x229 * x24 + x23 * x236 + x241,
            x232 * x24 + x243,
            x234 * x24 + x244,
            x236 * x24 + x245,
            x149 * x22 + x160 + x22 * (x149 + x22 * x246),
            x166 * x22 + x170 + x22 * (x166 + x22 * x247),
            x172 * x22 + x176 + x22 * (x172 + x22 * x248),
            x149 * x23 + x196 + x22 * x249,
            x166 * x23 + x200 + x22 * x250,
            x172 * x23 + x205 + x22 * x251,
            x215 + x22 * x253,
            x218 + x22 * x255,
            x22 * x257 + x221,
            x23 * x231 + x23 * x249 + x239,
            x23 * x233 + x23 * x250 + x240,
            x23 * x235 + x23 * x251 + x241,
            x23 * x253 + x243,
            x23 * x255 + x244,
            x23 * x257 + x245,
            x131 * x213 - x132 * x214 + 2 * x151 + x24 * x252 + x24 * x253 + x258 * x26,
            x131 * x216 - x132 * x217 + 2 * x168 + x24 * x254 + x24 * x255 + x258 * x27,
            x1 * (x131 * x207 - x132 * x210 + 2 * x152)
            + x131 * x219
            - x132 * x220
            + 2 * x175
            + x24 * x256
            + x24 * x257
            + x258 * x28,
        ]
    )
    return S


def eri_1202(a, A, b, B, c, C, d, D):
    """Cartesian [pd|sd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x9 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x2 - x22
    x24 = x15 * (c * C[1] + d * D[1])
    x25 = -x1 * (a * A[1] + b * B[1])
    x26 = -x24 - x25
    x27 = -x1 * (a * A[2] + b * B[2])
    x28 = -x15 * (c * C[2] + d * D[2]) - x27
    x29 = x21 * x8 * (x23**2 + x26**2 + x28**2)
    x30 = boys(1, x29)
    x31 = -2 * x10 * x14 * x20 * x30 * x6
    x32 = x0 * x21
    x33 = boys(2, x29)
    x34 = 2 * x10 * x14 * x20 * x6
    x35 = x33 * x34
    x36 = x5 * (-x31 - x32 * x35)
    x37 = x22 - C[0]
    x38 = x30 * x34
    x39 = x23 * x32
    x40 = x35 * x39 + x37 * x38
    x41 = boys(3, x29)
    x42 = x34 * x41
    x43 = x35 * x37 + x39 * x42
    x44 = x36 + x37 * x40 + x39 * x43
    x45 = -2 * x10 * x14 * x20 * x33 * x6
    x46 = x5 * (-x32 * x42 - x45)
    x47 = x34 * boys(4, x29)
    x48 = x37 * x42 + x39 * x47
    x49 = x37 * x43 + x39 * x48 + x46
    x50 = x21 * x7
    x51 = x49 * x50
    x52 = 2 * a + 2 * b
    x53 = x4 + x52
    x54 = x53 ** (-1.0)
    x55 = x23 * x50
    x56 = x3 * x42 - x47 * x55
    x57 = x48 * x50
    x58 = -x23 * x57 + x3 * x43 + x54 * x56
    x59 = 2 * x54
    x60 = -x23 * x51 + x3 * x44 + x58 * x59
    x61 = x50 * x60
    x62 = boys(0, x29)
    x63 = -2 * x10 * x14 * x20 * x6 * x62
    x64 = x5 * (-x32 * x38 - x63)
    x65 = x34 * x62
    x66 = x37 * x65 + x38 * x39
    x67 = x37 * x66 + x39 * x40 + x64
    x68 = x44 * x50
    x69 = x42 * x55
    x70 = x3 * x35 - x69
    x71 = x43 * x50
    x72 = -x23 * x71 + x3 * x40 + x54 * x70
    x73 = -x23 * x68 + x3 * x67 + x59 * x72
    x74 = x52 ** (-1.0)
    x75 = 2 * x74
    x76 = x74 * (x67 - x68)
    x77 = x74 * (x40 - x71)
    x78 = x74 * (-x42 * x50 - x45)
    x79 = x50 * x56
    x80 = -x23 * x79 + x3 * x70 + x78
    x81 = x50 * x58
    x82 = -x23 * x81 + x3 * x72 + x54 * x80 + x77
    x83 = -x23 * x61 + x3 * x73 + x59 * x82 + x76
    x84 = x74 * (x44 - x51)
    x85 = -2 * x10 * x14 * x20 * x41 * x6
    x86 = x5 * (-x32 * x47 - x85)
    x87 = x34 * boys(5, x29)
    x88 = x37 * x47 + x39 * x87
    x89 = x37 * x48 + x39 * x88 + x86
    x90 = x3 * x47 - x55 * x87
    x91 = x3 * x48 + x54 * x90 - x55 * x88
    x92 = x74 * (x43 - x57)
    x93 = x74 * (-x47 * x50 - x85)
    x94 = x3 * x56 - x55 * x90 + x93
    x95 = x3 * x58 + x54 * x94 - x55 * x91 + x92
    x96 = x50 * x72
    x97 = x35 * x55
    x98 = x3 * x38 - x97
    x99 = x40 * x50
    x100 = -x23 * x99 + x3 * x66 + x54 * x98
    x101 = x50 * x70
    x102 = x74 * (-x31 - x35 * x50)
    x103 = -x101 * x23 + x102 + x3 * x98
    x104 = x74 * (x66 - x99)
    x105 = x100 * x3 + x103 * x54 + x104 - x23 * x96
    x106 = (
        x105 * x3
        + x54
        * (
            x103 * x3
            - x55 * x80
            + x75 * (2 * x10 * x14 * x20 * x3 * x30 * x6 - x101 - x97)
        )
        - x55 * x82
        + x75 * (x100 - x96)
    )
    x107 = x38 * x55
    x108 = x50 * x98
    x109 = x74 * (-x38 * x50 - x63)
    x110 = -x107 + x3 * x65
    x111 = -x108 * x23 + x109 + x110 * x3
    x112 = (
        -x103 * x55
        + x111 * x3
        + x75 * (2 * x10 * x14 * x20 * x3 * x6 * x62 - x107 - x108)
    )
    x113 = x112 * x16
    x114 = x111 * x16
    x115 = x105 * x16 + x16 * (x105 + x114) + x83
    x116 = x110 * x16
    x117 = x100 * x16 + x16 * (x100 + x116) + x73
    x118 = x24 - C[1]
    x119 = x26 * x32
    x120 = x118 * x35 + x119 * x42
    x121 = x118 * x42 + x119 * x47
    x122 = x121 * x50
    x123 = x120 * x3 - x122 * x23
    x124 = x118 * x38 + x119 * x35
    x125 = x120 * x39 + x124 * x37
    x126 = x120 * x37 + x121 * x39
    x127 = x126 * x50
    x128 = x123 * x54 + x125 * x3 - x127 * x23
    x129 = x128 * x50
    x130 = x120 * x50
    x131 = x130 * x23
    x132 = x124 * x3 - x131
    x133 = x118 * x65 + x119 * x38
    x134 = x124 * x39 + x133 * x37
    x135 = x125 * x50
    x136 = x132 * x54 + x134 * x3 - x135 * x23
    x137 = x123 * x50
    x138 = x74 * (x124 - x130)
    x139 = x132 * x3 - x137 * x23 + x138
    x140 = x74 * (x120 - x122)
    x141 = x118 * x47 + x119 * x87
    x142 = x121 * x3 - x141 * x55
    x143 = x123 * x3 + x140 - x142 * x55
    x144 = x74 * (x134 - x135)
    x145 = -x129 * x23 + x136 * x3 + x139 * x54 + x144
    x146 = x74 * (x125 - x127)
    x147 = x121 * x37 + x141 * x39
    x148 = x112 * x17
    x149 = x124 * x50
    x150 = x149 * x23
    x151 = x132 * x50
    x152 = x74 * (x133 - x149)
    x153 = x133 * x3 - x150
    x154 = -x151 * x23 + x152 + x153 * x3
    x155 = -x139 * x55 + x154 * x3 + x75 * (x133 * x3 - x150 - x151)
    x156 = x148 + x155
    x157 = x111 * x17
    x158 = x154 + x157
    x159 = x105 * x17 + x145 + x158 * x16
    x160 = x110 * x17
    x161 = x153 + x160
    x162 = x100 * x17 + x136 + x16 * x161
    x163 = x105 * x18 + x114 * x18
    x164 = x100 * x18 + x116 * x18
    x165 = x118 * x133 + x119 * x124 + x64
    x166 = x118 * x124 + x119 * x120 + x36
    x167 = x166 * x50
    x168 = x167 * x23
    x169 = x118 * x120 + x119 * x121 + x46
    x170 = x169 * x50
    x171 = x166 * x3 - x170 * x23
    x172 = x171 * x50
    x173 = x74 * (x165 - x167)
    x174 = x165 * x3 - x168
    x175 = -x172 * x23 + x173 + x174 * x3
    x176 = x74 * (x166 - x170)
    x177 = x118 * x121 + x119 * x141 + x86
    x178 = x154 * x17 + x158 * x17 + x175
    x179 = x153 * x17 + x161 * x17 + x174
    x180 = x154 * x18 + x157 * x18
    x181 = x153 * x18 + x160 * x18
    x182 = x111 * x19
    x183 = x110 * x19
    x184 = -x25 - A[1]
    x185 = x26 * x50
    x186 = x185 * x35
    x187 = x184 * x38 - x186
    x188 = x185 * x42
    x189 = x184 * x35 - x188
    x190 = x189 * x50
    x191 = x187 * x3 - x190 * x23
    x192 = x26 * x99
    x193 = x184 * x66 - x192
    x194 = x26 * x71
    x195 = x184 * x40 - x194
    x196 = x195 * x50
    x197 = x191 * x54 + x193 * x3 - x196 * x23
    x198 = x185 * x38
    x199 = x184 * x65 - x198
    x200 = x187 * x50
    x201 = x199 * x3 - x200 * x23
    x202 = x16 * x201
    x203 = x26 * x68
    x204 = x184 * x67 - x203
    x205 = x184 * x44 - x26 * x51
    x206 = x205 * x50
    x207 = x184 * x42 - x185 * x47
    x208 = x207 * x50
    x209 = x189 * x3 - x208 * x23
    x210 = x184 * x43 - x26 * x57
    x211 = x210 * x50
    x212 = x195 * x3 + x209 * x54 - x211 * x23
    x213 = x204 * x3 - x206 * x23 + x212 * x59
    x214 = x16 * x197 + x16 * (x197 + x202) + x213
    x215 = x117 * x12 + x214
    x216 = x74 * (x184 * x67 - x203 - x206)
    x217 = x74 * (x184 * x66 - x192 - x196)
    x218 = x74 * (2 * x10 * x14 * x184 * x20 * x30 * x6 - x186 - x190)
    x219 = x197 * x3 - x212 * x55 + x217 + x54 * (x191 * x3 - x209 * x55 + x218)
    x220 = x74 * (2 * x10 * x14 * x184 * x20 * x6 * x62 - x198 - x200)
    x221 = -x191 * x55 + x201 * x3 + x220
    x222 = x16 * x221
    x223 = x74 * (x184 * x40 - x194 - x211)
    x224 = x74 * (2 * x10 * x14 * x184 * x20 * x33 * x6 - x188 - x208)
    x225 = x184 * x47 - x185 * x87
    x226 = x207 * x3 - x225 * x55
    x227 = x184 * x48 - x185 * x88
    x228 = x210 * x3 + x226 * x54 - x227 * x55
    x229 = x184 * x49 - x185 * x89
    x230 = (
        x16 * x219
        + x16 * (x219 + x222)
        + x213 * x3
        + x216
        - x55 * (x205 * x3 + x228 * x59 - x229 * x55)
        + x59 * (x212 * x3 + x223 - x228 * x55 + x54 * (x209 * x3 + x224 - x226 * x55))
    )
    x231 = x17 * x201
    x232 = x133 * x184 - x149 * x26 + x187 * x54
    x233 = x124 * x184 - x130 * x26 + x189 * x54
    x234 = x233 * x50
    x235 = -x23 * x234 + x232 * x3
    x236 = x231 + x235
    x237 = x120 * x184 - x122 * x26 + x207 * x54
    x238 = x237 * x50
    x239 = -x23 * x238 + x233 * x3
    x240 = x134 * x184 - x135 * x26 + x195 * x54
    x241 = x125 * x184 - x127 * x26 + x210 * x54
    x242 = x241 * x50
    x243 = -x23 * x242 + x239 * x54 + x240 * x3
    x244 = x16 * x236 + x17 * x197 + x243
    x245 = x12 * x162 + x244
    x246 = x74 * (x240 - x242)
    x247 = x74 * (x233 - x238)
    x248 = x121 * x184 - x141 * x185 + x225 * x54
    x249 = x237 * x3 - x248 * x55
    x250 = x17 * x221
    x251 = x74 * (x232 - x234)
    x252 = x235 * x3 - x239 * x55 + x251
    x253 = x250 + x252
    x254 = x126 * x184 - x147 * x185 + x227 * x54
    x255 = (
        x16 * x253
        + x17 * x219
        + x243 * x3
        + x246
        + x54 * (x239 * x3 + x247 - x249 * x55)
        - x55 * (x241 * x3 + x249 * x54 - x254 * x55)
    )
    x256 = x18 * x197 + x18 * x202
    x257 = x12 * x164 + x256
    x258 = x18 * x219 + x18 * x222
    x259 = x165 * x184 - x167 * x26 + x233 * x59
    x260 = x166 * x184 - x170 * x26 + x237 * x59
    x261 = x260 * x50
    x262 = -x23 * x261 + x259 * x3
    x263 = x17 * x235 + x17 * x236 + x262
    x264 = x12 * x179 + x263
    x265 = x74 * (x259 - x261)
    x266 = x169 * x184 - x177 * x185 + x248 * x59
    x267 = x17 * x252 + x17 * x253 + x262 * x3 + x265 - x55 * (x260 * x3 - x266 * x55)
    x268 = x18 * x231 + x18 * x235
    x269 = x12 * x181 + x268
    x270 = x18 * x250 + x18 * x252
    x271 = x19 * x201
    x272 = x12 * x183 + x271
    x273 = x19 * x221
    x274 = -x27 - A[2]
    x275 = x28 * x50
    x276 = x275 * x35
    x277 = x274 * x38 - x276
    x278 = x277 * x3
    x279 = x275 * x42
    x280 = x274 * x35 - x279
    x281 = x280 * x50
    x282 = -x23 * x281 + x278
    x283 = x28 * x99
    x284 = x274 * x66 - x283
    x285 = x28 * x71
    x286 = x274 * x40 - x285
    x287 = x286 * x50
    x288 = -x23 * x287 + x282 * x54 + x284 * x3
    x289 = x275 * x38
    x290 = x274 * x65 - x289
    x291 = x277 * x50
    x292 = -x23 * x291 + x290 * x3
    x293 = x28 * x68
    x294 = x274 * x67 - x293
    x295 = x274 * x44 - x28 * x51
    x296 = x295 * x50
    x297 = x280 * x3
    x298 = x274 * x42 - x275 * x47
    x299 = x298 * x50
    x300 = x23 * x299
    x301 = x297 - x300
    x302 = x286 * x3
    x303 = x274 * x43 - x28 * x57
    x304 = x303 * x50
    x305 = x23 * x304
    x306 = x301 * x54 + x302 - x305
    x307 = -x23 * x296 + x294 * x3 + x306 * x59
    x308 = x16 * x288 + x16 * (x16 * x292 + x288) + x307
    x309 = x117 * x13 + x308
    x310 = x74 * (x274 * x67 - x293 - x296)
    x311 = x74 * (x274 * x66 - x283 - x287)
    x312 = x74 * (2 * x10 * x14 * x20 * x274 * x30 * x6 - x276 - x281)
    x313 = x288 * x3 - x306 * x55 + x311 + x54 * (x282 * x3 - x301 * x55 + x312)
    x314 = x74 * (2 * x10 * x14 * x20 * x274 * x6 * x62 - x289 - x291)
    x315 = -x282 * x55 + x292 * x3 + x314
    x316 = x74 * (x274 * x40 - x285 - x304)
    x317 = x74 * (2 * x10 * x14 * x20 * x274 * x33 * x6 - x279 - x299)
    x318 = x298 * x3
    x319 = x274 * x47 - x275 * x87
    x320 = x319 * x55
    x321 = x318 - x320
    x322 = x3 * x303
    x323 = x274 * x48 - x275 * x88
    x324 = x323 * x55
    x325 = x321 * x54 + x322 - x324
    x326 = x274 * x49 - x275 * x89
    x327 = (
        x16 * x313
        + x16 * (x16 * x315 + x313)
        + x3 * x307
        + x310
        - x55 * (x295 * x3 + x325 * x59 - x326 * x55)
        + x59 * (x3 * x306 + x316 - x325 * x55 + x54 * (x3 * x301 + x317 - x321 * x55))
    )
    x328 = x149 * x28
    x329 = x133 * x274 - x328
    x330 = x130 * x28
    x331 = x124 * x274 - x330
    x332 = x331 * x50
    x333 = -x23 * x332 + x3 * x329
    x334 = x17 * x292 + x333
    x335 = x135 * x28
    x336 = x134 * x274 - x335
    x337 = x3 * x331
    x338 = x120 * x274 - x122 * x28
    x339 = x338 * x50
    x340 = x23 * x339
    x341 = x337 - x340
    x342 = x125 * x274 - x127 * x28
    x343 = x342 * x50
    x344 = -x23 * x343 + x3 * x336 + x341 * x54
    x345 = x16 * x334 + x17 * x288 + x344
    x346 = x13 * x162 + x345
    x347 = x74 * (x134 * x274 - x335 - x343)
    x348 = x74 * (x124 * x274 - x330 - x339)
    x349 = x3 * x338
    x350 = x121 * x274 - x141 * x275
    x351 = x350 * x55
    x352 = x349 - x351
    x353 = x74 * (x133 * x274 - x328 - x332)
    x354 = x3 * x333 - x341 * x55 + x353
    x355 = x17 * x315 + x354
    x356 = x126 * x274 - x147 * x275
    x357 = (
        x16 * x355
        + x17 * x313
        + x3 * x344
        + x347
        + x54 * (x3 * x341 + x348 - x352 * x55)
        - x55 * (x3 * x342 + x352 * x54 - x356 * x55)
    )
    x358 = x280 * x54
    x359 = x278 * x54 - x358 * x55
    x360 = x18 * x292 + x359
    x361 = x297 * x54 - x300 * x54
    x362 = x302 * x54 - x305 * x54 + x361 * x54
    x363 = x16 * x360 + x18 * x288 + x362
    x364 = x13 * x164 + x363
    x365 = x304 * x54
    x366 = x74 * (x286 * x54 - x365)
    x367 = x299 * x54
    x368 = x74 * (x280 * x54 - x367)
    x369 = x318 * x54 - x320 * x54
    x370 = x74 * (x277 * x54 - x358 * x50)
    x371 = x3 * x359 - x361 * x55 + x370
    x372 = x18 * x315 + x371
    x373 = (
        x16 * x372
        + x18 * x313
        + x3 * x362
        + x366
        + x54 * (x3 * x361 + x368 - x369 * x55)
        - x55 * (x322 * x54 - x324 * x54 + x369 * x54)
    )
    x374 = x167 * x28
    x375 = x165 * x274 - x374
    x376 = x166 * x274 - x170 * x28
    x377 = x376 * x50
    x378 = -x23 * x377 + x3 * x375
    x379 = x17 * x333 + x17 * x334 + x378
    x380 = x13 * x179 + x379
    x381 = x74 * (x165 * x274 - x374 - x377)
    x382 = x169 * x274 - x177 * x275
    x383 = x17 * x354 + x17 * x355 + x3 * x378 + x381 - x55 * (x3 * x376 - x382 * x55)
    x384 = x337 * x54 - x340 * x54
    x385 = x17 * x360 + x18 * x333 + x384
    x386 = x13 * x181 + x385
    x387 = x339 * x54
    x388 = x74 * (x331 * x54 - x387)
    x389 = x17 * x372 + x18 * x354 + x3 * x384 + x388 - x55 * (x349 * x54 - x351 * x54)
    x390 = x53 ** (-2.0)
    x391 = 2 * x390
    x392 = x297 * x391 - x300 * x391
    x393 = x18 * x359 + x18 * x360 + x392
    x394 = x13 * x183 + x393
    x395 = x74 * (2 * x280 * x390 - x299 * x391)
    x396 = x18 * x371 + x18 * x372 + x3 * x392 + x395 - x55 * (x318 * x391 - x320 * x391)
    x397 = x102 + x184 * x187 - x190 * x26
    x398 = x184 * x189 - x208 * x26 + x78
    x399 = x104 + x184 * x193 - x196 * x26
    x400 = x184 * x195 - x211 * x26 + x77
    x401 = x3 * x399 - x400 * x55 + x54 * (x3 * x397 - x398 * x55)
    x402 = x109 + x184 * x199 - x200 * x26
    x403 = x3 * x402 - x397 * x55
    x404 = x16 * x403
    x405 = x184 * x204 - x206 * x26 + x76
    x406 = x184 * x207 - x185 * x225 + x93
    x407 = x184 * x210 - x185 * x227 + x92
    x408 = x184 * x205 - x185 * x229 + x84
    x409 = (
        x12 * x214
        + x16 * x401
        + x16 * (x401 + x404)
        + x3 * x405
        - x408 * x55
        + x59 * (x3 * x400 - x407 * x55 + x54 * (x3 * x398 - x406 * x55))
    )
    x410 = x138 + x184 * x233 - x238 * x26 + x398 * x54
    x411 = x140 + x184 * x237 - x185 * x248 + x406 * x54
    x412 = x17 * x403
    x413 = x152 + x184 * x232 - x234 * x26 + x397 * x54
    x414 = x3 * x413 - x410 * x55
    x415 = x412 + x414
    x416 = x144 + x184 * x240 - x242 * x26 + x400 * x54
    x417 = x146 + x184 * x241 - x185 * x254 + x407 * x54
    x418 = (
        x12 * x244
        + x16 * x415
        + x17 * x401
        + x3 * x416
        - x417 * x55
        + x54 * (x3 * x410 - x411 * x55)
    )
    x419 = x12 * x256 + x18 * x401 + x18 * x404
    x420 = x173 + x184 * x259 - x26 * x261 + x410 * x59
    x421 = x176 + x184 * x260 - x185 * x266 + x411 * x59
    x422 = x12 * x263 + x17 * x414 + x17 * x415 + x3 * x420 - x421 * x55
    x423 = x12 * x268 + x18 * x412 + x18 * x414
    x424 = x12 * x271 + x19 * x403
    x425 = x184 * x277 - x26 * x281
    x426 = x184 * x280
    x427 = x26 * x299
    x428 = x426 - x427
    x429 = x184 * x284 - x26 * x287
    x430 = x184 * x286 - x26 * x304
    x431 = x3 * x429 - x430 * x55 + x54 * (x3 * x425 - x428 * x55)
    x432 = x184 * x290 - x26 * x291
    x433 = x3 * x432 - x425 * x55
    x434 = x184 * x294 - x26 * x296
    x435 = x184 * x298
    x436 = x185 * x319
    x437 = x435 - x436
    x438 = x184 * x303
    x439 = x185 * x323
    x440 = x438 - x439
    x441 = x184 * x295 - x185 * x326
    x442 = (
        x16 * x431
        + x16 * (x16 * x433 + x431)
        + x3 * x434
        - x441 * x55
        + x59 * (x3 * x430 - x440 * x55 + x54 * (x3 * x428 - x437 * x55))
    )
    x443 = x13 * x214 + x442
    x444 = x184 * x331 - x26 * x339 + x428 * x54
    x445 = x184 * x338
    x446 = x185 * x350
    x447 = x437 * x54 + x445 - x446
    x448 = x184 * x329 - x26 * x332 + x425 * x54
    x449 = x3 * x448 - x444 * x55
    x450 = x17 * x433 + x449
    x451 = x184 * x336 - x26 * x343 + x430 * x54
    x452 = x184 * x342 - x185 * x356 + x440 * x54
    x453 = (
        x16 * x450 + x17 * x431 + x3 * x451 - x452 * x55 + x54 * (x3 * x444 - x447 * x55)
    )
    x454 = x13 * x244 + x453
    x455 = x184 * x358 - x26 * x367
    x456 = x435 * x54 - x436 * x54
    x457 = x277 * x54
    x458 = x184 * x457 - x185 * x358
    x459 = x3 * x458 - x455 * x55
    x460 = x18 * x433 + x459
    x461 = x286 * x54
    x462 = x184 * x461 - x26 * x365
    x463 = x438 * x54 - x439 * x54
    x464 = (
        x16 * x460 + x18 * x431 + x3 * x462 - x463 * x55 + x54 * (x3 * x455 - x456 * x55)
    )
    x465 = x13 * x256 + x464
    x466 = x184 * x375 - x26 * x377 + x444 * x59
    x467 = x184 * x376 - x185 * x382 + x447 * x59
    x468 = x17 * x449 + x17 * x450 + x3 * x466 - x467 * x55
    x469 = x13 * x263 + x468
    x470 = x331 * x54
    x471 = x184 * x470 - x26 * x387 + x455 * x54
    x472 = x445 * x54 - x446 * x54 + x456 * x54
    x473 = x17 * x460 + x18 * x449 + x3 * x471 - x472 * x55
    x474 = x13 * x268 + x473
    x475 = x391 * x426 - x391 * x427
    x476 = x391 * x435 - x391 * x436
    x477 = x18 * x459 + x18 * x460 + x3 * x475 - x476 * x55
    x478 = x13 * x271 + x477
    x479 = x102 + x274 * x277 - x28 * x281
    x480 = x274 * x280
    x481 = x28 * x299
    x482 = x480 - x481 + x78
    x483 = x104 + x274 * x284 - x28 * x287
    x484 = x274 * x286 - x28 * x304 + x77
    x485 = x3 * x483 - x484 * x55 + x54 * (x3 * x479 - x482 * x55)
    x486 = x109 + x274 * x290 - x28 * x291
    x487 = x3 * x486 - x479 * x55
    x488 = x274 * x294 - x28 * x296 + x76
    x489 = x274 * x298
    x490 = x275 * x319
    x491 = x489 - x490 + x93
    x492 = x274 * x303
    x493 = x275 * x323
    x494 = x492 - x493 + x92
    x495 = x274 * x295 - x275 * x326 + x84
    x496 = (
        x13 * x308
        + x16 * x485
        + x16 * (x16 * x487 + x485)
        + x3 * x488
        - x495 * x55
        + x59 * (x3 * x484 - x494 * x55 + x54 * (x3 * x482 - x491 * x55))
    )
    x497 = x138 + x274 * x331 - x28 * x339
    x498 = x274 * x338
    x499 = x275 * x350
    x500 = x140 + x498 - x499
    x501 = x152 + x274 * x329 - x28 * x332
    x502 = x3 * x501 - x497 * x55
    x503 = x17 * x487 + x502
    x504 = x144 + x274 * x336 - x28 * x343
    x505 = x146 + x274 * x342 - x275 * x356
    x506 = (
        x13 * x345
        + x16 * x503
        + x17 * x485
        + x3 * x504
        - x505 * x55
        + x54 * (x3 * x497 - x500 * x55)
    )
    x507 = x274 * x358 - x28 * x367 + x482 * x54
    x508 = x489 * x54 - x490 * x54 + x491 * x54
    x509 = x274 * x457 - x275 * x358 + x479 * x54
    x510 = x3 * x509 - x507 * x55
    x511 = x18 * x487 + x510
    x512 = x274 * x461 - x28 * x365 + x484 * x54
    x513 = x492 * x54 - x493 * x54 + x494 * x54
    x514 = (
        x13 * x363
        + x16 * x511
        + x18 * x485
        + x3 * x512
        - x513 * x55
        + x54 * (x3 * x507 - x508 * x55)
    )
    x515 = x173 + x274 * x375 - x28 * x377
    x516 = x176 + x274 * x376 - x275 * x382
    x517 = x13 * x379 + x17 * x502 + x17 * x503 + x3 * x515 - x516 * x55
    x518 = x274 * x470 - x28 * x387 + x497 * x54
    x519 = x498 * x54 - x499 * x54 + x500 * x54
    x520 = x13 * x385 + x17 * x511 + x18 * x502 + x3 * x518 - x519 * x55
    x521 = x391 * x480 - x391 * x481 + x507 * x59
    x522 = x391 * x489 - x391 * x490 + x508 * x59
    x523 = x13 * x393 + x18 * x510 + x18 * x511 + x3 * x521 - x522 * x55
    x524 = x16 * x199
    x525 = x16 * x193 + x16 * (x193 + x524) + x204
    x526 = x17 * x199
    x527 = x232 + x526
    x528 = x16 * x527 + x17 * x193 + x240
    x529 = x18 * x193 + x18 * x524
    x530 = x17 * x232 + x17 * x527 + x259
    x531 = x18 * x232 + x18 * x526
    x532 = x19 * x199
    x533 = x16 * x402
    x534 = x16 * x399 + x16 * (x399 + x533) + x405
    x535 = x12 * x525 + x534
    x536 = x17 * x402
    x537 = x413 + x536
    x538 = x16 * x537 + x17 * x399 + x416
    x539 = x12 * x528 + x538
    x540 = x18 * x399 + x18 * x533
    x541 = x12 * x529 + x540
    x542 = x17 * x413 + x17 * x537 + x420
    x543 = x12 * x530 + x542
    x544 = x18 * x413 + x18 * x536
    x545 = x12 * x531 + x544
    x546 = x19 * x402
    x547 = x12 * x532 + x546
    x548 = x16 * x429 + x16 * (x16 * x432 + x429) + x434
    x549 = x13 * x525 + x548
    x550 = x17 * x432 + x448
    x551 = x16 * x550 + x17 * x429 + x451
    x552 = x13 * x528 + x551
    x553 = x18 * x432 + x458
    x554 = x16 * x553 + x18 * x429 + x462
    x555 = x13 * x529 + x554
    x556 = x17 * x448 + x17 * x550 + x466
    x557 = x13 * x530 + x556
    x558 = x17 * x553 + x18 * x448 + x471
    x559 = x13 * x531 + x558
    x560 = x18 * x458 + x18 * x553 + x475
    x561 = x13 * x532 + x560
    x562 = x184 * x399 - x185 * x400 + 2 * x217
    x563 = x184 * x402 - x185 * x397 + 2 * x220
    x564 = x16 * x563
    x565 = x17 * x563
    x566 = (
        x184 * x413
        - x185 * x410
        + 2 * x251
        + x54 * (x184 * x397 - x185 * x398 + 2 * x218)
    )
    x567 = x565 + x566
    x568 = x184 * x429 - x185 * x430 + x311
    x569 = x184 * x432 - x185 * x425 + x314
    x570 = x16 * x568 + x16 * (x16 * x569 + x568) + x184 * x434 - x185 * x441 + x310
    x571 = x184 * x448 - x185 * x444 + x353 + x54 * (x184 * x425 - x185 * x428 + x312)
    x572 = x17 * x569 + x571
    x573 = (
        x16 * x572
        + x17 * x568
        + x184 * x451
        - x185 * x452
        + x347
        + x54 * (x184 * x430 - x185 * x440 + x316)
    )
    x574 = x184 * x458 - x185 * x455 + x370
    x575 = x18 * x569 + x574
    x576 = x16 * x575 + x18 * x568 + x184 * x462 - x185 * x463 + x366
    x577 = (
        x17 * x571
        + x17 * x572
        + x184 * x466
        - x185 * x467
        + x381
        + x59
        * (x184 * x444 - x185 * x447 + x348 + x54 * (x184 * x428 - x185 * x437 + x317))
    )
    x578 = (
        x17 * x575
        + x18 * x571
        + x184 * x471
        - x185 * x472
        + x388
        + x54 * (x184 * x455 - x185 * x456 + x368)
    )
    x579 = x18 * x574 + x18 * x575 + x184 * x475 - x185 * x476 + x395
    x580 = x184 * x483 - x185 * x484
    x581 = x184 * x486 - x185 * x479
    x582 = x13 * x548 + x16 * x580 + x16 * (x16 * x581 + x580) + x184 * x488 - x185 * x495
    x583 = x184 * x501 - x185 * x497 + x54 * (x184 * x479 - x185 * x482)
    x584 = x17 * x581 + x583
    x585 = (
        x13 * x551
        + x16 * x584
        + x17 * x580
        + x184 * x504
        - x185 * x505
        + x54 * (x184 * x484 - x185 * x494)
    )
    x586 = x184 * x509 - x185 * x507
    x587 = x18 * x581 + x586
    x588 = x13 * x554 + x16 * x587 + x18 * x580 + x184 * x512 - x185 * x513
    x589 = (
        x13 * x556
        + x17 * x583
        + x17 * x584
        + x184 * x515
        - x185 * x516
        + x59 * (x184 * x497 - x185 * x500 + x54 * (x184 * x482 - x185 * x491))
    )
    x590 = (
        x13 * x558
        + x17 * x587
        + x18 * x583
        + x184 * x518
        - x185 * x519
        + x54 * (x184 * x507 - x185 * x508)
    )
    x591 = x13 * x560 + x18 * x586 + x18 * x587 + x184 * x521 - x185 * x522
    x592 = x16 * x284 + x16 * (x16 * x290 + x284) + x294
    x593 = x17 * x290 + x329
    x594 = x16 * x593 + x17 * x284 + x336
    x595 = x18 * x290 + x457
    x596 = x16 * x595 + x18 * x284 + x461
    x597 = x17 * x329 + x17 * x593 + x375
    x598 = x17 * x595 + x18 * x329 + x470
    x599 = x18 * x457 + x18 * x595 + x280 * x391
    x600 = x12 * x592 + x548
    x601 = x12 * x594 + x551
    x602 = x12 * x596 + x554
    x603 = x12 * x597 + x556
    x604 = x12 * x598 + x558
    x605 = x12 * x599 + x560
    x606 = x16 * x483 + x16 * (x16 * x486 + x483) + x488
    x607 = x13 * x592 + x606
    x608 = x17 * x486 + x501
    x609 = x16 * x608 + x17 * x483 + x504
    x610 = x13 * x594 + x609
    x611 = x18 * x486 + x509
    x612 = x16 * x611 + x18 * x483 + x512
    x613 = x13 * x596 + x612
    x614 = x17 * x501 + x17 * x608 + x515
    x615 = x13 * x597 + x614
    x616 = x17 * x611 + x18 * x501 + x518
    x617 = x13 * x598 + x616
    x618 = x18 * x509 + x18 * x611 + x521
    x619 = x13 * x599 + x618
    x620 = x274 * x483 - x275 * x484 + 2 * x311
    x621 = x274 * x486 - x275 * x479 + 2 * x314
    x622 = x274 * x501 - x275 * x497 + 2 * x353
    x623 = x17 * x621 + x622
    x624 = (
        x274 * x509
        - x275 * x507
        + 2 * x370
        + x54 * (x274 * x479 - x275 * x482 + 2 * x312)
    )
    x625 = x18 * x621 + x624

    # 108 item(s)
    S = numpy.array(
        [
            x106 * x16
            + x11 * x115
            + x11 * (x11 * x117 + x115)
            + x16 * (x106 + x113)
            + x3 * x83
            - x55
            * (x3 * x60 - x55 * (x3 * x49 - x55 * x89 + x59 * x91) + x59 * x95 + x84)
            + x59
            * (
                x3 * x82
                + x54
                * (
                    x3 * x80
                    - x55 * x94
                    + x75 * (2 * x10 * x14 * x20 * x3 * x33 * x6 - x69 - x79)
                )
                - x55 * x95
                + x75 * (x72 - x81)
            )
            + x75 * (-x61 + x73),
            x106 * x17
            + x11 * x159
            + x11 * (x11 * x162 + x159)
            + x145 * x3
            + x156 * x16
            + x54 * (x139 * x3 - x143 * x55 + x75 * (x124 * x3 - x131 - x137))
            - x55
            * (
                x128 * x3
                + x143 * x54
                + x146
                - x55 * (x126 * x3 + x142 * x54 - x147 * x55)
            )
            + x75 * (-x129 + x136),
            x106 * x18 + x11 * x163 + x11 * (x11 * x164 + x163) + x113 * x18,
            x11 * x178
            + x11 * (x11 * x179 + x178)
            + x155 * x17
            + x156 * x17
            + x175 * x3
            - x55 * (x171 * x3 + x176 - x55 * (x169 * x3 - x177 * x55))
            + x75 * (x165 * x3 - x168 - x172),
            x11 * x180 + x11 * (x11 * x181 + x180) + x148 * x18 + x155 * x18,
            x11 * x182 + x11 * (x11 * x183 + x182) + x112 * x19,
            x11 * x215 + x115 * x12 + x230,
            x11 * x245 + x12 * x159 + x255,
            x11 * x257 + x12 * x163 + x258,
            x11 * x264 + x12 * x178 + x267,
            x11 * x269 + x12 * x180 + x270,
            x11 * x272 + x12 * x182 + x273,
            x11 * x309 + x115 * x13 + x327,
            x11 * x346 + x13 * x159 + x357,
            x11 * x364 + x13 * x163 + x373,
            x11 * x380 + x13 * x178 + x383,
            x11 * x386 + x13 * x180 + x389,
            x11 * x394 + x13 * x182 + x396,
            x12 * x215 + x409,
            x12 * x245 + x418,
            x12 * x257 + x419,
            x12 * x264 + x422,
            x12 * x269 + x423,
            x12 * x272 + x424,
            x12 * x309 + x443,
            x12 * x346 + x454,
            x12 * x364 + x465,
            x12 * x380 + x469,
            x12 * x386 + x474,
            x12 * x394 + x478,
            x13 * x309 + x496,
            x13 * x346 + x506,
            x13 * x364 + x514,
            x13 * x380 + x517,
            x13 * x386 + x520,
            x13 * x394 + x523,
            x11 * x214 + x11 * (x11 * x525 + x214) + x230,
            x11 * x244 + x11 * (x11 * x528 + x244) + x255,
            x11 * x256 + x11 * (x11 * x529 + x256) + x258,
            x11 * x263 + x11 * (x11 * x530 + x263) + x267,
            x11 * x268 + x11 * (x11 * x531 + x268) + x270,
            x11 * x271 + x11 * (x11 * x532 + x271) + x273,
            x11 * x535 + x409,
            x11 * x539 + x418,
            x11 * x541 + x419,
            x11 * x543 + x422,
            x11 * x545 + x423,
            x11 * x547 + x424,
            x11 * x549 + x443,
            x11 * x552 + x454,
            x11 * x555 + x465,
            x11 * x557 + x469,
            x11 * x559 + x474,
            x11 * x561 + x478,
            x12 * x534
            + x12 * x535
            + x16 * x562
            + x16 * (x562 + x564)
            + x184 * x405
            - x185 * x408
            + 2 * x216,
            x12 * x538
            + x12 * x539
            + x16 * x567
            + x17 * x562
            + x184 * x416
            - x185 * x417
            + 2 * x246
            + x54 * (x184 * x400 - x185 * x407 + 2 * x223),
            x12 * x540 + x12 * x541 + x18 * x562 + x18 * x564,
            x12 * x542
            + x12 * x543
            + x17 * x566
            + x17 * x567
            + x184 * x420
            - x185 * x421
            + 2 * x265
            + x59
            * (
                x184 * x410
                - x185 * x411
                + 2 * x247
                + x54 * (x184 * x398 - x185 * x406 + 2 * x224)
            ),
            x12 * x544 + x12 * x545 + x18 * x565 + x18 * x566,
            x12 * x546 + x12 * x547 + x19 * x563,
            x12 * x549 + x13 * x534 + x570,
            x12 * x552 + x13 * x538 + x573,
            x12 * x555 + x13 * x540 + x576,
            x12 * x557 + x13 * x542 + x577,
            x12 * x559 + x13 * x544 + x578,
            x12 * x561 + x13 * x546 + x579,
            x13 * x549 + x582,
            x13 * x552 + x585,
            x13 * x555 + x588,
            x13 * x557 + x589,
            x13 * x559 + x590,
            x13 * x561 + x591,
            x11 * x308 + x11 * (x11 * x592 + x308) + x327,
            x11 * x345 + x11 * (x11 * x594 + x345) + x357,
            x11 * x363 + x11 * (x11 * x596 + x363) + x373,
            x11 * x379 + x11 * (x11 * x597 + x379) + x383,
            x11 * x385 + x11 * (x11 * x598 + x385) + x389,
            x11 * x393 + x11 * (x11 * x599 + x393) + x396,
            x11 * x600 + x12 * x308 + x442,
            x11 * x601 + x12 * x345 + x453,
            x11 * x602 + x12 * x363 + x464,
            x11 * x603 + x12 * x379 + x468,
            x11 * x604 + x12 * x385 + x473,
            x11 * x605 + x12 * x393 + x477,
            x11 * x607 + x496,
            x11 * x610 + x506,
            x11 * x613 + x514,
            x11 * x615 + x517,
            x11 * x617 + x520,
            x11 * x619 + x523,
            x12 * x548 + x12 * x600 + x570,
            x12 * x551 + x12 * x601 + x573,
            x12 * x554 + x12 * x602 + x576,
            x12 * x556 + x12 * x603 + x577,
            x12 * x558 + x12 * x604 + x578,
            x12 * x560 + x12 * x605 + x579,
            x12 * x607 + x582,
            x12 * x610 + x585,
            x12 * x613 + x588,
            x12 * x615 + x589,
            x12 * x617 + x590,
            x12 * x619 + x591,
            x13 * x606
            + x13 * x607
            + x16 * x620
            + x16 * (x16 * x621 + x620)
            + x274 * x488
            - x275 * x495
            + 2 * x310,
            x13 * x609
            + x13 * x610
            + x16 * x623
            + x17 * x620
            + x274 * x504
            - x275 * x505
            + 2 * x347,
            x13 * x612
            + x13 * x613
            + x16 * x625
            + x18 * x620
            + x274 * x512
            - x275 * x513
            + 2 * x366
            + x54 * (x274 * x484 - x275 * x494 + 2 * x316),
            x13 * x614
            + x13 * x615
            + x17 * x622
            + x17 * x623
            + x274 * x515
            - x275 * x516
            + 2 * x381,
            x13 * x616
            + x13 * x617
            + x17 * x625
            + x18 * x622
            + x274 * x518
            - x275 * x519
            + 2 * x388
            + x54 * (x274 * x497 - x275 * x500 + 2 * x348),
            x13 * x618
            + x13 * x619
            + x18 * x624
            + x18 * x625
            + x274 * x521
            - x275 * x522
            + 2 * x395
            + x59
            * (
                x274 * x507
                - x275 * x508
                + 2 * x368
                + x54 * (x274 * x482 - x275 * x491 + 2 * x317)
            ),
        ]
    )
    return S


def eri_1210(a, A, b, B, c, C, d, D):
    """Cartesian [pd|ps] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = (2 * c + 2 * d + x0) ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = c + d
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = x9 * (c * C[0] + d * D[0])
    x11 = -x10 - x4
    x12 = x9 * (c * C[1] + d * D[1])
    x13 = -x3 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x3 * (a * A[2] + b * B[2])
    x16 = -x15 - x9 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x3 * (x22**2 + x23**2 + x24**2))
    x26 = numpy.exp(
        -c * d * x9 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x27 = 2 * x20 * x21 * x25 * x26
    x28 = x19 * x27
    x29 = x6 * x8
    x30 = x11 * x29
    x31 = x27 * boys(3, x18)
    x32 = x28 * x5 - x30 * x31
    x33 = x10 - C[0]
    x34 = boys(1, x18)
    x35 = x27 * x34
    x36 = x2 * x8
    x37 = x11 * x36
    x38 = x28 * x37 + x33 * x35
    x39 = x28 * x33 + x31 * x37
    x40 = x29 * x39
    x41 = x1 * x32 - x11 * x40 + x38 * x5
    x42 = x29 * x41
    x43 = x28 * x30
    x44 = x35 * x5 - x43
    x45 = x27 * boys(0, x18)
    x46 = x33 * x45 + x35 * x37
    x47 = x29 * x38
    x48 = x1 * x44 - x11 * x47 + x46 * x5
    x49 = x0 ** (-1.0)
    x50 = 2 * x49
    x51 = x29 * x32
    x52 = x49 * (2 * x20 * x21 * x25 * x26 * x34 - x28 * x29)
    x53 = -x11 * x51 + x44 * x5 + x52
    x54 = x49 * (2 * x19 * x20 * x21 * x25 * x26 - x29 * x31)
    x55 = x27 * boys(4, x18)
    x56 = -x30 * x55 + x31 * x5
    x57 = -x30 * x56 + x32 * x5 + x54
    x58 = x49 * (x46 - x47)
    x59 = x1 * x53 - x11 * x42 + x48 * x5 + x58
    x60 = x49 * (x38 - x40)
    x61 = x31 * x33 + x37 * x55
    x62 = x12 - C[1]
    x63 = x14 * x36
    x64 = x35 * x63 + x45 * x62
    x65 = x28 * x63 + x35 * x62
    x66 = x29 * x65
    x67 = x11 * x66
    x68 = x28 * x62 + x31 * x63
    x69 = x29 * x68
    x70 = -x11 * x69 + x5 * x65
    x71 = x29 * x70
    x72 = x49 * (x64 - x66)
    x73 = x5 * x64 - x67
    x74 = -x11 * x71 + x5 * x73 + x72
    x75 = x49 * (x65 - x69)
    x76 = x31 * x62 + x55 * x63
    x77 = -x13 - A[1]
    x78 = x14 * x29
    x79 = x28 * x78
    x80 = x35 * x77 - x79
    x81 = x28 * x77 - x31 * x78
    x82 = x29 * x81
    x83 = -x11 * x82 + x5 * x80
    x84 = x14 * x47
    x85 = x46 * x77 - x84
    x86 = -x14 * x40 + x38 * x77
    x87 = x29 * x86
    x88 = x1 * x83 - x11 * x87 + x5 * x85
    x89 = x23 * x48 + x88
    x90 = x49 * (x46 * x77 - x84 - x87)
    x91 = x49 * (2 * x20 * x21 * x25 * x26 * x34 * x77 - x79 - x82)
    x92 = x31 * x77 - x55 * x78
    x93 = -x30 * x92 + x5 * x81
    x94 = x39 * x77 - x61 * x78
    x95 = (
        x1 * (-x30 * x93 + x5 * x83 + x91)
        - x30 * (x1 * x93 - x30 * x94 + x5 * x86)
        + x5 * x88
        + x90
    )
    x96 = x1 * x80 - x14 * x66 + x64 * x77
    x97 = x1 * x81 - x14 * x69 + x65 * x77
    x98 = x29 * x97
    x99 = -x11 * x98 + x5 * x96
    x100 = x23 * x73 + x99
    x101 = x49 * (x96 - x98)
    x102 = x1 * x92 + x68 * x77 - x76 * x78
    x103 = x101 - x30 * (-x102 * x30 + x5 * x97) + x5 * x99
    x104 = -x15 - A[2]
    x105 = x16 * x29
    x106 = x105 * x28
    x107 = x104 * x35 - x106
    x108 = x107 * x5
    x109 = x104 * x28 - x105 * x31
    x110 = x109 * x29
    x111 = x11 * x110
    x112 = x108 - x111
    x113 = x16 * x47
    x114 = x104 * x46 - x113
    x115 = x104 * x38 - x16 * x40
    x116 = x115 * x29
    x117 = x1 * x112 - x11 * x116 + x114 * x5
    x118 = x117 + x24 * x48
    x119 = x49 * (x104 * x46 - x113 - x116)
    x120 = x49 * (2 * x104 * x20 * x21 * x25 * x26 * x34 - x106 - x110)
    x121 = x109 * x5
    x122 = x104 * x31 - x105 * x55
    x123 = x122 * x30
    x124 = x121 - x123
    x125 = x104 * x39 - x105 * x61
    x126 = (
        x1 * (x112 * x5 + x120 - x124 * x30)
        + x117 * x5
        + x119
        - x30 * (x1 * x124 + x115 * x5 - x125 * x30)
    )
    x127 = x16 * x66
    x128 = x104 * x64 - x127
    x129 = x104 * x65 - x16 * x69
    x130 = x129 * x29
    x131 = -x11 * x130 + x128 * x5
    x132 = x131 + x24 * x73
    x133 = x49 * (x104 * x64 - x127 - x130)
    x134 = x104 * x68 - x105 * x76
    x135 = x131 * x5 + x133 - x30 * (x129 * x5 - x134 * x30)
    x136 = x1 * x110
    x137 = x49 * (x1 * x107 - x136)
    x138 = x1 * x108 - x1 * x111
    x139 = x137 + x138 * x22 + x138 * x5 - x30 * (x1 * x121 - x1 * x123)
    x140 = -x14 * x82 + x52 + x77 * x80
    x141 = x54 + x77 * x81 - x78 * x92
    x142 = -x14 * x87 + x58 + x77 * x85
    x143 = x60 + x77 * x86 - x78 * x94
    x144 = x1 * (x140 * x5 - x141 * x30) + x142 * x5 - x143 * x30 + x23 * x88
    x145 = x1 * x140 - x14 * x98 + x72 + x77 * x96
    x146 = x1 * x141 - x102 * x78 + x75 + x77 * x97
    x147 = x145 * x5 - x146 * x30 + x23 * x99
    x148 = x107 * x77 - x110 * x14
    x149 = x109 * x77
    x150 = x122 * x78
    x151 = x149 - x150
    x152 = x114 * x77 - x116 * x14
    x153 = x115 * x77 - x125 * x78
    x154 = x1 * (x148 * x5 - x151 * x30) + x152 * x5 - x153 * x30
    x155 = x154 + x24 * x88
    x156 = x1 * x148 + x128 * x77 - x130 * x14
    x157 = x1 * x151 + x129 * x77 - x134 * x78
    x158 = x156 * x5 - x157 * x30
    x159 = x158 + x24 * x99
    x160 = x1 * x107
    x161 = -x136 * x14 + x160 * x77
    x162 = x1 * x149 - x1 * x150
    x163 = x161 * x5 - x162 * x30
    x164 = x138 * x23 + x163
    x165 = x104 * x107 - x110 * x16 + x52
    x166 = x104 * x109
    x167 = x105 * x122
    x168 = x166 - x167 + x54
    x169 = x104 * x114 - x116 * x16 + x58
    x170 = x104 * x115 - x105 * x125 + x60
    x171 = x1 * (x165 * x5 - x168 * x30) + x117 * x24 + x169 * x5 - x170 * x30
    x172 = x104 * x128 - x130 * x16 + x72
    x173 = x104 * x129 - x105 * x134 + x75
    x174 = x131 * x24 + x172 * x5 - x173 * x30
    x175 = x138 * x24
    x176 = x1 * x165 + x104 * x160 - x136 * x16
    x177 = x1 * x166 - x1 * x167 + x1 * x168
    x178 = x176 * x5 - x177 * x30
    x179 = x142 + x23 * x85
    x180 = x145 + x23 * x96
    x181 = x152 + x24 * x85
    x182 = x156 + x24 * x96
    x183 = x119 + x152 * x77 - x153 * x78
    x184 = x1 * (x120 + x148 * x77 - x151 * x78) + x133 + x156 * x77 - x157 * x78
    x185 = x137 + x161 * x23 + x161 * x77 - x162 * x78
    x186 = x152 * x24 + x169 * x77 - x170 * x78
    x187 = x1 * (x165 * x77 - x168 * x78) + x156 * x24 + x172 * x77 - x173 * x78
    x188 = x161 * x24
    x189 = x176 * x77 - x177 * x78
    x190 = x114 * x23 + x152
    x191 = x128 * x23 + x156
    x192 = x160 * x23 + x161
    x193 = x114 * x24 + x169
    x194 = x128 * x24 + x172
    x195 = x160 * x24 + x176

    # 54 item(s)
    S = numpy.array(
        [
            x1
            * (
                -x30 * x57
                + x5 * x53
                + x50 * (2 * x20 * x21 * x25 * x26 * x34 * x5 - x43 - x51)
            )
            + x22 * x59
            + x22 * (x22 * x48 + x59)
            - x30 * (x1 * x57 - x30 * (x1 * x56 - x30 * x61 + x39 * x5) + x41 * x5 + x60)
            + x5 * x59
            + x50 * (-x42 + x48),
            x22 * x74
            + x22 * (x22 * x73 + x74)
            - x30 * (-x30 * (-x30 * x76 + x5 * x68) + x5 * x70 + x75)
            + x5 * x74
            + x50 * (x5 * x64 - x67 - x71),
            0,
            x22 * x89 + x23 * x59 + x95,
            x100 * x22 + x103 + x23 * x74,
            0,
            x118 * x22 + x126 + x24 * x59,
            x132 * x22 + x135 + x24 * x74,
            x139,
            x144 + x23 * x89,
            x100 * x23 + x147,
            0,
            x118 * x23 + x155,
            x132 * x23 + x159,
            x164,
            x118 * x24 + x171,
            x132 * x24 + x174,
            2 * x175 + x178,
            x22 * x88 + x22 * (x22 * x85 + x88) + x95,
            x103 + x22 * x99 + x22 * (x22 * x96 + x99),
            0,
            x144 + x179 * x22,
            x147 + x180 * x22,
            0,
            x155 + x181 * x22,
            x159 + x182 * x22,
            x161 * x22 + x163,
            x142 * x23 + x142 * x77 - x143 * x78 + x179 * x23 + 2 * x90,
            x1 * (x140 * x77 - x141 * x78 + 2 * x91)
            + 2 * x101
            + x145 * x23
            + x145 * x77
            - x146 * x78
            + x180 * x23,
            0,
            x142 * x24 + x181 * x23 + x183,
            x145 * x24 + x182 * x23 + x184,
            x185,
            x181 * x24 + x186,
            x182 * x24 + x187,
            2 * x188 + x189,
            x117 * x22 + x126 + x22 * (x114 * x22 + x117),
            x131 * x22 + x135 + x22 * (x128 * x22 + x131),
            x139 + x22 * (x138 + x160 * x22),
            x117 * x23 + x154 + x190 * x22,
            x131 * x23 + x158 + x191 * x22,
            x164 + x192 * x22,
            x171 + x193 * x22,
            x174 + x194 * x22,
            x175 + x178 + x195 * x22,
            x152 * x23 + x183 + x190 * x23,
            x156 * x23 + x184 + x191 * x23,
            x185 + x192 * x23,
            x186 + x193 * x23,
            x187 + x194 * x23,
            x188 + x189 + x195 * x23,
            x104 * x169 - x105 * x170 + 2 * x119 + x169 * x24 + x193 * x24,
            x104 * x172 - x105 * x173 + 2 * x133 + x172 * x24 + x194 * x24,
            x1 * (x104 * x165 - x105 * x168 + 2 * x120)
            + x104 * x176
            - x105 * x177
            + 2 * x137
            + x176 * x24
            + x195 * x24,
        ]
    )
    return S


def eri_1211(a, A, b, B, c, C, d, D):
    """Cartesian [pd|pp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x18**2))
    x20 = x9 ** (-1.0)
    x21 = x15 * (c * C[0] + d * D[0])
    x22 = -x2 - x21
    x23 = x15 * (c * C[1] + d * D[1])
    x24 = -x1 * (a * A[1] + b * B[1])
    x25 = -x23 - x24
    x26 = -x1 * (a * A[2] + b * B[2])
    x27 = -x15 * (c * C[2] + d * D[2]) - x26
    x28 = x20 * x8 * (x22**2 + x25**2 + x27**2)
    x29 = boys(1, x28)
    x30 = -2 * x10 * x14 * x19 * x29 * x6
    x31 = x0 * x20
    x32 = boys(2, x28)
    x33 = 2 * x10 * x14 * x19 * x6
    x34 = x32 * x33
    x35 = x5 * (-x30 - x31 * x34)
    x36 = x21 - C[0]
    x37 = x29 * x33
    x38 = x22 * x31
    x39 = x34 * x38 + x36 * x37
    x40 = boys(3, x28)
    x41 = x33 * x40
    x42 = x34 * x36 + x38 * x41
    x43 = x35 + x36 * x39 + x38 * x42
    x44 = -2 * x10 * x14 * x19 * x32 * x6
    x45 = x5 * (-x31 * x41 - x44)
    x46 = x33 * boys(4, x28)
    x47 = x36 * x41 + x38 * x46
    x48 = x36 * x42 + x38 * x47 + x45
    x49 = x20 * x7
    x50 = x48 * x49
    x51 = 2 * a + 2 * b
    x52 = x4 + x51
    x53 = x52 ** (-1.0)
    x54 = x22 * x49
    x55 = x3 * x41 - x46 * x54
    x56 = x47 * x49
    x57 = -x22 * x56 + x3 * x42 + x53 * x55
    x58 = 2 * x53
    x59 = -x22 * x50 + x3 * x43 + x57 * x58
    x60 = x49 * x59
    x61 = boys(0, x28)
    x62 = x5 * (2 * x10 * x14 * x19 * x6 * x61 - x31 * x37)
    x63 = x33 * x61
    x64 = x36 * x63 + x37 * x38
    x65 = x36 * x64 + x38 * x39 + x62
    x66 = x43 * x49
    x67 = x41 * x54
    x68 = x3 * x34 - x67
    x69 = x42 * x49
    x70 = -x22 * x69 + x3 * x39 + x53 * x68
    x71 = -x22 * x66 + x3 * x65 + x58 * x70
    x72 = x51 ** (-1.0)
    x73 = 2 * x72
    x74 = x72 * (x65 - x66)
    x75 = x72 * (x39 - x69)
    x76 = x72 * (-x41 * x49 - x44)
    x77 = x49 * x55
    x78 = -x22 * x77 + x3 * x68 + x76
    x79 = x49 * x57
    x80 = -x22 * x79 + x3 * x70 + x53 * x78 + x75
    x81 = -x22 * x60 + x3 * x71 + x58 * x80 + x74
    x82 = x72 * (x43 - x50)
    x83 = -2 * x10 * x14 * x19 * x40 * x6
    x84 = x5 * (-x31 * x46 - x83)
    x85 = x33 * boys(5, x28)
    x86 = x36 * x46 + x38 * x85
    x87 = x36 * x47 + x38 * x86 + x84
    x88 = x3 * x46 - x54 * x85
    x89 = x3 * x47 + x53 * x88 - x54 * x86
    x90 = x72 * (x42 - x56)
    x91 = x72 * (-x46 * x49 - x83)
    x92 = x3 * x55 - x54 * x88 + x91
    x93 = x3 * x57 + x53 * x92 - x54 * x89 + x90
    x94 = x49 * x70
    x95 = x34 * x54
    x96 = x3 * x37 - x95
    x97 = x39 * x49
    x98 = -x22 * x97 + x3 * x64 + x53 * x96
    x99 = x49 * x68
    x100 = x72 * (-x30 - x34 * x49)
    x101 = x100 - x22 * x99 + x3 * x96
    x102 = x72 * (x64 - x97)
    x103 = x101 * x53 + x102 - x22 * x94 + x3 * x98
    x104 = (
        x103 * x3
        + x53
        * (
            x101 * x3
            - x54 * x78
            + x73 * (2 * x10 * x14 * x19 * x29 * x3 * x6 - x95 - x99)
        )
        - x54 * x80
        + x73 * (-x94 + x98)
    )
    x105 = x103 * x16 + x81
    x106 = x16 * x98 + x71
    x107 = x23 - C[1]
    x108 = x25 * x31
    x109 = x107 * x37 + x108 * x34
    x110 = x107 * x34 + x108 * x41
    x111 = x109 * x36 + x110 * x38
    x112 = x111 * x49
    x113 = x107 * x63 + x108 * x37
    x114 = x109 * x38 + x113 * x36
    x115 = x72 * (-x112 + x114)
    x116 = x110 * x49
    x117 = x72 * (x109 - x116)
    x118 = x116 * x22
    x119 = x109 * x3 - x118
    x120 = x107 * x41 + x108 * x46
    x121 = x120 * x49
    x122 = x110 * x3 - x121 * x22
    x123 = x122 * x49
    x124 = x117 + x119 * x3 - x123 * x22
    x125 = -x112 * x22 + x114 * x3 + x119 * x53
    x126 = x110 * x36 + x120 * x38
    x127 = x126 * x49
    x128 = x111 * x3 + x122 * x53 - x127 * x22
    x129 = x128 * x49
    x130 = x115 + x124 * x53 + x125 * x3 - x129 * x22
    x131 = x103 * x17 + x130
    x132 = x125 + x17 * x98
    x133 = x72 * (x110 - x121)
    x134 = x107 * x46 + x108 * x85
    x135 = x120 * x3 - x134 * x54
    x136 = x122 * x3 + x133 - x135 * x54
    x137 = x72 * (x111 - x127)
    x138 = x120 * x36 + x134 * x38
    x139 = (
        x130 * x3
        + x53 * (x124 * x3 - x136 * x54 + x73 * (x109 * x3 - x118 - x123))
        - x54
        * (x128 * x3 + x136 * x53 + x137 - x54 * (x126 * x3 + x135 * x53 - x138 * x54))
        + x73 * (x125 - x129)
    )
    x140 = x103 * x18
    x141 = x11 * x18
    x142 = x109 * x49
    x143 = x72 * (x113 - x142)
    x144 = x142 * x22
    x145 = x113 * x3 - x144
    x146 = x119 * x49
    x147 = x143 + x145 * x3 - x146 * x22
    x148 = x130 + x147 * x16
    x149 = x125 + x145 * x16
    x150 = -x124 * x54 + x147 * x3 + x73 * (x113 * x3 - x144 - x146)
    x151 = x107 * x113 + x108 * x109 + x62
    x152 = x107 * x109 + x108 * x110 + x35
    x153 = x152 * x49
    x154 = x153 * x22
    x155 = x107 * x110 + x108 * x120 + x45
    x156 = x155 * x49
    x157 = x152 * x3 - x156 * x22
    x158 = x157 * x49
    x159 = x72 * (x151 - x153)
    x160 = x151 * x3 - x154
    x161 = -x158 * x22 + x159 + x160 * x3
    x162 = x72 * (x152 - x156)
    x163 = x107 * x120 + x108 * x134 + x84
    x164 = x147 * x17 + x161
    x165 = x145 * x17 + x160
    x166 = x147 * x18
    x167 = -x24 - A[1]
    x168 = x25 * x49
    x169 = x168 * x34
    x170 = x167 * x37 - x169
    x171 = x168 * x41
    x172 = x167 * x34 - x171
    x173 = x172 * x49
    x174 = x170 * x3 - x173 * x22
    x175 = x25 * x97
    x176 = x167 * x64 - x175
    x177 = x25 * x69
    x178 = x167 * x39 - x177
    x179 = x178 * x49
    x180 = x174 * x53 + x176 * x3 - x179 * x22
    x181 = x25 * x66
    x182 = x167 * x65 - x181
    x183 = x167 * x43 - x25 * x50
    x184 = x183 * x49
    x185 = x167 * x41 - x168 * x46
    x186 = x185 * x49
    x187 = x172 * x3 - x186 * x22
    x188 = x167 * x42 - x25 * x56
    x189 = x188 * x49
    x190 = x178 * x3 + x187 * x53 - x189 * x22
    x191 = x182 * x3 - x184 * x22 + x190 * x58
    x192 = x16 * x180 + x191
    x193 = x106 * x12 + x192
    x194 = x72 * (x167 * x65 - x181 - x184)
    x195 = x72 * (x167 * x64 - x175 - x179)
    x196 = x72 * (2 * x10 * x14 * x167 * x19 * x29 * x6 - x169 - x173)
    x197 = x180 * x3 - x190 * x54 + x195 + x53 * (x174 * x3 - x187 * x54 + x196)
    x198 = x72 * (x167 * x39 - x177 - x189)
    x199 = x72 * (2 * x10 * x14 * x167 * x19 * x32 * x6 - x171 - x186)
    x200 = x167 * x46 - x168 * x85
    x201 = x185 * x3 - x200 * x54
    x202 = x167 * x47 - x168 * x86
    x203 = x188 * x3 + x201 * x53 - x202 * x54
    x204 = x167 * x48 - x168 * x87
    x205 = (
        x16 * x197
        + x191 * x3
        + x194
        - x54 * (x183 * x3 + x203 * x58 - x204 * x54)
        + x58 * (x190 * x3 + x198 - x203 * x54 + x53 * (x187 * x3 + x199 - x201 * x54))
    )
    x206 = x109 * x167 - x116 * x25 + x172 * x53
    x207 = x110 * x167 - x121 * x25 + x185 * x53
    x208 = x207 * x49
    x209 = x206 * x3 - x208 * x22
    x210 = -x112 * x25 + x114 * x167 + x178 * x53
    x211 = x111 * x167 - x127 * x25 + x188 * x53
    x212 = x211 * x49
    x213 = x209 * x53 + x210 * x3 - x212 * x22
    x214 = x17 * x180 + x213
    x215 = x12 * x132 + x214
    x216 = x72 * (x210 - x212)
    x217 = x72 * (x206 - x208)
    x218 = x120 * x167 - x134 * x168 + x200 * x53
    x219 = x207 * x3 - x218 * x54
    x220 = x126 * x167 - x138 * x168 + x202 * x53
    x221 = (
        x213 * x3
        + x216
        + x53 * (x209 * x3 + x217 - x219 * x54)
        - x54 * (x211 * x3 + x219 * x53 - x220 * x54)
    )
    x222 = x17 * x197 + x221
    x223 = x12 * x18
    x224 = x18 * x180
    x225 = x223 * x98 + x224
    x226 = x18 * x197
    x227 = x113 * x167 - x142 * x25 + x170 * x53
    x228 = x206 * x49
    x229 = -x22 * x228 + x227 * x3
    x230 = x16 * x229 + x213
    x231 = x12 * x149 + x230
    x232 = x72 * (x227 - x228)
    x233 = -x209 * x54 + x229 * x3 + x232
    x234 = x16 * x233 + x221
    x235 = x151 * x167 - x153 * x25 + x206 * x58
    x236 = x152 * x167 - x156 * x25 + x207 * x58
    x237 = x236 * x49
    x238 = -x22 * x237 + x235 * x3
    x239 = x17 * x229 + x238
    x240 = x12 * x165 + x239
    x241 = x72 * (x235 - x237)
    x242 = x155 * x167 - x163 * x168 + x218 * x58
    x243 = x17 * x233 + x238 * x3 + x241 - x54 * (x236 * x3 - x242 * x54)
    x244 = x18 * x229
    x245 = x145 * x223 + x244
    x246 = x18 * x233
    x247 = -x26 - A[2]
    x248 = x27 * x49
    x249 = x248 * x34
    x250 = x247 * x37 - x249
    x251 = x250 * x3
    x252 = x248 * x41
    x253 = x247 * x34 - x252
    x254 = x253 * x49
    x255 = -x22 * x254 + x251
    x256 = x27 * x97
    x257 = x247 * x64 - x256
    x258 = x27 * x69
    x259 = x247 * x39 - x258
    x260 = x259 * x49
    x261 = -x22 * x260 + x255 * x53 + x257 * x3
    x262 = x27 * x66
    x263 = x247 * x65 - x262
    x264 = x247 * x43 - x27 * x50
    x265 = x264 * x49
    x266 = x253 * x3
    x267 = x247 * x41 - x248 * x46
    x268 = x267 * x49
    x269 = x22 * x268
    x270 = x266 - x269
    x271 = x259 * x3
    x272 = x247 * x42 - x27 * x56
    x273 = x272 * x49
    x274 = x22 * x273
    x275 = x270 * x53 + x271 - x274
    x276 = -x22 * x265 + x263 * x3 + x275 * x58
    x277 = x16 * x261 + x276
    x278 = x106 * x13 + x277
    x279 = x72 * (x247 * x65 - x262 - x265)
    x280 = x72 * (x247 * x64 - x256 - x260)
    x281 = x72 * (2 * x10 * x14 * x19 * x247 * x29 * x6 - x249 - x254)
    x282 = x261 * x3 - x275 * x54 + x280 + x53 * (x255 * x3 - x270 * x54 + x281)
    x283 = x72 * (x247 * x39 - x258 - x273)
    x284 = x72 * (2 * x10 * x14 * x19 * x247 * x32 * x6 - x252 - x268)
    x285 = x267 * x3
    x286 = x247 * x46 - x248 * x85
    x287 = x286 * x54
    x288 = x285 - x287
    x289 = x272 * x3
    x290 = x247 * x47 - x248 * x86
    x291 = x290 * x54
    x292 = x288 * x53 + x289 - x291
    x293 = x247 * x48 - x248 * x87
    x294 = (
        x16 * x282
        + x276 * x3
        + x279
        - x54 * (x264 * x3 + x292 * x58 - x293 * x54)
        + x58 * (x275 * x3 + x283 - x292 * x54 + x53 * (x270 * x3 + x284 - x288 * x54))
    )
    x295 = x112 * x27
    x296 = x114 * x247 - x295
    x297 = x116 * x27
    x298 = x109 * x247 - x297
    x299 = x298 * x3
    x300 = x110 * x247 - x121 * x27
    x301 = x300 * x49
    x302 = x22 * x301
    x303 = x299 - x302
    x304 = x111 * x247 - x127 * x27
    x305 = x304 * x49
    x306 = -x22 * x305 + x296 * x3 + x303 * x53
    x307 = x17 * x261 + x306
    x308 = x13 * x132 + x307
    x309 = x72 * (x114 * x247 - x295 - x305)
    x310 = x72 * (x109 * x247 - x297 - x301)
    x311 = x3 * x300
    x312 = x120 * x247 - x134 * x248
    x313 = x312 * x54
    x314 = x311 - x313
    x315 = x126 * x247 - x138 * x248
    x316 = (
        x3 * x306
        + x309
        + x53 * (x3 * x303 + x310 - x314 * x54)
        - x54 * (x3 * x304 + x314 * x53 - x315 * x54)
    )
    x317 = x17 * x282 + x316
    x318 = x13 * x18
    x319 = x266 * x53 - x269 * x53
    x320 = x271 * x53 - x274 * x53 + x319 * x53
    x321 = x18 * x261 + x320
    x322 = x318 * x98 + x321
    x323 = x273 * x53
    x324 = x72 * (x259 * x53 - x323)
    x325 = x268 * x53
    x326 = x72 * (x253 * x53 - x325)
    x327 = x285 * x53 - x287 * x53
    x328 = (
        x3 * x320
        + x324
        + x53 * (x3 * x319 + x326 - x327 * x54)
        - x54 * (x289 * x53 - x291 * x53 + x327 * x53)
    )
    x329 = x18 * x282 + x328
    x330 = x142 * x27
    x331 = x113 * x247 - x330
    x332 = x298 * x49
    x333 = -x22 * x332 + x3 * x331
    x334 = x16 * x333 + x306
    x335 = x13 * x149 + x334
    x336 = x72 * (x113 * x247 - x330 - x332)
    x337 = x3 * x333 - x303 * x54 + x336
    x338 = x16 * x337 + x316
    x339 = x153 * x27
    x340 = x151 * x247 - x339
    x341 = x152 * x247 - x156 * x27
    x342 = x341 * x49
    x343 = -x22 * x342 + x3 * x340
    x344 = x17 * x333 + x343
    x345 = x13 * x165 + x344
    x346 = x72 * (x151 * x247 - x339 - x342)
    x347 = x155 * x247 - x163 * x248
    x348 = x17 * x337 + x3 * x343 + x346 - x54 * (x3 * x341 - x347 * x54)
    x349 = x299 * x53 - x302 * x53
    x350 = x18 * x333 + x349
    x351 = x145 * x318 + x350
    x352 = x301 * x53
    x353 = x72 * (x298 * x53 - x352)
    x354 = x3 * x349 + x353 - x54 * (x311 * x53 - x313 * x53)
    x355 = x18 * x337 + x354
    x356 = x253 * x53
    x357 = x251 * x53 - x356 * x54
    x358 = x16 * x357 + x320
    x359 = x72 * (x250 * x53 - x356 * x49)
    x360 = x3 * x357 - x319 * x54 + x359
    x361 = x11 * x358 + x16 * x360 + x328
    x362 = x17 * x357 + x349
    x363 = x11 * x362 + x17 * x360 + x354
    x364 = x52 ** (-2.0)
    x365 = 2 * x364
    x366 = x72 * (2 * x253 * x364 - x268 * x365)
    x367 = x266 * x365 - x269 * x365
    x368 = x18 * x357 + x367
    x369 = x11 * x368 + x18 * x360 + x3 * x367 + x366 - x54 * (x285 * x365 - x287 * x365)
    x370 = x100 + x167 * x170 - x173 * x25
    x371 = x167 * x172 - x186 * x25 + x76
    x372 = x102 + x167 * x176 - x179 * x25
    x373 = x167 * x178 - x189 * x25 + x75
    x374 = x3 * x372 - x373 * x54 + x53 * (x3 * x370 - x371 * x54)
    x375 = x167 * x182 - x184 * x25 + x74
    x376 = x167 * x185 - x168 * x200 + x91
    x377 = x167 * x188 - x168 * x202 + x90
    x378 = x167 * x183 - x168 * x204 + x82
    x379 = (
        x12 * x192
        + x16 * x374
        + x3 * x375
        - x378 * x54
        + x58 * (x3 * x373 - x377 * x54 + x53 * (x3 * x371 - x376 * x54))
    )
    x380 = x117 + x167 * x206 - x208 * x25 + x371 * x53
    x381 = x133 + x167 * x207 - x168 * x218 + x376 * x53
    x382 = x115 + x167 * x210 - x212 * x25 + x373 * x53
    x383 = x137 + x167 * x211 - x168 * x220 + x377 * x53
    x384 = x3 * x382 - x383 * x54 + x53 * (x3 * x380 - x381 * x54)
    x385 = x12 * x214 + x17 * x374 + x384
    x386 = x12 * x224 + x18 * x374
    x387 = x143 + x167 * x227 - x228 * x25 + x370 * x53
    x388 = x3 * x387 - x380 * x54
    x389 = x12 * x230 + x16 * x388 + x384
    x390 = x159 + x167 * x235 - x237 * x25 + x380 * x58
    x391 = x162 + x167 * x236 - x168 * x242 + x381 * x58
    x392 = x12 * x239 + x17 * x388 + x3 * x390 - x391 * x54
    x393 = x12 * x244 + x18 * x388
    x394 = x167 * x250 - x25 * x254
    x395 = x167 * x253
    x396 = x25 * x268
    x397 = x395 - x396
    x398 = x167 * x257 - x25 * x260
    x399 = x167 * x259 - x25 * x273
    x400 = x3 * x398 - x399 * x54 + x53 * (x3 * x394 - x397 * x54)
    x401 = x167 * x263 - x25 * x265
    x402 = x167 * x267
    x403 = x168 * x286
    x404 = x402 - x403
    x405 = x167 * x272
    x406 = x168 * x290
    x407 = x405 - x406
    x408 = x167 * x264 - x168 * x293
    x409 = (
        x16 * x400
        + x3 * x401
        - x408 * x54
        + x58 * (x3 * x399 - x407 * x54 + x53 * (x3 * x397 - x404 * x54))
    )
    x410 = x13 * x192 + x409
    x411 = x167 * x298 - x25 * x301 + x397 * x53
    x412 = x167 * x300
    x413 = x168 * x312
    x414 = x404 * x53 + x412 - x413
    x415 = x167 * x296 - x25 * x305 + x399 * x53
    x416 = x167 * x304 - x168 * x315 + x407 * x53
    x417 = x3 * x415 - x416 * x54 + x53 * (x3 * x411 - x414 * x54)
    x418 = x17 * x400 + x417
    x419 = x13 * x214 + x418
    x420 = x167 * x356 - x25 * x325
    x421 = x402 * x53 - x403 * x53
    x422 = x259 * x53
    x423 = x167 * x422 - x25 * x323
    x424 = x405 * x53 - x406 * x53
    x425 = x3 * x423 - x424 * x54 + x53 * (x3 * x420 - x421 * x54)
    x426 = x18 * x400 + x425
    x427 = x13 * x224 + x426
    x428 = x167 * x331 - x25 * x332 + x394 * x53
    x429 = x3 * x428 - x411 * x54
    x430 = x16 * x429 + x417
    x431 = x13 * x230 + x430
    x432 = x167 * x340 - x25 * x342 + x411 * x58
    x433 = x167 * x341 - x168 * x347 + x414 * x58
    x434 = x17 * x429 + x3 * x432 - x433 * x54
    x435 = x13 * x239 + x434
    x436 = x298 * x53
    x437 = x167 * x436 - x25 * x352 + x420 * x53
    x438 = x412 * x53 - x413 * x53 + x421 * x53
    x439 = x3 * x437 - x438 * x54
    x440 = x18 * x429 + x439
    x441 = x13 * x244 + x440
    x442 = x250 * x53
    x443 = x167 * x442 - x168 * x356
    x444 = x3 * x443 - x420 * x54
    x445 = x16 * x444 + x425
    x446 = x12 * x358 + x445
    x447 = x17 * x444 + x439
    x448 = x12 * x362 + x447
    x449 = x365 * x395 - x365 * x396
    x450 = x365 * x402 - x365 * x403
    x451 = x18 * x444 + x3 * x449 - x450 * x54
    x452 = x12 * x368 + x451
    x453 = x100 + x247 * x250 - x254 * x27
    x454 = x247 * x253
    x455 = x268 * x27
    x456 = x454 - x455 + x76
    x457 = x102 + x247 * x257 - x260 * x27
    x458 = x247 * x259 - x27 * x273 + x75
    x459 = x3 * x457 - x458 * x54 + x53 * (x3 * x453 - x456 * x54)
    x460 = x247 * x263 - x265 * x27 + x74
    x461 = x247 * x267
    x462 = x248 * x286
    x463 = x461 - x462 + x91
    x464 = x247 * x272
    x465 = x248 * x290
    x466 = x464 - x465 + x90
    x467 = x247 * x264 - x248 * x293 + x82
    x468 = (
        x13 * x277
        + x16 * x459
        + x3 * x460
        - x467 * x54
        + x58 * (x3 * x458 - x466 * x54 + x53 * (x3 * x456 - x463 * x54))
    )
    x469 = x117 + x247 * x298 - x27 * x301
    x470 = x247 * x300
    x471 = x248 * x312
    x472 = x133 + x470 - x471
    x473 = x115 + x247 * x296 - x27 * x305
    x474 = x137 + x247 * x304 - x248 * x315
    x475 = x3 * x473 - x474 * x54 + x53 * (x3 * x469 - x472 * x54)
    x476 = x13 * x307 + x17 * x459 + x475
    x477 = x247 * x356 - x27 * x325 + x456 * x53
    x478 = x461 * x53 - x462 * x53 + x463 * x53
    x479 = x247 * x422 - x27 * x323 + x458 * x53
    x480 = x464 * x53 - x465 * x53 + x466 * x53
    x481 = x3 * x479 - x480 * x54 + x53 * (x3 * x477 - x478 * x54)
    x482 = x13 * x321 + x18 * x459 + x481
    x483 = x143 + x247 * x331 - x27 * x332
    x484 = x3 * x483 - x469 * x54
    x485 = x13 * x334 + x16 * x484 + x475
    x486 = x159 + x247 * x340 - x27 * x342
    x487 = x162 + x247 * x341 - x248 * x347
    x488 = x13 * x344 + x17 * x484 + x3 * x486 - x487 * x54
    x489 = x247 * x436 - x27 * x352 + x469 * x53
    x490 = x470 * x53 - x471 * x53 + x472 * x53
    x491 = x3 * x489 - x490 * x54
    x492 = x13 * x350 + x18 * x484 + x491
    x493 = x13 * x358
    x494 = x247 * x442 - x248 * x356 + x453 * x53
    x495 = x3 * x494 - x477 * x54
    x496 = x16 * x495 + x481
    x497 = x13 * x362
    x498 = x17 * x495 + x491
    x499 = x13 * x368
    x500 = x365 * x454 - x365 * x455 + x477 * x58
    x501 = x365 * x461 - x365 * x462 + x478 * x58
    x502 = x18 * x495 + x3 * x500 - x501 * x54
    x503 = x16 * x176 + x182
    x504 = x17 * x176 + x210
    x505 = x16 * x227 + x210
    x506 = x17 * x227 + x235
    x507 = x16 * x372 + x375
    x508 = x12 * x503 + x507
    x509 = x17 * x372 + x382
    x510 = x12 * x504 + x509
    x511 = x18 * x372
    x512 = x176 * x223 + x511
    x513 = x16 * x387 + x382
    x514 = x12 * x505 + x513
    x515 = x17 * x387 + x390
    x516 = x12 * x506 + x515
    x517 = x18 * x387
    x518 = x223 * x227 + x517
    x519 = x16 * x398 + x401
    x520 = x13 * x503 + x519
    x521 = x17 * x398 + x415
    x522 = x13 * x504 + x521
    x523 = x18 * x398 + x423
    x524 = x176 * x318 + x523
    x525 = x16 * x428 + x415
    x526 = x13 * x505 + x525
    x527 = x17 * x428 + x432
    x528 = x13 * x506 + x527
    x529 = x18 * x428 + x437
    x530 = x227 * x318 + x529
    x531 = x16 * x443 + x423
    x532 = x17 * x443 + x437
    x533 = x18 * x443 + x449
    x534 = x167 * x372 - x168 * x373 + 2 * x195
    x535 = (
        x167 * x382
        - x168 * x383
        + 2 * x216
        + x53 * (x167 * x373 - x168 * x377 + 2 * x198)
    )
    x536 = (
        x167 * x387
        - x168 * x380
        + 2 * x232
        + x53 * (x167 * x370 - x168 * x371 + 2 * x196)
    )
    x537 = x167 * x398 - x168 * x399 + x280
    x538 = x16 * x537 + x167 * x401 - x168 * x408 + x279
    x539 = x167 * x415 - x168 * x416 + x309 + x53 * (x167 * x399 - x168 * x407 + x283)
    x540 = x17 * x537 + x539
    x541 = x167 * x423 - x168 * x424 + x324
    x542 = x18 * x537 + x541
    x543 = x167 * x428 - x168 * x411 + x336 + x53 * (x167 * x394 - x168 * x397 + x281)
    x544 = x16 * x543 + x539
    x545 = (
        x167 * x432
        - x168 * x433
        + x17 * x543
        + x346
        + x58
        * (x167 * x411 - x168 * x414 + x310 + x53 * (x167 * x397 - x168 * x404 + x284))
    )
    x546 = x167 * x437 - x168 * x438 + x353 + x53 * (x167 * x420 - x168 * x421 + x326)
    x547 = x18 * x543 + x546
    x548 = x167 * x443 - x168 * x420 + x359
    x549 = x12 * x531 + x16 * x548 + x541
    x550 = x12 * x532 + x17 * x548 + x546
    x551 = x12 * x533 + x167 * x449 - x168 * x450 + x18 * x548 + x366
    x552 = x167 * x457 - x168 * x458
    x553 = x13 * x519 + x16 * x552 + x167 * x460 - x168 * x467
    x554 = x167 * x473 - x168 * x474 + x53 * (x167 * x458 - x168 * x466)
    x555 = x13 * x521 + x17 * x552 + x554
    x556 = x167 * x479 - x168 * x480
    x557 = x13 * x523 + x18 * x552 + x556
    x558 = x167 * x483 - x168 * x469 + x53 * (x167 * x453 - x168 * x456)
    x559 = x13 * x525 + x16 * x558 + x554
    x560 = (
        x13 * x527
        + x167 * x486
        - x168 * x487
        + x17 * x558
        + x58 * (x167 * x469 - x168 * x472 + x53 * (x167 * x456 - x168 * x463))
    )
    x561 = x167 * x489 - x168 * x490 + x53 * (x167 * x477 - x168 * x478)
    x562 = x13 * x529 + x18 * x558 + x561
    x563 = x13 * x531
    x564 = x167 * x494 - x168 * x477
    x565 = x16 * x564 + x556
    x566 = x13 * x532
    x567 = x17 * x564 + x561
    x568 = x13 * x533
    x569 = x167 * x500 - x168 * x501 + x18 * x564
    x570 = x16 * x257 + x263
    x571 = x17 * x257 + x296
    x572 = x18 * x257 + x422
    x573 = x16 * x331 + x296
    x574 = x17 * x331 + x340
    x575 = x18 * x331 + x436
    x576 = x16 * x442 + x422
    x577 = x17 * x442 + x436
    x578 = x18 * x442 + x253 * x365
    x579 = x12 * x570 + x519
    x580 = x12 * x571 + x521
    x581 = x12 * x572 + x523
    x582 = x12 * x573 + x525
    x583 = x12 * x574 + x527
    x584 = x12 * x575 + x529
    x585 = x12 * x576 + x531
    x586 = x12 * x577 + x532
    x587 = x12 * x578 + x533
    x588 = x16 * x457 + x460
    x589 = x13 * x570 + x588
    x590 = x17 * x457 + x473
    x591 = x13 * x571 + x590
    x592 = x18 * x457 + x479
    x593 = x13 * x572 + x592
    x594 = x16 * x483 + x473
    x595 = x13 * x573 + x594
    x596 = x17 * x483 + x486
    x597 = x13 * x574 + x596
    x598 = x18 * x483 + x489
    x599 = x13 * x575 + x598
    x600 = x16 * x494 + x479
    x601 = x13 * x576 + x600
    x602 = x17 * x494 + x489
    x603 = x13 * x577 + x602
    x604 = x18 * x494 + x500
    x605 = x13 * x578 + x604
    x606 = x247 * x457 - x248 * x458 + 2 * x280
    x607 = x247 * x473 - x248 * x474 + 2 * x309
    x608 = (
        x247 * x479
        - x248 * x480
        + 2 * x324
        + x53 * (x247 * x458 - x248 * x466 + 2 * x283)
    )
    x609 = x247 * x483 - x248 * x469 + 2 * x336
    x610 = (
        x247 * x489
        - x248 * x490
        + 2 * x353
        + x53 * (x247 * x469 - x248 * x472 + 2 * x310)
    )
    x611 = (
        x247 * x494
        - x248 * x477
        + 2 * x359
        + x53 * (x247 * x453 - x248 * x456 + 2 * x281)
    )

    # 162 item(s)
    S = numpy.array(
        [
            x104 * x16
            + x105 * x11
            + x11 * (x105 + x106 * x11)
            + x3 * x81
            - x54
            * (x3 * x59 - x54 * (x3 * x48 - x54 * x87 + x58 * x89) + x58 * x93 + x82)
            + x58
            * (
                x3 * x80
                + x53
                * (
                    x3 * x78
                    - x54 * x92
                    + x73 * (2 * x10 * x14 * x19 * x3 * x32 * x6 - x67 - x77)
                )
                - x54 * x93
                + x73 * (x70 - x79)
            )
            + x73 * (-x60 + x71),
            x104 * x17 + x11 * x131 + x11 * (x11 * x132 + x131) + x139,
            x104 * x18 + x11 * x140 + x11 * (x140 + x141 * x98),
            x11 * x148 + x11 * (x11 * x149 + x148) + x139 + x150 * x16,
            x11 * x164
            + x11 * (x11 * x165 + x164)
            + x150 * x17
            + x161 * x3
            - x54 * (x157 * x3 + x162 - x54 * (x155 * x3 - x163 * x54))
            + x73 * (x151 * x3 - x154 - x158),
            x11 * x166 + x11 * (x141 * x145 + x166) + x150 * x18,
            0,
            0,
            0,
            x105 * x12 + x11 * x193 + x205,
            x11 * x215 + x12 * x131 + x222,
            x11 * x225 + x12 * x140 + x226,
            x11 * x231 + x12 * x148 + x234,
            x11 * x240 + x12 * x164 + x243,
            x11 * x245 + x12 * x166 + x246,
            0,
            0,
            0,
            x105 * x13 + x11 * x278 + x294,
            x11 * x308 + x13 * x131 + x317,
            x11 * x322 + x13 * x140 + x329,
            x11 * x335 + x13 * x148 + x338,
            x11 * x345 + x13 * x164 + x348,
            x11 * x351 + x13 * x166 + x355,
            x361,
            x363,
            x369,
            x12 * x193 + x379,
            x12 * x215 + x385,
            x12 * x225 + x386,
            x12 * x231 + x389,
            x12 * x240 + x392,
            x12 * x245 + x393,
            0,
            0,
            0,
            x12 * x278 + x410,
            x12 * x308 + x419,
            x12 * x322 + x427,
            x12 * x335 + x431,
            x12 * x345 + x435,
            x12 * x351 + x441,
            x446,
            x448,
            x452,
            x13 * x278 + x468,
            x13 * x308 + x476,
            x13 * x322 + x482,
            x13 * x335 + x485,
            x13 * x345 + x488,
            x13 * x351 + x492,
            2 * x493 + x496,
            2 * x497 + x498,
            2 * x499 + x502,
            x11 * x192 + x11 * (x11 * x503 + x192) + x205,
            x11 * x214 + x11 * (x11 * x504 + x214) + x222,
            x11 * x224 + x11 * (x141 * x176 + x224) + x226,
            x11 * x230 + x11 * (x11 * x505 + x230) + x234,
            x11 * x239 + x11 * (x11 * x506 + x239) + x243,
            x11 * x244 + x11 * (x141 * x227 + x244) + x246,
            0,
            0,
            0,
            x11 * x508 + x379,
            x11 * x510 + x385,
            x11 * x512 + x386,
            x11 * x514 + x389,
            x11 * x516 + x392,
            x11 * x518 + x393,
            0,
            0,
            0,
            x11 * x520 + x410,
            x11 * x522 + x419,
            x11 * x524 + x427,
            x11 * x526 + x431,
            x11 * x528 + x435,
            x11 * x530 + x441,
            x11 * x531 + x445,
            x11 * x532 + x447,
            x11 * x533 + x451,
            x12 * x507 + x12 * x508 + x16 * x534 + x167 * x375 - x168 * x378 + 2 * x194,
            x12 * x509 + x12 * x510 + x17 * x534 + x535,
            x12 * x511 + x12 * x512 + x18 * x534,
            x12 * x513 + x12 * x514 + x16 * x536 + x535,
            x12 * x515
            + x12 * x516
            + x167 * x390
            - x168 * x391
            + x17 * x536
            + 2 * x241
            + x58
            * (
                x167 * x380
                - x168 * x381
                + 2 * x217
                + x53 * (x167 * x371 - x168 * x376 + 2 * x199)
            ),
            x12 * x517 + x12 * x518 + x18 * x536,
            0,
            0,
            0,
            x12 * x520 + x13 * x507 + x538,
            x12 * x522 + x13 * x509 + x540,
            x12 * x524 + x13 * x511 + x542,
            x12 * x526 + x13 * x513 + x544,
            x12 * x528 + x13 * x515 + x545,
            x12 * x530 + x13 * x517 + x547,
            x549,
            x550,
            x551,
            x13 * x520 + x553,
            x13 * x522 + x555,
            x13 * x524 + x557,
            x13 * x526 + x559,
            x13 * x528 + x560,
            x13 * x530 + x562,
            2 * x563 + x565,
            2 * x566 + x567,
            2 * x568 + x569,
            x11 * x277 + x11 * (x11 * x570 + x277) + x294,
            x11 * x307 + x11 * (x11 * x571 + x307) + x317,
            x11 * x321 + x11 * (x11 * x572 + x321) + x329,
            x11 * x334 + x11 * (x11 * x573 + x334) + x338,
            x11 * x344 + x11 * (x11 * x574 + x344) + x348,
            x11 * x350 + x11 * (x11 * x575 + x350) + x355,
            x11 * (x11 * x576 + x358) + x361,
            x11 * (x11 * x577 + x362) + x363,
            x11 * (x11 * x578 + x368) + x369,
            x11 * x579 + x12 * x277 + x409,
            x11 * x580 + x12 * x307 + x418,
            x11 * x581 + x12 * x321 + x426,
            x11 * x582 + x12 * x334 + x430,
            x11 * x583 + x12 * x344 + x434,
            x11 * x584 + x12 * x350 + x440,
            x11 * x585 + x446,
            x11 * x586 + x448,
            x11 * x587 + x452,
            x11 * x589 + x468,
            x11 * x591 + x476,
            x11 * x593 + x482,
            x11 * x595 + x485,
            x11 * x597 + x488,
            x11 * x599 + x492,
            x11 * x601 + x493 + x496,
            x11 * x603 + x497 + x498,
            x11 * x605 + x499 + x502,
            x12 * x519 + x12 * x579 + x538,
            x12 * x521 + x12 * x580 + x540,
            x12 * x523 + x12 * x581 + x542,
            x12 * x525 + x12 * x582 + x544,
            x12 * x527 + x12 * x583 + x545,
            x12 * x529 + x12 * x584 + x547,
            x12 * x585 + x549,
            x12 * x586 + x550,
            x12 * x587 + x551,
            x12 * x589 + x553,
            x12 * x591 + x555,
            x12 * x593 + x557,
            x12 * x595 + x559,
            x12 * x597 + x560,
            x12 * x599 + x562,
            x12 * x601 + x563 + x565,
            x12 * x603 + x566 + x567,
            x12 * x605 + x568 + x569,
            x13 * x588 + x13 * x589 + x16 * x606 + x247 * x460 - x248 * x467 + 2 * x279,
            x13 * x590 + x13 * x591 + x17 * x606 + x607,
            x13 * x592 + x13 * x593 + x18 * x606 + x608,
            x13 * x594 + x13 * x595 + x16 * x609 + x607,
            x13 * x596 + x13 * x597 + x17 * x609 + x247 * x486 - x248 * x487 + 2 * x346,
            x13 * x598 + x13 * x599 + x18 * x609 + x610,
            x13 * x600 + x13 * x601 + x16 * x611 + x608,
            x13 * x602 + x13 * x603 + x17 * x611 + x610,
            x13 * x604
            + x13 * x605
            + x18 * x611
            + x247 * x500
            - x248 * x501
            + 2 * x366
            + x58
            * (
                x247 * x477
                - x248 * x478
                + 2 * x326
                + x53 * (x247 * x456 - x248 * x463 + 2 * x284)
            ),
        ]
    )
    return S


def eri_1212(a, A, b, B, c, C, d, D):
    """Cartesian [pd|pd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = c + d
    x5 = x4 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x6 - C[0]
    x8 = x0 + x4
    x9 = x8 ** (-1.0)
    x10 = -x2 - x6
    x11 = x5 * (c * C[1] + d * D[1])
    x12 = -x1 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x1 * (a * A[2] + b * B[2])
    x15 = -x14 - x5 * (c * C[2] + d * D[2])
    x16 = x0 * x4
    x17 = x16 * x9 * (x10**2 + x13**2 + x15**2)
    x18 = boys(2, x17)
    x19 = numpy.pi**2.5
    x20 = (x16 + numpy.sqrt(x8)) ** (-1.0)
    x21 = A[0] - B[0]
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x1 * (x21**2 + x22**2 + x23**2))
    x25 = C[0] - D[0]
    x26 = C[1] - D[1]
    x27 = C[2] - D[2]
    x28 = x27**2
    x29 = numpy.exp(-c * d * x5 * (x25**2 + x26**2 + x28))
    x30 = 2 * x19 * x20 * x24 * x29
    x31 = x18 * x30
    x32 = x0 * x9
    x33 = x10 * x32
    x34 = boys(3, x17)
    x35 = x30 * x34
    x36 = x31 * x7 + x33 * x35
    x37 = x32 * x36
    x38 = boys(1, x17)
    x39 = x30 * x38
    x40 = x31 * x33 + x39 * x7
    x41 = 2 * c + 2 * d
    x42 = x41 ** (-1.0)
    x43 = 2 * x42
    x44 = -2 * x19 * x20 * x24 * x29 * x38
    x45 = x42 * (-x31 * x32 - x44)
    x46 = x10 * x37 + x40 * x7 + x45
    x47 = -2 * x18 * x19 * x20 * x24 * x29
    x48 = x42 * (-x32 * x35 - x47)
    x49 = boys(4, x17)
    x50 = x30 * x49
    x51 = x33 * x50 + x35 * x7
    x52 = x32 * x51
    x53 = x10 * x52 + x36 * x7 + x48
    x54 = x33 * x53 + x43 * (-x37 + x40) + x46 * x7
    x55 = -2 * x19 * x20 * x24 * x29 * x34
    x56 = x42 * (-x32 * x50 - x55)
    x57 = x30 * boys(5, x17)
    x58 = x33 * x57 + x50 * x7
    x59 = x32 * x58
    x60 = x10 * x59 + x51 * x7 + x56
    x61 = x33 * x60 + x43 * (x36 - x52) + x53 * x7
    x62 = x4 * x9
    x63 = x61 * x62
    x64 = x60 * x62
    x65 = 2 * a + 2 * b
    x66 = x41 + x65
    x67 = x66 ** (-1.0)
    x68 = x10 * x62
    x69 = x3 * x50 - x57 * x68
    x70 = x58 * x62
    x71 = -x10 * x70 + x3 * x51 + x67 * x69
    x72 = 2 * x67
    x73 = -x10 * x64 + x3 * x53 + x71 * x72
    x74 = 3 * x67
    x75 = -x10 * x63 + x3 * x54 + x73 * x74
    x76 = x62 * x75
    x77 = x32 * x40
    x78 = boys(0, x17)
    x79 = x30 * x78
    x80 = x33 * x39 + x7 * x79
    x81 = x42 * (2 * x19 * x20 * x24 * x29 * x78 - x32 * x39)
    x82 = x10 * x77 + x7 * x80 + x81
    x83 = x33 * x46 + x43 * (-x77 + x80) + x7 * x82
    x84 = x54 * x62
    x85 = x53 * x62
    x86 = x50 * x68
    x87 = x3 * x35 - x86
    x88 = x51 * x62
    x89 = -x10 * x88 + x3 * x36 + x67 * x87
    x90 = -x10 * x85 + x3 * x46 + x72 * x89
    x91 = -x10 * x84 + x3 * x83 + x74 * x90
    x92 = x65 ** (-1.0)
    x93 = 2 * x92
    x94 = x92 * (x83 - x84)
    x95 = x92 * (x46 - x85)
    x96 = x62 * x73
    x97 = x92 * (x36 - x88)
    x98 = x92 * (-x50 * x62 - x55)
    x99 = x62 * x69
    x100 = -x10 * x99 + x3 * x87 + x98
    x101 = x62 * x71
    x102 = -x10 * x101 + x100 * x67 + x3 * x89 + x97
    x103 = -x10 * x96 + x102 * x72 + x3 * x90 + x95
    x104 = -x10 * x76 + x103 * x74 + x3 * x91 + x94
    x105 = x92 * (x54 - x63)
    x106 = -2 * x19 * x20 * x24 * x29 * x49
    x107 = x42 * (-x106 - x32 * x57)
    x108 = x30 * boys(6, x17)
    x109 = x108 * x33 + x57 * x7
    x110 = x107 + x109 * x33 + x58 * x7
    x111 = x110 * x33 + x43 * (x51 - x59) + x60 * x7
    x112 = -x108 * x68 + x3 * x57
    x113 = -x109 * x68 + x112 * x67 + x3 * x58
    x114 = -x110 * x68 + x113 * x72 + x3 * x60
    x115 = x92 * (x53 - x64)
    x116 = x92 * (x51 - x70)
    x117 = x92 * (-x106 - x57 * x62)
    x118 = -x112 * x68 + x117 + x3 * x69
    x119 = -x113 * x68 + x116 + x118 * x67 + x3 * x71
    x120 = -x114 * x68 + x115 + x119 * x72 + x3 * x73
    x121 = x62 * x90
    x122 = x46 * x62
    x123 = x35 * x68
    x124 = -x123 + x3 * x31
    x125 = x36 * x62
    x126 = -x10 * x125 + x124 * x67 + x3 * x40
    x127 = -x10 * x122 + x126 * x72 + x3 * x82
    x128 = x92 * (-x122 + x82)
    x129 = x92 * (-x125 + x40)
    x130 = x92 * (-x35 * x62 - x47)
    x131 = x62 * x87
    x132 = -x10 * x131 + x124 * x3 + x130
    x133 = x62 * x89
    x134 = -x10 * x133 + x126 * x3 + x129 + x132 * x67
    x135 = -x10 * x121 + x127 * x3 + x128 + x134 * x72
    x136 = (
        -x103 * x68
        + x135 * x3
        + x72
        * (
            -x102 * x68
            + x134 * x3
            + x67
            * (
                -x100 * x68
                + x132 * x3
                + x93 * (-x123 - x131 + 2 * x18 * x19 * x20 * x24 * x29 * x3)
            )
            + x93 * (x126 - x133)
        )
        + x93 * (-x121 + x127)
    )
    x137 = x126 * x62
    x138 = x31 * x68
    x139 = -x138 + x3 * x39
    x140 = x40 * x62
    x141 = -x10 * x140 + x139 * x67 + x3 * x80
    x142 = x124 * x62
    x143 = x92 * (-x31 * x62 - x44)
    x144 = -x10 * x142 + x139 * x3 + x143
    x145 = x92 * (-x140 + x80)
    x146 = -x10 * x137 + x141 * x3 + x144 * x67 + x145
    x147 = (
        -x134 * x68
        + x146 * x3
        + x67
        * (
            -x132 * x68
            + x144 * x3
            + x93 * (-x138 - x142 + 2 * x19 * x20 * x24 * x29 * x3 * x38)
        )
        + x93 * (-x137 + x141)
    )
    x148 = x147 * x25
    x149 = x146 * x25
    x150 = x104 + x135 * x25 + x25 * (x135 + x149)
    x151 = x141 * x25
    x152 = x127 * x25 + x25 * (x127 + x151) + x91
    x153 = x146 * x26
    x154 = x11 - C[1]
    x155 = x13 * x32
    x156 = x154 * x39 + x155 * x31
    x157 = x154 * x31 + x155 * x35
    x158 = x157 * x32
    x159 = x10 * x158 + x156 * x7
    x160 = x159 * x62
    x161 = x154 * x79 + x155 * x39
    x162 = x156 * x32
    x163 = x10 * x162 + x161 * x7
    x164 = x92 * (-x160 + x163)
    x165 = x157 * x62
    x166 = x92 * (x156 - x165)
    x167 = x10 * x165
    x168 = x156 * x3 - x167
    x169 = x154 * x35 + x155 * x50
    x170 = x169 * x62
    x171 = x10 * x170
    x172 = x157 * x3 - x171
    x173 = x172 * x62
    x174 = -x10 * x173 + x166 + x168 * x3
    x175 = -x10 * x160 + x163 * x3 + x168 * x67
    x176 = x169 * x32
    x177 = x10 * x176 + x157 * x7
    x178 = x177 * x62
    x179 = -x10 * x178 + x159 * x3 + x172 * x67
    x180 = x179 * x62
    x181 = -x10 * x180 + x164 + x174 * x67 + x175 * x3
    x182 = x153 + x181
    x183 = x42 * (x156 - x158)
    x184 = x159 * x7 + x177 * x33 + x183
    x185 = x184 * x62
    x186 = x42 * (x161 - x162)
    x187 = x159 * x33 + x163 * x7 + x186
    x188 = x92 * (-x185 + x187)
    x189 = -x10 * x185 + x179 * x72 + x187 * x3
    x190 = x42 * (x157 - x176)
    x191 = x154 * x50 + x155 * x57
    x192 = x191 * x32
    x193 = x10 * x192 + x169 * x7
    x194 = x177 * x7 + x190 + x193 * x33
    x195 = x194 * x62
    x196 = x191 * x62
    x197 = -x10 * x196 + x169 * x3
    x198 = x193 * x62
    x199 = -x10 * x198 + x177 * x3 + x197 * x67
    x200 = -x10 * x195 + x184 * x3 + x199 * x72
    x201 = x200 * x62
    x202 = x92 * (x159 - x178)
    x203 = x92 * (x157 - x170)
    x204 = x197 * x62
    x205 = -x10 * x204 + x172 * x3 + x203
    x206 = x199 * x62
    x207 = -x10 * x206 + x179 * x3 + x202 + x205 * x67
    x208 = -x10 * x201 + x188 + x189 * x3 + x207 * x72
    x209 = x135 * x26 + x182 * x25 + x208
    x210 = x141 * x26
    x211 = x175 + x210
    x212 = x127 * x26 + x189 + x211 * x25
    x213 = x147 * x26
    x214 = (
        x181 * x3
        - x207 * x68
        + x67 * (x174 * x3 - x205 * x68 + x93 * (x156 * x3 - x167 - x173))
        + x93 * (x175 - x180)
    )
    x215 = x213 + x214
    x216 = x92 * (x169 - x196)
    x217 = x108 * x155 + x154 * x57
    x218 = x191 * x3 - x217 * x68
    x219 = x197 * x3 + x216 - x218 * x68
    x220 = x92 * (x177 - x198)
    x221 = x191 * x7 + x217 * x33
    x222 = x193 * x3 + x218 * x67 - x221 * x68
    x223 = x199 * x3 + x219 * x67 + x220 - x222 * x68
    x224 = x92 * (x184 - x195)
    x225 = x42 * (x169 - x192)
    x226 = x193 * x7 + x221 * x33 + x225
    x227 = (
        x208 * x3
        - x68
        * (x200 * x3 + x223 * x72 + x224 - x68 * (x194 * x3 + x222 * x72 - x226 * x68))
        + x72
        * (
            x207 * x3
            - x223 * x68
            + x67 * (x205 * x3 - x219 * x68 + x93 * (x157 * x3 - x171 - x204))
            + x93 * (x179 - x206)
        )
        + x93 * (x189 - x201)
    )
    x228 = x135 * x27 + x149 * x27
    x229 = x127 * x27 + x151 * x27
    x230 = x13 * x158 + x154 * x156 + x45
    x231 = x13 * x176 + x154 * x157 + x48
    x232 = x230 * x7 + x231 * x33
    x233 = x232 * x62
    x234 = x13 * x162 + x154 * x161 + x81
    x235 = x230 * x33 + x234 * x7
    x236 = x92 * (-x233 + x235)
    x237 = x231 * x62
    x238 = x92 * (x230 - x237)
    x239 = x10 * x237
    x240 = x230 * x3 - x239
    x241 = x13 * x192 + x154 * x169 + x56
    x242 = x241 * x62
    x243 = -x10 * x242 + x231 * x3
    x244 = x243 * x62
    x245 = -x10 * x244 + x238 + x240 * x3
    x246 = -x10 * x233 + x235 * x3 + x240 * x67
    x247 = x231 * x7 + x241 * x33
    x248 = x247 * x62
    x249 = -x10 * x248 + x232 * x3 + x243 * x67
    x250 = x249 * x62
    x251 = -x10 * x250 + x236 + x245 * x67 + x246 * x3
    x252 = x181 * x26 + x251
    x253 = x182 * x26 + x252
    x254 = x175 * x26 + x246
    x255 = x211 * x26 + x254
    x256 = x92 * (x231 - x242)
    x257 = x107 + x154 * x191 + x155 * x217
    x258 = x241 * x3 - x257 * x68
    x259 = x243 * x3 + x256 - x258 * x68
    x260 = x92 * (x232 - x248)
    x261 = x241 * x7 + x257 * x33
    x262 = (
        x214 * x26
        + x251 * x3
        + x67 * (x245 * x3 - x259 * x68 + x93 * (x230 * x3 - x239 - x244))
        - x68
        * (x249 * x3 + x259 * x67 + x260 - x68 * (x247 * x3 + x258 * x67 - x261 * x68))
        + x93 * (x246 - x250)
    )
    x263 = x181 * x27
    x264 = x153 * x27 + x263
    x265 = x175 * x27
    x266 = x210 * x27 + x265
    x267 = x214 * x27
    x268 = x146 * x28
    x269 = x21 * x28
    x270 = x156 * x62
    x271 = x92 * (x161 - x270)
    x272 = x10 * x270
    x273 = x161 * x3 - x272
    x274 = x168 * x62
    x275 = -x10 * x274 + x271 + x273 * x3
    x276 = x25 * x275
    x277 = x181 * x25 + x208 + x25 * (x181 + x276)
    x278 = x25 * x273
    x279 = x175 * x25 + x189 + x25 * (x175 + x278)
    x280 = -x174 * x68 + x275 * x3 + x93 * (x161 * x3 - x272 - x274)
    x281 = x25 * x280
    x282 = x26 * x275
    x283 = x230 * x62
    x284 = x92 * (x234 - x283)
    x285 = x10 * x283
    x286 = x234 * x3 - x285
    x287 = x240 * x62
    x288 = -x10 * x287 + x284 + x286 * x3
    x289 = x282 + x288
    x290 = x25 * x289 + x252
    x291 = x26 * x273
    x292 = x286 + x291
    x293 = x25 * x292 + x254
    x294 = x26 * x280
    x295 = -x245 * x68 + x288 * x3 + x93 * (x234 * x3 - x285 - x287)
    x296 = x294 + x295
    x297 = x263 + x27 * x276
    x298 = x265 + x27 * x278
    x299 = x154 * x234 + x155 * x230 + 2 * x186
    x300 = x154 * x230 + x155 * x231 + 2 * x183
    x301 = x300 * x62
    x302 = x10 * x301
    x303 = x154 * x231 + x155 * x241 + 2 * x190
    x304 = x303 * x62
    x305 = -x10 * x304 + x3 * x300
    x306 = x305 * x62
    x307 = x92 * (x299 - x301)
    x308 = x299 * x3 - x302
    x309 = -x10 * x306 + x3 * x308 + x307
    x310 = x92 * (x300 - x304)
    x311 = x154 * x241 + x155 * x257 + 2 * x225
    x312 = x26 * x288 + x26 * x289 + x309
    x313 = x26 * x286 + x26 * x292 + x308
    x314 = x27 * x282 + x27 * x288
    x315 = x27 * x286 + x27 * x291
    x316 = x275 * x28
    x317 = -x12 - A[1]
    x318 = x122 * x13
    x319 = x317 * x82 - x318
    x320 = x13 * x85
    x321 = x317 * x46 - x320
    x322 = x321 * x62
    x323 = x13 * x62
    x324 = x323 * x35
    x325 = x31 * x317 - x324
    x326 = x323 * x50
    x327 = x317 * x35 - x326
    x328 = x327 * x62
    x329 = -x10 * x328 + x3 * x325
    x330 = x125 * x13
    x331 = x317 * x40 - x330
    x332 = x13 * x88
    x333 = x317 * x36 - x332
    x334 = x333 * x62
    x335 = -x10 * x334 + x3 * x331 + x329 * x67
    x336 = -x10 * x322 + x3 * x319 + x335 * x72
    x337 = x31 * x323
    x338 = x317 * x39 - x337
    x339 = x325 * x62
    x340 = -x10 * x339 + x3 * x338
    x341 = x13 * x140
    x342 = x317 * x80 - x341
    x343 = x331 * x62
    x344 = -x10 * x343 + x3 * x342 + x340 * x67
    x345 = x25 * x344
    x346 = x13 * x84
    x347 = x317 * x83 - x346
    x348 = -x13 * x63 + x317 * x54
    x349 = x348 * x62
    x350 = -x13 * x64 + x317 * x53
    x351 = x350 * x62
    x352 = x317 * x50 - x323 * x57
    x353 = x352 * x62
    x354 = -x10 * x353 + x3 * x327
    x355 = -x13 * x70 + x317 * x51
    x356 = x355 * x62
    x357 = -x10 * x356 + x3 * x333 + x354 * x67
    x358 = -x10 * x351 + x3 * x321 + x357 * x72
    x359 = -x10 * x349 + x3 * x347 + x358 * x74
    x360 = x25 * x336 + x25 * (x336 + x345) + x359
    x361 = x152 * x22 + x360
    x362 = x92 * (x317 * x83 - x346 - x349)
    x363 = x92 * (x317 * x82 - x318 - x322)
    x364 = x92 * (x317 * x40 - x330 - x334)
    x365 = x92 * (2 * x18 * x19 * x20 * x24 * x29 * x317 - x324 - x328)
    x366 = (
        x3 * x336
        - x358 * x68
        + x363
        + x72 * (x3 * x335 - x357 * x68 + x364 + x67 * (x3 * x329 - x354 * x68 + x365))
    )
    x367 = x92 * (x317 * x80 - x341 - x343)
    x368 = x92 * (2 * x19 * x20 * x24 * x29 * x317 * x38 - x337 - x339)
    x369 = x3 * x344 - x335 * x68 + x367 + x67 * (x3 * x340 - x329 * x68 + x368)
    x370 = x25 * x369
    x371 = x92 * (x317 * x46 - x320 - x351)
    x372 = -x110 * x323 + x317 * x60
    x373 = -x108 * x323 + x317 * x57
    x374 = x3 * x352 - x373 * x68
    x375 = -x109 * x323 + x317 * x58
    x376 = x3 * x355 + x374 * x67 - x375 * x68
    x377 = x3 * x350 - x372 * x68 + x376 * x72
    x378 = x92 * (x317 * x36 - x332 - x356)
    x379 = x92 * (2 * x19 * x20 * x24 * x29 * x317 * x34 - x326 - x353)
    x380 = -x111 * x323 + x317 * x61
    x381 = (
        x25 * x366
        + x25 * (x366 + x370)
        + x3 * x359
        + x362
        - x68 * (x3 * x348 + x377 * x74 - x380 * x68)
        + x74
        * (
            x3 * x358
            + x371
            - x377 * x68
            + x72
            * (x3 * x357 - x376 * x68 + x378 + x67 * (x3 * x354 - x374 * x68 + x379))
        )
    )
    x382 = x26 * x344
    x383 = -x13 * x165 + x156 * x317 + x325 * x67
    x384 = -x13 * x170 + x157 * x317 + x327 * x67
    x385 = x384 * x62
    x386 = -x10 * x385 + x3 * x383
    x387 = -x13 * x160 + x163 * x317 + x331 * x67
    x388 = -x13 * x178 + x159 * x317 + x333 * x67
    x389 = x388 * x62
    x390 = -x10 * x389 + x3 * x387 + x386 * x67
    x391 = x382 + x390
    x392 = -x13 * x185 + x187 * x317 + x321 * x67
    x393 = -x13 * x195 + x184 * x317 + x350 * x67
    x394 = x393 * x62
    x395 = -x13 * x196 + x169 * x317 + x352 * x67
    x396 = x395 * x62
    x397 = -x10 * x396 + x3 * x384
    x398 = -x13 * x198 + x177 * x317 + x355 * x67
    x399 = x398 * x62
    x400 = -x10 * x399 + x3 * x388 + x397 * x67
    x401 = -x10 * x394 + x3 * x392 + x400 * x72
    x402 = x25 * x391 + x26 * x336 + x401
    x403 = x212 * x22 + x402
    x404 = x26 * x369
    x405 = x92 * (x387 - x389)
    x406 = x92 * (x383 - x385)
    x407 = x3 * x390 - x400 * x68 + x405 + x67 * (x3 * x386 - x397 * x68 + x406)
    x408 = x404 + x407
    x409 = x92 * (x392 - x394)
    x410 = x92 * (x388 - x399)
    x411 = x92 * (x384 - x396)
    x412 = x191 * x317 - x217 * x323 + x373 * x67
    x413 = x3 * x395 - x412 * x68
    x414 = x193 * x317 - x221 * x323 + x375 * x67
    x415 = x3 * x398 + x413 * x67 - x414 * x68
    x416 = x194 * x317 - x226 * x323 + x372 * x67
    x417 = (
        x3 * x401
        + x409
        - x68 * (x3 * x393 + x415 * x72 - x416 * x68)
        + x72 * (x3 * x400 + x410 - x415 * x68 + x67 * (x3 * x397 + x411 - x413 * x68))
    )
    x418 = x25 * x408 + x26 * x366 + x417
    x419 = x27 * x336 + x27 * x345
    x420 = x22 * x229 + x419
    x421 = x27 * x366 + x27 * x370
    x422 = -x13 * x237 + x230 * x317 + x384 * x72
    x423 = -x13 * x242 + x231 * x317 + x395 * x72
    x424 = x423 * x62
    x425 = -x10 * x424 + x3 * x422
    x426 = -x13 * x233 + x235 * x317 + x388 * x72
    x427 = -x13 * x248 + x232 * x317 + x398 * x72
    x428 = x427 * x62
    x429 = -x10 * x428 + x3 * x426 + x425 * x67
    x430 = x26 * x390 + x429
    x431 = x26 * x391 + x430
    x432 = x22 * x255 + x431
    x433 = x92 * (x426 - x428)
    x434 = x92 * (x422 - x424)
    x435 = x241 * x317 - x257 * x323 + x412 * x72
    x436 = x3 * x423 - x435 * x68
    x437 = x247 * x317 - x261 * x323 + x414 * x72
    x438 = (
        x26 * x407
        + x3 * x429
        + x433
        + x67 * (x3 * x425 + x434 - x436 * x68)
        - x68 * (x3 * x427 + x436 * x67 - x437 * x68)
    )
    x439 = x26 * x408 + x438
    x440 = x27 * x390
    x441 = x27 * x382 + x440
    x442 = x22 * x266 + x441
    x443 = x27 * x407
    x444 = x27 * x404 + x443
    x445 = x22 * x28
    x446 = x28 * x344
    x447 = x141 * x445 + x446
    x448 = x28 * x369
    x449 = -x13 * x270 + x161 * x317 + x338 * x67
    x450 = x383 * x62
    x451 = -x10 * x450 + x3 * x449
    x452 = x25 * x451
    x453 = x25 * x390 + x25 * (x390 + x452) + x401
    x454 = x22 * x279 + x453
    x455 = x92 * (x449 - x450)
    x456 = x3 * x451 - x386 * x68 + x455
    x457 = x25 * x456
    x458 = x25 * x407 + x25 * (x407 + x457) + x417
    x459 = x26 * x451
    x460 = -x13 * x283 + x234 * x317 + x383 * x72
    x461 = x422 * x62
    x462 = -x10 * x461 + x3 * x460
    x463 = x459 + x462
    x464 = x25 * x463 + x430
    x465 = x22 * x293 + x464
    x466 = x26 * x456
    x467 = x92 * (x460 - x461)
    x468 = x3 * x462 - x425 * x68 + x467
    x469 = x466 + x468
    x470 = x25 * x469 + x438
    x471 = x27 * x452 + x440
    x472 = x22 * x298 + x471
    x473 = x27 * x457 + x443
    x474 = -x13 * x301 + x299 * x317 + x422 * x74
    x475 = -x13 * x304 + x300 * x317 + x423 * x74
    x476 = x475 * x62
    x477 = -x10 * x476 + x3 * x474
    x478 = x26 * x462 + x26 * x463 + x477
    x479 = x22 * x313 + x478
    x480 = x92 * (x474 - x476)
    x481 = x303 * x317 - x311 * x323 + x435 * x74
    x482 = x26 * x468 + x26 * x469 + x3 * x477 + x480 - x68 * (x3 * x475 - x481 * x68)
    x483 = x27 * x459 + x27 * x462
    x484 = x22 * x315 + x483
    x485 = x27 * x466 + x27 * x468
    x486 = x28 * x451
    x487 = x273 * x445 + x486
    x488 = x28 * x456
    x489 = -x14 - A[2]
    x490 = x122 * x15
    x491 = x489 * x82 - x490
    x492 = x15 * x85
    x493 = x46 * x489 - x492
    x494 = x493 * x62
    x495 = x15 * x62
    x496 = x35 * x495
    x497 = x31 * x489 - x496
    x498 = x3 * x497
    x499 = x495 * x50
    x500 = x35 * x489 - x499
    x501 = x500 * x62
    x502 = x10 * x501
    x503 = x498 - x502
    x504 = x125 * x15
    x505 = x40 * x489 - x504
    x506 = x3 * x505
    x507 = x15 * x88
    x508 = x36 * x489 - x507
    x509 = x508 * x62
    x510 = -x10 * x509 + x503 * x67 + x506
    x511 = -x10 * x494 + x3 * x491 + x510 * x72
    x512 = x31 * x495
    x513 = x39 * x489 - x512
    x514 = x3 * x513
    x515 = x497 * x62
    x516 = -x10 * x515 + x514
    x517 = x140 * x15
    x518 = x489 * x80 - x517
    x519 = x505 * x62
    x520 = -x10 * x519 + x3 * x518 + x516 * x67
    x521 = x15 * x84
    x522 = x489 * x83 - x521
    x523 = -x15 * x63 + x489 * x54
    x524 = x523 * x62
    x525 = x3 * x493
    x526 = -x15 * x64 + x489 * x53
    x527 = x526 * x62
    x528 = x10 * x527
    x529 = x3 * x500
    x530 = x489 * x50 - x495 * x57
    x531 = x530 * x62
    x532 = x10 * x531
    x533 = x529 - x532
    x534 = x3 * x508
    x535 = -x15 * x70 + x489 * x51
    x536 = x535 * x62
    x537 = x10 * x536
    x538 = x533 * x67 + x534 - x537
    x539 = x525 - x528 + x538 * x72
    x540 = -x10 * x524 + x3 * x522 + x539 * x74
    x541 = x25 * x511 + x25 * (x25 * x520 + x511) + x540
    x542 = x152 * x23 + x541
    x543 = x92 * (x489 * x83 - x521 - x524)
    x544 = x92 * (x489 * x82 - x490 - x494)
    x545 = x92 * (x40 * x489 - x504 - x509)
    x546 = x92 * (2 * x18 * x19 * x20 * x24 * x29 * x489 - x496 - x501)
    x547 = (
        x3 * x511
        - x539 * x68
        + x544
        + x72 * (x3 * x510 - x538 * x68 + x545 + x67 * (x3 * x503 - x533 * x68 + x546))
    )
    x548 = x92 * (x489 * x80 - x517 - x519)
    x549 = x92 * (2 * x19 * x20 * x24 * x29 * x38 * x489 - x512 - x515)
    x550 = x3 * x520 - x510 * x68 + x548 + x67 * (x3 * x516 - x503 * x68 + x549)
    x551 = x92 * (x46 * x489 - x492 - x527)
    x552 = x3 * x526
    x553 = -x110 * x495 + x489 * x60
    x554 = x553 * x68
    x555 = x3 * x530
    x556 = -x108 * x495 + x489 * x57
    x557 = x556 * x68
    x558 = x555 - x557
    x559 = x3 * x535
    x560 = -x109 * x495 + x489 * x58
    x561 = x560 * x68
    x562 = x558 * x67 + x559 - x561
    x563 = x552 - x554 + x562 * x72
    x564 = x92 * (x36 * x489 - x507 - x536)
    x565 = x92 * (2 * x19 * x20 * x24 * x29 * x34 * x489 - x499 - x531)
    x566 = -x111 * x495 + x489 * x61
    x567 = (
        x25 * x547
        + x25 * (x25 * x550 + x547)
        + x3 * x540
        + x543
        - x68 * (x3 * x523 + x563 * x74 - x566 * x68)
        + x74
        * (
            x3 * x539
            + x551
            - x563 * x68
            + x72
            * (x3 * x538 - x562 * x68 + x564 + x67 * (x3 * x533 - x558 * x68 + x565))
        )
    )
    x568 = x15 * x160
    x569 = x163 * x489 - x568
    x570 = x15 * x165
    x571 = x156 * x489 - x570
    x572 = x3 * x571
    x573 = x15 * x170
    x574 = x157 * x489 - x573
    x575 = x574 * x62
    x576 = -x10 * x575 + x572
    x577 = x15 * x178
    x578 = x159 * x489 - x577
    x579 = x578 * x62
    x580 = -x10 * x579 + x3 * x569 + x576 * x67
    x581 = x26 * x520 + x580
    x582 = x15 * x185
    x583 = x187 * x489 - x582
    x584 = -x15 * x195 + x184 * x489
    x585 = x584 * x62
    x586 = x3 * x578
    x587 = x3 * x574
    x588 = -x15 * x196 + x169 * x489
    x589 = x588 * x62
    x590 = x10 * x589
    x591 = x587 - x590
    x592 = -x15 * x198 + x177 * x489
    x593 = x592 * x62
    x594 = x10 * x593
    x595 = x586 + x591 * x67 - x594
    x596 = -x10 * x585 + x3 * x583 + x595 * x72
    x597 = x25 * x581 + x26 * x511 + x596
    x598 = x212 * x23 + x597
    x599 = x92 * (x163 * x489 - x568 - x579)
    x600 = x92 * (x156 * x489 - x570 - x575)
    x601 = x3 * x580 - x595 * x68 + x599 + x67 * (x3 * x576 - x591 * x68 + x600)
    x602 = x26 * x550 + x601
    x603 = x92 * (x187 * x489 - x582 - x585)
    x604 = x92 * (x159 * x489 - x577 - x593)
    x605 = x92 * (x157 * x489 - x573 - x589)
    x606 = x3 * x588
    x607 = x191 * x489 - x217 * x495
    x608 = x607 * x68
    x609 = x606 - x608
    x610 = x3 * x592
    x611 = x193 * x489 - x221 * x495
    x612 = x611 * x68
    x613 = x609 * x67 + x610 - x612
    x614 = x194 * x489 - x226 * x495
    x615 = (
        x3 * x596
        + x603
        - x68 * (x3 * x584 + x613 * x72 - x614 * x68)
        + x72 * (x3 * x595 + x604 - x613 * x68 + x67 * (x3 * x591 + x605 - x609 * x68))
    )
    x616 = x25 * x602 + x26 * x547 + x615
    x617 = x500 * x67
    x618 = x498 * x67 - x617 * x68
    x619 = x508 * x67
    x620 = x506 * x67 + x618 * x67 - x619 * x68
    x621 = x27 * x520 + x620
    x622 = x529 * x67 - x532 * x67
    x623 = x534 * x67 - x537 * x67 + x622 * x67
    x624 = x525 * x67 - x528 * x67 + x623 * x72
    x625 = x25 * x621 + x27 * x511 + x624
    x626 = x229 * x23 + x625
    x627 = x92 * (x505 * x67 - x619 * x62)
    x628 = x92 * (x497 * x67 - x617 * x62)
    x629 = x3 * x620 - x623 * x68 + x627 + x67 * (x3 * x618 - x622 * x68 + x628)
    x630 = x27 * x550 + x629
    x631 = x527 * x67
    x632 = x92 * (x493 * x67 - x631)
    x633 = x536 * x67
    x634 = x92 * (x508 * x67 - x633)
    x635 = x531 * x67
    x636 = x92 * (x500 * x67 - x635)
    x637 = x555 * x67 - x557 * x67
    x638 = x559 * x67 - x561 * x67 + x637 * x67
    x639 = (
        x3 * x624
        + x632
        - x68 * (x552 * x67 - x554 * x67 + x638 * x72)
        + x72 * (x3 * x623 + x634 - x638 * x68 + x67 * (x3 * x622 + x636 - x637 * x68))
    )
    x640 = x25 * x630 + x27 * x547 + x639
    x641 = x15 * x233
    x642 = x235 * x489 - x641
    x643 = x15 * x237
    x644 = x230 * x489 - x643
    x645 = x3 * x644
    x646 = -x15 * x242 + x231 * x489
    x647 = x62 * x646
    x648 = x10 * x647
    x649 = x645 - x648
    x650 = -x15 * x248 + x232 * x489
    x651 = x62 * x650
    x652 = -x10 * x651 + x3 * x642 + x649 * x67
    x653 = x26 * x580 + x652
    x654 = x26 * x581 + x653
    x655 = x23 * x255 + x654
    x656 = x92 * (x235 * x489 - x641 - x651)
    x657 = x92 * (x230 * x489 - x643 - x647)
    x658 = x3 * x646
    x659 = x241 * x489 - x257 * x495
    x660 = x659 * x68
    x661 = x658 - x660
    x662 = x247 * x489 - x261 * x495
    x663 = (
        x26 * x601
        + x3 * x652
        + x656
        + x67 * (x3 * x649 + x657 - x661 * x68)
        - x68 * (x3 * x650 + x661 * x67 - x662 * x68)
    )
    x664 = x26 * x602 + x663
    x665 = x587 * x67 - x590 * x67
    x666 = x586 * x67 - x594 * x67 + x665 * x67
    x667 = x27 * x580 + x666
    x668 = x26 * x621 + x667
    x669 = x23 * x266 + x668
    x670 = x593 * x67
    x671 = x92 * (x578 * x67 - x670)
    x672 = x589 * x67
    x673 = x92 * (x574 * x67 - x672)
    x674 = x606 * x67 - x608 * x67
    x675 = (
        x3 * x666
        + x67 * (x3 * x665 + x673 - x674 * x68)
        + x671
        - x68 * (x610 * x67 - x612 * x67 + x67 * x674)
    )
    x676 = x27 * x601 + x675
    x677 = x26 * x630 + x676
    x678 = x23 * x28
    x679 = x66 ** (-2.0)
    x680 = 2 * x679
    x681 = x529 * x680 - x532 * x680
    x682 = x534 * x680 - x537 * x680 + x67 * x681
    x683 = x27 * x620 + x682
    x684 = x27 * x621 + x683
    x685 = x141 * x678 + x684
    x686 = x92 * (2 * x508 * x679 - x536 * x680)
    x687 = x92 * (2 * x500 * x679 - x531 * x680)
    x688 = x555 * x680 - x557 * x680
    x689 = (
        x27 * x629
        + x3 * x682
        + x67 * (x3 * x681 - x68 * x688 + x687)
        - x68 * (x559 * x680 - x561 * x680 + x67 * x688)
        + x686
    )
    x690 = x27 * x630 + x689
    x691 = x15 * x270
    x692 = x161 * x489 - x691
    x693 = x571 * x62
    x694 = -x10 * x693 + x3 * x692
    x695 = x25 * x580 + x25 * (x25 * x694 + x580) + x596
    x696 = x23 * x279 + x695
    x697 = x92 * (x161 * x489 - x691 - x693)
    x698 = x3 * x694 - x576 * x68 + x697
    x699 = x25 * x601 + x25 * (x25 * x698 + x601) + x615
    x700 = x15 * x283
    x701 = x234 * x489 - x700
    x702 = x62 * x644
    x703 = -x10 * x702 + x3 * x701
    x704 = x26 * x694 + x703
    x705 = x25 * x704 + x653
    x706 = x23 * x293 + x705
    x707 = x92 * (x234 * x489 - x700 - x702)
    x708 = x3 * x703 - x649 * x68 + x707
    x709 = x26 * x698 + x708
    x710 = x25 * x709 + x663
    x711 = x574 * x67
    x712 = x572 * x67 - x68 * x711
    x713 = x27 * x694 + x712
    x714 = x25 * x713 + x667
    x715 = x23 * x298 + x714
    x716 = x92 * (x571 * x67 - x62 * x711)
    x717 = x3 * x712 - x665 * x68 + x716
    x718 = x27 * x698 + x717
    x719 = x25 * x718 + x676
    x720 = x15 * x301
    x721 = x299 * x489 - x720
    x722 = -x15 * x304 + x300 * x489
    x723 = x62 * x722
    x724 = -x10 * x723 + x3 * x721
    x725 = x26 * x703 + x26 * x704 + x724
    x726 = x23 * x313 + x725
    x727 = x92 * (x299 * x489 - x720 - x723)
    x728 = x303 * x489 - x311 * x495
    x729 = x26 * x708 + x26 * x709 + x3 * x724 - x68 * (x3 * x722 - x68 * x728) + x727
    x730 = x645 * x67 - x648 * x67
    x731 = x26 * x713 + x27 * x703 + x730
    x732 = x23 * x315 + x731
    x733 = x647 * x67
    x734 = x92 * (x644 * x67 - x733)
    x735 = x3 * x730 - x68 * (x658 * x67 - x660 * x67) + x734
    x736 = x26 * x718 + x27 * x708 + x735
    x737 = x587 * x680 - x590 * x680
    x738 = x27 * x712 + x737
    x739 = x27 * x713 + x738
    x740 = x273 * x678 + x739
    x741 = x92 * (2 * x574 * x679 - x589 * x680)
    x742 = x27 * x717 + x3 * x737 - x68 * (x606 * x680 - x608 * x680) + x741
    x743 = x27 * x718 + x742
    x744 = x497 * x67
    x745 = x514 * x67 - x68 * x744
    x746 = x25 * x620 + x25 * (x25 * x745 + x620) + x624
    x747 = x92 * (x513 * x67 - x62 * x744)
    x748 = x3 * x745 - x618 * x68 + x747
    x749 = x21 * x746 + x25 * x629 + x25 * (x25 * x748 + x629) + x639
    x750 = x26 * x745 + x712
    x751 = x25 * x750 + x26 * x620 + x666
    x752 = x26 * x748 + x717
    x753 = x21 * x751 + x25 * x752 + x26 * x629 + x675
    x754 = x498 * x680 - x502 * x680
    x755 = x27 * x745 + x754
    x756 = x25 * x755 + x683
    x757 = x92 * (2 * x497 * x679 - x501 * x680)
    x758 = x3 * x754 - x68 * x681 + x757
    x759 = x27 * x748 + x758
    x760 = x21 * x756 + x25 * x759 + x689
    x761 = x26 * x712 + x26 * x750 + x730
    x762 = x21 * x761 + x26 * x717 + x26 * x752 + x735
    x763 = x26 * x755 + x738
    x764 = x21 * x763 + x26 * x759 + x742
    x765 = x66 ** (-3.0)
    x766 = 6 * x765
    x767 = x92 * (6 * x500 * x765 - x531 * x766)
    x768 = x529 * x766 - x532 * x766
    x769 = x27 * x754 + x27 * x755 + x768
    x770 = (
        x21 * x769
        + x27 * x758
        + x27 * x759
        + x3 * x768
        - x68 * (x555 * x766 - x557 * x766)
        + x767
    )
    x771 = x128 - x13 * x322 + x317 * x319
    x772 = -x13 * x351 + x317 * x321 + x95
    x773 = -x13 * x328 + x130 + x317 * x325
    x774 = -x13 * x353 + x317 * x327 + x98
    x775 = x129 - x13 * x334 + x317 * x331
    x776 = -x13 * x356 + x317 * x333 + x97
    x777 = (
        x3 * x771
        - x68 * x772
        + x72 * (x3 * x775 + x67 * (x3 * x773 - x68 * x774) - x68 * x776)
    )
    x778 = -x13 * x339 + x143 + x317 * x338
    x779 = -x13 * x343 + x145 + x317 * x342
    x780 = x3 * x779 + x67 * (x3 * x778 - x68 * x773) - x68 * x775
    x781 = x25 * x780
    x782 = -x13 * x349 + x317 * x347 + x94
    x783 = x115 + x317 * x350 - x323 * x372
    x784 = x117 + x317 * x352 - x323 * x373
    x785 = x116 + x317 * x355 - x323 * x375
    x786 = x105 + x317 * x348 - x323 * x380
    x787 = (
        x22 * x360
        + x25 * x777
        + x25 * (x777 + x781)
        + x3 * x782
        - x68 * x786
        + x74
        * (
            x3 * x772
            - x68 * x783
            + x72 * (x3 * x776 + x67 * (x3 * x774 - x68 * x784) - x68 * x785)
        )
    )
    x788 = x26 * x780
    x789 = -x13 * x385 + x166 + x317 * x383 + x67 * x773
    x790 = -x13 * x396 + x203 + x317 * x384 + x67 * x774
    x791 = -x13 * x389 + x164 + x317 * x387 + x67 * x775
    x792 = -x13 * x399 + x202 + x317 * x388 + x67 * x776
    x793 = x3 * x791 + x67 * (x3 * x789 - x68 * x790) - x68 * x792
    x794 = x788 + x793
    x795 = -x13 * x394 + x188 + x317 * x392 + x67 * x772
    x796 = x216 + x317 * x395 - x323 * x412 + x67 * x784
    x797 = x220 + x317 * x398 - x323 * x414 + x67 * x785
    x798 = x224 + x317 * x393 - x323 * x416 + x67 * x783
    x799 = (
        x3 * x795
        - x68 * x798
        + x72 * (x3 * x792 + x67 * (x3 * x790 - x68 * x796) - x68 * x797)
    )
    x800 = x22 * x402 + x25 * x794 + x26 * x777 + x799
    x801 = x22 * x419 + x27 * x777 + x27 * x781
    x802 = -x13 * x424 + x238 + x317 * x422 + x72 * x790
    x803 = x256 + x317 * x423 - x323 * x435 + x72 * x796
    x804 = -x13 * x428 + x236 + x317 * x426 + x72 * x792
    x805 = x260 + x317 * x427 - x323 * x437 + x72 * x797
    x806 = x26 * x793 + x3 * x804 + x67 * (x3 * x802 - x68 * x803) - x68 * x805
    x807 = x22 * x431 + x26 * x794 + x806
    x808 = x27 * x793
    x809 = x22 * x441 + x27 * x788 + x808
    x810 = x22 * x446 + x28 * x780
    x811 = -x13 * x450 + x271 + x317 * x449 + x67 * x778
    x812 = x3 * x811 - x68 * x789
    x813 = x25 * x812
    x814 = x22 * x453 + x25 * x793 + x25 * (x793 + x813) + x799
    x815 = x26 * x812
    x816 = -x13 * x461 + x284 + x317 * x460 + x72 * x789
    x817 = x3 * x816 - x68 * x802
    x818 = x815 + x817
    x819 = x22 * x464 + x25 * x818 + x806
    x820 = x22 * x471 + x27 * x813 + x808
    x821 = -x13 * x476 + x307 + x317 * x474 + x74 * x802
    x822 = x310 + x317 * x475 - x323 * x481 + x74 * x803
    x823 = x22 * x478 + x26 * x817 + x26 * x818 + x3 * x821 - x68 * x822
    x824 = x22 * x483 + x27 * x815 + x27 * x817
    x825 = x22 * x486 + x28 * x812
    x826 = -x13 * x494 + x317 * x491
    x827 = -x13 * x527 + x317 * x493
    x828 = x317 * x497
    x829 = x13 * x501
    x830 = x828 - x829
    x831 = x317 * x500
    x832 = x13 * x531
    x833 = x831 - x832
    x834 = -x13 * x509 + x317 * x505
    x835 = x317 * x508
    x836 = x13 * x536
    x837 = x835 - x836
    x838 = (
        x3 * x826
        - x68 * x827
        + x72 * (x3 * x834 + x67 * (x3 * x830 - x68 * x833) - x68 * x837)
    )
    x839 = -x13 * x515 + x317 * x513
    x840 = -x13 * x519 + x317 * x518
    x841 = x3 * x840 + x67 * (x3 * x839 - x68 * x830) - x68 * x834
    x842 = -x13 * x524 + x317 * x522
    x843 = x317 * x526
    x844 = x323 * x553
    x845 = x843 - x844
    x846 = x317 * x530
    x847 = x323 * x556
    x848 = x846 - x847
    x849 = x317 * x535
    x850 = x323 * x560
    x851 = x849 - x850
    x852 = x317 * x523 - x323 * x566
    x853 = (
        x25 * x838
        + x25 * (x25 * x841 + x838)
        + x3 * x842
        - x68 * x852
        + x74
        * (
            x3 * x827
            - x68 * x845
            + x72 * (x3 * x837 + x67 * (x3 * x833 - x68 * x848) - x68 * x851)
        )
    )
    x854 = x23 * x360 + x853
    x855 = -x13 * x575 + x317 * x571 + x67 * x830
    x856 = x317 * x574
    x857 = x13 * x589
    x858 = x67 * x833 + x856 - x857
    x859 = -x13 * x579 + x317 * x569 + x67 * x834
    x860 = -x13 * x593 + x317 * x578 + x67 * x837
    x861 = x3 * x859 + x67 * (x3 * x855 - x68 * x858) - x68 * x860
    x862 = x26 * x841 + x861
    x863 = -x13 * x585 + x317 * x583 + x67 * x827
    x864 = x317 * x588
    x865 = x323 * x607
    x866 = x67 * x848 + x864 - x865
    x867 = x317 * x592
    x868 = x323 * x611
    x869 = x67 * x851 + x867 - x868
    x870 = x317 * x584 - x323 * x614 + x67 * x845
    x871 = (
        x3 * x863
        - x68 * x870
        + x72 * (x3 * x860 + x67 * (x3 * x858 - x68 * x866) - x68 * x869)
    )
    x872 = x25 * x862 + x26 * x838 + x871
    x873 = x23 * x402 + x872
    x874 = x505 * x67
    x875 = x317 * x874 - x323 * x619
    x876 = -x13 * x633 + x317 * x619
    x877 = x317 * x744 - x323 * x617
    x878 = -x13 * x635 + x317 * x617
    x879 = x3 * x875 + x67 * (x3 * x877 - x68 * x878) - x68 * x876
    x880 = x27 * x841 + x879
    x881 = x493 * x67
    x882 = -x13 * x631 + x317 * x881
    x883 = x67 * x849 - x67 * x850
    x884 = x67 * x846 - x67 * x847
    x885 = x67 * x843 - x67 * x844
    x886 = (
        x3 * x882
        - x68 * x885
        + x72 * (x3 * x876 + x67 * (x3 * x878 - x68 * x884) - x68 * x883)
    )
    x887 = x25 * x880 + x27 * x838 + x886
    x888 = x23 * x419 + x887
    x889 = -x13 * x647 + x317 * x644 + x72 * x858
    x890 = x317 * x646
    x891 = x323 * x659
    x892 = x72 * x866 + x890 - x891
    x893 = -x13 * x651 + x317 * x642 + x72 * x860
    x894 = x317 * x650 - x323 * x662 + x72 * x869
    x895 = x26 * x861 + x3 * x893 + x67 * (x3 * x889 - x68 * x892) - x68 * x894
    x896 = x26 * x862 + x895
    x897 = x23 * x431 + x896
    x898 = -x13 * x672 + x317 * x711 + x67 * x878
    x899 = x67 * x864 - x67 * x865 + x67 * x884
    x900 = x578 * x67
    x901 = -x13 * x670 + x317 * x900 + x67 * x876
    x902 = x67 * x867 - x67 * x868 + x67 * x883
    x903 = x3 * x901 + x67 * (x3 * x898 - x68 * x899) - x68 * x902
    x904 = x27 * x861 + x903
    x905 = x26 * x880 + x904
    x906 = x23 * x441 + x905
    x907 = x680 * x831 - x680 * x832
    x908 = x680 * x846 - x680 * x847
    x909 = x680 * x835 - x680 * x836
    x910 = x680 * x849 - x680 * x850
    x911 = x27 * x879 + x3 * x909 + x67 * (x3 * x907 - x68 * x908) - x68 * x910
    x912 = x27 * x880 + x911
    x913 = x23 * x446 + x912
    x914 = -x13 * x693 + x317 * x692 + x67 * x839
    x915 = x3 * x914 - x68 * x855
    x916 = x25 * x861 + x25 * (x25 * x915 + x861) + x871
    x917 = x23 * x453 + x916
    x918 = -x13 * x702 + x317 * x701 + x72 * x855
    x919 = x3 * x918 - x68 * x889
    x920 = x26 * x915 + x919
    x921 = x25 * x920 + x895
    x922 = x23 * x464 + x921
    x923 = x571 * x67
    x924 = x317 * x923 - x323 * x711 + x67 * x877
    x925 = x3 * x924 - x68 * x898
    x926 = x27 * x915 + x925
    x927 = x25 * x926 + x904
    x928 = x23 * x471 + x927
    x929 = -x13 * x723 + x317 * x721 + x74 * x889
    x930 = x317 * x722 - x323 * x728 + x74 * x892
    x931 = x26 * x919 + x26 * x920 + x3 * x929 - x68 * x930
    x932 = x23 * x478 + x931
    x933 = x644 * x67
    x934 = -x13 * x733 + x317 * x933 + x72 * x898
    x935 = x67 * x890 - x67 * x891 + x72 * x899
    x936 = x3 * x934 - x68 * x935
    x937 = x26 * x926 + x27 * x919 + x936
    x938 = x23 * x483 + x937
    x939 = x67 * x907 + x680 * x856 - x680 * x857
    x940 = x67 * x908 + x680 * x864 - x680 * x865
    x941 = x27 * x925 + x3 * x939 - x68 * x940
    x942 = x27 * x926 + x941
    x943 = x23 * x486 + x942
    x944 = x513 * x67
    x945 = x317 * x944 - x323 * x744
    x946 = x3 * x945 - x68 * x877
    x947 = x25 * x879 + x25 * (x25 * x946 + x879) + x886
    x948 = x22 * x746 + x947
    x949 = x26 * x946 + x925
    x950 = x25 * x949 + x26 * x879 + x903
    x951 = x22 * x751 + x950
    x952 = x680 * x828 - x680 * x829
    x953 = x3 * x952 - x68 * x907
    x954 = x27 * x946 + x953
    x955 = x25 * x954 + x911
    x956 = x22 * x756 + x955
    x957 = x26 * x925 + x26 * x949 + x936
    x958 = x22 * x761 + x957
    x959 = x26 * x954 + x941
    x960 = x22 * x763 + x959
    x961 = x766 * x831 - x766 * x832
    x962 = x766 * x846 - x766 * x847
    x963 = x27 * x953 + x27 * x954 + x3 * x961 - x68 * x962
    x964 = x22 * x769 + x963
    x965 = x128 - x15 * x494 + x489 * x491
    x966 = -x15 * x527 + x489 * x493 + x95
    x967 = x489 * x497
    x968 = x15 * x501
    x969 = x130 + x967 - x968
    x970 = x489 * x500
    x971 = x15 * x531
    x972 = x970 - x971 + x98
    x973 = x129 - x15 * x509 + x489 * x505
    x974 = x489 * x508
    x975 = x15 * x536
    x976 = x97 + x974 - x975
    x977 = (
        x3 * x965
        - x68 * x966
        + x72 * (x3 * x973 + x67 * (x3 * x969 - x68 * x972) - x68 * x976)
    )
    x978 = x143 - x15 * x515 + x489 * x513
    x979 = x145 - x15 * x519 + x489 * x518
    x980 = x3 * x979 + x67 * (x3 * x978 - x68 * x969) - x68 * x973
    x981 = -x15 * x524 + x489 * x522 + x94
    x982 = x489 * x526
    x983 = x495 * x553
    x984 = x115 + x982 - x983
    x985 = x489 * x530
    x986 = x495 * x556
    x987 = x117 + x985 - x986
    x988 = x489 * x535
    x989 = x495 * x560
    x990 = x116 + x988 - x989
    x991 = x105 + x489 * x523 - x495 * x566
    x992 = (
        x23 * x541
        + x25 * x977
        + x25 * (x25 * x980 + x977)
        + x3 * x981
        - x68 * x991
        + x74
        * (
            x3 * x966
            - x68 * x984
            + x72 * (x3 * x976 + x67 * (x3 * x972 - x68 * x987) - x68 * x990)
        )
    )
    x993 = -x15 * x575 + x166 + x489 * x571
    x994 = x489 * x574
    x995 = x15 * x589
    x996 = x203 + x994 - x995
    x997 = -x15 * x579 + x164 + x489 * x569
    x998 = -x15 * x593 + x202 + x489 * x578
    x999 = x3 * x997 + x67 * (x3 * x993 - x68 * x996) - x68 * x998
    x1000 = x26 * x980 + x999
    x1001 = -x15 * x585 + x188 + x489 * x583
    x1002 = x489 * x588
    x1003 = x495 * x607
    x1004 = x1002 - x1003 + x216
    x1005 = x489 * x592
    x1006 = x495 * x611
    x1007 = x1005 - x1006 + x220
    x1008 = x224 + x489 * x584 - x495 * x614
    x1009 = (
        x1001 * x3
        - x1008 * x68
        + x72 * (-x1007 * x68 + x3 * x998 + x67 * (-x1004 * x68 + x3 * x996))
    )
    x1010 = x1000 * x25 + x1009 + x23 * x597 + x26 * x977
    x1011 = x489 * x744 - x495 * x617 + x67 * x969
    x1012 = -x15 * x635 + x489 * x617 + x67 * x972
    x1013 = x489 * x874 - x495 * x619 + x67 * x973
    x1014 = -x15 * x633 + x489 * x619 + x67 * x976
    x1015 = x1013 * x3 - x1014 * x68 + x67 * (x1011 * x3 - x1012 * x68)
    x1016 = x1015 + x27 * x980
    x1017 = -x15 * x631 + x489 * x881 + x67 * x966
    x1018 = x67 * x985 - x67 * x986 + x67 * x987
    x1019 = x67 * x988 - x67 * x989 + x67 * x990
    x1020 = x67 * x982 - x67 * x983 + x67 * x984
    x1021 = (
        x1017 * x3
        - x1020 * x68
        + x72 * (x1014 * x3 - x1019 * x68 + x67 * (x1012 * x3 - x1018 * x68))
    )
    x1022 = x1016 * x25 + x1021 + x23 * x625 + x27 * x977
    x1023 = -x15 * x647 + x238 + x489 * x644
    x1024 = x489 * x646
    x1025 = x495 * x659
    x1026 = x1024 - x1025 + x256
    x1027 = -x15 * x651 + x236 + x489 * x642
    x1028 = x260 + x489 * x650 - x495 * x662
    x1029 = x1027 * x3 - x1028 * x68 + x26 * x999 + x67 * (x1023 * x3 - x1026 * x68)
    x1030 = x1000 * x26 + x1029 + x23 * x654
    x1031 = -x15 * x672 + x489 * x711 + x67 * x996
    x1032 = x1002 * x67 - x1003 * x67 + x1004 * x67
    x1033 = -x15 * x670 + x489 * x900 + x67 * x998
    x1034 = x1005 * x67 - x1006 * x67 + x1007 * x67
    x1035 = x1033 * x3 - x1034 * x68 + x67 * (x1031 * x3 - x1032 * x68)
    x1036 = x1035 + x27 * x999
    x1037 = x1016 * x26 + x1036 + x23 * x668
    x1038 = x1012 * x72 + x680 * x970 - x680 * x971
    x1039 = x1018 * x72 + x680 * x985 - x680 * x986
    x1040 = x1014 * x72 + x680 * x974 - x680 * x975
    x1041 = x1019 * x72 + x680 * x988 - x680 * x989
    x1042 = x1015 * x27 + x1040 * x3 - x1041 * x68 + x67 * (x1038 * x3 - x1039 * x68)
    x1043 = x1016 * x27 + x1042 + x23 * x684
    x1044 = -x15 * x693 + x271 + x489 * x692
    x1045 = x1044 * x3 - x68 * x993
    x1046 = x1009 + x23 * x695 + x25 * x999 + x25 * (x1045 * x25 + x999)
    x1047 = -x15 * x702 + x284 + x489 * x701
    x1048 = -x1023 * x68 + x1047 * x3
    x1049 = x1045 * x26 + x1048
    x1050 = x1029 + x1049 * x25 + x23 * x705
    x1051 = x489 * x923 - x495 * x711 + x67 * x993
    x1052 = -x1031 * x68 + x1051 * x3
    x1053 = x1045 * x27 + x1052
    x1054 = x1036 + x1053 * x25 + x23 * x714
    x1055 = -x15 * x723 + x307 + x489 * x721
    x1056 = x310 + x489 * x722 - x495 * x728
    x1057 = x1048 * x26 + x1049 * x26 + x1055 * x3 - x1056 * x68 + x23 * x725
    x1058 = x1023 * x67 - x15 * x733 + x489 * x933
    x1059 = x1024 * x67 - x1025 * x67 + x1026 * x67
    x1060 = x1058 * x3 - x1059 * x68
    x1061 = x1048 * x27 + x1053 * x26 + x1060 + x23 * x731
    x1062 = x1031 * x72 + x680 * x994 - x680 * x995
    x1063 = x1002 * x680 - x1003 * x680 + x1032 * x72
    x1064 = x1052 * x27 + x1062 * x3 - x1063 * x68
    x1065 = x1053 * x27 + x1064 + x23 * x739
    x1066 = x23 * x746
    x1067 = x489 * x944 - x495 * x744 + x67 * x978
    x1068 = -x1011 * x68 + x1067 * x3
    x1069 = x1015 * x25 + x1021 + x25 * (x1015 + x1068 * x25)
    x1070 = x23 * x751
    x1071 = x1052 + x1068 * x26
    x1072 = x1015 * x26 + x1035 + x1071 * x25
    x1073 = x23 * x756
    x1074 = x1011 * x72 + x680 * x967 - x680 * x968
    x1075 = -x1038 * x68 + x1074 * x3
    x1076 = x1068 * x27 + x1075
    x1077 = x1042 + x1076 * x25
    x1078 = x23 * x761
    x1079 = x1052 * x26 + x1060 + x1071 * x26
    x1080 = x23 * x763
    x1081 = x1064 + x1076 * x26
    x1082 = x23 * x769
    x1083 = x1038 * x74 + x766 * x970 - x766 * x971
    x1084 = x1039 * x74 + x766 * x985 - x766 * x986
    x1085 = x1075 * x27 + x1076 * x27 + x1083 * x3 - x1084 * x68
    x1086 = x25 * x342
    x1087 = x25 * x319 + x25 * (x1086 + x319) + x347
    x1088 = x26 * x342
    x1089 = x1088 + x387
    x1090 = x1089 * x25 + x26 * x319 + x392
    x1091 = x1086 * x27 + x27 * x319
    x1092 = x26 * x387 + x426
    x1093 = x1089 * x26 + x1092
    x1094 = x27 * x387
    x1095 = x1088 * x27 + x1094
    x1096 = x25 * x449
    x1097 = x25 * x387 + x25 * (x1096 + x387) + x392
    x1098 = x26 * x449
    x1099 = x1098 + x460
    x1100 = x1092 + x1099 * x25
    x1101 = x1094 + x1096 * x27
    x1102 = x1099 * x26 + x26 * x460 + x474
    x1103 = x1098 * x27 + x27 * x460
    x1104 = x25 * x779
    x1105 = x25 * x771 + x25 * (x1104 + x771) + x782
    x1106 = x1087 * x22 + x1105
    x1107 = x26 * x779
    x1108 = x1107 + x791
    x1109 = x1108 * x25 + x26 * x771 + x795
    x1110 = x1090 * x22 + x1109
    x1111 = x1104 * x27 + x27 * x771
    x1112 = x1091 * x22 + x1111
    x1113 = x26 * x791 + x804
    x1114 = x1108 * x26 + x1113
    x1115 = x1093 * x22 + x1114
    x1116 = x27 * x791
    x1117 = x1107 * x27 + x1116
    x1118 = x1095 * x22 + x1117
    x1119 = x28 * x779
    x1120 = x1119 + x342 * x445
    x1121 = x25 * x811
    x1122 = x25 * x791 + x25 * (x1121 + x791) + x795
    x1123 = x1097 * x22 + x1122
    x1124 = x26 * x811
    x1125 = x1124 + x816
    x1126 = x1113 + x1125 * x25
    x1127 = x1100 * x22 + x1126
    x1128 = x1116 + x1121 * x27
    x1129 = x1101 * x22 + x1128
    x1130 = x1125 * x26 + x26 * x816 + x821
    x1131 = x1102 * x22 + x1130
    x1132 = x1124 * x27 + x27 * x816
    x1133 = x1103 * x22 + x1132
    x1134 = x28 * x811
    x1135 = x1134 + x445 * x449
    x1136 = x25 * x826 + x25 * (x25 * x840 + x826) + x842
    x1137 = x1087 * x23 + x1136
    x1138 = x26 * x840 + x859
    x1139 = x1138 * x25 + x26 * x826 + x863
    x1140 = x1090 * x23 + x1139
    x1141 = x27 * x840 + x875
    x1142 = x1141 * x25 + x27 * x826 + x882
    x1143 = x1091 * x23 + x1142
    x1144 = x26 * x859 + x893
    x1145 = x1138 * x26 + x1144
    x1146 = x1093 * x23 + x1145
    x1147 = x27 * x859 + x901
    x1148 = x1141 * x26 + x1147
    x1149 = x1095 * x23 + x1148
    x1150 = x27 * x875 + x909
    x1151 = x1141 * x27 + x1150
    x1152 = x1151 + x342 * x678
    x1153 = x25 * x859 + x25 * (x25 * x914 + x859) + x863
    x1154 = x1097 * x23 + x1153
    x1155 = x26 * x914 + x918
    x1156 = x1144 + x1155 * x25
    x1157 = x1100 * x23 + x1156
    x1158 = x27 * x914 + x924
    x1159 = x1147 + x1158 * x25
    x1160 = x1101 * x23 + x1159
    x1161 = x1155 * x26 + x26 * x918 + x929
    x1162 = x1102 * x23 + x1161
    x1163 = x1158 * x26 + x27 * x918 + x934
    x1164 = x1103 * x23 + x1163
    x1165 = x27 * x924 + x939
    x1166 = x1158 * x27 + x1165
    x1167 = x1166 + x449 * x678
    x1168 = x25 * x875 + x25 * (x25 * x945 + x875) + x882
    x1169 = x26 * x945 + x924
    x1170 = x1169 * x25 + x26 * x875 + x901
    x1171 = x27 * x945 + x952
    x1172 = x1150 + x1171 * x25
    x1173 = x1169 * x26 + x26 * x924 + x934
    x1174 = x1165 + x1171 * x26
    x1175 = x1171 * x27 + x27 * x952 + x961
    x1176 = x317 * x771 - x323 * x772 + 2 * x363
    x1177 = x317 * x779 - x323 * x775 + 2 * x367
    x1178 = x1177 * x25
    x1179 = x1177 * x26
    x1180 = (
        x317 * x791
        - x323 * x792
        + 2 * x405
        + x67 * (x317 * x775 - x323 * x776 + 2 * x364)
    )
    x1181 = x1179 + x1180
    x1182 = (
        x317 * x795
        - x323 * x798
        + 2 * x409
        + x67 * (x317 * x772 - x323 * x783 + 2 * x371)
    )
    x1183 = (
        x1180 * x26
        + x317 * x804
        - x323 * x805
        + 2 * x433
        + x72
        * (
            x317 * x792
            - x323 * x797
            + 2 * x410
            + x67 * (x317 * x776 - x323 * x785 + 2 * x378)
        )
    )
    x1184 = x1180 * x27
    x1185 = (
        x317 * x811
        - x323 * x789
        + 2 * x455
        + x67 * (x317 * x778 - x323 * x773 + 2 * x368)
    )
    x1186 = x1185 * x25
    x1187 = x1185 * x26
    x1188 = (
        x317 * x816
        - x323 * x802
        + 2 * x467
        + x72
        * (
            x317 * x789
            - x323 * x790
            + 2 * x406
            + x67 * (x317 * x773 - x323 * x774 + 2 * x365)
        )
    )
    x1189 = x1187 + x1188
    x1190 = x317 * x826 - x323 * x827 + x544
    x1191 = x317 * x840 - x323 * x834 + x548
    x1192 = x1190 * x25 + x25 * (x1190 + x1191 * x25) + x317 * x842 - x323 * x852 + x543
    x1193 = x317 * x859 - x323 * x860 + x599 + x67 * (x317 * x834 - x323 * x837 + x545)
    x1194 = x1191 * x26 + x1193
    x1195 = x317 * x863 - x323 * x870 + x603 + x67 * (x317 * x827 - x323 * x845 + x551)
    x1196 = x1190 * x26 + x1194 * x25 + x1195
    x1197 = x317 * x875 - x323 * x876 + x627
    x1198 = x1191 * x27 + x1197
    x1199 = x317 * x882 - x323 * x885 + x632
    x1200 = x1190 * x27 + x1198 * x25 + x1199
    x1201 = (
        x1193 * x26
        + x317 * x893
        - x323 * x894
        + x656
        + x72
        * (x317 * x860 - x323 * x869 + x604 + x67 * (x317 * x837 - x323 * x851 + x564))
    )
    x1202 = x1194 * x26 + x1201
    x1203 = x317 * x901 - x323 * x902 + x67 * (x317 * x876 - x323 * x883 + x634) + x671
    x1204 = x1193 * x27 + x1203
    x1205 = x1198 * x26 + x1204
    x1206 = x1197 * x27 + x317 * x909 - x323 * x910 + x686
    x1207 = x1198 * x27 + x1206
    x1208 = x317 * x914 - x323 * x855 + x67 * (x317 * x839 - x323 * x830 + x549) + x697
    x1209 = x1193 * x25 + x1195 + x25 * (x1193 + x1208 * x25)
    x1210 = (
        x317 * x918
        - x323 * x889
        + x707
        + x72
        * (x317 * x855 - x323 * x858 + x600 + x67 * (x317 * x830 - x323 * x833 + x546))
    )
    x1211 = x1208 * x26 + x1210
    x1212 = x1201 + x1211 * x25
    x1213 = x317 * x924 - x323 * x898 + x67 * (x317 * x877 - x323 * x878 + x628) + x716
    x1214 = x1208 * x27 + x1213
    x1215 = x1204 + x1214 * x25
    x1216 = (
        x1210 * x26
        + x1211 * x26
        + x317 * x929
        - x323 * x930
        + x727
        + x74
        * (
            x317 * x889
            - x323 * x892
            + x657
            + x72
            * (
                x317 * x858
                - x323 * x866
                + x605
                + x67 * (x317 * x833 - x323 * x848 + x565)
            )
        )
    )
    x1217 = (
        x317 * x934
        - x323 * x935
        + x72
        * (x317 * x898 - x323 * x899 + x67 * (x317 * x878 - x323 * x884 + x636) + x673)
        + x734
    )
    x1218 = x1210 * x27 + x1214 * x26 + x1217
    x1219 = (
        x1213 * x27
        + x317 * x939
        - x323 * x940
        + x67 * (x317 * x907 - x323 * x908 + x687)
        + x741
    )
    x1220 = x1214 * x27 + x1219
    x1221 = x317 * x945 - x323 * x877 + x747
    x1222 = x1168 * x22 + x1197 * x25 + x1199 + x25 * (x1197 + x1221 * x25)
    x1223 = x1213 + x1221 * x26
    x1224 = x1170 * x22 + x1197 * x26 + x1203 + x1223 * x25
    x1225 = x317 * x952 - x323 * x907 + x757
    x1226 = x1221 * x27 + x1225
    x1227 = x1172 * x22 + x1206 + x1226 * x25
    x1228 = x1173 * x22 + x1213 * x26 + x1217 + x1223 * x26
    x1229 = x1174 * x22 + x1219 + x1226 * x26
    x1230 = x1175 * x22 + x1225 * x27 + x1226 * x27 + x317 * x961 - x323 * x962 + x767
    x1231 = x317 * x965 - x323 * x966
    x1232 = x317 * x979 - x323 * x973
    x1233 = (
        x1136 * x23
        + x1231 * x25
        + x25 * (x1231 + x1232 * x25)
        + x317 * x981
        - x323 * x991
    )
    x1234 = x317 * x997 - x323 * x998 + x67 * (x317 * x973 - x323 * x976)
    x1235 = x1232 * x26 + x1234
    x1236 = x1001 * x317 - x1008 * x323 + x67 * (x317 * x966 - x323 * x984)
    x1237 = x1139 * x23 + x1231 * x26 + x1235 * x25 + x1236
    x1238 = x1013 * x317 - x1014 * x323
    x1239 = x1232 * x27 + x1238
    x1240 = x1017 * x317 - x1020 * x323
    x1241 = x1142 * x23 + x1231 * x27 + x1239 * x25 + x1240
    x1242 = (
        x1027 * x317
        - x1028 * x323
        + x1234 * x26
        + x72 * (-x1007 * x323 + x317 * x998 + x67 * (x317 * x976 - x323 * x990))
    )
    x1243 = x1145 * x23 + x1235 * x26 + x1242
    x1244 = x1033 * x317 - x1034 * x323 + x67 * (x1014 * x317 - x1019 * x323)
    x1245 = x1234 * x27 + x1244
    x1246 = x1148 * x23 + x1239 * x26 + x1245
    x1247 = x1040 * x317 - x1041 * x323 + x1238 * x27
    x1248 = x1151 * x23 + x1239 * x27 + x1247
    x1249 = x1044 * x317 - x323 * x993 + x67 * (x317 * x978 - x323 * x969)
    x1250 = x1153 * x23 + x1234 * x25 + x1236 + x25 * (x1234 + x1249 * x25)
    x1251 = (
        -x1023 * x323
        + x1047 * x317
        + x72 * (x317 * x993 - x323 * x996 + x67 * (x317 * x969 - x323 * x972))
    )
    x1252 = x1249 * x26 + x1251
    x1253 = x1156 * x23 + x1242 + x1252 * x25
    x1254 = -x1031 * x323 + x1051 * x317 + x67 * (x1011 * x317 - x1012 * x323)
    x1255 = x1249 * x27 + x1254
    x1256 = x1159 * x23 + x1245 + x1255 * x25
    x1257 = (
        x1055 * x317
        - x1056 * x323
        + x1161 * x23
        + x1251 * x26
        + x1252 * x26
        + x74
        * (
            x1023 * x317
            - x1026 * x323
            + x72 * (-x1004 * x323 + x317 * x996 + x67 * (x317 * x972 - x323 * x987))
        )
    )
    x1258 = (
        x1058 * x317
        - x1059 * x323
        + x72 * (x1031 * x317 - x1032 * x323 + x67 * (x1012 * x317 - x1018 * x323))
    )
    x1259 = x1163 * x23 + x1251 * x27 + x1255 * x26 + x1258
    x1260 = (
        x1062 * x317 - x1063 * x323 + x1254 * x27 + x67 * (x1038 * x317 - x1039 * x323)
    )
    x1261 = x1166 * x23 + x1255 * x27 + x1260
    x1262 = x1168 * x23
    x1263 = -x1011 * x323 + x1067 * x317
    x1264 = x1238 * x25 + x1240 + x25 * (x1238 + x1263 * x25)
    x1265 = x1170 * x23
    x1266 = x1254 + x1263 * x26
    x1267 = x1238 * x26 + x1244 + x1266 * x25
    x1268 = x1172 * x23
    x1269 = -x1038 * x323 + x1074 * x317
    x1270 = x1263 * x27 + x1269
    x1271 = x1247 + x1270 * x25
    x1272 = x1173 * x23
    x1273 = x1254 * x26 + x1258 + x1266 * x26
    x1274 = x1174 * x23
    x1275 = x1260 + x1270 * x26
    x1276 = x1175 * x23
    x1277 = x1083 * x317 - x1084 * x323 + x1269 * x27 + x1270 * x27
    x1278 = x25 * x491 + x25 * (x25 * x518 + x491) + x522
    x1279 = x26 * x518 + x569
    x1280 = x1279 * x25 + x26 * x491 + x583
    x1281 = x27 * x518 + x874
    x1282 = x1281 * x25 + x27 * x491 + x881
    x1283 = x26 * x569 + x642
    x1284 = x1279 * x26 + x1283
    x1285 = x27 * x569 + x900
    x1286 = x1281 * x26 + x1285
    x1287 = x27 * x874 + x508 * x680
    x1288 = x1281 * x27 + x1287
    x1289 = x25 * x569 + x25 * (x25 * x692 + x569) + x583
    x1290 = x26 * x692 + x701
    x1291 = x1283 + x1290 * x25
    x1292 = x27 * x692 + x923
    x1293 = x1285 + x1292 * x25
    x1294 = x1290 * x26 + x26 * x701 + x721
    x1295 = x1292 * x26 + x27 * x701 + x933
    x1296 = x27 * x923 + x574 * x680
    x1297 = x1292 * x27 + x1296
    x1298 = x25 * x874 + x25 * (x25 * x944 + x874) + x881
    x1299 = x26 * x944 + x923
    x1300 = x1299 * x25 + x26 * x874 + x900
    x1301 = x497 * x680
    x1302 = x1301 + x27 * x944
    x1303 = x1287 + x1302 * x25
    x1304 = x1299 * x26 + x26 * x923 + x933
    x1305 = x1296 + x1302 * x26
    x1306 = x1301 * x27 + x1302 * x27 + x500 * x766
    x1307 = x1136 + x1278 * x22
    x1308 = x1139 + x1280 * x22
    x1309 = x1142 + x1282 * x22
    x1310 = x1145 + x1284 * x22
    x1311 = x1148 + x1286 * x22
    x1312 = x1151 + x1288 * x22
    x1313 = x1153 + x1289 * x22
    x1314 = x1156 + x1291 * x22
    x1315 = x1159 + x1293 * x22
    x1316 = x1161 + x1294 * x22
    x1317 = x1163 + x1295 * x22
    x1318 = x1166 + x1297 * x22
    x1319 = x1168 + x1298 * x22
    x1320 = x1170 + x1300 * x22
    x1321 = x1172 + x1303 * x22
    x1322 = x1173 + x1304 * x22
    x1323 = x1174 + x1305 * x22
    x1324 = x1175 + x1306 * x22
    x1325 = x25 * x965 + x25 * (x25 * x979 + x965) + x981
    x1326 = x1278 * x23 + x1325
    x1327 = x26 * x979 + x997
    x1328 = x1001 + x1327 * x25 + x26 * x965
    x1329 = x1280 * x23 + x1328
    x1330 = x1013 + x27 * x979
    x1331 = x1017 + x1330 * x25 + x27 * x965
    x1332 = x1282 * x23 + x1331
    x1333 = x1027 + x26 * x997
    x1334 = x1327 * x26 + x1333
    x1335 = x1284 * x23 + x1334
    x1336 = x1033 + x27 * x997
    x1337 = x1330 * x26 + x1336
    x1338 = x1286 * x23 + x1337
    x1339 = x1013 * x27 + x1040
    x1340 = x1330 * x27 + x1339
    x1341 = x1288 * x23 + x1340
    x1342 = x1001 + x25 * x997 + x25 * (x1044 * x25 + x997)
    x1343 = x1289 * x23 + x1342
    x1344 = x1044 * x26 + x1047
    x1345 = x1333 + x1344 * x25
    x1346 = x1291 * x23 + x1345
    x1347 = x1044 * x27 + x1051
    x1348 = x1336 + x1347 * x25
    x1349 = x1293 * x23 + x1348
    x1350 = x1047 * x26 + x1055 + x1344 * x26
    x1351 = x1294 * x23 + x1350
    x1352 = x1047 * x27 + x1058 + x1347 * x26
    x1353 = x1295 * x23 + x1352
    x1354 = x1051 * x27 + x1062
    x1355 = x1347 * x27 + x1354
    x1356 = x1297 * x23 + x1355
    x1357 = x1013 * x25 + x1017 + x25 * (x1013 + x1067 * x25)
    x1358 = x1298 * x23 + x1357
    x1359 = x1051 + x1067 * x26
    x1360 = x1013 * x26 + x1033 + x1359 * x25
    x1361 = x1300 * x23 + x1360
    x1362 = x1067 * x27 + x1074
    x1363 = x1339 + x1362 * x25
    x1364 = x1303 * x23 + x1363
    x1365 = x1051 * x26 + x1058 + x1359 * x26
    x1366 = x1304 * x23 + x1365
    x1367 = x1354 + x1362 * x26
    x1368 = x1305 * x23 + x1367
    x1369 = x1074 * x27 + x1083 + x1362 * x27
    x1370 = x1306 * x23 + x1369
    x1371 = x489 * x965 - x495 * x966 + 2 * x544
    x1372 = x489 * x979 - x495 * x973 + 2 * x548
    x1373 = x489 * x997 - x495 * x998 + 2 * x599
    x1374 = x1372 * x26 + x1373
    x1375 = x1001 * x489 - x1008 * x495 + 2 * x603
    x1376 = (
        x1013 * x489
        - x1014 * x495
        + 2 * x627
        + x67 * (x489 * x973 - x495 * x976 + 2 * x545)
    )
    x1377 = x1372 * x27 + x1376
    x1378 = (
        x1017 * x489
        - x1020 * x495
        + 2 * x632
        + x67 * (x489 * x966 - x495 * x984 + 2 * x551)
    )
    x1379 = x1027 * x489 - x1028 * x495 + x1373 * x26 + 2 * x656
    x1380 = (
        x1033 * x489
        - x1034 * x495
        + x67 * (-x1007 * x495 + x489 * x998 + 2 * x604)
        + 2 * x671
    )
    x1381 = x1373 * x27 + x1380
    x1382 = (
        x1040 * x489
        - x1041 * x495
        + x1376 * x27
        + 2 * x686
        + x72
        * (
            x1014 * x489
            - x1019 * x495
            + 2 * x634
            + x67 * (x489 * x976 - x495 * x990 + 2 * x564)
        )
    )
    x1383 = x1044 * x489 - x495 * x993 + 2 * x697
    x1384 = -x1023 * x495 + x1047 * x489 + 2 * x707
    x1385 = x1383 * x26 + x1384
    x1386 = (
        -x1031 * x495
        + x1051 * x489
        + x67 * (x489 * x993 - x495 * x996 + 2 * x600)
        + 2 * x716
    )
    x1387 = x1383 * x27 + x1386
    x1388 = (
        x1058 * x489
        - x1059 * x495
        + x67 * (x1023 * x489 - x1026 * x495 + 2 * x657)
        + 2 * x734
    )
    x1389 = (
        x1062 * x489
        - x1063 * x495
        + x1386 * x27
        + x72
        * (
            x1031 * x489
            - x1032 * x495
            + x67 * (-x1004 * x495 + x489 * x996 + 2 * x605)
            + 2 * x673
        )
        + 2 * x741
    )
    x1390 = (
        -x1011 * x495
        + x1067 * x489
        + x67 * (x489 * x978 - x495 * x969 + 2 * x549)
        + 2 * x747
    )
    x1391 = x1386 + x1390 * x26
    x1392 = (
        -x1038 * x495
        + x1074 * x489
        + x72
        * (
            x1011 * x489
            - x1012 * x495
            + 2 * x628
            + x67 * (x489 * x969 - x495 * x972 + 2 * x546)
        )
        + 2 * x757
    )
    x1393 = x1390 * x27 + x1392

    # 324 item(s)
    S = numpy.array(
        [
            x104 * x3
            + x136 * x25
            + x150 * x21
            + x21 * (x150 + x152 * x21)
            + x25 * (x136 + x148)
            - x68
            * (x105 + x120 * x74 + x3 * x75 - x68 * (-x111 * x68 + x114 * x74 + x3 * x61))
            + x74
            * (
                x103 * x3
                - x120 * x68
                + x72
                * (
                    x102 * x3
                    - x119 * x68
                    + x67
                    * (
                        x100 * x3
                        - x118 * x68
                        + x93 * (2 * x19 * x20 * x24 * x29 * x3 * x34 - x86 - x99)
                    )
                    + x93 * (-x101 + x89)
                )
                + x93 * (x90 - x96)
            )
            + x93 * (-x76 + x91),
            x136 * x26 + x209 * x21 + x21 * (x209 + x21 * x212) + x215 * x25 + x227,
            x136 * x27 + x148 * x27 + x21 * x228 + x21 * (x21 * x229 + x228),
            x21 * x253 + x21 * (x21 * x255 + x253) + x215 * x26 + x262,
            x21 * x264 + x21 * (x21 * x266 + x264) + x213 * x27 + x267,
            x147 * x28 + x21 * x268 + x21 * (x141 * x269 + x268),
            x21 * x277
            + x21 * (x21 * x279 + x277)
            + x214 * x25
            + x227
            + x25 * (x214 + x281),
            x21 * x290 + x21 * (x21 * x293 + x290) + x25 * x296 + x262,
            x21 * x297 + x21 * (x21 * x298 + x297) + x267 + x27 * x281,
            x21 * x312
            + x21 * (x21 * x313 + x312)
            + x26 * x295
            + x26 * x296
            + x3 * x309
            - x68 * (x3 * x305 + x310 - x68 * (x3 * x303 - x311 * x68))
            + x93 * (x299 * x3 - x302 - x306),
            x21 * x314 + x21 * (x21 * x315 + x314) + x27 * x294 + x27 * x295,
            x21 * x316 + x21 * (x269 * x273 + x316) + x28 * x280,
            0,
            0,
            0,
            0,
            0,
            0,
            x150 * x22 + x21 * x361 + x381,
            x209 * x22 + x21 * x403 + x418,
            x21 * x420 + x22 * x228 + x421,
            x21 * x432 + x22 * x253 + x439,
            x21 * x442 + x22 * x264 + x444,
            x21 * x447 + x22 * x268 + x448,
            x21 * x454 + x22 * x277 + x458,
            x21 * x465 + x22 * x290 + x470,
            x21 * x472 + x22 * x297 + x473,
            x21 * x479 + x22 * x312 + x482,
            x21 * x484 + x22 * x314 + x485,
            x21 * x487 + x22 * x316 + x488,
            0,
            0,
            0,
            0,
            0,
            0,
            x150 * x23 + x21 * x542 + x567,
            x209 * x23 + x21 * x598 + x616,
            x21 * x626 + x228 * x23 + x640,
            x21 * x655 + x23 * x253 + x664,
            x21 * x669 + x23 * x264 + x677,
            x21 * x685 + x23 * x268 + x690,
            x21 * x696 + x23 * x277 + x699,
            x21 * x706 + x23 * x290 + x710,
            x21 * x715 + x23 * x297 + x719,
            x21 * x726 + x23 * x312 + x729,
            x21 * x732 + x23 * x314 + x736,
            x21 * x740 + x23 * x316 + x743,
            x749,
            x753,
            x760,
            x762,
            x764,
            x770,
            x22 * x361 + x787,
            x22 * x403 + x800,
            x22 * x420 + x801,
            x22 * x432 + x807,
            x22 * x442 + x809,
            x22 * x447 + x810,
            x22 * x454 + x814,
            x22 * x465 + x819,
            x22 * x472 + x820,
            x22 * x479 + x823,
            x22 * x484 + x824,
            x22 * x487 + x825,
            0,
            0,
            0,
            0,
            0,
            0,
            x22 * x542 + x854,
            x22 * x598 + x873,
            x22 * x626 + x888,
            x22 * x655 + x897,
            x22 * x669 + x906,
            x22 * x685 + x913,
            x22 * x696 + x917,
            x22 * x706 + x922,
            x22 * x715 + x928,
            x22 * x726 + x932,
            x22 * x732 + x938,
            x22 * x740 + x943,
            x948,
            x951,
            x956,
            x958,
            x960,
            x964,
            x23 * x542 + x992,
            x1010 + x23 * x598,
            x1022 + x23 * x626,
            x1030 + x23 * x655,
            x1037 + x23 * x669,
            x1043 + x23 * x685,
            x1046 + x23 * x696,
            x1050 + x23 * x706,
            x1054 + x23 * x715,
            x1057 + x23 * x726,
            x1061 + x23 * x732,
            x1065 + x23 * x740,
            2 * x1066 + x1069,
            2 * x1070 + x1072,
            2 * x1073 + x1077,
            2 * x1078 + x1079,
            2 * x1080 + x1081,
            2 * x1082 + x1085,
            x21 * x360 + x21 * (x1087 * x21 + x360) + x381,
            x21 * x402 + x21 * (x1090 * x21 + x402) + x418,
            x21 * x419 + x21 * (x1091 * x21 + x419) + x421,
            x21 * x431 + x21 * (x1093 * x21 + x431) + x439,
            x21 * x441 + x21 * (x1095 * x21 + x441) + x444,
            x21 * x446 + x21 * (x269 * x342 + x446) + x448,
            x21 * x453 + x21 * (x1097 * x21 + x453) + x458,
            x21 * x464 + x21 * (x1100 * x21 + x464) + x470,
            x21 * x471 + x21 * (x1101 * x21 + x471) + x473,
            x21 * x478 + x21 * (x1102 * x21 + x478) + x482,
            x21 * x483 + x21 * (x1103 * x21 + x483) + x485,
            x21 * x486 + x21 * (x269 * x449 + x486) + x488,
            0,
            0,
            0,
            0,
            0,
            0,
            x1106 * x21 + x787,
            x1110 * x21 + x800,
            x1112 * x21 + x801,
            x1115 * x21 + x807,
            x1118 * x21 + x809,
            x1120 * x21 + x810,
            x1123 * x21 + x814,
            x1127 * x21 + x819,
            x1129 * x21 + x820,
            x1131 * x21 + x823,
            x1133 * x21 + x824,
            x1135 * x21 + x825,
            0,
            0,
            0,
            0,
            0,
            0,
            x1137 * x21 + x854,
            x1140 * x21 + x873,
            x1143 * x21 + x888,
            x1146 * x21 + x897,
            x1149 * x21 + x906,
            x1152 * x21 + x913,
            x1154 * x21 + x917,
            x1157 * x21 + x922,
            x1160 * x21 + x928,
            x1162 * x21 + x932,
            x1164 * x21 + x938,
            x1167 * x21 + x943,
            x1168 * x21 + x947,
            x1170 * x21 + x950,
            x1172 * x21 + x955,
            x1173 * x21 + x957,
            x1174 * x21 + x959,
            x1175 * x21 + x963,
            x1105 * x22
            + x1106 * x22
            + x1176 * x25
            + x25 * (x1176 + x1178)
            + x317 * x782
            - x323 * x786
            + 2 * x362,
            x1109 * x22 + x1110 * x22 + x1176 * x26 + x1181 * x25 + x1182,
            x1111 * x22 + x1112 * x22 + x1176 * x27 + x1178 * x27,
            x1114 * x22 + x1115 * x22 + x1181 * x26 + x1183,
            x1117 * x22 + x1118 * x22 + x1179 * x27 + x1184,
            x1119 * x22 + x1120 * x22 + x1177 * x28,
            x1122 * x22 + x1123 * x22 + x1180 * x25 + x1182 + x25 * (x1180 + x1186),
            x1126 * x22 + x1127 * x22 + x1183 + x1189 * x25,
            x1128 * x22 + x1129 * x22 + x1184 + x1186 * x27,
            x1130 * x22
            + x1131 * x22
            + x1188 * x26
            + x1189 * x26
            + x317 * x821
            - x323 * x822
            + 2 * x480
            + x74
            * (
                x317 * x802
                - x323 * x803
                + 2 * x434
                + x72
                * (
                    x317 * x790
                    - x323 * x796
                    + 2 * x411
                    + x67 * (x317 * x774 - x323 * x784 + 2 * x379)
                )
            ),
            x1132 * x22 + x1133 * x22 + x1187 * x27 + x1188 * x27,
            x1134 * x22 + x1135 * x22 + x1185 * x28,
            0,
            0,
            0,
            0,
            0,
            0,
            x1105 * x23 + x1137 * x22 + x1192,
            x1109 * x23 + x1140 * x22 + x1196,
            x1111 * x23 + x1143 * x22 + x1200,
            x1114 * x23 + x1146 * x22 + x1202,
            x1117 * x23 + x1149 * x22 + x1205,
            x1119 * x23 + x1152 * x22 + x1207,
            x1122 * x23 + x1154 * x22 + x1209,
            x1126 * x23 + x1157 * x22 + x1212,
            x1128 * x23 + x1160 * x22 + x1215,
            x1130 * x23 + x1162 * x22 + x1216,
            x1132 * x23 + x1164 * x22 + x1218,
            x1134 * x23 + x1167 * x22 + x1220,
            x1222,
            x1224,
            x1227,
            x1228,
            x1229,
            x1230,
            x1137 * x23 + x1233,
            x1140 * x23 + x1237,
            x1143 * x23 + x1241,
            x1146 * x23 + x1243,
            x1149 * x23 + x1246,
            x1152 * x23 + x1248,
            x1154 * x23 + x1250,
            x1157 * x23 + x1253,
            x1160 * x23 + x1256,
            x1162 * x23 + x1257,
            x1164 * x23 + x1259,
            x1167 * x23 + x1261,
            2 * x1262 + x1264,
            2 * x1265 + x1267,
            2 * x1268 + x1271,
            2 * x1272 + x1273,
            2 * x1274 + x1275,
            2 * x1276 + x1277,
            x21 * x541 + x21 * (x1278 * x21 + x541) + x567,
            x21 * x597 + x21 * (x1280 * x21 + x597) + x616,
            x21 * x625 + x21 * (x1282 * x21 + x625) + x640,
            x21 * x654 + x21 * (x1284 * x21 + x654) + x664,
            x21 * x668 + x21 * (x1286 * x21 + x668) + x677,
            x21 * x684 + x21 * (x1288 * x21 + x684) + x690,
            x21 * x695 + x21 * (x1289 * x21 + x695) + x699,
            x21 * x705 + x21 * (x1291 * x21 + x705) + x710,
            x21 * x714 + x21 * (x1293 * x21 + x714) + x719,
            x21 * x725 + x21 * (x1294 * x21 + x725) + x729,
            x21 * x731 + x21 * (x1295 * x21 + x731) + x736,
            x21 * x739 + x21 * (x1297 * x21 + x739) + x743,
            x21 * (x1298 * x21 + x746) + x749,
            x21 * (x1300 * x21 + x751) + x753,
            x21 * (x1303 * x21 + x756) + x760,
            x21 * (x1304 * x21 + x761) + x762,
            x21 * (x1305 * x21 + x763) + x764,
            x21 * (x1306 * x21 + x769) + x770,
            x1307 * x21 + x22 * x541 + x853,
            x1308 * x21 + x22 * x597 + x872,
            x1309 * x21 + x22 * x625 + x887,
            x1310 * x21 + x22 * x654 + x896,
            x1311 * x21 + x22 * x668 + x905,
            x1312 * x21 + x22 * x684 + x912,
            x1313 * x21 + x22 * x695 + x916,
            x1314 * x21 + x22 * x705 + x921,
            x1315 * x21 + x22 * x714 + x927,
            x1316 * x21 + x22 * x725 + x931,
            x1317 * x21 + x22 * x731 + x937,
            x1318 * x21 + x22 * x739 + x942,
            x1319 * x21 + x948,
            x1320 * x21 + x951,
            x1321 * x21 + x956,
            x1322 * x21 + x958,
            x1323 * x21 + x960,
            x1324 * x21 + x964,
            x1326 * x21 + x992,
            x1010 + x1329 * x21,
            x1022 + x1332 * x21,
            x1030 + x1335 * x21,
            x1037 + x1338 * x21,
            x1043 + x1341 * x21,
            x1046 + x1343 * x21,
            x1050 + x1346 * x21,
            x1054 + x1349 * x21,
            x1057 + x1351 * x21,
            x1061 + x1353 * x21,
            x1065 + x1356 * x21,
            x1066 + x1069 + x1358 * x21,
            x1070 + x1072 + x1361 * x21,
            x1073 + x1077 + x1364 * x21,
            x1078 + x1079 + x1366 * x21,
            x1080 + x1081 + x1368 * x21,
            x1082 + x1085 + x1370 * x21,
            x1136 * x22 + x1192 + x1307 * x22,
            x1139 * x22 + x1196 + x1308 * x22,
            x1142 * x22 + x1200 + x1309 * x22,
            x1145 * x22 + x1202 + x1310 * x22,
            x1148 * x22 + x1205 + x1311 * x22,
            x1151 * x22 + x1207 + x1312 * x22,
            x1153 * x22 + x1209 + x1313 * x22,
            x1156 * x22 + x1212 + x1314 * x22,
            x1159 * x22 + x1215 + x1315 * x22,
            x1161 * x22 + x1216 + x1316 * x22,
            x1163 * x22 + x1218 + x1317 * x22,
            x1166 * x22 + x1220 + x1318 * x22,
            x1222 + x1319 * x22,
            x1224 + x1320 * x22,
            x1227 + x1321 * x22,
            x1228 + x1322 * x22,
            x1229 + x1323 * x22,
            x1230 + x1324 * x22,
            x1233 + x1326 * x22,
            x1237 + x1329 * x22,
            x1241 + x1332 * x22,
            x1243 + x1335 * x22,
            x1246 + x1338 * x22,
            x1248 + x1341 * x22,
            x1250 + x1343 * x22,
            x1253 + x1346 * x22,
            x1256 + x1349 * x22,
            x1257 + x1351 * x22,
            x1259 + x1353 * x22,
            x1261 + x1356 * x22,
            x1262 + x1264 + x1358 * x22,
            x1265 + x1267 + x1361 * x22,
            x1268 + x1271 + x1364 * x22,
            x1272 + x1273 + x1366 * x22,
            x1274 + x1275 + x1368 * x22,
            x1276 + x1277 + x1370 * x22,
            x1325 * x23
            + x1326 * x23
            + x1371 * x25
            + x25 * (x1371 + x1372 * x25)
            + x489 * x981
            - x495 * x991
            + 2 * x543,
            x1328 * x23 + x1329 * x23 + x1371 * x26 + x1374 * x25 + x1375,
            x1331 * x23 + x1332 * x23 + x1371 * x27 + x1377 * x25 + x1378,
            x1334 * x23 + x1335 * x23 + x1374 * x26 + x1379,
            x1337 * x23 + x1338 * x23 + x1377 * x26 + x1381,
            x1340 * x23 + x1341 * x23 + x1377 * x27 + x1382,
            x1342 * x23 + x1343 * x23 + x1373 * x25 + x1375 + x25 * (x1373 + x1383 * x25),
            x1345 * x23 + x1346 * x23 + x1379 + x1385 * x25,
            x1348 * x23 + x1349 * x23 + x1381 + x1387 * x25,
            x1055 * x489
            - x1056 * x495
            + x1350 * x23
            + x1351 * x23
            + x1384 * x26
            + x1385 * x26
            + 2 * x727,
            x1352 * x23 + x1353 * x23 + x1384 * x27 + x1387 * x26 + x1388,
            x1355 * x23 + x1356 * x23 + x1387 * x27 + x1389,
            x1357 * x23 + x1358 * x23 + x1376 * x25 + x1378 + x25 * (x1376 + x1390 * x25),
            x1360 * x23 + x1361 * x23 + x1376 * x26 + x1380 + x1391 * x25,
            x1363 * x23 + x1364 * x23 + x1382 + x1393 * x25,
            x1365 * x23 + x1366 * x23 + x1386 * x26 + x1388 + x1391 * x26,
            x1367 * x23 + x1368 * x23 + x1389 + x1393 * x26,
            x1083 * x489
            - x1084 * x495
            + x1369 * x23
            + x1370 * x23
            + x1392 * x27
            + x1393 * x27
            + x74
            * (
                x1038 * x489
                - x1039 * x495
                + 2 * x687
                + x72
                * (
                    x1012 * x489
                    - x1018 * x495
                    + 2 * x636
                    + x67 * (x489 * x972 - x495 * x987 + 2 * x565)
                )
            )
            + 2 * x767,
        ]
    )
    return S


def eri_1220(a, A, b, B, c, C, d, D):
    """Cartesian [pd|ds] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = numpy.exp(
        -c * d * x15 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x17 = x9 ** (-1.0)
    x18 = x15 * (c * C[0] + d * D[0])
    x19 = -x18 - x2
    x20 = x15 * (c * C[1] + d * D[1])
    x21 = -x1 * (a * A[1] + b * B[1])
    x22 = -x20 - x21
    x23 = -x1 * (a * A[2] + b * B[2])
    x24 = -x15 * (c * C[2] + d * D[2]) - x23
    x25 = x17 * x8 * (x19**2 + x22**2 + x24**2)
    x26 = boys(1, x25)
    x27 = x0 * x17
    x28 = boys(2, x25)
    x29 = 2 * x10 * x14 * x16 * x6
    x30 = x28 * x29
    x31 = x5 * (2 * x10 * x14 * x16 * x26 * x6 - x27 * x30)
    x32 = x18 - C[0]
    x33 = x26 * x29
    x34 = x19 * x27
    x35 = x30 * x34 + x32 * x33
    x36 = boys(3, x25)
    x37 = x29 * x36
    x38 = x30 * x32 + x34 * x37
    x39 = x31 + x32 * x35 + x34 * x38
    x40 = -2 * x10 * x14 * x16 * x28 * x6
    x41 = x5 * (-x27 * x37 - x40)
    x42 = x29 * boys(4, x25)
    x43 = x32 * x37 + x34 * x42
    x44 = x32 * x38 + x34 * x43 + x41
    x45 = x17 * x7
    x46 = x44 * x45
    x47 = 2 * a + 2 * b
    x48 = x4 + x47
    x49 = x48 ** (-1.0)
    x50 = x19 * x45
    x51 = x3 * x37 - x42 * x50
    x52 = x43 * x45
    x53 = -x19 * x52 + x3 * x38 + x49 * x51
    x54 = 2 * x49
    x55 = -x19 * x46 + x3 * x39 + x53 * x54
    x56 = x45 * x55
    x57 = boys(0, x25)
    x58 = x5 * (2 * x10 * x14 * x16 * x57 * x6 - x27 * x33)
    x59 = x29 * x57
    x60 = x32 * (x32 * x59 + x33 * x34) + x34 * x35 + x58
    x61 = x39 * x45
    x62 = x37 * x50
    x63 = x3 * x30 - x62
    x64 = x38 * x45
    x65 = -x19 * x64 + x3 * x35 + x49 * x63
    x66 = -x19 * x61 + x3 * x60 + x54 * x65
    x67 = x47 ** (-1.0)
    x68 = 2 * x67
    x69 = x67 * (x60 - x61)
    x70 = x67 * (x35 - x64)
    x71 = x67 * (-x37 * x45 - x40)
    x72 = x45 * x51
    x73 = -x19 * x72 + x3 * x63 + x71
    x74 = x45 * x53
    x75 = -x19 * x74 + x3 * x65 + x49 * x73 + x70
    x76 = -x19 * x56 + x3 * x66 + x54 * x75 + x69
    x77 = x67 * (x39 - x46)
    x78 = -2 * x10 * x14 * x16 * x36 * x6
    x79 = x5 * (-x27 * x42 - x78)
    x80 = x29 * boys(5, x25)
    x81 = x32 * x42 + x34 * x80
    x82 = x32 * x43 + x34 * x81 + x79
    x83 = x3 * x42 - x50 * x80
    x84 = x3 * x43 + x49 * x83 - x50 * x81
    x85 = x67 * (x38 - x52)
    x86 = x67 * (-x42 * x45 - x78)
    x87 = x3 * x51 - x50 * x83 + x86
    x88 = x3 * x53 + x49 * x87 - x50 * x84 + x85
    x89 = x20 - C[1]
    x90 = x22 * x27
    x91 = x30 * x89 + x37 * x90
    x92 = x37 * x89 + x42 * x90
    x93 = x45 * x92
    x94 = -x19 * x93 + x3 * x91
    x95 = x30 * x90 + x33 * x89
    x96 = x32 * x95 + x34 * x91
    x97 = x32 * x91 + x34 * x92
    x98 = x45 * x97
    x99 = -x19 * x98 + x3 * x96 + x49 * x94
    x100 = x45 * x99
    x101 = x45 * x91
    x102 = x101 * x19
    x103 = -x102 + x3 * x95
    x104 = x33 * x90 + x59 * x89
    x105 = x104 * x32 + x34 * x95
    x106 = x45 * x96
    x107 = x103 * x49 + x105 * x3 - x106 * x19
    x108 = x45 * x94
    x109 = x67 * (-x101 + x95)
    x110 = x103 * x3 - x108 * x19 + x109
    x111 = x67 * (x91 - x93)
    x112 = x42 * x89 + x80 * x90
    x113 = -x112 * x50 + x3 * x92
    x114 = x111 - x113 * x50 + x3 * x94
    x115 = x67 * (x105 - x106)
    x116 = -x100 * x19 + x107 * x3 + x110 * x49 + x115
    x117 = x67 * (x96 - x98)
    x118 = x112 * x34 + x32 * x92
    x119 = x104 * x89 + x58 + x90 * x95
    x120 = x31 + x89 * x95 + x90 * x91
    x121 = x120 * x45
    x122 = x121 * x19
    x123 = x41 + x89 * x91 + x90 * x92
    x124 = x123 * x45
    x125 = x120 * x3 - x124 * x19
    x126 = x125 * x45
    x127 = x67 * (x119 - x121)
    x128 = x119 * x3 - x122
    x129 = -x126 * x19 + x127 + x128 * x3
    x130 = x67 * (x120 - x124)
    x131 = x112 * x90 + x79 + x89 * x92
    x132 = -x21 - A[1]
    x133 = x22 * x61
    x134 = x132 * x60 - x133
    x135 = x132 * x39 - x22 * x46
    x136 = x135 * x45
    x137 = x22 * x45
    x138 = x137 * x37
    x139 = x132 * x30 - x138
    x140 = x132 * x37 - x137 * x42
    x141 = x140 * x45
    x142 = x139 * x3 - x141 * x19
    x143 = x22 * x64
    x144 = x132 * x35 - x143
    x145 = x132 * x38 - x22 * x52
    x146 = x145 * x45
    x147 = x142 * x49 + x144 * x3 - x146 * x19
    x148 = x134 * x3 - x136 * x19 + x147 * x54
    x149 = x12 * x66 + x148
    x150 = x67 * (x132 * x60 - x133 - x136)
    x151 = x67 * (x132 * x35 - x143 - x146)
    x152 = x67 * (2 * x10 * x132 * x14 * x16 * x28 * x6 - x138 - x141)
    x153 = x132 * x42 - x137 * x80
    x154 = x140 * x3 - x153 * x50
    x155 = x132 * x43 - x137 * x81
    x156 = x145 * x3 + x154 * x49 - x155 * x50
    x157 = x132 * x44 - x137 * x82
    x158 = (
        x148 * x3
        + x150
        - x50 * (x135 * x3 + x156 * x54 - x157 * x50)
        + x54 * (x147 * x3 + x151 - x156 * x50 + x49 * (x142 * x3 + x152 - x154 * x50))
    )
    x159 = -x101 * x22 + x132 * x95 + x139 * x49
    x160 = x132 * x91 + x140 * x49 - x22 * x93
    x161 = x160 * x45
    x162 = x159 * x3 - x161 * x19
    x163 = x105 * x132 - x106 * x22 + x144 * x49
    x164 = x132 * x96 + x145 * x49 - x22 * x98
    x165 = x164 * x45
    x166 = x162 * x49 + x163 * x3 - x165 * x19
    x167 = x107 * x12 + x166
    x168 = x67 * (x163 - x165)
    x169 = x67 * (x159 - x161)
    x170 = -x112 * x137 + x132 * x92 + x153 * x49
    x171 = x160 * x3 - x170 * x50
    x172 = -x118 * x137 + x132 * x97 + x155 * x49
    x173 = (
        x166 * x3
        + x168
        + x49 * (x162 * x3 + x169 - x171 * x50)
        - x50 * (x164 * x3 + x171 * x49 - x172 * x50)
    )
    x174 = x119 * x132 - x121 * x22 + x159 * x54
    x175 = x120 * x132 - x124 * x22 + x160 * x54
    x176 = x175 * x45
    x177 = x174 * x3 - x176 * x19
    x178 = x12 * x128 + x177
    x179 = x67 * (x174 - x176)
    x180 = x123 * x132 - x131 * x137 + x170 * x54
    x181 = x177 * x3 + x179 - x50 * (x175 * x3 - x180 * x50)
    x182 = -x23 - A[2]
    x183 = x24 * x61
    x184 = x182 * x60 - x183
    x185 = x182 * x39 - x24 * x46
    x186 = x185 * x45
    x187 = x24 * x45
    x188 = x187 * x37
    x189 = x182 * x30 - x188
    x190 = x189 * x3
    x191 = x182 * x37 - x187 * x42
    x192 = x191 * x45
    x193 = x19 * x192
    x194 = x190 - x193
    x195 = x24 * x64
    x196 = x182 * x35 - x195
    x197 = x196 * x3
    x198 = x182 * x38 - x24 * x52
    x199 = x198 * x45
    x200 = x19 * x199
    x201 = x194 * x49 + x197 - x200
    x202 = x184 * x3 - x186 * x19 + x201 * x54
    x203 = x13 * x66 + x202
    x204 = x67 * (x182 * x60 - x183 - x186)
    x205 = x67 * (x182 * x35 - x195 - x199)
    x206 = x67 * (2 * x10 * x14 * x16 * x182 * x28 * x6 - x188 - x192)
    x207 = x191 * x3
    x208 = x182 * x42 - x187 * x80
    x209 = x208 * x50
    x210 = x207 - x209
    x211 = x198 * x3
    x212 = x182 * x43 - x187 * x81
    x213 = x212 * x50
    x214 = x210 * x49 + x211 - x213
    x215 = x182 * x44 - x187 * x82
    x216 = (
        x202 * x3
        + x204
        - x50 * (x185 * x3 + x214 * x54 - x215 * x50)
        + x54 * (x201 * x3 + x205 - x214 * x50 + x49 * (x194 * x3 + x206 - x210 * x50))
    )
    x217 = x106 * x24
    x218 = x105 * x182 - x217
    x219 = x101 * x24
    x220 = x182 * x95 - x219
    x221 = x220 * x3
    x222 = x182 * x91 - x24 * x93
    x223 = x222 * x45
    x224 = x19 * x223
    x225 = x221 - x224
    x226 = x182 * x96 - x24 * x98
    x227 = x226 * x45
    x228 = -x19 * x227 + x218 * x3 + x225 * x49
    x229 = x107 * x13 + x228
    x230 = x67 * (x105 * x182 - x217 - x227)
    x231 = x67 * (x182 * x95 - x219 - x223)
    x232 = x222 * x3
    x233 = -x112 * x187 + x182 * x92
    x234 = x233 * x50
    x235 = x232 - x234
    x236 = -x118 * x187 + x182 * x97
    x237 = (
        x228 * x3
        + x230
        + x49 * (x225 * x3 + x231 - x235 * x50)
        - x50 * (x226 * x3 + x235 * x49 - x236 * x50)
    )
    x238 = x199 * x49
    x239 = x67 * (x196 * x49 - x238)
    x240 = x192 * x49
    x241 = x67 * (x189 * x49 - x240)
    x242 = x190 * x49 - x193 * x49
    x243 = x207 * x49 - x209 * x49
    x244 = x197 * x49 - x200 * x49 + x242 * x49
    x245 = (
        x11 * x244
        + x239
        + x244 * x3
        + x49 * (x241 + x242 * x3 - x243 * x50)
        - x50 * (x211 * x49 - x213 * x49 + x243 * x49)
    )
    x246 = x121 * x24
    x247 = x119 * x182 - x246
    x248 = x120 * x182 - x124 * x24
    x249 = x248 * x45
    x250 = -x19 * x249 + x247 * x3
    x251 = x128 * x13 + x250
    x252 = x67 * (x119 * x182 - x246 - x249)
    x253 = x123 * x182 - x131 * x187
    x254 = x250 * x3 + x252 - x50 * (x248 * x3 - x253 * x50)
    x255 = x223 * x49
    x256 = x67 * (x220 * x49 - x255)
    x257 = x221 * x49 - x224 * x49
    x258 = x11 * x257 + x256 + x257 * x3 - x50 * (x232 * x49 - x234 * x49)
    x259 = x48 ** (-2.0)
    x260 = 2 * x259
    x261 = x67 * (2 * x189 * x259 - x192 * x260)
    x262 = x190 * x260 - x193 * x260
    x263 = x11 * x262 + x261 + x262 * x3 - x50 * (x207 * x260 - x209 * x260)
    x264 = x132 * x134 - x136 * x22 + x69
    x265 = x132 * x139 - x141 * x22 + x71
    x266 = x132 * x140 - x137 * x153 + x86
    x267 = x132 * x144 - x146 * x22 + x70
    x268 = x132 * x145 - x137 * x155 + x85
    x269 = x132 * x135 - x137 * x157 + x77
    x270 = (
        x12 * x148
        + x264 * x3
        - x269 * x50
        + x54 * (x267 * x3 - x268 * x50 + x49 * (x265 * x3 - x266 * x50))
    )
    x271 = x109 + x132 * x159 - x161 * x22 + x265 * x49
    x272 = x111 + x132 * x160 - x137 * x170 + x266 * x49
    x273 = x115 + x132 * x163 - x165 * x22 + x267 * x49
    x274 = x117 + x132 * x164 - x137 * x172 + x268 * x49
    x275 = x12 * x166 + x273 * x3 - x274 * x50 + x49 * (x271 * x3 - x272 * x50)
    x276 = x127 + x132 * x174 - x176 * x22 + x271 * x54
    x277 = x130 + x132 * x175 - x137 * x180 + x272 * x54
    x278 = x12 * x177 + x276 * x3 - x277 * x50
    x279 = x132 * x184 - x186 * x22
    x280 = x132 * x189
    x281 = x192 * x22
    x282 = x280 - x281
    x283 = x132 * x191
    x284 = x137 * x208
    x285 = x283 - x284
    x286 = x132 * x196 - x199 * x22
    x287 = x132 * x198
    x288 = x137 * x212
    x289 = x287 - x288
    x290 = x132 * x185 - x137 * x215
    x291 = (
        x279 * x3
        - x290 * x50
        + x54 * (x286 * x3 - x289 * x50 + x49 * (x282 * x3 - x285 * x50))
    )
    x292 = x13 * x148 + x291
    x293 = x132 * x220 - x22 * x223 + x282 * x49
    x294 = x132 * x222
    x295 = x137 * x233
    x296 = x285 * x49 + x294 - x295
    x297 = x132 * x218 - x22 * x227 + x286 * x49
    x298 = x132 * x226 - x137 * x236 + x289 * x49
    x299 = x297 * x3 - x298 * x50 + x49 * (x293 * x3 - x296 * x50)
    x300 = x13 * x166 + x299
    x301 = x189 * x49
    x302 = x132 * x301 - x22 * x240
    x303 = x283 * x49 - x284 * x49
    x304 = x196 * x49
    x305 = x132 * x304 - x22 * x238
    x306 = x287 * x49 - x288 * x49
    x307 = x3 * x305 - x306 * x50 + x49 * (x3 * x302 - x303 * x50)
    x308 = x12 * x244 + x307
    x309 = x132 * x247 - x22 * x249 + x293 * x54
    x310 = x132 * x248 - x137 * x253 + x296 * x54
    x311 = x3 * x309 - x310 * x50
    x312 = x13 * x177 + x311
    x313 = x220 * x49
    x314 = x132 * x313 - x22 * x255 + x302 * x49
    x315 = x294 * x49 - x295 * x49 + x303 * x49
    x316 = x3 * x314 - x315 * x50
    x317 = x12 * x257 + x316
    x318 = x260 * x280 - x260 * x281
    x319 = x260 * x283 - x260 * x284
    x320 = x3 * x318 - x319 * x50
    x321 = x12 * x262 + x320
    x322 = x182 * x184 - x186 * x24 + x69
    x323 = x182 * x189
    x324 = x192 * x24
    x325 = x323 - x324 + x71
    x326 = x182 * x191
    x327 = x187 * x208
    x328 = x326 - x327 + x86
    x329 = x182 * x196 - x199 * x24 + x70
    x330 = x182 * x198
    x331 = x187 * x212
    x332 = x330 - x331 + x85
    x333 = x182 * x185 - x187 * x215 + x77
    x334 = (
        x13 * x202
        + x3 * x322
        - x333 * x50
        + x54 * (x3 * x329 - x332 * x50 + x49 * (x3 * x325 - x328 * x50))
    )
    x335 = x109 + x182 * x220 - x223 * x24
    x336 = x182 * x222
    x337 = x187 * x233
    x338 = x111 + x336 - x337
    x339 = x115 + x182 * x218 - x227 * x24
    x340 = x117 + x182 * x226 - x187 * x236
    x341 = x13 * x228 + x3 * x339 - x340 * x50 + x49 * (x3 * x335 - x338 * x50)
    x342 = x13 * x244
    x343 = x182 * x301 - x24 * x240 + x325 * x49
    x344 = x326 * x49 - x327 * x49 + x328 * x49
    x345 = x182 * x304 - x238 * x24 + x329 * x49
    x346 = x330 * x49 - x331 * x49 + x332 * x49
    x347 = x3 * x345 - x346 * x50 + x49 * (x3 * x343 - x344 * x50)
    x348 = x127 + x182 * x247 - x24 * x249
    x349 = x130 + x182 * x248 - x187 * x253
    x350 = x13 * x250 + x3 * x348 - x349 * x50
    x351 = x13 * x257
    x352 = x182 * x313 - x24 * x255 + x335 * x49
    x353 = x336 * x49 - x337 * x49 + x338 * x49
    x354 = x3 * x352 - x353 * x50
    x355 = x13 * x262
    x356 = x260 * x323 - x260 * x324 + x343 * x54
    x357 = x260 * x326 - x260 * x327 + x344 * x54
    x358 = x3 * x356 - x357 * x50
    x359 = x12 * x134 + x264
    x360 = x12 * x163 + x273
    x361 = x12 * x174 + x276
    x362 = x13 * x134 + x279
    x363 = x13 * x163 + x297
    x364 = x13 * x174 + x309
    x365 = x132 * x279 - x137 * x290 + x204
    x366 = x132 * x297 - x137 * x298 + x230 + x49 * (x132 * x286 - x137 * x289 + x205)
    x367 = x12 * x305 + x132 * x305 - x137 * x306 + x239
    x368 = (
        x132 * x309
        - x137 * x310
        + x252
        + x54
        * (x132 * x293 - x137 * x296 + x231 + x49 * (x132 * x282 - x137 * x285 + x206))
    )
    x369 = (
        x12 * x314
        + x132 * x314
        - x137 * x315
        + x256
        + x49 * (x132 * x302 - x137 * x303 + x241)
    )
    x370 = x12 * x318 + x132 * x318 - x137 * x319 + x261
    x371 = x13 * x279 + x132 * x322 - x137 * x333
    x372 = x13 * x297 + x132 * x339 - x137 * x340 + x49 * (x132 * x329 - x137 * x332)
    x373 = x13 * x305
    x374 = x132 * x345 - x137 * x346
    x375 = (
        x13 * x309
        + x132 * x348
        - x137 * x349
        + x54 * (x132 * x335 - x137 * x338 + x49 * (x132 * x325 - x137 * x328))
    )
    x376 = x13 * x314
    x377 = x132 * x352 - x137 * x353 + x49 * (x132 * x343 - x137 * x344)
    x378 = x13 * x318
    x379 = x132 * x356 - x137 * x357
    x380 = x189 * x260
    x381 = x12 * x184 + x279
    x382 = x12 * x218 + x297
    x383 = x12 * x304 + x305
    x384 = x12 * x247 + x309
    x385 = x12 * x313 + x314
    x386 = x12 * x380 + x318
    x387 = x13 * x184 + x322
    x388 = x13 * x218 + x339
    x389 = x13 * x304 + x345
    x390 = x13 * x247 + x348
    x391 = x13 * x313 + x352
    x392 = x13 * x380 + x356

    # 108 item(s)
    S = numpy.array(
        [
            x11 * x76
            + x11 * (x11 * x66 + x76)
            + x3 * x76
            - x50
            * (x3 * x55 - x50 * (x3 * x44 - x50 * x82 + x54 * x84) + x54 * x88 + x77)
            + x54
            * (
                x3 * x75
                + x49
                * (
                    x3 * x73
                    - x50 * x87
                    + x68 * (2 * x10 * x14 * x16 * x28 * x3 * x6 - x62 - x72)
                )
                - x50 * x88
                + x68 * (x65 - x74)
            )
            + x68 * (-x56 + x66),
            x11 * x116
            + x11 * (x107 * x11 + x116)
            + x116 * x3
            + x49 * (x110 * x3 - x114 * x50 + x68 * (-x102 - x108 + x3 * x95))
            - x50
            * (x114 * x49 + x117 + x3 * x99 - x50 * (x113 * x49 - x118 * x50 + x3 * x97))
            + x68 * (-x100 + x107),
            0,
            x11 * x129
            + x11 * (x11 * x128 + x129)
            + x129 * x3
            - x50 * (x125 * x3 + x130 - x50 * (x123 * x3 - x131 * x50))
            + x68 * (x119 * x3 - x122 - x126),
            0,
            0,
            x11 * x149 + x12 * x76 + x158,
            x11 * x167 + x116 * x12 + x173,
            0,
            x11 * x178 + x12 * x129 + x181,
            0,
            0,
            x11 * x203 + x13 * x76 + x216,
            x11 * x229 + x116 * x13 + x237,
            x245,
            x11 * x251 + x129 * x13 + x254,
            x258,
            x263,
            x12 * x149 + x270,
            x12 * x167 + x275,
            0,
            x12 * x178 + x278,
            0,
            0,
            x12 * x203 + x292,
            x12 * x229 + x300,
            x308,
            x12 * x251 + x312,
            x317,
            x321,
            x13 * x203 + x334,
            x13 * x229 + x341,
            2 * x342 + x347,
            x13 * x251 + x350,
            2 * x351 + x354,
            2 * x355 + x358,
            x11 * x148 + x11 * (x11 * x134 + x148) + x158,
            x11 * x166 + x11 * (x11 * x163 + x166) + x173,
            0,
            x11 * x177 + x11 * (x11 * x174 + x177) + x181,
            0,
            0,
            x11 * x359 + x270,
            x11 * x360 + x275,
            0,
            x11 * x361 + x278,
            0,
            0,
            x11 * x362 + x292,
            x11 * x363 + x300,
            x11 * x305 + x307,
            x11 * x364 + x312,
            x11 * x314 + x316,
            x11 * x318 + x320,
            x12 * x264 + x12 * x359 + x132 * x264 - x137 * x269 + 2 * x150,
            x12 * x273
            + x12 * x360
            + x132 * x273
            - x137 * x274
            + 2 * x168
            + x49 * (x132 * x267 - x137 * x268 + 2 * x151),
            0,
            x12 * x276
            + x12 * x361
            + x132 * x276
            - x137 * x277
            + 2 * x179
            + x54
            * (
                x132 * x271
                - x137 * x272
                + 2 * x169
                + x49 * (x132 * x265 - x137 * x266 + 2 * x152)
            ),
            0,
            0,
            x12 * x362 + x13 * x264 + x365,
            x12 * x363 + x13 * x273 + x366,
            x367,
            x12 * x364 + x13 * x276 + x368,
            x369,
            x370,
            x13 * x362 + x371,
            x13 * x363 + x372,
            2 * x373 + x374,
            x13 * x364 + x375,
            2 * x376 + x377,
            2 * x378 + x379,
            x11 * x202 + x11 * (x11 * x184 + x202) + x216,
            x11 * x228 + x11 * (x11 * x218 + x228) + x237,
            x11 * (x11 * x304 + x244) + x245,
            x11 * x250 + x11 * (x11 * x247 + x250) + x254,
            x11 * (x11 * x313 + x257) + x258,
            x11 * (x11 * x380 + x262) + x263,
            x11 * x381 + x12 * x202 + x291,
            x11 * x382 + x12 * x228 + x299,
            x11 * x383 + x308,
            x11 * x384 + x12 * x250 + x311,
            x11 * x385 + x317,
            x11 * x386 + x321,
            x11 * x387 + x334,
            x11 * x388 + x341,
            x11 * x389 + x342 + x347,
            x11 * x390 + x350,
            x11 * x391 + x351 + x354,
            x11 * x392 + x355 + x358,
            x12 * x279 + x12 * x381 + x365,
            x12 * x297 + x12 * x382 + x366,
            x12 * x383 + x367,
            x12 * x309 + x12 * x384 + x368,
            x12 * x385 + x369,
            x12 * x386 + x370,
            x12 * x387 + x371,
            x12 * x388 + x372,
            x12 * x389 + x373 + x374,
            x12 * x390 + x375,
            x12 * x391 + x376 + x377,
            x12 * x392 + x378 + x379,
            x13 * x322 + x13 * x387 + x182 * x322 - x187 * x333 + 2 * x204,
            x13 * x339 + x13 * x388 + x182 * x339 - x187 * x340 + 2 * x230,
            x13 * x345
            + x13 * x389
            + x182 * x345
            - x187 * x346
            + 2 * x239
            + x49 * (x182 * x329 - x187 * x332 + 2 * x205),
            x13 * x348 + x13 * x390 + x182 * x348 - x187 * x349 + 2 * x252,
            x13 * x352
            + x13 * x391
            + x182 * x352
            - x187 * x353
            + 2 * x256
            + x49 * (x182 * x335 - x187 * x338 + 2 * x231),
            x13 * x356
            + x13 * x392
            + x182 * x356
            - x187 * x357
            + 2 * x261
            + x54
            * (
                x182 * x343
                - x187 * x344
                + 2 * x241
                + x49 * (x182 * x325 - x187 * x328 + 2 * x206)
            ),
        ]
    )
    return S


def eri_1221(a, A, b, B, c, C, d, D):
    """Cartesian [pd|dp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = c + d
    x5 = x4 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x6 - C[0]
    x8 = x0 + x4
    x9 = x8 ** (-1.0)
    x10 = -x2 - x6
    x11 = x5 * (c * C[1] + d * D[1])
    x12 = -x1 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x1 * (a * A[2] + b * B[2])
    x15 = -x14 - x5 * (c * C[2] + d * D[2])
    x16 = x0 * x4
    x17 = x16 * x9 * (x10**2 + x13**2 + x15**2)
    x18 = boys(2, x17)
    x19 = numpy.pi**2.5
    x20 = (x16 + numpy.sqrt(x8)) ** (-1.0)
    x21 = A[0] - B[0]
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x1 * (x21**2 + x22**2 + x23**2))
    x25 = C[0] - D[0]
    x26 = C[1] - D[1]
    x27 = C[2] - D[2]
    x28 = numpy.exp(-c * d * x5 * (x25**2 + x26**2 + x27**2))
    x29 = 2 * x19 * x20 * x24 * x28
    x30 = x18 * x29
    x31 = x0 * x9
    x32 = x10 * x31
    x33 = boys(3, x17)
    x34 = x29 * x33
    x35 = x30 * x7 + x32 * x34
    x36 = x31 * x35
    x37 = boys(1, x17)
    x38 = x29 * x37
    x39 = x30 * x32 + x38 * x7
    x40 = 2 * c + 2 * d
    x41 = x40 ** (-1.0)
    x42 = 2 * x41
    x43 = x41 * (2 * x19 * x20 * x24 * x28 * x37 - x30 * x31)
    x44 = x10 * x36 + x39 * x7 + x43
    x45 = -2 * x18 * x19 * x20 * x24 * x28
    x46 = x41 * (-x31 * x34 - x45)
    x47 = boys(4, x17)
    x48 = x29 * x47
    x49 = x32 * x48 + x34 * x7
    x50 = x31 * x49
    x51 = x10 * x50 + x35 * x7 + x46
    x52 = x32 * x51 + x42 * (-x36 + x39) + x44 * x7
    x53 = -2 * x19 * x20 * x24 * x28 * x33
    x54 = x41 * (-x31 * x48 - x53)
    x55 = x29 * boys(5, x17)
    x56 = x32 * x55 + x48 * x7
    x57 = x31 * x56
    x58 = x10 * x57 + x49 * x7 + x54
    x59 = x32 * x58 + x42 * (x35 - x50) + x51 * x7
    x60 = x4 * x9
    x61 = x59 * x60
    x62 = x58 * x60
    x63 = 2 * a + 2 * b
    x64 = x40 + x63
    x65 = x64 ** (-1.0)
    x66 = x10 * x60
    x67 = x3 * x48 - x55 * x66
    x68 = x56 * x60
    x69 = -x10 * x68 + x3 * x49 + x65 * x67
    x70 = 2 * x65
    x71 = -x10 * x62 + x3 * x51 + x69 * x70
    x72 = 3 * x65
    x73 = -x10 * x61 + x3 * x52 + x71 * x72
    x74 = x60 * x73
    x75 = x31 * x39
    x76 = boys(0, x17)
    x77 = x29 * x76
    x78 = x32 * x38 + x7 * x77
    x79 = x41 * (2 * x19 * x20 * x24 * x28 * x76 - x31 * x38)
    x80 = x10 * x75 + x7 * x78 + x79
    x81 = x32 * x44 + x42 * (-x75 + x78) + x7 * x80
    x82 = x52 * x60
    x83 = x51 * x60
    x84 = x48 * x66
    x85 = x3 * x34 - x84
    x86 = x49 * x60
    x87 = -x10 * x86 + x3 * x35 + x65 * x85
    x88 = -x10 * x83 + x3 * x44 + x70 * x87
    x89 = -x10 * x82 + x3 * x81 + x72 * x88
    x90 = x63 ** (-1.0)
    x91 = 2 * x90
    x92 = x90 * (x81 - x82)
    x93 = x90 * (x44 - x83)
    x94 = x60 * x71
    x95 = x90 * (x35 - x86)
    x96 = x90 * (-x48 * x60 - x53)
    x97 = x60 * x67
    x98 = -x10 * x97 + x3 * x85 + x96
    x99 = x60 * x69
    x100 = -x10 * x99 + x3 * x87 + x65 * x98 + x95
    x101 = -x10 * x94 + x100 * x70 + x3 * x88 + x93
    x102 = -x10 * x74 + x101 * x72 + x3 * x89 + x92
    x103 = x90 * (x52 - x61)
    x104 = -2 * x19 * x20 * x24 * x28 * x47
    x105 = x41 * (-x104 - x31 * x55)
    x106 = x29 * boys(6, x17)
    x107 = x106 * x32 + x55 * x7
    x108 = x105 + x107 * x32 + x56 * x7
    x109 = x108 * x32 + x42 * (x49 - x57) + x58 * x7
    x110 = -x106 * x66 + x3 * x55
    x111 = -x107 * x66 + x110 * x65 + x3 * x56
    x112 = -x108 * x66 + x111 * x70 + x3 * x58
    x113 = x90 * (x51 - x62)
    x114 = x90 * (x49 - x68)
    x115 = x90 * (-x104 - x55 * x60)
    x116 = -x110 * x66 + x115 + x3 * x67
    x117 = -x111 * x66 + x114 + x116 * x65 + x3 * x69
    x118 = -x112 * x66 + x113 + x117 * x70 + x3 * x71
    x119 = x60 * x88
    x120 = x44 * x60
    x121 = x34 * x66
    x122 = -x121 + x3 * x30
    x123 = x35 * x60
    x124 = -x10 * x123 + x122 * x65 + x3 * x39
    x125 = -x10 * x120 + x124 * x70 + x3 * x80
    x126 = x90 * (-x120 + x80)
    x127 = x90 * (-x123 + x39)
    x128 = x90 * (-x34 * x60 - x45)
    x129 = x60 * x85
    x130 = -x10 * x129 + x122 * x3 + x128
    x131 = x60 * x87
    x132 = -x10 * x131 + x124 * x3 + x127 + x130 * x65
    x133 = -x10 * x119 + x125 * x3 + x126 + x132 * x70
    x134 = (
        -x101 * x66
        + x133 * x3
        + x70
        * (
            -x100 * x66
            + x132 * x3
            + x65
            * (
                x130 * x3
                - x66 * x98
                + x91 * (-x121 - x129 + 2 * x18 * x19 * x20 * x24 * x28 * x3)
            )
            + x91 * (x124 - x131)
        )
        + x91 * (-x119 + x125)
    )
    x135 = x102 + x133 * x25
    x136 = x125 * x25 + x89
    x137 = x11 - C[1]
    x138 = x13 * x31
    x139 = x137 * x30 + x138 * x34
    x140 = x139 * x31
    x141 = x137 * x38 + x138 * x30
    x142 = x41 * (-x140 + x141)
    x143 = x10 * x140 + x141 * x7
    x144 = x137 * x34 + x138 * x48
    x145 = x144 * x31
    x146 = x10 * x145 + x139 * x7
    x147 = x142 + x143 * x7 + x146 * x32
    x148 = x147 * x60
    x149 = x141 * x31
    x150 = x137 * x77 + x138 * x38
    x151 = x41 * (-x149 + x150)
    x152 = x10 * x149 + x150 * x7
    x153 = x143 * x32 + x151 + x152 * x7
    x154 = x90 * (-x148 + x153)
    x155 = x144 * x60
    x156 = x10 * x155
    x157 = x139 * x3 - x156
    x158 = x146 * x60
    x159 = -x10 * x158 + x143 * x3 + x157 * x65
    x160 = -x10 * x148 + x153 * x3 + x159 * x70
    x161 = x41 * (x139 - x145)
    x162 = x137 * x48 + x138 * x55
    x163 = x162 * x31
    x164 = x10 * x163 + x144 * x7
    x165 = x146 * x7 + x161 + x164 * x32
    x166 = x165 * x60
    x167 = x162 * x60
    x168 = -x10 * x167 + x144 * x3
    x169 = x164 * x60
    x170 = -x10 * x169 + x146 * x3 + x168 * x65
    x171 = -x10 * x166 + x147 * x3 + x170 * x70
    x172 = x171 * x60
    x173 = x90 * (x143 - x158)
    x174 = x90 * (x139 - x155)
    x175 = x168 * x60
    x176 = -x10 * x175 + x157 * x3 + x174
    x177 = x170 * x60
    x178 = -x10 * x177 + x159 * x3 + x173 + x176 * x65
    x179 = -x10 * x172 + x154 + x160 * x3 + x178 * x70
    x180 = x133 * x26 + x179
    x181 = x125 * x26 + x160
    x182 = x90 * (x144 - x167)
    x183 = x106 * x138 + x137 * x55
    x184 = x162 * x3 - x183 * x66
    x185 = x168 * x3 + x182 - x184 * x66
    x186 = x90 * (x146 - x169)
    x187 = x162 * x7 + x183 * x32
    x188 = x164 * x3 + x184 * x65 - x187 * x66
    x189 = x170 * x3 + x185 * x65 + x186 - x188 * x66
    x190 = x90 * (x147 - x166)
    x191 = x41 * (x144 - x163)
    x192 = x164 * x7 + x187 * x32 + x191
    x193 = (
        x179 * x3
        - x66
        * (x171 * x3 + x189 * x70 + x190 - x66 * (x165 * x3 + x188 * x70 - x192 * x66))
        + x70
        * (
            x178 * x3
            - x189 * x66
            + x65 * (x176 * x3 - x185 * x66 + x91 * (x139 * x3 - x156 - x175))
            + x91 * (x159 - x177)
        )
        + x91 * (x160 - x172)
    )
    x194 = x133 * x27
    x195 = x21 * x27
    x196 = x143 * x60
    x197 = x90 * (x152 - x196)
    x198 = x139 * x60
    x199 = x90 * (x141 - x198)
    x200 = x10 * x198
    x201 = x141 * x3 - x200
    x202 = x157 * x60
    x203 = -x10 * x202 + x199 + x201 * x3
    x204 = -x10 * x196 + x152 * x3 + x201 * x65
    x205 = x159 * x60
    x206 = -x10 * x205 + x197 + x203 * x65 + x204 * x3
    x207 = x179 + x206 * x25
    x208 = x160 + x204 * x25
    x209 = (
        -x178 * x66
        + x206 * x3
        + x65 * (-x176 * x66 + x203 * x3 + x91 * (x141 * x3 - x200 - x202))
        + x91 * (x204 - x205)
    )
    x210 = x13 * x140 + x137 * x141 + x43
    x211 = x13 * x145 + x137 * x139 + x46
    x212 = x210 * x7 + x211 * x32
    x213 = x212 * x60
    x214 = x13 * x149 + x137 * x150 + x79
    x215 = x210 * x32 + x214 * x7
    x216 = x90 * (-x213 + x215)
    x217 = x211 * x60
    x218 = x90 * (x210 - x217)
    x219 = x10 * x217
    x220 = x210 * x3 - x219
    x221 = x13 * x163 + x137 * x144 + x54
    x222 = x221 * x60
    x223 = -x10 * x222 + x211 * x3
    x224 = x223 * x60
    x225 = -x10 * x224 + x218 + x220 * x3
    x226 = -x10 * x213 + x215 * x3 + x220 * x65
    x227 = x211 * x7 + x221 * x32
    x228 = x227 * x60
    x229 = -x10 * x228 + x212 * x3 + x223 * x65
    x230 = x229 * x60
    x231 = -x10 * x230 + x216 + x225 * x65 + x226 * x3
    x232 = x206 * x26 + x231
    x233 = x204 * x26 + x226
    x234 = x90 * (x211 - x222)
    x235 = x105 + x137 * x162 + x138 * x183
    x236 = x221 * x3 - x235 * x66
    x237 = x223 * x3 + x234 - x236 * x66
    x238 = x90 * (x212 - x228)
    x239 = x221 * x7 + x235 * x32
    x240 = (
        x231 * x3
        + x65 * (x225 * x3 - x237 * x66 + x91 * (x210 * x3 - x219 - x224))
        - x66
        * (x229 * x3 + x237 * x65 + x238 - x66 * (x227 * x3 + x236 * x65 - x239 * x66))
        + x91 * (x226 - x230)
    )
    x241 = x206 * x27
    x242 = x210 * x60
    x243 = x90 * (x214 - x242)
    x244 = x10 * x242
    x245 = x214 * x3 - x244
    x246 = x220 * x60
    x247 = -x10 * x246 + x243 + x245 * x3
    x248 = x231 + x247 * x25
    x249 = x226 + x245 * x25
    x250 = -x225 * x66 + x247 * x3 + x91 * (x214 * x3 - x244 - x246)
    x251 = x137 * x214 + x138 * x210 + 2 * x151
    x252 = x137 * x210 + x138 * x211 + 2 * x142
    x253 = x252 * x60
    x254 = x10 * x253
    x255 = x137 * x211 + x138 * x221 + 2 * x161
    x256 = x255 * x60
    x257 = -x10 * x256 + x252 * x3
    x258 = x257 * x60
    x259 = x90 * (x251 - x253)
    x260 = x251 * x3 - x254
    x261 = -x10 * x258 + x259 + x260 * x3
    x262 = x90 * (x252 - x256)
    x263 = x137 * x221 + x138 * x235 + 2 * x191
    x264 = x247 * x26 + x261
    x265 = x245 * x26 + x260
    x266 = x247 * x27
    x267 = -x12 - A[1]
    x268 = x120 * x13
    x269 = x267 * x80 - x268
    x270 = x13 * x83
    x271 = x267 * x44 - x270
    x272 = x271 * x60
    x273 = x13 * x60
    x274 = x273 * x34
    x275 = x267 * x30 - x274
    x276 = x273 * x48
    x277 = x267 * x34 - x276
    x278 = x277 * x60
    x279 = -x10 * x278 + x275 * x3
    x280 = x123 * x13
    x281 = x267 * x39 - x280
    x282 = x13 * x86
    x283 = x267 * x35 - x282
    x284 = x283 * x60
    x285 = -x10 * x284 + x279 * x65 + x281 * x3
    x286 = -x10 * x272 + x269 * x3 + x285 * x70
    x287 = x13 * x82
    x288 = x267 * x81 - x287
    x289 = -x13 * x61 + x267 * x52
    x290 = x289 * x60
    x291 = -x13 * x62 + x267 * x51
    x292 = x291 * x60
    x293 = x267 * x48 - x273 * x55
    x294 = x293 * x60
    x295 = -x10 * x294 + x277 * x3
    x296 = -x13 * x68 + x267 * x49
    x297 = x296 * x60
    x298 = -x10 * x297 + x283 * x3 + x295 * x65
    x299 = -x10 * x292 + x271 * x3 + x298 * x70
    x300 = -x10 * x290 + x288 * x3 + x299 * x72
    x301 = x25 * x286 + x300
    x302 = x136 * x22 + x301
    x303 = x90 * (x267 * x81 - x287 - x290)
    x304 = x90 * (x267 * x80 - x268 - x272)
    x305 = x90 * (x267 * x39 - x280 - x284)
    x306 = x90 * (2 * x18 * x19 * x20 * x24 * x267 * x28 - x274 - x278)
    x307 = (
        x286 * x3
        - x299 * x66
        + x304
        + x70 * (x285 * x3 - x298 * x66 + x305 + x65 * (x279 * x3 - x295 * x66 + x306))
    )
    x308 = x90 * (x267 * x44 - x270 - x292)
    x309 = -x108 * x273 + x267 * x58
    x310 = -x106 * x273 + x267 * x55
    x311 = x293 * x3 - x310 * x66
    x312 = -x107 * x273 + x267 * x56
    x313 = x296 * x3 + x311 * x65 - x312 * x66
    x314 = x291 * x3 - x309 * x66 + x313 * x70
    x315 = x90 * (x267 * x35 - x282 - x297)
    x316 = x90 * (2 * x19 * x20 * x24 * x267 * x28 * x33 - x276 - x294)
    x317 = -x109 * x273 + x267 * x59
    x318 = (
        x25 * x307
        + x3 * x300
        + x303
        - x66 * (x289 * x3 + x314 * x72 - x317 * x66)
        + x72
        * (
            x299 * x3
            + x308
            - x314 * x66
            + x70
            * (x298 * x3 - x313 * x66 + x315 + x65 * (x295 * x3 - x311 * x66 + x316))
        )
    )
    x319 = -x13 * x148 + x153 * x267 + x271 * x65
    x320 = -x13 * x166 + x147 * x267 + x291 * x65
    x321 = x320 * x60
    x322 = -x13 * x155 + x139 * x267 + x277 * x65
    x323 = -x13 * x167 + x144 * x267 + x293 * x65
    x324 = x323 * x60
    x325 = -x10 * x324 + x3 * x322
    x326 = -x13 * x158 + x143 * x267 + x283 * x65
    x327 = -x13 * x169 + x146 * x267 + x296 * x65
    x328 = x327 * x60
    x329 = -x10 * x328 + x3 * x326 + x325 * x65
    x330 = -x10 * x321 + x3 * x319 + x329 * x70
    x331 = x26 * x286 + x330
    x332 = x181 * x22 + x331
    x333 = x90 * (x319 - x321)
    x334 = x90 * (x326 - x328)
    x335 = x90 * (x322 - x324)
    x336 = x162 * x267 - x183 * x273 + x310 * x65
    x337 = x3 * x323 - x336 * x66
    x338 = x164 * x267 - x187 * x273 + x312 * x65
    x339 = x3 * x327 + x337 * x65 - x338 * x66
    x340 = x165 * x267 - x192 * x273 + x309 * x65
    x341 = (
        x3 * x330
        + x333
        - x66 * (x3 * x320 + x339 * x70 - x340 * x66)
        + x70 * (x3 * x329 + x334 - x339 * x66 + x65 * (x3 * x325 + x335 - x337 * x66))
    )
    x342 = x26 * x307 + x341
    x343 = x22 * x27
    x344 = x27 * x286
    x345 = x125 * x343 + x344
    x346 = x27 * x307
    x347 = -x13 * x198 + x141 * x267 + x275 * x65
    x348 = x322 * x60
    x349 = -x10 * x348 + x3 * x347
    x350 = -x13 * x196 + x152 * x267 + x281 * x65
    x351 = x326 * x60
    x352 = -x10 * x351 + x3 * x350 + x349 * x65
    x353 = x25 * x352 + x330
    x354 = x208 * x22 + x353
    x355 = x90 * (x350 - x351)
    x356 = x90 * (x347 - x348)
    x357 = x3 * x352 - x329 * x66 + x355 + x65 * (x3 * x349 - x325 * x66 + x356)
    x358 = x25 * x357 + x341
    x359 = -x13 * x217 + x210 * x267 + x322 * x70
    x360 = -x13 * x222 + x211 * x267 + x323 * x70
    x361 = x360 * x60
    x362 = -x10 * x361 + x3 * x359
    x363 = -x13 * x213 + x215 * x267 + x326 * x70
    x364 = -x13 * x228 + x212 * x267 + x327 * x70
    x365 = x364 * x60
    x366 = -x10 * x365 + x3 * x363 + x362 * x65
    x367 = x26 * x352 + x366
    x368 = x22 * x233 + x367
    x369 = x90 * (x363 - x365)
    x370 = x90 * (x359 - x361)
    x371 = x221 * x267 - x235 * x273 + x336 * x70
    x372 = x3 * x360 - x371 * x66
    x373 = x227 * x267 - x239 * x273 + x338 * x70
    x374 = (
        x3 * x366
        + x369
        + x65 * (x3 * x362 + x370 - x372 * x66)
        - x66 * (x3 * x364 + x372 * x65 - x373 * x66)
    )
    x375 = x26 * x357 + x374
    x376 = x27 * x352
    x377 = x204 * x343 + x376
    x378 = x27 * x357
    x379 = -x13 * x242 + x214 * x267 + x347 * x70
    x380 = x359 * x60
    x381 = -x10 * x380 + x3 * x379
    x382 = x25 * x381 + x366
    x383 = x22 * x249 + x382
    x384 = x90 * (x379 - x380)
    x385 = x3 * x381 - x362 * x66 + x384
    x386 = x25 * x385 + x374
    x387 = -x13 * x253 + x251 * x267 + x359 * x72
    x388 = -x13 * x256 + x252 * x267 + x360 * x72
    x389 = x388 * x60
    x390 = -x10 * x389 + x3 * x387
    x391 = x26 * x381 + x390
    x392 = x22 * x265 + x391
    x393 = x90 * (x387 - x389)
    x394 = x255 * x267 - x263 * x273 + x371 * x72
    x395 = x26 * x385 + x3 * x390 + x393 - x66 * (x3 * x388 - x394 * x66)
    x396 = x27 * x381
    x397 = x245 * x343 + x396
    x398 = x27 * x385
    x399 = -x14 - A[2]
    x400 = x120 * x15
    x401 = x399 * x80 - x400
    x402 = x15 * x83
    x403 = x399 * x44 - x402
    x404 = x403 * x60
    x405 = x15 * x60
    x406 = x34 * x405
    x407 = x30 * x399 - x406
    x408 = x3 * x407
    x409 = x405 * x48
    x410 = x34 * x399 - x409
    x411 = x410 * x60
    x412 = x10 * x411
    x413 = x408 - x412
    x414 = x123 * x15
    x415 = x39 * x399 - x414
    x416 = x3 * x415
    x417 = x15 * x86
    x418 = x35 * x399 - x417
    x419 = x418 * x60
    x420 = -x10 * x419 + x413 * x65 + x416
    x421 = -x10 * x404 + x3 * x401 + x420 * x70
    x422 = x15 * x82
    x423 = x399 * x81 - x422
    x424 = -x15 * x61 + x399 * x52
    x425 = x424 * x60
    x426 = x3 * x403
    x427 = -x15 * x62 + x399 * x51
    x428 = x427 * x60
    x429 = x10 * x428
    x430 = x3 * x410
    x431 = x399 * x48 - x405 * x55
    x432 = x431 * x60
    x433 = x10 * x432
    x434 = x430 - x433
    x435 = x3 * x418
    x436 = -x15 * x68 + x399 * x49
    x437 = x436 * x60
    x438 = x10 * x437
    x439 = x434 * x65 + x435 - x438
    x440 = x426 - x429 + x439 * x70
    x441 = -x10 * x425 + x3 * x423 + x440 * x72
    x442 = x25 * x421 + x441
    x443 = x136 * x23 + x442
    x444 = x90 * (x399 * x81 - x422 - x425)
    x445 = x90 * (x399 * x80 - x400 - x404)
    x446 = x90 * (x39 * x399 - x414 - x419)
    x447 = x90 * (2 * x18 * x19 * x20 * x24 * x28 * x399 - x406 - x411)
    x448 = (
        x3 * x421
        - x440 * x66
        + x445
        + x70 * (x3 * x420 - x439 * x66 + x446 + x65 * (x3 * x413 - x434 * x66 + x447))
    )
    x449 = x90 * (x399 * x44 - x402 - x428)
    x450 = x3 * x427
    x451 = -x108 * x405 + x399 * x58
    x452 = x451 * x66
    x453 = x3 * x431
    x454 = -x106 * x405 + x399 * x55
    x455 = x454 * x66
    x456 = x453 - x455
    x457 = x3 * x436
    x458 = -x107 * x405 + x399 * x56
    x459 = x458 * x66
    x460 = x456 * x65 + x457 - x459
    x461 = x450 - x452 + x460 * x70
    x462 = x90 * (x35 * x399 - x417 - x437)
    x463 = x90 * (2 * x19 * x20 * x24 * x28 * x33 * x399 - x409 - x432)
    x464 = -x109 * x405 + x399 * x59
    x465 = (
        x25 * x448
        + x3 * x441
        + x444
        - x66 * (x3 * x424 + x461 * x72 - x464 * x66)
        + x72
        * (
            x3 * x440
            + x449
            - x461 * x66
            + x70
            * (x3 * x439 - x460 * x66 + x462 + x65 * (x3 * x434 - x456 * x66 + x463))
        )
    )
    x466 = x148 * x15
    x467 = x153 * x399 - x466
    x468 = x147 * x399 - x15 * x166
    x469 = x468 * x60
    x470 = x15 * x158
    x471 = x143 * x399 - x470
    x472 = x3 * x471
    x473 = x15 * x155
    x474 = x139 * x399 - x473
    x475 = x3 * x474
    x476 = x144 * x399 - x15 * x167
    x477 = x476 * x60
    x478 = x10 * x477
    x479 = x475 - x478
    x480 = x146 * x399 - x15 * x169
    x481 = x480 * x60
    x482 = x10 * x481
    x483 = x472 + x479 * x65 - x482
    x484 = -x10 * x469 + x3 * x467 + x483 * x70
    x485 = x26 * x421 + x484
    x486 = x181 * x23 + x485
    x487 = x90 * (x153 * x399 - x466 - x469)
    x488 = x90 * (x143 * x399 - x470 - x481)
    x489 = x90 * (x139 * x399 - x473 - x477)
    x490 = x3 * x476
    x491 = x162 * x399 - x183 * x405
    x492 = x491 * x66
    x493 = x490 - x492
    x494 = x3 * x480
    x495 = x164 * x399 - x187 * x405
    x496 = x495 * x66
    x497 = x493 * x65 + x494 - x496
    x498 = x165 * x399 - x192 * x405
    x499 = (
        x3 * x484
        + x487
        - x66 * (x3 * x468 + x497 * x70 - x498 * x66)
        + x70 * (x3 * x483 + x488 - x497 * x66 + x65 * (x3 * x479 + x489 - x493 * x66))
    )
    x500 = x26 * x448 + x499
    x501 = x23 * x27
    x502 = x430 * x65 - x433 * x65
    x503 = x435 * x65 - x438 * x65 + x502 * x65
    x504 = x426 * x65 - x429 * x65 + x503 * x70
    x505 = x27 * x421 + x504
    x506 = x125 * x501 + x505
    x507 = x428 * x65
    x508 = x90 * (x403 * x65 - x507)
    x509 = x437 * x65
    x510 = x90 * (x418 * x65 - x509)
    x511 = x432 * x65
    x512 = x90 * (x410 * x65 - x511)
    x513 = x453 * x65 - x455 * x65
    x514 = x457 * x65 - x459 * x65 + x513 * x65
    x515 = (
        x3 * x504
        + x508
        - x66 * (x450 * x65 - x452 * x65 + x514 * x70)
        + x70 * (x3 * x503 + x510 - x514 * x66 + x65 * (x3 * x502 + x512 - x513 * x66))
    )
    x516 = x27 * x448 + x515
    x517 = x15 * x196
    x518 = x152 * x399 - x517
    x519 = x15 * x198
    x520 = x141 * x399 - x519
    x521 = x3 * x520
    x522 = x474 * x60
    x523 = -x10 * x522 + x521
    x524 = x471 * x60
    x525 = -x10 * x524 + x3 * x518 + x523 * x65
    x526 = x25 * x525 + x484
    x527 = x208 * x23 + x526
    x528 = x90 * (x152 * x399 - x517 - x524)
    x529 = x90 * (x141 * x399 - x519 - x522)
    x530 = x3 * x525 - x483 * x66 + x528 + x65 * (x3 * x523 - x479 * x66 + x529)
    x531 = x25 * x530 + x499
    x532 = x15 * x213
    x533 = x215 * x399 - x532
    x534 = x15 * x217
    x535 = x210 * x399 - x534
    x536 = x3 * x535
    x537 = -x15 * x222 + x211 * x399
    x538 = x537 * x60
    x539 = x10 * x538
    x540 = x536 - x539
    x541 = -x15 * x228 + x212 * x399
    x542 = x541 * x60
    x543 = -x10 * x542 + x3 * x533 + x540 * x65
    x544 = x26 * x525 + x543
    x545 = x23 * x233 + x544
    x546 = x90 * (x215 * x399 - x532 - x542)
    x547 = x90 * (x210 * x399 - x534 - x538)
    x548 = x3 * x537
    x549 = x221 * x399 - x235 * x405
    x550 = x549 * x66
    x551 = x548 - x550
    x552 = x227 * x399 - x239 * x405
    x553 = (
        x3 * x543
        + x546
        + x65 * (x3 * x540 + x547 - x551 * x66)
        - x66 * (x3 * x541 + x551 * x65 - x552 * x66)
    )
    x554 = x26 * x530 + x553
    x555 = x475 * x65 - x478 * x65
    x556 = x472 * x65 - x482 * x65 + x555 * x65
    x557 = x27 * x525 + x556
    x558 = x204 * x501 + x557
    x559 = x481 * x65
    x560 = x90 * (x471 * x65 - x559)
    x561 = x477 * x65
    x562 = x90 * (x474 * x65 - x561)
    x563 = x490 * x65 - x492 * x65
    x564 = (
        x3 * x556
        + x560
        + x65 * (x3 * x555 + x562 - x563 * x66)
        - x66 * (x494 * x65 - x496 * x65 + x563 * x65)
    )
    x565 = x27 * x530 + x564
    x566 = x410 * x65
    x567 = x408 * x65 - x566 * x66
    x568 = x418 * x65
    x569 = x416 * x65 + x567 * x65 - x568 * x66
    x570 = x25 * x569 + x504
    x571 = x90 * (x415 * x65 - x568 * x60)
    x572 = x90 * (x407 * x65 - x566 * x60)
    x573 = x3 * x569 - x503 * x66 + x571 + x65 * (x3 * x567 - x502 * x66 + x572)
    x574 = x21 * x570 + x25 * x573 + x515
    x575 = x26 * x569 + x556
    x576 = x21 * x575 + x26 * x573 + x564
    x577 = x64 ** (-2.0)
    x578 = 2 * x577
    x579 = x430 * x578 - x433 * x578
    x580 = x435 * x578 - x438 * x578 + x579 * x65
    x581 = x27 * x569 + x580
    x582 = x90 * (2 * x418 * x577 - x437 * x578)
    x583 = x90 * (2 * x410 * x577 - x432 * x578)
    x584 = x453 * x578 - x455 * x578
    x585 = (
        x3 * x580
        + x582
        + x65 * (x3 * x579 + x583 - x584 * x66)
        - x66 * (x457 * x578 - x459 * x578 + x584 * x65)
    )
    x586 = x21 * x581 + x27 * x573 + x585
    x587 = x15 * x242
    x588 = x214 * x399 - x587
    x589 = x535 * x60
    x590 = -x10 * x589 + x3 * x588
    x591 = x25 * x590 + x543
    x592 = x23 * x249 + x591
    x593 = x90 * (x214 * x399 - x587 - x589)
    x594 = x3 * x590 - x540 * x66 + x593
    x595 = x25 * x594 + x553
    x596 = x15 * x253
    x597 = x251 * x399 - x596
    x598 = -x15 * x256 + x252 * x399
    x599 = x598 * x60
    x600 = -x10 * x599 + x3 * x597
    x601 = x26 * x590 + x600
    x602 = x23 * x265 + x601
    x603 = x90 * (x251 * x399 - x596 - x599)
    x604 = x255 * x399 - x263 * x405
    x605 = x26 * x594 + x3 * x600 + x603 - x66 * (x3 * x598 - x604 * x66)
    x606 = x536 * x65 - x539 * x65
    x607 = x27 * x590 + x606
    x608 = x245 * x501 + x607
    x609 = x538 * x65
    x610 = x90 * (x535 * x65 - x609)
    x611 = x3 * x606 + x610 - x66 * (x548 * x65 - x550 * x65)
    x612 = x27 * x594 + x611
    x613 = x474 * x65
    x614 = x521 * x65 - x613 * x66
    x615 = x25 * x614 + x556
    x616 = x90 * (x520 * x65 - x60 * x613)
    x617 = x3 * x614 - x555 * x66 + x616
    x618 = x21 * x615 + x25 * x617 + x564
    x619 = x26 * x614 + x606
    x620 = x21 * x619 + x26 * x617 + x611
    x621 = x475 * x578 - x478 * x578
    x622 = x27 * x614 + x621
    x623 = x90 * (2 * x474 * x577 - x477 * x578)
    x624 = x3 * x621 + x623 - x66 * (x490 * x578 - x492 * x578)
    x625 = x21 * x622 + x27 * x617 + x624
    x626 = x408 * x578 - x412 * x578
    x627 = x25 * x626 + x580
    x628 = x90 * (2 * x407 * x577 - x411 * x578)
    x629 = x3 * x626 - x579 * x66 + x628
    x630 = x21 * x627 + x25 * x629 + x585
    x631 = x26 * x626 + x621
    x632 = x21 * x631 + x26 * x629 + x624
    x633 = x64 ** (-3.0)
    x634 = 6 * x633
    x635 = x90 * (6 * x410 * x633 - x432 * x634)
    x636 = x430 * x634 - x433 * x634
    x637 = x27 * x626 + x636
    x638 = x21 * x637 + x27 * x629 + x3 * x636 + x635 - x66 * (x453 * x634 - x455 * x634)
    x639 = x126 - x13 * x272 + x267 * x269
    x640 = -x13 * x292 + x267 * x271 + x93
    x641 = x128 - x13 * x278 + x267 * x275
    x642 = -x13 * x294 + x267 * x277 + x96
    x643 = x127 - x13 * x284 + x267 * x281
    x644 = -x13 * x297 + x267 * x283 + x95
    x645 = (
        x3 * x639
        - x640 * x66
        + x70 * (x3 * x643 - x644 * x66 + x65 * (x3 * x641 - x642 * x66))
    )
    x646 = -x13 * x290 + x267 * x288 + x92
    x647 = x113 + x267 * x291 - x273 * x309
    x648 = x115 + x267 * x293 - x273 * x310
    x649 = x114 + x267 * x296 - x273 * x312
    x650 = x103 + x267 * x289 - x273 * x317
    x651 = (
        x22 * x301
        + x25 * x645
        + x3 * x646
        - x650 * x66
        + x72
        * (
            x3 * x640
            - x647 * x66
            + x70 * (x3 * x644 - x649 * x66 + x65 * (x3 * x642 - x648 * x66))
        )
    )
    x652 = -x13 * x321 + x154 + x267 * x319 + x640 * x65
    x653 = -x13 * x324 + x174 + x267 * x322 + x642 * x65
    x654 = x182 + x267 * x323 - x273 * x336 + x648 * x65
    x655 = -x13 * x328 + x173 + x267 * x326 + x644 * x65
    x656 = x186 + x267 * x327 - x273 * x338 + x649 * x65
    x657 = x190 + x267 * x320 - x273 * x340 + x647 * x65
    x658 = (
        x3 * x652
        - x657 * x66
        + x70 * (x3 * x655 + x65 * (x3 * x653 - x654 * x66) - x656 * x66)
    )
    x659 = x22 * x331 + x26 * x645 + x658
    x660 = x22 * x344 + x27 * x645
    x661 = -x13 * x348 + x199 + x267 * x347 + x641 * x65
    x662 = -x13 * x351 + x197 + x267 * x350 + x643 * x65
    x663 = x3 * x662 + x65 * (x3 * x661 - x653 * x66) - x655 * x66
    x664 = x22 * x353 + x25 * x663 + x658
    x665 = -x13 * x361 + x218 + x267 * x359 + x653 * x70
    x666 = x234 + x267 * x360 - x273 * x371 + x654 * x70
    x667 = -x13 * x365 + x216 + x267 * x363 + x655 * x70
    x668 = x238 + x267 * x364 - x273 * x373 + x656 * x70
    x669 = x3 * x667 + x65 * (x3 * x665 - x66 * x666) - x66 * x668
    x670 = x22 * x367 + x26 * x663 + x669
    x671 = x22 * x376 + x27 * x663
    x672 = -x13 * x380 + x243 + x267 * x379 + x661 * x70
    x673 = x3 * x672 - x66 * x665
    x674 = x22 * x382 + x25 * x673 + x669
    x675 = -x13 * x389 + x259 + x267 * x387 + x665 * x72
    x676 = x262 + x267 * x388 - x273 * x394 + x666 * x72
    x677 = x22 * x391 + x26 * x673 + x3 * x675 - x66 * x676
    x678 = x22 * x396 + x27 * x673
    x679 = -x13 * x404 + x267 * x401
    x680 = -x13 * x428 + x267 * x403
    x681 = x267 * x407
    x682 = x13 * x411
    x683 = x681 - x682
    x684 = x267 * x410
    x685 = x13 * x432
    x686 = x684 - x685
    x687 = -x13 * x419 + x267 * x415
    x688 = x267 * x418
    x689 = x13 * x437
    x690 = x688 - x689
    x691 = (
        x3 * x679
        - x66 * x680
        + x70 * (x3 * x687 + x65 * (x3 * x683 - x66 * x686) - x66 * x690)
    )
    x692 = -x13 * x425 + x267 * x423
    x693 = x267 * x427
    x694 = x273 * x451
    x695 = x693 - x694
    x696 = x267 * x431
    x697 = x273 * x454
    x698 = x696 - x697
    x699 = x267 * x436
    x700 = x273 * x458
    x701 = x699 - x700
    x702 = x267 * x424 - x273 * x464
    x703 = (
        x25 * x691
        + x3 * x692
        - x66 * x702
        + x72
        * (
            x3 * x680
            - x66 * x695
            + x70 * (x3 * x690 + x65 * (x3 * x686 - x66 * x698) - x66 * x701)
        )
    )
    x704 = x23 * x301 + x703
    x705 = -x13 * x469 + x267 * x467 + x65 * x680
    x706 = x267 * x474
    x707 = x13 * x477
    x708 = x65 * x686 + x706 - x707
    x709 = x267 * x476
    x710 = x273 * x491
    x711 = x65 * x698 + x709 - x710
    x712 = -x13 * x481 + x267 * x471 + x65 * x690
    x713 = x267 * x480
    x714 = x273 * x495
    x715 = x65 * x701 + x713 - x714
    x716 = x267 * x468 - x273 * x498 + x65 * x695
    x717 = (
        x3 * x705
        - x66 * x716
        + x70 * (x3 * x712 + x65 * (x3 * x708 - x66 * x711) - x66 * x715)
    )
    x718 = x26 * x691 + x717
    x719 = x23 * x331 + x718
    x720 = x403 * x65
    x721 = -x13 * x507 + x267 * x720
    x722 = -x13 * x509 + x267 * x568
    x723 = x65 * x699 - x65 * x700
    x724 = -x13 * x511 + x267 * x566
    x725 = x65 * x696 - x65 * x697
    x726 = x65 * x693 - x65 * x694
    x727 = (
        x3 * x721
        - x66 * x726
        + x70 * (x3 * x722 + x65 * (x3 * x724 - x66 * x725) - x66 * x723)
    )
    x728 = x27 * x691 + x727
    x729 = x23 * x344 + x728
    x730 = -x13 * x522 + x267 * x520 + x65 * x683
    x731 = -x13 * x524 + x267 * x518 + x65 * x687
    x732 = x3 * x731 + x65 * (x3 * x730 - x66 * x708) - x66 * x712
    x733 = x25 * x732 + x717
    x734 = x23 * x353 + x733
    x735 = -x13 * x538 + x267 * x535 + x70 * x708
    x736 = x267 * x537
    x737 = x273 * x549
    x738 = x70 * x711 + x736 - x737
    x739 = -x13 * x542 + x267 * x533 + x70 * x712
    x740 = x267 * x541 - x273 * x552 + x70 * x715
    x741 = x3 * x739 + x65 * (x3 * x735 - x66 * x738) - x66 * x740
    x742 = x26 * x732 + x741
    x743 = x23 * x367 + x742
    x744 = -x13 * x561 + x267 * x613 + x65 * x724
    x745 = x65 * x709 - x65 * x710 + x65 * x725
    x746 = x471 * x65
    x747 = -x13 * x559 + x267 * x746 + x65 * x722
    x748 = x65 * x713 - x65 * x714 + x65 * x723
    x749 = x3 * x747 + x65 * (x3 * x744 - x66 * x745) - x66 * x748
    x750 = x27 * x732 + x749
    x751 = x23 * x376 + x750
    x752 = x415 * x65
    x753 = x267 * x752 - x273 * x568
    x754 = x407 * x65
    x755 = x267 * x754 - x273 * x566
    x756 = x3 * x753 + x65 * (x3 * x755 - x66 * x724) - x66 * x722
    x757 = x25 * x756 + x727
    x758 = x22 * x570 + x757
    x759 = x26 * x756 + x749
    x760 = x22 * x575 + x759
    x761 = x578 * x684 - x578 * x685
    x762 = x578 * x696 - x578 * x697
    x763 = x578 * x688 - x578 * x689
    x764 = x578 * x699 - x578 * x700
    x765 = x3 * x763 + x65 * (x3 * x761 - x66 * x762) - x66 * x764
    x766 = x27 * x756 + x765
    x767 = x22 * x581 + x766
    x768 = -x13 * x589 + x267 * x588 + x70 * x730
    x769 = x3 * x768 - x66 * x735
    x770 = x25 * x769 + x741
    x771 = x23 * x382 + x770
    x772 = -x13 * x599 + x267 * x597 + x72 * x735
    x773 = x267 * x598 - x273 * x604 + x72 * x738
    x774 = x26 * x769 + x3 * x772 - x66 * x773
    x775 = x23 * x391 + x774
    x776 = x535 * x65
    x777 = -x13 * x609 + x267 * x776 + x70 * x744
    x778 = x65 * x736 - x65 * x737 + x70 * x745
    x779 = x3 * x777 - x66 * x778
    x780 = x27 * x769 + x779
    x781 = x23 * x396 + x780
    x782 = x520 * x65
    x783 = x267 * x782 - x273 * x613 + x65 * x755
    x784 = x3 * x783 - x66 * x744
    x785 = x25 * x784 + x749
    x786 = x22 * x615 + x785
    x787 = x26 * x784 + x779
    x788 = x22 * x619 + x787
    x789 = x578 * x706 - x578 * x707 + x65 * x761
    x790 = x578 * x709 - x578 * x710 + x65 * x762
    x791 = x3 * x789 - x66 * x790
    x792 = x27 * x784 + x791
    x793 = x22 * x622 + x792
    x794 = x578 * x681 - x578 * x682
    x795 = x3 * x794 - x66 * x761
    x796 = x25 * x795 + x765
    x797 = x22 * x627 + x796
    x798 = x26 * x795 + x791
    x799 = x22 * x631 + x798
    x800 = x634 * x684 - x634 * x685
    x801 = x634 * x696 - x634 * x697
    x802 = x27 * x795 + x3 * x800 - x66 * x801
    x803 = x22 * x637 + x802
    x804 = x126 - x15 * x404 + x399 * x401
    x805 = -x15 * x428 + x399 * x403 + x93
    x806 = x399 * x407
    x807 = x15 * x411
    x808 = x128 + x806 - x807
    x809 = x399 * x410
    x810 = x15 * x432
    x811 = x809 - x810 + x96
    x812 = x127 - x15 * x419 + x399 * x415
    x813 = x399 * x418
    x814 = x15 * x437
    x815 = x813 - x814 + x95
    x816 = (
        x3 * x804
        - x66 * x805
        + x70 * (x3 * x812 + x65 * (x3 * x808 - x66 * x811) - x66 * x815)
    )
    x817 = -x15 * x425 + x399 * x423 + x92
    x818 = x399 * x427
    x819 = x405 * x451
    x820 = x113 + x818 - x819
    x821 = x399 * x431
    x822 = x405 * x454
    x823 = x115 + x821 - x822
    x824 = x399 * x436
    x825 = x405 * x458
    x826 = x114 + x824 - x825
    x827 = x103 + x399 * x424 - x405 * x464
    x828 = (
        x23 * x442
        + x25 * x816
        + x3 * x817
        - x66 * x827
        + x72
        * (
            x3 * x805
            - x66 * x820
            + x70 * (x3 * x815 + x65 * (x3 * x811 - x66 * x823) - x66 * x826)
        )
    )
    x829 = -x15 * x469 + x154 + x399 * x467
    x830 = x399 * x474
    x831 = x15 * x477
    x832 = x174 + x830 - x831
    x833 = x399 * x476
    x834 = x405 * x491
    x835 = x182 + x833 - x834
    x836 = -x15 * x481 + x173 + x399 * x471
    x837 = x399 * x480
    x838 = x405 * x495
    x839 = x186 + x837 - x838
    x840 = x190 + x399 * x468 - x405 * x498
    x841 = (
        x3 * x829
        - x66 * x840
        + x70 * (x3 * x836 + x65 * (x3 * x832 - x66 * x835) - x66 * x839)
    )
    x842 = x23 * x485 + x26 * x816 + x841
    x843 = -x15 * x507 + x399 * x720 + x65 * x805
    x844 = -x15 * x511 + x399 * x566 + x65 * x811
    x845 = x65 * x821 - x65 * x822 + x65 * x823
    x846 = -x15 * x509 + x399 * x568 + x65 * x815
    x847 = x65 * x824 - x65 * x825 + x65 * x826
    x848 = x65 * x818 - x65 * x819 + x65 * x820
    x849 = (
        x3 * x843
        - x66 * x848
        + x70 * (x3 * x846 + x65 * (x3 * x844 - x66 * x845) - x66 * x847)
    )
    x850 = x23 * x505 + x27 * x816 + x849
    x851 = -x15 * x522 + x199 + x399 * x520
    x852 = -x15 * x524 + x197 + x399 * x518
    x853 = x3 * x852 + x65 * (x3 * x851 - x66 * x832) - x66 * x836
    x854 = x23 * x526 + x25 * x853 + x841
    x855 = -x15 * x538 + x218 + x399 * x535
    x856 = x399 * x537
    x857 = x405 * x549
    x858 = x234 + x856 - x857
    x859 = -x15 * x542 + x216 + x399 * x533
    x860 = x238 + x399 * x541 - x405 * x552
    x861 = x3 * x859 + x65 * (x3 * x855 - x66 * x858) - x66 * x860
    x862 = x23 * x544 + x26 * x853 + x861
    x863 = -x15 * x561 + x399 * x613 + x65 * x832
    x864 = x65 * x833 - x65 * x834 + x65 * x835
    x865 = -x15 * x559 + x399 * x746 + x65 * x836
    x866 = x65 * x837 - x65 * x838 + x65 * x839
    x867 = x3 * x865 + x65 * (x3 * x863 - x66 * x864) - x66 * x866
    x868 = x23 * x557 + x27 * x853 + x867
    x869 = x23 * x570
    x870 = x399 * x754 - x405 * x566 + x65 * x808
    x871 = x399 * x752 - x405 * x568 + x65 * x812
    x872 = x3 * x871 + x65 * (x3 * x870 - x66 * x844) - x66 * x846
    x873 = x25 * x872 + x849
    x874 = x23 * x575
    x875 = x26 * x872 + x867
    x876 = x23 * x581
    x877 = x578 * x809 - x578 * x810 + x70 * x844
    x878 = x578 * x821 - x578 * x822 + x70 * x845
    x879 = x578 * x813 - x578 * x814 + x70 * x846
    x880 = x578 * x824 - x578 * x825 + x70 * x847
    x881 = x3 * x879 + x65 * (x3 * x877 - x66 * x878) - x66 * x880
    x882 = x27 * x872 + x881
    x883 = -x15 * x589 + x243 + x399 * x588
    x884 = x3 * x883 - x66 * x855
    x885 = x23 * x591 + x25 * x884 + x861
    x886 = -x15 * x599 + x259 + x399 * x597
    x887 = x262 + x399 * x598 - x405 * x604
    x888 = x23 * x601 + x26 * x884 + x3 * x886 - x66 * x887
    x889 = -x15 * x609 + x399 * x776 + x65 * x855
    x890 = x65 * x856 - x65 * x857 + x65 * x858
    x891 = x3 * x889 - x66 * x890
    x892 = x23 * x607 + x27 * x884 + x891
    x893 = x23 * x615
    x894 = x399 * x782 - x405 * x613 + x65 * x851
    x895 = x3 * x894 - x66 * x863
    x896 = x25 * x895 + x867
    x897 = x23 * x619
    x898 = x26 * x895 + x891
    x899 = x23 * x622
    x900 = x578 * x830 - x578 * x831 + x70 * x863
    x901 = x578 * x833 - x578 * x834 + x70 * x864
    x902 = x3 * x900 - x66 * x901
    x903 = x27 * x895 + x902
    x904 = x23 * x627
    x905 = x578 * x806 - x578 * x807 + x70 * x870
    x906 = x3 * x905 - x66 * x877
    x907 = x25 * x906 + x881
    x908 = x23 * x631
    x909 = x26 * x906 + x902
    x910 = x23 * x637
    x911 = x634 * x809 - x634 * x810 + x72 * x877
    x912 = x634 * x821 - x634 * x822 + x72 * x878
    x913 = x27 * x906 + x3 * x911 - x66 * x912
    x914 = x25 * x269 + x288
    x915 = x26 * x269 + x319
    x916 = x25 * x350 + x319
    x917 = x26 * x350 + x363
    x918 = x25 * x379 + x363
    x919 = x26 * x379 + x387
    x920 = x25 * x639 + x646
    x921 = x22 * x914 + x920
    x922 = x26 * x639 + x652
    x923 = x22 * x915 + x922
    x924 = x27 * x639
    x925 = x269 * x343 + x924
    x926 = x25 * x662 + x652
    x927 = x22 * x916 + x926
    x928 = x26 * x662 + x667
    x929 = x22 * x917 + x928
    x930 = x27 * x662
    x931 = x343 * x350 + x930
    x932 = x25 * x672 + x667
    x933 = x22 * x918 + x932
    x934 = x26 * x672 + x675
    x935 = x22 * x919 + x934
    x936 = x27 * x672
    x937 = x343 * x379 + x936
    x938 = x25 * x679 + x692
    x939 = x23 * x914 + x938
    x940 = x26 * x679 + x705
    x941 = x23 * x915 + x940
    x942 = x27 * x679 + x721
    x943 = x269 * x501 + x942
    x944 = x25 * x731 + x705
    x945 = x23 * x916 + x944
    x946 = x26 * x731 + x739
    x947 = x23 * x917 + x946
    x948 = x27 * x731 + x747
    x949 = x350 * x501 + x948
    x950 = x25 * x753 + x721
    x951 = x26 * x753 + x747
    x952 = x27 * x753 + x763
    x953 = x25 * x768 + x739
    x954 = x23 * x918 + x953
    x955 = x26 * x768 + x772
    x956 = x23 * x919 + x955
    x957 = x27 * x768 + x777
    x958 = x379 * x501 + x957
    x959 = x25 * x783 + x747
    x960 = x26 * x783 + x777
    x961 = x27 * x783 + x789
    x962 = x25 * x794 + x763
    x963 = x26 * x794 + x789
    x964 = x27 * x794 + x800
    x965 = x267 * x639 - x273 * x640 + 2 * x304
    x966 = (
        x267 * x652
        - x273 * x657
        + 2 * x333
        + x65 * (x267 * x640 - x273 * x647 + 2 * x308)
    )
    x967 = (
        x267 * x662
        - x273 * x655
        + 2 * x355
        + x65 * (x267 * x643 - x273 * x644 + 2 * x305)
    )
    x968 = (
        x267 * x667
        - x273 * x668
        + 2 * x369
        + x70
        * (
            x267 * x655
            - x273 * x656
            + 2 * x334
            + x65 * (x267 * x644 - x273 * x649 + 2 * x315)
        )
    )
    x969 = (
        x267 * x672
        - x273 * x665
        + 2 * x384
        + x70
        * (
            x267 * x661
            - x273 * x653
            + 2 * x356
            + x65 * (x267 * x641 - x273 * x642 + 2 * x306)
        )
    )
    x970 = x267 * x679 - x273 * x680 + x445
    x971 = x25 * x970 + x267 * x692 - x273 * x702 + x444
    x972 = x267 * x705 - x273 * x716 + x487 + x65 * (x267 * x680 - x273 * x695 + x449)
    x973 = x26 * x970 + x972
    x974 = x267 * x721 - x273 * x726 + x508
    x975 = x27 * x970 + x974
    x976 = x267 * x731 - x273 * x712 + x528 + x65 * (x267 * x687 - x273 * x690 + x446)
    x977 = x25 * x976 + x972
    x978 = (
        x267 * x739
        - x273 * x740
        + x546
        + x70
        * (x267 * x712 - x273 * x715 + x488 + x65 * (x267 * x690 - x273 * x701 + x462))
    )
    x979 = x26 * x976 + x978
    x980 = x267 * x747 - x273 * x748 + x560 + x65 * (x267 * x722 - x273 * x723 + x510)
    x981 = x27 * x976 + x980
    x982 = x267 * x753 - x273 * x722 + x571
    x983 = x22 * x950 + x25 * x982 + x974
    x984 = x22 * x951 + x26 * x982 + x980
    x985 = x267 * x763 - x273 * x764 + x582
    x986 = x22 * x952 + x27 * x982 + x985
    x987 = (
        x267 * x768
        - x273 * x735
        + x593
        + x70
        * (x267 * x730 - x273 * x708 + x529 + x65 * (x267 * x683 - x273 * x686 + x447))
    )
    x988 = x25 * x987 + x978
    x989 = (
        x26 * x987
        + x267 * x772
        - x273 * x773
        + x603
        + x72
        * (
            x267 * x735
            - x273 * x738
            + x547
            + x70
            * (
                x267 * x708
                - x273 * x711
                + x489
                + x65 * (x267 * x686 - x273 * x698 + x463)
            )
        )
    )
    x990 = (
        x267 * x777
        - x273 * x778
        + x610
        + x70
        * (x267 * x744 - x273 * x745 + x562 + x65 * (x267 * x724 - x273 * x725 + x512))
    )
    x991 = x27 * x987 + x990
    x992 = x267 * x783 - x273 * x744 + x616 + x65 * (x267 * x755 - x273 * x724 + x572)
    x993 = x22 * x959 + x25 * x992 + x980
    x994 = x22 * x960 + x26 * x992 + x990
    x995 = x267 * x789 - x273 * x790 + x623 + x65 * (x267 * x761 - x273 * x762 + x583)
    x996 = x22 * x961 + x27 * x992 + x995
    x997 = x267 * x794 - x273 * x761 + x628
    x998 = x22 * x962 + x25 * x997 + x985
    x999 = x22 * x963 + x26 * x997 + x995
    x1000 = x22 * x964 + x267 * x800 + x27 * x997 - x273 * x801 + x635
    x1001 = x267 * x804 - x273 * x805
    x1002 = x1001 * x25 + x23 * x938 + x267 * x817 - x273 * x827
    x1003 = x267 * x829 - x273 * x840 + x65 * (x267 * x805 - x273 * x820)
    x1004 = x1001 * x26 + x1003 + x23 * x940
    x1005 = x267 * x843 - x273 * x848
    x1006 = x1001 * x27 + x1005 + x23 * x942
    x1007 = x267 * x852 - x273 * x836 + x65 * (x267 * x812 - x273 * x815)
    x1008 = x1003 + x1007 * x25 + x23 * x944
    x1009 = (
        x267 * x859
        - x273 * x860
        + x70 * (x267 * x836 - x273 * x839 + x65 * (x267 * x815 - x273 * x826))
    )
    x1010 = x1007 * x26 + x1009 + x23 * x946
    x1011 = x267 * x865 - x273 * x866 + x65 * (x267 * x846 - x273 * x847)
    x1012 = x1007 * x27 + x1011 + x23 * x948
    x1013 = x23 * x950
    x1014 = x267 * x871 - x273 * x846
    x1015 = x1005 + x1014 * x25
    x1016 = x23 * x951
    x1017 = x1011 + x1014 * x26
    x1018 = x23 * x952
    x1019 = x267 * x879 - x273 * x880
    x1020 = x1014 * x27 + x1019
    x1021 = (
        x267 * x883
        - x273 * x855
        + x70 * (x267 * x851 - x273 * x832 + x65 * (x267 * x808 - x273 * x811))
    )
    x1022 = x1009 + x1021 * x25 + x23 * x953
    x1023 = (
        x1021 * x26
        + x23 * x955
        + x267 * x886
        - x273 * x887
        + x72
        * (
            x267 * x855
            - x273 * x858
            + x70 * (x267 * x832 - x273 * x835 + x65 * (x267 * x811 - x273 * x823))
        )
    )
    x1024 = (
        x267 * x889
        - x273 * x890
        + x70 * (x267 * x863 - x273 * x864 + x65 * (x267 * x844 - x273 * x845))
    )
    x1025 = x1021 * x27 + x1024 + x23 * x957
    x1026 = x23 * x959
    x1027 = x267 * x894 - x273 * x863 + x65 * (x267 * x870 - x273 * x844)
    x1028 = x1011 + x1027 * x25
    x1029 = x23 * x960
    x1030 = x1024 + x1027 * x26
    x1031 = x23 * x961
    x1032 = x267 * x900 - x273 * x901 + x65 * (x267 * x877 - x273 * x878)
    x1033 = x1027 * x27 + x1032
    x1034 = x23 * x962
    x1035 = x267 * x905 - x273 * x877
    x1036 = x1019 + x1035 * x25
    x1037 = x23 * x963
    x1038 = x1032 + x1035 * x26
    x1039 = x23 * x964
    x1040 = x1035 * x27 + x267 * x911 - x273 * x912
    x1041 = x25 * x401 + x423
    x1042 = x26 * x401 + x467
    x1043 = x27 * x401 + x720
    x1044 = x25 * x518 + x467
    x1045 = x26 * x518 + x533
    x1046 = x27 * x518 + x746
    x1047 = x25 * x752 + x720
    x1048 = x26 * x752 + x746
    x1049 = x418 * x578
    x1050 = x1049 + x27 * x752
    x1051 = x25 * x588 + x533
    x1052 = x26 * x588 + x597
    x1053 = x27 * x588 + x776
    x1054 = x25 * x782 + x746
    x1055 = x26 * x782 + x776
    x1056 = x474 * x578
    x1057 = x1056 + x27 * x782
    x1058 = x407 * x578
    x1059 = x1049 + x1058 * x25
    x1060 = x1056 + x1058 * x26
    x1061 = x1058 * x27 + x410 * x634
    x1062 = x1041 * x22 + x938
    x1063 = x1042 * x22 + x940
    x1064 = x1043 * x22 + x942
    x1065 = x1044 * x22 + x944
    x1066 = x1045 * x22 + x946
    x1067 = x1046 * x22 + x948
    x1068 = x1047 * x22 + x950
    x1069 = x1048 * x22 + x951
    x1070 = x1050 * x22 + x952
    x1071 = x1051 * x22 + x953
    x1072 = x1052 * x22 + x955
    x1073 = x1053 * x22 + x957
    x1074 = x1054 * x22 + x959
    x1075 = x1055 * x22 + x960
    x1076 = x1057 * x22 + x961
    x1077 = x1059 * x22 + x962
    x1078 = x1060 * x22 + x963
    x1079 = x1061 * x22 + x964
    x1080 = x25 * x804 + x817
    x1081 = x1041 * x23 + x1080
    x1082 = x26 * x804 + x829
    x1083 = x1042 * x23 + x1082
    x1084 = x27 * x804 + x843
    x1085 = x1043 * x23 + x1084
    x1086 = x25 * x852 + x829
    x1087 = x1044 * x23 + x1086
    x1088 = x26 * x852 + x859
    x1089 = x1045 * x23 + x1088
    x1090 = x27 * x852 + x865
    x1091 = x1046 * x23 + x1090
    x1092 = x25 * x871 + x843
    x1093 = x1047 * x23 + x1092
    x1094 = x26 * x871 + x865
    x1095 = x1048 * x23 + x1094
    x1096 = x27 * x871 + x879
    x1097 = x1050 * x23 + x1096
    x1098 = x25 * x883 + x859
    x1099 = x1051 * x23 + x1098
    x1100 = x26 * x883 + x886
    x1101 = x1052 * x23 + x1100
    x1102 = x27 * x883 + x889
    x1103 = x1053 * x23 + x1102
    x1104 = x25 * x894 + x865
    x1105 = x1054 * x23 + x1104
    x1106 = x26 * x894 + x889
    x1107 = x1055 * x23 + x1106
    x1108 = x27 * x894 + x900
    x1109 = x1057 * x23 + x1108
    x1110 = x25 * x905 + x879
    x1111 = x1059 * x23 + x1110
    x1112 = x26 * x905 + x900
    x1113 = x1060 * x23 + x1112
    x1114 = x27 * x905 + x911
    x1115 = x1061 * x23 + x1114
    x1116 = x399 * x804 - x405 * x805 + 2 * x445
    x1117 = x399 * x829 - x405 * x840 + 2 * x487
    x1118 = (
        x399 * x843
        - x405 * x848
        + 2 * x508
        + x65 * (x399 * x805 - x405 * x820 + 2 * x449)
    )
    x1119 = x399 * x852 - x405 * x836 + 2 * x528
    x1120 = x399 * x859 - x405 * x860 + 2 * x546
    x1121 = (
        x399 * x865
        - x405 * x866
        + 2 * x560
        + x65 * (x399 * x836 - x405 * x839 + 2 * x488)
    )
    x1122 = (
        x399 * x871
        - x405 * x846
        + 2 * x571
        + x65 * (x399 * x812 - x405 * x815 + 2 * x446)
    )
    x1123 = (
        x399 * x879
        - x405 * x880
        + 2 * x582
        + x70
        * (
            x399 * x846
            - x405 * x847
            + 2 * x510
            + x65 * (x399 * x815 - x405 * x826 + 2 * x462)
        )
    )
    x1124 = x399 * x883 - x405 * x855 + 2 * x593
    x1125 = (
        x399 * x889
        - x405 * x890
        + 2 * x610
        + x65 * (x399 * x855 - x405 * x858 + 2 * x547)
    )
    x1126 = (
        x399 * x894
        - x405 * x863
        + 2 * x616
        + x65 * (x399 * x851 - x405 * x832 + 2 * x529)
    )
    x1127 = (
        x399 * x900
        - x405 * x901
        + 2 * x623
        + x70
        * (
            x399 * x863
            - x405 * x864
            + 2 * x562
            + x65 * (x399 * x832 - x405 * x835 + 2 * x489)
        )
    )
    x1128 = (
        x399 * x905
        - x405 * x877
        + 2 * x628
        + x70
        * (
            x399 * x870
            - x405 * x844
            + 2 * x572
            + x65 * (x399 * x808 - x405 * x811 + 2 * x447)
        )
    )

    # 324 item(s)
    S = numpy.array(
        [
            x102 * x3
            + x134 * x25
            + x135 * x21
            + x21 * (x135 + x136 * x21)
            - x66
            * (x103 + x118 * x72 + x3 * x73 - x66 * (-x109 * x66 + x112 * x72 + x3 * x59))
            + x72
            * (
                x101 * x3
                - x118 * x66
                + x70
                * (
                    x100 * x3
                    - x117 * x66
                    + x65
                    * (
                        -x116 * x66
                        + x3 * x98
                        + x91 * (2 * x19 * x20 * x24 * x28 * x3 * x33 - x84 - x97)
                    )
                    + x91 * (x87 - x99)
                )
                + x91 * (x88 - x94)
            )
            + x91 * (-x74 + x89),
            x134 * x26 + x180 * x21 + x193 + x21 * (x180 + x181 * x21),
            x134 * x27 + x194 * x21 + x21 * (x125 * x195 + x194),
            x193 + x207 * x21 + x209 * x25 + x21 * (x207 + x208 * x21),
            x209 * x26 + x21 * x232 + x21 * (x21 * x233 + x232) + x240,
            x209 * x27 + x21 * x241 + x21 * (x195 * x204 + x241),
            0,
            0,
            0,
            x21 * x248 + x21 * (x21 * x249 + x248) + x240 + x25 * x250,
            x21 * x264
            + x21 * (x21 * x265 + x264)
            + x250 * x26
            + x261 * x3
            - x66 * (x257 * x3 + x262 - x66 * (x255 * x3 - x263 * x66))
            + x91 * (x251 * x3 - x254 - x258),
            x21 * x266 + x21 * (x195 * x245 + x266) + x250 * x27,
            0,
            0,
            0,
            0,
            0,
            0,
            x135 * x22 + x21 * x302 + x318,
            x180 * x22 + x21 * x332 + x342,
            x194 * x22 + x21 * x345 + x346,
            x207 * x22 + x21 * x354 + x358,
            x21 * x368 + x22 * x232 + x375,
            x21 * x377 + x22 * x241 + x378,
            0,
            0,
            0,
            x21 * x383 + x22 * x248 + x386,
            x21 * x392 + x22 * x264 + x395,
            x21 * x397 + x22 * x266 + x398,
            0,
            0,
            0,
            0,
            0,
            0,
            x135 * x23 + x21 * x443 + x465,
            x180 * x23 + x21 * x486 + x500,
            x194 * x23 + x21 * x506 + x516,
            x207 * x23 + x21 * x527 + x531,
            x21 * x545 + x23 * x232 + x554,
            x21 * x558 + x23 * x241 + x565,
            x574,
            x576,
            x586,
            x21 * x592 + x23 * x248 + x595,
            x21 * x602 + x23 * x264 + x605,
            x21 * x608 + x23 * x266 + x612,
            x618,
            x620,
            x625,
            x630,
            x632,
            x638,
            x22 * x302 + x651,
            x22 * x332 + x659,
            x22 * x345 + x660,
            x22 * x354 + x664,
            x22 * x368 + x670,
            x22 * x377 + x671,
            0,
            0,
            0,
            x22 * x383 + x674,
            x22 * x392 + x677,
            x22 * x397 + x678,
            0,
            0,
            0,
            0,
            0,
            0,
            x22 * x443 + x704,
            x22 * x486 + x719,
            x22 * x506 + x729,
            x22 * x527 + x734,
            x22 * x545 + x743,
            x22 * x558 + x751,
            x758,
            x760,
            x767,
            x22 * x592 + x771,
            x22 * x602 + x775,
            x22 * x608 + x781,
            x786,
            x788,
            x793,
            x797,
            x799,
            x803,
            x23 * x443 + x828,
            x23 * x486 + x842,
            x23 * x506 + x850,
            x23 * x527 + x854,
            x23 * x545 + x862,
            x23 * x558 + x868,
            2 * x869 + x873,
            2 * x874 + x875,
            2 * x876 + x882,
            x23 * x592 + x885,
            x23 * x602 + x888,
            x23 * x608 + x892,
            2 * x893 + x896,
            2 * x897 + x898,
            2 * x899 + x903,
            2 * x904 + x907,
            2 * x908 + x909,
            2 * x910 + x913,
            x21 * x301 + x21 * (x21 * x914 + x301) + x318,
            x21 * x331 + x21 * (x21 * x915 + x331) + x342,
            x21 * x344 + x21 * (x195 * x269 + x344) + x346,
            x21 * x353 + x21 * (x21 * x916 + x353) + x358,
            x21 * x367 + x21 * (x21 * x917 + x367) + x375,
            x21 * x376 + x21 * (x195 * x350 + x376) + x378,
            0,
            0,
            0,
            x21 * x382 + x21 * (x21 * x918 + x382) + x386,
            x21 * x391 + x21 * (x21 * x919 + x391) + x395,
            x21 * x396 + x21 * (x195 * x379 + x396) + x398,
            0,
            0,
            0,
            0,
            0,
            0,
            x21 * x921 + x651,
            x21 * x923 + x659,
            x21 * x925 + x660,
            x21 * x927 + x664,
            x21 * x929 + x670,
            x21 * x931 + x671,
            0,
            0,
            0,
            x21 * x933 + x674,
            x21 * x935 + x677,
            x21 * x937 + x678,
            0,
            0,
            0,
            0,
            0,
            0,
            x21 * x939 + x704,
            x21 * x941 + x719,
            x21 * x943 + x729,
            x21 * x945 + x734,
            x21 * x947 + x743,
            x21 * x949 + x751,
            x21 * x950 + x757,
            x21 * x951 + x759,
            x21 * x952 + x766,
            x21 * x954 + x771,
            x21 * x956 + x775,
            x21 * x958 + x781,
            x21 * x959 + x785,
            x21 * x960 + x787,
            x21 * x961 + x792,
            x21 * x962 + x796,
            x21 * x963 + x798,
            x21 * x964 + x802,
            x22 * x920 + x22 * x921 + x25 * x965 + x267 * x646 - x273 * x650 + 2 * x303,
            x22 * x922 + x22 * x923 + x26 * x965 + x966,
            x22 * x924 + x22 * x925 + x27 * x965,
            x22 * x926 + x22 * x927 + x25 * x967 + x966,
            x22 * x928 + x22 * x929 + x26 * x967 + x968,
            x22 * x930 + x22 * x931 + x27 * x967,
            0,
            0,
            0,
            x22 * x932 + x22 * x933 + x25 * x969 + x968,
            x22 * x934
            + x22 * x935
            + x26 * x969
            + x267 * x675
            - x273 * x676
            + 2 * x393
            + x72
            * (
                x267 * x665
                - x273 * x666
                + 2 * x370
                + x70
                * (
                    x267 * x653
                    - x273 * x654
                    + 2 * x335
                    + x65 * (x267 * x642 - x273 * x648 + 2 * x316)
                )
            ),
            x22 * x936 + x22 * x937 + x27 * x969,
            0,
            0,
            0,
            0,
            0,
            0,
            x22 * x939 + x23 * x920 + x971,
            x22 * x941 + x23 * x922 + x973,
            x22 * x943 + x23 * x924 + x975,
            x22 * x945 + x23 * x926 + x977,
            x22 * x947 + x23 * x928 + x979,
            x22 * x949 + x23 * x930 + x981,
            x983,
            x984,
            x986,
            x22 * x954 + x23 * x932 + x988,
            x22 * x956 + x23 * x934 + x989,
            x22 * x958 + x23 * x936 + x991,
            x993,
            x994,
            x996,
            x998,
            x999,
            x1000,
            x1002 + x23 * x939,
            x1004 + x23 * x941,
            x1006 + x23 * x943,
            x1008 + x23 * x945,
            x1010 + x23 * x947,
            x1012 + x23 * x949,
            2 * x1013 + x1015,
            2 * x1016 + x1017,
            2 * x1018 + x1020,
            x1022 + x23 * x954,
            x1023 + x23 * x956,
            x1025 + x23 * x958,
            2 * x1026 + x1028,
            2 * x1029 + x1030,
            2 * x1031 + x1033,
            2 * x1034 + x1036,
            2 * x1037 + x1038,
            2 * x1039 + x1040,
            x21 * x442 + x21 * (x1041 * x21 + x442) + x465,
            x21 * x485 + x21 * (x1042 * x21 + x485) + x500,
            x21 * x505 + x21 * (x1043 * x21 + x505) + x516,
            x21 * x526 + x21 * (x1044 * x21 + x526) + x531,
            x21 * x544 + x21 * (x1045 * x21 + x544) + x554,
            x21 * x557 + x21 * (x1046 * x21 + x557) + x565,
            x21 * (x1047 * x21 + x570) + x574,
            x21 * (x1048 * x21 + x575) + x576,
            x21 * (x1050 * x21 + x581) + x586,
            x21 * x591 + x21 * (x1051 * x21 + x591) + x595,
            x21 * x601 + x21 * (x1052 * x21 + x601) + x605,
            x21 * x607 + x21 * (x1053 * x21 + x607) + x612,
            x21 * (x1054 * x21 + x615) + x618,
            x21 * (x1055 * x21 + x619) + x620,
            x21 * (x1057 * x21 + x622) + x625,
            x21 * (x1059 * x21 + x627) + x630,
            x21 * (x1060 * x21 + x631) + x632,
            x21 * (x1061 * x21 + x637) + x638,
            x1062 * x21 + x22 * x442 + x703,
            x1063 * x21 + x22 * x485 + x718,
            x1064 * x21 + x22 * x505 + x728,
            x1065 * x21 + x22 * x526 + x733,
            x1066 * x21 + x22 * x544 + x742,
            x1067 * x21 + x22 * x557 + x750,
            x1068 * x21 + x758,
            x1069 * x21 + x760,
            x1070 * x21 + x767,
            x1071 * x21 + x22 * x591 + x770,
            x1072 * x21 + x22 * x601 + x774,
            x1073 * x21 + x22 * x607 + x780,
            x1074 * x21 + x786,
            x1075 * x21 + x788,
            x1076 * x21 + x793,
            x1077 * x21 + x797,
            x1078 * x21 + x799,
            x1079 * x21 + x803,
            x1081 * x21 + x828,
            x1083 * x21 + x842,
            x1085 * x21 + x850,
            x1087 * x21 + x854,
            x1089 * x21 + x862,
            x1091 * x21 + x868,
            x1093 * x21 + x869 + x873,
            x1095 * x21 + x874 + x875,
            x1097 * x21 + x876 + x882,
            x1099 * x21 + x885,
            x1101 * x21 + x888,
            x1103 * x21 + x892,
            x1105 * x21 + x893 + x896,
            x1107 * x21 + x897 + x898,
            x1109 * x21 + x899 + x903,
            x1111 * x21 + x904 + x907,
            x1113 * x21 + x908 + x909,
            x1115 * x21 + x910 + x913,
            x1062 * x22 + x22 * x938 + x971,
            x1063 * x22 + x22 * x940 + x973,
            x1064 * x22 + x22 * x942 + x975,
            x1065 * x22 + x22 * x944 + x977,
            x1066 * x22 + x22 * x946 + x979,
            x1067 * x22 + x22 * x948 + x981,
            x1068 * x22 + x983,
            x1069 * x22 + x984,
            x1070 * x22 + x986,
            x1071 * x22 + x22 * x953 + x988,
            x1072 * x22 + x22 * x955 + x989,
            x1073 * x22 + x22 * x957 + x991,
            x1074 * x22 + x993,
            x1075 * x22 + x994,
            x1076 * x22 + x996,
            x1077 * x22 + x998,
            x1078 * x22 + x999,
            x1000 + x1079 * x22,
            x1002 + x1081 * x22,
            x1004 + x1083 * x22,
            x1006 + x1085 * x22,
            x1008 + x1087 * x22,
            x1010 + x1089 * x22,
            x1012 + x1091 * x22,
            x1013 + x1015 + x1093 * x22,
            x1016 + x1017 + x1095 * x22,
            x1018 + x1020 + x1097 * x22,
            x1022 + x1099 * x22,
            x1023 + x1101 * x22,
            x1025 + x1103 * x22,
            x1026 + x1028 + x1105 * x22,
            x1029 + x1030 + x1107 * x22,
            x1031 + x1033 + x1109 * x22,
            x1034 + x1036 + x1111 * x22,
            x1037 + x1038 + x1113 * x22,
            x1039 + x1040 + x1115 * x22,
            x1080 * x23
            + x1081 * x23
            + x1116 * x25
            + x399 * x817
            - x405 * x827
            + 2 * x444,
            x1082 * x23 + x1083 * x23 + x1116 * x26 + x1117,
            x1084 * x23 + x1085 * x23 + x1116 * x27 + x1118,
            x1086 * x23 + x1087 * x23 + x1117 + x1119 * x25,
            x1088 * x23 + x1089 * x23 + x1119 * x26 + x1120,
            x1090 * x23 + x1091 * x23 + x1119 * x27 + x1121,
            x1092 * x23 + x1093 * x23 + x1118 + x1122 * x25,
            x1094 * x23 + x1095 * x23 + x1121 + x1122 * x26,
            x1096 * x23 + x1097 * x23 + x1122 * x27 + x1123,
            x1098 * x23 + x1099 * x23 + x1120 + x1124 * x25,
            x1100 * x23
            + x1101 * x23
            + x1124 * x26
            + x399 * x886
            - x405 * x887
            + 2 * x603,
            x1102 * x23 + x1103 * x23 + x1124 * x27 + x1125,
            x1104 * x23 + x1105 * x23 + x1121 + x1126 * x25,
            x1106 * x23 + x1107 * x23 + x1125 + x1126 * x26,
            x1108 * x23 + x1109 * x23 + x1126 * x27 + x1127,
            x1110 * x23 + x1111 * x23 + x1123 + x1128 * x25,
            x1112 * x23 + x1113 * x23 + x1127 + x1128 * x26,
            x1114 * x23
            + x1115 * x23
            + x1128 * x27
            + x399 * x911
            - x405 * x912
            + 2 * x635
            + x72
            * (
                x399 * x877
                - x405 * x878
                + 2 * x583
                + x70
                * (
                    x399 * x844
                    - x405 * x845
                    + 2 * x512
                    + x65 * (x399 * x811 - x405 * x823 + 2 * x463)
                )
            ),
        ]
    )
    return S


def eri_1222(a, A, b, B, c, C, d, D):
    """Cartesian [pd|dd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x9 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x2 - x22
    x24 = x15 * (c * C[1] + d * D[1])
    x25 = -x1 * (a * A[1] + b * B[1])
    x26 = -x24 - x25
    x27 = -x1 * (a * A[2] + b * B[2])
    x28 = -x15 * (c * C[2] + d * D[2]) - x27
    x29 = x21 * x8 * (x23**2 + x26**2 + x28**2)
    x30 = boys(2, x29)
    x31 = -2 * x10 * x14 * x20 * x30 * x6
    x32 = x0 * x21
    x33 = boys(3, x29)
    x34 = 2 * x10 * x14 * x20 * x6
    x35 = x33 * x34
    x36 = x5 * (-x31 - x32 * x35)
    x37 = x22 - C[0]
    x38 = x30 * x34
    x39 = x23 * x32
    x40 = x35 * x39 + x37 * x38
    x41 = boys(4, x29)
    x42 = x34 * x41
    x43 = x35 * x37 + x39 * x42
    x44 = x32 * x43
    x45 = x23 * x44 + x36 + x37 * x40
    x46 = x32 * x45
    x47 = boys(1, x29)
    x48 = x5 * (2 * x10 * x14 * x20 * x47 * x6 - x32 * x38)
    x49 = x34 * x47
    x50 = x37 * x49 + x38 * x39
    x51 = x32 * x40
    x52 = x23 * x51 + x37 * x50 + x48
    x53 = 3 * x5
    x54 = 2 * x5
    x55 = x23 * x46 + x37 * x52 + x54 * (x50 - x51)
    x56 = -2 * x10 * x14 * x20 * x33 * x6
    x57 = x5 * (-x32 * x42 - x56)
    x58 = boys(5, x29)
    x59 = x34 * x58
    x60 = x37 * x42 + x39 * x59
    x61 = x32 * x60
    x62 = x23 * x61 + x37 * x43 + x57
    x63 = x32 * x62
    x64 = x23 * x63 + x37 * x45 + x54 * (x40 - x44)
    x65 = x37 * x55 + x39 * x64 + x53 * (-x46 + x52)
    x66 = -2 * x10 * x14 * x20 * x41 * x6
    x67 = x5 * (-x32 * x59 - x66)
    x68 = x34 * boys(6, x29)
    x69 = x37 * x59 + x39 * x68
    x70 = x32 * x69
    x71 = x23 * x70 + x37 * x60 + x67
    x72 = x32 * x71
    x73 = x23 * x72 + x37 * x62 + x54 * (x43 - x61)
    x74 = x37 * x64 + x39 * x73 + x53 * (x45 - x63)
    x75 = x21 * x7
    x76 = x74 * x75
    x77 = x73 * x75
    x78 = x71 * x75
    x79 = 2 * a + 2 * b
    x80 = x4 + x79
    x81 = x80 ** (-1.0)
    x82 = x23 * x75
    x83 = x3 * x59 - x68 * x82
    x84 = x69 * x75
    x85 = -x23 * x84 + x3 * x60 + x81 * x83
    x86 = 2 * x81
    x87 = -x23 * x78 + x3 * x62 + x85 * x86
    x88 = 3 * x81
    x89 = -x23 * x77 + x3 * x64 + x87 * x88
    x90 = 4 * x81
    x91 = -x23 * x76 + x3 * x65 + x89 * x90
    x92 = x75 * x91
    x93 = x32 * x52
    x94 = boys(0, x29)
    x95 = x5 * (2 * x10 * x14 * x20 * x6 * x94 - x32 * x49)
    x96 = x34 * x94
    x97 = x37 * x96 + x39 * x49
    x98 = x32 * x50
    x99 = x23 * x98 + x37 * x97 + x95
    x100 = x23 * x93 + x37 * x99 + x54 * (x97 - x98)
    x101 = x100 * x37 + x39 * x55 + x53 * (-x93 + x99)
    x102 = x65 * x75
    x103 = x64 * x75
    x104 = x62 * x75
    x105 = x59 * x82
    x106 = -x105 + x3 * x42
    x107 = x60 * x75
    x108 = x106 * x81 - x107 * x23 + x3 * x43
    x109 = -x104 * x23 + x108 * x86 + x3 * x45
    x110 = -x103 * x23 + x109 * x88 + x3 * x55
    x111 = x101 * x3 - x102 * x23 + x110 * x90
    x112 = x79 ** (-1.0)
    x113 = 2 * x112
    x114 = x112 * (x101 - x102)
    x115 = x112 * (-x103 + x55)
    x116 = x75 * x89
    x117 = x112 * (-x104 + x45)
    x118 = x75 * x87
    x119 = x112 * (-x107 + x43)
    x120 = x112 * (-x59 * x75 - x66)
    x121 = x75 * x83
    x122 = x106 * x3 + x120 - x121 * x23
    x123 = x75 * x85
    x124 = x108 * x3 + x119 + x122 * x81 - x123 * x23
    x125 = x109 * x3 + x117 - x118 * x23 + x124 * x86
    x126 = x110 * x3 + x115 - x116 * x23 + x125 * x88
    x127 = x111 * x3 + x114 + x126 * x90 - x23 * x92
    x128 = x112 * (x65 - x76)
    x129 = -2 * x10 * x14 * x20 * x58 * x6
    x130 = x5 * (-x129 - x32 * x68)
    x131 = x34 * boys(7, x29)
    x132 = x131 * x39 + x37 * x68
    x133 = x130 + x132 * x39 + x37 * x69
    x134 = x133 * x39 + x37 * x71 + x54 * (x60 - x70)
    x135 = x134 * x39 + x37 * x73 + x53 * (x62 - x72)
    x136 = -x131 * x82 + x3 * x68
    x137 = -x132 * x82 + x136 * x81 + x3 * x69
    x138 = -x133 * x82 + x137 * x86 + x3 * x71
    x139 = -x134 * x82 + x138 * x88 + x3 * x73
    x140 = x112 * (x64 - x77)
    x141 = x112 * (x62 - x78)
    x142 = x112 * (x60 - x84)
    x143 = x112 * (-x129 - x68 * x75)
    x144 = -x136 * x82 + x143 + x3 * x83
    x145 = -x137 * x82 + x142 + x144 * x81 + x3 * x85
    x146 = -x138 * x82 + x141 + x145 * x86 + x3 * x87
    x147 = -x139 * x82 + x140 + x146 * x88 + x3 * x89
    x148 = x110 * x75
    x149 = x55 * x75
    x150 = x45 * x75
    x151 = x42 * x82
    x152 = -x151 + x3 * x35
    x153 = x43 * x75
    x154 = x152 * x81 - x153 * x23 + x3 * x40
    x155 = -x150 * x23 + x154 * x86 + x3 * x52
    x156 = x100 * x3 - x149 * x23 + x155 * x88
    x157 = x112 * (x100 - x149)
    x158 = x112 * (-x150 + x52)
    x159 = x109 * x75
    x160 = x112 * (-x153 + x40)
    x161 = x112 * (-x42 * x75 - x56)
    x162 = x106 * x75
    x163 = x152 * x3 + x161 - x162 * x23
    x164 = x108 * x75
    x165 = x154 * x3 + x160 + x163 * x81 - x164 * x23
    x166 = x155 * x3 + x158 - x159 * x23 + x165 * x86
    x167 = -x148 * x23 + x156 * x3 + x157 + x166 * x88
    x168 = (
        x113 * (-x148 + x156)
        - x126 * x82
        + x167 * x3
        + x88
        * (
            x113 * (x155 - x159)
            - x125 * x82
            + x166 * x3
            + x86
            * (
                x113 * (x154 - x164)
                - x124 * x82
                + x165 * x3
                + x81
                * (
                    x113 * (2 * x10 * x14 * x20 * x3 * x33 * x6 - x151 - x162)
                    - x122 * x82
                    + x163 * x3
                )
            )
        )
    )
    x169 = x155 * x75
    x170 = x52 * x75
    x171 = x35 * x82
    x172 = -x171 + x3 * x38
    x173 = x40 * x75
    x174 = x172 * x81 - x173 * x23 + x3 * x50
    x175 = -x170 * x23 + x174 * x86 + x3 * x99
    x176 = x112 * (-x170 + x99)
    x177 = x112 * (-x173 + x50)
    x178 = x112 * (-x31 - x35 * x75)
    x179 = x152 * x75
    x180 = x172 * x3 + x178 - x179 * x23
    x181 = x154 * x75
    x182 = x174 * x3 + x177 + x180 * x81 - x181 * x23
    x183 = -x169 * x23 + x175 * x3 + x176 + x182 * x86
    x184 = (
        x113 * (-x169 + x175)
        - x166 * x82
        + x183 * x3
        + x86
        * (
            x113 * (x174 - x181)
            - x165 * x82
            + x182 * x3
            + x81
            * (
                x113 * (2 * x10 * x14 * x20 * x3 * x30 * x6 - x171 - x179)
                - x163 * x82
                + x180 * x3
            )
        )
    )
    x185 = x16 * x184
    x186 = x16 * x183
    x187 = x127 + x16 * x167 + x16 * (x167 + x186)
    x188 = x16 * x175
    x189 = x111 + x156 * x16 + x16 * (x156 + x188)
    x190 = x17 * x183
    x191 = x24 - C[1]
    x192 = x26 * x32
    x193 = x191 * x38 + x192 * x35
    x194 = x193 * x32
    x195 = x191 * x49 + x192 * x38
    x196 = x5 * (-x194 + x195)
    x197 = x194 * x23 + x195 * x37
    x198 = x191 * x35 + x192 * x42
    x199 = x198 * x32
    x200 = x193 * x37 + x199 * x23
    x201 = x200 * x32
    x202 = x196 + x197 * x37 + x201 * x23
    x203 = x202 * x75
    x204 = x195 * x32
    x205 = x191 * x96 + x192 * x49
    x206 = x5 * (-x204 + x205)
    x207 = x204 * x23 + x205 * x37
    x208 = x197 * x32
    x209 = x206 + x207 * x37 + x208 * x23
    x210 = x112 * (-x203 + x209)
    x211 = x198 * x75
    x212 = x211 * x23
    x213 = x193 * x3 - x212
    x214 = x200 * x75
    x215 = x197 * x3 + x213 * x81 - x214 * x23
    x216 = -x203 * x23 + x209 * x3 + x215 * x86
    x217 = x5 * (x193 - x199)
    x218 = x191 * x42 + x192 * x59
    x219 = x218 * x32
    x220 = x198 * x37 + x219 * x23
    x221 = x220 * x32
    x222 = x200 * x37 + x217 + x221 * x23
    x223 = x222 * x75
    x224 = x218 * x75
    x225 = x224 * x23
    x226 = x198 * x3 - x225
    x227 = x220 * x75
    x228 = x200 * x3 + x226 * x81 - x227 * x23
    x229 = x202 * x3 - x223 * x23 + x228 * x86
    x230 = x229 * x75
    x231 = x112 * (x197 - x214)
    x232 = x112 * (x193 - x211)
    x233 = x226 * x75
    x234 = x213 * x3 - x23 * x233 + x232
    x235 = x228 * x75
    x236 = x215 * x3 - x23 * x235 + x231 + x234 * x81
    x237 = x210 + x216 * x3 - x23 * x230 + x236 * x86
    x238 = x190 + x237
    x239 = x202 * x37 + x222 * x39 + x54 * (x197 - x201)
    x240 = x239 * x75
    x241 = x202 * x39 + x209 * x37 + x54 * (x207 - x208)
    x242 = x112 * (-x240 + x241)
    x243 = x229 * x88 - x23 * x240 + x241 * x3
    x244 = x5 * (x198 - x219)
    x245 = x191 * x59 + x192 * x68
    x246 = x245 * x32
    x247 = x218 * x37 + x23 * x246
    x248 = x247 * x32
    x249 = x220 * x37 + x23 * x248 + x244
    x250 = x222 * x37 + x249 * x39 + x54 * (x200 - x221)
    x251 = x250 * x75
    x252 = x249 * x75
    x253 = x245 * x75
    x254 = x218 * x3 - x23 * x253
    x255 = x247 * x75
    x256 = x220 * x3 - x23 * x255 + x254 * x81
    x257 = x222 * x3 - x23 * x252 + x256 * x86
    x258 = -x23 * x251 + x239 * x3 + x257 * x88
    x259 = x258 * x75
    x260 = x112 * (x202 - x223)
    x261 = x257 * x75
    x262 = x112 * (x200 - x227)
    x263 = x112 * (x198 - x224)
    x264 = x254 * x75
    x265 = x226 * x3 - x23 * x264 + x263
    x266 = x256 * x75
    x267 = x228 * x3 - x23 * x266 + x262 + x265 * x81
    x268 = x229 * x3 - x23 * x261 + x260 + x267 * x86
    x269 = -x23 * x259 + x242 + x243 * x3 + x268 * x88
    x270 = x16 * x238 + x167 * x17 + x269
    x271 = x17 * x175
    x272 = x216 + x271
    x273 = x156 * x17 + x16 * x272 + x243
    x274 = x17 * x184
    x275 = (
        x113 * (x216 - x230)
        + x237 * x3
        - x268 * x82
        + x86
        * (
            x113 * (x215 - x235)
            + x236 * x3
            - x267 * x82
            + x81 * (x113 * (x193 * x3 - x212 - x233) + x234 * x3 - x265 * x82)
        )
    )
    x276 = x274 + x275
    x277 = x112 * (x222 - x252)
    x278 = x5 * (x218 - x246)
    x279 = x131 * x192 + x191 * x68
    x280 = x245 * x37 + x279 * x39
    x281 = x247 * x37 + x278 + x280 * x39
    x282 = x245 * x3 - x279 * x82
    x283 = x247 * x3 - x280 * x82 + x282 * x81
    x284 = x249 * x3 - x281 * x82 + x283 * x86
    x285 = x112 * (x220 - x255)
    x286 = x112 * (x218 - x253)
    x287 = x254 * x3 - x282 * x82 + x286
    x288 = x256 * x3 - x283 * x82 + x285 + x287 * x81
    x289 = x257 * x3 + x277 - x284 * x82 + x288 * x86
    x290 = x112 * (x239 - x251)
    x291 = x249 * x37 + x281 * x39 + x54 * (x220 - x248)
    x292 = (
        x113 * (x243 - x259)
        + x269 * x3
        - x82
        * (x258 * x3 + x289 * x88 + x290 - x82 * (x250 * x3 + x284 * x88 - x291 * x82))
        + x88
        * (
            x113 * (x229 - x261)
            + x268 * x3
            - x289 * x82
            + x86
            * (
                x113 * (x228 - x266)
                + x267 * x3
                - x288 * x82
                + x81 * (x113 * (x198 * x3 - x225 - x264) + x265 * x3 - x287 * x82)
            )
        )
    )
    x293 = x167 * x18 + x18 * x186
    x294 = x156 * x18 + x18 * x188
    x295 = x191 * x193 + x199 * x26 + x36
    x296 = x295 * x32
    x297 = x191 * x195 + x194 * x26 + x48
    x298 = x5 * (-x296 + x297)
    x299 = x23 * x296 + x297 * x37
    x300 = x191 * x198 + x219 * x26 + x57
    x301 = x300 * x32
    x302 = x23 * x301 + x295 * x37
    x303 = x298 + x299 * x37 + x302 * x39
    x304 = x303 * x75
    x305 = x297 * x32
    x306 = x191 * x205 + x204 * x26 + x95
    x307 = x5 * (-x305 + x306)
    x308 = x23 * x305 + x306 * x37
    x309 = x299 * x39 + x307 + x308 * x37
    x310 = x112 * (-x304 + x309)
    x311 = x300 * x75
    x312 = x23 * x311
    x313 = x295 * x3 - x312
    x314 = x302 * x75
    x315 = -x23 * x314 + x299 * x3 + x313 * x81
    x316 = -x23 * x304 + x3 * x309 + x315 * x86
    x317 = x5 * (x295 - x301)
    x318 = x191 * x218 + x246 * x26 + x67
    x319 = x318 * x32
    x320 = x23 * x319 + x300 * x37
    x321 = x302 * x37 + x317 + x320 * x39
    x322 = x321 * x75
    x323 = x318 * x75
    x324 = -x23 * x323 + x3 * x300
    x325 = x320 * x75
    x326 = -x23 * x325 + x3 * x302 + x324 * x81
    x327 = -x23 * x322 + x3 * x303 + x326 * x86
    x328 = x327 * x75
    x329 = x112 * (x299 - x314)
    x330 = x112 * (x295 - x311)
    x331 = x324 * x75
    x332 = -x23 * x331 + x3 * x313 + x330
    x333 = x326 * x75
    x334 = -x23 * x333 + x3 * x315 + x329 + x332 * x81
    x335 = -x23 * x328 + x3 * x316 + x310 + x334 * x86
    x336 = x17 * x237 + x335
    x337 = x17 * x238 + x336
    x338 = x17 * x216 + x316
    x339 = x17 * x272 + x338
    x340 = x112 * (x300 - x323)
    x341 = x130 + x191 * x245 + x192 * x279
    x342 = x3 * x318 - x341 * x82
    x343 = x3 * x324 + x340 - x342 * x82
    x344 = x112 * (x302 - x325)
    x345 = x318 * x37 + x341 * x39
    x346 = x3 * x320 + x342 * x81 - x345 * x82
    x347 = x3 * x326 + x343 * x81 + x344 - x346 * x82
    x348 = x112 * (x303 - x322)
    x349 = x5 * (x300 - x319)
    x350 = x320 * x37 + x345 * x39 + x349
    x351 = (
        x113 * (x316 - x328)
        + x3 * x335
        - x82
        * (x3 * x327 + x347 * x86 + x348 - x82 * (x3 * x321 + x346 * x86 - x350 * x82))
        + x86
        * (
            x113 * (x315 - x333)
            + x3 * x334
            - x347 * x82
            + x81 * (x113 * (x295 * x3 - x312 - x331) + x3 * x332 - x343 * x82)
        )
    )
    x352 = x17 * x275 + x351
    x353 = x18 * x237
    x354 = x18 * x190 + x353
    x355 = x18 * x216
    x356 = x18 * x271 + x355
    x357 = x18 * x275
    x358 = x183 * x19
    x359 = x11 * x19
    x360 = x197 * x75
    x361 = x112 * (x207 - x360)
    x362 = x193 * x75
    x363 = x112 * (x195 - x362)
    x364 = x23 * x362
    x365 = x195 * x3 - x364
    x366 = x213 * x75
    x367 = -x23 * x366 + x3 * x365 + x363
    x368 = x207 * x3 - x23 * x360 + x365 * x81
    x369 = x215 * x75
    x370 = -x23 * x369 + x3 * x368 + x361 + x367 * x81
    x371 = x16 * x370
    x372 = x16 * x237 + x16 * (x237 + x371) + x269
    x373 = x16 * x368
    x374 = x16 * x216 + x16 * (x216 + x373) + x243
    x375 = (
        x113 * (x368 - x369)
        - x236 * x82
        + x3 * x370
        + x81 * (x113 * (x195 * x3 - x364 - x366) - x234 * x82 + x3 * x367)
    )
    x376 = x16 * x375
    x377 = x17 * x370
    x378 = x299 * x75
    x379 = x112 * (x308 - x378)
    x380 = x295 * x75
    x381 = x112 * (x297 - x380)
    x382 = x23 * x380
    x383 = x297 * x3 - x382
    x384 = x313 * x75
    x385 = -x23 * x384 + x3 * x383 + x381
    x386 = -x23 * x378 + x3 * x308 + x383 * x81
    x387 = x315 * x75
    x388 = -x23 * x387 + x3 * x386 + x379 + x385 * x81
    x389 = x377 + x388
    x390 = x16 * x389 + x336
    x391 = x17 * x368
    x392 = x386 + x391
    x393 = x16 * x392 + x338
    x394 = x17 * x375
    x395 = (
        x113 * (x386 - x387)
        + x3 * x388
        - x334 * x82
        + x81 * (x113 * (x297 * x3 - x382 - x384) + x3 * x385 - x332 * x82)
    )
    x396 = x394 + x395
    x397 = x18 * x371 + x353
    x398 = x18 * x373 + x355
    x399 = x191 * x297 + 2 * x196 + x26 * x296
    x400 = x191 * x295 + 2 * x217 + x26 * x301
    x401 = x37 * x399 + x39 * x400
    x402 = x401 * x75
    x403 = x191 * x306 + 2 * x206 + x26 * x305
    x404 = x37 * x403 + x39 * x399
    x405 = x112 * (-x402 + x404)
    x406 = x400 * x75
    x407 = x112 * (x399 - x406)
    x408 = x23 * x406
    x409 = x3 * x399 - x408
    x410 = x191 * x300 + 2 * x244 + x26 * x319
    x411 = x410 * x75
    x412 = -x23 * x411 + x3 * x400
    x413 = x412 * x75
    x414 = -x23 * x413 + x3 * x409 + x407
    x415 = -x23 * x402 + x3 * x404 + x409 * x81
    x416 = x37 * x400 + x39 * x410
    x417 = x416 * x75
    x418 = -x23 * x417 + x3 * x401 + x412 * x81
    x419 = x418 * x75
    x420 = -x23 * x419 + x3 * x415 + x405 + x414 * x81
    x421 = x17 * x388 + x420
    x422 = x17 * x389 + x421
    x423 = x17 * x386 + x415
    x424 = x17 * x392 + x423
    x425 = x112 * (x400 - x411)
    x426 = x191 * x318 + x192 * x341 + 2 * x278
    x427 = x3 * x410 - x426 * x82
    x428 = x3 * x412 + x425 - x427 * x82
    x429 = x112 * (x401 - x417)
    x430 = x37 * x410 + x39 * x426
    x431 = (
        x113 * (x415 - x419)
        + x17 * x395
        + x3 * x420
        + x81 * (x113 * (x3 * x399 - x408 - x413) + x3 * x414 - x428 * x82)
        - x82
        * (x3 * x418 + x428 * x81 + x429 - x82 * (x3 * x416 + x427 * x81 - x430 * x82))
    )
    x432 = x18 * x388
    x433 = x18 * x377 + x432
    x434 = x18 * x386
    x435 = x18 * x391 + x434
    x436 = x18 * x395
    x437 = x19 * x370
    x438 = x297 * x75
    x439 = x112 * (x306 - x438)
    x440 = x23 * x438
    x441 = x3 * x306 - x440
    x442 = x383 * x75
    x443 = -x23 * x442 + x3 * x441 + x439
    x444 = x16 * x443
    x445 = x16 * x388 + x16 * (x388 + x444) + x335
    x446 = x16 * x441
    x447 = x16 * x386 + x16 * (x386 + x446) + x316
    x448 = x113 * (x3 * x306 - x440 - x442) + x3 * x443 - x385 * x82
    x449 = x16 * x448
    x450 = x17 * x443
    x451 = x399 * x75
    x452 = x112 * (x403 - x451)
    x453 = x23 * x451
    x454 = x3 * x403 - x453
    x455 = x409 * x75
    x456 = -x23 * x455 + x3 * x454 + x452
    x457 = x450 + x456
    x458 = x16 * x457 + x421
    x459 = x17 * x441
    x460 = x454 + x459
    x461 = x16 * x460 + x423
    x462 = x17 * x448
    x463 = x113 * (x3 * x403 - x453 - x455) + x3 * x456 - x414 * x82
    x464 = x462 + x463
    x465 = x18 * x444 + x432
    x466 = x18 * x446 + x434
    x467 = x191 * x403 + x192 * x399 + 3 * x307
    x468 = x191 * x399 + x192 * x400 + 3 * x298
    x469 = x468 * x75
    x470 = x23 * x469
    x471 = x191 * x400 + x192 * x410 + 3 * x317
    x472 = x471 * x75
    x473 = -x23 * x472 + x3 * x468
    x474 = x473 * x75
    x475 = x112 * (x467 - x469)
    x476 = x3 * x467 - x470
    x477 = -x23 * x474 + x3 * x476 + x475
    x478 = x112 * (x468 - x472)
    x479 = x191 * x410 + x192 * x426 + 3 * x349
    x480 = x17 * x456 + x17 * x457 + x477
    x481 = x17 * x454 + x17 * x460 + x476
    x482 = x18 * x450 + x18 * x456
    x483 = x18 * x454 + x18 * x459
    x484 = x19 * x443
    x485 = -x25 - A[1]
    x486 = x149 * x26
    x487 = x100 * x485 - x486
    x488 = x103 * x26
    x489 = x485 * x55 - x488
    x490 = x489 * x75
    x491 = x150 * x26
    x492 = x485 * x52 - x491
    x493 = x104 * x26
    x494 = x45 * x485 - x493
    x495 = x494 * x75
    x496 = x26 * x75
    x497 = x42 * x496
    x498 = x35 * x485 - x497
    x499 = x496 * x59
    x500 = x42 * x485 - x499
    x501 = x500 * x75
    x502 = -x23 * x501 + x3 * x498
    x503 = x153 * x26
    x504 = x40 * x485 - x503
    x505 = x107 * x26
    x506 = x43 * x485 - x505
    x507 = x506 * x75
    x508 = -x23 * x507 + x3 * x504 + x502 * x81
    x509 = -x23 * x495 + x3 * x492 + x508 * x86
    x510 = -x23 * x490 + x3 * x487 + x509 * x88
    x511 = x170 * x26
    x512 = x485 * x99 - x511
    x513 = x492 * x75
    x514 = x35 * x496
    x515 = x38 * x485 - x514
    x516 = x498 * x75
    x517 = -x23 * x516 + x3 * x515
    x518 = x173 * x26
    x519 = x485 * x50 - x518
    x520 = x504 * x75
    x521 = -x23 * x520 + x3 * x519 + x517 * x81
    x522 = -x23 * x513 + x3 * x512 + x521 * x86
    x523 = x16 * x522
    x524 = x102 * x26
    x525 = x101 * x485 - x524
    x526 = -x26 * x76 + x485 * x65
    x527 = x526 * x75
    x528 = -x26 * x77 + x485 * x64
    x529 = x528 * x75
    x530 = -x26 * x78 + x485 * x62
    x531 = x530 * x75
    x532 = x485 * x59 - x496 * x68
    x533 = x532 * x75
    x534 = -x23 * x533 + x3 * x500
    x535 = -x26 * x84 + x485 * x60
    x536 = x535 * x75
    x537 = -x23 * x536 + x3 * x506 + x534 * x81
    x538 = -x23 * x531 + x3 * x494 + x537 * x86
    x539 = -x23 * x529 + x3 * x489 + x538 * x88
    x540 = -x23 * x527 + x3 * x525 + x539 * x90
    x541 = x16 * x510 + x16 * (x510 + x523) + x540
    x542 = x12 * x189 + x541
    x543 = x112 * (x101 * x485 - x524 - x527)
    x544 = x112 * (x100 * x485 - x486 - x490)
    x545 = x112 * (x485 * x52 - x491 - x495)
    x546 = x112 * (x40 * x485 - x503 - x507)
    x547 = x112 * (2 * x10 * x14 * x20 * x33 * x485 * x6 - x497 - x501)
    x548 = (
        x3 * x510
        - x539 * x82
        + x544
        + x88
        * (
            x3 * x509
            - x538 * x82
            + x545
            + x86
            * (x3 * x508 - x537 * x82 + x546 + x81 * (x3 * x502 - x534 * x82 + x547))
        )
    )
    x549 = x112 * (x485 * x99 - x511 - x513)
    x550 = x112 * (x485 * x50 - x518 - x520)
    x551 = x112 * (2 * x10 * x14 * x20 * x30 * x485 * x6 - x514 - x516)
    x552 = (
        x3 * x522
        - x509 * x82
        + x549
        + x86 * (x3 * x521 - x508 * x82 + x550 + x81 * (x3 * x517 - x502 * x82 + x551))
    )
    x553 = x16 * x552
    x554 = x112 * (x485 * x55 - x488 - x529)
    x555 = -x134 * x496 + x485 * x73
    x556 = -x133 * x496 + x485 * x71
    x557 = -x131 * x496 + x485 * x68
    x558 = x3 * x532 - x557 * x82
    x559 = -x132 * x496 + x485 * x69
    x560 = x3 * x535 + x558 * x81 - x559 * x82
    x561 = x3 * x530 - x556 * x82 + x560 * x86
    x562 = x3 * x528 - x555 * x82 + x561 * x88
    x563 = x112 * (x45 * x485 - x493 - x531)
    x564 = x112 * (x43 * x485 - x505 - x536)
    x565 = x112 * (2 * x10 * x14 * x20 * x41 * x485 * x6 - x499 - x533)
    x566 = -x135 * x496 + x485 * x74
    x567 = (
        x16 * x548
        + x16 * (x548 + x553)
        + x3 * x540
        + x543
        - x82 * (x3 * x526 + x562 * x90 - x566 * x82)
        + x90
        * (
            x3 * x539
            + x554
            - x562 * x82
            + x88
            * (
                x3 * x538
                - x561 * x82
                + x563
                + x86
                * (x3 * x537 - x560 * x82 + x564 + x81 * (x3 * x534 - x558 * x82 + x565))
            )
        )
    )
    x568 = x17 * x522
    x569 = -x203 * x26 + x209 * x485 + x492 * x81
    x570 = x202 * x485 - x223 * x26 + x494 * x81
    x571 = x570 * x75
    x572 = x193 * x485 - x211 * x26 + x498 * x81
    x573 = x198 * x485 - x224 * x26 + x500 * x81
    x574 = x573 * x75
    x575 = -x23 * x574 + x3 * x572
    x576 = x197 * x485 - x214 * x26 + x504 * x81
    x577 = x200 * x485 - x227 * x26 + x506 * x81
    x578 = x577 * x75
    x579 = -x23 * x578 + x3 * x576 + x575 * x81
    x580 = -x23 * x571 + x3 * x569 + x579 * x86
    x581 = x568 + x580
    x582 = -x240 * x26 + x241 * x485 + x489 * x81
    x583 = x239 * x485 - x251 * x26 + x528 * x81
    x584 = x583 * x75
    x585 = x222 * x485 - x252 * x26 + x530 * x81
    x586 = x585 * x75
    x587 = x218 * x485 - x253 * x26 + x532 * x81
    x588 = x587 * x75
    x589 = -x23 * x588 + x3 * x573
    x590 = x220 * x485 - x255 * x26 + x535 * x81
    x591 = x590 * x75
    x592 = -x23 * x591 + x3 * x577 + x589 * x81
    x593 = -x23 * x586 + x3 * x570 + x592 * x86
    x594 = -x23 * x584 + x3 * x582 + x593 * x88
    x595 = x16 * x581 + x17 * x510 + x594
    x596 = x12 * x273 + x595
    x597 = x17 * x552
    x598 = x112 * (x569 - x571)
    x599 = x112 * (x576 - x578)
    x600 = x112 * (x572 - x574)
    x601 = (
        x3 * x580
        - x593 * x82
        + x598
        + x86 * (x3 * x579 - x592 * x82 + x599 + x81 * (x3 * x575 - x589 * x82 + x600))
    )
    x602 = x597 + x601
    x603 = x112 * (x582 - x584)
    x604 = x112 * (x570 - x586)
    x605 = x249 * x485 - x281 * x496 + x556 * x81
    x606 = x245 * x485 - x279 * x496 + x557 * x81
    x607 = x3 * x587 - x606 * x82
    x608 = x247 * x485 - x280 * x496 + x559 * x81
    x609 = x3 * x590 + x607 * x81 - x608 * x82
    x610 = x3 * x585 - x605 * x82 + x609 * x86
    x611 = x112 * (x577 - x591)
    x612 = x112 * (x573 - x588)
    x613 = x250 * x485 - x291 * x496 + x555 * x81
    x614 = (
        x3 * x594
        + x603
        - x82 * (x3 * x583 + x610 * x88 - x613 * x82)
        + x88
        * (
            x3 * x593
            + x604
            - x610 * x82
            + x86
            * (x3 * x592 - x609 * x82 + x611 + x81 * (x3 * x589 - x607 * x82 + x612))
        )
    )
    x615 = x16 * x602 + x17 * x548 + x614
    x616 = x18 * x510 + x18 * x523
    x617 = x12 * x294 + x616
    x618 = x18 * x548 + x18 * x553
    x619 = -x26 * x304 + x309 * x485 + x570 * x86
    x620 = -x26 * x322 + x303 * x485 + x585 * x86
    x621 = x620 * x75
    x622 = -x26 * x311 + x295 * x485 + x573 * x86
    x623 = -x26 * x323 + x300 * x485 + x587 * x86
    x624 = x623 * x75
    x625 = -x23 * x624 + x3 * x622
    x626 = -x26 * x314 + x299 * x485 + x577 * x86
    x627 = -x26 * x325 + x302 * x485 + x590 * x86
    x628 = x627 * x75
    x629 = -x23 * x628 + x3 * x626 + x625 * x81
    x630 = -x23 * x621 + x3 * x619 + x629 * x86
    x631 = x17 * x580 + x630
    x632 = x17 * x581 + x631
    x633 = x12 * x339 + x632
    x634 = x112 * (x619 - x621)
    x635 = x112 * (x626 - x628)
    x636 = x112 * (x622 - x624)
    x637 = x318 * x485 - x341 * x496 + x606 * x86
    x638 = x3 * x623 - x637 * x82
    x639 = x320 * x485 - x345 * x496 + x608 * x86
    x640 = x3 * x627 + x638 * x81 - x639 * x82
    x641 = x321 * x485 - x350 * x496 + x605 * x86
    x642 = (
        x3 * x630
        + x634
        - x82 * (x3 * x620 + x640 * x86 - x641 * x82)
        + x86 * (x3 * x629 + x635 - x640 * x82 + x81 * (x3 * x625 + x636 - x638 * x82))
    )
    x643 = x17 * x601 + x642
    x644 = x17 * x602 + x643
    x645 = x18 * x580
    x646 = x18 * x568 + x645
    x647 = x12 * x356 + x646
    x648 = x18 * x601
    x649 = x18 * x597 + x648
    x650 = x12 * x19
    x651 = x19 * x522
    x652 = x175 * x650 + x651
    x653 = x19 * x552
    x654 = x195 * x485 - x26 * x362 + x515 * x81
    x655 = x572 * x75
    x656 = -x23 * x655 + x3 * x654
    x657 = x207 * x485 - x26 * x360 + x519 * x81
    x658 = x576 * x75
    x659 = -x23 * x658 + x3 * x657 + x656 * x81
    x660 = x16 * x659
    x661 = x16 * x580 + x16 * (x580 + x660) + x594
    x662 = x12 * x374 + x661
    x663 = x112 * (x657 - x658)
    x664 = x112 * (x654 - x655)
    x665 = x3 * x659 - x579 * x82 + x663 + x81 * (x3 * x656 - x575 * x82 + x664)
    x666 = x16 * x665
    x667 = x16 * x601 + x16 * (x601 + x666) + x614
    x668 = x17 * x659
    x669 = -x26 * x380 + x297 * x485 + x572 * x86
    x670 = x622 * x75
    x671 = -x23 * x670 + x3 * x669
    x672 = -x26 * x378 + x308 * x485 + x576 * x86
    x673 = x626 * x75
    x674 = -x23 * x673 + x3 * x672 + x671 * x81
    x675 = x668 + x674
    x676 = x16 * x675 + x631
    x677 = x12 * x393 + x676
    x678 = x17 * x665
    x679 = x112 * (x672 - x673)
    x680 = x112 * (x669 - x670)
    x681 = x3 * x674 - x629 * x82 + x679 + x81 * (x3 * x671 - x625 * x82 + x680)
    x682 = x678 + x681
    x683 = x16 * x682 + x643
    x684 = x18 * x660 + x645
    x685 = x12 * x398 + x684
    x686 = x18 * x666 + x648
    x687 = -x26 * x406 + x399 * x485 + x622 * x88
    x688 = -x26 * x411 + x400 * x485 + x623 * x88
    x689 = x688 * x75
    x690 = -x23 * x689 + x3 * x687
    x691 = -x26 * x402 + x404 * x485 + x626 * x88
    x692 = -x26 * x417 + x401 * x485 + x627 * x88
    x693 = x692 * x75
    x694 = -x23 * x693 + x3 * x691 + x690 * x81
    x695 = x17 * x674 + x694
    x696 = x17 * x675 + x695
    x697 = x12 * x424 + x696
    x698 = x112 * (x691 - x693)
    x699 = x112 * (x687 - x689)
    x700 = x410 * x485 - x426 * x496 + x637 * x88
    x701 = x3 * x688 - x700 * x82
    x702 = x416 * x485 - x430 * x496 + x639 * x88
    x703 = (
        x17 * x681
        + x3 * x694
        + x698
        + x81 * (x3 * x690 + x699 - x701 * x82)
        - x82 * (x3 * x692 + x701 * x81 - x702 * x82)
    )
    x704 = x17 * x682 + x703
    x705 = x18 * x674
    x706 = x18 * x668 + x705
    x707 = x12 * x435 + x706
    x708 = x18 * x681
    x709 = x18 * x678 + x708
    x710 = x19 * x659
    x711 = x368 * x650 + x710
    x712 = x19 * x665
    x713 = -x26 * x438 + x306 * x485 + x654 * x86
    x714 = x669 * x75
    x715 = -x23 * x714 + x3 * x713
    x716 = x16 * x715
    x717 = x16 * x674 + x16 * (x674 + x716) + x630
    x718 = x12 * x447 + x717
    x719 = x112 * (x713 - x714)
    x720 = x3 * x715 - x671 * x82 + x719
    x721 = x16 * x720
    x722 = x16 * x681 + x16 * (x681 + x721) + x642
    x723 = x17 * x715
    x724 = -x26 * x451 + x403 * x485 + x669 * x88
    x725 = x687 * x75
    x726 = -x23 * x725 + x3 * x724
    x727 = x723 + x726
    x728 = x16 * x727 + x695
    x729 = x12 * x461 + x728
    x730 = x17 * x720
    x731 = x112 * (x724 - x725)
    x732 = x3 * x726 - x690 * x82 + x731
    x733 = x730 + x732
    x734 = x16 * x733 + x703
    x735 = x18 * x716 + x705
    x736 = x12 * x466 + x735
    x737 = x18 * x721 + x708
    x738 = -x26 * x469 + x467 * x485 + x687 * x90
    x739 = -x26 * x472 + x468 * x485 + x688 * x90
    x740 = x739 * x75
    x741 = -x23 * x740 + x3 * x738
    x742 = x17 * x726 + x17 * x727 + x741
    x743 = x12 * x481 + x742
    x744 = x112 * (x738 - x740)
    x745 = x471 * x485 - x479 * x496 + x700 * x90
    x746 = x17 * x732 + x17 * x733 + x3 * x741 + x744 - x82 * (x3 * x739 - x745 * x82)
    x747 = x18 * x723 + x18 * x726
    x748 = x12 * x483 + x747
    x749 = x18 * x730 + x18 * x732
    x750 = x19 * x715
    x751 = x441 * x650 + x750
    x752 = x19 * x720
    x753 = -x27 - A[2]
    x754 = x149 * x28
    x755 = x100 * x753 - x754
    x756 = x103 * x28
    x757 = x55 * x753 - x756
    x758 = x75 * x757
    x759 = x150 * x28
    x760 = x52 * x753 - x759
    x761 = x3 * x760
    x762 = x104 * x28
    x763 = x45 * x753 - x762
    x764 = x75 * x763
    x765 = x28 * x75
    x766 = x42 * x765
    x767 = x35 * x753 - x766
    x768 = x3 * x767
    x769 = x59 * x765
    x770 = x42 * x753 - x769
    x771 = x75 * x770
    x772 = x23 * x771
    x773 = x768 - x772
    x774 = x153 * x28
    x775 = x40 * x753 - x774
    x776 = x3 * x775
    x777 = x107 * x28
    x778 = x43 * x753 - x777
    x779 = x75 * x778
    x780 = x23 * x779
    x781 = x773 * x81 + x776 - x780
    x782 = -x23 * x764 + x761 + x781 * x86
    x783 = -x23 * x758 + x3 * x755 + x782 * x88
    x784 = x170 * x28
    x785 = x753 * x99 - x784
    x786 = x75 * x760
    x787 = x35 * x765
    x788 = x38 * x753 - x787
    x789 = x3 * x788
    x790 = x75 * x767
    x791 = x23 * x790
    x792 = x789 - x791
    x793 = x173 * x28
    x794 = x50 * x753 - x793
    x795 = x3 * x794
    x796 = x75 * x775
    x797 = -x23 * x796 + x792 * x81 + x795
    x798 = -x23 * x786 + x3 * x785 + x797 * x86
    x799 = x102 * x28
    x800 = x101 * x753 - x799
    x801 = -x28 * x76 + x65 * x753
    x802 = x75 * x801
    x803 = x3 * x757
    x804 = -x28 * x77 + x64 * x753
    x805 = x75 * x804
    x806 = x23 * x805
    x807 = x3 * x763
    x808 = -x28 * x78 + x62 * x753
    x809 = x75 * x808
    x810 = x23 * x809
    x811 = x3 * x770
    x812 = x59 * x753 - x68 * x765
    x813 = x75 * x812
    x814 = x23 * x813
    x815 = x811 - x814
    x816 = x3 * x778
    x817 = -x28 * x84 + x60 * x753
    x818 = x75 * x817
    x819 = x23 * x818
    x820 = x81 * x815 + x816 - x819
    x821 = x807 - x810 + x820 * x86
    x822 = x803 - x806 + x821 * x88
    x823 = -x23 * x802 + x3 * x800 + x822 * x90
    x824 = x16 * x783 + x16 * (x16 * x798 + x783) + x823
    x825 = x13 * x189 + x824
    x826 = x112 * (x101 * x753 - x799 - x802)
    x827 = x112 * (x100 * x753 - x754 - x758)
    x828 = x112 * (x52 * x753 - x759 - x764)
    x829 = x112 * (x40 * x753 - x774 - x779)
    x830 = x112 * (2 * x10 * x14 * x20 * x33 * x6 * x753 - x766 - x771)
    x831 = (
        x3 * x783
        - x82 * x822
        + x827
        + x88
        * (
            x3 * x782
            - x82 * x821
            + x828
            + x86
            * (x3 * x781 + x81 * (x3 * x773 - x815 * x82 + x830) - x82 * x820 + x829)
        )
    )
    x832 = x112 * (x753 * x99 - x784 - x786)
    x833 = x112 * (x50 * x753 - x793 - x796)
    x834 = x112 * (2 * x10 * x14 * x20 * x30 * x6 * x753 - x787 - x790)
    x835 = (
        x3 * x798
        - x782 * x82
        + x832
        + x86 * (x3 * x797 - x781 * x82 + x81 * (x3 * x792 - x773 * x82 + x834) + x833)
    )
    x836 = x112 * (x55 * x753 - x756 - x805)
    x837 = x3 * x804
    x838 = -x134 * x765 + x73 * x753
    x839 = x82 * x838
    x840 = x3 * x808
    x841 = -x133 * x765 + x71 * x753
    x842 = x82 * x841
    x843 = x3 * x812
    x844 = -x131 * x765 + x68 * x753
    x845 = x82 * x844
    x846 = x843 - x845
    x847 = x3 * x817
    x848 = -x132 * x765 + x69 * x753
    x849 = x82 * x848
    x850 = x81 * x846 + x847 - x849
    x851 = x840 - x842 + x850 * x86
    x852 = x837 - x839 + x851 * x88
    x853 = x112 * (x45 * x753 - x762 - x809)
    x854 = x112 * (x43 * x753 - x777 - x818)
    x855 = x112 * (2 * x10 * x14 * x20 * x41 * x6 * x753 - x769 - x813)
    x856 = -x135 * x765 + x74 * x753
    x857 = (
        x16 * x831
        + x16 * (x16 * x835 + x831)
        + x3 * x823
        - x82 * (x3 * x801 - x82 * x856 + x852 * x90)
        + x826
        + x90
        * (
            x3 * x822
            - x82 * x852
            + x836
            + x88
            * (
                x3 * x821
                - x82 * x851
                + x853
                + x86
                * (x3 * x820 + x81 * (x3 * x815 - x82 * x846 + x855) - x82 * x850 + x854)
            )
        )
    )
    x858 = x203 * x28
    x859 = x209 * x753 - x858
    x860 = x223 * x28
    x861 = x202 * x753 - x860
    x862 = x75 * x861
    x863 = x214 * x28
    x864 = x197 * x753 - x863
    x865 = x3 * x864
    x866 = x211 * x28
    x867 = x193 * x753 - x866
    x868 = x3 * x867
    x869 = x224 * x28
    x870 = x198 * x753 - x869
    x871 = x75 * x870
    x872 = x23 * x871
    x873 = x868 - x872
    x874 = x227 * x28
    x875 = x200 * x753 - x874
    x876 = x75 * x875
    x877 = -x23 * x876 + x81 * x873 + x865
    x878 = -x23 * x862 + x3 * x859 + x86 * x877
    x879 = x17 * x798 + x878
    x880 = x240 * x28
    x881 = x241 * x753 - x880
    x882 = x239 * x753 - x251 * x28
    x883 = x75 * x882
    x884 = x3 * x861
    x885 = x222 * x753 - x252 * x28
    x886 = x75 * x885
    x887 = x23 * x886
    x888 = x3 * x875
    x889 = x3 * x870
    x890 = x218 * x753 - x253 * x28
    x891 = x75 * x890
    x892 = x23 * x891
    x893 = x889 - x892
    x894 = x220 * x753 - x255 * x28
    x895 = x75 * x894
    x896 = x23 * x895
    x897 = x81 * x893 + x888 - x896
    x898 = x86 * x897 + x884 - x887
    x899 = -x23 * x883 + x3 * x881 + x88 * x898
    x900 = x16 * x879 + x17 * x783 + x899
    x901 = x13 * x273 + x900
    x902 = x112 * (x209 * x753 - x858 - x862)
    x903 = x112 * (x197 * x753 - x863 - x876)
    x904 = x112 * (x193 * x753 - x866 - x871)
    x905 = (
        x3 * x878
        - x82 * x898
        + x86 * (x3 * x877 + x81 * (x3 * x873 - x82 * x893 + x904) - x82 * x897 + x903)
        + x902
    )
    x906 = x17 * x835 + x905
    x907 = x112 * (x241 * x753 - x880 - x883)
    x908 = x112 * (x202 * x753 - x860 - x886)
    x909 = x3 * x885
    x910 = x249 * x753 - x281 * x765
    x911 = x82 * x910
    x912 = x3 * x894
    x913 = x3 * x890
    x914 = x245 * x753 - x279 * x765
    x915 = x82 * x914
    x916 = x913 - x915
    x917 = x247 * x753 - x280 * x765
    x918 = x82 * x917
    x919 = x81 * x916 + x912 - x918
    x920 = x86 * x919 + x909 - x911
    x921 = x112 * (x200 * x753 - x874 - x895)
    x922 = x112 * (x198 * x753 - x869 - x891)
    x923 = x250 * x753 - x291 * x765
    x924 = (
        x3 * x899
        - x82 * (x3 * x882 - x82 * x923 + x88 * x920)
        + x88
        * (
            x3 * x898
            - x82 * x920
            + x86
            * (x3 * x897 + x81 * (x3 * x893 - x82 * x916 + x922) - x82 * x919 + x921)
            + x908
        )
        + x907
    )
    x925 = x16 * x906 + x17 * x831 + x924
    x926 = x763 * x81
    x927 = x770 * x81
    x928 = x768 * x81 - x82 * x927
    x929 = x778 * x81
    x930 = x776 * x81 + x81 * x928 - x82 * x929
    x931 = x761 * x81 - x82 * x926 + x86 * x930
    x932 = x18 * x798 + x931
    x933 = x81 * x811 - x81 * x814
    x934 = x81 * x816 - x81 * x819 + x81 * x933
    x935 = x807 * x81 - x81 * x810 + x86 * x934
    x936 = x803 * x81 - x806 * x81 + x88 * x935
    x937 = x16 * x932 + x18 * x783 + x936
    x938 = x13 * x294 + x937
    x939 = x112 * (-x75 * x926 + x760 * x81)
    x940 = x112 * (-x75 * x929 + x775 * x81)
    x941 = x112 * (-x75 * x927 + x767 * x81)
    x942 = (
        x3 * x931
        - x82 * x935
        + x86 * (x3 * x930 + x81 * (x3 * x928 - x82 * x933 + x941) - x82 * x934 + x940)
        + x939
    )
    x943 = x18 * x835 + x942
    x944 = x805 * x81
    x945 = x112 * (x757 * x81 - x944)
    x946 = x809 * x81
    x947 = x112 * (x763 * x81 - x946)
    x948 = x81 * x843 - x81 * x845
    x949 = x81 * x847 - x81 * x849 + x81 * x948
    x950 = x81 * x840 - x81 * x842 + x86 * x949
    x951 = x81 * x818
    x952 = x112 * (x778 * x81 - x951)
    x953 = x81 * x813
    x954 = x112 * (x770 * x81 - x953)
    x955 = (
        x3 * x936
        - x82 * (x81 * x837 - x81 * x839 + x88 * x950)
        + x88
        * (
            x3 * x935
            - x82 * x950
            + x86
            * (x3 * x934 + x81 * (x3 * x933 - x82 * x948 + x954) - x82 * x949 + x952)
            + x947
        )
        + x945
    )
    x956 = x16 * x943 + x18 * x831 + x955
    x957 = x28 * x304
    x958 = x309 * x753 - x957
    x959 = -x28 * x322 + x303 * x753
    x960 = x75 * x959
    x961 = x28 * x314
    x962 = x299 * x753 - x961
    x963 = x3 * x962
    x964 = x28 * x311
    x965 = x295 * x753 - x964
    x966 = x3 * x965
    x967 = -x28 * x323 + x300 * x753
    x968 = x75 * x967
    x969 = x23 * x968
    x970 = x966 - x969
    x971 = -x28 * x325 + x302 * x753
    x972 = x75 * x971
    x973 = x23 * x972
    x974 = x81 * x970 + x963 - x973
    x975 = -x23 * x960 + x3 * x958 + x86 * x974
    x976 = x17 * x878 + x975
    x977 = x17 * x879 + x976
    x978 = x13 * x339 + x977
    x979 = x112 * (x309 * x753 - x957 - x960)
    x980 = x112 * (x299 * x753 - x961 - x972)
    x981 = x112 * (x295 * x753 - x964 - x968)
    x982 = x3 * x967
    x983 = x318 * x753 - x341 * x765
    x984 = x82 * x983
    x985 = x982 - x984
    x986 = x3 * x971
    x987 = x320 * x753 - x345 * x765
    x988 = x82 * x987
    x989 = x81 * x985 + x986 - x988
    x990 = x321 * x753 - x350 * x765
    x991 = (
        x3 * x975
        - x82 * (x3 * x959 - x82 * x990 + x86 * x989)
        + x86 * (x3 * x974 + x81 * (x3 * x970 - x82 * x985 + x981) - x82 * x989 + x980)
        + x979
    )
    x992 = x17 * x905 + x991
    x993 = x17 * x906 + x992
    x994 = x81 * x889 - x81 * x892
    x995 = x81 * x888 - x81 * x896 + x81 * x994
    x996 = x81 * x884 - x81 * x887 + x86 * x995
    x997 = x18 * x878 + x996
    x998 = x17 * x932 + x997
    x999 = x13 * x356 + x998
    x1000 = x81 * x886
    x1001 = x112 * (-x1000 + x81 * x861)
    x1002 = x81 * x895
    x1003 = x112 * (-x1002 + x81 * x875)
    x1004 = x81 * x891
    x1005 = x112 * (-x1004 + x81 * x870)
    x1006 = x81 * x913 - x81 * x915
    x1007 = x1006 * x81 + x81 * x912 - x81 * x918
    x1008 = (
        x1001
        + x3 * x996
        - x82 * (x1007 * x86 + x81 * x909 - x81 * x911)
        + x86
        * (x1003 - x1007 * x82 + x3 * x995 + x81 * (x1005 - x1006 * x82 + x3 * x994))
    )
    x1009 = x1008 + x18 * x905
    x1010 = x1009 + x17 * x943
    x1011 = x13 * x19
    x1012 = x80 ** (-2.0)
    x1013 = 2 * x1012
    x1014 = x1013 * x811 - x1013 * x814
    x1015 = x1013 * x816 - x1013 * x819 + x1014 * x81
    x1016 = x1013 * x807 - x1013 * x810 + x1015 * x86
    x1017 = x1016 + x18 * x931
    x1018 = x1017 + x18 * x932
    x1019 = x1011 * x175 + x1018
    x1020 = x112 * (2 * x1012 * x763 - x1013 * x809)
    x1021 = x112 * (2 * x1012 * x778 - x1013 * x818)
    x1022 = x112 * (2 * x1012 * x770 - x1013 * x813)
    x1023 = x1013 * x843 - x1013 * x845
    x1024 = x1013 * x847 - x1013 * x849 + x1023 * x81
    x1025 = (
        x1016 * x3
        + x1020
        - x82 * (x1013 * x840 - x1013 * x842 + x1024 * x86)
        + x86
        * (x1015 * x3 + x1021 - x1024 * x82 + x81 * (x1014 * x3 + x1022 - x1023 * x82))
    )
    x1026 = x1025 + x18 * x942
    x1027 = x1026 + x18 * x943
    x1028 = x28 * x360
    x1029 = -x1028 + x207 * x753
    x1030 = x28 * x362
    x1031 = -x1030 + x195 * x753
    x1032 = x1031 * x3
    x1033 = x75 * x867
    x1034 = x1032 - x1033 * x23
    x1035 = x75 * x864
    x1036 = x1029 * x3 + x1034 * x81 - x1035 * x23
    x1037 = x16 * x878 + x16 * (x1036 * x16 + x878) + x899
    x1038 = x1037 + x13 * x374
    x1039 = x112 * (-x1028 - x1035 + x207 * x753)
    x1040 = x112 * (-x1030 - x1033 + x195 * x753)
    x1041 = x1036 * x3 + x1039 + x81 * (x1034 * x3 + x1040 - x82 * x873) - x82 * x877
    x1042 = x16 * x905 + x16 * (x1041 * x16 + x905) + x924
    x1043 = x28 * x378
    x1044 = -x1043 + x308 * x753
    x1045 = x28 * x380
    x1046 = -x1045 + x297 * x753
    x1047 = x1046 * x3
    x1048 = x75 * x965
    x1049 = x1047 - x1048 * x23
    x1050 = x75 * x962
    x1051 = x1044 * x3 + x1049 * x81 - x1050 * x23
    x1052 = x1036 * x17 + x1051
    x1053 = x1052 * x16 + x976
    x1054 = x1053 + x13 * x393
    x1055 = x112 * (-x1043 - x1050 + x308 * x753)
    x1056 = x112 * (-x1045 - x1048 + x297 * x753)
    x1057 = x1051 * x3 + x1055 + x81 * (x1049 * x3 + x1056 - x82 * x970) - x82 * x974
    x1058 = x1041 * x17 + x1057
    x1059 = x1058 * x16 + x992
    x1060 = x81 * x870
    x1061 = -x1060 * x82 + x81 * x868
    x1062 = x81 * x875
    x1063 = x1061 * x81 - x1062 * x82 + x81 * x865
    x1064 = x1036 * x18 + x1063
    x1065 = x1064 * x16 + x997
    x1066 = x1065 + x13 * x398
    x1067 = x112 * (-x1062 * x75 + x81 * x864)
    x1068 = x112 * (-x1060 * x75 + x81 * x867)
    x1069 = x1063 * x3 + x1067 + x81 * (x1061 * x3 + x1068 - x82 * x994) - x82 * x995
    x1070 = x1041 * x18 + x1069
    x1071 = x1009 + x1070 * x16
    x1072 = x28 * x402
    x1073 = -x1072 + x404 * x753
    x1074 = x28 * x406
    x1075 = -x1074 + x399 * x753
    x1076 = x1075 * x3
    x1077 = -x28 * x411 + x400 * x753
    x1078 = x1077 * x75
    x1079 = x1078 * x23
    x1080 = x1076 - x1079
    x1081 = -x28 * x417 + x401 * x753
    x1082 = x1081 * x75
    x1083 = x1073 * x3 + x1080 * x81 - x1082 * x23
    x1084 = x1051 * x17 + x1083
    x1085 = x1052 * x17 + x1084
    x1086 = x1085 + x13 * x424
    x1087 = x112 * (-x1072 - x1082 + x404 * x753)
    x1088 = x112 * (-x1074 - x1078 + x399 * x753)
    x1089 = x1077 * x3
    x1090 = x410 * x753 - x426 * x765
    x1091 = x1090 * x82
    x1092 = x1089 - x1091
    x1093 = x416 * x753 - x430 * x765
    x1094 = (
        x1057 * x17
        + x1083 * x3
        + x1087
        + x81 * (x1080 * x3 + x1088 - x1092 * x82)
        - x82 * (x1081 * x3 + x1092 * x81 - x1093 * x82)
    )
    x1095 = x1058 * x17 + x1094
    x1096 = x81 * x966 - x81 * x969
    x1097 = x1096 * x81 + x81 * x963 - x81 * x973
    x1098 = x1051 * x18 + x1097
    x1099 = x1064 * x17 + x1098
    x1100 = x1099 + x13 * x435
    x1101 = x81 * x972
    x1102 = x112 * (-x1101 + x81 * x962)
    x1103 = x81 * x968
    x1104 = x112 * (-x1103 + x81 * x965)
    x1105 = x81 * x982 - x81 * x984
    x1106 = (
        x1097 * x3
        + x1102
        + x81 * (x1096 * x3 + x1104 - x1105 * x82)
        - x82 * (x1105 * x81 + x81 * x986 - x81 * x988)
    )
    x1107 = x1057 * x18 + x1106
    x1108 = x1070 * x17 + x1107
    x1109 = x1013 * x889 - x1013 * x892
    x1110 = x1013 * x888 - x1013 * x896 + x1109 * x81
    x1111 = x1063 * x18 + x1110
    x1112 = x1064 * x18 + x1111
    x1113 = x1011 * x368 + x1112
    x1114 = x112 * (2 * x1012 * x875 - x1013 * x895)
    x1115 = x112 * (2 * x1012 * x870 - x1013 * x891)
    x1116 = x1013 * x913 - x1013 * x915
    x1117 = (
        x1110 * x3
        + x1114
        + x81 * (x1109 * x3 + x1115 - x1116 * x82)
        - x82 * (x1013 * x912 - x1013 * x918 + x1116 * x81)
    )
    x1118 = x1069 * x18 + x1117
    x1119 = x1070 * x18 + x1118
    x1120 = x767 * x81
    x1121 = -x1120 * x82 + x789 * x81
    x1122 = x775 * x81
    x1123 = x1121 * x81 - x1122 * x82 + x795 * x81
    x1124 = x16 * x931 + x16 * (x1123 * x16 + x931) + x936
    x1125 = x112 * (-x1122 * x75 + x794 * x81)
    x1126 = x112 * (-x1120 * x75 + x788 * x81)
    x1127 = x1123 * x3 + x1125 + x81 * (x1121 * x3 + x1126 - x82 * x928) - x82 * x930
    x1128 = x11 * x1124 + x16 * x942 + x16 * (x1127 * x16 + x942) + x955
    x1129 = x1063 + x1123 * x17
    x1130 = x1129 * x16 + x17 * x931 + x996
    x1131 = x1069 + x1127 * x17
    x1132 = x1008 + x11 * x1130 + x1131 * x16 + x17 * x942
    x1133 = x1013 * x768 - x1013 * x772
    x1134 = x1013 * x776 - x1013 * x780 + x1133 * x81
    x1135 = x1123 * x18 + x1134
    x1136 = x1017 + x1135 * x16
    x1137 = x112 * (2 * x1012 * x775 - x1013 * x779)
    x1138 = x112 * (2 * x1012 * x767 - x1013 * x771)
    x1139 = -x1015 * x82 + x1134 * x3 + x1137 + x81 * (-x1014 * x82 + x1133 * x3 + x1138)
    x1140 = x1127 * x18 + x1139
    x1141 = x1026 + x11 * x1136 + x1140 * x16
    x1142 = x1063 * x17 + x1097
    x1143 = x1129 * x17 + x1142
    x1144 = x1069 * x17 + x1106
    x1145 = x11 * x1143 + x1131 * x17 + x1144
    x1146 = x1111 + x1135 * x17
    x1147 = x11 * x1146 + x1118 + x1140 * x17
    x1148 = x80 ** (-3.0)
    x1149 = 6 * x1148
    x1150 = x1149 * x811 - x1149 * x814
    x1151 = x1149 * x816 - x1149 * x819 + x1150 * x81
    x1152 = x1134 * x18 + x1151
    x1153 = x1135 * x18 + x1152
    x1154 = x112 * (6 * x1148 * x778 - x1149 * x818)
    x1155 = x112 * (6 * x1148 * x770 - x1149 * x813)
    x1156 = x1149 * x843 - x1149 * x845
    x1157 = (
        x1139 * x18
        + x1151 * x3
        + x1154
        + x81 * (x1150 * x3 + x1155 - x1156 * x82)
        - x82 * (x1149 * x847 - x1149 * x849 + x1156 * x81)
    )
    x1158 = x11 * x1153 + x1140 * x18 + x1157
    x1159 = x28 * x438
    x1160 = -x1159 + x306 * x753
    x1161 = x1046 * x75
    x1162 = x1160 * x3 - x1161 * x23
    x1163 = x1051 * x16 + x16 * (x1051 + x1162 * x16) + x975
    x1164 = x1163 + x13 * x447
    x1165 = x112 * (-x1159 - x1161 + x306 * x753)
    x1166 = -x1049 * x82 + x1162 * x3 + x1165
    x1167 = x1057 * x16 + x16 * (x1057 + x1166 * x16) + x991
    x1168 = x28 * x451
    x1169 = -x1168 + x403 * x753
    x1170 = x1075 * x75
    x1171 = x1169 * x3 - x1170 * x23
    x1172 = x1162 * x17 + x1171
    x1173 = x1084 + x1172 * x16
    x1174 = x1173 + x13 * x461
    x1175 = x112 * (-x1168 - x1170 + x403 * x753)
    x1176 = -x1080 * x82 + x1171 * x3 + x1175
    x1177 = x1166 * x17 + x1176
    x1178 = x1094 + x1177 * x16
    x1179 = x81 * x965
    x1180 = x1047 * x81 - x1179 * x82
    x1181 = x1162 * x18 + x1180
    x1182 = x1098 + x1181 * x16
    x1183 = x1182 + x13 * x466
    x1184 = x112 * (x1046 * x81 - x1179 * x75)
    x1185 = -x1096 * x82 + x1180 * x3 + x1184
    x1186 = x1166 * x18 + x1185
    x1187 = x1107 + x1186 * x16
    x1188 = x28 * x469
    x1189 = -x1188 + x467 * x753
    x1190 = -x28 * x472 + x468 * x753
    x1191 = x1190 * x75
    x1192 = x1189 * x3 - x1191 * x23
    x1193 = x1171 * x17 + x1172 * x17 + x1192
    x1194 = x1193 + x13 * x481
    x1195 = x112 * (-x1188 - x1191 + x467 * x753)
    x1196 = x471 * x753 - x479 * x765
    x1197 = (
        x1176 * x17 + x1177 * x17 + x1192 * x3 + x1195 - x82 * (x1190 * x3 - x1196 * x82)
    )
    x1198 = x1076 * x81 - x1079 * x81
    x1199 = x1171 * x18 + x1181 * x17 + x1198
    x1200 = x1199 + x13 * x483
    x1201 = x1078 * x81
    x1202 = x112 * (x1075 * x81 - x1201)
    x1203 = x1198 * x3 + x1202 - x82 * (x1089 * x81 - x1091 * x81)
    x1204 = x1176 * x18 + x1186 * x17 + x1203
    x1205 = x1013 * x966 - x1013 * x969
    x1206 = x1180 * x18 + x1205
    x1207 = x1181 * x18 + x1206
    x1208 = x1011 * x441 + x1207
    x1209 = x112 * (2 * x1012 * x965 - x1013 * x968)
    x1210 = x1205 * x3 + x1209 - x82 * (x1013 * x982 - x1013 * x984)
    x1211 = x1185 * x18 + x1210
    x1212 = x1186 * x18 + x1211
    x1213 = x81 * x867
    x1214 = x1032 * x81 - x1213 * x82
    x1215 = x1063 * x16 + x16 * (x1063 + x1214 * x16) + x996
    x1216 = x112 * (x1031 * x81 - x1213 * x75)
    x1217 = -x1061 * x82 + x1214 * x3 + x1216
    x1218 = x1008 + x1069 * x16 + x11 * x1215 + x16 * (x1069 + x1217 * x16)
    x1219 = x1180 + x1214 * x17
    x1220 = x1142 + x1219 * x16
    x1221 = x1185 + x1217 * x17
    x1222 = x11 * x1220 + x1144 + x1221 * x16
    x1223 = x1013 * x868 - x1013 * x872
    x1224 = x1214 * x18 + x1223
    x1225 = x1111 + x1224 * x16
    x1226 = x112 * (2 * x1012 * x867 - x1013 * x871)
    x1227 = -x1109 * x82 + x1223 * x3 + x1226
    x1228 = x1217 * x18 + x1227
    x1229 = x11 * x1225 + x1118 + x1228 * x16
    x1230 = x1180 * x17 + x1198 + x1219 * x17
    x1231 = x11 * x1230 + x1185 * x17 + x1203 + x1221 * x17
    x1232 = x1206 + x1224 * x17
    x1233 = x11 * x1232 + x1211 + x1228 * x17
    x1234 = x1149 * x889 - x1149 * x892
    x1235 = x1223 * x18 + x1234
    x1236 = x1224 * x18 + x1235
    x1237 = x112 * (6 * x1148 * x870 - x1149 * x891)
    x1238 = x1227 * x18 + x1234 * x3 + x1237 - x82 * (x1149 * x913 - x1149 * x915)
    x1239 = x11 * x1236 + x1228 * x18 + x1238
    x1240 = x1013 * x789 - x1013 * x791
    x1241 = x1016 + x1134 * x16 + x16 * (x1134 + x1240 * x16)
    x1242 = x112 * (2 * x1012 * x788 - x1013 * x790)
    x1243 = -x1133 * x82 + x1240 * x3 + x1242
    x1244 = x1025 + x11 * x1241 + x1139 * x16 + x16 * (x1139 + x1243 * x16)
    x1245 = x1223 + x1240 * x17
    x1246 = x1110 + x1134 * x17 + x1245 * x16
    x1247 = x1227 + x1243 * x17
    x1248 = x11 * x1246 + x1117 + x1139 * x17 + x1247 * x16
    x1249 = x1149 * x768 - x1149 * x772
    x1250 = x1240 * x18 + x1249
    x1251 = x1152 + x1250 * x16
    x1252 = x112 * (6 * x1148 * x767 - x1149 * x771)
    x1253 = -x1150 * x82 + x1249 * x3 + x1252
    x1254 = x1243 * x18 + x1253
    x1255 = x11 * x1251 + x1157 + x1254 * x16
    x1256 = x1205 + x1223 * x17 + x1245 * x17
    x1257 = x11 * x1256 + x1210 + x1227 * x17 + x1247 * x17
    x1258 = x1235 + x1250 * x17
    x1259 = x11 * x1258 + x1238 + x1254 * x17
    x1260 = x80 ** (-4.0)
    x1261 = 24 * x1260
    x1262 = x112 * (24 * x1260 * x770 - x1261 * x813)
    x1263 = x1261 * x811 - x1261 * x814
    x1264 = x1249 * x18 + x1250 * x18 + x1263
    x1265 = (
        x11 * x1264
        + x1253 * x18
        + x1254 * x18
        + x1262
        + x1263 * x3
        - x82 * (x1261 * x843 - x1261 * x845)
    )
    x1266 = x157 - x26 * x490 + x485 * x487
    x1267 = x115 - x26 * x529 + x485 * x489
    x1268 = x158 - x26 * x495 + x485 * x492
    x1269 = x117 - x26 * x531 + x485 * x494
    x1270 = x161 - x26 * x501 + x485 * x498
    x1271 = x120 - x26 * x533 + x485 * x500
    x1272 = x160 - x26 * x507 + x485 * x504
    x1273 = x119 - x26 * x536 + x485 * x506
    x1274 = (
        x1266 * x3
        - x1267 * x82
        + x88
        * (
            x1268 * x3
            - x1269 * x82
            + x86 * (x1272 * x3 - x1273 * x82 + x81 * (x1270 * x3 - x1271 * x82))
        )
    )
    x1275 = x176 - x26 * x513 + x485 * x512
    x1276 = x178 - x26 * x516 + x485 * x515
    x1277 = x177 - x26 * x520 + x485 * x519
    x1278 = (
        -x1268 * x82
        + x1275 * x3
        + x86 * (-x1272 * x82 + x1277 * x3 + x81 * (-x1270 * x82 + x1276 * x3))
    )
    x1279 = x1278 * x16
    x1280 = x114 - x26 * x527 + x485 * x525
    x1281 = x140 + x485 * x528 - x496 * x555
    x1282 = x141 + x485 * x530 - x496 * x556
    x1283 = x143 + x485 * x532 - x496 * x557
    x1284 = x142 + x485 * x535 - x496 * x559
    x1285 = x128 + x485 * x526 - x496 * x566
    x1286 = (
        x12 * x541
        + x1274 * x16
        + x1280 * x3
        - x1285 * x82
        + x16 * (x1274 + x1279)
        + x90
        * (
            x1267 * x3
            - x1281 * x82
            + x88
            * (
                x1269 * x3
                - x1282 * x82
                + x86 * (x1273 * x3 - x1284 * x82 + x81 * (x1271 * x3 - x1283 * x82))
            )
        )
    )
    x1287 = x1278 * x17
    x1288 = x1268 * x81 + x210 - x26 * x571 + x485 * x569
    x1289 = x1269 * x81 - x26 * x586 + x260 + x485 * x570
    x1290 = x1270 * x81 + x232 - x26 * x574 + x485 * x572
    x1291 = x1271 * x81 - x26 * x588 + x263 + x485 * x573
    x1292 = x1272 * x81 + x231 - x26 * x578 + x485 * x576
    x1293 = x1273 * x81 - x26 * x591 + x262 + x485 * x577
    x1294 = (
        x1288 * x3
        - x1289 * x82
        + x86 * (x1292 * x3 - x1293 * x82 + x81 * (x1290 * x3 - x1291 * x82))
    )
    x1295 = x1287 + x1294
    x1296 = x1267 * x81 + x242 - x26 * x584 + x485 * x582
    x1297 = x1282 * x81 + x277 + x485 * x585 - x496 * x605
    x1298 = x1283 * x81 + x286 + x485 * x587 - x496 * x606
    x1299 = x1284 * x81 + x285 + x485 * x590 - x496 * x608
    x1300 = x1281 * x81 + x290 + x485 * x583 - x496 * x613
    x1301 = (
        x1296 * x3
        - x1300 * x82
        + x88
        * (
            x1289 * x3
            - x1297 * x82
            + x86 * (x1293 * x3 - x1299 * x82 + x81 * (x1291 * x3 - x1298 * x82))
        )
    )
    x1302 = x12 * x595 + x1274 * x17 + x1295 * x16 + x1301
    x1303 = x12 * x616 + x1274 * x18 + x1279 * x18
    x1304 = x1289 * x86 - x26 * x621 + x310 + x485 * x619
    x1305 = x1291 * x86 - x26 * x624 + x330 + x485 * x622
    x1306 = x1298 * x86 + x340 + x485 * x623 - x496 * x637
    x1307 = x1293 * x86 - x26 * x628 + x329 + x485 * x626
    x1308 = x1299 * x86 + x344 + x485 * x627 - x496 * x639
    x1309 = x1297 * x86 + x348 + x485 * x620 - x496 * x641
    x1310 = (
        x1304 * x3
        - x1309 * x82
        + x86 * (x1307 * x3 - x1308 * x82 + x81 * (x1305 * x3 - x1306 * x82))
    )
    x1311 = x1294 * x17 + x1310
    x1312 = x12 * x632 + x1295 * x17 + x1311
    x1313 = x1294 * x18
    x1314 = x12 * x646 + x1287 * x18 + x1313
    x1315 = x12 * x651 + x1278 * x19
    x1316 = x1276 * x81 - x26 * x655 + x363 + x485 * x654
    x1317 = x1277 * x81 - x26 * x658 + x361 + x485 * x657
    x1318 = -x1292 * x82 + x1317 * x3 + x81 * (-x1290 * x82 + x1316 * x3)
    x1319 = x1318 * x16
    x1320 = x12 * x661 + x1294 * x16 + x1301 + x16 * (x1294 + x1319)
    x1321 = x1318 * x17
    x1322 = x1290 * x86 - x26 * x670 + x381 + x485 * x669
    x1323 = x1292 * x86 - x26 * x673 + x379 + x485 * x672
    x1324 = -x1307 * x82 + x1323 * x3 + x81 * (-x1305 * x82 + x1322 * x3)
    x1325 = x1321 + x1324
    x1326 = x12 * x676 + x1311 + x1325 * x16
    x1327 = x12 * x684 + x1313 + x1319 * x18
    x1328 = x1305 * x88 - x26 * x689 + x407 + x485 * x687
    x1329 = x1306 * x88 + x425 + x485 * x688 - x496 * x700
    x1330 = x1307 * x88 - x26 * x693 + x405 + x485 * x691
    x1331 = x1308 * x88 + x429 + x485 * x692 - x496 * x702
    x1332 = x1324 * x17 + x1330 * x3 - x1331 * x82 + x81 * (x1328 * x3 - x1329 * x82)
    x1333 = x12 * x696 + x1325 * x17 + x1332
    x1334 = x1324 * x18
    x1335 = x12 * x706 + x1321 * x18 + x1334
    x1336 = x12 * x710 + x1318 * x19
    x1337 = x1316 * x86 - x26 * x714 + x439 + x485 * x713
    x1338 = -x1322 * x82 + x1337 * x3
    x1339 = x1338 * x16
    x1340 = x12 * x717 + x1310 + x1324 * x16 + x16 * (x1324 + x1339)
    x1341 = x1338 * x17
    x1342 = x1322 * x88 - x26 * x725 + x452 + x485 * x724
    x1343 = -x1328 * x82 + x1342 * x3
    x1344 = x1341 + x1343
    x1345 = x12 * x728 + x1332 + x1344 * x16
    x1346 = x12 * x735 + x1334 + x1339 * x18
    x1347 = x1328 * x90 - x26 * x740 + x475 + x485 * x738
    x1348 = x1329 * x90 + x478 + x485 * x739 - x496 * x745
    x1349 = x12 * x742 + x1343 * x17 + x1344 * x17 + x1347 * x3 - x1348 * x82
    x1350 = x12 * x747 + x1341 * x18 + x1343 * x18
    x1351 = x12 * x750 + x1338 * x19
    x1352 = -x26 * x758 + x485 * x755
    x1353 = -x26 * x805 + x485 * x757
    x1354 = -x26 * x764 + x485 * x760
    x1355 = x485 * x763
    x1356 = x26 * x809
    x1357 = x1355 - x1356
    x1358 = x485 * x767
    x1359 = x26 * x771
    x1360 = x1358 - x1359
    x1361 = x485 * x770
    x1362 = x26 * x813
    x1363 = x1361 - x1362
    x1364 = x485 * x775
    x1365 = x26 * x779
    x1366 = x1364 - x1365
    x1367 = x485 * x778
    x1368 = x26 * x818
    x1369 = x1367 - x1368
    x1370 = (
        x1352 * x3
        - x1353 * x82
        + x88
        * (
            x1354 * x3
            - x1357 * x82
            + x86 * (x1366 * x3 - x1369 * x82 + x81 * (x1360 * x3 - x1363 * x82))
        )
    )
    x1371 = -x26 * x786 + x485 * x785
    x1372 = x485 * x788
    x1373 = x26 * x790
    x1374 = x1372 - x1373
    x1375 = -x26 * x796 + x485 * x794
    x1376 = (
        -x1354 * x82
        + x1371 * x3
        + x86 * (-x1366 * x82 + x1375 * x3 + x81 * (-x1360 * x82 + x1374 * x3))
    )
    x1377 = -x26 * x802 + x485 * x800
    x1378 = x485 * x804
    x1379 = x496 * x838
    x1380 = x1378 - x1379
    x1381 = x485 * x808
    x1382 = x496 * x841
    x1383 = x1381 - x1382
    x1384 = x485 * x812
    x1385 = x496 * x844
    x1386 = x1384 - x1385
    x1387 = x485 * x817
    x1388 = x496 * x848
    x1389 = x1387 - x1388
    x1390 = x485 * x801 - x496 * x856
    x1391 = (
        x1370 * x16
        + x1377 * x3
        - x1390 * x82
        + x16 * (x1370 + x1376 * x16)
        + x90
        * (
            x1353 * x3
            - x1380 * x82
            + x88
            * (
                x1357 * x3
                - x1383 * x82
                + x86 * (x1369 * x3 - x1389 * x82 + x81 * (x1363 * x3 - x1386 * x82))
            )
        )
    )
    x1392 = x13 * x541 + x1391
    x1393 = x1354 * x81 - x26 * x862 + x485 * x859
    x1394 = x1357 * x81 - x26 * x886 + x485 * x861
    x1395 = x485 * x867
    x1396 = x26 * x871
    x1397 = x1360 * x81 + x1395 - x1396
    x1398 = x485 * x870
    x1399 = x26 * x891
    x1400 = x1363 * x81 + x1398 - x1399
    x1401 = x1366 * x81 - x26 * x876 + x485 * x864
    x1402 = x485 * x875
    x1403 = x26 * x895
    x1404 = x1369 * x81 + x1402 - x1403
    x1405 = (
        x1393 * x3
        - x1394 * x82
        + x86 * (x1401 * x3 - x1404 * x82 + x81 * (x1397 * x3 - x1400 * x82))
    )
    x1406 = x1376 * x17 + x1405
    x1407 = x1353 * x81 - x26 * x883 + x485 * x881
    x1408 = x485 * x885
    x1409 = x496 * x910
    x1410 = x1383 * x81 + x1408 - x1409
    x1411 = x485 * x890
    x1412 = x496 * x914
    x1413 = x1386 * x81 + x1411 - x1412
    x1414 = x485 * x894
    x1415 = x496 * x917
    x1416 = x1389 * x81 + x1414 - x1415
    x1417 = x1380 * x81 + x485 * x882 - x496 * x923
    x1418 = (
        x1407 * x3
        - x1417 * x82
        + x88
        * (
            x1394 * x3
            - x1410 * x82
            + x86 * (x1404 * x3 - x1416 * x82 + x81 * (x1400 * x3 - x1413 * x82))
        )
    )
    x1419 = x1370 * x17 + x1406 * x16 + x1418
    x1420 = x13 * x595 + x1419
    x1421 = x760 * x81
    x1422 = x1421 * x485 - x496 * x926
    x1423 = -x26 * x946 + x485 * x926
    x1424 = x1122 * x485 - x496 * x929
    x1425 = -x26 * x951 + x485 * x929
    x1426 = x1120 * x485 - x496 * x927
    x1427 = -x26 * x953 + x485 * x927
    x1428 = (
        x1422 * x3
        - x1423 * x82
        + x86 * (x1424 * x3 - x1425 * x82 + x81 * (x1426 * x3 - x1427 * x82))
    )
    x1429 = x1376 * x18 + x1428
    x1430 = x757 * x81
    x1431 = x1430 * x485 - x26 * x944
    x1432 = x1381 * x81 - x1382 * x81
    x1433 = x1387 * x81 - x1388 * x81
    x1434 = x1384 * x81 - x1385 * x81
    x1435 = x1378 * x81 - x1379 * x81
    x1436 = (
        x1431 * x3
        - x1435 * x82
        + x88
        * (
            x1423 * x3
            - x1432 * x82
            + x86 * (x1425 * x3 - x1433 * x82 + x81 * (x1427 * x3 - x1434 * x82))
        )
    )
    x1437 = x1370 * x18 + x1429 * x16 + x1436
    x1438 = x13 * x616 + x1437
    x1439 = x1394 * x86 - x26 * x960 + x485 * x958
    x1440 = x485 * x965
    x1441 = x26 * x968
    x1442 = x1400 * x86 + x1440 - x1441
    x1443 = x485 * x967
    x1444 = x496 * x983
    x1445 = x1413 * x86 + x1443 - x1444
    x1446 = x1404 * x86 - x26 * x972 + x485 * x962
    x1447 = x485 * x971
    x1448 = x496 * x987
    x1449 = x1416 * x86 + x1447 - x1448
    x1450 = x1410 * x86 + x485 * x959 - x496 * x990
    x1451 = (
        x1439 * x3
        - x1450 * x82
        + x86 * (x1446 * x3 - x1449 * x82 + x81 * (x1442 * x3 - x1445 * x82))
    )
    x1452 = x1405 * x17 + x1451
    x1453 = x1406 * x17 + x1452
    x1454 = x13 * x632 + x1453
    x1455 = x81 * x861
    x1456 = -x1000 * x26 + x1423 * x81 + x1455 * x485
    x1457 = -x1002 * x26 + x1062 * x485 + x1425 * x81
    x1458 = -x1004 * x26 + x1060 * x485 + x1427 * x81
    x1459 = x1411 * x81 - x1412 * x81 + x1434 * x81
    x1460 = x1414 * x81 - x1415 * x81 + x1433 * x81
    x1461 = x1408 * x81 - x1409 * x81 + x1432 * x81
    x1462 = (
        x1456 * x3
        - x1461 * x82
        + x86 * (x1457 * x3 - x1460 * x82 + x81 * (x1458 * x3 - x1459 * x82))
    )
    x1463 = x1405 * x18 + x1462
    x1464 = x1429 * x17 + x1463
    x1465 = x13 * x646 + x1464
    x1466 = x1013 * x1355 - x1013 * x1356
    x1467 = x1013 * x1367 - x1013 * x1368
    x1468 = x1013 * x1387 - x1013 * x1388
    x1469 = x1013 * x1361 - x1013 * x1362
    x1470 = x1013 * x1384 - x1013 * x1385
    x1471 = x1013 * x1381 - x1013 * x1382
    x1472 = (
        x1466 * x3
        - x1471 * x82
        + x86 * (x1467 * x3 - x1468 * x82 + x81 * (x1469 * x3 - x1470 * x82))
    )
    x1473 = x1428 * x18 + x1472
    x1474 = x1429 * x18 + x1473
    x1475 = x13 * x651 + x1474
    x1476 = x1031 * x485 - x1033 * x26 + x1374 * x81
    x1477 = x1029 * x485 - x1035 * x26 + x1375 * x81
    x1478 = -x1401 * x82 + x1477 * x3 + x81 * (-x1397 * x82 + x1476 * x3)
    x1479 = x1405 * x16 + x1418 + x16 * (x1405 + x1478 * x16)
    x1480 = x13 * x661 + x1479
    x1481 = x1046 * x485 - x1048 * x26 + x1397 * x86
    x1482 = x1044 * x485 - x1050 * x26 + x1401 * x86
    x1483 = -x1446 * x82 + x1482 * x3 + x81 * (-x1442 * x82 + x1481 * x3)
    x1484 = x1478 * x17 + x1483
    x1485 = x1452 + x1484 * x16
    x1486 = x13 * x676 + x1485
    x1487 = x81 * x864
    x1488 = -x1062 * x496 + x1424 * x81 + x1487 * x485
    x1489 = -x1060 * x496 + x1213 * x485 + x1426 * x81
    x1490 = -x1457 * x82 + x1488 * x3 + x81 * (-x1458 * x82 + x1489 * x3)
    x1491 = x1478 * x18 + x1490
    x1492 = x1463 + x1491 * x16
    x1493 = x13 * x684 + x1492
    x1494 = x1075 * x485 - x1078 * x26 + x1442 * x88
    x1495 = x1077 * x485
    x1496 = x1090 * x496
    x1497 = x1445 * x88 + x1495 - x1496
    x1498 = x1073 * x485 - x1082 * x26 + x1446 * x88
    x1499 = x1081 * x485 - x1093 * x496 + x1449 * x88
    x1500 = x1483 * x17 + x1498 * x3 - x1499 * x82 + x81 * (x1494 * x3 - x1497 * x82)
    x1501 = x1484 * x17 + x1500
    x1502 = x13 * x696 + x1501
    x1503 = -x1103 * x26 + x1179 * x485 + x1458 * x86
    x1504 = x1443 * x81 - x1444 * x81 + x1459 * x86
    x1505 = x81 * x962
    x1506 = -x1101 * x26 + x1457 * x86 + x1505 * x485
    x1507 = x1447 * x81 - x1448 * x81 + x1460 * x86
    x1508 = x1506 * x3 - x1507 * x82 + x81 * (x1503 * x3 - x1504 * x82)
    x1509 = x1483 * x18 + x1508
    x1510 = x1491 * x17 + x1509
    x1511 = x13 * x706 + x1510
    x1512 = x1013 * x1398 - x1013 * x1399 + x1469 * x81
    x1513 = x1013 * x1411 - x1013 * x1412 + x1470 * x81
    x1514 = x1013 * x1402 - x1013 * x1403 + x1467 * x81
    x1515 = x1013 * x1414 - x1013 * x1415 + x1468 * x81
    x1516 = x1514 * x3 - x1515 * x82 + x81 * (x1512 * x3 - x1513 * x82)
    x1517 = x1490 * x18 + x1516
    x1518 = x1491 * x18 + x1517
    x1519 = x13 * x710 + x1518
    x1520 = x794 * x81
    x1521 = -x1122 * x496 + x1520 * x485
    x1522 = x788 * x81
    x1523 = -x1120 * x496 + x1522 * x485
    x1524 = -x1424 * x82 + x1521 * x3 + x81 * (-x1426 * x82 + x1523 * x3)
    x1525 = x1428 * x16 + x1436 + x16 * (x1428 + x1524 * x16)
    x1526 = x1124 * x12 + x1525
    x1527 = x1490 + x1524 * x17
    x1528 = x1428 * x17 + x1462 + x1527 * x16
    x1529 = x1130 * x12 + x1528
    x1530 = x1013 * x1364 - x1013 * x1365
    x1531 = x1013 * x1358 - x1013 * x1359
    x1532 = -x1467 * x82 + x1530 * x3 + x81 * (-x1469 * x82 + x1531 * x3)
    x1533 = x1524 * x18 + x1532
    x1534 = x1473 + x1533 * x16
    x1535 = x1136 * x12 + x1534
    x1536 = x1490 * x17 + x1508
    x1537 = x1527 * x17 + x1536
    x1538 = x1143 * x12 + x1537
    x1539 = x1517 + x1533 * x17
    x1540 = x1146 * x12 + x1539
    x1541 = x1149 * x1361 - x1149 * x1362
    x1542 = x1149 * x1384 - x1149 * x1385
    x1543 = x1149 * x1367 - x1149 * x1368
    x1544 = x1149 * x1387 - x1149 * x1388
    x1545 = x1532 * x18 + x1543 * x3 - x1544 * x82 + x81 * (x1541 * x3 - x1542 * x82)
    x1546 = x1533 * x18 + x1545
    x1547 = x1153 * x12 + x1546
    x1548 = x1160 * x485 - x1161 * x26 + x1476 * x86
    x1549 = -x1481 * x82 + x1548 * x3
    x1550 = x1451 + x1483 * x16 + x16 * (x1483 + x1549 * x16)
    x1551 = x13 * x717 + x1550
    x1552 = x1169 * x485 - x1170 * x26 + x1481 * x88
    x1553 = -x1494 * x82 + x1552 * x3
    x1554 = x1549 * x17 + x1553
    x1555 = x1500 + x1554 * x16
    x1556 = x13 * x728 + x1555
    x1557 = x1046 * x81
    x1558 = -x1179 * x496 + x1489 * x86 + x1557 * x485
    x1559 = -x1503 * x82 + x1558 * x3
    x1560 = x1549 * x18 + x1559
    x1561 = x1509 + x1560 * x16
    x1562 = x13 * x735 + x1561
    x1563 = x1189 * x485 - x1191 * x26 + x1494 * x90
    x1564 = x1190 * x485 - x1196 * x496 + x1497 * x90
    x1565 = x1553 * x17 + x1554 * x17 + x1563 * x3 - x1564 * x82
    x1566 = x13 * x742 + x1565
    x1567 = x1075 * x81
    x1568 = -x1201 * x26 + x1503 * x88 + x1567 * x485
    x1569 = x1495 * x81 - x1496 * x81 + x1504 * x88
    x1570 = x1568 * x3 - x1569 * x82
    x1571 = x1553 * x18 + x1560 * x17 + x1570
    x1572 = x13 * x747 + x1571
    x1573 = x1013 * x1440 - x1013 * x1441 + x1512 * x86
    x1574 = x1013 * x1443 - x1013 * x1444 + x1513 * x86
    x1575 = x1573 * x3 - x1574 * x82
    x1576 = x1559 * x18 + x1575
    x1577 = x1560 * x18 + x1576
    x1578 = x13 * x750 + x1577
    x1579 = x1031 * x81
    x1580 = -x1213 * x496 + x1523 * x81 + x1579 * x485
    x1581 = -x1489 * x82 + x1580 * x3
    x1582 = x1462 + x1490 * x16 + x16 * (x1490 + x1581 * x16)
    x1583 = x12 * x1215 + x1582
    x1584 = x1559 + x1581 * x17
    x1585 = x1536 + x1584 * x16
    x1586 = x12 * x1220 + x1585
    x1587 = x1013 * x1395 - x1013 * x1396 + x1531 * x81
    x1588 = -x1512 * x82 + x1587 * x3
    x1589 = x1581 * x18 + x1588
    x1590 = x1517 + x1589 * x16
    x1591 = x12 * x1225 + x1590
    x1592 = x1559 * x17 + x1570 + x1584 * x17
    x1593 = x12 * x1230 + x1592
    x1594 = x1576 + x1589 * x17
    x1595 = x12 * x1232 + x1594
    x1596 = x1149 * x1398 - x1149 * x1399 + x1541 * x81
    x1597 = x1149 * x1411 - x1149 * x1412 + x1542 * x81
    x1598 = x1588 * x18 + x1596 * x3 - x1597 * x82
    x1599 = x1589 * x18 + x1598
    x1600 = x12 * x1236 + x1599
    x1601 = x1013 * x1372 - x1013 * x1373
    x1602 = -x1531 * x82 + x1601 * x3
    x1603 = x1472 + x1532 * x16 + x16 * (x1532 + x16 * x1602)
    x1604 = x12 * x1241 + x1603
    x1605 = x1588 + x1602 * x17
    x1606 = x1516 + x1532 * x17 + x16 * x1605
    x1607 = x12 * x1246 + x1606
    x1608 = x1149 * x1358 - x1149 * x1359
    x1609 = -x1541 * x82 + x1608 * x3
    x1610 = x1602 * x18 + x1609
    x1611 = x1545 + x16 * x1610
    x1612 = x12 * x1251 + x1611
    x1613 = x1575 + x1588 * x17 + x1605 * x17
    x1614 = x12 * x1256 + x1613
    x1615 = x1598 + x1610 * x17
    x1616 = x12 * x1258 + x1615
    x1617 = x1261 * x1361 - x1261 * x1362
    x1618 = x1261 * x1384 - x1261 * x1385
    x1619 = x1609 * x18 + x1610 * x18 + x1617 * x3 - x1618 * x82
    x1620 = x12 * x1264 + x1619
    x1621 = x157 - x28 * x758 + x753 * x755
    x1622 = x115 - x28 * x805 + x753 * x757
    x1623 = x158 - x28 * x764 + x753 * x760
    x1624 = x753 * x763
    x1625 = x28 * x809
    x1626 = x117 + x1624 - x1625
    x1627 = x753 * x767
    x1628 = x28 * x771
    x1629 = x161 + x1627 - x1628
    x1630 = x753 * x770
    x1631 = x28 * x813
    x1632 = x120 + x1630 - x1631
    x1633 = x753 * x775
    x1634 = x28 * x779
    x1635 = x160 + x1633 - x1634
    x1636 = x753 * x778
    x1637 = x28 * x818
    x1638 = x119 + x1636 - x1637
    x1639 = (
        x1621 * x3
        - x1622 * x82
        + x88
        * (
            x1623 * x3
            - x1626 * x82
            + x86 * (x1635 * x3 - x1638 * x82 + x81 * (x1629 * x3 - x1632 * x82))
        )
    )
    x1640 = x176 - x28 * x786 + x753 * x785
    x1641 = x753 * x788
    x1642 = x28 * x790
    x1643 = x1641 - x1642 + x178
    x1644 = x177 - x28 * x796 + x753 * x794
    x1645 = (
        -x1623 * x82
        + x1640 * x3
        + x86 * (-x1635 * x82 + x1644 * x3 + x81 * (-x1629 * x82 + x1643 * x3))
    )
    x1646 = x114 - x28 * x802 + x753 * x800
    x1647 = x753 * x804
    x1648 = x765 * x838
    x1649 = x140 + x1647 - x1648
    x1650 = x753 * x808
    x1651 = x765 * x841
    x1652 = x141 + x1650 - x1651
    x1653 = x753 * x812
    x1654 = x765 * x844
    x1655 = x143 + x1653 - x1654
    x1656 = x753 * x817
    x1657 = x765 * x848
    x1658 = x142 + x1656 - x1657
    x1659 = x128 + x753 * x801 - x765 * x856
    x1660 = (
        x13 * x824
        + x16 * x1639
        + x16 * (x16 * x1645 + x1639)
        + x1646 * x3
        - x1659 * x82
        + x90
        * (
            x1622 * x3
            - x1649 * x82
            + x88
            * (
                x1626 * x3
                - x1652 * x82
                + x86 * (x1638 * x3 - x1658 * x82 + x81 * (x1632 * x3 - x1655 * x82))
            )
        )
    )
    x1661 = x210 - x28 * x862 + x753 * x859
    x1662 = x260 - x28 * x886 + x753 * x861
    x1663 = x753 * x867
    x1664 = x28 * x871
    x1665 = x1663 - x1664 + x232
    x1666 = x753 * x870
    x1667 = x28 * x891
    x1668 = x1666 - x1667 + x263
    x1669 = x231 - x28 * x876 + x753 * x864
    x1670 = x753 * x875
    x1671 = x28 * x895
    x1672 = x1670 - x1671 + x262
    x1673 = (
        x1661 * x3
        - x1662 * x82
        + x86 * (x1669 * x3 - x1672 * x82 + x81 * (x1665 * x3 - x1668 * x82))
    )
    x1674 = x1645 * x17 + x1673
    x1675 = x242 - x28 * x883 + x753 * x881
    x1676 = x753 * x885
    x1677 = x765 * x910
    x1678 = x1676 - x1677 + x277
    x1679 = x753 * x890
    x1680 = x765 * x914
    x1681 = x1679 - x1680 + x286
    x1682 = x753 * x894
    x1683 = x765 * x917
    x1684 = x1682 - x1683 + x285
    x1685 = x290 + x753 * x882 - x765 * x923
    x1686 = (
        x1675 * x3
        - x1685 * x82
        + x88
        * (
            x1662 * x3
            - x1678 * x82
            + x86 * (x1672 * x3 - x1684 * x82 + x81 * (x1668 * x3 - x1681 * x82))
        )
    )
    x1687 = x13 * x900 + x16 * x1674 + x1639 * x17 + x1686
    x1688 = x1421 * x753 + x1623 * x81 - x765 * x926
    x1689 = x1626 * x81 - x28 * x946 + x753 * x926
    x1690 = x1120 * x753 + x1629 * x81 - x765 * x927
    x1691 = x1632 * x81 - x28 * x953 + x753 * x927
    x1692 = x1122 * x753 + x1635 * x81 - x765 * x929
    x1693 = x1638 * x81 - x28 * x951 + x753 * x929
    x1694 = (
        x1688 * x3
        - x1689 * x82
        + x86 * (x1692 * x3 - x1693 * x82 + x81 * (x1690 * x3 - x1691 * x82))
    )
    x1695 = x1645 * x18 + x1694
    x1696 = x1430 * x753 + x1622 * x81 - x28 * x944
    x1697 = x1650 * x81 - x1651 * x81 + x1652 * x81
    x1698 = x1653 * x81 - x1654 * x81 + x1655 * x81
    x1699 = x1656 * x81 - x1657 * x81 + x1658 * x81
    x1700 = x1647 * x81 - x1648 * x81 + x1649 * x81
    x1701 = (
        x1696 * x3
        - x1700 * x82
        + x88
        * (
            x1689 * x3
            - x1697 * x82
            + x86 * (x1693 * x3 - x1699 * x82 + x81 * (x1691 * x3 - x1698 * x82))
        )
    )
    x1702 = x13 * x937 + x16 * x1695 + x1639 * x18 + x1701
    x1703 = -x28 * x960 + x310 + x753 * x958
    x1704 = x753 * x965
    x1705 = x28 * x968
    x1706 = x1704 - x1705 + x330
    x1707 = x753 * x967
    x1708 = x765 * x983
    x1709 = x1707 - x1708 + x340
    x1710 = -x28 * x972 + x329 + x753 * x962
    x1711 = x753 * x971
    x1712 = x765 * x987
    x1713 = x1711 - x1712 + x344
    x1714 = x348 + x753 * x959 - x765 * x990
    x1715 = (
        x1703 * x3
        - x1714 * x82
        + x86 * (x1710 * x3 - x1713 * x82 + x81 * (x1706 * x3 - x1709 * x82))
    )
    x1716 = x1673 * x17 + x1715
    x1717 = x13 * x977 + x1674 * x17 + x1716
    x1718 = -x1000 * x28 + x1455 * x753 + x1662 * x81
    x1719 = -x1004 * x28 + x1060 * x753 + x1668 * x81
    x1720 = x1679 * x81 - x1680 * x81 + x1681 * x81
    x1721 = -x1002 * x28 + x1062 * x753 + x1672 * x81
    x1722 = x1682 * x81 - x1683 * x81 + x1684 * x81
    x1723 = x1676 * x81 - x1677 * x81 + x1678 * x81
    x1724 = (
        x1718 * x3
        - x1723 * x82
        + x86 * (x1721 * x3 - x1722 * x82 + x81 * (x1719 * x3 - x1720 * x82))
    )
    x1725 = x1673 * x18 + x1724
    x1726 = x13 * x998 + x1695 * x17 + x1725
    x1727 = x1013 * x1624 - x1013 * x1625 + x1689 * x86
    x1728 = x1013 * x1630 - x1013 * x1631 + x1691 * x86
    x1729 = x1013 * x1653 - x1013 * x1654 + x1698 * x86
    x1730 = x1013 * x1636 - x1013 * x1637 + x1693 * x86
    x1731 = x1013 * x1656 - x1013 * x1657 + x1699 * x86
    x1732 = x1013 * x1650 - x1013 * x1651 + x1697 * x86
    x1733 = (
        x1727 * x3
        - x1732 * x82
        + x86 * (x1730 * x3 - x1731 * x82 + x81 * (x1728 * x3 - x1729 * x82))
    )
    x1734 = x1694 * x18 + x1733
    x1735 = x1018 * x13 + x1695 * x18 + x1734
    x1736 = x1031 * x753 - x1033 * x28 + x363
    x1737 = x1029 * x753 - x1035 * x28 + x361
    x1738 = -x1669 * x82 + x1737 * x3 + x81 * (-x1665 * x82 + x1736 * x3)
    x1739 = x1037 * x13 + x16 * x1673 + x16 * (x16 * x1738 + x1673) + x1686
    x1740 = x1046 * x753 - x1048 * x28 + x381
    x1741 = x1044 * x753 - x1050 * x28 + x379
    x1742 = -x1710 * x82 + x1741 * x3 + x81 * (-x1706 * x82 + x1740 * x3)
    x1743 = x17 * x1738 + x1742
    x1744 = x1053 * x13 + x16 * x1743 + x1716
    x1745 = -x1060 * x765 + x1213 * x753 + x1665 * x81
    x1746 = -x1062 * x765 + x1487 * x753 + x1669 * x81
    x1747 = -x1721 * x82 + x1746 * x3 + x81 * (-x1719 * x82 + x1745 * x3)
    x1748 = x1738 * x18 + x1747
    x1749 = x1065 * x13 + x16 * x1748 + x1725
    x1750 = x1075 * x753 - x1078 * x28 + x407
    x1751 = x1077 * x753
    x1752 = x1090 * x765
    x1753 = x1751 - x1752 + x425
    x1754 = x1073 * x753 - x1082 * x28 + x405
    x1755 = x1081 * x753 - x1093 * x765 + x429
    x1756 = x17 * x1742 + x1754 * x3 - x1755 * x82 + x81 * (x1750 * x3 - x1753 * x82)
    x1757 = x1085 * x13 + x17 * x1743 + x1756
    x1758 = -x1103 * x28 + x1179 * x753 + x1706 * x81
    x1759 = x1707 * x81 - x1708 * x81 + x1709 * x81
    x1760 = -x1101 * x28 + x1505 * x753 + x1710 * x81
    x1761 = x1711 * x81 - x1712 * x81 + x1713 * x81
    x1762 = x1760 * x3 - x1761 * x82 + x81 * (x1758 * x3 - x1759 * x82)
    x1763 = x1742 * x18 + x1762
    x1764 = x1099 * x13 + x17 * x1748 + x1763
    x1765 = x1013 * x1666 - x1013 * x1667 + x1719 * x86
    x1766 = x1013 * x1679 - x1013 * x1680 + x1720 * x86
    x1767 = x1013 * x1670 - x1013 * x1671 + x1721 * x86
    x1768 = x1013 * x1682 - x1013 * x1683 + x1722 * x86
    x1769 = x1767 * x3 - x1768 * x82 + x81 * (x1765 * x3 - x1766 * x82)
    x1770 = x1747 * x18 + x1769
    x1771 = x1112 * x13 + x1748 * x18 + x1770
    x1772 = x1124 * x13
    x1773 = -x1120 * x765 + x1522 * x753 + x1643 * x81
    x1774 = -x1122 * x765 + x1520 * x753 + x1644 * x81
    x1775 = -x1692 * x82 + x1774 * x3 + x81 * (-x1690 * x82 + x1773 * x3)
    x1776 = x16 * x1694 + x16 * (x16 * x1775 + x1694) + x1701
    x1777 = x1130 * x13
    x1778 = x17 * x1775 + x1747
    x1779 = x16 * x1778 + x1694 * x17 + x1724
    x1780 = x1136 * x13
    x1781 = x1013 * x1627 - x1013 * x1628 + x1690 * x86
    x1782 = x1013 * x1633 - x1013 * x1634 + x1692 * x86
    x1783 = -x1730 * x82 + x1782 * x3 + x81 * (-x1728 * x82 + x1781 * x3)
    x1784 = x1775 * x18 + x1783
    x1785 = x16 * x1784 + x1734
    x1786 = x1143 * x13
    x1787 = x17 * x1747 + x1762
    x1788 = x17 * x1778 + x1787
    x1789 = x1146 * x13
    x1790 = x17 * x1784 + x1770
    x1791 = x1153 * x13
    x1792 = x1149 * x1630 - x1149 * x1631 + x1728 * x88
    x1793 = x1149 * x1653 - x1149 * x1654 + x1729 * x88
    x1794 = x1149 * x1636 - x1149 * x1637 + x1730 * x88
    x1795 = x1149 * x1656 - x1149 * x1657 + x1731 * x88
    x1796 = x1783 * x18 + x1794 * x3 - x1795 * x82 + x81 * (x1792 * x3 - x1793 * x82)
    x1797 = x1784 * x18 + x1796
    x1798 = x1160 * x753 - x1161 * x28 + x439
    x1799 = -x1740 * x82 + x1798 * x3
    x1800 = x1163 * x13 + x16 * x1742 + x16 * (x16 * x1799 + x1742) + x1715
    x1801 = x1169 * x753 - x1170 * x28 + x452
    x1802 = -x1750 * x82 + x1801 * x3
    x1803 = x17 * x1799 + x1802
    x1804 = x1173 * x13 + x16 * x1803 + x1756
    x1805 = -x1179 * x765 + x1557 * x753 + x1740 * x81
    x1806 = -x1758 * x82 + x1805 * x3
    x1807 = x1799 * x18 + x1806
    x1808 = x1182 * x13 + x16 * x1807 + x1763
    x1809 = x1189 * x753 - x1191 * x28 + x475
    x1810 = x1190 * x753 - x1196 * x765 + x478
    x1811 = x1193 * x13 + x17 * x1802 + x17 * x1803 + x1809 * x3 - x1810 * x82
    x1812 = -x1201 * x28 + x1567 * x753 + x1750 * x81
    x1813 = x1751 * x81 - x1752 * x81 + x1753 * x81
    x1814 = x1812 * x3 - x1813 * x82
    x1815 = x1199 * x13 + x17 * x1807 + x18 * x1802 + x1814
    x1816 = x1013 * x1704 - x1013 * x1705 + x1758 * x86
    x1817 = x1013 * x1707 - x1013 * x1708 + x1759 * x86
    x1818 = x1816 * x3 - x1817 * x82
    x1819 = x18 * x1806 + x1818
    x1820 = x1207 * x13 + x18 * x1807 + x1819
    x1821 = x1215 * x13
    x1822 = -x1213 * x765 + x1579 * x753 + x1736 * x81
    x1823 = -x1745 * x82 + x1822 * x3
    x1824 = x16 * x1747 + x16 * (x16 * x1823 + x1747) + x1724
    x1825 = x1220 * x13
    x1826 = x17 * x1823 + x1806
    x1827 = x16 * x1826 + x1787
    x1828 = x1225 * x13
    x1829 = x1013 * x1663 - x1013 * x1664 + x1745 * x86
    x1830 = -x1765 * x82 + x1829 * x3
    x1831 = x18 * x1823 + x1830
    x1832 = x16 * x1831 + x1770
    x1833 = x1230 * x13
    x1834 = x17 * x1806 + x17 * x1826 + x1814
    x1835 = x1232 * x13
    x1836 = x17 * x1831 + x1819
    x1837 = x1236 * x13
    x1838 = x1149 * x1666 - x1149 * x1667 + x1765 * x88
    x1839 = x1149 * x1679 - x1149 * x1680 + x1766 * x88
    x1840 = x18 * x1830 + x1838 * x3 - x1839 * x82
    x1841 = x18 * x1831 + x1840
    x1842 = x1241 * x13
    x1843 = x1013 * x1641 - x1013 * x1642 + x1773 * x86
    x1844 = -x1781 * x82 + x1843 * x3
    x1845 = x16 * x1783 + x16 * (x16 * x1844 + x1783) + x1733
    x1846 = x1246 * x13
    x1847 = x17 * x1844 + x1830
    x1848 = x16 * x1847 + x17 * x1783 + x1769
    x1849 = x1251 * x13
    x1850 = x1149 * x1627 - x1149 * x1628 + x1781 * x88
    x1851 = -x1792 * x82 + x1850 * x3
    x1852 = x18 * x1844 + x1851
    x1853 = x16 * x1852 + x1796
    x1854 = x1256 * x13
    x1855 = x17 * x1830 + x17 * x1847 + x1818
    x1856 = x1258 * x13
    x1857 = x17 * x1852 + x1840
    x1858 = x1264 * x13
    x1859 = x1261 * x1630 - x1261 * x1631 + x1792 * x90
    x1860 = x1261 * x1653 - x1261 * x1654 + x1793 * x90
    x1861 = x18 * x1851 + x18 * x1852 + x1859 * x3 - x1860 * x82
    x1862 = x16 * x512
    x1863 = x16 * x487 + x16 * (x1862 + x487) + x525
    x1864 = x17 * x512
    x1865 = x1864 + x569
    x1866 = x16 * x1865 + x17 * x487 + x582
    x1867 = x18 * x1862 + x18 * x487
    x1868 = x17 * x569 + x619
    x1869 = x17 * x1865 + x1868
    x1870 = x18 * x569
    x1871 = x18 * x1864 + x1870
    x1872 = x16 * x657
    x1873 = x16 * x569 + x16 * (x1872 + x569) + x582
    x1874 = x17 * x657
    x1875 = x1874 + x672
    x1876 = x16 * x1875 + x1868
    x1877 = x18 * x1872 + x1870
    x1878 = x17 * x672 + x691
    x1879 = x17 * x1875 + x1878
    x1880 = x18 * x672
    x1881 = x18 * x1874 + x1880
    x1882 = x16 * x713
    x1883 = x16 * x672 + x16 * (x1882 + x672) + x619
    x1884 = x17 * x713
    x1885 = x1884 + x724
    x1886 = x16 * x1885 + x1878
    x1887 = x18 * x1882 + x1880
    x1888 = x17 * x1885 + x17 * x724 + x738
    x1889 = x18 * x1884 + x18 * x724
    x1890 = x1275 * x16
    x1891 = x1266 * x16 + x1280 + x16 * (x1266 + x1890)
    x1892 = x12 * x1863 + x1891
    x1893 = x1275 * x17
    x1894 = x1288 + x1893
    x1895 = x1266 * x17 + x1296 + x16 * x1894
    x1896 = x12 * x1866 + x1895
    x1897 = x1266 * x18 + x18 * x1890
    x1898 = x12 * x1867 + x1897
    x1899 = x1288 * x17 + x1304
    x1900 = x17 * x1894 + x1899
    x1901 = x12 * x1869 + x1900
    x1902 = x1288 * x18
    x1903 = x18 * x1893 + x1902
    x1904 = x12 * x1871 + x1903
    x1905 = x1275 * x19
    x1906 = x1905 + x512 * x650
    x1907 = x1317 * x16
    x1908 = x1288 * x16 + x1296 + x16 * (x1288 + x1907)
    x1909 = x12 * x1873 + x1908
    x1910 = x1317 * x17
    x1911 = x1323 + x1910
    x1912 = x16 * x1911 + x1899
    x1913 = x12 * x1876 + x1912
    x1914 = x18 * x1907 + x1902
    x1915 = x12 * x1877 + x1914
    x1916 = x1323 * x17 + x1330
    x1917 = x17 * x1911 + x1916
    x1918 = x12 * x1879 + x1917
    x1919 = x1323 * x18
    x1920 = x18 * x1910 + x1919
    x1921 = x12 * x1881 + x1920
    x1922 = x1317 * x19
    x1923 = x1922 + x650 * x657
    x1924 = x1337 * x16
    x1925 = x1304 + x1323 * x16 + x16 * (x1323 + x1924)
    x1926 = x12 * x1883 + x1925
    x1927 = x1337 * x17
    x1928 = x1342 + x1927
    x1929 = x16 * x1928 + x1916
    x1930 = x12 * x1886 + x1929
    x1931 = x18 * x1924 + x1919
    x1932 = x12 * x1887 + x1931
    x1933 = x1342 * x17 + x1347 + x17 * x1928
    x1934 = x12 * x1888 + x1933
    x1935 = x1342 * x18 + x18 * x1927
    x1936 = x12 * x1889 + x1935
    x1937 = x1337 * x19
    x1938 = x1937 + x650 * x713
    x1939 = x1352 * x16 + x1377 + x16 * (x1352 + x1371 * x16)
    x1940 = x13 * x1863 + x1939
    x1941 = x1371 * x17 + x1393
    x1942 = x1352 * x17 + x1407 + x16 * x1941
    x1943 = x13 * x1866 + x1942
    x1944 = x1371 * x18 + x1422
    x1945 = x1352 * x18 + x1431 + x16 * x1944
    x1946 = x13 * x1867 + x1945
    x1947 = x1393 * x17 + x1439
    x1948 = x17 * x1941 + x1947
    x1949 = x13 * x1869 + x1948
    x1950 = x1393 * x18 + x1456
    x1951 = x17 * x1944 + x1950
    x1952 = x13 * x1871 + x1951
    x1953 = x1422 * x18 + x1466
    x1954 = x18 * x1944 + x1953
    x1955 = x1011 * x512 + x1954
    x1956 = x1393 * x16 + x1407 + x16 * (x1393 + x1477 * x16)
    x1957 = x13 * x1873 + x1956
    x1958 = x1477 * x17 + x1482
    x1959 = x16 * x1958 + x1947
    x1960 = x13 * x1876 + x1959
    x1961 = x1477 * x18 + x1488
    x1962 = x16 * x1961 + x1950
    x1963 = x13 * x1877 + x1962
    x1964 = x1482 * x17 + x1498
    x1965 = x17 * x1958 + x1964
    x1966 = x13 * x1879 + x1965
    x1967 = x1482 * x18 + x1506
    x1968 = x17 * x1961 + x1967
    x1969 = x13 * x1881 + x1968
    x1970 = x1488 * x18 + x1514
    x1971 = x18 * x1961 + x1970
    x1972 = x1011 * x657 + x1971
    x1973 = x1422 * x16 + x1431 + x16 * (x1422 + x1521 * x16)
    x1974 = x1488 + x1521 * x17
    x1975 = x1422 * x17 + x1456 + x16 * x1974
    x1976 = x1521 * x18 + x1530
    x1977 = x16 * x1976 + x1953
    x1978 = x1488 * x17 + x1506
    x1979 = x17 * x1974 + x1978
    x1980 = x17 * x1976 + x1970
    x1981 = x1530 * x18 + x1543
    x1982 = x18 * x1976 + x1981
    x1983 = x1439 + x1482 * x16 + x16 * (x1482 + x1548 * x16)
    x1984 = x13 * x1883 + x1983
    x1985 = x1548 * x17 + x1552
    x1986 = x16 * x1985 + x1964
    x1987 = x13 * x1886 + x1986
    x1988 = x1548 * x18 + x1558
    x1989 = x16 * x1988 + x1967
    x1990 = x13 * x1887 + x1989
    x1991 = x1552 * x17 + x1563 + x17 * x1985
    x1992 = x13 * x1888 + x1991
    x1993 = x1552 * x18 + x1568 + x17 * x1988
    x1994 = x13 * x1889 + x1993
    x1995 = x1558 * x18 + x1573
    x1996 = x18 * x1988 + x1995
    x1997 = x1011 * x713 + x1996
    x1998 = x1456 + x1488 * x16 + x16 * (x1488 + x1580 * x16)
    x1999 = x1558 + x1580 * x17
    x2000 = x16 * x1999 + x1978
    x2001 = x1580 * x18 + x1587
    x2002 = x16 * x2001 + x1970
    x2003 = x1558 * x17 + x1568 + x17 * x1999
    x2004 = x17 * x2001 + x1995
    x2005 = x1587 * x18 + x1596
    x2006 = x18 * x2001 + x2005
    x2007 = x1466 + x1530 * x16 + x16 * (x1530 + x16 * x1601)
    x2008 = x1587 + x1601 * x17
    x2009 = x1514 + x1530 * x17 + x16 * x2008
    x2010 = x1601 * x18 + x1608
    x2011 = x16 * x2010 + x1981
    x2012 = x1573 + x1587 * x17 + x17 * x2008
    x2013 = x17 * x2010 + x2005
    x2014 = x1608 * x18 + x1617 + x18 * x2010
    x2015 = x1266 * x485 - x1267 * x496 + 2 * x544
    x2016 = -x1268 * x496 + x1275 * x485 + 2 * x549
    x2017 = x16 * x2016
    x2018 = x17 * x2016
    x2019 = (
        x1288 * x485
        - x1289 * x496
        + 2 * x598
        + x81 * (x1268 * x485 - x1269 * x496 + 2 * x545)
    )
    x2020 = x2018 + x2019
    x2021 = (
        x1296 * x485
        - x1300 * x496
        + 2 * x603
        + x81 * (x1267 * x485 - x1281 * x496 + 2 * x554)
    )
    x2022 = (
        x1304 * x485
        - x1309 * x496
        + 2 * x634
        + x86
        * (
            x1289 * x485
            - x1297 * x496
            + 2 * x604
            + x81 * (x1269 * x485 - x1282 * x496 + 2 * x563)
        )
    )
    x2023 = x17 * x2019 + x2022
    x2024 = x18 * x2019
    x2025 = (
        -x1292 * x496
        + x1317 * x485
        + 2 * x663
        + x81 * (-x1272 * x496 + x1277 * x485 + 2 * x550)
    )
    x2026 = x16 * x2025
    x2027 = x17 * x2025
    x2028 = (
        -x1307 * x496
        + x1323 * x485
        + 2 * x679
        + x86
        * (
            x1292 * x485
            - x1293 * x496
            + 2 * x599
            + x81 * (x1272 * x485 - x1273 * x496 + 2 * x546)
        )
    )
    x2029 = x2027 + x2028
    x2030 = (
        x1330 * x485
        - x1331 * x496
        + x17 * x2028
        + 2 * x698
        + x88
        * (
            x1307 * x485
            - x1308 * x496
            + 2 * x635
            + x86
            * (
                x1293 * x485
                - x1299 * x496
                + 2 * x611
                + x81 * (x1273 * x485 - x1284 * x496 + 2 * x564)
            )
        )
    )
    x2031 = x18 * x2028
    x2032 = (
        -x1322 * x496
        + x1337 * x485
        + 2 * x719
        + x86
        * (
            -x1290 * x496
            + x1316 * x485
            + 2 * x664
            + x81 * (-x1270 * x496 + x1276 * x485 + 2 * x551)
        )
    )
    x2033 = x16 * x2032
    x2034 = x17 * x2032
    x2035 = (
        -x1328 * x496
        + x1342 * x485
        + 2 * x731
        + x88
        * (
            -x1305 * x496
            + x1322 * x485
            + 2 * x680
            + x86
            * (
                x1290 * x485
                - x1291 * x496
                + 2 * x600
                + x81 * (x1270 * x485 - x1271 * x496 + 2 * x547)
            )
        )
    )
    x2036 = x2034 + x2035
    x2037 = x1352 * x485 - x1353 * x496 + x827
    x2038 = -x1354 * x496 + x1371 * x485 + x832
    x2039 = x1377 * x485 - x1390 * x496 + x16 * x2037 + x16 * (x16 * x2038 + x2037) + x826
    x2040 = (
        x1393 * x485 - x1394 * x496 + x81 * (x1354 * x485 - x1357 * x496 + x828) + x902
    )
    x2041 = x17 * x2038 + x2040
    x2042 = (
        x1407 * x485 - x1417 * x496 + x81 * (x1353 * x485 - x1380 * x496 + x836) + x907
    )
    x2043 = x16 * x2041 + x17 * x2037 + x2042
    x2044 = x1422 * x485 - x1423 * x496 + x939
    x2045 = x18 * x2038 + x2044
    x2046 = x1431 * x485 - x1435 * x496 + x945
    x2047 = x16 * x2045 + x18 * x2037 + x2046
    x2048 = (
        x1439 * x485
        - x1450 * x496
        + x86
        * (
            x1394 * x485
            - x1410 * x496
            + x81 * (x1357 * x485 - x1383 * x496 + x853)
            + x908
        )
        + x979
    )
    x2049 = x17 * x2040 + x2048
    x2050 = x17 * x2041 + x2049
    x2051 = (
        x1001 + x1456 * x485 - x1461 * x496 + x81 * (x1423 * x485 - x1432 * x496 + x947)
    )
    x2052 = x18 * x2040 + x2051
    x2053 = x17 * x2045 + x2052
    x2054 = x1020 + x1466 * x485 - x1471 * x496
    x2055 = x18 * x2044 + x2054
    x2056 = x18 * x2045 + x2055
    x2057 = (
        x1039 - x1401 * x496 + x1477 * x485 + x81 * (-x1366 * x496 + x1375 * x485 + x833)
    )
    x2058 = x16 * x2040 + x16 * (x16 * x2057 + x2040) + x2042
    x2059 = (
        x1055
        - x1446 * x496
        + x1482 * x485
        + x86
        * (
            x1401 * x485
            - x1404 * x496
            + x81 * (x1366 * x485 - x1369 * x496 + x829)
            + x903
        )
    )
    x2060 = x17 * x2057 + x2059
    x2061 = x16 * x2060 + x2049
    x2062 = (
        x1067 - x1457 * x496 + x1488 * x485 + x81 * (x1424 * x485 - x1425 * x496 + x940)
    )
    x2063 = x18 * x2057 + x2062
    x2064 = x16 * x2063 + x2052
    x2065 = (
        x1087
        + x1498 * x485
        - x1499 * x496
        + x17 * x2059
        + x88
        * (
            x1446 * x485
            - x1449 * x496
            + x86
            * (
                x1404 * x485
                - x1416 * x496
                + x81 * (x1369 * x485 - x1389 * x496 + x854)
                + x921
            )
            + x980
        )
    )
    x2066 = x17 * x2060 + x2065
    x2067 = (
        x1102
        + x1506 * x485
        - x1507 * x496
        + x86
        * (
            x1003
            + x1457 * x485
            - x1460 * x496
            + x81 * (x1425 * x485 - x1433 * x496 + x952)
        )
    )
    x2068 = x18 * x2059 + x2067
    x2069 = x17 * x2063 + x2068
    x2070 = (
        x1114 + x1514 * x485 - x1515 * x496 + x81 * (x1021 + x1467 * x485 - x1468 * x496)
    )
    x2071 = x18 * x2062 + x2070
    x2072 = x18 * x2063 + x2071
    x2073 = x1125 - x1424 * x496 + x1521 * x485
    x2074 = x12 * x1973 + x16 * x2044 + x16 * (x16 * x2073 + x2044) + x2046
    x2075 = x17 * x2073 + x2062
    x2076 = x12 * x1975 + x16 * x2075 + x17 * x2044 + x2051
    x2077 = x1137 - x1467 * x496 + x1530 * x485
    x2078 = x18 * x2073 + x2077
    x2079 = x12 * x1977 + x16 * x2078 + x2055
    x2080 = x17 * x2062 + x2067
    x2081 = x12 * x1979 + x17 * x2075 + x2080
    x2082 = x12 * x1980 + x17 * x2078 + x2071
    x2083 = x1154 + x1543 * x485 - x1544 * x496 + x18 * x2077
    x2084 = x12 * x1982 + x18 * x2078 + x2083
    x2085 = (
        x1165
        - x1481 * x496
        + x1548 * x485
        + x86
        * (
            x1040
            - x1397 * x496
            + x1476 * x485
            + x81 * (-x1360 * x496 + x1374 * x485 + x834)
        )
    )
    x2086 = x16 * x2059 + x16 * (x16 * x2085 + x2059) + x2048
    x2087 = (
        x1175
        - x1494 * x496
        + x1552 * x485
        + x88
        * (
            x1056
            - x1442 * x496
            + x1481 * x485
            + x86
            * (
                x1397 * x485
                - x1400 * x496
                + x81 * (x1360 * x485 - x1363 * x496 + x830)
                + x904
            )
        )
    )
    x2088 = x17 * x2085 + x2087
    x2089 = x16 * x2088 + x2065
    x2090 = (
        x1184
        - x1503 * x496
        + x1558 * x485
        + x86
        * (
            x1068
            - x1458 * x496
            + x1489 * x485
            + x81 * (x1426 * x485 - x1427 * x496 + x941)
        )
    )
    x2091 = x18 * x2085 + x2090
    x2092 = x16 * x2091 + x2068
    x2093 = (
        x1195
        + x1563 * x485
        - x1564 * x496
        + x17 * x2087
        + x17 * x2088
        + x90
        * (
            x1088
            + x1494 * x485
            - x1497 * x496
            + x88
            * (
                x1442 * x485
                - x1445 * x496
                + x86
                * (
                    x1400 * x485
                    - x1413 * x496
                    + x81 * (x1363 * x485 - x1386 * x496 + x855)
                    + x922
                )
                + x981
            )
        )
    )
    x2094 = (
        x1202
        + x1568 * x485
        - x1569 * x496
        + x88
        * (
            x1104
            + x1503 * x485
            - x1504 * x496
            + x86
            * (
                x1005
                + x1458 * x485
                - x1459 * x496
                + x81 * (x1427 * x485 - x1434 * x496 + x954)
            )
        )
    )
    x2095 = x17 * x2091 + x18 * x2087 + x2094
    x2096 = (
        x1209
        + x1573 * x485
        - x1574 * x496
        + x86
        * (
            x1115
            + x1512 * x485
            - x1513 * x496
            + x81 * (x1022 + x1469 * x485 - x1470 * x496)
        )
    )
    x2097 = x18 * x2090 + x2096
    x2098 = x18 * x2091 + x2097
    x2099 = (
        x1216 - x1489 * x496 + x1580 * x485 + x81 * (x1126 - x1426 * x496 + x1523 * x485)
    )
    x2100 = x12 * x1998 + x16 * x2062 + x16 * (x16 * x2099 + x2062) + x2051
    x2101 = x17 * x2099 + x2090
    x2102 = x12 * x2000 + x16 * x2101 + x2080
    x2103 = (
        x1226 - x1512 * x496 + x1587 * x485 + x81 * (x1138 - x1469 * x496 + x1531 * x485)
    )
    x2104 = x18 * x2099 + x2103
    x2105 = x12 * x2002 + x16 * x2104 + x2071
    x2106 = x12 * x2003 + x17 * x2090 + x17 * x2101 + x2094
    x2107 = x12 * x2004 + x17 * x2104 + x2097
    x2108 = (
        x1237
        + x1596 * x485
        - x1597 * x496
        + x18 * x2103
        + x81 * (x1155 + x1541 * x485 - x1542 * x496)
    )
    x2109 = x12 * x2006 + x18 * x2104 + x2108
    x2110 = x1242 - x1531 * x496 + x1601 * x485
    x2111 = x12 * x2007 + x16 * x2077 + x16 * (x16 * x2110 + x2077) + x2054
    x2112 = x17 * x2110 + x2103
    x2113 = x12 * x2009 + x16 * x2112 + x17 * x2077 + x2070
    x2114 = x1252 - x1541 * x496 + x1608 * x485
    x2115 = x18 * x2110 + x2114
    x2116 = x12 * x2011 + x16 * x2115 + x2083
    x2117 = x12 * x2012 + x17 * x2103 + x17 * x2112 + x2096
    x2118 = x12 * x2013 + x17 * x2115 + x2108
    x2119 = x12 * x2014 + x1262 + x1617 * x485 - x1618 * x496 + x18 * x2114 + x18 * x2115
    x2120 = x1621 * x485 - x1622 * x496
    x2121 = -x1623 * x496 + x1640 * x485
    x2122 = (
        x13 * x1939
        + x16 * x2120
        + x16 * (x16 * x2121 + x2120)
        + x1646 * x485
        - x1659 * x496
    )
    x2123 = x1661 * x485 - x1662 * x496 + x81 * (x1623 * x485 - x1626 * x496)
    x2124 = x17 * x2121 + x2123
    x2125 = x1675 * x485 - x1685 * x496 + x81 * (x1622 * x485 - x1649 * x496)
    x2126 = x13 * x1942 + x16 * x2124 + x17 * x2120 + x2125
    x2127 = x1688 * x485 - x1689 * x496
    x2128 = x18 * x2121 + x2127
    x2129 = x1696 * x485 - x1700 * x496
    x2130 = x13 * x1945 + x16 * x2128 + x18 * x2120 + x2129
    x2131 = (
        x1703 * x485
        - x1714 * x496
        + x86 * (x1662 * x485 - x1678 * x496 + x81 * (x1626 * x485 - x1652 * x496))
    )
    x2132 = x17 * x2123 + x2131
    x2133 = x13 * x1948 + x17 * x2124 + x2132
    x2134 = x1718 * x485 - x1723 * x496 + x81 * (x1689 * x485 - x1697 * x496)
    x2135 = x18 * x2123 + x2134
    x2136 = x13 * x1951 + x17 * x2128 + x2135
    x2137 = x1727 * x485 - x1732 * x496
    x2138 = x18 * x2127 + x2137
    x2139 = x13 * x1954 + x18 * x2128 + x2138
    x2140 = -x1669 * x496 + x1737 * x485 + x81 * (-x1635 * x496 + x1644 * x485)
    x2141 = x13 * x1956 + x16 * x2123 + x16 * (x16 * x2140 + x2123) + x2125
    x2142 = (
        -x1710 * x496
        + x1741 * x485
        + x86 * (x1669 * x485 - x1672 * x496 + x81 * (x1635 * x485 - x1638 * x496))
    )
    x2143 = x17 * x2140 + x2142
    x2144 = x13 * x1959 + x16 * x2143 + x2132
    x2145 = -x1721 * x496 + x1746 * x485 + x81 * (x1692 * x485 - x1693 * x496)
    x2146 = x18 * x2140 + x2145
    x2147 = x13 * x1962 + x16 * x2146 + x2135
    x2148 = (
        x17 * x2142
        + x1754 * x485
        - x1755 * x496
        + x88
        * (
            x1710 * x485
            - x1713 * x496
            + x86 * (x1672 * x485 - x1684 * x496 + x81 * (x1638 * x485 - x1658 * x496))
        )
    )
    x2149 = x13 * x1965 + x17 * x2143 + x2148
    x2150 = (
        x1760 * x485
        - x1761 * x496
        + x86 * (x1721 * x485 - x1722 * x496 + x81 * (x1693 * x485 - x1699 * x496))
    )
    x2151 = x18 * x2142 + x2150
    x2152 = x13 * x1968 + x17 * x2146 + x2151
    x2153 = x1767 * x485 - x1768 * x496 + x81 * (x1730 * x485 - x1731 * x496)
    x2154 = x18 * x2145 + x2153
    x2155 = x13 * x1971 + x18 * x2146 + x2154
    x2156 = x13 * x1973
    x2157 = -x1692 * x496 + x1774 * x485
    x2158 = x16 * x2127 + x16 * (x16 * x2157 + x2127) + x2129
    x2159 = x13 * x1975
    x2160 = x17 * x2157 + x2145
    x2161 = x16 * x2160 + x17 * x2127 + x2134
    x2162 = x13 * x1977
    x2163 = -x1730 * x496 + x1782 * x485
    x2164 = x18 * x2157 + x2163
    x2165 = x16 * x2164 + x2138
    x2166 = x13 * x1979
    x2167 = x17 * x2145 + x2150
    x2168 = x17 * x2160 + x2167
    x2169 = x13 * x1980
    x2170 = x17 * x2164 + x2154
    x2171 = x13 * x1982
    x2172 = x1794 * x485 - x1795 * x496 + x18 * x2163
    x2173 = x18 * x2164 + x2172
    x2174 = (
        -x1740 * x496
        + x1798 * x485
        + x86 * (-x1665 * x496 + x1736 * x485 + x81 * (-x1629 * x496 + x1643 * x485))
    )
    x2175 = x13 * x1983 + x16 * x2142 + x16 * (x16 * x2174 + x2142) + x2131
    x2176 = (
        -x1750 * x496
        + x1801 * x485
        + x88
        * (
            -x1706 * x496
            + x1740 * x485
            + x86 * (x1665 * x485 - x1668 * x496 + x81 * (x1629 * x485 - x1632 * x496))
        )
    )
    x2177 = x17 * x2174 + x2176
    x2178 = x13 * x1986 + x16 * x2177 + x2148
    x2179 = (
        -x1758 * x496
        + x1805 * x485
        + x86 * (-x1719 * x496 + x1745 * x485 + x81 * (x1690 * x485 - x1691 * x496))
    )
    x2180 = x18 * x2174 + x2179
    x2181 = x13 * x1989 + x16 * x2180 + x2151
    x2182 = (
        x13 * x1991
        + x17 * x2176
        + x17 * x2177
        + x1809 * x485
        - x1810 * x496
        + x90
        * (
            x1750 * x485
            - x1753 * x496
            + x88
            * (
                x1706 * x485
                - x1709 * x496
                + x86
                * (x1668 * x485 - x1681 * x496 + x81 * (x1632 * x485 - x1655 * x496))
            )
        )
    )
    x2183 = (
        x1812 * x485
        - x1813 * x496
        + x88
        * (
            x1758 * x485
            - x1759 * x496
            + x86 * (x1719 * x485 - x1720 * x496 + x81 * (x1691 * x485 - x1698 * x496))
        )
    )
    x2184 = x13 * x1993 + x17 * x2180 + x18 * x2176 + x2183
    x2185 = (
        x1816 * x485
        - x1817 * x496
        + x86 * (x1765 * x485 - x1766 * x496 + x81 * (x1728 * x485 - x1729 * x496))
    )
    x2186 = x18 * x2179 + x2185
    x2187 = x13 * x1996 + x18 * x2180 + x2186
    x2188 = x13 * x1998
    x2189 = -x1745 * x496 + x1822 * x485 + x81 * (-x1690 * x496 + x1773 * x485)
    x2190 = x16 * x2145 + x16 * (x16 * x2189 + x2145) + x2134
    x2191 = x13 * x2000
    x2192 = x17 * x2189 + x2179
    x2193 = x16 * x2192 + x2167
    x2194 = x13 * x2002
    x2195 = -x1765 * x496 + x1829 * x485 + x81 * (-x1728 * x496 + x1781 * x485)
    x2196 = x18 * x2189 + x2195
    x2197 = x16 * x2196 + x2154
    x2198 = x13 * x2003
    x2199 = x17 * x2179 + x17 * x2192 + x2183
    x2200 = x13 * x2004
    x2201 = x17 * x2196 + x2186
    x2202 = x13 * x2006
    x2203 = (
        x18 * x2195 + x1838 * x485 - x1839 * x496 + x81 * (x1792 * x485 - x1793 * x496)
    )
    x2204 = x18 * x2196 + x2203
    x2205 = x13 * x2007
    x2206 = -x1781 * x496 + x1843 * x485
    x2207 = x16 * x2163 + x16 * (x16 * x2206 + x2163) + x2137
    x2208 = x13 * x2009
    x2209 = x17 * x2206 + x2195
    x2210 = x16 * x2209 + x17 * x2163 + x2153
    x2211 = x13 * x2011
    x2212 = -x1792 * x496 + x1850 * x485
    x2213 = x18 * x2206 + x2212
    x2214 = x16 * x2213 + x2172
    x2215 = x13 * x2012
    x2216 = x17 * x2195 + x17 * x2209 + x2185
    x2217 = x13 * x2013
    x2218 = x17 * x2213 + x2203
    x2219 = x13 * x2014
    x2220 = x18 * x2212 + x18 * x2213 + x1859 * x485 - x1860 * x496
    x2221 = x16 * x755 + x16 * (x16 * x785 + x755) + x800
    x2222 = x17 * x785 + x859
    x2223 = x16 * x2222 + x17 * x755 + x881
    x2224 = x1421 + x18 * x785
    x2225 = x1430 + x16 * x2224 + x18 * x755
    x2226 = x17 * x859 + x958
    x2227 = x17 * x2222 + x2226
    x2228 = x1455 + x18 * x859
    x2229 = x17 * x2224 + x2228
    x2230 = x1013 * x763
    x2231 = x1421 * x18 + x2230
    x2232 = x18 * x2224 + x2231
    x2233 = x16 * x859 + x16 * (x1029 * x16 + x859) + x881
    x2234 = x1029 * x17 + x1044
    x2235 = x16 * x2234 + x2226
    x2236 = x1029 * x18 + x1487
    x2237 = x16 * x2236 + x2228
    x2238 = x1044 * x17 + x1073
    x2239 = x17 * x2234 + x2238
    x2240 = x1044 * x18 + x1505
    x2241 = x17 * x2236 + x2240
    x2242 = x1013 * x875
    x2243 = x1487 * x18 + x2242
    x2244 = x18 * x2236 + x2243
    x2245 = x1421 * x16 + x1430 + x16 * (x1421 + x1520 * x16)
    x2246 = x1487 + x1520 * x17
    x2247 = x1421 * x17 + x1455 + x16 * x2246
    x2248 = x1013 * x775
    x2249 = x1520 * x18 + x2248
    x2250 = x16 * x2249 + x2231
    x2251 = x1487 * x17 + x1505
    x2252 = x17 * x2246 + x2251
    x2253 = x17 * x2249 + x2243
    x2254 = x1149 * x778 + x18 * x2248
    x2255 = x18 * x2249 + x2254
    x2256 = x1044 * x16 + x16 * (x1044 + x1160 * x16) + x958
    x2257 = x1160 * x17 + x1169
    x2258 = x16 * x2257 + x2238
    x2259 = x1160 * x18 + x1557
    x2260 = x16 * x2259 + x2240
    x2261 = x1169 * x17 + x1189 + x17 * x2257
    x2262 = x1169 * x18 + x1567 + x17 * x2259
    x2263 = x1013 * x965
    x2264 = x1557 * x18 + x2263
    x2265 = x18 * x2259 + x2264
    x2266 = x1455 + x1487 * x16 + x16 * (x1487 + x1579 * x16)
    x2267 = x1557 + x1579 * x17
    x2268 = x16 * x2267 + x2251
    x2269 = x1013 * x867
    x2270 = x1579 * x18 + x2269
    x2271 = x16 * x2270 + x2243
    x2272 = x1557 * x17 + x1567 + x17 * x2267
    x2273 = x17 * x2270 + x2264
    x2274 = x1149 * x870 + x18 * x2269
    x2275 = x18 * x2270 + x2274
    x2276 = x1013 * x788
    x2277 = x16 * x2248 + x16 * (x16 * x2276 + x2248) + x2230
    x2278 = x17 * x2276 + x2269
    x2279 = x16 * x2278 + x17 * x2248 + x2242
    x2280 = x1149 * x767
    x2281 = x18 * x2276 + x2280
    x2282 = x16 * x2281 + x2254
    x2283 = x17 * x2269 + x17 * x2278 + x2263
    x2284 = x17 * x2281 + x2274
    x2285 = x1261 * x770 + x18 * x2280 + x18 * x2281
    x2286 = x12 * x2221 + x1939
    x2287 = x12 * x2223 + x1942
    x2288 = x12 * x2225 + x1945
    x2289 = x12 * x2227 + x1948
    x2290 = x12 * x2229 + x1951
    x2291 = x12 * x2232 + x1954
    x2292 = x12 * x2233 + x1956
    x2293 = x12 * x2235 + x1959
    x2294 = x12 * x2237 + x1962
    x2295 = x12 * x2239 + x1965
    x2296 = x12 * x2241 + x1968
    x2297 = x12 * x2244 + x1971
    x2298 = x12 * x2245 + x1973
    x2299 = x12 * x2247 + x1975
    x2300 = x12 * x2250 + x1977
    x2301 = x12 * x2252 + x1979
    x2302 = x12 * x2253 + x1980
    x2303 = x12 * x2255 + x1982
    x2304 = x12 * x2256 + x1983
    x2305 = x12 * x2258 + x1986
    x2306 = x12 * x2260 + x1989
    x2307 = x12 * x2261 + x1991
    x2308 = x12 * x2262 + x1993
    x2309 = x12 * x2265 + x1996
    x2310 = x12 * x2266 + x1998
    x2311 = x12 * x2268 + x2000
    x2312 = x12 * x2271 + x2002
    x2313 = x12 * x2272 + x2003
    x2314 = x12 * x2273 + x2004
    x2315 = x12 * x2275 + x2006
    x2316 = x12 * x2277 + x2007
    x2317 = x12 * x2279 + x2009
    x2318 = x12 * x2282 + x2011
    x2319 = x12 * x2283 + x2012
    x2320 = x12 * x2284 + x2013
    x2321 = x12 * x2285 + x2014
    x2322 = x16 * x1621 + x16 * (x16 * x1640 + x1621) + x1646
    x2323 = x13 * x2221 + x2322
    x2324 = x1640 * x17 + x1661
    x2325 = x16 * x2324 + x1621 * x17 + x1675
    x2326 = x13 * x2223 + x2325
    x2327 = x1640 * x18 + x1688
    x2328 = x16 * x2327 + x1621 * x18 + x1696
    x2329 = x13 * x2225 + x2328
    x2330 = x1661 * x17 + x1703
    x2331 = x17 * x2324 + x2330
    x2332 = x13 * x2227 + x2331
    x2333 = x1661 * x18 + x1718
    x2334 = x17 * x2327 + x2333
    x2335 = x13 * x2229 + x2334
    x2336 = x1688 * x18 + x1727
    x2337 = x18 * x2327 + x2336
    x2338 = x13 * x2232 + x2337
    x2339 = x16 * x1661 + x16 * (x16 * x1737 + x1661) + x1675
    x2340 = x13 * x2233 + x2339
    x2341 = x17 * x1737 + x1741
    x2342 = x16 * x2341 + x2330
    x2343 = x13 * x2235 + x2342
    x2344 = x1737 * x18 + x1746
    x2345 = x16 * x2344 + x2333
    x2346 = x13 * x2237 + x2345
    x2347 = x17 * x1741 + x1754
    x2348 = x17 * x2341 + x2347
    x2349 = x13 * x2239 + x2348
    x2350 = x1741 * x18 + x1760
    x2351 = x17 * x2344 + x2350
    x2352 = x13 * x2241 + x2351
    x2353 = x1746 * x18 + x1767
    x2354 = x18 * x2344 + x2353
    x2355 = x13 * x2244 + x2354
    x2356 = x16 * x1688 + x16 * (x16 * x1774 + x1688) + x1696
    x2357 = x13 * x2245 + x2356
    x2358 = x17 * x1774 + x1746
    x2359 = x16 * x2358 + x1688 * x17 + x1718
    x2360 = x13 * x2247 + x2359
    x2361 = x1774 * x18 + x1782
    x2362 = x16 * x2361 + x2336
    x2363 = x13 * x2250 + x2362
    x2364 = x17 * x1746 + x1760
    x2365 = x17 * x2358 + x2364
    x2366 = x13 * x2252 + x2365
    x2367 = x17 * x2361 + x2353
    x2368 = x13 * x2253 + x2367
    x2369 = x1782 * x18 + x1794
    x2370 = x18 * x2361 + x2369
    x2371 = x13 * x2255 + x2370
    x2372 = x16 * x1741 + x16 * (x16 * x1798 + x1741) + x1703
    x2373 = x13 * x2256 + x2372
    x2374 = x17 * x1798 + x1801
    x2375 = x16 * x2374 + x2347
    x2376 = x13 * x2258 + x2375
    x2377 = x1798 * x18 + x1805
    x2378 = x16 * x2377 + x2350
    x2379 = x13 * x2260 + x2378
    x2380 = x17 * x1801 + x17 * x2374 + x1809
    x2381 = x13 * x2261 + x2380
    x2382 = x17 * x2377 + x18 * x1801 + x1812
    x2383 = x13 * x2262 + x2382
    x2384 = x18 * x1805 + x1816
    x2385 = x18 * x2377 + x2384
    x2386 = x13 * x2265 + x2385
    x2387 = x16 * x1746 + x16 * (x16 * x1822 + x1746) + x1718
    x2388 = x13 * x2266 + x2387
    x2389 = x17 * x1822 + x1805
    x2390 = x16 * x2389 + x2364
    x2391 = x13 * x2268 + x2390
    x2392 = x18 * x1822 + x1829
    x2393 = x16 * x2392 + x2353
    x2394 = x13 * x2271 + x2393
    x2395 = x17 * x1805 + x17 * x2389 + x1812
    x2396 = x13 * x2272 + x2395
    x2397 = x17 * x2392 + x2384
    x2398 = x13 * x2273 + x2397
    x2399 = x18 * x1829 + x1838
    x2400 = x18 * x2392 + x2399
    x2401 = x13 * x2275 + x2400
    x2402 = x16 * x1782 + x16 * (x16 * x1843 + x1782) + x1727
    x2403 = x13 * x2277 + x2402
    x2404 = x17 * x1843 + x1829
    x2405 = x16 * x2404 + x17 * x1782 + x1767
    x2406 = x13 * x2279 + x2405
    x2407 = x18 * x1843 + x1850
    x2408 = x16 * x2407 + x2369
    x2409 = x13 * x2282 + x2408
    x2410 = x17 * x1829 + x17 * x2404 + x1816
    x2411 = x13 * x2283 + x2410
    x2412 = x17 * x2407 + x2399
    x2413 = x13 * x2284 + x2412
    x2414 = x18 * x1850 + x18 * x2407 + x1859
    x2415 = x13 * x2285 + x2414
    x2416 = x1621 * x753 - x1622 * x765 + 2 * x827
    x2417 = -x1623 * x765 + x1640 * x753 + 2 * x832
    x2418 = x1661 * x753 - x1662 * x765 + 2 * x902
    x2419 = x17 * x2417 + x2418
    x2420 = x1675 * x753 - x1685 * x765 + 2 * x907
    x2421 = (
        x1688 * x753
        - x1689 * x765
        + x81 * (x1623 * x753 - x1626 * x765 + 2 * x828)
        + 2 * x939
    )
    x2422 = x18 * x2417 + x2421
    x2423 = (
        x1696 * x753
        - x1700 * x765
        + x81 * (x1622 * x753 - x1649 * x765 + 2 * x836)
        + 2 * x945
    )
    x2424 = x1703 * x753 - x1714 * x765 + 2 * x979
    x2425 = x17 * x2418 + x2424
    x2426 = (
        2 * x1001
        + x1718 * x753
        - x1723 * x765
        + x81 * (x1662 * x753 - x1678 * x765 + 2 * x908)
    )
    x2427 = x18 * x2418 + x2426
    x2428 = (
        2 * x1020
        + x1727 * x753
        - x1732 * x765
        + x86
        * (
            x1689 * x753
            - x1697 * x765
            + x81 * (x1626 * x753 - x1652 * x765 + 2 * x853)
            + 2 * x947
        )
    )
    x2429 = x18 * x2421 + x2428
    x2430 = 2 * x1039 - x1669 * x765 + x1737 * x753
    x2431 = 2 * x1055 - x1710 * x765 + x1741 * x753
    x2432 = x17 * x2430 + x2431
    x2433 = (
        2 * x1067
        - x1721 * x765
        + x1746 * x753
        + x81 * (x1669 * x753 - x1672 * x765 + 2 * x903)
    )
    x2434 = x18 * x2430 + x2433
    x2435 = 2 * x1087 + x17 * x2431 + x1754 * x753 - x1755 * x765
    x2436 = (
        2 * x1102
        + x1760 * x753
        - x1761 * x765
        + x81 * (x1710 * x753 - x1713 * x765 + 2 * x980)
    )
    x2437 = x18 * x2431 + x2436
    x2438 = (
        2 * x1114
        + x1767 * x753
        - x1768 * x765
        + x86
        * (
            2 * x1003
            + x1721 * x753
            - x1722 * x765
            + x81 * (x1672 * x753 - x1684 * x765 + 2 * x921)
        )
    )
    x2439 = x18 * x2433 + x2438
    x2440 = (
        2 * x1125
        - x1692 * x765
        + x1774 * x753
        + x81 * (-x1635 * x765 + x1644 * x753 + 2 * x833)
    )
    x2441 = x17 * x2440 + x2433
    x2442 = (
        2 * x1137
        - x1730 * x765
        + x1782 * x753
        + x86
        * (
            x1692 * x753
            - x1693 * x765
            + x81 * (x1635 * x753 - x1638 * x765 + 2 * x829)
            + 2 * x940
        )
    )
    x2443 = x18 * x2440 + x2442
    x2444 = x17 * x2433 + x2436
    x2445 = (
        2 * x1154
        + x1794 * x753
        - x1795 * x765
        + x18 * x2442
        + x88
        * (
            2 * x1021
            + x1730 * x753
            - x1731 * x765
            + x86
            * (
                x1693 * x753
                - x1699 * x765
                + x81 * (x1638 * x753 - x1658 * x765 + 2 * x854)
                + 2 * x952
            )
        )
    )
    x2446 = 2 * x1165 - x1740 * x765 + x1798 * x753
    x2447 = 2 * x1175 - x1750 * x765 + x1801 * x753
    x2448 = x17 * x2446 + x2447
    x2449 = (
        2 * x1184
        - x1758 * x765
        + x1805 * x753
        + x81 * (2 * x1056 - x1706 * x765 + x1740 * x753)
    )
    x2450 = x18 * x2446 + x2449
    x2451 = (
        2 * x1202
        + x1812 * x753
        - x1813 * x765
        + x81 * (2 * x1088 + x1750 * x753 - x1753 * x765)
    )
    x2452 = (
        2 * x1209
        + x1816 * x753
        - x1817 * x765
        + x86
        * (
            2 * x1104
            + x1758 * x753
            - x1759 * x765
            + x81 * (x1706 * x753 - x1709 * x765 + 2 * x981)
        )
    )
    x2453 = x18 * x2449 + x2452
    x2454 = (
        2 * x1216
        - x1745 * x765
        + x1822 * x753
        + x81 * (2 * x1040 - x1665 * x765 + x1736 * x753)
    )
    x2455 = x17 * x2454 + x2449
    x2456 = (
        2 * x1226
        - x1765 * x765
        + x1829 * x753
        + x86
        * (
            2 * x1068
            - x1719 * x765
            + x1745 * x753
            + x81 * (x1665 * x753 - x1668 * x765 + 2 * x904)
        )
    )
    x2457 = x18 * x2454 + x2456
    x2458 = (
        2 * x1237
        + x18 * x2456
        + x1838 * x753
        - x1839 * x765
        + x88
        * (
            2 * x1115
            + x1765 * x753
            - x1766 * x765
            + x86
            * (
                2 * x1005
                + x1719 * x753
                - x1720 * x765
                + x81 * (x1668 * x753 - x1681 * x765 + 2 * x922)
            )
        )
    )
    x2459 = (
        2 * x1242
        - x1781 * x765
        + x1843 * x753
        + x86
        * (
            2 * x1126
            - x1690 * x765
            + x1773 * x753
            + x81 * (-x1629 * x765 + x1643 * x753 + 2 * x834)
        )
    )
    x2460 = x17 * x2459 + x2456
    x2461 = (
        2 * x1252
        - x1792 * x765
        + x1850 * x753
        + x88
        * (
            2 * x1138
            - x1728 * x765
            + x1781 * x753
            + x86
            * (
                x1690 * x753
                - x1691 * x765
                + x81 * (x1629 * x753 - x1632 * x765 + 2 * x830)
                + 2 * x941
            )
        )
    )
    x2462 = x18 * x2459 + x2461

    # 648 item(s)
    S = numpy.array(
        [
            x11 * x187
            + x11 * (x11 * x189 + x187)
            + x113 * (x111 - x92)
            + x127 * x3
            + x16 * x168
            + x16 * (x168 + x185)
            - x82
            * (x128 + x147 * x90 + x3 * x91 - x82 * (-x135 * x82 + x139 * x90 + x3 * x74))
            + x90
            * (
                x113 * (x110 - x116)
                + x126 * x3
                - x147 * x82
                + x88
                * (
                    x113 * (x109 - x118)
                    + x125 * x3
                    - x146 * x82
                    + x86
                    * (
                        x113 * (x108 - x123)
                        + x124 * x3
                        - x145 * x82
                        + x81
                        * (
                            x113 * (2 * x10 * x14 * x20 * x3 * x41 * x6 - x105 - x121)
                            + x122 * x3
                            - x144 * x82
                        )
                    )
                )
            ),
            x11 * x270 + x11 * (x11 * x273 + x270) + x16 * x276 + x168 * x17 + x292,
            x11 * x293 + x11 * (x11 * x294 + x293) + x168 * x18 + x18 * x185,
            x11 * x337 + x11 * (x11 * x339 + x337) + x17 * x276 + x352,
            x11 * x354 + x11 * (x11 * x356 + x354) + x18 * x274 + x357,
            x11 * x358 + x11 * (x175 * x359 + x358) + x184 * x19,
            x11 * x372
            + x11 * (x11 * x374 + x372)
            + x16 * x275
            + x16 * (x275 + x376)
            + x292,
            x11 * x390 + x11 * (x11 * x393 + x390) + x16 * x396 + x352,
            x11 * x397 + x11 * (x11 * x398 + x397) + x18 * x376 + x357,
            x11 * x422 + x11 * (x11 * x424 + x422) + x17 * x396 + x431,
            x11 * x433 + x11 * (x11 * x435 + x433) + x18 * x394 + x436,
            x11 * x437 + x11 * (x359 * x368 + x437) + x19 * x375,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x445
            + x11 * (x11 * x447 + x445)
            + x16 * x395
            + x16 * (x395 + x449)
            + x351,
            x11 * x458 + x11 * (x11 * x461 + x458) + x16 * x464 + x431,
            x11 * x465 + x11 * (x11 * x466 + x465) + x18 * x449 + x436,
            x11 * x480
            + x11 * (x11 * x481 + x480)
            + x113 * (x3 * x467 - x470 - x474)
            + x17 * x463
            + x17 * x464
            + x3 * x477
            - x82 * (x3 * x473 + x478 - x82 * (x3 * x471 - x479 * x82)),
            x11 * x482 + x11 * (x11 * x483 + x482) + x18 * x462 + x18 * x463,
            x11 * x484 + x11 * (x359 * x441 + x484) + x19 * x448,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x542 + x12 * x187 + x567,
            x11 * x596 + x12 * x270 + x615,
            x11 * x617 + x12 * x293 + x618,
            x11 * x633 + x12 * x337 + x644,
            x11 * x647 + x12 * x354 + x649,
            x11 * x652 + x12 * x358 + x653,
            x11 * x662 + x12 * x372 + x667,
            x11 * x677 + x12 * x390 + x683,
            x11 * x685 + x12 * x397 + x686,
            x11 * x697 + x12 * x422 + x704,
            x11 * x707 + x12 * x433 + x709,
            x11 * x711 + x12 * x437 + x712,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x718 + x12 * x445 + x722,
            x11 * x729 + x12 * x458 + x734,
            x11 * x736 + x12 * x465 + x737,
            x11 * x743 + x12 * x480 + x746,
            x11 * x748 + x12 * x482 + x749,
            x11 * x751 + x12 * x484 + x752,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x825 + x13 * x187 + x857,
            x11 * x901 + x13 * x270 + x925,
            x11 * x938 + x13 * x293 + x956,
            x11 * x978 + x13 * x337 + x993,
            x1010 + x11 * x999 + x13 * x354,
            x1019 * x11 + x1027 + x13 * x358,
            x1038 * x11 + x1042 + x13 * x372,
            x1054 * x11 + x1059 + x13 * x390,
            x1066 * x11 + x1071 + x13 * x397,
            x1086 * x11 + x1095 + x13 * x422,
            x11 * x1100 + x1108 + x13 * x433,
            x11 * x1113 + x1119 + x13 * x437,
            x1128,
            x1132,
            x1141,
            x1145,
            x1147,
            x1158,
            x11 * x1164 + x1167 + x13 * x445,
            x11 * x1174 + x1178 + x13 * x458,
            x11 * x1183 + x1187 + x13 * x465,
            x11 * x1194 + x1197 + x13 * x480,
            x11 * x1200 + x1204 + x13 * x482,
            x11 * x1208 + x1212 + x13 * x484,
            x1218,
            x1222,
            x1229,
            x1231,
            x1233,
            x1239,
            x1244,
            x1248,
            x1255,
            x1257,
            x1259,
            x1265,
            x12 * x542 + x1286,
            x12 * x596 + x1302,
            x12 * x617 + x1303,
            x12 * x633 + x1312,
            x12 * x647 + x1314,
            x12 * x652 + x1315,
            x12 * x662 + x1320,
            x12 * x677 + x1326,
            x12 * x685 + x1327,
            x12 * x697 + x1333,
            x12 * x707 + x1335,
            x12 * x711 + x1336,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x718 + x1340,
            x12 * x729 + x1345,
            x12 * x736 + x1346,
            x12 * x743 + x1349,
            x12 * x748 + x1350,
            x12 * x751 + x1351,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x825 + x1392,
            x12 * x901 + x1420,
            x12 * x938 + x1438,
            x12 * x978 + x1454,
            x12 * x999 + x1465,
            x1019 * x12 + x1475,
            x1038 * x12 + x1480,
            x1054 * x12 + x1486,
            x1066 * x12 + x1493,
            x1086 * x12 + x1502,
            x1100 * x12 + x1511,
            x1113 * x12 + x1519,
            x1526,
            x1529,
            x1535,
            x1538,
            x1540,
            x1547,
            x1164 * x12 + x1551,
            x1174 * x12 + x1556,
            x1183 * x12 + x1562,
            x1194 * x12 + x1566,
            x12 * x1200 + x1572,
            x12 * x1208 + x1578,
            x1583,
            x1586,
            x1591,
            x1593,
            x1595,
            x1600,
            x1604,
            x1607,
            x1612,
            x1614,
            x1616,
            x1620,
            x13 * x825 + x1660,
            x13 * x901 + x1687,
            x13 * x938 + x1702,
            x13 * x978 + x1717,
            x13 * x999 + x1726,
            x1019 * x13 + x1735,
            x1038 * x13 + x1739,
            x1054 * x13 + x1744,
            x1066 * x13 + x1749,
            x1086 * x13 + x1757,
            x1100 * x13 + x1764,
            x1113 * x13 + x1771,
            2 * x1772 + x1776,
            2 * x1777 + x1779,
            2 * x1780 + x1785,
            2 * x1786 + x1788,
            2 * x1789 + x1790,
            2 * x1791 + x1797,
            x1164 * x13 + x1800,
            x1174 * x13 + x1804,
            x1183 * x13 + x1808,
            x1194 * x13 + x1811,
            x1200 * x13 + x1815,
            x1208 * x13 + x1820,
            2 * x1821 + x1824,
            2 * x1825 + x1827,
            2 * x1828 + x1832,
            2 * x1833 + x1834,
            2 * x1835 + x1836,
            2 * x1837 + x1841,
            2 * x1842 + x1845,
            2 * x1846 + x1848,
            2 * x1849 + x1853,
            2 * x1854 + x1855,
            2 * x1856 + x1857,
            2 * x1858 + x1861,
            x11 * x541 + x11 * (x11 * x1863 + x541) + x567,
            x11 * x595 + x11 * (x11 * x1866 + x595) + x615,
            x11 * x616 + x11 * (x11 * x1867 + x616) + x618,
            x11 * x632 + x11 * (x11 * x1869 + x632) + x644,
            x11 * x646 + x11 * (x11 * x1871 + x646) + x649,
            x11 * x651 + x11 * (x359 * x512 + x651) + x653,
            x11 * x661 + x11 * (x11 * x1873 + x661) + x667,
            x11 * x676 + x11 * (x11 * x1876 + x676) + x683,
            x11 * x684 + x11 * (x11 * x1877 + x684) + x686,
            x11 * x696 + x11 * (x11 * x1879 + x696) + x704,
            x11 * x706 + x11 * (x11 * x1881 + x706) + x709,
            x11 * x710 + x11 * (x359 * x657 + x710) + x712,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x717 + x11 * (x11 * x1883 + x717) + x722,
            x11 * x728 + x11 * (x11 * x1886 + x728) + x734,
            x11 * x735 + x11 * (x11 * x1887 + x735) + x737,
            x11 * x742 + x11 * (x11 * x1888 + x742) + x746,
            x11 * x747 + x11 * (x11 * x1889 + x747) + x749,
            x11 * x750 + x11 * (x359 * x713 + x750) + x752,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x1892 + x1286,
            x11 * x1896 + x1302,
            x11 * x1898 + x1303,
            x11 * x1901 + x1312,
            x11 * x1904 + x1314,
            x11 * x1906 + x1315,
            x11 * x1909 + x1320,
            x11 * x1913 + x1326,
            x11 * x1915 + x1327,
            x11 * x1918 + x1333,
            x11 * x1921 + x1335,
            x11 * x1923 + x1336,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x1926 + x1340,
            x11 * x1930 + x1345,
            x11 * x1932 + x1346,
            x11 * x1934 + x1349,
            x11 * x1936 + x1350,
            x11 * x1938 + x1351,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x11 * x1940 + x1392,
            x11 * x1943 + x1420,
            x11 * x1946 + x1438,
            x11 * x1949 + x1454,
            x11 * x1952 + x1465,
            x11 * x1955 + x1475,
            x11 * x1957 + x1480,
            x11 * x1960 + x1486,
            x11 * x1963 + x1493,
            x11 * x1966 + x1502,
            x11 * x1969 + x1511,
            x11 * x1972 + x1519,
            x11 * x1973 + x1525,
            x11 * x1975 + x1528,
            x11 * x1977 + x1534,
            x11 * x1979 + x1537,
            x11 * x1980 + x1539,
            x11 * x1982 + x1546,
            x11 * x1984 + x1551,
            x11 * x1987 + x1556,
            x11 * x1990 + x1562,
            x11 * x1992 + x1566,
            x11 * x1994 + x1572,
            x11 * x1997 + x1578,
            x11 * x1998 + x1582,
            x11 * x2000 + x1585,
            x11 * x2002 + x1590,
            x11 * x2003 + x1592,
            x11 * x2004 + x1594,
            x11 * x2006 + x1599,
            x11 * x2007 + x1603,
            x11 * x2009 + x1606,
            x11 * x2011 + x1611,
            x11 * x2012 + x1613,
            x11 * x2013 + x1615,
            x11 * x2014 + x1619,
            x12 * x1891
            + x12 * x1892
            + x1280 * x485
            - x1285 * x496
            + x16 * x2015
            + x16 * (x2015 + x2017)
            + 2 * x543,
            x12 * x1895 + x12 * x1896 + x16 * x2020 + x17 * x2015 + x2021,
            x12 * x1897 + x12 * x1898 + x18 * x2015 + x18 * x2017,
            x12 * x1900 + x12 * x1901 + x17 * x2020 + x2023,
            x12 * x1903 + x12 * x1904 + x18 * x2018 + x2024,
            x12 * x1905 + x12 * x1906 + x19 * x2016,
            x12 * x1908 + x12 * x1909 + x16 * x2019 + x16 * (x2019 + x2026) + x2021,
            x12 * x1912 + x12 * x1913 + x16 * x2029 + x2023,
            x12 * x1914 + x12 * x1915 + x18 * x2026 + x2024,
            x12 * x1917 + x12 * x1918 + x17 * x2029 + x2030,
            x12 * x1920 + x12 * x1921 + x18 * x2027 + x2031,
            x12 * x1922 + x12 * x1923 + x19 * x2025,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x1925 + x12 * x1926 + x16 * x2028 + x16 * (x2028 + x2033) + x2022,
            x12 * x1929 + x12 * x1930 + x16 * x2036 + x2030,
            x12 * x1931 + x12 * x1932 + x18 * x2033 + x2031,
            x12 * x1933
            + x12 * x1934
            + x1347 * x485
            - x1348 * x496
            + x17 * x2035
            + x17 * x2036
            + 2 * x744
            + x90
            * (
                x1328 * x485
                - x1329 * x496
                + 2 * x699
                + x88
                * (
                    x1305 * x485
                    - x1306 * x496
                    + 2 * x636
                    + x86
                    * (
                        x1291 * x485
                        - x1298 * x496
                        + 2 * x612
                        + x81 * (x1271 * x485 - x1283 * x496 + 2 * x565)
                    )
                )
            ),
            x12 * x1935 + x12 * x1936 + x18 * x2034 + x18 * x2035,
            x12 * x1937 + x12 * x1938 + x19 * x2032,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x12 * x1940 + x13 * x1891 + x2039,
            x12 * x1943 + x13 * x1895 + x2043,
            x12 * x1946 + x13 * x1897 + x2047,
            x12 * x1949 + x13 * x1900 + x2050,
            x12 * x1952 + x13 * x1903 + x2053,
            x12 * x1955 + x13 * x1905 + x2056,
            x12 * x1957 + x13 * x1908 + x2058,
            x12 * x1960 + x13 * x1912 + x2061,
            x12 * x1963 + x13 * x1914 + x2064,
            x12 * x1966 + x13 * x1917 + x2066,
            x12 * x1969 + x13 * x1920 + x2069,
            x12 * x1972 + x13 * x1922 + x2072,
            x2074,
            x2076,
            x2079,
            x2081,
            x2082,
            x2084,
            x12 * x1984 + x13 * x1925 + x2086,
            x12 * x1987 + x13 * x1929 + x2089,
            x12 * x1990 + x13 * x1931 + x2092,
            x12 * x1992 + x13 * x1933 + x2093,
            x12 * x1994 + x13 * x1935 + x2095,
            x12 * x1997 + x13 * x1937 + x2098,
            x2100,
            x2102,
            x2105,
            x2106,
            x2107,
            x2109,
            x2111,
            x2113,
            x2116,
            x2117,
            x2118,
            x2119,
            x13 * x1940 + x2122,
            x13 * x1943 + x2126,
            x13 * x1946 + x2130,
            x13 * x1949 + x2133,
            x13 * x1952 + x2136,
            x13 * x1955 + x2139,
            x13 * x1957 + x2141,
            x13 * x1960 + x2144,
            x13 * x1963 + x2147,
            x13 * x1966 + x2149,
            x13 * x1969 + x2152,
            x13 * x1972 + x2155,
            2 * x2156 + x2158,
            2 * x2159 + x2161,
            2 * x2162 + x2165,
            2 * x2166 + x2168,
            2 * x2169 + x2170,
            2 * x2171 + x2173,
            x13 * x1984 + x2175,
            x13 * x1987 + x2178,
            x13 * x1990 + x2181,
            x13 * x1992 + x2182,
            x13 * x1994 + x2184,
            x13 * x1997 + x2187,
            2 * x2188 + x2190,
            2 * x2191 + x2193,
            2 * x2194 + x2197,
            2 * x2198 + x2199,
            2 * x2200 + x2201,
            2 * x2202 + x2204,
            2 * x2205 + x2207,
            2 * x2208 + x2210,
            2 * x2211 + x2214,
            2 * x2215 + x2216,
            2 * x2217 + x2218,
            2 * x2219 + x2220,
            x11 * x824 + x11 * (x11 * x2221 + x824) + x857,
            x11 * x900 + x11 * (x11 * x2223 + x900) + x925,
            x11 * x937 + x11 * (x11 * x2225 + x937) + x956,
            x11 * x977 + x11 * (x11 * x2227 + x977) + x993,
            x1010 + x11 * x998 + x11 * (x11 * x2229 + x998),
            x1018 * x11 + x1027 + x11 * (x1018 + x11 * x2232),
            x1037 * x11 + x1042 + x11 * (x1037 + x11 * x2233),
            x1053 * x11 + x1059 + x11 * (x1053 + x11 * x2235),
            x1065 * x11 + x1071 + x11 * (x1065 + x11 * x2237),
            x1085 * x11 + x1095 + x11 * (x1085 + x11 * x2239),
            x1099 * x11 + x11 * (x1099 + x11 * x2241) + x1108,
            x11 * x1112 + x11 * (x11 * x2244 + x1112) + x1119,
            x11 * (x11 * x2245 + x1124) + x1128,
            x11 * (x11 * x2247 + x1130) + x1132,
            x11 * (x11 * x2250 + x1136) + x1141,
            x11 * (x11 * x2252 + x1143) + x1145,
            x11 * (x11 * x2253 + x1146) + x1147,
            x11 * (x11 * x2255 + x1153) + x1158,
            x11 * x1163 + x11 * (x11 * x2256 + x1163) + x1167,
            x11 * x1173 + x11 * (x11 * x2258 + x1173) + x1178,
            x11 * x1182 + x11 * (x11 * x2260 + x1182) + x1187,
            x11 * x1193 + x11 * (x11 * x2261 + x1193) + x1197,
            x11 * x1199 + x11 * (x11 * x2262 + x1199) + x1204,
            x11 * x1207 + x11 * (x11 * x2265 + x1207) + x1212,
            x11 * (x11 * x2266 + x1215) + x1218,
            x11 * (x11 * x2268 + x1220) + x1222,
            x11 * (x11 * x2271 + x1225) + x1229,
            x11 * (x11 * x2272 + x1230) + x1231,
            x11 * (x11 * x2273 + x1232) + x1233,
            x11 * (x11 * x2275 + x1236) + x1239,
            x11 * (x11 * x2277 + x1241) + x1244,
            x11 * (x11 * x2279 + x1246) + x1248,
            x11 * (x11 * x2282 + x1251) + x1255,
            x11 * (x11 * x2283 + x1256) + x1257,
            x11 * (x11 * x2284 + x1258) + x1259,
            x11 * (x11 * x2285 + x1264) + x1265,
            x11 * x2286 + x12 * x824 + x1391,
            x11 * x2287 + x12 * x900 + x1419,
            x11 * x2288 + x12 * x937 + x1437,
            x11 * x2289 + x12 * x977 + x1453,
            x11 * x2290 + x12 * x998 + x1464,
            x1018 * x12 + x11 * x2291 + x1474,
            x1037 * x12 + x11 * x2292 + x1479,
            x1053 * x12 + x11 * x2293 + x1485,
            x1065 * x12 + x11 * x2294 + x1492,
            x1085 * x12 + x11 * x2295 + x1501,
            x1099 * x12 + x11 * x2296 + x1510,
            x11 * x2297 + x1112 * x12 + x1518,
            x11 * x2298 + x1526,
            x11 * x2299 + x1529,
            x11 * x2300 + x1535,
            x11 * x2301 + x1538,
            x11 * x2302 + x1540,
            x11 * x2303 + x1547,
            x11 * x2304 + x1163 * x12 + x1550,
            x11 * x2305 + x1173 * x12 + x1555,
            x11 * x2306 + x1182 * x12 + x1561,
            x11 * x2307 + x1193 * x12 + x1565,
            x11 * x2308 + x1199 * x12 + x1571,
            x11 * x2309 + x12 * x1207 + x1577,
            x11 * x2310 + x1583,
            x11 * x2311 + x1586,
            x11 * x2312 + x1591,
            x11 * x2313 + x1593,
            x11 * x2314 + x1595,
            x11 * x2315 + x1600,
            x11 * x2316 + x1604,
            x11 * x2317 + x1607,
            x11 * x2318 + x1612,
            x11 * x2319 + x1614,
            x11 * x2320 + x1616,
            x11 * x2321 + x1620,
            x11 * x2323 + x1660,
            x11 * x2326 + x1687,
            x11 * x2329 + x1702,
            x11 * x2332 + x1717,
            x11 * x2335 + x1726,
            x11 * x2338 + x1735,
            x11 * x2340 + x1739,
            x11 * x2343 + x1744,
            x11 * x2346 + x1749,
            x11 * x2349 + x1757,
            x11 * x2352 + x1764,
            x11 * x2355 + x1771,
            x11 * x2357 + x1772 + x1776,
            x11 * x2360 + x1777 + x1779,
            x11 * x2363 + x1780 + x1785,
            x11 * x2366 + x1786 + x1788,
            x11 * x2368 + x1789 + x1790,
            x11 * x2371 + x1791 + x1797,
            x11 * x2373 + x1800,
            x11 * x2376 + x1804,
            x11 * x2379 + x1808,
            x11 * x2381 + x1811,
            x11 * x2383 + x1815,
            x11 * x2386 + x1820,
            x11 * x2388 + x1821 + x1824,
            x11 * x2391 + x1825 + x1827,
            x11 * x2394 + x1828 + x1832,
            x11 * x2396 + x1833 + x1834,
            x11 * x2398 + x1835 + x1836,
            x11 * x2401 + x1837 + x1841,
            x11 * x2403 + x1842 + x1845,
            x11 * x2406 + x1846 + x1848,
            x11 * x2409 + x1849 + x1853,
            x11 * x2411 + x1854 + x1855,
            x11 * x2413 + x1856 + x1857,
            x11 * x2415 + x1858 + x1861,
            x12 * x1939 + x12 * x2286 + x2039,
            x12 * x1942 + x12 * x2287 + x2043,
            x12 * x1945 + x12 * x2288 + x2047,
            x12 * x1948 + x12 * x2289 + x2050,
            x12 * x1951 + x12 * x2290 + x2053,
            x12 * x1954 + x12 * x2291 + x2056,
            x12 * x1956 + x12 * x2292 + x2058,
            x12 * x1959 + x12 * x2293 + x2061,
            x12 * x1962 + x12 * x2294 + x2064,
            x12 * x1965 + x12 * x2295 + x2066,
            x12 * x1968 + x12 * x2296 + x2069,
            x12 * x1971 + x12 * x2297 + x2072,
            x12 * x2298 + x2074,
            x12 * x2299 + x2076,
            x12 * x2300 + x2079,
            x12 * x2301 + x2081,
            x12 * x2302 + x2082,
            x12 * x2303 + x2084,
            x12 * x1983 + x12 * x2304 + x2086,
            x12 * x1986 + x12 * x2305 + x2089,
            x12 * x1989 + x12 * x2306 + x2092,
            x12 * x1991 + x12 * x2307 + x2093,
            x12 * x1993 + x12 * x2308 + x2095,
            x12 * x1996 + x12 * x2309 + x2098,
            x12 * x2310 + x2100,
            x12 * x2311 + x2102,
            x12 * x2312 + x2105,
            x12 * x2313 + x2106,
            x12 * x2314 + x2107,
            x12 * x2315 + x2109,
            x12 * x2316 + x2111,
            x12 * x2317 + x2113,
            x12 * x2318 + x2116,
            x12 * x2319 + x2117,
            x12 * x2320 + x2118,
            x12 * x2321 + x2119,
            x12 * x2323 + x2122,
            x12 * x2326 + x2126,
            x12 * x2329 + x2130,
            x12 * x2332 + x2133,
            x12 * x2335 + x2136,
            x12 * x2338 + x2139,
            x12 * x2340 + x2141,
            x12 * x2343 + x2144,
            x12 * x2346 + x2147,
            x12 * x2349 + x2149,
            x12 * x2352 + x2152,
            x12 * x2355 + x2155,
            x12 * x2357 + x2156 + x2158,
            x12 * x2360 + x2159 + x2161,
            x12 * x2363 + x2162 + x2165,
            x12 * x2366 + x2166 + x2168,
            x12 * x2368 + x2169 + x2170,
            x12 * x2371 + x2171 + x2173,
            x12 * x2373 + x2175,
            x12 * x2376 + x2178,
            x12 * x2379 + x2181,
            x12 * x2381 + x2182,
            x12 * x2383 + x2184,
            x12 * x2386 + x2187,
            x12 * x2388 + x2188 + x2190,
            x12 * x2391 + x2191 + x2193,
            x12 * x2394 + x2194 + x2197,
            x12 * x2396 + x2198 + x2199,
            x12 * x2398 + x2200 + x2201,
            x12 * x2401 + x2202 + x2204,
            x12 * x2403 + x2205 + x2207,
            x12 * x2406 + x2208 + x2210,
            x12 * x2409 + x2211 + x2214,
            x12 * x2411 + x2215 + x2216,
            x12 * x2413 + x2217 + x2218,
            x12 * x2415 + x2219 + x2220,
            x13 * x2322
            + x13 * x2323
            + x16 * x2416
            + x16 * (x16 * x2417 + x2416)
            + x1646 * x753
            - x1659 * x765
            + 2 * x826,
            x13 * x2325 + x13 * x2326 + x16 * x2419 + x17 * x2416 + x2420,
            x13 * x2328 + x13 * x2329 + x16 * x2422 + x18 * x2416 + x2423,
            x13 * x2331 + x13 * x2332 + x17 * x2419 + x2425,
            x13 * x2334 + x13 * x2335 + x17 * x2422 + x2427,
            x13 * x2337 + x13 * x2338 + x18 * x2422 + x2429,
            x13 * x2339 + x13 * x2340 + x16 * x2418 + x16 * (x16 * x2430 + x2418) + x2420,
            x13 * x2342 + x13 * x2343 + x16 * x2432 + x2425,
            x13 * x2345 + x13 * x2346 + x16 * x2434 + x2427,
            x13 * x2348 + x13 * x2349 + x17 * x2432 + x2435,
            x13 * x2351 + x13 * x2352 + x17 * x2434 + x2437,
            x13 * x2354 + x13 * x2355 + x18 * x2434 + x2439,
            x13 * x2356 + x13 * x2357 + x16 * x2421 + x16 * (x16 * x2440 + x2421) + x2423,
            x13 * x2359 + x13 * x2360 + x16 * x2441 + x17 * x2421 + x2426,
            x13 * x2362 + x13 * x2363 + x16 * x2443 + x2429,
            x13 * x2365 + x13 * x2366 + x17 * x2441 + x2444,
            x13 * x2367 + x13 * x2368 + x17 * x2443 + x2439,
            x13 * x2370 + x13 * x2371 + x18 * x2443 + x2445,
            x13 * x2372 + x13 * x2373 + x16 * x2431 + x16 * (x16 * x2446 + x2431) + x2424,
            x13 * x2375 + x13 * x2376 + x16 * x2448 + x2435,
            x13 * x2378 + x13 * x2379 + x16 * x2450 + x2437,
            2 * x1195
            + x13 * x2380
            + x13 * x2381
            + x17 * x2447
            + x17 * x2448
            + x1809 * x753
            - x1810 * x765,
            x13 * x2382 + x13 * x2383 + x17 * x2450 + x18 * x2447 + x2451,
            x13 * x2385 + x13 * x2386 + x18 * x2450 + x2453,
            x13 * x2387 + x13 * x2388 + x16 * x2433 + x16 * (x16 * x2454 + x2433) + x2426,
            x13 * x2390 + x13 * x2391 + x16 * x2455 + x2444,
            x13 * x2393 + x13 * x2394 + x16 * x2457 + x2439,
            x13 * x2395 + x13 * x2396 + x17 * x2449 + x17 * x2455 + x2451,
            x13 * x2397 + x13 * x2398 + x17 * x2457 + x2453,
            x13 * x2400 + x13 * x2401 + x18 * x2457 + x2458,
            x13 * x2402 + x13 * x2403 + x16 * x2442 + x16 * (x16 * x2459 + x2442) + x2428,
            x13 * x2405 + x13 * x2406 + x16 * x2460 + x17 * x2442 + x2438,
            x13 * x2408 + x13 * x2409 + x16 * x2462 + x2445,
            x13 * x2410 + x13 * x2411 + x17 * x2456 + x17 * x2460 + x2452,
            x13 * x2412 + x13 * x2413 + x17 * x2462 + x2458,
            2 * x1262
            + x13 * x2414
            + x13 * x2415
            + x18 * x2461
            + x18 * x2462
            + x1859 * x753
            - x1860 * x765
            + x90
            * (
                2 * x1155
                + x1792 * x753
                - x1793 * x765
                + x88
                * (
                    2 * x1022
                    + x1728 * x753
                    - x1729 * x765
                    + x86
                    * (
                        x1691 * x753
                        - x1698 * x765
                        + x81 * (x1632 * x753 - x1655 * x765 + 2 * x855)
                        + 2 * x954
                    )
                )
            ),
        ]
    )
    return S


def eri_2000(a, A, b, B, c, C, d, D):
    """Cartesian [ds|ss] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = numpy.pi**2.5
    x1 = a + b
    x2 = c + d
    x3 = x1 * x2
    x4 = x1 + x2
    x5 = (x3 + numpy.sqrt(x4)) ** (-1.0)
    x6 = x1 ** (-1.0)
    x7 = numpy.exp(
        -a * b * x6 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x8 = x2 ** (-1.0)
    x9 = numpy.exp(
        -c * d * x8 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x10 = x4 ** (-1.0)
    x11 = -x6 * (a * A[0] + b * B[0])
    x12 = -x11 - x8 * (c * C[0] + d * D[0])
    x13 = -x6 * (a * A[1] + b * B[1])
    x14 = -x13 - x8 * (c * C[1] + d * D[1])
    x15 = -x6 * (a * A[2] + b * B[2])
    x16 = -x15 - x8 * (c * C[2] + d * D[2])
    x17 = x10 * x3 * (x12**2 + x14**2 + x16**2)
    x18 = boys(0, x17)
    x19 = x10 * x2
    x20 = 2 * x0 * x5 * x7 * x9
    x21 = x20 * boys(1, x17)
    x22 = (2 * x0 * x18 * x5 * x7 * x9 - x19 * x21) / (2 * a + 2 * b)
    x23 = -x11 - A[0]
    x24 = x18 * x20
    x25 = x12 * x19
    x26 = x20 * boys(2, x17)
    x27 = -x13 - A[1]
    x28 = x14 * x19
    x29 = -x21 * x28 + x24 * x27
    x30 = x21 * x27 - x26 * x28
    x31 = -x15 - A[2]
    x32 = x16 * x19
    x33 = -x21 * x32 + x24 * x31
    x34 = x21 * x31 - x26 * x32

    # 6 item(s)
    S = numpy.array(
        [
            x22 + x23 * (-x21 * x25 + x23 * x24) - x25 * (x21 * x23 - x25 * x26),
            x23 * x29 - x25 * x30,
            x23 * x33 - x25 * x34,
            x22 + x27 * x29 - x28 * x30,
            x27 * x33 - x28 * x34,
            x22 + x31 * x33 - x32 * x34,
        ]
    )
    return S


def eri_2001(a, A, b, B, c, C, d, D):
    """Cartesian [ds|sp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(1, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = numpy.exp(
        -a * b * x9 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x23 = C[0] - D[0]
    x24 = C[1] - D[1]
    x25 = C[2] - D[2]
    x26 = numpy.exp(-c * d * x3 * (x23**2 + x24**2 + x25**2))
    x27 = 2 * x20 * x21 * x22 * x26
    x28 = x19 * x27
    x29 = x27 * boys(2, x18)
    x30 = x6 * x8
    x31 = x11 * x30
    x32 = x28 * x5 + x29 * x31
    x33 = x2 * x8
    x34 = x32 * x33
    x35 = boys(0, x18)
    x36 = x27 * x35
    x37 = x28 * x31 + x36 * x5
    x38 = x1 * (-x34 + x37)
    x39 = x1 * (2 * x20 * x21 * x22 * x26 * x35 - x28 * x33)
    x40 = -x10 - A[0]
    x41 = x11 * x33
    x42 = x28 * x40 - x29 * x41
    x43 = x39 + x40 * (-x28 * x41 + x36 * x40) - x41 * x42
    x44 = (2 * c + 2 * d + x0) ** (-1.0)
    x45 = x1 * (2 * x19 * x20 * x21 * x22 * x26 - x29 * x33)
    x46 = x27 * boys(3, x18)
    x47 = x29 * x40 - x41 * x46
    x48 = x29 * x5 + x31 * x46
    x49 = x12 - C[1]
    x50 = x14 * x30
    x51 = x28 * x49 + x29 * x50
    x52 = x33 * x51
    x53 = x28 * x50 + x36 * x49
    x54 = x1 * (-x52 + x53)
    x55 = x29 * x49 + x46 * x50
    x56 = -x13 - A[1]
    x57 = x14 * x33
    x58 = -x28 * x57 + x36 * x56
    x59 = x28 * x56 - x29 * x57
    x60 = x40 * x58 - x41 * x59
    x61 = x29 * x56 - x46 * x57
    x62 = -x14 * x34 + x37 * x56
    x63 = x32 * x56 - x48 * x57
    x64 = -x14 * x52 + x44 * x59 + x53 * x56
    x65 = x44 * x61 + x51 * x56 - x55 * x57
    x66 = -x15 - A[2]
    x67 = x16 * x33
    x68 = -x28 * x67 + x36 * x66
    x69 = x28 * x66 - x29 * x67
    x70 = x40 * x68 - x41 * x69
    x71 = x40 * x69
    x72 = x29 * x66 - x46 * x67
    x73 = x41 * x72
    x74 = -x16 * x34 + x37 * x66
    x75 = x32 * x66 - x48 * x67
    x76 = -x16 * x52 + x53 * x66
    x77 = x51 * x66 - x55 * x67
    x78 = x39 + x56 * x58 - x57 * x59
    x79 = x56 * x68 - x57 * x69
    x80 = x56 * x69
    x81 = x57 * x72
    x82 = x39 + x66 * x68 - x67 * x69
    x83 = x66 * x69
    x84 = x67 * x72

    # 18 item(s)
    S = numpy.array(
        [
            x23 * x43
            + x38
            + x40 * (-x11 * x34 + x37 * x40 + x42 * x44)
            - x41 * (x32 * x40 - x41 * x48 + x44 * x47)
            + x44 * (x40 * x42 - x41 * x47 + x45),
            x24 * x43
            + x40 * (-x11 * x52 + x40 * x53)
            - x41 * (x40 * x51 - x41 * x55)
            + x54,
            x25 * x43,
            x23 * x60 + x40 * x62 - x41 * x63 + x44 * (x40 * x59 - x41 * x61),
            x24 * x60 + x40 * x64 - x41 * x65,
            x25 * x60,
            x23 * x70 + x40 * x74 - x41 * x75 + x44 * (x71 - x73),
            x24 * x70 + x40 * x76 - x41 * x77,
            x25 * x70 + x44 * x71 - x44 * x73,
            x23 * x78 + x38 + x56 * x62 - x57 * x63,
            x24 * x78 + x44 * (x45 + x56 * x59 - x57 * x61) + x54 + x56 * x64 - x57 * x65,
            x25 * x78,
            x23 * x79 + x56 * x74 - x57 * x75,
            x24 * x79 + x44 * (x80 - x81) + x56 * x76 - x57 * x77,
            x25 * x79 + x44 * x80 - x44 * x81,
            x23 * x82 + x38 + x66 * x74 - x67 * x75,
            x24 * x82 + x54 + x66 * x76 - x67 * x77,
            x25 * x82 + x44 * x83 - x44 * x84 + x44 * (x45 + x83 - x84),
        ]
    )
    return S


def eri_2002(a, A, b, B, c, C, d, D):
    """Cartesian [ds|sd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = numpy.exp(
        -a * b * x10 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = x6 ** (-1.0)
    x13 = C[0] - D[0]
    x14 = C[1] - D[1]
    x15 = C[2] - D[2]
    x16 = x15**2
    x17 = numpy.exp(-c * d * x12 * (x13**2 + x14**2 + x16))
    x18 = x8 ** (-1.0)
    x19 = x12 * (c * C[0] + d * D[0])
    x20 = -x10 * (a * A[0] + b * B[0])
    x21 = -x19 - x20
    x22 = x12 * (c * C[1] + d * D[1])
    x23 = -x10 * (a * A[1] + b * B[1])
    x24 = -x22 - x23
    x25 = -x10 * (a * A[2] + b * B[2])
    x26 = -x12 * (c * C[2] + d * D[2]) - x25
    x27 = x18 * x7 * (x21**2 + x24**2 + x26**2)
    x28 = boys(1, x27)
    x29 = -2 * x11 * x17 * x28 * x4 * x9
    x30 = x18 * x5
    x31 = boys(2, x27)
    x32 = 2 * x11 * x17 * x4 * x9
    x33 = x31 * x32
    x34 = x3 * (-x29 - x30 * x33)
    x35 = x19 - C[0]
    x36 = x28 * x32
    x37 = x21 * x30
    x38 = x33 * x37 + x35 * x36
    x39 = x32 * boys(3, x27)
    x40 = x33 * x35 + x37 * x39
    x41 = x34 + x35 * x38 + x37 * x40
    x42 = x18 * x6
    x43 = x41 * x42
    x44 = boys(0, x27)
    x45 = -2 * x11 * x17 * x4 * x44 * x9
    x46 = x3 * (-x30 * x36 - x45)
    x47 = x32 * x44
    x48 = x35 * x47 + x36 * x37
    x49 = x35 * x48 + x37 * x38 + x46
    x50 = x1 * (-x43 + x49)
    x51 = -x20 - A[0]
    x52 = x0 + x2
    x53 = x52 ** (-1.0)
    x54 = x21 * x42
    x55 = x33 * x51 - x39 * x54
    x56 = x40 * x42
    x57 = -x21 * x56 + x38 * x51 + x53 * x55
    x58 = 2 * x53
    x59 = -2 * x11 * x17 * x31 * x4 * x9
    x60 = x3 * (-x30 * x39 - x59)
    x61 = x32 * boys(4, x27)
    x62 = x35 * x39 + x37 * x61
    x63 = x35 * x40 + x37 * x62 + x60
    x64 = x39 * x51 - x54 * x61
    x65 = x40 * x51 + x53 * x64 - x54 * x62
    x66 = x38 * x42
    x67 = x1 * (x48 - x66)
    x68 = x1 * (-x29 - x33 * x42)
    x69 = -x33 * x54 + x36 * x51
    x70 = (
        x51 * (-x21 * x66 + x48 * x51 + x53 * x69)
        + x53 * (x51 * x69 - x54 * x55 + x68)
        - x54 * x57
        + x67
    )
    x71 = x1 * (x38 - x56)
    x72 = x1 * (-x39 * x42 - x59)
    x73 = x1 * (-x36 * x42 - x45)
    x74 = x51 * (-x36 * x54 + x47 * x51) - x54 * x69 + x73
    x75 = x13 * x74
    x76 = x22 - C[1]
    x77 = x24 * x30
    x78 = x33 * x77 + x36 * x76
    x79 = x33 * x76 + x39 * x77
    x80 = x35 * x78 + x37 * x79
    x81 = x42 * x80
    x82 = x36 * x77 + x47 * x76
    x83 = x35 * x82 + x37 * x78
    x84 = x1 * (-x81 + x83)
    x85 = x42 * x79
    x86 = x1 * (x78 - x85)
    x87 = -x21 * x85 + x51 * x78
    x88 = x39 * x76 + x61 * x77
    x89 = x51 * x79 - x54 * x88
    x90 = x35 * x79 + x37 * x88
    x91 = x14 * x74
    x92 = x42 * x78
    x93 = x1 * (x82 - x92)
    x94 = x51 * (-x21 * x92 + x51 * x82) - x54 * x87 + x93
    x95 = x91 + x94
    x96 = x34 + x76 * x78 + x77 * x79
    x97 = x42 * x96
    x98 = x46 + x76 * x82 + x77 * x78
    x99 = x1 * (-x97 + x98)
    x100 = x60 + x76 * x79 + x77 * x88
    x101 = -x23 - A[1]
    x102 = x101 * x49 - x24 * x43
    x103 = x24 * x42
    x104 = x101 * x41 - x103 * x63
    x105 = x101 * x36 - x103 * x33
    x106 = x101 * x33 - x103 * x39
    x107 = x101 * x48 - x24 * x66
    x108 = x101 * x38 - x24 * x56
    x109 = x107 * x51 - x108 * x54 + x53 * (x105 * x51 - x106 * x54)
    x110 = x101 * x39 - x103 * x61
    x111 = x101 * x40 - x103 * x62
    x112 = x101 * x47 - x103 * x36
    x113 = -x105 * x54 + x112 * x51
    x114 = x113 * x13
    x115 = x101 * x78 + x106 * x53 - x24 * x85
    x116 = x101 * x79 - x103 * x88 + x110 * x53
    x117 = x101 * x83 + x108 * x53 - x24 * x81
    x118 = x101 * x80 - x103 * x90 + x111 * x53
    x119 = x113 * x14
    x120 = x101 * x82 + x105 * x53 - x24 * x92
    x121 = -x115 * x54 + x120 * x51
    x122 = x119 + x121
    x123 = x101 * x98 + x115 * x58 - x24 * x97
    x124 = -x100 * x103 + x101 * x96 + x116 * x58
    x125 = -x25 - A[2]
    x126 = x125 * x49 - x26 * x43
    x127 = x26 * x42
    x128 = x125 * x41 - x127 * x63
    x129 = x125 * x36 - x127 * x33
    x130 = x129 * x51
    x131 = x125 * x33 - x127 * x39
    x132 = x131 * x54
    x133 = x125 * x48 - x26 * x66
    x134 = x125 * x38 - x26 * x56
    x135 = x133 * x51 - x134 * x54 + x53 * (x130 - x132)
    x136 = x131 * x51
    x137 = x125 * x39 - x127 * x61
    x138 = x137 * x54
    x139 = x134 * x51
    x140 = x125 * x40 - x127 * x62
    x141 = x140 * x54
    x142 = x125 * x47 - x127 * x36
    x143 = -x129 * x54 + x142 * x51
    x144 = x125 * x83 - x26 * x81
    x145 = x125 * x78 - x26 * x85
    x146 = x145 * x51
    x147 = x125 * x79 - x127 * x88
    x148 = x147 * x54
    x149 = x125 * x80 - x127 * x90
    x150 = x125 * x82 - x26 * x92
    x151 = -x145 * x54 + x150 * x51
    x152 = x14 * x143 + x151
    x153 = x130 * x53 - x132 * x53
    x154 = x143 * x15 + x153
    x155 = x125 * x98 - x26 * x97
    x156 = -x100 * x127 + x125 * x96
    x157 = 2 / x52**2
    x158 = x101 * x107 - x103 * x108 + x67
    x159 = x101 * x112 - x103 * x105 + x73
    x160 = x13 * x159
    x161 = x14 * x159
    x162 = x101 * x120 - x103 * x115 + x53 * (x101 * x105 - x103 * x106 + x68) + x93
    x163 = x161 + x162
    x164 = x101 * x133 - x103 * x134
    x165 = x101 * x142 - x103 * x129
    x166 = x101 * x134
    x167 = x103 * x140
    x168 = x101 * x129
    x169 = x103 * x131
    x170 = x101 * x150 - x103 * x145 + x53 * (x168 - x169)
    x171 = x14 * x165 + x170
    x172 = x168 * x53 - x169 * x53
    x173 = x15 * x165 + x172
    x174 = x101 * x131
    x175 = x103 * x137
    x176 = x101 * x145
    x177 = x103 * x147
    x178 = x125 * x133 - x127 * x134 + x67
    x179 = x125 * x142 - x127 * x129 + x73
    x180 = x125 * x150 - x127 * x145 + x93
    x181 = x14 * x179 + x180
    x182 = x125 * x134
    x183 = x127 * x140
    x184 = x125 * x129
    x185 = x127 * x131
    x186 = x184 * x53 - x185 * x53 + x53 * (x184 - x185 + x68)
    x187 = x15 * x179 + x186
    x188 = x125 * x145
    x189 = x127 * x147
    x190 = x125 * x131
    x191 = x127 * x137

    # 36 item(s)
    S = numpy.array(
        [
            x13 * x70
            + x13 * (x70 + x75)
            + x50
            + x51 * (-x21 * x43 + x49 * x51 + x57 * x58)
            - x54 * (x41 * x51 - x54 * x63 + x58 * x65)
            + x58 * (x51 * x57 + x53 * (x51 * x55 - x54 * x64 + x72) - x54 * x65 + x71),
            x13 * x95
            + x14 * x70
            + x51 * (-x21 * x81 + x51 * x83 + x53 * x87)
            + x53 * (x51 * x87 - x54 * x89 + x86)
            - x54 * (x51 * x80 + x53 * x89 - x54 * x90)
            + x84,
            x15 * x70 + x15 * x75,
            x14 * x94
            + x14 * x95
            + x51 * (-x21 * x97 + x51 * x98)
            - x54 * (-x100 * x54 + x51 * x96)
            + x99,
            x15 * x91 + x15 * x94,
            x16 * x74,
            x102 * x51
            - x104 * x54
            + x109 * x13
            + x13 * (x109 + x114)
            + x58 * (x108 * x51 - x111 * x54 + x53 * (x106 * x51 - x110 * x54)),
            x109 * x14
            + x117 * x51
            - x118 * x54
            + x122 * x13
            + x53 * (x115 * x51 - x116 * x54),
            x109 * x15 + x114 * x15,
            x121 * x14 + x122 * x14 + x123 * x51 - x124 * x54,
            x119 * x15 + x121 * x15,
            x113 * x16,
            x126 * x51
            - x128 * x54
            + x13 * x135
            + x13 * (x13 * x143 + x135)
            + x58 * (x139 - x141 + x53 * (x136 - x138)),
            x13 * x152 + x135 * x14 + x144 * x51 - x149 * x54 + x53 * (x146 - x148),
            x13 * x154
            + x135 * x15
            + x139 * x53
            - x141 * x53
            + x53 * (x136 * x53 - x138 * x53),
            x14 * x151 + x14 * x152 + x155 * x51 - x156 * x54,
            x14 * x154 + x146 * x53 - x148 * x53 + x15 * x151,
            x136 * x157 - x138 * x157 + x15 * x153 + x15 * x154,
            x101 * x102 - x103 * x104 + x13 * x158 + x13 * (x158 + x160) + x50,
            x101 * x117
            - x103 * x118
            + x13 * x163
            + x14 * x158
            + x53 * (x101 * x108 - x103 * x111 + x71)
            + x84,
            x15 * x158 + x15 * x160,
            x101 * x123
            - x103 * x124
            + x14 * x162
            + x14 * x163
            + x58
            * (x101 * x115 - x103 * x116 + x53 * (x101 * x106 - x103 * x110 + x72) + x86)
            + x99,
            x15 * x161 + x15 * x162,
            x159 * x16,
            x101 * x126 - x103 * x128 + x13 * x164 + x13 * (x13 * x165 + x164),
            x101 * x144 - x103 * x149 + x13 * x171 + x14 * x164 + x53 * (x166 - x167),
            x13 * x173 + x15 * x164 + x166 * x53 - x167 * x53,
            x101 * x155
            - x103 * x156
            + x14 * x170
            + x14 * x171
            + x58 * (x176 - x177 + x53 * (x174 - x175)),
            x14 * x173
            + x15 * x170
            + x176 * x53
            - x177 * x53
            + x53 * (x174 * x53 - x175 * x53),
            x15 * x172 + x15 * x173 + x157 * x174 - x157 * x175,
            x125 * x126 - x127 * x128 + x13 * x178 + x13 * (x13 * x179 + x178) + x50,
            x125 * x144 - x127 * x149 + x13 * x181 + x14 * x178 + x84,
            x13 * x187 + x15 * x178 + x182 * x53 - x183 * x53 + x53 * (x182 - x183 + x71),
            x125 * x155 - x127 * x156 + x14 * x180 + x14 * x181 + x99,
            x14 * x187 + x15 * x180 + x188 * x53 - x189 * x53 + x53 * (x188 - x189 + x86),
            x15 * x186
            + x15 * x187
            + x157 * x190
            - x157 * x191
            + x58 * (x190 * x53 - x191 * x53 + x53 * (x190 - x191 + x72)),
        ]
    )
    return S


def eri_2010(a, A, b, B, c, C, d, D):
    """Cartesian [ds|ps] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(1, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = numpy.exp(
        -a * b * x9 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x23 = numpy.exp(
        -c * d * x3 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x24 = 2 * x20 * x21 * x22 * x23
    x25 = x19 * x24
    x26 = boys(2, x18)
    x27 = x24 * x26
    x28 = x6 * x8
    x29 = x11 * x28
    x30 = x25 * x5 + x27 * x29
    x31 = x2 * x8
    x32 = x30 * x31
    x33 = boys(0, x18)
    x34 = x24 * x5
    x35 = x25 * x29 + x33 * x34
    x36 = x1 * (-x32 + x35)
    x37 = (2 * c + 2 * d + x0) ** (-1.0)
    x38 = x1 * (2 * x19 * x20 * x21 * x22 * x23 - x27 * x31)
    x39 = -x10 - A[0]
    x40 = x11 * x31
    x41 = x25 * x39 - x27 * x40
    x42 = x24 * boys(3, x18)
    x43 = x27 * x39 - x40 * x42
    x44 = x26 * x34 + x29 * x42
    x45 = x12 - C[1]
    x46 = x14 * x28
    x47 = x25 * x45 + x27 * x46
    x48 = x31 * x47
    x49 = x24 * x33 * x45 + x25 * x46
    x50 = x1 * (-x48 + x49)
    x51 = x27 * x45 + x42 * x46
    x52 = -x13 - A[1]
    x53 = x14 * x31
    x54 = x25 * x52 - x27 * x53
    x55 = x27 * x52 - x42 * x53
    x56 = -x14 * x32 + x35 * x52
    x57 = x30 * x52 - x44 * x53
    x58 = -x14 * x48 + x37 * x54 + x49 * x52
    x59 = x37 * x55 + x47 * x52 - x51 * x53
    x60 = -x15 - A[2]
    x61 = x16 * x31
    x62 = x25 * x60 - x27 * x61
    x63 = x39 * x62
    x64 = x27 * x60 - x42 * x61
    x65 = x40 * x64
    x66 = -x16 * x32 + x35 * x60
    x67 = x30 * x60 - x44 * x61
    x68 = -x16 * x48 + x49 * x60
    x69 = x47 * x60 - x51 * x61
    x70 = x52 * x62
    x71 = x53 * x64
    x72 = x60 * x62
    x73 = x61 * x64

    # 18 item(s)
    S = numpy.array(
        [
            x36
            + x37 * (x38 + x39 * x41 - x40 * x43)
            + x39 * (-x11 * x32 + x35 * x39 + x37 * x41)
            - x40 * (x30 * x39 + x37 * x43 - x40 * x44),
            x39 * (-x11 * x48 + x39 * x49) - x40 * (x39 * x47 - x40 * x51) + x50,
            0,
            x37 * (x39 * x54 - x40 * x55) + x39 * x56 - x40 * x57,
            x39 * x58 - x40 * x59,
            0,
            x37 * (x63 - x65) + x39 * x66 - x40 * x67,
            x39 * x68 - x40 * x69,
            x37 * x63 - x37 * x65,
            x36 + x52 * x56 - x53 * x57,
            x37 * (x38 + x52 * x54 - x53 * x55) + x50 + x52 * x58 - x53 * x59,
            0,
            x52 * x66 - x53 * x67,
            x37 * (x70 - x71) + x52 * x68 - x53 * x69,
            x37 * x70 - x37 * x71,
            x36 + x60 * x66 - x61 * x67,
            x50 + x60 * x68 - x61 * x69,
            x37 * x72 - x37 * x73 + x37 * (x38 + x72 - x73),
        ]
    )
    return S


def eri_2011(a, A, b, B, c, C, d, D):
    """Cartesian [ds|pp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = numpy.exp(
        -a * b * x10 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = x6 ** (-1.0)
    x13 = C[0] - D[0]
    x14 = C[1] - D[1]
    x15 = C[2] - D[2]
    x16 = numpy.exp(-c * d * x12 * (x13**2 + x14**2 + x15**2))
    x17 = x8 ** (-1.0)
    x18 = x12 * (c * C[0] + d * D[0])
    x19 = -x10 * (a * A[0] + b * B[0])
    x20 = -x18 - x19
    x21 = x12 * (c * C[1] + d * D[1])
    x22 = -x10 * (a * A[1] + b * B[1])
    x23 = -x21 - x22
    x24 = -x10 * (a * A[2] + b * B[2])
    x25 = -x12 * (c * C[2] + d * D[2]) - x24
    x26 = x17 * x7 * (x20**2 + x23**2 + x25**2)
    x27 = boys(1, x26)
    x28 = -2 * x11 * x16 * x27 * x4 * x9
    x29 = x17 * x5
    x30 = boys(2, x26)
    x31 = 2 * x11 * x16 * x4 * x9
    x32 = x30 * x31
    x33 = x3 * (-x28 - x29 * x32)
    x34 = x18 - C[0]
    x35 = x27 * x31
    x36 = x20 * x29
    x37 = x32 * x36 + x34 * x35
    x38 = x31 * boys(3, x26)
    x39 = x32 * x34 + x36 * x38
    x40 = x33 + x34 * x37 + x36 * x39
    x41 = x17 * x6
    x42 = x40 * x41
    x43 = boys(0, x26)
    x44 = x3 * (2 * x11 * x16 * x4 * x43 * x9 - x29 * x35)
    x45 = x31 * x43
    x46 = x34 * x45 + x35 * x36
    x47 = x34 * x46 + x36 * x37 + x44
    x48 = x1 * (-x42 + x47)
    x49 = -x19 - A[0]
    x50 = x0 + x2
    x51 = x50 ** (-1.0)
    x52 = x20 * x41
    x53 = x32 * x49 - x38 * x52
    x54 = x39 * x41
    x55 = -x20 * x54 + x37 * x49 + x51 * x53
    x56 = 2 * x51
    x57 = -2 * x11 * x16 * x30 * x4 * x9
    x58 = x3 * (-x29 * x38 - x57)
    x59 = x31 * boys(4, x26)
    x60 = x34 * x38 + x36 * x59
    x61 = x34 * x39 + x36 * x60 + x58
    x62 = x38 * x49 - x52 * x59
    x63 = x39 * x49 + x51 * x62 - x52 * x60
    x64 = x37 * x41
    x65 = x1 * (x46 - x64)
    x66 = x1 * (-x28 - x32 * x41)
    x67 = -x32 * x52 + x35 * x49
    x68 = (
        x49 * (-x20 * x64 + x46 * x49 + x51 * x67)
        + x51 * (x49 * x67 - x52 * x53 + x66)
        - x52 * x55
        + x65
    )
    x69 = x1 * (x37 - x54)
    x70 = x1 * (-x38 * x41 - x57)
    x71 = x21 - C[1]
    x72 = x23 * x29
    x73 = x32 * x72 + x35 * x71
    x74 = x32 * x71 + x38 * x72
    x75 = x34 * x73 + x36 * x74
    x76 = x41 * x75
    x77 = x35 * x72 + x45 * x71
    x78 = x34 * x77 + x36 * x73
    x79 = x1 * (-x76 + x78)
    x80 = x41 * x74
    x81 = x1 * (x73 - x80)
    x82 = -x20 * x80 + x49 * x73
    x83 = x38 * x71 + x59 * x72
    x84 = x49 * x74 - x52 * x83
    x85 = x34 * x74 + x36 * x83
    x86 = (
        x49 * (-x20 * x76 + x49 * x78 + x51 * x82)
        + x51 * (x49 * x82 - x52 * x84 + x81)
        - x52 * (x49 * x75 + x51 * x84 - x52 * x85)
        + x79
    )
    x87 = x41 * x73
    x88 = x1 * (x77 - x87)
    x89 = x49 * (-x20 * x87 + x49 * x77) - x52 * x82 + x88
    x90 = x33 + x71 * x73 + x72 * x74
    x91 = x41 * x90
    x92 = x44 + x71 * x77 + x72 * x73
    x93 = x1 * (-x91 + x92)
    x94 = x58 + x71 * x74 + x72 * x83
    x95 = -x22 - A[1]
    x96 = -x23 * x42 + x47 * x95
    x97 = x23 * x41
    x98 = x40 * x95 - x61 * x97
    x99 = -x32 * x97 + x35 * x95
    x100 = x32 * x95 - x38 * x97
    x101 = -x23 * x64 + x46 * x95
    x102 = -x23 * x54 + x37 * x95
    x103 = x101 * x49 - x102 * x52 + x51 * (-x100 * x52 + x49 * x99)
    x104 = x38 * x95 - x59 * x97
    x105 = x39 * x95 - x60 * x97
    x106 = x100 * x51 - x23 * x80 + x73 * x95
    x107 = x104 * x51 + x74 * x95 - x83 * x97
    x108 = x102 * x51 - x23 * x76 + x78 * x95
    x109 = x105 * x51 + x75 * x95 - x85 * x97
    x110 = x108 * x49 - x109 * x52 + x51 * (x106 * x49 - x107 * x52)
    x111 = -x23 * x87 + x51 * x99 + x77 * x95
    x112 = -x106 * x52 + x111 * x49
    x113 = x106 * x56 - x23 * x91 + x92 * x95
    x114 = x107 * x56 + x90 * x95 - x94 * x97
    x115 = -x24 - A[2]
    x116 = x115 * x47 - x25 * x42
    x117 = x25 * x41
    x118 = x115 * x40 - x117 * x61
    x119 = x115 * x35 - x117 * x32
    x120 = x119 * x49
    x121 = x115 * x32 - x117 * x38
    x122 = x121 * x52
    x123 = x115 * x46 - x25 * x64
    x124 = x115 * x37 - x25 * x54
    x125 = x123 * x49 - x124 * x52 + x51 * (x120 - x122)
    x126 = x121 * x49
    x127 = x115 * x38 - x117 * x59
    x128 = x127 * x52
    x129 = x124 * x49
    x130 = x115 * x39 - x117 * x60
    x131 = x130 * x52
    x132 = x115 * x73 - x25 * x80
    x133 = x132 * x49
    x134 = x115 * x74 - x117 * x83
    x135 = x134 * x52
    x136 = x115 * x78 - x25 * x76
    x137 = x115 * x75 - x117 * x85
    x138 = x136 * x49 - x137 * x52 + x51 * (x133 - x135)
    x139 = x129 * x51 - x131 * x51 + x51 * (x126 * x51 - x128 * x51)
    x140 = x115 * x77 - x25 * x87
    x141 = -x132 * x52 + x140 * x49
    x142 = x115 * x92 - x25 * x91
    x143 = x115 * x90 - x117 * x94
    x144 = x133 * x51 - x135 * x51
    x145 = x120 * x51 - x122 * x51
    x146 = 2 / x50**2
    x147 = x101 * x95 - x102 * x97 + x65
    x148 = x108 * x95 - x109 * x97 + x51 * (x102 * x95 - x105 * x97 + x69) + x79
    x149 = -x106 * x97 + x111 * x95 + x51 * (-x100 * x97 + x66 + x95 * x99) + x88
    x150 = x123 * x95 - x124 * x97
    x151 = x124 * x95
    x152 = x130 * x97
    x153 = x136 * x95 - x137 * x97 + x51 * (x151 - x152)
    x154 = x151 * x51 - x152 * x51
    x155 = x119 * x95
    x156 = x121 * x97
    x157 = -x132 * x97 + x140 * x95 + x51 * (x155 - x156)
    x158 = x121 * x95
    x159 = x127 * x97
    x160 = x132 * x95
    x161 = x134 * x97
    x162 = x160 * x51 - x161 * x51 + x51 * (x158 * x51 - x159 * x51)
    x163 = x155 * x51 - x156 * x51
    x164 = x115 * x123 - x117 * x124 + x65
    x165 = x115 * x136 - x117 * x137 + x79
    x166 = x115 * x124
    x167 = x117 * x130
    x168 = x166 * x51 - x167 * x51 + x51 * (x166 - x167 + x69)
    x169 = x115 * x140 - x117 * x132 + x88
    x170 = x115 * x132
    x171 = x117 * x134
    x172 = x170 * x51 - x171 * x51 + x51 * (x170 - x171 + x81)
    x173 = x115 * x119
    x174 = x117 * x121
    x175 = x173 * x51 - x174 * x51 + x51 * (x173 - x174 + x66)
    x176 = x115 * x121
    x177 = x117 * x127

    # 54 item(s)
    S = numpy.array(
        [
            x13 * x68
            + x48
            + x49 * (-x20 * x42 + x47 * x49 + x55 * x56)
            - x52 * (x40 * x49 - x52 * x61 + x56 * x63)
            + x56 * (x49 * x55 + x51 * (x49 * x53 - x52 * x62 + x70) - x52 * x63 + x69),
            x14 * x68 + x86,
            x15 * x68,
            x13 * x89 + x86,
            x14 * x89
            + x49 * (-x20 * x91 + x49 * x92)
            - x52 * (x49 * x90 - x52 * x94)
            + x93,
            x15 * x89,
            0,
            0,
            0,
            x103 * x13
            + x49 * x96
            - x52 * x98
            + x56 * (x102 * x49 - x105 * x52 + x51 * (x100 * x49 - x104 * x52)),
            x103 * x14 + x110,
            x103 * x15,
            x110 + x112 * x13,
            x112 * x14 + x113 * x49 - x114 * x52,
            x112 * x15,
            0,
            0,
            0,
            x116 * x49
            - x118 * x52
            + x125 * x13
            + x56 * (x129 - x131 + x51 * (x126 - x128)),
            x125 * x14 + x138,
            x125 * x15 + x139,
            x13 * x141 + x138,
            x14 * x141 + x142 * x49 - x143 * x52,
            x141 * x15 + x144,
            x13 * x145 + x139,
            x14 * x145 + x144,
            x126 * x146 - x128 * x146 + x145 * x15,
            x13 * x147 + x48 + x95 * x96 - x97 * x98,
            x14 * x147 + x148,
            x147 * x15,
            x13 * x149 + x148,
            x113 * x95
            - x114 * x97
            + x14 * x149
            + x56
            * (x106 * x95 - x107 * x97 + x51 * (x100 * x95 - x104 * x97 + x70) + x81)
            + x93,
            x149 * x15,
            0,
            0,
            0,
            x116 * x95 - x118 * x97 + x13 * x150,
            x14 * x150 + x153,
            x15 * x150 + x154,
            x13 * x157 + x153,
            x14 * x157
            + x142 * x95
            - x143 * x97
            + x56 * (x160 - x161 + x51 * (x158 - x159)),
            x15 * x157 + x162,
            x13 * x163 + x154,
            x14 * x163 + x162,
            x146 * x158 - x146 * x159 + x15 * x163,
            x115 * x116 - x117 * x118 + x13 * x164 + x48,
            x14 * x164 + x165,
            x15 * x164 + x168,
            x13 * x169 + x165,
            x115 * x142 - x117 * x143 + x14 * x169 + x93,
            x15 * x169 + x172,
            x13 * x175 + x168,
            x14 * x175 + x172,
            x146 * x176
            - x146 * x177
            + x15 * x175
            + x56 * (x176 * x51 - x177 * x51 + x51 * (x176 - x177 + x70)),
        ]
    )
    return S


def eri_2012(a, A, b, B, c, C, d, D):
    """Cartesian [ds|pd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = numpy.exp(
        -a * b * x9 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x23 = C[0] - D[0]
    x24 = C[1] - D[1]
    x25 = C[2] - D[2]
    x26 = x25**2
    x27 = numpy.exp(-c * d * x3 * (x23**2 + x24**2 + x26))
    x28 = 2 * x20 * x21 * x22 * x27
    x29 = x19 * x28
    x30 = x6 * x8
    x31 = x11 * x30
    x32 = boys(3, x18)
    x33 = x28 * x32
    x34 = x29 * x5 + x31 * x33
    x35 = x30 * x34
    x36 = boys(1, x18)
    x37 = x28 * x36
    x38 = x29 * x31 + x37 * x5
    x39 = 2 * c + 2 * d
    x40 = x39 ** (-1.0)
    x41 = 2 * x40
    x42 = -2 * x20 * x21 * x22 * x27 * x36
    x43 = x40 * (-x29 * x30 - x42)
    x44 = x11 * x35 + x38 * x5 + x43
    x45 = -2 * x19 * x20 * x21 * x22 * x27
    x46 = x40 * (-x30 * x33 - x45)
    x47 = x28 * boys(4, x18)
    x48 = x31 * x47 + x33 * x5
    x49 = x30 * x48
    x50 = x11 * x49 + x34 * x5 + x46
    x51 = x31 * x50 + x41 * (-x35 + x38) + x44 * x5
    x52 = x2 * x8
    x53 = x51 * x52
    x54 = x30 * x38
    x55 = boys(0, x18)
    x56 = x28 * x55
    x57 = x31 * x37 + x5 * x56
    x58 = x40 * (2 * x20 * x21 * x22 * x27 * x55 - x30 * x37)
    x59 = x11 * x54 + x5 * x57 + x58
    x60 = x31 * x44 + x41 * (-x54 + x57) + x5 * x59
    x61 = x1 * (-x53 + x60)
    x62 = -x10 - A[0]
    x63 = x50 * x52
    x64 = x0 + x39
    x65 = x64 ** (-1.0)
    x66 = x11 * x52
    x67 = x33 * x62 - x47 * x66
    x68 = x48 * x52
    x69 = -x11 * x68 + x34 * x62 + x65 * x67
    x70 = 2 * x65
    x71 = -x11 * x63 + x44 * x62 + x69 * x70
    x72 = 3 * x65
    x73 = -2 * x20 * x21 * x22 * x27 * x32
    x74 = x40 * (-x30 * x47 - x73)
    x75 = x28 * boys(5, x18)
    x76 = x31 * x75 + x47 * x5
    x77 = x31 * x76 + x48 * x5 + x74
    x78 = x31 * x77 + x41 * (x34 - x49) + x5 * x50
    x79 = x47 * x62 - x66 * x75
    x80 = x48 * x62 + x65 * x79 - x66 * x76
    x81 = x50 * x62 - x66 * x77 + x70 * x80
    x82 = x44 * x52
    x83 = x1 * (x59 - x82)
    x84 = x29 * x62 - x33 * x66
    x85 = x34 * x52
    x86 = -x11 * x85 + x38 * x62 + x65 * x84
    x87 = x1 * (x38 - x85)
    x88 = x1 * (-x33 * x52 - x45)
    x89 = (
        x62 * (-x11 * x82 + x59 * x62 + x70 * x86)
        - x66 * x71
        + x70 * (x62 * x86 + x65 * (x62 * x84 - x66 * x67 + x88) - x66 * x69 + x87)
        + x83
    )
    x90 = x1 * (x44 - x63)
    x91 = x1 * (x34 - x68)
    x92 = x1 * (-x47 * x52 - x73)
    x93 = x38 * x52
    x94 = x1 * (x57 - x93)
    x95 = x1 * (-x29 * x52 - x42)
    x96 = -x29 * x66 + x37 * x62
    x97 = (
        x62 * (-x11 * x93 + x57 * x62 + x65 * x96)
        + x65 * (x62 * x96 - x66 * x84 + x95)
        - x66 * x86
        + x94
    )
    x98 = x23 * x97
    x99 = x24 * x97
    x100 = x12 - C[1]
    x101 = x14 * x30
    x102 = x100 * x37 + x101 * x29
    x103 = x100 * x29 + x101 * x33
    x104 = x103 * x30
    x105 = x102 * x5 + x104 * x11
    x106 = x105 * x52
    x107 = x100 * x56 + x101 * x37
    x108 = x102 * x30
    x109 = x107 * x5 + x108 * x11
    x110 = x1 * (-x106 + x109)
    x111 = x103 * x52
    x112 = x1 * (x102 - x111)
    x113 = x102 * x62 - x11 * x111
    x114 = x100 * x33 + x101 * x47
    x115 = x114 * x52
    x116 = x103 * x62 - x11 * x115
    x117 = x114 * x30
    x118 = x103 * x5 + x11 * x117
    x119 = x118 * x52
    x120 = x105 * x62 - x11 * x119 + x116 * x65
    x121 = (
        x110
        - x120 * x66
        + x62 * (-x106 * x11 + x109 * x62 + x113 * x65)
        + x65 * (x112 + x113 * x62 - x116 * x66)
    )
    x122 = x121 + x99
    x123 = x40 * (x102 - x104)
    x124 = x105 * x5 + x118 * x31 + x123
    x125 = x124 * x52
    x126 = x40 * (x107 - x108)
    x127 = x105 * x31 + x109 * x5 + x126
    x128 = x1 * (-x125 + x127)
    x129 = x1 * (x105 - x119)
    x130 = x1 * (x103 - x115)
    x131 = x100 * x47 + x101 * x75
    x132 = x114 * x62 - x131 * x66
    x133 = x114 * x5 + x131 * x31
    x134 = x118 * x62 + x132 * x65 - x133 * x66
    x135 = x40 * (x103 - x117)
    x136 = x118 * x5 + x133 * x31 + x135
    x137 = (
        x128
        + x62 * (-x11 * x125 + x120 * x70 + x127 * x62)
        - x66 * (x124 * x62 + x134 * x70 - x136 * x66)
        + x70 * (x120 * x62 + x129 - x134 * x66 + x65 * (x116 * x62 + x130 - x132 * x66))
    )
    x138 = x100 * x102 + x104 * x14 + x43
    x139 = x100 * x103 + x117 * x14 + x46
    x140 = x138 * x5 + x139 * x31
    x141 = x140 * x52
    x142 = x100 * x107 + x108 * x14 + x58
    x143 = x138 * x31 + x142 * x5
    x144 = x1 * (-x141 + x143)
    x145 = x139 * x52
    x146 = x1 * (x138 - x145)
    x147 = -x11 * x145 + x138 * x62
    x148 = x100 * x114 + x101 * x131 + x74
    x149 = x139 * x62 - x148 * x66
    x150 = x139 * x5 + x148 * x31
    x151 = (
        x121 * x24
        + x144
        + x62 * (-x11 * x141 + x143 * x62 + x147 * x65)
        + x65 * (x146 + x147 * x62 - x149 * x66)
        - x66 * (x140 * x62 + x149 * x65 - x150 * x66)
    )
    x152 = x121 * x25
    x153 = x102 * x52
    x154 = x1 * (x107 - x153)
    x155 = -x113 * x66 + x154 + x62 * (x107 * x62 - x11 * x153)
    x156 = x155 * x23
    x157 = x155 * x24
    x158 = x138 * x52
    x159 = x1 * (x142 - x158)
    x160 = -x147 * x66 + x159 + x62 * (-x11 * x158 + x142 * x62)
    x161 = x157 + x160
    x162 = x100 * x138 + x101 * x139 + 2 * x123
    x163 = x162 * x52
    x164 = x100 * x142 + x101 * x138 + 2 * x126
    x165 = x1 * (-x163 + x164)
    x166 = x100 * x139 + x101 * x148 + 2 * x135
    x167 = -x13 - A[1]
    x168 = -x14 * x53 + x167 * x60
    x169 = x14 * x52
    x170 = x167 * x51 - x169 * x78
    x171 = -x14 * x82 + x167 * x59
    x172 = -x14 * x63 + x167 * x44
    x173 = x167 * x29 - x169 * x33
    x174 = x167 * x33 - x169 * x47
    x175 = -x14 * x85 + x167 * x38
    x176 = -x14 * x68 + x167 * x34
    x177 = (
        x171 * x62
        - x172 * x66
        + x70 * (x175 * x62 - x176 * x66 + x65 * (x173 * x62 - x174 * x66))
    )
    x178 = x167 * x50 - x169 * x77
    x179 = x167 * x47 - x169 * x75
    x180 = x167 * x48 - x169 * x76
    x181 = x167 * x37 - x169 * x29
    x182 = -x14 * x93 + x167 * x57
    x183 = -x175 * x66 + x182 * x62 + x65 * (-x173 * x66 + x181 * x62)
    x184 = x183 * x23
    x185 = x183 * x24
    x186 = x102 * x167 - x111 * x14 + x173 * x65
    x187 = x103 * x167 - x115 * x14 + x174 * x65
    x188 = -x106 * x14 + x109 * x167 + x175 * x65
    x189 = x105 * x167 - x119 * x14 + x176 * x65
    x190 = x188 * x62 - x189 * x66 + x65 * (x186 * x62 - x187 * x66)
    x191 = x185 + x190
    x192 = -x125 * x14 + x127 * x167 + x172 * x65
    x193 = x114 * x167 - x131 * x169 + x179 * x65
    x194 = x118 * x167 - x133 * x169 + x180 * x65
    x195 = x124 * x167 - x136 * x169 + x178 * x65
    x196 = (
        x192 * x62
        - x195 * x66
        + x70 * (x189 * x62 - x194 * x66 + x65 * (x187 * x62 - x193 * x66))
    )
    x197 = x138 * x167 - x14 * x145 + x187 * x70
    x198 = x139 * x167 - x148 * x169 + x193 * x70
    x199 = -x14 * x141 + x143 * x167 + x189 * x70
    x200 = x140 * x167 - x150 * x169 + x194 * x70
    x201 = x190 * x24 + x199 * x62 - x200 * x66 + x65 * (x197 * x62 - x198 * x66)
    x202 = x190 * x25
    x203 = x107 * x167 - x14 * x153 + x181 * x65
    x204 = -x186 * x66 + x203 * x62
    x205 = x204 * x23
    x206 = x204 * x24
    x207 = -x14 * x158 + x142 * x167 + x186 * x70
    x208 = -x197 * x66 + x207 * x62
    x209 = x206 + x208
    x210 = -x14 * x163 + x164 * x167 + x197 * x72
    x211 = x162 * x167 - x166 * x169 + x198 * x72
    x212 = -x15 - A[2]
    x213 = -x16 * x53 + x212 * x60
    x214 = x16 * x52
    x215 = x212 * x51 - x214 * x78
    x216 = -x16 * x82 + x212 * x59
    x217 = -x16 * x63 + x212 * x44
    x218 = x212 * x29 - x214 * x33
    x219 = x218 * x62
    x220 = x212 * x33 - x214 * x47
    x221 = x220 * x66
    x222 = -x16 * x85 + x212 * x38
    x223 = x222 * x62
    x224 = -x16 * x68 + x212 * x34
    x225 = x224 * x66
    x226 = x216 * x62 - x217 * x66 + x70 * (x223 - x225 + x65 * (x219 - x221))
    x227 = x217 * x62
    x228 = x212 * x50 - x214 * x77
    x229 = x228 * x66
    x230 = x220 * x62
    x231 = x212 * x47 - x214 * x75
    x232 = x231 * x66
    x233 = x224 * x62
    x234 = x212 * x48 - x214 * x76
    x235 = x234 * x66
    x236 = x212 * x37 - x214 * x29
    x237 = x236 * x62
    x238 = x218 * x66
    x239 = -x16 * x93 + x212 * x57
    x240 = -x222 * x66 + x239 * x62 + x65 * (x237 - x238)
    x241 = -x106 * x16 + x109 * x212
    x242 = x102 * x212 - x111 * x16
    x243 = x242 * x62
    x244 = x103 * x212 - x115 * x16
    x245 = x244 * x66
    x246 = x105 * x212 - x119 * x16
    x247 = x241 * x62 - x246 * x66 + x65 * (x243 - x245)
    x248 = x24 * x240 + x247
    x249 = -x125 * x16 + x127 * x212
    x250 = x246 * x62
    x251 = x244 * x62
    x252 = x114 * x212 - x131 * x214
    x253 = x252 * x66
    x254 = x118 * x212 - x133 * x214
    x255 = x254 * x66
    x256 = x124 * x212 - x136 * x214
    x257 = x249 * x62 - x256 * x66 + x70 * (x250 - x255 + x65 * (x251 - x253))
    x258 = x223 * x65 - x225 * x65 + x65 * (x219 * x65 - x221 * x65)
    x259 = x240 * x25 + x258
    x260 = (
        x227 * x65
        - x229 * x65
        + x70 * (x233 * x65 - x235 * x65 + x65 * (x230 * x65 - x232 * x65))
    )
    x261 = x138 * x212 - x145 * x16
    x262 = x261 * x62
    x263 = x139 * x212 - x148 * x214
    x264 = x263 * x66
    x265 = -x141 * x16 + x143 * x212
    x266 = x140 * x212 - x150 * x214
    x267 = x24 * x247 + x265 * x62 - x266 * x66 + x65 * (x262 - x264)
    x268 = x250 * x65 - x255 * x65 + x65 * (x251 * x65 - x253 * x65)
    x269 = x247 * x25 + x268
    x270 = 2 / x64**2
    x271 = x233 * x270 - x235 * x270 + x25 * x258 + x65 * (x230 * x270 - x232 * x270)
    x272 = x107 * x212 - x153 * x16
    x273 = -x242 * x66 + x272 * x62
    x274 = x142 * x212 - x158 * x16
    x275 = -x261 * x66 + x274 * x62
    x276 = x24 * x273 + x275
    x277 = x243 * x65 - x245 * x65
    x278 = x25 * x273 + x277
    x279 = -x16 * x163 + x164 * x212
    x280 = x162 * x212 - x166 * x214
    x281 = x262 * x65 - x264 * x65
    x282 = x25 * x277 + x251 * x270 - x253 * x270
    x283 = x237 * x65 - x238 * x65
    x284 = x24 * x283 + x277
    x285 = x219 * x270 - x221 * x270
    x286 = x25 * x283 + x285
    x287 = 6 / x64**3
    x288 = x167 * x171 - x169 * x172 + x83
    x289 = x167 * x182 - x169 * x175 + x94
    x290 = x23 * x289
    x291 = x24 * x289
    x292 = x110 + x167 * x188 - x169 * x189 + x65 * (x167 * x175 - x169 * x176 + x87)
    x293 = x291 + x292
    x294 = x128 + x167 * x192 - x169 * x195 + x65 * (x167 * x172 - x169 * x178 + x90)
    x295 = (
        x144
        + x167 * x199
        - x169 * x200
        + x24 * x292
        + x70
        * (x129 + x167 * x189 - x169 * x194 + x65 * (x167 * x176 - x169 * x180 + x91))
    )
    x296 = x25 * x292
    x297 = x154 + x167 * x203 - x169 * x186 + x65 * (x167 * x181 - x169 * x173 + x95)
    x298 = x23 * x297
    x299 = x24 * x297
    x300 = (
        x159
        + x167 * x207
        - x169 * x197
        + x70
        * (x112 + x167 * x186 - x169 * x187 + x65 * (x167 * x173 - x169 * x174 + x88))
    )
    x301 = x299 + x300
    x302 = x167 * x216 - x169 * x217
    x303 = x167 * x239 - x169 * x222
    x304 = x167 * x222
    x305 = x169 * x224
    x306 = x167 * x241 - x169 * x246 + x65 * (x304 - x305)
    x307 = x24 * x303 + x306
    x308 = x167 * x217
    x309 = x169 * x228
    x310 = x167 * x249 - x169 * x256 + x65 * (x308 - x309)
    x311 = x304 * x65 - x305 * x65
    x312 = x25 * x303 + x311
    x313 = x308 * x65 - x309 * x65
    x314 = x167 * x246
    x315 = x167 * x224
    x316 = x169 * x234
    x317 = x169 * x254
    x318 = (
        x167 * x265 - x169 * x266 + x24 * x306 + x70 * (x314 - x317 + x65 * (x315 - x316))
    )
    x319 = x314 * x65 - x317 * x65 + x65 * (x315 * x65 - x316 * x65)
    x320 = x25 * x306 + x319
    x321 = x25 * x311 + x270 * x315 - x270 * x316
    x322 = x167 * x236
    x323 = x169 * x218
    x324 = x167 * x272 - x169 * x242 + x65 * (x322 - x323)
    x325 = x167 * x218
    x326 = x169 * x220
    x327 = x167 * x242
    x328 = x169 * x244
    x329 = x167 * x274 - x169 * x261 + x70 * (x327 - x328 + x65 * (x325 - x326))
    x330 = x24 * x324 + x329
    x331 = x327 * x65 - x328 * x65 + x65 * (x325 * x65 - x326 * x65)
    x332 = x25 * x324 + x331
    x333 = x167 * x261
    x334 = x169 * x263
    x335 = x167 * x220
    x336 = x169 * x231
    x337 = x167 * x244
    x338 = x169 * x252
    x339 = (
        x333 * x65
        - x334 * x65
        + x70 * (x337 * x65 - x338 * x65 + x65 * (x335 * x65 - x336 * x65))
    )
    x340 = x25 * x331 + x270 * x337 - x270 * x338 + x65 * (x270 * x335 - x270 * x336)
    x341 = x322 * x65 - x323 * x65
    x342 = x24 * x341 + x331
    x343 = x270 * x325 - x270 * x326
    x344 = x25 * x341 + x343
    x345 = x212 * x216 - x214 * x217 + x83
    x346 = x212 * x239 - x214 * x222 + x94
    x347 = x110 + x212 * x241 - x214 * x246
    x348 = x24 * x346 + x347
    x349 = x128 + x212 * x249 - x214 * x256
    x350 = x212 * x222
    x351 = x214 * x224
    x352 = x350 * x65 - x351 * x65 + x65 * (x350 - x351 + x87)
    x353 = x25 * x346 + x352
    x354 = x212 * x217
    x355 = x214 * x228
    x356 = x354 * x65 - x355 * x65 + x65 * (x354 - x355 + x90)
    x357 = x144 + x212 * x265 - x214 * x266 + x24 * x347
    x358 = x212 * x246
    x359 = x214 * x254
    x360 = x358 * x65 - x359 * x65 + x65 * (x129 + x358 - x359)
    x361 = x25 * x347 + x360
    x362 = x212 * x224
    x363 = x214 * x234
    x364 = (
        x25 * x352
        + x270 * x362
        - x270 * x363
        + x70 * (x362 * x65 - x363 * x65 + x65 * (x362 - x363 + x91))
    )
    x365 = x154 + x212 * x272 - x214 * x242
    x366 = x159 + x212 * x274 - x214 * x261
    x367 = x24 * x365 + x366
    x368 = x212 * x242
    x369 = x214 * x244
    x370 = x368 * x65 - x369 * x65 + x65 * (x112 + x368 - x369)
    x371 = x25 * x365 + x370
    x372 = x212 * x261
    x373 = x214 * x263
    x374 = x372 * x65 - x373 * x65 + x65 * (x146 + x372 - x373)
    x375 = x212 * x244
    x376 = x214 * x252
    x377 = (
        x25 * x370
        + x270 * x375
        - x270 * x376
        + x70 * (x375 * x65 - x376 * x65 + x65 * (x130 + x375 - x376))
    )
    x378 = x212 * x236
    x379 = x214 * x218
    x380 = x378 * x65 - x379 * x65 + x65 * (x378 - x379 + x95)
    x381 = x24 * x380 + x370
    x382 = x212 * x218
    x383 = x214 * x220
    x384 = (
        x270 * x382
        - x270 * x383
        + x70 * (x382 * x65 - x383 * x65 + x65 * (x382 - x383 + x88))
    )
    x385 = x25 * x380 + x384
    x386 = x212 * x220
    x387 = x214 * x231

    # 108 item(s)
    S = numpy.array(
        [
            x23 * x89
            + x23 * (x89 + x98)
            + x61
            + x62 * (-x11 * x53 + x60 * x62 + x71 * x72)
            - x66 * (x51 * x62 - x66 * x78 + x72 * x81)
            + x72
            * (
                x62 * x71
                - x66 * x81
                + x70
                * (x62 * x69 + x65 * (x62 * x67 - x66 * x79 + x92) - x66 * x80 + x91)
                + x90
            ),
            x122 * x23 + x137 + x24 * x89,
            x25 * x89 + x25 * x98,
            x122 * x24 + x151,
            x152 + x25 * x99,
            x26 * x97,
            x121 * x23 + x137 + x23 * (x121 + x156),
            x151 + x161 * x23,
            x152 + x156 * x25,
            x160 * x24
            + x161 * x24
            + x165
            + x62 * (-x11 * x163 + x164 * x62)
            - x66 * (x162 * x62 - x166 * x66),
            x157 * x25 + x160 * x25,
            x155 * x26,
            0,
            0,
            0,
            0,
            0,
            0,
            x168 * x62
            - x170 * x66
            + x177 * x23
            + x23 * (x177 + x184)
            + x72
            * (
                x172 * x62
                - x178 * x66
                + x70 * (x176 * x62 - x180 * x66 + x65 * (x174 * x62 - x179 * x66))
            ),
            x177 * x24 + x191 * x23 + x196,
            x177 * x25 + x184 * x25,
            x191 * x24 + x201,
            x185 * x25 + x202,
            x183 * x26,
            x190 * x23 + x196 + x23 * (x190 + x205),
            x201 + x209 * x23,
            x202 + x205 * x25,
            x208 * x24 + x209 * x24 + x210 * x62 - x211 * x66,
            x206 * x25 + x208 * x25,
            x204 * x26,
            0,
            0,
            0,
            0,
            0,
            0,
            x213 * x62
            - x215 * x66
            + x226 * x23
            + x23 * (x226 + x23 * x240)
            + x72 * (x227 - x229 + x70 * (x233 - x235 + x65 * (x230 - x232))),
            x226 * x24 + x23 * x248 + x257,
            x226 * x25 + x23 * x259 + x260,
            x24 * x248 + x267,
            x24 * x259 + x269,
            x25 * x259 + x271,
            x23 * x247 + x23 * (x23 * x273 + x247) + x257,
            x23 * x276 + x267,
            x23 * x278 + x269,
            x24 * x275 + x24 * x276 + x279 * x62 - x280 * x66,
            x24 * x278 + x25 * x275 + x281,
            x25 * x278 + x282,
            x23 * x258 + x23 * (x23 * x283 + x258) + x260,
            x23 * x284 + x24 * x258 + x268,
            x23 * x286 + x271,
            x24 * x277 + x24 * x284 + x281,
            x24 * x286 + x282,
            x230 * x287 - x232 * x287 + x25 * x285 + x25 * x286,
            x167 * x168 - x169 * x170 + x23 * x288 + x23 * (x288 + x290) + x61,
            x23 * x293 + x24 * x288 + x294,
            x25 * x288 + x25 * x290,
            x24 * x293 + x295,
            x25 * x291 + x296,
            x26 * x289,
            x23 * x292 + x23 * (x292 + x298) + x294,
            x23 * x301 + x295,
            x25 * x298 + x296,
            x165
            + x167 * x210
            - x169 * x211
            + x24 * x300
            + x24 * x301
            + x72
            * (
                x146
                + x167 * x197
                - x169 * x198
                + x70
                * (
                    x130
                    + x167 * x187
                    - x169 * x193
                    + x65 * (x167 * x174 - x169 * x179 + x92)
                )
            ),
            x25 * x299 + x25 * x300,
            x26 * x297,
            0,
            0,
            0,
            0,
            0,
            0,
            x167 * x213 - x169 * x215 + x23 * x302 + x23 * (x23 * x303 + x302),
            x23 * x307 + x24 * x302 + x310,
            x23 * x312 + x25 * x302 + x313,
            x24 * x307 + x318,
            x24 * x312 + x320,
            x25 * x312 + x321,
            x23 * x306 + x23 * (x23 * x324 + x306) + x310,
            x23 * x330 + x318,
            x23 * x332 + x320,
            x167 * x279
            - x169 * x280
            + x24 * x329
            + x24 * x330
            + x72 * (x333 - x334 + x70 * (x337 - x338 + x65 * (x335 - x336))),
            x24 * x332 + x25 * x329 + x339,
            x25 * x332 + x340,
            x23 * x311 + x23 * (x23 * x341 + x311) + x313,
            x23 * x342 + x24 * x311 + x319,
            x23 * x344 + x321,
            x24 * x331 + x24 * x342 + x339,
            x24 * x344 + x340,
            x25 * x343 + x25 * x344 + x287 * x335 - x287 * x336,
            x212 * x213 - x214 * x215 + x23 * x345 + x23 * (x23 * x346 + x345) + x61,
            x23 * x348 + x24 * x345 + x349,
            x23 * x353 + x25 * x345 + x356,
            x24 * x348 + x357,
            x24 * x353 + x361,
            x25 * x353 + x364,
            x23 * x347 + x23 * (x23 * x365 + x347) + x349,
            x23 * x367 + x357,
            x23 * x371 + x361,
            x165 + x212 * x279 - x214 * x280 + x24 * x366 + x24 * x367,
            x24 * x371 + x25 * x366 + x374,
            x25 * x371 + x377,
            x23 * x352 + x23 * (x23 * x380 + x352) + x356,
            x23 * x381 + x24 * x352 + x360,
            x23 * x385 + x364,
            x24 * x370 + x24 * x381 + x374,
            x24 * x385 + x377,
            x25 * x384
            + x25 * x385
            + x287 * x386
            - x287 * x387
            + x72
            * (
                x270 * x386
                - x270 * x387
                + x70 * (x386 * x65 - x387 * x65 + x65 * (x386 - x387 + x92))
            ),
        ]
    )
    return S


def eri_2020(a, A, b, B, c, C, d, D):
    """Cartesian [ds|ds] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = numpy.exp(
        -a * b * x10 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = x6 ** (-1.0)
    x13 = numpy.exp(
        -c * d * x12 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x14 = x8 ** (-1.0)
    x15 = x12 * (c * C[0] + d * D[0])
    x16 = -x10 * (a * A[0] + b * B[0])
    x17 = -x15 - x16
    x18 = x12 * (c * C[1] + d * D[1])
    x19 = -x10 * (a * A[1] + b * B[1])
    x20 = -x18 - x19
    x21 = -x10 * (a * A[2] + b * B[2])
    x22 = -x12 * (c * C[2] + d * D[2]) - x21
    x23 = x14 * x7 * (x17**2 + x20**2 + x22**2)
    x24 = boys(1, x23)
    x25 = x14 * x5
    x26 = boys(2, x23)
    x27 = 2 * x11 * x13 * x4 * x9
    x28 = x26 * x27
    x29 = x3 * (2 * x11 * x13 * x24 * x4 * x9 - x25 * x28)
    x30 = x15 - C[0]
    x31 = x24 * x27
    x32 = x17 * x25
    x33 = x28 * x32 + x30 * x31
    x34 = x27 * boys(3, x23)
    x35 = x28 * x30 + x32 * x34
    x36 = x29 + x30 * x33 + x32 * x35
    x37 = x14 * x6
    x38 = x36 * x37
    x39 = boys(0, x23)
    x40 = x3 * (2 * x11 * x13 * x39 * x4 * x9 - x25 * x31)
    x41 = x27 * x39
    x42 = x30 * (x30 * x41 + x31 * x32) + x32 * x33 + x40
    x43 = x1 * (-x38 + x42)
    x44 = -x16 - A[0]
    x45 = x0 + x2
    x46 = x45 ** (-1.0)
    x47 = x17 * x37
    x48 = x28 * x44 - x34 * x47
    x49 = x35 * x37
    x50 = -x17 * x49 + x33 * x44 + x46 * x48
    x51 = 2 * x46
    x52 = -2 * x11 * x13 * x26 * x4 * x9
    x53 = x3 * (-x25 * x34 - x52)
    x54 = x27 * boys(4, x23)
    x55 = x30 * x34 + x32 * x54
    x56 = x30 * x35 + x32 * x55 + x53
    x57 = x34 * x44 - x47 * x54
    x58 = x35 * x44 + x46 * x57 - x47 * x55
    x59 = x1 * (x33 - x49)
    x60 = x1 * (-x34 * x37 - x52)
    x61 = x18 - C[1]
    x62 = x20 * x25
    x63 = x28 * x62 + x31 * x61
    x64 = x28 * x61 + x34 * x62
    x65 = x30 * x63 + x32 * x64
    x66 = x37 * x65
    x67 = x31 * x62 + x41 * x61
    x68 = x30 * x67 + x32 * x63
    x69 = x1 * (-x66 + x68)
    x70 = x37 * x64
    x71 = x1 * (x63 - x70)
    x72 = -x17 * x70 + x44 * x63
    x73 = x34 * x61 + x54 * x62
    x74 = x44 * x64 - x47 * x73
    x75 = x30 * x64 + x32 * x73
    x76 = x29 + x61 * x63 + x62 * x64
    x77 = x37 * x76
    x78 = x40 + x61 * x67 + x62 * x63
    x79 = x1 * (-x77 + x78)
    x80 = x53 + x61 * x64 + x62 * x73
    x81 = -x19 - A[1]
    x82 = -x20 * x38 + x42 * x81
    x83 = x20 * x37
    x84 = x36 * x81 - x56 * x83
    x85 = x28 * x81 - x34 * x83
    x86 = x34 * x81 - x54 * x83
    x87 = -x20 * x49 + x33 * x81
    x88 = x35 * x81 - x55 * x83
    x89 = -x20 * x70 + x46 * x85 + x63 * x81
    x90 = x46 * x86 + x64 * x81 - x73 * x83
    x91 = -x20 * x66 + x46 * x87 + x68 * x81
    x92 = x46 * x88 + x65 * x81 - x75 * x83
    x93 = -x20 * x77 + x51 * x89 + x78 * x81
    x94 = x51 * x90 + x76 * x81 - x80 * x83
    x95 = -x21 - A[2]
    x96 = -x22 * x38 + x42 * x95
    x97 = x22 * x37
    x98 = x36 * x95 - x56 * x97
    x99 = x28 * x95 - x34 * x97
    x100 = x44 * x99
    x101 = x34 * x95 - x54 * x97
    x102 = x101 * x47
    x103 = -x22 * x49 + x33 * x95
    x104 = x103 * x44
    x105 = x35 * x95 - x55 * x97
    x106 = x105 * x47
    x107 = -x22 * x66 + x68 * x95
    x108 = -x22 * x70 + x63 * x95
    x109 = x108 * x44
    x110 = x64 * x95 - x73 * x97
    x111 = x110 * x47
    x112 = x65 * x95 - x75 * x97
    x113 = -x22 * x77 + x78 * x95
    x114 = x76 * x95 - x80 * x97
    x115 = 2 / x45**2
    x116 = x103 * x81
    x117 = x105 * x83
    x118 = x81 * x99
    x119 = x101 * x83
    x120 = x108 * x81
    x121 = x110 * x83
    x122 = x103 * x95
    x123 = x105 * x97
    x124 = x108 * x95
    x125 = x110 * x97
    x126 = x95 * x99
    x127 = x101 * x97

    # 36 item(s)
    S = numpy.array(
        [
            x43
            + x44 * (-x17 * x38 + x42 * x44 + x50 * x51)
            - x47 * (x36 * x44 - x47 * x56 + x51 * x58)
            + x51 * (x44 * x50 + x46 * (x44 * x48 - x47 * x57 + x60) - x47 * x58 + x59),
            x44 * (-x17 * x66 + x44 * x68 + x46 * x72)
            + x46 * (x44 * x72 - x47 * x74 + x71)
            - x47 * (x44 * x65 + x46 * x74 - x47 * x75)
            + x69,
            0,
            x44 * (-x17 * x77 + x44 * x78) - x47 * (x44 * x76 - x47 * x80) + x79,
            0,
            0,
            x44 * x82
            - x47 * x84
            + x51 * (x44 * x87 + x46 * (x44 * x85 - x47 * x86) - x47 * x88),
            x44 * x91 + x46 * (x44 * x89 - x47 * x90) - x47 * x92,
            0,
            x44 * x93 - x47 * x94,
            0,
            0,
            x44 * x96 - x47 * x98 + x51 * (x104 - x106 + x46 * (x100 - x102)),
            x107 * x44 - x112 * x47 + x46 * (x109 - x111),
            x104 * x46 - x106 * x46 + x46 * (x100 * x46 - x102 * x46),
            x113 * x44 - x114 * x47,
            x109 * x46 - x111 * x46,
            x100 * x115 - x102 * x115,
            x43 + x81 * x82 - x83 * x84,
            x46 * (x59 + x81 * x87 - x83 * x88) + x69 + x81 * x91 - x83 * x92,
            0,
            x51 * (x46 * (x60 + x81 * x85 - x83 * x86) + x71 + x81 * x89 - x83 * x90)
            + x79
            + x81 * x93
            - x83 * x94,
            0,
            0,
            x81 * x96 - x83 * x98,
            x107 * x81 - x112 * x83 + x46 * (x116 - x117),
            x116 * x46 - x117 * x46,
            x113 * x81 - x114 * x83 + x51 * (x120 - x121 + x46 * (x118 - x119)),
            x120 * x46 - x121 * x46 + x46 * (x118 * x46 - x119 * x46),
            x115 * x118 - x115 * x119,
            x43 + x95 * x96 - x97 * x98,
            x107 * x95 - x112 * x97 + x69,
            x122 * x46 - x123 * x46 + x46 * (x122 - x123 + x59),
            x113 * x95 - x114 * x97 + x79,
            x124 * x46 - x125 * x46 + x46 * (x124 - x125 + x71),
            x115 * x126
            - x115 * x127
            + x51 * (x126 * x46 - x127 * x46 + x46 * (x126 - x127 + x60)),
        ]
    )
    return S


def eri_2021(a, A, b, B, c, C, d, D):
    """Cartesian [ds|dp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = c + d
    x3 = x2 ** (-1.0)
    x4 = x3 * (c * C[0] + d * D[0])
    x5 = x4 - C[0]
    x6 = a + b
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = -x9 * (a * A[0] + b * B[0])
    x11 = -x10 - x4
    x12 = x3 * (c * C[1] + d * D[1])
    x13 = -x9 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x9 * (a * A[2] + b * B[2])
    x16 = -x15 - x3 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = numpy.exp(
        -a * b * x9 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x23 = C[0] - D[0]
    x24 = C[1] - D[1]
    x25 = C[2] - D[2]
    x26 = numpy.exp(-c * d * x3 * (x23**2 + x24**2 + x25**2))
    x27 = 2 * x20 * x21 * x22 * x26
    x28 = x19 * x27
    x29 = x6 * x8
    x30 = x11 * x29
    x31 = boys(3, x18)
    x32 = x27 * x31
    x33 = x28 * x5 + x30 * x32
    x34 = x29 * x33
    x35 = boys(1, x18)
    x36 = x27 * x35
    x37 = x28 * x30 + x36 * x5
    x38 = 2 * c + 2 * d
    x39 = x38 ** (-1.0)
    x40 = 2 * x39
    x41 = x39 * (2 * x20 * x21 * x22 * x26 * x35 - x28 * x29)
    x42 = x11 * x34 + x37 * x5 + x41
    x43 = -2 * x19 * x20 * x21 * x22 * x26
    x44 = x39 * (-x29 * x32 - x43)
    x45 = x27 * boys(4, x18)
    x46 = x30 * x45 + x32 * x5
    x47 = x29 * x46
    x48 = x11 * x47 + x33 * x5 + x44
    x49 = x30 * x48 + x40 * (-x34 + x37) + x42 * x5
    x50 = x2 * x8
    x51 = x49 * x50
    x52 = x29 * x37
    x53 = boys(0, x18)
    x54 = x27 * x53
    x55 = x30 * x36 + x5 * x54
    x56 = x39 * (2 * x20 * x21 * x22 * x26 * x53 - x29 * x36)
    x57 = x11 * x52 + x5 * x55 + x56
    x58 = x30 * x42 + x40 * (-x52 + x55) + x5 * x57
    x59 = x1 * (-x51 + x58)
    x60 = -x10 - A[0]
    x61 = x48 * x50
    x62 = x0 + x38
    x63 = x62 ** (-1.0)
    x64 = x11 * x50
    x65 = x32 * x60 - x45 * x64
    x66 = x46 * x50
    x67 = -x11 * x66 + x33 * x60 + x63 * x65
    x68 = 2 * x63
    x69 = -x11 * x61 + x42 * x60 + x67 * x68
    x70 = 3 * x63
    x71 = -2 * x20 * x21 * x22 * x26 * x31
    x72 = x39 * (-x29 * x45 - x71)
    x73 = x27 * boys(5, x18)
    x74 = x30 * x73 + x45 * x5
    x75 = x30 * x74 + x46 * x5 + x72
    x76 = x30 * x75 + x40 * (x33 - x47) + x48 * x5
    x77 = x45 * x60 - x64 * x73
    x78 = x46 * x60 + x63 * x77 - x64 * x74
    x79 = x48 * x60 - x64 * x75 + x68 * x78
    x80 = x42 * x50
    x81 = x1 * (x57 - x80)
    x82 = x28 * x60 - x32 * x64
    x83 = x33 * x50
    x84 = -x11 * x83 + x37 * x60 + x63 * x82
    x85 = x1 * (x37 - x83)
    x86 = x1 * (-x32 * x50 - x43)
    x87 = (
        x60 * (-x11 * x80 + x57 * x60 + x68 * x84)
        - x64 * x69
        + x68 * (x60 * x84 + x63 * (x60 * x82 - x64 * x65 + x86) - x64 * x67 + x85)
        + x81
    )
    x88 = x1 * (x42 - x61)
    x89 = x1 * (x33 - x66)
    x90 = x1 * (-x45 * x50 - x71)
    x91 = x12 - C[1]
    x92 = x14 * x29
    x93 = x28 * x91 + x32 * x92
    x94 = x29 * x93
    x95 = x28 * x92 + x36 * x91
    x96 = x39 * (-x94 + x95)
    x97 = x11 * x94 + x5 * x95
    x98 = x32 * x91 + x45 * x92
    x99 = x29 * x98
    x100 = x11 * x99 + x5 * x93
    x101 = x100 * x30 + x5 * x97 + x96
    x102 = x101 * x50
    x103 = x29 * x95
    x104 = x36 * x92 + x54 * x91
    x105 = x39 * (-x103 + x104)
    x106 = x103 * x11 + x104 * x5
    x107 = x105 + x106 * x5 + x30 * x97
    x108 = x1 * (-x102 + x107)
    x109 = x50 * x98
    x110 = -x109 * x11 + x60 * x93
    x111 = x100 * x50
    x112 = -x11 * x111 + x110 * x63 + x60 * x97
    x113 = x1 * (-x111 + x97)
    x114 = x1 * (-x109 + x93)
    x115 = x45 * x91 + x73 * x92
    x116 = -x115 * x64 + x60 * x98
    x117 = x115 * x30 + x5 * x98
    x118 = x100 * x60 + x116 * x63 - x117 * x64
    x119 = x39 * (x93 - x99)
    x120 = x100 * x5 + x117 * x30 + x119
    x121 = (
        x108
        + x60 * (-x102 * x11 + x107 * x60 + x112 * x68)
        - x64 * (x101 * x60 + x118 * x68 - x120 * x64)
        + x68 * (x112 * x60 + x113 - x118 * x64 + x63 * (x110 * x60 + x114 - x116 * x64))
    )
    x122 = x50 * x97
    x123 = x1 * (x106 - x122)
    x124 = x50 * x93
    x125 = x1 * (-x124 + x95)
    x126 = -x11 * x124 + x60 * x95
    x127 = (
        -x112 * x64
        + x123
        + x60 * (x106 * x60 - x11 * x122 + x126 * x63)
        + x63 * (-x110 * x64 + x125 + x126 * x60)
    )
    x128 = x14 * x94 + x41 + x91 * x95
    x129 = x14 * x99 + x44 + x91 * x93
    x130 = x128 * x5 + x129 * x30
    x131 = x130 * x50
    x132 = x103 * x14 + x104 * x91 + x56
    x133 = x128 * x30 + x132 * x5
    x134 = x1 * (-x131 + x133)
    x135 = x129 * x50
    x136 = x1 * (x128 - x135)
    x137 = -x11 * x135 + x128 * x60
    x138 = x115 * x92 + x72 + x91 * x98
    x139 = x129 * x60 - x138 * x64
    x140 = x129 * x5 + x138 * x30
    x141 = (
        x134
        + x60 * (-x11 * x131 + x133 * x60 + x137 * x63)
        + x63 * (x136 + x137 * x60 - x139 * x64)
        - x64 * (x130 * x60 + x139 * x63 - x140 * x64)
    )
    x142 = x128 * x50
    x143 = x1 * (x132 - x142)
    x144 = -x137 * x64 + x143 + x60 * (-x11 * x142 + x132 * x60)
    x145 = x128 * x91 + x129 * x92 + 2 * x96
    x146 = x145 * x50
    x147 = 2 * x105 + x128 * x92 + x132 * x91
    x148 = x1 * (-x146 + x147)
    x149 = 2 * x119 + x129 * x91 + x138 * x92
    x150 = -x13 - A[1]
    x151 = -x14 * x51 + x150 * x58
    x152 = x14 * x50
    x153 = x150 * x49 - x152 * x76
    x154 = -x14 * x80 + x150 * x57
    x155 = -x14 * x61 + x150 * x42
    x156 = x150 * x28 - x152 * x32
    x157 = x150 * x32 - x152 * x45
    x158 = -x14 * x83 + x150 * x37
    x159 = -x14 * x66 + x150 * x33
    x160 = (
        x154 * x60
        - x155 * x64
        + x68 * (x158 * x60 - x159 * x64 + x63 * (x156 * x60 - x157 * x64))
    )
    x161 = x150 * x48 - x152 * x75
    x162 = x150 * x45 - x152 * x73
    x163 = x150 * x46 - x152 * x74
    x164 = -x102 * x14 + x107 * x150 + x155 * x63
    x165 = -x109 * x14 + x150 * x93 + x157 * x63
    x166 = -x115 * x152 + x150 * x98 + x162 * x63
    x167 = -x111 * x14 + x150 * x97 + x159 * x63
    x168 = x100 * x150 - x117 * x152 + x163 * x63
    x169 = x101 * x150 - x120 * x152 + x161 * x63
    x170 = (
        x164 * x60
        - x169 * x64
        + x68 * (x167 * x60 - x168 * x64 + x63 * (x165 * x60 - x166 * x64))
    )
    x171 = -x124 * x14 + x150 * x95 + x156 * x63
    x172 = x106 * x150 - x122 * x14 + x158 * x63
    x173 = -x167 * x64 + x172 * x60 + x63 * (-x165 * x64 + x171 * x60)
    x174 = x128 * x150 - x135 * x14 + x165 * x68
    x175 = x129 * x150 - x138 * x152 + x166 * x68
    x176 = -x131 * x14 + x133 * x150 + x167 * x68
    x177 = x130 * x150 - x140 * x152 + x168 * x68
    x178 = x176 * x60 - x177 * x64 + x63 * (x174 * x60 - x175 * x64)
    x179 = x132 * x150 - x14 * x142 + x171 * x68
    x180 = -x174 * x64 + x179 * x60
    x181 = -x14 * x146 + x147 * x150 + x174 * x70
    x182 = x145 * x150 - x149 * x152 + x175 * x70
    x183 = -x15 - A[2]
    x184 = -x16 * x51 + x183 * x58
    x185 = x16 * x50
    x186 = x183 * x49 - x185 * x76
    x187 = -x16 * x80 + x183 * x57
    x188 = -x16 * x61 + x183 * x42
    x189 = x183 * x28 - x185 * x32
    x190 = x189 * x60
    x191 = x183 * x32 - x185 * x45
    x192 = x191 * x64
    x193 = -x16 * x83 + x183 * x37
    x194 = x193 * x60
    x195 = -x16 * x66 + x183 * x33
    x196 = x195 * x64
    x197 = x187 * x60 - x188 * x64 + x68 * (x194 - x196 + x63 * (x190 - x192))
    x198 = x188 * x60
    x199 = x183 * x48 - x185 * x75
    x200 = x199 * x64
    x201 = x191 * x60
    x202 = x183 * x45 - x185 * x73
    x203 = x202 * x64
    x204 = x195 * x60
    x205 = x183 * x46 - x185 * x74
    x206 = x205 * x64
    x207 = -x102 * x16 + x107 * x183
    x208 = -x111 * x16 + x183 * x97
    x209 = x208 * x60
    x210 = -x109 * x16 + x183 * x93
    x211 = x210 * x60
    x212 = -x115 * x185 + x183 * x98
    x213 = x212 * x64
    x214 = x100 * x183 - x117 * x185
    x215 = x214 * x64
    x216 = x101 * x183 - x120 * x185
    x217 = x207 * x60 - x216 * x64 + x68 * (x209 - x215 + x63 * (x211 - x213))
    x218 = (
        x198 * x63
        - x200 * x63
        + x68 * (x204 * x63 - x206 * x63 + x63 * (x201 * x63 - x203 * x63))
    )
    x219 = x106 * x183 - x122 * x16
    x220 = -x124 * x16 + x183 * x95
    x221 = x220 * x60
    x222 = x210 * x64
    x223 = -x208 * x64 + x219 * x60 + x63 * (x221 - x222)
    x224 = x128 * x183 - x135 * x16
    x225 = x224 * x60
    x226 = x129 * x183 - x138 * x185
    x227 = x226 * x64
    x228 = -x131 * x16 + x133 * x183
    x229 = x130 * x183 - x140 * x185
    x230 = x228 * x60 - x229 * x64 + x63 * (x225 - x227)
    x231 = x209 * x63 - x215 * x63 + x63 * (x211 * x63 - x213 * x63)
    x232 = x194 * x63 - x196 * x63 + x63 * (x190 * x63 - x192 * x63)
    x233 = 2 / x62**2
    x234 = x204 * x233 - x206 * x233 + x63 * (x201 * x233 - x203 * x233)
    x235 = x132 * x183 - x142 * x16
    x236 = -x224 * x64 + x235 * x60
    x237 = -x146 * x16 + x147 * x183
    x238 = x145 * x183 - x149 * x185
    x239 = x225 * x63 - x227 * x63
    x240 = x221 * x63 - x222 * x63
    x241 = x211 * x233 - x213 * x233
    x242 = x190 * x233 - x192 * x233
    x243 = 6 / x62**3
    x244 = x150 * x154 - x152 * x155 + x81
    x245 = x108 + x150 * x164 - x152 * x169 + x63 * (x150 * x155 - x152 * x161 + x88)
    x246 = x123 + x150 * x172 - x152 * x167 + x63 * (x150 * x158 - x152 * x159 + x85)
    x247 = (
        x134
        + x150 * x176
        - x152 * x177
        + x68
        * (x113 + x150 * x167 - x152 * x168 + x63 * (x150 * x159 - x152 * x163 + x89))
    )
    x248 = (
        x143
        + x150 * x179
        - x152 * x174
        + x68
        * (x125 + x150 * x171 - x152 * x165 + x63 * (x150 * x156 - x152 * x157 + x86))
    )
    x249 = x150 * x187 - x152 * x188
    x250 = x150 * x188
    x251 = x152 * x199
    x252 = x150 * x207 - x152 * x216 + x63 * (x250 - x251)
    x253 = x250 * x63 - x251 * x63
    x254 = x150 * x193
    x255 = x152 * x195
    x256 = x150 * x219 - x152 * x208 + x63 * (x254 - x255)
    x257 = x150 * x208
    x258 = x150 * x195
    x259 = x152 * x205
    x260 = x152 * x214
    x261 = x150 * x228 - x152 * x229 + x68 * (x257 - x260 + x63 * (x258 - x259))
    x262 = x257 * x63 - x260 * x63 + x63 * (x258 * x63 - x259 * x63)
    x263 = x254 * x63 - x255 * x63
    x264 = x233 * x258 - x233 * x259
    x265 = x150 * x189
    x266 = x152 * x191
    x267 = x150 * x220
    x268 = x152 * x210
    x269 = x150 * x235 - x152 * x224 + x68 * (x267 - x268 + x63 * (x265 - x266))
    x270 = x150 * x224
    x271 = x152 * x226
    x272 = x150 * x191
    x273 = x152 * x202
    x274 = x150 * x210
    x275 = x152 * x212
    x276 = (
        x270 * x63
        - x271 * x63
        + x68 * (x274 * x63 - x275 * x63 + x63 * (x272 * x63 - x273 * x63))
    )
    x277 = x267 * x63 - x268 * x63 + x63 * (x265 * x63 - x266 * x63)
    x278 = x233 * x274 - x233 * x275 + x63 * (x233 * x272 - x233 * x273)
    x279 = x233 * x265 - x233 * x266
    x280 = x183 * x187 - x185 * x188 + x81
    x281 = x108 + x183 * x207 - x185 * x216
    x282 = x183 * x188
    x283 = x185 * x199
    x284 = x282 * x63 - x283 * x63 + x63 * (x282 - x283 + x88)
    x285 = x123 + x183 * x219 - x185 * x208
    x286 = x134 + x183 * x228 - x185 * x229
    x287 = x183 * x208
    x288 = x185 * x214
    x289 = x287 * x63 - x288 * x63 + x63 * (x113 + x287 - x288)
    x290 = x183 * x193
    x291 = x185 * x195
    x292 = x290 * x63 - x291 * x63 + x63 * (x290 - x291 + x85)
    x293 = x183 * x195
    x294 = x185 * x205
    x295 = (
        x233 * x293
        - x233 * x294
        + x68 * (x293 * x63 - x294 * x63 + x63 * (x293 - x294 + x89))
    )
    x296 = x143 + x183 * x235 - x185 * x224
    x297 = x183 * x224
    x298 = x185 * x226
    x299 = x297 * x63 - x298 * x63 + x63 * (x136 + x297 - x298)
    x300 = x183 * x220
    x301 = x185 * x210
    x302 = x300 * x63 - x301 * x63 + x63 * (x125 + x300 - x301)
    x303 = x183 * x210
    x304 = x185 * x212
    x305 = (
        x233 * x303
        - x233 * x304
        + x68 * (x303 * x63 - x304 * x63 + x63 * (x114 + x303 - x304))
    )
    x306 = x183 * x189
    x307 = x185 * x191
    x308 = (
        x233 * x306
        - x233 * x307
        + x68 * (x306 * x63 - x307 * x63 + x63 * (x306 - x307 + x86))
    )
    x309 = x183 * x191
    x310 = x185 * x202

    # 108 item(s)
    S = numpy.array(
        [
            x23 * x87
            + x59
            + x60 * (-x11 * x51 + x58 * x60 + x69 * x70)
            - x64 * (x49 * x60 - x64 * x76 + x70 * x79)
            + x70
            * (
                x60 * x69
                - x64 * x79
                + x68
                * (x60 * x67 + x63 * (x60 * x65 - x64 * x77 + x90) - x64 * x78 + x89)
                + x88
            ),
            x121 + x24 * x87,
            x25 * x87,
            x121 + x127 * x23,
            x127 * x24 + x141,
            x127 * x25,
            0,
            0,
            0,
            x141 + x144 * x23,
            x144 * x24
            + x148
            + x60 * (-x11 * x146 + x147 * x60)
            - x64 * (x145 * x60 - x149 * x64),
            x144 * x25,
            0,
            0,
            0,
            0,
            0,
            0,
            x151 * x60
            - x153 * x64
            + x160 * x23
            + x70
            * (
                x155 * x60
                - x161 * x64
                + x68 * (x159 * x60 - x163 * x64 + x63 * (x157 * x60 - x162 * x64))
            ),
            x160 * x24 + x170,
            x160 * x25,
            x170 + x173 * x23,
            x173 * x24 + x178,
            x173 * x25,
            0,
            0,
            0,
            x178 + x180 * x23,
            x180 * x24 + x181 * x60 - x182 * x64,
            x180 * x25,
            0,
            0,
            0,
            0,
            0,
            0,
            x184 * x60
            - x186 * x64
            + x197 * x23
            + x70 * (x198 - x200 + x68 * (x204 - x206 + x63 * (x201 - x203))),
            x197 * x24 + x217,
            x197 * x25 + x218,
            x217 + x223 * x23,
            x223 * x24 + x230,
            x223 * x25 + x231,
            x218 + x23 * x232,
            x231 + x232 * x24,
            x232 * x25 + x234,
            x23 * x236 + x230,
            x236 * x24 + x237 * x60 - x238 * x64,
            x236 * x25 + x239,
            x23 * x240 + x231,
            x239 + x24 * x240,
            x240 * x25 + x241,
            x23 * x242 + x234,
            x24 * x242 + x241,
            x201 * x243 - x203 * x243 + x242 * x25,
            x150 * x151 - x152 * x153 + x23 * x244 + x59,
            x24 * x244 + x245,
            x244 * x25,
            x23 * x246 + x245,
            x24 * x246 + x247,
            x246 * x25,
            0,
            0,
            0,
            x23 * x248 + x247,
            x148
            + x150 * x181
            - x152 * x182
            + x24 * x248
            + x70
            * (
                x136
                + x150 * x174
                - x152 * x175
                + x68
                * (
                    x114
                    + x150 * x165
                    - x152 * x166
                    + x63 * (x150 * x157 - x152 * x162 + x90)
                )
            ),
            x248 * x25,
            0,
            0,
            0,
            0,
            0,
            0,
            x150 * x184 - x152 * x186 + x23 * x249,
            x24 * x249 + x252,
            x249 * x25 + x253,
            x23 * x256 + x252,
            x24 * x256 + x261,
            x25 * x256 + x262,
            x23 * x263 + x253,
            x24 * x263 + x262,
            x25 * x263 + x264,
            x23 * x269 + x261,
            x150 * x237
            - x152 * x238
            + x24 * x269
            + x70 * (x270 - x271 + x68 * (x274 - x275 + x63 * (x272 - x273))),
            x25 * x269 + x276,
            x23 * x277 + x262,
            x24 * x277 + x276,
            x25 * x277 + x278,
            x23 * x279 + x264,
            x24 * x279 + x278,
            x243 * x272 - x243 * x273 + x25 * x279,
            x183 * x184 - x185 * x186 + x23 * x280 + x59,
            x24 * x280 + x281,
            x25 * x280 + x284,
            x23 * x285 + x281,
            x24 * x285 + x286,
            x25 * x285 + x289,
            x23 * x292 + x284,
            x24 * x292 + x289,
            x25 * x292 + x295,
            x23 * x296 + x286,
            x148 + x183 * x237 - x185 * x238 + x24 * x296,
            x25 * x296 + x299,
            x23 * x302 + x289,
            x24 * x302 + x299,
            x25 * x302 + x305,
            x23 * x308 + x295,
            x24 * x308 + x305,
            x243 * x309
            - x243 * x310
            + x25 * x308
            + x70
            * (
                x233 * x309
                - x233 * x310
                + x68 * (x309 * x63 - x310 * x63 + x63 * (x309 - x310 + x90))
            ),
        ]
    )
    return S


def eri_2022(a, A, b, B, c, C, d, D):
    """Cartesian [ds|dd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = x0 ** (-1.0)
    x2 = 2 * c + 2 * d
    x3 = x2 ** (-1.0)
    x4 = numpy.pi**2.5
    x5 = a + b
    x6 = c + d
    x7 = x5 * x6
    x8 = x5 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = x5 ** (-1.0)
    x11 = numpy.exp(
        -a * b * x10 * ((A[0] - B[0]) ** 2 + (A[1] - B[1]) ** 2 + (A[2] - B[2]) ** 2)
    )
    x12 = x6 ** (-1.0)
    x13 = C[0] - D[0]
    x14 = C[1] - D[1]
    x15 = C[2] - D[2]
    x16 = x15**2
    x17 = numpy.exp(-c * d * x12 * (x13**2 + x14**2 + x16))
    x18 = x8 ** (-1.0)
    x19 = x12 * (c * C[0] + d * D[0])
    x20 = -x10 * (a * A[0] + b * B[0])
    x21 = -x19 - x20
    x22 = x12 * (c * C[1] + d * D[1])
    x23 = -x10 * (a * A[1] + b * B[1])
    x24 = -x22 - x23
    x25 = -x10 * (a * A[2] + b * B[2])
    x26 = -x12 * (c * C[2] + d * D[2]) - x25
    x27 = x18 * x7 * (x21**2 + x24**2 + x26**2)
    x28 = boys(2, x27)
    x29 = -2 * x11 * x17 * x28 * x4 * x9
    x30 = x18 * x5
    x31 = boys(3, x27)
    x32 = 2 * x11 * x17 * x4 * x9
    x33 = x31 * x32
    x34 = x3 * (-x29 - x30 * x33)
    x35 = x19 - C[0]
    x36 = x28 * x32
    x37 = x21 * x30
    x38 = x33 * x37 + x35 * x36
    x39 = boys(4, x27)
    x40 = x32 * x39
    x41 = x33 * x35 + x37 * x40
    x42 = x30 * x41
    x43 = x21 * x42 + x34 + x35 * x38
    x44 = x30 * x43
    x45 = boys(1, x27)
    x46 = x3 * (2 * x11 * x17 * x4 * x45 * x9 - x30 * x36)
    x47 = x32 * x45
    x48 = x35 * x47 + x36 * x37
    x49 = x30 * x38
    x50 = x21 * x49 + x35 * x48 + x46
    x51 = 3 * x3
    x52 = 2 * x3
    x53 = x21 * x44 + x35 * x50 + x52 * (x48 - x49)
    x54 = -2 * x11 * x17 * x31 * x4 * x9
    x55 = x3 * (-x30 * x40 - x54)
    x56 = x32 * boys(5, x27)
    x57 = x35 * x40 + x37 * x56
    x58 = x30 * x57
    x59 = x21 * x58 + x35 * x41 + x55
    x60 = x30 * x59
    x61 = x21 * x60 + x35 * x43 + x52 * (x38 - x42)
    x62 = x35 * x53 + x37 * x61 + x51 * (-x44 + x50)
    x63 = x18 * x6
    x64 = x62 * x63
    x65 = x30 * x50
    x66 = boys(0, x27)
    x67 = x3 * (2 * x11 * x17 * x4 * x66 * x9 - x30 * x47)
    x68 = x32 * x66
    x69 = x35 * x68 + x37 * x47
    x70 = x30 * x48
    x71 = x21 * x70 + x35 * x69 + x67
    x72 = x21 * x65 + x35 * x71 + x52 * (x69 - x70)
    x73 = x35 * x72 + x37 * x53 + x51 * (-x65 + x71)
    x74 = x1 * (-x64 + x73)
    x75 = -x20 - A[0]
    x76 = x61 * x63
    x77 = x59 * x63
    x78 = x0 + x2
    x79 = x78 ** (-1.0)
    x80 = x21 * x63
    x81 = x40 * x75 - x56 * x80
    x82 = x57 * x63
    x83 = -x21 * x82 + x41 * x75 + x79 * x81
    x84 = 2 * x79
    x85 = -x21 * x77 + x43 * x75 + x83 * x84
    x86 = 3 * x79
    x87 = -x21 * x76 + x53 * x75 + x85 * x86
    x88 = 4 * x79
    x89 = -2 * x11 * x17 * x39 * x4 * x9
    x90 = x3 * (-x30 * x56 - x89)
    x91 = x32 * boys(6, x27)
    x92 = x35 * x56 + x37 * x91
    x93 = x35 * x57 + x37 * x92 + x90
    x94 = x35 * x59 + x37 * x93 + x52 * (x41 - x58)
    x95 = x35 * x61 + x37 * x94 + x51 * (x43 - x60)
    x96 = x56 * x75 - x80 * x91
    x97 = x57 * x75 + x79 * x96 - x80 * x92
    x98 = x59 * x75 - x80 * x93 + x84 * x97
    x99 = x61 * x75 - x80 * x94 + x86 * x98
    x100 = x53 * x63
    x101 = x1 * (-x100 + x72)
    x102 = x43 * x63
    x103 = x33 * x75 - x40 * x80
    x104 = x41 * x63
    x105 = x103 * x79 - x104 * x21 + x38 * x75
    x106 = -x102 * x21 + x105 * x84 + x50 * x75
    x107 = x1 * (-x102 + x50)
    x108 = x1 * (-x104 + x38)
    x109 = x1 * (-x40 * x63 - x54)
    x110 = (
        x101
        + x75 * (-x100 * x21 + x106 * x86 + x72 * x75)
        - x80 * x87
        + x86
        * (
            x106 * x75
            + x107
            - x80 * x85
            + x84
            * (x105 * x75 + x108 + x79 * (x103 * x75 + x109 - x80 * x81) - x80 * x83)
        )
    )
    x111 = x1 * (x53 - x76)
    x112 = x1 * (x43 - x77)
    x113 = x1 * (x41 - x82)
    x114 = x1 * (-x56 * x63 - x89)
    x115 = x50 * x63
    x116 = x1 * (-x115 + x71)
    x117 = -x33 * x80 + x36 * x75
    x118 = x38 * x63
    x119 = x117 * x79 - x118 * x21 + x48 * x75
    x120 = x1 * (-x118 + x48)
    x121 = x1 * (-x29 - x33 * x63)
    x122 = (
        -x106 * x80
        + x116
        + x75 * (-x115 * x21 + x119 * x84 + x71 * x75)
        + x84
        * (-x105 * x80 + x119 * x75 + x120 + x79 * (-x103 * x80 + x117 * x75 + x121))
    )
    x123 = x122 * x13
    x124 = x122 * x14
    x125 = x22 - C[1]
    x126 = x24 * x30
    x127 = x125 * x36 + x126 * x33
    x128 = x127 * x30
    x129 = x125 * x47 + x126 * x36
    x130 = x3 * (-x128 + x129)
    x131 = x128 * x21 + x129 * x35
    x132 = x125 * x33 + x126 * x40
    x133 = x132 * x30
    x134 = x127 * x35 + x133 * x21
    x135 = x134 * x30
    x136 = x130 + x131 * x35 + x135 * x21
    x137 = x136 * x63
    x138 = x129 * x30
    x139 = x125 * x68 + x126 * x47
    x140 = x3 * (-x138 + x139)
    x141 = x138 * x21 + x139 * x35
    x142 = x131 * x30
    x143 = x140 + x141 * x35 + x142 * x21
    x144 = x1 * (-x137 + x143)
    x145 = x132 * x63
    x146 = x127 * x75 - x145 * x21
    x147 = x134 * x63
    x148 = x131 * x75 + x146 * x79 - x147 * x21
    x149 = x3 * (x127 - x133)
    x150 = x125 * x40 + x126 * x56
    x151 = x150 * x30
    x152 = x132 * x35 + x151 * x21
    x153 = x152 * x30
    x154 = x134 * x35 + x149 + x153 * x21
    x155 = x154 * x63
    x156 = x150 * x63
    x157 = x132 * x75 - x156 * x21
    x158 = x152 * x63
    x159 = x134 * x75 + x157 * x79 - x158 * x21
    x160 = x136 * x75 - x155 * x21 + x159 * x84
    x161 = x1 * (x131 - x147)
    x162 = x1 * (x127 - x145)
    x163 = (
        x144
        - x160 * x80
        + x75 * (-x137 * x21 + x143 * x75 + x148 * x84)
        + x84 * (x148 * x75 - x159 * x80 + x161 + x79 * (x146 * x75 - x157 * x80 + x162))
    )
    x164 = x124 + x163
    x165 = x136 * x35 + x154 * x37 + x52 * (x131 - x135)
    x166 = x165 * x63
    x167 = x136 * x37 + x143 * x35 + x52 * (x141 - x142)
    x168 = x1 * (-x166 + x167)
    x169 = x1 * (x136 - x155)
    x170 = x3 * (x132 - x151)
    x171 = x125 * x56 + x126 * x91
    x172 = x150 * x35 + x171 * x37
    x173 = x152 * x35 + x170 + x172 * x37
    x174 = x150 * x75 - x171 * x80
    x175 = x152 * x75 - x172 * x80 + x174 * x79
    x176 = x154 * x75 - x173 * x80 + x175 * x84
    x177 = x1 * (x134 - x158)
    x178 = x1 * (x132 - x156)
    x179 = x154 * x35 + x173 * x37 + x52 * (x134 - x153)
    x180 = (
        x168
        + x75 * (x160 * x86 - x166 * x21 + x167 * x75)
        - x80 * (x165 * x75 + x176 * x86 - x179 * x80)
        + x86
        * (
            x160 * x75
            + x169
            - x176 * x80
            + x84
            * (x159 * x75 - x175 * x80 + x177 + x79 * (x157 * x75 - x174 * x80 + x178))
        )
    )
    x181 = x125 * x127 + x133 * x24 + x34
    x182 = x181 * x30
    x183 = x125 * x129 + x128 * x24 + x46
    x184 = x3 * (-x182 + x183)
    x185 = x182 * x21 + x183 * x35
    x186 = x125 * x132 + x151 * x24 + x55
    x187 = x186 * x30
    x188 = x181 * x35 + x187 * x21
    x189 = x184 + x185 * x35 + x188 * x37
    x190 = x189 * x63
    x191 = x183 * x30
    x192 = x125 * x139 + x138 * x24 + x67
    x193 = x3 * (-x191 + x192)
    x194 = x191 * x21 + x192 * x35
    x195 = x185 * x37 + x193 + x194 * x35
    x196 = x1 * (-x190 + x195)
    x197 = x186 * x63
    x198 = x181 * x75 - x197 * x21
    x199 = x188 * x63
    x200 = x185 * x75 + x198 * x79 - x199 * x21
    x201 = x1 * (x185 - x199)
    x202 = x1 * (x181 - x197)
    x203 = x125 * x150 + x126 * x171 + x90
    x204 = x186 * x75 - x203 * x80
    x205 = x186 * x35 + x203 * x37
    x206 = x188 * x75 + x204 * x79 - x205 * x80
    x207 = x3 * (x181 - x187)
    x208 = x188 * x35 + x205 * x37 + x207
    x209 = (
        x196
        + x75 * (-x190 * x21 + x195 * x75 + x200 * x84)
        - x80 * (x189 * x75 + x206 * x84 - x208 * x80)
        + x84 * (x200 * x75 + x201 - x206 * x80 + x79 * (x198 * x75 + x202 - x204 * x80))
    )
    x210 = x14 * x163 + x209
    x211 = x15 * x163
    x212 = x131 * x63
    x213 = x1 * (x141 - x212)
    x214 = x127 * x63
    x215 = x1 * (x129 - x214)
    x216 = x129 * x75 - x21 * x214
    x217 = (
        -x148 * x80
        + x213
        + x75 * (x141 * x75 - x21 * x212 + x216 * x79)
        + x79 * (-x146 * x80 + x215 + x216 * x75)
    )
    x218 = x13 * x217
    x219 = x14 * x217
    x220 = x185 * x63
    x221 = x1 * (x194 - x220)
    x222 = x181 * x63
    x223 = x1 * (x183 - x222)
    x224 = x183 * x75 - x21 * x222
    x225 = (
        -x200 * x80
        + x221
        + x75 * (x194 * x75 - x21 * x220 + x224 * x79)
        + x79 * (-x198 * x80 + x223 + x224 * x75)
    )
    x226 = x219 + x225
    x227 = x125 * x183 + 2 * x130 + x182 * x24
    x228 = x125 * x181 + 2 * x149 + x187 * x24
    x229 = x227 * x35 + x228 * x37
    x230 = x229 * x63
    x231 = x125 * x192 + 2 * x140 + x191 * x24
    x232 = x227 * x37 + x231 * x35
    x233 = x1 * (-x230 + x232)
    x234 = x228 * x63
    x235 = x1 * (x227 - x234)
    x236 = -x21 * x234 + x227 * x75
    x237 = x125 * x186 + x126 * x203 + 2 * x170
    x238 = x228 * x75 - x237 * x80
    x239 = x228 * x35 + x237 * x37
    x240 = (
        x14 * x225
        + x233
        + x75 * (-x21 * x230 + x232 * x75 + x236 * x79)
        + x79 * (x235 + x236 * x75 - x238 * x80)
        - x80 * (x229 * x75 + x238 * x79 - x239 * x80)
    )
    x241 = x15 * x225
    x242 = x183 * x63
    x243 = x1 * (x192 - x242)
    x244 = -x224 * x80 + x243 + x75 * (x192 * x75 - x21 * x242)
    x245 = x13 * x244
    x246 = x14 * x244
    x247 = x227 * x63
    x248 = x1 * (x231 - x247)
    x249 = -x236 * x80 + x248 + x75 * (-x21 * x247 + x231 * x75)
    x250 = x246 + x249
    x251 = x125 * x227 + x126 * x228 + 3 * x184
    x252 = x251 * x63
    x253 = x125 * x231 + x126 * x227 + 3 * x193
    x254 = x1 * (-x252 + x253)
    x255 = x125 * x228 + x126 * x237 + 3 * x207
    x256 = -x23 - A[1]
    x257 = -x24 * x64 + x256 * x73
    x258 = x24 * x63
    x259 = x256 * x62 - x258 * x95
    x260 = -x100 * x24 + x256 * x72
    x261 = -x24 * x76 + x256 * x53
    x262 = -x102 * x24 + x256 * x50
    x263 = -x24 * x77 + x256 * x43
    x264 = x256 * x33 - x258 * x40
    x265 = x256 * x40 - x258 * x56
    x266 = -x104 * x24 + x256 * x38
    x267 = -x24 * x82 + x256 * x41
    x268 = (
        x260 * x75
        - x261 * x80
        + x86
        * (
            x262 * x75
            - x263 * x80
            + x84 * (x266 * x75 - x267 * x80 + x79 * (x264 * x75 - x265 * x80))
        )
    )
    x269 = x256 * x61 - x258 * x94
    x270 = x256 * x59 - x258 * x93
    x271 = x256 * x56 - x258 * x91
    x272 = x256 * x57 - x258 * x92
    x273 = -x115 * x24 + x256 * x71
    x274 = x256 * x36 - x258 * x33
    x275 = -x118 * x24 + x256 * x48
    x276 = (
        -x262 * x80
        + x273 * x75
        + x84 * (-x266 * x80 + x275 * x75 + x79 * (-x264 * x80 + x274 * x75))
    )
    x277 = x13 * x276
    x278 = x14 * x276
    x279 = -x137 * x24 + x143 * x256 + x262 * x79
    x280 = x136 * x256 - x155 * x24 + x263 * x79
    x281 = x127 * x256 - x145 * x24 + x264 * x79
    x282 = x132 * x256 - x156 * x24 + x265 * x79
    x283 = x131 * x256 - x147 * x24 + x266 * x79
    x284 = x134 * x256 - x158 * x24 + x267 * x79
    x285 = (
        x279 * x75
        - x280 * x80
        + x84 * (x283 * x75 - x284 * x80 + x79 * (x281 * x75 - x282 * x80))
    )
    x286 = x278 + x285
    x287 = -x166 * x24 + x167 * x256 + x261 * x79
    x288 = x154 * x256 - x173 * x258 + x270 * x79
    x289 = x150 * x256 - x171 * x258 + x271 * x79
    x290 = x152 * x256 - x172 * x258 + x272 * x79
    x291 = x165 * x256 - x179 * x258 + x269 * x79
    x292 = (
        x287 * x75
        - x291 * x80
        + x86
        * (
            x280 * x75
            - x288 * x80
            + x84 * (x284 * x75 - x290 * x80 + x79 * (x282 * x75 - x289 * x80))
        )
    )
    x293 = -x190 * x24 + x195 * x256 + x280 * x84
    x294 = x181 * x256 - x197 * x24 + x282 * x84
    x295 = x186 * x256 - x203 * x258 + x289 * x84
    x296 = x185 * x256 - x199 * x24 + x284 * x84
    x297 = x188 * x256 - x205 * x258 + x290 * x84
    x298 = x189 * x256 - x208 * x258 + x288 * x84
    x299 = (
        x293 * x75
        - x298 * x80
        + x84 * (x296 * x75 - x297 * x80 + x79 * (x294 * x75 - x295 * x80))
    )
    x300 = x14 * x285 + x299
    x301 = x15 * x285
    x302 = x129 * x256 - x214 * x24 + x274 * x79
    x303 = x141 * x256 - x212 * x24 + x275 * x79
    x304 = -x283 * x80 + x303 * x75 + x79 * (-x281 * x80 + x302 * x75)
    x305 = x13 * x304
    x306 = x14 * x304
    x307 = x183 * x256 - x222 * x24 + x281 * x84
    x308 = x194 * x256 - x220 * x24 + x283 * x84
    x309 = -x296 * x80 + x308 * x75 + x79 * (-x294 * x80 + x307 * x75)
    x310 = x306 + x309
    x311 = x227 * x256 - x234 * x24 + x294 * x86
    x312 = x228 * x256 - x237 * x258 + x295 * x86
    x313 = -x230 * x24 + x232 * x256 + x296 * x86
    x314 = x229 * x256 - x239 * x258 + x297 * x86
    x315 = x14 * x309 + x313 * x75 - x314 * x80 + x79 * (x311 * x75 - x312 * x80)
    x316 = x15 * x309
    x317 = x192 * x256 - x24 * x242 + x302 * x84
    x318 = -x307 * x80 + x317 * x75
    x319 = x13 * x318
    x320 = x14 * x318
    x321 = x231 * x256 - x24 * x247 + x307 * x86
    x322 = -x311 * x80 + x321 * x75
    x323 = x320 + x322
    x324 = -x24 * x252 + x253 * x256 + x311 * x88
    x325 = x251 * x256 - x255 * x258 + x312 * x88
    x326 = -x25 - A[2]
    x327 = -x26 * x64 + x326 * x73
    x328 = x26 * x63
    x329 = x326 * x62 - x328 * x95
    x330 = -x100 * x26 + x326 * x72
    x331 = -x26 * x76 + x326 * x53
    x332 = -x102 * x26 + x326 * x50
    x333 = x332 * x75
    x334 = -x26 * x77 + x326 * x43
    x335 = x334 * x80
    x336 = x326 * x33 - x328 * x40
    x337 = x336 * x75
    x338 = x326 * x40 - x328 * x56
    x339 = x338 * x80
    x340 = -x104 * x26 + x326 * x38
    x341 = x340 * x75
    x342 = -x26 * x82 + x326 * x41
    x343 = x342 * x80
    x344 = (
        x330 * x75
        - x331 * x80
        + x86 * (x333 - x335 + x84 * (x341 - x343 + x79 * (x337 - x339)))
    )
    x345 = x331 * x75
    x346 = x326 * x61 - x328 * x94
    x347 = x346 * x80
    x348 = x334 * x75
    x349 = x326 * x59 - x328 * x93
    x350 = x349 * x80
    x351 = x338 * x75
    x352 = x326 * x56 - x328 * x91
    x353 = x352 * x80
    x354 = x342 * x75
    x355 = x326 * x57 - x328 * x92
    x356 = x355 * x80
    x357 = -x115 * x26 + x326 * x71
    x358 = x326 * x36 - x328 * x33
    x359 = x358 * x75
    x360 = x336 * x80
    x361 = -x118 * x26 + x326 * x48
    x362 = x361 * x75
    x363 = x340 * x80
    x364 = -x332 * x80 + x357 * x75 + x84 * (x362 - x363 + x79 * (x359 - x360))
    x365 = -x137 * x26 + x143 * x326
    x366 = x136 * x326 - x155 * x26
    x367 = x131 * x326 - x147 * x26
    x368 = x367 * x75
    x369 = x127 * x326 - x145 * x26
    x370 = x369 * x75
    x371 = x132 * x326 - x156 * x26
    x372 = x371 * x80
    x373 = x134 * x326 - x158 * x26
    x374 = x373 * x80
    x375 = x365 * x75 - x366 * x80 + x84 * (x368 - x374 + x79 * (x370 - x372))
    x376 = x14 * x364 + x375
    x377 = -x166 * x26 + x167 * x326
    x378 = x366 * x75
    x379 = x154 * x326 - x173 * x328
    x380 = x379 * x80
    x381 = x373 * x75
    x382 = x371 * x75
    x383 = x150 * x326 - x171 * x328
    x384 = x383 * x80
    x385 = x152 * x326 - x172 * x328
    x386 = x385 * x80
    x387 = x165 * x326 - x179 * x328
    x388 = (
        x377 * x75
        - x387 * x80
        + x86 * (x378 - x380 + x84 * (x381 - x386 + x79 * (x382 - x384)))
    )
    x389 = (
        x333 * x79
        - x335 * x79
        + x84 * (x341 * x79 - x343 * x79 + x79 * (x337 * x79 - x339 * x79))
    )
    x390 = x15 * x364 + x389
    x391 = (
        x345 * x79
        - x347 * x79
        + x86
        * (
            x348 * x79
            - x350 * x79
            + x84 * (x354 * x79 - x356 * x79 + x79 * (x351 * x79 - x353 * x79))
        )
    )
    x392 = -x190 * x26 + x195 * x326
    x393 = x185 * x326 - x199 * x26
    x394 = x393 * x75
    x395 = x181 * x326 - x197 * x26
    x396 = x395 * x75
    x397 = x186 * x326 - x203 * x328
    x398 = x397 * x80
    x399 = x188 * x326 - x205 * x328
    x400 = x399 * x80
    x401 = x189 * x326 - x208 * x328
    x402 = x392 * x75 - x401 * x80 + x84 * (x394 - x400 + x79 * (x396 - x398))
    x403 = x14 * x375 + x402
    x404 = (
        x378 * x79
        - x380 * x79
        + x84 * (x381 * x79 - x386 * x79 + x79 * (x382 * x79 - x384 * x79))
    )
    x405 = x15 * x375 + x404
    x406 = 2 / x78**2
    x407 = (
        x348 * x406
        - x350 * x406
        + x84 * (x354 * x406 - x356 * x406 + x79 * (x351 * x406 - x353 * x406))
    )
    x408 = x15 * x389 + x407
    x409 = x141 * x326 - x212 * x26
    x410 = x129 * x326 - x214 * x26
    x411 = x410 * x75
    x412 = x369 * x80
    x413 = -x367 * x80 + x409 * x75 + x79 * (x411 - x412)
    x414 = x194 * x326 - x220 * x26
    x415 = x183 * x326 - x222 * x26
    x416 = x415 * x75
    x417 = x395 * x80
    x418 = -x393 * x80 + x414 * x75 + x79 * (x416 - x417)
    x419 = x14 * x413 + x418
    x420 = x368 * x79 - x374 * x79 + x79 * (x370 * x79 - x372 * x79)
    x421 = x15 * x413 + x420
    x422 = x227 * x326 - x234 * x26
    x423 = x422 * x75
    x424 = x228 * x326 - x237 * x328
    x425 = x424 * x80
    x426 = -x230 * x26 + x232 * x326
    x427 = x229 * x326 - x239 * x328
    x428 = x14 * x418 + x426 * x75 - x427 * x80 + x79 * (x423 - x425)
    x429 = x394 * x79 - x400 * x79 + x79 * (x396 * x79 - x398 * x79)
    x430 = x15 * x418 + x429
    x431 = x381 * x406 - x386 * x406 + x79 * (x382 * x406 - x384 * x406)
    x432 = x15 * x420 + x431
    x433 = x362 * x79 - x363 * x79 + x79 * (x359 * x79 - x360 * x79)
    x434 = x14 * x433 + x420
    x435 = x341 * x406 - x343 * x406 + x79 * (x337 * x406 - x339 * x406)
    x436 = x15 * x433 + x435
    x437 = x14 * x420 + x429
    x438 = 6 / x78**3
    x439 = x15 * x435 + x354 * x438 - x356 * x438 + x79 * (x351 * x438 - x353 * x438)
    x440 = x192 * x326 - x242 * x26
    x441 = -x415 * x80 + x440 * x75
    x442 = x231 * x326 - x247 * x26
    x443 = -x422 * x80 + x442 * x75
    x444 = x14 * x441 + x443
    x445 = x416 * x79 - x417 * x79
    x446 = x15 * x441 + x445
    x447 = -x252 * x26 + x253 * x326
    x448 = x251 * x326 - x255 * x328
    x449 = x423 * x79 - x425 * x79
    x450 = x396 * x406 - x398 * x406
    x451 = x15 * x445 + x450
    x452 = x411 * x79 - x412 * x79
    x453 = x14 * x452 + x445
    x454 = x370 * x406 - x372 * x406
    x455 = x15 * x452 + x454
    x456 = x15 * x454 + x382 * x438 - x384 * x438
    x457 = x359 * x406 - x360 * x406
    x458 = x14 * x457 + x454
    x459 = x337 * x438 - x339 * x438
    x460 = x15 * x457 + x459
    x461 = 24 / x78**4
    x462 = x101 + x256 * x260 - x258 * x261
    x463 = x116 + x256 * x273 - x258 * x262
    x464 = x13 * x463
    x465 = x14 * x463
    x466 = x144 + x256 * x279 - x258 * x280 + x79 * (x107 + x256 * x262 - x258 * x263)
    x467 = x465 + x466
    x468 = x168 + x256 * x287 - x258 * x291 + x79 * (x111 + x256 * x261 - x258 * x269)
    x469 = (
        x196
        + x256 * x293
        - x258 * x298
        + x84
        * (x169 + x256 * x280 - x258 * x288 + x79 * (x112 + x256 * x263 - x258 * x270))
    )
    x470 = x14 * x466 + x469
    x471 = x15 * x466
    x472 = x213 + x256 * x303 - x258 * x283 + x79 * (x120 + x256 * x275 - x258 * x266)
    x473 = x13 * x472
    x474 = x14 * x472
    x475 = (
        x221
        + x256 * x308
        - x258 * x296
        + x84
        * (x161 + x256 * x283 - x258 * x284 + x79 * (x108 + x256 * x266 - x258 * x267))
    )
    x476 = x474 + x475
    x477 = (
        x14 * x475
        + x233
        + x256 * x313
        - x258 * x314
        + x86
        * (
            x201
            + x256 * x296
            - x258 * x297
            + x84
            * (
                x177
                + x256 * x284
                - x258 * x290
                + x79 * (x113 + x256 * x267 - x258 * x272)
            )
        )
    )
    x478 = x15 * x475
    x479 = (
        x243
        + x256 * x317
        - x258 * x307
        + x84
        * (x215 + x256 * x302 - x258 * x281 + x79 * (x121 + x256 * x274 - x258 * x264))
    )
    x480 = x13 * x479
    x481 = x14 * x479
    x482 = (
        x248
        + x256 * x321
        - x258 * x311
        + x86
        * (
            x223
            + x256 * x307
            - x258 * x294
            + x84
            * (
                x162
                + x256 * x281
                - x258 * x282
                + x79 * (x109 + x256 * x264 - x258 * x265)
            )
        )
    )
    x483 = x481 + x482
    x484 = x256 * x330 - x258 * x331
    x485 = x256 * x357 - x258 * x332
    x486 = x256 * x332
    x487 = x258 * x334
    x488 = x256 * x365 - x258 * x366 + x79 * (x486 - x487)
    x489 = x14 * x485 + x488
    x490 = x256 * x331
    x491 = x258 * x346
    x492 = x256 * x377 - x258 * x387 + x79 * (x490 - x491)
    x493 = x486 * x79 - x487 * x79
    x494 = x15 * x485 + x493
    x495 = x490 * x79 - x491 * x79
    x496 = x256 * x334
    x497 = x258 * x349
    x498 = x256 * x366
    x499 = x258 * x379
    x500 = x256 * x392 - x258 * x401 + x84 * (x498 - x499 + x79 * (x496 - x497))
    x501 = x14 * x488 + x500
    x502 = x498 * x79 - x499 * x79 + x79 * (x496 * x79 - x497 * x79)
    x503 = x15 * x488 + x502
    x504 = x406 * x496 - x406 * x497
    x505 = x15 * x493 + x504
    x506 = x256 * x361
    x507 = x258 * x340
    x508 = x256 * x409 - x258 * x367 + x79 * (x506 - x507)
    x509 = x256 * x367
    x510 = x256 * x340
    x511 = x258 * x342
    x512 = x258 * x373
    x513 = x256 * x414 - x258 * x393 + x84 * (x509 - x512 + x79 * (x510 - x511))
    x514 = x14 * x508 + x513
    x515 = x509 * x79 - x512 * x79 + x79 * (x510 * x79 - x511 * x79)
    x516 = x15 * x508 + x515
    x517 = x256 * x393
    x518 = x258 * x399
    x519 = x256 * x373
    x520 = x256 * x342
    x521 = x258 * x355
    x522 = x258 * x385
    x523 = (
        x14 * x513
        + x256 * x426
        - x258 * x427
        + x86 * (x517 - x518 + x84 * (x519 - x522 + x79 * (x520 - x521)))
    )
    x524 = (
        x517 * x79
        - x518 * x79
        + x84 * (x519 * x79 - x522 * x79 + x79 * (x520 * x79 - x521 * x79))
    )
    x525 = x15 * x513 + x524
    x526 = x406 * x519 - x406 * x522 + x79 * (x406 * x520 - x406 * x521)
    x527 = x15 * x515 + x526
    x528 = x506 * x79 - x507 * x79
    x529 = x14 * x528 + x515
    x530 = x406 * x510 - x406 * x511
    x531 = x15 * x528 + x530
    x532 = x14 * x515 + x524
    x533 = x15 * x530 + x438 * x520 - x438 * x521
    x534 = x256 * x358
    x535 = x258 * x336
    x536 = x256 * x410
    x537 = x258 * x369
    x538 = x256 * x440 - x258 * x415 + x84 * (x536 - x537 + x79 * (x534 - x535))
    x539 = x256 * x415
    x540 = x258 * x395
    x541 = x256 * x336
    x542 = x258 * x338
    x543 = x256 * x369
    x544 = x258 * x371
    x545 = (
        x256 * x442
        - x258 * x422
        + x86 * (x539 - x540 + x84 * (x543 - x544 + x79 * (x541 - x542)))
    )
    x546 = x14 * x538 + x545
    x547 = (
        x539 * x79
        - x540 * x79
        + x84 * (x543 * x79 - x544 * x79 + x79 * (x541 * x79 - x542 * x79))
    )
    x548 = x15 * x538 + x547
    x549 = x256 * x422
    x550 = x258 * x424
    x551 = x256 * x395
    x552 = x258 * x397
    x553 = x256 * x338
    x554 = x258 * x352
    x555 = x256 * x371
    x556 = x258 * x383
    x557 = (
        x549 * x79
        - x550 * x79
        + x86
        * (
            x551 * x79
            - x552 * x79
            + x84 * (x555 * x79 - x556 * x79 + x79 * (x553 * x79 - x554 * x79))
        )
    )
    x558 = (
        x406 * x551
        - x406 * x552
        + x84 * (x406 * x555 - x406 * x556 + x79 * (x406 * x553 - x406 * x554))
    )
    x559 = x15 * x547 + x558
    x560 = x536 * x79 - x537 * x79 + x79 * (x534 * x79 - x535 * x79)
    x561 = x14 * x560 + x547
    x562 = x406 * x543 - x406 * x544 + x79 * (x406 * x541 - x406 * x542)
    x563 = x15 * x560 + x562
    x564 = x15 * x562 + x438 * x555 - x438 * x556 + x79 * (x438 * x553 - x438 * x554)
    x565 = x406 * x534 - x406 * x535
    x566 = x14 * x565 + x562
    x567 = x438 * x541 - x438 * x542
    x568 = x15 * x565 + x567
    x569 = x101 + x326 * x330 - x328 * x331
    x570 = x116 + x326 * x357 - x328 * x332
    x571 = x144 + x326 * x365 - x328 * x366
    x572 = x14 * x570 + x571
    x573 = x168 + x326 * x377 - x328 * x387
    x574 = x326 * x332
    x575 = x328 * x334
    x576 = x574 * x79 - x575 * x79 + x79 * (x107 + x574 - x575)
    x577 = x15 * x570 + x576
    x578 = x326 * x331
    x579 = x328 * x346
    x580 = x578 * x79 - x579 * x79 + x79 * (x111 + x578 - x579)
    x581 = x196 + x326 * x392 - x328 * x401
    x582 = x14 * x571 + x581
    x583 = x326 * x366
    x584 = x328 * x379
    x585 = x583 * x79 - x584 * x79 + x79 * (x169 + x583 - x584)
    x586 = x15 * x571 + x585
    x587 = x326 * x334
    x588 = x328 * x349
    x589 = (
        x406 * x587
        - x406 * x588
        + x84 * (x587 * x79 - x588 * x79 + x79 * (x112 + x587 - x588))
    )
    x590 = x15 * x576 + x589
    x591 = x213 + x326 * x409 - x328 * x367
    x592 = x221 + x326 * x414 - x328 * x393
    x593 = x14 * x591 + x592
    x594 = x326 * x367
    x595 = x328 * x373
    x596 = x594 * x79 - x595 * x79 + x79 * (x161 + x594 - x595)
    x597 = x15 * x591 + x596
    x598 = x14 * x592 + x233 + x326 * x426 - x328 * x427
    x599 = x326 * x393
    x600 = x328 * x399
    x601 = x599 * x79 - x600 * x79 + x79 * (x201 + x599 - x600)
    x602 = x15 * x592 + x601
    x603 = x326 * x373
    x604 = x328 * x385
    x605 = (
        x406 * x603
        - x406 * x604
        + x84 * (x603 * x79 - x604 * x79 + x79 * (x177 + x603 - x604))
    )
    x606 = x15 * x596 + x605
    x607 = x326 * x361
    x608 = x328 * x340
    x609 = x607 * x79 - x608 * x79 + x79 * (x120 + x607 - x608)
    x610 = x14 * x609 + x596
    x611 = x326 * x340
    x612 = x328 * x342
    x613 = (
        x406 * x611
        - x406 * x612
        + x84 * (x611 * x79 - x612 * x79 + x79 * (x108 + x611 - x612))
    )
    x614 = x15 * x609 + x613
    x615 = x14 * x596 + x601
    x616 = x326 * x342
    x617 = x328 * x355
    x618 = (
        x15 * x613
        + x438 * x616
        - x438 * x617
        + x86
        * (
            x406 * x616
            - x406 * x617
            + x84 * (x616 * x79 - x617 * x79 + x79 * (x113 + x616 - x617))
        )
    )
    x619 = x243 + x326 * x440 - x328 * x415
    x620 = x248 + x326 * x442 - x328 * x422
    x621 = x14 * x619 + x620
    x622 = x326 * x415
    x623 = x328 * x395
    x624 = x622 * x79 - x623 * x79 + x79 * (x223 + x622 - x623)
    x625 = x15 * x619 + x624
    x626 = x326 * x422
    x627 = x328 * x424
    x628 = x626 * x79 - x627 * x79 + x79 * (x235 + x626 - x627)
    x629 = x326 * x395
    x630 = x328 * x397
    x631 = (
        x406 * x629
        - x406 * x630
        + x84 * (x629 * x79 - x630 * x79 + x79 * (x202 + x629 - x630))
    )
    x632 = x15 * x624 + x631
    x633 = x326 * x410
    x634 = x328 * x369
    x635 = x633 * x79 - x634 * x79 + x79 * (x215 + x633 - x634)
    x636 = x14 * x635 + x624
    x637 = x326 * x369
    x638 = x328 * x371
    x639 = (
        x406 * x637
        - x406 * x638
        + x84 * (x637 * x79 - x638 * x79 + x79 * (x162 + x637 - x638))
    )
    x640 = x15 * x635 + x639
    x641 = x326 * x371
    x642 = x328 * x383
    x643 = (
        x15 * x639
        + x438 * x641
        - x438 * x642
        + x86
        * (
            x406 * x641
            - x406 * x642
            + x84 * (x641 * x79 - x642 * x79 + x79 * (x178 + x641 - x642))
        )
    )
    x644 = x326 * x358
    x645 = x328 * x336
    x646 = (
        x406 * x644
        - x406 * x645
        + x84 * (x644 * x79 - x645 * x79 + x79 * (x121 + x644 - x645))
    )
    x647 = x14 * x646 + x639
    x648 = x326 * x336
    x649 = x328 * x338
    x650 = (
        x438 * x648
        - x438 * x649
        + x86
        * (
            x406 * x648
            - x406 * x649
            + x84 * (x648 * x79 - x649 * x79 + x79 * (x109 + x648 - x649))
        )
    )
    x651 = x15 * x646 + x650
    x652 = x326 * x338
    x653 = x328 * x352

    # 216 item(s)
    S = numpy.array(
        [
            x110 * x13
            + x13 * (x110 + x123)
            + x74
            + x75 * (-x21 * x64 + x73 * x75 + x87 * x88)
            - x80 * (x62 * x75 - x80 * x95 + x88 * x99)
            + x88
            * (
                x111
                + x75 * x87
                - x80 * x99
                + x86
                * (
                    x112
                    + x75 * x85
                    - x80 * x98
                    + x84
                    * (
                        x113
                        + x75 * x83
                        + x79 * (x114 + x75 * x81 - x80 * x96)
                        - x80 * x97
                    )
                )
            ),
            x110 * x14 + x13 * x164 + x180,
            x110 * x15 + x123 * x15,
            x14 * x164 + x210,
            x124 * x15 + x211,
            x122 * x16,
            x13 * x163 + x13 * (x163 + x218) + x180,
            x13 * x226 + x210,
            x15 * x218 + x211,
            x14 * x226 + x240,
            x15 * x219 + x241,
            x16 * x217,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x225 + x13 * (x225 + x245) + x209,
            x13 * x250 + x240,
            x15 * x245 + x241,
            x14 * x249
            + x14 * x250
            + x254
            + x75 * (-x21 * x252 + x253 * x75)
            - x80 * (x251 * x75 - x255 * x80),
            x15 * x246 + x15 * x249,
            x16 * x244,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x268
            + x13 * (x268 + x277)
            + x257 * x75
            - x259 * x80
            + x88
            * (
                x261 * x75
                - x269 * x80
                + x86
                * (
                    x263 * x75
                    - x270 * x80
                    + x84 * (x267 * x75 - x272 * x80 + x79 * (x265 * x75 - x271 * x80))
                )
            ),
            x13 * x286 + x14 * x268 + x292,
            x15 * x268 + x15 * x277,
            x14 * x286 + x300,
            x15 * x278 + x301,
            x16 * x276,
            x13 * x285 + x13 * (x285 + x305) + x292,
            x13 * x310 + x300,
            x15 * x305 + x301,
            x14 * x310 + x315,
            x15 * x306 + x316,
            x16 * x304,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x309 + x13 * (x309 + x319) + x299,
            x13 * x323 + x315,
            x15 * x319 + x316,
            x14 * x322 + x14 * x323 + x324 * x75 - x325 * x80,
            x15 * x320 + x15 * x322,
            x16 * x318,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x344
            + x13 * (x13 * x364 + x344)
            + x327 * x75
            - x329 * x80
            + x88
            * (
                x345
                - x347
                + x86 * (x348 - x350 + x84 * (x354 - x356 + x79 * (x351 - x353)))
            ),
            x13 * x376 + x14 * x344 + x388,
            x13 * x390 + x15 * x344 + x391,
            x14 * x376 + x403,
            x14 * x390 + x405,
            x15 * x390 + x408,
            x13 * x375 + x13 * (x13 * x413 + x375) + x388,
            x13 * x419 + x403,
            x13 * x421 + x405,
            x14 * x419 + x428,
            x14 * x421 + x430,
            x15 * x421 + x432,
            x13 * x389 + x13 * (x13 * x433 + x389) + x391,
            x13 * x434 + x14 * x389 + x404,
            x13 * x436 + x408,
            x14 * x434 + x437,
            x14 * x436 + x432,
            x15 * x436 + x439,
            x13 * x418 + x13 * (x13 * x441 + x418) + x402,
            x13 * x444 + x428,
            x13 * x446 + x430,
            x14 * x443 + x14 * x444 + x447 * x75 - x448 * x80,
            x14 * x446 + x15 * x443 + x449,
            x15 * x446 + x451,
            x13 * x420 + x13 * (x13 * x452 + x420) + x404,
            x13 * x453 + x437,
            x13 * x455 + x432,
            x14 * x445 + x14 * x453 + x449,
            x14 * x455 + x451,
            x15 * x455 + x456,
            x13 * x435 + x13 * (x13 * x457 + x435) + x407,
            x13 * x458 + x14 * x435 + x431,
            x13 * x460 + x439,
            x14 * x454 + x14 * x458 + x450,
            x14 * x460 + x456,
            x15 * x459 + x15 * x460 + x351 * x461 - x353 * x461,
            x13 * x462 + x13 * (x462 + x464) + x256 * x257 - x258 * x259 + x74,
            x13 * x467 + x14 * x462 + x468,
            x15 * x462 + x15 * x464,
            x14 * x467 + x470,
            x15 * x465 + x471,
            x16 * x463,
            x13 * x466 + x13 * (x466 + x473) + x468,
            x13 * x476 + x470,
            x15 * x473 + x471,
            x14 * x476 + x477,
            x15 * x474 + x478,
            x16 * x472,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x475 + x13 * (x475 + x480) + x469,
            x13 * x483 + x477,
            x15 * x480 + x478,
            x14 * x482
            + x14 * x483
            + x254
            + x256 * x324
            - x258 * x325
            + x88
            * (
                x235
                + x256 * x311
                - x258 * x312
                + x86
                * (
                    x202
                    + x256 * x294
                    - x258 * x295
                    + x84
                    * (
                        x178
                        + x256 * x282
                        - x258 * x289
                        + x79 * (x114 + x256 * x265 - x258 * x271)
                    )
                )
            ),
            x15 * x481 + x15 * x482,
            x16 * x479,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            x13 * x484 + x13 * (x13 * x485 + x484) + x256 * x327 - x258 * x329,
            x13 * x489 + x14 * x484 + x492,
            x13 * x494 + x15 * x484 + x495,
            x14 * x489 + x501,
            x14 * x494 + x503,
            x15 * x494 + x505,
            x13 * x488 + x13 * (x13 * x508 + x488) + x492,
            x13 * x514 + x501,
            x13 * x516 + x503,
            x14 * x514 + x523,
            x14 * x516 + x525,
            x15 * x516 + x527,
            x13 * x493 + x13 * (x13 * x528 + x493) + x495,
            x13 * x529 + x14 * x493 + x502,
            x13 * x531 + x505,
            x14 * x529 + x532,
            x14 * x531 + x527,
            x15 * x531 + x533,
            x13 * x513 + x13 * (x13 * x538 + x513) + x500,
            x13 * x546 + x523,
            x13 * x548 + x525,
            x14 * x545
            + x14 * x546
            + x256 * x447
            - x258 * x448
            + x88
            * (
                x549
                - x550
                + x86 * (x551 - x552 + x84 * (x555 - x556 + x79 * (x553 - x554)))
            ),
            x14 * x548 + x15 * x545 + x557,
            x15 * x548 + x559,
            x13 * x515 + x13 * (x13 * x560 + x515) + x502,
            x13 * x561 + x532,
            x13 * x563 + x527,
            x14 * x547 + x14 * x561 + x557,
            x14 * x563 + x559,
            x15 * x563 + x564,
            x13 * x530 + x13 * (x13 * x565 + x530) + x504,
            x13 * x566 + x14 * x530 + x526,
            x13 * x568 + x533,
            x14 * x562 + x14 * x566 + x558,
            x14 * x568 + x564,
            x15 * x567 + x15 * x568 + x461 * x553 - x461 * x554,
            x13 * x569 + x13 * (x13 * x570 + x569) + x326 * x327 - x328 * x329 + x74,
            x13 * x572 + x14 * x569 + x573,
            x13 * x577 + x15 * x569 + x580,
            x14 * x572 + x582,
            x14 * x577 + x586,
            x15 * x577 + x590,
            x13 * x571 + x13 * (x13 * x591 + x571) + x573,
            x13 * x593 + x582,
            x13 * x597 + x586,
            x14 * x593 + x598,
            x14 * x597 + x602,
            x15 * x597 + x606,
            x13 * x576 + x13 * (x13 * x609 + x576) + x580,
            x13 * x610 + x14 * x576 + x585,
            x13 * x614 + x590,
            x14 * x610 + x615,
            x14 * x614 + x606,
            x15 * x614 + x618,
            x13 * x592 + x13 * (x13 * x619 + x592) + x581,
            x13 * x621 + x598,
            x13 * x625 + x602,
            x14 * x620 + x14 * x621 + x254 + x326 * x447 - x328 * x448,
            x14 * x625 + x15 * x620 + x628,
            x15 * x625 + x632,
            x13 * x596 + x13 * (x13 * x635 + x596) + x585,
            x13 * x636 + x615,
            x13 * x640 + x606,
            x14 * x624 + x14 * x636 + x628,
            x14 * x640 + x632,
            x15 * x640 + x643,
            x13 * x613 + x13 * (x13 * x646 + x613) + x589,
            x13 * x647 + x14 * x613 + x605,
            x13 * x651 + x618,
            x14 * x639 + x14 * x647 + x631,
            x14 * x651 + x643,
            x15 * x650
            + x15 * x651
            + x461 * x652
            - x461 * x653
            + x88
            * (
                x438 * x652
                - x438 * x653
                + x86
                * (
                    x406 * x652
                    - x406 * x653
                    + x84 * (x652 * x79 - x653 * x79 + x79 * (x114 + x652 - x653))
                )
            ),
        ]
    )
    return S


def eri_2100(a, A, b, B, c, C, d, D):
    """Cartesian [dp|ss] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (2 * a + 2 * b) ** (-1.0)
    x1 = numpy.pi**2.5
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = c + d
    x7 = x2 * x6
    x8 = x2 + x6
    x9 = (x7 + numpy.sqrt(x8)) ** (-1.0)
    x10 = A[0] - B[0]
    x11 = A[1] - B[1]
    x12 = A[2] - B[2]
    x13 = numpy.exp(-a * b * x3 * (x10**2 + x11**2 + x12**2))
    x14 = x6 ** (-1.0)
    x15 = numpy.exp(
        -c * d * x14 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x16 = x8 ** (-1.0)
    x17 = -x14 * (c * C[0] + d * D[0]) - x4
    x18 = -x3 * (a * A[1] + b * B[1])
    x19 = -x14 * (c * C[1] + d * D[1]) - x18
    x20 = -x3 * (a * A[2] + b * B[2])
    x21 = -x14 * (c * C[2] + d * D[2]) - x20
    x22 = x16 * x7 * (x17**2 + x19**2 + x21**2)
    x23 = boys(0, x22)
    x24 = x16 * x6
    x25 = x17 * x24
    x26 = boys(1, x22)
    x27 = 2 * x1 * x13 * x15 * x9
    x28 = x26 * x27
    x29 = x25 * x28
    x30 = x27 * boys(2, x22)
    x31 = -x25 * x30 + x28 * x5
    x32 = x24 * x31
    x33 = x0 * (2 * x1 * x13 * x15 * x23 * x9 - x24 * x28)
    x34 = x23 * x27
    x35 = -x17 * x32 + x33 + x5 * (-x29 + x34 * x5)
    x36 = x0 * (2 * x1 * x13 * x15 * x26 * x9 - x24 * x30)
    x37 = x27 * boys(3, x22)
    x38 = -x18 - A[1]
    x39 = x19 * x24
    x40 = x28 * x39
    x41 = x28 * x38 - x30 * x39
    x42 = x24 * x41
    x43 = x0 * (2 * x1 * x13 * x15 * x23 * x38 * x9 - x40 - x42)
    x44 = x34 * x38 - x40
    x45 = -x17 * x42 + x44 * x5
    x46 = x30 * x38 - x37 * x39
    x47 = -x25 * (-x25 * x46 + x41 * x5) + x43 + x45 * x5
    x48 = -x20 - A[2]
    x49 = x21 * x24
    x50 = x28 * x49
    x51 = x28 * x48 - x30 * x49
    x52 = x24 * x51
    x53 = x0 * (2 * x1 * x13 * x15 * x23 * x48 * x9 - x50 - x52)
    x54 = x34 * x48 - x50
    x55 = -x17 * x52 + x5 * x54
    x56 = x30 * x48 - x37 * x49
    x57 = -x25 * (-x25 * x56 + x5 * x51) + x5 * x55 + x53
    x58 = -x19 * x42 + x33 + x38 * x44
    x59 = x36 + x38 * x41 - x39 * x46
    x60 = -x25 * x59 + x5 * x58
    x61 = -x19 * x52 + x38 * x54
    x62 = x38 * x51 - x39 * x56
    x63 = -x25 * x62 + x5 * x61
    x64 = -x21 * x52 + x33 + x48 * x54
    x65 = x36 + x48 * x51 - x49 * x56
    x66 = -x25 * x65 + x5 * x64
    x67 = x38 * x61 - x39 * x62 + x53
    x68 = x38 * x64 - x39 * x65

    # 18 item(s)
    S = numpy.array(
        [
            2 * x0 * (2 * x1 * x13 * x15 * x23 * x5 * x9 - x29 - x32)
            + x10 * x35
            - x25 * (-x25 * (-x25 * x37 + x30 * x5) + x31 * x5 + x36)
            + x35 * x5,
            x11 * x35 + x47,
            x12 * x35 + x57,
            x10 * x45 + x47,
            x11 * x45 + x60,
            x12 * x45 + x63,
            x10 * x55 + x57,
            x11 * x55 + x63,
            x12 * x55 + x66,
            x10 * x58 + x60,
            x11 * x58 + x38 * x58 - x39 * x59 + 2 * x43,
            x12 * x58 + x67,
            x10 * x61 + x63,
            x11 * x61 + x67,
            x12 * x61 + x68,
            x10 * x64 + x66,
            x11 * x64 + x68,
            x12 * x64 + x48 * x64 - x49 * x65 + 2 * x53,
        ]
    )
    return S


def eri_2101(a, A, b, B, c, C, d, D):
    """Cartesian [dp|sp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = (2 * c + 2 * d + x0) ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = c + d
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = x9 * (c * C[0] + d * D[0])
    x11 = -x10 - x4
    x12 = x9 * (c * C[1] + d * D[1])
    x13 = -x3 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x3 * (a * A[2] + b * B[2])
    x16 = -x15 - x9 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x3 * (x22**2 + x23**2 + x24**2))
    x26 = C[0] - D[0]
    x27 = C[1] - D[1]
    x28 = C[2] - D[2]
    x29 = numpy.exp(-c * d * x9 * (x26**2 + x27**2 + x28**2))
    x30 = 2 * x20 * x21 * x25 * x29
    x31 = x19 * x30
    x32 = x6 * x8
    x33 = x11 * x32
    x34 = x30 * boys(3, x18)
    x35 = x31 * x5 - x33 * x34
    x36 = x10 - C[0]
    x37 = boys(1, x18)
    x38 = x30 * x37
    x39 = x2 * x8
    x40 = x11 * x39
    x41 = x31 * x40 + x36 * x38
    x42 = x31 * x36 + x34 * x40
    x43 = x32 * x42
    x44 = x1 * x35 - x11 * x43 + x41 * x5
    x45 = x32 * x44
    x46 = x31 * x33
    x47 = x38 * x5 - x46
    x48 = boys(0, x18)
    x49 = x30 * x48
    x50 = x36 * x49 + x38 * x40
    x51 = x32 * x41
    x52 = x1 * x47 - x11 * x51 + x5 * x50
    x53 = x0 ** (-1.0)
    x54 = 2 * x53
    x55 = x33 * x38
    x56 = x32 * x47
    x57 = x53 * (2 * x20 * x21 * x25 * x29 * x48 - x32 * x38)
    x58 = -x11 * x56 + x5 * (x49 * x5 - x55) + x57
    x59 = x53 * (2 * x20 * x21 * x25 * x29 * x37 - x31 * x32)
    x60 = x32 * x35
    x61 = -x11 * x60 + x47 * x5 + x59
    x62 = -x33 * x61 + x5 * x58 + x54 * (2 * x20 * x21 * x25 * x29 * x48 * x5 - x55 - x56)
    x63 = x53 * (2 * x19 * x20 * x21 * x25 * x29 - x32 * x34)
    x64 = x30 * boys(4, x18)
    x65 = -x33 * x64 + x34 * x5
    x66 = -x33 * x65 + x35 * x5 + x63
    x67 = x53 * (x50 - x51)
    x68 = x1 * x61 - x11 * x45 + x5 * x52 + x67
    x69 = x53 * (x41 - x43)
    x70 = x34 * x36 + x40 * x64
    x71 = x26 * x58 + x68
    x72 = x12 - C[1]
    x73 = x14 * x39
    x74 = x38 * x73 + x49 * x72
    x75 = x31 * x73 + x38 * x72
    x76 = x32 * x75
    x77 = x11 * x76
    x78 = x31 * x72 + x34 * x73
    x79 = x32 * x78
    x80 = -x11 * x79 + x5 * x75
    x81 = x32 * x80
    x82 = x53 * (x74 - x76)
    x83 = -x11 * x81 + x5 * (x5 * x74 - x77) + x82
    x84 = x53 * (x75 - x79)
    x85 = x34 * x72 + x64 * x73
    x86 = x27 * x58 + x83
    x87 = x28 * x58
    x88 = -x13 - A[1]
    x89 = x14 * x51
    x90 = -x14 * x43 + x41 * x88
    x91 = x32 * x90
    x92 = x53 * (x50 * x88 - x89 - x91)
    x93 = x14 * x32
    x94 = x31 * x93
    x95 = x31 * x88 - x34 * x93
    x96 = x32 * x95
    x97 = x53 * (2 * x20 * x21 * x25 * x29 * x37 * x88 - x94 - x96)
    x98 = x38 * x88 - x94
    x99 = -x11 * x96 + x5 * x98
    x100 = x34 * x88 - x64 * x93
    x101 = -x100 * x33 + x5 * x95
    x102 = x38 * x93
    x103 = x32 * x98
    x104 = x53 * (-x102 - x103 + 2 * x20 * x21 * x25 * x29 * x48 * x88)
    x105 = -x102 + x49 * x88
    x106 = -x103 * x11 + x105 * x5
    x107 = x104 + x106 * x5 - x33 * x99
    x108 = x50 * x88 - x89
    x109 = x1 * x99 + x108 * x5 - x11 * x91
    x110 = x42 * x88 - x70 * x93
    x111 = (
        x1 * (-x101 * x33 + x5 * x99 + x97)
        + x107 * x26
        + x109 * x5
        - x33 * (x1 * x101 - x110 * x33 + x5 * x90)
        + x92
    )
    x112 = x1 * x95 - x14 * x79 + x75 * x88
    x113 = x112 * x32
    x114 = x1 * x98 - x14 * x76 + x74 * x88
    x115 = x53 * (-x113 + x114)
    x116 = -x11 * x113 + x114 * x5
    x117 = x1 * x100 + x78 * x88 - x85 * x93
    x118 = x107 * x27 + x115 + x116 * x5 - x33 * (x112 * x5 - x117 * x33)
    x119 = x107 * x28
    x120 = -x15 - A[2]
    x121 = x16 * x51
    x122 = x120 * x41 - x16 * x43
    x123 = x122 * x32
    x124 = x53 * (x120 * x50 - x121 - x123)
    x125 = x16 * x32
    x126 = x125 * x31
    x127 = x120 * x31 - x125 * x34
    x128 = x127 * x32
    x129 = x53 * (2 * x120 * x20 * x21 * x25 * x29 * x37 - x126 - x128)
    x130 = x120 * x38 - x126
    x131 = x130 * x5
    x132 = x11 * x128
    x133 = x131 - x132
    x134 = x127 * x5
    x135 = x120 * x34 - x125 * x64
    x136 = x135 * x33
    x137 = x134 - x136
    x138 = x125 * x38
    x139 = x130 * x32
    x140 = x53 * (2 * x120 * x20 * x21 * x25 * x29 * x48 - x138 - x139)
    x141 = x120 * x49 - x138
    x142 = -x11 * x139 + x141 * x5
    x143 = -x133 * x33 + x140 + x142 * x5
    x144 = x120 * x50 - x121
    x145 = x1 * x133 - x11 * x123 + x144 * x5
    x146 = x120 * x42 - x125 * x70
    x147 = (
        x1 * (x129 + x133 * x5 - x137 * x33)
        + x124
        + x143 * x26
        + x145 * x5
        - x33 * (x1 * x137 + x122 * x5 - x146 * x33)
    )
    x148 = x16 * x76
    x149 = x120 * x75 - x16 * x79
    x150 = x149 * x32
    x151 = x53 * (x120 * x74 - x148 - x150)
    x152 = x120 * x74 - x148
    x153 = -x11 * x150 + x152 * x5
    x154 = x120 * x78 - x125 * x85
    x155 = x143 * x27 + x151 + x153 * x5 - x33 * (x149 * x5 - x154 * x33)
    x156 = x1 * x128
    x157 = x53 * (x1 * x130 - x156)
    x158 = x1 * x131 - x1 * x132
    x159 = x143 * x28 + x157 + x158 * x5 - x33 * (x1 * x134 - x1 * x136)
    x160 = x106 * x26 + x109
    x161 = x106 * x27 + x116
    x162 = x106 * x28
    x163 = -x14 * x96 + x59 + x88 * x98
    x164 = -x100 * x93 + x63 + x88 * x95
    x165 = -x103 * x14 + x105 * x88 + x57
    x166 = -x163 * x33 + x165 * x5
    x167 = x108 * x88 - x14 * x91 + x67
    x168 = -x110 * x93 + x69 + x88 * x90
    x169 = x1 * (x163 * x5 - x164 * x33) + x166 * x26 + x167 * x5 - x168 * x33
    x170 = x1 * x163 - x113 * x14 + x114 * x88 + x82
    x171 = x1 * x164 + x112 * x88 - x117 * x93 + x84
    x172 = x166 * x27 + x170 * x5 - x171 * x33
    x173 = x166 * x28
    x174 = -x128 * x14 + x130 * x88
    x175 = x127 * x88
    x176 = x135 * x93
    x177 = x175 - x176
    x178 = -x139 * x14 + x141 * x88
    x179 = -x174 * x33 + x178 * x5
    x180 = -x123 * x14 + x144 * x88
    x181 = x122 * x88 - x146 * x93
    x182 = x1 * (x174 * x5 - x177 * x33) + x179 * x26 + x180 * x5 - x181 * x33
    x183 = x1 * x174 - x14 * x150 + x152 * x88
    x184 = x1 * x177 + x149 * x88 - x154 * x93
    x185 = x179 * x27 + x183 * x5 - x184 * x33
    x186 = x1 * x130
    x187 = -x14 * x156 + x186 * x88
    x188 = x1 * x175 - x1 * x176
    x189 = x179 * x28 + x187 * x5 - x188 * x33
    x190 = x142 * x26 + x145
    x191 = x142 * x27 + x153
    x192 = x142 * x28 + x158
    x193 = x120 * x130 - x128 * x16 + x59
    x194 = x120 * x127
    x195 = x125 * x135
    x196 = x194 - x195 + x63
    x197 = x120 * x141 - x139 * x16 + x57
    x198 = -x193 * x33 + x197 * x5
    x199 = x120 * x144 - x123 * x16 + x67
    x200 = x120 * x122 - x125 * x146 + x69
    x201 = x1 * (x193 * x5 - x196 * x33) + x198 * x26 + x199 * x5 - x200 * x33
    x202 = x120 * x152 - x150 * x16 + x82
    x203 = x120 * x149 - x125 * x154 + x84
    x204 = x198 * x27 + x202 * x5 - x203 * x33
    x205 = x1 * x193 + x120 * x186 - x156 * x16
    x206 = x1 * x194 - x1 * x195 + x1 * x196
    x207 = x198 * x28 + x205 * x5 - x206 * x33
    x208 = x165 * x26 + x167
    x209 = x165 * x27 + x170
    x210 = x165 * x28
    x211 = 2 * x104 - x163 * x93 + x165 * x88
    x212 = x140 - x174 * x93 + x178 * x88
    x213 = x124 + x180 * x88 - x181 * x93 + x212 * x26
    x214 = (
        x1 * (x129 + x174 * x88 - x177 * x93)
        + x151
        + x183 * x88
        - x184 * x93
        + x212 * x27
    )
    x215 = x157 + x187 * x88 - x188 * x93 + x212 * x28
    x216 = x178 * x26 + x180
    x217 = x178 * x27 + x183
    x218 = x178 * x28 + x187
    x219 = -x193 * x93 + x197 * x88
    x220 = x199 * x88 - x200 * x93 + x219 * x26
    x221 = x1 * (x193 * x88 - x196 * x93) + x202 * x88 - x203 * x93 + x219 * x27
    x222 = x205 * x88 - x206 * x93 + x219 * x28
    x223 = x197 * x26 + x199
    x224 = x197 * x27 + x202
    x225 = x197 * x28 + x205
    x226 = x120 * x197 - x125 * x193 + 2 * x140

    # 54 item(s)
    S = numpy.array(
        [
            x1
            * (
                -x33 * x66
                + x5 * x61
                + x54 * (2 * x20 * x21 * x25 * x29 * x37 * x5 - x46 - x60)
            )
            + x22 * x71
            + x26 * x62
            - x33 * (x1 * x66 - x33 * (x1 * x65 - x33 * x70 + x42 * x5) + x44 * x5 + x69)
            + x5 * x68
            + x54 * (-x45 + x52),
            x22 * x86
            + x27 * x62
            - x33 * (-x33 * (-x33 * x85 + x5 * x78) + x5 * x80 + x84)
            + x5 * x83
            + x54 * (x5 * x74 - x77 - x81),
            x22 * x87 + x28 * x62,
            x111 + x23 * x71,
            x118 + x23 * x86,
            x119 + x23 * x87,
            x147 + x24 * x71,
            x155 + x24 * x86,
            x159 + x24 * x87,
            x111 + x160 * x22,
            x118 + x161 * x22,
            x119 + x162 * x22,
            x160 * x23 + x169,
            x161 * x23 + x172,
            x162 * x23 + x173,
            x160 * x24 + x182,
            x161 * x24 + x185,
            x162 * x24 + x189,
            x147 + x190 * x22,
            x155 + x191 * x22,
            x159 + x192 * x22,
            x182 + x190 * x23,
            x185 + x191 * x23,
            x189 + x192 * x23,
            x190 * x24 + x201,
            x191 * x24 + x204,
            x192 * x24 + x207,
            x169 + x208 * x22,
            x172 + x209 * x22,
            x173 + x210 * x22,
            x167 * x88 - x168 * x93 + x208 * x23 + x211 * x26 + 2 * x92,
            x1 * (x163 * x88 - x164 * x93 + 2 * x97)
            + 2 * x115
            + x170 * x88
            - x171 * x93
            + x209 * x23
            + x211 * x27,
            x210 * x23 + x211 * x28,
            x208 * x24 + x213,
            x209 * x24 + x214,
            x210 * x24 + x215,
            x182 + x216 * x22,
            x185 + x217 * x22,
            x189 + x218 * x22,
            x213 + x216 * x23,
            x214 + x217 * x23,
            x215 + x218 * x23,
            x216 * x24 + x220,
            x217 * x24 + x221,
            x218 * x24 + x222,
            x201 + x22 * x223,
            x204 + x22 * x224,
            x207 + x22 * x225,
            x220 + x223 * x23,
            x221 + x224 * x23,
            x222 + x225 * x23,
            x120 * x199 + 2 * x124 - x125 * x200 + x223 * x24 + x226 * x26,
            x120 * x202 - x125 * x203 + 2 * x151 + x224 * x24 + x226 * x27,
            x1 * (x120 * x193 - x125 * x196 + 2 * x129)
            + x120 * x205
            - x125 * x206
            + 2 * x157
            + x225 * x24
            + x226 * x28,
        ]
    )
    return S


def eri_2102(a, A, b, B, c, C, d, D):
    """Cartesian [dp|sd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = x18**2
    x20 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x19))
    x21 = x9 ** (-1.0)
    x22 = x15 * (c * C[0] + d * D[0])
    x23 = -x2 - x22
    x24 = x15 * (c * C[1] + d * D[1])
    x25 = -x1 * (a * A[1] + b * B[1])
    x26 = -x24 - x25
    x27 = -x1 * (a * A[2] + b * B[2])
    x28 = -x15 * (c * C[2] + d * D[2]) - x27
    x29 = x21 * x8 * (x23**2 + x26**2 + x28**2)
    x30 = boys(1, x29)
    x31 = -2 * x10 * x14 * x20 * x30 * x6
    x32 = x0 * x21
    x33 = boys(2, x29)
    x34 = 2 * x10 * x14 * x20 * x6
    x35 = x33 * x34
    x36 = x5 * (-x31 - x32 * x35)
    x37 = x22 - C[0]
    x38 = x30 * x34
    x39 = x23 * x32
    x40 = x35 * x39 + x37 * x38
    x41 = boys(3, x29)
    x42 = x34 * x41
    x43 = x35 * x37 + x39 * x42
    x44 = x36 + x37 * x40 + x39 * x43
    x45 = -2 * x10 * x14 * x20 * x33 * x6
    x46 = x5 * (-x32 * x42 - x45)
    x47 = x34 * boys(4, x29)
    x48 = x37 * x42 + x39 * x47
    x49 = x37 * x43 + x39 * x48 + x46
    x50 = x21 * x7
    x51 = x49 * x50
    x52 = 2 * a + 2 * b
    x53 = x4 + x52
    x54 = x53 ** (-1.0)
    x55 = x23 * x50
    x56 = x3 * x42 - x47 * x55
    x57 = x48 * x50
    x58 = -x23 * x57 + x3 * x43 + x54 * x56
    x59 = 2 * x54
    x60 = -x23 * x51 + x3 * x44 + x58 * x59
    x61 = x50 * x60
    x62 = boys(0, x29)
    x63 = -2 * x10 * x14 * x20 * x6 * x62
    x64 = x5 * (-x32 * x38 - x63)
    x65 = x34 * x62
    x66 = x37 * x65 + x38 * x39
    x67 = x37 * x66 + x39 * x40 + x64
    x68 = x44 * x50
    x69 = x42 * x55
    x70 = x3 * x35 - x69
    x71 = x43 * x50
    x72 = -x23 * x71 + x3 * x40 + x54 * x70
    x73 = -x23 * x68 + x3 * x67 + x59 * x72
    x74 = x52 ** (-1.0)
    x75 = 2 * x74
    x76 = x74 * (x67 - x68)
    x77 = x74 * (x40 - x71)
    x78 = x74 * (-x42 * x50 - x45)
    x79 = x50 * x56
    x80 = -x23 * x79 + x3 * x70 + x78
    x81 = x50 * x58
    x82 = -x23 * x81 + x3 * x72 + x54 * x80 + x77
    x83 = -x23 * x61 + x3 * x73 + x59 * x82 + x76
    x84 = x74 * (x44 - x51)
    x85 = -2 * x10 * x14 * x20 * x41 * x6
    x86 = x5 * (-x32 * x47 - x85)
    x87 = x34 * boys(5, x29)
    x88 = x37 * x47 + x39 * x87
    x89 = x37 * x48 + x39 * x88 + x86
    x90 = x3 * x47 - x55 * x87
    x91 = x3 * x48 + x54 * x90 - x55 * x88
    x92 = x74 * (x43 - x57)
    x93 = x74 * (-x47 * x50 - x85)
    x94 = x3 * x56 - x55 * x90 + x93
    x95 = x3 * x58 + x54 * x94 - x55 * x91 + x92
    x96 = x50 * x72
    x97 = x35 * x55
    x98 = x3 * x38 - x97
    x99 = x40 * x50
    x100 = -x23 * x99 + x3 * x66 + x54 * x98
    x101 = x50 * x70
    x102 = x74 * (-x31 - x35 * x50)
    x103 = -x101 * x23 + x102 + x3 * x98
    x104 = x74 * (x66 - x99)
    x105 = x100 * x3 + x103 * x54 + x104 - x23 * x96
    x106 = (
        x105 * x3
        + x54
        * (
            x103 * x3
            - x55 * x80
            + x75 * (2 * x10 * x14 * x20 * x3 * x30 * x6 - x101 - x97)
        )
        - x55 * x82
        + x75 * (x100 - x96)
    )
    x107 = x38 * x55
    x108 = x50 * x98
    x109 = x74 * (-x38 * x50 - x63)
    x110 = -x108 * x23 + x109 + x3 * (-x107 + x3 * x65)
    x111 = (
        -x103 * x55
        + x110 * x3
        + x75 * (2 * x10 * x14 * x20 * x3 * x6 * x62 - x107 - x108)
    )
    x112 = x111 * x16
    x113 = x110 * x16
    x114 = x105 * x16 + x16 * (x105 + x113) + x83
    x115 = x24 - C[1]
    x116 = x26 * x32
    x117 = x115 * x35 + x116 * x42
    x118 = x115 * x42 + x116 * x47
    x119 = x118 * x50
    x120 = x117 * x3 - x119 * x23
    x121 = x115 * x38 + x116 * x35
    x122 = x117 * x39 + x121 * x37
    x123 = x117 * x37 + x118 * x39
    x124 = x123 * x50
    x125 = x120 * x54 + x122 * x3 - x124 * x23
    x126 = x125 * x50
    x127 = x117 * x50
    x128 = x127 * x23
    x129 = x121 * x3 - x128
    x130 = x115 * x65 + x116 * x38
    x131 = x121 * x39 + x130 * x37
    x132 = x122 * x50
    x133 = x129 * x54 + x131 * x3 - x132 * x23
    x134 = x120 * x50
    x135 = x74 * (x121 - x127)
    x136 = x129 * x3 - x134 * x23 + x135
    x137 = x74 * (x117 - x119)
    x138 = x115 * x47 + x116 * x87
    x139 = x118 * x3 - x138 * x55
    x140 = x120 * x3 + x137 - x139 * x55
    x141 = x74 * (x131 - x132)
    x142 = -x126 * x23 + x133 * x3 + x136 * x54 + x141
    x143 = x74 * (x122 - x124)
    x144 = x118 * x37 + x138 * x39
    x145 = x111 * x17
    x146 = x121 * x50
    x147 = x146 * x23
    x148 = x129 * x50
    x149 = x74 * (x130 - x146)
    x150 = -x148 * x23 + x149 + x3 * (x130 * x3 - x147)
    x151 = -x136 * x55 + x150 * x3 + x75 * (x130 * x3 - x147 - x148)
    x152 = x145 + x151
    x153 = x110 * x17
    x154 = x150 + x153
    x155 = x105 * x17 + x142 + x154 * x16
    x156 = x105 * x18 + x113 * x18
    x157 = x115 * x130 + x116 * x121 + x64
    x158 = x115 * x121 + x116 * x117 + x36
    x159 = x158 * x50
    x160 = x159 * x23
    x161 = x115 * x117 + x116 * x118 + x46
    x162 = x161 * x50
    x163 = x158 * x3 - x162 * x23
    x164 = x163 * x50
    x165 = x74 * (x157 - x159)
    x166 = -x164 * x23 + x165 + x3 * (x157 * x3 - x160)
    x167 = x74 * (x158 - x162)
    x168 = x115 * x118 + x116 * x138 + x86
    x169 = x150 * x17 + x154 * x17 + x166
    x170 = x150 * x18 + x153 * x18
    x171 = x110 * x19
    x172 = -x25 - A[1]
    x173 = x26 * x68
    x174 = x172 * x44 - x26 * x51
    x175 = x174 * x50
    x176 = x74 * (x172 * x67 - x173 - x175)
    x177 = x26 * x99
    x178 = x26 * x71
    x179 = x172 * x40 - x178
    x180 = x179 * x50
    x181 = x74 * (x172 * x66 - x177 - x180)
    x182 = x26 * x50
    x183 = x182 * x35
    x184 = x182 * x42
    x185 = x172 * x35 - x184
    x186 = x185 * x50
    x187 = x74 * (2 * x10 * x14 * x172 * x20 * x30 * x6 - x183 - x186)
    x188 = x172 * x38 - x183
    x189 = -x186 * x23 + x188 * x3
    x190 = x172 * x42 - x182 * x47
    x191 = x190 * x50
    x192 = x185 * x3 - x191 * x23
    x193 = x172 * x66 - x177
    x194 = -x180 * x23 + x189 * x54 + x193 * x3
    x195 = x172 * x43 - x26 * x57
    x196 = x195 * x50
    x197 = x179 * x3 + x192 * x54 - x196 * x23
    x198 = x181 + x194 * x3 - x197 * x55 + x54 * (x187 + x189 * x3 - x192 * x55)
    x199 = x182 * x38
    x200 = x188 * x50
    x201 = x74 * (2 * x10 * x14 * x172 * x20 * x6 * x62 - x199 - x200)
    x202 = x172 * x65 - x199
    x203 = -x200 * x23 + x202 * x3
    x204 = -x189 * x55 + x201 + x203 * x3
    x205 = x16 * x204
    x206 = x172 * x67 - x173
    x207 = -x175 * x23 + x197 * x59 + x206 * x3
    x208 = x74 * (x172 * x40 - x178 - x196)
    x209 = x74 * (2 * x10 * x14 * x172 * x20 * x33 * x6 - x184 - x191)
    x210 = x172 * x47 - x182 * x87
    x211 = x190 * x3 - x210 * x55
    x212 = x172 * x48 - x182 * x88
    x213 = x195 * x3 + x211 * x54 - x212 * x55
    x214 = x172 * x49 - x182 * x89
    x215 = (
        x16 * x198
        + x16 * (x198 + x205)
        + x176
        + x207 * x3
        - x55 * (x174 * x3 + x213 * x59 - x214 * x55)
        + x59 * (x197 * x3 + x208 - x213 * x55 + x54 * (x192 * x3 + x209 - x211 * x55))
    )
    x216 = x122 * x172 - x124 * x26 + x195 * x54
    x217 = x216 * x50
    x218 = x131 * x172 - x132 * x26 + x179 * x54
    x219 = x74 * (-x217 + x218)
    x220 = x117 * x172 - x119 * x26 + x190 * x54
    x221 = x220 * x50
    x222 = x121 * x172 - x127 * x26 + x185 * x54
    x223 = x74 * (-x221 + x222)
    x224 = -x221 * x23 + x222 * x3
    x225 = x118 * x172 - x138 * x182 + x210 * x54
    x226 = x220 * x3 - x225 * x55
    x227 = x17 * x204
    x228 = x222 * x50
    x229 = x130 * x172 - x146 * x26 + x188 * x54
    x230 = x74 * (-x228 + x229)
    x231 = -x228 * x23 + x229 * x3
    x232 = -x224 * x55 + x230 + x231 * x3
    x233 = x227 + x232
    x234 = -x217 * x23 + x218 * x3 + x224 * x54
    x235 = x123 * x172 - x144 * x182 + x212 * x54
    x236 = (
        x16 * x233
        + x17 * x198
        + x219
        + x234 * x3
        + x54 * (x223 + x224 * x3 - x226 * x55)
        - x55 * (x216 * x3 + x226 * x54 - x235 * x55)
    )
    x237 = x18 * x198 + x18 * x205
    x238 = x158 * x172 - x162 * x26 + x220 * x59
    x239 = x238 * x50
    x240 = x157 * x172 - x159 * x26 + x222 * x59
    x241 = x74 * (-x239 + x240)
    x242 = -x23 * x239 + x240 * x3
    x243 = x161 * x172 - x168 * x182 + x225 * x59
    x244 = x17 * x232 + x17 * x233 + x241 + x242 * x3 - x55 * (x238 * x3 - x243 * x55)
    x245 = x18 * x227 + x18 * x232
    x246 = x19 * x204
    x247 = -x27 - A[2]
    x248 = x28 * x68
    x249 = x247 * x44 - x28 * x51
    x250 = x249 * x50
    x251 = x74 * (x247 * x67 - x248 - x250)
    x252 = x28 * x99
    x253 = x28 * x71
    x254 = x247 * x40 - x253
    x255 = x254 * x50
    x256 = x74 * (x247 * x66 - x252 - x255)
    x257 = x28 * x50
    x258 = x257 * x35
    x259 = x257 * x42
    x260 = x247 * x35 - x259
    x261 = x260 * x50
    x262 = x74 * (2 * x10 * x14 * x20 * x247 * x30 * x6 - x258 - x261)
    x263 = x247 * x38 - x258
    x264 = x263 * x3
    x265 = -x23 * x261 + x264
    x266 = x260 * x3
    x267 = x247 * x42 - x257 * x47
    x268 = x267 * x50
    x269 = x23 * x268
    x270 = x266 - x269
    x271 = x247 * x66 - x252
    x272 = -x23 * x255 + x265 * x54 + x271 * x3
    x273 = x254 * x3
    x274 = x247 * x43 - x28 * x57
    x275 = x274 * x50
    x276 = x23 * x275
    x277 = x270 * x54 + x273 - x276
    x278 = x256 + x272 * x3 - x277 * x55 + x54 * (x262 + x265 * x3 - x270 * x55)
    x279 = x257 * x38
    x280 = x263 * x50
    x281 = x74 * (2 * x10 * x14 * x20 * x247 * x6 * x62 - x279 - x280)
    x282 = x247 * x65 - x279
    x283 = -x23 * x280 + x282 * x3
    x284 = -x265 * x55 + x281 + x283 * x3
    x285 = x247 * x67 - x248
    x286 = -x23 * x250 + x277 * x59 + x285 * x3
    x287 = x74 * (x247 * x40 - x253 - x275)
    x288 = x74 * (2 * x10 * x14 * x20 * x247 * x33 * x6 - x259 - x268)
    x289 = x267 * x3
    x290 = x247 * x47 - x257 * x87
    x291 = x290 * x55
    x292 = x289 - x291
    x293 = x274 * x3
    x294 = x247 * x48 - x257 * x88
    x295 = x294 * x55
    x296 = x292 * x54 + x293 - x295
    x297 = x247 * x49 - x257 * x89
    x298 = (
        x16 * x278
        + x16 * (x16 * x284 + x278)
        + x251
        + x286 * x3
        - x55 * (x249 * x3 + x296 * x59 - x297 * x55)
        + x59 * (x277 * x3 + x287 - x296 * x55 + x54 * (x270 * x3 + x288 - x292 * x55))
    )
    x299 = x132 * x28
    x300 = x122 * x247 - x124 * x28
    x301 = x300 * x50
    x302 = x74 * (x131 * x247 - x299 - x301)
    x303 = x127 * x28
    x304 = x117 * x247 - x119 * x28
    x305 = x304 * x50
    x306 = x74 * (x121 * x247 - x303 - x305)
    x307 = x121 * x247 - x303
    x308 = x3 * x307
    x309 = x23 * x305
    x310 = x308 - x309
    x311 = x3 * x304
    x312 = x118 * x247 - x138 * x257
    x313 = x312 * x55
    x314 = x311 - x313
    x315 = x146 * x28
    x316 = x307 * x50
    x317 = x74 * (x130 * x247 - x315 - x316)
    x318 = x130 * x247 - x315
    x319 = -x23 * x316 + x3 * x318
    x320 = x3 * x319 - x310 * x55 + x317
    x321 = x17 * x284 + x320
    x322 = x131 * x247 - x299
    x323 = -x23 * x301 + x3 * x322 + x310 * x54
    x324 = x123 * x247 - x144 * x257
    x325 = (
        x16 * x321
        + x17 * x278
        + x3 * x323
        + x302
        + x54 * (x3 * x310 + x306 - x314 * x55)
        - x55 * (x3 * x300 + x314 * x54 - x324 * x55)
    )
    x326 = x275 * x54
    x327 = x74 * (x254 * x54 - x326)
    x328 = x268 * x54
    x329 = x74 * (x260 * x54 - x328)
    x330 = x266 * x54 - x269 * x54
    x331 = x289 * x54 - x291 * x54
    x332 = x260 * x54
    x333 = x74 * (x263 * x54 - x332 * x50)
    x334 = x264 * x54 - x332 * x55
    x335 = x3 * x334 - x330 * x55 + x333
    x336 = x18 * x284 + x335
    x337 = x273 * x54 - x276 * x54 + x330 * x54
    x338 = (
        x16 * x336
        + x18 * x278
        + x3 * x337
        + x327
        + x54 * (x3 * x330 + x329 - x331 * x55)
        - x55 * (x293 * x54 - x295 * x54 + x331 * x54)
    )
    x339 = x159 * x28
    x340 = x158 * x247 - x162 * x28
    x341 = x340 * x50
    x342 = x74 * (x157 * x247 - x339 - x341)
    x343 = x157 * x247 - x339
    x344 = -x23 * x341 + x3 * x343
    x345 = x161 * x247 - x168 * x257
    x346 = x17 * x320 + x17 * x321 + x3 * x344 + x342 - x55 * (x3 * x340 - x345 * x55)
    x347 = x305 * x54
    x348 = x74 * (x307 * x54 - x347)
    x349 = x308 * x54 - x309 * x54
    x350 = x17 * x336 + x18 * x320 + x3 * x349 + x348 - x55 * (x311 * x54 - x313 * x54)
    x351 = x53 ** (-2.0)
    x352 = 2 * x351
    x353 = x74 * (2 * x260 * x351 - x268 * x352)
    x354 = x266 * x352 - x269 * x352
    x355 = x18 * x335 + x18 * x336 + x3 * x354 + x353 - x55 * (x289 * x352 - x291 * x352)
    x356 = x16 * x203
    x357 = x16 * x194 + x16 * (x194 + x356) + x207
    x358 = x17 * x203
    x359 = x231 + x358
    x360 = x16 * x359 + x17 * x194 + x234
    x361 = x18 * x194 + x18 * x356
    x362 = x17 * x231 + x17 * x359 + x242
    x363 = x18 * x231 + x18 * x358
    x364 = x19 * x203
    x365 = x102 + x172 * x188 - x186 * x26
    x366 = x172 * x185 - x191 * x26 + x78
    x367 = x104 + x172 * x193 - x180 * x26
    x368 = x172 * x179 - x196 * x26 + x77
    x369 = x3 * x367 - x368 * x55 + x54 * (x3 * x365 - x366 * x55)
    x370 = x109 + x172 * x202 - x200 * x26
    x371 = x3 * x370 - x365 * x55
    x372 = x16 * x371
    x373 = x172 * x206 - x175 * x26 + x76
    x374 = x172 * x190 - x182 * x210 + x93
    x375 = x172 * x195 - x182 * x212 + x92
    x376 = x172 * x174 - x182 * x214 + x84
    x377 = (
        x16 * x369
        + x16 * (x369 + x372)
        + x3 * x373
        - x376 * x55
        + x59 * (x3 * x368 - x375 * x55 + x54 * (x3 * x366 - x374 * x55))
    )
    x378 = x135 + x172 * x222 - x221 * x26 + x366 * x54
    x379 = x137 + x172 * x220 - x182 * x225 + x374 * x54
    x380 = x17 * x371
    x381 = x149 + x172 * x229 - x228 * x26 + x365 * x54
    x382 = x3 * x381 - x378 * x55
    x383 = x380 + x382
    x384 = x141 + x172 * x218 - x217 * x26 + x368 * x54
    x385 = x143 + x172 * x216 - x182 * x235 + x375 * x54
    x386 = (
        x16 * x383 + x17 * x369 + x3 * x384 - x385 * x55 + x54 * (x3 * x378 - x379 * x55)
    )
    x387 = x18 * x369 + x18 * x372
    x388 = x165 + x172 * x240 - x239 * x26 + x378 * x59
    x389 = x167 + x172 * x238 - x182 * x243 + x379 * x59
    x390 = x17 * x382 + x17 * x383 + x3 * x388 - x389 * x55
    x391 = x18 * x380 + x18 * x382
    x392 = x19 * x371
    x393 = x172 * x263 - x26 * x261
    x394 = x172 * x260
    x395 = x26 * x268
    x396 = x394 - x395
    x397 = x172 * x271 - x255 * x26
    x398 = x172 * x254 - x26 * x275
    x399 = x3 * x397 - x398 * x55 + x54 * (x3 * x393 - x396 * x55)
    x400 = x172 * x282 - x26 * x280
    x401 = x3 * x400 - x393 * x55
    x402 = x172 * x285 - x250 * x26
    x403 = x172 * x267
    x404 = x182 * x290
    x405 = x403 - x404
    x406 = x172 * x274
    x407 = x182 * x294
    x408 = x406 - x407
    x409 = x172 * x249 - x182 * x297
    x410 = (
        x16 * x399
        + x16 * (x16 * x401 + x399)
        + x3 * x402
        - x409 * x55
        + x59 * (x3 * x398 - x408 * x55 + x54 * (x3 * x396 - x405 * x55))
    )
    x411 = x172 * x307 - x26 * x305 + x396 * x54
    x412 = x172 * x304
    x413 = x182 * x312
    x414 = x405 * x54 + x412 - x413
    x415 = x172 * x318 - x26 * x316 + x393 * x54
    x416 = x3 * x415 - x411 * x55
    x417 = x17 * x401 + x416
    x418 = x172 * x322 - x26 * x301 + x398 * x54
    x419 = x172 * x300 - x182 * x324 + x408 * x54
    x420 = (
        x16 * x417 + x17 * x399 + x3 * x418 - x419 * x55 + x54 * (x3 * x411 - x414 * x55)
    )
    x421 = x172 * x332 - x26 * x328
    x422 = x403 * x54 - x404 * x54
    x423 = x263 * x54
    x424 = x172 * x423 - x182 * x332
    x425 = x3 * x424 - x421 * x55
    x426 = x18 * x401 + x425
    x427 = x254 * x54
    x428 = x172 * x427 - x26 * x326
    x429 = x406 * x54 - x407 * x54
    x430 = (
        x16 * x426 + x18 * x399 + x3 * x428 - x429 * x55 + x54 * (x3 * x421 - x422 * x55)
    )
    x431 = x172 * x343 - x26 * x341 + x411 * x59
    x432 = x172 * x340 - x182 * x345 + x414 * x59
    x433 = x17 * x416 + x17 * x417 + x3 * x431 - x432 * x55
    x434 = x307 * x54
    x435 = x172 * x434 - x26 * x347 + x421 * x54
    x436 = x412 * x54 - x413 * x54 + x422 * x54
    x437 = x17 * x426 + x18 * x416 + x3 * x435 - x436 * x55
    x438 = x352 * x394 - x352 * x395
    x439 = x352 * x403 - x352 * x404
    x440 = x18 * x425 + x18 * x426 + x3 * x438 - x439 * x55
    x441 = x16 * x272 + x16 * (x16 * x283 + x272) + x286
    x442 = x17 * x283 + x319
    x443 = x16 * x442 + x17 * x272 + x323
    x444 = x18 * x283 + x334
    x445 = x16 * x444 + x18 * x272 + x337
    x446 = x17 * x319 + x17 * x442 + x344
    x447 = x17 * x444 + x18 * x319 + x349
    x448 = x18 * x334 + x18 * x444 + x354
    x449 = x102 + x247 * x263 - x261 * x28
    x450 = x247 * x260
    x451 = x268 * x28
    x452 = x450 - x451 + x78
    x453 = x104 + x247 * x271 - x255 * x28
    x454 = x247 * x254 - x275 * x28 + x77
    x455 = x3 * x453 - x454 * x55 + x54 * (x3 * x449 - x452 * x55)
    x456 = x109 + x247 * x282 - x28 * x280
    x457 = x3 * x456 - x449 * x55
    x458 = x247 * x285 - x250 * x28 + x76
    x459 = x247 * x267
    x460 = x257 * x290
    x461 = x459 - x460 + x93
    x462 = x247 * x274
    x463 = x257 * x294
    x464 = x462 - x463 + x92
    x465 = x247 * x249 - x257 * x297 + x84
    x466 = (
        x16 * x455
        + x16 * (x16 * x457 + x455)
        + x3 * x458
        - x465 * x55
        + x59 * (x3 * x454 - x464 * x55 + x54 * (x3 * x452 - x461 * x55))
    )
    x467 = x135 + x247 * x307 - x28 * x305
    x468 = x247 * x304
    x469 = x257 * x312
    x470 = x137 + x468 - x469
    x471 = x149 + x247 * x318 - x28 * x316
    x472 = x3 * x471 - x467 * x55
    x473 = x17 * x457 + x472
    x474 = x141 + x247 * x322 - x28 * x301
    x475 = x143 + x247 * x300 - x257 * x324
    x476 = (
        x16 * x473 + x17 * x455 + x3 * x474 - x475 * x55 + x54 * (x3 * x467 - x470 * x55)
    )
    x477 = x247 * x332 - x28 * x328 + x452 * x54
    x478 = x459 * x54 - x460 * x54 + x461 * x54
    x479 = x247 * x423 - x257 * x332 + x449 * x54
    x480 = x3 * x479 - x477 * x55
    x481 = x18 * x457 + x480
    x482 = x247 * x427 - x28 * x326 + x454 * x54
    x483 = x462 * x54 - x463 * x54 + x464 * x54
    x484 = (
        x16 * x481 + x18 * x455 + x3 * x482 - x483 * x55 + x54 * (x3 * x477 - x478 * x55)
    )
    x485 = x165 + x247 * x343 - x28 * x341
    x486 = x167 + x247 * x340 - x257 * x345
    x487 = x17 * x472 + x17 * x473 + x3 * x485 - x486 * x55
    x488 = x247 * x434 - x28 * x347 + x467 * x54
    x489 = x468 * x54 - x469 * x54 + x470 * x54
    x490 = x17 * x481 + x18 * x472 + x3 * x488 - x489 * x55
    x491 = x352 * x450 - x352 * x451 + x477 * x59
    x492 = x352 * x459 - x352 * x460 + x478 * x59
    x493 = x18 * x480 + x18 * x481 + x3 * x491 - x492 * x55
    x494 = x16 * x370
    x495 = x16 * x367 + x16 * (x367 + x494) + x373
    x496 = x17 * x370
    x497 = x381 + x496
    x498 = x16 * x497 + x17 * x367 + x384
    x499 = x18 * x367 + x18 * x494
    x500 = x17 * x381 + x17 * x497 + x388
    x501 = x18 * x381 + x18 * x496
    x502 = x19 * x370
    x503 = x172 * x367 + 2 * x181 - x182 * x368
    x504 = x172 * x370 - x182 * x365 + 2 * x201
    x505 = x16 * x504
    x506 = x17 * x504
    x507 = (
        x172 * x381
        - x182 * x378
        + 2 * x230
        + x54 * (x172 * x365 - x182 * x366 + 2 * x187)
    )
    x508 = x506 + x507
    x509 = x172 * x397 - x182 * x398 + x256
    x510 = x172 * x400 - x182 * x393 + x281
    x511 = x16 * x509 + x16 * (x16 * x510 + x509) + x172 * x402 - x182 * x409 + x251
    x512 = x172 * x415 - x182 * x411 + x317 + x54 * (x172 * x393 - x182 * x396 + x262)
    x513 = x17 * x510 + x512
    x514 = (
        x16 * x513
        + x17 * x509
        + x172 * x418
        - x182 * x419
        + x302
        + x54 * (x172 * x398 - x182 * x408 + x287)
    )
    x515 = x172 * x424 - x182 * x421 + x333
    x516 = x18 * x510 + x515
    x517 = x16 * x516 + x172 * x428 + x18 * x509 - x182 * x429 + x327
    x518 = (
        x17 * x512
        + x17 * x513
        + x172 * x431
        - x182 * x432
        + x342
        + x59
        * (x172 * x411 - x182 * x414 + x306 + x54 * (x172 * x396 - x182 * x405 + x288))
    )
    x519 = (
        x17 * x516
        + x172 * x435
        + x18 * x512
        - x182 * x436
        + x348
        + x54 * (x172 * x421 - x182 * x422 + x329)
    )
    x520 = x172 * x438 + x18 * x515 + x18 * x516 - x182 * x439 + x353
    x521 = x16 * x397 + x16 * (x16 * x400 + x397) + x402
    x522 = x17 * x400 + x415
    x523 = x16 * x522 + x17 * x397 + x418
    x524 = x18 * x400 + x424
    x525 = x16 * x524 + x18 * x397 + x428
    x526 = x17 * x415 + x17 * x522 + x431
    x527 = x17 * x524 + x18 * x415 + x435
    x528 = x18 * x424 + x18 * x524 + x438
    x529 = x172 * x453 - x182 * x454
    x530 = x172 * x456 - x182 * x449
    x531 = x16 * x529 + x16 * (x16 * x530 + x529) + x172 * x458 - x182 * x465
    x532 = x172 * x471 - x182 * x467 + x54 * (x172 * x449 - x182 * x452)
    x533 = x17 * x530 + x532
    x534 = (
        x16 * x533
        + x17 * x529
        + x172 * x474
        - x182 * x475
        + x54 * (x172 * x454 - x182 * x464)
    )
    x535 = x172 * x479 - x182 * x477
    x536 = x18 * x530 + x535
    x537 = x16 * x536 + x172 * x482 + x18 * x529 - x182 * x483
    x538 = (
        x17 * x532
        + x17 * x533
        + x172 * x485
        - x182 * x486
        + x59 * (x172 * x467 - x182 * x470 + x54 * (x172 * x452 - x182 * x461))
    )
    x539 = (
        x17 * x536
        + x172 * x488
        + x18 * x532
        - x182 * x489
        + x54 * (x172 * x477 - x182 * x478)
    )
    x540 = x172 * x491 + x18 * x535 + x18 * x536 - x182 * x492
    x541 = x16 * x453 + x16 * (x16 * x456 + x453) + x458
    x542 = x17 * x456 + x471
    x543 = x16 * x542 + x17 * x453 + x474
    x544 = x18 * x456 + x479
    x545 = x16 * x544 + x18 * x453 + x482
    x546 = x17 * x471 + x17 * x542 + x485
    x547 = x17 * x544 + x18 * x471 + x488
    x548 = x18 * x479 + x18 * x544 + x491
    x549 = x247 * x453 + 2 * x256 - x257 * x454
    x550 = x247 * x456 - x257 * x449 + 2 * x281
    x551 = x247 * x471 - x257 * x467 + 2 * x317
    x552 = x17 * x550 + x551
    x553 = (
        x247 * x479
        - x257 * x477
        + 2 * x333
        + x54 * (x247 * x449 - x257 * x452 + 2 * x262)
    )
    x554 = x18 * x550 + x553

    # 108 item(s)
    S = numpy.array(
        [
            x106 * x16
            + x11 * x114
            + x16 * (x106 + x112)
            + x3 * x83
            - x55
            * (x3 * x60 - x55 * (x3 * x49 - x55 * x89 + x59 * x91) + x59 * x95 + x84)
            + x59
            * (
                x3 * x82
                + x54
                * (
                    x3 * x80
                    - x55 * x94
                    + x75 * (2 * x10 * x14 * x20 * x3 * x33 * x6 - x69 - x79)
                )
                - x55 * x95
                + x75 * (x72 - x81)
            )
            + x75 * (-x61 + x73),
            x106 * x17
            + x11 * x155
            + x142 * x3
            + x152 * x16
            + x54 * (x136 * x3 - x140 * x55 + x75 * (x121 * x3 - x128 - x134))
            - x55
            * (
                x125 * x3
                + x140 * x54
                + x143
                - x55 * (x123 * x3 + x139 * x54 - x144 * x55)
            )
            + x75 * (-x126 + x133),
            x106 * x18 + x11 * x156 + x112 * x18,
            x11 * x169
            + x151 * x17
            + x152 * x17
            + x166 * x3
            - x55 * (x163 * x3 + x167 - x55 * (x161 * x3 - x168 * x55))
            + x75 * (x157 * x3 - x160 - x164),
            x11 * x170 + x145 * x18 + x151 * x18,
            x11 * x171 + x111 * x19,
            x114 * x12 + x215,
            x12 * x155 + x236,
            x12 * x156 + x237,
            x12 * x169 + x244,
            x12 * x170 + x245,
            x12 * x171 + x246,
            x114 * x13 + x298,
            x13 * x155 + x325,
            x13 * x156 + x338,
            x13 * x169 + x346,
            x13 * x170 + x350,
            x13 * x171 + x355,
            x11 * x357 + x215,
            x11 * x360 + x236,
            x11 * x361 + x237,
            x11 * x362 + x244,
            x11 * x363 + x245,
            x11 * x364 + x246,
            x12 * x357 + x377,
            x12 * x360 + x386,
            x12 * x361 + x387,
            x12 * x362 + x390,
            x12 * x363 + x391,
            x12 * x364 + x392,
            x13 * x357 + x410,
            x13 * x360 + x420,
            x13 * x361 + x430,
            x13 * x362 + x433,
            x13 * x363 + x437,
            x13 * x364 + x440,
            x11 * x441 + x298,
            x11 * x443 + x325,
            x11 * x445 + x338,
            x11 * x446 + x346,
            x11 * x447 + x350,
            x11 * x448 + x355,
            x12 * x441 + x410,
            x12 * x443 + x420,
            x12 * x445 + x430,
            x12 * x446 + x433,
            x12 * x447 + x437,
            x12 * x448 + x440,
            x13 * x441 + x466,
            x13 * x443 + x476,
            x13 * x445 + x484,
            x13 * x446 + x487,
            x13 * x447 + x490,
            x13 * x448 + x493,
            x11 * x495 + x377,
            x11 * x498 + x386,
            x11 * x499 + x387,
            x11 * x500 + x390,
            x11 * x501 + x391,
            x11 * x502 + x392,
            x12 * x495
            + x16 * x503
            + x16 * (x503 + x505)
            + x172 * x373
            + 2 * x176
            - x182 * x376,
            x12 * x498
            + x16 * x508
            + x17 * x503
            + x172 * x384
            - x182 * x385
            + 2 * x219
            + x54 * (x172 * x368 - x182 * x375 + 2 * x208),
            x12 * x499 + x18 * x503 + x18 * x505,
            x12 * x500
            + x17 * x507
            + x17 * x508
            + x172 * x388
            - x182 * x389
            + 2 * x241
            + x59
            * (
                x172 * x378
                - x182 * x379
                + 2 * x223
                + x54 * (x172 * x366 - x182 * x374 + 2 * x209)
            ),
            x12 * x501 + x18 * x506 + x18 * x507,
            x12 * x502 + x19 * x504,
            x13 * x495 + x511,
            x13 * x498 + x514,
            x13 * x499 + x517,
            x13 * x500 + x518,
            x13 * x501 + x519,
            x13 * x502 + x520,
            x11 * x521 + x410,
            x11 * x523 + x420,
            x11 * x525 + x430,
            x11 * x526 + x433,
            x11 * x527 + x437,
            x11 * x528 + x440,
            x12 * x521 + x511,
            x12 * x523 + x514,
            x12 * x525 + x517,
            x12 * x526 + x518,
            x12 * x527 + x519,
            x12 * x528 + x520,
            x13 * x521 + x531,
            x13 * x523 + x534,
            x13 * x525 + x537,
            x13 * x526 + x538,
            x13 * x527 + x539,
            x13 * x528 + x540,
            x11 * x541 + x466,
            x11 * x543 + x476,
            x11 * x545 + x484,
            x11 * x546 + x487,
            x11 * x547 + x490,
            x11 * x548 + x493,
            x12 * x541 + x531,
            x12 * x543 + x534,
            x12 * x545 + x537,
            x12 * x546 + x538,
            x12 * x547 + x539,
            x12 * x548 + x540,
            x13 * x541
            + x16 * x549
            + x16 * (x16 * x550 + x549)
            + x247 * x458
            + 2 * x251
            - x257 * x465,
            x13 * x543 + x16 * x552 + x17 * x549 + x247 * x474 - x257 * x475 + 2 * x302,
            x13 * x545
            + x16 * x554
            + x18 * x549
            + x247 * x482
            - x257 * x483
            + 2 * x327
            + x54 * (x247 * x454 - x257 * x464 + 2 * x287),
            x13 * x546 + x17 * x551 + x17 * x552 + x247 * x485 - x257 * x486 + 2 * x342,
            x13 * x547
            + x17 * x554
            + x18 * x551
            + x247 * x488
            - x257 * x489
            + 2 * x348
            + x54 * (x247 * x467 - x257 * x470 + 2 * x306),
            x13 * x548
            + x18 * x553
            + x18 * x554
            + x247 * x491
            - x257 * x492
            + 2 * x353
            + x59
            * (
                x247 * x477
                - x257 * x478
                + 2 * x329
                + x54 * (x247 * x452 - x257 * x461 + 2 * x288)
            ),
        ]
    )
    return S


def eri_2110(a, A, b, B, c, C, d, D):
    """Cartesian [dp|ps] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2 * a + 2 * b
    x1 = (2 * c + 2 * d + x0) ** (-1.0)
    x2 = a + b
    x3 = x2 ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = c + d
    x7 = x2 + x6
    x8 = x7 ** (-1.0)
    x9 = x6 ** (-1.0)
    x10 = x9 * (c * C[0] + d * D[0])
    x11 = -x10 - x4
    x12 = x9 * (c * C[1] + d * D[1])
    x13 = -x3 * (a * A[1] + b * B[1])
    x14 = -x12 - x13
    x15 = -x3 * (a * A[2] + b * B[2])
    x16 = -x15 - x9 * (c * C[2] + d * D[2])
    x17 = x2 * x6
    x18 = x17 * x8 * (x11**2 + x14**2 + x16**2)
    x19 = boys(2, x18)
    x20 = numpy.pi**2.5
    x21 = (x17 + numpy.sqrt(x7)) ** (-1.0)
    x22 = A[0] - B[0]
    x23 = A[1] - B[1]
    x24 = A[2] - B[2]
    x25 = numpy.exp(-a * b * x3 * (x22**2 + x23**2 + x24**2))
    x26 = numpy.exp(
        -c * d * x9 * ((C[0] - D[0]) ** 2 + (C[1] - D[1]) ** 2 + (C[2] - D[2]) ** 2)
    )
    x27 = 2 * x20 * x21 * x25 * x26
    x28 = x19 * x27
    x29 = x6 * x8
    x30 = x11 * x29
    x31 = x27 * boys(3, x18)
    x32 = x28 * x5 - x30 * x31
    x33 = x10 - C[0]
    x34 = boys(1, x18)
    x35 = x27 * x34
    x36 = x2 * x8
    x37 = x11 * x36
    x38 = x28 * x37 + x33 * x35
    x39 = x28 * x33 + x31 * x37
    x40 = x29 * x39
    x41 = x1 * x32 - x11 * x40 + x38 * x5
    x42 = x29 * x41
    x43 = x28 * x30
    x44 = x35 * x5 - x43
    x45 = x27 * boys(0, x18)
    x46 = x33 * x45 + x35 * x37
    x47 = x29 * x38
    x48 = x1 * x44 - x11 * x47 + x46 * x5
    x49 = x0 ** (-1.0)
    x50 = 2 * x49
    x51 = x29 * x32
    x52 = x49 * (2 * x20 * x21 * x25 * x26 * x34 - x28 * x29)
    x53 = -x11 * x51 + x44 * x5 + x52
    x54 = x49 * (2 * x19 * x20 * x21 * x25 * x26 - x29 * x31)
    x55 = x27 * boys(4, x18)
    x56 = -x30 * x55 + x31 * x5
    x57 = -x30 * x56 + x32 * x5 + x54
    x58 = x49 * (x46 - x47)
    x59 = x1 * x53 - x11 * x42 + x48 * x5 + x58
    x60 = x49 * (x38 - x40)
    x61 = x31 * x33 + x37 * x55
    x62 = x12 - C[1]
    x63 = x14 * x36
    x64 = x35 * x63 + x45 * x62
    x65 = x28 * x63 + x35 * x62
    x66 = x29 * x65
    x67 = x11 * x66
    x68 = x28 * x62 + x31 * x63
    x69 = x29 * x68
    x70 = -x11 * x69 + x5 * x65
    x71 = x29 * x70
    x72 = x49 * (x64 - x66)
    x73 = -x11 * x71 + x5 * (x5 * x64 - x67) + x72
    x74 = x49 * (x65 - x69)
    x75 = x31 * x62 + x55 * x63
    x76 = -x13 - A[1]
    x77 = x14 * x47
    x78 = -x14 * x40 + x38 * x76
    x79 = x29 * x78
    x80 = x49 * (x46 * x76 - x77 - x79)
    x81 = x14 * x29
    x82 = x28 * x81
    x83 = x28 * x76 - x31 * x81
    x84 = x29 * x83
    x85 = x49 * (2 * x20 * x21 * x25 * x26 * x34 * x76 - x82 - x84)
    x86 = x35 * x76 - x82
    x87 = -x11 * x84 + x5 * x86
    x88 = x31 * x76 - x55 * x81
    x89 = -x30 * x88 + x5 * x83
    x90 = x46 * x76 - x77
    x91 = x1 * x87 - x11 * x79 + x5 * x90
    x92 = x39 * x76 - x61 * x81
    x93 = (
        x1 * (-x30 * x89 + x5 * x87 + x85)
        - x30 * (x1 * x89 - x30 * x92 + x5 * x78)
        + x5 * x91
        + x80
    )
    x94 = x1 * x83 - x14 * x69 + x65 * x76
    x95 = x29 * x94
    x96 = x1 * x86 - x14 * x66 + x64 * x76
    x97 = x49 * (-x95 + x96)
    x98 = -x11 * x95 + x5 * x96
    x99 = x1 * x88 + x68 * x76 - x75 * x81
    x100 = -x30 * (-x30 * x99 + x5 * x94) + x5 * x98 + x97
    x101 = -x15 - A[2]
    x102 = x16 * x47
    x103 = x101 * x38 - x16 * x40
    x104 = x103 * x29
    x105 = x49 * (x101 * x46 - x102 - x104)
    x106 = x16 * x29
    x107 = x106 * x28
    x108 = x101 * x28 - x106 * x31
    x109 = x108 * x29
    x110 = x49 * (2 * x101 * x20 * x21 * x25 * x26 * x34 - x107 - x109)
    x111 = x101 * x35 - x107
    x112 = x111 * x5
    x113 = x109 * x11
    x114 = x112 - x113
    x115 = x108 * x5
    x116 = x101 * x31 - x106 * x55
    x117 = x116 * x30
    x118 = x115 - x117
    x119 = x101 * x46 - x102
    x120 = x1 * x114 - x104 * x11 + x119 * x5
    x121 = x101 * x39 - x106 * x61
    x122 = (
        x1 * (x110 + x114 * x5 - x118 * x30)
        + x105
        + x120 * x5
        - x30 * (x1 * x118 + x103 * x5 - x121 * x30)
    )
    x123 = x16 * x66
    x124 = x101 * x65 - x16 * x69
    x125 = x124 * x29
    x126 = x49 * (x101 * x64 - x123 - x125)
    x127 = x101 * x64 - x123
    x128 = -x11 * x125 + x127 * x5
    x129 = x101 * x68 - x106 * x75
    x130 = x126 + x128 * x5 - x30 * (x124 * x5 - x129 * x30)
    x131 = x1 * x109
    x132 = x49 * (x1 * x111 - x131)
    x133 = x1 * x112 - x1 * x113
    x134 = x132 + x133 * x5 - x30 * (x1 * x115 - x1 * x117)
    x135 = -x14 * x84 + x52 + x76 * x86
    x136 = x54 + x76 * x83 - x81 * x88
    x137 = -x14 * x79 + x58 + x76 * x90
    x138 = x60 + x76 * x78 - x81 * x92
    x139 = x1 * (x135 * x5 - x136 * x30) + x137 * x5 - x138 * x30
    x140 = x1 * x135 - x14 * x95 + x72 + x76 * x96
    x141 = x1 * x136 + x74 + x76 * x94 - x81 * x99
    x142 = x140 * x5 - x141 * x30
    x143 = -x109 * x14 + x111 * x76
    x144 = x108 * x76
    x145 = x116 * x81
    x146 = x144 - x145
    x147 = -x104 * x14 + x119 * x76
    x148 = x103 * x76 - x121 * x81
    x149 = x1 * (x143 * x5 - x146 * x30) + x147 * x5 - x148 * x30
    x150 = x1 * x143 - x125 * x14 + x127 * x76
    x151 = x1 * x146 + x124 * x76 - x129 * x81
    x152 = x150 * x5 - x151 * x30
    x153 = x1 * x111
    x154 = -x131 * x14 + x153 * x76
    x155 = x1 * x144 - x1 * x145
    x156 = x154 * x5 - x155 * x30
    x157 = x101 * x111 - x109 * x16 + x52
    x158 = x101 * x108
    x159 = x106 * x116
    x160 = x158 - x159 + x54
    x161 = x101 * x119 - x104 * x16 + x58
    x162 = x101 * x103 - x106 * x121 + x60
    x163 = x1 * (x157 * x5 - x160 * x30) + x161 * x5 - x162 * x30
    x164 = x101 * x127 - x125 * x16 + x72
    x165 = x101 * x124 - x106 * x129 + x74
    x166 = x164 * x5 - x165 * x30
    x167 = x1 * x157 + x101 * x153 - x131 * x16
    x168 = x1 * x158 - x1 * x159 + x1 * x160
    x169 = x167 * x5 - x168 * x30
    x170 = x105 + x147 * x76 - x148 * x81
    x171 = x1 * (x110 + x143 * x76 - x146 * x81) + x126 + x150 * x76 - x151 * x81
    x172 = x132 + x154 * x76 - x155 * x81
    x173 = x161 * x76 - x162 * x81
    x174 = x1 * (x157 * x76 - x160 * x81) + x164 * x76 - x165 * x81
    x175 = x167 * x76 - x168 * x81

    # 54 item(s)
    S = numpy.array(
        [
            x1
            * (
                -x30 * x57
                + x5 * x53
                + x50 * (2 * x20 * x21 * x25 * x26 * x34 * x5 - x43 - x51)
            )
            + x22 * x59
            - x30 * (x1 * x57 - x30 * (x1 * x56 - x30 * x61 + x39 * x5) + x41 * x5 + x60)
            + x5 * x59
            + x50 * (-x42 + x48),
            x22 * x73
            - x30 * (-x30 * (-x30 * x75 + x5 * x68) + x5 * x70 + x74)
            + x5 * x73
            + x50 * (x5 * x64 - x67 - x71),
            0,
            x23 * x59 + x93,
            x100 + x23 * x73,
            0,
            x122 + x24 * x59,
            x130 + x24 * x73,
            x134,
            x22 * x91 + x93,
            x100 + x22 * x98,
            0,
            x139 + x23 * x91,
            x142 + x23 * x98,
            0,
            x149 + x24 * x91,
            x152 + x24 * x98,
            x156,
            x120 * x22 + x122,
            x128 * x22 + x130,
            x133 * x22 + x134,
            x120 * x23 + x149,
            x128 * x23 + x152,
            x133 * x23 + x156,
            x120 * x24 + x163,
            x128 * x24 + x166,
            x133 * x24 + x169,
            x137 * x22 + x139,
            x140 * x22 + x142,
            0,
            x137 * x23 + x137 * x76 - x138 * x81 + 2 * x80,
            x1 * (x135 * x76 - x136 * x81 + 2 * x85)
            + x140 * x23
            + x140 * x76
            - x141 * x81
            + 2 * x97,
            0,
            x137 * x24 + x170,
            x140 * x24 + x171,
            x172,
            x147 * x22 + x149,
            x150 * x22 + x152,
            x154 * x22 + x156,
            x147 * x23 + x170,
            x150 * x23 + x171,
            x154 * x23 + x172,
            x147 * x24 + x173,
            x150 * x24 + x174,
            x154 * x24 + x175,
            x161 * x22 + x163,
            x164 * x22 + x166,
            x167 * x22 + x169,
            x161 * x23 + x173,
            x164 * x23 + x174,
            x167 * x23 + x175,
            x101 * x161 + 2 * x105 - x106 * x162 + x161 * x24,
            x101 * x164 - x106 * x165 + 2 * x126 + x164 * x24,
            x1 * (x101 * x157 - x106 * x160 + 2 * x110)
            + x101 * x167
            - x106 * x168
            + 2 * x132
            + x167 * x24,
        ]
    )
    return S


def eri_2111(a, A, b, B, c, C, d, D):
    """Cartesian [dp|pp] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = 2 * c + 2 * d
    x5 = x4 ** (-1.0)
    x6 = numpy.pi**2.5
    x7 = c + d
    x8 = x0 * x7
    x9 = x0 + x7
    x10 = (x8 + numpy.sqrt(x9)) ** (-1.0)
    x11 = A[0] - B[0]
    x12 = A[1] - B[1]
    x13 = A[2] - B[2]
    x14 = numpy.exp(-a * b * x1 * (x11**2 + x12**2 + x13**2))
    x15 = x7 ** (-1.0)
    x16 = C[0] - D[0]
    x17 = C[1] - D[1]
    x18 = C[2] - D[2]
    x19 = numpy.exp(-c * d * x15 * (x16**2 + x17**2 + x18**2))
    x20 = x9 ** (-1.0)
    x21 = x15 * (c * C[0] + d * D[0])
    x22 = -x2 - x21
    x23 = x15 * (c * C[1] + d * D[1])
    x24 = -x1 * (a * A[1] + b * B[1])
    x25 = -x23 - x24
    x26 = -x1 * (a * A[2] + b * B[2])
    x27 = -x15 * (c * C[2] + d * D[2]) - x26
    x28 = x20 * x8 * (x22**2 + x25**2 + x27**2)
    x29 = boys(1, x28)
    x30 = -2 * x10 * x14 * x19 * x29 * x6
    x31 = x0 * x20
    x32 = boys(2, x28)
    x33 = 2 * x10 * x14 * x19 * x6
    x34 = x32 * x33
    x35 = x5 * (-x30 - x31 * x34)
    x36 = x21 - C[0]
    x37 = x29 * x33
    x38 = x22 * x31
    x39 = x34 * x38 + x36 * x37
    x40 = boys(3, x28)
    x41 = x33 * x40
    x42 = x34 * x36 + x38 * x41
    x43 = x35 + x36 * x39 + x38 * x42
    x44 = -2 * x10 * x14 * x19 * x32 * x6
    x45 = x5 * (-x31 * x41 - x44)
    x46 = x33 * boys(4, x28)
    x47 = x36 * x41 + x38 * x46
    x48 = x36 * x42 + x38 * x47 + x45
    x49 = x20 * x7
    x50 = x48 * x49
    x51 = 2 * a + 2 * b
    x52 = x4 + x51
    x53 = x52 ** (-1.0)
    x54 = x22 * x49
    x55 = x3 * x41 - x46 * x54
    x56 = x47 * x49
    x57 = -x22 * x56 + x3 * x42 + x53 * x55
    x58 = 2 * x53
    x59 = -x22 * x50 + x3 * x43 + x57 * x58
    x60 = x49 * x59
    x61 = boys(0, x28)
    x62 = x5 * (2 * x10 * x14 * x19 * x6 * x61 - x31 * x37)
    x63 = x33 * x61
    x64 = x36 * x63 + x37 * x38
    x65 = x36 * x64 + x38 * x39 + x62
    x66 = x43 * x49
    x67 = x41 * x54
    x68 = x3 * x34 - x67
    x69 = x42 * x49
    x70 = -x22 * x69 + x3 * x39 + x53 * x68
    x71 = -x22 * x66 + x3 * x65 + x58 * x70
    x72 = x51 ** (-1.0)
    x73 = 2 * x72
    x74 = x72 * (x65 - x66)
    x75 = x72 * (x39 - x69)
    x76 = x72 * (-x41 * x49 - x44)
    x77 = x49 * x55
    x78 = -x22 * x77 + x3 * x68 + x76
    x79 = x49 * x57
    x80 = -x22 * x79 + x3 * x70 + x53 * x78 + x75
    x81 = -x22 * x60 + x3 * x71 + x58 * x80 + x74
    x82 = x72 * (x43 - x50)
    x83 = -2 * x10 * x14 * x19 * x40 * x6
    x84 = x5 * (-x31 * x46 - x83)
    x85 = x33 * boys(5, x28)
    x86 = x36 * x46 + x38 * x85
    x87 = x36 * x47 + x38 * x86 + x84
    x88 = x3 * x46 - x54 * x85
    x89 = x3 * x47 + x53 * x88 - x54 * x86
    x90 = x72 * (x42 - x56)
    x91 = x72 * (-x46 * x49 - x83)
    x92 = x3 * x55 - x54 * x88 + x91
    x93 = x3 * x57 + x53 * x92 - x54 * x89 + x90
    x94 = x49 * x70
    x95 = x34 * x54
    x96 = x3 * x37 - x95
    x97 = x39 * x49
    x98 = -x22 * x97 + x3 * x64 + x53 * x96
    x99 = x49 * x68
    x100 = x72 * (-x30 - x34 * x49)
    x101 = x100 - x22 * x99 + x3 * x96
    x102 = x72 * (x64 - x97)
    x103 = x101 * x53 + x102 - x22 * x94 + x3 * x98
    x104 = (
        x103 * x3
        + x53
        * (
            x101 * x3
            - x54 * x78
            + x73 * (2 * x10 * x14 * x19 * x29 * x3 * x6 - x95 - x99)
        )
        - x54 * x80
        + x73 * (-x94 + x98)
    )
    x105 = x103 * x16 + x81
    x106 = x23 - C[1]
    x107 = x25 * x31
    x108 = x106 * x37 + x107 * x34
    x109 = x106 * x34 + x107 * x41
    x110 = x108 * x36 + x109 * x38
    x111 = x110 * x49
    x112 = x106 * x63 + x107 * x37
    x113 = x108 * x38 + x112 * x36
    x114 = x72 * (-x111 + x113)
    x115 = x109 * x49
    x116 = x72 * (x108 - x115)
    x117 = x115 * x22
    x118 = x108 * x3 - x117
    x119 = x106 * x41 + x107 * x46
    x120 = x119 * x49
    x121 = x109 * x3 - x120 * x22
    x122 = x121 * x49
    x123 = x116 + x118 * x3 - x122 * x22
    x124 = -x111 * x22 + x113 * x3 + x118 * x53
    x125 = x109 * x36 + x119 * x38
    x126 = x125 * x49
    x127 = x110 * x3 + x121 * x53 - x126 * x22
    x128 = x127 * x49
    x129 = x114 + x123 * x53 + x124 * x3 - x128 * x22
    x130 = x103 * x17 + x129
    x131 = x72 * (x109 - x120)
    x132 = x106 * x46 + x107 * x85
    x133 = x119 * x3 - x132 * x54
    x134 = x121 * x3 + x131 - x133 * x54
    x135 = x72 * (x110 - x126)
    x136 = x119 * x36 + x132 * x38
    x137 = (
        x129 * x3
        + x53 * (x123 * x3 - x134 * x54 + x73 * (x108 * x3 - x117 - x122))
        - x54
        * (x127 * x3 + x134 * x53 + x135 - x54 * (x125 * x3 + x133 * x53 - x136 * x54))
        + x73 * (x124 - x128)
    )
    x138 = x11 * x18
    x139 = x108 * x49
    x140 = x72 * (x112 - x139)
    x141 = x139 * x22
    x142 = x118 * x49
    x143 = x140 - x142 * x22 + x3 * (x112 * x3 - x141)
    x144 = x129 + x143 * x16
    x145 = -x123 * x54 + x143 * x3 + x73 * (x112 * x3 - x141 - x142)
    x146 = x106 * x112 + x107 * x108 + x62
    x147 = x106 * x108 + x107 * x109 + x35
    x148 = x147 * x49
    x149 = x148 * x22
    x150 = x106 * x109 + x107 * x119 + x45
    x151 = x150 * x49
    x152 = x147 * x3 - x151 * x22
    x153 = x152 * x49
    x154 = x72 * (x146 - x148)
    x155 = -x153 * x22 + x154 + x3 * (x146 * x3 - x149)
    x156 = x72 * (x147 - x151)
    x157 = x106 * x119 + x107 * x132 + x84
    x158 = x143 * x17 + x155
    x159 = -x24 - A[1]
    x160 = x25 * x66
    x161 = x159 * x43 - x25 * x50
    x162 = x161 * x49
    x163 = x72 * (x159 * x65 - x160 - x162)
    x164 = x25 * x97
    x165 = x25 * x69
    x166 = x159 * x39 - x165
    x167 = x166 * x49
    x168 = x72 * (x159 * x64 - x164 - x167)
    x169 = x25 * x49
    x170 = x169 * x34
    x171 = x169 * x41
    x172 = x159 * x34 - x171
    x173 = x172 * x49
    x174 = x72 * (2 * x10 * x14 * x159 * x19 * x29 * x6 - x170 - x173)
    x175 = x159 * x37 - x170
    x176 = -x173 * x22 + x175 * x3
    x177 = x159 * x41 - x169 * x46
    x178 = x177 * x49
    x179 = x172 * x3 - x178 * x22
    x180 = x159 * x64 - x164
    x181 = -x167 * x22 + x176 * x53 + x180 * x3
    x182 = x159 * x42 - x25 * x56
    x183 = x182 * x49
    x184 = x166 * x3 + x179 * x53 - x183 * x22
    x185 = x168 + x181 * x3 - x184 * x54 + x53 * (x174 + x176 * x3 - x179 * x54)
    x186 = x159 * x65 - x160
    x187 = -x162 * x22 + x184 * x58 + x186 * x3
    x188 = x72 * (x159 * x39 - x165 - x183)
    x189 = x72 * (2 * x10 * x14 * x159 * x19 * x32 * x6 - x171 - x178)
    x190 = x159 * x46 - x169 * x85
    x191 = x177 * x3 - x190 * x54
    x192 = x159 * x47 - x169 * x86
    x193 = x182 * x3 + x191 * x53 - x192 * x54
    x194 = x159 * x48 - x169 * x87
    x195 = (
        x16 * x185
        + x163
        + x187 * x3
        - x54 * (x161 * x3 + x193 * x58 - x194 * x54)
        + x58 * (x184 * x3 + x188 - x193 * x54 + x53 * (x179 * x3 + x189 - x191 * x54))
    )
    x196 = x110 * x159 - x126 * x25 + x182 * x53
    x197 = x196 * x49
    x198 = -x111 * x25 + x113 * x159 + x166 * x53
    x199 = x72 * (-x197 + x198)
    x200 = x109 * x159 - x120 * x25 + x177 * x53
    x201 = x200 * x49
    x202 = x108 * x159 - x115 * x25 + x172 * x53
    x203 = x72 * (-x201 + x202)
    x204 = -x201 * x22 + x202 * x3
    x205 = x119 * x159 - x132 * x169 + x190 * x53
    x206 = x200 * x3 - x205 * x54
    x207 = -x197 * x22 + x198 * x3 + x204 * x53
    x208 = x125 * x159 - x136 * x169 + x192 * x53
    x209 = (
        x199
        + x207 * x3
        + x53 * (x203 + x204 * x3 - x206 * x54)
        - x54 * (x196 * x3 + x206 * x53 - x208 * x54)
    )
    x210 = x17 * x185 + x209
    x211 = x12 * x18
    x212 = x18 * x185
    x213 = x202 * x49
    x214 = x112 * x159 - x139 * x25 + x175 * x53
    x215 = x72 * (-x213 + x214)
    x216 = -x213 * x22 + x214 * x3
    x217 = -x204 * x54 + x215 + x216 * x3
    x218 = x16 * x217 + x209
    x219 = x147 * x159 - x151 * x25 + x200 * x58
    x220 = x219 * x49
    x221 = x146 * x159 - x148 * x25 + x202 * x58
    x222 = x72 * (-x220 + x221)
    x223 = -x22 * x220 + x221 * x3
    x224 = x150 * x159 - x157 * x169 + x205 * x58
    x225 = x17 * x217 + x222 + x223 * x3 - x54 * (x219 * x3 - x224 * x54)
    x226 = x18 * x217
    x227 = -x26 - A[2]
    x228 = x27 * x66
    x229 = x227 * x43 - x27 * x50
    x230 = x229 * x49
    x231 = x72 * (x227 * x65 - x228 - x230)
    x232 = x27 * x97
    x233 = x27 * x69
    x234 = x227 * x39 - x233
    x235 = x234 * x49
    x236 = x72 * (x227 * x64 - x232 - x235)
    x237 = x27 * x49
    x238 = x237 * x34
    x239 = x237 * x41
    x240 = x227 * x34 - x239
    x241 = x240 * x49
    x242 = x72 * (2 * x10 * x14 * x19 * x227 * x29 * x6 - x238 - x241)
    x243 = x227 * x37 - x238
    x244 = x243 * x3
    x245 = -x22 * x241 + x244
    x246 = x240 * x3
    x247 = x227 * x41 - x237 * x46
    x248 = x247 * x49
    x249 = x22 * x248
    x250 = x246 - x249
    x251 = x227 * x64 - x232
    x252 = -x22 * x235 + x245 * x53 + x251 * x3
    x253 = x234 * x3
    x254 = x227 * x42 - x27 * x56
    x255 = x254 * x49
    x256 = x22 * x255
    x257 = x250 * x53 + x253 - x256
    x258 = x236 + x252 * x3 - x257 * x54 + x53 * (x242 + x245 * x3 - x250 * x54)
    x259 = x227 * x65 - x228
    x260 = -x22 * x230 + x257 * x58 + x259 * x3
    x261 = x72 * (x227 * x39 - x233 - x255)
    x262 = x72 * (2 * x10 * x14 * x19 * x227 * x32 * x6 - x239 - x248)
    x263 = x247 * x3
    x264 = x227 * x46 - x237 * x85
    x265 = x264 * x54
    x266 = x263 - x265
    x267 = x254 * x3
    x268 = x227 * x47 - x237 * x86
    x269 = x268 * x54
    x270 = x266 * x53 + x267 - x269
    x271 = x227 * x48 - x237 * x87
    x272 = (
        x16 * x258
        + x231
        + x260 * x3
        - x54 * (x229 * x3 + x270 * x58 - x271 * x54)
        + x58 * (x257 * x3 + x261 - x270 * x54 + x53 * (x250 * x3 + x262 - x266 * x54))
    )
    x273 = x111 * x27
    x274 = x110 * x227 - x126 * x27
    x275 = x274 * x49
    x276 = x72 * (x113 * x227 - x273 - x275)
    x277 = x115 * x27
    x278 = x109 * x227 - x120 * x27
    x279 = x278 * x49
    x280 = x72 * (x108 * x227 - x277 - x279)
    x281 = x108 * x227 - x277
    x282 = x281 * x3
    x283 = x22 * x279
    x284 = x282 - x283
    x285 = x278 * x3
    x286 = x119 * x227 - x132 * x237
    x287 = x286 * x54
    x288 = x285 - x287
    x289 = x113 * x227 - x273
    x290 = -x22 * x275 + x284 * x53 + x289 * x3
    x291 = x125 * x227 - x136 * x237
    x292 = (
        x276
        + x290 * x3
        + x53 * (x280 + x284 * x3 - x288 * x54)
        - x54 * (x274 * x3 + x288 * x53 - x291 * x54)
    )
    x293 = x17 * x258 + x292
    x294 = x13 * x18
    x295 = x255 * x53
    x296 = x72 * (x234 * x53 - x295)
    x297 = x248 * x53
    x298 = x72 * (x240 * x53 - x297)
    x299 = x246 * x53 - x249 * x53
    x300 = x263 * x53 - x265 * x53
    x301 = x253 * x53 - x256 * x53 + x299 * x53
    x302 = (
        x296
        + x3 * x301
        + x53 * (x298 + x299 * x3 - x300 * x54)
        - x54 * (x267 * x53 - x269 * x53 + x300 * x53)
    )
    x303 = x18 * x258 + x302
    x304 = x139 * x27
    x305 = x281 * x49
    x306 = x72 * (x112 * x227 - x304 - x305)
    x307 = x112 * x227 - x304
    x308 = -x22 * x305 + x3 * x307
    x309 = -x284 * x54 + x3 * x308 + x306
    x310 = x16 * x309 + x292
    x311 = x148 * x27
    x312 = x147 * x227 - x151 * x27
    x313 = x312 * x49
    x314 = x72 * (x146 * x227 - x311 - x313)
    x315 = x146 * x227 - x311
    x316 = -x22 * x313 + x3 * x315
    x317 = x150 * x227 - x157 * x237
    x318 = x17 * x309 + x3 * x316 + x314 - x54 * (x3 * x312 - x317 * x54)
    x319 = x279 * x53
    x320 = x72 * (x281 * x53 - x319)
    x321 = x282 * x53 - x283 * x53
    x322 = x3 * x321 + x320 - x54 * (x285 * x53 - x287 * x53)
    x323 = x18 * x309 + x322
    x324 = x240 * x53
    x325 = x72 * (x243 * x53 - x324 * x49)
    x326 = x244 * x53 - x324 * x54
    x327 = -x299 * x54 + x3 * x326 + x325
    x328 = x16 * x327 + x302
    x329 = x17 * x327 + x322
    x330 = x52 ** (-2.0)
    x331 = 2 * x330
    x332 = x72 * (2 * x240 * x330 - x248 * x331)
    x333 = x246 * x331 - x249 * x331
    x334 = x18 * x327 + x3 * x333 + x332 - x54 * (x263 * x331 - x265 * x331)
    x335 = x16 * x181 + x187
    x336 = x17 * x181 + x207
    x337 = x16 * x216 + x207
    x338 = x17 * x216 + x223
    x339 = x100 + x159 * x175 - x173 * x25
    x340 = x159 * x172 - x178 * x25 + x76
    x341 = x102 + x159 * x180 - x167 * x25
    x342 = x159 * x166 - x183 * x25 + x75
    x343 = x3 * x341 - x342 * x54 + x53 * (x3 * x339 - x340 * x54)
    x344 = x159 * x186 - x162 * x25 + x74
    x345 = x159 * x177 - x169 * x190 + x91
    x346 = x159 * x182 - x169 * x192 + x90
    x347 = x159 * x161 - x169 * x194 + x82
    x348 = (
        x16 * x343
        + x3 * x344
        - x347 * x54
        + x58 * (x3 * x342 - x346 * x54 + x53 * (x3 * x340 - x345 * x54))
    )
    x349 = x116 + x159 * x202 - x201 * x25 + x340 * x53
    x350 = x131 + x159 * x200 - x169 * x205 + x345 * x53
    x351 = x114 + x159 * x198 - x197 * x25 + x342 * x53
    x352 = x135 + x159 * x196 - x169 * x208 + x346 * x53
    x353 = x3 * x351 - x352 * x54 + x53 * (x3 * x349 - x350 * x54)
    x354 = x17 * x343 + x353
    x355 = x18 * x343
    x356 = x140 + x159 * x214 - x213 * x25 + x339 * x53
    x357 = x3 * x356 - x349 * x54
    x358 = x16 * x357 + x353
    x359 = x154 + x159 * x221 - x220 * x25 + x349 * x58
    x360 = x156 + x159 * x219 - x169 * x224 + x350 * x58
    x361 = x17 * x357 + x3 * x359 - x360 * x54
    x362 = x18 * x357
    x363 = x159 * x243 - x241 * x25
    x364 = x159 * x240
    x365 = x248 * x25
    x366 = x364 - x365
    x367 = x159 * x251 - x235 * x25
    x368 = x159 * x234 - x25 * x255
    x369 = x3 * x367 - x368 * x54 + x53 * (x3 * x363 - x366 * x54)
    x370 = x159 * x259 - x230 * x25
    x371 = x159 * x247
    x372 = x169 * x264
    x373 = x371 - x372
    x374 = x159 * x254
    x375 = x169 * x268
    x376 = x374 - x375
    x377 = x159 * x229 - x169 * x271
    x378 = (
        x16 * x369
        + x3 * x370
        - x377 * x54
        + x58 * (x3 * x368 - x376 * x54 + x53 * (x3 * x366 - x373 * x54))
    )
    x379 = x159 * x281 - x25 * x279 + x366 * x53
    x380 = x159 * x278
    x381 = x169 * x286
    x382 = x373 * x53 + x380 - x381
    x383 = x159 * x289 - x25 * x275 + x368 * x53
    x384 = x159 * x274 - x169 * x291 + x376 * x53
    x385 = x3 * x383 - x384 * x54 + x53 * (x3 * x379 - x382 * x54)
    x386 = x17 * x369 + x385
    x387 = x159 * x324 - x25 * x297
    x388 = x371 * x53 - x372 * x53
    x389 = x234 * x53
    x390 = x159 * x389 - x25 * x295
    x391 = x374 * x53 - x375 * x53
    x392 = x3 * x390 - x391 * x54 + x53 * (x3 * x387 - x388 * x54)
    x393 = x18 * x369 + x392
    x394 = x159 * x307 - x25 * x305 + x363 * x53
    x395 = x3 * x394 - x379 * x54
    x396 = x16 * x395 + x385
    x397 = x159 * x315 - x25 * x313 + x379 * x58
    x398 = x159 * x312 - x169 * x317 + x382 * x58
    x399 = x17 * x395 + x3 * x397 - x398 * x54
    x400 = x281 * x53
    x401 = x159 * x400 - x25 * x319 + x387 * x53
    x402 = x380 * x53 - x381 * x53 + x388 * x53
    x403 = x3 * x401 - x402 * x54
    x404 = x18 * x395 + x403
    x405 = x243 * x53
    x406 = x159 * x405 - x169 * x324
    x407 = x3 * x406 - x387 * x54
    x408 = x16 * x407 + x392
    x409 = x17 * x407 + x403
    x410 = x331 * x364 - x331 * x365
    x411 = x331 * x371 - x331 * x372
    x412 = x18 * x407 + x3 * x410 - x411 * x54
    x413 = x16 * x252 + x260
    x414 = x17 * x252 + x290
    x415 = x18 * x252 + x301
    x416 = x16 * x308 + x290
    x417 = x17 * x308 + x316
    x418 = x18 * x308 + x321
    x419 = x16 * x326 + x301
    x420 = x17 * x326 + x321
    x421 = x18 * x326 + x333
    x422 = x100 + x227 * x243 - x241 * x27
    x423 = x227 * x240
    x424 = x248 * x27
    x425 = x423 - x424 + x76
    x426 = x102 + x227 * x251 - x235 * x27
    x427 = x227 * x234 - x255 * x27 + x75
    x428 = x3 * x426 - x427 * x54 + x53 * (x3 * x422 - x425 * x54)
    x429 = x227 * x259 - x230 * x27 + x74
    x430 = x227 * x247
    x431 = x237 * x264
    x432 = x430 - x431 + x91
    x433 = x227 * x254
    x434 = x237 * x268
    x435 = x433 - x434 + x90
    x436 = x227 * x229 - x237 * x271 + x82
    x437 = (
        x16 * x428
        + x3 * x429
        - x436 * x54
        + x58 * (x3 * x427 - x435 * x54 + x53 * (x3 * x425 - x432 * x54))
    )
    x438 = x116 + x227 * x281 - x27 * x279
    x439 = x227 * x278
    x440 = x237 * x286
    x441 = x131 + x439 - x440
    x442 = x114 + x227 * x289 - x27 * x275
    x443 = x135 + x227 * x274 - x237 * x291
    x444 = x3 * x442 - x443 * x54 + x53 * (x3 * x438 - x441 * x54)
    x445 = x17 * x428 + x444
    x446 = x227 * x324 - x27 * x297 + x425 * x53
    x447 = x430 * x53 - x431 * x53 + x432 * x53
    x448 = x227 * x389 - x27 * x295 + x427 * x53
    x449 = x433 * x53 - x434 * x53 + x435 * x53
    x450 = x3 * x448 - x449 * x54 + x53 * (x3 * x446 - x447 * x54)
    x451 = x18 * x428 + x450
    x452 = x140 + x227 * x307 - x27 * x305
    x453 = x3 * x452 - x438 * x54
    x454 = x16 * x453 + x444
    x455 = x154 + x227 * x315 - x27 * x313
    x456 = x156 + x227 * x312 - x237 * x317
    x457 = x17 * x453 + x3 * x455 - x456 * x54
    x458 = x227 * x400 - x27 * x319 + x438 * x53
    x459 = x439 * x53 - x440 * x53 + x441 * x53
    x460 = x3 * x458 - x459 * x54
    x461 = x18 * x453 + x460
    x462 = x227 * x405 - x237 * x324 + x422 * x53
    x463 = x3 * x462 - x446 * x54
    x464 = x16 * x463 + x450
    x465 = x17 * x463 + x460
    x466 = x331 * x423 - x331 * x424 + x446 * x58
    x467 = x331 * x430 - x331 * x431 + x447 * x58
    x468 = x18 * x463 + x3 * x466 - x467 * x54
    x469 = x16 * x341 + x344
    x470 = x17 * x341 + x351
    x471 = x16 * x356 + x351
    x472 = x17 * x356 + x359
    x473 = x159 * x341 + 2 * x168 - x169 * x342
    x474 = (
        x159 * x351
        - x169 * x352
        + 2 * x199
        + x53 * (x159 * x342 - x169 * x346 + 2 * x188)
    )
    x475 = (
        x159 * x356
        - x169 * x349
        + 2 * x215
        + x53 * (x159 * x339 - x169 * x340 + 2 * x174)
    )
    x476 = x159 * x367 - x169 * x368 + x236
    x477 = x159 * x370 + x16 * x476 - x169 * x377 + x231
    x478 = x159 * x383 - x169 * x384 + x276 + x53 * (x159 * x368 - x169 * x376 + x261)
    x479 = x17 * x476 + x478
    x480 = x159 * x390 - x169 * x391 + x296
    x481 = x18 * x476 + x480
    x482 = x159 * x394 - x169 * x379 + x306 + x53 * (x159 * x363 - x169 * x366 + x242)
    x483 = x16 * x482 + x478
    x484 = (
        x159 * x397
        - x169 * x398
        + x17 * x482
        + x314
        + x58
        * (x159 * x379 - x169 * x382 + x280 + x53 * (x159 * x366 - x169 * x373 + x262))
    )
    x485 = x159 * x401 - x169 * x402 + x320 + x53 * (x159 * x387 - x169 * x388 + x298)
    x486 = x18 * x482 + x485
    x487 = x159 * x406 - x169 * x387 + x325
    x488 = x16 * x487 + x480
    x489 = x17 * x487 + x485
    x490 = x159 * x410 - x169 * x411 + x18 * x487 + x332
    x491 = x16 * x367 + x370
    x492 = x17 * x367 + x383
    x493 = x18 * x367 + x390
    x494 = x16 * x394 + x383
    x495 = x17 * x394 + x397
    x496 = x18 * x394 + x401
    x497 = x16 * x406 + x390
    x498 = x17 * x406 + x401
    x499 = x18 * x406 + x410
    x500 = x159 * x426 - x169 * x427
    x501 = x159 * x429 + x16 * x500 - x169 * x436
    x502 = x159 * x442 - x169 * x443 + x53 * (x159 * x427 - x169 * x435)
    x503 = x17 * x500 + x502
    x504 = x159 * x448 - x169 * x449
    x505 = x18 * x500 + x504
    x506 = x159 * x452 - x169 * x438 + x53 * (x159 * x422 - x169 * x425)
    x507 = x16 * x506 + x502
    x508 = (
        x159 * x455
        - x169 * x456
        + x17 * x506
        + x58 * (x159 * x438 - x169 * x441 + x53 * (x159 * x425 - x169 * x432))
    )
    x509 = x159 * x458 - x169 * x459 + x53 * (x159 * x446 - x169 * x447)
    x510 = x18 * x506 + x509
    x511 = x159 * x462 - x169 * x446
    x512 = x16 * x511 + x504
    x513 = x17 * x511 + x509
    x514 = x159 * x466 - x169 * x467 + x18 * x511
    x515 = x16 * x426 + x429
    x516 = x17 * x426 + x442
    x517 = x18 * x426 + x448
    x518 = x16 * x452 + x442
    x519 = x17 * x452 + x455
    x520 = x18 * x452 + x458
    x521 = x16 * x462 + x448
    x522 = x17 * x462 + x458
    x523 = x18 * x462 + x466
    x524 = x227 * x426 + 2 * x236 - x237 * x427
    x525 = x227 * x442 - x237 * x443 + 2 * x276
    x526 = (
        x227 * x448
        - x237 * x449
        + 2 * x296
        + x53 * (x227 * x427 - x237 * x435 + 2 * x261)
    )
    x527 = x227 * x452 - x237 * x438 + 2 * x306
    x528 = (
        x227 * x458
        - x237 * x459
        + 2 * x320
        + x53 * (x227 * x438 - x237 * x441 + 2 * x280)
    )
    x529 = (
        x227 * x462
        - x237 * x446
        + 2 * x325
        + x53 * (x227 * x422 - x237 * x425 + 2 * x242)
    )

    # 162 item(s)
    S = numpy.array(
        [
            x104 * x16
            + x105 * x11
            + x3 * x81
            - x54
            * (x3 * x59 - x54 * (x3 * x48 - x54 * x87 + x58 * x89) + x58 * x93 + x82)
            + x58
            * (
                x3 * x80
                + x53
                * (
                    x3 * x78
                    - x54 * x92
                    + x73 * (2 * x10 * x14 * x19 * x3 * x32 * x6 - x67 - x77)
                )
                - x54 * x93
                + x73 * (x70 - x79)
            )
            + x73 * (-x60 + x71),
            x104 * x17 + x11 * x130 + x137,
            x103 * x138 + x104 * x18,
            x11 * x144 + x137 + x145 * x16,
            x11 * x158
            + x145 * x17
            + x155 * x3
            - x54 * (x152 * x3 + x156 - x54 * (x150 * x3 - x157 * x54))
            + x73 * (x146 * x3 - x149 - x153),
            x138 * x143 + x145 * x18,
            0,
            0,
            0,
            x105 * x12 + x195,
            x12 * x130 + x210,
            x103 * x211 + x212,
            x12 * x144 + x218,
            x12 * x158 + x225,
            x143 * x211 + x226,
            0,
            0,
            0,
            x105 * x13 + x272,
            x13 * x130 + x293,
            x103 * x294 + x303,
            x13 * x144 + x310,
            x13 * x158 + x318,
            x143 * x294 + x323,
            x328,
            x329,
            x334,
            x11 * x335 + x195,
            x11 * x336 + x210,
            x138 * x181 + x212,
            x11 * x337 + x218,
            x11 * x338 + x225,
            x138 * x216 + x226,
            0,
            0,
            0,
            x12 * x335 + x348,
            x12 * x336 + x354,
            x181 * x211 + x355,
            x12 * x337 + x358,
            x12 * x338 + x361,
            x211 * x216 + x362,
            0,
            0,
            0,
            x13 * x335 + x378,
            x13 * x336 + x386,
            x181 * x294 + x393,
            x13 * x337 + x396,
            x13 * x338 + x399,
            x216 * x294 + x404,
            x408,
            x409,
            x412,
            x11 * x413 + x272,
            x11 * x414 + x293,
            x11 * x415 + x303,
            x11 * x416 + x310,
            x11 * x417 + x318,
            x11 * x418 + x323,
            x11 * x419 + x328,
            x11 * x420 + x329,
            x11 * x421 + x334,
            x12 * x413 + x378,
            x12 * x414 + x386,
            x12 * x415 + x393,
            x12 * x416 + x396,
            x12 * x417 + x399,
            x12 * x418 + x404,
            x12 * x419 + x408,
            x12 * x420 + x409,
            x12 * x421 + x412,
            x13 * x413 + x437,
            x13 * x414 + x445,
            x13 * x415 + x451,
            x13 * x416 + x454,
            x13 * x417 + x457,
            x13 * x418 + x461,
            x13 * x419 + x464,
            x13 * x420 + x465,
            x13 * x421 + x468,
            x11 * x469 + x348,
            x11 * x470 + x354,
            x138 * x341 + x355,
            x11 * x471 + x358,
            x11 * x472 + x361,
            x138 * x356 + x362,
            0,
            0,
            0,
            x12 * x469 + x159 * x344 + x16 * x473 + 2 * x163 - x169 * x347,
            x12 * x470 + x17 * x473 + x474,
            x18 * x473 + x211 * x341,
            x12 * x471 + x16 * x475 + x474,
            x12 * x472
            + x159 * x359
            - x169 * x360
            + x17 * x475
            + 2 * x222
            + x58
            * (
                x159 * x349
                - x169 * x350
                + 2 * x203
                + x53 * (x159 * x340 - x169 * x345 + 2 * x189)
            ),
            x18 * x475 + x211 * x356,
            0,
            0,
            0,
            x13 * x469 + x477,
            x13 * x470 + x479,
            x294 * x341 + x481,
            x13 * x471 + x483,
            x13 * x472 + x484,
            x294 * x356 + x486,
            x488,
            x489,
            x490,
            x11 * x491 + x378,
            x11 * x492 + x386,
            x11 * x493 + x393,
            x11 * x494 + x396,
            x11 * x495 + x399,
            x11 * x496 + x404,
            x11 * x497 + x408,
            x11 * x498 + x409,
            x11 * x499 + x412,
            x12 * x491 + x477,
            x12 * x492 + x479,
            x12 * x493 + x481,
            x12 * x494 + x483,
            x12 * x495 + x484,
            x12 * x496 + x486,
            x12 * x497 + x488,
            x12 * x498 + x489,
            x12 * x499 + x490,
            x13 * x491 + x501,
            x13 * x492 + x503,
            x13 * x493 + x505,
            x13 * x494 + x507,
            x13 * x495 + x508,
            x13 * x496 + x510,
            x13 * x497 + x512,
            x13 * x498 + x513,
            x13 * x499 + x514,
            x11 * x515 + x437,
            x11 * x516 + x445,
            x11 * x517 + x451,
            x11 * x518 + x454,
            x11 * x519 + x457,
            x11 * x520 + x461,
            x11 * x521 + x464,
            x11 * x522 + x465,
            x11 * x523 + x468,
            x12 * x515 + x501,
            x12 * x516 + x503,
            x12 * x517 + x505,
            x12 * x518 + x507,
            x12 * x519 + x508,
            x12 * x520 + x510,
            x12 * x521 + x512,
            x12 * x522 + x513,
            x12 * x523 + x514,
            x13 * x515 + x16 * x524 + x227 * x429 + 2 * x231 - x237 * x436,
            x13 * x516 + x17 * x524 + x525,
            x13 * x517 + x18 * x524 + x526,
            x13 * x518 + x16 * x527 + x525,
            x13 * x519 + x17 * x527 + x227 * x455 - x237 * x456 + 2 * x314,
            x13 * x520 + x18 * x527 + x528,
            x13 * x521 + x16 * x529 + x526,
            x13 * x522 + x17 * x529 + x528,
            x13 * x523
            + x18 * x529
            + x227 * x466
            - x237 * x467
            + 2 * x332
            + x58
            * (
                x227 * x446
                - x237 * x447
                + 2 * x298
                + x53 * (x227 * x425 - x237 * x432 + 2 * x262)
            ),
        ]
    )
    return S


def eri_2112(a, A, b, B, c, C, d, D):
    """Cartesian [dp|pd] 2-electron electron repulsion integral.

    Generated code; DO NOT modify by hand!"""

    x0 = a + b
    x1 = x0 ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = c + d
    x5 = x4 ** (-1.0)
    x6 = x5 * (c * C[0] + d * D[0])
    x7 = x6 - C[0]
    x8 = x0 + x4
    x9 = x8 ** (-1.0)
    x10 = -x2 - x6
    x11 = x5 * (c * C[1] + d * D[1])
    x12 = -x1 * (a * A[1] + b * B[1])
    x13 = -x11 - x12
    x14 = -x1 * (a * A[2] + b * B[2])
    x15 = -x14 - x5 * (c * C[2] + d * D[2])
    x16 = x0 * x4
    x17 = x16 * x9 * (x10**2 + x13**2 + x15**2)
    x18 = boys(2, x17)
    x19 = numpy.pi**2.5
    x20 = (x16 + numpy.sqrt(x8)) ** (-1.0)
    x21 = A[0] - B[0]
    x22 = A[1] - B[1]
    x23 = A[2] - B[2]
    x24 = numpy.exp(-a * b * x1 * (x21**2 + x22**2 + x23**2))
    x25 = C[0] - D[0]
    x26 = C[1] - D[1]
    x27 = C[2] - D[2]
    x28 = x27**2
    x29 = numpy.exp(-c * d * x5 * (x25**2 + x26**2 + x28))
    x30 = 2 * x19 * x20 * x24 * x29
    x31 = x18 * x30
    x32 = x0 * x9
    x33 = x10 * x32
    x34 = boys(3, x17)
    x35 = x30 * x34
    x36 = x31 * x7 + x33 * x35
    x37 = x32 * x36
    x38 = boys(1, x17)
    x39 = x30 * x38
    x40 = x31 * x33 + x39 * x7
    x41 = 2 * c + 2 * d
    x42 = x41 ** (-1.0)
    x43 = 2 * x42
    x44 = -2 * x19 * x20 * x24 * x29 * x38
    x45 = x42 * (-x31 * x32 - x44)
    x46 = x10 * x37 + x40 * x7 + x45
    x47 = -2 * x18 * x19 * x20 * x24 * x29
    x48 = x42 * (-x32 * x35 - x47)
    x49 = boys(4, x17)
    x50 = x30 * x49
    x51 = x33 * x50 + x35 * x7
    x52 = x32 * x51
    x53 = x10 * x52 + x36 * x7 + x48
    x54 = x33 * x53 + x43 * (-x37 + x40) + x46 * x7
    x55 = -2 * x19 * x20 * x24 * x29 * x34
    x56 = x42 * (-x32 * x50 - x55)
    x57 = x30 * boys(5, x17)
    x58 = x33 * x57 + x50 * x7
    x59 = x32 * x58
    x60 = x10 * x59 + x51 * x7 + x56
    x61 = x33 * x60 + x43 * (x36 - x52) + x53 * x7
    x62 = x4 * x9
    x63 = x61 * x62
    x64 = x60 * x62
    x65 = 2 * a + 2 * b
    x66 = x41 + x65
    x67 = x66 ** (-1.0)
    x68 = x10 * x62
    x69 = x3 * x50 - x57 * x68
    x70 = x58 * x62
    x71 = -x10 * x70 + x3 * x51 + x67 * x69
    x72 = 2 * x67
    x73 = -x10 * x64 + x3 * x53 + x71 * x72
    x74 = 3 * x67
    x75 = -x10 * x63 + x3 * x54 + x73 * x74
    x76 = x62 * x75
    x77 = x32 * x40
    x78 = boys(0, x17)
    x79 = x30 * x78
    x80 = x33 * x39 + x7 * x79
    x81 = x42 * (2 * x19 * x20 * x24 * x29 * x78 - x32 * x39)
    x82 = x10 * x77 + x7 * x80 + x81
    x83 = x33 * x46 + x43 * (-x77 + x80) + x7 * x82
    x84 = x54 * x62
    x85 = x53 * x62
    x86 = x50 * x68
    x87 = x3 * x35 - x86
    x88 = x51 * x62
    x89 = -x10 * x88 + x3 * x36 + x67 * x87
    x90 = -x10 * x85 + x3 * x46 + x72 * x89
    x91 = -x10 * x84 + x3 * x83 + x74 * x90
    x92 = x65 ** (-1.0)
    x93 = 2 * x92
    x94 = x92 * (x83 - x84)
    x95 = x92 * (x46 - x85)
    x96 = x62 * x73
    x97 = x92 * (x36 - x88)
    x98 = x92 * (-x50 * x62 - x55)
    x99 = x62 * x69
    x100 = -x10 * x99 + x3 * x87 + x98
    x101 = x62 * x71
    x102 = -x10 * x101 + x100 * x67 + x3 * x89 + x97
    x103 = -x10 * x96 + x102 * x72 + x3 * x90 + x95
    x104 = -x10 * x76 + x103 * x74 + x3 * x91 + x94
    x105 = x92 * (x54 - x63)
    x106 = -2 * x19 * x20 * x24 * x29 * x49
    x107 = x42 * (-x106 - x32 * x57)
    x108 = x30 * boys(6, x17)
    x109 = x108 * x33 + x57 * x7
    x110 = x107 + x109 * x33 + x58 * x7
    x111 = x110 * x33 + x43 * (x51 - x59) + x60 * x7
    x112 = -x108 * x68 + x3 * x57
    x113 = -x109 * x68 + x112 * x67 + x3 * x58
    x114 = -x110 * x68 + x113 * x72 + x3 * x60
    x115 = x92 * (x53 - x64)
    x116 = x92 * (x51 - x70)
    x117 = x92 * (-x106 - x57 * x62)
    x118 = -x112 * x68 + x117 + x3 * x69
    x119 = -x113 * x68 + x116 + x118 * x67 + x3 * x71
    x120 = -x114 * x68 + x115 + x119 * x72 + x3 * x73
    x121 = x62 * x90
    x122 = x46 * x62
    x123 = x35 * x68
    x124 = -x123 + x3 * x31
    x125 = x36 * x62
    x126 = -x10 * x125 + x124 * x67 + x3 * x40
    x127 = -x10 * x122 + x126 * x72 + x3 * x82
    x128 = x92 * (-x122 + x82)
    x129 = x92 * (-x125 + x40)
    x130 = x92 * (-x35 * x62 - x47)
    x131 = x62 * x87
    x132 = -x10 * x131 + x124 * x3 + x130
    x133 = x62 * x89
    x134 = -x10 * x133 + x126 * x3 + x129 + x132 * x67
    x135 = -x10 * x121 + x127 * x3 + x128 + x134 * x72
    x136 = (
        -x103 * x68
        + x135 * x3
        + x72
        * (
            -x102 * x68
            + x134 * x3
            + x67
            * (
                -x100 * x68
                + x132 * x3
                + x93 * (-x123 - x131 + 2 * x18 * x19 * x20 * x24 * x29 * x3)
            )
            + x93 * (x126 - x133)
        )
        + x93 * (-x121 + x127)
    )
    x137 = x126 * x62
    x138 = x31 * x68
    x139 = -x138 + x3 * x39
    x140 = x40 * x62
    x141 = -x10 * x140 + x139 * x67 + x3 * x80
    x142 = x124 * x62
    x143 = x92 * (-x31 * x62 - x44)
    x144 = -x10 * x142 + x139 * x3 + x143
    x145 = x92 * (-x140 + x80)
    x146 = -x10 * x137 + x141 * x3 + x144 * x67 + x145
    x147 = (
        -x134 * x68
        + x146 * x3
        + x67
        * (
            -x132 * x68
            + x144 * x3
            + x93 * (-x138 - x142 + 2 * x19 * x20 * x24 * x29 * x3 * x38)
        )
        + x93 * (-x137 + x141)
    )
    x148 = x147 * x25
    x149 = x146 * x25
    x150 = x104 + x135 * x25 + x25 * (x135 + x149)
    x151 = x146 * x26
    x152 = x11 - C[1]
    x153 = x13 * x32
    x154 = x152 * x39 + x153 * x31
    x155 = x152 * x31 + x153 * x35
    x156 = x155 * x32
    x157 = x10 * x156 + x154 * x7
    x158 = x157 * x62
    x159 = x152 * x79 + x153 * x39
    x160 = x154 * x32
    x161 = x10 * x160 + x159 * x7
    x162 = x92 * (-x158 + x161)
    x163 = x155 * x62
    x164 = x92 * (x154 - x163)
    x165 = x10 * x163
    x166 = x154 * x3 - x165
    x167 = x152 * x35 + x153 * x50
    x168 = x167 * x62
    x169 = x10 * x168
    x170 = x155 * x3 - x169
    x171 = x170 * x62
    x172 = -x10 * x171 + x164 + x166 * x3
    x173 = -x10 * x158 + x161 * x3 + x166 * x67
    x174 = x167 * x32
    x175 = x10 * x174 + x155 * x7
    x176 = x175 * x62
    x177 = -x10 * x176 + x157 * x3 + x170 * x67
    x178 = x177 * x62
    x179 = -x10 * x178 + x162 + x172 * x67 + x173 * x3
    x180 = x151 + x179
    x181 = x42 * (x154 - x156)
    x182 = x157 * x7 + x175 * x33 + x181
    x183 = x182 * x62
    x184 = x42 * (x159 - x160)
    x185 = x157 * x33 + x161 * x7 + x184
    x186 = x92 * (-x183 + x185)
    x187 = -x10 * x183 + x177 * x72 + x185 * x3
    x188 = x42 * (x155 - x174)
    x189 = x152 * x50 + x153 * x57
    x190 = x189 * x32
    x191 = x10 * x190 + x167 * x7
    x192 = x175 * x7 + x188 + x191 * x33
    x193 = x192 * x62
    x194 = x189 * x62
    x195 = -x10 * x194 + x167 * x3
    x196 = x191 * x62
    x197 = -x10 * x196 + x175 * x3 + x195 * x67
    x198 = -x10 * x193 + x182 * x3 + x197 * x72
    x199 = x198 * x62
    x200 = x92 * (x157 - x176)
    x201 = x92 * (x155 - x168)
    x202 = x195 * x62
    x203 = -x10 * x202 + x170 * x3 + x201
    x204 = x197 * x62
    x205 = -x10 * x204 + x177 * x3 + x200 + x203 * x67
    x206 = -x10 * x199 + x186 + x187 * x3 + x205 * x72
    x207 = x135 * x26 + x180 * x25 + x206
    x208 = x147 * x26
    x209 = (
        x179 * x3
        - x205 * x68
        + x67 * (x172 * x3 - x203 * x68 + x93 * (x154 * x3 - x165 - x171))
        + x93 * (x173 - x178)
    )
    x210 = x208 + x209
    x211 = x92 * (x167 - x194)
    x212 = x108 * x153 + x152 * x57
    x213 = x189 * x3 - x212 * x68
    x214 = x195 * x3 + x211 - x213 * x68
    x215 = x92 * (x175 - x196)
    x216 = x189 * x7 + x212 * x33
    x217 = x191 * x3 + x213 * x67 - x216 * x68
    x218 = x197 * x3 + x214 * x67 + x215 - x217 * x68
    x219 = x92 * (x182 - x193)
    x220 = x42 * (x167 - x190)
    x221 = x191 * x7 + x216 * x33 + x220
    x222 = (
        x206 * x3
        - x68
        * (x198 * x3 + x218 * x72 + x219 - x68 * (x192 * x3 + x217 * x72 - x221 * x68))
        + x72
        * (
            x205 * x3
            - x218 * x68
            + x67 * (x203 * x3 - x214 * x68 + x93 * (x155 * x3 - x169 - x202))
            + x93 * (x177 - x204)
        )
        + x93 * (x187 - x199)
    )
    x223 = x135 * x27 + x149 * x27
    x224 = x13 * x156 + x152 * x154 + x45
    x225 = x13 * x174 + x152 * x155 + x48
    x226 = x224 * x7 + x225 * x33
    x227 = x226 * x62
    x228 = x13 * x160 + x152 * x159 + x81
    x229 = x224 * x33 + x228 * x7
    x230 = x92 * (-x227 + x229)
    x231 = x225 * x62
    x232 = x92 * (x224 - x231)
    x233 = x10 * x231
    x234 = x224 * x3 - x233
    x235 = x13 * x190 + x152 * x167 + x56
    x236 = x235 * x62
    x237 = -x10 * x236 + x225 * x3
    x238 = x237 * x62
    x239 = -x10 * x238 + x232 + x234 * x3
    x240 = -x10 * x227 + x229 * x3 + x234 * x67
    x241 = x225 * x7 + x235 * x33
    x242 = x241 * x62
    x243 = -x10 * x242 + x226 * x3 + x237 * x67
    x244 = x243 * x62
    x245 = -x10 * x244 + x230 + x239 * x67 + x240 * x3
    x246 = x179 * x26 + x245
    x247 = x180 * x26 + x246
    x248 = x92 * (x225 - x236)
    x249 = x107 + x152 * x189 + x153 * x212
    x250 = x235 * x3 - x249 * x68
    x251 = x237 * x3 + x248 - x250 * x68
    x252 = x92 * (x226 - x242)
    x253 = x235 * x7 + x249 * x33
    x254 = (
        x209 * x26
        + x245 * x3
        + x67 * (x239 * x3 - x251 * x68 + x93 * (x224 * x3 - x233 - x238))
        - x68
        * (x243 * x3 + x251 * x67 + x252 - x68 * (x241 * x3 + x250 * x67 - x253 * x68))
        + x93 * (x240 - x244)
    )
    x255 = x179 * x27
    x256 = x151 * x27 + x255
    x257 = x209 * x27
    x258 = x21 * x28
    x259 = x154 * x62
    x260 = x92 * (x159 - x259)
    x261 = x10 * x259
    x262 = x166 * x62
    x263 = -x10 * x262 + x260 + x3 * (x159 * x3 - x261)
    x264 = x25 * x263
    x265 = x179 * x25 + x206 + x25 * (x179 + x264)
    x266 = -x172 * x68 + x263 * x3 + x93 * (x159 * x3 - x261 - x262)
    x267 = x25 * x266
    x268 = x26 * x263
    x269 = x224 * x62
    x270 = x92 * (x228 - x269)
    x271 = x10 * x269
    x272 = x234 * x62
    x273 = -x10 * x272 + x270 + x3 * (x228 * x3 - x271)
    x274 = x268 + x273
    x275 = x246 + x25 * x274
    x276 = x26 * x266
    x277 = -x239 * x68 + x273 * x3 + x93 * (x228 * x3 - x271 - x272)
    x278 = x276 + x277
    x279 = x255 + x264 * x27
    x280 = x152 * x228 + x153 * x224 + 2 * x184
    x281 = x152 * x224 + x153 * x225 + 2 * x181
    x282 = x281 * x62
    x283 = x10 * x282
    x284 = x152 * x225 + x153 * x235 + 2 * x188
    x285 = x284 * x62
    x286 = -x10 * x285 + x281 * x3
    x287 = x286 * x62
    x288 = x92 * (x280 - x282)
    x289 = -x10 * x287 + x288 + x3 * (x280 * x3 - x283)
    x290 = x92 * (x281 - x285)
    x291 = x152 * x235 + x153 * x249 + 2 * x220
    x292 = x26 * x273 + x26 * x274 + x289
    x293 = x268 * x27 + x27 * x273
    x294 = -x12 - A[1]
    x295 = x13 * x84
    x296 = -x13 * x63 + x294 * x54
    x297 = x296 * x62
    x298 = x92 * (x294 * x83 - x295 - x297)
    x299 = x122 * x13
    x300 = x13 * x85
    x301 = x294 * x46 - x300
    x302 = x301 * x62
    x303 = x92 * (x294 * x82 - x299 - x302)
    x304 = x294 * x82 - x299
    x305 = x13 * x62
    x306 = x305 * x35
    x307 = x294 * x31 - x306
    x308 = x305 * x50
    x309 = x294 * x35 - x308
    x310 = x309 * x62
    x311 = -x10 * x310 + x3 * x307
    x312 = x125 * x13
    x313 = x294 * x40 - x312
    x314 = x13 * x88
    x315 = x294 * x36 - x314
    x316 = x315 * x62
    x317 = -x10 * x316 + x3 * x313 + x311 * x67
    x318 = -x10 * x302 + x3 * x304 + x317 * x72
    x319 = -x13 * x64 + x294 * x53
    x320 = x319 * x62
    x321 = x294 * x50 - x305 * x57
    x322 = x321 * x62
    x323 = -x10 * x322 + x3 * x309
    x324 = -x13 * x70 + x294 * x51
    x325 = x324 * x62
    x326 = -x10 * x325 + x3 * x315 + x323 * x67
    x327 = -x10 * x320 + x3 * x301 + x326 * x72
    x328 = x92 * (x294 * x40 - x312 - x316)
    x329 = x92 * (2 * x18 * x19 * x20 * x24 * x29 * x294 - x306 - x310)
    x330 = (
        x3 * x318
        + x303
        - x327 * x68
        + x72 * (x3 * x317 - x326 * x68 + x328 + x67 * (x3 * x311 - x323 * x68 + x329))
    )
    x331 = x13 * x140
    x332 = x313 * x62
    x333 = x92 * (x294 * x80 - x331 - x332)
    x334 = x305 * x31
    x335 = x307 * x62
    x336 = x92 * (2 * x19 * x20 * x24 * x29 * x294 * x38 - x334 - x335)
    x337 = x294 * x39 - x334
    x338 = -x10 * x335 + x3 * x337
    x339 = x294 * x80 - x331
    x340 = -x10 * x332 + x3 * x339 + x338 * x67
    x341 = x3 * x340 - x317 * x68 + x333 + x67 * (x3 * x338 - x311 * x68 + x336)
    x342 = x25 * x341
    x343 = x294 * x83 - x295
    x344 = -x10 * x297 + x3 * x343 + x327 * x74
    x345 = x92 * (x294 * x46 - x300 - x320)
    x346 = -x110 * x305 + x294 * x60
    x347 = -x108 * x305 + x294 * x57
    x348 = x3 * x321 - x347 * x68
    x349 = -x109 * x305 + x294 * x58
    x350 = x3 * x324 + x348 * x67 - x349 * x68
    x351 = x3 * x319 - x346 * x68 + x350 * x72
    x352 = x92 * (x294 * x36 - x314 - x325)
    x353 = x92 * (2 * x19 * x20 * x24 * x29 * x294 * x34 - x308 - x322)
    x354 = -x111 * x305 + x294 * x61
    x355 = (
        x25 * x330
        + x25 * (x330 + x342)
        + x298
        + x3 * x344
        - x68 * (x296 * x3 + x351 * x74 - x354 * x68)
        + x74
        * (
            x3 * x327
            + x345
            - x351 * x68
            + x72
            * (x3 * x326 - x350 * x68 + x352 + x67 * (x3 * x323 - x348 * x68 + x353))
        )
    )
    x356 = x26 * x341
    x357 = -x13 * x176 + x157 * x294 + x315 * x67
    x358 = x357 * x62
    x359 = -x13 * x158 + x161 * x294 + x313 * x67
    x360 = x92 * (-x358 + x359)
    x361 = -x13 * x168 + x155 * x294 + x309 * x67
    x362 = x361 * x62
    x363 = -x13 * x163 + x154 * x294 + x307 * x67
    x364 = x92 * (-x362 + x363)
    x365 = -x10 * x362 + x3 * x363
    x366 = -x13 * x194 + x167 * x294 + x321 * x67
    x367 = x366 * x62
    x368 = -x10 * x367 + x3 * x361
    x369 = -x10 * x358 + x3 * x359 + x365 * x67
    x370 = -x13 * x196 + x175 * x294 + x324 * x67
    x371 = x370 * x62
    x372 = -x10 * x371 + x3 * x357 + x368 * x67
    x373 = x3 * x369 + x360 - x372 * x68 + x67 * (x3 * x365 + x364 - x368 * x68)
    x374 = x356 + x373
    x375 = -x13 * x193 + x182 * x294 + x319 * x67
    x376 = x375 * x62
    x377 = -x13 * x183 + x185 * x294 + x301 * x67
    x378 = x92 * (-x376 + x377)
    x379 = -x10 * x376 + x3 * x377 + x372 * x72
    x380 = x92 * (x357 - x371)
    x381 = x92 * (x361 - x367)
    x382 = x189 * x294 - x212 * x305 + x347 * x67
    x383 = x3 * x366 - x382 * x68
    x384 = x191 * x294 - x216 * x305 + x349 * x67
    x385 = x3 * x370 + x383 * x67 - x384 * x68
    x386 = x192 * x294 - x221 * x305 + x346 * x67
    x387 = (
        x3 * x379
        + x378
        - x68 * (x3 * x375 + x385 * x72 - x386 * x68)
        + x72 * (x3 * x372 + x380 - x385 * x68 + x67 * (x3 * x368 + x381 - x383 * x68))
    )
    x388 = x25 * x374 + x26 * x330 + x387
    x389 = x27 * x330 + x27 * x342
    x390 = -x13 * x242 + x226 * x294 + x370 * x72
    x391 = x390 * x62
    x392 = -x13 * x227 + x229 * x294 + x357 * x72
    x393 = x92 * (-x391 + x392)
    x394 = -x13 * x236 + x225 * x294 + x366 * x72
    x395 = x394 * x62
    x396 = -x13 * x231 + x224 * x294 + x361 * x72
    x397 = x92 * (-x395 + x396)
    x398 = -x10 * x395 + x3 * x396
    x399 = x235 * x294 - x249 * x305 + x382 * x72
    x400 = x3 * x394 - x399 * x68
    x401 = -x10 * x391 + x3 * x392 + x398 * x67
    x402 = x241 * x294 - x253 * x305 + x384 * x72
    x403 = (
        x26 * x373
        + x3 * x401
        + x393
        + x67 * (x3 * x398 + x397 - x400 * x68)
        - x68 * (x3 * x390 + x400 * x67 - x402 * x68)
    )
    x404 = x26 * x374 + x403
    x405 = x27 * x373
    x406 = x27 * x356 + x405
    x407 = x22 * x28
    x408 = x28 * x341
    x409 = x363 * x62
    x410 = -x13 * x259 + x159 * x294 + x337 * x67
    x411 = x92 * (-x409 + x410)
    x412 = -x10 * x409 + x3 * x410
    x413 = x3 * x412 - x365 * x68 + x411
    x414 = x25 * x413
    x415 = x25 * x373 + x25 * (x373 + x414) + x387
    x416 = x26 * x413
    x417 = x396 * x62
    x418 = -x13 * x269 + x228 * x294 + x363 * x72
    x419 = x92 * (-x417 + x418)
    x420 = -x10 * x417 + x3 * x418
    x421 = x3 * x420 - x398 * x68 + x419
    x422 = x416 + x421
    x423 = x25 * x422 + x403
    x424 = x27 * x414 + x405
    x425 = -x13 * x285 + x281 * x294 + x394 * x74
    x426 = x425 * x62
    x427 = -x13 * x282 + x280 * x294 + x396 * x74
    x428 = x92 * (-x426 + x427)
    x429 = -x10 * x426 + x3 * x427
    x430 = x284 * x294 - x291 * x305 + x399 * x74
    x431 = x26 * x421 + x26 * x422 + x3 * x429 + x428 - x68 * (x3 * x425 - x430 * x68)
    x432 = x27 * x416 + x27 * x421
    x433 = x28 * x413
    x434 = -x14 - A[2]
    x435 = x15 * x84
    x436 = -x15 * x63 + x434 * x54
    x437 = x436 * x62
    x438 = x92 * (x434 * x83 - x435 - x437)
    x439 = x122 * x15
    x440 = x15 * x85
    x441 = x434 * x46 - x440
    x442 = x441 * x62
    x443 = x92 * (x434 * x82 - x439 - x442)
    x444 = x434 * x82 - x439
    x445 = x15 * x62
    x446 = x35 * x445
    x447 = x31 * x434 - x446
    x448 = x3 * x447
    x449 = x445 * x50
    x450 = x35 * x434 - x449
    x451 = x450 * x62
    x452 = x10 * x451
    x453 = x448 - x452
    x454 = x125 * x15
    x455 = x40 * x434 - x454
    x456 = x3 * x455
    x457 = x15 * x88
    x458 = x36 * x434 - x457
    x459 = x458 * x62
    x460 = -x10 * x459 + x453 * x67 + x456
    x461 = -x10 * x442 + x3 * x444 + x460 * x72
    x462 = x3 * x441
    x463 = -x15 * x64 + x434 * x53
    x464 = x463 * x62
    x465 = x10 * x464
    x466 = x3 * x450
    x467 = x434 * x50 - x445 * x57
    x468 = x467 * x62
    x469 = x10 * x468
    x470 = x466 - x469
    x471 = x3 * x458
    x472 = -x15 * x70 + x434 * x51
    x473 = x472 * x62
    x474 = x10 * x473
    x475 = x470 * x67 + x471 - x474
    x476 = x462 - x465 + x475 * x72
    x477 = x92 * (x40 * x434 - x454 - x459)
    x478 = x92 * (2 * x18 * x19 * x20 * x24 * x29 * x434 - x446 - x451)
    x479 = (
        x3 * x461
        + x443
        - x476 * x68
        + x72 * (x3 * x460 - x475 * x68 + x477 + x67 * (x3 * x453 - x470 * x68 + x478))
    )
    x480 = x140 * x15
    x481 = x455 * x62
    x482 = x92 * (x434 * x80 - x480 - x481)
    x483 = x31 * x445
    x484 = x447 * x62
    x485 = x92 * (2 * x19 * x20 * x24 * x29 * x38 * x434 - x483 - x484)
    x486 = x39 * x434 - x483
    x487 = x3 * x486
    x488 = -x10 * x484 + x487
    x489 = x434 * x80 - x480
    x490 = -x10 * x481 + x3 * x489 + x488 * x67
    x491 = x3 * x490 - x460 * x68 + x482 + x67 * (x3 * x488 - x453 * x68 + x485)
    x492 = x434 * x83 - x435
    x493 = -x10 * x437 + x3 * x492 + x476 * x74
    x494 = x92 * (x434 * x46 - x440 - x464)
    x495 = x3 * x463
    x496 = -x110 * x445 + x434 * x60
    x497 = x496 * x68
    x498 = x3 * x467
    x499 = -x108 * x445 + x434 * x57
    x500 = x499 * x68
    x501 = x498 - x500
    x502 = x3 * x472
    x503 = -x109 * x445 + x434 * x58
    x504 = x503 * x68
    x505 = x501 * x67 + x502 - x504
    x506 = x495 - x497 + x505 * x72
    x507 = x92 * (x36 * x434 - x457 - x473)
    x508 = x92 * (2 * x19 * x20 * x24 * x29 * x34 * x434 - x449 - x468)
    x509 = -x111 * x445 + x434 * x61
    x510 = (
        x25 * x479
        + x25 * (x25 * x491 + x479)
        + x3 * x493
        + x438
        - x68 * (x3 * x436 + x506 * x74 - x509 * x68)
        + x74
        * (
            x3 * x476
            + x494
            - x506 * x68
            + x72
            * (x3 * x475 - x505 * x68 + x507 + x67 * (x3 * x470 - x501 * x68 + x508))
        )
    )
    x511 = x15 * x158
    x512 = x15 * x176
    x513 = x157 * x434 - x512
    x514 = x513 * x62
    x515 = x92 * (x161 * x434 - x511 - x514)
    x516 = x15 * x163
    x517 = x15 * x168
    x518 = x155 * x434 - x517
    x519 = x518 * x62
    x520 = x92 * (x154 * x434 - x516 - x519)
    x521 = x154 * x434 - x516
    x522 = x3 * x521
    x523 = -x10 * x519 + x522
    x524 = x3 * x518
    x525 = -x15 * x194 + x167 * x434
    x526 = x525 * x62
    x527 = x10 * x526
    x528 = x524 - x527
    x529 = x161 * x434 - x511
    x530 = -x10 * x514 + x3 * x529 + x523 * x67
    x531 = x3 * x513
    x532 = -x15 * x196 + x175 * x434
    x533 = x532 * x62
    x534 = x10 * x533
    x535 = x528 * x67 + x531 - x534
    x536 = x3 * x530 + x515 - x535 * x68 + x67 * (x3 * x523 + x520 - x528 * x68)
    x537 = x26 * x491 + x536
    x538 = x15 * x183
    x539 = -x15 * x193 + x182 * x434
    x540 = x539 * x62
    x541 = x92 * (x185 * x434 - x538 - x540)
    x542 = x185 * x434 - x538
    x543 = -x10 * x540 + x3 * x542 + x535 * x72
    x544 = x92 * (x157 * x434 - x512 - x533)
    x545 = x92 * (x155 * x434 - x517 - x526)
    x546 = x3 * x525
    x547 = x189 * x434 - x212 * x445
    x548 = x547 * x68
    x549 = x546 - x548
    x550 = x3 * x532
    x551 = x191 * x434 - x216 * x445
    x552 = x551 * x68
    x553 = x549 * x67 + x550 - x552
    x554 = x192 * x434 - x221 * x445
    x555 = (
        x3 * x543
        + x541
        - x68 * (x3 * x539 + x553 * x72 - x554 * x68)
        + x72 * (x3 * x535 + x544 - x553 * x68 + x67 * (x3 * x528 + x545 - x549 * x68))
    )
    x556 = x25 * x537 + x26 * x479 + x555
    x557 = x458 * x67
    x558 = x92 * (x455 * x67 - x557 * x62)
    x559 = x450 * x67
    x560 = x92 * (x447 * x67 - x559 * x62)
    x561 = x448 * x67 - x559 * x68
    x562 = x466 * x67 - x469 * x67
    x563 = x456 * x67 - x557 * x68 + x561 * x67
    x564 = x471 * x67 - x474 * x67 + x562 * x67
    x565 = x3 * x563 + x558 - x564 * x68 + x67 * (x3 * x561 + x560 - x562 * x68)
    x566 = x27 * x491 + x565
    x567 = x464 * x67
    x568 = x92 * (x441 * x67 - x567)
    x569 = x462 * x67 - x465 * x67 + x564 * x72
    x570 = x473 * x67
    x571 = x92 * (x458 * x67 - x570)
    x572 = x468 * x67
    x573 = x92 * (x450 * x67 - x572)
    x574 = x498 * x67 - x500 * x67
    x575 = x502 * x67 - x504 * x67 + x574 * x67
    x576 = (
        x3 * x569
        + x568
        - x68 * (x495 * x67 - x497 * x67 + x575 * x72)
        + x72 * (x3 * x564 + x571 - x575 * x68 + x67 * (x3 * x562 + x573 - x574 * x68))
    )
    x577 = x25 * x566 + x27 * x479 + x576
    x578 = x15 * x227
    x579 = -x15 * x242 + x226 * x434
    x580 = x579 * x62
    x581 = x92 * (x229 * x434 - x578 - x580)
    x582 = x15 * x231
    x583 = -x15 * x236 + x225 * x434
    x584 = x583 * x62
    x585 = x92 * (x224 * x434 - x582 - x584)
    x586 = x224 * x434 - x582
    x587 = x3 * x586
    x588 = x10 * x584
    x589 = x587 - x588
    x590 = x3 * x583
    x591 = x235 * x434 - x249 * x445
    x592 = x591 * x68
    x593 = x590 - x592
    x594 = x229 * x434 - x578
    x595 = -x10 * x580 + x3 * x594 + x589 * x67
    x596 = x241 * x434 - x253 * x445
    x597 = (
        x26 * x536
        + x3 * x595
        + x581
        + x67 * (x3 * x589 + x585 - x593 * x68)
        - x68 * (x3 * x579 + x593 * x67 - x596 * x68)
    )
    x598 = x26 * x537 + x597
    x599 = x533 * x67
    x600 = x92 * (x513 * x67 - x599)
    x601 = x526 * x67
    x602 = x92 * (x518 * x67 - x601)
    x603 = x524 * x67 - x527 * x67
    x604 = x546 * x67 - x548 * x67
    x605 = x531 * x67 - x534 * x67 + x603 * x67
    x606 = (
        x3 * x605
        + x600
        + x67 * (x3 * x603 + x602 - x604 * x68)
        - x68 * (x550 * x67 - x552 * x67 + x604 * x67)
    )
    x607 = x27 * x536 + x606
    x608 = x26 * x566 + x607
    x609 = x23 * x28
    x610 = x66 ** (-2.0)
    x611 = 2 * x610
    x612 = x92 * (2 * x458 * x610 - x473 * x611)
    x613 = x92 * (2 * x450 * x610 - x468 * x611)
    x614 = x466 * x611 - x469 * x611
    x615 = x498 * x611 - x500 * x611
    x616 = x471 * x611 - x474 * x611 + x614 * x67
    x617 = (
        x27 * x565
        + x3 * x616
        + x612
        + x67 * (x3 * x614 + x613 - x615 * x68)
        - x68 * (x502 * x611 - x504 * x611 + x615 * x67)
    )
    x618 = x27 * x566 + x617
    x619 = x15 * x259
    x620 = x521 * x62
    x621 = x92 * (x159 * x434 - x619 - x620)
    x622 = x159 * x434 - x619
    x623 = -x10 * x620 + x3 * x622
    x624 = x3 * x623 - x523 * x68 + x621
    x625 = x25 * x536 + x25 * (x25 * x624 + x536) + x555
    x626 = x15 * x269
    x627 = x586 * x62
    x628 = x92 * (x228 * x434 - x626 - x627)
    x629 = x228 * x434 - x626
    x630 = -x10 * x627 + x3 * x629
    x631 = x3 * x630 - x589 * x68 + x628
    x632 = x26 * x624 + x631
    x633 = x25 * x632 + x597
    x634 = x518 * x67
    x635 = x92 * (x521 * x67 - x62 * x634)
    x636 = x522 * x67 - x634 * x68
    x637 = x3 * x636 - x603 * x68 + x635
    x638 = x27 * x624 + x637
    x639 = x25 * x638 + x607
    x640 = x15 * x282
    x641 = -x15 * x285 + x281 * x434
    x642 = x62 * x641
    x643 = x92 * (x280 * x434 - x640 - x642)
    x644 = x280 * x434 - x640
    x645 = -x10 * x642 + x3 * x644
    x646 = x284 * x434 - x291 * x445
    x647 = x26 * x631 + x26 * x632 + x3 * x645 + x643 - x68 * (x3 * x641 - x646 * x68)
    x648 = x584 * x67
    x649 = x92 * (x586 * x67 - x648)
    x650 = x587 * x67 - x588 * x67
    x651 = x3 * x650 + x649 - x68 * (x590 * x67 - x592 * x67)
    x652 = x26 * x638 + x27 * x631 + x651
    x653 = x92 * (2 * x518 * x610 - x526 * x611)
    x654 = x524 * x611 - x527 * x611
    x655 = x27 * x637 + x3 * x654 + x653 - x68 * (x546 * x611 - x548 * x611)
    x656 = x27 * x638 + x655
    x657 = x447 * x67
    x658 = x92 * (x486 * x67 - x62 * x657)
    x659 = x487 * x67 - x657 * x68
    x660 = x3 * x659 - x561 * x68 + x658
    x661 = x25 * x565 + x25 * (x25 * x660 + x565) + x576
    x662 = x26 * x660 + x637
    x663 = x25 * x662 + x26 * x565 + x606
    x664 = x92 * (2 * x447 * x610 - x451 * x611)
    x665 = x448 * x611 - x452 * x611
    x666 = x3 * x665 - x614 * x68 + x664
    x667 = x27 * x660 + x666
    x668 = x25 * x667 + x617
    x669 = x26 * x637 + x26 * x662 + x651
    x670 = x26 * x667 + x655
    x671 = x66 ** (-3.0)
    x672 = 6 * x671
    x673 = x92 * (6 * x450 * x671 - x468 * x672)
    x674 = x466 * x672 - x469 * x672
    x675 = x27 * x666 + x27 * x667 + x3 * x674 + x673 - x68 * (x498 * x672 - x500 * x672)
    x676 = x25 * x340
    x677 = x25 * x318 + x25 * (x318 + x676) + x344
    x678 = x26 * x340
    x679 = x369 + x678
    x680 = x25 * x679 + x26 * x318 + x379
    x681 = x27 * x318 + x27 * x676
    x682 = x26 * x369 + x401
    x683 = x26 * x679 + x682
    x684 = x27 * x369
    x685 = x27 * x678 + x684
    x686 = x25 * x412
    x687 = x25 * x369 + x25 * (x369 + x686) + x379
    x688 = x26 * x412
    x689 = x420 + x688
    x690 = x25 * x689 + x682
    x691 = x27 * x686 + x684
    x692 = x26 * x420 + x26 * x689 + x429
    x693 = x27 * x420 + x27 * x688
    x694 = x128 - x13 * x302 + x294 * x304
    x695 = -x13 * x320 + x294 * x301 + x95
    x696 = -x13 * x310 + x130 + x294 * x307
    x697 = -x13 * x322 + x294 * x309 + x98
    x698 = x129 - x13 * x316 + x294 * x313
    x699 = -x13 * x325 + x294 * x315 + x97
    x700 = (
        x3 * x694
        - x68 * x695
        + x72 * (x3 * x698 + x67 * (x3 * x696 - x68 * x697) - x68 * x699)
    )
    x701 = -x13 * x335 + x143 + x294 * x337
    x702 = -x13 * x332 + x145 + x294 * x339
    x703 = x3 * x702 + x67 * (x3 * x701 - x68 * x696) - x68 * x698
    x704 = x25 * x703
    x705 = -x13 * x297 + x294 * x343 + x94
    x706 = x115 + x294 * x319 - x305 * x346
    x707 = x117 + x294 * x321 - x305 * x347
    x708 = x116 + x294 * x324 - x305 * x349
    x709 = x105 + x294 * x296 - x305 * x354
    x710 = (
        x25 * x700
        + x25 * (x700 + x704)
        + x3 * x705
        - x68 * x709
        + x74
        * (
            x3 * x695
            - x68 * x706
            + x72 * (x3 * x699 + x67 * (x3 * x697 - x68 * x707) - x68 * x708)
        )
    )
    x711 = x26 * x703
    x712 = -x13 * x362 + x164 + x294 * x363 + x67 * x696
    x713 = -x13 * x367 + x201 + x294 * x361 + x67 * x697
    x714 = -x13 * x358 + x162 + x294 * x359 + x67 * x698
    x715 = -x13 * x371 + x200 + x294 * x357 + x67 * x699
    x716 = x3 * x714 + x67 * (x3 * x712 - x68 * x713) - x68 * x715
    x717 = x711 + x716
    x718 = -x13 * x376 + x186 + x294 * x377 + x67 * x695
    x719 = x211 + x294 * x366 - x305 * x382 + x67 * x707
    x720 = x215 + x294 * x370 - x305 * x384 + x67 * x708
    x721 = x219 + x294 * x375 - x305 * x386 + x67 * x706
    x722 = (
        x3 * x718
        - x68 * x721
        + x72 * (x3 * x715 + x67 * (x3 * x713 - x68 * x719) - x68 * x720)
    )
    x723 = x25 * x717 + x26 * x700 + x722
    x724 = x27 * x700 + x27 * x704
    x725 = -x13 * x395 + x232 + x294 * x396 + x713 * x72
    x726 = x248 + x294 * x394 - x305 * x399 + x719 * x72
    x727 = -x13 * x391 + x230 + x294 * x392 + x715 * x72
    x728 = x252 + x294 * x390 - x305 * x402 + x72 * x720
    x729 = x26 * x716 + x3 * x727 + x67 * (x3 * x725 - x68 * x726) - x68 * x728
    x730 = x26 * x717 + x729
    x731 = x27 * x716
    x732 = x27 * x711 + x731
    x733 = x28 * x703
    x734 = -x13 * x409 + x260 + x294 * x410 + x67 * x701
    x735 = x3 * x734 - x68 * x712
    x736 = x25 * x735
    x737 = x25 * x716 + x25 * (x716 + x736) + x722
    x738 = x26 * x735
    x739 = -x13 * x417 + x270 + x294 * x418 + x712 * x72
    x740 = x3 * x739 - x68 * x725
    x741 = x738 + x740
    x742 = x25 * x741 + x729
    x743 = x27 * x736 + x731
    x744 = -x13 * x426 + x288 + x294 * x427 + x725 * x74
    x745 = x290 + x294 * x425 - x305 * x430 + x726 * x74
    x746 = x26 * x740 + x26 * x741 + x3 * x744 - x68 * x745
    x747 = x27 * x738 + x27 * x740
    x748 = x28 * x735
    x749 = -x13 * x442 + x294 * x444
    x750 = -x13 * x464 + x294 * x441
    x751 = x294 * x447
    x752 = x13 * x451
    x753 = x751 - x752
    x754 = x294 * x450
    x755 = x13 * x468
    x756 = x754 - x755
    x757 = -x13 * x459 + x294 * x455
    x758 = x294 * x458
    x759 = x13 * x473
    x760 = x758 - x759
    x761 = (
        x3 * x749
        - x68 * x750
        + x72 * (x3 * x757 + x67 * (x3 * x753 - x68 * x756) - x68 * x760)
    )
    x762 = -x13 * x484 + x294 * x486
    x763 = -x13 * x481 + x294 * x489
    x764 = x3 * x763 + x67 * (x3 * x762 - x68 * x753) - x68 * x757
    x765 = -x13 * x437 + x294 * x492
    x766 = x294 * x463
    x767 = x305 * x496
    x768 = x766 - x767
    x769 = x294 * x467
    x770 = x305 * x499
    x771 = x769 - x770
    x772 = x294 * x472
    x773 = x305 * x503
    x774 = x772 - x773
    x775 = x294 * x436 - x305 * x509
    x776 = (
        x25 * x761
        + x25 * (x25 * x764 + x761)
        + x3 * x765
        - x68 * x775
        + x74
        * (
            x3 * x750
            - x68 * x768
            + x72 * (x3 * x760 + x67 * (x3 * x756 - x68 * x771) - x68 * x774)
        )
    )
    x777 = -x13 * x519 + x294 * x521 + x67 * x753
    x778 = x294 * x518
    x779 = x13 * x526
    x780 = x67 * x756 + x778 - x779
    x781 = -x13 * x514 + x294 * x529 + x67 * x757
    x782 = -x13 * x533 + x294 * x513 + x67 * x760
    x783 = x3 * x781 + x67 * (x3 * x777 - x68 * x780) - x68 * x782
    x784 = x26 * x764 + x783
    x785 = -x13 * x540 + x294 * x542 + x67 * x750
    x786 = x294 * x525
    x787 = x305 * x547
    x788 = x67 * x771 + x786 - x787
    x789 = x294 * x532
    x790 = x305 * x551
    x791 = x67 * x774 + x789 - x790
    x792 = x294 * x539 - x305 * x554 + x67 * x768
    x793 = (
        x3 * x785
        - x68 * x792
        + x72 * (x3 * x782 + x67 * (x3 * x780 - x68 * x788) - x68 * x791)
    )
    x794 = x25 * x784 + x26 * x761 + x793
    x795 = x455 * x67
    x796 = x294 * x795 - x305 * x557
    x797 = -x13 * x570 + x294 * x557
    x798 = x294 * x657 - x305 * x559
    x799 = -x13 * x572 + x294 * x559
    x800 = x3 * x796 + x67 * (x3 * x798 - x68 * x799) - x68 * x797
    x801 = x27 * x764 + x800
    x802 = x441 * x67
    x803 = -x13 * x567 + x294 * x802
    x804 = x67 * x772 - x67 * x773
    x805 = x67 * x769 - x67 * x770
    x806 = x67 * x766 - x67 * x767
    x807 = (
        x3 * x803
        - x68 * x806
        + x72 * (x3 * x797 + x67 * (x3 * x799 - x68 * x805) - x68 * x804)
    )
    x808 = x25 * x801 + x27 * x761 + x807
    x809 = -x13 * x584 + x294 * x586 + x72 * x780
    x810 = x294 * x583
    x811 = x305 * x591
    x812 = x72 * x788 + x810 - x811
    x813 = -x13 * x580 + x294 * x594 + x72 * x782
    x814 = x294 * x579 - x305 * x596 + x72 * x791
    x815 = x26 * x783 + x3 * x813 + x67 * (x3 * x809 - x68 * x812) - x68 * x814
    x816 = x26 * x784 + x815
    x817 = -x13 * x601 + x294 * x634 + x67 * x799
    x818 = x67 * x786 - x67 * x787 + x67 * x805
    x819 = x513 * x67
    x820 = -x13 * x599 + x294 * x819 + x67 * x797
    x821 = x67 * x789 - x67 * x790 + x67 * x804
    x822 = x3 * x820 + x67 * (x3 * x817 - x68 * x818) - x68 * x821
    x823 = x27 * x783 + x822
    x824 = x26 * x801 + x823
    x825 = x611 * x754 - x611 * x755
    x826 = x611 * x769 - x611 * x770
    x827 = x611 * x758 - x611 * x759
    x828 = x611 * x772 - x611 * x773
    x829 = x27 * x800 + x3 * x827 + x67 * (x3 * x825 - x68 * x826) - x68 * x828
    x830 = x27 * x801 + x829
    x831 = -x13 * x620 + x294 * x622 + x67 * x762
    x832 = x3 * x831 - x68 * x777
    x833 = x25 * x783 + x25 * (x25 * x832 + x783) + x793
    x834 = -x13 * x627 + x294 * x629 + x72 * x777
    x835 = x3 * x834 - x68 * x809
    x836 = x26 * x832 + x835
    x837 = x25 * x836 + x815
    x838 = x521 * x67
    x839 = x294 * x838 - x305 * x634 + x67 * x798
    x840 = x3 * x839 - x68 * x817
    x841 = x27 * x832 + x840
    x842 = x25 * x841 + x823
    x843 = -x13 * x642 + x294 * x644 + x74 * x809
    x844 = x294 * x641 - x305 * x646 + x74 * x812
    x845 = x26 * x835 + x26 * x836 + x3 * x843 - x68 * x844
    x846 = x586 * x67
    x847 = -x13 * x648 + x294 * x846 + x72 * x817
    x848 = x67 * x810 - x67 * x811 + x72 * x818
    x849 = x3 * x847 - x68 * x848
    x850 = x26 * x841 + x27 * x835 + x849
    x851 = x611 * x778 - x611 * x779 + x67 * x825
    x852 = x611 * x786 - x611 * x787 + x67 * x826
    x853 = x27 * x840 + x3 * x851 - x68 * x852
    x854 = x27 * x841 + x853
    x855 = x486 * x67
    x856 = x294 * x855 - x305 * x657
    x857 = x3 * x856 - x68 * x798
    x858 = x25 * x800 + x25 * (x25 * x857 + x800) + x807
    x859 = x26 * x857 + x840
    x860 = x25 * x859 + x26 * x800 + x822
    x861 = x611 * x751 - x611 * x752
    x862 = x3 * x861 - x68 * x825
    x863 = x27 * x857 + x862
    x864 = x25 * x863 + x829
    x865 = x26 * x840 + x26 * x859 + x849
    x866 = x26 * x863 + x853
    x867 = x672 * x754 - x672 * x755
    x868 = x672 * x769 - x672 * x770
    x869 = x27 * x862 + x27 * x863 + x3 * x867 - x68 * x868
    x870 = x25 * x461 + x25 * (x25 * x490 + x461) + x493
    x871 = x26 * x490 + x530
    x872 = x25 * x871 + x26 * x461 + x543
    x873 = x27 * x490 + x563
    x874 = x25 * x873 + x27 * x461 + x569
    x875 = x26 * x530 + x595
    x876 = x26 * x871 + x875
    x877 = x27 * x530 + x605
    x878 = x26 * x873 + x877
    x879 = x27 * x563 + x616
    x880 = x27 * x873 + x879
    x881 = x25 * x530 + x25 * (x25 * x623 + x530) + x543
    x882 = x26 * x623 + x630
    x883 = x25 * x882 + x875
    x884 = x27 * x623 + x636
    x885 = x25 * x884 + x877
    x886 = x26 * x630 + x26 * x882 + x645
    x887 = x26 * x884 + x27 * x630 + x650
    x888 = x27 * x636 + x654
    x889 = x27 * x884 + x888
    x890 = x25 * x563 + x25 * (x25 * x659 + x563) + x569
    x891 = x26 * x659 + x636
    x892 = x25 * x891 + x26 * x563 + x605
    x893 = x27 * x659 + x665
    x894 = x25 * x893 + x879
    x895 = x26 * x636 + x26 * x891 + x650
    x896 = x26 * x893 + x888
    x897 = x27 * x665 + x27 * x893 + x674
    x898 = x128 - x15 * x442 + x434 * x444
    x899 = -x15 * x464 + x434 * x441 + x95
    x900 = x434 * x447
    x901 = x15 * x451
    x902 = x130 + x900 - x901
    x903 = x434 * x450
    x904 = x15 * x468
    x905 = x903 - x904 + x98
    x906 = x129 - x15 * x459 + x434 * x455
    x907 = x434 * x458
    x908 = x15 * x473
    x909 = x907 - x908 + x97
    x910 = (
        x3 * x898
        - x68 * x899
        + x72 * (x3 * x906 + x67 * (x3 * x902 - x68 * x905) - x68 * x909)
    )
    x911 = x143 - x15 * x484 + x434 * x486
    x912 = x145 - x15 * x481 + x434 * x489
    x913 = x3 * x912 + x67 * (x3 * x911 - x68 * x902) - x68 * x906
    x914 = -x15 * x437 + x434 * x492 + x94
    x915 = x434 * x463
    x916 = x445 * x496
    x917 = x115 + x915 - x916
    x918 = x434 * x467
    x919 = x445 * x499
    x920 = x117 + x918 - x919
    x921 = x434 * x472
    x922 = x445 * x503
    x923 = x116 + x921 - x922
    x924 = x105 + x434 * x436 - x445 * x509
    x925 = (
        x25 * x910
        + x25 * (x25 * x913 + x910)
        + x3 * x914
        - x68 * x924
        + x74
        * (
            x3 * x899
            - x68 * x917
            + x72 * (x3 * x909 + x67 * (x3 * x905 - x68 * x920) - x68 * x923)
        )
    )
    x926 = -x15 * x519 + x164 + x434 * x521
    x927 = x434 * x518
    x928 = x15 * x526
    x929 = x201 + x927 - x928
    x930 = -x15 * x514 + x162 + x434 * x529
    x931 = -x15 * x533 + x200 + x434 * x513
    x932 = x3 * x930 + x67 * (x3 * x926 - x68 * x929) - x68 * x931
    x933 = x26 * x913 + x932
    x934 = -x15 * x540 + x186 + x434 * x542
    x935 = x434 * x525
    x936 = x445 * x547
    x937 = x211 + x935 - x936
    x938 = x434 * x532
    x939 = x445 * x551
    x940 = x215 + x938 - x939
    x941 = x219 + x434 * x539 - x445 * x554
    x942 = (
        x3 * x934
        - x68 * x941
        + x72 * (x3 * x931 + x67 * (x3 * x929 - x68 * x937) - x68 * x940)
    )
    x943 = x25 * x933 + x26 * x910 + x942
    x944 = x434 * x657 - x445 * x559 + x67 * x902
    x945 = -x15 * x572 + x434 * x559 + x67 * x905
    x946 = x434 * x795 - x445 * x557 + x67 * x906
    x947 = -x15 * x570 + x434 * x557 + x67 * x909
    x948 = x3 * x946 + x67 * (x3 * x944 - x68 * x945) - x68 * x947
    x949 = x27 * x913 + x948
    x950 = -x15 * x567 + x434 * x802 + x67 * x899
    x951 = x67 * x918 - x67 * x919 + x67 * x920
    x952 = x67 * x921 - x67 * x922 + x67 * x923
    x953 = x67 * x915 - x67 * x916 + x67 * x917
    x954 = (
        x3 * x950
        - x68 * x953
        + x72 * (x3 * x947 + x67 * (x3 * x945 - x68 * x951) - x68 * x952)
    )
    x955 = x25 * x949 + x27 * x910 + x954
    x956 = -x15 * x584 + x232 + x434 * x586
    x957 = x434 * x583
    x958 = x445 * x591
    x959 = x248 + x957 - x958
    x960 = -x15 * x580 + x230 + x434 * x594
    x961 = x252 + x434 * x579 - x445 * x596
    x962 = x26 * x932 + x3 * x960 + x67 * (x3 * x956 - x68 * x959) - x68 * x961
    x963 = x26 * x933 + x962
    x964 = -x15 * x601 + x434 * x634 + x67 * x929
    x965 = x67 * x935 - x67 * x936 + x67 * x937
    x966 = -x15 * x599 + x434 * x819 + x67 * x931
    x967 = x67 * x938 - x67 * x939 + x67 * x940
    x968 = x3 * x966 + x67 * (x3 * x964 - x68 * x965) - x68 * x967
    x969 = x27 * x932 + x968
    x970 = x26 * x949 + x969
    x971 = x611 * x903 - x611 * x904 + x72 * x945
    x972 = x611 * x918 - x611 * x919 + x72 * x951
    x973 = x611 * x907 - x611 * x908 + x72 * x947
    x974 = x611 * x921 - x611 * x922 + x72 * x952
    x975 = x27 * x948 + x3 * x973 + x67 * (x3 * x971 - x68 * x972) - x68 * x974
    x976 = x27 * x949 + x975
    x977 = -x15 * x620 + x260 + x434 * x622
    x978 = x3 * x977 - x68 * x926
    x979 = x25 * x932 + x25 * (x25 * x978 + x932) + x942
    x980 = -x15 * x627 + x270 + x434 * x629
    x981 = x3 * x980 - x68 * x956
    x982 = x26 * x978 + x981
    x983 = x25 * x982 + x962
    x984 = x434 * x838 - x445 * x634 + x67 * x926
    x985 = x3 * x984 - x68 * x964
    x986 = x27 * x978 + x985
    x987 = x25 * x986 + x969
    x988 = -x15 * x642 + x288 + x434 * x644
    x989 = x290 + x434 * x641 - x445 * x646
    x990 = x26 * x981 + x26 * x982 + x3 * x988 - x68 * x989
    x991 = -x15 * x648 + x434 * x846 + x67 * x956
    x992 = x67 * x957 - x67 * x958 + x67 * x959
    x993 = x3 * x991 - x68 * x992
    x994 = x26 * x986 + x27 * x981 + x993
    x995 = x611 * x927 - x611 * x928 + x72 * x964
    x996 = x611 * x935 - x611 * x936 + x72 * x965
    x997 = x27 * x985 + x3 * x995 - x68 * x996
    x998 = x27 * x986 + x997
    x999 = x434 * x855 - x445 * x657 + x67 * x911
    x1000 = x3 * x999 - x68 * x944
    x1001 = x25 * x948 + x25 * (x1000 * x25 + x948) + x954
    x1002 = x1000 * x26 + x985
    x1003 = x1002 * x25 + x26 * x948 + x968
    x1004 = x611 * x900 - x611 * x901 + x72 * x944
    x1005 = x1004 * x3 - x68 * x971
    x1006 = x1000 * x27 + x1005
    x1007 = x1006 * x25 + x975
    x1008 = x1002 * x26 + x26 * x985 + x993
    x1009 = x1006 * x26 + x997
    x1010 = x672 * x903 - x672 * x904 + x74 * x971
    x1011 = x672 * x918 - x672 * x919 + x74 * x972
    x1012 = x1005 * x27 + x1006 * x27 + x1010 * x3 - x1011 * x68
    x1013 = x25 * x702
    x1014 = x25 * x694 + x25 * (x1013 + x694) + x705
    x1015 = x26 * x702
    x1016 = x1015 + x714
    x1017 = x1016 * x25 + x26 * x694 + x718
    x1018 = x1013 * x27 + x27 * x694
    x1019 = x26 * x714 + x727
    x1020 = x1016 * x26 + x1019
    x1021 = x27 * x714
    x1022 = x1015 * x27 + x1021
    x1023 = x25 * x734
    x1024 = x25 * x714 + x25 * (x1023 + x714) + x718
    x1025 = x26 * x734
    x1026 = x1025 + x739
    x1027 = x1019 + x1026 * x25
    x1028 = x1021 + x1023 * x27
    x1029 = x1026 * x26 + x26 * x739 + x744
    x1030 = x1025 * x27 + x27 * x739
    x1031 = x294 * x694 + 2 * x303 - x305 * x695
    x1032 = x294 * x702 - x305 * x698 + 2 * x333
    x1033 = x1032 * x25
    x1034 = x1032 * x26
    x1035 = (
        x294 * x714
        - x305 * x715
        + 2 * x360
        + x67 * (x294 * x698 - x305 * x699 + 2 * x328)
    )
    x1036 = x1034 + x1035
    x1037 = (
        x294 * x718
        - x305 * x721
        + 2 * x378
        + x67 * (x294 * x695 - x305 * x706 + 2 * x345)
    )
    x1038 = (
        x1035 * x26
        + x294 * x727
        - x305 * x728
        + 2 * x393
        + x72
        * (
            x294 * x715
            - x305 * x720
            + 2 * x380
            + x67 * (x294 * x699 - x305 * x708 + 2 * x352)
        )
    )
    x1039 = x1035 * x27
    x1040 = (
        x294 * x734
        - x305 * x712
        + 2 * x411
        + x67 * (x294 * x701 - x305 * x696 + 2 * x336)
    )
    x1041 = x1040 * x25
    x1042 = x1040 * x26
    x1043 = (
        x294 * x739
        - x305 * x725
        + 2 * x419
        + x72
        * (
            x294 * x712
            - x305 * x713
            + 2 * x364
            + x67 * (x294 * x696 - x305 * x697 + 2 * x329)
        )
    )
    x1044 = x1042 + x1043
    x1045 = x294 * x749 - x305 * x750 + x443
    x1046 = x294 * x763 - x305 * x757 + x482
    x1047 = x1045 * x25 + x25 * (x1045 + x1046 * x25) + x294 * x765 - x305 * x775 + x438
    x1048 = x294 * x781 - x305 * x782 + x515 + x67 * (x294 * x757 - x305 * x760 + x477)
    x1049 = x1046 * x26 + x1048
    x1050 = x294 * x785 - x305 * x792 + x541 + x67 * (x294 * x750 - x305 * x768 + x494)
    x1051 = x1045 * x26 + x1049 * x25 + x1050
    x1052 = x294 * x796 - x305 * x797 + x558
    x1053 = x1046 * x27 + x1052
    x1054 = x294 * x803 - x305 * x806 + x568
    x1055 = x1045 * x27 + x1053 * x25 + x1054
    x1056 = (
        x1048 * x26
        + x294 * x813
        - x305 * x814
        + x581
        + x72
        * (x294 * x782 - x305 * x791 + x544 + x67 * (x294 * x760 - x305 * x774 + x507))
    )
    x1057 = x1049 * x26 + x1056
    x1058 = x294 * x820 - x305 * x821 + x600 + x67 * (x294 * x797 - x305 * x804 + x571)
    x1059 = x1048 * x27 + x1058
    x1060 = x1053 * x26 + x1059
    x1061 = x1052 * x27 + x294 * x827 - x305 * x828 + x612
    x1062 = x1053 * x27 + x1061
    x1063 = x294 * x831 - x305 * x777 + x621 + x67 * (x294 * x762 - x305 * x753 + x485)
    x1064 = x1048 * x25 + x1050 + x25 * (x1048 + x1063 * x25)
    x1065 = (
        x294 * x834
        - x305 * x80