import numpy


def kinetic3d_00(a, A, b, B):
    """Cartesian 3D (ss) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = -a
    x1 = (a + b) ** (-1.0)
    x2 = (2.0 * a + 2.0 * b) ** (-1.0)
    x3 = 2.0 * a**2
    x4 = a * b * x1
    x5 = (
        5.56832799683171
        * x1**1.5
        * numpy.exp(-x4 * (A[0] - B[0]) ** 2)
        * numpy.exp(-x4 * (A[1] - B[1]) ** 2)
        * numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    )

    # 1 item(s)
    return numpy.array(
        [
            x5 * (-x0 - x3 * (x2 + (x1 * (a * A[0] + b * B[0]) - A[0]) ** 2))
            + x5 * (-x0 - x3 * (x2 + (x1 * (a * A[1] + b * B[1]) - A[1]) ** 2))
            + x5 * (-x0 - x3 * (x2 + (x1 * (a * A[2] + b * B[2]) - A[2]) ** 2))
        ]
    )


def kinetic3d_01(a, A, b, B):
    """Cartesian 3D (sp) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = -a
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = 2.0 * a
    x4 = (2.0 * b + x3) ** (-1.0)
    x5 = 2.0 * a**2
    x6 = -x0 - x5 * (x4 + (-x2 - A[0]) ** 2)
    x7 = numpy.sqrt(x1)
    x8 = 1.77245385090552 * x7
    x9 = b * x1
    x10 = a * x9
    x11 = numpy.exp(-x10 * (A[0] - B[0]) ** 2)
    x12 = x11 * (-x2 - B[0])
    x13 = x12 * x8
    x14 = x3 * x9
    x15 = numpy.exp(-x10 * (A[1] - B[1]) ** 2)
    x16 = numpy.exp(-x10 * (A[2] - B[2]) ** 2)
    x17 = 3.14159265358979 * x1 * x16
    x18 = 5.56832799683171 * x7
    x19 = x12 * x18
    x20 = -x1 * (a * A[1] + b * B[1])
    x21 = x15 * (-x0 - x5 * (x4 + (-x20 - A[1]) ** 2))
    x22 = x1 * x16 * x21
    x23 = -x1 * (a * A[2] + b * B[2])
    x24 = x16 * (-x0 - x5 * (x4 + (-x23 - A[2]) ** 2))
    x25 = x1 * x15
    x26 = -x20 - B[1]
    x27 = x26 * x8
    x28 = x11 * x25
    x29 = x18 * x26 * x28
    x30 = x16 * x6
    x31 = -x23 - B[2]
    x32 = x31 * x8
    x33 = x18 * x31

    # 3 item(s)
    return numpy.array(
        [
            x15 * x17 * (x13 * x14 + x13 * x6) + x19 * x22 + x19 * x24 * x25,
            x11 * x17 * (x14 * x15 * x27 + x21 * x27) + x24 * x29 + x29 * x30,
            x11 * x22 * x33
            + x28 * x30 * x33
            + 3.14159265358979 * x28 * (x14 * x16 * x32 + x24 * x32),
        ]
    )


def kinetic3d_02(a, A, b, B):
    """Cartesian 3D (sd) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (a + b) ** (-1.0)
    x1 = -x0 * (a * A[0] + b * B[0])
    x2 = -x1 - B[0]
    x3 = -a
    x4 = 2.0 * a
    x5 = 2.0 * b
    x6 = (x4 + x5) ** (-1.0)
    x7 = 2.0 * a**2
    x8 = -x3 - x7 * (x6 + (-x1 - A[0]) ** 2)
    x9 = a * x0
    x10 = b * x9
    x11 = numpy.exp(-x10 * (A[0] - B[0]) ** 2)
    x12 = numpy.sqrt(x0)
    x13 = 1.77245385090552 * x12
    x14 = x11 * x13
    x15 = x14 * x2
    x16 = b * x0 * x4
    x17 = x15 * x16 + x15 * x8
    x18 = x14 * x6
    x19 = x14 * x2**2 + x18
    x20 = numpy.exp(-x10 * (A[1] - B[1]) ** 2)
    x21 = numpy.exp(-x10 * (A[2] - B[2]) ** 2)
    x22 = 3.14159265358979 * x0 * x21
    x23 = x20 * x22
    x24 = -x0 * (a * A[1] + b * B[1])
    x25 = -x3 - x7 * (x6 + (-x24 - A[1]) ** 2)
    x26 = x19 * x23
    x27 = -x0 * (a * A[2] + b * B[2])
    x28 = -x3 - x7 * (x6 + (-x27 - A[2]) ** 2)
    x29 = -x24 - B[1]
    x30 = x13 * x20
    x31 = x29 * x30
    x32 = x16 * x31 + x25 * x31
    x33 = x11 * x22
    x34 = x32 * x33
    x35 = x17 * x23
    x36 = 5.56832799683171
    x37 = x0 * x11 * x20
    x38 = x12 * x2 * x21 * x36 * x37
    x39 = -x27 - B[2]
    x40 = x13 * x21
    x41 = x39 * x40
    x42 = x16 * x41 + x28 * x41
    x43 = 3.14159265358979 * x37
    x44 = x42 * x43
    x45 = x30 * x6
    x46 = x29**2 * x30 + x45
    x47 = x33 * x46
    x48 = x40 * x6
    x49 = x39**2 * x40 + x48
    x50 = x43 * x49

    # 6 item(s)
    return numpy.array(
        [
            x23 * (x17 * x2 + x18 * x8 + x9 * (-2.0 * x14 + x19 * x5))
            + x25 * x26
            + x26 * x28,
            x2 * x34 + x28 * x29 * x38 + x29 * x35,
            x2 * x44 + x25 * x38 * x39 + x35 * x39,
            x28 * x47
            + x33 * (x25 * x45 + x29 * x32 + x9 * (-2.0 * x30 + x46 * x5))
            + x47 * x8,
            x12 * x21 * x29 * x36 * x37 * x39 * x8 + x29 * x44 + x34 * x39,
            x25 * x50
            + x43 * (x28 * x48 + x39 * x42 + x9 * (-2.0 * x40 + x49 * x5))
            + x50 * x8,
        ]
    )


def kinetic3d_03(a, A, b, B):
    """Cartesian 3D (sf) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - B[0]
    x6 = -a
    x7 = 2.0 * a**2
    x8 = -x6 - x7 * (x2 + (-x4 - A[0]) ** 2)
    x9 = a * x3
    x10 = b * x9
    x11 = numpy.exp(-x10 * (A[0] - B[0]) ** 2)
    x12 = 1.77245385090552 * numpy.sqrt(x3)
    x13 = x11 * x12
    x14 = 2.0 * x13
    x15 = x13 * x5
    x16 = 4.0 * x10
    x17 = b * x0 * x3
    x18 = x15 * x17 + x15 * x8
    x19 = x13 * x2
    x20 = x13 * x5**2 + x19
    x21 = x18 * x5 + x19 * x8 + x9 * (x1 * x20 - x14)
    x22 = 2.0 * x19 * x5 + x20 * x5
    x23 = numpy.exp(-x10 * (A[1] - B[1]) ** 2)
    x24 = numpy.exp(-x10 * (A[2] - B[2]) ** 2)
    x25 = 3.14159265358979 * x24 * x3
    x26 = x23 * x25
    x27 = -x3 * (a * A[1] + b * B[1])
    x28 = -x6 - x7 * (x2 + (-x27 - A[1]) ** 2)
    x29 = x22 * x26
    x30 = -x3 * (a * A[2] + b * B[2])
    x31 = -x6 - x7 * (x2 + (-x30 - A[2]) ** 2)
    x32 = -x27 - B[1]
    x33 = x12 * x23
    x34 = x32 * x33
    x35 = x17 * x34 + x28 * x34
    x36 = x12 * x24
    x37 = x21 * x26
    x38 = x20 * x26
    x39 = -x30 - B[2]
    x40 = x36 * x39
    x41 = x17 * x40 + x31 * x40
    x42 = x2 * x33
    x43 = x32**2 * x33 + x42
    x44 = 2.0 * x33
    x45 = x28 * x42 + x32 * x35 + x9 * (x1 * x43 - x44)
    x46 = x11 * x25
    x47 = x45 * x46
    x48 = x46 * x5
    x49 = 3.14159265358979 * x11 * x23 * x3
    x50 = x49 * x5
    x51 = x2 * x36
    x52 = x36 * x39**2 + x51
    x53 = 2.0 * x36
    x54 = x31 * x51 + x39 * x41 + x9 * (x1 * x52 - x53)
    x55 = x49 * x54
    x56 = 2.0 * x32 * x42 + x32 * x43
    x57 = x46 * x56
    x58 = 2.0 * x39 * x51 + x39 * x52
    x59 = x49 * x58

    # 10 item(s)
    return numpy.array(
        [
            x26
            * (x2 * (x14 * x5 * x8 + x15 * x16) + x21 * x5 + x9 * (x1 * x22 - 3.0 * x15))
            + x28 * x29
            + x29 * x31,
            x20 * x35 * x36 + x31 * x32 * x38 + x32 * x37,
            x20 * x33 * x41 + x28 * x38 * x39 + x37 * x39,
            x18 * x36 * x43 + x31 * x43 * x48 + x47 * x5,
            x18 * x26 * x32 * x39 + x32 * x41 * x50 + x35 * x39 * x48,
            x18 * x33 * x52 + x28 * x50 * x52 + x5 * x55,
            x31 * x57
            + x46
            * (
                x2 * (x16 * x34 + x28 * x32 * x44)
                + x32 * x45
                + x9 * (x1 * x56 - 3.0 * x34)
            )
            + x57 * x8,
            x13 * x41 * x43 + x39 * x43 * x46 * x8 + x39 * x47,
            x13 * x35 * x52 + x32 * x49 * x52 * x8 + x32 * x55,
            x28 * x59
            + x49
            * (
                x2 * (x16 * x40 + x31 * x39 * x53)
                + x39 * x54
                + x9 * (x1 * x58 - 3.0 * x40)
            )
            + x59 * x8,
        ]
    )


def kinetic3d_04(a, A, b, B):
    """Cartesian 3D (sg) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - B[0]
    x6 = -a
    x7 = 2.0 * a**2
    x8 = -x6 - x7 * (x2 + (-x4 - A[0]) ** 2)
    x9 = a * x3
    x10 = b * x9
    x11 = numpy.exp(-x10 * (A[0] - B[0]) ** 2)
    x12 = 1.77245385090552 * numpy.sqrt(x3)
    x13 = x11 * x12
    x14 = x13 * x5
    x15 = b * x0 * x3
    x16 = x14 * x15 + x14 * x8
    x17 = x16 * x5
    x18 = x13 * x5**2
    x19 = x13 * x2
    x20 = x18 + x19
    x21 = 2.0 * x13
    x22 = x9 * (x1 * x20 - x21)
    x23 = x19 * x8
    x24 = 4.0 * x10
    x25 = x17 + x22 + x23
    x26 = 2.0 * x19 * x5 + x20 * x5
    x27 = x2 * (x14 * x24 + x21 * x5 * x8) + x25 * x5 + x9 * (x1 * x26 - 3.0 * x14)
    x28 = x2 * (3.0 * x18 + 3.0 * x19) + x26 * x5
    x29 = numpy.exp(-x10 * (A[1] - B[1]) ** 2)
    x30 = numpy.exp(-x10 * (A[2] - B[2]) ** 2)
    x31 = 3.14159265358979 * x3 * x30
    x32 = x29 * x31
    x33 = -x3 * (a * A[1] + b * B[1])
    x34 = -x6 - x7 * (x2 + (-x33 - A[1]) ** 2)
    x35 = x28 * x32
    x36 = -x3 * (a * A[2] + b * B[2])
    x37 = -x6 - x7 * (x2 + (-x36 - A[2]) ** 2)
    x38 = -x33 - B[1]
    x39 = x12 * x29
    x40 = x38 * x39
    x41 = x15 * x40 + x34 * x40
    x42 = x12 * x30
    x43 = x41 * x42
    x44 = x27 * x32
    x45 = x26 * x32
    x46 = -x36 - B[2]
    x47 = x42 * x46
    x48 = x15 * x47 + x37 * x47
    x49 = x38 * x41
    x50 = x38**2 * x39
    x51 = x2 * x39
    x52 = x50 + x51
    x53 = 2.0 * x39
    x54 = x9 * (x1 * x52 - x53)
    x55 = x34 * x51
    x56 = x49 + x54 + x55
    x57 = x20 * x42
    x58 = x46 * x48
    x59 = x42 * x46**2
    x60 = x2 * x42
    x61 = x59 + x60
    x62 = 2.0 * x42
    x63 = x9 * (x1 * x61 - x62)
    x64 = x37 * x60
    x65 = x58 + x63 + x64
    x66 = x20 * x39
    x67 = 2.0 * x38 * x51 + x38 * x52
    x68 = x2 * (x24 * x40 + x34 * x38 * x53) + x38 * x56 + x9 * (x1 * x67 - 3.0 * x40)
    x69 = x11 * x31
    x70 = x68 * x69
    x71 = x5 * x69
    x72 = 3.14159265358979 * x11 * x29 * x3
    x73 = x5 * x72
    x74 = 2.0 * x46 * x60 + x46 * x61
    x75 = x2 * (x24 * x47 + x37 * x46 * x62) + x46 * x65 + x9 * (x1 * x74 - 3.0 * x47)
    x76 = x72 * x75
    x77 = x2 * (3.0 * x50 + 3.0 * x51) + x38 * x67
    x78 = x69 * x77
    x79 = x13 * x52
    x80 = x2 * (3.0 * x59 + 3.0 * x60) + x46 * x74
    x81 = x72 * x80

    # 15 item(s)
    return numpy.array(
        [
            x32
            * (
                x2 * (3.0 * x17 + 3.0 * x22 + 3.0 * x23)
                + x27 * x5
                + x9 * (2.0 * b * x28 - 4.0 * x18 - 4.0 * x19)
            )
            + x34 * x35
            + x35 * x37,
            x26 * x43 + x37 * x38 * x45 + x38 * x44,
            x26 * x39 * x48 + x34 * x45 * x46 + x44 * x46,
            x25 * x42 * x52 + x37 * x52 * x57 + x56 * x57,
            x20 * x40 * x48 + x20 * x43 * x46 + x25 * x32 * x38 * x46,
            x25 * x39 * x61 + x34 * x61 * x66 + x65 * x66,
            x16 * x42 * x67 + x37 * x67 * x71 + x5 * x70,
            x14 * x48 * x52 + x16 * x47 * x52 + x46 * x56 * x71,
            x14 * x41 * x61 + x16 * x40 * x61 + x38 * x65 * x73,
            x16 * x39 * x74 + x34 * x73 * x74 + x5 * x76,
            x37 * x78
            + x69
            * (
                x2 * (3.0 * x49 + 3.0 * x54 + 3.0 * x55)
                + x38 * x68
                + x9 * (2.0 * b * x77 - 4.0 * x50 - 4.0 * x51)
            )
            + x78 * x8,
            x13 * x48 * x67 + x46 * x67 * x69 * x8 + x46 * x70,
            x13 * x56 * x61 + x61 * x79 * x8 + x65 * x79,
            x13 * x41 * x74 + x38 * x72 * x74 * x8 + x38 * x76,
            x34 * x81
            + x72
            * (
                x2 * (3.0 * x58 + 3.0 * x63 + 3.0 * x64)
                + x46 * x75
                + x9 * (2.0 * b * x80 - 4.0 * x59 - 4.0 * x60)
            )
            + x8 * x81,
        ]
    )


def kinetic3d_10(a, A, b, B):
    """Cartesian 3D (ps) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = -a
    x1 = (a + b) ** (-1.0)
    x2 = x1 * (a * A[0] + b * B[0]) - A[0]
    x3 = 2.0 * a
    x4 = (2.0 * b + x3) ** (-1.0)
    x5 = 2.0 * a**2
    x6 = -x0 - x5 * (x2**2 + x4)
    x7 = numpy.sqrt(x1)
    x8 = 1.77245385090552 * x7
    x9 = b * x1
    x10 = a * x9
    x11 = numpy.exp(-x10 * (A[0] - B[0]) ** 2)
    x12 = x11 * x2
    x13 = x12 * x8
    x14 = x3 * x9
    x15 = numpy.exp(-x10 * (A[1] - B[1]) ** 2)
    x16 = numpy.exp(-x10 * (A[2] - B[2]) ** 2)
    x17 = 3.14159265358979 * x1 * x16
    x18 = 5.56832799683171 * x7
    x19 = x12 * x18
    x20 = x1 * (a * A[1] + b * B[1]) - A[1]
    x21 = x15 * (-x0 - x5 * (x20**2 + x4))
    x22 = x1 * x16 * x21
    x23 = x1 * (a * A[2] + b * B[2]) - A[2]
    x24 = x16 * (-x0 - x5 * (x23**2 + x4))
    x25 = x1 * x15
    x26 = x20 * x8
    x27 = x11 * x25
    x28 = x18 * x20 * x27
    x29 = x16 * x6
    x30 = x23 * x8
    x31 = x18 * x23

    # 3 item(s)
    return numpy.array(
        [
            x15 * x17 * (x13 * x14 + x13 * x6) + x19 * x22 + x19 * x24 * x25,
            x11 * x17 * (x14 * x15 * x26 + x21 * x26) + x24 * x28 + x28 * x29,
            x11 * x22 * x31
            + x27 * x29 * x31
            + 3.14159265358979 * x27 * (x14 * x16 * x30 + x24 * x30),
        ]
    )


def kinetic3d_11(a, A, b, B):
    """Cartesian 3D (pp) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (a + b) ** (-1.0)
    x1 = -x0 * (a * A[0] + b * B[0])
    x2 = -x1 - A[0]
    x3 = -a
    x4 = 2.0 * a
    x5 = (2.0 * b + x4) ** (-1.0)
    x6 = 2.0 * a**2
    x7 = -x3 - x6 * (x2**2 + x5)
    x8 = numpy.sqrt(x0)
    x9 = 1.77245385090552 * x8
    x10 = b * x0
    x11 = a * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = x12 * (-x1 - B[0])
    x14 = x13 * x9
    x15 = x10 * x4
    x16 = x14 * x15 + x14 * x7
    x17 = x5 * x9
    x18 = x12 * x17
    x19 = x14 * x2 + x18
    x20 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x21 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x22 = 3.14159265358979 * x0 * x21
    x23 = x20 * x22
    x24 = -x0 * (a * A[1] + b * B[1])
    x25 = -x24 - A[1]
    x26 = -x3 - x6 * (x25**2 + x5)
    x27 = x19 * x23
    x28 = -x0 * (a * A[2] + b * B[2])
    x29 = -x28 - A[2]
    x30 = -x3 - x6 * (x29**2 + x5)
    x31 = -x24 - B[1]
    x32 = x20 * x31
    x33 = x26 * x9
    x34 = x32 * x9
    x35 = x15 * x34 + x32 * x33
    x36 = x12 * x2
    x37 = x36 * x9
    x38 = x23 * (x15 * x37 + x37 * x7)
    x39 = x0 * x32
    x40 = 5.56832799683171 * x21 * x8
    x41 = x36 * x40
    x42 = -x28 - B[2]
    x43 = x21 * x9
    x44 = x30 * x43
    x45 = x42 * x43
    x46 = x15 * x45 + x42 * x44
    x47 = x0 * x20
    x48 = 3.14159265358979 * x47
    x49 = x26 * x47
    x50 = x16 * x23
    x51 = x20 * x25
    x52 = x15 * x51 * x9 + x33 * x51
    x53 = x0 * x51
    x54 = x40 * x53
    x55 = x17 * x20
    x56 = x25 * x34 + x55
    x57 = x12 * x22
    x58 = x56 * x57
    x59 = 3.14159265358979 * x12
    x60 = x12 * x7
    x61 = x15 * x29 * x43 + x29 * x44
    x62 = x29 * x40
    x63 = x17 * x21
    x64 = x29 * x45 + x63
    x65 = x12 * x48
    x66 = x64 * x65

    # 9 item(s)
    return numpy.array(
        [
            x23 * (x15 * x19 + x16 * x2 + x18 * x7) + x26 * x27 + x27 * x30,
            x22 * x35 * x36 + x30 * x39 * x41 + x31 * x38,
            x36 * x46 * x48 + x38 * x42 + x41 * x42 * x49,
            x13 * x22 * x52 + x13 * x30 * x54 + x25 * x50,
            x30 * x58 + x57 * (x15 * x56 + x25 * x35 + x26 * x55) + x58 * x7,
            x42 * x52 * x57 + x42 * x54 * x60 + x46 * x53 * x59,
            x13 * x48 * x61 + x13 * x49 * x62 + x29 * x50,
            x29 * x35 * x57 + x39 * x59 * x61 + x39 * x60 * x62,
            x26 * x66 + x65 * (x15 * x64 + x29 * x46 + x30 * x63) + x66 * x7,
        ]
    )


def kinetic3d_12(a, A, b, B):
    """Cartesian 3D (pd) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - B[0]
    x6 = -a
    x7 = -x4 - A[0]
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7**2)
    x10 = a * x3
    x11 = b * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = 1.77245385090552 * numpy.sqrt(x3)
    x14 = x12 * x13
    x15 = 2.0 * x14
    x16 = x14 * x5
    x17 = 4.0 * x11
    x18 = b * x0
    x19 = x18 * x3
    x20 = x16 * x19 + x16 * x9
    x21 = x14 * x2
    x22 = x14 * x5**2 + x21
    x23 = x21 * x9
    x24 = x10 * (x1 * x22 - x15) + x20 * x5 + x23
    x25 = x3 * (2.0 * x21 * x5 + x22 * x7)
    x26 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x27 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x28 = 3.14159265358979 * x27 * x3
    x29 = x26 * x28
    x30 = -x3 * (a * A[1] + b * B[1])
    x31 = -x30 - A[1]
    x32 = -x6 - x8 * (x2 + x31**2)
    x33 = 3.14159265358979 * x26
    x34 = x25 * x27 * x33
    x35 = -x3 * (a * A[2] + b * B[2])
    x36 = -x35 - A[2]
    x37 = -x6 - x8 * (x2 + x36**2)
    x38 = -x30 - B[1]
    x39 = x13 * x26
    x40 = x32 * x39
    x41 = x38 * x39
    x42 = x19 * x41 + x38 * x40
    x43 = x16 * x7 + x21
    x44 = x13 * x27
    x45 = x29 * (x19 * x43 + x20 * x7 + x23)
    x46 = x29 * x43
    x47 = -x35 - B[2]
    x48 = x37 * x44
    x49 = x44 * x47
    x50 = x19 * x49 + x47 * x48
    x51 = x2 * x39
    x52 = x38**2 * x39 + x51
    x53 = x14 * x7
    x54 = x19 * x53 + x53 * x9
    x55 = 2.0 * x39
    x56 = x32 * x51
    x57 = x10 * (x1 * x52 - x55) + x38 * x42 + x56
    x58 = x12 * x28
    x59 = x57 * x58
    x60 = x58 * x7
    x61 = x12 * x3 * x33
    x62 = x61 * x7
    x63 = x29 * x47
    x64 = x2 * x44
    x65 = x44 * x47**2 + x64
    x66 = 2.0 * x44
    x67 = x37 * x64
    x68 = x10 * (x1 * x65 - x66) + x47 * x50 + x67
    x69 = x61 * x68
    x70 = x19 * x31 * x39 + x31 * x40
    x71 = x24 * x29
    x72 = x22 * x29
    x73 = x31 * x41 + x51
    x74 = x58 * (x19 * x73 + x31 * x42 + x56)
    x75 = x5 * x58
    x76 = x31 * x61
    x77 = x31 * x52 + 2.0 * x38 * x51
    x78 = x58 * x77
    x79 = x58 * x9
    x80 = x19 * x36 * x44 + x36 * x48
    x81 = x5 * x61
    x82 = x36 * x49 + x64
    x83 = x61 * (x19 * x82 + x36 * x50 + x67)
    x84 = x36 * x65 + 2.0 * x47 * x64
    x85 = x61 * x84

    # 18 item(s)
    return numpy.array(
        [
            x29 * (x18 * x25 + x2 * (x15 * x5 * x9 + x16 * x17) + x24 * x7)
            + x32 * x34
            + x34 * x37,
            x37 * x38 * x46 + x38 * x45 + x42 * x43 * x44,
            x32 * x46 * x47 + x39 * x43 * x50 + x45 * x47,
            x37 * x52 * x60 + x44 * x52 * x54 + x59 * x7,
            x38 * x50 * x62 + x38 * x54 * x63 + x42 * x47 * x60,
            x32 * x62 * x65 + x39 * x54 * x65 + x69 * x7,
            x22 * x44 * x70 + x31 * x37 * x72 + x31 * x71,
            x20 * x44 * x73 + x37 * x73 * x75 + x5 * x74,
            x20 * x31 * x63 + x47 * x70 * x75 + x5 * x50 * x76,
            x37 * x78
            + x58 * (x19 * x77 + x2 * (x17 * x41 + x32 * x38 * x55) + x31 * x57)
            + x78 * x9,
            x14 * x50 * x73 + x47 * x73 * x79 + x47 * x74,
            x14 * x65 * x70 + x31 * x69 + x65 * x76 * x9,
            x22 * x39 * x80 + x32 * x36 * x72 + x36 * x71,
            x20 * x29 * x36 * x38 + x36 * x42 * x75 + x38 * x80 * x81,
            x20 * x39 * x82 + x32 * x81 * x82 + x5 * x83,
            x14 * x52 * x80 + x36 * x52 * x79 + x36 * x59,
            x14 * x42 * x82 + x38 * x61 * x82 * x9 + x38 * x83,
            x32 * x85
            + x61 * (x19 * x84 + x2 * (x17 * x49 + x37 * x47 * x66) + x36 * x68)
            + x85 * x9,
        ]
    )


def kinetic3d_13(a, A, b, B):
    """Cartesian 3D (pf) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - B[0]
    x6 = -a
    x7 = -x4 - A[0]
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7**2)
    x10 = a * x3
    x11 = b * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = 1.77245385090552 * numpy.sqrt(x3)
    x14 = x12 * x13
    x15 = x14 * x5
    x16 = b * x0
    x17 = x16 * x3
    x18 = x15 * x17 + x15 * x9
    x19 = x18 * x5
    x20 = x14 * x5**2
    x21 = x14 * x2
    x22 = x20 + x21
    x23 = 2.0 * x14
    x24 = x10 * (x1 * x22 - x23)
    x25 = x21 * x9
    x26 = 4.0 * x11
    x27 = x2 * (x15 * x26 + x23 * x5 * x9)
    x28 = x19 + x24 + x25
    x29 = 2.0 * x21 * x5
    x30 = x22 * x5 + x29
    x31 = x10 * (x1 * x30 - 3.0 * x15) + x27 + x28 * x5
    x32 = x3 * (x2 * (3.0 * x20 + 3.0 * x21) + x30 * x7)
    x33 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x34 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x35 = 3.14159265358979 * x3 * x34
    x36 = x33 * x35
    x37 = -x3 * (a * A[1] + b * B[1])
    x38 = -x37 - A[1]
    x39 = -x6 - x8 * (x2 + x38**2)
    x40 = 3.14159265358979 * x33
    x41 = x32 * x34 * x40
    x42 = -x3 * (a * A[2] + b * B[2])
    x43 = -x42 - A[2]
    x44 = -x6 - x8 * (x2 + x43**2)
    x45 = x22 * x7 + x29
    x46 = -x37 - B[1]
    x47 = x13 * x33
    x48 = x46 * x47
    x49 = x17 * x48 + x39 * x48
    x50 = x13 * x34
    x51 = x49 * x50
    x52 = x36 * (x17 * x45 + x27 + x28 * x7)
    x53 = x36 * x45
    x54 = -x42 - B[2]
    x55 = x50 * x54
    x56 = x17 * x55 + x44 * x55
    x57 = x47 * x56
    x58 = x15 * x7 + x21
    x59 = x17 * x58 + x18 * x7 + x25
    x60 = x46**2 * x47
    x61 = x2 * x47
    x62 = x60 + x61
    x63 = x50 * x62
    x64 = x46 * x49
    x65 = 2.0 * x47
    x66 = x10 * (x1 * x62 - x65)
    x67 = x39 * x61
    x68 = x64 + x66 + x67
    x69 = x36 * x54
    x70 = x50 * x54**2
    x71 = x2 * x50
    x72 = x70 + x71
    x73 = x47 * x72
    x74 = x54 * x56
    x75 = 2.0 * x50
    x76 = x10 * (x1 * x72 - x75)
    x77 = x44 * x71
    x78 = x74 + x76 + x77
    x79 = 2.0 * x46 * x61
    x80 = x46 * x62 + x79
    x81 = x14 * x7
    x82 = x17 * x81 + x81 * x9
    x83 = x2 * (x26 * x48 + x39 * x46 * x65)
    x84 = x10 * (x1 * x80 - 3.0 * x48) + x46 * x68 + x83
    x85 = x12 * x35
    x86 = x84 * x85
    x87 = x7 * x85
    x88 = x12 * x3 * x40
    x89 = x7 * x88
    x90 = 2.0 * x54 * x71
    x91 = x54 * x72 + x90
    x92 = x2 * (x26 * x55 + x44 * x54 * x75)
    x93 = x10 * (x1 * x91 - 3.0 * x55) + x54 * x78 + x92
    x94 = x88 * x93
    x95 = x39 * x47
    x96 = x17 * x38 * x47 + x38 * x95
    x97 = x31 * x36
    x98 = x30 * x36
    x99 = x38 * x48 + x61
    x100 = x17 * x99 + x38 * x49 + x67
    x101 = x22 * x50
    x102 = x38 * x62 + x79
    x103 = x85 * (x102 * x17 + x38 * x68 + x83)
    x104 = x5 * x85
    x105 = x38 * x88
    x106 = x2 * (3.0 * x60 + 3.0 * x61) + x38 * x80
    x107 = x106 * x85
    x108 = x85 * x9
    x109 = x14 * x72
    x110 = x43 * x50
    x111 = x110 * x17 + x110 * x44
    x112 = x43 * x55 + x71
    x113 = x112 * x17 + x43 * x56 + x77
    x114 = x5 * x88
    x115 = x43 * x72 + x90
    x116 = x88 * (x115 * x17 + x43 * x78 + x92)
    x117 = x14 * x62
    x118 = x2 * (3.0 * x70 + 3.0 * x71) + x43 * x91
    x119 = x118 * x88

    # 30 item(s)
    return numpy.array(
        [
            x36 * (x16 * x32 + x2 * (3.0 * x19 + 3.0 * x24 + 3.0 * x25) + x31 * x7)
            + x39 * x41
            + x41 * x44,
            x44 * x46 * x53 + x45 * x51 + x46 * x52,
            x39 * x53 * x54 + x45 * x57 + x52 * x54,
            x44 * x58 * x63 + x50 * x58 * x68 + x59 * x63,
            x46 * x59 * x69 + x48 * x56 * x58 + x51 * x54 * x58,
            x39 * x58 * x73 + x47 * x58 * x78 + x59 * x73,
            x44 * x80 * x87 + x50 * x80 * x82 + x7 * x86,
            x54 * x68 * x87 + x55 * x62 * x82 + x56 * x62 * x81,
            x46 * x78 * x89 + x48 * x72 * x82 + x49 * x72 * x81,
            x39 * x89 * x91 + x47 * x82 * x91 + x7 * x94,
            x30 * x50 * x96 + x38 * x44 * x98 + x38 * x97,
            x100 * x101 + x101 * x44 * x99 + x28 * x50 * x99,
            x22 * x38 * x57 + x22 * x55 * x96 + x28 * x38 * x69,
            x102 * x104 * x44 + x102 * x18 * x50 + x103 * x5,
            x100 * x104 * x54 + x15 * x56 * x99 + x18 * x55 * x99,
            x105 * x5 * x78 + x15 * x72 * x96 + x18 * x38 * x73,
            x107 * x44
            + x107 * x9
            + x85 * (x106 * x17 + x2 * (3.0 * x64 + 3.0 * x66 + 3.0 * x67) + x38 * x84),
            x102 * x108 * x54 + x102 * x14 * x56 + x103 * x54,
            x100 * x109 + x109 * x9 * x99 + x14 * x78 * x99,
            x105 * x9 * x91 + x14 * x91 * x96 + x38 * x94,
            x111 * x30 * x47 + x39 * x43 * x98 + x43 * x97,
            x111 * x22 * x48 + x22 * x43 * x51 + x28 * x36 * x43 * x46,
            x112 * x22 * x95 + x112 * x28 * x47 + x113 * x22 * x47,
            x104 * x43 * x68 + x111 * x15 * x62 + x18 * x43 * x63,
            x112 * x15 * x49 + x112 * x18 * x48 + x113 * x114 * x46,
            x114 * x115 * x39 + x115 * x18 * x47 + x116 * x5,
            x108 * x43 * x80 + x111 * x14 * x80 + x43 * x86,
            x112 * x117 * x9 + x112 * x14 * x68 + x113 * x117,
            x115 * x14 * x49 + x115 * x46 * x88 * x9 + x116 * x46,
            x119 * x39
            + x119 * x9
            + x88 * (x118 * x17 + x2 * (3.0 * x74 + 3.0 * x76 + 3.0 * x77) + x43 * x93),
        ]
    )


def kinetic3d_14(a, A, b, B):
    """Cartesian 3D (pg) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - B[0]
    x6 = -a
    x7 = -x4 - A[0]
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7**2)
    x10 = a * x3
    x11 = b * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = 1.77245385090552 * numpy.sqrt(x3)
    x14 = x12 * x13
    x15 = 2.0 * x14
    x16 = x14 * x5
    x17 = 4.0 * x11
    x18 = x2 * (x15 * x5 * x9 + x16 * x17)
    x19 = b * x0
    x20 = x19 * x3
    x21 = x16 * x20 + x16 * x9
    x22 = x21 * x5
    x23 = x14 * x5**2
    x24 = x14 * x2
    x25 = x23 + x24
    x26 = x10 * (x1 * x25 - x15)
    x27 = x24 * x9
    x28 = x22 + x26 + x27
    x29 = x28 * x5
    x30 = x25 * x5
    x31 = x24 * x5
    x32 = 2.0 * x31
    x33 = x30 + x32
    x34 = x10 * (x1 * x33 - 3.0 * x16)
    x35 = x2 * (3.0 * x22 + 3.0 * x26 + 3.0 * x27)
    x36 = x18 + x29 + x34
    x37 = x2 * (3.0 * x23 + 3.0 * x24)
    x38 = x33 * x5 + x37
    x39 = x10 * (2.0 * b * x38 - 4.0 * x23 - 4.0 * x24) + x35 + x36 * x5
    x40 = x3 * (x2 * (4.0 * x30 + 8.0 * x31) + x38 * x7)
    x41 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x42 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x43 = 3.14159265358979 * x3 * x42
    x44 = x41 * x43
    x45 = -x3 * (a * A[1] + b * B[1])
    x46 = -x45 - A[1]
    x47 = -x6 - x8 * (x2 + x46**2)
    x48 = 3.14159265358979 * x41
    x49 = x40 * x42 * x48
    x50 = -x3 * (a * A[2] + b * B[2])
    x51 = -x50 - A[2]
    x52 = -x6 - x8 * (x2 + x51**2)
    x53 = x33 * x7 + x37
    x54 = -x45 - B[1]
    x55 = x13 * x41
    x56 = x54 * x55
    x57 = x20 * x56 + x47 * x56
    x58 = x13 * x42
    x59 = x57 * x58
    x60 = x44 * (x20 * x53 + x35 + x36 * x7)
    x61 = x44 * x53
    x62 = -x50 - B[2]
    x63 = x58 * x62
    x64 = x20 * x63 + x52 * x63
    x65 = x55 * x64
    x66 = x54 * x57
    x67 = x54**2 * x55
    x68 = x2 * x55
    x69 = x67 + x68
    x70 = 2.0 * x55
    x71 = x10 * (x1 * x69 - x70)
    x72 = x47 * x68
    x73 = x66 + x71 + x72
    x74 = x25 * x7 + x32
    x75 = x58 * x74
    x76 = x18 + x20 * x74 + x28 * x7
    x77 = x58 * x69
    x78 = x44 * x62
    x79 = x62 * x64
    x80 = x58 * x62**2
    x81 = x2 * x58
    x82 = x80 + x81
    x83 = 2.0 * x58
    x84 = x10 * (x1 * x82 - x83)
    x85 = x52 * x81
    x86 = x79 + x84 + x85
    x87 = x55 * x74
    x88 = x55 * x82
    x89 = x16 * x7 + x24
    x90 = x20 * x89 + x21 * x7 + x27
    x91 = x54 * x69
    x92 = x54 * x68
    x93 = 2.0 * x92
    x94 = x91 + x93
    x95 = x58 * x94
    x96 = x2 * (x17 * x56 + x47 * x54 * x70)
    x97 = x54 * x73
    x98 = x10 * (x1 * x94 - 3.0 * x56)
    x99 = x96 + x97 + x98
    x100 = x62 * x82
    x101 = x62 * x81
    x102 = 2.0 * x101
    x103 = x100 + x102
    x104 = x103 * x55
    x105 = x2 * (x17 * x63 + x52 * x62 * x83)
    x106 = x62 * x86
    x107 = x10 * (x1 * x103 - 3.0 * x63)
    x108 = x105 + x106 + x107
    x109 = x2 * (3.0 * x67 + 3.0 * x68)
    x110 = x109 + x54 * x94
    x111 = x14 * x7
    x112 = x111 * x20 + x111 * x9
    x113 = x2 * (3.0 * x66 + 3.0 * x71 + 3.0 * x72)
    x114 = x10 * (2.0 * b * x110 - 4.0 * x67 - 4.0 * x68) + x113 + x54 * x99
    x115 = x12 * x43
    x116 = x114 * x115
    x117 = x115 * x7
    x118 = x12 * x3 * x48
    x119 = x118 * x7
    x120 = x2 * (3.0 * x80 + 3.0 * x81)
    x121 = x103 * x62 + x120
    x122 = x2 * (3.0 * x79 + 3.0 * x84 + 3.0 * x85)
    x123 = x10 * (2.0 * b * x121 - 4.0 * x80 - 4.0 * x81) + x108 * x62 + x122
    x124 = x118 * x123
    x125 = x46 * x55
    x126 = x125 * x20 + x125 * x47
    x127 = x39 * x44
    x128 = x38 * x44
    x129 = x46 * x56 + x68
    x130 = x129 * x20 + x46 * x57 + x72
    x131 = x33 * x58
    x132 = x46 * x69 + x93
    x133 = x132 * x58
    x134 = x132 * x20 + x46 * x73 + x96
    x135 = x25 * x58
    x136 = x109 + x46 * x94
    x137 = x115 * (x113 + x136 * x20 + x46 * x99)
    x138 = x115 * x5
    x139 = x118 * x46
    x140 = x110 * x46 + x2 * (4.0 * x91 + 8.0 * x92)
    x141 = x115 * x140
    x142 = x115 * x9
    x143 = x132 * x14
    x144 = x103 * x14
    x145 = x51 * x58
    x146 = x145 * x20 + x145 * x52
    x147 = x51 * x63 + x81
    x148 = x147 * x20 + x51 * x64 + x85
    x149 = x33 * x55
    x150 = x102 + x51 * x82
    x151 = x150 * x55
    x152 = x105 + x150 * x20 + x51 * x86
    x153 = x118 * x5
    x154 = x103 * x51 + x120
    x155 = x118 * (x108 * x51 + x122 + x154 * x20)
    x156 = x14 * x94
    x157 = x14 * x150
    x158 = x121 * x51 + x2 * (4.0 * x100 + 8.0 * x101)
    x159 = x118 * x158

    # 45 item(s)
    return numpy.array(
        [
            x44 * (x19 * x40 + x2 * (4.0 * x18 + 4.0 * x29 + 4.0 * x34) + x39 * x7)
            + x47 * x49
            + x49 * x52,
            x52 * x54 * x61 + x53 * x59 + x54 * x60,
            x47 * x61 * x62 + x53 * x65 + x60 * x62,
            x52 * x69 * x75 + x73 * x75 + x76 * x77,
            x54 * x76 * x78 + x56 * x64 * x74 + x59 * x62 * x74,
            x47 * x82 * x87 + x76 * x88 + x86 * x87,
            x52 * x89 * x95 + x58 * x89 * x99 + x90 * x95,
            x63 * x69 * x90 + x63 * x73 * x89 + x64 * x69 * x89,
            x56 * x82 * x90 + x56 * x86 * x89 + x57 * x82 * x89,
            x104 * x47 * x89 + x104 * x90 + x108 * x55 * x89,
            x110 * x112 * x58 + x110 * x117 * x52 + x116 * x7,
            x111 * x64 * x94 + x112 * x63 * x94 + x117 * x62 * x99,
            x111 * x69 * x86 + x111 * x73 * x82 + x112 * x69 * x82,
            x103 * x111 * x57 + x103 * x112 * x56 + x108 * x119 * x54,
            x112 * x121 * x55 + x119 * x121 * x47 + x124 * x7,
            x126 * x38 * x58 + x127 * x46 + x128 * x46 * x52,
            x129 * x131 * x52 + x129 * x36 * x58 + x130 * x131,
            x126 * x33 * x63 + x33 * x46 * x65 + x36 * x46 * x78,
            x133 * x25 * x52 + x133 * x28 + x134 * x135,
            x129 * x25 * x64 + x129 * x28 * x63 + x130 * x25 * x63,
            x125 * x25 * x86 + x126 * x25 * x82 + x28 * x46 * x88,
            x136 * x138 * x52 + x136 * x21 * x58 + x137 * x5,
            x132 * x16 * x64 + x132 * x21 * x63 + x134 * x138 * x62,
            x129 * x16 * x86 + x129 * x21 * x82 + x130 * x16 * x82,
            x103 * x126 * x16 + x104 * x21 * x46 + x108 * x139 * x5,
            x115 * (x114 * x46 + x140 * x20 + x2 * (4.0 * x96 + 4.0 * x97 + 4.0 * x98))
            + x141 * x52
            + x141 * x9,
            x136 * x14 * x64 + x136 * x142 * x62 + x137 * x62,
            x134 * x14 * x82 + x143 * x82 * x9 + x143 * x86,
            x108 * x129 * x14 + x129 * x144 * x9 + x130 * x144,
            x121 * x126 * x14 + x121 * x139 * x9 + x124 * x46,
            x127 * x51 + x128 * x47 * x51 + x146 * x38 * x55,
            x146 * x33 * x56 + x33 * x51 * x59 + x36 * x44 * x51 * x54,
            x147 * x149 * x47 + x147 * x36 * x55 + x148 * x149,
            x135 * x51 * x73 + x146 * x25 * x69 + x28 * x51 * x77,
            x147 * x25 * x57 + x147 * x28 * x56 + x148 * x25 * x56,
            x151 * x25 * x47 + x151 * x28 + x152 * x25 * x55,
            x138 * x51 * x99 + x146 * x16 * x94 + x21 * x51 * x95,
            x147 * x16 * x73 + x147 * x21 * x69 + x148 * x16 * x69,
            x150 * x16 * x57 + x150 * x21 * x56 + x152 * x153 * x54,
            x153 * x154 * x47 + x154 * x21 * x55 + x155 * x5,
            x110 * x14 * x146 + x110 * x142 * x51 + x116 * x51,
            x14 * x147 * x99 + x147 * x156 * x9 + x148 * x156,
            x14 * x152 * x69 + x157 * x69 * x9 + x157 * x73,
            x118 * x154 * x54 * x9 + x14 * x154 * x57 + x155 * x54,
            x118 * (x123 * x51 + x158 * x20 + x2 * (4.0 * x105 + 4.0 * x106 + 4.0 * x107))
            + x159 * x47
            + x159 * x9,
        ]
    )


def kinetic3d_20(a, A, b, B):
    """Cartesian 3D (ds) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = (a + b) ** (-1.0)
    x1 = x0 * (a * A[0] + b * B[0]) - A[0]
    x2 = -a
    x3 = x1**2
    x4 = 2.0 * a
    x5 = (2.0 * b + x4) ** (-1.0)
    x6 = 2.0 * a**2
    x7 = -x2 - x6 * (x3 + x5)
    x8 = b * x0
    x9 = a * x8
    x10 = numpy.exp(-x9 * (A[0] - B[0]) ** 2)
    x11 = numpy.sqrt(x0)
    x12 = 1.77245385090552 * x11
    x13 = x10 * x12
    x14 = x1 * x13
    x15 = x4 * x8
    x16 = x14 * x15 + x14 * x7
    x17 = x13 * x5
    x18 = x13 * x3 + x17
    x19 = numpy.exp(-x9 * (A[1] - B[1]) ** 2)
    x20 = numpy.exp(-x9 * (A[2] - B[2]) ** 2)
    x21 = 3.14159265358979 * x0 * x20
    x22 = x19 * x21
    x23 = x0 * (a * A[1] + b * B[1]) - A[1]
    x24 = x23**2
    x25 = -x2 - x6 * (x24 + x5)
    x26 = x18 * x22
    x27 = x0 * (a * A[2] + b * B[2]) - A[2]
    x28 = x27**2
    x29 = -x2 - x6 * (x28 + x5)
    x30 = x12 * x19
    x31 = x23 * x30
    x32 = x15 * x31 + x25 * x31
    x33 = x10 * x21
    x34 = x32 * x33
    x35 = x16 * x22
    x36 = 5.56832799683171
    x37 = x0 * x10 * x19
    x38 = x1 * x11 * x20 * x36 * x37
    x39 = x12 * x20
    x40 = x27 * x39
    x41 = x15 * x40 + x29 * x40
    x42 = 3.14159265358979 * x37
    x43 = x41 * x42
    x44 = x30 * x5
    x45 = x24 * x30 + x44
    x46 = x33 * x45
    x47 = x39 * x5
    x48 = x28 * x39 + x47
    x49 = x42 * x48

    # 6 item(s)
    return numpy.array(
        [
            x22 * (x1 * x16 + x17 * x7 + x8 * (-2.0 * x13 + x18 * x4))
            + x25 * x26
            + x26 * x29,
            x1 * x34 + x23 * x29 * x38 + x23 * x35,
            x1 * x43 + x25 * x27 * x38 + x27 * x35,
            x29 * x46
            + x33 * (x23 * x32 + x25 * x44 + x8 * (-2.0 * x30 + x4 * x45))
            + x46 * x7,
            x11 * x20 * x23 * x27 * x36 * x37 * x7 + x23 * x43 + x27 * x34,
            x25 * x49
            + x42 * (x27 * x41 + x29 * x47 + x8 * (-2.0 * x39 + x4 * x48))
            + x49 * x7,
        ]
    )


def kinetic3d_21(a, A, b, B):
    """Cartesian 3D (dp) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = (2.0 * b + x0) ** (-1.0)
    x2 = -a
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = x5**2
    x7 = 2.0 * a**2
    x8 = -x2 - x7 * (x1 + x6)
    x9 = -x4 - B[0]
    x10 = b * x3
    x11 = a * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = 1.77245385090552 * numpy.sqrt(x3)
    x14 = x12 * x13
    x15 = x14 * x9
    x16 = x0 * x10
    x17 = x15 * x16 + x15 * x8
    x18 = x14 * x5
    x19 = x16 * x18 + x18 * x8
    x20 = x1 * x14
    x21 = x18 * x9 + x20
    x22 = x20 * x8
    x23 = x16 * x21 + x17 * x5 + x22
    x24 = x1 * (x15 + x18) + x21 * x5
    x25 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x26 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x27 = 3.14159265358979 * x26 * x3
    x28 = x25 * x27
    x29 = -x3 * (a * A[1] + b * B[1])
    x30 = -x29 - A[1]
    x31 = x30**2
    x32 = -x2 - x7 * (x1 + x31)
    x33 = x24 * x28
    x34 = -x3 * (a * A[2] + b * B[2])
    x35 = -x34 - A[2]
    x36 = x35**2
    x37 = -x2 - x7 * (x1 + x36)
    x38 = -x29 - B[1]
    x39 = x13 * x25
    x40 = x38 * x39
    x41 = x16 * x40 + x32 * x40
    x42 = x14 * x6 + x20
    x43 = x13 * x26
    x44 = x28 * (x10 * (x0 * x42 - 2.0 * x14) + x19 * x5 + x22)
    x45 = x28 * x42
    x46 = -x34 - B[2]
    x47 = x43 * x46
    x48 = x16 * x47 + x37 * x47
    x49 = x30 * x39
    x50 = x16 * x49 + x32 * x49
    x51 = x23 * x28
    x52 = x28 * x30
    x53 = x1 * x13
    x54 = x25 * x53
    x55 = x38 * x49 + x54
    x56 = x32 * x54
    x57 = x16 * x55 + x30 * x41 + x56
    x58 = x12 * x27
    x59 = x57 * x58
    x60 = x5 * x58
    x61 = 3.14159265358979 * x12 * x25 * x3
    x62 = x5 * x61
    x63 = x35 * x43
    x64 = x16 * x63 + x37 * x63
    x65 = x28 * x35
    x66 = x26 * x53
    x67 = x46 * x63 + x66
    x68 = x37 * x66
    x69 = x16 * x67 + x35 * x48 + x68
    x70 = x61 * x69
    x71 = x31 * x39 + x54
    x72 = 2.0 * x39
    x73 = x58 * (x10 * (x0 * x71 - x72) + x30 * x50 + x56)
    x74 = x58 * x71
    x75 = x1 * (x40 + x49) + x30 * x55
    x76 = x58 * x75
    x77 = x30 * x61
    x78 = x35 * x58
    x79 = x36 * x43 + x66
    x80 = 2.0 * x43
    x81 = x61 * (x10 * (x0 * x79 - x80) + x35 * x64 + x68)
    x82 = x61 * x79
    x83 = x1 * (x47 + x63) + x35 * x67
    x84 = x61 * x83

    # 18 item(s)
    return numpy.array(
        [
            x28 * (x1 * (x17 + x19) + x10 * (x0 * x24 - 2.0 * x15) + x23 * x5)
            + x32 * x33
            + x33 * x37,
            x37 * x38 * x45 + x38 * x44 + x41 * x42 * x43,
            x32 * x45 * x46 + x39 * x42 * x48 + x44 * x46,
            x21 * x37 * x52 + x21 * x43 * x50 + x30 * x51,
            x19 * x43 * x55 + x37 * x55 * x60 + x5 * x59,
            x19 * x46 * x52 + x30 * x48 * x62 + x46 * x50 * x60,
            x21 * x32 * x65 + x21 * x39 * x64 + x35 * x51,
            x19 * x38 * x65 + x35 * x41 * x60 + x38 * x62 * x64,
            x19 * x39 * x67 + x32 * x62 * x67 + x5 * x70,
            x17 * x43 * x71 + x37 * x74 * x9 + x73 * x9,
            x37 * x76
            + x58 * (x1 * (x41 + x50) + x10 * (x0 * x75 - x38 * x72) + x30 * x57)
            + x76 * x8,
            x14 * x48 * x71 + x46 * x73 + x46 * x74 * x8,
            x17 * x35 * x52 + x50 * x78 * x9 + x64 * x77 * x9,
            x14 * x55 * x64 + x35 * x59 + x55 * x78 * x8,
            x14 * x50 * x67 + x30 * x70 + x67 * x77 * x8,
            x17 * x39 * x79 + x32 * x82 * x9 + x81 * x9,
            x14 * x41 * x79 + x38 * x8 * x82 + x38 * x81,
            x32 * x84
            + x61 * (x1 * (x48 + x64) + x10 * (x0 * x83 - x46 * x80) + x35 * x69)
            + x8 * x84,
        ]
    )


def kinetic3d_22(a, A, b, B):
    """Cartesian 3D (dd) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = -a
    x7 = x5**2
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7)
    x10 = -x4 - B[0]
    x11 = a * x3
    x12 = b * x11
    x13 = numpy.exp(-x12 * (A[0] - B[0]) ** 2)
    x14 = 1.77245385090552 * numpy.sqrt(x3)
    x15 = x13 * x14
    x16 = x10 * x15
    x17 = b * x3
    x18 = x0 * x17
    x19 = x16 * x18 + x16 * x9
    x20 = x19 * x5
    x21 = x15 * x2
    x22 = x15 * x5
    x23 = x10 * x22 + x21
    x24 = 4.0 * x12
    x25 = x21 * x9
    x26 = x10**2 * x15
    x27 = x21 + x26
    x28 = 2.0 * x15
    x29 = -x28
    x30 = x10 * x19 + x11 * (x1 * x27 + x29)
    x31 = x10 * x28
    x32 = x25 + x30
    x33 = 2.0 * x21
    x34 = x10 * x33 + x27 * x5
    x35 = x18 * x34 + x2 * (x16 * x24 + x31 * x9) + x32 * x5
    x36 = x2 * (3.0 * x21 + x26 + x31 * x5) + x34 * x5
    x37 = numpy.exp(-x12 * (A[1] - B[1]) ** 2)
    x38 = numpy.exp(-x12 * (A[2] - B[2]) ** 2)
    x39 = 3.14159265358979 * x3 * x38
    x40 = x37 * x39
    x41 = -x3 * (a * A[1] + b * B[1])
    x42 = -x41 - A[1]
    x43 = x42**2
    x44 = -x6 - x8 * (x2 + x43)
    x45 = x36 * x40
    x46 = -x3 * (a * A[2] + b * B[2])
    x47 = -x46 - A[2]
    x48 = x47**2
    x49 = -x6 - x8 * (x2 + x48)
    x50 = -x41 - B[1]
    x51 = x14 * x37
    x52 = x50 * x51
    x53 = x18 * x52 + x44 * x52
    x54 = x2 * (x16 + x22) + x23 * x5
    x55 = x14 * x38
    x56 = x18 * x22 + x22 * x9
    x57 = x18 * x23 + x20 + x25
    x58 = x40 * (x17 * (x0 * x54 - x31) + x2 * (x19 + x56) + x5 * x57)
    x59 = x40 * x54
    x60 = -x46 - B[2]
    x61 = x55 * x60
    x62 = x18 * x61 + x49 * x61
    x63 = x2 * x51
    x64 = x44 * x63
    x65 = x50**2 * x51
    x66 = x63 + x65
    x67 = 2.0 * x51
    x68 = -x67
    x69 = x11 * (x1 * x66 + x68) + x50 * x53
    x70 = x64 + x69
    x71 = x15 * x7 + x21
    x72 = x55 * x71
    x73 = x17 * (x0 * x71 + x29) + x25 + x5 * x56
    x74 = x40 * x60
    x75 = x2 * x55
    x76 = x49 * x75
    x77 = x55 * x60**2
    x78 = x75 + x77
    x79 = 2.0 * x55
    x80 = -x79
    x81 = x11 * (x1 * x78 + x80) + x60 * x62
    x82 = x76 + x81
    x83 = x51 * x71
    x84 = x42 * x51
    x85 = x18 * x84 + x44 * x84
    x86 = x35 * x40
    x87 = x34 * x40
    x88 = x42 * x53
    x89 = x50 * x84 + x63
    x90 = x18 * x89 + x64 + x88
    x91 = x23 * x55
    x92 = 2.0 * x63
    x93 = x42 * x66 + x50 * x92
    x94 = x50 * x67
    x95 = x18 * x93 + x2 * (x24 * x52 + x44 * x94) + x42 * x70
    x96 = x13 * x39
    x97 = x95 * x96
    x98 = x5 * x96
    x99 = 3.14159265358979 * x13 * x3 * x37
    x100 = x5 * x99
    x101 = x47 * x55
    x102 = x101 * x18 + x101 * x49
    x103 = x40 * x47
    x104 = x47 * x62
    x105 = x101 * x60 + x75
    x106 = x104 + x105 * x18 + x76
    x107 = x23 * x51
    x108 = 2.0 * x75
    x109 = x108 * x60 + x47 * x78
    x110 = x60 * x79
    x111 = x109 * x18 + x2 * (x110 * x49 + x24 * x61) + x47 * x82
    x112 = x111 * x99
    x113 = x43 * x51 + x63
    x114 = x113 * x55
    x115 = x17 * (x0 * x113 + x68) + x42 * x85 + x64
    x116 = x2 * (x52 + x84) + x42 * x89
    x117 = x96 * (x17 * (x0 * x116 - x94) + x2 * (x53 + x85) + x42 * x90)
    x118 = x10 * x96
    x119 = x2 * (x42 * x94 + 3.0 * x63 + x65) + x42 * x93
    x120 = x119 * x96
    x121 = x9 * x96
    x122 = x113 * x15
    x123 = x42 * x99
    x124 = x15 * x89
    x125 = x48 * x55 + x75
    x126 = x125 * x51
    x127 = x102 * x47 + x17 * (x0 * x125 + x80) + x76
    x128 = x10 * x99
    x129 = x105 * x47 + x2 * (x101 + x61)
    x130 = x99 * (x106 * x47 + x17 * (x0 * x129 - x110) + x2 * (x102 + x62))
    x131 = x125 * x15
    x132 = x109 * x47 + x2 * (x110 * x47 + 3.0 * x75 + x77)
    x133 = x132 * x99

    # 36 item(s)
    return numpy.array(
        [
            x40
            * (
                x17 * (2.0 * a * x36 - 2.0 * x26 - x33)
                + x2 * (2.0 * x20 + x23 * x24 + 3.0 * x25 + x30)
                + x35 * x5
            )
            + x44 * x45
            + x45 * x49,
            x49 * x50 * x59 + x50 * x58 + x53 * x54 * x55,
            x44 * x59 * x60 + x51 * x54 * x62 + x58 * x60,
            x49 * x66 * x72 + x55 * x66 * x73 + x70 * x72,
            x50 * x73 * x74 + x52 * x62 * x71 + x53 * x61 * x71,
            x44 * x78 * x83 + x51 * x73 * x78 + x82 * x83,
            x34 * x55 * x85 + x42 * x49 * x87 + x42 * x86,
            x49 * x89 * x91 + x55 * x57 * x89 + x90 * x91,
            x23 * x61 * x85 + x23 * x62 * x84 + x42 * x57 * x74,
            x49 * x93 * x98 + x5 * x97 + x55 * x56 * x93,
            x22 * x62 * x89 + x56 * x61 * x89 + x60 * x90 * x98,
            x100 * x42 * x82 + x22 * x78 * x85 + x56 * x78 * x84,
            x102 * x34 * x51 + x44 * x47 * x87 + x47 * x86,
            x101 * x23 * x53 + x102 * x23 * x52 + x103 * x50 * x57,
            x105 * x107 * x44 + x105 * x51 * x57 + x106 * x107,
            x101 * x56 * x66 + x102 * x22 * x66 + x47 * x70 * x98,
            x100 * x106 * x50 + x105 * x22 * x53 + x105 * x52 * x56,
            x100 * x109 * x44 + x109 * x51 * x56 + x112 * x5,
            x114 * x27 * x49 + x114 * x32 + x115 * x27 * x55,
            x10 * x117 + x116 * x118 * x49 + x116 * x19 * x55,
            x113 * x16 * x62 + x113 * x19 * x61 + x115 * x118 * x60,
            x120 * x49
            + x120 * x9
            + x96
            * (
                x17 * (2.0 * a * x119 - 2.0 * x65 - x92)
                + x2 * (x24 * x89 + 3.0 * x64 + x69 + 2.0 * x88)
                + x42 * x95
            ),
            x116 * x121 * x60 + x116 * x15 * x62 + x117 * x60,
            x115 * x15 * x78 + x122 * x78 * x9 + x122 * x82,
            x101 * x27 * x85 + x102 * x27 * x84 + x103 * x32 * x42,
            x101 * x19 * x89 + x102 * x16 * x89 + x118 * x47 * x90,
            x10 * x106 * x123 + x105 * x16 * x85 + x105 * x19 * x84,
            x102 * x15 * x93 + x121 * x47 * x93 + x47 * x97,
            x105 * x124 * x9 + x105 * x15 * x90 + x106 * x124,
            x109 * x123 * x9 + x109 * x15 * x85 + x112 * x42,
            x126 * x27 * x44 + x126 * x32 + x127 * x27 * x51,
            x125 * x16 * x53 + x125 * x19 * x52 + x127 * x128 * x50,
            x10 * x130 + x128 * x129 * x44 + x129 * x19 * x51,
            x127 * x15 * x66 + x131 * x66 * x9 + x131 * x70,
            x129 * x15 * x53 + x129 * x50 * x9 * x99 + x130 * x50,
            x133 * x44
            + x133 * x9
            + x99
            * (
                x111 * x47
                + x17 * (2.0 * a * x132 - x108 - 2.0 * x77)
                + x2 * (2.0 * x104 + x105 * x24 + 3.0 * x76 + x81)
            ),
        ]
    )


def kinetic3d_23(a, A, b, B):
    """Cartesian 3D (df) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = -a
    x7 = x5**2
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7)
    x10 = a * x3
    x11 = b * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = 1.77245385090552 * numpy.sqrt(x3)
    x14 = x12 * x13
    x15 = x14 * x2
    x16 = x15 * x9
    x17 = -x4 - B[0]
    x18 = x14 * x17
    x19 = b * x3
    x20 = x0 * x19
    x21 = x18 * x20 + x18 * x9
    x22 = x17 * x21
    x23 = x14 * x17**2
    x24 = x15 + x23
    x25 = 2.0 * x14
    x26 = -x25
    x27 = x10 * (x1 * x24 + x26)
    x28 = x22 + x27
    x29 = x16 + x28
    x30 = x29 * x5
    x31 = x17 * x25
    x32 = 4.0 * x11
    x33 = x2 * (x18 * x32 + x31 * x9)
    x34 = x24 * x5
    x35 = 2.0 * x15
    x36 = x17 * x35
    x37 = x34 + x36
    x38 = 6.0 * x11
    x39 = x17 * x24
    x40 = x36 + x39
    x41 = x10 * (x1 * x40 - 3.0 * x18) + x17 * x29
    x42 = 3.0 * x16
    x43 = x33 + x41
    x44 = 3.0 * x15
    x45 = x2 * (3.0 * x23 + x44) + x40 * x5
    x46 = x2 * (3.0 * x22 + 3.0 * x27 + x42) + x20 * x45 + x43 * x5
    x47 = x15 * x17
    x48 = x2 * (3.0 * x34 + x39 + 8.0 * x47) + x45 * x5
    x49 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x50 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x51 = 3.14159265358979 * x3 * x50
    x52 = x49 * x51
    x53 = -x3 * (a * A[1] + b * B[1])
    x54 = -x53 - A[1]
    x55 = x54**2
    x56 = -x6 - x8 * (x2 + x55)
    x57 = x48 * x52
    x58 = -x3 * (a * A[2] + b * B[2])
    x59 = -x58 - A[2]
    x60 = x59**2
    x61 = -x6 - x8 * (x2 + x60)
    x62 = -x53 - B[1]
    x63 = x13 * x49
    x64 = x62 * x63
    x65 = x20 * x64 + x56 * x64
    x66 = x2 * (x23 + x31 * x5 + x44) + x37 * x5
    x67 = x13 * x50
    x68 = x21 * x5
    x69 = x14 * x5
    x70 = x15 + x17 * x69
    x71 = x20 * x37 + x30 + x33
    x72 = x52 * (
        x19 * (2.0 * a * x66 - 2.0 * x23 - x35)
        + x2 * (x28 + x32 * x70 + x42 + 2.0 * x68)
        + x5 * x71
    )
    x73 = x52 * x66
    x74 = -x58 - B[2]
    x75 = x67 * x74
    x76 = x20 * x75 + x61 * x75
    x77 = x2 * x63
    x78 = x56 * x77
    x79 = x62 * x65
    x80 = x62**2 * x63
    x81 = x77 + x80
    x82 = 2.0 * x63
    x83 = -x82
    x84 = x10 * (x1 * x81 + x83)
    x85 = x79 + x84
    x86 = x78 + x85
    x87 = x2 * (x18 + x69) + x5 * x70
    x88 = x67 * x87
    x89 = x20 * x69 + x69 * x9
    x90 = x16 + x20 * x70 + x68
    x91 = x19 * (x0 * x87 - x31) + x2 * (x21 + x89) + x5 * x90
    x92 = x52 * x74
    x93 = x2 * x67
    x94 = x61 * x93
    x95 = x74 * x76
    x96 = x67 * x74**2
    x97 = x93 + x96
    x98 = 2.0 * x67
    x99 = -x98
    x100 = x10 * (x1 * x97 + x99)
    x101 = x100 + x95
    x102 = x101 + x94
    x103 = x63 * x87
    x104 = x14 * x7 + x15
    x105 = x16 + x19 * (x0 * x104 + x26) + x5 * x89
    x106 = x62 * x81
    x107 = 2.0 * x77
    x108 = x107 * x62
    x109 = x106 + x108
    x110 = x109 * x67
    x111 = x62 * x82
    x112 = x2 * (x111 * x56 + x32 * x64)
    x113 = x10 * (x1 * x109 - 3.0 * x64) + x62 * x86
    x114 = x112 + x113
    x115 = x74 * x97
    x116 = 2.0 * x93
    x117 = x116 * x74
    x118 = x115 + x117
    x119 = x118 * x63
    x120 = x74 * x98
    x121 = x2 * (x120 * x61 + x32 * x75)
    x122 = x10 * (x1 * x118 - 3.0 * x75) + x102 * x74
    x123 = x121 + x122
    x124 = x54 * x63
    x125 = x124 * x20 + x124 * x56
    x126 = x46 * x52
    x127 = x45 * x52
    x128 = x54 * x65
    x129 = x124 * x62 + x77
    x130 = x128 + x129 * x20 + x78
    x131 = x37 * x67
    x132 = x54 * x81
    x133 = x108 + x132
    x134 = x133 * x67
    x135 = x54 * x86
    x136 = x112 + x133 * x20 + x135
    x137 = 3.0 * x77
    x138 = x109 * x54 + x2 * (x137 + 3.0 * x80)
    x139 = 3.0 * x78
    x140 = x114 * x54 + x138 * x20 + x2 * (x139 + 3.0 * x79 + 3.0 * x84)
    x141 = x12 * x51
    x142 = x140 * x141
    x143 = x141 * x5
    x144 = 3.14159265358979 * x12 * x3 * x49
    x145 = x144 * x5
    x146 = x59 * x67
    x147 = x146 * x20 + x146 * x61
    x148 = x52 * x59
    x149 = x59 * x76
    x150 = x146 * x74 + x93
    x151 = x149 + x150 * x20 + x94
    x152 = x37 * x63
    x153 = x59 * x97
    x154 = x117 + x153
    x155 = x154 * x63
    x156 = x102 * x59
    x157 = x121 + x154 * x20 + x156
    x158 = 3.0 * x93
    x159 = x118 * x59 + x2 * (x158 + 3.0 * x96)
    x160 = 3.0 * x94
    x161 = x123 * x59 + x159 * x20 + x2 * (3.0 * x100 + x160 + 3.0 * x95)
    x162 = x144 * x161
    x163 = x55 * x63 + x77
    x164 = x125 * x54 + x19 * (x0 * x163 + x83) + x78
    x165 = x40 * x67
    x166 = x129 * x54 + x2 * (x124 + x64)
    x167 = x166 * x67
    x168 = x130 * x54 + x19 * (x0 * x166 - x111) + x2 * (x125 + x65)
    x169 = x133 * x54 + x2 * (x111 * x54 + x137 + x80)
    x170 = x141 * (
        x136 * x54
        + x19 * (2.0 * a * x169 - x107 - 2.0 * x80)
        + x2 * (2.0 * x128 + x129 * x32 + x139 + x85)
    )
    x171 = x141 * x17
    x172 = x62 * x77
    x173 = x138 * x54 + x2 * (x106 + 3.0 * x132 + 8.0 * x172)
    x174 = x141 * x173
    x175 = x141 * x9
    x176 = x14 * x166
    x177 = x118 * x14
    x178 = x144 * x54
    x179 = x133 * x14
    x180 = x14 * x154
    x181 = x60 * x67 + x93
    x182 = x147 * x59 + x19 * (x0 * x181 + x99) + x94
    x183 = x40 * x63
    x184 = x150 * x59 + x2 * (x146 + x75)
    x185 = x184 * x63
    x186 = x151 * x59 + x19 * (x0 * x184 - x120) + x2 * (x147 + x76)
    x187 = x144 * x17
    x188 = x154 * x59 + x2 * (x120 * x59 + x158 + x96)
    x189 = x144 * (
        x157 * x59
        + x19 * (2.0 * a * x188 - x116 - 2.0 * x96)
        + x2 * (x101 + 2.0 * x149 + x150 * x32 + x160)
    )
    x190 = x109 * x14
    x191 = x14 * x184
    x192 = x74 * x93
    x193 = x159 * x59 + x2 * (x115 + 3.0 * x153 + 8.0 * x192)
    x194 = x144 * x193

    # 60 item(s)
    return numpy.array(
        [
            x52
            * (
                x19 * (2.0 * a * x48 - 2.0 * x39 - 4.0 * x47)
                + x2 * (3.0 * x30 + 4.0 * x33 + x37 * x38 + x41)
                + x46 * x5
            )
            + x56 * x57
            + x57 * x61,
            x61 * x62 * x73 + x62 * x72 + x65 * x66 * x67,
            x56 * x73 * x74 + x63 * x66 * x76 + x72 * x74,
            x61 * x81 * x88 + x67 * x81 * x91 + x86 * x88,
            x62 * x91 * x92 + x64 * x76 * x87 + x65 * x75 * x87,
            x102 * x103 + x103 * x56 * x97 + x63 * x91 * x97,
            x104 * x110 * x61 + x104 * x114 * x67 + x105 * x110,
            x104 * x75 * x86 + x104 * x76 * x81 + x105 * x75 * x81,
            x102 * x104 * x64 + x104 * x65 * x97 + x105 * x64 * x97,
            x104 * x119 * x56 + x104 * x123 * x63 + x105 * x119,
            x125 * x45 * x67 + x126 * x54 + x127 * x54 * x61,
            x129 * x131 * x61 + x129 * x67 * x71 + x130 * x131,
            x124 * x37 * x76 + x125 * x37 * x75 + x54 * x71 * x92,
            x134 * x61 * x70 + x134 * x90 + x136 * x67 * x70,
            x129 * x70 * x76 + x129 * x75 * x90 + x130 * x70 * x75,
            x102 * x124 * x70 + x124 * x90 * x97 + x125 * x70 * x97,
            x138 * x143 * x61 + x138 * x67 * x89 + x142 * x5,
            x133 * x69 * x76 + x133 * x75 * x89 + x136 * x143 * x74,
            x102 * x129 * x69 + x129 * x89 * x97 + x130 * x69 * x97,
            x118 * x124 * x89 + x118 * x125 * x69 + x123 * x145 * x54,
            x126 * x59 + x127 * x56 * x59 + x147 * x45 * x63,
            x146 * x37 * x65 + x147 * x37 * x64 + x148 * x62 * x71,
            x150 * x152 * x56 + x150 * x63 * x71 + x151 * x152,
            x146 * x70 * x86 + x146 * x81 * x90 + x147 * x70 * x81,
            x150 * x64 * x90 + x150 * x65 * x70 + x151 * x64 * x70,
            x155 * x56 * x70 + x155 * x90 + x157 * x63 * x70,
            x109 * x146 * x89 + x109 * x147 * x69 + x114 * x143 * x59,
            x150 * x69 * x86 + x150 * x81 * x89 + x151 * x69 * x81,
            x145 * x157 * x62 + x154 * x64 * x89 + x154 * x65 * x69,
            x145 * x159 * x56 + x159 * x63 * x89 + x162 * x5,
            x163 * x165 * x61 + x163 * x43 * x67 + x164 * x165,
            x167 * x24 * x61 + x167 * x29 + x168 * x24 * x67,
            x163 * x24 * x76 + x163 * x29 * x75 + x164 * x24 * x75,
            x169 * x171 * x61 + x169 * x21 * x67 + x17 * x170,
            x166 * x18 * x76 + x166 * x21 * x75 + x168 * x171 * x74,
            x102 * x163 * x18 + x163 * x21 * x97 + x164 * x18 * x97,
            x141
            * (
                x140 * x54
                + x19 * (2.0 * a * x173 - 2.0 * x106 - 4.0 * x172)
                + x2 * (4.0 * x112 + x113 + x133 * x38 + 3.0 * x135)
            )
            + x174 * x61
            + x174 * x9,
            x14 * x169 * x76 + x169 * x175 * x74 + x170 * x74,
            x102 * x176 + x14 * x168 * x97 + x176 * x9 * x97,
            x123 * x14 * x163 + x163 * x177 * x9 + x164 * x177,
            x124 * x147 * x40 + x125 * x146 * x40 + x148 * x43 * x54,
            x129 * x146 * x29 + x129 * x147 * x24 + x130 * x146 * x24,
            x124 * x150 * x29 + x124 * x151 * x24 + x125 * x150 * x24,
            x133 * x146 * x21 + x133 * x147 * x18 + x136 * x171 * x59,
            x129 * x150 * x21 + x129 * x151 * x18 + x130 * x150 * x18,
            x124 * x154 * x21 + x125 * x154 * x18 + x157 * x17 * x178,
            x138 * x14 * x147 + x138 * x175 * x59 + x142 * x59,
            x136 * x14 * x150 + x150 * x179 * x9 + x151 * x179,
            x129 * x14 * x157 + x129 * x180 * x9 + x130 * x180,
            x125 * x14 * x159 + x159 * x178 * x9 + x162 * x54,
            x181 * x183 * x56 + x181 * x43 * x63 + x182 * x183,
            x181 * x24 * x65 + x181 * x29 * x64 + x182 * x24 * x64,
            x185 * x24 * x56 + x185 * x29 + x186 * x24 * x63,
            x18 * x181 * x86 + x18 * x182 * x81 + x181 * x21 * x81,
            x18 * x184 * x65 + x184 * x21 * x64 + x186 * x187 * x62,
            x17 * x189 + x187 * x188 * x56 + x188 * x21 * x63,
            x114 * x14 * x181 + x181 * x190 * x9 + x182 * x190,
            x14 * x186 * x81 + x191 * x81 * x9 + x191 * x86,
            x14 * x188 * x65 + x144 * x188 * x62 * x9 + x189 * x62,
            x144
            * (
                x161 * x59
                + x19 * (2.0 * a * x193 - 2.0 * x115 - 4.0 * x192)
                + x2 * (4.0 * x121 + x122 + x154 * x38 + 3.0 * x156)
            )
            + x194 * x56
            + x194 * x9,
        ]
    )


def kinetic3d_24(a, A, b, B):
    """Cartesian 3D (dg) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = -a
    x7 = x5**2
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7)
    x10 = -x4 - B[0]
    x11 = a * x3
    x12 = b * x11
    x13 = numpy.exp(-x12 * (A[0] - B[0]) ** 2)
    x14 = 1.77245385090552 * numpy.sqrt(x3)
    x15 = x13 * x14
    x16 = 2.0 * x15
    x17 = x10 * x16
    x18 = x10 * x15
    x19 = 4.0 * x12
    x20 = x2 * (x17 * x9 + x18 * x19)
    x21 = x15 * x2
    x22 = x21 * x9
    x23 = b * x3
    x24 = x0 * x23
    x25 = x18 * x24 + x18 * x9
    x26 = x10 * x25
    x27 = x10**2 * x15
    x28 = x21 + x27
    x29 = -x16
    x30 = x11 * (x1 * x28 + x29)
    x31 = x26 + x30
    x32 = x22 + x31
    x33 = x10 * x32
    x34 = x10 * x28
    x35 = 2.0 * x21
    x36 = x10 * x35
    x37 = x34 + x36
    x38 = x11 * (x1 * x37 - 3.0 * x18)
    x39 = x33 + x38
    x40 = x20 + x39
    x41 = x40 * x5
    x42 = 3.0 * x22
    x43 = x2 * (3.0 * x26 + 3.0 * x30 + x42)
    x44 = 3.0 * x21
    x45 = x2 * (3.0 * x27 + x44)
    x46 = x37 * x5
    x47 = x45 + x46
    x48 = 8.0 * x12
    x49 = x10 * x37
    x50 = x45 + x49
    x51 = 4.0 * x21
    x52 = x10 * x40 + x11 * (2.0 * b * x50 - 4.0 * x27 - x51)
    x53 = 4.0 * x20
    x54 = x43 + x52
    x55 = 8.0 * x10 * x21
    x56 = x2 * (4.0 * x34 + x55) + x5 * x50
    x57 = x2 * (4.0 * x33 + 4.0 * x38 + x53) + x24 * x56 + x5 * x54
    x58 = x2 * (5.0 * x45 + 4.0 * x46 + x49) + x5 * x56
    x59 = numpy.exp(-x12 * (A[1] - B[1]) ** 2)
    x60 = numpy.exp(-x12 * (A[2] - B[2]) ** 2)
    x61 = 3.14159265358979 * x3 * x60
    x62 = x59 * x61
    x63 = -x3 * (a * A[1] + b * B[1])
    x64 = -x63 - A[1]
    x65 = x64**2
    x66 = -x6 - x8 * (x2 + x65)
    x67 = x58 * x62
    x68 = -x3 * (a * A[2] + b * B[2])
    x69 = -x68 - A[2]
    x70 = x69**2
    x71 = -x6 - x8 * (x2 + x70)
    x72 = -x63 - B[1]
    x73 = x14 * x59
    x74 = x72 * x73
    x75 = x24 * x74 + x66 * x74
    x76 = x28 * x5
    x77 = x2 * (x34 + x55 + 3.0 * x76) + x47 * x5
    x78 = x14 * x60
    x79 = x32 * x5
    x80 = x36 + x76
    x81 = 6.0 * x12
    x82 = x24 * x47 + x41 + x43
    x83 = x62 * (
        x2 * (x39 + x53 + 3.0 * x79 + x80 * x81)
        + x23 * (2.0 * a * x77 - x10 * x51 - 2.0 * x34)
        + x5 * x82
    )
    x84 = x62 * x77
    x85 = -x68 - B[2]
    x86 = x78 * x85
    x87 = x24 * x86 + x71 * x86
    x88 = x2 * x73
    x89 = x66 * x88
    x90 = x72 * x75
    x91 = x72**2 * x73
    x92 = x88 + x91
    x93 = 2.0 * x73
    x94 = -x93
    x95 = x11 * (x1 * x92 + x94)
    x96 = x90 + x95
    x97 = x89 + x96
    x98 = x2 * (x17 * x5 + x27 + x44) + x5 * x80
    x99 = x78 * x98
    x100 = x25 * x5
    x101 = x15 * x5
    x102 = x10 * x101 + x21
    x103 = x20 + x24 * x80 + x79
    x104 = (
        x103 * x5
        + x2 * (2.0 * x100 + x102 * x19 + x31 + x42)
        + x23 * (2.0 * a * x98 - 2.0 * x27 - x35)
    )
    x105 = x62 * x85
    x106 = x2 * x78
    x107 = x106 * x71
    x108 = x85 * x87
    x109 = x78 * x85**2
    x110 = x106 + x109
    x111 = 2.0 * x78
    x112 = -x111
    x113 = x11 * (x1 * x110 + x112)
    x114 = x108 + x113
    x115 = x107 + x114
    x116 = x73 * x98
    x117 = x72 * x93
    x118 = x2 * (x117 * x66 + x19 * x74)
    x119 = x72 * x97
    x120 = x72 * x92
    x121 = 2.0 * x88
    x122 = x121 * x72
    x123 = x120 + x122
    x124 = x11 * (x1 * x123 - 3.0 * x74)
    x125 = x119 + x124
    x126 = x118 + x125
    x127 = x102 * x5 + x2 * (x101 + x18)
    x128 = x127 * x78
    x129 = x101 * x24 + x101 * x9
    x130 = x100 + x102 * x24 + x22
    x131 = x130 * x5 + x2 * (x129 + x25) + x23 * (x0 * x127 - x17)
    x132 = x111 * x85
    x133 = x2 * (x132 * x71 + x19 * x86)
    x134 = x115 * x85
    x135 = x110 * x85
    x136 = 2.0 * x106
    x137 = x136 * x85
    x138 = x135 + x137
    x139 = x11 * (x1 * x138 - 3.0 * x86)
    x140 = x134 + x139
    x141 = x133 + x140
    x142 = x127 * x73
    x143 = x15 * x7 + x21
    x144 = x129 * x5 + x22 + x23 * (x0 * x143 + x29)
    x145 = 3.0 * x88
    x146 = x2 * (x145 + 3.0 * x91)
    x147 = x123 * x72
    x148 = x146 + x147
    x149 = x148 * x78
    x150 = 3.0 * x89
    x151 = x2 * (x150 + 3.0 * x90 + 3.0 * x95)
    x152 = 4.0 * x88
    x153 = x11 * (2.0 * b * x148 - x152 - 4.0 * x91) + x126 * x72
    x154 = x151 + x153
    x155 = 3.0 * x106
    x156 = x2 * (3.0 * x109 + x155)
    x157 = x138 * x85
    x158 = x156 + x157
    x159 = x158 * x73
    x160 = 3.0 * x107
    x161 = x2 * (3.0 * x108 + 3.0 * x113 + x160)
    x162 = 4.0 * x106
    x163 = x11 * (2.0 * b * x158 - 4.0 * x109 - x162) + x141 * x85
    x164 = x161 + x163
    x165 = x64 * x73
    x166 = x165 * x24 + x165 * x66
    x167 = x57 * x62
    x168 = x56 * x62
    x169 = x64 * x75
    x170 = x165 * x72 + x88
    x171 = x169 + x170 * x24 + x89
    x172 = x47 * x78
    x173 = x64 * x97
    x174 = x64 * x92
    x175 = x122 + x174
    x176 = x118 + x173 + x175 * x24
    x177 = x78 * x80
    x178 = x123 * x64
    x179 = x146 + x178
    x180 = x179 * x78
    x181 = x126 * x64
    x182 = x151 + x179 * x24 + x181
    x183 = 8.0 * x72 * x88
    x184 = x148 * x64 + x2 * (4.0 * x120 + x183)
    x185 = 4.0 * x118
    x186 = x154 * x64 + x184 * x24 + x2 * (4.0 * x119 + 4.0 * x124 + x185)
    x187 = x13 * x61
    x188 = x186 * x187
    x189 = x187 * x5
    x190 = 3.14159265358979 * x13 * x3 * x59
    x191 = x190 * x5
    x192 = x69 * x78
    x193 = x192 * x24 + x192 * x71
    x194 = x62 * x69
    x195 = x69 * x87
    x196 = x106 + x192 * x85
    x197 = x107 + x195 + x196 * x24
    x198 = x47 * x73
    x199 = x115 * x69
    x200 = x110 * x69
    x201 = x137 + x200
    x202 = x133 + x199 + x201 * x24
    x203 = x73 * x80
    x204 = x138 * x69
    x205 = x156 + x204
    x206 = x205 * x73
    x207 = x141 * x69
    x208 = x161 + x205 * x24 + x207
    x209 = 8.0 * x106 * x85
    x210 = x158 * x69 + x2 * (4.0 * x135 + x209)
    x211 = 4.0 * x133
    x212 = x164 * x69 + x2 * (4.0 * x134 + 4.0 * x139 + x211) + x210 * x24
    x213 = x190 * x212
    x214 = x65 * x73 + x88
    x215 = x166 * x64 + x23 * (x0 * x214 + x94) + x89
    x216 = x50 * x78
    x217 = x170 * x64 + x2 * (x165 + x74)
    x218 = x217 * x78
    x219 = x171 * x64 + x2 * (x166 + x75) + x23 * (x0 * x217 - x117)
    x220 = x175 * x64 + x2 * (x117 * x64 + x145 + x91)
    x221 = x220 * x78
    x222 = (
        x176 * x64
        + x2 * (x150 + 2.0 * x169 + x170 * x19 + x96)
        + x23 * (2.0 * a * x220 - x121 - 2.0 * x91)
    )
    x223 = x179 * x64 + x2 * (x120 + 3.0 * x174 + x183)
    x224 = x187 * (
        x182 * x64
        + x2 * (x125 + 3.0 * x173 + x175 * x81 + x185)
        + x23 * (2.0 * a * x223 - 2.0 * x120 - x152 * x72)
    )
    x225 = x10 * x187
    x226 = x184 * x64 + x2 * (5.0 * x146 + x147 + 4.0 * x178)
    x227 = x187 * x226
    x228 = x187 * x9
    x229 = x15 * x220
    x230 = x15 * x217
    x231 = x15 * x158
    x232 = x190 * x64
    x233 = x15 * x179
    x234 = x15 * x175
    x235 = x15 * x205
    x236 = x106 + x70 * x78
    x237 = x107 + x193 * x69 + x23 * (x0 * x236 + x112)
    x238 = x50 * x73
    x239 = x196 * x69 + x2 * (x192 + x86)
    x240 = x239 * x73
    x241 = x197 * x69 + x2 * (x193 + x87) + x23 * (x0 * x239 - x132)
    x242 = x2 * (x109 + x132 * x69 + x155) + x201 * x69
    x243 = x242 * x73
    x244 = (
        x2 * (x114 + x160 + x19 * x196 + 2.0 * x195)
        + x202 * x69
        + x23 * (2.0 * a * x242 - 2.0 * x109 - x136)
    )
    x245 = x10 * x190
    x246 = x2 * (x135 + 3.0 * x200 + x209) + x205 * x69
    x247 = x190 * (
        x2 * (x140 + 3.0 * x199 + x201 * x81 + x211)
        + x208 * x69
        + x23 * (2.0 * a * x246 - 2.0 * x135 - x162 * x85)
    )
    x248 = x148 * x15
    x249 = x15 * x239
    x250 = x15 * x242
    x251 = x2 * (5.0 * x156 + x157 + 4.0 * x204) + x210 * x69
    x252 = x190 * x251

    # 90 item(s)
    return numpy.array(
        [
            x62
            * (
                x2 * (4.0 * x41 + 5.0 * x43 + x47 * x48 + x52)
                + x23 * (2.0 * a * x58 - 2.0 * x45 - 2.0 * x49)
                + x5 * x57
            )
            + x66 * x67
            + x67 * x71,
            x71 * x72 * x84 + x72 * x83 + x75 * x77 * x78,
            x66 * x84 * x85 + x73 * x77 * x87 + x83 * x85,
            x104 * x78 * x92 + x71 * x92 * x99 + x97 * x99,
            x104 * x105 * x72 + x74 * x87 * x98 + x75 * x86 * x98,
            x104 * x110 * x73 + x110 * x116 * x66 + x115 * x116,
            x123 * x128 * x71 + x123 * x131 * x78 + x126 * x128,
            x127 * x86 * x97 + x127 * x87 * x92 + x131 * x86 * x92,
            x110 * x127 * x75 + x110 * x131 * x74 + x115 * x127 * x74,
            x131 * x138 * x73 + x138 * x142 * x66 + x141 * x142,
            x143 * x149 * x71 + x143 * x154 * x78 + x144 * x149,
            x123 * x143 * x87 + x123 * x144 * x86 + x126 * x143 * x86,
            x110 * x143 * x97 + x110 * x144 * x92 + x115 * x143 * x92,
            x138 * x143 * x75 + x138 * x144 * x74 + x141 * x143 * x74,
            x143 * x159 * x66 + x143 * x164 * x73 + x144 * x159,
            x166 * x56 * x78 + x167 * x64 + x168 * x64 * x71,
            x170 * x172 * x71 + x170 * x78 * x82 + x171 * x172,
            x105 * x64 * x82 + x165 * x47 * x87 + x166 * x47 * x86,
            x103 * x175 * x78 + x175 * x177 * x71 + x176 * x177,
            x103 * x170 * x86 + x170 * x80 * x87 + x171 * x80 * x86,
            x103 * x110 * x165 + x110 * x166 * x80 + x115 * x165 * x80,
            x102 * x180 * x71 + x102 * x182 * x78 + x130 * x180,
            x102 * x175 * x87 + x102 * x176 * x86 + x130 * x175 * x86,
            x102 * x110 * x171 + x102 * x115 * x170 + x110 * x130 * x170,
            x102 * x138 * x166 + x102 * x141 * x165 + x130 * x138 * x165,
            x129 * x184 * x78 + x184 * x189 * x71 + x188 * x5,
            x101 * x179 * x87 + x129 * x179 * x86 + x182 * x189 * x85,
            x101 * x110 * x176 + x101 * x115 * x175 + x110 * x129 * x175,
            x101 * x138 * x171 + x101 * x141 * x170 + x129 * x138 * x170,
            x101 * x158 * x166 + x129 * x158 * x165 + x164 * x191 * x64,
            x167 * x69 + x168 * x66 * x69 + x193 * x56 * x73,
            x192 * x47 * x75 + x193 * x47 * x74 + x194 * x72 * x82,
            x196 * x198 * x66 + x196 * x73 * x82 + x197 * x198,
            x103 * x192 * x92 + x192 * x80 * x97 + x193 * x80 * x92,
            x103 * x196 * x74 + x196 * x75 * x80 + x197 * x74 * x80,
            x103 * x201 * x73 + x201 * x203 * x66 + x202 * x203,
            x102 * x123 * x193 + x102 * x126 * x192 + x123 * x130 * x192,
            x102 * x196 * x97 + x102 * x197 * x92 + x130 * x196 * x92,
            x102 * x201 * x75 + x102 * x202 * x74 + x130 * x201 * x74,
            x102 * x206 * x66 + x102 * x208 * x73 + x130 * x206,
            x101 * x148 * x193 + x129 * x148 * x192 + x154 * x189 * x69,
            x101 * x123 * x197 + x101 * x126 * x196 + x123 * x129 * x196,
            x101 * x201 * x97 + x101 * x202 * x92 + x129 * x201 * x92,
            x101 * x205 * x75 + x129 * x205 * x74 + x191 * x208 * x72,
            x129 * x210 * x73 + x191 * x210 * x66 + x213 * x5,
            x214 * x216 * x71 + x214 * x54 * x78 + x215 * x216,
            x218 * x37 * x71 + x218 * x40 + x219 * x37 * x78,
            x214 * x37 * x87 + x214 * x40 * x86 + x215 * x37 * x86,
            x221 * x28 * x71 + x221 * x32 + x222 * x28 * x78,
            x217 * x28 * x87 + x217 * x32 * x86 + x219 * x28 * x86,
            x110 * x214 * x32 + x110 * x215 * x28 + x115 * x214 * x28,
            x10 * x224 + x223 * x225 * x71 + x223 * x25 * x78,
            x18 * x220 * x87 + x220 * x25 * x86 + x222 * x225 * x85,
            x110 * x18 * x219 + x110 * x217 * x25 + x115 * x18 * x217,
            x138 * x18 * x215 + x138 * x214 * x25 + x141 * x18 * x214,
            x187
            * (
                x186 * x64
                + x2 * (5.0 * x151 + x153 + x179 * x48 + 4.0 * x181)
                + x23 * (2.0 * a * x226 - 2.0 * x146 - 2.0 * x147)
            )
            + x227 * x71
            + x227 * x9,
            x15 * x223 * x87 + x223 * x228 * x85 + x224 * x85,
            x110 * x15 * x222 + x110 * x229 * x9 + x115 * x229,
            x138 * x15 * x219 + x138 * x230 * x9 + x141 * x230,
            x15 * x164 * x214 + x214 * x231 * x9 + x215 * x231,
            x165 * x193 * x50 + x166 * x192 * x50 + x194 * x54 * x64,
            x170 * x192 * x40 + x170 * x193 * x37 + x171 * x192 * x37,
            x165 * x196 * x40 + x165 * x197 * x37 + x166 * x196 * x37,
            x175 * x192 * x32 + x175 * x193 * x28 + x176 * x192 * x28,
            x170 * x196 * x32 + x170 * x197 * x28 + x171 * x196 * x28,
            x165 * x201 * x32 + x165 * x202 * x28 + x166 * x201 * x28,
            x179 * x18 * x193 + x179 * x192 * x25 + x182 * x225 * x69,
            x175 * x18 * x197 + x175 * x196 * x25 + x176 * x18 * x196,
            x170 * x18 * x202 + x170 * x201 * x25 + x171 * x18 * x201,
            x10 * x208 * x232 + x165 * x205 * x25 + x166 * x18 * x205,
            x15 * x184 * x193 + x184 * x228 * x69 + x188 * x69,
            x15 * x182 * x196 + x196 * x233 * x9 + x197 * x233,
            x15 * x176 * x201 + x201 * x234 * x9 + x202 * x234,
            x15 * x170 * x208 + x170 * x235 * x9 + x171 * x235,
            x15 * x166 * x210 + x210 * x232 * x9 + x213 * x64,
            x236 * x238 * x66 + x236 * x54 * x73 + x237 * x238,
            x236 * x37 * x75 + x236 * x40 * x74 + x237 * x37 * x74,
            x240 * x37 * x66 + x240 * x40 + x241 * x37 * x73,
            x236 * x28 * x97 + x236 * x32 * x92 + x237 * x28 * x92,
            x239 * x28 * x75 + x239 * x32 * x74 + x241 * x28 * x74,
            x243 * x28 * x66 + x243 * x32 + x244 * x28 * x73,
            x123 * x18 * x237 + x123 * x236 * x25 + x126 * x18 * x236,
            x18 * x239 * x97 + x18 * x241 * x92 + x239 * x25 * x92,
            x18 * x242 * x75 + x242 * x25 * x74 + x244 * x245 * x72,
            x10 * x247 + x245 * x246 * x66 + x246 * x25 * x73,
            x15 * x154 * x236 + x236 * x248 * x9 + x237 * x248,
            x123 * x15 * x241 + x123 * x249 * x9 + x126 * x249,
            x15 * x244 * x92 + x250 * x9 * x92 + x250 * x97,
            x15 * x246 * x75 + x190 * x246 * x72 * x9 + x247 * x72,
            x190
            * (
                x2 * (5.0 * x161 + x163 + x205 * x48 + 4.0 * x207)
                + x212 * x69
                + x23 * (2.0 * a * x251 - 2.0 * x156 - 2.0 * x157)
            )
            + x252 * x66
            + x252 * x9,
        ]
    )


def kinetic3d_30(a, A, b, B):
    """Cartesian 3D (fs) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = (2.0 * b + x0) ** (-1.0)
    x2 = (a + b) ** (-1.0)
    x3 = x2 * (a * A[0] + b * B[0]) - A[0]
    x4 = -a
    x5 = x3**2
    x6 = 2.0 * a**2
    x7 = -x4 - x6 * (x1 + x5)
    x8 = b * x2
    x9 = a * x8
    x10 = numpy.exp(-x9 * (A[0] - B[0]) ** 2)
    x11 = 1.77245385090552 * numpy.sqrt(x2)
    x12 = x10 * x11
    x13 = 2.0 * x12
    x14 = x12 * x3
    x15 = 4.0 * x9
    x16 = x0 * x8
    x17 = x14 * x16 + x14 * x7
    x18 = x1 * x12
    x19 = x12 * x5 + x18
    x20 = x17 * x3 + x18 * x7 + x8 * (x0 * x19 - x13)
    x21 = 2.0 * x18 * x3 + x19 * x3
    x22 = numpy.exp(-x9 * (A[1] - B[1]) ** 2)
    x23 = numpy.exp(-x9 * (A[2] - B[2]) ** 2)
    x24 = 3.14159265358979 * x2 * x23
    x25 = x22 * x24
    x26 = x2 * (a * A[1] + b * B[1]) - A[1]
    x27 = x26**2
    x28 = -x4 - x6 * (x1 + x27)
    x29 = x21 * x25
    x30 = x2 * (a * A[2] + b * B[2]) - A[2]
    x31 = x30**2
    x32 = -x4 - x6 * (x1 + x31)
    x33 = x11 * x22
    x34 = x26 * x33
    x35 = x16 * x34 + x28 * x34
    x36 = x11 * x23
    x37 = x20 * x25
    x38 = x19 * x25
    x39 = x30 * x36
    x40 = x16 * x39 + x32 * x39
    x41 = x1 * x33
    x42 = x27 * x33 + x41
    x43 = 2.0 * x33
    x44 = x26 * x35 + x28 * x41 + x8 * (x0 * x42 - x43)
    x45 = x10 * x24
    x46 = x44 * x45
    x47 = x3 * x45
    x48 = 3.14159265358979 * x10 * x2 * x22
    x49 = x3 * x48
    x50 = x1 * x36
    x51 = x31 * x36 + x50
    x52 = 2.0 * x36
    x53 = x30 * x40 + x32 * x50 + x8 * (x0 * x51 - x52)
    x54 = x48 * x53
    x55 = 2.0 * x26 * x41 + x26 * x42
    x56 = x45 * x55
    x57 = 2.0 * x30 * x50 + x30 * x51
    x58 = x48 * x57

    # 10 item(s)
    return numpy.array(
        [
            x25
            * (x1 * (x13 * x3 * x7 + x14 * x15) + x20 * x3 + x8 * (x0 * x21 - 3.0 * x14))
            + x28 * x29
            + x29 * x32,
            x19 * x35 * x36 + x26 * x32 * x38 + x26 * x37,
            x19 * x33 * x40 + x28 * x30 * x38 + x30 * x37,
            x17 * x36 * x42 + x3 * x46 + x32 * x42 * x47,
            x17 * x25 * x26 * x30 + x26 * x40 * x49 + x30 * x35 * x47,
            x17 * x33 * x51 + x28 * x49 * x51 + x3 * x54,
            x32 * x56
            + x45
            * (
                x1 * (x15 * x34 + x26 * x28 * x43)
                + x26 * x44
                + x8 * (x0 * x55 - 3.0 * x34)
            )
            + x56 * x7,
            x12 * x40 * x42 + x30 * x42 * x45 * x7 + x30 * x46,
            x12 * x35 * x51 + x26 * x48 * x51 * x7 + x26 * x54,
            x28 * x58
            + x48
            * (
                x1 * (x15 * x39 + x30 * x32 * x52)
                + x30 * x53
                + x8 * (x0 * x57 - 3.0 * x39)
            )
            + x58 * x7,
        ]
    )


def kinetic3d_31(a, A, b, B):
    """Cartesian 3D (fp) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = (2.0 * b + x0) ** (-1.0)
    x2 = (a + b) ** (-1.0)
    x3 = -x2 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = -a
    x6 = x4**2
    x7 = 2.0 * a**2
    x8 = -x5 - x7 * (x1 + x6)
    x9 = -x3 - B[0]
    x10 = b * x2
    x11 = a * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = 1.77245385090552 * numpy.sqrt(x2)
    x14 = x12 * x13
    x15 = x14 * x9
    x16 = x0 * x10
    x17 = x15 * x16 + x15 * x8
    x18 = x17 * x4
    x19 = x1 * x14
    x20 = x14 * x4
    x21 = x20 * x9
    x22 = x19 + x21
    x23 = 4.0 * x11
    x24 = x19 * x8
    x25 = x16 * x20 + x20 * x8
    x26 = x14 * x6
    x27 = x19 + x26
    x28 = 2.0 * x14
    x29 = x10 * (x0 * x27 - x28) + x25 * x4
    x30 = x16 * x22 + x18 + x24
    x31 = x1 * (x15 + x20) + x22 * x4
    x32 = x28 * x9
    x33 = x1 * (x17 + x25) + x10 * (x0 * x31 - x32) + x30 * x4
    x34 = 3.0 * x19
    x35 = x1 * (x26 + x32 * x4 + x34) + x31 * x4
    x36 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x37 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x38 = 3.14159265358979 * x2 * x37
    x39 = x36 * x38
    x40 = -x2 * (a * A[1] + b * B[1])
    x41 = -x40 - A[1]
    x42 = x41**2
    x43 = -x5 - x7 * (x1 + x42)
    x44 = x35 * x39
    x45 = -x2 * (a * A[2] + b * B[2])
    x46 = -x45 - A[2]
    x47 = x46**2
    x48 = -x5 - x7 * (x1 + x47)
    x49 = -x40 - B[1]
    x50 = x13 * x36
    x51 = x49 * x50
    x52 = x16 * x51 + x43 * x51
    x53 = 2.0 * x19 * x4 + x27 * x4
    x54 = x13 * x37
    x55 = x24 + x29
    x56 = x39 * (
        x1 * (x20 * x23 + x28 * x4 * x8) + x10 * (x0 * x53 - 3.0 * x20) + x4 * x55
    )
    x57 = x39 * x53
    x58 = -x45 - B[2]
    x59 = x54 * x58
    x60 = x16 * x59 + x48 * x59
    x61 = x41 * x50
    x62 = x16 * x61 + x43 * x61
    x63 = x33 * x39
    x64 = x39 * x41
    x65 = x41 * x52
    x66 = x1 * x13
    x67 = x36 * x66
    x68 = x49 * x61
    x69 = x67 + x68
    x70 = x43 * x67
    x71 = x16 * x69 + x65 + x70
    x72 = x27 * x54
    x73 = x46 * x54
    x74 = x16 * x73 + x48 * x73
    x75 = x39 * x46
    x76 = x46 * x60
    x77 = x37 * x66
    x78 = x58 * x73
    x79 = x77 + x78
    x80 = x48 * x77
    x81 = x16 * x79 + x76 + x80
    x82 = x27 * x50
    x83 = x42 * x50
    x84 = x67 + x83
    x85 = x54 * x84
    x86 = 2.0 * x50
    x87 = x10 * (x0 * x84 - x86) + x41 * x62
    x88 = x70 + x87
    x89 = x1 * (x51 + x61) + x41 * x69
    x90 = x49 * x86
    x91 = x1 * (x52 + x62) + x10 * (x0 * x89 - x90) + x41 * x71
    x92 = x12 * x38
    x93 = x91 * x92
    x94 = x4 * x92
    x95 = 3.14159265358979 * x12 * x2 * x36
    x96 = x4 * x95
    x97 = x47 * x54
    x98 = x77 + x97
    x99 = x50 * x98
    x100 = 2.0 * x54
    x101 = x10 * (x0 * x98 - x100) + x46 * x74
    x102 = x101 + x80
    x103 = x1 * (x59 + x73) + x46 * x79
    x104 = x100 * x58
    x105 = x1 * (x60 + x74) + x10 * (x0 * x103 - x104) + x46 * x81
    x106 = x105 * x95
    x107 = 2.0 * x41 * x67 + x41 * x84
    x108 = x92 * (
        x1 * (x23 * x61 + x41 * x43 * x86) + x10 * (x0 * x107 - 3.0 * x61) + x41 * x88
    )
    x109 = x107 * x92
    x110 = 3.0 * x67
    x111 = x1 * (x110 + x41 * x90 + x83) + x41 * x89
    x112 = x111 * x92
    x113 = x46 * x92
    x114 = x14 * x84
    x115 = x41 * x95
    x116 = x14 * x98
    x117 = 2.0 * x46 * x77 + x46 * x98
    x118 = x95 * (
        x1 * (x100 * x46 * x48 + x23 * x73) + x10 * (x0 * x117 - 3.0 * x73) + x102 * x46
    )
    x119 = x117 * x95
    x120 = 3.0 * x77
    x121 = x1 * (x104 * x46 + x120 + x97) + x103 * x46
    x122 = x121 * x95

    # 30 item(s)
    return numpy.array(
        [
            x39
            * (
                x1 * (2.0 * x18 + x22 * x23 + 3.0 * x24 + x29)
                + x10 * (2.0 * a * x35 - 3.0 * x21 - x34)
                + x33 * x4
            )
            + x43 * x44
            + x44 * x48,
            x48 * x49 * x57 + x49 * x56 + x52 * x53 * x54,
            x43 * x57 * x58 + x50 * x53 * x60 + x56 * x58,
            x31 * x48 * x64 + x31 * x54 * x62 + x41 * x63,
            x48 * x69 * x72 + x54 * x55 * x69 + x71 * x72,
            x27 * x59 * x62 + x27 * x60 * x61 + x55 * x58 * x64,
            x31 * x43 * x75 + x31 * x50 * x74 + x46 * x63,
            x27 * x51 * x74 + x27 * x52 * x73 + x49 * x55 * x75,
            x43 * x79 * x82 + x50 * x55 * x79 + x81 * x82,
            x22 * x48 * x85 + x22 * x54 * x88 + x30 * x85,
            x25 * x54 * x89 + x4 * x93 + x48 * x89 * x94,
            x20 * x60 * x84 + x25 * x59 * x84 + x58 * x88 * x94,
            x22 * x61 * x74 + x22 * x62 * x73 + x30 * x46 * x64,
            x20 * x69 * x74 + x25 * x69 * x73 + x46 * x71 * x94,
            x20 * x62 * x79 + x25 * x61 * x79 + x41 * x81 * x96,
            x102 * x22 * x50 + x22 * x43 * x99 + x30 * x99,
            x102 * x49 * x96 + x20 * x52 * x98 + x25 * x51 * x98,
            x103 * x25 * x50 + x103 * x43 * x96 + x106 * x4,
            x107 * x17 * x54 + x108 * x9 + x109 * x48 * x9,
            x112 * x48
            + x112 * x8
            + x92
            * (
                x1 * (x23 * x69 + 2.0 * x65 + 3.0 * x70 + x87)
                + x10 * (2.0 * a * x111 - x110 - 3.0 * x68)
                + x41 * x91
            ),
            x107 * x14 * x60 + x108 * x58 + x109 * x58 * x8,
            x113 * x88 * x9 + x15 * x74 * x84 + x17 * x73 * x84,
            x113 * x8 * x89 + x14 * x74 * x89 + x46 * x93,
            x114 * x79 * x8 + x114 * x81 + x14 * x79 * x88,
            x102 * x115 * x9 + x15 * x62 * x98 + x17 * x61 * x98,
            x102 * x14 * x69 + x116 * x69 * x8 + x116 * x71,
            x103 * x115 * x8 + x103 * x14 * x62 + x106 * x41,
            x117 * x17 * x50 + x118 * x9 + x119 * x43 * x9,
            x117 * x14 * x52 + x118 * x49 + x119 * x49 * x8,
            x122 * x43
            + x122 * x8
            + x95
            * (
                x1 * (x101 + x23 * x79 + 2.0 * x76 + 3.0 * x80)
                + x10 * (2.0 * a * x121 - x120 - 3.0 * x78)
                + x105 * x46
            ),
        ]
    )


def kinetic3d_32(a, A, b, B):
    """Cartesian 3D (fd) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = -a
    x4 = (a + b) ** (-1.0)
    x5 = -x4 * (a * A[0] + b * B[0])
    x6 = -x5 - A[0]
    x7 = x6**2
    x8 = 2.0 * a**2
    x9 = -x3 - x8 * (x2 + x7)
    x10 = -x5 - B[0]
    x11 = a * x4
    x12 = b * x11
    x13 = numpy.exp(-x12 * (A[0] - B[0]) ** 2)
    x14 = 1.77245385090552 * numpy.sqrt(x4)
    x15 = x13 * x14
    x16 = 2.0 * x15
    x17 = x10 * x16
    x18 = x10 * x15
    x19 = 4.0 * x12
    x20 = x2 * (x17 * x9 + x18 * x19)
    x21 = b * x4
    x22 = x0 * x21
    x23 = x18 * x22 + x18 * x9
    x24 = x15 * x6
    x25 = x22 * x24 + x24 * x9
    x26 = x2 * (x23 + x25)
    x27 = x23 * x6
    x28 = x15 * x2
    x29 = x10 * x24
    x30 = x28 + x29
    x31 = x28 * x9
    x32 = x22 * x30 + x27 + x31
    x33 = x32 * x6
    x34 = x10**2 * x15
    x35 = x28 + x34
    x36 = -x16
    x37 = x10 * x23 + x11 * (x1 * x35 + x36)
    x38 = x31 + x37
    x39 = x38 * x6
    x40 = x2 * (x18 + x24)
    x41 = x30 * x6
    x42 = x40 + x41
    x43 = x0 * x42 - x17
    x44 = x1 * x4
    x45 = x35 * x6
    x46 = 2.0 * x28
    x47 = x10 * x46 + x45
    x48 = x19 * x30 + 2.0 * x27 + 3.0 * x31
    x49 = x20 + x22 * x47 + x39
    x50 = 3.0 * x28
    x51 = x17 * x6 + x50
    x52 = x2 * (x34 + x51) + x47 * x6
    x53 = x2 * (x37 + x48) + x21 * (2.0 * a * x52 - 2.0 * x34 - x46) + x49 * x6
    x54 = x10 * x28
    x55 = x2 * (2.0 * x40 + 2.0 * x41 + 2.0 * x45 + 4.0 * x54) + x52 * x6
    x56 = numpy.exp(-x12 * (A[1] - B[1]) ** 2)
    x57 = numpy.exp(-x12 * (A[2] - B[2]) ** 2)
    x58 = 3.14159265358979 * x4 * x57
    x59 = x56 * x58
    x60 = -x4 * (a * A[1] + b * B[1])
    x61 = -x60 - A[1]
    x62 = x61**2
    x63 = -x3 - x8 * (x2 + x62)
    x64 = x55 * x59
    x65 = -x4 * (a * A[2] + b * B[2])
    x66 = -x65 - A[2]
    x67 = x66**2
    x68 = -x3 - x8 * (x2 + x67)
    x69 = -x60 - B[1]
    x70 = x14 * x56
    x71 = x69 * x70
    x72 = x22 * x71 + x63 * x71
    x73 = x15 * x7
    x74 = x2 * (x51 + x73) + x42 * x6
    x75 = x14 * x57
    x76 = x28 + x73
    x77 = x21 * (x0 * x76 + x36) + x25 * x6
    x78 = x21 * x43 + x26 + x33
    x79 = x59 * (x2 * (x48 + x77) + x21 * (2.0 * a * x74 - 3.0 * x29 - x50) + x6 * x78)
    x80 = x59 * x74
    x81 = -x65 - B[2]
    x82 = x75 * x81
    x83 = x22 * x82 + x68 * x82
    x84 = x2 * x70
    x85 = x63 * x84
    x86 = x69**2 * x70
    x87 = x84 + x86
    x88 = 2.0 * x70
    x89 = -x88
    x90 = x11 * (x1 * x87 + x89) + x69 * x72
    x91 = x85 + x90
    x92 = x46 * x6 + x6 * x76
    x93 = x75 * x92
    x94 = x31 + x77
    x95 = x2 * (x16 * x6 * x9 + x19 * x24) + x21 * (x0 * x92 - 3.0 * x24) + x6 * x94
    x96 = x59 * x81
    x97 = x2 * x75
    x98 = x68 * x97
    x99 = x75 * x81**2
    x100 = x97 + x99
    x101 = 2.0 * x75
    x102 = -x101
    x103 = x11 * (x1 * x100 + x102) + x81 * x83
    x104 = x103 + x98
    x105 = x70 * x92
    x106 = x61 * x70
    x107 = x106 * x22 + x106 * x63
    x108 = x53 * x59
    x109 = x52 * x59
    x110 = x61 * x72
    x111 = x106 * x69
    x112 = x111 + x84
    x113 = x110 + x112 * x22 + x85
    x114 = x42 * x75
    x115 = x61 * x87
    x116 = 2.0 * x84
    x117 = x115 + x116 * x69
    x118 = x117 * x75
    x119 = x69 * x88
    x120 = x2 * (x119 * x63 + x19 * x71)
    x121 = x61 * x91
    x122 = x117 * x22 + x120 + x121
    x123 = x66 * x75
    x124 = x123 * x22 + x123 * x68
    x125 = x59 * x66
    x126 = x66 * x83
    x127 = x123 * x81
    x128 = x127 + x97
    x129 = x126 + x128 * x22 + x98
    x130 = x42 * x70
    x131 = x100 * x66
    x132 = 2.0 * x97
    x133 = x131 + x132 * x81
    x134 = x133 * x70
    x135 = x101 * x81
    x136 = x2 * (x135 * x68 + x19 * x82)
    x137 = x104 * x66
    x138 = x133 * x22 + x136 + x137
    x139 = x62 * x70
    x140 = x139 + x84
    x141 = x107 * x61 + x21 * (x0 * x140 + x89)
    x142 = x141 + x85
    x143 = x47 * x75
    x144 = x2 * (x106 + x71)
    x145 = x112 * x61
    x146 = x144 + x145
    x147 = x146 * x75
    x148 = x2 * (x107 + x72)
    x149 = x113 * x61
    x150 = x0 * x146 - x119
    x151 = x148 + x149 + x150 * x21
    x152 = 3.0 * x84
    x153 = x119 * x61 + x152
    x154 = x117 * x61 + x2 * (x153 + x86)
    x155 = 2.0 * x110 + x112 * x19 + 3.0 * x85
    x156 = x122 * x61 + x2 * (x155 + x90) + x21 * (2.0 * a * x154 - x116 - 2.0 * x86)
    x157 = x13 * x58
    x158 = x156 * x157
    x159 = x157 * x6
    x160 = 3.14159265358979 * x13 * x4 * x56
    x161 = x160 * x6
    x162 = x67 * x75
    x163 = x162 + x97
    x164 = x124 * x66 + x21 * (x0 * x163 + x102)
    x165 = x164 + x98
    x166 = x47 * x70
    x167 = x2 * (x123 + x82)
    x168 = x128 * x66
    x169 = x167 + x168
    x170 = x169 * x70
    x171 = x2 * (x124 + x83)
    x172 = x129 * x66
    x173 = x0 * x169 - x135
    x174 = x171 + x172 + x173 * x21
    x175 = 3.0 * x97
    x176 = x135 * x66 + x175
    x177 = x133 * x66 + x2 * (x176 + x99)
    x178 = 2.0 * x126 + x128 * x19 + 3.0 * x98
    x179 = x138 * x66 + x2 * (x103 + x178) + x21 * (2.0 * a * x177 - x132 - 2.0 * x99)
    x180 = x160 * x179
    x181 = x116 * x61 + x140 * x61
    x182 = x181 * x75
    x183 = (
        x142 * x61 + x2 * (x106 * x19 + x61 * x63 * x88) + x21 * (x0 * x181 - 3.0 * x106)
    )
    x184 = x146 * x61 + x2 * (x139 + x153)
    x185 = x157 * (
        x151 * x61 + x2 * (x141 + x155) + x21 * (2.0 * a * x184 - 3.0 * x111 - x152)
    )
    x186 = x10 * x157
    x187 = x69 * x84
    x188 = x154 * x61 + x2 * (2.0 * x115 + 2.0 * x144 + 2.0 * x145 + 4.0 * x187)
    x189 = x157 * x188
    x190 = x157 * x9
    x191 = x15 * x181
    x192 = x146 * x15
    x193 = x133 * x15
    x194 = x160 * x61
    x195 = x117 * x15
    x196 = x15 * x169
    x197 = x132 * x66 + x163 * x66
    x198 = x197 * x70
    x199 = (
        x165 * x66 + x2 * (x101 * x66 * x68 + x123 * x19) + x21 * (x0 * x197 - 3.0 * x123)
    )
    x200 = x10 * x160
    x201 = x169 * x66 + x2 * (x162 + x176)
    x202 = x160 * (
        x174 * x66 + x2 * (x164 + x178) + x21 * (2.0 * a * x201 - 3.0 * x127 - x175)
    )
    x203 = x15 * x197
    x204 = x81 * x97
    x205 = x177 * x66 + x2 * (2.0 * x131 + 2.0 * x167 + 2.0 * x168 + 4.0 * x204)
    x206 = x160 * x205

    # 60 item(s)
    return numpy.array(
        [
            x59
            * (
                x2
                * (x19 * x47 + 2.0 * x20 + 2.0 * x26 + 2.0 * x33 + 2.0 * x39 + x43 * x44)
                + x21 * (2.0 * a * x55 - 3.0 * x45 - 6.0 * x54)
                + x53 * x6
            )
            + x63 * x64
            + x64 * x68,
            x68 * x69 * x80 + x69 * x79 + x72 * x74 * x75,
            x63 * x80 * x81 + x70 * x74 * x83 + x79 * x81,
            x68 * x87 * x93 + x75 * x87 * x95 + x91 * x93,
            x69 * x95 * x96 + x71 * x83 * x92 + x72 * x82 * x92,
            x100 * x105 * x63 + x100 * x70 * x95 + x104 * x105,
            x107 * x52 * x75 + x108 * x61 + x109 * x61 * x68,
            x112 * x114 * x68 + x112 * x75 * x78 + x113 * x114,
            x106 * x42 * x83 + x107 * x42 * x82 + x61 * x78 * x96,
            x118 * x68 * x76 + x118 * x94 + x122 * x75 * x76,
            x112 * x76 * x83 + x112 * x82 * x94 + x113 * x76 * x82,
            x100 * x106 * x94 + x100 * x107 * x76 + x104 * x106 * x76,
            x108 * x66 + x109 * x63 * x66 + x124 * x52 * x70,
            x123 * x42 * x72 + x124 * x42 * x71 + x125 * x69 * x78,
            x128 * x130 * x63 + x128 * x70 * x78 + x129 * x130,
            x123 * x76 * x91 + x123 * x87 * x94 + x124 * x76 * x87,
            x128 * x71 * x94 + x128 * x72 * x76 + x129 * x71 * x76,
            x134 * x63 * x76 + x134 * x94 + x138 * x70 * x76,
            x140 * x143 * x68 + x140 * x49 * x75 + x142 * x143,
            x147 * x30 * x68 + x147 * x32 + x151 * x30 * x75,
            x140 * x30 * x83 + x140 * x32 * x82 + x142 * x30 * x82,
            x154 * x159 * x68 + x154 * x25 * x75 + x158 * x6,
            x146 * x24 * x83 + x146 * x25 * x82 + x151 * x159 * x81,
            x100 * x140 * x25 + x100 * x142 * x24 + x104 * x140 * x24,
            x106 * x124 * x47 + x107 * x123 * x47 + x125 * x49 * x61,
            x112 * x123 * x32 + x112 * x124 * x30 + x113 * x123 * x30,
            x106 * x128 * x32 + x106 * x129 * x30 + x107 * x128 * x30,
            x117 * x123 * x25 + x117 * x124 * x24 + x122 * x159 * x66,
            x112 * x128 * x25 + x112 * x129 * x24 + x113 * x128 * x24,
            x106 * x133 * x25 + x107 * x133 * x24 + x138 * x161 * x61,
            x163 * x166 * x63 + x163 * x49 * x70 + x165 * x166,
            x163 * x30 * x72 + x163 * x32 * x71 + x165 * x30 * x71,
            x170 * x30 * x63 + x170 * x32 + x174 * x30 * x70,
            x163 * x24 * x91 + x163 * x25 * x87 + x165 * x24 * x87,
            x161 * x174 * x69 + x169 * x24 * x72 + x169 * x25 * x71,
            x161 * x177 * x63 + x177 * x25 * x70 + x180 * x6,
            x182 * x35 * x68 + x182 * x38 + x183 * x35 * x75,
            x10 * x185 + x184 * x186 * x68 + x184 * x23 * x75,
            x18 * x181 * x83 + x181 * x23 * x82 + x183 * x186 * x81,
            x157
            * (
                x156 * x61
                + x2
                * (
                    x117 * x19
                    + 2.0 * x120
                    + 2.0 * x121
                    + 2.0 * x148
                    + 2.0 * x149
                    + x150 * x44
                )
                + x21 * (2.0 * a * x188 - 3.0 * x115 - 6.0 * x187)
            )
            + x189 * x68
            + x189 * x9,
            x15 * x184 * x83 + x184 * x190 * x81 + x185 * x81,
            x100 * x15 * x183 + x100 * x191 * x9 + x104 * x191,
            x123 * x140 * x38 + x123 * x142 * x35 + x124 * x140 * x35,
            x123 * x146 * x23 + x124 * x146 * x18 + x151 * x186 * x66,
            x128 * x140 * x23 + x128 * x142 * x18 + x129 * x140 * x18,
            x124 * x15 * x154 + x154 * x190 * x66 + x158 * x66,
            x128 * x15 * x151 + x128 * x192 * x9 + x129 * x192,
            x138 * x140 * x15 + x140 * x193 * x9 + x142 * x193,
            x106 * x163 * x38 + x106 * x165 * x35 + x107 * x163 * x35,
            x112 * x163 * x23 + x112 * x165 * x18 + x113 * x163 * x18,
            x10 * x174 * x194 + x106 * x169 * x23 + x107 * x169 * x18,
            x122 * x15 * x163 + x163 * x195 * x9 + x165 * x195,
            x112 * x15 * x174 + x112 * x196 * x9 + x113 * x196,
            x107 * x15 * x177 + x177 * x194 * x9 + x180 * x61,
            x198 * x35 * x63 + x198 * x38 + x199 * x35 * x70,
            x18 * x197 * x72 + x197 * x23 * x71 + x199 * x200 * x69,
            x10 * x202 + x200 * x201 * x63 + x201 * x23 * x70,
            x15 * x199 * x87 + x203 * x87 * x9 + x203 * x91,
            x15 * x201 * x72 + x160 * x201 * x69 * x9 + x202 * x69,
            x160
            * (
                x179 * x66
                + x2
                * (
                    x133 * x19
                    + 2.0 * x136
                    + 2.0 * x137
                    + 2.0 * x171
                    + 2.0 * x172
                    + x173 * x44
                )
                + x21 * (2.0 * a * x205 - 3.0 * x131 - 6.0 * x204)
            )
            + x206 * x63
            + x206 * x9,
        ]
    )


def kinetic3d_33(a, A, b, B):
    """Cartesian 3D (ff) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - B[0]
    x6 = -a
    x7 = -x4 - A[0]
    x8 = x7**2
    x9 = 2.0 * a**2
    x10 = -x6 - x9 * (x2 + x8)
    x11 = a * x3
    x12 = b * x11
    x13 = numpy.exp(-x12 * (A[0] - B[0]) ** 2)
    x14 = 1.77245385090552 * numpy.sqrt(x3)
    x15 = x13 * x14
    x16 = x15 * x5
    x17 = b * x3
    x18 = x0 * x17
    x19 = x10 * x16 + x16 * x18
    x20 = x19 * x5
    x21 = x15 * x5**2
    x22 = x15 * x2
    x23 = x21 + x22
    x24 = 2.0 * x15
    x25 = -x24
    x26 = x11 * (x1 * x23 + x25)
    x27 = x10 * x22
    x28 = 3.0 * x27
    x29 = x2 * (3.0 * x20 + 3.0 * x26 + x28)
    x30 = x24 * x5
    x31 = 4.0 * x12
    x32 = x2 * (x10 * x30 + x16 * x31)
    x33 = x20 + x26
    x34 = x27 + x33
    x35 = x23 * x5
    x36 = 2.0 * x22
    x37 = x36 * x5
    x38 = x35 + x37
    x39 = x11 * (x1 * x38 - 3.0 * x16) + x34 * x5
    x40 = x32 + x39
    x41 = x40 * x7
    x42 = x19 * x7
    x43 = x15 * x7
    x44 = x43 * x5
    x45 = x22 + x44
    x46 = x28 + x31 * x45 + 2.0 * x42
    x47 = x2 * (x33 + x46)
    x48 = x34 * x7
    x49 = x23 * x7
    x50 = x37 + x49
    x51 = x18 * x50 + x32 + x48
    x52 = x51 * x7
    x53 = 3.0 * x22
    x54 = x30 * x7 + x53
    x55 = x2 * (x21 + x54)
    x56 = x50 * x7
    x57 = x55 + x56
    x58 = x17 * (2.0 * a * x57 - 2.0 * x21 - x36)
    x59 = x2 * (3.0 * x21 + x53)
    x60 = x38 * x7
    x61 = x59 + x60
    x62 = 6.0 * x12
    x63 = x18 * x61 + x29 + x41
    x64 = 3.0 * x49
    x65 = x22 * x5
    x66 = x2 * (x35 + x64 + 8.0 * x65) + x61 * x7
    x67 = 4.0 * x65
    x68 = (
        x17 * (2.0 * a * x66 - 2.0 * x35 - x67)
        + x2 * (4.0 * x32 + x39 + 3.0 * x48 + x50 * x62)
        + x63 * x7
    )
    x69 = x2 * (3.0 * x55 + 3.0 * x56 + 2.0 * x59 + 2.0 * x60) + x66 * x7
    x70 = numpy.exp(-x12 * (A[1] - B[1]) ** 2)
    x71 = numpy.exp(-x12 * (A[2] - B[2]) ** 2)
    x72 = 3.14159265358979 * x3 * x71
    x73 = x70 * x72
    x74 = -x3 * (a * A[1] + b * B[1])
    x75 = -x74 - A[1]
    x76 = x75**2
    x77 = -x6 - x9 * (x2 + x76)
    x78 = x69 * x73
    x79 = -x3 * (a * A[2] + b * B[2])
    x80 = -x79 - A[2]
    x81 = x80**2
    x82 = -x6 - x9 * (x2 + x81)
    x83 = -x74 - B[1]
    x84 = x14 * x70
    x85 = x83 * x84
    x86 = x18 * x85 + x77 * x85
    x87 = x2 * (x16 + x43)
    x88 = x45 * x7
    x89 = x2 * (2.0 * x49 + x67 + 2.0 * x87 + 2.0 * x88) + x57 * x7
    x90 = x14 * x71
    x91 = x10 * x43 + x18 * x43
    x92 = x2 * (x19 + x91)
    x93 = x18 * x45 + x27 + x42
    x94 = x7 * x93
    x95 = x87 + x88
    x96 = x0 * x95 - x30
    x97 = x1 * x3
    x98 = x47 + x52 + x58
    x99 = x73 * (
        x17 * (2.0 * a * x89 - x64 - 6.0 * x65)
        + x2 * (x31 * x50 + 2.0 * x32 + 2.0 * x48 + 2.0 * x92 + 2.0 * x94 + x96 * x97)
        + x7 * x98
    )
    x100 = x73 * x89
    x101 = -x79 - B[2]
    x102 = x101 * x90
    x103 = x102 * x18 + x102 * x82
    x104 = x2 * x84
    x105 = x104 * x77
    x106 = x83 * x86
    x107 = x83**2 * x84
    x108 = x104 + x107
    x109 = 2.0 * x84
    x110 = -x109
    x111 = x11 * (x1 * x108 + x110)
    x112 = x106 + x111
    x113 = x105 + x112
    x114 = x15 * x8
    x115 = x2 * (x114 + x54) + x7 * x95
    x116 = x115 * x90
    x117 = x114 + x22
    x118 = x17 * (x0 * x117 + x25) + x7 * x91
    x119 = x17 * x96 + x92 + x94
    x120 = x119 * x7 + x17 * (2.0 * a * x115 - 3.0 * x44 - x53) + x2 * (x118 + x46)
    x121 = x101 * x73
    x122 = x2 * x90
    x123 = x122 * x82
    x124 = x101 * x103
    x125 = x101**2 * x90
    x126 = x122 + x125
    x127 = 2.0 * x90
    x128 = -x127
    x129 = x11 * (x1 * x126 + x128)
    x130 = x124 + x129
    x131 = x123 + x130
    x132 = x115 * x84
    x133 = x109 * x83
    x134 = x2 * (x133 * x77 + x31 * x85)
    x135 = x108 * x83
    x136 = 2.0 * x104
    x137 = x136 * x83
    x138 = x135 + x137
    x139 = x11 * (x1 * x138 - 3.0 * x85) + x113 * x83
    x140 = x134 + x139
    x141 = x117 * x7 + x36 * x7
    x142 = x141 * x90
    x143 = x118 + x27
    x144 = x143 * x7 + x17 * (x0 * x141 - 3.0 * x43) + x2 * (x10 * x24 * x7 + x31 * x43)
    x145 = x101 * x127
    x146 = x2 * (x102 * x31 + x145 * x82)
    x147 = x101 * x126
    x148 = 2.0 * x122
    x149 = x101 * x148
    x150 = x147 + x149
    x151 = x101 * x131 + x11 * (x1 * x150 - 3.0 * x102)
    x152 = x146 + x151
    x153 = x141 * x84
    x154 = x75 * x84
    x155 = x154 * x18 + x154 * x77
    x156 = x68 * x73
    x157 = x66 * x73
    x158 = x75 * x86
    x159 = x154 * x83
    x160 = x104 + x159
    x161 = x105 + x158 + x160 * x18
    x162 = x57 * x90
    x163 = x113 * x75
    x164 = x108 * x75
    x165 = x137 + x164
    x166 = x134 + x163 + x165 * x18
    x167 = x90 * x95
    x168 = 3.0 * x104
    x169 = x2 * (3.0 * x107 + x168)
    x170 = x138 * x75
    x171 = x169 + x170
    x172 = x171 * x90
    x173 = 3.0 * x105
    x174 = x2 * (3.0 * x106 + 3.0 * x111 + x173)
    x175 = x140 * x75
    x176 = x171 * x18 + x174 + x175
    x177 = x80 * x90
    x178 = x177 * x18 + x177 * x82
    x179 = x73 * x80
    x180 = x103 * x80
    x181 = x101 * x177
    x182 = x122 + x181
    x183 = x123 + x18 * x182 + x180
    x184 = x57 * x84
    x185 = x131 * x80
    x186 = x126 * x80
    x187 = x149 + x186
    x188 = x146 + x18 * x187 + x185
    x189 = x84 * x95
    x190 = 3.0 * x122
    x191 = x2 * (3.0 * x125 + x190)
    x192 = x150 * x80
    x193 = x191 + x192
    x194 = x193 * x84
    x195 = 3.0 * x123
    x196 = x2 * (3.0 * x124 + 3.0 * x129 + x195)
    x197 = x152 * x80
    x198 = x18 * x193 + x196 + x197
    x199 = x76 * x84
    x200 = x104 + x199
    x201 = x155 * x75 + x17 * (x0 * x200 + x110)
    x202 = x105 + x201
    x203 = x61 * x90
    x204 = x2 * (x154 + x85)
    x205 = x160 * x75
    x206 = x204 + x205
    x207 = x206 * x90
    x208 = x2 * (x155 + x86)
    x209 = x161 * x75
    x210 = x0 * x206 - x133
    x211 = x17 * x210 + x208 + x209
    x212 = x133 * x75 + x168
    x213 = x2 * (x107 + x212)
    x214 = x165 * x75
    x215 = x213 + x214
    x216 = x215 * x90
    x217 = 2.0 * x158 + x160 * x31 + x173
    x218 = x2 * (x112 + x217)
    x219 = x166 * x75
    x220 = x17 * (2.0 * a * x215 - 2.0 * x107 - x136)
    x221 = x218 + x219 + x220
    x222 = 3.0 * x164
    x223 = x104 * x83
    x224 = x171 * x75 + x2 * (x135 + x222 + 8.0 * x223)
    x225 = 4.0 * x223
    x226 = (
        x17 * (2.0 * a * x224 - 2.0 * x135 - x225)
        + x176 * x75
        + x2 * (4.0 * x134 + x139 + 3.0 * x163 + x165 * x62)
    )
    x227 = x13 * x72
    x228 = x226 * x227
    x229 = x227 * x7
    x230 = 3.14159265358979 * x13 * x3 * x70
    x231 = x230 * x7
    x232 = x81 * x90
    x233 = x122 + x232
    x234 = x17 * (x0 * x233 + x128) + x178 * x80
    x235 = x123 + x234
    x236 = x61 * x84
    x237 = x2 * (x102 + x177)
    x238 = x182 * x80
    x239 = x237 + x238
    x240 = x239 * x84
    x241 = x2 * (x103 + x178)
    x242 = x183 * x80
    x243 = x0 * x239 - x145
    x244 = x17 * x243 + x241 + x242
    x245 = x145 * x80 + x190
    x246 = x2 * (x125 + x245)
    x247 = x187 * x80
    x248 = x246 + x247
    x249 = x248 * x84
    x250 = 2.0 * x180 + x182 * x31 + x195
    x251 = x2 * (x130 + x250)
    x252 = x188 * x80
    x253 = x17 * (2.0 * a * x248 - 2.0 * x125 - x148)
    x254 = x251 + x252 + x253
    x255 = 3.0 * x186
    x256 = x101 * x122
    x257 = x193 * x80 + x2 * (x147 + x255 + 8.0 * x256)
    x258 = 4.0 * x256
    x259 = (
        x17 * (2.0 * a * x257 - 2.0 * x147 - x258)
        + x198 * x80
        + x2 * (4.0 * x146 + x151 + 3.0 * x185 + x187 * x62)
    )
    x260 = x230 * x259
    x261 = x136 * x75 + x200 * x75
    x262 = x261 * x90
    x263 = (
        x17 * (x0 * x261 - 3.0 * x154) + x2 * (x109 * x75 * x77 + x154 * x31) + x202 * x75
    )
    x264 = x2 * (x199 + x212) + x206 * x75
    x265 = x264 * x90
    x266 = x17 * (2.0 * a * x264 - 3.0 * x159 - x168) + x2 * (x201 + x217) + x211 * x75
    x267 = x2 * (2.0 * x164 + 2.0 * x204 + 2.0 * x205 + x225) + x215 * x75
    x268 = x227 * (
        x17 * (2.0 * a * x267 - x222 - 6.0 * x223)
        + x2
        * (2.0 * x134 + 2.0 * x163 + x165 * x31 + 2.0 * x208 + 2.0 * x209 + x210 * x97)
        + x221 * x75
    )
    x269 = x227 * x5
    x270 = x2 * (2.0 * x169 + 2.0 * x170 + 3.0 * x213 + 3.0 * x214) + x224 * x75
    x271 = x227 * x270
    x272 = x10 * x227
    x273 = x15 * x264
    x274 = x15 * x261
    x275 = x15 * x215
    x276 = x15 * x206
    x277 = x15 * x193
    x278 = x230 * x75
    x279 = x15 * x171
    x280 = x15 * x239
    x281 = x15 * x248
    x282 = x148 * x80 + x233 * x80
    x283 = x282 * x84
    x284 = (
        x17 * (x0 * x282 - 3.0 * x177) + x2 * (x127 * x80 * x82 + x177 * x31) + x235 * x80
    )
    x285 = x2 * (x232 + x245) + x239 * x80
    x286 = x285 * x84
    x287 = x17 * (2.0 * a * x285 - 3.0 * x181 - x190) + x2 * (x234 + x250) + x244 * x80
    x288 = x230 * x5
    x289 = x2 * (2.0 * x186 + 2.0 * x237 + 2.0 * x238 + x258) + x248 * x80
    x290 = x230 * (
        x17 * (2.0 * a * x289 - x255 - 6.0 * x256)
        + x2
        * (2.0 * x146 + 2.0 * x185 + x187 * x31 + 2.0 * x241 + 2.0 * x242 + x243 * x97)
        + x254 * x80
    )
    x291 = x15 * x282
    x292 = x15 * x285
    x293 = x2 * (2.0 * x191 + 2.0 * x192 + 3.0 * x246 + 3.0 * x247) + x257 * x80
    x294 = x230 * x293

    # 100 item(s)
    return numpy.array(
        [
            x73
            * (
                x17 * (2.0 * a * x69 - 3.0 * x59 - 3.0 * x60)
                + x2
                * (2.0 * x29 + x31 * x61 + 2.0 * x41 + 3.0 * x47 + 3.0 * x52 + 3.0 * x58)
                + x68 * x7
            )
            + x77 * x78
            + x78 * x82,
            x100 * x82 * x83 + x83 * x99 + x86 * x89 * x90,
            x100 * x101 * x77 + x101 * x99 + x103 * x84 * x89,
            x108 * x116 * x82 + x108 * x120 * x90 + x113 * x116,
            x102 * x115 * x86 + x103 * x115 * x85 + x120 * x121 * x83,
            x120 * x126 * x84 + x126 * x132 * x77 + x131 * x132,
            x138 * x142 * x82 + x138 * x144 * x90 + x140 * x142,
            x102 * x108 * x144 + x102 * x113 * x141 + x103 * x108 * x141,
            x126 * x141 * x86 + x126 * x144 * x85 + x131 * x141 * x85,
            x144 * x150 * x84 + x150 * x153 * x77 + x152 * x153,
            x155 * x66 * x90 + x156 * x75 + x157 * x75 * x82,
            x160 * x162 * x82 + x160 * x90 * x98 + x161 * x162,
            x102 * x155 * x57 + x103 * x154 * x57 + x121 * x75 * x98,
            x119 * x165 * x90 + x165 * x167 * x82 + x166 * x167,
            x102 * x119 * x160 + x102 * x161 * x95 + x103 * x160 * x95,
            x119 * x126 * x154 + x126 * x155 * x95 + x131 * x154 * x95,
            x117 * x172 * x82 + x117 * x176 * x90 + x143 * x172,
            x102 * x117 * x166 + x102 * x143 * x165 + x103 * x117 * x165,
            x117 * x126 * x161 + x117 * x131 * x160 + x126 * x143 * x160,
            x117 * x150 * x155 + x117 * x152 * x154 + x143 * x150 * x154,
            x156 * x80 + x157 * x77 * x80 + x178 * x66 * x84,
            x177 * x57 * x86 + x178 * x57 * x85 + x179 * x83 * x98,
            x182 * x184 * x77 + x182 * x84 * x98 + x183 * x184,
            x108 * x119 * x177 + x108 * x178 * x95 + x113 * x177 * x95,
            x119 * x182 * x85 + x182 * x86 * x95 + x183 * x85 * x95,
            x119 * x187 * x84 + x187 * x189 * x77 + x188 * x189,
            x117 * x138 * x178 + x117 * x140 * x177 + x138 * x143 * x177,
            x108 * x117 * x183 + x108 * x143 * x182 + x113 * x117 * x182,
            x117 * x187 * x86 + x117 * x188 * x85 + x143 * x187 * x85,
            x117 * x194 * x77 + x117 * x198 * x84 + x143 * x194,
            x200 * x203 * x82 + x200 * x63 * x90 + x202 * x203,
            x207 * x50 * x82 + x207 * x51 + x211 * x50 * x90,
            x102 * x200 * x51 + x102 * x202 * x50 + x103 * x200 * x50,
            x216 * x45 * x82 + x216 * x93 + x221 * x45 * x90,
            x102 * x206 * x93 + x102 * x211 * x45 + x103 * x206 * x45,
            x126 * x200 * x93 + x126 * x202 * x45 + x131 * x200 * x45,
            x224 * x229 * x82 + x224 * x90 * x91 + x228 * x7,
            x101 * x221 * x229 + x102 * x215 * x91 + x103 * x215 * x43,
            x126 * x206 * x91 + x126 * x211 * x43 + x131 * x206 * x43,
            x150 * x200 * x91 + x150 * x202 * x43 + x152 * x200 * x43,
            x154 * x178 * x61 + x155 * x177 * x61 + x179 * x63 * x75,
            x160 * x177 * x51 + x160 * x178 * x50 + x161 * x177 * x50,
            x154 * x182 * x51 + x154 * x183 * x50 + x155 * x182 * x50,
            x165 * x177 * x93 + x165 * x178 * x45 + x166 * x177 * x45,
            x160 * x182 * x93 + x160 * x183 * x45 + x161 * x182 * x45,
            x154 * x187 * x93 + x154 * x188 * x45 + x155 * x187 * x45,
            x171 * x177 * x91 + x171 * x178 * x43 + x176 * x229 * x80,
            x165 * x182 * x91 + x165 * x183 * x43 + x166 * x182 * x43,
            x160 * x187 * x91 + x160 * x188 * x43 + x161 * x187 * x43,
            x154 * x193 * x91 + x155 * x193 * x43 + x198 * x231 * x75,
            x233 * x236 * x77 + x233 * x63 * x84 + x235 * x236,
            x233 * x50 * x86 + x233 * x51 * x85 + x235 * x50 * x85,
            x240 * x50 * x77 + x240 * x51 + x244 * x50 * x84,
            x108 * x233 * x93 + x108 * x235 * x45 + x113 * x233 * x45,
            x239 * x45 * x86 + x239 * x85 * x93 + x244 * x45 * x85,
            x249 * x45 * x77 + x249 * x93 + x254 * x45 * x84,
            x138 * x233 * x91 + x138 * x235 * x43 + x140 * x233 * x43,
            x108 * x239 * x91 + x108 * x244 * x43 + x113 * x239 * x43,
            x231 * x254 * x83 + x248 * x43 * x86 + x248 * x85 * x91,
            x231 * x257 * x77 + x257 * x84 * x91 + x260 * x7,
            x262 * x38 * x82 + x262 * x40 + x263 * x38 * x90,
            x23 * x265 * x82 + x23 * x266 * x90 + x265 * x34,
            x102 * x23 * x263 + x102 * x261 * x34 + x103 * x23 * x261,
            x19 * x267 * x90 + x267 * x269 * x82 + x268 * x5,
            x101 * x266 * x269 + x102 * x19 * x264 + x103 * x16 * x264,
            x126 * x16 * x263 + x126 * x19 * x261 + x131 * x16 * x261,
            x10 * x271
            + x227
            * (
                x17 * (2.0 * a * x270 - 3.0 * x169 - 3.0 * x170)
                + x2
                * (
                    x171 * x31
                    + 2.0 * x174
                    + 2.0 * x175
                    + 3.0 * x218
                    + 3.0 * x219
                    + 3.0 * x220
                )
                + x226 * x75
            )
            + x271 * x82,
            x101 * x267 * x272 + x101 * x268 + x103 * x15 * x267,
            x10 * x126 * x273 + x126 * x15 * x266 + x131 * x273,
            x10 * x150 * x274 + x15 * x150 * x263 + x152 * x274,
            x177 * x200 * x40 + x177 * x202 * x38 + x178 * x200 * x38,
            x177 * x206 * x34 + x177 * x211 * x23 + x178 * x206 * x23,
            x182 * x200 * x34 + x182 * x202 * x23 + x183 * x200 * x23,
            x16 * x178 * x215 + x177 * x19 * x215 + x221 * x269 * x80,
            x16 * x182 * x211 + x16 * x183 * x206 + x182 * x19 * x206,
            x16 * x187 * x202 + x16 * x188 * x200 + x187 * x19 * x200,
            x15 * x178 * x224 + x224 * x272 * x80 + x228 * x80,
            x10 * x182 * x275 + x15 * x182 * x221 + x183 * x275,
            x10 * x187 * x276 + x15 * x187 * x211 + x188 * x276,
            x10 * x200 * x277 + x15 * x198 * x200 + x202 * x277,
            x154 * x233 * x40 + x154 * x235 * x38 + x155 * x233 * x38,
            x160 * x23 * x235 + x160 * x233 * x34 + x161 * x23 * x233,
            x154 * x23 * x244 + x154 * x239 * x34 + x155 * x23 * x239,
            x16 * x165 * x235 + x16 * x166 * x233 + x165 * x19 * x233,
            x16 * x160 * x244 + x16 * x161 * x239 + x160 * x19 * x239,
            x154 * x19 * x248 + x155 * x16 * x248 + x254 * x278 * x5,
            x10 * x233 * x279 + x15 * x176 * x233 + x235 * x279,
            x10 * x165 * x280 + x15 * x165 * x244 + x166 * x280,
            x10 * x160 * x281 + x15 * x160 * x254 + x161 * x281,
            x10 * x257 * x278 + x15 * x155 * x257 + x260 * x75,
            x283 * x38 * x77 + x283 * x40 + x284 * x38 * x84,
            x23 * x282 * x86 + x23 * x284 * x85 + x282 * x34 * x85,
            x23 * x286 * x77 + x23 * x287 * x84 + x286 * x34,
            x108 * x16 * x284 + x108 * x19 * x282 + x113 * x16 * x282,
            x16 * x285 * x86 + x19 * x285 * x85 + x287 * x288 * x83,
            x19 * x289 * x84 + x288 * x289 * x77 + x290 * x5,
            x10 * x138 * x291 + x138 * x15 * x284 + x140 * x291,
            x10 * x108 * x292 + x108 * x15 * x287 + x113 * x292,
            x10 * x230 * x289 * x83 + x15 * x289 * x86 + x290 * x83,
            x10 * x294
            + x230
            * (
                x17 * (2.0 * a * x293 - 3.0 * x191 - 3.0 * x192)
                + x2
                * (
                    x193 * x31
                    + 2.0 * x196
                    + 2.0 * x197
                    + 3.0 * x251
                    + 3.0 * x252
                    + 3.0 * x253
                )
                + x259 * x80
            )
            + x294 * x77,
        ]
    )


def kinetic3d_34(a, A, b, B):
    """Cartesian 3D (fg) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = -a
    x4 = (a + b) ** (-1.0)
    x5 = -x4 * (a * A[0] + b * B[0])
    x6 = -x5 - A[0]
    x7 = x6**2
    x8 = 2.0 * a**2
    x9 = -x3 - x8 * (x2 + x7)
    x10 = -x5 - B[0]
    x11 = a * x4
    x12 = b * x11
    x13 = numpy.exp(-x12 * (A[0] - B[0]) ** 2)
    x14 = 1.77245385090552 * numpy.sqrt(x4)
    x15 = x13 * x14
    x16 = 2.0 * x15
    x17 = x10 * x16
    x18 = x10 * x15
    x19 = 4.0 * x12
    x20 = x2 * (x17 * x9 + x18 * x19)
    x21 = 4.0 * x20
    x22 = x15 * x2
    x23 = x22 * x9
    x24 = b * x4
    x25 = x0 * x24
    x26 = x18 * x25 + x18 * x9
    x27 = x10 * x26
    x28 = x10**2 * x15
    x29 = x22 + x28
    x30 = -x16
    x31 = x11 * (x1 * x29 + x30)
    x32 = x27 + x31
    x33 = x23 + x32
    x34 = x10 * x33
    x35 = x10 * x29
    x36 = 2.0 * x22
    x37 = x10 * x36
    x38 = x35 + x37
    x39 = x11 * (x1 * x38 - 3.0 * x18)
    x40 = x2 * (x21 + 4.0 * x34 + 4.0 * x39)
    x41 = 3.0 * x23
    x42 = x2 * (3.0 * x27 + 3.0 * x31 + x41)
    x43 = x34 + x39
    x44 = x20 + x43
    x45 = 3.0 * x22
    x46 = x2 * (3.0 * x28 + x45)
    x47 = x10 * x38
    x48 = x46 + x47
    x49 = 4.0 * x22
    x50 = x10 * x44 + x11 * (2.0 * b * x48 - 4.0 * x28 - x49)
    x51 = x42 + x50
    x52 = x51 * x6
    x53 = x33 * x6
    x54 = x29 * x6
    x55 = x37 + x54
    x56 = x12 * x55
    x57 = x2 * (x21 + x43 + 3.0 * x53 + 6.0 * x56)
    x58 = x44 * x6
    x59 = x38 * x6
    x60 = x46 + x59
    x61 = x25 * x60 + x42 + x58
    x62 = x6 * x61
    x63 = 3.0 * x54
    x64 = x10 * x22
    x65 = 8.0 * x64
    x66 = x2 * (x35 + x63 + x65)
    x67 = x6 * x60
    x68 = x66 + x67
    x69 = x10 * x49
    x70 = x24 * (2.0 * a * x68 - 2.0 * x35 - x69)
    x71 = x2 * (4.0 * x35 + x65)
    x72 = x48 * x6
    x73 = x71 + x72
    x74 = 8.0 * x12
    x75 = x25 * x73 + x40 + x52
    x76 = x2 * (5.0 * x46 + x47 + 4.0 * x59) + x6 * x73
    x77 = 2.0 * x46
    x78 = (
        x2 * (5.0 * x42 + x50 + 4.0 * x58 + x60 * x74)
        + x24 * (2.0 * a * x76 - 2.0 * x47 - x77)
        + x6 * x75
    )
    x79 = x2 * (4.0 * x66 + 4.0 * x67 + 2.0 * x71 + 2.0 * x72) + x6 * x76
    x80 = numpy.exp(-x12 * (A[1] - B[1]) ** 2)
    x81 = numpy.exp(-x12 * (A[2] - B[2]) ** 2)
    x82 = 3.14159265358979 * x4 * x81
    x83 = x80 * x82
    x84 = -x4 * (a * A[1] + b * B[1])
    x85 = -x84 - A[1]
    x86 = x85**2
    x87 = -x3 - x8 * (x2 + x86)
    x88 = x79 * x83
    x89 = -x4 * (a * A[2] + b * B[2])
    x90 = -x89 - A[2]
    x91 = x90**2
    x92 = -x3 - x8 * (x2 + x91)
    x93 = -x84 - B[1]
    x94 = x14 * x80
    x95 = x93 * x94
    x96 = x25 * x95 + x87 * x95
    x97 = x17 * x6 + x45
    x98 = x2 * (x28 + x97)
    x99 = x55 * x6
    x100 = x2 * (2.0 * x59 + x77 + 3.0 * x98 + 3.0 * x99) + x6 * x68
    x101 = x14 * x81
    x102 = x26 * x6
    x103 = x15 * x6
    x104 = x10 * x103
    x105 = x104 + x22
    x106 = 2.0 * x102 + x105 * x19 + x41
    x107 = x2 * (x106 + x32)
    x108 = x20 + x25 * x55 + x53
    x109 = x108 * x6
    x110 = x98 + x99
    x111 = x24 * (2.0 * a * x110 - 2.0 * x28 - x36)
    x112 = x57 + x62 + x70
    x113 = x83 * (
        x112 * x6
        + x2 * (3.0 * x107 + 3.0 * x109 + 3.0 * x111 + x19 * x60 + 2.0 * x42 + 2.0 * x58)
        + x24 * (2.0 * a * x100 - 3.0 * x46 - 3.0 * x59)
    )
    x114 = x100 * x83
    x115 = -x89 - B[2]
    x116 = x101 * x115
    x117 = x116 * x25 + x116 * x92
    x118 = x2 * x94
    x119 = x118 * x87
    x120 = x93 * x96
    x121 = x93**2 * x94
    x122 = x118 + x121
    x123 = 2.0 * x94
    x124 = -x123
    x125 = x11 * (x1 * x122 + x124)
    x126 = x120 + x125
    x127 = x119 + x126
    x128 = x2 * (x103 + x18)
    x129 = x105 * x6
    x130 = x110 * x6 + x2 * (2.0 * x128 + 2.0 * x129 + 2.0 * x54 + x69)
    x131 = x101 * x130
    x132 = x103 * x25 + x103 * x9
    x133 = x2 * (x132 + x26)
    x134 = x102 + x105 * x25 + x23
    x135 = x134 * x6
    x136 = x128 + x129
    x137 = x0 * x136 - x17
    x138 = x1 * x4
    x139 = x107 + x109 + x111
    x140 = (
        x139 * x6
        + x2 * (2.0 * x133 + 2.0 * x135 + x137 * x138 + 2.0 * x20 + 2.0 * x53 + 4.0 * x56)
        + x24 * (2.0 * a * x130 - x63 - 6.0 * x64)
    )
    x141 = x115 * x83
    x142 = x101 * x2
    x143 = x142 * x92
    x144 = x115 * x117
    x145 = x101 * x115**2
    x146 = x142 + x145
    x147 = 2.0 * x101
    x148 = -x147
    x149 = x11 * (x1 * x146 + x148)
    x150 = x144 + x149
    x151 = x143 + x150
    x152 = x130 * x94
    x153 = x123 * x93
    x154 = x2 * (x153 * x87 + x19 * x95)
    x155 = x127 * x93
    x156 = x122 * x93
    x157 = 2.0 * x118
    x158 = x157 * x93
    x159 = x156 + x158
    x160 = x11 * (x1 * x159 - 3.0 * x95)
    x161 = x155 + x160
    x162 = x154 + x161
    x163 = x15 * x7
    x164 = x136 * x6 + x2 * (x163 + x97)
    x165 = x101 * x164
    x166 = x163 + x22
    x167 = x132 * x6 + x24 * (x0 * x166 + x30)
    x168 = x133 + x135 + x137 * x24
    x169 = x168 * x6 + x2 * (x106 + x167) + x24 * (2.0 * a * x164 - 3.0 * x104 - x45)
    x170 = x115 * x147
    x171 = x2 * (x116 * x19 + x170 * x92)
    x172 = x115 * x151
    x173 = x115 * x146
    x174 = 2.0 * x142
    x175 = x115 * x174
    x176 = x173 + x175
    x177 = x11 * (x1 * x176 - 3.0 * x116)
    x178 = x172 + x177
    x179 = x171 + x178
    x180 = x164 * x94
    x181 = x167 + x23
    x182 = x166 * x6 + x36 * x6
    x183 = x181 * x6 + x2 * (x103 * x19 + x16 * x6 * x9) + x24 * (x0 * x182 - 3.0 * x103)
    x184 = 3.0 * x118
    x185 = x2 * (3.0 * x121 + x184)
    x186 = x159 * x93
    x187 = x185 + x186
    x188 = x101 * x187
    x189 = 3.0 * x119
    x190 = x2 * (3.0 * x120 + 3.0 * x125 + x189)
    x191 = 4.0 * x118
    x192 = x11 * (2.0 * b * x187 - 4.0 * x121 - x191) + x162 * x93
    x193 = x190 + x192
    x194 = 3.0 * x142
    x195 = x2 * (3.0 * x145 + x194)
    x196 = x115 * x176
    x197 = x195 + x196
    x198 = x197 * x94
    x199 = 3.0 * x143
    x200 = x2 * (3.0 * x144 + 3.0 * x149 + x199)
    x201 = 4.0 * x142
    x202 = x11 * (2.0 * b * x197 - 4.0 * x145 - x201) + x115 * x179
    x203 = x200 + x202
    x204 = x85 * x94
    x205 = x204 * x25 + x204 * x87
    x206 = x78 * x83
    x207 = x76 * x83
    x208 = x85 * x96
    x209 = x204 * x93
    x210 = x118 + x209
    x211 = x119 + x208 + x210 * x25
    x212 = x101 * x68
    x213 = x127 * x85
    x214 = x122 * x85
    x215 = x158 + x214
    x216 = x154 + x213 + x215 * x25
    x217 = x101 * x110
    x218 = x162 * x85
    x219 = x159 * x85
    x220 = x185 + x219
    x221 = x190 + x218 + x220 * x25
    x222 = x101 * x136
    x223 = x118 * x93
    x224 = 8.0 * x223
    x225 = x2 * (4.0 * x156 + x224)
    x226 = x187 * x85
    x227 = x225 + x226
    x228 = x101 * x227
    x229 = 4.0 * x154
    x230 = x2 * (4.0 * x155 + 4.0 * x160 + x229)
    x231 = x193 * x85
    x232 = x227 * x25 + x230 + x231
    x233 = x101 * x90
    x234 = x233 * x25 + x233 * x92
    x235 = x83 * x90
    x236 = x117 * x90
    x237 = x115 * x233
    x238 = x142 + x237
    x239 = x143 + x236 + x238 * x25
    x240 = x68 * x94
    x241 = x151 * x90
    x242 = x146 * x90
    x243 = x175 + x242
    x244 = x171 + x241 + x243 * x25
    x245 = x110 * x94
    x246 = x179 * x90
    x247 = x176 * x90
    x248 = x195 + x247
    x249 = x200 + x246 + x248 * x25
    x250 = x136 * x94
    x251 = x115 * x142
    x252 = 8.0 * x251
    x253 = x2 * (4.0 * x173 + x252)
    x254 = x197 * x90
    x255 = x253 + x254
    x256 = x255 * x94
    x257 = 4.0 * x171
    x258 = x2 * (4.0 * x172 + 4.0 * x177 + x257)
    x259 = x203 * x90
    x260 = x25 * x255 + x258 + x259
    x261 = x86 * x94
    x262 = x118 + x261
    x263 = x205 * x85 + x24 * (x0 * x262 + x124)
    x264 = x119 + x263
    x265 = x101 * x73
    x266 = x2 * (x204 + x95)
    x267 = x210 * x85
    x268 = x266 + x267
    x269 = x101 * x268
    x270 = x2 * (x205 + x96)
    x271 = x211 * x85
    x272 = x0 * x268 - x153
    x273 = x24 * x272 + x270 + x271
    x274 = x153 * x85 + x184
    x275 = x2 * (x121 + x274)
    x276 = x215 * x85
    x277 = x275 + x276
    x278 = x101 * x277
    x279 = x189 + x19 * x210 + 2.0 * x208
    x280 = x2 * (x126 + x279)
    x281 = x216 * x85
    x282 = x24 * (2.0 * a * x277 - 2.0 * x121 - x157)
    x283 = x280 + x281 + x282
    x284 = 3.0 * x214
    x285 = x2 * (x156 + x224 + x284)
    x286 = x220 * x85
    x287 = x285 + x286
    x288 = x101 * x287
    x289 = 6.0 * x12
    x290 = x2 * (x161 + 3.0 * x213 + x215 * x289 + x229)
    x291 = x221 * x85
    x292 = x191 * x93
    x293 = x24 * (2.0 * a * x287 - 2.0 * x156 - x292)
    x294 = x290 + x291 + x293
    x295 = x2 * (5.0 * x185 + x186 + 4.0 * x219) + x227 * x85
    x296 = 2.0 * x185
    x297 = (
        x2 * (5.0 * x190 + x192 + 4.0 * x218 + x220 * x74)
        + x232 * x85
        + x24 * (2.0 * a * x295 - 2.0 * x186 - x296)
    )
    x298 = x13 * x82
    x299 = x297 * x298
    x300 = x298 * x6
    x301 = 3.14159265358979 * x13 * x4 * x80
    x302 = x301 * x6
    x303 = x101 * x91
    x304 = x142 + x303
    x305 = x234 * x90 + x24 * (x0 * x304 + x148)
    x306 = x143 + x305
    x307 = x73 * x94
    x308 = x2 * (x116 + x233)
    x309 = x238 * x90
    x310 = x308 + x309
    x311 = x310 * x94
    x312 = x2 * (x117 + x234)
    x313 = x239 * x90
    x314 = x0 * x310 - x170
    x315 = x24 * x314 + x312 + x313
    x316 = x170 * x90 + x194
    x317 = x2 * (x145 + x316)
    x318 = x243 * x90
    x319 = x317 + x318
    x320 = x319 * x94
    x321 = x19 * x238 + x199 + 2.0 * x236
    x322 = x2 * (x150 + x321)
    x323 = x244 * x90
    x324 = x24 * (2.0 * a * x319 - 2.0 * x145 - x174)
    x325 = x322 + x323 + x324
    x326 = 3.0 * x242
    x327 = x2 * (x173 + x252 + x326)
    x328 = x248 * x90
    x329 = x327 + x328
    x330 = x329 * x94
    x331 = x2 * (x178 + 3.0 * x241 + x243 * x289 + x257)
    x332 = x249 * x90
    x333 = x115 * x201
    x334 = x24 * (2.0 * a * x329 - 2.0 * x173 - x333)
    x335 = x331 + x332 + x334
    x336 = x2 * (5.0 * x195 + x196 + 4.0 * x247) + x255 * x90
    x337 = 2.0 * x195
    x338 = (
        x2 * (5.0 * x200 + x202 + 4.0 * x246 + x248 * x74)
        + x24 * (2.0 * a * x336 - 2.0 * x196 - x337)
        + x260 * x90
    )
    x339 = x301 * x338
    x340 = x157 * x85 + x262 * x85
    x341 = (
        x2 * (x123 * x85 * x87 + x19 * x204) + x24 * (x0 * x340 - 3.0 * x204) + x264 * x85
    )
    x342 = x101 * x48
    x343 = x2 * (x261 + x274) + x268 * x85
    x344 = x101 * x343
    x345 = x2 * (x263 + x279) + x24 * (2.0 * a * x343 - x184 - 3.0 * x209) + x273 * x85
    x346 = x2 * (2.0 * x214 + 2.0 * x266 + 2.0 * x267 + x292) + x277 * x85
    x347 = x101 * x346
    x348 = (
        x2
        * (x138 * x272 + 2.0 * x154 + x19 * x215 + 2.0 * x213 + 2.0 * x270 + 2.0 * x271)
        + x24 * (2.0 * a * x346 - 6.0 * x223 - x284)
        + x283 * x85
    )
    x349 = x2 * (2.0 * x219 + 3.0 * x275 + 3.0 * x276 + x296) + x287 * x85
    x350 = x298 * (
        x2 * (x19 * x220 + 2.0 * x190 + 2.0 * x218 + 3.0 * x280 + 3.0 * x281 + 3.0 * x282)
        + x24 * (2.0 * a * x349 - 3.0 * x185 - 3.0 * x219)
        + x294 * x85
    )
    x351 = x10 * x298
    x352 = x2 * (2.0 * x225 + 2.0 * x226 + 4.0 * x285 + 4.0 * x286) + x295 * x85
    x353 = x298 * x352
    x354 = x298 * x9
    x355 = x15 * x346
    x356 = x15 * x343
    x357 = x15 * x197
    x358 = x15 * x287
    x359 = x15 * x277
    x360 = x15 * x268
    x361 = x15 * x255
    x362 = x301 * x85
    x363 = x15 * x227
    x364 = x15 * x310
    x365 = x15 * x319
    x366 = x15 * x329
    x367 = x174 * x90 + x304 * x90
    x368 = (
        x2 * (x147 * x90 * x92 + x19 * x233) + x24 * (x0 * x367 - 3.0 * x233) + x306 * x90
    )
    x369 = x48 * x94
    x370 = x2 * (x303 + x316) + x310 * x90
    x371 = x370 * x94
    x372 = x2 * (x305 + x321) + x24 * (2.0 * a * x370 - x194 - 3.0 * x237) + x315 * x90
    x373 = x2 * (2.0 * x242 + 2.0 * x308 + 2.0 * x309 + x333) + x319 * x90
    x374 = x373 * x94
    x375 = (
        x2
        * (x138 * x314 + 2.0 * x171 + x19 * x243 + 2.0 * x241 + 2.0 * x312 + 2.0 * x313)
        + x24 * (2.0 * a * x373 - 6.0 * x251 - x326)
        + x325 * x90
    )
    x376 = x10 * x301
    x377 = x2 * (2.0 * x247 + 3.0 * x317 + 3.0 * x318 + x337) + x329 * x90
    x378 = x301 * (
        x2 * (x19 * x248 + 2.0 * x200 + 2.0 * x246 + 3.0 * x322 + 3.0 * x323 + 3.0 * x324)
        + x24 * (2.0 * a * x377 - 3.0 * x195 - 3.0 * x247)
        + x335 * x90
    )
    x379 = x15 * x187
    x380 = x15 * x370
    x381 = x15 * x373
    x382 = x2 * (2.0 * x253 + 2.0 * x254 + 4.0 * x327 + 4.0 * x328) + x336 * x90
    x383 = x301 * x382

    # 150 item(s)
    return numpy.array(
        [
            x83
            * (
                x2
                * (x19 * x73 + 2.0 * x40 + 2.0 * x52 + 4.0 * x57 + 4.0 * x62 + 4.0 * x70)
                + x24 * (2.0 * a * x79 - 3.0 * x71 - 3.0 * x72)
                + x6 * x78
            )
            + x87 * x88
            + x88 * x92,
            x100 * x101 * x96 + x113 * x93 + x114 * x92 * x93,
            x100 * x117 * x94 + x113 * x115 + x114 * x115 * x87,
            x101 * x122 * x140 + x122 * x131 * x92 + x127 * x131,
            x116 * x130 * x96 + x117 * x130 * x95 + x140 * x141 * x93,
            x140 * x146 * x94 + x146 * x152 * x87 + x151 * x152,
            x101 * x159 * x169 + x159 * x165 * x92 + x162 * x165,
            x116 * x122 * x169 + x116 * x127 * x164 + x117 * x122 * x164,
            x146 * x164 * x96 + x146 * x169 * x95 + x151 * x164 * x95,
            x169 * x176 * x94 + x176 * x180 * x87 + x179 * x180,
            x101 * x182 * x193 + x182 * x188 * x92 + x183 * x188,
            x116 * x159 * x183 + x116 * x162 * x182 + x117 * x159 * x182,
            x122 * x146 * x183 + x122 * x151 * x182 + x127 * x146 * x182,
            x176 * x182 * x96 + x176 * x183 * x95 + x179 * x182 * x95,
            x182 * x198 * x87 + x182 * x203 * x94 + x183 * x198,
            x101 * x205 * x76 + x206 * x85 + x207 * x85 * x92,
            x101 * x112 * x210 + x210 * x212 * x92 + x211 * x212,
            x112 * x141 * x85 + x116 * x205 * x68 + x117 * x204 * x68,
            x101 * x139 * x215 + x215 * x217 * x92 + x216 * x217,
            x110 * x116 * x211 + x110 * x117 * x210 + x116 * x139 * x210,
            x110 * x146 * x205 + x110 * x151 * x204 + x139 * x146 * x204,
            x101 * x168 * x220 + x220 * x222 * x92 + x221 * x222,
            x116 * x136 * x216 + x116 * x168 * x215 + x117 * x136 * x215,
            x136 * x146 * x211 + x136 * x151 * x210 + x146 * x168 * x210,
            x136 * x176 * x205 + x136 * x179 * x204 + x168 * x176 * x204,
            x101 * x166 * x232 + x166 * x228 * x92 + x181 * x228,
            x116 * x166 * x221 + x116 * x181 * x220 + x117 * x166 * x220,
            x146 * x166 * x216 + x146 * x181 * x215 + x151 * x166 * x215,
            x166 * x176 * x211 + x166 * x179 * x210 + x176 * x181 * x210,
            x166 * x197 * x205 + x166 * x203 * x204 + x181 * x197 * x204,
            x206 * x90 + x207 * x87 * x90 + x234 * x76 * x94,
            x112 * x235 * x93 + x233 * x68 * x96 + x234 * x68 * x95,
            x112 * x238 * x94 + x238 * x240 * x87 + x239 * x240,
            x110 * x122 * x234 + x110 * x127 * x233 + x122 * x139 * x233,
            x110 * x238 * x96 + x110 * x239 * x95 + x139 * x238 * x95,
            x139 * x243 * x94 + x243 * x245 * x87 + x244 * x245,
            x136 * x159 * x234 + x136 * x162 * x233 + x159 * x168 * x233,
            x122 * x136 * x239 + x122 * x168 * x238 + x127 * x136 * x238,
            x136 * x243 * x96 + x136 * x244 * x95 + x168 * x243 * x95,
            x168 * x248 * x94 + x248 * x250 * x87 + x249 * x250,
            x166 * x187 * x234 + x166 * x193 * x233 + x181 * x187 * x233,
            x159 * x166 * x239 + x159 * x181 * x238 + x162 * x166 * x238,
            x122 * x166 * x244 + x122 * x181 * x243 + x127 * x166 * x243,
            x166 * x248 * x96 + x166 * x249 * x95 + x181 * x248 * x95,
            x166 * x256 * x87 + x166 * x260 * x94 + x181 * x256,
            x101 * x262 * x75 + x262 * x265 * x92 + x264 * x265,
            x101 * x273 * x60 + x269 * x60 * x92 + x269 * x61,
            x116 * x262 * x61 + x116 * x264 * x60 + x117 * x262 * x60,
            x101 * x283 * x55 + x108 * x278 + x278 * x55 * x92,
            x108 * x116 * x268 + x116 * x273 * x55 + x117 * x268 * x55,
            x108 * x146 * x262 + x146 * x264 * x55 + x151 * x262 * x55,
            x101 * x105 * x294 + x105 * x288 * x92 + x134 * x288,
            x105 * x116 * x283 + x105 * x117 * x277 + x116 * x134 * x277,
            x105 * x146 * x273 + x105 * x151 * x268 + x134 * x146 * x268,
            x105 * x176 * x264 + x105 * x179 * x262 + x134 * x176 * x262,
            x101 * x132 * x295 + x295 * x300 * x92 + x299 * x6,
            x103 * x117 * x287 + x115 * x294 * x300 + x116 * x132 * x287,
            x103 * x146 * x283 + x103 * x151 * x277 + x132 * x146 * x277,
            x103 * x176 * x273 + x103 * x179 * x268 + x132 * x176 * x268,
            x103 * x197 * x264 + x103 * x203 * x262 + x132 * x197 * x262,
            x204 * x234 * x73 + x205 * x233 * x73 + x235 * x75 * x85,
            x210 * x233 * x61 + x210 * x234 * x60 + x211 * x233 * x60,
            x204 * x238 * x61 + x204 * x239 * x60 + x205 * x238 * x60,
            x108 * x215 * x233 + x215 * x234 * x55 + x216 * x233 * x55,
            x108 * x210 * x238 + x210 * x239 * x55 + x211 * x238 * x55,
            x108 * x204 * x243 + x204 * x244 * x55 + x205 * x243 * x55,
            x105 * x220 * x234 + x105 * x221 * x233 + x134 * x220 * x233,
            x105 * x215 * x239 + x105 * x216 * x238 + x134 * x215 * x238,
            x105 * x210 * x244 + x105 * x211 * x243 + x134 * x210 * x243,
            x105 * x204 * x249 + x105 * x205 * x248 + x134 * x204 * x248,
            x103 * x227 * x234 + x132 * x227 * x233 + x232 * x300 * x90,
            x103 * x220 * x239 + x103 * x221 * x238 + x132 * x220 * x238,
            x103 * x215 * x244 + x103 * x216 * x243 + x132 * x215 * x243,
            x103 * x210 * x249 + x103 * x211 * x248 + x132 * x210 * x248,
            x103 * x205 * x255 + x132 * x204 * x255 + x260 * x302 * x85,
            x304 * x307 * x87 + x304 * x75 * x94 + x306 * x307,
            x304 * x60 * x96 + x304 * x61 * x95 + x306 * x60 * x95,
            x311 * x60 * x87 + x311 * x61 + x315 * x60 * x94,
            x108 * x122 * x304 + x122 * x306 * x55 + x127 * x304 * x55,
            x108 * x310 * x95 + x310 * x55 * x96 + x315 * x55 * x95,
            x108 * x320 + x320 * x55 * x87 + x325 * x55 * x94,
            x105 * x159 * x306 + x105 * x162 * x304 + x134 * x159 * x304,
            x105 * x122 * x315 + x105 * x127 * x310 + x122 * x134 * x310,
            x105 * x319 * x96 + x105 * x325 * x95 + x134 * x319 * x95,
            x105 * x330 * x87 + x105 * x335 * x94 + x134 * x330,
            x103 * x187 * x306 + x103 * x193 * x304 + x132 * x187 * x304,
            x103 * x159 * x315 + x103 * x162 * x310 + x132 * x159 * x310,
            x103 * x122 * x325 + x103 * x127 * x319 + x122 * x132 * x319,
            x103 * x329 * x96 + x132 * x329 * x95 + x302 * x335 * x93,
            x132 * x336 * x94 + x302 * x336 * x87 + x339 * x6,
            x101 * x340 * x51 + x340 * x342 * x92 + x341 * x342,
            x101 * x345 * x38 + x344 * x38 * x92 + x344 * x44,
            x116 * x340 * x44 + x116 * x341 * x38 + x117 * x340 * x38,
            x101 * x29 * x348 + x29 * x347 * x92 + x33 * x347,
            x116 * x29 * x345 + x116 * x33 * x343 + x117 * x29 * x343,
            x146 * x29 * x341 + x146 * x33 * x340 + x151 * x29 * x340,
            x10 * x350 + x101 * x26 * x349 + x349 * x351 * x92,
            x115 * x348 * x351 + x116 * x26 * x346 + x117 * x18 * x346,
            x146 * x18 * x345 + x146 * x26 * x343 + x151 * x18 * x343,
            x176 * x18 * x341 + x176 * x26 * x340 + x179 * x18 * x340,
            x298
            * (
                x2
                * (
                    x19 * x227
                    + 2.0 * x230
                    + 2.0 * x231
                    + 4.0 * x290
                    + 4.0 * x291
                    + 4.0 * x293
                )
                + x24 * (2.0 * a * x352 - 3.0 * x225 - 3.0 * x226)
                + x297 * x85
            )
            + x353 * x9
            + x353 * x92,
            x115 * x349 * x354 + x115 * x350 + x117 * x15 * x349,
            x146 * x15 * x348 + x146 * x355 * x9 + x151 * x355,
            x15 * x176 * x345 + x176 * x356 * x9 + x179 * x356,
            x15 * x203 * x340 + x340 * x357 * x9 + x341 * x357,
            x233 * x262 * x51 + x233 * x264 * x48 + x234 * x262 * x48,
            x233 * x268 * x44 + x233 * x273 * x38 + x234 * x268 * x38,
            x238 * x262 * x44 + x238 * x264 * x38 + x239 * x262 * x38,
            x233 * x277 * x33 + x233 * x283 * x29 + x234 * x277 * x29,
            x238 * x268 * x33 + x238 * x273 * x29 + x239 * x268 * x29,
            x243 * x262 * x33 + x243 * x264 * x29 + x244 * x262 * x29,
            x18 * x234 * x287 + x233 * x26 * x287 + x294 * x351 * x90,
            x18 * x238 * x283 + x18 * x239 * x277 + x238 * x26 * x277,
            x18 * x243 * x273 + x18 * x244 * x268 + x243 * x26 * x268,
            x18 * x248 * x264 + x18 * x249 * x262 + x248 * x26 * x262,
            x15 * x234 * x295 + x295 * x354 * x90 + x299 * x90,
            x15 * x238 * x294 + x238 * x358 * x9 + x239 * x358,
            x15 * x243 * x283 + x243 * x359 * x9 + x244 * x359,
            x15 * x248 * x273 + x248 * x360 * x9 + x249 * x360,
            x15 * x260 * x262 + x262 * x361 * x9 + x264 * x361,
            x204 * x304 * x51 + x204 * x306 * x48 + x205 * x304 * x48,
            x210 * x304 * x44 + x210 * x306 * x38 + x211 * x304 * x38,
            x204 * x310 * x44 + x204 * x315 * x38 + x205 * x310 * x38,
            x215 * x29 * x306 + x215 * x304 * x33 + x216 * x29 * x304,
            x210 * x29 * x315 + x210 * x310 * x33 + x211 * x29 * x310,
            x204 * x29 * x325 + x204 * x319 * x33 + x205 * x29 * x319,
            x18 * x220 * x306 + x18 * x221 * x304 + x220 * x26 * x304,
            x18 * x215 * x315 + x18 * x216 * x310 + x215 * x26 * x310,
            x18 * x210 * x325 + x18 * x211 * x319 + x210 * x26 * x319,
            x10 * x335 * x362 + x18 * x205 * x329 + x204 * x26 * x329,
            x15 * x232 * x304 + x304 * x363 * x9 + x306 * x363,
            x15 * x220 * x315 + x220 * x364 * x9 + x221 * x364,
            x15 * x215 * x325 + x215 * x365 * x9 + x216 * x365,
            x15 * x210 * x335 + x210 * x366 * x9 + x211 * x366,
            x15 * x205 * x336 + x336 * x362 * x9 + x339 * x85,
            x367 * x369 * x87 + x367 * x51 * x94 + x368 * x369,
            x367 * x38 * x96 + x367 * x44 * x95 + x368 * x38 * x95,
            x371 * x38 * x87 + x371 * x44 + x372 * x38 * x94,
            x122 * x29 * x368 + x122 * x33 * x367 + x127 * x29 * x367,
            x29 * x370 * x96 + x29 * x372 * x95 + x33 * x370 * x95,
            x29 * x374 * x87 + x29 * x375 * x94 + x33 * x374,
            x159 * x18 * x368 + x159 * x26 * x367 + x162 * x18 * x367,
            x122 * x18 * x372 + x122 * x26 * x370 + x127 * x18 * x370,
            x18 * x373 * x96 + x26 * x373 * x95 + x375 * x376 * x93,
            x10 * x378 + x26 * x377 * x94 + x376 * x377 * x87,
            x15 * x193 * x367 + x367 * x379 * x9 + x368 * x379,
            x15 * x159 * x372 + x159 * x380 * x9 + x162 * x380,
            x122 * x15 * x375 + x122 * x381 * x9 + x127 * x381,
            x15 * x377 * x96 + x301 * x377 * x9 * x93 + x378 * x93,
            x301
            * (
                x2
                * (
                    x19 * x255
                    + 2.0 * x258
                    + 2.0 * x259
                    + 4.0 * x331
                    + 4.0 * x332
                    + 4.0 * x334
                )
                + x24 * (2.0 * a * x382 - 3.0 * x253 - 3.0 * x254)
                + x338 * x90
            )
            + x383 * x87
            + x383 * x9,
        ]
    )


def kinetic3d_40(a, A, b, B):
    """Cartesian 3D (gs) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = (2.0 * b + x0) ** (-1.0)
    x2 = (a + b) ** (-1.0)
    x3 = x2 * (a * A[0] + b * B[0]) - A[0]
    x4 = -a
    x5 = x3**2
    x6 = 2.0 * a**2
    x7 = -x4 - x6 * (x1 + x5)
    x8 = b * x2
    x9 = a * x8
    x10 = numpy.exp(-x9 * (A[0] - B[0]) ** 2)
    x11 = 1.77245385090552 * numpy.sqrt(x2)
    x12 = x10 * x11
    x13 = x12 * x3
    x14 = x0 * x8
    x15 = x13 * x14 + x13 * x7
    x16 = x15 * x3
    x17 = x12 * x5
    x18 = x1 * x12
    x19 = x17 + x18
    x20 = 2.0 * x12
    x21 = x8 * (x0 * x19 - x20)
    x22 = x18 * x7
    x23 = 4.0 * x9
    x24 = x16 + x21 + x22
    x25 = 2.0 * x18 * x3 + x19 * x3
    x26 = x1 * (x13 * x23 + x20 * x3 * x7) + x24 * x3 + x8 * (x0 * x25 - 3.0 * x13)
    x27 = x1 * (3.0 * x17 + 3.0 * x18) + x25 * x3
    x28 = numpy.exp(-x9 * (A[1] - B[1]) ** 2)
    x29 = numpy.exp(-x9 * (A[2] - B[2]) ** 2)
    x30 = 3.14159265358979 * x2 * x29
    x31 = x28 * x30
    x32 = x2 * (a * A[1] + b * B[1]) - A[1]
    x33 = x32**2
    x34 = -x4 - x6 * (x1 + x33)
    x35 = x27 * x31
    x36 = x2 * (a * A[2] + b * B[2]) - A[2]
    x37 = x36**2
    x38 = -x4 - x6 * (x1 + x37)
    x39 = x11 * x28
    x40 = x32 * x39
    x41 = x14 * x40 + x34 * x40
    x42 = x11 * x29
    x43 = x41 * x42
    x44 = x26 * x31
    x45 = x25 * x31
    x46 = x36 * x42
    x47 = x14 * x46 + x38 * x46
    x48 = x32 * x41
    x49 = x33 * x39
    x50 = x1 * x39
    x51 = x49 + x50
    x52 = 2.0 * x39
    x53 = x8 * (x0 * x51 - x52)
    x54 = x34 * x50
    x55 = x48 + x53 + x54
    x56 = x19 * x42
    x57 = x36 * x47
    x58 = x37 * x42
    x59 = x1 * x42
    x60 = x58 + x59
    x61 = 2.0 * x42
    x62 = x8 * (x0 * x60 - x61)
    x63 = x38 * x59
    x64 = x57 + x62 + x63
    x65 = x19 * x39
    x66 = 2.0 * x32 * x50 + x32 * x51
    x67 = x1 * (x23 * x40 + x32 * x34 * x52) + x32 * x55 + x8 * (x0 * x66 - 3.0 * x40)
    x68 = x10 * x30
    x69 = x67 * x68
    x70 = x3 * x68
    x71 = 3.14159265358979 * x10 * x2 * x28
    x72 = x3 * x71
    x73 = 2.0 * x36 * x59 + x36 * x60
    x74 = x1 * (x23 * x46 + x36 * x38 * x61) + x36 * x64 + x8 * (x0 * x73 - 3.0 * x46)
    x75 = x71 * x74
    x76 = x1 * (3.0 * x49 + 3.0 * x50) + x32 * x66
    x77 = x68 * x76
    x78 = x12 * x51
    x79 = x1 * (3.0 * x58 + 3.0 * x59) + x36 * x73
    x80 = x71 * x79

    # 15 item(s)
    return numpy.array(
        [
            x31
            * (
                x1 * (3.0 * x16 + 3.0 * x21 + 3.0 * x22)
                + x26 * x3
                + x8 * (2.0 * a * x27 - 4.0 * x17 - 4.0 * x18)
            )
            + x34 * x35
            + x35 * x38,
            x25 * x43 + x32 * x38 * x45 + x32 * x44,
            x25 * x39 * x47 + x34 * x36 * x45 + x36 * x44,
            x24 * x42 * x51 + x38 * x51 * x56 + x55 * x56,
            x19 * x36 * x43 + x19 * x40 * x47 + x24 * x31 * x32 * x36,
            x24 * x39 * x60 + x34 * x60 * x65 + x64 * x65,
            x15 * x42 * x66 + x3 * x69 + x38 * x66 * x70,
            x13 * x47 * x51 + x15 * x46 * x51 + x36 * x55 * x70,
            x13 * x41 * x60 + x15 * x40 * x60 + x32 * x64 * x72,
            x15 * x39 * x73 + x3 * x75 + x34 * x72 * x73,
            x38 * x77
            + x68
            * (
                x1 * (3.0 * x48 + 3.0 * x53 + 3.0 * x54)
                + x32 * x67
                + x8 * (2.0 * a * x76 - 4.0 * x49 - 4.0 * x50)
            )
            + x7 * x77,
            x12 * x47 * x66 + x36 * x66 * x68 * x7 + x36 * x69,
            x12 * x55 * x60 + x60 * x7 * x78 + x64 * x78,
            x12 * x41 * x73 + x32 * x7 * x71 * x73 + x32 * x75,
            x34 * x80
            + x7 * x80
            + x71
            * (
                x1 * (3.0 * x57 + 3.0 * x62 + 3.0 * x63)
                + x36 * x74
                + x8 * (2.0 * a * x79 - 4.0 * x58 - 4.0 * x59)
            ),
        ]
    )


def kinetic3d_41(a, A, b, B):
    """Cartesian 3D (gp) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = (2.0 * b + x0) ** (-1.0)
    x2 = -a
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = x5**2
    x7 = 2.0 * a**2
    x8 = -x2 - x7 * (x1 + x6)
    x9 = b * x3
    x10 = a * x9
    x11 = numpy.exp(-x10 * (A[0] - B[0]) ** 2)
    x12 = 1.77245385090552 * numpy.sqrt(x3)
    x13 = x11 * x12
    x14 = x13 * x5
    x15 = x0 * x9
    x16 = x14 * x15 + x14 * x8
    x17 = -x4 - B[0]
    x18 = x13 * x17
    x19 = x15 * x18 + x18 * x8
    x20 = x1 * (x16 + x19)
    x21 = x19 * x5
    x22 = x1 * x13
    x23 = x14 * x17
    x24 = x22 + x23
    x25 = x22 * x8
    x26 = x15 * x24 + x21 + x25
    x27 = x26 * x5
    x28 = x1 * (x14 + x18)
    x29 = x24 * x5
    x30 = x28 + x29
    x31 = 2.0 * x13
    x32 = x17 * x31
    x33 = x9 * (x0 * x30 - x32)
    x34 = 4.0 * x10
    x35 = x16 * x5
    x36 = x13 * x6
    x37 = x22 + x36
    x38 = x9 * (x0 * x37 - x31)
    x39 = x35 + x38
    x40 = x25 + x39
    x41 = 2.0 * x22 * x5 + x37 * x5
    x42 = x1 * (x14 * x34 + x31 * x5 * x8) + x40 * x5 + x9 * (x0 * x41 - 3.0 * x14)
    x43 = 3.0 * x25
    x44 = x20 + x27 + x33
    x45 = 3.0 * x22
    x46 = x1 * (x32 * x5 + x36 + x45) + x30 * x5
    x47 = (
        x1 * (2.0 * x21 + x24 * x34 + x39 + x43)
        + x44 * x5
        + x9 * (2.0 * a * x46 - 3.0 * x23 - x45)
    )
    x48 = x1 * (3.0 * x28 + 3.0 * x29 + x41) + x46 * x5
    x49 = numpy.exp(-x10 * (A[1] - B[1]) ** 2)
    x50 = numpy.exp(-x10 * (A[2] - B[2]) ** 2)
    x51 = 3.14159265358979 * x3 * x50
    x52 = x49 * x51
    x53 = -x3 * (a * A[1] + b * B[1])
    x54 = -x53 - A[1]
    x55 = x54**2
    x56 = -x2 - x7 * (x1 + x55)
    x57 = x48 * x52
    x58 = -x3 * (a * A[2] + b * B[2])
    x59 = -x58 - A[2]
    x60 = x59**2
    x61 = -x2 - x7 * (x1 + x60)
    x62 = -x53 - B[1]
    x63 = x12 * x49
    x64 = x62 * x63
    x65 = x15 * x64 + x56 * x64
    x66 = x1 * (3.0 * x36 + x45) + x41 * x5
    x67 = x12 * x50
    x68 = x52 * (
        x1 * (3.0 * x35 + 3.0 * x38 + x43)
        + x42 * x5
        + x9 * (2.0 * a * x66 - 4.0 * x22 - 4.0 * x36)
    )
    x69 = x52 * x66
    x70 = -x58 - B[2]
    x71 = x67 * x70
    x72 = x15 * x71 + x61 * x71
    x73 = x54 * x63
    x74 = x15 * x73 + x56 * x73
    x75 = x47 * x52
    x76 = x52 * x54
    x77 = x54 * x65
    x78 = x1 * x12
    x79 = x49 * x78
    x80 = x62 * x73
    x81 = x79 + x80
    x82 = x56 * x79
    x83 = x15 * x81 + x77 + x82
    x84 = x41 * x67
    x85 = x59 * x67
    x86 = x15 * x85 + x61 * x85
    x87 = x52 * x59
    x88 = x59 * x72
    x89 = x50 * x78
    x90 = x70 * x85
    x91 = x89 + x90
    x92 = x61 * x89
    x93 = x15 * x91 + x88 + x92
    x94 = x41 * x63
    x95 = x54 * x74
    x96 = x55 * x63
    x97 = x79 + x96
    x98 = 2.0 * x63
    x99 = x9 * (x0 * x97 - x98)
    x100 = x95 + x99
    x101 = x100 + x82
    x102 = x30 * x67
    x103 = x1 * (x64 + x73)
    x104 = x54 * x81
    x105 = x103 + x104
    x106 = x105 * x67
    x107 = x1 * (x65 + x74)
    x108 = x54 * x83
    x109 = x62 * x98
    x110 = x9 * (x0 * x105 - x109)
    x111 = x107 + x108 + x110
    x112 = x59 * x86
    x113 = x60 * x67
    x114 = x113 + x89
    x115 = 2.0 * x67
    x116 = x9 * (x0 * x114 - x115)
    x117 = x112 + x116
    x118 = x117 + x92
    x119 = x30 * x63
    x120 = x1 * (x71 + x85)
    x121 = x59 * x91
    x122 = x120 + x121
    x123 = x122 * x63
    x124 = x1 * (x72 + x86)
    x125 = x59 * x93
    x126 = x115 * x70
    x127 = x9 * (x0 * x122 - x126)
    x128 = x124 + x125 + x127
    x129 = 2.0 * x54 * x79 + x54 * x97
    x130 = x129 * x67
    x131 = x1 * (x34 * x73 + x54 * x56 * x98) + x101 * x54 + x9 * (x0 * x129 - 3.0 * x73)
    x132 = 3.0 * x79
    x133 = x1 * (x109 * x54 + x132 + x96) + x105 * x54
    x134 = 3.0 * x82
    x135 = (
        x1 * (x100 + x134 + x34 * x81 + 2.0 * x77)
        + x111 * x54
        + x9 * (2.0 * a * x133 - x132 - 3.0 * x80)
    )
    x136 = x11 * x51
    x137 = x135 * x136
    x138 = x136 * x5
    x139 = 3.14159265358979 * x11 * x3 * x49
    x140 = x139 * x5
    x141 = x114 * x59 + 2.0 * x59 * x89
    x142 = x141 * x63
    x143 = x1 * (x115 * x59 * x61 + x34 * x85) + x118 * x59 + x9 * (x0 * x141 - 3.0 * x85)
    x144 = 3.0 * x89
    x145 = x1 * (x113 + x126 * x59 + x144) + x122 * x59
    x146 = 3.0 * x92
    x147 = (
        x1 * (x117 + x146 + x34 * x91 + 2.0 * x88)
        + x128 * x59
        + x9 * (2.0 * a * x145 - x144 - 3.0 * x90)
    )
    x148 = x139 * x147
    x149 = x1 * (x132 + 3.0 * x96) + x129 * x54
    x150 = x136 * (
        x1 * (x134 + 3.0 * x95 + 3.0 * x99)
        + x131 * x54
        + x9 * (2.0 * a * x149 - 4.0 * x79 - 4.0 * x96)
    )
    x151 = x136 * x149
    x152 = x1 * (3.0 * x103 + 3.0 * x104 + x129) + x133 * x54
    x153 = x136 * x152
    x154 = x136 * x59
    x155 = x129 * x13
    x156 = x105 * x13
    x157 = x122 * x13
    x158 = x139 * x54
    x159 = x13 * x141
    x160 = x1 * (3.0 * x113 + x144) + x141 * x59
    x161 = x139 * (
        x1 * (3.0 * x112 + 3.0 * x116 + x146)
        + x143 * x59
        + x9 * (2.0 * a * x160 - 4.0 * x113 - 4.0 * x89)
    )
    x162 = x139 * x160
    x163 = x1 * (3.0 * x120 + 3.0 * x121 + x141) + x145 * x59
    x164 = x139 * x163

    # 45 item(s)
    return numpy.array(
        [
            x52
            * (
                x1 * (3.0 * x20 + 3.0 * x27 + 3.0 * x33 + x42)
                + x47 * x5
                + x9 * (2.0 * a * x48 - 4.0 * x28 - 4.0 * x29)
            )
            + x56 * x57
            + x57 * x61,
            x61 * x62 * x69 + x62 * x68 + x65 * x66 * x67,
            x56 * x69 * x70 + x63 * x66 * x72 + x68 * x70,
            x46 * x61 * x76 + x46 * x67 * x74 + x54 * x75,
            x42 * x67 * x81 + x61 * x81 * x84 + x83 * x84,
            x41 * x71 * x74 + x41 * x72 * x73 + x42 * x70 * x76,
            x46 * x56 * x87 + x46 * x63 * x86 + x59 * x75,
            x41 * x64 * x86 + x41 * x65 * x85 + x42 * x62 * x87,
            x42 * x63 * x91 + x56 * x91 * x94 + x93 * x94,
            x101 * x102 + x102 * x61 * x97 + x44 * x67 * x97,
            x106 * x37 * x61 + x106 * x40 + x111 * x37 * x67,
            x101 * x37 * x71 + x37 * x72 * x97 + x40 * x71 * x97,
            x30 * x73 * x86 + x30 * x74 * x85 + x44 * x59 * x76,
            x37 * x81 * x86 + x37 * x83 * x85 + x40 * x81 * x85,
            x37 * x73 * x93 + x37 * x74 * x91 + x40 * x73 * x91,
            x114 * x119 * x56 + x114 * x44 * x63 + x118 * x119,
            x114 * x37 * x65 + x114 * x40 * x64 + x118 * x37 * x64,
            x123 * x37 * x56 + x123 * x40 + x128 * x37 * x63,
            x130 * x24 * x61 + x130 * x26 + x131 * x24 * x67,
            x133 * x138 * x61 + x133 * x16 * x67 + x137 * x5,
            x129 * x14 * x72 + x129 * x16 * x71 + x131 * x138 * x70,
            x101 * x24 * x85 + x24 * x86 * x97 + x26 * x85 * x97,
            x105 * x14 * x86 + x105 * x16 * x85 + x111 * x138 * x59,
            x101 * x14 * x91 + x14 * x93 * x97 + x16 * x91 * x97,
            x114 * x24 * x74 + x114 * x26 * x73 + x118 * x24 * x73,
            x114 * x14 * x83 + x114 * x16 * x81 + x118 * x14 * x81,
            x122 * x14 * x74 + x122 * x16 * x73 + x128 * x140 * x54,
            x142 * x24 * x56 + x142 * x26 + x143 * x24 * x63,
            x14 * x141 * x65 + x140 * x143 * x62 + x141 * x16 * x64,
            x140 * x145 * x56 + x145 * x16 * x63 + x148 * x5,
            x149 * x19 * x67 + x150 * x17 + x151 * x17 * x61,
            x136
            * (
                x1 * (3.0 * x107 + 3.0 * x108 + 3.0 * x110 + x131)
                + x135 * x54
                + x9 * (2.0 * a * x152 - 4.0 * x103 - 4.0 * x104)
            )
            + x153 * x61
            + x153 * x8,
            x13 * x149 * x72 + x150 * x70 + x151 * x70 * x8,
            x129 * x18 * x86 + x129 * x19 * x85 + x131 * x154 * x17,
            x13 * x133 * x86 + x133 * x154 * x8 + x137 * x59,
            x13 * x131 * x91 + x155 * x8 * x91 + x155 * x93,
            x101 * x114 * x18 + x114 * x19 * x97 + x118 * x18 * x97,
            x111 * x114 * x13 + x114 * x156 * x8 + x118 * x156,
            x101 * x157 + x128 * x13 * x97 + x157 * x8 * x97,
            x141 * x18 * x74 + x141 * x19 * x73 + x143 * x158 * x17,
            x13 * x143 * x81 + x159 * x8 * x81 + x159 * x83,
            x13 * x145 * x74 + x145 * x158 * x8 + x148 * x54,
            x160 * x19 * x63 + x161 * x17 + x162 * x17 * x56,
            x13 * x160 * x65 + x161 * x62 + x162 * x62 * x8,
            x139
            * (
                x1 * (3.0 * x124 + 3.0 * x125 + 3.0 * x127 + x143)
                + x147 * x59
                + x9 * (2.0 * a * x163 - 4.0 * x120 - 4.0 * x121)
            )
            + x164 * x56
            + x164 * x8,
        ]
    )


def kinetic3d_42(a, A, b, B):
    """Cartesian 3D (gd) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = -a
    x7 = x5**2
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7)
    x10 = b * x3
    x11 = a * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = 1.77245385090552 * numpy.sqrt(x3)
    x14 = x12 * x13
    x15 = x14 * x5
    x16 = x0 * x10
    x17 = x15 * x16 + x15 * x9
    x18 = x17 * x5
    x19 = x14 * x7
    x20 = x14 * x2
    x21 = x19 + x20
    x22 = 2.0 * x14
    x23 = -x22
    x24 = x10 * (x0 * x21 + x23)
    x25 = x18 + x24
    x26 = x20 * x9
    x27 = 3.0 * x26
    x28 = -x4 - B[0]
    x29 = x14 * x28
    x30 = x16 * x29 + x29 * x9
    x31 = x30 * x5
    x32 = x15 * x28
    x33 = x20 + x32
    x34 = 4.0 * x11
    x35 = x27 + 2.0 * x31 + x33 * x34
    x36 = x2 * (x25 + x35)
    x37 = x2 * (x17 + x30)
    x38 = x16 * x33 + x26 + x31
    x39 = x38 * x5
    x40 = x2 * (x15 + x29)
    x41 = x33 * x5
    x42 = x40 + x41
    x43 = x22 * x28
    x44 = x0 * x42 - x43
    x45 = x10 * x44
    x46 = x37 + x39 + x45
    x47 = x46 * x5
    x48 = x28**2
    x49 = x14 * x48
    x50 = x20 + x49
    x51 = a * x3
    x52 = x28 * x30 + x51 * (x1 * x50 + x23)
    x53 = x2 * (x35 + x52)
    x54 = x2 * (x29 * x34 + x43 * x9)
    x55 = x26 + x52
    x56 = x5 * x55
    x57 = x5 * x50
    x58 = 2.0 * x20
    x59 = x28 * x58 + x57
    x60 = x16 * x59 + x54 + x56
    x61 = x5 * x60
    x62 = 3.0 * x20
    x63 = x43 * x5 + x62
    x64 = x2 * (x19 + x63)
    x65 = x42 * x5
    x66 = x64 + x65
    x67 = 2.0 * a * x66 - 3.0 * x32 - x62
    x68 = x1 * x3
    x69 = x2 * (x49 + x63)
    x70 = x5 * x59
    x71 = x69 + x70
    x72 = x10 * (2.0 * a * x71 - x22 * x48 - x58)
    x73 = x53 + x61 + x72
    x74 = 4.0 * x20
    x75 = x2 * (x28 * x74 + 2.0 * x40 + 2.0 * x41 + 2.0 * x57) + x5 * x71
    x76 = (
        x10 * (2.0 * a * x75 - 6.0 * x20 * x28 - 3.0 * x57)
        + x2 * (x34 * x59 + 2.0 * x37 + 2.0 * x39 + x44 * x68 + 2.0 * x54 + 2.0 * x56)
        + x5 * x73
    )
    x77 = x2 * (2.0 * x64 + 2.0 * x65 + 3.0 * x69 + 3.0 * x70) + x5 * x75
    x78 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x79 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x80 = 3.14159265358979 * x3 * x79
    x81 = x78 * x80
    x82 = -x3 * (a * A[1] + b * B[1])
    x83 = -x82 - A[1]
    x84 = x83**2
    x85 = -x6 - x8 * (x2 + x84)
    x86 = x77 * x81
    x87 = -x3 * (a * A[2] + b * B[2])
    x88 = -x87 - A[2]
    x89 = x88**2
    x90 = -x6 - x8 * (x2 + x89)
    x91 = -x82 - B[1]
    x92 = x13 * x78
    x93 = x91 * x92
    x94 = x16 * x93 + x85 * x93
    x95 = x21 * x5 + x5 * x58
    x96 = x2 * (3.0 * x40 + 3.0 * x41 + x95) + x5 * x66
    x97 = x13 * x79
    x98 = x25 + x26
    x99 = x10 * (x0 * x95 - 3.0 * x15) + x2 * (x15 * x34 + x22 * x5 * x9) + x5 * x98
    x100 = x10 * x67 + x36 + x47
    x101 = x81 * (
        x10 * (2.0 * a * x96 - 4.0 * x40 - 4.0 * x41)
        + x100 * x5
        + x2 * (3.0 * x37 + 3.0 * x39 + 3.0 * x45 + x99)
    )
    x102 = x81 * x96
    x103 = -x87 - B[2]
    x104 = x103 * x97
    x105 = x104 * x16 + x104 * x90
    x106 = x2 * x92
    x107 = x106 * x85
    x108 = x91**2 * x92
    x109 = x106 + x108
    x110 = 2.0 * x92
    x111 = -x110
    x112 = x51 * (x1 * x109 + x111) + x91 * x94
    x113 = x107 + x112
    x114 = x2 * (3.0 * x19 + x62) + x5 * x95
    x115 = x114 * x97
    x116 = (
        x10 * (2.0 * a * x114 - 4.0 * x19 - x74)
        + x2 * (3.0 * x18 + 3.0 * x24 + x27)
        + x5 * x99
    )
    x117 = x103 * x81
    x118 = x2 * x97
    x119 = x118 * x90
    x120 = x103**2 * x97
    x121 = x118 + x120
    x122 = 2.0 * x97
    x123 = -x122
    x124 = x103 * x105 + x51 * (x1 * x121 + x123)
    x125 = x119 + x124
    x126 = x114 * x92
    x127 = x83 * x92
    x128 = x127 * x16 + x127 * x85
    x129 = x76 * x81
    x130 = x75 * x81
    x131 = x83 * x94
    x132 = x127 * x91
    x133 = x106 + x132
    x134 = x107 + x131 + x133 * x16
    x135 = x66 * x97
    x136 = x110 * x91
    x137 = x2 * (x136 * x85 + x34 * x93)
    x138 = x113 * x83
    x139 = x109 * x83
    x140 = 2.0 * x106
    x141 = x139 + x140 * x91
    x142 = x137 + x138 + x141 * x16
    x143 = x95 * x97
    x144 = x88 * x97
    x145 = x144 * x16 + x144 * x90
    x146 = x81 * x88
    x147 = x105 * x88
    x148 = x103 * x144
    x149 = x118 + x148
    x150 = x119 + x147 + x149 * x16
    x151 = x66 * x92
    x152 = x103 * x122
    x153 = x2 * (x104 * x34 + x152 * x90)
    x154 = x125 * x88
    x155 = x121 * x88
    x156 = 2.0 * x118
    x157 = x103 * x156 + x155
    x158 = x153 + x154 + x157 * x16
    x159 = x92 * x95
    x160 = x128 * x83
    x161 = x84 * x92
    x162 = x106 + x161
    x163 = x10 * (x0 * x162 + x111)
    x164 = x160 + x163
    x165 = x107 + x164
    x166 = x71 * x97
    x167 = x2 * (x128 + x94)
    x168 = x134 * x83
    x169 = x2 * (x127 + x93)
    x170 = x133 * x83
    x171 = x169 + x170
    x172 = x0 * x171 - x136
    x173 = x10 * x172
    x174 = x167 + x168 + x173
    x175 = x42 * x97
    x176 = 3.0 * x106
    x177 = x136 * x83 + x176
    x178 = x2 * (x108 + x177)
    x179 = x141 * x83
    x180 = x178 + x179
    x181 = x180 * x97
    x182 = 3.0 * x107
    x183 = 2.0 * x131 + x133 * x34 + x182
    x184 = x2 * (x112 + x183)
    x185 = x142 * x83
    x186 = x10 * (2.0 * a * x180 - 2.0 * x108 - x140)
    x187 = x184 + x185 + x186
    x188 = x145 * x88
    x189 = x89 * x97
    x190 = x118 + x189
    x191 = x10 * (x0 * x190 + x123)
    x192 = x188 + x191
    x193 = x119 + x192
    x194 = x71 * x92
    x195 = x2 * (x105 + x145)
    x196 = x150 * x88
    x197 = x2 * (x104 + x144)
    x198 = x149 * x88
    x199 = x197 + x198
    x200 = x0 * x199 - x152
    x201 = x10 * x200
    x202 = x195 + x196 + x201
    x203 = x42 * x92
    x204 = 3.0 * x118
    x205 = x152 * x88 + x204
    x206 = x2 * (x120 + x205)
    x207 = x157 * x88
    x208 = x206 + x207
    x209 = x208 * x92
    x210 = 3.0 * x119
    x211 = 2.0 * x147 + x149 * x34 + x210
    x212 = x2 * (x124 + x211)
    x213 = x158 * x88
    x214 = x10 * (2.0 * a * x208 - 2.0 * x120 - x156)
    x215 = x212 + x213 + x214
    x216 = x140 * x83 + x162 * x83
    x217 = (
        x10 * (x0 * x216 - 3.0 * x127) + x165 * x83 + x2 * (x110 * x83 * x85 + x127 * x34)
    )
    x218 = x59 * x97
    x219 = x2 * (x161 + x177)
    x220 = x171 * x83
    x221 = x219 + x220
    x222 = x221 * x97
    x223 = x2 * (x164 + x183)
    x224 = x174 * x83
    x225 = 2.0 * a * x221 - 3.0 * x132 - x176
    x226 = x10 * x225 + x223 + x224
    x227 = 4.0 * x106
    x228 = x180 * x83 + x2 * (2.0 * x139 + 2.0 * x169 + 2.0 * x170 + x227 * x91)
    x229 = (
        x10 * (2.0 * a * x228 - 6.0 * x106 * x91 - 3.0 * x139)
        + x187 * x83
        + x2
        * (2.0 * x137 + 2.0 * x138 + x141 * x34 + 2.0 * x167 + 2.0 * x168 + x172 * x68)
    )
    x230 = x12 * x80
    x231 = x229 * x230
    x232 = x230 * x5
    x233 = 3.14159265358979 * x12 * x3 * x78
    x234 = x233 * x5
    x235 = x156 * x88 + x190 * x88
    x236 = (
        x10 * (x0 * x235 - 3.0 * x144) + x193 * x88 + x2 * (x122 * x88 * x90 + x144 * x34)
    )
    x237 = x59 * x92
    x238 = x2 * (x189 + x205)
    x239 = x199 * x88
    x240 = x238 + x239
    x241 = x240 * x92
    x242 = x2 * (x192 + x211)
    x243 = x202 * x88
    x244 = 2.0 * a * x240 - 3.0 * x148 - x204
    x245 = x10 * x244 + x242 + x243
    x246 = 4.0 * x118
    x247 = x2 * (x103 * x246 + 2.0 * x155 + 2.0 * x197 + 2.0 * x198) + x208 * x88
    x248 = (
        x10 * (2.0 * a * x247 - 6.0 * x103 * x118 - 3.0 * x155)
        + x2
        * (2.0 * x153 + 2.0 * x154 + x157 * x34 + 2.0 * x195 + 2.0 * x196 + x200 * x68)
        + x215 * x88
    )
    x249 = x233 * x248
    x250 = x2 * (3.0 * x161 + x176) + x216 * x83
    x251 = x250 * x97
    x252 = (
        x10 * (2.0 * a * x250 - 4.0 * x161 - x227)
        + x2 * (3.0 * x160 + 3.0 * x163 + x182)
        + x217 * x83
    )
    x253 = x2 * (3.0 * x169 + 3.0 * x170 + x216) + x221 * x83
    x254 = x230 * (
        x10 * (2.0 * a * x253 - 4.0 * x169 - 4.0 * x170)
        + x2 * (3.0 * x167 + 3.0 * x168 + 3.0 * x173 + x217)
        + x226 * x83
    )
    x255 = x230 * x28
    x256 = x2 * (3.0 * x178 + 3.0 * x179 + 2.0 * x219 + 2.0 * x220) + x228 * x83
    x257 = x230 * x256
    x258 = x230 * x9
    x259 = x14 * x250
    x260 = x14 * x221
    x261 = x14 * x216
    x262 = x14 * x180
    x263 = x14 * x171
    x264 = x14 * x208
    x265 = x233 * x83
    x266 = x14 * x141
    x267 = x14 * x240
    x268 = x2 * (3.0 * x189 + x204) + x235 * x88
    x269 = x268 * x92
    x270 = (
        x10 * (2.0 * a * x268 - 4.0 * x189 - x246)
        + x2 * (3.0 * x188 + 3.0 * x191 + x210)
        + x236 * x88
    )
    x271 = x233 * x28
    x272 = x2 * (3.0 * x197 + 3.0 * x198 + x235) + x240 * x88
    x273 = x233 * (
        x10 * (2.0 * a * x272 - 4.0 * x197 - 4.0 * x198)
        + x2 * (3.0 * x195 + 3.0 * x196 + 3.0 * x201 + x236)
        + x245 * x88
    )
    x274 = x14 * x268
    x275 = x2 * (3.0 * x206 + 3.0 * x207 + 2.0 * x238 + 2.0 * x239) + x247 * x88
    x276 = x233 * x275

    # 90 item(s)
    return numpy.array(
        [
            x81
            * (
                x10 * (2.0 * a * x77 - 4.0 * x69 - 4.0 * x70)
                + x2
                * (2.0 * x36 + 2.0 * x47 + 3.0 * x53 + 3.0 * x61 + x67 * x68 + 3.0 * x72)
                + x5 * x76
            )
            + x85 * x86
            + x86 * x90,
            x101 * x91 + x102 * x90 * x91 + x94 * x96 * x97,
            x101 * x103 + x102 * x103 * x85 + x105 * x92 * x96,
            x109 * x115 * x90 + x109 * x116 * x97 + x113 * x115,
            x104 * x114 * x94 + x105 * x114 * x93 + x116 * x117 * x91,
            x116 * x121 * x92 + x121 * x126 * x85 + x125 * x126,
            x128 * x75 * x97 + x129 * x83 + x130 * x83 * x90,
            x100 * x133 * x97 + x133 * x135 * x90 + x134 * x135,
            x100 * x117 * x83 + x104 * x128 * x66 + x105 * x127 * x66,
            x141 * x143 * x90 + x141 * x97 * x99 + x142 * x143,
            x104 * x133 * x99 + x104 * x134 * x95 + x105 * x133 * x95,
            x121 * x127 * x99 + x121 * x128 * x95 + x125 * x127 * x95,
            x129 * x88 + x130 * x85 * x88 + x145 * x75 * x92,
            x100 * x146 * x91 + x144 * x66 * x94 + x145 * x66 * x93,
            x100 * x149 * x92 + x149 * x151 * x85 + x150 * x151,
            x109 * x144 * x99 + x109 * x145 * x95 + x113 * x144 * x95,
            x149 * x93 * x99 + x149 * x94 * x95 + x150 * x93 * x95,
            x157 * x159 * x85 + x157 * x92 * x99 + x158 * x159,
            x162 * x166 * x90 + x162 * x73 * x97 + x165 * x166,
            x171 * x175 * x90 + x171 * x46 * x97 + x174 * x175,
            x104 * x162 * x46 + x104 * x165 * x42 + x105 * x162 * x42,
            x181 * x21 * x90 + x181 * x98 + x187 * x21 * x97,
            x104 * x171 * x98 + x104 * x174 * x21 + x105 * x171 * x21,
            x121 * x162 * x98 + x121 * x165 * x21 + x125 * x162 * x21,
            x127 * x145 * x71 + x128 * x144 * x71 + x146 * x73 * x83,
            x133 * x144 * x46 + x133 * x145 * x42 + x134 * x144 * x42,
            x127 * x149 * x46 + x127 * x150 * x42 + x128 * x149 * x42,
            x141 * x144 * x98 + x141 * x145 * x21 + x142 * x144 * x21,
            x133 * x149 * x98 + x133 * x150 * x21 + x134 * x149 * x21,
            x127 * x157 * x98 + x127 * x158 * x21 + x128 * x157 * x21,
            x190 * x194 * x85 + x190 * x73 * x92 + x193 * x194,
            x190 * x42 * x94 + x190 * x46 * x93 + x193 * x42 * x93,
            x199 * x203 * x85 + x199 * x46 * x92 + x202 * x203,
            x109 * x190 * x98 + x109 * x193 * x21 + x113 * x190 * x21,
            x199 * x21 * x94 + x199 * x93 * x98 + x202 * x21 * x93,
            x209 * x21 * x85 + x209 * x98 + x21 * x215 * x92,
            x216 * x218 * x90 + x216 * x60 * x97 + x217 * x218,
            x222 * x33 * x90 + x222 * x38 + x226 * x33 * x97,
            x104 * x216 * x38 + x104 * x217 * x33 + x105 * x216 * x33,
            x17 * x228 * x97 + x228 * x232 * x90 + x231 * x5,
            x103 * x226 * x232 + x104 * x17 * x221 + x105 * x15 * x221,
            x121 * x15 * x217 + x121 * x17 * x216 + x125 * x15 * x216,
            x144 * x162 * x60 + x144 * x165 * x59 + x145 * x162 * x59,
            x144 * x171 * x38 + x144 * x174 * x33 + x145 * x171 * x33,
            x149 * x162 * x38 + x149 * x165 * x33 + x150 * x162 * x33,
            x144 * x17 * x180 + x145 * x15 * x180 + x187 * x232 * x88,
            x149 * x15 * x174 + x149 * x17 * x171 + x15 * x150 * x171,
            x15 * x157 * x165 + x15 * x158 * x162 + x157 * x162 * x17,
            x127 * x190 * x60 + x127 * x193 * x59 + x128 * x190 * x59,
            x133 * x190 * x38 + x133 * x193 * x33 + x134 * x190 * x33,
            x127 * x199 * x38 + x127 * x202 * x33 + x128 * x199 * x33,
            x141 * x15 * x193 + x141 * x17 * x190 + x142 * x15 * x190,
            x133 * x15 * x202 + x133 * x17 * x199 + x134 * x15 * x199,
            x127 * x17 * x208 + x128 * x15 * x208 + x215 * x234 * x83,
            x235 * x237 * x85 + x235 * x60 * x92 + x236 * x237,
            x235 * x33 * x94 + x235 * x38 * x93 + x236 * x33 * x93,
            x241 * x33 * x85 + x241 * x38 + x245 * x33 * x92,
            x109 * x15 * x236 + x109 * x17 * x235 + x113 * x15 * x235,
            x15 * x240 * x94 + x17 * x240 * x93 + x234 * x245 * x91,
            x17 * x247 * x92 + x234 * x247 * x85 + x249 * x5,
            x251 * x50 * x90 + x251 * x55 + x252 * x50 * x97,
            x253 * x255 * x90 + x253 * x30 * x97 + x254 * x28,
            x103 * x252 * x255 + x104 * x250 * x30 + x105 * x250 * x29,
            x230
            * (
                x10 * (2.0 * a * x256 - 4.0 * x178 - 4.0 * x179)
                + x2
                * (
                    3.0 * x184
                    + 3.0 * x185
                    + 3.0 * x186
                    + 2.0 * x223
                    + 2.0 * x224
                    + x225 * x68
                )
                + x229 * x83
            )
            + x257 * x9
            + x257 * x90,
            x103 * x253 * x258 + x103 * x254 + x105 * x14 * x253,
            x121 * x14 * x252 + x121 * x259 * x9 + x125 * x259,
            x144 * x216 * x55 + x144 * x217 * x50 + x145 * x216 * x50,
            x144 * x221 * x30 + x145 * x221 * x29 + x226 * x255 * x88,
            x149 * x216 * x30 + x149 * x217 * x29 + x150 * x216 * x29,
            x14 * x145 * x228 + x228 * x258 * x88 + x231 * x88,
            x14 * x149 * x226 + x149 * x260 * x9 + x150 * x260,
            x14 * x157 * x217 + x157 * x261 * x9 + x158 * x261,
            x162 * x190 * x55 + x162 * x193 * x50 + x165 * x190 * x50,
            x171 * x190 * x30 + x171 * x193 * x29 + x174 * x190 * x29,
            x162 * x199 * x30 + x162 * x202 * x29 + x165 * x199 * x29,
            x14 * x187 * x190 + x190 * x262 * x9 + x193 * x262,
            x14 * x174 * x199 + x199 * x263 * x9 + x202 * x263,
            x14 * x162 * x215 + x162 * x264 * x9 + x165 * x264,
            x127 * x235 * x55 + x127 * x236 * x50 + x128 * x235 * x50,
            x133 * x235 * x30 + x133 * x236 * x29 + x134 * x235 * x29,
            x127 * x240 * x30 + x128 * x240 * x29 + x245 * x265 * x28,
            x14 * x142 * x235 + x235 * x266 * x9 + x236 * x266,
            x133 * x14 * x245 + x133 * x267 * x9 + x134 * x267,
            x128 * x14 * x247 + x247 * x265 * x9 + x249 * x83,
            x269 * x50 * x85 + x269 * x55 + x270 * x50 * x92,
            x268 * x29 * x94 + x268 * x30 * x93 + x270 * x271 * x91,
            x271 * x272 * x85 + x272 * x30 * x92 + x273 * x28,
            x109 * x14 * x270 + x109 * x274 * x9 + x113 * x274,
            x14 * x272 * x94 + x233 * x272 * x9 * x91 + x273 * x91,
            x233
            * (
                x10 * (2.0 * a * x275 - 4.0 * x206 - 4.0 * x207)
                + x2
                * (
                    3.0 * x212
                    + 3.0 * x213
                    + 3.0 * x214
                    + 2.0 * x242
                    + 2.0 * x243
                    + x244 * x68
                )
                + x248 * x88
            )
            + x276 * x85
            + x276 * x9,
        ]
    )


def kinetic3d_43(a, A, b, B):
    """Cartesian 3D (gf) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = -a
    x7 = x5**2
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7)
    x10 = a * x3
    x11 = b * x10
    x12 = numpy.exp(-x11 * (A[0] - B[0]) ** 2)
    x13 = 1.77245385090552 * numpy.sqrt(x3)
    x14 = x12 * x13
    x15 = x14 * x2
    x16 = x15 * x9
    x17 = -x4 - B[0]
    x18 = x14 * x17
    x19 = b * x3
    x20 = x0 * x19
    x21 = x18 * x20 + x18 * x9
    x22 = x17 * x21
    x23 = x14 * x17**2
    x24 = x15 + x23
    x25 = 2.0 * x14
    x26 = -x25
    x27 = x10 * (x1 * x24 + x26)
    x28 = x22 + x27
    x29 = x16 + x28
    x30 = x29 * x5
    x31 = x17 * x25
    x32 = 4.0 * x11
    x33 = x2 * (x18 * x32 + x31 * x9)
    x34 = x24 * x5
    x35 = 2.0 * x15
    x36 = x17 * x35
    x37 = x34 + x36
    x38 = x11 * x37
    x39 = x17 * x24
    x40 = x36 + x39
    x41 = x10 * (x1 * x40 - 3.0 * x18) + x17 * x29
    x42 = x2 * (3.0 * x30 + 4.0 * x33 + 6.0 * x38 + x41)
    x43 = x14 * x5
    x44 = x20 * x43 + x43 * x9
    x45 = x2 * (x21 + x44)
    x46 = x21 * x5
    x47 = x17 * x43
    x48 = x15 + x47
    x49 = x16 + x20 * x48 + x46
    x50 = x49 * x5
    x51 = x2 * (x18 + x43)
    x52 = x48 * x5
    x53 = x51 + x52
    x54 = x0 * x53 - x31
    x55 = x1 * x3
    x56 = x2 * (2.0 * x30 + 2.0 * x33 + 4.0 * x38 + 2.0 * x45 + 2.0 * x50 + x54 * x55)
    x57 = 3.0 * x16
    x58 = x2 * (3.0 * x22 + 3.0 * x27 + x57)
    x59 = x33 + x41
    x60 = x5 * x59
    x61 = 3.0 * x15
    x62 = x2 * (3.0 * x23 + x61)
    x63 = x40 * x5
    x64 = x62 + x63
    x65 = x20 * x64 + x58 + x60
    x66 = x5 * x65
    x67 = x32 * x48 + 2.0 * x46 + x57
    x68 = x2 * (x28 + x67)
    x69 = x20 * x37 + x30 + x33
    x70 = x5 * x69
    x71 = x31 * x5 + x61
    x72 = x2 * (x23 + x71)
    x73 = x37 * x5
    x74 = x72 + x73
    x75 = x19 * (2.0 * a * x74 - 2.0 * x23 - x35)
    x76 = x68 + x70 + x75
    x77 = x5 * x76
    x78 = 4.0 * x15
    x79 = x17 * x78
    x80 = x2 * (2.0 * x34 + 2.0 * x51 + 2.0 * x52 + x79)
    x81 = x5 * x74
    x82 = x80 + x81
    x83 = 3.0 * x34
    x84 = x15 * x17
    x85 = x19 * (2.0 * a * x82 - x83 - 6.0 * x84)
    x86 = x2 * (x39 + x83 + 8.0 * x84)
    x87 = x5 * x64
    x88 = x86 + x87
    x89 = x19 * (2.0 * a * x88 - 2.0 * x39 - x79)
    x90 = 3.0 * x68 + 3.0 * x70 + 3.0 * x75
    x91 = x42 + x66 + x89
    x92 = 3.0 * x72 + 3.0 * x73
    x93 = x2 * (2.0 * x62 + 2.0 * x63 + x92) + x5 * x88
    x94 = (
        x19 * (2.0 * a * x93 - 3.0 * x62 - 3.0 * x63)
        + x2 * (x32 * x64 + 2.0 * x58 + 2.0 * x60 + x90)
        + x5 * x91
    )
    x95 = x2 * (3.0 * x80 + 3.0 * x81 + 3.0 * x86 + 3.0 * x87) + x5 * x93
    x96 = numpy.exp(-x11 * (A[1] - B[1]) ** 2)
    x97 = numpy.exp(-x11 * (A[2] - B[2]) ** 2)
    x98 = 3.14159265358979 * x3 * x97
    x99 = x96 * x98
    x100 = -x3 * (a * A[1] + b * B[1])
    x101 = -x100 - A[1]
    x102 = x101**2
    x103 = -x6 - x8 * (x102 + x2)
    x104 = x95 * x99
    x105 = -x3 * (a * A[2] + b * B[2])
    x106 = -x105 - A[2]
    x107 = x106**2
    x108 = -x6 - x8 * (x107 + x2)
    x109 = -x100 - B[1]
    x110 = x13 * x96
    x111 = x109 * x110
    x112 = x103 * x111 + x111 * x20
    x113 = x14 * x7
    x114 = x2 * (x113 + x71)
    x115 = x5 * x53
    x116 = x2 * (2.0 * x114 + 2.0 * x115 + x92) + x5 * x82
    x117 = x13 * x97
    x118 = x44 * x5
    x119 = x113 + x15
    x120 = x19 * (x0 * x119 + x26)
    x121 = x118 + x120
    x122 = x2 * (x121 + x67)
    x123 = x19 * x54
    x124 = x123 + x45 + x50
    x125 = x124 * x5
    x126 = x114 + x115
    x127 = 2.0 * a * x126 - 3.0 * x47 - x61
    x128 = x56 + x77 + x85
    x129 = x99 * (
        x128 * x5
        + x19 * (2.0 * a * x116 - 4.0 * x72 - 4.0 * x73)
        + x2 * (2.0 * x122 + 2.0 * x125 + x127 * x55 + x90)
    )
    x130 = x116 * x99
    x131 = -x105 - B[2]
    x132 = x117 * x131
    x133 = x108 * x132 + x132 * x20
    x134 = x110 * x2
    x135 = x103 * x134
    x136 = x109 * x112
    x137 = x109**2 * x110
    x138 = x134 + x137
    x139 = 2.0 * x110
    x140 = -x139
    x141 = x10 * (x1 * x138 + x140)
    x142 = x136 + x141
    x143 = x135 + x142
    x144 = x119 * x5 + x35 * x5
    x145 = x126 * x5 + x2 * (x144 + 3.0 * x51 + 3.0 * x52)
    x146 = x117 * x145
    x147 = x121 + x16
    x148 = x147 * x5 + x19 * (x0 * x144 - 3.0 * x43) + x2 * (x25 * x5 * x9 + x32 * x43)
    x149 = x122 + x125 + x127 * x19
    x150 = (
        x149 * x5
        + x19 * (2.0 * a * x145 - 4.0 * x51 - 4.0 * x52)
        + x2 * (3.0 * x123 + x148 + 3.0 * x45 + 3.0 * x50)
    )
    x151 = x131 * x99
    x152 = x117 * x2
    x153 = x108 * x152
    x154 = x131 * x133
    x155 = x117 * x131**2
    x156 = x152 + x155
    x157 = 2.0 * x117
    x158 = -x157
    x159 = x10 * (x1 * x156 + x158)
    x160 = x154 + x159
    x161 = x153 + x160
    x162 = x110 * x145
    x163 = x109 * x139
    x164 = x2 * (x103 * x163 + x111 * x32)
    x165 = x109 * x138
    x166 = 2.0 * x134
    x167 = x109 * x166
    x168 = x165 + x167
    x169 = x10 * (x1 * x168 - 3.0 * x111) + x109 * x143
    x170 = x164 + x169
    x171 = x144 * x5 + x2 * (3.0 * x113 + x61)
    x172 = x117 * x171
    x173 = (
        x148 * x5
        + x19 * (2.0 * a * x171 - 4.0 * x113 - x78)
        + x2 * (3.0 * x118 + 3.0 * x120 + x57)
    )
    x174 = x131 * x157
    x175 = x2 * (x108 * x174 + x132 * x32)
    x176 = x131 * x156
    x177 = 2.0 * x152
    x178 = x131 * x177
    x179 = x176 + x178
    x180 = x10 * (x1 * x179 - 3.0 * x132) + x131 * x161
    x181 = x175 + x180
    x182 = x110 * x171
    x183 = x101 * x110
    x184 = x103 * x183 + x183 * x20
    x185 = x94 * x99
    x186 = x93 * x99
    x187 = x101 * x112
    x188 = x109 * x183
    x189 = x134 + x188
    x190 = x135 + x187 + x189 * x20
    x191 = x117 * x82
    x192 = x101 * x143
    x193 = x101 * x138
    x194 = x167 + x193
    x195 = x164 + x192 + x194 * x20
    x196 = x117 * x126
    x197 = 3.0 * x134
    x198 = x2 * (3.0 * x137 + x197)
    x199 = x101 * x168
    x200 = x198 + x199
    x201 = x117 * x200
    x202 = 3.0 * x135
    x203 = x2 * (3.0 * x136 + 3.0 * x141 + x202)
    x204 = x101 * x170
    x205 = x20 * x200 + x203 + x204
    x206 = x106 * x117
    x207 = x108 * x206 + x20 * x206
    x208 = x106 * x99
    x209 = x106 * x133
    x210 = x131 * x206
    x211 = x152 + x210
    x212 = x153 + x20 * x211 + x209
    x213 = x110 * x82
    x214 = x106 * x161
    x215 = x106 * x156
    x216 = x178 + x215
    x217 = x175 + x20 * x216 + x214
    x218 = x110 * x126
    x219 = 3.0 * x152
    x220 = x2 * (3.0 * x155 + x219)
    x221 = x106 * x179
    x222 = x220 + x221
    x223 = x110 * x222
    x224 = 3.0 * x153
    x225 = x2 * (3.0 * x154 + 3.0 * x159 + x224)
    x226 = x106 * x181
    x227 = x20 * x222 + x225 + x226
    x228 = x101 * x184
    x229 = x102 * x110
    x230 = x134 + x229
    x231 = x19 * (x0 * x230 + x140)
    x232 = x228 + x231
    x233 = x135 + x232
    x234 = x117 * x88
    x235 = x2 * (x111 + x183)
    x236 = x101 * x189
    x237 = x235 + x236
    x238 = x117 * x237
    x239 = x2 * (x112 + x184)
    x240 = x101 * x190
    x241 = x0 * x237 - x163
    x242 = x19 * x241
    x243 = x239 + x240 + x242
    x244 = 2.0 * x187 + x189 * x32 + x202
    x245 = x2 * (x142 + x244)
    x246 = x101 * x195
    x247 = x101 * x163 + x197
    x248 = x2 * (x137 + x247)
    x249 = x101 * x194
    x250 = x248 + x249
    x251 = x19 * (2.0 * a * x250 - 2.0 * x137 - x166)
    x252 = x245 + x246 + x251
    x253 = x117 * x53
    x254 = 3.0 * x193
    x255 = x109 * x134
    x256 = x2 * (x165 + x254 + 8.0 * x255)
    x257 = x101 * x200
    x258 = x256 + x257
    x259 = x117 * x258
    x260 = 6.0 * x11
    x261 = x2 * (4.0 * x164 + x169 + 3.0 * x192 + x194 * x260)
    x262 = x101 * x205
    x263 = 4.0 * x134
    x264 = x109 * x263
    x265 = x19 * (2.0 * a * x258 - 2.0 * x165 - x264)
    x266 = x261 + x262 + x265
    x267 = x106 * x207
    x268 = x107 * x117
    x269 = x152 + x268
    x270 = x19 * (x0 * x269 + x158)
    x271 = x267 + x270
    x272 = x153 + x271
    x273 = x110 * x88
    x274 = x2 * (x132 + x206)
    x275 = x106 * x211
    x276 = x274 + x275
    x277 = x110 * x276
    x278 = x2 * (x133 + x207)
    x279 = x106 * x212
    x280 = x0 * x276 - x174
    x281 = x19 * x280
    x282 = x278 + x279 + x281
    x283 = 2.0 * x209 + x211 * x32 + x224
    x284 = x2 * (x160 + x283)
    x285 = x106 * x217
    x286 = x106 * x174 + x219
    x287 = x2 * (x155 + x286)
    x288 = x106 * x216
    x289 = x287 + x288
    x290 = x19 * (2.0 * a * x289 - 2.0 * x155 - x177)
    x291 = x284 + x285 + x290
    x292 = x110 * x53
    x293 = 3.0 * x215
    x294 = x131 * x152
    x295 = x2 * (x176 + x293 + 8.0 * x294)
    x296 = x106 * x222
    x297 = x295 + x296
    x298 = x110 * x297
    x299 = x2 * (4.0 * x175 + x180 + 3.0 * x214 + x216 * x260)
    x300 = x106 * x227
    x301 = 4.0 * x152
    x302 = x131 * x301
    x303 = x19 * (2.0 * a * x297 - 2.0 * x176 - x302)
    x304 = x299 + x300 + x303
    x305 = x101 * x166 + x101 * x230
    x306 = (
        x101 * x233
        + x19 * (x0 * x305 - 3.0 * x183)
        + x2 * (x101 * x103 * x139 + x183 * x32)
    )
    x307 = x117 * x64
    x308 = x2 * (x229 + x247)
    x309 = x101 * x237
    x310 = x308 + x309
    x311 = x117 * x310
    x312 = x2 * (x232 + x244)
    x313 = x101 * x243
    x314 = 2.0 * a * x310 - 3.0 * x188 - x197
    x315 = x19 * x314 + x312 + x313
    x316 = x2 * (2.0 * x193 + 2.0 * x235 + 2.0 * x236 + x264)
    x317 = x101 * x250
    x318 = x316 + x317
    x319 = x117 * x318
    x320 = x2 * (
        2.0 * x164 + 2.0 * x192 + x194 * x32 + 2.0 * x239 + 2.0 * x240 + x241 * x55
    )
    x321 = x101 * x252
    x322 = x19 * (2.0 * a * x318 - x254 - 6.0 * x255)
    x323 = x320 + x321 + x322
    x324 = 3.0 * x248 + 3.0 * x249
    x325 = x101 * x258 + x2 * (2.0 * x198 + 2.0 * x199 + x324)
    x326 = 3.0 * x245 + 3.0 * x246 + 3.0 * x251
    x327 = (
        x101 * x266
        + x19 * (2.0 * a * x325 - 3.0 * x198 - 3.0 * x199)
        + x2 * (x200 * x32 + 2.0 * x203 + 2.0 * x204 + x326)
    )
    x328 = x12 * x98
    x329 = x327 * x328
    x330 = x328 * x5
    x331 = 3.14159265358979 * x12 * x3 * x96
    x332 = x331 * x5
    x333 = x106 * x177 + x106 * x269
    x334 = (
        x106 * x272
        + x19 * (x0 * x333 - 3.0 * x206)
        + x2 * (x106 * x108 * x157 + x206 * x32)
    )
    x335 = x110 * x64
    x336 = x2 * (x268 + x286)
    x337 = x106 * x276
    x338 = x336 + x337
    x339 = x110 * x338
    x340 = x2 * (x271 + x283)
    x341 = x106 * x282
    x342 = 2.0 * a * x338 - 3.0 * x210 - x219
    x343 = x19 * x342 + x340 + x341
    x344 = x2 * (2.0 * x215 + 2.0 * x274 + 2.0 * x275 + x302)
    x345 = x106 * x289
    x346 = x344 + x345
    x347 = x110 * x346
    x348 = x2 * (
        2.0 * x175 + 2.0 * x214 + x216 * x32 + 2.0 * x278 + 2.0 * x279 + x280 * x55
    )
    x349 = x106 * x291
    x350 = x19 * (2.0 * a * x346 - x293 - 6.0 * x294)
    x351 = x348 + x349 + x350
    x352 = 3.0 * x287 + 3.0 * x288
    x353 = x106 * x297 + x2 * (2.0 * x220 + 2.0 * x221 + x352)
    x354 = 3.0 * x284 + 3.0 * x285 + 3.0 * x290
    x355 = (
        x106 * x304
        + x19 * (2.0 * a * x353 - 3.0 * x220 - 3.0 * x221)
        + x2 * (x222 * x32 + 2.0 * x225 + 2.0 * x226 + x354)
    )
    x356 = x331 * x355
    x357 = x101 * x305 + x2 * (x197 + 3.0 * x229)
    x358 = x117 * x357
    x359 = (
        x101 * x306
        + x19 * (2.0 * a * x357 - 4.0 * x229 - x263)
        + x2 * (x202 + 3.0 * x228 + 3.0 * x231)
    )
    x360 = x101 * x310 + x2 * (3.0 * x235 + 3.0 * x236 + x305)
    x361 = x117 * x360
    x362 = (
        x101 * x315
        + x19 * (2.0 * a * x360 - 4.0 * x235 - 4.0 * x236)
        + x2 * (3.0 * x239 + 3.0 * x240 + 3.0 * x242 + x306)
    )
    x363 = x101 * x318 + x2 * (2.0 * x308 + 2.0 * x309 + x324)
    x364 = x328 * (
        x101 * x323
        + x19 * (2.0 * a * x363 - 4.0 * x248 - 4.0 * x249)
        + x2 * (2.0 * x312 + 2.0 * x313 + x314 * x55 + x326)
    )
    x365 = x17 * x328
    x366 = x101 * x325 + x2 * (3.0 * x256 + 3.0 * x257 + 3.0 * x316 + 3.0 * x317)
    x367 = x328 * x366
    x368 = x328 * x9
    x369 = x14 * x360
    x370 = x14 * x357
    x371 = x14 * x318
    x372 = x14 * x310
    x373 = x14 * x222
    x374 = x14 * x258
    x375 = x14 * x276
    x376 = x14 * x237
    x377 = x14 * x297
    x378 = x101 * x331
    x379 = x14 * x200
    x380 = x14 * x338
    x381 = x14 * x346
    x382 = x106 * x333 + x2 * (x219 + 3.0 * x268)
    x383 = x110 * x382
    x384 = (
        x106 * x334
        + x19 * (2.0 * a * x382 - 4.0 * x268 - x301)
        + x2 * (x224 + 3.0 * x267 + 3.0 * x270)
    )
    x385 = x106 * x338 + x2 * (3.0 * x274 + 3.0 * x275 + x333)
    x386 = x110 * x385
    x387 = (
        x106 * x343
        + x19 * (2.0 * a * x385 - 4.0 * x274 - 4.0 * x275)
        + x2 * (3.0 * x278 + 3.0 * x279 + 3.0 * x281 + x334)
    )
    x388 = x17 * x331
    x389 = x106 * x346 + x2 * (2.0 * x336 + 2.0 * x337 + x352)
    x390 = x331 * (
        x106 * x351
        + x19 * (2.0 * a * x389 - 4.0 * x287 - 4.0 * x288)
        + x2 * (2.0 * x340 + 2.0 * x341 + x342 * x55 + x354)
    )
    x391 = x14 * x382
    x392 = x14 * x385
    x393 = x106 * x353 + x2 * (3.0 * x295 + 3.0 * x296 + 3.0 * x344 + 3.0 * x345)
    x394 = x331 * x393

    # 150 item(s)
    return numpy.array(
        [
            x103 * x104
            + x104 * x108
            + x99
            * (
                x19 * (2.0 * a * x95 - 4.0 * x86 - 4.0 * x87)
                + x2
                * (3.0 * x42 + 3.0 * x56 + 3.0 * x66 + 3.0 * x77 + 3.0 * x85 + 3.0 * x89)
                + x5 * x94
            ),
            x108 * x109 * x130 + x109 * x129 + x112 * x116 * x117,
            x103 * x130 * x131 + x110 * x116 * x133 + x129 * x131,
            x108 * x138 * x146 + x117 * x138 * x150 + x143 * x146,
            x109 * x150 * x151 + x111 * x133 * x145 + x112 * x132 * x145,
            x103 * x156 * x162 + x110 * x150 * x156 + x161 * x162,
            x108 * x168 * x172 + x117 * x168 * x173 + x170 * x172,
            x132 * x138 * x173 + x132 * x143 * x171 + x133 * x138 * x171,
            x111 * x156 * x173 + x111 * x161 * x171 + x112 * x156 * x171,
            x103 * x179 * x182 + x110 * x173 * x179 + x181 * x182,
            x101 * x108 * x186 + x101 * x185 + x117 * x184 * x93,
            x108 * x189 * x191 + x117 * x128 * x189 + x190 * x191,
            x101 * x128 * x151 + x132 * x184 * x82 + x133 * x183 * x82,
            x108 * x194 * x196 + x117 * x149 * x194 + x195 * x196,
            x126 * x132 * x190 + x126 * x133 * x189 + x132 * x149 * x189,
            x126 * x156 * x184 + x126 * x161 * x183 + x149 * x156 * x183,
            x108 * x144 * x201 + x117 * x144 * x205 + x148 * x201,
            x132 * x144 * x195 + x132 * x148 * x194 + x133 * x144 * x194,
            x144 * x156 * x190 + x144 * x161 * x189 + x148 * x156 * x189,
            x144 * x179 * x184 + x144 * x181 * x183 + x148 * x179 * x183,
            x103 * x106 * x186 + x106 * x185 + x110 * x207 * x93,
            x109 * x128 * x208 + x111 * x207 * x82 + x112 * x206 * x82,
            x103 * x211 * x213 + x110 * x128 * x211 + x212 * x213,
            x126 * x138 * x207 + x126 * x143 * x206 + x138 * x149 * x206,
            x111 * x126 * x212 + x111 * x149 * x211 + x112 * x126 * x211,
            x103 * x216 * x218 + x110 * x149 * x216 + x217 * x218,
            x144 * x168 * x207 + x144 * x170 * x206 + x148 * x168 * x206,
            x138 * x144 * x212 + x138 * x148 * x211 + x143 * x144 * x211,
            x111 * x144 * x217 + x111 * x148 * x216 + x112 * x144 * x216,
            x103 * x144 * x223 + x110 * x144 * x227 + x148 * x223,
            x108 * x230 * x234 + x117 * x230 * x91 + x233 * x234,
            x108 * x238 * x74 + x117 * x243 * x74 + x238 * x76,
            x132 * x230 * x76 + x132 * x233 * x74 + x133 * x230 * x74,
            x108 * x250 * x253 + x117 * x124 * x250 + x252 * x253,
            x124 * x132 * x237 + x132 * x243 * x53 + x133 * x237 * x53,
            x124 * x156 * x230 + x156 * x233 * x53 + x161 * x230 * x53,
            x108 * x119 * x259 + x117 * x119 * x266 + x147 * x259,
            x119 * x132 * x252 + x119 * x133 * x250 + x132 * x147 * x250,
            x119 * x156 * x243 + x119 * x161 * x237 + x147 * x156 * x237,
            x119 * x179 * x233 + x119 * x181 * x230 + x147 * x179 * x230,
            x101 * x208 * x91 + x183 * x207 * x88 + x184 * x206 * x88,
            x189 * x206 * x76 + x189 * x207 * x74 + x190 * x206 * x74,
            x183 * x211 * x76 + x183 * x212 * x74 + x184 * x211 * x74,
            x124 * x194 * x206 + x194 * x207 * x53 + x195 * x206 * x53,
            x124 * x189 * x211 + x189 * x212 * x53 + x190 * x211 * x53,
            x124 * x183 * x216 + x183 * x217 * x53 + x184 * x216 * x53,
            x119 * x200 * x207 + x119 * x205 * x206 + x147 * x200 * x206,
            x119 * x194 * x212 + x119 * x195 * x211 + x147 * x194 * x211,
            x119 * x189 * x217 + x119 * x190 * x216 + x147 * x189 * x216,
            x119 * x183 * x227 + x119 * x184 * x222 + x147 * x183 * x222,
            x103 * x269 * x273 + x110 * x269 * x91 + x272 * x273,
            x111 * x269 * x76 + x111 * x272 * x74 + x112 * x269 * x74,
            x103 * x277 * x74 + x110 * x282 * x74 + x277 * x76,
            x124 * x138 * x269 + x138 * x272 * x53 + x143 * x269 * x53,
            x111 * x124 * x276 + x111 * x282 * x53 + x112 * x276 * x53,
            x103 * x289 * x292 + x110 * x124 * x289 + x291 * x292,
            x119 * x168 * x272 + x119 * x170 * x269 + x147 * x168 * x269,
            x119 * x138 * x282 + x119 * x143 * x276 + x138 * x147 * x276,
            x111 * x119 * x291 + x111 * x147 * x289 + x112 * x119 * x289,
            x103 * x119 * x298 + x110 * x119 * x304 + x147 * x298,
            x108 * x305 * x307 + x117 * x305 * x65 + x306 * x307,
            x108 * x311 * x37 + x117 * x315 * x37 + x311 * x69,
            x132 * x305 * x69 + x132 * x306 * x37 + x133 * x305 * x37,
            x108 * x319 * x48 + x117 * x323 * x48 + x319 * x49,
            x132 * x310 * x49 + x132 * x315 * x48 + x133 * x310 * x48,
            x156 * x305 * x49 + x156 * x306 * x48 + x161 * x305 * x48,
            x108 * x325 * x330 + x117 * x325 * x44 + x329 * x5,
            x131 * x323 * x330 + x132 * x318 * x44 + x133 * x318 * x43,
            x156 * x310 * x44 + x156 * x315 * x43 + x161 * x310 * x43,
            x179 * x305 * x44 + x179 * x306 * x43 + x181 * x305 * x43,
            x206 * x230 * x65 + x206 * x233 * x64 + x207 * x230 * x64,
            x206 * x237 * x69 + x206 * x243 * x37 + x207 * x237 * x37,
            x211 * x230 * x69 + x211 * x233 * x37 + x212 * x230 * x37,
            x206 * x250 * x49 + x206 * x252 * x48 + x207 * x250 * x48,
            x211 * x237 * x49 + x211 * x243 * x48 + x212 * x237 * x48,
            x216 * x230 * x49 + x216 * x233 * x48 + x217 * x230 * x48,
            x106 * x266 * x330 + x206 * x258 * x44 + x207 * x258 * x43,
            x211 * x250 * x44 + x211 * x252 * x43 + x212 * x250 * x43,
            x216 * x237 * x44 + x216 * x243 * x43 + x217 * x237 * x43,
            x222 * x230 * x44 + x222 * x233 * x43 + x227 * x230 * x43,
            x183 * x269 * x65 + x183 * x272 * x64 + x184 * x269 * x64,
            x189 * x269 * x69 + x189 * x272 * x37 + x190 * x269 * x37,
            x183 * x276 * x69 + x183 * x282 * x37 + x184 * x276 * x37,
            x194 * x269 * x49 + x194 * x272 * x48 + x195 * x269 * x48,
            x189 * x276 * x49 + x189 * x282 * x48 + x190 * x276 * x48,
            x183 * x289 * x49 + x183 * x291 * x48 + x184 * x289 * x48,
            x200 * x269 * x44 + x200 * x272 * x43 + x205 * x269 * x43,
            x194 * x276 * x44 + x194 * x282 * x43 + x195 * x276 * x43,
            x189 * x289 * x44 + x189 * x291 * x43 + x190 * x289 * x43,
            x101 * x304 * x332 + x183 * x297 * x44 + x184 * x297 * x43,
            x103 * x333 * x335 + x110 * x333 * x65 + x334 * x335,
            x111 * x333 * x69 + x111 * x334 * x37 + x112 * x333 * x37,
            x103 * x339 * x37 + x110 * x343 * x37 + x339 * x69,
            x138 * x333 * x49 + x138 * x334 * x48 + x143 * x333 * x48,
            x111 * x338 * x49 + x111 * x343 * x48 + x112 * x338 * x48,
            x103 * x347 * x48 + x110 * x351 * x48 + x347 * x49,
            x168 * x333 * x44 + x168 * x334 * x43 + x170 * x333 * x43,
            x138 * x338 * x44 + x138 * x343 * x43 + x143 * x338 * x43,
            x109 * x332 * x351 + x111 * x346 * x44 + x112 * x346 * x43,
            x103 * x332 * x353 + x110 * x353 * x44 + x356 * x5,
            x108 * x358 * x40 + x117 * x359 * x40 + x358 * x59,
            x108 * x24 * x361 + x117 * x24 * x362 + x29 * x361,
            x132 * x24 * x359 + x132 * x29 * x357 + x133 * x24 * x357,
            x108 * x363 * x365 + x117 * x21 * x363 + x17 * x364,
            x131 * x362 * x365 + x132 * x21 * x360 + x133 * x18 * x360,
            x156 * x18 * x359 + x156 * x21 * x357 + x161 * x18 * x357,
            x108 * x367
            + x328
            * (
                x101 * x327
                + x19 * (2.0 * a * x366 - 4.0 * x256 - 4.0 * x257)
                + x2
                * (
                    3.0 * x261
                    + 3.0 * x262
                    + 3.0 * x265
                    + 3.0 * x320
                    + 3.0 * x321
                    + 3.0 * x322
                )
            )
            + x367 * x9,
            x131 * x363 * x368 + x131 * x364 + x133 * x14 * x363,
            x14 * x156 * x362 + x156 * x369 * x9 + x161 * x369,
            x14 * x179 * x359 + x179 * x370 * x9 + x181 * x370,
            x206 * x305 * x59 + x206 * x306 * x40 + x207 * x305 * x40,
            x206 * x24 * x315 + x206 * x29 * x310 + x207 * x24 * x310,
            x211 * x24 * x306 + x211 * x29 * x305 + x212 * x24 * x305,
            x106 * x323 * x365 + x18 * x207 * x318 + x206 * x21 * x318,
            x18 * x211 * x315 + x18 * x212 * x310 + x21 * x211 * x310,
            x18 * x216 * x306 + x18 * x217 * x305 + x21 * x216 * x305,
            x106 * x325 * x368 + x106 * x329 + x14 * x207 * x325,
            x14 * x211 * x323 + x211 * x371 * x9 + x212 * x371,
            x14 * x216 * x315 + x216 * x372 * x9 + x217 * x372,
            x14 * x227 * x305 + x305 * x373 * x9 + x306 * x373,
            x230 * x269 * x59 + x230 * x272 * x40 + x233 * x269 * x40,
            x237 * x24 * x272 + x237 * x269 * x29 + x24 * x243 * x269,
            x230 * x24 * x282 + x230 * x276 * x29 + x233 * x24 * x276,
            x18 * x250 * x272 + x18 * x252 * x269 + x21 * x250 * x269,
            x18 * x237 * x282 + x18 * x243 * x276 + x21 * x237 * x276,
            x18 * x230 * x291 + x18 * x233 * x289 + x21 * x230 * x289,
            x14 * x266 * x269 + x269 * x374 * x9 + x272 * x374,
            x14 * x250 * x282 + x250 * x375 * x9 + x252 * x375,
            x14 * x243 * x289 + x289 * x376 * x9 + x291 * x376,
            x14 * x230 * x304 + x230 * x377 * x9 + x233 * x377,
            x183 * x333 * x59 + x183 * x334 * x40 + x184 * x333 * x40,
            x189 * x24 * x334 + x189 * x29 * x333 + x190 * x24 * x333,
            x183 * x24 * x343 + x183 * x29 * x338 + x184 * x24 * x338,
            x18 * x194 * x334 + x18 * x195 * x333 + x194 * x21 * x333,
            x18 * x189 * x343 + x18 * x190 * x338 + x189 * x21 * x338,
            x17 * x351 * x378 + x18 * x184 * x346 + x183 * x21 * x346,
            x14 * x205 * x333 + x333 * x379 * x9 + x334 * x379,
            x14 * x194 * x343 + x194 * x380 * x9 + x195 * x380,
            x14 * x189 * x351 + x189 * x381 * x9 + x190 * x381,
            x101 * x356 + x14 * x184 * x353 + x353 * x378 * x9,
            x103 * x383 * x40 + x110 * x384 * x40 + x383 * x59,
            x111 * x24 * x384 + x111 * x29 * x382 + x112 * x24 * x382,
            x103 * x24 * x386 + x110 * x24 * x387 + x29 * x386,
            x138 * x18 * x384 + x138 * x21 * x382 + x143 * x18 * x382,
            x109 * x387 * x388 + x111 * x21 * x385 + x112 * x18 * x385,
            x103 * x388 * x389 + x110 * x21 * x389 + x17 * x390,
            x14 * x168 * x384 + x168 * x391 * x9 + x170 * x391,
            x138 * x14 * x387 + x138 * x392 * x9 + x143 * x392,
            x109 * x331 * x389 * x9 + x109 * x390 + x112 * x14 * x389,
            x103 * x394
            + x331
            * (
                x106 * x355
                + x19 * (2.0 * a * x393 - 4.0 * x295 - 4.0 * x296)
                + x2
                * (
                    3.0 * x299
                    + 3.0 * x300
                    + 3.0 * x303
                    + 3.0 * x348
                    + 3.0 * x349
                    + 3.0 * x350
                )
            )
            + x394 * x9,
        ]
    )


def kinetic3d_44(a, A, b, B):
    """Cartesian 3D (gg) kinetic energy integral.

    Generated code; DO NOT modify by hand!"""

    x0 = 2.0 * a
    x1 = 2.0 * b
    x2 = (x0 + x1) ** (-1.0)
    x3 = (a + b) ** (-1.0)
    x4 = -x3 * (a * A[0] + b * B[0])
    x5 = -x4 - A[0]
    x6 = -a
    x7 = x5**2
    x8 = 2.0 * a**2
    x9 = -x6 - x8 * (x2 + x7)
    x10 = -x4 - B[0]
    x11 = a * x3
    x12 = b * x11
    x13 = numpy.exp(-x12 * (A[0] - B[0]) ** 2)
    x14 = 1.77245385090552 * numpy.sqrt(x3)
    x15 = x13 * x14
    x16 = 2.0 * x15
    x17 = x10 * x16
    x18 = x10 * x15
    x19 = 4.0 * x12
    x20 = x2 * (x17 * x9 + x18 * x19)
    x21 = x15 * x2
    x22 = x21 * x9
    x23 = b * x3
    x24 = x0 * x23
    x25 = x18 * x24 + x18 * x9
    x26 = x10 * x25
    x27 = x10**2 * x15
    x28 = x21 + x27
    x29 = -x16
    x30 = x11 * (x1 * x28 + x29)
    x31 = x26 + x30
    x32 = x22 + x31
    x33 = x10 * x32
    x34 = x10 * x28
    x35 = 2.0 * x21
    x36 = x10 * x35
    x37 = x34 + x36
    x38 = x11 * (x1 * x37 - 3.0 * x18)
    x39 = x33 + x38
    x40 = x20 + x39
    x41 = x40 * x5
    x42 = 3.0 * x22
    x43 = x2 * (3.0 * x26 + 3.0 * x30 + x42)
    x44 = 3.0 * x21
    x45 = x2 * (3.0 * x27 + x44)
    x46 = x37 * x5
    x47 = x45 + x46
    x48 = x12 * x47
    x49 = x10 * x37
    x50 = x45 + x49
    x51 = 4.0 * x21
    x52 = x10 * x40 + x11 * (2.0 * b * x50 - 4.0 * x27 - x51)
    x53 = x2 * (4.0 * x41 + 5.0 * x43 + 8.0 * x48 + x52)
    x54 = 4.0 * x20
    x55 = x2 * (4.0 * x33 + 4.0 * x38 + x54)
    x56 = x43 + x52
    x57 = x5 * x56
    x58 = x10 * x21
    x59 = 8.0 * x58
    x60 = x2 * (4.0 * x34 + x59)
    x61 = x5 * x50
    x62 = x60 + x61
    x63 = x24 * x62 + x55 + x57
    x64 = x5 * x63
    x65 = x25 * x5
    x66 = x15 * x5
    x67 = x10 * x66
    x68 = x21 + x67
    x69 = x19 * x68 + x42 + 2.0 * x65
    x70 = x2 * (x31 + x69)
    x71 = x32 * x5
    x72 = x28 * x5
    x73 = x36 + x72
    x74 = x20 + x24 * x73 + x71
    x75 = x5 * x74
    x76 = x17 * x5 + x44
    x77 = x2 * (x27 + x76)
    x78 = x5 * x73
    x79 = x77 + x78
    x80 = x23 * (2.0 * a * x79 - 2.0 * x27 - x35)
    x81 = 3.0 * x70 + 3.0 * x75 + 3.0 * x80
    x82 = x2 * (2.0 * x41 + 2.0 * x43 + 4.0 * x48 + x81)
    x83 = 6.0 * x12
    x84 = x2 * (x39 + x54 + 3.0 * x71 + x73 * x83)
    x85 = x24 * x47 + x41 + x43
    x86 = x5 * x85
    x87 = 3.0 * x72
    x88 = x2 * (x34 + x59 + x87)
    x89 = x47 * x5
    x90 = x88 + x89
    x91 = x10 * x51
    x92 = x23 * (2.0 * a * x90 - 2.0 * x34 - x91)
    x93 = x84 + x86 + x92
    x94 = x5 * x93
    x95 = x2 * (5.0 * x45 + 4.0 * x46 + x49)
    x96 = x5 * x62
    x97 = x95 + x96
    x98 = 2.0 * x45
    x99 = x23 * (2.0 * a * x97 - 2.0 * x49 - x98)
    x100 = 3.0 * x77 + 3.0 * x78
    x101 = x2 * (x100 + 2.0 * x46 + x98)
    x102 = x5 * x90
    x103 = x101 + x102
    x104 = x23 * (2.0 * a * x103 - 3.0 * x45 - 3.0 * x46)
    x105 = x53 + x64 + x99
    x106 = 4.0 * x88 + 4.0 * x89
    x107 = x2 * (x106 + 2.0 * x60 + 2.0 * x61) + x5 * x97
    x108 = (
        x105 * x5
        + x2 * (x19 * x62 + 2.0 * x55 + 2.0 * x57 + 4.0 * x84 + 4.0 * x86 + 4.0 * x92)
        + x23 * (2.0 * a * x107 - 3.0 * x60 - 3.0 * x61)
    )
    x109 = x107 * x5 + x2 * (4.0 * x101 + 4.0 * x102 + 3.0 * x95 + 3.0 * x96)
    x110 = numpy.exp(-x12 * (A[1] - B[1]) ** 2)
    x111 = numpy.exp(-x12 * (A[2] - B[2]) ** 2)
    x112 = 3.14159265358979 * x111 * x3
    x113 = x110 * x112
    x114 = -x3 * (a * A[1] + b * B[1])
    x115 = -x114 - A[1]
    x116 = x115**2
    x117 = -x6 - x8 * (x116 + x2)
    x118 = x109 * x113
    x119 = -x3 * (a * A[2] + b * B[2])
    x120 = -x119 - A[2]
    x121 = x120**2
    x122 = -x6 - x8 * (x121 + x2)
    x123 = -x114 - B[1]
    x124 = x110 * x14
    x125 = x123 * x124
    x126 = x117 * x125 + x125 * x24
    x127 = x2 * (x18 + x66)
    x128 = x5 * x68
    x129 = x2 * (2.0 * x127 + 2.0 * x128 + 2.0 * x72 + x91)
    x130 = x5 * x79
    x131 = x103 * x5 + x2 * (3.0 * x129 + 3.0 * x130 + 3.0 * x88 + 3.0 * x89)
    x132 = x111 * x14
    x133 = x24 * x66 + x66 * x9
    x134 = x2 * (x133 + x25)
    x135 = x22 + x24 * x68 + x65
    x136 = x135 * x5
    x137 = x127 + x128
    x138 = x0 * x137 - x17
    x139 = x1 * x3
    x140 = x2 * (
        2.0 * x134 + 2.0 * x136 + x138 * x139 + x19 * x73 + 2.0 * x20 + 2.0 * x71
    )
    x141 = x70 + x75 + x80
    x142 = x141 * x5
    x143 = x129 + x130
    x144 = x23 * (2.0 * a * x143 - 6.0 * x58 - x87)
    x145 = x104 + x82 + x94
    x146 = x113 * (
        x145 * x5
        + x2 * (3.0 * x140 + 3.0 * x142 + 3.0 * x144 + 3.0 * x84 + 3.0 * x86 + 3.0 * x92)
        + x23 * (2.0 * a * x131 - x106)
    )
    x147 = x113 * x131
    x148 = -x119 - B[2]
    x149 = x132 * x148
    x150 = x122 * x149 + x149 * x24
    x151 = x124 * x2
    x152 = x117 * x151
    x153 = x123 * x126
    x154 = x123**2 * x124
    x155 = x151 + x154
    x156 = 2.0 * x124
    x157 = -x156
    x158 = x11 * (x1 * x155 + x157)
    x159 = x153 + x158
    x160 = x152 + x159
    x161 = x15 * x7
    x162 = x2 * (x161 + x76)
    x163 = x137 * x5
    x164 = x143 * x5 + x2 * (x100 + 2.0 * x162 + 2.0 * x163)
    x165 = x132 * x164
    x166 = x133 * x5
    x167 = x161 + x21
    x168 = x23 * (x0 * x167 + x29)
    x169 = x166 + x168
    x170 = x2 * (x169 + x69)
    x171 = x138 * x23
    x172 = x134 + x136 + x171
    x173 = x172 * x5
    x174 = x162 + x163
    x175 = 2.0 * a * x174 - x44 - 3.0 * x67
    x176 = x140 + x142 + x144
    x177 = (
        x176 * x5
        + x2 * (x139 * x175 + 2.0 * x170 + 2.0 * x173 + x81)
        + x23 * (2.0 * a * x164 - 4.0 * x77 - 4.0 * x78)
    )
    x178 = x113 * x148
    x179 = x132 * x2
    x180 = x122 * x179
    x181 = x148 * x150
    x182 = x132 * x148**2
    x183 = x179 + x182
    x184 = 2.0 * x132
    x185 = -x184
    x186 = x11 * (x1 * x183 + x185)
    x187 = x181 + x186
    x188 = x180 + x187
    x189 = x124 * x164
    x190 = x123 * x156
    x191 = x2 * (x117 * x190 + x125 * x19)
    x192 = x123 * x160
    x193 = x123 * x155
    x194 = 2.0 * x151
    x195 = x123 * x194
    x196 = x193 + x195
    x197 = x11 * (x1 * x196 - 3.0 * x125)
    x198 = x192 + x197
    x199 = x191 + x198
    x200 = x167 * x5 + x35 * x5
    x201 = x174 * x5 + x2 * (3.0 * x127 + 3.0 * x128 + x200)
    x202 = x132 * x201
    x203 = x169 + x22
    x204 = x2 * (x16 * x5 * x9 + x19 * x66) + x203 * x5 + x23 * (x0 * x200 - 3.0 * x66)
    x205 = x170 + x173 + x175 * x23
    x206 = (
        x2 * (3.0 * x134 + 3.0 * x136 + 3.0 * x171 + x204)
        + x205 * x5
        + x23 * (2.0 * a * x201 - 4.0 * x127 - 4.0 * x128)
    )
    x207 = x148 * x184
    x208 = x2 * (x122 * x207 + x149 * x19)
    x209 = x148 * x188
    x210 = x148 * x183
    x211 = 2.0 * x179
    x212 = x148 * x211
    x213 = x210 + x212
    x214 = x11 * (x1 * x213 - 3.0 * x149)
    x215 = x209 + x214
    x216 = x208 + x215
    x217 = x124 * x201
    x218 = 3.0 * x152
    x219 = x2 * (3.0 * x153 + 3.0 * x158 + x218)
    x220 = 3.0 * x151
    x221 = x2 * (3.0 * x154 + x220)
    x222 = x123 * x196
    x223 = x221 + x222
    x224 = 4.0 * x151
    x225 = x11 * (2.0 * b * x223 - 4.0 * x154 - x224) + x123 * x199
    x226 = x219 + x225
    x227 = x2 * (3.0 * x161 + x44) + x200 * x5
    x228 = x132 * x227
    x229 = (
        x2 * (3.0 * x166 + 3.0 * x168 + x42)
        + x204 * x5
        + x23 * (2.0 * a * x227 - 4.0 * x161 - x51)
    )
    x230 = 3.0 * x180
    x231 = x2 * (3.0 * x181 + 3.0 * x186 + x230)
    x232 = 3.0 * x179
    x233 = x2 * (3.0 * x182 + x232)
    x234 = x148 * x213
    x235 = x233 + x234
    x236 = 4.0 * x179
    x237 = x11 * (2.0 * b * x235 - 4.0 * x182 - x236) + x148 * x216
    x238 = x231 + x237
    x239 = x124 * x227
    x240 = x115 * x124
    x241 = x117 * x240 + x24 * x240
    x242 = x108 * x113
    x243 = x107 * x113
    x244 = x115 * x126
    x245 = x123 * x240
    x246 = x151 + x245
    x247 = x152 + x24 * x246 + x244
    x248 = x103 * x132
    x249 = x115 * x160
    x250 = x115 * x155
    x251 = x195 + x250
    x252 = x191 + x24 * x251 + x249
    x253 = x132 * x143
    x254 = x115 * x196
    x255 = x221 + x254
    x256 = x132 * x255
    x257 = x115 * x199
    x258 = x219 + x24 * x255 + x257
    x259 = x123 * x151
    x260 = 8.0 * x259
    x261 = x2 * (4.0 * x193 + x260)
    x262 = x115 * x223
    x263 = x261 + x262
    x264 = x132 * x263
    x265 = 4.0 * x191
    x266 = x2 * (4.0 * x192 + 4.0 * x197 + x265)
    x267 = x115 * x226
    x268 = x24 * x263 + x266 + x267
    x269 = x120 * x132
    x270 = x122 * x269 + x24 * x269
    x271 = x113 * x120
    x272 = x120 * x150
    x273 = x148 * x269
    x274 = x179 + x273
    x275 = x180 + x24 * x274 + x272
    x276 = x103 * x124
    x277 = x120 * x188
    x278 = x120 * x183
    x279 = x212 + x278
    x280 = x208 + x24 * x279 + x277
    x281 = x124 * x143
    x282 = x120 * x213
    x283 = x233 + x282
    x284 = x124 * x283
    x285 = x120 * x216
    x286 = x231 + x24 * x283 + x285
    x287 = x148 * x179
    x288 = 8.0 * x287
    x289 = x2 * (4.0 * x210 + x288)
    x290 = x120 * x235
    x291 = x289 + x290
    x292 = x124 * x291
    x293 = 4.0 * x208
    x294 = x2 * (4.0 * x209 + 4.0 * x214 + x293)
    x295 = x120 * x238
    x296 = x24 * x291 + x294 + x295
    x297 = x115 * x241
    x298 = x116 * x124
    x299 = x151 + x298
    x300 = x23 * (x0 * x299 + x157)
    x301 = x297 + x300
    x302 = x152 + x301
    x303 = x132 * x97
    x304 = x2 * (x125 + x240)
    x305 = x115 * x246
    x306 = x304 + x305
    x307 = x132 * x306
    x308 = x2 * (x126 + x241)
    x309 = x115 * x247
    x310 = x0 * x306 - x190
    x311 = x23 * x310
    x312 = x308 + x309 + x311
    x313 = x19 * x246 + x218 + 2.0 * x244
    x314 = x2 * (x159 + x313)
    x315 = x115 * x252
    x316 = x115 * x190 + x220
    x317 = x2 * (x154 + x316)
    x318 = x115 * x251
    x319 = x317 + x318
    x320 = x23 * (2.0 * a * x319 - 2.0 * x154 - x194)
    x321 = x314 + x315 + x320
    x322 = x132 * x79
    x323 = x2 * (x198 + 3.0 * x249 + x251 * x83 + x265)
    x324 = x115 * x258
    x325 = 3.0 * x250
    x326 = x2 * (x193 + x260 + x325)
    x327 = x115 * x255
    x328 = x326 + x327
    x329 = x123 * x224
    x330 = x23 * (2.0 * a * x328 - 2.0 * x193 - x329)
    x331 = x323 + x324 + x330
    x332 = x132 * x137
    x333 = x2 * (5.0 * x221 + x222 + 4.0 * x254)
    x334 = x115 * x263
    x335 = x333 + x334
    x336 = x132 * x335
    x337 = 8.0 * x12
    x338 = x2 * (5.0 * x219 + x225 + x255 * x337 + 4.0 * x257)
    x339 = x115 * x268
    x340 = 2.0 * x221
    x341 = x23 * (2.0 * a * x335 - 2.0 * x222 - x340)
    x342 = x338 + x339 + x341
    x343 = x120 * x270
    x344 = x121 * x132
    x345 = x179 + x344
    x346 = x23 * (x0 * x345 + x185)
    x347 = x343 + x346
    x348 = x180 + x347
    x349 = x124 * x97
    x350 = x2 * (x149 + x269)
    x351 = x120 * x274
    x352 = x350 + x351
    x353 = x124 * x352
    x354 = x2 * (x150 + x270)
    x355 = x120 * x275
    x356 = x0 * x352 - x207
    x357 = x23 * x356
    x358 = x354 + x355 + x357
    x359 = x19 * x274 + x230 + 2.0 * x272
    x360 = x2 * (x187 + x359)
    x361 = x120 * x280
    x362 = x120 * x207 + x232
    x363 = x2 * (x182 + x362)
    x364 = x120 * x279
    x365 = x363 + x364
    x366 = x23 * (2.0 * a * x365 - 2.0 * x182 - x211)
    x367 = x360 + x361 + x366
    x368 = x124 * x79
    x369 = x2 * (x215 + 3.0 * x277 + x279 * x83 + x293)
    x370 = x120 * x286
    x371 = 3.0 * x278
    x372 = x2 * (x210 + x288 + x371)
    x373 = x120 * x283
    x374 = x372 + x373
    x375 = x148 * x236
    x376 = x23 * (2.0 * a * x374 - 2.0 * x210 - x375)
    x377 = x369 + x370 + x376
    x378 = x124 * x137
    x379 = x2 * (5.0 * x233 + x234 + 4.0 * x282)
    x380 = x120 * x291
    x381 = x379 + x380
    x382 = x124 * x381
    x383 = x2 * (5.0 * x231 + x237 + x283 * x337 + 4.0 * x285)
    x384 = x120 * x296
    x385 = 2.0 * x233
    x386 = x23 * (2.0 * a * x381 - 2.0 * x234 - x385)
    x387 = x383 + x384 + x386
    x388 = x115 * x194 + x115 * x299
    x389 = (
        x115 * x302
        + x2 * (x115 * x117 * x156 + x19 * x240)
        + x23 * (x0 * x388 - 3.0 * x240)
    )
    x390 = x132 * x62
    x391 = x2 * (x301 + x313)
    x392 = x115 * x312
    x393 = x2 * (x298 + x316)
    x394 = x115 * x306
    x395 = x393 + x394
    x396 = 2.0 * a * x395 - x220 - 3.0 * x245
    x397 = x23 * x396 + x391 + x392
    x398 = x132 * x47
    x399 = x2 * (2.0 * x250 + 2.0 * x304 + 2.0 * x305 + x329)
    x400 = x115 * x319
    x401 = x399 + x400
    x402 = x132 * x401
    x403 = x2 * (
        x139 * x310 + x19 * x251 + 2.0 * x191 + 2.0 * x249 + 2.0 * x308 + 2.0 * x309
    )
    x404 = x115 * x321
    x405 = x23 * (2.0 * a * x401 - 6.0 * x259 - x325)
    x406 = x403 + x404 + x405
    x407 = 3.0 * x317 + 3.0 * x318
    x408 = x2 * (2.0 * x254 + x340 + x407)
    x409 = x115 * x328
    x410 = x408 + x409
    x411 = x132 * x410
    x412 = 3.0 * x314 + 3.0 * x315 + 3.0 * x320
    x413 = x2 * (x19 * x255 + 2.0 * x219 + 2.0 * x257 + x412)
    x414 = x115 * x331
    x415 = x23 * (2.0 * a * x410 - 3.0 * x221 - 3.0 * x254)
    x416 = x413 + x414 + x415
    x417 = 4.0 * x326 + 4.0 * x327
    x418 = x115 * x335 + x2 * (2.0 * x261 + 2.0 * x262 + x417)
    x419 = (
        x115 * x342
        + x2
        * (x19 * x263 + 2.0 * x266 + 2.0 * x267 + 4.0 * x323 + 4.0 * x324 + 4.0 * x330)
        + x23 * (2.0 * a * x418 - 3.0 * x261 - 3.0 * x262)
    )
    x420 = x112 * x13
    x421 = x419 * x420
    x422 = x420 * x5
    x423 = 3.14159265358979 * x110 * x13 * x3
    x424 = x423 * x5
    x425 = x120 * x211 + x120 * x345
    x426 = (
        x120 * x348
        + x2 * (x120 * x122 * x184 + x19 * x269)
        + x23 * (x0 * x425 - 3.0 * x269)
    )
    x427 = x124 * x62
    x428 = x2 * (x347 + x359)
    x429 = x120 * x358
    x430 = x2 * (x344 + x362)
    x431 = x120 * x352
    x432 = x430 + x431
    x433 = 2.0 * a * x432 - x232 - 3.0 * x273
    x434 = x23 * x433 + x428 + x429
    x435 = x124 * x47
    x436 = x2 * (2.0 * x278 + 2.0 * x350 + 2.0 * x351 + x375)
    x437 = x120 * x365
    x438 = x436 + x437
    x439 = x124 * x438
    x440 = x2 * (
        x139 * x356 + x19 * x279 + 2.0 * x208 + 2.0 * x277 + 2.0 * x354 + 2.0 * x355
    )
    x441 = x120 * x367
    x442 = x23 * (2.0 * a * x438 - 6.0 * x287 - x371)
    x443 = x440 + x441 + x442
    x444 = 3.0 * x363 + 3.0 * x364
    x445 = x2 * (2.0 * x282 + x385 + x444)
    x446 = x120 * x374
    x447 = x445 + x446
    x448 = x124 * x447
    x449 = 3.0 * x360 + 3.0 * x361 + 3.0 * x366
    x450 = x2 * (x19 * x283 + 2.0 * x231 + 2.0 * x285 + x449)
    x451 = x120 * x377
    x452 = x23 * (2.0 * a * x447 - 3.0 * x233 - 3.0 * x282)
    x453 = x450 + x451 + x452
    x454 = 4.0 * x372 + 4.0 * x373
    x455 = x120 * x381 + x2 * (2.0 * x289 + 2.0 * x290 + x454)
    x456 = (
        x120 * x387
        + x2
        * (x19 * x291 + 2.0 * x294 + 2.0 * x295 + 4.0 * x369 + 4.0 * x370 + 4.0 * x376)
        + x23 * (2.0 * a * x455 - 3.0 * x289 - 3.0 * x290)
    )
    x457 = x423 * x456
    x458 = x115 * x388 + x2 * (x220 + 3.0 * x298)
    x459 = x132 * x458
    x460 = (
        x115 * x389
        + x2 * (x218 + 3.0 * x297 + 3.0 * x300)
        + x23 * (2.0 * a * x458 - x224 - 4.0 * x298)
    )
    x461 = x115 * x395 + x2 * (3.0 * x304 + 3.0 * x305 + x388)
    x462 = x132 * x461
    x463 = (
        x115 * x397
        + x2 * (3.0 * x308 + 3.0 * x309 + 3.0 * x311 + x389)
        + x23 * (2.0 * a * x461 - 4.0 * x304 - 4.0 * x305)
    )
    x464 = x115 * x401 + x2 * (2.0 * x393 + 2.0 * x394 + x407)
    x465 = x132 * x464
    x466 = (
        x115 * x406
        + x2 * (x139 * x396 + 2.0 * x391 + 2.0 * x392 + x412)
        + x23 * (2.0 * a * x464 - 4.0 * x317 - 4.0 * x318)
    )
    x467 = x115 * x410 + x2 * (3.0 * x326 + 3.0 * x327 + 3.0 * x399 + 3.0 * x400)
    x468 = x420 * (
        x115 * x416
        + x2
        * (3.0 * x323 + 3.0 * x324 + 3.0 * x330 + 3.0 * x403 + 3.0 * x404 + 3.0 * x405)
        + x23 * (2.0 * a * x467 - x417)
    )
    x469 = x10 * x420
    x470 = x115 * x418 + x2 * (3.0 * x333 + 3.0 * x334 + 4.0 * x408 + 4.0 * x409)
    x471 = x420 * x470
    x472 = x420 * x9
    x473 = x15 * x464
    x474 = x15 * x461
    x475 = x15 * x458
    x476 = x15 * x410
    x477 = x15 * x401
    x478 = x15 * x283
    x479 = x15 * x291
    x480 = x15 * x335
    x481 = x15 * x352
    x482 = x15 * x319
    x483 = x15 * x306
    x484 = x15 * x381
    x485 = x115 * x423
    x486 = x15 * x263
    x487 = x15 * x255
    x488 = x15 * x438
    x489 = x15 * x447
    x490 = x120 * x425 + x2 * (x232 + 3.0 * x344)
    x491 = x124 * x490
    x492 = (
        x120 * x426
        + x2 * (x230 + 3.0 * x343 + 3.0 * x346)
        + x23 * (2.0 * a * x490 - x236 - 4.0 * x344)
    )
    x493 = x120 * x432 + x2 * (3.0 * x350 + 3.0 * x351 + x425)
    x494 = x124 * x493
    x495 = (
        x120 * x434
        + x2 * (3.0 * x354 + 3.0 * x355 + 3.0 * x357 + x426)
        + x23 * (2.0 * a * x493 - 4.0 * x350 - 4.0 * x351)
    )
    x496 = x120 * x438 + x2 * (2.0 * x430 + 2.0 * x431 + x444)
    x497 = x124 * x496
    x498 = (
        x120 * x443
        + x2 * (x139 * x433 + 2.0 * x428 + 2.0 * x429 + x449)
        + x23 * (2.0 * a * x496 - 4.0 * x363 - 4.0 * x364)
    )
    x499 = x10 * x423
    x500 = x120 * x447 + x2 * (3.0 * x372 + 3.0 * x373 + 3.0 * x436 + 3.0 * x437)
    x501 = x423 * (
        x120 * x453
        + x2
        * (3.0 * x369 + 3.0 * x370 + 3.0 * x376 + 3.0 * x440 + 3.0 * x441 + 3.0 * x442)
        + x23 * (2.0 * a * x500 - x454)
    )
    x502 = x15 * x490
    x503 = x15 * x493
    x504 = x15 * x496
    x505 = x120 * x455 + x2 * (3.0 * x379 + 3.0 * x380 + 4.0 * x445 + 4.0 * x446)
    x506 = x423 * x505

    # 225 item(s)
    return numpy.array(
        [
            x113
            * (
                x108 * x5
                + x2
                * (4.0 * x104 + 3.0 * x53 + 3.0 * x64 + 4.0 * x82 + 4.0 * x94 + 3.0 * x99)
                + x23 * (2.0 * a * x109 - 4.0 * x95 - 4.0 * x96)
            )
            + x117 * x118
            + x118 * x122,
            x122 * x123 * x147 + x123 * x146 + x126 * x131 * x132,
            x117 * x147 * x148 + x124 * x131 * x150 + x146 * x148,
            x122 * x155 * x165 + x132 * x155 * x177 + x160 * x165,
            x123 * x177 * x178 + x125 * x150 * x164 + x126 * x149 * x164,
            x117 * x183 * x189 + x124 * x177 * x183 + x188 * x189,
            x122 * x196 * x202 + x132 * x196 * x206 + x199 * x202,
            x149 * x155 * x206 + x149 * x160 * x201 + x150 * x155 * x201,
            x125 * x183 * x206 + x125 * x188 * x201 + x126 * x183 * x201,
            x117 * x213 * x217 + x124 * x206 * x213 + x216 * x217,
            x122 * x223 * x228 + x132 * x223 * x229 + x226 * x228,
            x149 * x196 * x229 + x149 * x199 * x227 + x150 * x196 * x227,
            x155 * x183 * x229 + x155 * x188 * x227 + x160 * x183 * x227,
            x125 * x213 * x229 + x125 * x216 * x227 + x126 * x213 * x227,
            x117 * x235 * x239 + x124 * x229 * x235 + x238 * x239,
            x107 * x132 * x241 + x115 * x122 * x243 + x115 * x242,
            x122 * x246 * x248 + x132 * x145 * x246 + x247 * x248,
            x103 * x149 * x241 + x103 * x150 * x240 + x115 * x145 * x178,
            x122 * x251 * x253 + x132 * x176 * x251 + x252 * x253,
            x143 * x149 * x247 + x143 * x150 * x246 + x149 * x176 * x246,
            x143 * x183 * x241 + x143 * x188 * x240 + x176 * x183 * x240,
            x122 * x174 * x256 + x132 * x174 * x258 + x205 * x256,
            x149 * x174 * x252 + x149 * x205 * x251 + x150 * x174 * x251,
            x174 * x183 * x247 + x174 * x188 * x246 + x183 * x205 * x246,
            x174 * x213 * x241 + x174 * x216 * x240 + x205 * x213 * x240,
            x122 * x200 * x264 + x132 * x200 * x268 + x204 * x264,
            x149 * x200 * x258 + x149 * x204 * x255 + x150 * x200 * x255,
            x183 * x200 * x252 + x183 * x204 * x251 + x188 * x200 * x251,
            x200 * x213 * x247 + x200 * x216 * x246 + x204 * x213 * x246,
            x200 * x235 * x241 + x200 * x238 * x240 + x204 * x235 * x240,
            x107 * x124 * x270 + x117 * x120 * x243 + x120 * x242,
            x103 * x125 * x270 + x103 * x126 * x269 + x123 * x145 * x271,
            x117 * x274 * x276 + x124 * x145 * x274 + x275 * x276,
            x143 * x155 * x270 + x143 * x160 * x269 + x155 * x176 * x269,
            x125 * x143 * x275 + x125 * x176 * x274 + x126 * x143 * x274,
            x117 * x279 * x281 + x124 * x176 * x279 + x280 * x281,
            x174 * x196 * x270 + x174 * x199 * x269 + x196 * x205 * x269,
            x155 * x174 * x275 + x155 * x205 * x274 + x160 * x174 * x274,
            x125 * x174 * x280 + x125 * x205 * x279 + x126 * x174 * x279,
            x117 * x174 * x284 + x124 * x174 * x286 + x205 * x284,
            x200 * x223 * x270 + x200 * x226 * x269 + x204 * x223 * x269,
            x196 * x200 * x275 + x196 * x204 * x274 + x199 * x200 * x274,
            x155 * x200 * x280 + x155 * x204 * x279 + x160 * x200 * x279,
            x125 * x200 * x286 + x125 * x204 * x283 + x126 * x200 * x283,
            x117 * x200 * x292 + x124 * x200 * x296 + x204 * x292,
            x105 * x132 * x299 + x122 * x299 * x303 + x302 * x303,
            x122 * x307 * x90 + x132 * x312 * x90 + x307 * x93,
            x149 * x299 * x93 + x149 * x302 * x90 + x150 * x299 * x90,
            x122 * x319 * x322 + x132 * x141 * x319 + x321 * x322,
            x141 * x149 * x306 + x149 * x312 * x79 + x150 * x306 * x79,
            x141 * x183 * x299 + x183 * x302 * x79 + x188 * x299 * x79,
            x122 * x328 * x332 + x132 * x172 * x328 + x331 * x332,
            x137 * x149 * x321 + x137 * x150 * x319 + x149 * x172 * x319,
            x137 * x183 * x312 + x137 * x188 * x306 + x172 * x183 * x306,
            x137 * x213 * x302 + x137 * x216 * x299 + x172 * x213 * x299,
            x122 * x167 * x336 + x132 * x167 * x342 + x203 * x336,
            x149 * x167 * x331 + x149 * x203 * x328 + x150 * x167 * x328,
            x167 * x183 * x321 + x167 * x188 * x319 + x183 * x203 * x319,
            x167 * x213 * x312 + x167 * x216 * x306 + x203 * x213 * x306,
            x167 * x235 * x302 + x167 * x238 * x299 + x203 * x235 * x299,
            x105 * x115 * x271 + x240 * x270 * x97 + x241 * x269 * x97,
            x246 * x269 * x93 + x246 * x270 * x90 + x247 * x269 * x90,
            x240 * x274 * x93 + x240 * x275 * x90 + x241 * x274 * x90,
            x141 * x251 * x269 + x251 * x270 * x79 + x252 * x269 * x79,
            x141 * x246 * x274 + x246 * x275 * x79 + x247 * x274 * x79,
            x141 * x240 * x279 + x240 * x280 * x79 + x241 * x279 * x79,
            x137 * x255 * x270 + x137 * x258 * x269 + x172 * x255 * x269,
            x137 * x251 * x275 + x137 * x252 * x274 + x172 * x251 * x274,
            x137 * x246 * x280 + x137 * x247 * x279 + x172 * x246 * x279,
            x137 * x240 * x286 + x137 * x241 * x283 + x172 * x240 * x283,
            x167 * x263 * x270 + x167 * x268 * x269 + x203 * x263 * x269,
            x167 * x255 * x275 + x167 * x258 * x274 + x203 * x255 * x274,
            x167 * x251 * x280 + x167 * x252 * x279 + x203 * x251 * x279,
            x167 * x246 * x286 + x167 * x247 * x283 + x203 * x246 * x283,
            x167 * x240 * x296 + x167 * x241 * x291 + x203 * x240 * x291,
            x105 * x124 * x345 + x117 * x345 * x349 + x348 * x349,
            x125 * x345 * x93 + x125 * x348 * x90 + x126 * x345 * x90,
            x117 * x353 * x90 + x124 * x358 * x90 + x353 * x93,
            x141 * x155 * x345 + x155 * x348 * x79 + x160 * x345 * x79,
            x125 * x141 * x352 + x125 * x358 * x79 + x126 * x352 * x79,
            x117 * x365 * x368 + x124 * x141 * x365 + x367 * x368,
            x137 * x196 * x348 + x137 * x199 * x345 + x172 * x196 * x345,
            x137 * x155 * x358 + x137 * x160 * x352 + x155 * x172 * x352,
            x125 * x137 * x367 + x125 * x172 * x365 + x126 * x137 * x365,
            x117 * x374 * x378 + x124 * x172 * x374 + x377 * x378,
            x167 * x223 * x348 + x167 * x226 * x345 + x203 * x223 * x345,
            x167 * x196 * x358 + x167 * x199 * x352 + x196 * x203 * x352,
            x155 * x167 * x367 + x155 * x203 * x365 + x160 * x167 * x365,
            x125 * x167 * x377 + x125 * x203 * x374 + x126 * x167 * x374,
            x117 * x167 * x382 + x124 * x167 * x387 + x203 * x382,
            x122 * x388 * x390 + x132 * x388 * x63 + x389 * x390,
            x122 * x395 * x398 + x132 * x395 * x85 + x397 * x398,
            x149 * x388 * x85 + x149 * x389 * x47 + x150 * x388 * x47,
            x122 * x402 * x73 + x132 * x406 * x73 + x402 * x74,
            x149 * x395 * x74 + x149 * x397 * x73 + x150 * x395 * x73,
            x183 * x388 * x74 + x183 * x389 * x73 + x188 * x388 * x73,
            x122 * x411 * x68 + x132 * x416 * x68 + x135 * x411,
            x135 * x149 * x401 + x149 * x406 * x68 + x150 * x401 * x68,
            x135 * x183 * x395 + x183 * x397 * x68 + x188 * x395 * x68,
            x135 * x213 * x388 + x213 * x389 * x68 + x216 * x388 * x68,
            x122 * x418 * x422 + x132 * x133 * x418 + x421 * x5,
            x133 * x149 * x410 + x148 * x416 * x422 + x150 * x410 * x66,
            x133 * x183 * x401 + x183 * x406 * x66 + x188 * x401 * x66,
            x133 * x213 * x395 + x213 * x397 * x66 + x216 * x395 * x66,
            x133 * x235 * x388 + x235 * x389 * x66 + x238 * x388 * x66,
            x269 * x299 * x63 + x269 * x302 * x62 + x270 * x299 * x62,
            x269 * x306 * x85 + x269 * x312 * x47 + x270 * x306 * x47,
            x274 * x299 * x85 + x274 * x302 * x47 + x275 * x299 * x47,
            x269 * x319 * x74 + x269 * x321 * x73 + x270 * x319 * x73,
            x274 * x306 * x74 + x274 * x312 * x73 + x275 * x306 * x73,
            x279 * x299 * x74 + x279 * x302 * x73 + x280 * x299 * x73,
            x135 * x269 * x328 + x269 * x331 * x68 + x270 * x328 * x68,
            x135 * x274 * x319 + x274 * x321 * x68 + x275 * x319 * x68,
            x135 * x279 * x306 + x279 * x312 * x68 + x280 * x306 * x68,
            x135 * x283 * x299 + x283 * x302 * x68 + x286 * x299 * x68,
            x120 * x342 * x422 + x133 * x269 * x335 + x270 * x335 * x66,
            x133 * x274 * x328 + x274 * x331 * x66 + x275 * x328 * x66,
            x133 * x279 * x319 + x279 * x321 * x66 + x280 * x319 * x66,
            x133 * x283 * x306 + x283 * x312 * x66 + x286 * x306 * x66,
            x133 * x291 * x299 + x291 * x302 * x66 + x296 * x299 * x66,
            x240 * x345 * x63 + x240 * x348 * x62 + x241 * x345 * x62,
            x246 * x345 * x85 + x246 * x348 * x47 + x247 * x345 * x47,
            x240 * x352 * x85 + x240 * x358 * x47 + x241 * x352 * x47,
            x251 * x345 * x74 + x251 * x348 * x73 + x252 * x345 * x73,
            x246 * x352 * x74 + x246 * x358 * x73 + x247 * x352 * x73,
            x240 * x365 * x74 + x240 * x367 * x73 + x241 * x365 * x73,
            x135 * x255 * x345 + x255 * x348 * x68 + x258 * x345 * x68,
            x135 * x251 * x352 + x251 * x358 * x68 + x252 * x352 * x68,
            x135 * x246 * x365 + x246 * x367 * x68 + x247 * x365 * x68,
            x135 * x240 * x374 + x240 * x377 * x68 + x241 * x374 * x68,
            x133 * x263 * x345 + x263 * x348 * x66 + x268 * x345 * x66,
            x133 * x255 * x352 + x255 * x358 * x66 + x258 * x352 * x66,
            x133 * x251 * x365 + x251 * x367 * x66 + x252 * x365 * x66,
            x133 * x246 * x374 + x246 * x377 * x66 + x247 * x374 * x66,
            x115 * x387 * x424 + x133 * x240 * x381 + x241 * x381 * x66,
            x117 * x425 * x427 + x124 * x425 * x63 + x426 * x427,
            x125 * x425 * x85 + x125 * x426 * x47 + x126 * x425 * x47,
            x117 * x432 * x435 + x124 * x432 * x85 + x434 * x435,
            x155 * x425 * x74 + x155 * x426 * x73 + x160 * x425 * x73,
            x125 * x432 * x74 + x125 * x434 * x73 + x126 * x432 * x73,
            x117 * x439 * x73 + x124 * x443 * x73 + x439 * x74,
            x135 * x196 * x425 + x196 * x426 * x68 + x199 * x425 * x68,
            x135 * x155 * x432 + x155 * x434 * x68 + x160 * x432 * x68,
            x125 * x135 * x438 + x125 * x443 * x68 + x126 * x438 * x68,
            x117 * x448 * x68 + x124 * x453 * x68 + x135 * x448,
            x133 * x223 * x425 + x223 * x426 * x66 + x226 * x425 * x66,
            x133 * x196 * x432 + x196 * x434 * x66 + x199 * x432 * x66,
            x133 * x155 * x438 + x155 * x443 * x66 + x160 * x438 * x66,
            x123 * x424 * x453 + x125 * x133 * x447 + x126 * x447 * x66,
            x117 * x424 * x455 + x124 * x133 * x455 + x457 * x5,
            x122 * x459 * x50 + x132 * x460 * x50 + x459 * x56,
            x122 * x37 * x462 + x132 * x37 * x463 + x40 * x462,
            x149 * x37 * x460 + x149 * x40 * x458 + x150 * x37 * x458,
            x122 * x28 * x465 + x132 * x28 * x466 + x32 * x465,
            x149 * x28 * x463 + x149 * x32 * x461 + x150 * x28 * x461,
            x183 * x28 * x460 + x183 * x32 * x458 + x188 * x28 * x458,
            x10 * x468 + x122 * x467 * x469 + x132 * x25 * x467,
            x148 * x466 * x469 + x149 * x25 * x464 + x150 * x18 * x464,
            x18 * x183 * x463 + x18 * x188 * x461 + x183 * x25 * x461,
            x18 * x213 * x460 + x18 * x216 * x458 + x213 * x25 * x458,
            x122 * x471
            + x420
            * (
                x115 * x419
                + x2
                * (
                    3.0 * x338
                    + 3.0 * x339
                    + 3.0 * x341
                    + 4.0 * x413
                    + 4.0 * x414
                    + 4.0 * x415
                )
                + x23 * (2.0 * a * x470 - 4.0 * x333 - 4.0 * x334)
            )
            + x471 * x9,
            x148 * x467 * x472 + x148 * x468 + x15 * x150 * x467,
            x15 * x183 * x466 + x183 * x473 * x9 + x188 * x473,
            x15 * x213 * x463 + x213 * x474 * x9 + x216 * x474,
            x15 * x235 * x460 + x235 * x475 * x9 + x238 * x475,
            x269 * x388 * x56 + x269 * x389 * x50 + x270 * x388 * x50,
            x269 * x37 * x397 + x269 * x395 * x40 + x270 * x37 * x395,
            x274 * x37 * x389 + x274 * x388 * x40 + x275 * x37 * x388,
            x269 * x28 * x406 + x269 * x32 * x401 + x270 * x28 * x401,
            x274 * x28 * x397 + x274 * x32 * x395 + x275 * x28 * x395,
            x279 * x28 * x389 + x279 * x32 * x388 + x28 * x280 * x388,
            x120 * x416 * x469 + x18 * x270 * x410 + x25 * x269 * x410,
            x18 * x274 * x406 + x18 * x275 * x401 + x25 * x274 * x401,
            x18 * x279 * x397 + x18 * x280 * x395 + x25 * x279 * x395,
            x18 * x283 * x389 + x18 * x286 * x388 + x25 * x283 * x388,
            x120 * x418 * x472 + x120 * x421 + x15 * x270 * x418,
            x15 * x274 * x416 + x274 * x476 * x9 + x275 * x476,
            x15 * x279 * x406 + x279 * x477 * x9 + x280 * x477,
            x15 * x286 * x395 + x395 * x478 * x9 + x397 * x478,
            x15 * x296 * x388 + x388 * x479 * x9 + x389 * x479,
            x299 * x345 * x56 + x299 * x348 * x50 + x302 * x345 * x50,
            x306 * x345 * x40 + x306 * x348 * x37 + x312 * x345 * x37,
            x299 * x352 * x40 + x299 * x358 * x37 + x302 * x352 * x37,
            x28 * x319 * x348 + x28 * x321 * x345 + x319 * x32 * x345,
            x28 * x306 * x358 + x28 * x312 * x352 + x306 * x32 * x352,
            x28 * x299 * x367 + x28 * x302 * x365 + x299 * x32 * x365,
            x18 * x328 * x348 + x18 * x331 * x345 + x25 * x328 * x345,
            x18 * x319 * x358 + x18 * x321 * x352 + x25 * x319 * x352,
            x18 * x306 * x367 + x18 * x312 * x365 + x25 * x306 * x365,
            x18 * x299 * x377 + x18 * x302 * x374 + x25 * x299 * x374,
            x15 * x342 * x345 + x345 * x480 * x9 + x348 * x480,
            x15 * x328 * x358 + x328 * x481 * x9 + x331 * x481,
            x15 * x321 * x365 + x365 * x482 * x9 + x367 * x482,
            x15 * x312 * x374 + x374 * x483 * x9 + x377 * x483,
            x15 * x299 * x387 + x299 * x484 * x9 + x302 * x484,
            x240 * x425 * x56 + x240 * x426 * x50 + x241 * x425 * x50,
            x246 * x37 * x426 + x246 * x40 * x425 + x247 * x37 * x425,
            x240 * x37 * x434 + x240 * x40 * x432 + x241 * x37 * x432,
            x251 * x28 * x426 + x251 * x32 * x425 + x252 * x28 * x425,
            x246 * x28 * x434 + x246 * x32 * x432 + x247 * x28 * x432,
            x240 * x28 * x443 + x240 * x32 * x438 + x241 * x28 * x438,
            x18 * x255 * x426 + x18 * x258 * x425 + x25 * x255 * x425,
            x18 * x251 * x434 + x18 * x252 * x432 + x25 * x251 * x432,
            x18 * x246 * x443 + x18 * x247 * x438 + x246 * x25 * x438,
            x10 * x453 * x485 + x18 * x241 * x447 + x240 * x25 * x447,
            x15 * x268 * x425 + x425 * x486 * x9 + x426 * x486,
            x15 * x258 * x432 + x432 * x487 * x9 + x434 * x487,
            x15 * x251 * x443 + x251 * x488 * x9 + x252 * x488,
            x15 * x246 * x453 + x246 * x489 * x9 + x247 * x489,
            x115 * x457 + x15 * x241 * x455 + x455 * x485 * x9,
            x117 * x491 * x50 + x124 * x492 * x50 + x491 * x56,
            x125 * x37 * x492 + x125 * x40 * x490 + x126 * x37 * x490,
            x117 * x37 * x494 + x124 * x37 * x495 + x40 * x494,
            x155 * x28 * x492 + x155 * x32 * x490 + x160 * x28 * x490,
            x125 * x28 * x495 + x125 * x32 * x493 + x126 * x28 * x493,
            x117 * x28 * x497 + x124 * x28 * x498 + x32 * x497,
            x18 * x196 * x492 + x18 * x199 * x490 + x196 * x25 * x490,
            x155 * x18 * x495 + x155 * x25 * x493 + x160 * x18 * x493,
            x123 * x498 * x499 + x125 * x25 * x496 + x126 * x18 * x496,
            x10 * x501 + x117 * x499 * x500 + x124 * x25 * x500,
            x15 * x223 * x492 + x223 * x502 * x9 + x226 * x502,
            x15 * x196 * x495 + x196 * x503 * x9 + x199 * x503,
            x15 * x155 * x498 + x155 * x504 * x9 + x160 * x504,
            x123 * x423 * x500 * x9 + x123 * x501 + x126 * x15 * x500,
            x117 * x506
            + x423
            * (
                x120 * x456
                + x2
                * (
                    3.0 * x383
                    + 3.0 * x384
                    + 3.0 * x386
                    + 4.0 * x450
                    + 4.0 * x451
                    + 4.0 * x452
                )
                + x23 * (2.0 * a * x505 - 4.0 * x379 - 4.0 * x380)
            )
            + x506 * x9,
        ]
    )
