import numpy

"""

        Quadrupole integrals contain the upper triangular part of the symmetric
        3x3 quadrupole matrix.

        / xx xy xz \
        |    yy yz |
        \       zz /

"""


def quadrupole3d_00(a, A, b, B, C):
    """Cartesian 3D (ss) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (a + b) ** (-1.0)
    x1 = a * b * x0
    x2 = numpy.exp(-x1 * (A[1] - B[1]) ** 2)
    x3 = x0 * (a * A[0] + b * B[0]) - C[0]
    x4 = numpy.exp(-x1 * (A[0] - B[0]) ** 2)
    x5 = numpy.sqrt(x0)
    x6 = 1.77245385090552 * x5
    x7 = x4 * x6
    x8 = (2.0 * a + 2.0 * b) ** (-1.0)
    x9 = numpy.exp(-x1 * (A[2] - B[2]) ** 2)
    x10 = 3.14159265358979 * x0 * x9
    x11 = x0 * (a * A[1] + b * B[1]) - C[1]
    x12 = 5.56832799683171
    x13 = x0 * x2 * x4
    x14 = x12 * x13 * x3 * x5 * x9
    x15 = x0 * (a * A[2] + b * B[2]) - C[2]
    x16 = x2 * x6
    x17 = x6 * x9

    # 6 item(s)
    return numpy.array(
        [
            x10 * x2 * (x3**2 * x7 + x7 * x8),
            x11 * x14,
            x14 * x15,
            x10 * x4 * (x11**2 * x16 + x16 * x8),
            x11 * x12 * x13 * x15 * x5 * x9,
            3.14159265358979 * x13 * (x15**2 * x17 + x17 * x8),
        ]
    )


def quadrupole3d_01(a, A, b, B, C):
    """Cartesian 3D (sp) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (a + b) ** (-1.0)
    x1 = -x0 * (a * A[0] + b * B[0])
    x2 = -x1 - B[0]
    x3 = -x1 - C[0]
    x4 = a * b * x0
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = numpy.sqrt(x0)
    x7 = 1.77245385090552 * x6
    x8 = x5 * x7
    x9 = (2.0 * a + 2.0 * b) ** (-1.0)
    x10 = x8 * x9
    x11 = x10 + x3**2 * x8
    x12 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x13 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x14 = 3.14159265358979 * x0 * x13
    x15 = x12 * x14
    x16 = -x0 * (a * A[1] + b * B[1])
    x17 = -x16 - B[1]
    x18 = x11 * x15
    x19 = -x0 * (a * A[2] + b * B[2])
    x20 = -x19 - B[2]
    x21 = -x16 - C[1]
    x22 = x15 * (x10 + x2 * x3 * x8)
    x23 = x7 * x9
    x24 = x12 * x23
    x25 = x12 * x7
    x26 = x14 * x5
    x27 = x26 * (x17 * x21 * x25 + x24)
    x28 = 5.56832799683171
    x29 = x0 * x12 * x5
    x30 = x13 * x28 * x29 * x3 * x6
    x31 = -x19 - C[2]
    x32 = x13 * x23
    x33 = x13 * x7
    x34 = 3.14159265358979 * x29
    x35 = x34 * (x20 * x31 * x33 + x32)
    x36 = x21**2 * x25 + x24
    x37 = x26 * x36
    x38 = x31**2 * x33 + x32
    x39 = x34 * x38

    # 18 item(s)
    return numpy.array(
        [
            x15 * (2.0 * x10 * x3 + x11 * x2),
            x17 * x18,
            x18 * x20,
            x21 * x22,
            x27 * x3,
            x20 * x21 * x30,
            x22 * x31,
            x17 * x30 * x31,
            x3 * x35,
            x2 * x37,
            x26 * (x17 * x36 + 2.0 * x21 * x24),
            x20 * x37,
            x13 * x2 * x21 * x28 * x29 * x31 * x6,
            x27 * x31,
            x21 * x35,
            x2 * x39,
            x17 * x39,
            x34 * (x20 * x38 + 2.0 * x31 * x32),
        ]
    )


def quadrupole3d_02(a, A, b, B, C):
    """Cartesian 3D (sd) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3**2 * x7
    x9 = x0 * x7
    x10 = -x2 - B[0]
    x11 = x10 * x7
    x12 = x11 * x3
    x13 = x8 + x9
    x14 = x10 * x13 + 2.0 * x3 * x9
    x15 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x16 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x17 = 3.14159265358979 * x1 * x16
    x18 = x15 * x17
    x19 = -x1 * (a * A[1] + b * B[1])
    x20 = -x19 - B[1]
    x21 = x14 * x18
    x22 = -x1 * (a * A[2] + b * B[2])
    x23 = -x22 - B[2]
    x24 = x15 * x6
    x25 = x0 * x24
    x26 = x20**2 * x24 + x25
    x27 = x16 * x6
    x28 = x18 * x23
    x29 = x0 * x27
    x30 = x23**2 * x27 + x29
    x31 = -x19 - C[1]
    x32 = x12 + x9
    x33 = x18 * (x0 * (x11 + x3 * x7) + x10 * x32)
    x34 = x20 * x24
    x35 = x31 * x34
    x36 = x25 + x35
    x37 = x17 * x5
    x38 = x37 * (x0 * (x24 * x31 + x34) + x20 * x36)
    x39 = x3 * x37
    x40 = 3.14159265358979 * x1 * x15 * x5
    x41 = x3 * x40
    x42 = -x22 - C[2]
    x43 = x18 * x42
    x44 = x23 * x27
    x45 = x42 * x44
    x46 = x29 + x45
    x47 = x40 * (x0 * (x27 * x42 + x44) + x23 * x46)
    x48 = x24 * x31**2
    x49 = x25 + x48
    x50 = x10**2 * x7 + x9
    x51 = x20 * x49 + 2.0 * x25 * x31
    x52 = x37 * x51
    x53 = x10 * x37
    x54 = x10 * x40
    x55 = x27 * x42**2
    x56 = x29 + x55
    x57 = x23 * x56 + 2.0 * x29 * x42
    x58 = x40 * x57

    # 36 item(s)
    return numpy.array(
        [
            x18 * (x0 * (2.0 * x12 + x8 + 3.0 * x9) + x10 * x14),
            x20 * x21,
            x21 * x23,
            x13 * x26 * x27,
            x13 * x20 * x28,
            x13 * x24 * x30,
            x31 * x33,
            x27 * x32 * x36,
            x28 * x31 * x32,
            x3 * x38,
            x23 * x36 * x39,
            x30 * x31 * x41,
            x33 * x42,
            x20 * x32 * x43,
            x24 * x32 * x46,
            x26 * x39 * x42,
            x20 * x41 * x46,
            x3 * x47,
            x27 * x49 * x50,
            x10 * x52,
            x23 * x49 * x53,
            x37 * (x0 * (3.0 * x25 + 2.0 * x35 + x48) + x20 * x51),
            x23 * x52,
            x30 * x49 * x7,
            x31 * x43 * x50,
            x36 * x42 * x53,
            x31 * x46 * x54,
            x38 * x42,
            x36 * x46 * x7,
            x31 * x47,
            x24 * x50 * x56,
            x20 * x54 * x56,
            x10 * x58,
            x26 * x56 * x7,
            x20 * x58,
            x40 * (x0 * (3.0 * x29 + 2.0 * x45 + x55) + x23 * x57),
        ]
    )


def quadrupole3d_03(a, A, b, B, C):
    """Cartesian 3D (sf) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = 1.77245385090552 * numpy.sqrt(x1)
    x3 = -x1 * (a * A[0] + b * B[0])
    x4 = -x3 - B[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = x4 * x6
    x8 = x2 * x7
    x9 = -x3 - C[0]
    x10 = x2 * x6
    x11 = x10 * x9
    x12 = x0 * (x11 + x8)
    x13 = x10 * x9**2
    x14 = x0 * x10
    x15 = x13 + x14
    x16 = x15 * x4
    x17 = x8 * x9
    x18 = x14 + x17
    x19 = x18 * x4
    x20 = x0 * x11
    x21 = 3.0 * x14 + 2.0 * x17
    x22 = x16 + 2.0 * x20
    x23 = x0 * (x13 + x21) + x22 * x4
    x24 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x25 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x26 = 3.14159265358979 * x1 * x25
    x27 = x24 * x26
    x28 = -x1 * (a * A[1] + b * B[1])
    x29 = -x28 - B[1]
    x30 = x23 * x27
    x31 = -x1 * (a * A[2] + b * B[2])
    x32 = -x31 - B[2]
    x33 = x2 * x24
    x34 = x29**2 * x33
    x35 = x0 * x33
    x36 = x34 + x35
    x37 = x2 * x25
    x38 = x27 * x32
    x39 = x32**2 * x37
    x40 = x0 * x37
    x41 = x39 + x40
    x42 = 2.0 * x35
    x43 = x29 * x36 + x29 * x42
    x44 = x32 * x37
    x45 = x29 * x33
    x46 = 2.0 * x40
    x47 = x32 * x41 + x32 * x46
    x48 = -x28 - C[1]
    x49 = x10 * x4**2
    x50 = x12 + x19
    x51 = x27 * (x0 * (x21 + x49) + x4 * x50)
    x52 = x45 * x48
    x53 = x35 + x52
    x54 = x33 * x48
    x55 = x0 * (x45 + x54)
    x56 = x29 * x53
    x57 = x55 + x56
    x58 = 3.0 * x35 + 2.0 * x52
    x59 = x26 * x6
    x60 = x59 * (x0 * (x34 + x58) + x29 * x57)
    x61 = x32 * x59
    x62 = 3.14159265358979 * x1 * x24
    x63 = x6 * x62
    x64 = -x31 - C[2]
    x65 = x27 * x64
    x66 = x44 * x64
    x67 = x40 + x66
    x68 = x37 * x64
    x69 = x0 * (x44 + x68)
    x70 = x32 * x67
    x71 = x69 + x70
    x72 = x29 * x63
    x73 = 3.0 * x40 + 2.0 * x66
    x74 = x63 * (x0 * (x39 + x73) + x32 * x71)
    x75 = x33 * x48**2
    x76 = x35 + x75
    x77 = x14 + x49
    x78 = 2.0 * x0 * x8 + x4 * x77
    x79 = x29 * x76
    x80 = x42 * x48 + x79
    x81 = x0 * (x58 + x75) + x29 * x80
    x82 = x26 * x7
    x83 = x62 * x7
    x84 = x37 * x64**2
    x85 = x40 + x84
    x86 = x32 * x85
    x87 = x46 * x64 + x86
    x88 = x0 * (x73 + x84) + x32 * x87

    # 60 item(s)
    return numpy.array(
        [
            x27 * (x0 * (2.0 * x12 + 2.0 * x16 + 2.0 * x19 + 4.0 * x20) + x23 * x4),
            x29 * x30,
            x30 * x32,
            x22 * x36 * x37,
            x22 * x29 * x38,
            x22 * x33 * x41,
            x15 * x37 * x43,
            x15 * x36 * x44,
            x15 * x41 * x45,
            x15 * x33 * x47,
            x48 * x51,
            x37 * x50 * x53,
            x38 * x48 * x50,
            x18 * x37 * x57,
            x18 * x44 * x53,
            x18 * x41 * x54,
            x60 * x9,
            x57 * x61 * x9,
            x11 * x41 * x53,
            x47 * x48 * x63 * x9,
            x51 * x64,
            x29 * x50 * x65,
            x33 * x50 * x67,
            x18 * x36 * x68,
            x18 * x45 * x67,
            x18 * x33 * x71,
            x43 * x59 * x64 * x9,
            x11 * x36 * x67,
            x71 * x72 * x9,
            x74 * x9,
            x37 * x76 * x78,
            x37 * x77 * x80,
            x44 * x76 * x77,
            x81 * x82,
            x32 * x80 * x82,
            x41 * x76 * x8,
            x59
            * (x0 * (4.0 * x35 * x48 + 2.0 * x55 + 2.0 * x56 + 2.0 * x79) + x29 * x81),
            x61 * x81,
            x10 * x41 * x80,
            x10 * x47 * x76,
            x48 * x65 * x78,
            x53 * x68 * x77,
            x54 * x67 * x77,
            x57 * x64 * x82,
            x53 * x67 * x8,
            x48 * x71 * x83,
            x60 * x64,
            x10 * x57 * x67,
            x10 * x53 * x71,
            x48 * x74,
            x33 * x78 * x85,
            x45 * x77 * x85,
            x33 * x77 * x87,
            x36 * x8 * x85,
            x29 * x83 * x87,
            x83 * x88,
            x10 * x43 * x85,
            x10 * x36 * x87,
            x72 * x88,
            x63
            * (x0 * (4.0 * x40 * x64 + 2.0 * x69 + 2.0 * x70 + 2.0 * x86) + x32 * x88),
        ]
    )


def quadrupole3d_04(a, A, b, B, C):
    """Cartesian 3D (sg) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3**2 * x7
    x9 = x0 * x7
    x10 = 3.0 * x9
    x11 = -x2 - C[0]
    x12 = x3 * x7
    x13 = x11 * x12
    x14 = x10 + 2.0 * x13
    x15 = x0 * (x14 + x8)
    x16 = x11 * x7
    x17 = x0 * (x12 + x16)
    x18 = x13 + x9
    x19 = x18 * x3
    x20 = x17 + x19
    x21 = x20 * x3
    x22 = x11**2 * x7
    x23 = x0 * (x14 + x22)
    x24 = x22 + x9
    x25 = x24 * x3
    x26 = x0 * x16
    x27 = x25 + 2.0 * x26
    x28 = x27 * x3
    x29 = x23 + x28
    x30 = x0 * (2.0 * x17 + 2.0 * x19 + 2.0 * x25 + 4.0 * x26) + x29 * x3
    x31 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x32 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x33 = 3.14159265358979 * x1 * x32
    x34 = x31 * x33
    x35 = -x1 * (a * A[1] + b * B[1])
    x36 = -x35 - B[1]
    x37 = x30 * x34
    x38 = -x1 * (a * A[2] + b * B[2])
    x39 = -x38 - B[2]
    x40 = x31 * x6
    x41 = x36**2 * x40
    x42 = x0 * x40
    x43 = x41 + x42
    x44 = x32 * x6
    x45 = x34 * x39
    x46 = x39**2 * x44
    x47 = x0 * x44
    x48 = x46 + x47
    x49 = 2.0 * x42
    x50 = x36 * x43 + x36 * x49
    x51 = x39 * x44
    x52 = x36 * x40
    x53 = 2.0 * x47
    x54 = x39 * x48 + x39 * x53
    x55 = 3.0 * x42
    x56 = x0 * (3.0 * x41 + x55) + x36 * x50
    x57 = 3.0 * x47
    x58 = x0 * (3.0 * x46 + x57) + x39 * x54
    x59 = -x35 - C[1]
    x60 = x8 + x9
    x61 = 2.0 * x0 * x12 + x3 * x60
    x62 = x15 + x21
    x63 = x34 * (x0 * (3.0 * x17 + 3.0 * x19 + x61) + x3 * x62)
    x64 = x52 * x59
    x65 = x42 + x64
    x66 = x40 * x59
    x67 = x0 * (x52 + x66)
    x68 = x36 * x65
    x69 = x67 + x68
    x70 = x55 + 2.0 * x64
    x71 = x0 * (x41 + x70)
    x72 = x36 * x69
    x73 = x71 + x72
    x74 = x33 * x5
    x75 = x74 * (x0 * (x50 + 3.0 * x67 + 3.0 * x68) + x36 * x73)
    x76 = x11 * x74
    x77 = 3.14159265358979 * x1 * x31 * x5
    x78 = x11 * x77
    x79 = -x38 - C[2]
    x80 = x34 * x79
    x81 = x51 * x79
    x82 = x47 + x81
    x83 = x44 * x79
    x84 = x0 * (x51 + x83)
    x85 = x39 * x82
    x86 = x84 + x85
    x87 = x57 + 2.0 * x81
    x88 = x0 * (x46 + x87)
    x89 = x39 * x86
    x90 = x88 + x89
    x91 = x77 * (x0 * (x54 + 3.0 * x84 + 3.0 * x85) + x39 * x90)
    x92 = x40 * x59**2
    x93 = x42 + x92
    x94 = x0 * (x10 + 3.0 * x8) + x3 * x61
    x95 = x36 * x93
    x96 = x49 * x59 + x95
    x97 = x0 * (x70 + x92)
    x98 = x36 * x96
    x99 = x97 + x98
    x100 = x0 * (4.0 * x42 * x59 + 2.0 * x67 + 2.0 * x68 + 2.0 * x95) + x36 * x99
    x101 = x100 * x74
    x102 = x3 * x74
    x103 = x3 * x77
    x104 = x44 * x79**2
    x105 = x104 + x47
    x106 = x105 * x39
    x107 = x106 + x53 * x79
    x108 = x0 * (x104 + x87)
    x109 = x107 * x39
    x110 = x108 + x109
    x111 = x0 * (2.0 * x106 + 4.0 * x47 * x79 + 2.0 * x84 + 2.0 * x85) + x110 * x39
    x112 = x111 * x77

    # 90 item(s)
    return numpy.array(
        [
            x34 * (x0 * (2.0 * x15 + 2.0 * x21 + 3.0 * x23 + 3.0 * x28) + x3 * x30),
            x36 * x37,
            x37 * x39,
            x29 * x43 * x44,
            x29 * x36 * x45,
            x29 * x40 * x48,
            x27 * x44 * x50,
            x27 * x43 * x51,
            x27 * x48 * x52,
            x27 * x40 * x54,
            x24 * x44 * x56,
            x24 * x50 * x51,
            x24 * x43 * x48,
            x24 * x52 * x54,
            x24 * x40 * x58,
            x59 * x63,
            x44 * x62 * x65,
            x45 * x59 * x62,
            x20 * x44 * x69,
            x20 * x51 * x65,
            x20 * x48 * x66,
            x18 * x44 * x73,
            x18 * x51 * x69,
            x18 * x48 * x65,
            x18 * x54 * x66,
            x11 * x75,
            x39 * x73 * x76,
            x16 * x48 * x69,
            x16 * x54 * x65,
            x58 * x59 * x78,
            x63 * x79,
            x36 * x62 * x80,
            x40 * x62 * x82,
            x20 * x43 * x83,
            x20 * x52 * x82,
            x20 * x40 * x86,
            x18 * x50 * x83,
            x18 * x43 * x82,
            x18 * x52 * x86,
            x18 * x40 * x90,
            x56 * x76 * x79,
            x16 * x50 * x82,
            x16 * x43 * x86,
            x36 * x78 * x90,
            x11 * x91,
            x44 * x93 * x94,
            x44 * x61 * x96,
            x51 * x61 * x93,
            x44 * x60 * x99,
            x51 * x60 * x96,
            x48 * x60 * x93,
            x101 * x3,
            x102 * x39 * x99,
            x12 * x48 * x96,
            x12 * x54 * x93,
            x74 * (x0 * (2.0 * x71 + 2.0 * x72 + 3.0 * x97 + 3.0 * x98) + x100 * x36),
            x101 * x39,
            x48 * x7 * x99,
            x54 * x7 * x96,
            x58 * x7 * x93,
            x59 * x80 * x94,
            x61 * x65 * x83,
            x61 * x66 * x82,
            x60 * x69 * x83,
            x60 * x65 * x82,
            x60 * x66 * x86,
            x102 * x73 * x79,
            x12 * x69 * x82,
            x12 * x65 * x86,
            x103 * x59 * x90,
            x75 * x79,
            x7 * x73 * x82,
            x69 * x7 * x86,
            x65 * x7 * x90,
            x59 * x91,
            x105 * x40 * x94,
            x105 * x52 * x61,
            x107 * x40 * x61,
            x105 * x43 * x60,
            x107 * x52 * x60,
            x110 * x40 * x60,
            x105 * x12 * x50,
            x107 * x12 * x43,
            x103 * x110 * x36,
            x112 * x3,
            x105 * x56 * x7,
            x107 * x50 * x7,
            x110 * x43 * x7,
            x112 * x36,
            x77 * (x0 * (3.0 * x108 + 3.0 * x109 + 2.0 * x88 + 2.0 * x89) + x111 * x39),
        ]
    )


def quadrupole3d_10(a, A, b, B, C):
    """Cartesian 3D (ps) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (a + b) ** (-1.0)
    x1 = -x0 * (a * A[0] + b * B[0])
    x2 = -x1 - A[0]
    x3 = -x1 - C[0]
    x4 = a * b * x0
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = numpy.sqrt(x0)
    x7 = 1.77245385090552 * x6
    x8 = x5 * x7
    x9 = (2.0 * a + 2.0 * b) ** (-1.0)
    x10 = x8 * x9
    x11 = x10 + x3**2 * x8
    x12 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x13 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x14 = 3.14159265358979 * x0 * x13
    x15 = x12 * x14
    x16 = -x0 * (a * A[1] + b * B[1])
    x17 = -x16 - A[1]
    x18 = x11 * x15
    x19 = -x0 * (a * A[2] + b * B[2])
    x20 = -x19 - A[2]
    x21 = -x16 - C[1]
    x22 = x15 * (x10 + x2 * x3 * x8)
    x23 = x7 * x9
    x24 = x12 * x23
    x25 = x12 * x7
    x26 = x14 * x5
    x27 = x26 * (x17 * x21 * x25 + x24)
    x28 = 5.56832799683171
    x29 = x0 * x12 * x5
    x30 = x13 * x28 * x29 * x3 * x6
    x31 = -x19 - C[2]
    x32 = x13 * x23
    x33 = x13 * x7
    x34 = 3.14159265358979 * x29
    x35 = x34 * (x20 * x31 * x33 + x32)
    x36 = x21**2 * x25 + x24
    x37 = x26 * x36
    x38 = x31**2 * x33 + x32
    x39 = x34 * x38

    # 18 item(s)
    return numpy.array(
        [
            x15 * (2.0 * x10 * x3 + x11 * x2),
            x17 * x18,
            x18 * x20,
            x21 * x22,
            x27 * x3,
            x20 * x21 * x30,
            x22 * x31,
            x17 * x30 * x31,
            x3 * x35,
            x2 * x37,
            x26 * (x17 * x36 + 2.0 * x21 * x24),
            x20 * x37,
            x13 * x2 * x21 * x28 * x29 * x31 * x6,
            x27 * x31,
            x21 * x35,
            x2 * x39,
            x17 * x39,
            x34 * (x20 * x38 + 2.0 * x31 * x32),
        ]
    )


def quadrupole3d_11(a, A, b, B, C):
    """Cartesian 3D (pp) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3**2 * x7
    x9 = x0 * x7
    x10 = -x2 - B[0]
    x11 = x10 * x7
    x12 = x11 * x3
    x13 = -x2 - A[0]
    x14 = x8 + x9
    x15 = 2.0 * x3 * x9
    x16 = x10 * x14 + x15
    x17 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x18 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x19 = 3.14159265358979 * x1 * x18
    x20 = x17 * x19
    x21 = -x1 * (a * A[1] + b * B[1])
    x22 = -x21 - B[1]
    x23 = x20 * (x13 * x14 + x15)
    x24 = -x1 * (a * A[2] + b * B[2])
    x25 = -x24 - B[2]
    x26 = -x21 - A[1]
    x27 = x16 * x20
    x28 = x0 * x6
    x29 = x17 * x28
    x30 = x17 * x6
    x31 = x22 * x30
    x32 = x26 * x31 + x29
    x33 = x18 * x6
    x34 = x14 * x20
    x35 = -x24 - A[2]
    x36 = x18 * x28
    x37 = x25 * x33
    x38 = x35 * x37 + x36
    x39 = -x21 - C[1]
    x40 = x3 * x7
    x41 = x12 + x9
    x42 = x20 * (x0 * (x11 + x40) + x13 * x41)
    x43 = x31 * x39
    x44 = x29 + x43
    x45 = x13 * x40 + x9
    x46 = x20 * x39
    x47 = x30 * x39
    x48 = x26 * x47 + x29
    x49 = x19 * x5
    x50 = x49 * (x0 * (x31 + x47) + x26 * x44)
    x51 = x3 * x49
    x52 = 3.14159265358979 * x1 * x17 * x5
    x53 = x3 * x52
    x54 = -x24 - C[2]
    x55 = x20 * x54
    x56 = x37 * x54
    x57 = x36 + x56
    x58 = x33 * x54
    x59 = x35 * x58 + x36
    x60 = x52 * (x0 * (x37 + x58) + x35 * x57)
    x61 = x30 * x39**2
    x62 = x29 + x61
    x63 = x11 * x13 + x9
    x64 = 2.0 * x29 * x39
    x65 = x22 * x62 + x64
    x66 = x49 * x65
    x67 = x49 * x62
    x68 = x49 * (x26 * x62 + x64)
    x69 = x49 * x54
    x70 = x39 * x52
    x71 = x33 * x54**2
    x72 = x36 + x71
    x73 = x52 * x72
    x74 = 2.0 * x36 * x54
    x75 = x25 * x72 + x74
    x76 = x52 * x75
    x77 = x52 * (x35 * x72 + x74)

    # 54 item(s)
    return numpy.array(
        [
            x20 * (x0 * (2.0 * x12 + x8 + 3.0 * x9) + x13 * x16),
            x22 * x23,
            x23 * x25,
            x26 * x27,
            x14 * x32 * x33,
            x25 * x26 * x34,
            x27 * x35,
            x22 * x34 * x35,
            x14 * x30 * x38,
            x39 * x42,
            x33 * x44 * x45,
            x25 * x45 * x46,
            x33 * x41 * x48,
            x3 * x50,
            x25 * x48 * x51,
            x35 * x41 * x46,
            x35 * x44 * x51,
            x38 * x39 * x53,
            x42 * x54,
            x22 * x45 * x55,
            x30 * x45 * x57,
            x26 * x41 * x55,
            x32 * x51 * x54,
            x26 * x53 * x57,
            x30 * x41 * x59,
            x22 * x53 * x59,
            x3 * x60,
            x33 * x62 * x63,
            x13 * x66,
            x13 * x25 * x67,
            x10 * x68,
            x49 * (x0 * (3.0 * x29 + 2.0 * x43 + x61) + x26 * x65),
            x25 * x68,
            x10 * x35 * x67,
            x35 * x66,
            x38 * x62 * x7,
            x46 * x54 * x63,
            x13 * x44 * x69,
            x13 * x57 * x70,
            x10 * x48 * x69,
            x50 * x54,
            x48 * x57 * x7,
            x10 * x59 * x70,
            x44 * x59 * x7,
            x39 * x60,
            x30 * x63 * x72,
            x13 * x22 * x73,
            x13 * x76,
            x10 * x26 * x73,
            x32 * x7 * x72,
            x26 * x76,
            x10 * x77,
            x22 * x77,
            x52 * (x0 * (3.0 * x36 + 2.0 * x56 + x71) + x35 * x75),
        ]
    )


def quadrupole3d_12(a, A, b, B, C):
    """Cartesian 3D (pd) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = 1.77245385090552 * numpy.sqrt(x1)
    x3 = -x1 * (a * A[0] + b * B[0])
    x4 = -x3 - B[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = x4 * x6
    x8 = x2 * x7
    x9 = -x3 - C[0]
    x10 = x2 * x6
    x11 = x10 * x9
    x12 = x0 * (x11 + x8)
    x13 = x10 * x9**2
    x14 = x0 * x10
    x15 = x13 + x14
    x16 = x15 * x4
    x17 = x8 * x9
    x18 = x14 + x17
    x19 = x18 * x4
    x20 = x0 * x11
    x21 = -x3 - A[0]
    x22 = 3.0 * x14 + 2.0 * x17
    x23 = x0 * (x13 + x22)
    x24 = 2.0 * x20
    x25 = x16 + x24
    x26 = x23 + x25 * x4
    x27 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x28 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x29 = 3.14159265358979 * x1 * x28
    x30 = x27 * x29
    x31 = -x1 * (a * A[1] + b * B[1])
    x32 = -x31 - B[1]
    x33 = x30 * (x21 * x25 + x23)
    x34 = -x1 * (a * A[2] + b * B[2])
    x35 = -x34 - B[2]
    x36 = x15 * x21 + x24
    x37 = x2 * x27
    x38 = x32**2 * x37
    x39 = x0 * x37
    x40 = x38 + x39
    x41 = x2 * x28
    x42 = x40 * x41
    x43 = x30 * x35
    x44 = x35**2 * x41
    x45 = x0 * x41
    x46 = x44 + x45
    x47 = x37 * x46
    x48 = -x31 - A[1]
    x49 = x26 * x30
    x50 = x32 * x37
    x51 = x39 + x48 * x50
    x52 = 2.0 * x39
    x53 = x32 * x52 + x40 * x48
    x54 = x35 * x41
    x55 = -x34 - A[2]
    x56 = x30 * x55
    x57 = x45 + x54 * x55
    x58 = 2.0 * x45
    x59 = x35 * x58 + x46 * x55
    x60 = -x31 - C[1]
    x61 = x10 * x4**2
    x62 = x12 + x19
    x63 = x30 * (x0 * (x22 + x61) + x21 * x62)
    x64 = x12 + x18 * x21
    x65 = x50 * x60
    x66 = x39 + x65
    x67 = x41 * x66
    x68 = x37 * x60
    x69 = x0 * (x50 + x68)
    x70 = x32 * x66
    x71 = x69 + x70
    x72 = x11 * x21 + x14
    x73 = x39 + x48 * x68
    x74 = x48 * x66 + x69
    x75 = 3.0 * x39 + 2.0 * x65
    x76 = x29 * x6
    x77 = x76 * (x0 * (x38 + x75) + x48 * x71)
    x78 = x35 * x76
    x79 = x76 * x9
    x80 = 3.14159265358979 * x1 * x27
    x81 = x6 * x80
    x82 = x81 * x9
    x83 = -x34 - C[2]
    x84 = x30 * x83
    x85 = x54 * x83
    x86 = x45 + x85
    x87 = x37 * x86
    x88 = x41 * x83
    x89 = x0 * (x54 + x88)
    x90 = x35 * x86
    x91 = x89 + x90
    x92 = x45 + x55 * x88
    x93 = x55 * x86 + x89
    x94 = x32 * x81
    x95 = 3.0 * x45 + 2.0 * x85
    x96 = x81 * (x0 * (x44 + x95) + x55 * x91)
    x97 = x14 + x61
    x98 = 2.0 * x0 * x8 + x21 * x97
    x99 = x37 * x60**2
    x100 = x39 + x99
    x101 = x100 * x41
    x102 = x100 * x32
    x103 = x52 * x60
    x104 = x102 + x103
    x105 = x14 + x21 * x8
    x106 = x0 * (x75 + x99)
    x107 = x104 * x32 + x106
    x108 = x107 * x76
    x109 = x10 * x46
    x110 = x100 * x48 + x103
    x111 = x104 * x48 + x106
    x112 = x29 * x7
    x113 = x10 * x86
    x114 = x7 * x80
    x115 = x41 * x83**2
    x116 = x115 + x45
    x117 = x116 * x37
    x118 = x116 * x35
    x119 = x58 * x83
    x120 = x118 + x119
    x121 = x10 * x116
    x122 = x0 * (x115 + x95)
    x123 = x120 * x35 + x122
    x124 = x123 * x81
    x125 = x116 * x55 + x119
    x126 = x120 * x55 + x122

    # 108 item(s)
    return numpy.array(
        [
            x30 * (x0 * (2.0 * x12 + 2.0 * x16 + 2.0 * x19 + 4.0 * x20) + x21 * x26),
            x32 * x33,
            x33 * x35,
            x36 * x42,
            x32 * x36 * x43,
            x36 * x47,
            x48 * x49,
            x25 * x41 * x51,
            x25 * x43 * x48,
            x15 * x41 * x53,
            x15 * x51 * x54,
            x15 * x47 * x48,
            x49 * x55,
            x25 * x32 * x56,
            x25 * x37 * x57,
            x15 * x42 * x55,
            x15 * x50 * x57,
            x15 * x37 * x59,
            x60 * x63,
            x64 * x67,
            x43 * x60 * x64,
            x41 * x71 * x72,
            x54 * x66 * x72,
            x46 * x68 * x72,
            x41 * x62 * x73,
            x18 * x41 * x74,
            x18 * x54 * x73,
            x77 * x9,
            x74 * x78 * x9,
            x11 * x46 * x73,
            x56 * x60 * x62,
            x18 * x55 * x67,
            x18 * x57 * x68,
            x55 * x71 * x79,
            x11 * x57 * x66,
            x59 * x60 * x82,
            x63 * x83,
            x32 * x64 * x84,
            x64 * x87,
            x40 * x72 * x88,
            x50 * x72 * x86,
            x37 * x72 * x91,
            x48 * x62 * x84,
            x18 * x51 * x88,
            x18 * x48 * x87,
            x53 * x79 * x83,
            x11 * x51 * x86,
            x48 * x82 * x91,
            x37 * x62 * x92,
            x18 * x50 * x92,
            x18 * x37 * x93,
            x11 * x40 * x92,
            x9 * x93 * x94,
            x9 * x96,
            x101 * x98,
            x104 * x105 * x41,
            x100 * x105 * x54,
            x108 * x21,
            x104 * x21 * x78,
            x100 * x109 * x21,
            x110 * x41 * x97,
            x111 * x112,
            x110 * x112 * x35,
            x76
            * (x0 * (2.0 * x102 + 4.0 * x39 * x60 + 2.0 * x69 + 2.0 * x70) + x107 * x48),
            x111 * x78,
            x109 * x110,
            x101 * x55 * x97,
            x104 * x112 * x55,
            x100 * x57 * x8,
            x108 * x55,
            x10 * x104 * x57,
            x10 * x100 * x59,
            x60 * x84 * x98,
            x105 * x66 * x88,
            x105 * x68 * x86,
            x21 * x71 * x76 * x83,
            x113 * x21 * x66,
            x21 * x60 * x81 * x91,
            x73 * x88 * x97,
            x112 * x74 * x83,
            x73 * x8 * x86,
            x77 * x83,
            x113 * x74,
            x10 * x73 * x91,
            x68 * x92 * x97,
            x66 * x8 * x92,
            x114 * x60 * x93,
            x10 * x71 * x92,
            x10 * x66 * x93,
            x60 * x96,
            x117 * x98,
            x105 * x116 * x50,
            x105 * x120 * x37,
            x121 * x21 * x40,
            x120 * x21 * x94,
            x124 * x21,
            x117 * x48 * x97,
            x116 * x51 * x8,
            x114 * x120 * x48,
            x121 * x53,
            x10 * x120 * x51,
            x124 * x48,
            x125 * x37 * x97,
            x114 * x125 * x32,
            x114 * x126,
            x10 * x125 * x40,
            x126 * x94,
            x81
            * (x0 * (2.0 * x118 + 4.0 * x45 * x83 + 2.0 * x89 + 2.0 * x90) + x123 * x55),
        ]
    )


def quadrupole3d_13(a, A, b, B, C):
    """Cartesian 3D (pf) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3**2 * x7
    x9 = x0 * x7
    x10 = 3.0 * x9
    x11 = -x2 - C[0]
    x12 = x3 * x7
    x13 = x11 * x12
    x14 = x10 + 2.0 * x13
    x15 = x0 * (x14 + x8)
    x16 = x11 * x7
    x17 = x0 * (x12 + x16)
    x18 = x13 + x9
    x19 = x18 * x3
    x20 = x17 + x19
    x21 = x20 * x3
    x22 = x11**2 * x7
    x23 = x0 * (x14 + x22)
    x24 = x22 + x9
    x25 = x24 * x3
    x26 = x0 * x16
    x27 = 2.0 * x26
    x28 = x25 + x27
    x29 = x28 * x3
    x30 = -x2 - A[0]
    x31 = x0 * (2.0 * x17 + 2.0 * x19 + 2.0 * x25 + 4.0 * x26)
    x32 = x23 + x29
    x33 = x3 * x32 + x31
    x34 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x35 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x36 = 3.14159265358979 * x1 * x35
    x37 = x34 * x36
    x38 = -x1 * (a * A[1] + b * B[1])
    x39 = -x38 - B[1]
    x40 = x37 * (x30 * x32 + x31)
    x41 = -x1 * (a * A[2] + b * B[2])
    x42 = -x41 - B[2]
    x43 = x23 + x28 * x30
    x44 = x34 * x6
    x45 = x39**2 * x44
    x46 = x0 * x44
    x47 = x45 + x46
    x48 = x35 * x6
    x49 = x47 * x48
    x50 = x37 * x42
    x51 = x42**2 * x48
    x52 = x0 * x48
    x53 = x51 + x52
    x54 = x44 * x53
    x55 = x24 * x30 + x27
    x56 = 2.0 * x46
    x57 = x39 * x56
    x58 = x39 * x47 + x57
    x59 = x48 * x58
    x60 = x42 * x48
    x61 = x39 * x44
    x62 = 2.0 * x52
    x63 = x42 * x62
    x64 = x42 * x53 + x63
    x65 = x44 * x64
    x66 = -x38 - A[1]
    x67 = x33 * x37
    x68 = x46 + x61 * x66
    x69 = x47 * x66 + x57
    x70 = 3.0 * x46
    x71 = x0 * (3.0 * x45 + x70) + x58 * x66
    x72 = -x41 - A[2]
    x73 = x37 * x72
    x74 = x52 + x60 * x72
    x75 = x53 * x72 + x63
    x76 = 3.0 * x52
    x77 = x0 * (3.0 * x51 + x76) + x64 * x72
    x78 = -x38 - C[1]
    x79 = x8 + x9
    x80 = 2.0 * x0 * x12
    x81 = x3 * x79 + x80
    x82 = x15 + x21
    x83 = x37 * (x0 * (3.0 * x17 + 3.0 * x19 + x81) + x30 * x82)
    x84 = x15 + x20 * x30
    x85 = x61 * x78
    x86 = x46 + x85
    x87 = x48 * x86
    x88 = x17 + x18 * x30
    x89 = x44 * x78
    x90 = x0 * (x61 + x89)
    x91 = x39 * x86
    x92 = x90 + x91
    x93 = x48 * x92
    x94 = x70 + 2.0 * x85
    x95 = x0 * (x45 + x94)
    x96 = x39 * x92
    x97 = x95 + x96
    x98 = x16 * x30 + x9
    x99 = x46 + x66 * x89
    x100 = x66 * x86 + x90
    x101 = x66 * x92 + x95
    x102 = x36 * x5
    x103 = x102 * (x0 * (x58 + 3.0 * x90 + 3.0 * x91) + x66 * x97)
    x104 = x102 * x11
    x105 = 3.14159265358979 * x1 * x34 * x5
    x106 = x105 * x11
    x107 = -x41 - C[2]
    x108 = x107 * x37
    x109 = x107 * x60
    x110 = x109 + x52
    x111 = x110 * x44
    x112 = x107 * x48
    x113 = x0 * (x112 + x60)
    x114 = x110 * x42
    x115 = x113 + x114
    x116 = x115 * x44
    x117 = 2.0 * x109 + x76
    x118 = x0 * (x117 + x51)
    x119 = x115 * x42
    x120 = x118 + x119
    x121 = x112 * x72 + x52
    x122 = x110 * x72 + x113
    x123 = x115 * x72 + x118
    x124 = x105 * (x0 * (3.0 * x113 + 3.0 * x114 + x64) + x120 * x72)
    x125 = x0 * (x10 + 3.0 * x8) + x30 * x81
    x126 = x44 * x78**2
    x127 = x126 + x46
    x128 = x127 * x48
    x129 = x30 * x79 + x80
    x130 = x127 * x39
    x131 = x56 * x78
    x132 = x130 + x131
    x133 = x132 * x48
    x134 = x0 * (x126 + x94)
    x135 = x132 * x39
    x136 = x134 + x135
    x137 = x12 * x30 + x9
    x138 = x0 * (2.0 * x130 + 4.0 * x46 * x78 + 2.0 * x90 + 2.0 * x91)
    x139 = x136 * x39 + x138
    x140 = x102 * x139
    x141 = x102 * x42
    x142 = x53 * x7
    x143 = x64 * x7
    x144 = x127 * x66 + x131
    x145 = x132 * x66 + x134
    x146 = x102 * (x136 * x66 + x138)
    x147 = x102 * x3
    x148 = x110 * x7
    x149 = x115 * x7
    x150 = x105 * x78
    x151 = x107**2 * x48
    x152 = x151 + x52
    x153 = x152 * x44
    x154 = x152 * x42
    x155 = x107 * x62
    x156 = x154 + x155
    x157 = x156 * x44
    x158 = x0 * (x117 + x151)
    x159 = x156 * x42
    x160 = x158 + x159
    x161 = x152 * x7
    x162 = x156 * x7
    x163 = x105 * x160
    x164 = x0 * (4.0 * x107 * x52 + 2.0 * x113 + 2.0 * x114 + 2.0 * x154)
    x165 = x160 * x42 + x164
    x166 = x105 * x165
    x167 = x152 * x72 + x155
    x168 = x156 * x72 + x158
    x169 = x105 * (x160 * x72 + x164)

    # 180 item(s)
    return numpy.array(
        [
            x37 * (x0 * (2.0 * x15 + 2.0 * x21 + 3.0 * x23 + 3.0 * x29) + x30 * x33),
            x39 * x40,
            x40 * x42,
            x43 * x49,
            x39 * x43 * x50,
            x43 * x54,
            x55 * x59,
            x47 * x55 * x60,
            x53 * x55 * x61,
            x55 * x65,
            x66 * x67,
            x32 * x48 * x68,
            x32 * x50 * x66,
            x28 * x48 * x69,
            x28 * x60 * x68,
            x28 * x54 * x66,
            x24 * x48 * x71,
            x24 * x60 * x69,
            x24 * x53 * x68,
            x24 * x65 * x66,
            x67 * x72,
            x32 * x39 * x73,
            x32 * x44 * x74,
            x28 * x49 * x72,
            x28 * x61 * x74,
            x28 * x44 * x75,
            x24 * x59 * x72,
            x24 * x47 * x74,
            x24 * x61 * x75,
            x24 * x44 * x77,
            x78 * x83,
            x84 * x87,
            x50 * x78 * x84,
            x88 * x93,
            x60 * x86 * x88,
            x53 * x88 * x89,
            x48 * x97 * x98,
            x60 * x92 * x98,
            x53 * x86 * x98,
            x64 * x89 * x98,
            x48 * x82 * x99,
            x100 * x20 * x48,
            x20 * x60 * x99,
            x101 * x18 * x48,
            x100 * x18 * x60,
            x18 * x53 * x99,
            x103 * x11,
            x101 * x104 * x42,
            x100 * x16 * x53,
            x16 * x64 * x99,
            x73 * x78 * x82,
            x20 * x72 * x87,
            x20 * x74 * x89,
            x18 * x72 * x93,
            x18 * x74 * x86,
            x18 * x75 * x89,
            x104 * x72 * x97,
            x16 * x74 * x92,
            x16 * x75 * x86,
            x106 * x77 * x78,
            x107 * x83,
            x108 * x39 * x84,
            x111 * x84,
            x112 * x47 * x88,
            x110 * x61 * x88,
            x116 * x88,
            x112 * x58 * x98,
            x110 * x47 * x98,
            x115 * x61 * x98,
            x120 * x44 * x98,
            x108 * x66 * x82,
            x112 * x20 * x68,
            x111 * x20 * x66,
            x112 * x18 * x69,
            x110 * x18 * x68,
            x116 * x18 * x66,
            x104 * x107 * x71,
            x110 * x16 * x69,
            x115 * x16 * x68,
            x106 * x120 * x66,
            x121 * x44 * x82,
            x121 * x20 * x61,
            x122 * x20 * x44,
            x121 * x18 * x47,
            x122 * x18 * x61,
            x123 * x18 * x44,
            x121 * x16 * x58,
            x122 * x16 * x47,
            x106 * x123 * x39,
            x11 * x124,
            x125 * x128,
            x129 * x133,
            x127 * x129 * x60,
            x136 * x137 * x48,
            x132 * x137 * x60,
            x127 * x137 * x53,
            x140 * x30,
            x136 * x141 * x30,
            x132 * x142 * x30,
            x127 * x143 * x30,
            x144 * x48 * x81,
            x145 * x48 * x79,
            x144 * x60 * x79,
            x146 * x3,
            x141 * x145 * x3,
            x12 * x144 * x53,
            x102 * (x0 * (3.0 * x134 + 3.0 * x135 + 2.0 * x95 + 2.0 * x96) + x139 * x66),
            x146 * x42,
            x142 * x145,
            x143 * x144,
            x128 * x72 * x81,
            x133 * x72 * x79,
            x127 * x74 * x79,
            x136 * x147 * x72,
            x12 * x132 * x74,
            x12 * x127 * x75,
            x140 * x72,
            x136 * x7 * x74,
            x132 * x7 * x75,
            x127 * x7 * x77,
            x108 * x125 * x78,
            x112 * x129 * x86,
            x110 * x129 * x89,
            x112 * x137 * x92,
            x110 * x137 * x86,
            x115 * x137 * x89,
            x102 * x107 * x30 * x97,
            x148 * x30 * x92,
            x149 * x30 * x86,
            x120 * x150 * x30,
            x112 * x81 * x99,
            x100 * x112 * x79,
            x110 * x79 * x99,
            x101 * x107 * x147,
            x100 * x110 * x12,
            x115 * x12 * x99,
            x103 * x107,
            x101 * x148,
            x100 * x149,
            x120 * x7 * x99,
            x121 * x81 * x89,
            x121 * x79 * x86,
            x122 * x79 * x89,
            x12 * x121 * x92,
            x12 * x122 * x86,
            x123 * x150 * x3,
            x121 * x7 * x97,
            x122 * x7 * x92,
            x123 * x7 * x86,
            x124 * x78,
            x125 * x153,
            x129 * x152 * x61,
            x129 * x157,
            x137 * x152 * x47,
            x137 * x156 * x61,
            x137 * x160 * x44,
            x161 * x30 * x58,
            x162 * x30 * x47,
            x163 * x30 * x39,
            x166 * x30,
            x153 * x66 * x81,
            x152 * x68 * x79,
            x157 * x66 * x79,
            x12 * x152 * x69,
            x12 * x156 * x68,
            x163 * x3 * x66,
            x161 * x71,
            x162 * x69,
            x160 * x68 * x7,
            x166 * x66,
            x167 * x44 * x81,
            x167 * x61 * x79,
            x168 * x44 * x79,
            x12 * x167 * x47,
            x105 * x168 * x3 * x39,
            x169 * x3,
            x167 * x58 * x7,
            x168 * x47 * x7,
            x169 * x39,
            x105
            * (x0 * (2.0 * x118 + 2.0 * x119 + 3.0 * x158 + 3.0 * x159) + x165 * x72),
        ]
    )


def quadrupole3d_14(a, A, b, B, C):
    """Cartesian 3D (pg) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3 * x7
    x9 = -x2 - C[0]
    x10 = x7 * x9
    x11 = x0 * (x10 + x8)
    x12 = x0 * x7
    x13 = x8 * x9
    x14 = x12 + x13
    x15 = x14 * x3
    x16 = x3**2 * x7
    x17 = x12 + x16
    x18 = x17 * x3
    x19 = 2.0 * x12
    x20 = x19 * x3
    x21 = x18 + x20
    x22 = x0 * (3.0 * x11 + 3.0 * x15 + x21)
    x23 = 3.0 * x12
    x24 = 2.0 * x13 + x23
    x25 = x0 * (x16 + x24)
    x26 = x11 + x15
    x27 = x26 * x3
    x28 = x25 + x27
    x29 = x28 * x3
    x30 = x7 * x9**2
    x31 = x12 + x30
    x32 = x3 * x31
    x33 = x0 * (2.0 * x11 + 4.0 * x12 * x9 + 2.0 * x15 + 2.0 * x32)
    x34 = x0 * (x24 + x30)
    x35 = x19 * x9
    x36 = x32 + x35
    x37 = x3 * x36
    x38 = x34 + x37
    x39 = x3 * x38
    x40 = -x2 - A[0]
    x41 = x0 * (2.0 * x25 + 2.0 * x27 + 3.0 * x34 + 3.0 * x37)
    x42 = x33 + x39
    x43 = x3 * x42 + x41
    x44 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x45 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x46 = 3.14159265358979 * x1 * x45
    x47 = x44 * x46
    x48 = -x1 * (a * A[1] + b * B[1])
    x49 = -x48 - B[1]
    x50 = x47 * (x40 * x42 + x41)
    x51 = -x1 * (a * A[2] + b * B[2])
    x52 = -x51 - B[2]
    x53 = x33 + x38 * x40
    x54 = x44 * x6
    x55 = x49**2 * x54
    x56 = x0 * x54
    x57 = x55 + x56
    x58 = x45 * x6
    x59 = x57 * x58
    x60 = x47 * x52
    x61 = x52**2 * x58
    x62 = x0 * x58
    x63 = x61 + x62
    x64 = x54 * x63
    x65 = x34 + x36 * x40
    x66 = x49 * x57
    x67 = x49 * x56
    x68 = 2.0 * x67
    x69 = x66 + x68
    x70 = x58 * x69
    x71 = x52 * x58
    x72 = x49 * x54
    x73 = x52 * x63
    x74 = x52 * x62
    x75 = 2.0 * x74
    x76 = x73 + x75
    x77 = x54 * x76
    x78 = x31 * x40 + x35
    x79 = 3.0 * x56
    x80 = x0 * (3.0 * x55 + x79)
    x81 = x49 * x69 + x80
    x82 = x58 * x81
    x83 = 3.0 * x62
    x84 = x0 * (3.0 * x61 + x83)
    x85 = x52 * x76 + x84
    x86 = x54 * x85
    x87 = -x48 - A[1]
    x88 = x43 * x47
    x89 = x56 + x72 * x87
    x90 = x57 * x87 + x68
    x91 = x69 * x87 + x80
    x92 = x0 * (4.0 * x66 + 8.0 * x67) + x81 * x87
    x93 = -x51 - A[2]
    x94 = x47 * x93
    x95 = x62 + x71 * x93
    x96 = x63 * x93 + x75
    x97 = x76 * x93 + x84
    x98 = x0 * (4.0 * x73 + 8.0 * x74) + x85 * x93
    x99 = -x48 - C[1]
    x100 = x0 * (3.0 * x16 + x23)
    x101 = x100 + x21 * x3
    x102 = x22 + x29
    x103 = x47 * (x0 * (x101 + 4.0 * x25 + 4.0 * x27) + x102 * x40)
    x104 = x22 + x28 * x40
    x105 = x72 * x99
    x106 = x105 + x56
    x107 = x106 * x58
    x108 = x25 + x26 * x40
    x109 = x54 * x99
    x110 = x0 * (x109 + x72)
    x111 = x106 * x49
    x112 = x110 + x111
    x113 = x112 * x58
    x114 = x11 + x14 * x40
    x115 = 2.0 * x105 + x79
    x116 = x0 * (x115 + x55)
    x117 = x112 * x49
    x118 = x116 + x117
    x119 = x118 * x58
    x120 = x0 * (3.0 * x110 + 3.0 * x111 + x69)
    x121 = x118 * x49
    x122 = x120 + x121
    x123 = x10 * x40 + x12
    x124 = x109 * x87 + x56
    x125 = x106 * x87 + x110
    x126 = x112 * x87 + x116
    x127 = x118 * x87 + x120
    x128 = x46 * x5
    x129 = x128 * (x0 * (4.0 * x116 + 4.0 * x117 + x81) + x122 * x87)
    x130 = x128 * x9
    x131 = 3.14159265358979 * x1 * x44 * x5
    x132 = x131 * x9
    x133 = -x51 - C[2]
    x134 = x133 * x47
    x135 = x133 * x71
    x136 = x135 + x62
    x137 = x136 * x54
    x138 = x133 * x58
    x139 = x0 * (x138 + x71)
    x140 = x136 * x52
    x141 = x139 + x140
    x142 = x141 * x54
    x143 = 2.0 * x135 + x83
    x144 = x0 * (x143 + x61)
    x145 = x141 * x52
    x146 = x144 + x145
    x147 = x146 * x54
    x148 = x0 * (3.0 * x139 + 3.0 * x140 + x76)
    x149 = x146 * x52
    x150 = x148 + x149
    x151 = x138 * x93 + x62
    x152 = x136 * x93 + x139
    x153 = x141 * x93 + x144
    x154 = x146 * x93 + x148
    x155 = x131 * (x0 * (4.0 * x144 + 4.0 * x145 + x85) + x150 * x93)
    x156 = x0 * (8.0 * x12 * x3 + 4.0 * x18) + x101 * x40
    x157 = x54 * x99**2
    x158 = x157 + x56
    x159 = x158 * x58
    x160 = x100 + x21 * x40
    x161 = x158 * x49
    x162 = x56 * x99
    x163 = 2.0 * x162
    x164 = x161 + x163
    x165 = x164 * x58
    x166 = x17 * x40 + x20
    x167 = x0 * (x115 + x157)
    x168 = x164 * x49
    x169 = x167 + x168
    x170 = x169 * x58
    x171 = x0 * (2.0 * x110 + 2.0 * x111 + 2.0 * x161 + 4.0 * x162)
    x172 = x169 * x49
    x173 = x171 + x172
    x174 = x12 + x40 * x8
    x175 = x0 * (2.0 * x116 + 2.0 * x117 + 3.0 * x167 + 3.0 * x168)
    x176 = x173 * x49 + x175
    x177 = x128 * x176
    x178 = x128 * x52
    x179 = x63 * x7
    x180 = x7 * x76
    x181 = x7 * x85
    x182 = x158 * x87 + x163
    x183 = x164 * x87 + x167
    x184 = x169 * x87 + x171
    x185 = x128 * (x173 * x87 + x175)
    x186 = x128 * x3
    x187 = x136 * x7
    x188 = x141 * x7
    x189 = x146 * x7
    x190 = x131 * x99
    x191 = x133**2 * x58
    x192 = x191 + x62
    x193 = x192 * x54
    x194 = x192 * x52
    x195 = x133 * x62
    x196 = 2.0 * x195
    x197 = x194 + x196
    x198 = x197 * x54
    x199 = x0 * (x143 + x191)
    x200 = x197 * x52
    x201 = x199 + x200
    x202 = x201 * x54
    x203 = x0 * (2.0 * x139 + 2.0 * x140 + 2.0 * x194 + 4.0 * x195)
    x204 = x201 * x52
    x205 = x203 + x204
    x206 = x192 * x7
    x207 = x197 * x7
    x208 = x201 * x7
    x209 = x131 * x205
    x210 = x0 * (2.0 * x144 + 2.0 * x145 + 3.0 * x199 + 3.0 * x200)
    x211 = x205 * x52 + x210
    x212 = x131 * x211
    x213 = x192 * x93 + x196
    x214 = x197 * x93 + x199
    x215 = x201 * x93 + x203
    x216 = x131 * (x205 * x93 + x210)

    # 270 item(s)
    return numpy.array(
        [
            x47 * (x0 * (2.0 * x22 + 2.0 * x29 + 4.0 * x33 + 4.0 * x39) + x40 * x43),
            x49 * x50,
            x50 * x52,
            x53 * x59,
            x49 * x53 * x60,
            x53 * x64,
            x65 * x70,
            x57 * x65 * x71,
            x63 * x65 * x72,
            x65 * x77,
            x78 * x82,
            x69 * x71 * x78,
            x57 * x63 * x78,
            x72 * x76 * x78,
            x78 * x86,
            x87 * x88,
            x42 * x58 * x89,
            x42 * x60 * x87,
            x38 * x58 * x90,
            x38 * x71 * x89,
            x38 * x64 * x87,
            x36 * x58 * x91,
            x36 * x71 * x90,
            x36 * x63 * x89,
            x36 * x77 * x87,
            x31 * x58 * x92,
            x31 * x71 * x91,
            x31 * x63 * x90,
            x31 * x76 * x89,
            x31 * x86 * x87,
            x88 * x93,
            x42 * x49 * x94,
            x42 * x54 * x95,
            x38 * x59 * x93,
            x38 * x72 * x95,
            x38 * x54 * x96,
            x36 * x70 * x93,
            x36 * x57 * x95,
            x36 * x72 * x96,
            x36 * x54 * x97,
            x31 * x82 * x93,
            x31 * x69 * x95,
            x31 * x57 * x96,
            x31 * x72 * x97,
            x31 * x54 * x98,
            x103 * x99,
            x104 * x107,
            x104 * x60 * x99,
            x108 * x113,
            x106 * x108 * x71,
            x108 * x109 * x63,
            x114 * x119,
            x112 * x114 * x71,
            x106 * x114 * x63,
            x109 * x114 * x76,
            x122 * x123 * x58,
            x118 * x123 * x71,
            x112 * x123 * x63,
            x106 * x123 * x76,
            x109 * x123 * x85,
            x102 * x124 * x58,
            x125 * x28 * x58,
            x124 * x28 * x71,
            x126 * x26 * x58,
            x125 * x26 * x71,
            x124 * x26 * x63,
            x127 * x14 * x58,
            x126 * x14 * x71,
            x125 * x14 * x63,
            x124 * x14 * x76,
            x129 * x9,
            x127 * x130 * x52,
            x10 * x126 * x63,
            x10 * x125 * x76,
            x10 * x124 * x85,
            x102 * x94 * x99,
            x107 * x28 * x93,
            x109 * x28 * x95,
            x113 * x26 * x93,
            x106 * x26 * x95,
            x109 * x26 * x96,
            x119 * x14 * x93,
            x112 * x14 * x95,
            x106 * x14 * x96,
            x109 * x14 * x97,
            x122 * x130 * x93,
            x10 * x118 * x95,
            x10 * x112 * x96,
            x10 * x106 * x97,
            x132 * x98 * x99,
            x103 * x133,
            x104 * x134 * x49,
            x104 * x137,
            x108 * x138 * x57,
            x108 * x136 * x72,
            x108 * x142,
            x114 * x138 * x69,
            x114 * x136 * x57,
            x114 * x141 * x72,
            x114 * x147,
            x123 * x138 * x81,
            x123 * x136 * x69,
            x123 * x141 * x57,
            x123 * x146 * x72,
            x123 * x150 * x54,
            x102 * x134 * x87,
            x138 * x28 * x89,
            x137 * x28 * x87,
            x138 * x26 * x90,
            x136 * x26 * x89,
            x142 * x26 * x87,
            x138 * x14 * x91,
            x136 * x14 * x90,
            x14 * x141 * x89,
            x14 * x147 * x87,
            x130 * x133 * x92,
            x10 * x136 * x91,
            x10 * x141 * x90,
            x10 * x146 * x89,
            x132 * x150 * x87,
            x102 * x151 * x54,
            x151 * x28 * x72,
            x152 * x28 * x54,
            x151 * x26 * x57,
            x152 * x26 * x72,
            x153 * x26 * x54,
            x14 * x151 * x69,
            x14 * x152 * x57,
            x14 * x153 * x72,
            x14 * x154 * x54,
            x10 * x151 * x81,
            x10 * x152 * x69,
            x10 * x153 * x57,
            x132 * x154 * x49,
            x155 * x9,
            x156 * x159,
            x160 * x165,
            x158 * x160 * x71,
            x166 * x170,
            x164 * x166 * x71,
            x158 * x166 * x63,
            x173 * x174 * x58,
            x169 * x174 * x71,
            x164 * x174 * x63,
            x158 * x174 * x76,
            x177 * x40,
            x173 * x178 * x40,
            x169 * x179 * x40,
            x164 * x180 * x40,
            x158 * x181 * x40,
            x101 * x182 * x58,
            x183 * x21 * x58,
            x182 * x21 * x71,
            x17 * x184 * x58,
            x17 * x183 * x71,
            x17 * x182 * x63,
            x185 * x3,
            x178 * x184 * x3,
            x183 * x63 * x8,
            x182 * x76 * x8,
            x128
            * (x0 * (2.0 * x120 + 2.0 * x121 + 4.0 * x171 + 4.0 * x172) + x176 * x87),
            x185 * x52,
            x179 * x184,
            x180 * x183,
            x181 * x182,
            x101 * x159 * x93,
            x165 * x21 * x93,
            x158 * x21 * x95,
            x17 * x170 * x93,
            x164 * x17 * x95,
            x158 * x17 * x96,
            x173 * x186 * x93,
            x169 * x8 * x95,
            x164 * x8 * x96,
            x158 * x8 * x97,
            x177 * x93,
            x173 * x7 * x95,
            x169 * x7 * x96,
            x164 * x7 * x97,
            x158 * x7 * x98,
            x134 * x156 * x99,
            x106 * x138 * x160,
            x109 * x136 * x160,
            x112 * x138 * x166,
            x106 * x136 * x166,
            x109 * x141 * x166,
            x118 * x138 * x174,
            x112 * x136 * x174,
            x106 * x141 * x174,
            x109 * x146 * x174,
            x122 * x128 * x133 * x40,
            x118 * x187 * x40,
            x112 * x188 * x40,
            x106 * x189 * x40,
            x150 * x190 * x40,
            x101 * x124 * x138,
            x125 * x138 * x21,
            x124 * x136 * x21,
            x126 * x138 * x17,
            x125 * x136 * x17,
            x124 * x141 * x17,
            x127 * x133 * x186,
            x126 * x136 * x8,
            x125 * x141 * x8,
            x124 * x146 * x8,
            x129 * x133,
            x127 * x187,
            x126 * x188,
            x125 * x189,
            x124 * x150 * x7,
            x101 * x109 * x151,
            x106 * x151 * x21,
            x109 * x152 * x21,
            x112 * x151 * x17,
            x106 * x152 * x17,
            x109 * x153 * x17,
            x118 * x151 * x8,
            x112 * x152 * x8,
            x106 * x153 * x8,
            x154 * x190 * x3,
            x122 * x151 * x7,
            x118 * x152 * x7,
            x112 * x153 * x7,
            x106 * x154 * x7,
            x155 * x99,
            x156 * x193,
            x160 * x192 * x72,
            x160 * x198,
            x166 * x192 * x57,
            x166 * x197 * x72,
            x166 * x202,
            x174 * x192 * x69,
            x174 * x197 * x57,
            x174 * x201 * x72,
            x174 * x205 * x54,
            x206 * x40 * x81,
            x207 * x40 * x69,
            x208 * x40 * x57,
            x209 * x40 * x49,
            x212 * x40,
            x101 * x193 * x87,
            x192 * x21 * x89,
            x198 * x21 * x87,
            x17 * x192 * x90,
            x17 * x197 * x89,
            x17 * x202 * x87,
            x192 * x8 * x91,
            x197 * x8 * x90,
            x201 * x8 * x89,
            x209 * x3 * x87,
            x206 * x92,
            x207 * x91,
            x208 * x90,
            x205 * x7 * x89,
            x212 * x87,
            x101 * x213 * x54,
            x21 * x213 * x72,
            x21 * x214 * x54,
            x17 * x213 * x57,
            x17 * x214 * x72,
            x17 * x215 * x54,
            x213 * x69 * x8,
            x214 * x57 * x8,
            x131 * x215 * x3 * x49,
            x216 * x3,
            x213 * x7 * x81,
            x214 * x69 * x7,
            x215 * x57 * x7,
            x216 * x49,
            x131
            * (x0 * (2.0 * x148 + 2.0 * x149 + 4.0 * x203 + 4.0 * x204) + x211 * x93),
        ]
    )


def quadrupole3d_20(a, A, b, B, C):
    """Cartesian 3D (ds) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3**2 * x7
    x9 = x0 * x7
    x10 = -x2 - A[0]
    x11 = x10 * x7
    x12 = x11 * x3
    x13 = x8 + x9
    x14 = x10 * x13 + 2.0 * x3 * x9
    x15 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x16 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x17 = 3.14159265358979 * x1 * x16
    x18 = x15 * x17
    x19 = -x1 * (a * A[1] + b * B[1])
    x20 = -x19 - A[1]
    x21 = x14 * x18
    x22 = -x1 * (a * A[2] + b * B[2])
    x23 = -x22 - A[2]
    x24 = x15 * x6
    x25 = x0 * x24
    x26 = x20**2 * x24 + x25
    x27 = x16 * x6
    x28 = x18 * x23
    x29 = x0 * x27
    x30 = x23**2 * x27 + x29
    x31 = -x19 - C[1]
    x32 = x12 + x9
    x33 = x18 * (x0 * (x11 + x3 * x7) + x10 * x32)
    x34 = x20 * x24
    x35 = x31 * x34
    x36 = x25 + x35
    x37 = x17 * x5
    x38 = x37 * (x0 * (x24 * x31 + x34) + x20 * x36)
    x39 = x3 * x37
    x40 = 3.14159265358979 * x1 * x15 * x5
    x41 = x3 * x40
    x42 = -x22 - C[2]
    x43 = x18 * x42
    x44 = x23 * x27
    x45 = x42 * x44
    x46 = x29 + x45
    x47 = x40 * (x0 * (x27 * x42 + x44) + x23 * x46)
    x48 = x24 * x31**2
    x49 = x25 + x48
    x50 = x10**2 * x7 + x9
    x51 = x20 * x49 + 2.0 * x25 * x31
    x52 = x37 * x51
    x53 = x10 * x37
    x54 = x10 * x40
    x55 = x27 * x42**2
    x56 = x29 + x55
    x57 = x23 * x56 + 2.0 * x29 * x42
    x58 = x40 * x57

    # 36 item(s)
    return numpy.array(
        [
            x18 * (x0 * (2.0 * x12 + x8 + 3.0 * x9) + x10 * x14),
            x20 * x21,
            x21 * x23,
            x13 * x26 * x27,
            x13 * x20 * x28,
            x13 * x24 * x30,
            x31 * x33,
            x27 * x32 * x36,
            x28 * x31 * x32,
            x3 * x38,
            x23 * x36 * x39,
            x30 * x31 * x41,
            x33 * x42,
            x20 * x32 * x43,
            x24 * x32 * x46,
            x26 * x39 * x42,
            x20 * x41 * x46,
            x3 * x47,
            x27 * x49 * x50,
            x10 * x52,
            x23 * x49 * x53,
            x37 * (x0 * (3.0 * x25 + 2.0 * x35 + x48) + x20 * x51),
            x23 * x52,
            x30 * x49 * x7,
            x31 * x43 * x50,
            x36 * x42 * x53,
            x31 * x46 * x54,
            x38 * x42,
            x36 * x46 * x7,
            x31 * x47,
            x24 * x50 * x56,
            x20 * x54 * x56,
            x10 * x58,
            x26 * x56 * x7,
            x20 * x58,
            x40 * (x0 * (3.0 * x29 + 2.0 * x45 + x55) + x23 * x57),
        ]
    )


def quadrupole3d_21(a, A, b, B, C):
    """Cartesian 3D (dp) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = -x2 - C[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = 1.77245385090552 * numpy.sqrt(x1)
    x8 = x6 * x7
    x9 = x4**2 * x8
    x10 = x0 * x8
    x11 = x10 + x9
    x12 = x11 * x3
    x13 = -x2 - B[0]
    x14 = x11 * x13
    x15 = x13 * x8
    x16 = x4 * x8
    x17 = x0 * (x15 + x16)
    x18 = x15 * x4
    x19 = x10 + x18
    x20 = x19 * x3
    x21 = x10 * x4
    x22 = 3.0 * x10
    x23 = x22 + x9
    x24 = 2.0 * x21
    x25 = x14 + x24
    x26 = x0 * (2.0 * x18 + x23) + x25 * x3
    x27 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x28 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x29 = 3.14159265358979 * x1 * x28
    x30 = x27 * x29
    x31 = -x1 * (a * A[1] + b * B[1])
    x32 = -x31 - B[1]
    x33 = x16 * x3
    x34 = x12 + x24
    x35 = x30 * (x0 * (x23 + 2.0 * x33) + x3 * x34)
    x36 = -x1 * (a * A[2] + b * B[2])
    x37 = -x36 - B[2]
    x38 = -x31 - A[1]
    x39 = x26 * x30
    x40 = x0 * x7
    x41 = x27 * x40
    x42 = x27 * x7
    x43 = x38 * x42
    x44 = x32 * x43
    x45 = x41 + x44
    x46 = x28 * x7
    x47 = x30 * x34
    x48 = -x36 - A[2]
    x49 = x28 * x40
    x50 = x46 * x48
    x51 = x37 * x50
    x52 = x49 + x51
    x53 = x38**2 * x42 + x41
    x54 = x32 * x42
    x55 = x0 * (x43 + x54) + x38 * x45
    x56 = x37 * x46
    x57 = x30 * x48
    x58 = x46 * x48**2 + x49
    x59 = x0 * (x50 + x56) + x48 * x52
    x60 = -x31 - C[1]
    x61 = x15 * x3
    x62 = x17 + x20
    x63 = x30 * (x0 * (x18 + x22 + x33 + x61) + x3 * x62)
    x64 = x54 * x60
    x65 = x41 + x64
    x66 = x3 * x8
    x67 = x10 + x33
    x68 = x0 * (x16 + x66) + x3 * x67
    x69 = x30 * x68
    x70 = x43 * x60
    x71 = x41 + x70
    x72 = x42 * x60
    x73 = x0 * (x54 + x72)
    x74 = x38 * x65
    x75 = x73 + x74
    x76 = x0 * (x43 + x72) + x38 * x71
    x77 = 3.0 * x41
    x78 = x29 * x6
    x79 = x78 * (x0 * (x44 + x64 + x70 + x77) + x38 * x75)
    x80 = x4 * x78
    x81 = 3.14159265358979 * x1 * x27 * x6
    x82 = x4 * x81
    x83 = -x36 - C[2]
    x84 = x56 * x83
    x85 = x49 + x84
    x86 = x30 * x83
    x87 = x46 * x83
    x88 = x50 * x83
    x89 = x49 + x88
    x90 = x0 * (x56 + x87)
    x91 = x48 * x85
    x92 = x90 + x91
    x93 = x0 * (x50 + x87) + x48 * x89
    x94 = 3.0 * x49
    x95 = x81 * (x0 * (x51 + x84 + x88 + x94) + x48 * x92)
    x96 = x42 * x60**2
    x97 = x41 + x96
    x98 = x10 + x61
    x99 = x0 * (x15 + x66) + x3 * x98
    x100 = x32 * x97
    x101 = x41 * x60
    x102 = 2.0 * x101
    x103 = x100 + x102
    x104 = x10 + x3**2 * x8
    x105 = x38 * x97
    x106 = x102 + x105
    x107 = x77 + x96
    x108 = x0 * (x107 + 2.0 * x64) + x103 * x38
    x109 = x108 * x78
    x110 = x3 * x78
    x111 = x78 * (x0 * (x107 + 2.0 * x70) + x106 * x38)
    x112 = x13 * x78
    x113 = x60 * x81
    x114 = x46 * x83**2
    x115 = x114 + x49
    x116 = x115 * x37
    x117 = x49 * x83
    x118 = 2.0 * x117
    x119 = x116 + x118
    x120 = x3 * x81
    x121 = x115 * x48
    x122 = x118 + x121
    x123 = x114 + x94
    x124 = x0 * (x123 + 2.0 * x84) + x119 * x48
    x125 = x124 * x81
    x126 = x81 * (x0 * (x123 + 2.0 * x88) + x122 * x48)

    # 108 item(s)
    return numpy.array(
        [
            x30 * (x0 * (x12 + x14 + 2.0 * x17 + 2.0 * x20 + 4.0 * x21) + x26 * x3),
            x32 * x35,
            x35 * x37,
            x38 * x39,
            x34 * x45 * x46,
            x37 * x38 * x47,
            x39 * x48,
            x32 * x47 * x48,
            x34 * x42 * x52,
            x25 * x46 * x53,
            x11 * x46 * x55,
            x11 * x53 * x56,
            x25 * x38 * x57,
            x11 * x45 * x50,
            x11 * x43 * x52,
            x25 * x42 * x58,
            x11 * x54 * x58,
            x11 * x42 * x59,
            x60 * x63,
            x46 * x65 * x68,
            x37 * x60 * x69,
            x46 * x62 * x71,
            x46 * x67 * x75,
            x56 * x67 * x71,
            x57 * x60 * x62,
            x50 * x65 * x67,
            x52 * x67 * x72,
            x19 * x46 * x76,
            x4 * x79,
            x37 * x76 * x80,
            x19 * x50 * x71,
            x48 * x75 * x80,
            x16 * x52 * x71,
            x19 * x58 * x72,
            x16 * x58 * x65,
            x59 * x60 * x82,
            x63 * x83,
            x32 * x69 * x83,
            x42 * x68 * x85,
            x38 * x62 * x86,
            x45 * x67 * x87,
            x43 * x67 * x85,
            x42 * x62 * x89,
            x54 * x67 * x89,
            x42 * x67 * x92,
            x19 * x53 * x87,
            x55 * x80 * x83,
            x16 * x53 * x85,
            x19 * x43 * x89,
            x16 * x45 * x89,
            x38 * x82 * x92,
            x19 * x42 * x93,
            x32 * x82 * x93,
            x4 * x95,
            x46 * x97 * x99,
            x103 * x104 * x46,
            x104 * x56 * x97,
            x106 * x46 * x98,
            x109 * x3,
            x106 * x110 * x37,
            x50 * x97 * x98,
            x103 * x110 * x48,
            x52 * x66 * x97,
            x111 * x13,
            x78 * (x0 * (x100 + 4.0 * x101 + x105 + 2.0 * x73 + 2.0 * x74) + x108 * x38),
            x111 * x37,
            x106 * x112 * x48,
            x109 * x48,
            x106 * x52 * x8,
            x15 * x58 * x97,
            x103 * x58 * x8,
            x59 * x8 * x97,
            x60 * x86 * x99,
            x104 * x65 * x87,
            x104 * x72 * x85,
            x71 * x87 * x98,
            x110 * x75 * x83,
            x66 * x71 * x85,
            x72 * x89 * x98,
            x65 * x66 * x89,
            x113 * x3 * x92,
            x112 * x76 * x83,
            x79 * x83,
            x76 * x8 * x85,
            x15 * x71 * x89,
            x75 * x8 * x89,
            x71 * x8 * x92,
            x113 * x13 * x93,
            x65 * x8 * x93,
            x60 * x95,
            x115 * x42 * x99,
            x104 * x115 * x54,
            x104 * x119 * x42,
            x115 * x43 * x98,
            x115 * x45 * x66,
            x119 * x120 * x38,
            x122 * x42 * x98,
            x120 * x122 * x32,
            x125 * x3,
            x115 * x15 * x53,
            x115 * x55 * x8,
            x119 * x53 * x8,
            x122 * x13 * x38 * x81,
            x122 * x45 * x8,
            x125 * x38,
            x126 * x13,
            x126 * x32,
            x81 * (x0 * (x116 + 4.0 * x117 + x121 + 2.0 * x90 + 2.0 * x91) + x124 * x48),
        ]
    )


def quadrupole3d_22(a, A, b, B, C):
    """Cartesian 3D (dd) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = -x2 - C[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = 1.77245385090552 * numpy.sqrt(x1)
    x8 = x6 * x7
    x9 = x4**2 * x8
    x10 = x0 * x8
    x11 = x10 + x9
    x12 = x11 * x3
    x13 = x10 * x4
    x14 = 2.0 * x13
    x15 = x12 + x14
    x16 = x15 * x3
    x17 = x3**2 * x8
    x18 = 3.0 * x10
    x19 = x3 * x8
    x20 = x19 * x4
    x21 = x18 + 2.0 * x20
    x22 = x0 * (x17 + x21)
    x23 = -x2 - A[0]
    x24 = x4 * x8
    x25 = x0 * (x19 + x24)
    x26 = x10 + x20
    x27 = x26 * x3
    x28 = x25 + x27
    x29 = x23 * x28
    x30 = x15 * x23
    x31 = x0 * (x21 + x9)
    x32 = 4.0 * x13 + 2.0 * x25
    x33 = x16 + x31
    x34 = x0 * (2.0 * x12 + 2.0 * x27 + x32) + x23 * x33
    x35 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x36 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x37 = 3.14159265358979 * x1 * x36
    x38 = x35 * x37
    x39 = -x1 * (a * A[1] + b * B[1])
    x40 = -x39 - B[1]
    x41 = x11 * x23
    x42 = x23 * x26
    x43 = 2.0 * x42
    x44 = x30 + x31
    x45 = x38 * (x0 * (x12 + x32 + x41 + x43) + x23 * x44)
    x46 = -x1 * (a * A[2] + b * B[2])
    x47 = -x46 - B[2]
    x48 = x35 * x7
    x49 = x40**2 * x48
    x50 = x0 * x48
    x51 = x49 + x50
    x52 = x23 * x24
    x53 = x14 + x41
    x54 = x0 * (x18 + 2.0 * x52 + x9) + x23 * x53
    x55 = x36 * x7
    x56 = x38 * x47
    x57 = x47**2 * x55
    x58 = x0 * x55
    x59 = x57 + x58
    x60 = -x39 - A[1]
    x61 = x34 * x38
    x62 = x48 * x60
    x63 = x40 * x62
    x64 = x50 + x63
    x65 = 2.0 * x50
    x66 = x40 * x65 + x51 * x60
    x67 = x47 * x55
    x68 = -x46 - A[2]
    x69 = x38 * x68
    x70 = x55 * x68
    x71 = x47 * x70
    x72 = x58 + x71
    x73 = x40 * x48
    x74 = 2.0 * x58
    x75 = x47 * x74 + x59 * x68
    x76 = x48 * x60**2 + x50
    x77 = x0 * (x62 + x73) + x60 * x64
    x78 = 3.0 * x50
    x79 = x49 + x78
    x80 = x0 * (2.0 * x63 + x79) + x60 * x66
    x81 = x55 * x68**2 + x58
    x82 = x0 * (x67 + x70) + x68 * x72
    x83 = 3.0 * x58
    x84 = x57 + x83
    x85 = x0 * (2.0 * x71 + x84) + x68 * x75
    x86 = -x39 - C[1]
    x87 = x10 + x17
    x88 = 2.0 * x10 * x3 + x23 * x87
    x89 = x22 + x29
    x90 = x38 * (x0 * (3.0 * x25 + x27 + x43 + x88) + x23 * x89)
    x91 = x73 * x86
    x92 = x50 + x91
    x93 = x19 * x23
    x94 = x25 + x42
    x95 = x0 * (x18 + x20 + x52 + x93) + x23 * x94
    x96 = x48 * x86
    x97 = x0 * (x73 + x96)
    x98 = x40 * x92
    x99 = x97 + x98
    x100 = x23 * x8
    x101 = x10 + x52
    x102 = x0 * (x100 + x24) + x101 * x23
    x103 = x62 * x86
    x104 = x103 + x50
    x105 = x60 * x92
    x106 = x105 + x97
    x107 = 2.0 * x91
    x108 = x0 * (x107 + x79)
    x109 = x60 * x99
    x110 = x108 + x109
    x111 = x0 * (x62 + x96) + x104 * x60
    x112 = x0 * (x103 + x63 + x78 + x91) + x106 * x60
    x113 = 2.0 * x105
    x114 = x37 * x6
    x115 = x114 * (x0 * (x113 + x66 + 3.0 * x97 + x98) + x110 * x60)
    x116 = x114 * x4
    x117 = 3.14159265358979 * x1 * x35 * x6
    x118 = x117 * x4
    x119 = -x46 - C[2]
    x120 = x119 * x38
    x121 = x119 * x67
    x122 = x121 + x58
    x123 = x119 * x55
    x124 = x0 * (x123 + x67)
    x125 = x122 * x47
    x126 = x124 + x125
    x127 = x119 * x70
    x128 = x127 + x58
    x129 = x122 * x68
    x130 = x124 + x129
    x131 = 2.0 * x121
    x132 = x0 * (x131 + x84)
    x133 = x126 * x68
    x134 = x132 + x133
    x135 = x0 * (x123 + x70) + x128 * x68
    x136 = x0 * (x121 + x127 + x71 + x83) + x130 * x68
    x137 = 2.0 * x129
    x138 = x117 * (x0 * (3.0 * x124 + x125 + x137 + x75) + x134 * x68)
    x139 = x48 * x86**2
    x140 = x139 + x50
    x141 = x0 * (x17 + x18 + 2.0 * x93) + x23 * x88
    x142 = x140 * x40
    x143 = x65 * x86
    x144 = x142 + x143
    x145 = x10 + x93
    x146 = x0 * (x100 + x19) + x145 * x23
    x147 = x139 + x78
    x148 = x0 * (x107 + x147)
    x149 = x144 * x40
    x150 = x148 + x149
    x151 = x10 + x23**2 * x8
    x152 = x140 * x60
    x153 = x143 + x152
    x154 = x144 * x60
    x155 = x148 + x154
    x156 = 4.0 * x50 * x86 + 2.0 * x97
    x157 = x0 * (2.0 * x142 + x156 + 2.0 * x98) + x150 * x60
    x158 = x114 * x157
    x159 = x114 * x23
    x160 = x0 * (2.0 * x103 + x147) + x153 * x60
    x161 = x114 * (x0 * (x113 + x142 + x152 + x156) + x155 * x60)
    x162 = x114 * x3
    x163 = x117 * x86
    x164 = x119**2 * x55
    x165 = x164 + x58
    x166 = x165 * x47
    x167 = x119 * x74
    x168 = x166 + x167
    x169 = x164 + x83
    x170 = x0 * (x131 + x169)
    x171 = x168 * x47
    x172 = x170 + x171
    x173 = x117 * x23
    x174 = x165 * x68
    x175 = x167 + x174
    x176 = x168 * x68
    x177 = x170 + x176
    x178 = 4.0 * x119 * x58 + 2.0 * x124
    x179 = x0 * (2.0 * x125 + 2.0 * x166 + x178) + x172 * x68
    x180 = x117 * x179
    x181 = x117 * x3
    x182 = x0 * (2.0 * x127 + x169) + x175 * x68
    x183 = x117 * (x0 * (x137 + x166 + x174 + x178) + x177 * x68)

    # 216 item(s)
    return numpy.array(
        [
            x38
            * (x0 * (x16 + 2.0 * x22 + 2.0 * x29 + 2.0 * x30 + 3.0 * x31) + x23 * x34),
            x40 * x45,
            x45 * x47,
            x51 * x54 * x55,
            x40 * x54 * x56,
            x48 * x54 * x59,
            x60 * x61,
            x44 * x55 * x64,
            x44 * x56 * x60,
            x53 * x55 * x66,
            x53 * x64 * x67,
            x53 * x59 * x62,
            x61 * x68,
            x40 * x44 * x69,
            x44 * x48 * x72,
            x51 * x53 * x70,
            x53 * x72 * x73,
            x48 * x53 * x75,
            x33 * x55 * x76,
            x15 * x55 * x77,
            x15 * x67 * x76,
            x11 * x55 * x80,
            x11 * x67 * x77,
            x11 * x59 * x76,
            x33 * x60 * x69,
            x15 * x64 * x70,
            x15 * x62 * x72,
            x11 * x66 * x70,
            x11 * x64 * x72,
            x11 * x62 * x75,
            x33 * x48 * x81,
            x15 * x73 * x81,
            x15 * x48 * x82,
            x11 * x51 * x81,
            x11 * x73 * x82,
            x11 * x48 * x85,
            x86 * x90,
            x55 * x92 * x95,
            x56 * x86 * x95,
            x102 * x55 * x99,
            x102 * x67 * x92,
            x102 * x59 * x96,
            x104 * x55 * x89,
            x106 * x55 * x94,
            x104 * x67 * x94,
            x101 * x110 * x55,
            x101 * x106 * x67,
            x101 * x104 * x59,
            x69 * x86 * x89,
            x70 * x92 * x94,
            x72 * x94 * x96,
            x101 * x70 * x99,
            x101 * x72 * x92,
            x101 * x75 * x96,
            x111 * x28 * x55,
            x112 * x26 * x55,
            x111 * x26 * x67,
            x115 * x4,
            x112 * x116 * x47,
            x111 * x24 * x59,
            x104 * x28 * x70,
            x106 * x26 * x70,
            x104 * x26 * x72,
            x110 * x116 * x68,
            x106 * x24 * x72,
            x104 * x24 * x75,
            x28 * x81 * x96,
            x26 * x81 * x92,
            x26 * x82 * x96,
            x24 * x81 * x99,
            x24 * x82 * x92,
            x118 * x85 * x86,
            x119 * x90,
            x120 * x40 * x95,
            x122 * x48 * x95,
            x102 * x123 * x51,
            x102 * x122 * x73,
            x102 * x126 * x48,
            x120 * x60 * x89,
            x123 * x64 * x94,
            x122 * x62 * x94,
            x101 * x123 * x66,
            x101 * x122 * x64,
            x101 * x126 * x62,
            x128 * x48 * x89,
            x128 * x73 * x94,
            x130 * x48 * x94,
            x101 * x128 * x51,
            x101 * x130 * x73,
            x101 * x134 * x48,
            x123 * x28 * x76,
            x123 * x26 * x77,
            x122 * x26 * x76,
            x116 * x119 * x80,
            x122 * x24 * x77,
            x126 * x24 * x76,
            x128 * x28 * x62,
            x128 * x26 * x64,
            x130 * x26 * x62,
            x128 * x24 * x66,
            x130 * x24 * x64,
            x118 * x134 * x60,
            x135 * x28 * x48,
            x135 * x26 * x73,
            x136 * x26 * x48,
            x135 * x24 * x51,
            x118 * x136 * x40,
            x138 * x4,
            x140 * x141 * x55,
            x144 * x146 * x55,
            x140 * x146 * x67,
            x150 * x151 * x55,
            x144 * x151 * x67,
            x140 * x151 * x59,
            x153 * x55 * x88,
            x145 * x155 * x55,
            x145 * x153 * x67,
            x158 * x23,
            x155 * x159 * x47,
            x100 * x153 * x59,
            x140 * x70 * x88,
            x144 * x145 * x70,
            x140 * x145 * x72,
            x150 * x159 * x68,
            x100 * x144 * x72,
            x100 * x140 * x75,
            x160 * x55 * x87,
            x161 * x3,
            x160 * x162 * x47,
            x114
            * (
                x0 * (2.0 * x108 + 2.0 * x109 + 3.0 * x148 + x149 + 2.0 * x154)
                + x157 * x60
            ),
            x161 * x47,
            x160 * x59 * x8,
            x153 * x70 * x87,
            x155 * x162 * x68,
            x153 * x19 * x72,
            x158 * x68,
            x155 * x72 * x8,
            x153 * x75 * x8,
            x140 * x81 * x87,
            x144 * x19 * x81,
            x140 * x19 * x82,
            x150 * x8 * x81,
            x144 * x8 * x82,
            x140 * x8 * x85,
            x120 * x141 * x86,
            x123 * x146 * x92,
            x122 * x146 * x96,
            x123 * x151 * x99,
            x122 * x151 * x92,
            x126 * x151 * x96,
            x104 * x123 * x88,
            x106 * x123 * x145,
            x104 * x122 * x145,
            x110 * x119 * x159,
            x100 * x106 * x122,
            x100 * x104 * x126,
            x128 * x88 * x96,
            x128 * x145 * x92,
            x130 * x145 * x96,
            x100 * x128 * x99,
            x100 * x130 * x92,
            x134 * x163 * x23,
            x111 * x123 * x87,
            x112 * x119 * x162,
            x111 * x122 * x19,
            x115 * x119,
            x112 * x122 * x8,
            x111 * x126 * x8,
            x104 * x128 * x87,
            x106 * x128 * x19,
            x104 * x130 * x19,
            x110 * x128 * x8,
            x106 * x130 * x8,
            x104 * x134 * x8,
            x135 * x87 * x96,
            x135 * x19 * x92,
            x136 * x163 * x3,
            x135 * x8 * x99,
            x136 * x8 * x92,
            x138 * x86,
            x141 * x165 * x48,
            x146 * x165 * x73,
            x146 * x168 * x48,
            x151 * x165 * x51,
            x151 * x168 * x73,
            x151 * x172 * x48,
            x165 * x62 * x88,
            x145 * x165 * x64,
            x145 * x168 * x62,
            x100 * x165 * x66,
            x100 * x168 * x64,
            x172 * x173 * x60,
            x175 * x48 * x88,
            x145 * x175 * x73,
            x145 * x177 * x48,
            x100 * x175 * x51,
            x173 * x177 * x40,
            x180 * x23,
            x165 * x76 * x87,
            x165 * x19 * x77,
            x168 * x19 * x76,
            x165 * x8 * x80,
            x168 * x77 * x8,
            x172 * x76 * x8,
            x175 * x62 * x87,
            x175 * x19 * x64,
            x177 * x181 * x60,
            x175 * x66 * x8,
            x177 * x64 * x8,
            x180 * x60,
            x182 * x48 * x87,
            x181 * x182 * x40,
            x183 * x3,
            x182 * x51 * x8,
            x183 * x40,
            x117
            * (
                x0 * (2.0 * x132 + 2.0 * x133 + 3.0 * x170 + x171 + 2.0 * x176)
                + x179 * x68
            ),
        ]
    )


def quadrupole3d_23(a, A, b, B, C):
    """Cartesian 3D (df) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = -x2 - C[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = 1.77245385090552 * numpy.sqrt(x1)
    x8 = x6 * x7
    x9 = x4**2 * x8
    x10 = x0 * x8
    x11 = 3.0 * x10
    x12 = x3 * x8
    x13 = x12 * x4
    x14 = x11 + 2.0 * x13
    x15 = x0 * (x14 + x9)
    x16 = x10 + x9
    x17 = x16 * x3
    x18 = 2.0 * x10
    x19 = x18 * x4
    x20 = x17 + x19
    x21 = x20 * x3
    x22 = x15 + x21
    x23 = x22 * x3
    x24 = x4 * x8
    x25 = x0 * (x12 + x24)
    x26 = 3.0 * x25
    x27 = x10 + x13
    x28 = x27 * x3
    x29 = x3**2 * x8
    x30 = x10 + x29
    x31 = x3 * x30
    x32 = x18 * x3
    x33 = x31 + x32
    x34 = x0 * (x26 + 3.0 * x28 + x33)
    x35 = -x2 - A[0]
    x36 = x0 * (x14 + x29)
    x37 = x25 + x28
    x38 = x3 * x37
    x39 = x36 + x38
    x40 = x35 * x39
    x41 = x22 * x35
    x42 = 4.0 * x10 * x4 + 2.0 * x25
    x43 = x0 * (2.0 * x17 + 2.0 * x28 + x42)
    x44 = 3.0 * x15 + 2.0 * x36
    x45 = x23 + x43
    x46 = x0 * (3.0 * x21 + 2.0 * x38 + x44) + x35 * x45
    x47 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x48 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x49 = 3.14159265358979 * x1 * x48
    x50 = x47 * x49
    x51 = -x1 * (a * A[1] + b * B[1])
    x52 = -x51 - B[1]
    x53 = x35 * x37
    x54 = x20 * x35
    x55 = x41 + x43
    x56 = x50 * (x0 * (x21 + x44 + 2.0 * x53 + 2.0 * x54) + x35 * x55)
    x57 = -x1 * (a * A[2] + b * B[2])
    x58 = -x57 - B[2]
    x59 = x47 * x7
    x60 = x52**2 * x59
    x61 = x0 * x59
    x62 = x60 + x61
    x63 = x16 * x35
    x64 = x27 * x35
    x65 = 2.0 * x64
    x66 = x15 + x54
    x67 = x0 * (x17 + x42 + x63 + x65) + x35 * x66
    x68 = x48 * x7
    x69 = x50 * x58
    x70 = x58**2 * x68
    x71 = x0 * x68
    x72 = x70 + x71
    x73 = x52 * x62
    x74 = x52 * x61
    x75 = 2.0 * x74
    x76 = x73 + x75
    x77 = x24 * x35
    x78 = x19 + x63
    x79 = x0 * (x11 + 2.0 * x77 + x9) + x35 * x78
    x80 = x58 * x68
    x81 = x52 * x59
    x82 = x58 * x72
    x83 = x58 * x71
    x84 = 2.0 * x83
    x85 = x82 + x84
    x86 = -x51 - A[1]
    x87 = x46 * x50
    x88 = x59 * x86
    x89 = x52 * x88
    x90 = x61 + x89
    x91 = x62 * x86
    x92 = x75 + x91
    x93 = 3.0 * x61
    x94 = x0 * (3.0 * x60 + x93) + x76 * x86
    x95 = -x57 - A[2]
    x96 = x50 * x95
    x97 = x68 * x95
    x98 = x58 * x97
    x99 = x71 + x98
    x100 = x72 * x95
    x101 = x100 + x84
    x102 = 3.0 * x71
    x103 = x0 * (x102 + 3.0 * x70) + x85 * x95
    x104 = x59 * x86**2 + x61
    x105 = x0 * (x81 + x88) + x86 * x90
    x106 = x60 + x93
    x107 = x0 * (x106 + 2.0 * x89) + x86 * x92
    x108 = x0 * (x73 + 8.0 * x74 + 3.0 * x91) + x86 * x94
    x109 = x68 * x95**2 + x71
    x110 = x0 * (x80 + x97) + x95 * x99
    x111 = x102 + x70
    x112 = x0 * (x111 + 2.0 * x98) + x101 * x95
    x113 = x0 * (3.0 * x100 + x82 + 8.0 * x83) + x103 * x95
    x114 = -x51 - C[1]
    x115 = x0 * (x11 + 3.0 * x29) + x33 * x35
    x116 = x34 + x40
    x117 = x50 * (x0 * (x115 + 4.0 * x36 + x38 + 3.0 * x53) + x116 * x35)
    x118 = x114 * x81
    x119 = x118 + x61
    x120 = x30 * x35
    x121 = x120 + x32
    x122 = x36 + x53
    x123 = x0 * (x121 + x26 + x28 + x65) + x122 * x35
    x124 = x114 * x59
    x125 = x0 * (x124 + x81)
    x126 = x119 * x52
    x127 = x125 + x126
    x128 = x12 * x35
    x129 = x25 + x64
    x130 = x0 * (x11 + x128 + x13 + x77) + x129 * x35
    x131 = 2.0 * x118
    x132 = x0 * (x106 + x131)
    x133 = x127 * x52
    x134 = x132 + x133
    x135 = x35 * x8
    x136 = x10 + x77
    x137 = x0 * (x135 + x24) + x136 * x35
    x138 = x114 * x88
    x139 = x138 + x61
    x140 = x119 * x86
    x141 = x125 + x140
    x142 = x127 * x86
    x143 = x132 + x142
    x144 = 3.0 * x125
    x145 = x0 * (3.0 * x126 + x144 + x76)
    x146 = x134 * x86
    x147 = x145 + x146
    x148 = x0 * (x124 + x88) + x139 * x86
    x149 = x0 * (x118 + x138 + x89 + x93) + x141 * x86
    x150 = 2.0 * x140
    x151 = x0 * (x126 + x144 + x150 + x92) + x143 * x86
    x152 = x49 * x6
    x153 = x152 * (x0 * (4.0 * x132 + x133 + 3.0 * x142 + x94) + x147 * x86)
    x154 = x152 * x4
    x155 = 3.14159265358979 * x1 * x47 * x6
    x156 = x155 * x4
    x157 = -x57 - C[2]
    x158 = x157 * x50
    x159 = x157 * x80
    x160 = x159 + x71
    x161 = x157 * x68
    x162 = x0 * (x161 + x80)
    x163 = x160 * x58
    x164 = x162 + x163
    x165 = 2.0 * x159
    x166 = x0 * (x111 + x165)
    x167 = x164 * x58
    x168 = x166 + x167
    x169 = x157 * x97
    x170 = x169 + x71
    x171 = x160 * x95
    x172 = x162 + x171
    x173 = x164 * x95
    x174 = x166 + x173
    x175 = 3.0 * x162
    x176 = x0 * (3.0 * x163 + x175 + x85)
    x177 = x168 * x95
    x178 = x176 + x177
    x179 = x0 * (x161 + x97) + x170 * x95
    x180 = x0 * (x102 + x159 + x169 + x98) + x172 * x95
    x181 = 2.0 * x171
    x182 = x0 * (x101 + x163 + x175 + x181) + x174 * x95
    x183 = x155 * (x0 * (x103 + 4.0 * x166 + x167 + 3.0 * x173) + x178 * x95)
    x184 = x114**2 * x59
    x185 = x184 + x61
    x186 = x0 * (8.0 * x10 * x3 + 3.0 * x120 + x31) + x115 * x35
    x187 = x185 * x52
    x188 = x114 * x61
    x189 = 2.0 * x188
    x190 = x187 + x189
    x191 = x0 * (x11 + 2.0 * x128 + x29) + x121 * x35
    x192 = x184 + x93
    x193 = x0 * (x131 + x192)
    x194 = x190 * x52
    x195 = x193 + x194
    x196 = x10 + x128
    x197 = x0 * (x12 + x135) + x196 * x35
    x198 = 2.0 * x125 + 4.0 * x188
    x199 = x0 * (2.0 * x126 + 2.0 * x187 + x198)
    x200 = x195 * x52
    x201 = x199 + x200
    x202 = x10 + x35**2 * x8
    x203 = x185 * x86
    x204 = x189 + x203
    x205 = x190 * x86
    x206 = x193 + x205
    x207 = x195 * x86
    x208 = x199 + x207
    x209 = 2.0 * x132 + 3.0 * x193
    x210 = x0 * (2.0 * x133 + 3.0 * x194 + x209) + x201 * x86
    x211 = x152 * x210
    x212 = x152 * x35
    x213 = x0 * (2.0 * x138 + x192) + x204 * x86
    x214 = x0 * (x150 + x187 + x198 + x203) + x206 * x86
    x215 = x152 * (x0 * (2.0 * x142 + x194 + 2.0 * x205 + x209) + x208 * x86)
    x216 = x152 * x3
    x217 = x114 * x155
    x218 = x157**2 * x68
    x219 = x218 + x71
    x220 = x219 * x58
    x221 = x157 * x71
    x222 = 2.0 * x221
    x223 = x220 + x222
    x224 = x102 + x218
    x225 = x0 * (x165 + x224)
    x226 = x223 * x58
    x227 = x225 + x226
    x228 = 2.0 * x162 + 4.0 * x221
    x229 = x0 * (2.0 * x163 + 2.0 * x220 + x228)
    x230 = x227 * x58
    x231 = x229 + x230
    x232 = x155 * x35
    x233 = x219 * x95
    x234 = x222 + x233
    x235 = x223 * x95
    x236 = x225 + x235
    x237 = x227 * x95
    x238 = x229 + x237
    x239 = 2.0 * x166 + 3.0 * x225
    x240 = x0 * (2.0 * x167 + 3.0 * x226 + x239) + x231 * x95
    x241 = x155 * x240
    x242 = x155 * x3
    x243 = x0 * (2.0 * x169 + x224) + x234 * x95
    x244 = x0 * (x181 + x220 + x228 + x233) + x236 * x95
    x245 = x155 * (x0 * (2.0 * x173 + x226 + 2.0 * x235 + x239) + x238 * x95)

    # 360 item(s)
    return numpy.array(
        [
            x50
            * (x0 * (x23 + 2.0 * x34 + 2.0 * x40 + 3.0 * x41 + 4.0 * x43) + x35 * x46),
            x52 * x56,
            x56 * x58,
            x62 * x67 * x68,
            x52 * x67 * x69,
            x59 * x67 * x72,
            x68 * x76 * x79,
            x62 * x79 * x80,
            x72 * x79 * x81,
            x59 * x79 * x85,
            x86 * x87,
            x55 * x68 * x90,
            x55 * x69 * x86,
            x66 * x68 * x92,
            x66 * x80 * x90,
            x66 * x72 * x88,
            x68 * x78 * x94,
            x78 * x80 * x92,
            x72 * x78 * x90,
            x78 * x85 * x88,
            x87 * x95,
            x52 * x55 * x96,
            x55 * x59 * x99,
            x62 * x66 * x97,
            x66 * x81 * x99,
            x101 * x59 * x66,
            x76 * x78 * x97,
            x62 * x78 * x99,
            x101 * x78 * x81,
            x103 * x59 * x78,
            x104 * x45 * x68,
            x105 * x22 * x68,
            x104 * x22 * x80,
            x107 * x20 * x68,
            x105 * x20 * x80,
            x104 * x20 * x72,
            x108 * x16 * x68,
            x107 * x16 * x80,
            x105 * x16 * x72,
            x104 * x16 * x85,
            x45 * x86 * x96,
            x22 * x90 * x97,
            x22 * x88 * x99,
            x20 * x92 * x97,
            x20 * x90 * x99,
            x101 * x20 * x88,
            x16 * x94 * x97,
            x16 * x92 * x99,
            x101 * x16 * x90,
            x103 * x16 * x88,
            x109 * x45 * x59,
            x109 * x22 * x81,
            x110 * x22 * x59,
            x109 * x20 * x62,
            x110 * x20 * x81,
            x112 * x20 * x59,
            x109 * x16 * x76,
            x110 * x16 * x62,
            x112 * x16 * x81,
            x113 * x16 * x59,
            x114 * x117,
            x119 * x123 * x68,
            x114 * x123 * x69,
            x127 * x130 * x68,
            x119 * x130 * x80,
            x124 * x130 * x72,
            x134 * x137 * x68,
            x127 * x137 * x80,
            x119 * x137 * x72,
            x124 * x137 * x85,
            x116 * x139 * x68,
            x122 * x141 * x68,
            x122 * x139 * x80,
            x129 * x143 * x68,
            x129 * x141 * x80,
            x129 * x139 * x72,
            x136 * x147 * x68,
            x136 * x143 * x80,
            x136 * x141 * x72,
            x136 * x139 * x85,
            x114 * x116 * x96,
            x119 * x122 * x97,
            x122 * x124 * x99,
            x127 * x129 * x97,
            x119 * x129 * x99,
            x101 * x124 * x129,
            x134 * x136 * x97,
            x127 * x136 * x99,
            x101 * x119 * x136,
            x103 * x124 * x136,
            x148 * x39 * x68,
            x149 * x37 * x68,
            x148 * x37 * x80,
            x151 * x27 * x68,
            x149 * x27 * x80,
            x148 * x27 * x72,
            x153 * x4,
            x151 * x154 * x58,
            x149 * x24 * x72,
            x148 * x24 * x85,
            x139 * x39 * x97,
            x141 * x37 * x97,
            x139 * x37 * x99,
            x143 * x27 * x97,
            x141 * x27 * x99,
            x101 * x139 * x27,
            x147 * x154 * x95,
            x143 * x24 * x99,
            x101 * x141 * x24,
            x103 * x139 * x24,
            x109 * x124 * x39,
            x109 * x119 * x37,
            x110 * x124 * x37,
            x109 * x127 * x27,
            x110 * x119 * x27,
            x112 * x124 * x27,
            x109 * x134 * x24,
            x110 * x127 * x24,
            x112 * x119 * x24,
            x113 * x114 * x156,
            x117 * x157,
            x123 * x158 * x52,
            x123 * x160 * x59,
            x130 * x161 * x62,
            x130 * x160 * x81,
            x130 * x164 * x59,
            x137 * x161 * x76,
            x137 * x160 * x62,
            x137 * x164 * x81,
            x137 * x168 * x59,
            x116 * x158 * x86,
            x122 * x161 * x90,
            x122 * x160 * x88,
            x129 * x161 * x92,
            x129 * x160 * x90,
            x129 * x164 * x88,
            x136 * x161 * x94,
            x136 * x160 * x92,
            x136 * x164 * x90,
            x136 * x168 * x88,
            x116 * x170 * x59,
            x122 * x170 * x81,
            x122 * x172 * x59,
            x129 * x170 * x62,
            x129 * x172 * x81,
            x129 * x174 * x59,
            x136 * x170 * x76,
            x136 * x172 * x62,
            x136 * x174 * x81,
            x136 * x178 * x59,
            x104 * x161 * x39,
            x105 * x161 * x37,
            x104 * x160 * x37,
            x107 * x161 * x27,
            x105 * x160 * x27,
            x104 * x164 * x27,
            x108 * x154 * x157,
            x107 * x160 * x24,
            x105 * x164 * x24,
            x104 * x168 * x24,
            x170 * x39 * x88,
            x170 * x37 * x90,
            x172 * x37 * x88,
            x170 * x27 * x92,
            x172 * x27 * x90,
            x174 * x27 * x88,
            x170 * x24 * x94,
            x172 * x24 * x92,
            x174 * x24 * x90,
            x156 * x178 * x86,
            x179 * x39 * x59,
            x179 * x37 * x81,
            x180 * x37 * x59,
            x179 * x27 * x62,
            x180 * x27 * x81,
            x182 * x27 * x59,
            x179 * x24 * x76,
            x180 * x24 * x62,
            x156 * x182 * x52,
            x183 * x4,
            x185 * x186 * x68,
            x190 * x191 * x68,
            x185 * x191 * x80,
            x195 * x197 * x68,
            x190 * x197 * x80,
            x185 * x197 * x72,
            x201 * x202 * x68,
            x195 * x202 * x80,
            x190 * x202 * x72,
            x185 * x202 * x85,
            x115 * x204 * x68,
            x121 * x206 * x68,
            x121 * x204 * x80,
            x196 * x208 * x68,
            x196 * x206 * x80,
            x196 * x204 * x72,
            x211 * x35,
            x208 * x212 * x58,
            x135 * x206 * x72,
            x135 * x204 * x85,
            x115 * x185 * x97,
            x121 * x190 * x97,
            x121 * x185 * x99,
            x195 * x196 * x97,
            x190 * x196 * x99,
            x101 * x185 * x196,
            x201 * x212 * x95,
            x135 * x195 * x99,
            x101 * x135 * x190,
            x103 * x135 * x185,
            x213 * x33 * x68,
            x214 * x30 * x68,
            x213 * x30 * x80,
            x215 * x3,
            x214 * x216 * x58,
            x12 * x213 * x72,
            x152
            * (
                x0 * (2.0 * x145 + 2.0 * x146 + 4.0 * x199 + x200 + 3.0 * x207)
                + x210 * x86
            ),
            x215 * x58,
            x214 * x72 * x8,
            x213 * x8 * x85,
            x204 * x33 * x97,
            x206 * x30 * x97,
            x204 * x30 * x99,
            x208 * x216 * x95,
            x12 * x206 * x99,
            x101 * x12 * x204,
            x211 * x95,
            x208 * x8 * x99,
            x101 * x206 * x8,
            x103 * x204 * x8,
            x109 * x185 * x33,
            x109 * x190 * x30,
            x110 * x185 * x30,
            x109 * x12 * x195,
            x110 * x12 * x190,
            x112 * x12 * x185,
            x109 * x201 * x8,
            x110 * x195 * x8,
            x112 * x190 * x8,
            x113 * x185 * x8,
            x114 * x158 * x186,
            x119 * x161 * x191,
            x124 * x160 * x191,
            x127 * x161 * x197,
            x119 * x160 * x197,
            x124 * x164 * x197,
            x134 * x161 * x202,
            x127 * x160 * x202,
            x119 * x164 * x202,
            x124 * x168 * x202,
            x115 * x139 * x161,
            x121 * x141 * x161,
            x121 * x139 * x160,
            x143 * x161 * x196,
            x141 * x160 * x196,
            x139 * x164 * x196,
            x147 * x157 * x212,
            x135 * x143 * x160,
            x135 * x141 * x164,
            x135 * x139 * x168,
            x115 * x124 * x170,
            x119 * x121 * x170,
            x121 * x124 * x172,
            x127 * x170 * x196,
            x119 * x172 * x196,
            x124 * x174 * x196,
            x134 * x135 * x170,
            x127 * x135 * x172,
            x119 * x135 * x174,
            x178 * x217 * x35,
            x148 * x161 * x33,
            x149 * x161 * x30,
            x148 * x160 * x30,
            x151 * x157 * x216,
            x12 * x149 * x160,
            x12 * x148 * x164,
            x153 * x157,
            x151 * x160 * x8,
            x149 * x164 * x8,
            x148 * x168 * x8,
            x139 * x170 * x33,
            x141 * x170 * x30,
            x139 * x172 * x30,
            x12 * x143 * x170,
            x12 * x141 * x172,
            x12 * x139 * x174,
            x147 * x170 * x8,
            x143 * x172 * x8,
            x141 * x174 * x8,
            x139 * x178 * x8,
            x124 * x179 * x33,
            x119 * x179 * x30,
            x124 * x180 * x30,
            x12 * x127 * x179,
            x119 * x12 * x180,
            x182 * x217 * x3,
            x134 * x179 * x8,
            x127 * x180 * x8,
            x119 * x182 * x8,
            x114 * x183,
            x186 * x219 * x59,
            x191 * x219 * x81,
            x191 * x223 * x59,
            x197 * x219 * x62,
            x197 * x223 * x81,
            x197 * x227 * x59,
            x202 * x219 * x76,
            x202 * x223 * x62,
            x202 * x227 * x81,
            x202 * x231 * x59,
            x115 * x219 * x88,
            x121 * x219 * x90,
            x121 * x223 * x88,
            x196 * x219 * x92,
            x196 * x223 * x90,
            x196 * x227 * x88,
            x135 * x219 * x94,
            x135 * x223 * x92,
            x135 * x227 * x90,
            x231 * x232 * x86,
            x115 * x234 * x59,
            x121 * x234 * x81,
            x121 * x236 * x59,
            x196 * x234 * x62,
            x196 * x236 * x81,
            x196 * x238 * x59,
            x135 * x234 * x76,
            x135 * x236 * x62,
            x232 * x238 * x52,
            x241 * x35,
            x104 * x219 * x33,
            x105 * x219 * x30,
            x104 * x223 * x30,
            x107 * x12 * x219,
            x105 * x12 * x223,
            x104 * x12 * x227,
            x108 * x219 * x8,
            x107 * x223 * x8,
            x105 * x227 * x8,
            x104 * x231 * x8,
            x234 * x33 * x88,
            x234 * x30 * x90,
            x236 * x30 * x88,
            x12 * x234 * x92,
            x12 * x236 * x90,
            x238 * x242 * x86,
            x234 * x8 * x94,
            x236 * x8 * x92,
            x238 * x8 * x90,
            x241 * x86,
            x243 * x33 * x59,
            x243 * x30 * x81,
            x244 * x30 * x59,
            x12 * x243 * x62,
            x242 * x244 * x52,
            x245 * x3,
            x243 * x76 * x8,
            x244 * x62 * x8,
            x245 * x52,
            x155
            * (
                x0 * (2.0 * x176 + 2.0 * x177 + 4.0 * x229 + x230 + 3.0 * x237)
                + x240 * x95
            ),
        ]
    )


def quadrupole3d_24(a, A, b, B, C):
    """Cartesian 3D (dg) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = -x2 - C[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = 1.77245385090552 * numpy.sqrt(x1)
    x8 = x6 * x7
    x9 = x4**2 * x8
    x10 = x0 * x8
    x11 = x10 + x9
    x12 = x11 * x3
    x13 = x3 * x6
    x14 = x13 * x7
    x15 = x14 * x4
    x16 = x10 + x15
    x17 = x16 * x3
    x18 = x4 * x8
    x19 = x0 * (x14 + x18)
    x20 = x0 * x18
    x21 = 2.0 * x19 + 4.0 * x20
    x22 = x0 * (2.0 * x12 + 2.0 * x17 + x21)
    x23 = 3.0 * x10
    x24 = 2.0 * x15 + x23
    x25 = x0 * (x24 + x9)
    x26 = 2.0 * x20
    x27 = x12 + x26
    x28 = x27 * x3
    x29 = x25 + x28
    x30 = x29 * x3
    x31 = x22 + x30
    x32 = x3 * x31
    x33 = x3**2 * x8
    x34 = x0 * (x24 + x33)
    x35 = 4.0 * x34
    x36 = x17 + x19
    x37 = x3 * x36
    x38 = x0 * (x23 + 3.0 * x33)
    x39 = x10 + x33
    x40 = x3 * x39
    x41 = x0 * x14
    x42 = 2.0 * x41
    x43 = x40 + x42
    x44 = x3 * x43
    x45 = x38 + x44
    x46 = x0 * (x35 + 4.0 * x37 + x45)
    x47 = -x2 - A[0]
    x48 = 3.0 * x19
    x49 = x0 * (3.0 * x17 + x43 + x48)
    x50 = x34 + x37
    x51 = x3 * x50
    x52 = x49 + x51
    x53 = x47 * x52
    x54 = x31 * x47
    x55 = 3.0 * x25 + 2.0 * x34
    x56 = x0 * (3.0 * x28 + 2.0 * x37 + x55)
    x57 = 4.0 * x22 + 2.0 * x49
    x58 = x32 + x56
    x59 = x0 * (4.0 * x30 + 2.0 * x51 + x57) + x47 * x58
    x60 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x61 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x62 = 3.14159265358979 * x1 * x61
    x63 = x60 * x62
    x64 = -x1 * (a * A[1] + b * B[1])
    x65 = -x64 - B[1]
    x66 = x47 * x50
    x67 = x29 * x47
    x68 = x54 + x56
    x69 = x63 * (x0 * (x30 + x57 + 2.0 * x66 + 3.0 * x67) + x47 * x68)
    x70 = -x1 * (a * A[2] + b * B[2])
    x71 = -x70 - B[2]
    x72 = x60 * x7
    x73 = x65**2 * x72
    x74 = x0 * x72
    x75 = x73 + x74
    x76 = x36 * x47
    x77 = x27 * x47
    x78 = x22 + x67
    x79 = x0 * (x28 + x55 + 2.0 * x76 + 2.0 * x77) + x47 * x78
    x80 = x61 * x7
    x81 = x63 * x71
    x82 = x71**2 * x80
    x83 = x0 * x80
    x84 = x82 + x83
    x85 = x65 * x75
    x86 = x65 * x74
    x87 = 2.0 * x86
    x88 = x85 + x87
    x89 = x11 * x47
    x90 = x16 * x47
    x91 = 2.0 * x90
    x92 = x25 + x77
    x93 = x0 * (x12 + x21 + x89 + x91) + x47 * x92
    x94 = x71 * x80
    x95 = x65 * x72
    x96 = x71 * x84
    x97 = x71 * x83
    x98 = 2.0 * x97
    x99 = x96 + x98
    x100 = 3.0 * x74
    x101 = x0 * (x100 + 3.0 * x73)
    x102 = x65 * x88
    x103 = x101 + x102
    x104 = x18 * x47
    x105 = x26 + x89
    x106 = x0 * (2.0 * x104 + x23 + x9) + x105 * x47
    x107 = 3.0 * x83
    x108 = x0 * (x107 + 3.0 * x82)
    x109 = x71 * x99
    x110 = x108 + x109
    x111 = -x64 - A[1]
    x112 = x59 * x63
    x113 = x111 * x72
    x114 = x113 * x65
    x115 = x114 + x74
    x116 = x111 * x75
    x117 = x116 + x87
    x118 = x111 * x88
    x119 = x101 + x118
    x120 = 8.0 * x86
    x121 = x0 * (x120 + 4.0 * x85) + x103 * x111
    x122 = -x70 - A[2]
    x123 = x122 * x63
    x124 = x122 * x80
    x125 = x124 * x71
    x126 = x125 + x83
    x127 = x122 * x84
    x128 = x127 + x98
    x129 = x122 * x99
    x130 = x108 + x129
    x131 = 8.0 * x97
    x132 = x0 * (x131 + 4.0 * x96) + x110 * x122
    x133 = x111**2 * x72 + x74
    x134 = x0 * (x113 + x95) + x111 * x115
    x135 = x100 + x73
    x136 = x0 * (2.0 * x114 + x135) + x111 * x117
    x137 = x0 * (3.0 * x116 + x120 + x85) + x111 * x119
    x138 = x0 * (5.0 * x101 + x102 + 4.0 * x118) + x111 * x121
    x139 = x122**2 * x80 + x83
    x140 = x0 * (x124 + x94) + x122 * x126
    x141 = x107 + x82
    x142 = x0 * (2.0 * x125 + x141) + x122 * x128
    x143 = x0 * (3.0 * x127 + x131 + x96) + x122 * x130
    x144 = x0 * (5.0 * x108 + x109 + 4.0 * x129) + x122 * x132
    x145 = -x64 - C[1]
    x146 = 8.0 * x41
    x147 = x0 * (x146 + 4.0 * x40) + x45 * x47
    x148 = x46 + x53
    x149 = x63 * (x0 * (x147 + 5.0 * x49 + x51 + 4.0 * x66) + x148 * x47)
    x150 = x145 * x95
    x151 = x150 + x74
    x152 = x43 * x47
    x153 = x152 + x38
    x154 = x49 + x66
    x155 = x0 * (x153 + x35 + x37 + 3.0 * x76) + x154 * x47
    x156 = x145 * x72
    x157 = x0 * (x156 + x95)
    x158 = x151 * x65
    x159 = x157 + x158
    x160 = x39 * x47
    x161 = x160 + x42
    x162 = x34 + x76
    x163 = x0 * (x161 + x17 + x48 + x91) + x162 * x47
    x164 = 2.0 * x150
    x165 = x0 * (x135 + x164)
    x166 = x159 * x65
    x167 = x165 + x166
    x168 = x14 * x47
    x169 = x19 + x90
    x170 = x0 * (x104 + x15 + x168 + x23) + x169 * x47
    x171 = 3.0 * x157
    x172 = x0 * (3.0 * x158 + x171 + x88)
    x173 = x167 * x65
    x174 = x172 + x173
    x175 = x47 * x8
    x176 = x10 + x104
    x177 = x0 * (x175 + x18) + x176 * x47
    x178 = x113 * x145
    x179 = x178 + x74
    x180 = x111 * x151
    x181 = x157 + x180
    x182 = x111 * x159
    x183 = x165 + x182
    x184 = x111 * x167
    x185 = x172 + x184
    x186 = 4.0 * x165
    x187 = x0 * (x103 + 4.0 * x166 + x186)
    x188 = x111 * x174
    x189 = x187 + x188
    x190 = x0 * (x113 + x156) + x111 * x179
    x191 = x0 * (x100 + x114 + x150 + x178) + x111 * x181
    x192 = 2.0 * x180
    x193 = x0 * (x117 + x158 + x171 + x192) + x111 * x183
    x194 = x0 * (x119 + x166 + 3.0 * x182 + x186) + x111 * x185
    x195 = x6 * x62
    x196 = x195 * (x0 * (x121 + 5.0 * x172 + x173 + 4.0 * x184) + x111 * x189)
    x197 = x195 * x71
    x198 = x195 * x4
    x199 = 3.14159265358979 * x1 * x60
    x200 = x199 * x6
    x201 = x200 * x4
    x202 = -x70 - C[2]
    x203 = x202 * x63
    x204 = x202 * x94
    x205 = x204 + x83
    x206 = x202 * x80
    x207 = x0 * (x206 + x94)
    x208 = x205 * x71
    x209 = x207 + x208
    x210 = 2.0 * x204
    x211 = x0 * (x141 + x210)
    x212 = x209 * x71
    x213 = x211 + x212
    x214 = 3.0 * x207
    x215 = x0 * (3.0 * x208 + x214 + x99)
    x216 = x213 * x71
    x217 = x215 + x216
    x218 = x124 * x202
    x219 = x218 + x83
    x220 = x122 * x205
    x221 = x207 + x220
    x222 = x122 * x209
    x223 = x211 + x222
    x224 = x122 * x213
    x225 = x215 + x224
    x226 = 4.0 * x211
    x227 = x0 * (x110 + 4.0 * x212 + x226)
    x228 = x122 * x217
    x229 = x227 + x228
    x230 = x0 * (x124 + x206) + x122 * x219
    x231 = x0 * (x107 + x125 + x204 + x218) + x122 * x221
    x232 = 2.0 * x220
    x233 = x0 * (x128 + x208 + x214 + x232) + x122 * x223
    x234 = x0 * (x130 + x212 + 3.0 * x222 + x226) + x122 * x225
    x235 = x200 * x65
    x236 = x200 * (x0 * (x132 + 5.0 * x215 + x216 + 4.0 * x224) + x122 * x229)
    x237 = x145**2 * x72
    x238 = x237 + x74
    x239 = x0 * (4.0 * x152 + 5.0 * x38 + x44) + x147 * x47
    x240 = x238 * x65
    x241 = x145 * x74
    x242 = 2.0 * x241
    x243 = x240 + x242
    x244 = x0 * (x146 + 3.0 * x160 + x40) + x153 * x47
    x245 = x100 + x237
    x246 = x0 * (x164 + x245)
    x247 = x243 * x65
    x248 = x246 + x247
    x249 = x0 * (2.0 * x168 + x23 + x33) + x161 * x47
    x250 = 2.0 * x157 + 4.0 * x241
    x251 = x0 * (2.0 * x158 + 2.0 * x240 + x250)
    x252 = x248 * x65
    x253 = x251 + x252
    x254 = x10 + x168
    x255 = x0 * (x14 + x175) + x254 * x47
    x256 = 2.0 * x165 + 3.0 * x246
    x257 = x0 * (2.0 * x166 + 3.0 * x247 + x256)
    x258 = x253 * x65
    x259 = x257 + x258
    x260 = x10 + x47**2 * x8
    x261 = x111 * x238
    x262 = x242 + x261
    x263 = x111 * x243
    x264 = x246 + x263
    x265 = x111 * x248
    x266 = x251 + x265
    x267 = x111 * x253
    x268 = x257 + x267
    x269 = 2.0 * x172 + 4.0 * x251
    x270 = x0 * (2.0 * x173 + 4.0 * x252 + x269) + x111 * x259
    x271 = x195 * x270
    x272 = x195 * x47
    x273 = x0 * (2.0 * x178 + x245) + x111 * x262
    x274 = x0 * (x192 + x240 + x250 + x261) + x111 * x264
    x275 = x0 * (2.0 * x182 + x247 + x256 + 2.0 * x263) + x111 * x266
    x276 = x0 * (2.0 * x184 + x252 + 3.0 * x265 + x269) + x111 * x268
    x277 = x13 * x62
    x278 = x200 * x47
    x279 = x13 * x199
    x280 = x202**2 * x80
    x281 = x280 + x83
    x282 = x281 * x71
    x283 = x202 * x83
    x284 = 2.0 * x283
    x285 = x282 + x284
    x286 = x107 + x280
    x287 = x0 * (x210 + x286)
    x288 = x285 * x71
    x289 = x287 + x288
    x290 = 2.0 * x207 + 4.0 * x283
    x291 = x0 * (2.0 * x208 + 2.0 * x282 + x290)
    x292 = x289 * x71
    x293 = x291 + x292
    x294 = 2.0 * x211 + 3.0 * x287
    x295 = x0 * (2.0 * x212 + 3.0 * x288 + x294)
    x296 = x293 * x71
    x297 = x295 + x296
    x298 = x122 * x281
    x299 = x284 + x298
    x300 = x122 * x285
    x301 = x287 + x300
    x302 = x122 * x289
    x303 = x291 + x302
    x304 = x122 * x293
    x305 = x295 + x304
    x306 = 2.0 * x215 + 4.0 * x291
    x307 = x0 * (2.0 * x216 + 4.0 * x292 + x306) + x122 * x297
    x308 = x200 * x307
    x309 = x0 * (2.0 * x218 + x286) + x122 * x299
    x310 = x0 * (x232 + x282 + x290 + x298) + x122 * x301
    x311 = x0 * (2.0 * x222 + x288 + x294 + 2.0 * x300) + x122 * x303
    x312 = x0 * (2.0 * x224 + x292 + 3.0 * x302 + x306) + x122 * x305

    # 540 item(s)
    return numpy.array(
        [
            x63
            * (x0 * (x32 + 2.0 * x46 + 2.0 * x53 + 4.0 * x54 + 5.0 * x56) + x47 * x59),
            x65 * x69,
            x69 * x71,
            x75 * x79 * x80,
            x65 * x79 * x81,
            x72 * x79 * x84,
            x80 * x88 * x93,
            x75 * x93 * x94,
            x84 * x93 * x95,
            x72 * x93 * x99,
            x103 * x106 * x80,
            x106 * x88 * x94,
            x106 * x75 * x84,
            x106 * x95 * x99,
            x106 * x110 * x72,
            x111 * x112,
            x115 * x68 * x80,
            x111 * x68 * x81,
            x117 * x78 * x80,
            x115 * x78 * x94,
            x113 * x78 * x84,
            x119 * x80 * x92,
            x117 * x92 * x94,
            x115 * x84 * x92,
            x113 * x92 * x99,
            x105 * x121 * x80,
            x105 * x119 * x94,
            x105 * x117 * x84,
            x105 * x115 * x99,
            x105 * x110 * x113,
            x112 * x122,
            x123 * x65 * x68,
            x126 * x68 * x72,
            x124 * x75 * x78,
            x126 * x78 * x95,
            x128 * x72 * x78,
            x124 * x88 * x92,
            x126 * x75 * x92,
            x128 * x92 * x95,
            x130 * x72 * x92,
            x103 * x105 * x124,
            x105 * x126 * x88,
            x105 * x128 * x75,
            x105 * x130 * x95,
            x105 * x132 * x72,
            x133 * x58 * x80,
            x134 * x31 * x80,
            x133 * x31 * x94,
            x136 * x29 * x80,
            x134 * x29 * x94,
            x133 * x29 * x84,
            x137 * x27 * x80,
            x136 * x27 * x94,
            x134 * x27 * x84,
            x133 * x27 * x99,
            x11 * x138 * x80,
            x11 * x137 * x94,
            x11 * x136 * x84,
            x11 * x134 * x99,
            x11 * x110 * x133,
            x111 * x123 * x58,
            x115 * x124 * x31,
            x113 * x126 * x31,
            x117 * x124 * x29,
            x115 * x126 * x29,
            x113 * x128 * x29,
            x119 * x124 * x27,
            x117 * x126 * x27,
            x115 * x128 * x27,
            x113 * x130 * x27,
            x11 * x121 * x124,
            x11 * x119 * x126,
            x11 * x117 * x128,
            x11 * x115 * x130,
            x11 * x113 * x132,
            x139 * x58 * x72,
            x139 * x31 * x95,
            x140 * x31 * x72,
            x139 * x29 * x75,
            x140 * x29 * x95,
            x142 * x29 * x72,
            x139 * x27 * x88,
            x140 * x27 * x75,
            x142 * x27 * x95,
            x143 * x27 * x72,
            x103 * x11 * x139,
            x11 * x140 * x88,
            x11 * x142 * x75,
            x11 * x143 * x95,
            x11 * x144 * x72,
            x145 * x149,
            x151 * x155 * x80,
            x145 * x155 * x81,
            x159 * x163 * x80,
            x151 * x163 * x94,
            x156 * x163 * x84,
            x167 * x170 * x80,
            x159 * x170 * x94,
            x151 * x170 * x84,
            x156 * x170 * x99,
            x174 * x177 * x80,
            x167 * x177 * x94,
            x159 * x177 * x84,
            x151 * x177 * x99,
            x110 * x156 * x177,
            x148 * x179 * x80,
            x154 * x181 * x80,
            x154 * x179 * x94,
            x162 * x183 * x80,
            x162 * x181 * x94,
            x162 * x179 * x84,
            x169 * x185 * x80,
            x169 * x183 * x94,
            x169 * x181 * x84,
            x169 * x179 * x99,
            x176 * x189 * x80,
            x176 * x185 * x94,
            x176 * x183 * x84,
            x176 * x181 * x99,
            x110 * x176 * x179,
            x123 * x145 * x148,
            x124 * x151 * x154,
            x126 * x154 * x156,
            x124 * x159 * x162,
            x126 * x151 * x162,
            x128 * x156 * x162,
            x124 * x167 * x169,
            x126 * x159 * x169,
            x128 * x151 * x169,
            x130 * x156 * x169,
            x124 * x174 * x176,
            x126 * x167 * x176,
            x128 * x159 * x176,
            x130 * x151 * x176,
            x132 * x156 * x176,
            x190 * x52 * x80,
            x191 * x50 * x80,
            x190 * x50 * x94,
            x193 * x36 * x80,
            x191 * x36 * x94,
            x190 * x36 * x84,
            x16 * x194 * x80,
            x16 * x193 * x94,
            x16 * x191 * x84,
            x16 * x190 * x99,
            x196 * x4,
            x194 * x197 * x4,
            x18 * x193 * x84,
            x18 * x191 * x99,
            x110 * x18 * x190,
            x124 * x179 * x52,
            x124 * x181 * x50,
            x126 * x179 * x50,
            x124 * x183 * x36,
            x126 * x181 * x36,
            x128 * x179 * x36,
            x124 * x16 * x185,
            x126 * x16 * x183,
            x128 * x16 * x181,
            x130 * x16 * x179,
            x122 * x189 * x198,
            x126 * x18 * x185,
            x128 * x18 * x183,
            x130 * x18 * x181,
            x132 * x179 * x18,
            x139 * x156 * x52,
            x139 * x151 * x50,
            x140 * x156 * x50,
            x139 * x159 * x36,
            x140 * x151 * x36,
            x142 * x156 * x36,
            x139 * x16 * x167,
            x140 * x159 * x16,
            x142 * x151 * x16,
            x143 * x156 * x16,
            x139 * x174 * x18,
            x140 * x167 * x18,
            x142 * x159 * x18,
            x143 * x151 * x18,
            x144 * x145 * x201,
            x149 * x202,
            x155 * x203 * x65,
            x155 * x205 * x72,
            x163 * x206 * x75,
            x163 * x205 * x95,
            x163 * x209 * x72,
            x170 * x206 * x88,
            x170 * x205 * x75,
            x170 * x209 * x95,
            x170 * x213 * x72,
            x103 * x177 * x206,
            x177 * x205 * x88,
            x177 * x209 * x75,
            x177 * x213 * x95,
            x177 * x217 * x72,
            x111 * x148 * x203,
            x115 * x154 * x206,
            x113 * x154 * x205,
            x117 * x162 * x206,
            x115 * x162 * x205,
            x113 * x162 * x209,
            x119 * x169 * x206,
            x117 * x169 * x205,
            x115 * x169 * x209,
            x113 * x169 * x213,
            x121 * x176 * x206,
            x119 * x176 * x205,
            x117 * x176 * x209,
            x115 * x176 * x213,
            x113 * x176 * x217,
            x148 * x219 * x72,
            x154 * x219 * x95,
            x154 * x221 * x72,
            x162 * x219 * x75,
            x162 * x221 * x95,
            x162 * x223 * x72,
            x169 * x219 * x88,
            x169 * x221 * x75,
            x169 * x223 * x95,
            x169 * x225 * x72,
            x103 * x176 * x219,
            x176 * x221 * x88,
            x176 * x223 * x75,
            x176 * x225 * x95,
            x176 * x229 * x72,
            x133 * x206 * x52,
            x134 * x206 * x50,
            x133 * x205 * x50,
            x136 * x206 * x36,
            x134 * x205 * x36,
            x133 * x209 * x36,
            x137 * x16 * x206,
            x136 * x16 * x205,
            x134 * x16 * x209,
            x133 * x16 * x213,
            x138 * x198 * x202,
            x137 * x18 * x205,
            x136 * x18 * x209,
            x134 * x18 * x213,
            x133 * x18 * x217,
            x113 * x219 * x52,
            x115 * x219 * x50,
            x113 * x221 * x50,
            x117 * x219 * x36,
            x115 * x221 * x36,
            x113 * x223 * x36,
            x119 * x16 * x219,
            x117 * x16 * x221,
            x115 * x16 * x223,
            x113 * x16 * x225,
            x121 * x18 * x219,
            x119 * x18 * x221,
            x117 * x18 * x223,
            x115 * x18 * x225,
            x111 * x201 * x229,
            x230 * x52 * x72,
            x230 * x50 * x95,
            x231 * x50 * x72,
            x230 * x36 * x75,
            x231 * x36 * x95,
            x233 * x36 * x72,
            x16 * x230 * x88,
            x16 * x231 * x75,
            x16 * x233 * x95,
            x16 * x234 * x72,
            x103 * x18 * x230,
            x18 * x231 * x88,
            x18 * x233 * x75,
            x234 * x235 * x4,
            x236 * x4,
            x238 * x239 * x80,
            x243 * x244 * x80,
            x238 * x244 * x94,
            x248 * x249 * x80,
            x243 * x249 * x94,
            x238 * x249 * x84,
            x253 * x255 * x80,
            x248 * x255 * x94,
            x243 * x255 * x84,
            x238 * x255 * x99,
            x259 * x260 * x80,
            x253 * x260 * x94,
            x248 * x260 * x84,
            x243 * x260 * x99,
            x110 * x238 * x260,
            x147 * x262 * x80,
            x153 * x264 * x80,
            x153 * x262 * x94,
            x161 * x266 * x80,
            x161 * x264 * x94,
            x161 * x262 * x84,
            x254 * x268 * x80,
            x254 * x266 * x94,
            x254 * x264 * x84,
            x254 * x262 * x99,
            x271 * x47,
            x197 * x268 * x47,
            x175 * x266 * x84,
            x175 * x264 * x99,
            x110 * x175 * x262,
            x124 * x147 * x238,
            x124 * x153 * x243,
            x126 * x153 * x238,
            x124 * x161 * x248,
            x126 * x161 * x243,
            x128 * x161 * x238,
            x124 * x253 * x254,
            x126 * x248 * x254,
            x128 * x243 * x254,
            x130 * x238 * x254,
            x122 * x259 * x272,
            x126 * x175 * x253,
            x128 * x175 * x248,
            x130 * x175 * x243,
            x132 * x175 * x238,
            x273 * x45 * x80,
            x274 * x43 * x80,
            x273 * x43 * x94,
            x275 * x39 * x80,
            x274 * x39 * x94,
            x273 * x39 * x84,
            x276 * x277,
            x275 * x277 * x71,
            x14 * x274 * x84,
            x14 * x273 * x99,
            x195
            * (
                x0 * (2.0 * x187 + 2.0 * x188 + 5.0 * x257 + x258 + 4.0 * x267)
                + x111 * x270
            ),
            x197 * x276,
            x275 * x8 * x84,
            x274 * x8 * x99,
            x110 * x273 * x8,
            x124 * x262 * x45,
            x124 * x264 * x43,
            x126 * x262 * x43,
            x124 * x266 * x39,
            x126 * x264 * x39,
            x128 * x262 * x39,
            x122 * x268 * x277,
            x126 * x14 * x266,
            x128 * x14 * x264,
            x130 * x14 * x262,
            x122 * x271,
            x126 * x268 * x8,
            x128 * x266 * x8,
            x130 * x264 * x8,
            x132 * x262 * x8,
            x139 * x238 * x45,
            x139 * x243 * x43,
            x140 * x238 * x43,
            x139 * x248 * x39,
            x140 * x243 * x39,
            x142 * x238 * x39,
            x139 * x14 * x253,
            x14 * x140 * x248,
            x14 * x142 * x243,
            x14 * x143 * x238,
            x139 * x259 * x8,
            x140 * x253 * x8,
            x142 * x248 * x8,
            x143 * x243 * x8,
            x144 * x238 * x8,
            x145 * x203 * x239,
            x151 * x206 * x244,
            x156 * x205 * x244,
            x159 * x206 * x249,
            x151 * x205 * x249,
            x156 * x209 * x249,
            x167 * x206 * x255,
            x159 * x205 * x255,
            x151 * x209 * x255,
            x156 * x213 * x255,
            x174 * x206 * x260,
            x167 * x205 * x260,
            x159 * x209 * x260,
            x151 * x213 * x260,
            x156 * x217 * x260,
            x147 * x179 * x206,
            x153 * x181 * x206,
            x153 * x179 * x205,
            x161 * x183 * x206,
            x161 * x181 * x205,
            x161 * x179 * x209,
            x185 * x206 * x254,
            x183 * x205 * x254,
            x181 * x209 * x254,
            x179 * x213 * x254,
            x189 * x202 * x272,
            x175 * x185 * x205,
            x175 * x183 * x209,
            x175 * x181 * x213,
            x175 * x179 * x217,
            x147 * x156 * x219,
            x151 * x153 * x219,
            x153 * x156 * x221,
            x159 * x161 * x219,
            x151 * x161 * x221,
            x156 * x161 * x223,
            x167 * x219 * x254,
            x159 * x221 * x254,
            x151 * x223 * x254,
            x156 * x225 * x254,
            x174 * x175 * x219,
            x167 * x175 * x221,
            x159 * x175 * x223,
            x151 * x175 * x225,
            x145 * x229 * x278,
            x190 * x206 * x45,
            x191 * x206 * x43,
            x190 * x205 * x43,
            x193 * x206 * x39,
            x191 * x205 * x39,
            x190 * x209 * x39,
            x194 * x202 * x277,
            x14 * x193 * x205,
            x14 * x191 * x209,
            x14 * x190 * x213,
            x196 * x202,
            x194 * x205 * x8,
            x193 * x209 * x8,
            x191 * x213 * x8,
            x190 * x217 * x8,
            x179 * x219 * x45,
            x181 * x219 * x43,
            x179 * x221 * x43,
            x183 * x219 * x39,
            x181 * x221 * x39,
            x179 * x223 * x39,
            x14 * x185 * x219,
            x14 * x183 * x221,
            x14 * x181 * x223,
            x14 * x179 * x225,
            x189 * x219 * x8,
            x185 * x221 * x8,
            x183 * x223 * x8,
            x181 * x225 * x8,
            x179 * x229 * x8,
            x156 * x230 * x45,
            x151 * x230 * x43,
            x156 * x231 * x43,
            x159 * x230 * x39,
            x151 * x231 * x39,
            x156 * x233 * x39,
            x14 * x167 * x230,
            x14 * x159 * x231,
            x14 * x151 * x233,
            x145 * x234 * x279,
            x174 * x230 * x8,
            x167 * x231 * x8,
            x159 * x233 * x8,
            x151 * x234 * x8,
            x145 * x236,
            x239 * x281 * x72,
            x244 * x281 * x95,
            x244 * x285 * x72,
            x249 * x281 * x75,
            x249 * x285 * x95,
            x249 * x289 * x72,
            x255 * x281 * x88,
            x255 * x285 * x75,
            x255 * x289 * x95,
            x255 * x293 * x72,
            x103 * x260 * x281,
            x260 * x285 * x88,
            x260 * x289 * x75,
            x260 * x293 * x95,
            x260 * x297 * x72,
            x113 * x147 * x281,
            x115 * x153 * x281,
            x113 * x153 * x285,
            x117 * x161 * x281,
            x115 * x161 * x285,
            x113 * x161 * x289,
            x119 * x254 * x281,
            x117 * x254 * x285,
            x115 * x254 * x289,
            x113 * x254 * x293,
            x121 * x175 * x281,
            x119 * x175 * x285,
            x117 * x175 * x289,
            x115 * x175 * x293,
            x111 * x278 * x297,
            x147 * x299 * x72,
            x153 * x299 * x95,
            x153 * x301 * x72,
            x161 * x299 * x75,
            x161 * x301 * x95,
            x161 * x303 * x72,
            x254 * x299 * x88,
            x254 * x301 * x75,
            x254 * x303 * x95,
            x254 * x305 * x72,
            x103 * x175 * x299,
            x175 * x301 * x88,
            x175 * x303 * x75,
            x235 * x305 * x47,
            x308 * x47,
            x133 * x281 * x45,
            x134 * x281 * x43,
            x133 * x285 * x43,
            x136 * x281 * x39,
            x134 * x285 * x39,
            x133 * x289 * x39,
            x137 * x14 * x281,
            x136 * x14 * x285,
            x134 * x14 * x289,
            x133 * x14 * x293,
            x138 * x281 * x8,
            x137 * x285 * x8,
            x136 * x289 * x8,
            x134 * x293 * x8,
            x133 * x297 * x8,
            x113 * x299 * x45,
            x115 * x299 * x43,
            x113 * x301 * x43,
            x117 * x299 * x39,
            x115 * x301 * x39,
            x113 * x303 * x39,
            x119 * x14 * x299,
            x117 * x14 * x301,
            x115 * x14 * x303,
            x111 * x279 * x305,
            x121 * x299 * x8,
            x119 * x301 * x8,
            x117 * x303 * x8,
            x115 * x305 * x8,
            x111 * x308,
            x309 * x45 * x72,
            x309 * x43 * x95,
            x310 * x43 * x72,
            x309 * x39 * x75,
            x310 * x39 * x95,
            x311 * x39 * x72,
            x14 * x309 * x88,
            x14 * x310 * x75,
            x279 * x311 * x65,
            x279 * x312,
            x103 * x309 * x8,
            x310 * x8 * x88,
            x311 * x75 * x8,
            x235 * x312,
            x200
            * (
                x0 * (2.0 * x227 + 2.0 * x228 + 5.0 * x295 + x296 + 4.0 * x304)
                + x122 * x307
            ),
        ]
    )


def quadrupole3d_30(a, A, b, B, C):
    """Cartesian 3D (fs) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = 1.77245385090552 * numpy.sqrt(x1)
    x3 = -x1 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = x4 * x6
    x8 = x2 * x7
    x9 = -x3 - C[0]
    x10 = x2 * x6
    x11 = x10 * x9
    x12 = x0 * (x11 + x8)
    x13 = x10 * x9**2
    x14 = x0 * x10
    x15 = x13 + x14
    x16 = x15 * x4
    x17 = x8 * x9
    x18 = x14 + x17
    x19 = x18 * x4
    x20 = x0 * x11
    x21 = 3.0 * x14 + 2.0 * x17
    x22 = x16 + 2.0 * x20
    x23 = x0 * (x13 + x21) + x22 * x4
    x24 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x25 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x26 = 3.14159265358979 * x1 * x25
    x27 = x24 * x26
    x28 = -x1 * (a * A[1] + b * B[1])
    x29 = -x28 - A[1]
    x30 = x23 * x27
    x31 = -x1 * (a * A[2] + b * B[2])
    x32 = -x31 - A[2]
    x33 = x2 * x24
    x34 = x29**2 * x33
    x35 = x0 * x33
    x36 = x34 + x35
    x37 = x2 * x25
    x38 = x27 * x32
    x39 = x32**2 * x37
    x40 = x0 * x37
    x41 = x39 + x40
    x42 = 2.0 * x35
    x43 = x29 * x36 + x29 * x42
    x44 = x32 * x37
    x45 = x29 * x33
    x46 = 2.0 * x40
    x47 = x32 * x41 + x32 * x46
    x48 = -x28 - C[1]
    x49 = x10 * x4**2
    x50 = x12 + x19
    x51 = x27 * (x0 * (x21 + x49) + x4 * x50)
    x52 = x45 * x48
    x53 = x35 + x52
    x54 = x33 * x48
    x55 = x0 * (x45 + x54)
    x56 = x29 * x53
    x57 = x55 + x56
    x58 = 3.0 * x35 + 2.0 * x52
    x59 = x26 * x6
    x60 = x59 * (x0 * (x34 + x58) + x29 * x57)
    x61 = x32 * x59
    x62 = 3.14159265358979 * x1 * x24
    x63 = x6 * x62
    x64 = -x31 - C[2]
    x65 = x27 * x64
    x66 = x44 * x64
    x67 = x40 + x66
    x68 = x37 * x64
    x69 = x0 * (x44 + x68)
    x70 = x32 * x67
    x71 = x69 + x70
    x72 = x29 * x63
    x73 = 3.0 * x40 + 2.0 * x66
    x74 = x63 * (x0 * (x39 + x73) + x32 * x71)
    x75 = x33 * x48**2
    x76 = x35 + x75
    x77 = x14 + x49
    x78 = 2.0 * x0 * x8 + x4 * x77
    x79 = x29 * x76
    x80 = x42 * x48 + x79
    x81 = x0 * (x58 + x75) + x29 * x80
    x82 = x26 * x7
    x83 = x62 * x7
    x84 = x37 * x64**2
    x85 = x40 + x84
    x86 = x32 * x85
    x87 = x46 * x64 + x86
    x88 = x0 * (x73 + x84) + x32 * x87

    # 60 item(s)
    return numpy.array(
        [
            x27 * (x0 * (2.0 * x12 + 2.0 * x16 + 2.0 * x19 + 4.0 * x20) + x23 * x4),
            x29 * x30,
            x30 * x32,
            x22 * x36 * x37,
            x22 * x29 * x38,
            x22 * x33 * x41,
            x15 * x37 * x43,
            x15 * x36 * x44,
            x15 * x41 * x45,
            x15 * x33 * x47,
            x48 * x51,
            x37 * x50 * x53,
            x38 * x48 * x50,
            x18 * x37 * x57,
            x18 * x44 * x53,
            x18 * x41 * x54,
            x60 * x9,
            x57 * x61 * x9,
            x11 * x41 * x53,
            x47 * x48 * x63 * x9,
            x51 * x64,
            x29 * x50 * x65,
            x33 * x50 * x67,
            x18 * x36 * x68,
            x18 * x45 * x67,
            x18 * x33 * x71,
            x43 * x59 * x64 * x9,
            x11 * x36 * x67,
            x71 * x72 * x9,
            x74 * x9,
            x37 * x76 * x78,
            x37 * x77 * x80,
            x44 * x76 * x77,
            x81 * x82,
            x32 * x80 * x82,
            x41 * x76 * x8,
            x59
            * (x0 * (4.0 * x35 * x48 + 2.0 * x55 + 2.0 * x56 + 2.0 * x79) + x29 * x81),
            x61 * x81,
            x10 * x41 * x80,
            x10 * x47 * x76,
            x48 * x65 * x78,
            x53 * x68 * x77,
            x54 * x67 * x77,
            x57 * x64 * x82,
            x53 * x67 * x8,
            x48 * x71 * x83,
            x60 * x64,
            x10 * x57 * x67,
            x10 * x53 * x71,
            x48 * x74,
            x33 * x78 * x85,
            x45 * x77 * x85,
            x33 * x77 * x87,
            x36 * x8 * x85,
            x29 * x83 * x87,
            x83 * x88,
            x10 * x43 * x85,
            x10 * x36 * x87,
            x72 * x88,
            x63
            * (x0 * (4.0 * x40 * x64 + 2.0 * x69 + 2.0 * x70 + 2.0 * x86) + x32 * x88),
        ]
    )


def quadrupole3d_31(a, A, b, B, C):
    """Cartesian 3D (fp) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - C[0]
    x4 = -x2 - B[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = 1.77245385090552 * numpy.sqrt(x1)
    x8 = x6 * x7
    x9 = x4 * x8
    x10 = x3 * x9
    x11 = x3**2 * x8
    x12 = x0 * x8
    x13 = 3.0 * x12
    x14 = x11 + x13
    x15 = x0 * (2.0 * x10 + x14)
    x16 = -x2 - A[0]
    x17 = x16 * x9
    x18 = x3 * x8
    x19 = x16 * x18
    x20 = x0 * (x10 + x13 + x17 + x19)
    x21 = x0 * (x18 + x9)
    x22 = x10 + x12
    x23 = x16 * x22
    x24 = x21 + x23
    x25 = x16 * x24
    x26 = x11 + x12
    x27 = x26 * x4
    x28 = x12 * x3
    x29 = 2.0 * x28
    x30 = x27 + x29
    x31 = x16 * x30
    x32 = 2.0 * x19
    x33 = x16 * x26
    x34 = x29 + x33
    x35 = x0 * (x14 + x32) + x16 * x34
    x36 = 4.0 * x28
    x37 = 2.0 * x21 + 2.0 * x23
    x38 = x15 + x31
    x39 = x0 * (x27 + x33 + x36 + x37) + x16 * x38
    x40 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x41 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x42 = 3.14159265358979 * x1 * x41
    x43 = x40 * x42
    x44 = -x1 * (a * A[1] + b * B[1])
    x45 = -x44 - B[1]
    x46 = x16 * x8
    x47 = x0 * (x18 + x46)
    x48 = x12 + x19
    x49 = x16 * x48
    x50 = x43 * (x0 * (2.0 * x33 + x36 + 2.0 * x47 + 2.0 * x49) + x16 * x35)
    x51 = -x1 * (a * A[2] + b * B[2])
    x52 = -x51 - B[2]
    x53 = -x44 - A[1]
    x54 = x39 * x43
    x55 = x0 * x7
    x56 = x40 * x55
    x57 = x40 * x7
    x58 = x53 * x57
    x59 = x45 * x58
    x60 = x56 + x59
    x61 = x41 * x7
    x62 = x35 * x43
    x63 = -x51 - A[2]
    x64 = x41 * x55
    x65 = x61 * x63
    x66 = x52 * x65
    x67 = x64 + x66
    x68 = x53**2 * x57
    x69 = x56 + x68
    x70 = x45 * x57
    x71 = x0 * (x58 + x70) + x53 * x60
    x72 = x52 * x61
    x73 = x43 * x63
    x74 = x61 * x63**2
    x75 = x64 + x74
    x76 = x0 * (x65 + x72) + x63 * x67
    x77 = 2.0 * x56
    x78 = x53 * x69 + x53 * x77
    x79 = 3.0 * x56
    x80 = x68 + x79
    x81 = x0 * (2.0 * x59 + x80) + x53 * x71
    x82 = 2.0 * x64
    x83 = x63 * x75 + x63 * x82
    x84 = 3.0 * x64
    x85 = x74 + x84
    x86 = x0 * (2.0 * x66 + x85) + x63 * x76
    x87 = -x44 - C[1]
    x88 = x47 + x49
    x89 = x12 + x17
    x90 = x0 * (x46 + x9) + x16 * x89
    x91 = x20 + x25
    x92 = x43 * (x0 * (x37 + x88 + x90) + x16 * x91)
    x93 = x70 * x87
    x94 = x56 + x93
    x95 = x16**2 * x8
    x96 = x13 + x95
    x97 = x0 * (x32 + x96) + x16 * x88
    x98 = x43 * x97
    x99 = x58 * x87
    x100 = x56 + x99
    x101 = x57 * x87
    x102 = x0 * (x101 + x70)
    x103 = x53 * x94
    x104 = x102 + x103
    x105 = x0 * (x101 + x58)
    x106 = x100 * x53
    x107 = x105 + x106
    x108 = x0 * (x59 + x79 + x93 + x99)
    x109 = x104 * x53
    x110 = x108 + x109
    x111 = 2.0 * x99
    x112 = x0 * (x111 + x80) + x107 * x53
    x113 = 2.0 * x102 + 2.0 * x103
    x114 = x42 * x6
    x115 = x114 * (x0 * (x107 + x113 + x71) + x110 * x53)
    x116 = x114 * x3
    x117 = 3.14159265358979 * x1 * x40 * x6
    x118 = x117 * x3
    x119 = -x51 - C[2]
    x120 = x119 * x72
    x121 = x120 + x64
    x122 = x119 * x43
    x123 = x119 * x61
    x124 = x119 * x65
    x125 = x124 + x64
    x126 = x0 * (x123 + x72)
    x127 = x121 * x63
    x128 = x126 + x127
    x129 = x0 * (x123 + x65)
    x130 = x125 * x63
    x131 = x129 + x130
    x132 = x0 * (x120 + x124 + x66 + x84)
    x133 = x128 * x63
    x134 = x132 + x133
    x135 = 2.0 * x124
    x136 = x0 * (x135 + x85) + x131 * x63
    x137 = 2.0 * x126 + 2.0 * x127
    x138 = x117 * (x0 * (x131 + x137 + x76) + x134 * x63)
    x139 = x57 * x87**2
    x140 = x139 + x56
    x141 = x0 * (2.0 * x17 + x96) + x16 * x90
    x142 = x140 * x45
    x143 = x77 * x87
    x144 = x142 + x143
    x145 = x12 + x95
    x146 = 2.0 * x12 * x16 + x145 * x16
    x147 = x140 * x53
    x148 = x143 + x147
    x149 = x139 + x79
    x150 = x0 * (x149 + 2.0 * x93)
    x151 = x144 * x53
    x152 = x150 + x151
    x153 = x0 * (x111 + x149) + x148 * x53
    x154 = 4.0 * x56 * x87
    x155 = x0 * (x113 + x142 + x147 + x154) + x152 * x53
    x156 = x114 * x155
    x157 = x114 * x16
    x158 = x114 * (x0 * (2.0 * x105 + 2.0 * x106 + 2.0 * x147 + x154) + x153 * x53)
    x159 = x114 * x4
    x160 = x117 * x87
    x161 = x119**2 * x61
    x162 = x161 + x64
    x163 = x162 * x52
    x164 = x119 * x82
    x165 = x163 + x164
    x166 = x162 * x63
    x167 = x164 + x166
    x168 = x161 + x84
    x169 = x0 * (2.0 * x120 + x168)
    x170 = x165 * x63
    x171 = x169 + x170
    x172 = x117 * x16
    x173 = x0 * (x135 + x168) + x167 * x63
    x174 = 4.0 * x119 * x64
    x175 = x0 * (x137 + x163 + x166 + x174) + x171 * x63
    x176 = x117 * x175
    x177 = x117 * (x0 * (2.0 * x129 + 2.0 * x130 + 2.0 * x166 + x174) + x173 * x63)

    # 180 item(s)
    return numpy.array(
        [
            x43
            * (x0 * (2.0 * x15 + 2.0 * x20 + 2.0 * x25 + 2.0 * x31 + x35) + x16 * x39),
            x45 * x50,
            x50 * x52,
            x53 * x54,
            x35 * x60 * x61,
            x52 * x53 * x62,
            x54 * x63,
            x45 * x62 * x63,
            x35 * x57 * x67,
            x38 * x61 * x69,
            x34 * x61 * x71,
            x34 * x69 * x72,
            x38 * x53 * x73,
            x34 * x60 * x65,
            x34 * x58 * x67,
            x38 * x57 * x75,
            x34 * x70 * x75,
            x34 * x57 * x76,
            x30 * x61 * x78,
            x26 * x61 * x81,
            x26 * x72 * x78,
            x30 * x65 * x69,
            x26 * x65 * x71,
            x26 * x67 * x69,
            x30 * x58 * x75,
            x26 * x60 * x75,
            x26 * x58 * x76,
            x30 * x57 * x83,
            x26 * x70 * x83,
            x26 * x57 * x86,
            x87 * x92,
            x61 * x94 * x97,
            x52 * x87 * x98,
            x100 * x61 * x91,
            x104 * x61 * x88,
            x100 * x72 * x88,
            x73 * x87 * x91,
            x65 * x88 * x94,
            x101 * x67 * x88,
            x107 * x24 * x61,
            x110 * x48 * x61,
            x107 * x48 * x72,
            x100 * x24 * x65,
            x104 * x48 * x65,
            x100 * x48 * x67,
            x101 * x24 * x75,
            x48 * x75 * x94,
            x101 * x48 * x76,
            x112 * x22 * x61,
            x115 * x3,
            x112 * x116 * x52,
            x107 * x22 * x65,
            x110 * x116 * x63,
            x107 * x18 * x67,
            x100 * x22 * x75,
            x104 * x18 * x75,
            x100 * x18 * x76,
            x101 * x22 * x83,
            x18 * x83 * x94,
            x118 * x86 * x87,
            x119 * x92,
            x119 * x45 * x98,
            x121 * x57 * x97,
            x122 * x53 * x91,
            x123 * x60 * x88,
            x121 * x58 * x88,
            x125 * x57 * x91,
            x125 * x70 * x88,
            x128 * x57 * x88,
            x123 * x24 * x69,
            x123 * x48 * x71,
            x121 * x48 * x69,
            x125 * x24 * x58,
            x125 * x48 * x60,
            x128 * x48 * x58,
            x131 * x24 * x57,
            x131 * x48 * x70,
            x134 * x48 * x57,
            x123 * x22 * x78,
            x116 * x119 * x81,
            x121 * x18 * x78,
            x125 * x22 * x69,
            x125 * x18 * x71,
            x128 * x18 * x69,
            x131 * x22 * x58,
            x131 * x18 * x60,
            x118 * x134 * x53,
            x136 * x22 * x57,
            x118 * x136 * x45,
            x138 * x3,
            x140 * x141 * x61,
            x144 * x146 * x61,
            x140 * x146 * x72,
            x148 * x61 * x90,
            x145 * x152 * x61,
            x145 * x148 * x72,
            x140 * x65 * x90,
            x144 * x145 * x65,
            x140 * x145 * x67,
            x153 * x61 * x89,
            x156 * x16,
            x153 * x157 * x52,
            x148 * x65 * x89,
            x152 * x157 * x63,
            x148 * x46 * x67,
            x140 * x75 * x89,
            x144 * x46 * x75,
            x140 * x46 * x76,
            x158 * x4,
            x114
            * (
                x0 * (2.0 * x108 + 2.0 * x109 + 2.0 * x150 + 2.0 * x151 + x153)
                + x155 * x53
            ),
            x158 * x52,
            x153 * x159 * x63,
            x156 * x63,
            x153 * x67 * x8,
            x148 * x75 * x9,
            x152 * x75 * x8,
            x148 * x76 * x8,
            x140 * x83 * x9,
            x144 * x8 * x83,
            x140 * x8 * x86,
            x122 * x141 * x87,
            x123 * x146 * x94,
            x101 * x121 * x146,
            x100 * x123 * x90,
            x104 * x123 * x145,
            x100 * x121 * x145,
            x101 * x125 * x90,
            x125 * x145 * x94,
            x101 * x128 * x145,
            x107 * x123 * x89,
            x110 * x119 * x157,
            x107 * x121 * x46,
            x100 * x125 * x89,
            x104 * x125 * x46,
            x100 * x128 * x46,
            x101 * x131 * x89,
            x131 * x46 * x94,
            x134 * x16 * x160,
            x112 * x119 * x159,
            x115 * x119,
            x112 * x121 * x8,
            x107 * x125 * x9,
            x110 * x125 * x8,
            x107 * x128 * x8,
            x100 * x131 * x9,
            x104 * x131 * x8,
            x100 * x134 * x8,
            x136 * x160 * x4,
            x136 * x8 * x94,
            x138 * x87,
            x141 * x162 * x57,
            x146 * x162 * x70,
            x146 * x165 * x57,
            x162 * x58 * x90,
            x145 * x162 * x60,
            x145 * x165 * x58,
            x167 * x57 * x90,
            x145 * x167 * x70,
            x145 * x171 * x57,
            x162 * x69 * x89,
            x162 * x46 * x71,
            x165 * x46 * x69,
            x167 * x58 * x89,
            x167 * x46 * x60,
            x171 * x172 * x53,
            x173 * x57 * x89,
            x172 * x173 * x45,
            x16 * x176,
            x162 * x78 * x9,
            x162 * x8 * x81,
            x165 * x78 * x8,
            x167 * x69 * x9,
            x167 * x71 * x8,
            x171 * x69 * x8,
            x117 * x173 * x4 * x53,
            x173 * x60 * x8,
            x176 * x53,
            x177 * x4,
            x177 * x45,
            x117
            * (
                x0 * (2.0 * x132 + 2.0 * x133 + 2.0 * x169 + 2.0 * x170 + x173)
                + x175 * x63
            ),
        ]
    )


def quadrupole3d_32(a, A, b, B, C):
    """Cartesian 3D (fd) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = -x2 - C[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = 1.77245385090552 * numpy.sqrt(x1)
    x8 = x6 * x7
    x9 = x4**2 * x8
    x10 = x0 * x8
    x11 = x10 + x9
    x12 = x11 * x3
    x13 = x3 * x6
    x14 = x13 * x7
    x15 = x14 * x4
    x16 = x10 + x15
    x17 = x16 * x3
    x18 = x4 * x8
    x19 = x0 * (x14 + x18)
    x20 = 2.0 * x19
    x21 = x0 * x18
    x22 = 4.0 * x21
    x23 = x20 + x22
    x24 = x0 * (2.0 * x12 + 2.0 * x17 + x23)
    x25 = -x2 - A[0]
    x26 = x16 * x25
    x27 = 2.0 * x26
    x28 = x3**2 * x8
    x29 = x10 + x28
    x30 = x25 * x29
    x31 = x0 * x14
    x32 = x30 + 2.0 * x31
    x33 = x0 * (x17 + 3.0 * x19 + x27 + x32)
    x34 = x11 * x25
    x35 = x0 * (x12 + x23 + x27 + x34)
    x36 = 3.0 * x10
    x37 = 2.0 * x15 + x36
    x38 = x0 * (x28 + x37)
    x39 = x17 + x19
    x40 = x25 * x39
    x41 = x38 + x40
    x42 = x25 * x41
    x43 = x0 * (x37 + x9)
    x44 = 2.0 * x21
    x45 = x12 + x44
    x46 = x25 * x45
    x47 = x43 + x46
    x48 = x25 * x47
    x49 = x3 * x45
    x50 = x43 + x49
    x51 = x25 * x50
    x52 = 2.0 * x46
    x53 = 2.0 * x38 + 2.0 * x40
    x54 = x24 + x51
    x55 = x0 * (3.0 * x43 + x49 + x52 + x53) + x25 * x54
    x56 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x57 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x58 = 3.14159265358979 * x1 * x57
    x59 = x56 * x58
    x60 = -x1 * (a * A[1] + b * B[1])
    x61 = -x60 - B[1]
    x62 = x18 * x25
    x63 = x36 + 2.0 * x62
    x64 = x34 + x44
    x65 = x0 * (x63 + x9) + x25 * x64
    x66 = x14 * x25
    x67 = x0 * (x15 + x36 + x62 + x66)
    x68 = x19 + x26
    x69 = x25 * x68
    x70 = 2.0 * x67 + 2.0 * x69
    x71 = x35 + x48
    x72 = x59 * (x0 * (2.0 * x43 + x52 + x65 + x70) + x25 * x71)
    x73 = -x1 * (a * A[2] + b * B[2])
    x74 = -x73 - B[2]
    x75 = x56 * x7
    x76 = x61**2 * x75
    x77 = x0 * x75
    x78 = x76 + x77
    x79 = x25 * x8
    x80 = x0 * (x18 + x79)
    x81 = x10 + x62
    x82 = x25 * x81
    x83 = x0 * (x22 + 2.0 * x34 + 2.0 * x80 + 2.0 * x82) + x25 * x65
    x84 = x57 * x7
    x85 = x59 * x74
    x86 = x74**2 * x84
    x87 = x0 * x84
    x88 = x86 + x87
    x89 = -x60 - A[1]
    x90 = x55 * x59
    x91 = x75 * x89
    x92 = x61 * x91
    x93 = x77 + x92
    x94 = x78 * x89
    x95 = 2.0 * x77
    x96 = x61 * x95 + x94
    x97 = x74 * x84
    x98 = -x73 - A[2]
    x99 = x59 * x98
    x100 = x84 * x98
    x101 = x100 * x74
    x102 = x101 + x87
    x103 = x61 * x75
    x104 = x88 * x98
    x105 = 2.0 * x87
    x106 = x104 + x105 * x74
    x107 = x75 * x89**2
    x108 = x107 + x77
    x109 = x0 * (x103 + x91)
    x110 = x89 * x93
    x111 = x109 + x110
    x112 = 3.0 * x77
    x113 = x112 + 2.0 * x92
    x114 = x0 * (x113 + x76) + x89 * x96
    x115 = x84 * x98**2
    x116 = x115 + x87
    x117 = x0 * (x100 + x97)
    x118 = x102 * x98
    x119 = x117 + x118
    x120 = 3.0 * x87
    x121 = 2.0 * x101 + x120
    x122 = x0 * (x121 + x86) + x106 * x98
    x123 = x108 * x89 + x89 * x95
    x124 = x0 * (x107 + x113) + x111 * x89
    x125 = 4.0 * x77
    x126 = x0 * (2.0 * x109 + 2.0 * x110 + x125 * x61 + 2.0 * x94) + x114 * x89
    x127 = x105 * x98 + x116 * x98
    x128 = x0 * (x115 + x121) + x119 * x98
    x129 = 4.0 * x87
    x130 = x0 * (2.0 * x104 + 2.0 * x117 + 2.0 * x118 + x129 * x74) + x122 * x98
    x131 = -x60 - C[1]
    x132 = x36 + 2.0 * x66
    x133 = x0 * (x132 + x28) + x25 * x32
    x134 = x33 + x42
    x135 = x59 * (x0 * (x133 + x53 + x70) + x134 * x25)
    x136 = x103 * x131
    x137 = x136 + x77
    x138 = x80 + x82
    x139 = x0 * (x14 + x79)
    x140 = x10 + x66
    x141 = x140 * x25
    x142 = x139 + x141
    x143 = x67 + x69
    x144 = x0 * (x138 + x142 + x20 + x27) + x143 * x25
    x145 = x131 * x75
    x146 = x0 * (x103 + x145)
    x147 = x137 * x61
    x148 = x146 + x147
    x149 = x25**2 * x8
    x150 = x0 * (x149 + x63) + x138 * x25
    x151 = x131 * x91
    x152 = x151 + x77
    x153 = x137 * x89
    x154 = x146 + x153
    x155 = x112 + 2.0 * x136
    x156 = x0 * (x155 + x76)
    x157 = x148 * x89
    x158 = x156 + x157
    x159 = x0 * (x145 + x91)
    x160 = x152 * x89
    x161 = x159 + x160
    x162 = x0 * (x112 + x136 + x151 + x92)
    x163 = x154 * x89
    x164 = x162 + x163
    x165 = 2.0 * x153
    x166 = x0 * (3.0 * x146 + x147 + x165 + x96)
    x167 = x158 * x89
    x168 = x166 + x167
    x169 = x112 + 2.0 * x151
    x170 = x0 * (x107 + x169) + x161 * x89
    x171 = 2.0 * x146
    x172 = x0 * (x111 + x161 + x165 + x171) + x164 * x89
    x173 = 2.0 * x156 + 2.0 * x157
    x174 = 2.0 * x162 + 2.0 * x163
    x175 = x58 * x6
    x176 = x175 * (x0 * (x114 + x173 + x174) + x168 * x89)
    x177 = x175 * x74
    x178 = x175 * x4
    x179 = 3.14159265358979 * x1 * x56
    x180 = x179 * x6
    x181 = x180 * x4
    x182 = -x73 - C[2]
    x183 = x182 * x59
    x184 = x182 * x97
    x185 = x184 + x87
    x186 = x182 * x84
    x187 = x0 * (x186 + x97)
    x188 = x185 * x74
    x189 = x187 + x188
    x190 = x100 * x182
    x191 = x190 + x87
    x192 = x185 * x98
    x193 = x187 + x192
    x194 = x120 + 2.0 * x184
    x195 = x0 * (x194 + x86)
    x196 = x189 * x98
    x197 = x195 + x196
    x198 = x0 * (x100 + x186)
    x199 = x191 * x98
    x200 = x198 + x199
    x201 = x0 * (x101 + x120 + x184 + x190)
    x202 = x193 * x98
    x203 = x201 + x202
    x204 = 2.0 * x192
    x205 = x0 * (x106 + 3.0 * x187 + x188 + x204)
    x206 = x197 * x98
    x207 = x205 + x206
    x208 = x120 + 2.0 * x190
    x209 = x0 * (x115 + x208) + x200 * x98
    x210 = 2.0 * x187
    x211 = x0 * (x119 + x200 + x204 + x210) + x203 * x98
    x212 = x180 * x61
    x213 = 2.0 * x195 + 2.0 * x196
    x214 = 2.0 * x201 + 2.0 * x202
    x215 = x180 * (x0 * (x122 + x213 + x214) + x207 * x98)
    x216 = x131**2 * x75
    x217 = x216 + x77
    x218 = x0 * (2.0 * x139 + 2.0 * x141 + 2.0 * x30 + 4.0 * x31) + x133 * x25
    x219 = x217 * x61
    x220 = x131 * x95
    x221 = x219 + x220
    x222 = x0 * (x132 + x149) + x142 * x25
    x223 = x0 * (x155 + x216)
    x224 = x221 * x61
    x225 = x223 + x224
    x226 = x10 + x149
    x227 = 2.0 * x10 * x25 + x226 * x25
    x228 = x217 * x89
    x229 = x220 + x228
    x230 = x221 * x89
    x231 = x223 + x230
    x232 = x125 * x131
    x233 = x171 + x232
    x234 = x0 * (2.0 * x147 + 2.0 * x219 + x233)
    x235 = x225 * x89
    x236 = x234 + x235
    x237 = x0 * (x169 + x216) + x229 * x89
    x238 = x0 * (x165 + x219 + x228 + x233)
    x239 = x231 * x89
    x240 = x238 + x239
    x241 = 2.0 * x230
    x242 = x0 * (x173 + 3.0 * x223 + x224 + x241) + x236 * x89
    x243 = x175 * x242
    x244 = x175 * x25
    x245 = x0 * (2.0 * x159 + 2.0 * x160 + 2.0 * x228 + x232) + x237 * x89
    x246 = x0 * (x174 + 2.0 * x223 + x237 + x241) + x240 * x89
    x247 = x13 * x58
    x248 = x180 * x25
    x249 = x13 * x179
    x250 = x182**2 * x84
    x251 = x250 + x87
    x252 = x251 * x74
    x253 = x105 * x182
    x254 = x252 + x253
    x255 = x0 * (x194 + x250)
    x256 = x254 * x74
    x257 = x255 + x256
    x258 = x251 * x98
    x259 = x253 + x258
    x260 = x254 * x98
    x261 = x255 + x260
    x262 = x129 * x182
    x263 = x210 + x262
    x264 = x0 * (2.0 * x188 + 2.0 * x252 + x263)
    x265 = x257 * x98
    x266 = x264 + x265
    x267 = x0 * (x208 + x250) + x259 * x98
    x268 = x0 * (x204 + x252 + x258 + x263)
    x269 = x261 * x98
    x270 = x268 + x269
    x271 = 2.0 * x260
    x272 = x0 * (x213 + 3.0 * x255 + x256 + x271) + x266 * x98
    x273 = x180 * x272
    x274 = x0 * (2.0 * x198 + 2.0 * x199 + 2.0 * x258 + x262) + x267 * x98
    x275 = x0 * (x214 + 2.0 * x255 + x267 + x271) + x270 * x98

    # 360 item(s)
    return numpy.array(
        [
            x59
            * (
                x0
                * (2.0 * x24 + 2.0 * x33 + 2.0 * x35 + 2.0 * x42 + 2.0 * x48 + 2.0 * x51)
                + x25 * x55
            ),
            x61 * x72,
            x72 * x74,
            x78 * x83 * x84,
            x61 * x83 * x85,
            x75 * x83 * x88,
            x89 * x90,
            x71 * x84 * x93,
            x71 * x85 * x89,
            x65 * x84 * x96,
            x65 * x93 * x97,
            x65 * x88 * x91,
            x90 * x98,
            x61 * x71 * x99,
            x102 * x71 * x75,
            x100 * x65 * x78,
            x102 * x103 * x65,
            x106 * x65 * x75,
            x108 * x54 * x84,
            x111 * x47 * x84,
            x108 * x47 * x97,
            x114 * x64 * x84,
            x111 * x64 * x97,
            x108 * x64 * x88,
            x54 * x89 * x99,
            x100 * x47 * x93,
            x102 * x47 * x91,
            x100 * x64 * x96,
            x102 * x64 * x93,
            x106 * x64 * x91,
            x116 * x54 * x75,
            x103 * x116 * x47,
            x119 * x47 * x75,
            x116 * x64 * x78,
            x103 * x119 * x64,
            x122 * x64 * x75,
            x123 * x50 * x84,
            x124 * x45 * x84,
            x123 * x45 * x97,
            x11 * x126 * x84,
            x11 * x124 * x97,
            x11 * x123 * x88,
            x100 * x108 * x50,
            x100 * x111 * x45,
            x102 * x108 * x45,
            x100 * x11 * x114,
            x102 * x11 * x111,
            x106 * x108 * x11,
            x116 * x50 * x91,
            x116 * x45 * x93,
            x119 * x45 * x91,
            x11 * x116 * x96,
            x11 * x119 * x93,
            x11 * x122 * x91,
            x127 * x50 * x75,
            x103 * x127 * x45,
            x128 * x45 * x75,
            x11 * x127 * x78,
            x103 * x11 * x128,
            x11 * x130 * x75,
            x131 * x135,
            x137 * x144 * x84,
            x131 * x144 * x85,
            x148 * x150 * x84,
            x137 * x150 * x97,
            x145 * x150 * x88,
            x134 * x152 * x84,
            x143 * x154 * x84,
            x143 * x152 * x97,
            x138 * x158 * x84,
            x138 * x154 * x97,
            x138 * x152 * x88,
            x131 * x134 * x99,
            x100 * x137 * x143,
            x102 * x143 * x145,
            x100 * x138 * x148,
            x102 * x137 * x138,
            x106 * x138 * x145,
            x161 * x41 * x84,
            x164 * x68 * x84,
            x161 * x68 * x97,
            x168 * x81 * x84,
            x164 * x81 * x97,
            x161 * x81 * x88,
            x100 * x152 * x41,
            x100 * x154 * x68,
            x102 * x152 * x68,
            x100 * x158 * x81,
            x102 * x154 * x81,
            x106 * x152 * x81,
            x116 * x145 * x41,
            x116 * x137 * x68,
            x119 * x145 * x68,
            x116 * x148 * x81,
            x119 * x137 * x81,
            x122 * x145 * x81,
            x170 * x39 * x84,
            x16 * x172 * x84,
            x16 * x170 * x97,
            x176 * x4,
            x172 * x177 * x4,
            x170 * x18 * x88,
            x100 * x161 * x39,
            x100 * x16 * x164,
            x102 * x16 * x161,
            x168 * x178 * x98,
            x102 * x164 * x18,
            x106 * x161 * x18,
            x116 * x152 * x39,
            x116 * x154 * x16,
            x119 * x152 * x16,
            x116 * x158 * x18,
            x119 * x154 * x18,
            x122 * x152 * x18,
            x127 * x145 * x39,
            x127 * x137 * x16,
            x128 * x145 * x16,
            x127 * x148 * x18,
            x128 * x137 * x18,
            x130 * x131 * x181,
            x135 * x182,
            x144 * x183 * x61,
            x144 * x185 * x75,
            x150 * x186 * x78,
            x103 * x150 * x185,
            x150 * x189 * x75,
            x134 * x183 * x89,
            x143 * x186 * x93,
            x143 * x185 * x91,
            x138 * x186 * x96,
            x138 * x185 * x93,
            x138 * x189 * x91,
            x134 * x191 * x75,
            x103 * x143 * x191,
            x143 * x193 * x75,
            x138 * x191 * x78,
            x103 * x138 * x193,
            x138 * x197 * x75,
            x108 * x186 * x41,
            x111 * x186 * x68,
            x108 * x185 * x68,
            x114 * x186 * x81,
            x111 * x185 * x81,
            x108 * x189 * x81,
            x191 * x41 * x91,
            x191 * x68 * x93,
            x193 * x68 * x91,
            x191 * x81 * x96,
            x193 * x81 * x93,
            x197 * x81 * x91,
            x200 * x41 * x75,
            x103 * x200 * x68,
            x203 * x68 * x75,
            x200 * x78 * x81,
            x103 * x203 * x81,
            x207 * x75 * x81,
            x123 * x186 * x39,
            x124 * x16 * x186,
            x123 * x16 * x185,
            x126 * x178 * x182,
            x124 * x18 * x185,
            x123 * x18 * x189,
            x108 * x191 * x39,
            x111 * x16 * x191,
            x108 * x16 * x193,
            x114 * x18 * x191,
            x111 * x18 * x193,
            x108 * x18 * x197,
            x200 * x39 * x91,
            x16 * x200 * x93,
            x16 * x203 * x91,
            x18 * x200 * x96,
            x18 * x203 * x93,
            x181 * x207 * x89,
            x209 * x39 * x75,
            x103 * x16 * x209,
            x16 * x211 * x75,
            x18 * x209 * x78,
            x211 * x212 * x4,
            x215 * x4,
            x217 * x218 * x84,
            x221 * x222 * x84,
            x217 * x222 * x97,
            x225 * x227 * x84,
            x221 * x227 * x97,
            x217 * x227 * x88,
            x133 * x229 * x84,
            x142 * x231 * x84,
            x142 * x229 * x97,
            x226 * x236 * x84,
            x226 * x231 * x97,
            x226 * x229 * x88,
            x100 * x133 * x217,
            x100 * x142 * x221,
            x102 * x142 * x217,
            x100 * x225 * x226,
            x102 * x221 * x226,
            x106 * x217 * x226,
            x237 * x32 * x84,
            x140 * x240 * x84,
            x140 * x237 * x97,
            x243 * x25,
            x177 * x240 * x25,
            x237 * x79 * x88,
            x100 * x229 * x32,
            x100 * x140 * x231,
            x102 * x140 * x229,
            x236 * x244 * x98,
            x102 * x231 * x79,
            x106 * x229 * x79,
            x116 * x217 * x32,
            x116 * x140 * x221,
            x119 * x140 * x217,
            x116 * x225 * x79,
            x119 * x221 * x79,
            x122 * x217 * x79,
            x245 * x29 * x84,
            x246 * x247,
            x245 * x247 * x74,
            x175
            * (
                x0
                * (
                    2.0 * x166
                    + 2.0 * x167
                    + 2.0 * x234
                    + 2.0 * x235
                    + 2.0 * x238
                    + 2.0 * x239
                )
                + x242 * x89
            ),
            x177 * x246,
            x245 * x8 * x88,
            x100 * x237 * x29,
            x240 * x247 * x98,
            x102 * x14 * x237,
            x243 * x98,
            x102 * x240 * x8,
            x106 * x237 * x8,
            x116 * x229 * x29,
            x116 * x14 * x231,
            x119 * x14 * x229,
            x116 * x236 * x8,
            x119 * x231 * x8,
            x122 * x229 * x8,
            x127 * x217 * x29,
            x127 * x14 * x221,
            x128 * x14 * x217,
            x127 * x225 * x8,
            x128 * x221 * x8,
            x130 * x217 * x8,
            x131 * x183 * x218,
            x137 * x186 * x222,
            x145 * x185 * x222,
            x148 * x186 * x227,
            x137 * x185 * x227,
            x145 * x189 * x227,
            x133 * x152 * x186,
            x142 * x154 * x186,
            x142 * x152 * x185,
            x158 * x186 * x226,
            x154 * x185 * x226,
            x152 * x189 * x226,
            x133 * x145 * x191,
            x137 * x142 * x191,
            x142 * x145 * x193,
            x148 * x191 * x226,
            x137 * x193 * x226,
            x145 * x197 * x226,
            x161 * x186 * x32,
            x140 * x164 * x186,
            x140 * x161 * x185,
            x168 * x182 * x244,
            x164 * x185 * x79,
            x161 * x189 * x79,
            x152 * x191 * x32,
            x140 * x154 * x191,
            x140 * x152 * x193,
            x158 * x191 * x79,
            x154 * x193 * x79,
            x152 * x197 * x79,
            x145 * x200 * x32,
            x137 * x140 * x200,
            x140 * x145 * x203,
            x148 * x200 * x79,
            x137 * x203 * x79,
            x131 * x207 * x248,
            x170 * x186 * x29,
            x172 * x182 * x247,
            x14 * x170 * x185,
            x176 * x182,
            x172 * x185 * x8,
            x170 * x189 * x8,
            x161 * x191 * x29,
            x14 * x164 * x191,
            x14 * x161 * x193,
            x168 * x191 * x8,
            x164 * x193 * x8,
            x161 * x197 * x8,
            x152 * x200 * x29,
            x14 * x154 * x200,
            x14 * x152 * x203,
            x158 * x200 * x8,
            x154 * x203 * x8,
            x152 * x207 * x8,
            x145 * x209 * x29,
            x137 * x14 * x209,
            x131 * x211 * x249,
            x148 * x209 * x8,
            x137 * x211 * x8,
            x131 * x215,
            x218 * x251 * x75,
            x103 * x222 * x251,
            x222 * x254 * x75,
            x227 * x251 * x78,
            x103 * x227 * x254,
            x227 * x257 * x75,
            x133 * x251 * x91,
            x142 * x251 * x93,
            x142 * x254 * x91,
            x226 * x251 * x96,
            x226 * x254 * x93,
            x226 * x257 * x91,
            x133 * x259 * x75,
            x103 * x142 * x259,
            x142 * x261 * x75,
            x226 * x259 * x78,
            x103 * x226 * x261,
            x226 * x266 * x75,
            x108 * x251 * x32,
            x111 * x140 * x251,
            x108 * x140 * x254,
            x114 * x251 * x79,
            x111 * x254 * x79,
            x108 * x257 * x79,
            x259 * x32 * x91,
            x140 * x259 * x93,
            x140 * x261 * x91,
            x259 * x79 * x96,
            x261 * x79 * x93,
            x248 * x266 * x89,
            x267 * x32 * x75,
            x103 * x140 * x267,
            x140 * x270 * x75,
            x267 * x78 * x79,
            x212 * x25 * x270,
            x25 * x273,
            x123 * x251 * x29,
            x124 * x14 * x251,
            x123 * x14 * x254,
            x126 * x251 * x8,
            x124 * x254 * x8,
            x123 * x257 * x8,
            x108 * x259 * x29,
            x111 * x14 * x259,
            x108 * x14 * x261,
            x114 * x259 * x8,
            x111 * x261 * x8,
            x108 * x266 * x8,
            x267 * x29 * x91,
            x14 * x267 * x93,
            x249 * x270 * x89,
            x267 * x8 * x96,
            x270 * x8 * x93,
            x273 * x89,
            x274 * x29 * x75,
            x249 * x274 * x61,
            x249 * x275,
            x274 * x78 * x8,
            x212 * x275,
            x180
            * (
                x0
                * (
                    2.0 * x205
                    + 2.0 * x206
                    + 2.0 * x264
                    + 2.0 * x265
                    + 2.0 * x268
                    + 2.0 * x269
                )
                + x272 * x98
            ),
        ]
    )


def quadrupole3d_33(a, A, b, B, C):
    """Cartesian 3D (ff) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3 * x7
    x9 = -x2 - C[0]
    x10 = x7 * x9
    x11 = x0 * (x10 + x8)
    x12 = x0 * x7
    x13 = x8 * x9
    x14 = x12 + x13
    x15 = x14 * x3
    x16 = x11 + x15
    x17 = x16 * x3
    x18 = x7 * x9**2
    x19 = x12 + x18
    x20 = x19 * x3
    x21 = 2.0 * x0
    x22 = x10 * x21
    x23 = x20 + x22
    x24 = x23 * x3
    x25 = x3**2 * x7
    x26 = 3.0 * x12
    x27 = 2.0 * x13 + x26
    x28 = x0 * (x25 + x27)
    x29 = 2.0 * x28
    x30 = x0 * (x18 + x27)
    x31 = x29 + 3.0 * x30
    x32 = x0 * (2.0 * x17 + 3.0 * x24 + x31)
    x33 = -x2 - A[0]
    x34 = x16 * x33
    x35 = x0 * (3.0 * x25 + x26)
    x36 = x12 + x25
    x37 = x3 * x36
    x38 = x21 * x8
    x39 = x37 + x38
    x40 = x33 * x39
    x41 = x35 + x40
    x42 = x0 * (x17 + 4.0 * x28 + 3.0 * x34 + x41)
    x43 = 3.0 * x11
    x44 = x0 * (3.0 * x15 + x39 + x43)
    x45 = x17 + x28
    x46 = x33 * x45
    x47 = x44 + x46
    x48 = x33 * x47
    x49 = 2.0 * x11
    x50 = 4.0 * x0
    x51 = x10 * x50
    x52 = x49 + x51
    x53 = x0 * (2.0 * x15 + 2.0 * x20 + x52)
    x54 = x24 + x30
    x55 = x3 * x54
    x56 = x53 + x55
    x57 = x33 * x56
    x58 = 2.0 * x34
    x59 = x23 * x33
    x60 = 2.0 * x59
    x61 = x0 * (x24 + x31 + x58 + x60)
    x62 = x33 * x54
    x63 = x53 + x62
    x64 = x33 * x63
    x65 = 2.0 * x44 + 2.0 * x46
    x66 = x32 + x57
    x67 = x0 * (4.0 * x53 + x55 + 3.0 * x62 + x65) + x33 * x66
    x68 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x69 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x70 = 3.14159265358979 * x1 * x69
    x71 = x68 * x70
    x72 = -x1 * (a * A[1] + b * B[1])
    x73 = -x72 - B[1]
    x74 = x14 * x33
    x75 = 2.0 * x74
    x76 = x33 * x36
    x77 = x38 + x76
    x78 = x0 * (x15 + x43 + x75 + x77)
    x79 = x19 * x33
    x80 = x0 * (x20 + x52 + x75 + x79)
    x81 = x28 + x34
    x82 = x33 * x81
    x83 = x30 + x59
    x84 = x33 * x83
    x85 = x61 + x64
    x86 = x71 * (
        x0 * (2.0 * x53 + 2.0 * x62 + 2.0 * x78 + 2.0 * x80 + 2.0 * x82 + 2.0 * x84)
        + x33 * x85
    )
    x87 = -x1 * (a * A[2] + b * B[2])
    x88 = -x87 - B[2]
    x89 = x6 * x68
    x90 = x73**2 * x89
    x91 = x0 * x89
    x92 = x90 + x91
    x93 = x10 * x33
    x94 = x26 + 2.0 * x93
    x95 = x22 + x79
    x96 = x0 * (x18 + x94) + x33 * x95
    x97 = x33 * x8
    x98 = x0 * (x13 + x26 + x93 + x97)
    x99 = x11 + x74
    x100 = x33 * x99
    x101 = 2.0 * x100 + 2.0 * x98
    x102 = x80 + x84
    x103 = x0 * (x101 + 2.0 * x30 + x60 + x96) + x102 * x33
    x104 = x6 * x69
    x105 = x71 * x88
    x106 = x104 * x88**2
    x107 = x0 * x104
    x108 = x106 + x107
    x109 = x73 * x92
    x110 = x73 * x91
    x111 = 2.0 * x110
    x112 = x109 + x111
    x113 = x33 * x7
    x114 = x0 * (x10 + x113)
    x115 = x12 + x93
    x116 = x115 * x33
    x117 = x0 * (2.0 * x114 + 2.0 * x116 + x51 + 2.0 * x79) + x33 * x96
    x118 = x104 * x88
    x119 = x73 * x89
    x120 = x108 * x88
    x121 = x107 * x88
    x122 = 2.0 * x121
    x123 = x120 + x122
    x124 = -x72 - A[1]
    x125 = x67 * x71
    x126 = x124 * x89
    x127 = x126 * x73
    x128 = x127 + x91
    x129 = x124 * x92
    x130 = x111 + x129
    x131 = 3.0 * x91
    x132 = x0 * (x131 + 3.0 * x90)
    x133 = x112 * x124
    x134 = x132 + x133
    x135 = -x87 - A[2]
    x136 = x135 * x71
    x137 = x104 * x135
    x138 = x137 * x88
    x139 = x107 + x138
    x140 = x108 * x135
    x141 = x122 + x140
    x142 = 3.0 * x107
    x143 = x0 * (3.0 * x106 + x142)
    x144 = x123 * x135
    x145 = x143 + x144
    x146 = x124**2 * x89
    x147 = x146 + x91
    x148 = x0 * (x119 + x126)
    x149 = x124 * x128
    x150 = x148 + x149
    x151 = 2.0 * x127 + x131
    x152 = x0 * (x151 + x90)
    x153 = x124 * x130
    x154 = x152 + x153
    x155 = x0 * (x109 + 8.0 * x110 + 3.0 * x129) + x124 * x134
    x156 = x104 * x135**2
    x157 = x107 + x156
    x158 = x0 * (x118 + x137)
    x159 = x135 * x139
    x160 = x158 + x159
    x161 = 2.0 * x138 + x142
    x162 = x0 * (x106 + x161)
    x163 = x135 * x141
    x164 = x162 + x163
    x165 = x0 * (x120 + 8.0 * x121 + 3.0 * x140) + x135 * x145
    x166 = 2.0 * x91
    x167 = x124 * x147 + x124 * x166
    x168 = x0 * (x146 + x151) + x124 * x150
    x169 = x0 * (4.0 * x110 + 2.0 * x129 + 2.0 * x148 + 2.0 * x149) + x124 * x154
    x170 = x0 * (2.0 * x132 + 2.0 * x133 + 3.0 * x152 + 3.0 * x153) + x124 * x155
    x171 = 2.0 * x107
    x172 = x135 * x157 + x135 * x171
    x173 = x0 * (x156 + x161) + x135 * x160
    x174 = x0 * (4.0 * x121 + 2.0 * x140 + 2.0 * x158 + 2.0 * x159) + x135 * x164
    x175 = x0 * (2.0 * x143 + 2.0 * x144 + 3.0 * x162 + 3.0 * x163) + x135 * x165
    x176 = -x72 - C[1]
    x177 = x0 * (8.0 * x0 * x8 + x37 + 3.0 * x76) + x33 * x41
    x178 = x42 + x48
    x179 = x71 * (x0 * (x177 + x65 + 3.0 * x78 + 3.0 * x82) + x178 * x33)
    x180 = x119 * x176
    x181 = x180 + x91
    x182 = x26 + 2.0 * x97
    x183 = x0 * (x182 + x25)
    x184 = x33 * x77
    x185 = x183 + x184
    x186 = x78 + x82
    x187 = x0 * (x101 + x185 + x29 + x58) + x186 * x33
    x188 = x176 * x89
    x189 = x0 * (x119 + x188)
    x190 = x181 * x73
    x191 = x189 + x190
    x192 = x114 + x116
    x193 = x0 * (x113 + x8)
    x194 = x12 + x97
    x195 = x194 * x33
    x196 = x193 + x195
    x197 = x100 + x98
    x198 = x0 * (x192 + x196 + x49 + x75) + x197 * x33
    x199 = x131 + 2.0 * x180
    x200 = x0 * (x199 + x90)
    x201 = x191 * x73
    x202 = x200 + x201
    x203 = x33**2 * x7
    x204 = x0 * (x203 + x94) + x192 * x33
    x205 = x126 * x176
    x206 = x205 + x91
    x207 = x124 * x181
    x208 = x189 + x207
    x209 = x124 * x191
    x210 = x200 + x209
    x211 = 3.0 * x189
    x212 = x0 * (x112 + 3.0 * x190 + x211)
    x213 = x124 * x202
    x214 = x212 + x213
    x215 = x0 * (x126 + x188)
    x216 = x124 * x206
    x217 = x215 + x216
    x218 = x0 * (x127 + x131 + x180 + x205)
    x219 = x124 * x208
    x220 = x218 + x219
    x221 = 2.0 * x207
    x222 = x0 * (x130 + x190 + x211 + x221)
    x223 = x124 * x210
    x224 = x222 + x223
    x225 = x0 * (x134 + 4.0 * x200 + x201 + 3.0 * x209)
    x226 = x124 * x214
    x227 = x225 + x226
    x228 = x131 + 2.0 * x205
    x229 = x0 * (x146 + x228) + x124 * x217
    x230 = 2.0 * x189
    x231 = x0 * (x150 + x217 + x221 + x230) + x124 * x220
    x232 = 2.0 * x200
    x233 = 2.0 * x209
    x234 = 2.0 * x218 + 2.0 * x219
    x235 = x0 * (x154 + x232 + x233 + x234) + x124 * x224
    x236 = 2.0 * x212 + 2.0 * x213
    x237 = x5 * x70
    x238 = x237 * (x0 * (x155 + 3.0 * x222 + 3.0 * x223 + x236) + x124 * x227)
    x239 = x237 * x9
    x240 = 3.14159265358979 * x1 * x5 * x68
    x241 = x240 * x9
    x242 = -x87 - C[2]
    x243 = x242 * x71
    x244 = x118 * x242
    x245 = x107 + x244
    x246 = x104 * x242
    x247 = x0 * (x118 + x246)
    x248 = x245 * x88
    x249 = x247 + x248
    x250 = x142 + 2.0 * x244
    x251 = x0 * (x106 + x250)
    x252 = x249 * x88
    x253 = x251 + x252
    x254 = x137 * x242
    x255 = x107 + x254
    x256 = x135 * x245
    x257 = x247 + x256
    x258 = x135 * x249
    x259 = x251 + x258
    x260 = 3.0 * x247
    x261 = x0 * (x123 + 3.0 * x248 + x260)
    x262 = x135 * x253
    x263 = x261 + x262
    x264 = x0 * (x137 + x246)
    x265 = x135 * x255
    x266 = x264 + x265
    x267 = x0 * (x138 + x142 + x244 + x254)
    x268 = x135 * x257
    x269 = x267 + x268
    x270 = 2.0 * x256
    x271 = x0 * (x141 + x248 + x260 + x270)
    x272 = x135 * x259
    x273 = x271 + x272
    x274 = x0 * (x145 + 4.0 * x251 + x252 + 3.0 * x258)
    x275 = x135 * x263
    x276 = x274 + x275
    x277 = x142 + 2.0 * x254
    x278 = x0 * (x156 + x277) + x135 * x266
    x279 = 2.0 * x247
    x280 = x0 * (x160 + x266 + x270 + x279) + x135 * x269
    x281 = 2.0 * x251
    x282 = 2.0 * x258
    x283 = 2.0 * x267 + 2.0 * x268
    x284 = x0 * (x164 + x281 + x282 + x283) + x135 * x273
    x285 = 2.0 * x261 + 2.0 * x262
    x286 = x240 * (x0 * (x165 + 3.0 * x271 + 3.0 * x272 + x285) + x135 * x276)
    x287 = x176**2 * x89
    x288 = x287 + x91
    x289 = x0 * (3.0 * x183 + 3.0 * x184 + 2.0 * x35 + 2.0 * x40) + x177 * x33
    x290 = x288 * x73
    x291 = x166 * x176
    x292 = x290 + x291
    x293 = x0 * (2.0 * x193 + 2.0 * x195 + x50 * x8 + 2.0 * x76) + x185 * x33
    x294 = x0 * (x199 + x287)
    x295 = x292 * x73
    x296 = x294 + x295
    x297 = x0 * (x182 + x203) + x196 * x33
    x298 = 4.0 * x176 * x91
    x299 = x230 + x298
    x300 = x0 * (2.0 * x190 + 2.0 * x290 + x299)
    x301 = x296 * x73
    x302 = x300 + x301
    x303 = x12 + x203
    x304 = 2.0 * x12 * x33 + x303 * x33
    x305 = x124 * x288
    x306 = x291 + x305
    x307 = x124 * x292
    x308 = x294 + x307
    x309 = x124 * x296
    x310 = x300 + x309
    x311 = x232 + 3.0 * x294
    x312 = x0 * (2.0 * x201 + 3.0 * x295 + x311)
    x313 = x124 * x302
    x314 = x312 + x313
    x315 = x0 * (x228 + x287) + x124 * x306
    x316 = x0 * (x221 + x290 + x299 + x305)
    x317 = x124 * x308
    x318 = x316 + x317
    x319 = 2.0 * x307
    x320 = x0 * (x233 + x295 + x311 + x319)
    x321 = x124 * x310
    x322 = x320 + x321
    x323 = x0 * (x236 + 4.0 * x300 + x301 + 3.0 * x309) + x124 * x314
    x324 = x237 * x323
    x325 = x237 * x33
    x326 = x0 * (2.0 * x215 + 2.0 * x216 + x298 + 2.0 * x305) + x124 * x315
    x327 = x0 * (x234 + 2.0 * x294 + x315 + x319) + x124 * x318
    x328 = x237 * (
        x0 * (2.0 * x222 + 2.0 * x223 + 2.0 * x300 + 2.0 * x309 + 2.0 * x316 + 2.0 * x317)
        + x124 * x322
    )
    x329 = x237 * x3
    x330 = x176 * x240
    x331 = x104 * x242**2
    x332 = x107 + x331
    x333 = x332 * x88
    x334 = x171 * x242
    x335 = x333 + x334
    x336 = x0 * (x250 + x331)
    x337 = x335 * x88
    x338 = x336 + x337
    x339 = 4.0 * x107 * x242
    x340 = x279 + x339
    x341 = x0 * (2.0 * x248 + 2.0 * x333 + x340)
    x342 = x338 * x88
    x343 = x341 + x342
    x344 = x135 * x332
    x345 = x334 + x344
    x346 = x135 * x335
    x347 = x336 + x346
    x348 = x135 * x338
    x349 = x341 + x348
    x350 = x281 + 3.0 * x336
    x351 = x0 * (2.0 * x252 + 3.0 * x337 + x350)
    x352 = x135 * x343
    x353 = x351 + x352
    x354 = x240 * x33
    x355 = x0 * (x277 + x331) + x135 * x345
    x356 = x0 * (x270 + x333 + x340 + x344)
    x357 = x135 * x347
    x358 = x356 + x357
    x359 = 2.0 * x346
    x360 = x0 * (x282 + x337 + x350 + x359)
    x361 = x135 * x349
    x362 = x360 + x361
    x363 = x0 * (x285 + 4.0 * x341 + x342 + 3.0 * x348) + x135 * x353
    x364 = x240 * x363
    x365 = x240 * x3
    x366 = x0 * (2.0 * x264 + 2.0 * x265 + x339 + 2.0 * x344) + x135 * x355
    x367 = x0 * (x283 + 2.0 * x336 + x355 + x359) + x135 * x358
    x368 = x240 * (
        x0 * (2.0 * x271 + 2.0 * x272 + 2.0 * x341 + 2.0 * x348 + 2.0 * x356 + 2.0 * x357)
        + x135 * x362
    )

    # 600 item(s)
    return numpy.array(
        [
            x71
            * (
                x0
                * (2.0 * x32 + 2.0 * x42 + 2.0 * x48 + 2.0 * x57 + 3.0 * x61 + 3.0 * x64)
                + x33 * x67
            ),
            x73 * x86,
            x86 * x88,
            x103 * x104 * x92,
            x103 * x105 * x73,
            x103 * x108 * x89,
            x104 * x112 * x117,
            x117 * x118 * x92,
            x108 * x117 * x119,
            x117 * x123 * x89,
            x124 * x125,
            x104 * x128 * x85,
            x105 * x124 * x85,
            x102 * x104 * x130,
            x102 * x118 * x128,
            x102 * x108 * x126,
            x104 * x134 * x96,
            x118 * x130 * x96,
            x108 * x128 * x96,
            x123 * x126 * x96,
            x125 * x135,
            x136 * x73 * x85,
            x139 * x85 * x89,
            x102 * x137 * x92,
            x102 * x119 * x139,
            x102 * x141 * x89,
            x112 * x137 * x96,
            x139 * x92 * x96,
            x119 * x141 * x96,
            x145 * x89 * x96,
            x104 * x147 * x66,
            x104 * x150 * x63,
            x118 * x147 * x63,
            x104 * x154 * x83,
            x118 * x150 * x83,
            x108 * x147 * x83,
            x104 * x155 * x95,
            x118 * x154 * x95,
            x108 * x150 * x95,
            x123 * x147 * x95,
            x124 * x136 * x66,
            x128 * x137 * x63,
            x126 * x139 * x63,
            x130 * x137 * x83,
            x128 * x139 * x83,
            x126 * x141 * x83,
            x134 * x137 * x95,
            x130 * x139 * x95,
            x128 * x141 * x95,
            x126 * x145 * x95,
            x157 * x66 * x89,
            x119 * x157 * x63,
            x160 * x63 * x89,
            x157 * x83 * x92,
            x119 * x160 * x83,
            x164 * x83 * x89,
            x112 * x157 * x95,
            x160 * x92 * x95,
            x119 * x164 * x95,
            x165 * x89 * x95,
            x104 * x167 * x56,
            x104 * x168 * x54,
            x118 * x167 * x54,
            x104 * x169 * x23,
            x118 * x168 * x23,
            x108 * x167 * x23,
            x104 * x170 * x19,
            x118 * x169 * x19,
            x108 * x168 * x19,
            x123 * x167 * x19,
            x137 * x147 * x56,
            x137 * x150 * x54,
            x139 * x147 * x54,
            x137 * x154 * x23,
            x139 * x150 * x23,
            x141 * x147 * x23,
            x137 * x155 * x19,
            x139 * x154 * x19,
            x141 * x150 * x19,
            x145 * x147 * x19,
            x126 * x157 * x56,
            x128 * x157 * x54,
            x126 * x160 * x54,
            x130 * x157 * x23,
            x128 * x160 * x23,
            x126 * x164 * x23,
            x134 * x157 * x19,
            x130 * x160 * x19,
            x128 * x164 * x19,
            x126 * x165 * x19,
            x172 * x56 * x89,
            x119 * x172 * x54,
            x173 * x54 * x89,
            x172 * x23 * x92,
            x119 * x173 * x23,
            x174 * x23 * x89,
            x112 * x172 * x19,
            x173 * x19 * x92,
            x119 * x174 * x19,
            x175 * x19 * x89,
            x176 * x179,
            x104 * x181 * x187,
            x105 * x176 * x187,
            x104 * x191 * x198,
            x118 * x181 * x198,
            x108 * x188 * x198,
            x104 * x202 * x204,
            x118 * x191 * x204,
            x108 * x181 * x204,
            x123 * x188 * x204,
            x104 * x178 * x206,
            x104 * x186 * x208,
            x118 * x186 * x206,
            x104 * x197 * x210,
            x118 * x197 * x208,
            x108 * x197 * x206,
            x104 * x192 * x214,
            x118 * x192 * x210,
            x108 * x192 * x208,
            x123 * x192 * x206,
            x136 * x176 * x178,
            x137 * x181 * x186,
            x139 * x186 * x188,
            x137 * x191 * x197,
            x139 * x181 * x197,
            x141 * x188 * x197,
            x137 * x192 * x202,
            x139 * x191 * x192,
            x141 * x181 * x192,
            x145 * x188 * x192,
            x104 * x217 * x47,
            x104 * x220 * x81,
            x118 * x217 * x81,
            x104 * x224 * x99,
            x118 * x220 * x99,
            x108 * x217 * x99,
            x104 * x115 * x227,
            x115 * x118 * x224,
            x108 * x115 * x220,
            x115 * x123 * x217,
            x137 * x206 * x47,
            x137 * x208 * x81,
            x139 * x206 * x81,
            x137 * x210 * x99,
            x139 * x208 * x99,
            x141 * x206 * x99,
            x115 * x137 * x214,
            x115 * x139 * x210,
            x115 * x141 * x208,
            x115 * x145 * x206,
            x157 * x188 * x47,
            x157 * x181 * x81,
            x160 * x188 * x81,
            x157 * x191 * x99,
            x160 * x181 * x99,
            x164 * x188 * x99,
            x115 * x157 * x202,
            x115 * x160 * x191,
            x115 * x164 * x181,
            x115 * x165 * x188,
            x104 * x229 * x45,
            x104 * x16 * x231,
            x118 * x16 * x229,
            x104 * x14 * x235,
            x118 * x14 * x231,
            x108 * x14 * x229,
            x238 * x9,
            x235 * x239 * x88,
            x10 * x108 * x231,
            x10 * x123 * x229,
            x137 * x217 * x45,
            x137 * x16 * x220,
            x139 * x16 * x217,
            x137 * x14 * x224,
            x139 * x14 * x220,
            x14 * x141 * x217,
            x135 * x227 * x239,
            x10 * x139 * x224,
            x10 * x141 * x220,
            x10 * x145 * x217,
            x157 * x206 * x45,
            x157 * x16 * x208,
            x16 * x160 * x206,
            x14 * x157 * x210,
            x14 * x160 * x208,
            x14 * x164 * x206,
            x10 * x157 * x214,
            x10 * x160 * x210,
            x10 * x164 * x208,
            x10 * x165 * x206,
            x172 * x188 * x45,
            x16 * x172 * x181,
            x16 * x173 * x188,
            x14 * x172 * x191,
            x14 * x173 * x181,
            x14 * x174 * x188,
            x10 * x172 * x202,
            x10 * x173 * x191,
            x10 * x174 * x181,
            x175 * x176 * x241,
            x179 * x242,
            x187 * x243 * x73,
            x187 * x245 * x89,
            x198 * x246 * x92,
            x119 * x198 * x245,
            x198 * x249 * x89,
            x112 * x204 * x246,
            x204 * x245 * x92,
            x119 * x204 * x249,
            x204 * x253 * x89,
            x124 * x178 * x243,
            x128 * x186 * x246,
            x126 * x186 * x245,
            x130 * x197 * x246,
            x128 * x197 * x245,
            x126 * x197 * x249,
            x134 * x192 * x246,
            x130 * x192 * x245,
            x128 * x192 * x249,
            x126 * x192 * x253,
            x178 * x255 * x89,
            x119 * x186 * x255,
            x186 * x257 * x89,
            x197 * x255 * x92,
            x119 * x197 * x257,
            x197 * x259 * x89,
            x112 * x192 * x255,
            x192 * x257 * x92,
            x119 * x192 * x259,
            x192 * x263 * x89,
            x147 * x246 * x47,
            x150 * x246 * x81,
            x147 * x245 * x81,
            x154 * x246 * x99,
            x150 * x245 * x99,
            x147 * x249 * x99,
            x115 * x155 * x246,
            x115 * x154 * x245,
            x115 * x150 * x249,
            x115 * x147 * x253,
            x126 * x255 * x47,
            x128 * x255 * x81,
            x126 * x257 * x81,
            x130 * x255 * x99,
            x128 * x257 * x99,
            x126 * x259 * x99,
            x115 * x134 * x255,
            x115 * x130 * x257,
            x115 * x128 * x259,
            x115 * x126 * x263,
            x266 * x47 * x89,
            x119 * x266 * x81,
            x269 * x81 * x89,
            x266 * x92 * x99,
            x119 * x269 * x99,
            x273 * x89 * x99,
            x112 * x115 * x266,
            x115 * x269 * x92,
            x115 * x119 * x273,
            x115 * x276 * x89,
            x167 * x246 * x45,
            x16 * x168 * x246,
            x16 * x167 * x245,
            x14 * x169 * x246,
            x14 * x168 * x245,
            x14 * x167 * x249,
            x170 * x239 * x242,
            x10 * x169 * x245,
            x10 * x168 * x249,
            x10 * x167 * x253,
            x147 * x255 * x45,
            x150 * x16 * x255,
            x147 * x16 * x257,
            x14 * x154 * x255,
            x14 * x150 * x257,
            x14 * x147 * x259,
            x10 * x155 * x255,
            x10 * x154 * x257,
            x10 * x150 * x259,
            x10 * x147 * x263,
            x126 * x266 * x45,
            x128 * x16 * x266,
            x126 * x16 * x269,
            x130 * x14 * x266,
            x128 * x14 * x269,
            x126 * x14 * x273,
            x10 * x134 * x266,
            x10 * x130 * x269,
            x10 * x128 * x273,
            x124 * x241 * x276,
            x278 * x45 * x89,
            x119 * x16 * x278,
            x16 * x280 * x89,
            x14 * x278 * x92,
            x119 * x14 * x280,
            x14 * x284 * x89,
            x10 * x112 * x278,
            x10 * x280 * x92,
            x241 * x284 * x73,
            x286 * x9,
            x104 * x288 * x289,
            x104 * x292 * x293,
            x118 * x288 * x293,
            x104 * x296 * x297,
            x118 * x292 * x297,
            x108 * x288 * x297,
            x104 * x302 * x304,
            x118 * x296 * x304,
            x108 * x292 * x304,
            x123 * x288 * x304,
            x104 * x177 * x306,
            x104 * x185 * x308,
            x118 * x185 * x306,
            x104 * x196 * x310,
            x118 * x196 * x308,
            x108 * x196 * x306,
            x104 * x303 * x314,
            x118 * x303 * x310,
            x108 * x303 * x308,
            x123 * x303 * x306,
            x137 * x177 * x288,
            x137 * x185 * x292,
            x139 * x185 * x288,
            x137 * x196 * x296,
            x139 * x196 * x292,
            x141 * x196 * x288,
            x137 * x302 * x303,
            x139 * x296 * x303,
            x141 * x292 * x303,
            x145 * x288 * x303,
            x104 * x315 * x41,
            x104 * x318 * x77,
            x118 * x315 * x77,
            x104 * x194 * x322,
            x118 * x194 * x318,
            x108 * x194 * x315,
            x324 * x33,
            x322 * x325 * x88,
            x108 * x113 * x318,
            x113 * x123 * x315,
            x137 * x306 * x41,
            x137 * x308 * x77,
            x139 * x306 * x77,
            x137 * x194 * x310,
            x139 * x194 * x308,
            x141 * x194 * x306,
            x135 * x314 * x325,
            x113 * x139 * x310,
            x113 * x141 * x308,
            x113 * x145 * x306,
            x157 * x288 * x41,
            x157 * x292 * x77,
            x160 * x288 * x77,
            x157 * x194 * x296,
            x160 * x194 * x292,
            x164 * x194 * x288,
            x113 * x157 * x302,
            x113 * x160 * x296,
            x113 * x164 * x292,
            x113 * x165 * x288,
            x104 * x326 * x39,
            x104 * x327 * x36,
            x118 * x326 * x36,
            x3 * x328,
            x327 * x329 * x88,
            x108 * x326 * x8,
            x237
            * (
                x0
                * (
                    2.0 * x225
                    + 2.0 * x226
                    + 2.0 * x312
                    + 2.0 * x313
                    + 3.0 * x320
                    + 3.0 * x321
                )
                + x124 * x323
            ),
            x328 * x88,
            x108 * x327 * x7,
            x123 * x326 * x7,
            x137 * x315 * x39,
            x137 * x318 * x36,
            x139 * x315 * x36,
            x135 * x322 * x329,
            x139 * x318 * x8,
            x141 * x315 * x8,
            x135 * x324,
            x139 * x322 * x7,
            x141 * x318 * x7,
            x145 * x315 * x7,
            x157 * x306 * x39,
            x157 * x308 * x36,
            x160 * x306 * x36,
            x157 * x310 * x8,
            x160 * x308 * x8,
            x164 * x306 * x8,
            x157 * x314 * x7,
            x160 * x310 * x7,
            x164 * x308 * x7,
            x165 * x306 * x7,
            x172 * x288 * x39,
            x172 * x292 * x36,
            x173 * x288 * x36,
            x172 * x296 * x8,
            x173 * x292 * x8,
            x174 * x288 * x8,
            x172 * x302 * x7,
            x173 * x296 * x7,
            x174 * x292 * x7,
            x175 * x288 * x7,
            x176 * x243 * x289,
            x181 * x246 * x293,
            x188 * x245 * x293,
            x191 * x246 * x297,
            x181 * x245 * x297,
            x188 * x249 * x297,
            x202 * x246 * x304,
            x191 * x245 * x304,
            x181 * x249 * x304,
            x188 * x253 * x304,
            x177 * x206 * x246,
            x185 * x208 * x246,
            x185 * x206 * x245,
            x196 * x210 * x246,
            x196 * x208 * x245,
            x196 * x206 * x249,
            x214 * x246 * x303,
            x210 * x245 * x303,
            x208 * x249 * x303,
            x206 * x253 * x303,
            x177 * x188 * x255,
            x181 * x185 * x255,
            x185 * x188 * x257,
            x191 * x196 * x255,
            x181 * x196 * x257,
            x188 * x196 * x259,
            x202 * x255 * x303,
            x191 * x257 * x303,
            x181 * x259 * x303,
            x188 * x263 * x303,
            x217 * x246 * x41,
            x220 * x246 * x77,
            x217 * x245 * x77,
            x194 * x224 * x246,
            x194 * x220 * x245,
            x194 * x217 * x249,
            x227 * x242 * x325,
            x113 * x224 * x245,
            x113 * x220 * x249,
            x113 * x217 * x253,
            x206 * x255 * x41,
            x208 * x255 * x77,
            x206 * x257 * x77,
            x194 * x210 * x255,
            x194 * x208 * x257,
            x194 * x206 * x259,
            x113 * x214 * x255,
            x113 * x210 * x257,
            x113 * x208 * x259,
            x113 * x206 * x263,
            x188 * x266 * x41,
            x181 * x266 * x77,
            x188 * x269 * x77,
            x191 * x194 * x266,
            x181 * x194 * x269,
            x188 * x194 * x273,
            x113 * x202 * x266,
            x113 * x191 * x269,
            x113 * x181 * x273,
            x276 * x33 * x330,
            x229 * x246 * x39,
            x231 * x246 * x36,
            x229 * x245 * x36,
            x235 * x242 * x329,
            x231 * x245 * x8,
            x229 * x249 * x8,
            x238 * x242,
            x235 * x245 * x7,
            x231 * x249 * x7,
            x229 * x253 * x7,
            x217 * x255 * x39,
            x220 * x255 * x36,
            x217 * x257 * x36,
            x224 * x255 * x8,
            x220 * x257 * x8,
            x217 * x259 * x8,
            x227 * x255 * x7,
            x224 * x257 * x7,
            x220 * x259 * x7,
            x217 * x263 * x7,
            x206 * x266 * x39,
            x208 * x266 * x36,
            x206 * x269 * x36,
            x210 * x266 * x8,
            x208 * x269 * x8,
            x206 * x273 * x8,
            x214 * x266 * x7,
            x210 * x269 * x7,
            x208 * x273 * x7,
            x206 * x276 * x7,
            x188 * x278 * x39,
            x181 * x278 * x36,
            x188 * x280 * x36,
            x191 * x278 * x8,
            x181 * x280 * x8,
            x284 * x3 * x330,
            x202 * x278 * x7,
            x191 * x280 * x7,
            x181 * x284 * x7,
            x176 * x286,
            x289 * x332 * x89,
            x119 * x293 * x332,
            x293 * x335 * x89,
            x297 * x332 * x92,
            x119 * x297 * x335,
            x297 * x338 * x89,
            x112 * x304 * x332,
            x304 * x335 * x92,
            x119 * x304 * x338,
            x304 * x343 * x89,
            x126 * x177 * x332,
            x128 * x185 * x332,
            x126 * x185 * x335,
            x130 * x196 * x332,
            x128 * x196 * x335,
            x126 * x196 * x338,
            x134 * x303 * x332,
            x130 * x303 * x335,
            x128 * x303 * x338,
            x126 * x303 * x343,
            x177 * x345 * x89,
            x119 * x185 * x345,
            x185 * x347 * x89,
            x196 * x345 * x92,
            x119 * x196 * x347,
            x196 * x349 * x89,
            x112 * x303 * x345,
            x303 * x347 * x92,
            x119 * x303 * x349,
            x303 * x353 * x89,
            x147 * x332 * x41,
            x150 * x332 * x77,
            x147 * x335 * x77,
            x154 * x194 * x332,
            x150 * x194 * x335,
            x147 * x194 * x338,
            x113 * x155 * x332,
            x113 * x154 * x335,
            x113 * x150 * x338,
            x113 * x147 * x343,
            x126 * x345 * x41,
            x128 * x345 * x77,
            x126 * x347 * x77,
            x130 * x194 * x345,
            x128 * x194 * x347,
            x126 * x194 * x349,
            x113 * x134 * x345,
            x113 * x130 * x347,
            x113 * x128 * x349,
            x124 * x353 * x354,
            x355 * x41 * x89,
            x119 * x355 * x77,
            x358 * x77 * x89,
            x194 * x355 * x92,
            x119 * x194 * x358,
            x194 * x362 * x89,
            x112 * x113 * x355,
            x113 * x358 * x92,
            x354 * x362 * x73,
            x33 * x364,
            x167 * x332 * x39,
            x168 * x332 * x36,
            x167 * x335 * x36,
            x169 * x332 * x8,
            x168 * x335 * x8,
            x167 * x338 * x8,
            x170 * x332 * x7,
            x169 * x335 * x7,
            x168 * x338 * x7,
            x167 * x343 * x7,
            x147 * x345 * x39,
            x150 * x345 * x36,
            x147 * x347 * x36,
            x154 * x345 * x8,
            x150 * x347 * x8,
            x147 * x349 * x8,
            x155 * x345 * x7,
            x154 * x347 * x7,
            x150 * x349 * x7,
            x147 * x353 * x7,
            x126 * x355 * x39,
            x128 * x355 * x36,
            x126 * x358 * x36,
            x130 * x355 * x8,
            x128 * x358 * x8,
            x124 * x362 * x365,
            x134 * x355 * x7,
            x130 * x358 * x7,
            x128 * x362 * x7,
            x124 * x364,
            x366 * x39 * x89,
            x119 * x36 * x366,
            x36 * x367 * x89,
            x366 * x8 * x92,
            x365 * x367 * x73,
            x3 * x368,
            x112 * x366 * x7,
            x367 * x7 * x92,
            x368 * x73,
            x240
            * (
                x0
                * (
                    2.0 * x274
                    + 2.0 * x275
                    + 2.0 * x351
                    + 2.0 * x352
                    + 3.0 * x360
                    + 3.0 * x361
                )
                + x135 * x363
            ),
        ]
    )


def quadrupole3d_34(a, A, b, B, C):
    """Cartesian 3D (fg) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3**2 * x7
    x9 = x0 * x7
    x10 = 3.0 * x9
    x11 = -x2 - C[0]
    x12 = x3 * x7
    x13 = x11 * x12
    x14 = x10 + 2.0 * x13
    x15 = x0 * (x14 + x8)
    x16 = x11 * x7
    x17 = x0 * (x12 + x16)
    x18 = x13 + x9
    x19 = x18 * x3
    x20 = x17 + x19
    x21 = x20 * x3
    x22 = x15 + x21
    x23 = x22 * x3
    x24 = x11**2 * x7
    x25 = x0 * (x14 + x24)
    x26 = x24 + x9
    x27 = x26 * x3
    x28 = 2.0 * x9
    x29 = x11 * x28
    x30 = x27 + x29
    x31 = x3 * x30
    x32 = x25 + x31
    x33 = x3 * x32
    x34 = 3.0 * x17
    x35 = x8 + x9
    x36 = x3 * x35
    x37 = x28 * x3
    x38 = x36 + x37
    x39 = x0 * (3.0 * x19 + x34 + x38)
    x40 = 2.0 * x39
    x41 = 2.0 * x17
    x42 = 4.0 * x9
    x43 = x11 * x42
    x44 = x41 + x43
    x45 = x0 * (2.0 * x19 + 2.0 * x27 + x44)
    x46 = x40 + 4.0 * x45
    x47 = x0 * (2.0 * x23 + 4.0 * x33 + x46)
    x48 = -x2 - A[0]
    x49 = x22 * x48
    x50 = 8.0 * x3 * x9
    x51 = x0 * (4.0 * x36 + x50)
    x52 = x0 * (x10 + 3.0 * x8)
    x53 = x3 * x38
    x54 = x52 + x53
    x55 = x48 * x54
    x56 = x51 + x55
    x57 = x0 * (x23 + 5.0 * x39 + 4.0 * x49 + x56)
    x58 = 4.0 * x15
    x59 = x0 * (4.0 * x21 + x54 + x58)
    x60 = x23 + x39
    x61 = x48 * x60
    x62 = x59 + x61
    x63 = x48 * x62
    x64 = 2.0 * x15
    x65 = 3.0 * x25 + x64
    x66 = x0 * (2.0 * x21 + 3.0 * x31 + x65)
    x67 = x33 + x45
    x68 = x3 * x67
    x69 = x66 + x68
    x70 = x48 * x69
    x71 = 2.0 * x49
    x72 = x32 * x48
    x73 = x0 * (x33 + x46 + x71 + 3.0 * x72)
    x74 = x48 * x67
    x75 = x66 + x74
    x76 = x48 * x75
    x77 = 2.0 * x59 + 2.0 * x61
    x78 = x47 + x70
    x79 = x0 * (5.0 * x66 + x68 + 4.0 * x74 + x77) + x48 * x78
    x80 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x81 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x82 = 3.14159265358979 * x1 * x81
    x83 = x80 * x82
    x84 = -x1 * (a * A[1] + b * B[1])
    x85 = -x84 - B[1]
    x86 = x20 * x48
    x87 = x38 * x48
    x88 = x52 + x87
    x89 = x0 * (x21 + x58 + 3.0 * x86 + x88)
    x90 = x39 + x49
    x91 = x48 * x90
    x92 = 2.0 * x86
    x93 = x30 * x48
    x94 = 2.0 * x93
    x95 = x0 * (x31 + x65 + x92 + x94)
    x96 = x45 + x72
    x97 = x48 * x96
    x98 = x73 + x76
    x99 = x83 * (
        x0 * (2.0 * x66 + 2.0 * x74 + 2.0 * x89 + 2.0 * x91 + 3.0 * x95 + 3.0 * x97)
        + x48 * x98
    )
    x100 = -x1 * (a * A[2] + b * B[2])
    x101 = -x100 - B[2]
    x102 = x6 * x80
    x103 = x102 * x85**2
    x104 = x0 * x102
    x105 = x103 + x104
    x106 = x18 * x48
    x107 = 2.0 * x106
    x108 = x35 * x48
    x109 = x108 + x37
    x110 = x0 * (x107 + x109 + x19 + x34)
    x111 = x26 * x48
    x112 = x0 * (x107 + x111 + x27 + x44)
    x113 = x15 + x86
    x114 = x113 * x48
    x115 = x25 + x93
    x116 = x115 * x48
    x117 = x95 + x97
    x118 = (
        x0 * (2.0 * x110 + 2.0 * x112 + 2.0 * x114 + 2.0 * x116 + 2.0 * x45 + 2.0 * x72)
        + x117 * x48
    )
    x119 = x6 * x81
    x120 = x101 * x83
    x121 = x101**2 * x119
    x122 = x0 * x119
    x123 = x121 + x122
    x124 = x105 * x85
    x125 = x104 * x85
    x126 = 2.0 * x125
    x127 = x124 + x126
    x128 = x16 * x48
    x129 = x10 + 2.0 * x128
    x130 = x111 + x29
    x131 = x0 * (x129 + x24) + x130 * x48
    x132 = x12 * x48
    x133 = x0 * (x10 + x128 + x13 + x132)
    x134 = x106 + x17
    x135 = x134 * x48
    x136 = 2.0 * x133 + 2.0 * x135
    x137 = x112 + x116
    x138 = x0 * (x131 + x136 + 2.0 * x25 + x94) + x137 * x48
    x139 = x101 * x119
    x140 = x102 * x85
    x141 = x101 * x123
    x142 = x101 * x122
    x143 = 2.0 * x142
    x144 = x141 + x143
    x145 = 3.0 * x104
    x146 = x0 * (3.0 * x103 + x145)
    x147 = x127 * x85
    x148 = x146 + x147
    x149 = x48 * x7
    x150 = x0 * (x149 + x16)
    x151 = x128 + x9
    x152 = x151 * x48
    x153 = x0 * (2.0 * x111 + 2.0 * x150 + 2.0 * x152 + x43) + x131 * x48
    x154 = 3.0 * x122
    x155 = x0 * (3.0 * x121 + x154)
    x156 = x101 * x144
    x157 = x155 + x156
    x158 = -x84 - A[1]
    x159 = x79 * x83
    x160 = x102 * x158
    x161 = x160 * x85
    x162 = x104 + x161
    x163 = x105 * x158
    x164 = x126 + x163
    x165 = x127 * x158
    x166 = x146 + x165
    x167 = 8.0 * x125
    x168 = x0 * (4.0 * x124 + x167)
    x169 = x148 * x158
    x170 = x168 + x169
    x171 = -x100 - A[2]
    x172 = x171 * x83
    x173 = x119 * x171
    x174 = x101 * x173
    x175 = x122 + x174
    x176 = x123 * x171
    x177 = x143 + x176
    x178 = x144 * x171
    x179 = x155 + x178
    x180 = 8.0 * x142
    x181 = x0 * (4.0 * x141 + x180)
    x182 = x157 * x171
    x183 = x181 + x182
    x184 = x102 * x158**2
    x185 = x104 + x184
    x186 = x0 * (x140 + x160)
    x187 = x158 * x162
    x188 = x186 + x187
    x189 = x145 + 2.0 * x161
    x190 = x0 * (x103 + x189)
    x191 = x158 * x164
    x192 = x190 + x191
    x193 = x0 * (x124 + 3.0 * x163 + x167)
    x194 = x158 * x166
    x195 = x193 + x194
    x196 = x0 * (5.0 * x146 + x147 + 4.0 * x165) + x158 * x170
    x197 = x119 * x171**2
    x198 = x122 + x197
    x199 = x0 * (x139 + x173)
    x200 = x171 * x175
    x201 = x199 + x200
    x202 = x154 + 2.0 * x174
    x203 = x0 * (x121 + x202)
    x204 = x171 * x177
    x205 = x203 + x204
    x206 = x0 * (x141 + 3.0 * x176 + x180)
    x207 = x171 * x179
    x208 = x206 + x207
    x209 = x0 * (5.0 * x155 + x156 + 4.0 * x178) + x171 * x183
    x210 = 2.0 * x104
    x211 = x158 * x185 + x158 * x210
    x212 = x0 * (x184 + x189) + x158 * x188
    x213 = x0 * (4.0 * x125 + 2.0 * x163 + 2.0 * x186 + 2.0 * x187) + x158 * x192
    x214 = x0 * (2.0 * x146 + 2.0 * x165 + 3.0 * x190 + 3.0 * x191) + x158 * x195
    x215 = x0 * (2.0 * x168 + 2.0 * x169 + 4.0 * x193 + 4.0 * x194) + x158 * x196
    x216 = 2.0 * x122
    x217 = x171 * x198 + x171 * x216
    x218 = x0 * (x197 + x202) + x171 * x201
    x219 = x0 * (4.0 * x142 + 2.0 * x176 + 2.0 * x199 + 2.0 * x200) + x171 * x205
    x220 = x0 * (2.0 * x155 + 2.0 * x178 + 3.0 * x203 + 3.0 * x204) + x171 * x208
    x221 = x0 * (2.0 * x181 + 2.0 * x182 + 4.0 * x206 + 4.0 * x207) + x171 * x209
    x222 = -x84 - C[1]
    x223 = x0 * (5.0 * x52 + x53 + 4.0 * x87) + x48 * x56
    x224 = x57 + x63
    x225 = x83 * (x0 * (x223 + x77 + 4.0 * x89 + 4.0 * x91) + x224 * x48)
    x226 = x140 * x222
    x227 = x104 + x226
    x228 = x0 * (3.0 * x108 + x36 + x50)
    x229 = x48 * x88
    x230 = x228 + x229
    x231 = x89 + x91
    x232 = x0 * (3.0 * x110 + 3.0 * x114 + x230 + x40 + x71) + x231 * x48
    x233 = x102 * x222
    x234 = x0 * (x140 + x233)
    x235 = x227 * x85
    x236 = x234 + x235
    x237 = x10 + 2.0 * x132
    x238 = x0 * (x237 + x8)
    x239 = x109 * x48
    x240 = x238 + x239
    x241 = x110 + x114
    x242 = x0 * (x136 + x240 + x64 + x92) + x241 * x48
    x243 = x145 + 2.0 * x226
    x244 = x0 * (x103 + x243)
    x245 = x236 * x85
    x246 = x244 + x245
    x247 = x150 + x152
    x248 = x0 * (x12 + x149)
    x249 = x132 + x9
    x250 = x249 * x48
    x251 = x248 + x250
    x252 = x133 + x135
    x253 = x0 * (x107 + x247 + x251 + x41) + x252 * x48
    x254 = 3.0 * x234
    x255 = x0 * (x127 + 3.0 * x235 + x254)
    x256 = x246 * x85
    x257 = x255 + x256
    x258 = x48**2 * x7
    x259 = x0 * (x129 + x258) + x247 * x48
    x260 = x160 * x222
    x261 = x104 + x260
    x262 = x158 * x227
    x263 = x234 + x262
    x264 = x158 * x236
    x265 = x244 + x264
    x266 = x158 * x246
    x267 = x255 + x266
    x268 = 4.0 * x244
    x269 = x0 * (x148 + 4.0 * x245 + x268)
    x270 = x158 * x257
    x271 = x269 + x270
    x272 = x0 * (x160 + x233)
    x273 = x158 * x261
    x274 = x272 + x273
    x275 = x0 * (x145 + x161 + x226 + x260)
    x276 = x158 * x263
    x277 = x275 + x276
    x278 = 2.0 * x262
    x279 = x0 * (x164 + x235 + x254 + x278)
    x280 = x158 * x265
    x281 = x279 + x280
    x282 = x0 * (x166 + x245 + 3.0 * x264 + x268)
    x283 = x158 * x267
    x284 = x282 + x283
    x285 = x0 * (x170 + 5.0 * x255 + x256 + 4.0 * x266)
    x286 = x158 * x271
    x287 = x285 + x286
    x288 = x145 + 2.0 * x260
    x289 = x0 * (x184 + x288) + x158 * x274
    x290 = 2.0 * x234
    x291 = x0 * (x188 + x274 + x278 + x290) + x158 * x277
    x292 = 2.0 * x244
    x293 = 2.0 * x264
    x294 = 2.0 * x275 + 2.0 * x276
    x295 = x0 * (x192 + x292 + x293 + x294) + x158 * x281
    x296 = 2.0 * x255
    x297 = 2.0 * x266
    x298 = x0 * (x195 + 3.0 * x279 + 3.0 * x280 + x296 + x297) + x158 * x284
    x299 = 2.0 * x269 + 2.0 * x270
    x300 = x5 * x82
    x301 = x300 * (x0 * (x196 + 4.0 * x282 + 4.0 * x283 + x299) + x158 * x287)
    x302 = x11 * x300
    x303 = 3.14159265358979 * x1 * x5 * x80
    x304 = x11 * x303
    x305 = -x100 - C[2]
    x306 = x305 * x83
    x307 = x139 * x305
    x308 = x122 + x307
    x309 = x119 * x305
    x310 = x0 * (x139 + x309)
    x311 = x101 * x308
    x312 = x310 + x311
    x313 = x154 + 2.0 * x307
    x314 = x0 * (x121 + x313)
    x315 = x101 * x312
    x316 = x314 + x315
    x317 = 3.0 * x310
    x318 = x0 * (x144 + 3.0 * x311 + x317)
    x319 = x101 * x316
    x320 = x318 + x319
    x321 = x173 * x305
    x322 = x122 + x321
    x323 = x171 * x308
    x324 = x310 + x323
    x325 = x171 * x312
    x326 = x314 + x325
    x327 = x171 * x316
    x328 = x318 + x327
    x329 = 4.0 * x314
    x330 = x0 * (x157 + 4.0 * x315 + x329)
    x331 = x171 * x320
    x332 = x330 + x331
    x333 = x0 * (x173 + x309)
    x334 = x171 * x322
    x335 = x333 + x334
    x336 = x0 * (x154 + x174 + x307 + x321)
    x337 = x171 * x324
    x338 = x336 + x337
    x339 = 2.0 * x323
    x340 = x0 * (x177 + x311 + x317 + x339)
    x341 = x171 * x326
    x342 = x340 + x341
    x343 = x0 * (x179 + x315 + 3.0 * x325 + x329)
    x344 = x171 * x328
    x345 = x343 + x344
    x346 = x0 * (x183 + 5.0 * x318 + x319 + 4.0 * x327)
    x347 = x171 * x332
    x348 = x346 + x347
    x349 = x154 + 2.0 * x321
    x350 = x0 * (x197 + x349) + x171 * x335
    x351 = 2.0 * x310
    x352 = x0 * (x201 + x335 + x339 + x351) + x171 * x338
    x353 = 2.0 * x314
    x354 = 2.0 * x325
    x355 = 2.0 * x336 + 2.0 * x337
    x356 = x0 * (x205 + x353 + x354 + x355) + x171 * x342
    x357 = 2.0 * x318
    x358 = 2.0 * x327
    x359 = x0 * (x208 + 3.0 * x340 + 3.0 * x341 + x357 + x358) + x171 * x345
    x360 = 2.0 * x330 + 2.0 * x331
    x361 = x303 * (x0 * (x209 + 4.0 * x343 + 4.0 * x344 + x360) + x171 * x348)
    x362 = x102 * x222**2
    x363 = x104 + x362
    x364 = x0 * (4.0 * x228 + 4.0 * x229 + 2.0 * x51 + 2.0 * x55) + x223 * x48
    x365 = x363 * x85
    x366 = x210 * x222
    x367 = x365 + x366
    x368 = x0 * (3.0 * x238 + 3.0 * x239 + 2.0 * x52 + 2.0 * x87) + x230 * x48
    x369 = x0 * (x243 + x362)
    x370 = x367 * x85
    x371 = x369 + x370
    x372 = x0 * (2.0 * x108 + 2.0 * x248 + 2.0 * x250 + x3 * x42) + x240 * x48
    x373 = 4.0 * x104 * x222
    x374 = x290 + x373
    x375 = x0 * (2.0 * x235 + 2.0 * x365 + x374)
    x376 = x371 * x85
    x377 = x375 + x376
    x378 = x0 * (x237 + x258) + x251 * x48
    x379 = x292 + 3.0 * x369
    x380 = x0 * (2.0 * x245 + 3.0 * x370 + x379)
    x381 = x377 * x85
    x382 = x380 + x381
    x383 = x258 + x9
    x384 = x28 * x48 + x383 * x48
    x385 = x158 * x363
    x386 = x366 + x385
    x387 = x158 * x367
    x388 = x369 + x387
    x389 = x158 * x371
    x390 = x375 + x389
    x391 = x158 * x377
    x392 = x380 + x391
    x393 = x296 + 4.0 * x375
    x394 = x0 * (2.0 * x256 + 4.0 * x376 + x393)
    x395 = x158 * x382
    x396 = x394 + x395
    x397 = x0 * (x288 + x362) + x158 * x386
    x398 = x0 * (x278 + x365 + x374 + x385)
    x399 = x158 * x388
    x400 = x398 + x399
    x401 = 2.0 * x387
    x402 = x0 * (x293 + x370 + x379 + x401)
    x403 = x158 * x390
    x404 = x402 + x403
    x405 = x0 * (x297 + x376 + 3.0 * x389 + x393)
    x406 = x158 * x392
    x407 = x405 + x406
    x408 = x0 * (x299 + 5.0 * x380 + x381 + 4.0 * x391) + x158 * x396
    x409 = x300 * x408
    x410 = x300 * x48
    x411 = x0 * (2.0 * x272 + 2.0 * x273 + x373 + 2.0 * x385) + x158 * x397
    x412 = x0 * (x294 + 2.0 * x369 + x397 + x401) + x158 * x400
    x413 = (
        x0 * (2.0 * x279 + 2.0 * x280 + 2.0 * x375 + 2.0 * x389 + 2.0 * x398 + 2.0 * x399)
        + x158 * x404
    )
    x414 = x300 * (
        x0 * (2.0 * x282 + 2.0 * x283 + 2.0 * x380 + 2.0 * x391 + 3.0 * x402 + 3.0 * x403)
        + x158 * x407
    )
    x415 = x3 * x300
    x416 = x222 * x303
    x417 = x119 * x305**2
    x418 = x122 + x417
    x419 = x101 * x418
    x420 = x216 * x305
    x421 = x419 + x420
    x422 = x0 * (x313 + x417)
    x423 = x101 * x421
    x424 = x422 + x423
    x425 = 4.0 * x122 * x305
    x426 = x351 + x425
    x427 = x0 * (2.0 * x311 + 2.0 * x419 + x426)
    x428 = x101 * x424
    x429 = x427 + x428
    x430 = x353 + 3.0 * x422
    x431 = x0 * (2.0 * x315 + 3.0 * x423 + x430)
    x432 = x101 * x429
    x433 = x431 + x432
    x434 = x171 * x418
    x435 = x420 + x434
    x436 = x171 * x421
    x437 = x422 + x436
    x438 = x171 * x424
    x439 = x427 + x438
    x440 = x171 * x429
    x441 = x431 + x440
    x442 = x357 + 4.0 * x427
    x443 = x0 * (2.0 * x319 + 4.0 * x428 + x442)
    x444 = x171 * x433
    x445 = x443 + x444
    x446 = x303 * x48
    x447 = x0 * (x349 + x417) + x171 * x435
    x448 = x0 * (x339 + x419 + x426 + x434)
    x449 = x171 * x437
    x450 = x448 + x449
    x451 = 2.0 * x436
    x452 = x0 * (x354 + x423 + x430 + x451)
    x453 = x171 * x439
    x454 = x452 + x453
    x455 = x0 * (x358 + x428 + 3.0 * x438 + x442)
    x456 = x171 * x441
    x457 = x455 + x456
    x458 = x0 * (x360 + 5.0 * x431 + x432 + 4.0 * x440) + x171 * x445
    x459 = x303 * x458
    x460 = x3 * x303
    x461 = x0 * (2.0 * x333 + 2.0 * x334 + x425 + 2.0 * x434) + x171 * x447
    x462 = x0 * (x355 + 2.0 * x422 + x447 + x451) + x171 * x450
    x463 = (
        x0 * (2.0 * x340 + 2.0 * x341 + 2.0 * x427 + 2.0 * x438 + 2.0 * x448 + 2.0 * x449)
        + x171 * x454
    )
    x464 = x303 * (
        x0 * (2.0 * x343 + 2.0 * x344 + 2.0 * x431 + 2.0 * x440 + 3.0 * x452 + 3.0 * x453)
        + x171 * x457
    )

    # 900 item(s)
    return numpy.array(
        [
            x83
            * (
                x0
                * (2.0 * x47 + 2.0 * x57 + 2.0 * x63 + 2.0 * x70 + 4.0 * x73 + 4.0 * x76)
                + x48 * x79
            ),
            x85 * x99,
            x101 * x99,
            x105 * x118 * x119,
            x118 * x120 * x85,
            x102 * x118 * x123,
            x119 * x127 * x138,
            x105 * x138 * x139,
            x123 * x138 * x140,
            x102 * x138 * x144,
            x119 * x148 * x153,
            x127 * x139 * x153,
            x105 * x123 * x153,
            x140 * x144 * x153,
            x102 * x153 * x157,
            x158 * x159,
            x119 * x162 * x98,
            x120 * x158 * x98,
            x117 * x119 * x164,
            x117 * x139 * x162,
            x117 * x123 * x160,
            x119 * x137 * x166,
            x137 * x139 * x164,
            x123 * x137 * x162,
            x137 * x144 * x160,
            x119 * x131 * x170,
            x131 * x139 * x166,
            x123 * x131 * x164,
            x131 * x144 * x162,
            x131 * x157 * x160,
            x159 * x171,
            x172 * x85 * x98,
            x102 * x175 * x98,
            x105 * x117 * x173,
            x117 * x140 * x175,
            x102 * x117 * x177,
            x127 * x137 * x173,
            x105 * x137 * x175,
            x137 * x140 * x177,
            x102 * x137 * x179,
            x131 * x148 * x173,
            x127 * x131 * x175,
            x105 * x131 * x177,
            x131 * x140 * x179,
            x102 * x131 * x183,
            x119 * x185 * x78,
            x119 * x188 * x75,
            x139 * x185 * x75,
            x119 * x192 * x96,
            x139 * x188 * x96,
            x123 * x185 * x96,
            x115 * x119 * x195,
            x115 * x139 * x192,
            x115 * x123 * x188,
            x115 * x144 * x185,
            x119 * x130 * x196,
            x130 * x139 * x195,
            x123 * x130 * x192,
            x130 * x144 * x188,
            x130 * x157 * x185,
            x158 * x172 * x78,
            x162 * x173 * x75,
            x160 * x175 * x75,
            x164 * x173 * x96,
            x162 * x175 * x96,
            x160 * x177 * x96,
            x115 * x166 * x173,
            x115 * x164 * x175,
            x115 * x162 * x177,
            x115 * x160 * x179,
            x130 * x170 * x173,
            x130 * x166 * x175,
            x130 * x164 * x177,
            x130 * x162 * x179,
            x130 * x160 * x183,
            x102 * x198 * x78,
            x140 * x198 * x75,
            x102 * x201 * x75,
            x105 * x198 * x96,
            x140 * x201 * x96,
            x102 * x205 * x96,
            x115 * x127 * x198,
            x105 * x115 * x201,
            x115 * x140 * x205,
            x102 * x115 * x208,
            x130 * x148 * x198,
            x127 * x130 * x201,
            x105 * x130 * x205,
            x130 * x140 * x208,
            x102 * x130 * x209,
            x119 * x211 * x69,
            x119 * x212 * x67,
            x139 * x211 * x67,
            x119 * x213 * x32,
            x139 * x212 * x32,
            x123 * x211 * x32,
            x119 * x214 * x30,
            x139 * x213 * x30,
            x123 * x212 * x30,
            x144 * x211 * x30,
            x119 * x215 * x26,
            x139 * x214 * x26,
            x123 * x213 * x26,
            x144 * x212 * x26,
            x157 * x211 * x26,
            x173 * x185 * x69,
            x173 * x188 * x67,
            x175 * x185 * x67,
            x173 * x192 * x32,
            x175 * x188 * x32,
            x177 * x185 * x32,
            x173 * x195 * x30,
            x175 * x192 * x30,
            x177 * x188 * x30,
            x179 * x185 * x30,
            x173 * x196 * x26,
            x175 * x195 * x26,
            x177 * x192 * x26,
            x179 * x188 * x26,
            x183 * x185 * x26,
            x160 * x198 * x69,
            x162 * x198 * x67,
            x160 * x201 * x67,
            x164 * x198 * x32,
            x162 * x201 * x32,
            x160 * x205 * x32,
            x166 * x198 * x30,
            x164 * x201 * x30,
            x162 * x205 * x30,
            x160 * x208 * x30,
            x170 * x198 * x26,
            x166 * x201 * x26,
            x164 * x205 * x26,
            x162 * x208 * x26,
            x160 * x209 * x26,
            x102 * x217 * x69,
            x140 * x217 * x67,
            x102 * x218 * x67,
            x105 * x217 * x32,
            x140 * x218 * x32,
            x102 * x219 * x32,
            x127 * x217 * x30,
            x105 * x218 * x30,
            x140 * x219 * x30,
            x102 * x220 * x30,
            x148 * x217 * x26,
            x127 * x218 * x26,
            x105 * x219 * x26,
            x140 * x220 * x26,
            x102 * x221 * x26,
            x222 * x225,
            x119 * x227 * x232,
            x120 * x222 * x232,
            x119 * x236 * x242,
            x139 * x227 * x242,
            x123 * x233 * x242,
            x119 * x246 * x253,
            x139 * x236 * x253,
            x123 * x227 * x253,
            x144 * x233 * x253,
            x119 * x257 * x259,
            x139 * x246 * x259,
            x123 * x236 * x259,
            x144 * x227 * x259,
            x157 * x233 * x259,
            x119 * x224 * x261,
            x119 * x231 * x263,
            x139 * x231 * x261,
            x119 * x241 * x265,
            x139 * x241 * x263,
            x123 * x241 * x261,
            x119 * x252 * x267,
            x139 * x252 * x265,
            x123 * x252 * x263,
            x144 * x252 * x261,
            x119 * x247 * x271,
            x139 * x247 * x267,
            x123 * x247 * x265,
            x144 * x247 * x263,
            x157 * x247 * x261,
            x172 * x222 * x224,
            x173 * x227 * x231,
            x175 * x231 * x233,
            x173 * x236 * x241,
            x175 * x227 * x241,
            x177 * x233 * x241,
            x173 * x246 * x252,
            x175 * x236 * x252,
            x177 * x227 * x252,
            x179 * x233 * x252,
            x173 * x247 * x257,
            x175 * x246 * x247,
            x177 * x236 * x247,
            x179 * x227 * x247,
            x183 * x233 * x247,
            x119 * x274 * x62,
            x119 * x277 * x90,
            x139 * x274 * x90,
            x113 * x119 * x281,
            x113 * x139 * x277,
            x113 * x123 * x274,
            x119 * x134 * x284,
            x134 * x139 * x281,
            x123 * x134 * x277,
            x134 * x144 * x274,
            x119 * x151 * x287,
            x139 * x151 * x284,
            x123 * x151 * x281,
            x144 * x151 * x277,
            x151 * x157 * x274,
            x173 * x261 * x62,
            x173 * x263 * x90,
            x175 * x261 * x90,
            x113 * x173 * x265,
            x113 * x175 * x263,
            x113 * x177 * x261,
            x134 * x173 * x267,
            x134 * x175 * x265,
            x134 * x177 * x263,
            x134 * x179 * x261,
            x151 * x173 * x271,
            x151 * x175 * x267,
            x151 * x177 * x265,
            x151 * x179 * x263,
            x151 * x183 * x261,
            x198 * x233 * x62,
            x198 * x227 * x90,
            x201 * x233 * x90,
            x113 * x198 * x236,
            x113 * x201 * x227,
            x113 * x205 * x233,
            x134 * x198 * x246,
            x134 * x201 * x236,
            x134 * x205 * x227,
            x134 * x208 * x233,
            x151 * x198 * x257,
            x151 * x201 * x246,
            x151 * x205 * x236,
            x151 * x208 * x227,
            x151 * x209 * x233,
            x119 * x289 * x60,
            x119 * x22 * x291,
            x139 * x22 * x289,
            x119 * x20 * x295,
            x139 * x20 * x291,
            x123 * x20 * x289,
            x119 * x18 * x298,
            x139 * x18 * x295,
            x123 * x18 * x291,
            x144 * x18 * x289,
            x11 * x301,
            x101 * x298 * x302,
            x123 * x16 * x295,
            x144 * x16 * x291,
            x157 * x16 * x289,
            x173 * x274 * x60,
            x173 * x22 * x277,
            x175 * x22 * x274,
            x173 * x20 * x281,
            x175 * x20 * x277,
            x177 * x20 * x274,
            x173 * x18 * x284,
            x175 * x18 * x281,
            x177 * x18 * x277,
            x179 * x18 * x274,
            x171 * x287 * x302,
            x16 * x175 * x284,
            x16 * x177 * x281,
            x16 * x179 * x277,
            x16 * x183 * x274,
            x198 * x261 * x60,
            x198 * x22 * x263,
            x201 * x22 * x261,
            x198 * x20 * x265,
            x20 * x201 * x263,
            x20 * x205 * x261,
            x18 * x198 * x267,
            x18 * x201 * x265,
            x18 * x205 * x263,
            x18 * x208 * x261,
            x16 * x198 * x271,
            x16 * x201 * x267,
            x16 * x205 * x265,
            x16 * x208 * x263,
            x16 * x209 * x261,
            x217 * x233 * x60,
            x217 * x22 * x227,
            x218 * x22 * x233,
            x20 * x217 * x236,
            x20 * x218 * x227,
            x20 * x219 * x233,
            x18 * x217 * x246,
            x18 * x218 * x236,
            x18 * x219 * x227,
            x18 * x220 * x233,
            x16 * x217 * x257,
            x16 * x218 * x246,
            x16 * x219 * x236,
            x16 * x220 * x227,
            x221 * x222 * x304,
            x225 * x305,
            x232 * x306 * x85,
            x102 * x232 * x308,
            x105 * x242 * x309,
            x140 * x242 * x308,
            x102 * x242 * x312,
            x127 * x253 * x309,
            x105 * x253 * x308,
            x140 * x253 * x312,
            x102 * x253 * x316,
            x148 * x259 * x309,
            x127 * x259 * x308,
            x105 * x259 * x312,
            x140 * x259 * x316,
            x102 * x259 * x320,
            x158 * x224 * x306,
            x162 * x231 * x309,
            x160 * x231 * x308,
            x164 * x241 * x309,
            x162 * x241 * x308,
            x160 * x241 * x312,
            x166 * x252 * x309,
            x164 * x252 * x308,
            x162 * x252 * x312,
            x160 * x252 * x316,
            x170 * x247 * x309,
            x166 * x247 * x308,
            x164 * x247 * x312,
            x162 * x247 * x316,
            x160 * x247 * x320,
            x102 * x224 * x322,
            x140 * x231 * x322,
            x102 * x231 * x324,
            x105 * x241 * x322,
            x140 * x241 * x324,
            x102 * x241 * x326,
            x127 * x252 * x322,
            x105 * x252 * x324,
            x140 * x252 * x326,
            x102 * x252 * x328,
            x148 * x247 * x322,
            x127 * x247 * x324,
            x105 * x247 * x326,
            x140 * x247 * x328,
            x102 * x247 * x332,
            x185 * x309 * x62,
            x188 * x309 * x90,
            x185 * x308 * x90,
            x113 * x192 * x309,
            x113 * x188 * x308,
            x113 * x185 * x312,
            x134 * x195 * x309,
            x134 * x192 * x308,
            x134 * x188 * x312,
            x134 * x185 * x316,
            x151 * x196 * x309,
            x151 * x195 * x308,
            x151 * x192 * x312,
            x151 * x188 * x316,
            x151 * x185 * x320,
            x160 * x322 * x62,
            x162 * x322 * x90,
            x160 * x324 * x90,
            x113 * x164 * x322,
            x113 * x162 * x324,
            x113 * x160 * x326,
            x134 * x166 * x322,
            x134 * x164 * x324,
            x134 * x162 * x326,
            x134 * x160 * x328,
            x151 * x170 * x322,
            x151 * x166 * x324,
            x151 * x164 * x326,
            x151 * x162 * x328,
            x151 * x160 * x332,
            x102 * x335 * x62,
            x140 * x335 * x90,
            x102 * x338 * x90,
            x105 * x113 * x335,
            x113 * x140 * x338,
            x102 * x113 * x342,
            x127 * x134 * x335,
            x105 * x134 * x338,
            x134 * x140 * x342,
            x102 * x134 * x345,
            x148 * x151 * x335,
            x127 * x151 * x338,
            x105 * x151 * x342,
            x140 * x151 * x345,
            x102 * x151 * x348,
            x211 * x309 * x60,
            x212 * x22 * x309,
            x211 * x22 * x308,
            x20 * x213 * x309,
            x20 * x212 * x308,
            x20 * x211 * x312,
            x18 * x214 * x309,
            x18 * x213 * x308,
            x18 * x212 * x312,
            x18 * x211 * x316,
            x215 * x302 * x305,
            x16 * x214 * x308,
            x16 * x213 * x312,
            x16 * x212 * x316,
            x16 * x211 * x320,
            x185 * x322 * x60,
            x188 * x22 * x322,
            x185 * x22 * x324,
            x192 * x20 * x322,
            x188 * x20 * x324,
            x185 * x20 * x326,
            x18 * x195 * x322,
            x18 * x192 * x324,
            x18 * x188 * x326,
            x18 * x185 * x328,
            x16 * x196 * x322,
            x16 * x195 * x324,
            x16 * x192 * x326,
            x16 * x188 * x328,
            x16 * x185 * x332,
            x160 * x335 * x60,
            x162 * x22 * x335,
            x160 * x22 * x338,
            x164 * x20 * x335,
            x162 * x20 * x338,
            x160 * x20 * x342,
            x166 * x18 * x335,
            x164 * x18 * x338,
            x162 * x18 * x342,
            x160 * x18 * x345,
            x16 * x170 * x335,
            x16 * x166 * x338,
            x16 * x164 * x342,
            x16 * x162 * x345,
            x158 * x304 * x348,
            x102 * x350 * x60,
            x140 * x22 * x350,
            x102 * x22 * x352,
            x105 * x20 * x350,
            x140 * x20 * x352,
            x102 * x20 * x356,
            x127 * x18 * x350,
            x105 * x18 * x352,
            x140 * x18 * x356,
            x102 * x18 * x359,
            x148 * x16 * x350,
            x127 * x16 * x352,
            x105 * x16 * x356,
            x304 * x359 * x85,
            x11 * x361,
            x119 * x363 * x364,
            x119 * x367 * x368,
            x139 * x363 * x368,
            x119 * x371 * x372,
            x139 * x367 * x372,
            x123 * x363 * x372,
            x119 * x377 * x378,
            x139 * x371 * x378,
            x123 * x367 * x378,
            x144 * x363 * x378,
            x119 * x382 * x384,
            x139 * x377 * x384,
            x123 * x371 * x384,
            x144 * x367 * x384,
            x157 * x363 * x384,
            x119 * x223 * x386,
            x119 * x230 * x388,
            x139 * x230 * x386,
            x119 * x240 * x390,
            x139 * x240 * x388,
            x123 * x240 * x386,
            x119 * x251 * x392,
            x139 * x251 * x390,
            x123 * x251 * x388,
            x144 * x251 * x386,
            x119 * x383 * x396,
            x139 * x383 * x392,
            x123 * x383 * x390,
            x144 * x383 * x388,
            x157 * x383 * x386,
            x173 * x223 * x363,
            x173 * x230 * x367,
            x175 * x230 * x363,
            x173 * x240 * x371,
            x175 * x240 * x367,
            x177 * x240 * x363,
            x173 * x251 * x377,
            x175 * x251 * x371,
            x177 * x251 * x367,
            x179 * x251 * x363,
            x173 * x382 * x383,
            x175 * x377 * x383,
            x177 * x371 * x383,
            x179 * x367 * x383,
            x183 * x363 * x383,
            x119 * x397 * x56,
            x119 * x400 * x88,
            x139 * x397 * x88,
            x109 * x119 * x404,
            x109 * x139 * x400,
            x109 * x123 * x397,
            x119 * x249 * x407,
            x139 * x249 * x404,
            x123 * x249 * x400,
            x144 * x249 * x397,
            x409 * x48,
            x101 * x407 * x410,
            x123 * x149 * x404,
            x144 * x149 * x400,
            x149 * x157 * x397,
            x173 * x386 * x56,
            x173 * x388 * x88,
            x175 * x386 * x88,
            x109 * x173 * x390,
            x109 * x175 * x388,
            x109 * x177 * x386,
            x173 * x249 * x392,
            x175 * x249 * x390,
            x177 * x249 * x388,
            x179 * x249 * x386,
            x171 * x396 * x410,
            x149 * x175 * x392,
            x149 * x177 * x390,
            x149 * x179 * x388,
            x149 * x183 * x386,
            x198 * x363 * x56,
            x198 * x367 * x88,
            x201 * x363 * x88,
            x109 * x198 * x371,
            x109 * x201 * x367,
            x109 * x205 * x363,
            x198 * x249 * x377,
            x201 * x249 * x371,
            x205 * x249 * x367,
            x208 * x249 * x363,
            x149 * x198 * x382,
            x149 * x201 * x377,
            x149 * x205 * x371,
            x149 * x208 * x367,
            x149 * x209 * x363,
            x119 * x411 * x54,
            x119 * x38 * x412,
            x139 * x38 * x411,
            x119 * x35 * x413,
            x139 * x35 * x412,
            x123 * x35 * x411,
            x3 * x414,
            x101 * x413 * x415,
            x12 * x123 * x412,
            x12 * x144 * x411,
            x300
            * (
                x0
                * (
                    2.0 * x285
                    + 2.0 * x286
                    + 2.0 * x394
                    + 2.0 * x395
                    + 4.0 * x405
                    + 4.0 * x406
                )
                + x158 * x408
            ),
            x101 * x414,
            x123 * x413 * x7,
            x144 * x412 * x7,
            x157 * x411 * x7,
            x173 * x397 * x54,
            x173 * x38 * x400,
            x175 * x38 * x397,
            x173 * x35 * x404,
            x175 * x35 * x400,
            x177 * x35 * x397,
            x171 * x407 * x415,
            x12 * x175 * x404,
            x12 * x177 * x400,
            x12 * x179 * x397,
            x171 * x409,
            x175 * x407 * x7,
            x177 * x404 * x7,
            x179 * x400 * x7,
            x183 * x397 * x7,
            x198 * x386 * x54,
            x198 * x38 * x388,
            x201 * x38 * x386,
            x198 * x35 * x390,
            x201 * x35 * x388,
            x205 * x35 * x386,
            x12 * x198 * x392,
            x12 * x201 * x390,
            x12 * x205 * x388,
            x12 * x208 * x386,
            x198 * x396 * x7,
            x201 * x392 * x7,
            x205 * x390 * x7,
            x208 * x388 * x7,
            x209 * x386 * x7,
            x217 * x363 * x54,
            x217 * x367 * x38,
            x218 * x363 * x38,
            x217 * x35 * x371,
            x218 * x35 * x367,
            x219 * x35 * x363,
            x12 * x217 * x377,
            x12 * x218 * x371,
            x12 * x219 * x367,
            x12 * x220 * x363,
            x217 * x382 * x7,
            x218 * x377 * x7,
            x219 * x371 * x7,
            x220 * x367 * x7,
            x221 * x363 * x7,
            x222 * x306 * x364,
            x227 * x309 * x368,
            x233 * x308 * x368,
            x236 * x309 * x372,
            x227 * x308 * x372,
            x233 * x312 * x372,
            x246 * x309 * x378,
            x236 * x308 * x378,
            x227 * x312 * x378,
            x233 * x316 * x378,
            x257 * x309 * x384,
            x246 * x308 * x384,
            x236 * x312 * x384,
            x227 * x316 * x384,
            x233 * x320 * x384,
            x223 * x261 * x309,
            x230 * x263 * x309,
            x230 * x261 * x308,
            x240 * x265 * x309,
            x240 * x263 * x308,
            x240 * x261 * x312,
            x251 * x267 * x309,
            x251 * x265 * x308,
            x251 * x263 * x312,
            x251 * x261 * x316,
            x271 * x309 * x383,
            x267 * x308 * x383,
            x265 * x312 * x383,
            x263 * x316 * x383,
            x261 * x320 * x383,
            x223 * x233 * x322,
            x227 * x230 * x322,
            x230 * x233 * x324,
            x236 * x240 * x322,
            x227 * x240 * x324,
            x233 * x240 * x326,
            x246 * x251 * x322,
            x236 * x251 * x324,
            x227 * x251 * x326,
            x233 * x251 * x328,
            x257 * x322 * x383,
            x246 * x324 * x383,
            x236 * x326 * x383,
            x227 * x328 * x383,
            x233 * x332 * x383,
            x274 * x309 * x56,
            x277 * x309 * x88,
            x274 * x308 * x88,
            x109 * x281 * x309,
            x109 * x277 * x308,
            x109 * x274 * x312,
            x249 * x284 * x309,
            x249 * x281 * x308,
            x249 * x277 * x312,
            x249 * x274 * x316,
            x287 * x305 * x410,
            x149 * x284 * x308,
            x149 * x281 * x312,
            x149 * x277 * x316,
            x149 * x274 * x320,
            x261 * x322 * x56,
            x263 * x322 * x88,
            x261 * x324 * x88,
            x109 * x265 * x322,
            x109 * x263 * x324,
            x109 * x261 * x326,
            x249 * x267 * x322,
            x249 * x265 * x324,
            x249 * x263 * x326,
            x249 * x261 * x328,
            x149 * x271 * x322,
            x149 * x267 * x324,
            x149 * x265 * x326,
            x149 * x263 * x328,
            x149 * x261 * x332,
            x233 * x335 * x56,
            x227 * x335 * x88,
            x233 * x338 * x88,
            x109 * x236 * x335,
            x109 * x227 * x338,
            x109 * x233 * x342,
            x246 * x249 * x335,
            x236 * x249 * x338,
            x227 * x249 * x342,
            x233 * x249 * x345,
            x149 * x257 * x335,
            x149 * x246 * x338,
            x149 * x236 * x342,
            x149 * x227 * x345,
            x348 * x416 * x48,
            x289 * x309 * x54,
            x291 * x309 * x38,
            x289 * x308 * x38,
            x295 * x309 * x35,
            x291 * x308 * x35,
            x289 * x312 * x35,
            x298 * x305 * x415,
            x12 * x295 * x308,
            x12 * x291 * x312,
            x12 * x289 * x316,
            x301 * x305,
            x298 * x308 * x7,
            x295 * x312 * x7,
            x291 * x316 * x7,
            x289 * x320 * x7,
            x274 * x322 * x54,
            x277 * x322 * x38,
            x274 * x324 * x38,
            x281 * x322 * x35,
            x277 * x324 * x35,
            x274 * x326 * x35,
            x12 * x284 * x322,
            x12 * x281 * x324,
            x12 * x277 * x326,
            x12 * x274 * x328,
            x287 * x322 * x7,
            x284 * x324 * x7,
            x281 * x326 * x7,
            x277 * x328 * x7,
            x274 * x332 * x7,
            x261 * x335 * x54,
            x263 * x335 * x38,
            x261 * x338 * x38,
            x265 * x335 * x35,
            x263 * x338 * x35,
            x261 * x342 * x35,
            x12 * x267 * x335,
            x12 * x265 * x338,
            x12 * x263 * x342,
            x12 * x261 * x345,
            x271 * x335 * x7,
            x267 * x338 * x7,
            x265 * x342 * x7,
            x263 * x345 * x7,
            x261 * x348 * x7,
            x233 * x350 * x54,
            x227 * x350 * x38,
            x233 * x352 * x38,
            x236 * x35 * x350,
            x227 * x35 * x352,
            x233 * x35 * x356,
            x12 * x246 * x350,
            x12 * x236 * x352,
            x12 * x227 * x356,
            x3 * x359 * x416,
            x257 * x350 * x7,
            x246 * x352 * x7,
            x236 * x356 * x7,
            x227 * x359 * x7,
            x222 * x361,
            x102 * x364 * x418,
            x140 * x368 * x418,
            x102 * x368 * x421,
            x105 * x372 * x418,
            x140 * x372 * x421,
            x102 * x372 * x424,
            x127 * x378 * x418,
            x105 * x378 * x421,
            x140 * x378 * x424,
            x102 * x378 * x429,
            x148 * x384 * x418,
            x127 * x384 * x421,
            x105 * x384 * x424,
            x140 * x384 * x429,
            x102 * x384 * x433,
            x160 * x223 * x418,
            x162 * x230 * x418,
            x160 * x230 * x421,
            x164 * x240 * x418,
            x162 * x240 * x421,
            x160 * x240 * x424,
            x166 * x251 * x418,
            x164 * x251 * x421,
            x162 * x251 * x424,
            x160 * x251 * x429,
            x170 * x383 * x418,
            x166 * x383 * x421,
            x164 * x383 * x424,
            x162 * x383 * x429,
            x160 * x383 * x433,
            x102 * x223 * x435,
            x140 * x230 * x435,
            x102 * x230 * x437,
            x105 * x240 * x435,
            x140 * x240 * x437,
            x102 * x240 * x439,
            x127 * x251 * x435,
            x105 * x251 * x437,
            x140 * x251 * x439,
            x102 * x251 * x441,
            x148 * x383 * x435,
            x127 * x383 * x437,
            x105 * x383 * x439,
            x140 * x383 * x441,
            x102 * x383 * x445,
            x185 * x418 * x56,
            x188 * x418 * x88,
            x185 * x421 * x88,
            x109 * x192 * x418,
            x109 * x188 * x421,
            x109 * x185 * x424,
            x195 * x249 * x418,
            x192 * x249 * x421,
            x188 * x249 * x424,
            x185 * x249 * x429,
            x149 * x196 * x418,
            x149 * x195 * x421,
            x149 * x192 * x424,
            x149 * x188 * x429,
            x149 * x185 * x433,
            x160 * x435 * x56,
            x162 * x435 * x88,
            x160 * x437 * x88,
            x109 * x164 * x435,
            x109 * x162 * x437,
            x109 * x160 * x439,
            x166 * x249 * x435,
            x164 * x249 * x437,
            x162 * x249 * x439,
            x160 * x249 * x441,
            x149 * x170 * x435,
            x149 * x166 * x437,
            x149 * x164 * x439,
            x149 * x162 * x441,
            x158 * x445 * x446,
            x102 * x447 * x56,
            x140 * x447 * x88,
            x102 * x450 * x88,
            x105 * x109 * x447,
            x109 * x140 * x450,
            x102 * x109 * x454,
            x127 * x249 * x447,
            x105 * x249 * x450,
            x140 * x249 * x454,
            x102 * x249 * x457,
            x148 * x149 * x447,
            x127 * x149 * x450,
            x105 * x149 * x454,
            x446 * x457 * x85,
            x459 * x48,
            x211 * x418 * x54,
            x212 * x38 * x418,
            x211 * x38 * x421,
            x213 * x35 * x418,
            x212 * x35 * x421,
            x211 * x35 * x424,
            x12 * x214 * x418,
            x12 * x213 * x421,
            x12 * x212 * x424,
            x12 * x211 * x429,
            x215 * x418 * x7,
            x214 * x421 * x7,
            x213 * x424 * x7,
            x212 * x429 * x7,
            x211 * x433 * x7,
            x185 * x435 * x54,
            x188 * x38 * x435,
            x185 * x38 * x437,
            x192 * x35 * x435,
            x188 * x35 * x437,
            x185 * x35 * x439,
            x12 * x195 * x435,
            x12 * x192 * x437,
            x12 * x188 * x439,
            x12 * x185 * x441,
            x196 * x435 * x7,
            x195 * x437 * x7,
            x192 * x439 * x7,
            x188 * x441 * x7,
            x185 * x445 * x7,
            x160 * x447 * x54,
            x162 * x38 * x447,
            x160 * x38 * x450,
            x164 * x35 * x447,
            x162 * x35 * x450,
            x160 * x35 * x454,
            x12 * x166 * x447,
            x12 * x164 * x450,
            x12 * x162 * x454,
            x158 * x457 * x460,
            x170 * x447 * x7,
            x166 * x450 * x7,
            x164 * x454 * x7,
            x162 * x457 * x7,
            x158 * x459,
            x102 * x461 * x54,
            x140 * x38 * x461,
            x102 * x38 * x462,
            x105 * x35 * x461,
            x140 * x35 * x462,
            x102 * x35 * x463,
            x12 * x127 * x461,
            x105 * x12 * x462,
            x460 * x463 * x85,
            x3 * x464,
            x148 * x461 * x7,
            x127 * x462 * x7,
            x105 * x463 * x7,
            x464 * x85,
            x303
            * (
                x0
                * (
                    2.0 * x346
                    + 2.0 * x347
                    + 2.0 * x443
                    + 2.0 * x444
                    + 4.0 * x455
                    + 4.0 * x456
                )
                + x171 * x458
            ),
        ]
    )


def quadrupole3d_40(a, A, b, B, C):
    """Cartesian 3D (gs) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3**2 * x7
    x9 = x0 * x7
    x10 = 3.0 * x9
    x11 = -x2 - C[0]
    x12 = x3 * x7
    x13 = x11 * x12
    x14 = x10 + 2.0 * x13
    x15 = x0 * (x14 + x8)
    x16 = x11 * x7
    x17 = x0 * (x12 + x16)
    x18 = x13 + x9
    x19 = x18 * x3
    x20 = x17 + x19
    x21 = x20 * x3
    x22 = x11**2 * x7
    x23 = x0 * (x14 + x22)
    x24 = x22 + x9
    x25 = x24 * x3
    x26 = x0 * x16
    x27 = x25 + 2.0 * x26
    x28 = x27 * x3
    x29 = x23 + x28
    x30 = x0 * (2.0 * x17 + 2.0 * x19 + 2.0 * x25 + 4.0 * x26) + x29 * x3
    x31 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x32 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x33 = 3.14159265358979 * x1 * x32
    x34 = x31 * x33
    x35 = -x1 * (a * A[1] + b * B[1])
    x36 = -x35 - A[1]
    x37 = x30 * x34
    x38 = -x1 * (a * A[2] + b * B[2])
    x39 = -x38 - A[2]
    x40 = x31 * x6
    x41 = x36**2 * x40
    x42 = x0 * x40
    x43 = x41 + x42
    x44 = x32 * x6
    x45 = x34 * x39
    x46 = x39**2 * x44
    x47 = x0 * x44
    x48 = x46 + x47
    x49 = 2.0 * x42
    x50 = x36 * x43 + x36 * x49
    x51 = x39 * x44
    x52 = x36 * x40
    x53 = 2.0 * x47
    x54 = x39 * x48 + x39 * x53
    x55 = 3.0 * x42
    x56 = x0 * (3.0 * x41 + x55) + x36 * x50
    x57 = 3.0 * x47
    x58 = x0 * (3.0 * x46 + x57) + x39 * x54
    x59 = -x35 - C[1]
    x60 = x8 + x9
    x61 = 2.0 * x0 * x12 + x3 * x60
    x62 = x15 + x21
    x63 = x34 * (x0 * (3.0 * x17 + 3.0 * x19 + x61) + x3 * x62)
    x64 = x52 * x59
    x65 = x42 + x64
    x66 = x40 * x59
    x67 = x0 * (x52 + x66)
    x68 = x36 * x65
    x69 = x67 + x68
    x70 = x55 + 2.0 * x64
    x71 = x0 * (x41 + x70)
    x72 = x36 * x69
    x73 = x71 + x72
    x74 = x33 * x5
    x75 = x74 * (x0 * (x50 + 3.0 * x67 + 3.0 * x68) + x36 * x73)
    x76 = x11 * x74
    x77 = 3.14159265358979 * x1 * x31 * x5
    x78 = x11 * x77
    x79 = -x38 - C[2]
    x80 = x34 * x79
    x81 = x51 * x79
    x82 = x47 + x81
    x83 = x44 * x79
    x84 = x0 * (x51 + x83)
    x85 = x39 * x82
    x86 = x84 + x85
    x87 = x57 + 2.0 * x81
    x88 = x0 * (x46 + x87)
    x89 = x39 * x86
    x90 = x88 + x89
    x91 = x77 * (x0 * (x54 + 3.0 * x84 + 3.0 * x85) + x39 * x90)
    x92 = x40 * x59**2
    x93 = x42 + x92
    x94 = x0 * (x10 + 3.0 * x8) + x3 * x61
    x95 = x36 * x93
    x96 = x49 * x59 + x95
    x97 = x0 * (x70 + x92)
    x98 = x36 * x96
    x99 = x97 + x98
    x100 = x0 * (4.0 * x42 * x59 + 2.0 * x67 + 2.0 * x68 + 2.0 * x95) + x36 * x99
    x101 = x100 * x74
    x102 = x3 * x74
    x103 = x3 * x77
    x104 = x44 * x79**2
    x105 = x104 + x47
    x106 = x105 * x39
    x107 = x106 + x53 * x79
    x108 = x0 * (x104 + x87)
    x109 = x107 * x39
    x110 = x108 + x109
    x111 = x0 * (2.0 * x106 + 4.0 * x47 * x79 + 2.0 * x84 + 2.0 * x85) + x110 * x39
    x112 = x111 * x77

    # 90 item(s)
    return numpy.array(
        [
            x34 * (x0 * (2.0 * x15 + 2.0 * x21 + 3.0 * x23 + 3.0 * x28) + x3 * x30),
            x36 * x37,
            x37 * x39,
            x29 * x43 * x44,
            x29 * x36 * x45,
            x29 * x40 * x48,
            x27 * x44 * x50,
            x27 * x43 * x51,
            x27 * x48 * x52,
            x27 * x40 * x54,
            x24 * x44 * x56,
            x24 * x50 * x51,
            x24 * x43 * x48,
            x24 * x52 * x54,
            x24 * x40 * x58,
            x59 * x63,
            x44 * x62 * x65,
            x45 * x59 * x62,
            x20 * x44 * x69,
            x20 * x51 * x65,
            x20 * x48 * x66,
            x18 * x44 * x73,
            x18 * x51 * x69,
            x18 * x48 * x65,
            x18 * x54 * x66,
            x11 * x75,
            x39 * x73 * x76,
            x16 * x48 * x69,
            x16 * x54 * x65,
            x58 * x59 * x78,
            x63 * x79,
            x36 * x62 * x80,
            x40 * x62 * x82,
            x20 * x43 * x83,
            x20 * x52 * x82,
            x20 * x40 * x86,
            x18 * x50 * x83,
            x18 * x43 * x82,
            x18 * x52 * x86,
            x18 * x40 * x90,
            x56 * x76 * x79,
            x16 * x50 * x82,
            x16 * x43 * x86,
            x36 * x78 * x90,
            x11 * x91,
            x44 * x93 * x94,
            x44 * x61 * x96,
            x51 * x61 * x93,
            x44 * x60 * x99,
            x51 * x60 * x96,
            x48 * x60 * x93,
            x101 * x3,
            x102 * x39 * x99,
            x12 * x48 * x96,
            x12 * x54 * x93,
            x74 * (x0 * (2.0 * x71 + 2.0 * x72 + 3.0 * x97 + 3.0 * x98) + x100 * x36),
            x101 * x39,
            x48 * x7 * x99,
            x54 * x7 * x96,
            x58 * x7 * x93,
            x59 * x80 * x94,
            x61 * x65 * x83,
            x61 * x66 * x82,
            x60 * x69 * x83,
            x60 * x65 * x82,
            x60 * x66 * x86,
            x102 * x73 * x79,
            x12 * x69 * x82,
            x12 * x65 * x86,
            x103 * x59 * x90,
            x75 * x79,
            x7 * x73 * x82,
            x69 * x7 * x86,
            x65 * x7 * x90,
            x59 * x91,
            x105 * x40 * x94,
            x105 * x52 * x61,
            x107 * x40 * x61,
            x105 * x43 * x60,
            x107 * x52 * x60,
            x110 * x40 * x60,
            x105 * x12 * x50,
            x107 * x12 * x43,
            x103 * x110 * x36,
            x112 * x3,
            x105 * x56 * x7,
            x107 * x50 * x7,
            x110 * x43 * x7,
            x112 * x36,
            x77 * (x0 * (3.0 * x108 + 3.0 * x109 + 2.0 * x88 + 2.0 * x89) + x111 * x39),
        ]
    )


def quadrupole3d_41(a, A, b, B, C):
    """Cartesian 3D (gp) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = 1.77245385090552 * numpy.sqrt(x1)
    x3 = -x1 * (a * A[0] + b * B[0])
    x4 = -x3 - A[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = x4 * x6
    x8 = x2 * x7
    x9 = -x3 - C[0]
    x10 = x2 * x6
    x11 = x10 * x9
    x12 = x0 * (x11 + x8)
    x13 = x0 * x10
    x14 = x8 * x9
    x15 = x13 + x14
    x16 = x15 * x4
    x17 = x12 + x16
    x18 = -x3 - B[0]
    x19 = x10 * x18
    x20 = x0 * (x19 + x8)
    x21 = x18 * x8
    x22 = x13 + x21
    x23 = x22 * x4
    x24 = x20 + x23
    x25 = x0 * (x11 + x19)
    x26 = x11 * x18
    x27 = x13 + x26
    x28 = x27 * x4
    x29 = 2.0 * x25 + 2.0 * x28
    x30 = x0 * (x17 + x24 + x29)
    x31 = 3.0 * x13
    x32 = x0 * (x14 + x21 + x26 + x31)
    x33 = x25 + x28
    x34 = x33 * x4
    x35 = x32 + x34
    x36 = x35 * x4
    x37 = x10 * x9**2
    x38 = x13 + x37
    x39 = x38 * x4
    x40 = x18 * x38
    x41 = x0 * x11
    x42 = 4.0 * x41
    x43 = x0 * (x29 + x39 + x40 + x42)
    x44 = x31 + x37
    x45 = x0 * (2.0 * x26 + x44)
    x46 = 2.0 * x41
    x47 = x40 + x46
    x48 = x4 * x47
    x49 = x45 + x48
    x50 = x4 * x49
    x51 = 2.0 * x14
    x52 = x0 * (x44 + x51)
    x53 = x39 + x46
    x54 = x4 * x53
    x55 = x52 + x54
    x56 = x0 * (2.0 * x12 + 2.0 * x16 + 2.0 * x39 + x42) + x4 * x55
    x57 = x43 + x50
    x58 = x0 * (2.0 * x32 + 2.0 * x34 + 2.0 * x45 + 2.0 * x48 + x55) + x4 * x57
    x59 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x60 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x61 = 3.14159265358979 * x1 * x60
    x62 = x59 * x61
    x63 = -x1 * (a * A[1] + b * B[1])
    x64 = -x63 - B[1]
    x65 = x10 * x4**2
    x66 = x31 + x65
    x67 = x0 * (x51 + x66)
    x68 = x17 * x4
    x69 = x62 * (x0 * (3.0 * x52 + 3.0 * x54 + 2.0 * x67 + 2.0 * x68) + x4 * x56)
    x70 = -x1 * (a * A[2] + b * B[2])
    x71 = -x70 - B[2]
    x72 = -x63 - A[1]
    x73 = x58 * x62
    x74 = x0 * x2
    x75 = x59 * x74
    x76 = x2 * x59
    x77 = x72 * x76
    x78 = x64 * x77
    x79 = x75 + x78
    x80 = x2 * x60
    x81 = x56 * x62
    x82 = -x70 - A[2]
    x83 = x60 * x74
    x84 = x80 * x82
    x85 = x71 * x84
    x86 = x83 + x85
    x87 = x72**2 * x76
    x88 = x75 + x87
    x89 = x64 * x76
    x90 = x0 * (x77 + x89)
    x91 = x72 * x79
    x92 = x90 + x91
    x93 = x71 * x80
    x94 = x62 * x82
    x95 = x80 * x82**2
    x96 = x83 + x95
    x97 = x0 * (x84 + x93)
    x98 = x82 * x86
    x99 = x97 + x98
    x100 = 2.0 * x75
    x101 = x100 * x72 + x72 * x88
    x102 = 3.0 * x75
    x103 = x102 + x87
    x104 = x0 * (x103 + 2.0 * x78) + x72 * x92
    x105 = 2.0 * x83
    x106 = x105 * x82 + x82 * x96
    x107 = 3.0 * x83
    x108 = x107 + x95
    x109 = x0 * (x108 + 2.0 * x85) + x82 * x99
    x110 = x0 * (x102 + 3.0 * x87) + x101 * x72
    x111 = x0 * (x101 + 3.0 * x90 + 3.0 * x91) + x104 * x72
    x112 = x0 * (x107 + 3.0 * x95) + x106 * x82
    x113 = x0 * (x106 + 3.0 * x97 + 3.0 * x98) + x109 * x82
    x114 = -x63 - C[1]
    x115 = x67 + x68
    x116 = x0 * (2.0 * x21 + x66) + x24 * x4
    x117 = x30 + x36
    x118 = x62 * (x0 * (x115 + x116 + 3.0 * x32 + 3.0 * x34) + x117 * x4)
    x119 = x114 * x89
    x120 = x119 + x75
    x121 = x13 + x65
    x122 = 2.0 * x0 * x8 + x121 * x4
    x123 = x0 * (3.0 * x12 + x122 + 3.0 * x16) + x115 * x4
    x124 = x123 * x62
    x125 = x114 * x77
    x126 = x125 + x75
    x127 = x114 * x76
    x128 = x0 * (x127 + x89)
    x129 = x120 * x72
    x130 = x128 + x129
    x131 = x0 * (x127 + x77)
    x132 = x126 * x72
    x133 = x131 + x132
    x134 = x0 * (x102 + x119 + x125 + x78)
    x135 = x130 * x72
    x136 = x134 + x135
    x137 = 2.0 * x125
    x138 = x0 * (x103 + x137)
    x139 = x133 * x72
    x140 = x138 + x139
    x141 = 2.0 * x128 + 2.0 * x129
    x142 = x0 * (x133 + x141 + x92)
    x143 = x136 * x72
    x144 = x142 + x143
    x145 = x0 * (x101 + 3.0 * x131 + 3.0 * x132) + x140 * x72
    x146 = x6 * x61
    x147 = x146 * (x0 * (x104 + 3.0 * x134 + 3.0 * x135 + x140) + x144 * x72)
    x148 = x146 * x9
    x149 = x146 * x82
    x150 = 3.14159265358979 * x1 * x59
    x151 = x150 * x6
    x152 = x151 * x9
    x153 = -x70 - C[2]
    x154 = x153 * x93
    x155 = x154 + x83
    x156 = x153 * x62
    x157 = x153 * x80
    x158 = x153 * x84
    x159 = x158 + x83
    x160 = x0 * (x157 + x93)
    x161 = x155 * x82
    x162 = x160 + x161
    x163 = x0 * (x157 + x84)
    x164 = x159 * x82
    x165 = x163 + x164
    x166 = x0 * (x107 + x154 + x158 + x85)
    x167 = x162 * x82
    x168 = x166 + x167
    x169 = 2.0 * x158
    x170 = x0 * (x108 + x169)
    x171 = x165 * x82
    x172 = x170 + x171
    x173 = 2.0 * x160 + 2.0 * x161
    x174 = x0 * (x165 + x173 + x99)
    x175 = x168 * x82
    x176 = x174 + x175
    x177 = x151 * x72
    x178 = x0 * (x106 + 3.0 * x163 + 3.0 * x164) + x172 * x82
    x179 = x151 * (x0 * (x109 + 3.0 * x166 + 3.0 * x167 + x172) + x176 * x82)
    x180 = x114**2 * x76
    x181 = x180 + x75
    x182 = x0 * (x122 + 3.0 * x20 + 3.0 * x23) + x116 * x4
    x183 = x181 * x64
    x184 = x100 * x114
    x185 = x183 + x184
    x186 = x0 * (x31 + 3.0 * x65) + x122 * x4
    x187 = x181 * x72
    x188 = x184 + x187
    x189 = x102 + x180
    x190 = x0 * (2.0 * x119 + x189)
    x191 = x185 * x72
    x192 = x190 + x191
    x193 = x0 * (x137 + x189)
    x194 = x188 * x72
    x195 = x193 + x194
    x196 = 4.0 * x114 * x75
    x197 = x0 * (x141 + x183 + x187 + x196)
    x198 = x192 * x72
    x199 = x197 + x198
    x200 = x0 * (2.0 * x131 + 2.0 * x132 + 2.0 * x187 + x196) + x195 * x72
    x201 = x0 * (2.0 * x134 + 2.0 * x135 + 2.0 * x190 + 2.0 * x191 + x195) + x199 * x72
    x202 = x61 * x7
    x203 = x146 * (x0 * (2.0 * x138 + 2.0 * x139 + 3.0 * x193 + 3.0 * x194) + x200 * x72)
    x204 = x150 * x7
    x205 = x153**2 * x80
    x206 = x205 + x83
    x207 = x206 * x71
    x208 = x105 * x153
    x209 = x207 + x208
    x210 = x206 * x82
    x211 = x208 + x210
    x212 = x107 + x205
    x213 = x0 * (2.0 * x154 + x212)
    x214 = x209 * x82
    x215 = x213 + x214
    x216 = x0 * (x169 + x212)
    x217 = x211 * x82
    x218 = x216 + x217
    x219 = 4.0 * x153 * x83
    x220 = x0 * (x173 + x207 + x210 + x219)
    x221 = x215 * x82
    x222 = x220 + x221
    x223 = x0 * (2.0 * x163 + 2.0 * x164 + 2.0 * x210 + x219) + x218 * x82
    x224 = x0 * (2.0 * x166 + 2.0 * x167 + 2.0 * x213 + 2.0 * x214 + x218) + x222 * x82
    x225 = x151 * (x0 * (2.0 * x170 + 2.0 * x171 + 3.0 * x216 + 3.0 * x217) + x223 * x82)

    # 270 item(s)
    return numpy.array(
        [
            x62 * (x0 * (2.0 * x30 + 2.0 * x36 + 3.0 * x43 + 3.0 * x50 + x56) + x4 * x58),
            x64 * x69,
            x69 * x71,
            x72 * x73,
            x56 * x79 * x80,
            x71 * x72 * x81,
            x73 * x82,
            x64 * x81 * x82,
            x56 * x76 * x86,
            x57 * x80 * x88,
            x55 * x80 * x92,
            x55 * x88 * x93,
            x57 * x72 * x94,
            x55 * x79 * x84,
            x55 * x77 * x86,
            x57 * x76 * x96,
            x55 * x89 * x96,
            x55 * x76 * x99,
            x101 * x49 * x80,
            x104 * x53 * x80,
            x101 * x53 * x93,
            x49 * x84 * x88,
            x53 * x84 * x92,
            x53 * x86 * x88,
            x49 * x77 * x96,
            x53 * x79 * x96,
            x53 * x77 * x99,
            x106 * x49 * x76,
            x106 * x53 * x89,
            x109 * x53 * x76,
            x110 * x47 * x80,
            x111 * x38 * x80,
            x110 * x38 * x93,
            x101 * x47 * x84,
            x104 * x38 * x84,
            x101 * x38 * x86,
            x47 * x88 * x96,
            x38 * x92 * x96,
            x38 * x88 * x99,
            x106 * x47 * x77,
            x106 * x38 * x79,
            x109 * x38 * x77,
            x112 * x47 * x76,
            x112 * x38 * x89,
            x113 * x38 * x76,
            x114 * x118,
            x120 * x123 * x80,
            x114 * x124 * x71,
            x117 * x126 * x80,
            x115 * x130 * x80,
            x115 * x126 * x93,
            x114 * x117 * x94,
            x115 * x120 * x84,
            x115 * x127 * x86,
            x133 * x35 * x80,
            x136 * x17 * x80,
            x133 * x17 * x93,
            x126 * x35 * x84,
            x130 * x17 * x84,
            x126 * x17 * x86,
            x127 * x35 * x96,
            x120 * x17 * x96,
            x127 * x17 * x99,
            x140 * x33 * x80,
            x144 * x15 * x80,
            x140 * x15 * x93,
            x133 * x33 * x84,
            x136 * x15 * x84,
            x133 * x15 * x86,
            x126 * x33 * x96,
            x130 * x15 * x96,
            x126 * x15 * x99,
            x106 * x127 * x33,
            x106 * x120 * x15,
            x109 * x127 * x15,
            x145 * x27 * x80,
            x147 * x9,
            x145 * x148 * x71,
            x140 * x27 * x84,
            x144 * x149 * x9,
            x11 * x140 * x86,
            x133 * x27 * x96,
            x11 * x136 * x96,
            x11 * x133 * x99,
            x106 * x126 * x27,
            x106 * x11 * x130,
            x109 * x11 * x126,
            x112 * x127 * x27,
            x11 * x112 * x120,
            x113 * x114 * x152,
            x118 * x153,
            x124 * x153 * x64,
            x123 * x155 * x76,
            x117 * x156 * x72,
            x115 * x157 * x79,
            x115 * x155 * x77,
            x117 * x159 * x76,
            x115 * x159 * x89,
            x115 * x162 * x76,
            x157 * x35 * x88,
            x157 * x17 * x92,
            x155 * x17 * x88,
            x159 * x35 * x77,
            x159 * x17 * x79,
            x162 * x17 * x77,
            x165 * x35 * x76,
            x165 * x17 * x89,
            x168 * x17 * x76,
            x101 * x157 * x33,
            x104 * x15 * x157,
            x101 * x15 * x155,
            x159 * x33 * x88,
            x15 * x159 * x92,
            x15 * x162 * x88,
            x165 * x33 * x77,
            x15 * x165 * x79,
            x15 * x168 * x77,
            x172 * x33 * x76,
            x15 * x172 * x89,
            x15 * x176 * x76,
            x110 * x157 * x27,
            x111 * x148 * x153,
            x11 * x110 * x155,
            x101 * x159 * x27,
            x104 * x11 * x159,
            x101 * x11 * x162,
            x165 * x27 * x88,
            x11 * x165 * x92,
            x11 * x168 * x88,
            x172 * x27 * x77,
            x11 * x172 * x79,
            x176 * x177 * x9,
            x178 * x27 * x76,
            x152 * x178 * x64,
            x179 * x9,
            x181 * x182 * x80,
            x185 * x186 * x80,
            x181 * x186 * x93,
            x116 * x188 * x80,
            x122 * x192 * x80,
            x122 * x188 * x93,
            x116 * x181 * x84,
            x122 * x185 * x84,
            x122 * x181 * x86,
            x195 * x24 * x80,
            x121 * x199 * x80,
            x121 * x195 * x93,
            x188 * x24 * x84,
            x121 * x192 * x84,
            x121 * x188 * x86,
            x181 * x24 * x96,
            x121 * x185 * x96,
            x121 * x181 * x99,
            x200 * x22 * x80,
            x201 * x202,
            x200 * x202 * x71,
            x195 * x22 * x84,
            x199 * x202 * x82,
            x195 * x8 * x86,
            x188 * x22 * x96,
            x192 * x8 * x96,
            x188 * x8 * x99,
            x106 * x181 * x22,
            x106 * x185 * x8,
            x109 * x181 * x8,
            x18 * x203,
            x146
            * (
                x0 * (2.0 * x142 + 2.0 * x143 + 3.0 * x197 + 3.0 * x198 + x200)
                + x201 * x72
            ),
            x203 * x71,
            x149 * x18 * x200,
            x149 * x201,
            x10 * x200 * x86,
            x19 * x195 * x96,
            x10 * x199 * x96,
            x10 * x195 * x99,
            x106 * x188 * x19,
            x10 * x106 * x192,
            x10 * x109 * x188,
            x112 * x181 * x19,
            x10 * x112 * x185,
            x10 * x113 * x181,
            x114 * x156 * x182,
            x120 * x157 * x186,
            x127 * x155 * x186,
            x116 * x126 * x157,
            x122 * x130 * x157,
            x122 * x126 * x155,
            x116 * x127 * x159,
            x120 * x122 * x159,
            x122 * x127 * x162,
            x133 * x157 * x24,
            x121 * x136 * x157,
            x121 * x133 * x155,
            x126 * x159 * x24,
            x121 * x130 * x159,
            x121 * x126 * x162,
            x127 * x165 * x24,
            x120 * x121 * x165,
            x121 * x127 * x168,
            x140 * x157 * x22,
            x144 * x153 * x202,
            x140 * x155 * x8,
            x133 * x159 * x22,
            x136 * x159 * x8,
            x133 * x162 * x8,
            x126 * x165 * x22,
            x130 * x165 * x8,
            x126 * x168 * x8,
            x127 * x172 * x22,
            x120 * x172 * x8,
            x114 * x176 * x204,
            x145 * x146 * x153 * x18,
            x147 * x153,
            x10 * x145 * x155,
            x140 * x159 * x19,
            x10 * x144 * x159,
            x10 * x140 * x162,
            x133 * x165 * x19,
            x10 * x136 * x165,
            x10 * x133 * x168,
            x126 * x172 * x19,
            x10 * x130 * x172,
            x10 * x126 * x176,
            x114 * x151 * x178 * x18,
            x10 * x120 * x178,
            x114 * x179,
            x182 * x206 * x76,
            x186 * x206 * x89,
            x186 * x209 * x76,
            x116 * x206 * x77,
            x122 * x206 * x79,
            x122 * x209 * x77,
            x116 * x211 * x76,
            x122 * x211 * x89,
            x122 * x215 * x76,
            x206 * x24 * x88,
            x121 * x206 * x92,
            x121 * x209 * x88,
            x211 * x24 * x77,
            x121 * x211 * x79,
            x121 * x215 * x77,
            x218 * x24 * x76,
            x121 * x218 * x89,
            x121 * x222 * x76,
            x101 * x206 * x22,
            x104 * x206 * x8,
            x101 * x209 * x8,
            x211 * x22 * x88,
            x211 * x8 * x92,
            x215 * x8 * x88,
            x218 * x22 * x77,
            x218 * x79 * x8,
            x204 * x222 * x72,
            x22 * x223 * x76,
            x204 * x223 * x64,
            x204 * x224,
            x110 * x19 * x206,
            x10 * x111 * x206,
            x10 * x110 * x209,
            x101 * x19 * x211,
            x10 * x104 * x211,
            x10 * x101 * x215,
            x19 * x218 * x88,
            x10 * x218 * x92,
            x10 * x222 * x88,
            x177 * x18 * x223,
            x10 * x223 * x79,
            x177 * x224,
            x18 * x225,
            x225 * x64,
            x151
            * (
                x0 * (2.0 * x174 + 2.0 * x175 + 3.0 * x220 + 3.0 * x221 + x223)
                + x224 * x82
            ),
        ]
    )


def quadrupole3d_42(a, A, b, B, C):
    """Cartesian 3D (gd) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - A[0]
    x4 = -x2 - B[0]
    x5 = a * b * x1
    x6 = numpy.exp(-x5 * (A[0] - B[0]) ** 2)
    x7 = 1.77245385090552 * numpy.sqrt(x1)
    x8 = x6 * x7
    x9 = x4 * x8
    x10 = x3 * x9
    x11 = 2.0 * x10
    x12 = x4**2 * x8
    x13 = x0 * x8
    x14 = 3.0 * x13
    x15 = x12 + x14
    x16 = x0 * (x11 + x15)
    x17 = x12 + x13
    x18 = x17 * x3
    x19 = 2.0 * x13
    x20 = x18 + x19 * x4
    x21 = x20 * x3
    x22 = x16 + x21
    x23 = -x2 - C[0]
    x24 = x23 * x9
    x25 = 2.0 * x24
    x26 = x0 * (x15 + x25)
    x27 = x23 * x8
    x28 = x0 * (x27 + x9)
    x29 = x13 + x24
    x30 = x29 * x4
    x31 = x28 + x30
    x32 = x3 * x31
    x33 = 2.0 * x26 + 2.0 * x32
    x34 = x27 * x3
    x35 = x0 * (x10 + x14 + x24 + x34)
    x36 = x29 * x3
    x37 = x28 + x36
    x38 = x3 * x37
    x39 = 2.0 * x35 + 2.0 * x38
    x40 = x0 * (x22 + x33 + x39)
    x41 = x23**2 * x8
    x42 = x13 + x41
    x43 = x4 * x42
    x44 = x19 * x23
    x45 = x43 + x44
    x46 = x3 * x45
    x47 = 2.0 * x46
    x48 = x14 + x41
    x49 = x0 * (x25 + x48)
    x50 = 2.0 * x34
    x51 = x0 * (x48 + x50)
    x52 = x3 * x42
    x53 = x44 + x52
    x54 = x3 * x53
    x55 = x51 + x54
    x56 = x0 * (x39 + x47 + 2.0 * x49 + x55)
    x57 = 2.0 * x36
    x58 = x0 * (x20 + 3.0 * x28 + x30 + x57)
    x59 = x26 + x32
    x60 = x3 * x59
    x61 = x58 + x60
    x62 = x3 * x61
    x63 = 2.0 * x28
    x64 = 4.0 * x13
    x65 = x23 * x64
    x66 = x63 + x65
    x67 = x0 * (x43 + x52 + x57 + x66)
    x68 = x46 + x49
    x69 = x3 * x68
    x70 = x67 + x69
    x71 = x3 * x70
    x72 = x4 * x45
    x73 = x0 * (x33 + x47 + 3.0 * x49 + x72)
    x74 = x0 * (2.0 * x30 + 2.0 * x43 + x66)
    x75 = x49 + x72
    x76 = x3 * x75
    x77 = x74 + x76
    x78 = x3 * x77
    x79 = x73 + x78
    x80 = (
        x0 * (2.0 * x58 + 2.0 * x60 + 2.0 * x67 + 2.0 * x69 + 2.0 * x74 + 2.0 * x76)
        + x3 * x79
    )
    x81 = numpy.exp(-x5 * (A[1] - B[1]) ** 2)
    x82 = numpy.exp(-x5 * (A[2] - B[2]) ** 2)
    x83 = 3.14159265358979 * x1 * x82
    x84 = x81 * x83
    x85 = -x1 * (a * A[1] + b * B[1])
    x86 = -x85 - B[1]
    x87 = x3 * x8
    x88 = x0 * (x27 + x87)
    x89 = x13 + x34
    x90 = x3 * x89
    x91 = x0 * (2.0 * x52 + x65 + 2.0 * x88 + 2.0 * x90) + x3 * x55
    x92 = x88 + x90
    x93 = x0 * (x87 + x9)
    x94 = x10 + x13
    x95 = x3 * x94
    x96 = x93 + x95
    x97 = x0 * (x57 + x63 + x92 + x96)
    x98 = x35 + x38
    x99 = x3 * x98
    x100 = 2.0 * x97 + 2.0 * x99
    x101 = x56 + x71
    x102 = x84 * (x0 * (x100 + 3.0 * x67 + 3.0 * x69 + x91) + x101 * x3)
    x103 = -x1 * (a * A[2] + b * B[2])
    x104 = -x103 - B[2]
    x105 = x7 * x81
    x106 = x105 * x86**2
    x107 = x0 * x105
    x108 = x106 + x107
    x109 = x3**2 * x8
    x110 = x109 + x14
    x111 = x0 * (x110 + x50)
    x112 = x3 * x92
    x113 = x0 * (2.0 * x111 + 2.0 * x112 + 3.0 * x51 + 3.0 * x54) + x3 * x91
    x114 = x7 * x82
    x115 = x104 * x84
    x116 = x104**2 * x114
    x117 = x0 * x114
    x118 = x116 + x117
    x119 = -x85 - A[1]
    x120 = x80 * x84
    x121 = x105 * x119
    x122 = x121 * x86
    x123 = x107 + x122
    x124 = x108 * x119
    x125 = 2.0 * x107
    x126 = x124 + x125 * x86
    x127 = x104 * x114
    x128 = -x103 - A[2]
    x129 = x128 * x84
    x130 = x114 * x128
    x131 = x104 * x130
    x132 = x117 + x131
    x133 = x105 * x86
    x134 = x118 * x128
    x135 = 2.0 * x117
    x136 = x104 * x135 + x134
    x137 = x105 * x119**2
    x138 = x107 + x137
    x139 = x0 * (x121 + x133)
    x140 = x119 * x123
    x141 = x139 + x140
    x142 = 3.0 * x107
    x143 = 2.0 * x122 + x142
    x144 = x0 * (x106 + x143)
    x145 = x119 * x126
    x146 = x144 + x145
    x147 = x114 * x128**2
    x148 = x117 + x147
    x149 = x0 * (x127 + x130)
    x150 = x128 * x132
    x151 = x149 + x150
    x152 = 3.0 * x117
    x153 = 2.0 * x131 + x152
    x154 = x0 * (x116 + x153)
    x155 = x128 * x136
    x156 = x154 + x155
    x157 = x119 * x125 + x119 * x138
    x158 = x0 * (x137 + x143)
    x159 = x119 * x141
    x160 = x158 + x159
    x161 = 4.0 * x107
    x162 = x0 * (2.0 * x124 + 2.0 * x139 + 2.0 * x140 + x161 * x86) + x119 * x146
    x163 = x128 * x135 + x128 * x148
    x164 = x0 * (x147 + x153)
    x165 = x128 * x151
    x166 = x164 + x165
    x167 = 4.0 * x117
    x168 = x0 * (x104 * x167 + 2.0 * x134 + 2.0 * x149 + 2.0 * x150) + x128 * x156
    x169 = x0 * (3.0 * x137 + x142) + x119 * x157
    x170 = x0 * (3.0 * x139 + 3.0 * x140 + x157) + x119 * x160
    x171 = x0 * (3.0 * x144 + 3.0 * x145 + 2.0 * x158 + 2.0 * x159) + x119 * x162
    x172 = x0 * (3.0 * x147 + x152) + x128 * x163
    x173 = x0 * (3.0 * x149 + 3.0 * x150 + x163) + x128 * x166
    x174 = x0 * (3.0 * x154 + 3.0 * x155 + 2.0 * x164 + 2.0 * x165) + x128 * x168
    x175 = -x85 - C[1]
    x176 = x0 * (2.0 * x18 + x4 * x64 + 2.0 * x93 + 2.0 * x95) + x22 * x3
    x177 = x40 + x62
    x178 = x84 * (x0 * (x100 + x176 + 3.0 * x58 + 3.0 * x60) + x177 * x3)
    x179 = x133 * x175
    x180 = x107 + x179
    x181 = x111 + x112
    x182 = x0 * (x11 + x110)
    x183 = x3 * x96
    x184 = x182 + x183
    x185 = x97 + x99
    x186 = x0 * (x181 + x184 + 3.0 * x35 + 3.0 * x38) + x185 * x3
    x187 = x105 * x175
    x188 = x0 * (x133 + x187)
    x189 = x180 * x86
    x190 = x188 + x189
    x191 = x109 + x13
    x192 = x19 * x3 + x191 * x3
    x193 = x0 * (x192 + 3.0 * x88 + 3.0 * x90) + x181 * x3
    x194 = x121 * x175
    x195 = x107 + x194
    x196 = x119 * x180
    x197 = x188 + x196
    x198 = x142 + 2.0 * x179
    x199 = x0 * (x106 + x198)
    x200 = x119 * x190
    x201 = x199 + x200
    x202 = x0 * (x121 + x187)
    x203 = x119 * x195
    x204 = x202 + x203
    x205 = x0 * (x122 + x142 + x179 + x194)
    x206 = x119 * x197
    x207 = x205 + x206
    x208 = 2.0 * x196
    x209 = x0 * (x126 + 3.0 * x188 + x189 + x208)
    x210 = x119 * x201
    x211 = x209 + x210
    x212 = x142 + 2.0 * x194
    x213 = x0 * (x137 + x212)
    x214 = x119 * x204
    x215 = x213 + x214
    x216 = 2.0 * x188
    x217 = x0 * (x141 + x204 + x208 + x216)
    x218 = x119 * x207
    x219 = x217 + x218
    x220 = 2.0 * x199 + 2.0 * x200
    x221 = 2.0 * x205 + 2.0 * x206
    x222 = x0 * (x146 + x220 + x221)
    x223 = x119 * x211
    x224 = x222 + x223
    x225 = x0 * (x157 + 3.0 * x202 + 3.0 * x203) + x119 * x215
    x226 = x0 * (x160 + 3.0 * x205 + 3.0 * x206 + x215) + x119 * x219
    x227 = 2.0 * x217 + 2.0 * x218
    x228 = x6 * x83
    x229 = x228 * (x0 * (x162 + 3.0 * x209 + 3.0 * x210 + x227) + x119 * x224)
    x230 = x228 * x23
    x231 = 3.14159265358979 * x1 * x6 * x81
    x232 = x23 * x231
    x233 = -x103 - C[2]
    x234 = x233 * x84
    x235 = x127 * x233
    x236 = x117 + x235
    x237 = x114 * x233
    x238 = x0 * (x127 + x237)
    x239 = x104 * x236
    x240 = x238 + x239
    x241 = x130 * x233
    x242 = x117 + x241
    x243 = x128 * x236
    x244 = x238 + x243
    x245 = x152 + 2.0 * x235
    x246 = x0 * (x116 + x245)
    x247 = x128 * x240
    x248 = x246 + x247
    x249 = x0 * (x130 + x237)
    x250 = x128 * x242
    x251 = x249 + x250
    x252 = x0 * (x131 + x152 + x235 + x241)
    x253 = x128 * x244
    x254 = x252 + x253
    x255 = 2.0 * x243
    x256 = x0 * (x136 + 3.0 * x238 + x239 + x255)
    x257 = x128 * x248
    x258 = x256 + x257
    x259 = x152 + 2.0 * x241
    x260 = x0 * (x147 + x259)
    x261 = x128 * x251
    x262 = x260 + x261
    x263 = 2.0 * x238
    x264 = x0 * (x151 + x251 + x255 + x263)
    x265 = x128 * x254
    x266 = x264 + x265
    x267 = 2.0 * x246 + 2.0 * x247
    x268 = 2.0 * x252 + 2.0 * x253
    x269 = x0 * (x156 + x267 + x268)
    x270 = x128 * x258
    x271 = x269 + x270
    x272 = x0 * (x163 + 3.0 * x249 + 3.0 * x250) + x128 * x262
    x273 = x0 * (x166 + 3.0 * x252 + 3.0 * x253 + x262) + x128 * x266
    x274 = 2.0 * x264 + 2.0 * x265
    x275 = x231 * (x0 * (x168 + 3.0 * x256 + 3.0 * x257 + x274) + x128 * x271)
    x276 = x105 * x175**2
    x277 = x107 + x276
    x278 = x0 * (3.0 * x16 + 2.0 * x182 + 2.0 * x183 + 3.0 * x21) + x176 * x3
    x279 = x277 * x86
    x280 = x125 * x175
    x281 = x279 + x280
    x282 = x0 * (x192 + 3.0 * x93 + 3.0 * x95) + x184 * x3
    x283 = x0 * (x198 + x276)
    x284 = x281 * x86
    x285 = x283 + x284
    x286 = x0 * (3.0 * x109 + x14) + x192 * x3
    x287 = x119 * x277
    x288 = x280 + x287
    x289 = x119 * x281
    x290 = x283 + x289
    x291 = x161 * x175
    x292 = x216 + x291
    x293 = x0 * (2.0 * x189 + 2.0 * x279 + x292)
    x294 = x119 * x285
    x295 = x293 + x294
    x296 = x0 * (x212 + x276)
    x297 = x119 * x288
    x298 = x296 + x297
    x299 = x0 * (x208 + x279 + x287 + x292)
    x300 = x119 * x290
    x301 = x299 + x300
    x302 = 2.0 * x289
    x303 = x0 * (x220 + 3.0 * x283 + x284 + x302)
    x304 = x119 * x295
    x305 = x303 + x304
    x306 = x0 * (2.0 * x202 + 2.0 * x203 + 2.0 * x287 + x291) + x119 * x298
    x307 = x0 * (x221 + 2.0 * x283 + x298 + x302)
    x308 = x119 * x301
    x309 = x307 + x308
    x310 = (
        x0 * (2.0 * x209 + 2.0 * x210 + 2.0 * x293 + 2.0 * x294 + 2.0 * x299 + 2.0 * x300)
        + x119 * x305
    )
    x311 = x228 * x310
    x312 = x228 * x3
    x313 = x0 * (2.0 * x213 + 2.0 * x214 + 3.0 * x296 + 3.0 * x297) + x119 * x306
    x314 = x228 * (x0 * (x227 + 3.0 * x299 + 3.0 * x300 + x306) + x119 * x309)
    x315 = x228 * x4
    x316 = x175 * x231
    x317 = x114 * x233**2
    x318 = x117 + x317
    x319 = x104 * x318
    x320 = x135 * x233
    x321 = x319 + x320
    x322 = x0 * (x245 + x317)
    x323 = x104 * x321
    x324 = x322 + x323
    x325 = x128 * x318
    x326 = x320 + x325
    x327 = x128 * x321
    x328 = x322 + x327
    x329 = x167 * x233
    x330 = x263 + x329
    x331 = x0 * (2.0 * x239 + 2.0 * x319 + x330)
    x332 = x128 * x324
    x333 = x331 + x332
    x334 = x0 * (x259 + x317)
    x335 = x128 * x326
    x336 = x334 + x335
    x337 = x0 * (x255 + x319 + x325 + x330)
    x338 = x128 * x328
    x339 = x337 + x338
    x340 = 2.0 * x327
    x341 = x0 * (x267 + 3.0 * x322 + x323 + x340)
    x342 = x128 * x333
    x343 = x341 + x342
    x344 = x231 * x3
    x345 = x0 * (2.0 * x249 + 2.0 * x250 + 2.0 * x325 + x329) + x128 * x336
    x346 = x0 * (x268 + 2.0 * x322 + x336 + x340)
    x347 = x128 * x339
    x348 = x346 + x347
    x349 = (
        x0 * (2.0 * x256 + 2.0 * x257 + 2.0 * x331 + 2.0 * x332 + 2.0 * x337 + 2.0 * x338)
        + x128 * x343
    )
    x350 = x231 * x349
    x351 = x231 * x4
    x352 = x0 * (2.0 * x260 + 2.0 * x261 + 3.0 * x334 + 3.0 * x335) + x128 * x345
    x353 = x231 * (x0 * (x274 + 3.0 * x337 + 3.0 * x338 + x345) + x128 * x348)

    # 540 item(s)
    return numpy.array(
        [
            x84
            * (
                x0
                * (2.0 * x40 + 2.0 * x56 + 2.0 * x62 + 2.0 * x71 + 3.0 * x73 + 3.0 * x78)
                + x3 * x80
            ),
            x102 * x86,
            x102 * x104,
            x108 * x113 * x114,
            x113 * x115 * x86,
            x105 * x113 * x118,
            x119 * x120,
            x101 * x114 * x123,
            x101 * x115 * x119,
            x114 * x126 * x91,
            x123 * x127 * x91,
            x118 * x121 * x91,
            x120 * x128,
            x101 * x129 * x86,
            x101 * x105 * x132,
            x108 * x130 * x91,
            x132 * x133 * x91,
            x105 * x136 * x91,
            x114 * x138 * x79,
            x114 * x141 * x70,
            x127 * x138 * x70,
            x114 * x146 * x55,
            x127 * x141 * x55,
            x118 * x138 * x55,
            x119 * x129 * x79,
            x123 * x130 * x70,
            x121 * x132 * x70,
            x126 * x130 * x55,
            x123 * x132 * x55,
            x121 * x136 * x55,
            x105 * x148 * x79,
            x133 * x148 * x70,
            x105 * x151 * x70,
            x108 * x148 * x55,
            x133 * x151 * x55,
            x105 * x156 * x55,
            x114 * x157 * x77,
            x114 * x160 * x68,
            x127 * x157 * x68,
            x114 * x162 * x53,
            x127 * x160 * x53,
            x118 * x157 * x53,
            x130 * x138 * x77,
            x130 * x141 * x68,
            x132 * x138 * x68,
            x130 * x146 * x53,
            x132 * x141 * x53,
            x136 * x138 * x53,
            x121 * x148 * x77,
            x123 * x148 * x68,
            x121 * x151 * x68,
            x126 * x148 * x53,
            x123 * x151 * x53,
            x121 * x156 * x53,
            x105 * x163 * x77,
            x133 * x163 * x68,
            x105 * x166 * x68,
            x108 * x163 * x53,
            x133 * x166 * x53,
            x105 * x168 * x53,
            x114 * x169 * x75,
            x114 * x170 * x45,
            x127 * x169 * x45,
            x114 * x171 * x42,
            x127 * x170 * x42,
            x118 * x169 * x42,
            x130 * x157 * x75,
            x130 * x160 * x45,
            x132 * x157 * x45,
            x130 * x162 * x42,
            x132 * x160 * x42,
            x136 * x157 * x42,
            x138 * x148 * x75,
            x141 * x148 * x45,
            x138 * x151 * x45,
            x146 * x148 * x42,
            x141 * x151 * x42,
            x138 * x156 * x42,
            x121 * x163 * x75,
            x123 * x163 * x45,
            x121 * x166 * x45,
            x126 * x163 * x42,
            x123 * x166 * x42,
            x121 * x168 * x42,
            x105 * x172 * x75,
            x133 * x172 * x45,
            x105 * x173 * x45,
            x108 * x172 * x42,
            x133 * x173 * x42,
            x105 * x174 * x42,
            x175 * x178,
            x114 * x180 * x186,
            x115 * x175 * x186,
            x114 * x190 * x193,
            x127 * x180 * x193,
            x118 * x187 * x193,
            x114 * x177 * x195,
            x114 * x185 * x197,
            x127 * x185 * x195,
            x114 * x181 * x201,
            x127 * x181 * x197,
            x118 * x181 * x195,
            x129 * x175 * x177,
            x130 * x180 * x185,
            x132 * x185 * x187,
            x130 * x181 * x190,
            x132 * x180 * x181,
            x136 * x181 * x187,
            x114 * x204 * x61,
            x114 * x207 * x98,
            x127 * x204 * x98,
            x114 * x211 * x92,
            x127 * x207 * x92,
            x118 * x204 * x92,
            x130 * x195 * x61,
            x130 * x197 * x98,
            x132 * x195 * x98,
            x130 * x201 * x92,
            x132 * x197 * x92,
            x136 * x195 * x92,
            x148 * x187 * x61,
            x148 * x180 * x98,
            x151 * x187 * x98,
            x148 * x190 * x92,
            x151 * x180 * x92,
            x156 * x187 * x92,
            x114 * x215 * x59,
            x114 * x219 * x37,
            x127 * x215 * x37,
            x114 * x224 * x89,
            x127 * x219 * x89,
            x118 * x215 * x89,
            x130 * x204 * x59,
            x130 * x207 * x37,
            x132 * x204 * x37,
            x130 * x211 * x89,
            x132 * x207 * x89,
            x136 * x204 * x89,
            x148 * x195 * x59,
            x148 * x197 * x37,
            x151 * x195 * x37,
            x148 * x201 * x89,
            x151 * x197 * x89,
            x156 * x195 * x89,
            x163 * x187 * x59,
            x163 * x180 * x37,
            x166 * x187 * x37,
            x163 * x190 * x89,
            x166 * x180 * x89,
            x168 * x187 * x89,
            x114 * x225 * x31,
            x114 * x226 * x29,
            x127 * x225 * x29,
            x229 * x23,
            x104 * x226 * x230,
            x118 * x225 * x27,
            x130 * x215 * x31,
            x130 * x219 * x29,
            x132 * x215 * x29,
            x128 * x224 * x230,
            x132 * x219 * x27,
            x136 * x215 * x27,
            x148 * x204 * x31,
            x148 * x207 * x29,
            x151 * x204 * x29,
            x148 * x211 * x27,
            x151 * x207 * x27,
            x156 * x204 * x27,
            x163 * x195 * x31,
            x163 * x197 * x29,
            x166 * x195 * x29,
            x163 * x201 * x27,
            x166 * x197 * x27,
            x168 * x195 * x27,
            x172 * x187 * x31,
            x172 * x180 * x29,
            x173 * x187 * x29,
            x172 * x190 * x27,
            x173 * x180 * x27,
            x174 * x175 * x232,
            x178 * x233,
            x186 * x234 * x86,
            x105 * x186 * x236,
            x108 * x193 * x237,
            x133 * x193 * x236,
            x105 * x193 * x240,
            x119 * x177 * x234,
            x123 * x185 * x237,
            x121 * x185 * x236,
            x126 * x181 * x237,
            x123 * x181 * x236,
            x121 * x181 * x240,
            x105 * x177 * x242,
            x133 * x185 * x242,
            x105 * x185 * x244,
            x108 * x181 * x242,
            x133 * x181 * x244,
            x105 * x181 * x248,
            x138 * x237 * x61,
            x141 * x237 * x98,
            x138 * x236 * x98,
            x146 * x237 * x92,
            x141 * x236 * x92,
            x138 * x240 * x92,
            x121 * x242 * x61,
            x123 * x242 * x98,
            x121 * x244 * x98,
            x126 * x242 * x92,
            x123 * x244 * x92,
            x121 * x248 * x92,
            x105 * x251 * x61,
            x133 * x251 * x98,
            x105 * x254 * x98,
            x108 * x251 * x92,
            x133 * x254 * x92,
            x105 * x258 * x92,
            x157 * x237 * x59,
            x160 * x237 * x37,
            x157 * x236 * x37,
            x162 * x237 * x89,
            x160 * x236 * x89,
            x157 * x240 * x89,
            x138 * x242 * x59,
            x141 * x242 * x37,
            x138 * x244 * x37,
            x146 * x242 * x89,
            x141 * x244 * x89,
            x138 * x248 * x89,
            x121 * x251 * x59,
            x123 * x251 * x37,
            x121 * x254 * x37,
            x126 * x251 * x89,
            x123 * x254 * x89,
            x121 * x258 * x89,
            x105 * x262 * x59,
            x133 * x262 * x37,
            x105 * x266 * x37,
            x108 * x262 * x89,
            x133 * x266 * x89,
            x105 * x271 * x89,
            x169 * x237 * x31,
            x170 * x237 * x29,
            x169 * x236 * x29,
            x171 * x230 * x233,
            x170 * x236 * x27,
            x169 * x240 * x27,
            x157 * x242 * x31,
            x160 * x242 * x29,
            x157 * x244 * x29,
            x162 * x242 * x27,
            x160 * x244 * x27,
            x157 * x248 * x27,
            x138 * x251 * x31,
            x141 * x251 * x29,
            x138 * x254 * x29,
            x146 * x251 * x27,
            x141 * x254 * x27,
            x138 * x258 * x27,
            x121 * x262 * x31,
            x123 * x262 * x29,
            x121 * x266 * x29,
            x126 * x262 * x27,
            x123 * x266 * x27,
            x119 * x232 * x271,
            x105 * x272 * x31,
            x133 * x272 * x29,
            x105 * x273 * x29,
            x108 * x27 * x272,
            x232 * x273 * x86,
            x23 * x275,
            x114 * x277 * x278,
            x114 * x281 * x282,
            x127 * x277 * x282,
            x114 * x285 * x286,
            x127 * x281 * x286,
            x118 * x277 * x286,
            x114 * x176 * x288,
            x114 * x184 * x290,
            x127 * x184 * x288,
            x114 * x192 * x295,
            x127 * x192 * x290,
            x118 * x192 * x288,
            x130 * x176 * x277,
            x130 * x184 * x281,
            x132 * x184 * x277,
            x130 * x192 * x285,
            x132 * x192 * x281,
            x136 * x192 * x277,
            x114 * x22 * x298,
            x114 * x301 * x96,
            x127 * x298 * x96,
            x114 * x191 * x305,
            x127 * x191 * x301,
            x118 * x191 * x298,
            x130 * x22 * x288,
            x130 * x290 * x96,
            x132 * x288 * x96,
            x130 * x191 * x295,
            x132 * x191 * x290,
            x136 * x191 * x288,
            x148 * x22 * x277,
            x148 * x281 * x96,
            x151 * x277 * x96,
            x148 * x191 * x285,
            x151 * x191 * x281,
            x156 * x191 * x277,
            x114 * x20 * x306,
            x114 * x309 * x94,
            x127 * x306 * x94,
            x3 * x311,
            x104 * x309 * x312,
            x118 * x306 * x87,
            x130 * x20 * x298,
            x130 * x301 * x94,
            x132 * x298 * x94,
            x128 * x305 * x312,
            x132 * x301 * x87,
            x136 * x298 * x87,
            x148 * x20 * x288,
            x148 * x290 * x94,
            x151 * x288 * x94,
            x148 * x295 * x87,
            x151 * x290 * x87,
            x156 * x288 * x87,
            x163 * x20 * x277,
            x163 * x281 * x94,
            x166 * x277 * x94,
            x163 * x285 * x87,
            x166 * x281 * x87,
            x168 * x277 * x87,
            x114 * x17 * x313,
            x314 * x4,
            x104 * x313 * x315,
            x228
            * (
                x0
                * (
                    2.0 * x222
                    + 2.0 * x223
                    + 3.0 * x303
                    + 3.0 * x304
                    + 2.0 * x307
                    + 2.0 * x308
                )
                + x119 * x310
            ),
            x104 * x314,
            x118 * x313 * x8,
            x130 * x17 * x306,
            x128 * x309 * x315,
            x132 * x306 * x9,
            x128 * x311,
            x132 * x309 * x8,
            x136 * x306 * x8,
            x148 * x17 * x298,
            x148 * x301 * x9,
            x151 * x298 * x9,
            x148 * x305 * x8,
            x151 * x301 * x8,
            x156 * x298 * x8,
            x163 * x17 * x288,
            x163 * x290 * x9,
            x166 * x288 * x9,
            x163 * x295 * x8,
            x166 * x290 * x8,
            x168 * x288 * x8,
            x17 * x172 * x277,
            x172 * x281 * x9,
            x173 * x277 * x9,
            x172 * x285 * x8,
            x173 * x281 * x8,
            x174 * x277 * x8,
            x175 * x234 * x278,
            x180 * x237 * x282,
            x187 * x236 * x282,
            x190 * x237 * x286,
            x180 * x236 * x286,
            x187 * x240 * x286,
            x176 * x195 * x237,
            x184 * x197 * x237,
            x184 * x195 * x236,
            x192 * x201 * x237,
            x192 * x197 * x236,
            x192 * x195 * x240,
            x176 * x187 * x242,
            x180 * x184 * x242,
            x184 * x187 * x244,
            x190 * x192 * x242,
            x180 * x192 * x244,
            x187 * x192 * x248,
            x204 * x22 * x237,
            x207 * x237 * x96,
            x204 * x236 * x96,
            x191 * x211 * x237,
            x191 * x207 * x236,
            x191 * x204 * x240,
            x195 * x22 * x242,
            x197 * x242 * x96,
            x195 * x244 * x96,
            x191 * x201 * x242,
            x191 * x197 * x244,
            x191 * x195 * x248,
            x187 * x22 * x251,
            x180 * x251 * x96,
            x187 * x254 * x96,
            x190 * x191 * x251,
            x180 * x191 * x254,
            x187 * x191 * x258,
            x20 * x215 * x237,
            x219 * x237 * x94,
            x215 * x236 * x94,
            x224 * x233 * x312,
            x219 * x236 * x87,
            x215 * x240 * x87,
            x20 * x204 * x242,
            x207 * x242 * x94,
            x204 * x244 * x94,
            x211 * x242 * x87,
            x207 * x244 * x87,
            x204 * x248 * x87,
            x195 * x20 * x251,
            x197 * x251 * x94,
            x195 * x254 * x94,
            x201 * x251 * x87,
            x197 * x254 * x87,
            x195 * x258 * x87,
            x187 * x20 * x262,
            x180 * x262 * x94,
            x187 * x266 * x94,
            x190 * x262 * x87,
            x180 * x266 * x87,
            x271 * x3 * x316,
            x17 * x225 * x237,
            x226 * x233 * x315,
            x225 * x236 * x9,
            x229 * x233,
            x226 * x236 * x8,
            x225 * x240 * x8,
            x17 * x215 * x242,
            x219 * x242 * x9,
            x215 * x244 * x9,
            x224 * x242 * x8,
            x219 * x244 * x8,
            x215 * x248 * x8,
            x17 * x204 * x251,
            x207 * x251 * x9,
            x204 * x254 * x9,
            x211 * x251 * x8,
            x207 * x254 * x8,
            x204 * x258 * x8,
            x17 * x195 * x262,
            x197 * x262 * x9,
            x195 * x266 * x9,
            x201 * x262 * x8,
            x197 * x266 * x8,
            x195 * x271 * x8,
            x17 * x187 * x272,
            x180 * x272 * x9,
            x273 * x316 * x4,
            x190 * x272 * x8,
            x180 * x273 * x8,
            x175 * x275,
            x105 * x278 * x318,
            x133 * x282 * x318,
            x105 * x282 * x321,
            x108 * x286 * x318,
            x133 * x286 * x321,
            x105 * x286 * x324,
            x121 * x176 * x318,
            x123 * x184 * x318,
            x121 * x184 * x321,
            x126 * x192 * x318,
            x123 * x192 * x321,
            x121 * x192 * x324,
            x105 * x176 * x326,
            x133 * x184 * x326,
            x105 * x184 * x328,
            x108 * x192 * x326,
            x133 * x192 * x328,
            x105 * x192 * x333,
            x138 * x22 * x318,
            x141 * x318 * x96,
            x138 * x321 * x96,
            x146 * x191 * x318,
            x141 * x191 * x321,
            x138 * x191 * x324,
            x121 * x22 * x326,
            x123 * x326 * x96,
            x121 * x328 * x96,
            x126 * x191 * x326,
            x123 * x191 * x328,
            x121 * x191 * x333,
            x105 * x22 * x336,
            x133 * x336 * x96,
            x105 * x339 * x96,
            x108 * x191 * x336,
            x133 * x191 * x339,
            x105 * x191 * x343,
            x157 * x20 * x318,
            x160 * x318 * x94,
            x157 * x321 * x94,
            x162 * x318 * x87,
            x160 * x321 * x87,
            x157 * x324 * x87,
            x138 * x20 * x326,
            x141 * x326 * x94,
            x138 * x328 * x94,
            x146 * x326 * x87,
            x141 * x328 * x87,
            x138 * x333 * x87,
            x121 * x20 * x336,
            x123 * x336 * x94,
            x121 * x339 * x94,
            x126 * x336 * x87,
            x123 * x339 * x87,
            x119 * x343 * x344,
            x105 * x20 * x345,
            x133 * x345 * x94,
            x105 * x348 * x94,
            x108 * x345 * x87,
            x344 * x348 * x86,
            x3 * x350,
            x169 * x17 * x318,
            x170 * x318 * x9,
            x169 * x321 * x9,
            x171 * x318 * x8,
            x170 * x321 * x8,
            x169 * x324 * x8,
            x157 * x17 * x326,
            x160 * x326 * x9,
            x157 * x328 * x9,
            x162 * x326 * x8,
            x160 * x328 * x8,
            x157 * x333 * x8,
            x138 * x17 * x336,
            x141 * x336 * x9,
            x138 * x339 * x9,
            x146 * x336 * x8,
            x141 * x339 * x8,
            x138 * x343 * x8,
            x121 * x17 * x345,
            x123 * x345 * x9,
            x119 * x348 * x351,
            x126 * x345 * x8,
            x123 * x348 * x8,
            x119 * x350,
            x105 * x17 * x352,
            x351 * x352 * x86,
            x353 * x4,
            x108 * x352 * x8,
            x353 * x86,
            x231
            * (
                x0
                * (
                    2.0 * x269
                    + 2.0 * x270
                    + 3.0 * x341
                    + 3.0 * x342
                    + 2.0 * x346
                    + 2.0 * x347
                )
                + x128 * x349
            ),
        ]
    )


def quadrupole3d_43(a, A, b, B, C):
    """Cartesian 3D (gf) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3**2 * x7
    x9 = x0 * x7
    x10 = x8 + x9
    x11 = x10 * x3
    x12 = -x2 - A[0]
    x13 = x10 * x12
    x14 = x3 * x9
    x15 = x0 * (x11 + 3.0 * x13 + 8.0 * x14)
    x16 = 3.0 * x9
    x17 = x0 * (x16 + 3.0 * x8)
    x18 = 2.0 * x14
    x19 = x11 + x18
    x20 = x12 * x19
    x21 = x17 + x20
    x22 = x12 * x21
    x23 = x15 + x22
    x24 = x3 * x7
    x25 = -x2 - C[0]
    x26 = x25 * x7
    x27 = x0 * (x24 + x26)
    x28 = 3.0 * x27
    x29 = x24 * x25
    x30 = x29 + x9
    x31 = x3 * x30
    x32 = x0 * (x19 + x28 + 3.0 * x31)
    x33 = x16 + 2.0 * x29
    x34 = x0 * (x33 + x8)
    x35 = x27 + x31
    x36 = x3 * x35
    x37 = x34 + x36
    x38 = x12 * x37
    x39 = 2.0 * x32 + 2.0 * x38
    x40 = x12 * x30
    x41 = 2.0 * x40
    x42 = x13 + x18
    x43 = x0 * (x28 + x31 + x41 + x42)
    x44 = x12 * x35
    x45 = x34 + x44
    x46 = x12 * x45
    x47 = 3.0 * x43 + 3.0 * x46
    x48 = x0 * (x23 + x39 + x47)
    x49 = x0 * (x21 + 4.0 * x34 + x36 + 3.0 * x44)
    x50 = x32 + x38
    x51 = x12 * x50
    x52 = x49 + x51
    x53 = x12 * x52
    x54 = x25**2 * x7
    x55 = x0 * (x33 + x54)
    x56 = x54 + x9
    x57 = x3 * x56
    x58 = x25 * x9
    x59 = 2.0 * x58
    x60 = x57 + x59
    x61 = x3 * x60
    x62 = x55 + x61
    x63 = x3 * x62
    x64 = x12 * x62
    x65 = 2.0 * x27
    x66 = 4.0 * x58
    x67 = x65 + x66
    x68 = x0 * (2.0 * x31 + 2.0 * x57 + x67)
    x69 = x0 * (x39 + x63 + 3.0 * x64 + 4.0 * x68)
    x70 = x12 * x56
    x71 = x0 * (x41 + x57 + x67 + x70)
    x72 = x12 * x60
    x73 = x55 + x72
    x74 = x12 * x73
    x75 = x0 * (2.0 * x43 + 2.0 * x46 + 2.0 * x64 + 2.0 * x68 + 2.0 * x71 + 2.0 * x74)
    x76 = 2.0 * x34
    x77 = 3.0 * x55 + x76
    x78 = x0 * (2.0 * x36 + 3.0 * x61 + x77)
    x79 = x63 + x68
    x80 = x12 * x79
    x81 = x78 + x80
    x82 = x12 * x81
    x83 = 2.0 * x44
    x84 = 2.0 * x72
    x85 = x0 * (x61 + x77 + x83 + x84)
    x86 = x64 + x68
    x87 = x12 * x86
    x88 = x85 + x87
    x89 = x12 * x88
    x90 = 3.0 * x85 + 3.0 * x87
    x91 = x69 + x82
    x92 = x0 * (2.0 * x49 + 2.0 * x51 + 2.0 * x78 + 2.0 * x80 + x90) + x12 * x91
    x93 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x94 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x95 = 3.14159265358979 * x1 * x94
    x96 = x93 * x95
    x97 = -x1 * (a * A[1] + b * B[1])
    x98 = -x97 - B[1]
    x99 = x12 * x24
    x100 = x16 + 2.0 * x99
    x101 = x0 * (x100 + x8)
    x102 = x12 * x42
    x103 = x101 + x102
    x104 = x12 * x26
    x105 = x0 * (x104 + x16 + x29 + x99)
    x106 = x27 + x40
    x107 = x106 * x12
    x108 = 2.0 * x105 + 2.0 * x107
    x109 = x0 * (x103 + x108 + x76 + x83)
    x110 = 2.0 * x104 + x16
    x111 = x0 * (x110 + x54)
    x112 = x59 + x70
    x113 = x112 * x12
    x114 = x111 + x113
    x115 = x0 * (x108 + x114 + 2.0 * x55 + x84)
    x116 = x43 + x46
    x117 = x116 * x12
    x118 = x71 + x74
    x119 = x118 * x12
    x120 = x75 + x89
    x121 = x96 * (
        x0 * (2.0 * x109 + 2.0 * x115 + 2.0 * x117 + 2.0 * x119 + x90) + x12 * x120
    )
    x122 = -x1 * (a * A[2] + b * B[2])
    x123 = -x122 - B[2]
    x124 = x6 * x93
    x125 = x124 * x98**2
    x126 = x0 * x124
    x127 = x125 + x126
    x128 = x12 * x7
    x129 = x0 * (x128 + x26)
    x130 = x104 + x9
    x131 = x12 * x130
    x132 = x0 * (2.0 * x129 + 2.0 * x131 + x66 + 2.0 * x70) + x114 * x12
    x133 = x129 + x131
    x134 = x0 * (x128 + x24)
    x135 = x9 + x99
    x136 = x12 * x135
    x137 = x134 + x136
    x138 = x0 * (x133 + x137 + x41 + x65)
    x139 = x105 + x107
    x140 = x12 * x139
    x141 = 2.0 * x138 + 2.0 * x140
    x142 = x115 + x119
    x143 = x0 * (x132 + x141 + 3.0 * x71 + 3.0 * x74) + x12 * x142
    x144 = x6 * x94
    x145 = x123 * x96
    x146 = x123**2 * x144
    x147 = x0 * x144
    x148 = x146 + x147
    x149 = x127 * x98
    x150 = x126 * x98
    x151 = 2.0 * x150
    x152 = x149 + x151
    x153 = x12**2 * x7
    x154 = x0 * (x110 + x153)
    x155 = x12 * x133
    x156 = x0 * (3.0 * x111 + 3.0 * x113 + 2.0 * x154 + 2.0 * x155) + x12 * x132
    x157 = x123 * x144
    x158 = x124 * x98
    x159 = x123 * x148
    x160 = x123 * x147
    x161 = 2.0 * x160
    x162 = x159 + x161
    x163 = -x97 - A[1]
    x164 = x92 * x96
    x165 = x124 * x163
    x166 = x165 * x98
    x167 = x126 + x166
    x168 = x127 * x163
    x169 = x151 + x168
    x170 = 3.0 * x126
    x171 = x0 * (3.0 * x125 + x170)
    x172 = x152 * x163
    x173 = x171 + x172
    x174 = -x122 - A[2]
    x175 = x174 * x96
    x176 = x144 * x174
    x177 = x123 * x176
    x178 = x147 + x177
    x179 = x148 * x174
    x180 = x161 + x179
    x181 = 3.0 * x147
    x182 = x0 * (3.0 * x146 + x181)
    x183 = x162 * x174
    x184 = x182 + x183
    x185 = x124 * x163**2
    x186 = x126 + x185
    x187 = x0 * (x158 + x165)
    x188 = x163 * x167
    x189 = x187 + x188
    x190 = 2.0 * x166 + x170
    x191 = x0 * (x125 + x190)
    x192 = x163 * x169
    x193 = x191 + x192
    x194 = x0 * (x149 + 8.0 * x150 + 3.0 * x168)
    x195 = x163 * x173
    x196 = x194 + x195
    x197 = x144 * x174**2
    x198 = x147 + x197
    x199 = x0 * (x157 + x176)
    x200 = x174 * x178
    x201 = x199 + x200
    x202 = 2.0 * x177 + x181
    x203 = x0 * (x146 + x202)
    x204 = x174 * x180
    x205 = x203 + x204
    x206 = x0 * (x159 + 8.0 * x160 + 3.0 * x179)
    x207 = x174 * x184
    x208 = x206 + x207
    x209 = 2.0 * x126
    x210 = x163 * x186 + x163 * x209
    x211 = x0 * (x185 + x190)
    x212 = x163 * x189
    x213 = x211 + x212
    x214 = x0 * (4.0 * x150 + 2.0 * x168 + 2.0 * x187 + 2.0 * x188)
    x215 = x163 * x193
    x216 = x214 + x215
    x217 = 3.0 * x191 + 3.0 * x192
    x218 = x0 * (2.0 * x171 + 2.0 * x172 + x217) + x163 * x196
    x219 = 2.0 * x147
    x220 = x174 * x198 + x174 * x219
    x221 = x0 * (x197 + x202)
    x222 = x174 * x201
    x223 = x221 + x222
    x224 = x0 * (4.0 * x160 + 2.0 * x179 + 2.0 * x199 + 2.0 * x200)
    x225 = x174 * x205
    x226 = x224 + x225
    x227 = 3.0 * x203 + 3.0 * x204
    x228 = x0 * (2.0 * x182 + 2.0 * x183 + x227) + x174 * x208
    x229 = x0 * (x170 + 3.0 * x185) + x163 * x210
    x230 = x0 * (3.0 * x187 + 3.0 * x188 + x210) + x163 * x213
    x231 = x0 * (2.0 * x211 + 2.0 * x212 + x217) + x163 * x216
    x232 = x0 * (3.0 * x194 + 3.0 * x195 + 3.0 * x214 + 3.0 * x215) + x163 * x218
    x233 = x0 * (x181 + 3.0 * x197) + x174 * x220
    x234 = x0 * (3.0 * x199 + 3.0 * x200 + x220) + x174 * x223
    x235 = x0 * (2.0 * x221 + 2.0 * x222 + x227) + x174 * x226
    x236 = x0 * (3.0 * x206 + 3.0 * x207 + 3.0 * x224 + 3.0 * x225) + x174 * x228
    x237 = -x97 - C[1]
    x238 = 3.0 * x101 + 3.0 * x102
    x239 = x0 * (2.0 * x17 + 2.0 * x20 + x238) + x12 * x23
    x240 = x48 + x53
    x241 = x96 * (
        x0 * (3.0 * x109 + 3.0 * x117 + x239 + 3.0 * x49 + 3.0 * x51) + x12 * x240
    )
    x242 = x158 * x237
    x243 = x126 + x242
    x244 = x0 * (2.0 * x13 + 2.0 * x134 + 2.0 * x136 + 4.0 * x14)
    x245 = x103 * x12
    x246 = x244 + x245
    x247 = x109 + x117
    x248 = x0 * (x141 + x246 + x47) + x12 * x247
    x249 = x124 * x237
    x250 = x0 * (x158 + x249)
    x251 = x243 * x98
    x252 = x250 + x251
    x253 = x154 + x155
    x254 = x0 * (x100 + x153)
    x255 = x12 * x137
    x256 = x254 + x255
    x257 = x138 + x140
    x258 = x0 * (3.0 * x105 + 3.0 * x107 + x253 + x256) + x12 * x257
    x259 = x170 + 2.0 * x242
    x260 = x0 * (x125 + x259)
    x261 = x252 * x98
    x262 = x260 + x261
    x263 = x153 + x9
    x264 = x12 * x263 + 2.0 * x12 * x9
    x265 = x0 * (3.0 * x129 + 3.0 * x131 + x264) + x12 * x253
    x266 = x165 * x237
    x267 = x126 + x266
    x268 = x163 * x243
    x269 = x250 + x268
    x270 = x163 * x252
    x271 = x260 + x270
    x272 = 3.0 * x250
    x273 = x0 * (x152 + 3.0 * x251 + x272)
    x274 = x163 * x262
    x275 = x273 + x274
    x276 = x0 * (x165 + x249)
    x277 = x163 * x267
    x278 = x276 + x277
    x279 = x0 * (x166 + x170 + x242 + x266)
    x280 = x163 * x269
    x281 = x279 + x280
    x282 = 2.0 * x268
    x283 = x0 * (x169 + x251 + x272 + x282)
    x284 = x163 * x271
    x285 = x283 + x284
    x286 = x0 * (x173 + 4.0 * x260 + x261 + 3.0 * x270)
    x287 = x163 * x275
    x288 = x286 + x287
    x289 = x170 + 2.0 * x266
    x290 = x0 * (x185 + x289)
    x291 = x163 * x278
    x292 = x290 + x291
    x293 = 2.0 * x250
    x294 = x0 * (x189 + x278 + x282 + x293)
    x295 = x163 * x281
    x296 = x294 + x295
    x297 = 2.0 * x260
    x298 = 2.0 * x270
    x299 = 2.0 * x279 + 2.0 * x280
    x300 = x0 * (x193 + x297 + x298 + x299)
    x301 = x163 * x285
    x302 = x300 + x301
    x303 = 2.0 * x273 + 2.0 * x274
    x304 = 3.0 * x283 + 3.0 * x284
    x305 = x0 * (x196 + x303 + x304)
    x306 = x163 * x288
    x307 = x305 + x306
    x308 = x0 * (x210 + 3.0 * x276 + 3.0 * x277) + x163 * x292
    x309 = x0 * (x213 + 3.0 * x279 + 3.0 * x280 + x292) + x163 * x296
    x310 = 2.0 * x294 + 2.0 * x295
    x311 = x0 * (x216 + x304 + x310) + x163 * x302
    x312 = x5 * x95
    x313 = x312 * (
        x0 * (x218 + 3.0 * x286 + 3.0 * x287 + 3.0 * x300 + 3.0 * x301) + x163 * x307
    )
    x314 = x25 * x312
    x315 = 3.14159265358979 * x1 * x5 * x93
    x316 = x25 * x315
    x317 = -x122 - C[2]
    x318 = x317 * x96
    x319 = x157 * x317
    x320 = x147 + x319
    x321 = x144 * x317
    x322 = x0 * (x157 + x321)
    x323 = x123 * x320
    x324 = x322 + x323
    x325 = x181 + 2.0 * x319
    x326 = x0 * (x146 + x325)
    x327 = x123 * x324
    x328 = x326 + x327
    x329 = x176 * x317
    x330 = x147 + x329
    x331 = x174 * x320
    x332 = x322 + x331
    x333 = x174 * x324
    x334 = x326 + x333
    x335 = 3.0 * x322
    x336 = x0 * (x162 + 3.0 * x323 + x335)
    x337 = x174 * x328
    x338 = x336 + x337
    x339 = x0 * (x176 + x321)
    x340 = x174 * x330
    x341 = x339 + x340
    x342 = x0 * (x177 + x181 + x319 + x329)
    x343 = x174 * x332
    x344 = x342 + x343
    x345 = 2.0 * x331
    x346 = x0 * (x180 + x323 + x335 + x345)
    x347 = x174 * x334
    x348 = x346 + x347
    x349 = x0 * (x184 + 4.0 * x326 + x327 + 3.0 * x333)
    x350 = x174 * x338
    x351 = x349 + x350
    x352 = x181 + 2.0 * x329
    x353 = x0 * (x197 + x352)
    x354 = x174 * x341
    x355 = x353 + x354
    x356 = 2.0 * x322
    x357 = x0 * (x201 + x341 + x345 + x356)
    x358 = x174 * x344
    x359 = x357 + x358
    x360 = 2.0 * x326
    x361 = 2.0 * x333
    x362 = 2.0 * x342 + 2.0 * x343
    x363 = x0 * (x205 + x360 + x361 + x362)
    x364 = x174 * x348
    x365 = x363 + x364
    x366 = 2.0 * x336 + 2.0 * x337
    x367 = 3.0 * x346 + 3.0 * x347
    x368 = x0 * (x208 + x366 + x367)
    x369 = x174 * x351
    x370 = x368 + x369
    x371 = x0 * (x220 + 3.0 * x339 + 3.0 * x340) + x174 * x355
    x372 = x0 * (x223 + 3.0 * x342 + 3.0 * x343 + x355) + x174 * x359
    x373 = 2.0 * x357 + 2.0 * x358
    x374 = x0 * (x226 + x367 + x373) + x174 * x365
    x375 = x315 * (
        x0 * (x228 + 3.0 * x349 + 3.0 * x350 + 3.0 * x363 + 3.0 * x364) + x174 * x370
    )
    x376 = x124 * x237**2
    x377 = x126 + x376
    x378 = x0 * (3.0 * x15 + 3.0 * x22 + 3.0 * x244 + 3.0 * x245) + x12 * x239
    x379 = x377 * x98
    x380 = x209 * x237
    x381 = x379 + x380
    x382 = x0 * (x238 + 2.0 * x254 + 2.0 * x255) + x12 * x246
    x383 = x0 * (x259 + x376)
    x384 = x381 * x98
    x385 = x383 + x384
    x386 = x0 * (3.0 * x134 + 3.0 * x136 + x264) + x12 * x256
    x387 = 4.0 * x126 * x237
    x388 = x293 + x387
    x389 = x0 * (2.0 * x251 + 2.0 * x379 + x388)
    x390 = x385 * x98
    x391 = x389 + x390
    x392 = x0 * (3.0 * x153 + x16) + x12 * x264
    x393 = x163 * x377
    x394 = x380 + x393
    x395 = x163 * x381
    x396 = x383 + x395
    x397 = x163 * x385
    x398 = x389 + x397
    x399 = x297 + 3.0 * x383
    x400 = x0 * (2.0 * x261 + 3.0 * x384 + x399)
    x401 = x163 * x391
    x402 = x400 + x401
    x403 = x0 * (x289 + x376)
    x404 = x163 * x394
    x405 = x403 + x404
    x406 = x0 * (x282 + x379 + x388 + x393)
    x407 = x163 * x396
    x408 = x406 + x407
    x409 = 2.0 * x395
    x410 = x0 * (x298 + x384 + x399 + x409)
    x411 = x163 * x398
    x412 = x410 + x411
    x413 = x0 * (x303 + 4.0 * x389 + x390 + 3.0 * x397)
    x414 = x163 * x402
    x415 = x413 + x414
    x416 = x0 * (2.0 * x276 + 2.0 * x277 + x387 + 2.0 * x393) + x163 * x405
    x417 = x0 * (x299 + 2.0 * x383 + x405 + x409)
    x418 = x163 * x408
    x419 = x417 + x418
    x420 = x0 * (
        2.0 * x283 + 2.0 * x284 + 2.0 * x389 + 2.0 * x397 + 2.0 * x406 + 2.0 * x407
    )
    x421 = x163 * x412
    x422 = x420 + x421
    x423 = 3.0 * x410 + 3.0 * x411
    x424 = x0 * (2.0 * x286 + 2.0 * x287 + 2.0 * x400 + 2.0 * x401 + x423) + x163 * x415
    x425 = x312 * x424
    x426 = x12 * x312
    x427 = x0 * (2.0 * x290 + 2.0 * x291 + 3.0 * x403 + 3.0 * x404) + x163 * x416
    x428 = x0 * (x310 + 3.0 * x406 + 3.0 * x407 + x416) + x163 * x419
    x429 = x312 * (
        x0 * (2.0 * x300 + 2.0 * x301 + 2.0 * x417 + 2.0 * x418 + x423) + x163 * x422
    )
    x430 = x3 * x312
    x431 = x237 * x315
    x432 = x144 * x317**2
    x433 = x147 + x432
    x434 = x123 * x433
    x435 = x219 * x317
    x436 = x434 + x435
    x437 = x0 * (x325 + x432)
    x438 = x123 * x436
    x439 = x437 + x438
    x440 = 4.0 * x147 * x317
    x441 = x356 + x440
    x442 = x0 * (2.0 * x323 + 2.0 * x434 + x441)
    x443 = x123 * x439
    x444 = x442 + x443
    x445 = x174 * x433
    x446 = x435 + x445
    x447 = x174 * x436
    x448 = x437 + x447
    x449 = x174 * x439
    x450 = x442 + x449
    x451 = x360 + 3.0 * x437
    x452 = x0 * (2.0 * x327 + 3.0 * x438 + x451)
    x453 = x174 * x444
    x454 = x452 + x453
    x455 = x0 * (x352 + x432)
    x456 = x174 * x446
    x457 = x455 + x456
    x458 = x0 * (x345 + x434 + x441 + x445)
    x459 = x174 * x448
    x460 = x458 + x459
    x461 = 2.0 * x447
    x462 = x0 * (x361 + x438 + x451 + x461)
    x463 = x174 * x450
    x464 = x462 + x463
    x465 = x0 * (x366 + 4.0 * x442 + x443 + 3.0 * x449)
    x466 = x174 * x454
    x467 = x465 + x466
    x468 = x12 * x315
    x469 = x0 * (2.0 * x339 + 2.0 * x340 + x440 + 2.0 * x445) + x174 * x457
    x470 = x0 * (x362 + 2.0 * x437 + x457 + x461)
    x471 = x174 * x460
    x472 = x470 + x471
    x473 = x0 * (
        2.0 * x346 + 2.0 * x347 + 2.0 * x442 + 2.0 * x449 + 2.0 * x458 + 2.0 * x459
    )
    x474 = x174 * x464
    x475 = x473 + x474
    x476 = 3.0 * x462 + 3.0 * x463
    x477 = x0 * (2.0 * x349 + 2.0 * x350 + 2.0 * x452 + 2.0 * x453 + x476) + x174 * x467
    x478 = x315 * x477
    x479 = x3 * x315
    x480 = x0 * (2.0 * x353 + 2.0 * x354 + 3.0 * x455 + 3.0 * x456) + x174 * x469
    x481 = x0 * (x373 + 3.0 * x458 + 3.0 * x459 + x469) + x174 * x472
    x482 = x315 * (
        x0 * (2.0 * x363 + 2.0 * x364 + 2.0 * x470 + 2.0 * x471 + x476) + x174 * x475
    )

    # 900 item(s)
    return numpy.array(
        [
            x96
            * (
                x0
                * (2.0 * x48 + 2.0 * x53 + 3.0 * x69 + 3.0 * x75 + 3.0 * x82 + 3.0 * x89)
                + x12 * x92
            ),
            x121 * x98,
            x121 * x123,
            x127 * x143 * x144,
            x143 * x145 * x98,
            x124 * x143 * x148,
            x144 * x152 * x156,
            x127 * x156 * x157,
            x148 * x156 * x158,
            x124 * x156 * x162,
            x163 * x164,
            x120 * x144 * x167,
            x120 * x145 * x163,
            x142 * x144 * x169,
            x142 * x157 * x167,
            x142 * x148 * x165,
            x132 * x144 * x173,
            x132 * x157 * x169,
            x132 * x148 * x167,
            x132 * x162 * x165,
            x164 * x174,
            x120 * x175 * x98,
            x120 * x124 * x178,
            x127 * x142 * x176,
            x142 * x158 * x178,
            x124 * x142 * x180,
            x132 * x152 * x176,
            x127 * x132 * x178,
            x132 * x158 * x180,
            x124 * x132 * x184,
            x144 * x186 * x91,
            x144 * x189 * x88,
            x157 * x186 * x88,
            x118 * x144 * x193,
            x118 * x157 * x189,
            x118 * x148 * x186,
            x114 * x144 * x196,
            x114 * x157 * x193,
            x114 * x148 * x189,
            x114 * x162 * x186,
            x163 * x175 * x91,
            x167 * x176 * x88,
            x165 * x178 * x88,
            x118 * x169 * x176,
            x118 * x167 * x178,
            x118 * x165 * x180,
            x114 * x173 * x176,
            x114 * x169 * x178,
            x114 * x167 * x180,
            x114 * x165 * x184,
            x124 * x198 * x91,
            x158 * x198 * x88,
            x124 * x201 * x88,
            x118 * x127 * x198,
            x118 * x158 * x201,
            x118 * x124 * x205,
            x114 * x152 * x198,
            x114 * x127 * x201,
            x114 * x158 * x205,
            x114 * x124 * x208,
            x144 * x210 * x81,
            x144 * x213 * x86,
            x157 * x210 * x86,
            x144 * x216 * x73,
            x157 * x213 * x73,
            x148 * x210 * x73,
            x112 * x144 * x218,
            x112 * x157 * x216,
            x112 * x148 * x213,
            x112 * x162 * x210,
            x176 * x186 * x81,
            x176 * x189 * x86,
            x178 * x186 * x86,
            x176 * x193 * x73,
            x178 * x189 * x73,
            x180 * x186 * x73,
            x112 * x176 * x196,
            x112 * x178 * x193,
            x112 * x180 * x189,
            x112 * x184 * x186,
            x165 * x198 * x81,
            x167 * x198 * x86,
            x165 * x201 * x86,
            x169 * x198 * x73,
            x167 * x201 * x73,
            x165 * x205 * x73,
            x112 * x173 * x198,
            x112 * x169 * x201,
            x112 * x167 * x205,
            x112 * x165 * x208,
            x124 * x220 * x81,
            x158 * x220 * x86,
            x124 * x223 * x86,
            x127 * x220 * x73,
            x158 * x223 * x73,
            x124 * x226 * x73,
            x112 * x152 * x220,
            x112 * x127 * x223,
            x112 * x158 * x226,
            x112 * x124 * x228,
            x144 * x229 * x79,
            x144 * x230 * x62,
            x157 * x229 * x62,
            x144 * x231 * x60,
            x157 * x230 * x60,
            x148 * x229 * x60,
            x144 * x232 * x56,
            x157 * x231 * x56,
            x148 * x230 * x56,
            x162 * x229 * x56,
            x176 * x210 * x79,
            x176 * x213 * x62,
            x178 * x210 * x62,
            x176 * x216 * x60,
            x178 * x213 * x60,
            x180 * x210 * x60,
            x176 * x218 * x56,
            x178 * x216 * x56,
            x180 * x213 * x56,
            x184 * x210 * x56,
            x186 * x198 * x79,
            x189 * x198 * x62,
            x186 * x201 * x62,
            x193 * x198 * x60,
            x189 * x201 * x60,
            x186 * x205 * x60,
            x196 * x198 * x56,
            x193 * x201 * x56,
            x189 * x205 * x56,
            x186 * x208 * x56,
            x165 * x220 * x79,
            x167 * x220 * x62,
            x165 * x223 * x62,
            x169 * x220 * x60,
            x167 * x223 * x60,
            x165 * x226 * x60,
            x173 * x220 * x56,
            x169 * x223 * x56,
            x167 * x226 * x56,
            x165 * x228 * x56,
            x124 * x233 * x79,
            x158 * x233 * x62,
            x124 * x234 * x62,
            x127 * x233 * x60,
            x158 * x234 * x60,
            x124 * x235 * x60,
            x152 * x233 * x56,
            x127 * x234 * x56,
            x158 * x235 * x56,
            x124 * x236 * x56,
            x237 * x241,
            x144 * x243 * x248,
            x145 * x237 * x248,
            x144 * x252 * x258,
            x157 * x243 * x258,
            x148 * x249 * x258,
            x144 * x262 * x265,
            x157 * x252 * x265,
            x148 * x243 * x265,
            x162 * x249 * x265,
            x144 * x240 * x267,
            x144 * x247 * x269,
            x157 * x247 * x267,
            x144 * x257 * x271,
            x157 * x257 * x269,
            x148 * x257 * x267,
            x144 * x253 * x275,
            x157 * x253 * x271,
            x148 * x253 * x269,
            x162 * x253 * x267,
            x175 * x237 * x240,
            x176 * x243 * x247,
            x178 * x247 * x249,
            x176 * x252 * x257,
            x178 * x243 * x257,
            x180 * x249 * x257,
            x176 * x253 * x262,
            x178 * x252 * x253,
            x180 * x243 * x253,
            x184 * x249 * x253,
            x144 * x278 * x52,
            x116 * x144 * x281,
            x116 * x157 * x278,
            x139 * x144 * x285,
            x139 * x157 * x281,
            x139 * x148 * x278,
            x133 * x144 * x288,
            x133 * x157 * x285,
            x133 * x148 * x281,
            x133 * x162 * x278,
            x176 * x267 * x52,
            x116 * x176 * x269,
            x116 * x178 * x267,
            x139 * x176 * x271,
            x139 * x178 * x269,
            x139 * x180 * x267,
            x133 * x176 * x275,
            x133 * x178 * x271,
            x133 * x180 * x269,
            x133 * x184 * x267,
            x198 * x249 * x52,
            x116 * x198 * x243,
            x116 * x201 * x249,
            x139 * x198 * x252,
            x139 * x201 * x243,
            x139 * x205 * x249,
            x133 * x198 * x262,
            x133 * x201 * x252,
            x133 * x205 * x243,
            x133 * x208 * x249,
            x144 * x292 * x50,
            x144 * x296 * x45,
            x157 * x292 * x45,
            x106 * x144 * x302,
            x106 * x157 * x296,
            x106 * x148 * x292,
            x130 * x144 * x307,
            x130 * x157 * x302,
            x130 * x148 * x296,
            x130 * x162 * x292,
            x176 * x278 * x50,
            x176 * x281 * x45,
            x178 * x278 * x45,
            x106 * x176 * x285,
            x106 * x178 * x281,
            x106 * x180 * x278,
            x130 * x176 * x288,
            x130 * x178 * x285,
            x130 * x180 * x281,
            x130 * x184 * x278,
            x198 * x267 * x50,
            x198 * x269 * x45,
            x201 * x267 * x45,
            x106 * x198 * x271,
            x106 * x201 * x269,
            x106 * x205 * x267,
            x130 * x198 * x275,
            x130 * x201 * x271,
            x130 * x205 * x269,
            x130 * x208 * x267,
            x220 * x249 * x50,
            x220 * x243 * x45,
            x223 * x249 * x45,
            x106 * x220 * x252,
            x106 * x223 * x243,
            x106 * x226 * x249,
            x130 * x220 * x262,
            x130 * x223 * x252,
            x130 * x226 * x243,
            x130 * x228 * x249,
            x144 * x308 * x37,
            x144 * x309 * x35,
            x157 * x308 * x35,
            x144 * x30 * x311,
            x157 * x30 * x309,
            x148 * x30 * x308,
            x25 * x313,
            x123 * x311 * x314,
            x148 * x26 * x309,
            x162 * x26 * x308,
            x176 * x292 * x37,
            x176 * x296 * x35,
            x178 * x292 * x35,
            x176 * x30 * x302,
            x178 * x296 * x30,
            x180 * x292 * x30,
            x174 * x307 * x314,
            x178 * x26 * x302,
            x180 * x26 * x296,
            x184 * x26 * x292,
            x198 * x278 * x37,
            x198 * x281 * x35,
            x201 * x278 * x35,
            x198 * x285 * x30,
            x201 * x281 * x30,
            x205 * x278 * x30,
            x198 * x26 * x288,
            x201 * x26 * x285,
            x205 * x26 * x281,
            x208 * x26 * x278,
            x220 * x267 * x37,
            x220 * x269 * x35,
            x223 * x267 * x35,
            x220 * x271 * x30,
            x223 * x269 * x30,
            x226 * x267 * x30,
            x220 * x26 * x275,
            x223 * x26 * x271,
            x226 * x26 * x269,
            x228 * x26 * x267,
            x233 * x249 * x37,
            x233 * x243 * x35,
            x234 * x249 * x35,
            x233 * x252 * x30,
            x234 * x243 * x30,
            x235 * x249 * x30,
            x233 * x26 * x262,
            x234 * x252 * x26,
            x235 * x243 * x26,
            x236 * x237 * x316,
            x241 * x317,
            x248 * x318 * x98,
            x124 * x248 * x320,
            x127 * x258 * x321,
            x158 * x258 * x320,
            x124 * x258 * x324,
            x152 * x265 * x321,
            x127 * x265 * x320,
            x158 * x265 * x324,
            x124 * x265 * x328,
            x163 * x240 * x318,
            x167 * x247 * x321,
            x165 * x247 * x320,
            x169 * x257 * x321,
            x167 * x257 * x320,
            x165 * x257 * x324,
            x173 * x253 * x321,
            x169 * x253 * x320,
            x167 * x253 * x324,
            x165 * x253 * x328,
            x124 * x240 * x330,
            x158 * x247 * x330,
            x124 * x247 * x332,
            x127 * x257 * x330,
            x158 * x257 * x332,
            x124 * x257 * x334,
            x152 * x253 * x330,
            x127 * x253 * x332,
            x158 * x253 * x334,
            x124 * x253 * x338,
            x186 * x321 * x52,
            x116 * x189 * x321,
            x116 * x186 * x320,
            x139 * x193 * x321,
            x139 * x189 * x320,
            x139 * x186 * x324,
            x133 * x196 * x321,
            x133 * x193 * x320,
            x133 * x189 * x324,
            x133 * x186 * x328,
            x165 * x330 * x52,
            x116 * x167 * x330,
            x116 * x165 * x332,
            x139 * x169 * x330,
            x139 * x167 * x332,
            x139 * x165 * x334,
            x133 * x173 * x330,
            x133 * x169 * x332,
            x133 * x167 * x334,
            x133 * x165 * x338,
            x124 * x341 * x52,
            x116 * x158 * x341,
            x116 * x124 * x344,
            x127 * x139 * x341,
            x139 * x158 * x344,
            x124 * x139 * x348,
            x133 * x152 * x341,
            x127 * x133 * x344,
            x133 * x158 * x348,
            x124 * x133 * x351,
            x210 * x321 * x50,
            x213 * x321 * x45,
            x210 * x320 * x45,
            x106 * x216 * x321,
            x106 * x213 * x320,
            x106 * x210 * x324,
            x130 * x218 * x321,
            x130 * x216 * x320,
            x130 * x213 * x324,
            x130 * x210 * x328,
            x186 * x330 * x50,
            x189 * x330 * x45,
            x186 * x332 * x45,
            x106 * x193 * x330,
            x106 * x189 * x332,
            x106 * x186 * x334,
            x130 * x196 * x330,
            x130 * x193 * x332,
            x130 * x189 * x334,
            x130 * x186 * x338,
            x165 * x341 * x50,
            x167 * x341 * x45,
            x165 * x344 * x45,
            x106 * x169 * x341,
            x106 * x167 * x344,
            x106 * x165 * x348,
            x130 * x173 * x341,
            x130 * x169 * x344,
            x130 * x167 * x348,
            x130 * x165 * x351,
            x124 * x355 * x50,
            x158 * x355 * x45,
            x124 * x359 * x45,
            x106 * x127 * x355,
            x106 * x158 * x359,
            x106 * x124 * x365,
            x130 * x152 * x355,
            x127 * x130 * x359,
            x130 * x158 * x365,
            x124 * x130 * x370,
            x229 * x321 * x37,
            x230 * x321 * x35,
            x229 * x320 * x35,
            x231 * x30 * x321,
            x230 * x30 * x320,
            x229 * x30 * x324,
            x232 * x314 * x317,
            x231 * x26 * x320,
            x230 * x26 * x324,
            x229 * x26 * x328,
            x210 * x330 * x37,
            x213 * x330 * x35,
            x210 * x332 * x35,
            x216 * x30 * x330,
            x213 * x30 * x332,
            x210 * x30 * x334,
            x218 * x26 * x330,
            x216 * x26 * x332,
            x213 * x26 * x334,
            x210 * x26 * x338,
            x186 * x341 * x37,
            x189 * x341 * x35,
            x186 * x344 * x35,
            x193 * x30 * x341,
            x189 * x30 * x344,
            x186 * x30 * x348,
            x196 * x26 * x341,
            x193 * x26 * x344,
            x189 * x26 * x348,
            x186 * x26 * x351,
            x165 * x355 * x37,
            x167 * x35 * x355,
            x165 * x35 * x359,
            x169 * x30 * x355,
            x167 * x30 * x359,
            x165 * x30 * x365,
            x173 * x26 * x355,
            x169 * x26 * x359,
            x167 * x26 * x365,
            x163 * x316 * x370,
            x124 * x37 * x371,
            x158 * x35 * x371,
            x124 * x35 * x372,
            x127 * x30 * x371,
            x158 * x30 * x372,
            x124 * x30 * x374,
            x152 * x26 * x371,
            x127 * x26 * x372,
            x316 * x374 * x98,
            x25 * x375,
            x144 * x377 * x378,
            x144 * x381 * x382,
            x157 * x377 * x382,
            x144 * x385 * x386,
            x157 * x381 * x386,
            x148 * x377 * x386,
            x144 * x391 * x392,
            x157 * x385 * x392,
            x148 * x381 * x392,
            x162 * x377 * x392,
            x144 * x239 * x394,
            x144 * x246 * x396,
            x157 * x246 * x394,
            x144 * x256 * x398,
            x157 * x256 * x396,
            x148 * x256 * x394,
            x144 * x264 * x402,
            x157 * x264 * x398,
            x148 * x264 * x396,
            x162 * x264 * x394,
            x176 * x239 * x377,
            x176 * x246 * x381,
            x178 * x246 * x377,
            x176 * x256 * x385,
            x178 * x256 * x381,
            x180 * x256 * x377,
            x176 * x264 * x391,
            x178 * x264 * x385,
            x180 * x264 * x381,
            x184 * x264 * x377,
            x144 * x23 * x405,
            x103 * x144 * x408,
            x103 * x157 * x405,
            x137 * x144 * x412,
            x137 * x157 * x408,
            x137 * x148 * x405,
            x144 * x263 * x415,
            x157 * x263 * x412,
            x148 * x263 * x408,
            x162 * x263 * x405,
            x176 * x23 * x394,
            x103 * x176 * x396,
            x103 * x178 * x394,
            x137 * x176 * x398,
            x137 * x178 * x396,
            x137 * x180 * x394,
            x176 * x263 * x402,
            x178 * x263 * x398,
            x180 * x263 * x396,
            x184 * x263 * x394,
            x198 * x23 * x377,
            x103 * x198 * x381,
            x103 * x201 * x377,
            x137 * x198 * x385,
            x137 * x201 * x381,
            x137 * x205 * x377,
            x198 * x263 * x391,
            x201 * x263 * x385,
            x205 * x263 * x381,
            x208 * x263 * x377,
            x144 * x21 * x416,
            x144 * x419 * x42,
            x157 * x416 * x42,
            x135 * x144 * x422,
            x135 * x157 * x419,
            x135 * x148 * x416,
            x12 * x425,
            x123 * x422 * x426,
            x128 * x148 * x419,
            x128 * x162 * x416,
            x176 * x21 * x405,
            x176 * x408 * x42,
            x178 * x405 * x42,
            x135 * x176 * x412,
            x135 * x178 * x408,
            x135 * x180 * x405,
            x174 * x415 * x426,
            x128 * x178 * x412,
            x128 * x180 * x408,
            x128 * x184 * x405,
            x198 * x21 * x394,
            x198 * x396 * x42,
            x201 * x394 * x42,
            x135 * x198 * x398,
            x135 * x201 * x396,
            x135 * x205 * x394,
            x128 * x198 * x402,
            x128 * x201 * x398,
            x128 * x205 * x396,
            x128 * x208 * x394,
            x21 * x220 * x377,
            x220 * x381 * x42,
            x223 * x377 * x42,
            x135 * x220 * x385,
            x135 * x223 * x381,
            x135 * x226 * x377,
            x128 * x220 * x391,
            x128 * x223 * x385,
            x128 * x226 * x381,
            x128 * x228 * x377,
            x144 * x19 * x427,
            x10 * x144 * x428,
            x10 * x157 * x427,
            x3 * x429,
            x123 * x428 * x430,
            x148 * x24 * x427,
            x312
            * (
                x0
                * (
                    2.0 * x305
                    + 2.0 * x306
                    + 3.0 * x413
                    + 3.0 * x414
                    + 3.0 * x420
                    + 3.0 * x421
                )
                + x163 * x424
            ),
            x123 * x429,
            x148 * x428 * x7,
            x162 * x427 * x7,
            x176 * x19 * x416,
            x10 * x176 * x419,
            x10 * x178 * x416,
            x174 * x422 * x430,
            x178 * x24 * x419,
            x180 * x24 * x416,
            x174 * x425,
            x178 * x422 * x7,
            x180 * x419 * x7,
            x184 * x416 * x7,
            x19 * x198 * x405,
            x10 * x198 * x408,
            x10 * x201 * x405,
            x198 * x24 * x412,
            x201 * x24 * x408,
            x205 * x24 * x405,
            x198 * x415 * x7,
            x201 * x412 * x7,
            x205 * x408 * x7,
            x208 * x405 * x7,
            x19 * x220 * x394,
            x10 * x220 * x396,
            x10 * x223 * x394,
            x220 * x24 * x398,
            x223 * x24 * x396,
            x226 * x24 * x394,
            x220 * x402 * x7,
            x223 * x398 * x7,
            x226 * x396 * x7,
            x228 * x394 * x7,
            x19 * x233 * x377,
            x10 * x233 * x381,
            x10 * x234 * x377,
            x233 * x24 * x385,
            x234 * x24 * x381,
            x235 * x24 * x377,
            x233 * x391 * x7,
            x234 * x385 * x7,
            x235 * x381 * x7,
            x236 * x377 * x7,
            x237 * x318 * x378,
            x243 * x321 * x382,
            x249 * x320 * x382,
            x252 * x321 * x386,
            x243 * x320 * x386,
            x249 * x324 * x386,
            x262 * x321 * x392,
            x252 * x320 * x392,
            x243 * x324 * x392,
            x249 * x328 * x392,
            x239 * x267 * x321,
            x246 * x269 * x321,
            x246 * x267 * x320,
            x256 * x271 * x321,
            x256 * x269 * x320,
            x256 * x267 * x324,
            x264 * x275 * x321,
            x264 * x271 * x320,
            x264 * x269 * x324,
            x264 * x267 * x328,
            x239 * x249 * x330,
            x243 * x246 * x330,
            x246 * x249 * x332,
            x252 * x256 * x330,
            x243 * x256 * x332,
            x249 * x256 * x334,
            x262 * x264 * x330,
            x252 * x264 * x332,
            x243 * x264 * x334,
            x249 * x264 * x338,
            x23 * x278 * x321,
            x103 * x281 * x321,
            x103 * x278 * x320,
            x137 * x285 * x321,
            x137 * x281 * x320,
            x137 * x278 * x324,
            x263 * x288 * x321,
            x263 * x285 * x320,
            x263 * x281 * x324,
            x263 * x278 * x328,
            x23 * x267 * x330,
            x103 * x269 * x330,
            x103 * x267 * x332,
            x137 * x271 * x330,
            x137 * x269 * x332,
            x137 * x267 * x334,
            x263 * x275 * x330,
            x263 * x271 * x332,
            x263 * x269 * x334,
            x263 * x267 * x338,
            x23 * x249 * x341,
            x103 * x243 * x341,
            x103 * x249 * x344,
            x137 * x252 * x341,
            x137 * x243 * x344,
            x137 * x249 * x348,
            x262 * x263 * x341,
            x252 * x263 * x344,
            x243 * x263 * x348,
            x249 * x263 * x351,
            x21 * x292 * x321,
            x296 * x321 * x42,
            x292 * x320 * x42,
            x135 * x302 * x321,
            x135 * x296 * x320,
            x135 * x292 * x324,
            x307 * x317 * x426,
            x128 * x302 * x320,
            x128 * x296 * x324,
            x128 * x292 * x328,
            x21 * x278 * x330,
            x281 * x330 * x42,
            x278 * x332 * x42,
            x135 * x285 * x330,
            x135 * x281 * x332,
            x135 * x278 * x334,
            x128 * x288 * x330,
            x128 * x285 * x332,
            x128 * x281 * x334,
            x128 * x278 * x338,
            x21 * x267 * x341,
            x269 * x341 * x42,
            x267 * x344 * x42,
            x135 * x271 * x341,
            x135 * x269 * x344,
            x135 * x267 * x348,
            x128 * x275 * x341,
            x128 * x271 * x344,
            x128 * x269 * x348,
            x128 * x267 * x351,
            x21 * x249 * x355,
            x243 * x355 * x42,
            x249 * x359 * x42,
            x135 * x252 * x355,
            x135 * x243 * x359,
            x135 * x249 * x365,
            x128 * x262 * x355,
            x128 * x252 * x359,
            x128 * x243 * x365,
            x12 * x370 * x431,
            x19 * x308 * x321,
            x10 * x309 * x321,
            x10 * x308 * x320,
            x311 * x317 * x430,
            x24 * x309 * x320,
            x24 * x308 * x324,
            x313 * x317,
            x311 * x320 * x7,
            x309 * x324 * x7,
            x308 * x328 * x7,
            x19 * x292 * x330,
            x10 * x296 * x330,
            x10 * x292 * x332,
            x24 * x302 * x330,
            x24 * x296 * x332,
            x24 * x292 * x334,
            x307 * x330 * x7,
            x302 * x332 * x7,
            x296 * x334 * x7,
            x292 * x338 * x7,
            x19 * x278 * x341,
            x10 * x281 * x341,
            x10 * x278 * x344,
            x24 * x285 * x341,
            x24 * x281 * x344,
            x24 * x278 * x348,
            x288 * x341 * x7,
            x285 * x344 * x7,
            x281 * x348 * x7,
            x278 * x351 * x7,
            x19 * x267 * x355,
            x10 * x269 * x355,
            x10 * x267 * x359,
            x24 * x271 * x355,
            x24 * x269 * x359,
            x24 * x267 * x365,
            x275 * x355 * x7,
            x271 * x359 * x7,
            x269 * x365 * x7,
            x267 * x370 * x7,
            x19 * x249 * x371,
            x10 * x243 * x371,
            x10 * x249 * x372,
            x24 * x252 * x371,
            x24 * x243 * x372,
            x3 * x374 * x431,
            x262 * x371 * x7,
            x252 * x372 * x7,
            x243 * x374 * x7,
            x237 * x375,
            x124 * x378 * x433,
            x158 * x382 * x433,
            x124 * x382 * x436,
            x127 * x386 * x433,
            x158 * x386 * x436,
            x124 * x386 * x439,
            x152 * x392 * x433,
            x127 * x392 * x436,
            x158 * x392 * x439,
            x124 * x392 * x444,
            x165 * x239 * x433,
            x167 * x246 * x433,
            x165 * x246 * x436,
            x169 * x256 * x433,
            x167 * x256 * x436,
            x165 * x256 * x439,
            x173 * x264 * x433,
            x169 * x264 * x436,
            x167 * x264 * x439,
            x165 * x264 * x444,
            x124 * x239 * x446,
            x158 * x246 * x446,
            x124 * x246 * x448,
            x127 * x256 * x446,
            x158 * x256 * x448,
            x124 * x256 * x450,
            x152 * x264 * x446,
            x127 * x264 * x448,
            x158 * x264 * x450,
            x124 * x264 * x454,
            x186 * x23 * x433,
            x103 * x189 * x433,
            x103 * x186 * x436,
            x137 * x193 * x433,
            x137 * x189 * x436,
            x137 * x186 * x439,
            x196 * x263 * x433,
            x193 * x263 * x436,
            x189 * x263 * x439,
            x186 * x263 * x444,
            x165 * x23 * x446,
            x103 * x167 * x446,
            x103 * x165 * x448,
            x137 * x169 * x446,
            x137 * x167 * x448,
            x137 * x165 * x450,
            x173 * x263 * x446,
            x169 * x263 * x448,
            x167 * x263 * x450,
            x165 * x263 * x454,
            x124 * x23 * x457,
            x103 * x158 * x457,
            x103 * x124 * x460,
            x127 * x137 * x457,
            x137 * x158 * x460,
            x124 * x137 * x464,
            x152 * x263 * x457,
            x127 * x263 * x460,
            x158 * x263 * x464,
            x124 * x263 * x467,
            x21 * x210 * x433,
            x213 * x42 * x433,
            x210 * x42 * x436,
            x135 * x216 * x433,
            x135 * x213 * x436,
            x135 * x210 * x439,
            x128 * x218 * x433,
            x128 * x216 * x436,
            x128 * x213 * x439,
            x128 * x210 * x444,
            x186 * x21 * x446,
            x189 * x42 * x446,
            x186 * x42 * x448,
            x135 * x193 * x446,
            x135 * x189 * x448,
            x135 * x186 * x450,
            x128 * x196 * x446,
            x128 * x193 * x448,
            x128 * x189 * x450,
            x128 * x186 * x454,
            x165 * x21 * x457,
            x167 * x42 * x457,
            x165 * x42 * x460,
            x135 * x169 * x457,
            x135 * x167 * x460,
            x135 * x165 * x464,
            x128 * x173 * x457,
            x128 * x169 * x460,
            x128 * x167 * x464,
            x163 * x467 * x468,
            x124 * x21 * x469,
            x158 * x42 * x469,
            x124 * x42 * x472,
            x127 * x135 * x469,
            x135 * x158 * x472,
            x124 * x135 * x475,
            x128 * x152 * x469,
            x127 * x128 * x472,
            x468 * x475 * x98,
            x12 * x478,
            x19 * x229 * x433,
            x10 * x230 * x433,
            x10 * x229 * x436,
            x231 * x24 * x433,
            x230 * x24 * x436,
            x229 * x24 * x439,
            x232 * x433 * x7,
            x231 * x436 * x7,
            x230 * x439 * x7,
            x229 * x444 * x7,
            x19 * x210 * x446,
            x10 * x213 * x446,
            x10 * x210 * x448,
            x216 * x24 * x446,
            x213 * x24 * x448,
            x210 * x24 * x450,
            x218 * x446 * x7,
            x216 * x448 * x7,
            x213 * x450 * x7,
            x210 * x454 * x7,
            x186 * x19 * x457,
            x10 * x189 * x457,
            x10 * x186 * x460,
            x193 * x24 * x457,
            x189 * x24 * x460,
            x186 * x24 * x464,
            x196 * x457 * x7,
            x193 * x460 * x7,
            x189 * x464 * x7,
            x186 * x467 * x7,
            x165 * x19 * x469,
            x10 * x167 * x469,
            x10 * x165 * x472,
            x169 * x24 * x469,
            x167 * x24 * x472,
            x163 * x475 * x479,
            x173 * x469 * x7,
            x169 * x472 * x7,
            x167 * x475 * x7,
            x163 * x478,
            x124 * x19 * x480,
            x10 * x158 * x480,
            x10 * x124 * x481,
            x127 * x24 * x480,
            x479 * x481 * x98,
            x3 * x482,
            x152 * x480 * x7,
            x127 * x481 * x7,
            x482 * x98,
            x315
            * (
                x0
                * (
                    2.0 * x368
                    + 2.0 * x369
                    + 3.0 * x465
                    + 3.0 * x466
                    + 3.0 * x473
                    + 3.0 * x474
                )
                + x174 * x477
            ),
        ]
    )


def quadrupole3d_44(a, A, b, B, C):
    """Cartesian 3D (gg) quadrupole moment integrals.
    The origin is at C.

    Generated code; DO NOT modify by hand!"""

    x0 = (2.0 * a + 2.0 * b) ** (-1.0)
    x1 = (a + b) ** (-1.0)
    x2 = -x1 * (a * A[0] + b * B[0])
    x3 = -x2 - B[0]
    x4 = a * b * x1
    x5 = numpy.exp(-x4 * (A[0] - B[0]) ** 2)
    x6 = 1.77245385090552 * numpy.sqrt(x1)
    x7 = x5 * x6
    x8 = x3 * x7
    x9 = -x2 - C[0]
    x10 = x7 * x9
    x11 = x0 * (x10 + x8)
    x12 = x0 * x7
    x13 = x8 * x9
    x14 = x12 + x13
    x15 = x14 * x3
    x16 = x11 + x15
    x17 = x16 * x3
    x18 = x3**2 * x7
    x19 = 3.0 * x12
    x20 = 2.0 * x13 + x19
    x21 = x0 * (x18 + x20)
    x22 = 4.0 * x21
    x23 = -x2 - A[0]
    x24 = x16 * x23
    x25 = x0 * (3.0 * x18 + x19)
    x26 = x12 + x18
    x27 = x26 * x3
    x28 = x12 * x3
    x29 = 2.0 * x28
    x30 = x27 + x29
    x31 = x23 * x30
    x32 = x25 + x31
    x33 = x0 * (x17 + x22 + 3.0 * x24 + x32)
    x34 = 3.0 * x11
    x35 = x0 * (3.0 * x15 + x30 + x34)
    x36 = x17 + x21
    x37 = x23 * x36
    x38 = x35 + x37
    x39 = x23 * x38
    x40 = x3 * x30
    x41 = x0 * (5.0 * x25 + 4.0 * x31 + x40)
    x42 = 8.0 * x28
    x43 = x0 * (4.0 * x27 + x42)
    x44 = x25 + x40
    x45 = x23 * x44
    x46 = x43 + x45
    x47 = x23 * x46
    x48 = x41 + x47
    x49 = x0 * (4.0 * x17 + x22 + x44)
    x50 = x3 * x36
    x51 = x35 + x50
    x52 = x23 * x51
    x53 = 2.0 * x49 + 2.0 * x52
    x54 = x0 * (4.0 * x33 + 4.0 * x39 + x48 + x53)
    x55 = x0 * (5.0 * x35 + 4.0 * x37 + x46 + x50)
    x56 = x49 + x52
    x57 = x23 * x56
    x58 = x55 + x57
    x59 = x23 * x58
    x60 = x7 * x9**2
    x61 = x12 + x60
    x62 = x3 * x61
    x63 = 2.0 * x11
    x64 = x12 * x9
    x65 = 4.0 * x64
    x66 = x63 + x65
    x67 = x0 * (2.0 * x15 + 2.0 * x62 + x66)
    x68 = x0 * (x20 + x60)
    x69 = 2.0 * x64
    x70 = x62 + x69
    x71 = x3 * x70
    x72 = x68 + x71
    x73 = x3 * x72
    x74 = x67 + x73
    x75 = x3 * x74
    x76 = x23 * x74
    x77 = 2.0 * x21
    x78 = 3.0 * x68 + x77
    x79 = x0 * (2.0 * x17 + 3.0 * x71 + x78)
    x80 = x0 * (x53 + x75 + 4.0 * x76 + 5.0 * x79)
    x81 = 2.0 * x35
    x82 = 4.0 * x67 + x81
    x83 = x0 * (2.0 * x50 + 4.0 * x73 + x82)
    x84 = x75 + x79
    x85 = x23 * x84
    x86 = x83 + x85
    x87 = x23 * x86
    x88 = 2.0 * x24
    x89 = x23 * x70
    x90 = 2.0 * x89
    x91 = x0 * (x71 + x78 + x88 + x90)
    x92 = x23 * x72
    x93 = x67 + x92
    x94 = x23 * x93
    x95 = 3.0 * x91 + 3.0 * x94
    x96 = x0 * (2.0 * x33 + 2.0 * x39 + 2.0 * x76 + 2.0 * x79 + x95)
    x97 = 2.0 * x37
    x98 = x0 * (x73 + x82 + 3.0 * x92 + x97)
    x99 = x76 + x79
    x100 = x23 * x99
    x101 = x100 + x98
    x102 = x101 * x23
    x103 = x80 + x87
    x104 = (
        x0 * (4.0 * x100 + 2.0 * x55 + 2.0 * x57 + 2.0 * x83 + 2.0 * x85 + 4.0 * x98)
        + x103 * x23
    )
    x105 = numpy.exp(-x4 * (A[1] - B[1]) ** 2)
    x106 = numpy.exp(-x4 * (A[2] - B[2]) ** 2)
    x107 = 3.14159265358979 * x1 * x106
    x108 = x105 * x107
    x109 = -x1 * (a * A[1] + b * B[1])
    x110 = -x109 - B[1]
    x111 = x23 * x26
    x112 = x0 * (3.0 * x111 + x27 + x42)
    x113 = x23 * x32
    x114 = x112 + x113
    x115 = x14 * x23
    x116 = 2.0 * x115
    x117 = x111 + x29
    x118 = x0 * (x116 + x117 + x15 + x34)
    x119 = x21 + x24
    x120 = x119 * x23
    x121 = 3.0 * x118 + 3.0 * x120
    x122 = x0 * (x114 + x121 + x81 + x97)
    x123 = x33 + x39
    x124 = x123 * x23
    x125 = x23 * x61
    x126 = x0 * (x116 + x125 + x62 + x66)
    x127 = x68 + x89
    x128 = x127 * x23
    x129 = x0 * (
        2.0 * x118 + 2.0 * x120 + 2.0 * x126 + 2.0 * x128 + 2.0 * x67 + 2.0 * x92
    )
    x130 = x91 + x94
    x131 = x130 * x23
    x132 = x102 + x96
    x133 = x108 * (
        x0 * (3.0 * x100 + 2.0 * x122 + 2.0 * x124 + 3.0 * x129 + 3.0 * x131 + 3.0 * x98)
        + x132 * x23
    )
    x134 = -x1 * (a * A[2] + b * B[2])
    x135 = -x134 - B[2]
    x136 = x105 * x6
    x137 = x110**2 * x136
    x138 = x0 * x136
    x139 = x137 + x138
    x140 = x23 * x8
    x141 = 2.0 * x140 + x19
    x142 = x0 * (x141 + x18)
    x143 = x117 * x23
    x144 = x142 + x143
    x145 = x10 * x23
    x146 = x0 * (x13 + x140 + x145 + x19)
    x147 = x11 + x115
    x148 = x147 * x23
    x149 = 2.0 * x146 + 2.0 * x148
    x150 = x0 * (x144 + x149 + x77 + x88)
    x151 = 2.0 * x145 + x19
    x152 = x0 * (x151 + x60)
    x153 = x125 + x69
    x154 = x153 * x23
    x155 = x152 + x154
    x156 = x0 * (x149 + x155 + 2.0 * x68 + x90)
    x157 = x118 + x120
    x158 = x157 * x23
    x159 = x126 + x128
    x160 = x159 * x23
    x161 = x129 + x131
    x162 = x0 * (2.0 * x150 + 2.0 * x156 + 2.0 * x158 + 2.0 * x160 + x95) + x161 * x23
    x163 = x106 * x6
    x164 = x108 * x135
    x165 = x135**2 * x163
    x166 = x0 * x163
    x167 = x165 + x166
    x168 = x110 * x139
    x169 = x110 * x138
    x170 = 2.0 * x169
    x171 = x168 + x170
    x172 = x23 * x7
    x173 = x0 * (x10 + x172)
    x174 = x12 + x145
    x175 = x174 * x23
    x176 = x0 * (2.0 * x125 + 2.0 * x173 + 2.0 * x175 + x65) + x155 * x23
    x177 = x173 + x175
    x178 = x0 * (x172 + x8)
    x179 = x12 + x140
    x180 = x179 * x23
    x181 = x178 + x180
    x182 = x0 * (x116 + x177 + x181 + x63)
    x183 = x146 + x148
    x184 = x183 * x23
    x185 = 2.0 * x182 + 2.0 * x184
    x186 = x156 + x160
    x187 = x0 * (3.0 * x126 + 3.0 * x128 + x176 + x185) + x186 * x23
    x188 = x135 * x163
    x189 = x110 * x136
    x190 = x135 * x167
    x191 = x135 * x166
    x192 = 2.0 * x191
    x193 = x190 + x192
    x194 = 3.0 * x138
    x195 = x0 * (3.0 * x137 + x194)
    x196 = x110 * x171
    x197 = x195 + x196
    x198 = x23**2 * x7
    x199 = x0 * (x151 + x198)
    x200 = x177 * x23
    x201 = x0 * (3.0 * x152 + 3.0 * x154 + 2.0 * x199 + 2.0 * x200) + x176 * x23
    x202 = 3.0 * x166
    x203 = x0 * (3.0 * x165 + x202)
    x204 = x135 * x193
    x205 = x203 + x204
    x206 = -x109 - A[1]
    x207 = x104 * x108
    x208 = x136 * x206
    x209 = x110 * x208
    x210 = x138 + x209
    x211 = x139 * x206
    x212 = x170 + x211
    x213 = x171 * x206
    x214 = x195 + x213
    x215 = 8.0 * x169
    x216 = x0 * (4.0 * x168 + x215)
    x217 = x197 * x206
    x218 = x216 + x217
    x219 = -x134 - A[2]
    x220 = x108 * x219
    x221 = x163 * x219
    x222 = x135 * x221
    x223 = x166 + x222
    x224 = x167 * x219
    x225 = x192 + x224
    x226 = x193 * x219
    x227 = x203 + x226
    x228 = 8.0 * x191
    x229 = x0 * (4.0 * x190 + x228)
    x230 = x205 * x219
    x231 = x229 + x230
    x232 = x136 * x206**2
    x233 = x138 + x232
    x234 = x0 * (x189 + x208)
    x235 = x206 * x210
    x236 = x234 + x235
    x237 = x194 + 2.0 * x209
    x238 = x0 * (x137 + x237)
    x239 = x206 * x212
    x240 = x238 + x239
    x241 = x0 * (x168 + 3.0 * x211 + x215)
    x242 = x206 * x214
    x243 = x241 + x242
    x244 = x0 * (5.0 * x195 + x196 + 4.0 * x213)
    x245 = x206 * x218
    x246 = x244 + x245
    x247 = x163 * x219**2
    x248 = x166 + x247
    x249 = x0 * (x188 + x221)
    x250 = x219 * x223
    x251 = x249 + x250
    x252 = x202 + 2.0 * x222
    x253 = x0 * (x165 + x252)
    x254 = x219 * x225
    x255 = x253 + x254
    x256 = x0 * (x190 + 3.0 * x224 + x228)
    x257 = x219 * x227
    x258 = x256 + x257
    x259 = x0 * (5.0 * x203 + x204 + 4.0 * x226)
    x260 = x219 * x231
    x261 = x259 + x260
    x262 = 2.0 * x138
    x263 = x206 * x233 + x206 * x262
    x264 = x0 * (x232 + x237)
    x265 = x206 * x236
    x266 = x264 + x265
    x267 = x0 * (4.0 * x169 + 2.0 * x211 + 2.0 * x234 + 2.0 * x235)
    x268 = x206 * x240
    x269 = x267 + x268
    x270 = 3.0 * x238 + 3.0 * x239
    x271 = x0 * (2.0 * x195 + 2.0 * x213 + x270)
    x272 = x206 * x243
    x273 = x271 + x272
    x274 = x0 * (2.0 * x216 + 2.0 * x217 + 4.0 * x241 + 4.0 * x242) + x206 * x246
    x275 = 2.0 * x166
    x276 = x219 * x248 + x219 * x275
    x277 = x0 * (x247 + x252)
    x278 = x219 * x251
    x279 = x277 + x278
    x280 = x0 * (4.0 * x191 + 2.0 * x224 + 2.0 * x249 + 2.0 * x250)
    x281 = x219 * x255
    x282 = x280 + x281
    x283 = 3.0 * x253 + 3.0 * x254
    x284 = x0 * (2.0 * x203 + 2.0 * x226 + x283)
    x285 = x219 * x258
    x286 = x284 + x285
    x287 = x0 * (2.0 * x229 + 2.0 * x230 + 4.0 * x256 + 4.0 * x257) + x219 * x261
    x288 = x0 * (x194 + 3.0 * x232) + x206 * x263
    x289 = x0 * (3.0 * x234 + 3.0 * x235 + x263) + x206 * x266
    x290 = x0 * (2.0 * x264 + 2.0 * x265 + x270) + x206 * x269
    x291 = x0 * (3.0 * x241 + 3.0 * x242 + 3.0 * x267 + 3.0 * x268) + x206 * x273
    x292 = x0 * (3.0 * x244 + 3.0 * x245 + 4.0 * x271 + 4.0 * x272) + x206 * x274
    x293 = x0 * (x202 + 3.0 * x247) + x219 * x276
    x294 = x0 * (3.0 * x249 + 3.0 * x250 + x276) + x219 * x279
    x295 = x0 * (2.0 * x277 + 2.0 * x278 + x283) + x219 * x282
    x296 = x0 * (3.0 * x256 + 3.0 * x257 + 3.0 * x280 + 3.0 * x281) + x219 * x286
    x297 = x0 * (3.0 * x259 + 3.0 * x260 + 4.0 * x284 + 4.0 * x285) + x219 * x287
    x298 = -x109 - C[1]
    x299 = x0 * (4.0 * x112 + 4.0 * x113 + 2.0 * x43 + 2.0 * x45) + x23 * x48
    x300 = x54 + x59
    x301 = x108 * (
        x0 * (4.0 * x122 + 4.0 * x124 + x299 + 3.0 * x55 + 3.0 * x57) + x23 * x300
    )
    x302 = x189 * x298
    x303 = x138 + x302
    x304 = 3.0 * x142 + 3.0 * x143
    x305 = x0 * (2.0 * x25 + x304 + 2.0 * x31)
    x306 = x114 * x23
    x307 = x305 + x306
    x308 = x122 + x124
    x309 = x0 * (3.0 * x150 + 3.0 * x158 + x307 + 3.0 * x33 + 3.0 * x39) + x23 * x308
    x310 = x136 * x298
    x311 = x0 * (x189 + x310)
    x312 = x110 * x303
    x313 = x311 + x312
    x314 = x0 * (2.0 * x111 + 2.0 * x178 + 2.0 * x180 + 4.0 * x28)
    x315 = x144 * x23
    x316 = x314 + x315
    x317 = x150 + x158
    x318 = x0 * (x121 + x185 + x316) + x23 * x317
    x319 = x194 + 2.0 * x302
    x320 = x0 * (x137 + x319)
    x321 = x110 * x313
    x322 = x320 + x321
    x323 = x199 + x200
    x324 = x0 * (x141 + x198)
    x325 = x181 * x23
    x326 = x324 + x325
    x327 = x182 + x184
    x328 = x0 * (3.0 * x146 + 3.0 * x148 + x323 + x326) + x23 * x327
    x329 = 3.0 * x311
    x330 = x0 * (x171 + 3.0 * x312 + x329)
    x331 = x110 * x322
    x332 = x330 + x331
    x333 = x12 + x198
    x334 = 2.0 * x12 * x23 + x23 * x333
    x335 = x0 * (3.0 * x173 + 3.0 * x175 + x334) + x23 * x323
    x336 = x208 * x298
    x337 = x138 + x336
    x338 = x206 * x303
    x339 = x311 + x338
    x340 = x206 * x313
    x341 = x320 + x340
    x342 = x206 * x322
    x343 = x330 + x342
    x344 = 4.0 * x320
    x345 = x0 * (x197 + 4.0 * x321 + x344)
    x346 = x206 * x332
    x347 = x345 + x346
    x348 = x0 * (x208 + x310)
    x349 = x206 * x337
    x350 = x348 + x349
    x351 = x0 * (x194 + x209 + x302 + x336)
    x352 = x206 * x339
    x353 = x351 + x352
    x354 = 2.0 * x338
    x355 = x0 * (x212 + x312 + x329 + x354)
    x356 = x206 * x341
    x357 = x355 + x356
    x358 = x0 * (x214 + x321 + 3.0 * x340 + x344)
    x359 = x206 * x343
    x360 = x358 + x359
    x361 = x0 * (x218 + 5.0 * x330 + x331 + 4.0 * x342)
    x362 = x206 * x347
    x363 = x361 + x362
    x364 = x194 + 2.0 * x336
    x365 = x0 * (x232 + x364)
    x366 = x206 * x350
    x367 = x365 + x366
    x368 = 2.0 * x311
    x369 = x0 * (x236 + x350 + x354 + x368)
    x370 = x206 * x353
    x371 = x369 + x370
    x372 = 2.0 * x320
    x373 = 2.0 * x340
    x374 = 2.0 * x351 + 2.0 * x352
    x375 = x0 * (x240 + x372 + x373 + x374)
    x376 = x206 * x357
    x377 = x375 + x376
    x378 = 2.0 * x330
    x379 = 2.0 * x342
    x380 = 3.0 * x355 + 3.0 * x356
    x381 = x0 * (x243 + x378 + x379 + x380)
    x382 = x206 * x360
    x383 = x381 + x382
    x384 = 2.0 * x345 + 2.0 * x346
    x385 = x0 * (x246 + 4.0 * x358 + 4.0 * x359 + x384)
    x386 = x206 * x363
    x387 = x385 + x386
    x388 = x0 * (x263 + 3.0 * x348 + 3.0 * x349) + x206 * x367
    x389 = x0 * (x266 + 3.0 * x351 + 3.0 * x352 + x367) + x206 * x371
    x390 = 2.0 * x369 + 2.0 * x370
    x391 = x0 * (x269 + x380 + x390) + x206 * x377
    x392 = x0 * (x273 + 3.0 * x358 + 3.0 * x359 + 3.0 * x375 + 3.0 * x376) + x206 * x383
    x393 = x107 * x5
    x394 = x393 * (
        x0 * (x274 + 3.0 * x361 + 3.0 * x362 + 4.0 * x381 + 4.0 * x382) + x206 * x387
    )
    x395 = x393 * x9
    x396 = 3.14159265358979 * x1 * x105 * x5
    x397 = x396 * x9
    x398 = -x134 - C[2]
    x399 = x108 * x398
    x400 = x188 * x398
    x401 = x166 + x400
    x402 = x163 * x398
    x403 = x0 * (x188 + x402)
    x404 = x135 * x401
    x405 = x403 + x404
    x406 = x202 + 2.0 * x400
    x407 = x0 * (x165 + x406)
    x408 = x135 * x405
    x409 = x407 + x408
    x410 = 3.0 * x403
    x411 = x0 * (x193 + 3.0 * x404 + x410)
    x412 = x135 * x409
    x413 = x411 + x412
    x414 = x221 * x398
    x415 = x166 + x414
    x416 = x219 * x401
    x417 = x403 + x416
    x418 = x219 * x405
    x419 = x407 + x418
    x420 = x219 * x409
    x421 = x411 + x420
    x422 = 4.0 * x407
    x423 = x0 * (x205 + 4.0 * x408 + x422)
    x424 = x219 * x413
    x425 = x423 + x424
    x426 = x0 * (x221 + x402)
    x427 = x219 * x415
    x428 = x426 + x427
    x429 = x0 * (x202 + x222 + x400 + x414)
    x430 = x219 * x417
    x431 = x429 + x430
    x432 = 2.0 * x416
    x433 = x0 * (x225 + x404 + x410 + x432)
    x434 = x219 * x419
    x435 = x433 + x434
    x436 = x0 * (x227 + x408 + 3.0 * x418 + x422)
    x437 = x219 * x421
    x438 = x436 + x437
    x439 = x0 * (x231 + 5.0 * x411 + x412 + 4.0 * x420)
    x440 = x219 * x425
    x441 = x439 + x440
    x442 = x202 + 2.0 * x414
    x443 = x0 * (x247 + x442)
    x444 = x219 * x428
    x445 = x443 + x444
    x446 = 2.0 * x403
    x447 = x0 * (x251 + x428 + x432 + x446)
    x448 = x219 * x431
    x449 = x447 + x448
    x450 = 2.0 * x407
    x451 = 2.0 * x418
    x452 = 2.0 * x429 + 2.0 * x430
    x453 = x0 * (x255 + x450 + x451 + x452)
    x454 = x219 * x435
    x455 = x453 + x454
    x456 = 2.0 * x411
    x457 = 2.0 * x420
    x458 = 3.0 * x433 + 3.0 * x434
    x459 = x0 * (x258 + x456 + x457 + x458)
    x460 = x219 * x438
    x461 = x459 + x460
    x462 = 2.0 * x423 + 2.0 * x424
    x463 = x0 * (x261 + 4.0 * x436 + 4.0 * x437 + x462)
    x464 = x219 * x441
    x465 = x463 + x464
    x466 = x0 * (x276 + 3.0 * x426 + 3.0 * x427) + x219 * x445
    x467 = x0 * (x279 + 3.0 * x429 + 3.0 * x430 + x445) + x219 * x449
    x468 = 2.0 * x447 + 2.0 * x448
    x469 = x0 * (x282 + x458 + x468) + x219 * x455
    x470 = x0 * (x286 + 3.0 * x436 + 3.0 * x437 + 3.0 * x453 + 3.0 * x454) + x219 * x461
    x471 = x396 * (
        x0 * (x287 + 3.0 * x439 + 3.0 * x440 + 4.0 * x459 + 4.0 * x460) + x219 * x465
    )
    x472 = x136 * x298**2
    x473 = x138 + x472
    x474 = x0 * (4.0 * x305 + 4.0 * x306 + 3.0 * x41 + 3.0 * x47) + x23 * x299
    x475 = x110 * x473
    x476 = x262 * x298
    x477 = x475 + x476
    x478 = x0 * (3.0 * x112 + 3.0 * x113 + 3.0 * x314 + 3.0 * x315) + x23 * x307
    x479 = x0 * (x319 + x472)
    x480 = x110 * x477
    x481 = x479 + x480
    x482 = x0 * (x304 + 2.0 * x324 + 2.0 * x325) + x23 * x316
    x483 = 4.0 * x138 * x298
    x484 = x368 + x483
    x485 = x0 * (2.0 * x312 + 2.0 * x475 + x484)
    x486 = x110 * x481
    x487 = x485 + x486
    x488 = x0 * (3.0 * x178 + 3.0 * x180 + x334) + x23 * x326
    x489 = x372 + 3.0 * x479
    x490 = x0 * (2.0 * x321 + 3.0 * x480 + x489)
    x491 = x110 * x487
    x492 = x490 + x491
    x493 = x0 * (x19 + 3.0 * x198) + x23 * x334
    x494 = x206 * x473
    x495 = x476 + x494
    x496 = x206 * x477
    x497 = x479 + x496
    x498 = x206 * x481
    x499 = x485 + x498
    x500 = x206 * x487
    x501 = x490 + x500
    x502 = x378 + 4.0 * x485
    x503 = x0 * (2.0 * x331 + 4.0 * x486 + x502)
    x504 = x206 * x492
    x505 = x503 + x504
    x506 = x0 * (x364 + x472)
    x507 = x206 * x495
    x508 = x506 + x507
    x509 = x0 * (x354 + x475 + x484 + x494)
    x510 = x206 * x497
    x511 = x509 + x510
    x512 = 2.0 * x496
    x513 = x0 * (x373 + x480 + x489 + x512)
    x514 = x206 * x499
    x515 = x513 + x514
    x516 = x0 * (x379 + x486 + 3.0 * x498 + x502)
    x517 = x206 * x501
    x518 = x516 + x517
    x519 = x0 * (x384 + 5.0 * x490 + x491 + 4.0 * x500)
    x520 = x206 * x505
    x521 = x519 + x520
    x522 = x0 * (2.0 * x348 + 2.0 * x349 + x483 + 2.0 * x494) + x206 * x508
    x523 = x0 * (x374 + 2.0 * x479 + x508 + x512)
    x524 = x206 * x511
    x525 = x523 + x524
    x526 = x0 * (
        2.0 * x355 + 2.0 * x356 + 2.0 * x485 + 2.0 * x498 + 2.0 * x509 + 2.0 * x510
    )
    x527 = x206 * x515
    x528 = x526 + x527
    x529 = 3.0 * x513 + 3.0 * x514
    x530 = x0 * (2.0 * x358 + 2.0 * x359 + 2.0 * x490 + 2.0 * x500 + x529)
    x531 = x206 * x518
    x532 = x530 + x531
    x533 = (
        x0 * (2.0 * x361 + 2.0 * x362 + 2.0 * x503 + 2.0 * x504 + 4.0 * x516 + 4.0 * x517)
        + x206 * x521
    )
    x534 = x393 * x533
    x535 = x23 * x393
    x536 = x0 * (2.0 * x365 + 2.0 * x366 + 3.0 * x506 + 3.0 * x507) + x206 * x522
    x537 = x0 * (x390 + 3.0 * x509 + 3.0 * x510 + x522) + x206 * x525
    x538 = x0 * (2.0 * x375 + 2.0 * x376 + 2.0 * x523 + 2.0 * x524 + x529) + x206 * x528
    x539 = x393 * (
        x0 * (2.0 * x381 + 2.0 * x382 + 3.0 * x516 + 3.0 * x517 + 3.0 * x526 + 3.0 * x527)
        + x206 * x532
    )
    x540 = x3 * x393
    x541 = x298 * x396
    x542 = x163 * x398**2
    x543 = x166 + x542
    x544 = x135 * x543
    x545 = x275 * x398
    x546 = x544 + x545
    x547 = x0 * (x406 + x542)
    x548 = x135 * x546
    x549 = x547 + x548
    x550 = 4.0 * x166 * x398
    x551 = x446 + x550
    x552 = x0 * (2.0 * x404 + 2.0 * x544 + x551)
    x553 = x135 * x549
    x554 = x552 + x553
    x555 = x450 + 3.0 * x547
    x556 = x0 * (2.0 * x408 + 3.0 * x548 + x555)
    x557 = x135 * x554
    x558 = x556 + x557
    x559 = x219 * x543
    x560 = x545 + x559
    x561 = x219 * x546
    x562 = x547 + x561
    x563 = x219 * x549
    x564 = x552 + x563
    x565 = x219 * x554
    x566 = x556 + x565
    x567 = x456 + 4.0 * x552
    x568 = x0 * (2.0 * x412 + 4.0 * x553 + x567)
    x569 = x219 * x558
    x570 = x568 + x569
    x571 = x0 * (x442 + x542)
    x572 = x219 * x560
    x573 = x571 + x572
    x574 = x0 * (x432 + x544 + x551 + x559)
    x575 = x219 * x562
    x576 = x574 + x575
    x577 = 2.0 * x561
    x578 = x0 * (x451 + x548 + x555 + x577)
    x579 = x219 * x564
    x580 = x578 + x579
    x581 = x0 * (x457 + x553 + 3.0 * x563 + x567)
    x582 = x219 * x566
    x583 = x581 + x582
    x584 = x0 * (x462 + 5.0 * x556 + x557 + 4.0 * x565)
    x585 = x219 * x570
    x586 = x584 + x585
    x587 = x23 * x396
    x588 = x0 * (2.0 * x426 + 2.0 * x427 + x550 + 2.0 * x559) + x219 * x573
    x589 = x0 * (x452 + 2.0 * x547 + x573 + x577)
    x590 = x219 * x576
    x591 = x589 + x590
    x592 = x0 * (
        2.0 * x433 + 2.0 * x434 + 2.0 * x552 + 2.0 * x563 + 2.0 * x574 + 2.0 * x575
    )
    x593 = x219 * x580
    x594 = x592 + x593
    x595 = 3.0 * x578 + 3.0 * x579
    x596 = x0 * (2.0 * x436 + 2.0 * x437 + 2.0 * x556 + 2.0 * x565 + x595)
    x597 = x219 * x583
    x598 = x596 + x597
    x599 = (
        x0 * (2.0 * x439 + 2.0 * x440 + 2.0 * x568 + 2.0 * x569 + 4.0 * x581 + 4.0 * x582)
        + x219 * x586
    )
    x600 = x396 * x599
    x601 = x3 * x396
    x602 = x0 * (2.0 * x443 + 2.0 * x444 + 3.0 * x571 + 3.0 * x572) + x219 * x588
    x603 = x0 * (x468 + 3.0 * x574 + 3.0 * x575 + x588) + x219 * x591
    x604 = x0 * (2.0 * x453 + 2.0 * x454 + 2.0 * x589 + 2.0 * x590 + x595) + x219 * x594
    x605 = x396 * (
        x0 * (2.0 * x459 + 2.0 * x460 + 3.0 * x581 + 3.0 * x582 + 3.0 * x592 + 3.0 * x593)
        + x219 * x598
    )

    # 1350 item(s)
    return numpy.array(
        [
            x108
            * (
                x0
                * (4.0 * x102 + 2.0 * x54 + 2.0 * x59 + 3.0 * x80 + 3.0 * x87 + 4.0 * x96)
                + x104 * x23
            ),
            x110 * x133,
            x133 * x135,
            x139 * x162 * x163,
            x110 * x162 * x164,
            x136 * x162 * x167,
            x163 * x171 * x187,
            x139 * x187 * x188,
            x167 * x187 * x189,
            x136 * x187 * x193,
            x163 * x197 * x201,
            x171 * x188 * x201,
            x139 * x167 * x201,
            x189 * x193 * x201,
            x136 * x201 * x205,
            x206 * x207,
            x132 * x163 * x210,
            x132 * x164 * x206,
            x161 * x163 * x212,
            x161 * x188 * x210,
            x161 * x167 * x208,
            x163 * x186 * x214,
            x186 * x188 * x212,
            x167 * x186 * x210,
            x186 * x193 * x208,
            x163 * x176 * x218,
            x176 * x188 * x214,
            x167 * x176 * x212,
            x176 * x193 * x210,
            x176 * x205 * x208,
            x207 * x219,
            x110 * x132 * x220,
            x132 * x136 * x223,
            x139 * x161 * x221,
            x161 * x189 * x223,
            x136 * x161 * x225,
            x171 * x186 * x221,
            x139 * x186 * x223,
            x186 * x189 * x225,
            x136 * x186 * x227,
            x176 * x197 * x221,
            x171 * x176 * x223,
            x139 * x176 * x225,
            x176 * x189 * x227,
            x136 * x176 * x231,
            x103 * x163 * x233,
            x101 * x163 * x236,
            x101 * x188 * x233,
            x130 * x163 * x240,
            x130 * x188 * x236,
            x130 * x167 * x233,
            x159 * x163 * x243,
            x159 * x188 * x240,
            x159 * x167 * x236,
            x159 * x193 * x233,
            x155 * x163 * x246,
            x155 * x188 * x243,
            x155 * x167 * x240,
            x155 * x193 * x236,
            x155 * x205 * x233,
            x103 * x206 * x220,
            x101 * x210 * x221,
            x101 * x208 * x223,
            x130 * x212 * x221,
            x130 * x210 * x223,
            x130 * x208 * x225,
            x159 * x214 * x221,
            x159 * x212 * x223,
            x159 * x210 * x225,
            x159 * x208 * x227,
            x155 * x218 * x221,
            x155 * x214 * x223,
            x155 * x212 * x225,
            x155 * x210 * x227,
            x155 * x208 * x231,
            x103 * x136 * x248,
            x101 * x189 * x248,
            x101 * x136 * x251,
            x130 * x139 * x248,
            x130 * x189 * x251,
            x130 * x136 * x255,
            x159 * x171 * x248,
            x139 * x159 * x251,
            x159 * x189 * x255,
            x136 * x159 * x258,
            x155 * x197 * x248,
            x155 * x171 * x251,
            x139 * x155 * x255,
            x155 * x189 * x258,
            x136 * x155 * x261,
            x163 * x263 * x86,
            x163 * x266 * x99,
            x188 * x263 * x99,
            x163 * x269 * x93,
            x188 * x266 * x93,
            x167 * x263 * x93,
            x127 * x163 * x273,
            x127 * x188 * x269,
            x127 * x167 * x266,
            x127 * x193 * x263,
            x153 * x163 * x274,
            x153 * x188 * x273,
            x153 * x167 * x269,
            x153 * x193 * x266,
            x153 * x205 * x263,
            x221 * x233 * x86,
            x221 * x236 * x99,
            x223 * x233 * x99,
            x221 * x240 * x93,
            x223 * x236 * x93,
            x225 * x233 * x93,
            x127 * x221 * x243,
            x127 * x223 * x240,
            x127 * x225 * x236,
            x127 * x227 * x233,
            x153 * x221 * x246,
            x153 * x223 * x243,
            x153 * x225 * x240,
            x153 * x227 * x236,
            x153 * x231 * x233,
            x208 * x248 * x86,
            x210 * x248 * x99,
            x208 * x251 * x99,
            x212 * x248 * x93,
            x210 * x251 * x93,
            x208 * x255 * x93,
            x127 * x214 * x248,
            x127 * x212 * x251,
            x127 * x210 * x255,
            x127 * x208 * x258,
            x153 * x218 * x248,
            x153 * x214 * x251,
            x153 * x212 * x255,
            x153 * x210 * x258,
            x153 * x208 * x261,
            x136 * x276 * x86,
            x189 * x276 * x99,
            x136 * x279 * x99,
            x139 * x276 * x93,
            x189 * x279 * x93,
            x136 * x282 * x93,
            x127 * x171 * x276,
            x127 * x139 * x279,
            x127 * x189 * x282,
            x127 * x136 * x286,
            x153 * x197 * x276,
            x153 * x171 * x279,
            x139 * x153 * x282,
            x153 * x189 * x286,
            x136 * x153 * x287,
            x163 * x288 * x84,
            x163 * x289 * x74,
            x188 * x288 * x74,
            x163 * x290 * x72,
            x188 * x289 * x72,
            x167 * x288 * x72,
            x163 * x291 * x70,
            x188 * x290 * x70,
            x167 * x289 * x70,
            x193 * x288 * x70,
            x163 * x292 * x61,
            x188 * x291 * x61,
            x167 * x290 * x61,
            x193 * x289 * x61,
            x205 * x288 * x61,
            x221 * x263 * x84,
            x221 * x266 * x74,
            x223 * x263 * x74,
            x221 * x269 * x72,
            x223 * x266 * x72,
            x225 * x263 * x72,
            x221 * x273 * x70,
            x223 * x269 * x70,
            x225 * x266 * x70,
            x227 * x263 * x70,
            x221 * x274 * x61,
            x223 * x273 * x61,
            x225 * x269 * x61,
            x227 * x266 * x61,
            x231 * x263 * x61,
            x233 * x248 * x84,
            x236 * x248 * x74,
            x233 * x251 * x74,
            x240 * x248 * x72,
            x236 * x251 * x72,
            x233 * x255 * x72,
            x243 * x248 * x70,
            x240 * x251 * x70,
            x236 * x255 * x70,
            x233 * x258 * x70,
            x246 * x248 * x61,
            x243 * x251 * x61,
            x240 * x255 * x61,
            x236 * x258 * x61,
            x233 * x261 * x61,
            x208 * x276 * x84,
            x210 * x276 * x74,
            x208 * x279 * x74,
            x212 * x276 * x72,
            x210 * x279 * x72,
            x208 * x282 * x72,
            x214 * x276 * x70,
            x212 * x279 * x70,
            x210 * x282 * x70,
            x208 * x286 * x70,
            x218 * x276 * x61,
            x214 * x279 * x61,
            x212 * x282 * x61,
            x210 * x286 * x61,
            x208 * x287 * x61,
            x136 * x293 * x84,
            x189 * x293 * x74,
            x136 * x294 * x74,
            x139 * x293 * x72,
            x189 * x294 * x72,
            x136 * x295 * x72,
            x171 * x293 * x70,
            x139 * x294 * x70,
            x189 * x295 * x70,
            x136 * x296 * x70,
            x197 * x293 * x61,
            x171 * x294 * x61,
            x139 * x295 * x61,
            x189 * x296 * x61,
            x136 * x297 * x61,
            x298 * x301,
            x163 * x303 * x309,
            x164 * x298 * x309,
            x163 * x313 * x318,
            x188 * x303 * x318,
            x167 * x310 * x318,
            x163 * x322 * x328,
            x188 * x313 * x328,
            x167 * x303 * x328,
            x193 * x310 * x328,
            x163 * x332 * x335,
            x188 * x322 * x335,
            x167 * x313 * x335,
            x193 * x303 * x335,
            x205 * x310 * x335,
            x163 * x300 * x337,
            x163 * x308 * x339,
            x188 * x308 * x337,
            x163 * x317 * x341,
            x188 * x317 * x339,
            x167 * x317 * x337,
            x163 * x327 * x343,
            x188 * x327 * x341,
            x167 * x327 * x339,
            x193 * x327 * x337,
            x163 * x323 * x347,
            x188 * x323 * x343,
            x167 * x323 * x341,
            x193 * x323 * x339,
            x205 * x323 * x337,
            x220 * x298 * x300,
            x221 * x303 * x308,
            x223 * x308 * x310,
            x221 * x313 * x317,
            x223 * x303 * x317,
            x225 * x310 * x317,
            x221 * x322 * x327,
            x223 * x313 * x327,
            x225 * x303 * x327,
            x227 * x310 * x327,
            x221 * x323 * x332,
            x223 * x322 * x323,
            x225 * x313 * x323,
            x227 * x303 * x323,
            x231 * x310 * x323,
            x163 * x350 * x58,
            x123 * x163 * x353,
            x123 * x188 * x350,
            x157 * x163 * x357,
            x157 * x188 * x353,
            x157 * x167 * x350,
            x163 * x183 * x360,
            x183 * x188 * x357,
            x167 * x183 * x353,
            x183 * x193 * x350,
            x163 * x177 * x363,
            x177 * x188 * x360,
            x167 * x177 * x357,
            x177 * x193 * x353,
            x177 * x205 * x350,
            x221 * x337 * x58,
            x123 * x221 * x339,
            x123 * x223 * x337,
            x157 * x221 * x341,
            x157 * x223 * x339,
            x157 * x225 * x337,
            x183 * x221 * x343,
            x183 * x223 * x341,
            x183 * x225 * x339,
            x183 * x227 * x337,
            x177 * x221 * x347,
            x177 * x223 * x343,
            x177 * x225 * x341,
            x177 * x227 * x339,
            x177 * x231 * x337,
            x248 * x310 * x58,
            x123 * x248 * x303,
            x123 * x251 * x310,
            x157 * x248 * x313,
            x157 * x251 * x303,
            x157 * x255 * x310,
            x183 * x248 * x322,
            x183 * x251 * x313,
            x183 * x255 * x303,
            x183 * x258 * x310,
            x177 * x248 * x332,
            x177 * x251 * x322,
            x177 * x255 * x313,
            x177 * x258 * x303,
            x177 * x261 * x310,
            x163 * x367 * x56,
            x163 * x371 * x38,
            x188 * x367 * x38,
            x119 * x163 * x377,
            x119 * x188 * x371,
            x119 * x167 * x367,
            x147 * x163 * x383,
            x147 * x188 * x377,
            x147 * x167 * x371,
            x147 * x193 * x367,
            x163 * x174 * x387,
            x174 * x188 * x383,
            x167 * x174 * x377,
            x174 * x193 * x371,
            x174 * x205 * x367,
            x221 * x350 * x56,
            x221 * x353 * x38,
            x223 * x350 * x38,
            x119 * x221 * x357,
            x119 * x223 * x353,
            x119 * x225 * x350,
            x147 * x221 * x360,
            x147 * x223 * x357,
            x147 * x225 * x353,
            x147 * x227 * x350,
            x174 * x221 * x363,
            x174 * x223 * x360,
            x174 * x225 * x357,
            x174 * x227 * x353,
            x174 * x231 * x350,
            x248 * x337 * x56,
            x248 * x339 * x38,
            x251 * x337 * x38,
            x119 * x248 * x341,
            x119 * x251 * x339,
            x119 * x255 * x337,
            x147 * x248 * x343,
            x147 * x251 * x341,
            x147 * x255 * x339,
            x147 * x258 * x337,
            x174 * x248 * x347,
            x174 * x251 * x343,
            x174 * x255 * x341,
            x174 * x258 * x339,
            x174 * x261 * x337,
            x276 * x310 * x56,
            x276 * x303 * x38,
            x279 * x310 * x38,
            x119 * x276 * x313,
            x119 * x279 * x303,
            x119 * x282 * x310,
            x147 * x276 * x322,
            x147 * x279 * x313,
            x147 * x282 * x303,
            x147 * x286 * x310,
            x174 * x276 * x332,
            x174 * x279 * x322,
            x174 * x282 * x313,
            x174 * x286 * x303,
            x174 * x287 * x310,
            x163 * x388 * x51,
            x163 * x36 * x389,
            x188 * x36 * x388,
            x16 * x163 * x391,
            x16 * x188 * x389,
            x16 * x167 * x388,
            x14 * x163 * x392,
            x14 * x188 * x391,
            x14 * x167 * x389,
            x14 * x193 * x388,
            x394 * x9,
            x135 * x392 * x395,
            x10 * x167 * x391,
            x10 * x193 * x389,
            x10 * x205 * x388,
            x221 * x367 * x51,
            x221 * x36 * x371,
            x223 * x36 * x367,
            x16 * x221 * x377,
            x16 * x223 * x371,
            x16 * x225 * x367,
            x14 * x221 * x383,
            x14 * x223 * x377,
            x14 * x225 * x371,
            x14 * x227 * x367,
            x219 * x387 * x395,
            x10 * x223 * x383,
            x10 * x225 * x377,
            x10 * x227 * x371,
            x10 * x231 * x367,
            x248 * x350 * x51,
            x248 * x353 * x36,
            x251 * x350 * x36,
            x16 * x248 * x357,
            x16 * x251 * x353,
            x16 * x255 * x350,
            x14 * x248 * x360,
            x14 * x251 * x357,
            x14 * x255 * x353,
            x14 * x258 * x350,
            x10 * x248 * x363,
            x10 * x251 * x360,
            x10 * x255 * x357,
            x10 * x258 * x353,
            x10 * x261 * x350,
            x276 * x337 * x51,
            x276 * x339 * x36,
            x279 * x337 * x36,
            x16 * x276 * x341,
            x16 * x279 * x339,
            x16 * x282 * x337,
            x14 * x276 * x343,
            x14 * x279 * x341,
            x14 * x282 * x339,
            x14 * x286 * x337,
            x10 * x276 * x347,
            x10 * x279 * x343,
            x10 * x282 * x341,
            x10 * x286 * x339,
            x10 * x287 * x337,
            x293 * x310 * x51,
            x293 * x303 * x36,
            x294 * x310 * x36,
            x16 * x293 * x313,
            x16 * x294 * x303,
            x16 * x295 * x310,
            x14 * x293 * x322,
            x14 * x294 * x313,
            x14 * x295 * x303,
            x14 * x296 * x310,
            x10 * x293 * x332,
            x10 * x294 * x322,
            x10 * x295 * x313,
            x10 * x296 * x303,
            x297 * x298 * x397,
            x301 * x398,
            x110 * x309 * x399,
            x136 * x309 * x401,
            x139 * x318 * x402,
            x189 * x318 * x401,
            x136 * x318 * x405,
            x171 * x328 * x402,
            x139 * x328 * x401,
            x189 * x328 * x405,
            x136 * x328 * x409,
            x197 * x335 * x402,
            x171 * x335 * x401,
            x139 * x335 * x405,
            x189 * x335 * x409,
            x136 * x335 * x413,
            x206 * x300 * x399,
            x210 * x308 * x402,
            x208 * x308 * x401,
            x212 * x317 * x402,
            x210 * x317 * x401,
            x208 * x317 * x405,
            x214 * x327 * x402,
            x212 * x327 * x401,
            x210 * x327 * x405,
            x208 * x327 * x409,
            x218 * x323 * x402,
            x214 * x323 * x401,
            x212 * x323 * x405,
            x210 * x323 * x409,
            x208 * x323 * x413,
            x136 * x300 * x415,
            x189 * x308 * x415,
            x136 * x308 * x417,
            x139 * x317 * x415,
            x189 * x317 * x417,
            x136 * x317 * x419,
            x171 * x327 * x415,
            x139 * x327 * x417,
            x189 * x327 * x419,
            x136 * x327 * x421,
            x197 * x323 * x415,
            x171 * x323 * x417,
            x139 * x323 * x419,
            x189 * x323 * x421,
            x136 * x323 * x425,
            x233 * x402 * x58,
            x123 * x236 * x402,
            x123 * x233 * x401,
            x157 * x240 * x402,
            x157 * x236 * x401,
            x157 * x233 * x405,
            x183 * x243 * x402,
            x183 * x240 * x401,
            x183 * x236 * x405,
            x183 * x233 * x409,
            x177 * x246 * x402,
            x177 * x243 * x401,
            x177 * x240 * x405,
            x177 * x236 * x409,
            x177 * x233 * x413,
            x208 * x415 * x58,
            x123 * x210 * x415,
            x123 * x208 * x417,
            x157 * x212 * x415,
            x157 * x210 * x417,
            x157 * x208 * x419,
            x183 * x214 * x415,
            x183 * x212 * x417,
            x183 * x210 * x419,
            x183 * x208 * x421,
            x177 * x218 * x415,
            x177 * x214 * x417,
            x177 * x212 * x419,
            x177 * x210 * x421,
            x177 * x208 * x425,
            x136 * x428 * x58,
            x123 * x189 * x428,
            x123 * x136 * x431,
            x139 * x157 * x428,
            x157 * x189 * x431,
            x136 * x157 * x435,
            x171 * x183 * x428,
            x139 * x183 * x431,
            x183 * x189 * x435,
            x136 * x183 * x438,
            x177 * x197 * x428,
            x171 * x177 * x431,
            x139 * x177 * x435,
            x177 * x189 * x438,
            x136 * x177 * x441,
            x263 * x402 * x56,
            x266 * x38 * x402,
            x263 * x38 * x401,
            x119 * x269 * x402,
            x119 * x266 * x401,
            x119 * x263 * x405,
            x147 * x273 * x402,
            x147 * x269 * x401,
            x147 * x266 * x405,
            x147 * x263 * x409,
            x174 * x274 * x402,
            x174 * x273 * x401,
            x174 * x269 * x405,
            x174 * x266 * x409,
            x174 * x263 * x413,
            x233 * x415 * x56,
            x236 * x38 * x415,
            x233 * x38 * x417,
            x119 * x240 * x415,
            x119 * x236 * x417,
            x119 * x233 * x419,
            x147 * x243 * x415,
            x147 * x240 * x417,
            x147 * x236 * x419,
            x147 * x233 * x421,
            x174 * x246 * x415,
            x174 * x243 * x417,
            x174 * x240 * x419,
            x174 * x236 * x421,
            x174 * x233 * x425,
            x208 * x428 * x56,
            x210 * x38 * x428,
            x208 * x38 * x431,
            x119 * x212 * x428,
            x119 * x210 * x431,
            x119 * x208 * x435,
            x147 * x214 * x428,
            x147 * x212 * x431,
            x147 * x210 * x435,
            x147 * x208 * x438,
            x174 * x218 * x428,
            x174 * x214 * x431,
            x174 * x212 * x435,
            x174 * x210 * x438,
            x174 * x208 * x441,
            x136 * x445 * x56,
            x189 * x38 * x445,
            x136 * x38 * x449,
            x119 * x139 * x445,
            x119 * x189 * x449,
            x119 * x136 * x455,
            x147 * x171 * x445,
            x139 * x147 * x449,
            x147 * x189 * x455,
            x136 * x147 * x461,
            x174 * x197 * x445,
            x171 * x174 * x449,
            x139 * x174 * x455,
            x174 * x189 * x461,
            x136 * x174 * x465,
            x288 * x402 * x51,
            x289 * x36 * x402,
            x288 * x36 * x401,
            x16 * x290 * x402,
            x16 * x289 * x401,
            x16 * x288 * x405,
            x14 * x291 * x402,
            x14 * x290 * x401,
            x14 * x289 * x405,
            x14 * x288 * x409,
            x292 * x395 * x398,
            x10 * x291 * x401,
            x10 * x290 * x405,
            x10 * x289 * x409,
            x10 * x288 * x413,
            x263 * x415 * x51,
            x266 * x36 * x415,
            x263 * x36 * x417,
            x16 * x269 * x415,
            x16 * x266 * x417,
            x16 * x263 * x419,
            x14 * x273 * x415,
            x14 * x269 * x417,
            x14 * x266 * x419,
            x14 * x263 * x421,
            x10 * x274 * x415,
            x10 * x273 * x417,
            x10 * x269 * x419,
            x10 * x266 * x421,
            x10 * x263 * x425,
            x233 * x428 * x51,
            x236 * x36 * x428,
            x233 * x36 * x431,
            x16 * x240 * x428,
            x16 * x236 * x431,
            x16 * x233 * x435,
            x14 * x243 * x428,
            x14 * x240 * x431,
            x14 * x236 * x435,
            x14 * x233 * x438,
            x10 * x246 * x428,
            x10 * x243 * x431,
            x10 * x240 * x435,
            x10 * x236 * x438,
            x10 * x233 * x441,
            x208 * x445 * x51,
            x210 * x36 * x445,
            x208 * x36 * x449,
            x16 * x212 * x445,
            x16 * x210 * x449,
            x16 * x208 * x455,
            x14 * x214 * x445,
            x14 * x212 * x449,
            x14 * x210 * x455,
            x14 * x208 * x461,
            x10 * x218 * x445,
            x10 * x214 * x449,
            x10 * x212 * x455,
            x10 * x210 * x461,
            x206 * x397 * x465,
            x136 * x466 * x51,
            x189 * x36 * x466,
            x136 * x36 * x467,
            x139 * x16 * x466,
            x16 * x189 * x467,
            x136 * x16 * x469,
            x14 * x171 * x466,
            x139 * x14 * x467,
            x14 * x189 * x469,
            x136 * x14 * x470,
            x10 * x197 * x466,
            x10 * x171 * x467,
            x10 * x139 * x469,
            x110 * x397 * x470,
            x471 * x9,
            x163 * x473 * x474,
            x163 * x477 * x478,
            x188 * x473 * x478,
            x163 * x481 * x482,
            x188 * x477 * x482,
            x167 * x473 * x482,
            x163 * x487 * x488,
            x188 * x481 * x488,
            x167 * x477 * x488,
            x193 * x473 * x488,
            x163 * x492 * x493,
            x188 * x487 * x493,
            x167 * x481 * x493,
            x193 * x477 * x493,
            x205 * x473 * x493,
            x163 * x299 * x495,
            x163 * x307 * x497,
            x188 * x307 * x495,
            x163 * x316 * x499,
            x188 * x316 * x497,
            x167 * x316 * x495,
            x163 * x326 * x501,
            x188 * x326 * x499,
            x167 * x326 * x497,
            x193 * x326 * x495,
            x163 * x334 * x505,
            x188 * x334 * x501,
            x167 * x334 * x499,
            x193 * x334 * x497,
            x205 * x334 * x495,
            x221 * x299 * x473,
            x221 * x307 * x477,
            x223 * x307 * x473,
            x221 * x316 * x481,
            x223 * x316 * x477,
            x225 * x316 * x473,
            x221 * x326 * x487,
            x223 * x326 * x481,
            x225 * x326 * x477,
            x227 * x326 * x473,
            x221 * x334 * x492,
            x223 * x334 * x487,
            x225 * x334 * x481,
            x227 * x334 * x477,
            x231 * x334 * x473,
            x163 * x48 * x508,
            x114 * x163 * x511,
            x114 * x188 * x508,
            x144 * x163 * x515,
            x144 * x188 * x511,
            x144 * x167 * x508,
            x163 * x181 * x518,
            x181 * x188 * x515,
            x167 * x181 * x511,
            x181 * x193 * x508,
            x163 * x333 * x521,
            x188 * x333 * x518,
            x167 * x333 * x515,
            x193 * x333 * x511,
            x205 * x333 * x508,
            x221 * x48 * x495,
            x114 * x221 * x497,
            x114 * x223 * x495,
            x144 * x221 * x499,
            x144 * x223 * x497,
            x144 * x225 * x495,
            x181 * x221 * x501,
            x181 * x223 * x499,
            x181 * x225 * x497,
            x181 * x227 * x495,
            x221 * x333 * x505,
            x223 * x333 * x501,
            x225 * x333 * x499,
            x227 * x333 * x497,
            x231 * x333 * x495,
            x248 * x473 * x48,
            x114 * x248 * x477,
            x114 * x251 * x473,
            x144 * x248 * x481,
            x144 * x251 * x477,
            x144 * x255 * x473,
            x181 * x248 * x487,
            x181 * x251 * x481,
            x181 * x255 * x477,
            x181 * x258 * x473,
            x248 * x333 * x492,
            x251 * x333 * x487,
            x255 * x333 * x481,
            x258 * x333 * x477,
            x261 * x333 * x473,
            x163 * x46 * x522,
            x163 * x32 * x525,
            x188 * x32 * x522,
            x117 * x163 * x528,
            x117 * x188 * x525,
            x117 * x167 * x522,
            x163 * x179 * x532,
            x179 * x188 * x528,
            x167 * x179 * x525,
            x179 * x193 * x522,
            x23 * x534,
            x135 * x532 * x535,
            x167 * x172 * x528,
            x172 * x193 * x525,
            x172 * x205 * x522,
            x221 * x46 * x508,
            x221 * x32 * x511,
            x223 * x32 * x508,
            x117 * x221 * x515,
            x117 * x223 * x511,
            x117 * x225 * x508,
            x179 * x221 * x518,
            x179 * x223 * x515,
            x179 * x225 * x511,
            x179 * x227 * x508,
            x219 * x521 * x535,
            x172 * x223 * x518,
            x172 * x225 * x515,
            x172 * x227 * x511,
            x172 * x231 * x508,
            x248 * x46 * x495,
            x248 * x32 * x497,
            x251 * x32 * x495,
            x117 * x248 * x499,
            x117 * x251 * x497,
            x117 * x255 * x495,
            x179 * x248 * x501,
            x179 * x251 * x499,
            x179 * x255 * x497,
            x179 * x258 * x495,
            x172 * x248 * x505,
            x172 * x251 * x501,
            x172 * x255 * x499,
            x172 * x258 * x497,
            x172 * x261 * x495,
            x276 * x46 * x473,
            x276 * x32 * x477,
            x279 * x32 * x473,
            x117 * x276 * x481,
            x117 * x279 * x477,
            x117 * x282 * x473,
            x179 * x276 * x487,
            x179 * x279 * x481,
            x179 * x282 * x477,
            x179 * x286 * x473,
            x172 * x276 * x492,
            x172 * x279 * x487,
            x172 * x282 * x481,
            x172 * x286 * x477,
            x172 * x287 * x473,
            x163 * x44 * x536,
            x163 * x30 * x537,
            x188 * x30 * x536,
            x163 * x26 * x538,
            x188 * x26 * x537,
            x167 * x26 * x536,
            x3 * x539,
            x135 * x538 * x540,
            x167 * x537 * x8,
            x193 * x536 * x8,
            x393
            * (
                x0
                * (
                    2.0 * x385
                    + 2.0 * x386
                    + 3.0 * x519
                    + 3.0 * x520
                    + 4.0 * x530
                    + 4.0 * x531
                )
                + x206 * x533
            ),
            x135 * x539,
            x167 * x538 * x7,
            x193 * x537 * x7,
            x205 * x536 * x7,
            x221 * x44 * x522,
            x221 * x30 * x525,
            x223 * x30 * x522,
            x221 * x26 * x528,
            x223 * x26 * x525,
            x225 * x26 * x522,
            x219 * x532 * x540,
            x223 * x528 * x8,
            x225 * x525 * x8,
            x227 * x522 * x8,
            x219 * x534,
            x223 * x532 * x7,
            x225 * x528 * x7,
            x227 * x525 * x7,
            x231 * x522 * x7,
            x248 * x44 * x508,
            x248 * x30 * x511,
            x251 * x30 * x508,
            x248 * x26 * x515,
            x251 * x26 * x511,
            x255 * x26 * x508,
            x248 * x518 * x8,
            x251 * x515 * x8,
            x255 * x511 * x8,
            x258 * x508 * x8,
            x248 * x521 * x7,
            x251 * x518 * x7,
            x255 * x515 * x7,
            x258 * x511 * x7,
            x261 * x508 * x7,
            x276 * x44 * x495,
            x276 * x30 * x497,
            x279 * x30 * x495,
            x26 * x276 * x499,
            x26 * x279 * x497,
            x26 * x282 * x495,
            x276 * x501 * x8,
            x279 * x499 * x8,
            x282 * x497 * x8,
            x286 * x495 * x8,
            x276 * x505 * x7,
            x279 * x501 * x7,
            x282 * x499 * x7,
            x286 * x497 * x7,
            x287 * x495 * x7,
            x293 * x44 * x473,
            x293 * x30 * x477,
            x294 * x30 * x473,
            x26 * x293 * x481,
            x26 * x294 * x477,
            x26 * x295 * x473,
            x293 * x487 * x8,
            x294 * x481 * x8,
            x295 * x477 * x8,
            x296 * x473 * x8,
            x293 * x492 * x7,
            x294 * x487 * x7,
            x295 * x481 * x7,
            x296 * x477 * x7,
            x297 * x473 * x7,
            x298 * x399 * x474,
            x303 * x402 * x478,
            x310 * x401 * x478,
            x313 * x402 * x482,
            x303 * x401 * x482,
            x310 * x405 * x482,
            x322 * x402 * x488,
            x313 * x401 * x488,
            x303 * x405 * x488,
            x310 * x409 * x488,
            x332 * x402 * x493,
            x322 * x401 * x493,
            x313 * x405 * x493,
            x303 * x409 * x493,
            x310 * x413 * x493,
            x299 * x337 * x402,
            x307 * x339 * x402,
            x307 * x337 * x401,
            x316 * x341 * x402,
            x316 * x339 * x401,
            x316 * x337 * x405,
            x326 * x343 * x402,
            x326 * x341 * x401,
            x326 * x339 * x405,
            x326 * x337 * x409,
            x334 * x347 * x402,
            x334 * x343 * x401,
            x334 * x341 * x405,
            x334 * x339 * x409,
            x334 * x337 * x413,
            x299 * x310 * x415,
            x303 * x307 * x415,
            x307 * x310 * x417,
            x313 * x316 * x415,
            x303 * x316 * x417,
            x310 * x316 * x419,
            x322 * x326 * x415,
            x313 * x326 * x417,
            x303 * x326 * x419,
            x310 * x326 * x421,
            x332 * x334 * x415,
            x322 * x334 * x417,
            x313 * x334 * x419,
            x303 * x334 * x421,
            x310 * x334 * x425,
            x350 * x402 * x48,
            x114 * x353 * x402,
            x114 * x350 * x401,
            x144 * x357 * x402,
            x144 * x353 * x401,
            x144 * x350 * x405,
            x181 * x360 * x402,
            x181 * x357 * x401,
            x181 * x353 * x405,
            x181 * x350 * x409,
            x333 * x363 * x402,
            x333 * x360 * x401,
            x333 * x357 * x405,
            x333 * x353 * x409,
            x333 * x350 * x413,
            x337 * x415 * x48,
            x114 * x339 * x415,
            x114 * x337 * x417,
            x144 * x341 * x415,
            x144 * x339 * x417,
            x144 * x337 * x419,
            x181 * x343 * x415,
            x181 * x341 * x417,
            x181 * x339 * x419,
            x181 * x337 * x421,
            x333 * x347 * x415,
            x333 * x343 * x417,
            x333 * x341 * x419,
            x333 * x339 * x421,
            x333 * x337 * x425,
            x310 * x428 * x48,
            x114 * x303 * x428,
            x114 * x310 * x431,
            x144 * x313 * x428,
            x144 * x303 * x431,
            x144 * x310 * x435,
            x181 * x322 * x428,
            x181 * x313 * x431,
            x181 * x303 * x435,
            x181 * x310 * x438,
            x332 * x333 * x428,
            x322 * x333 * x431,
            x313 * x333 * x435,
            x303 * x333 * x438,
            x310 * x333 * x441,
            x367 * x402 * x46,
            x32 * x371 * x402,
            x32 * x367 * x401,
            x117 * x377 * x402,
            x117 * x371 * x401,
            x117 * x367 * x405,
            x179 * x383 * x402,
            x179 * x377 * x401,
            x179 * x371 * x405,
            x179 * x367 * x409,
            x387 * x398 * x535,
            x172 * x383 * x401,
            x172 * x377 * x405,
            x172 * x371 * x409,
            x172 * x367 * x413,
            x350 * x415 * x46,
            x32 * x353 * x415,
            x32 * x350 * x417,
            x117 * x357 * x415,
            x117 * x353 * x417,
            x117 * x350 * x419,
            x179 * x360 * x415,
            x179 * x357 * x417,
            x179 * x353 * x419,
            x179 * x350 * x421,
            x172 * x363 * x415,
            x172 * x360 * x417,
            x172 * x357 * x419,
            x172 * x353 * x421,
            x172 * x350 * x425,
            x337 * x428 * x46,
            x32 * x339 * x428,
            x32 * x337 * x431,
            x117 * x341 * x428,
            x117 * x339 * x431,
            x117 * x337 * x435,
            x179 * x343 * x428,
            x179 * x341 * x431,
            x179 * x339 * x435,
            x179 * x337 * x438,
            x172 * x347 * x428,
            x172 * x343 * x431,
            x172 * x341 * x435,
            x172 * x339 * x438,
            x172 * x337 * x441,
            x310 * x445 * x46,
            x303 * x32 * x445,
            x310 * x32 * x449,
            x117 * x313 * x445,
            x117 * x303 * x449,
            x117 * x310 * x455,
            x179 * x322 * x445,
            x179 * x313 * x449,
            x179 * x303 * x455,
            x179 * x310 * x461,
            x172 * x332 * x445,
            x172 * x322 * x449,
            x172 * x313 * x455,
            x172 * x303 * x461,
            x23 * x465 * x541,
            x388 * x402 * x44,
            x30 * x389 * x402,
            x30 * x388 * x401,
            x26 * x391 * x402,
            x26 * x389 * x401,
            x26 * x388 * x405,
            x392 * x398 * x540,
            x391 * x401 * x8,
            x389 * x405 * x8,
            x388 * x409 * x8,
            x394 * x398,
            x392 * x401 * x7,
            x391 * x405 * x7,
            x389 * x409 * x7,
            x388 * x413 * x7,
            x367 * x415 * x44,
            x30 * x371 * x415,
            x30 * x367 * x417,
            x26 * x377 * x415,
            x26 * x371 * x417,
            x26 * x367 * x419,
            x383 * x415 * x8,
            x377 * x417 * x8,
            x371 * x419 * x8,
            x367 * x421 * x8,
            x387 * x415 * x7,
            x383 * x417 * x7,
            x377 * x419 * x7,
            x371 * x421 * x7,
            x367 * x425 * x7,
            x350 * x428 * x44,
            x30 * x353 * x428,
            x30 * x350 * x431,
            x26 * x357 * x428,
            x26 * x353 * x431,
            x26 * x350 * x435,
            x360 * x428 * x8,
            x357 * x431 * x8,
            x353 * x435 * x8,
            x350 * x438 * x8,
            x363 * x428 * x7,
            x360 * x431 * x7,
            x357 * x435 * x7,
            x353 * x438 * x7,
            x350 * x441 * x7,
            x337 * x44 * x445,
            x30 * x339 * x445,
            x30 * x337 * x449,
            x26 * x341 * x445,
            x26 * x339 * x449,
            x26 * x337 * x455,
            x343 * x445 * x8,
            x341 * x449 * x8,
            x339 * x455 * x8,
            x337 * x461 * x8,
            x347 * x445 * x7,
            x343 * x449 * x7,
            x341 * x455 * x7,
            x339 * x461 * x7,
            x337 * x465 * x7,
            x310 * x44 * x466,
            x30 * x303 * x466,
            x30 * x310 * x467,
            x26 * x313 * x466,
            x26 * x303 * x467,
            x26 * x310 * x469,
            x322 * x466 * x8,
            x313 * x467 * x8,
            x303 * x469 * x8,
            x3 * x470 * x541,
            x332 * x466 * x7,
            x322 * x467 * x7,
            x313 * x469 * x7,
            x303 * x470 * x7,
            x298 * x471,
            x136 * x474 * x543,
            x189 * x478 * x543,
            x136 * x478 * x546,
            x139 * x482 * x543,
            x189 * x482 * x546,
            x136 * x482 * x549,
            x171 * x488 * x543,
            x139 * x488 * x546,
            x189 * x488 * x549,
            x136 * x488 * x554,
            x197 * x493 * x543,
            x171 * x493 * x546,
            x139 * x493 * x549,
            x189 * x493 * x554,
            x136 * x493 * x558,
            x208 * x299 * x543,
            x210 * x307 * x543,
            x208 * x307 * x546,
            x212 * x316 * x543,
            x210 * x316 * x546,
            x208 * x316 * x549,
            x214 * x326 * x543,
            x212 * x326 * x546,
            x210 * x326 * x549,
            x208 * x326 * x554,
            x218 * x334 * x543,
            x214 * x334 * x546,
            x212 * x334 * x549,
            x210 * x334 * x554,
            x208 * x334 * x558,
            x136 * x299 * x560,
            x189 * x307 * x560,
            x136 * x307 * x562,
            x139 * x316 * x560,
            x189 * x316 * x562,
            x136 * x316 * x564,
            x171 * x326 * x560,
            x139 * x326 * x562,
            x189 * x326 * x564,
            x136 * x326 * x566,
            x197 * x334 * x560,
            x171 * x334 * x562,
            x139 * x334 * x564,
            x189 * x334 * x566,
            x136 * x334 * x570,
            x233 * x48 * x543,
            x114 * x236 * x543,
            x114 * x233 * x546,
            x144 * x240 * x543,
            x144 * x236 * x546,
            x144 * x233 * x549,
            x181 * x243 * x543,
            x181 * x240 * x546,
            x181 * x236 * x549,
            x181 * x233 * x554,
            x246 * x333 * x543,
            x243 * x333 * x546,
            x240 * x333 * x549,
            x236 * x333 * x554,
            x233 * x333 * x558,
            x208 * x48 * x560,
            x114 * x210 * x560,
            x114 * x208 * x562,
            x144 * x212 * x560,
            x144 * x210 * x562,
            x144 * x208 * x564,
            x181 * x214 * x560,
            x181 * x212 * x562,
            x181 * x210 * x564,
            x181 * x208 * x566,
            x218 * x333 * x560,
            x214 * x333 * x562,
            x212 * x333 * x564,
            x210 * x333 * x566,
            x208 * x333 * x570,
            x136 * x48 * x573,
            x114 * x189 * x573,
            x114 * x136 * x576,
            x139 * x144 * x573,
            x144 * x189 * x576,
            x136 * x144 * x580,
            x171 * x181 * x573,
            x139 * x181 * x576,
            x181 * x189 * x580,
            x136 * x181 * x583,
            x197 * x333 * x573,
            x171 * x333 * x576,
            x139 * x333 * x580,
            x189 * x333 * x583,
            x136 * x333 * x586,
            x263 * x46 * x543,
            x266 * x32 * x543,
            x263 * x32 * x546,
            x117 * x269 * x543,
            x117 * x266 * x546,
            x117 * x263 * x549,
            x179 * x273 * x543,
            x179 * x269 * x546,
            x179 * x266 * x549,
            x179 * x263 * x554,
            x172 * x274 * x543,
            x172 * x273 * x546,
            x172 * x269 * x549,
            x172 * x266 * x554,
            x172 * x263 * x558,
            x233 * x46 * x560,
            x236 * x32 * x560,
            x233 * x32 * x562,
            x117 * x240 * x560,
            x117 * x236 * x562,
            x117 * x233 * x564,
            x179 * x243 * x560,
            x179 * x240 * x562,
            x179 * x236 * x564,
            x179 * x233 * x566,
            x172 * x246 * x560,
            x172 * x243 * x562,
            x172 * x240 * x564,
            x172 * x236 * x566,
            x172 * x233 * x570,
            x208 * x46 * x573,
            x210 * x32 * x573,
            x208 * x32 * x576,
            x117 * x212 * x573,
            x117 * x210 * x576,
            x117 * x208 * x580,
            x179 * x214 * x573,
            x179 * x212 * x576,
            x179 * x210 * x580,
            x179 * x208 * x583,
            x172 * x218 * x573,
            x172 * x214 * x576,
            x172 * x212 * x580,
            x172 * x210 * x583,
            x206 * x586 * x587,
            x136 * x46 * x588,
            x189 * x32 * x588,
            x136 * x32 * x591,
            x117 * x139 * x588,
            x117 * x189 * x591,
            x117 * x136 * x594,
            x171 * x179 * x588,
            x139 * x179 * x591,
            x179 * x189 * x594,
            x136 * x179 * x598,
            x172 * x197 * x588,
            x171 * x172 * x591,
            x139 * x172 * x594,
            x110 * x587 * x598,
            x23 * x600,
            x288 * x44 * x543,
            x289 * x30 * x543,
            x288 * x30 * x546,
            x26 * x290 * x543,
            x26 * x289 * x546,
            x26 * x288 * x549,
            x291 * x543 * x8,
            x290 * x546 * x8,
            x289 * x549 * x8,
            x288 * x554 * x8,
            x292 * x543 * x7,
            x291 * x546 * x7,
            x290 * x549 * x7,
            x289 * x554 * x7,
            x288 * x558 * x7,
            x263 * x44 * x560,
            x266 * x30 * x560,
            x263 * x30 * x562,
            x26 * x269 * x560,
            x26 * x266 * x562,
            x26 * x263 * x564,
            x273 * x560 * x8,
            x269 * x562 * x8,
            x266 * x564 * x8,
            x263 * x566 * x8,
            x274 * x560 * x7,
            x273 * x562 * x7,
            x269 * x564 * x7,
            x266 * x566 * x7,
            x263 * x570 * x7,
            x233 * x44 * x573,
            x236 * x30 * x573,
            x233 * x30 * x576,
            x240 * x26 * x573,
            x236 * x26 * x576,
            x233 * x26 * x580,
            x243 * x573 * x8,
            x240 * x576 * x8,
            x236 * x580 * x8,
            x233 * x583 * x8,
            x246 * x573 * x7,
            x243 * x576 * x7,
            x240 * x580 * x7,
            x236 * x583 * x7,
            x233 * x586 * x7,
            x208 * x44 * x588,
            x210 * x30 * x588,
            x208 * x30 * x591,
            x212 * x26 * x588,
            x210 * x26 * x591,
            x208 * x26 * x594,
            x214 * x588 * x8,
            x212 * x591 * x8,
            x210 * x594 * x8,
            x206 * x598 * x601,
            x218 * x588 * x7,
            x214 * x591 * x7,
            x212 * x594 * x7,
            x210 * x598 * x7,
            x206 * x600,
            x136 * x44 * x602,
            x189 * x30 * x602,
            x136 * x30 * x603,
            x139 * x26 * x602,
            x189 * x26 * x603,
            x136 * x26 * x604,
            x171 * x602 * x8,
            x139 * x603 * x8,
            x110 * x601 * x604,
            x3 * x605,
            x197 * x602 * x7,
            x171 * x603 * x7,
            x139 * x604 * x7,
            x110 * x605,
            x396
            * (
                x0
                * (
                    2.0 * x463
                    + 2.0 * x464
                    + 3.0 * x584
                    + 3.0 * x585
                    + 4.0 * x596
                    + 4.0 * x597
                )
                + x219 * x599
            ),
        ]
    )
