import { Construct } from "constructs";
import { IVersionedStackManagerProps } from "./types";
/**
 * This construct will create a custom resource that will manage the versioned stacks,
 * and if too many stacks are present, it will delete the oldest.
 *
 * This prevents inadvertent AWS Limit errors, and keeps your account clean.
 *
 * @param props IVersionedStackManagerProps
 */
export declare class VersionedStackManager extends Construct {
    private readonly id;
    private readonly props;
    private readonly provider;
    constructor(scope: Construct, id: string, props: IVersionedStackManagerProps);
    private validateProps;
    private createProductionPromoterProvider;
    private createResource;
}
export * from "./types";
